/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import util.GCanvas;
import util.LabelData;
import util.PlotData;
import util.SectionData;

public class DrawPreview
extends JFrame {
    public DrawPreview(String plotfilename, String plotfile) {
        super(plotfilename);
        try {
            PlotData curplot = this.ReadPlotFile(plotfile);
            if (curplot != null) {
                this.setBounds(200, 200, curplot.m_plotwidth, curplot.m_plotheight);
                this.setDefaultCloseOperation(2);
                Container con = this.getContentPane();
                con.setBackground(Color.white);
                GCanvas canvas = new GCanvas(curplot);
                Color bkgrnd = new Color(204, 255, 255);
                canvas.setBackground(bkgrnd);
                con.add(canvas);
                this.setVisible(true);
            }
        }
        catch (FileNotFoundException e) {
            String msg = "Plot file: ";
            msg = String.valueOf(msg) + plotfilename;
            msg = String.valueOf(msg) + " does not exist.";
            JOptionPane.showMessageDialog(null, msg, "Error", 0);
        }
    }

    public PlotData ReadPlotFile(String plotfilename) throws FileNotFoundException {
        PlotData curplot = new PlotData();
        SectionData cursec = new SectionData();
        cursec.strokewidth = -1.0;
        Scanner scanfile = new Scanner(new File(plotfilename));
        boolean pagefound = false;
        while (scanfile.hasNextLine()) {
            int index;
            String curline = scanfile.nextLine();
            Scanner scanline = new Scanner(curline);
            scanline.useDelimiter(" ");
            if (!scanline.hasNext()) continue;
            if (pagefound) {
                Double ybeg;
                Double xbeg;
                if (curline.contains(" l")) {
                    index = 0;
                    xbeg = 0.0;
                    ybeg = 0.0;
                    Double xend = 0.0;
                    Double yend = 0.0;
                    while (scanline.hasNext()) {
                        if (scanline.hasNextDouble()) {
                            switch (index) {
                                case 0: {
                                    xbeg = scanline.nextDouble();
                                    break;
                                }
                                case 1: {
                                    ybeg = scanline.nextDouble();
                                    break;
                                }
                                case 2: {
                                    xend = scanline.nextDouble();
                                    break;
                                }
                                case 3: {
                                    yend = scanline.nextDouble();
                                }
                            }
                            ++index;
                            continue;
                        }
                        scanline.next();
                    }
                    ybeg = (double)curplot.m_plotheight - ybeg;
                    yend = (double)curplot.m_plotheight - yend;
                    Line2D.Double cur2d = new Line2D.Double(xbeg, ybeg, xend, yend);
                    cursec.lines.add(cur2d);
                } else if (curline.contains(" moveto")) {
                    int index2 = 0;
                    xbeg = 0.0;
                    ybeg = 0.0;
                    Double xoff1 = 0.0;
                    Double yoff1 = 0.0;
                    Double xoff2 = 0.0;
                    Double yoff2 = 0.0;
                    Double xend = 0.0;
                    Double yend = 0.0;
                    while (scanline.hasNext()) {
                        if (scanline.hasNextDouble()) {
                            switch (index2) {
                                case 0: {
                                    xbeg = scanline.nextDouble();
                                    break;
                                }
                                case 1: {
                                    ybeg = scanline.nextDouble();
                                }
                            }
                            ++index2;
                            continue;
                        }
                        scanline.next();
                    }
                    curline = scanfile.nextLine();
                    scanline = new Scanner(curline);
                    index2 = 0;
                    while (scanline.hasNext()) {
                        if (scanline.hasNextDouble()) {
                            switch (index2) {
                                case 0: {
                                    xoff1 = scanline.nextDouble();
                                    break;
                                }
                                case 1: {
                                    yoff1 = scanline.nextDouble();
                                    break;
                                }
                                case 2: {
                                    xoff2 = scanline.nextDouble();
                                    break;
                                }
                                case 3: {
                                    yoff2 = scanline.nextDouble();
                                    break;
                                }
                                case 4: {
                                    xend = scanline.nextDouble();
                                    break;
                                }
                                case 5: {
                                    yend = scanline.nextDouble();
                                }
                            }
                            ++index2;
                            continue;
                        }
                        scanline.next();
                    }
                    ybeg = (double)curplot.m_plotheight - ybeg;
                    yoff1 = (double)curplot.m_plotheight - yoff1;
                    yoff2 = (double)curplot.m_plotheight - yoff2;
                    yend = (double)curplot.m_plotheight - yend;
                    CubicCurve2D.Double cube2d = new CubicCurve2D.Double(xbeg, ybeg, xoff1, yoff1, xoff2, yoff2, xend, yend);
                    cursec.curves.add(cube2d);
                }
            }
            if (curline.contains("DocumentMedia:")) {
                index = 0;
                while (scanline.hasNext()) {
                    if (scanline.hasNextInt()) {
                        if (index == 0) {
                            curplot.m_plotwidth = scanline.nextInt();
                        } else if (index == 1) {
                            curplot.m_plotheight = scanline.nextInt();
                        } else {
                            scanline.next();
                        }
                        ++index;
                        continue;
                    }
                    scanline.next();
                }
                continue;
            }
            if (curline.contains("setlinewidth")) {
                if (cursec.strokewidth > 0.0) {
                    curplot.m_treePart.add(cursec);
                }
                cursec = new SectionData();
                while (scanline.hasNext()) {
                    if (scanline.hasNextDouble()) {
                        cursec.strokewidth = scanline.nextDouble();
                        continue;
                    }
                    scanline.next();
                }
                continue;
            }
            if (curline.contains("Page:")) {
                pagefound = true;
                continue;
            }
            if (!curline.contains("findfont")) continue;
            Point2D.Double translation = new Point2D.Double(0.0, 0.0);
            Double rotation = 0.0;
            String displayText = new String("");
            String fontstring = scanline.next().replace('/', ' ');
            fontstring = fontstring.trim();
            String[] fontparts = fontstring.split("-");
            int fontsize = 0;
            while (scanline.hasNext()) {
                if (scanline.hasNextDouble()) {
                    fontsize = (int)scanline.nextDouble();
                    continue;
                }
                scanline.next();
            }
            String fontkind = fontparts.length == 1 ? "book" : (fontparts.length == 3 ? fontparts[2].toLowerCase() : fontparts[1].toLowerCase());
            Font useFont = fontkind.contains("roman") || fontkind.contains("book") || fontkind.contains("narrow") || fontkind.contains("light") ? new Font(fontparts[0], 0, fontsize) : (fontkind.contains("bolditalic") || fontkind.contains("boldoblique") || fontkind.contains("demioblique") || fontkind.contains("demiitalic") ? new Font(fontparts[0], 3, fontsize) : (fontkind.contains("bold") || fontkind.contains("demi") ? new Font(fontparts[0], 1, fontsize) : (fontkind.contains("italic") || fontkind.contains("oblique") || fontkind.contains("bookoblique") || fontkind.contains("lightitalic") || fontkind.contains("mediumitalic") ? new Font(fontparts[0], 2, fontsize) : new Font("SanSerif", 0, fontsize))));
            curline = scanfile.nextLine();
            scanline = new Scanner(curline);
            boolean xfound = false;
            boolean yfound = false;
            while (scanline.hasNext()) {
                if (scanline.hasNextDouble()) {
                    if (!xfound) {
                        translation.x = scanline.nextDouble();
                        xfound = true;
                        continue;
                    }
                    if (!yfound) {
                        translation.y = scanline.nextDouble();
                        translation.y = (double)curplot.m_plotheight - translation.y;
                        yfound = true;
                        continue;
                    }
                    rotation = -scanline.nextDouble();
                    continue;
                }
                scanline.next();
            }
            curline = scanfile.nextLine();
            scanline = new Scanner(curline);
            curline = scanfile.nextLine();
            if (curline.contains("(")) {
                displayText = curline.substring(curline.indexOf(40) + 1, curline.lastIndexOf(41));
            }
            LabelData newlabel = new LabelData(useFont, translation, rotation, displayText);
            cursec.texts.add(newlabel);
        }
        if (cursec.strokewidth > 0.0) {
            curplot.m_treePart.add(cursec);
        }
        return curplot;
    }
}

