// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: pkg/kascfg/kascfg.proto

package kascfg

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// Validate checks the field values on ListenAgentCF with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *ListenAgentCF) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for Network

	// no validation rules for Address

	// no validation rules for Websocket

	// no validation rules for CertificateFile

	// no validation rules for KeyFile

	// no validation rules for ConnectionsPerTokenPerMinute

	if d := m.GetMaxConnectionAge(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			return ListenAgentCFValidationError{
				field:  "MaxConnectionAge",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return ListenAgentCFValidationError{
				field:  "MaxConnectionAge",
				reason: "value must be greater than 0s",
			}
		}

	}

	return nil
}

// ListenAgentCFValidationError is the validation error returned by
// ListenAgentCF.Validate if the designated constraints aren't met.
type ListenAgentCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListenAgentCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListenAgentCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListenAgentCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListenAgentCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListenAgentCFValidationError) ErrorName() string { return "ListenAgentCFValidationError" }

// Error satisfies the builtin error interface
func (e ListenAgentCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListenAgentCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListenAgentCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListenAgentCFValidationError{}

// Validate checks the field values on PrometheusCF with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *PrometheusCF) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for UrlPath

	return nil
}

// PrometheusCFValidationError is the validation error returned by
// PrometheusCF.Validate if the designated constraints aren't met.
type PrometheusCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PrometheusCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PrometheusCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PrometheusCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PrometheusCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PrometheusCFValidationError) ErrorName() string { return "PrometheusCFValidationError" }

// Error satisfies the builtin error interface
func (e PrometheusCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPrometheusCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PrometheusCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PrometheusCFValidationError{}

// Validate checks the field values on ObservabilityListenCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ObservabilityListenCF) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for Network

	// no validation rules for Address

	return nil
}

// ObservabilityListenCFValidationError is the validation error returned by
// ObservabilityListenCF.Validate if the designated constraints aren't met.
type ObservabilityListenCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ObservabilityListenCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ObservabilityListenCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ObservabilityListenCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ObservabilityListenCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ObservabilityListenCFValidationError) ErrorName() string {
	return "ObservabilityListenCFValidationError"
}

// Error satisfies the builtin error interface
func (e ObservabilityListenCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sObservabilityListenCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ObservabilityListenCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ObservabilityListenCFValidationError{}

// Validate checks the field values on TracingCF with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *TracingCF) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for ConnectionString

	return nil
}

// TracingCFValidationError is the validation error returned by
// TracingCF.Validate if the designated constraints aren't met.
type TracingCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TracingCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TracingCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TracingCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TracingCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TracingCFValidationError) ErrorName() string { return "TracingCFValidationError" }

// Error satisfies the builtin error interface
func (e TracingCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTracingCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TracingCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TracingCFValidationError{}

// Validate checks the field values on LoggingCF with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *LoggingCF) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for Level

	return nil
}

// LoggingCFValidationError is the validation error returned by
// LoggingCF.Validate if the designated constraints aren't met.
type LoggingCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LoggingCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LoggingCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LoggingCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LoggingCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LoggingCFValidationError) ErrorName() string { return "LoggingCFValidationError" }

// Error satisfies the builtin error interface
func (e LoggingCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLoggingCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LoggingCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LoggingCFValidationError{}

// Validate checks the field values on GitLabCF with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *GitLabCF) Validate() error {
	if m == nil {
		return nil
	}

	if utf8.RuneCountInString(m.GetAddress()) < 1 {
		return GitLabCFValidationError{
			field:  "Address",
			reason: "value length must be at least 1 runes",
		}
	}

	if uri, err := url.Parse(m.GetAddress()); err != nil {
		return GitLabCFValidationError{
			field:  "Address",
			reason: "value must be a valid URI",
			cause:  err,
		}
	} else if !uri.IsAbs() {
		return GitLabCFValidationError{
			field:  "Address",
			reason: "value must be absolute",
		}
	}

	if utf8.RuneCountInString(m.GetAuthenticationSecretFile()) < 1 {
		return GitLabCFValidationError{
			field:  "AuthenticationSecretFile",
			reason: "value length must be at least 1 runes",
		}
	}

	// no validation rules for CaCertificateFile

	if v, ok := interface{}(m.GetApiRateLimit()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GitLabCFValidationError{
				field:  "ApiRateLimit",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// GitLabCFValidationError is the validation error returned by
// GitLabCF.Validate if the designated constraints aren't met.
type GitLabCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GitLabCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GitLabCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GitLabCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GitLabCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GitLabCFValidationError) ErrorName() string { return "GitLabCFValidationError" }

// Error satisfies the builtin error interface
func (e GitLabCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGitLabCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GitLabCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GitLabCFValidationError{}

// Validate checks the field values on GitopsCF with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *GitopsCF) Validate() error {
	if m == nil {
		return nil
	}

	if d := m.GetPollPeriod(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			return GitopsCFValidationError{
				field:  "PollPeriod",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return GitopsCFValidationError{
				field:  "PollPeriod",
				reason: "value must be greater than 0s",
			}
		}

	}

	if d := m.GetProjectInfoCacheTtl(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			return GitopsCFValidationError{
				field:  "ProjectInfoCacheTtl",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		gte := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur < gte {
			return GitopsCFValidationError{
				field:  "ProjectInfoCacheTtl",
				reason: "value must be greater than or equal to 0s",
			}
		}

	}

	if d := m.GetProjectInfoCacheErrorTtl(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			return GitopsCFValidationError{
				field:  "ProjectInfoCacheErrorTtl",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return GitopsCFValidationError{
				field:  "ProjectInfoCacheErrorTtl",
				reason: "value must be greater than 0s",
			}
		}

	}

	// no validation rules for MaxManifestFileSize

	// no validation rules for MaxTotalManifestFileSize

	// no validation rules for MaxNumberOfPaths

	// no validation rules for MaxNumberOfFiles

	return nil
}

// GitopsCFValidationError is the validation error returned by
// GitopsCF.Validate if the designated constraints aren't met.
type GitopsCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GitopsCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GitopsCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GitopsCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GitopsCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GitopsCFValidationError) ErrorName() string { return "GitopsCFValidationError" }

// Error satisfies the builtin error interface
func (e GitopsCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGitopsCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GitopsCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GitopsCFValidationError{}

// Validate checks the field values on SentryCF with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *SentryCF) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for Dsn

	// no validation rules for Environment

	return nil
}

// SentryCFValidationError is the validation error returned by
// SentryCF.Validate if the designated constraints aren't met.
type SentryCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SentryCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SentryCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SentryCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SentryCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SentryCFValidationError) ErrorName() string { return "SentryCFValidationError" }

// Error satisfies the builtin error interface
func (e SentryCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSentryCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SentryCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SentryCFValidationError{}

// Validate checks the field values on ListenKubernetesApiCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ListenKubernetesApiCF) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for Network

	// no validation rules for Address

	// no validation rules for CertificateFile

	// no validation rules for KeyFile

	return nil
}

// ListenKubernetesApiCFValidationError is the validation error returned by
// ListenKubernetesApiCF.Validate if the designated constraints aren't met.
type ListenKubernetesApiCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListenKubernetesApiCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListenKubernetesApiCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListenKubernetesApiCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListenKubernetesApiCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListenKubernetesApiCFValidationError) ErrorName() string {
	return "ListenKubernetesApiCFValidationError"
}

// Error satisfies the builtin error interface
func (e ListenKubernetesApiCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListenKubernetesApiCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListenKubernetesApiCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListenKubernetesApiCFValidationError{}

// Validate checks the field values on KubernetesApiCF with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *KubernetesApiCF) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetListen()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return KubernetesApiCFValidationError{
				field:  "Listen",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for UrlPathPrefix

	return nil
}

// KubernetesApiCFValidationError is the validation error returned by
// KubernetesApiCF.Validate if the designated constraints aren't met.
type KubernetesApiCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e KubernetesApiCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e KubernetesApiCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e KubernetesApiCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e KubernetesApiCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e KubernetesApiCFValidationError) ErrorName() string { return "KubernetesApiCFValidationError" }

// Error satisfies the builtin error interface
func (e KubernetesApiCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sKubernetesApiCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = KubernetesApiCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = KubernetesApiCFValidationError{}

// Validate checks the field values on AgentCF with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *AgentCF) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetListen()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentCFValidationError{
				field:  "Listen",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetConfiguration()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentCFValidationError{
				field:  "Configuration",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetGitops()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentCFValidationError{
				field:  "Gitops",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if d := m.GetInfoCacheTtl(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			return AgentCFValidationError{
				field:  "InfoCacheTtl",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		gte := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur < gte {
			return AgentCFValidationError{
				field:  "InfoCacheTtl",
				reason: "value must be greater than or equal to 0s",
			}
		}

	}

	if d := m.GetInfoCacheErrorTtl(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			return AgentCFValidationError{
				field:  "InfoCacheErrorTtl",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return AgentCFValidationError{
				field:  "InfoCacheErrorTtl",
				reason: "value must be greater than 0s",
			}
		}

	}

	if v, ok := interface{}(m.GetRedisConnInfoTtl()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentCFValidationError{
				field:  "RedisConnInfoTtl",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetRedisConnInfoRefresh()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentCFValidationError{
				field:  "RedisConnInfoRefresh",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetRedisConnInfoGc()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentCFValidationError{
				field:  "RedisConnInfoGc",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetKubernetesApi()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentCFValidationError{
				field:  "KubernetesApi",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// AgentCFValidationError is the validation error returned by AgentCF.Validate
// if the designated constraints aren't met.
type AgentCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AgentCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AgentCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AgentCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AgentCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AgentCFValidationError) ErrorName() string { return "AgentCFValidationError" }

// Error satisfies the builtin error interface
func (e AgentCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAgentCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AgentCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AgentCFValidationError{}

// Validate checks the field values on AgentConfigurationCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *AgentConfigurationCF) Validate() error {
	if m == nil {
		return nil
	}

	if d := m.GetPollPeriod(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			return AgentConfigurationCFValidationError{
				field:  "PollPeriod",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return AgentConfigurationCFValidationError{
				field:  "PollPeriod",
				reason: "value must be greater than 0s",
			}
		}

	}

	// no validation rules for MaxConfigurationFileSize

	return nil
}

// AgentConfigurationCFValidationError is the validation error returned by
// AgentConfigurationCF.Validate if the designated constraints aren't met.
type AgentConfigurationCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AgentConfigurationCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AgentConfigurationCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AgentConfigurationCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AgentConfigurationCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AgentConfigurationCFValidationError) ErrorName() string {
	return "AgentConfigurationCFValidationError"
}

// Error satisfies the builtin error interface
func (e AgentConfigurationCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAgentConfigurationCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AgentConfigurationCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AgentConfigurationCFValidationError{}

// Validate checks the field values on GoogleProfilerCF with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *GoogleProfilerCF) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for Enabled

	// no validation rules for ProjectId

	// no validation rules for CredentialsFile

	return nil
}

// GoogleProfilerCFValidationError is the validation error returned by
// GoogleProfilerCF.Validate if the designated constraints aren't met.
type GoogleProfilerCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GoogleProfilerCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GoogleProfilerCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GoogleProfilerCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GoogleProfilerCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GoogleProfilerCFValidationError) ErrorName() string { return "GoogleProfilerCFValidationError" }

// Error satisfies the builtin error interface
func (e GoogleProfilerCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGoogleProfilerCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GoogleProfilerCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GoogleProfilerCFValidationError{}

// Validate checks the field values on LivenessProbeCF with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *LivenessProbeCF) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for UrlPath

	return nil
}

// LivenessProbeCFValidationError is the validation error returned by
// LivenessProbeCF.Validate if the designated constraints aren't met.
type LivenessProbeCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LivenessProbeCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LivenessProbeCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LivenessProbeCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LivenessProbeCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LivenessProbeCFValidationError) ErrorName() string { return "LivenessProbeCFValidationError" }

// Error satisfies the builtin error interface
func (e LivenessProbeCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLivenessProbeCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LivenessProbeCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LivenessProbeCFValidationError{}

// Validate checks the field values on ReadinessProbeCF with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *ReadinessProbeCF) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for UrlPath

	return nil
}

// ReadinessProbeCFValidationError is the validation error returned by
// ReadinessProbeCF.Validate if the designated constraints aren't met.
type ReadinessProbeCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ReadinessProbeCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ReadinessProbeCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ReadinessProbeCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ReadinessProbeCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ReadinessProbeCFValidationError) ErrorName() string { return "ReadinessProbeCFValidationError" }

// Error satisfies the builtin error interface
func (e ReadinessProbeCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sReadinessProbeCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ReadinessProbeCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ReadinessProbeCFValidationError{}

// Validate checks the field values on ObservabilityCF with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *ObservabilityCF) Validate() error {
	if m == nil {
		return nil
	}

	if d := m.GetUsageReportingPeriod(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			return ObservabilityCFValidationError{
				field:  "UsageReportingPeriod",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		gte := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur < gte {
			return ObservabilityCFValidationError{
				field:  "UsageReportingPeriod",
				reason: "value must be greater than or equal to 0s",
			}
		}

	}

	if v, ok := interface{}(m.GetListen()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObservabilityCFValidationError{
				field:  "Listen",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetPrometheus()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObservabilityCFValidationError{
				field:  "Prometheus",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetTracing()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObservabilityCFValidationError{
				field:  "Tracing",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetSentry()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObservabilityCFValidationError{
				field:  "Sentry",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetLogging()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObservabilityCFValidationError{
				field:  "Logging",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetGoogleProfiler()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObservabilityCFValidationError{
				field:  "GoogleProfiler",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetLivenessProbe()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObservabilityCFValidationError{
				field:  "LivenessProbe",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetReadinessProbe()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObservabilityCFValidationError{
				field:  "ReadinessProbe",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// ObservabilityCFValidationError is the validation error returned by
// ObservabilityCF.Validate if the designated constraints aren't met.
type ObservabilityCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ObservabilityCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ObservabilityCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ObservabilityCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ObservabilityCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ObservabilityCFValidationError) ErrorName() string { return "ObservabilityCFValidationError" }

// Error satisfies the builtin error interface
func (e ObservabilityCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sObservabilityCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ObservabilityCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ObservabilityCFValidationError{}

// Validate checks the field values on TokenBucketRateLimitCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *TokenBucketRateLimitCF) Validate() error {
	if m == nil {
		return nil
	}

	if m.GetRefillRatePerSecond() < 0 {
		return TokenBucketRateLimitCFValidationError{
			field:  "RefillRatePerSecond",
			reason: "value must be greater than or equal to 0",
		}
	}

	// no validation rules for BucketSize

	return nil
}

// TokenBucketRateLimitCFValidationError is the validation error returned by
// TokenBucketRateLimitCF.Validate if the designated constraints aren't met.
type TokenBucketRateLimitCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TokenBucketRateLimitCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TokenBucketRateLimitCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TokenBucketRateLimitCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TokenBucketRateLimitCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TokenBucketRateLimitCFValidationError) ErrorName() string {
	return "TokenBucketRateLimitCFValidationError"
}

// Error satisfies the builtin error interface
func (e TokenBucketRateLimitCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTokenBucketRateLimitCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TokenBucketRateLimitCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TokenBucketRateLimitCFValidationError{}

// Validate checks the field values on GitalyCF with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *GitalyCF) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetGlobalApiRateLimit()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GitalyCFValidationError{
				field:  "GlobalApiRateLimit",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetPerServerApiRateLimit()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GitalyCFValidationError{
				field:  "PerServerApiRateLimit",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// GitalyCFValidationError is the validation error returned by
// GitalyCF.Validate if the designated constraints aren't met.
type GitalyCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GitalyCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GitalyCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GitalyCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GitalyCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GitalyCFValidationError) ErrorName() string { return "GitalyCFValidationError" }

// Error satisfies the builtin error interface
func (e GitalyCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGitalyCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GitalyCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GitalyCFValidationError{}

// Validate checks the field values on RedisCF with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *RedisCF) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for PoolSize

	if d := m.GetDialTimeout(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			return RedisCFValidationError{
				field:  "DialTimeout",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return RedisCFValidationError{
				field:  "DialTimeout",
				reason: "value must be greater than 0s",
			}
		}

	}

	if d := m.GetReadTimeout(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			return RedisCFValidationError{
				field:  "ReadTimeout",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return RedisCFValidationError{
				field:  "ReadTimeout",
				reason: "value must be greater than 0s",
			}
		}

	}

	if d := m.GetWriteTimeout(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			return RedisCFValidationError{
				field:  "WriteTimeout",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return RedisCFValidationError{
				field:  "WriteTimeout",
				reason: "value must be greater than 0s",
			}
		}

	}

	if d := m.GetIdleTimeout(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			return RedisCFValidationError{
				field:  "IdleTimeout",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return RedisCFValidationError{
				field:  "IdleTimeout",
				reason: "value must be greater than 0s",
			}
		}

	}

	// no validation rules for KeyPrefix

	// no validation rules for Username

	// no validation rules for PasswordFile

	if _, ok := _RedisCF_Network_InLookup[m.GetNetwork()]; !ok {
		return RedisCFValidationError{
			field:  "Network",
			reason: "value must be in list [ tcp unix]",
		}
	}

	if v, ok := interface{}(m.GetTls()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisCFValidationError{
				field:  "Tls",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	switch m.RedisConfig.(type) {

	case *RedisCF_Server:

		if v, ok := interface{}(m.GetServer()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RedisCFValidationError{
					field:  "Server",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RedisCF_Sentinel:

		if v, ok := interface{}(m.GetSentinel()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RedisCFValidationError{
					field:  "Sentinel",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		return RedisCFValidationError{
			field:  "RedisConfig",
			reason: "value is required",
		}

	}

	return nil
}

// RedisCFValidationError is the validation error returned by RedisCF.Validate
// if the designated constraints aren't met.
type RedisCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedisCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedisCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedisCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisCFValidationError) ErrorName() string { return "RedisCFValidationError" }

// Error satisfies the builtin error interface
func (e RedisCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisCFValidationError{}

var _RedisCF_Network_InLookup = map[string]struct{}{
	"":     {},
	"tcp":  {},
	"unix": {},
}

// Validate checks the field values on RedisTLSCF with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *RedisTLSCF) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for Enabled

	// no validation rules for CertificateFile

	// no validation rules for KeyFile

	// no validation rules for CaCertificateFile

	return nil
}

// RedisTLSCFValidationError is the validation error returned by
// RedisTLSCF.Validate if the designated constraints aren't met.
type RedisTLSCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisTLSCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedisTLSCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedisTLSCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedisTLSCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisTLSCFValidationError) ErrorName() string { return "RedisTLSCFValidationError" }

// Error satisfies the builtin error interface
func (e RedisTLSCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisTLSCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisTLSCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisTLSCFValidationError{}

// Validate checks the field values on RedisServerCF with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *RedisServerCF) Validate() error {
	if m == nil {
		return nil
	}

	if utf8.RuneCountInString(m.GetAddress()) < 1 {
		return RedisServerCFValidationError{
			field:  "Address",
			reason: "value length must be at least 1 runes",
		}
	}

	return nil
}

// RedisServerCFValidationError is the validation error returned by
// RedisServerCF.Validate if the designated constraints aren't met.
type RedisServerCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisServerCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedisServerCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedisServerCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedisServerCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisServerCFValidationError) ErrorName() string { return "RedisServerCFValidationError" }

// Error satisfies the builtin error interface
func (e RedisServerCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisServerCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisServerCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisServerCFValidationError{}

// Validate checks the field values on RedisSentinelCF with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *RedisSentinelCF) Validate() error {
	if m == nil {
		return nil
	}

	if utf8.RuneCountInString(m.GetMasterName()) < 1 {
		return RedisSentinelCFValidationError{
			field:  "MasterName",
			reason: "value length must be at least 1 runes",
		}
	}

	if len(m.GetAddresses()) < 1 {
		return RedisSentinelCFValidationError{
			field:  "Addresses",
			reason: "value must contain at least 1 item(s)",
		}
	}

	// no validation rules for SentinelPasswordFile

	return nil
}

// RedisSentinelCFValidationError is the validation error returned by
// RedisSentinelCF.Validate if the designated constraints aren't met.
type RedisSentinelCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisSentinelCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedisSentinelCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedisSentinelCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedisSentinelCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisSentinelCFValidationError) ErrorName() string { return "RedisSentinelCFValidationError" }

// Error satisfies the builtin error interface
func (e RedisSentinelCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisSentinelCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisSentinelCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisSentinelCFValidationError{}

// Validate checks the field values on ListenApiCF with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *ListenApiCF) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for Network

	// no validation rules for Address

	if utf8.RuneCountInString(m.GetAuthenticationSecretFile()) < 1 {
		return ListenApiCFValidationError{
			field:  "AuthenticationSecretFile",
			reason: "value length must be at least 1 runes",
		}
	}

	// no validation rules for CertificateFile

	// no validation rules for KeyFile

	if d := m.GetMaxConnectionAge(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			return ListenApiCFValidationError{
				field:  "MaxConnectionAge",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return ListenApiCFValidationError{
				field:  "MaxConnectionAge",
				reason: "value must be greater than 0s",
			}
		}

	}

	return nil
}

// ListenApiCFValidationError is the validation error returned by
// ListenApiCF.Validate if the designated constraints aren't met.
type ListenApiCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListenApiCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListenApiCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListenApiCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListenApiCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListenApiCFValidationError) ErrorName() string { return "ListenApiCFValidationError" }

// Error satisfies the builtin error interface
func (e ListenApiCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListenApiCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListenApiCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListenApiCFValidationError{}

// Validate checks the field values on ApiCF with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *ApiCF) Validate() error {
	if m == nil {
		return nil
	}

	if m.GetListen() == nil {
		return ApiCFValidationError{
			field:  "Listen",
			reason: "value is required",
		}
	}

	if v, ok := interface{}(m.GetListen()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ApiCFValidationError{
				field:  "Listen",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// ApiCFValidationError is the validation error returned by ApiCF.Validate if
// the designated constraints aren't met.
type ApiCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApiCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApiCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApiCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApiCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApiCFValidationError) ErrorName() string { return "ApiCFValidationError" }

// Error satisfies the builtin error interface
func (e ApiCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApiCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApiCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApiCFValidationError{}

// Validate checks the field values on PrivateApiCF with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *PrivateApiCF) Validate() error {
	if m == nil {
		return nil
	}

	if m.GetListen() == nil {
		return PrivateApiCFValidationError{
			field:  "Listen",
			reason: "value is required",
		}
	}

	if v, ok := interface{}(m.GetListen()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PrivateApiCFValidationError{
				field:  "Listen",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// PrivateApiCFValidationError is the validation error returned by
// PrivateApiCF.Validate if the designated constraints aren't met.
type PrivateApiCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PrivateApiCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PrivateApiCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PrivateApiCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PrivateApiCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PrivateApiCFValidationError) ErrorName() string { return "PrivateApiCFValidationError" }

// Error satisfies the builtin error interface
func (e PrivateApiCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPrivateApiCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PrivateApiCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PrivateApiCFValidationError{}

// Validate checks the field values on ConfigurationFile with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *ConfigurationFile) Validate() error {
	if m == nil {
		return nil
	}

	if m.GetGitlab() == nil {
		return ConfigurationFileValidationError{
			field:  "Gitlab",
			reason: "value is required",
		}
	}

	if v, ok := interface{}(m.GetGitlab()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "Gitlab",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetAgent()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "Agent",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetObservability()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "Observability",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetGitaly()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "Gitaly",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetRedis()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "Redis",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetApi()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "Api",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetPrivateApi()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "PrivateApi",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// ConfigurationFileValidationError is the validation error returned by
// ConfigurationFile.Validate if the designated constraints aren't met.
type ConfigurationFileValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ConfigurationFileValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ConfigurationFileValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ConfigurationFileValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ConfigurationFileValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ConfigurationFileValidationError) ErrorName() string {
	return "ConfigurationFileValidationError"
}

// Error satisfies the builtin error interface
func (e ConfigurationFileValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConfigurationFile.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ConfigurationFileValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ConfigurationFileValidationError{}
