/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include <locale.h>
#include "interface.h"
#include "support.h"
#include "ac.h"
#include "gconfig.h"

#include "dvdtools.h"

#define DVD95_VERSION "1.1p2"

/*------------------------------------------------------------------------------
	CHECKDVD-
Linux!jef 2007/01/09 22:45:11
------------------------------------------------------------------------------*/

gboolean CheckDvd( gpointer data )
{
	GtkWidget * Dvd95 = (GtkWidget *)data;
	char * device = ConfigGetString( KEY_DEVICE, "/dev/dvd" );
	int ret;

	ret = IsDvdLoaded( device );
	if( ret == 1 ) {
		GtkWidget * item;

		item = lookup_widget(GTK_WIDGET(Dvd95), "DoScan" );
		g_assert(item);
		gtk_widget_set_sensitive( GTK_WIDGET(item), TRUE );
		item = lookup_widget(GTK_WIDGET(Dvd95), "ToDvd9" );
		g_assert(item);
		gtk_widget_set_sensitive( GTK_WIDGET(item), TRUE );
		return( FALSE );
	}
	return( TRUE );
}



int
main (int argc, char *argv[])
{
	GtkWidget *Dvd95;
	GtkWidget * item;
	char * lang;

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	ac_mmtest();
	tc_memcpy_init( 0, ac_mmflag());

	gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
			argc, argv,
			GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
			NULL);

	gnome_sound_init( "localhost" );

/* Langague if any */
	lang = ConfigGetString( KEY_LANG, "" );
	if( lang && *lang ) {
		if( !strcmp( lang,"English"))	setlocale( LC_MESSAGES, "en_US.UTF-8" );
		if( !strcmp( lang,"Francais"))	setlocale( LC_MESSAGES, "fr_FR.UTF-8" );
	}
/* Pour que les doubles soit sous la forme xxx.yyy */
	setlocale( LC_NUMERIC, "C" );

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
	Dvd95 = create_Dvd95 ();

/* Setup main infos */

	item = lookup_widget(GTK_WIDGET(Dvd95), "produit" );
	gtk_label_set_text( GTK_LABEL(item), _("DVD95: copie privée de DVD 9 vers DVD 5 par J.F. COULON") );

	item = lookup_widget(GTK_WIDGET(Dvd95), "version" );
	{
		char message[256];

		sprintf( message,_("Version: %s du %s"), DVD95_VERSION, __DATE__ );
		gtk_label_set_text( GTK_LABEL(item), message );
	}


/* Manage Button sensitivity */
	{
		char * device = ConfigGetString( KEY_DEVICE, "/dev/dvd" );
		int ret;

		ret = IsDvdLoaded( device );
		if( ret != 1 ) {
			item = lookup_widget(GTK_WIDGET(Dvd95), "DoScan" );
			g_assert(item);
			gtk_widget_set_sensitive( GTK_WIDGET(item), FALSE );
			item = lookup_widget(GTK_WIDGET(Dvd95), "ToDvd9" );
			g_assert(item);
			gtk_widget_set_sensitive( GTK_WIDGET(item), FALSE );
			g_timeout_add( 500, CheckDvd, Dvd95 );
		}
	}



	gtk_widget_show (Dvd95);

	gtk_main ();
	return( 0 );
}

