/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ScrollEvent;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.touch.client.TouchScroller;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.HasScrolling;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.ScrollListener;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.SourcesScrollEvents;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;

public class ScrollPanel
extends SimplePanel
implements SourcesScrollEvents,
RequiresResize,
ProvidesResize,
HasScrolling {
    private static Impl impl;
    private Element containerElem;
    private TouchScroller touchScroller;

    public ScrollPanel() {
        if (impl == null) {
            impl = (Impl)GWT.create(Impl.class);
        }
        this.setAlwaysShowScrollBars(false);
        this.containerElem = DOM.createDiv();
        this.getElement().appendChild(this.containerElem);
        DOM.setStyleAttribute(this.getElement(), "position", "relative");
        DOM.setStyleAttribute(this.containerElem, "position", "relative");
        DOM.setStyleAttribute(this.getElement(), "zoom", "1");
        DOM.setStyleAttribute(this.containerElem, "zoom", "1");
        this.setTouchScrollingDisabled(false);
    }

    public ScrollPanel(Widget child) {
        this();
        this.setWidget(child);
    }

    public HandlerRegistration addScrollHandler(ScrollHandler handler) {
        return this.addDomHandler(handler, ScrollEvent.getType());
    }

    @Deprecated
    public void addScrollListener(ScrollListener listener) {
        ListenerWrapper.WrappedScrollListener.add(this, listener);
    }

    public void ensureVisible(UIObject item) {
        Element scroll = this.getElement();
        Element element = item.getElement();
        this.ensureVisibleImpl(scroll, element);
    }

    public int getHorizontalScrollPosition() {
        return DOM.getElementPropertyInt(this.getElement(), "scrollLeft");
    }

    public int getMaximumHorizontalScrollPosition() {
        return impl.getMaximumHorizontalScrollPosition(this.getElement());
    }

    public int getMaximumVerticalScrollPosition() {
        return this.getElement().getScrollHeight() - this.getElement().getClientHeight();
    }

    public int getMinimumHorizontalScrollPosition() {
        return impl.getMinimumHorizontalScrollPosition(this.getElement());
    }

    public int getMinimumVerticalScrollPosition() {
        return 0;
    }

    @Deprecated
    public int getScrollPosition() {
        return DOM.getElementPropertyInt(this.getElement(), "scrollTop");
    }

    public int getVerticalScrollPosition() {
        return this.getScrollPosition();
    }

    public boolean isTouchScrollingDisabled() {
        return this.touchScroller == null;
    }

    public void onResize() {
        Widget child = this.getWidget();
        if (child != null && child instanceof RequiresResize) {
            ((RequiresResize)((Object)child)).onResize();
        }
    }

    @Deprecated
    public void removeScrollListener(ScrollListener listener) {
        ListenerWrapper.WrappedScrollListener.remove(this, listener);
    }

    public void scrollToBottom() {
        this.setScrollPosition(DOM.getElementPropertyInt(this.getElement(), "scrollHeight"));
    }

    public void scrollToLeft() {
        this.setHorizontalScrollPosition(0);
    }

    public void scrollToRight() {
        this.setHorizontalScrollPosition(DOM.getElementPropertyInt(this.getElement(), "scrollWidth"));
    }

    public void scrollToTop() {
        this.setScrollPosition(0);
    }

    public void setAlwaysShowScrollBars(boolean alwaysShow) {
        DOM.setStyleAttribute(this.getElement(), "overflow", alwaysShow ? "scroll" : "auto");
    }

    public void setHeight(String height) {
        super.setHeight(height);
    }

    public void setHorizontalScrollPosition(int position) {
        DOM.setElementPropertyInt(this.getElement(), "scrollLeft", position);
    }

    @Deprecated
    public void setScrollPosition(int position) {
        DOM.setElementPropertyInt(this.getElement(), "scrollTop", position);
    }

    public void setSize(String width, String height) {
        super.setSize(width, height);
    }

    public boolean setTouchScrollingDisabled(boolean isDisabled) {
        if (isDisabled == this.isTouchScrollingDisabled()) {
            return isDisabled;
        }
        if (isDisabled) {
            this.touchScroller.setTargetWidget(null);
            this.touchScroller = null;
        } else {
            this.touchScroller = TouchScroller.createIfSupported(this);
        }
        return this.isTouchScrollingDisabled();
    }

    public void setVerticalScrollPosition(int position) {
        this.setScrollPosition(position);
    }

    public void setWidth(String width) {
        super.setWidth(width);
    }

    protected Element getContainerElement() {
        return this.containerElem;
    }

    private native void ensureVisibleImpl(Element var1, Element var2);

    static class ImplRtlReversed
    extends Impl {
        ImplRtlReversed() {
        }

        public int getMaximumHorizontalScrollPosition(Element scrollable) {
            return this.isRtl(scrollable) ? 0 : super.getMaximumHorizontalScrollPosition(scrollable);
        }

        public int getMinimumHorizontalScrollPosition(Element scrollable) {
            return this.isRtl(scrollable) ? scrollable.getClientWidth() - scrollable.getScrollWidth() : 0;
        }

        private native boolean isRtl(Element var1);
    }

    static class Impl {
        Impl() {
        }

        public int getMaximumHorizontalScrollPosition(Element scrollable) {
            return scrollable.getScrollWidth() - scrollable.getClientWidth();
        }

        public int getMinimumHorizontalScrollPosition(Element scrollable) {
            return 0;
        }
    }
}

