// For documentation of the format, see README in this directory.
var browserTests = [
["<blockquote><p>foo[bar]</p><p>baz</p></blockquote><p>extra",
    [["outdent",""]],
    "<p>foo[bar]</p><blockquote><p>baz</p></blockquote><p>extra</p>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote><p>foo[bar</p><p>b]az</p></blockquote><p>extra",
    [["outdent",""]],
    "<p>foo[bar</p><p>b]az</p><p>extra</p>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote><p>foo[bar]</p></blockquote><p>baz</p><p>extra",
    [["outdent",""]],
    "<p>foo[bar]</p><p>baz</p><p>extra</p>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote><p>foo[bar</p></blockquote><p>b]az</p><p>extra",
    [["outdent",""]],
    "<p>foo[bar</p><p>b]az</p><p>extra</p>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0px;\" dir=\"ltr\"><p>foo[bar]</p><p>baz</p></blockquote><p>extra",
    [["stylewithcss","true"],["outdent",""]],
    "<p>foo[bar]</p><blockquote><p>baz</p></blockquote><p>extra</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0px;\" dir=\"ltr\"><p>foo[bar]</p><p>baz</p></blockquote><p>extra",
    [["stylewithcss","false"],["outdent",""]],
    "<p>foo[bar]</p><blockquote><p>baz</p></blockquote><p>extra</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"outdent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0px;\" dir=\"ltr\"><p>foo[bar</p><p>b]az</p></blockquote><p>extra",
    [["stylewithcss","true"],["outdent",""]],
    "<p>foo[bar</p><p>b]az</p><p>extra</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0px;\" dir=\"ltr\"><p>foo[bar</p><p>b]az</p></blockquote><p>extra",
    [["stylewithcss","false"],["outdent",""]],
    "<p>foo[bar</p><p>b]az</p><p>extra</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"outdent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0px;\" dir=\"ltr\"><p>foo[bar]</p></blockquote><p>baz</p><p>extra",
    [["stylewithcss","true"],["outdent",""]],
    "<p>foo[bar]</p><p>baz</p><p>extra</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0px;\" dir=\"ltr\"><p>foo[bar]</p></blockquote><p>baz</p><p>extra",
    [["stylewithcss","false"],["outdent",""]],
    "<p>foo[bar]</p><p>baz</p><p>extra</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"outdent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0px;\" dir=\"ltr\"><p>foo[bar</p></blockquote><p>b]az</p><p>extra",
    [["stylewithcss","true"],["outdent",""]],
    "<p>foo[bar</p><p>b]az</p><p>extra</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""]}],
["<blockquote style=\"margin-right: 0px;\" dir=\"ltr\"><p>foo[bar</p></blockquote><p>b]az</p><p>extra",
    [["stylewithcss","false"],["outdent",""]],
    "<p>foo[bar</p><p>b]az</p><p>extra</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"outdent":[false,false,"",false,false,""]}],
["<p style=\"margin-left: 40px\">foo[bar]</p><p style=\"margin-left: 40px\">baz</p><p>extra",
    [["outdent",""]],
    "<p style=\"margin-left:40px\">foo[bar]</p><p style=\"margin-left:40px\">baz</p><p>extra</p>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<p style=\"margin-left: 40px\">foo[bar</p><p style=\"margin-left: 40px\">b]az</p><p>extra",
    [["outdent",""]],
    "<p style=\"margin-left:40px\">foo[bar</p><p style=\"margin-left:40px\">b]az</p><p>extra</p>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<p style=\"margin-left: 40px\">foo[bar]</p><p>baz</p><p>extra",
    [["outdent",""]],
    "<p style=\"margin-left:40px\">foo[bar]</p><p>baz</p><p>extra</p>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<p style=\"margin-left: 40px\">foo[bar</p><p>b]az</p><p>extra",
    [["outdent",""]],
    "<p style=\"margin-left:40px\">foo[bar</p><p>b]az</p><p>extra</p>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px;\"><p>foo[bar]</p><p>baz</p></blockquote><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["outdent",""]],
    "<div class=\"webkit-indent-blockquote\"><p>foo[bar]</p><blockquote><p>baz</p></blockquote></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px;\"><p>foo[bar]</p><p>baz</p></blockquote><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["outdent",""]],
    "<div class=\"webkit-indent-blockquote\"><p>foo[bar]</p><blockquote><p>baz</p></blockquote></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px;\"><p>foo[bar]</p><p>baz</p></blockquote><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["outdent",""]],
    "<div class=\"webkit-indent-blockquote\"><p>foo[bar]</p><blockquote><p>baz</p></blockquote></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px;\"><p>foo[bar]</p><p>baz</p></blockquote><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["outdent",""]],
    "<div class=\"webkit-indent-blockquote\"><p>foo[bar]</p><blockquote><p>baz</p></blockquote></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px;\"><p>foo[bar</p><p>b]az</p></blockquote><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["outdent",""]],
    "<div class=\"webkit-indent-blockquote\"><p>foo[bar</p><p>b]az</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px;\"><p>foo[bar</p><p>b]az</p></blockquote><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["outdent",""]],
    "<div class=\"webkit-indent-blockquote\"><p>foo[bar</p><p>b]az</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px;\"><p>foo[bar</p><p>b]az</p></blockquote><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["outdent",""]],
    "<div class=\"webkit-indent-blockquote\"><p>foo[bar</p><p>b]az</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px;\"><p>foo[bar</p><p>b]az</p></blockquote><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["outdent",""]],
    "<div class=\"webkit-indent-blockquote\"><p>foo[bar</p><p>b]az</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px;\"><p>foo[bar]</p></blockquote><p>baz</p><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["outdent",""]],
    "<div class=\"webkit-indent-blockquote\"><p>foo[bar]</p></div><p>baz</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px;\"><p>foo[bar]</p></blockquote><p>baz</p><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["outdent",""]],
    "<div class=\"webkit-indent-blockquote\"><p>foo[bar]</p></div><p>baz</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px;\"><p>foo[bar]</p></blockquote><p>baz</p><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["outdent",""]],
    "<div class=\"webkit-indent-blockquote\"><p>foo[bar]</p></div><p>baz</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px;\"><p>foo[bar]</p></blockquote><p>baz</p><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["outdent",""]],
    "<div class=\"webkit-indent-blockquote\"><p>foo[bar]</p></div><p>baz</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px;\"><p>foo[bar</p></blockquote><p>b]az</p><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["outdent",""]],
    "<div class=\"webkit-indent-blockquote\"><p>foo[bar</p></div><p>b]az</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px;\"><p>foo[bar</p></blockquote><p>b]az</p><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["outdent",""]],
    "<div class=\"webkit-indent-blockquote\"><p>foo[bar</p></div><p>b]az</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px;\"><p>foo[bar</p></blockquote><p>b]az</p><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["outdent",""]],
    "<div class=\"webkit-indent-blockquote\"><p>foo[bar</p></div><p>b]az</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<blockquote class=\"webkit-indent-blockquote\" style=\"margin: 0 0 0 40px; border: none; padding: 0px;\"><p>foo[bar</p></blockquote><p>b]az</p><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["outdent",""]],
    "<div class=\"webkit-indent-blockquote\"><p>foo[bar</p></div><p>b]az</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<blockquote><blockquote>foo[bar]baz</blockquote></blockquote>",
    [["outdent",""]],
    "<blockquote>foo[bar]baz</blockquote>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote><blockquote data-abc=def>foo[bar]baz</blockquote></blockquote>",
    [["outdent",""]],
    "<blockquote data-abc=\"def\">foo[bar]baz</blockquote>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote data-abc=def><blockquote>foo[bar]baz</blockquote></blockquote>",
    [["outdent",""]],
    "<blockquote data-abc=\"def\">foo[bar]baz</blockquote>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote><div>foo[bar]baz</div></blockquote>",
    [["outdent",""]],
    "<div>foo[bar]baz</div>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote><div id=abc>foo[bar]baz</div></blockquote>",
    [["outdent",""]],
    "<div id=\"abc\">foo[bar]baz</div>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote id=abc>foo[bar]baz</blockquote>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div id=\"abc\">foo[bar]baz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<blockquote id=abc>foo[bar]baz</blockquote>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<div id=\"abc\">foo[bar]baz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<blockquote style=\"color: blue\">foo[bar]baz</blockquote>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div style=\"color:rgb(0, 0, 255)\">foo[bar]baz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<blockquote style=\"color: blue\">foo[bar]baz</blockquote>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<div style=\"color:rgb(0, 0, 255)\">foo[bar]baz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<blockquote><blockquote><p>foo[bar]<p>baz</blockquote></blockquote>",
    [["outdent",""]],
    "<blockquote><p>foo[bar]</p><blockquote><p>baz</p></blockquote></blockquote>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote><blockquote data-abc=def><p>foo[bar]<p>baz</blockquote></blockquote>",
    [["outdent",""]],
    "<blockquote data-abc=\"def\"><p>foo[bar]</p><blockquote><p>baz</p></blockquote></blockquote>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote data-abc=def><blockquote><p>foo[bar]<p>baz</blockquote></blockquote>",
    [["outdent",""]],
    "<blockquote data-abc=\"def\"><p>foo[bar]</p><blockquote><p>baz</p></blockquote></blockquote>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote><div><p>foo[bar]<p>baz</div></blockquote>",
    [["outdent",""]],
    "<div><p>foo[bar]</p><blockquote><p>baz</p></blockquote></div>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote><div id=abc><p>foo[bar]<p>baz</div></blockquote>",
    [["outdent",""]],
    "<div id=\"abc\"><p>foo[bar]</p><blockquote><p>baz</p></blockquote></div>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote id=abc><p>foo[bar]<p>baz</blockquote>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div id=\"abc\"><p>foo[bar]</p><blockquote><p>baz</p></blockquote></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<blockquote id=abc><p>foo[bar]<p>baz</blockquote>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<div id=\"abc\"><p>foo[bar]</p><blockquote><p>baz</p></blockquote></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<blockquote style=\"color: blue\"><p>foo[bar]<p>baz</blockquote>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div style=\"color:rgb(0, 0, 255)\"><p>foo[bar]</p><blockquote><p>baz</p></blockquote></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<blockquote style=\"color: blue\"><p>foo[bar]<p>baz</blockquote>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<div style=\"color:rgb(0, 0, 255)\"><p>foo[bar]</p><blockquote><p>baz</p></blockquote></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<blockquote><p><b>foo[bar]</b><p>baz</blockquote>",
    [["outdent",""]],
    "<p><b>foo[bar]</b></p><blockquote><p>baz</p></blockquote>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote><p><strong>foo[bar]</strong><p>baz</blockquote>",
    [["outdent",""]],
    "<p><strong>foo[bar]</strong></p><blockquote><p>baz</p></blockquote>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote><p><span>foo[bar]</span><p>baz</blockquote>",
    [["outdent",""]],
    "<p><span>foo[bar]</span></p><blockquote><p>baz</p></blockquote>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote><blockquote style=\"color: blue\"><p>foo[bar]</blockquote><p>baz</blockquote>",
    [["outdent",""]],
    "<blockquote style=\"color:rgb(0, 0, 255)\"><p>foo[bar]</p></blockquote><blockquote><p>baz</p></blockquote>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote style=\"color: blue\"><blockquote><p>foo[bar]</blockquote><p>baz</blockquote>",
    [["outdent",""]],
    "<blockquote style=\"color:rgb(0, 0, 255)\"><p>foo[bar]</p><p>baz</p></blockquote>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]<li>baz</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<ol><li>foo</li></ol><div>[bar]</div><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]<li>baz</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<ol><li>foo</li></ol><p>[bar]</p><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol data-start=1 data-end=2><li>foo<li>bar<li>baz</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<ol><li>foo</li>{</ol><div>bar</div>}<ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol data-start=1 data-end=2><li>foo<li>bar<li>baz</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<ol><li>foo</li>{</ol><p>bar</p>}<ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</ol>[bar]",
    [["outdent",""]],
    "<ol><li>foo</li></ol>[bar]",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo]<br>bar<li>baz</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div>[foo]<br>bar</div><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo]<br>bar<li>baz</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<p>[foo]<br>bar</p><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<br>[bar]<li>baz</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div>foo<br>[bar]</div><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<br>[bar]<li>baz</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<p>foo<br>[bar]</p><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li><div>[foo]</div>bar<li>baz</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div>[foo]</div><div>bar</div><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li><div>[foo]</div>bar<li>baz</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<div>[foo]</div><p>bar</p><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>[bar]<li>baz</ol><li>quz</ol>",
    [["outdent",""]],
    "<ol><li>foo</li><li>[bar]</li><ol><li>baz</li></ol><li>quz</li></ol>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>bar<li>[baz]</ol><li>quz</ol>",
    [["outdent",""]],
    "<ol><li>foo</li><ol><li>bar</li></ol><li>[baz]</li><li>quz</li></ol>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>[bar]<li>baz</ol><li>quz</ol>",
    [["outdent",""]],
    "<ol><li>foo</li><li>[bar]</li><ol><li>baz</li></ol><li>quz</li></ol>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol data-start=0 data-end=1><li>bar<li>baz</ol><li>quz</ol>",
    [["outdent",""]],
    "<ol><li>foo</li>{<li>bar</li>}<ol><li>baz</li></ol><li>quz</li></ol>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>bar<li>[baz]</ol><li>quz</ol>",
    [["outdent",""]],
    "<ol><li>foo</li><ol><li>bar</li></ol><li>[baz]</li><li>quz</li></ol>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol data-start=1 data-end=2><li>bar<li>baz</ol><li>quz</ol>",
    [["outdent",""]],
    "<ol><li>foo</li><ol><li>bar</li></ol>{<li>baz</li>}<li>quz</li></ol>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>b[a]r</ol><li>baz</ol>",
    [["outdent",""]],
    "<ol><li>foo</li><li>b[a]r</li><li>baz</li></ol>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>b[a]r</ol><li>baz</ol>",
    [["outdent",""]],
    "<ol><li>foo</li><li>b[a]r</li><li>baz</li></ol>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo{<ol><li>bar</ol>}<li>baz</ol>",
    [["outdent",""]],
    "<ol><li>foo</li>{<li>bar</li>}<li>baz</li></ol>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li>{<ol><li>bar</ol>}<li>baz</ol>",
    [["outdent",""]],
    "<ol><li>foo</li>{<li>bar</li>}<li>baz</li></ol>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo]<ol><li>bar</ol><li>baz</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div>[foo]</div><ol><ol><li>bar</li></ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo]<ol><li>bar</ol><li>baz</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<p>[foo]</p><ol><ol><li>bar</li></ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo]</li><ol><li>bar</ol><li>baz</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div>[foo]</div><ol><ol><li>bar</li></ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo]</li><ol><li>bar</ol><li>baz</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<p>[foo]</p><ol><ol><li>bar</li></ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]<ol><li>baz</ol><li>quz</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<ol><li>foo</li></ol><div>[bar]</div><ol><ol><li>baz</li></ol><li>quz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]<ol><li>baz</ol><li>quz</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<ol><li>foo</li></ol><p>[bar]</p><ol><ol><li>baz</li></ol><li>quz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]</li><ol><li>baz</ol><li>quz</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<ol><li>foo</li></ol><div>[bar]</div><ol><ol><li>baz</li></ol><li>quz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>[bar]</li><ol><li>baz</ol><li>quz</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<ol><li>foo</li></ol><p>[bar]</p><ol><ol><li>baz</li></ol><li>quz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>bar<li>baz</ol><li>[quz]</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<ol><li>foo<ol><li>bar</li><li>baz</li></ol></li></ol><div>[quz]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>bar<li>baz</ol><li>[quz]</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<ol><li>foo<ol><li>bar</li><li>baz</li></ol></li></ol><p>[quz]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>bar<li>baz</ol><li>[quz]</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<ol><li>foo</li><ol><li>bar</li><li>baz</li></ol></ol><div>[quz]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>bar<li>baz</ol><li>[quz]</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<ol><li>foo</li><ol><li>bar</li><li>baz</li></ol></ol><p>[quz]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>b[ar<li>baz]</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<ol><li>foo</li></ol><div>b[ar</div><div>baz]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<li>b[ar<li>baz]</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<ol><li>foo</li></ol><p>b[ar</p><p>baz]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo<ol><li>bar]</ol><li>baz</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div>[foo</div><ol><li>bar]</li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo<ol><li>bar]</ol><li>baz</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<p>[foo</p><ol><li>bar]</li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo</li><ol><li>bar]</ol><li>baz</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div>[foo</div><ol><li>bar]</li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo</li><ol><li>bar]</ol><li>baz</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<p>[foo</p><ol><li>bar]</li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>b[ar</ol><li>b]az</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<ol><li>foo</li><li>b[ar</li></ol><div>b]az</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>b[ar</ol><li>b]az</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<ol><li>foo</li><li>b[ar</li></ol><p>b]az</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>b[ar</ol><li>b]az</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<ol><li>foo</li><li>b[ar</li></ol><div>b]az</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li>b[ar</ol><li>b]az</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<ol><li>foo</li><li>b[ar</li></ol><p>b]az</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo<ol><li>bar</ol><li>baz]</ol><p>extra",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div>[foo</div><ol><li>bar</li></ol><div>baz]</div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo<ol><li>bar</ol><li>baz]</ol><p>extra",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<p>[foo</p><ol><li>bar</li></ol><p>baz]</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo</li><ol><li>bar</ol><li>baz]</ol><p>extra",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div>[foo</div><ol><li>bar</li></ol><div>baz]</div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo</li><ol><li>bar</ol><li>baz]</ol><p>extra",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<p>[foo</p><ol><li>bar</li></ol><p>baz]</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo]<ol><li>bar</ol>baz</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div>[foo]</div><ol><ol><li>bar</li></ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo]<ol><li>bar</ol>baz</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<p>[foo]</p><ol><ol><li>bar</li></ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>[bar]</ol>baz</ol>",
    [["outdent",""]],
    "<ol><li>foo</li><li>[bar]</li><li>baz</li></ol>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>bar</ol>[baz]</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<ol><li>foo</li><ol><li>bar</li></ol></ol><div>[baz]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo<ol><li>bar</ol>[baz]</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<ol><li>foo</li><ol><li>bar</li></ol></ol><p>[baz]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo<ol><li>bar]</ol>baz</ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div>[foo</div><ol><li>bar]</li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo<ol><li>bar]</ol>baz</ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<p>[foo</p><ol><li>bar]</li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["foo<ol start=5><li>[bar]</ol>baz",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "foo<div>[bar]</div>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["foo<ol start=5><li>[bar]</ol>baz",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "foo<p>[bar]</p>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["foo<ol id=abc><li>[bar]</ol>baz",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "foo<div id=\"abc\"><div>[bar]</div></div>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["foo<ol id=abc><li>[bar]</ol>baz",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "foo<div id=\"abc\"><p>[bar]</p></div>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["foo<ol style=color:blue><li>[bar]</ol>baz",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "foo<div style=\"color:rgb(0, 0, 255)\"><div>[bar]</div></div>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["foo<ol style=color:blue><li>[bar]</ol>baz",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "foo<div style=\"color:rgb(0, 0, 255)\"><p>[bar]</p></div>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["foo<ol><li value=5>[bar]</ol>baz",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "foo<div value=\"5\">[bar]</div>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["foo<ol><li value=5>[bar]</ol>baz",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "foo<p value=\"5\">[bar]</p>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["foo<ol><li id=abc>[bar]</ol>baz",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "foo<div id=\"abc\">[bar]</div>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["foo<ol><li id=abc>[bar]</ol>baz",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "foo<p id=\"abc\">[bar]</p>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["foo<ol><li style=color:blue>[bar]</ol>baz",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "foo<div style=\"color:rgb(0, 0, 255)\">[bar]</div>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["foo<ol><li style=color:blue>[bar]</ol>baz",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "foo<p style=\"color:rgb(0, 0, 255)\">[bar]</p>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol><li value=5>[bar]</ol></ol>",
    [["outdent",""]],
    "<ol><li>foo</li><li value=\"5\">[bar]</li></ol>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ul><li>foo</li><ol><li value=5>[bar]</ol></ul>",
    [["outdent",""]],
    "<ul><li>foo</li><li value=\"5\">[bar]</li></ul>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol start=5><li>[bar]</ol><li>baz</ol>",
    [["outdent",""]],
    "<ol><li>foo</li><li>[bar]</li><li>baz</li></ol>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol id=abc><li>[bar]</ol><li>baz</ol>",
    [["outdent",""]],
    "<ol><li>foo</li><li>[bar]</li><li>baz</li></ol>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol style=color:blue><li>[bar]</ol><li>baz</ol>",
    [["stylewithcss","true"],["outdent",""]],
    "<ol><li>foo</li><li><span style=\"color:rgb(0, 0, 255)\">[bar]</span></li><li>baz</li></ol>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol style=color:blue><li>[bar]</ol><li>baz</ol>",
    [["stylewithcss","false"],["outdent",""]],
    "<ol><li>foo</li><li><font color=\"#0000ff\">[bar]</font></li><li>baz</li></ol>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol style=text-indent:1em><li>[bar]</ol><li>baz</ol>",
    [["stylewithcss","true"],["outdent",""]],
    "<ol><li>foo</li><li>[bar]</li><li>baz</li></ol>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol style=text-indent:1em><li>[bar]</ol><li>baz</ol>",
    [["stylewithcss","false"],["outdent",""]],
    "<ol><li>foo</li><li>[bar]</li><li>baz</li></ol>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol start=5><li>[bar<li>baz]</ol><li>quz</ol>",
    [["outdent",""]],
    "<ol><li>foo</li><li>[bar</li><li>baz]</li><li>quz</li></ol>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol id=abc><li>[bar<li>baz]</ol><li>quz</ol>",
    [["outdent",""]],
    "<ol><li>foo</li><li>[bar</li><li>baz]</li><li>quz</li></ol>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol style=color:blue><li>[bar<li>baz]</ol><li>quz</ol>",
    [["stylewithcss","true"],["outdent",""]],
    "<ol><li>foo</li><li><span style=\"color:rgb(0, 0, 255)\">[bar</span></li><li><span style=\"color:rgb(0, 0, 255)\">baz]</span></li><li>quz</li></ol>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol style=color:blue><li>[bar<li>baz]</ol><li>quz</ol>",
    [["stylewithcss","false"],["outdent",""]],
    "<ol><li>foo</li><li><font color=\"#0000ff\">[bar</font></li><li><font color=\"#0000ff\">baz]</font></li><li>quz</li></ol>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol style=text-indent:1em><li>[bar<li>baz]</ol><li>quz</ol>",
    [["stylewithcss","true"],["outdent",""]],
    "<ol><li>foo</li><li>[bar</li><li>baz]</li><li>quz</li></ol>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""]}],
["<ol><li>foo</li><ol style=text-indent:1em><li>[bar<li>baz]</ol><li>quz</ol>",
    [["stylewithcss","false"],["outdent",""]],
    "<ol><li>foo</li><li>[bar</li><li>baz]</li><li>quz</li></ol>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"outdent":[false,false,"",false,false,""]}],
["<blockquote><ol><li>[foo]</ol></blockquote><p>extra",
    [["outdent",""]],
    "<ol><li>[foo]</li></ol><p>extra</p>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote>foo<ol><li>[bar]</ol>baz</blockquote><p>extra",
    [["outdent",""]],
    "<blockquote>foo</blockquote><ol><li>[bar]</li></ol><blockquote>baz</blockquote><p>extra</p>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote><ol><li>foo</li><ol><li>[bar]</ol><li>baz</ol></blockquote><p>extra",
    [["outdent",""]],
    "<blockquote><ol><li>foo</li><li>[bar]</li><li>baz</li></ol></blockquote><p>extra</p>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li><h1>[foo]</h1></ol>",
    [["outdent",""]],
    "<h1>[foo]</h1>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol><li><xmp>[foo]</xmp></li></ol>",
    [["outdent",""]],
    "<xmp>[foo]</xmp>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote><ol><li>foo<div><ol><li>[bar]</ol></div><li>baz</ol></blockquote>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<blockquote><ol><li>foo</li><li>[bar]</li><li>baz</li></ol></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<blockquote><ol><li>foo<div><ol><li>[bar]</ol></div><li>baz</ol></blockquote>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<blockquote><ol><li>foo</li><li>[bar]</li><li>baz</li></ol></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<blockquote> <p>[foo]</p></blockquote>",
    [["outdent",""]],
    " <p>[foo]</p>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote><p>[foo]</p> </blockquote>",
    [["outdent",""]],
    "<p>[foo]</p> ",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote> <p>[foo]</p> </blockquote>",
    [["outdent",""]],
    " <p>[foo]</p> ",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol> <li>[foo]</li></ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    " <div>[foo]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol> <li>[foo]</li></ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    " <p>[foo]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo]</li> </ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div>[foo]</div> ",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[foo]</li> </ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<p>[foo]</p> ",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol> <li>[foo]</li> </ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    " <div>[foo]</div> ",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol> <li>[foo]</li> </ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    " <p>[foo]</p> ",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ul> <li>[foo]</li></ul>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    " <div>[foo]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ul> <li>[foo]</li></ul>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    " <p>[foo]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ul><li>[foo]</li> </ul>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div>[foo]</div> ",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ul><li>[foo]</li> </ul>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<p>[foo]</p> ",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ul> <li>[foo]</li> </ul>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    " <div>[foo]</div> ",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ul> <li>[foo]</li> </ul>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    " <p>[foo]</p> ",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<blockquote> <p>[foo]</p> <p>bar</p> <p>baz</p></blockquote>",
    [["outdent",""]],
    " <p>[foo]</p><blockquote> <p>bar</p> <p>baz</p></blockquote>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote> <p>foo</p> <p>[bar]</p> <p>baz</p></blockquote>",
    [["outdent",""]],
    "<blockquote> <p>foo</p> </blockquote><p>[bar]</p><blockquote> <p>baz</p></blockquote>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<blockquote> <p>foo</p> <p>bar</p> <p>[baz]</p></blockquote>",
    [["outdent",""]],
    "<blockquote> <p>foo</p> <p>bar</p> </blockquote><p>[baz]</p>",
    [true],
    {"outdent":[false,false,"",false,false,""]}],
["<ol> <li>[foo]</li> <li>bar</li> <li>baz</li></ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    " <div>[foo]</div> <ol><li>bar</li> <li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol> <li>[foo]</li> <li>bar</li> <li>baz</li></ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    " <p>[foo]</p> <ol><li>bar</li> <li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol> <li>foo</li> <li>[bar]</li> <li>baz</li></ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<ol> <li>foo</li></ol> <div>[bar]</div> <ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol> <li>foo</li> <li>[bar]</li> <li>baz</li></ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<ol> <li>foo</li></ol> <p>[bar]</p> <ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol> <li>foo</li> <li>bar</li> <li>[baz]</li></ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<ol> <li>foo</li> <li>bar</li></ol> <div>[baz]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol> <li>foo</li> <li>bar</li> <li>[baz]</li></ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<ol> <li>foo</li> <li>bar</li></ol> <p>[baz]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ul> <li>[foo]</li> <li>bar</li> <li>baz</li></ul>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    " <div>[foo]</div> <ul><li>bar</li> <li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ul> <li>[foo]</li> <li>bar</li> <li>baz</li></ul>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    " <p>[foo]</p> <ul><li>bar</li> <li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ul> <li>foo</li> <li>[bar]</li> <li>baz</li></ul>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<ul> <li>foo</li></ul> <div>[bar]</div> <ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ul> <li>foo</li> <li>[bar]</li> <li>baz</li></ul>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<ul> <li>foo</li></ul> <p>[bar]</p> <ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ul> <li>foo</li> <li>bar</li> <li>[baz]</li></ul>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<ul> <li>foo</li> <li>bar</li></ul> <div>[baz]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ul> <li>foo</li> <li>bar</li> <li>[baz]</li></ul>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<ul> <li>foo</li> <li>bar</li></ul> <p>[baz]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[]a<table><tr><td><br></table></ol>",
    [["defaultparagraphseparator","div"],["outdent",""]],
    "<div>[]a</div><table><tbody><tr><td><br></td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"outdent":[false,false,"",false,false,""]}],
["<ol><li>[]a<table><tr><td><br></table></ol>",
    [["defaultparagraphseparator","p"],["outdent",""]],
    "<p>[]a</p><table><tbody><tr><td><br></td></tr></tbody></table>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"outdent":[false,false,"",false,false,""]}],
["<blockquote><span>foo<br>[bar]</span></blockquote>",
    [["outdent",""]],
    "<blockquote>foo</blockquote><span>[bar]</span>",
    [true],
    {"outdent":[false,false,"",false,false,""]}]
]
