/*
 * Copyright (c) 2000 IBM Deutschland Entwicklung GmbH, IBM Coporation
 * Copyright (c) 2000-2019 The strace developers.
 * Authors: Ulrich Weigand <Ulrich.Weigand@de.ibm.com>
 *          D.J. Barrow  <barrow_dj@mail.yahoo.com,djbarrow@de.ibm.com>
 * All rights reserved.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 */

[  0] = {MA,	0,		SEN(setup),			"setup"			},
[  1] = { 1,	TP|SE,		SEN(exit),			"exit"			},
[  2] = { 0,	TP,		SEN(fork),			"fork"			},
[  3] = { 3,	TD,		SEN(read),			"read"			},
[  4] = { 3,	TD,		SEN(write),			"write"			},
[  5] = { 3,	TD|TF,		SEN(open),			"open"			},
[  6] = { 1,	TD,		SEN(close),			"close"			},
[  7] = { 0,	0,		SEN(restart_syscall),		"restart_syscall"	},
[  8] = { 2,	TD|TF,		SEN(creat),			"creat"			},
[  9] = { 2,	TF,		SEN(link),			"link"			},
[ 10] = { 1,	TF,		SEN(unlink),			"unlink"		},
[ 11] = { 3,	TF|TP|TSD|SE|SI,	SEN(execve),			"execve"		},
[ 12] = { 1,	TF,		SEN(chdir),			"chdir"			},
[ 13] = { 1,	0,		SEN(time),			"time"			},
[ 14] = { 3,	TF,		SEN(mknod),			"mknod"			},
[ 15] = { 2,	TF,		SEN(chmod),			"chmod"			},
[ 16] = { 3,	TF,		SEN(chown16),			"lchown"		},
[ 17] = { },
[ 18] = { },
[ 19] = { 3,	TD,		SEN(lseek),			"lseek"			},
[ 20] = { 0,	PU|NF,		SEN(getpid),			"getpid"		},
[ 21] = { 5,	TF,		SEN(mount),			"mount"			},
[ 22] = { 1,	TF,		SEN(umount),			"umount"		},
[ 23] = { 1,	TC,		SEN(setuid16),			"setuid"		},
[ 24] = { 0,	TC|PU|NF,	SEN(getuid16),			"getuid"		},
[ 25] = { 1,	0,		SEN(stime),			"stime"			},
[ 26] = { 4,	0,		SEN(ptrace),			"ptrace"		},
[ 27] = { 1,	0,		SEN(alarm),			"alarm"			},
[ 28] = { },
[ 29] = { 0,	TS,		SEN(pause),			"pause"			},
[ 30] = { 2,	TF,		SEN(utime),			"utime"			},
[ 31] = { },
[ 32] = { },
[ 33] = { 2,	TF,		SEN(access),			"access"		},
[ 34] = { 1,	0,		SEN(nice),			"nice"			},
[ 35] = { },
[ 36] = { 0,	0,		SEN(sync),			"sync"			},
[ 37] = { 2,	TS,		SEN(kill),			"kill"			},
[ 38] = { 2,	TF,		SEN(rename),			"rename"		},
[ 39] = { 2,	TF,		SEN(mkdir),			"mkdir"			},
[ 40] = { 1,	TF,		SEN(rmdir),			"rmdir"			},
[ 41] = { 1,	TD,		SEN(dup),			"dup"			},
[ 42] = { 1,	TD,		SEN(pipe),			"pipe"			},
[ 43] = { 1,	0,		SEN(times),			"times"			},
[ 44] = { },
[ 45] = { 1,	TM|SI,		SEN(brk),			"brk"			},
[ 46] = { 1,	TC,		SEN(setgid16),			"setgid"		},
[ 47] = { 0,	TC|PU|NF,	SEN(getgid16),			"getgid"		},
[ 48] = { 2,	TS,		SEN(signal),			"signal"		},
[ 49] = { 0,	TC|PU|NF,	SEN(geteuid16),			"geteuid"		},
[ 50] = { 0,	TC|PU|NF,	SEN(getegid16),			"getegid"		},
[ 51] = { 1,	TF,		SEN(acct),			"acct"			},
[ 52] = { 2,	TF,		SEN(umount2),			"umount2"		},
[ 53] = { },
[ 54] = { 3,	TD,		SEN(ioctl),			"ioctl"			},
[ 55] = { 3,	TD,		SEN(fcntl),			"fcntl"			},
[ 56] = { },
[ 57] = { 2,	0,		SEN(setpgid),			"setpgid"		},
[ 58] = { },
[ 59] = { },
[ 60] = { 1,	NF,		SEN(umask),			"umask"			},
[ 61] = { 1,	TF,		SEN(chroot),			"chroot"		},
[ 62] = { 2,	TSFA,		SEN(ustat),			"ustat"			},
[ 63] = { 2,	TD,		SEN(dup2),			"dup2"			},
[ 64] = { 0,	PU|NF,		SEN(getppid),			"getppid"		},
[ 65] = { 0,	PU|NF,		SEN(getpgrp),			"getpgrp"		},
[ 66] = { 0,	0,		SEN(setsid),			"setsid"		},
[ 67] = { 3,	TS,		SEN(sigaction),			"sigaction"		},
[ 68] = { },
[ 69] = { },
[ 70] = { 2,	TC,		SEN(setreuid16),		"setreuid"		},
[ 71] = { 2,	TC,		SEN(setregid16),		"setregid"		},
[ 72] = { 3,	TS,		SEN(sigsuspend),		"sigsuspend"		},
[ 73] = { 1,	TS,		SEN(sigpending),		"sigpending"		},
[ 74] = { 2,	0,		SEN(sethostname),		"sethostname"		},
[ 75] = { 2,	0,		SEN(setrlimit),			"setrlimit"		},
[ 76] = { 2,	0,		SEN(getrlimit),			"getrlimit"		},
[ 77] = { 2,	0,		SEN(getrusage),			"getrusage"		},
[ 78] = { 2,	0,		SEN(gettimeofday),		"gettimeofday"		},
[ 79] = { 2,	0,		SEN(settimeofday),		"settimeofday"		},
[ 80] = { 2,	TC,		SEN(getgroups16),		"getgroups"		},
[ 81] = { 2,	TC,		SEN(setgroups16),		"setgroups"		},
[ 82] = { },
[ 83] = { 2,	TF,		SEN(symlink),			"symlink"		},
[ 84] = { },
[ 85] = { 3,	TF,		SEN(readlink),			"readlink"		},
[ 86] = { 1,	TF,		SEN(uselib),			"uselib"		},
[ 87] = { 2,	TF,		SEN(swapon),			"swapon"		},
[ 88] = { 4,	0,		SEN(reboot),			"reboot"		},
[ 89] = { 3,	TD,		SEN(readdir),			"readdir"		},
[ 90] = { 1,	TD|TM|SI,	SEN(old_mmap),			"mmap"			},
[ 91] = { 2,	TM|SI,		SEN(munmap),			"munmap"		},
[ 92] = { 2,	TF,		SEN(truncate),			"truncate"		},
[ 93] = { 2,	TD,		SEN(ftruncate),			"ftruncate"		},
[ 94] = { 2,	TD,		SEN(fchmod),			"fchmod"		},
[ 95] = { 3,	TD,		SEN(fchown16),			"fchown"		},
[ 96] = { 2,	0,		SEN(getpriority),		"getpriority"		},
[ 97] = { 3,	0,		SEN(setpriority),		"setpriority"		},
[ 98] = { },
[ 99] = { 2,	TF|TSF|TSFA,	SEN(statfs),			"statfs"		},
[100] = { 2,	TD|TFSF|TSFA,	SEN(fstatfs),			"fstatfs"		},
[101] = { 3,	0,		SEN(ioperm),			"ioperm"		},
[102] = { 2,	TD|TSD,		SEN(socketcall),		"socketcall"		},
[103] = { 3,	0,		SEN(syslog),			"syslog"		},
[104] = { 3,	0,		SEN(setitimer),			"setitimer"		},
[105] = { 2,	0,		SEN(getitimer),			"getitimer"		},
[106] = { 2,	TF|TST|TSTA,	SEN(stat),			"stat"			},
[107] = { 2,	TF|TLST|TSTA,	SEN(lstat),			"lstat"			},
[108] = { 2,	TD|TFST|TSTA,	SEN(fstat),			"fstat"			},
[109] = { },
[110] = { 4,	0,		SEN(lookup_dcookie),		"lookup_dcookie"	},
[111] = { 0,	0,		SEN(vhangup),			"vhangup"		},
[112] = { 0,	0,		SEN(idle),			"idle"			},
[113] = { },
[114] = { 4,	TP,		SEN(wait4),			"wait4"			},
[115] = { 1,	TF,		SEN(swapoff),			"swapoff"		},
[116] = { 1,	0,		SEN(sysinfo),			"sysinfo"		},
[117] = { 5,	TI|TSD,		SEN(ipc),			"ipc"			},
[118] = { 1,	TD,		SEN(fsync),			"fsync"			},
[119] = { 0,	TS,		SEN(sigreturn),			"sigreturn"		},
[120] = { 5,	TP,		SEN(clone),			"clone"			},
[121] = { 2,	0,		SEN(setdomainname),		"setdomainname"		},
[122] = { 1,	0,		SEN(uname),			"uname"			},
[123] = { },
[124] = { 1,	0,		SEN(adjtimex32),		"adjtimex"		},
[125] = { 3,	TM|SI,		SEN(mprotect),			"mprotect"		},
[126] = { 3,	TS,		SEN(sigprocmask),		"sigprocmask"		},
[127] = { 2,	0,		SEN(create_module),		"create_module"		},
[128] = { 3,	0,		SEN(init_module),		"init_module"		},
[129] = { 2,	0,		SEN(delete_module),		"delete_module"		},
[130] = { 1,	0,		SEN(get_kernel_syms),		"get_kernel_syms"	},
[131] = { 4,	TF,		SEN(quotactl),			"quotactl"		},
[132] = { 1,	0,		SEN(getpgid),			"getpgid"		},
[133] = { 1,	TD,		SEN(fchdir),			"fchdir"		},
[134] = { 2,	0,		SEN(bdflush),			"bdflush"		},
[135] = { 3,	0,		SEN(sysfs),			"sysfs"			},
[136] = { 1,	NF,		SEN(personality),		"personality"		},
[137] = { 5,	0,		SEN(afs_syscall),		"afs_syscall"		},
[138] = { 1,	TC|NF,		SEN(setfsuid16),		"setfsuid"		},
[139] = { 1,	TC|NF,		SEN(setfsgid16),		"setfsgid"		},
[140] = { 5,	TD,		SEN(llseek),			"_llseek"		},
[141] = { 3,	TD,		SEN(getdents),			"getdents"		},
[142] = { 5,	TD,		SEN(select),			"_newselect"		},
[143] = { 2,	TD,		SEN(flock),			"flock"			},
[144] = { 3,	TM,		SEN(msync),			"msync"			},
[145] = { 3,	TD,		SEN(readv),			"readv"			},
[146] = { 3,	TD,		SEN(writev),			"writev"		},
[147] = { 1,	0,		SEN(getsid),			"getsid"		},
[148] = { 1,	TD,		SEN(fdatasync),			"fdatasync"		},
[149] = { 1,	0,		SEN(sysctl),			"_sysctl"		},
[150] = { 2,	TM,		SEN(mlock),			"mlock"			},
[151] = { 2,	TM,		SEN(munlock),			"munlock"		},
[152] = { 1,	TM,		SEN(mlockall),			"mlockall"		},
[153] = { 0,	TM,		SEN(munlockall),		"munlockall"		},
[154] = { 2,	0,		SEN(sched_setparam),		"sched_setparam"	},
[155] = { 2,	0,		SEN(sched_getparam),		"sched_getparam"	},
[156] = { 3,	0,		SEN(sched_setscheduler),	"sched_setscheduler"	},
[157] = { 1,	0,		SEN(sched_getscheduler),	"sched_getscheduler"	},
[158] = { 0,	0,		SEN(sched_yield),		"sched_yield"		},
[159] = { 1,	0,		SEN(sched_get_priority_max),	"sched_get_priority_max"},
[160] = { 1,	0,		SEN(sched_get_priority_min),	"sched_get_priority_min"},
[161] = { 2,	0,		SEN(sched_rr_get_interval_time32),"sched_rr_get_interval"},
[162] = { 2,	0,		SEN(nanosleep_time32),		"nanosleep"		},
[163] = { 5,	TM|SI,		SEN(mremap),			"mremap"		},
[164] = { 3,	TC,		SEN(setresuid16),		"setresuid"		},
[165] = { 3,	TC,		SEN(getresuid16),		"getresuid"		},
[166] = { },
[167] = { 5,	0,		SEN(query_module),		"query_module"		},
[168] = { 3,	TD,		SEN(poll_time32),		"poll"			},
[169] = { 3,	0,		SEN(nfsservctl),		"nfsservctl"		},
[170] = { 3,	TC,		SEN(setresgid16),		"setresgid"		},
[171] = { 3,	TC,		SEN(getresgid16),		"getresgid"		},
[172] = { 5,	TC,		SEN(prctl),			"prctl"			},
[173] = { 0,	TS,		SEN(rt_sigreturn),		"rt_sigreturn"		},
[174] = { 4,	TS,		SEN(rt_sigaction),		"rt_sigaction"		},
[175] = { 4,	TS,		SEN(rt_sigprocmask),		"rt_sigprocmask"	},
[176] = { 2,	TS,		SEN(rt_sigpending),		"rt_sigpending"		},
[177] = { 4,	TS,		SEN(rt_sigtimedwait_time32),	"rt_sigtimedwait"	},
[178] = { 3,	TS,		SEN(rt_sigqueueinfo),		"rt_sigqueueinfo"	},
[179] = { 2,	TS,		SEN(rt_sigsuspend),		"rt_sigsuspend"		},
[180] = { 5,	TD,		SEN(pread),			"pread64"		},
[181] = { 5,	TD,		SEN(pwrite),			"pwrite64"		},
[182] = { 3,	TF,		SEN(chown16),			"chown"			},
[183] = { 2,	TF,		SEN(getcwd),			"getcwd"		},
[184] = { 2,	TC,		SEN(capget),			"capget"		},
[185] = { 2,	TC,		SEN(capset),			"capset"		},
[186] = { 2,	TS,		SEN(sigaltstack),		"sigaltstack"		},
[187] = { 4,	TD|TN,		SEN(sendfile),			"sendfile"		},
[188] = { 5,	TN,		SEN(getpmsg),			"getpmsg"		},
[189] = { 5,	TN,		SEN(putpmsg),			"putpmsg"		},
[190] = { 0,	TP,		SEN(vfork),			"vfork"			},
[191] = { 2,	0,		SEN(getrlimit),			"ugetrlimit"		},
[192] = { 1,	TD|TM|SI,	SEN(old_mmap_pgoff),		"mmap2"			},
[193] = { 3,	TF,		SEN(truncate64),		"truncate64"		},
[194] = { 3,	TD,		SEN(ftruncate64),		"ftruncate64"		},
[195] = { 2,	TF|TST|TSTA,	SEN(stat64),			"stat64"		},
[196] = { 2,	TF|TLST|TSTA,	SEN(lstat64),			"lstat64"		},
[197] = { 2,	TD|TFST|TSTA,	SEN(fstat64),			"fstat64"		},
[198] = { 3,	TF,		SEN(chown),			"lchown32"		},
[199] = { 0,	TC|PU|NF,	SEN(getuid),			"getuid32"		},
[200] = { 0,	TC|PU|NF,	SEN(getgid),			"getgid32"		},
[201] = { 0,	TC|PU|NF,	SEN(geteuid),			"geteuid32"		},
[202] = { 0,	TC|PU|NF,	SEN(getegid),			"getegid32"		},
[203] = { 2,	TC,		SEN(setreuid),			"setreuid32"		},
[204] = { 2,	TC,		SEN(setregid),			"setregid32"		},
[205] = { 2,	TC,		SEN(getgroups),			"getgroups32"		},
[206] = { 2,	TC,		SEN(setgroups),			"setgroups32"		},
[207] = { 3,	TD,		SEN(fchown),			"fchown32"		},
[208] = { 3,	TC,		SEN(setresuid),			"setresuid32"		},
[209] = { 3,	TC,		SEN(getresuid),			"getresuid32"		},
[210] = { 3,	TC,		SEN(setresgid),			"setresgid32"		},
[211] = { 3,	TC,		SEN(getresgid),			"getresgid32"		},
[212] = { 3,	TF,		SEN(chown),			"chown32"		},
[213] = { 1,	TC,		SEN(setuid),			"setuid32"		},
[214] = { 1,	TC,		SEN(setgid),			"setgid32"		},
[215] = { 1,	TC|NF,		SEN(setfsuid),			"setfsuid32"		},
[216] = { 1,	TC|NF,		SEN(setfsgid),			"setfsgid32"		},
[217] = { 2,	TF,		SEN(pivotroot),			"pivot_root"		},
[218] = { 3,	TM,		SEN(mincore),			"mincore"		},
[219] = { 3,	TM,		SEN(madvise),			"madvise"		},
[220] = { 3,	TD,		SEN(getdents64),		"getdents64"		},
[221] = { 3,	TD,		SEN(fcntl64),			"fcntl64"		},
[222] = { 4,	TD,		SEN(readahead),			"readahead"		},
[223] = { 4,	TD|TN,		SEN(sendfile64),		"sendfile64"		},
[224] = { 5,	TF,		SEN(setxattr),			"setxattr"		},
[225] = { 5,	TF,		SEN(setxattr),			"lsetxattr"		},
[226] = { 5,	TD,		SEN(fsetxattr),			"fsetxattr"		},
[227] = { 4,	TF,		SEN(getxattr),			"getxattr"		},
[228] = { 4,	TF,		SEN(getxattr),			"lgetxattr"		},
[229] = { 4,	TD,		SEN(fgetxattr),			"fgetxattr"		},
[230] = { 3,	TF,		SEN(listxattr),			"listxattr"		},
[231] = { 3,	TF,		SEN(listxattr),			"llistxattr"		},
[232] = { 3,	TD,		SEN(flistxattr),		"flistxattr"		},
[233] = { 2,	TF,		SEN(removexattr),		"removexattr"		},
[234] = { 2,	TF,		SEN(removexattr),		"lremovexattr"		},
[235] = { 2,	TD,		SEN(fremovexattr),		"fremovexattr"		},
[236] = { 0,	PU|NF,		SEN(gettid),			"gettid"		},
[237] = { 2,	TS,		SEN(kill),			"tkill"			},
[238] = { 6,	0,		SEN(futex_time32),		"futex"			},
[239] = { 3,	0,		SEN(sched_setaffinity),		"sched_setaffinity"	},
[240] = { 3,	0,		SEN(sched_getaffinity),		"sched_getaffinity"	},
[241] = { 3,	TS,		SEN(tgkill),			"tgkill"		},
[242] = { },
[243] = { 2,	TM,		SEN(io_setup),			"io_setup"		},
[244] = { 1,	TM,		SEN(io_destroy),		"io_destroy"		},
[245] = { 5,	0,		SEN(io_getevents_time32),	"io_getevents"		},
[246] = { 3,	0,		SEN(io_submit),			"io_submit"		},
[247] = { 3,	0,		SEN(io_cancel),			"io_cancel"		},
[248] = { 1,	TP|SE,		SEN(exit),			"exit_group"		},
[249] = { 1,	TD,		SEN(epoll_create),		"epoll_create"		},
[250] = { 4,	TD,		SEN(epoll_ctl),			"epoll_ctl"		},
[251] = { 4,	TD,		SEN(epoll_wait),		"epoll_wait"		},
[252] = { 1,	0,		SEN(set_tid_address),		"set_tid_address"	},
[253] = { 5,	TD,		SEN(fadvise64),			"fadvise64"		},
[254] = { 3,	0,		SEN(timer_create),		"timer_create"		},
[255] = { 4,	0,		SEN(timer_settime32),		"timer_settime"		},
[256] = { 2,	0,		SEN(timer_gettime32),		"timer_gettime"		},
[257] = { 1,	0,		SEN(timer_getoverrun),		"timer_getoverrun"	},
[258] = { 1,	0,		SEN(timer_delete),		"timer_delete"		},
[259] = { 2,	0,		SEN(clock_settime32),		"clock_settime"		},
[260] = { 2,	0,		SEN(clock_gettime32),		"clock_gettime"		},
[261] = { 2,	0,		SEN(clock_getres_time32),	"clock_getres"		},
[262] = { 4,	0,		SEN(clock_nanosleep_time32),	"clock_nanosleep"	},
[263] = { 5,	0,		SEN(vserver),			"vserver"		},
[264] = { 6,	TD,		SEN(fadvise64_64),		"fadvise64_64"		},
[265] = { 3,	TF|TSF|TSFA,	SEN(statfs64),			"statfs64"		},
[266] = { 3,	TD|TFSF|TSFA,	SEN(fstatfs64),			"fstatfs64"		},
[267] = { 5,	TM|SI,		SEN(remap_file_pages),		"remap_file_pages"	},
[268] = { 6,	TM,		SEN(mbind),			"mbind"			},
[269] = { 5,	TM,		SEN(get_mempolicy),		"get_mempolicy"		},
[270] = { 3,	TM,		SEN(set_mempolicy),		"set_mempolicy"		},
[271] = { 4,	TD,		SEN(mq_open),			"mq_open"		},
[272] = { 1,	0,		SEN(mq_unlink),			"mq_unlink"		},
[273] = { 5,	TD,		SEN(mq_timedsend_time32),	"mq_timedsend"		},
[274] = { 5,	TD,		SEN(mq_timedreceive_time32),	"mq_timedreceive"	},
[275] = { 2,	TD,		SEN(mq_notify),			"mq_notify"		},
[276] = { 3,	TD,		SEN(mq_getsetattr),		"mq_getsetattr"		},
[277] = { 4,	0,		SEN(kexec_load),		"kexec_load"		},
[278] = { 5,	0,		SEN(add_key),			"add_key"		},
[279] = { 4,	0,		SEN(request_key),		"request_key"		},
[280] = { 5,	0,		SEN(keyctl),			"keyctl"		},
[281] = { 5,	TP,		SEN(waitid),			"waitid"		},
[282] = { 3,	0,		SEN(ioprio_set),		"ioprio_set"		},
[283] = { 2,	0,		SEN(ioprio_get),		"ioprio_get"		},
[284] = { 0,	TD,		SEN(inotify_init),		"inotify_init"		},
[285] = { 3,	TD|TF,		SEN(inotify_add_watch),		"inotify_add_watch"	},
[286] = { 2,	TD,		SEN(inotify_rm_watch),		"inotify_rm_watch"	},
[287] = { 4,	TM,		SEN(migrate_pages),		"migrate_pages"		},
[288] = { 4,	TD|TF,		SEN(openat),			"openat"		},
[289] = { 3,	TD|TF,		SEN(mkdirat),			"mkdirat"		},
[290] = { 4,	TD|TF,		SEN(mknodat),			"mknodat"		},
[291] = { 5,	TD|TF,		SEN(fchownat),			"fchownat"		},
[292] = { 3,	TD|TF,		SEN(futimesat),			"futimesat"		},
[293] = { 4,	TD|TF|TFST|TSTA,SEN(fstatat64),			"fstatat64"		},
[294] = { 3,	TD|TF,		SEN(unlinkat),			"unlinkat"		},
[295] = { 4,	TD|TF,		SEN(renameat),			"renameat"		},
[296] = { 5,	TD|TF,		SEN(linkat),			"linkat"		},
[297] = { 3,	TD|TF,		SEN(symlinkat),			"symlinkat"		},
[298] = { 4,	TD|TF,		SEN(readlinkat),		"readlinkat"		},
[299] = { 3,	TD|TF,		SEN(fchmodat),			"fchmodat"		},
[300] = { 3,	TD|TF,		SEN(faccessat),			"faccessat"		},
[301] = { 6,	TD,		SEN(pselect6_time32),		"pselect6"		},
[302] = { 5,	TD,		SEN(ppoll_time32),		"ppoll"			},
[303] = { 1,	TP,		SEN(unshare),			"unshare"		},
[304] = { 2,	0,		SEN(set_robust_list),		"set_robust_list"	},
[305] = { 3,	0,		SEN(get_robust_list),		"get_robust_list"	},
[306] = { 6,	TD,		SEN(splice),			"splice"		},
[307] = { 6,	TD,		SEN(sync_file_range),		"sync_file_range"	},
[308] = { 4,	TD,		SEN(tee),			"tee"			},
[309] = { 4,	TD,		SEN(vmsplice),			"vmsplice"		},
[310] = { 6,	TM,		SEN(move_pages),		"move_pages"		},
[311] = { 3,	0,		SEN(getcpu),			"getcpu"		},
[312] = { 6,	TD,		SEN(epoll_pwait),		"epoll_pwait"		},
[313] = { 2,	TF,		SEN(utimes),			"utimes"		},
[314] = { 6,	TD,		SEN(fallocate),			"fallocate"		},
[315] = { 4,	TD|TF,		SEN(utimensat_time32),		"utimensat"		},
[316] = { 3,	TD|TS,		SEN(signalfd),			"signalfd"		},
[317] = { 4,	TD,		SEN(timerfd),			"timerfd"		},
[318] = { 1,	TD,		SEN(eventfd),			"eventfd"		},
[319] = { 2,	TD,		SEN(timerfd_create),		"timerfd_create"	},
[320] = { 4,	TD,		SEN(timerfd_settime32),		"timerfd_settime"	},
[321] = { 2,	TD,		SEN(timerfd_gettime32),		"timerfd_gettime"	},
[322] = { 4,	TD|TS,		SEN(signalfd4),			"signalfd4"		},
[323] = { 2,	TD,		SEN(eventfd2),			"eventfd2"		},
[324] = { 1,	TD,		SEN(inotify_init1),		"inotify_init1"		},
[325] = { 2,	TD,		SEN(pipe2),			"pipe2"			},
[326] = { 3,	TD,		SEN(dup3),			"dup3"			},
[327] = { 1,	TD,		SEN(epoll_create1),		"epoll_create1"		},
[328] = { 5,	TD,		SEN(preadv),			"preadv"		},
[329] = { 5,	TD,		SEN(pwritev),			"pwritev"		},
[330] = { 4,	TP|TS,		SEN(rt_tgsigqueueinfo),		"rt_tgsigqueueinfo"	},
[331] = { 5,	TD,		SEN(perf_event_open),		"perf_event_open"	},
[332] = { 2,	TD,		SEN(fanotify_init),		"fanotify_init"		},
[333] = { 6,	TD|TF,		SEN(fanotify_mark),		"fanotify_mark"		},
[334] = { 4,	0,		SEN(prlimit64),			"prlimit64"		},
[335] = { 5,	TD|TF,		SEN(name_to_handle_at),		"name_to_handle_at"	},
[336] = { 3,	TD,		SEN(open_by_handle_at),		"open_by_handle_at"	},
[337] = { 2,	0,		SEN(clock_adjtime32),		"clock_adjtime"		},
[338] = { 1,	TD,		SEN(syncfs),			"syncfs"		},
[339] = { 2,	TD,		SEN(setns),			"setns"			},
[340] = { 6,	0,		SEN(process_vm_readv),		"process_vm_readv"	},
[341] = { 6,	0,		SEN(process_vm_writev),		"process_vm_writev"	},
[342] = { 2,	0,		SEN(s390_runtime_instr),	"s390_runtime_instr"	},
[343] = { 5,	0,		SEN(kcmp),			"kcmp"			},
[344] = { 3,	TD,		SEN(finit_module),		"finit_module"		},
[345] = { 3,	0,		SEN(sched_setattr),		"sched_setattr"		},
[346] = { 4,	0,		SEN(sched_getattr),		"sched_getattr"		},
[347] = { 5,	TD|TF,		SEN(renameat2),			"renameat2"		},
[348] = { 3,	0,		SEN(seccomp),			"seccomp"		},
[349] = { 3,	0,		SEN(getrandom),			"getrandom"		},
[350] = { 2,	TD,		SEN(memfd_create),		"memfd_create"		},
[351] = { 3,	TD,		SEN(bpf),			"bpf"			},
[352] = { 3,	0,		SEN(s390_pci_mmio_write),	"s390_pci_mmio_write"	},
[353] = { 3,	0,		SEN(s390_pci_mmio_read),	"s390_pci_mmio_read"	},
[354] = { 5,	TD|TF|TP|TSD|SE|SI,	SEN(execveat),			"execveat"		},
[355] = { 1,	TD,		SEN(userfaultfd),		"userfaultfd"		},
[356] = { 2,	0,		SEN(membarrier),		"membarrier"		},
[357] = { 5,	TN,		SEN(recvmmsg_time32),		"recvmmsg"		},
[358] = { 4,	TN,		SEN(sendmmsg),			"sendmmsg"		},
[359] = { 3,	TN,		SEN(socket),			"socket"		},
[360] = { 4,	TN,		SEN(socketpair),		"socketpair"		},
[361] = { 3,	TN,		SEN(bind),			"bind"			},
[362] = { 3,	TN,		SEN(connect),			"connect"		},
[363] = { 2,	TN,		SEN(listen),			"listen"		},
[364] = { 4,	TN,		SEN(accept4),			"accept4"		},
[365] = { 5,	TN,		SEN(getsockopt),		"getsockopt"		},
[366] = { 5,	TN,		SEN(setsockopt),		"setsockopt"		},
[367] = { 3,	TN,		SEN(getsockname),		"getsockname"		},
[368] = { 3,	TN,		SEN(getpeername),		"getpeername"		},
[369] = { 6,	TN,		SEN(sendto),			"sendto"		},
[370] = { 3,	TN,		SEN(sendmsg),			"sendmsg"		},
[371] = { 6,	TN,		SEN(recvfrom),			"recvfrom"		},
[372] = { 3,	TN,		SEN(recvmsg),			"recvmsg"		},
[373] = { 2,	TN,		SEN(shutdown),			"shutdown"		},
[374] = { 3,	TM,		SEN(mlock2),			"mlock2"		},
[375] = { 6,	TD,		SEN(copy_file_range),		"copy_file_range"	},
[376] = { 6,	TD,		SEN(preadv2),			"preadv2"		},
[377] = { 6,	TD,		SEN(pwritev2),			"pwritev2"		},
[378] = { 2,	0,		SEN(s390_guarded_storage),	"s390_guarded_storage"	},
[379] = { 5,	TD|TF|TSTA,	SEN(statx),			"statx"			},
[380] = { 4,	0,		SEN(s390_sthyi),		"s390_sthyi"		},
[381] = { 5,	TD,		SEN(kexec_file_load),		"kexec_file_load"	},
[382] = { 6,	0,		SEN(io_pgetevents_time32),	"io_pgetevents"		},
[383] = { 4,	0,		SEN(rseq),			"rseq"			},
[384] = { 4,	TM|SI,		SEN(pkey_mprotect),		"pkey_mprotect"		},
[385] = { 2,	0,		SEN(pkey_alloc),		"pkey_alloc"		},
[386] = { 1,	0,		SEN(pkey_free),			"pkey_free"		},
/* room for arch specific calls */
[393] = { 3,	TI,		SEN(semget),			"semget"		},
[394] = { 4,	TI,		SEN(semctl),			"semctl"		},
[395] = { 3,	TI,		SEN(shmget),			"shmget"		},
[396] = { 3,	TI,		SEN(shmctl),			"shmctl"		},
[397] = { 3,	TI|TM|SI,	SEN(shmat),			"shmat"			},
[398] = { 1,	TI|TM|SI,	SEN(shmdt),			"shmdt"			},
[399] = { 2,	TI,		SEN(msgget),			"msgget"		},
[400] = { 4,	TI,		SEN(msgsnd),			"msgsnd"		},
[401] = { 5,	TI,		SEN(msgrcv),			"msgrcv"		},
[402] = { 3,	TI,		SEN(msgctl),			"msgctl"		},
#include "syscallent-common-32.h"
#include "syscallent-common.h"

#define SYS_socket_subcall	500
#include "subcall32.h"
