The `feature` value is missing in a stability attribute.

Erroneous code example:

```compile_fail,E0546
#![feature(staged_api)]
#![stable(since = "1.0.0", feature = "test")]

#[unstable(issue = "none")] // invalid
fn unstable_fn() {}

#[stable(since = "1.0.0")] // invalid
fn stable_fn() {}
```

To fix this issue, you need to provide the `feature` field. Example:

```
#![feature(staged_api)]
#![stable(since = "1.0.0", feature = "test")]

#[unstable(feature = "unstable_fn", issue = "none")] // ok!
fn unstable_fn() {}

#[stable(feature = "stable_fn", since = "1.0.0")] // ok!
fn stable_fn() {}
```

See the [How Rust is Made and “Nightly Rust”][how-rust-made-nightly] appendix
of the Book and the [Stability attributes][stability-attributes] section of the
Rustc Dev Guide for more details.

[how-rust-made-nightly]: https://doc.rust-lang.org/book/appendix-07-nightly-rust.html
[stability-attributes]: https://rustc-dev-guide.rust-lang.org/stability.html
