/*
 * Remmina - The GTK+ Remote Desktop Client
 * Copyright (C) 2009-2010 Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU General Public License in all respects
 *  for all of the code used other than OpenSSL. *  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so. *  If you
 *  do not wish to do so, delete this exception statement from your
 *  version. *  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __REMMINAAVAHI_H__
#define __REMMINAAVAHI_H__

G_BEGIN_DECLS

typedef struct _RemminaAvahiPriv RemminaAvahiPriv;

typedef struct _RemminaAvahi
{
	GHashTable *discovered_services;
	gboolean started;

	RemminaAvahiPriv *priv;
} RemminaAvahi;

RemminaAvahi* remmina_avahi_new(void);
void remmina_avahi_start(RemminaAvahi* ga);
void remmina_avahi_stop(RemminaAvahi* ga);
void remmina_avahi_free(RemminaAvahi* ga);

G_END_DECLS

#endif  /* __REMMINAAVAHI_H__  */

