/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/CafInstallRequestXml/GetInventoryJobXml.h"
#include "Doc/DocXml/CafInstallRequestXml/InstallProviderJobXml.h"
#include "Doc/DocXml/CafInstallRequestXml/UninstallProviderJobXml.h"

#include "Doc/CafInstallRequestDoc/CGetInventoryJobDoc.h"
#include "Doc/CafInstallRequestDoc/CInstallBatchDoc.h"
#include "Doc/CafInstallRequestDoc/CInstallProviderJobDoc.h"
#include "Doc/CafInstallRequestDoc/CUninstallProviderJobDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafInstallRequestXml/InstallBatchXml.h"

using namespace Caf;

void InstallBatchXml::add(
	const SmartPtrCInstallBatchDoc installBatchDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("InstallBatchXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(installBatchDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const SmartPtrCGetInventoryJobDoc getInventoryVal =
			installBatchDoc->getGetInventory();
		if (! getInventoryVal.IsNull()) {
			const SmartPtrCXmlElement getInventoryXml =
				thisXml->createAndAddElement("getInventory");
			GetInventoryJobXml::add(getInventoryVal, getInventoryXml);
		}

		const SmartPtrCInstallProviderJobDoc installProviderVal =
			installBatchDoc->getInstallProvider();
		if (! installProviderVal.IsNull()) {
			const SmartPtrCXmlElement installProviderXml =
				thisXml->createAndAddElement("installProvider");
			InstallProviderJobXml::add(installProviderVal, installProviderXml);
		}

		const SmartPtrCUninstallProviderJobDoc uninstallProviderVal =
			installBatchDoc->getUninstallProvider();
		if (! uninstallProviderVal.IsNull()) {
			const SmartPtrCXmlElement uninstallProviderXml =
				thisXml->createAndAddElement("uninstallProvider");
			UninstallProviderJobXml::add(uninstallProviderVal, uninstallProviderXml);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCInstallBatchDoc InstallBatchXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("InstallBatchXml", "parse");

	SmartPtrCInstallBatchDoc installBatchDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const SmartPtrCXmlElement getInventoryXml =
			thisXml->findOptionalChild("getInventory");

		SmartPtrCGetInventoryJobDoc getInventoryVal;
		if (! getInventoryXml.IsNull()) {
			getInventoryVal = GetInventoryJobXml::parse(getInventoryXml);
		}

		const SmartPtrCXmlElement installProviderXml =
			thisXml->findOptionalChild("installProvider");

		SmartPtrCInstallProviderJobDoc installProviderVal;
		if (! installProviderXml.IsNull()) {
			installProviderVal = InstallProviderJobXml::parse(installProviderXml);
		}

		const SmartPtrCXmlElement uninstallProviderXml =
			thisXml->findOptionalChild("uninstallProvider");

		SmartPtrCUninstallProviderJobDoc uninstallProviderVal;
		if (! uninstallProviderXml.IsNull()) {
			uninstallProviderVal = UninstallProviderJobXml::parse(uninstallProviderXml);
		}

		installBatchDoc.CreateInstance();
		installBatchDoc->initialize(
			getInventoryVal,
			installProviderVal,
			uninstallProviderVal);
	}
	CAF_CM_EXIT;

	return installBatchDoc;
}

