// |reftest| skip -- regexp-unicode-property-escapes is not supported
// Copyright 2019 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script_Extensions=Mende_Kikakui`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v12.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x01E800, 0x01E8C4],
    [0x01E8C7, 0x01E8D6]
  ]
});
testPropertyEscapes(
  /^\p{Script_Extensions=Mende_Kikakui}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Mende_Kikakui}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Mend}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Mend}"
);
testPropertyEscapes(
  /^\p{scx=Mende_Kikakui}+$/u,
  matchSymbols,
  "\\p{scx=Mende_Kikakui}"
);
testPropertyEscapes(
  /^\p{scx=Mend}+$/u,
  matchSymbols,
  "\\p{scx=Mend}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x01E7FF],
    [0x01E8C5, 0x01E8C6],
    [0x01E8D7, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script_Extensions=Mende_Kikakui}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Mende_Kikakui}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Mend}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Mend}"
);
testPropertyEscapes(
  /^\P{scx=Mende_Kikakui}+$/u,
  nonMatchSymbols,
  "\\P{scx=Mende_Kikakui}"
);
testPropertyEscapes(
  /^\P{scx=Mend}+$/u,
  nonMatchSymbols,
  "\\P{scx=Mend}"
);

reportCompare(0, 0);
