// |reftest| skip -- regexp-unicode-property-escapes is not supported
// Copyright 2019 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Egyptian_Hieroglyphs`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v12.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x013000, 0x01342E],
    [0x013430, 0x013438]
  ]
});
testPropertyEscapes(
  /^\p{Script=Egyptian_Hieroglyphs}+$/u,
  matchSymbols,
  "\\p{Script=Egyptian_Hieroglyphs}"
);
testPropertyEscapes(
  /^\p{Script=Egyp}+$/u,
  matchSymbols,
  "\\p{Script=Egyp}"
);
testPropertyEscapes(
  /^\p{sc=Egyptian_Hieroglyphs}+$/u,
  matchSymbols,
  "\\p{sc=Egyptian_Hieroglyphs}"
);
testPropertyEscapes(
  /^\p{sc=Egyp}+$/u,
  matchSymbols,
  "\\p{sc=Egyp}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [
    0x01342F
  ],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x012FFF],
    [0x013439, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Egyptian_Hieroglyphs}+$/u,
  nonMatchSymbols,
  "\\P{Script=Egyptian_Hieroglyphs}"
);
testPropertyEscapes(
  /^\P{Script=Egyp}+$/u,
  nonMatchSymbols,
  "\\P{Script=Egyp}"
);
testPropertyEscapes(
  /^\P{sc=Egyptian_Hieroglyphs}+$/u,
  nonMatchSymbols,
  "\\P{sc=Egyptian_Hieroglyphs}"
);
testPropertyEscapes(
  /^\P{sc=Egyp}+$/u,
  nonMatchSymbols,
  "\\P{sc=Egyp}"
);

reportCompare(0, 0);
