// For documentation of the format, see README in this directory.
var browserTests = [
["foo[]bar",
    [["strikethrough",""]],
    "foo[]bar",
    [true],
    {"strikethrough":[false,false,"",false,true,""]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<p><span style=\"text-decoration:line-through\">[foo</span></p> <p><span style=\"text-decoration:line-through\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<p><s>[foo</s></p> <p><s>bar]</s></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\"><span>[foo</span> <span>bar]</span></span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s><span>[foo</span> <span>bar]</span></s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<p><span style=\"text-decoration:line-through\">[foo</span></p><p> <span style=\"text-decoration:line-through\"><span>bar</span></span> </p><p><span style=\"text-decoration:line-through\">baz]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<p><s>[foo</s></p><p> <s><span>bar</span></s> </p><p><s>baz]</s></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","true"],["strikethrough",""]],
    "<p><span style=\"text-decoration:line-through\">[foo</span></p><p><span style=\"text-decoration:line-through\"><br></span></p><p><span style=\"text-decoration:line-through\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","false"],["strikethrough",""]],
    "<p><s>[foo</s></p><p><s><br></s></p><p><s>bar]</s></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<b>foo[]bar</b>",
    [["strikethrough",""]],
    "<b>foo[]bar</b>",
    [true],
    {"strikethrough":[false,false,"",false,true,""]}],
["<i>foo[]bar</i>",
    [["strikethrough",""]],
    "<i>foo[]bar</i>",
    [true],
    {"strikethrough":[false,false,"",false,true,""]}],
["<span>foo</span>{}<span>bar</span>",
    [["strikethrough",""]],
    "<span>foo</span>{}<span>bar</span>",
    [true],
    {"strikethrough":[false,false,"",false,true,""]}],
["<span>foo[</span><span>]bar</span>",
    [["strikethrough",""]],
    "<span>foo[</span><span>]bar</span>",
    [true],
    {"strikethrough":[false,false,"",false,true,""]}],
["foo[bar]baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:line-through\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo[bar]baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<s>[bar]</s>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:line-through\">[bar</span><b><span style=\"text-decoration:line-through\">baz]</span>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<s>[bar</s><b><s>baz]</s>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:line-through\">[bar</span><i><span style=\"text-decoration:line-through\">baz]</span>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<s>[bar</s><i><s>baz]</s>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","true"],["strikethrough",""]],
    "{<p></p><p> </p><p><span style=\"text-decoration:line-through\">foo</span></p>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","false"],["strikethrough",""]],
    "{<p></p><p> </p><p><s>foo</s></p>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<table><tbody><tr><td>foo</td><td>b<span style=\"text-decoration:line-through\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<table><tbody><tr><td>foo</td><td>b<s>[a]</s>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<table><tbody><tr><td>foo</td>{<td><span style=\"text-decoration:line-through\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<table><tbody><tr><td>foo</td>{<td><s>bar</s></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<table><tbody><tr>{<td><span style=\"text-decoration:line-through\">foo</span></td><td><span style=\"text-decoration:line-through\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<table><tbody><tr>{<td><s>foo</s></td><td><s>bar</s></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<table><tbody>{<tr><td><span style=\"text-decoration:line-through\">foo</span></td><td><span style=\"text-decoration:line-through\">bar</span></td><td><span style=\"text-decoration:line-through\">baz</span></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<table><tbody>{<tr><td><s>foo</s></td><td><s>bar</s></td><td><s>baz</s></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<table>{<tbody><tr><td><span style=\"text-decoration:line-through\">foo</span></td><td><span style=\"text-decoration:line-through\">bar</span></td><td><span style=\"text-decoration:line-through\">baz</span></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<table>{<tbody><tr><td><s>foo</s></td><td><s>bar</s></td><td><s>baz</s></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","true"],["strikethrough",""]],
    "{<table><tbody><tr><td><span style=\"text-decoration:line-through\">foo</span></td><td><span style=\"text-decoration:line-through\">bar</span></td><td><span style=\"text-decoration:line-through\">baz</span></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","false"],["strikethrough",""]],
    "{<table><tbody><tr><td><s>foo</s></td><td><s>bar</s></td><td><s>baz</s></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<u>[bar]</u>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:line-through\"><u>[bar]</u></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<u>[bar]</u>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<s><u>[bar]</u></s>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<span style=\"text-decoration: underline\">[bar]</span>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:line-through\"><span style=\"text-decoration:underline\">[bar]</span></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<span style=\"text-decoration: underline\">[bar]</span>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<s><span style=\"text-decoration:underline\">[bar]</span></s>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[bar]baz</u>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<u>foo<span style=\"text-decoration:line-through\">[bar]</span>baz</u>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[bar]baz</u>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<u>foo<s>[bar]</s>baz</u>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[b<span style=\"color:blue\">ar]ba</span>z</u>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<u>foo<span style=\"text-decoration:line-through\">[b</span><span style=\"color:rgb(0, 0, 255)\"><span style=\"text-decoration:line-through\">ar]</span>ba</span>z</u>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[b<span style=\"color:blue\">ar]ba</span>z</u>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<u>foo<s>[b</s><span style=\"color:rgb(0, 0, 255)\"><s>ar]</s>ba</span>z</u>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</u>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<u>foo<span style=\"text-decoration:line-through\">[b</span><span style=\"color:rgb(0, 0, 255)\" id=\"foo\"><span style=\"text-decoration:line-through\">ar]</span>ba</span>z</u>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</u>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<u>foo<s>[b</s><span style=\"color:rgb(0, 0, 255)\" id=\"foo\"><s>ar]</s>ba</span>z</u>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[b<span style=\"font-size:3em\">ar]ba</span>z</u>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<u>foo<span style=\"text-decoration:line-through\">[b</span><span style=\"font-size:3em\"><span style=\"text-decoration:line-through\">ar]</span>ba</span>z</u>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[b<span style=\"font-size:3em\">ar]ba</span>z</u>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<u>foo<s>[b</s><span style=\"font-size:3em\"><s>ar]</s>ba</span>z</u>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[b<i>ar]ba</i>z</u>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<u>foo<span style=\"text-decoration:line-through\">[b</span><i><span style=\"text-decoration:line-through\">ar]</span>ba</i>z</u>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[b<i>ar]ba</i>z</u>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<u>foo<s>[b</s><i><s>ar]</s>ba</i>z</u>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<p style=\"text-decoration: underline\">foo[bar]baz</p>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<p style=\"text-decoration:underline\">foo<span style=\"text-decoration:line-through\">[bar]</span>baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<p style=\"text-decoration: underline\">foo[bar]baz</p>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<p style=\"text-decoration:underline\">foo<s>[bar]</s>baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<span style=\"text-decoration: line-through\">[bar]</span>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<span style=\"text-decoration: line-through\">[bar]</span>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[bar]baz</s>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\">foo</span>[bar]<span style=\"text-decoration:line-through\">baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[bar]baz</s>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>foo</s>[bar]<s>baz</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[b<span style=\"color:blue\">ar]ba</span>z</s>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\">foo</span>[b<span style=\"color:rgb(0, 0, 255)\">ar]<span style=\"text-decoration:line-through\">ba</span></span><span style=\"text-decoration:line-through\">z</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[b<span style=\"color:blue\">ar]ba</span>z</s>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>foo</s>[b<span style=\"color:rgb(0, 0, 255)\">ar]<s>ba</s></span><s>z</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</s>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\">foo</span>[b<span style=\"color:rgb(0, 0, 255)\" id=\"foo\">ar]<span style=\"text-decoration:line-through\">ba</span></span><span style=\"text-decoration:line-through\">z</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</s>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>foo</s>[b<span style=\"color:rgb(0, 0, 255)\" id=\"foo\">ar]<s>ba</s></span><s>z</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[b<span style=\"font-size:3em\">ar]ba</span>z</s>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\">foo</span>[b<span style=\"font-size:3em\">ar]<span style=\"text-decoration:line-through\">ba</span></span><span style=\"text-decoration:line-through\">z</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[b<span style=\"font-size:3em\">ar]ba</span>z</s>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>foo</s>[b<span style=\"font-size:3em\">ar]<s>ba</s></span><s>z</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[b<i>ar]ba</i>z</s>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\">foo</span>[b<i>ar]<span style=\"text-decoration:line-through\">ba</span></i><span style=\"text-decoration:line-through\">z</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[b<i>ar]ba</i>z</s>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>foo</s>[b<i>ar]<s>ba</s></i><s>z</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<strike>[bar]</strike>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<strike>[bar]</strike>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[bar]baz</strike>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\">foo</span>[bar]<span style=\"text-decoration:line-through\">baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[bar]baz</strike>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>foo</s>[bar]<s>baz</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[b<span style=\"color:blue\">ar]ba</span>z</strike>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\">foo</span>[b<span style=\"color:rgb(0, 0, 255)\">ar]<span style=\"text-decoration:line-through\">ba</span></span><span style=\"text-decoration:line-through\">z</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[b<span style=\"color:blue\">ar]ba</span>z</strike>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>foo</s>[b<span style=\"color:rgb(0, 0, 255)\">ar]<s>ba</s></span><s>z</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</strike>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\">foo</span>[b<span style=\"color:rgb(0, 0, 255)\" id=\"foo\">ar]<span style=\"text-decoration:line-through\">ba</span></span><span style=\"text-decoration:line-through\">z</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</strike>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>foo</s>[b<span style=\"color:rgb(0, 0, 255)\" id=\"foo\">ar]<s>ba</s></span><s>z</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[b<span style=\"font-size:3em\">ar]ba</span>z</strike>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\">foo</span>[b<span style=\"font-size:3em\">ar]<span style=\"text-decoration:line-through\">ba</span></span><span style=\"text-decoration:line-through\">z</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[b<span style=\"font-size:3em\">ar]ba</span>z</strike>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>foo</s>[b<span style=\"font-size:3em\">ar]<s>ba</s></span><s>z</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[b<i>ar]ba</i>z</strike>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\">foo</span>[b<i>ar]<span style=\"text-decoration:line-through\">ba</span></i><span style=\"text-decoration:line-through\">z</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[b<i>ar]ba</i>z</strike>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>foo</s>[b<i>ar]<s>ba</s></i><s>z</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<ins>[bar]</ins>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:line-through\"><ins>[bar]</ins></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<ins>[bar]</ins>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<s><ins>[bar]</ins></s>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[bar]baz</ins>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<ins>foo<span style=\"text-decoration:line-through\">[bar]</span>baz</ins>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[bar]baz</ins>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<ins>foo<s>[bar]</s>baz</ins>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[b<span style=\"color:blue\">ar]ba</span>z</ins>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<ins>foo<span style=\"text-decoration:line-through\">[b</span><span style=\"color:rgb(0, 0, 255)\"><span style=\"text-decoration:line-through\">ar]</span>ba</span>z</ins>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[b<span style=\"color:blue\">ar]ba</span>z</ins>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<ins>foo<s>[b</s><span style=\"color:rgb(0, 0, 255)\"><s>ar]</s>ba</span>z</ins>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</ins>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<ins>foo<span style=\"text-decoration:line-through\">[b</span><span style=\"color:rgb(0, 0, 255)\" id=\"foo\"><span style=\"text-decoration:line-through\">ar]</span>ba</span>z</ins>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</ins>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<ins>foo<s>[b</s><span style=\"color:rgb(0, 0, 255)\" id=\"foo\"><s>ar]</s>ba</span>z</ins>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[b<span style=\"font-size:3em\">ar]ba</span>z</ins>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<ins>foo<span style=\"text-decoration:line-through\">[b</span><span style=\"font-size:3em\"><span style=\"text-decoration:line-through\">ar]</span>ba</span>z</ins>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[b<span style=\"font-size:3em\">ar]ba</span>z</ins>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<ins>foo<s>[b</s><span style=\"font-size:3em\"><s>ar]</s>ba</span>z</ins>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[b<i>ar]ba</i>z</ins>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<ins>foo<span style=\"text-decoration:line-through\">[b</span><i><span style=\"text-decoration:line-through\">ar]</span>ba</i>z</ins>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[b<i>ar]ba</i>z</ins>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<ins>foo<s>[b</s><i><s>ar]</s>ba</i>z</ins>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<del>[bar]</del>baz",
    [["strikethrough",""]],
    "foo<del>[bar]</del>baz",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["<del>foo[bar]baz</del>",
    [["strikethrough",""]],
    "<del>foo[bar]baz</del>",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["<del>foo[b<span style=\"color:blue\">ar]ba</span>z</del>",
    [["strikethrough",""]],
    "<del>foo[b<span style=\"color:rgb(0, 0, 255)\">ar]ba</span>z</del>",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["<del>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</del>",
    [["strikethrough",""]],
    "<del>foo[b<span style=\"color:rgb(0, 0, 255)\" id=\"foo\">ar]ba</span>z</del>",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["<del>foo[b<span style=\"font-size:3em\">ar]ba</span>z</del>",
    [["strikethrough",""]],
    "<del>foo[b<span style=\"font-size:3em\">ar]ba</span>z</del>",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["<del>foo[b<i>ar]ba</i>z</del>",
    [["strikethrough",""]],
    "<del>foo[b<i>ar]ba</i>z</del>",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["foo<span style=\"text-decoration: underline line-through\">[bar]</span>baz",
    [["strikethrough",""]],
    "foo<span style=\"text-decoration:underline\">[bar]</span>baz",
    [true],
    {"strikethrough":[false,true,"",false,false,""]}],
["foo<span style=\"text-decoration: underline line-through\">b[a]r</span>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:underline\"><span style=\"text-decoration:line-through\">b</span>[a]<span style=\"text-decoration:line-through\">r</span></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<span style=\"text-decoration: underline line-through\">b[a]r</span>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<span style=\"text-decoration:underline\"><s>b</s>[a]<s>r</s></span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<s style=\"text-decoration: underline\">[bar]</s>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:line-through\"><s style=\"text-decoration:underline\">[bar]</s></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<s style=\"text-decoration: underline\">[bar]</s>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<s><s style=\"text-decoration:underline\">[bar]</s></s>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<s style=\"text-decoration: underline\">b[a]r</s>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<s style=\"text-decoration:underline\">b<span style=\"text-decoration:line-through\">[a]</span>r</s>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<s style=\"text-decoration: underline\">b[a]r</s>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<s style=\"text-decoration:underline\">b<s>[a]</s>r</s>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<u style=\"text-decoration: line-through\">[bar]</u>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<u style=\"text-decoration: line-through\">[bar]</u>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<u style=\"text-decoration: line-through\">b[a]r</u>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:line-through\">b</span>[a]<span style=\"text-decoration:line-through\">r</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<u style=\"text-decoration: line-through\">b[a]r</u>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<s>b</s>[a]<s>r</s>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<s style=\"text-decoration: overline\">[bar]</s>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:line-through\"><s style=\"text-decoration:overline\">[bar]</s></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<s style=\"text-decoration: overline\">[bar]</s>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<s><s style=\"text-decoration:overline\">[bar]</s></s>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<s style=\"text-decoration: overline\">b[a]r</s>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<s style=\"text-decoration:overline\">b<span style=\"text-decoration:line-through\">[a]</span>r</s>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<s style=\"text-decoration: overline\">b[a]r</s>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<s style=\"text-decoration:overline\">b<s>[a]</s>r</s>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<u style=\"text-decoration: overline\">[bar]</u>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:line-through\"><u style=\"text-decoration:overline\">[bar]</u></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<u style=\"text-decoration: overline\">[bar]</u>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<s><u style=\"text-decoration:overline\">[bar]</u></s>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<u style=\"text-decoration: overline\">b[a]r</u>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<u style=\"text-decoration:overline\">b<span style=\"text-decoration:line-through\">[a]</span>r</u>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<u style=\"text-decoration: overline\">b[a]r</u>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<u style=\"text-decoration:overline\">b<s>[a]</s>r</u>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<p style=\"text-decoration: line-through\">foo[bar]baz</p>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<p><span style=\"text-decoration:line-through\">foo</span>[bar]<span style=\"text-decoration:line-through\">baz</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<p style=\"text-decoration: line-through\">foo[bar]baz</p>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<p><s>foo</s>[bar]<s>baz</s></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<p style=\"text-decoration: overline\">foo[bar]baz</p>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<p style=\"text-decoration:overline\">foo<span style=\"text-decoration:line-through\">[bar]</span>baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<p style=\"text-decoration: overline\">foo[bar]baz</p>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<p style=\"text-decoration:overline\">foo<s>[bar]</s>baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<span class=\"underline\">[bar]</span>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:line-through\"><span class=\"underline\">[bar]</span></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<span class=\"underline\">[bar]</span>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<s><span class=\"underline\">[bar]</span></s>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<span class=\"underline\">b[a]r</span>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span class=\"underline\">b<span style=\"text-decoration:line-through\">[a]</span>r</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<span class=\"underline\">b[a]r</span>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<span class=\"underline\">b<s>[a]</s>r</span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<span class=\"line-through\">[bar]</span>baz",
    [["strikethrough",""]],
    "foo<span class=\"line-through\">[bar]</span>baz",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["foo<span class=\"line-through\">b[a]r</span>baz",
    [["strikethrough",""]],
    "foo<span class=\"line-through\">b[a]r</span>baz",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["foo<span class=\"underline-and-line-through\">[bar]</span>baz",
    [["strikethrough",""]],
    "foo<span class=\"underline-and-line-through\">[bar]</span>baz",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["foo<span class=\"underline-and-line-through\">b[a]r</span>baz",
    [["strikethrough",""]],
    "foo<span class=\"underline-and-line-through\">b[a]r</span>baz",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["fo[o<s>b]ar</s>baz",
    [["strikethrough",""]],
    "fo<s>[ob]ar</s>baz",
    [true],
    {"strikethrough":[true,false,"",false,true,""]}],
["foo<s>ba[r</s>b]az",
    [["strikethrough",""]],
    "foo<s>ba[rb]</s>az",
    [true],
    {"strikethrough":[true,false,"",false,true,""]}],
["fo[o<s>bar</s>b]az",
    [["stylewithcss","true"],["strikethrough",""]],
    "fo<span style=\"text-decoration:line-through\">[obarb]</span>az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[true,false,"",false,true,""]}],
["fo[o<s>bar</s>b]az",
    [["stylewithcss","false"],["strikethrough",""]],
    "fo<s>[obarb]</s>az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[true,false,"",false,true,""]}],
["foo[<s>b]ar</s>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo[b]<span style=\"text-decoration:line-through\">ar</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo[<s>b]ar</s>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo[b]<s>ar</s>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<s>ba[r</s>]baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:line-through\">ba</span>[r]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<s>ba[r</s>]baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<s>ba</s>[r]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["foo[<s>bar</s>]baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo[<s>bar</s>]baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<s>[bar]</s>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<s>[bar]</s>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["foo{<s>bar</s>}baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo{bar}baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo{<s>bar</s>}baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo{bar}baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["fo[o<span style=text-decoration:line-through>b]ar</span>baz",
    [["strikethrough",""]],
    "fo<span style=\"text-decoration:line-through\">[ob]ar</span>baz",
    [true],
    {"strikethrough":[true,false,"",false,true,""]}],
["<strike>fo[o</strike><s>b]ar</s>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\">fo</span>[ob]<span style=\"text-decoration:line-through\">ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>fo[o</strike><s>b]ar</s>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>fo</s>[ob]<s>ar</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>fo[o</s><del>b]ar</del>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\">fo</span>[o<del>b]ar</del>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",true,false,""]}],
["<s>fo[o</s><del>b]ar</del>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>fo</s>[o<del>b]ar</del>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",true,false,""]}]
]
