/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import org.jhotdraw.contrib.PolygonFigure;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractHandle;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

class PolygonScaleHandle
extends AbstractHandle {
    private Point fCurrent;

    public PolygonScaleHandle(PolygonFigure polygonFigure) {
        super(polygonFigure);
    }

    public void invokeStart(int n, int n2, DrawingView drawingView) {
        this.fCurrent = new Point(n, n2);
        UndoActivity undoActivity = (UndoActivity)this.createUndoActivity(drawingView);
        this.setUndoActivity(undoActivity);
        undoActivity.setAffectedFigures(new SingleFigureEnumerator(this.owner()));
        undoActivity.setPolygon(((PolygonFigure)this.owner()).getPolygon());
    }

    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        this.fCurrent = new Point(n, n2);
        Polygon polygon = ((UndoActivity)this.getUndoActivity()).getPolygon();
        ((PolygonFigure)this.owner()).scaleRotate(new Point(n3, n4), polygon, this.fCurrent);
    }

    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        ((PolygonFigure)this.owner()).smoothPoints();
        if (this.fCurrent.x == n3 && this.fCurrent.y == n4) {
            this.setUndoActivity(null);
        }
        this.fCurrent = null;
    }

    public Point locate() {
        if (this.fCurrent == null) {
            return this.getOrigin();
        }
        return this.fCurrent;
    }

    Point getOrigin() {
        Point point = ((PolygonFigure)this.owner()).outermostPoint();
        Point point2 = ((PolygonFigure)this.owner()).center();
        double d = Geom.length(point.x, point.y, point2.x, point2.y);
        if (d == 0.0) {
            return new Point(point.x - 4, point.y + 4);
        }
        double d2 = 8.0 / d;
        if (d2 > 1.0) {
            return new Point((point.x * 3 + point2.x) / 4, (point.y * 3 + point2.y) / 4);
        }
        return new Point((int)((double)point.x * (1.0 - d2) + (double)point2.x * d2), (int)((double)point.y * (1.0 - d2) + (double)point2.y * d2));
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.yellow);
        graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected Undoable createUndoActivity(DrawingView drawingView) {
        return new UndoActivity(drawingView);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Polygon myPolygon;

        public UndoActivity(DrawingView drawingView) {
            super(drawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            return this.resetPolygon();
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            return this.resetPolygon();
        }

        protected boolean resetPolygon() {
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            if (!figureEnumeration.hasNextFigure()) {
                return false;
            }
            PolygonFigure polygonFigure = (PolygonFigure)figureEnumeration.nextFigure();
            Polygon polygon = polygonFigure.getPolygon();
            polygonFigure.willChange();
            polygonFigure.setInternalPolygon(this.getPolygon());
            polygonFigure.changed();
            this.setPolygon(polygon);
            return true;
        }

        protected void setPolygon(Polygon polygon) {
            this.myPolygon = polygon;
        }

        public Polygon getPolygon() {
            return this.myPolygon;
        }
    }
}

