/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.FigureSelection;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class StandardFigureSelection
implements FigureSelection,
Serializable {
    private byte[] fData;
    public static final String TYPE = "org.jhotdraw.Figures";

    public StandardFigureSelection(FigureEnumeration figureEnumeration, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(200);
        StorableOutput storableOutput = new StorableOutput(byteArrayOutputStream);
        storableOutput.writeInt(n);
        while (figureEnumeration.hasNextFigure()) {
            storableOutput.writeStorable(figureEnumeration.nextFigure());
        }
        storableOutput.close();
        this.fData = byteArrayOutputStream.toByteArray();
    }

    public String getType() {
        return TYPE;
    }

    public Object getData(String string) {
        if (string.equals(TYPE)) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.fData);
            List list = CollectionsFactory.current().createList(10);
            StorableInput storableInput = new StorableInput(byteArrayInputStream);
            try {
                int n = storableInput.readInt();
                for (int i = 0; i < n; ++i) {
                    Figure figure = (Figure)storableInput.readStorable();
                    list.add(figure);
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException.toString());
            }
            return new FigureEnumerator(list);
        }
        return null;
    }

    public static FigureEnumeration duplicateFigures(FigureEnumeration figureEnumeration, int n) {
        StandardFigureSelection standardFigureSelection = new StandardFigureSelection(figureEnumeration, n);
        return (FigureEnumeration)standardFigureSelection.getData(standardFigureSelection.getType());
    }
}

