/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class AlignCommand
extends AbstractCommand {
    private Alignment myAlignment;

    public AlignCommand(Alignment alignment, DrawingEditor drawingEditor) {
        super(alignment.getDescription(), drawingEditor);
        this.setAlignment(alignment);
    }

    protected boolean isExecutableWithView() {
        return this.view().selectionCount() > 1;
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selection());
        ((UndoActivity)this.getUndoActivity()).alignAffectedFigures(this.getAlignment());
        this.view().checkDamage();
    }

    protected void setAlignment(Alignment alignment) {
        this.myAlignment = alignment;
    }

    public Alignment getAlignment() {
        return this.myAlignment;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.getAlignment());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Hashtable myOriginalPoints = new Hashtable();
        private Alignment myAppliedAlignment;

        public UndoActivity(DrawingView drawingView, Alignment alignment) {
            super(drawingView);
            this.setAppliedAlignment(alignment);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                Point point = this.getOriginalPoint(figure);
                Point point2 = figure.displayBox().getLocation();
                figure.moveBy(-point2.x + point.x, -point2.y + point.y);
            }
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            this.alignAffectedFigures(this.getAppliedAlignment());
            return true;
        }

        protected void setAppliedAlignment(Alignment alignment) {
            this.myAppliedAlignment = alignment;
        }

        public Alignment getAppliedAlignment() {
            return this.myAppliedAlignment;
        }

        protected void addOriginalPoint(Figure figure) {
            this.myOriginalPoints.put(figure, figure.displayBox().getLocation());
        }

        public Point getOriginalPoint(Figure figure) {
            return (Point)this.myOriginalPoints.get(figure);
        }

        public void alignAffectedFigures(Alignment alignment) {
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            Figure figure = figureEnumeration.nextFigure();
            Rectangle rectangle = figure.displayBox();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure2 = figureEnumeration.nextFigure();
                alignment.moveBy(figure2, rectangle);
            }
        }

        public void setAffectedFigures(FigureEnumeration figureEnumeration) {
            super.setAffectedFigures(figureEnumeration);
            FigureEnumeration figureEnumeration2 = this.getAffectedFigures();
            while (figureEnumeration2.hasNextFigure()) {
                this.addOriginalPoint(figureEnumeration2.nextFigure());
            }
        }
    }

    public static abstract class Alignment {
        public static final Alignment LEFTS = new Alignment("Lefts"){

            public void moveBy(Figure figure, Rectangle rectangle) {
                Rectangle rectangle2 = figure.displayBox();
                figure.moveBy(rectangle.x - rectangle2.x, 0);
            }
        };
        public static final Alignment CENTERS = new Alignment("Centers"){

            public void moveBy(Figure figure, Rectangle rectangle) {
                Rectangle rectangle2 = figure.displayBox();
                figure.moveBy(rectangle.x + rectangle.width / 2 - (rectangle2.x + rectangle2.width / 2), 0);
            }
        };
        public static final Alignment RIGHTS = new Alignment("Rights"){

            public void moveBy(Figure figure, Rectangle rectangle) {
                Rectangle rectangle2 = figure.displayBox();
                figure.moveBy(rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), 0);
            }
        };
        public static final Alignment TOPS = new Alignment("Tops"){

            public void moveBy(Figure figure, Rectangle rectangle) {
                Rectangle rectangle2 = figure.displayBox();
                figure.moveBy(0, rectangle.y - rectangle2.y);
            }
        };
        public static final Alignment MIDDLES = new Alignment("Middles"){

            public void moveBy(Figure figure, Rectangle rectangle) {
                Rectangle rectangle2 = figure.displayBox();
                figure.moveBy(0, rectangle.y + rectangle.height / 2 - (rectangle2.y + rectangle2.height / 2));
            }
        };
        public static final Alignment BOTTOMS = new Alignment("Bottoms"){

            public void moveBy(Figure figure, Rectangle rectangle) {
                Rectangle rectangle2 = figure.displayBox();
                figure.moveBy(0, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
            }
        };
        private String myDescription;

        private Alignment(String string) {
            this.setDescription(string);
        }

        public String toString() {
            return this.getDescription();
        }

        public String getDescription() {
            return this.myDescription;
        }

        private void setDescription(String string) {
            this.myDescription = string;
        }

        public abstract void moveBy(Figure var1, Rectangle var2);
    }
}

