/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JComponent;
import org.jhotdraw.contrib.dnd.DNDFigures;
import org.jhotdraw.contrib.dnd.DNDFiguresTransferable;
import org.jhotdraw.contrib.dnd.DNDInterface;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Handle;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.standard.AWTCursor;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.standard.DragTracker;
import org.jhotdraw.standard.HandleTracker;
import org.jhotdraw.standard.SelectAreaTracker;

public class DragNDropTool
extends AbstractTool {
    private Tool fChild;
    private DragGestureListener dragGestureListener;
    private boolean dragOn;
    static /* synthetic */ Class class$org$jhotdraw$contrib$dnd$DNDInterface;

    public DragNDropTool(DrawingEditor drawingEditor) {
        super(drawingEditor);
        this.setDragGestureListener(this.createDragGestureListener());
        this.dragOn = false;
    }

    protected void viewCreated(DrawingView drawingView) {
        super.viewCreated(drawingView);
        if ((class$org$jhotdraw$contrib$dnd$DNDInterface == null ? (class$org$jhotdraw$contrib$dnd$DNDInterface = DragNDropTool.class$("org.jhotdraw.contrib.dnd.DNDInterface")) : class$org$jhotdraw$contrib$dnd$DNDInterface).isInstance(drawingView)) {
            DNDInterface dNDInterface = (DNDInterface)((Object)drawingView);
            dNDInterface.DNDInitialize(this.getDragGestureListener());
        }
    }

    protected void viewDestroying(DrawingView drawingView) {
        if ((class$org$jhotdraw$contrib$dnd$DNDInterface == null ? (class$org$jhotdraw$contrib$dnd$DNDInterface = DragNDropTool.class$("org.jhotdraw.contrib.dnd.DNDInterface")) : class$org$jhotdraw$contrib$dnd$DNDInterface).isInstance(drawingView)) {
            DNDInterface dNDInterface = (DNDInterface)((Object)drawingView);
            dNDInterface.DNDDeinitialize();
        }
        super.viewDestroying(drawingView);
    }

    public void activate() {
        super.activate();
        this.setDragOn(true);
    }

    public void deactivate() {
        this.setDragOn(false);
        super.deactivate();
    }

    public static void setCursor(int n, int n2, DrawingView drawingView) {
        if (drawingView == null) {
            return;
        }
        Handle handle = drawingView.findHandle(n, n2);
        Figure figure = drawingView.drawing().findFigure(n, n2);
        if (handle != null) {
            drawingView.setCursor(handle.getCursor());
        } else if (figure != null) {
            drawingView.setCursor(new AWTCursor(13));
        } else {
            drawingView.setCursor(new AWTCursor(0));
        }
    }

    public void mouseMove(MouseEvent mouseEvent, int n, int n2) {
        if (mouseEvent.getSource() == this.getActiveView()) {
            DragNDropTool.setCursor(n, n2, this.getActiveView());
        }
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        if (this.fChild != null) {
            this.fChild.mouseUp(mouseEvent, n, n2);
            this.fChild = null;
        }
        this.setDragOn(true);
        this.view().unfreezeView();
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDown(mouseEvent, n, n2);
        if (this.fChild != null) {
            return;
        }
        this.view().freezeView();
        Handle handle = this.view().findHandle(this.getAnchorX(), this.getAnchorY());
        if (handle != null) {
            this.setDragOn(false);
            this.fChild = this.createHandleTracker(handle);
        } else {
            Figure figure = this.drawing().findFigure(this.getAnchorX(), this.getAnchorY());
            if (figure != null) {
                this.fChild = null;
                if (mouseEvent.isShiftDown()) {
                    this.view().toggleSelection(figure);
                } else if (!this.view().isFigureSelected(figure)) {
                    this.view().clearSelection();
                    this.view().addToSelection(figure);
                }
            } else {
                this.setDragOn(false);
                if (!mouseEvent.isShiftDown()) {
                    this.view().clearSelection();
                }
                this.fChild = this.createAreaTracker();
            }
        }
        if (this.fChild != null) {
            this.fChild.mouseDown(mouseEvent, n, n2);
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        if (this.fChild != null) {
            this.fChild.mouseDrag(mouseEvent, n, n2);
        }
    }

    protected Tool createAreaTracker() {
        return new SelectAreaTracker(this.editor());
    }

    protected Tool createDragTracker(DrawingEditor drawingEditor, Figure figure) {
        return new DragTracker(drawingEditor, figure);
    }

    protected Tool createHandleTracker(Handle handle) {
        return new HandleTracker(this.editor(), handle);
    }

    private DragGestureListener getDragGestureListener() {
        return this.dragGestureListener;
    }

    private void setDragGestureListener(DragGestureListener dragGestureListener) {
        this.dragGestureListener = dragGestureListener;
    }

    protected boolean isDragOn() {
        return this.dragOn;
    }

    protected void setDragOn(boolean bl) {
        this.dragOn = bl;
    }

    private DragGestureListener createDragGestureListener() {
        return new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                Component component = dragGestureEvent.getComponent();
                if (!DragNDropTool.this.isDragOn()) {
                    return;
                }
                if (component instanceof DrawingView) {
                    Serializable serializable;
                    boolean bl = false;
                    DrawingView drawingView = (DrawingView)((Object)component);
                    FigureEnumeration figureEnumeration = drawingView.selection();
                    if (!figureEnumeration.hasNextFigure()) {
                        return;
                    }
                    Point point = dragGestureEvent.getDragOrigin();
                    while (figureEnumeration.hasNextFigure()) {
                        serializable = figureEnumeration.nextFigure();
                        if (!serializable.containsPoint(point.x, point.y)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        serializable = new DNDFigures(drawingView.selection(), point);
                        DNDFiguresTransferable dNDFiguresTransferable = new DNDFiguresTransferable(serializable);
                        if (component instanceof JComponent) {
                            ((JComponent)component).setAutoscrolls(false);
                        }
                        dragGestureEvent.getDragSource().startDrag(dragGestureEvent, null, dNDFiguresTransferable, ((DNDInterface)((Object)drawingView)).getDragSourceListener());
                    }
                }
            }
        };
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

