/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.text.StyledEditorKit;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.beans.Disposable;
import org.jhotdraw.draw.ArrowTip;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DelegationSelectionTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.LineDecoration;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.ToolEvent;
import org.jhotdraw.draw.ToolListener;
import org.jhotdraw.draw.action.AbstractDrawingViewAction;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.action.AlignAction;
import org.jhotdraw.draw.action.ApplyAttributesAction;
import org.jhotdraw.draw.action.AttributeAction;
import org.jhotdraw.draw.action.AttributeToggler;
import org.jhotdraw.draw.action.BringToFrontAction;
import org.jhotdraw.draw.action.ColorIcon;
import org.jhotdraw.draw.action.DefaultAttributeAction;
import org.jhotdraw.draw.action.DrawingAttributeAction;
import org.jhotdraw.draw.action.DrawingColorChooserAction;
import org.jhotdraw.draw.action.DrawingColorIcon;
import org.jhotdraw.draw.action.EditorColorChooserAction;
import org.jhotdraw.draw.action.EditorColorIcon;
import org.jhotdraw.draw.action.FontChooserHandler;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.LineDecorationIcon;
import org.jhotdraw.draw.action.MoveAction;
import org.jhotdraw.draw.action.PickAttributesAction;
import org.jhotdraw.draw.action.SelectSameAction;
import org.jhotdraw.draw.action.SelectionColorChooserAction;
import org.jhotdraw.draw.action.SelectionColorIcon;
import org.jhotdraw.draw.action.SendToBackAction;
import org.jhotdraw.draw.action.StrokeIcon;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.draw.action.ZoomAction;
import org.jhotdraw.draw.action.ZoomEditorAction;
import org.jhotdraw.geom.DoubleStroke;
import org.jhotdraw.gui.JFontChooser;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.gui.event.SelectionComponentRepainter;
import org.jhotdraw.util.Images;
import org.jhotdraw.util.ResourceBundleUtil;

public class ButtonFactory {
    public static final List<ColorIcon> DEFAULT_COLORS;
    public static final int DEFAULT_COLORS_COLUMN_COUNT = 8;
    public static final List<ColorIcon> WEBSAVE_COLORS;
    public static final int WEBSAVE_COLORS_COLUMN_COUNT = 19;
    public static final List<ColorIcon> HSV_COLORS;
    public static final int HSV_COLORS_COLUMN_COUNT = 12;

    private ButtonFactory() {
    }

    public static Collection<Action> createDrawingActions(DrawingEditor drawingEditor) {
        return ButtonFactory.createDrawingActions(drawingEditor, new LinkedList<Disposable>());
    }

    public static Collection<Action> createDrawingActions(DrawingEditor drawingEditor, List<Disposable> list) {
        LinkedList<Action> linkedList = new LinkedList<Action>();
        linkedList.add(new CutAction());
        linkedList.add(new CopyAction());
        linkedList.add(new PasteAction());
        SelectSameAction selectSameAction = new SelectSameAction(drawingEditor);
        linkedList.add(selectSameAction);
        list.add(selectSameAction);
        return linkedList;
    }

    public static Collection<Action> createSelectionActions(DrawingEditor drawingEditor) {
        LinkedList<Action> linkedList = new LinkedList<Action>();
        linkedList.add(new DuplicateAction());
        linkedList.add(null);
        linkedList.add(new GroupAction(drawingEditor));
        linkedList.add(new UngroupAction(drawingEditor));
        linkedList.add(null);
        linkedList.add(new BringToFrontAction(drawingEditor));
        linkedList.add(new SendToBackAction(drawingEditor));
        return linkedList;
    }

    public static JToggleButton addSelectionToolTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        return ButtonFactory.addSelectionToolTo(jToolBar, drawingEditor, ButtonFactory.createDrawingActions(drawingEditor), ButtonFactory.createSelectionActions(drawingEditor));
    }

    public static JToggleButton addSelectionToolTo(JToolBar jToolBar, DrawingEditor drawingEditor, Collection<Action> collection, Collection<Action> collection2) {
        DelegationSelectionTool delegationSelectionTool = new DelegationSelectionTool(collection, collection2);
        return ButtonFactory.addSelectionToolTo(jToolBar, drawingEditor, delegationSelectionTool);
    }

    public static JToggleButton addSelectionToolTo(JToolBar jToolBar, DrawingEditor drawingEditor, Tool tool) {
        JToggleButton jToggleButton;
        ButtonGroup buttonGroup;
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        if (jToolBar.getClientProperty("toolButtonGroup") instanceof ButtonGroup) {
            buttonGroup = (ButtonGroup)jToolBar.getClientProperty("toolButtonGroup");
        } else {
            buttonGroup = new ButtonGroup();
            jToolBar.putClientProperty("toolButtonGroup", buttonGroup);
        }
        drawingEditor.setTool(tool);
        final JToggleButton jToggleButton2 = jToggleButton = new JToggleButton();
        if (jToolBar.getClientProperty("toolHandler") instanceof ToolListener) {
            ToolListener toolListener = (ToolListener)jToolBar.getClientProperty("toolHandler");
        } else {
            ToolListener toolListener = new ToolListener(){

                @Override
                public void toolStarted(ToolEvent toolEvent) {
                }

                @Override
                public void toolDone(ToolEvent toolEvent) {
                    jToggleButton2.setSelected(true);
                }

                @Override
                public void areaInvalidated(ToolEvent toolEvent) {
                }
            };
            jToolBar.putClientProperty("toolHandler", toolListener);
        }
        resourceBundleUtil.configureToolBarButton(jToggleButton, "selectionTool");
        jToggleButton.setSelected(true);
        jToggleButton.addItemListener(new ToolButtonListener(tool, drawingEditor));
        jToggleButton.setFocusable(false);
        buttonGroup.add(jToggleButton);
        jToolBar.add(jToggleButton);
        return jToggleButton;
    }

    public static JToggleButton addToolTo(JToolBar jToolBar, DrawingEditor drawingEditor, Tool tool, String string, ResourceBundleUtil resourceBundleUtil) {
        ButtonGroup buttonGroup = (ButtonGroup)jToolBar.getClientProperty("toolButtonGroup");
        ToolListener toolListener = (ToolListener)jToolBar.getClientProperty("toolHandler");
        JToggleButton jToggleButton = new JToggleButton();
        resourceBundleUtil.configureToolBarButton(jToggleButton, string);
        jToggleButton.addItemListener(new ToolButtonListener(tool, drawingEditor));
        jToggleButton.setFocusable(false);
        tool.addToolListener(toolListener);
        buttonGroup.add(jToggleButton);
        jToolBar.add(jToggleButton);
        return jToggleButton;
    }

    public static void addZoomButtonsTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        jToolBar.add(ButtonFactory.createZoomButton(drawingEditor));
    }

    public static AbstractButton createZoomButton(final DrawingEditor drawingEditor) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        final JPopupButton jPopupButton = new JPopupButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "view.zoomFactor");
        jPopupButton.setFocusable(false);
        if (drawingEditor.getDrawingViews().size() == 0) {
            jPopupButton.setText("100 %");
        } else {
            jPopupButton.setText((int)(drawingEditor.getDrawingViews().iterator().next().getScaleFactor() * 100.0) + " %");
        }
        drawingEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "activeView") {
                    if (propertyChangeEvent.getNewValue() == null) {
                        jPopupButton.setText("100 %");
                    } else {
                        jPopupButton.setText((int)(drawingEditor.getActiveView().getScaleFactor() * 100.0) + " %");
                    }
                }
            }
        });
        double[] dArray = new double[]{16.0, 8.0, 5.0, 4.0, 3.0, 2.0, 1.5, 1.25, 1.0, 0.75, 0.5, 0.25, 0.1};
        for (int i = 0; i < dArray.length; ++i) {
            jPopupButton.add(new ZoomEditorAction(drawingEditor, dArray[i], (AbstractButton)jPopupButton){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    super.actionPerformed(actionEvent);
                    jPopupButton.setText((int)(this.editor.getActiveView().getScaleFactor() * 100.0) + " %");
                }
            });
        }
        jPopupButton.setFocusable(false);
        return jPopupButton;
    }

    public static AbstractButton createZoomButton(DrawingView drawingView) {
        return ButtonFactory.createZoomButton(drawingView, new double[]{5.0, 4.0, 3.0, 2.0, 1.5, 1.25, 1.0, 0.75, 0.5, 0.25, 0.1});
    }

    public static AbstractButton createZoomButton(final DrawingView drawingView, double[] dArray) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        final JPopupButton jPopupButton = new JPopupButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "view.zoomFactor");
        jPopupButton.setFocusable(false);
        jPopupButton.setText((int)(drawingView.getScaleFactor() * 100.0) + " %");
        drawingView.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "scaleFactor") {
                    jPopupButton.setText((int)(drawingView.getScaleFactor() * 100.0) + " %");
                }
            }
        });
        for (int i = 0; i < dArray.length; ++i) {
            jPopupButton.add(new ZoomAction(drawingView, dArray[i], jPopupButton){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    super.actionPerformed(actionEvent);
                    jPopupButton.setText((int)(drawingView.getScaleFactor() * 100.0) + " %");
                }
            });
        }
        jPopupButton.setFocusable(false);
        return jPopupButton;
    }

    public static void addAttributesButtonsTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        JButton jButton = jToolBar.add(new PickAttributesAction(drawingEditor));
        jButton.setFocusable(false);
        jButton = jToolBar.add(new ApplyAttributesAction(drawingEditor));
        jButton.setFocusable(false);
        jToolBar.addSeparator();
        ButtonFactory.addColorButtonsTo(jToolBar, drawingEditor);
        jToolBar.addSeparator();
        ButtonFactory.addStrokeButtonsTo(jToolBar, drawingEditor);
        jToolBar.addSeparator();
        ButtonFactory.addFontButtonsTo(jToolBar, drawingEditor);
    }

    public static void addColorButtonsTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        ButtonFactory.addColorButtonsTo(jToolBar, drawingEditor, DEFAULT_COLORS, 8);
    }

    public static void addColorButtonsTo(JToolBar jToolBar, DrawingEditor drawingEditor, List<ColorIcon> list, int n) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        jToolBar.add(ButtonFactory.createEditorColorButton(drawingEditor, AttributeKeys.STROKE_COLOR, list, n, "attribute.strokeColor", resourceBundleUtil, new HashMap<AttributeKey, Object>()));
        jToolBar.add(ButtonFactory.createEditorColorButton(drawingEditor, AttributeKeys.FILL_COLOR, list, n, "attribute.fillColor", resourceBundleUtil, new HashMap<AttributeKey, Object>()));
        jToolBar.add(ButtonFactory.createEditorColorButton(drawingEditor, AttributeKeys.TEXT_COLOR, list, n, "attribute.textColor", resourceBundleUtil, new HashMap<AttributeKey, Object>()));
    }

    public static JPopupButton createEditorColorButton(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, List<ColorIcon> list, int n, String string, ResourceBundleUtil resourceBundleUtil) {
        return ButtonFactory.createEditorColorButton(drawingEditor, attributeKey, list, n, string, resourceBundleUtil, null);
    }

    public static JPopupButton createEditorColorButton(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, List<ColorIcon> list, int n, String string, ResourceBundleUtil resourceBundleUtil, Map<AttributeKey, Object> map) {
        return ButtonFactory.createEditorColorButton(drawingEditor, attributeKey, list, n, string, resourceBundleUtil, map, new Rectangle(1, 17, 20, 4));
    }

    public static JPopupButton createEditorColorButton(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, List<ColorIcon> list, int n, String string, ResourceBundleUtil resourceBundleUtil, Map<AttributeKey, Object> map, Shape shape) {
        Object object;
        Serializable serializable;
        final JPopupButton jPopupButton = new JPopupButton();
        jPopupButton.setPopupAlpha(1.0f);
        if (map == null) {
            map = new HashMap<AttributeKey, Object>();
        }
        jPopupButton.setAction(new DefaultAttributeAction(drawingEditor, attributeKey, map), new Rectangle(0, 0, 22, 22));
        jPopupButton.setColumnCount(n, false);
        boolean bl = false;
        for (ColorIcon object22 : list) {
            HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>(map);
            hashMap.put(attributeKey, object22.getColor());
            if (object22.getColor() == null) {
                bl = true;
            }
            serializable = new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getToolTipTextProperty(string), (Icon)object22);
            jPopupButton.add((Action)((Object)serializable));
            serializable.putValue("ShortDescription", object22.getName());
            serializable.setUpdateEnabledState(false);
        }
        if (!bl) {
            HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>(map);
            hashMap.put(attributeKey, null);
            object = new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getToolTipTextProperty("attribute.color.noColor"), (Icon)new ColorIcon(null, resourceBundleUtil.getToolTipTextProperty("attribute.color.noColor"), list.get(0).getIconWidth(), list.get(0).getIconHeight()));
            jPopupButton.add((Action)object);
            ((AbstractAction)object).putValue("ShortDescription", resourceBundleUtil.getToolTipTextProperty("attribute.color.noColor"));
            ((AbstractSelectedAction)object).setUpdateEnabledState(false);
        }
        object = new ImageIcon(Images.createImage(ButtonFactory.class, "/org/jhotdraw/draw/action/images/attribute.color.colorChooser.png"));
        EditorColorChooserAction editorColorChooserAction = new EditorColorChooserAction(drawingEditor, attributeKey, "color", (Icon)object, map);
        jPopupButton.add(editorColorChooserAction);
        resourceBundleUtil.configureToolBarButton(jPopupButton, string);
        editorColorChooserAction.putValue("ShortDescription", resourceBundleUtil.getToolTipTextProperty("attribute.color.colorChooser"));
        serializable = new EditorColorIcon(drawingEditor, attributeKey, resourceBundleUtil.getIconProperty(string, ButtonFactory.class).getImage(), shape);
        jPopupButton.setIcon((Icon)((Object)serializable));
        jPopupButton.setDisabledIcon((Icon)((Object)serializable));
        jPopupButton.setFocusable(false);
        drawingEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jPopupButton.repaint();
            }
        });
        return jPopupButton;
    }

    public static JPopupButton createSelectionColorButton(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, List<ColorIcon> list, int n, String string, ResourceBundleUtil resourceBundleUtil) {
        return ButtonFactory.createSelectionColorButton(drawingEditor, attributeKey, list, n, string, resourceBundleUtil, null);
    }

    public static JPopupButton createSelectionColorButton(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, List<ColorIcon> list, int n, String string, ResourceBundleUtil resourceBundleUtil, Map<AttributeKey, Object> map) {
        return ButtonFactory.createSelectionColorButton(drawingEditor, attributeKey, list, n, string, resourceBundleUtil, map, new Rectangle(1, 17, 20, 4));
    }

    public static JPopupButton createSelectionColorButton(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, List<ColorIcon> list, int n, String string, ResourceBundleUtil resourceBundleUtil, Map<AttributeKey, Object> map, Shape shape) {
        return ButtonFactory.createSelectionColorButton(drawingEditor, attributeKey, list, n, string, resourceBundleUtil, map, shape, new LinkedList<Disposable>());
    }

    public static JPopupButton createSelectionColorButton(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, List<ColorIcon> list, int n, String string, ResourceBundleUtil resourceBundleUtil, Map<AttributeKey, Object> map, Shape shape, List<Disposable> list2) {
        Object object;
        Serializable serializable;
        JPopupButton jPopupButton = new JPopupButton();
        jPopupButton.setPopupAlpha(1.0f);
        if (map == null) {
            map = new HashMap<AttributeKey, Object>();
        }
        jPopupButton.setColumnCount(n, false);
        boolean bl = false;
        for (ColorIcon object22 : list) {
            HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>(map);
            hashMap.put(attributeKey, object22.getColor());
            if (object22.getColor() == null) {
                bl = true;
            }
            serializable = new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getToolTipTextProperty(string), (Icon)object22);
            jPopupButton.add((Action)((Object)serializable));
            serializable.putValue("ShortDescription", object22.getName());
            serializable.setUpdateEnabledState(false);
            list2.add((Disposable)((Object)serializable));
        }
        if (!bl) {
            HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>(map);
            hashMap.put(attributeKey, null);
            object = new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getToolTipTextProperty("attribute.color.noColor"), (Icon)new ColorIcon(null, resourceBundleUtil.getToolTipTextProperty("attribute.color.noColor")));
            jPopupButton.add((Action)object);
            ((AbstractAction)object).putValue("ShortDescription", resourceBundleUtil.getToolTipTextProperty("attribute.color.noColor"));
            ((AbstractSelectedAction)object).setUpdateEnabledState(false);
            list2.add((Disposable)object);
        }
        object = new ImageIcon(Images.createImage(ButtonFactory.class, "/org/jhotdraw/draw/action/images/attribute.color.colorChooser.png"));
        SelectionColorChooserAction selectionColorChooserAction = new SelectionColorChooserAction(drawingEditor, attributeKey, resourceBundleUtil.getToolTipTextProperty("attribute.color.colorChooser"), (Icon)object, map);
        jPopupButton.add(selectionColorChooserAction);
        selectionColorChooserAction.putValue("ShortDescription", resourceBundleUtil.getToolTipTextProperty("attribute.color.colorChooser"));
        list2.add(selectionColorChooserAction);
        resourceBundleUtil.configureToolBarButton(jPopupButton, string);
        serializable = new SelectionColorIcon(drawingEditor, attributeKey, resourceBundleUtil.getIconProperty(string, ButtonFactory.class).getImage(), shape);
        jPopupButton.setIcon((Icon)((Object)serializable));
        jPopupButton.setDisabledIcon((Icon)((Object)serializable));
        jPopupButton.setFocusable(false);
        list2.add(new SelectionComponentRepainter(drawingEditor, jPopupButton));
        return jPopupButton;
    }

    public static JPopupButton createDrawingColorButton(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, List<ColorIcon> list, int n, String string, ResourceBundleUtil resourceBundleUtil) {
        return ButtonFactory.createDrawingColorButton(drawingEditor, attributeKey, list, n, string, resourceBundleUtil, null);
    }

    public static JPopupButton createDrawingColorButton(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, List<ColorIcon> list, int n, String string, ResourceBundleUtil resourceBundleUtil, Map<AttributeKey, Object> map) {
        return ButtonFactory.createDrawingColorButton(drawingEditor, attributeKey, list, n, string, resourceBundleUtil, map, new Rectangle(1, 17, 20, 4));
    }

    public static JPopupButton createDrawingColorButton(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, List<ColorIcon> list, int n, String string, ResourceBundleUtil resourceBundleUtil, Map<AttributeKey, Object> map, Shape shape) {
        return ButtonFactory.createDrawingColorButton(drawingEditor, attributeKey, list, n, string, resourceBundleUtil, map, shape, new LinkedList<Disposable>());
    }

    public static JPopupButton createDrawingColorButton(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, List<ColorIcon> list, int n, String string, ResourceBundleUtil resourceBundleUtil, Map<AttributeKey, Object> map, Shape shape, List<Disposable> list2) {
        Object object;
        Serializable serializable;
        JPopupButton jPopupButton = new JPopupButton();
        jPopupButton.setPopupAlpha(1.0f);
        if (map == null) {
            map = new HashMap<AttributeKey, Object>();
        }
        jPopupButton.setColumnCount(n, false);
        boolean bl = false;
        for (ColorIcon object22 : list) {
            HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>(map);
            hashMap.put(attributeKey, object22.getColor());
            if (object22.getColor() == null) {
                bl = true;
            }
            serializable = new DrawingAttributeAction(drawingEditor, hashMap, resourceBundleUtil.getToolTipTextProperty(string), (Icon)object22);
            jPopupButton.add((Action)((Object)serializable));
            list2.add((Disposable)((Object)serializable));
            serializable.putValue("ShortDescription", object22.getName());
            serializable.setUpdateEnabledState(false);
        }
        if (!bl) {
            HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>(map);
            hashMap.put(attributeKey, null);
            object = new DrawingAttributeAction(drawingEditor, hashMap, resourceBundleUtil.getToolTipTextProperty("attribute.color.noColor"), (Icon)new ColorIcon(null, resourceBundleUtil.getToolTipTextProperty("attribute.color.noColor")));
            jPopupButton.add((Action)object);
            list2.add((Disposable)object);
            ((AbstractAction)object).putValue("ShortDescription", resourceBundleUtil.getToolTipTextProperty("attribute.color.noColor"));
            ((AbstractDrawingViewAction)object).setUpdateEnabledState(false);
        }
        object = new ImageIcon(Images.createImage(ButtonFactory.class, "/org/jhotdraw/draw/action/images/attribute.color.colorChooser.png"));
        DrawingColorChooserAction drawingColorChooserAction = new DrawingColorChooserAction(drawingEditor, attributeKey, "color", (Icon)object, map);
        jPopupButton.add(drawingColorChooserAction);
        list2.add(drawingColorChooserAction);
        resourceBundleUtil.configureToolBarButton(jPopupButton, string);
        drawingColorChooserAction.putValue("ShortDescription", resourceBundleUtil.getToolTipTextProperty("attribute.color.colorChooser"));
        serializable = new DrawingColorIcon(drawingEditor, attributeKey, resourceBundleUtil.getIconProperty(string, ButtonFactory.class).getImage(), shape);
        jPopupButton.setIcon((Icon)((Object)serializable));
        jPopupButton.setDisabledIcon((Icon)((Object)serializable));
        jPopupButton.setFocusable(false);
        if (drawingEditor != null) {
            list2.add(new SelectionComponentRepainter(drawingEditor, jPopupButton));
        }
        return jPopupButton;
    }

    public static void addStrokeButtonsTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        jToolBar.add(ButtonFactory.createStrokeDecorationButton(drawingEditor));
        jToolBar.add(ButtonFactory.createStrokeWidthButton(drawingEditor));
        jToolBar.add(ButtonFactory.createStrokeDashesButton(drawingEditor));
        jToolBar.add(ButtonFactory.createStrokeTypeButton(drawingEditor));
        jToolBar.add(ButtonFactory.createStrokePlacementButton(drawingEditor));
        jToolBar.add(ButtonFactory.createStrokeCapButton(drawingEditor));
        jToolBar.add(ButtonFactory.createStrokeJoinButton(drawingEditor));
    }

    public static JPopupButton createStrokeWidthButton(DrawingEditor drawingEditor) {
        return ButtonFactory.createStrokeWidthButton(drawingEditor, new double[]{0.5, 1.0, 2.0, 3.0, 5.0, 9.0, 13.0}, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeWidthButton(DrawingEditor drawingEditor, ResourceBundleUtil resourceBundleUtil) {
        return ButtonFactory.createStrokeWidthButton(drawingEditor, new double[]{0.5, 1.0, 2.0, 3.0, 5.0, 9.0, 13.0}, resourceBundleUtil);
    }

    public static JPopupButton createStrokeWidthButton(DrawingEditor drawingEditor, double[] dArray) {
        return ButtonFactory.createStrokeWidthButton(drawingEditor, new double[]{0.5, 1.0, 2.0, 3.0, 5.0, 9.0, 13.0}, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeWidthButton(DrawingEditor drawingEditor, double[] dArray, ResourceBundleUtil resourceBundleUtil) {
        JPopupButton jPopupButton = new JPopupButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "attribute.strokeWidth");
        jPopupButton.setFocusable(false);
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).setMaximumFractionDigits(1);
            ((DecimalFormat)numberFormat).setMinimumFractionDigits(0);
        }
        for (int i = 0; i < dArray.length; ++i) {
            String string = Double.toString(dArray[i]);
            StrokeIcon strokeIcon = new StrokeIcon(new BasicStroke((float)dArray[i], 0, 2));
            AttributeAction attributeAction = new AttributeAction(drawingEditor, AttributeKeys.STROKE_WIDTH, new Double(dArray[i]), string, strokeIcon);
            attributeAction.putValue("undoPresentationName", resourceBundleUtil.getString("attribute.strokeWidth.text"));
            AbstractButton abstractButton = jPopupButton.add(attributeAction);
            abstractButton.setDisabledIcon(strokeIcon);
        }
        return jPopupButton;
    }

    public static JPopupButton createStrokeDecorationButton(DrawingEditor drawingEditor) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        JPopupButton jPopupButton = new JPopupButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "attribute.strokeDecoration");
        jPopupButton.setFocusable(false);
        jPopupButton.setColumnCount(2, false);
        LineDecoration[] lineDecorationArray = new LineDecoration[]{new ArrowTip(0.35, 12.0, 11.3), new ArrowTip(0.35, 13.0, 7.0), new ArrowTip(0.6283185307179586, 12.0, 9.8, true, true, false), new ArrowTip(0.5235987755982988, 12.0, 0.0, false, true, false), new ArrowTip(0.28559933214452665, 13.0, 0.0, false, true, true), new ArrowTip(0.5235987755982988, 10.0, 18.0, false, true, false), new ArrowTip(0.5235987755982988, 10.0, 18.0, true, true, true), null};
        for (int i = 0; i < lineDecorationArray.length; ++i) {
            jPopupButton.add(new AttributeAction(drawingEditor, AttributeKeys.START_DECORATION, lineDecorationArray[i], null, new LineDecorationIcon(lineDecorationArray[i], true)));
            jPopupButton.add(new AttributeAction(drawingEditor, AttributeKeys.END_DECORATION, lineDecorationArray[i], null, new LineDecorationIcon(lineDecorationArray[i], false)));
        }
        return jPopupButton;
    }

    public static JPopupButton createStrokeDashesButton(DrawingEditor drawingEditor) {
        return ButtonFactory.createStrokeDashesButton(drawingEditor, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeDashesButton(DrawingEditor drawingEditor, ResourceBundleUtil resourceBundleUtil) {
        return ButtonFactory.createStrokeDashesButton(drawingEditor, new double[][]{null, {4.0, 4.0}, {2.0, 2.0}, {4.0, 2.0}, {2.0, 4.0}, {8.0, 2.0}, {6.0, 2.0, 2.0, 2.0}}, resourceBundleUtil);
    }

    public static JPopupButton createStrokeDashesButton(DrawingEditor drawingEditor, double[][] dArray) {
        return ButtonFactory.createStrokeDashesButton(drawingEditor, dArray, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeDashesButton(DrawingEditor drawingEditor, double[][] dArray, ResourceBundleUtil resourceBundleUtil) {
        return ButtonFactory.createStrokeDashesButton(drawingEditor, dArray, resourceBundleUtil, new LinkedList<Disposable>());
    }

    public static JPopupButton createStrokeDashesButton(DrawingEditor drawingEditor, double[][] dArray, ResourceBundleUtil resourceBundleUtil, List<Disposable> list) {
        JPopupButton jPopupButton = new JPopupButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "attribute.strokeDashes");
        jPopupButton.setFocusable(false);
        for (int i = 0; i < dArray.length; ++i) {
            float[] fArray;
            if (dArray[i] == null) {
                fArray = null;
            } else {
                fArray = new float[dArray[i].length];
                for (int j = 0; j < dArray[i].length; ++j) {
                    fArray[j] = (float)dArray[i][j];
                }
            }
            StrokeIcon strokeIcon = new StrokeIcon(new BasicStroke(2.0f, 0, 2, 10.0f, fArray, 0.0f));
            AttributeAction attributeAction = new AttributeAction(drawingEditor, AttributeKeys.STROKE_DASHES, dArray[i], null, strokeIcon);
            AbstractButton abstractButton = jPopupButton.add(attributeAction);
            list.add(attributeAction);
            abstractButton.setDisabledIcon(strokeIcon);
        }
        return jPopupButton;
    }

    public static JPopupButton createStrokeTypeButton(DrawingEditor drawingEditor) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        JPopupButton jPopupButton = new JPopupButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "attribute.strokeType");
        jPopupButton.setFocusable(false);
        jPopupButton.add(new AttributeAction(drawingEditor, AttributeKeys.STROKE_TYPE, (Object)AttributeKeys.StrokeType.BASIC, resourceBundleUtil.getString("attribute.strokeType.basic"), new StrokeIcon(new BasicStroke(1.0f, 0, 2))));
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        hashMap.put(AttributeKeys.STROKE_TYPE, (Object)AttributeKeys.StrokeType.DOUBLE);
        hashMap.put(AttributeKeys.STROKE_INNER_WIDTH_FACTOR, 2.0);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokeType.double"), (Icon)new StrokeIcon(new DoubleStroke(2.0f, 1.0f))));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_TYPE, (Object)AttributeKeys.StrokeType.DOUBLE);
        hashMap.put(AttributeKeys.STROKE_INNER_WIDTH_FACTOR, 3.0);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokeType.double"), (Icon)new StrokeIcon(new DoubleStroke(3.0f, 1.0f))));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_TYPE, (Object)AttributeKeys.StrokeType.DOUBLE);
        hashMap.put(AttributeKeys.STROKE_INNER_WIDTH_FACTOR, 4.0);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokeType.double"), (Icon)new StrokeIcon(new DoubleStroke(4.0f, 1.0f))));
        return jPopupButton;
    }

    public static JPopupButton createStrokePlacementButton(DrawingEditor drawingEditor) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        JPopupButton jPopupButton = new JPopupButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "attribute.strokePlacement");
        jPopupButton.setFocusable(false);
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.CENTER);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.CENTER);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokePlacement.center"), null));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.INSIDE);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.CENTER);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokePlacement.inside"), null));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.OUTSIDE);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.CENTER);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokePlacement.outside"), null));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.CENTER);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.FULL);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokePlacement.centerFilled"), null));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.INSIDE);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.FULL);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokePlacement.insideFilled"), null));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.OUTSIDE);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.FULL);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokePlacement.outsideFilled"), null));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.CENTER);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.NONE);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokePlacement.centerUnfilled"), null));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.INSIDE);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.NONE);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokePlacement.insideUnfilled"), null));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.OUTSIDE);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.NONE);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokePlacement.outsideUnfilled"), null));
        return jPopupButton;
    }

    public static void addFontButtonsTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        jToolBar.add(ButtonFactory.createFontButton(drawingEditor));
        jToolBar.add(ButtonFactory.createFontStyleBoldButton(drawingEditor));
        jToolBar.add(ButtonFactory.createFontStyleItalicButton(drawingEditor));
        jToolBar.add(ButtonFactory.createFontStyleUnderlineButton(drawingEditor));
    }

    public static JPopupButton createFontButton(DrawingEditor drawingEditor) {
        return ButtonFactory.createFontButton(drawingEditor, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createFontButton(DrawingEditor drawingEditor, ResourceBundleUtil resourceBundleUtil) {
        return ButtonFactory.createFontButton(drawingEditor, AttributeKeys.FONT_FACE, resourceBundleUtil);
    }

    public static JPopupButton createFontButton(DrawingEditor drawingEditor, AttributeKey<Font> attributeKey, ResourceBundleUtil resourceBundleUtil) {
        return ButtonFactory.createFontButton(drawingEditor, attributeKey, resourceBundleUtil, new LinkedList<Disposable>());
    }

    public static JPopupButton createFontButton(DrawingEditor drawingEditor, AttributeKey<Font> attributeKey, ResourceBundleUtil resourceBundleUtil, List<Disposable> list) {
        JPopupButton jPopupButton = new JPopupButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "attribute.font");
        jPopupButton.setFocusable(false);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JFontChooser jFontChooser = new JFontChooser();
        list.add(new FontChooserHandler(drawingEditor, attributeKey, jFontChooser, jPopupMenu));
        jPopupMenu.add(jFontChooser);
        jPopupButton.setPopupMenu(jPopupMenu);
        jPopupButton.setFocusable(false);
        return jPopupButton;
    }

    public static JButton createFontStyleBoldButton(DrawingEditor drawingEditor) {
        return ButtonFactory.createFontStyleBoldButton(drawingEditor, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JButton createFontStyleBoldButton(DrawingEditor drawingEditor, ResourceBundleUtil resourceBundleUtil) {
        return ButtonFactory.createFontStyleBoldButton(drawingEditor, resourceBundleUtil, new LinkedList<Disposable>());
    }

    public static JButton createFontStyleBoldButton(DrawingEditor drawingEditor, ResourceBundleUtil resourceBundleUtil, List<Disposable> list) {
        JButton jButton = new JButton();
        resourceBundleUtil.configureToolBarButton(jButton, "attribute.fontStyle.bold");
        jButton.setFocusable(false);
        AttributeToggler<Boolean> attributeToggler = new AttributeToggler<Boolean>(drawingEditor, AttributeKeys.FONT_BOLD, Boolean.TRUE, Boolean.FALSE, new StyledEditorKit.BoldAction());
        attributeToggler.putValue("undoPresentationName", resourceBundleUtil.getString("attribute.fontStyle.bold.text"));
        jButton.addActionListener(attributeToggler);
        return jButton;
    }

    public static JButton createFontStyleItalicButton(DrawingEditor drawingEditor) {
        return ButtonFactory.createFontStyleItalicButton(drawingEditor, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JButton createFontStyleItalicButton(DrawingEditor drawingEditor, ResourceBundleUtil resourceBundleUtil) {
        return ButtonFactory.createFontStyleItalicButton(drawingEditor, resourceBundleUtil, new LinkedList<Disposable>());
    }

    public static JButton createFontStyleItalicButton(DrawingEditor drawingEditor, ResourceBundleUtil resourceBundleUtil, List<Disposable> list) {
        JButton jButton = new JButton();
        resourceBundleUtil.configureToolBarButton(jButton, "attribute.fontStyle.italic");
        jButton.setFocusable(false);
        AttributeToggler<Boolean> attributeToggler = new AttributeToggler<Boolean>(drawingEditor, AttributeKeys.FONT_ITALIC, Boolean.TRUE, Boolean.FALSE, new StyledEditorKit.BoldAction());
        attributeToggler.putValue("undoPresentationName", resourceBundleUtil.getString("attribute.fontStyle.italic.text"));
        jButton.addActionListener(attributeToggler);
        return jButton;
    }

    public static JButton createFontStyleUnderlineButton(DrawingEditor drawingEditor) {
        return ButtonFactory.createFontStyleUnderlineButton(drawingEditor, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JButton createFontStyleUnderlineButton(DrawingEditor drawingEditor, ResourceBundleUtil resourceBundleUtil) {
        return ButtonFactory.createFontStyleUnderlineButton(drawingEditor, resourceBundleUtil, new LinkedList<Disposable>());
    }

    public static JButton createFontStyleUnderlineButton(DrawingEditor drawingEditor, ResourceBundleUtil resourceBundleUtil, List<Disposable> list) {
        JButton jButton = new JButton();
        resourceBundleUtil.configureToolBarButton(jButton, "attribute.fontStyle.underline");
        jButton.setFocusable(false);
        AttributeToggler<Boolean> attributeToggler = new AttributeToggler<Boolean>(drawingEditor, AttributeKeys.FONT_UNDERLINE, Boolean.TRUE, Boolean.FALSE, new StyledEditorKit.BoldAction());
        attributeToggler.putValue("undoPresentationName", resourceBundleUtil.getString("attribute.fontStyle.underline.text"));
        jButton.addActionListener(attributeToggler);
        return jButton;
    }

    public static void addAlignmentButtonsTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        ButtonFactory.addAlignmentButtonsTo(jToolBar, drawingEditor, new LinkedList<Disposable>());
    }

    public static void addAlignmentButtonsTo(JToolBar jToolBar, DrawingEditor drawingEditor, List<Disposable> list) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        AbstractSelectedAction abstractSelectedAction = new AlignAction.West(drawingEditor);
        jToolBar.add(abstractSelectedAction).setFocusable(false);
        list.add(abstractSelectedAction);
        abstractSelectedAction = new AlignAction.East(drawingEditor);
        jToolBar.add(abstractSelectedAction).setFocusable(false);
        list.add(abstractSelectedAction);
        abstractSelectedAction = new AlignAction.Horizontal(drawingEditor);
        jToolBar.add(abstractSelectedAction).setFocusable(false);
        list.add(abstractSelectedAction);
        abstractSelectedAction = new AlignAction.North(drawingEditor);
        jToolBar.add(abstractSelectedAction).setFocusable(false);
        list.add(abstractSelectedAction);
        abstractSelectedAction = new AlignAction.South(drawingEditor);
        jToolBar.add(abstractSelectedAction).setFocusable(false);
        list.add(abstractSelectedAction);
        abstractSelectedAction = new AlignAction.Vertical(drawingEditor);
        jToolBar.add(abstractSelectedAction).setFocusable(false);
        list.add(abstractSelectedAction);
        jToolBar.addSeparator();
        abstractSelectedAction = new MoveAction.West(drawingEditor);
        jToolBar.add(abstractSelectedAction).setFocusable(false);
        list.add(abstractSelectedAction);
        abstractSelectedAction = new MoveAction.East(drawingEditor);
        jToolBar.add(abstractSelectedAction).setFocusable(false);
        list.add(abstractSelectedAction);
        abstractSelectedAction = new MoveAction.North(drawingEditor);
        jToolBar.add(abstractSelectedAction).setFocusable(false);
        list.add(abstractSelectedAction);
        abstractSelectedAction = new MoveAction.South(drawingEditor);
        jToolBar.add(abstractSelectedAction).setFocusable(false);
        list.add(abstractSelectedAction);
        jToolBar.addSeparator();
        jToolBar.add(new BringToFrontAction(drawingEditor)).setFocusable(false);
        list.add(abstractSelectedAction);
        jToolBar.add(new SendToBackAction(drawingEditor)).setFocusable(false);
        list.add(abstractSelectedAction);
    }

    public static AbstractButton createToggleGridButton(final DrawingView drawingView) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        final JToggleButton jToggleButton = new JToggleButton();
        resourceBundleUtil.configureToolBarButton(jToggleButton, "view.toggleGrid");
        jToggleButton.setFocusable(false);
        jToggleButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                drawingView.setConstrainerVisible(jToggleButton.isSelected());
            }
        });
        drawingView.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "constrainerVisible") {
                    jToggleButton.setSelected(drawingView.isConstrainerVisible());
                }
            }
        });
        return jToggleButton;
    }

    public static JPopupButton createStrokeCapButton(DrawingEditor drawingEditor) {
        return ButtonFactory.createStrokeCapButton(drawingEditor, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeCapButton(DrawingEditor drawingEditor, ResourceBundleUtil resourceBundleUtil) {
        return ButtonFactory.createStrokeCapButton(drawingEditor, resourceBundleUtil, new LinkedList<Disposable>());
    }

    public static JPopupButton createStrokeCapButton(DrawingEditor drawingEditor, ResourceBundleUtil resourceBundleUtil, List<Disposable> list) {
        JPopupButton jPopupButton = new JPopupButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "attribute.strokeCap");
        jPopupButton.setFocusable(false);
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        hashMap.put(AttributeKeys.STROKE_CAP, 0);
        AttributeAction attributeAction = new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokeCap.butt"), null);
        jPopupButton.add(attributeAction);
        list.add(attributeAction);
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_CAP, 1);
        attributeAction = new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokeCap.round"), null);
        jPopupButton.add(attributeAction);
        list.add(attributeAction);
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_CAP, 2);
        attributeAction = new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokeCap.square"), null);
        jPopupButton.add(attributeAction);
        list.add(attributeAction);
        return jPopupButton;
    }

    public static JPopupButton createStrokeJoinButton(DrawingEditor drawingEditor) {
        return ButtonFactory.createStrokeJoinButton(drawingEditor, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeJoinButton(DrawingEditor drawingEditor, ResourceBundleUtil resourceBundleUtil) {
        return ButtonFactory.createStrokeJoinButton(drawingEditor, resourceBundleUtil, new LinkedList<Disposable>());
    }

    public static JPopupButton createStrokeJoinButton(DrawingEditor drawingEditor, ResourceBundleUtil resourceBundleUtil, List<Disposable> list) {
        JPopupButton jPopupButton = new JPopupButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "attribute.strokeJoin");
        jPopupButton.setFocusable(false);
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        hashMap.put(AttributeKeys.STROKE_JOIN, 2);
        AttributeAction attributeAction = new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokeJoin.bevel"), null);
        jPopupButton.add(attributeAction);
        list.add(attributeAction);
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_JOIN, 1);
        attributeAction = new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokeJoin.round"), null);
        jPopupButton.add(attributeAction);
        list.add(attributeAction);
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_JOIN, 0);
        attributeAction = new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attribute.strokeJoin.miter"), null);
        jPopupButton.add(attributeAction);
        list.add(attributeAction);
        return jPopupButton;
    }

    public static JButton createPickAttributesButton(DrawingEditor drawingEditor) {
        return ButtonFactory.createPickAttributesButton(drawingEditor, new LinkedList<Disposable>());
    }

    public static JButton createPickAttributesButton(DrawingEditor drawingEditor, List<Disposable> list) {
        PickAttributesAction pickAttributesAction = new PickAttributesAction(drawingEditor);
        JButton jButton = new JButton(pickAttributesAction);
        list.add(pickAttributesAction);
        if (jButton.getIcon() != null) {
            jButton.putClientProperty("hideActionText", Boolean.TRUE);
        }
        jButton.setHorizontalTextPosition(0);
        jButton.setVerticalTextPosition(3);
        jButton.setText(null);
        jButton.setFocusable(false);
        return jButton;
    }

    public static JButton createApplyAttributesButton(DrawingEditor drawingEditor) {
        return ButtonFactory.createApplyAttributesButton(drawingEditor, new LinkedList<Disposable>());
    }

    public static JButton createApplyAttributesButton(DrawingEditor drawingEditor, List<Disposable> list) {
        ApplyAttributesAction applyAttributesAction = new ApplyAttributesAction(drawingEditor);
        JButton jButton = new JButton(applyAttributesAction);
        list.add(applyAttributesAction);
        if (jButton.getIcon() != null) {
            jButton.putClientProperty("hideActionText", Boolean.TRUE);
        }
        jButton.setHorizontalTextPosition(0);
        jButton.setVerticalTextPosition(3);
        jButton.setText(null);
        jButton.setFocusable(false);
        return jButton;
    }

    static {
        int n;
        int n2;
        int n3;
        LinkedList<ColorIcon> linkedList = new LinkedList<ColorIcon>();
        linkedList.add(new ColorIcon(0x800000, "Cayenne"));
        linkedList.add(new ColorIcon(0x808000, "Asparagus"));
        linkedList.add(new ColorIcon(32768, "Clover"));
        linkedList.add(new ColorIcon(32896, "Teal"));
        linkedList.add(new ColorIcon(128, "Midnight"));
        linkedList.add(new ColorIcon(0x800080, "Plum"));
        linkedList.add(new ColorIcon(0x7F7F7F, "Tin"));
        linkedList.add(new ColorIcon(0x808080, "Nickel"));
        linkedList.add(new ColorIcon(0xFF0000, "Maraschino"));
        linkedList.add(new ColorIcon(0xFFFF00, "Lemon"));
        linkedList.add(new ColorIcon(65280, "Spring"));
        linkedList.add(new ColorIcon(65535, "Turquoise"));
        linkedList.add(new ColorIcon(255, "Blueberry"));
        linkedList.add(new ColorIcon(0xFF00FF, "Magenta"));
        linkedList.add(new ColorIcon(0x666666, "Steel"));
        linkedList.add(new ColorIcon(0x999999, "Aluminium"));
        linkedList.add(new ColorIcon(0xFF6666, "Salmon"));
        linkedList.add(new ColorIcon(0xFFFF66, "Banana"));
        linkedList.add(new ColorIcon(0x66FF66, "Flora"));
        linkedList.add(new ColorIcon(0x66FFFF, "Ice"));
        linkedList.add(new ColorIcon(0x6666FF, "Orchid"));
        linkedList.add(new ColorIcon(0xFF66FF, "Bubblegum"));
        linkedList.add(new ColorIcon(0x4C4C4C, "Iron"));
        linkedList.add(new ColorIcon(0xB3B3B3, "Magnesium"));
        linkedList.add(new ColorIcon(0x804000, "Mocha"));
        linkedList.add(new ColorIcon(0x408000, "Fern"));
        linkedList.add(new ColorIcon(32832, "Moss"));
        linkedList.add(new ColorIcon(16512, "Ocean"));
        linkedList.add(new ColorIcon(0x400080, "Eggplant"));
        linkedList.add(new ColorIcon(0x800040, "Maroon"));
        linkedList.add(new ColorIcon(0x333333, "Tungsten"));
        linkedList.add(new ColorIcon(0xCCCCCC, "Silver"));
        linkedList.add(new ColorIcon(0xFF8000, "Tangerine"));
        linkedList.add(new ColorIcon(0x80FF00, "Lime"));
        linkedList.add(new ColorIcon(65408, "Sea Foam"));
        linkedList.add(new ColorIcon(33023, "Aqua"));
        linkedList.add(new ColorIcon(0x8000FF, "Grape"));
        linkedList.add(new ColorIcon(0xFF0080, "Strawberry"));
        linkedList.add(new ColorIcon(0x191919, "Lead"));
        linkedList.add(new ColorIcon(0xE6E6E6, "Mercury"));
        linkedList.add(new ColorIcon(0xFFCC66, "Cantaloupe"));
        linkedList.add(new ColorIcon(0xCCFF66, "Honeydew"));
        linkedList.add(new ColorIcon(0x66FFCC, "Spindrift"));
        linkedList.add(new ColorIcon(0x66CCFF, "Sky"));
        linkedList.add(new ColorIcon(0xCC66FF, "Lavender"));
        linkedList.add(new ColorIcon(0xFF6FCF, "Carnation"));
        linkedList.add(new ColorIcon(0, "Licorice"));
        linkedList.add(new ColorIcon(0xFFFFFF, "Snow"));
        DEFAULT_COLORS = Collections.unmodifiableList(linkedList);
        linkedList = new LinkedList();
        for (int i = 0; i <= 255; i += 51) {
            n3 = i << 16 | i << 8 | i;
            linkedList.add(new ColorIcon(n3));
            for (n2 = 0; n2 <= 102; n2 += 51) {
                for (n = 0; n <= 255; n += 51) {
                    n3 = n2 << 16 | n << 8 | i;
                    linkedList.add(new ColorIcon(n3));
                }
            }
        }
        Object object = new int[]{0xFF0000, 65280, 255, 0xFF00FF, 65535, 0xFFFF00};
        n3 = 0;
        n2 = 0;
        while (n3 <= 255) {
            n = n3 << 16 | n3 << 8 | n3;
            linkedList.add(new ColorIcon(object[n2]));
            for (int i = 153; i <= 255; i += 51) {
                for (int j = 0; j <= 255; j += 51) {
                    n = 0xFF000000 | i << 16 | j << 8 | n3;
                    linkedList.add(new ColorIcon(n));
                }
            }
            n3 += 51;
            ++n2;
        }
        WEBSAVE_COLORS = Collections.unmodifiableList(linkedList);
        linkedList = new LinkedList();
        object = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        linkedList.add(new ColorIcon(null, ((ResourceBundleUtil)object).getToolTipTextProperty("attribute.color.noColor")));
        for (n3 = 10; n3 >= 0; --n3) {
            linkedList.add(new ColorIcon(Color.HSBtoRGB(0.0f, 0.0f, (float)n3 * 0.1f)));
        }
        for (n3 = 2; n3 <= 10; n3 += 2) {
            for (n2 = 0; n2 < 12; ++n2) {
                linkedList.add(new ColorIcon(Color.HSBtoRGB((float)(n2 + 6) / 12.0f, 1.0f, (float)n3 * 0.1f)));
            }
        }
        for (n3 = 8; n3 > 0; n3 -= 2) {
            for (n2 = 0; n2 < 12; ++n2) {
                linkedList.add(new ColorIcon(Color.HSBtoRGB((float)(n2 + 6) / 12.0f, (float)n3 * 0.1f, 1.0f)));
            }
        }
        HSV_COLORS = Collections.unmodifiableList(linkedList);
    }

    private static class ToolButtonListener
    implements ItemListener {
        private Tool tool;
        private DrawingEditor editor;

        public ToolButtonListener(Tool tool, DrawingEditor drawingEditor) {
            this.tool = tool;
            this.editor = drawingEditor;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                this.editor.setTool(this.tool);
            }
        }
    }
}

