/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.odftoolkit.odfdom.type.CURIE;
import org.odftoolkit.odfdom.type.OdfDataType;

public class CURIEs
implements OdfDataType {
    private String mCURIEs;

    public CURIEs(List<CURIE> curies) throws IllegalArgumentException {
        if (curies == null || curies.size() == 0) {
            throw new IllegalArgumentException("parameter can not be null for CURIEs");
        }
        StringBuffer aRet = new StringBuffer();
        Iterator<CURIE> aIter = curies.iterator();
        while (aIter.hasNext()) {
            if (aRet.length() > 0) {
                aRet.append(' ');
            }
            String aCurie = aIter.next().toString();
            aRet.append(aCurie);
        }
        this.mCURIEs = aRet.toString();
    }

    public String toString() {
        return this.mCURIEs;
    }

    public static CURIEs valueOf(String stringValue) throws IllegalArgumentException {
        if (stringValue == null || stringValue.length() == 0) {
            throw new IllegalArgumentException("parameter is invalid for datatype CURIEs");
        }
        ArrayList<CURIE> aRet = new ArrayList<CURIE>();
        String[] names = stringValue.split(" ");
        for (int i = 0; i < names.length; ++i) {
            aRet.add(new CURIE(names[i]));
        }
        return new CURIEs(aRet);
    }

    public List<CURIE> getCURIEList() {
        ArrayList<CURIE> aRet = new ArrayList<CURIE>();
        String[] names = this.mCURIEs.split(" ");
        for (int i = 0; i < names.length; ++i) {
            aRet.add(new CURIE(names[i]));
        }
        return aRet;
    }

    public static boolean isValid(String stringValue) {
        if (stringValue == null) {
            return false;
        }
        if (stringValue.length() == 0) {
            return false;
        }
        String[] names = stringValue.split(" ");
        for (int i = 0; i < names.length; ++i) {
            if (CURIE.isValid(names[i])) continue;
            return false;
        }
        return true;
    }
}

