/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM ../../../storage/public/mozIStorageService.idl
 */

#ifndef __gen_mozIStorageService_h__
#define __gen_mozIStorageService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class mozIStorageConnection; /* forward declaration */

class nsIFile; /* forward declaration */


/* starting interface:    mozIStorageService */
#define MOZISTORAGESERVICE_IID_STR "a4a0cad9-e0da-4379-bee4-2feef3dddc7e"

#define MOZISTORAGESERVICE_IID \
  {0xa4a0cad9, 0xe0da, 0x4379, \
    { 0xbe, 0xe4, 0x2f, 0xee, 0xf3, 0xdd, 0xdc, 0x7e }}

/**
 * The mozIStorageService interface is intended to be implemented by
 * a service that can create storage connections (mozIStorageConnection)
 * to either a well-known profile database or to a specific database file.
 *
 * The implementation of this service using sqlite with the async IO module
 * must be created the first time on the main thread. If you want to use it
 * from another thread, you should be sure you call getService from the main
 * thread before accessing it from another thread.
 *
 * This is the only way to open a database connection.
 */
class NS_NO_VTABLE mozIStorageService : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(MOZISTORAGESERVICE_IID)

  /**
   * Get a connection to a named special database storage.
   *
   * @param aStorageKey a string key identifying the type of storage
   * requested.  Valid values include: "profile", "memory".
   *
   * @see openDatabase for restrictions on how database connections may be
   * used. For the profile database, you should only access it from the main
   * thread since other callers may also have connections.
   *
   * @returns a new mozIStorageConnection for the requested
   * storage database.
   *
   * @throws NS_ERROR_INVALID_ARG if aStorageKey is invalid.
   */
  /* mozIStorageConnection openSpecialDatabase (in string aStorageKey); */
  NS_IMETHOD OpenSpecialDatabase(const char *aStorageKey, mozIStorageConnection **_retval) = 0;

  /**
   * Open a connection to the specified file.
   *
   * ==========
   *   DANGER
   * ==========
   *
   * If you have more than one connection to a file, you MUST use the EXACT
   * SAME NAME for the file each time, including case. The sqlite code uses
   * a simple string compare to see if there is already a connection. Opening
   * a connection to "Foo.sqlite" and "foo.sqlite" will CORRUPT YOUR DATABASE.
   *
   * Opening connections from more than one thread to the same database will
   * also CORRUPT YOUR DATABASE. All connections share the same sqlite cache,
   * and the cache is not threadsafe.
   *
   * The connection object returned by this function is not threadsafe. You must
   * use it only from the thread you created it from.
   *
   * @param aDatabaseFile a nsIFile of the database to open.
   *
   * @returns a mozIStorageConnection for the requested
   * database file.
   *
   * @throws NS_ERROR_FAILURE if any operation fails while opening
   * the database.
   */
  /* mozIStorageConnection openDatabase (in nsIFile aDatabaseFile); */
  NS_IMETHOD OpenDatabase(nsIFile *aDatabaseFile, mozIStorageConnection **_retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_MOZISTORAGESERVICE \
  NS_IMETHOD OpenSpecialDatabase(const char *aStorageKey, mozIStorageConnection **_retval); \
  NS_IMETHOD OpenDatabase(nsIFile *aDatabaseFile, mozIStorageConnection **_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_MOZISTORAGESERVICE(_to) \
  NS_IMETHOD OpenSpecialDatabase(const char *aStorageKey, mozIStorageConnection **_retval) { return _to OpenSpecialDatabase(aStorageKey, _retval); } \
  NS_IMETHOD OpenDatabase(nsIFile *aDatabaseFile, mozIStorageConnection **_retval) { return _to OpenDatabase(aDatabaseFile, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_MOZISTORAGESERVICE(_to) \
  NS_IMETHOD OpenSpecialDatabase(const char *aStorageKey, mozIStorageConnection **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenSpecialDatabase(aStorageKey, _retval); } \
  NS_IMETHOD OpenDatabase(nsIFile *aDatabaseFile, mozIStorageConnection **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenDatabase(aDatabaseFile, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public mozIStorageService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_MOZISTORAGESERVICE

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, mozIStorageService)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* mozIStorageConnection openSpecialDatabase (in string aStorageKey); */
NS_IMETHODIMP _MYCLASS_::OpenSpecialDatabase(const char *aStorageKey, mozIStorageConnection **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* mozIStorageConnection openDatabase (in nsIFile aDatabaseFile); */
NS_IMETHODIMP _MYCLASS_::OpenDatabase(nsIFile *aDatabaseFile, mozIStorageConnection **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

#define MOZ_STORAGE_MEMORY_STORAGE_KEY    "memory"
#define MOZ_STORAGE_PROFILE_STORAGE_KEY   "profile"

#endif /* __gen_mozIStorageService_h__ */
