/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef LRFPARSER_H_INCLUDED
#define LRFPARSER_H_INCLUDED

#include <map>

#include "LRFCollector.h"

class WPXDocumentInterface;
class WPXInputStream;

namespace libebook
{

struct LRFHeader;

class LRFParser
{
  // disable copying
  LRFParser(const LRFParser &other);
  LRFParser &operator=(const LRFParser &other);

  enum ObjectType
  {
    OBJECT_TYPE_UNSPECIFIED = 0x0,
    OBJECT_TYPE_PAGE_TREE = 0x1,
    OBJECT_TYPE_PAGE = 0x2,
    OBJECT_TYPE_HEADER = 0x3,
    OBJECT_TYPE_FOOTER = 0x4,
    OBJECT_TYPE_PAGE_ATR = 0x5,
    OBJECT_TYPE_BLOCK = 0x6,
    OBJECT_TYPE_BLOCK_ATR = 0x7,
    OBJECT_TYPE_MINI_PAGE = 0x8,
    OBJECT_TYPE_BLOCK_LIST = 0x9,
    OBJECT_TYPE_TEXT = 0xa,
    OBJECT_TYPE_TEXT_ATR = 0xb,
    OBJECT_TYPE_IMAGE = 0xc,
    OBJECT_TYPE_CANVAS = 0xd,
    OBJECT_TYPE_PARAGRAPH_ATR = 0xe,
    OBJECT_TYPE_IMAGE_STREAM = 0x11,
    OBJECT_TYPE_IMPORT = 0x12,
    OBJECT_TYPE_BUTTON = 0x13,
    OBJECT_TYPE_WINDOW = 0x14,
    OBJECT_TYPE_POP_UP_WIN = 0x15,
    OBJECT_TYPE_SOUND = 0x16,
    OBJECT_TYPE_PLANE_STREAM = 0x17,
    OBJECT_TYPE_FONT = 0x19,
    OBJECT_TYPE_OBJECT_INFO = 0x1a,
    OBJECT_TYPE_BOOK_ATR = 0x1c,
    OBJECT_TYPE_SIMPLE_TEXT = 0x1d,
    OBJECT_TYPE_TOC = 0x1e
  };

  struct LRFIndexEntry
  {
    unsigned offset;
    unsigned size;
    bool reading;
    bool read;
  };

  typedef std::map<unsigned, LRFIndexEntry> ObjectIndex_t;

public:
  LRFParser(WPXInputStream *input, WPXDocumentInterface *document);
  ~LRFParser();

  bool parse();

  static bool isSupported(WPXInputStream *input);

private:
  void readHeader();
  void readMetadata();
  void readThumbnail();
  void readObjectIndex();

  void readObject(unsigned id, unsigned type = OBJECT_TYPE_UNSPECIFIED);

  void readPageTreeObject(WPXInputStream *object);
  void readPageObject(WPXInputStream *object);
  void readFooterObject(WPXInputStream *object);
  void readHeaderObject(WPXInputStream *object);
  void readPageAtrObject(WPXInputStream *object, unsigned id);
  void readBlockObject(WPXInputStream *object);
  void readBlockAtrObject(WPXInputStream *object, unsigned id);
  void readMiniPageObject(WPXInputStream *object);
  void readBlockListObject(WPXInputStream *object);
  void readTextObject(WPXInputStream *object);
  void readTextAtrObject(WPXInputStream *object, unsigned id);
  void readImageObject(WPXInputStream *object);
  void readCanvasObject(WPXInputStream *object);
  void readParagraphAtrObject(WPXInputStream *object, unsigned id);
  void readImageStreamObject(WPXInputStream *object, unsigned id);
  void readImportObject(WPXInputStream *object);
  void readButtonObject(WPXInputStream *object);
  void readWindowObject(WPXInputStream *object);
  void readPopUpWinObject(WPXInputStream *object);
  void readSoundObject(WPXInputStream *object);
  void readPlaneStreamObject(WPXInputStream *object);
  void readFontObject(WPXInputStream *object);
  void readObjectInfoObject(WPXInputStream *object);
  void readBookAtrObject(WPXInputStream *object);
  void readSimpleTextObject(WPXInputStream *object);
  void readTOCObject(WPXInputStream *object);

  bool readAttribute(unsigned tag, WPXInputStream *input, LRFAttributes &attributes);

  void skipUnhandledTag(unsigned tag, WPXInputStream *input, const char *objectType);

  bool isObjectRead(unsigned id) const;

private:
  LRFCollector m_collector;
  WPXInputStream *m_input;
  LRFHeader *m_header;
  ObjectIndex_t m_objectIndex;
  unsigned m_pageTree;
};

} // namespace libebook

#endif // LRFPARSER_H_INCLUDED
/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
