#pragma once

#define VFS5011_LINE_SIZE 240
#define VFS5011_IMAGE_WIDTH 160

enum {
  VFS5011_DEFAULT_WAIT_TIMEOUT = 3000,

  VFS5011_OUT_ENDPOINT = 1 | FPI_USB_ENDPOINT_OUT,
  VFS5011_IN_ENDPOINT_CTRL = 1 | FPI_USB_ENDPOINT_IN,
  VFS5011_IN_ENDPOINT_DATA = 2 | FPI_USB_ENDPOINT_IN,
  VFS5011_IN_ENDPOINT_CTRL2 = 3 | FPI_USB_ENDPOINT_IN,
};

enum {
  VFS5011_RECEIVE_BUF_SIZE = 102400
};

static unsigned char VFS5011_NORMAL_CONTROL_REPLY[] = {0x00, 0x00};

static unsigned char vfs5011_cmd_01[] = { /* 1 B */
  0x01,
};

static unsigned char vfs5011_cmd_19[] = { /* 1 B */
  0x19,
};

static unsigned char vfs5011_init_00[] = { /* 39 B */
  0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x9F, 0x00, 0x00, 0x00,
};

static unsigned char vfs5011_init_01[] = { /* 40 B */
  0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xAB, 0x00, 0x00, 0x00, 0x00,

};

static unsigned char vfs5011_init_02[] = { /* 578 B */
  0x06, 0x9C, 0xF1, 0x9D, 0x71, 0xC3, 0x13, 0xDF,
  0x5F, 0xE4, 0x7A, 0x1F, 0xC7, 0x17, 0x53, 0x9A,
  0x1A, 0xA1, 0xD7, 0xB6, 0x6E, 0xBE, 0xDF, 0x1F,
  0x9F, 0x44, 0x42, 0x22, 0xFA, 0x2A, 0x6A, 0xAB,
  0x2B, 0xF0, 0x56, 0x39, 0xE3, 0x7B, 0x53, 0x9A,
  0x1A, 0xA1, 0xDB, 0xBA, 0x62, 0xB2, 0xE4, 0x65,
  0xE5, 0xDB, 0x68, 0x04, 0x79, 0x98, 0xDE, 0x8F,
  0x23, 0xFB, 0xEC, 0xAD, 0x76, 0xCA, 0xA2, 0xEB,
  0x61, 0x38, 0xC7, 0xAB, 0x6E, 0x2E, 0x78, 0xF9,
  0x79, 0x13, 0x8A, 0xE5, 0x90, 0x22, 0x63, 0x8D,
  0x0E, 0x93, 0x25, 0x49, 0x5A, 0xC8, 0xA3, 0xD8,
  0x7E, 0xAE, 0x12, 0xF6, 0x2C, 0x1C, 0xFC, 0x48,
  0x4F, 0x0E, 0x48, 0x22, 0xFB, 0x4B, 0xCE, 0x7E,
  0xDB, 0x2D, 0x91, 0xE0, 0xC8, 0x78, 0x2E, 0xAF,
  0x2F, 0xD4, 0x03, 0x6F, 0x12, 0x59, 0xC6, 0x26,
  0x40, 0x88, 0x2E, 0x62, 0xBA, 0x06, 0x6C, 0xC9,
  0x7A, 0x84, 0x93, 0xCF, 0x14, 0x15, 0x44, 0x87,
  0xE2, 0x09, 0x97, 0xE6, 0xCE, 0x7E, 0x28, 0xA9,
  0x29, 0x53, 0xD7, 0xB8, 0xD1, 0x53, 0x30, 0x15,
  0x6E, 0x95, 0x3E, 0xA2, 0x7A, 0xCA, 0x9C, 0x1D,
  0x9D, 0xEB, 0x5F, 0x15, 0xEF, 0x48, 0x34, 0xCC,
  0xCB, 0x02, 0xA6, 0xD6, 0xA7, 0x80, 0xF2, 0x3F,
  0x7E, 0x96, 0x23, 0xAE, 0x42, 0xF1, 0x29, 0xF5,
  0xAD, 0x5A, 0x35, 0x57, 0x36, 0xAA, 0xAF, 0x97,
  0xE8, 0x1E, 0xA2, 0xD3, 0xFB, 0x4B, 0x1D, 0x9C,
  0x1C, 0x06, 0x84, 0xEB, 0x9E, 0x2C, 0xD4, 0x18,
  0x94, 0x44, 0x7E, 0x4B, 0x12, 0x91, 0xF2, 0x8B,
  0x07, 0x45, 0xDB, 0x52, 0xBB, 0x2E, 0x53, 0x63,
  0xE3, 0x38, 0xB8, 0x95, 0x4D, 0x9B, 0xCF, 0x07,
  0x05, 0xDD, 0x4C, 0xE2, 0x39, 0xAF, 0xA9, 0x51,
  0xDB, 0xAD, 0x19, 0xC8, 0x13, 0x6E, 0x0A, 0x2F,
  0xEA, 0x12, 0xB9, 0x25, 0x55, 0xB6, 0x64, 0x04,
  0x7F, 0x14, 0x6E, 0x12, 0x08, 0xFB, 0xBD, 0xBD,
  0x1D, 0xC6, 0xE2, 0x84, 0x50, 0x20, 0x60, 0xA0,
  0x90, 0xD2, 0x74, 0x8A, 0x18, 0xA4, 0xD9, 0xE9,
  0x69, 0xB2, 0x1E, 0x73, 0xAB, 0x1B, 0x7B, 0xBB,
  0x3B, 0xE0, 0x42, 0x23, 0xF9, 0x29, 0x49, 0x89,
  0x09, 0xD2, 0x4C, 0x29, 0xF1, 0x21, 0x65, 0xAC,
  0x2C, 0x97, 0x30, 0x6C, 0xB4, 0x04, 0xF4, 0x3D,
  0xBD, 0x06, 0xA0, 0xC6, 0x1E, 0xCE, 0x7E, 0xB3,
  0x33, 0x88, 0x2E, 0x43, 0x9B, 0x2B, 0x37, 0xF0,
  0x70, 0xCB, 0x91, 0xF1, 0x2B, 0xFB, 0x8B, 0x48,
  0xCA, 0x39, 0x97, 0xFB, 0x21, 0xB9, 0xCD, 0x0E,
  0x8C, 0x7F, 0x8D, 0xEC, 0x36, 0xE6, 0xEA, 0x27,
  0xA5, 0x1E, 0x40, 0x2A, 0xF2, 0x22, 0xCA, 0x07,
  0x85, 0x3E, 0xC8, 0xAE, 0x76, 0xA6, 0xF0, 0x71,
  0xF1, 0xAB, 0x6B, 0x04, 0x6D, 0xA9, 0xCA, 0x06,
  0x2C, 0x66, 0xA5, 0xCA, 0xB0, 0x4B, 0x2B, 0x62,
  0xEB, 0xD5, 0x61, 0x0D, 0xF0, 0x46, 0x26, 0xC3,
  0x44, 0x9F, 0x0C, 0x63, 0xBB, 0xAA, 0xBD, 0x7E,
  0xF2, 0x74, 0x00, 0x66, 0x2B, 0x7A, 0x62, 0xA1,
  0x07, 0x80, 0x33, 0x8D, 0x1F, 0xF7, 0x45, 0xCB,
  0x5E, 0x24, 0xEB, 0x84, 0xED, 0x27, 0x44, 0x61,
  0xFF, 0x0C, 0xA7, 0x3B, 0xE3, 0x53, 0x05, 0x84,
  0x04, 0xEE, 0x23, 0x4C, 0xB5, 0x79, 0x1A, 0xF3,
  0xA0, 0x66, 0x20, 0x4C, 0x94, 0x24, 0x72, 0xF3,
  0x73, 0x39, 0xF8, 0x97, 0xDD, 0x64, 0x54, 0xF2,
  0x6B, 0xBA, 0xAD, 0xBC, 0x67, 0x66, 0x78, 0xBB,
  0x5E, 0x6D, 0xFB, 0x8A, 0xA2, 0x74, 0x3D, 0xF5,
  0xD4, 0x72, 0xC7, 0x1A, 0xBD, 0x0E, 0x0B, 0x2C,
  0x8C, 0x4A, 0x0C, 0x60, 0xB8, 0x08, 0x5E, 0xDF,
  0x5F, 0x05, 0x33, 0x5C, 0xB5, 0x7E, 0x1D, 0xFC,
  0xFD, 0x25, 0xBA, 0x95, 0xC4, 0xA7, 0xDA, 0xEA,
  0x6A, 0xB1, 0x31, 0x1C, 0xC4, 0xE5, 0x07, 0xC4,
  0xC5, 0x9D, 0x28, 0xCD, 0x3C, 0xE9, 0x89, 0x49,
  0xD4, 0xFF, 0x7F, 0x52, 0x8A, 0x9B, 0x7F, 0xBC,
  0x8E, 0xF5, 0xCF, 0x0B, 0xD9, 0x49, 0x48, 0x88,
  0x80, 0x71, 0x7D, 0xAB, 0xEF, 0x47, 0x2B, 0xF7,
  0x7B, 0x2D, 0x79, 0x3F, 0xCF, 0xBF, 0xFF, 0x3F,
  0x6D, 0xF8, 0x42, 0xEC, 0x7F, 0xE8, 0xED, 0x42,
  0xE6, 0x1D, 0x4D, 0x32, 0xFA, 0x6A, 0x0A, 0xD7,
  0xA7, 0x7C, 0xCB, 0xA7, 0x7B, 0xCB, 0xBF, 0x71,
  0xF3, 0x48,
};

static unsigned char vfs5011_cmd_1A[] = { /* 1 B */
  0x1A,
};

static unsigned char vfs5011_init_03[] = { /* 2354 B */
  0x06, 0xFE, 0x93, 0xFF, 0x03, 0xBA, 0x6A, 0xA6,
  0x26, 0x9D, 0x03, 0x66, 0xBE, 0x6E, 0x2A, 0xE3,
  0x63, 0xD8, 0xFE, 0x9B, 0x43, 0x93, 0xD7, 0x03,
  0x83, 0x38, 0x8C, 0xE0, 0x38, 0x88, 0x58, 0x94,
  0x14, 0xAF, 0xC9, 0xA2, 0x7A, 0xCA, 0x96, 0x5E,
  0xDE, 0x65, 0x27, 0x36, 0xEA, 0x3A, 0x4E, 0x82,
  0x02, 0xB9, 0x0F, 0x4B, 0x97, 0x17, 0xF7, 0x1A,
  0x9E, 0x75, 0xC3, 0x8F, 0x53, 0xD3, 0x9F, 0x7F,
  0xFB, 0x10, 0xE6, 0xAA, 0x76, 0xF6, 0x72, 0x93,
  0x17, 0xFC, 0x4A, 0x26, 0xFE, 0x76, 0x2A, 0xEA,
  0x6A, 0x89, 0x3F, 0xF3, 0x2B, 0xA3, 0xFF, 0x9F,
  0x1F, 0xFC, 0x4A, 0x06, 0xDE, 0x56, 0x38, 0xD8,
  0x58, 0xBB, 0x0D, 0x21, 0xF9, 0x71, 0x19, 0x99,
  0x19, 0xFA, 0x4C, 0x40, 0x98, 0x10, 0x78, 0xD8,
  0x58, 0xBB, 0x0D, 0xE1, 0x39, 0xB1, 0xD9, 0x99,
  0x19, 0xFA, 0x6C, 0x7E, 0xA2, 0x72, 0xC6, 0x7D,
  0xF9, 0x42, 0xF4, 0x86, 0x5A, 0xDA, 0xD2, 0x06,
  0x86, 0x3D, 0x6F, 0x08, 0xD0, 0x00, 0xD8, 0x10,
  0x90, 0x2B, 0xFD, 0xB7, 0x6B, 0xBB, 0x67, 0xA0,
  0x20, 0x9B, 0x35, 0x36, 0xEA, 0x3A, 0xA2, 0x0C,
  0x88, 0x33, 0x7D, 0x1A, 0xC2, 0x12, 0x2A, 0xFE,
  0x7E, 0xC5, 0x8C, 0x17, 0x30, 0x7F, 0xE0, 0xCF,
  0xB0, 0x94, 0x4E, 0x36, 0xEE, 0x3E, 0x5E, 0x96,
  0x16, 0xCD, 0x9F, 0xE1, 0x3B, 0xEB, 0x8B, 0x5B,
  0xDB, 0x00, 0x8A, 0xF2, 0x2A, 0xFA, 0x0E, 0xC8,
  0x48, 0xF3, 0x6D, 0x12, 0xC8, 0x18, 0x08, 0xDC,
  0x5C, 0xE7, 0x01, 0x79, 0xA1, 0x71, 0x3D, 0xF4,
  0x74, 0xCF, 0x84, 0x17, 0xCF, 0x7F, 0xE0, 0x20,
  0x5F, 0x7B, 0xFB, 0xD6, 0x0E, 0x1B, 0x65, 0xA5,
  0x00, 0xDC, 0x6A, 0xE3, 0x7E, 0xCE, 0x4B, 0xCE,
  0x68, 0x22, 0xB8, 0xD7, 0xAE, 0x33, 0x50, 0x9C,
  0x14, 0x46, 0xFA, 0x14, 0x85, 0x35, 0x48, 0x78,
  0xF8, 0x23, 0xA3, 0x8E, 0x56, 0x77, 0x39, 0xFA,
  0x76, 0xA5, 0x91, 0xB4, 0x34, 0xE1, 0x4D, 0xA8,
  0x35, 0x1E, 0x9E, 0xB3, 0x6B, 0x6A, 0x3A, 0xF9,
  0xD4, 0x0D, 0x9A, 0xD9, 0x02, 0xF4, 0x94, 0x54,
  0x1F, 0xE6, 0x5B, 0x8C, 0x72, 0xC9, 0xA3, 0xEB,
  0x69, 0x32, 0x04, 0x1C, 0x43, 0x69, 0xF9, 0x3F,
  0xBE, 0x65, 0xF6, 0xFE, 0x03, 0x9E, 0xF4, 0x29,
  0x59, 0x82, 0x02, 0x2F, 0xF7, 0x67, 0x66, 0xA6,
  0x03, 0x22, 0x6B, 0x27, 0x19, 0xBA, 0xCA, 0x2A,
  0xAA, 0x7D, 0xC1, 0x08, 0xF6, 0x63, 0xA2, 0x53,
  0xD0, 0xBA, 0x3E, 0x51, 0xAC, 0x38, 0x70, 0xAD,
  0xDD, 0x06, 0x86, 0xAB, 0x73, 0xF2, 0xA1, 0x62,
  0xC3, 0x2C, 0x99, 0xDC, 0x47, 0xEA, 0x7A, 0xBA,
  0x3A, 0xE1, 0x61, 0x4C, 0x94, 0xA6, 0xC4, 0x09,
  0x85, 0x45, 0x73, 0x9F, 0x43, 0xA5, 0xDD, 0x1A,
  0x96, 0x48, 0xF2, 0x98, 0x02, 0xA0, 0xCE, 0x12,
  0x95, 0x74, 0x86, 0x58, 0x44, 0x75, 0x27, 0xE3,
  0x63, 0x0A, 0xB7, 0xA5, 0xBF, 0x0B, 0x6A, 0x9D,
  0xA6, 0x71, 0xF0, 0x20, 0xE9, 0x64, 0x0F, 0x08,
  0x33, 0xE4, 0x6F, 0x0F, 0x11, 0xA0, 0xC0, 0x37,
  0x8B, 0x54, 0x25, 0xF2, 0x2B, 0xA6, 0xCD, 0xA0,
  0x23, 0x45, 0xF0, 0xF9, 0x99, 0x01, 0xCB, 0x6D,
  0xB7, 0x3F, 0x82, 0x99, 0x0A, 0xFE, 0x2C, 0x28,
  0x29, 0xA4, 0x85, 0x15, 0x60, 0xD5, 0x08, 0xCD,
  0x68, 0x04, 0x9A, 0xFA, 0x39, 0x5B, 0x99, 0x35,
  0x15, 0x0A, 0xFD, 0x51, 0x4F, 0x3F, 0x85, 0x97,
  0xE5, 0x23, 0x17, 0xBB, 0xA7, 0x56, 0xF6, 0xB5,
  0x74, 0x5F, 0x06, 0x9A, 0xA2, 0xF1, 0xB0, 0xFA,
  0x94, 0xBF, 0xC7, 0x38, 0x22, 0xCF, 0x2D, 0xEB,
  0x68, 0xB3, 0xC7, 0x09, 0xBD, 0xC7, 0x65, 0x67,
  0xFB, 0x5D, 0xD1, 0x71, 0x6B, 0xD7, 0xB7, 0xA5,
  0x37, 0xE5, 0x7E, 0x19, 0x16, 0x1A, 0x7B, 0xB7,
  0x15, 0xD3, 0x95, 0xF9, 0x21, 0x91, 0xC7, 0x46,
  0xC6, 0xAC, 0x2F, 0x40, 0x20, 0x9B, 0x77, 0xDC,
  0xFE, 0x84, 0x52, 0x94, 0xE7, 0xF2, 0x28, 0xC8,
  0xE5, 0x3C, 0x2F, 0xEF, 0x12, 0xBF, 0x2F, 0xEF,
  0x6F, 0xB4, 0x34, 0x19, 0xC1, 0xD0, 0x86, 0x45,
  0x74, 0x98, 0x2D, 0x8C, 0x56, 0x43, 0x75, 0x90,
  0xA1, 0x43, 0xF6, 0xBA, 0x48, 0x58, 0x99, 0x61,
  0xE2, 0xF4, 0x40, 0x89, 0x04, 0x91, 0x40, 0xBB,
  0x38, 0xC3, 0x4F, 0x83, 0x99, 0xEA, 0x9A, 0xFB,
  0x41, 0x99, 0x23, 0x4D, 0xBC, 0x0F, 0x46, 0x95,
  0x3C, 0xC4, 0x5B, 0x04, 0xF9, 0x1D, 0x58, 0x29,
  0x94, 0x4C, 0xCA, 0x9C, 0xE4, 0x96, 0x35, 0xE5,
  0xC4, 0x23, 0x96, 0xDF, 0x54, 0xC1, 0xAD, 0x64,
  0xD4, 0x35, 0x23, 0x7D, 0x66, 0xC6, 0xBD, 0xE4,
  0x4D, 0x95, 0x68, 0x37, 0x89, 0xA0, 0x36, 0x5B,
  0xD8, 0xB1, 0xA7, 0x6E, 0x9A, 0x66, 0x23, 0x41,
  0xE9, 0x93, 0x1B, 0x74, 0x1D, 0x92, 0xF1, 0xF3,
  0xB0, 0x4F, 0x5C, 0x60, 0x9D, 0x9C, 0xBD, 0x7E,
  0xCE, 0x2F, 0x39, 0xF4, 0x6C, 0xDF, 0x8D, 0x8E,
  0x2A, 0x3C, 0x89, 0xC0, 0x4A, 0xDF, 0x0E, 0x8D,
  0x0E, 0xE5, 0x69, 0xA5, 0xDC, 0x2E, 0x4D, 0x40,
  0xC3, 0xFD, 0x18, 0x51, 0x38, 0xCD, 0xAE, 0x5E,
  0xE4, 0x9F, 0x88, 0xA0, 0x7B, 0x06, 0x65, 0x40,
  0x92, 0x6C, 0x6B, 0x40, 0x9B, 0x1B, 0x41, 0x21,
  0x00, 0x9D, 0x28, 0x89, 0x52, 0xC7, 0xF5, 0x10,
  0xA0, 0x51, 0x47, 0x36, 0x1E, 0xAE, 0xF8, 0x79,
  0xF9, 0x07, 0x94, 0xF8, 0xA1, 0x58, 0x3B, 0x6A,
  0xD9, 0x01, 0x16, 0x32, 0xE9, 0xF0, 0xC9, 0x80,
  0x09, 0xCF, 0x89, 0xE5, 0x3D, 0x8D, 0xDB, 0x5A,
  0xDA, 0x30, 0xB3, 0xDC, 0x08, 0x9F, 0xC7, 0x04,
  0xD5, 0x44, 0xF1, 0x0F, 0xD4, 0x6C, 0x6E, 0x0F,
  0xFF, 0x2F, 0x10, 0x6A, 0xFA, 0x4C, 0xFD, 0x76,
  0xF5, 0x22, 0xFE, 0x9E, 0x41, 0x73, 0xDA, 0xE6,
  0x70, 0xA3, 0x1F, 0x55, 0xD4, 0x6C, 0xA1, 0x63,
  0x06, 0x1C, 0x8C, 0xCD, 0x1F, 0xB2, 0x22, 0x88,
  0x4B, 0x22, 0x87, 0xE0, 0xAA, 0x1E, 0x7E, 0xA8,
  0x13, 0xC3, 0x13, 0x06, 0xCE, 0xBC, 0xC8, 0xF4,
  0x22, 0x55, 0xE9, 0x27, 0xBC, 0x04, 0x46, 0x85,
  0x08, 0xF3, 0x64, 0x0C, 0xC9, 0x89, 0xE5, 0x2E,
  0x2C, 0xF4, 0x4F, 0xE1, 0x1A, 0x77, 0x00, 0xA8,
  0x27, 0x6E, 0xD5, 0xB9, 0x6D, 0xCF, 0xB9, 0x50,
  0xDE, 0x0E, 0x11, 0xDF, 0x4A, 0xFA, 0xDC, 0x1C,
  0x9C, 0x4B, 0xFF, 0x53, 0xAB, 0x1B, 0xD9, 0x0A,
  0x82, 0x9B, 0x48, 0x84, 0xD0, 0x7A, 0xFF, 0xD5,
  0x73, 0xB5, 0xF3, 0xF5, 0x6E, 0x0C, 0x68, 0xA8,
  0x4E, 0x88, 0x02, 0xD6, 0x2C, 0x31, 0x52, 0x77,
  0x13, 0xEE, 0xF8, 0x74, 0xD8, 0x0E, 0x70, 0x91,
  0xA0, 0x37, 0x82, 0x1C, 0xCF, 0x7F, 0x39, 0xD6,
  0x51, 0xF8, 0x05, 0x69, 0xBD, 0x07, 0xC2, 0x68,
  0xCD, 0x1A, 0x94, 0x6A, 0x91, 0xFF, 0x5F, 0xBF,
  0x3F, 0x76, 0xA5, 0x69, 0x33, 0xC0, 0xA8, 0x2E,
  0xAD, 0x76, 0x62, 0x1D, 0xC2, 0xFE, 0xE4, 0x56,
  0x92, 0x49, 0x5D, 0x22, 0xFD, 0xE8, 0x6E, 0x88,
  0x04, 0xCD, 0x66, 0xFA, 0x90, 0x33, 0x5B, 0xF1,
  0x32, 0xFF, 0x82, 0xE9, 0xF3, 0x47, 0x27, 0x25,
  0x69, 0x49, 0xE9, 0xB9, 0x66, 0x34, 0x57, 0x9A,
  0x98, 0x67, 0x50, 0x2B, 0x9D, 0x7D, 0x8F, 0x42,
  0xC2, 0x0F, 0x30, 0x50, 0x84, 0x26, 0x4D, 0x74,
  0x06, 0x90, 0x26, 0xCC, 0x04, 0xB4, 0x56, 0x5F,
  0x26, 0xAB, 0x85, 0x1C, 0x7C, 0xEE, 0x23, 0xE0,
  0x85, 0x83, 0x13, 0xDF, 0x97, 0x53, 0x38, 0x61,
  0xB7, 0x85, 0x39, 0x59, 0x8A, 0x36, 0x1A, 0x38,
  0x9B, 0x9D, 0xF9, 0x37, 0x9B, 0xF1, 0x42, 0x42,
  0xE2, 0x39, 0x2D, 0x52, 0x82, 0xD0, 0xD5, 0xB5,
  0x47, 0xC1, 0x09, 0xA7, 0x3C, 0x84, 0xF2, 0x78,
  0x0A, 0xDD, 0x05, 0x8B, 0x17, 0xA7, 0x65, 0xB6,
  0x3E, 0x00, 0x69, 0x23, 0x7D, 0x08, 0x97, 0x7A,
  0xFD, 0x2A, 0x93, 0x3F, 0xC7, 0x77, 0xB5, 0x66,
  0xEE, 0xB7, 0x64, 0xA8, 0x66, 0x4C, 0xDF, 0x7A,
  0x24, 0xD9, 0x72, 0xEE, 0x3A, 0x88, 0xAE, 0xA6,
  0xD9, 0xBA, 0x2E, 0xEF, 0x34, 0x21, 0x99, 0x7F,
  0x5F, 0x14, 0xD6, 0xDC, 0x1D, 0x8A, 0xE6, 0x2D,
  0x7F, 0x87, 0xEC, 0x42, 0x38, 0xFC, 0x56, 0x55,
  0x15, 0xEE, 0x58, 0xE6, 0x5B, 0x4B, 0x89, 0x5A,
  0xD2, 0x7B, 0x91, 0x83, 0xE7, 0x0D, 0x07, 0x24,
  0xA8, 0x1E, 0x7A, 0x58, 0x80, 0x92, 0xE1, 0x29,
  0x4C, 0x4D, 0xDD, 0x37, 0xE6, 0x56, 0x3A, 0x85,
  0x09, 0x86, 0x72, 0x5D, 0x8D, 0x57, 0x74, 0x46,
  0x82, 0x59, 0x5D, 0x22, 0xF1, 0xDD, 0xF6, 0x84,
  0x50, 0x77, 0xCD, 0x5B, 0x8F, 0xB7, 0x55, 0xD1,
  0x51, 0x6F, 0x01, 0x4B, 0x01, 0xA5, 0x39, 0x6B,
  0x22, 0x08, 0x2C, 0x14, 0x30, 0xA2, 0xC1, 0x0C,
  0xAC, 0x56, 0xE4, 0x95, 0xBD, 0x20, 0x47, 0x01,
  0x5E, 0x7A, 0x6E, 0x16, 0x32, 0x94, 0x2E, 0x06,
  0x8A, 0xD9, 0xED, 0xC5, 0x1D, 0x1B, 0xC1, 0x11,
  0x9D, 0xBC, 0x2F, 0x95, 0x6B, 0xF9, 0x8D, 0xB1,
  0x13, 0x0A, 0x4D, 0x03, 0x8F, 0xC3, 0xA5, 0xF8,
  0x87, 0x39, 0x5A, 0x10, 0xE5, 0x52, 0x74, 0x48,
  0x37, 0xEC, 0x6C, 0x41, 0x99, 0x78, 0x2D, 0xEE,
  0x36, 0xE8, 0x1C, 0xD0, 0xF8, 0x02, 0x27, 0xD5,
  0x51, 0x0A, 0x9A, 0xD5, 0x3C, 0xAA, 0x89, 0x7A,
  0x9B, 0x0A, 0xBF, 0xA2, 0x31, 0x82, 0xEE, 0x86,
  0x20, 0x98, 0x01, 0x0B, 0x50, 0xFE, 0x92, 0x21,
  0x33, 0xCD, 0xA5, 0x09, 0xF1, 0x41, 0xB3, 0x15,
  0x35, 0xDC, 0x2E, 0xC2, 0xA8, 0x1D, 0x70, 0x12,
  0x95, 0x4E, 0x48, 0x95, 0x49, 0x49, 0x81, 0xD2,
  0xF0, 0x6C, 0xDA, 0xAB, 0x83, 0x2E, 0xBE, 0x72,
  0xE1, 0x7C, 0xCA, 0xA6, 0x72, 0xF1, 0xA3, 0x27,
  0x27, 0xE1, 0xA7, 0xC7, 0x4C, 0x3E, 0x7B, 0x65,
  0x25, 0xDE, 0x68, 0xC6, 0x78, 0x68, 0xCE, 0xFD,
  0x82, 0x59, 0xD9, 0xF4, 0x2C, 0xAD, 0x80, 0x43,
  0xE2, 0x77, 0xC2, 0x87, 0x4C, 0xE1, 0x71, 0xB1,
  0x31, 0xEA, 0x6A, 0x47, 0x9F, 0xBE, 0xEB, 0x28,
  0x30, 0xE2, 0xD8, 0x1D, 0x67, 0xFE, 0x43, 0x23,
  0x03, 0xCC, 0x5C, 0x0A, 0xD0, 0x05, 0x22, 0xC3,
  0x5E, 0x75, 0xF5, 0xD8, 0x00, 0x11, 0x21, 0xE2,
  0x43, 0xD1, 0x64, 0x39, 0xD2, 0x61, 0x90, 0x1F,
  0x9C, 0xC6, 0x21, 0x4E, 0x1F, 0x86, 0xCF, 0x0C,
  0x25, 0xA7, 0x0C, 0x90, 0x48, 0xF8, 0xAE, 0x2F,
  0xAF, 0x55, 0xB1, 0xDE, 0x8E, 0x1C, 0xBB, 0x13,
  0x8E, 0xF4, 0x11, 0x7E, 0x43, 0xBE, 0xF6, 0xA7,
  0x73, 0xAB, 0xDC, 0xE5, 0x3E, 0x3F, 0x09, 0xCA,
  0xE2, 0x1B, 0x15, 0x72, 0x6A, 0x70, 0x00, 0x50,
  0x4A, 0x81, 0x87, 0x71, 0x3A, 0x13, 0x51, 0xB4,
  0xFA, 0x04, 0xAF, 0x33, 0xEB, 0x5B, 0x0D, 0x8C,
  0x0C, 0x76, 0x93, 0xFC, 0x41, 0xB6, 0xFE, 0xDF,
  0x08, 0xD0, 0x27, 0x78, 0xA3, 0x22, 0x10, 0xD3,
  0x5F, 0x88, 0xE6, 0xA9, 0x80, 0x66, 0x05, 0x72,
  0x9F, 0x66, 0x6D, 0x0E, 0x1E, 0xAA, 0x03, 0xCC,
  0xE1, 0x38, 0x0F, 0x3B, 0xE0, 0xB0, 0x4D, 0xAD,
  0xB4, 0x4C, 0x73, 0x1B, 0xA6, 0x13, 0x73, 0x02,
  0xDB, 0x03, 0x1D, 0x52, 0x86, 0x34, 0xE4, 0x8E,
  0x2E, 0x5C, 0xC9, 0xB8, 0x90, 0x2C, 0x47, 0x41,
  0x37, 0x13, 0x93, 0xBE, 0x66, 0xCA, 0x62, 0x25,
  0x37, 0xE8, 0x7F, 0x49, 0x92, 0x3F, 0xAF, 0xC2,
  0x40, 0x3E, 0x4E, 0x07, 0xF2, 0x48, 0x35, 0x05,
  0x85, 0x5E, 0xDE, 0xF3, 0x2B, 0xDA, 0xE1, 0x22,
  0x93, 0x14, 0xA1, 0x45, 0xD9, 0xE0, 0x02, 0xFB,
  0x3F, 0xF9, 0xBF, 0xD3, 0x0B, 0xBB, 0xED, 0x6C,
  0xEC, 0x95, 0xE1, 0x9D, 0x60, 0xAB, 0xEB, 0xBA,
  0x61, 0xB9, 0x87, 0x69, 0x38, 0xC1, 0xBC, 0x8C,
  0x0C, 0xD7, 0x57, 0x7A, 0xA2, 0xAF, 0xCD, 0x2C,
  0xF1, 0x29, 0xB7, 0xD9, 0x0D, 0x31, 0xDA, 0xB8,
  0x1D, 0x8C, 0x12, 0xFF, 0x79, 0xCA, 0x38, 0x3A,
  0xAA, 0xE8, 0x0C, 0xF9, 0x63, 0x5A, 0x58, 0x14,
  0x97, 0x75, 0x51, 0x20, 0x08, 0xB8, 0xEE, 0x6F,
  0xEF, 0x05, 0xEE, 0x81, 0x61, 0xD2, 0x00, 0xD3,
  0x4B, 0x9C, 0x36, 0x5D, 0x6E, 0xC4, 0x35, 0xAA,
  0x29, 0x32, 0x2F, 0x63, 0x19, 0xFA, 0x82, 0x82,
  0x22, 0xF9, 0xD7, 0xB2, 0xE8, 0x4B, 0x2D, 0x4F,
  0x0C, 0xC7, 0xEB, 0x0F, 0x5E, 0x9D, 0x18, 0xAB,
  0x0B, 0x62, 0xC7, 0xB3, 0x7C, 0x27, 0x49, 0x31,
  0x22, 0x75, 0x58, 0xBC, 0x6F, 0x72, 0x10, 0x30,
  0xB8, 0x63, 0xF8, 0x9E, 0x5B, 0x1B, 0x77, 0xB5,
  0x28, 0x03, 0x83, 0xAE, 0x76, 0xF7, 0xCA, 0x09,
  0xB1, 0x69, 0x6D, 0x13, 0xDF, 0xA7, 0x64, 0x0C,
  0xAF, 0xBE, 0xB3, 0x66, 0x1D, 0x0A, 0x51, 0xC0,
  0xE0, 0xA0, 0xD6, 0x38, 0xF3, 0x5B, 0xA2, 0xC1,
  0x56, 0xE5, 0x78, 0xD6, 0xA6, 0xE9, 0x68, 0xC8,
  0x4B, 0x68, 0x6D, 0xC1, 0x39, 0x89, 0x3B, 0xE8,
  0x70, 0x1A, 0xE6, 0x89, 0xB1, 0xDC, 0xAC, 0x9E,
  0x75, 0x0E, 0x6A, 0x55, 0x95, 0xE5, 0xA5, 0x65,
  0x47, 0xB7, 0x81, 0x2D, 0xD5, 0x65, 0xC5, 0xAF,
  0x3F, 0x46, 0x9B, 0x77, 0xE9, 0x58, 0x38, 0x5A,
  0x19, 0xD2, 0xC1, 0xC3, 0x3B, 0x4B, 0x0B, 0xCB,
  0xDA, 0x5E, 0xEB, 0x05, 0xCE, 0x78, 0x80, 0x49,
  0x6B, 0x73, 0xD5, 0x23, 0x73, 0x4A, 0x59, 0x7C,
  0x97, 0x6C, 0x52, 0xBD, 0xC8, 0x7A, 0xFA, 0x32,
  0xB2, 0x74, 0x32, 0x5E, 0x86, 0x36, 0x60, 0xE1,
  0x61, 0xF8, 0xE6, 0x75, 0x3C, 0xED, 0x8E, 0xFF,
  0x22, 0xFA, 0x7D, 0x5B, 0x80, 0x88, 0xE3, 0xE1,
  0x7A, 0xB9, 0x03, 0x42, 0x4A, 0x36, 0x76, 0x74,
  0xAF, 0x6C, 0x1A, 0x56, 0x8E, 0x9C, 0xDF, 0xBF,
  0x96, 0xF6, 0x80, 0xCC, 0x14, 0x26, 0x65, 0x05,
  0x45, 0xBE, 0x08, 0xF4, 0xA4, 0x04, 0xF6, 0x97,
  0x17, 0x5C, 0x62, 0x2E, 0x74, 0xA7, 0x67, 0x67,
  0xC7, 0x1C, 0x88, 0xC7, 0x9F, 0xEF, 0xAF, 0x6F,
  0xAF, 0x56, 0xF0, 0xDE, 0xA2, 0x12, 0x32, 0xD0,
  0x70, 0x89, 0x5C, 0xB0, 0x75, 0x35, 0x63, 0xE2,
  0x62, 0xDF, 0x5D, 0x39, 0x63, 0xD0, 0x97, 0x95,
  0x16, 0xEB, 0x3B, 0x6F, 0xBD, 0xA0, 0xC2, 0xBF,
  0x3C, 0x2A, 0x98, 0x51, 0x56, 0xC4, 0xB9, 0x89,
  0xA1, 0x29, 0x2D, 0xE1, 0xC2, 0xC2, 0x6E, 0xBE,
  0xFC, 0x64, 0xF4, 0x58, 0xA0, 0x10, 0xE2, 0x28,
  0xA4, 0xBF, 0x29, 0x45, 0x2D, 0x04, 0x74, 0x26,
  0xEC, 0x3B, 0x90, 0x0C, 0xD4, 0x64, 0x1E, 0xDF,
  0x5F, 0x84, 0x32, 0x5E, 0x86, 0x36, 0xB6, 0x7B,
  0xF9, 0x42, 0xF0, 0x9D, 0x45, 0xF5, 0x95, 0x55,
  0xD5, 0x0E, 0x14, 0x76, 0xAC, 0x7C, 0x00, 0xC0,
  0x48, 0x93, 0x58, 0x30, 0x96, 0x22, 0x7E, 0xAC,
  0x2E, 0x95, 0xBB, 0xC5, 0x1F, 0xCF, 0x03, 0xD1,
  0x53, 0xE8, 0xC2, 0xBD, 0x67, 0xB7, 0xFF, 0x2C,
  0xAE, 0x15, 0xEB, 0x93, 0x4B, 0x9B, 0xB7, 0x63,
  0xE3, 0x58, 0x9E, 0xE6, 0x3E, 0xEE, 0xBA, 0x7A,
  0xFA, 0x21, 0x97, 0xFB, 0x23, 0x93, 0xF3, 0x33,
  0xB3, 0x68, 0xDE, 0xB2, 0x6A, 0xDA, 0x92, 0x5B,
  0xDB, 0x60, 0xF2, 0x97, 0x4F, 0x9F, 0xEF, 0x1F,
  0x9D, 0x46, 0x70, 0x08, 0xD0, 0x00, 0x30, 0xF1,
  0x71, 0xAA, 0xA0, 0xCB, 0x13, 0xC3, 0x0B, 0xC6,
  0x44, 0xFF, 0x35, 0x5E, 0x86, 0x56, 0x8E, 0x43,
  0xC1, 0x7A, 0xF0, 0x94, 0x4C, 0x9C, 0xEC, 0x22,
  0xA0, 0x1B, 0x65, 0x07, 0xDD, 0x0D, 0x05, 0xD1,
  0x51, 0xEA, 0xD0, 0xB3, 0x69, 0xB9, 0xB1, 0x60,
  0xE2, 0x59, 0x57, 0x33, 0xEB, 0x3B, 0x83, 0x52,
  0xD0, 0x6B, 0xD1, 0xAF, 0x75, 0xA5, 0x45, 0x97,
  0x15, 0xAE, 0xF0, 0x9A, 0x42, 0x92, 0x1E, 0xCD,
  0x4F, 0xF4, 0x02, 0x64, 0xBC, 0x6C, 0x3A, 0xBB,
  0x3B, 0x61, 0xC8, 0xA1, 0xC8, 0x65, 0x00, 0xCC,
  0x16, 0x5C, 0xF4, 0x9D, 0xE7, 0x1C, 0x7C, 0x35,
  0xBC, 0x42, 0xF7, 0x9B, 0xA6, 0x15, 0x75, 0x10,
  0x95, 0x4E, 0x9D, 0xF9, 0x21, 0xF4, 0x90, 0x50,
  0xB5, 0x67, 0xD1, 0x58, 0x80, 0x30, 0xF1, 0x11,
  0x94, 0xFE, 0x69, 0x00, 0xFD, 0xF9, 0xBE, 0x63,
  0x13, 0xC8, 0x48, 0x65, 0xBD, 0x3C, 0x7E, 0xBB,
  0x1A, 0xE2, 0x51, 0x14, 0xDF, 0x72, 0xE2, 0x22,
  0xA2, 0x79, 0xF9, 0xD4, 0x0C, 0x8D, 0xC9, 0x0C,
  0xAD, 0x53, 0xE0, 0xA5, 0xAE, 0x03, 0x93, 0x53,
  0xD3, 0x08, 0x88, 0xA5, 0x7D, 0xFC, 0xBA, 0x7F,
  0xDE, 0x22, 0x91, 0xD4, 0x4F, 0xE2, 0x72, 0xB2,
  0x32, 0xE9, 0x69, 0x44, 0x9C, 0x1D, 0x59, 0x9C,
  0x3D, 0xCE, 0x7D, 0x38, 0x73, 0xDE, 0x4E, 0x8E,
  0x0E, 0xD5, 0x55, 0x78, 0xA0, 0x81, 0xC8, 0x0D,
  0x81, 0x52, 0x66, 0x43, 0x9B, 0x4E, 0x2F, 0xEF,
  0xCE, 0x3E, 0x8D, 0x50, 0xAE, 0x1B, 0xBA, 0x50,
  0xD5, 0xC7, 0x7A, 0xBF, 0x3C, 0x91, 0x01, 0xC1,
  0x41, 0x9A, 0x1A, 0x37, 0xEF, 0x6E, 0x22, 0xE7,
  0x46, 0xB0, 0x03, 0x46, 0x8D, 0x20, 0xB0, 0x70,
  0xF0, 0x2B, 0xAB, 0x86, 0x5E, 0x6F, 0x21, 0xE4,
  0x55, 0xAC, 0x1F, 0x52, 0xA5, 0x10, 0x59, 0xBA,
  0xB3, 0x3B, 0x90, 0x0C, 0xD4, 0x64, 0x32, 0xB3,
  0x33, 0x79, 0xFF, 0x96, 0xCF, 0x4E, 0x2B, 0x62,
  0xCB, 0x75, 0xC3, 0xAF, 0x6A, 0x2A, 0x7C, 0xFD,
  0x7D, 0x07, 0x83, 0xEA, 0x80, 0x90, 0x7C, 0x14,
  0x9E, 0x65, 0xB2, 0xDE, 0x8E, 0x14, 0xCE, 0xB4,
  0xA8, 0x6B, 0xD1, 0xA1, 0x75, 0x48, 0xCA, 0x20,
  0x88, 0x93, 0x05, 0x69, 0x63, 0x9D, 0xF1, 0xF3,
  0x38, 0xC4, 0x57, 0x3A, 0xC6, 0x56, 0xD0, 0x03,
  0x93, 0x68, 0xDE, 0xAF, 0x87, 0x37, 0x57, 0x97,
  0x17, 0xCC, 0x7A, 0x16, 0xCE, 0x7E, 0x1E, 0xDE,
  0x5E, 0x85, 0x32, 0x5E, 0x82, 0x32, 0x9E, 0x4A,
  0xC8, 0x73,
};

static unsigned char vfs5011_init_04[] = { /* 2221 B */
  0x02, 0x20, 0x01, 0x01, 0x00, 0x03, 0x00, 0x09,
  0x00, 0x04, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x18, 0x20,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x20, 0x04, 0x30, 0x08,
  0x00, 0x80, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x24, 0x20, 0x04, 0x30, 0x00, 0x00, 0xFF, 0x01,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x2C, 0x20, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x40, 0x20, 0x04, 0x30, 0xAD, 0x01,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x44,
  0x20, 0x04, 0x30, 0xAD, 0x01, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x48, 0x20, 0x04, 0x30,
  0xAD, 0x01, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x4C, 0x20, 0x04, 0x30, 0xFF, 0x03, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x50, 0x20,
  0x04, 0x30, 0x00, 0x00, 0x50, 0x03, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x54, 0x20, 0x04, 0x30, 0x01,
  0x3E, 0x02, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x00, 0x21, 0x04, 0x30, 0x14, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x04, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x08, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x0C,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x10, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x14, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x18, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x1C, 0x21, 0x04, 0x30, 0x12,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x20, 0x21, 0x04, 0x30, 0x04, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x40, 0x21, 0x04,
  0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x44, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x48,
  0x21, 0x04, 0x30, 0x10, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x4C, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x50, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x21,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x58, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x5C, 0x21, 0x04, 0x30, 0x1F, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x60, 0x21, 0x04,
  0x30, 0x0F, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x80, 0x21, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x84,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x88, 0x21, 0x04, 0x30,
  0x10, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x8C, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x90, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x94, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x98, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x9C, 0x21, 0x04,
  0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xA0, 0x21, 0x04, 0x30, 0x0F, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC0,
  0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xC4, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xC8, 0x21, 0x04, 0x30, 0x10, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xCC, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xD0, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xD4, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xD8, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xDC, 0x21, 0x04, 0x30, 0x1F, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xE0,
  0x21, 0x04, 0x30, 0x0F, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xA0, 0x20, 0x04, 0x30,
  0xEF, 0xE1, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xA4, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xA8, 0x20,
  0x04, 0x30, 0xFE, 0x21, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xB0, 0x20, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xC4, 0x20, 0x04, 0x30, 0x47, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xC8, 0x20, 0x04,
  0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xCC, 0x20, 0x04, 0x30, 0x20, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x04,
  0x00, 0x00, 0x38, 0x00, 0x08, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x08, 0x00, 0x00, 0x38,
  0x00, 0x12, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x0C, 0x00, 0x00, 0x38, 0x01, 0x03, 0x02,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10, 0x00,
  0x00, 0x38, 0x01, 0x07, 0x02, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x14, 0x00, 0x00, 0x38, 0x0C,
  0x0C, 0x8A, 0x00, 0x04, 0x02, 0x00, 0x80, 0x05,
  0xFF, 0xF9, 0x87, 0x20, 0x83, 0x48, 0x84, 0x20,
  0x83, 0x48, 0x84, 0x20, 0x83, 0x48, 0x84, 0x20,
  0x83, 0x48, 0x84, 0x20, 0x83, 0x48, 0x84, 0x20,
  0x83, 0x48, 0x84, 0x20, 0x83, 0x48, 0x84, 0x20,
  0x83, 0x48, 0x84, 0x20, 0x83, 0x48, 0x84, 0x20,
  0x83, 0x48, 0x84, 0x20, 0x85, 0x48, 0x04, 0x20,
  0x87, 0x48, 0x04, 0x20, 0x89, 0x48, 0x04, 0x20,
  0x8B, 0x48, 0x04, 0x20, 0x8D, 0x48, 0x04, 0x20,
  0x8F, 0x48, 0x04, 0x20, 0x91, 0x48, 0x04, 0x20,
  0x93, 0x48, 0x04, 0x20, 0x95, 0x48, 0x04, 0x20,
  0x97, 0x48, 0x04, 0x20, 0x99, 0x48, 0x04, 0x20,
  0x9B, 0x48, 0x04, 0x20, 0x9D, 0x48, 0x04, 0x20,
  0x9F, 0x48, 0x04, 0x20, 0xA1, 0x48, 0x04, 0x20,
  0xA3, 0x48, 0x04, 0x20, 0xA3, 0x48, 0x04, 0x00,
  0x85, 0x5A, 0x04, 0x20, 0x87, 0x5A, 0x04, 0x20,
  0x89, 0x5A, 0x04, 0x20, 0x8B, 0x5A, 0x04, 0x20,
  0x8D, 0x5A, 0x04, 0x20, 0x8F, 0x5A, 0x04, 0x20,
  0x91, 0x5A, 0x04, 0x20, 0x93, 0x5A, 0x04, 0x20,
  0x95, 0x5A, 0x04, 0x20, 0x97, 0x5A, 0x04, 0x20,
  0x99, 0x5A, 0x04, 0x20, 0x9B, 0x5A, 0x04, 0x20,
  0x9D, 0x5A, 0x04, 0x20, 0x9F, 0x5A, 0x04, 0x20,
  0xA1, 0x5A, 0x04, 0x20, 0xA3, 0x5A, 0x04, 0x20,
  0xA3, 0x5A, 0x04, 0x00, 0x85, 0x6C, 0x04, 0x20,
  0x87, 0x6C, 0x04, 0x20, 0x89, 0x6C, 0x04, 0x20,
  0x8B, 0x6C, 0x04, 0x20, 0x8D, 0x6C, 0x04, 0x20,
  0x8F, 0x6C, 0x04, 0x20, 0x91, 0x6C, 0x04, 0x20,
  0x93, 0x6C, 0x04, 0x20, 0x95, 0x6C, 0x04, 0x20,
  0x97, 0x6C, 0x04, 0x20, 0x99, 0x6C, 0x04, 0x20,
  0x9B, 0x6C, 0x04, 0x20, 0x9D, 0x6C, 0x04, 0x20,
  0x9F, 0x6C, 0x04, 0x20, 0xA1, 0x6C, 0x04, 0x20,
  0xA3, 0x6C, 0x04, 0x20, 0xA3, 0x6C, 0x04, 0x00,
  0x86, 0x48, 0x04, 0x20, 0x88, 0x48, 0x04, 0x20,
  0x8A, 0x48, 0x04, 0x20, 0x8C, 0x48, 0x04, 0x20,
  0x8E, 0x48, 0x04, 0x20, 0x90, 0x48, 0x04, 0x20,
  0x92, 0x48, 0x04, 0x20, 0xF7, 0x48, 0x04, 0x20,
  0xF9, 0x48, 0x04, 0x20, 0xFB, 0x48, 0x04, 0x20,
  0xFD, 0x48, 0x04, 0x20, 0xFF, 0x48, 0x04, 0x20,
  0x01, 0x49, 0x04, 0x20, 0x03, 0x49, 0x04, 0x20,
  0x05, 0x49, 0x04, 0x20, 0x07, 0x49, 0x04, 0x20,
  0x07, 0x49, 0x04, 0x00, 0x86, 0x5A, 0x04, 0x20,
  0x88, 0x5A, 0x04, 0x20, 0x8A, 0x5A, 0x04, 0x20,
  0x8C, 0x5A, 0x04, 0x20, 0x8E, 0x5A, 0x04, 0x20,
  0x90, 0x5A, 0x04, 0x20, 0x92, 0x5A, 0x04, 0x20,
  0xF7, 0x5A, 0x04, 0x20, 0xF9, 0x5A, 0x04, 0x20,
  0xFB, 0x5A, 0x04, 0x20, 0xFD, 0x5A, 0x04, 0x20,
  0xFF, 0x5A, 0x04, 0x20, 0x01, 0x5B, 0x04, 0x20,
  0x03, 0x5B, 0x04, 0x20, 0x05, 0x5B, 0x04, 0x20,
  0x07, 0x5B, 0x04, 0x20, 0x07, 0x5B, 0x04, 0x00,
  0x86, 0x6C, 0x04, 0x20, 0x88, 0x6C, 0x04, 0x20,
  0x8A, 0x6C, 0x04, 0x20, 0x8C, 0x6C, 0x04, 0x20,
  0x8E, 0x6C, 0x04, 0x20, 0x90, 0x6C, 0x04, 0x20,
  0x92, 0x6C, 0x04, 0x20, 0xF7, 0x6C, 0x04, 0x20,
  0xF9, 0x6C, 0x04, 0x20, 0xFB, 0x6C, 0x04, 0x20,
  0xFD, 0x6C, 0x04, 0x20, 0xFF, 0x6C, 0x04, 0x20,
  0x01, 0x6D, 0x04, 0x20, 0x03, 0x6D, 0x04, 0x20,
  0x05, 0x6D, 0x04, 0x20, 0x07, 0x6D, 0x04, 0x20,
  0x07, 0x6D, 0x04, 0x00, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x83, 0x68, 0x84, 0x20,
  0x83, 0x68, 0x84, 0x20, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x00, 0x08, 0x00, 0x10, 0x03, 0x51, 0x09,
  0x10, 0x03, 0x51, 0x09, 0x03, 0x00, 0x09, 0x00,
  0x00, 0x20, 0x04, 0x30, 0x80, 0x00, 0x00, 0x00,
  0x04, 0x15, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x20, 0x28, 0x00, 0x00,
};

static unsigned char vfs5011_init_05[] = { /* 2770 B */
  0x06, 0x6B, 0x06, 0x6A, 0x76, 0xCC, 0x1C, 0xD0,
  0x50, 0xEB, 0x75, 0x10, 0xC8, 0x18, 0x5C, 0x95,
  0x15, 0xAE, 0xA8, 0xC8, 0x10, 0xC0, 0xB0, 0x7A,
  0xFA, 0x21, 0x96, 0xFA, 0x22, 0x92, 0xAE, 0x78,
  0xF8, 0x43, 0x05, 0x6E, 0xB6, 0x66, 0x62, 0xD5,
  0x51, 0xEA, 0xF0, 0xE5, 0x39, 0xE9, 0xA1, 0x19,
  0x9D, 0x26, 0x80, 0xE0, 0x38, 0xE8, 0x1C, 0xCA,
  0x4A, 0xF1, 0xBF, 0xD8, 0x00, 0xD0, 0x34, 0xD9,
  0x5D, 0xB6, 0x00, 0xF2, 0x2A, 0xA2, 0xAA, 0x7C,
  0xFC, 0x47, 0xDD, 0xB8, 0x60, 0xB0, 0xD0, 0xEF,
  0x6F, 0xB4, 0x46, 0x2C, 0xF4, 0x24, 0xBB, 0x7B,
  0x04, 0x20, 0x96, 0xC5, 0x1D, 0xAD, 0x32, 0x32,
  0x4D, 0x69, 0xDF, 0xA0, 0x7A, 0xAA, 0xB6, 0x60,
  0xE0, 0x5B, 0x89, 0xF6, 0x2C, 0xFC, 0x14, 0xC2,
  0x42, 0xF9, 0x23, 0x59, 0x81, 0x51, 0x31, 0xEF,
  0x6B, 0x80, 0x36, 0x52, 0x8A, 0x3A, 0x5A, 0x64,
  0x1B, 0xF7, 0xBD, 0xD4, 0x0C, 0xDC, 0xBC, 0x54,
  0xD0, 0x3B, 0x0D, 0x4C, 0x90, 0x10, 0x70, 0x90,
  0x14, 0xFF, 0x65, 0x29, 0xF5, 0x75, 0x55, 0xB5,
  0x31, 0xDA, 0x88, 0xC5, 0x19, 0x99, 0xF9, 0x39,
  0xB9, 0x5A, 0xD0, 0xBC, 0x64, 0xEC, 0x8C, 0xEC,
  0x6C, 0x8F, 0x05, 0xC9, 0x11, 0x99, 0xF9, 0x19,
  0x99, 0x7A, 0xC2, 0x8E, 0x56, 0xDE, 0xBE, 0x3E,
  0xBE, 0x5D, 0xE3, 0xCF, 0x17, 0x9F, 0xFF, 0x5F,
  0xDF, 0x3C, 0x82, 0x8E, 0x56, 0xDE, 0xBE, 0xFE,
  0x7E, 0x9D, 0x23, 0xCF, 0x17, 0x9F, 0xC9, 0x48,
  0xC8, 0xF6, 0x07, 0x4D, 0x04, 0x98, 0xFB, 0x9A,
  0x37, 0xEF, 0x55, 0x31, 0x60, 0xDA, 0x38, 0xB1,
  0x31, 0xF7, 0xB1, 0xDD, 0x05, 0xB5, 0xE3, 0x62,
  0xE2, 0x19, 0xCE, 0xA2, 0x5F, 0x11, 0x8E, 0x6E,
  0x08, 0xC0, 0x66, 0x2A, 0xF2, 0x4E, 0x24, 0x01,
  0xAA, 0x54, 0x43, 0x01, 0xDA, 0xDB, 0x94, 0x57,
  0xB2, 0x40, 0xDE, 0xAF, 0x87, 0x37, 0x61, 0xE0,
  0x60, 0x16, 0xA2, 0x4F, 0xA7, 0x14, 0x78, 0xB1,
  0x3A, 0x59, 0x78, 0x0C, 0xC5, 0x54, 0x05, 0xC6,
  0x8E, 0x57, 0xEA, 0x3D, 0x25, 0x55, 0x41, 0x46,
  0xDC, 0x0C, 0x71, 0x3F, 0x81, 0x3A, 0xAA, 0x8F,
  0x6B, 0x95, 0x0E, 0x68, 0xAD, 0xED, 0x90, 0xA0,
  0x20, 0xFB, 0x7B, 0x56, 0x8E, 0xAF, 0xFC, 0x3F,
  0x9E, 0x70, 0xC5, 0x98, 0x72, 0xC1, 0x20, 0xD4,
  0x57, 0x05, 0x60, 0x2E, 0x95, 0x35, 0xCC, 0x9F,
  0x02, 0x29, 0xA9, 0x84, 0x5C, 0xDD, 0x8B, 0x48,
  0xDE, 0xA7, 0x17, 0x1E, 0x49, 0xDC, 0x94, 0x57,
  0x75, 0xCC, 0x58, 0x15, 0xFA, 0x49, 0xB5, 0x7F,
  0x77, 0x96, 0xB2, 0xC4, 0x08, 0x3A, 0x72, 0xB2,
  0xA0, 0x29, 0x91, 0x1D, 0xCD, 0x7D, 0x5B, 0x9A,
  0x1A, 0xC1, 0x7B, 0x1D, 0x20, 0x5C, 0x1C, 0x79,
  0x9E, 0x45, 0x42, 0x17, 0xCC, 0xD5, 0x37, 0xFB,
  0x67, 0x34, 0x81, 0x0C, 0xEC, 0x5F, 0xCD, 0x05,
  0x50, 0x87, 0x58, 0xA4, 0x83, 0x03, 0xF2, 0x08,
  0x8B, 0xA2, 0x5C, 0xE5, 0xBC, 0x3E, 0x5D, 0x45,
  0xC6, 0xF5, 0x4D, 0xE3, 0x76, 0x11, 0xD9, 0x1A,
  0x78, 0xFE, 0x1F, 0xC1, 0x73, 0xDF, 0x7F, 0x9F,
  0x1F, 0x4C, 0x22, 0xDC, 0x2D, 0x1D, 0xEF, 0x45,
  0xE6, 0x31, 0x8E, 0x70, 0xC2, 0x50, 0xA2, 0x38,
  0xEE, 0xD5, 0x6B, 0x07, 0xC2, 0x82, 0x4A, 0x89,
  0xAB, 0xBA, 0x54, 0x5D, 0x7C, 0xEB, 0x96, 0xA6,
  0x26, 0xFD, 0x7D, 0x50, 0x88, 0xA9, 0xFE, 0x3D,
  0x3F, 0xED, 0x7F, 0x91, 0x00, 0x95, 0x50, 0xB1,
  0x31, 0x4B, 0xC6, 0xA9, 0xF0, 0x72, 0x11, 0xDD,
  0x74, 0x2D, 0xB3, 0xCD, 0x87, 0x5D, 0x39, 0x19,
  0x91, 0x4A, 0x5E, 0x92, 0xDE, 0xDF, 0x89, 0x4A,
  0x0B, 0xEC, 0x59, 0x8D, 0x5E, 0x2E, 0x6E, 0xAE,
  0xE6, 0x31, 0x15, 0x62, 0xE7, 0xFD, 0x36, 0x3C,
  0x25, 0x6C, 0xB1, 0xF5, 0x08, 0x02, 0x42, 0x9F,
  0xEF, 0x34, 0xB4, 0x99, 0x41, 0xFD, 0x88, 0x09,
  0xBE, 0x66, 0xE7, 0x69, 0x9D, 0x6A, 0xE8, 0x27,
  0x95, 0x4A, 0xDB, 0x95, 0x49, 0xDF, 0x85, 0x67,
  0xC7, 0x3D, 0xAA, 0xE4, 0x78, 0xED, 0x90, 0xA0,
  0x79, 0xE6, 0xC2, 0xAA, 0x57, 0x65, 0x01, 0xE7,
  0x6C, 0x2E, 0x08, 0xF4, 0x58, 0x7A, 0x5E, 0xB9,
  0xA3, 0xF0, 0xC6, 0x2B, 0xD2, 0xE0, 0xC4, 0x21,
  0xBC, 0x97, 0x78, 0x20, 0x4A, 0xFE, 0xB9, 0xDB,
  0x5F, 0xA1, 0xB5, 0x9D, 0x4F, 0xE4, 0x2E, 0x4E,
  0x6E, 0xC1, 0xD5, 0xFD, 0x03, 0x09, 0xC3, 0xA3,
  0x82, 0x78, 0x6C, 0x44, 0xB9, 0x14, 0x84, 0x44,
  0xC4, 0x1F, 0x9F, 0xB2, 0x6A, 0x1A, 0x5A, 0x9A,
  0x16, 0xC4, 0xF3, 0xA2, 0x79, 0xF8, 0xA2, 0x61,
  0xB0, 0x50, 0xE5, 0xFB, 0x00, 0x3A, 0x9A, 0x7A,
  0xFA, 0x69, 0x9A, 0x94, 0x6F, 0x56, 0xB6, 0x01,
  0x91, 0xCA, 0x0B, 0x76, 0x2E, 0xF8, 0x88, 0x88,
  0x28, 0xF3, 0x77, 0x38, 0x61, 0xA1, 0xA7, 0x47,
  0xB6, 0x5B, 0xEE, 0xE2, 0x7E, 0xEE, 0xBE, 0xDF,
  0x5B, 0xE1, 0x6B, 0x04, 0xEC, 0xDD, 0xB9, 0x49,
  0x78, 0xE2, 0xEC, 0x87, 0x49, 0xD1, 0xB9, 0xFB,
  0x50, 0x94, 0x15, 0x71, 0xD5, 0xE4, 0xBA, 0x79,
  0xF5, 0x64, 0x5A, 0xDE, 0x36, 0x35, 0x75, 0x55,
  0xDD, 0x06, 0x78, 0x51, 0xA8, 0x2F, 0x4C, 0x87,
  0x9B, 0x56, 0xB9, 0xDF, 0xB5, 0xC9, 0x57, 0x81,
  0xBA, 0x6B, 0x0F, 0xAF, 0x8A, 0x2C, 0xE1, 0x2D,
  0xBB, 0xDC, 0x6A, 0x20, 0xB4, 0x0C, 0xCE, 0xAE,
  0x2E, 0x50, 0x50, 0x1C, 0x06, 0x93, 0xF7, 0xF7,
  0xE7, 0x48, 0x52, 0x57, 0xA9, 0x50, 0x14, 0x71,
  0xE1, 0x3A, 0x0D, 0x53, 0x88, 0xBA, 0xF2, 0x20,
  0x40, 0x93, 0x25, 0xEB, 0x93, 0xB7, 0x6F, 0xA8,
  0xE8, 0x13, 0xA5, 0x01, 0xDF, 0xFD, 0x86, 0x1B,
  0x31, 0x41, 0x3D, 0xC8, 0x82, 0x59, 0x11, 0x34,
  0x1D, 0xE6, 0x98, 0xB1, 0x65, 0xDE, 0x3E, 0x52,
  0xD3, 0xA8, 0xBA, 0xF6, 0x0B, 0xA8, 0xC8, 0xA5,
  0x26, 0xF1, 0x4C, 0x85, 0x4F, 0xFF, 0x57, 0xD2,
  0x92, 0xD9, 0x1B, 0xEB, 0xAA, 0x3C, 0x15, 0xC2,
  0x5F, 0x74, 0x02, 0x4E, 0x96, 0xEE, 0x88, 0xFA,
  0x61, 0xE7, 0xFC, 0x92, 0x80, 0x8B, 0x52, 0xA0,
  0xC5, 0xB8, 0x2E, 0x5F, 0x77, 0xC7, 0xA7, 0x67,
  0x55, 0x2E, 0x99, 0x27, 0xFD, 0x47, 0x85, 0x47,
  0xEF, 0x34, 0x5F, 0x22, 0x7A, 0x60, 0x11, 0x71,
  0x5D, 0xA6, 0xC0, 0x06, 0xFE, 0x6B, 0x04, 0xC4,
  0xEC, 0xB5, 0x0F, 0x68, 0x15, 0xAB, 0xCB, 0x2E,
  0xE7, 0x3C, 0x86, 0xC1, 0x3C, 0x82, 0xE2, 0x3F,
  0x4F, 0x94, 0x2E, 0x48, 0xF5, 0xE8, 0xA8, 0xA0,
  0x65, 0x38, 0x54, 0xC7, 0x1F, 0xAF, 0x62, 0xA1,
  0x04, 0x36, 0x7F, 0xE1, 0x3B, 0xAD, 0x2F, 0xED,
  0x4A, 0x66, 0x6E, 0x13, 0x43, 0xC1, 0x1D, 0x55,
  0x4D, 0xD4, 0xDE, 0xFB, 0x81, 0x33, 0x59, 0x95,
  0x1E, 0x7C, 0x8F, 0x41, 0xDB, 0x4E, 0xE6, 0x63,
  0x25, 0x2E, 0x67, 0xA6, 0x7D, 0x28, 0xAE, 0x91,
  0xC3, 0x1A, 0x8A, 0x24, 0xFE, 0x69, 0xDE, 0xA2,
  0x33, 0x00, 0x84, 0x44, 0x62, 0x2A, 0x08, 0x64,
  0x5B, 0x02, 0xB6, 0xD0, 0x04, 0xBD, 0x44, 0xC1,
  0xC3, 0x5A, 0xC9, 0x6D, 0xF0, 0xC6, 0x61, 0x5E,
  0xDE, 0x05, 0xBF, 0xD9, 0xE4, 0x4A, 0x2A, 0xBC,
  0x86, 0xA1, 0x1B, 0x6D, 0xD0, 0x7E, 0x1E, 0xD2,
  0x69, 0x7F, 0xC3, 0xA3, 0x31, 0x41, 0x8A, 0xD9,
  0xF0, 0x6E, 0xDE, 0x5C, 0x7B, 0xCB, 0xA7, 0x4D,
  0xE8, 0x2E, 0x98, 0x2C, 0xB1, 0x0D, 0x23, 0x43,
  0x1D, 0x45, 0x2A, 0x03, 0x1D, 0x5F, 0xC0, 0x00,
  0x80, 0x5B, 0xDB, 0xF6, 0x2E, 0x3C, 0xFC, 0x18,
  0x49, 0xAF, 0x1A, 0x97, 0x70, 0xC3, 0x92, 0x65,
  0xE6, 0x1C, 0x90, 0xFF, 0x66, 0xE8, 0x8B, 0x8B,
  0x2B, 0xF0, 0xC4, 0x8C, 0x5A, 0x58, 0x1A, 0x53,
  0x11, 0xC9, 0x57, 0xDB, 0xB8, 0x18, 0xF8, 0xF4,
  0x65, 0x6E, 0x14, 0x68, 0x70, 0x7B, 0x3B, 0x1B,
  0x93, 0x48, 0x3E, 0x72, 0xAA, 0x36, 0xDC, 0x94,
  0xF0, 0xFA, 0x0D, 0x62, 0x08, 0x9A, 0x70, 0x72,
  0xF1, 0x0F, 0x58, 0x74, 0xAF, 0x9F, 0x33, 0xE2,
  0x82, 0x95, 0x33, 0x8F, 0xEC, 0x4C, 0xEC, 0x97,
  0x37, 0x0C, 0xB2, 0xDE, 0x1B, 0x5B, 0x0D, 0x8C,
  0x0C, 0x96, 0x16, 0x79, 0xF0, 0x72, 0x11, 0x09,
  0x8D, 0x27, 0xA6, 0xC9, 0x83, 0x1E, 0x62, 0x62,
  0xC2, 0x19, 0x2D, 0x56, 0x80, 0xF2, 0x8F, 0x19,
  0xB0, 0x62, 0x56, 0xF2, 0xD2, 0xF0, 0xBD, 0x61,
  0xAA, 0xBD, 0xCB, 0x67, 0x4B, 0x39, 0x04, 0x92,
  0x59, 0x1B, 0x3F, 0x3E, 0xFA, 0xCD, 0x81, 0x37,
  0x96, 0x74, 0xC1, 0x48, 0xCC, 0x59, 0x81, 0x45,
  0x67, 0xD7, 0x43, 0xA3, 0xC1, 0xF3, 0xB9, 0x7A,
  0x78, 0x8B, 0x3D, 0xB1, 0x61, 0xD1, 0xF7, 0x36,
  0xB6, 0x6D, 0xD7, 0xB1, 0x8C, 0xA6, 0xE6, 0xAE,
  0x8B, 0xB0, 0x0E, 0x62, 0x57, 0xED, 0x5F, 0xBB,
  0x3B, 0x52, 0xFE, 0x86, 0xFC, 0x21, 0x63, 0x71,
  0xEC, 0x61, 0x65, 0xC2, 0xE2, 0x85, 0x4E, 0x8F,
  0xD2, 0x02, 0x09, 0x67, 0x17, 0x89, 0x39, 0x99,
  0xED, 0xFB, 0x4B, 0xAC, 0xDE, 0x8B, 0x8B, 0x63,
  0xC9, 0x34, 0x3A, 0x52, 0x02, 0xE7, 0x25, 0xCE,
  0x6C, 0x25, 0xB8, 0xC8, 0xD2, 0x79, 0x4F, 0xEF,
  0xF6, 0xED, 0x3B, 0x9B, 0x83, 0xF1, 0xCA, 0x5C,
  0x4E, 0xFE, 0x54, 0xD8, 0x08, 0xB8, 0x00, 0xC4,
  0xE6, 0x2A, 0x92, 0x3C, 0xF9, 0x1F, 0xDD, 0xD7,
  0xAF, 0xD3, 0xC9, 0x2B, 0x75, 0xC5, 0xA5, 0x44,
  0xFD, 0x25, 0x21, 0x8E, 0xA9, 0xEF, 0xA4, 0x30,
  0xA6, 0x91, 0x22, 0xAB, 0x27, 0xB2, 0x1A, 0xDE,
  0xFC, 0x4B, 0xDF, 0x3F, 0x5D, 0x6F, 0x25, 0xE6,
  0xE4, 0x17, 0xA1, 0x2D, 0xFD, 0x4D, 0x6B, 0xAA,
  0x2A, 0xF1, 0x4B, 0x2D, 0x10, 0x32, 0x72, 0x3A,
  0x1F, 0x24, 0x9A, 0xF6, 0xE6, 0x52, 0x8F, 0x4D,
  0x6F, 0xD8, 0x4C, 0x88, 0x7A, 0x08, 0x74, 0xE2,
  0xC0, 0xD1, 0x6F, 0xE6, 0x67, 0xFF, 0x2E, 0xD7,
  0x54, 0x07, 0xE4, 0x20, 0xFC, 0x8E, 0x4E, 0x8E,
  0xCC, 0x4D, 0xAD, 0x73, 0xC1, 0x6D, 0xAF, 0x45,
  0xE7, 0xDC, 0x62, 0x0E, 0x04, 0x90, 0xF0, 0xC0,
  0x60, 0xBB, 0xCF, 0xBE, 0x30, 0x0C, 0xF0, 0x92,
  0x3F, 0xF8, 0xF3, 0x9D, 0x20, 0xC7, 0x8F, 0x9D,
  0x39, 0xE2, 0x32, 0x7D, 0x9B, 0xC9, 0xB4, 0x23,
  0x1F, 0xAA, 0x79, 0x5B, 0xA6, 0xEE, 0x8A, 0xE8,
  0x07, 0xFE, 0xE4, 0x92, 0xC2, 0x48, 0xA0, 0x68,
  0x08, 0xDB, 0x6D, 0x89, 0xF4, 0xA4, 0xCC, 0x0C,
  0x14, 0xCB, 0xF5, 0xCC, 0xB6, 0x6F, 0x2D, 0x0D,
  0x85, 0x5E, 0x40, 0x28, 0x52, 0xF8, 0xCF, 0x59,
  0xA3, 0x85, 0x35, 0x5A, 0x82, 0x32, 0x52, 0x33,
  0xF0, 0x28, 0x2F, 0x01, 0xDA, 0xD3, 0xE4, 0x01,
  0x3D, 0xC1, 0xAF, 0xC7, 0xDD, 0x70, 0x47, 0x0B,
  0x87, 0x41, 0x07, 0xCA, 0x57, 0xE4, 0x55, 0xD1,
  0x52, 0x50, 0x81, 0x08, 0x6A, 0xFD, 0x80, 0xB0,
  0x30, 0xEB, 0x6B, 0x46, 0x9E, 0xEF, 0xB8, 0x7B,
  0x5A, 0xBA, 0x0F, 0xDF, 0xC5, 0xF7, 0x55, 0x6B,
  0xFD, 0x6E, 0xDE, 0xD4, 0x1E, 0x85, 0x5D, 0x97,
  0xF5, 0x22, 0xB0, 0x0E, 0xDD, 0x6A, 0xA8, 0x63,
  0xE5, 0xAC, 0x11, 0x78, 0x70, 0x6A, 0xCA, 0x9D,
  0x37, 0xA5, 0xB1, 0x91, 0x61, 0x33, 0x1F, 0xFA,
  0x58, 0x88, 0x37, 0xA9, 0x7A, 0xC2, 0x50, 0xDC,
  0x7B, 0x82, 0x78, 0x32, 0xE6, 0x44, 0x39, 0x09,
  0x89, 0x52, 0xE8, 0x8E, 0xB3, 0x87, 0xC7, 0x0B,
  0x89, 0x4F, 0x09, 0xDD, 0x0F, 0x6D, 0x01, 0xE9,
  0xCB, 0x1B, 0xAA, 0x44, 0x97, 0x23, 0x99, 0xF3,
  0xD4, 0x27, 0xD7, 0x19, 0x8D, 0x15, 0x57, 0x9C,
  0x15, 0x2C, 0x96, 0xDE, 0xF4, 0x4F, 0x27, 0x15,
  0xD9, 0x25, 0x71, 0x51, 0xAC, 0x3E, 0x12, 0xF4,
  0x78, 0xB1, 0x1A, 0x86, 0x52, 0xE0, 0x9D, 0xAD,
  0x95, 0x44, 0x50, 0x30, 0xC0, 0xA2, 0xC9, 0x0E,
  0x0C, 0xDC, 0x6F, 0xD3, 0xA1, 0xD1, 0x36, 0xDC,
  0x40, 0x39, 0xC3, 0x87, 0x7D, 0xC6, 0xAF, 0x8D,
  0x01, 0xFE, 0xBA, 0xDD, 0x0D, 0x4F, 0x63, 0x84,
  0xE6, 0x71, 0xE2, 0xAC, 0x38, 0xAE, 0xC2, 0x10,
  0x8D, 0xA6, 0x1C, 0x72, 0xB7, 0xF7, 0x9B, 0x59,
  0xC4, 0xEF, 0x6F, 0x42, 0x9A, 0x0B, 0x5D, 0x9E,
  0x9C, 0x65, 0xD3, 0xFE, 0x11, 0xA2, 0x40, 0x98,
  0x4F, 0xA5, 0x21, 0x4E, 0x3A, 0xF2, 0x37, 0xCA,
  0x6F, 0x2C, 0x98, 0x56, 0xE7, 0x75, 0xB9, 0xA3,
  0xAB, 0x4A, 0x74, 0x10, 0x28, 0x90, 0xF0, 0xB8,
  0x9B, 0xA0, 0x1E, 0x72, 0x32, 0x80, 0x62, 0x81,
  0x04, 0x7D, 0xA2, 0xEC, 0xD4, 0x6C, 0x0C, 0x64,
  0xE6, 0x9F, 0x33, 0x08, 0x86, 0x5C, 0xC1, 0xA0,
  0x65, 0xBD, 0xBA, 0x92, 0x49, 0x40, 0x44, 0x21,
  0x0A, 0xF6, 0x5D, 0xC1, 0x19, 0xA9, 0xC9, 0xA8,
  0x6B, 0xB3, 0xC4, 0xEA, 0x31, 0x48, 0x7C, 0x19,
  0x33, 0xCF, 0xA1, 0xCF, 0xC5, 0x68, 0x5F, 0xC9,
  0x34, 0x11, 0xE1, 0x7B, 0x5C, 0xEC, 0xBA, 0x3B,
  0xBB, 0x6C, 0xD0, 0x9D, 0x73, 0xC0, 0xDC, 0xF0,
  0xC8, 0x11, 0x26, 0x74, 0xAF, 0xAD, 0xE6, 0x05,
  0x0D, 0x3E, 0x48, 0x9F, 0x57, 0x07, 0x6F, 0xAF,
  0x87, 0x5E, 0x4A, 0xEC, 0x6C, 0x39, 0xFE, 0x19,
  0x84, 0xAF, 0x2F, 0x02, 0xDA, 0x76, 0xCE, 0x89,
  0x9B, 0x44, 0xD3, 0xF9, 0x22, 0x8F, 0x1F, 0x72,
  0xF0, 0x0E, 0x0E, 0x47, 0xB2, 0x08, 0x75, 0x45,
  0xC5, 0x1E, 0x9E, 0xB3, 0x6B, 0x76, 0x14, 0xB1,
  0x31, 0xEA, 0x50, 0x3E, 0xFB, 0xBB, 0xED, 0x6C,
  0xEC, 0x17, 0x03, 0x4F, 0xB2, 0xE0, 0xA7, 0x56,
  0xED, 0x35, 0x1B, 0x74, 0x0C, 0x34, 0x15, 0x57,
  0x9E, 0x44, 0x50, 0x75, 0xAD, 0x36, 0xF4, 0xD1,
  0xB1, 0x4D, 0x4A, 0x11, 0xCA, 0xF8, 0x9A, 0x5F,
  0x2D, 0xF4, 0x45, 0xFB, 0x21, 0x97, 0x35, 0xF7,
  0x7F, 0x4C, 0xF9, 0x07, 0xDD, 0x69, 0x9B, 0x15,
  0x91, 0xC8, 0x30, 0x59, 0x23, 0xDD, 0xBF, 0xDF,
  0xF7, 0x6D, 0x79, 0x5B, 0x80, 0x92, 0xF0, 0x39,
  0x4B, 0xDE, 0x6F, 0xA1, 0x32, 0xA4, 0x66, 0xE8,
  0x61, 0x78, 0x80, 0xE4, 0xEE, 0x10, 0x76, 0x66,
  0x36, 0x99, 0xEF, 0x43, 0xEF, 0x9D, 0xB6, 0x51,
  0x03, 0x93, 0x0D, 0xCB, 0xCF, 0xAF, 0x1E, 0xFF,
  0xAD, 0x3D, 0xAF, 0xDE, 0xF6, 0x46, 0x10, 0x91,
  0x11, 0x07, 0xB3, 0xD3, 0x06, 0xAD, 0xAE, 0xD3,
  0x55, 0xB9, 0x3B, 0x26, 0xD5, 0x31, 0x61, 0xE5,
  0xA5, 0x65, 0x97, 0xBB, 0xE2, 0x13, 0x74, 0xD0,
  0x56, 0xA6, 0xA3, 0x1D, 0xC7, 0x77, 0x0C, 0x0E,
  0x12, 0xF1, 0xEA, 0x8B, 0x78, 0x73, 0xF1, 0x3D,
  0xBD, 0xB4, 0x0E, 0x63, 0x90, 0xEC, 0x66, 0x0C,
  0x56, 0x27, 0xC6, 0x31, 0x07, 0x6A, 0x00, 0x6D,
  0xE0, 0x86, 0x34, 0x7D, 0xC5, 0x5D, 0xF0, 0x32,
  0x0F, 0xD2, 0x68, 0x09, 0x91, 0xC0, 0xE1, 0x26,
  0xC2, 0x15, 0xB8, 0x16, 0x1C, 0xAE, 0xCE, 0x15,
  0x23, 0x28, 0x44, 0xE8, 0xE0, 0x81, 0x81, 0xDD,
  0xA3, 0x55, 0xEE, 0x10, 0xC4, 0x74, 0x3F, 0x44,
  0x54, 0x15, 0x63, 0x9F, 0xD6, 0x06, 0xFC, 0x1E,
  0x1C, 0xCB, 0x7C, 0x3B, 0x2F, 0x1F, 0xF5, 0xF5,
  0xF5, 0xAF, 0x79, 0x9F, 0x65, 0x82, 0x79, 0x5B,
  0xC6, 0xED, 0x76, 0x17, 0xD2, 0x92, 0xFE, 0x3C,
  0xA1, 0x8A, 0x0A, 0x07, 0xDF, 0xAF, 0xEF, 0x2F,
  0xEE, 0x7C, 0xC9, 0x04, 0x94, 0x27, 0x66, 0xE1,
  0x62, 0xEB, 0xFD, 0x90, 0x1A, 0xC8, 0x29, 0x29,
  0x89, 0x52, 0x76, 0x38, 0x60, 0x10, 0x50, 0x90,
  0xB0, 0xF2, 0x64, 0x9A, 0x20, 0x10, 0xB0, 0x50,
  0xD0, 0x89, 0x1B, 0xF6, 0xEE, 0x7E, 0x1E, 0x8E,
  0x86, 0x7D, 0x49, 0x41, 0x18, 0xCD, 0x8F, 0x6A,
  0xD7, 0x06, 0xA6, 0x80, 0x54, 0x5C, 0x16, 0x6F,
  0xEE, 0x39, 0x84, 0x08, 0xB1, 0x01, 0xB3, 0xD3,
  0x53, 0x59, 0xD8, 0xB7, 0xAF, 0x3F, 0x5F, 0x5D,
  0xFF, 0xA4, 0xD2, 0x9E, 0x46, 0xA6, 0x0A, 0xEA,
  0xB8, 0x7E, 0xC6, 0x68, 0xD2, 0xE2, 0x24, 0xF9,
  0x5C, 0x25, 0x33, 0xA3, 0xB9, 0x28, 0x48, 0x48,
  0xE8, 0x33, 0x77, 0x39, 0x6B, 0x2B, 0xC3, 0x42,
  0x62, 0x46, 0xE0, 0x0B, 0xCC, 0x8C, 0x2C, 0xCC,
  0x4C, 0xDC, 0xD1, 0x3F, 0xC5, 0xF9, 0x1B, 0xB7,
  0x37, 0x2E, 0x54, 0x3C, 0x33, 0xA8, 0x17, 0x86,
  0x4C, 0x94, 0xC2, 0x48, 0x83, 0x23, 0x63, 0xA3,
  0xA1, 0x5F, 0xED, 0x61, 0xB1, 0x01, 0x77, 0xBD,
  0x3A, 0xED, 0x55, 0xF8, 0x1B, 0xA8, 0xB4, 0x9C,
  0x10, 0x81, 0x4B, 0x1E, 0x06, 0x96, 0xF6, 0xE4,
  0x40, 0x1D, 0x6B, 0x27, 0xFF, 0xDF, 0x22, 0xF2,
  0xD2, 0x90, 0x06, 0xF8, 0x44, 0x72, 0xD2, 0x32,
  0xB2, 0x9B, 0x09, 0xE4, 0xFC, 0x6C, 0x0C, 0x4C,
  0x33, 0xF8, 0xBC, 0xB4, 0xED, 0x9D, 0xDD, 0x1D,
  0x4F, 0xF0, 0xC0, 0x6C, 0x94, 0x24, 0x8C, 0x40,
  0x68, 0x90, 0xD4, 0xB4, 0x6C, 0x6E, 0x02, 0xC3,
  0x81, 0x96, 0x22, 0xCE, 0xAD, 0x0C, 0x9C, 0xE7,
  0x47, 0x4E, 0xF4, 0x98, 0x82, 0x3E, 0x5F, 0x7D,
  0x9F, 0xC5, 0xF3, 0x53, 0x9A, 0xFA, 0x56, 0xB6,
  0xD3, 0xE0, 0xA9, 0x4D, 0xA6, 0x3B, 0x51, 0x19,
  0x91, 0xE7, 0x52, 0xDE, 0x0E, 0xBE, 0xC3, 0xF3,
  0x73, 0xA8, 0x12, 0x74, 0x49, 0xAD, 0xED, 0xAB,
  0xE6, 0xC2, 0xFC, 0xD5, 0xED, 0x55, 0x35, 0xE3,
  0x19, 0x3D, 0x4D, 0xC1, 0xE6, 0x56, 0x00, 0x81,
  0x01, 0x7B, 0x86, 0xE9, 0x80, 0x7C, 0x1F, 0x12,
  0x90, 0x2E, 0x70, 0x38, 0x51, 0xAF, 0xCC, 0x2C,
  0x86, 0xFD, 0xEA, 0xCB, 0x10, 0x6D, 0x0F, 0xAA,
  0xCD, 0x32, 0x35, 0x09, 0xD2, 0x42, 0x18, 0x78,
  0x3A, 0x22, 0x84, 0x49, 0xDE, 0x6D, 0x01, 0xC3,
  0x6A, 0xB2, 0x2D, 0x52, 0xA3, 0x30, 0x79, 0x8A,
  0xEF, 0xD1, 0x43, 0x9E, 0x14, 0xA7, 0xF7, 0x0D,
  0x2D, 0x34, 0x41, 0x3D, 0x44, 0xA5, 0xC6, 0xE3,
  0x87, 0x78, 0xC2, 0xA7, 0x4F, 0xC5, 0x05, 0xF7,
  0xB4, 0x7F, 0xE2, 0x17, 0xE6, 0x55, 0x1C, 0xCF,
  0xC4, 0x2C, 0xFC, 0x09, 0x25, 0x38, 0x5B, 0x29,
  0x09, 0x77, 0xED, 0xCD, 0xF0, 0x73, 0x3B, 0x5A,
  0x89, 0x51, 0x56, 0x6E, 0xB5, 0xC7, 0x64, 0x80,
  0x65, 0x5C, 0xCE, 0x13, 0x9D, 0x2E, 0x7E, 0x84,
  0xA4, 0xDE, 0x3D, 0x52, 0xB8, 0xCB, 0x8F, 0x82,
  0x01, 0x3F, 0x6A, 0x22, 0x4B, 0xA3, 0xC0, 0x30,
  0x8A, 0xF1, 0xE6, 0xDD, 0x06, 0x7B, 0x18, 0xBD,
  0xD8, 0x27, 0x20, 0x16, 0xCD, 0x4D, 0x17, 0x77,
  0x56, 0xD4, 0x61, 0xC0, 0x1B, 0x0E, 0x8A, 0x6E,
  0x5F, 0xD8, 0x6D, 0x31, 0xD3, 0xC3, 0x02, 0x99,
  0x1A, 0x0C, 0xB9, 0x70, 0x4B, 0xDF, 0x8F, 0x65,
  0x45, 0x83, 0xC5, 0xA9, 0x71, 0xC1, 0xBB, 0x7A,
  0xFA, 0x21, 0x97, 0xFB, 0x23, 0x93, 0x7F, 0xB2,
  0x30, 0x8B, 0xA9, 0xD3, 0x0B, 0xDB, 0xA6, 0x66,
  0xEC, 0x37, 0x03, 0x6B, 0x30, 0x84, 0x44, 0x97,
  0x15, 0xAE, 0x19, 0x75, 0xAD, 0x1D, 0x01, 0xD7,
  0x57, 0xEC, 0x26, 0x5C, 0x84, 0x54, 0x9C, 0x4A,
  0xCA, 0x71, 0x4F, 0x35, 0xED, 0x3D, 0xD5, 0x03,
  0x83, 0x38, 0x22, 0x58, 0x80, 0x50, 0x30, 0xF0,
  0x70, 0xAB, 0x1D, 0x71, 0xA9, 0x19, 0x79, 0xB9,
  0x39, 0xE2, 0x54, 0x38, 0xE0, 0x50, 0x30, 0xF0,
  0x70, 0xAB, 0x1D, 0x71, 0xA9, 0x19, 0x79, 0xB9,
  0x39, 0xE2, 0x54, 0x38, 0xE0, 0x50, 0x30, 0xF0,
  0x70, 0xAB, 0x1D, 0x71, 0xA9, 0x19, 0x79, 0xB9,
  0x39, 0xE2, 0x7C, 0x19, 0xC1, 0x11, 0x55, 0x9C,
  0x1C, 0xA7, 0x03, 0x5F, 0x87, 0x37, 0x97, 0x41,
  0xC1, 0x7A, 0x7C, 0x10, 0xC8, 0x78, 0x64, 0xA3,
  0x23, 0x98, 0x82, 0xE3, 0x39, 0xE9, 0x79, 0xBE,
  0x3E, 0x85, 0xC3, 0xA2, 0x78, 0xA8, 0xB8, 0x76,
  0xF4, 0x4F, 0xF1, 0x92, 0x48, 0x98, 0x44, 0x83,
  0x03, 0xB8, 0x86, 0xF9, 0x23, 0xF3, 0x3F, 0xEA,
  0x68, 0xD3, 0x53, 0x7E, 0xA6, 0x97, 0x45, 0x80,
  0xB1, 0xDA, 0x69, 0xA7, 0xDF, 0x6C, 0x9D, 0xEC,
  0x69, 0x10, 0xED, 0x81, 0xDB, 0x02, 0x62, 0xC7,
  0x46, 0x9D, 0x0E, 0x60, 0xB8, 0x2D, 0x49, 0x89,
  0xA8, 0xC0, 0x73, 0xAE, 0xC2, 0x77, 0xF2, 0xA3,
  0x04, 0xC2, 0x84, 0xE8, 0x30, 0x80, 0xD6, 0x57,
  0xD7, 0x3D, 0x3E, 0x57, 0xAE, 0xA8, 0xCD, 0x24,
  0x77, 0xB1, 0xF7, 0x9B, 0x43, 0xF3, 0xA5, 0x24,
  0xA4, 0xCE, 0xC0, 0xA9, 0x40, 0x4B, 0x2E, 0xCF,
  0xF3, 0x2D, 0x1A, 0xCC, 0x11, 0x30, 0xE7, 0x22,
  0x03, 0x61, 0xD2, 0x17, 0x16, 0x24, 0x2D, 0xFD,
  0x54, 0xAC, 0xA3, 0x56, 0x93, 0xD3, 0x85, 0x04,
  0x84, 0x6E, 0x6D, 0x04, 0xFD, 0xF0, 0x95, 0x7C,
  0x6F, 0xA9, 0xEF, 0x83, 0x5B, 0xEB, 0x8B, 0x4B,
  0xCB, 0x10, 0xA6, 0xCA, 0x12, 0xA2, 0xC2, 0x02,
  0x82, 0x59, 0xEE, 0x82, 0x5E, 0xEE, 0x76, 0xA0,
  0x22, 0x99,
};

static unsigned char vfs5011_init_06[] = { /* 2855 B */
  0x02, 0xB0, 0x00, 0x62, 0x00, 0x03, 0x00, 0x09,
  0x00, 0x04, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x18, 0x20,
  0x04, 0x30, 0x01, 0x80, 0x64, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x20, 0x04, 0x30, 0x08,
  0x00, 0x80, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x24, 0x20, 0x04, 0x30, 0x00, 0x00, 0xFF, 0x01,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x2C, 0x20, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x40, 0x20, 0x04, 0x30, 0xFF, 0x03,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x44,
  0x20, 0x04, 0x30, 0xE6, 0x03, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x48, 0x20, 0x04, 0x30,
  0xE7, 0x03, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x4C, 0x20, 0x04, 0x30, 0xE8, 0x03, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x20,
  0x04, 0x30, 0x00, 0x92, 0x01, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x00, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x04, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x08, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x0C, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x14, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x18, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x1C, 0x21,
  0x04, 0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x40, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x44, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x48, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x4C,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x50, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x54, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x58, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x5C, 0x21, 0x04, 0x30, 0x1F,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x60, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x80, 0x21, 0x04,
  0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x84, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x88,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x8C, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x90, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x94, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x98, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x9C, 0x21, 0x04, 0x30, 0x1F, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xA0, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xC0, 0x21, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xC8, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xCC, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xD0, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xD4, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xD8, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xDC, 0x21, 0x04,
  0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xE0, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xA0,
  0x20, 0x04, 0x30, 0xEF, 0xE1, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xA4, 0x20, 0x04, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xB0, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4, 0x20,
  0x04, 0x30, 0x14, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xC8, 0x20, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xCC, 0x20, 0x04, 0x30, 0x20, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x50, 0x20, 0x04,
  0x30, 0x00, 0x02, 0xA8, 0x02, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xA8, 0x20, 0x04, 0x30, 0xFE, 0x21,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x04,
  0x00, 0x00, 0x38, 0x00, 0x07, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x08, 0x00, 0x00, 0x38,
  0x00, 0x15, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x0C, 0x00, 0x00, 0x38, 0x01, 0x03, 0x02,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10, 0x00,
  0x00, 0x38, 0x01, 0x07, 0x02, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x14, 0x00, 0x00, 0x38, 0x0C,
  0x0C, 0x05, 0x00, 0x04, 0x02, 0x00, 0x80, 0x05,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x8B, 0x07, 0x20, 0x60, 0x8A, 0x07, 0x20,
  0xFF, 0x93, 0x07, 0x20, 0x61, 0x92, 0x07, 0x20,
  0xFF, 0x9B, 0x07, 0x20, 0x62, 0x9A, 0x07, 0x20,
  0xFF, 0xA3, 0x07, 0x20, 0x63, 0xA2, 0x07, 0x20,
  0xFF, 0xAB, 0x07, 0x20, 0x64, 0xAA, 0x07, 0x20,
  0xFF, 0xB3, 0x07, 0x20, 0x65, 0xB2, 0x07, 0x20,
  0xFF, 0xBB, 0x07, 0x20, 0x66, 0xBA, 0x07, 0x20,
  0xFF, 0xC3, 0x07, 0x20, 0x67, 0xC2, 0x07, 0x20,
  0xFF, 0xCB, 0x07, 0x20, 0x68, 0xCA, 0x07, 0x20,
  0xFF, 0xD3, 0x07, 0x20, 0x69, 0xD2, 0x07, 0x20,
  0xFF, 0xDB, 0x07, 0x20, 0x6A, 0xDA, 0x07, 0x20,
  0xFF, 0xE3, 0x07, 0x20, 0x6B, 0xE2, 0x07, 0x20,
  0xFF, 0xEB, 0x07, 0x20, 0x6C, 0xEA, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x6D, 0xF2, 0x07, 0x20,
  0xFF, 0xFB, 0x07, 0x20, 0x6E, 0xFA, 0x07, 0x20,
  0xFF, 0x85, 0x07, 0x20, 0x6F, 0x84, 0x07, 0x20,
  0xFF, 0x8D, 0x07, 0x20, 0x70, 0x8C, 0x07, 0x20,
  0xFF, 0x95, 0x07, 0x20, 0x71, 0x94, 0x07, 0x20,
  0xFF, 0x9D, 0x07, 0x20, 0x72, 0x9C, 0x07, 0x20,
  0xFF, 0xA5, 0x07, 0x20, 0x73, 0xA4, 0x07, 0x20,
  0xFF, 0xAD, 0x07, 0x20, 0x74, 0xAC, 0x07, 0x20,
  0xFF, 0xB5, 0x07, 0x20, 0x75, 0xB4, 0x07, 0x20,
  0xFF, 0xBD, 0x07, 0x20, 0x76, 0xBC, 0x07, 0x20,
  0xFF, 0xC5, 0x07, 0x20, 0x77, 0xC4, 0x07, 0x20,
  0xFF, 0xCD, 0x07, 0x20, 0x78, 0xCC, 0x07, 0x20,
  0xFF, 0xD5, 0x07, 0x20, 0x79, 0xD4, 0x07, 0x20,
  0xFF, 0xDD, 0x07, 0x20, 0x7A, 0xDC, 0x07, 0x20,
  0xFF, 0xE5, 0x07, 0x20, 0x7B, 0xE4, 0x07, 0x20,
  0xFF, 0xED, 0x07, 0x20, 0x7C, 0xEC, 0x07, 0x20,
  0xFF, 0xF5, 0x07, 0x20, 0x7D, 0xF4, 0x07, 0x20,
  0xFF, 0xFD, 0x07, 0x20, 0x7E, 0xFC, 0x07, 0x20,
  0xFF, 0x87, 0x07, 0x20, 0x7F, 0x86, 0x07, 0x20,
  0xFF, 0x8F, 0x07, 0x20, 0x80, 0x8E, 0x07, 0x20,
  0xFF, 0x97, 0x07, 0x20, 0x81, 0x96, 0x07, 0x20,
  0xFF, 0x9F, 0x07, 0x20, 0x82, 0x9E, 0x07, 0x20,
  0xFF, 0xA7, 0x07, 0x20, 0x83, 0xA6, 0x07, 0x20,
  0xFF, 0xAF, 0x07, 0x20, 0x84, 0xAE, 0x07, 0x20,
  0xFF, 0xB7, 0x07, 0x20, 0x85, 0xB6, 0x07, 0x20,
  0xFF, 0xBF, 0x07, 0x20, 0x86, 0xBE, 0x07, 0x20,
  0xFF, 0xC7, 0x07, 0x20, 0x87, 0xC6, 0x07, 0x20,
  0xFF, 0xCF, 0x07, 0x20, 0x88, 0xCE, 0x07, 0x20,
  0xFF, 0xD7, 0x07, 0x20, 0x89, 0xD6, 0x07, 0x20,
  0xFF, 0xDF, 0x07, 0x20, 0x8A, 0xDE, 0x07, 0x20,
  0xFF, 0xE7, 0x07, 0x20, 0x8B, 0xE6, 0x07, 0x20,
  0xFF, 0xEF, 0x07, 0x20, 0x8C, 0xEE, 0x07, 0x20,
  0xFF, 0xF7, 0x07, 0x20, 0x8D, 0xF6, 0x07, 0x20,
  0xFF, 0xFF, 0x07, 0x20, 0x8E, 0xFE, 0x07, 0x20,
  0xFF, 0x83, 0xA7, 0x00, 0x5F, 0x82, 0xA7, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x00, 0x5F, 0x82, 0x27, 0x00,
  0xFF, 0x83, 0x27, 0x20, 0x5F, 0x82, 0x27, 0x20,
  0xFF, 0x8B, 0x27, 0x20, 0x60, 0x8A, 0x27, 0x20,
  0xFF, 0x93, 0x27, 0x20, 0x61, 0x92, 0x27, 0x20,
  0xFF, 0x9B, 0x27, 0x20, 0x62, 0x9A, 0x27, 0x20,
  0xFF, 0xA3, 0x27, 0x20, 0x63, 0xA2, 0x27, 0x20,
  0xFF, 0xAB, 0x27, 0x20, 0x64, 0xAA, 0x27, 0x20,
  0xFF, 0xB3, 0x27, 0x20, 0x65, 0xB2, 0x27, 0x20,
  0xFF, 0xBB, 0x27, 0x20, 0x66, 0xBA, 0x27, 0x20,
  0xFF, 0xC3, 0x27, 0x20, 0x67, 0xC2, 0x27, 0x20,
  0xFF, 0xCB, 0x27, 0x20, 0x68, 0xCA, 0x27, 0x20,
  0xFF, 0xD3, 0x27, 0x20, 0x69, 0xD2, 0x27, 0x20,
  0xFF, 0xDB, 0x27, 0x20, 0x6A, 0xDA, 0x27, 0x20,
  0xFF, 0xE3, 0x27, 0x20, 0x6B, 0xE2, 0x27, 0x20,
  0xFF, 0xEB, 0x27, 0x20, 0x6C, 0xEA, 0x27, 0x20,
  0xFF, 0xF3, 0x27, 0x20, 0x6D, 0xF2, 0x27, 0x20,
  0xFF, 0xFB, 0x27, 0x20, 0x6E, 0xFA, 0x27, 0x20,
  0xFF, 0x85, 0x27, 0x20, 0x6F, 0x84, 0x27, 0x20,
  0xFF, 0x8D, 0x27, 0x20, 0x70, 0x8C, 0x27, 0x20,
  0xFF, 0x95, 0x27, 0x20, 0x71, 0x94, 0x27, 0x20,
  0xFF, 0x9D, 0x27, 0x20, 0x72, 0x9C, 0x27, 0x20,
  0xFF, 0xA5, 0x27, 0x20, 0x73, 0xA4, 0x27, 0x20,
  0xFF, 0xAD, 0x27, 0x20, 0x74, 0xAC, 0x27, 0x20,
  0xFF, 0xB5, 0x27, 0x20, 0x75, 0xB4, 0x27, 0x20,
  0xFF, 0xBD, 0x27, 0x20, 0x76, 0xBC, 0x27, 0x20,
  0xFF, 0xC5, 0x27, 0x20, 0x77, 0xC4, 0x27, 0x20,
  0xFF, 0xCD, 0x27, 0x20, 0x78, 0xCC, 0x27, 0x20,
  0xFF, 0xD5, 0x27, 0x20, 0x79, 0xD4, 0x27, 0x20,
  0xFF, 0xDD, 0x27, 0x20, 0x7A, 0xDC, 0x27, 0x20,
  0xFF, 0xE5, 0x27, 0x20, 0x7B, 0xE4, 0x27, 0x20,
  0xFF, 0xED, 0x27, 0x20, 0x7C, 0xEC, 0x27, 0x20,
  0xFF, 0xF5, 0x27, 0x20, 0x7D, 0xF4, 0x27, 0x20,
  0xFF, 0xFD, 0x27, 0x20, 0x7E, 0xFC, 0x27, 0x20,
  0xFF, 0x87, 0x27, 0x20, 0x7F, 0x86, 0x27, 0x20,
  0xFF, 0x8F, 0x27, 0x20, 0x80, 0x8E, 0x27, 0x20,
  0xFF, 0x97, 0x27, 0x20, 0x81, 0x96, 0x27, 0x20,
  0xFF, 0x9F, 0x27, 0x20, 0x82, 0x9E, 0x27, 0x20,
  0xFF, 0xA7, 0x27, 0x20, 0x83, 0xA6, 0x27, 0x20,
  0xFF, 0xAF, 0x27, 0x20, 0x84, 0xAE, 0x27, 0x20,
  0xFF, 0xB7, 0x27, 0x20, 0x85, 0xB6, 0x27, 0x20,
  0xFF, 0xBF, 0x27, 0x20, 0x86, 0xBE, 0x27, 0x20,
  0xFF, 0xC7, 0x27, 0x20, 0x87, 0xC6, 0x27, 0x20,
  0xFF, 0xCF, 0x27, 0x20, 0x88, 0xCE, 0x27, 0x20,
  0xFF, 0xD7, 0x27, 0x20, 0x89, 0xD6, 0x27, 0x20,
  0xFF, 0xDF, 0x27, 0x20, 0x8A, 0xDE, 0x27, 0x20,
  0xFF, 0xE7, 0x27, 0x20, 0x8B, 0xE6, 0x27, 0x20,
  0xFF, 0xEF, 0x27, 0x20, 0x8C, 0xEE, 0x27, 0x20,
  0xFF, 0xF7, 0x27, 0x20, 0x8D, 0xF6, 0x27, 0x20,
  0xFF, 0xFF, 0x27, 0x20, 0x8E, 0xFE, 0x27, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x00, 0x08, 0x00, 0x10, 0x03, 0x18, 0x1C,
  0x10, 0x03, 0x18, 0x1C, 0x03, 0x00, 0x09, 0x00,
  0x00, 0x20, 0x04, 0x30, 0x80, 0x00, 0x00, 0x00,
  0x04, 0x0C, 0x00, 0x01, 0x00, 0x00, 0x0D, 0x00,
  0x78, 0x01, 0x50, 0x01, 0x00, 0x00, 0x0E, 0x00,
  0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x6E,
  0x00, 0x65, 0x00, 0x65, 0x00, 0x72, 0x00, 0x69,
  0x00, 0x6E, 0x00, 0x67, 0x00, 0x5C, 0x00, 0x70,
  0x00, 0x72, 0x00, 0x69, 0x00, 0x76, 0x03, 0x00,
  0x00, 0x00, 0x0C, 0x00, 0x00, 0x38, 0x00, 0x07,
  0x00, 0x00, 0xFD, 0x00, 0xFF, 0xFF, 0x0C, 0x00,
  0x00, 0x38, 0x02, 0x07, 0x00, 0x00, 0xFD, 0x00,
  0xFF, 0xFF, 0x0C, 0x00, 0x00, 0x38, 0x00, 0x08,
  0x00, 0x00, 0xFD, 0x00, 0xFF, 0xFF, 0x0C, 0x00,
  0x00, 0x38, 0x02, 0x08, 0x00, 0x00, 0xFD, 0x00,
  0xFF, 0xFF, 0x0C, 0x00, 0x00, 0x38, 0x00, 0x02,
  0x00, 0x00, 0xFD, 0x00, 0xFF, 0xFF, 0x0C, 0x00,
  0x00, 0x38, 0x02, 0x02, 0x00, 0x00, 0xFD, 0x00,
  0xFF, 0xFF, 0x0C, 0x00, 0x00, 0x38, 0x00, 0x03,
  0x00, 0x00, 0xFD, 0x00, 0xFF, 0xFF, 0x0C, 0x00,
  0x00, 0x38, 0x02, 0x03, 0x00, 0x00, 0xFD, 0x00,
  0xFF, 0xFF, 0x0C, 0x00, 0x00, 0x38, 0x00, 0x04,
  0x00, 0x00, 0xFD, 0x00, 0xFF, 0xFF, 0x0C, 0x00,
  0x00, 0x38, 0x02, 0x04, 0x00, 0x00, 0xFD, 0x00,
  0xFF, 0xFF, 0x0C, 0x00, 0x00, 0x38, 0x00, 0x05,
  0x00, 0x00, 0xFD, 0x00, 0xFF, 0xFF, 0x0C, 0x00,
  0x00, 0x38, 0x02, 0x05, 0x00, 0x00, 0xFD, 0x00,
  0xFF, 0xFF, 0x0C, 0x00, 0x00, 0x38, 0x00, 0x06,
  0x00, 0x00, 0xFD, 0x00, 0xFF, 0xFF, 0x0C, 0x00,
  0x00, 0x38, 0x02, 0x06, 0x00, 0x00, 0xFD, 0x00,
  0xFF, 0xFF, 0x10, 0x00, 0x00, 0x38, 0x02, 0x03,
  0x00, 0x00, 0xFD, 0x00, 0xFF, 0xFF, 0x10, 0x00,
  0x00, 0x38, 0x00, 0x04, 0x00, 0x00, 0xFD, 0x00,
  0xFF, 0xFF, 0x10, 0x00, 0x00, 0x38, 0x02, 0x04,
  0x00, 0x00, 0xFD, 0x00, 0xFF, 0xFF, 0x10, 0x00,
  0x00, 0x38, 0x00, 0x05, 0x00, 0x00, 0xFD, 0x00,
  0xFF, 0xFF, 0x10, 0x00, 0x00, 0x38, 0x02, 0x05,
  0x00, 0x00, 0xFD, 0x00, 0xFF, 0xFF, 0x10, 0x00,
  0x00, 0x38, 0x00, 0x06, 0x00, 0x00, 0xFD, 0x00,
  0xFF, 0xFF, 0x10, 0x00, 0x00, 0x38, 0x02, 0x06,
  0x00, 0x00, 0xFD, 0x00, 0xFF, 0xFF, 0x10, 0x00,
  0x00, 0x38, 0x00, 0x07, 0x00, 0x00, 0xFD, 0x00,
  0xFF, 0xFF, 0x10, 0x00, 0x00, 0x38, 0x02, 0x07,
  0x00, 0x00, 0xFD, 0x00, 0xFF, 0xFF, 0x10, 0x00,
  0x00, 0x38, 0x00, 0x08, 0x00, 0x00, 0xFD, 0x00,
  0xFF, 0xFF, 0x10, 0x00, 0x00, 0x38, 0x02, 0x08,
  0x00, 0x00, 0xFD, 0x00, 0xFF, 0xFF, 0x10, 0x00,
  0x00, 0x38, 0x00, 0x09, 0x00, 0x00, 0xFD, 0x00,
  0xFF, 0xFF, 0x10, 0x00, 0x00, 0x38, 0x02, 0x09,
  0x00, 0x00, 0xFD, 0x00, 0xFF, 0xFF, 0x10, 0x00,
  0x00, 0x38, 0x00, 0x0A, 0x00, 0x00, 0xFD, 0x00,
  0xFF, 0xFF, 0x0E, 0x00, 0xE0, 0x00, 0x00, 0x01,
  0x00, 0x01, 0x00, 0x01, 0x00, 0x1F, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x01,
  0x01, 0x01, 0x00, 0x01, 0x00, 0x1F, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x00, 0x1F, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x01,
  0x02, 0x01, 0x01, 0x01, 0x00, 0x1F, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x1F, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x01,
  0x02, 0x01, 0x01, 0x01, 0x01, 0x1F, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x01,
  0x04, 0x01, 0x01, 0x01, 0x01, 0x1F, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x01,
  0x04, 0x01, 0x02, 0x01, 0x01, 0x1F, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x01,
  0x08, 0x01, 0x02, 0x01, 0x01, 0x1F, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x01,
  0x08, 0x01, 0x04, 0x01, 0x01, 0x1F, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x01,
  0x10, 0x01, 0x04, 0x01, 0x01, 0x1F, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x01,
  0x10, 0x01, 0x08, 0x01, 0x01, 0x1F, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x01,
  0x10, 0x01, 0x08, 0x01, 0x02, 0x1F, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x01,
  0x10, 0x01, 0x10, 0x01, 0x02, 0x1F, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x0F, 0x00,
  0x01, 0x00, 0x02, 0x10, 0x00, 0x01, 0x00, 0x01,
  0x11, 0x00, 0x02, 0x00, 0x0E, 0x00, 0x12, 0x00,
  0x01, 0x00, 0x0E, 0x15, 0x00, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x20, 0x28, 0x00, 0x00,
};

static unsigned char vfs5011_init_07[] = { /* 2503 B */
  0x02, 0xB0, 0x00, 0x00, 0x01, 0x03, 0x00, 0x09,
  0x00, 0x04, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x18, 0x20,
  0x04, 0x30, 0x01, 0x80, 0x4F, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x20, 0x04, 0x30, 0x08,
  0x00, 0x80, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x24, 0x20, 0x04, 0x30, 0x00, 0x00, 0xFF, 0x01,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x2C, 0x20, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x40, 0x20, 0x04, 0x30, 0xFF, 0x03,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x44,
  0x20, 0x04, 0x30, 0xE6, 0x03, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x48, 0x20, 0x04, 0x30,
  0xE7, 0x03, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x4C, 0x20, 0x04, 0x30, 0xE8, 0x03, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x20,
  0x04, 0x30, 0x00, 0x3E, 0x01, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x00, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x04, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x08, 0x21, 0x04,
  0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x0C, 0x21, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10,
  0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x14, 0x21, 0x04, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x18, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x1C, 0x21,
  0x04, 0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x40, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x44, 0x21, 0x04,
  0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x48, 0x21, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x4C,
  0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x50, 0x21, 0x04, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x54, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x58, 0x21,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x5C, 0x21, 0x04, 0x30, 0x1F,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x60, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x80, 0x21, 0x04,
  0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x84, 0x21, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x88,
  0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x8C, 0x21, 0x04, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x90, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x94, 0x21,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x98, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x9C, 0x21, 0x04, 0x30, 0x1F, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xA0, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xC0, 0x21, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4,
  0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xC8, 0x21, 0x04, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xCC, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xD0, 0x21,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xD4, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xD8, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xDC, 0x21, 0x04,
  0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xE0, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xA0,
  0x20, 0x04, 0x30, 0xEF, 0xE1, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xA4, 0x20, 0x04, 0x30,
  0x00, 0x40, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xB0, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4, 0x20,
  0x04, 0x30, 0x14, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xC8, 0x20, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xCC, 0x20, 0x04, 0x30, 0x20, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x50, 0x20, 0x04,
  0x30, 0x00, 0x02, 0xA8, 0x02, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xA8, 0x20, 0x04, 0x30, 0xFE, 0x21,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x04,
  0x00, 0x00, 0x38, 0x00, 0x07, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x08, 0x00, 0x00, 0x38,
  0x00, 0x15, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x0C, 0x00, 0x00, 0x38, 0x01, 0x03, 0x02,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10, 0x00,
  0x00, 0x38, 0x01, 0x07, 0x02, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x14, 0x00, 0x00, 0x38, 0x0C,
  0x0C, 0x05, 0x00, 0x04, 0x02, 0x00, 0x80, 0x05,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x8B, 0x07, 0x20, 0x60, 0x8A, 0x07, 0x20,
  0xFF, 0x93, 0x07, 0x20, 0x61, 0x92, 0x07, 0x20,
  0xFF, 0x9B, 0x07, 0x20, 0x62, 0x9A, 0x07, 0x20,
  0xFF, 0xA3, 0x07, 0x20, 0x63, 0xA2, 0x07, 0x20,
  0xFF, 0xAB, 0x07, 0x20, 0x64, 0xAA, 0x07, 0x20,
  0xFF, 0xB3, 0x07, 0x20, 0x65, 0xB2, 0x07, 0x20,
  0xFF, 0xBB, 0x07, 0x20, 0x66, 0xBA, 0x07, 0x20,
  0xFF, 0xC3, 0x07, 0x20, 0x67, 0xC2, 0x07, 0x20,
  0xFF, 0xCB, 0x07, 0x20, 0x68, 0xCA, 0x07, 0x20,
  0xFF, 0xD3, 0x07, 0x20, 0x69, 0xD2, 0x07, 0x20,
  0xFF, 0xDB, 0x07, 0x20, 0x6A, 0xDA, 0x07, 0x20,
  0xFF, 0xE3, 0x07, 0x20, 0x6B, 0xE2, 0x07, 0x20,
  0xFF, 0xEB, 0x07, 0x20, 0x6C, 0xEA, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x6D, 0xF2, 0x07, 0x20,
  0xFF, 0xFB, 0x07, 0x20, 0x6E, 0xFA, 0x07, 0x20,
  0xFF, 0x85, 0x07, 0x20, 0x6F, 0x84, 0x07, 0x20,
  0xFF, 0x8D, 0x07, 0x20, 0x70, 0x8C, 0x07, 0x20,
  0xFF, 0x95, 0x07, 0x20, 0x71, 0x94, 0x07, 0x20,
  0xFF, 0x9D, 0x07, 0x20, 0x72, 0x9C, 0x07, 0x20,
  0xFF, 0xA5, 0x07, 0x20, 0x73, 0xA4, 0x07, 0x20,
  0xFF, 0xAD, 0x07, 0x20, 0x74, 0xAC, 0x07, 0x20,
  0xFF, 0xB5, 0x07, 0x20, 0x75, 0xB4, 0x07, 0x20,
  0xFF, 0xBD, 0x07, 0x20, 0x76, 0xBC, 0x07, 0x20,
  0xFF, 0xC5, 0x07, 0x20, 0x77, 0xC4, 0x07, 0x20,
  0xFF, 0xCD, 0x07, 0x20, 0x78, 0xCC, 0x07, 0x20,
  0xFF, 0xD5, 0x07, 0x20, 0x79, 0xD4, 0x07, 0x20,
  0xFF, 0xDD, 0x07, 0x20, 0x7A, 0xDC, 0x07, 0x20,
  0xFF, 0xE5, 0x07, 0x20, 0x7B, 0xE4, 0x07, 0x20,
  0xFF, 0xED, 0x07, 0x20, 0x7C, 0xEC, 0x07, 0x20,
  0xFF, 0xF5, 0x07, 0x20, 0x7D, 0xF4, 0x07, 0x20,
  0xFF, 0xFD, 0x07, 0x20, 0x7E, 0xFC, 0x07, 0x20,
  0xFF, 0x87, 0x07, 0x20, 0x7F, 0x86, 0x07, 0x20,
  0xFF, 0x8F, 0x07, 0x20, 0x80, 0x8E, 0x07, 0x20,
  0xFF, 0x97, 0x07, 0x20, 0x81, 0x96, 0x07, 0x20,
  0xFF, 0x9F, 0x07, 0x20, 0x82, 0x9E, 0x07, 0x20,
  0xFF, 0xA7, 0x07, 0x20, 0x83, 0xA6, 0x07, 0x20,
  0xFF, 0xAF, 0x07, 0x20, 0x84, 0xAE, 0x07, 0x20,
  0xFF, 0xB7, 0x07, 0x20, 0x85, 0xB6, 0x07, 0x20,
  0xFF, 0xBF, 0x07, 0x20, 0x86, 0xBE, 0x07, 0x20,
  0xFF, 0xC7, 0x07, 0x20, 0x87, 0xC6, 0x07, 0x20,
  0xFF, 0xCF, 0x07, 0x20, 0x88, 0xCE, 0x07, 0x20,
  0xFF, 0xD7, 0x07, 0x20, 0x89, 0xD6, 0x07, 0x20,
  0xFF, 0xDF, 0x07, 0x20, 0x8A, 0xDE, 0x07, 0x20,
  0xFF, 0xE7, 0x07, 0x20, 0x8B, 0xE6, 0x07, 0x20,
  0xFF, 0xEF, 0x07, 0x20, 0x8C, 0xEE, 0x07, 0x20,
  0xFF, 0xF7, 0x07, 0x20, 0x8D, 0xF6, 0x07, 0x20,
  0xFF, 0xFF, 0x07, 0x20, 0x8E, 0xFE, 0x07, 0x20,
  0xFF, 0xFF, 0x07, 0x20, 0x8E, 0xFE, 0x07, 0x20,
  0xFF, 0xF7, 0x07, 0x20, 0x8D, 0xF6, 0x07, 0x20,
  0xFF, 0xEF, 0x07, 0x20, 0x8C, 0xEE, 0x07, 0x20,
  0xFF, 0xE7, 0x07, 0x20, 0x8B, 0xE6, 0x07, 0x20,
  0xFF, 0xDF, 0x07, 0x20, 0x8A, 0xDE, 0x07, 0x20,
  0xFF, 0xD7, 0x07, 0x20, 0x89, 0xD6, 0x07, 0x20,
  0xFF, 0xCF, 0x07, 0x20, 0x88, 0xCE, 0x07, 0x20,
  0xFF, 0xC7, 0x07, 0x20, 0x87, 0xC6, 0x07, 0x20,
  0xFF, 0xBF, 0x07, 0x20, 0x86, 0xBE, 0x07, 0x20,
  0xFF, 0xB7, 0x07, 0x20, 0x85, 0xB6, 0x07, 0x20,
  0xFF, 0xAF, 0x07, 0x20, 0x84, 0xAE, 0x07, 0x20,
  0xFF, 0xA7, 0x07, 0x20, 0x83, 0xA6, 0x07, 0x20,
  0xFF, 0x9F, 0x07, 0x20, 0x82, 0x9E, 0x07, 0x20,
  0xFF, 0x97, 0x07, 0x20, 0x81, 0x96, 0x07, 0x20,
  0xFF, 0x8F, 0x07, 0x20, 0x80, 0x8E, 0x07, 0x20,
  0xFF, 0x87, 0x07, 0x20, 0x7F, 0x86, 0x07, 0x20,
  0xFF, 0xFD, 0x07, 0x20, 0x7E, 0xFC, 0x07, 0x20,
  0xFF, 0xF5, 0x07, 0x20, 0x7D, 0xF4, 0x07, 0x20,
  0xFF, 0xED, 0x07, 0x20, 0x7C, 0xEC, 0x07, 0x20,
  0xFF, 0xE5, 0x07, 0x20, 0x7B, 0xE4, 0x07, 0x20,
  0xFF, 0xDD, 0x07, 0x20, 0x7A, 0xDC, 0x07, 0x20,
  0xFF, 0xD5, 0x07, 0x20, 0x79, 0xD4, 0x07, 0x20,
  0xFF, 0xCD, 0x07, 0x20, 0x78, 0xCC, 0x07, 0x20,
  0xFF, 0xC5, 0x07, 0x20, 0x77, 0xC4, 0x07, 0x20,
  0xFF, 0xBD, 0x07, 0x20, 0x76, 0xBC, 0x07, 0x20,
  0xFF, 0xB5, 0x07, 0x20, 0x75, 0xB4, 0x07, 0x20,
  0xFF, 0xAD, 0x07, 0x20, 0x74, 0xAC, 0x07, 0x20,
  0xFF, 0xA5, 0x07, 0x20, 0x73, 0xA4, 0x07, 0x20,
  0xFF, 0x9D, 0x07, 0x20, 0x72, 0x9C, 0x07, 0x20,
  0xFF, 0x95, 0x07, 0x20, 0x71, 0x94, 0x07, 0x20,
  0xFF, 0x8D, 0x07, 0x20, 0x70, 0x8C, 0x07, 0x20,
  0xFF, 0x85, 0x07, 0x20, 0x6F, 0x84, 0x07, 0x20,
  0xFF, 0xFB, 0x07, 0x20, 0x6E, 0xFA, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x6D, 0xF2, 0x07, 0x20,
  0xFF, 0xEB, 0x07, 0x20, 0x6C, 0xEA, 0x07, 0x20,
  0xFF, 0xE3, 0x07, 0x20, 0x6B, 0xE2, 0x07, 0x20,
  0xFF, 0xDB, 0x07, 0x20, 0x6A, 0xDA, 0x07, 0x20,
  0xFF, 0xD3, 0x07, 0x20, 0x69, 0xD2, 0x07, 0x20,
  0xFF, 0xCB, 0x07, 0x20, 0x68, 0xCA, 0x07, 0x20,
  0xFF, 0xC3, 0x07, 0x20, 0x67, 0xC2, 0x07, 0x20,
  0xFF, 0xBB, 0x07, 0x20, 0x66, 0xBA, 0x07, 0x20,
  0xFF, 0xB3, 0x07, 0x20, 0x65, 0xB2, 0x07, 0x20,
  0xFF, 0xAB, 0x07, 0x20, 0x64, 0xAA, 0x07, 0x20,
  0xFF, 0xA3, 0x07, 0x20, 0x63, 0xA2, 0x07, 0x20,
  0xFF, 0x9B, 0x07, 0x20, 0x62, 0x9A, 0x07, 0x20,
  0xFF, 0x93, 0x07, 0x20, 0x61, 0x92, 0x07, 0x20,
  0xFF, 0x8B, 0x07, 0x20, 0x60, 0x8A, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x00, 0x08, 0x00, 0x10, 0x03, 0x18, 0x1C,
  0x10, 0x03, 0x18, 0x1C, 0x03, 0x00, 0x09, 0x00,
  0x00, 0x20, 0x04, 0x30, 0x80, 0x00, 0x00, 0x00,
  0x04, 0x0C, 0x00, 0x01, 0x00, 0x03, 0x0D, 0x00,
  0x28, 0x00, 0xC8, 0x20, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x01, 0x00,
  0x00, 0x00, 0xC8, 0x20, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x1C, 0x02, 0xB0, 0x01, 0x00,
  0x00, 0x00, 0x0E, 0x00, 0x10, 0x00, 0x00, 0x01,
  0x01, 0x01, 0x01, 0x00, 0x01, 0x1F, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0F, 0x00,
  0x01, 0x00, 0x01, 0x10, 0x00, 0x01, 0x00, 0x01,
  0x11, 0x00, 0x02, 0x00, 0x00, 0x01, 0x12, 0x00,
  0x01, 0x00, 0x01, 0x05, 0x00, 0x0E, 0x00, 0x0C,
  0x20, 0xFD, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x08, 0x00, 0x00, 0x05, 0x00, 0x0E,
  0x00, 0x10, 0x20, 0xFD, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x03,
  0x00, 0x09, 0x00, 0x04, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x08, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x0C, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x10, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x14,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x18, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x44, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x48, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x4C, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x50, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x58, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x15, 0x00, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x20, 0x28, 0x00, 0x00,
};

static unsigned char vfs5011_init_08[] = { /* 2516 B */
  0x02, 0xB0, 0x00, 0x60, 0x00, 0x03, 0x00, 0x09,
  0x00, 0x04, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x18, 0x20,
  0x04, 0x30, 0x01, 0x80, 0x4F, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x20, 0x04, 0x30, 0x08,
  0x00, 0x80, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x24, 0x20, 0x04, 0x30, 0x00, 0x00, 0xFF, 0x01,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x2C, 0x20, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x40, 0x20, 0x04, 0x30, 0xFF, 0x03,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x44,
  0x20, 0x04, 0x30, 0xE6, 0x03, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x48, 0x20, 0x04, 0x30,
  0xE7, 0x03, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x4C, 0x20, 0x04, 0x30, 0xE8, 0x03, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x20,
  0x04, 0x30, 0x00, 0x3E, 0x01, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x00, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x04, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x08, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x0C, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x14, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x18, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x1C, 0x21,
  0x04, 0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x21, 0x04, 0x30, 0x05,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x40, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x44, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x48, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x4C,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x50, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x54, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x58, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x5C, 0x21, 0x04, 0x30, 0x1F,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x60, 0x21, 0x04, 0x30, 0x05, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x80, 0x21, 0x04,
  0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x84, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x88,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x8C, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x90, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x94, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x98, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x9C, 0x21, 0x04, 0x30, 0x1F, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xA0, 0x21, 0x04,
  0x30, 0x05, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xC0, 0x21, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xC8, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xCC, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xD0, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xD4, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xD8, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xDC, 0x21, 0x04,
  0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xE0, 0x21, 0x04, 0x30, 0x05, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xA0,
  0x20, 0x04, 0x30, 0xEF, 0xE1, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xA4, 0x20, 0x04, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xB0, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4, 0x20,
  0x04, 0x30, 0x14, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xC8, 0x20, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xCC, 0x20, 0x04, 0x30, 0x20, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x50, 0x20, 0x04,
  0x30, 0x00, 0x02, 0xA8, 0x02, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xA8, 0x20, 0x04, 0x30, 0xFE, 0x21,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x04,
  0x00, 0x00, 0x38, 0x00, 0x07, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x08, 0x00, 0x00, 0x38,
  0x00, 0x15, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x0C, 0x00, 0x00, 0x38, 0x01, 0x03, 0x02,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10, 0x00,
  0x00, 0x38, 0x01, 0x07, 0x02, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x14, 0x00, 0x00, 0x38, 0x0C,
  0x0C, 0x05, 0x00, 0x04, 0x02, 0x00, 0x80, 0x05,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x8B, 0x07, 0x20, 0x60, 0x8A, 0x07, 0x20,
  0xFF, 0x93, 0x07, 0x20, 0x61, 0x92, 0x07, 0x20,
  0xFF, 0x9B, 0x07, 0x20, 0x62, 0x9A, 0x07, 0x20,
  0xFF, 0xA3, 0x07, 0x20, 0x63, 0xA2, 0x07, 0x20,
  0xFF, 0xAB, 0x07, 0x20, 0x64, 0xAA, 0x07, 0x20,
  0xFF, 0xB3, 0x07, 0x20, 0x65, 0xB2, 0x07, 0x20,
  0xFF, 0xBB, 0x07, 0x20, 0x66, 0xBA, 0x07, 0x20,
  0xFF, 0xC3, 0x07, 0x20, 0x67, 0xC2, 0x07, 0x20,
  0xFF, 0xCB, 0x07, 0x20, 0x68, 0xCA, 0x07, 0x20,
  0xFF, 0xD3, 0x07, 0x20, 0x69, 0xD2, 0x07, 0x20,
  0xFF, 0xDB, 0x07, 0x20, 0x6A, 0xDA, 0x07, 0x20,
  0xFF, 0xE3, 0x07, 0x20, 0x6B, 0xE2, 0x07, 0x20,
  0xFF, 0xEB, 0x07, 0x20, 0x6C, 0xEA, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x6D, 0xF2, 0x07, 0x20,
  0xFF, 0xFB, 0x07, 0x20, 0x6E, 0xFA, 0x07, 0x20,
  0xFF, 0x85, 0x07, 0x20, 0x6F, 0x84, 0x07, 0x20,
  0xFF, 0x8D, 0x07, 0x20, 0x70, 0x8C, 0x07, 0x20,
  0xFF, 0x95, 0x07, 0x20, 0x71, 0x94, 0x07, 0x20,
  0xFF, 0x9D, 0x07, 0x20, 0x72, 0x9C, 0x07, 0x20,
  0xFF, 0xA5, 0x07, 0x20, 0x73, 0xA4, 0x07, 0x20,
  0xFF, 0xAD, 0x07, 0x20, 0x74, 0xAC, 0x07, 0x20,
  0xFF, 0xB5, 0x07, 0x20, 0x75, 0xB4, 0x07, 0x20,
  0xFF, 0xBD, 0x07, 0x20, 0x76, 0xBC, 0x07, 0x20,
  0xFF, 0xC5, 0x07, 0x20, 0x77, 0xC4, 0x07, 0x20,
  0xFF, 0xCD, 0x07, 0x20, 0x78, 0xCC, 0x07, 0x20,
  0xFF, 0xD5, 0x07, 0x20, 0x79, 0xD4, 0x07, 0x20,
  0xFF, 0xDD, 0x07, 0x20, 0x7A, 0xDC, 0x07, 0x20,
  0xFF, 0xE5, 0x07, 0x20, 0x7B, 0xE4, 0x07, 0x20,
  0xFF, 0xED, 0x07, 0x20, 0x7C, 0xEC, 0x07, 0x20,
  0xFF, 0xF5, 0x07, 0x20, 0x7D, 0xF4, 0x07, 0x20,
  0xFF, 0xFD, 0x07, 0x20, 0x7E, 0xFC, 0x07, 0x20,
  0xFF, 0x87, 0x07, 0x20, 0x7F, 0x86, 0x07, 0x20,
  0xFF, 0x8F, 0x07, 0x20, 0x80, 0x8E, 0x07, 0x20,
  0xFF, 0x97, 0x07, 0x20, 0x81, 0x96, 0x07, 0x20,
  0xFF, 0x9F, 0x07, 0x20, 0x82, 0x9E, 0x07, 0x20,
  0xFF, 0xA7, 0x07, 0x20, 0x83, 0xA6, 0x07, 0x20,
  0xFF, 0xAF, 0x07, 0x20, 0x84, 0xAE, 0x07, 0x20,
  0xFF, 0xB7, 0x07, 0x20, 0x85, 0xB6, 0x07, 0x20,
  0xFF, 0xBF, 0x07, 0x20, 0x86, 0xBE, 0x07, 0x20,
  0xFF, 0xC7, 0x07, 0x20, 0x87, 0xC6, 0x07, 0x20,
  0xFF, 0xCF, 0x07, 0x20, 0x88, 0xCE, 0x07, 0x20,
  0xFF, 0xD7, 0x07, 0x20, 0x89, 0xD6, 0x07, 0x20,
  0xFF, 0xDF, 0x07, 0x20, 0x8A, 0xDE, 0x07, 0x20,
  0xFF, 0xE7, 0x07, 0x20, 0x8B, 0xE6, 0x07, 0x20,
  0xFF, 0xEF, 0x07, 0x20, 0x8C, 0xEE, 0x07, 0x20,
  0xFF, 0xF7, 0x07, 0x20, 0x8D, 0xF6, 0x07, 0x20,
  0xFF, 0xFF, 0x07, 0x20, 0x8E, 0xFE, 0x07, 0x20,
  0xFF, 0xFF, 0x07, 0x20, 0x8E, 0xFE, 0x07, 0x20,
  0xFF, 0xF7, 0x07, 0x20, 0x8D, 0xF6, 0x07, 0x20,
  0xFF, 0xEF, 0x07, 0x20, 0x8C, 0xEE, 0x07, 0x20,
  0xFF, 0xE7, 0x07, 0x20, 0x8B, 0xE6, 0x07, 0x20,
  0xFF, 0xDF, 0x07, 0x20, 0x8A, 0xDE, 0x07, 0x20,
  0xFF, 0xD7, 0x07, 0x20, 0x89, 0xD6, 0x07, 0x20,
  0xFF, 0xCF, 0x07, 0x20, 0x88, 0xCE, 0x07, 0x20,
  0xFF, 0xC7, 0x07, 0x20, 0x87, 0xC6, 0x07, 0x20,
  0xFF, 0xBF, 0x07, 0x20, 0x86, 0xBE, 0x07, 0x20,
  0xFF, 0xB7, 0x07, 0x20, 0x85, 0xB6, 0x07, 0x20,
  0xFF, 0xAF, 0x07, 0x20, 0x84, 0xAE, 0x07, 0x20,
  0xFF, 0xA7, 0x07, 0x20, 0x83, 0xA6, 0x07, 0x20,
  0xFF, 0x9F, 0x07, 0x20, 0x82, 0x9E, 0x07, 0x20,
  0xFF, 0x97, 0x07, 0x20, 0x81, 0x96, 0x07, 0x20,
  0xFF, 0x8F, 0x07, 0x20, 0x80, 0x8E, 0x07, 0x20,
  0xFF, 0x87, 0x07, 0x20, 0x7F, 0x86, 0x07, 0x20,
  0xFF, 0xFD, 0x07, 0x20, 0x7E, 0xFC, 0x07, 0x20,
  0xFF, 0xF5, 0x07, 0x20, 0x7D, 0xF4, 0x07, 0x20,
  0xFF, 0xED, 0x07, 0x20, 0x7C, 0xEC, 0x07, 0x20,
  0xFF, 0xE5, 0x07, 0x20, 0x7B, 0xE4, 0x07, 0x20,
  0xFF, 0xDD, 0x07, 0x20, 0x7A, 0xDC, 0x07, 0x20,
  0xFF, 0xD5, 0x07, 0x20, 0x79, 0xD4, 0x07, 0x20,
  0xFF, 0xCD, 0x07, 0x20, 0x78, 0xCC, 0x07, 0x20,
  0xFF, 0xC5, 0x07, 0x20, 0x77, 0xC4, 0x07, 0x20,
  0xFF, 0xBD, 0x07, 0x20, 0x76, 0xBC, 0x07, 0x20,
  0xFF, 0xB5, 0x07, 0x20, 0x75, 0xB4, 0x07, 0x20,
  0xFF, 0xAD, 0x07, 0x20, 0x74, 0xAC, 0x07, 0x20,
  0xFF, 0xA5, 0x07, 0x20, 0x73, 0xA4, 0x07, 0x20,
  0xFF, 0x9D, 0x07, 0x20, 0x72, 0x9C, 0x07, 0x20,
  0xFF, 0x95, 0x07, 0x20, 0x71, 0x94, 0x07, 0x20,
  0xFF, 0x8D, 0x07, 0x20, 0x70, 0x8C, 0x07, 0x20,
  0xFF, 0x85, 0x07, 0x20, 0x6F, 0x84, 0x07, 0x20,
  0xFF, 0xFB, 0x07, 0x20, 0x6E, 0xFA, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x6D, 0xF2, 0x07, 0x20,
  0xFF, 0xEB, 0x07, 0x20, 0x6C, 0xEA, 0x07, 0x20,
  0xFF, 0xE3, 0x07, 0x20, 0x6B, 0xE2, 0x07, 0x20,
  0xFF, 0xDB, 0x07, 0x20, 0x6A, 0xDA, 0x07, 0x20,
  0xFF, 0xD3, 0x07, 0x20, 0x69, 0xD2, 0x07, 0x20,
  0xFF, 0xCB, 0x07, 0x20, 0x68, 0xCA, 0x07, 0x20,
  0xFF, 0xC3, 0x07, 0x20, 0x67, 0xC2, 0x07, 0x20,
  0xFF, 0xBB, 0x07, 0x20, 0x66, 0xBA, 0x07, 0x20,
  0xFF, 0xB3, 0x07, 0x20, 0x65, 0xB2, 0x07, 0x20,
  0xFF, 0xAB, 0x07, 0x20, 0x64, 0xAA, 0x07, 0x20,
  0xFF, 0xA3, 0x07, 0x20, 0x63, 0xA2, 0x07, 0x20,
  0xFF, 0x9B, 0x07, 0x20, 0x62, 0x9A, 0x07, 0x20,
  0xFF, 0x93, 0x07, 0x20, 0x61, 0x92, 0x07, 0x20,
  0xFF, 0x8B, 0x07, 0x20, 0x60, 0x8A, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x00, 0x08, 0x00, 0x10, 0x03, 0x18, 0x1C,
  0x10, 0x03, 0x18, 0x1C, 0x03, 0x00, 0x09, 0x00,
  0x00, 0x20, 0x04, 0x30, 0x80, 0x00, 0x00, 0x00,
  0x04, 0x0C, 0x00, 0x01, 0x00, 0x02, 0x0D, 0x00,
  0x28, 0x00, 0x14, 0x00, 0x00, 0x38, 0x00, 0x00,
  0x6E, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x8F, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x0E, 0x00, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0F, 0x00,
  0x01, 0x00, 0x01, 0x10, 0x00, 0x01, 0x00, 0x02,
  0x11, 0x00, 0x02, 0x00, 0x60, 0x00, 0x12, 0x00,
  0x01, 0x00, 0x01, 0x05, 0x00, 0x0E, 0x00, 0x0C,
  0x20, 0xFD, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x08, 0x00, 0x00, 0x05, 0x00, 0x0E,
  0x00, 0x10, 0x20, 0xFD, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x03,
  0x00, 0x09, 0x00, 0x04, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x08, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x0C, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x10, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x14,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x18, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x44, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x48, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x4C, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x50, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x58, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC8,
  0x20, 0x04, 0x30, 0x04, 0x00, 0x00, 0x00, 0x04,
  0x15, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x20, 0x28, 0x00, 0x00,
};

static unsigned char vfs5011_init_09[] = { /* 2742 B */
  0x02, 0xB0, 0x00, 0x1C, 0x00, 0x03, 0x00, 0x09,
  0x00, 0x04, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x18, 0x20,
  0x04, 0x30, 0x01, 0x80, 0x4F, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x20, 0x04, 0x30, 0x08,
  0x00, 0x80, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x24, 0x20, 0x04, 0x30, 0x00, 0x00, 0xFF, 0x01,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x2C, 0x20, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x40, 0x20, 0x04, 0x30, 0xFF, 0x03,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x44,
  0x20, 0x04, 0x30, 0xE7, 0x03, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x48, 0x20, 0x04, 0x30,
  0xFF, 0x03, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x4C, 0x20, 0x04, 0x30, 0xFF, 0x03, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x20,
  0x04, 0x30, 0x00, 0x3E, 0x01, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x00, 0x21, 0x04, 0x30, 0x30,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x04, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x08, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x0C, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x14, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x18, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x1C, 0x21,
  0x04, 0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x40, 0x21, 0x04, 0x30, 0x30, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x44, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x48, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x4C,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x50, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x54, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x58, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x5C, 0x21, 0x04, 0x30, 0x1F,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x60, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x80, 0x21, 0x04,
  0x30, 0x30, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x84, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x88,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x8C, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x90, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x94, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x98, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x9C, 0x21, 0x04, 0x30, 0x1F, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xA0, 0x21, 0x04,
  0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xC0, 0x21, 0x04, 0x30, 0x30, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xC8, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xCC, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xD0, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xD4, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xD8, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xDC, 0x21, 0x04,
  0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xE0, 0x21, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xA0,
  0x20, 0x04, 0x30, 0xEF, 0xE1, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xA4, 0x20, 0x04, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xB0, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4, 0x20,
  0x04, 0x30, 0x14, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xC8, 0x20, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xCC, 0x20, 0x04, 0x30, 0x20, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x50, 0x20, 0x04,
  0x30, 0x00, 0x02, 0xA8, 0x02, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xA8, 0x20, 0x04, 0x30, 0xFE, 0x21,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x04,
  0x00, 0x00, 0x38, 0x00, 0x07, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x08, 0x00, 0x00, 0x38,
  0x00, 0x15, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x0C, 0x00, 0x00, 0x38, 0x01, 0x03, 0x02,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10, 0x00,
  0x00, 0x38, 0x01, 0x07, 0x02, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x14, 0x00, 0x00, 0x38, 0x0C,
  0x0C, 0x05, 0x00, 0x04, 0x02, 0x00, 0x80, 0x05,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x80, 0xF2, 0x07, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x00, 0x08, 0x00, 0x10, 0x03, 0x18, 0x1C,
  0x10, 0x03, 0x18, 0x1C, 0x03, 0x00, 0x09, 0x00,
  0x00, 0x20, 0x04, 0x30, 0x80, 0x00, 0x00, 0x00,
  0x04, 0x0C, 0x00, 0x01, 0x00, 0x00, 0x0D, 0x00,
  0x28, 0x00, 0xA0, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
  0x00, 0x00, 0xA0, 0x21, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x73, 0x00, 0x00, 0x10, 0x01, 0x00,
  0x00, 0x00, 0x0E, 0x00, 0xE0, 0x00, 0x00, 0x01,
  0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x01,
  0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x01,
  0x02, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x01,
  0x04, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x01,
  0x08, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x01,
  0x10, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x01,
  0x10, 0x01, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x01,
  0x10, 0x01, 0x04, 0x01, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x01,
  0x10, 0x01, 0x08, 0x01, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x01,
  0x10, 0x01, 0x10, 0x01, 0x02, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x01,
  0x10, 0x01, 0x10, 0x01, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x01,
  0x10, 0x01, 0x10, 0x01, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x0F, 0x00,
  0x01, 0x00, 0x01, 0x10, 0x00, 0x01, 0x00, 0x02,
  0x11, 0x00, 0x02, 0x00, 0x02, 0x00, 0x12, 0x00,
  0x01, 0x00, 0x0E, 0x05, 0x00, 0x0E, 0x00, 0x0C,
  0x20, 0xFD, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x08, 0x00, 0x00, 0x05, 0x00, 0x0E,
  0x00, 0x10, 0x20, 0xFD, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x03,
  0x00, 0x09, 0x00, 0x04, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x08, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x0C, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x10, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x14,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x18, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x44, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x48, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x4C, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x50, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x58, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC8,
  0x20, 0x04, 0x30, 0x04, 0x00, 0x00, 0x00, 0x04,
  0x05, 0x00, 0x0E, 0x00, 0x14, 0x20, 0xFF, 0xFF,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x83, 0x00, 0x15, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x20, 0x28, 0x00, 0x00,
};

static unsigned char vfs5011_init_10[] = { /* 2612 B */
  0x02, 0xB0, 0x00, 0x20, 0x00, 0x03, 0x00, 0x09,
  0x00, 0x04, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x18, 0x20,
  0x04, 0x30, 0x01, 0x80, 0x4F, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x20, 0x04, 0x30, 0x08,
  0x00, 0x80, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x24, 0x20, 0x04, 0x30, 0x00, 0x00, 0xFF, 0x01,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x2C, 0x20, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x40, 0x20, 0x04, 0x30, 0xFF, 0x03,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x44,
  0x20, 0x04, 0x30, 0xE7, 0x03, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x48, 0x20, 0x04, 0x30,
  0xFF, 0x03, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x4C, 0x20, 0x04, 0x30, 0xFF, 0x03, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x20,
  0x04, 0x30, 0x00, 0x3E, 0x01, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x00, 0x21, 0x04, 0x30, 0x30,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x04, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x08, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x0C, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10,
  0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x14, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x18, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x1C, 0x21,
  0x04, 0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x21, 0x04, 0x30, 0x04,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x40, 0x21, 0x04, 0x30, 0x30, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x44, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x48, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x4C,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x50, 0x21, 0x04, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x54, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x58, 0x21,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x5C, 0x21, 0x04, 0x30, 0x1F,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x60, 0x21, 0x04, 0x30, 0x04, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x80, 0x21, 0x04,
  0x30, 0x30, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x84, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x88,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x8C, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x90, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x94, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x98, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x9C, 0x21, 0x04, 0x30, 0x1F, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xA0, 0x21, 0x04,
  0x30, 0x04, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xC0, 0x21, 0x04, 0x30, 0x30, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xC8, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xCC, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xD0, 0x21,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xD4, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xD8, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xDC, 0x21, 0x04,
  0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xE0, 0x21, 0x04, 0x30, 0x04, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xA0,
  0x20, 0x04, 0x30, 0xEF, 0xE1, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xA4, 0x20, 0x04, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xB0, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4, 0x20,
  0x04, 0x30, 0x14, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xC8, 0x20, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xCC, 0x20, 0x04, 0x30, 0x20, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x50, 0x20, 0x04,
  0x30, 0x00, 0x02, 0xA8, 0x02, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xA8, 0x20, 0x04, 0x30, 0xFE, 0x21,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x04,
  0x00, 0x00, 0x38, 0x00, 0x07, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x08, 0x00, 0x00, 0x38,
  0x00, 0x15, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x0C, 0x00, 0x00, 0x38, 0x01, 0x03, 0x02,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10, 0x00,
  0x00, 0x38, 0x01, 0x07, 0x02, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x14, 0x00, 0x00, 0x38, 0x0C,
  0x0C, 0x05, 0x00, 0x04, 0x02, 0x00, 0x80, 0x05,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0xFF, 0xF3, 0x47, 0x20, 0x80, 0xF2, 0x47, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x00, 0x08, 0x00, 0x10, 0x03, 0x18, 0x1C,
  0x10, 0x03, 0x18, 0x1C, 0x03, 0x00, 0x09, 0x00,
  0x00, 0x20, 0x04, 0x30, 0x80, 0x00, 0x00, 0x00,
  0x04, 0x0C, 0x00, 0x01, 0x00, 0x01, 0x0D, 0x00,
  0x28, 0x00, 0xA0, 0x21, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0F, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x01, 0x00,
  0x00, 0x00, 0xA0, 0x21, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x1C, 0x02, 0xB0, 0x01, 0x00,
  0x00, 0x00, 0x0E, 0x00, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00,
  0x01, 0x00, 0x01, 0x10, 0x00, 0x01, 0x00, 0x02,
  0x11, 0x00, 0x02, 0x00, 0x20, 0x00, 0x12, 0x00,
  0x01, 0x00, 0x01, 0x05, 0x00, 0x0E, 0x00, 0x0C,
  0x20, 0xFD, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x08, 0x00, 0x00, 0x05, 0x00, 0x0E,
  0x00, 0x10, 0x20, 0xFD, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x03,
  0x00, 0x09, 0x00, 0x04, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x08, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x0C, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x10, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x14,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x18, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x44, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x48, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x4C, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x50, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x58, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC8,
  0x20, 0x04, 0x30, 0x04, 0x00, 0x00, 0x00, 0x04,
  0x05, 0x00, 0x0E, 0x00, 0x14, 0x20, 0xFF, 0xFF,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x83, 0x00, 0x03, 0x00, 0x09, 0x00, 0x84, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x88, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x8C, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x90, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x94, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x98,
  0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x15, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x20, 0x28, 0x00, 0x00,
};

static unsigned char vfs5011_init_11[] = { /* 2625 B */
  0x02, 0xB0, 0x00, 0x20, 0x00, 0x03, 0x00, 0x09,
  0x00, 0x04, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x18, 0x20,
  0x04, 0x30, 0x01, 0x80, 0x4F, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x20, 0x04, 0x30, 0x08,
  0x00, 0x80, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x24, 0x20, 0x04, 0x30, 0x00, 0x00, 0xFF, 0x01,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x2C, 0x20, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x40, 0x20, 0x04, 0x30, 0xFF, 0x03,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x44,
  0x20, 0x04, 0x30, 0xE6, 0x03, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x48, 0x20, 0x04, 0x30,
  0xE7, 0x03, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x4C, 0x20, 0x04, 0x30, 0xE8, 0x03, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x20,
  0x04, 0x30, 0x00, 0x3E, 0x01, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x00, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x04, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x08, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x0C, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x14, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x18, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x1C, 0x21,
  0x04, 0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x21, 0x04, 0x30, 0x08,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x40, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x44, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x48, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x4C,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x50, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x54, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x58, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x5C, 0x21, 0x04, 0x30, 0x1F,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x60, 0x21, 0x04, 0x30, 0x08, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x80, 0x21, 0x04,
  0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x84, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x88,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x8C, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x90, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x94, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x98, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x9C, 0x21, 0x04, 0x30, 0x1F, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xA0, 0x21, 0x04,
  0x30, 0x08, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xC0, 0x21, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xC8, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xCC, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xD0, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xD4, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xD8, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xDC, 0x21, 0x04,
  0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xE0, 0x21, 0x04, 0x30, 0x08, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xA0,
  0x20, 0x04, 0x30, 0xEF, 0xE1, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xA4, 0x20, 0x04, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xB0, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4, 0x20,
  0x04, 0x30, 0x14, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xC8, 0x20, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xCC, 0x20, 0x04, 0x30, 0x20, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x50, 0x20, 0x04,
  0x30, 0x00, 0x02, 0xA8, 0x02, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xA8, 0x20, 0x04, 0x30, 0xFE, 0x21,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x04,
  0x00, 0x00, 0x38, 0x00, 0x07, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x08, 0x00, 0x00, 0x38,
  0x00, 0x15, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x0C, 0x00, 0x00, 0x38, 0x01, 0x03, 0x02,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10, 0x00,
  0x00, 0x38, 0x01, 0x07, 0x02, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x14, 0x00, 0x00, 0x38, 0x0C,
  0x0C, 0x05, 0x00, 0x04, 0x02, 0x00, 0x80, 0x05,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0xFF, 0x8B, 0x07, 0x20, 0x60, 0x8A, 0x07, 0x20,
  0xFF, 0x93, 0x07, 0x20, 0x61, 0x92, 0x07, 0x20,
  0xFF, 0x9B, 0x07, 0x20, 0x62, 0x9A, 0x07, 0x20,
  0xFF, 0xA3, 0x07, 0x20, 0x63, 0xA2, 0x07, 0x20,
  0xFF, 0xAB, 0x07, 0x20, 0x64, 0xAA, 0x07, 0x20,
  0xFF, 0xB3, 0x07, 0x20, 0x65, 0xB2, 0x07, 0x20,
  0xFF, 0xBB, 0x07, 0x20, 0x66, 0xBA, 0x07, 0x20,
  0xFF, 0xC3, 0x07, 0x20, 0x67, 0xC2, 0x07, 0x20,
  0xFF, 0xCB, 0x07, 0x20, 0x68, 0xCA, 0x07, 0x20,
  0xFF, 0xD3, 0x07, 0x20, 0x69, 0xD2, 0x07, 0x20,
  0xFF, 0xDB, 0x07, 0x20, 0x6A, 0xDA, 0x07, 0x20,
  0xFF, 0xE3, 0x07, 0x20, 0x6B, 0xE2, 0x07, 0x20,
  0xFF, 0xEB, 0x07, 0x20, 0x6C, 0xEA, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x6D, 0xF2, 0x07, 0x20,
  0xFF, 0xFB, 0x07, 0x20, 0x6E, 0xFA, 0x07, 0x20,
  0xFF, 0x85, 0x07, 0x20, 0x6F, 0x84, 0x07, 0x20,
  0xFF, 0x8D, 0x07, 0x20, 0x70, 0x8C, 0x07, 0x20,
  0xFF, 0x95, 0x07, 0x20, 0x71, 0x94, 0x07, 0x20,
  0xFF, 0x9D, 0x07, 0x20, 0x72, 0x9C, 0x07, 0x20,
  0xFF, 0xA5, 0x07, 0x20, 0x73, 0xA4, 0x07, 0x20,
  0xFF, 0xAD, 0x07, 0x20, 0x74, 0xAC, 0x07, 0x20,
  0xFF, 0xB5, 0x07, 0x20, 0x75, 0xB4, 0x07, 0x20,
  0xFF, 0xBD, 0x07, 0x20, 0x76, 0xBC, 0x07, 0x20,
  0xFF, 0xC5, 0x07, 0x20, 0x77, 0xC4, 0x07, 0x20,
  0xFF, 0xCD, 0x07, 0x20, 0x78, 0xCC, 0x07, 0x20,
  0xFF, 0xD5, 0x07, 0x20, 0x79, 0xD4, 0x07, 0x20,
  0xFF, 0xDD, 0x07, 0x20, 0x7A, 0xDC, 0x07, 0x20,
  0xFF, 0xE5, 0x07, 0x20, 0x7B, 0xE4, 0x07, 0x20,
  0xFF, 0xED, 0x07, 0x20, 0x7C, 0xEC, 0x07, 0x20,
  0xFF, 0xF5, 0x07, 0x20, 0x7D, 0xF4, 0x07, 0x20,
  0xFF, 0xFD, 0x07, 0x20, 0x7E, 0xFC, 0x07, 0x20,
  0xFF, 0x87, 0x07, 0x20, 0x7F, 0x86, 0x07, 0x20,
  0xFF, 0x8F, 0x07, 0x20, 0x80, 0x8E, 0x07, 0x20,
  0xFF, 0x97, 0x07, 0x20, 0x81, 0x96, 0x07, 0x20,
  0xFF, 0x9F, 0x07, 0x20, 0x82, 0x9E, 0x07, 0x20,
  0xFF, 0xA7, 0x07, 0x20, 0x83, 0xA6, 0x07, 0x20,
  0xFF, 0xAF, 0x07, 0x20, 0x84, 0xAE, 0x07, 0x20,
  0xFF, 0xB7, 0x07, 0x20, 0x85, 0xB6, 0x07, 0x20,
  0xFF, 0xBF, 0x07, 0x20, 0x86, 0xBE, 0x07, 0x20,
  0xFF, 0xC7, 0x07, 0x20, 0x87, 0xC6, 0x07, 0x20,
  0xFF, 0xCF, 0x07, 0x20, 0x88, 0xCE, 0x07, 0x20,
  0xFF, 0xD7, 0x07, 0x20, 0x89, 0xD6, 0x07, 0x20,
  0xFF, 0xDF, 0x07, 0x20, 0x8A, 0xDE, 0x07, 0x20,
  0xFF, 0xE7, 0x07, 0x20, 0x8B, 0xE6, 0x07, 0x20,
  0xFF, 0xEF, 0x07, 0x20, 0x8C, 0xEE, 0x07, 0x20,
  0xFF, 0xF7, 0x07, 0x20, 0x8D, 0xF6, 0x07, 0x20,
  0xFF, 0xFF, 0x07, 0x20, 0x8E, 0xFE, 0x07, 0x20,
  0xFF, 0xFF, 0x07, 0x20, 0x8E, 0xFE, 0x07, 0x20,
  0xFF, 0xF7, 0x07, 0x20, 0x8D, 0xF6, 0x07, 0x20,
  0xFF, 0xEF, 0x07, 0x20, 0x8C, 0xEE, 0x07, 0x20,
  0xFF, 0xE7, 0x07, 0x20, 0x8B, 0xE6, 0x07, 0x20,
  0xFF, 0xDF, 0x07, 0x20, 0x8A, 0xDE, 0x07, 0x20,
  0xFF, 0xD7, 0x07, 0x20, 0x89, 0xD6, 0x07, 0x20,
  0xFF, 0xCF, 0x07, 0x20, 0x88, 0xCE, 0x07, 0x20,
  0xFF, 0xC7, 0x07, 0x20, 0x87, 0xC6, 0x07, 0x20,
  0xFF, 0xBF, 0x07, 0x20, 0x86, 0xBE, 0x07, 0x20,
  0xFF, 0xB7, 0x07, 0x20, 0x85, 0xB6, 0x07, 0x20,
  0xFF, 0xAF, 0x07, 0x20, 0x84, 0xAE, 0x07, 0x20,
  0xFF, 0xA7, 0x07, 0x20, 0x83, 0xA6, 0x07, 0x20,
  0xFF, 0x9F, 0x07, 0x20, 0x82, 0x9E, 0x07, 0x20,
  0xFF, 0x97, 0x07, 0x20, 0x81, 0x96, 0x07, 0x20,
  0xFF, 0x8F, 0x07, 0x20, 0x80, 0x8E, 0x07, 0x20,
  0xFF, 0x87, 0x07, 0x20, 0x7F, 0x86, 0x07, 0x20,
  0xFF, 0xFD, 0x07, 0x20, 0x7E, 0xFC, 0x07, 0x20,
  0xFF, 0xF5, 0x07, 0x20, 0x7D, 0xF4, 0x07, 0x20,
  0xFF, 0xED, 0x07, 0x20, 0x7C, 0xEC, 0x07, 0x20,
  0xFF, 0xE5, 0x07, 0x20, 0x7B, 0xE4, 0x07, 0x20,
  0xFF, 0xDD, 0x07, 0x20, 0x7A, 0xDC, 0x07, 0x20,
  0xFF, 0xD5, 0x07, 0x20, 0x79, 0xD4, 0x07, 0x20,
  0xFF, 0xCD, 0x07, 0x20, 0x78, 0xCC, 0x07, 0x20,
  0xFF, 0xC5, 0x07, 0x20, 0x77, 0xC4, 0x07, 0x20,
  0xFF, 0xBD, 0x07, 0x20, 0x76, 0xBC, 0x07, 0x20,
  0xFF, 0xB5, 0x07, 0x20, 0x75, 0xB4, 0x07, 0x20,
  0xFF, 0xAD, 0x07, 0x20, 0x74, 0xAC, 0x07, 0x20,
  0xFF, 0xA5, 0x07, 0x20, 0x73, 0xA4, 0x07, 0x20,
  0xFF, 0x9D, 0x07, 0x20, 0x72, 0x9C, 0x07, 0x20,
  0xFF, 0x95, 0x07, 0x20, 0x71, 0x94, 0x07, 0x20,
  0xFF, 0x8D, 0x07, 0x20, 0x70, 0x8C, 0x07, 0x20,
  0xFF, 0x85, 0x07, 0x20, 0x6F, 0x84, 0x07, 0x20,
  0xFF, 0xFB, 0x07, 0x20, 0x6E, 0xFA, 0x07, 0x20,
  0xFF, 0xF3, 0x07, 0x20, 0x6D, 0xF2, 0x07, 0x20,
  0xFF, 0xEB, 0x07, 0x20, 0x6C, 0xEA, 0x07, 0x20,
  0xFF, 0xE3, 0x07, 0x20, 0x6B, 0xE2, 0x07, 0x20,
  0xFF, 0xDB, 0x07, 0x20, 0x6A, 0xDA, 0x07, 0x20,
  0xFF, 0xD3, 0x07, 0x20, 0x69, 0xD2, 0x07, 0x20,
  0xFF, 0xCB, 0x07, 0x20, 0x68, 0xCA, 0x07, 0x20,
  0xFF, 0xC3, 0x07, 0x20, 0x67, 0xC2, 0x07, 0x20,
  0xFF, 0xBB, 0x07, 0x20, 0x66, 0xBA, 0x07, 0x20,
  0xFF, 0xB3, 0x07, 0x20, 0x65, 0xB2, 0x07, 0x20,
  0xFF, 0xAB, 0x07, 0x20, 0x64, 0xAA, 0x07, 0x20,
  0xFF, 0xA3, 0x07, 0x20, 0x63, 0xA2, 0x07, 0x20,
  0xFF, 0x9B, 0x07, 0x20, 0x62, 0x9A, 0x07, 0x20,
  0xFF, 0x93, 0x07, 0x20, 0x61, 0x92, 0x07, 0x20,
  0xFF, 0x8B, 0x07, 0x20, 0x60, 0x8A, 0x07, 0x20,
  0xFF, 0x83, 0x07, 0x20, 0x5F, 0x82, 0x07, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x00, 0x08, 0x00, 0x10, 0x03, 0x18, 0x1C,
  0x10, 0x03, 0x18, 0x1C, 0x03, 0x00, 0x09, 0x00,
  0x00, 0x20, 0x04, 0x30, 0x80, 0x00, 0x00, 0x00,
  0x04, 0x0C, 0x00, 0x01, 0x00, 0x01, 0x0D, 0x00,
  0x28, 0x00, 0x20, 0x21, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0F, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x01, 0x00,
  0x00, 0x00, 0x20, 0x21, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x1C, 0x02, 0xB0, 0x01, 0x00,
  0x00, 0x00, 0x0E, 0x00, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0F, 0x00,
  0x01, 0x00, 0x01, 0x10, 0x00, 0x01, 0x00, 0x02,
  0x11, 0x00, 0x02, 0x00, 0x20, 0x00, 0x12, 0x00,
  0x01, 0x00, 0x01, 0x05, 0x00, 0x0E, 0x00, 0x0C,
  0x20, 0xFD, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x08, 0x00, 0x00, 0x05, 0x00, 0x0E,
  0x00, 0x10, 0x20, 0xFD, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x03,
  0x00, 0x09, 0x00, 0x04, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x08, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x0C, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x10, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x14,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x18, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x44, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x48, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x4C, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x50, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x58, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC8,
  0x20, 0x04, 0x30, 0x04, 0x00, 0x00, 0x00, 0x04,
  0x05, 0x00, 0x0E, 0x00, 0x14, 0x20, 0xFF, 0xFF,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x83, 0x00, 0x03, 0x00, 0x09, 0x00, 0x84, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x88, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x8C, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x90, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x94, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x98,
  0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xA0, 0x21, 0x04, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x00, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x28, 0x00,
  0x00,
};

static unsigned char vfs5011_init_12[] = { /* 2666 B */
  0x02, 0xF0, 0x00, 0x0E, 0x00, 0x03, 0x00, 0x09,
  0x00, 0x04, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x18, 0x20,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x20, 0x04, 0x30, 0x08,
  0x00, 0x80, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x24, 0x20, 0x04, 0x30, 0x00, 0x00, 0xFF, 0x01,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x2C, 0x20, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x40, 0x20, 0x04, 0x30, 0xFF, 0x03,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x44,
  0x20, 0x04, 0x30, 0xE5, 0x03, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x48, 0x20, 0x04, 0x30,
  0xEA, 0x03, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x4C, 0x20, 0x04, 0x30, 0x0A, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x20,
  0x04, 0x30, 0x01, 0xDE, 0x01, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x00, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x04, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x08, 0x21, 0x04,
  0x30, 0x02, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x0C, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x14, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x18, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x1C, 0x21,
  0x04, 0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x21, 0x04, 0x30, 0x08,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x40, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x44, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x48, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x4C,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x50, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x54, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x58, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x5C, 0x21, 0x04, 0x30, 0x1F,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x60, 0x21, 0x04, 0x30, 0x08, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x80, 0x21, 0x04,
  0x30, 0x30, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x84, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x88,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x8C, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x90, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x94, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x98, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x9C, 0x21, 0x04, 0x30, 0x1F, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xA0, 0x21, 0x04,
  0x30, 0x04, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xC0, 0x21, 0x04, 0x30, 0x30, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xC8, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xCC, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xD0, 0x21,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xD4, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xD8, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xDC, 0x21, 0x04,
  0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xE0, 0x21, 0x04, 0x30, 0x04, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xA0,
  0x20, 0x04, 0x30, 0xEF, 0xE1, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xA4, 0x20, 0x04, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xB0, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4, 0x20,
  0x04, 0x30, 0x14, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xC8, 0x20, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xCC, 0x20, 0x04, 0x30, 0x20, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x50, 0x20, 0x04,
  0x30, 0x00, 0x00, 0x74, 0x01, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xA8, 0x20, 0x04, 0x30, 0xFE, 0x21,
  0x74, 0x01, 0x04, 0x03, 0x00, 0x09, 0x00, 0x04,
  0x00, 0x00, 0x38, 0x00, 0x07, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x08, 0x00, 0x00, 0x38,
  0x00, 0x15, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x0C, 0x00, 0x00, 0x38, 0x01, 0x03, 0x02,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10, 0x00,
  0x00, 0x38, 0x01, 0x07, 0x02, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x14, 0x00, 0x00, 0x38, 0x0C,
  0x0C, 0x05, 0x00, 0x04, 0x02, 0x00, 0x80, 0x05,
  0xFF, 0xF9, 0x87, 0x20, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x07, 0x20,
  0xBA, 0xF8, 0x07, 0x20, 0xB9, 0xF8, 0x07, 0x20,
  0xB8, 0xF8, 0x07, 0x20, 0xB7, 0xF8, 0x07, 0x20,
  0xB6, 0xF8, 0x07, 0x20, 0xB5, 0xF8, 0x07, 0x20,
  0xB4, 0xF8, 0x07, 0x20, 0xB3, 0xF8, 0x07, 0x20,
  0xB2, 0xF8, 0x07, 0x20, 0xB1, 0xF8, 0x07, 0x22,
  0xB0, 0xF8, 0x07, 0x22, 0xAF, 0xF8, 0x07, 0x22,
  0xAE, 0xF8, 0x07, 0x22, 0xAD, 0xF8, 0x07, 0x22,
  0xAC, 0xF8, 0x07, 0x22, 0xAB, 0xF8, 0x07, 0x22,
  0xAA, 0xF8, 0x07, 0x22, 0xA9, 0xF8, 0x07, 0x22,
  0xA8, 0xF8, 0x07, 0x22, 0xA7, 0xF8, 0x07, 0x22,
  0xA6, 0xF8, 0x07, 0x22, 0xA5, 0xF8, 0x07, 0x22,
  0xA4, 0xF8, 0x07, 0x22, 0xA3, 0xF8, 0x07, 0x22,
  0xA2, 0xF8, 0x07, 0x22, 0xA1, 0xF8, 0x07, 0x22,
  0xA0, 0xF8, 0x07, 0x22, 0x9F, 0xF8, 0x07, 0x22,
  0x9E, 0xF8, 0x07, 0x22, 0x9D, 0xF8, 0x07, 0x22,
  0x9C, 0xF8, 0x07, 0x22, 0x9B, 0xF8, 0x07, 0x22,
  0x9A, 0xF8, 0x07, 0x22, 0x99, 0xF8, 0x07, 0x22,
  0x98, 0xF8, 0x07, 0x22, 0x97, 0xF8, 0x07, 0x22,
  0x96, 0xF8, 0x07, 0x22, 0x95, 0xF8, 0x07, 0x22,
  0x94, 0xF8, 0x07, 0x22, 0x93, 0xF8, 0x07, 0x22,
  0x92, 0xF8, 0x07, 0x22, 0x91, 0xF8, 0x07, 0x22,
  0x90, 0xF8, 0x07, 0x22, 0x8F, 0xF8, 0x07, 0x22,
  0x8E, 0xF8, 0x07, 0x22, 0x8D, 0xF8, 0x07, 0x22,
  0x8C, 0xF8, 0x07, 0x22, 0x8B, 0xF8, 0x07, 0x22,
  0x8A, 0xF8, 0x07, 0x22, 0x89, 0xF8, 0x07, 0x22,
  0x88, 0xF8, 0x07, 0x22, 0x87, 0xF8, 0x07, 0x22,
  0x86, 0xF8, 0x07, 0x22, 0x85, 0xF8, 0x07, 0x22,
  0x84, 0xF8, 0x07, 0x22, 0x83, 0xF8, 0x07, 0x22,
  0x82, 0xF8, 0x07, 0x22, 0x81, 0xF8, 0x07, 0x22,
  0x80, 0xF8, 0x07, 0x22, 0x7F, 0xF8, 0x07, 0x22,
  0x7E, 0xF8, 0x07, 0x22, 0x7D, 0xF8, 0x07, 0x22,
  0x7C, 0xF8, 0x07, 0x22, 0x7B, 0xF8, 0x07, 0x22,
  0x7A, 0xF8, 0x07, 0x22, 0x79, 0xF8, 0x07, 0x22,
  0x78, 0xF8, 0x07, 0x22, 0x77, 0xF8, 0x07, 0x22,
  0x76, 0xF8, 0x07, 0x22, 0x75, 0xF8, 0x07, 0x22,
  0x74, 0xF8, 0x07, 0x22, 0x73, 0xF8, 0x07, 0x22,
  0x72, 0xF8, 0x07, 0x22, 0x71, 0xF8, 0x07, 0x22,
  0x70, 0xF8, 0x07, 0x22, 0x6F, 0xF8, 0x07, 0x22,
  0x6E, 0xF8, 0x07, 0x22, 0x6D, 0xF8, 0x07, 0x22,
  0x6C, 0xF8, 0x07, 0x22, 0x6B, 0xF8, 0x07, 0x22,
  0x6A, 0xF8, 0x07, 0x22, 0x69, 0xF8, 0x07, 0x22,
  0x68, 0xF8, 0x07, 0x22, 0x67, 0xF8, 0x07, 0x22,
  0x66, 0xF8, 0x07, 0x22, 0x65, 0xF8, 0x07, 0x22,
  0x64, 0xF8, 0x07, 0x22, 0x63, 0xF8, 0x07, 0x22,
  0x62, 0xF8, 0x07, 0x22, 0x61, 0xF8, 0x07, 0x22,
  0x60, 0xF8, 0x07, 0x22, 0x5F, 0xF8, 0x07, 0x22,
  0x5E, 0xF8, 0x07, 0x22, 0x5D, 0xF8, 0x07, 0x22,
  0x5C, 0xF8, 0x07, 0x22, 0x5B, 0xF8, 0x07, 0x22,
  0x5A, 0xF8, 0x07, 0x22, 0x59, 0xF8, 0x07, 0x22,
  0x58, 0xF8, 0x07, 0x22, 0x57, 0xF8, 0x07, 0x22,
  0x56, 0xF8, 0x07, 0x22, 0x55, 0xF8, 0x07, 0x22,
  0x54, 0xF8, 0x07, 0x22, 0x53, 0xF8, 0x07, 0x22,
  0x52, 0xF8, 0x07, 0x22, 0x51, 0xF8, 0x07, 0x22,
  0x50, 0xF8, 0x07, 0x22, 0x4F, 0xF8, 0x07, 0x22,
  0x4E, 0xF8, 0x07, 0x22, 0x4D, 0xF8, 0x07, 0x22,
  0x4C, 0xF8, 0x07, 0x22, 0x4B, 0xF8, 0x07, 0x22,
  0x4A, 0xF8, 0x07, 0x22, 0x49, 0xF8, 0x07, 0x22,
  0x48, 0xF8, 0x07, 0x22, 0x47, 0xF8, 0x07, 0x22,
  0x46, 0xF8, 0x07, 0x22, 0x45, 0xF8, 0x07, 0x22,
  0x44, 0xF8, 0x07, 0x22, 0x43, 0xF8, 0x07, 0x22,
  0x42, 0xF8, 0x07, 0x22, 0x41, 0xF8, 0x07, 0x22,
  0x40, 0xF8, 0x07, 0x22, 0x3F, 0xF8, 0x07, 0x22,
  0x3E, 0xF8, 0x07, 0x22, 0x3D, 0xF8, 0x07, 0x22,
  0x3C, 0xF8, 0x07, 0x22, 0x3B, 0xF8, 0x07, 0x22,
  0x3A, 0xF8, 0x07, 0x22, 0x39, 0xF8, 0x07, 0x22,
  0x38, 0xF8, 0x07, 0x22, 0x37, 0xF8, 0x07, 0x22,
  0x36, 0xF8, 0x07, 0x22, 0x35, 0xF8, 0x07, 0x22,
  0x34, 0xF8, 0x07, 0x22, 0x33, 0xF8, 0x07, 0x22,
  0x32, 0xF8, 0x07, 0x22, 0x31, 0xF8, 0x07, 0x22,
  0x30, 0xF8, 0x07, 0x22, 0x2F, 0xF8, 0x07, 0x22,
  0x2E, 0xF8, 0x07, 0x22, 0x2D, 0xF8, 0x07, 0x22,
  0x2C, 0xF8, 0x07, 0x22, 0x2B, 0xF8, 0x07, 0x22,
  0x2A, 0xF8, 0x07, 0x22, 0x29, 0xF8, 0x07, 0x22,
  0x28, 0xF8, 0x07, 0x22, 0x27, 0xF8, 0x07, 0x22,
  0x26, 0xF8, 0x07, 0x22, 0x25, 0xF8, 0x07, 0x22,
  0x24, 0xF8, 0x07, 0x22, 0x23, 0xF8, 0x07, 0x20,
  0x22, 0xF8, 0x07, 0x20, 0x21, 0xF8, 0x07, 0x20,
  0x20, 0xF8, 0x07, 0x20, 0x1F, 0xF8, 0x07, 0x20,
  0x1E, 0xF8, 0x07, 0x20, 0x1D, 0xF8, 0x07, 0x20,
  0x1C, 0xF8, 0x07, 0x20, 0x1C, 0xF8, 0x07, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD8, 0xF8, 0x27, 0x20, 0xD9, 0xF8, 0x27, 0x20,
  0xDA, 0xF8, 0x27, 0x20, 0xDB, 0xF8, 0x27, 0x20,
  0xDC, 0xF8, 0x27, 0x20, 0xDD, 0xF8, 0x27, 0x20,
  0xDE, 0xF8, 0x27, 0x20, 0xDF, 0xF8, 0x27, 0x20,
  0xE0, 0xF8, 0x27, 0x20, 0xE1, 0xF8, 0x27, 0x20,
  0xE2, 0xF8, 0x27, 0x20, 0xE3, 0xF8, 0x27, 0x20,
  0xE4, 0xF8, 0x27, 0x20, 0xE5, 0xF8, 0x27, 0x20,
  0xE6, 0xF8, 0x27, 0x20, 0xE7, 0xF8, 0x27, 0x20,
  0xE8, 0xF8, 0x27, 0x20, 0xE9, 0xF8, 0x27, 0x20,
  0xEA, 0xF8, 0x27, 0x20, 0xEB, 0xF8, 0x27, 0x20,
  0xEC, 0xF8, 0x27, 0x20, 0xED, 0xF8, 0x27, 0x20,
  0xEE, 0xF8, 0x27, 0x20, 0xEF, 0xF8, 0x27, 0x20,
  0xF0, 0xF8, 0x27, 0x20, 0xF1, 0xF8, 0x27, 0x20,
  0xF2, 0xF8, 0x27, 0x20, 0xF3, 0xF8, 0x27, 0x20,
  0xF4, 0xF8, 0x27, 0x20, 0xF5, 0xF8, 0x27, 0x20,
  0xF6, 0xF8, 0x27, 0x20, 0xF7, 0xF8, 0x27, 0x20,
  0xF8, 0xF8, 0x27, 0x20, 0xF9, 0xF8, 0x27, 0x20,
  0xFA, 0xF8, 0x27, 0x20, 0xFB, 0xF8, 0x27, 0x20,
  0xFC, 0xF8, 0x27, 0x20, 0xFD, 0xF8, 0x27, 0x20,
  0xFE, 0xF8, 0x27, 0x20, 0xFF, 0xF8, 0x27, 0x20,
  0x00, 0xF9, 0x27, 0x20, 0xD7, 0xF8, 0x27, 0x20,
  0x00, 0xF8, 0x27, 0x20, 0x01, 0xF8, 0x27, 0x20,
  0x02, 0xF8, 0x27, 0x20, 0x03, 0xF8, 0x27, 0x20,
  0x04, 0xF8, 0x27, 0x20, 0x05, 0xF8, 0x27, 0x20,
  0x06, 0xF8, 0x27, 0x20, 0x07, 0xF8, 0x27, 0x20,
  0x08, 0xF8, 0x27, 0x20, 0x09, 0xF8, 0x27, 0x20,
  0x0A, 0xF8, 0x27, 0x20, 0x0B, 0xF8, 0x27, 0x20,
  0x0C, 0xF8, 0x27, 0x20, 0x0D, 0xF8, 0x27, 0x20,
  0x0E, 0xF8, 0x27, 0x20, 0x0F, 0xF8, 0x27, 0x20,
  0x10, 0xF8, 0x27, 0x20, 0x11, 0xF8, 0x27, 0x20,
  0x12, 0xF8, 0x27, 0x20, 0x13, 0xF8, 0x27, 0x20,
  0x14, 0xF8, 0x27, 0x20, 0x15, 0xF8, 0x27, 0x20,
  0x15, 0xF8, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x00, 0x08, 0x00, 0x10, 0x03, 0x18, 0x1C,
  0x10, 0x03, 0x18, 0x1C, 0x03, 0x00, 0x09, 0x00,
  0x00, 0x20, 0x04, 0x30, 0x80, 0x00, 0x00, 0x00,
  0x04, 0x0C, 0x00, 0x01, 0x00, 0x04, 0x11, 0x00,
  0x02, 0x00, 0x0E, 0x00, 0x13, 0x00, 0x04, 0x00,
  0x18, 0x00, 0x00, 0x00, 0x14, 0x00, 0x04, 0x00,
  0x1E, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x0A, 0x00,
  0x08, 0x00, 0xA8, 0x00, 0xE6, 0x82, 0xA0, 0x0A,
  0x26, 0x06, 0x07, 0x00, 0x3C, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0xFF, 0xFF, 0x78, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x18, 0xA2, 0x55, 0x03, 0xD3, 0xA2,
  0x5D, 0x00, 0x18, 0xA2, 0x55, 0x03, 0xD3, 0xA2,
  0x5D, 0x00, 0x18, 0xA2, 0x55, 0x03, 0x20, 0x80,
  0x80, 0x00, 0xFF, 0x10, 0x0F, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x03,
  0x00, 0x00, 0x05, 0x00, 0x0E, 0x00, 0x0C, 0x20,
  0xFD, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x08, 0x00, 0x00, 0x05, 0x00, 0x0E, 0x00,
  0x10, 0x20, 0xFD, 0x00, 0xFF, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x03, 0x00,
  0x09, 0x00, 0x04, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x08,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x0C, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x10, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x14, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x18, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x44, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x48, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x4C, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x50,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x54, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x58, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC8, 0x20,
  0x04, 0x30, 0x04, 0x00, 0x00, 0x00, 0x04, 0x05,
  0x00, 0x0E, 0x00, 0x14, 0x20, 0xFF, 0xFF, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83,
  0x00, 0x03, 0x00, 0x09, 0x00, 0x84, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x88, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x8C,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x90, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x94, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x98, 0x21,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xA0, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x20, 0x21, 0x04, 0x30, 0x08, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x60, 0x21, 0x04,
  0x30, 0x08, 0x00, 0x00, 0x00, 0x04, 0x15, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x28,
  0x00, 0x00,
};

static unsigned char vfs5011_init_13[] = { /* 57 B */
  0x12, 0x90, 0x02, 0x00, 0x00, 0xFE, 0x03, 0x00,
  0x00, 0xFF, 0x1F, 0xFF, 0x1F, 0x00, 0x00, 0x00,
  0x00, 0x18, 0xA2, 0x55, 0x03, 0xD3, 0xA2, 0x5D,
  0x00, 0x18, 0xA2, 0x55, 0x03, 0xD3, 0xA2, 0x5D,
  0x00, 0x18, 0xA2, 0x55, 0x03, 0x20, 0xFF, 0x80,
  0x00, 0xFF, 0x04, 0x0F, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x03, 0x00,
  0x00,
};

static unsigned char vfs5011_init_14[] = { /* 2561 B */
  0x02, 0xF0, 0x00, 0x14, 0x00, 0x03, 0x00, 0x09,
  0x00, 0x04, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x18, 0x20,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x20, 0x04, 0x30, 0x08,
  0x00, 0x80, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x24, 0x20, 0x04, 0x30, 0x00, 0x00, 0xFF, 0x01,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x2C, 0x20, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x40, 0x20, 0x04, 0x30, 0xFF, 0x03,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x44,
  0x20, 0x04, 0x30, 0xE5, 0x03, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x48, 0x20, 0x04, 0x30,
  0xEA, 0x03, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x4C, 0x20, 0x04, 0x30, 0x0A, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x20,
  0x04, 0x30, 0x01, 0xDE, 0x01, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x00, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x04, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x08, 0x21, 0x04,
  0x30, 0x02, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x0C, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x14, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x18, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x1C, 0x21,
  0x04, 0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x21, 0x04, 0x30, 0x08,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x40, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x44, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x48, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x4C,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x50, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x54, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x58, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x5C, 0x21, 0x04, 0x30, 0x1F,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x60, 0x21, 0x04, 0x30, 0x08, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x80, 0x21, 0x04,
  0x30, 0x30, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x84, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x88,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x8C, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x90, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x94, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x98, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x9C, 0x21, 0x04, 0x30, 0x1F, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xA0, 0x21, 0x04,
  0x30, 0x04, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xC0, 0x21, 0x04, 0x30, 0x30, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xC8, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xCC, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xD0, 0x21,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xD4, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xD8, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xDC, 0x21, 0x04,
  0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xE0, 0x21, 0x04, 0x30, 0x04, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xA0,
  0x20, 0x04, 0x30, 0xEF, 0xE1, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xA4, 0x20, 0x04, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xB0, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4, 0x20,
  0x04, 0x30, 0x14, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xC8, 0x20, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xCC, 0x20, 0x04, 0x30, 0x20, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x50, 0x20, 0x04,
  0x30, 0x00, 0x00, 0x74, 0x01, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xA8, 0x20, 0x04, 0x30, 0xFE, 0x21,
  0x74, 0x01, 0x04, 0x03, 0x00, 0x09, 0x00, 0x04,
  0x00, 0x00, 0x38, 0x00, 0x07, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x08, 0x00, 0x00, 0x38,
  0x00, 0x15, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x0C, 0x00, 0x00, 0x38, 0x01, 0x03, 0x02,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10, 0x00,
  0x00, 0x38, 0x01, 0x07, 0x02, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x14, 0x00, 0x00, 0x38, 0x0C,
  0x0C, 0x05, 0x00, 0x04, 0x02, 0x00, 0x80, 0x05,
  0xFF, 0xF9, 0x87, 0x20, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x07, 0x20,
  0xBA, 0xF8, 0x07, 0x20, 0xB9, 0xF8, 0x07, 0x20,
  0xB8, 0xF8, 0x07, 0x20, 0xB7, 0xF8, 0x07, 0x20,
  0xB6, 0xF8, 0x07, 0x20, 0xB5, 0xF8, 0x07, 0x20,
  0xB4, 0xF8, 0x07, 0x20, 0xB3, 0xF8, 0x07, 0x20,
  0xB2, 0xF8, 0x07, 0x20, 0xB1, 0xF8, 0x07, 0x22,
  0xB0, 0xF8, 0x07, 0x22, 0xAF, 0xF8, 0x07, 0x22,
  0xAE, 0xF8, 0x07, 0x22, 0xAD, 0xF8, 0x07, 0x22,
  0xAC, 0xF8, 0x07, 0x22, 0xAB, 0xF8, 0x07, 0x22,
  0xAA, 0xF8, 0x07, 0x22, 0xA9, 0xF8, 0x07, 0x22,
  0xA8, 0xF8, 0x07, 0x22, 0xA7, 0xF8, 0x07, 0x22,
  0xA6, 0xF8, 0x07, 0x22, 0xA5, 0xF8, 0x07, 0x22,
  0xA4, 0xF8, 0x07, 0x22, 0xA3, 0xF8, 0x07, 0x22,
  0xA2, 0xF8, 0x07, 0x22, 0xA1, 0xF8, 0x07, 0x22,
  0xA0, 0xF8, 0x07, 0x22, 0x9F, 0xF8, 0x07, 0x22,
  0x9E, 0xF8, 0x07, 0x22, 0x9D, 0xF8, 0x07, 0x22,
  0x9C, 0xF8, 0x07, 0x22, 0x9B, 0xF8, 0x07, 0x22,
  0x9A, 0xF8, 0x07, 0x22, 0x99, 0xF8, 0x07, 0x22,
  0x98, 0xF8, 0x07, 0x22, 0x97, 0xF8, 0x07, 0x22,
  0x96, 0xF8, 0x07, 0x22, 0x95, 0xF8, 0x07, 0x22,
  0x94, 0xF8, 0x07, 0x22, 0x93, 0xF8, 0x07, 0x22,
  0x92, 0xF8, 0x07, 0x22, 0x91, 0xF8, 0x07, 0x22,
  0x90, 0xF8, 0x07, 0x22, 0x8F, 0xF8, 0x07, 0x22,
  0x8E, 0xF8, 0x07, 0x22, 0x8D, 0xF8, 0x07, 0x22,
  0x8C, 0xF8, 0x07, 0x22, 0x8B, 0xF8, 0x07, 0x22,
  0x8A, 0xF8, 0x07, 0x22, 0x89, 0xF8, 0x07, 0x22,
  0x88, 0xF8, 0x07, 0x22, 0x87, 0xF8, 0x07, 0x22,
  0x86, 0xF8, 0x07, 0x22, 0x85, 0xF8, 0x07, 0x22,
  0x84, 0xF8, 0x07, 0x22, 0x83, 0xF8, 0x07, 0x22,
  0x82, 0xF8, 0x07, 0x22, 0x81, 0xF8, 0x07, 0x22,
  0x80, 0xF8, 0x07, 0x22, 0x7F, 0xF8, 0x07, 0x22,
  0x7E, 0xF8, 0x07, 0x22, 0x7D, 0xF8, 0x07, 0x22,
  0x7C, 0xF8, 0x07, 0x22, 0x7B, 0xF8, 0x07, 0x22,
  0x7A, 0xF8, 0x07, 0x22, 0x79, 0xF8, 0x07, 0x22,
  0x78, 0xF8, 0x07, 0x22, 0x77, 0xF8, 0x07, 0x22,
  0x76, 0xF8, 0x07, 0x22, 0x75, 0xF8, 0x07, 0x22,
  0x74, 0xF8, 0x07, 0x22, 0x73, 0xF8, 0x07, 0x22,
  0x72, 0xF8, 0x07, 0x22, 0x71, 0xF8, 0x07, 0x22,
  0x70, 0xF8, 0x07, 0x22, 0x6F, 0xF8, 0x07, 0x22,
  0x6E, 0xF8, 0x07, 0x22, 0x6D, 0xF8, 0x07, 0x22,
  0x6C, 0xF8, 0x07, 0x22, 0x6B, 0xF8, 0x07, 0x22,
  0x6A, 0xF8, 0x07, 0x22, 0x69, 0xF8, 0x07, 0x22,
  0x68, 0xF8, 0x07, 0x22, 0x67, 0xF8, 0x07, 0x22,
  0x66, 0xF8, 0x07, 0x22, 0x65, 0xF8, 0x07, 0x22,
  0x64, 0xF8, 0x07, 0x22, 0x63, 0xF8, 0x07, 0x22,
  0x62, 0xF8, 0x07, 0x22, 0x61, 0xF8, 0x07, 0x22,
  0x60, 0xF8, 0x07, 0x22, 0x5F, 0xF8, 0x07, 0x22,
  0x5E, 0xF8, 0x07, 0x22, 0x5D, 0xF8, 0x07, 0x22,
  0x5C, 0xF8, 0x07, 0x22, 0x5B, 0xF8, 0x07, 0x22,
  0x5A, 0xF8, 0x07, 0x22, 0x59, 0xF8, 0x07, 0x22,
  0x58, 0xF8, 0x07, 0x22, 0x57, 0xF8, 0x07, 0x22,
  0x56, 0xF8, 0x07, 0x22, 0x55, 0xF8, 0x07, 0x22,
  0x54, 0xF8, 0x07, 0x22, 0x53, 0xF8, 0x07, 0x22,
  0x52, 0xF8, 0x07, 0x22, 0x51, 0xF8, 0x07, 0x22,
  0x50, 0xF8, 0x07, 0x22, 0x4F, 0xF8, 0x07, 0x22,
  0x4E, 0xF8, 0x07, 0x22, 0x4D, 0xF8, 0x07, 0x22,
  0x4C, 0xF8, 0x07, 0x22, 0x4B, 0xF8, 0x07, 0x22,
  0x4A, 0xF8, 0x07, 0x22, 0x49, 0xF8, 0x07, 0x22,
  0x48, 0xF8, 0x07, 0x22, 0x47, 0xF8, 0x07, 0x22,
  0x46, 0xF8, 0x07, 0x22, 0x45, 0xF8, 0x07, 0x22,
  0x44, 0xF8, 0x07, 0x22, 0x43, 0xF8, 0x07, 0x22,
  0x42, 0xF8, 0x07, 0x22, 0x41, 0xF8, 0x07, 0x22,
  0x40, 0xF8, 0x07, 0x22, 0x3F, 0xF8, 0x07, 0x22,
  0x3E, 0xF8, 0x07, 0x22, 0x3D, 0xF8, 0x07, 0x22,
  0x3C, 0xF8, 0x07, 0x22, 0x3B, 0xF8, 0x07, 0x22,
  0x3A, 0xF8, 0x07, 0x22, 0x39, 0xF8, 0x07, 0x22,
  0x38, 0xF8, 0x07, 0x22, 0x37, 0xF8, 0x07, 0x22,
  0x36, 0xF8, 0x07, 0x22, 0x35, 0xF8, 0x07, 0x22,
  0x34, 0xF8, 0x07, 0x22, 0x33, 0xF8, 0x07, 0x22,
  0x32, 0xF8, 0x07, 0x22, 0x31, 0xF8, 0x07, 0x22,
  0x30, 0xF8, 0x07, 0x22, 0x2F, 0xF8, 0x07, 0x22,
  0x2E, 0xF8, 0x07, 0x22, 0x2D, 0xF8, 0x07, 0x22,
  0x2C, 0xF8, 0x07, 0x22, 0x2B, 0xF8, 0x07, 0x22,
  0x2A, 0xF8, 0x07, 0x22, 0x29, 0xF8, 0x07, 0x22,
  0x28, 0xF8, 0x07, 0x22, 0x27, 0xF8, 0x07, 0x22,
  0x26, 0xF8, 0x07, 0x22, 0x25, 0xF8, 0x07, 0x22,
  0x24, 0xF8, 0x07, 0x22, 0x23, 0xF8, 0x07, 0x20,
  0x22, 0xF8, 0x07, 0x20, 0x21, 0xF8, 0x07, 0x20,
  0x20, 0xF8, 0x07, 0x20, 0x1F, 0xF8, 0x07, 0x20,
  0x1E, 0xF8, 0x07, 0x20, 0x1D, 0xF8, 0x07, 0x20,
  0x1C, 0xF8, 0x07, 0x20, 0x1C, 0xF8, 0x07, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD8, 0xF8, 0x27, 0x20, 0xD9, 0xF8, 0x27, 0x20,
  0xDA, 0xF8, 0x27, 0x20, 0xDB, 0xF8, 0x27, 0x20,
  0xDC, 0xF8, 0x27, 0x20, 0xDD, 0xF8, 0x27, 0x20,
  0xDE, 0xF8, 0x27, 0x20, 0xDF, 0xF8, 0x27, 0x20,
  0xE0, 0xF8, 0x27, 0x20, 0xE1, 0xF8, 0x27, 0x20,
  0xE2, 0xF8, 0x27, 0x20, 0xE3, 0xF8, 0x27, 0x20,
  0xE4, 0xF8, 0x27, 0x20, 0xE5, 0xF8, 0x27, 0x20,
  0xE6, 0xF8, 0x27, 0x20, 0xE7, 0xF8, 0x27, 0x20,
  0xE8, 0xF8, 0x27, 0x20, 0xE9, 0xF8, 0x27, 0x20,
  0xEA, 0xF8, 0x27, 0x20, 0xEB, 0xF8, 0x27, 0x20,
  0xEC, 0xF8, 0x27, 0x20, 0xED, 0xF8, 0x27, 0x20,
  0xEE, 0xF8, 0x27, 0x20, 0xEF, 0xF8, 0x27, 0x20,
  0xF0, 0xF8, 0x27, 0x20, 0xF1, 0xF8, 0x27, 0x20,
  0xF2, 0xF8, 0x27, 0x20, 0xF3, 0xF8, 0x27, 0x20,
  0xF4, 0xF8, 0x27, 0x20, 0xF5, 0xF8, 0x27, 0x20,
  0xF6, 0xF8, 0x27, 0x20, 0xF7, 0xF8, 0x27, 0x20,
  0xF8, 0xF8, 0x27, 0x20, 0xF9, 0xF8, 0x27, 0x20,
  0xFA, 0xF8, 0x27, 0x20, 0xFB, 0xF8, 0x27, 0x20,
  0xFC, 0xF8, 0x27, 0x20, 0xFD, 0xF8, 0x27, 0x20,
  0xFE, 0xF8, 0x27, 0x20, 0xFF, 0xF8, 0x27, 0x20,
  0x00, 0xF9, 0x27, 0x20, 0xD7, 0xF8, 0x27, 0x20,
  0x00, 0xF8, 0x27, 0x20, 0x01, 0xF8, 0x27, 0x20,
  0x02, 0xF8, 0x27, 0x20, 0x03, 0xF8, 0x27, 0x20,
  0x04, 0xF8, 0x27, 0x20, 0x05, 0xF8, 0x27, 0x20,
  0x06, 0xF8, 0x27, 0x20, 0x07, 0xF8, 0x27, 0x20,
  0x08, 0xF8, 0x27, 0x20, 0x09, 0xF8, 0x27, 0x20,
  0x0A, 0xF8, 0x27, 0x20, 0x0B, 0xF8, 0x27, 0x20,
  0x0C, 0xF8, 0x27, 0x20, 0x0D, 0xF8, 0x27, 0x20,
  0x0E, 0xF8, 0x27, 0x20, 0x0F, 0xF8, 0x27, 0x20,
  0x10, 0xF8, 0x27, 0x20, 0x11, 0xF8, 0x27, 0x20,
  0x12, 0xF8, 0x27, 0x20, 0x13, 0xF8, 0x27, 0x20,
  0x14, 0xF8, 0x27, 0x20, 0x15, 0xF8, 0x27, 0x20,
  0x15, 0xF8, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x00, 0x08, 0x00, 0x10, 0x03, 0x18, 0x1C,
  0x10, 0x03, 0x18, 0x1C, 0x03, 0x00, 0x09, 0x00,
  0x00, 0x20, 0x04, 0x30, 0x80, 0x00, 0x00, 0x00,
  0x04, 0x05, 0x00, 0x0E, 0x00, 0x0C, 0x20, 0xFD,
  0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x02,
  0x08, 0x00, 0x00, 0x05, 0x00, 0x0E, 0x00, 0x10,
  0x20, 0xFD, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x05, 0x00, 0x00, 0x03, 0x00, 0x09,
  0x00, 0x04, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x08, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x0C, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x10, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x14, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x18, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x44,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x48, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x4C, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x50, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x54, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x58, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xC8, 0x20, 0x04,
  0x30, 0x04, 0x00, 0x00, 0x00, 0x04, 0x05, 0x00,
  0x0E, 0x00, 0x14, 0x20, 0xFF, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0x00,
  0x03, 0x00, 0x09, 0x00, 0x84, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x88, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x8C, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x90, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x94, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x98, 0x21, 0x04,
  0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xA0, 0x21, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x20,
  0x21, 0x04, 0x30, 0x08, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x60, 0x21, 0x04, 0x30,
  0x08, 0x00, 0x00, 0x00, 0x04, 0x15, 0x00, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x28, 0x00,
  0x00,
};

static unsigned char vfs5011_cmd_27[] = { /* 1 B */
  0x27,
};

static unsigned char vfs5011_init_15[] = { /* 3794 B */
  0x06, 0x6B, 0x06, 0x6A, 0x76, 0xC8, 0x18, 0xD4,
  0x54, 0xEF, 0x71, 0x14, 0xCC, 0x1C, 0x58, 0x91,
  0x11, 0xAA, 0x80, 0xF4, 0x2C, 0xFC, 0x9F, 0x5F,
  0xDF, 0x04, 0x02, 0x62, 0xBA, 0x6A, 0x5A, 0x97,
  0x17, 0xCC, 0x46, 0x22, 0xFA, 0x2A, 0xBE, 0x03,
  0x87, 0x3C, 0x9E, 0xFE, 0x26, 0xF6, 0x96, 0x7E,
  0xFA, 0x11, 0x27, 0x66, 0xBA, 0x3A, 0x5A, 0xBA,
  0x3E, 0xD5, 0x4F, 0x03, 0xDF, 0x5F, 0x7F, 0x9F,
  0x1B, 0xF0, 0xA2, 0xEF, 0x33, 0xB3, 0xD3, 0x13,
  0x93, 0x70, 0xFA, 0x96, 0x4E, 0xC6, 0xA6, 0xC6,
  0x46, 0xA5, 0x2F, 0xE3, 0x3B, 0xB3, 0xD3, 0x33,
  0xB3, 0x50, 0xE8, 0xA4, 0x7C, 0xF4, 0x94, 0x14,
  0x94, 0x77, 0xC9, 0xE5, 0x3D, 0xB5, 0xD5, 0x75,
  0xF5, 0x16, 0xA8, 0xA4, 0x7C, 0xF4, 0x94, 0xD4,
  0x54, 0xB7, 0x09, 0xE5, 0x3D, 0xB5, 0x2D, 0xF4,
  0x74, 0xCF, 0x29, 0x5C, 0x84, 0x54, 0x14, 0xAA,
  0x2E, 0x95, 0xF7, 0xE0, 0x3C, 0xEC, 0x8C, 0x52,
  0xD6, 0x3D, 0x7B, 0x0E, 0xD6, 0x06, 0x82, 0x49,
  0xC9, 0x72, 0x7C, 0x18, 0xC0, 0x10, 0x10, 0xF6,
  0x72, 0xC9, 0xC3, 0xA8, 0x70, 0xA0, 0xD8, 0x77,
  0xF3, 0x48, 0x06, 0x04, 0xD8, 0x08, 0x90, 0x5B,
  0xDB, 0x60, 0x36, 0x43, 0x9B, 0x4B, 0xD4, 0xE3,
  0x9C, 0xB8, 0xF1, 0x72, 0x55, 0x1A, 0x8E, 0x57,
  0xD7, 0x6C, 0xDA, 0xBE, 0x66, 0xD6, 0xEA, 0x3D,
  0xBF, 0x04, 0xB2, 0xCE, 0x16, 0xA6, 0x06, 0xDE,
  0x5E, 0xE5, 0xB7, 0xC3, 0x1B, 0xCB, 0x47, 0x9F,
  0x1F, 0xA4, 0x3E, 0x5B, 0x83, 0x53, 0x53, 0x8A,
  0x0A, 0xB1, 0x93, 0xF9, 0x21, 0xF1, 0x31, 0xE6,
  0x64, 0xDF, 0x95, 0xE0, 0x38, 0xE8, 0xB4, 0x6D,
  0xED, 0x56, 0x1D, 0x8E, 0x56, 0xE6, 0x79, 0xB9,
  0xC6, 0xE2, 0x62, 0x4F, 0x97, 0x02, 0x40, 0x80,
  0x65, 0xB8, 0x0E, 0x07, 0xC2, 0x72, 0x37, 0xBE,
  0x3E, 0x00, 0xF2, 0xB8, 0xF1, 0x6D, 0x0E, 0x6F,
  0xC2, 0x1A, 0xA0, 0xC4, 0x95, 0x2F, 0xCD, 0x44,
  0xC4, 0x02, 0x44, 0x28, 0xF0, 0x40, 0x16, 0x97,
  0x17, 0x7D, 0xE4, 0x8B, 0xFE, 0x4C, 0x0D, 0xE3,
  0x60, 0xFD, 0x4B, 0x27, 0x34, 0xA6, 0xCD, 0xB6,
  0x10, 0xC0, 0x7C, 0x98, 0x42, 0x72, 0x92, 0x26,
  0x21, 0x60, 0x26, 0x4C, 0x95, 0x25, 0xA0, 0x03,
  0xA6, 0x50, 0xEC, 0x9D, 0xB5, 0x05, 0x53, 0xD2,
  0x52, 0xA9, 0x7E, 0x12, 0x2F, 0x65, 0xFA, 0x1A,
  0x7C, 0xB4, 0x12, 0x5E, 0x86, 0x3A, 0x50, 0xF5,
  0x53, 0xAD, 0xBA, 0xE6, 0x3D, 0x3C, 0x6D, 0xAE,
  0xCB, 0x33, 0xAD, 0xDC, 0xF4, 0x44, 0x12, 0x93,
  0x13, 0xF9, 0x7D, 0x12, 0xEB, 0x68, 0x0B, 0xE2,
  0x21, 0xE7, 0xA1, 0xCD, 0x15, 0xA5, 0xF3, 0x72,
  0xF2, 0xAB, 0x1F, 0x7E, 0xAA, 0x01, 0xE1, 0xA1,
  0x25, 0xA8, 0x06, 0x6D, 0xB9, 0x0C, 0x60, 0xA6,
  0x64, 0xAD, 0x15, 0x65, 0xBA, 0x30, 0x14, 0x66,
  0x22, 0x78, 0xFC, 0x94, 0x4C, 0x4E, 0x25, 0x9B,
  0xD9, 0x06, 0xB1, 0xEA, 0x89, 0x35, 0x62, 0x1E,
  0x8F, 0x69, 0xD4, 0x7F, 0x1C, 0xA0, 0xFD, 0x31,
  0x77, 0xAD, 0x1B, 0x40, 0xA4, 0x10, 0xB7, 0xCC,
  0x4D, 0xAB, 0x16, 0xD7, 0x0C, 0x01, 0x62, 0x87,
  0xBF, 0x4C, 0x50, 0x5A, 0xD8, 0x3B, 0x50, 0xE7,
  0x2C, 0xB3, 0xB7, 0x1F, 0x46, 0xA0, 0x57, 0x6B,
  0x46, 0x98, 0x93, 0xFA, 0xC7, 0xC1, 0x89, 0x45,
  0xDE, 0xD7, 0xC3, 0xC3, 0xBB, 0xCF, 0xEE, 0xEE,
  0xA8, 0xB3, 0xDF, 0x61, 0x4B, 0xE6, 0x04, 0x04,
  0x40, 0xDA, 0xAC, 0x43, 0xDA, 0x9A, 0x15, 0x25,
  0x45, 0x7D, 0xEA, 0x0C, 0x3A, 0x7A, 0xD4, 0x87,
  0xC5, 0x43, 0x77, 0x1D, 0xC6, 0x76, 0xD4, 0xB6,
  0x5A, 0x4B, 0x3F, 0x91, 0x55, 0x98, 0xC2, 0xCE,
  0x8C, 0x5B, 0xED, 0x53, 0x99, 0x20, 0x6D, 0xA6,
  0xF1, 0x96, 0x21, 0x41, 0xBB, 0x16, 0x86, 0x46,
  0xC6, 0x1D, 0x9D, 0xB0, 0x68, 0x69, 0x3D, 0xFE,
  0xC6, 0x16, 0x2C, 0x2B, 0x51, 0x40, 0x40, 0x2A,
  0x01, 0xBF, 0xB3, 0xFF, 0x8A, 0x38, 0x3D, 0x51,
  0xF4, 0x32, 0x74, 0x18, 0xC0, 0x70, 0x26, 0xA7,
  0x27, 0x5D, 0xDE, 0xB1, 0xD8, 0x5E, 0x3D, 0x30,
  0xB2, 0x0C, 0xEC, 0xA5, 0xCC, 0x44, 0x27, 0xC7,
  0x6D, 0x16, 0x01, 0x5A, 0x81, 0xFC, 0x9E, 0x3B,
  0xEE, 0x10, 0x17, 0x41, 0x9A, 0x0A, 0x50, 0x30,
  0x72, 0x6A, 0xCC, 0x01, 0xE0, 0x53, 0x3F, 0xFD,
  0x54, 0x8C, 0x13, 0x6C, 0x9D, 0x0E, 0x47, 0xB4,
  0xD1, 0x59, 0xCA, 0x17, 0xF3, 0x40, 0x10, 0xEA,
  0xCA, 0xD3, 0xA6, 0xDA, 0xA3, 0x28, 0x4B, 0x6E,
  0xBC, 0x42, 0xF8, 0x9D, 0x75, 0xFF, 0x3F, 0xCD,
  0x8E, 0x45, 0xE8, 0x1D, 0xEC, 0x5F, 0x74, 0x87,
  0x61, 0x23, 0x63, 0xA2, 0x79, 0x7B, 0xBB, 0xDE,
  0x72, 0xE5, 0xB6, 0x7B, 0x8B, 0x9A, 0xC7, 0x04,
  0x35, 0xD0, 0x65, 0xCB, 0xD0, 0x44, 0x41, 0xD1,
  0x74, 0x1E, 0xE8, 0x87, 0x6F, 0xE5, 0x25, 0x44,
  0xFB, 0x23, 0xA7, 0x08, 0xF4, 0x89, 0xEA, 0xCF,
  0x1E, 0xE0, 0xE7, 0xC9, 0x12, 0x92, 0xC8, 0xA8,
  0x89, 0x13, 0xA6, 0x07, 0xDC, 0xC9, 0xFA, 0x1F,
  0x2E, 0xB1, 0x04, 0x58, 0xBA, 0xAA, 0x6B, 0xE8,
  0x6B, 0x7D, 0xC8, 0x01, 0x8B, 0x1E, 0xCF, 0x49,
  0xCA, 0x21, 0xAD, 0x61, 0x18, 0xED, 0x8E, 0x83,
  0x00, 0x3E, 0xD9, 0x90, 0x78, 0xE2, 0x22, 0xFF,
  0x8F, 0x54, 0xD4, 0xF9, 0x21, 0x10, 0x37, 0xF4,
  0xFC, 0x2F, 0x15, 0x31, 0x48, 0xB0, 0xD3, 0x36,
  0xC1, 0x32, 0x99, 0x05, 0xDD, 0x6D, 0x3B, 0xBA,
  0x3A, 0x60, 0x91, 0xFE, 0xAE, 0x16, 0xFA, 0x72,
  0x53, 0xC0, 0x75, 0xFC, 0x51, 0xC9, 0x0C, 0x38,
  0x99, 0x5F, 0x19, 0x75, 0xAD, 0x1D, 0x4B, 0xCA,
  0x4A, 0x3C, 0x88, 0x01, 0x40, 0xD2, 0x33, 0xB4,
  0x37, 0x64, 0xDA, 0x3A, 0xAA, 0xBB, 0x93, 0x50,
  0xF5, 0x5A, 0xC4, 0xB5, 0x9D, 0x2D, 0x7B, 0xFA,
  0x7A, 0x84, 0x17, 0x7B, 0x22, 0xD8, 0xBB, 0xEA,
  0x58, 0x80, 0x97, 0xB2, 0x69, 0x70, 0x49, 0x00,
  0x89, 0x4F, 0x09, 0x65, 0xBD, 0x0D, 0x5B, 0xDA,
  0x5A, 0xB0, 0x32, 0x5D, 0x89, 0x1E, 0x46, 0x85,
  0x54, 0xC4, 0x71, 0x8F, 0x54, 0xEC, 0xEE, 0x8F,
  0x7F, 0xAF, 0x90, 0xEA, 0x7A, 0xCC, 0x7D, 0xF1,
  0x72, 0xA5, 0x79, 0x19, 0xC6, 0xF4, 0x5D, 0x61,
  0xF7, 0x24, 0x98, 0xD2, 0x53, 0xEB, 0x26, 0xE4,
  0x01, 0x67, 0xF7, 0xB6, 0x64, 0xC9, 0x59, 0xF3,
  0x30, 0x59, 0xFC, 0x9B, 0xD1, 0x65, 0x05, 0xD3,
  0x68, 0xB8, 0x68, 0x7D, 0xB5, 0xC7, 0xB3, 0x8F,
  0x59, 0x2E, 0x92, 0x5C, 0xC7, 0x7F, 0x3D, 0xFE,
  0x73, 0x88, 0x1F, 0x77, 0xB2, 0xF2, 0x9E, 0x55,
  0x57, 0x8F, 0x34, 0x9A, 0x61, 0x0C, 0x7B, 0xD3,
  0x5C, 0x15, 0xAE, 0xC2, 0x16, 0xB4, 0xC2, 0x2B,
  0xA5, 0x75, 0x6A, 0xA4, 0x31, 0x81, 0xA7, 0x67,
  0xE7, 0x30, 0x84, 0x28, 0xD0, 0x60, 0xA2, 0x71,
  0xF9, 0xE0, 0x33, 0xFF, 0xAB, 0x01, 0x04, 0x22,
  0x84, 0x42, 0x04, 0x02, 0x99, 0xFB, 0x9F, 0x5F,
  0xB9, 0x7F, 0xF5, 0x21, 0xDB, 0xC6, 0xA5, 0x00,
  0x60, 0x9D, 0x8B, 0x07, 0xAB, 0x7D, 0x03, 0xE2,
  0xD3, 0x45, 0xF0, 0x6E, 0xBD, 0x0D, 0x4B, 0xA4,
  0x23, 0x8A, 0x77, 0x1B, 0xCF, 0x75, 0x30, 0x96,
  0x33, 0xE4, 0x6A, 0x94, 0x6F, 0x01, 0xA1, 0x41,
  0xC1, 0x88, 0x5B, 0x97, 0xCD, 0x3E, 0x56, 0xD0,
  0x53, 0x88, 0x9C, 0xE3, 0x3C, 0x00, 0x1A, 0xA8,
  0x6C, 0xB7, 0xA3, 0xDC, 0x03, 0x96, 0x14, 0xF2,
  0x7E, 0xB7, 0x1C, 0x80, 0xEA, 0x49, 0x21, 0x8B,
  0x48, 0x85, 0xF8, 0x93, 0x89, 0x3D, 0x5D, 0x5F,
  0x13, 0x33, 0x93, 0xC3, 0x1C, 0x4E, 0x2D, 0xE0,
  0xE2, 0x1D, 0x2A, 0x51, 0xE7, 0x07, 0xF5, 0x38,
  0xB8, 0x75, 0x4A, 0x2A, 0xFE, 0x5C, 0x37, 0x0E,
  0x7C, 0xEA, 0x5C, 0xB6, 0x7E, 0xCE, 0x2C, 0x25,
  0x5C, 0xD1, 0xFF, 0x66, 0x06, 0x94, 0x59, 0x9A,
  0x7F, 0x7D, 0xED, 0x21, 0x69, 0xAD, 0xC6, 0x9F,
  0x49, 0x7B, 0xC7, 0xA7, 0x74, 0xC8, 0xE4, 0xC6,
  0x65, 0x63, 0x07, 0xC9, 0x65, 0x0F, 0xBC, 0xBC,
  0x1C, 0xC7, 0xD3, 0xAC, 0x7C, 0x2E, 0x2B, 0x4B,
  0xB9, 0x3F, 0xF7, 0x59, 0xC2, 0x7A, 0x0C, 0x86,
  0xF4, 0x23, 0xFB, 0x75, 0xE9, 0x59, 0x9B, 0x48,
  0xC0, 0x7E, 0x13, 0x59, 0x07, 0x72, 0xED, 0x00,
  0x87, 0x50, 0xE9, 0x45, 0xBD, 0x0D, 0xCF, 0x1C,
  0x94, 0xCD, 0x1E, 0xD2, 0x1C, 0x36, 0xA5, 0x80,
  0xD9, 0x24, 0x8F, 0x13, 0xC7, 0x75, 0x53, 0x5B,
  0x24, 0x47, 0xD3, 0x12, 0xC9, 0x5C, 0xE8, 0x0E,
  0x2E, 0x65, 0xA7, 0xAD, 0x6C, 0xFB, 0x97, 0x5C,
  0x0E, 0xF6, 0x9D, 0x33, 0x49, 0x8D, 0x27, 0x24,
  0x64, 0x9F, 0x29, 0x97, 0x2A, 0x3A, 0xF8, 0x2B,
  0xA3, 0x0A, 0xE0, 0xF2, 0x96, 0x7C, 0x76, 0x55,
  0xD9, 0x6F, 0x0B, 0x29, 0xF1, 0xE3, 0x90, 0x58,
  0xBD, 0xB0, 0x20, 0xCA, 0x1B, 0xAB, 0xC7, 0x78,
  0xF4, 0x7B, 0x8F, 0xA0, 0x70, 0xAA, 0x89, 0xBB,
  0x7F, 0xA4, 0xA0, 0xDF, 0x0C, 0x20, 0x0B, 0x79,
  0xAD, 0x8A, 0x30, 0xA6, 0x72, 0x4A, 0xA8, 0x2C,
  0xAC, 0x12, 0x70, 0x3A, 0x70, 0xD4, 0x48, 0x1A,
  0x53, 0x79, 0x5D, 0x65, 0x41, 0xD3, 0xB0, 0x7D,
  0xDD, 0x27, 0x95, 0xE4, 0xCC, 0x51, 0x36, 0x70,
  0x2F, 0x0B, 0x1F, 0x67, 0x43, 0xE5, 0x5F, 0x77,
  0xFB, 0xA8, 0x9C, 0xB4, 0x6C, 0x6A, 0xB0, 0x60,
  0xEC, 0xCD, 0xDE, 0x63, 0x9D, 0x0F, 0x7B, 0x47,
  0xE5, 0xFC, 0xBB, 0xF5, 0x79, 0x35, 0x53, 0x0E,
  0x71, 0x4F, 0x29, 0x63, 0x96, 0x21, 0x07, 0x3B,
  0x44, 0x9F, 0x1F, 0x32, 0xEA, 0x0B, 0x5F, 0x9C,
  0x44, 0x9A, 0x6E, 0xA2, 0x8A, 0x70, 0x55, 0xA7,
  0x23, 0x78, 0xE8, 0xA7, 0x4E, 0xD8, 0xFB, 0x08,
  0xE9, 0x79, 0xCC, 0xD1, 0x45, 0xF6, 0x9A, 0xF2,
  0x54, 0xEC, 0x75, 0x7F, 0x24, 0x8A, 0xE6, 0x55,
  0x47, 0xB9, 0xD1, 0x7D, 0x85, 0x35, 0xC7, 0x61,
  0x41, 0xA8, 0x5A, 0xB6, 0xDC, 0x69, 0x04, 0x66,
  0xE1, 0x3A, 0x3C, 0xE1, 0x3D, 0x3D, 0xF5, 0xA6,
  0x84, 0x18, 0xAE, 0xDF, 0xF7, 0x5A, 0xCA, 0x06,
  0x95, 0x08, 0xBE, 0xD2, 0x06, 0x85, 0xD7, 0x53,
  0x53, 0x95, 0xD3, 0xB3, 0x38, 0x4A, 0x0F, 0x11,
  0x51, 0xAA, 0x1C, 0xB2, 0x0C, 0x1C, 0xBA, 0x89,
  0xF6, 0x2D, 0xAD, 0x80, 0x58, 0xD9, 0xF7, 0x34,
  0x95, 0x01, 0xB4, 0xF1, 0x3A, 0x97, 0x07, 0xC7,
  0x47, 0x9C, 0x1C, 0x31, 0xE9, 0xC8, 0x9C, 0x5F,
  0x47, 0x95, 0xAF, 0x6A, 0x10, 0x89, 0x34, 0x54,
  0x74, 0xBB, 0x2B, 0x7D, 0xA7, 0xF2, 0xD0, 0x31,
  0xAC, 0x87, 0x07, 0x2A, 0xF2, 0xE3, 0xD2, 0x11,
  0xB0, 0x21, 0x94, 0xC9, 0x23, 0x90, 0x61, 0xF1,
  0x72, 0x28, 0xCC, 0xA3, 0xF2, 0x6B, 0x22, 0xE1,
  0xC8, 0x4A, 0xE1, 0x7D, 0xA5, 0x15, 0x43, 0xC2,
  0x42, 0xB8, 0x5D, 0x32, 0x62, 0xF0, 0x57, 0xFF,
  0x62, 0x18, 0xFA, 0x95, 0x28, 0xD1, 0x99, 0xC8,
  0x1D, 0xC5, 0xB2, 0x88, 0x53, 0x52, 0x65, 0xA6,
  0x8E, 0x77, 0x79, 0x1E, 0x06, 0x1C, 0x6C, 0x3C,
  0x26, 0xED, 0xEB, 0x1D, 0x56, 0x7F, 0x3D, 0x58,
  0x11, 0xEF, 0x44, 0xD8, 0x00, 0xB0, 0xE6, 0x67,
  0xE7, 0x9D, 0x7F, 0x10, 0x2D, 0xDF, 0x97, 0xB6,
  0x6E, 0xB6, 0x41, 0x1F, 0xC4, 0x45, 0x76, 0xB5,
  0x39, 0xEE, 0x80, 0xCF, 0xE6, 0x01, 0x62, 0x15,
  0xF8, 0x01, 0x0A, 0x69, 0x79, 0xCD, 0x64, 0xAB,
  0x86, 0x5F, 0x68, 0x5D, 0x86, 0xD6, 0x2B, 0xCB,
  0xD2, 0x2A, 0x15, 0x7D, 0xC0, 0x38, 0x58, 0x29,
  0xF3, 0x2B, 0x35, 0x7A, 0xAE, 0x1C, 0xCC, 0xA6,
  0x06, 0x74, 0xE1, 0x90, 0xB8, 0x04, 0x6F, 0x69,
  0x1F, 0x3B, 0xBB, 0x96, 0x4E, 0xE2, 0x4A, 0x0D,
  0x1F, 0xC0, 0x57, 0x60, 0xBB, 0x16, 0x86, 0xEB,
  0x69, 0x97, 0xE3, 0xAA, 0x5F, 0xE5, 0x98, 0xA8,
  0x28, 0xF3, 0x73, 0x5E, 0x86, 0x47, 0x60, 0xA3,
  0xFF, 0x70, 0x4E, 0x25, 0x71, 0x89, 0x4C, 0x92,
  0x12, 0x8F, 0x38, 0x54, 0x2D, 0xD5, 0xB6, 0x53,
  0xEF, 0x1C, 0x02, 0x69, 0xBD, 0x04, 0xF6, 0x7C,
  0x64, 0x0D, 0x1B, 0x04, 0x96, 0x45, 0xE7, 0x87,
  0x73, 0xCF, 0x45, 0x3A, 0x5F, 0xED, 0x25, 0xE2,
  0xAF, 0x77, 0x8B, 0x4D, 0x37, 0x4D, 0x09, 0x6C,
  0xA9, 0x5A, 0x5E, 0x92, 0x39, 0x4F, 0x2A, 0xEA,
  0x2D, 0xCD, 0x6F, 0xBE, 0x64, 0x7C, 0x1B, 0x19,
  0x39, 0x96, 0x60, 0xC0, 0xD8, 0x22, 0xE8, 0x8A,
  0xC0, 0x3F, 0x6C, 0x43, 0xB3, 0xB1, 0x71, 0xC2,
  0xFE, 0x70, 0xA1, 0xF6, 0x26, 0x34, 0xF0, 0x35,
  0x50, 0x5A, 0xC8, 0xE2, 0x3D, 0x8D, 0x5F, 0x3F,
  0xCB, 0x77, 0x7A, 0x1E, 0x64, 0x70, 0x16, 0x33,
  0x63, 0x9C, 0xAC, 0xC3, 0x1B, 0xA7, 0xCD, 0xD5,
  0x52, 0x85, 0x2F, 0x81, 0x14, 0x3C, 0xB9, 0xB6,
  0x12, 0xEC, 0x5E, 0x32, 0x02, 0xB5, 0x37, 0xF9,
  0xE1, 0xF6, 0x0E, 0xC3, 0x53, 0xE0, 0x25, 0xDD,
  0x75, 0xB3, 0xF5, 0x99, 0x41, 0xF1, 0xA7, 0x26,
  0xA6, 0x4C, 0xBD, 0xD2, 0x32, 0x81, 0xC0, 0x5C,
  0xDF, 0x2D, 0xE8, 0x0F, 0x54, 0x76, 0xD5, 0x01,
  0x18, 0xA0, 0x8F, 0xB0, 0xE1, 0x62, 0x8B, 0x68,
  0xCA, 0xD3, 0x99, 0xDC, 0x47, 0xEA, 0x7A, 0xBA,
  0x3A, 0xE1, 0x61, 0x4C, 0x94, 0xC1, 0xB2, 0x72,
  0xEF, 0xC4, 0x44, 0x69, 0xB1, 0x0D, 0x27, 0x42,
  0xE2, 0x1B, 0x8C, 0xA7, 0x7C, 0x41, 0x2B, 0x73,
  0xF1, 0x26, 0x8A, 0x64, 0xD5, 0x42, 0x87, 0x58,
  0xFA, 0x5D, 0x37, 0x27, 0x11, 0xAD, 0xE5, 0x9D,
  0x1F, 0xC8, 0x69, 0xA7, 0x14, 0x8C, 0x5D, 0xD6,
  0x55, 0x4E, 0xD8, 0xB4, 0xFE, 0x65, 0xAD, 0xAD,
  0x0D, 0xD6, 0x10, 0xE5, 0x1D, 0x3F, 0x34, 0x5C,
  0x1C, 0xE7, 0x51, 0xCF, 0x3C, 0x24, 0x84, 0x64,
  0xE4, 0xBF, 0xF6, 0xBA, 0x90, 0x4B, 0x83, 0x83,
  0x23, 0xF8, 0x9C, 0xDB, 0xA9, 0xD9, 0x99, 0x59,
  0x39, 0x3F, 0x99, 0x27, 0x94, 0x8E, 0x2E, 0xCE,
  0x4E, 0x37, 0xAA, 0x6C, 0x74, 0xE4, 0x84, 0x84,
  0xAE, 0x65, 0x71, 0x76, 0x04, 0x15, 0x28, 0xEB,
  0xCE, 0x00, 0x94, 0xF4, 0x2F, 0x27, 0x45, 0x89,
  0x0F, 0xD8, 0x2B, 0xA7, 0x3C, 0x9D, 0xF1, 0x38,
  0x88, 0xB0, 0xF6, 0x7A, 0x4C, 0xED, 0x3D, 0x0E,
  0x2E, 0x97, 0x4E, 0x08, 0xDC, 0x73, 0xDB, 0x19,
  0x09, 0x7B, 0x3D, 0x4A, 0x0B, 0x2B, 0xDB, 0x6F,
  0x05, 0x12, 0x6E, 0xC8, 0xC2, 0x7E, 0x37, 0x75,
  0xF9, 0x08, 0x0C, 0x6C, 0x91, 0xA1, 0x49, 0x98,
  0xA8, 0xC0, 0x37, 0xE9, 0x7D, 0xE8, 0x58, 0x10,
  0xB0, 0xB3, 0x07, 0xD6, 0x06, 0x36, 0xE9, 0xAA,
  0xC0, 0xC6, 0xC0, 0x54, 0xCD, 0x8F, 0xA3, 0x49,
  0x13, 0x62, 0x56, 0x30, 0xC0, 0xC2, 0xEE, 0x07,
  0x07, 0x58, 0xAF, 0x41, 0xD3, 0x4B, 0x4D, 0xC4,
  0xFE, 0xAD, 0x19, 0xD8, 0x03, 0x39, 0xCA, 0x80,
  0xB4, 0xDD, 0x40, 0x06, 0x54, 0x6A, 0xBA, 0xC1,
  0xB1, 0xD0, 0xEE, 0x00, 0xD0, 0x47, 0xA5, 0x2C,
  0x44, 0x17, 0xA3, 0xC3, 0x10, 0x20, 0x93, 0xC3,
  0xC9, 0xE6, 0xA2, 0xE1, 0x13, 0x29, 0xA7, 0x97,
  0xE8, 0xC3, 0x8F, 0x0D, 0x17, 0xA9, 0xE3, 0xC1,
  0x4F, 0xBD, 0x8B, 0x2B, 0xE2, 0xB2, 0x1E, 0xFE,
  0xBC, 0x3A, 0xE0, 0xE9, 0x20, 0x90, 0xFC, 0x35,
  0xBE, 0x30, 0x3E, 0x50, 0x93, 0x10, 0x40, 0xB0,
  0x44, 0xAF, 0xFA, 0x66, 0x04, 0x70, 0x62, 0xCE,
  0x60, 0x5B, 0xAE, 0xD3, 0x5D, 0x58, 0xCD, 0xAF,
  0xE4, 0x2B, 0x1C, 0x2E, 0xF5, 0xD7, 0x9C, 0x79,
  0x6B, 0xDB, 0x44, 0xE8, 0x10, 0xA0, 0x48, 0x80,
  0x89, 0xD9, 0xCA, 0xF1, 0x09, 0xA4, 0x34, 0xF4,
  0x74, 0xAF, 0x2F, 0x02, 0xDA, 0x4B, 0x6C, 0xAF,
  0x87, 0x5E, 0x4A, 0xEC, 0x20, 0xB5, 0x8D, 0x6D,
  0x45, 0x9C, 0xA1, 0x67, 0x9A, 0xB9, 0xFE, 0x32,
  0xF8, 0xC1, 0xD8, 0x34, 0x3D, 0xC6, 0xA5, 0xA5,
  0x05, 0xDE, 0xAA, 0xEB, 0x87, 0xF7, 0xB7, 0x77,
  0x4F, 0x96, 0xC0, 0x60, 0xA8, 0xDA, 0xD7, 0xA3,
  0x91, 0x61, 0xF0, 0xF9, 0x29, 0xBB, 0x63, 0xA1,
  0x2D, 0xEC, 0xE8, 0xAF, 0x5F, 0x0A, 0x6D, 0x8F,
  0x12, 0x39, 0xB9, 0x94, 0x4C, 0xAD, 0x86, 0x45,
  0x05, 0xFE, 0x48, 0x66, 0x9B, 0x9F, 0x3F, 0xDF,
  0x5F, 0xB4, 0x46, 0x3A, 0xA2, 0x50, 0x10, 0x92,
  0x77, 0x18, 0xB3, 0x2F, 0xF7, 0x47, 0x11, 0x90,
  0x10, 0xC7, 0x72, 0x6C, 0x14, 0xD4, 0xE5, 0x62,
  0xE1, 0x36, 0x96, 0x42, 0x9F, 0x1F, 0xBC, 0x8C,
  0xBC, 0xC4, 0xD2, 0x6C, 0x9E, 0x04, 0xD4, 0xD8,
  0xF8, 0xF3, 0x98, 0x04, 0x06, 0x7A, 0x98, 0x54,
  0xF0, 0xCB, 0x3E, 0x43, 0xFD, 0x55, 0x09, 0x2B,
  0x81, 0x74, 0x10, 0x56, 0xBC, 0x47, 0x94, 0xB3,
  0x3E, 0xF2, 0xE6, 0x86, 0x76, 0xC6, 0xBD, 0x3D,
  0xBD, 0xD0, 0xC7, 0xDB, 0xB8, 0x18, 0xD8, 0xB8,
  0x0C, 0x67, 0x7B, 0x37, 0x4F, 0x5F, 0x4B, 0xCD,
  0x4D, 0x96, 0x2C, 0x4A, 0x20, 0x3F, 0xDF, 0x3A,
  0x43, 0x67, 0x69, 0x00, 0x62, 0x06, 0x94, 0x79,
  0xD7, 0x00, 0xAA, 0x36, 0x01, 0xA0, 0x30, 0x3E,
  0x2D, 0x34, 0xEF, 0xAD, 0x6E, 0xED, 0xBD, 0x4D,
  0xB9, 0x04, 0xF1, 0x3D, 0x6E, 0x75, 0xB0, 0xF5,
  0x52, 0x24, 0x90, 0x7D, 0xFB, 0x48, 0xE8, 0x08,
  0x88, 0xDB, 0x65, 0x80, 0x6A, 0x7F, 0x56, 0xB6,
  0x2B, 0x00, 0x80, 0xAD, 0x75, 0x44, 0x63, 0xA0,
  0x00, 0xB9, 0xFF, 0x1B, 0xCB, 0x70, 0x53, 0x13,
  0xA1, 0xEA, 0xDC, 0xE2, 0x9A, 0x58, 0x1D, 0xF7,
  0xF7, 0x4A, 0x5C, 0x40, 0xEF, 0xAF, 0xB5, 0x53,
  0x85, 0xBA, 0x08, 0x46, 0x9C, 0x0A, 0x28, 0x7B,
  0x8B, 0xD0, 0x44, 0x29, 0xD1, 0x49, 0x18, 0x92,
  0x30, 0xEB, 0x7F, 0x02, 0xFA, 0x6A, 0x3B, 0xD9,
  0x0A, 0xA1, 0x55, 0x1C, 0xEE, 0x1E, 0x3A, 0x0A,
  0xC0, 0x5D, 0xA9, 0xC1, 0x3F, 0x2E, 0x11, 0xD2,
  0xD2, 0x4D, 0xFA, 0xD6, 0x46, 0xC7, 0x01, 0xD5,
  0x59, 0x24, 0x50, 0x2F, 0xEB, 0xA9, 0xD5, 0xED,
  0xEF, 0x67, 0xA1, 0x8B, 0x51, 0xE1, 0x67, 0xB5,
  0x33, 0xE4, 0x50, 0x30, 0xE1, 0xC3, 0xF0, 0x40,
  0x60, 0x19, 0x0F, 0xCB, 0x19, 0x0B, 0x0E, 0xFC,
  0x61, 0x4A, 0xDE, 0xB0, 0x4D, 0x7B, 0xF4, 0xCB,
  0x4B, 0x90, 0x10, 0x3D, 0xE5, 0x59, 0x3B, 0xF7,
  0x72, 0xE8, 0x19, 0x76, 0xA2, 0x51, 0xF9, 0x3D,
  0x7D, 0x74, 0x52, 0xAC, 0x69, 0xB5, 0xC3, 0x5A,
  0xDD, 0x0D, 0x32, 0xDE, 0x86, 0xC2, 0x20, 0xBD,
  0x51, 0xDC, 0xE2, 0x88, 0x90, 0xD2, 0x12, 0x30,
  0x9F, 0x6E, 0x64, 0x16, 0xE8, 0x46, 0x09, 0xEF,
  0x41, 0xB6, 0x66, 0x34, 0xBB, 0x59, 0x56, 0xBC,
  0x1C, 0x55, 0x13, 0xBF, 0xFE, 0xEE, 0x2C, 0xE5,
  0x4F, 0x26, 0x99, 0xDC, 0x84, 0x9E, 0xEF, 0x9F,
  0xB5, 0x4E, 0xF4, 0x93, 0xE9, 0x04, 0x08, 0xE2,
  0xCE, 0x87, 0x38, 0x73, 0x39, 0xC3, 0x4B, 0x26,
  0xA4, 0x5A, 0x1F, 0x8C, 0x12, 0xA9, 0xC9, 0x12,
  0x2C, 0xD7, 0xC3, 0x5F, 0x47, 0x5D, 0x9D, 0xEF,
  0x00, 0xF1, 0xF7, 0x20, 0x08, 0x02, 0xC8, 0xBA,
  0x30, 0xC1, 0x95, 0xF3, 0x02, 0x32, 0xE9, 0x38,
  0x58, 0x38, 0xAE, 0x70, 0xF5, 0x29, 0x63, 0x1F,
  0x3D, 0xEC, 0x7D, 0xB3, 0x20, 0x78, 0xB5, 0x77,
  0xFB, 0x2B, 0x78, 0xFB, 0xDC, 0xA4, 0xC0, 0x2A,
  0x76, 0x3F, 0x84, 0x00, 0x74, 0x0D, 0x66, 0x5F,
  0x2D, 0xBB, 0xE5, 0x41, 0x9D, 0x07, 0xBB, 0x99,
  0x14, 0x27, 0x4D, 0xEF, 0x9A, 0x28, 0x44, 0x9F,
  0x3F, 0x66, 0x20, 0x8C, 0xC6, 0xD6, 0x24, 0xCD,
  0x67, 0x7C, 0x42, 0x8E, 0xC6, 0xEF, 0x7F, 0x25,
  0x2D, 0x74, 0xCA, 0x81, 0xDB, 0x26, 0xAE, 0xCB,
  0xA7, 0x83, 0xFD, 0x95, 0x46, 0xC5, 0xBE, 0x5C,
  0xFC, 0x07, 0xC5, 0xFF, 0x34, 0x70, 0x82, 0x6E,
  0xC7, 0x90, 0xAF, 0xC8, 0x99, 0xAB, 0xA7, 0x4E,
  0x02, 0xC1, 0x92, 0x22, 0x05, 0xA8, 0x38, 0xF8,
  0x78, 0xA3, 0x23, 0x0E, 0xD6, 0x27, 0x27, 0xE4,
  0x55, 0xEF, 0x5A, 0xBE, 0x22, 0x1B, 0xF9, 0x00,
  0xC4, 0x02, 0x44, 0x28, 0xF0, 0x40, 0x16, 0x97,
  0x17, 0x6E, 0x1A, 0x66, 0x1B, 0x98, 0xD8, 0x89,
  0x69, 0xB1, 0x8F, 0x61, 0x30, 0xC9, 0xB4, 0x84,
  0x04, 0xDF, 0x5F, 0x72, 0xAA, 0xA7, 0xC5, 0x24,
  0xC6, 0x1E, 0x80, 0xEE, 0x3A, 0x06, 0xED, 0x8F,
  0xAA, 0x73, 0xED, 0x00, 0xBB, 0x08, 0xFA, 0xF8,
  0x68, 0x2A, 0xCE, 0x3B, 0xA1, 0x98, 0x9A, 0xD6,
  0x55, 0xB7, 0x93, 0xE2, 0xCA, 0x7A, 0x2C, 0xAD,
  0x2D, 0xC7, 0x13, 0x7C, 0x9C, 0x2F, 0xFD, 0x2E,
  0xB6, 0x61, 0xCB, 0xA0, 0x93, 0x39, 0xC8, 0x56,
  0xD5, 0xCE, 0xD3, 0x9F, 0xE5, 0x06, 0x7E, 0x7E,
  0xDE, 0x05, 0x2B, 0x4E, 0x14, 0xB7, 0xD1, 0xB3,
  0xF0, 0x3B, 0x17, 0xF3, 0xA2, 0x61, 0x64, 0x88,
  0x28, 0x41, 0xE4, 0x90, 0x5F, 0x04, 0x6A, 0x12,
  0x01, 0x56, 0x7B, 0x9F, 0x4C, 0x51, 0x33, 0x13,
  0x9B, 0x40, 0xDB, 0xBD, 0x78, 0x38, 0x54, 0x96,
  0x0B, 0x20, 0xA0, 0x8D, 0x55, 0xD4, 0xD6, 0x15,
  0xAD, 0x75, 0x71, 0x0F, 0xC3, 0xBB, 0x78, 0x10,
  0xB3, 0xA2, 0xAF, 0x7A, 0x01, 0x16, 0x4D, 0xDC,
  0xFC, 0xBC, 0xCA, 0x24, 0xEF, 0x47, 0xBE, 0xDD,
  0x4A, 0xF9, 0x64, 0xCA, 0xBA, 0xF5, 0x74, 0xD0,
  0x53, 0x70, 0x75, 0xD9, 0x21, 0x91, 0x23, 0xF0,
  0x68, 0x02, 0xFF, 0x90, 0xA8, 0xC5, 0xB5, 0x87,
  0x6C, 0x17, 0x73, 0x4C, 0x8C, 0xFC, 0xBC, 0x7C,
  0x5E, 0xAE, 0x98, 0x34, 0xCC, 0x7C, 0xDC, 0xB6,
  0x26, 0x5F, 0x82, 0x6E, 0xF0, 0x41, 0x21, 0x43,
  0x00, 0xCB, 0x58, 0x13, 0xEB, 0x9B, 0xDB, 0x1B,
  0x0A, 0x8F, 0x3A, 0xD4, 0x1F, 0xA9, 0x51, 0x98,
  0xBA, 0xA2, 0x04, 0xF2, 0xA2, 0x9B, 0x88, 0x2D,
  0x89, 0x72, 0x4C, 0xA3, 0xD6, 0x64, 0xE4, 0x2C,
  0xAC, 0x6A, 0x2C, 0x40, 0x98, 0x28, 0x7E, 0xFF,
  0x7F, 0xE6, 0xF8, 0x6B, 0x22, 0xF7, 0x94, 0xE5,
  0x07, 0xDF, 0x58, 0x7F, 0xA4, 0xAC, 0xC7, 0xC5,
  0x5E, 0x9D, 0x27, 0x66, 0x6E, 0x12, 0x52, 0x50,
  0x8B, 0x48, 0x3E, 0x72, 0xAA, 0xB8, 0xFB, 0x9B,
  0xB2, 0xD2, 0xA4, 0xE8, 0x30, 0x02, 0x41, 0x21,
  0x61, 0x9A, 0x2C, 0xD0, 0x80, 0x20, 0xD2, 0xB3,
  0x33, 0x78, 0x46, 0x0A, 0x50, 0x83, 0x43, 0x43,
  0xE3, 0x38, 0xAC, 0xE3, 0xBB, 0xCB, 0x8B, 0x4B,
  0x8B, 0x72, 0xD4, 0xFA, 0x86, 0x36, 0x16, 0xF4,
  0x54, 0xAD, 0x78, 0x94, 0x51, 0x11, 0x47, 0xC6,
  0x46, 0xFB, 0x79, 0x1D, 0x47, 0xF4, 0xB3, 0xB1,
  0x32, 0xCF, 0x1F, 0x4B, 0x99, 0x84, 0xE6, 0x9B,
  0x18, 0x0E, 0xBC, 0xF5, 0xB5, 0x27, 0x5A, 0x6A,
  0x42, 0xCA, 0xCE, 0x02, 0x21, 0x21, 0x8D, 0x5D,
  0x1F, 0x87, 0x17, 0xBB, 0x43, 0xF3, 0x01, 0xCB,
  0x47, 0x5C, 0xCA, 0xA6, 0xCE, 0xE7, 0x97, 0xC5,
  0x0F, 0xD8, 0x73, 0xEF, 0x37, 0x87, 0xFD, 0x3C,
  0xBC, 0x67, 0xD1, 0xBD, 0x65, 0xD5, 0x51, 0x9C,
  0x1E, 0xA5, 0x17, 0x7A, 0xA2, 0x12, 0x72, 0xB2,
  0x32, 0xE9, 0xEF, 0x8D, 0x57, 0x87, 0xCD, 0x0F,
  0x8F, 0x54, 0xE2, 0x8E, 0x56, 0xE6, 0x66, 0xB4,
  0x36, 0x8D, 0x27, 0x4B, 0x9B, 0x2B, 0x36, 0xF2,
  0x0C, 0xD3, 0xE1, 0x9F, 0x45, 0x95, 0x81, 0x52,
  0xD0, 0x6B, 0x45, 0x3A, 0xE0, 0x30, 0xF0, 0x23,
  0xA1, 0x1A, 0x74, 0x0C, 0xD6, 0x06, 0x7E, 0xAB,
  0x29, 0x92, 0x14, 0x6E, 0xB4, 0x64, 0x30, 0xE5,
  0x67, 0xDC, 0xD2, 0xAB, 0x71, 0xA1, 0xC1, 0x01,
  0x81, 0x5A, 0x1C, 0x8F, 0xA8, 0xE7, 0x87, 0x47,
  0xC7, 0x1C, 0x5A, 0xC9, 0xEE, 0xA1, 0xC1, 0x01,
  0x81, 0x5A, 0x1C, 0x8F, 0xA8, 0xE7, 0x87, 0x47,
  0xC7, 0x1C, 0x5A, 0xC9, 0xEE, 0xA1, 0xC1, 0x01,
  0x81, 0x5A, 0x1C, 0x8F, 0xA8, 0xE7, 0x87, 0x47,
  0xC7, 0x1C, 0x5A, 0xC9, 0xEE, 0xA1, 0xC1, 0x01,
  0x81, 0x5A, 0x1C, 0x8F, 0xA8, 0xE7, 0x87, 0x47,
  0xC7, 0x1C, 0x5A, 0xC9, 0xEE, 0xA1, 0xC1, 0x01,
  0x81, 0x5A, 0x1C, 0x8F, 0xA8, 0xE7, 0x97, 0x40,
  0xC2, 0x79, 0xEB, 0x90, 0x4A, 0x9A, 0xEE, 0x36,
  0xB4, 0x0F, 0x19, 0x62, 0xB8, 0x68, 0x08, 0xC8,
  0x48, 0x93, 0x25, 0x49, 0x91, 0x21, 0x41, 0x81,
  0x01, 0xDA, 0xA0, 0xD4, 0x0C, 0xDC, 0x6C, 0xB4,
  0x34, 0x8F, 0xC1, 0xB4, 0x6C, 0xBC, 0x30, 0xF0,
  0x70, 0xAB, 0x1D, 0x71, 0xA9, 0x19, 0x78, 0xB8,
  0x38, 0xE3, 0x54, 0x38, 0xE1, 0x51, 0x30, 0xF8,
  0x38, 0xE3, 0x54, 0x39, 0xE0, 0x51, 0x70, 0xA0,
  0x24, 0xFD, 0x6A, 0x02, 0xFB, 0x4F, 0x0E, 0x4A,
  0xDA, 0x43, 0xE4, 0x99, 0x50, 0xF1, 0xD8, 0x3A,
  0x9E, 0x67, 0x98, 0xE6, 0x77, 0xD5, 0xFC, 0x6E,
  0xD7, 0x1E, 0xFD, 0x80, 0x0D, 0xAC, 0x99, 0x4C,
  0x99, 0x53, 0x4F, 0x09, 0x7B, 0xE1, 0x2B, 0x41,
  0x6B, 0x9A, 0x79, 0x40, 0xCD, 0x28, 0x1D, 0x88,
  0x5D, 0x53, 0xB0, 0x09, 0x84, 0xE1, 0x2B, 0x01,
  0x2B, 0x1E, 0x02, 0x80, 0xF2, 0xAC, 0x7A, 0x17,
  0x21, 0x17, 0x17, 0x96, 0xF8, 0xA5, 0x73, 0x6E,
  0x35, 0x33, 0x6B, 0xE9, 0xDF, 0x81, 0x3F, 0x84,
  0xEB, 0x8D, 0xE5, 0x72, 0x74, 0x3F, 0xE1, 0xCE,
  0xB5, 0x93, 0xDB, 0x49, 0x6F, 0x21, 0xBF, 0x88,
  0xB7, 0x93, 0xDB, 0x48, 0x6E, 0x21, 0xBE, 0x81,
  0xFE, 0xDA, 0x58, 0x2D, 0xF5, 0x25, 0x7D, 0xA4,
  0x24, 0x9F, 0xD5, 0xA0, 0x78, 0xA8, 0xFC, 0x3C,
  0xBC, 0x67, 0xD1, 0xBD, 0x65, 0xD5, 0xB5, 0x75,
  0xF5, 0x2E, 0x98, 0xF4, 0x2C, 0x9C, 0xFC, 0x3C,
  0xBC, 0x67, 0xF9, 0x9C, 0x44, 0x94, 0xD0, 0x19,
  0x99, 0x22, 0x84, 0x58, 0x82, 0x32, 0x52, 0x88,
  0x08, 0xB3, 0x75, 0x18, 0xC0, 0x70, 0x6C, 0xAB,
  0x2B, 0x90, 0x9A, 0xFB, 0x21, 0xF1, 0xAD, 0x65,
  0xE5, 0x5E, 0xFC, 0x9E, 0x44, 0x94, 0x38, 0xF6,
  0x74, 0xCF, 0xED, 0x87, 0x5F, 0x8F, 0x4B, 0x84,
  0x06, 0xBD, 0x4F, 0x25, 0xFD, 0x2D, 0xC1, 0x0E,
  0x8C, 0x37, 0x71, 0x04, 0xDC, 0x0C, 0xB8, 0x77,
  0xF5, 0x4E, 0x48, 0x35, 0xEF, 0x3F, 0xE7, 0x2F,
  0xAF, 0x14, 0x82, 0xFC, 0x26, 0xF6, 0x2A, 0xED,
  0x6D, 0xD6, 0x34, 0x4A, 0x90, 0x40, 0xE8, 0x3A,
  0xB8, 0x03, 0x5D, 0x37, 0xEF, 0x3F, 0x3B, 0xE3,
  0x61, 0xDA, 0x2C, 0x4A, 0x92, 0x42, 0x14, 0x95,
  0x15, 0x4F, 0x7B, 0x11, 0x78, 0x48, 0x2E, 0xF2,
  0x78, 0x32, 0x05, 0x6F, 0x15, 0xEE, 0x8E, 0xC7,
  0x4E, 0xB0, 0x04, 0x68, 0x55, 0xE1, 0x81, 0xE4,
  0x66, 0xBD, 0xEE, 0x87, 0x5F, 0x0A, 0x62, 0xA2,
  0x07, 0xDF, 0x69, 0xA0, 0x71, 0xC1, 0x00, 0x43,
  0xC5, 0xAF, 0x9D, 0xF7, 0x8A, 0x60, 0x27, 0xFA,
  0x8A, 0x51, 0xD1, 0xFC, 0x24, 0xA5, 0x40, 0x86,
  0x27, 0x7A, 0xCA, 0x8F, 0x84, 0x29, 0xB9, 0x79,
  0xF9, 0x22, 0xA2, 0x8F, 0x57, 0xD6, 0x31, 0xF7,
  0x56, 0x05, 0xB5, 0xF0, 0x6B, 0xC6, 0x56, 0x96,
  0x16, 0xCD, 0x4D, 0x60, 0xB8, 0x39, 0xDC, 0x1A,
  0xBB, 0xE9, 0x59, 0x1C, 0x57, 0xFA, 0x6A, 0xAA,
  0x2A, 0xF1, 0x71, 0x5C, 0x84, 0x15, 0xF8, 0x3E,
  0x8F, 0xD8, 0x68, 0x95, 0xC7, 0x71, 0x90, 0xDB,
  0x5D, 0x0F, 0xF0, 0xB5, 0x6E, 0xC3, 0x53, 0x93,
  0x13, 0xC8, 0x48, 0x65, 0xBD, 0x9C, 0x72, 0xB4,
  0x38, 0xEB, 0xDF, 0xFA, 0x22, 0xF7, 0x96, 0x56,
  0x77, 0x3C, 0x8C, 0x51, 0x0E, 0xB8, 0x19, 0x56,
  0xD0, 0xC2, 0x7F, 0xBA, 0x39, 0x94, 0x04, 0xC4,
  0x44, 0x9F, 0x1F, 0x32, 0xEA, 0x6B, 0x9A, 0x5C,
  0xFD, 0xB4, 0x04, 0x41, 0x8A, 0x27, 0xB7, 0x77,
  0xF7, 0x2C, 0xAC, 0x81, 0x59, 0x68, 0x9C, 0x5A,
  0xEB, 0xA3, 0x13, 0x5E, 0x13, 0xA5, 0xEC, 0x0F,
  0x06, 0x8E, 0x25, 0xB9, 0x61, 0xD1, 0x87, 0x06,
  0x86, 0xCC, 0xEC, 0x86, 0xDF, 0xF8, 0x9E, 0xD7,
  0x7E, 0xC0, 0x76, 0x1A, 0xDF, 0x9F, 0xC9, 0x48,
  0xC8, 0xB2, 0x9C, 0xF6, 0x9C, 0x8C, 0x60, 0x08,
  0x82, 0x79, 0xAE, 0xC2, 0x92, 0x08, 0xD2, 0xA8,
  0xB4, 0x77, 0xCD, 0xBD, 0x69, 0x54, 0xD6, 0x3C,
  0x94, 0x8F, 0x19, 0x75, 0x7F, 0x81, 0xED, 0xEF,
  0x24, 0xD8, 0x4B, 0x80, 0x7B, 0xEB, 0x6D, 0xBE,
  0x2E, 0xD5, 0x63, 0x12, 0x3A, 0x8A, 0xEA, 0x2A,
  0xAA, 0x71, 0xC7, 0xAB, 0x73, 0xC3, 0xA3, 0x63,
  0xE3, 0x38, 0x8F, 0xE3, 0x3F, 0x8F, 0x8B, 0x51,
  0xD3, 0x68,
};

static unsigned char vfs5011_init_16[] = { /* 2565 B */
  0x02, 0xF0, 0x00, 0x14, 0x00, 0x03, 0x00, 0x09,
  0x00, 0x04, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x18, 0x20,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x20, 0x04, 0x30, 0x08,
  0x00, 0x80, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x24, 0x20, 0x04, 0x30, 0x00, 0x00, 0xFF, 0x01,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x2C, 0x20, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x40, 0x20, 0x04, 0x30, 0xFF, 0x03,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x44,
  0x20, 0x04, 0x30, 0xE5, 0x03, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x48, 0x20, 0x04, 0x30,
  0xEA, 0x03, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x4C, 0x20, 0x04, 0x30, 0x0A, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x20,
  0x04, 0x30, 0x01, 0xDE, 0x01, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x00, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x04, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x08, 0x21, 0x04,
  0x30, 0x02, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x0C, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x14, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x18, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x1C, 0x21,
  0x04, 0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x21, 0x04, 0x30, 0x08,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x40, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x44, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x48, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x4C,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x50, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x54, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x58, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x5C, 0x21, 0x04, 0x30, 0x1F,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x60, 0x21, 0x04, 0x30, 0x08, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x80, 0x21, 0x04,
  0x30, 0x30, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x84, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x88,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x8C, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x90, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x94, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x98, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x9C, 0x21, 0x04, 0x30, 0x1F, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xA0, 0x21, 0x04,
  0x30, 0x04, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xC0, 0x21, 0x04, 0x30, 0x30, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xC8, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xCC, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xD0, 0x21,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xD4, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xD8, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xDC, 0x21, 0x04,
  0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xE0, 0x21, 0x04, 0x30, 0x04, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xA0,
  0x20, 0x04, 0x30, 0xEF, 0xE1, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xA4, 0x20, 0x04, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xB0, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4, 0x20,
  0x04, 0x30, 0x14, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xC8, 0x20, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xCC, 0x20, 0x04, 0x30, 0x20, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x50, 0x20, 0x04,
  0x30, 0x00, 0x00, 0x74, 0x01, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xA8, 0x20, 0x04, 0x30, 0xFE, 0x21,
  0x74, 0x01, 0x04, 0x03, 0x00, 0x09, 0x00, 0x04,
  0x00, 0x00, 0x38, 0x00, 0x07, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x08, 0x00, 0x00, 0x38,
  0x00, 0x15, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x0C, 0x00, 0x00, 0x38, 0x01, 0x03, 0x02,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10, 0x00,
  0x00, 0x38, 0x01, 0x07, 0x02, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x14, 0x00, 0x00, 0x38, 0x0C,
  0x0C, 0x05, 0x00, 0x04, 0x02, 0x00, 0x80, 0x05,
  0xFF, 0xF9, 0x87, 0x20, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x07, 0x20,
  0xBA, 0xF8, 0x07, 0x20, 0xB9, 0xF8, 0x07, 0x20,
  0xB8, 0xF8, 0x07, 0x20, 0xB7, 0xF8, 0x07, 0x20,
  0xB6, 0xF8, 0x07, 0x20, 0xB5, 0xF8, 0x07, 0x20,
  0xB4, 0xF8, 0x07, 0x20, 0xB3, 0xF8, 0x07, 0x20,
  0xB2, 0xF8, 0x07, 0x20, 0xB1, 0xF8, 0x07, 0x22,
  0xB0, 0xF8, 0x07, 0x22, 0xAF, 0xF8, 0x07, 0x22,
  0xAE, 0xF8, 0x07, 0x22, 0xAD, 0xF8, 0x07, 0x22,
  0xAC, 0xF8, 0x07, 0x22, 0xAB, 0xF8, 0x07, 0x22,
  0xAA, 0xF8, 0x07, 0x22, 0xA9, 0xF8, 0x07, 0x22,
  0xA8, 0xF8, 0x07, 0x22, 0xA7, 0xF8, 0x07, 0x22,
  0xA6, 0xF8, 0x07, 0x22, 0xA5, 0xF8, 0x07, 0x22,
  0xA4, 0xF8, 0x07, 0x22, 0xA3, 0xF8, 0x07, 0x22,
  0xA2, 0xF8, 0x07, 0x22, 0xA1, 0xF8, 0x07, 0x22,
  0xA0, 0xF8, 0x07, 0x22, 0x9F, 0xF8, 0x07, 0x22,
  0x9E, 0xF8, 0x07, 0x22, 0x9D, 0xF8, 0x07, 0x22,
  0x9C, 0xF8, 0x07, 0x22, 0x9B, 0xF8, 0x07, 0x22,
  0x9A, 0xF8, 0x07, 0x22, 0x99, 0xF8, 0x07, 0x22,
  0x98, 0xF8, 0x07, 0x22, 0x97, 0xF8, 0x07, 0x22,
  0x96, 0xF8, 0x07, 0x22, 0x95, 0xF8, 0x07, 0x22,
  0x94, 0xF8, 0x07, 0x22, 0x93, 0xF8, 0x07, 0x22,
  0x92, 0xF8, 0x07, 0x22, 0x91, 0xF8, 0x07, 0x22,
  0x90, 0xF8, 0x07, 0x22, 0x8F, 0xF8, 0x07, 0x22,
  0x8E, 0xF8, 0x07, 0x22, 0x8D, 0xF8, 0x07, 0x22,
  0x8C, 0xF8, 0x07, 0x22, 0x8B, 0xF8, 0x07, 0x22,
  0x8A, 0xF8, 0x07, 0x22, 0x89, 0xF8, 0x07, 0x22,
  0x88, 0xF8, 0x07, 0x22, 0x87, 0xF8, 0x07, 0x22,
  0x86, 0xF8, 0x07, 0x22, 0x85, 0xF8, 0x07, 0x22,
  0x84, 0xF8, 0x07, 0x22, 0x83, 0xF8, 0x07, 0x22,
  0x82, 0xF8, 0x07, 0x22, 0x81, 0xF8, 0x07, 0x22,
  0x80, 0xF8, 0x07, 0x22, 0x7F, 0xF8, 0x07, 0x22,
  0x7E, 0xF8, 0x07, 0x22, 0x7D, 0xF8, 0x07, 0x22,
  0x7C, 0xF8, 0x07, 0x22, 0x7B, 0xF8, 0x07, 0x22,
  0x7A, 0xF8, 0x07, 0x22, 0x79, 0xF8, 0x07, 0x22,
  0x78, 0xF8, 0x07, 0x22, 0x77, 0xF8, 0x07, 0x22,
  0x76, 0xF8, 0x07, 0x22, 0x75, 0xF8, 0x07, 0x22,
  0x74, 0xF8, 0x07, 0x22, 0x73, 0xF8, 0x07, 0x22,
  0x72, 0xF8, 0x07, 0x22, 0x71, 0xF8, 0x07, 0x22,
  0x70, 0xF8, 0x07, 0x22, 0x6F, 0xF8, 0x07, 0x22,
  0x6E, 0xF8, 0x07, 0x22, 0x6D, 0xF8, 0x07, 0x22,
  0x6C, 0xF8, 0x07, 0x22, 0x6B, 0xF8, 0x07, 0x22,
  0x6A, 0xF8, 0x07, 0x22, 0x69, 0xF8, 0x07, 0x22,
  0x68, 0xF8, 0x07, 0x22, 0x67, 0xF8, 0x07, 0x22,
  0x66, 0xF8, 0x07, 0x22, 0x65, 0xF8, 0x07, 0x22,
  0x64, 0xF8, 0x07, 0x22, 0x63, 0xF8, 0x07, 0x22,
  0x62, 0xF8, 0x07, 0x22, 0x61, 0xF8, 0x07, 0x22,
  0x60, 0xF8, 0x07, 0x22, 0x5F, 0xF8, 0x07, 0x22,
  0x5E, 0xF8, 0x07, 0x22, 0x5D, 0xF8, 0x07, 0x22,
  0x5C, 0xF8, 0x07, 0x22, 0x5B, 0xF8, 0x07, 0x22,
  0x5A, 0xF8, 0x07, 0x22, 0x59, 0xF8, 0x07, 0x22,
  0x58, 0xF8, 0x07, 0x22, 0x57, 0xF8, 0x07, 0x22,
  0x56, 0xF8, 0x07, 0x22, 0x55, 0xF8, 0x07, 0x22,
  0x54, 0xF8, 0x07, 0x22, 0x53, 0xF8, 0x07, 0x22,
  0x52, 0xF8, 0x07, 0x22, 0x51, 0xF8, 0x07, 0x22,
  0x50, 0xF8, 0x07, 0x22, 0x4F, 0xF8, 0x07, 0x22,
  0x4E, 0xF8, 0x07, 0x22, 0x4D, 0xF8, 0x07, 0x22,
  0x4C, 0xF8, 0x07, 0x22, 0x4B, 0xF8, 0x07, 0x22,
  0x4A, 0xF8, 0x07, 0x22, 0x49, 0xF8, 0x07, 0x22,
  0x48, 0xF8, 0x07, 0x22, 0x47, 0xF8, 0x07, 0x22,
  0x46, 0xF8, 0x07, 0x22, 0x45, 0xF8, 0x07, 0x22,
  0x44, 0xF8, 0x07, 0x22, 0x43, 0xF8, 0x07, 0x22,
  0x42, 0xF8, 0x07, 0x22, 0x41, 0xF8, 0x07, 0x22,
  0x40, 0xF8, 0x07, 0x22, 0x3F, 0xF8, 0x07, 0x22,
  0x3E, 0xF8, 0x07, 0x22, 0x3D, 0xF8, 0x07, 0x22,
  0x3C, 0xF8, 0x07, 0x22, 0x3B, 0xF8, 0x07, 0x22,
  0x3A, 0xF8, 0x07, 0x22, 0x39, 0xF8, 0x07, 0x22,
  0x38, 0xF8, 0x07, 0x22, 0x37, 0xF8, 0x07, 0x22,
  0x36, 0xF8, 0x07, 0x22, 0x35, 0xF8, 0x07, 0x22,
  0x34, 0xF8, 0x07, 0x22, 0x33, 0xF8, 0x07, 0x22,
  0x32, 0xF8, 0x07, 0x22, 0x31, 0xF8, 0x07, 0x22,
  0x30, 0xF8, 0x07, 0x22, 0x2F, 0xF8, 0x07, 0x22,
  0x2E, 0xF8, 0x07, 0x22, 0x2D, 0xF8, 0x07, 0x22,
  0x2C, 0xF8, 0x07, 0x22, 0x2B, 0xF8, 0x07, 0x22,
  0x2A, 0xF8, 0x07, 0x22, 0x29, 0xF8, 0x07, 0x22,
  0x28, 0xF8, 0x07, 0x22, 0x27, 0xF8, 0x07, 0x22,
  0x26, 0xF8, 0x07, 0x22, 0x25, 0xF8, 0x07, 0x22,
  0x24, 0xF8, 0x07, 0x22, 0x23, 0xF8, 0x07, 0x20,
  0x22, 0xF8, 0x07, 0x20, 0x21, 0xF8, 0x07, 0x20,
  0x20, 0xF8, 0x07, 0x20, 0x1F, 0xF8, 0x07, 0x20,
  0x1E, 0xF8, 0x07, 0x20, 0x1D, 0xF8, 0x07, 0x20,
  0x1C, 0xF8, 0x07, 0x20, 0x1C, 0xF8, 0x07, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD8, 0xF8, 0x27, 0x20, 0xD9, 0xF8, 0x27, 0x20,
  0xDA, 0xF8, 0x27, 0x20, 0xDB, 0xF8, 0x27, 0x20,
  0xDC, 0xF8, 0x27, 0x20, 0xDD, 0xF8, 0x27, 0x20,
  0xDE, 0xF8, 0x27, 0x20, 0xDF, 0xF8, 0x27, 0x20,
  0xE0, 0xF8, 0x27, 0x20, 0xE1, 0xF8, 0x27, 0x20,
  0xE2, 0xF8, 0x27, 0x20, 0xE3, 0xF8, 0x27, 0x20,
  0xE4, 0xF8, 0x27, 0x20, 0xE5, 0xF8, 0x27, 0x20,
  0xE6, 0xF8, 0x27, 0x20, 0xE7, 0xF8, 0x27, 0x20,
  0xE8, 0xF8, 0x27, 0x20, 0xE9, 0xF8, 0x27, 0x20,
  0xEA, 0xF8, 0x27, 0x20, 0xEB, 0xF8, 0x27, 0x20,
  0xEC, 0xF8, 0x27, 0x20, 0xED, 0xF8, 0x27, 0x20,
  0xEE, 0xF8, 0x27, 0x20, 0xEF, 0xF8, 0x27, 0x20,
  0xF0, 0xF8, 0x27, 0x20, 0xF1, 0xF8, 0x27, 0x20,
  0xF2, 0xF8, 0x27, 0x20, 0xF3, 0xF8, 0x27, 0x20,
  0xF4, 0xF8, 0x27, 0x20, 0xF5, 0xF8, 0x27, 0x20,
  0xF6, 0xF8, 0x27, 0x20, 0xF7, 0xF8, 0x27, 0x20,
  0xF8, 0xF8, 0x27, 0x20, 0xF9, 0xF8, 0x27, 0x20,
  0xFA, 0xF8, 0x27, 0x20, 0xFB, 0xF8, 0x27, 0x20,
  0xFC, 0xF8, 0x27, 0x20, 0xFD, 0xF8, 0x27, 0x20,
  0xFE, 0xF8, 0x27, 0x20, 0xFF, 0xF8, 0x27, 0x20,
  0x00, 0xF9, 0x27, 0x20, 0xD7, 0xF8, 0x27, 0x20,
  0x00, 0xF8, 0x27, 0x20, 0x01, 0xF8, 0x27, 0x20,
  0x02, 0xF8, 0x27, 0x20, 0x03, 0xF8, 0x27, 0x20,
  0x04, 0xF8, 0x27, 0x20, 0x05, 0xF8, 0x27, 0x20,
  0x06, 0xF8, 0x27, 0x20, 0x07, 0xF8, 0x27, 0x20,
  0x08, 0xF8, 0x27, 0x20, 0x09, 0xF8, 0x27, 0x20,
  0x0A, 0xF8, 0x27, 0x20, 0x0B, 0xF8, 0x27, 0x20,
  0x0C, 0xF8, 0x27, 0x20, 0x0D, 0xF8, 0x27, 0x20,
  0x0E, 0xF8, 0x27, 0x20, 0x0F, 0xF8, 0x27, 0x20,
  0x10, 0xF8, 0x27, 0x20, 0x11, 0xF8, 0x27, 0x20,
  0x12, 0xF8, 0x27, 0x20, 0x13, 0xF8, 0x27, 0x20,
  0x14, 0xF8, 0x27, 0x20, 0x15, 0xF8, 0x27, 0x20,
  0x15, 0xF8, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x00, 0x08, 0x00, 0x10, 0x03, 0x18, 0x1C,
  0x10, 0x03, 0x18, 0x1C, 0x03, 0x00, 0x09, 0x00,
  0x00, 0x20, 0x04, 0x30, 0x80, 0x00, 0x00, 0x00,
  0x04, 0x17, 0x00, 0x00, 0x00, 0x05, 0x00, 0x0E,
  0x00, 0x0C, 0x20, 0xFD, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x02, 0x08, 0x00, 0x00, 0x05,
  0x00, 0x0E, 0x00, 0x10, 0x20, 0xFD, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00,
  0x00, 0x03, 0x00, 0x09, 0x00, 0x04, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x08, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x0C,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x10, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x14, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x18, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x44, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x48, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x4C, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x50, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x54,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x58, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xC8, 0x20, 0x04, 0x30, 0x04, 0x00, 0x00,
  0x00, 0x04, 0x05, 0x00, 0x0E, 0x00, 0x14, 0x20,
  0xFF, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x83, 0x00, 0x03, 0x00, 0x09, 0x00,
  0x84, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x88, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x8C, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x90,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x94, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x98, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xA0, 0x21,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x21, 0x04, 0x30, 0x08,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x60, 0x21, 0x04, 0x30, 0x08, 0x00, 0x00, 0x00,
  0x04, 0x15, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x20, 0x28, 0x00, 0x00,
};

static unsigned char vfs5011_init_17[] = { /* 117 B */
  0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0xFF, 0x00, 0x00, 0xFF, 0xF4, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
  0x00, 0x00, 0x00, 0xF4, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x20, 0xBF, 0x02, 0x00,
};

static unsigned char vfs5011_init_18[] = { /* 2903 B */
  0x02, 0xF0, 0x00, 0x00, 0x00, 0x03, 0x00, 0x09,
  0x00, 0x04, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x18, 0x20,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x20, 0x04, 0x30, 0x08,
  0x00, 0x80, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x24, 0x20, 0x04, 0x30, 0x00, 0x00, 0xFF, 0x01,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x2C, 0x20, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x40, 0x20, 0x04, 0x30, 0xFF, 0x03,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x44,
  0x20, 0x04, 0x30, 0xE5, 0x03, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x48, 0x20, 0x04, 0x30,
  0xEA, 0x03, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x4C, 0x20, 0x04, 0x30, 0x0A, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x20,
  0x04, 0x30, 0x01, 0xDE, 0x01, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x00, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x04, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x08, 0x21, 0x04,
  0x30, 0x02, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x0C, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x14, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x18, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x1C, 0x21,
  0x04, 0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x21, 0x04, 0x30, 0x08,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x40, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x44, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x48, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x4C,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x50, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x54, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x58, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x5C, 0x21, 0x04, 0x30, 0x1F,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x60, 0x21, 0x04, 0x30, 0x08, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x80, 0x21, 0x04,
  0x30, 0x30, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x84, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x88,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x8C, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x90, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x94, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x98, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x9C, 0x21, 0x04, 0x30, 0x1F, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xA0, 0x21, 0x04,
  0x30, 0x04, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xC0, 0x21, 0x04, 0x30, 0x30, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xC8, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xCC, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xD0, 0x21,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xD4, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xD8, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xDC, 0x21, 0x04,
  0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xE0, 0x21, 0x04, 0x30, 0x04, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xA0,
  0x20, 0x04, 0x30, 0xEF, 0xE1, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xA4, 0x20, 0x04, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xB0, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4, 0x20,
  0x04, 0x30, 0x14, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xC8, 0x20, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xCC, 0x20, 0x04, 0x30, 0x20, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x50, 0x20, 0x04,
  0x30, 0x00, 0x00, 0x74, 0x01, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xA8, 0x20, 0x04, 0x30, 0xFE, 0x21,
  0x74, 0x01, 0x04, 0x03, 0x00, 0x09, 0x00, 0x04,
  0x00, 0x00, 0x38, 0x00, 0x07, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x08, 0x00, 0x00, 0x38,
  0x00, 0x15, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x0C, 0x00, 0x00, 0x38, 0x01, 0x03, 0x02,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10, 0x00,
  0x00, 0x38, 0x01, 0x07, 0x02, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x14, 0x00, 0x00, 0x38, 0x0C,
  0x0C, 0x05, 0x00, 0x04, 0x02, 0x00, 0x80, 0x05,
  0xFF, 0xF9, 0x87, 0x20, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x07, 0x20,
  0xBA, 0xF8, 0x07, 0x20, 0xB9, 0xF8, 0x07, 0x20,
  0xB8, 0xF8, 0x07, 0x20, 0xB7, 0xF8, 0x07, 0x20,
  0xB6, 0xF8, 0x07, 0x20, 0xB5, 0xF8, 0x07, 0x20,
  0xB4, 0xF8, 0x07, 0x20, 0xB3, 0xF8, 0x07, 0x20,
  0xB2, 0xF8, 0x07, 0x20, 0xB1, 0xF8, 0x07, 0x22,
  0xB0, 0xF8, 0x07, 0x22, 0xAF, 0xF8, 0x07, 0x22,
  0xAE, 0xF8, 0x07, 0x22, 0xAD, 0xF8, 0x07, 0x22,
  0xAC, 0xF8, 0x07, 0x22, 0xAB, 0xF8, 0x07, 0x22,
  0xAA, 0xF8, 0x07, 0x22, 0xA9, 0xF8, 0x07, 0x22,
  0xA8, 0xF8, 0x07, 0x22, 0xA7, 0xF8, 0x07, 0x22,
  0xA6, 0xF8, 0x07, 0x22, 0xA5, 0xF8, 0x07, 0x22,
  0xA4, 0xF8, 0x07, 0x22, 0xA3, 0xF8, 0x07, 0x22,
  0xA2, 0xF8, 0x07, 0x22, 0xA1, 0xF8, 0x07, 0x22,
  0xA0, 0xF8, 0x07, 0x22, 0x9F, 0xF8, 0x07, 0x22,
  0x9E, 0xF8, 0x07, 0x22, 0x9D, 0xF8, 0x07, 0x22,
  0x9C, 0xF8, 0x07, 0x22, 0x9B, 0xF8, 0x07, 0x22,
  0x9A, 0xF8, 0x07, 0x22, 0x99, 0xF8, 0x07, 0x22,
  0x98, 0xF8, 0x07, 0x22, 0x97, 0xF8, 0x07, 0x22,
  0x96, 0xF8, 0x07, 0x22, 0x95, 0xF8, 0x07, 0x22,
  0x94, 0xF8, 0x07, 0x22, 0x93, 0xF8, 0x07, 0x22,
  0x92, 0xF8, 0x07, 0x22, 0x91, 0xF8, 0x07, 0x22,
  0x90, 0xF8, 0x07, 0x22, 0x8F, 0xF8, 0x07, 0x22,
  0x8E, 0xF8, 0x07, 0x22, 0x8D, 0xF8, 0x07, 0x22,
  0x8C, 0xF8, 0x07, 0x22, 0x8B, 0xF8, 0x07, 0x22,
  0x8A, 0xF8, 0x07, 0x22, 0x89, 0xF8, 0x07, 0x22,
  0x88, 0xF8, 0x07, 0x22, 0x87, 0xF8, 0x07, 0x22,
  0x86, 0xF8, 0x07, 0x22, 0x85, 0xF8, 0x07, 0x22,
  0x84, 0xF8, 0x07, 0x22, 0x83, 0xF8, 0x07, 0x22,
  0x82, 0xF8, 0x07, 0x22, 0x81, 0xF8, 0x07, 0x22,
  0x80, 0xF8, 0x07, 0x22, 0x7F, 0xF8, 0x07, 0x22,
  0x7E, 0xF8, 0x07, 0x22, 0x7D, 0xF8, 0x07, 0x22,
  0x7C, 0xF8, 0x07, 0x22, 0x7B, 0xF8, 0x07, 0x22,
  0x7A, 0xF8, 0x07, 0x22, 0x79, 0xF8, 0x07, 0x22,
  0x78, 0xF8, 0x07, 0x22, 0x77, 0xF8, 0x07, 0x22,
  0x76, 0xF8, 0x07, 0x22, 0x75, 0xF8, 0x07, 0x22,
  0x74, 0xF8, 0x07, 0x22, 0x73, 0xF8, 0x07, 0x22,
  0x72, 0xF8, 0x07, 0x22, 0x71, 0xF8, 0x07, 0x22,
  0x70, 0xF8, 0x07, 0x22, 0x6F, 0xF8, 0x07, 0x22,
  0x6E, 0xF8, 0x07, 0x22, 0x6D, 0xF8, 0x07, 0x22,
  0x6C, 0xF8, 0x07, 0x22, 0x6B, 0xF8, 0x07, 0x22,
  0x6A, 0xF8, 0x07, 0x22, 0x69, 0xF8, 0x07, 0x22,
  0x68, 0xF8, 0x07, 0x22, 0x67, 0xF8, 0x07, 0x22,
  0x66, 0xF8, 0x07, 0x22, 0x65, 0xF8, 0x07, 0x22,
  0x64, 0xF8, 0x07, 0x22, 0x63, 0xF8, 0x07, 0x22,
  0x62, 0xF8, 0x07, 0x22, 0x61, 0xF8, 0x07, 0x22,
  0x60, 0xF8, 0x07, 0x22, 0x5F, 0xF8, 0x07, 0x22,
  0x5E, 0xF8, 0x07, 0x22, 0x5D, 0xF8, 0x07, 0x22,
  0x5C, 0xF8, 0x07, 0x22, 0x5B, 0xF8, 0x07, 0x22,
  0x5A, 0xF8, 0x07, 0x22, 0x59, 0xF8, 0x07, 0x22,
  0x58, 0xF8, 0x07, 0x22, 0x57, 0xF8, 0x07, 0x22,
  0x56, 0xF8, 0x07, 0x22, 0x55, 0xF8, 0x07, 0x22,
  0x54, 0xF8, 0x07, 0x22, 0x53, 0xF8, 0x07, 0x22,
  0x52, 0xF8, 0x07, 0x22, 0x51, 0xF8, 0x07, 0x22,
  0x50, 0xF8, 0x07, 0x22, 0x4F, 0xF8, 0x07, 0x22,
  0x4E, 0xF8, 0x07, 0x22, 0x4D, 0xF8, 0x07, 0x22,
  0x4C, 0xF8, 0x07, 0x22, 0x4B, 0xF8, 0x07, 0x22,
  0x4A, 0xF8, 0x07, 0x22, 0x49, 0xF8, 0x07, 0x22,
  0x48, 0xF8, 0x07, 0x22, 0x47, 0xF8, 0x07, 0x22,
  0x46, 0xF8, 0x07, 0x22, 0x45, 0xF8, 0x07, 0x22,
  0x44, 0xF8, 0x07, 0x22, 0x43, 0xF8, 0x07, 0x22,
  0x42, 0xF8, 0x07, 0x22, 0x41, 0xF8, 0x07, 0x22,
  0x40, 0xF8, 0x07, 0x22, 0x3F, 0xF8, 0x07, 0x22,
  0x3E, 0xF8, 0x07, 0x22, 0x3D, 0xF8, 0x07, 0x22,
  0x3C, 0xF8, 0x07, 0x22, 0x3B, 0xF8, 0x07, 0x22,
  0x3A, 0xF8, 0x07, 0x22, 0x39, 0xF8, 0x07, 0x22,
  0x38, 0xF8, 0x07, 0x22, 0x37, 0xF8, 0x07, 0x22,
  0x36, 0xF8, 0x07, 0x22, 0x35, 0xF8, 0x07, 0x22,
  0x34, 0xF8, 0x07, 0x22, 0x33, 0xF8, 0x07, 0x22,
  0x32, 0xF8, 0x07, 0x22, 0x31, 0xF8, 0x07, 0x22,
  0x30, 0xF8, 0x07, 0x22, 0x2F, 0xF8, 0x07, 0x22,
  0x2E, 0xF8, 0x07, 0x22, 0x2D, 0xF8, 0x07, 0x22,
  0x2C, 0xF8, 0x07, 0x22, 0x2B, 0xF8, 0x07, 0x22,
  0x2A, 0xF8, 0x07, 0x22, 0x29, 0xF8, 0x07, 0x22,
  0x28, 0xF8, 0x07, 0x22, 0x27, 0xF8, 0x07, 0x22,
  0x26, 0xF8, 0x07, 0x22, 0x25, 0xF8, 0x07, 0x22,
  0x24, 0xF8, 0x07, 0x22, 0x23, 0xF8, 0x07, 0x20,
  0x22, 0xF8, 0x07, 0x20, 0x21, 0xF8, 0x07, 0x20,
  0x20, 0xF8, 0x07, 0x20, 0x1F, 0xF8, 0x07, 0x20,
  0x1E, 0xF8, 0x07, 0x20, 0x1D, 0xF8, 0x07, 0x20,
  0x1C, 0xF8, 0x07, 0x20, 0x1C, 0xF8, 0x07, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD8, 0xF8, 0x27, 0x20, 0xD9, 0xF8, 0x27, 0x20,
  0xDA, 0xF8, 0x27, 0x20, 0xDB, 0xF8, 0x27, 0x20,
  0xDC, 0xF8, 0x27, 0x20, 0xDD, 0xF8, 0x27, 0x20,
  0xDE, 0xF8, 0x27, 0x20, 0xDF, 0xF8, 0x27, 0x20,
  0xE0, 0xF8, 0x27, 0x20, 0xE1, 0xF8, 0x27, 0x20,
  0xE2, 0xF8, 0x27, 0x20, 0xE3, 0xF8, 0x27, 0x20,
  0xE4, 0xF8, 0x27, 0x20, 0xE5, 0xF8, 0x27, 0x20,
  0xE6, 0xF8, 0x27, 0x20, 0xE7, 0xF8, 0x27, 0x20,
  0xE8, 0xF8, 0x27, 0x20, 0xE9, 0xF8, 0x27, 0x20,
  0xEA, 0xF8, 0x27, 0x20, 0xEB, 0xF8, 0x27, 0x20,
  0xEC, 0xF8, 0x27, 0x20, 0xED, 0xF8, 0x27, 0x20,
  0xEE, 0xF8, 0x27, 0x20, 0xEF, 0xF8, 0x27, 0x20,
  0xF0, 0xF8, 0x27, 0x20, 0xF1, 0xF8, 0x27, 0x20,
  0xF2, 0xF8, 0x27, 0x20, 0xF3, 0xF8, 0x27, 0x20,
  0xF4, 0xF8, 0x27, 0x20, 0xF5, 0xF8, 0x27, 0x20,
  0xF6, 0xF8, 0x27, 0x20, 0xF7, 0xF8, 0x27, 0x20,
  0xF8, 0xF8, 0x27, 0x20, 0xF9, 0xF8, 0x27, 0x20,
  0xFA, 0xF8, 0x27, 0x20, 0xFB, 0xF8, 0x27, 0x20,
  0xFC, 0xF8, 0x27, 0x20, 0xFD, 0xF8, 0x27, 0x20,
  0xFE, 0xF8, 0x27, 0x20, 0xFF, 0xF8, 0x27, 0x20,
  0x00, 0xF9, 0x27, 0x20, 0xD7, 0xF8, 0x27, 0x20,
  0x00, 0xF8, 0x27, 0x20, 0x01, 0xF8, 0x27, 0x20,
  0x02, 0xF8, 0x27, 0x20, 0x03, 0xF8, 0x27, 0x20,
  0x04, 0xF8, 0x27, 0x20, 0x05, 0xF8, 0x27, 0x20,
  0x06, 0xF8, 0x27, 0x20, 0x07, 0xF8, 0x27, 0x20,
  0x08, 0xF8, 0x27, 0x20, 0x09, 0xF8, 0x27, 0x20,
  0x0A, 0xF8, 0x27, 0x20, 0x0B, 0xF8, 0x27, 0x20,
  0x0C, 0xF8, 0x27, 0x20, 0x0D, 0xF8, 0x27, 0x20,
  0x0E, 0xF8, 0x27, 0x20, 0x0F, 0xF8, 0x27, 0x20,
  0x10, 0xF8, 0x27, 0x20, 0x11, 0xF8, 0x27, 0x20,
  0x12, 0xF8, 0x27, 0x20, 0x13, 0xF8, 0x27, 0x20,
  0x14, 0xF8, 0x27, 0x20, 0x15, 0xF8, 0x27, 0x20,
  0x15, 0xF8, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x00, 0x08, 0x00, 0x10, 0x03, 0x18, 0x1C,
  0x10, 0x03, 0x18, 0x1C, 0x03, 0x00, 0x09, 0x00,
  0x00, 0x20, 0x04, 0x30, 0x80, 0x00, 0x00, 0x00,
  0x04, 0x05, 0x00, 0x0E, 0x00, 0x0C, 0x20, 0xFD,
  0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x02,
  0x08, 0x00, 0x00, 0x05, 0x00, 0x0E, 0x00, 0x10,
  0x20, 0xFD, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x05, 0x00, 0x00, 0x03, 0x00, 0x09,
  0x00, 0x04, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x08, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x0C, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x10, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x14, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x18, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x44,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x48, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x4C, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x50, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x54, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x58, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xC8, 0x20, 0x04,
  0x30, 0x04, 0x00, 0x00, 0x00, 0x04, 0x05, 0x00,
  0x0E, 0x00, 0x14, 0x20, 0xFF, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0x00,
  0x03, 0x00, 0x09, 0x00, 0x84, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x88, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x8C, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x90, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x94, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x98, 0x21, 0x04,
  0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xA0, 0x21, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x20,
  0x21, 0x04, 0x30, 0x08, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x60, 0x21, 0x04, 0x30,
  0x08, 0x00, 0x00, 0x00, 0x04, 0x15, 0x00, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x28, 0x00,
  0x00, 0x18, 0x00, 0x52, 0x01, 0x08, 0x00, 0x05,
  0x00, 0x0A, 0x00, 0xFA, 0x00, 0x1E, 0x00, 0xC8,
  0x00, 0x00, 0x00, 0x9F, 0x00, 0x38, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x03, 0xFF, 0xF9, 0xFD, 0xFE, 0xFE, 0x00, 0xFD,
  0x02, 0x03, 0x02, 0x01, 0x01, 0xFF, 0x03, 0x06,
  0x0C, 0x08, 0x08, 0x0C, 0x06, 0x0A, 0x0B, 0x06,
  0x0B, 0x0A, 0x0C, 0x0A, 0x0A, 0x07, 0x02, 0x05,
  0x07, 0x06, 0x0A, 0x09, 0x09, 0x0C, 0x0C, 0x11,
  0x0B, 0x0D, 0x08, 0x07, 0x09, 0x09, 0x09, 0x08,
  0x06, 0x09, 0xFE, 0xFF, 0xFF, 0x01, 0x06, 0x01,
  0xFD, 0xFB, 0x00, 0x01, 0x04, 0x01, 0x02, 0x05,
  0x04, 0x00, 0x02, 0x02, 0x05, 0x07, 0x05, 0x03,
  0x05, 0x02, 0x0A, 0x06, 0x03, 0x04, 0x00, 0x01,
  0x02, 0x04, 0x01, 0x01, 0xFA, 0xF7, 0xFA, 0xF9,
  0xF6, 0xF7, 0xFD, 0xFE, 0x02, 0xFE, 0xFC, 0xF7,
  0xF9, 0xFB, 0xF7, 0xFB, 0xF5, 0xF8, 0xF8, 0xF9,
  0xEF, 0xEE, 0xF2, 0xEF, 0xF0, 0xED, 0xF2, 0xF7,
  0xF9, 0xFA, 0xF6, 0xF6, 0xF5, 0xF4, 0xF3, 0xEF,
  0xF1, 0xF5, 0xF4, 0xF1, 0xF5, 0xFA, 0xF8, 0xFA,
  0xF9, 0xFA, 0xFE, 0x01, 0x02, 0xFE, 0xFE, 0x03,
  0x01, 0xFC, 0xF9, 0xF7, 0xF6, 0xF4, 0xF9, 0xF7,
  0xF7, 0xF5, 0xF7, 0xFA, 0xFB, 0x00, 0xFC, 0xFD,
  0xFD, 0xF6, 0xF2, 0xF4, 0xED, 0xDC, 0xCE, 0xFF,
  0x05, 0x07, 0x08, 0x0E, 0x0E, 0x0F, 0x0A, 0x0C,
  0x06, 0x05, 0x05, 0xF6, 0xF2, 0xF1, 0xEF, 0xF4,
  0xF6, 0xF4, 0xF5, 0xF6, 0xF7, 0xF5, 0xF8, 0xF8,
  0xF8, 0xF2, 0xF7, 0xF3, 0xF0, 0xF3, 0xF5, 0xFD,
  0xFB, 0xFC, 0xF9, 0xF9, 0xFC, 0xFA, 0xF8, 0xFD,
  0x0B, 0x1C, 0x17, 0x13, 0x14, 0x0F, 0x0D, 0x0C,
  0x0B, 0x0B, 0x0F, 0x0C, 0x0E, 0x10, 0x0E, 0x11,
  0x12, 0x14, 0x1C, 0x1C, 0x20, 0x20, 0x24, 0xF4,
  0xF6, 0xF4, 0xF5, 0xF6, 0xF7, 0xF5, 0xF8, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
};

static unsigned char vfs5011_cmd_04[] = { /* 1 B */
  0x04,
};

static unsigned char vfs5011_prepare_00[] = { /* 578 B */
  0x06, 0x9C, 0xF1, 0x9D, 0x71, 0xC3, 0x13, 0xDF,
  0x5F, 0xE4, 0x7A, 0x1F, 0xC7, 0x17, 0x53, 0x9A,
  0x1A, 0xA1, 0xD7, 0xB6, 0x6E, 0xBE, 0xDF, 0x1F,
  0x9F, 0x44, 0x42, 0x22, 0xFA, 0x2A, 0x6A, 0xAB,
  0x2B, 0xF0, 0x56, 0x39, 0xE3, 0x7B, 0x53, 0x9A,
  0x1A, 0xA1, 0xDB, 0xBA, 0x62, 0xB2, 0xE4, 0x65,
  0xE5, 0xDB, 0x68, 0x04, 0x79, 0x98, 0xDE, 0x8F,
  0x23, 0xFB, 0xEC, 0xAD, 0x76, 0xCA, 0xA2, 0xEB,
  0x61, 0x38, 0xC7, 0xAB, 0x6E, 0x2E, 0x78, 0xF9,
  0x79, 0x13, 0x8A, 0xE5, 0x90, 0x22, 0x63, 0x8D,
  0x0E, 0x93, 0x25, 0x49, 0x5A, 0xC8, 0xA3, 0xD8,
  0x7E, 0xAE, 0x12, 0xF6, 0x2C, 0x1C, 0xFC, 0x48,
  0x4F, 0x0E, 0x48, 0x22, 0xFB, 0x4B, 0xCE, 0x7E,
  0xDB, 0x2D, 0x91, 0xE0, 0xC8, 0x78, 0x2E, 0xAF,
  0x2F, 0xD4, 0x03, 0x6F, 0x12, 0x59, 0xC6, 0x26,
  0x40, 0x88, 0x2E, 0x62, 0xBA, 0x06, 0x6C, 0xC9,
  0x7A, 0x84, 0x93, 0xCF, 0x14, 0x15, 0x44, 0x87,
  0xE2, 0x09, 0x97, 0xE6, 0xCE, 0x7E, 0x28, 0xA9,
  0x29, 0x53, 0xD7, 0xB8, 0xD1, 0x53, 0x30, 0x15,
  0x6E, 0x95, 0x3E, 0xA2, 0x7A, 0xCA, 0x9C, 0x1D,
  0x9D, 0xEB, 0x5F, 0x15, 0xEF, 0x48, 0x34, 0xCC,
  0xCB, 0x02, 0xA6, 0xD6, 0xA7, 0x80, 0xF2, 0x3F,
  0x7E, 0x96, 0x23, 0xAE, 0x42, 0xF1, 0x29, 0xF5,
  0xAD, 0x5A, 0x35, 0x57, 0x36, 0xAA, 0xAF, 0x97,
  0xE8, 0x1E, 0xA2, 0xD3, 0xFB, 0x4B, 0x1D, 0x9C,
  0x1C, 0x06, 0x84, 0xEB, 0x9E, 0x2C, 0xD4, 0x18,
  0x94, 0x44, 0x7E, 0x4B, 0x12, 0x91, 0xF2, 0x8B,
  0x07, 0x45, 0xDB, 0x52, 0xBB, 0x2E, 0x53, 0x63,
  0xE3, 0x38, 0xB8, 0x95, 0x4D, 0x9B, 0xCF, 0x07,
  0x05, 0xDD, 0x4C, 0xE2, 0x39, 0xAF, 0xA9, 0x51,
  0xDB, 0xAD, 0x19, 0xC8, 0x13, 0x6E, 0x0A, 0x2F,
  0xEA, 0x12, 0xB9, 0x25, 0x55, 0xB6, 0x64, 0x04,
  0x7F, 0x14, 0x6E, 0x12, 0x08, 0xFB, 0xBD, 0xBD,
  0x1D, 0xC6, 0xE2, 0x84, 0x50, 0x20, 0x60, 0xA0,
  0x90, 0xD2, 0x74, 0x8A, 0x18, 0xA4, 0xD9, 0xE9,
  0x69, 0xB2, 0x1E, 0x73, 0xAB, 0x1B, 0x7B, 0xBB,
  0x3B, 0xE0, 0x42, 0x23, 0xF9, 0x29, 0x49, 0x89,
  0x09, 0xD2, 0x4C, 0x29, 0xF1, 0x21, 0x65, 0xAC,
  0x2C, 0x97, 0x30, 0x6C, 0xB4, 0x04, 0xF4, 0x3D,
  0xBD, 0x06, 0xA0, 0xC6, 0x1E, 0xCE, 0x7E, 0xB3,
  0x33, 0x88, 0x2E, 0x43, 0x9B, 0x2B, 0x37, 0xF0,
  0x70, 0xCB, 0x91, 0xF1, 0x2B, 0xFB, 0x8B, 0x48,
  0xCA, 0x39, 0x97, 0xFB, 0x21, 0xB9, 0xCD, 0x0E,
  0x8C, 0x7F, 0x8D, 0xEC, 0x36, 0xE6, 0xEA, 0x27,
  0xA5, 0x1E, 0x40, 0x2A, 0xF2, 0x22, 0xCA, 0x07,
  0x85, 0x3E, 0xC8, 0xAE, 0x76, 0xA6, 0xF0, 0x71,
  0xF1, 0xAB, 0x6B, 0x04, 0x6D, 0xA9, 0xCA, 0x06,
  0x2C, 0x66, 0xA5, 0xCA, 0xB0, 0x4B, 0x2B, 0x62,
  0xEB, 0xD5, 0x61, 0x0D, 0xF0, 0x46, 0x26, 0xC3,
  0x44, 0x9F, 0x0C, 0x63, 0xBB, 0xAA, 0xBD, 0x7E,
  0xF2, 0x74, 0x00, 0x66, 0x2B, 0x7A, 0x62, 0xA1,
  0x07, 0x80, 0x33, 0x8D, 0x1F, 0xF7, 0x45, 0xCB,
  0x5E, 0x24, 0xEB, 0x84, 0xED, 0x27, 0x44, 0x61,
  0xFF, 0x0C, 0xA7, 0x3B, 0xE3, 0x53, 0x05, 0x84,
  0x04, 0xEE, 0x23, 0x4C, 0xB5, 0x79, 0x1A, 0xF3,
  0xA0, 0x66, 0x20, 0x4C, 0x94, 0x24, 0x72, 0xF3,
  0x73, 0x39, 0xF8, 0x97, 0xDD, 0x64, 0x54, 0xF2,
  0x6B, 0xBA, 0xAD, 0xBC, 0x67, 0x66, 0x78, 0xBB,
  0x5E, 0x6D, 0xFB, 0x8A, 0xA2, 0x74, 0x3D, 0xF5,
  0xD4, 0x72, 0xC7, 0x1A, 0xBD, 0x0E, 0x0B, 0x2C,
  0x8C, 0x4A, 0x0C, 0x60, 0xB8, 0x08, 0x5E, 0xDF,
  0x5F, 0x05, 0x33, 0x5C, 0xB5, 0x7E, 0x1D, 0xFC,
  0xFD, 0x25, 0xBA, 0x95, 0xC4, 0xA7, 0xDA, 0xEA,
  0x6A, 0xB1, 0x31, 0x1C, 0xC4, 0xE5, 0x07, 0xC4,
  0xC5, 0x9D, 0x28, 0xCD, 0x3C, 0xE9, 0x89, 0x49,
  0xD4, 0xFF, 0x7F, 0x52, 0x8A, 0x9B, 0x7F, 0xBC,
  0x8E, 0xF5, 0xCF, 0x0B, 0xD9, 0x49, 0x48, 0x88,
  0x80, 0x71, 0x7D, 0xAB, 0xEF, 0x47, 0x2B, 0xF7,
  0x7B, 0x2D, 0x79, 0x3F, 0xCF, 0xBF, 0xFF, 0x3F,
  0x6D, 0xF8, 0x42, 0xEC, 0x7F, 0xE8, 0xED, 0x42,
  0xE6, 0x1D, 0x4D, 0x32, 0xFA, 0x6A, 0x0A, 0xD7,
  0xA7, 0x7C, 0xCB, 0xA7, 0x7B, 0xCB, 0xBF, 0x71,
  0xF3, 0x48,
};

static unsigned char vfs5011_prepare_01[] = { /* 3794 B */
  0x06, 0x6B, 0x06, 0x6A, 0x76, 0xC8, 0x18, 0xD4,
  0x54, 0xEF, 0x71, 0x14, 0xCC, 0x1C, 0x58, 0x91,
  0x11, 0xAA, 0x80, 0xF4, 0x2C, 0xFC, 0x9F, 0x5F,
  0xDF, 0x04, 0x02, 0x62, 0xBA, 0x6A, 0x5A, 0x97,
  0x17, 0xCC, 0x46, 0x22, 0xFA, 0x2A, 0xBE, 0x03,
  0x87, 0x3C, 0x9E, 0xFE, 0x26, 0xF6, 0x96, 0x7E,
  0xFA, 0x11, 0x27, 0x66, 0xBA, 0x3A, 0x5A, 0xBA,
  0x3E, 0xD5, 0x4F, 0x03, 0xDF, 0x5F, 0x7F, 0x9F,
  0x1B, 0xF0, 0xA2, 0xEF, 0x33, 0xB3, 0xD3, 0x13,
  0x93, 0x70, 0xFA, 0x96, 0x4E, 0xC6, 0xA6, 0xC6,
  0x46, 0xA5, 0x2F, 0xE3, 0x3B, 0xB3, 0xD3, 0x33,
  0xB3, 0x50, 0xE8, 0xA4, 0x7C, 0xF4, 0x94, 0x14,
  0x94, 0x77, 0xC9, 0xE5, 0x3D, 0xB5, 0xD5, 0x75,
  0xF5, 0x16, 0xA8, 0xA4, 0x7C, 0xF4, 0x94, 0xD4,
  0x54, 0xB7, 0x09, 0xE5, 0x3D, 0xB5, 0x2D, 0xF4,
  0x74, 0xCF, 0x29, 0x5C, 0x84, 0x54, 0x14, 0xAA,
  0x2E, 0x95, 0xF7, 0xE0, 0x3C, 0xEC, 0x8C, 0x52,
  0xD6, 0x3D, 0x7B, 0x0E, 0xD6, 0x06, 0x82, 0x49,
  0xC9, 0x72, 0x7C, 0x18, 0xC0, 0x10, 0x10, 0xF6,
  0x72, 0xC9, 0xC3, 0xA8, 0x70, 0xA0, 0xD8, 0x77,
  0xF3, 0x48, 0x06, 0x04, 0xD8, 0x08, 0x90, 0x5B,
  0xDB, 0x60, 0x36, 0x43, 0x9B, 0x4B, 0xD4, 0xE3,
  0x9C, 0xB8, 0xF1, 0x72, 0x55, 0x1A, 0x8E, 0x57,
  0xD7, 0x6C, 0xDA, 0xBE, 0x66, 0xD6, 0xEA, 0x3D,
  0xBF, 0x04, 0xB2, 0xCE, 0x16, 0xA6, 0x06, 0xDE,
  0x5E, 0xE5, 0xB7, 0xC3, 0x1B, 0xCB, 0x47, 0x9F,
  0x1F, 0xA4, 0x3E, 0x5B, 0x83, 0x53, 0x53, 0x8A,
  0x0A, 0xB1, 0x93, 0xF9, 0x21, 0xF1, 0x31, 0xE6,
  0x64, 0xDF, 0x95, 0xE0, 0x38, 0xE8, 0xB4, 0x6D,
  0xED, 0x56, 0x1D, 0x8E, 0x56, 0xE6, 0x79, 0xB9,
  0xC6, 0xE2, 0x62, 0x4F, 0x97, 0x02, 0x40, 0x80,
  0x65, 0xB8, 0x0E, 0x07, 0xC2, 0x72, 0x37, 0xBE,
  0x3E, 0x00, 0xF2, 0xB8, 0xF1, 0x6D, 0x0E, 0x6F,
  0xC2, 0x1A, 0xA0, 0xC4, 0x95, 0x2F, 0xCD, 0x44,
  0xC4, 0x02, 0x44, 0x28, 0xF0, 0x40, 0x16, 0x97,
  0x17, 0x7D, 0xE4, 0x8B, 0xFE, 0x4C, 0x0D, 0xE3,
  0x60, 0xFD, 0x4B, 0x27, 0x34, 0xA6, 0xCD, 0xB6,
  0x10, 0xC0, 0x7C, 0x98, 0x42, 0x72, 0x92, 0x26,
  0x21, 0x60, 0x26, 0x4C, 0x95, 0x25, 0xA0, 0x03,
  0xA6, 0x50, 0xEC, 0x9D, 0xB5, 0x05, 0x53, 0xD2,
  0x52, 0xA9, 0x7E, 0x12, 0x2F, 0x65, 0xFA, 0x1A,
  0x7C, 0xB4, 0x12, 0x5E, 0x86, 0x3A, 0x50, 0xF5,
  0x53, 0xAD, 0xBA, 0xE6, 0x3D, 0x3C, 0x6D, 0xAE,
  0xCB, 0x33, 0xAD, 0xDC, 0xF4, 0x44, 0x12, 0x93,
  0x13, 0xF9, 0x7D, 0x12, 0xEB, 0x68, 0x0B, 0xE2,
  0x21, 0xE7, 0xA1, 0xCD, 0x15, 0xA5, 0xF3, 0x72,
  0xF2, 0xAB, 0x1F, 0x7E, 0xAA, 0x01, 0xE1, 0xA1,
  0x25, 0xA8, 0x06, 0x6D, 0xB9, 0x0C, 0x60, 0xA6,
  0x64, 0xAD, 0x15, 0x65, 0xBA, 0x30, 0x14, 0x66,
  0x22, 0x78, 0xFC, 0x94, 0x4C, 0x4E, 0x25, 0x9B,
  0xD9, 0x06, 0xB1, 0xEA, 0x89, 0x35, 0x62, 0x1E,
  0x8F, 0x69, 0xD4, 0x7F, 0x1C, 0xA0, 0xFD, 0x31,
  0x77, 0xAD, 0x1B, 0x40, 0xA4, 0x10, 0xB7, 0xCC,
  0x4D, 0xAB, 0x16, 0xD7, 0x0C, 0x01, 0x62, 0x87,
  0xBF, 0x4C, 0x50, 0x5A, 0xD8, 0x3B, 0x50, 0xE7,
  0x2C, 0xB3, 0xB7, 0x1F, 0x46, 0xA0, 0x57, 0x6B,
  0x46, 0x98, 0x93, 0xFA, 0xC7, 0xC1, 0x89, 0x45,
  0xDE, 0xD7, 0xC3, 0xC3, 0xBB, 0xCF, 0xEE, 0xEE,
  0xA8, 0xB3, 0xDF, 0x61, 0x4B, 0xE6, 0x04, 0x04,
  0x40, 0xDA, 0xAC, 0x43, 0xDA, 0x9A, 0x15, 0x25,
  0x45, 0x7D, 0xEA, 0x0C, 0x3A, 0x7A, 0xD4, 0x87,
  0xC5, 0x43, 0x77, 0x1D, 0xC6, 0x76, 0xD4, 0xB6,
  0x5A, 0x4B, 0x3F, 0x91, 0x55, 0x98, 0xC2, 0xCE,
  0x8C, 0x5B, 0xED, 0x53, 0x99, 0x20, 0x6D, 0xA6,
  0xF1, 0x96, 0x21, 0x41, 0xBB, 0x16, 0x86, 0x46,
  0xC6, 0x1D, 0x9D, 0xB0, 0x68, 0x69, 0x3D, 0xFE,
  0xC6, 0x16, 0x2C, 0x2B, 0x51, 0x40, 0x40, 0x2A,
  0x01, 0xBF, 0xB3, 0xFF, 0x8A, 0x38, 0x3D, 0x51,
  0xF4, 0x32, 0x74, 0x18, 0xC0, 0x70, 0x26, 0xA7,
  0x27, 0x5D, 0xDE, 0xB1, 0xD8, 0x5E, 0x3D, 0x30,
  0xB2, 0x0C, 0xEC, 0xA5, 0xCC, 0x44, 0x27, 0xC7,
  0x6D, 0x16, 0x01, 0x5A, 0x81, 0xFC, 0x9E, 0x3B,
  0xEE, 0x10, 0x17, 0x41, 0x9A, 0x0A, 0x50, 0x30,
  0x72, 0x6A, 0xCC, 0x01, 0xE0, 0x53, 0x3F, 0xFD,
  0x54, 0x8C, 0x13, 0x6C, 0x9D, 0x0E, 0x47, 0xB4,
  0xD1, 0x59, 0xCA, 0x17, 0xF3, 0x40, 0x10, 0xEA,
  0xCA, 0xD3, 0xA6, 0xDA, 0xA3, 0x28, 0x4B, 0x6E,
  0xBC, 0x42, 0xF8, 0x9D, 0x75, 0xFF, 0x3F, 0xCD,
  0x8E, 0x45, 0xE8, 0x1D, 0xEC, 0x5F, 0x74, 0x87,
  0x61, 0x23, 0x63, 0xA2, 0x79, 0x7B, 0xBB, 0xDE,
  0x72, 0xE5, 0xB6, 0x7B, 0x8B, 0x9A, 0xC7, 0x04,
  0x35, 0xD0, 0x65, 0xCB, 0xD0, 0x44, 0x41, 0xD1,
  0x74, 0x1E, 0xE8, 0x87, 0x6F, 0xE5, 0x25, 0x44,
  0xFB, 0x23, 0xA7, 0x08, 0xF4, 0x89, 0xEA, 0xCF,
  0x1E, 0xE0, 0xE7, 0xC9, 0x12, 0x92, 0xC8, 0xA8,
  0x89, 0x13, 0xA6, 0x07, 0xDC, 0xC9, 0xFA, 0x1F,
  0x2E, 0xB1, 0x04, 0x58, 0xBA, 0xAA, 0x6B, 0xE8,
  0x6B, 0x7D, 0xC8, 0x01, 0x8B, 0x1E, 0xCF, 0x49,
  0xCA, 0x21, 0xAD, 0x61, 0x18, 0xED, 0x8E, 0x83,
  0x00, 0x3E, 0xD9, 0x90, 0x78, 0xE2, 0x22, 0xFF,
  0x8F, 0x54, 0xD4, 0xF9, 0x21, 0x10, 0x37, 0xF4,
  0xFC, 0x2F, 0x15, 0x31, 0x48, 0xB0, 0xD3, 0x36,
  0xC1, 0x32, 0x99, 0x05, 0xDD, 0x6D, 0x3B, 0xBA,
  0x3A, 0x60, 0x91, 0xFE, 0xAE, 0x16, 0xFA, 0x72,
  0x53, 0xC0, 0x75, 0xFC, 0x51, 0xC9, 0x0C, 0x38,
  0x99, 0x5F, 0x19, 0x75, 0xAD, 0x1D, 0x4B, 0xCA,
  0x4A, 0x3C, 0x88, 0x01, 0x40, 0xD2, 0x33, 0xB4,
  0x37, 0x64, 0xDA, 0x3A, 0xAA, 0xBB, 0x93, 0x50,
  0xF5, 0x5A, 0xC4, 0xB5, 0x9D, 0x2D, 0x7B, 0xFA,
  0x7A, 0x84, 0x17, 0x7B, 0x22, 0xD8, 0xBB, 0xEA,
  0x58, 0x80, 0x97, 0xB2, 0x69, 0x70, 0x49, 0x00,
  0x89, 0x4F, 0x09, 0x65, 0xBD, 0x0D, 0x5B, 0xDA,
  0x5A, 0xB0, 0x32, 0x5D, 0x89, 0x1E, 0x46, 0x85,
  0x54, 0xC4, 0x71, 0x8F, 0x54, 0xEC, 0xEE, 0x8F,
  0x7F, 0xAF, 0x90, 0xEA, 0x7A, 0xCC, 0x7D, 0xF1,
  0x72, 0xA5, 0x79, 0x19, 0xC6, 0xF4, 0x5D, 0x61,
  0xF7, 0x24, 0x98, 0xD2, 0x53, 0xEB, 0x26, 0xE4,
  0x01, 0x67, 0xF7, 0xB6, 0x64, 0xC9, 0x59, 0xF3,
  0x30, 0x59, 0xFC, 0x9B, 0xD1, 0x65, 0x05, 0xD3,
  0x68, 0xB8, 0x68, 0x7D, 0xB5, 0xC7, 0xB3, 0x8F,
  0x59, 0x2E, 0x92, 0x5C, 0xC7, 0x7F, 0x3D, 0xFE,
  0x73, 0x88, 0x1F, 0x77, 0xB2, 0xF2, 0x9E, 0x55,
  0x57, 0x8F, 0x34, 0x9A, 0x61, 0x0C, 0x7B, 0xD3,
  0x5C, 0x15, 0xAE, 0xC2, 0x16, 0xB4, 0xC2, 0x2B,
  0xA5, 0x75, 0x6A, 0xA4, 0x31, 0x81, 0xA7, 0x67,
  0xE7, 0x30, 0x84, 0x28, 0xD0, 0x60, 0xA2, 0x71,
  0xF9, 0xE0, 0x33, 0xFF, 0xAB, 0x01, 0x04, 0x22,
  0x84, 0x42, 0x04, 0x02, 0x99, 0xFB, 0x9F, 0x5F,
  0xB9, 0x7F, 0xF5, 0x21, 0xDB, 0xC6, 0xA5, 0x00,
  0x60, 0x9D, 0x8B, 0x07, 0xAB, 0x7D, 0x03, 0xE2,
  0xD3, 0x45, 0xF0, 0x6E, 0xBD, 0x0D, 0x4B, 0xA4,
  0x23, 0x8A, 0x77, 0x1B, 0xCF, 0x75, 0x30, 0x96,
  0x33, 0xE4, 0x6A, 0x94, 0x6F, 0x01, 0xA1, 0x41,
  0xC1, 0x88, 0x5B, 0x97, 0xCD, 0x3E, 0x56, 0xD0,
  0x53, 0x88, 0x9C, 0xE3, 0x3C, 0x00, 0x1A, 0xA8,
  0x6C, 0xB7, 0xA3, 0xDC, 0x03, 0x96, 0x14, 0xF2,
  0x7E, 0xB7, 0x1C, 0x80, 0xEA, 0x49, 0x21, 0x8B,
  0x48, 0x85, 0xF8, 0x93, 0x89, 0x3D, 0x5D, 0x5F,
  0x13, 0x33, 0x93, 0xC3, 0x1C, 0x4E, 0x2D, 0xE0,
  0xE2, 0x1D, 0x2A, 0x51, 0xE7, 0x07, 0xF5, 0x38,
  0xB8, 0x75, 0x4A, 0x2A, 0xFE, 0x5C, 0x37, 0x0E,
  0x7C, 0xEA, 0x5C, 0xB6, 0x7E, 0xCE, 0x2C, 0x25,
  0x5C, 0xD1, 0xFF, 0x66, 0x06, 0x94, 0x59, 0x9A,
  0x7F, 0x7D, 0xED, 0x21, 0x69, 0xAD, 0xC6, 0x9F,
  0x49, 0x7B, 0xC7, 0xA7, 0x74, 0xC8, 0xE4, 0xC6,
  0x65, 0x63, 0x07, 0xC9, 0x65, 0x0F, 0xBC, 0xBC,
  0x1C, 0xC7, 0xD3, 0xAC, 0x7C, 0x2E, 0x2B, 0x4B,
  0xB9, 0x3F, 0xF7, 0x59, 0xC2, 0x7A, 0x0C, 0x86,
  0xF4, 0x23, 0xFB, 0x75, 0xE9, 0x59, 0x9B, 0x48,
  0xC0, 0x7E, 0x13, 0x59, 0x07, 0x72, 0xED, 0x00,
  0x87, 0x50, 0xE9, 0x45, 0xBD, 0x0D, 0xCF, 0x1C,
  0x94, 0xCD, 0x1E, 0xD2, 0x1C, 0x36, 0xA5, 0x80,
  0xD9, 0x24, 0x8F, 0x13, 0xC7, 0x75, 0x53, 0x5B,
  0x24, 0x47, 0xD3, 0x12, 0xC9, 0x5C, 0xE8, 0x0E,
  0x2E, 0x65, 0xA7, 0xAD, 0x6C, 0xFB, 0x97, 0x5C,
  0x0E, 0xF6, 0x9D, 0x33, 0x49, 0x8D, 0x27, 0x24,
  0x64, 0x9F, 0x29, 0x97, 0x2A, 0x3A, 0xF8, 0x2B,
  0xA3, 0x0A, 0xE0, 0xF2, 0x96, 0x7C, 0x76, 0x55,
  0xD9, 0x6F, 0x0B, 0x29, 0xF1, 0xE3, 0x90, 0x58,
  0xBD, 0xB0, 0x20, 0xCA, 0x1B, 0xAB, 0xC7, 0x78,
  0xF4, 0x7B, 0x8F, 0xA0, 0x70, 0xAA, 0x89, 0xBB,
  0x7F, 0xA4, 0xA0, 0xDF, 0x0C, 0x20, 0x0B, 0x79,
  0xAD, 0x8A, 0x30, 0xA6, 0x72, 0x4A, 0xA8, 0x2C,
  0xAC, 0x12, 0x70, 0x3A, 0x70, 0xD4, 0x48, 0x1A,
  0x53, 0x79, 0x5D, 0x65, 0x41, 0xD3, 0xB0, 0x7D,
  0xDD, 0x27, 0x95, 0xE4, 0xCC, 0x51, 0x36, 0x70,
  0x2F, 0x0B, 0x1F, 0x67, 0x43, 0xE5, 0x5F, 0x77,
  0xFB, 0xA8, 0x9C, 0xB4, 0x6C, 0x6A, 0xB0, 0x60,
  0xEC, 0xCD, 0xDE, 0x63, 0x9D, 0x0F, 0x7B, 0x47,
  0xE5, 0xFC, 0xBB, 0xF5, 0x79, 0x35, 0x53, 0x0E,
  0x71, 0x4F, 0x29, 0x63, 0x96, 0x21, 0x07, 0x3B,
  0x44, 0x9F, 0x1F, 0x32, 0xEA, 0x0B, 0x5F, 0x9C,
  0x44, 0x9A, 0x6E, 0xA2, 0x8A, 0x70, 0x55, 0xA7,
  0x23, 0x78, 0xE8, 0xA7, 0x4E, 0xD8, 0xFB, 0x08,
  0xE9, 0x79, 0xCC, 0xD1, 0x45, 0xF6, 0x9A, 0xF2,
  0x54, 0xEC, 0x75, 0x7F, 0x24, 0x8A, 0xE6, 0x55,
  0x47, 0xB9, 0xD1, 0x7D, 0x85, 0x35, 0xC7, 0x61,
  0x41, 0xA8, 0x5A, 0xB6, 0xDC, 0x69, 0x04, 0x66,
  0xE1, 0x3A, 0x3C, 0xE1, 0x3D, 0x3D, 0xF5, 0xA6,
  0x84, 0x18, 0xAE, 0xDF, 0xF7, 0x5A, 0xCA, 0x06,
  0x95, 0x08, 0xBE, 0xD2, 0x06, 0x85, 0xD7, 0x53,
  0x53, 0x95, 0xD3, 0xB3, 0x38, 0x4A, 0x0F, 0x11,
  0x51, 0xAA, 0x1C, 0xB2, 0x0C, 0x1C, 0xBA, 0x89,
  0xF6, 0x2D, 0xAD, 0x80, 0x58, 0xD9, 0xF7, 0x34,
  0x95, 0x01, 0xB4, 0xF1, 0x3A, 0x97, 0x07, 0xC7,
  0x47, 0x9C, 0x1C, 0x31, 0xE9, 0xC8, 0x9C, 0x5F,
  0x47, 0x95, 0xAF, 0x6A, 0x10, 0x89, 0x34, 0x54,
  0x74, 0xBB, 0x2B, 0x7D, 0xA7, 0xF2, 0xD0, 0x31,
  0xAC, 0x87, 0x07, 0x2A, 0xF2, 0xE3, 0xD2, 0x11,
  0xB0, 0x21, 0x94, 0xC9, 0x23, 0x90, 0x61, 0xF1,
  0x72, 0x28, 0xCC, 0xA3, 0xF2, 0x6B, 0x22, 0xE1,
  0xC8, 0x4A, 0xE1, 0x7D, 0xA5, 0x15, 0x43, 0xC2,
  0x42, 0xB8, 0x5D, 0x32, 0x62, 0xF0, 0x57, 0xFF,
  0x62, 0x18, 0xFA, 0x95, 0x28, 0xD1, 0x99, 0xC8,
  0x1D, 0xC5, 0xB2, 0x88, 0x53, 0x52, 0x65, 0xA6,
  0x8E, 0x77, 0x79, 0x1E, 0x06, 0x1C, 0x6C, 0x3C,
  0x26, 0xED, 0xEB, 0x1D, 0x56, 0x7F, 0x3D, 0x58,
  0x11, 0xEF, 0x44, 0xD8, 0x00, 0xB0, 0xE6, 0x67,
  0xE7, 0x9D, 0x7F, 0x10, 0x2D, 0xDF, 0x97, 0xB6,
  0x6E, 0xB6, 0x41, 0x1F, 0xC4, 0x45, 0x76, 0xB5,
  0x39, 0xEE, 0x80, 0xCF, 0xE6, 0x01, 0x62, 0x15,
  0xF8, 0x01, 0x0A, 0x69, 0x79, 0xCD, 0x64, 0xAB,
  0x86, 0x5F, 0x68, 0x5D, 0x86, 0xD6, 0x2B, 0xCB,
  0xD2, 0x2A, 0x15, 0x7D, 0xC0, 0x38, 0x58, 0x29,
  0xF3, 0x2B, 0x35, 0x7A, 0xAE, 0x1C, 0xCC, 0xA6,
  0x06, 0x74, 0xE1, 0x90, 0xB8, 0x04, 0x6F, 0x69,
  0x1F, 0x3B, 0xBB, 0x96, 0x4E, 0xE2, 0x4A, 0x0D,
  0x1F, 0xC0, 0x57, 0x60, 0xBB, 0x16, 0x86, 0xEB,
  0x69, 0x97, 0xE3, 0xAA, 0x5F, 0xE5, 0x98, 0xA8,
  0x28, 0xF3, 0x73, 0x5E, 0x86, 0x47, 0x60, 0xA3,
  0xFF, 0x70, 0x4E, 0x25, 0x71, 0x89, 0x4C, 0x92,
  0x12, 0x8F, 0x38, 0x54, 0x2D, 0xD5, 0xB6, 0x53,
  0xEF, 0x1C, 0x02, 0x69, 0xBD, 0x04, 0xF6, 0x7C,
  0x64, 0x0D, 0x1B, 0x04, 0x96, 0x45, 0xE7, 0x87,
  0x73, 0xCF, 0x45, 0x3A, 0x5F, 0xED, 0x25, 0xE2,
  0xAF, 0x77, 0x8B, 0x4D, 0x37, 0x4D, 0x09, 0x6C,
  0xA9, 0x5A, 0x5E, 0x92, 0x39, 0x4F, 0x2A, 0xEA,
  0x2D, 0xCD, 0x6F, 0xBE, 0x64, 0x7C, 0x1B, 0x19,
  0x39, 0x96, 0x60, 0xC0, 0xD8, 0x22, 0xE8, 0x8A,
  0xC0, 0x3F, 0x6C, 0x43, 0xB3, 0xB1, 0x71, 0xC2,
  0xFE, 0x70, 0xA1, 0xF6, 0x26, 0x34, 0xF0, 0x35,
  0x50, 0x5A, 0xC8, 0xE2, 0x3D, 0x8D, 0x5F, 0x3F,
  0xCB, 0x77, 0x7A, 0x1E, 0x64, 0x70, 0x16, 0x33,
  0x63, 0x9C, 0xAC, 0xC3, 0x1B, 0xA7, 0xCD, 0xD5,
  0x52, 0x85, 0x2F, 0x81, 0x14, 0x3C, 0xB9, 0xB6,
  0x12, 0xEC, 0x5E, 0x32, 0x02, 0xB5, 0x37, 0xF9,
  0xE1, 0xF6, 0x0E, 0xC3, 0x53, 0xE0, 0x25, 0xDD,
  0x75, 0xB3, 0xF5, 0x99, 0x41, 0xF1, 0xA7, 0x26,
  0xA6, 0x4C, 0xBD, 0xD2, 0x32, 0x81, 0xC0, 0x5C,
  0xDF, 0x2D, 0xE8, 0x0F, 0x54, 0x76, 0xD5, 0x01,
  0x18, 0xA0, 0x8F, 0xB0, 0xE1, 0x62, 0x8B, 0x68,
  0xCA, 0xD3, 0x99, 0xDC, 0x47, 0xEA, 0x7A, 0xBA,
  0x3A, 0xE1, 0x61, 0x4C, 0x94, 0xC1, 0xB2, 0x72,
  0xEF, 0xC4, 0x44, 0x69, 0xB1, 0x0D, 0x27, 0x42,
  0xE2, 0x1B, 0x8C, 0xA7, 0x7C, 0x41, 0x2B, 0x73,
  0xF1, 0x26, 0x8A, 0x64, 0xD5, 0x42, 0x87, 0x58,
  0xFA, 0x5D, 0x37, 0x27, 0x11, 0xAD, 0xE5, 0x9D,
  0x1F, 0xC8, 0x69, 0xA7, 0x14, 0x8C, 0x5D, 0xD6,
  0x55, 0x4E, 0xD8, 0xB4, 0xFE, 0x65, 0xAD, 0xAD,
  0x0D, 0xD6, 0x10, 0xE5, 0x1D, 0x3F, 0x34, 0x5C,
  0x1C, 0xE7, 0x51, 0xCF, 0x3C, 0x24, 0x84, 0x64,
  0xE4, 0xBF, 0xF6, 0xBA, 0x90, 0x4B, 0x83, 0x83,
  0x23, 0xF8, 0x9C, 0xDB, 0xA9, 0xD9, 0x99, 0x59,
  0x39, 0x3F, 0x99, 0x27, 0x94, 0x8E, 0x2E, 0xCE,
  0x4E, 0x37, 0xAA, 0x6C, 0x74, 0xE4, 0x84, 0x84,
  0xAE, 0x65, 0x71, 0x76, 0x04, 0x15, 0x28, 0xEB,
  0xCE, 0x00, 0x94, 0xF4, 0x2F, 0x27, 0x45, 0x89,
  0x0F, 0xD8, 0x2B, 0xA7, 0x3C, 0x9D, 0xF1, 0x38,
  0x88, 0xB0, 0xF6, 0x7A, 0x4C, 0xED, 0x3D, 0x0E,
  0x2E, 0x97, 0x4E, 0x08, 0xDC, 0x73, 0xDB, 0x19,
  0x09, 0x7B, 0x3D, 0x4A, 0x0B, 0x2B, 0xDB, 0x6F,
  0x05, 0x12, 0x6E, 0xC8, 0xC2, 0x7E, 0x37, 0x75,
  0xF9, 0x08, 0x0C, 0x6C, 0x91, 0xA1, 0x49, 0x98,
  0xA8, 0xC0, 0x37, 0xE9, 0x7D, 0xE8, 0x58, 0x10,
  0xB0, 0xB3, 0x07, 0xD6, 0x06, 0x36, 0xE9, 0xAA,
  0xC0, 0xC6, 0xC0, 0x54, 0xCD, 0x8F, 0xA3, 0x49,
  0x13, 0x62, 0x56, 0x30, 0xC0, 0xC2, 0xEE, 0x07,
  0x07, 0x58, 0xAF, 0x41, 0xD3, 0x4B, 0x4D, 0xC4,
  0xFE, 0xAD, 0x19, 0xD8, 0x03, 0x39, 0xCA, 0x80,
  0xB4, 0xDD, 0x40, 0x06, 0x54, 0x6A, 0xBA, 0xC1,
  0xB1, 0xD0, 0xEE, 0x00, 0xD0, 0x47, 0xA5, 0x2C,
  0x44, 0x17, 0xA3, 0xC3, 0x10, 0x20, 0x93, 0xC3,
  0xC9, 0xE6, 0xA2, 0xE1, 0x13, 0x29, 0xA7, 0x97,
  0xE8, 0xC3, 0x8F, 0x0D, 0x17, 0xA9, 0xE3, 0xC1,
  0x4F, 0xBD, 0x8B, 0x2B, 0xE2, 0xB2, 0x1E, 0xFE,
  0xBC, 0x3A, 0xE0, 0xE9, 0x20, 0x90, 0xFC, 0x35,
  0xBE, 0x30, 0x3E, 0x50, 0x93, 0x10, 0x40, 0xB0,
  0x44, 0xAF, 0xFA, 0x66, 0x04, 0x70, 0x62, 0xCE,
  0x60, 0x5B, 0xAE, 0xD3, 0x5D, 0x58, 0xCD, 0xAF,
  0xE4, 0x2B, 0x1C, 0x2E, 0xF5, 0xD7, 0x9C, 0x79,
  0x6B, 0xDB, 0x44, 0xE8, 0x10, 0xA0, 0x48, 0x80,
  0x89, 0xD9, 0xCA, 0xF1, 0x09, 0xA4, 0x34, 0xF4,
  0x74, 0xAF, 0x2F, 0x02, 0xDA, 0x4B, 0x6C, 0xAF,
  0x87, 0x5E, 0x4A, 0xEC, 0x20, 0xB5, 0x8D, 0x6D,
  0x45, 0x9C, 0xA1, 0x67, 0x9A, 0xB9, 0xFE, 0x32,
  0xF8, 0xC1, 0xD8, 0x34, 0x3D, 0xC6, 0xA5, 0xA5,
  0x05, 0xDE, 0xAA, 0xEB, 0x87, 0xF7, 0xB7, 0x77,
  0x4F, 0x96, 0xC0, 0x60, 0xA8, 0xDA, 0xD7, 0xA3,
  0x91, 0x61, 0xF0, 0xF9, 0x29, 0xBB, 0x63, 0xA1,
  0x2D, 0xEC, 0xE8, 0xAF, 0x5F, 0x0A, 0x6D, 0x8F,
  0x12, 0x39, 0xB9, 0x94, 0x4C, 0xAD, 0x86, 0x45,
  0x05, 0xFE, 0x48, 0x66, 0x9B, 0x9F, 0x3F, 0xDF,
  0x5F, 0xB4, 0x46, 0x3A, 0xA2, 0x50, 0x10, 0x92,
  0x77, 0x18, 0xB3, 0x2F, 0xF7, 0x47, 0x11, 0x90,
  0x10, 0xC7, 0x72, 0x6C, 0x14, 0xD4, 0xE5, 0x62,
  0xE1, 0x36, 0x96, 0x42, 0x9F, 0x1F, 0xBC, 0x8C,
  0xBC, 0xC4, 0xD2, 0x6C, 0x9E, 0x04, 0xD4, 0xD8,
  0xF8, 0xF3, 0x98, 0x04, 0x06, 0x7A, 0x98, 0x54,
  0xF0, 0xCB, 0x3E, 0x43, 0xFD, 0x55, 0x09, 0x2B,
  0x81, 0x74, 0x10, 0x56, 0xBC, 0x47, 0x94, 0xB3,
  0x3E, 0xF2, 0xE6, 0x86, 0x76, 0xC6, 0xBD, 0x3D,
  0xBD, 0xD0, 0xC7, 0xDB, 0xB8, 0x18, 0xD8, 0xB8,
  0x0C, 0x67, 0x7B, 0x37, 0x4F, 0x5F, 0x4B, 0xCD,
  0x4D, 0x96, 0x2C, 0x4A, 0x20, 0x3F, 0xDF, 0x3A,
  0x43, 0x67, 0x69, 0x00, 0x62, 0x06, 0x94, 0x79,
  0xD7, 0x00, 0xAA, 0x36, 0x01, 0xA0, 0x30, 0x3E,
  0x2D, 0x34, 0xEF, 0xAD, 0x6E, 0xED, 0xBD, 0x4D,
  0xB9, 0x04, 0xF1, 0x3D, 0x6E, 0x75, 0xB0, 0xF5,
  0x52, 0x24, 0x90, 0x7D, 0xFB, 0x48, 0xE8, 0x08,
  0x88, 0xDB, 0x65, 0x80, 0x6A, 0x7F, 0x56, 0xB6,
  0x2B, 0x00, 0x80, 0xAD, 0x75, 0x44, 0x63, 0xA0,
  0x00, 0xB9, 0xFF, 0x1B, 0xCB, 0x70, 0x53, 0x13,
  0xA1, 0xEA, 0xDC, 0xE2, 0x9A, 0x58, 0x1D, 0xF7,
  0xF7, 0x4A, 0x5C, 0x40, 0xEF, 0xAF, 0xB5, 0x53,
  0x85, 0xBA, 0x08, 0x46, 0x9C, 0x0A, 0x28, 0x7B,
  0x8B, 0xD0, 0x44, 0x29, 0xD1, 0x49, 0x18, 0x92,
  0x30, 0xEB, 0x7F, 0x02, 0xFA, 0x6A, 0x3B, 0xD9,
  0x0A, 0xA1, 0x55, 0x1C, 0xEE, 0x1E, 0x3A, 0x0A,
  0xC0, 0x5D, 0xA9, 0xC1, 0x3F, 0x2E, 0x11, 0xD2,
  0xD2, 0x4D, 0xFA, 0xD6, 0x46, 0xC7, 0x01, 0xD5,
  0x59, 0x24, 0x50, 0x2F, 0xEB, 0xA9, 0xD5, 0xED,
  0xEF, 0x67, 0xA1, 0x8B, 0x51, 0xE1, 0x67, 0xB5,
  0x33, 0xE4, 0x50, 0x30, 0xE1, 0xC3, 0xF0, 0x40,
  0x60, 0x19, 0x0F, 0xCB, 0x19, 0x0B, 0x0E, 0xFC,
  0x61, 0x4A, 0xDE, 0xB0, 0x4D, 0x7B, 0xF4, 0xCB,
  0x4B, 0x90, 0x10, 0x3D, 0xE5, 0x59, 0x3B, 0xF7,
  0x72, 0xE8, 0x19, 0x76, 0xA2, 0x51, 0xF9, 0x3D,
  0x7D, 0x74, 0x52, 0xAC, 0x69, 0xB5, 0xC3, 0x5A,
  0xDD, 0x0D, 0x32, 0xDE, 0x86, 0xC2, 0x20, 0xBD,
  0x51, 0xDC, 0xE2, 0x88, 0x90, 0xD2, 0x12, 0x30,
  0x9F, 0x6E, 0x64, 0x16, 0xE8, 0x46, 0x09, 0xEF,
  0x41, 0xB6, 0x66, 0x34, 0xBB, 0x59, 0x56, 0xBC,
  0x1C, 0x55, 0x13, 0xBF, 0xFE, 0xEE, 0x2C, 0xE5,
  0x4F, 0x26, 0x99, 0xDC, 0x84, 0x9E, 0xEF, 0x9F,
  0xB5, 0x4E, 0xF4, 0x93, 0xE9, 0x04, 0x08, 0xE2,
  0xCE, 0x87, 0x38, 0x73, 0x39, 0xC3, 0x4B, 0x26,
  0xA4, 0x5A, 0x1F, 0x8C, 0x12, 0xA9, 0xC9, 0x12,
  0x2C, 0xD7, 0xC3, 0x5F, 0x47, 0x5D, 0x9D, 0xEF,
  0x00, 0xF1, 0xF7, 0x20, 0x08, 0x02, 0xC8, 0xBA,
  0x30, 0xC1, 0x95, 0xF3, 0x02, 0x32, 0xE9, 0x38,
  0x58, 0x38, 0xAE, 0x70, 0xF5, 0x29, 0x63, 0x1F,
  0x3D, 0xEC, 0x7D, 0xB3, 0x20, 0x78, 0xB5, 0x77,
  0xFB, 0x2B, 0x78, 0xFB, 0xDC, 0xA4, 0xC0, 0x2A,
  0x76, 0x3F, 0x84, 0x00, 0x74, 0x0D, 0x66, 0x5F,
  0x2D, 0xBB, 0xE5, 0x41, 0x9D, 0x07, 0xBB, 0x99,
  0x14, 0x27, 0x4D, 0xEF, 0x9A, 0x28, 0x44, 0x9F,
  0x3F, 0x66, 0x20, 0x8C, 0xC6, 0xD6, 0x24, 0xCD,
  0x67, 0x7C, 0x42, 0x8E, 0xC6, 0xEF, 0x7F, 0x25,
  0x2D, 0x74, 0xCA, 0x81, 0xDB, 0x26, 0xAE, 0xCB,
  0xA7, 0x83, 0xFD, 0x95, 0x46, 0xC5, 0xBE, 0x5C,
  0xFC, 0x07, 0xC5, 0xFF, 0x34, 0x70, 0x82, 0x6E,
  0xC7, 0x90, 0xAF, 0xC8, 0x99, 0xAB, 0xA7, 0x4E,
  0x02, 0xC1, 0x92, 0x22, 0x05, 0xA8, 0x38, 0xF8,
  0x78, 0xA3, 0x23, 0x0E, 0xD6, 0x27, 0x27, 0xE4,
  0x55, 0xEF, 0x5A, 0xBE, 0x22, 0x1B, 0xF9, 0x00,
  0xC4, 0x02, 0x44, 0x28, 0xF0, 0x40, 0x16, 0x97,
  0x17, 0x6E, 0x1A, 0x66, 0x1B, 0x98, 0xD8, 0x89,
  0x69, 0xB1, 0x8F, 0x61, 0x30, 0xC9, 0xB4, 0x84,
  0x04, 0xDF, 0x5F, 0x72, 0xAA, 0xA7, 0xC5, 0x24,
  0xC6, 0x1E, 0x80, 0xEE, 0x3A, 0x06, 0xED, 0x8F,
  0xAA, 0x73, 0xED, 0x00, 0xBB, 0x08, 0xFA, 0xF8,
  0x68, 0x2A, 0xCE, 0x3B, 0xA1, 0x98, 0x9A, 0xD6,
  0x55, 0xB7, 0x93, 0xE2, 0xCA, 0x7A, 0x2C, 0xAD,
  0x2D, 0xC7, 0x13, 0x7C, 0x9C, 0x2F, 0xFD, 0x2E,
  0xB6, 0x61, 0xCB, 0xA0, 0x93, 0x39, 0xC8, 0x56,
  0xD5, 0xCE, 0xD3, 0x9F, 0xE5, 0x06, 0x7E, 0x7E,
  0xDE, 0x05, 0x2B, 0x4E, 0x14, 0xB7, 0xD1, 0xB3,
  0xF0, 0x3B, 0x17, 0xF3, 0xA2, 0x61, 0x64, 0x88,
  0x28, 0x41, 0xE4, 0x90, 0x5F, 0x04, 0x6A, 0x12,
  0x01, 0x56, 0x7B, 0x9F, 0x4C, 0x51, 0x33, 0x13,
  0x9B, 0x40, 0xDB, 0xBD, 0x78, 0x38, 0x54, 0x96,
  0x0B, 0x20, 0xA0, 0x8D, 0x55, 0xD4, 0xD6, 0x15,
  0xAD, 0x75, 0x71, 0x0F, 0xC3, 0xBB, 0x78, 0x10,
  0xB3, 0xA2, 0xAF, 0x7A, 0x01, 0x16, 0x4D, 0xDC,
  0xFC, 0xBC, 0xCA, 0x24, 0xEF, 0x47, 0xBE, 0xDD,
  0x4A, 0xF9, 0x64, 0xCA, 0xBA, 0xF5, 0x74, 0xD0,
  0x53, 0x70, 0x75, 0xD9, 0x21, 0x91, 0x23, 0xF0,
  0x68, 0x02, 0xFF, 0x90, 0xA8, 0xC5, 0xB5, 0x87,
  0x6C, 0x17, 0x73, 0x4C, 0x8C, 0xFC, 0xBC, 0x7C,
  0x5E, 0xAE, 0x98, 0x34, 0xCC, 0x7C, 0xDC, 0xB6,
  0x26, 0x5F, 0x82, 0x6E, 0xF0, 0x41, 0x21, 0x43,
  0x00, 0xCB, 0x58, 0x13, 0xEB, 0x9B, 0xDB, 0x1B,
  0x0A, 0x8F, 0x3A, 0xD4, 0x1F, 0xA9, 0x51, 0x98,
  0xBA, 0xA2, 0x04, 0xF2, 0xA2, 0x9B, 0x88, 0x2D,
  0x89, 0x72, 0x4C, 0xA3, 0xD6, 0x64, 0xE4, 0x2C,
  0xAC, 0x6A, 0x2C, 0x40, 0x98, 0x28, 0x7E, 0xFF,
  0x7F, 0xE6, 0xF8, 0x6B, 0x22, 0xF7, 0x94, 0xE5,
  0x07, 0xDF, 0x58, 0x7F, 0xA4, 0xAC, 0xC7, 0xC5,
  0x5E, 0x9D, 0x27, 0x66, 0x6E, 0x12, 0x52, 0x50,
  0x8B, 0x48, 0x3E, 0x72, 0xAA, 0xB8, 0xFB, 0x9B,
  0xB2, 0xD2, 0xA4, 0xE8, 0x30, 0x02, 0x41, 0x21,
  0x61, 0x9A, 0x2C, 0xD0, 0x80, 0x20, 0xD2, 0xB3,
  0x33, 0x78, 0x46, 0x0A, 0x50, 0x83, 0x43, 0x43,
  0xE3, 0x38, 0xAC, 0xE3, 0xBB, 0xCB, 0x8B, 0x4B,
  0x8B, 0x72, 0xD4, 0xFA, 0x86, 0x36, 0x16, 0xF4,
  0x54, 0xAD, 0x78, 0x94, 0x51, 0x11, 0x47, 0xC6,
  0x46, 0xFB, 0x79, 0x1D, 0x47, 0xF4, 0xB3, 0xB1,
  0x32, 0xCF, 0x1F, 0x4B, 0x99, 0x84, 0xE6, 0x9B,
  0x18, 0x0E, 0xBC, 0xF5, 0xB5, 0x27, 0x5A, 0x6A,
  0x42, 0xCA, 0xCE, 0x02, 0x21, 0x21, 0x8D, 0x5D,
  0x1F, 0x87, 0x17, 0xBB, 0x43, 0xF3, 0x01, 0xCB,
  0x47, 0x5C, 0xCA, 0xA6, 0xCE, 0xE7, 0x97, 0xC5,
  0x0F, 0xD8, 0x73, 0xEF, 0x37, 0x87, 0xFD, 0x3C,
  0xBC, 0x67, 0xD1, 0xBD, 0x65, 0xD5, 0x51, 0x9C,
  0x1E, 0xA5, 0x17, 0x7A, 0xA2, 0x12, 0x72, 0xB2,
  0x32, 0xE9, 0xEF, 0x8D, 0x57, 0x87, 0xCD, 0x0F,
  0x8F, 0x54, 0xE2, 0x8E, 0x56, 0xE6, 0x66, 0xB4,
  0x36, 0x8D, 0x27, 0x4B, 0x9B, 0x2B, 0x36, 0xF2,
  0x0C, 0xD3, 0xE1, 0x9F, 0x45, 0x95, 0x81, 0x52,
  0xD0, 0x6B, 0x45, 0x3A, 0xE0, 0x30, 0xF0, 0x23,
  0xA1, 0x1A, 0x74, 0x0C, 0xD6, 0x06, 0x7E, 0xAB,
  0x29, 0x92, 0x14, 0x6E, 0xB4, 0x64, 0x30, 0xE5,
  0x67, 0xDC, 0xD2, 0xAB, 0x71, 0xA1, 0xC1, 0x01,
  0x81, 0x5A, 0x1C, 0x8F, 0xA8, 0xE7, 0x87, 0x47,
  0xC7, 0x1C, 0x5A, 0xC9, 0xEE, 0xA1, 0xC1, 0x01,
  0x81, 0x5A, 0x1C, 0x8F, 0xA8, 0xE7, 0x87, 0x47,
  0xC7, 0x1C, 0x5A, 0xC9, 0xEE, 0xA1, 0xC1, 0x01,
  0x81, 0x5A, 0x1C, 0x8F, 0xA8, 0xE7, 0x87, 0x47,
  0xC7, 0x1C, 0x5A, 0xC9, 0xEE, 0xA1, 0xC1, 0x01,
  0x81, 0x5A, 0x1C, 0x8F, 0xA8, 0xE7, 0x87, 0x47,
  0xC7, 0x1C, 0x5A, 0xC9, 0xEE, 0xA1, 0xC1, 0x01,
  0x81, 0x5A, 0x1C, 0x8F, 0xA8, 0xE7, 0x97, 0x40,
  0xC2, 0x79, 0xEB, 0x90, 0x4A, 0x9A, 0xEE, 0x36,
  0xB4, 0x0F, 0x19, 0x62, 0xB8, 0x68, 0x08, 0xC8,
  0x48, 0x93, 0x25, 0x49, 0x91, 0x21, 0x41, 0x81,
  0x01, 0xDA, 0xA0, 0xD4, 0x0C, 0xDC, 0x6C, 0xB4,
  0x34, 0x8F, 0xC1, 0xB4, 0x6C, 0xBC, 0x30, 0xF0,
  0x70, 0xAB, 0x1D, 0x71, 0xA9, 0x19, 0x78, 0xB8,
  0x38, 0xE3, 0x54, 0x38, 0xE1, 0x51, 0x30, 0xF8,
  0x38, 0xE3, 0x54, 0x39, 0xE0, 0x51, 0x70, 0xA0,
  0x24, 0xFD, 0x6A, 0x02, 0xFB, 0x4F, 0x0E, 0x4A,
  0xDA, 0x43, 0xE4, 0x99, 0x50, 0xF1, 0xD8, 0x3A,
  0x9E, 0x67, 0x98, 0xE6, 0x77, 0xD5, 0xFC, 0x6E,
  0xD7, 0x1E, 0xFD, 0x80, 0x0D, 0xAC, 0x99, 0x4C,
  0x99, 0x53, 0x4F, 0x09, 0x7B, 0xE1, 0x2B, 0x41,
  0x6B, 0x9A, 0x79, 0x40, 0xCD, 0x28, 0x1D, 0x88,
  0x5D, 0x53, 0xB0, 0x09, 0x84, 0xE1, 0x2B, 0x01,
  0x2B, 0x1E, 0x02, 0x80, 0xF2, 0xAC, 0x7A, 0x17,
  0x21, 0x17, 0x17, 0x96, 0xF8, 0xA5, 0x73, 0x6E,
  0x35, 0x33, 0x6B, 0xE9, 0xDF, 0x81, 0x3F, 0x84,
  0xEB, 0x8D, 0xE5, 0x72, 0x74, 0x3F, 0xE1, 0xCE,
  0xB5, 0x93, 0xDB, 0x49, 0x6F, 0x21, 0xBF, 0x88,
  0xB7, 0x93, 0xDB, 0x48, 0x6E, 0x21, 0xBE, 0x81,
  0xFE, 0xDA, 0x58, 0x2D, 0xF5, 0x25, 0x7D, 0xA4,
  0x24, 0x9F, 0xD5, 0xA0, 0x78, 0xA8, 0xFC, 0x3C,
  0xBC, 0x67, 0xD1, 0xBD, 0x65, 0xD5, 0xB5, 0x75,
  0xF5, 0x2E, 0x98, 0xF4, 0x2C, 0x9C, 0xFC, 0x3C,
  0xBC, 0x67, 0xF9, 0x9C, 0x44, 0x94, 0xD0, 0x19,
  0x99, 0x22, 0x84, 0x58, 0x82, 0x32, 0x52, 0x88,
  0x08, 0xB3, 0x75, 0x18, 0xC0, 0x70, 0x6C, 0xAB,
  0x2B, 0x90, 0x9A, 0xFB, 0x21, 0xF1, 0xAD, 0x65,
  0xE5, 0x5E, 0xFC, 0x9E, 0x44, 0x94, 0x38, 0xF6,
  0x74, 0xCF, 0xED, 0x87, 0x5F, 0x8F, 0x4B, 0x84,
  0x06, 0xBD, 0x4F, 0x25, 0xFD, 0x2D, 0xC1, 0x0E,
  0x8C, 0x37, 0x71, 0x04, 0xDC, 0x0C, 0xB8, 0x77,
  0xF5, 0x4E, 0x48, 0x35, 0xEF, 0x3F, 0xE7, 0x2F,
  0xAF, 0x14, 0x82, 0xFC, 0x26, 0xF6, 0x2A, 0xED,
  0x6D, 0xD6, 0x34, 0x4A, 0x90, 0x40, 0xE8, 0x3A,
  0xB8, 0x03, 0x5D, 0x37, 0xEF, 0x3F, 0x3B, 0xE3,
  0x61, 0xDA, 0x2C, 0x4A, 0x92, 0x42, 0x14, 0x95,
  0x15, 0x4F, 0x7B, 0x11, 0x78, 0x48, 0x2E, 0xF2,
  0x78, 0x32, 0x05, 0x6F, 0x15, 0xEE, 0x8E, 0xC7,
  0x4E, 0xB0, 0x04, 0x68, 0x55, 0xE1, 0x81, 0xE4,
  0x66, 0xBD, 0xEE, 0x87, 0x5F, 0x0A, 0x62, 0xA2,
  0x07, 0xDF, 0x69, 0xA0, 0x71, 0xC1, 0x00, 0x43,
  0xC5, 0xAF, 0x9D, 0xF7, 0x8A, 0x60, 0x27, 0xFA,
  0x8A, 0x51, 0xD1, 0xFC, 0x24, 0xA5, 0x40, 0x86,
  0x27, 0x7A, 0xCA, 0x8F, 0x84, 0x29, 0xB9, 0x79,
  0xF9, 0x22, 0xA2, 0x8F, 0x57, 0xD6, 0x31, 0xF7,
  0x56, 0x05, 0xB5, 0xF0, 0x6B, 0xC6, 0x56, 0x96,
  0x16, 0xCD, 0x4D, 0x60, 0xB8, 0x39, 0xDC, 0x1A,
  0xBB, 0xE9, 0x59, 0x1C, 0x57, 0xFA, 0x6A, 0xAA,
  0x2A, 0xF1, 0x71, 0x5C, 0x84, 0x15, 0xF8, 0x3E,
  0x8F, 0xD8, 0x68, 0x95, 0xC7, 0x71, 0x90, 0xDB,
  0x5D, 0x0F, 0xF0, 0xB5, 0x6E, 0xC3, 0x53, 0x93,
  0x13, 0xC8, 0x48, 0x65, 0xBD, 0x9C, 0x72, 0xB4,
  0x38, 0xEB, 0xDF, 0xFA, 0x22, 0xF7, 0x96, 0x56,
  0x77, 0x3C, 0x8C, 0x51, 0x0E, 0xB8, 0x19, 0x56,
  0xD0, 0xC2, 0x7F, 0xBA, 0x39, 0x94, 0x04, 0xC4,
  0x44, 0x9F, 0x1F, 0x32, 0xEA, 0x6B, 0x9A, 0x5C,
  0xFD, 0xB4, 0x04, 0x41, 0x8A, 0x27, 0xB7, 0x77,
  0xF7, 0x2C, 0xAC, 0x81, 0x59, 0x68, 0x9C, 0x5A,
  0xEB, 0xA3, 0x13, 0x5E, 0x13, 0xA5, 0xEC, 0x0F,
  0x06, 0x8E, 0x25, 0xB9, 0x61, 0xD1, 0x87, 0x06,
  0x86, 0xCC, 0xEC, 0x86, 0xDF, 0xF8, 0x9E, 0xD7,
  0x7E, 0xC0, 0x76, 0x1A, 0xDF, 0x9F, 0xC9, 0x48,
  0xC8, 0xB2, 0x9C, 0xF6, 0x9C, 0x8C, 0x60, 0x08,
  0x82, 0x79, 0xAE, 0xC2, 0x92, 0x08, 0xD2, 0xA8,
  0xB4, 0x77, 0xCD, 0xBD, 0x69, 0x54, 0xD6, 0x3C,
  0x94, 0x8F, 0x19, 0x75, 0x7F, 0x81, 0xED, 0xEF,
  0x24, 0xD8, 0x4B, 0x80, 0x7B, 0xEB, 0x6D, 0xBE,
  0x2E, 0xD5, 0x63, 0x12, 0x3A, 0x8A, 0xEA, 0x2A,
  0xAA, 0x71, 0xC7, 0xAB, 0x73, 0xC3, 0xA3, 0x63,
  0xE3, 0x38, 0x8F, 0xE3, 0x3F, 0x8F, 0x8B, 0x51,
  0xD3, 0x68,
};

static unsigned char vfs5011_prepare_02[] = { /* 2565 B */
  0x02, 0xF0, 0x00, 0x14, 0x00, 0x03, 0x00, 0x09,
  0x00, 0x04, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x18, 0x20,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x20, 0x04, 0x30, 0x08,
  0x00, 0x80, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x24, 0x20, 0x04, 0x30, 0x00, 0x00, 0xFF, 0x01,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x2C, 0x20, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x40, 0x20, 0x04, 0x30, 0xFF, 0x03,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x44,
  0x20, 0x04, 0x30, 0xE5, 0x03, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x48, 0x20, 0x04, 0x30,
  0xEA, 0x03, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x4C, 0x20, 0x04, 0x30, 0x0A, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x20,
  0x04, 0x30, 0x01, 0xDE, 0x01, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x00, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x04, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x08, 0x21, 0x04,
  0x30, 0x02, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x0C, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x14, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x18, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x1C, 0x21,
  0x04, 0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x21, 0x04, 0x30, 0x08,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x40, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x44, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x48, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x4C,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x50, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x54, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x58, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x5C, 0x21, 0x04, 0x30, 0x1F,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x60, 0x21, 0x04, 0x30, 0x08, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x80, 0x21, 0x04,
  0x30, 0x30, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x84, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x88,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x8C, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x90, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x94, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x98, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x9C, 0x21, 0x04, 0x30, 0x1F, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xA0, 0x21, 0x04,
  0x30, 0x04, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xC0, 0x21, 0x04, 0x30, 0x30, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xC8, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xCC, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xD0, 0x21,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xD4, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xD8, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xDC, 0x21, 0x04,
  0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xE0, 0x21, 0x04, 0x30, 0x04, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xA0,
  0x20, 0x04, 0x30, 0xEF, 0xE1, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xA4, 0x20, 0x04, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xB0, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4, 0x20,
  0x04, 0x30, 0x14, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xC8, 0x20, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xCC, 0x20, 0x04, 0x30, 0x20, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x50, 0x20, 0x04,
  0x30, 0x00, 0x00, 0x74, 0x01, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xA8, 0x20, 0x04, 0x30, 0xFE, 0x21,
  0x74, 0x01, 0x04, 0x03, 0x00, 0x09, 0x00, 0x04,
  0x00, 0x00, 0x38, 0x00, 0x07, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x08, 0x00, 0x00, 0x38,
  0x00, 0x15, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x0C, 0x00, 0x00, 0x38, 0x01, 0x03, 0x02,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10, 0x00,
  0x00, 0x38, 0x01, 0x07, 0x02, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x14, 0x00, 0x00, 0x38, 0x0C,
  0x0C, 0x05, 0x00, 0x04, 0x02, 0x00, 0x80, 0x05,
  0xFF, 0xF9, 0x87, 0x20, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x07, 0x20,
  0xBA, 0xF8, 0x07, 0x20, 0xB9, 0xF8, 0x07, 0x20,
  0xB8, 0xF8, 0x07, 0x20, 0xB7, 0xF8, 0x07, 0x20,
  0xB6, 0xF8, 0x07, 0x20, 0xB5, 0xF8, 0x07, 0x20,
  0xB4, 0xF8, 0x07, 0x20, 0xB3, 0xF8, 0x07, 0x20,
  0xB2, 0xF8, 0x07, 0x20, 0xB1, 0xF8, 0x07, 0x22,
  0xB0, 0xF8, 0x07, 0x22, 0xAF, 0xF8, 0x07, 0x22,
  0xAE, 0xF8, 0x07, 0x22, 0xAD, 0xF8, 0x07, 0x22,
  0xAC, 0xF8, 0x07, 0x22, 0xAB, 0xF8, 0x07, 0x22,
  0xAA, 0xF8, 0x07, 0x22, 0xA9, 0xF8, 0x07, 0x22,
  0xA8, 0xF8, 0x07, 0x22, 0xA7, 0xF8, 0x07, 0x22,
  0xA6, 0xF8, 0x07, 0x22, 0xA5, 0xF8, 0x07, 0x22,
  0xA4, 0xF8, 0x07, 0x22, 0xA3, 0xF8, 0x07, 0x22,
  0xA2, 0xF8, 0x07, 0x22, 0xA1, 0xF8, 0x07, 0x22,
  0xA0, 0xF8, 0x07, 0x22, 0x9F, 0xF8, 0x07, 0x22,
  0x9E, 0xF8, 0x07, 0x22, 0x9D, 0xF8, 0x07, 0x22,
  0x9C, 0xF8, 0x07, 0x22, 0x9B, 0xF8, 0x07, 0x22,
  0x9A, 0xF8, 0x07, 0x22, 0x99, 0xF8, 0x07, 0x22,
  0x98, 0xF8, 0x07, 0x22, 0x97, 0xF8, 0x07, 0x22,
  0x96, 0xF8, 0x07, 0x22, 0x95, 0xF8, 0x07, 0x22,
  0x94, 0xF8, 0x07, 0x22, 0x93, 0xF8, 0x07, 0x22,
  0x92, 0xF8, 0x07, 0x22, 0x91, 0xF8, 0x07, 0x22,
  0x90, 0xF8, 0x07, 0x22, 0x8F, 0xF8, 0x07, 0x22,
  0x8E, 0xF8, 0x07, 0x22, 0x8D, 0xF8, 0x07, 0x22,
  0x8C, 0xF8, 0x07, 0x22, 0x8B, 0xF8, 0x07, 0x22,
  0x8A, 0xF8, 0x07, 0x22, 0x89, 0xF8, 0x07, 0x22,
  0x88, 0xF8, 0x07, 0x22, 0x87, 0xF8, 0x07, 0x22,
  0x86, 0xF8, 0x07, 0x22, 0x85, 0xF8, 0x07, 0x22,
  0x84, 0xF8, 0x07, 0x22, 0x83, 0xF8, 0x07, 0x22,
  0x82, 0xF8, 0x07, 0x22, 0x81, 0xF8, 0x07, 0x22,
  0x80, 0xF8, 0x07, 0x22, 0x7F, 0xF8, 0x07, 0x22,
  0x7E, 0xF8, 0x07, 0x22, 0x7D, 0xF8, 0x07, 0x22,
  0x7C, 0xF8, 0x07, 0x22, 0x7B, 0xF8, 0x07, 0x22,
  0x7A, 0xF8, 0x07, 0x22, 0x79, 0xF8, 0x07, 0x22,
  0x78, 0xF8, 0x07, 0x22, 0x77, 0xF8, 0x07, 0x22,
  0x76, 0xF8, 0x07, 0x22, 0x75, 0xF8, 0x07, 0x22,
  0x74, 0xF8, 0x07, 0x22, 0x73, 0xF8, 0x07, 0x22,
  0x72, 0xF8, 0x07, 0x22, 0x71, 0xF8, 0x07, 0x22,
  0x70, 0xF8, 0x07, 0x22, 0x6F, 0xF8, 0x07, 0x22,
  0x6E, 0xF8, 0x07, 0x22, 0x6D, 0xF8, 0x07, 0x22,
  0x6C, 0xF8, 0x07, 0x22, 0x6B, 0xF8, 0x07, 0x22,
  0x6A, 0xF8, 0x07, 0x22, 0x69, 0xF8, 0x07, 0x22,
  0x68, 0xF8, 0x07, 0x22, 0x67, 0xF8, 0x07, 0x22,
  0x66, 0xF8, 0x07, 0x22, 0x65, 0xF8, 0x07, 0x22,
  0x64, 0xF8, 0x07, 0x22, 0x63, 0xF8, 0x07, 0x22,
  0x62, 0xF8, 0x07, 0x22, 0x61, 0xF8, 0x07, 0x22,
  0x60, 0xF8, 0x07, 0x22, 0x5F, 0xF8, 0x07, 0x22,
  0x5E, 0xF8, 0x07, 0x22, 0x5D, 0xF8, 0x07, 0x22,
  0x5C, 0xF8, 0x07, 0x22, 0x5B, 0xF8, 0x07, 0x22,
  0x5A, 0xF8, 0x07, 0x22, 0x59, 0xF8, 0x07, 0x22,
  0x58, 0xF8, 0x07, 0x22, 0x57, 0xF8, 0x07, 0x22,
  0x56, 0xF8, 0x07, 0x22, 0x55, 0xF8, 0x07, 0x22,
  0x54, 0xF8, 0x07, 0x22, 0x53, 0xF8, 0x07, 0x22,
  0x52, 0xF8, 0x07, 0x22, 0x51, 0xF8, 0x07, 0x22,
  0x50, 0xF8, 0x07, 0x22, 0x4F, 0xF8, 0x07, 0x22,
  0x4E, 0xF8, 0x07, 0x22, 0x4D, 0xF8, 0x07, 0x22,
  0x4C, 0xF8, 0x07, 0x22, 0x4B, 0xF8, 0x07, 0x22,
  0x4A, 0xF8, 0x07, 0x22, 0x49, 0xF8, 0x07, 0x22,
  0x48, 0xF8, 0x07, 0x22, 0x47, 0xF8, 0x07, 0x22,
  0x46, 0xF8, 0x07, 0x22, 0x45, 0xF8, 0x07, 0x22,
  0x44, 0xF8, 0x07, 0x22, 0x43, 0xF8, 0x07, 0x22,
  0x42, 0xF8, 0x07, 0x22, 0x41, 0xF8, 0x07, 0x22,
  0x40, 0xF8, 0x07, 0x22, 0x3F, 0xF8, 0x07, 0x22,
  0x3E, 0xF8, 0x07, 0x22, 0x3D, 0xF8, 0x07, 0x22,
  0x3C, 0xF8, 0x07, 0x22, 0x3B, 0xF8, 0x07, 0x22,
  0x3A, 0xF8, 0x07, 0x22, 0x39, 0xF8, 0x07, 0x22,
  0x38, 0xF8, 0x07, 0x22, 0x37, 0xF8, 0x07, 0x22,
  0x36, 0xF8, 0x07, 0x22, 0x35, 0xF8, 0x07, 0x22,
  0x34, 0xF8, 0x07, 0x22, 0x33, 0xF8, 0x07, 0x22,
  0x32, 0xF8, 0x07, 0x22, 0x31, 0xF8, 0x07, 0x22,
  0x30, 0xF8, 0x07, 0x22, 0x2F, 0xF8, 0x07, 0x22,
  0x2E, 0xF8, 0x07, 0x22, 0x2D, 0xF8, 0x07, 0x22,
  0x2C, 0xF8, 0x07, 0x22, 0x2B, 0xF8, 0x07, 0x22,
  0x2A, 0xF8, 0x07, 0x22, 0x29, 0xF8, 0x07, 0x22,
  0x28, 0xF8, 0x07, 0x22, 0x27, 0xF8, 0x07, 0x22,
  0x26, 0xF8, 0x07, 0x22, 0x25, 0xF8, 0x07, 0x22,
  0x24, 0xF8, 0x07, 0x22, 0x23, 0xF8, 0x07, 0x20,
  0x22, 0xF8, 0x07, 0x20, 0x21, 0xF8, 0x07, 0x20,
  0x20, 0xF8, 0x07, 0x20, 0x1F, 0xF8, 0x07, 0x20,
  0x1E, 0xF8, 0x07, 0x20, 0x1D, 0xF8, 0x07, 0x20,
  0x1C, 0xF8, 0x07, 0x20, 0x1C, 0xF8, 0x07, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD8, 0xF8, 0x27, 0x20, 0xD9, 0xF8, 0x27, 0x20,
  0xDA, 0xF8, 0x27, 0x20, 0xDB, 0xF8, 0x27, 0x20,
  0xDC, 0xF8, 0x27, 0x20, 0xDD, 0xF8, 0x27, 0x20,
  0xDE, 0xF8, 0x27, 0x20, 0xDF, 0xF8, 0x27, 0x20,
  0xE0, 0xF8, 0x27, 0x20, 0xE1, 0xF8, 0x27, 0x20,
  0xE2, 0xF8, 0x27, 0x20, 0xE3, 0xF8, 0x27, 0x20,
  0xE4, 0xF8, 0x27, 0x20, 0xE5, 0xF8, 0x27, 0x20,
  0xE6, 0xF8, 0x27, 0x20, 0xE7, 0xF8, 0x27, 0x20,
  0xE8, 0xF8, 0x27, 0x20, 0xE9, 0xF8, 0x27, 0x20,
  0xEA, 0xF8, 0x27, 0x20, 0xEB, 0xF8, 0x27, 0x20,
  0xEC, 0xF8, 0x27, 0x20, 0xED, 0xF8, 0x27, 0x20,
  0xEE, 0xF8, 0x27, 0x20, 0xEF, 0xF8, 0x27, 0x20,
  0xF0, 0xF8, 0x27, 0x20, 0xF1, 0xF8, 0x27, 0x20,
  0xF2, 0xF8, 0x27, 0x20, 0xF3, 0xF8, 0x27, 0x20,
  0xF4, 0xF8, 0x27, 0x20, 0xF5, 0xF8, 0x27, 0x20,
  0xF6, 0xF8, 0x27, 0x20, 0xF7, 0xF8, 0x27, 0x20,
  0xF8, 0xF8, 0x27, 0x20, 0xF9, 0xF8, 0x27, 0x20,
  0xFA, 0xF8, 0x27, 0x20, 0xFB, 0xF8, 0x27, 0x20,
  0xFC, 0xF8, 0x27, 0x20, 0xFD, 0xF8, 0x27, 0x20,
  0xFE, 0xF8, 0x27, 0x20, 0xFF, 0xF8, 0x27, 0x20,
  0x00, 0xF9, 0x27, 0x20, 0xD7, 0xF8, 0x27, 0x20,
  0x00, 0xF8, 0x27, 0x20, 0x01, 0xF8, 0x27, 0x20,
  0x02, 0xF8, 0x27, 0x20, 0x03, 0xF8, 0x27, 0x20,
  0x04, 0xF8, 0x27, 0x20, 0x05, 0xF8, 0x27, 0x20,
  0x06, 0xF8, 0x27, 0x20, 0x07, 0xF8, 0x27, 0x20,
  0x08, 0xF8, 0x27, 0x20, 0x09, 0xF8, 0x27, 0x20,
  0x0A, 0xF8, 0x27, 0x20, 0x0B, 0xF8, 0x27, 0x20,
  0x0C, 0xF8, 0x27, 0x20, 0x0D, 0xF8, 0x27, 0x20,
  0x0E, 0xF8, 0x27, 0x20, 0x0F, 0xF8, 0x27, 0x20,
  0x10, 0xF8, 0x27, 0x20, 0x11, 0xF8, 0x27, 0x20,
  0x12, 0xF8, 0x27, 0x20, 0x13, 0xF8, 0x27, 0x20,
  0x14, 0xF8, 0x27, 0x20, 0x15, 0xF8, 0x27, 0x20,
  0x15, 0xF8, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x00, 0x08, 0x00, 0x10, 0x03, 0x18, 0x1C,
  0x10, 0x03, 0x18, 0x1C, 0x03, 0x00, 0x09, 0x00,
  0x00, 0x20, 0x04, 0x30, 0x80, 0x00, 0x00, 0x00,
  0x04, 0x17, 0x00, 0x00, 0x00, 0x05, 0x00, 0x0E,
  0x00, 0x0C, 0x20, 0xFD, 0x00, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x05,
  0x00, 0x0E, 0x00, 0x10, 0x20, 0xFD, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x00,
  0x00, 0x03, 0x00, 0x09, 0x00, 0x04, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x08, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x0C,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x10, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x14, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x18, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x44, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x48, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x4C, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x50, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x54,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x58, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xC8, 0x20, 0x04, 0x30, 0x04, 0x00, 0x00,
  0x00, 0x04, 0x05, 0x00, 0x0E, 0x00, 0x14, 0x20,
  0xFF, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x84, 0x00, 0x03, 0x00, 0x09, 0x00,
  0x84, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x88, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x8C, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x90,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x94, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x98, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xA0, 0x21,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x21, 0x04, 0x30, 0x07,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x60, 0x21, 0x04, 0x30, 0x07, 0x00, 0x00, 0x00,
  0x04, 0x15, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x20, 0x28, 0x00, 0x00,
};

static unsigned char vfs5011_prepare_03[] = { /* 117 B */
  0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0xFF, 0x00, 0x00, 0xFF, 0xF4, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
  0x00, 0x00, 0x00, 0xF4, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x20, 0xBF, 0x02, 0x00,
};

static unsigned char vfs5011_prepare_04[] = { /* 2903 B */
  0x02, 0xF0, 0x00, 0x00, 0x00, 0x03, 0x00, 0x09,
  0x00, 0x04, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x18, 0x20,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x20, 0x04, 0x30, 0x08,
  0x00, 0x80, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x24, 0x20, 0x04, 0x30, 0x00, 0x00, 0xFF, 0x01,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x2C, 0x20, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x40, 0x20, 0x04, 0x30, 0xFF, 0x03,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x44,
  0x20, 0x04, 0x30, 0xE5, 0x03, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x48, 0x20, 0x04, 0x30,
  0xEA, 0x03, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x4C, 0x20, 0x04, 0x30, 0x0A, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x54, 0x20,
  0x04, 0x30, 0x01, 0xDE, 0x01, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x00, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x04, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x08, 0x21, 0x04,
  0x30, 0x02, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x0C, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x14, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x18, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x1C, 0x21,
  0x04, 0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x20, 0x21, 0x04, 0x30, 0x08,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x40, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x44, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x48, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x4C,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x50, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x54, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x58, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x5C, 0x21, 0x04, 0x30, 0x1F,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x60, 0x21, 0x04, 0x30, 0x08, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x80, 0x21, 0x04,
  0x30, 0x30, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x84, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x88,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x8C, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x90, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x94, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x98, 0x21, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x9C, 0x21, 0x04, 0x30, 0x1F, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xA0, 0x21, 0x04,
  0x30, 0x04, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xC0, 0x21, 0x04, 0x30, 0x30, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xC8, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xCC, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xD0, 0x21,
  0x04, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xD4, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xD8, 0x21, 0x04, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xDC, 0x21, 0x04,
  0x30, 0x1F, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xE0, 0x21, 0x04, 0x30, 0x04, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xA0,
  0x20, 0x04, 0x30, 0xEF, 0xE1, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0xA4, 0x20, 0x04, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0xB0, 0x20, 0x04, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0xC4, 0x20,
  0x04, 0x30, 0x14, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0xC8, 0x20, 0x04, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0xCC, 0x20, 0x04, 0x30, 0x20, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x50, 0x20, 0x04,
  0x30, 0x00, 0x00, 0x74, 0x01, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xA8, 0x20, 0x04, 0x30, 0xFE, 0x21,
  0x74, 0x01, 0x04, 0x03, 0x00, 0x09, 0x00, 0x04,
  0x00, 0x00, 0x38, 0x00, 0x07, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x08, 0x00, 0x00, 0x38,
  0x00, 0x15, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x0C, 0x00, 0x00, 0x38, 0x01, 0x03, 0x02,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x10, 0x00,
  0x00, 0x38, 0x01, 0x07, 0x02, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x14, 0x00, 0x00, 0x38, 0x0C,
  0x0C, 0x05, 0x00, 0x04, 0x02, 0x00, 0x80, 0x05,
  0xFF, 0xF9, 0x87, 0x20, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x87, 0x00,
  0xBB, 0xF8, 0x87, 0x00, 0xBB, 0xF8, 0x07, 0x20,
  0xBA, 0xF8, 0x07, 0x20, 0xB9, 0xF8, 0x07, 0x20,
  0xB8, 0xF8, 0x07, 0x20, 0xB7, 0xF8, 0x07, 0x20,
  0xB6, 0xF8, 0x07, 0x20, 0xB5, 0xF8, 0x07, 0x20,
  0xB4, 0xF8, 0x07, 0x20, 0xB3, 0xF8, 0x07, 0x20,
  0xB2, 0xF8, 0x07, 0x20, 0xB1, 0xF8, 0x07, 0x22,
  0xB0, 0xF8, 0x07, 0x22, 0xAF, 0xF8, 0x07, 0x22,
  0xAE, 0xF8, 0x07, 0x22, 0xAD, 0xF8, 0x07, 0x22,
  0xAC, 0xF8, 0x07, 0x22, 0xAB, 0xF8, 0x07, 0x22,
  0xAA, 0xF8, 0x07, 0x22, 0xA9, 0xF8, 0x07, 0x22,
  0xA8, 0xF8, 0x07, 0x22, 0xA7, 0xF8, 0x07, 0x22,
  0xA6, 0xF8, 0x07, 0x22, 0xA5, 0xF8, 0x07, 0x22,
  0xA4, 0xF8, 0x07, 0x22, 0xA3, 0xF8, 0x07, 0x22,
  0xA2, 0xF8, 0x07, 0x22, 0xA1, 0xF8, 0x07, 0x22,
  0xA0, 0xF8, 0x07, 0x22, 0x9F, 0xF8, 0x07, 0x22,
  0x9E, 0xF8, 0x07, 0x22, 0x9D, 0xF8, 0x07, 0x22,
  0x9C, 0xF8, 0x07, 0x22, 0x9B, 0xF8, 0x07, 0x22,
  0x9A, 0xF8, 0x07, 0x22, 0x99, 0xF8, 0x07, 0x22,
  0x98, 0xF8, 0x07, 0x22, 0x97, 0xF8, 0x07, 0x22,
  0x96, 0xF8, 0x07, 0x22, 0x95, 0xF8, 0x07, 0x22,
  0x94, 0xF8, 0x07, 0x22, 0x93, 0xF8, 0x07, 0x22,
  0x92, 0xF8, 0x07, 0x22, 0x91, 0xF8, 0x07, 0x22,
  0x90, 0xF8, 0x07, 0x22, 0x8F, 0xF8, 0x07, 0x22,
  0x8E, 0xF8, 0x07, 0x22, 0x8D, 0xF8, 0x07, 0x22,
  0x8C, 0xF8, 0x07, 0x22, 0x8B, 0xF8, 0x07, 0x22,
  0x8A, 0xF8, 0x07, 0x22, 0x89, 0xF8, 0x07, 0x22,
  0x88, 0xF8, 0x07, 0x22, 0x87, 0xF8, 0x07, 0x22,
  0x86, 0xF8, 0x07, 0x22, 0x85, 0xF8, 0x07, 0x22,
  0x84, 0xF8, 0x07, 0x22, 0x83, 0xF8, 0x07, 0x22,
  0x82, 0xF8, 0x07, 0x22, 0x81, 0xF8, 0x07, 0x22,
  0x80, 0xF8, 0x07, 0x22, 0x7F, 0xF8, 0x07, 0x22,
  0x7E, 0xF8, 0x07, 0x22, 0x7D, 0xF8, 0x07, 0x22,
  0x7C, 0xF8, 0x07, 0x22, 0x7B, 0xF8, 0x07, 0x22,
  0x7A, 0xF8, 0x07, 0x22, 0x79, 0xF8, 0x07, 0x22,
  0x78, 0xF8, 0x07, 0x22, 0x77, 0xF8, 0x07, 0x22,
  0x76, 0xF8, 0x07, 0x22, 0x75, 0xF8, 0x07, 0x22,
  0x74, 0xF8, 0x07, 0x22, 0x73, 0xF8, 0x07, 0x22,
  0x72, 0xF8, 0x07, 0x22, 0x71, 0xF8, 0x07, 0x22,
  0x70, 0xF8, 0x07, 0x22, 0x6F, 0xF8, 0x07, 0x22,
  0x6E, 0xF8, 0x07, 0x22, 0x6D, 0xF8, 0x07, 0x22,
  0x6C, 0xF8, 0x07, 0x22, 0x6B, 0xF8, 0x07, 0x22,
  0x6A, 0xF8, 0x07, 0x22, 0x69, 0xF8, 0x07, 0x22,
  0x68, 0xF8, 0x07, 0x22, 0x67, 0xF8, 0x07, 0x22,
  0x66, 0xF8, 0x07, 0x22, 0x65, 0xF8, 0x07, 0x22,
  0x64, 0xF8, 0x07, 0x22, 0x63, 0xF8, 0x07, 0x22,
  0x62, 0xF8, 0x07, 0x22, 0x61, 0xF8, 0x07, 0x22,
  0x60, 0xF8, 0x07, 0x22, 0x5F, 0xF8, 0x07, 0x22,
  0x5E, 0xF8, 0x07, 0x22, 0x5D, 0xF8, 0x07, 0x22,
  0x5C, 0xF8, 0x07, 0x22, 0x5B, 0xF8, 0x07, 0x22,
  0x5A, 0xF8, 0x07, 0x22, 0x59, 0xF8, 0x07, 0x22,
  0x58, 0xF8, 0x07, 0x22, 0x57, 0xF8, 0x07, 0x22,
  0x56, 0xF8, 0x07, 0x22, 0x55, 0xF8, 0x07, 0x22,
  0x54, 0xF8, 0x07, 0x22, 0x53, 0xF8, 0x07, 0x22,
  0x52, 0xF8, 0x07, 0x22, 0x51, 0xF8, 0x07, 0x22,
  0x50, 0xF8, 0x07, 0x22, 0x4F, 0xF8, 0x07, 0x22,
  0x4E, 0xF8, 0x07, 0x22, 0x4D, 0xF8, 0x07, 0x22,
  0x4C, 0xF8, 0x07, 0x22, 0x4B, 0xF8, 0x07, 0x22,
  0x4A, 0xF8, 0x07, 0x22, 0x49, 0xF8, 0x07, 0x22,
  0x48, 0xF8, 0x07, 0x22, 0x47, 0xF8, 0x07, 0x22,
  0x46, 0xF8, 0x07, 0x22, 0x45, 0xF8, 0x07, 0x22,
  0x44, 0xF8, 0x07, 0x22, 0x43, 0xF8, 0x07, 0x22,
  0x42, 0xF8, 0x07, 0x22, 0x41, 0xF8, 0x07, 0x22,
  0x40, 0xF8, 0x07, 0x22, 0x3F, 0xF8, 0x07, 0x22,
  0x3E, 0xF8, 0x07, 0x22, 0x3D, 0xF8, 0x07, 0x22,
  0x3C, 0xF8, 0x07, 0x22, 0x3B, 0xF8, 0x07, 0x22,
  0x3A, 0xF8, 0x07, 0x22, 0x39, 0xF8, 0x07, 0x22,
  0x38, 0xF8, 0x07, 0x22, 0x37, 0xF8, 0x07, 0x22,
  0x36, 0xF8, 0x07, 0x22, 0x35, 0xF8, 0x07, 0x22,
  0x34, 0xF8, 0x07, 0x22, 0x33, 0xF8, 0x07, 0x22,
  0x32, 0xF8, 0x07, 0x22, 0x31, 0xF8, 0x07, 0x22,
  0x30, 0xF8, 0x07, 0x22, 0x2F, 0xF8, 0x07, 0x22,
  0x2E, 0xF8, 0x07, 0x22, 0x2D, 0xF8, 0x07, 0x22,
  0x2C, 0xF8, 0x07, 0x22, 0x2B, 0xF8, 0x07, 0x22,
  0x2A, 0xF8, 0x07, 0x22, 0x29, 0xF8, 0x07, 0x22,
  0x28, 0xF8, 0x07, 0x22, 0x27, 0xF8, 0x07, 0x22,
  0x26, 0xF8, 0x07, 0x22, 0x25, 0xF8, 0x07, 0x22,
  0x24, 0xF8, 0x07, 0x22, 0x23, 0xF8, 0x07, 0x20,
  0x22, 0xF8, 0x07, 0x20, 0x21, 0xF8, 0x07, 0x20,
  0x20, 0xF8, 0x07, 0x20, 0x1F, 0xF8, 0x07, 0x20,
  0x1E, 0xF8, 0x07, 0x20, 0x1D, 0xF8, 0x07, 0x20,
  0x1C, 0xF8, 0x07, 0x20, 0x1C, 0xF8, 0x07, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD7, 0xF8, 0xA7, 0x00, 0xD7, 0xF8, 0xA7, 0x00,
  0xD8, 0xF8, 0x27, 0x20, 0xD9, 0xF8, 0x27, 0x20,
  0xDA, 0xF8, 0x27, 0x20, 0xDB, 0xF8, 0x27, 0x20,
  0xDC, 0xF8, 0x27, 0x20, 0xDD, 0xF8, 0x27, 0x20,
  0xDE, 0xF8, 0x27, 0x20, 0xDF, 0xF8, 0x27, 0x20,
  0xE0, 0xF8, 0x27, 0x20, 0xE1, 0xF8, 0x27, 0x20,
  0xE2, 0xF8, 0x27, 0x20, 0xE3, 0xF8, 0x27, 0x20,
  0xE4, 0xF8, 0x27, 0x20, 0xE5, 0xF8, 0x27, 0x20,
  0xE6, 0xF8, 0x27, 0x20, 0xE7, 0xF8, 0x27, 0x20,
  0xE8, 0xF8, 0x27, 0x20, 0xE9, 0xF8, 0x27, 0x20,
  0xEA, 0xF8, 0x27, 0x20, 0xEB, 0xF8, 0x27, 0x20,
  0xEC, 0xF8, 0x27, 0x20, 0xED, 0xF8, 0x27, 0x20,
  0xEE, 0xF8, 0x27, 0x20, 0xEF, 0xF8, 0x27, 0x20,
  0xF0, 0xF8, 0x27, 0x20, 0xF1, 0xF8, 0x27, 0x20,
  0xF2, 0xF8, 0x27, 0x20, 0xF3, 0xF8, 0x27, 0x20,
  0xF4, 0xF8, 0x27, 0x20, 0xF5, 0xF8, 0x27, 0x20,
  0xF6, 0xF8, 0x27, 0x20, 0xF7, 0xF8, 0x27, 0x20,
  0xF8, 0xF8, 0x27, 0x20, 0xF9, 0xF8, 0x27, 0x20,
  0xFA, 0xF8, 0x27, 0x20, 0xFB, 0xF8, 0x27, 0x20,
  0xFC, 0xF8, 0x27, 0x20, 0xFD, 0xF8, 0x27, 0x20,
  0xFE, 0xF8, 0x27, 0x20, 0xFF, 0xF8, 0x27, 0x20,
  0x00, 0xF9, 0x27, 0x20, 0xD7, 0xF8, 0x27, 0x20,
  0x00, 0xF8, 0x27, 0x20, 0x01, 0xF8, 0x27, 0x20,
  0x02, 0xF8, 0x27, 0x20, 0x03, 0xF8, 0x27, 0x20,
  0x04, 0xF8, 0x27, 0x20, 0x05, 0xF8, 0x27, 0x20,
  0x06, 0xF8, 0x27, 0x20, 0x07, 0xF8, 0x27, 0x20,
  0x08, 0xF8, 0x27, 0x20, 0x09, 0xF8, 0x27, 0x20,
  0x0A, 0xF8, 0x27, 0x20, 0x0B, 0xF8, 0x27, 0x20,
  0x0C, 0xF8, 0x27, 0x20, 0x0D, 0xF8, 0x27, 0x20,
  0x0E, 0xF8, 0x27, 0x20, 0x0F, 0xF8, 0x27, 0x20,
  0x10, 0xF8, 0x27, 0x20, 0x11, 0xF8, 0x27, 0x20,
  0x12, 0xF8, 0x27, 0x20, 0x13, 0xF8, 0x27, 0x20,
  0x14, 0xF8, 0x27, 0x20, 0x15, 0xF8, 0x27, 0x20,
  0x15, 0xF8, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x00, 0x08, 0x00, 0x10, 0x03, 0x18, 0x1C,
  0x10, 0x03, 0x18, 0x1C, 0x03, 0x00, 0x09, 0x00,
  0x00, 0x20, 0x04, 0x30, 0x80, 0x00, 0x00, 0x00,
  0x04, 0x05, 0x00, 0x0E, 0x00, 0x0C, 0x20, 0xFD,
  0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x05, 0x00, 0x0E, 0x00, 0x10,
  0x20, 0xFD, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x05, 0x00, 0x00, 0x03, 0x00, 0x09,
  0x00, 0x04, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x08, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x0C, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x10, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x14, 0x21, 0x04,
  0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0x18, 0x21, 0x04, 0x30, 0x01, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x44,
  0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x48, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x4C, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x50, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x54, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x58, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0xC8, 0x20, 0x04,
  0x30, 0x04, 0x00, 0x00, 0x00, 0x04, 0x05, 0x00,
  0x0E, 0x00, 0x14, 0x20, 0xFF, 0xFF, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x00,
  0x03, 0x00, 0x09, 0x00, 0x84, 0x21, 0x04, 0x30,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09,
  0x00, 0x88, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00,
  0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x8C, 0x21,
  0x04, 0x30, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03,
  0x00, 0x09, 0x00, 0x90, 0x21, 0x04, 0x30, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00,
  0x94, 0x21, 0x04, 0x30, 0x01, 0x00, 0x00, 0x00,
  0x04, 0x03, 0x00, 0x09, 0x00, 0x98, 0x21, 0x04,
  0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00,
  0x09, 0x00, 0xA0, 0x21, 0x04, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x03, 0x00, 0x09, 0x00, 0x20,
  0x21, 0x04, 0x30, 0x07, 0x00, 0x00, 0x00, 0x04,
  0x03, 0x00, 0x09, 0x00, 0x60, 0x21, 0x04, 0x30,
  0x07, 0x00, 0x00, 0x00, 0x04, 0x15, 0x00, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x28, 0x00,
  0x00, 0x18, 0x00, 0x52, 0x01, 0x08, 0x00, 0x05,
  0x00, 0x0A, 0x00, 0xFA, 0x00, 0x1E, 0x00, 0xC8,
  0x00, 0x00, 0x00, 0x9F, 0x00, 0x38, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
  0xFF, 0xFB, 0xF9, 0xFC, 0xFD, 0xFF, 0xFD, 0xFE,
  0x00, 0x01, 0x00, 0x00, 0x03, 0x01, 0x01, 0x02,
  0x06, 0x05, 0x05, 0x06, 0x05, 0x08, 0x0A, 0x06,
  0x09, 0x09, 0x06, 0x08, 0x05, 0x04, 0x03, 0x04,
  0x03, 0x05, 0x07, 0x07, 0x09, 0x05, 0x04, 0x03,
  0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0xFF, 0x00,
  0xFF, 0x00, 0xFB, 0xFD, 0xFF, 0xFF, 0x01, 0xFF,
  0xFD, 0xFF, 0x01, 0x02, 0x01, 0xFE, 0xFF, 0x01,
  0xFE, 0xFC, 0x00, 0xFF, 0x01, 0x01, 0x00, 0x00,
  0xFF, 0xFF, 0x04, 0x03, 0x00, 0x01, 0xFE, 0x02,
  0x02, 0x03, 0x03, 0x00, 0xFF, 0xFA, 0xFB, 0xFC,
  0xFF, 0xFF, 0x02, 0xFF, 0x01, 0xFF, 0xFE, 0xFD,
  0xFF, 0xFE, 0xFB, 0xF9, 0xF9, 0xFC, 0xFC, 0xFC,
  0xF5, 0xF3, 0xF8, 0xF5, 0xF5, 0xF5, 0xF9, 0xFB,
  0xFE, 0xFC, 0xFA, 0xF8, 0xFC, 0xF9, 0xF7, 0xF6,
  0xF6, 0xF7, 0xFB, 0xF7, 0xF9, 0xF9, 0xF8, 0xF8,
  0xF1, 0xF6, 0xF9, 0xFC, 0xFE, 0xFC, 0xFE, 0x00,
  0xFB, 0xFE, 0xFC, 0xFC, 0xFC, 0xFB, 0xFD, 0xFB,
  0xFC, 0xFA, 0xFC, 0xFA, 0x01, 0x02, 0xFE, 0xFE,
  0xFC, 0xF7, 0xF4, 0xF4, 0xED, 0xE1, 0xD7, 0x01,
  0x04, 0x03, 0x04, 0x08, 0x0B, 0x09, 0x09, 0x09,
  0x05, 0x06, 0x08, 0x05, 0x03, 0x00, 0x00, 0x01,
  0x00, 0xFF, 0xFF, 0xFE, 0xFD, 0xFD, 0xFC, 0xFF,
  0x02, 0xFD, 0xFB, 0xFC, 0xFA, 0xFC, 0xFD, 0xFF,
  0xFF, 0xFC, 0xFC, 0xFB, 0xFC, 0xFE, 0xFF, 0x00,
  0x01, 0x0B, 0x09, 0x07, 0x06, 0x03, 0x06, 0x08,
  0x07, 0x06, 0x07, 0x08, 0x08, 0x09, 0x0B, 0x0D,
  0x0E, 0x10, 0x15, 0x15, 0x19, 0x1B, 0x20, 0x01,
  0x00, 0xFF, 0xFF, 0xFE, 0xFD, 0xFD, 0xFC, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
};
