//===----------------------- View.h -----------------------------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
/// \file
///
/// This file defines the main interface for Views. Each view contributes a
/// portion of the final report generated by the tool.
///
//===----------------------------------------------------------------------===//

#ifndef LLVM_TOOLS_LLVM_MCA_VIEW_H
#define LLVM_TOOLS_LLVM_MCA_VIEW_H

#include "HWEventListener.h"
#include "llvm/Support/raw_ostream.h"

namespace mca {

class View : public HWEventListener {
public:
  virtual void printView(llvm::raw_ostream &OS) const = 0;
  virtual ~View() = default;
  void anchor() override;
};
} // namespace mca

#endif
