; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+experimental-b -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32IB
; RUN: llc -mtriple=riscv32 -mattr=+experimental-zbe -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32IBE

declare i32 @llvm.riscv.bcompress.i32(i32 %a, i32 %b)

define i32 @bcompress32(i32 %a, i32 %b) nounwind {
; RV32IB-LABEL: bcompress32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    bcompress a0, a0, a1
; RV32IB-NEXT:    ret
;
; RV32IBE-LABEL: bcompress32:
; RV32IBE:       # %bb.0:
; RV32IBE-NEXT:    bcompress a0, a0, a1
; RV32IBE-NEXT:    ret
  %tmp = call i32 @llvm.riscv.bcompress.i32(i32 %a, i32 %b)
 ret i32 %tmp
}

declare i32 @llvm.riscv.bdecompress.i32(i32 %a, i32 %b)

define i32 @bdecompress32(i32 %a, i32 %b) nounwind {
; RV32IB-LABEL: bdecompress32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    bdecompress a0, a0, a1
; RV32IB-NEXT:    ret
;
; RV32IBE-LABEL: bdecompress32:
; RV32IBE:       # %bb.0:
; RV32IBE-NEXT:    bdecompress a0, a0, a1
; RV32IBE-NEXT:    ret
  %tmp = call i32 @llvm.riscv.bdecompress.i32(i32 %a, i32 %b)
 ret i32 %tmp
}
