; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-linux | FileCheck %s -check-prefix=X86-64
; RUN: llc < %s -mtriple=x86_64-cygwin | FileCheck %s -check-prefix=WIN64
; RUN: llc < %s -mtriple=x86_64-win32 | FileCheck %s -check-prefix=WIN64
; RUN: llc < %s -mtriple=x86_64-mingw32 | FileCheck %s -check-prefix=WIN64

define i64 @mod128(i128 %x) nounwind {
; X86-64-LABEL: mod128:
; X86-64:       # %bb.0:
; X86-64-NEXT:    pushq %rax
; X86-64-NEXT:    movl $3, %edx
; X86-64-NEXT:    xorl %ecx, %ecx
; X86-64-NEXT:    callq __modti3
; X86-64-NEXT:    popq %rcx
; X86-64-NEXT:    retq
;
; WIN64-LABEL: mod128:
; WIN64:       # %bb.0:
; WIN64-NEXT:    subq $72, %rsp
; WIN64-NEXT:    movq %rdx, {{[0-9]+}}(%rsp)
; WIN64-NEXT:    movq %rcx, {{[0-9]+}}(%rsp)
; WIN64-NEXT:    movq $3, {{[0-9]+}}(%rsp)
; WIN64-NEXT:    movq $0, {{[0-9]+}}(%rsp)
; WIN64-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN64-NEXT:    callq __modti3
; WIN64-NEXT:    movq %xmm0, %rax
; WIN64-NEXT:    addq $72, %rsp
; WIN64-NEXT:    retq


  %1 = srem i128 %x, 3
  %2 = trunc i128 %1 to i64
  ret i64 %2
}

define i64 @div128(i128 %x) nounwind {
; X86-64-LABEL: div128:
; X86-64:       # %bb.0:
; X86-64-NEXT:    pushq %rax
; X86-64-NEXT:    movl $3, %edx
; X86-64-NEXT:    xorl %ecx, %ecx
; X86-64-NEXT:    callq __divti3
; X86-64-NEXT:    popq %rcx
; X86-64-NEXT:    retq
;
; WIN64-LABEL: div128:
; WIN64:       # %bb.0:
; WIN64-NEXT:    subq $72, %rsp
; WIN64-NEXT:    movq %rdx, {{[0-9]+}}(%rsp)
; WIN64-NEXT:    movq %rcx, {{[0-9]+}}(%rsp)
; WIN64-NEXT:    movq $3, {{[0-9]+}}(%rsp)
; WIN64-NEXT:    movq $0, {{[0-9]+}}(%rsp)
; WIN64-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN64-NEXT:    callq __divti3
; WIN64-NEXT:    movq %xmm0, %rax
; WIN64-NEXT:    addq $72, %rsp
; WIN64-NEXT:    retq


  %1 = sdiv i128 %x, 3
  %2 = trunc i128 %1 to i64
  ret i64 %2
}

define i64 @umod128(i128 %x) nounwind {
; X86-64-LABEL: umod128:
; X86-64:       # %bb.0:
; X86-64-NEXT:    pushq %rax
; X86-64-NEXT:    movl $3, %edx
; X86-64-NEXT:    xorl %ecx, %ecx
; X86-64-NEXT:    callq __umodti3
; X86-64-NEXT:    popq %rcx
; X86-64-NEXT:    retq
;
; WIN64-LABEL: umod128:
; WIN64:       # %bb.0:
; WIN64-NEXT:    subq $72, %rsp
; WIN64-NEXT:    movq %rdx, {{[0-9]+}}(%rsp)
; WIN64-NEXT:    movq %rcx, {{[0-9]+}}(%rsp)
; WIN64-NEXT:    movq $3, {{[0-9]+}}(%rsp)
; WIN64-NEXT:    movq $0, {{[0-9]+}}(%rsp)
; WIN64-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN64-NEXT:    callq __umodti3
; WIN64-NEXT:    movq %xmm0, %rax
; WIN64-NEXT:    addq $72, %rsp
; WIN64-NEXT:    retq


  %1 = urem i128 %x, 3
  %2 = trunc i128 %1 to i64
  ret i64 %2
}

define i64 @udiv128(i128 %x) nounwind {
; X86-64-LABEL: udiv128:
; X86-64:       # %bb.0:
; X86-64-NEXT:    pushq %rax
; X86-64-NEXT:    movl $3, %edx
; X86-64-NEXT:    xorl %ecx, %ecx
; X86-64-NEXT:    callq __udivti3
; X86-64-NEXT:    popq %rcx
; X86-64-NEXT:    retq
;
; WIN64-LABEL: udiv128:
; WIN64:       # %bb.0:
; WIN64-NEXT:    subq $72, %rsp
; WIN64-NEXT:    movq %rdx, {{[0-9]+}}(%rsp)
; WIN64-NEXT:    movq %rcx, {{[0-9]+}}(%rsp)
; WIN64-NEXT:    movq $3, {{[0-9]+}}(%rsp)
; WIN64-NEXT:    movq $0, {{[0-9]+}}(%rsp)
; WIN64-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN64-NEXT:    callq __udivti3
; WIN64-NEXT:    movq %xmm0, %rax
; WIN64-NEXT:    addq $72, %rsp
; WIN64-NEXT:    retq


  %1 = udiv i128 %x, 3
  %2 = trunc i128 %1 to i64
  ret i64 %2
}
