; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve -verify-machineinstrs %s -o - | FileCheck %s

define arm_aapcs_vfpcc <16 x i8> @sadd_int8_t(<16 x i8> %src1, <16 x i8> %src2) {
; CHECK-LABEL: sadd_int8_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqadd.s8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> %src1, <16 x i8> %src2)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @sadd_int16_t(<8 x i16> %src1, <8 x i16> %src2) {
; CHECK-LABEL: sadd_int16_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqadd.s16 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> %src1, <8 x i16> %src2)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @sadd_int32_t(<4 x i32> %src1, <4 x i32> %src2) {
; CHECK-LABEL: sadd_int32_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqadd.s32 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> %src1, <4 x i32> %src2)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <2 x i64> @sadd_int64_t(<2 x i64> %src1, <2 x i64> %src2) {
; CHECK-LABEL: sadd_int64_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, lr}
; CHECK-NEXT:    push {r4, r5, r6, lr}
; CHECK-NEXT:    vmov r0, s7
; CHECK-NEXT:    vmov r2, s3
; CHECK-NEXT:    vmov lr, s6
; CHECK-NEXT:    vmov r5, s4
; CHECK-NEXT:    vmov r6, s0
; CHECK-NEXT:    cmp.w r0, #-1
; CHECK-NEXT:    cset r1, gt
; CHECK-NEXT:    cmp.w r2, #-1
; CHECK-NEXT:    cset r3, gt
; CHECK-NEXT:    cmp r3, r1
; CHECK-NEXT:    vmov r1, s2
; CHECK-NEXT:    cset r12, eq
; CHECK-NEXT:    adds.w r1, r1, lr
; CHECK-NEXT:    adcs r0, r2
; CHECK-NEXT:    cmp.w r0, #-1
; CHECK-NEXT:    cset r2, gt
; CHECK-NEXT:    cmp r3, r2
; CHECK-NEXT:    vmov r3, s5
; CHECK-NEXT:    cset r2, ne
; CHECK-NEXT:    and.w r2, r2, r12
; CHECK-NEXT:    ands r12, r2, #1
; CHECK-NEXT:    vmov r2, s1
; CHECK-NEXT:    it ne
; CHECK-NEXT:    asrne r1, r0, #31
; CHECK-NEXT:    cmp.w r3, #-1
; CHECK-NEXT:    cset lr, gt
; CHECK-NEXT:    cmp.w r2, #-1
; CHECK-NEXT:    cset r4, gt
; CHECK-NEXT:    cmp r4, lr
; CHECK-NEXT:    cset lr, eq
; CHECK-NEXT:    adds r5, r5, r6
; CHECK-NEXT:    adcs r2, r3
; CHECK-NEXT:    mvn r6, #-2147483648
; CHECK-NEXT:    cmp.w r2, #-1
; CHECK-NEXT:    cset r3, gt
; CHECK-NEXT:    cmp r4, r3
; CHECK-NEXT:    cset r3, ne
; CHECK-NEXT:    and.w r3, r3, lr
; CHECK-NEXT:    ands r3, r3, #1
; CHECK-NEXT:    it ne
; CHECK-NEXT:    asrne r5, r2, #31
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    vmov q0[2], q0[0], r5, r1
; CHECK-NEXT:    cset r1, mi
; CHECK-NEXT:    tst.w r1, #1
; CHECK-NEXT:    cinv r1, r6, eq
; CHECK-NEXT:    cmp.w r12, #0
; CHECK-NEXT:    csel r0, r1, r0, ne
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    cset r1, mi
; CHECK-NEXT:    tst.w r1, #1
; CHECK-NEXT:    cinv r1, r6, eq
; CHECK-NEXT:    cmp r3, #0
; CHECK-NEXT:    csel r1, r1, r2, ne
; CHECK-NEXT:    vmov q0[3], q0[1], r1, r0
; CHECK-NEXT:    pop {r4, r5, r6, pc}
entry:
  %0 = call <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> %src1, <2 x i64> %src2)
  ret <2 x i64> %0
}

define arm_aapcs_vfpcc <16 x i8> @uadd_int8_t(<16 x i8> %src1, <16 x i8> %src2) {
; CHECK-LABEL: uadd_int8_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqadd.u8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> %src1, <16 x i8> %src2)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @uadd_int16_t(<8 x i16> %src1, <8 x i16> %src2) {
; CHECK-LABEL: uadd_int16_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqadd.u16 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> %src1, <8 x i16> %src2)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @uadd_int32_t(<4 x i32> %src1, <4 x i32> %src2) {
; CHECK-LABEL: uadd_int32_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqadd.u32 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> %src1, <4 x i32> %src2)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <2 x i64> @uadd_int64_t(<2 x i64> %src1, <2 x i64> %src2) {
; CHECK-LABEL: uadd_int64_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r7, lr}
; CHECK-NEXT:    push {r4, r5, r7, lr}
; CHECK-NEXT:    vmov r2, s6
; CHECK-NEXT:    mov.w r12, #0
; CHECK-NEXT:    vmov r3, s2
; CHECK-NEXT:    vmov r0, s7
; CHECK-NEXT:    vmov r1, s3
; CHECK-NEXT:    vmov r4, s4
; CHECK-NEXT:    vmov r5, s0
; CHECK-NEXT:    adds r2, r2, r3
; CHECK-NEXT:    vmov r3, s5
; CHECK-NEXT:    adcs r0, r1
; CHECK-NEXT:    vmov r1, s1
; CHECK-NEXT:    adcs lr, r12, #0
; CHECK-NEXT:    it ne
; CHECK-NEXT:    movne.w r2, #-1
; CHECK-NEXT:    adds r4, r4, r5
; CHECK-NEXT:    adcs r1, r3
; CHECK-NEXT:    adcs r3, r12, #0
; CHECK-NEXT:    it ne
; CHECK-NEXT:    movne.w r4, #-1
; CHECK-NEXT:    cmp.w lr, #0
; CHECK-NEXT:    vmov q0[2], q0[0], r4, r2
; CHECK-NEXT:    it ne
; CHECK-NEXT:    movne.w r0, #-1
; CHECK-NEXT:    cmp r3, #0
; CHECK-NEXT:    it ne
; CHECK-NEXT:    movne.w r1, #-1
; CHECK-NEXT:    vmov q0[3], q0[1], r1, r0
; CHECK-NEXT:    pop {r4, r5, r7, pc}
entry:
  %0 = call <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64> %src1, <2 x i64> %src2)
  ret <2 x i64> %0
}


define arm_aapcs_vfpcc <16 x i8> @ssub_int8_t(<16 x i8> %src1, <16 x i8> %src2) {
; CHECK-LABEL: ssub_int8_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqsub.s8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> %src1, <16 x i8> %src2)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @ssub_int16_t(<8 x i16> %src1, <8 x i16> %src2) {
; CHECK-LABEL: ssub_int16_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqsub.s16 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16> %src1, <8 x i16> %src2)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @ssub_int32_t(<4 x i32> %src1, <4 x i32> %src2) {
; CHECK-LABEL: ssub_int32_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqsub.s32 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> %src1, <4 x i32> %src2)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <2 x i64> @ssub_int64_t(<2 x i64> %src1, <2 x i64> %src2) {
; CHECK-LABEL: ssub_int64_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, lr}
; CHECK-NEXT:    push {r4, r5, r6, lr}
; CHECK-NEXT:    vmov r0, s7
; CHECK-NEXT:    vmov r2, s3
; CHECK-NEXT:    vmov lr, s6
; CHECK-NEXT:    vmov r5, s4
; CHECK-NEXT:    vmov r6, s0
; CHECK-NEXT:    cmp.w r0, #-1
; CHECK-NEXT:    cset r1, gt
; CHECK-NEXT:    cmp.w r2, #-1
; CHECK-NEXT:    cset r3, gt
; CHECK-NEXT:    cmp r3, r1
; CHECK-NEXT:    vmov r1, s2
; CHECK-NEXT:    cset r12, ne
; CHECK-NEXT:    subs.w r1, r1, lr
; CHECK-NEXT:    sbc.w r0, r2, r0
; CHECK-NEXT:    cmp.w r0, #-1
; CHECK-NEXT:    cset r2, gt
; CHECK-NEXT:    cmp r3, r2
; CHECK-NEXT:    vmov r3, s5
; CHECK-NEXT:    cset r2, ne
; CHECK-NEXT:    and.w r2, r2, r12
; CHECK-NEXT:    ands r12, r2, #1
; CHECK-NEXT:    vmov r2, s1
; CHECK-NEXT:    it ne
; CHECK-NEXT:    asrne r1, r0, #31
; CHECK-NEXT:    cmp.w r3, #-1
; CHECK-NEXT:    cset lr, gt
; CHECK-NEXT:    cmp.w r2, #-1
; CHECK-NEXT:    cset r4, gt
; CHECK-NEXT:    cmp r4, lr
; CHECK-NEXT:    cset lr, ne
; CHECK-NEXT:    subs r5, r6, r5
; CHECK-NEXT:    sbcs r2, r3
; CHECK-NEXT:    mvn r6, #-2147483648
; CHECK-NEXT:    cmp.w r2, #-1
; CHECK-NEXT:    cset r3, gt
; CHECK-NEXT:    cmp r4, r3
; CHECK-NEXT:    cset r3, ne
; CHECK-NEXT:    and.w r3, r3, lr
; CHECK-NEXT:    ands r3, r3, #1
; CHECK-NEXT:    it ne
; CHECK-NEXT:    asrne r5, r2, #31
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    vmov q0[2], q0[0], r5, r1
; CHECK-NEXT:    cset r1, mi
; CHECK-NEXT:    tst.w r1, #1
; CHECK-NEXT:    cinv r1, r6, eq
; CHECK-NEXT:    cmp.w r12, #0
; CHECK-NEXT:    csel r0, r1, r0, ne
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    cset r1, mi
; CHECK-NEXT:    tst.w r1, #1
; CHECK-NEXT:    cinv r1, r6, eq
; CHECK-NEXT:    cmp r3, #0
; CHECK-NEXT:    csel r1, r1, r2, ne
; CHECK-NEXT:    vmov q0[3], q0[1], r1, r0
; CHECK-NEXT:    pop {r4, r5, r6, pc}
entry:
  %0 = call <2 x i64> @llvm.ssub.sat.v2i64(<2 x i64> %src1, <2 x i64> %src2)
  ret <2 x i64> %0
}

define arm_aapcs_vfpcc <16 x i8> @usub_int8_t(<16 x i8> %src1, <16 x i8> %src2) {
; CHECK-LABEL: usub_int8_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqsub.u8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.usub.sat.v16i8(<16 x i8> %src1, <16 x i8> %src2)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @usub_int16_t(<8 x i16> %src1, <8 x i16> %src2) {
; CHECK-LABEL: usub_int16_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqsub.u16 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.usub.sat.v8i16(<8 x i16> %src1, <8 x i16> %src2)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @usub_int32_t(<4 x i32> %src1, <4 x i32> %src2) {
; CHECK-LABEL: usub_int32_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqsub.u32 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.usub.sat.v4i32(<4 x i32> %src1, <4 x i32> %src2)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <2 x i64> @usub_int64_t(<2 x i64> %src1, <2 x i64> %src2) {
; CHECK-LABEL: usub_int64_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r7, lr}
; CHECK-NEXT:    push {r4, r5, r7, lr}
; CHECK-NEXT:    vmov r2, s6
; CHECK-NEXT:    mov.w r12, #0
; CHECK-NEXT:    vmov r3, s2
; CHECK-NEXT:    vmov r0, s7
; CHECK-NEXT:    vmov r1, s3
; CHECK-NEXT:    vmov r4, s4
; CHECK-NEXT:    vmov r5, s0
; CHECK-NEXT:    subs r2, r3, r2
; CHECK-NEXT:    vmov r3, s5
; CHECK-NEXT:    sbcs.w r0, r1, r0
; CHECK-NEXT:    adc r1, r12, #0
; CHECK-NEXT:    rsbs.w lr, r1, #1
; CHECK-NEXT:    vmov r1, s1
; CHECK-NEXT:    it ne
; CHECK-NEXT:    movne r2, #0
; CHECK-NEXT:    subs r4, r5, r4
; CHECK-NEXT:    sbcs r1, r3
; CHECK-NEXT:    adc r3, r12, #0
; CHECK-NEXT:    rsbs.w r3, r3, #1
; CHECK-NEXT:    it ne
; CHECK-NEXT:    movne r4, #0
; CHECK-NEXT:    cmp.w lr, #0
; CHECK-NEXT:    vmov q0[2], q0[0], r4, r2
; CHECK-NEXT:    it ne
; CHECK-NEXT:    movne r0, #0
; CHECK-NEXT:    cmp r3, #0
; CHECK-NEXT:    it ne
; CHECK-NEXT:    movne r1, #0
; CHECK-NEXT:    vmov q0[3], q0[1], r1, r0
; CHECK-NEXT:    pop {r4, r5, r7, pc}
entry:
  %0 = call <2 x i64> @llvm.usub.sat.v2i64(<2 x i64> %src1, <2 x i64> %src2)
  ret <2 x i64> %0
}


declare <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> %src1, <16 x i8> %src2)
declare <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> %src1, <8 x i16> %src2)
declare <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> %src1, <4 x i32> %src2)
declare <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> %src1, <2 x i64> %src2)
declare <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> %src1, <16 x i8> %src2)
declare <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> %src1, <8 x i16> %src2)
declare <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> %src1, <4 x i32> %src2)
declare <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64> %src1, <2 x i64> %src2)
declare <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> %src1, <16 x i8> %src2)
declare <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16> %src1, <8 x i16> %src2)
declare <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> %src1, <4 x i32> %src2)
declare <2 x i64> @llvm.ssub.sat.v2i64(<2 x i64> %src1, <2 x i64> %src2)
declare <16 x i8> @llvm.usub.sat.v16i8(<16 x i8> %src1, <16 x i8> %src2)
declare <8 x i16> @llvm.usub.sat.v8i16(<8 x i16> %src1, <8 x i16> %src2)
declare <4 x i32> @llvm.usub.sat.v4i32(<4 x i32> %src1, <4 x i32> %src2)
declare <2 x i64> @llvm.usub.sat.v2i64(<2 x i64> %src1, <2 x i64> %src2)
