; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instcombine -S | FileCheck %s

target datalayout = "e-m:o-i64:64-f80:128-n8:16:32:64-S128"

; Tests folding constants from two similar selects that feed a add

define float @test1a(i1 zeroext %arg) #0 {
; CHECK-LABEL: @test1a(
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[ARG:%.*]], float 6.000000e+00, float 1.500000e+01
; CHECK-NEXT:    ret float [[TMP2]]
;
  %tmp = select i1 %arg, float 5.000000e+00, float 6.000000e+00
  %tmp1 = select i1 %arg, float 1.000000e+00, float 9.000000e+00
  %tmp2 = fadd float %tmp, %tmp1
  ret float %tmp2
}

; Tests folding multiple expression constants from similar selects that feed a adds

define float @test1b(i1 zeroext %arg) #0 {
; CHECK-LABEL: @test1b(
; CHECK-NEXT:    [[TMP5:%.*]] = select i1 [[ARG:%.*]], float 7.250000e+00, float 2.800000e+01
; CHECK-NEXT:    ret float [[TMP5]]
;
  %tmp = select i1 %arg, float 5.000000e+00, float 6.000000e+00
  %tmp1 = select i1 %arg, float 1.000000e+00, float 9.000000e+00
  %tmp2 = select i1 %arg, float 2.500000e-01, float 4.000000e+00
  %tmp3 = fadd float %tmp, %tmp1
  %tmp4 = fadd float %tmp2, %tmp1
  %tmp5 = fadd float %tmp4, %tmp3
  ret float %tmp5
}

; Tests folding constants from two similar selects that feed a sub

define float @test2(i1 zeroext %arg) #0 {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[ARG:%.*]], float 4.000000e+00, float -3.000000e+00
; CHECK-NEXT:    ret float [[TMP2]]
;
  %tmp = select i1 %arg, float 5.000000e+00, float 6.000000e+00
  %tmp1 = select i1 %arg, float 1.000000e+00, float 9.000000e+00
  %tmp2 = fsub float %tmp, %tmp1
  ret float %tmp2
}

; Tests folding constants from two similar selects that feed a mul

define float @test3(i1 zeroext %arg) #0 {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[ARG:%.*]], float 5.000000e+00, float 5.400000e+01
; CHECK-NEXT:    ret float [[TMP2]]
;
  %tmp = select i1 %arg, float 5.000000e+00, float 6.000000e+00
  %tmp1 = select i1 %arg, float 1.000000e+00, float 9.000000e+00
  %tmp2 = fmul float %tmp, %tmp1
  ret float %tmp2
}

declare void @use_float(float)

; Tests folding constants if the selects have multiple uses but
; we can fold away the binary op with a select.

define float @test4(i1 zeroext %arg) #0 {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    [[TMP:%.*]] = select i1 [[ARG:%.*]], float 5.000000e+00, float 6.000000e+00
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[ARG]], float 5.000000e+00, float 5.400000e+01
; CHECK-NEXT:    call void @use_float(float [[TMP]])
; CHECK-NEXT:    ret float [[TMP2]]
;
  %tmp = select i1 %arg, float 5.000000e+00, float 6.000000e+00
  %tmp1 = select i1 %arg, float 1.000000e+00, float 9.000000e+00
  %tmp2 = fmul float %tmp, %tmp1
  call void @use_float(float %tmp)
  ret float %tmp2
}

; Tests not folding constants if we cannot fold away any of the selects.

define float @test5(i1 zeroext %arg, float %div) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    [[TMP:%.*]] = select i1 [[ARG:%.*]], float [[DIV:%.*]], float 5.000000e+00
; CHECK-NEXT:    [[MUL:%.*]] = fmul contract float [[TMP]], [[TMP]]
; CHECK-NEXT:    call void @use_float(float [[TMP]])
; CHECK-NEXT:    ret float [[MUL]]
;
  %tmp = select i1 %arg, float %div, float 5.000000e+00
  %mul = fmul contract float %tmp, %tmp
  call void @use_float(float %tmp)
  ret float %mul
}

define float @fmul_nnan_nsz(i1 %cond, float %val) {
; CHECK-LABEL: @fmul_nnan_nsz(
; CHECK-NEXT:    ret float 0.000000e+00
;
  %lhs = select i1 %cond, float %val, float +0.0
  %rhs = select i1 %cond, float -0.0, float %val
  %mul = fmul nnan nsz float %lhs, %rhs
  ret float %mul
}

define <2 x float> @fadd_nsz(<2 x i1> %cond, <2 x float> %val) {
; CHECK-LABEL: @fadd_nsz(
; CHECK-NEXT:    ret <2 x float> [[VAL:%.*]]
;
  %lhs = select <2 x i1> %cond, <2 x float> %val, <2 x float> <float +0.0, float +0.0>
  %rhs = select <2 x i1> %cond, <2 x float> <float +0.0, float +0.0>, <2 x float> %val
  %add = fadd nsz <2 x float> %lhs, %rhs
  ret <2 x float> %add
}

define double @fsub_nnan(i1 %cond, double %val, double %val2) {
; CHECK-LABEL: @fsub_nnan(
; CHECK-NEXT:    [[TMP1:%.*]] = fadd nnan double [[VAL2:%.*]], -7.000000e+00
; CHECK-NEXT:    [[ADD:%.*]] = select nnan i1 [[COND:%.*]], double 0.000000e+00, double [[TMP1]]
; CHECK-NEXT:    ret double [[ADD]]
;
  %lhs = select i1 %cond, double %val, double %val2
  %rhs = select i1 %cond, double %val, double 7.0
  %add = fsub nnan double %lhs, %rhs
  ret double %add
}

; TODO combine selects feeding fdiv like we do for fmul, fadd and fsub
define double @fdiv_nnan_nsz(i1 %cond, double %val, double %val2) {
; CHECK-LABEL: @fdiv_nnan_nsz(
; CHECK-NEXT:    [[LHS:%.*]] = select i1 [[COND:%.*]], double [[VAL2:%.*]], double 0.000000e+00
; CHECK-NEXT:    [[RHS:%.*]] = select i1 [[COND]], double 4.200000e+01, double [[VAL:%.*]]
; CHECK-NEXT:    [[ADD:%.*]] = fdiv nnan nsz double [[LHS]], [[RHS]]
; CHECK-NEXT:    ret double [[ADD]]
;
  %lhs = select i1 %cond, double %val2, double 0.0
  %rhs = select i1 %cond, double 42.0, double %val
  %add = fdiv nnan nsz double %lhs, %rhs
  ret double %add
}
