; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -global-isel -stop-after=irtranslator -verify-machineinstrs %s -o - | FileCheck %s -check-prefixes=MIPS32


define  signext i8 @sext_arg_i8(i8 signext %a) {
  ; MIPS32-LABEL: name: sext_arg_i8
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[TRUNC:%[0-9]+]]:_(s8) = G_TRUNC [[COPY]](s32)
  ; MIPS32:   [[SEXT:%[0-9]+]]:_(s32) = G_SEXT [[TRUNC]](s8)
  ; MIPS32:   $v0 = COPY [[SEXT]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  ret i8 %a
}

define zeroext i8 @zext_arg_i8(i8 zeroext %a) {
  ; MIPS32-LABEL: name: zext_arg_i8
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[TRUNC:%[0-9]+]]:_(s8) = G_TRUNC [[COPY]](s32)
  ; MIPS32:   [[ZEXT:%[0-9]+]]:_(s32) = G_ZEXT [[TRUNC]](s8)
  ; MIPS32:   $v0 = COPY [[ZEXT]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  ret i8 %a
}

define i8 @aext_arg_i8(i8 %a) {
  ; MIPS32-LABEL: name: aext_arg_i8
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[TRUNC:%[0-9]+]]:_(s8) = G_TRUNC [[COPY]](s32)
  ; MIPS32:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[TRUNC]](s8)
  ; MIPS32:   $v0 = COPY [[ANYEXT]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  ret i8 %a
}

declare signext i8 @sext_stack_arg_i8(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i8 %a)
declare zeroext i8 @zext_stack_arg_i8(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i8 %a)
declare i8 @aext_stack_arg_i8(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i8 %a)

define signext i8 @call_sext_stack_arg_i8(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i8 signext %a) {
  ; MIPS32-LABEL: name: call_sext_stack_arg_i8
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0, $a1, $a2, $a3
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[COPY1:%[0-9]+]]:_(s32) = COPY $a1
  ; MIPS32:   [[COPY2:%[0-9]+]]:_(s32) = COPY $a2
  ; MIPS32:   [[COPY3:%[0-9]+]]:_(s32) = COPY $a3
  ; MIPS32:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.0
  ; MIPS32:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p0) :: (load 4 from %fixed-stack.0, align 8)
  ; MIPS32:   [[TRUNC:%[0-9]+]]:_(s8) = G_TRUNC [[LOAD]](s32)
  ; MIPS32:   ADJCALLSTACKDOWN 24, 0, implicit-def $sp, implicit $sp
  ; MIPS32:   $a0 = COPY [[COPY]](s32)
  ; MIPS32:   $a1 = COPY [[COPY1]](s32)
  ; MIPS32:   $a2 = COPY [[COPY2]](s32)
  ; MIPS32:   $a3 = COPY [[COPY3]](s32)
  ; MIPS32:   [[COPY4:%[0-9]+]]:_(p0) = COPY $sp
  ; MIPS32:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; MIPS32:   [[GEP:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY4]], [[C]](s32)
  ; MIPS32:   [[SEXT:%[0-9]+]]:_(s32) = G_SEXT [[TRUNC]](s8)
  ; MIPS32:   G_STORE [[SEXT]](s32), [[GEP]](p0) :: (store 4 into stack + 16, align 8)
  ; MIPS32:   JAL @sext_stack_arg_i8, csr_o32, implicit-def $ra, implicit-def $sp, implicit $a0, implicit $a1, implicit $a2, implicit $a3, implicit-def $v0
  ; MIPS32:   [[COPY5:%[0-9]+]]:_(s32) = COPY $v0
  ; MIPS32:   [[TRUNC1:%[0-9]+]]:_(s8) = G_TRUNC [[COPY5]](s32)
  ; MIPS32:   ADJCALLSTACKUP 24, 0, implicit-def $sp, implicit $sp
  ; MIPS32:   [[SEXT1:%[0-9]+]]:_(s32) = G_SEXT [[TRUNC1]](s8)
  ; MIPS32:   $v0 = COPY [[SEXT1]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  %call = call signext i8 @sext_stack_arg_i8(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i8 signext %a)
  ret i8 %call
}

define zeroext i8 @call_zext_stack_arg_i8(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i8 zeroext %a) {
  ; MIPS32-LABEL: name: call_zext_stack_arg_i8
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0, $a1, $a2, $a3
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[COPY1:%[0-9]+]]:_(s32) = COPY $a1
  ; MIPS32:   [[COPY2:%[0-9]+]]:_(s32) = COPY $a2
  ; MIPS32:   [[COPY3:%[0-9]+]]:_(s32) = COPY $a3
  ; MIPS32:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.0
  ; MIPS32:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p0) :: (load 4 from %fixed-stack.0, align 8)
  ; MIPS32:   [[TRUNC:%[0-9]+]]:_(s8) = G_TRUNC [[LOAD]](s32)
  ; MIPS32:   ADJCALLSTACKDOWN 24, 0, implicit-def $sp, implicit $sp
  ; MIPS32:   $a0 = COPY [[COPY]](s32)
  ; MIPS32:   $a1 = COPY [[COPY1]](s32)
  ; MIPS32:   $a2 = COPY [[COPY2]](s32)
  ; MIPS32:   $a3 = COPY [[COPY3]](s32)
  ; MIPS32:   [[COPY4:%[0-9]+]]:_(p0) = COPY $sp
  ; MIPS32:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; MIPS32:   [[GEP:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY4]], [[C]](s32)
  ; MIPS32:   [[ZEXT:%[0-9]+]]:_(s32) = G_ZEXT [[TRUNC]](s8)
  ; MIPS32:   G_STORE [[ZEXT]](s32), [[GEP]](p0) :: (store 4 into stack + 16, align 8)
  ; MIPS32:   JAL @zext_stack_arg_i8, csr_o32, implicit-def $ra, implicit-def $sp, implicit $a0, implicit $a1, implicit $a2, implicit $a3, implicit-def $v0
  ; MIPS32:   [[COPY5:%[0-9]+]]:_(s32) = COPY $v0
  ; MIPS32:   [[TRUNC1:%[0-9]+]]:_(s8) = G_TRUNC [[COPY5]](s32)
  ; MIPS32:   ADJCALLSTACKUP 24, 0, implicit-def $sp, implicit $sp
  ; MIPS32:   [[ZEXT1:%[0-9]+]]:_(s32) = G_ZEXT [[TRUNC1]](s8)
  ; MIPS32:   $v0 = COPY [[ZEXT1]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  %call = call zeroext i8 @zext_stack_arg_i8(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i8 zeroext %a)
  ret i8 %call
}

define i8 @call_aext_stack_arg_i8(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i8 %a) {
  ; MIPS32-LABEL: name: call_aext_stack_arg_i8
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0, $a1, $a2, $a3
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[COPY1:%[0-9]+]]:_(s32) = COPY $a1
  ; MIPS32:   [[COPY2:%[0-9]+]]:_(s32) = COPY $a2
  ; MIPS32:   [[COPY3:%[0-9]+]]:_(s32) = COPY $a3
  ; MIPS32:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.0
  ; MIPS32:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p0) :: (load 4 from %fixed-stack.0, align 8)
  ; MIPS32:   [[TRUNC:%[0-9]+]]:_(s8) = G_TRUNC [[LOAD]](s32)
  ; MIPS32:   ADJCALLSTACKDOWN 24, 0, implicit-def $sp, implicit $sp
  ; MIPS32:   $a0 = COPY [[COPY]](s32)
  ; MIPS32:   $a1 = COPY [[COPY1]](s32)
  ; MIPS32:   $a2 = COPY [[COPY2]](s32)
  ; MIPS32:   $a3 = COPY [[COPY3]](s32)
  ; MIPS32:   [[COPY4:%[0-9]+]]:_(p0) = COPY $sp
  ; MIPS32:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; MIPS32:   [[GEP:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY4]], [[C]](s32)
  ; MIPS32:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[TRUNC]](s8)
  ; MIPS32:   G_STORE [[ANYEXT]](s32), [[GEP]](p0) :: (store 4 into stack + 16, align 8)
  ; MIPS32:   JAL @aext_stack_arg_i8, csr_o32, implicit-def $ra, implicit-def $sp, implicit $a0, implicit $a1, implicit $a2, implicit $a3, implicit-def $v0
  ; MIPS32:   [[COPY5:%[0-9]+]]:_(s32) = COPY $v0
  ; MIPS32:   [[TRUNC1:%[0-9]+]]:_(s8) = G_TRUNC [[COPY5]](s32)
  ; MIPS32:   ADJCALLSTACKUP 24, 0, implicit-def $sp, implicit $sp
  ; MIPS32:   [[ANYEXT1:%[0-9]+]]:_(s32) = G_ANYEXT [[TRUNC1]](s8)
  ; MIPS32:   $v0 = COPY [[ANYEXT1]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  %call = call i8 @aext_stack_arg_i8(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i8 %a)
  ret i8 %call
}


define  signext i16 @sext_arg_i16(i16 signext %a) {
  ; MIPS32-LABEL: name: sext_arg_i16
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[COPY]](s32)
  ; MIPS32:   [[SEXT:%[0-9]+]]:_(s32) = G_SEXT [[TRUNC]](s16)
  ; MIPS32:   $v0 = COPY [[SEXT]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  ret i16 %a
}

define zeroext i16 @zext_arg_i16(i16 zeroext %a) {
  ; MIPS32-LABEL: name: zext_arg_i16
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[COPY]](s32)
  ; MIPS32:   [[ZEXT:%[0-9]+]]:_(s32) = G_ZEXT [[TRUNC]](s16)
  ; MIPS32:   $v0 = COPY [[ZEXT]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  ret i16 %a
}

define i16 @aext_arg_i16(i16 %a) {
  ; MIPS32-LABEL: name: aext_arg_i16
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[COPY]](s32)
  ; MIPS32:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[TRUNC]](s16)
  ; MIPS32:   $v0 = COPY [[ANYEXT]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  ret i16 %a
}

declare signext i16 @sext_stack_arg_i16(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i16 %a)
declare zeroext i16 @zext_stack_arg_i16(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i16 %a)
declare i16 @aext_stack_arg_i16(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i16 %a)

define signext i16 @call_sext_stack_arg_i16(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i16 signext %a) {
  ; MIPS32-LABEL: name: call_sext_stack_arg_i16
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0, $a1, $a2, $a3
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[COPY1:%[0-9]+]]:_(s32) = COPY $a1
  ; MIPS32:   [[COPY2:%[0-9]+]]:_(s32) = COPY $a2
  ; MIPS32:   [[COPY3:%[0-9]+]]:_(s32) = COPY $a3
  ; MIPS32:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.0
  ; MIPS32:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p0) :: (load 4 from %fixed-stack.0, align 8)
  ; MIPS32:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[LOAD]](s32)
  ; MIPS32:   ADJCALLSTACKDOWN 24, 0, implicit-def $sp, implicit $sp
  ; MIPS32:   $a0 = COPY [[COPY]](s32)
  ; MIPS32:   $a1 = COPY [[COPY1]](s32)
  ; MIPS32:   $a2 = COPY [[COPY2]](s32)
  ; MIPS32:   $a3 = COPY [[COPY3]](s32)
  ; MIPS32:   [[COPY4:%[0-9]+]]:_(p0) = COPY $sp
  ; MIPS32:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; MIPS32:   [[GEP:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY4]], [[C]](s32)
  ; MIPS32:   [[SEXT:%[0-9]+]]:_(s32) = G_SEXT [[TRUNC]](s16)
  ; MIPS32:   G_STORE [[SEXT]](s32), [[GEP]](p0) :: (store 4 into stack + 16, align 8)
  ; MIPS32:   JAL @sext_stack_arg_i16, csr_o32, implicit-def $ra, implicit-def $sp, implicit $a0, implicit $a1, implicit $a2, implicit $a3, implicit-def $v0
  ; MIPS32:   [[COPY5:%[0-9]+]]:_(s32) = COPY $v0
  ; MIPS32:   [[TRUNC1:%[0-9]+]]:_(s16) = G_TRUNC [[COPY5]](s32)
  ; MIPS32:   ADJCALLSTACKUP 24, 0, implicit-def $sp, implicit $sp
  ; MIPS32:   [[SEXT1:%[0-9]+]]:_(s32) = G_SEXT [[TRUNC1]](s16)
  ; MIPS32:   $v0 = COPY [[SEXT1]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  %call = call signext i16 @sext_stack_arg_i16(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i16 signext %a)
  ret i16 %call
}

define zeroext i16 @call_zext_stack_arg_i16(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i16 zeroext %a) {
  ; MIPS32-LABEL: name: call_zext_stack_arg_i16
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0, $a1, $a2, $a3
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[COPY1:%[0-9]+]]:_(s32) = COPY $a1
  ; MIPS32:   [[COPY2:%[0-9]+]]:_(s32) = COPY $a2
  ; MIPS32:   [[COPY3:%[0-9]+]]:_(s32) = COPY $a3
  ; MIPS32:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.0
  ; MIPS32:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p0) :: (load 4 from %fixed-stack.0, align 8)
  ; MIPS32:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[LOAD]](s32)
  ; MIPS32:   ADJCALLSTACKDOWN 24, 0, implicit-def $sp, implicit $sp
  ; MIPS32:   $a0 = COPY [[COPY]](s32)
  ; MIPS32:   $a1 = COPY [[COPY1]](s32)
  ; MIPS32:   $a2 = COPY [[COPY2]](s32)
  ; MIPS32:   $a3 = COPY [[COPY3]](s32)
  ; MIPS32:   [[COPY4:%[0-9]+]]:_(p0) = COPY $sp
  ; MIPS32:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; MIPS32:   [[GEP:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY4]], [[C]](s32)
  ; MIPS32:   [[ZEXT:%[0-9]+]]:_(s32) = G_ZEXT [[TRUNC]](s16)
  ; MIPS32:   G_STORE [[ZEXT]](s32), [[GEP]](p0) :: (store 4 into stack + 16, align 8)
  ; MIPS32:   JAL @zext_stack_arg_i16, csr_o32, implicit-def $ra, implicit-def $sp, implicit $a0, implicit $a1, implicit $a2, implicit $a3, implicit-def $v0
  ; MIPS32:   [[COPY5:%[0-9]+]]:_(s32) = COPY $v0
  ; MIPS32:   [[TRUNC1:%[0-9]+]]:_(s16) = G_TRUNC [[COPY5]](s32)
  ; MIPS32:   ADJCALLSTACKUP 24, 0, implicit-def $sp, implicit $sp
  ; MIPS32:   [[ZEXT1:%[0-9]+]]:_(s32) = G_ZEXT [[TRUNC1]](s16)
  ; MIPS32:   $v0 = COPY [[ZEXT1]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  %call = call zeroext i16 @zext_stack_arg_i16(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i16 zeroext %a)
  ret i16 %call
}

define i16 @call_aext_stack_arg_i16(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i16 %a) {
  ; MIPS32-LABEL: name: call_aext_stack_arg_i16
  ; MIPS32: bb.1.entry:
  ; MIPS32:   liveins: $a0, $a1, $a2, $a3
  ; MIPS32:   [[COPY:%[0-9]+]]:_(s32) = COPY $a0
  ; MIPS32:   [[COPY1:%[0-9]+]]:_(s32) = COPY $a1
  ; MIPS32:   [[COPY2:%[0-9]+]]:_(s32) = COPY $a2
  ; MIPS32:   [[COPY3:%[0-9]+]]:_(s32) = COPY $a3
  ; MIPS32:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.0
  ; MIPS32:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p0) :: (load 4 from %fixed-stack.0, align 8)
  ; MIPS32:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[LOAD]](s32)
  ; MIPS32:   ADJCALLSTACKDOWN 24, 0, implicit-def $sp, implicit $sp
  ; MIPS32:   $a0 = COPY [[COPY]](s32)
  ; MIPS32:   $a1 = COPY [[COPY1]](s32)
  ; MIPS32:   $a2 = COPY [[COPY2]](s32)
  ; MIPS32:   $a3 = COPY [[COPY3]](s32)
  ; MIPS32:   [[COPY4:%[0-9]+]]:_(p0) = COPY $sp
  ; MIPS32:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; MIPS32:   [[GEP:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY4]], [[C]](s32)
  ; MIPS32:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[TRUNC]](s16)
  ; MIPS32:   G_STORE [[ANYEXT]](s32), [[GEP]](p0) :: (store 4 into stack + 16, align 8)
  ; MIPS32:   JAL @aext_stack_arg_i16, csr_o32, implicit-def $ra, implicit-def $sp, implicit $a0, implicit $a1, implicit $a2, implicit $a3, implicit-def $v0
  ; MIPS32:   [[COPY5:%[0-9]+]]:_(s32) = COPY $v0
  ; MIPS32:   [[TRUNC1:%[0-9]+]]:_(s16) = G_TRUNC [[COPY5]](s32)
  ; MIPS32:   ADJCALLSTACKUP 24, 0, implicit-def $sp, implicit $sp
  ; MIPS32:   [[ANYEXT1:%[0-9]+]]:_(s32) = G_ANYEXT [[TRUNC1]](s16)
  ; MIPS32:   $v0 = COPY [[ANYEXT1]](s32)
  ; MIPS32:   RetRA implicit $v0
entry:
  %call = call i16 @aext_stack_arg_i16(i32 %x1, i32 %x2, i32 %x3, i32 %x4, i16 %a)
  ret i16 %call
}
