if (!Array.prototype.filter){
	Array.prototype.filter = function(fun){
	    var len = this.length >>> 0;
	    if (typeof fun != "function")
		throw new TypeError();

	    var res = new Array();
	    var thisp = arguments[1];
	    for (var i = 0; i < len; i++){
		if (i in this){
		    var val = this[i]; 
		    if (fun.call(thisp, val, i, this))
			res.push(val);
		}
	    }
	    
	    return res;
	};
    }

if (!Array.prototype.forEach){
    Array.prototype.forEach = function(fun){
	var len = this.length >>> 0;
	if (typeof fun != "function")
	    throw new TypeError();
	
	var thisp = arguments[1];
	for (var i = 0; i < len; i++){
	    if (i in this)
		fun.call(thisp, this[i], i, this);
	}
    };
}

if (!Array.prototype.every){
    Array.prototype.every = function(fun /*, thisp*/){
	var len = this.length >>> 0;
	if (typeof fun != "function")
	    throw new TypeError();

	var thisp = arguments[1];
	for (var i = 0; i < len; i++){
	    if (i in this &&
		!fun.call(thisp, this[i], i, this))
		return false;
	}

	return true;
    };
}


if (!Array.prototype.map){
    Array.prototype.map = function(fun /*, thisp*/){
	var len = this.length >>> 0;
	if (typeof fun != "function")
	    throw new TypeError();

	var res = new Array(len);
	var thisp = arguments[1];
	for (var i = 0; i < len; i++){
	    if (i in this)
		res[i] = fun.call(thisp, this[i], i, this);
	}

	return res;
    };
}

if (!Array.prototype.some){
    Array.prototype.some = function(fun /*, thisp*/){
	var i = 0,
        len = this.length >>> 0;

	if (typeof fun != "function")
	    throw new TypeError();

	var thisp = arguments[1];
	for (; i < len; i++){
	    if (i in this &&
		fun.call(thisp, this[i], i, this))
		return true;
	}

	return false;
    };
}

if (!Array.prototype.reduce){
    Array.prototype.reduce = function(fun /*, initial*/){
	var len = this.length >>> 0;
	if (typeof fun != "function")
	    throw new TypeError();

	// no value to return if no initial value and an empty array
	if (len == 0 && arguments.length == 1)
	    throw new TypeError();

	var i = 0;
	if (arguments.length >= 2){
	    var rv = arguments[1];
	}
	else{
	    do{
		if (i in this){
		    rv = this[i++];
		    break;
		}

		// if array contains no values, no initial value to return
		if (++i >= len)
		    throw new TypeError();
	    }
	    while (true);
	}

	for (; i < len; i++){
	    if (i in this)
		rv = fun.call(null, rv, this[i], i, this);
	}

	return rv;
    };
}

if (!Array.prototype.reduceRight){
    Array.prototype.reduceRight = function(fun /*, initial*/){
	var len = this.length >>> 0;
	if (typeof fun != "function")
	    throw new TypeError();

	// no value to return if no initial value, empty array
	if (len == 0 && arguments.length == 1)
	    throw new TypeError();

	var i = len - 1;
	if (arguments.length >= 2){
	    var rv = arguments[1];
	}
	else{
	    do{
		if (i in this){
		    rv = this[i--];
		    break;
		}

		// if array contains no values, no initial value to return
		if (--i < 0)
		    throw new TypeError();
	    }
	    while (true);
	}

	for (; i >= 0; i--){
	    if (i in this)
		rv = fun.call(null, rv, this[i], i, this);
	}

	return rv;
    };
}


