/*
 * glade-gtk-action-widgets.h
 *
 * Copyright (C) 2011 Juan Pablo Ugarte.
 *
 * Author:
 *   Juan Pablo Ugarte <juanpablougarte@gmail.com>
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef __GLADE_GTK_ACTION_WIDGETS_H__
#define __GLADE_GTK_ACTION_WIDGETS_H__

#include <gladeui/glade.h>

G_BEGIN_DECLS

#define GLADE_TAG_ACTION_WIDGETS "action-widgets"
#define GLADE_TAG_ACTION_WIDGET  "action-widget"
#define GLADE_TAG_RESPONSE       "response"

void glade_gtk_action_widgets_read_child  (GladeWidget *widget,
                                           GladeXmlNode *node,
                                           gchar *action_container);

void glade_gtk_action_widgets_write_child (GladeWidget *widget,
                                           GladeXmlContext *context,
                                           GladeXmlNode *node,
                                           gchar *action_container);
G_END_DECLS

#endif /* __GLADE_GTK_ACTION_WIDGETS_H__ */
