.\" dpkg manual page - dsc(5)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dsc 5 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOM
dsc \- Format du fichier de contrôle dans les paquets source Debian
.
.SH SYNOPSIS
\fInom\-du\-fichier\fP\fB.dsc\fP
.
.SH DESCRIPTION
Chaque paquet Debian possède un fichier de contrôle .dsc qui contient un
certain nombre de champs. Chaque champ commence par une étiquette, telle que
\fBSource\fP ou \fBBinary\fP (la casse n'importe pas), suivie d'un «\ :\ », et du
contenu du champ. Les champs sont séparés seulement par des étiquettes de
champ. En d'autres termes, le contenu d'un champ peut s'étendre sur
plusieurs lignes, mais les outils d'installation joindront en général les
lignes pendant le traitement du contenu du champ (sauf pour les champs à
lignes multiples \fBPackage\-List\fP, \fBFiles\fP, \fBChecksums\-Sha1\fP et
\fBChecksums\-Sha256\fP, voir ci\-dessous).
.PP
Les données de contrôle pourraient être incluses dans une signature OpenPGP
«\ ASCII Armored\ », comme spécifié dans RFC4880.
.
.SH "LES CHAMPS"
.TP 
\fBFormat:\fP \fIversion\-format\fP (requis)
La valeur de ce champ déclare la version du format du paquet source. La
valeur du champ est utilisée par les programmes qui agissent sur un paquet
source pour interpréter la liste des fichiers du paquet source et déterminer
comment le dépaqueter. La syntaxe de la valeur du champ est un numéro de
révision majeure («\ 0\-9\ »), un point («\ .\ »), un numéro de révision mineure,
puis un sous\-type facultatif après une espace («\ \ \ ») qui, lorsqu'il est
présent, est un mot en caractères alphanumériques («\ a\-z0\-9\ »), en
minuscules entre parenthèses («\ ()\ ». Le sous\-type est facultatif dans la
syntaxe, mais peut être obligatoire pour certaines révisions particulières
du format source.

Les formats source actuellement pris en charge par \fBdpkg\fP sont \fB1.0\fP,
\fB2.0\fP, \fB3.0 (native)\fP, \fB3.0 (quilt)\fP, \fB3.0 (git)\fP, \fB3.0 (bzr)\fP et \fB3.0
(custom)\fP. Voir \fBdpkg\-source\fP(1) pour leur description.
.TP 
\fBSource:\fP \fInom\-source\fP (requis)
La valeur de ce champ donne le nom du paquet, et la plupart des outils
d'installation s'en servent pour produire les noms des paquets.
.TP 
\fBBinary:\fP \fIliste\-de\-paquets\-binaires\fP
Ce champ coupé liste des paquets binaires que ce paquet source peut produire
séparés par des virgules.

Ce champ a maintenant été remplacé par le champ \fBPackage\-List\fP qui donne
suffisamment d'informations sur quels paquets binaires sont produits sur
quelle architecture, quel profil de construction et autres restrictions
actives.
.TP 
\fBArchitecture:\fP \fIliste\-architectures\fP (recommandé)
Une liste d'architectures et de jokers d'architecture séparés par des
espaces qui précisent le type de matériel pour lequel ce paquet peut être
compilé. Les noms et les jokers d'architecture courants sont \fBamd64\fP,
\fBarmel\fP, \fBi386\fP, \fBlinux\-any\fP, \fBany\-amd64\fP,\ etc.

Notez que la valeur \fBall\fP est destinée aux paquets indépendants de
l'architecture et \fBany\fP à ceux qui sont dépendants d'une architecture. La
liste peut comprendre (ou consister uniquement de) la valeur spéciale
\fBall\fP. Quand la liste comprend le joker d'architecture \fBany\fP, la seule
autre valeur permise dans la liste est \fBall\fP.

La valeur du champ est en général générée par les champs \fBArchitecture\fP du
fichier \fIdebian/control\fP du paquet source.
.TP 
\fBVersion:\fP \fIchaîne\-de\-la\-version\fP (requis)
C'est classiquement le numéro de version du paquet d'origine dans la forme
choisie par l'auteur du programme. Il peut y avoir aussi un numéro de
révision Debian (pour les paquets non natifs). Le format exact et
l'algorithme de tri sont décrits dans \fBdeb\-version\fP(7).
.TP 
\fBOrigin:\fP\fI nom\fP
Nom de la distribution dont ce paquet provient.
.TP 
\fBMaintainer:\fP \fInom\-complet\-et\-adresse\-électronique\fP (recommandé)
Le format de ce champ sera «\ Jean Dupont <jdupont@foo.com>\ »\ ; et
c'est bien sûr le créateur du paquet, par opposition à l'auteur du programme
mis en paquet.
.TP 
\fBUploaders:\fP \fIliste\-de\-noms\-complets\-et\-adresses\-électroniques\fP
Affiche les noms et les adresses électroniques des co\-responsables du
paquet, au même format que le champ \fBMaintainer\fP. Des co\-responsables
multiples peuvent être séparés par des virgules.
.TP 
\fBDescription\fP \fIdescription\-courte\fP
.TQ
\fB \fP\fIdescription\-longue\fP
Le format de la description du paquet est un résumé bref sur la première
ligne (après le champ \fBDescription\fP). Les lignes suivantes peuvent servir à
une description plus longue et plus détaillée. Chaque ligne de cette
description longue doit être précédée d'une espace\ ; quand c'est une ligne
blanche, elle doit contenir un seul «\ \fB.\fP\ » après cette espace.
.TP 
\fBHomepage:\fP\fI URL\fP
\fIURL\fP de la page d'accueil du projet amont.
.TP 
\fBStandards\-Version:\fP \fIchaîne\-de\-la\-version\fP (recommandé)
Ce champ indique la version la plus récente des normes de la charte de la
distribution auxquelles ce paquet se conforme.
.TP 
\fBVcs\-Browser:\fP\fI URL\fP
Indique l'\fIURL\fP de l'interface web permettant de parcourir le dépôt du
système de gestion de versions.
.TP 
\fBVcs\-Arch:\fP\fI URL\fP
.TQ
\fBVcs\-Bzr:\fP\fI URL\fP
.TQ
\fBVcs\-Cvs:\fP\fI URL\fP
.TQ
\fBVcs\-Darcs:\fP\fI URL\fP
.TQ
\fBVcs\-Git:\fP\fI URL\fP
.TQ
\fBVcs\-Hg:\fP\fI URL\fP
.TQ
\fBVcs\-Mtn:\fP\fI URL\fP
.TQ
\fBVcs\-Svn:\fP\fI URL\fP
Ces champs indiquent l'\fIURL\fP du dépôt du système de gestion de versions
utilisé pour la gestion du paquet. Voir \fBdeb\-src\-control\fP(5) pour plus de
détails.
.TP 
\fBTestsuite:\fP\fI liste\-de\-noms\fP
Ce champ indique que le paquet source contient les suites de tests
spécifiées. La valeur est une liste des suites de tests séparées par des
virgules. Si la valeur \fBautopkgtest\fP est présente, un fichier
\fIdebian/tests/control\fP devrait être présent, et si la fichier est présent
mais pas la valeur, alors \fBdpkg\-source\fP l'ajoutera automatiquement, en
conservant les valeurs précédentes.
.TP 
\fBTestsuite\-Triggers:\fP\fI liste\-de\-paquets\fP
Ce champ indique l'union de toutes les dépendances de test, séparées par des
virgules (champs \fBDepends\fP du fichier \fIdebian/tests/control\fP), toutes
restrictions supprimées, et les dépendances OR mises à plat (c'est\-à\-dire
convertie en relations AND distinctes), sauf pour les binaires générés par
ce paquet source et son équivalent de méta\-dépendance \fB@\fP.

Raison\ : ce champ est nécessaire parce qu'autrement chaque paquet source
devrait être dépaqueté pour pouvoir obtenir les dépendances de test.
.TP 
\fBBuild\-Depends:\fP\fI liste\-de\-paquets\fP
.TQ
\fBBuild\-Depends\-Arch:\fP\fIliste\-de\-paquets\fP
.TQ
\fBBuild\-Depends\-Indep:\fP\fI liste\-de\-paquets\fP
.TQ
\fBBuild\-Conflicts:\fP\fI liste de paquets\fP
.TQ
\fBBuild\-Conflicts\-Arch:\fP\fI liste\-de\-paquets\fP
.TQ
\fBBuild\-Conflicts\-Indep:\fP\fI liste\-de\-paquets\fP
Ces champs indiquent les relations entre le paquet source et les paquets
utilisés pour le construire. Ils sont détaillés dans la page de manuel
\fBdeb\-src\-control\fP(5).
.TP 
\fBPackage\-List:\fP
.TQ
\fIpaquet\fP \fItype\-de\-paquet\fP \fIsection\fP \fIpriorité\fP \fIliste\-clés\-valeurs\fP
Ce champ à lignes multiples contient une liste des paquets binaires générés
par le paquet source.

Le \fIpaquet\fP est le nom du paquet binaire.

Le \fItype\-de\-paquet\fP est le type du paquet binaire, habituellement \fBdeb\fP\ ;
une autre valeur commune est \fBudeb\fP.

La \fIsection\fP et la \fIpriorité\fP correspondent aux champs du même nom du
paquet binaire.

La \fIliste\-clés\-valeurs\fP est une liste de \fIclés\fP\fB=\fP\fIvaleurs\fP séparées par
des valeurs et les clés optionnelles actuellement reconnues sont\ :

.RS
.TP 
\fBarch\fP
Les restrictions d'architecture à partir du champ \fBArchitecture\fP du paquet
binaire avec les espaces converties en «\ ,\ ».
.TP 
\fBprofile\fP
La formule normalisée de restrictions de profil de construction à partir du
champ \fBBuild\-Profile\fP du paquet binaire avec les OR convertis en «\ +\ » et
les «\ AND\ » en «\ ,\ ».
.TP 
\fBessential\fP
Si le paquet binaire est essentiel, cette clé contiendra la valeur du champ
\fBEssential\fP, qui est la valeur \fByes\fP.
.RE
.TP 
\fBFiles:\fP (requis)
.TQ
\fBChecksums\-Sha1:\fP (requis)
.TQ
\fBChecksums\-Sha256:\fP (requis)
.TQ
\fIsomme\-de\-contrôle\fP \fItaille\fP \fInom\-du\-fichier\fP
Ces champs à lignes multiples contiennent une liste de fichiers avec une
somme de contrôle et une taille pour chacun. Ces champs ont la même syntaxe
et diffèrent seulement par l'algorithme de somme de contrôle employé\ : MD5
pour \fBFiles\fP, SHA\-1 pour \fBChecksums\-Sha1\fP et SHA\-256 pour
\fBChecksums\-Sha256\fP.

La première ligne de la valeur du champ (la partie sur la même ligne que le
nom du champ suivi par deux\-points) est toujours vide. Le contenu du champ
est exprimé sous la forme de lignes de continuation, un ligne par
fichier. Chaque ligne consiste en la somme de contrôle, une espace, la
taille du fichier, une espace et le nom du fichier.

Ces champs listent tous les fichiers qui composent le paquet source. La
liste de fichiers de ces champs doit correspondre à celle présente dans les
autres champs relatifs.
.
.\" .SH EXAMPLE
.\" .RS
.\" .nf
.\" .fi
.\" .RE
.
.SH BOGUES
Le champ \fBFormat\fP combine le format pour le fichier \fB.dsc\fP lui\-même et le
format du paquet source extrait.
.SH "VOIR AUSSI"
\fBdeb\-src\-control\fP(5), \fBdeb\-version\fP(7), \fBdpkg\-source\fP(1).
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
