/*-
 *   BSD LICENSE
 *
 *   Copyright(c) 2010-2014 Intel Corporation. All rights reserved.
 *   All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *     * Neither the name of Intel Corporation nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TEST_LPM_ROUTES_H_
#define _TEST_LPM_ROUTES_H_

#include <rte_ip.h>

struct route_rule {
	uint32_t ip;
	uint8_t depth;
};

/*
 * Source = http://psp1.iit.cnr.it/~mcsoft/ast/ast.html
 * Note that there are duplicates
 */

static const struct route_rule large_route_table[] =
{
	{100728832U, 16},
	{100794368U, 22},
	{100859904U, 18},
	{100925440U, 16},
	{100990976U, 19},
	{101187584U, 20},
	{101253120U, 20},
	{101318656U, 15},
	{101580800U, 15},
	{109379584U, 21},
	{110559232U, 16},
	{110624768U, 16},
	{160268288U, 24},
	{163082240U, 20},
	{163221504U, 20},
	{201326592U, 8},
	{201338880U, 20},
	{201391104U, 23},
	{201413376U, 24},
	{201454848U, 24},
	{201455616U, 24},
	{201459200U, 24},
	{201459456U, 24},
	{201468160U, 24},
	{201480192U, 22},
	{201481728U, 23},
	{201482496U, 24},
	{201483008U, 24},
	{201485568U, 24},
	{201485824U, 24},
	{201494016U, 24},
	{201500928U, 24},
	{201512960U, 23},
	{201513984U, 22},
	{201520640U, 24},
	{201528576U, 24},
	{201531648U, 24},
	{201538304U, 24},
	{201539328U, 24},
	{201539840U, 24},
	{201543680U, 22},
	{201553664U, 24},
	{201578752U, 24},
	{201590016U, 24},
	{201617920U, 24},
	{201619200U, 24},
	{201620992U, 23},
	{201638912U, 22},
	{201647104U, 24},
	{201664256U, 24},
	{201666560U, 21},
	{201689088U, 24},
	{201696256U, 24},
	{201696512U, 24},
	{201750784U, 24},
	{201751552U, 24},
	{201751808U, 24},
	{201773056U, 20},
	{201777920U, 24},
	{201786624U, 24},
	{201819392U, 24},
	{201853184U, 24},
	{201853952U, 24},
	{201854208U, 24},
	{201897984U, 24},
	{201899008U, 24},
	{201899264U, 24},
	{201977344U, 24},
	{201982208U, 24},
	{202020352U, 24},
	{202020864U, 21},
	{202026752U, 24},
	{202030592U, 24},
	{202031104U, 23},
	{202032128U, 22},
	{202037504U, 24},
	{202080768U, 24},
	{202081024U, 24},
	{202081792U, 23},
	{202082816U, 24},
	{202088960U, 24},
	{202197504U, 24},
	{202208256U, 22},
	{202235904U, 19},
	{202235904U, 21},
	{202238976U, 22},
	{202240000U, 22},
	{202241024U, 23},
	{202241536U, 23},
	{202242048U, 22},
	{202248704U, 23},
	{202249216U, 22},
	{202250240U, 21},
	{202253056U, 24},
	{202294272U, 24},
	{202294528U, 24},
	{202294784U, 24},
	{202295040U, 24},
	{202298880U, 24},
	{202299136U, 24},
	{202303488U, 23},
	{202304768U, 24},
	{202305024U, 23},
	{202321408U, 23},
	{202385408U, 23},
	{202394624U, 23},
	{202405888U, 23},
	{202418176U, 24},
	{202437632U, 22},
	{202445824U, 24},
	{202484992U, 24},
	{202515456U, 22},
	{202515456U, 24},
	{202529280U, 23},
	{202530816U, 22},
	{202534400U, 23},
	{202536960U, 24},
	{202545920U, 24},
	{202549760U, 23},
	{202551552U, 24},
	{202561536U, 24},
	{202561792U, 24},
	{202567680U, 22},
	{202568704U, 22},
	{202606592U, 23},
	{202607104U, 24},
	{202625024U, 24},
	{202625792U, 24},
	{202641408U, 21},
	{202651392U, 24},
	{202660864U, 24},
	{202687488U, 22},
	{202688512U, 22},
	{202693120U, 24},
	{202695936U, 24},
	{202706432U, 23},
	{202715392U, 24},
	{202715648U, 23},
	{202724352U, 24},
	{202724608U, 24},
	{202754560U, 23},
	{202756096U, 23},
	{202756608U, 23},
	{202757120U, 23},
	{202840576U, 23},
	{202850816U, 23},
	{202851840U, 23},
	{202852352U, 23},
	{202853888U, 24},
	{202857472U, 24},
	{202860544U, 22},
	{202861568U, 23},
	{202868736U, 22},
	{202882304U, 24},
	{202883584U, 24},
	{202928128U, 22},
	{202942464U, 24},
	{202945536U, 23},
	{202963456U, 23},
	{202963968U, 22},
	{202977536U, 24},
	{202990080U, 24},
	{202991872U, 24},
	{202999808U, 21},
	{203015168U, 22},
	{203016192U, 21},
	{203019264U, 23},
	{203024384U, 21},
	{203026688U, 24},
	{203032320U, 24},
	{203036928U, 24},
	{203052032U, 24},
	{203063296U, 22},
	{203065344U, 22},
	{203088384U, 23},
	{203105792U, 24},
	{203106304U, 24},
	{203106560U, 24},
	{203106816U, 24},
	{203107072U, 24},
	{203112960U, 24},
	{203118592U, 24},
	{203118848U, 24},
	{203119104U, 24},
	{203119360U, 24},
	{203122688U, 23},
	{203134208U, 24},
	{203198976U, 23},
	{203199488U, 24},
	{203234304U, 23},
	{203252736U, 24},
	{203252992U, 24},
	{203253248U, 24},
	{203254272U, 24},
	{203275776U, 24},
	{203276800U, 24},
	{203292672U, 23},
	{203292928U, 24},
	{203306240U, 24},
	{203319552U, 24},
	{203332864U, 24},
	{203333376U, 24},
	{203343360U, 23},
	{203345152U, 24},
	{203345920U, 21},
	{203350016U, 22},
	{203351040U, 22},
	{203363584U, 24},
	{203364352U, 24},
	{203364608U, 24},
	{203390208U, 24},
	{203390464U, 24},
	{203394816U, 24},
	{203409920U, 24},
	{203438592U, 23},
	{203442176U, 23},
	{203446784U, 24},
	{203447040U, 24},
	{203450368U, 22},
	{203452416U, 22},
	{203453952U, 23},
	{203482880U, 24},
	{203485440U, 24},
	{203501056U, 24},
	{203503616U, 22},
	{203518464U, 24},
	{203538944U, 24},
	{203539200U, 24},
	{203555328U, 24},
	{203556864U, 21},
	{203559680U, 24},
	{203574016U, 24},
	{203580416U, 24},
	{203580672U, 24},
	{203594240U, 24},
	{203595520U, 24},
	{203614464U, 24},
	{203622400U, 22},
	{203629824U, 24},
	{203636992U, 24},
	{203644928U, 24},
	{203649536U, 24},
	{203657472U, 24},
	{203661056U, 24},
	{203700224U, 22},
	{203715584U, 24},
	{203716096U, 24},
	{203718912U, 24},
	{203719936U, 24},
	{203726848U, 22},
	{203737856U, 24},
	{203758592U, 22},
	{203767040U, 24},
	{203771904U, 24},
	{203779072U, 22},
	{203780352U, 24},
	{203809792U, 22},
	{203829248U, 22},
	{203833344U, 22},
	{203845632U, 24},
	{203871232U, 24},
	{203879680U, 24},
	{203879936U, 24},
	{203880192U, 24},
	{203899136U, 24},
	{203909632U, 24},
	{203977216U, 24},
	{203977728U, 24},
	{203979008U, 24},
	{203992576U, 24},
	{203993856U, 24},
	{204026112U, 24},
	{204026368U, 24},
	{204026624U, 24},
	{204030464U, 23},
	{204044800U, 24},
	{204055040U, 23},
	{204055040U, 24},
	{204055296U, 24},
	{204061696U, 24},
	{204062976U, 24},
	{204063232U, 23},
	{204063232U, 24},
	{204063488U, 24},
	{204091904U, 24},
	{204092160U, 24},
	{204092416U, 24},
	{204112384U, 24},
	{204112640U, 24},
	{204115968U, 22},
	{204118016U, 24},
	{204140544U, 23},
	{204149760U, 23},
	{204177408U, 20},
	{204177408U, 24},
	{204177920U, 24},
	{204181504U, 20},
	{204182016U, 24},
	{204276224U, 23},
	{204276224U, 24},
	{204276736U, 24},
	{204276992U, 24},
	{204299264U, 23},
	{204302080U, 24},
	{204303360U, 24},
	{204310016U, 24},
	{204378112U, 21},
	{204384256U, 21},
	{204455936U, 21},
	{204462336U, 24},
	{205553664U, 19},
	{205561856U, 20},
	{205717760U, 24},
	{207628288U, 22},
	{207659008U, 21},
	{208151552U, 24},
	{208163328U, 23},
	{208166912U, 24},
	{208226048U, 24},
	{208255232U, 24},
	{208277504U, 24},
	{208297984U, 24},
	{208298240U, 24},
	{208344064U, 22},
	{208349184U, 22},
	{208350208U, 22},
	{208359936U, 24},
	{208372224U, 24},
	{208374784U, 22},
	{208385024U, 22},
	{208398336U, 24},
	{208465152U, 24},
	{208497920U, 24},
	{208537088U, 23},
	{208600320U, 24},
	{208634880U, 23},
	{209776640U, 20},
	{209780736U, 18},
	{209797120U, 18},
	{209829888U, 18},
	{210800640U, 24},
	{210801664U, 22},
	{210845952U, 24},
	{210971648U, 24},
	{210973696U, 24},
	{210973952U, 24},
	{210974208U, 24},
	{210974464U, 24},
	{211078144U, 23},
	{211092480U, 23},
	{211238912U, 21},
	{211247104U, 24},
	{211330048U, 23},
	{211353600U, 21},
	{211355648U, 23},
	{229967872U, 21},
	{229970944U, 24},
	{229974016U, 24},
	{229975040U, 24},
	{229976064U, 24},
	{229982208U, 23},
	{229982720U, 24},
	{229983232U, 24},
	{229985280U, 23},
	{229985792U, 24},
	{229986304U, 24},
	{229991424U, 24},
	{229993472U, 24},
	{251658240U, 8},
	{265519104U, 20},
	{266076160U, 16},
	{266338304U, 16},
	{266600448U, 16},
	{268173312U, 18},
	{268189696U, 20},
	{268234752U, 20},
	{268435456U, 8},
	{285212672U, 8},
	{291962880U, 16},
	{292028416U, 16},
	{293470208U, 15},
	{404226048U, 19},
	{404234240U, 19},
	{404242432U, 19},
	{404250624U, 19},
	{404258816U, 18},
	{404275200U, 20},
	{404279296U, 20},
	{404283392U, 19},
	{404291584U, 19},
	{404299776U, 19},
	{404307968U, 19},
	{404316160U, 19},
	{404324352U, 19},
	{404332544U, 19},
	{404340736U, 19},
	{404348928U, 19},
	{404357120U, 18},
	{404373504U, 19},
	{404381696U, 19},
	{404389888U, 19},
	{404398080U, 19},
	{404406272U, 19},
	{404414464U, 19},
	{404422656U, 18},
	{404439040U, 18},
	{404455424U, 19},
	{404463616U, 19},
	{404471808U, 19},
	{404480000U, 20},
	{404484096U, 20},
	{404488192U, 18},
	{404504576U, 19},
	{404512768U, 19},
	{404520960U, 19},
	{404529152U, 19},
	{404537344U, 19},
	{404545536U, 19},
	{404553728U, 19},
	{404561920U, 19},
	{404570112U, 19},
	{404578304U, 19},
	{404586496U, 19},
	{404594688U, 20},
	{404598784U, 20},
	{404619264U, 18},
	{404635648U, 19},
	{404643840U, 19},
	{404652032U, 19},
	{404660224U, 19},
	{404668416U, 19},
	{404676608U, 19},
	{404684800U, 19},
	{404692992U, 19},
	{404701184U, 19},
	{404709376U, 19},
	{404717568U, 19},
	{404725760U, 19},
	{404733952U, 19},
	{404742144U, 19},
	{405340160U, 18},
	{405356544U, 19},
	{408420352U, 18},
	{408436736U, 19},
	{408444928U, 19},
	{408453120U, 19},
	{408461312U, 19},
	{408469504U, 19},
	{408477696U, 20},
	{408481792U, 20},
	{408616960U, 16},
	{408616960U, 18},
	{408633344U, 19},
	{408641536U, 19},
	{408649728U, 17},
	{408682496U, 19},
	{408690688U, 19},
	{408698880U, 19},
	{408707072U, 19},
	{408715264U, 20},
	{408723456U, 19},
	{408731648U, 19},
	{408739840U, 19},
	{408748032U, 19},
	{408756224U, 19},
	{408764416U, 19},
	{408772608U, 19},
	{408780800U, 19},
	{408788992U, 19},
	{408797184U, 19},
	{408805376U, 19},
	{408813568U, 19},
	{408821760U, 19},
	{408829952U, 19},
	{408838144U, 19},
	{408846336U, 19},
	{408854528U, 19},
	{408862720U, 19},
	{408870912U, 19},
	{408879104U, 19},
	{408887296U, 19},
	{408895488U, 19},
	{408903680U, 19},
	{408911872U, 19},
	{408920064U, 19},
	{408928256U, 19},
	{408936448U, 19},
	{409468928U, 18},
	{409479168U, 21},
	{409481216U, 21},
	{409483264U, 21},
	{409485312U, 19},
	{409485312U, 22},
	{409487360U, 21},
	{409492480U, 22},
	{410255360U, 17},
	{410255360U, 23},
	{410255872U, 24},
	{410256128U, 24},
	{410256384U, 24},
	{410256640U, 24},
	{410258432U, 23},
	{410258944U, 24},
	{410259200U, 24},
	{410259456U, 23},
	{410260992U, 23},
	{410262016U, 23},
	{410262528U, 22},
	{410263552U, 21},
	{410264576U, 24},
	{410264832U, 24},
	{410265088U, 24},
	{410267648U, 21},
	{410273792U, 23},
	{410275840U, 22},
	{410276864U, 22},
	{410277888U, 22},
	{410278912U, 22},
	{410279936U, 22},
	{410280960U, 23},
	{410281472U, 23},
	{410281984U, 23},
	{410282496U, 24},
	{410283008U, 23},
	{410284032U, 23},
	{410284544U, 23},
	{410285056U, 22},
	{410285056U, 23},
	{410286080U, 22},
	{410287104U, 23},
	{410287616U, 23},
	{410517504U, 19},
	{410525696U, 19},
	{410533888U, 19},
	{411041792U, 16},
	{411107328U, 17},
	{411140096U, 18},
	{411156480U, 19},
	{411172864U, 18},
	{411189248U, 19},
	{411197440U, 19},
	{411205632U, 20},
	{411209728U, 20},
	{411213824U, 19},
	{411222016U, 19},
	{411230208U, 19},
	{411238400U, 18},
	{411254784U, 18},
	{411287552U, 18},
	{411566080U, 19},
	{411631616U, 19},
	{411828224U, 19},
	{411969536U, 22},
	{411970560U, 22},
	{412000256U, 19},
	{412004864U, 24},
	{412008448U, 18},
	{412011776U, 24},
	{412286976U, 16},
	{412352512U, 18},
	{412368896U, 19},
	{412549120U, 19},
	{412557312U, 19},
	{412557312U, 20},
	{412559360U, 22},
	{412560384U, 23},
	{412560896U, 23},
	{412561408U, 20},
	{412561408U, 24},
	{412561664U, 24},
	{412561920U, 23},
	{412562432U, 22},
	{412564480U, 23},
	{412564992U, 24},
	{412565248U, 24},
	{412811264U, 19},
	{413011968U, 20},
	{413032448U, 19},
	{413040640U, 20},
	{413073408U, 20},
	{413081600U, 20},
	{413085696U, 20},
	{413097984U, 20},
	{413106176U, 20},
	{413118464U, 20},
	{413122560U, 20},
	{413126656U, 20},
	{413138944U, 19},
	{413147136U, 20},
	{413151232U, 20},
	{413155328U, 18},
	{413171712U, 19},
	{413179904U, 19},
	{413188096U, 19},
	{413196288U, 19},
	{413204480U, 18},
	{413220864U, 19},
	{413229056U, 19},
	{413237248U, 19},
	{413245440U, 19},
	{413253632U, 19},
	{413261824U, 19},
	{413270016U, 18},
	{413286400U, 19},
	{413294592U, 19},
	{413302784U, 19},
	{413310976U, 19},
	{413319168U, 19},
	{413327360U, 19},
	{413335552U, 19},
	{413343744U, 20},
	{413347840U, 20},
	{413351936U, 19},
	{413360128U, 19},
	{413368320U, 20},
	{413372416U, 20},
	{413376512U, 19},
	{413384704U, 19},
	{413392896U, 20},
	{413401088U, 19},
	{413409280U, 19},
	{413417472U, 19},
	{413425664U, 19},
	{413433856U, 19},
	{413442048U, 20},
	{413446144U, 20},
	{413450240U, 19},
	{413458432U, 19},
	{413466624U, 19},
	{413474816U, 19},
	{413483008U, 20},
	{413487104U, 20},
	{413491200U, 20},
	{413495296U, 20},
	{413499392U, 18},
	{413515776U, 19},
	{413523968U, 19},
	{413532160U, 18},
	{413548544U, 18},
	{413564928U, 19},
	{413573120U, 19},
	{413581312U, 19},
	{413589504U, 20},
	{413593600U, 20},
	{413597696U, 18},
	{413614080U, 19},
	{413622272U, 19},
	{413630464U, 19},
	{413646848U, 19},
	{413655040U, 19},
	{413663232U, 18},
	{413679616U, 19},
	{413687808U, 19},
	{413696000U, 19},
	{413704192U, 19},
	{413712384U, 19},
	{413720576U, 19},
	{413728768U, 19},
	{413736960U, 19},
	{413745152U, 19},
	{413753344U, 19},
	{413761536U, 19},
	{413769728U, 20},
	{413773824U, 20},
	{413777920U, 20},
	{413782016U, 20},
	{413786112U, 20},
	{413790208U, 20},
	{413794304U, 19},
	{413802496U, 19},
	{413810688U, 19},
	{413814784U, 20},
	{413818880U, 19},
	{416153600U, 20},
	{416612352U, 20},
	{416616448U, 20},
	{416616448U, 22},
	{416619520U, 22},
	{416620544U, 19},
	{416832768U, 24},
	{416856064U, 24},
	{416856832U, 24},
	{416873472U, 24},
	{416873728U, 24},
	{416873984U, 24},
	{416874240U, 24},
	{416940032U, 16},
	{417007616U, 21},
	{417009664U, 21},
	{417042432U, 20},
	{417185792U, 19},
	{417189888U, 20},
	{417202176U, 18},
	{417218560U, 20},
	{417222656U, 20},
	{417226752U, 20},
	{417230848U, 20},
	{417234944U, 19},
	{417243136U, 20},
	{417267712U, 19},
	{417275904U, 19},
	{417284096U, 20},
	{417529856U, 19},
	{417660928U, 17},
	{417857536U, 18},
	{417873920U, 19},
	{417882112U, 19},
	{417890304U, 18},
	{417988608U, 19},
	{417996800U, 19},
	{418004992U, 19},
	{418013184U, 19},
	{418021376U, 19},
	{418029568U, 19},
	{418037760U, 19},
	{418045952U, 19},
	{418119680U, 19},
	{418384896U, 24},
	{418406656U, 24},
	{418407424U, 24},
	{418412288U, 24},
	{418413056U, 24},
	{418418688U, 24},
	{418418944U, 24},
	{418419200U, 24},
	{418419456U, 24},
	{418419712U, 24},
	{418419968U, 24},
	{418429440U, 24},
	{418434816U, 24},
	{418436352U, 24},
	{418443776U, 24},
	{418444032U, 24},
	{418444288U, 24},
	{418446336U, 24},
	{418465536U, 24},
	{418469888U, 24},
	{418474240U, 24},
	{418486784U, 24},
	{418490112U, 24},
	{418492928U, 24},
	{418676736U, 22},
	{418677760U, 22},
	{418678784U, 21},
	{418775040U, 17},
	{418777344U, 24},
	{418777600U, 23},
	{418778112U, 22},
	{418779136U, 23},
	{418784768U, 24},
	{418790400U, 24},
	{418796544U, 22},
	{418806272U, 24},
	{418807808U, 18},
	{418820096U, 21},
	{418820096U, 22},
	{418821120U, 22},
	{418840576U, 19},
	{418844672U, 21},
	{418846720U, 21},
	{418848768U, 20},
	{418852864U, 21},
	{418856960U, 20},
	{418861056U, 20},
	{418869248U, 20},
	{418873344U, 20},
	{536870912U, 8},
	{543031296U, 16},
	{543162368U, 13},
	{543184384U, 24},
	{543190784U, 24},
	{543254528U, 24},
	{543256064U, 24},
	{543262464U, 24},
	{543266816U, 24},
	{543268608U, 24},
	{543270656U, 24},
	{543270912U, 23},
	{543271424U, 24},
	{543285504U, 24},
	{543289344U, 23},
	{543289856U, 24},
	{543292416U, 22},
	{543686656U, 15},
	{543891200U, 24},
	{551849984U, 20},
	{551854080U, 20},
	{587202560U, 8},
	{589520896U, 20},
	{589533184U, 20},
	{589541376U, 20},
	{650373632U, 24},
	{671113216U, 22},
	{738492672U, 24},
	{749076480U, 16},
	{754974720U, 8},
	{791543808U, 15},
	{791556096U, 20},
	{791584768U, 19},
	{791592960U, 20},
	{791597056U, 20},
	{791603712U, 23},
	{791666688U, 21},
	{791670784U, 21},
	{798556160U, 18},
	{798572544U, 18},
	{905183232U, 19},
	{939540480U, 19},
	{939556864U, 18},
	{939556864U, 19},
	{939565056U, 19},
	{1023737856U, 17},
	{1023737856U, 22},
	{1023738880U, 22},
	{1023739904U, 22},
	{1023741952U, 22},
	{1023744000U, 22},
	{1023745024U, 22},
	{1023746048U, 22},
	{1023747072U, 22},
	{1023753216U, 22},
	{1023754240U, 22},
	{1023755264U, 22},
	{1023756288U, 22},
	{1023757312U, 22},
	{1023758336U, 22},
	{1023759360U, 22},
	{1023760384U, 22},
	{1023761408U, 22},
	{1023764480U, 22},
	{1023765504U, 22},
	{1023803392U, 17},
	{1023836160U, 18},
	{1023934464U, 19},
	{1023942144U, 24},
	{1023959040U, 19},
	{1023991808U, 19},
	{1023996416U, 24},
	{1023996672U, 24},
	{1023996928U, 24},
	{1023997184U, 24},
	{1023997440U, 24},
	{1023997696U, 24},
	{1023997952U, 24},
	{1023998208U, 24},
	{1023998464U, 24},
	{1023998720U, 24},
	{1024000000U, 17},
	{1024028672U, 24},
	{1024032256U, 24},
	{1024131072U, 19},
	{1024134144U, 22},
	{1024137216U, 21},
	{1024196608U, 16},
	{1024196608U, 17},
	{1024196608U, 18},
	{1024225280U, 21},
	{1024227328U, 21},
	{1024229376U, 18},
	{1024258048U, 21},
	{1024260096U, 21},
	{1024720896U, 16},
	{1024983040U, 16},
	{1025048576U, 19},
	{1025507328U, 13},
	{1026031616U, 14},
	{1027137536U, 19},
	{1027178496U, 20},
	{1027276800U, 19},
	{1027866624U, 16},
	{1027997696U, 17},
	{1028128768U, 13},
	{1028653056U, 15},
	{1030750208U, 16},
	{1030815744U, 16},
	{1030881280U, 18},
	{1030897664U, 20},
	{1030901760U, 20},
	{1030905856U, 20},
	{1030909952U, 20},
	{1030914048U, 19},
	{1030922240U, 20},
	{1030926336U, 20},
	{1030930432U, 19},
	{1030938624U, 20},
	{1030942720U, 20},
	{1030979584U, 18},
	{1030979584U, 19},
	{1030987776U, 19},
	{1031000064U, 20},
	{1031008256U, 20},
	{1031077888U, 17},
	{1031110656U, 17},
	{1031143424U, 16},
	{1031208960U, 16},
	{1031274496U, 17},
	{1031307264U, 20},
	{1031311360U, 20},
	{1031312384U, 22},
	{1031315456U, 19},
	{1031323648U, 20},
	{1031331840U, 19},
	{1031340032U, 17},
	{1031397376U, 20},
	{1031409664U, 20},
	{1031417856U, 20},
	{1031430144U, 20},
	{1031438336U, 18},
	{1031458816U, 20},
	{1031467008U, 20},
	{1031536640U, 16},
	{1031618560U, 18},
	{1031618560U, 19},
	{1031626752U, 19},
	{1031639040U, 20},
	{1031643136U, 20},
	{1031651328U, 18},
	{1031667712U, 15},
	{1031798784U, 15},
	{1031798784U, 17},
	{1031823360U, 19},
	{1031831552U, 17},
	{1031864320U, 16},
	{1031929856U, 17},
	{1031962624U, 17},
	{1031995392U, 17},
	{1032028160U, 17},
	{1032060928U, 17},
	{1032093696U, 17},
	{1032126464U, 17},
	{1032159232U, 18},
	{1032175616U, 19},
	{1032183808U, 19},
	{1032192000U, 18},
	{1032208384U, 18},
	{1032224768U, 18},
	{1032241152U, 18},
	{1032257536U, 17},
	{1032290304U, 19},
	{1032298496U, 21},
	{1032300544U, 23},
	{1032323072U, 18},
	{1032339456U, 18},
	{1032355840U, 18},
	{1032372224U, 18},
	{1032388608U, 17},
	{1032421376U, 17},
	{1032454144U, 18},
	{1032470528U, 18},
	{1032486912U, 18},
	{1032503296U, 19},
	{1032519680U, 17},
	{1032552448U, 17},
	{1032552448U, 18},
	{1032568832U, 18},
	{1032585216U, 14},
	{1032847360U, 15},
	{1032978432U, 16},
	{1033043968U, 16},
	{1033109504U, 16},
	{1033175040U, 16},
	{1033240576U, 17},
	{1033273344U, 17},
	{1033306112U, 16},
	{1033371648U, 16},
	{1033437184U, 16},
	{1033502720U, 16},
	{1033568256U, 16},
	{1033633792U, 16},
	{1033699328U, 16},
	{1033764864U, 17},
	{1033797632U, 17},
	{1033830400U, 18},
	{1033846784U, 18},
	{1033863168U, 18},
	{1033879552U, 18},
	{1035010048U, 16},
	{1035272192U, 16},
	{1035534336U, 16},
	{1035862016U, 16},
	{1036537856U, 20},
	{1036541952U, 20},
	{1036546048U, 20},
	{1036550144U, 17},
	{1036648448U, 17},
	{1036681216U, 18},
	{1036713984U, 17},
	{1036750848U, 20},
	{1036754944U, 20},
	{1036759040U, 20},
	{1036763136U, 19},
	{1036771328U, 19},
	{1036779520U, 17},
	{1036812288U, 17},
	{1036845056U, 20},
	{1036865536U, 20},
	{1036869632U, 20},
	{1036873728U, 20},
	{1036877824U, 18},
	{1036877824U, 19},
	{1036886016U, 19},
	{1036894208U, 18},
	{1036914688U, 20},
	{1036926976U, 21},
	{1036959744U, 20},
	{1036976128U, 16},
	{1037041664U, 16},
	{1037238272U, 18},
	{1037565952U, 16},
	{1037631488U, 16},
	{1037697024U, 16},
	{1037762560U, 16},
	{1037828096U, 14},
	{1038090240U, 14},
	{1039663104U, 16},
	{1039663104U, 17},
	{1039695872U, 17},
	{1039904768U, 20},
	{1040252928U, 16},
	{1040318464U, 16},
	{1040384000U, 19},
	{1040384000U, 24},
	{1040387328U, 24},
	{1040391936U, 24},
	{1040465920U, 19},
	{1040515072U, 17},
	{1040580608U, 16},
	{1040646144U, 16},
	{1040711680U, 19},
	{1040714240U, 23},
	{1040714240U, 24},
	{1040714496U, 24},
	{1040973824U, 19},
	{1041088512U, 19},
	{1041104896U, 15},
	{1041235968U, 19},
	{1042087936U, 17},
	{1042808832U, 19},
	{1042841600U, 17},
	{1042939904U, 16},
	{1043349504U, 19},
	{1043988480U, 15},
	{1044660224U, 19},
	{1045037056U, 21},
	{1045040128U, 22},
	{1045041152U, 20},
	{1045045248U, 19},
	{1045053440U, 18},
	{1045069824U, 18},
	{1045086208U, 19},
	{1045098496U, 20},
	{1045233664U, 19},
	{1045446656U, 20},
	{1045450752U, 20},
	{1046740992U, 18},
	{1046872064U, 17},
	{1046937600U, 16},
	{1047003136U, 16},
	{1047052288U, 19},
	{1047281664U, 19},
	{1047314432U, 19},
	{1047527424U, 19},
	{1047592960U, 19},
	{1047822336U, 19},
	{1048625152U, 20},
	{1048629248U, 20},
	{1048674304U, 19},
	{1048772608U, 16},
	{1048969216U, 16},
	{1050091520U, 19},
	{1050099712U, 18},
	{1050116096U, 18},
	{1050181632U, 19},
	{1051066368U, 16},
	{1051230208U, 19},
	{1051246592U, 20},
	{1051250688U, 20},
	{1051295744U, 19},
	{1051328512U, 15},
	{1051459584U, 16},
	{1051459584U, 21},
	{1051460608U, 22},
	{1051983872U, 16},
	{1052363776U, 24},
	{1052386048U, 24},
	{1052437504U, 24},
	{1052641280U, 24},
	{1053294592U, 16},
	{1054098432U, 22},
	{1054113792U, 19},
	{1055227904U, 20},
	{1055228416U, 24},
	{1055228928U, 24},
	{1055391744U, 16},
	{1055396864U, 24},
	{1055397120U, 24},
	{1055397376U, 24},
	{1055403520U, 24},
	{1055410176U, 24},
	{1055457280U, 19},
	{1055784960U, 16},
	{1056571392U, 16},
	{1056702464U, 14},
	{1056702464U, 16},
	{1056702464U, 17},
	{1056735232U, 17},
	{1056768000U, 16},
	{1056768000U, 17},
	{1056800768U, 17},
	{1056833536U, 16},
	{1056833536U, 17},
	{1056866304U, 17},
	{1056899072U, 17},
	{1056931840U, 17},
	{1061174016U, 24},
	{1061186048U, 23},
	{1061192192U, 23},
	{1061196800U, 22},
	{1061205248U, 24},
	{1061209344U, 24},
	{1061209600U, 23},
	{1061217280U, 23},
	{1061222144U, 24},
	{1061222400U, 22},
	{1061223936U, 23},
	{1061245952U, 23},
	{1061256960U, 24},
	{1061281024U, 24},
	{1061284608U, 24},
	{1061284864U, 22},
	{1061318656U, 24},
	{1061318912U, 24},
	{1061333504U, 23},
	{1061351424U, 24},
	{1061374208U, 24},
	{1061385216U, 23},
	{1061403648U, 24},
	{1061405696U, 24},
	{1061408000U, 24},
	{1061412864U, 24},
	{1061413120U, 24},
	{1061413376U, 24},
	{1061413632U, 24},
	{1061413888U, 24},
	{1061414144U, 24},
	{1061414400U, 24},
	{1061414656U, 24},
	{1061449728U, 24},
	{1061476864U, 23},
	{1061511680U, 23},
	{1061515776U, 23},
	{1061524992U, 24},
	{1061525760U, 24},
	{1061550080U, 21},
	{1061594112U, 23},
	{1061618432U, 24},
	{1061660160U, 23},
	{1061663744U, 24},
	{1061664000U, 24},
	{1061690368U, 24},
	{1061698816U, 24},
	{1061731840U, 24},
	{1061738496U, 24},
	{1061749760U, 22},
	{1061751296U, 24},
	{1061751552U, 24},
	{1061751808U, 24},
	{1061763584U, 24},
	{1061766656U, 24},
	{1061777152U, 24},
	{1061780224U, 24},
	{1061782016U, 23},
	{1061783552U, 22},
	{1061795328U, 24},
	{1061799680U, 24},
	{1061800960U, 24},
	{1061806080U, 22},
	{1061806336U, 24},
	{1061806848U, 24},
	{1061809664U, 24},
	{1061822464U, 23},
	{1061837056U, 24},
	{1061855232U, 24},
	{1061856000U, 24},
	{1061872128U, 24},
	{1061896192U, 24},
	{1061897216U, 23},
	{1061903104U, 24},
	{1061927424U, 24},
	{1061929472U, 24},
	{1061947648U, 24},
	{1061962240U, 23},
	{1061970432U, 24},
	{1061980416U, 24},
	{1062007552U, 24},
	{1062007808U, 24},
	{1062008064U, 24},
	{1062033920U, 24},
	{1062039040U, 24},
	{1062046208U, 24},
	{1062079488U, 22},
	{1062111488U, 24},
	{1062149376U, 24},
	{1062156288U, 21},
	{1062162432U, 24},
	{1062162688U, 24},
	{1062168576U, 24},
	{1062168832U, 24},
	{1062210816U, 24},
	{1062219008U, 24},
	{1062330368U, 24},
	{1062331136U, 24},
	{1062331392U, 24},
	{1062332160U, 24},
	{1062332928U, 24},
	{1062333440U, 24},
	{1062333952U, 24},
	{1062334208U, 24},
	{1062345216U, 24},
	{1062359040U, 24},
	{1062400256U, 24},
	{1062437632U, 24},
	{1062439936U, 22},
	{1062457344U, 20},
	{1062466560U, 22},
	{1062473472U, 24},
	{1062485504U, 24},
	{1062485760U, 24},
	{1062488064U, 22},
	{1062498816U, 24},
	{1062500864U, 24},
	{1062505472U, 22},
	{1062528768U, 24},
	{1062561536U, 24},
	{1062565888U, 21},
	{1062589440U, 24},
	{1062589696U, 24},
	{1062632960U, 24},
	{1062668288U, 21},
	{1062709760U, 23},
	{1062754304U, 23},
	{1062775808U, 24},
	{1062833408U, 24},
	{1062840064U, 24},
	{1062855168U, 23},
	{1062868992U, 23},
	{1062882560U, 24},
	{1062883072U, 24},
	{1062889472U, 21},
	{1062891520U, 20},
	{1062935552U, 24},
	{1062956544U, 23},
	{1062958336U, 24},
	{1062965504U, 24},
	{1062968576U, 24},
	{1062972416U, 23},
	{1062972416U, 24},
	{1062973440U, 24},
	{1063014400U, 21},
	{1063016448U, 22},
	{1063037952U, 24},
	{1063043584U, 24},
	{1063098368U, 24},
	{1063100416U, 24},
	{1063100672U, 24},
	{1063102208U, 24},
	{1063109632U, 24},
	{1063109888U, 24},
	{1063111424U, 24},
	{1063147264U, 24},
	{1063148544U, 23},
	{1063149056U, 23},
	{1063212544U, 24},
	{1063223808U, 23},
	{1063225344U, 21},
	{1063239936U, 24},
	{1063245824U, 24},
	{1063255552U, 23},
	{1063271424U, 24},
	{1063271680U, 24},
	{1063271936U, 24},
	{1063272192U, 24},
	{1063358464U, 24},
	{1063358720U, 24},
	{1063366912U, 24},
	{1063367680U, 22},
	{1063380224U, 24},
	{1063402496U, 24},
	{1063414016U, 24},
	{1063414528U, 24},
	{1063419136U, 24},
	{1063419648U, 24},
	{1063432192U, 24},
	{1063435264U, 22},
	{1063438080U, 24},
	{1063454976U, 24},
	{1063461888U, 24},
	{1063463168U, 24},
	{1063472128U, 24},
	{1063483392U, 22},
	{1063485440U, 21},
	{1063492096U, 23},
	{1063522560U, 24},
	{1063545856U, 24},
	{1063567360U, 21},
	{1063569408U, 22},
	{1063570432U, 22},
	{1063571456U, 24},
	{1063571712U, 24},
	{1063571968U, 24},
	{1063572480U, 22},
	{1063572992U, 24},
	{1063573248U, 24},
	{1063574528U, 22},
	{1063588608U, 24},
	{1063607296U, 23},
	{1063622144U, 23},
	{1063650560U, 24},
	{1063667712U, 21},
	{1063706624U, 22},
	{1063725056U, 22},
	{1063736064U, 24},
	{1063747584U, 24},
	{1063748096U, 24},
	{1063748608U, 23},
	{1063749120U, 24},
	{1063749376U, 24},
	{1063749632U, 24},
	{1063749888U, 24},
	{1063750400U, 24},
	{1063750656U, 24},
	{1063761408U, 24},
	{1063762688U, 24},
	{1063792640U, 22},
	{1063801856U, 22},
	{1063821312U, 24},
	{1063827456U, 23},
	{1063847680U, 24},
	{1063848704U, 24},
	{1063878144U, 23},
	{1063923968U, 24},
	{1063951360U, 23},
	{1064005632U, 24},
	{1064011520U, 24},
	{1064034304U, 23},
	{1064055808U, 23},
	{1064065024U, 21},
	{1064070656U, 24},
	{1064071168U, 21},
	{1064074496U, 24},
	{1064076544U, 24},
	{1064087296U, 24},
	{1064124416U, 24},
	{1064124672U, 24},
	{1064124928U, 24},
	{1064125184U, 24},
	{1064125440U, 24},
	{1064125952U, 24},
	{1064126208U, 24},
	{1064126464U, 24},
	{1064126720U, 24},
	{1064127232U, 24},
	{1064127488U, 24},
	{1064127744U, 24},
	{1064128000U, 24},
	{1064128256U, 24},
	{1064164096U, 24},
	{1064169472U, 20},
	{1064194816U, 24},
	{1064218368U, 24},
	{1064235776U, 24},
	{1064286208U, 23},
	{1064340480U, 22},
	{1064341504U, 24},
	{1064347648U, 22},
	{1064379904U, 23},
	{1064390656U, 20},
	{1064396800U, 21},
	{1064435712U, 24},
	{1064489728U, 24},
	{1064506112U, 24},
	{1064662016U, 24},
	{1064662272U, 24},
	{1064662528U, 24},
	{1064662784U, 24},
	{1064714752U, 24},
	{1064722176U, 24},
	{1064740096U, 24},
	{1064849408U, 24},
	{1064858368U, 24},
	{1064868352U, 24},
	{1064894720U, 24},
	{1064901632U, 22},
	{1064915968U, 24},
	{1064922880U, 24},
	{1064928256U, 23},
	{1064928768U, 23},
	{1064929280U, 22},
	{1064931328U, 23},
	{1064935168U, 24},
	{1064998912U, 24},
	{1064999424U, 24},
	{1065014528U, 24},
	{1065051904U, 24},
	{1065095424U, 24},
	{1065122816U, 24},
	{1065160448U, 24},
	{1065198080U, 23},
	{1065214464U, 24},
	{1065244416U, 24},
	{1065264128U, 24},
	{1065267712U, 24},
	{1065336832U, 21},
	{1065893888U, 20},
	{1065949696U, 24},
	{1066082304U, 20},
	{1066164736U, 24},
	{1066173440U, 24},
	{1066173952U, 24},
	{1066174720U, 24},
	{1066274304U, 24},
	{1066427392U, 24},
	{1066502656U, 24},
	{1066502912U, 24},
	{1066503168U, 24},
	{1066510080U, 24},
	{1066519296U, 24},
	{1066540288U, 24},
	{1066542080U, 24},
	{1066555648U, 24},
	{1066584832U, 24},
	{1066593536U, 24},
	{1066610688U, 24},
	{1066610944U, 24},
	{1066611200U, 24},
	{1066638336U, 22},
	{1066673920U, 24},
	{1066683648U, 24},
	{1066687744U, 24},
	{1066736128U, 24},
	{1066736640U, 24},
	{1066757376U, 24},
	{1066780416U, 24},
	{1066788864U, 24},
	{1066796032U, 24},
	{1066806272U, 24},
	{1066813440U, 22},
	{1066865408U, 24},
	{1066868736U, 21},
	{1066895616U, 24},
	{1066897152U, 24},
	{1067453184U, 24},
	{1067458560U, 21},
	{1067459584U, 24},
	{1067483392U, 24},
	{1067516928U, 23},
	{1067519488U, 24},
	{1067528960U, 24},
	{1067534592U, 24},
	{1067544576U, 24},
	{1067568128U, 22},
	{1067666432U, 23},
	{1067801088U, 24},
	{1067810560U, 24},
	{1067820032U, 24},
	{1067826944U, 24},
	{1067833344U, 22},
	{1067901440U, 24},
	{1067911168U, 23},
	{1067920128U, 24},
	{1067941376U, 23},
	{1067941376U, 24},
	{1067941632U, 24},
	{1067950080U, 24},
	{1067962368U, 20},
	{1068004608U, 24},
	{1068016128U, 24},
	{1068043008U, 24},
	{1068065792U, 24},
	{1068070912U, 21},
	{1068073984U, 24},
	{1068088832U, 24},
	{1068109312U, 24},
	{1068125696U, 24},
	{1068142080U, 24},
	{1068170752U, 23},
	{1068237312U, 24},
	{1068285184U, 24},
	{1068371968U, 20},
	{1068398592U, 21},
	{1068441600U, 20},
	{1068457984U, 24},
	{1069576192U, 20},
	{1069703168U, 19},
	{1069858816U, 20},
	{1070137344U, 20},
	{1070139136U, 24},
	{1070141440U, 20},
	{1070176768U, 24},
	{1070235648U, 20},
	{1070239744U, 20},
	{1070366720U, 24},
	{1070664448U, 24},
	{1070668800U, 24},
	{1070802432U, 23},
	{1070844416U, 23},
	{1071089920U, 24},
	{1071463424U, 24},
	{1071726336U, 24},
	{1071818240U, 24},
	{1071880704U, 23},
	{1071913984U, 24},
	{1072440064U, 24},
	{1072450560U, 23},
	{1072488704U, 24},
	{1072488960U, 24},
	{1072489216U, 24},
	{1072489472U, 24},
	{1072506624U, 24},
	{1072506880U, 24},
	{1072512256U, 24},
	{1072517120U, 23},
	{1072540416U, 24},
	{1072548096U, 24},
	{1072576512U, 24},
	{1072577280U, 24},
	{1072578816U, 24},
	{1072582400U, 24},
	{1072586752U, 22},
	{1072595968U, 24},
	{1072603136U, 19},
	{1072613376U, 22},
	{1072614400U, 22},
	{1072627200U, 23},
	{1072653312U, 24},
	{1072653568U, 24},
	{1072653824U, 24},
	{1072669440U, 24},
	{1072681728U, 24},
	{1072693248U, 15},
	{1072693248U, 18},
	{1072694272U, 24},
	{1072706560U, 24},
	{1072709632U, 19},
	{1072711168U, 24},
	{1072726016U, 18},
	{1072742400U, 19},
	{1072750592U, 19},
	{1072758784U, 18},
	{1072775168U, 19},
	{1072775168U, 22},
	{1072791552U, 18},
	{1072807936U, 18},
	{1072824320U, 16},
	{1073217536U, 20},
	{1073225216U, 23},
	{1073225728U, 23},
	{1073226240U, 24},
	{1073226496U, 24},
	{1073227264U, 23},
	{1073227776U, 23},
	{1073230848U, 22},
	{1073231872U, 22},
	{1073232896U, 22},
	{1073233920U, 21},
	{1073236992U, 22},
	{1073238528U, 23},
	{1073240064U, 23},
	{1073241344U, 24},
	{1073241856U, 24},
	{1073242624U, 23},
	{1073243136U, 23},
	{1073243648U, 23},
	{1073244160U, 23},
	{1073244672U, 23},
	{1073245184U, 23},
	{1073245696U, 24},
	{1073246208U, 23},
	{1073246720U, 23},
	{1073247744U, 23},
	{1073248256U, 23},
	{1073248768U, 23},
	{1073249280U, 23},
	{1073249792U, 23},
	{1073250304U, 20},
	{1073254400U, 21},
	{1073256448U, 22},
	{1073257472U, 23},
	{1073260544U, 21},
	{1073262592U, 20},
	{1073268736U, 23},
	{1073269760U, 22},
	{1073272320U, 23},
	{1073273344U, 24},
	{1073273600U, 24},
	{1073273856U, 23},
	{1073274368U, 23},
	{1073278464U, 23},
	{1073278976U, 24},
	{1073280000U, 23},
	{1073282560U, 23},
	{1073348608U, 19},
	{1073348608U, 24},
	{1073348864U, 24},
	{1073349120U, 24},
	{1073349376U, 24},
	{1073349632U, 24},
	{1073349888U, 24},
	{1073350144U, 24},
	{1073350400U, 24},
	{1073350656U, 24},
	{1073351680U, 24},
	{1073352448U, 24},
	{1073353216U, 24},
	{1073353728U, 24},
	{1073353984U, 24},
	{1073354752U, 24},
	{1073355008U, 24},
	{1073355264U, 24},
	{1073355520U, 24},
	{1073356800U, 19},
	{1073357824U, 24},
	{1073361920U, 22},
	{1073362944U, 21},
	{1073364992U, 19},
	{1073381376U, 20},
	{1073385472U, 20},
	{1073385472U, 24},
	{1073385728U, 24},
	{1073385984U, 24},
	{1073386240U, 24},
	{1073386496U, 24},
	{1073387008U, 24},
	{1073387264U, 24},
	{1073387520U, 24},
	{1073387776U, 24},
	{1073388032U, 24},
	{1073388288U, 24},
	{1073388544U, 24},
	{1073388800U, 24},
	{1073389056U, 24},
	{1073389312U, 24},
	{1073397760U, 19},
	{1073414144U, 20},
	{1073418240U, 20},
	{1073418240U, 21},
	{1073421568U, 24},
	{1073422080U, 24},
	{1073422336U, 20},
	{1073423104U, 24},
	{1073423616U, 24},
	{1073424384U, 21},
	{1073424896U, 24},
	{1073426432U, 20},
	{1073426688U, 24},
	{1073427456U, 24},
	{1073429504U, 24},
	{1073430528U, 20},
	{1073430528U, 24},
	{1073430784U, 24},
	{1073433344U, 24},
	{1073434112U, 24},
	{1073434624U, 20},
	{1073435136U, 24},
	{1073436160U, 23},
	{1073437952U, 24},
	{1073438464U, 24},
	{1073438720U, 20},
	{1073438720U, 24},
	{1073441280U, 24},
	{1073442304U, 24},
	{1073442816U, 20},
	{1073444352U, 24},
	{1073445120U, 24},
	{1073446912U, 20},
	{1073450496U, 24},
	{1073451008U, 20},
	{1073454080U, 24},
	{1073455104U, 20},
	{1073459200U, 20},
	{1073463296U, 19},
	{1073463296U, 24},
	{1073466112U, 24},
	{1073467392U, 20},
	{1073467392U, 21},
	{1073468416U, 24},
	{1073468672U, 24},
	{1073471488U, 19},
	{1073471488U, 24},
	{1073472512U, 24},
	{1073473792U, 24},
	{1073474816U, 24},
	{1073476096U, 23},
	{1073477376U, 24},
	{1073478400U, 24},
	{1073741824U, 14},
	{1073743872U, 21},
	{1073748224U, 24},
	{1073924608U, 23},
	{1073971200U, 21},
	{1073972224U, 24},
	{1073973760U, 24},
	{1073974016U, 24},
	{1073974272U, 22},
	{1074003968U, 18},
	{1074028544U, 20},
	{1074041600U, 24},
	{1074087680U, 24},
	{1074126848U, 24},
	{1074127104U, 24},
	{1074127360U, 24},
	{1074151424U, 20},
	{1074167808U, 20},
	{1074171904U, 20},
	{1074200576U, 19},
	{1074216960U, 19},
	{1074225152U, 20},
	{1074298880U, 18},
	{1074344960U, 24},
	{1074364416U, 18},
	{1074528256U, 16},
	{1074528256U, 20},
	{1074536448U, 20},
	{1074540544U, 20},
	{1074544640U, 20},
	{1074552832U, 19},
	{1074561024U, 17},
	{1074593792U, 16},
	{1074610176U, 20},
	{1074614272U, 20},
	{1074618368U, 20},
	{1074622464U, 20},
	{1074626560U, 20},
	{1074659328U, 19},
	{1074661632U, 24},
	{1074667520U, 19},
	{1074675712U, 20},
	{1074678272U, 23},
	{1074679808U, 20},
	{1074683904U, 20},
	{1074685952U, 22},
	{1074688000U, 20},
	{1074692096U, 20},
	{1074694144U, 23},
	{1074694400U, 24},
	{1074696192U, 20},
	{1074700288U, 20},
	{1074704384U, 20},
	{1074708480U, 20},
	{1074712576U, 20},
	{1074716672U, 20},
	{1074720768U, 20},
	{1074733056U, 20},
	{1074757632U, 20},
	{1074757872U, 30},
	{1074757876U, 30},
	{1074757880U, 29},
	{1074757920U, 27},
	{1074757952U, 26},
	{1074765824U, 20},
	{1074766216U, 30},
	{1074766220U, 30},
	{1074766224U, 28},
	{1074766240U, 27},
	{1074766336U, 24},
	{1074766848U, 25},
	{1074774016U, 20},
	{1074774016U, 28},
	{1074774032U, 28},
	{1074774272U, 25},
	{1074774400U, 26},
	{1074774464U, 28},
	{1074774480U, 29},
	{1074774488U, 29},
	{1074774496U, 27},
	{1074774528U, 23},
	{1074775040U, 26},
	{1074775136U, 30},
	{1074775140U, 30},
	{1074775144U, 30},
	{1074775148U, 30},
	{1074775168U, 28},
	{1074775200U, 27},
	{1074775232U, 26},
	{1074782208U, 20},
	{1074782208U, 24},
	{1074782208U, 28},
	{1074782224U, 28},
	{1074782272U, 29},
	{1074782280U, 29},
	{1074782464U, 24},
	{1074782720U, 27},
	{1074782848U, 26},
	{1074782928U, 28},
	{1074782944U, 28},
	{1074782972U, 30},
	{1074806784U, 19},
	{1074806784U, 20},
	{1074806784U, 22},
	{1074806784U, 24},
	{1074807040U, 24},
	{1074807296U, 24},
	{1074807552U, 24},
	{1074807808U, 24},
	{1074808064U, 24},
	{1074808320U, 24},
	{1074808576U, 24},
	{1074808832U, 24},
	{1074809088U, 24},
	{1074809344U, 24},
	{1074809600U, 24},
	{1074809856U, 22},
	{1074810368U, 24},
	{1074810624U, 24},
	{1074810880U, 22},
	{1074811904U, 22},
	{1074812928U, 22},
	{1074813952U, 24},
	{1074814208U, 24},
	{1074814464U, 24},
	{1074814720U, 24},
	{1074814976U, 20},
	{1074814976U, 24},
	{1074823168U, 19},
	{1074823168U, 20},
	{1074823424U, 24},
	{1074823936U, 24},
	{1074824192U, 24},
	{1074824448U, 24},
	{1074824960U, 24},
	{1074825216U, 24},
	{1074825472U, 24},
	{1074825728U, 24},
	{1074825984U, 24},
	{1074826240U, 24},
	{1074826496U, 24},
	{1074826752U, 23},
	{1074827264U, 24},
	{1074828032U, 24},
	{1074828800U, 24},
	{1074829056U, 24},
	{1074829312U, 23},
	{1074829824U, 24},
	{1074830080U, 24},
	{1074830336U, 24},
	{1074830592U, 24},
	{1074830848U, 24},
	{1074831104U, 24},
	{1074831360U, 24},
	{1074831872U, 24},
	{1074832128U, 24},
	{1074832640U, 24},
	{1074833152U, 24},
	{1074833408U, 24},
	{1074833664U, 24},
	{1074833920U, 24},
	{1074834176U, 24},
	{1074834688U, 24},
	{1074835200U, 24},
	{1074835456U, 20},
	{1074835456U, 24},
	{1074835968U, 24},
	{1074836480U, 24},
	{1074836992U, 24},
	{1074837248U, 24},
	{1074837504U, 24},
	{1074838272U, 24},
	{1074838528U, 24},
	{1074838784U, 24},
	{1074839040U, 24},
	{1074839296U, 24},
	{1074839552U, 18},
	{1074839552U, 19},
	{1074839552U, 22},
	{1074839808U, 24},
	{1074840576U, 23},
	{1074841088U, 23},
	{1074841600U, 23},
	{1074842112U, 24},
	{1074842368U, 24},
	{1074842624U, 23},
	{1074843136U, 23},
	{1074843648U, 23},
	{1074844160U, 24},
	{1074844416U, 24},
	{1074844672U, 23},
	{1074845184U, 24},
	{1074845440U, 24},
	{1074845696U, 22},
	{1074846720U, 23},
	{1074847232U, 24},
	{1074847488U, 24},
	{1074847744U, 22},
	{1074848768U, 22},
	{1074849792U, 21},
	{1074852096U, 24},
	{1074852352U, 23},
	{1074852864U, 23},
	{1074853376U, 23},
	{1074853888U, 24},
	{1074854144U, 24},
	{1074854400U, 24},
	{1074854656U, 24},
	{1074854912U, 24},
	{1074855168U, 24},
	{1074855936U, 18},
	{1074855936U, 20},
	{1074855936U, 22},
	{1074857472U, 24},
	{1074857728U, 24},
	{1074858240U, 24},
	{1074858496U, 24},
	{1074858752U, 24},
	{1074859264U, 24},
	{1074859520U, 24},
	{1074859776U, 24},
	{1074860032U, 20},
	{1074860288U, 24},
	{1074860800U, 24},
	{1074861056U, 24},
	{1074861568U, 24},
	{1074861824U, 24},
	{1074862080U, 24},
	{1074862336U, 24},
	{1074862848U, 24},
	{1074863104U, 24},
	{1074863616U, 24},
	{1074863872U, 24},
	{1074864128U, 24},
	{1074864384U, 24},
	{1074864640U, 24},
	{1074864896U, 24},
	{1074865152U, 24},
	{1074865408U, 24},
	{1074865664U, 24},
	{1074865920U, 24},
	{1074866432U, 24},
	{1074866688U, 24},
	{1074867200U, 24},
	{1074867456U, 24},
	{1074867968U, 24},
	{1074868224U, 24},
	{1074868736U, 24},
	{1074868992U, 24},
	{1074869248U, 24},
	{1074869760U, 24},
	{1074870016U, 24},
	{1074870272U, 24},
	{1074870528U, 24},
	{1074872320U, 20},
	{1074872320U, 24},
	{1074872576U, 24},
	{1074872832U, 24},
	{1074873088U, 24},
	{1074873344U, 24},
	{1074873600U, 24},
	{1074873856U, 24},
	{1074874112U, 24},
	{1074874368U, 21},
	{1074874368U, 22},
	{1074874624U, 24},
	{1074874880U, 23},
	{1074875392U, 24},
	{1074875648U, 24},
	{1074875904U, 24},
	{1074876160U, 24},
	{1074876416U, 20},
	{1074876416U, 24},
	{1074876672U, 24},
	{1074876928U, 24},
	{1074877184U, 24},
	{1074877440U, 24},
	{1074877696U, 24},
	{1074877952U, 24},
	{1074878208U, 24},
	{1074878464U, 24},
	{1074878720U, 24},
	{1074878976U, 24},
	{1074888704U, 19},
	{1074888704U, 20},
	{1074888704U, 24},
	{1074888960U, 24},
	{1074889216U, 23},
	{1074889728U, 23},
	{1074890240U, 23},
	{1074890496U, 24},
	{1074890752U, 24},
	{1074891008U, 24},
	{1074891264U, 24},
	{1074891520U, 24},
	{1074891776U, 24},
	{1074892032U, 24},
	{1074892288U, 23},
	{1074892800U, 23},
	{1074893312U, 24},
	{1074893568U, 24},
	{1074894080U, 24},
	{1074894336U, 24},
	{1074894592U, 24},
	{1074894848U, 24},
	{1074895104U, 24},
	{1074895872U, 22},
	{1074896896U, 19},
	{1074896896U, 24},
	{1074897152U, 24},
	{1074897408U, 24},
	{1074897664U, 24},
	{1074905088U, 20},
	{1074906112U, 23},
	{1074906624U, 24},
	{1074906880U, 24},
	{1074907136U, 24},
	{1074907392U, 24},
	{1074907648U, 24},
	{1074907904U, 24},
	{1074908160U, 24},
	{1074908416U, 24},
	{1074921472U, 20},
	{1074921472U, 23},
	{1074921984U, 24},
	{1074922240U, 24},
	{1074922496U, 24},
	{1074922752U, 24},
	{1074923008U, 24},
	{1074923264U, 24},
	{1074923520U, 21},
	{1074923520U, 24},
	{1074924032U, 24},
	{1074924288U, 24},
	{1074924800U, 24},
	{1074925056U, 23},
	{1074937856U, 19},
	{1074937856U, 20},
	{1074938624U, 24},
	{1074939136U, 24},
	{1074939392U, 24},
	{1074939648U, 24},
	{1074939904U, 21},
	{1074940416U, 24},
	{1074941952U, 24},
	{1074942720U, 24},
	{1074943232U, 24},
	{1074943744U, 24},
	{1074954240U, 19},
	{1074954240U, 20},
	{1074955264U, 22},
	{1074956288U, 24},
	{1074956544U, 24},
	{1074956800U, 24},
	{1074957056U, 24},
	{1074957312U, 24},
	{1074957568U, 24},
	{1074958336U, 24},
	{1074958592U, 24},
	{1074958848U, 24},
	{1074959104U, 24},
	{1074970624U, 19},
	{1074987008U, 18},
	{1075003392U, 19},
	{1075052544U, 20},
	{1075056640U, 20},
	{1075060736U, 20},
	{1075068928U, 20},
	{1075073024U, 20},
	{1075077120U, 20},
	{1075081216U, 20},
	{1075085312U, 20},
	{1075089408U, 20},
	{1075093504U, 20},
	{1075097600U, 20},
	{1075101696U, 20},
	{1075105792U, 20},
	{1075109888U, 20},
	{1075113984U, 20},
	{1075118080U, 17},
	{1075130624U, 24},
	{1075132416U, 23},
	{1075135488U, 23},
	{1075138304U, 24},
	{1075144192U, 23},
	{1075150848U, 18},
	{1075183616U, 18},
	{1075187712U, 22},
	{1075188736U, 22},
	{1075198464U, 23},
	{1075198976U, 22},
	{1075200000U, 20},
	{1075204096U, 20},
	{1075208192U, 19},
	{1075216384U, 19},
	{1075217408U, 22},
	{1075217408U, 23},
	{1075217408U, 24},
	{1075217664U, 25},
	{1075217920U, 23},
	{1075232768U, 19},
	{1075304704U, 24},
	{1075314688U, 16},
	{1075335168U, 20},
	{1075462144U, 18},
	{1075494912U, 19},
	{1075503104U, 19},
	{1075511296U, 19},
	{1075519488U, 20},
	{1075519488U, 24},
	{1075527680U, 18},
	{1075544064U, 19},
	{1075552256U, 20},
	{1075576832U, 19},
	{1075593216U, 19},
	{1075594240U, 23},
	{1075594240U, 24},
	{1075594496U, 24},
	{1075613696U, 20},
	{1075617792U, 20},
	{1075646464U, 20},
	{1075650560U, 20},
	{1075658752U, 19},
	{1075658752U, 20},
	{1075660288U, 24},
	{1075660800U, 22},
	{1075666432U, 24},
	{1075691520U, 19},
	{1075699712U, 20},
	{1075712256U, 24},
	{1075714560U, 24},
	{1075716608U, 24},
	{1075740672U, 19},
	{1075765248U, 20},
	{1075773440U, 19},
	{1075839232U, 24},
	{1075843072U, 24},
	{1075846144U, 24},
	{1075846912U, 24},
	{1075848192U, 24},
	{1075849728U, 23},
	{1075851520U, 24},
	{1075852288U, 24},
	{1075852800U, 24},
	{1075871744U, 18},
	{1076035584U, 17},
	{1076035584U, 18},
	{1076101120U, 16},
	{1076101120U, 24},
	{1076101376U, 24},
	{1076101632U, 24},
	{1076101888U, 24},
	{1076102144U, 22},
	{1076103168U, 24},
	{1076103424U, 24},
	{1076103680U, 24},
	{1076103936U, 24},
	{1076104192U, 23},
	{1076104704U, 23},
	{1076105216U, 24},
	{1076105472U, 24},
	{1076105728U, 24},
	{1076105984U, 24},
	{1076106496U, 24},
	{1076106752U, 23},
	{1076107264U, 23},
	{1076107776U, 24},
	{1076108032U, 24},
	{1076108288U, 24},
	{1076108544U, 24},
	{1076108800U, 24},
	{1076109056U, 24},
	{1076109312U, 22},
	{1076110592U, 24},
	{1076110848U, 23},
	{1076111360U, 22},
	{1076112384U, 23},
	{1076112896U, 24},
	{1076113152U, 24},
	{1076113408U, 24},
	{1076113664U, 24},
	{1076113920U, 24},
	{1076114176U, 24},
	{1076114432U, 23},
	{1076114944U, 24},
	{1076115456U, 24},
	{1076115712U, 24},
	{1076116224U, 24},
	{1076116480U, 24},
	{1076116736U, 24},
	{1076116992U, 23},
	{1076117504U, 21},
	{1076119552U, 21},
	{1076121600U, 22},
	{1076122624U, 23},
	{1076123136U, 24},
	{1076123648U, 23},
	{1076124160U, 24},
	{1076124672U, 24},
	{1076125696U, 24},
	{1076125952U, 24},
	{1076126208U, 24},
	{1076126720U, 22},
	{1076127744U, 24},
	{1076128000U, 24},
	{1076128256U, 24},
	{1076128768U, 24},
	{1076129280U, 24},
	{1076129792U, 23},
	{1076130816U, 23},
	{1076131328U, 23},
	{1076131840U, 22},
	{1076132864U, 24},
	{1076133120U, 24},
	{1076133888U, 22},
	{1076134912U, 23},
	{1076135424U, 23},
	{1076135936U, 22},
	{1076136960U, 23},
	{1076137472U, 23},
	{1076137984U, 24},
	{1076138240U, 24},
	{1076138496U, 24},
	{1076138752U, 24},
	{1076139008U, 24},
	{1076139520U, 24},
	{1076140032U, 22},
	{1076141056U, 24},
	{1076141312U, 24},
	{1076142080U, 21},
	{1076144128U, 22},
	{1076145152U, 23},
	{1076145664U, 24},
	{1076146176U, 22},
	{1076147200U, 23},
	{1076148736U, 23},
	{1076149248U, 22},
	{1076150784U, 23},
	{1076151808U, 23},
	{1076152320U, 23},
	{1076152832U, 23},
	{1076153344U, 23},
	{1076153856U, 23},
	{1076154368U, 23},
	{1076154880U, 23},
	{1076155392U, 24},
	{1076155904U, 23},
	{1076156416U, 24},
	{1076156672U, 24},
	{1076156928U, 24},
	{1076157440U, 24},
	{1076157952U, 23},
	{1076158720U, 24},
	{1076158976U, 23},
	{1076159488U, 24},
	{1076159744U, 24},
	{1076160512U, 24},
	{1076161280U, 24},
	{1076161536U, 24},
	{1076162304U, 24},
	{1076183040U, 19},
	{1076191232U, 19},
	{1076199424U, 21},
	{1076203520U, 20},
	{1076215808U, 18},
	{1076256768U, 20},
	{1076264960U, 18},
	{1076297728U, 19},
	{1076305920U, 19},
	{1076314112U, 19},
	{1076322304U, 20},
	{1076330496U, 20},
	{1076346880U, 19},
	{1076355072U, 20},
	{1076355072U, 21},
	{1076363264U, 20},
	{1076404224U, 20},
	{1076461568U, 17},
	{1076462592U, 24},
	{1076467712U, 21},
	{1076467712U, 22},
	{1076467712U, 24},
	{1076467968U, 24},
	{1076468224U, 24},
	{1076468224U, 26},
	{1076468352U, 25},
	{1076468480U, 24},
	{1076468736U, 22},
	{1076469184U, 26},
	{1076469248U, 25},
	{1076469376U, 26},
	{1076469440U, 28},
	{1076469472U, 27},
	{1076469504U, 25},
	{1076469760U, 22},
	{1076475904U, 27},
	{1076477456U, 28},
	{1076478208U, 24},
	{1076494080U, 24},
	{1076494336U, 17},
	{1076504576U, 21},
	{1076506624U, 21},
	{1076509696U, 22},
	{1076512768U, 21},
	{1076521984U, 22},
	{1076523008U, 20},
	{1076559872U, 16},
	{1076625408U, 19},
	{1076633600U, 20},
	{1076633600U, 22},
	{1076633600U, 23},
	{1076634112U, 24},
	{1076634624U, 22},
	{1076635648U, 22},
	{1076635648U, 23},
	{1076636672U, 24},
	{1076637184U, 23},
	{1076637696U, 20},
	{1076641792U, 19},
	{1076649984U, 20},
	{1076654080U, 20},
	{1076654080U, 21},
	{1076656128U, 22},
	{1076657152U, 22},
	{1076658176U, 20},
	{1076658176U, 22},
	{1076659200U, 22},
	{1076660224U, 22},
	{1076661248U, 22},
	{1076662272U, 20},
	{1076662272U, 22},
	{1076663296U, 22},
	{1076664320U, 21},
	{1076666368U, 20},
	{1076666368U, 22},
	{1076667392U, 22},
	{1076668416U, 21},
	{1076670464U, 20},
	{1076670464U, 22},
	{1076671488U, 22},
	{1076672512U, 22},
	{1076673536U, 23},
	{1076674560U, 18},
	{1076678144U, 24},
	{1076723712U, 19},
	{1076789248U, 19},
	{1076797440U, 20},
	{1076805632U, 18},
	{1076887552U, 16},
	{1076953088U, 18},
	{1076985856U, 18},
	{1076994048U, 21},
	{1076996096U, 21},
	{1077002240U, 19},
	{1077018624U, 17},
	{1077019648U, 23},
	{1077020416U, 24},
	{1077020672U, 22},
	{1077021696U, 24},
	{1077021952U, 24},
	{1077022208U, 23},
	{1077022720U, 23},
	{1077023232U, 23},
	{1077023744U, 23},
	{1077024256U, 23},
	{1077025024U, 24},
	{1077025280U, 24},
	{1077025536U, 24},
	{1077025792U, 24},
	{1077026048U, 24},
	{1077026304U, 23},
	{1077026816U, 23},
	{1077027328U, 23},
	{1077027840U, 24},
	{1077028096U, 24},
	{1077028352U, 23},
	{1077028864U, 24},
	{1077029120U, 24},
	{1077029376U, 24},
	{1077029632U, 24},
	{1077029888U, 23},
	{1077030400U, 23},
	{1077030912U, 23},
	{1077031424U, 24},
	{1077031680U, 24},
	{1077031936U, 24},
	{1077032192U, 24},
	{1077032448U, 23},
	{1077032960U, 23},
	{1077033728U, 24},
	{1077033984U, 23},
	{1077034496U, 24},
	{1077034752U, 24},
	{1077035008U, 20},
	{1077039104U, 22},
	{1077040128U, 22},
	{1077041152U, 22},
	{1077042176U, 23},
	{1077042688U, 23},
	{1077043200U, 22},
	{1077043456U, 24},
	{1077044224U, 23},
	{1077044736U, 23},
	{1077045248U, 22},
	{1077046016U, 24},
	{1077046272U, 22},
	{1077047296U, 23},
	{1077047808U, 23},
	{1077048320U, 23},
	{1077048832U, 23},
	{1077049344U, 23},
	{1077049856U, 24},
	{1077050112U, 24},
	{1077050368U, 23},
	{1077050368U, 24},
	{1077050624U, 24},
	{1077050880U, 24},
	{1077051136U, 24},
	{1077051392U, 19},
	{1077059584U, 19},
	{1077067776U, 19},
	{1077166080U, 20},
	{1077182464U, 20},
	{1077186560U, 20},
	{1077190656U, 20},
	{1077215232U, 18},
	{1077215232U, 19},
	{1077223424U, 19},
	{1077231616U, 19},
	{1077239808U, 19},
	{1077420032U, 19},
	{1077436416U, 20},
	{1077452800U, 19},
	{1077460992U, 20},
	{1077464124U, 30},
	{1077477376U, 20},
	{1077510144U, 20},
	{1077518336U, 19},
	{1077522432U, 24},
	{1077534720U, 20},
	{1077559296U, 19},
	{1077563392U, 22},
	{1077583360U, 23},
	{1077608448U, 18},
	{1077608448U, 23},
	{1077609472U, 22},
	{1077610496U, 23},
	{1077611008U, 23},
	{1077612544U, 22},
	{1077613568U, 23},
	{1077715968U, 24},
	{1077739520U, 19},
	{1077746944U, 24},
	{1077747712U, 19},
	{1077755904U, 19},
	{1077764096U, 19},
	{1077772288U, 20},
	{1077784576U, 20},
	{1077805056U, 17},
	{1077805056U, 21},
	{1077808128U, 22},
	{1077835776U, 24},
	{1077837056U, 24},
	{1077876736U, 22},
	{1077886976U, 19},
	{1077895168U, 20},
	{1077903360U, 20},
	{1077915648U, 20},
	{1078001664U, 18},
	{1078074368U, 24},
	{1078206464U, 19},
	{1078214656U, 19},
	{1078215680U, 24},
	{1078231040U, 22},
	{1078232064U, 22},
	{1078233088U, 22},
	{1078267904U, 20},
	{1078296576U, 20},
	{1078304768U, 19},
	{1078305152U, 25},
	{1078309312U, 27},
	{1078317056U, 20},
	{1078329344U, 18},
	{1078330368U, 22},
	{1078330368U, 23},
	{1078330624U, 25},
	{1078330880U, 23},
	{1078343680U, 23},
	{1078345728U, 19},
	{1078346752U, 22},
	{1078362112U, 17},
	{1078411264U, 19},
	{1078427648U, 18},
	{1078525952U, 17},
	{1078591488U, 19},
	{1078592768U, 24},
	{1078593536U, 22},
	{1078599680U, 19},
	{1078600704U, 23},
	{1078601216U, 24},
	{1078601472U, 24},
	{1078601728U, 22},
	{1078602752U, 24},
	{1078603264U, 23},
	{1078603264U, 24},
	{1078603520U, 24},
	{1078604032U, 24},
	{1078604288U, 24},
	{1078607616U, 24},
	{1078657024U, 18},
	{1078663168U, 24},
	{1078663424U, 24},
	{1078663680U, 24},
	{1078722560U, 16},
	{1078722560U, 19},
	{1078724608U, 21},
	{1078726656U, 21},
	{1078730752U, 20},
	{1078730752U, 21},
	{1078732800U, 23},
	{1078735104U, 24},
	{1078735360U, 24},
	{1078735616U, 24},
	{1078735872U, 22},
	{1078736896U, 24},
	{1078737152U, 24},
	{1078737408U, 24},
	{1078739712U, 24},
	{1078739968U, 22},
	{1078740992U, 21},
	{1078750208U, 24},
	{1078753280U, 21},
	{1078753792U, 23},
	{1078758912U, 24},
	{1078759168U, 24},
	{1078760960U, 24},
	{1078761216U, 24},
	{1078761472U, 24},
	{1078761728U, 24},
	{1078761984U, 24},
	{1078762240U, 24},
	{1078762496U, 24},
	{1078762752U, 24},
	{1078820864U, 18},
	{1078853632U, 18},
	{1078935552U, 19},
	{1078943744U, 20},
	{1078984704U, 16},
	{1078984704U, 22},
	{1078985728U, 24},
	{1078985984U, 24},
	{1078986240U, 24},
	{1078986496U, 24},
	{1078986752U, 21},
	{1078988800U, 20},
	{1078988800U, 23},
	{1078989312U, 23},
	{1078989824U, 23},
	{1078990336U, 23},
	{1078990848U, 21},
	{1078992896U, 20},
	{1078996992U, 22},
	{1078998016U, 22},
	{1078999552U, 23},
	{1079000064U, 22},
	{1079001088U, 21},
	{1079003136U, 21},
	{1079005184U, 22},
	{1079006208U, 23},
	{1079006720U, 23},
	{1079007232U, 21},
	{1079009280U, 22},
	{1079010304U, 22},
	{1079011328U, 21},
	{1079013376U, 22},
	{1079014400U, 22},
	{1079015424U, 22},
	{1079016448U, 23},
	{1079016960U, 23},
	{1079017472U, 20},
	{1079021568U, 20},
	{1079025664U, 21},
	{1079027712U, 21},
	{1079029760U, 20},
	{1079029760U, 21},
	{1079031808U, 22},
	{1079033856U, 21},
	{1079035904U, 22},
	{1079037952U, 20},
	{1079042048U, 21},
	{1079044096U, 22},
	{1079046144U, 22},
	{1079048192U, 22},
	{1079049728U, 23},
	{1079050240U, 19},
	{1079058432U, 20},
	{1079062528U, 20},
	{1079066624U, 20},
	{1079070720U, 20},
	{1079074816U, 20},
	{1079078912U, 20},
	{1079083008U, 21},
	{1079085056U, 21},
	{1079087104U, 20},
	{1079091200U, 19},
	{1079099392U, 19},
	{1079107584U, 21},
	{1079109632U, 21},
	{1079111680U, 20},
	{1079115776U, 17},
	{1079253504U, 24},
	{1079257344U, 24},
	{1079312384U, 20},
	{1079328768U, 18},
	{1079361536U, 19},
	{1079459840U, 19},
	{1079582720U, 20},
	{1079582976U, 24},
	{1079599104U, 20},
	{1079615488U, 20},
	{1079640064U, 19},
	{1079640064U, 23},
	{1079640576U, 24},
	{1079640832U, 24},
	{1079641088U, 23},
	{1079641600U, 24},
	{1079641856U, 24},
	{1079642112U, 24},
	{1079642368U, 24},
	{1079642624U, 24},
	{1079643136U, 24},
	{1079643392U, 24},
	{1079643648U, 24},
	{1079643904U, 24},
	{1079644160U, 23},
	{1079644672U, 24},
	{1079644928U, 24},
	{1079645184U, 23},
	{1079645696U, 24},
	{1079645952U, 24},
	{1079646208U, 23},
	{1079646720U, 24},
	{1079646976U, 24},
	{1079647232U, 24},
	{1079647488U, 24},
	{1079647744U, 24},
	{1079648000U, 24},
	{1079656448U, 20},
	{1079664640U, 20},
	{1079701504U, 20},
	{1079803904U, 20},
	{1079805696U, 24},
	{1079808000U, 20},
	{1079812096U, 20},
	{1079902208U, 20},
	{1079903744U, 24},
	{1079906304U, 20},
	{1079907328U, 22},
	{1079910144U, 24},
	{1079910400U, 20},
	{1079914496U, 20},
	{1079914496U, 22},
	{1079914496U, 24},
	{1079914752U, 24},
	{1079918592U, 19},
	{1079918592U, 22},
	{1079919616U, 24},
	{1079920128U, 24},
	{1079922944U, 24},
	{1079923200U, 24},
	{1079923456U, 24},
	{1079924736U, 24},
	{1079924992U, 24},
	{1079926016U, 24},
	{1079926272U, 24},
	{1079926528U, 24},
	{1079926784U, 20},
	{1079926784U, 23},
	{1079927296U, 23},
	{1079930880U, 20},
	{1079934976U, 20},
	{1079934976U, 22},
	{1079939072U, 20},
	{1079939072U, 22},
	{1079940864U, 24},
	{1079941120U, 22},
	{1079943168U, 19},
	{1079943168U, 20},
	{1079943680U, 24},
	{1079944960U, 24},
	{1079945728U, 24},
	{1079946752U, 24},
	{1079947008U, 24},
	{1079948288U, 23},
	{1079948800U, 23},
	{1079948800U, 24},
	{1079949056U, 24},
	{1079951360U, 20},
	{1079953152U, 24},
	{1079953664U, 24},
	{1079953920U, 23},
	{1079953920U, 24},
	{1079954176U, 24},
	{1079955200U, 24},
	{1079955456U, 20},
	{1079956992U, 23},
	{1079958016U, 24},
	{1079959552U, 20},
	{1079959552U, 21},
	{1079963136U, 24},
	{1079963648U, 20},
	{1079964160U, 24},
	{1079967744U, 19},
	{1079970816U, 24},
	{1079973888U, 24},
	{1079974400U, 24},
	{1079974656U, 24},
	{1079974912U, 24},
	{1079984128U, 20},
	{1079988224U, 20},
	{1079992064U, 24},
	{1079992320U, 20},
	{1079993344U, 22},
	{1079996416U, 20},
	{1080000512U, 20},
	{1080008704U, 19},
	{1080010752U, 22},
	{1080012288U, 24},
	{1080012800U, 22},
	{1080016896U, 20},
	{1080020992U, 20},
	{1080033280U, 14},
	{1080295424U, 14},
	{1080557568U, 16},
	{1080701184U, 28},
	{1080754176U, 17},
	{1080786944U, 17},
	{1080950784U, 19},
	{1080954624U, 24},
	{1080958976U, 20},
	{1080965120U, 22},
	{1080966144U, 22},
	{1080970496U, 24},
	{1080971008U, 24},
	{1080971264U, 20},
	{1080975360U, 20},
	{1080977408U, 21},
	{1080979456U, 20},
	{1080979968U, 24},
	{1080980992U, 24},
	{1080982016U, 24},
	{1080983040U, 24},
	{1080983552U, 23},
	{1080984064U, 24},
	{1080984832U, 24},
	{1080985600U, 21},
	{1080987648U, 21},
	{1080988672U, 22},
	{1080989184U, 23},
	{1080989696U, 21},
	{1080990720U, 22},
	{1080991744U, 20},
	{1080995840U, 20},
	{1081016320U, 20},
	{1081020416U, 20},
	{1081024512U, 20},
	{1081032704U, 20},
	{1081036800U, 20},
	{1081040896U, 20},
	{1081044992U, 20},
	{1081053184U, 20},
	{1081057280U, 20},
	{1081081856U, 20},
	{1081081856U, 22},
	{1081082880U, 22},
	{1081083904U, 22},
	{1081084928U, 22},
	{1081085952U, 22},
	{1081090048U, 20},
	{1081090048U, 22},
	{1081094144U, 20},
	{1081094144U, 22},
	{1081095168U, 22},
	{1081096192U, 22},
	{1081098240U, 20},
	{1081098240U, 21},
	{1081100288U, 21},
	{1081102336U, 20},
	{1081114624U, 18},
	{1081114624U, 19},
	{1081122816U, 20},
	{1081122816U, 21},
	{1081124864U, 21},
	{1081126912U, 20},
	{1081128960U, 23},
	{1081278464U, 19},
	{1081671680U, 16},
	{1081737216U, 18},
	{1081739264U, 21},
	{1081741312U, 21},
	{1081743360U, 21},
	{1081745408U, 21},
	{1081747456U, 21},
	{1081749504U, 21},
	{1081827328U, 21},
	{1081829376U, 23},
	{1081839616U, 20},
	{1081868288U, 15},
	{1081869824U, 24},
	{1081876224U, 24},
	{1081878784U, 24},
	{1081886208U, 24},
	{1081891840U, 24},
	{1081895424U, 23},
	{1081905920U, 24},
	{1081906176U, 24},
	{1081906688U, 24},
	{1081911552U, 24},
	{1081922560U, 24},
	{1081922816U, 24},
	{1081999360U, 18},
	{1082064896U, 18},
	{1082393088U, 23},
	{1082396160U, 24},
	{1082399232U, 24},
	{1082413824U, 24},
	{1082414080U, 24},
	{1082526720U, 24},
	{1082527744U, 22},
	{1082528768U, 23},
	{1082531072U, 24},
	{1082555904U, 24},
	{1082589184U, 17},
	{1082654720U, 20},
	{1082658816U, 20},
	{1082658816U, 23},
	{1082658816U, 24},
	{1082659072U, 24},
	{1082662912U, 20},
	{1082662912U, 21},
	{1082666240U, 24},
	{1082666752U, 24},
	{1082855424U, 20},
	{1082859520U, 20},
	{1083441152U, 16},
	{1083441152U, 20},
	{1083445248U, 20},
	{1083449344U, 20},
	{1083453440U, 20},
	{1083457536U, 20},
	{1083461632U, 20},
	{1083465728U, 20},
	{1083469824U, 20},
	{1083486208U, 20},
	{1083498496U, 20},
	{1083506688U, 16},
	{1083506688U, 20},
	{1083510784U, 20},
	{1083514880U, 20},
	{1083518976U, 20},
	{1083523072U, 20},
	{1083527168U, 20},
	{1083531264U, 20},
	{1083535360U, 20},
	{1083539456U, 20},
	{1083543552U, 20},
	{1083547648U, 20},
	{1083551744U, 20},
	{1083572224U, 16},
	{1083705344U, 22},
	{1083728640U, 24},
	{1083731712U, 24},
	{1083734272U, 24},
	{1083748352U, 21},
	{1083879424U, 21},
	{1083884032U, 23},
	{1083889152U, 23},
	{1084011520U, 23},
	{1084030976U, 22},
	{1084090368U, 22},
	{1084126208U, 24},
	{1084126464U, 24},
	{1084178432U, 21},
	{1084180480U, 22},
	{1084181504U, 22},
	{1084257280U, 22},
	{1084301312U, 20},
	{1084305408U, 20},
	{1084324096U, 24},
	{1084378880U, 24},
	{1084384000U, 24},
	{1084386304U, 23},
	{1084415488U, 24},
	{1084504832U, 24},
	{1084549120U, 24},
	{1084661760U, 20},
	{1084801024U, 20},
	{1084817408U, 20},
	{1085132800U, 20},
	{1085276160U, 16},
	{1085341696U, 16},
	{1085604096U, 24},
	{1085734912U, 16},
	{1086062592U, 20},
	{1086066688U, 21},
	{1086069760U, 22},
	{1086075904U, 22},
	{1086076928U, 22},
	{1086077952U, 22},
	{1086080512U, 23},
	{1086088192U, 22},
	{1086089216U, 23},
	{1086090240U, 23},
	{1086091264U, 23},
	{1086091776U, 23},
	{1086094336U, 23},
	{1086094848U, 23},
	{1086095360U, 23},
	{1086099456U, 22},
	{1086101760U, 24},
	{1086103040U, 23},
	{1086103552U, 21},
	{1086105600U, 21},
	{1086107648U, 20},
	{1086111744U, 21},
	{1086115840U, 21},
	{1086126592U, 23},
	{1086127104U, 23},
	{1086127616U, 23},
	{1086849024U, 16},
	{1086873344U, 24},
	{1086873600U, 23},
	{1086887936U, 24},
	{1086896896U, 24},
	{1086897152U, 23},
	{1087374368U, 27},
	{1087381504U, 24},
	{1087382016U, 24},
	{1087383040U, 24},
	{1087383552U, 27},
	{1087383608U, 30},
	{1087383612U, 30},
	{1087383632U, 28},
	{1087383648U, 27},
	{1087383680U, 28},
	{1087383696U, 29},
	{1087383712U, 27},
	{1087384064U, 24},
	{1087384320U, 24},
	{1087384605U, 24},
	{1087384608U, 27},
	{1087384672U, 27},
	{1087384740U, 30},
	{1087384768U, 26},
	{1087384832U, 24},
	{1087384864U, 27},
	{1087384896U, 27},
	{1087384928U, 27},
	{1087384960U, 25},
	{1087385088U, 25},
	{1087385216U, 25},
	{1087385344U, 25},
	{1087385856U, 24},
	{1087386128U, 29},
	{1087386136U, 29},
	{1087386144U, 27},
	{1087386176U, 26},
	{1087386304U, 28},
	{1087386624U, 23},
	{1087407616U, 23},
	{1087414976U, 26},
	{1087415040U, 24},
	{1087416112U, 30},
	{1087416128U, 26},
	{1087416832U, 24},
	{1087417088U, 24},
	{1087417344U, 24},
	{1087417728U, 26},
	{1087418352U, 28},
	{1087419904U, 24},
	{1087420384U, 28},
	{1087420400U, 28},
	{1087420416U, 24},
	{1087420928U, 23},
	{1087421440U, 24},
	{1087421696U, 24},
	{1087421952U, 24},
	{1087422208U, 24},
	{1087429632U, 24},
	{1087434752U, 24},
	{1087443200U, 25},
	{1087443472U, 28},
	{1087443520U, 27},
	{1087443584U, 26},
	{1087458816U, 24},
	{1087462144U, 24},
	{1087462400U, 24},
	{1087471616U, 28},
	{1087471632U, 29},
	{1087471640U, 29},
	{1087471648U, 27},
	{1087471680U, 28},
	{1087471696U, 28},
	{1087471720U, 30},
	{1087471724U, 30},
	{1087471728U, 28},
	{1087471744U, 25},
	{1087471872U, 24},
	{1087472128U, 24},
	{1087472384U, 24},
	{1087472640U, 26},
	{1087472704U, 28},
	{1087472720U, 28},
	{1087472752U, 30},
	{1087472756U, 30},
	{1087472760U, 29},
	{1087472768U, 25},
	{1087473152U, 28},
	{1087473168U, 28},
	{1087473184U, 27},
	{1087473216U, 29},
	{1087473224U, 29},
	{1087473232U, 28},
	{1087473248U, 27},
	{1087473280U, 27},
	{1087473312U, 30},
	{1087473328U, 28},
	{1087473408U, 24},
	{1087474176U, 27},
	{1087474208U, 27},
	{1087474240U, 27},
	{1087474272U, 28},
	{1087474288U, 30},
	{1087474292U, 30},
	{1087474296U, 29},
	{1087474304U, 27},
	{1087474368U, 26},
	{1087474432U, 27},
	{1087474464U, 27},
	{1087474496U, 26},
	{1087474576U, 28},
	{1087474592U, 27},
	{1087474624U, 27},
	{1087474656U, 27},
	{1087474688U, 24},
	{1087474944U, 27},
	{1087474976U, 27},
	{1087475008U, 26},
	{1087475072U, 26},
	{1087475136U, 27},
	{1087475168U, 27},
	{1087475200U, 28},
	{1087475216U, 28},
	{1087475584U, 26},
	{1087475648U, 26},
	{1087479808U, 24},
	{1087480064U, 29},
	{1087480096U, 29},
	{1087480104U, 29},
	{1087480112U, 28},
	{1087480128U, 27},
	{1087480160U, 27},
	{1087480192U, 26},
	{1087480288U, 27},
	{1087480320U, 28},
	{1087480336U, 29},
	{1087480352U, 30},
	{1087480356U, 30},
	{1087480360U, 30},
	{1087480368U, 28},
	{1087480384U, 26},
	{1087480448U, 26},
	{1087480512U, 28},
	{1087480544U, 27},
	{1087480576U, 24},
	{1087480832U, 23},
	{1087481344U, 24},
	{1087481600U, 28},
	{1087481616U, 28},
	{1087481632U, 27},
	{1087481696U, 27},
	{1087481736U, 29},
	{1087481744U, 28},
	{1087481744U, 29},
	{1087481760U, 29},
	{1087481768U, 29},
	{1087481776U, 28},
	{1087481856U, 25},
	{1087481984U, 27},
	{1087482016U, 29},
	{1087482024U, 29},
	{1087482036U, 30},
	{1087482040U, 30},
	{1087482048U, 28},
	{1087482064U, 28},
	{1087482080U, 27},
	{1087482112U, 27},
	{1087482152U, 29},
	{1087482164U, 30},
	{1087482168U, 29},
	{1087482184U, 29},
	{1087482192U, 28},
	{1087482208U, 27},
	{1087482240U, 26},
	{1087482304U, 27},
	{1087482336U, 27},
	{1087482368U, 23},
	{1087483392U, 29},
	{1087483400U, 29},
	{1087483408U, 29},
	{1087483416U, 30},
	{1087483420U, 30},
	{1087483424U, 27},
	{1087483456U, 27},
	{1087483488U, 28},
	{1087483512U, 29},
	{1087483520U, 25},
	{1087483648U, 24},
	{1087483904U, 24},
	{1087484176U, 28},
	{1087484192U, 27},
	{1087484224U, 26},
	{1087484304U, 28},
	{1087484320U, 27},
	{1087484416U, 26},
	{1087484544U, 29},
	{1087484560U, 28},
	{1087484576U, 29},
	{1087484584U, 29},
	{1087484592U, 29},
	{1087484600U, 29},
	{1087484608U, 26},
	{1087484672U, 27},
	{1087484704U, 27},
	{1087484736U, 28},
	{1087484752U, 30},
	{1087484756U, 30},
	{1087484768U, 27},
	{1087484800U, 25},
	{1087484928U, 24},
	{1087485184U, 27},
	{1087485216U, 28},
	{1087485232U, 29},
	{1087485240U, 29},
	{1087485248U, 27},
	{1087485280U, 28},
	{1087485296U, 29},
	{1087485304U, 29},
	{1087485700U, 30},
	{1087485712U, 29},
	{1087485720U, 29},
	{1087485776U, 28},
	{1087485792U, 29},
	{1087485800U, 29},
	{1087485808U, 28},
	{1087485824U, 26},
	{1087485840U, 28},
	{1087485856U, 28},
	{1087485872U, 28},
	{1087485888U, 27},
	{1087485920U, 28},
	{1087485936U, 28},
	{1087485952U, 25},
	{1087486080U, 26},
	{1087486144U, 29},
	{1087486152U, 29},
	{1087486160U, 28},
	{1087486176U, 27},
	{1087486208U, 24},
	{1087486464U, 23},
	{1087486976U, 25},
	{1087487232U, 24},
	{1087487552U, 28},
	{1087487568U, 29},
	{1087487576U, 29},
	{1087487584U, 27},
	{1087487616U, 27},
	{1087487648U, 29},
	{1087487656U, 30},
	{1087487660U, 30},
	{1087487664U, 30},
	{1087487668U, 30},
	{1087487672U, 30},
	{1087487676U, 30},
	{1087487680U, 27},
	{1087487712U, 27},
	{1087487744U, 29},
	{1087487752U, 29},
	{1087487760U, 30},
	{1087487764U, 30},
	{1087487768U, 30},
	{1087487772U, 30},
	{1087487776U, 27},
	{1087487808U, 26},
	{1087487872U, 28},
	{1087487888U, 29},
	{1087487896U, 30},
	{1087487900U, 30},
	{1087487904U, 29},
	{1087487912U, 29},
	{1087487920U, 28},
	{1087487936U, 26},
	{1087488000U, 29},
	{1087488008U, 29},
	{1087488016U, 30},
	{1087488020U, 30},
	{1087488024U, 29},
	{1087488032U, 27},
	{1087488064U, 30},
	{1087488072U, 29},
	{1087488080U, 29},
	{1087488088U, 29},
	{1087488096U, 27},
	{1087488128U, 29},
	{1087488136U, 29},
	{1087488152U, 29},
	{1087488160U, 28},
	{1087488176U, 28},
	{1087488192U, 26},
	{1087488256U, 24},
	{1087488768U, 24},
	{1087489024U, 24},
	{1087489280U, 27},
	{1087489312U, 29},
	{1087489320U, 30},
	{1087489324U, 30},
	{1087489328U, 29},
	{1087489336U, 29},
	{1087489344U, 26},
	{1087489472U, 26},
	{1087489536U, 24},
	{1087489792U, 25},
	{1087489920U, 28},
	{1087489936U, 28},
	{1087489952U, 27},
	{1087489984U, 27},
	{1087490016U, 28},
	{1087490040U, 29},
	{1087490048U, 23},
	{1087490048U, 24},
	{1087490560U, 24},
	{1087490816U, 24},
	{1087491072U, 24},
	{1087491328U, 24},
	{1087491584U, 24},
	{1087491840U, 24},
	{1087492864U, 24},
	{1087493120U, 25},
	{1087493248U, 26},
	{1087493312U, 26},
	{1087493504U, 28},
	{1087493520U, 30},
	{1087493536U, 27},
	{1087493568U, 29},
	{1087493576U, 30},
	{1087493580U, 30},
	{1087493600U, 27},
	{1087493632U, 24},
	{1087493888U, 29},
	{1087493904U, 29},
	{1087493912U, 29},
	{1087493920U, 27},
	{1087493952U, 26},
	{1087494080U, 26},
	{1087494144U, 24},
	{1087494400U, 24},
	{1087494656U, 28},
	{1087494672U, 28},
	{1087494688U, 28},
	{1087494704U, 29},
	{1087494712U, 29},
	{1087494720U, 26},
	{1087494784U, 26},
	{1087494848U, 27},
	{1087494880U, 29},
	{1087494888U, 29},
	{1087494896U, 28},
	{1087495040U, 26},
	{1087495108U, 30},
	{1087495112U, 29},
	{1087495120U, 28},
	{1087495136U, 28},
	{1087495152U, 29},
	{1087495160U, 29},
	{1087495168U, 26},
	{1087495424U, 26},
	{1087495488U, 26},
	{1087495552U, 27},
	{1087495584U, 27},
	{1087495616U, 28},
	{1087495632U, 28},
	{1087495648U, 28},
	{1087495664U, 28},
	{1087495680U, 26},
	{1087495744U, 27},
	{1087495776U, 27},
	{1087495808U, 26},
	{1087495872U, 26},
	{1087495936U, 28},
	{1087495952U, 28},
	{1087495968U, 27},
	{1087496000U, 26},
	{1087496064U, 25},
	{1087496192U, 26},
	{1087496256U, 29},
	{1087496264U, 29},
	{1087496272U, 29},
	{1087496280U, 29},
	{1087496288U, 27},
	{1087496448U, 28},
	{1087496464U, 28},
	{1087496480U, 27},
	{1087496512U, 26},
	{1087496576U, 25},
	{1087497224U, 29},
	{1087497232U, 29},
	{1087497240U, 29},
	{1087497248U, 29},
	{1087497256U, 29},
	{1087497264U, 29},
	{1087497272U, 29},
	{1087497280U, 26},
	{1087497344U, 26},
	{1087497408U, 27},
	{1087497440U, 27},
	{1087497472U, 24},
	{1087497728U, 25},
	{1087497856U, 27},
	{1087497888U, 27},
	{1087497920U, 27},
	{1087497952U, 29},
	{1087497960U, 29},
	{1087497968U, 28},
	{1087497984U, 28},
	{1087498000U, 29},
	{1087498008U, 29},
	{1087498016U, 28},
	{1087498032U, 29},
	{1087498040U, 29},
	{1087498048U, 27},
	{1087498080U, 28},
	{1087498104U, 29},
	{1087498112U, 25},
	{1087498240U, 24},
	{1087498496U, 26},
	{1087498560U, 28},
	{1087498576U, 29},
	{1087498592U, 27},
	{1087498624U, 27},
	{1087498672U, 28},
	{1087498688U, 27},
	{1087498720U, 27},
	{1087498752U, 23},
	{1087499264U, 24},
	{1087499520U, 27},
	{1087499552U, 30},
	{1087499556U, 30},
	{1087499564U, 30},
	{1087499568U, 29},
	{1087499576U, 29},
	{1087499616U, 27},
	{1087499648U, 26},
	{1087499736U, 29},
	{1087499744U, 27},
	{1087499776U, 24},
	{1087500032U, 26},
	{1087500096U, 27},
	{1087500100U, 30},
	{1087500104U, 30},
	{1087500108U, 30},
	{1087500112U, 29},
	{1087500124U, 30},
	{1087500128U, 28},
	{1087500144U, 28},
	{1087500160U, 26},
	{1087500224U, 29},
	{1087500232U, 30},
	{1087500236U, 30},
	{1087500243U, 28},
	{1087500244U, 30},
	{1087500248U, 31},
	{1087500251U, 31},
	{1087500252U, 30},
	{1087500256U, 27},
	{1087523584U, 24},
	{1087527936U, 24},
	{1087545856U, 24},
	{1087546112U, 25},
	{1087546240U, 27},
	{1087546304U, 27},
	{1087546336U, 30},
	{1087546340U, 30},
	{1087546352U, 28},
	{1087546368U, 23},
	{1087546880U, 24},
	{1087547136U, 24},
	{1087547648U, 27},
	{1087547680U, 27},
	{1087547712U, 28},
	{1087547728U, 28},
	{1087547744U, 29},
	{1087547752U, 29},
	{1087547760U, 29},
	{1087547768U, 29},
	{1087547776U, 26},
	{1087547840U, 26},
	{1087547904U, 24},
	{1087548416U, 28},
	{1087548432U, 28},
	{1087548544U, 25},
	{1087548672U, 24},
	{1087548928U, 27},
	{1087548960U, 29},
	{1087548968U, 29},
	{1087548976U, 28},
	{1087548992U, 29},
	{1087549000U, 30},
	{1087549024U, 29},
	{1087549040U, 28},
	{1087549184U, 27},
	{1087549216U, 27},
	{1087549252U, 30},
	{1087549256U, 29},
	{1087549264U, 28},
	{1087549280U, 27},
	{1087549312U, 25},
	{1087549440U, 24},
	{1087549696U, 26},
	{1087549792U, 29},
	{1087549800U, 30},
	{1087549804U, 30},
	{1087549808U, 29},
	{1087549816U, 29},
	{1087549920U, 29},
	{1087549928U, 29},
	{1087549937U, 30},
	{1087549941U, 30},
	{1087549944U, 30},
	{1087549948U, 30},
	{1087550208U, 24},
	{1087550464U, 22},
	{1087551488U, 28},
	{1087551504U, 28},
	{1087551520U, 27},
	{1087551552U, 27},
	{1087551584U, 27},
	{1087551616U, 28},
	{1087551640U, 29},
	{1087551648U, 27},
	{1087551680U, 26},
	{1087551744U, 24},
	{1087552000U, 24},
	{1087552512U, 22},
	{1087553536U, 29},
	{1087553544U, 29},
	{1087553552U, 28},
	{1087553568U, 28},
	{1087553584U, 28},
	{1087553600U, 27},
	{1087553632U, 29},
	{1087553640U, 29},
	{1087553648U, 28},
	{1087553664U, 25},
	{1087553792U, 24},
	{1087554048U, 26},
	{1087554112U, 26},
	{1087554176U, 27},
	{1087554208U, 27},
	{1087554240U, 28},
	{1087554256U, 28},
	{1087554272U, 27},
	{1087554304U, 26},
	{1087554368U, 26},
	{1087554432U, 26},
	{1087554496U, 28},
	{1087554512U, 29},
	{1087554520U, 29},
	{1087554528U, 28},
	{1087554544U, 28},
	{1087554560U, 26},
	{1087554624U, 26},
	{1087554688U, 27},
	{1087554720U, 29},
	{1087554728U, 29},
	{1087554736U, 28},
	{1087554752U, 29},
	{1087554760U, 29},
	{1087554784U, 27},
	{1087554816U, 24},
	{1087555072U, 23},
	{1087555584U, 24},
	{1087555840U, 25},
	{1087555968U, 26},
	{1087556032U, 26},
	{1087556096U, 23},
	{1087556640U, 27},
	{1087556672U, 26},
	{1087556736U, 25},
	{1087556864U, 24},
	{1087557120U, 25},
	{1087557248U, 28},
	{1087557256U, 29},
	{1087557264U, 28},
	{1087557280U, 29},
	{1087557296U, 29},
	{1087557304U, 29},
	{1087557440U, 27},
	{1087557472U, 28},
	{1087557488U, 28},
	{1087557504U, 26},
	{1087557568U, 28},
	{1087557584U, 29},
	{1087557600U, 27},
	{1087557632U, 24},
	{1087557888U, 24},
	{1087558144U, 24},
	{1087558400U, 24},
	{1087558400U, 27},
	{1087561728U, 24},
	{1087561984U, 24},
	{1087562240U, 23},
	{1087562752U, 27},
	{1087562784U, 28},
	{1087562800U, 30},
	{1087562808U, 29},
	{1087562816U, 27},
	{1087562880U, 25},
	{1087563008U, 25},
	{1087563136U, 25},
	{1087563264U, 24},
	{1087563520U, 27},
	{1087563552U, 27},
	{1087563584U, 28},
	{1087563600U, 28},
	{1087563616U, 27},
	{1087563648U, 28},
	{1087563664U, 28},
	{1087563680U, 28},
	{1087563696U, 28},
	{1087563712U, 26},
	{1087565824U, 24},
	{1087566080U, 26},
	{1087566144U, 27},
	{1087566176U, 27},
	{1087566208U, 26},
	{1087566272U, 27},
	{1087566304U, 28},
	{1087566320U, 28},
	{1087566848U, 24},
	{1087567104U, 26},
	{1087567168U, 27},
	{1087567200U, 27},
	{1087567232U, 27},
	{1087567264U, 30},
	{1087567268U, 30},
	{1087567272U, 29},
	{1087567280U, 28},
	{1087567296U, 26},
	{1087567360U, 24},
	{1087567616U, 24},
	{1087567872U, 27},
	{1087567904U, 27},
	{1087567936U, 26},
	{1087568000U, 27},
	{1087568032U, 27},
	{1087568080U, 30},
	{1087568084U, 30},
	{1087568096U, 27},
	{1087568128U, 26},
	{1087568192U, 28},
	{1087568208U, 28},
	{1087568224U, 27},
	{1087568256U, 27},
	{1087568384U, 27},
	{1087568416U, 27},
	{1087568448U, 26},
	{1087568512U, 25},
	{1087606784U, 23},
	{1087617024U, 21},
	{1087619072U, 24},
	{1087619328U, 28},
	{1087619344U, 28},
	{1087619360U, 27},
	{1087619392U, 26},
	{1087627264U, 26},
	{1087627328U, 26},
	{1087627392U, 27},
	{1087627424U, 28},
	{1087627440U, 29},
	{1087627448U, 30},
	{1087627452U, 30},
	{1087627456U, 27},
	{1087627488U, 30},
	{1087627492U, 30},
	{1087627496U, 29},
	{1087627504U, 29},
	{1087627512U, 29},
	{1087627520U, 24},
	{1087627776U, 24},
	{1087628032U, 27},
	{1087628072U, 29},
	{1087628080U, 29},
	{1087628088U, 29},
	{1087628096U, 28},
	{1087628112U, 28},
	{1087628128U, 27},
	{1087628160U, 25},
	{1087628288U, 26},
	{1087628352U, 30},
	{1087628356U, 30},
	{1087628360U, 29},
	{1087628368U, 29},
	{1087628376U, 29},
	{1087628384U, 28},
	{1087628480U, 27},
	{1087628512U, 27},
	{1087628544U, 24},
	{1087628800U, 24},
	{1087629056U, 25},
	{1087629248U, 27},
	{1087629280U, 27},
	{1087629312U, 21},
	{1087631360U, 25},
	{1087631496U, 29},
	{1087631504U, 28},
	{1087631552U, 27},
	{1087631584U, 27},
	{1087631616U, 24},
	{1087631872U, 27},
	{1087631904U, 27},
	{1087631936U, 28},
	{1087631952U, 28},
	{1087631968U, 27},
	{1087632000U, 25},
	{1087632384U, 24},
	{1087632640U, 25},
	{1087632768U, 27},
	{1087632800U, 28},
	{1087632816U, 28},
	{1087632832U, 28},
	{1087632848U, 29},
	{1087632896U, 24},
	{1087633184U, 28},
	{1087633200U, 28},
	{1087633216U, 26},
	{1087633280U, 27},
	{1087633312U, 27},
	{1087633344U, 29},
	{1087633352U, 29},
	{1087633360U, 28},
	{1087633376U, 28},
	{1087633392U, 28},
	{1087633408U, 24},
	{1087633664U, 27},
	{1087633696U, 28},
	{1087633712U, 28},
	{1087633728U, 27},
	{1087633792U, 25},
	{1087633920U, 24},
	{1087634176U, 24},
	{1087634432U, 28},
	{1087634456U, 29},
	{1087634464U, 27},
	{1087634496U, 26},
	{1087634560U, 28},
	{1087634576U, 28},
	{1087634592U, 29},
	{1087634600U, 29},
	{1087634608U, 28},
	{1087634624U, 27},
	{1087634656U, 28},
	{1087634688U, 24},
	{1087634944U, 23},
	{1087637504U, 21},
	{1087641864U, 29},
	{1087674368U, 24},
	{1087677760U, 30},
	{1087677764U, 30},
	{1087677768U, 30},
	{1087677772U, 30},
	{1087678976U, 24},
	{1087679232U, 24},
	{1087720448U, 22},
	{1087734272U, 24},
	{1087734656U, 25},
	{1087922176U, 20},
	{1087942656U, 20},
	{1087963136U, 19},
	{1087968000U, 24},
	{1087971328U, 20},
	{1087987712U, 20},
	{1088073728U, 20},
	{1088081920U, 20},
	{1088102400U, 20},
	{1088159744U, 15},
	{1088211200U, 24},
	{1088268288U, 21},
	{1088278272U, 24},
	{1088278528U, 22},
	{1088279552U, 23},
	{1088280064U, 23},
	{1088280576U, 23},
	{1088281088U, 23},
	{1088281600U, 23},
	{1088282112U, 23},
	{1088282368U, 24},
	{1088282624U, 22},
	{1088283648U, 23},
	{1088284672U, 23},
	{1088284672U, 24},
	{1088285184U, 23},
	{1088285696U, 23},
	{1088286208U, 23},
	{1088286720U, 23},
	{1088287232U, 23},
	{1088287744U, 23},
	{1088288768U, 22},
	{1088289792U, 22},
	{1089208320U, 16},
	{1089484544U, 24},
	{1089488128U, 24},
	{1089494272U, 24},
	{1089496576U, 23},
	{1089552384U, 24},
	{1089611776U, 24},
	{1089612032U, 24},
	{1089638400U, 24},
	{1089665536U, 23},
	{1089696768U, 22},
	{1089696768U, 24},
	{1089726464U, 22},
	{1089762048U, 24},
	{1089763328U, 21},
	{1089765376U, 22},
	{1089810432U, 20},
	{1089815552U, 22},
	{1089822720U, 21},
	{1089826816U, 20},
	{1089855488U, 21},
	{1090158592U, 18},
	{1090199552U, 20},
	{1090215936U, 20},
	{1090256896U, 16},
	{1090306048U, 19},
	{1090330624U, 20},
	{1090330624U, 22},
	{1090331648U, 23},
	{1090332160U, 23},
	{1090332672U, 21},
	{1090347008U, 20},
	{1090363392U, 20},
	{1090379776U, 20},
	{1090382080U, 24},
	{1090396160U, 20},
	{1090412544U, 20},
	{1090412544U, 24},
	{1090412800U, 24},
	{1090413056U, 24},
	{1090413312U, 24},
	{1090413568U, 24},
	{1090413824U, 24},
	{1090414080U, 24},
	{1090414336U, 24},
	{1090414848U, 24},
	{1090420736U, 20},
	{1090428928U, 20},
	{1090429184U, 24},
	{1090429440U, 24},
	{1090429696U, 24},
	{1090429952U, 24},
	{1090430208U, 24},
	{1090430464U, 24},
	{1090432000U, 23},
	{1091829760U, 15},
	{1091928064U, 19},
	{1092091904U, 17},
	{1092124672U, 18},
	{1092141056U, 18},
	{1092157440U, 17},
	{1092190208U, 19},
	{1092198400U, 19},
	{1092206592U, 18},
	{1092222976U, 17},
	{1092255744U, 20},
	{1092259840U, 20},
	{1092263936U, 20},
	{1092268032U, 20},
	{1092272128U, 18},
	{1092288512U, 17},
	{1092321280U, 17},
	{1092354048U, 14},
	{1092354048U, 17},
	{1092386816U, 20},
	{1092390912U, 20},
	{1092395008U, 19},
	{1092403200U, 19},
	{1092411392U, 19},
	{1092419584U, 18},
	{1092435968U, 19},
	{1092444160U, 19},
	{1092452352U, 18},
	{1092468736U, 19},
	{1092476928U, 19},
	{1092485120U, 18},
	{1092534272U, 18},
	{1092616192U, 17},
	{1092648960U, 18},
	{1092665344U, 18},
	{1092681728U, 17},
	{1092714496U, 18},
	{1092730880U, 18},
	{1092747264U, 20},
	{1092751360U, 20},
	{1092755456U, 20},
	{1092759552U, 20},
	{1092763648U, 18},
	{1092780032U, 18},
	{1092796416U, 18},
	{1092812800U, 18},
	{1092829184U, 19},
	{1093468160U, 16},
	{1093468160U, 17},
	{1093500928U, 18},
	{1093500928U, 21},
	{1094115328U, 19},
	{1094721536U, 19},
	{1094729728U, 20},
	{1094733824U, 20},
	{1094758400U, 20},
	{1094787072U, 20},
	{1094836224U, 20},
	{1094844416U, 19},
	{1094926336U, 20},
	{1094959104U, 19},
	{1094971392U, 20},
	{1095000064U, 20},
	{1095016448U, 20},
	{1095098368U, 20},
	{1095499776U, 16},
	{1096286208U, 15},
	{1096288512U, 24},
	{1096288768U, 23},
	{1096291840U, 24},
	{1096306688U, 22},
	{1096307712U, 22},
	{1096308736U, 22},
	{1096310784U, 20},
	{1096314880U, 22},
	{1096315904U, 22},
	{1096331264U, 20},
	{1096335360U, 21},
	{1096337408U, 22},
	{1096338432U, 23},
	{1096338944U, 24},
	{1096339200U, 25},
	{1096341504U, 22},
	{1096343808U, 24},
	{1096347648U, 20},
	{1096353024U, 24},
	{1096359936U, 21},
	{1096361984U, 22},
	{1096363008U, 22},
	{1096364032U, 21},
	{1096366080U, 22},
	{1096367104U, 22},
	{1096372224U, 20},
	{1096376320U, 20},
	{1096384512U, 22},
	{1096408064U, 22},
	{1096810496U, 19},
	{1096818688U, 19},
	{1096826880U, 18},
	{1096843264U, 17},
	{1097334784U, 14},
	{1097335296U, 23},
	{1097335808U, 23},
	{1097336320U, 23},
	{1097350144U, 22},
	{1097439232U, 23},
	{1097439488U, 24},
	{1097439744U, 23},
	{1097440256U, 23},
	{1097440768U, 23},
	{1097441792U, 23},
	{1097442304U, 23},
	{1097442816U, 23},
	{1097443328U, 23},
	{1097443840U, 24},
	{1097444096U, 24},
	{1097444352U, 23},
	{1097444864U, 23},
	{1097444864U, 24},
	{1097445376U, 22},
	{1097446144U, 24},
	{1097446400U, 23},
	{1097446912U, 23},
	{1097447936U, 23},
	{1097448448U, 23},
	{1097448960U, 23},
	{1097449216U, 24},
	{1097449472U, 22},
	{1097450496U, 22},
	{1097451008U, 24},
	{1097451520U, 22},
	{1097452544U, 22},
	{1097453568U, 23},
	{1097454080U, 23},
	{1097455616U, 22},
	{1097456128U, 24},
	{1097457152U, 23},
	{1097457664U, 21},
	{1097458432U, 24},
	{1097459712U, 23},
	{1097460224U, 23},
	{1097460736U, 22},
	{1097460736U, 24},
	{1097461760U, 23},
	{1097462272U, 23},
	{1097462784U, 22},
	{1097463808U, 23},
	{1097464832U, 23},
	{1097465344U, 23},
	{1097472000U, 23},
	{1097480192U, 21},
	{1097486336U, 22},
	{1097487360U, 23},
	{1097492480U, 22},
	{1097494528U, 22},
	{1097502720U, 22},
	{1097505280U, 23},
	{1097506816U, 22},
	{1097525248U, 22},
	{1097526272U, 23},
	{1097596928U, 16},
	{1097859072U, 20},
	{1097983232U, 24},
	{1101020416U, 24},
	{1101049856U, 20},
	{1101062144U, 20},
	{1101073408U, 23},
	{1101081344U, 24},
	{1101101568U, 23},
	{1101226496U, 23},
	{1101330688U, 24},
	{1101402112U, 24},
	{1101435648U, 24},
	{1101457664U, 24},
	{1103110144U, 24},
	{1103111168U, 23},
	{1103123968U, 24},
	{1103172352U, 24},
	{1103212544U, 21},
	{1103280128U, 22},
	{1103291904U, 23},
	{1103292416U, 22},
	{1103300864U, 24},
	{1103301632U, 24},
	{1103303168U, 23},
	{1103351808U, 24},
	{1103352320U, 24},
	{1103352576U, 24},
	{1103352832U, 24},
	{1103353088U, 24},
	{1103353344U, 24},
	{1103380992U, 23},
	{1103452928U, 24},
	{1103474944U, 24},
	{1103494656U, 24},
	{1103528960U, 23},
	{1103529984U, 23},
	{1103545856U, 24},
	{1103564800U, 24},
	{1103565056U, 24},
	{1103565312U, 24},
	{1103565568U, 24},
	{1103571968U, 24},
	{1103597824U, 24},
	{1103598592U, 24},
	{1103598848U, 24},
	{1103615232U, 24},
	{1103666432U, 24},
	{1103694848U, 22},
	{1103726080U, 24},
	{1103764992U, 24},
	{1103833856U, 24},
	{1103908864U, 24},
	{1103971584U, 24},
	{1103990016U, 24},
	{1103994880U, 22},
	{1107419136U, 20},
	{1107427328U, 17},
	{1107460096U, 18},
	{1107492864U, 17},
	{1107501056U, 20},
	{1107525632U, 18},
	{1107542016U, 18},
	{1107558400U, 17},
	{1107591168U, 17},
	{1107623936U, 17},
	{1107656704U, 17},
	{1107689472U, 20},
	{1107714048U, 19},
	{1107730432U, 20},
	{1107730432U, 23},
	{1107731200U, 24},
	{1107731456U, 24},
	{1107731712U, 24},
	{1107732480U, 23},
	{1107738624U, 20},
	{1107755008U, 19},
	{1107791360U, 24},
	{1107791872U, 24},
	{1107792128U, 24},
	{1107793920U, 24},
	{1107795968U, 24},
	{1107803904U, 24},
	{1107853312U, 19},
	{1107861504U, 20},
	{1107865600U, 20},
	{1107869696U, 20},
	{1107873792U, 20},
	{1107877888U, 20},
	{1107881984U, 20},
	{1108410368U, 18},
	{1108410368U, 19},
	{1108418560U, 19},
	{1108475904U, 20},
	{1108476160U, 24},
	{1108476416U, 24},
	{1108476672U, 24},
	{1108479488U, 24},
	{1108479744U, 24},
	{1108541440U, 18},
	{1108869120U, 18},
	{1108885504U, 18},
	{1108901888U, 19},
	{1108910080U, 20},
	{1108914176U, 20},
	{1108918272U, 19},
	{1108926464U, 19},
	{1108934656U, 18},
	{1108951040U, 19},
	{1108959232U, 19},
	{1108967424U, 17},
	{1109000192U, 20},
	{1109004288U, 20},
	{1109008384U, 19},
	{1109016576U, 19},
	{1109024768U, 20},
	{1109028864U, 20},
	{1109032960U, 19},
	{1109041152U, 20},
	{1109045248U, 20},
	{1109049344U, 19},
	{1109057536U, 19},
	{1109065728U, 20},
	{1109069824U, 20},
	{1109073920U, 20},
	{1109078016U, 20},
	{1109082112U, 18},
	{1109098496U, 19},
	{1109106688U, 19},
	{1109114880U, 19},
	{1109123072U, 20},
	{1109127168U, 20},
	{1109131264U, 19},
	{1109135104U, 24},
	{1109262336U, 19},
	{1109270528U, 20},
	{1109274624U, 20},
	{1109278720U, 18},
	{1109295104U, 18},
	{1109311488U, 18},
	{1109327872U, 16},
	{1109394432U, 22},
	{1109458944U, 17},
	{1109491712U, 19},
	{1109606400U, 19},
	{1109607424U, 22},
	{1109608448U, 23},
	{1109609984U, 24},
	{1109614336U, 24},
	{1109639168U, 18},
	{1109640704U, 23},
	{1109642728U, 30},
	{1109643520U, 24},
	{1109646848U, 24},
	{1109661696U, 21},
	{1109663744U, 21},
	{1109737472U, 20},
	{1109745664U, 20},
	{1109753856U, 20},
	{1109762048U, 20},
	{1109765120U, 24},
	{1109770240U, 19},
	{1109786624U, 20},
	{1109786624U, 24},
	{1109786880U, 24},
	{1109787136U, 24},
	{1109787392U, 24},
	{1109787648U, 22},
	{1109788672U, 22},
	{1109788672U, 24},
	{1109788928U, 24},
	{1109789184U, 24},
	{1109789440U, 24},
	{1109789696U, 22},
	{1109789696U, 24},
	{1109789952U, 24},
	{1109790208U, 24},
	{1109790464U, 24},
	{1109790720U, 20},
	{1109790720U, 22},
	{1109791744U, 22},
	{1109791744U, 24},
	{1109792000U, 24},
	{1109792256U, 24},
	{1109792512U, 24},
	{1109792768U, 22},
	{1109792768U, 24},
	{1109793024U, 24},
	{1109793280U, 24},
	{1109793536U, 24},
	{1109793792U, 22},
	{1109793792U, 24},
	{1109794048U, 24},
	{1109794304U, 24},
	{1109794560U, 24},
	{1109794816U, 20},
	{1109794816U, 21},
	{1109794816U, 22},
	{1109795840U, 24},
	{1109796352U, 24},
	{1109796608U, 24},
	{1109796864U, 22},
	{1109796864U, 24},
	{1109797120U, 24},
	{1109797376U, 24},
	{1109797632U, 24},
	{1109797888U, 22},
	{1109797888U, 24},
	{1109798144U, 24},
	{1109798400U, 24},
	{1109798656U, 24},
	{1109798912U, 20},
	{1109798912U, 22},
	{1109798912U, 24},
	{1109799424U, 24},
	{1109802752U, 24},
	{1109830400U, 24},
	{1109917696U, 18},
	{1109934080U, 19},
	{1109938176U, 20},
	{1109942272U, 21},
	{1109944320U, 21},
	{1109946368U, 20},
	{1109983232U, 19},
	{1109991424U, 19},
	{1109999616U, 20},
	{1110003712U, 20},
	{1110007808U, 19},
	{1110016000U, 20},
	{1110114304U, 20},
	{1110163456U, 18},
	{1110179840U, 17},
	{1110245376U, 20},
	{1110245376U, 23},
	{1110245888U, 23},
	{1110247680U, 24},
	{1110247936U, 23},
	{1110248448U, 24},
	{1110248704U, 24},
	{1110248960U, 24},
	{1110249472U, 20},
	{1110250496U, 22},
	{1110252032U, 24},
	{1110253568U, 20},
	{1110386688U, 22},
	{1110413312U, 22},
	{1110640384U, 24},
	{1110640640U, 24},
	{1110640896U, 24},
	{1110641152U, 24},
	{1110641408U, 24},
	{1110641664U, 24},
	{1110641920U, 24},
	{1110644736U, 23},
	{1110645248U, 23},
	{1110645760U, 24},
	{1110646016U, 24},
	{1110654976U, 20},
	{1110671360U, 20},
	{1110835200U, 18},
	{1110835200U, 22},
	{1110836224U, 22},
	{1110837248U, 22},
	{1110839296U, 22},
	{1110840320U, 22},
	{1110843392U, 22},
	{1110847488U, 22},
	{1110874624U, 24},
	{1110874880U, 24},
	{1110886400U, 21},
	{1110966272U, 18},
	{1110982656U, 19},
	{1110990848U, 20},
	{1110994944U, 20},
	{1110999040U, 19},
	{1111007232U, 19},
	{1111015424U, 19},
	{1111023616U, 19},
	{1111031808U, 19},
	{1111040000U, 20},
	{1111044096U, 20},
	{1111097344U, 17},
	{1111098368U, 24},
	{1111099392U, 24},
	{1111100416U, 24},
	{1111101440U, 23},
	{1111101952U, 24},
	{1111102464U, 23},
	{1111102976U, 23},
	{1111103488U, 24},
	{1111111680U, 24},
	{1111126016U, 21},
	{1111293952U, 20},
	{1111298048U, 20},
	{1111302144U, 19},
	{1111310336U, 18},
	{1111310336U, 19},
	{1111556096U, 18},
	{1111572480U, 19},
	{1111580672U, 20},
	{1111584768U, 20},
	{1111621632U, 18},
	{1111638016U, 18},
	{1111654400U, 18},
	{1111670784U, 18},
	{1111687168U, 19},
	{1111695360U, 20},
	{1111699456U, 20},
	{1111703552U, 18},
	{1111752704U, 17},
	{1111785472U, 18},
	{1111883776U, 18},
	{1111982080U, 18},
	{1112145920U, 18},
	{1112162304U, 19},
	{1112170496U, 20},
	{1112174592U, 20},
	{1112178688U, 18},
	{1112195072U, 19},
	{1112203264U, 20},
	{1112207360U, 20},
	{1112299520U, 21},
	{1112301568U, 21},
	{1112303616U, 21},
	{1112408064U, 18},
	{1112477696U, 21},
	{1112507392U, 24},
	{1112507648U, 24},
	{1112539136U, 20},
	{1112547328U, 19},
	{1112604672U, 17},
	{1112670208U, 19},
	{1113006080U, 20},
	{1113063424U, 15},
	{1113073152U, 23},
	{1113088000U, 22},
	{1113089024U, 23},
	{1113096192U, 21},
	{1113098240U, 22},
	{1113099264U, 23},
	{1113099776U, 23},
	{1113104384U, 22},
	{1113111552U, 23},
	{1113134080U, 22},
	{1113141248U, 23},
	{1113141760U, 23},
	{1113146368U, 22},
	{1113147392U, 23},
	{1113147904U, 24},
	{1113149440U, 23},
	{1113153536U, 23},
	{1113154048U, 23},
	{1113154560U, 22},
	{1113155584U, 23},
	{1113156096U, 23},
	{1113156608U, 23},
	{1113157120U, 23},
	{1113157632U, 22},
	{1113159680U, 23},
	{1113160192U, 23},
	{1113163776U, 23},
	{1113164288U, 23},
	{1113164800U, 22},
	{1113170432U, 23},
	{1113177088U, 22},
	{1113182208U, 23},
	{1113185280U, 23},
	{1113187584U, 24},
	{1113260032U, 18},
	{1113325568U, 19},
	{1113333760U, 19},
	{1113341952U, 19},
	{1113350144U, 19},
	{1113358336U, 20},
	{1113362432U, 20},
	{1113604096U, 20},
	{1113784320U, 17},
	{1114177536U, 17},
	{1114210304U, 18},
	{1114374144U, 17},
	{1114791936U, 20},
	{1115308032U, 20},
	{2147614720U, 16},
	{2147680256U, 16},
	{2147745792U, 16},
	{2147876864U, 16},
	{2148073472U, 16},
	{2148466688U, 16},
	{2148990976U, 16},
	{2149908480U, 16},
	{2149974016U, 16},
	{2150236160U, 16},
	{2150563840U, 16},
	{2150694912U, 16},
	{2151088128U, 16},
	{2151153664U, 16},
	{2151350272U, 16},
	{2151415808U, 16},
	{2151612416U, 16},
	{2152923136U, 16},
	{2152988672U, 16},
	{2153250816U, 16},
	{2153644032U, 16},
	{2153709568U, 16},
	{2153971712U, 16},
	{2154102784U, 16},
	{2154233856U, 16},
	{2154299392U, 16},
	{2154305792U, 24},
	{2154306560U, 23},
	{2154364928U, 16},
	{2154496000U, 16},
	{2154823680U, 16},
	{2154889216U, 16},
	{2155020288U, 16},
	{2155085824U, 16},
	{2155151360U, 16},
	{2155216896U, 16},
	{2155413504U, 16},
	{2155479040U, 16},
	{2155675648U, 16},
	{2155937792U, 16},
	{2156134400U, 16},
	{2156265472U, 16},
	{2156274944U, 24},
	{2156275200U, 24},
	{2156275456U, 24},
	{2156284672U, 24},
	{2156284928U, 24},
	{2156287232U, 24},
	{2156287488U, 24},
	{2156287744U, 24},
	{2156288000U, 24},
	{2156288256U, 24},
	{2156288512U, 24},
	{2156288768U, 24},
	{2156289024U, 24},
	{2156289280U, 24},
	{2156289536U, 24},
	{2156297984U, 24},
	{2156300032U, 24},
	{2156303360U, 24},
	{2156303616U, 24},
	{2156303872U, 24},
	{2156304128U, 24},
	{2156304896U, 24},
	{2156331008U, 16},
	{2156527616U, 16},
	{2157051904U, 16},
	{2157117440U, 16},
	{2157248512U, 16},
	{2157379584U, 16},
	{2157445120U, 16},
	{2157510656U, 16},
	{2157707264U, 16},
	{2157969408U, 16},
	{2158100480U, 16},
	{2158231552U, 16},
	{2158297088U, 16},
	{2158886912U, 16},
	{2158952448U, 16},
	{2159083520U, 16},
	{2159136768U, 20},
	{2159146496U, 24},
	{2159147008U, 24},
	{2159411200U, 16},
	{2159427584U, 18},
	{2159935488U, 16},
	{2159976704U, 26},
	{2160459776U, 16},
	{2160918528U, 16},
	{2160984064U, 16},
	{2161115136U, 16},
	{2161147904U, 19},
	{2161180672U, 16},
	{2161442816U, 16},
	{2161836032U, 16},
	{2161901568U, 16},
	{2162294784U, 16},
	{2162425856U, 16},
	{2162556928U, 16},
	{2163015680U, 16},
	{2163081216U, 16},
	{2163277824U, 16},
	{2163297280U, 22},
	{2163343360U, 16},
	{2163380736U, 23},
	{2163381248U, 22},
	{2163382272U, 21},
	{2163392512U, 18},
	{2163605504U, 16},
	{2163606528U, 23},
	{2163607040U, 24},
	{2163607296U, 24},
	{2163736576U, 16},
	{2163802112U, 16},
	{2163998720U, 16},
	{2164064256U, 16},
	{2164195328U, 16},
	{2164326400U, 16},
	{2164457472U, 16},
	{2164523008U, 16},
	{2164719616U, 16},
	{2164850688U, 16},
	{2165243904U, 16},
	{2165374976U, 16},
	{2165637120U, 16},
	{2165702656U, 16},
	{2166161408U, 16},
	{2166226944U, 16},
	{2166423552U, 16},
	{2166423552U, 19},
	{2166431744U, 19},
	{2166439936U, 19},
	{2166448128U, 19},
	{2166456320U, 19},
	{2166480896U, 20},
	{2166554624U, 16},
	{2166556160U, 24},
	{2166564864U, 21},
	{2166571008U, 22},
	{2166571264U, 24},
	{2166572032U, 22},
	{2166573056U, 22},
	{2166574080U, 22},
	{2166579200U, 20},
	{2166587392U, 20},
	{2166595584U, 20},
	{2166595584U, 22},
	{2166597632U, 22},
	{2166603776U, 21},
	{2166611968U, 21},
	{2166614016U, 22},
	{2166685696U, 16},
	{2166956032U, 20},
	{2166964224U, 20},
	{2166969344U, 24},
	{2166972416U, 19},
	{2167013376U, 16},
	{2167013376U, 24},
	{2167013632U, 24},
	{2167013888U, 24},
	{2167014144U, 24},
	{2167014400U, 24},
	{2167014656U, 24},
	{2167014912U, 24},
	{2167015168U, 24},
	{2167015424U, 24},
	{2167015680U, 24},
	{2167015936U, 24},
	{2167016192U, 24},
	{2167016960U, 24},
	{2167017216U, 24},
	{2167017472U, 24},
	{2167017728U, 24},
	{2167017984U, 24},
	{2167018240U, 24},
	{2167018496U, 24},
	{2167018752U, 24},
	{2167019008U, 24},
	{2167019264U, 24},
	{2167019520U, 24},
	{2167021568U, 24},
	{2167021824U, 24},
	{2167022080U, 24},
	{2167022336U, 24},
	{2167022592U, 24},
	{2167022848U, 24},
	{2167023104U, 24},
	{2167023360U, 24},
	{2167023616U, 24},
	{2167023872U, 24},
	{2167024128U, 24},
	{2167024384U, 24},
	{2167024640U, 24},
	{2167024896U, 24},
	{2167025152U, 24},
	{2167025408U, 24},
	{2167025664U, 24},
	{2167026176U, 24},
	{2167026688U, 24},
	{2167026944U, 24},
	{2167027200U, 24},
	{2167027712U, 24},
	{2167027968U, 24},
	{2167029248U, 24},
	{2167029504U, 24},
	{2167074816U, 24},
	{2167075072U, 24},
	{2167075328U, 24},
	{2167075584U, 24},
	{2167075840U, 24},
	{2167076352U, 24},
	{2167275520U, 16},
	{2167406592U, 16},
	{2167472128U, 16},
	{2167996416U, 16},
	{2168193024U, 16},
	{2168258560U, 16},
	{2168324096U, 16},
	{2168979456U, 16},
	{2169044992U, 16},
	{2169438208U, 16},
	{2169569280U, 16},
	{2169634816U, 16},
	{2169831424U, 16},
	{2170290176U, 16},
	{2170355712U, 16},
	{2170486784U, 16},
	{2170683392U, 16},
	{2170880000U, 16},
	{2171142144U, 16},
	{2171207680U, 16},
	{2171863040U, 16},
	{2171994112U, 16},
	{2172387328U, 16},
	{2172846080U, 16},
	{2173239296U, 16},
	{2173370368U, 16},
	{2174877696U, 16},
	{2175533056U, 16},
	{2175991808U, 16},
	{2176450560U, 16},
	{2176712704U, 16},
	{2176909312U, 16},
	{2177105920U, 16},
	{2177171456U, 16},
	{2177236992U, 16},
	{2177368064U, 16},
	{2177826816U, 16},
	{2178154496U, 16},
	{2178547712U, 16},
	{2178913280U, 22},
	{2178914304U, 24},
	{2178914560U, 24},
	{2178915072U, 24},
	{2179137536U, 16},
	{2179268608U, 16},
	{2179661824U, 16},
	{2179727360U, 16},
	{2179858432U, 16},
	{2179923968U, 16},
	{2180251648U, 16},
	{2180382720U, 16},
	{2180384256U, 24},
	{2180513792U, 16},
	{2180644864U, 16},
	{2180775936U, 16},
	{2180841472U, 16},
	{2180907008U, 16},
	{2180972544U, 16},
	{2181758976U, 16},
	{2182348800U, 16},
	{2182807552U, 16},
	{2182938624U, 16},
	{2183004160U, 16},
	{2183266304U, 16},
	{2183528448U, 16},
	{2183921664U, 16},
	{2184052736U, 16},
	{2184249344U, 16},
	{2184249344U, 17},
	{2184312320U, 23},
	{2184314880U, 16},
	{2184511488U, 16},
	{2184577024U, 16},
	{2184773632U, 16},
	{2185560064U, 16},
	{2185691136U, 16},
	{2186084352U, 16},
	{2186280960U, 16},
	{2186739712U, 16},
	{2187198464U, 16},
	{2187526144U, 16},
	{2187657216U, 16},
	{2187853824U, 16},
	{2188050432U, 16},
	{2188115968U, 16},
	{2188181504U, 16},
	{2188509184U, 16},
	{2188771328U, 16},
	{2189295616U, 16},
	{2189361152U, 16},
	{2189492224U, 16},
	{2190999552U, 16},
	{2191065088U, 16},
	{2191185408U, 24},
	{2191185664U, 24},
	{2191392768U, 16},
	{2191654912U, 16},
	{2191720448U, 16},
	{2191785984U, 16},
	{2191822592U, 24},
	{2191828480U, 24},
	{2191828992U, 24},
	{2191830784U, 24},
	{2191851008U, 24},
	{2194079744U, 16},
	{2194276352U, 16},
	{2194341888U, 16},
	{2194472960U, 16},
	{2195193856U, 16},
	{2195521536U, 16},
	{2195718144U, 16},
	{2197094400U, 16},
	{2197618688U, 16},
	{2200174592U, 16},
	{2200305664U, 16},
	{2200895488U, 16},
	{2201026560U, 16},
	{2202468352U, 16},
	{2203451648U, 24},
	{2203844608U, 16},
	{2203910144U, 16},
	{2204368896U, 16},
	{2204565504U, 16},
	{2204827648U, 16},
	{2205155328U, 16},
	{2205220864U, 16},
	{2205679616U, 16},
	{2205745152U, 16},
	{2205810688U, 16},
	{2205876224U, 16},
	{2207121408U, 16},
	{2207711232U, 16},
	{2208038912U, 16},
	{2208380416U, 24},
	{2208417792U, 21},
	{2208417792U, 22},
	{2208419840U, 20},
	{2208422144U, 24},
	{2208759808U, 16},
	{2208993280U, 23},
	{2209480704U, 16},
	{2209808384U, 16},
	{2209873920U, 16},
	{2210070528U, 16},
	{2210463744U, 16},
	{2210988032U, 16},
	{2211315712U, 16},
	{2211708928U, 16},
	{2211840000U, 16},
	{2211905536U, 16},
	{2212102144U, 16},
	{2212364288U, 16},
	{2212560896U, 16},
	{2212888576U, 16},
	{2212945920U, 20},
	{2213412864U, 16},
	{2213478400U, 16},
	{2213740544U, 16},
	{2213806080U, 15},
	{2214068224U, 16},
	{2214133760U, 16},
	{2214199296U, 16},
	{2215575552U, 16},
	{2215641088U, 16},
	{2215903232U, 16},
	{2217541632U, 16},
	{2218590208U, 16},
	{2224160768U, 16},
	{2224488448U, 16},
	{2224488448U, 18},
	{2224504832U, 24},
	{2224685056U, 16},
	{2225143808U, 16},
	{2225209344U, 16},
	{2225274880U, 16},
	{2226061312U, 16},
	{2226323456U, 16},
	{2226585600U, 16},
	{2226913280U, 19},
	{2226978816U, 16},
	{2227306496U, 16},
	{2227699712U, 16},
	{2229141504U, 16},
	{2229403648U, 16},
	{2229534720U, 16},
	{2229993472U, 16},
	{2230059008U, 16},
	{2230255616U, 16},
	{2230779904U, 16},
	{2230845440U, 16},
	{2230910976U, 16},
	{2230976512U, 16},
	{2231238656U, 16},
	{2231238656U, 19},
	{2231250944U, 21},
	{2231252992U, 21},
	{2231255040U, 20},
	{2231259136U, 21},
	{2231261184U, 21},
	{2231263232U, 21},
	{2231267328U, 21},
	{2231269376U, 21},
	{2231271424U, 21},
	{2231275520U, 21},
	{2231287808U, 19},
	{2231287808U, 20},
	{2231296000U, 19},
	{2231298048U, 24},
	{2231435264U, 16},
	{2231500800U, 16},
	{2231566336U, 16},
	{2231697408U, 16},
	{2231762944U, 16},
	{2231828480U, 16},
	{2231894016U, 16},
	{2231959552U, 16},
	{2232025088U, 16},
	{2232090624U, 16},
	{2232156160U, 16},
	{2232221696U, 16},
	{2232287232U, 16},
	{2232352768U, 16},
	{2232418304U, 16},
	{2232483840U, 16},
	{2232549376U, 16},
	{2232614912U, 16},
	{2232680448U, 16},
	{2232745984U, 16},
	{2232877056U, 16},
	{2232942592U, 16},
	{2233008128U, 16},
	{2233073664U, 16},
	{2233139200U, 16},
	{2233204736U, 16},
	{2233270272U, 16},
	{2233335808U, 16},
	{2233401344U, 16},
	{2233466880U, 16},
	{2233532416U, 16},
	{2233597952U, 16},
	{2233663488U, 16},
	{2233729024U, 16},
	{2233794560U, 16},
	{2233860096U, 16},
	{2233925632U, 16},
	{2233991168U, 16},
	{2234056704U, 16},
	{2234122240U, 16},
	{2234187776U, 16},
	{2234253312U, 16},
	{2234318848U, 16},
	{2234384384U, 16},
	{2234449920U, 16},
	{2234515456U, 16},
	{2234580992U, 16},
	{2234646528U, 16},
	{2234712064U, 16},
	{2234777600U, 16},
	{2234843136U, 16},
	{2234908672U, 16},
	{2234974208U, 16},
	{2235105280U, 16},
	{2235170816U, 16},
	{2235236352U, 16},
	{2235301888U, 16},
	{2235432960U, 16},
	{2235498496U, 16},
	{2235564032U, 16},
	{2235629568U, 16},
	{2235695104U, 16},
	{2235760640U, 16},
	{2235826176U, 16},
	{2235891712U, 16},
	{2235957248U, 16},
	{2236022784U, 16},
	{2236153856U, 16},
	{2236219392U, 16},
	{2236284928U, 16},
	{2236416000U, 16},
	{2236481536U, 16},
	{2236547072U, 16},
	{2236612608U, 16},
	{2236678144U, 16},
	{2236743680U, 16},
	{2236809216U, 16},
	{2236940288U, 16},
	{2237005824U, 16},
	{2237071360U, 16},
	{2237136896U, 16},
	{2237202432U, 16},
	{2237333504U, 16},
	{2237399040U, 16},
	{2237530112U, 16},
	{2237595648U, 16},
	{2237661184U, 16},
	{2237726720U, 16},
	{2237792256U, 16},
	{2237857792U, 16},
	{2237923328U, 16},
	{2237988864U, 16},
	{2238054400U, 16},
	{2238185472U, 16},
	{2238251008U, 16},
	{2238316544U, 16},
	{2238513152U, 16},
	{2238644224U, 16},
	{2239299584U, 16},
	{2239430656U, 16},
	{2239627264U, 16},
	{2239692800U, 16},
	{2239889408U, 16},
	{2240348160U, 16},
	{2240413696U, 16},
	{2240806912U, 16},
	{2240872448U, 16},
	{2240937984U, 16},
	{2241331200U, 16},
	{2241658880U, 16},
	{2242052096U, 16},
	{2242117632U, 16},
	{2242445312U, 16},
	{2242510848U, 16},
	{2242707456U, 16},
	{2242838528U, 16},
	{2242904064U, 16},
	{2243559424U, 16},
	{2243624960U, 16},
	{2243690496U, 16},
	{2243756032U, 16},
	{2243952640U, 16},
	{2244083712U, 16},
	{2244149248U, 16},
	{2244804608U, 16},
	{2245132288U, 16},
	{2245591040U, 16},
	{2245787648U, 16},
	{2245853184U, 16},
	{2246180864U, 16},
	{2246770688U, 16},
	{2246836224U, 16},
	{2246901760U, 16},
	{2246967296U, 16},
	{2247098368U, 16},
	{2247294976U, 16},
	{2247426048U, 16},
	{2247688192U, 16},
	{2247753728U, 16},
	{2248015872U, 16},
	{2248409088U, 16},
	{2248474624U, 16},
	{2248672512U, 24},
	{2248736768U, 16},
	{2248802304U, 16},
	{2248998912U, 16},
	{2249129984U, 16},
	{2249326592U, 16},
	{2249457664U, 16},
	{2249719808U, 16},
	{2249745408U, 24},
	{2249751296U, 24},
	{2249751808U, 24},
	{2249758976U, 24},
	{2250047488U, 16},
	{2250702848U, 16},
	{2250768384U, 16},
	{2250967552U, 23},
	{2250968064U, 24},
	{2250980608U, 24},
	{2250990848U, 24},
	{2251358208U, 16},
	{2251375616U, 22},
	{2251376640U, 22},
	{2251390976U, 21},
	{2251393024U, 21},
	{2251620352U, 16},
	{2251685888U, 16},
	{2251751424U, 16},
	{2251882496U, 16},
	{2251948032U, 16},
	{2252406784U, 16},
	{2252734464U, 16},
	{2252996608U, 16},
	{2253062144U, 16},
	{2253065216U, 24},
	{2253066752U, 24},
	{2253067264U, 24},
	{2253093376U, 24},
	{2253105920U, 24},
	{2253106176U, 24},
	{2253108224U, 24},
	{2253112320U, 24},
	{2253112576U, 24},
	{2253117696U, 24},
	{2253120000U, 24},
	{2253258752U, 16},
	{2253324288U, 16},
	{2253520896U, 16},
	{2253651968U, 16},
	{2256011264U, 16},
	{2256076800U, 16},
	{2256273408U, 16},
	{2256338944U, 16},
	{2256732160U, 16},
	{2257125376U, 16},
	{2257387520U, 16},
	{2257449472U, 24},
	{2258632704U, 16},
	{2258698240U, 16},
	{2258894848U, 16},
	{2259091456U, 16},
	{2259419136U, 16},
	{2259550208U, 16},
	{2259943424U, 16},
	{2260008960U, 16},
	{2260205568U, 16},
	{2260795392U, 16},
	{2260860928U, 16},
	{2261319680U, 16},
	{2261712896U, 16},
	{2261778432U, 16},
	{2261909504U, 16},
	{2262368256U, 16},
	{2263285760U, 16},
	{2263678976U, 16},
	{2263744512U, 16},
	{2263810048U, 16},
	{2263875584U, 16},
	{2263941120U, 16},
	{2263941120U, 17},
	{2263973888U, 17},
	{2264072192U, 16},
	{2264334336U, 16},
	{2264662016U, 16},
	{2264727552U, 16},
	{2264924160U, 13},
	{2265710592U, 14},
	{2266038272U, 16},
	{2266103808U, 16},
	{2266365952U, 15},
	{2266497024U, 16},
	{2267283456U, 16},
	{2267414528U, 15},
	{2268397568U, 16},
	{2269907200U, 24},
	{2270429184U, 14},
	{2270691328U, 16},
	{2270953472U, 15},
	{2271674368U, 16},
	{2271739904U, 16},
	{2271936512U, 16},
	{2272067584U, 16},
	{2272198656U, 16},
	{2272264192U, 16},
	{2272395264U, 15},
	{2272526336U, 14},
	{2272788480U, 15},
	{2274099200U, 15},
	{2274230272U, 16},
	{2274426880U, 16},
	{2274689024U, 16},
	{2275082240U, 16},
	{2275147776U, 16},
	{2276130816U, 16},
	{2276720640U, 16},
	{2276786176U, 16},
	{2276917248U, 16},
	{2277048320U, 16},
	{2277834752U, 16},
	{2278424576U, 16},
	{2278621184U, 16},
	{2278948864U, 16},
	{2279079936U, 16},
	{2279211008U, 16},
	{2280652800U, 12},
	{2281308160U, 16},
	{2281766912U, 16},
	{2281832448U, 16},
	{2290941952U, 16},
	{2291007488U, 16},
	{2291532288U, 24},
	{2291532800U, 24},
	{2291542016U, 24},
	{2291543296U, 24},
	{2291543552U, 24},
	{2291547136U, 24},
	{2291557376U, 24},
	{2291557888U, 24},
	{2291793920U, 16},
	{2292645888U, 16},
	{2293170176U, 16},
	{2293235712U, 16},
	{2293301248U, 16},
	{2293563392U, 16},
	{2293694464U, 16},
	{2293760000U, 16},
	{2293956608U, 16},
	{2295070720U, 16},
	{2295136256U, 16},
	{2296316160U, 24},
	{2296316416U, 23},
	{2296316928U, 22},
	{2296317952U, 21},
	{2296320000U, 24},
	{2296320256U, 24},
	{2296320512U, 24},
	{2296324096U, 24},
	{2296340480U, 24},
	{2296340736U, 24},
	{2296381440U, 16},
	{2296381440U, 18},
	{2296397824U, 19},
	{2296406016U, 19},
	{2296413184U, 23},
	{2296414208U, 18},
	{2296430592U, 19},
	{2296438784U, 19},
	{2296512512U, 16},
	{2296578048U, 16},
	{2296709120U, 16},
	{2297036800U, 16},
	{2297233408U, 16},
	{2297888768U, 16},
	{2297954304U, 16},
	{2299527168U, 16},
	{2299854848U, 16},
	{2299920384U, 16},
	{2300051456U, 16},
	{2300575744U, 16},
	{2300903424U, 16},
	{2300968960U, 16},
	{2301689856U, 16},
	{2301952000U, 16},
	{2302738432U, 16},
	{2302869504U, 16},
	{2302935040U, 16},
	{2303066112U, 16},
	{2303524864U, 16},
	{2303590400U, 16},
	{2303655936U, 16},
	{2303721472U, 16},
	{2305228800U, 16},
	{2305622016U, 16},
	{2305687552U, 16},
	{2305798656U, 23},
	{2305818624U, 16},
	{2306539520U, 16},
	{2306605056U, 16},
	{2306670592U, 16},
	{2306867200U, 16},
	{2307063808U, 16},
	{2307129344U, 16},
	{2307588096U, 16},
	{2307653632U, 16},
	{2307653888U, 24},
	{2307654400U, 24},
	{2307655424U, 24},
	{2307655680U, 24},
	{2307655936U, 24},
	{2307656192U, 24},
	{2307656448U, 24},
	{2307658240U, 24},
	{2307658496U, 24},
	{2307658752U, 24},
	{2307659264U, 24},
	{2307659520U, 24},
	{2307661312U, 24},
	{2307661568U, 24},
	{2307661824U, 24},
	{2307662080U, 24},
	{2307662336U, 24},
	{2307662592U, 24},
	{2307662848U, 24},
	{2307663104U, 24},
	{2307663360U, 24},
	{2307663616U, 24},
	{2307663872U, 24},
	{2307664128U, 24},
	{2307664384U, 24},
	{2307664640U, 24},
	{2307664896U, 24},
	{2307665152U, 24},
	{2307665408U, 24},
	{2307665664U, 24},
	{2307665920U, 24},
	{2307667968U, 21},
	{2307670016U, 24},
	{2307678976U, 24},
	{2307679232U, 24},
	{2307704832U, 24},
	{2307719168U, 16},
	{2307784704U, 16},
	{2307825664U, 19},
	{2307850240U, 16},
	{2307883008U, 17},
	{2308177920U, 16},
	{2308898816U, 16},
	{2308964352U, 16},
	{2309554176U, 16},
	{2309574656U, 24},
	{2309574912U, 24},
	{2309591040U, 20},
	{2309619712U, 16},
	{2311061504U, 16},
	{2312503296U, 15},
	{2312634368U, 16},
	{2313355264U, 16},
	{2313420800U, 16},
	{2313486336U, 16},
	{2313551872U, 16},
	{2314600448U, 16},
	{2314665984U, 16},
	{2314993664U, 16},
	{2315583488U, 16},
	{2316042240U, 16},
	{2316472320U, 24},
	{2316943360U, 22},
	{2317090816U, 16},
	{2317156352U, 16},
	{2317811712U, 16},
	{2318270464U, 16},
	{2318401536U, 16},
	{2319187968U, 16},
	{2319646720U, 16},
	{2319843328U, 16},
	{2319974400U, 16},
	{2320171008U, 16},
	{2320760832U, 16},
	{2320957440U, 16},
	{2321285120U, 16},
	{2321874944U, 16},
	{2322268160U, 16},
	{2322857984U, 16},
	{2323447808U, 16},
	{2323578880U, 16},
	{2323709952U, 16},
	{2323906560U, 16},
	{2326003712U, 16},
	{2326265856U, 16},
	{2327248896U, 17},
	{2327314432U, 16},
	{2327642112U, 16},
	{2327838720U, 16},
	{2328231936U, 16},
	{2330263552U, 16},
	{2330329088U, 16},
	{2330591232U, 16},
	{2330787840U, 16},
	{2331443200U, 16},
	{2332164096U, 16},
	{2333802496U, 16},
	{2333868032U, 16},
	{2335113216U, 16},
	{2335506432U, 16},
	{2335723520U, 24},
	{2336096256U, 16},
	{2336292864U, 16},
	{2336423936U, 16},
	{2336489472U, 16},
	{2337144832U, 16},
	{2337275904U, 16},
	{2337538048U, 16},
	{2337734656U, 16},
	{2337800192U, 16},
	{2338062336U, 16},
	{2338127872U, 16},
	{2338717696U, 16},
	{2340651008U, 18},
	{2340667392U, 19},
	{2341470208U, 16},
	{2341994496U, 16},
	{2342846464U, 16},
	{2343239680U, 16},
	{2343239680U, 19},
	{2343245824U, 21},
	{2343501824U, 16},
	{2343501824U, 18},
	{2343501824U, 19},
	{2343516416U, 24},
	{2343518208U, 18},
	{2343522048U, 24},
	{2343534592U, 18},
	{2343545088U, 24},
	{2343548928U, 21},
	{2343550976U, 18},
	{2343829504U, 16},
	{2347176192U, 24},
	{2350841856U, 18},
	{2350907392U, 16},
	{2351759360U, 16},
	{2354446336U, 16},
	{2354577408U, 16},
	{2354642944U, 16},
	{2354839552U, 16},
	{2355036160U, 16},
	{2355101696U, 16},
	{2355298304U, 16},
	{2355299840U, 24},
	{2355322880U, 21},
	{2355363840U, 16},
	{2355363840U, 17},
	{2355364864U, 24},
	{2355366912U, 24},
	{2355396608U, 18},
	{2355412992U, 18},
	{2355560448U, 16},
	{2355757056U, 16},
	{2355822592U, 16},
	{2355953664U, 16},
	{2356019200U, 15},
	{2356150272U, 16},
	{2356215808U, 16},
	{2356281344U, 15},
	{2356412416U, 14},
	{2356674560U, 14},
	{2356936704U, 15},
	{2357067776U, 16},
	{2357133312U, 16},
	{2357198848U, 13},
	{2357723136U, 15},
	{2357854208U, 16},
	{2357919744U, 16},
	{2357985280U, 16},
	{2358050816U, 16},
	{2358116352U, 16},
	{2358312960U, 16},
	{2358838528U, 25},
	{2358842624U, 25},
	{2358862592U, 25},
	{2358864640U, 25},
	{2359104000U, 23},
	{2359109120U, 23},
	{2359109632U, 23},
	{2359110144U, 23},
	{2359110656U, 23},
	{2359111680U, 23},
	{2359112704U, 23},
	{2359296000U, 16},
	{2359492608U, 16},
	{2360016896U, 16},
	{2360082432U, 16},
	{2360213504U, 16},
	{2360240384U, 24},
	{2360344576U, 16},
	{2360475648U, 16},
	{2360606720U, 16},
	{2360737792U, 16},
	{2360803328U, 16},
	{2360999936U, 16},
	{2361011712U, 24},
	{2361017856U, 24},
	{2361036800U, 24},
	{2361040896U, 22},
	{2361311232U, 18},
	{2361589760U, 16},
	{2361655296U, 16},
	{2362189824U, 22},
	{2362202880U, 24},
	{2362241024U, 21},
	{2362441728U, 16},
	{2362507264U, 16},
	{2362703872U, 16},
	{2362755072U, 22},
	{2362755328U, 24},
	{2362755584U, 24},
	{2362756096U, 23},
	{2362756096U, 24},
	{2362756352U, 24},
	{2362834944U, 15},
	{2362966016U, 14},
	{2363228160U, 16},
	{2363293696U, 16},
	{2363555840U, 16},
	{2363621376U, 16},
	{2363752448U, 16},
	{2363817984U, 16},
	{2364350464U, 19},
	{2364518656U, 24},
	{2364528128U, 24},
	{2364997632U, 16},
	{2365259776U, 16},
	{2365456384U, 16},
	{2371616768U, 16},
	{2371682304U, 16},
	{2372272128U, 16},
	{2372796416U, 16},
	{2372861952U, 16},
	{2373517312U, 16},
	{2373582848U, 16},
	{2374041600U, 16},
	{2374696960U, 16},
	{2374762496U, 16},
	{2374828032U, 16},
	{2374893568U, 16},
	{2376073216U, 16},
	{2376925184U, 16},
	{2377121792U, 16},
	{2377252864U, 16},
	{2377318400U, 16},
	{2377580544U, 16},
	{2377646080U, 16},
	{2377842688U, 16},
	{2377973760U, 16},
	{2378039296U, 16},
	{2378499072U, 23},
	{2378500096U, 23},
	{2378563584U, 16},
	{2378694656U, 16},
	{2378956800U, 16},
	{2379022336U, 16},
	{2379284480U, 16},
	{2379350016U, 16},
	{2379415552U, 16},
	{2379481088U, 16},
	{2379546624U, 16},
	{2379612160U, 16},
	{2379743232U, 16},
	{2379808768U, 16},
	{2379874304U, 16},
	{2379939840U, 16},
	{2380070912U, 16},
	{2380136448U, 16},
	{2380201984U, 16},
	{2380201984U, 18},
	{2380218368U, 18},
	{2380234752U, 18},
	{2380251136U, 18},
	{2380267520U, 16},
	{2381053952U, 16},
	{2381185024U, 16},
	{2381197312U, 20},
	{2381201408U, 20},
	{2381205504U, 20},
	{2381209600U, 19},
	{2381316096U, 16},
	{2381447168U, 16},
	{2381709312U, 16},
	{2381840384U, 16},
	{2382233600U, 16},
	{2387279872U, 16},
	{2387542016U, 16},
	{2391801856U, 16},
	{2392514560U, 19},
	{2394998784U, 24},
	{2395537408U, 16},
	{2395833344U, 23},
	{2395834880U, 23},
	{2401959936U, 16},
	{2401988608U, 20},
	{2402009088U, 18},
	{2402091008U, 16},
	{2402156544U, 16},
	{2402287616U, 16},
	{2402746368U, 16},
	{2402779136U, 17},
	{2402811904U, 16},
	{2402989056U, 22},
	{2403139584U, 16},
	{2403149312U, 24},
	{2403178752U, 24},
	{2403179008U, 24},
	{2403179520U, 24},
	{2403199232U, 24},
	{2403205120U, 16},
	{2403467264U, 16},
	{2403532800U, 16},
	{2404188160U, 16},
	{2404739840U, 25},
	{2405636096U, 24},
	{2406023168U, 16},
	{2406350848U, 16},
	{2406416384U, 16},
	{2406547456U, 16},
	{2406678528U, 16},
	{2406719488U, 19},
	{2406744064U, 16},
	{2406940672U, 16},
	{2407333888U, 16},
	{2407467008U, 22},
	{2407530496U, 16},
	{2407596032U, 16},
	{2408185856U, 16},
	{2409914368U, 22},
	{2410020864U, 16},
	{2410217472U, 16},
	{2410676224U, 14},
	{2410840064U, 19},
	{2410841600U, 24},
	{2411659264U, 16},
	{2411724800U, 16},
	{2411921408U, 16},
	{2412052480U, 16},
	{2412642304U, 16},
	{2412707840U, 16},
	{2413363200U, 16},
	{2413953024U, 16},
	{2414149632U, 16},
	{2415067136U, 16},
	{2415132672U, 16},
	{2415263744U, 16},
	{2415329280U, 16},
	{2415394816U, 16},
	{2416115712U, 16},
	{2416640000U, 16},
	{2416902144U, 16},
	{2416965888U, 24},
	{2416966656U, 24},
	{2417098752U, 16},
	{2418147328U, 16},
	{2418868224U, 16},
	{2418999296U, 16},
	{2419195904U, 16},
	{2419720192U, 16},
	{2419785728U, 16},
	{2420768768U, 16},
	{2421161984U, 16},
	{2421177344U, 22},
	{2421185536U, 22},
	{2421227520U, 16},
	{2421555200U, 16},
	{2421948416U, 16},
	{2422012204U, 30},
	{2422145024U, 16},
	{2422210560U, 16},
	{2423717888U, 16},
	{2426798080U, 16},
	{2426994688U, 16},
	{2427191296U, 16},
	{2428829696U, 16},
	{2428895232U, 16},
	{2428953088U, 24},
	{2428960768U, 16},
	{2429878272U, 16},
	{2430009344U, 16},
	{2432106496U, 16},
	{2432161792U, 21},
	{2432163840U, 21},
	{2432167936U, 20},
	{2432172032U, 16},
	{2432434176U, 16},
	{2432565248U, 16},
	{2433155072U, 16},
	{2433220608U, 16},
	{2433351680U, 16},
	{2436169728U, 16},
	{2436694016U, 16},
	{2436825088U, 16},
	{2437021696U, 16},
	{2437218304U, 16},
	{2437768960U, 24},
	{2447376384U, 16},
	{2447441664U, 24},
	{2447493888U, 24},
	{2447494144U, 24},
	{2447704064U, 16},
	{2447900672U, 16},
	{2449866752U, 16},
	{2449932288U, 16},
	{2450063360U, 16},
	{2450653184U, 16},
	{2450784256U, 16},
	{2450788608U, 24},
	{2450788864U, 23},
	{2453209088U, 16},
	{2453667840U, 16},
	{2453929984U, 16},
	{2454454272U, 16},
	{2454585344U, 16},
	{2454650880U, 16},
	{2454913024U, 16},
	{2454978560U, 16},
	{2455044096U, 16},
	{2455699456U, 16},
	{2455764992U, 16},
	{2455961600U, 16},
	{2456223744U, 16},
	{2456748032U, 16},
	{2456879104U, 16},
	{2457010176U, 16},
	{2457034752U, 22},
	{2457468928U, 16},
	{2457731072U, 16},
	{2457731584U, 24},
	{2457744128U, 24},
	{2457746688U, 24},
	{2457749760U, 24},
	{2457753088U, 24},
	{2457753600U, 24},
	{2457927680U, 16},
	{2458124288U, 16},
	{2458189824U, 16},
	{2458247168U, 19},
	{2458451968U, 16},
	{2458583040U, 16},
	{2458714112U, 16},
	{2459303936U, 16},
	{2459369472U, 16},
	{2459435008U, 16},
	{2459500544U, 16},
	{2459631616U, 16},
	{2459762688U, 16},
	{2460155904U, 16},
	{2460418048U, 16},
	{2460680192U, 16},
	{2460942336U, 16},
	{2461152000U, 24},
	{2461335552U, 16},
	{2461401088U, 16},
	{2461663232U, 16},
	{2461728768U, 16},
	{2462318592U, 16},
	{2462777344U, 16},
	{2462803968U, 24},
	{2463105024U, 16},
	{2463211520U, 19},
	{2463580160U, 24},
	{2463580416U, 24},
	{2463580672U, 24},
	{2463694848U, 16},
	{2463760384U, 16},
	{2463948800U, 20},
	{2464030720U, 24},
	{2464030976U, 24},
	{2464031232U, 24},
	{2464062464U, 23},
	{2464062976U, 24},
	{2464069888U, 24},
	{2464070144U, 24},
	{2464070400U, 24},
	{2464070656U, 24},
	{2464072192U, 24},
	{2464072448U, 24},
	{2464072704U, 24},
	{2464072960U, 24},
	{2464082176U, 24},
	{2464088064U, 16},
	{2464219136U, 16},
	{2464546816U, 16},
	{2464612352U, 16},
	{2464874496U, 18},
	{2464890880U, 18},
	{2464907264U, 18},
	{2465529856U, 16},
	{2465595392U, 16},
	{2466381824U, 16},
	{2466512896U, 16},
	{2466538752U, 24},
	{2466643968U, 16},
	{2466840576U, 16},
	{2467299328U, 16},
	{2467364864U, 16},
	{2467627008U, 16},
	{2467823616U, 16},
	{2467889152U, 16},
	{2468085760U, 16},
	{2468282368U, 16},
	{2469068800U, 16},
	{2469265408U, 16},
	{2469724160U, 16},
	{2469855232U, 16},
	{2469920768U, 16},
	{2470445056U, 16},
	{2470969344U, 16},
	{2471362560U, 16},
	{2471428096U, 16},
	{2471493632U, 16},
	{2472280064U, 16},
	{2473197568U, 16},
	{2474115072U, 16},
	{2474639360U, 16},
	{2474639360U, 18},
	{2474656768U, 22},
	{2474663936U, 19},
	{2474672128U, 17},
	{2474704896U, 16},
	{2475098112U, 16},
	{2475229184U, 16},
	{2475294720U, 16},
	{2475425792U, 16},
	{2475884544U, 16},
	{2475950080U, 14},
	{2476277760U, 16},
	{2476343296U, 16},
	{2476408832U, 16},
	{2476539904U, 16},
	{2477916160U, 16},
	{2477981696U, 16},
	{2478178304U, 16},
	{2478768128U, 16},
	{2479489024U, 16},
	{2479685632U, 16},
	{2480799744U, 16},
	{2481061888U, 16},
	{2481153024U, 24},
	{2481651712U, 16},
	{2481842176U, 24},
	{2482110464U, 16},
	{2482569216U, 16},
	{2482831360U, 16},
	{2483290112U, 16},
	{2486632448U, 16},
	{2486697984U, 16},
	{2486894592U, 16},
	{2487025664U, 16},
	{2487615488U, 16},
	{2487681024U, 16},
	{2487877632U, 16},
	{2487943168U, 16},
	{2488008704U, 16},
	{2488074240U, 16},
	{2488203776U, 24},
	{2488204032U, 24},
	{2488204288U, 24},
	{2488204544U, 24},
	{2488204800U, 24},
	{2488532992U, 16},
	{2488729600U, 19},
	{2488925184U, 24},
	{2488925440U, 24},
	{2488925696U, 24},
	{2489581568U, 16},
	{2490040320U, 16},
	{2490040320U, 19},
	{2490040576U, 24},
	{2490041088U, 24},
	{2490041344U, 24},
	{2490041600U, 24},
	{2490041856U, 24},
	{2490042112U, 24},
	{2490042368U, 24},
	{2490042624U, 24},
	{2490042880U, 24},
	{2490043136U, 24},
	{2490043904U, 24},
	{2490564608U, 16},
	{2490630144U, 16},
	{2491285504U, 16},
	{2491547648U, 16},
	{2491744256U, 16},
	{2492006400U, 16},
	{2492596224U, 16},
	{2492792832U, 16},
	{2493120512U, 16},
	{2493710336U, 16},
	{2494038016U, 16},
	{2494046208U, 19},
	{2494062592U, 19},
	{2494562304U, 16},
	{2494627840U, 16},
	{2494627840U, 21},
	{2494660608U, 21},
	{2494958592U, 22},
	{2495021056U, 16},
	{2496069632U, 16},
	{2496200704U, 16},
	{2496331776U, 16},
	{2496381952U, 24},
	{2496397312U, 16},
	{2496462848U, 16},
	{2496692224U, 17},
	{2496708352U, 24},
	{2496724992U, 16},
	{2497052672U, 16},
	{2497118208U, 16},
	{2497183744U, 16},
	{2497314816U, 16},
	{2497380352U, 16},
	{2497445888U, 16},
	{2497511424U, 16},
	{2497511424U, 19},
	{2497519616U, 19},
	{2497527808U, 19},
	{2497536000U, 19},
	{2497544192U, 18},
	{2497560576U, 18},
	{2497642496U, 16},
	{2497642496U, 18},
	{2497658880U, 19},
	{2497667072U, 20},
	{2497671168U, 20},
	{2497675264U, 18},
	{2497691648U, 19},
	{2497699840U, 19},
	{2497709568U, 24},
	{2497773568U, 16},
	{2497839104U, 16},
	{2498101248U, 16},
	{2498166784U, 16},
	{2498297856U, 16},
	{2498297856U, 19},
	{2498306048U, 19},
	{2498314240U, 19},
	{2498322432U, 19},
	{2498330624U, 18},
	{2498347008U, 18},
	{2498363392U, 16},
	{2498428928U, 16},
	{2498428928U, 19},
	{2498437120U, 19},
	{2498445312U, 19},
	{2498453504U, 19},
	{2498461696U, 18},
	{2498478080U, 18},
	{2498494464U, 16},
	{2498560000U, 16},
	{2498691072U, 16},
	{2498822144U, 16},
	{2498822144U, 17},
	{2498969600U, 20},
	{2499018752U, 16},
	{2499018752U, 18},
	{2499280896U, 16},
	{2499346432U, 16},
	{2499941888U, 24},
	{2499943424U, 24},
	{2499943680U, 24},
	{2499944448U, 21},
	{2499967232U, 24},
	{2499967488U, 24},
	{2499967744U, 24},
	{2500788224U, 16},
	{2501312512U, 16},
	{2501640192U, 16},
	{2501640192U, 20},
	{2501836800U, 16},
	{2502623232U, 16},
	{2502819840U, 24},
	{2503344128U, 16},
	{2503606272U, 16},
	{2503933952U, 16},
	{2503999488U, 16},
	{2504065024U, 16},
	{2504261632U, 16},
	{2504327168U, 16},
	{2504392704U, 16},
	{2504523776U, 16},
	{2504531968U, 19},
	{2504720384U, 16},
	{2504851456U, 16},
	{2505113600U, 16},
	{2505310208U, 16},
	{2505637888U, 16},
	{2506096640U, 16},
	{2506686464U, 16},
	{2507086592U, 24},
	{2507091968U, 24},
	{2507603968U, 16},
	{2507866112U, 16},
	{2507931136U, 24},
	{2507997184U, 16},
	{2508587008U, 16},
	{2509176832U, 16},
	{2509307904U, 16},
	{2510159872U, 16},
	{2510225408U, 16},
	{2510553088U, 16},
	{2511077376U, 16},
	{2511077376U, 17},
	{2511110144U, 17},
	{2511115776U, 24},
	{2511142912U, 16},
	{2511208448U, 16},
	{2512781312U, 16},
	{2512846848U, 16},
	{2513305600U, 16},
	{2513633280U, 16},
	{2513829888U, 16},
	{2514288640U, 16},
	{2514419712U, 16},
	{2514440960U, 24},
	{2514441216U, 24},
	{2514445312U, 22},
	{2514446336U, 22},
	{2514447360U, 23},
	{2514454016U, 24},
	{2514455552U, 24},
	{2514457088U, 24},
	{2514464512U, 24},
	{2515009536U, 16},
	{2515271680U, 16},
	{2515719168U, 24},
	{2515795968U, 16},
	{2517041152U, 16},
	{2517172224U, 16},
	{2517368832U, 16},
	{2517565440U, 16},
	{2517762048U, 16},
	{2517827584U, 16},
	{2518024192U, 16},
	{2518155264U, 16},
	{2518286336U, 16},
	{2518351872U, 16},
	{2518482944U, 16},
	{2518548480U, 16},
	{2518614016U, 16},
	{2518679552U, 16},
	{2519072768U, 16},
	{2519334912U, 16},
	{2519400448U, 16},
	{2519597056U, 16},
	{2519662592U, 16},
	{2519728128U, 16},
	{2519789568U, 23},
	{2519790336U, 24},
	{2519793664U, 16},
	{2519990272U, 16},
	{2520121344U, 16},
	{2520186880U, 16},
	{2520317952U, 16},
	{2520449024U, 16},
	{2520580096U, 16},
	{2520711168U, 16},
	{2520776704U, 16},
	{2520842240U, 16},
	{2520973312U, 16},
	{2521104384U, 16},
	{2521169920U, 16},
	{2521235456U, 16},
	{2521956352U, 16},
	{2522021888U, 16},
	{2522087424U, 16},
	{2522218496U, 16},
	{2522284032U, 16},
	{2522415104U, 16},
	{2522480640U, 16},
	{2522546176U, 16},
	{2522873856U, 16},
	{2522939392U, 16},
	{2523070464U, 16},
	{2523136000U, 16},
	{2523220224U, 24},
	{2523234304U, 20},
	{2523238400U, 20},
	{2523262976U, 22},
	{2523463680U, 16},
	{2523467776U, 20},
	{2523471872U, 20},
	{2523922432U, 16},
	{2525167616U, 16},
	{2525298688U, 16},
	{2525364224U, 16},
	{2525560832U, 16},
	{2525888512U, 16},
	{2525954048U, 16},
	{2526216192U, 16},
	{2526412800U, 16},
	{2526740480U, 16},
	{2526806016U, 16},
	{2527526912U, 16},
	{2528575488U, 16},
	{2528576000U, 24},
	{2528578048U, 24},
	{2528599040U, 24},
	{2528706560U, 16},
	{2528727040U, 20},
	{2528739328U, 18},
	{2528772096U, 16},
	{2528780288U, 19},
	{2528837632U, 16},
	{2528845312U, 23},
	{2528845824U, 22},
	{2528903168U, 16},
	{2528968704U, 16},
	{2529624064U, 16},
	{2529689600U, 16},
	{2529755136U, 16},
	{2530279424U, 16},
	{2530344960U, 16},
	{2530672640U, 16},
	{2531000320U, 16},
	{2531065856U, 16},
	{2531097088U, 24},
	{2531524608U, 16},
	{2531721216U, 16},
	{2531786752U, 16},
	{2532507648U, 16},
	{2532966400U, 16},
	{2533163008U, 16},
	{2533425152U, 16},
	{2533490688U, 16},
	{2538930176U, 16},
	{2538995712U, 16},
	{2539061248U, 16},
	{2539192320U, 16},
	{2539651072U, 16},
	{2540621312U, 24},
	{2540634112U, 16},
	{2540765184U, 16},
	{2541223936U, 16},
	{2541486080U, 16},
	{2541617152U, 16},
	{2542534656U, 16},
	{2542665728U, 16},
	{2542714880U, 19},
	{2542862336U, 16},
	{2543058944U, 16},
	{2543386624U, 16},
	{2543517696U, 16},
	{2543779840U, 16},
	{2543910912U, 16},
	{2544041984U, 16},
	{2544042496U, 24},
	{2544056320U, 24},
	{2544056576U, 24},
	{2544113408U, 24},
	{2544124672U, 24},
	{2544124928U, 23},
	{2544128512U, 23},
	{2544129792U, 24},
	{2544130048U, 24},
	{2544150784U, 24},
	{2544151040U, 23},
	{2544151552U, 23},
	{2544152064U, 24},
	{2544160768U, 22},
	{2544166400U, 24},
	{2544166656U, 24},
	{2544166912U, 24},
	{2545549312U, 16},
	{2546008064U, 16},
	{2546139136U, 16},
	{2547122176U, 16},
	{2547253248U, 16},
	{2554134528U, 16},
	{2554527744U, 16},
	{2554554880U, 24},
	{2554555648U, 24},
	{2554584064U, 22},
	{2554585088U, 23},
	{2554585600U, 24},
	{2554986496U, 16},
	{2555052032U, 16},
	{2555117568U, 16},
	{2555379712U, 16},
	{2555707392U, 16},
	{2555772928U, 16},
	{2555838464U, 16},
	{2556624896U, 16},
	{2557149184U, 16},
	{2557345792U, 16},
	{2557411328U, 16},
	{2557476864U, 16},
	{2557542400U, 16},
	{2557607936U, 16},
	{2557870080U, 16},
	{2558747648U, 22},
	{2558748672U, 24},
	{2558750208U, 23},
	{2558750720U, 23},
	{2558751232U, 24},
	{2558984192U, 16},
	{2559115264U, 16},
	{2559311872U, 16},
	{2559418624U, 24},
	{2559442944U, 16},
	{2559901696U, 16},
	{2559927296U, 22},
	{2559928320U, 21},
	{2559930368U, 20},
	{2559934464U, 23},
	{2560425984U, 16},
	{2560491520U, 16},
	{2560532480U, 19},
	{2560540672U, 18},
	{2560622592U, 16},
	{2560635904U, 24},
	{2560819200U, 16},
	{2560819200U, 20},
	{2564947968U, 16},
	{2565079040U, 16},
	{2567045120U, 16},
	{2567103488U, 24},
	{2567103744U, 24},
	{2567104000U, 24},
	{2567104256U, 24},
	{2567108352U, 24},
	{2567176192U, 16},
	{2567503872U, 16},
	{2567569408U, 16},
	{2567634944U, 16},
	{2568224768U, 16},
	{2569076736U, 16},
	{2569863168U, 16},
	{2569928704U, 16},
	{2572812288U, 16},
	{2572877824U, 16},
	{2573139968U, 16},
	{2573664256U, 16},
	{2573795328U, 16},
	{2573860864U, 16},
	{2574188544U, 16},
	{2583822336U, 16},
	{2583826944U, 24},
	{2600796160U, 16},
	{2600861696U, 16},
	{2601385984U, 16},
	{2602762240U, 16},
	{2602827776U, 16},
	{2603614208U, 16},
	{2603876352U, 16},
	{2603941888U, 16},
	{2604335104U, 16},
	{2604335616U, 24},
	{2604335872U, 24},
	{2604336128U, 24},
	{2604400640U, 16},
	{2604597248U, 16},
	{2604859392U, 16},
	{2604990464U, 16},
	{2604997632U, 22},
	{2604999680U, 24},
	{2605006848U, 19},
	{2605187072U, 16},
	{2606432256U, 16},
	{2606432768U, 24},
	{2606433280U, 24},
	{2606433792U, 24},
	{2606434304U, 24},
	{2606436352U, 24},
	{2606436608U, 24},
	{2606628864U, 16},
	{2606655488U, 21},
	{2606694400U, 16},
	{2607153152U, 16},
	{2607415296U, 16},
	{2609053696U, 16},
	{2609053696U, 19},
	{2609078272U, 19},
	{2609435904U, 24},
	{2609437440U, 24},
	{2609437696U, 24},
	{2609438720U, 23},
	{2609439232U, 24},
	{2609512448U, 16},
	{2609577984U, 16},
	{2609709056U, 16},
	{2610102272U, 16},
	{2610167808U, 16},
	{2610460672U, 21},
	{2610757632U, 16},
	{2610888704U, 16},
	{2611019776U, 16},
	{2611085312U, 16},
	{2611150848U, 16},
	{2611216384U, 16},
	{2611281920U, 16},
	{2611347456U, 16},
	{2611412992U, 16},
	{2611478528U, 16},
	{2611544064U, 16},
	{2611609600U, 16},
	{2611871744U, 16},
	{2612002816U, 16},
	{2612112896U, 24},
	{2613051392U, 16},
	{2613051392U, 17},
	{2613092352U, 19},
	{2613108736U, 19},
	{2613641216U, 16},
	{2613650176U, 24},
	{2613650432U, 24},
	{2613657344U, 24},
	{2613676800U, 24},
	{2613702656U, 24},
	{2613702912U, 24},
	{2613703168U, 24},
	{2613703424U, 24},
	{2613703680U, 24},
	{2613703936U, 24},
	{2613704192U, 24},
	{2613706752U, 16},
	{2613771776U, 24},
	{2614099968U, 16},
	{2614296576U, 16},
	{2614325248U, 24},
	{2614329344U, 24},
	{2614360832U, 24},
	{2614362112U, 16},
	{2614427648U, 16},
	{2614755328U, 16},
	{2615214080U, 16},
	{2615476224U, 16},
	{2615491072U, 23},
	{2615498496U, 24},
	{2615498752U, 24},
	{2615531264U, 24},
	{2615541760U, 16},
	{2615672832U, 16},
	{2615803904U, 16},
	{2615895808U, 24},
	{2616000512U, 16},
	{2616066048U, 16},
	{2616131584U, 16},
	{2616197120U, 16},
	{2616459264U, 16},
	{2616852480U, 16},
	{2616983552U, 16},
	{2616983552U, 24},
	{2616983808U, 24},
	{2616984064U, 24},
	{2616987648U, 20},
	{2616999936U, 21},
	{2617001984U, 21},
	{2617004032U, 21},
	{2617006080U, 21},
	{2617008128U, 21},
	{2617010176U, 22},
	{2617012224U, 22},
	{2617013248U, 22},
	{2617016320U, 21},
	{2617019392U, 22},
	{2617020416U, 21},
	{2617022464U, 22},
	{2617024000U, 24},
	{2617024512U, 22},
	{2617025536U, 23},
	{2617032704U, 21},
	{2617035776U, 22},
	{2617040896U, 20},
	{2617044992U, 21},
	{2617047040U, 22},
	{2617048064U, 24},
	{2617638912U, 16},
	{2617704448U, 16},
	{2617769984U, 16},
	{2618032128U, 16},
	{2618490880U, 16},
	{2619146240U, 16},
	{2620266752U, 24},
	{2620296192U, 22},
	{2620850176U, 16},
	{2620882432U, 23},
	{2620882944U, 22},
	{2620883968U, 22},
	{2620915712U, 16},
	{2621112320U, 16},
	{2621243392U, 16},
	{2621308928U, 16},
	{2621374464U, 16},
	{2622095360U, 16},
	{2622291968U, 16},
	{2622308352U, 19},
	{2622355456U, 24},
	{2622423040U, 16},
	{2623537152U, 16},
	{2623668224U, 15},
	{2624301056U, 23},
	{2624454656U, 16},
	{2624520192U, 16},
	{2624768000U, 24},
	{2626420736U, 16},
	{2626486272U, 16},
	{2626748416U, 16},
	{2626879488U, 16},
	{2627207168U, 15},
	{2627264512U, 24},
	{2634088448U, 16},
	{2634153984U, 16},
	{2634416128U, 16},
	{2634481664U, 16},
	{2634809344U, 16},
	{2634874880U, 16},
	{2634940416U, 16},
	{2635071488U, 16},
	{2635137024U, 16},
	{2635268096U, 16},
	{2635333632U, 16},
	{2635493376U, 20},
	{2635517952U, 23},
	{2635518976U, 23},
	{2635857920U, 15},
	{2636054528U, 16},
	{2636120064U, 12},
	{2637299712U, 16},
	{2638086144U, 16},
	{2638151680U, 16},
	{2638217216U, 16},
	{2638282752U, 16},
	{2638348288U, 16},
	{2638610432U, 16},
	{2638675968U, 16},
	{2638741504U, 16},
	{2638807040U, 16},
	{2638872576U, 16},
	{2638938112U, 16},
	{2639003648U, 16},
	{2639069184U, 16},
	{2639224832U, 21},
	{2639265792U, 16},
	{2639396864U, 16},
	{2639527936U, 16},
	{2639855616U, 16},
	{2639986688U, 16},
	{2640642048U, 16},
	{2640707584U, 16},
	{2640773120U, 16},
	{2640904192U, 16},
	{2641100800U, 16},
	{2641166336U, 16},
	{2641231872U, 16},
	{2641428480U, 16},
	{2641494016U, 16},
	{2641756160U, 16},
	{2641887232U, 16},
	{2642214912U, 16},
	{2642345984U, 16},
	{2642411520U, 16},
	{2642804736U, 16},
	{2643132416U, 23},
	{2643263488U, 16},
	{2643329024U, 16},
	{2643918848U, 16},
	{2644115456U, 16},
	{2644508672U, 16},
	{2644770816U, 16},
	{2644836352U, 16},
	{2645557248U, 16},
	{2645688320U, 16},
	{2645753856U, 20},
	{2645757952U, 24},
	{2646278144U, 16},
	{2646282240U, 20},
	{2646286336U, 20},
	{2646290432U, 20},
	{2646671360U, 16},
	{2646933504U, 16},
	{2646999040U, 16},
	{2647064576U, 16},
	{2647457792U, 16},
	{2647457792U, 22},
	{2647490560U, 17},
	{2647719936U, 16},
	{2648834048U, 16},
	{2649030656U, 16},
	{2649620480U, 16},
	{2649670912U, 24},
	{2650537984U, 16},
	{2650931200U, 16},
	{2651586560U, 16},
	{2653422336U, 24},
	{2653880320U, 16},
	{2654208000U, 16},
	{2654339072U, 16},
	{2654535680U, 16},
	{2655256576U, 16},
	{2655584256U, 16},
	{2656108544U, 17},
	{2656141312U, 17},
	{2656208128U, 24},
	{2656239616U, 16},
	{2656527104U, 24},
	{2656632832U, 16},
	{2656640000U, 24},
	{2656640512U, 24},
	{2657157120U, 16},
	{2657484800U, 16},
	{2657615872U, 16},
	{2657878016U, 16},
	{2658205696U, 16},
	{2658271232U, 16},
	{2658435840U, 24},
	{2658729984U, 16},
	{2658795520U, 16},
	{2659450880U, 16},
	{2660106240U, 16},
	{2660696064U, 16},
	{2660761600U, 16},
	{2660827136U, 16},
	{2661154816U, 16},
	{2661351424U, 16},
	{2661941248U, 16},
	{2662039808U, 24},
	{2662040064U, 24},
	{2662055936U, 24},
	{2662056192U, 24},
	{2662060544U, 24},
	{2663776256U, 16},
	{2663972864U, 16},
	{2664103936U, 16},
	{2664366080U, 16},
	{2664431616U, 16},
	{2664562688U, 16},
	{2664890368U, 16},
	{2665021440U, 16},
	{2665152512U, 16},
	{2665406464U, 20},
	{2666463232U, 16},
	{2666725376U, 16},
	{2666987520U, 16},
	{2667249664U, 16},
	{2667642880U, 16},
	{2668070656U, 24},
	{2668363776U, 16},
	{2668390400U, 24},
	{2668390912U, 24},
	{2668406272U, 24},
	{2668494848U, 16},
	{2668953600U, 16},
	{2669412352U, 16},
	{2670788608U, 16},
	{2671050752U, 16},
	{2671640576U, 16},
	{2672492544U, 16},
	{2672558080U, 16},
	{2673016832U, 16},
	{2673147904U, 16},
	{2673475584U, 16},
	{2674065408U, 16},
	{2674098176U, 19},
	{2674106368U, 21},
	{2674394624U, 24},
	{2674394880U, 24},
	{2674655232U, 16},
	{2674982912U, 16},
	{2675310592U, 16},
	{2675376128U, 16},
	{2675441664U, 16},
	{2675703808U, 16},
	{2676555776U, 16},
	{2676621312U, 16},
	{2676752384U, 16},
	{2676796928U, 24},
	{2676817408U, 24},
	{2677604352U, 16},
	{2677604352U, 17},
	{2677637120U, 19},
	{2677653504U, 19},
	{2677661696U, 19},
	{2679504896U, 16},
	{2679963648U, 16},
	{2680619008U, 16},
	{2680946688U, 16},
	{2681864192U, 16},
	{2682060800U, 16},
	{2682191872U, 16},
	{2682388480U, 16},
	{2683305984U, 16},
	{2683437056U, 16},
	{2683764736U, 16},
	{2684026880U, 16},
	{2685075456U, 16},
	{2685140992U, 16},
	{2685337600U, 16},
	{2685403136U, 16},
	{2685534208U, 16},
	{2685730816U, 16},
	{2685861888U, 16},
	{2685927424U, 16},
	{2686058496U, 16},
	{2686124032U, 16},
	{2686189568U, 16},
	{2686255104U, 16},
	{2686320640U, 16},
	{2686517248U, 16},
	{2686517248U, 19},
	{2686910464U, 16},
	{2687041536U, 16},
	{2687107072U, 16},
	{2687172608U, 16},
	{2688876544U, 16},
	{2688876544U, 23},
	{2689580032U, 22},
	{2689581056U, 19},
	{2689589248U, 20},
	{2689589248U, 22},
	{2689593344U, 21},
	{2689595392U, 22},
	{2689802240U, 19},
	{2690318336U, 16},
	{2690514944U, 16},
	{2690646272U, 24},
	{2690646528U, 24},
	{2691694592U, 16},
	{2691891200U, 16},
	{2692087808U, 16},
	{2692415488U, 16},
	{2692743168U, 18},
	{2693201920U, 16},
	{2693988352U, 16},
	{2696544256U, 16},
	{2696740864U, 16},
	{2696806400U, 16},
	{2696937472U, 16},
	{2697003008U, 16},
	{2697068544U, 16},
	{2697265152U, 16},
	{2697330688U, 16},
	{2697396224U, 16},
	{2697527296U, 16},
	{2697592832U, 16},
	{2697723904U, 16},
	{2697789440U, 16},
	{2697854976U, 16},
	{2697920512U, 16},
	{2698182656U, 16},
	{2698248192U, 16},
	{2698706944U, 16},
	{2698838016U, 16},
	{2699493376U, 16},
	{2699493632U, 24},
	{2699624448U, 16},
	{2699886592U, 16},
	{2699952128U, 16},
	{2700083200U, 16},
	{2700279808U, 16},
	{2700345344U, 16},
	{2700410880U, 16},
	{2700541952U, 16},
	{2700607488U, 16},
	{2700738560U, 16},
	{2700869632U, 16},
	{2701000704U, 16},
	{2701030144U, 24},
	{2701031936U, 24},
	{2701032192U, 24},
	{2701197312U, 16},
	{2701197312U, 17},
	{2701983744U, 16},
	{2702180352U, 16},
	{2702508032U, 16},
	{2703228928U, 16},
	{2703294464U, 16},
	{2703295232U, 24},
	{2703622144U, 16},
	{2704146432U, 16},
	{2704531456U, 20},
	{2704736256U, 16},
	{2704867328U, 16},
	{2704932864U, 16},
	{2705653760U, 16},
	{2705828608U, 24},
	{2706440192U, 16},
	{2707488768U, 16},
	{2708648960U, 24},
	{2708651008U, 24},
	{2708651264U, 24},
	{2708652032U, 20},
	{2709127168U, 16},
	{2709258240U, 16},
	{2709651456U, 16},
	{2709841920U, 21},
	{2709843968U, 21},
	{2709848064U, 16},
	{2709913600U, 16},
	{2709979136U, 16},
	{2710044672U, 16},
	{2710110208U, 16},
	{2710241280U, 16},
	{2710437888U, 16},
	{2710437888U, 17},
	{2710470656U, 17},
	{2710962176U, 17},
	{2710994944U, 18},
	{2711011328U, 18},
	{2711289856U, 16},
	{2711552000U, 16},
	{2711617536U, 16},
	{2711945216U, 16},
	{2712469504U, 16},
	{2712472320U, 24},
	{2713255936U, 16},
	{2713255936U, 17},
	{2713288704U, 17},
	{2713307904U, 24},
	{2713321472U, 16},
	{2713583616U, 16},
	{2713911296U, 16},
	{2714238976U, 16},
	{2714894336U, 16},
	{2715353088U, 16},
	{2715680768U, 16},
	{2715811840U, 16},
	{2715877376U, 16},
	{2716139520U, 16},
	{2716205056U, 16},
	{2716401664U, 16},
	{2716991488U, 16},
	{2717057024U, 16},
	{2717253632U, 16},
	{2717712384U, 16},
	{2718236672U, 16},
	{2718269440U, 17},
	{2718433280U, 16},
	{2718492160U, 24},
	{2718492416U, 24},
	{2718492672U, 24},
	{2718492928U, 24},
	{2718564352U, 16},
	{2719678464U, 16},
	{2720071936U, 24},
	{2720202752U, 16},
	{2720268288U, 16},
	{2721054720U, 16},
	{2721185792U, 16},
	{2721251328U, 16},
	{2721644544U, 16},
	{2721710080U, 16},
	{2722430976U, 16},
	{2723020800U, 16},
	{2723676160U, 16},
	{2724003840U, 16},
	{2724044800U, 19},
	{2724052992U, 19},
	{2724061184U, 19},
	{2724069376U, 16},
	{2724921344U, 16},
	{2724986880U, 16},
	{2725511168U, 16},
	{2725969920U, 16},
	{2726363136U, 16},
	{2726428672U, 16},
	{2726428928U, 24},
	{2726821888U, 16},
	{2726832128U, 22},
	{2734817280U, 16},
	{2735144960U, 16},
	{2735210496U, 16},
	{2735341568U, 16},
	{2735407104U, 16},
	{2735472640U, 16},
	{2735538176U, 16},
	{2735603712U, 15},
	{2735734784U, 15},
	{2735865856U, 16},
	{2735931392U, 16},
	{2735996928U, 14},
	{2736259072U, 14},
	{2736521216U, 16},
	{2736523264U, 21},
	{2736586752U, 16},
	{2736652288U, 16},
	{2736717824U, 16},
	{2736783360U, 16},
	{2737307648U, 16},
	{2737438720U, 16},
	{2737569792U, 16},
	{2737700864U, 16},
	{2737766400U, 16},
	{2737831936U, 16},
	{2737934336U, 22},
	{2738028544U, 16},
	{2738225152U, 16},
	{2738683904U, 16},
	{2742550528U, 16},
	{2742878208U, 16},
	{2742943744U, 16},
	{2743140352U, 16},
	{2743205888U, 16},
	{2743468032U, 16},
	{2743533568U, 16},
	{2743599104U, 16},
	{2743795712U, 16},
	{2743992320U, 16},
	{2744057856U, 16},
	{2744188928U, 16},
	{2744385536U, 16},
	{2744647680U, 16},
	{2744686336U, 24},
	{2744686592U, 23},
	{2744687104U, 24},
	{2744688896U, 24},
	{2744689152U, 23},
	{2744689664U, 24},
	{2744691456U, 24},
	{2744691712U, 23},
	{2744692224U, 24},
	{2744700928U, 20},
	{2744705024U, 20},
	{2744713216U, 16},
	{2744774144U, 24},
	{2744909824U, 16},
	{2744975360U, 16},
	{2745434112U, 16},
	{2746155008U, 16},
	{2746220544U, 16},
	{2746417152U, 16},
	{2746482688U, 17},
	{2746507264U, 19},
	{2746515456U, 18},
	{2746515456U, 19},
	{2746613760U, 16},
	{2747203584U, 16},
	{2747203584U, 19},
	{2747236352U, 19},
	{2747252736U, 19},
	{2747260928U, 19},
	{2747531264U, 16},
	{2747596800U, 16},
	{2747662336U, 15},
	{2747761664U, 24},
	{2747793408U, 16},
	{2747858944U, 16},
	{2747924480U, 15},
	{2748252160U, 16},
	{2748317696U, 16},
	{2748383232U, 16},
	{2748448768U, 16},
	{2748579840U, 16},
	{2748710912U, 16},
	{2748776448U, 16},
	{2749104128U, 16},
	{2749169664U, 16},
	{2749300736U, 16},
	{2749366272U, 16},
	{2749431808U, 16},
	{2749497344U, 16},
	{2749825024U, 16},
	{2750021632U, 16},
	{2750283776U, 16},
	{2750349312U, 16},
	{2750349312U, 17},
	{2750382080U, 18},
	{2750413568U, 24},
	{2750676992U, 16},
	{2750742528U, 16},
	{2750873600U, 16},
	{2750873856U, 24},
	{2750874368U, 24},
	{2750874880U, 24},
	{2750875392U, 24},
	{2750875648U, 22},
	{2750876928U, 24},
	{2750877184U, 24},
	{2750877696U, 24},
	{2750878464U, 24},
	{2750878976U, 24},
	{2750879488U, 24},
	{2750879744U, 24},
	{2750880256U, 24},
	{2750880512U, 24},
	{2750880768U, 24},
	{2750881024U, 24},
	{2750881536U, 24},
	{2750881792U, 22},
	{2750883840U, 24},
	{2750884096U, 24},
	{2750884352U, 24},
	{2750884864U, 24},
	{2750885376U, 24},
	{2750885632U, 24},
	{2750886400U, 24},
	{2750886656U, 24},
	{2750886912U, 24},
	{2750887168U, 24},
	{2750887424U, 24},
	{2750887680U, 24},
	{2750887936U, 24},
	{2750888448U, 24},
	{2750888704U, 24},
	{2750888960U, 24},
	{2750889216U, 24},
	{2750889728U, 24},
	{2750889984U, 24},
	{2750891264U, 24},
	{2750891520U, 24},
	{2750891776U, 24},
	{2750892032U, 24},
	{2750897920U, 24},
	{2750906624U, 24},
	{2750910464U, 24},
	{2750933760U, 24},
	{2750934016U, 24},
	{2750934528U, 24},
	{2750935040U, 24},
	{2750935552U, 24},
	{2750935808U, 24},
	{2750937088U, 24},
	{2751004672U, 16},
	{2751015680U, 24},
	{2751018240U, 24},
	{2751018496U, 24},
	{2751019264U, 24},
	{2751040512U, 22},
	{2751045632U, 21},
	{2751047680U, 23},
	{2751048192U, 24},
	{2751135744U, 17},
	{2751135744U, 19},
	{2751143936U, 19},
	{2751152128U, 19},
	{2751193088U, 19},
	{2751194112U, 24},
	{2751194368U, 24},
	{2751195136U, 24},
	{2751197184U, 21},
	{2751199744U, 24},
	{2751200000U, 24},
	{2751200256U, 24},
	{2751200512U, 24},
	{2751200768U, 24},
	{2752446464U, 16},
	{2753953792U, 16},
	{2754066688U, 24},
	{2754281472U, 16},
	{2754478080U, 16},
	{2754543616U, 16},
	{2754660096U, 24},
	{2754674688U, 16},
	{2755002368U, 16},
	{2755067904U, 16},
	{2755198976U, 16},
	{2755264512U, 16},
	{2755919872U, 16},
	{2755985408U, 16},
	{2756116480U, 16},
	{2756247552U, 16},
	{2756444160U, 16},
	{2756575232U, 16},
	{2756902912U, 16},
	{2757230592U, 16},
	{2757623808U, 16},
	{2757951488U, 16},
	{2758017024U, 16},
	{2758019072U, 22},
	{2758029312U, 20},
	{2758042624U, 22},
	{2758049792U, 19},
	{2758053888U, 20},
	{2758074368U, 19},
	{2758078464U, 20},
	{2758213632U, 16},
	{2758279168U, 16},
	{2758344704U, 16},
	{2758387712U, 24},
	{2758475776U, 16},
	{2758672384U, 16},
	{2758868992U, 19},
	{2758877184U, 19},
	{2758930432U, 21},
	{2759000064U, 16},
	{2759065600U, 16},
	{2759458816U, 16},
	{2759589888U, 16},
	{2760638464U, 16},
	{2760898560U, 24},
	{2760898816U, 24},
	{2760899072U, 24},
	{2760899328U, 24},
	{2761555968U, 16},
	{2761621504U, 16},
	{2761752576U, 16},
	{2761818112U, 16},
	{2761883648U, 16},
	{2762014720U, 16},
	{2762145792U, 16},
	{2762211328U, 16},
	{2762230784U, 24},
	{2762232576U, 24},
	{2762235648U, 24},
	{2763128832U, 16},
	{2765750272U, 16},
	{2765881344U, 16},
	{2766077952U, 16},
	{2766143488U, 16},
	{2766274560U, 16},
	{2766340096U, 16},
	{2766471168U, 16},
	{2766536704U, 16},
	{2766620672U, 24},
	{2768306176U, 16},
	{2768502784U, 16},
	{2768764928U, 16},
	{2768896000U, 16},
	{2768961536U, 16},
	{2769158144U, 16},
	{2769616896U, 16},
	{2769622016U, 24},
	{2769623040U, 21},
	{2769633280U, 21},
	{2769636096U, 24},
	{2769636352U, 23},
	{2769645568U, 21},
	{2769648640U, 22},
	{2769649664U, 22},
	{2769650688U, 24},
	{2769651200U, 24},
	{2769657088U, 24},
	{2769657344U, 23},
	{2769813504U, 16},
	{2769879040U, 16},
	{2769944576U, 16},
	{2770075648U, 16},
	{2770206720U, 16},
	{2772500480U, 16},
	{2772967424U, 19},
	{2773221376U, 16},
	{2773479424U, 20},
	{2773680128U, 16},
	{2773942272U, 16},
	{2774073344U, 16},
	{2774335488U, 16},
	{2774665216U, 24},
	{2774665984U, 24},
	{2774666240U, 24},
	{2774667008U, 24},
	{2774689024U, 24},
	{2774689280U, 24},
	{2774689536U, 24},
	{2774689792U, 22},
	{2774691584U, 24},
	{2775646208U, 16},
	{2775678720U, 24},
	{2775678976U, 24},
	{2775679232U, 24},
	{2775686144U, 24},
	{2775687424U, 24},
	{2775691264U, 24},
	{2775694080U, 24},
	{2775694592U, 24},
	{2775694848U, 24},
	{2775695104U, 24},
	{2775695616U, 24},
	{2775699456U, 24},
	{2775701248U, 24},
	{2776170496U, 16},
	{2776314368U, 24},
	{2776367104U, 16},
	{2776760320U, 16},
	{2776891392U, 16},
	{2776949760U, 22},
	{2776950784U, 21},
	{2776954368U, 23},
	{2776956928U, 17},
	{2776989696U, 17},
	{2777284608U, 16},
	{2777284608U, 20},
	{2777288704U, 20},
	{2777292800U, 20},
	{2777296896U, 20},
	{2777309184U, 20},
	{2777313280U, 20},
	{2777317376U, 19},
	{2777325568U, 20},
	{2777329664U, 20},
	{2777333760U, 19},
	{2777341952U, 20},
	{2777346048U, 20},
	{2777350144U, 16},
	{2777350144U, 20},
	{2777354240U, 20},
	{2777358336U, 20},
	{2777366528U, 20},
	{2777370624U, 20},
	{2777378816U, 20},
	{2777382912U, 20},
	{2777387008U, 20},
	{2777391104U, 20},
	{2777395200U, 20},
	{2777399296U, 20},
	{2777403392U, 20},
	{2777407488U, 19},
	{2777415680U, 16},
	{2777481216U, 16},
	{2778071040U, 16},
	{2778136576U, 16},
	{2778202112U, 16},
	{2778398720U, 16},
	{2778529792U, 16},
	{2779119616U, 16},
	{2779119616U, 17},
	{2779152384U, 17},
	{2779387904U, 21},
	{2779398144U, 24},
	{2779426816U, 22},
	{2779435008U, 24},
	{2779578368U, 16},
	{2780430336U, 16},
	{2780723712U, 23},
	{2780724224U, 22},
	{2780725248U, 21},
	{2780889088U, 16},
	{2780954624U, 16},
	{2781413376U, 16},
	{2781741056U, 16},
	{2781801984U, 24},
	{2782134272U, 16},
	{2782134272U, 18},
	{2782150400U, 24},
	{2782199808U, 16},
	{2782461952U, 16},
	{2782661120U, 24},
	{2783035904U, 24},
	{2783248384U, 16},
	{2783313920U, 16},
	{2783379456U, 16},
	{2783444992U, 16},
	{2783510528U, 16},
	{2783707136U, 16},
	{2783838208U, 16},
	{2784100352U, 16},
	{2784165888U, 16},
	{2784231424U, 16},
	{2784362496U, 16},
	{2784428032U, 16},
	{2784458752U, 21},
	{2784779520U, 24},
	{2784886784U, 16},
	{2784901120U, 24},
	{2784902656U, 24},
	{2784903168U, 20},
	{2784910336U, 24},
	{2784913152U, 24},
	{2784916736U, 24},
	{2784927488U, 24},
	{2784929024U, 24},
	{2784929792U, 24},
	{2784934400U, 24},
	{2784945408U, 24},
	{2784950272U, 22},
	{2786066432U, 16},
	{2786263040U, 16},
	{2786328576U, 16},
	{2786394112U, 16},
	{2786983936U, 16},
	{2788261888U, 17},
	{2788261888U, 23},
	{2788262400U, 24},
	{2788262656U, 24},
	{2788262912U, 24},
	{2788263168U, 24},
	{2788263424U, 24},
	{2788263680U, 24},
	{2788264192U, 24},
	{2788264448U, 24},
	{2788264704U, 24},
	{2788265984U, 24},
	{2788267264U, 24},
	{2788269056U, 24},
	{2788273152U, 22},
	{2788275200U, 23},
	{2788275712U, 23},
	{2788276224U, 23},
	{2788276736U, 23},
	{2788277760U, 23},
	{2788278272U, 22},
	{2788286464U, 19},
	{2789263360U, 23},
	{2789263360U, 24},
	{2789263616U, 24},
	{2789343232U, 16},
	{2789736448U, 16},
	{2789801984U, 16},
	{2789807104U, 24},
	{2790195200U, 16},
	{2790262784U, 24},
	{2790263040U, 24},
	{2790263296U, 24},
	{2790264832U, 24},
	{2790267648U, 24},
	{2790267904U, 23},
	{2790268416U, 24},
	{2790272512U, 24},
	{2790273536U, 24},
	{2790274560U, 24},
	{2790276608U, 24},
	{2790279680U, 24},
	{2790280704U, 24},
	{2790280960U, 24},
	{2790281728U, 24},
	{2790281984U, 24},
	{2790282240U, 24},
	{2790283776U, 24},
	{2790287872U, 24},
	{2790289920U, 24},
	{2790291456U, 24},
	{2790292992U, 24},
	{2790293248U, 24},
	{2790322688U, 24},
	{2790522880U, 16},
	{2790537216U, 21},
	{2790537216U, 22},
	{2790538240U, 22},
	{2790558720U, 23},
	{2790559488U, 24},
	{2790559744U, 20},
	{2790563072U, 24},
	{2790565888U, 22},
	{2790566912U, 24},
	{2790567424U, 24},
	{2790570240U, 24},
	{2790571776U, 24},
	{2790785024U, 16},
	{2790807552U, 24},
	{2790928640U, 24},
	{2790929152U, 24},
	{2790951424U, 23},
	{2790960384U, 24},
	{2791374848U, 16},
	{2791768064U, 16},
	{2791833600U, 17},
	{2791866368U, 18},
	{2791882752U, 18},
	{2792501248U, 20},
	{2792505344U, 19},
	{2792513536U, 19},
	{2792529920U, 19},
	{2792816640U, 16},
	{2792947712U, 16},
	{2793144320U, 16},
	{2793275392U, 16},
	{2793340928U, 16},
	{2793406464U, 13},
	{2793406464U, 16},
	{2793472000U, 16},
	{2793537536U, 16},
	{2793603072U, 16},
	{2793668608U, 16},
	{2793734144U, 16},
	{2793799680U, 16},
	{2793996288U, 16},
	{2795765760U, 16},
	{2796748800U, 16},
	{2797010944U, 16},
	{2797076480U, 16},
	{2797142016U, 16},
	{2797207552U, 16},
	{2797273088U, 16},
	{2797338624U, 16},
	{2797404160U, 16},
	{2797469696U, 16},
	{2797535232U, 16},
	{2797600768U, 16},
	{2797666304U, 16},
	{2797731840U, 16},
	{2797797376U, 16},
	{2797862912U, 16},
	{2797928448U, 16},
	{2797993984U, 16},
	{2798059520U, 16},
	{2798125056U, 16},
	{2798190592U, 16},
	{2798256128U, 16},
	{2798321664U, 16},
	{2798387200U, 16},
	{2798977024U, 16},
	{2801860608U, 16},
	{2801886208U, 24},
	{2801886464U, 24},
	{2801886720U, 24},
	{2801887232U, 24},
	{2801887488U, 24},
	{2801887744U, 24},
	{2801888000U, 24},
	{2801888256U, 24},
	{2801888512U, 24},
	{2801888768U, 24},
	{2801889536U, 24},
	{2802188288U, 16},
	{2802253824U, 16},
	{2802724864U, 21},
	{2803367936U, 16},
	{2803393792U, 24},
	{2803394048U, 24},
	{2803394304U, 24},
	{2803394560U, 24},
	{2803394816U, 24},
	{2803429632U, 24},
	{2803429888U, 24},
	{2803430144U, 24},
	{2803430400U, 24},
	{2803430656U, 24},
	{2803433472U, 16},
	{2803630080U, 16},
	{2805989376U, 16},
	{2806000384U, 24},
	{2806001664U, 24},
	{2806003968U, 24},
	{2806011136U, 24},
	{2806120448U, 16},
	{2806251520U, 16},
	{2806382592U, 16},
	{2806513664U, 16},
	{2806850560U, 24},
	{2806972416U, 16},
	{2807562240U, 16},
	{2807627776U, 16},
	{2808807424U, 16},
	{2809331712U, 16},
	{2809331712U, 17},
	{2809659392U, 16},
	{2809724928U, 16},
	{2810118144U, 16},
	{2810159104U, 21},
	{2810445824U, 16},
	{2810707968U, 16},
	{2810714368U, 24},
	{2810716928U, 24},
	{2810765568U, 24},
	{2810768128U, 24},
	{2810904576U, 16},
	{2810970112U, 16},
	{2811101184U, 16},
	{2811428864U, 16},
	{2811625472U, 16},
	{2811691008U, 16},
	{2811822080U, 16},
	{2811822080U, 17},
	{2811854848U, 17},
	{2812674048U, 16},
	{2812739584U, 16},
	{2812870656U, 16},
	{2813394944U, 16},
	{2813919232U, 16},
	{2814048512U, 24},
	{2814050304U, 16},
	{2815229952U, 16},
	{2815623168U, 16},
	{2815950848U, 16},
	{2815950848U, 17},
	{2815983616U, 17},
	{2816016384U, 16},
	{2816212992U, 16},
	{2816879104U, 24},
	{2816999424U, 16},
	{2817130496U, 16},
	{2817261568U, 16},
	{2817458176U, 16},
	{2817523712U, 16},
	{2817654784U, 16},
	{2817982464U, 16},
	{2818048000U, 16},
	{2818310144U, 16},
	{2820669440U, 12},
	{2821718016U, 13},
	{2822242304U, 14},
	{2822504448U, 16},
	{2823094272U, 16},
	{2823487488U, 16},
	{2823487488U, 18},
	{2823487488U, 24},
	{2823684096U, 16},
	{2823815168U, 15},
	{2824011776U, 16},
	{2824077312U, 16},
	{2824404992U, 16},
	{2824798208U, 16},
	{2824863744U, 16},
	{2824880128U, 21},
	{2824882176U, 21},
	{2824896512U, 22},
	{2824899584U, 23},
	{2824900608U, 22},
	{2824901632U, 24},
	{2824915968U, 22},
	{2824918016U, 24},
	{2825060352U, 16},
	{2825125888U, 16},
	{2825191424U, 16},
	{2825195520U, 21},
	{2825846784U, 16},
	{2826108928U, 16},
	{2826117120U, 19},
	{2826436608U, 16},
	{2826829824U, 16},
	{2826836736U, 24},
	{2826872576U, 24},
	{2827157504U, 16},
	{2827288576U, 16},
	{2827419648U, 16},
	{2827878400U, 16},
	{2827943936U, 16},
	{2828337152U, 16},
	{2828468224U, 16},
	{2828664832U, 16},
	{2828795904U, 16},
	{2828926976U, 16},
	{2829320192U, 16},
	{2829385728U, 16},
	{2829451264U, 16},
	{2829516800U, 16},
	{2829713408U, 16},
	{2829778944U, 16},
	{2829844480U, 16},
	{2830041088U, 16},
	{2830565376U, 16},
	{2830893056U, 16},
	{2831876096U, 16},
	{2832007168U, 16},
	{2832203776U, 16},
	{2832269312U, 16},
	{2832334848U, 16},
	{2832335104U, 24},
	{2832345088U, 23},
	{2832347648U, 24},
	{2832352256U, 22},
	{2832360448U, 24},
	{2832465920U, 16},
	{2832687104U, 23},
	{2832689664U, 23},
	{2832690176U, 23},
	{2832691456U, 24},
	{2832719872U, 20},
	{2832793600U, 16},
	{2832924672U, 16},
	{2832990208U, 16},
	{2833252608U, 24},
	{2833383424U, 16},
	{2833645568U, 16},
	{2833678336U, 19},
	{2833711104U, 16},
	{2833907712U, 16},
	{2833907712U, 17},
	{2833925120U, 22},
	{2833928448U, 24},
	{2833928704U, 24},
	{2833928960U, 24},
	{2833929216U, 24},
	{2833929472U, 24},
	{2833940736U, 24},
	{2833940992U, 24},
	{2833942016U, 24},
	{2833942272U, 24},
	{2833942528U, 24},
	{2833942784U, 24},
	{2833943040U, 24},
	{2833943296U, 24},
	{2833944320U, 24},
	{2833944576U, 24},
	{2833944832U, 24},
	{2833945088U, 24},
	{2833945344U, 24},
	{2833945600U, 23},
	{2833946112U, 23},
	{2833946880U, 24},
	{2833947904U, 24},
	{2833948160U, 23},
	{2833949952U, 24},
	{2833950208U, 23},
	{2833950720U, 24},
	{2833950976U, 24},
	{2833951232U, 24},
	{2833951488U, 24},
	{2833952000U, 24},
	{2833952512U, 24},
	{2833952768U, 24},
	{2833953024U, 24},
	{2833954048U, 24},
	{2833956352U, 23},
	{2833956864U, 20},
	{2833971712U, 24},
	{2833971968U, 24},
	{2833972224U, 24},
	{2833972480U, 24},
	{2833972736U, 24},
	{2834366464U, 16},
	{2834518016U, 24},
	{2834518272U, 24},
	{2834531584U, 24},
	{2834542592U, 21},
	{2834544640U, 21},
	{2834628608U, 16},
	{2834825216U, 15},
	{2835283968U, 17},
	{2835611648U, 14},
	{2835873792U, 13},
	{2840007680U, 24},
	{2840023040U, 24},
	{2840023296U, 24},
	{2840027392U, 24},
	{2841903104U, 19},
	{2843869184U, 16},
	{2843934720U, 16},
	{2844000256U, 16},
	{2844003072U, 24},
	{2844393472U, 16},
	{2844540928U, 18},
	{2844573696U, 18},
	{2844655616U, 16},
	{2844786688U, 16},
	{2844917760U, 16},
	{2845179904U, 16},
	{2845245440U, 16},
	{2845310976U, 16},
	{2845409280U, 24},
	{2845573120U, 16},
	{2845638656U, 16},
	{2848587776U, 16},
	{2848653312U, 16},
	{2848718848U, 16},
	{2848784384U, 16},
	{2848849920U, 16},
	{2848915456U, 16},
	{2850160640U, 16},
	{2851078144U, 16},
	{2852323328U, 16},
	{2852454400U, 16},
	{2852732928U, 18},
	{2852765696U, 18},
	{2852847616U, 16},
	{2853175296U, 16},
	{2853177344U, 22},
	{2853177856U, 23},
	{2853178368U, 23},
	{2853178880U, 23},
	{2853240832U, 16},
	{2853437440U, 16},
	{2853437440U, 18},
	{2853453824U, 19},
	{2853474304U, 20},
	{2853478400U, 19},
	{2853486592U, 18},
	{2853568512U, 16},
	{2853699584U, 16},
	{2853929984U, 22},
	{2853994496U, 22},
	{2854223872U, 16},
	{2854420480U, 16},
	{2854481920U, 22},
	{2854482944U, 22},
	{2854483968U, 22},
	{2854484992U, 22},
	{2854612224U, 24},
	{2854612480U, 24},
	{2854612736U, 24},
	{2854617088U, 16},
	{2854682624U, 16},
	{2855206912U, 16},
	{2855665664U, 16},
	{2855680768U, 24},
	{2855727104U, 24},
	{2855727360U, 24},
	{2855731200U, 16},
	{2855862272U, 16},
	{2856419328U, 21},
	{2856845312U, 16},
	{2857041920U, 16},
	{2857697280U, 16},
	{2858123264U, 18},
	{2858156032U, 16},
	{2859139072U, 16},
	{2859204608U, 16},
	{2860056576U, 16},
	{2860515328U, 16},
	{2860558848U, 24},
	{2860560128U, 24},
	{2860711936U, 19},
	{2860974080U, 16},
	{2861170688U, 16},
	{2861187072U, 21},
	{2861760512U, 16},
	{2862088192U, 16},
	{2862153728U, 16},
	{2862284800U, 16},
	{2862481408U, 16},
	{2862612480U, 16},
	{2862678016U, 16},
	{2862760192U, 24},
	{2862760448U, 24},
	{2862940160U, 16},
	{2863071232U, 16},
	{2863792128U, 16},
	{2865299456U, 16},
	{2865627136U, 16},
	{2865627136U, 19},
	{2865635328U, 19},
	{2865643520U, 19},
	{2865651712U, 19},
	{2865659904U, 19},
	{2865668096U, 19},
	{2865676288U, 19},
	{2865684480U, 23},
	{2865684992U, 23},
	{2865823744U, 16},
	{2866216960U, 16},
	{2866220800U, 24},
	{2866221056U, 20},
	{2866241536U, 19},
	{2866249728U, 20},
	{2866257664U, 24},
	{2866257920U, 24},
	{2866258176U, 24},
	{2866258432U, 24},
	{2866258688U, 24},
	{2866260736U, 24},
	{2866261760U, 24},
	{2866262272U, 24},
	{2866262784U, 24},
	{2866263296U, 24},
	{2866263552U, 24},
	{2866263808U, 24},
	{2866264064U, 24},
	{2866264320U, 24},
	{2866264576U, 24},
	{2866264832U, 24},
	{2866265088U, 24},
	{2866266112U, 18},
	{2866741248U, 16},
	{2866806784U, 16},
	{2866806784U, 20},
	{2866810880U, 20},
	{2866868224U, 20},
	{2867596800U, 24},
	{2868403968U, 24},
	{2868404480U, 24},
	{2868510720U, 16},
	{2868673280U, 24},
	{2868674304U, 24},
	{2870673408U, 16},
	{2870902784U, 17},
	{2873360384U, 14},
	{2873622528U, 16},
	{2894069760U, 13},
	{2894594048U, 13},
	{2895118336U, 13},
	{2895642624U, 13},
	{2896166912U, 13},
	{2896691200U, 13},
	{2897215488U, 13},
	{2897477632U, 14},
	{2897477632U, 16},
	{2897739776U, 13},
	{2897739776U, 16},
	{2897805312U, 16},
	{2898001920U, 14},
	{3238006272U, 24},
	{3238060032U, 22},
	{3238062080U, 23},
	{3238232064U, 23},
	{3238330880U, 24},
	{3238336512U, 24},
	{3238340864U, 24},
	{3238347776U, 23},
	{3238371328U, 21},
	{3238391808U, 21},
	{3238393856U, 23},
	{3238395648U, 24},
	{3238535936U, 24},
	{3238554880U, 24},
	{3238577408U, 24},
	{3238594560U, 24},
	{3238624256U, 22},
	{3238657536U, 24},
	{3239052032U, 24},
	{3239063552U, 20},
	{3239246080U, 24},
	{3239470080U, 23},
	{3239475200U, 21},
	{3239485440U, 24},
	{3239485952U, 24},
	{3239486208U, 24},
	{3239552000U, 24},
	{3239552768U, 24},
	{3239838976U, 24},
	{3239845888U, 22},
	{3239853568U, 24},
	{3239891968U, 24},
	{3239962112U, 24},
	{3239970048U, 24},
	{3239973888U, 24},
	{3239980032U, 22},
	{3239981056U, 20},
	{3239994368U, 24},
	{3239995136U, 24},
	{3240020480U, 24},
	{3240104192U, 24},
	{3240105728U, 24},
	{3240153088U, 23},
	{3240164864U, 24},
	{3240289792U, 23},
	{3240289792U, 24},
	{3240333824U, 23},
	{3240343040U, 23},
	{3240343552U, 21},
	{3240345600U, 22},
	{3240346624U, 23},
	{3240361728U, 24},
	{3240435712U, 24},
	{3240436736U, 24},
	{3240445184U, 24},
	{3240468480U, 24},
	{3240506368U, 24},
	{3240536064U, 24},
	{3240536320U, 24},
	{3240562688U, 20},
	{3240589824U, 24},
	{3240592640U, 24},
	{3240621568U, 24},
	{3240704000U, 22},
	{3240705024U, 22},
	{3240710656U, 24},
	{3240712704U, 24},
	{3240713472U, 24},
	{3240719872U, 23},
	{3240726528U, 23},
	{3240727552U, 23},
	{3240731648U, 23},
	{3240736768U, 22},
	{3240745472U, 23},
	{3240749568U, 24},
	{3240787968U, 22},
	{3240824576U, 24},
	{3240846848U, 23},
	{3240853504U, 22},
	{3240854528U, 23},
	{3241051904U, 24},
	{3241109504U, 21},
	{3241111552U, 20},
	{3241115648U, 21},
	{3241481984U, 24},
	{3241484800U, 24},
	{3241496576U, 24},
	{3241705216U, 24},
	{3241766144U, 24},
	{3241821696U, 23},
	{3241821696U, 24},
	{3241821952U, 24},
	{3241851392U, 23},
	{3241856000U, 22},
	{3241857024U, 24},
	{3241857280U, 24},
	{3242029056U, 22},
	{3242776576U, 24},
	{3242802176U, 24},
	{3242802688U, 24},
	{3242805504U, 24},
	{3242805760U, 24},
	{3242806016U, 24},
	{3242806272U, 24},
	{3242806784U, 24},
	{3242807040U, 24},
	{3242807296U, 24},
	{3242807552U, 24},
	{3242807808U, 24},
	{3242808064U, 24},
	{3242808320U, 24},
	{3242808576U, 24},
	{3242808832U, 24},
	{3242809088U, 24},
	{3242809344U, 24},
	{3242809600U, 24},
	{3242809856U, 24},
	{3242810112U, 24},
	{3242810368U, 24},
	{3242810624U, 24},
	{3242810880U, 24},
	{3242811136U, 24},
	{3242811392U, 24},
	{3242811648U, 24},
	{3242811904U, 24},
	{3242812160U, 24},
	{3242812416U, 24},
	{3242812672U, 24},
	{3242812928U, 24},
	{3242813184U, 24},
	{3243417088U, 24},
	{3244294400U, 24},
	{3244321024U, 24},
	{3244322816U, 21},
	{3244338432U, 24},
	{3244353024U, 24},
	{3244384256U, 20},
	{3244390400U, 22},
	{3244391424U, 23},
	{3244392704U, 24},
	{3244406784U, 24},
	{3244425472U, 24},
	{3244427264U, 22},
	{3244427520U, 24},
	{3244453376U, 24},
	{3244482816U, 24},
	{3244527616U, 24},
	{3244564480U, 19},
	{3244580864U, 24},
	{3244599040U, 24},
	{3244622336U, 24},
	{3244624896U, 22},
	{3244627712U, 24},
	{3244633344U, 24},
	{3244633856U, 24},
	{3244636672U, 24},
	{3244637696U, 23},
	{3244638976U, 24},
	{3244639232U, 24},
	{3244720128U, 22},
	{3244740608U, 24},
	{3244745472U, 24},
	{3244753152U, 24},
	{3244753408U, 23},
	{3244753920U, 22},
	{3244754944U, 21},
	{3244756992U, 20},
	{3244761088U, 19},
	{3244769280U, 18},
	{3244787200U, 24},
	{3245089792U, 23},
	{3245096960U, 21},
	{3245113344U, 23},
	{3245408256U, 16},
	{3245504000U, 24},
	{3245537280U, 24},
	{3245688832U, 21},
	{3245719040U, 24},
	{3245740032U, 20},
	{3245846528U, 20},
	{3246092288U, 20},
	{3246187776U, 24},
	{3246216704U, 24},
	{3246438400U, 22},
	{3246613504U, 22},
	{3246617088U, 23},
	{3246620416U, 24},
	{3246654464U, 22},
	{3246705408U, 24},
	{3246849536U, 24},
	{3246876672U, 23},
	{3246877184U, 24},
	{3246915072U, 24},
	{3247054848U, 19},
	{3247226880U, 20},
	{3247230976U, 21},
	{3247259648U, 24},
	{3247288320U, 24},
	{3247708160U, 21},
	{3247710208U, 22},
	{3247711232U, 23},
	{3247764992U, 24},
	{3247775744U, 19},
	{3247816704U, 18},
	{3247823104U, 24},
	{3247875072U, 24},
	{3248646144U, 23},
	{3248775168U, 19},
	{3248799744U, 24},
	{3248800256U, 23},
	{3248812544U, 23},
	{3249013248U, 24},
	{3249238528U, 24},
	{3249274880U, 15},
	{3249289216U, 22},
	{3249323008U, 22},
	{3249327104U, 22},
	{3249553408U, 24},
	{3249560832U, 24},
	{3249561088U, 23},
	{3249571840U, 21},
	{3249659904U, 21},
	{3249681664U, 24},
	{3249701632U, 24},
	{3249701888U, 24},
	{3249704960U, 22},
	{3249710848U, 24},
	{3249721344U, 24},
	{3249726464U, 23},
	{3249815040U, 24},
	{3249864704U, 24},
	{3250000384U, 23},
	{3250216192U, 24},
	{3250216448U, 24},
	{3250233600U, 24},
	{3250240512U, 22},
	{3250331648U, 20},
	{3250331648U, 24},
	{3250332160U, 23},
	{3250332672U, 23},
	{3250333696U, 21},
	{3250358016U, 24},
	{3250364416U, 19},
	{3250454528U, 15},
	{3250593792U, 19},
	{3250601984U, 19},
	{3250634752U, 19},
	{3250642944U, 19},
	{3250649344U, 24},
	{3250682880U, 22},
	{3250686208U, 24},
	{3250692352U, 24},
	{3250694912U, 24},
	{3250698240U, 23},
	{3250700288U, 19},
	{3250708480U, 19},
	{3250733056U, 19},
	{3250733056U, 24},
	{3250733312U, 24},
	{3250734336U, 24},
	{3250736128U, 24},
	{3250737408U, 24},
	{3250749952U, 24},
	{3250751488U, 24},
	{3250757120U, 24},
	{3250782208U, 16},
	{3250842112U, 24},
	{3251113984U, 23},
	{3251314176U, 23},
	{3251331072U, 19},
	{3251364096U, 24},
	{3251364352U, 24},
	{3251366912U, 23},
	{3251367424U, 23},
	{3251367936U, 20},
	{3252310016U, 23},
	{3252314880U, 24},
	{3252320512U, 24},
	{3252567040U, 24},
	{3252821504U, 24},
	{3252821760U, 24},
	{3252822016U, 24},
	{3252822272U, 24},
	{3252822784U, 24},
	{3252825088U, 24},
	{3252827648U, 24},
	{3252828416U, 24},
	{3252830208U, 24},
	{3252834816U, 23},
	{3252835072U, 24},
	{3252835328U, 24},
	{3252836352U, 23},
	{3252838144U, 24},
	{3252838912U, 24},
	{3252839168U, 24},
	{3252839424U, 24},
	{3252839680U, 24},
	{3252840192U, 24},
	{3252842240U, 24},
	{3252846080U, 24},
	{3252904192U, 24},
	{3252906240U, 24},
	{3252976896U, 24},
	{3253075968U, 17},
	{3253110272U, 23},
	{3253110528U, 24},
	{3253112064U, 24},
	{3253112320U, 24},
	{3253113088U, 24},
	{3253113344U, 24},
	{3253116928U, 24},
	{3253117184U, 24},
	{3253117440U, 24},
	{3253117696U, 24},
	{3253118464U, 24},
	{3253118720U, 24},
	{3253118976U, 24},
	{3253119232U, 24},
	{3253121024U, 24},
	{3253121536U, 24},
	{3253122560U, 24},
	{3253126656U, 24},
	{3253134336U, 24},
	{3253135360U, 24},
	{3253135872U, 23},
	{3253136384U, 23},
	{3253137152U, 24},
	{3253138176U, 24},
	{3253138688U, 24},
	{3253139456U, 24},
	{3253140736U, 24},
	{3253152256U, 24},
	{3253158144U, 24},
	{3253158400U, 24},
	{3253158656U, 24},
	{3253159424U, 24},
	{3253159680U, 24},
	{3253159936U, 24},
	{3253160192U, 24},
	{3253161728U, 24},
	{3253162752U, 24},
	{3253166592U, 24},
	{3253166848U, 24},
	{3253169408U, 24},
	{3253170944U, 24},
	{3253171200U, 22},
	{3253171968U, 24},
	{3253172224U, 21},
	{3253172736U, 24},
	{3253172992U, 24},
	{3253186560U, 24},
	{3253187584U, 22},
	{3253193728U, 24},
	{3253194240U, 23},
	{3253202944U, 24},
	{3253204480U, 24},
	{3253205504U, 23},
	{3253230592U, 24},
	{3253270528U, 22},
	{3253394432U, 23},
	{3253436928U, 23},
	{3253456384U, 24},
	{3253534720U, 16},
	{3253886976U, 24},
	{3253891328U, 24},
	{3253891840U, 24},
	{3253892096U, 24},
	{3253969920U, 23},
	{3253972992U, 22},
	{3253974016U, 23},
	{3253977088U, 19},
	{3253985280U, 19},
	{3254149120U, 24},
	{3254150400U, 24},
	{3254152192U, 23},
	{3254155264U, 24},
	{3254156032U, 24},
	{3254202368U, 23},
	{3254203136U, 24},
	{3254203904U, 23},
	{3254204416U, 22},
	{3254207488U, 22},
	{3254209024U, 23},
	{3254209536U, 24},
	{3254210816U, 24},
	{3254212352U, 24},
	{3254212608U, 24},
	{3254214144U, 24},
	{3254215936U, 24},
	{3254224128U, 24},
	{3254224384U, 23},
	{3254227712U, 24},
	{3254236160U, 24},
	{3254236928U, 24},
	{3254238464U, 24},
	{3254241792U, 24},
	{3254245888U, 24},
	{3254246144U, 24},
	{3254246400U, 22},
	{3254251008U, 24},
	{3254656000U, 24},
	{3254741504U, 24},
	{3255084032U, 24},
	{3255328768U, 19},
	{3255328768U, 24},
	{3255336960U, 19},
	{3255362560U, 22},
	{3255363328U, 24},
	{3255363584U, 24},
	{3255363840U, 24},
	{3255364096U, 24},
	{3255364352U, 24},
	{3255364608U, 24},
	{3255486720U, 24},
	{3255552000U, 24},
	{3255565312U, 24},
	{3255693312U, 20},
	{3255698944U, 23},
	{3255717888U, 24},
	{3255718144U, 24},
	{3255719424U, 24},
	{3255779328U, 21},
	{3255781376U, 22},
	{3255783424U, 20},
	{3255791616U, 20},
	{3255803904U, 24},
	{3255807744U, 24},
	{3255810048U, 24},
	{3255810304U, 24},
	{3255810560U, 24},
	{3255810816U, 24},
	{3255821824U, 24},
	{3255823616U, 24},
	{3255825152U, 24},
	{3256092672U, 21},
	{3256100864U, 23},
	{3256101376U, 24},
	{3256101888U, 22},
	{3256103168U, 24},
	{3256103424U, 24},
	{3256103936U, 22},
	{3256104960U, 23},
	{3256105984U, 22},
	{3256118272U, 22},
	{3256130304U, 24},
	{3256141568U, 24},
	{3256141824U, 21},
	{3256143872U, 21},
	{3256145920U, 22},
	{3256147456U, 24},
	{3256148480U, 24},
	{3256149248U, 24},
	{3256154112U, 24},
	{3256157184U, 22},
	{3256158208U, 22},
	{3256161024U, 24},
	{3256161280U, 22},
	{3256162560U, 24},
	{3256163328U, 22},
	{3256345344U, 24},
	{3256385536U, 19},
	{3256530944U, 22},
	{3256680448U, 19},
	{3256696832U, 18},
	{3256697344U, 23},
	{3256698880U, 21},
	{3256705024U, 24},
	{3256705792U, 24},
	{3256706048U, 23},
	{3256706560U, 23},
	{3256778752U, 19},
	{3256795136U, 18},
	{3256815616U, 20},
	{3256831232U, 24},
	{3256864000U, 24},
	{3256867840U, 24},
	{3256869632U, 24},
	{3256872960U, 23},
	{3256874240U, 24},
	{3256909056U, 24},
	{3256909312U, 23},
	{3256921600U, 23},
	{3256929024U, 24},
	{3256933632U, 24},
	{3256954624U, 24},
	{3256954880U, 23},
	{3257036800U, 20},
	{3257138176U, 24},
	{3257169920U, 24},
	{3257183232U, 22},
	{3257195264U, 24},
	{3257195520U, 24},
	{3257196288U, 24},
	{3257289216U, 23},
	{3257289728U, 22},
	{3257290752U, 21},
	{3257292800U, 23},
	{3257293312U, 24},
	{3257366784U, 24},
	{3257373696U, 24},
	{3257396480U, 24},
	{3257401344U, 17},
	{3257482752U, 24},
	{3257546752U, 21},
	{3257565184U, 19},
	{3257573376U, 19},
	{3257577472U, 20},
	{3257581568U, 20},
	{3257664512U, 24},
	{3257664768U, 24},
	{3257670144U, 24},
	{3257671168U, 24},
	{3257671680U, 23},
	{3257672192U, 24},
	{3257673216U, 23},
	{3257677312U, 24},
	{3257679360U, 24},
	{3257679616U, 24},
	{3257683968U, 24},
	{3257684224U, 24},
	{3257684480U, 24},
	{3257684736U, 24},
	{3257686016U, 23},
	{3257686528U, 24},
	{3257687296U, 24},
	{3257689344U, 24},
	{3257689600U, 24},
	{3257690112U, 22},
	{3257691648U, 24},
	{3257691904U, 24},
	{3257692160U, 24},
	{3257700864U, 23},
	{3257701888U, 24},
	{3257702400U, 24},
	{3257702656U, 24},
	{3257702912U, 24},
	{3257703936U, 24},
	{3257704960U, 24},
	{3257705472U, 24},
	{3257707008U, 24},
	{3257709056U, 24},
	{3257711104U, 24},
	{3257711360U, 24},
	{3257714176U, 24},
	{3257714688U, 24},
	{3257714944U, 24},
	{3257715200U, 24},
	{3257715456U, 24},
	{3257715712U, 24},
	{3257716736U, 23},
	{3257717504U, 24},
	{3257718528U, 24},
	{3257719296U, 23},
	{3257721344U, 24},
	{3257721856U, 24},
	{3257722368U, 23},
	{3257723904U, 24},
	{3257724416U, 24},
	{3257724672U, 24},
	{3257726976U, 24},
	{3257727232U, 24},
	{3257727488U, 24},
	{3257727744U, 24},
	{3257728768U, 24},
	{3257740544U, 24},
	{3257756160U, 24},
	{3257761536U, 24},
	{3257776128U, 24},
	{3257787136U, 24},
	{3257788416U, 24},
	{3257948160U, 22},
	{3257957376U, 22},
	{3257958400U, 22},
	{3257959424U, 22},
	{3257959424U, 24},
	{3257960448U, 22},
	{3257977856U, 22},
	{3257978880U, 21},
	{3257980928U, 22},
	{3258006528U, 24},
	{3258008320U, 24},
	{3258145792U, 24},
	{3258267904U, 24},
	{3258276864U, 24},
	{3258406400U, 24},
	{3258431232U, 24},
	{3258447360U, 23},
	{3258474752U, 24},
	{3258492160U, 24},
	{3258512384U, 24},
	{3258513920U, 23},
	{3258650624U, 23},
	{3258671104U, 19},
	{3258686464U, 24},
	{3258693120U, 24},
	{3258737152U, 24},
	{3258737664U, 24},
	{3258737920U, 24},
	{3258738176U, 24},
	{3258738432U, 24},
	{3258738688U, 24},
	{3258738944U, 24},
	{3258739200U, 23},
	{3258739712U, 22},
	{3258788096U, 24},
	{3258793728U, 24},
	{3258821888U, 24},
	{3258836480U, 24},
	{3258971648U, 23},
	{3258982144U, 24},
	{3259010560U, 24},
	{3259021056U, 24},
	{3259238400U, 22},
	{3259239424U, 24},
	{3259262464U, 24},
	{3259293184U, 24},
	{3259305984U, 20},
	{3259310080U, 19},
	{3259345152U, 24},
	{3259347456U, 24},
	{3259348224U, 24},
	{3259348480U, 24},
	{3259366656U, 24},
	{3259367424U, 16},
	{3259489792U, 24},
	{3259498496U, 14},
	{3259537920U, 24},
	{3259568128U, 21},
	{3259570176U, 21},
	{3259582976U, 24},
	{3259585536U, 24},
	{3259586048U, 24},
	{3259588096U, 23},
	{3259600896U, 24},
	{3259622400U, 23},
	{3259636736U, 24},
	{3259650048U, 21},
	{3259652096U, 21},
	{3259654144U, 21},
	{3259656192U, 21},
	{3259657216U, 24},
	{3259657984U, 24},
	{3259658240U, 21},
	{3259660288U, 21},
	{3259662336U, 21},
	{3259664384U, 21},
	{3259668480U, 21},
	{3259670528U, 19},
	{3259695104U, 20},
	{3259699200U, 21},
	{3259701248U, 21},
	{3259701760U, 24},
	{3259702016U, 24},
	{3259705344U, 21},
	{3259706368U, 23},
	{3259707392U, 21},
	{3259711488U, 20},
	{3259715584U, 21},
	{3259717632U, 21},
	{3259723776U, 21},
	{3259725824U, 21},
	{3259740672U, 24},
	{3259744256U, 21},
	{3259746304U, 21},
	{3259748352U, 21},
	{3259750400U, 21},
	{3259751424U, 23},
	{3259770880U, 24},
	{3259772160U, 24},
	{3259798016U, 24},
	{3259814656U, 24},
	{3259826176U, 16},
	{3259831552U, 24},
	{3259832832U, 23},
	{3259833344U, 24},
	{3259837952U, 23},
	{3259838464U, 22},
	{3259839488U, 23},
	{3259843328U, 24},
	{3259845632U, 24},
	{3259847168U, 24},
	{3259849216U, 24},
	{3259850240U, 24},
	{3259851008U, 24},
	{3259851264U, 24},
	{3259861760U, 24},
	{3259865344U, 24},
	{3259866112U, 24},
	{3259867136U, 24},
	{3259868160U, 24},
	{3259868416U, 24},
	{3259868928U, 24},
	{3259874560U, 24},
	{3259890944U, 24},
	{3260415488U, 23},
	{3260461056U, 24},
	{3260561920U, 24},
	{3260571648U, 19},
	{3260579840U, 19},
	{3260743680U, 16},
	{3260887552U, 24},
	{3260915712U, 19},
	{3260923904U, 18},
	{3261136896U, 16},
	{3261136896U, 24},
	{3261145344U, 24},
	{3261161472U, 19},
	{3261161728U, 24},
	{3261167104U, 24},
	{3261167616U, 21},
	{3261169664U, 19},
	{3261177856U, 19},
	{3261179904U, 24},
	{3261181440U, 24},
	{3261185280U, 24},
	{3261185536U, 24},
	{3261296384U, 24},
	{3261297408U, 24},
	{3261415424U, 21},
	{3261417472U, 22},
	{3261418496U, 23},
	{3261419008U, 24},
	{3261464576U, 19},
	{3261468672U, 24},
	{3261476096U, 24},
	{3261484800U, 24},
	{3261485056U, 24},
	{3261485312U, 24},
	{3261485568U, 24},
	{3261485824U, 24},
	{3261488384U, 24},
	{3261488640U, 24},
	{3261489920U, 24},
	{3261491968U, 24},
	{3261492224U, 24},
	{3261493504U, 24},
	{3261493760U, 24},
	{3261494272U, 24},
	{3261494528U, 24},
	{3261494784U, 24},
	{3261495040U, 24},
	{3261495296U, 22},
	{3261497088U, 24},
	{3261497856U, 24},
	{3261498112U, 24},
	{3261499648U, 24},
	{3261499904U, 24},
	{3261500160U, 24},
	{3261501440U, 22},
	{3261501440U, 24},
	{3261501696U, 24},
	{3261501952U, 24},
	{3261502208U, 24},
	{3261502464U, 24},
	{3261504768U, 24},
	{3261508096U, 24},
	{3261508608U, 24},
	{3261508864U, 24},
	{3261509120U, 24},
	{3261510400U, 24},
	{3261510912U, 24},
	{3261513728U, 24},
	{3261515520U, 24},
	{3261515776U, 24},
	{3261516032U, 24},
	{3261521920U, 24},
	{3261523968U, 24},
	{3261524224U, 24},
	{3261526016U, 24},
	{3261526528U, 24},
	{3261536000U, 24},
	{3261569024U, 24},
	{3261621248U, 24},
	{3261627392U, 23},
	{3261630976U, 23},
	{3261631488U, 24},
	{3261632000U, 24},
	{3261640448U, 24},
	{3261661440U, 24},
	{3261663232U, 24},
	{3261664256U, 22},
	{3261665280U, 24},
	{3261666304U, 24},
	{3261702144U, 19},
	{3261807616U, 22},
	{3261808640U, 22},
	{3261809664U, 24},
	{3261813248U, 24},
	{3261813504U, 24},
	{3261816832U, 20},
	{3261821440U, 23},
	{3261821952U, 22},
	{3261822976U, 21},
	{3262136320U, 24},
	{3262152704U, 18},
	{3262169088U, 18},
	{3262363136U, 23},
	{3262513152U, 16},
	{3262611456U, 18},
	{3262636032U, 19},
	{3262658304U, 24},
	{3262702592U, 24},
	{3262724096U, 24},
	{3262935040U, 22},
	{3262943488U, 24},
	{3262943744U, 23},
	{3262944256U, 22},
	{3262971392U, 24},
	{3263038720U, 24},
	{3263038976U, 24},
	{3263040256U, 24},
	{3263040512U, 24},
	{3263041280U, 24},
	{3263041536U, 24},
	{3263041792U, 24},
	{3263042048U, 24},
	{3263042560U, 24},
	{3263043328U, 24},
	{3263043584U, 24},
	{3263044352U, 24},
	{3263045120U, 24},
	{3263053824U, 19},
	{3263071488U, 24},
	{3263071744U, 23},
	{3263072256U, 24},
	{3263073280U, 24},
	{3263073792U, 24},
	{3263146752U, 24},
	{3263461888U, 24},
	{3263468800U, 24},
	{3263537152U, 20},
	{3263557632U, 20},
	{3263558144U, 24},
	{3263558400U, 24},
	{3263558656U, 24},
	{3263885312U, 22},
	{3263890944U, 23},
	{3263922176U, 18},
	{3263954944U, 18},
	{3263971328U, 19},
	{3263975424U, 24},
	{3263975936U, 24},
	{3264012288U, 19},
	{3264020992U, 24},
	{3264021248U, 24},
	{3264028672U, 22},
	{3264029696U, 23},
	{3264035584U, 24},
	{3264036864U, 21},
	{3264192512U, 19},
	{3264320256U, 24},
	{3264442368U, 23},
	{3264457472U, 24},
	{3264473600U, 23},
	{3264474112U, 23},
	{3264563200U, 22},
	{3264568064U, 24},
	{3264577536U, 19},
	{3264605184U, 24},
	{3264605440U, 24},
	{3264606976U, 24},
	{3264675840U, 16},
	{3264676352U, 23},
	{3264681984U, 21},
	{3264689152U, 24},
	{3264708608U, 19},
	{3264732160U, 24},
	{3264774144U, 19},
	{3264826368U, 23},
	{3264828160U, 24},
	{3264828928U, 23},
	{3264832000U, 24},
	{3264832256U, 24},
	{3264834048U, 24},
	{3264839936U, 24},
	{3264840704U, 24},
	{3264841728U, 21},
	{3264844288U, 24},
	{3264844544U, 24},
	{3264845312U, 24},
	{3264847872U, 21},
	{3264851968U, 21},
	{3264865024U, 24},
	{3264865536U, 24},
	{3264866048U, 24},
	{3264866816U, 24},
	{3264867328U, 24},
	{3264868608U, 24},
	{3264869120U, 24},
	{3264869376U, 24},
	{3264870912U, 24},
	{3264871424U, 24},
	{3264871680U, 24},
	{3264872192U, 24},
	{3264872448U, 19},
	{3264905216U, 21},
	{3264907264U, 22},
	{3264908288U, 22},
	{3264909312U, 22},
	{3264910336U, 24},
	{3264910592U, 24},
	{3264911360U, 21},
	{3264913408U, 19},
	{3264921600U, 19},
	{3265010688U, 24},
	{3265167360U, 19},
	{3265175552U, 19},
	{3265183744U, 19},
	{3265184256U, 24},
	{3265184512U, 24},
	{3265191936U, 19},
	{3265198592U, 23},
	{3265199104U, 24},
	{3265200128U, 16},
	{3265218560U, 23},
	{3265257472U, 21},
	{3265370624U, 24},
	{3265382400U, 23},
	{3265382400U, 24},
	{3265382656U, 24},
	{3265480192U, 24},
	{3265529600U, 24},
	{3265609728U, 19},
	{3265642496U, 19},
	{3265646848U, 24},
	{3265789952U, 16},
	{3266011136U, 21},
	{3266204672U, 23},
	{3266404352U, 19},
	{3266580992U, 24},
	{3266582784U, 24},
	{3266609152U, 24},
	{3266805760U, 19},
	{3266813952U, 19},
	{3266822144U, 19},
	{3266827008U, 24},
	{3266828800U, 24},
	{3266830336U, 19},
	{3266904064U, 16},
	{3266910464U, 24},
	{3267432704U, 24},
	{3267493888U, 16},
	{3267584000U, 19},
	{3267624960U, 16},
	{3267636992U, 24},
	{3267675136U, 24},
	{3267688448U, 24},
	{3268018176U, 22},
	{3268018176U, 23},
	{3268019200U, 23},
	{3268135168U, 24},
	{3268345344U, 24},
	{3268411392U, 16},
	{3268475392U, 24},
	{3268504576U, 24},
	{3268514304U, 24},
	{3268524288U, 24},
	{3268755456U, 19},
	{3268950784U, 24},
	{3268978688U, 24},
	{3269001216U, 16},
	{3269024768U, 24},
	{3269057536U, 23},
	{3269263360U, 16},
	{3269305344U, 24},
	{3269317632U, 24},
	{3269328896U, 16},
	{3269525504U, 16},
	{3269621760U, 22},
	{3269622784U, 23},
	{3269853184U, 16},
	{3269872640U, 24},
	{3269878528U, 24},
	{3269918720U, 16},
	{3269932544U, 24},
	{3269945600U, 24},
	{3269960704U, 23},
	{3269961728U, 24},
	{3269970176U, 24},
	{3269979136U, 22},
	{3269980672U, 23},
	{3269981696U, 24},
	{3269983744U, 23},
	{3269984256U, 16},
	{3270009344U, 23},
	{3270073344U, 24},
	{3270184704U, 24},
	{3270194944U, 24},
	{3270217472U, 24},
	{3270377472U, 16},
	{3270651136U, 24},
	{3270654464U, 24},
	{3270656000U, 19},
	{3270926336U, 24},
	{3270967296U, 19},
	{3270983680U, 19},
	{3271393792U, 24},
	{3271720960U, 19},
	{3271781376U, 23},
	{3271819264U, 16},
	{3271821824U, 24},
	{3271835904U, 24},
	{3271836416U, 24},
	{3271836672U, 23},
	{3271838464U, 24},
	{3271838720U, 24},
	{3271839488U, 24},
	{3271852032U, 20},
	{3271884800U, 19},
	{3271892992U, 19},
	{3271901184U, 19},
	{3272073216U, 19},
	{3272108544U, 23},
	{3272237056U, 19},
	{3272278016U, 16},
	{3272335360U, 19},
	{3272343552U, 19},
	{3272392704U, 19},
	{3272425472U, 18},
	{3272605696U, 19},
	{3272622080U, 19},
	{3272638464U, 19},
	{3272663040U, 19},
	{3272753152U, 18},
	{3272925184U, 19},
	{3272998912U, 19},
	{3273146368U, 19},
	{3273179136U, 19},
	{3273277440U, 19},
	{3273285632U, 19},
	{3273310208U, 19},
	{3273337856U, 24},
	{3273351936U, 24},
	{3273352192U, 24},
	{3273449472U, 19},
	{3273523200U, 16},
	{3273687040U, 17},
	{3273719808U, 16},
	{3273724416U, 24},
	{3273736192U, 24},
	{3273744384U, 19},
	{3273768960U, 18},
	{3273826304U, 19},
	{3273872384U, 23},
	{3273878016U, 24},
	{3273879040U, 24},
	{3273879296U, 24},
	{3273883136U, 24},
	{3274051584U, 24},
	{3274051840U, 24},
	{3274052096U, 24},
	{3274052352U, 24},
	{3274063872U, 19},
	{3274096640U, 18},
	{3274368512U, 24},
	{3274371072U, 21},
	{3274571776U, 21},
	{3274573824U, 21},
	{3274575872U, 20},
	{3274604544U, 19},
	{3274604544U, 21},
	{3274607872U, 24},
	{3274608128U, 24},
	{3274612480U, 24},
	{3274629120U, 19},
	{3274915840U, 24},
	{3274944000U, 23},
	{3274944512U, 23},
	{3274945536U, 24},
	{3275120640U, 19},
	{3275153408U, 19},
	{3275390976U, 19},
	{3275407360U, 19},
	{3275489280U, 19},
	{3275563008U, 24},
	{3275566592U, 24},
	{3275570432U, 24},
	{3275636736U, 19},
	{3275751424U, 19},
	{3275823104U, 24},
	{3275857408U, 24},
	{3275915264U, 19},
	{3275931648U, 19},
	{3275939840U, 19},
	{3276161024U, 19},
	{3276169216U, 19},
	{3276283904U, 19},
	{3276308480U, 19},
	{3276316672U, 19},
	{3276431360U, 19},
	{3276439552U, 19},
	{3276464128U, 19},
	{3276472320U, 16},
	{3276484096U, 24},
	{3276701696U, 19},
	{3276775680U, 24},
	{3276778240U, 24},
	{3276800000U, 19},
	{3276808192U, 19},
	{3276849152U, 19},
	{3276875776U, 23},
	{3276939264U, 19},
	{3276947456U, 19},
	{3276963840U, 19},
	{3276988416U, 19},
	{3277193216U, 16},
	{3277258752U, 16},
	{3277326848U, 23},
	{3277328640U, 24},
	{3277335040U, 24},
	{3277335296U, 24},
	{3277335552U, 23},
	{3277336064U, 24},
	{3277355008U, 24},
	{3277355776U, 24},
	{3277361664U, 24},
	{3277365248U, 22},
	{3277471744U, 19},
	{3277504512U, 19},
	{3277512704U, 19},
	{3277651968U, 17},
	{3277660160U, 20},
	{3277664256U, 20},
	{3277668352U, 20},
	{3277672448U, 20},
	{3277717504U, 24},
	{3277717760U, 24},
	{3277718016U, 24},
	{3277718272U, 24},
	{3277718528U, 24},
	{3277718784U, 24},
	{3277719040U, 24},
	{3277733888U, 19},
	{3277783040U, 18},
	{3277799424U, 19},
	{3277807616U, 19},
	{3277815808U, 21},
	{3277821952U, 21},
	{3277824000U, 20},
	{3277848576U, 19},
	{3277854464U, 24},
	{3277856768U, 19},
	{3277881344U, 19},
	{3277914112U, 17},
	{3277936384U, 24},
	{3277943808U, 22},
	{3278028800U, 19},
	{3278045184U, 16},
	{3278047232U, 21},
	{3278049280U, 21},
	{3278051328U, 21},
	{3278053376U, 21},
	{3278061568U, 20},
	{3278062848U, 24},
	{3278065664U, 21},
	{3278067712U, 21},
	{3278068992U, 24},
	{3278069760U, 21},
	{3278071808U, 21},
	{3278073856U, 21},
	{3278094336U, 21},
	{3278096384U, 21},
	{3278097920U, 24},
	{3278098432U, 21},
	{3278102528U, 21},
	{3278104576U, 21},
	{3278108672U, 21},
	{3278110720U, 16},
	{3278241792U, 16},
	{3278306560U, 24},
	{3278556672U, 23},
	{3278807040U, 19},
	{3278815232U, 19},
	{3278897152U, 18},
	{3278913536U, 19},
	{3279486976U, 16},
	{3279618048U, 16},
	{3280011776U, 24},
	{3280019968U, 23},
	{3280041472U, 24},
	{3280117760U, 19},
	{3280404480U, 17},
	{3280437248U, 18},
	{3280479744U, 24},
	{3280625664U, 20},
	{3280631808U, 22},
	{3280632832U, 22},
	{3280633856U, 21},
	{3280633856U, 24},
	{3280634112U, 24},
	{3280634368U, 24},
	{3280634624U, 24},
	{3280634880U, 24},
	{3280635136U, 24},
	{3280635392U, 24},
	{3280635648U, 24},
	{3280635904U, 23},
	{3280635904U, 24},
	{3280636928U, 22},
	{3280636928U, 24},
	{3280637184U, 24},
	{3280637440U, 24},
	{3280637696U, 24},
	{3280637952U, 20},
	{3280637952U, 24},
	{3280638208U, 24},
	{3280638464U, 24},
	{3280638720U, 24},
	{3280638976U, 24},
	{3280639232U, 24},
	{3280639488U, 24},
	{3280639744U, 24},
	{3280640000U, 24},
	{3280640512U, 24},
	{3280640768U, 24},
	{3280641024U, 24},
	{3280641280U, 24},
	{3280641536U, 24},
	{3280641792U, 24},
	{3280658176U, 24},
	{3280658432U, 19},
	{3280797696U, 16},
	{3280799488U, 24},
	{3280805632U, 24},
	{3280839168U, 24},
	{3280847616U, 24},
	{3280849152U, 24},
	{3281010688U, 19},
	{3281133568U, 19},
	{3281190912U, 16},
	{3281321984U, 18},
	{3281756416U, 24},
	{3282173952U, 19},
	{3282190336U, 19},
	{3282198528U, 19},
	{3282214912U, 19},
	{3282231296U, 19},
	{3282239488U, 17},
	{3282272256U, 19},
	{3282280448U, 20},
	{3282284544U, 20},
	{3282468864U, 19},
	{3282493440U, 24},
	{3282493696U, 24},
	{3282493952U, 24},
	{3282494208U, 24},
	{3282494464U, 24},
	{3282494720U, 24},
	{3282494976U, 24},
	{3282495232U, 24},
	{3282495488U, 24},
	{3282501632U, 17},
	{3282534400U, 19},
	{3282539776U, 24},
	{3282542592U, 20},
	{3282546688U, 20},
	{3282550784U, 20},
	{3282554880U, 20},
	{3282558976U, 21},
	{3282565120U, 21},
	{3282698240U, 19},
	{3282714624U, 19},
	{3282763776U, 16},
	{3282771968U, 22},
	{3282772992U, 22},
	{3282775040U, 22},
	{3282776064U, 22},
	{3282777088U, 22},
	{3282778112U, 22},
	{3282779136U, 23},
	{3282779648U, 23},
	{3282780160U, 23},
	{3282785280U, 24},
	{3282785536U, 24},
	{3282785792U, 24},
	{3282786304U, 21},
	{3282789376U, 22},
	{3282894848U, 16},
	{3282952192U, 19},
	{3283124224U, 22},
	{3283127040U, 24},
	{3283131392U, 23},
	{3283255296U, 19},
	{3283484672U, 19},
	{3283509248U, 19},
	{3283550208U, 16},
	{3283632128U, 19},
	{3283648512U, 19},
	{3283649536U, 24},
	{3283650816U, 24},
	{3283653120U, 24},
	{3283653376U, 24},
	{3283656192U, 24},
	{3283656448U, 24},
	{3283673088U, 19},
	{3283892224U, 24},
	{3283907072U, 24},
	{3283968000U, 19},
	{3283976192U, 19},
	{3283992576U, 19},
	{3284000768U, 19},
	{3284017152U, 19},
	{3284049920U, 19},
	{3284680704U, 19},
	{3284682496U, 24},
	{3284697088U, 19},
	{3284811776U, 19},
	{3284828160U, 19},
	{3284836352U, 19},
	{3284844544U, 18},
	{3285073920U, 19},
	{3285098496U, 19},
	{3285106688U, 24},
	{3285106944U, 24},
	{3285107200U, 24},
	{3285107456U, 24},
	{3285188608U, 21},
	{3285319680U, 19},
	{3285393920U, 23},
	{3285410560U, 24},
	{3285450752U, 16},
	{3285516288U, 16},
	{3285868544U, 19},
	{3286122496U, 19},
	{3286122496U, 24},
	{3286155264U, 18},
	{3286237184U, 16},
	{3286368256U, 22},
	{3286401024U, 19},
	{3286433792U, 16},
	{3286630400U, 22},
	{3286631424U, 23},
	{3286631936U, 24},
	{3286632192U, 24},
	{3286632448U, 21},
	{3286634496U, 20},
	{3287187456U, 19},
	{3287285760U, 16},
	{3287351296U, 16},
	{3287588864U, 19},
	{3287597056U, 19},
	{3287605248U, 19},
	{3287678976U, 19},
	{3287703552U, 19},
	{3287719936U, 19},
	{3287729920U, 24},
	{3287731200U, 23},
	{3287731712U, 23},
	{3287818240U, 19},
	{3287851008U, 19},
	{3287965696U, 19},
	{3288408064U, 24},
	{3288426240U, 24},
	{3288433152U, 24},
	{3288433408U, 24},
	{3288433664U, 24},
	{3288433920U, 24},
	{3288465408U, 24},
	{3288465664U, 24},
	{3288530944U, 21},
	{3288542976U, 24},
	{3288544000U, 24},
	{3288544256U, 24},
	{3288544512U, 24},
	{3288544768U, 24},
	{3288555264U, 24},
	{3288559872U, 24},
	{3288560128U, 24},
	{3288560384U, 24},
	{3288562688U, 22},
	{3288563712U, 22},
	{3288570880U, 23},
	{3288571648U, 24},
	{3288578048U, 21},
	{3288596480U, 24},
	{3288601600U, 22},
	{3288602624U, 22},
	{3288603648U, 23},
	{3288611328U, 24},
	{3288612096U, 24},
	{3288612352U, 23},
	{3288612864U, 22},
	{3288614400U, 24},
	{3288614656U, 24},
	{3288614912U, 22},
	{3288615936U, 24},
	{3288617216U, 24},
	{3288617728U, 24},
	{3288617984U, 24},
	{3288618752U, 24},
	{3288619008U, 22},
	{3288620032U, 23},
	{3288620800U, 24},
	{3288621056U, 24},
	{3288621312U, 24},
	{3288622080U, 22},
	{3288623104U, 24},
	{3288633088U, 24},
	{3288633344U, 24},
	{3288633600U, 24},
	{3288633856U, 24},
	{3288637440U, 23},
	{3288637952U, 23},
	{3288638464U, 24},
	{3288638720U, 24},
	{3288639488U, 24},
	{3288640512U, 24},
	{3288640768U, 24},
	{3288641024U, 23},
	{3288641536U, 21},
	{3288643584U, 22},
	{3288644608U, 24},
	{3288650752U, 22},
	{3288651776U, 21},
	{3288653824U, 21},
	{3288655872U, 21},
	{3288657664U, 24},
	{3288657920U, 21},
	{3288657920U, 24},
	{3288658176U, 24},
	{3288658432U, 24},
	{3288658688U, 24},
	{3288658944U, 24},
	{3288659200U, 24},
	{3288659456U, 24},
	{3288659712U, 24},
	{3288659968U, 24},
	{3288660480U, 23},
	{3288662016U, 16},
	{3288727808U, 24},
	{3288758528U, 24},
	{3288765696U, 24},
	{3288765952U, 24},
	{3288766208U, 24},
	{3288766720U, 24},
	{3288772352U, 24},
	{3288772608U, 23},
	{3288773120U, 24},
	{3288774400U, 24},
	{3288774656U, 24},
	{3288777728U, 24},
	{3288778240U, 24},
	{3288778496U, 24},
	{3288779008U, 24},
	{3288780800U, 24},
	{3288781568U, 24},
	{3288781824U, 23},
	{3288781824U, 24},
	{3288782080U, 24},
	{3288782336U, 24},
	{3288783872U, 23},
	{3288784384U, 23},
	{3288788224U, 24},
	{3288789248U, 24},
	{3288789504U, 24},
	{3288789760U, 24},
	{3288791808U, 24},
	{3288880896U, 24},
	{3288881152U, 24},
	{3288883968U, 24},
	{3288884224U, 24},
	{3288884480U, 24},
	{3288884992U, 24},
	{3288885248U, 24},
	{3288885760U, 24},
	{3288888064U, 24},
	{3288924160U, 16},
	{3289002752U, 24},
	{3289014272U, 24},
	{3289015552U, 24},
	{3289016320U, 24},
	{3289016832U, 24},
	{3289017088U, 24},
	{3289017344U, 24},
	{3289017856U, 24},
	{3289018112U, 24},
	{3289018368U, 22},
	{3289019392U, 24},
	{3289019648U, 24},
	{3289019904U, 24},
	{3289020160U, 24},
	{3289020672U, 24},
	{3289020928U, 23},
	{3289021440U, 22},
	{3289022976U, 23},
	{3289023488U, 22},
	{3289024512U, 22},
	{3289025536U, 22},
	{3289028096U, 23},
	{3289028608U, 21},
	{3289030656U, 19},
	{3289038848U, 21},
	{3289041664U, 24},
	{3289041920U, 24},
	{3289042176U, 24},
	{3289042432U, 24},
	{3289042688U, 24},
	{3289042944U, 24},
	{3289043200U, 24},
	{3289043456U, 24},
	{3289043712U, 24},
	{3289043968U, 24},
	{3289044224U, 24},
	{3289047040U, 24},
	{3289048320U, 24},
	{3289048832U, 24},
	{3289053184U, 23},
	{3289053440U, 24},
	{3289053952U, 24},
	{3289054208U, 23},
	{3289054720U, 24},
	{3289055232U, 20},
	{3289059328U, 21},
	{3289061376U, 22},
	{3289062400U, 23},
	{3289062912U, 24},
	{3289065472U, 21},
	{3289069824U, 24},
	{3289070080U, 24},
	{3289070848U, 24},
	{3289072896U, 24},
	{3289073152U, 24},
	{3289073664U, 24},
	{3289083136U, 24},
	{3289083392U, 23},
	{3289083904U, 23},
	{3289084416U, 24},
	{3289084928U, 24},
	{3289086464U, 24},
	{3289086976U, 24},
	{3289087232U, 24},
	{3289087488U, 24},
	{3289087744U, 24},
	{3289088000U, 24},
	{3289088256U, 24},
	{3289088512U, 24},
	{3289088768U, 24},
	{3289089280U, 24},
	{3289089536U, 24},
	{3289089792U, 24},
	{3289090048U, 21},
	{3289092096U, 23},
	{3289092608U, 23},
	{3289093120U, 23},
	{3289098752U, 23},
	{3289099264U, 23},
	{3289099776U, 24},
	{3289103360U, 23},
	{3289103360U, 24},
	{3289103872U, 24},
	{3289104384U, 22},
	{3289105408U, 24},
	{3289105664U, 24},
	{3289106432U, 22},
	{3289107456U, 24},
	{3289108736U, 24},
	{3289114880U, 24},
	{3289116416U, 24},
	{3289116672U, 24},
	{3289116928U, 24},
	{3289117440U, 24},
	{3289117952U, 24},
	{3289119488U, 24},
	{3289124864U, 24},
	{3289128960U, 19},
	{3289161728U, 24},
	{3289162240U, 24},
	{3289162496U, 24},
	{3289163264U, 24},
	{3289163520U, 24},
	{3289166336U, 24},
	{3289167104U, 24},
	{3289168640U, 24},
	{3289186560U, 24},
	{3289186816U, 23},
	{3289187328U, 22},
	{3289188352U, 21},
	{3289190400U, 21},
	{3289192448U, 22},
	{3289193472U, 23},
	{3289193984U, 24},
	{3289194240U, 24},
	{3289194496U, 19},
	{3289202688U, 20},
	{3289206784U, 24},
	{3289210112U, 24},
	{3289211136U, 24},
	{3289212160U, 24},
	{3289212416U, 23},
	{3289212928U, 24},
	{3289213952U, 24},
	{3289215232U, 24},
	{3289217280U, 24},
	{3289218304U, 24},
	{3289218560U, 24},
	{3289218816U, 24},
	{3289219072U, 22},
	{3289220096U, 24},
	{3289221632U, 24},
	{3289221888U, 24},
	{3289222144U, 22},
	{3289223168U, 22},
	{3289224704U, 24},
	{3289224960U, 24},
	{3289225216U, 21},
	{3289227264U, 24},
	{3289228032U, 24},
	{3289228288U, 24},
	{3289228544U, 24},
	{3289229568U, 24},
	{3289230848U, 23},
	{3289231360U, 21},
	{3289233408U, 23},
	{3289234176U, 24},
	{3289234432U, 22},
	{3289235456U, 22},
	{3289236480U, 24},
	{3289237504U, 22},
	{3289238528U, 24},
	{3289240832U, 24},
	{3289241088U, 23},
	{3289241600U, 23},
	{3289243904U, 24},
	{3289244160U, 23},
	{3289244672U, 22},
	{3289245696U, 24},
	{3289250816U, 22},
	{3289251840U, 16},
	{3289350144U, 17},
	{3289710592U, 16},
	{3289776128U, 22},
	{3289776640U, 24},
	{3289776896U, 24},
	{3289784320U, 24},
	{3289817088U, 19},
	{3289817600U, 24},
	{3289818624U, 24},
	{3289819648U, 24},
	{3289821184U, 24},
	{3289822464U, 24},
	{3289822720U, 24},
	{3289822976U, 24},
	{3289824512U, 24},
	{3289829120U, 24},
	{3289841664U, 16},
	{3289907200U, 16},
	{3289972736U, 16},
	{3290038272U, 16},
	{3290107648U, 24},
	{3290108672U, 24},
	{3290114048U, 22},
	{3290116096U, 22},
	{3290170624U, 24},
	{3290171392U, 24},
	{3290173440U, 20},
	{3290177536U, 20},
	{3290185728U, 19},
	{3290193920U, 19},
	{3290236416U, 24},
	{3290431488U, 21},
	{3290447872U, 19},
	{3290449408U, 24},
	{3290449920U, 24},
	{3290450688U, 24},
	{3290451456U, 24},
	{3290451712U, 24},
	{3290468352U, 24},
	{3290497024U, 16},
	{3290562560U, 15},
	{3290693632U, 16},
	{3290759168U, 16},
	{3290824704U, 16},
	{3290890240U, 17},
	{3290966016U, 22},
	{3290968064U, 22},
	{3290969088U, 22},
	{3291021312U, 19},
	{3291062272U, 20},
	{3291064832U, 24},
	{3291065088U, 24},
	{3291152384U, 18},
	{3291217920U, 19},
	{3291234304U, 19},
	{3321958400U, 21},
	{3321960448U, 23},
	{3321962496U, 20},
	{3321966592U, 22},
	{3322089472U, 20},
	{3322109952U, 21},
	{3322116608U, 24},
	{3322117120U, 24},
	{3322118144U, 24},
	{3322162176U, 24},
	{3322167296U, 20},
	{3322174976U, 24},
	{3322217984U, 24},
	{3322231552U, 24},
	{3322232064U, 24},
	{3322273280U, 23},
	{3322281472U, 24},
	{3322286080U, 24},
	{3322302464U, 24},
	{3322306304U, 24},
	{3322332160U, 24},
	{3322332672U, 24},
	{3322344704U, 24},
	{3322345472U, 24},
	{3322345728U, 24},
	{3322347264U, 24},
	{3322347520U, 21},
	{3322363904U, 19},
	{3322380288U, 18},
	{3322417152U, 20},
	{3322421248U, 20},
	{3322421248U, 24},
	{3322421760U, 24},
	{3322422016U, 24},
	{3322422272U, 24},
	{3322422528U, 24},
	{3322422784U, 24},
	{3322423040U, 24},
	{3322423296U, 24},
	{3322423808U, 24},
	{3322424064U, 24},
	{3322424576U, 24},
	{3322424832U, 24},
	{3322425344U, 21},
	{3322427392U, 24},
	{3322429440U, 22},
	{3322430464U, 23},
	{3322530048U, 24},
	{3322610688U, 22},
	{3322613760U, 20},
	{3322617856U, 19},
	{3322624256U, 24},
	{3322624512U, 24},
	{3322814464U, 19},
	{3323004160U, 24},
	{3323012352U, 24},
	{3323012864U, 24},
	{3323013120U, 24},
	{3323014656U, 24},
	{3323014912U, 24},
	{3323017472U, 24},
	{3323017984U, 24},
	{3323018752U, 24},
	{3323027712U, 24},
	{3323028736U, 24},
	{3323030272U, 24},
	{3323038208U, 24},
	{3323040000U, 24},
	{3323041280U, 23},
	{3323044864U, 24},
	{3323046144U, 24},
	{3323047936U, 24},
	{3323049728U, 24},
	{3323049984U, 24},
	{3323050496U, 24},
	{3323051008U, 24},
	{3323051264U, 24},
	{3323051520U, 24},
	{3323051776U, 24},
	{3323052032U, 23},
	{3323052544U, 24},
	{3323054080U, 24},
	{3323057920U, 24},
	{3323058176U, 24},
	{3323059968U, 24},
	{3323063040U, 24},
	{3323063808U, 24},
	{3323064832U, 24},
	{3323065088U, 24},
	{3323066112U, 24},
	{3323066624U, 24},
	{3323067136U, 24},
	{3323331840U, 24},
	{3323332096U, 23},
	{3323332608U, 23},
	{3323333376U, 24},
	{3323333632U, 22},
	{3323335424U, 24},
	{3323337728U, 24},
	{3323341056U, 24},
	{3323341568U, 24},
	{3323346176U, 24},
	{3323346432U, 23},
	{3323346944U, 22},
	{3323355904U, 24},
	{3323358464U, 24},
	{3323361536U, 24},
	{3323362048U, 24},
	{3323363584U, 24},
	{3323365632U, 24},
	{3323366400U, 22},
	{3323367936U, 24},
	{3323370240U, 24},
	{3323373568U, 24},
	{3323375616U, 24},
	{3323386112U, 24},
	{3323386368U, 23},
	{3323386880U, 23},
	{3323387392U, 24},
	{3323389184U, 24},
	{3323389440U, 24},
	{3323394304U, 24},
	{3323463168U, 24},
	{3323533312U, 24},
	{3323536128U, 24},
	{3323537920U, 24},
	{3323539456U, 24},
	{3323539968U, 24},
	{3323544320U, 24},
	{3323545600U, 24},
	{3323553280U, 24},
	{3323563264U, 24},
	{3323563520U, 24},
	{3323563776U, 24},
	{3323564544U, 24},
	{3323565568U, 24},
	{3323569920U, 24},
	{3323570176U, 24},
	{3323570432U, 24},
	{3323575296U, 24},
	{3323575808U, 24},
	{3323576064U, 24},
	{3323576320U, 24},
	{3323577088U, 24},
	{3323577600U, 24},
	{3323577856U, 24},
	{3323578112U, 24},
	{3323578880U, 24},
	{3323580672U, 24},
	{3323586048U, 24},
	{3323586304U, 24},
	{3323586560U, 24},
	{3323587584U, 24},
	{3323587840U, 24},
	{3323588352U, 24},
	{3323588608U, 24},
	{3323589120U, 24},
	{3323589376U, 24},
	{3323636480U, 24},
	{3323636736U, 24},
	{3323636992U, 24},
	{3323637248U, 24},
	{3323637504U, 24},
	{3323638016U, 24},
	{3323638272U, 24},
	{3323638784U, 24},
	{3323639040U, 24},
	{3323639296U, 24},
	{3323639552U, 24},
	{3323640320U, 24},
	{3323640576U, 24},
	{3323640832U, 24},
	{3323641600U, 24},
	{3323641856U, 24},
	{3323643648U, 24},
	{3323650816U, 24},
	{3323656192U, 24},
	{3323662848U, 24},
	{3323664384U, 24},
	{3323756544U, 24},
	{3323789312U, 22},
	{3323854848U, 16},
	{3323922688U, 24},
	{3323928320U, 24},
	{3323960832U, 23},
	{3323985920U, 23},
	{3323996160U, 24},
	{3324029440U, 23},
	{3324041216U, 24},
	{3324043264U, 24},
	{3324046336U, 24},
	{3324182784U, 24},
	{3324183040U, 24},
	{3324183296U, 24},
	{3324183552U, 24},
	{3324183808U, 24},
	{3324184064U, 24},
	{3324184320U, 24},
	{3324184576U, 24},
	{3324184832U, 24},
	{3324185088U, 24},
	{3324185344U, 24},
	{3324185600U, 24},
	{3324185856U, 24},
	{3324186112U, 24},
	{3324186368U, 24},
	{3324215296U, 24},
	{3324252160U, 21},
	{3324254208U, 22},
	{3324317696U, 21},
	{3324319744U, 22},
	{3324381184U, 22},
	{3324382208U, 24},
	{3324514304U, 21},
	{3324516352U, 22},
	{3324517376U, 23},
	{3324517888U, 24},
	{3324575744U, 24},
	{3324576000U, 24},
	{3324576512U, 24},
	{3324577024U, 24},
	{3324577280U, 24},
	{3324577792U, 24},
	{3324578048U, 24},
	{3324578304U, 24},
	{3324578560U, 24},
	{3324579072U, 24},
	{3324732416U, 24},
	{3324767488U, 24},
	{3324842496U, 24},
	{3324843008U, 24},
	{3324843520U, 24},
	{3324843776U, 24},
	{3324844032U, 24},
	{3324903424U, 21},
	{3324905472U, 24},
	{3324905728U, 24},
	{3325038592U, 23},
	{3325038592U, 24},
	{3325038848U, 24},
	{3325050880U, 19},
	{3325053952U, 22},
	{3325057536U, 23},
	{3325105664U, 24},
	{3325111552U, 24},
	{3325123584U, 23},
	{3325126400U, 24},
	{3325129216U, 24},
	{3325136640U, 24},
	{3325136896U, 23},
	{3325138944U, 23},
	{3325143040U, 23},
	{3325144576U, 24},
	{3325146112U, 24},
	{3325146624U, 24},
	{3325152512U, 24},
	{3325153280U, 24},
	{3325156864U, 24},
	{3325158656U, 24},
	{3325161216U, 24},
	{3325161472U, 24},
	{3325161728U, 24},
	{3325164032U, 24},
	{3325167872U, 24},
	{3325234432U, 24},
	{3325237504U, 24},
	{3325237760U, 23},
	{3325238272U, 23},
	{3325238784U, 24},
	{3325240064U, 24},
	{3325249536U, 24},
	{3325254144U, 24},
	{3325254912U, 24},
	{3325255168U, 24},
	{3325259008U, 24},
	{3325267200U, 24},
	{3325278208U, 23},
	{3325280000U, 24},
	{3325280256U, 24},
	{3325280512U, 24},
	{3325284608U, 24},
	{3325284864U, 24},
	{3325285888U, 24},
	{3325286144U, 24},
	{3325292032U, 24},
	{3325292288U, 24},
	{3325292800U, 24},
	{3325293312U, 24},
	{3325293568U, 24},
	{3325294848U, 24},
	{3325295616U, 24},
	{3325295872U, 24},
	{3325296128U, 24},
	{3325296640U, 22},
	{3325432832U, 22},
	{3325433856U, 21},
	{3325435904U, 21},
	{3325437952U, 23},
	{3325442560U, 24},
	{3325444096U, 24},
	{3325444352U, 24},
	{3325444608U, 24},
	{3325445120U, 24},
	{3325445888U, 24},
	{3325446144U, 22},
	{3325448192U, 24},
	{3325448704U, 24},
	{3325448960U, 24},
	{3325449216U, 24},
	{3325450752U, 23},
	{3325451264U, 24},
	{3325465856U, 24},
	{3325467136U, 23},
	{3325467648U, 22},
	{3325468672U, 23},
	{3325469184U, 24},
	{3325469440U, 24},
	{3325469952U, 24},
	{3325471232U, 24},
	{3325472000U, 24},
	{3325472256U, 24},
	{3325474816U, 22},
	{3325475840U, 23},
	{3325476864U, 22},
	{3325477888U, 24},
	{3325479424U, 24},
	{3325483776U, 24},
	{3325484544U, 23},
	{3325485312U, 24},
	{3325492480U, 24},
	{3325494272U, 24},
	{3325495296U, 21},
	{3325510912U, 24},
	{3325514496U, 24},
	{3325514752U, 24},
	{3325515008U, 24},
	{3325515264U, 24},
	{3325515520U, 24},
	{3325516032U, 24},
	{3325517056U, 24},
	{3325558784U, 21},
	{3325689856U, 24},
	{3325690112U, 24},
	{3325690624U, 24},
	{3325690880U, 23},
	{3325693952U, 21},
	{3325696000U, 22},
	{3325755904U, 24},
	{3325757184U, 24},
	{3325765632U, 24},
	{3325767168U, 24},
	{3325767424U, 24},
	{3325767680U, 24},
	{3325767936U, 24},
	{3325769216U, 24},
	{3325769472U, 24},
	{3325771008U, 24},
	{3325773056U, 24},
	{3325773312U, 24},
	{3325776128U, 24},
	{3325776384U, 24},
	{3325776640U, 24},
	{3325777664U, 24},
	{3325778176U, 24},
	{3325779200U, 24},
	{3325825280U, 24},
	{3325842688U, 24},
	{3325842944U, 23},
	{3325843456U, 22},
	{3325844480U, 24},
	{3325844736U, 24},
	{3325845248U, 24},
	{3325847552U, 24},
	{3325851904U, 24},
	{3325852160U, 23},
	{3325852672U, 22},
	{3325857536U, 24},
	{3325885184U, 24},
	{3325890560U, 20},
	{3325954048U, 24},
	{3325954304U, 24},
	{3325954560U, 24},
	{3325954816U, 24},
	{3325968384U, 24},
	{3325968640U, 24},
	{3325968896U, 24},
	{3325969920U, 24},
	{3325970688U, 24},
	{3325971200U, 24},
	{3325973504U, 24},
	{3325974016U, 24},
	{3325977088U, 24},
	{3325978624U, 24},
	{3325979136U, 24},
	{3325980672U, 24},
	{3325986560U, 24},
	{3325987072U, 24},
	{3325987328U, 24},
	{3325991680U, 24},
	{3325995264U, 24},
	{3325998336U, 24},
	{3325999616U, 24},
	{3325999872U, 24},
	{3326002688U, 24},
	{3326004224U, 24},
	{3326005504U, 24},
	{3326005760U, 24},
	{3326006272U, 24},
	{3326010880U, 24},
	{3326011136U, 24},
	{3326011392U, 24},
	{3326011648U, 24},
	{3326012416U, 24},
	{3326013952U, 24},
	{3326014976U, 23},
	{3326015488U, 23},
	{3326016000U, 24},
	{3326017536U, 16},
	{3326023680U, 24},
	{3326033920U, 24},
	{3326034176U, 24},
	{3326066944U, 24},
	{3326070016U, 24},
	{3326070784U, 22},
	{3326075648U, 24},
	{3326083072U, 15},
	{3326115584U, 24},
	{3326199552U, 24},
	{3326214144U, 16},
	{3326283520U, 24},
	{3326289408U, 24},
	{3326345216U, 19},
	{3326347008U, 24},
	{3326350080U, 24},
	{3326350336U, 23},
	{3326350848U, 23},
	{3326352640U, 24},
	{3326361600U, 18},
	{3326377984U, 20},
	{3326387200U, 22},
	{3326388224U, 21},
	{3326391552U, 24},
	{3326402560U, 20},
	{3326407680U, 24},
	{3326411264U, 23},
	{3326417408U, 24},
	{3326431232U, 23},
	{3326431744U, 24},
	{3326432256U, 22},
	{3326433280U, 21},
	{3326433792U, 24},
	{3326444288U, 24},
	{3326445056U, 24},
	{3326457856U, 23},
	{3326458368U, 23},
	{3326458880U, 22},
	{3326459648U, 24},
	{3326489088U, 24},
	{3326521344U, 20},
	{3326526208U, 24},
	{3326526464U, 22},
	{3326529792U, 24},
	{3326532608U, 23},
	{3326533120U, 23},
	{3326533632U, 20},
	{3326537728U, 23},
	{3326538240U, 24},
	{3326538496U, 24},
	{3326538752U, 23},
	{3326607360U, 22},
	{3326608640U, 24},
	{3326609408U, 22},
	{3326610432U, 24},
	{3326615552U, 21},
	{3326681600U, 23},
	{3326682112U, 22},
	{3326683136U, 21},
	{3326685184U, 22},
	{3326693888U, 24},
	{3326737664U, 24},
	{3326744832U, 24},
	{3326745088U, 24},
	{3326746624U, 21},
	{3326748672U, 23},
	{3326876160U, 23},
	{3326876672U, 24},
	{3326876928U, 24},
	{3326877184U, 24},
	{3326877440U, 24},
	{3326901760U, 23},
	{3326910976U, 24},
	{3326911744U, 24},
	{3326914560U, 23},
	{3326915072U, 24},
	{3326917632U, 23},
	{3326951936U, 24},
	{3326957056U, 23},
	{3326961664U, 24},
	{3326961920U, 24},
	{3326962176U, 24},
	{3326963712U, 22},
	{3326964736U, 23},
	{3326969856U, 24},
	{3326980096U, 23},
	{3326987264U, 22},
	{3327002624U, 21},
	{3327006208U, 23},
	{3327013888U, 23},
	{3327016960U, 21},
	{3327025152U, 20},
	{3327072256U, 22},
	{3327088640U, 21},
	{3327131648U, 23},
	{3327135488U, 24},
	{3327136768U, 24},
	{3327140864U, 24},
	{3327145984U, 24},
	{3327146240U, 24},
	{3327146496U, 24},
	{3327146752U, 24},
	{3327149056U, 22},
	{3327154176U, 21},
	{3327164672U, 24},
	{3327164928U, 24},
	{3327165440U, 24},
	{3327166464U, 24},
	{3327166720U, 24},
	{3327166976U, 24},
	{3327167232U, 24},
	{3327167488U, 24},
	{3327168256U, 24},
	{3327168512U, 24},
	{3327168768U, 24},
	{3327169024U, 24},
	{3327170304U, 24},
	{3327170560U, 24},
	{3327170816U, 24},
	{3327171328U, 24},
	{3327171584U, 24},
	{3327171840U, 24},
	{3327172352U, 24},
	{3327172608U, 24},
	{3327173120U, 24},
	{3327173632U, 24},
	{3327173888U, 24},
	{3327174400U, 24},
	{3327174912U, 24},
	{3327175168U, 24},
	{3327175424U, 24},
	{3327175680U, 24},
	{3327175936U, 24},
	{3327176192U, 24},
	{3327176448U, 24},
	{3327177216U, 24},
	{3327178240U, 24},
	{3327178496U, 24},
	{3327179008U, 24},
	{3327179264U, 24},
	{3327179520U, 24},
	{3327180032U, 24},
	{3327180544U, 24},
	{3327197184U, 19},
	{3327198208U, 22},
	{3327201280U, 20},
	{3327201280U, 21},
	{3327248384U, 24},
	{3327256064U, 24},
	{3327258624U, 24},
	{3327333120U, 24},
	{3327335424U, 22},
	{3327361536U, 24},
	{3327397888U, 20},
	{3327406848U, 24},
	{3327407104U, 24},
	{3327478272U, 23},
	{3327489024U, 24},
	{3327590400U, 16},
	{3327598592U, 22},
	{3327604736U, 21},
	{3327627264U, 21},
	{3327655936U, 16},
	{3327655936U, 24},
	{3327682816U, 24},
	{3327683072U, 24},
	{3327683328U, 24},
	{3327686144U, 24},
	{3327689728U, 24},
	{3327689984U, 24},
	{3327690240U, 24},
	{3327690496U, 24},
	{3327690752U, 24},
	{3327692800U, 21},
	{3327700992U, 20},
	{3327711232U, 24},
	{3327730432U, 24},
	{3327730688U, 24},
	{3327730944U, 24},
	{3327754240U, 18},
	{3327762432U, 24},
	{3327854592U, 23},
	{3327855616U, 23},
	{3327868928U, 24},
	{3327869184U, 24},
	{3327869440U, 24},
	{3327869696U, 24},
	{3327870464U, 24},
	{3327870720U, 24},
	{3327871232U, 24},
	{3327944704U, 21},
	{3327958016U, 23},
	{3327971328U, 22},
	{3327988736U, 22},
	{3328007168U, 22},
	{3328011264U, 24},
	{3328011520U, 24},
	{3328011776U, 24},
	{3328012032U, 24},
	{3328017920U, 23},
	{3328018432U, 22},
	{3328116736U, 23},
	{3328117248U, 24},
	{3328172032U, 24},
	{3328172288U, 24},
	{3328172544U, 24},
	{3328178176U, 22},
	{3328212736U, 24},
	{3328228352U, 24},
	{3328257024U, 24},
	{3328259072U, 23},
	{3328262912U, 24},
	{3328263680U, 24},
	{3328264192U, 24},
	{3328265984U, 24},
	{3328266240U, 24},
	{3328266496U, 24},
	{3328266752U, 23},
	{3328267264U, 22},
	{3328268288U, 24},
	{3328269568U, 24},
	{3328270080U, 24},
	{3328270592U, 24},
	{3328273152U, 24},
	{3328273408U, 24},
	{3328273920U, 24},
	{3328280320U, 24},
	{3328281088U, 24},
	{3328282368U, 24},
	{3328282624U, 24},
	{3328284416U, 24},
	{3328284928U, 24},
	{3328285184U, 24},
	{3328285440U, 24},
	{3328299008U, 24},
	{3328299264U, 24},
	{3328305664U, 23},
	{3328306176U, 24},
	{3328399360U, 24},
	{3328399616U, 24},
	{3328399872U, 24},
	{3328402432U, 23},
	{3328403968U, 24},
	{3328404224U, 24},
	{3328404480U, 24},
	{3328404992U, 24},
	{3328406272U, 24},
	{3328414208U, 24},
	{3328414464U, 24},
	{3328428288U, 24},
	{3328434432U, 24},
	{3328438016U, 24},
	{3328513792U, 24},
	{3328514048U, 24},
	{3328516096U, 20},
	{3328573696U, 24},
	{3328573952U, 23},
	{3328590336U, 24},
	{3328590592U, 24},
	{3328595200U, 24},
	{3328595456U, 23},
	{3328595968U, 24},
	{3328602112U, 24},
	{3328603392U, 24},
	{3328611072U, 24},
	{3328613632U, 24},
	{3328614144U, 24},
	{3328621056U, 23},
	{3328621568U, 22},
	{3328622592U, 22},
	{3328623616U, 23},
	{3328624128U, 23},
	{3328624896U, 24},
	{3328626176U, 24},
	{3328627456U, 24},
	{3328637952U, 24},
	{3328638208U, 24},
	{3328638464U, 24},
	{3328704512U, 16},
	{3328720896U, 18},
	{3328745472U, 20},
	{3328763904U, 21},
	{3328770560U, 24},
	{3328778240U, 20},
	{3328786432U, 20},
	{3328802816U, 20},
	{3328835584U, 15},
	{3328884736U, 22},
	{3328885760U, 22},
	{3328890880U, 23},
	{3328897024U, 22},
	{3328901120U, 18},
	{3328937984U, 20},
	{3328960512U, 22},
	{3328962560U, 23},
	{3328966656U, 14},
	{3328970752U, 22},
	{3329082112U, 24},
	{3329082624U, 24},
	{3329086976U, 23},
	{3329087488U, 23},
	{3329088000U, 24},
	{3329280000U, 23},
	{3329470464U, 21},
	{3329674752U, 24},
	{3329693440U, 24},
	{3329693696U, 24},
	{3329694464U, 25},
	{3330015232U, 14},
	{3330277376U, 14},
	{3330609152U, 20},
	{3330624768U, 24},
	{3330625280U, 24},
	{3330635776U, 24},
	{3330636544U, 24},
	{3330638080U, 24},
	{3330642432U, 24},
	{3330648576U, 24},
	{3330652416U, 24},
	{3330655744U, 24},
	{3330656000U, 24},
	{3330657792U, 24},
	{3330661120U, 24},
	{3330662400U, 24},
	{3330664704U, 24},
	{3330667008U, 24},
	{3330707200U, 24},
	{3330708480U, 24},
	{3330720768U, 24},
	{3330736128U, 22},
	{3330737152U, 22},
	{3330753280U, 24},
	{3330753536U, 24},
	{3330756096U, 24},
	{3330764288U, 24},
	{3330766336U, 23},
	{3330767104U, 24},
	{3330775296U, 24},
	{3330786304U, 24},
	{3330803712U, 21},
	{3330837248U, 24},
	{3330840832U, 24},
	{3330842624U, 24},
	{3330855936U, 24},
	{3330863872U, 24},
	{3330865664U, 24},
	{3330892544U, 24},
	{3330903040U, 24},
	{3330903808U, 24},
	{3330910720U, 24},
	{3330913536U, 24},
	{3330913792U, 23},
	{3330914304U, 23},
	{3330914816U, 24},
	{3330915072U, 24},
	{3330916864U, 24},
	{3330918144U, 24},
	{3330918400U, 24},
	{3330918912U, 24},
	{3330923776U, 24},
	{3330924800U, 24},
	{3330925056U, 24},
	{3330925312U, 24},
	{3330929920U, 24},
	{3330930944U, 24},
	{3330932224U, 24},
	{3330932736U, 15},
	{3330942976U, 23},
	{3330946304U, 24},
	{3330946560U, 23},
	{3330947072U, 22},
	{3330948096U, 24},
	{3330950144U, 23},
	{3330950144U, 24},
	{3330950400U, 24},
	{3330954240U, 23},
	{3330956544U, 24},
	{3330959104U, 24},
	{3331035136U, 23},
	{3331047168U, 24},
	{3331047680U, 24},
	{3331048192U, 24},
	{3331048704U, 24},
	{3331050240U, 24},
	{3331051264U, 24},
	{3331055616U, 24},
	{3331058944U, 24},
	{3331063808U, 22},
	{3331078656U, 23},
	{3331079936U, 24},
	{3331098112U, 24},
	{3331105024U, 24},
	{3331109632U, 24},
	{3331112192U, 24},
	{3331118848U, 24},
	{3331199232U, 24},
	{3331201024U, 21},
	{3331202560U, 24},
	{3331260416U, 19},
	{3331342336U, 20},
	{3331358720U, 20},
	{3331360512U, 24},
	{3331375104U, 20},
	{3331383296U, 20},
	{3331415040U, 23},
	{3331422208U, 24},
	{3331448832U, 19},
	{3331454976U, 21},
	{3331456512U, 24},
	{3331522560U, 20},
	{3331532288U, 24},
	{3331538944U, 18},
	{3331545856U, 24},
	{3331555328U, 24},
	{3331557632U, 24},
	{3331558912U, 23},
	{3331560192U, 24},
	{3331560960U, 24},
	{3331561216U, 24},
	{3331562752U, 24},
	{3331564032U, 24},
	{3331567360U, 24},
	{3331568896U, 24},
	{3331572992U, 24},
	{3331573760U, 23},
	{3331578624U, 24},
	{3331583232U, 24},
	{3331583488U, 24},
	{3331585536U, 24},
	{3331604480U, 21},
	{3331606528U, 22},
	{3331628032U, 24},
	{3331630592U, 24},
	{3331632896U, 24},
	{3331636736U, 24},
	{3331640576U, 24},
	{3331649280U, 24},
	{3331652352U, 24},
	{3331654144U, 24},
	{3331697664U, 22},
	{3331719680U, 24},
	{3331720192U, 24},
	{3331720448U, 24},
	{3331720704U, 24},
	{3331720960U, 24},
	{3331721472U, 24},
	{3331724800U, 24},
	{3331726592U, 24},
	{3331728896U, 24},
	{3331729152U, 24},
	{3331733248U, 24},
	{3331740160U, 24},
	{3331740416U, 24},
	{3331740672U, 24},
	{3331740928U, 24},
	{3331741184U, 24},
	{3331741440U, 24},
	{3331746304U, 24},
	{3331817984U, 24},
	{3331818752U, 24},
	{3331819776U, 24},
	{3331822336U, 24},
	{3331822848U, 24},
	{3331825408U, 24},
	{3331825664U, 24},
	{3331826176U, 24},
	{3331828224U, 24},
	{3331828480U, 24},
	{3331828736U, 24},
	{3331835904U, 22},
	{3331843584U, 23},
	{3331844864U, 24},
	{3331845120U, 24},
	{3331848192U, 24},
	{3331848960U, 24},
	{3331856128U, 24},
	{3331885824U, 24},
	{3331897600U, 24},
	{3331920896U, 22},
	{3331923456U, 24},
	{3331923712U, 24},
	{3331953152U, 24},
	{3331959808U, 24},
	{3331971840U, 24},
	{3331977728U, 23},
	{3331978240U, 23},
	{3331981824U, 23},
	{3331985408U, 24},
	{3331985920U, 24},
	{3331986176U, 24},
	{3331986432U, 24},
	{3331986688U, 24},
	{3331986944U, 24},
	{3331987200U, 24},
	{3331987456U, 24},
	{3331987712U, 24},
	{3332019712U, 24},
	{3332025600U, 24},
	{3332025856U, 23},
	{3332026368U, 23},
	{3332046848U, 16},
	{3332093952U, 24},
	{3332094208U, 24},
	{3332095488U, 24},
	{3332095744U, 24},
	{3332379136U, 24},
	{3332410368U, 24},
	{3332419840U, 24},
	{3332420096U, 24},
	{3332420352U, 24},
	{3332420608U, 24},
	{3332424704U, 24},
	{3332424960U, 24},
	{3332437504U, 24},
	{3332439040U, 24},
	{3332486144U, 24},
	{3332618240U, 21},
	{3332620288U, 21},
	{3332622336U, 21},
	{3332874240U, 24},
	{3332874496U, 24},
	{3332874752U, 24},
	{3332875008U, 24},
	{3333008128U, 24},
	{3333010688U, 24},
	{3333010944U, 24},
	{3333011200U, 24},
	{3333011456U, 24},
	{3333029888U, 15},
	{3333078272U, 24},
	{3333160960U, 15},
	{3333260544U, 24},
	{3333263872U, 24},
	{3333277440U, 24},
	{3333292032U, 16},
	{3333292288U, 24},
	{3333292544U, 23},
	{3333293056U, 23},
	{3333293568U, 24},
	{3333296128U, 20},
	{3333304320U, 24},
	{3333304576U, 24},
	{3333304832U, 24},
	{3333305088U, 24},
	{3333305344U, 24},
	{3333306112U, 24},
	{3333308672U, 24},
	{3333308928U, 23},
	{3333309440U, 22},
	{3333310464U, 21},
	{3333312512U, 20},
	{3333322752U, 24},
	{3333323008U, 24},
	{3333323264U, 23},
	{3333323776U, 22},
	{3333324544U, 24},
	{3333324800U, 22},
	{3333324800U, 24},
	{3333325824U, 24},
	{3333335296U, 24},
	{3333337088U, 20},
	{3333347584U, 24},
	{3333347840U, 23},
	{3333348352U, 22},
	{3333349376U, 21},
	{3333359872U, 24},
	{3333369856U, 24},
	{3333370112U, 24},
	{3333371904U, 24},
	{3333372160U, 24},
	{3333372928U, 24},
	{3333373440U, 23},
	{3333373440U, 24},
	{3333374976U, 24},
	{3333375488U, 23},
	{3333376000U, 24},
	{3333377024U, 24},
	{3333385984U, 24},
	{3333395200U, 24},
	{3333395712U, 24},
	{3333405440U, 24},
	{3333409280U, 24},
	{3333409536U, 24},
	{3333409792U, 24},
	{3333411840U, 22},
	{3333415680U, 24},
	{3333417984U, 24},
	{3333419008U, 24},
	{3333419520U, 24},
	{3333421824U, 24},
	{3333422080U, 24},
	{3333425152U, 22},
	{3333426176U, 23},
	{3333426688U, 24},
	{3333426944U, 24},
	{3333427200U, 24},
	{3333428224U, 24},
	{3333428480U, 24},
	{3333463040U, 24},
	{3333464064U, 24},
	{3333466624U, 24},
	{3333470208U, 24},
	{3333472512U, 24},
	{3333474048U, 24},
	{3333475328U, 24},
	{3333478656U, 24},
	{3333486336U, 24},
	{3333491456U, 24},
	{3333491712U, 24},
	{3333491968U, 24},
	{3333492224U, 24},
	{3333492480U, 24},
	{3333496832U, 20},
	{3333500928U, 22},
	{3333528064U, 24},
	{3333533440U, 24},
	{3333533696U, 22},
	{3333534720U, 23},
	{3333534976U, 24},
	{3333537536U, 24},
	{3333537792U, 22},
	{3333538816U, 23},
	{3333545728U, 24},
	{3333545984U, 24},
	{3333547264U, 24},
	{3333562368U, 20},
	{3333566464U, 21},
	{3333587200U, 24},
	{3333588992U, 24},
	{3333591552U, 24},
	{3333592064U, 24},
	{3333592576U, 24},
	{3333593600U, 24},
	{3333594368U, 24},
	{3333596928U, 24},
	{3333601792U, 24},
	{3333603840U, 24},
	{3333604352U, 22},
	{3333609728U, 24},
	{3333609984U, 24},
	{3333613568U, 24},
	{3333614080U, 23},
	{3333614592U, 22},
	{3333619200U, 24},
	{3333623808U, 24},
	{3333652480U, 24},
	{3333652992U, 24},
	{3333655552U, 24},
	{3333662976U, 24},
	{3333663232U, 24},
	{3333663488U, 24},
	{3333663744U, 24},
	{3333664000U, 24},
	{3333668352U, 23},
	{3333671168U, 24},
	{3333674496U, 24},
	{3333678336U, 24},
	{3333679104U, 24},
	{3333680896U, 24},
	{3333682688U, 24},
	{3333683200U, 24},
	{3333686272U, 22},
	{3333689344U, 20},
	{3333694464U, 24},
	{3333695488U, 24},
	{3333697792U, 24},
	{3333718272U, 24},
	{3333720064U, 24},
	{3333721344U, 24},
	{3333722880U, 24},
	{3333732096U, 24},
	{3333733376U, 24},
	{3333734144U, 24},
	{3333737728U, 24},
	{3333737984U, 24},
	{3333740288U, 24},
	{3333741312U, 24},
	{3333743872U, 24},
	{3333751808U, 22},
	{3333754880U, 23},
	{3333792000U, 24},
	{3333806848U, 24},
	{3333807104U, 24},
	{3333812736U, 24},
	{3333812992U, 24},
	{3333814784U, 24},
	{3333815040U, 24},
	{3333818368U, 21},
	{3333849600U, 24},
	{3333849856U, 24},
	{3333850112U, 24},
	{3333850368U, 24},
	{3333850624U, 24},
	{3333852160U, 24},
	{3333861376U, 22},
	{3333861888U, 24},
	{3333862400U, 23},
	{3333867520U, 24},
	{3333867776U, 24},
	{3333872640U, 24},
	{3333873920U, 24},
	{3333877504U, 24},
	{3333883904U, 21},
	{3333884416U, 24},
	{3333917440U, 24},
	{3333919232U, 23},
	{3333922048U, 24},
	{3333922816U, 22},
	{3333926656U, 24},
	{3333926912U, 23},
	{3333931008U, 23},
	{3333931520U, 24},
	{3333937408U, 24},
	{3333937664U, 24},
	{3333939968U, 24},
	{3333945344U, 23},
	{3333947392U, 21},
	{3333949440U, 24},
	{3333949696U, 24},
	{3333950464U, 24},
	{3333964288U, 24},
	{3333965056U, 24},
	{3333969152U, 24},
	{3333971200U, 24},
	{3333978368U, 24},
	{3333979648U, 24},
	{3333979904U, 24},
	{3333981696U, 24},
	{3333983744U, 24},
	{3333985024U, 24},
	{3333991168U, 24},
	{3334001152U, 24},
	{3334001408U, 24},
	{3334005504U, 24},
	{3334013952U, 22},
	{3334015488U, 24},
	{3334018560U, 24},
	{3334030848U, 23},
	{3334031360U, 23},
	{3334046976U, 24},
	{3334047232U, 23},
	{3334047744U, 23},
	{3334049280U, 24},
	{3334067456U, 24},
	{3334072832U, 24},
	{3334073344U, 24},
	{3334087680U, 24},
	{3334094848U, 24},
	{3334111232U, 24},
	{3334115584U, 24},
	{3334117120U, 24},
	{3334119424U, 24},
	{3334121216U, 24},
	{3334125568U, 24},
	{3334129664U, 22},
	{3334133760U, 24},
	{3334134784U, 23},
	{3334139136U, 24},
	{3334139904U, 23},
	{3334144000U, 22},
	{3334178816U, 24},
	{3334183424U, 24},
	{3334183936U, 24},
	{3334195968U, 24},
	{3334196224U, 24},
	{3334207232U, 24},
	{3334208512U, 24},
	{3334250496U, 19},
	{3334347776U, 24},
	{3334383104U, 24},
	{3334384384U, 24},
	{3334387200U, 24},
	{3334388480U, 24},
	{3334388736U, 24},
	{3334390528U, 24},
	{3334392064U, 24},
	{3334395904U, 24},
	{3334396672U, 24},
	{3334398464U, 24},
	{3334933760U, 24},
	{3334963200U, 24},
	{3334973440U, 24},
	{3334976256U, 24},
	{3334978816U, 24},
	{3334979328U, 24},
	{3334981376U, 24},
	{3334983168U, 24},
	{3334986496U, 24},
	{3334987776U, 24},
	{3334991104U, 24},
	{3335004160U, 21},
	{3335031552U, 24},
	{3335042560U, 24},
	{3335045888U, 24},
	{3335062528U, 24},
	{3335062784U, 24},
	{3335063040U, 24},
	{3335067392U, 24},
	{3335143424U, 18},
	{3335143424U, 21},
	{3335143680U, 24},
	{3335143936U, 24},
	{3335144192U, 24},
	{3335144448U, 24},
	{3335144704U, 24},
	{3335144960U, 24},
	{3335145216U, 24},
	{3335145472U, 21},
	{3335145472U, 24},
	{3335145728U, 24},
	{3335145984U, 24},
	{3335146240U, 24},
	{3335146496U, 24},
	{3335147264U, 24},
	{3335147520U, 20},
	{3335147520U, 24},
	{3335147776U, 24},
	{3335148544U, 24},
	{3335148800U, 24},
	{3335149056U, 24},
	{3335149312U, 24},
	{3335151616U, 19},
	{3335162624U, 24},
	{3335164928U, 24},
	{3335170048U, 24},
	{3335172352U, 24},
	{3335173632U, 24},
	{3335179264U, 24},
	{3335182592U, 24},
	{3335183616U, 24},
	{3335184384U, 24},
	{3335185408U, 23},
	{3335187200U, 24},
	{3335189248U, 24},
	{3335196672U, 21},
	{3335198720U, 23},
	{3335200768U, 20},
	{3335204864U, 20},
	{3335229696U, 24},
	{3335236864U, 24},
	{3335238144U, 24},
	{3335241472U, 24},
	{3335241728U, 24},
	{3335248640U, 24},
	{3335255552U, 24},
	{3335281664U, 24},
	{3335284736U, 24},
	{3335286784U, 22},
	{3335290368U, 24},
	{3335292160U, 24},
	{3335292416U, 24},
	{3335293440U, 24},
	{3335294208U, 24},
	{3335294464U, 24},
	{3335327232U, 24},
	{3335331840U, 19},
	{3335393280U, 20},
	{3335401216U, 24},
	{3335423488U, 24},
	{3335425024U, 24},
	{3335429376U, 24},
	{3335429632U, 24},
	{3335430144U, 24},
	{3335430656U, 24},
	{3335433984U, 24},
	{3335438592U, 24},
	{3335438848U, 24},
	{3335439104U, 24},
	{3335444224U, 24},
	{3335446016U, 24},
	{3335446272U, 24},
	{3335447552U, 23},
	{3335449088U, 23},
	{3335449600U, 24},
	{3335450368U, 24},
	{3335450624U, 23},
	{3335451136U, 24},
	{3335451392U, 24},
	{3335452160U, 24},
	{3335456768U, 21},
	{3335490048U, 23},
	{3335497728U, 24},
	{3335497984U, 24},
	{3335500544U, 24},
	{3335502080U, 24},
	{3335502848U, 24},
	{3335504128U, 24},
	{3335511552U, 24},
	{3335513344U, 24},
	{3335513600U, 23},
	{3335514112U, 24},
	{3335515392U, 24},
	{3335515648U, 24},
	{3335515904U, 24},
	{3335516160U, 24},
	{3335516416U, 24},
	{3335521792U, 24},
	{3335577344U, 24},
	{3335585792U, 19},
	{3335593984U, 19},
	{3335602176U, 19},
	{3335610368U, 19},
	{3335618560U, 19},
	{3335626752U, 19},
	{3335634944U, 19},
	{3335643136U, 19},
	{3335716864U, 16},
	{3335727104U, 24},
	{3335730688U, 24},
	{3335731200U, 23},
	{3335733504U, 24},
	{3335748608U, 24},
	{3335824896U, 24},
	{3335827456U, 24},
	{3335832064U, 23},
	{3335832576U, 23},
	{3335834880U, 24},
	{3335835136U, 24},
	{3335835392U, 24},
	{3335835648U, 22},
	{3335838208U, 24},
	{3335845376U, 24},
	{3335846656U, 24},
	{3336165376U, 21},
	{3336227840U, 24},
	{3336510720U, 24},
	{3336510976U, 23},
	{3336528128U, 24},
	{3336529152U, 24},
	{3336529408U, 24},
	{3336530432U, 24},
	{3336536064U, 21},
	{3336544256U, 19},
	{3336830976U, 19},
	{3336880128U, 18},
	{3336945408U, 24},
	{3337126144U, 24},
	{3337129984U, 24},
	{3337133824U, 24},
	{3337147904U, 24},
	{3337148160U, 24},
	{3337148416U, 24},
	{3337148672U, 24},
	{3337151488U, 24},
	{3337153536U, 24},
	{3337153792U, 24},
	{3337154048U, 24},
	{3337154304U, 24},
	{3337224192U, 16},
	{3337335040U, 24},
	{3337486336U, 16},
	{3337540608U, 23},
	{3337551872U, 16},
	{3337734400U, 24},
	{3337734656U, 23},
	{3337734656U, 24},
	{3337734912U, 24},
	{3337735168U, 24},
	{3337754368U, 24},
	{3337757440U, 24},
	{3337762816U, 24},
	{3337763328U, 24},
	{3337778944U, 24},
	{3337803776U, 24},
	{3337879552U, 21},
	{3337881600U, 23},
	{3337949184U, 20},
	{3337980928U, 24},
	{3337991936U, 24},
	{3337997312U, 24},
	{3337997824U, 24},
	{3337998848U, 24},
	{3337999104U, 24},
	{3338010624U, 21},
	{3338014720U, 21},
	{3338016768U, 23},
	{3338018816U, 21},
	{3338027008U, 19},
	{3338035200U, 21},
	{3338044160U, 24},
	{3338048768U, 24},
	{3338049024U, 24},
	{3338049280U, 24},
	{3338049536U, 24},
	{3338049792U, 24},
	{3338059776U, 24},
	{3338061824U, 24},
	{3338068736U, 24},
	{3338073600U, 24},
	{3338076160U, 16},
	{3338076160U, 20},
	{3338082304U, 21},
	{3338084352U, 20},
	{3338088448U, 20},
	{3338088448U, 24},
	{3338092544U, 19},
	{3338100736U, 19},
	{3338108928U, 19},
	{3338123264U, 22},
	{3338135552U, 23},
	{3338136064U, 24},
	{3338158080U, 19},
	{3338166272U, 19},
	{3338318848U, 24},
	{3338324480U, 24},
	{3338324736U, 24},
	{3338324992U, 24},
	{3338405888U, 21},
	{3338412032U, 19},
	{3338440448U, 24},
	{3338444544U, 24},
	{3338451456U, 24},
	{3338452224U, 24},
	{3338452480U, 24},
	{3338452736U, 24},
	{3338452992U, 24},
	{3338454016U, 22},
	{3338458624U, 24},
	{3338464512U, 24},
	{3338469376U, 16},
	{3338469376U, 20},
	{3338473472U, 20},
	{3338479616U, 21},
	{3338484224U, 24},
	{3338484736U, 24},
	{3338487552U, 24},
	{3338487808U, 21},
	{3338489856U, 20},
	{3338494720U, 24},
	{3338494976U, 22},
	{3338496256U, 24},
	{3338496512U, 24},
	{3338497536U, 24},
	{3338497792U, 24},
	{3338498048U, 23},
	{3338498560U, 24},
	{3338499072U, 24},
	{3338499328U, 24},
	{3338499584U, 23},
	{3338500096U, 24},
	{3338500608U, 23},
	{3338501120U, 22},
	{3338502144U, 21},
	{3338504192U, 21},
	{3338507008U, 24},
	{3338507264U, 23},
	{3338509824U, 24},
	{3338510592U, 24},
	{3338511104U, 24},
	{3338511872U, 23},
	{3338512384U, 22},
	{3338513664U, 24},
	{3338513920U, 24},
	{3338514176U, 24},
	{3338514688U, 24},
	{3338514944U, 24},
	{3338516480U, 24},
	{3338516736U, 24},
	{3338516992U, 24},
	{3338517248U, 24},
	{3338517504U, 22},
	{3338518528U, 22},
	{3338519552U, 24},
	{3338520064U, 24},
	{3338520320U, 24},
	{3338520576U, 24},
	{3338521600U, 23},
	{3338522112U, 24},
	{3338522368U, 24},
	{3338522624U, 23},
	{3338523136U, 24},
	{3338524160U, 23},
	{3338524672U, 22},
	{3338525696U, 23},
	{3338526208U, 24},
	{3338526976U, 24},
	{3338527232U, 24},
	{3338528768U, 23},
	{3338531584U, 24},
	{3338532352U, 23},
	{3338534144U, 24},
	{3338534400U, 24},
	{3338534656U, 24},
	{3338534912U, 20},
	{3338668032U, 24},
	{3338685440U, 22},
	{3338731776U, 24},
	{3338734336U, 24},
	{3338754816U, 24},
	{3338764288U, 23},
	{3338765312U, 22},
	{3338766336U, 21},
	{3338768384U, 20},
	{3338771456U, 24},
	{3338771712U, 24},
	{3338772480U, 19},
	{3338799104U, 21},
	{3338801152U, 20},
	{3338809856U, 24},
	{3338813440U, 19},
	{3338821632U, 19},
	{3338824448U, 24},
	{3338824704U, 24},
	{3338827008U, 24},
	{3338828544U, 24},
	{3338832128U, 24},
	{3338846208U, 19},
	{3338854144U, 24},
	{3338865152U, 23},
	{3338865664U, 24},
	{3338878976U, 19},
	{3338909184U, 24},
	{3338923776U, 24},
	{3338924032U, 24},
	{3338925568U, 24},
	{3338940416U, 22},
	{3338942464U, 22},
	{3338942720U, 24},
	{3338942976U, 24},
	{3338944512U, 18},
	{3338963968U, 22},
	{3338965504U, 23},
	{3338970112U, 22},
	{3338976000U, 24},
	{3338977792U, 24},
	{3338982144U, 24},
	{3338983424U, 24},
	{3338983680U, 24},
	{3338984448U, 24},
	{3338985728U, 24},
	{3338991104U, 23},
	{3338991872U, 24},
	{3338992640U, 24},
	{3338992896U, 24},
	{3339009024U, 24},
	{3339009280U, 24},
	{3339010048U, 18},
	{3339027712U, 24},
	{3339038720U, 23},
	{3339039232U, 24},
	{3339039488U, 24},
	{3339039744U, 24},
	{3339040000U, 24},
	{3339040256U, 24},
	{3339042560U, 24},
	{3339044096U, 24},
	{3339044352U, 24},
	{3339044608U, 24},
	{3339044864U, 24},
	{3339045888U, 22},
	{3339046912U, 22},
	{3339051264U, 24},
	{3339053056U, 24},
	{3339053312U, 24},
	{3339053568U, 23},
	{3339054080U, 24},
	{3339055872U, 24},
	{3339058688U, 24},
	{3339084288U, 24},
	{3339091712U, 24},
	{3339190272U, 16},
	{3339190272U, 20},
	{3339196416U, 22},
	{3339197440U, 22},
	{3339198464U, 22},
	{3339199488U, 22},
	{3339200512U, 21},
	{3339202560U, 21},
	{3339204608U, 24},
	{3339204864U, 24},
	{3339205120U, 24},
	{3339205376U, 24},
	{3339205632U, 24},
	{3339205888U, 24},
	{3339206400U, 24},
	{3339206656U, 21},
	{3339208704U, 24},
	{3339208960U, 24},
	{3339209216U, 24},
	{3339209472U, 24},
	{3339209728U, 24},
	{3339209984U, 24},
	{3339210240U, 24},
	{3339210496U, 24},
	{3339210752U, 21},
	{3339212800U, 22},
	{3339212800U, 23},
	{3339213824U, 22},
	{3339214848U, 22},
	{3339215872U, 22},
	{3339216896U, 22},
	{3339217920U, 23},
	{3339218432U, 23},
	{3339218944U, 21},
	{3339220992U, 24},
	{3339225088U, 22},
	{3339226112U, 22},
	{3339227136U, 21},
	{3339229184U, 22},
	{3339231232U, 21},
	{3339233280U, 22},
	{3339234304U, 22},
	{3339235328U, 20},
	{3339239424U, 21},
	{3339241472U, 22},
	{3339242496U, 22},
	{3339243520U, 20},
	{3339247616U, 21},
	{3339249664U, 21},
	{3339252736U, 22},
	{3339254784U, 22},
	{3339255808U, 24},
	{3339256064U, 24},
	{3339256320U, 24},
	{3339258368U, 23},
	{3339325440U, 21},
	{3339334144U, 24},
	{3339337216U, 24},
	{3339338496U, 24},
	{3339341056U, 24},
	{3339342080U, 24},
	{3339345152U, 24},
	{3339351040U, 24},
	{3339351808U, 24},
	{3339352064U, 23},
	{3339352576U, 24},
	{3339353088U, 24},
	{3339353856U, 24},
	{3339355392U, 24},
	{3339355904U, 24},
	{3339356672U, 24},
	{3339356928U, 24},
	{3339357440U, 24},
	{3339359232U, 24},
	{3339372544U, 24},
	{3339376384U, 24},
	{3339380480U, 24},
	{3339380992U, 24},
	{3339382528U, 24},
	{3339605760U, 24},
	{3339649024U, 21},
	{3339651072U, 21},
	{3339664384U, 22},
	{3339722752U, 19},
	{3339780096U, 16},
	{3339845632U, 16},
	{3339978752U, 21},
	{3340009472U, 17},
	{3340049408U, 22},
	{3340371968U, 21},
	{3340409088U, 24},
	{3340409600U, 24},
	{3340412160U, 24},
	{3340413696U, 24},
	{3340414976U, 24},
	{3340415232U, 24},
	{3340420864U, 24},
	{3340427520U, 24},
	{3340433920U, 24},
	{3340437504U, 21},
	{3340566784U, 24},
	{3340567040U, 24},
	{3340567296U, 24},
	{3340568064U, 24},
	{3340568320U, 24},
	{3340568576U, 24},
	{3340568832U, 24},
	{3340574464U, 24},
	{3340590080U, 22},
	{3340600320U, 24},
	{3340602624U, 24},
	{3340603392U, 20},
	{3340613632U, 24},
	{3340616704U, 23},
	{3340617984U, 24},
	{3340618240U, 23},
	{3340618752U, 23},
	{3340619264U, 23},
	{3340619776U, 23},
	{3340620288U, 24},
	{3340620544U, 24},
	{3340620800U, 22},
	{3340621824U, 22},
	{3340622848U, 24},
	{3340623104U, 24},
	{3340623360U, 24},
	{3340623616U, 24},
	{3340628480U, 24},
	{3340629248U, 24},
	{3340629504U, 24},
	{3340629760U, 24},
	{3340631808U, 24},
	{3340702976U, 24},
	{3340705536U, 24},
	{3340724992U, 24},
	{3340836864U, 19},
	{3340845056U, 24},
	{3340848896U, 24},
	{3340849408U, 24},
	{3340859136U, 24},
	{3340861440U, 24},
	{3340861696U, 24},
	{3340865536U, 24},
	{3340865792U, 24},
	{3340869376U, 24},
	{3340870656U, 23},
	{3340870656U, 24},
	{3340870912U, 24},
	{3340871168U, 24},
	{3340871424U, 24},
	{3340871680U, 24},
	{3340871936U, 24},
	{3340872192U, 24},
	{3340872448U, 24},
	{3340872704U, 24},
	{3340872960U, 24},
	{3340875264U, 24},
	{3340878848U, 24},
	{3340879360U, 24},
	{3340880640U, 24},
	{3340881408U, 24},
	{3340884224U, 24},
	{3340885760U, 24},
	{3340886016U, 23},
	{3340889600U, 24},
	{3340890368U, 24},
	{3340890624U, 24},
	{3340891136U, 24},
	{3340893184U, 24},
	{3340898304U, 20},
	{3340902400U, 24},
	{3340907776U, 24},
	{3340936960U, 24},
	{3340959744U, 16},
	{3340984576U, 24},
	{3341030144U, 24},
	{3341031424U, 24},
	{3341090816U, 17},
	{3341115392U, 24},
	{3341119488U, 24},
	{3341123584U, 17},
	{3341156352U, 24},
	{3341156608U, 24},
	{3341156864U, 24},
	{3341157120U, 24},
	{3341157376U, 24},
	{3341157632U, 24},
	{3341157888U, 24},
	{3341158144U, 24},
	{3341164544U, 20},
	{3341168640U, 22},
	{3341190400U, 24},
	{3341319936U, 24},
	{3341339648U, 23},
	{3341340160U, 24},
	{3341352448U, 24},
	{3341353728U, 24},
	{3341355008U, 23},
	{3341385472U, 24},
	{3341403392U, 24},
	{3341403648U, 23},
	{3341404160U, 22},
	{3341416448U, 24},
	{3341417984U, 24},
	{3341427712U, 24},
	{3341445120U, 23},
	{3341479936U, 23},
	{3341492224U, 24},
	{3341492736U, 24},
	{3341492992U, 24},
	{3341496320U, 24},
	{3341497088U, 24},
	{3341512704U, 24},
	{3341647872U, 17},
	{3341682688U, 21},
	{3341684736U, 20},
	{3341684736U, 23},
	{3341685248U, 23},
	{3341713408U, 17},
	{3341731840U, 24},
	{3341743360U, 24},
	{3341745920U, 24},
	{3341754368U, 22},
	{3341812736U, 22},
	{3341817344U, 24},
	{3341817600U, 24},
	{3341817856U, 24},
	{3341882880U, 24},
	{3341887232U, 24},
	{3341895168U, 24},
	{3341949440U, 24},
	{3341950208U, 24},
	{3342028032U, 24},
	{3342033664U, 24},
	{3342036992U, 24},
	{3342145280U, 24},
	{3342158336U, 24},
	{3342159104U, 24},
	{3342159360U, 24},
	{3342164992U, 24},
	{3342165504U, 23},
	{3342480384U, 24},
	{3342542848U, 24},
	{3342794752U, 16},
	{3342860288U, 24},
	{3342862080U, 24},
	{3342862336U, 24},
	{3342976000U, 24},
	{3342991616U, 24},
	{3342993920U, 24},
	{3343056896U, 21},
	{3343060992U, 20},
	{3343089920U, 24},
	{3343091712U, 24},
	{3343092224U, 23},
	{3343092736U, 23},
	{3343102976U, 24},
	{3343103232U, 24},
	{3343103488U, 23},
	{3343104000U, 23},
	{3343105792U, 24},
	{3343107072U, 24},
	{3343118080U, 24},
	{3343131392U, 24},
	{3343143168U, 24},
	{3343187968U, 16},
	{3343253504U, 16},
	{3343329280U, 24},
	{3343455232U, 24},
	{3343458304U, 21},
	{3343460352U, 23},
	{3343517696U, 21},
	{3343532032U, 18},
	{3343552000U, 24},
	{3343558400U, 24},
	{3343566336U, 24},
	{3343568384U, 24},
	{3343570944U, 22},
	{3343571968U, 23},
	{3343572480U, 24},
	{3343574016U, 24},
	{3343575808U, 24},
	{3343576064U, 24},
	{3343576320U, 24},
	{3343577600U, 24},
	{3343723520U, 23},
	{3343724032U, 24},
	{3343843328U, 20},
	{3343876864U, 24},
	{3343878144U, 24},
	{3343883008U, 24},
	{3343886336U, 24},
	{3343886592U, 24},
	{3343886848U, 24},
	{3343887104U, 24},
	{3343890944U, 24},
	{3343891968U, 24},
	{3343892992U, 24},
	{3343895040U, 24},
	{3343895552U, 24},
	{3343897856U, 24},
	{3343898368U, 24},
	{3343900160U, 24},
	{3343901440U, 24},
	{3343901696U, 24},
	{3343903744U, 24},
	{3343905536U, 24},
	{3343905792U, 24},
	{3343907328U, 23},
	{3343907840U, 23},
	{3343908352U, 24},
	{3343921664U, 24},
	{3343941632U, 17},
	{3343974400U, 16},
	{3344023552U, 19},
	{3344039936U, 16},
	{3344121856U, 20},
	{3344238080U, 24},
	{3344302080U, 16},
	{3344306176U, 22},
	{3344308992U, 24},
	{3344323584U, 24},
	{3344334848U, 17},
	{3344436736U, 24},
	{3344466944U, 24},
	{3344467456U, 23},
	{3344467968U, 23},
	{3344470272U, 24},
	{3344470784U, 24},
	{3344473600U, 24},
	{3344476928U, 24},
	{3344481024U, 24},
	{3344485632U, 24},
	{3344492544U, 24},
	{3344493056U, 24},
	{3344493312U, 24},
	{3344498176U, 24},
	{3344498688U, 21},
	{3344500736U, 21},
	{3344515072U, 18},
	{3344531456U, 24},
	{3344534528U, 24},
	{3344535040U, 23},
	{3344540416U, 24},
	{3344546560U, 24},
	{3344546816U, 24},
	{3344547840U, 23},
	{3344556032U, 24},
	{3344557312U, 24},
	{3344558336U, 24},
	{3344558592U, 24},
	{3344558848U, 24},
	{3344562176U, 24},
	{3344563456U, 24},
	{3344637952U, 24},
	{3344638208U, 24},
	{3344638464U, 24},
	{3344638720U, 24},
	{3344638976U, 24},
	{3344639232U, 24},
	{3344639488U, 24},
	{3344639744U, 24},
	{3344761856U, 24},
	{3344762112U, 24},
	{3344778752U, 24},
	{3344779008U, 24},
	{3344826368U, 19},
	{3344834560U, 20},
	{3344838656U, 24},
	{3345026048U, 24},
	{3345035264U, 24},
	{3345038592U, 24},
	{3345047808U, 24},
	{3345053952U, 24},
	{3345071616U, 24},
	{3345072128U, 22},
	{3345077248U, 24},
	{3345090304U, 24},
	{3345092608U, 20},
	{3345111040U, 24},
	{3345117184U, 23},
	{3345132288U, 24},
	{3345139712U, 24},
	{3345140992U, 24},
	{3345154560U, 24},
	{3345170432U, 21},
	{3345172480U, 23},
	{3345179904U, 24},
	{3345188352U, 24},
	{3345193984U, 22},
	{3345216000U, 24},
	{3345216256U, 24},
	{3345216512U, 24},
	{3345217536U, 21},
	{3345286144U, 24},
	{3345286656U, 24},
	{3345287168U, 21},
	{3345352960U, 24},
	{3345354496U, 24},
	{3345360640U, 24},
	{3345448960U, 17},
	{3345453568U, 24},
	{3345454336U, 24},
	{3345470208U, 24},
	{3345486592U, 24},
	{3345486848U, 24},
	{3345487360U, 24},
	{3345501696U, 24},
	{3345501952U, 24},
	{3345502208U, 24},
	{3345502464U, 24},
	{3345502720U, 24},
	{3345503232U, 24},
	{3345510400U, 24},
	{3345510656U, 24},
	{3345510912U, 24},
	{3345511168U, 24},
	{3345511424U, 24},
	{3345511680U, 24},
	{3345511936U, 24},
	{3345512192U, 24},
	{3345515520U, 24},
	{3345547264U, 16},
	{3345547264U, 18},
	{3345563648U, 23},
	{3345568768U, 22},
	{3345573376U, 24},
	{3345575936U, 21},
	{3345577984U, 21},
	{3345582592U, 24},
	{3345590272U, 24},
	{3345592064U, 24},
	{3345594880U, 24},
	{3345596160U, 24},
	{3345596416U, 20},
	{3345600512U, 24},
	{3345600768U, 24},
	{3345612544U, 24},
	{3345612800U, 16},
	{3345616896U, 24},
	{3345617152U, 24},
	{3345621504U, 24},
	{3345621760U, 24},
	{3345637376U, 19},
	{3345657344U, 23},
	{3345657856U, 23},
	{3345666048U, 20},
	{3345678336U, 16},
	{3345684480U, 22},
	{3345702912U, 22},
	{3345715200U, 24},
	{3345717248U, 24},
	{3345719296U, 21},
	{3345743872U, 16},
	{3345747968U, 24},
	{3345750272U, 24},
	{3345754112U, 24},
	{3345754624U, 23},
	{3345755136U, 22},
	{3345756160U, 21},
	{3345758208U, 23},
	{3345760256U, 24},
	{3345760768U, 24},
	{3345766400U, 23},
	{3345784832U, 21},
	{3345785856U, 24},
	{3345786624U, 24},
	{3345792256U, 24},
	{3345801216U, 22},
	{3345802240U, 23},
	{3345817600U, 22},
	{3346138624U, 24},
	{3346206720U, 21},
	{3346208768U, 23},
	{3346212096U, 24},
	{3346399232U, 16},
	{3346475008U, 24},
	{3346530304U, 21},
	{3346532352U, 22},
	{3346534400U, 20},
	{3346546688U, 18},
	{3346571520U, 24},
	{3346576128U, 24},
	{3346576640U, 24},
	{3346577152U, 24},
	{3346582016U, 24},
	{3346582272U, 24},
	{3346584576U, 24},
	{3346586112U, 24},
	{3346594048U, 24},
	{3346603776U, 24},
	{3346606592U, 24},
	{3346627584U, 24},
	{3346627840U, 24},
	{3346629376U, 24},
	{3346629632U, 24},
	{3346635520U, 24},
	{3346635776U, 24},
	{3346636032U, 24},
	{3346636544U, 24},
	{3346636800U, 24},
	{3346640384U, 23},
	{3346643200U, 24},
	{3346656768U, 23},
	{3346657280U, 24},
	{3346659072U, 24},
	{3346670336U, 24},
	{3346735104U, 20},
	{3346749184U, 24},
	{3346749440U, 24},
	{3346749696U, 24},
	{3346749952U, 24},
	{3346794496U, 21},
	{3346862080U, 20},
	{3346993152U, 24},
	{3346995456U, 24},
	{3346997248U, 21},
	{3346999296U, 23},
	{3347267584U, 19},
	{3347275776U, 21},
	{3347277824U, 22},
	{3349450752U, 24},
	{3349455872U, 24},
	{3349456640U, 24},
	{3349458944U, 23},
	{3349459456U, 24},
	{3349459968U, 23},
	{3349460992U, 24},
	{3349461248U, 24},
	{3349462784U, 24},
	{3349463040U, 24},
	{3349465088U, 24},
	{3349467648U, 24},
	{3349468672U, 24},
	{3349470464U, 24},
	{3349470720U, 24},
	{3349474048U, 24},
	{3349474304U, 24},
	{3349474560U, 24},
	{3349477888U, 24},
	{3349478656U, 24},
	{3349483520U, 20},
	{3349483520U, 24},
	{3349484288U, 24},
	{3349495808U, 18},
	{3349499904U, 21},
	{3349512448U, 24},
	{3349515520U, 24},
	{3349517824U, 24},
	{3349519616U, 24},
	{3349521664U, 24},
	{3349524480U, 24},
	{3349525248U, 24},
	{3349525504U, 24},
	{3349532160U, 24},
	{3349534976U, 24},
	{3349536512U, 24},
	{3349539072U, 24},
	{3349542656U, 24},
	{3349794816U, 20},
	{3349828608U, 23},
	{3349829632U, 21},
	{3349838336U, 24},
	{3349840896U, 24},
	{3349885952U, 24},
	{3349887232U, 24},
	{3349906944U, 24},
	{3349923840U, 24},
	{3349924096U, 24},
	{3349968896U, 24},
	{3349972992U, 24},
	{3349975040U, 20},
	{3349981440U, 24},
	{3350051840U, 24},
	{3350052096U, 24},
	{3350069248U, 16},
	{3350069248U, 18},
	{3350073344U, 21},
	{3350212608U, 21},
	{3350224896U, 19},
	{3350233088U, 17},
	{3350240256U, 24},
	{3350280704U, 24},
	{3350298624U, 18},
	{3350331392U, 18},
	{3350347776U, 20},
	{3350349568U, 24},
	{3350351872U, 20},
	{3350352896U, 24},
	{3350353920U, 24},
	{3350355712U, 24},
	{3350355968U, 19},
	{3350364160U, 18},
	{3350396928U, 17},
	{3350429696U, 19},
	{3350446080U, 19},
	{3350454272U, 19},
	{3350546176U, 24},
	{3350550528U, 22},
	{3350551552U, 22},
	{3350557952U, 24},
	{3350562816U, 23},
	{3350563328U, 24},
	{3350564864U, 24},
	{3350569984U, 22},
	{3350571008U, 24},
	{3350573568U, 23},
	{3350573824U, 24},
	{3350574080U, 24},
	{3350577408U, 24},
	{3350587904U, 24},
	{3350590208U, 24},
	{3350590464U, 24},
	{3350590976U, 24},
	{3350593536U, 15},
	{3350659840U, 24},
	{3350667264U, 24},
	{3350668800U, 24},
	{3350728704U, 20},
	{3350743808U, 24},
	{3350745600U, 24},
	{3350753280U, 22},
	{3350754304U, 23},
	{3350755072U, 24},
	{3350766848U, 24},
	{3350768384U, 24},
	{3350768640U, 24},
	{3350775808U, 22},
	{3350778368U, 24},
	{3350779648U, 24},
	{3350782464U, 24},
	{3350782720U, 24},
	{3350782976U, 24},
	{3350785024U, 23},
	{3350785536U, 24},
	{3350786048U, 24},
	{3350786560U, 24},
	{3350786816U, 24},
	{3350787072U, 24},
	{3350787328U, 24},
	{3350819584U, 24},
	{3350855680U, 16},
	{3350863616U, 24},
	{3350863872U, 24},
	{3350864128U, 24},
	{3350864384U, 24},
	{3351052288U, 24},
	{3351052544U, 24},
	{3351052800U, 24},
	{3351053056U, 24},
	{3351053312U, 24},
	{3351053568U, 24},
	{3351054336U, 21},
	{3351143424U, 24},
	{3351143680U, 24},
	{3351144448U, 24},
	{3351147520U, 24},
	{3351149056U, 23},
	{3351150592U, 23},
	{3351152128U, 24},
	{3351159040U, 24},
	{3351162368U, 24},
	{3351162624U, 24},
	{3351163392U, 23},
	{3351163904U, 24},
	{3351164160U, 24},
	{3351164416U, 24},
	{3351168512U, 23},
	{3351169024U, 24},
	{3351171328U, 24},
	{3351174656U, 23},
	{3351175168U, 23},
	{3351175680U, 24},
	{3351175936U, 24},
	{3351180288U, 24},
	{3351180544U, 24},
	{3351180800U, 24},
	{3351181056U, 24},
	{3351181312U, 24},
	{3351191552U, 24},
	{3351191808U, 24},
	{3351192064U, 24},
	{3351192320U, 24},
	{3351192576U, 24},
	{3351193344U, 24},
	{3351198464U, 24},
	{3351216128U, 21},
	{3351216128U, 22},
	{3351218176U, 21},
	{3351220224U, 21},
	{3351220224U, 22},
	{3351222272U, 21},
	{3351226368U, 24},
	{3351232512U, 24},
	{3351234560U, 24},
	{3351236608U, 24},
	{3351248896U, 21},
	{3351250944U, 22},
	{3351379968U, 16},
	{3351675136U, 24},
	{3351707648U, 16},
	{3351715840U, 19},
	{3351725568U, 24},
	{3351737856U, 23},
	{3351738368U, 21},
	{3351750656U, 23},
	{3351757568U, 24},
	{3351763968U, 24},
	{3351775488U, 24},
	{3351805952U, 24},
	{3351840256U, 24},
	{3351842816U, 22},
	{3351843328U, 24},
	{3351844608U, 24},
	{3351845632U, 24},
	{3351871488U, 24},
	{3351871744U, 24},
	{3351874560U, 24},
	{3351875328U, 24},
	{3351877888U, 24},
	{3351878144U, 24},
	{3351878656U, 24},
	{3351878912U, 24},
	{3351879168U, 24},
	{3351883520U, 24},
	{3351885056U, 24},
	{3351887872U, 24},
	{3351890688U, 24},
	{3351893248U, 24},
	{3351895808U, 24},
	{3351897856U, 24},
	{3351898112U, 22},
	{3351899392U, 24},
	{3351900160U, 24},
	{3352101120U, 24},
	{3352298496U, 24},
	{3352298752U, 24},
	{3352299008U, 24},
	{3352299264U, 24},
	{3352320000U, 23},
	{3352320768U, 24},
	{3352321024U, 24},
	{3352322048U, 24},
	{3352325632U, 24},
	{3352337664U, 24},
	{3352337920U, 24},
	{3352341504U, 24},
	{3352345856U, 24},
	{3352347136U, 23},
	{3352352000U, 24},
	{3352359424U, 24},
	{3352360704U, 24},
	{3352360960U, 24},
	{3352361216U, 24},
	{3352363008U, 23},
	{3352367104U, 22},
	{3352368128U, 23},
	{3352368640U, 24},
	{3352371456U, 24},
	{3352372736U, 24},
	{3352372992U, 24},
	{3352510720U, 24},
	{3352514816U, 24},
	{3352516864U, 24},
	{3352519680U, 24},
	{3352521216U, 24},
	{3352524032U, 24},
	{3352524288U, 23},
	{3352524800U, 24},
	{3352525056U, 24},
	{3352525312U, 24},
	{3352526848U, 23},
	{3352527616U, 24},
	{3352528384U, 24},
	{3352532480U, 24},
	{3352534272U, 24},
	{3352534528U, 23},
	{3352535040U, 24},
	{3352535296U, 24},
	{3352535552U, 24},
	{3352535808U, 24},
	{3352538112U, 22},
	{3352540160U, 24},
	{3352540416U, 24},
	{3352540672U, 24},
	{3352540928U, 24},
	{3352543232U, 23},
	{3352544512U, 24},
	{3352544768U, 24},
	{3352545024U, 24},
	{3352548096U, 24},
	{3352548864U, 24},
	{3352550144U, 24},
	{3352550400U, 24},
	{3352551680U, 24},
	{3352551936U, 24},
	{3352552448U, 24},
	{3352558848U, 24},
	{3352575744U, 24},
	{3352885760U, 23},
	{3352889344U, 21},
	{3352920064U, 17},
	{3352936448U, 24},
	{3352936960U, 23},
	{3352941568U, 24},
	{3352942080U, 23},
	{3352942848U, 24},
	{3352943616U, 24},
	{3352952832U, 16},
	{3353019648U, 24},
	{3353051136U, 18},
	{3353067520U, 20},
	{3353071616U, 21},
	{3353073664U, 24},
	{3353166080U, 24},
	{3353206784U, 19},
	{3353216000U, 24},
	{3353223424U, 24},
	{3353240576U, 24},
	{3353247744U, 20},
	{3353251072U, 24},
	{3353255936U, 20},
	{3353316096U, 24},
	{3353318656U, 24},
	{3353320192U, 24},
	{3353320448U, 24},
	{3353320960U, 24},
	{3353324288U, 24},
	{3353326080U, 24},
	{3353326592U, 24},
	{3353346048U, 20},
	{3353346560U, 23},
	{3353348864U, 24},
	{3353349120U, 24},
	{3353517056U, 24},
	{3353542656U, 24},
	{3353555456U, 24},
	{3353555968U, 23},
	{3353556992U, 23},
	{3353561088U, 24},
	{3353568256U, 23},
	{3353569024U, 24},
	{3353572096U, 24},
	{3353572864U, 23},
	{3353573376U, 23},
	{3353574400U, 24},
	{3353575168U, 24},
	{3353575936U, 24},
	{3353576960U, 24},
	{3353577728U, 24},
	{3353578752U, 24},
	{3353580032U, 24},
	{3353581824U, 24},
	{3353582080U, 24},
	{3353583104U, 24},
	{3353584896U, 24},
	{3353591296U, 23},
	{3353595904U, 23},
	{3353654528U, 24},
	{3353673984U, 24},
	{3353676032U, 24},
	{3353676288U, 24},
	{3353677056U, 24},
	{3353677312U, 24},
	{3353678848U, 24},
	{3353694720U, 24},
	{3353698560U, 24},
	{3353703168U, 24},
	{3353743360U, 21},
	{3353745920U, 24},
	{3353746688U, 24},
	{3353772032U, 24},
	{3353772288U, 24},
	{3353772544U, 24},
	{3353803008U, 24},
	{3353817344U, 24},
	{3353817600U, 24},
	{3353817856U, 24},
	{3353870336U, 16},
	{3353884672U, 21},
	{3353893888U, 22},
	{3353904128U, 23},
	{3353954816U, 24},
	{3353955584U, 24},
	{3353956352U, 24},
	{3353956864U, 24},
	{3353958144U, 24},
	{3353959168U, 24},
	{3353959936U, 24},
	{3353960960U, 24},
	{3353961216U, 24},
	{3353962496U, 24},
	{3353963520U, 24},
	{3353968896U, 24},
	{3353969152U, 24},
	{3353970176U, 24},
	{3353970432U, 24},
	{3353972992U, 24},
	{3353975040U, 24},
	{3353975296U, 23},
	{3353976320U, 24},
	{3353982208U, 24},
	{3353982464U, 24},
	{3353983232U, 24},
	{3353985280U, 24},
	{3353989888U, 24},
	{3353990400U, 24},
	{3353991168U, 24},
	{3354001408U, 16},
	{3354001920U, 23},
	{3354011648U, 22},
	{3354012672U, 24},
	{3354017280U, 23},
	{3354017792U, 20},
	{3354021888U, 22},
	{3354022912U, 23},
	{3354025984U, 21},
	{3354028032U, 23},
	{3354038272U, 24},
	{3354038784U, 24},
	{3354058752U, 24},
	{3354059008U, 24},
	{3354059520U, 24},
	{3354062848U, 22},
	{3354132480U, 14},
	{3354186752U, 23},
	{3354214400U, 19},
	{3354238976U, 19},
	{3354293504U, 24},
	{3354314752U, 24},
	{3354345472U, 23},
	{3354359040U, 24},
	{3354394624U, 16},
	{3354394624U, 18},
	{3354414336U, 24},
	{3354414592U, 23},
	{3354415616U, 24},
	{3354417152U, 23},
	{3354423296U, 23},
	{3354424576U, 24},
	{3354424832U, 23},
	{3354427904U, 23},
	{3354428416U, 23},
	{3354428928U, 24},
	{3354429184U, 24},
	{3354429440U, 23},
	{3354430976U, 23},
	{3354434304U, 24},
	{3354435072U, 23},
	{3354435840U, 24},
	{3354438144U, 23},
	{3354439424U, 24},
	{3354439680U, 23},
	{3354440448U, 24},
	{3354440704U, 22},
	{3354441472U, 24},
	{3354441728U, 22},
	{3354443776U, 21},
	{3354445824U, 23},
	{3354452480U, 24},
	{3354454016U, 22},
	{3354458112U, 23},
	{3354458624U, 24},
	{3354476544U, 19},
	{3354527488U, 24},
	{3354559232U, 24},
	{3354561024U, 24},
	{3354561792U, 24},
	{3354575360U, 24},
	{3354577152U, 24},
	{3354578432U, 24},
	{3354579712U, 24},
	{3354582784U, 24},
	{3354584576U, 24},
	{3354588160U, 24},
	{3354690560U, 24},
	{3354696448U, 24},
	{3354696704U, 24},
	{3354705920U, 22},
	{3354706944U, 23},
	{3354726400U, 20},
	{3354730496U, 24},
	{3354738688U, 24},
	{3354740992U, 24},
	{3354743040U, 24},
	{3354743296U, 24},
	{3354745088U, 24},
	{3354747136U, 24},
	{3354748672U, 24},
	{3354750464U, 24},
	{3354750976U, 23},
	{3354751488U, 23},
	{3354752512U, 23},
	{3354753024U, 23},
	{3354755072U, 23},
	{3354755840U, 24},
	{3354756608U, 23},
	{3354762496U, 24},
	{3354764032U, 24},
	{3354764288U, 23},
	{3354764800U, 24},
	{3354766336U, 24},
	{3354766592U, 24},
	{3354769152U, 24},
	{3354770432U, 24},
	{3354772736U, 24},
	{3354775040U, 24},
	{3354779904U, 24},
	{3354781440U, 24},
	{3354781696U, 24},
	{3354784256U, 24},
	{3354784768U, 23},
	{3354785280U, 24},
	{3354804992U, 24},
	{3354805248U, 24},
	{3354951680U, 22},
	{3354953216U, 23},
	{3354955776U, 24},
	{3354956032U, 24},
	{3354959616U, 24},
	{3354959872U, 23},
	{3354960384U, 24},
	{3354962432U, 24},
	{3354964992U, 24},
	{3354966272U, 24},
	{3354970368U, 24},
	{3354978304U, 24},
	{3354979840U, 24},
	{3354980096U, 24},
	{3354980352U, 24},
	{3354981632U, 24},
	{3354992640U, 19},
	{3355017216U, 22},
	{3355018240U, 23},
	{3355019264U, 24},
	{3355019520U, 24},
	{3355019776U, 24},
	{3355026176U, 24},
	{3355026688U, 24},
	{3355026944U, 23},
	{3355027456U, 23},
	{3355027712U, 24},
	{3355030528U, 24},
	{3355031808U, 24},
	{3355032320U, 24},
	{3355033344U, 24},
	{3355035392U, 24},
	{3355035648U, 23},
	{3355041536U, 24},
	{3355042816U, 24},
	{3355043072U, 24},
	{3355052032U, 24},
	{3355053312U, 24},
	{3355058176U, 20},
	{3355062272U, 21},
	{3355064320U, 22},
	{3355067904U, 23},
	{3355082752U, 17},
	{3355084800U, 21},
	{3355089920U, 24},
	{3355096320U, 24},
	{3355107840U, 23},
	{3355122432U, 24},
	{3355163392U, 24},
	{3355163648U, 24},
	{3355163904U, 24},
	{3355171072U, 24},
	{3355171328U, 24},
	{3355171584U, 24},
	{3355213824U, 24},
	{3355214592U, 24},
	{3355214848U, 24},
	{3355216128U, 24},
	{3355216384U, 24},
	{3355216640U, 24},
	{3355217408U, 24},
	{3355220224U, 24},
	{3355220736U, 24},
	{3355220992U, 24},
	{3355227136U, 24},
	{3355246592U, 21},
	{3355293696U, 21},
	{3355297792U, 21},
	{3355297792U, 22},
	{3355309568U, 24},
	{3355310080U, 24},
	{3355314176U, 21},
	{3355347456U, 24},
	{3355350016U, 24},
	{3355355392U, 24},
	{3355357952U, 24},
	{3355363072U, 24},
	{3355363584U, 24},
	{3355363840U, 24},
	{3355364352U, 24},
	{3355368448U, 24},
	{3355369728U, 24},
	{3355370496U, 24},
	{3355370752U, 24},
	{3355372032U, 24},
	{3355469568U, 24},
	{3355469824U, 24},
	{3355470080U, 24},
	{3355470336U, 24},
	{3355471616U, 24},
	{3355471872U, 24},
	{3355472128U, 24},
	{3355473408U, 23},
	{3355480064U, 23},
	{3355480832U, 24},
	{3355482880U, 24},
	{3355483392U, 24},
	{3355483648U, 24},
	{3355483904U, 24},
	{3355484928U, 24},
	{3355489792U, 23},
	{3355489792U, 24},
	{3355490048U, 24},
	{3355490304U, 24},
	{3355491072U, 24},
	{3355491328U, 22},
	{3355492608U, 24},
	{3355492864U, 23},
	{3355493376U, 23},
	{3355493888U, 23},
	{3355493888U, 24},
	{3355498496U, 21},
	{3355500544U, 19},
	{3355510784U, 21},
	{3355512832U, 20},
	{3355516928U, 19},
	{3355541504U, 24},
	{3355553024U, 24},
	{3355553536U, 24},
	{3355557888U, 24},
	{3355558144U, 24},
	{3355558400U, 24},
	{3355558656U, 24},
	{3355558912U, 24},
	{3355559168U, 24},
	{3355559424U, 24},
	{3355559680U, 24},
	{3355566080U, 19},
	{3355566336U, 24},
	{3355566592U, 24},
	{3355590656U, 24},
	{3355597568U, 24},
	{3355602944U, 21},
	{3355667968U, 24},
	{3355668736U, 24},
	{3355670528U, 21},
	{3355705344U, 21},
	{3355707392U, 24},
	{3355708928U, 24},
	{3355709184U, 24},
	{3355717632U, 22},
	{3355738112U, 20},
	{3355742208U, 24},
	{3355742720U, 24},
	{3355742976U, 24},
	{3355743232U, 24},
	{3355743488U, 24},
	{3355743744U, 24},
	{3355744000U, 24},
	{3355744256U, 24},
	{3355744512U, 24},
	{3355744768U, 24},
	{3355745024U, 24},
	{3355745280U, 24},
	{3355745536U, 24},
	{3355746048U, 24},
	{3355779072U, 21},
	{3355787264U, 18},
	{3355820032U, 18},
	{3355838464U, 24},
	{3355853056U, 24},
	{3355855104U, 24},
	{3355855360U, 24},
	{3355856128U, 24},
	{3355920896U, 24},
	{3356052224U, 24},
	{3356057856U, 24},
	{3356058112U, 23},
	{3356058624U, 24},
	{3356070144U, 24},
	{3356070400U, 24},
	{3356078080U, 24},
	{3356081408U, 24},
	{3356084480U, 24},
	{3356087296U, 23},
	{3356089088U, 24},
	{3356093184U, 24},
	{3356093696U, 24},
	{3356102656U, 21},
	{3356104704U, 22},
	{3356123136U, 22},
	{3356125696U, 24},
	{3356128000U, 24},
	{3356128256U, 23},
	{3356128512U, 24},
	{3356128768U, 24},
	{3356129280U, 23},
	{3356129792U, 24},
	{3356131328U, 24},
	{3356135168U, 24},
	{3356136192U, 24},
	{3356136448U, 22},
	{3356139776U, 24},
	{3356150272U, 24},
	{3356154624U, 24},
	{3356160768U, 24},
	{3356236032U, 24},
	{3356246016U, 24},
	{3356246272U, 24},
	{3356246528U, 24},
	{3356246784U, 24},
	{3356247296U, 24},
	{3356247808U, 24},
	{3356249600U, 24},
	{3356250880U, 24},
	{3356251136U, 24},
	{3356251648U, 24},
	{3356252160U, 24},
	{3356253952U, 24},
	{3356261888U, 24},
	{3356262144U, 24},
	{3356263680U, 24},
	{3356263936U, 24},
	{3356264192U, 24},
	{3356264448U, 24},
	{3356269056U, 24},
	{3356270080U, 23},
	{3356270592U, 22},
	{3356271616U, 24},
	{3356272128U, 24},
	{3356272640U, 24},
	{3356274688U, 20},
	{3356279040U, 24},
	{3356286976U, 20},
	{3356295168U, 21},
	{3356307456U, 22},
	{3356308480U, 24},
	{3356308736U, 24},
	{3356308992U, 23},
	{3356309504U, 21},
	{3356317696U, 21},
	{3356323328U, 24},
	{3356324864U, 24},
	{3356362752U, 21},
	{3356363520U, 24},
	{3356363776U, 24},
	{3356364032U, 24},
	{3356378112U, 22},
	{3356390912U, 24},
	{3356409856U, 24},
	{3356413952U, 24},
	{3356414208U, 24},
	{3356414464U, 24},
	{3356414720U, 24},
	{3356415744U, 24},
	{3356426240U, 16},
	{3356508160U, 24},
	{3356508416U, 24},
	{3356512256U, 24},
	{3356513024U, 24},
	{3356513792U, 24},
	{3356516352U, 20},
	{3356526592U, 23},
	{3356529664U, 23},
	{3356529664U, 24},
	{3356529920U, 24},
	{3356530688U, 22},
	{3356531712U, 24},
	{3356531968U, 24},
	{3356532224U, 24},
	{3356532480U, 24},
	{3356533248U, 23},
	{3356535296U, 24},
	{3356535552U, 24},
	{3356535808U, 24},
	{3356536064U, 24},
	{3356536576U, 24},
	{3356536832U, 22},
	{3356538624U, 24},
	{3356538880U, 23},
	{3356539392U, 24},
	{3356540160U, 24},
	{3356540416U, 24},
	{3356540928U, 24},
	{3356541440U, 24},
	{3356541952U, 23},
	{3356542464U, 24},
	{3356542720U, 24},
	{3356543488U, 24},
	{3356543744U, 24},
	{3356544000U, 24},
	{3356544256U, 24},
	{3356544512U, 23},
	{3356545280U, 24},
	{3356545536U, 23},
	{3356546048U, 24},
	{3356546304U, 24},
	{3356547584U, 23},
	{3356548352U, 24},
	{3356548864U, 24},
	{3356549120U, 24},
	{3356549632U, 23},
	{3356549632U, 24},
	{3356549888U, 24},
	{3356550144U, 24},
	{3356550656U, 24},
	{3356550912U, 24},
	{3356551168U, 23},
	{3356551680U, 24},
	{3356551936U, 24},
	{3356553984U, 24},
	{3356554240U, 24},
	{3356555264U, 24},
	{3356555520U, 24},
	{3356555776U, 24},
	{3356556032U, 24},
	{3356556288U, 24},
	{3356556800U, 24},
	{3356557056U, 24},
	{3356950784U, 24},
	{3356951296U, 24},
	{3356954624U, 24},
	{3356954880U, 24},
	{3356955904U, 24},
	{3356956160U, 24},
	{3356956416U, 24},
	{3356959744U, 23},
	{3356960768U, 24},
	{3356961024U, 24},
	{3356961280U, 24},
	{3356961536U, 24},
	{3356970496U, 24},
	{3356970752U, 24},
	{3356971008U, 24},
	{3356979456U, 24},
	{3356984320U, 24},
	{3356985344U, 24},
	{3356987648U, 24},
	{3356987904U, 24},
	{3356988672U, 24},
	{3356994816U, 24},
	{3356995840U, 24},
	{3356999680U, 24},
	{3356999936U, 24},
	{3357000192U, 24},
	{3357000448U, 24},
	{3357000704U, 24},
	{3357000960U, 24},
	{3357004288U, 23},
	{3357005312U, 24},
	{3357006080U, 24},
	{3357006592U, 24},
	{3357007360U, 24},
	{3357007616U, 24},
	{3357011968U, 24},
	{3357012736U, 24},
	{3357013248U, 24},
	{3357014016U, 24},
	{3357014272U, 24},
	{3357014528U, 24},
	{3357014784U, 24},
	{3357015040U, 24},
	{3357018112U, 24},
	{3357020160U, 21},
	{3357022208U, 22},
	{3357023232U, 23},
	{3357023744U, 24},
	{3357024000U, 24},
	{3357081600U, 17},
	{3357100544U, 24},
	{3357100800U, 24},
	{3357153792U, 24},
	{3357159424U, 20},
	{3357163520U, 18},
	{3357212672U, 16},
	{3357212672U, 21},
	{3357212672U, 24},
	{3357212928U, 24},
	{3357213184U, 24},
	{3357213696U, 24},
	{3357213952U, 24},
	{3357214208U, 24},
	{3357214464U, 24},
	{3357214720U, 21},
	{3357214720U, 24},
	{3357214976U, 24},
	{3357215488U, 24},
	{3357215744U, 24},
	{3357216000U, 24},
	{3357216256U, 24},
	{3357216512U, 24},
	{3357216768U, 21},
	{3357217024U, 24},
	{3357217280U, 24},
	{3357217792U, 24},
	{3357218048U, 24},
	{3357218304U, 24},
	{3357218560U, 24},
	{3357218816U, 21},
	{3357218816U, 24},
	{3357219072U, 24},
	{3357219328U, 24},
	{3357219840U, 24},
	{3357220096U, 24},
	{3357220352U, 24},
	{3357220608U, 24},
	{3357220864U, 21},
	{3357220864U, 24},
	{3357221120U, 24},
	{3357221376U, 24},
	{3357221632U, 24},
	{3357221888U, 24},
	{3357222144U, 24},
	{3357222400U, 24},
	{3357222656U, 24},
	{3357222912U, 21},
	{3357222912U, 24},
	{3357223168U, 24},
	{3357223424U, 24},
	{3357223936U, 24},
	{3357224192U, 24},
	{3357224448U, 24},
	{3357224704U, 24},
	{3357224960U, 21},
	{3357224960U, 24},
	{3357225216U, 24},
	{3357225472U, 24},
	{3357225728U, 24},
	{3357225984U, 24},
	{3357226240U, 24},
	{3357226496U, 24},
	{3357226752U, 24},
	{3357227008U, 21},
	{3357227008U, 24},
	{3357227264U, 24},
	{3357227776U, 24},
	{3357228032U, 24},
	{3357228288U, 24},
	{3357228544U, 24},
	{3357229056U, 21},
	{3357229056U, 24},
	{3357229312U, 24},
	{3357229568U, 24},
	{3357229824U, 24},
	{3357230080U, 24},
	{3357230336U, 24},
	{3357230592U, 24},
	{3357230848U, 24},
	{3357231104U, 21},
	{3357231104U, 24},
	{3357231360U, 24},
	{3357231872U, 24},
	{3357232128U, 24},
	{3357232384U, 24},
	{3357233152U, 21},
	{3357233664U, 24},
	{3357233920U, 24},
	{3357234176U, 24},
	{3357234432U, 24},
	{3357234688U, 24},
	{3357235200U, 21},
	{3357235200U, 24},
	{3357235712U, 24},
	{3357235968U, 24},
	{3357236480U, 24},
	{3357236736U, 24},
	{3357236992U, 24},
	{3357237248U, 21},
	{3357237248U, 24},
	{3357237504U, 24},
	{3357237760U, 24},
	{3357238016U, 24},
	{3357238528U, 24},
	{3357238784U, 24},
	{3357239040U, 24},
	{3357239296U, 21},
	{3357239296U, 24},
	{3357239552U, 24},
	{3357239808U, 24},
	{3357240064U, 24},
	{3357240320U, 24},
	{3357240576U, 24},
	{3357240832U, 24},
	{3357241088U, 24},
	{3357241344U, 21},
	{3357241344U, 24},
	{3357241600U, 24},
	{3357241856U, 24},
	{3357242112U, 24},
	{3357242368U, 24},
	{3357242880U, 24},
	{3357243392U, 21},
	{3357243648U, 24},
	{3357243904U, 24},
	{3357244160U, 24},
	{3357244672U, 24},
	{3357245440U, 21},
	{3357245696U, 24},
	{3357245952U, 24},
	{3357246208U, 24},
	{3357246464U, 24},
	{3357246720U, 24},
	{3357246976U, 24},
	{3357247232U, 24},
	{3357247488U, 21},
	{3357247488U, 24},
	{3357247744U, 24},
	{3357248000U, 24},
	{3357248256U, 24},
	{3357248512U, 24},
	{3357248768U, 24},
	{3357249024U, 24},
	{3357249280U, 24},
	{3357249536U, 21},
	{3357249536U, 24},
	{3357249792U, 24},
	{3357250048U, 24},
	{3357250304U, 24},
	{3357250560U, 24},
	{3357250816U, 24},
	{3357251328U, 24},
	{3357251584U, 21},
	{3357251584U, 24},
	{3357251840U, 24},
	{3357252096U, 24},
	{3357252352U, 24},
	{3357252608U, 24},
	{3357252864U, 24},
	{3357253632U, 21},
	{3357253632U, 24},
	{3357254144U, 24},
	{3357254400U, 24},
	{3357254656U, 24},
	{3357254912U, 24},
	{3357255168U, 24},
	{3357255424U, 24},
	{3357255680U, 21},
	{3357255936U, 24},
	{3357256192U, 24},
	{3357256448U, 24},
	{3357257216U, 24},
	{3357257472U, 24},
	{3357257728U, 21},
	{3357257728U, 24},
	{3357257984U, 24},
	{3357258240U, 24},
	{3357258496U, 24},
	{3357258752U, 24},
	{3357259008U, 24},
	{3357259264U, 24},
	{3357259776U, 21},
	{3357259776U, 24},
	{3357260032U, 24},
	{3357260544U, 24},
	{3357260800U, 24},
	{3357261824U, 21},
	{3357261824U, 24},
	{3357262336U, 24},
	{3357262592U, 24},
	{3357262848U, 24},
	{3357263104U, 24},
	{3357263360U, 24},
	{3357263616U, 24},
	{3357263872U, 21},
	{3357263872U, 24},
	{3357264128U, 24},
	{3357264384U, 24},
	{3357264640U, 24},
	{3357264896U, 24},
	{3357265152U, 24},
	{3357265408U, 24},
	{3357265664U, 24},
	{3357265920U, 21},
	{3357266432U, 24},
	{3357267968U, 21},
	{3357267968U, 24},
	{3357268480U, 24},
	{3357269248U, 24},
	{3357269504U, 24},
	{3357269760U, 24},
	{3357270016U, 21},
	{3357270016U, 24},
	{3357270272U, 24},
	{3357270784U, 24},
	{3357271040U, 24},
	{3357271296U, 24},
	{3357271552U, 24},
	{3357271808U, 24},
	{3357272064U, 21},
	{3357272320U, 24},
	{3357272576U, 24},
	{3357272832U, 24},
	{3357273088U, 24},
	{3357273600U, 24},
	{3357273856U, 24},
	{3357274112U, 21},
	{3357274112U, 24},
	{3357274368U, 24},
	{3357274624U, 24},
	{3357274880U, 24},
	{3357275392U, 24},
	{3357275648U, 24},
	{3357275904U, 24},
	{3357276160U, 21},
	{3357276416U, 24},
	{3357276672U, 24},
	{3357277440U, 24},
	{3357277696U, 24},
	{3357317120U, 24},
	{3357347072U, 24},
	{3357442048U, 24},
	{3357442304U, 24},
	{3357446144U, 24},
	{3357446400U, 24},
	{3357458432U, 24},
	{3357458688U, 24},
	{3357458944U, 24},
	{3357459200U, 24},
	{3357459456U, 24},
	{3357459712U, 24},
	{3357459968U, 24},
	{3357460224U, 24},
	{3357460480U, 24},
	{3357460736U, 24},
	{3357460992U, 24},
	{3357461248U, 24},
	{3357461504U, 24},
	{3357461760U, 24},
	{3357462016U, 24},
	{3357462272U, 24},
	{3357462528U, 24},
	{3357462784U, 24},
	{3357463040U, 24},
	{3357463296U, 24},
	{3357463552U, 24},
	{3357463808U, 24},
	{3357464064U, 24},
	{3357464320U, 24},
	{3357464576U, 24},
	{3357464832U, 24},
	{3357465088U, 24},
	{3357465344U, 24},
	{3357465600U, 24},
	{3357465856U, 24},
	{3357466112U, 24},
	{3357466368U, 24},
	{3357474816U, 19},
	{3357474816U, 24},
	{3357475840U, 24},
	{3357476096U, 24},
	{3357476352U, 24},
	{3357476608U, 24},
	{3357476864U, 24},
	{3357477120U, 24},
	{3357477376U, 24},
	{3357477888U, 24},
	{3357478144U, 24},
	{3357478400U, 24},
	{3357478656U, 24},
	{3357478912U, 24},
	{3357479168U, 24},
	{3357479424U, 24},
	{3357479680U, 24},
	{3357479936U, 22},
	{3357480960U, 24},
	{3357481216U, 24},
	{3357481472U, 23},
	{3357481984U, 22},
	{3357540352U, 19},
	{3357540352U, 21},
	{3357542400U, 21},
	{3357544448U, 21},
	{3357546496U, 21},
	{3357548544U, 19},
	{3357556736U, 18},
	{3357560832U, 24},
	{3357561088U, 24},
	{3357561344U, 24},
	{3357561600U, 24},
	{3357573120U, 19},
	{3357609728U, 24},
	{3357609984U, 24},
	{3357611008U, 24},
	{3357611264U, 24},
	{3357613568U, 24},
	{3357618688U, 24},
	{3357619456U, 24},
	{3357620224U, 24},
	{3357623296U, 24},
	{3357624064U, 24},
	{3357630720U, 24},
	{3357631232U, 24},
	{3357631488U, 22},
	{3357632512U, 24},
	{3357635584U, 24},
	{3357635840U, 24},
	{3357640704U, 24},
	{3357640960U, 24},
	{3357641216U, 24},
	{3357641728U, 24},
	{3357641984U, 24},
	{3357642240U, 24},
	{3357642496U, 24},
	{3357642752U, 24},
	{3357643008U, 24},
	{3357643264U, 24},
	{3357644544U, 24},
	{3357647872U, 22},
	{3357649408U, 24},
	{3357652224U, 24},
	{3357654016U, 22},
	{3357658880U, 24},
	{3357668608U, 24},
	{3357670400U, 24},
	{3357679616U, 20},
	{3357682688U, 24},
	{3357698560U, 24},
	{3357698816U, 24},
	{3357699072U, 24},
	{3357699328U, 24},
	{3357699584U, 24},
	{3357707776U, 24},
	{3357709824U, 24},
	{3357710848U, 24},
	{3357712128U, 24},
	{3357712384U, 22},
	{3357713408U, 22},
	{3357714432U, 24},
	{3357714688U, 24},
	{3357715200U, 24},
	{3357718272U, 24},
	{3357719808U, 24},
	{3357720064U, 24},
	{3357720320U, 24},
	{3357728000U, 24},
	{3357802496U, 16},
	{3357802496U, 19},
	{3357809664U, 22},
	{3357810688U, 19},
	{3357811456U, 24},
	{3357818880U, 19},
	{3357843456U, 20},
	{3357847552U, 20},
	{3357933568U, 19},
	{3357941760U, 19},
	{3357966336U, 19},
	{3357972480U, 24},
	{3357982720U, 19},
	{3357988096U, 24},
	{3357988608U, 24},
	{3357990400U, 24},
	{3357995264U, 24},
	{3358040064U, 19},
	{3358048256U, 19},
	{3358048256U, 24},
	{3358064640U, 20},
	{3358068736U, 20},
	{3358068736U, 21},
	{3358070784U, 22},
	{3358071808U, 22},
	{3358072832U, 19},
	{3358075648U, 24},
	{3358079232U, 24},
	{3358081024U, 20},
	{3358085120U, 20},
	{3358089216U, 20},
	{3358093312U, 20},
	{3358097408U, 19},
	{3358097408U, 20},
	{3358101504U, 20},
	{3358130176U, 17},
	{3358132480U, 24},
	{3358148608U, 22},
	{3358148608U, 23},
	{3358149120U, 23},
	{3358149632U, 24},
	{3358149888U, 24},
	{3358150144U, 24},
	{3358150400U, 24},
	{3358154240U, 23},
	{3358156032U, 24},
	{3358159616U, 24},
	{3358163200U, 24},
	{3358163968U, 24},
	{3358164224U, 24},
	{3358164992U, 22},
	{3358167040U, 24},
	{3358167552U, 23},
	{3358168320U, 24},
	{3358169088U, 23},
	{3358169600U, 24},
	{3358170624U, 24},
	{3358170880U, 24},
	{3358172416U, 24},
	{3358172672U, 24},
	{3358172928U, 24},
	{3358173184U, 24},
	{3358173440U, 24},
	{3358174208U, 24},
	{3358174464U, 24},
	{3358174720U, 24},
	{3358174976U, 24},
	{3358175744U, 24},
	{3358176000U, 24},
	{3358177792U, 24},
	{3358178048U, 24},
	{3358179584U, 24},
	{3358180864U, 24},
	{3358181120U, 24},
	{3358182144U, 24},
	{3358182400U, 24},
	{3358182656U, 24},
	{3358182912U, 24},
	{3358183424U, 24},
	{3358183680U, 24},
	{3358183936U, 23},
	{3358187520U, 20},
	{3358192640U, 24},
	{3358193152U, 23},
	{3358193664U, 24},
	{3358195712U, 19},
	{3358195712U, 21},
	{3358197760U, 21},
	{3358199808U, 21},
	{3358201856U, 21},
	{3358203904U, 24},
	{3358204160U, 24},
	{3358212096U, 19},
	{3358212096U, 21},
	{3358214144U, 21},
	{3358216192U, 21},
	{3358220288U, 19},
	{3358220288U, 21},
	{3358222336U, 21},
	{3358224384U, 21},
	{3358226432U, 21},
	{3358228480U, 19},
	{3358228480U, 21},
	{3358230528U, 21},
	{3358232576U, 21},
	{3358234624U, 21},
	{3358265856U, 24},
	{3358266112U, 24},
	{3358266368U, 24},
	{3358266624U, 24},
	{3358530048U, 23},
	{3358561792U, 24},
	{3358562304U, 22},
	{3358563840U, 24},
	{3358578688U, 24},
	{3358578944U, 24},
	{3358579200U, 24},
	{3358579456U, 24},
	{3358579712U, 24},
	{3358654464U, 23},
	{3358656512U, 21},
	{3358662656U, 22},
	{3358663680U, 24},
	{3358664192U, 24},
	{3358664704U, 22},
	{3358665728U, 22},
	{3358670848U, 19},
	{3358671616U, 24},
	{3358677504U, 24},
	{3358679040U, 20},
	{3358687232U, 19},
	{3358703616U, 22},
	{3358704640U, 22},
	{3358704640U, 24},
	{3358704896U, 24},
	{3358705152U, 24},
	{3358705408U, 24},
	{3358705664U, 22},
	{3358706688U, 22},
	{3358707712U, 21},
	{3358709760U, 21},
	{3358711808U, 20},
	{3358785536U, 23},
	{3358786560U, 24},
	{3358786816U, 24},
	{3358787584U, 23},
	{3358788608U, 23},
	{3358790400U, 24},
	{3358790656U, 23},
	{3358791424U, 24},
	{3358791680U, 23},
	{3358792192U, 24},
	{3358792448U, 24},
	{3358792704U, 24},
	{3358793216U, 24},
	{3358793472U, 24},
	{3358793728U, 24},
	{3358794496U, 24},
	{3358794752U, 22},
	{3358795776U, 21},
	{3358798336U, 24},
	{3358798592U, 24},
	{3358798848U, 24},
	{3358799104U, 24},
	{3358801408U, 24},
	{3358801920U, 24},
	{3358802176U, 24},
	{3358802688U, 24},
	{3358802944U, 24},
	{3358803456U, 24},
	{3358803712U, 24},
	{3358803968U, 24},
	{3358804224U, 24},
	{3358805504U, 24},
	{3358806016U, 20},
	{3358810112U, 21},
	{3358815232U, 24},
	{3358817280U, 23},
	{3358818304U, 24},
	{3358818560U, 24},
	{3358821376U, 22},
	{3358822400U, 20},
	{3358826496U, 22},
	{3358827520U, 23},
	{3358828032U, 24},
	{3358828288U, 24},
	{3358829056U, 24},
	{3358829312U, 24},
	{3358831104U, 23},
	{3358831616U, 22},
	{3358832640U, 24},
	{3358832896U, 24},
	{3358833664U, 23},
	{3358834688U, 20},
	{3358838784U, 22},
	{3358839808U, 22},
	{3358840832U, 23},
	{3358841344U, 24},
	{3358841600U, 24},
	{3358841856U, 22},
	{3358844928U, 22},
	{3358845952U, 22},
	{3358846976U, 23},
	{3358847488U, 23},
	{3358850048U, 22},
	{3358857216U, 21},
	{3358877440U, 24},
	{3358879744U, 24},
	{3358880512U, 24},
	{3358880768U, 24},
	{3358881024U, 24},
	{3358881280U, 24},
	{3358881536U, 24},
	{3358883328U, 24},
	{3358883584U, 24},
	{3358887936U, 20},
	{3358912512U, 20},
	{3358973952U, 20},
	{3358978048U, 24},
	{3358978304U, 24},
	{3358978560U, 24},
	{3358978816U, 24},
	{3358979072U, 24},
	{3358979328U, 24},
	{3358979584U, 24},
	{3358979840U, 24},
	{3358980096U, 24},
	{3358980352U, 24},
	{3358980608U, 24},
	{3358980864U, 24},
	{3358981120U, 24},
	{3358981376U, 24},
	{3358981632U, 24},
	{3358981888U, 24},
	{3359047680U, 18},
	{3359051520U, 24},
	{3359052288U, 24},
	{3359052544U, 24},
	{3359054848U, 23},
	{3359057920U, 24},
	{3359058176U, 24},
	{3359058688U, 24},
	{3359141888U, 24},
	{3359142144U, 24},
	{3359142400U, 24},
	{3359142656U, 24},
	{3359142912U, 24},
	{3359144704U, 24},
	{3359145472U, 24},
	{3359162368U, 24},
	{3359162624U, 24},
	{3359162880U, 24},
	{3359163136U, 24},
	{3359163392U, 24},
	{3359163648U, 24},
	{3359163904U, 24},
	{3359164160U, 24},
	{3359164416U, 24},
	{3359170560U, 20},
	{3359186944U, 20},
	{3359199232U, 20},
	{3359211520U, 20},
	{3359215616U, 20},
	{3359321088U, 22},
	{3359326208U, 21},
	{3359332864U, 24},
	{3359334144U, 24},
	{3359342592U, 19},
	{3359342592U, 20},
	{3359343360U, 24},
	{3359449088U, 20},
	{3359449088U, 23},
	{3359449600U, 23},
	{3359450112U, 23},
	{3359450624U, 23},
	{3359450880U, 24},
	{3359451136U, 23},
	{3359451648U, 23},
	{3359452160U, 23},
	{3359452672U, 23},
	{3359453184U, 23},
	{3359454208U, 23},
	{3359458304U, 22},
	{3359459328U, 24},
	{3359473664U, 21},
	{3359476736U, 22},
	{3359477760U, 24},
	{3359478272U, 24},
	{3359479552U, 24},
	{3359479808U, 24},
	{3359480320U, 23},
	{3359480832U, 23},
	{3359481344U, 24},
	{3359481600U, 24},
	{3359490048U, 19},
	{3359571968U, 19},
	{3359588352U, 20},
	{3359637504U, 16},
	{3359637504U, 18},
	{3359653888U, 18},
	{3359670272U, 19},
	{3359678464U, 19},
	{3359686656U, 19},
	{3359694848U, 19},
	{3359703040U, 16},
	{3359703040U, 18},
	{3359719424U, 18},
	{3359735808U, 19},
	{3359744000U, 19},
	{3359752192U, 19},
	{3359760384U, 19},
	{3359965184U, 22},
	{3359966208U, 22},
	{3359967232U, 22},
	{3359968256U, 22},
	{3359981568U, 19},
	{3360030720U, 16},
	{3366780928U, 16},
	{3366912000U, 18},
	{3366916096U, 20},
	{3366920192U, 20},
	{3366926336U, 21},
	{3367723008U, 20},
	{3367829504U, 22},
	{3367830528U, 22},
	{3367895040U, 16},
	{3368026112U, 18},
	{3368046592U, 20},
	{3368083456U, 21},
	{3368173568U, 19},
	{3368300544U, 20},
	{3368464384U, 20},
	{3370209280U, 20},
	{3370225664U, 20},
	{3370237952U, 18},
	{3370237952U, 21},
	{3370240000U, 21},
	{3370242048U, 21},
	{3370244096U, 21},
	{3370246144U, 21},
	{3370248192U, 21},
	{3370250240U, 21},
	{3370252288U, 21},
	{3370270720U, 18},
	{3370287104U, 17},
	{3370450944U, 20},
	{3370459136U, 20},
	{3370479616U, 24},
	{3370479872U, 24},
	{3370480128U, 24},
	{3370480896U, 24},
	{3370481152U, 24},
	{3370481920U, 24},
	{3370508288U, 20},
	{3370512384U, 21},
	{3379782656U, 24},
	{3389001728U, 20},
	{3389014016U, 24},
	{3389014272U, 24},
	{3389015808U, 24},
	{3389016832U, 24},
	{3389018624U, 24},
	{3389019392U, 24},
	{3389022208U, 24},
	{3389023744U, 24},
	{3389024512U, 24},
	{3389024768U, 24},
	{3389027584U, 24},
	{3389027840U, 24},
	{3389029888U, 24},
	{3389030144U, 24},
	{3389035776U, 24},
	{3389037312U, 24},
	{3389041152U, 24},
	{3389041408U, 24},
	{3389041664U, 24},
	{3389041920U, 24},
	{3389063936U, 24},
	{3389064704U, 24},
	{3389064960U, 24},
	{3389067776U, 24},
	{3389120512U, 21},
	{3389122816U, 24},
	{3389123072U, 24},
	{3389130752U, 21},
	{3389142016U, 22},
	{3389149184U, 21},
	{3389194240U, 22},
	{3389194496U, 24},
	{3389195264U, 24},
	{3389196288U, 22},
	{3389196544U, 24},
	{3389196800U, 24},
	{3389197312U, 24},
	{3389202432U, 19},
	{3389210624U, 24},
	{3389210880U, 24},
	{3389211136U, 24},
	{3389211392U, 24},
	{3389259776U, 21},
	{3389261824U, 24},
	{3389300736U, 23},
	{3389301248U, 24},
	{3389307136U, 24},
	{3389307392U, 24},
	{3389307648U, 24},
	{3389308160U, 24},
	{3389333504U, 19},
	{3389341696U, 20},
	{3389349888U, 19},
	{3389366528U, 24},
	{3389366784U, 24},
	{3389367040U, 24},
	{3389367552U, 24},
	{3389368576U, 24},
	{3389369088U, 24},
	{3389374464U, 19},
	{3389405184U, 24},
	{3389407488U, 24},
	{3389411584U, 24},
	{3389413888U, 24},
	{3389414144U, 24},
	{3389416448U, 23},
	{3389418240U, 24},
	{3389419776U, 24},
	{3389422592U, 22},
	{3389423616U, 20},
	{3389427712U, 20},
	{3389455360U, 22},
	{3389458432U, 21},
	{3389460224U, 24},
	{3389464576U, 24},
	{3389471744U, 24},
	{3389472768U, 19},
	{3389476864U, 21},
	{3389480960U, 24},
	{3389481216U, 24},
	{3389481472U, 24},
	{3389481728U, 24},
	{3389481984U, 24},
	{3389482240U, 24},
	{3389482496U, 24},
	{3389482752U, 24},
	{3389483008U, 24},
	{3389483264U, 24},
	{3389483520U, 24},
	{3389483776U, 24},
	{3389484032U, 24},
	{3389484288U, 24},
	{3389484544U, 24},
	{3389484800U, 24},
	{3389498368U, 24},
	{3389499136U, 24},
	{3389499392U, 24},
	{3389499648U, 24},
	{3389499904U, 24},
	{3389500928U, 24},
	{3389501184U, 24},
	{3389502208U, 24},
	{3389502464U, 24},
	{3389502976U, 24},
	{3389503232U, 24},
	{3389504000U, 24},
	{3389504256U, 24},
	{3389504512U, 24},
	{3389504768U, 24},
	{3389505024U, 24},
	{3389505280U, 24},
	{3389505792U, 24},
	{3389506560U, 24},
	{3389507584U, 24},
	{3389509120U, 24},
	{3389509376U, 24},
	{3389511168U, 24},
	{3389511424U, 24},
	{3389511936U, 24},
	{3389513216U, 24},
	{3389513472U, 24},
	{3389513728U, 19},
	{3389522176U, 24},
	{3389546496U, 19},
	{3389579264U, 19},
	{3389579264U, 24},
	{3389579520U, 24},
	{3389579776U, 24},
	{3389580032U, 24},
	{3389582336U, 24},
	{3389582592U, 24},
	{3389582848U, 24},
	{3389584128U, 24},
	{3389584384U, 24},
	{3389584640U, 24},
	{3389584896U, 24},
	{3389585152U, 24},
	{3389585408U, 24},
	{3389585664U, 24},
	{3389587200U, 24},
	{3389595648U, 19},
	{3389603840U, 19},
	{3389612032U, 20},
	{3389624320U, 24},
	{3389626112U, 24},
	{3389628416U, 22},
	{3389632000U, 24},
	{3389633280U, 24},
	{3389634304U, 24},
	{3389634560U, 24},
	{3389635328U, 24},
	{3389635584U, 22},
	{3389636352U, 24},
	{3389644800U, 19},
	{3389652736U, 24},
	{3389652992U, 19},
	{3389671424U, 21},
	{3389685760U, 17},
	{3389702144U, 18},
	{3389716480U, 22},
	{3389718528U, 21},
	{3389721600U, 22},
	{3389734400U, 23},
	{3389743104U, 21},
	{3389745152U, 21},
	{3389749248U, 22},
	{3389750272U, 23},
	{3389751040U, 24},
	{3389753856U, 24},
	{3389759488U, 22},
	{3389760512U, 23},
	{3389761024U, 23},
	{3389761536U, 21},
	{3389765632U, 23},
	{3389767680U, 20},
	{3389772800U, 24},
	{3389773312U, 24},
	{3389773824U, 22},
	{3389775872U, 22},
	{3389779968U, 21},
	{3389784832U, 24},
	{3389786112U, 24},
	{3389790720U, 24},
	{3389790976U, 24},
	{3389791232U, 24},
	{3389791488U, 24},
	{3389791744U, 24},
	{3389799936U, 24},
	{3389801472U, 24},
	{3389801728U, 24},
	{3389802752U, 24},
	{3389803008U, 24},
	{3389806080U, 24},
	{3389806336U, 24},
	{3389806848U, 24},
	{3389807104U, 24},
	{3389807872U, 24},
	{3389808128U, 23},
	{3389808896U, 24},
	{3389811456U, 24},
	{3389811712U, 24},
	{3389812736U, 24},
	{3389812992U, 24},
	{3389816576U, 24},
	{3389818112U, 24},
	{3389818368U, 24},
	{3389818624U, 24},
	{3389818880U, 24},
	{3389819136U, 24},
	{3389819392U, 24},
	{3389820160U, 24},
	{3389820928U, 24},
	{3389821696U, 24},
	{3389822464U, 24},
	{3389822720U, 24},
	{3389822976U, 24},
	{3389823232U, 24},
	{3389823488U, 24},
	{3389824000U, 24},
	{3389824512U, 24},
	{3389825024U, 24},
	{3389827840U, 24},
	{3389829632U, 24},
	{3389829888U, 24},
	{3389831168U, 24},
	{3389831424U, 24},
	{3389834240U, 24},
	{3389836800U, 24},
	{3389837824U, 24},
	{3389843712U, 24},
	{3389845248U, 24},
	{3389845760U, 24},
	{3389846016U, 24},
	{3389849600U, 22},
	{3389850624U, 23},
	{3389851648U, 21},
	{3389853696U, 21},
	{3389860352U, 24},
	{3389864448U, 24},
	{3389870592U, 23},
	{3389871104U, 22},
	{3389872384U, 24},
	{3389882368U, 19},
	{3389890560U, 20},
	{3389895680U, 23},
	{3389897984U, 24},
	{3389898752U, 19},
	{3389906944U, 21},
	{3389910016U, 22},
	{3389920000U, 24},
	{3389923328U, 19},
	{3389934848U, 24},
	{3389935872U, 24},
	{3389936128U, 24},
	{3389937920U, 24},
	{3389939456U, 24},
	{3389939712U, 24},
	{3389940480U, 24},
	{3389941248U, 24},
	{3389943296U, 24},
	{3389943808U, 24},
	{3389944064U, 24},
	{3389945088U, 24},
	{3389947904U, 24},
	{3389949440U, 24},
	{3389951232U, 24},
	{3389952256U, 24},
	{3389953024U, 24},
	{3389954048U, 24},
	{3389957120U, 24},
	{3389957632U, 24},
	{3389960448U, 24},
	{3389960704U, 24},
	{3389960960U, 24},
	{3389961216U, 24},
	{3389961472U, 24},
	{3389961728U, 24},
	{3389962752U, 24},
	{3389963776U, 24},
	{3389964032U, 24},
	{3389964544U, 24},
	{3389964800U, 24},
	{3389965056U, 24},
	{3389965312U, 24},
	{3389965568U, 24},
	{3389965824U, 24},
	{3389969152U, 24},
	{3389969408U, 24},
	{3389969920U, 24},
	{3389970176U, 24},
	{3389970432U, 24},
	{3389970688U, 24},
	{3389971712U, 24},
	{3389973760U, 24},
	{3389975040U, 24},
	{3389976576U, 24},
	{3389976832U, 24},
	{3389977088U, 24},
	{3389977344U, 24},
	{3389977600U, 24},
	{3389978368U, 24},
	{3389978624U, 23},
	{3389979136U, 24},
	{3389979648U, 24},
	{3389984768U, 20},
	{3389988864U, 21},
	{3389997056U, 24},
	{3390000640U, 24},
	{3390004992U, 24},
	{3390007552U, 24},
	{3390009344U, 22},
	{3390013440U, 18},
	{3390042112U, 24},
	{3390044160U, 22},
	{3390072832U, 24},
	{3390077440U, 23},
	{3390077952U, 23},
	{3390078976U, 20},
	{3390086912U, 24},
	{3390095360U, 21},
	{3390099456U, 20},
	{3390103552U, 24},
	{3390103808U, 24},
	{3390115840U, 20},
	{3390119424U, 23},
	{3390136320U, 23},
	{3390138368U, 21},
	{3390142464U, 21},
	{3390144512U, 19},
	{3390155264U, 23},
	{3390155776U, 22},
	{3390157824U, 24},
	{3390158336U, 24},
	{3390158848U, 22},
	{3390160896U, 23},
	{3390162944U, 21},
	{3390164992U, 22},
	{3390166016U, 22},
	{3390173696U, 23},
	{3390173696U, 24},
	{3390176768U, 24},
	{3390177536U, 24},
	{3390185472U, 19},
	{3390193664U, 18},
	{3390218240U, 20},
	{3390224384U, 22},
	{3390225408U, 22},
	{3390237440U, 24},
	{3390240768U, 23},
	{3390241280U, 24},
	{3390242816U, 20},
	{3390251008U, 24},
	{3390253056U, 22},
	{3390268416U, 22},
	{3390269440U, 23},
	{3390271488U, 24},
	{3390273536U, 24},
	{3390274816U, 24},
	{3390277632U, 21},
	{3390279680U, 21},
	{3390285824U, 21},
	{3390288640U, 24},
	{3390288896U, 22},
	{3390297600U, 23},
	{3390300160U, 21},
	{3390302208U, 22},
	{3390303232U, 24},
	{3390303488U, 24},
	{3390312448U, 20},
	{3390324736U, 24},
	{3390324992U, 24},
	{3390325504U, 24},
	{3390325760U, 24},
	{3390326016U, 24},
	{3390329088U, 24},
	{3390329856U, 23},
	{3390331648U, 24},
	{3390331904U, 24},
	{3390333696U, 24},
	{3390335232U, 24},
	{3390335488U, 23},
	{3390337280U, 24},
	{3390338816U, 24},
	{3390341120U, 17},
	{3390373888U, 21},
	{3390375936U, 21},
	{3390382080U, 19},
	{3390406656U, 24},
	{3390410752U, 24},
	{3390412032U, 24},
	{3390414080U, 24},
	{3390439424U, 21},
	{3390441472U, 21},
	{3390447616U, 19},
	{3390480384U, 24},
	{3390480640U, 24},
	{3390480896U, 24},
	{3390481920U, 24},
	{3390482176U, 24},
	{3390483456U, 22},
	{3390503936U, 22},
	{3390521344U, 21},
	{3390523392U, 21},
	{3390527488U, 24},
	{3390528768U, 24},
	{3390537728U, 18},
	{3390554112U, 21},
	{3390566400U, 21},
	{3390568448U, 24},
	{3390580736U, 22},
	{3390587392U, 24},
	{3390587904U, 24},
	{3390590976U, 21},
	{3390594048U, 22},
	{3390606336U, 22},
	{3390607360U, 21},
	{3390611456U, 21},
	{3390614528U, 23},
	{3390617600U, 22},
	{3390618624U, 22},
	{3390619648U, 24},
	{3390621696U, 23},
	{3390631936U, 21},
	{3390653440U, 22},
	{3390656512U, 20},
	{3390661376U, 24},
	{3390662656U, 21},
	{3390664960U, 24},
	{3390665472U, 24},
	{3390665728U, 22},
	{3390672896U, 20},
	{3390677504U, 23},
	{3390679040U, 21},
	{3390685184U, 20},
	{3390692352U, 24},
	{3390692608U, 24},
	{3390693120U, 24},
	{3390693376U, 20},
	{3390701568U, 18},
	{3390709504U, 24},
	{3390725120U, 24},
	{3390725632U, 23},
	{3390736384U, 22},
	{3390737408U, 22},
	{3390738432U, 20},
	{3390742528U, 20},
	{3390749184U, 24},
	{3390749696U, 22},
	{3390751744U, 22},
	{3390752768U, 21},
	{3390754816U, 20},
	{3390758912U, 22},
	{3390759936U, 22},
	{3390765056U, 23},
	{3390767104U, 16},
	{3390771200U, 20},
	{3390771456U, 24},
	{3390787840U, 24},
	{3390788352U, 24},
	{3390792704U, 22},
	{3390793472U, 24},
	{3390795264U, 24},
	{3390796032U, 24},
	{3390807040U, 22},
	{3390814208U, 23},
	{3390816256U, 21},
	{3390818304U, 22},
	{3390819328U, 24},
	{3390820608U, 24},
	{3390820864U, 24},
	{3390821120U, 24},
	{3390821376U, 22},
	{3390822400U, 22},
	{3390822656U, 24},
	{3390823936U, 24},
	{3390827520U, 24},
	{3390830336U, 24},
	{3390831360U, 24},
	{3390834688U, 21},
	{3390834688U, 24},
	{3390836992U, 24},
	{3390838784U, 22},
	{3390840832U, 22},
	{3390850048U, 24},
	{3390850304U, 24},
	{3390856192U, 22},
	{3390856192U, 24},
	{3390865408U, 21},
	{3390867456U, 21},
	{3390869504U, 21},
	{3390871552U, 21},
	{3390873600U, 21},
	{3390875648U, 21},
	{3390877696U, 21},
	{3390879744U, 21},
	{3390963712U, 19},
	{3390971904U, 23},
	{3390972416U, 24},
	{3390972928U, 23},
	{3390973440U, 24},
	{3390973696U, 24},
	{3390973952U, 22},
	{3390974976U, 24},
	{3390975232U, 24},
	{3390975488U, 23},
	{3390976256U, 24},
	{3390976512U, 23},
	{3390977024U, 23},
	{3390977536U, 24},
	{3390977792U, 24},
	{3390978048U, 23},
	{3390978560U, 24},
	{3390978816U, 24},
	{3390979072U, 22},
	{3390980096U, 19},
	{3390987776U, 24},
	{3390988288U, 20},
	{3390992384U, 21},
	{3390996480U, 17},
	{3390996480U, 18},
	{3391007488U, 24},
	{3391007744U, 24},
	{3391008000U, 24},
	{3391008256U, 24},
	{3391008768U, 24},
	{3391009792U, 24},
	{3391010048U, 24},
	{3391010560U, 24},
	{3391010816U, 24},
	{3391012352U, 24},
	{3391012864U, 18},
	{3391012864U, 19},
	{3391012864U, 24},
	{3391013120U, 24},
	{3391015168U, 24},
	{3391019776U, 24},
	{3391021056U, 19},
	{3391021056U, 24},
	{3391022848U, 24},
	{3391023104U, 24},
	{3391023360U, 24},
	{3391023616U, 24},
	{3391023872U, 24},
	{3391024128U, 24},
	{3391024384U, 24},
	{3391024640U, 24},
	{3391062016U, 20},
	{3391066112U, 21},
	{3391068160U, 24},
	{3391068416U, 24},
	{3391068672U, 24},
	{3391069184U, 22},
	{3391070208U, 20},
	{3391075328U, 24},
	{3391075584U, 24},
	{3391076352U, 21},
	{3391078400U, 20},
	{3391082496U, 22},
	{3391084544U, 22},
	{3391086080U, 24},
	{3391086592U, 19},
	{3391094784U, 16},
	{3391160320U, 16},
	{3391227904U, 21},
	{3391234048U, 24},
	{3391241984U, 24},
	{3391242240U, 18},
	{3391264256U, 23},
	{3391264768U, 23},
	{3391275008U, 19},
	{3391285248U, 21},
	{3391287808U, 23},
	{3391288832U, 23},
	{3391309824U, 22},
	{3391314944U, 24},
	{3391322112U, 22},
	{3391323136U, 22},
	{3391340544U, 19},
	{3391348736U, 24},
	{3391349248U, 23},
	{3391349760U, 23},
	{3391350272U, 24},
	{3391350784U, 22},
	{3391352832U, 21},
	{3391354880U, 22},
	{3391356928U, 16},
	{3391367936U, 24},
	{3391368448U, 24},
	{3391368704U, 24},
	{3391374848U, 24},
	{3391377408U, 24},
	{3391380992U, 24},
	{3391385088U, 24},
	{3391386112U, 24},
	{3391394560U, 24},
	{3391394816U, 24},
	{3391396352U, 24},
	{3391398912U, 22},
	{3391398912U, 23},
	{3391399424U, 23},
	{3391406848U, 24},
	{3391408640U, 24},
	{3391415040U, 24},
	{3391417088U, 24},
	{3391422464U, 16},
	{3391422464U, 20},
	{3391438848U, 23},
	{3391440896U, 24},
	{3391441664U, 24},
	{3391442432U, 24},
	{3391445504U, 23},
	{3391446272U, 24},
	{3391451136U, 24},
	{3391452416U, 24},
	{3391452672U, 24},
	{3391454208U, 23},
	{3391454976U, 24},
	{3391463424U, 24},
	{3391465472U, 24},
	{3391468800U, 24},
	{3391478784U, 24},
	{3391485184U, 24},
	{3391487488U, 24},
	{3391492096U, 22},
	{3391520768U, 23},
	{3391523328U, 24},
	{3391529984U, 22},
	{3391553536U, 18},
	{3391569920U, 20},
	{3391578112U, 20},
	{3391582208U, 20},
	{3391586304U, 17},
	{3391620608U, 24},
	{3391627264U, 19},
	{3391635456U, 18},
	{3391653376U, 24},
	{3391676416U, 21},
	{3391685632U, 24},
	{3391685888U, 24},
	{3391687168U, 24},
	{3391706368U, 24},
	{3391711744U, 24},
	{3391725568U, 19},
	{3391725824U, 24},
	{3391726336U, 24},
	{3391726592U, 24},
	{3391750144U, 16},
	{3391881216U, 21},
	{3391883264U, 21},
	{3391897600U, 24},
	{3391898624U, 22},
	{3391899904U, 24},
	{3391913984U, 24},
	{3391914496U, 23},
	{3391915776U, 24},
	{3391916032U, 24},
	{3391916800U, 24},
	{3391917056U, 23},
	{3391917568U, 23},
	{3391918080U, 24},
	{3391918336U, 24},
	{3391919104U, 22},
	{3391930368U, 18},
	{3391936512U, 24},
	{3391939584U, 24},
	{3392018432U, 21},
	{3392028672U, 20},
	{3392033792U, 24},
	{3392078080U, 24},
	{3392092160U, 24},
	{3392094208U, 20},
	{3392109824U, 24},
	{3392111616U, 23},
	{3392113664U, 24},
	{3392118784U, 19},
	{3392135168U, 20},
	{3392135168U, 21},
	{3392137216U, 22},
	{3392138240U, 22},
	{3392139264U, 21},
	{3392139264U, 22},
	{3392140288U, 22},
	{3392141312U, 23},
	{3392141824U, 24},
	{3392142336U, 23},
	{3392142336U, 24},
	{3392142592U, 24},
	{3392143872U, 23},
	{3392145408U, 21},
	{3392155648U, 20},
	{3392167936U, 22},
	{3392170240U, 24},
	{3392170496U, 23},
	{3392172032U, 21},
	{3392174080U, 21},
	{3392176128U, 19},
	{3392184320U, 22},
	{3392188160U, 24},
	{3392188416U, 22},
	{3392189952U, 23},
	{3392192512U, 24},
	{3392196608U, 24},
	{3392201728U, 22},
	{3392208896U, 16},
	{3392208896U, 21},
	{3392212992U, 20},
	{3392225280U, 21},
	{3392230400U, 24},
	{3392230912U, 24},
	{3392252928U, 22},
	{3392255232U, 24},
	{3392255744U, 24},
	{3392257280U, 24},
	{3392268544U, 24},
	{3392273664U, 24},
	{3392274432U, 16},
	{3392286976U, 24},
	{3392289792U, 22},
	{3392290816U, 21},
	{3392292864U, 24},
	{3392298752U, 24},
	{3392300800U, 24},
	{3392303104U, 24},
	{3392309504U, 24},
	{3392311040U, 24},
	{3392316416U, 24},
	{3392319744U, 24},
	{3392321792U, 24},
	{3392322048U, 24},
	{3392339968U, 22},
	{3392356352U, 24},
	{3392356608U, 24},
	{3392357376U, 24},
	{3392357632U, 24},
	{3392357888U, 24},
	{3392358144U, 24},
	{3392358400U, 24},
	{3392359168U, 24},
	{3392359424U, 24},
	{3392359680U, 24},
	{3392360704U, 24},
	{3392363776U, 24},
	{3392364032U, 24},
	{3392364288U, 24},
	{3392372736U, 19},
	{3392372736U, 21},
	{3392378880U, 24},
	{3392380160U, 24},
	{3392380672U, 24},
	{3392389120U, 20},
	{3392404480U, 22},
	{3392462848U, 19},
	{3392483328U, 20},
	{3392494080U, 23},
	{3392528384U, 19},
	{3392528384U, 23},
	{3392529408U, 23},
	{3392530944U, 23},
	{3392534528U, 22},
	{3392536064U, 23},
	{3392610304U, 24},
	{3392610560U, 24},
	{3392613888U, 24},
	{3392618496U, 19},
	{3392638720U, 24},
	{3392692224U, 19},
	{3392700416U, 21},
	{3392700672U, 24},
	{3392701696U, 24},
	{3392702464U, 22},
	{3392704512U, 21},
	{3392707584U, 23},
	{3392708096U, 23},
	{3392716800U, 22},
	{3392717824U, 22},
	{3392717824U, 23},
	{3392718336U, 23},
	{3392718848U, 22},
	{3392719872U, 22},
	{3392719872U, 24},
	{3392720128U, 24},
	{3392720384U, 24},
	{3392720640U, 24},
	{3392721920U, 22},
	{3392722944U, 22},
	{3392723968U, 22},
	{3392724224U, 24},
	{3392724480U, 24},
	{3392724736U, 24},
	{3392724992U, 22},
	{3392724992U, 24},
	{3392726016U, 22},
	{3392727040U, 22},
	{3392728064U, 22},
	{3392728320U, 24},
	{3392729088U, 24},
	{3392729600U, 24},
	{3392729856U, 24},
	{3392730368U, 24},
	{3392730624U, 24},
	{3392731136U, 21},
	{3392731136U, 24},
	{3392731392U, 24},
	{3392731648U, 24},
	{3392731904U, 24},
	{3392732160U, 22},
	{3392732160U, 24},
	{3392732416U, 24},
	{3392732672U, 24},
	{3392732928U, 24},
	{3392733184U, 24},
	{3392733440U, 24},
	{3392733696U, 24},
	{3392733952U, 24},
	{3392757760U, 19},
	{3392763648U, 24},
	{3392763904U, 22},
	{3392764928U, 24},
	{3392765184U, 24},
	{3392765952U, 18},
	{3392806912U, 19},
	{3392828416U, 24},
	{3392868352U, 20},
	{3392872448U, 20},
	{3392882176U, 24},
	{3392882432U, 24},
	{3392882688U, 24},
	{3392882944U, 24},
	{3392883200U, 24},
	{3392883456U, 24},
	{3392897024U, 19},
	{3392921600U, 19},
	{3393003520U, 19},
	{3393011712U, 22},
	{3393017856U, 21},
	{3393033216U, 22},
	{3393034240U, 23},
	{3393035264U, 24},
	{3393035520U, 24},
	{3393036288U, 24},
	{3393036544U, 24},
	{3393036800U, 24},
	{3393037056U, 24},
	{3393037312U, 24},
	{3393037568U, 24},
	{3393037824U, 24},
	{3393038080U, 24},
	{3393039616U, 24},
	{3393039872U, 24},
	{3393040640U, 24},
	{3393042176U, 24},
	{3393042944U, 24},
	{3393043200U, 24},
	{3393043456U, 24},
	{3393043712U, 24},
	{3393044480U, 24},
	{3393045248U, 24},
	{3393046016U, 24},
	{3393046272U, 24},
	{3393046784U, 24},
	{3393047040U, 24},
	{3393047552U, 24},
	{3393047808U, 24},
	{3393048064U, 24},
	{3393048576U, 24},
	{3393049088U, 24},
	{3393049856U, 24},
	{3393050624U, 24},
	{3393050880U, 24},
	{3393051136U, 24},
	{3393051392U, 24},
	{3393051648U, 24},
	{3393051904U, 24},
	{3393052672U, 24},
	{3393052928U, 24},
	{3393053184U, 24},
	{3393053696U, 24},
	{3393054208U, 24},
	{3393055744U, 22},
	{3393055744U, 24},
	{3393056000U, 24},
	{3393056256U, 24},
	{3393056512U, 24},
	{3393058304U, 24},
	{3393059328U, 24},
	{3393059584U, 24},
	{3393060352U, 24},
	{3393060608U, 24},
	{3393078272U, 22},
	{3393079296U, 22},
	{3393082112U, 24},
	{3393082624U, 24},
	{3393085184U, 24},
	{3393093632U, 19},
	{3393110016U, 19},
	{3393134848U, 24},
	{3393159168U, 20},
	{3393175552U, 19},
	{3393265664U, 19},
	{3393273856U, 19},
	{3393275136U, 24},
	{3393290496U, 24},
	{3393290752U, 24},
	{3393291008U, 24},
	{3393291520U, 24},
	{3393291776U, 24},
	{3393292288U, 24},
	{3393292800U, 24},
	{3393297920U, 24},
	{3393329152U, 24},
	{3393396736U, 21},
	{3393404928U, 19},
	{3393404928U, 20},
	{3393409024U, 20},
	{3393413120U, 20},
	{3393417216U, 20},
	{3393421312U, 17},
	{3393421312U, 19},
	{3393425152U, 24},
	{3393429504U, 19},
	{3393447424U, 23},
	{3393449472U, 24},
	{3393560576U, 20},
	{3393585152U, 19},
	{3393650688U, 19},
	{3393684736U, 24},
	{3393684992U, 24},
	{3393689344U, 24},
	{3393689856U, 24},
	{3393690112U, 24},
	{3393690368U, 24},
	{3393690624U, 24},
	{3393690880U, 24},
	{3393691136U, 24},
	{3393691392U, 24},
	{3393699840U, 18},
	{3393713920U, 24},
	{3393732608U, 21},
	{3393732608U, 24},
	{3393732864U, 24},
	{3393733120U, 24},
	{3393733376U, 24},
	{3393733632U, 24},
	{3393733888U, 24},
	{3393734144U, 24},
	{3393734400U, 24},
	{3393734656U, 21},
	{3393734656U, 24},
	{3393734912U, 24},
	{3393735168U, 24},
	{3393735424U, 24},
	{3393735680U, 24},
	{3393735936U, 24},
	{3393736192U, 24},
	{3393736448U, 24},
	{3393748992U, 19},
	{3393748992U, 23},
	{3393749504U, 24},
	{3393750016U, 23},
	{3393803264U, 22},
	{3393804288U, 24},
	{3393804544U, 24},
	{3393804800U, 24},
	{3393805056U, 24},
	{3393805312U, 22},
	{3393855488U, 19},
	{3393871872U, 24},
	{3393872128U, 24},
	{3393872384U, 24},
	{3393872640U, 24},
	{3393872896U, 24},
	{3393873152U, 24},
	{3393873408U, 24},
	{3393873664U, 24},
	{3393874176U, 24},
	{3393874432U, 24},
	{3393875200U, 24},
	{3393880064U, 21},
	{3393882112U, 21},
	{3393884160U, 21},
	{3393886208U, 21},
	{3393912832U, 23},
	{3393921024U, 20},
	{3393945600U, 18},
	{3393995008U, 24},
	{3394022912U, 24},
	{3394068480U, 20},
	{3394068480U, 22},
	{3394069504U, 22},
	{3394070528U, 22},
	{3394071552U, 22},
	{3394072576U, 21},
	{3394072576U, 22},
	{3394073600U, 22},
	{3394073600U, 24},
	{3394073856U, 24},
	{3394074112U, 23},
	{3394074624U, 21},
	{3394074624U, 22},
	{3394075648U, 22},
	{3394079744U, 22},
	{3394082816U, 22},
	{3394142208U, 19},
	{3394142208U, 21},
	{3394144512U, 24},
	{3394149376U, 22},
	{3394149376U, 24},
	{3394149632U, 24},
	{3394149888U, 24},
	{3394150144U, 24},
	{3394183168U, 19},
	{3394191360U, 19},
	{3394207744U, 19},
	{3394224128U, 19},
	{3394256896U, 21},
	{3394258176U, 24},
	{3394258688U, 24},
	{3394258944U, 24},
	{3394259968U, 24},
	{3394260736U, 24},
	{3394260992U, 23},
	{3394261504U, 24},
	{3394264832U, 24},
	{3394297856U, 19},
	{3394330624U, 24},
	{3394330880U, 24},
	{3394331136U, 24},
	{3394331392U, 24},
	{3394331648U, 24},
	{3394331904U, 24},
	{3394332160U, 24},
	{3394332928U, 24},
	{3394333184U, 24},
	{3394333440U, 24},
	{3394336768U, 24},
	{3394337024U, 24},
	{3394337536U, 24},
	{3394338304U, 24},
	{3394338560U, 24},
	{3394445312U, 19},
	{3394567680U, 24},
	{3394583040U, 24},
	{3394591744U, 23},
	{3394592256U, 23},
	{3394592768U, 19},
	{3394592768U, 23},
	{3394609152U, 22},
	{3394699264U, 22},
	{3394707456U, 19},
	{3394709248U, 24},
	{3394709504U, 24},
	{3394709760U, 24},
	{3394710528U, 24},
	{3394748416U, 24},
	{3394798592U, 24},
	{3394799360U, 24},
	{3394799616U, 24},
	{3394800640U, 24},
	{3394801408U, 24},
	{3394822144U, 21},
	{3394824192U, 21},
	{3394830336U, 22},
	{3394838528U, 19},
	{3394854912U, 19},
	{3394863104U, 19},
	{3394880512U, 22},
	{3394880512U, 24},
	{3394880768U, 24},
	{3394881024U, 24},
	{3394881280U, 24},
	{3394945024U, 24},
	{3394945280U, 24},
	{3394945536U, 24},
	{3395002368U, 20},
	{3395026944U, 22},
	{3395043328U, 19},
	{3395049472U, 21},
	{3395051520U, 19},
	{3395092480U, 20},
	{3395125248U, 21},
	{3395174400U, 24},
	{3395174656U, 24},
	{3395174912U, 24},
	{3395175936U, 24},
	{3395176192U, 24},
	{3395176448U, 24},
	{3395176704U, 24},
	{3395176960U, 24},
	{3395256320U, 19},
	{3395257856U, 24},
	{3395258112U, 24},
	{3395258368U, 24},
	{3395260160U, 24},
	{3395260416U, 24},
	{3395260672U, 24},
	{3395260928U, 24},
	{3395263488U, 22},
	{3395263488U, 24},
	{3395263744U, 24},
	{3395264000U, 24},
	{3395264256U, 24},
	{3395289088U, 18},
	{3395305472U, 19},
	{3395313664U, 19},
	{3395321856U, 18},
	{3395338240U, 18},
	{3395354624U, 19},
	{3395362816U, 19},
	{3395379200U, 19},
	{3395379200U, 20},
	{3395387392U, 19},
	{3395395584U, 19},
	{3395403776U, 18},
	{3395420160U, 19},
	{3395428352U, 19},
	{3395436544U, 19},
	{3395444736U, 19},
	{3395452928U, 19},
	{3395461120U, 19},
	{3395469312U, 19},
	{3395477504U, 19},
	{3395485696U, 18},
	{3395502080U, 18},
	{3395518464U, 19},
	{3395526656U, 19},
	{3395534848U, 19},
	{3395543040U, 19},
	{3395551232U, 18},
	{3395567616U, 19},
	{3395575808U, 19},
	{3395584000U, 19},
	{3395592192U, 19},
	{3395600384U, 19},
	{3395608576U, 19},
	{3395616768U, 18},
	{3395633152U, 19},
	{3395641344U, 19},
	{3395649536U, 19},
	{3395657728U, 19},
	{3395665920U, 18},
	{3395682304U, 17},
	{3395715072U, 18},
	{3395731456U, 19},
	{3395739648U, 19},
	{3395747840U, 18},
	{3395764224U, 19},
	{3395772416U, 19},
	{3395780608U, 18},
	{3395796992U, 19},
	{3395805184U, 19},
	{3395813376U, 16},
	{3395878912U, 16},
	{3395944448U, 19},
	{3395952640U, 20},
	{3395956736U, 20},
	{3395960832U, 18},
	{3395977216U, 18},
	{3395993600U, 19},
	{3396001792U, 19},
	{3396009984U, 17},
	{3396042752U, 18},
	{3396059136U, 18},
	{3396075520U, 17},
	{3396108288U, 17},
	{3396141056U, 17},
	{3396173824U, 18},
	{3396190208U, 18},
	{3396206592U, 18},
	{3396222976U, 18},
	{3396239360U, 18},
	{3396255744U, 18},
	{3396272128U, 17},
	{3396304896U, 19},
	{3396313088U, 19},
	{3396321280U, 19},
	{3396329472U, 19},
	{3396993280U, 24},
	{3396994816U, 24},
	{3397001216U, 21},
	{3397212160U, 21},
	{3397255168U, 20},
	{3397287936U, 19},
	{3397320704U, 23},
	{3397323776U, 22},
	{3397324800U, 20},
	{3397357568U, 23},
	{3397360896U, 24},
	{3397361664U, 21},
	{3397371904U, 21},
	{3397402624U, 19},
	{3397451776U, 19},
	{3397468160U, 19},
	{3397580800U, 21},
	{3397582848U, 21},
	{3397607424U, 24},
	{3397607680U, 24},
	{3397607936U, 24},
	{3397608192U, 24},
	{3397608448U, 24},
	{3397608704U, 24},
	{3397608960U, 24},
	{3397609216U, 24},
	{3397609472U, 24},
	{3397612288U, 24},
	{3397619712U, 20},
	{3397640192U, 19},
	{3397714688U, 24},
	{3397733120U, 24},
	{3397746688U, 20},
	{3397779456U, 22},
	{3397779456U, 24},
	{3397779968U, 24},
	{3397780224U, 24},
	{3397836800U, 19},
	{3397844992U, 16},
	{3397884928U, 24},
	{3397910528U, 20},
	{3397910528U, 24},
	{3397951488U, 19},
	{3397976064U, 20},
	{3397976064U, 21},
	{3397978112U, 21},
	{3397978112U, 22},
	{3397992448U, 19},
	{3398000384U, 24},
	{3398008832U, 19},
	{3398041600U, 19},
	{3398042624U, 24},
	{3398043648U, 24},
	{3398043904U, 24},
	{3398044160U, 24},
	{3398044416U, 24},
	{3398044672U, 24},
	{3398044928U, 24},
	{3398045184U, 24},
	{3398045440U, 24},
	{3398046720U, 22},
	{3398047744U, 21},
	{3398049792U, 22},
	{3398050560U, 24},
	{3398050816U, 22},
	{3398051840U, 21},
	{3398052608U, 24},
	{3398052864U, 24},
	{3398053376U, 24},
	{3398053888U, 21},
	{3398054400U, 24},
	{3398054656U, 24},
	{3398055936U, 22},
	{3398056192U, 24},
	{3398056448U, 24},
	{3398056960U, 22},
	{3398057728U, 24},
	{3398074368U, 18},
	{3398082560U, 23},
	{3398082560U, 24},
	{3398082816U, 24},
	{3398090752U, 22},
	{3398091776U, 22},
	{3398092800U, 23},
	{3398098944U, 21},
	{3398105600U, 23},
	{3398109184U, 21},
	{3398118400U, 24},
	{3398118656U, 24},
	{3398122240U, 24},
	{3398123520U, 24},
	{3398123776U, 24},
	{3398124032U, 24},
	{3398124288U, 24},
	{3398124544U, 24},
	{3398124800U, 24},
	{3398125056U, 24},
	{3398125312U, 24},
	{3398125568U, 24},
	{3398125824U, 24},
	{3398126080U, 24},
	{3398126336U, 24},
	{3398126592U, 24},
	{3398126848U, 24},
	{3398127104U, 24},
	{3398127360U, 24},
	{3398130944U, 24},
	{3398165760U, 24},
	{3398166016U, 24},
	{3398166528U, 24},
	{3398167040U, 23},
	{3398167552U, 22},
	{3398168576U, 20},
	{3398209536U, 22},
	{3398209792U, 24},
	{3398210048U, 24},
	{3398211072U, 23},
	{3398291456U, 20},
	{3398293504U, 21},
	{3398385664U, 21},
	{3398386688U, 24},
	{3398402048U, 19},
	{3398426624U, 21},
	{3398438400U, 24},
	{3398447104U, 20},
	{3398448640U, 24},
	{3398451200U, 24},
	{3398457344U, 24},
	{3398459392U, 24},
	{3398459904U, 24},
	{3398460160U, 24},
	{3398462208U, 24},
	{3398465536U, 24},
	{3398467584U, 19},
	{3398500352U, 22},
	{3398508544U, 19},
	{3398516736U, 18},
	{3398533120U, 17},
	{3398565888U, 22},
	{3398565888U, 23},
	{3398566400U, 23},
	{3398566912U, 23},
	{3398566912U, 24},
	{3398567168U, 24},
	{3398598656U, 20},
	{3398598656U, 24},
	{3398598912U, 24},
	{3398599424U, 24},
	{3398599680U, 24},
	{3398600192U, 24},
	{3398600704U, 24},
	{3398601472U, 24},
	{3398603008U, 24},
	{3398604032U, 24},
	{3398604288U, 24},
	{3398605568U, 24},
	{3398623232U, 19},
	{3398623232U, 20},
	{3398624256U, 23},
	{3398624768U, 24},
	{3398625024U, 24},
	{3398625280U, 24},
	{3398625536U, 24},
	{3398626304U, 24},
	{3398626560U, 24},
	{3398627584U, 24},
	{3398628352U, 22},
	{3398630656U, 24},
	{3398631168U, 24},
	{3398631424U, 24},
	{3398647808U, 19},
	{3398664192U, 19},
	{3398680576U, 20},
	{3398680576U, 21},
	{3398682624U, 21},
	{3398688768U, 19},
	{3398696960U, 22},
	{3398697984U, 24},
	{3398698240U, 24},
	{3398698496U, 24},
	{3398698752U, 24},
	{3398699008U, 21},
	{3398699264U, 24},
	{3398699520U, 24},
	{3398699776U, 24},
	{3398700032U, 24},
	{3398701056U, 24},
	{3398701312U, 24},
	{3398702080U, 24},
	{3398729728U, 21},
	{3398746112U, 19},
	{3398748416U, 24},
	{3398778880U, 24},
	{3398782720U, 24},
	{3398782976U, 23},
	{3398783488U, 24},
	{3398795264U, 20},
	{3398800384U, 22},
	{3398801408U, 24},
	{3398823936U, 20},
	{3398836224U, 20},
	{3398839808U, 24},
	{3398840064U, 24},
	{3398844416U, 19},
	{3398868992U, 22},
	{3398885376U, 19},
	{3398942720U, 18},
	{3398959104U, 19},
	{3398963200U, 22},
	{3398964224U, 22},
	{3398965248U, 22},
	{3398966272U, 22},
	{3398967296U, 20},
	{3398991872U, 22},
	{3398992896U, 22},
	{3398993920U, 23},
	{3398994432U, 23},
	{3398999040U, 24},
	{3398999552U, 23},
	{3399016448U, 19},
	{3399090176U, 22},
	{3399091200U, 22},
	{3399092224U, 21},
	{3399094272U, 20},
	{3399098368U, 20},
	{3399102464U, 20},
	{3399106560U, 20},
	{3399139328U, 19},
	{3399155712U, 22},
	{3399156480U, 24},
	{3399156736U, 23},
	{3399157248U, 24},
	{3399157504U, 24},
	{3399158016U, 24},
	{3399158272U, 23},
	{3399158784U, 22},
	{3399159808U, 22},
	{3399160832U, 22},
	{3399161856U, 23},
	{3399162368U, 23},
	{3399162880U, 23},
	{3399163392U, 23},
	{3399163904U, 23},
	{3399164416U, 23},
	{3399164928U, 23},
	{3399165440U, 23},
	{3399165952U, 22},
	{3399166976U, 22},
	{3399168512U, 23},
	{3399169024U, 23},
	{3399169536U, 23},
	{3399170560U, 24},
	{3399170816U, 24},
	{3399171072U, 23},
	{3399172096U, 23},
	{3399172608U, 23},
	{3399173120U, 23},
	{3399173632U, 23},
	{3399175168U, 23},
	{3399179776U, 23},
	{3399187456U, 24},
	{3399221248U, 17},
	{3399221248U, 19},
	{3399229440U, 19},
	{3399237632U, 19},
	{3399245824U, 19},
	{3399254016U, 19},
	{3399262208U, 19},
	{3399286784U, 23},
	{3399303936U, 24},
	{3399319552U, 19},
	{3399327744U, 21},
	{3399334400U, 23},
	{3399344128U, 19},
	{3399352320U, 18},
	{3399352320U, 19},
	{3399352320U, 21},
	{3399358464U, 21},
	{3399358464U, 22},
	{3399359488U, 22},
	{3399360256U, 24},
	{3399360512U, 19},
	{3399364608U, 21},
	{3399365632U, 22},
	{3399366656U, 21},
	{3399368704U, 19},
	{3399374848U, 22},
	{3399375872U, 22},
	{3399417856U, 19},
	{3399426048U, 22},
	{3399427072U, 24},
	{3399427584U, 23},
	{3399428096U, 22},
	{3399429120U, 23},
	{3399429632U, 24},
	{3399429888U, 24},
	{3399430144U, 20},
	{3399442432U, 19},
	{3399483392U, 19},
	{3399499776U, 19},
	{3399516160U, 23},
	{3399516672U, 23},
	{3399517184U, 22},
	{3399518208U, 22},
	{3399520256U, 21},
	{3399540736U, 19},
	{3399540736U, 21},
	{3399543552U, 24},
	{3399548928U, 19},
	{3399553024U, 21},
	{3399581696U, 19},
	{3399663616U, 20},
	{3399704576U, 19},
	{3399712768U, 24},
	{3399713024U, 24},
	{3399713280U, 24},
	{3399713536U, 24},
	{3399733248U, 20},
	{3399736320U, 22},
	{3399737344U, 19},
	{3399739904U, 24},
	{3399741440U, 20},
	{3399741696U, 24},
	{3399744768U, 24},
	{3399770112U, 20},
	{3399778304U, 19},
	{3399786496U, 19},
	{3399809024U, 22},
	{3399811072U, 19},
	{3399827456U, 19},
	{3399827456U, 20},
	{3399827968U, 24},
	{3399828224U, 24},
	{3399828992U, 23},
	{3399831552U, 20},
	{3399833344U, 24},
	{3399876608U, 17},
	{3399917568U, 19},
	{3399925760U, 18},
	{3399943168U, 24},
	{3399944704U, 24},
	{3399945728U, 24},
	{3399945984U, 24},
	{3399946240U, 22},
	{3399948288U, 23},
	{3399951104U, 24},
	{3399951360U, 24},
	{3399951616U, 24},
	{3399951872U, 24},
	{3399952384U, 24},
	{3399952640U, 24},
	{3399952896U, 24},
	{3399954176U, 24},
	{3399954432U, 24},
	{3399954688U, 24},
	{3399970816U, 20},
	{3399974912U, 20},
	{3400032256U, 19},
	{3400072704U, 23},
	{3400130560U, 19},
	{3400131328U, 24},
	{3400131584U, 24},
	{3400132352U, 24},
	{3400196096U, 22},
	{3400197120U, 23},
	{3400204288U, 20},
	{3400220672U, 20},
	{3400220672U, 24},
	{3400222720U, 24},
	{3400222976U, 24},
	{3400224256U, 23},
	{3400237056U, 20},
	{3400237056U, 21},
	{3400239104U, 21},
	{3400253440U, 20},
	{3400323584U, 24},
	{3400349696U, 21},
	{3400351744U, 22},
	{3400437760U, 20},
	{3400458240U, 19},
	{3400597504U, 19},
	{3400630272U, 19},
	{3400630272U, 20},
	{3400633344U, 22},
	{3400634368U, 20},
	{3400637440U, 22},
	{3400638464U, 19},
	{3400638464U, 23},
	{3400695808U, 17},
	{3400695808U, 18},
	{3400712192U, 19},
	{3400720384U, 19},
	{3400728576U, 19},
	{3400744960U, 23},
	{3400745472U, 24},
	{3400761344U, 24},
	{3400761600U, 24},
	{3400762368U, 24},
	{3400762624U, 24},
	{3400762880U, 24},
	{3400766464U, 24},
	{3400766720U, 24},
	{3400767488U, 24},
	{3400769024U, 24},
	{3400769280U, 24},
	{3400794368U, 24},
	{3400796672U, 24},
	{3400797184U, 24},
	{3400797440U, 24},
	{3400799488U, 24},
	{3400810496U, 18},
	{3400810496U, 19},
	{3400818688U, 19},
	{3400851456U, 19},
	{3400859648U, 19},
	{3400876032U, 19},
	{3400925184U, 19},
	{3400941568U, 19},
	{3400941568U, 20},
	{3400941568U, 24},
	{3400943104U, 24},
	{3400943616U, 24},
	{3400945664U, 20},
	{3400945664U, 24},
	{3400945920U, 24},
	{3400946176U, 24},
	{3400982528U, 24},
	{3400982784U, 24},
	{3400990720U, 19},
	{3401023488U, 17},
	{3401023488U, 18},
	{3401038848U, 22},
	{3401039872U, 18},
	{3401045504U, 24},
	{3401056256U, 15},
	{3401187328U, 15},
	{3401318400U, 16},
	{3401351168U, 17},
	{3401383936U, 19},
	{3401449472U, 16},
	{3402631168U, 23},
	{3402633216U, 22},
	{3402634240U, 24},
	{3402635520U, 24},
	{3402637312U, 19},
	{3402645504U, 19},
	{3402653696U, 20},
	{3402670080U, 19},
	{3402678272U, 19},
	{3402686464U, 20},
	{3402690560U, 20},
	{3402694656U, 16},
	{3402722304U, 23},
	{3402735360U, 24},
	{3402739712U, 22},
	{3402748928U, 22},
	{3402760192U, 22},
	{3402763008U, 24},
	{3402772480U, 24},
	{3402775552U, 22},
	{3402776576U, 18},
	{3402825728U, 19},
	{3402833920U, 19},
	{3402842112U, 20},
	{3402850304U, 20},
	{3402858496U, 17},
	{3402891264U, 16},
	{3402956800U, 22},
	{3402957824U, 22},
	{3402961152U, 24},
	{3402962944U, 23},
	{3402964992U, 19},
	{3402964992U, 20},
	{3402973184U, 20},
	{3402981376U, 19},
	{3402989568U, 19},
	{3402997760U, 20},
	{3403005952U, 18},
	{3403022336U, 16},
	{3403087872U, 16},
	{3403153408U, 19},
	{3403169792U, 20},
	{3403177984U, 20},
	{3403186176U, 19},
	{3403194368U, 20},
	{3403202560U, 19},
	{3403210752U, 19},
	{3403218944U, 17},
	{3403251712U, 17},
	{3403350016U, 16},
	{3403415552U, 22},
	{3403417088U, 23},
	{3403419904U, 24},
	{3403420672U, 24},
	{3403420928U, 24},
	{3403425024U, 24},
	{3403425792U, 21},
	{3403429888U, 22},
	{3403431424U, 23},
	{3403431936U, 22},
	{3403433984U, 22},
	{3403436032U, 24},
	{3403439360U, 24},
	{3403442176U, 23},
	{3403443200U, 22},
	{3403445248U, 23},
	{3403445760U, 24},
	{3403446784U, 23},
	{3403447296U, 22},
	{3403447808U, 23},
	{3403456512U, 19},
	{3403481088U, 16},
	{3403546624U, 20},
	{3403563008U, 18},
	{3403579392U, 19},
	{3403587584U, 19},
	{3403595776U, 18},
	{3403628544U, 18},
	{3403644928U, 17},
	{3403648512U, 24},
	{3403653632U, 24},
	{3403656192U, 23},
	{3403659008U, 24},
	{3403661568U, 24},
	{3403661824U, 24},
	{3403677696U, 20},
	{3403685888U, 19},
	{3403694080U, 19},
	{3403702272U, 20},
	{3403710464U, 18},
	{3403726848U, 18},
	{3403743232U, 16},
	{3403857920U, 19},
	{3403874304U, 18},
	{3403890688U, 19},
	{3403898880U, 19},
	{3403907072U, 18},
	{3403923456U, 18},
	{3403926016U, 24},
	{3403926528U, 24},
	{3403939840U, 18},
	{3403956224U, 18},
	{3403972608U, 18},
	{3404005376U, 16},
	{3404136448U, 18},
	{3404136448U, 22},
	{3404137472U, 23},
	{3404152832U, 18},
	{3404169216U, 19},
	{3404177408U, 19},
	{3404201984U, 16},
	{3404267520U, 18},
	{3404300288U, 18},
	{3404316672U, 18},
	{3404349440U, 18},
	{3404382208U, 18},
	{3404398592U, 18},
	{3404398848U, 24},
	{3404401152U, 24},
	{3404402432U, 24},
	{3404404736U, 21},
	{3404414720U, 24},
	{3404414976U, 18},
	{3404431360U, 18},
	{3404464640U, 24},
	{3404464896U, 24},
	{3404468224U, 24},
	{3404472064U, 24},
	{3404472576U, 24},
	{3404473344U, 23},
	{3404474368U, 21},
	{3404479488U, 23},
	{3404480512U, 24},
	{3404481024U, 23},
	{3404482048U, 24},
	{3404482816U, 24},
	{3404483328U, 24},
	{3404483584U, 22},
	{3404489728U, 22},
	{3404491264U, 23},
	{3404492032U, 24},
	{3404492288U, 24},
	{3404492544U, 24},
	{3404492800U, 22},
	{3404493824U, 24},
	{3404494080U, 24},
	{3404494848U, 24},
	{3404495872U, 24},
	{3404496896U, 20},
	{3404500992U, 23},
	{3404502528U, 23},
	{3404503040U, 23},
	{3404505088U, 23},
	{3404506880U, 24},
	{3404509184U, 22},
	{3404510720U, 23},
	{3404512000U, 24},
	{3404512256U, 22},
	{3404519424U, 21},
	{3404525056U, 23},
	{3404527104U, 24},
	{3404529664U, 23},
	{3404530176U, 23},
	{3404531200U, 23},
	{3404532224U, 24},
	{3404532992U, 24},
	{3404533504U, 24},
	{3404535808U, 24},
	{3404536576U, 24},
	{3404539904U, 24},
	{3404542464U, 24},
	{3404542976U, 23},
	{3404543488U, 23},
	{3404546560U, 23},
	{3404548608U, 23},
	{3404559104U, 24},
	{3404563456U, 24},
	{3404565248U, 24},
	{3404567296U, 24},
	{3404572672U, 23},
	{3404573440U, 24},
	{3404574208U, 24},
	{3404574464U, 24},
	{3404574720U, 22},
	{3404577536U, 24},
	{3404578816U, 19},
	{3404588544U, 24},
	{3404592640U, 23},
	{3404594688U, 23},
	{3404595200U, 18},
	{3404611584U, 18},
	{3404627968U, 18},
	{3404644352U, 18},
	{3404677120U, 18},
	{3404693504U, 18},
	{3404709888U, 18},
	{3404728320U, 21},
	{3404739584U, 22},
	{3404743168U, 23},
	{3404744704U, 21},
	{3404747008U, 24},
	{3404747776U, 23},
	{3404750848U, 22},
	{3404753920U, 23},
	{3404754944U, 22},
	{3404756224U, 24},
	{3404761344U, 24},
	{3404762112U, 24},
	{3404771328U, 23},
	{3404771840U, 24},
	{3404783616U, 24},
	{3404788736U, 22},
	{3404791808U, 17},
	{3404824576U, 18},
	{3404858624U, 24},
	{3404859136U, 24},
	{3404859392U, 21},
	{3404861440U, 24},
	{3404861952U, 23},
	{3404862464U, 24},
	{3404862720U, 24},
	{3404866048U, 24},
	{3404867072U, 23},
	{3404868608U, 23},
	{3404871424U, 24},
	{3404871936U, 24},
	{3404872960U, 24},
	{3404873728U, 21},
	{3404875776U, 23},
	{3404876800U, 23},
	{3404877312U, 23},
	{3404880128U, 24},
	{3404883200U, 24},
	{3404883968U, 21},
	{3404886528U, 24},
	{3404886784U, 24},
	{3404888064U, 23},
	{3404889088U, 23},
	{3404889856U, 24},
	{3404890880U, 24},
	{3404891136U, 22},
	{3404892160U, 24},
	{3404898304U, 19},
	{3404906496U, 19},
	{3404918784U, 23},
	{3404920064U, 24},
	{3404922624U, 24},
	{3404926976U, 20},
	{3404939264U, 24},
	{3404949504U, 24},
	{3404949760U, 24},
	{3404953600U, 21},
	{3404955648U, 20},
	{3404959744U, 20},
	{3404964352U, 24},
	{3404965120U, 24},
	{3404970240U, 24},
	{3404970496U, 24},
	{3404974080U, 22},
	{3404978176U, 24},
	{3404978688U, 24},
	{3404979200U, 24},
	{3404979456U, 24},
	{3404979712U, 24},
	{3404982784U, 23},
	{3404984320U, 24},
	{3404988928U, 23},
	{3404989440U, 24},
	{3404989696U, 24},
	{3404993024U, 24},
	{3404994048U, 23},
	{3404994560U, 21},
	{3404996608U, 21},
	{3405001216U, 24},
	{3405001728U, 22},
	{3405002752U, 23},
	{3405003264U, 24},
	{3405003520U, 24},
	{3405004288U, 24},
	{3405006336U, 24},
	{3405006592U, 24},
	{3405007872U, 22},
	{3405009920U, 23},
	{3405011456U, 23},
	{3405012224U, 24},
	{3405012736U, 24},
	{3405012992U, 22},
	{3405015040U, 23},
	{3405016320U, 24},
	{3405017088U, 20},
	{3405025280U, 21},
	{3405027328U, 24},
	{3405029376U, 19},
	{3405037568U, 21},
	{3405039616U, 23},
	{3405040896U, 24},
	{3405042176U, 24},
	{3405045248U, 24},
	{3405045504U, 24},
	{3405048320U, 23},
	{3405049856U, 20},
	{3405054464U, 23},
	{3405056768U, 24},
	{3405057024U, 24},
	{3405057536U, 24},
	{3405058048U, 23},
	{3405058048U, 24},
	{3405060096U, 23},
	{3405061632U, 24},
	{3405062144U, 19},
	{3405070336U, 19},
	{3405078528U, 24},
	{3405079552U, 22},
	{3405080576U, 21},
	{3405082624U, 21},
	{3405085696U, 24},
	{3405087488U, 24},
	{3405088768U, 23},
	{3405089792U, 24},
	{3405090048U, 24},
	{3405090304U, 24},
	{3405090816U, 22},
	{3405091840U, 23},
	{3405093120U, 24},
	{3405094656U, 24},
	{3405094912U, 24},
	{3405095424U, 24},
	{3405096192U, 24},
	{3405096960U, 22},
	{3405097984U, 23},
	{3405098496U, 24},
	{3405099008U, 20},
	{3405104128U, 23},
	{3405104640U, 23},
	{3405105152U, 24},
	{3405108224U, 22},
	{3405111296U, 24},
	{3405111808U, 23},
	{3405116416U, 24},
	{3405117184U, 24},
	{3405118976U, 24},
	{3405120512U, 22},
	{3405121792U, 24},
	{3405122304U, 24},
	{3405123072U, 24},
	{3405124608U, 22},
	{3405127680U, 21},
	{3405133056U, 24},
	{3405133312U, 24},
	{3405135360U, 24},
	{3405136896U, 22},
	{3405146624U, 23},
	{3405148672U, 24},
	{3405150464U, 24},
	{3405152256U, 19},
	{3405160448U, 22},
	{3405161472U, 24},
	{3405164544U, 22},
	{3405180416U, 24},
	{3405181184U, 24},
	{3405181952U, 22},
	{3405182976U, 21},
	{3405185024U, 17},
	{3405250560U, 16},
	{3405316096U, 17},
	{3405365248U, 19},
	{3405373440U, 19},
	{3405381632U, 20},
	{3405385728U, 20},
	{3405389824U, 24},
	{3405393152U, 24},
	{3405398016U, 21},
	{3405400832U, 24},
	{3405401088U, 24},
	{3405412352U, 21},
	{3405414656U, 24},
	{3405416448U, 21},
	{3405418496U, 22},
	{3405419520U, 23},
	{3405420032U, 24},
	{3405421568U, 23},
	{3405422592U, 22},
	{3405423616U, 23},
	{3405424128U, 23},
	{3405424640U, 21},
	{3405426688U, 22},
	{3405428736U, 21},
	{3405433856U, 22},
	{3405434880U, 21},
	{3405437696U, 24},
	{3405438976U, 22},
	{3405442048U, 24},
	{3405442560U, 23},
	{3405443072U, 21},
	{3405447168U, 19},
	{3405455360U, 20},
	{3405469696U, 22},
	{3405484032U, 20},
	{3405488128U, 22},
	{3405492224U, 24},
	{3405493248U, 22},
	{3405494272U, 21},
	{3405496320U, 21},
	{3405498368U, 22},
	{3405504512U, 20},
	{3405508864U, 24},
	{3405509376U, 24},
	{3405509632U, 22},
	{3405512192U, 24},
	{3405512704U, 18},
	{3405529088U, 19},
	{3405537280U, 21},
	{3405539328U, 22},
	{3405542400U, 22},
	{3405543424U, 21},
	{3405545472U, 18},
	{3405563136U, 24},
	{3405565440U, 24},
	{3405566976U, 24},
	{3405567488U, 24},
	{3405568000U, 21},
	{3405575680U, 24},
	{3405575936U, 24},
	{3405578240U, 18},
	{3405600768U, 22},
	{3405604864U, 24},
	{3405605376U, 24},
	{3405605888U, 22},
	{3405611520U, 23},
	{3405613568U, 23},
	{3405619200U, 22},
	{3405621760U, 24},
	{3405626880U, 23},
	{3405627392U, 21},
	{3405629440U, 22},
	{3405631488U, 24},
	{3405635584U, 20},
	{3405640448U, 24},
	{3405641728U, 22},
	{3405643776U, 19},
	{3405660160U, 23},
	{3405665280U, 23},
	{3405666304U, 22},
	{3405668352U, 21},
	{3405670912U, 24},
	{3405672192U, 24},
	{3405682688U, 23},
	{3405685248U, 23},
	{3405685760U, 22},
	{3405692928U, 21},
	{3405694976U, 21},
	{3405698048U, 23},
	{3405699328U, 24},
	{3405699584U, 24},
	{3405701632U, 24},
	{3405701888U, 24},
	{3405702656U, 23},
	{3405703168U, 21},
	{3405711360U, 22},
	{3405713408U, 21},
	{3405715968U, 23},
	{3405716480U, 23},
	{3405719552U, 22},
	{3405720576U, 22},
	{3405721600U, 22},
	{3405724672U, 22},
	{3405727744U, 22},
	{3405734912U, 22},
	{3405748224U, 22},
	{3405749248U, 24},
	{3405754368U, 24},
	{3405754624U, 24},
	{3405756416U, 22},
	{3405758464U, 21},
	{3405760512U, 22},
	{3405761536U, 22},
	{3405767936U, 24},
	{3405769984U, 24},
	{3405770752U, 23},
	{3405771776U, 22},
	{3405775104U, 24},
	{3405776896U, 24},
	{3405777152U, 24},
	{3405777920U, 24},
	{3405778176U, 24},
	{3405778688U, 24},
	{3405781248U, 24},
	{3405781760U, 24},
	{3405782784U, 24},
	{3405783808U, 24},
	{3405784064U, 24},
	{3405784320U, 24},
	{3405784576U, 24},
	{3405785344U, 24},
	{3405790720U, 24},
	{3405793280U, 24},
	{3405793536U, 24},
	{3405793792U, 24},
	{3405794048U, 24},
	{3405794304U, 24},
	{3405794560U, 24},
	{3405794816U, 24},
	{3405795072U, 24},
	{3405795328U, 24},
	{3405797632U, 24},
	{3405799936U, 24},
	{3405800192U, 24},
	{3405800704U, 24},
	{3405803520U, 24},
	{3405805312U, 24},
	{3405805568U, 24},
	{3405806336U, 24},
	{3405806592U, 22},
	{3405807872U, 24},
	{3405810432U, 24},
	{3405810688U, 24},
	{3405811456U, 24},
	{3405811968U, 24},
	{3405812224U, 23},
	{3405812736U, 23},
	{3405814272U, 24},
	{3405814528U, 24},
	{3405817856U, 23},
	{3405819904U, 24},
	{3405820672U, 24},
	{3405820928U, 22},
	{3405822720U, 24},
	{3405831168U, 24},
	{3405831424U, 24},
	{3405831680U, 24},
	{3405831936U, 24},
	{3405832448U, 24},
	{3405832704U, 24},
	{3405832960U, 24},
	{3405833728U, 24},
	{3405840640U, 24},
	{3405842944U, 24},
	{3405843712U, 24},
	{3405844480U, 24},
	{3405844736U, 24},
	{3405845504U, 24},
	{3405847552U, 24},
	{3405857792U, 23},
	{3405860608U, 24},
	{3405862912U, 24},
	{3405863168U, 24},
	{3405864960U, 24},
	{3405868288U, 24},
	{3405887744U, 24},
	{3405889280U, 24},
	{3405889536U, 20},
	{3405893888U, 24},
	{3405896192U, 24},
	{3405896448U, 24},
	{3405897472U, 24},
	{3405901056U, 24},
	{3405901824U, 21},
	{3405903872U, 24},
	{3405904384U, 24},
	{3405904640U, 24},
	{3405904896U, 24},
	{3405905664U, 24},
	{3405925632U, 24},
	{3405926144U, 24},
	{3405930496U, 24},
	{3405937152U, 24},
	{3405937408U, 24},
	{3405937664U, 24},
	{3405937920U, 24},
	{3405939968U, 24},
	{3405940224U, 24},
	{3405940480U, 24},
	{3405942272U, 24},
	{3405942528U, 24},
	{3405942784U, 24},
	{3405943040U, 24},
	{3405946368U, 24},
	{3405946624U, 24},
	{3405955072U, 24},
	{3405955328U, 24},
	{3405955584U, 24},
	{3405955840U, 24},
	{3405958144U, 24},
	{3405959168U, 24},
	{3405959680U, 24},
	{3405959936U, 24},
	{3405960192U, 24},
	{3405960448U, 24},
	{3405961984U, 24},
	{3405963264U, 24},
	{3405964288U, 24},
	{3405964800U, 24},
	{3405965056U, 24},
	{3405967104U, 24},
	{3405967360U, 20},
	{3405982720U, 24},
	{3405987840U, 22},
	{3405989120U, 24},
	{3405989632U, 24},
	{3405990912U, 24},
	{3405991168U, 24},
	{3405991424U, 24},
	{3405991680U, 24},
	{3405997056U, 22},
	{3405997312U, 24},
	{3405999104U, 24},
	{3405999360U, 24},
	{3406002432U, 24},
	{3406003456U, 24},
	{3406003968U, 24},
	{3406004480U, 24},
	{3406004736U, 24},
	{3406004992U, 24},
	{3406005760U, 24},
	{3406006784U, 24},
	{3406007296U, 24},
	{3406007552U, 24},
	{3406008320U, 20},
	{3406012416U, 22},
	{3406013952U, 24},
	{3406014208U, 24},
	{3406014464U, 24},
	{3406020864U, 24},
	{3406021120U, 24},
	{3406057216U, 24},
	{3406072064U, 24},
	{3406074880U, 23},
	{3406075392U, 24},
	{3406076928U, 24},
	{3406077440U, 24},
	{3406077696U, 24},
	{3406078208U, 24},
	{3406078464U, 24},
	{3406078720U, 24},
	{3406080256U, 24},
	{3406083328U, 24},
	{3406084096U, 24},
	{3406085632U, 23},
	{3406086144U, 21},
	{3406088192U, 22},
	{3406089216U, 24},
	{3406089728U, 24},
	{3406091264U, 22},
	{3406092288U, 21},
	{3406094336U, 24},
	{3406100480U, 21},
	{3406103296U, 24},
	{3406104064U, 24},
	{3406105856U, 24},
	{3406106112U, 24},
	{3406106368U, 24},
	{3406107648U, 24},
	{3406108416U, 24},
	{3406108672U, 24},
	{3406108928U, 24},
	{3406110208U, 24},
	{3406110464U, 24},
	{3406112768U, 22},
	{3406115328U, 24},
	{3406115584U, 24},
	{3406117376U, 24},
	{3406117632U, 24},
	{3406118400U, 24},
	{3406121216U, 24},
	{3406121728U, 24},
	{3406122496U, 23},
	{3406123008U, 24},
	{3406128640U, 24},
	{3406128896U, 24},
	{3406129152U, 21},
	{3406130944U, 24},
	{3406133504U, 24},
	{3406134272U, 24},
	{3406134528U, 24},
	{3406134784U, 24},
	{3406135040U, 24},
	{3406145536U, 22},
	{3406146816U, 24},
	{3406147584U, 24},
	{3406147840U, 24},
	{3406148096U, 24},
	{3406148352U, 24},
	{3406149632U, 24},
	{3406151424U, 24},
	{3406151936U, 24},
	{3406152704U, 24},
	{3406152960U, 24},
	{3406156800U, 24},
	{3406157056U, 24},
	{3406164480U, 24},
	{3406166016U, 24},
	{3406166272U, 24},
	{3406166528U, 24},
	{3406166784U, 24},
	{3406201088U, 24},
	{3406202624U, 24},
	{3406203136U, 24},
	{3406204672U, 24},
	{3406204928U, 23},
	{3406205184U, 24},
	{3406205440U, 23},
	{3406206976U, 22},
	{3406208000U, 24},
	{3406209024U, 19},
	{3406216960U, 24},
	{3406217472U, 24},
	{3406219008U, 24},
	{3406220288U, 24},
	{3406220544U, 24},
	{3406220800U, 24},
	{3406225152U, 24},
	{3406229504U, 24},
	{3406230272U, 24},
	{3406230528U, 24},
	{3406230784U, 24},
	{3406231296U, 24},
	{3406232064U, 24},
	{3406232320U, 24},
	{3406233088U, 24},
	{3406267392U, 24},
	{3406268416U, 24},
	{3406268672U, 24},
	{3406269440U, 22},
	{3406270464U, 24},
	{3406270720U, 24},
	{3406270976U, 24},
	{3406271488U, 24},
	{3406271744U, 24},
	{3406273024U, 24},
	{3406273280U, 24},
	{3406273536U, 24},
	{3406273792U, 24},
	{3406277888U, 24},
	{3406278400U, 24},
	{3406278656U, 20},
	{3406280704U, 24},
	{3406283264U, 24},
	{3406283520U, 24},
	{3406284288U, 24},
	{3406284544U, 24},
	{3406285824U, 24},
	{3406286336U, 24},
	{3406286592U, 24},
	{3406286848U, 20},
	{3406290944U, 24},
	{3406291200U, 24},
	{3406291456U, 24},
	{3406292992U, 24},
	{3406298880U, 24},
	{3406299392U, 24},
	{3406299648U, 24},
	{3406300160U, 22},
	{3406301440U, 24},
	{3406301696U, 24},
	{3406302208U, 22},
	{3406303232U, 23},
	{3406304256U, 24},
	{3406304512U, 24},
	{3406307328U, 24},
	{3406307584U, 24},
	{3406315264U, 24},
	{3406317312U, 24},
	{3406320640U, 24},
	{3406320896U, 24},
	{3406321664U, 24},
	{3406323200U, 24},
	{3406323456U, 24},
	{3406325760U, 24},
	{3406326016U, 24},
	{3406328064U, 24},
	{3406328320U, 24},
	{3406329344U, 24},
	{3406329600U, 24},
	{3406329856U, 24},
	{3406330880U, 24},
	{3406331648U, 24},
	{3406340864U, 24},
	{3406342656U, 24},
	{3406342912U, 24},
	{3406343680U, 24},
	{3406343936U, 24},
	{3406344192U, 21},
	{3406346496U, 24},
	{3406348544U, 24},
	{3406348800U, 24},
	{3406349056U, 24},
	{3406350336U, 24},
	{3406350592U, 24},
	{3406350848U, 24},
	{3406351616U, 24},
	{3406356480U, 19},
	{3406373120U, 24},
	{3406373632U, 24},
	{3406379008U, 24},
	{3406381568U, 24},
	{3406382080U, 22},
	{3406386176U, 24},
	{3406388736U, 24},
	{3406388992U, 24},
	{3406390784U, 24},
	{3406391040U, 24},
	{3406391552U, 24},
	{3406392576U, 24},
	{3406392832U, 24},
	{3406396416U, 24},
	{3406396672U, 24},
	{3406399744U, 24},
	{3406400000U, 24},
	{3406400256U, 24},
	{3406400512U, 24},
	{3406400768U, 24},
	{3406401024U, 24},
	{3406401280U, 24},
	{3406401536U, 24},
	{3406401792U, 24},
	{3406402048U, 24},
	{3406402304U, 24},
	{3406402560U, 24},
	{3406403072U, 24},
	{3406403328U, 24},
	{3406404608U, 24},
	{3406404864U, 24},
	{3406405376U, 24},
	{3406405632U, 20},
	{3406410496U, 24},
	{3406410752U, 24},
	{3406412800U, 24},
	{3406413056U, 24},
	{3406413312U, 23},
	{3406413824U, 19},
	{3406413824U, 20},
	{3406417920U, 20},
	{3406430208U, 24},
	{3406430464U, 24},
	{3406431744U, 24},
	{3406432000U, 24},
	{3406434304U, 21},
	{3406436608U, 24},
	{3406436864U, 24},
	{3406437120U, 24},
	{3406437376U, 24},
	{3406437632U, 24},
	{3406437888U, 24},
	{3406438400U, 24},
	{3406439424U, 24},
	{3406445568U, 24},
	{3406449920U, 24},
	{3406450176U, 24},
	{3406450688U, 22},
	{3406452992U, 24},
	{3406453504U, 24},
	{3406454272U, 24},
	{3406456832U, 24},
	{3406457088U, 24},
	{3406457344U, 24},
	{3406457600U, 24},
	{3406458624U, 24},
	{3406460928U, 24},
	{3406461440U, 24},
	{3406461696U, 24},
	{3406461952U, 24},
	{3406463488U, 24},
	{3406498560U, 24},
	{3406513408U, 24},
	{3406514176U, 24},
	{3406514432U, 24},
	{3406516480U, 24},
	{3406516992U, 24},
	{3406518272U, 24},
	{3406519296U, 24},
	{3406519552U, 24},
	{3406520320U, 24},
	{3406522368U, 22},
	{3406524416U, 24},
	{3406525184U, 24},
	{3406525440U, 24},
	{3406526464U, 24},
	{3406527232U, 24},
	{3406527488U, 24},
	{3406528256U, 24},
	{3406528512U, 22},
	{3406529536U, 23},
	{3406530048U, 23},
	{3406531584U, 24},
	{3406536448U, 24},
	{3406538496U, 24},
	{3406539520U, 24},
	{3406540288U, 24},
	{3406540800U, 24},
	{3406541056U, 24},
	{3406541312U, 23},
	{3406550784U, 24},
	{3406551040U, 24},
	{3406551296U, 24},
	{3406551552U, 24},
	{3406552064U, 24},
	{3406552576U, 23},
	{3406553344U, 24},
	{3406553600U, 24},
	{3406553856U, 24},
	{3406554112U, 24},
	{3406554368U, 24},
	{3406554880U, 24},
	{3406555136U, 24},
	{3406555392U, 24},
	{3406555648U, 24},
	{3406555904U, 24},
	{3406556160U, 24},
	{3406556416U, 24},
	{3406556672U, 24},
	{3406556928U, 24},
	{3406557184U, 24},
	{3406557440U, 24},
	{3406557696U, 24},
	{3406557952U, 24},
	{3406558208U, 24},
	{3406558464U, 24},
	{3406558720U, 24},
	{3406558976U, 24},
	{3406559232U, 24},
	{3406559488U, 24},
	{3406559744U, 24},
	{3406560000U, 24},
	{3406560256U, 24},
	{3406560512U, 24},
	{3406560768U, 24},
	{3406561024U, 24},
	{3406561792U, 24},
	{3406562048U, 24},
	{3406562304U, 24},
	{3406562560U, 24},
	{3406562816U, 24},
	{3406563072U, 24},
	{3406563328U, 24},
	{3406563584U, 24},
	{3406563840U, 24},
	{3406564096U, 24},
	{3406564352U, 24},
	{3406566912U, 24},
	{3406567168U, 24},
	{3406568448U, 23},
	{3406568448U, 24},
	{3406568704U, 24},
	{3406568960U, 24},
	{3406569216U, 24},
	{3406570496U, 24},
	{3406571264U, 24},
	{3406572032U, 24},
	{3406573056U, 24},
	{3406573568U, 22},
	{3406574336U, 24},
	{3406575616U, 24},
	{3406576128U, 23},
	{3406576640U, 22},
	{3406577664U, 24},
	{3406578432U, 24},
	{3406578688U, 24},
	{3406579712U, 21},
	{3406581248U, 24},
	{3406581760U, 23},
	{3406582528U, 24},
	{3406586112U, 24},
	{3406586368U, 24},
	{3406586624U, 24},
	{3406587392U, 24},
	{3406587904U, 21},
	{3406589952U, 23},
	{3406590720U, 24},
	{3406591232U, 24},
	{3406592000U, 24},
	{3406594816U, 24},
	{3406595072U, 24},
	{3406595328U, 24},
	{3406596864U, 24},
	{3406598144U, 21},
	{3406600192U, 21},
	{3406603520U, 24},
	{3406603776U, 24},
	{3406604032U, 24},
	{3406604800U, 24},
	{3406605056U, 24},
	{3406605312U, 22},
	{3406607360U, 24},
	{3406608896U, 23},
	{3406614528U, 24},
	{3406614784U, 24},
	{3406615040U, 24},
	{3406615552U, 22},
	{3406616576U, 23},
	{3406617088U, 24},
	{3406618880U, 24},
	{3406619392U, 24},
	{3406620672U, 24},
	{3406621184U, 23},
	{3406621696U, 24},
	{3406621952U, 24},
	{3406622208U, 24},
	{3406622464U, 24},
	{3406624768U, 24},
	{3406625024U, 24},
	{3406625280U, 24},
	{3406626816U, 20},
	{3406630144U, 24},
	{3406631936U, 24},
	{3406632192U, 24},
	{3406632448U, 24},
	{3406632704U, 24},
	{3406633216U, 24},
	{3406633472U, 24},
	{3406633984U, 22},
	{3406635008U, 24},
	{3406635520U, 24},
	{3406635776U, 24},
	{3406636032U, 24},
	{3406636288U, 24},
	{3406636800U, 24},
	{3406637824U, 24},
	{3406638592U, 24},
	{3406641152U, 21},
	{3406644224U, 22},
	{3406645248U, 24},
	{3406645760U, 24},
	{3406667776U, 24},
	{3406668288U, 23},
	{3406669056U, 24},
	{3406669312U, 24},
	{3406669568U, 24},
	{3406669824U, 24},
	{3406670080U, 24},
	{3406670336U, 24},
	{3406670592U, 24},
	{3406670848U, 24},
	{3406671360U, 24},
	{3406671616U, 24},
	{3406671872U, 24},
	{3406680064U, 24},
	{3406680832U, 24},
	{3406681600U, 24},
	{3406683136U, 23},
	{3406683648U, 24},
	{3406685184U, 24},
	{3406685952U, 24},
	{3406687232U, 24},
	{3406687744U, 23},
	{3406688768U, 24},
	{3406690048U, 24},
	{3406690816U, 24},
	{3406692352U, 20},
	{3406696448U, 24},
	{3406696704U, 24},
	{3406697984U, 24},
	{3406698240U, 24},
	{3406699520U, 24},
	{3406700544U, 24},
	{3406701056U, 24},
	{3406701312U, 24},
	{3406701568U, 24},
	{3406701824U, 24},
	{3406702080U, 24},
	{3406702336U, 24},
	{3406702592U, 21},
	{3406702592U, 24},
	{3406704640U, 23},
	{3406705152U, 24},
	{3406705408U, 24},
	{3406706176U, 24},
	{3406706944U, 24},
	{3406707456U, 24},
	{3406707712U, 24},
	{3406716928U, 24},
	{3406717952U, 24},
	{3406718464U, 24},
	{3406718720U, 24},
	{3406719232U, 24},
	{3406720000U, 24},
	{3406720768U, 24},
	{3406722304U, 24},
	{3406723072U, 22},
	{3406724096U, 22},
	{3406729216U, 24},
	{3406729472U, 24},
	{3406729728U, 24},
	{3406729984U, 24},
	{3406731776U, 24},
	{3406732800U, 23},
	{3406734080U, 24},
	{3406734336U, 24},
	{3406734592U, 24},
	{3406735104U, 24},
	{3406737408U, 24},
	{3406737664U, 24},
	{3406737920U, 24},
	{3406738176U, 24},
	{3406738432U, 24},
	{3406742528U, 24},
	{3406743296U, 24},
	{3406743552U, 24},
	{3406743808U, 24},
	{3406744064U, 24},
	{3406744320U, 24},
	{3406745600U, 24},
	{3406746112U, 24},
	{3406746368U, 24},
	{3406746624U, 24},
	{3406746880U, 24},
	{3406751232U, 24},
	{3406754816U, 24},
	{3406763776U, 24},
	{3406775296U, 24},
	{3406775552U, 24},
	{3406775808U, 24},
	{3406781696U, 24},
	{3406781952U, 24},
	{3406782208U, 24},
	{3406784000U, 24},
	{3406784512U, 24},
	{3406785024U, 24},
	{3406785280U, 24},
	{3406785536U, 24},
	{3406786048U, 24},
	{3406786304U, 24},
	{3406788608U, 23},
	{3406789120U, 23},
	{3406792192U, 23},
	{3406793728U, 24},
	{3406793984U, 24},
	{3406794240U, 24},
	{3406795776U, 24},
	{3406796288U, 24},
	{3406796800U, 24},
	{3406797056U, 24},
	{3406797568U, 24},
	{3406798848U, 21},
	{3406799616U, 24},
	{3406814720U, 24},
	{3406815232U, 24},
	{3406815744U, 24},
	{3406819840U, 24},
	{3406820096U, 24},
	{3406820352U, 24},
	{3406821376U, 24},
	{3406821632U, 24},
	{3406822144U, 24},
	{3406822400U, 24},
	{3406822912U, 24},
	{3406823424U, 23},
	{3406825216U, 24},
	{3406825472U, 24},
	{3406825728U, 24},
	{3406829568U, 24},
	{3406830080U, 24},
	{3406830592U, 23},
	{3406831104U, 23},
	{3406831616U, 24},
	{3406831872U, 24},
	{3406832128U, 24},
	{3406832384U, 24},
	{3406832896U, 24},
	{3406833408U, 24},
	{3406836736U, 23},
	{3406837248U, 24},
	{3406837760U, 24},
	{3406838016U, 24},
	{3406838784U, 24},
	{3406839040U, 24},
	{3406839296U, 24},
	{3406857216U, 24},
	{3406857984U, 24},
	{3406859008U, 24},
	{3406860032U, 24},
	{3406860288U, 24},
	{3406860544U, 24},
	{3406860800U, 24},
	{3406861056U, 24},
	{3406861312U, 24},
	{3406861568U, 24},
	{3406864384U, 24},
	{3406865664U, 24},
	{3406866176U, 24},
	{3406866688U, 24},
	{3406866944U, 24},
	{3406867968U, 24},
	{3406868480U, 24},
	{3406868736U, 24},
	{3406868992U, 24},
	{3406869248U, 24},
	{3406869504U, 22},
	{3406870016U, 23},
	{3406872064U, 24},
	{3406872320U, 24},
	{3406872576U, 23},
	{3406873344U, 24},
	{3406873600U, 24},
	{3406874624U, 22},
	{3406874624U, 24},
	{3406875136U, 24},
	{3406876160U, 24},
	{3406876416U, 24},
	{3406876672U, 21},
	{3406880768U, 24},
	{3406881024U, 24},
	{3406881280U, 24},
	{3406881536U, 24},
	{3406882048U, 24},
	{3406882304U, 23},
	{3406882816U, 24},
	{3406883072U, 24},
	{3406885120U, 24},
	{3406885376U, 24},
	{3406885632U, 24},
	{3406885888U, 24},
	{3406886400U, 24},
	{3406888960U, 24},
	{3406889216U, 24},
	{3406890240U, 24},
	{3406891008U, 24},
	{3406891776U, 24},
	{3406892288U, 24},
	{3406892544U, 23},
	{3406893824U, 24},
	{3406894592U, 24},
	{3406894848U, 24},
	{3406895104U, 24},
	{3406895360U, 24},
	{3406895616U, 24},
	{3406895872U, 24},
	{3406896896U, 24},
	{3406898176U, 24},
	{3406899200U, 21},
	{3406899968U, 24},
	{3406901504U, 24},
	{3406902272U, 24},
	{3406902528U, 24},
	{3406902784U, 24},
	{3406903040U, 24},
	{3406903552U, 24},
	{3406903808U, 23},
	{3406906112U, 24},
	{3406906624U, 24},
	{3406907136U, 24},
	{3406907392U, 24},
	{3406907648U, 24},
	{3406912256U, 24},
	{3406912512U, 24},
	{3406917632U, 24},
	{3406917888U, 24},
	{3406918144U, 24},
	{3406919168U, 24},
	{3406919424U, 24},
	{3406919680U, 24},
	{3406920448U, 24},
	{3406920960U, 24},
	{3406921216U, 24},
	{3406921472U, 24},
	{3406921728U, 24},
	{3406921984U, 24},
	{3406926848U, 22},
	{3406927872U, 24},
	{3406928384U, 24},
	{3406928640U, 24},
	{3406928896U, 22},
	{3406930432U, 24},
	{3406931200U, 24},
	{3406931712U, 24},
	{3406931968U, 21},
	{3406934016U, 23},
	{3406935040U, 24},
	{3406935296U, 24},
	{3406935552U, 24},
	{3406935808U, 24},
	{3406936320U, 24},
	{3406936576U, 24},
	{3406937088U, 24},
	{3406938112U, 24},
	{3406938368U, 24},
	{3406939136U, 22},
	{3406943232U, 24},
	{3406943488U, 24},
	{3406946304U, 24},
	{3406947328U, 23},
	{3406948352U, 24},
	{3406948864U, 23},
	{3406949888U, 24},
	{3406950400U, 22},
	{3406951424U, 23},
	{3406953728U, 24},
	{3406953984U, 24},
	{3406954496U, 24},
	{3406954752U, 24},
	{3406955776U, 24},
	{3406957056U, 24},
	{3406957312U, 24},
	{3406957568U, 23},
	{3406958080U, 23},
	{3406958848U, 24},
	{3406959360U, 24},
	{3406960640U, 24},
	{3406961408U, 24},
	{3406961664U, 24},
	{3406962944U, 24},
	{3406963456U, 24},
	{3406964224U, 24},
	{3406964480U, 24},
	{3406967552U, 24},
	{3406968064U, 24},
	{3406968576U, 24},
	{3406969088U, 24},
	{3406969344U, 24},
	{3406970624U, 24},
	{3406970880U, 24},
	{3406971136U, 24},
	{3406971392U, 24},
	{3406971648U, 24},
	{3406971904U, 24},
	{3406972160U, 24},
	{3406972416U, 24},
	{3406972672U, 24},
	{3406974208U, 24},
	{3406974464U, 24},
	{3406974720U, 24},
	{3406976512U, 24},
	{3406977024U, 24},
	{3406978048U, 24},
	{3406978304U, 24},
	{3406979072U, 24},
	{3406981120U, 24},
	{3406981632U, 24},
	{3406983168U, 20},
	{3406987264U, 24},
	{3406987776U, 24},
	{3406990080U, 24},
	{3406990592U, 24},
	{3406990848U, 24},
	{3406991104U, 24},
	{3406991616U, 24},
	{3406991872U, 23},
	{3406992384U, 24},
	{3406992896U, 24},
	{3406993152U, 24},
	{3406994176U, 24},
	{3406994432U, 24},
	{3406994688U, 24},
	{3406994944U, 24},
	{3406995200U, 24},
	{3406995456U, 24},
	{3406995968U, 23},
	{3406996736U, 24},
	{3406997248U, 24},
	{3406999040U, 24},
	{3407002112U, 24},
	{3407002368U, 24},
	{3407002624U, 22},
	{3407009792U, 22},
	{3407009792U, 24},
	{3407011840U, 24},
	{3407012096U, 24},
	{3407012352U, 24},
	{3407012608U, 24},
	{3407012864U, 24},
	{3407013120U, 24},
	{3407013376U, 24},
	{3407013888U, 24},
	{3407014144U, 24},
	{3407014400U, 24},
	{3407014656U, 24},
	{3407015424U, 24},
	{3407015936U, 24},
	{3407016192U, 24},
	{3407016448U, 23},
	{3407017216U, 24},
	{3407017472U, 24},
	{3407017728U, 24},
	{3407017984U, 24},
	{3407018496U, 24},
	{3407018752U, 24},
	{3407019008U, 24},
	{3407019264U, 24},
	{3407020032U, 24},
	{3407020544U, 24},
	{3407021056U, 24},
	{3407021824U, 24},
	{3407023104U, 24},
	{3407023360U, 24},
	{3407023616U, 24},
	{3407023872U, 24},
	{3407024384U, 24},
	{3407025152U, 24},
	{3407025408U, 24},
	{3407025664U, 24},
	{3407026688U, 24},
	{3407027968U, 24},
	{3407031040U, 24},
	{3407032064U, 24},
	{3407032320U, 24},
	{3407033600U, 24},
	{3407033856U, 24},
	{3407034368U, 24},
	{3407036672U, 24},
	{3407036928U, 24},
	{3407038208U, 24},
	{3407038720U, 24},
	{3407038976U, 24},
	{3407039232U, 24},
	{3407039488U, 24},
	{3407039744U, 24},
	{3407040000U, 24},
	{3407040512U, 24},
	{3407042304U, 24},
	{3407042560U, 24},
	{3407047168U, 24},
	{3407047424U, 24},
	{3407049984U, 24},
	{3407050752U, 24},
	{3407053824U, 24},
	{3407054848U, 24},
	{3407055104U, 24},
	{3407056128U, 24},
	{3407056384U, 23},
	{3407057664U, 24},
	{3407057920U, 24},
	{3407058176U, 24},
	{3407058688U, 24},
	{3407058944U, 24},
	{3407059200U, 24},
	{3407059456U, 24},
	{3407059712U, 24},
	{3407059968U, 24},
	{3407060224U, 24},
	{3407060480U, 24},
	{3407060736U, 24},
	{3407060992U, 22},
	{3407062016U, 23},
	{3407065344U, 24},
	{3407067136U, 24},
	{3407067392U, 24},
	{3407074816U, 23},
	{3407077120U, 24},
	{3407077376U, 24},
	{3407077632U, 24},
	{3407077888U, 23},
	{3407080448U, 24},
	{3407080704U, 24},
	{3407080960U, 24},
	{3407081216U, 24},
	{3407081472U, 24},
	{3407081728U, 24},
	{3407082240U, 24},
	{3407084032U, 24},
	{3407084288U, 24},
	{3407084544U, 24},
	{3407085056U, 24},
	{3407085312U, 24},
	{3407086080U, 24},
	{3407086336U, 24},
	{3407086848U, 24},
	{3407087104U, 24},
	{3407087360U, 24},
	{3407091968U, 24},
	{3407092224U, 23},
	{3407093760U, 24},
	{3407094528U, 24},
	{3407094784U, 24},
	{3407095296U, 24},
	{3407096320U, 24},
	{3407096576U, 24},
	{3407096832U, 24},
	{3407097088U, 24},
	{3407097344U, 24},
	{3407098880U, 23},
	{3407099392U, 24},
	{3407099648U, 24},
	{3407099904U, 24},
	{3407100416U, 24},
	{3407101440U, 24},
	{3407102976U, 23},
	{3407103744U, 24},
	{3407104000U, 24},
	{3407104512U, 24},
	{3407104768U, 24},
	{3407105024U, 24},
	{3407105280U, 24},
	{3407105536U, 23},
	{3407106048U, 24},
	{3407107584U, 24},
	{3407107840U, 24},
	{3407108608U, 23},
	{3407109632U, 24},
	{3407109888U, 24},
	{3407110144U, 24},
	{3407110400U, 24},
	{3407110656U, 24},
	{3407111168U, 24},
	{3407111424U, 24},
	{3407111680U, 24},
	{3407111936U, 24},
	{3407112192U, 24},
	{3407113216U, 24},
	{3407113472U, 24},
	{3407114240U, 24},
	{3407114496U, 24},
	{3407114752U, 24},
	{3407115008U, 24},
	{3407117312U, 24},
	{3407117568U, 24},
	{3407118336U, 22},
	{3407119616U, 24},
	{3407119872U, 24},
	{3407123456U, 24},
	{3407123712U, 24},
	{3407124480U, 24},
	{3407124736U, 24},
	{3407124992U, 24},
	{3407125248U, 24},
	{3407125504U, 24},
	{3407125760U, 24},
	{3407126016U, 24},
	{3407126272U, 24},
	{3407134720U, 24},
	{3407135488U, 24},
	{3407138816U, 24},
	{3407139072U, 24},
	{3407143424U, 24},
	{3407143680U, 24},
	{3407145216U, 24},
	{3407145472U, 24},
	{3407145728U, 24},
	{3407146240U, 24},
	{3407146496U, 24},
	{3407146752U, 24},
	{3407147264U, 24},
	{3407148032U, 23},
	{3407148544U, 24},
	{3407148800U, 24},
	{3407151872U, 24},
	{3407152384U, 24},
	{3407152640U, 24},
	{3407152896U, 24},
	{3407153408U, 24},
	{3407154944U, 24},
	{3407156224U, 24},
	{3407157248U, 21},
	{3407159296U, 24},
	{3407161344U, 24},
	{3407161600U, 24},
	{3407161856U, 24},
	{3407162112U, 24},
	{3407162880U, 24},
	{3407163392U, 23},
	{3407163904U, 23},
	{3407167232U, 24},
	{3407167488U, 24},
	{3407167744U, 24},
	{3407168256U, 24},
	{3407170048U, 24},
	{3407171072U, 24},
	{3407171328U, 24},
	{3407171584U, 24},
	{3407171840U, 24},
	{3407172352U, 24},
	{3407172608U, 23},
	{3407173120U, 24},
	{3407177728U, 24},
	{3407177984U, 24},
	{3407178240U, 24},
	{3407178496U, 24},
	{3407178752U, 22},
	{3407179776U, 21},
	{3407181824U, 24},
	{3407182336U, 24},
	{3407182592U, 24},
	{3407183104U, 24},
	{3407183360U, 24},
	{3407183872U, 23},
	{3407184896U, 24},
	{3407185408U, 24},
	{3407186432U, 24},
	{3407187200U, 24},
	{3407187456U, 24},
	{3407187968U, 24},
	{3407189504U, 23},
	{3407190016U, 24},
	{3407200256U, 24},
	{3407200512U, 24},
	{3407200768U, 24},
	{3407202304U, 24},
	{3407202816U, 24},
	{3407203072U, 24},
	{3407203328U, 24},
	{3407203584U, 24},
	{3407208448U, 19},
	{3407208448U, 21},
	{3407215104U, 23},
	{3407215616U, 22},
	{3407216640U, 20},
	{3407220736U, 23},
	{3407221248U, 24},
	{3407221504U, 24},
	{3407222016U, 24},
	{3407223040U, 24},
	{3407223296U, 24},
	{3407223552U, 24},
	{3407224320U, 24},
	{3407233024U, 24},
	{3407234560U, 24},
	{3407235072U, 23},
	{3407235584U, 24},
	{3407235840U, 24},
	{3407237632U, 24},
	{3407237888U, 24},
	{3407239168U, 22},
	{3407241216U, 24},
	{3407244800U, 23},
	{3407245312U, 24},
	{3407246336U, 23},
	{3407247616U, 24},
	{3407248384U, 23},
	{3407248896U, 24},
	{3407249152U, 24},
	{3407249408U, 24},
	{3407249664U, 24},
	{3407249920U, 24},
	{3407250432U, 24},
	{3407250944U, 24},
	{3407251200U, 24},
	{3407256064U, 24},
	{3407256576U, 22},
	{3407256832U, 24},
	{3407257344U, 24},
	{3407257600U, 24},
	{3407260416U, 24},
	{3407263744U, 23},
	{3407264512U, 24},
	{3407264768U, 24},
	{3407265280U, 24},
	{3407265792U, 24},
	{3407266816U, 24},
	{3407267328U, 24},
	{3407267584U, 24},
	{3407268352U, 24},
	{3407268608U, 24},
	{3407269120U, 24},
	{3407269376U, 24},
	{3407271168U, 24},
	{3407271424U, 24},
	{3407271680U, 24},
	{3407271936U, 24},
	{3407272192U, 24},
	{3407273472U, 24},
	{3407273728U, 24},
	{3407275008U, 24},
	{3407275264U, 24},
	{3407276032U, 24},
	{3407276544U, 23},
	{3407277056U, 24},
	{3407277312U, 24},
	{3407277568U, 24},
	{3407277824U, 24},
	{3407278336U, 24},
	{3407279104U, 24},
	{3407279872U, 24},
	{3407280384U, 24},
	{3407280896U, 24},
	{3407281664U, 24},
	{3407282944U, 24},
	{3407283200U, 24},
	{3407283456U, 24},
	{3407283968U, 24},
	{3407284224U, 24},
	{3407284736U, 24},
	{3407285504U, 24},
	{3407285760U, 24},
	{3407286016U, 24},
	{3407286528U, 24},
	{3407287296U, 24},
	{3407287552U, 24},
	{3407287808U, 24},
	{3407288064U, 24},
	{3407288320U, 24},
	{3407288576U, 24},
	{3407288832U, 24},
	{3407289088U, 24},
	{3407289344U, 24},
	{3407289600U, 24},
	{3407289856U, 24},
	{3407290368U, 22},
	{3407291648U, 24},
	{3407291904U, 24},
	{3407292416U, 24},
	{3407292672U, 24},
	{3407292928U, 24},
	{3407293184U, 24},
	{3407293440U, 24},
	{3407293952U, 24},
	{3407294208U, 24},
	{3407294720U, 24},
	{3407294976U, 24},
	{3407295232U, 24},
	{3407295744U, 24},
	{3407296000U, 24},
	{3407296512U, 24},
	{3407297024U, 23},
	{3407299328U, 24},
	{3407299584U, 24},
	{3407299840U, 24},
	{3407300096U, 24},
	{3407301120U, 24},
	{3407301376U, 24},
	{3407302144U, 23},
	{3407302656U, 24},
	{3407302912U, 24},
	{3407303168U, 24},
	{3407304192U, 24},
	{3407304448U, 24},
	{3407304704U, 23},
	{3407305216U, 24},
	{3407306752U, 23},
	{3407307008U, 24},
	{3407307520U, 24},
	{3407309056U, 24},
	{3407309312U, 24},
	{3407310336U, 24},
	{3407310592U, 24},
	{3407310848U, 24},
	{3407312384U, 24},
	{3407312640U, 24},
	{3407313408U, 24},
	{3407314176U, 24},
	{3407314432U, 24},
	{3407314944U, 24},
	{3407315712U, 24},
	{3407317504U, 24},
	{3407318528U, 24},
	{3407319040U, 21},
	{3407319296U, 24},
	{3407320320U, 24},
	{3407321088U, 23},
	{3407321600U, 24},
	{3407321856U, 24},
	{3407322112U, 23},
	{3407322624U, 23},
	{3407323136U, 24},
	{3407323392U, 24},
	{3407323648U, 24},
	{3407323904U, 24},
	{3407324160U, 24},
	{3407324416U, 24},
	{3407324672U, 24},
	{3407324928U, 24},
	{3407325184U, 23},
	{3407325184U, 24},
	{3407325440U, 24},
	{3407326976U, 24},
	{3407327232U, 24},
	{3407327488U, 24},
	{3407327744U, 24},
	{3407328000U, 24},
	{3407328256U, 24},
	{3407328768U, 24},
	{3407329024U, 24},
	{3407329792U, 24},
	{3407330048U, 24},
	{3407330816U, 24},
	{3407331840U, 24},
	{3407332352U, 24},
	{3407333120U, 24},
	{3407333376U, 24},
	{3407333632U, 24},
	{3407333888U, 24},
	{3407334144U, 24},
	{3407335424U, 24},
	{3407335680U, 24},
	{3407335936U, 24},
	{3407336192U, 24},
	{3407336448U, 24},
	{3407336704U, 24},
	{3407336960U, 24},
	{3407337472U, 24},
	{3407337984U, 24},
	{3407338240U, 24},
	{3407338496U, 24},
	{3407338752U, 24},
	{3407339008U, 24},
	{3407339264U, 24},
	{3407339776U, 24},
	{3407342592U, 24},
	{3407342848U, 24},
	{3407343104U, 24},
	{3407343360U, 24},
	{3407343616U, 24},
	{3407343872U, 24},
	{3407344128U, 24},
	{3407344384U, 24},
	{3407344640U, 24},
	{3407344896U, 24},
	{3407345664U, 24},
	{3407346944U, 24},
	{3407348224U, 24},
	{3407348480U, 24},
	{3407349248U, 24},
	{3407349504U, 24},
	{3407349760U, 24},
	{3407350016U, 24},
	{3407350272U, 24},
	{3407350528U, 24},
	{3407351808U, 24},
	{3407352576U, 24},
	{3407353088U, 24},
	{3407353600U, 24},
	{3407353856U, 24},
	{3407354368U, 24},
	{3407356928U, 24},
	{3407357184U, 24},
	{3407357696U, 24},
	{3407358464U, 23},
	{3407358464U, 24},
	{3407358976U, 24},
	{3407359232U, 24},
	{3407359488U, 24},
	{3407359744U, 24},
	{3407360256U, 24},
	{3407361024U, 24},
	{3407361280U, 24},
	{3407363328U, 24},
	{3407363584U, 24},
	{3407364096U, 23},
	{3407364608U, 24},
	{3407365120U, 24},
	{3407365632U, 23},
	{3407367168U, 24},
	{3407367424U, 24},
	{3407368192U, 24},
	{3407368704U, 23},
	{3407371008U, 24},
	{3407371520U, 24},
	{3407372032U, 24},
	{3407372544U, 24},
	{3407373056U, 24},
	{3407373312U, 23},
	{3407374336U, 22},
	{3407375616U, 24},
	{3407375872U, 24},
	{3407376896U, 24},
	{3407377920U, 23},
	{3407378688U, 24},
	{3407379712U, 24},
	{3407379968U, 24},
	{3407380224U, 24},
	{3407380480U, 24},
	{3407381248U, 24},
	{3407382016U, 23},
	{3407382784U, 24},
	{3407383552U, 24},
	{3407383808U, 24},
	{3407384320U, 24},
	{3407384576U, 24},
	{3407386112U, 24},
	{3407386368U, 24},
	{3407387648U, 24},
	{3407388160U, 23},
	{3407388672U, 24},
	{3407389440U, 24},
	{3407390208U, 24},
	{3407391232U, 24},
	{3407391488U, 24},
	{3407392000U, 24},
	{3407392768U, 24},
	{3407393280U, 24},
	{3407393536U, 24},
	{3407393792U, 24},
	{3407394048U, 24},
	{3407394560U, 24},
	{3407394816U, 24},
	{3407395072U, 24},
	{3407396608U, 24},
	{3407396864U, 24},
	{3407398144U, 24},
	{3407398912U, 24},
	{3407399168U, 24},
	{3407400192U, 24},
	{3407400448U, 24},
	{3407400704U, 24},
	{3407401472U, 24},
	{3407401728U, 24},
	{3407402496U, 24},
	{3407402752U, 24},
	{3407403520U, 24},
	{3407404288U, 24},
	{3407404800U, 24},
	{3407405056U, 24},
	{3407405312U, 24},
	{3407405568U, 24},
	{3407405824U, 24},
	{3407406080U, 24},
	{3407406336U, 24},
	{3407406592U, 24},
	{3407406848U, 24},
	{3407407104U, 23},
	{3407407616U, 24},
	{3407407872U, 24},
	{3407408128U, 22},
	{3407409408U, 24},
	{3407409664U, 24},
	{3407410432U, 24},
	{3407410688U, 24},
	{3407410944U, 24},
	{3407411200U, 24},
	{3407411456U, 24},
	{3407411712U, 24},
	{3407411968U, 24},
	{3407412224U, 24},
	{3407412480U, 24},
	{3407412736U, 24},
	{3407412992U, 24},
	{3407417856U, 24},
	{3407418880U, 24},
	{3407419136U, 24},
	{3407419392U, 24},
	{3407419648U, 24},
	{3407419904U, 24},
	{3407420160U, 24},
	{3407420416U, 24},
	{3407420928U, 24},
	{3407421440U, 24},
	{3407421952U, 24},
	{3407422208U, 24},
	{3407422464U, 24},
	{3407422720U, 24},
	{3407422976U, 24},
	{3407423232U, 24},
	{3407423488U, 24},
	{3407424512U, 23},
	{3407425280U, 24},
	{3407430144U, 24},
	{3407430400U, 24},
	{3407430656U, 22},
	{3407432448U, 24},
	{3407432704U, 24},
	{3407432960U, 24},
	{3407433216U, 24},
	{3407433472U, 24},
	{3407433984U, 24},
	{3407434240U, 24},
	{3407434752U, 23},
	{3407437824U, 24},
	{3407439872U, 24},
	{3407440128U, 24},
	{3407440640U, 24},
	{3407440896U, 24},
	{3407441152U, 24},
	{3407441408U, 23},
	{3407443712U, 24},
	{3407443968U, 24},
	{3407444480U, 24},
	{3407444736U, 24},
	{3407446272U, 24},
	{3407446528U, 24},
	{3407448832U, 24},
	{3407449600U, 24},
	{3407451136U, 24},
	{3407451392U, 24},
	{3407451648U, 24},
	{3407452160U, 24},
	{3407453184U, 24},
	{3407453440U, 24},
	{3407453696U, 24},
	{3407453952U, 24},
	{3407454208U, 24},
	{3407454464U, 24},
	{3407454976U, 24},
	{3407455488U, 24},
	{3407456000U, 24},
	{3407456512U, 24},
	{3407458304U, 24},
	{3407458816U, 24},
	{3407460096U, 24},
	{3407460352U, 24},
	{3407460608U, 24},
	{3407460864U, 24},
	{3407461120U, 24},
	{3407461376U, 24},
	{3407461632U, 24},
	{3407462400U, 24},
	{3407462656U, 24},
	{3407463168U, 24},
	{3407463936U, 24},
	{3407465472U, 24},
	{3407465728U, 24},
	{3407465984U, 24},
	{3407466240U, 24},
	{3407470592U, 24},
	{3407471104U, 24},
	{3407472128U, 23},
	{3407473152U, 24},
	{3407474432U, 24},
	{3407475456U, 24},
	{3407475968U, 24},
	{3407476736U, 24},
	{3407476992U, 24},
	{3407477248U, 24},
	{3407477504U, 24},
	{3407477760U, 22},
	{3407479552U, 24},
	{3407479808U, 24},
	{3407480064U, 24},
	{3407480320U, 24},
	{3407480576U, 24},
	{3407480832U, 22},
	{3407482624U, 24},
	{3407482880U, 24},
	{3407483392U, 24},
	{3407483904U, 24},
	{3407484160U, 24},
	{3407484672U, 24},
	{3407485184U, 24},
	{3407485440U, 24},
	{3407486208U, 24},
	{3407486720U, 24},
	{3407487744U, 24},
	{3407488000U, 24},
	{3407488256U, 24},
	{3407488512U, 24},
	{3407488768U, 24},
	{3407489280U, 24},
	{3407490304U, 24},
	{3407490816U, 24},
	{3407491840U, 24},
	{3407492608U, 24},
	{3407493888U, 24},
	{3407494656U, 24},
	{3407495680U, 23},
	{3407496448U, 24},
	{3407496704U, 24},
	{3407497472U, 24},
	{3407497728U, 24},
	{3407497984U, 24},
	{3407498752U, 24},
	{3407499008U, 24},
	{3407499520U, 24},
	{3407499776U, 23},
	{3407501056U, 24},
	{3407501568U, 24},
	{3407502848U, 23},
	{3407503104U, 24},
	{3407504128U, 24},
	{3407504640U, 24},
	{3407505920U, 24},
	{3407506432U, 24},
	{3407506688U, 24},
	{3407507456U, 24},
	{3407509504U, 22},
	{3407511296U, 24},
	{3407512064U, 24},
	{3407512576U, 24},
	{3407513344U, 24},
	{3407513600U, 24},
	{3407513856U, 24},
	{3407514880U, 24},
	{3407515136U, 24},
	{3407515904U, 24},
	{3407516160U, 24},
	{3407517952U, 24},
	{3407518720U, 24},
	{3407521792U, 24},
	{3407522048U, 24},
	{3407522560U, 24},
	{3407524096U, 24},
	{3407524352U, 24},
	{3407524608U, 24},
	{3407524864U, 24},
	{3407525120U, 24},
	{3407525888U, 24},
	{3407526656U, 24},
	{3407526912U, 24},
	{3407527168U, 24},
	{3407527424U, 24},
	{3407529984U, 23},
	{3407529984U, 24},
	{3407530240U, 24},
	{3407531008U, 24},
	{3407531520U, 24},
	{3407532032U, 24},
	{3407532800U, 24},
	{3407533824U, 24},
	{3407534080U, 24},
	{3407534592U, 24},
	{3407534848U, 24},
	{3407536384U, 24},
	{3407537408U, 24},
	{3407537664U, 24},
	{3407538432U, 24},
	{3407538688U, 24},
	{3407539200U, 24},
	{3407539456U, 24},
	{3407539712U, 24},
	{3407539968U, 24},
	{3407540224U, 23},
	{3407540992U, 24},
	{3407541248U, 24},
	{3407541760U, 24},
	{3407542016U, 24},
	{3407542272U, 24},
	{3407542528U, 24},
	{3407542784U, 24},
	{3407543040U, 24},
	{3407543296U, 24},
	{3407543552U, 24},
	{3407543808U, 24},
	{3407544064U, 24},
	{3407544576U, 24},
	{3407545088U, 24},
	{3407545600U, 24},
	{3407546624U, 24},
	{3407548928U, 24},
	{3407550464U, 23},
	{3407550464U, 24},
	{3407551232U, 24},
	{3407551488U, 24},
	{3407552000U, 24},
	{3407552256U, 24},
	{3407553280U, 24},
	{3407553536U, 24},
	{3407553792U, 24},
	{3407554048U, 24},
	{3407554304U, 24},
	{3407555072U, 24},
	{3407555328U, 24},
	{3407556096U, 24},
	{3407556352U, 24},
	{3407556864U, 24},
	{3407557120U, 24},
	{3407557376U, 24},
	{3407557632U, 24},
	{3407559424U, 24},
	{3407559936U, 24},
	{3407560448U, 24},
	{3407561472U, 24},
	{3407561728U, 24},
	{3407561984U, 24},
	{3407562240U, 24},
	{3407563264U, 24},
	{3407563776U, 24},
	{3407564544U, 24},
	{3407564800U, 24},
	{3407566080U, 24},
	{3407566592U, 24},
	{3407567360U, 24},
	{3407567616U, 24},
	{3407567872U, 24},
	{3407568384U, 24},
	{3407569920U, 24},
	{3407570176U, 24},
	{3407570688U, 24},
	{3407570944U, 23},
	{3407570944U, 24},
	{3407571968U, 24},
	{3407572736U, 24},
	{3407572992U, 23},
	{3407573504U, 23},
	{3407574016U, 24},
	{3407574272U, 24},
	{3407574784U, 24},
	{3407575808U, 24},
	{3407576064U, 24},
	{3407577088U, 18},
	{3407593472U, 24},
	{3407593728U, 24},
	{3407595264U, 24},
	{3407595776U, 24},
	{3407596288U, 24},
	{3407596544U, 24},
	{3407596800U, 24},
	{3407597056U, 24},
	{3407597568U, 24},
	{3407599872U, 24},
	{3407600640U, 24},
	{3407601152U, 24},
	{3407601664U, 24},
	{3407601920U, 24},
	{3407602176U, 24},
	{3407602688U, 24},
	{3407603200U, 24},
	{3407603456U, 24},
	{3407604224U, 24},
	{3407604992U, 24},
	{3407606272U, 24},
	{3407606528U, 24},
	{3407606784U, 24},
	{3407607040U, 24},
	{3407607296U, 24},
	{3407607552U, 24},
	{3407607808U, 24},
	{3407608832U, 24},
	{3407609088U, 24},
	{3407609344U, 24},
	{3407609856U, 21},
	{3407611904U, 23},
	{3407612672U, 24},
	{3407613184U, 24},
	{3407613440U, 24},
	{3407613952U, 24},
	{3407614208U, 24},
	{3407614720U, 24},
	{3407614976U, 24},
	{3407615232U, 24},
	{3407615488U, 24},
	{3407616000U, 24},
	{3407616256U, 24},
	{3407616512U, 24},
	{3407616768U, 24},
	{3407617024U, 24},
	{3407617280U, 24},
	{3407617536U, 24},
	{3407618048U, 24},
	{3407619072U, 24},
	{3407622144U, 22},
	{3407623168U, 23},
	{3407624960U, 24},
	{3407625216U, 24},
	{3407625472U, 24},
	{3407625728U, 24},
	{3407625984U, 24},
	{3407626240U, 21},
	{3407626240U, 24},
	{3407626496U, 24},
	{3407626752U, 24},
	{3407627008U, 24},
	{3407627520U, 24},
	{3407627776U, 24},
	{3407628288U, 24},
	{3407628544U, 24},
	{3407631616U, 24},
	{3407632640U, 24},
	{3407633152U, 24},
	{3407633920U, 23},
	{3407634176U, 24},
	{3407636992U, 24},
	{3407638784U, 24},
	{3407639296U, 24},
	{3407639552U, 22},
	{3407640576U, 24},
	{3407641088U, 24},
	{3407641344U, 24},
	{3407641600U, 24},
	{3407641856U, 24},
	{3407642112U, 24},
	{3407643904U, 24},
	{3407644160U, 23},
	{3407644928U, 24},
	{3407645440U, 24},
	{3407645952U, 24},
	{3407646208U, 24},
	{3407646464U, 24},
	{3407646720U, 24},
	{3407647488U, 24},
	{3407648256U, 24},
	{3407648512U, 24},
	{3407651328U, 24},
	{3407651584U, 24},
	{3407652352U, 24},
	{3407652608U, 24},
	{3407652864U, 24},
	{3407653632U, 24},
	{3407653888U, 24},
	{3407654144U, 24},
	{3407654400U, 24},
	{3407654912U, 24},
	{3407656960U, 24},
	{3407657472U, 24},
	{3407658496U, 24},
	{3407658752U, 24},
	{3407659264U, 24},
	{3407660288U, 24},
	{3407660800U, 24},
	{3407661056U, 24},
	{3407661312U, 24},
	{3407662080U, 24},
	{3407662848U, 24},
	{3407664384U, 24},
	{3407665920U, 24},
	{3407666688U, 24},
	{3407666944U, 24},
	{3407668224U, 24},
	{3407668480U, 24},
	{3407669248U, 24},
	{3407669760U, 24},
	{3407670784U, 24},
	{3407675648U, 24},
	{3407675904U, 24},
	{3407676160U, 24},
	{3407676672U, 24},
	{3407677184U, 24},
	{3407682048U, 24},
	{3407682304U, 24},
	{3407682560U, 24},
	{3407682816U, 24},
	{3407683584U, 24},
	{3407683840U, 24},
	{3407684096U, 24},
	{3407684352U, 24},
	{3407684608U, 24},
	{3407684864U, 24},
	{3407686656U, 24},
	{3407690496U, 24},
	{3407691776U, 24},
	{3407692544U, 24},
	{3407692800U, 24},
	{3407693312U, 24},
	{3407693568U, 24},
	{3407694336U, 24},
	{3407694592U, 24},
	{3407695104U, 24},
	{3407695360U, 24},
	{3407697920U, 24},
	{3407698176U, 24},
	{3407698688U, 24},
	{3407698944U, 24},
	{3407699200U, 24},
	{3407699456U, 24},
	{3407699968U, 24},
	{3407701248U, 24},
	{3407702016U, 24},
	{3407702272U, 24},
	{3407702528U, 24},
	{3407702784U, 24},
	{3407703040U, 24},
	{3407703296U, 24},
	{3407703552U, 24},
	{3407703808U, 24},
	{3407704320U, 24},
	{3407704576U, 23},
	{3407705088U, 23},
	{3407705600U, 24},
	{3407705856U, 24},
	{3407707392U, 24},
	{3407707648U, 24},
	{3407707904U, 24},
	{3407708160U, 24},
	{3407708416U, 24},
	{3407708672U, 24},
	{3407709184U, 24},
	{3407709696U, 24},
	{3407710208U, 24},
	{3407710720U, 24},
	{3407710976U, 24},
	{3407711232U, 24},
	{3407711488U, 24},
	{3407711744U, 24},
	{3407712512U, 24},
	{3407713792U, 24},
	{3407714048U, 24},
	{3407714304U, 24},
	{3407714560U, 24},
	{3407715072U, 24},
	{3407715328U, 24},
	{3407716096U, 24},
	{3407720448U, 22},
	{3407722496U, 24},
	{3407723520U, 24},
	{3407723776U, 24},
	{3407724032U, 24},
	{3407728640U, 23},
	{3407730176U, 23},
	{3407731200U, 24},
	{3407731456U, 24},
	{3407731712U, 24},
	{3407731968U, 24},
	{3407732480U, 24},
	{3407732736U, 23},
	{3407733248U, 24},
	{3407733760U, 24},
	{3407734016U, 24},
	{3407734272U, 24},
	{3407735808U, 24},
	{3407736832U, 24},
	{3407737088U, 24},
	{3407737344U, 24},
	{3407739136U, 24},
	{3407739392U, 23},
	{3407739904U, 24},
	{3407741952U, 22},
	{3407743744U, 24},
	{3407744256U, 24},
	{3407744512U, 24},
	{3407744768U, 24},
	{3407745536U, 24},
	{3407745792U, 24},
	{3407746560U, 24},
	{3407747072U, 24},
	{3407748608U, 24},
	{3407748864U, 24},
	{3407750144U, 24},
	{3407750656U, 24},
	{3407750912U, 24},
	{3407752192U, 22},
	{3407753728U, 24},
	{3407753984U, 24},
	{3407755520U, 24},
	{3407755776U, 24},
	{3407756544U, 24},
	{3407757312U, 24},
	{3407758080U, 24},
	{3407758336U, 24},
	{3407759104U, 24},
	{3407759360U, 24},
	{3407760128U, 24},
	{3407760640U, 24},
	{3407760896U, 24},
	{3407761152U, 24},
	{3407761408U, 24},
	{3407761920U, 24},
	{3407762176U, 24},
	{3407762688U, 24},
	{3407762944U, 24},
	{3407763456U, 24},
	{3407763968U, 24},
	{3407764224U, 24},
	{3407765504U, 24},
	{3407765760U, 24},
	{3407766016U, 23},
	{3407767552U, 24},
	{3407768064U, 24},
	{3407768320U, 24},
	{3407772160U, 24},
	{3407772672U, 23},
	{3407773184U, 24},
	{3407773696U, 23},
	{3407774208U, 24},
	{3407774464U, 24},
	{3407775232U, 24},
	{3407775488U, 24},
	{3407776000U, 24},
	{3407776512U, 24},
	{3407776768U, 24},
	{3407777024U, 24},
	{3407777280U, 24},
	{3407777536U, 24},
	{3407778048U, 24},
	{3407780096U, 24},
	{3407780352U, 24},
	{3407781120U, 24},
	{3407781376U, 24},
	{3407782912U, 24},
	{3407783168U, 24},
	{3407783936U, 23},
	{3407785728U, 24},
	{3407785984U, 23},
	{3407786496U, 24},
	{3407787008U, 24},
	{3407787776U, 24},
	{3407788032U, 23},
	{3407790080U, 24},
	{3407790336U, 24},
	{3407790592U, 24},
	{3407790848U, 24},
	{3407791360U, 24},
	{3407792128U, 24},
	{3407792640U, 24},
	{3407794176U, 24},
	{3407794432U, 24},
	{3407794688U, 24},
	{3407794944U, 24},
	{3407795456U, 24},
	{3407796224U, 24},
	{3407796736U, 24},
	{3407796992U, 24},
	{3407798016U, 24},
	{3407798272U, 24},
	{3407798528U, 24},
	{3407798784U, 24},
	{3407799296U, 23},
	{3407799808U, 24},
	{3407801088U, 24},
	{3407801344U, 23},
	{3407801856U, 24},
	{3407802880U, 24},
	{3407803136U, 24},
	{3407804160U, 24},
	{3407804416U, 24},
	{3407804672U, 24},
	{3407805696U, 24},
	{3407805952U, 24},
	{3407806208U, 24},
	{3407806464U, 24},
	{3407807232U, 24},
	{3407807488U, 24},
	{3407808000U, 24},
	{3407808256U, 24},
	{3407808512U, 24},
	{3407808768U, 24},
	{3407809024U, 24},
	{3407810048U, 23},
	{3407810560U, 24},
	{3407810816U, 24},
	{3407811072U, 23},
	{3407812096U, 24},
	{3407812608U, 23},
	{3407813120U, 24},
	{3407813376U, 24},
	{3407813632U, 24},
	{3407813888U, 24},
	{3407814144U, 24},
	{3407814400U, 24},
	{3407814656U, 22},
	{3407816704U, 24},
	{3407816960U, 24},
	{3407817728U, 24},
	{3407818496U, 24},
	{3407818752U, 24},
	{3407819264U, 24},
	{3407819776U, 24},
	{3407820032U, 24},
	{3407820800U, 24},
	{3407821312U, 24},
	{3407821568U, 24},
	{3407821824U, 24},
	{3407822336U, 24},
	{3407822592U, 24},
	{3407822848U, 24},
	{3407823360U, 24},
	{3407824128U, 24},
	{3407825152U, 24},
	{3407825664U, 24},
	{3407825920U, 24},
	{3407826176U, 24},
	{3407826432U, 24},
	{3407826688U, 24},
	{3407827200U, 24},
	{3407827712U, 24},
	{3407827968U, 24},
	{3407828480U, 24},
	{3407828736U, 24},
	{3407830016U, 24},
	{3407830272U, 24},
	{3407830528U, 24},
	{3407831040U, 24},
	{3407832576U, 24},
	{3407832832U, 24},
	{3407833856U, 24},
	{3407834624U, 23},
	{3407835648U, 24},
	{3407835904U, 24},
	{3407838464U, 24},
	{3407838720U, 24},
	{3407845888U, 24},
	{3407847424U, 24},
	{3407847680U, 24},
	{3407848192U, 24},
	{3407848448U, 24},
	{3407848704U, 24},
	{3407849216U, 24},
	{3407849728U, 24},
	{3407849984U, 24},
	{3407850240U, 24},
	{3407850752U, 24},
	{3407851520U, 24},
	{3407853056U, 24},
	{3407853312U, 24},
	{3407853568U, 24},
	{3407854592U, 24},
	{3407855104U, 24},
	{3407855616U, 24},
	{3407856128U, 24},
	{3407856384U, 24},
	{3407856896U, 24},
	{3407857152U, 24},
	{3407858944U, 24},
	{3407859200U, 23},
	{3407859712U, 24},
	{3407860224U, 24},
	{3407860736U, 24},
	{3407860992U, 24},
	{3407861504U, 24},
	{3407862016U, 24},
	{3407862272U, 24},
	{3407862528U, 24},
	{3407863808U, 24},
	{3407864832U, 24},
	{3407865856U, 23},
	{3407866880U, 24},
	{3407867136U, 24},
	{3407867904U, 24},
	{3407868160U, 24},
	{3407868416U, 24},
	{3407868928U, 23},
	{3407869440U, 24},
	{3407870720U, 24},
	{3407870976U, 24},
	{3407872000U, 23},
	{3407872512U, 24},
	{3407872768U, 24},
	{3407873536U, 24},
	{3407873792U, 24},
	{3407876096U, 24},
	{3407876352U, 24},
	{3407876608U, 24},
	{3407876864U, 24},
	{3407877376U, 24},
	{3407877888U, 24},
	{3407878400U, 24},
	{3407878656U, 24},
	{3407878912U, 24},
	{3407879168U, 24},
	{3407879424U, 24},
	{3407879680U, 24},
	{3407879936U, 24},
	{3407880448U, 24},
	{3407880704U, 24},
	{3407881216U, 24},
	{3407881472U, 24},
	{3407881728U, 24},
	{3407882240U, 24},
	{3407883008U, 24},
	{3407884032U, 24},
	{3407885568U, 24},
	{3407886592U, 24},
	{3407886848U, 24},
	{3407887616U, 24},
	{3407887872U, 24},
	{3407888128U, 24},
	{3407888640U, 24},
	{3407888896U, 24},
	{3407889920U, 24},
	{3407890432U, 23},
	{3407890944U, 24},
	{3407891200U, 24},
	{3407891712U, 24},
	{3407891968U, 24},
	{3407892224U, 24},
	{3407892992U, 24},
	{3407894528U, 24},
	{3407894784U, 24},
	{3407895296U, 24},
	{3407895552U, 24},
	{3407896576U, 24},
	{3407897088U, 24},
	{3407897344U, 24},
	{3407897600U, 24},
	{3407898368U, 24},
	{3407898624U, 24},
	{3407899648U, 24},
	{3407899904U, 24},
	{3407900160U, 24},
	{3407900416U, 24},
	{3407901952U, 24},
	{3407903232U, 24},
	{3407903744U, 24},
	{3407904000U, 24},
	{3407904256U, 24},
	{3407904512U, 24},
	{3407905792U, 24},
	{3407906560U, 24},
	{3407906816U, 24},
	{3407907072U, 24},
	{3407907328U, 24},
	{3407907584U, 24},
	{3407908096U, 24},
	{3407908352U, 24},
	{3407908608U, 24},
	{3407908864U, 24},
	{3407909120U, 24},
	{3407909376U, 24},
	{3407909632U, 24},
	{3407909888U, 24},
	{3407910144U, 24},
	{3407910400U, 24},
	{3407911936U, 24},
	{3407912192U, 24},
	{3407912448U, 24},
	{3407912704U, 24},
	{3407912960U, 24},
	{3407913216U, 24},
	{3407913472U, 24},
	{3407914496U, 24},
	{3407917056U, 24},
	{3407917312U, 24},
	{3407917824U, 24},
	{3407918080U, 23},
	{3407918592U, 24},
	{3407918848U, 24},
	{3407919104U, 24},
	{3407920128U, 24},
	{3407921408U, 24},
	{3407921664U, 24},
	{3407922432U, 24},
	{3407922944U, 24},
	{3407923712U, 24},
	{3407924736U, 24},
	{3407924992U, 24},
	{3407926528U, 24},
	{3407927808U, 24},
	{3407929344U, 19},
	{3407937536U, 24},
	{3407938048U, 24},
	{3407938304U, 24},
	{3407939072U, 24},
	{3407942144U, 24},
	{3407942400U, 24},
	{3407942656U, 24},
	{3407944704U, 24},
	{3407945216U, 24},
	{3407945472U, 24},
	{3407946752U, 24},
	{3407947264U, 24},
	{3407947520U, 24},
	{3407948032U, 24},
	{3407948288U, 24},
	{3407949056U, 24},
	{3407949312U, 24},
	{3407949568U, 24},
	{3407953408U, 24},
	{3407954432U, 24},
	{3407955456U, 24},
	{3407956480U, 24},
	{3407956736U, 24},
	{3407957248U, 24},
	{3407957504U, 24},
	{3407962112U, 22},
	{3407963648U, 24},
	{3407964160U, 24},
	{3407964416U, 24},
	{3407965184U, 24},
	{3407965440U, 24},
	{3407965696U, 24},
	{3407965952U, 24},
	{3407966208U, 22},
	{3407967232U, 22},
	{3407969280U, 24},
	{3407969792U, 24},
	{3407970048U, 24},
	{3407970304U, 24},
	{3407971840U, 24},
	{3407972352U, 22},
	{3407973376U, 24},
	{3407973632U, 24},
	{3407974144U, 24},
	{3407974912U, 24},
	{3407975168U, 24},
	{3407976448U, 24},
	{3407976704U, 24},
	{3407976960U, 24},
	{3407980544U, 24},
	{3407980800U, 24},
	{3407981312U, 24},
	{3407983104U, 24},
	{3407983616U, 24},
	{3407983872U, 24},
	{3407984128U, 24},
	{3407985664U, 24},
	{3407986176U, 24},
	{3407986432U, 24},
	{3407987712U, 24},
	{3407987968U, 24},
	{3407988992U, 24},
	{3407991552U, 24},
	{3407991808U, 24},
	{3407992064U, 24},
	{3407992832U, 24},
	{3407993856U, 23},
	{3407994624U, 24},
	{3407995904U, 24},
	{3407996160U, 24},
	{3407997696U, 24},
	{3407997952U, 24},
	{3407998208U, 24},
	{3407998976U, 24},
	{3407999488U, 24},
	{3408000256U, 24},
	{3408000512U, 24},
	{3408001024U, 24},
	{3408001280U, 24},
	{3408001792U, 24},
	{3408002048U, 24},
	{3408002304U, 24},
	{3408002560U, 24},
	{3408002816U, 24},
	{3408003072U, 23},
	{3408003584U, 24},
	{3408003840U, 24},
	{3408004352U, 24},
	{3408004608U, 24},
	{3408005120U, 24},
	{3408005376U, 24},
	{3408005888U, 24},
	{3408006144U, 23},
	{3408006912U, 24},
	{3408008704U, 24},
	{3408009216U, 24},
	{3408010496U, 24},
	{3408010752U, 24},
	{3408011008U, 24},
	{3408012288U, 24},
	{3408012544U, 24},
	{3408012800U, 24},
	{3408013312U, 24},
	{3408013568U, 24},
	{3408013824U, 24},
	{3408014080U, 24},
	{3408014336U, 24},
	{3408014848U, 24},
	{3408015104U, 24},
	{3408016128U, 24},
	{3408017920U, 24},
	{3408018176U, 24},
	{3408018432U, 24},
	{3408018688U, 24},
	{3408018944U, 24},
	{3408019456U, 24},
	{3408019712U, 24},
	{3408020736U, 24},
	{3408022784U, 24},
	{3408023040U, 23},
	{3408024320U, 24},
	{3408024576U, 24},
	{3408024832U, 24},
	{3408025088U, 24},
	{3408026112U, 24},
	{3408026368U, 24},
	{3408027136U, 24},
	{3408027904U, 24},
	{3408028160U, 24},
	{3408029952U, 24},
	{3408030464U, 24},
	{3408030976U, 24},
	{3408031232U, 24},
	{3408032256U, 24},
	{3408032512U, 24},
	{3408034048U, 24},
	{3408034304U, 24},
	{3408035840U, 24},
	{3408036096U, 24},
	{3408036352U, 24},
	{3408036864U, 24},
	{3408037120U, 24},
	{3408037376U, 24},
	{3408037632U, 24},
	{3408038144U, 24},
	{3408038912U, 24},
	{3408040448U, 24},
	{3408040960U, 24},
	{3408041728U, 24},
	{3408042752U, 24},
	{3408043008U, 22},
	{3408044032U, 24},
	{3408045056U, 24},
	{3408045312U, 24},
	{3408045568U, 24},
	{3408045824U, 24},
	{3408046080U, 24},
	{3408046336U, 24},
	{3408046592U, 24},
	{3408046848U, 24},
	{3408047104U, 24},
	{3408047360U, 24},
	{3408047616U, 24},
	{3408047872U, 24},
	{3408048384U, 24},
	{3408049152U, 24},
	{3408049664U, 24},
	{3408049920U, 24},
	{3408050176U, 24},
	{3408051712U, 24},
	{3408054528U, 24},
	{3408054784U, 24},
	{3408056832U, 24},
	{3408057088U, 24},
	{3408057344U, 24},
	{3408057600U, 24},
	{3408057856U, 24},
	{3408058112U, 24},
	{3408058624U, 24},
	{3408058880U, 24},
	{3408059392U, 23},
	{3408059392U, 24},
	{3408059648U, 24},
	{3408059904U, 24},
	{3408060160U, 24},
	{3408062720U, 24},
	{3408063232U, 24},
	{3408063488U, 24},
	{3408064000U, 24},
	{3408064256U, 24},
	{3408065280U, 24},
	{3408065536U, 24},
	{3408066048U, 24},
	{3408067584U, 23},
	{3408068608U, 16},
	{3408068608U, 24},
	{3408101376U, 23},
	{3408101376U, 24},
	{3408102400U, 24},
	{3408119296U, 23},
	{3408131584U, 24},
	{3408134144U, 14},
	{3408143872U, 23},
	{3408209408U, 24},
	{3408241920U, 24},
	{3408242944U, 24},
	{3408246784U, 24},
	{3408247040U, 24},
	{3408291840U, 24},
	{3408300544U, 24},
	{3408301056U, 22},
	{3408396288U, 13},
	{3408469760U, 24},
	{3408576512U, 21},
	{3408576512U, 24},
	{3408578560U, 23},
	{3408599552U, 23},
	{3408622336U, 24},
	{3408701952U, 23},
	{3408920576U, 14},
	{3409182720U, 15},
	{3409187328U, 24},
	{3409313792U, 16},
	{3409380864U, 23},
	{3409381376U, 24},
	{3409381632U, 24},
	{3409382912U, 23},
	{3409383424U, 24},
	{3409384192U, 24},
	{3409384448U, 24},
	{3409385216U, 24},
	{3409385472U, 24},
	{3409385984U, 24},
	{3409386240U, 24},
	{3409387264U, 24},
	{3409387520U, 24},
	{3409387776U, 24},
	{3409388032U, 24},
	{3409388288U, 24},
	{3409388544U, 24},
	{3409388800U, 24},
	{3409389312U, 24},
	{3409389568U, 24},
	{3409390848U, 24},
	{3409391104U, 23},
	{3409391616U, 23},
	{3409392128U, 24},
	{3409392384U, 24},
	{3409392640U, 24},
	{3409393152U, 23},
	{3409393152U, 24},
	{3409393408U, 24},
	{3409394688U, 24},
	{3409395200U, 24},
	{3409395456U, 24},
	{3409395968U, 24},
	{3409396224U, 24},
	{3409396992U, 24},
	{3409397248U, 24},
	{3409397504U, 24},
	{3409397760U, 24},
	{3409398016U, 24},
	{3409398272U, 24},
	{3409398528U, 24},
	{3409398784U, 24},
	{3409400064U, 24},
	{3409400320U, 24},
	{3409400576U, 24},
	{3409400832U, 24},
	{3409402112U, 24},
	{3409402368U, 23},
	{3409402880U, 24},
	{3409403392U, 24},
	{3409406208U, 24},
	{3409406464U, 24},
	{3409406976U, 24},
	{3409408000U, 24},
	{3409408768U, 24},
	{3409409024U, 24},
	{3409409280U, 24},
	{3409409536U, 24},
	{3409410048U, 24},
	{3409410304U, 24},
	{3409410560U, 24},
	{3409410816U, 24},
	{3409411072U, 24},
	{3409411328U, 24},
	{3409411584U, 24},
	{3409411840U, 24},
	{3409413632U, 23},
	{3409414144U, 24},
	{3409414656U, 24},
	{3409415680U, 24},
	{3409415936U, 24},
	{3409416192U, 24},
	{3409416448U, 24},
	{3409417728U, 24},
	{3409418752U, 24},
	{3409419008U, 24},
	{3409419264U, 24},
	{3409419520U, 24},
	{3409419776U, 24},
	{3409420288U, 24},
	{3409420544U, 24},
	{3409421056U, 24},
	{3409421568U, 24},
	{3409421824U, 24},
	{3409422080U, 24},
	{3409422592U, 24},
	{3409423104U, 24},
	{3409423360U, 24},
	{3409423616U, 24},
	{3409424384U, 24},
	{3409424640U, 24},
	{3409425152U, 24},
	{3409425408U, 24},
	{3409425920U, 24},
	{3409427456U, 24},
	{3409427968U, 24},
	{3409429504U, 24},
	{3409430272U, 24},
	{3409430528U, 24},
	{3409431552U, 23},
	{3409432064U, 24},
	{3409432320U, 24},
	{3409433600U, 24},
	{3409433856U, 24},
	{3409434112U, 24},
	{3409434368U, 24},
	{3409436160U, 24},
	{3409436928U, 24},
	{3409437184U, 24},
	{3409437440U, 24},
	{3409438720U, 22},
	{3409440256U, 24},
	{3409440768U, 21},
	{3409442816U, 23},
	{3409443328U, 24},
	{3409444096U, 24},
	{3409444608U, 24},
	{3409444864U, 24},
	{3409445376U, 24},
	{3409445632U, 24},
	{3409446656U, 24},
	{3409446912U, 24},
	{3409447168U, 24},
	{3409447424U, 24},
	{3409447680U, 24},
	{3409449216U, 24},
	{3409449472U, 24},
	{3409449728U, 24},
	{3409449984U, 24},
	{3409450496U, 24},
	{3409450752U, 24},
	{3409452032U, 24},
	{3409452544U, 24},
	{3409452800U, 24},
	{3409453056U, 23},
	{3409453568U, 24},
	{3409453824U, 24},
	{3409454080U, 24},
	{3409454336U, 24},
	{3409455360U, 24},
	{3409455872U, 24},
	{3409456128U, 24},
	{3409456384U, 24},
	{3409456896U, 24},
	{3409461248U, 24},
	{3409461504U, 24},
	{3409461760U, 24},
	{3409462016U, 24},
	{3409462784U, 24},
	{3409463296U, 24},
	{3409463552U, 24},
	{3409463808U, 24},
	{3409464064U, 24},
	{3409464576U, 24},
	{3409464832U, 23},
	{3409464832U, 24},
	{3409465344U, 24},
	{3409467136U, 24},
	{3409467392U, 24},
	{3409467904U, 23},
	{3409468928U, 24},
	{3409469952U, 24},
	{3409470208U, 24},
	{3409470464U, 24},
	{3409470720U, 24},
	{3409470976U, 24},
	{3409472256U, 24},
	{3409472512U, 24},
	{3409474560U, 23},
	{3409475072U, 24},
	{3409476096U, 24},
	{3409476352U, 24},
	{3409476864U, 24},
	{3409477120U, 24},
	{3409477376U, 24},
	{3409477632U, 22},
	{3409479680U, 23},
	{3409486848U, 24},
	{3409487872U, 24},
	{3409489920U, 24},
	{3409490432U, 24},
	{3409490944U, 24},
	{3409491200U, 24},
	{3409491456U, 24},
	{3409492480U, 24},
	{3409494272U, 24},
	{3409494784U, 24},
	{3409495040U, 24},
	{3409495808U, 24},
	{3409496576U, 24},
	{3409497088U, 24},
	{3409497344U, 24},
	{3409497600U, 24},
	{3409497856U, 24},
	{3409498112U, 22},
	{3409499392U, 24},
	{3409500672U, 24},
	{3409502208U, 24},
	{3409504000U, 24},
	{3409504512U, 24},
	{3409506560U, 24},
	{3409507328U, 24},
	{3409507840U, 24},
	{3409508096U, 24},
	{3409508352U, 24},
	{3409508864U, 24},
	{3409509632U, 24},
	{3409510400U, 24},
	{3409510656U, 24},
	{3409510912U, 24},
	{3409511424U, 24},
	{3409512192U, 24},
	{3409512448U, 24},
	{3409512960U, 24},
	{3409513984U, 24},
	{3409514240U, 24},
	{3409515520U, 24},
	{3409516288U, 24},
	{3409516544U, 24},
	{3409516800U, 24},
	{3409517056U, 24},
	{3409517824U, 24},
	{3409519616U, 23},
	{3409521152U, 24},
	{3409522688U, 24},
	{3409522944U, 24},
	{3409523200U, 24},
	{3409523456U, 24},
	{3409523712U, 22},
	{3409524736U, 24},
	{3409524992U, 24},
	{3409526272U, 24},
	{3409527552U, 24},
	{3409529088U, 24},
	{3409529600U, 24},
	{3409529856U, 24},
	{3409531136U, 24},
	{3409531392U, 23},
	{3409531648U, 24},
	{3409532416U, 24},
	{3409532672U, 24},
	{3409533696U, 24},
	{3409533952U, 24},
	{3409534208U, 24},
	{3409534976U, 24},
	{3409535488U, 24},
	{3409538048U, 24},
	{3409538560U, 24},
	{3409538816U, 24},
	{3409539328U, 24},
	{3409540608U, 23},
	{3409541120U, 24},
	{3409541376U, 24},
	{3409541632U, 24},
	{3409542144U, 24},
	{3409542400U, 24},
	{3409543168U, 20},
	{3409543168U, 24},
	{3409543424U, 24},
	{3409543680U, 24},
	{3409543936U, 24},
	{3409544192U, 24},
	{3409544448U, 24},
	{3409544704U, 24},
	{3409544960U, 24},
	{3409545216U, 24},
	{3409545472U, 24},
	{3409545728U, 24},
	{3409545984U, 24},
	{3409546240U, 24},
	{3409546496U, 24},
	{3409546752U, 24},
	{3409547008U, 24},
	{3409547264U, 24},
	{3409547776U, 24},
	{3409548032U, 24},
	{3409548288U, 24},
	{3409548544U, 24},
	{3409549312U, 22},
	{3409550336U, 24},
	{3409550848U, 24},
	{3409551104U, 24},
	{3409551616U, 24},
	{3409551872U, 24},
	{3409552128U, 24},
	{3409552384U, 24},
	{3409552640U, 24},
	{3409552896U, 24},
	{3409553152U, 24},
	{3409553408U, 24},
	{3409553664U, 24},
	{3409553920U, 24},
	{3409554176U, 24},
	{3409554432U, 24},
	{3409554688U, 24},
	{3409554944U, 24},
	{3409555200U, 24},
	{3409555456U, 24},
	{3409555712U, 24},
	{3409555968U, 24},
	{3409556224U, 24},
	{3409556480U, 24},
	{3409556736U, 24},
	{3409559552U, 23},
	{3409559552U, 24},
	{3409559808U, 24},
	{3409561856U, 24},
	{3409562368U, 24},
	{3409562624U, 24},
	{3409563392U, 24},
	{3409563648U, 21},
	{3409565952U, 24},
	{3409567232U, 24},
	{3409567488U, 24},
	{3409572096U, 24},
	{3409572352U, 24},
	{3409572864U, 24},
	{3409574400U, 24},
	{3409574656U, 24},
	{3409574912U, 22},
	{3409575936U, 24},
	{3409577472U, 24},
	{3409577728U, 24},
	{3409578240U, 24},
	{3409579264U, 24},
	{3409580288U, 24},
	{3409580544U, 24},
	{3409580800U, 24},
	{3409581056U, 24},
	{3409581312U, 24},
	{3409581568U, 24},
	{3409582080U, 24},
	{3409583616U, 24},
	{3409583872U, 24},
	{3409584128U, 19},
	{3409590784U, 24},
	{3409591040U, 24},
	{3409592320U, 18},
	{3409605888U, 24},
	{3409606144U, 24},
	{3409606400U, 24},
	{3409608704U, 17},
	{3409610240U, 24},
	{3409707008U, 16},
	{3409707264U, 24},
	{3409711872U, 24},
	{3409774592U, 24},
	{3409785856U, 24},
	{3409796608U, 24},
	{3409803264U, 24},
	{3409804288U, 24},
	{3409805056U, 24},
	{3409807872U, 24},
	{3409825792U, 24},
	{3409826560U, 24},
	{3409828352U, 24},
	{3409868800U, 24},
	{3409871360U, 24},
	{3409872384U, 24},
	{3409872640U, 24},
	{3409872896U, 23},
	{3409873408U, 24},
	{3409874176U, 24},
	{3409874432U, 23},
	{3409874944U, 24},
	{3409875200U, 24},
	{3409875456U, 24},
	{3409875712U, 24},
	{3409875968U, 22},
	{3409876480U, 24},
	{3409878016U, 24},
	{3409878272U, 24},
	{3409878528U, 24},
	{3409879808U, 24},
	{3409881600U, 24},
	{3409881856U, 24},
	{3409883392U, 24},
	{3409884160U, 22},
	{3409884416U, 24},
	{3409884928U, 24},
	{3409886208U, 24},
	{3409886464U, 24},
	{3409886720U, 24},
	{3409886976U, 24},
	{3409887232U, 24},
	{3409887488U, 24},
	{3409887744U, 24},
	{3409888256U, 24},
	{3409889280U, 24},
	{3409889536U, 24},
	{3409889792U, 24},
	{3409890048U, 24},
	{3409890560U, 24},
	{3409891072U, 24},
	{3409894400U, 22},
	{3409895424U, 24},
	{3409901568U, 21},
	{3409903616U, 16},
	{3409906176U, 24},
	{3409909760U, 23},
	{3409928960U, 24},
	{3409929728U, 24},
	{3409930496U, 24},
	{3409942528U, 24},
	{3409951488U, 24},
	{3409952512U, 24},
	{3409958912U, 24},
	{3409959680U, 24},
	{3409963264U, 24},
	{3409969152U, 16},
	{3410034688U, 17},
	{3410067456U, 19},
	{3410075648U, 19},
	{3410100224U, 16},
	{3410165760U, 16},
	{3410231296U, 16},
	{3410296832U, 16},
	{3410362368U, 16},
	{3410427904U, 16},
	{3410493440U, 19},
	{3410501632U, 22},
	{3410502656U, 23},
	{3410503168U, 23},
	{3410503680U, 21},
	{3410505728U, 20},
	{3410509824U, 18},
	{3410526208U, 17},
	{3410558976U, 16},
	{3410624512U, 16},
	{3410690048U, 16},
	{3410758144U, 24},
	{3410761728U, 24},
	{3410761984U, 24},
	{3410771968U, 19},
	{3410812928U, 24},
	{3410821120U, 18},
	{3410837504U, 18},
	{3410919424U, 24},
	{3411034112U, 24},
	{3411034624U, 23},
	{3411035136U, 22},
	{3411037184U, 22},
	{3411038208U, 22},
	{3411041024U, 24},
	{3411041280U, 24},
	{3411043072U, 24},
	{3411043840U, 24},
	{3411044096U, 24},
	{3411045632U, 24},
	{3411046144U, 24},
	{3411046400U, 24},
	{3411047424U, 24},
	{3411048192U, 24},
	{3411048448U, 22},
	{3411066880U, 22},
	{3411068160U, 24},
	{3411068928U, 22},
	{3411069952U, 22},
	{3411071744U, 24},
	{3411072000U, 24},
	{3411073792U, 24},
	{3411083264U, 23},
	{3411181568U, 19},
	{3411247104U, 19},
	{3411296000U, 24},
	{3411329024U, 19},
	{3411435520U, 19},
	{3411476480U, 20},
	{3411478528U, 24},
	{3411480576U, 23},
	{3411481088U, 24},
	{3411481600U, 24},
	{3411481856U, 24},
	{3411482112U, 23},
	{3411482880U, 24},
	{3411483136U, 24},
	{3411483392U, 24},
	{3411483648U, 23},
	{3411484160U, 23},
	{3411484672U, 20},
	{3411489792U, 24},
	{3411490048U, 24},
	{3411490304U, 23},
	{3411490816U, 24},
	{3411491072U, 24},
	{3411491328U, 23},
	{3411491840U, 24},
	{3411492096U, 24},
	{3411492352U, 24},
	{3411492608U, 24},
	{3411492864U, 24},
	{3411493120U, 24},
	{3411494144U, 24},
	{3411494400U, 24},
	{3411494656U, 24},
	{3411495168U, 24},
	{3411495424U, 24},
	{3411495680U, 24},
	{3411495936U, 24},
	{3411496192U, 24},
	{3411496448U, 24},
	{3411496704U, 24},
	{3411496960U, 23},
	{3411497472U, 23},
	{3411497984U, 22},
	{3411499008U, 23},
	{3411499520U, 23},
	{3411500032U, 22},
	{3411509248U, 20},
	{3411513344U, 20},
	{3411558400U, 19},
	{3411576064U, 24},
	{3411576320U, 24},
	{3411576576U, 24},
	{3411576832U, 24},
	{3411577088U, 24},
	{3411578112U, 24},
	{3411578368U, 24},
	{3411578624U, 24},
	{3411578880U, 24},
	{3411579136U, 24},
	{3411579392U, 24},
	{3411579648U, 24},
	{3411623936U, 19},
	{3411656704U, 18},
	{3411656704U, 19},
	{3411664896U, 19},
	{3411755008U, 19},
	{3411795968U, 19},
	{3411796480U, 24},
	{3411798272U, 24},
	{3411798784U, 24},
	{3411799040U, 24},
	{3411799296U, 24},
	{3411800064U, 24},
	{3411802368U, 24},
	{3411802624U, 24},
	{3411820544U, 19},
	{3411836928U, 19},
	{3411933184U, 21},
	{3411951616U, 18},
	{3411970048U, 22},
	{3411971328U, 24},
	{3411972352U, 24},
	{3412017152U, 19},
	{3412082688U, 19},
	{3412090880U, 19},
	{3412097024U, 23},
	{3412097024U, 24},
	{3412099072U, 20},
	{3412131840U, 17},
	{3412135936U, 24},
	{3412136192U, 24},
	{3412136448U, 24},
	{3412136704U, 24},
	{3412142592U, 24},
	{3412143104U, 24},
	{3412147200U, 24},
	{3412147456U, 24},
	{3412156416U, 19},
	{3412198144U, 24},
	{3412206592U, 23},
	{3412206848U, 24},
	{3412213760U, 19},
	{3412254720U, 19},
	{3412279552U, 24},
	{3412279808U, 24},
	{3412328192U, 24},
	{3412362240U, 22},
	{3412385792U, 19},
	{3412387840U, 24},
	{3412389376U, 23},
	{3412389888U, 24},
	{3412391680U, 24},
	{3412393984U, 17},
	{3412393984U, 21},
	{3412396032U, 21},
	{3412403712U, 24},
	{3412405248U, 22},
	{3412410368U, 19},
	{3412416512U, 22},
	{3412417536U, 23},
	{3412423680U, 22},
	{3412423680U, 24},
	{3412426752U, 19},
	{3412432896U, 21},
	{3412469504U, 24},
	{3412512256U, 24},
	{3412523520U, 23},
	{3412563712U, 24},
	{3412569856U, 24},
	{3412570880U, 24},
	{3412573696U, 24},
	{3412573952U, 24},
	{3412578048U, 24},
	{3412582656U, 24},
	{3412606976U, 19},
	{3412656128U, 18},
	{3412656128U, 21},
	{3412658176U, 21},
	{3412658176U, 24},
	{3412658432U, 24},
	{3412660224U, 21},
	{3412661504U, 24},
	{3412662016U, 24},
	{3412662272U, 21},
	{3412666368U, 21},
	{3412668416U, 21},
	{3412668416U, 24},
	{3412670464U, 21},
	{3412690944U, 22},
	{3412691968U, 23},
	{3412713472U, 19},
	{3412721664U, 16},
	{3412819968U, 17},
	{3412819968U, 22},
	{3412824064U, 20},
	{3412834304U, 22},
	{3412836352U, 21},
	{3412838400U, 23},
	{3412838912U, 23},
	{3412839424U, 22},
	{3412840448U, 22},
	{3412842752U, 24},
	{3412843264U, 24},
	{3412843520U, 22},
	{3412845824U, 24},
	{3412846080U, 24},
	{3412847872U, 24},
	{3412848128U, 23},
	{3412854528U, 24},
	{3412864512U, 24},
	{3412866304U, 24},
	{3412871680U, 24},
	{3412872448U, 24},
	{3412882432U, 24},
	{3412888832U, 24},
	{3412889088U, 24},
	{3412898816U, 24},
	{3412901632U, 24},
	{3412910080U, 24},
	{3412910336U, 24},
	{3412910592U, 24},
	{3412910848U, 24},
	{3412912896U, 24},
	{3412919296U, 24},
	{3412951040U, 24},
	{3412951296U, 24},
	{3412951552U, 24},
	{3412952064U, 24},
	{3412952576U, 24},
	{3412952832U, 24},
	{3412953856U, 24},
	{3412954112U, 24},
	{3412954368U, 24},
	{3412954624U, 23},
	{3412955136U, 20},
	{3412959232U, 24},
	{3412959488U, 24},
	{3412959744U, 24},
	{3412960256U, 22},
	{3412961280U, 21},
	{3412962304U, 22},
	{3412963328U, 20},
	{3412968448U, 24},
	{3412969728U, 24},
	{3412969984U, 24},
	{3412970240U, 24},
	{3412970496U, 24},
	{3412970752U, 24},
	{3412971008U, 24},
	{3412971264U, 24},
	{3412972032U, 24},
	{3412972544U, 22},
	{3412973568U, 21},
	{3412973568U, 23},
	{3412974592U, 22},
	{3412974592U, 24},
	{3412975616U, 22},
	{3412975872U, 24},
	{3412976640U, 23},
	{3412977664U, 21},
	{3412978432U, 24},
	{3412978688U, 24},
	{3412979712U, 21},
	{3412981760U, 22},
	{3412982272U, 24},
	{3412983808U, 18},
	{3413049344U, 17},
	{3413049344U, 20},
	{3413055488U, 22},
	{3413056512U, 22},
	{3413057536U, 20},
	{3413061632U, 21},
	{3413063680U, 22},
	{3413064704U, 22},
	{3413064704U, 23},
	{3413065728U, 22},
	{3413066752U, 22},
	{3413067776U, 21},
	{3413069824U, 20},
	{3413073920U, 19},
	{3413098496U, 20},
	{3413117184U, 24},
	{3413172224U, 19},
	{3413180416U, 19},
	{3413303296U, 23},
	{3413303808U, 23},
	{3413304320U, 23},
	{3413304832U, 23},
	{3413305344U, 23},
	{3413305856U, 23},
	{3413306368U, 23},
	{3413306880U, 23},
	{3413307392U, 23},
	{3413307904U, 23},
	{3413308416U, 23},
	{3413308928U, 23},
	{3413309440U, 23},
	{3413309952U, 23},
	{3413310464U, 23},
	{3413310976U, 23},
	{3413311488U, 18},
	{3413364736U, 20},
	{3413368832U, 19},
	{3413377024U, 16},
	{3413377536U, 24},
	{3413382912U, 24},
	{3413392640U, 24},
	{3413397760U, 24},
	{3413442304U, 24},
	{3413442560U, 16},
	{3413442560U, 24},
	{3413443840U, 24},
	{3413446400U, 24},
	{3413449984U, 24},
	{3413450752U, 19},
	{3413451008U, 24},
	{3413467136U, 24},
	{3413468672U, 24},
	{3413475072U, 24},
	{3413490688U, 24},
	{3413508096U, 18},
	{3413704704U, 18},
	{3413704704U, 19},
	{3413712896U, 19},
	{3413721088U, 19},
	{3413721088U, 20},
	{3413729280U, 19},
	{3413729280U, 20},
	{3413733376U, 20},
	{3413737472U, 19},
	{3413737472U, 24},
	{3413737984U, 24},
	{3413738240U, 24},
	{3413740032U, 24},
	{3413741568U, 20},
	{3413770240U, 18},
	{3413780480U, 22},
	{3413835776U, 19},
	{3413835776U, 24},
	{3413836032U, 24},
	{3413836288U, 24},
	{3413836544U, 24},
	{3413836800U, 24},
	{3413837056U, 24},
	{3413837312U, 24},
	{3413837568U, 24},
	{3413837824U, 24},
	{3413838080U, 24},
	{3413838336U, 24},
	{3413838592U, 24},
	{3413838848U, 24},
	{3413839104U, 24},
	{3413839872U, 22},
	{3413840896U, 24},
	{3413841920U, 24},
	{3413842944U, 24},
	{3413843712U, 24},
	{3413852160U, 19},
	{3413854464U, 24},
	{3413854976U, 24},
	{3413855744U, 24},
	{3413856000U, 24},
	{3413860096U, 24},
	{3413893120U, 19},
	{3413901312U, 24},
	{3413901568U, 24},
	{3413901824U, 24},
	{3413935616U, 23},
	{3413936128U, 22},
	{3414032384U, 16},
	{3414034944U, 24},
	{3414052096U, 24},
	{3414065152U, 18},
	{3414081536U, 18},
	{3414097920U, 16},
	{3414097920U, 18},
	{3414114304U, 18},
	{3414125568U, 24},
	{3414130688U, 18},
	{3414131712U, 24},
	{3414136064U, 24},
	{3414147072U, 18},
	{3414155520U, 24},
	{3414163456U, 19},
	{3414261760U, 19},
	{3414269696U, 24},
	{3414281216U, 24},
	{3414281472U, 24},
	{3414281984U, 24},
	{3414284288U, 24},
	{3414285312U, 24},
	{3414285824U, 23},
	{3414290432U, 22},
	{3414291456U, 24},
	{3414291712U, 24},
	{3414291968U, 24},
	{3414292224U, 24},
	{3414293504U, 22},
	{3414294016U, 23},
	{3414327296U, 19},
	{3414343680U, 18},
	{3414343680U, 21},
	{3414345728U, 23},
	{3414346240U, 23},
	{3414346752U, 22},
	{3414347776U, 20},
	{3414351872U, 22},
	{3414352896U, 23},
	{3414353152U, 24},
	{3414353408U, 24},
	{3414353664U, 24},
	{3414353920U, 23},
	{3414354432U, 24},
	{3414354688U, 24},
	{3414354944U, 22},
	{3414356992U, 23},
	{3414358784U, 24},
	{3414359040U, 24},
	{3414373120U, 24},
	{3414417408U, 19},
	{3414450176U, 19},
	{3414450432U, 24},
	{3414450688U, 24},
	{3414450944U, 24},
	{3414451200U, 24},
	{3414451712U, 24},
	{3414451968U, 24},
	{3414452224U, 24},
	{3414452480U, 24},
	{3414452736U, 24},
	{3414452992U, 24},
	{3414453248U, 24},
	{3414453504U, 24},
	{3414453760U, 24},
	{3414454272U, 24},
	{3414454528U, 24},
	{3414455552U, 24},
	{3414457088U, 24},
	{3414457344U, 24},
	{3414457600U, 24},
	{3414457856U, 24},
	{3414458112U, 24},
	{3414482944U, 19},
	{3414491136U, 17},
	{3414556672U, 17},
	{3414556672U, 20},
	{3414558976U, 24},
	{3414559232U, 24},
	{3414559744U, 23},
	{3414560000U, 24},
	{3414560512U, 24},
	{3414560768U, 20},
	{3414560768U, 23},
	{3414561280U, 23},
	{3414561792U, 24},
	{3414562048U, 24},
	{3414562816U, 21},
	{3414563328U, 24},
	{3414564864U, 20},
	{3414564864U, 21},
	{3414566912U, 21},
	{3414568448U, 23},
	{3414568960U, 21},
	{3414570752U, 24},
	{3414571008U, 22},
	{3414572032U, 22},
	{3414573056U, 19},
	{3414574080U, 24},
	{3414579968U, 24},
	{3414581248U, 20},
	{3414582528U, 24},
	{3414583040U, 24},
	{3414584064U, 24},
	{3414584576U, 24},
	{3414584832U, 24},
	{3414585088U, 24},
	{3414585344U, 22},
	{3414586368U, 22},
	{3414586368U, 24},
	{3414586624U, 24},
	{3414587392U, 21},
	{3414588160U, 24},
	{3414589440U, 18},
	{3414589440U, 20},
	{3414591488U, 24},
	{3414593024U, 24},
	{3414593536U, 20},
	{3414593536U, 22},
	{3414594560U, 22},
	{3414597632U, 21},
	{3414599680U, 21},
	{3414601728U, 22},
	{3414602752U, 22},
	{3414603776U, 21},
	{3414622208U, 24},
	{3414623232U, 24},
	{3414623488U, 24},
	{3414623744U, 24},
	{3414624000U, 24},
	{3414624256U, 24},
	{3414624512U, 24},
	{3414624768U, 24},
	{3414625024U, 24},
	{3414625280U, 24},
	{3414625536U, 24},
	{3414625792U, 24},
	{3414626048U, 24},
	{3414626304U, 24},
	{3414626560U, 24},
	{3414626816U, 24},
	{3414627072U, 24},
	{3414627328U, 24},
	{3414627584U, 24},
	{3414627840U, 24},
	{3414628096U, 24},
	{3414628352U, 24},
	{3414628608U, 24},
	{3414628864U, 24},
	{3414629376U, 24},
	{3414629632U, 24},
	{3414630400U, 24},
	{3414630656U, 24},
	{3414630912U, 24},
	{3414631168U, 24},
	{3414631424U, 24},
	{3414631680U, 24},
	{3414631936U, 24},
	{3414632192U, 24},
	{3414632448U, 24},
	{3414632704U, 24},
	{3414633216U, 24},
	{3414633472U, 24},
	{3414633728U, 24},
	{3414633984U, 24},
	{3414634240U, 24},
	{3414634496U, 24},
	{3414634752U, 24},
	{3414635264U, 24},
	{3414635520U, 24},
	{3414635776U, 24},
	{3414636032U, 24},
	{3414636544U, 24},
	{3414636800U, 24},
	{3414637056U, 24},
	{3414637568U, 24},
	{3414647552U, 24},
	{3414687744U, 16},
	{3414818816U, 16},
	{3414884352U, 17},
	{3414917120U, 20},
	{3414925312U, 19},
	{3414933504U, 19},
	{3414941696U, 19},
	{3414958080U, 19},
	{3414966272U, 20},
	{3414974464U, 20},
	{3414978560U, 20},
	{3414982656U, 19},
	{3414989312U, 24},
	{3414994944U, 20},
	{3415015424U, 19},
	{3415023616U, 20},
	{3415031808U, 19},
	{3415040000U, 19},
	{3415040000U, 21},
	{3415042048U, 22},
	{3415043072U, 22},
	{3415044096U, 21},
	{3415048192U, 19},
	{3415056384U, 19},
	{3415064576U, 19},
	{3415072768U, 20},
	{3415113728U, 19},
	{3415146496U, 19},
	{3415179264U, 23},
	{3415179776U, 24},
	{3415180032U, 24},
	{3415203840U, 19},
	{3415212032U, 19},
	{3415220224U, 20},
	{3415266304U, 22},
	{3415270400U, 22},
	{3415271424U, 22},
	{3415272448U, 22},
	{3415273472U, 22},
	{3415274496U, 22},
	{3415275776U, 24},
	{3415276544U, 22},
	{3415277568U, 21},
	{3415279616U, 21},
	{3415281664U, 21},
	{3415283712U, 21},
	{3415293952U, 24},
	{3415310336U, 22},
	{3415311616U, 24},
	{3415311872U, 24},
	{3415312128U, 24},
	{3415312384U, 22},
	{3415313408U, 22},
	{3415314432U, 22},
	{3415315456U, 22},
	{3415316480U, 23},
	{3415316992U, 24},
	{3415317504U, 24},
	{3415317760U, 24},
	{3415318016U, 24},
	{3415318272U, 24},
	{3415334912U, 23},
	{3415335936U, 24},
	{3415343104U, 17},
	{3415343104U, 22},
	{3415344128U, 22},
	{3415345152U, 21},
	{3415347200U, 21},
	{3415349248U, 21},
	{3415351296U, 21},
	{3415353344U, 21},
	{3415355392U, 21},
	{3415357440U, 23},
	{3415357952U, 23},
	{3415358464U, 23},
	{3415358976U, 23},
	{3415359488U, 21},
	{3415361536U, 21},
	{3415363584U, 21},
	{3415365632U, 21},
	{3415367680U, 19},
	{3415375872U, 18},
	{3415384064U, 19},
	{3415392256U, 19},
	{3415393280U, 22},
	{3415394304U, 21},
	{3415395584U, 24},
	{3415396352U, 20},
	{3415400448U, 21},
	{3415402496U, 21},
	{3415404544U, 21},
	{3415406592U, 21},
	{3415408640U, 18},
	{3415408640U, 19},
	{3415424000U, 24},
	{3415445504U, 21},
	{3415447552U, 22},
	{3415455744U, 21},
	{3415457792U, 24},
	{3415458048U, 24},
	{3415458304U, 24},
	{3415458560U, 24},
	{3415459072U, 24},
	{3415459840U, 21},
	{3415461888U, 20},
	{3415465984U, 20},
	{3415470080U, 23},
	{3415470336U, 24},
	{3415472128U, 22},
	{3415473664U, 23},
	{3415473920U, 24},
	{3415506944U, 20},
	{3415511040U, 20},
	{3415511040U, 21},
	{3415513088U, 21},
	{3415515136U, 19},
	{3415515392U, 24},
	{3415523328U, 22},
	{3415524352U, 22},
	{3415525376U, 21},
	{3415527424U, 20},
	{3415528960U, 23},
	{3415528960U, 24},
	{3415529216U, 24},
	{3415531520U, 19},
	{3415535616U, 23},
	{3415539968U, 24},
	{3415547904U, 19},
	{3415553024U, 24},
	{3415636224U, 24},
	{3415730176U, 21},
	{3415732224U, 20},
	{3415736320U, 18},
	{3415736320U, 22},
	{3415737344U, 22},
	{3415738368U, 22},
	{3415739392U, 22},
	{3415740416U, 22},
	{3415741440U, 22},
	{3415742464U, 22},
	{3415743488U, 22},
	{3415744512U, 22},
	{3415745536U, 22},
	{3415746560U, 22},
	{3415747584U, 22},
	{3415748608U, 22},
	{3415749632U, 22},
	{3415750656U, 22},
	{3415760896U, 19},
	{3415834624U, 20},
	{3415867392U, 16},
	{3415923968U, 24},
	{3415924224U, 24},
	{3415932928U, 16},
	{3415933184U, 24},
	{3415933440U, 24},
	{3415935232U, 24},
	{3415938304U, 24},
	{3415938560U, 24},
	{3415942144U, 24},
	{3415948544U, 24},
	{3415952896U, 24},
	{3415960064U, 24},
	{3415963136U, 24},
	{3415970304U, 24},
	{3415973888U, 20},
	{3415981056U, 24},
	{3415984128U, 24},
	{3415985408U, 24},
	{3415998208U, 24},
	{3416064000U, 16},
	{3416130560U, 23},
	{3416131072U, 23},
	{3416211456U, 19},
	{3416391680U, 20},
	{3416473600U, 18},
	{3416476928U, 24},
	{3416477184U, 24},
	{3416479232U, 24},
	{3416479488U, 24},
	{3416480000U, 24},
	{3416480256U, 24},
	{3416480512U, 24},
	{3416480768U, 24},
	{3416481536U, 24},
	{3416481792U, 24},
	{3416482304U, 24},
	{3416484864U, 24},
	{3416485120U, 24},
	{3416485376U, 24},
	{3416494592U, 24},
	{3416494848U, 24},
	{3416495104U, 24},
	{3416495360U, 24},
	{3416495616U, 24},
	{3416495872U, 24},
	{3416496128U, 24},
	{3416588288U, 16},
	{3416665344U, 24},
	{3416711168U, 19},
	{3416719616U, 24},
	{3416719872U, 24},
	{3416721664U, 24},
	{3416721920U, 24},
	{3416726016U, 24},
	{3416726272U, 24},
	{3416735744U, 19},
	{3416735744U, 23},
	{3416736256U, 24},
	{3416736512U, 24},
	{3416736768U, 24},
	{3416737024U, 24},
	{3416737280U, 24},
	{3416737536U, 24},
	{3416737792U, 24},
	{3416738048U, 24},
	{3416738304U, 24},
	{3416738816U, 24},
	{3416739072U, 24},
	{3416739328U, 24},
	{3416739584U, 24},
	{3416740864U, 24},
	{3416741120U, 24},
	{3416742400U, 24},
	{3416742656U, 24},
	{3416743424U, 24},
	{3416743936U, 19},
	{3416743936U, 24},
	{3416744192U, 24},
	{3416744448U, 24},
	{3416744704U, 24},
	{3416744960U, 24},
	{3416745216U, 24},
	{3416745728U, 24},
	{3416745984U, 24},
	{3416746240U, 24},
	{3416746496U, 24},
	{3416746752U, 24},
	{3416747008U, 24},
	{3416747264U, 24},
	{3416747776U, 24},
	{3416748032U, 24},
	{3416748288U, 24},
	{3416748544U, 24},
	{3416748800U, 24},
	{3416749056U, 24},
	{3416749312U, 24},
	{3416749568U, 24},
	{3416749824U, 24},
	{3416750080U, 24},
	{3416750336U, 24},
	{3416750592U, 24},
	{3416750848U, 24},
	{3416751104U, 24},
	{3416751360U, 24},
	{3416751616U, 24},
	{3416751872U, 24},
	{3416752128U, 17},
	{3416784896U, 19},
	{3416785920U, 22},
	{3416786944U, 22},
	{3416788992U, 20},
	{3416790272U, 24},
	{3416790528U, 24},
	{3416801280U, 20},
	{3416801280U, 24},
	{3416801536U, 24},
	{3416801792U, 24},
	{3416802048U, 24},
	{3416802304U, 24},
	{3416803840U, 24},
	{3416804096U, 24},
	{3416804608U, 24},
	{3416804864U, 24},
	{3416805120U, 24},
	{3416866816U, 18},
	{3416883200U, 18},
	{3416883200U, 19},
	{3416891392U, 19},
	{3416915968U, 24},
	{3416916224U, 24},
	{3416916480U, 24},
	{3416916736U, 24},
	{3416916992U, 24},
	{3416917248U, 24},
	{3416917504U, 24},
	{3416917760U, 24},
	{3416918016U, 24},
	{3416918272U, 24},
	{3416918528U, 24},
	{3416919552U, 24},
	{3416948736U, 18},
	{3416956928U, 19},
	{3416961024U, 24},
	{3416961280U, 24},
	{3416961536U, 24},
	{3416961792U, 24},
	{3416964608U, 24},
	{3416964864U, 24},
	{3417047040U, 19},
	{3417051136U, 20},
	{3417112576U, 18},
	{3417145344U, 19},
	{3417153536U, 20},
	{3417157632U, 21},
	{3417159680U, 22},
	{3417160704U, 22},
	{3417160704U, 24},
	{3417160960U, 24},
	{3417161728U, 21},
	{3417165312U, 23},
	{3417165824U, 21},
	{3417167872U, 23},
	{3417169920U, 24},
	{3417170176U, 24},
	{3417170432U, 24},
	{3417170688U, 24},
	{3417171456U, 23},
	{3417171968U, 24},
	{3417172480U, 24},
	{3417172736U, 24},
	{3417172992U, 22},
	{3417175040U, 23},
	{3417176320U, 24},
	{3417176576U, 24},
	{3417177088U, 24},
	{3417177600U, 24},
	{3417177856U, 24},
	{3417210880U, 19},
	{3417210880U, 20},
	{3417243648U, 24},
	{3417243904U, 24},
	{3417244160U, 24},
	{3417244416U, 24},
	{3417309184U, 18},
	{3417309184U, 19},
	{3417311232U, 24},
	{3417317376U, 19},
	{3417317376U, 24},
	{3417320960U, 24},
	{3417321216U, 24},
	{3417325568U, 19},
	{3417375488U, 24},
	{3417382912U, 19},
	{3417383680U, 24},
	{3417385984U, 23},
	{3417391104U, 20},
	{3417439232U, 24},
	{3417439488U, 24},
	{3417439744U, 24},
	{3417440000U, 24},
	{3417442048U, 24},
	{3417448448U, 24},
	{3417448704U, 24},
	{3417449472U, 22},
	{3417451520U, 24},
	{3417451776U, 24},
	{3417456640U, 18},
	{3417473024U, 19},
	{3417522176U, 20},
	{3417542656U, 20},
	{3417546752U, 19},
	{3417554944U, 19},
	{3417563136U, 20},
	{3417571328U, 16},
	{3417636864U, 18},
	{3417653248U, 19},
	{3417661440U, 19},
	{3417686016U, 18},
	{3417702400U, 16},
	{3417899264U, 24},
	{3417900032U, 22},
	{3417901056U, 22},
	{3417902336U, 24},
	{3417905152U, 22},
	{3417907200U, 22},
	{3417908224U, 22},
	{3417909248U, 22},
	{3417910272U, 22},
	{3417915392U, 18},
	{3417932032U, 24},
	{3417934848U, 22},
	{3417935872U, 22},
	{3417968128U, 23},
	{3417970688U, 22},
	{3417973504U, 24},
	{3417973760U, 22},
	{3417980928U, 22},
	{3417981952U, 22},
	{3417988608U, 24},
	{3417988864U, 24},
	{3418030080U, 17},
	{3418128384U, 21},
	{3418226176U, 24},
	{3418226688U, 22},
	{3418259456U, 20},
	{3418291712U, 23},
	{3418333184U, 20},
	{3418488832U, 18},
	{3418521600U, 24},
	{3418521856U, 24},
	{3418522112U, 24},
	{3418522368U, 24},
	{3418522624U, 24},
	{3418522880U, 24},
	{3418523136U, 24},
	{3418523392U, 24},
	{3418523648U, 24},
	{3418524160U, 24},
	{3418524672U, 24},
	{3418525184U, 24},
	{3418554368U, 18},
	{3418554368U, 19},
	{3418562560U, 19},
	{3418604544U, 22},
	{3418620928U, 22},
	{3418620928U, 24},
	{3418621184U, 24},
	{3418621696U, 24},
	{3418636288U, 20},
	{3418947584U, 19},
	{3418947584U, 20},
	{3418951680U, 21},
	{3418953728U, 22},
	{3418954752U, 23},
	{3418955264U, 23},
	{3419020544U, 24},
	{3419023360U, 21},
	{3419078656U, 16},
	{3419144192U, 16},
	{3419144192U, 17},
	{3419176960U, 17},
	{3419340800U, 20},
	{3419377664U, 24},
	{3419410432U, 24},
	{3419426816U, 23},
	{3419427328U, 24},
	{3419439104U, 19},
	{3419439616U, 24},
	{3419439872U, 24},
	{3419440128U, 24},
	{3419440640U, 24},
	{3419440896U, 24},
	{3419441152U, 24},
	{3419441664U, 24},
	{3419602944U, 19},
	{3419701248U, 19},
	{3419799808U, 24},
	{3419856896U, 19},
	{3419930624U, 17},
	{3419963392U, 19},
	{3420192768U, 16},
	{3420454912U, 16},
	{3420520448U, 16},
	{3420585984U, 18},
	{3420618752U, 18},
	{3420635136U, 18},
	{3420656384U, 24},
	{3420693504U, 22},
	{3420717056U, 17},
	{3420749824U, 17},
	{3420749824U, 18},
	{3420762112U, 24},
	{3420762368U, 24},
	{3420762624U, 24},
	{3420766208U, 18},
	{3420770304U, 21},
	{3420815360U, 17},
	{3420820224U, 24},
	{3420848128U, 17},
	{3420849152U, 23},
	{3420851200U, 22},
	{3420864512U, 21},
	{3420866560U, 23},
	{3420867072U, 24},
	{3420867584U, 22},
	{3420867584U, 24},
	{3420868608U, 20},
	{3420872704U, 21},
	{3420874752U, 22},
	{3420880896U, 17},
	{3420889088U, 19},
	{3420901376U, 23},
	{3420979200U, 16},
	{3421011456U, 23},
	{3421011968U, 21},
	{3421014016U, 22},
	{3421036544U, 24},
	{3421036800U, 24},
	{3421037056U, 24},
	{3421037312U, 24},
	{3421037568U, 24},
	{3421037824U, 24},
	{3421038080U, 24},
	{3421038336U, 24},
	{3421038592U, 24},
	{3421038848U, 24},
	{3421039104U, 24},
	{3421039360U, 24},
	{3421039616U, 24},
	{3421039872U, 24},
	{3421044736U, 17},
	{3421065728U, 24},
	{3421066496U, 24},
	{3421068032U, 24},
	{3421077504U, 21},
	{3421079552U, 22},
	{3421081600U, 20},
	{3421085696U, 19},
	{3421093888U, 19},
	{3421102080U, 20},
	{3421110272U, 16},
	{3421122560U, 20},
	{3421134848U, 21},
	{3421136896U, 22},
	{3421137920U, 23},
	{3421138432U, 24},
	{3421144064U, 24},
	{3421152000U, 24},
	{3421175808U, 24},
	{3421176064U, 24},
	{3421177856U, 24},
	{3421178368U, 24},
	{3421208576U, 18},
	{3421213184U, 24},
	{3421224960U, 21},
	{3421229056U, 20},
	{3421233152U, 19},
	{3421241344U, 17},
	{3421241344U, 19},
	{3421249536U, 21},
	{3421251584U, 22},
	{3421257728U, 24},
	{3421258240U, 24},
	{3421258496U, 24},
	{3421259008U, 24},
	{3421259776U, 24},
	{3421260032U, 24},
	{3421260544U, 24},
	{3421260800U, 24},
	{3421261056U, 24},
	{3421261312U, 24},
	{3421290496U, 18},
	{3421295104U, 24},
	{3421299712U, 24},
	{3421304320U, 24},
	{3421304576U, 24},
	{3421304832U, 24},
	{3421306880U, 19},
	{3421315072U, 19},
	{3421323264U, 19},
	{3421331456U, 19},
	{3421339648U, 17},
	{3421355520U, 24},
	{3421359104U, 22},
	{3421360128U, 21},
	{3421372416U, 24},
	{3421372672U, 24},
	{3421374208U, 24},
	{3421379584U, 24},
	{3421381888U, 24},
	{3421421568U, 19},
	{3421429760U, 19},
	{3421446656U, 24},
	{3421452288U, 24},
	{3421452544U, 24},
	{3421457920U, 24},
	{3421487104U, 24},
	{3421487616U, 23},
	{3421488128U, 23},
	{3421488640U, 24},
	{3421488896U, 24},
	{3421489152U, 21},
	{3421491200U, 24},
	{3421491456U, 24},
	{3421491712U, 24},
	{3421491968U, 24},
	{3421492224U, 22},
	{3421493248U, 24},
	{3421493504U, 24},
	{3421493760U, 23},
	{3421494272U, 22},
	{3421495296U, 19},
	{3421503488U, 18},
	{3421536256U, 17},
	{3421536256U, 18},
	{3421536256U, 24},
	{3421552640U, 18},
	{3421562624U, 24},
	{3421569024U, 19},
	{3421581312U, 22},
	{3421582336U, 22},
	{3421583360U, 21},
	{3421585408U, 21},
	{3421585408U, 22},
	{3421586432U, 24},
	{3421586944U, 24},
	{3421587200U, 24},
	{3421587456U, 21},
	{3421589504U, 22},
	{3421590528U, 22},
	{3421591552U, 21},
	{3421593600U, 20},
	{3421597696U, 22},
	{3421598720U, 22},
	{3421599744U, 21},
	{3421599744U, 22},
	{3421600768U, 22},
	{3421601792U, 22},
	{3421602816U, 22},
	{3421603840U, 21},
	{3421605888U, 20},
	{3421609984U, 22},
	{3421611008U, 23},
	{3421611776U, 24},
	{3421612032U, 22},
	{3421612032U, 24},
	{3421612544U, 24},
	{3421613056U, 22},
	{3421613568U, 23},
	{3421614080U, 20},
	{3421618176U, 18},
	{3421618176U, 20},
	{3421622272U, 22},
	{3421623296U, 24},
	{3421623552U, 24},
	{3421626368U, 19},
	{3421642752U, 20},
	{3421646848U, 21},
	{3421648896U, 22},
	{3421649920U, 23},
	{3421650432U, 24},
	{3421650688U, 24},
	{3421650944U, 19},
	{3421659136U, 20},
	{3421663232U, 21},
	{3421665280U, 21},
	{3421667328U, 17},
	{3421700096U, 18},
	{3421700096U, 19},
	{3421708288U, 19},
	{3421716480U, 18},
	{3421741056U, 19},
	{3421749248U, 20},
	{3421753344U, 21},
	{3421765632U, 19},
	{3421773824U, 19},
	{3421782016U, 19},
	{3421790208U, 20},
	{3421794304U, 21},
	{3421796352U, 21},
	{3421798400U, 18},
	{3421814784U, 18},
	{3421831168U, 18},
	{3421847552U, 18},
	{3421863936U, 17},
	{3421896704U, 17},
	{3421923328U, 21},
	{3421927168U, 24},
	{3421929472U, 19},
	{3421943808U, 24},
	{3421944320U, 24},
	{3421944576U, 24},
	{3421944832U, 24},
	{3421945088U, 24},
	{3421945344U, 23},
	{3421945856U, 18},
	{3421962240U, 19},
	{3421970432U, 19},
	{3421978624U, 18},
	{3421995008U, 19},
	{3422003200U, 19},
	{3422003456U, 24},
	{3422003712U, 24},
	{3422004736U, 24},
	{3422005248U, 23},
	{3422008320U, 23},
	{3422011392U, 19},
	{3422018304U, 24},
	{3422018560U, 22},
	{3422019584U, 19},
	{3422060544U, 17},
	{3422075904U, 24},
	{3422085632U, 24},
	{3422085888U, 24},
	{3422093312U, 17},
	{3422093312U, 19},
	{3422096128U, 24},
	{3422096384U, 22},
	{3422097408U, 24},
	{3422097920U, 23},
	{3422102272U, 24},
	{3422104064U, 23},
	{3422104576U, 23},
	{3422105344U, 24},
	{3422109696U, 19},
	{3422114816U, 22},
	{3422115840U, 21},
	{3422117888U, 20},
	{3422126080U, 19},
	{3422134272U, 19},
	{3422142464U, 19},
	{3422150656U, 19},
	{3422158848U, 18},
	{3422167040U, 19},
	{3422175232U, 19},
	{3422183424U, 19},
	{3422189568U, 21},
	{3422191616U, 20},
	{3422195712U, 20},
	{3422199808U, 20},
	{3422205952U, 21},
	{3422206976U, 22},
	{3422208000U, 18},
	{3422224384U, 17},
	{3422257152U, 18},
	{3422273536U, 18},
	{3422273792U, 24},
	{3422274048U, 24},
	{3422282240U, 23},
	{3422282752U, 23},
	{3422283264U, 24},
	{3422288384U, 24},
	{3422289152U, 24},
	{3422290432U, 23},
	{3422290944U, 22},
	{3422291968U, 21},
	{3422294016U, 22},
	{3422296832U, 24},
	{3422297088U, 22},
	{3422298112U, 21},
	{3422300160U, 24},
	{3422300416U, 24},
	{3422300672U, 24},
	{3422300928U, 24},
	{3422301184U, 22},
	{3422302208U, 20},
	{3422306304U, 19},
	{3422314496U, 19},
	{3422322688U, 19},
	{3422330880U, 24},
	{3422331136U, 24},
	{3422331392U, 24},
	{3422331648U, 24},
	{3422331904U, 24},
	{3422332160U, 24},
	{3422332416U, 24},
	{3422332928U, 21},
	{3422334976U, 20},
	{3422339072U, 20},
	{3422343168U, 20},
	{3422347264U, 19},
	{3422355456U, 19},
	{3422363648U, 20},
	{3422371840U, 24},
	{3422372352U, 23},
	{3422372864U, 22},
	{3422373888U, 21},
	{3422380032U, 20},
	{3422388224U, 20},
	{3422392320U, 22},
	{3422396416U, 19},
	{3422404608U, 19},
	{3422412800U, 22},
	{3422414848U, 24},
	{3422416128U, 24},
	{3422416896U, 21},
	{3422416896U, 22},
	{3422418944U, 21},
	{3422420992U, 18},
	{3422431488U, 24},
	{3422431744U, 24},
	{3422432000U, 24},
	{3422432256U, 24},
	{3422433024U, 24},
	{3422437376U, 19},
	{3422445568U, 22},
	{3422451712U, 24},
	{3422461952U, 21},
	{3422464000U, 22},
	{3422465024U, 24},
	{3422465280U, 24},
	{3422466048U, 20},
	{3422470144U, 18},
	{3422486528U, 18},
	{3422502912U, 19},
	{3422511104U, 20},
	{3422517248U, 22},
	{3422518272U, 22},
	{3422526464U, 24},
	{3422526720U, 24},
	{3422526976U, 24},
	{3422527232U, 24},
	{3422527488U, 19},
	{3422535680U, 20},
	{3422539776U, 24},
	{3422540032U, 24},
	{3422540288U, 24},
	{3422540544U, 24},
	{3422540800U, 22},
	{3422541824U, 22},
	{3422541824U, 23},
	{3422542336U, 23},
	{3422542848U, 23},
	{3422543360U, 23},
	{3422543872U, 21},
	{3422545920U, 24},
	{3422546432U, 24},
	{3422546944U, 22},
	{3422547968U, 21},
	{3422550016U, 21},
	{3422552064U, 14},
	{3422564608U, 24},
	{3422572544U, 24},
	{3422612992U, 24},
	{3422614528U, 24},
	{3422614784U, 24},
	{3422636288U, 24},
	{3422829568U, 24},
	{3422836224U, 23},
	{3422836736U, 24},
	{3422859776U, 24},
	{3422860032U, 24},
	{3422860800U, 24},
	{3422861056U, 24},
	{3422861568U, 24},
	{3422862080U, 24},
	{3422862848U, 24},
	{3422863104U, 24},
	{3422867968U, 23},
	{3422968576U, 24},
	{3422997760U, 24},
	{3422998016U, 24},
	{3422998272U, 24},
	{3422998528U, 24},
	{3422998784U, 24},
	{3423670272U, 24},
	{3423670528U, 24},
	{3423672320U, 24},
	{3423672832U, 24},
	{3423673088U, 24},
	{3423682560U, 18},
	{3423698944U, 24},
	{3423699968U, 24},
	{3423701760U, 24},
	{3423707904U, 24},
	{3423713536U, 24},
	{3423716096U, 24},
	{3423717632U, 24},
	{3423719680U, 24},
	{3423724544U, 24},
	{3423725824U, 24},
	{3423823104U, 24},
	{3423993856U, 15},
	{3424124416U, 24},
	{3424124928U, 15},
	{3424260096U, 20},
	{3424337920U, 18},
	{3424355584U, 24},
	{3424358144U, 24},
	{3424358400U, 24},
	{3424361472U, 24},
	{3424363776U, 24},
	{3424366336U, 24},
	{3424366592U, 24},
	{3424367616U, 24},
	{3424369664U, 24},
	{3424371712U, 24},
	{3424374272U, 24},
	{3424376064U, 24},
	{3424382720U, 24},
	{3424385792U, 24},
	{3424386304U, 24},
	{3424387840U, 24},
	{3424486912U, 24},
	{3424489728U, 24},
	{3424492032U, 24},
	{3424492544U, 24},
	{3424494592U, 24},
	{3424496128U, 24},
	{3424496384U, 24},
	{3424499968U, 24},
	{3424500224U, 23},
	{3424501760U, 24},
	{3424504320U, 23},
	{3424505344U, 24},
	{3424505600U, 24},
	{3424506880U, 24},
	{3424508160U, 24},
	{3424513536U, 24},
	{3424518144U, 15},
	{3424526080U, 24},
	{3424541440U, 24},
	{3424548864U, 24},
	{3424583680U, 24},
	{3424638208U, 24},
	{3424649216U, 15},
	{3424673280U, 24},
	{3424721920U, 24},
	{3424761088U, 24},
	{3424763904U, 23},
	{3424764416U, 24},
	{3424778496U, 24},
	{3424778752U, 24},
	{3424779520U, 24},
	{3424780800U, 24},
	{3424781312U, 24},
	{3424782336U, 24},
	{3424782592U, 24},
	{3424782848U, 24},
	{3424783104U, 24},
	{3424783360U, 24},
	{3424783616U, 24},
	{3424783872U, 24},
	{3424784128U, 24},
	{3424807936U, 24},
	{3424808192U, 24},
	{3424815104U, 24},
	{3424816384U, 24},
	{3424819456U, 24},
	{3424819712U, 24},
	{3424822272U, 24},
	{3424823808U, 24},
	{3424824576U, 24},
	{3424825344U, 24},
	{3424830720U, 24},
	{3424831744U, 24},
	{3424832512U, 24},
	{3424832768U, 24},
	{3424834304U, 24},
	{3424838144U, 24},
	{3424838912U, 24},
	{3424840704U, 24},
	{3424841472U, 24},
	{3424842752U, 24},
	{3424844544U, 24},
	{3424845312U, 24},
	{3424915200U, 24},
	{3424915456U, 20},
	{3424919552U, 24},
	{3424919808U, 24},
	{3424921088U, 24},
	{3424922880U, 24},
	{3424923392U, 24},
	{3424980992U, 24},
	{3425009664U, 24},
	{3425009920U, 24},
	{3425010176U, 24},
	{3425010432U, 24},
	{3425010688U, 24},
	{3425010944U, 24},
	{3425011200U, 24},
	{3425011712U, 24},
	{3425016320U, 24},
	{3425020416U, 24},
	{3425022976U, 24},
	{3425023488U, 24},
	{3425028352U, 24},
	{3425042432U, 15},
	{3425061376U, 24},
	{3425304576U, 16},
	{3425308672U, 20},
	{3425316864U, 20},
	{3425337344U, 20},
	{3425369088U, 22},
	{3425468416U, 21},
	{3425470464U, 23},
	{3425488896U, 20},
	{3425497856U, 24},
	{3425699840U, 24},
	{3425705984U, 19},
	{3425994496U, 24},
	{3425995008U, 24},
	{3426004736U, 24},
	{3426004992U, 24},
	{3426005248U, 24},
	{3426005504U, 24},
	{3426007808U, 24},
	{3426008064U, 24},
	{3426008832U, 24},
	{3426014976U, 24},
	{3426017024U, 24},
	{3426020864U, 24},
	{3426021888U, 24},
	{3426022656U, 24},
	{3426022912U, 23},
	{3426024192U, 24},
	{3426024448U, 24},
	{3426025472U, 16},
	{3426091008U, 16},
	{3426222080U, 21},
	{3426238464U, 18},
	{3426238464U, 19},
	{3426246656U, 22},
	{3426247680U, 23},
	{3426248192U, 24},
	{3426248448U, 24},
	{3426248704U, 24},
	{3426248960U, 24},
	{3426249216U, 24},
	{3426249472U, 24},
	{3426249728U, 24},
	{3426249984U, 24},
	{3426250240U, 24},
	{3426250496U, 24},
	{3426250752U, 21},
	{3426252800U, 21},
	{3426287616U, 21},
	{3426295808U, 19},
	{3426323968U, 24},
	{3426360832U, 24},
	{3426391296U, 24},
	{3426392064U, 22},
	{3426410496U, 24},
	{3426410752U, 24},
	{3426411008U, 24},
	{3426411264U, 24},
	{3426412544U, 22},
	{3426416640U, 24},
	{3426484224U, 16},
	{3426547200U, 24},
	{3426549760U, 21},
	{3426551808U, 22},
	{3426552832U, 23},
	{3426619392U, 21},
	{3426621440U, 22},
	{3426648064U, 22},
	{3426649088U, 23},
	{3426656000U, 24},
	{3426656768U, 24},
	{3426664448U, 24},
	{3426671360U, 24},
	{3426671616U, 23},
	{3426672128U, 24},
	{3426672384U, 24},
	{3426674432U, 24},
	{3426674688U, 24},
	{3426678016U, 24},
	{3426678272U, 24},
	{3426678528U, 24},
	{3426678784U, 23},
	{3426680320U, 24},
	{3426732032U, 21},
	{3426736128U, 21},
	{3426746368U, 14},
	{3427012608U, 20},
	{3427042560U, 24},
	{3427044352U, 24},
	{3427046656U, 24},
	{3427047168U, 24},
	{3427047424U, 24},
	{3427047680U, 24},
	{3427047936U, 24},
	{3427051520U, 24},
	{3427052800U, 24},
	{3427056128U, 24},
	{3427056384U, 24},
	{3427064064U, 24},
	{3427066624U, 24},
	{3427066880U, 24},
	{3427071744U, 24},
	{3427082240U, 24},
	{3427090432U, 18},
	{3427106816U, 24},
	{3427107584U, 24},
	{3427107840U, 24},
	{3427108096U, 24},
	{3427114240U, 24},
	{3427114496U, 23},
	{3427115008U, 23},
	{3427115520U, 24},
	{3427117312U, 24},
	{3427124736U, 23},
	{3427125248U, 24},
	{3427126784U, 24},
	{3427129856U, 23},
	{3427130368U, 24},
	{3427130880U, 24},
	{3427131648U, 24},
	{3427131904U, 23},
	{3427132416U, 24},
	{3427132672U, 24},
	{3427132928U, 24},
	{3427133952U, 24},
	{3427205632U, 24},
	{3427208192U, 23},
	{3427210496U, 24},
	{3427213056U, 24},
	{3427216640U, 24},
	{3427216896U, 23},
	{3427231232U, 24},
	{3427237632U, 24},
	{3427244544U, 24},
	{3427250176U, 27},
	{3427250208U, 27},
	{3427250304U, 25},
	{3427250432U, 24},
	{3427251200U, 24},
	{3427251712U, 24},
	{3427251968U, 24},
	{3427252352U, 28},
	{3427252368U, 28},
	{3427252384U, 27},
	{3427252416U, 28},
	{3427252992U, 24},
	{3427253248U, 24},
	{3427253504U, 25},
	{3427254016U, 24},
	{3427254336U, 26},
	{3427254512U, 28},
	{3427254528U, 27},
	{3427254560U, 28},
	{3427254784U, 24},
	{3427255296U, 22},
	{3427256320U, 22},
	{3427257344U, 24},
	{3427257600U, 25},
	{3427257728U, 29},
	{3427257736U, 30},
	{3427257740U, 30},
	{3427257744U, 28},
	{3427257824U, 27},
	{3427257888U, 27},
	{3427257952U, 27},
	{3427259392U, 24},
	{3427259648U, 24},
	{3427270656U, 15},
	{3427270656U, 17},
	{3427274240U, 23},
	{3427274752U, 22},
	{3427328512U, 23},
	{3427329024U, 22},
	{3427330048U, 22},
	{3427336192U, 19},
	{3427345408U, 22},
	{3427347200U, 24},
	{3427364096U, 24},
	{3427377152U, 21},
	{3427401728U, 21},
	{3427403776U, 23},
	{3427419136U, 23},
	{3427427584U, 24},
	{3427429120U, 24},
	{3427429376U, 24},
	{3427475456U, 19},
	{3427501824U, 24},
	{3427502336U, 24},
	{3427504640U, 24},
	{3427506432U, 24},
	{3427508480U, 24},
	{3427508736U, 24},
	{3427517184U, 24},
	{3427520768U, 24},
	{3427525632U, 24},
	{3427528192U, 24},
	{3427532800U, 21},
	{3427561728U, 24},
	{3427571712U, 22},
	{3427572736U, 24},
	{3427579392U, 24},
	{3427606528U, 19},
	{3427618304U, 24},
	{3427632640U, 24},
	{3427634432U, 24},
	{3427634688U, 24},
	{3427635456U, 24},
	{3427635712U, 24},
	{3427636224U, 23},
	{3427638272U, 24},
	{3427639040U, 24},
	{3427644672U, 24},
	{3427663872U, 20},
	{3427672064U, 19},
	{3427778048U, 24},
	{3427780352U, 24},
	{3427799040U, 20},
	{3427819520U, 19},
	{3427828736U, 24},
	{3427829760U, 24},
	{3427832320U, 24},
	{3427841536U, 24},
	{3427842048U, 24},
	{3427849472U, 24},
	{3427851520U, 24},
	{3427851776U, 24},
	{3428212736U, 21},
	{3428218880U, 21},
	{3428220928U, 23},
	{3428239360U, 21},
	{3428241408U, 21},
	{3428270080U, 18},
	{3428287744U, 24},
	{3428291328U, 24},
	{3428291840U, 24},
	{3428292352U, 24},
	{3428294144U, 24},
	{3428296960U, 24},
	{3428299264U, 24},
	{3428300544U, 24},
	{3428301568U, 24},
	{3428307200U, 24},
	{3428310016U, 24},
	{3428312576U, 24},
	{3428315392U, 24},
	{3428352000U, 19},
	{3428383232U, 24},
	{3428386816U, 21},
	{3428397056U, 24},
	{3428397312U, 24},
	{3428417792U, 24},
	{3428418304U, 24},
	{3428420096U, 24},
	{3428420352U, 24},
	{3428420608U, 24},
	{3428424448U, 24},
	{3428426496U, 24},
	{3428426752U, 22},
	{3428428800U, 24},
	{3428431104U, 24},
	{3428432896U, 24},
	{3428435200U, 24},
	{3428435968U, 24},
	{3428440064U, 24},
	{3428440832U, 24},
	{3428442624U, 24},
	{3428443904U, 24},
	{3428445952U, 24},
	{3428447232U, 24},
	{3428449024U, 24},
	{3428449792U, 24},
	{3428467968U, 24},
	{3428469248U, 24},
	{3428470272U, 24},
	{3428480512U, 24},
	{3428480768U, 24},
	{3428481024U, 23},
	{3428481536U, 24},
	{3428496640U, 24},
	{3428496896U, 24},
	{3428518400U, 24},
	{3428518656U, 24},
	{3428518912U, 24},
	{3428519168U, 24},
	{3428551424U, 24},
	{3428555776U, 24},
	{3428559360U, 24},
	{3428574208U, 24},
	{3428604672U, 24},
	{3428641280U, 23},
	{3428642048U, 24},
	{3428722432U, 24},
	{3428722688U, 21},
	{3428728832U, 19},
	{3428745472U, 24},
	{3428749312U, 20},
	{3428818944U, 19},
	{3428827136U, 19},
	{3428836864U, 24},
	{3428872192U, 24},
	{3428909568U, 24},
	{3428909824U, 24},
	{3428917248U, 19},
	{3428925440U, 21},
	{3428927488U, 24},
	{3428931840U, 24},
	{3428935680U, 24},
	{3428936704U, 22},
	{3428965376U, 24},
	{3428965888U, 23},
	{3429040128U, 17},
	{3429073920U, 24},
	{3429080576U, 24},
	{3429089280U, 19},
	{3429097472U, 19},
	{3429178880U, 24},
	{3429179136U, 24},
	{3429179648U, 24},
	{3429179904U, 24},
	{3429342464U, 24},
	{3429342720U, 24},
	{3429500928U, 21},
	{3429531648U, 24},
	{3429531904U, 24},
	{3429532160U, 24},
	{3429544960U, 23},
	{3429572608U, 22},
	{3429574656U, 22},
	{3429575680U, 22},
	{3429576704U, 22},
	{3429577728U, 22},
	{3429578752U, 22},
	{3429579776U, 22},
	{3429584128U, 24},
	{3429586176U, 24},
	{3429587712U, 24},
	{3429588480U, 24},
	{3429591296U, 24},
	{3429592320U, 24},
	{3429597440U, 24},
	{3429597696U, 24},
	{3429600256U, 24},
	{3429600768U, 24},
	{3429603840U, 24},
	{3429604352U, 24},
	{3429606912U, 24},
	{3429611264U, 24},
	{3429618432U, 24},
	{3429623808U, 24},
	{3429625344U, 24},
	{3429628160U, 24},
	{3429628928U, 24},
	{3429629440U, 24},
	{3429629952U, 21},
	{3429632000U, 24},
	{3429632256U, 24},
	{3429632512U, 24},
	{3429634048U, 24},
	{3429634304U, 24},
	{3429634560U, 24},
	{3429634816U, 24},
	{3429635072U, 24},
	{3429635328U, 24},
	{3429635584U, 24},
	{3429635840U, 24},
	{3429636096U, 24},
	{3429636352U, 24},
	{3429703680U, 24},
	{3429706496U, 24},
	{3429714432U, 24},
	{3429761024U, 21},
	{3429795584U, 24},
	{3429796352U, 24},
	{3429803008U, 24},
	{3429803776U, 24},
	{3429804288U, 24},
	{3430039552U, 18},
	{3430055936U, 17},
	{3430087936U, 24},
	{3430108160U, 24},
	{3430113280U, 24},
	{3430113536U, 24},
	{3430113792U, 24},
	{3430114048U, 24},
	{3430119680U, 24},
	{3430130688U, 24},
	{3430131712U, 21},
	{3430143744U, 24},
	{3430144000U, 21},
	{3430146048U, 24},
	{3430146304U, 24},
	{3430146560U, 24},
	{3430146816U, 24},
	{3430147072U, 24},
	{3430147328U, 24},
	{3430147584U, 24},
	{3430154240U, 16},
	{3430154240U, 17},
	{3430187008U, 17},
	{3430277120U, 23},
	{3430293504U, 24},
	{3430298624U, 24},
	{3430298880U, 24},
	{3430299136U, 24},
	{3430299392U, 24},
	{3430324736U, 24},
	{3430350848U, 18},
	{3430350848U, 23},
	{3430351616U, 24},
	{3430357248U, 24},
	{3430357760U, 24},
	{3430365184U, 22},
	{3430366464U, 24},
	{3430367232U, 18},
	{3430418432U, 21},
	{3430450176U, 22},
	{3430451712U, 24},
	{3430453248U, 20},
	{3430469376U, 24},
	{3430481920U, 16},
	{3430547456U, 21},
	{3430612992U, 16},
	{3430700288U, 24},
	{3430700544U, 24},
	{3430705152U, 24},
	{3430705408U, 24},
	{3430705664U, 24},
	{3430705920U, 24},
	{3430709248U, 24},
	{3430709504U, 24},
	{3430709760U, 24},
	{3430710016U, 24},
	{3430712320U, 24},
	{3430712576U, 24},
	{3430712832U, 24},
	{3430713088U, 24},
	{3430713600U, 24},
	{3430719488U, 22},
	{3430720512U, 23},
	{3430721024U, 24},
	{3430727680U, 22},
	{3430728960U, 24},
	{3430731776U, 23},
	{3430740992U, 24},
	{3430741248U, 24},
	{3430741504U, 24},
	{3430741760U, 24},
	{3430744064U, 16},
	{3430780416U, 24},
	{3430810112U, 23},
	{3430811648U, 24},
	{3430815232U, 24},
	{3430840320U, 24},
	{3430840576U, 24},
	{3430840832U, 24},
	{3430841088U, 24},
	{3430843904U, 24},
	{3430844160U, 24},
	{3430844928U, 23},
	{3430846464U, 23},
	{3430851072U, 23},
	{3430853632U, 24},
	{3430853888U, 24},
	{3430857216U, 23},
	{3430857728U, 22},
	{3430868480U, 24},
	{3430871552U, 24},
	{3430871808U, 24},
	{3430873600U, 23},
	{3430873600U, 24},
	{3430873856U, 24},
	{3430874624U, 23},
	{3430891520U, 20},
	{3430907904U, 17},
	{3430924288U, 20},
	{3430978304U, 24},
	{3430980096U, 24},
	{3430980608U, 24},
	{3430981120U, 24},
	{3430985472U, 24},
	{3430986240U, 24},
	{3430986496U, 24},
	{3430986752U, 24},
	{3430989824U, 24},
	{3430991616U, 24},
	{3430993408U, 24},
	{3430995200U, 24},
	{3430996224U, 24},
	{3430997504U, 24},
	{3430998528U, 24},
	{3430998784U, 24},
	{3431000064U, 22},
	{3431001088U, 22},
	{3431002880U, 24},
	{3431005696U, 24},
	{3431112192U, 24},
	{3431113984U, 24},
	{3431114240U, 24},
	{3431116800U, 24},
	{3431118848U, 24},
	{3431119104U, 24},
	{3431122432U, 24},
	{3431127040U, 24},
	{3431129600U, 23},
	{3431130112U, 22},
	{3431131136U, 22},
	{3431132160U, 23},
	{3431134208U, 24},
	{3431135232U, 24},
	{3431135488U, 24},
	{3431153152U, 24},
	{3431190528U, 24},
	{3431260160U, 20},
	{3431367424U, 24},
	{3431367680U, 24},
	{3431367936U, 24},
	{3431368448U, 24},
	{3431368704U, 24},
	{3431368960U, 24},
	{3431369216U, 24},
	{3431370240U, 24},
	{3431370752U, 24},
	{3431371520U, 24},
	{3431372288U, 24},
	{3431390208U, 24},
	{3431390720U, 24},
	{3431395328U, 23},
	{3431470848U, 24},
	{3431471104U, 23},
	{3431471616U, 23},
	{3431472128U, 23},
	{3431563520U, 24},
	{3431563776U, 23},
	{3431564288U, 23},
	{3431581440U, 24},
	{3431606784U, 23},
	{3431607296U, 22},
	{3431608320U, 22},
	{3431609344U, 22},
	{3431610368U, 22},
	{3431656448U, 24},
	{3431673088U, 24},
	{3431677952U, 18},
	{3431727104U, 24},
	{3431730944U, 24},
	{3431735296U, 19},
	{3431745280U, 24},
	{3431759872U, 17},
	{3431771392U, 24},
	{3431789824U, 24},
	{3431792640U, 16},
	{3431794688U, 21},
	{3431799040U, 24},
	{3431799552U, 24},
	{3431801088U, 24},
	{3431803904U, 22},
	{3431804928U, 21},
	{3431809024U, 20},
	{3431814144U, 24},
	{3431815936U, 24},
	{3431818496U, 24},
	{3431819264U, 21},
	{3431825408U, 19},
	{3431835648U, 22},
	{3431837440U, 24},
	{3431837696U, 24},
	{3431845632U, 24},
	{3431847936U, 24},
	{3431851264U, 24},
	{3431852800U, 24},
	{3431853056U, 23},
	{3431853056U, 24},
	{3431858176U, 15},
	{3431895040U, 22},
	{3431903744U, 24},
	{3431920640U, 22},
	{3431927040U, 24},
	{3431927296U, 24},
	{3431968768U, 20},
	{3431972864U, 22},
	{3431981056U, 20},
	{3431997440U, 20},
	{3432001536U, 21},
	{3432003584U, 24},
	{3432008704U, 24},
	{3432016384U, 24},
	{3432022016U, 17},
	{3432022016U, 24},
	{3432022272U, 24},
	{3432022528U, 24},
	{3432022784U, 24},
	{3432023040U, 24},
	{3432023296U, 24},
	{3432025088U, 24},
	{3432025344U, 24},
	{3432032256U, 24},
	{3432035072U, 24},
	{3432036096U, 24},
	{3432036352U, 24},
	{3432051456U, 24},
	{3432051712U, 24},
	{3432085248U, 24},
	{3432091648U, 24},
	{3432092416U, 24},
	{3432092672U, 24},
	{3432097536U, 24},
	{3432098560U, 24},
	{3432108800U, 24},
	{3432112128U, 24},
	{3432112384U, 24},
	{3432113664U, 24},
	{3432120064U, 24},
	{3432120320U, 16},
	{3432126464U, 22},
	{3432162560U, 24},
	{3432199936U, 24},
	{3432230912U, 20},
	{3432271872U, 21},
	{3432275968U, 21},
	{3432288256U, 20},
	{3432292352U, 20},
	{3432341504U, 20},
	{3432345600U, 21},
	{3432462592U, 24},
	{3432516608U, 23},
	{3432519680U, 24},
	{3432519936U, 24},
	{3432525312U, 23},
	{3432525824U, 24},
	{3432526080U, 24},
	{3432527872U, 23},
	{3432528896U, 24},
	{3432531456U, 23},
	{3432534016U, 23},
	{3432542720U, 23},
	{3432546304U, 23},
	{3432547840U, 23},
	{3432549888U, 24},
	{3432550144U, 24},
	{3432553472U, 22},
	{3432556064U, 27},
	{3432556096U, 27},
	{3432556160U, 28},
	{3432556176U, 28},
	{3432556288U, 24},
	{3432560640U, 21},
	{3432591616U, 24},
	{3432591872U, 24},
	{3432592128U, 24},
	{3432594432U, 24},
	{3432594688U, 24},
	{3432594944U, 24},
	{3432595200U, 24},
	{3432596480U, 24},
	{3432597248U, 24},
	{3432603648U, 22},
	{3432613376U, 24},
	{3432620032U, 22},
	{3432623872U, 24},
	{3432624128U, 22},
	{3432629760U, 24},
	{3432637440U, 22},
	{3432652800U, 21},
	{3432662784U, 24},
	{3432673280U, 21},
	{3432693760U, 21},
	{3432702976U, 24},
	{3432714240U, 21},
	{3432716288U, 23},
	{3432724480U, 24},
	{3432726528U, 20},
	{3432751104U, 20},
	{3432768000U, 24},
	{3432775680U, 19},
	{3432795648U, 24},
	{3432797184U, 24},
	{3432800256U, 20},
	{3432804352U, 21},
	{3432806400U, 24},
	{3432808448U, 19},
	{3432844032U, 24},
	{3432880384U, 24},
	{3432895232U, 24},
	{3432897536U, 22},
	{3432902144U, 24},
	{3432981504U, 22},
	{3432999680U, 24},
	{3432999936U, 22},
	{3433189376U, 21},
	{3433277952U, 24},
	{3433325056U, 23},
	{3433325568U, 23},
	{3433369856U, 24},
	{3433370112U, 24},
	{3433521152U, 20},
	{3433562112U, 16},
	{3433565184U, 24},
	{3433566208U, 24},
	{3433566464U, 24},
	{3433566720U, 24},
	{3433566976U, 24},
	{3433567232U, 24},
	{3433567744U, 24},
	{3433568000U, 24},
	{3433568256U, 24},
	{3433568512U, 24},
	{3433568768U, 24},
	{3433569024U, 24},
	{3433569280U, 24},
	{3433569536U, 24},
	{3433569792U, 24},
	{3433570048U, 24},
	{3433578752U, 24},
	{3433579008U, 24},
	{3433579264U, 24},
	{3433579520U, 24},
	{3433579776U, 24},
	{3433580032U, 24},
	{3433580288U, 24},
	{3433580544U, 24},
	{3433581312U, 24},
	{3433584128U, 24},
	{3433585152U, 24},
	{3433585408U, 24},
	{3433586176U, 24},
	{3433590784U, 22},
	{3433603072U, 19},
	{3433627648U, 16},
	{3433630720U, 22},
	{3433641984U, 22},
	{3433693184U, 15},
	{3433698816U, 24},
	{3433699072U, 24},
	{3433702656U, 24},
	{3433763072U, 24},
	{3433763328U, 23},
	{3433763840U, 24},
	{3433764608U, 24},
	{3433776128U, 22},
	{3433777152U, 22},
	{3433778176U, 23},
	{3433778688U, 23},
	{3433786368U, 22},
	{3433787392U, 21},
	{3433792000U, 23},
	{3433792512U, 22},
	{3433793536U, 21},
	{3433799680U, 21},
	{3433801984U, 24},
	{3433802240U, 24},
	{3433805824U, 24},
	{3433806080U, 24},
	{3433806336U, 23},
	{3433806848U, 24},
	{3433949696U, 24},
	{3434123776U, 24},
	{3434131712U, 24},
	{3434132736U, 24},
	{3434135040U, 24},
	{3434160128U, 19},
	{3434172416U, 21},
	{3434175488U, 24},
	{3434175744U, 24},
	{3434191360U, 23},
	{3434221568U, 20},
	{3434264832U, 24},
	{3434328064U, 21},
	{3434344448U, 24},
	{3434356992U, 24},
	{3434364160U, 24},
	{3434364416U, 24},
	{3434397696U, 20},
	{3434407424U, 23},
	{3434407936U, 21},
	{3434423552U, 24},
	{3434434560U, 20},
	{3434443776U, 24},
	{3434451712U, 24},
	{3434452224U, 24},
	{3434493696U, 24},
	{3434493952U, 24},
	{3434496000U, 18},
	{3434516480U, 24},
	{3434554112U, 24},
	{3434569728U, 20},
	{3434586112U, 20},
	{3434594304U, 20},
	{3434597632U, 24},
	{3434610688U, 17},
	{3434643456U, 18},
	{3434659840U, 18},
	{3434676224U, 19},
	{3434684416U, 19},
	{3434692608U, 18},
	{3434708992U, 17},
	{3434741760U, 16},
	{3434846208U, 24},
	{3434947072U, 24},
	{3434962432U, 23},
	{3435164416U, 24},
	{3435167488U, 24},
	{3435216640U, 24},
	{3435233280U, 19},
	{3435236352U, 22},
	{3435238144U, 24},
	{3435238912U, 23},
	{3435239424U, 22},
	{3435273216U, 22},
	{3435280384U, 21},
	{3435292672U, 23},
	{3435293184U, 23},
	{3435293696U, 23},
	{3435294208U, 23},
	{3435311104U, 21},
	{3435592192U, 24},
	{3435659264U, 14},
	{3435663360U, 21},
	{3435665408U, 23},
	{3435665920U, 23},
	{3435667712U, 24},
	{3435675648U, 24},
	{3435676416U, 24},
	{3435676672U, 22},
	{3435677696U, 21},
	{3435679744U, 20},
	{3435684352U, 24},
	{3435696128U, 21},
	{3435698176U, 22},
	{3435724800U, 20},
	{3435729920U, 24},
	{3435730176U, 24},
	{3435731200U, 24},
	{3435733504U, 24},
	{3435734016U, 22},
	{3435734016U, 24},
	{3435734272U, 24},
	{3435734528U, 23},
	{3435734528U, 24},
	{3435734784U, 24},
	{3435737088U, 21},
	{3435753472U, 20},
	{3435784192U, 21},
	{3435786240U, 20},
	{3435823104U, 19},
	{3435826432U, 24},
	{3435860992U, 22},
	{3435860992U, 24},
	{3435861248U, 24},
	{3435861504U, 23},
	{3435861504U, 24},
	{3435861760U, 24},
	{3435864064U, 24},
	{3435864576U, 24},
	{3435868160U, 23},
	{3435868672U, 24},
	{3435869184U, 22},
	{3435879424U, 24},
	{3435888128U, 24},
	{3435888640U, 19},
	{3435917312U, 22},
	{3435920384U, 22},
	{3436183808U, 24},
	{3436184064U, 24},
	{3436184320U, 24},
	{3436184576U, 24},
	{3436184832U, 24},
	{3436185088U, 24},
	{3436185344U, 24},
	{3436185600U, 24},
	{3436185856U, 24},
	{3436186112U, 24},
	{3436186368U, 24},
	{3436186624U, 24},
	{3436186880U, 24},
	{3436187136U, 24},
	{3436187392U, 24},
	{3436187648U, 24},
	{3436187904U, 24},
	{3436188160U, 24},
	{3436188416U, 24},
	{3436188672U, 24},
	{3436190720U, 22},
	{3436190720U, 24},
	{3436190976U, 24},
	{3436191232U, 24},
	{3436191488U, 24},
	{3436191744U, 21},
	{3436191744U, 24},
	{3436192000U, 24},
	{3436192256U, 24},
	{3436192512U, 24},
	{3436193024U, 24},
	{3436193280U, 24},
	{3436193792U, 22},
	{3436193792U, 24},
	{3436194304U, 24},
	{3436194560U, 24},
	{3436198144U, 24},
	{3436204032U, 24},
	{3436204288U, 24},
	{3436204544U, 24},
	{3436204800U, 24},
	{3436205056U, 24},
	{3436205312U, 24},
	{3436205568U, 24},
	{3436205824U, 24},
	{3436206080U, 24},
	{3436206336U, 24},
	{3436206592U, 24},
	{3436206848U, 24},
	{3436207104U, 24},
	{3436207360U, 24},
	{3436207616U, 24},
	{3436207872U, 24},
	{3436226560U, 24},
	{3436232704U, 24},
	{3436232960U, 24},
	{3436233216U, 24},
	{3436233472U, 24},
	{3436233728U, 24},
	{3436233984U, 24},
	{3436234240U, 24},
	{3436234496U, 24},
	{3436235520U, 24},
	{3436236288U, 24},
	{3436236544U, 24},
	{3436236800U, 24},
	{3436237056U, 24},
	{3436238080U, 24},
	{3436238336U, 24},
	{3436238592U, 24},
	{3436239104U, 24},
	{3436239360U, 24},
	{3436239616U, 24},
	{3436239872U, 24},
	{3436240128U, 24},
	{3436240384U, 24},
	{3436286208U, 24},
	{3436314624U, 20},
	{3436318720U, 20},
	{3436322816U, 20},
	{3436326912U, 20},
	{3436331008U, 18},
	{3436339200U, 19},
	{3436347392U, 19},
	{3436355584U, 20},
	{3436363776U, 19},
	{3436371968U, 20},
	{3436376064U, 21},
	{3436378112U, 22},
	{3436379136U, 24},
	{3436379392U, 24},
	{3436456960U, 22},
	{3436478464U, 19},
	{3436505088U, 21},
	{3436505088U, 24},
	{3436505344U, 24},
	{3436505600U, 24},
	{3436505856U, 24},
	{3436506112U, 24},
	{3436506368U, 24},
	{3436506624U, 24},
	{3436506880U, 24},
	{3436533760U, 23},
	{3436534272U, 23},
	{3436535296U, 23},
	{3436535808U, 20},
	{3436563456U, 23},
	{3436578560U, 24},
	{3436601344U, 19},
	{3436603648U, 24},
	{3436606464U, 24},
	{3436606720U, 24},
	{3436613632U, 20},
	{3436670976U, 20},
	{3436707840U, 17},
	{3436712192U, 24},
	{3436712448U, 24},
	{3436712704U, 24},
	{3436712960U, 24},
	{3436732672U, 24},
	{3436733696U, 24},
	{3436733952U, 24},
	{3436734208U, 24},
	{3436734976U, 24},
	{3436740608U, 17},
	{3436969984U, 15},
	{3436979968U, 24},
	{3436986368U, 18},
	{3437010944U, 19},
	{3437015808U, 24},
	{3437016320U, 24},
	{3437016576U, 24},
	{3437016832U, 24},
	{3437017088U, 24},
	{3437018112U, 24},
	{3437018368U, 24},
	{3437018624U, 24},
	{3437021184U, 21},
	{3437023232U, 21},
	{3437038336U, 24},
	{3437044736U, 22},
	{3437054976U, 24},
	{3437056000U, 20},
	{3437096960U, 21},
	{3437101056U, 23},
	{3437101568U, 24},
	{3437102592U, 23},
	{3437103104U, 23},
	{3437105152U, 24},
	{3437105408U, 24},
	{3437105664U, 24},
	{3437105920U, 24},
	{3437106176U, 22},
	{3437107200U, 24},
	{3437107456U, 24},
	{3437107712U, 24},
	{3437107968U, 24},
	{3437109248U, 24},
	{3437109504U, 24},
	{3437109760U, 24},
	{3437110016U, 24},
	{3437110272U, 24},
	{3437110528U, 24},
	{3437110784U, 24},
	{3437111040U, 24},
	{3437111296U, 24},
	{3437112064U, 24},
	{3437112320U, 24},
	{3437112576U, 24},
	{3437112832U, 24},
	{3437113088U, 24},
	{3437117440U, 21},
	{3437137408U, 24},
	{3437137664U, 24},
	{3437137920U, 23},
	{3437138432U, 24},
	{3437139200U, 24},
	{3437141504U, 24},
	{3437141760U, 24},
	{3437142016U, 24},
	{3437142784U, 24},
	{3437143808U, 24},
	{3437144064U, 24},
	{3437144320U, 24},
	{3437144576U, 24},
	{3437145344U, 24},
	{3437146112U, 24},
	{3437146368U, 24},
	{3437146624U, 24},
	{3437146880U, 24},
	{3437155840U, 23},
	{3437157376U, 24},
	{3437157632U, 24},
	{3437159424U, 24},
	{3437159680U, 24},
	{3437159936U, 23},
	{3437160448U, 21},
	{3437165056U, 23},
	{3437165568U, 23},
	{3437232128U, 16},
	{3437331968U, 24},
	{3437345280U, 24},
	{3437353472U, 24},
	{3437436928U, 19},
	{3437469696U, 19},
	{3437471488U, 24},
	{3437473280U, 24},
	{3437510656U, 24},
	{3437511424U, 24},
	{3437511680U, 24},
	{3437511936U, 24},
	{3437512448U, 24},
	{3437514240U, 24},
	{3437514752U, 24},
	{3437515264U, 24},
	{3437546240U, 24},
	{3437546496U, 24},
	{3437606400U, 24},
	{3437701888U, 24},
	{3437709824U, 24},
	{3437715712U, 24},
	{3437719040U, 23},
	{3437751808U, 24},
	{3437754368U, 24},
	{3437754624U, 24},
	{3437754880U, 24},
	{3437755904U, 24},
	{3437821952U, 16},
	{3437830144U, 23},
	{3437830656U, 24},
	{3437832960U, 24},
	{3437839616U, 24},
	{3437839872U, 24},
	{3437840128U, 24},
	{3437848576U, 24},
	{3437850880U, 24},
	{3437851136U, 24},
	{3437857536U, 24},
	{3437865472U, 24},
	{3437865984U, 22},
	{3437868544U, 23},
	{3437869056U, 24},
	{3437961216U, 21},
	{3437963264U, 22},
	{3437973504U, 20},
	{3437977600U, 21},
	{3437979648U, 24},
	{3437989888U, 20},
	{3437993984U, 20},
	{3438003200U, 24},
	{3438010368U, 20},
	{3438015744U, 24},
	{3438152192U, 24},
	{3438152448U, 24},
	{3438153472U, 24},
	{3438153728U, 24},
	{3438154240U, 24},
	{3438155776U, 23},
	{3438156288U, 24},
	{3438159104U, 24},
	{3438166528U, 24},
	{3438174720U, 24},
	{3438181888U, 24},
	{3438182656U, 24},
	{3438185728U, 24},
	{3438186240U, 24},
	{3438186752U, 24},
	{3438188800U, 24},
	{3438203648U, 24},
	{3438205184U, 24},
	{3438209024U, 24},
	{3438214912U, 24},
	{3438641152U, 17},
	{3438658048U, 24},
	{3438658304U, 24},
	{3438666752U, 24},
	{3438672384U, 24},
	{3438673664U, 24},
	{3438690304U, 18},
	{3438706688U, 20},
	{3438710784U, 21},
	{3438711552U, 24},
	{3438726144U, 24},
	{3438727936U, 24},
	{3438728960U, 28},
	{3438728976U, 28},
	{3438729024U, 28},
	{3438729056U, 28},
	{3438729104U, 28},
	{3438729120U, 28},
	{3438729136U, 28},
	{3438729152U, 28},
	{3438729168U, 28},
	{3438729184U, 28},
	{3438729200U, 28},
	{3438738688U, 24},
	{3438739456U, 16},
	{3438812416U, 24},
	{3438812672U, 24},
	{3438812928U, 24},
	{3438829568U, 20},
	{3438837760U, 20},
	{3438848512U, 23},
	{3438849792U, 24},
	{3438858240U, 21},
	{3438858496U, 24},
	{3438859264U, 24},
	{3438864896U, 24},
	{3438873088U, 24},
	{3438878720U, 20},
	{3438882816U, 20},
	{3438883072U, 24},
	{3438883328U, 24},
	{3438883584U, 24},
	{3438885376U, 24},
	{3438886400U, 24},
	{3438886656U, 24},
	{3438911488U, 22},
	{3438915584U, 21},
	{3438928640U, 24},
	{3438929920U, 24},
	{3438930176U, 24},
	{3438956032U, 24},
	{3438960640U, 20},
	{3438967552U, 24},
	{3438967808U, 24},
	{3438968064U, 24},
	{3438968320U, 24},
	{3438975744U, 24},
	{3438976512U, 24},
	{3438977024U, 19},
	{3439017984U, 21},
	{3439044608U, 22},
	{3439049728U, 22},
	{3439067136U, 22},
	{3439086080U, 24},
	{3439109120U, 24},
	{3439114240U, 21},
	{3439134720U, 21},
	{3439134720U, 24},
	{3439134976U, 24},
	{3439135232U, 24},
	{3439135488U, 24},
	{3439135744U, 24},
	{3439136000U, 24},
	{3439136256U, 24},
	{3439136512U, 24},
	{3439142656U, 24},
	{3439153920U, 24},
	{3439165440U, 22},
	{3439168256U, 24},
	{3439171328U, 24},
	{3439175680U, 21},
	{3439185920U, 21},
	{3439190528U, 24},
	{3439206400U, 24},
	{3439213568U, 24},
	{3439213824U, 24},
	{3439222272U, 24},
	{3439228928U, 21},
	{3439241216U, 24},
	{3439241728U, 24},
	{3439255552U, 21},
	{3439272448U, 24},
	{3439276544U, 24},
	{3439278080U, 24},
	{3439278336U, 24},
	{3439281664U, 24},
	{3439309056U, 24},
	{3439314944U, 21},
	{3439321088U, 20},
	{3439326208U, 23},
	{3443036160U, 24},
	{3443036416U, 24},
	{3443037696U, 24},
	{3443396096U, 24},
	{3443622144U, 24},
	{3443654912U, 24},
	{3443676160U, 24},
	{3443680256U, 22},
	{3443681536U, 24},
	{3443682048U, 24},
	{3443682816U, 24},
	{3443683072U, 24},
	{3443683328U, 24},
	{3443683584U, 24},
	{3443684864U, 24},
	{3443716096U, 24},
	{3443716352U, 24},
	{3443772928U, 24},
	{3443773184U, 24},
	{3443777280U, 24},
	{3443778560U, 24},
	{3443779328U, 24},
	{3443779584U, 24},
	{3443783680U, 24},
	{3443784704U, 24},
	{3443785472U, 24},
	{3443802368U, 24},
	{3443802624U, 24},
	{3443803392U, 24},
	{3443805184U, 24},
	{3443808512U, 24},
	{3443808768U, 24},
	{3443809536U, 24},
	{3443809792U, 24},
	{3443810048U, 24},
	{3443900416U, 20},
	{3443904512U, 21},
	{3443907840U, 24},
	{3443908608U, 24},
	{3443908864U, 24},
	{3443909120U, 24},
	{3443909376U, 24},
	{3443909632U, 24},
	{3443933184U, 24},
	{3443933440U, 24},
	{3443933952U, 24},
	{3444310272U, 24},
	{3444312064U, 24},
	{3444817920U, 23},
	{3444965632U, 24},
	{3445178880U, 24},
	{3445407744U, 24},
	{3445408256U, 24},
	{3445408512U, 24},
	{3445408768U, 24},
	{3445777664U, 24},
	{3445972992U, 24},
	{3445973248U, 24},
	{3445973504U, 24},
	{3445973760U, 24},
	{3445974016U, 24},
	{3446005760U, 24},
	{3446046720U, 24},
	{3446046976U, 24},
	{3446100992U, 24},
	{3446332416U, 24},
	{3446487040U, 21},
	{3446489088U, 22},
	{3446521856U, 24},
	{3446530048U, 19},
	{3446538240U, 24},
	{3446538496U, 24},
	{3446538752U, 24},
	{3446539008U, 24},
	{3446539264U, 24},
	{3446539520U, 24},
	{3446539776U, 24},
	{3446540032U, 24},
	{3446540288U, 24},
	{3446540544U, 24},
	{3446540800U, 24},
	{3446541056U, 24},
	{3446541312U, 24},
	{3446541568U, 24},
	{3446541824U, 24},
	{3446542080U, 24},
	{3446542336U, 24},
	{3446542592U, 24},
	{3446542848U, 24},
	{3446543104U, 24},
	{3446543360U, 24},
	{3446543616U, 24},
	{3446543872U, 24},
	{3446544128U, 24},
	{3446544384U, 24},
	{3446544640U, 24},
	{3446544896U, 24},
	{3446545152U, 24},
	{3446545408U, 24},
	{3446545664U, 24},
	{3446545920U, 24},
	{3446546176U, 24},
	{3446590720U, 24},
	{3446590976U, 24},
	{3446595584U, 24},
	{3446595840U, 24},
	{3447982080U, 24},
	{3447984128U, 21},
	{3447989248U, 22},
	{3447998720U, 24},
	{3447998976U, 24},
	{3447999232U, 24},
	{3447999488U, 24},
	{3448001024U, 24},
	{3448001280U, 24},
	{3448024320U, 24},
	{3448024576U, 24},
	{3448024832U, 24},
	{3448037376U, 24},
	{3448037632U, 24},
	{3448037888U, 24},
	{3448038144U, 24},
	{3448038400U, 24},
	{3448038656U, 24},
	{3448038912U, 24},
	{3448039168U, 24},
	{3448039424U, 24},
	{3448039680U, 24},
	{3448043520U, 21},
	{3448045568U, 16},
	{3448161280U, 24},
	{3448164352U, 24},
	{3448164864U, 24},
	{3448250368U, 24},
	{3448251136U, 24},
	{3448253952U, 24},
	{3448254720U, 24},
	{3448257536U, 24},
	{3448257792U, 24},
	{3448272640U, 24},
	{3448282624U, 24},
	{3448284160U, 22},
	{3448288256U, 23},
	{3448288768U, 23},
	{3448294656U, 24},
	{3448296704U, 24},
	{3448299520U, 24},
	{3448305152U, 23},
	{3448305664U, 23},
	{3448315904U, 20},
	{3448332288U, 24},
	{3448352768U, 20},
	{3448407296U, 24},
	{3448412160U, 22},
	{3448432128U, 24},
	{3448438784U, 23},
	{3448445184U, 24},
	{3448451584U, 23},
	{3448454144U, 23},
	{3448462848U, 24},
	{3448474624U, 23},
	{3448487168U, 24},
	{3448496128U, 22},
	{3448507904U, 23},
	{3448513536U, 22},
	{3448546304U, 22},
	{3448553472U, 19},
	{3448602624U, 18},
	{3448643584U, 22},
	{3448651776U, 23},
	{3448655872U, 22},
	{3448659968U, 22},
	{3448663040U, 23},
	{3448667136U, 22},
	{3448674048U, 24},
	{3448677376U, 24},
	{3448680448U, 24},
	{3448683520U, 22},
	{3448685568U, 24},
	{3448685824U, 24},
	{3448686080U, 24},
	{3448686336U, 24},
	{3448694784U, 22},
	{3448695808U, 24},
	{3448696064U, 24},
	{3448696320U, 24},
	{3448696576U, 24},
	{3448697856U, 22},
	{3448706816U, 24},
	{3448710400U, 24},
	{3448713216U, 23},
	{3448713728U, 23},
	{3448714240U, 22},
	{3448717312U, 21},
	{3448726528U, 23},
	{3448727296U, 24},
	{3448735744U, 21},
	{3448750080U, 21},
	{3448752128U, 24},
	{3448752384U, 24},
	{3448752640U, 24},
	{3448752896U, 24},
	{3448753152U, 24},
	{3448753408U, 24},
	{3448753664U, 24},
	{3448754176U, 21},
	{3448756224U, 21},
	{3448791808U, 24},
	{3448792064U, 24},
	{3448795392U, 24},
	{3448797184U, 24},
	{3448797696U, 24},
	{3448797952U, 24},
	{3448798464U, 24},
	{3448798720U, 24},
	{3448798976U, 24},
	{3448803840U, 24},
	{3448823296U, 24},
	{3448823552U, 24},
	{3448824064U, 24},
	{3448872448U, 24},
	{3448873216U, 24},
	{3448897536U, 16},
	{3448898560U, 22},
	{3448917504U, 23},
	{3448935424U, 22},
	{3448936448U, 24},
	{3448938496U, 22},
	{3448948736U, 21},
	{3448950784U, 23},
	{3448954880U, 20},
	{3448963072U, 18},
	{3448995840U, 19},
	{3449060096U, 24},
	{3449060608U, 24},
	{3449086208U, 24},
	{3449088256U, 24},
	{3449094144U, 21},
	{3449110528U, 19},
	{3449124864U, 22},
	{3449125888U, 23},
	{3449126912U, 20},
	{3449135104U, 19},
	{3449363456U, 22},
	{3449371648U, 22},
	{3449378816U, 22},
	{3449412608U, 24},
	{3449419776U, 22},
	{3449586944U, 24},
	{3449593856U, 24},
	{3449598208U, 24},
	{3449635072U, 24},
	{3449641472U, 24},
	{3449644544U, 24},
	{3449644800U, 24},
	{3449645056U, 24},
	{3449651200U, 20},
	{3449659392U, 19},
	{3449680896U, 24},
	{3449683968U, 16},
	{3449699328U, 23},
	{3449699840U, 23},
	{3449706496U, 22},
	{3449712640U, 22},
	{3449713664U, 23},
	{3449714176U, 24},
	{3449714432U, 24},
	{3449714688U, 24},
	{3449714944U, 24},
	{3449715200U, 24},
	{3449715456U, 24},
	{3449715712U, 24},
	{3449716224U, 23},
	{3449724928U, 23},
	{3449725952U, 23},
	{3449726976U, 21},
	{3449729024U, 22},
	{3449730048U, 23},
	{3449730560U, 23},
	{3449731072U, 23},
	{3449731072U, 24},
	{3449731584U, 23},
	{3449732096U, 22},
	{3449733120U, 23},
	{3449733632U, 23},
	{3449734144U, 23},
	{3449734656U, 23},
	{3449735168U, 23},
	{3449735680U, 23},
	{3449736192U, 22},
	{3449737216U, 23},
	{3449737728U, 23},
	{3449738240U, 22},
	{3449739264U, 22},
	{3449740288U, 22},
	{3449741312U, 22},
	{3449742336U, 23},
	{3449742848U, 23},
	{3449743360U, 23},
	{3449743872U, 23},
	{3449744384U, 22},
	{3449749760U, 24},
	{3449756416U, 24},
	{3449756672U, 24},
	{3449770240U, 24},
	{3449770752U, 24},
	{3449781760U, 24},
	{3449783296U, 24},
	{3449787136U, 24},
	{3449788160U, 24},
	{3449788928U, 24},
	{3449789696U, 24},
	{3449792768U, 24},
	{3449793792U, 24},
	{3449794560U, 24},
	{3449798400U, 24},
	{3449799168U, 24},
	{3449801216U, 24},
	{3449806848U, 24},
	{3449809152U, 24},
	{3449810176U, 24},
	{3449810432U, 24},
	{3449810688U, 24},
	{3449812992U, 24},
	{3449815040U, 22},
	{3449816064U, 23},
	{3449843712U, 20},
	{3449870336U, 22},
	{3449933056U, 24},
	{3449947392U, 24},
	{3449947904U, 24},
	{3449959936U, 24},
	{3449960960U, 24},
	{3449961216U, 24},
	{3449962496U, 20},
	{3449997568U, 24},
	{3449997824U, 24},
	{3450007552U, 24},
	{3450011648U, 19},
	{3450012160U, 24},
	{3450012416U, 24},
	{3450026496U, 24},
	{3450132480U, 23},
	{3450133248U, 24},
	{3450209280U, 24},
	{3450210304U, 24},
	{3450214144U, 24},
	{3450216448U, 24},
	{3450216704U, 24},
	{3450217472U, 24},
	{3450218240U, 24},
	{3450219520U, 24},
	{3450220544U, 24},
	{3450224128U, 24},
	{3450224640U, 24},
	{3450227712U, 24},
	{3450229248U, 24},
	{3450229760U, 24},
	{3450231808U, 24},
	{3450235904U, 24},
	{3450236160U, 24},
	{3450239232U, 24},
	{3450242048U, 24},
	{3450246912U, 24},
	{3450250496U, 24},
	{3450254336U, 24},
	{3450258176U, 24},
	{3450263040U, 24},
	{3450266112U, 24},
	{3450268160U, 24},
	{3450272000U, 24},
	{3450272256U, 24},
	{3450273024U, 24},
	{3450278656U, 24},
	{3450279424U, 23},
	{3450280960U, 23},
	{3450283008U, 23},
	{3450285568U, 23},
	{3450288640U, 23},
	{3450289664U, 23},
	{3450291200U, 23},
	{3450293248U, 23},
	{3450294272U, 23},
	{3450296320U, 24},
	{3450296576U, 24},
	{3450296832U, 23},
	{3450301440U, 24},
	{3450301696U, 24},
	{3450301952U, 24},
	{3450302208U, 24},
	{3450304000U, 24},
	{3450305536U, 23},
	{3450306560U, 23},
	{3450310144U, 23},
	{3450312192U, 23},
	{3450312704U, 23},
	{3450321920U, 23},
	{3450334720U, 23},
	{3450513408U, 21},
	{3450552320U, 21},
	{3450601472U, 22},
	{3450603520U, 22},
	{3450605568U, 22},
	{3450619904U, 21},
	{3450621952U, 20},
	{3450626048U, 21},
	{3450628096U, 22},
	{3450637056U, 24},
	{3450641408U, 22},
	{3450643456U, 24},
	{3450653440U, 24},
	{3450655744U, 22},
	{3450667008U, 21},
	{3450675200U, 21},
	{3450677248U, 21},
	{3450691328U, 24},
	{3450700032U, 24},
	{3450703616U, 24},
	{3450712064U, 21},
	{3450718208U, 21},
	{3450728448U, 24},
	{3450736640U, 24},
	{3450737920U, 24},
	{3450738176U, 24},
	{3450738432U, 24},
	{3450741248U, 24},
	{3450743040U, 24},
	{3450748928U, 20},
	{3450773248U, 24},
	{3450793984U, 20},
	{3450798080U, 19},
	{3450822656U, 19},
	{3450851328U, 24},
	{3450855424U, 24},
	{3450862592U, 24},
	{3450932736U, 24},
	{3450945024U, 24},
	{3450948608U, 24},
	{3450950656U, 23},
	{3450958848U, 22},
	{3450964992U, 22},
	{3450966016U, 20},
	{3450973184U, 24},
	{3450994688U, 17},
	{3451027456U, 18},
	{3451128320U, 24},
	{3451129600U, 24},
	{3451160832U, 24},
	{3451209728U, 24},
	{3451224064U, 19},
	{3451252736U, 24},
	{3451253248U, 24},
	{3451384320U, 24},
	{3451387904U, 14},
	{3451391488U, 24},
	{3451403776U, 24},
	{3451411456U, 24},
	{3451419392U, 24},
	{3451420672U, 23},
	{3451443712U, 23},
	{3451448832U, 24},
	{3451467520U, 24},
	{3451483904U, 24},
	{3451512064U, 24},
	{3451554048U, 24},
	{3451558912U, 24},
	{3451570176U, 24},
	{3451592960U, 24},
	{3451650048U, 16},
	{3451666432U, 18},
	{3451682816U, 17},
	{3451733760U, 24},
	{3451734016U, 23},
	{3451749888U, 24},
	{3451751168U, 24},
	{3451767808U, 24},
	{3451781120U, 16},
	{3451817472U, 24},
	{3451879424U, 23},
	{3451889664U, 24},
	{3451889920U, 24},
	{3451896320U, 24},
	{3452305408U, 18},
	{3452368896U, 21},
	{3452403712U, 20},
	{3452403712U, 24},
	{3452403968U, 24},
	{3452406528U, 24},
	{3452408832U, 22},
	{3452422144U, 23},
	{3452430336U, 22},
	{3452649472U, 19},
	{3452690432U, 19},
	{3452933888U, 24},
	{3452943616U, 24},
	{3452943872U, 23},
	{3452944384U, 21},
	{3452946432U, 22},
	{3452977152U, 18},
	{3453102592U, 24},
	{3453128704U, 24},
	{3453128960U, 24},
	{3453129728U, 24},
	{3453147648U, 24},
	{3453157632U, 24},
	{3453222912U, 16},
	{3453245440U, 21},
	{3453251584U, 20},
	{3453259776U, 21},
	{3453261824U, 21},
	{3453362176U, 19},
	{3453364736U, 24},
	{3453394944U, 20},
	{3453430528U, 24},
	{3453432064U, 24},
	{3453474816U, 24},
	{3453478912U, 23},
	{3453522560U, 27},
	{3453522592U, 27},
	{3453552128U, 23},
	{3453558784U, 20},
	{3453577216U, 24},
	{3453602048U, 24},
	{3453602304U, 23},
	{3453605888U, 24},
	{3453606912U, 22},
	{3453607936U, 19},
	{3453643776U, 23},
	{3453656064U, 22},
	{3453663744U, 24},
	{3453686272U, 24},
	{3453698048U, 19},
	{3453712384U, 23},
	{3453716992U, 23},
	{3453717760U, 24},
	{3453723136U, 24},
	{3453729792U, 23},
	{3453729792U, 24},
	{3453732352U, 23},
	{3453734912U, 24},
	{3453747200U, 17},
	{3453812736U, 16},
	{3453976064U, 24},
	{3453976576U, 24},
	{3454155008U, 24},
	{3454172672U, 23},
	{3454248192U, 24},
	{3454258176U, 24},
	{3454271488U, 18},
	{3454332928U, 21},
	{3454334208U, 24},
	{3454345216U, 20},
	{3454355456U, 21},
	{3454395392U, 22},
	{3454395392U, 24},
	{3454395648U, 24},
	{3454395904U, 24},
	{3454396160U, 24},
	{3454401024U, 24},
	{3454406656U, 21},
	{3454408960U, 24},
	{3454416896U, 24},
	{3454417152U, 24},
	{3454418944U, 20},
	{3454419456U, 24},
	{3454421504U, 24},
	{3454489088U, 23},
	{3454489088U, 24},
	{3454494720U, 22},
	{3454521856U, 23},
	{3454533632U, 16},
	{3454538240U, 23},
	{3454543616U, 24},
	{3454550272U, 24},
	{3454553088U, 22},
	{3454554112U, 22},
	{3454555136U, 24},
	{3454555392U, 24},
	{3454566400U, 21},
	{3454575616U, 24},
	{3454575872U, 24},
	{3454577664U, 22},
	{3454579712U, 23},
	{3454588416U, 24},
	{3454589184U, 24},
	{3454604800U, 23},
	{3454605312U, 21},
	{3454664704U, 19},
	{3454664704U, 22},
	{3454668800U, 21},
	{3454745856U, 24},
	{3454746112U, 24},
	{3454751744U, 23},
	{3454752512U, 24},
	{3454752768U, 23},
	{3454753536U, 24},
	{3454768384U, 24},
	{3454770944U, 24},
	{3454771200U, 20},
	{3454775040U, 24},
	{3454926848U, 18},
	{3454926848U, 24},
	{3454927616U, 24},
	{3454931968U, 24},
	{3454933248U, 24},
	{3454933504U, 23},
	{3454934528U, 24},
	{3454937088U, 21},
	{3454939136U, 24},
	{3455026944U, 24},
	{3455027200U, 23},
	{3455027712U, 24},
	{3455119360U, 24},
	{3455123456U, 21},
	{3455160320U, 22},
	{3455191552U, 23},
	{3455203328U, 22},
	{3455247360U, 24},
	{3455247616U, 24},
	{3455260416U, 24},
	{3455261952U, 24},
	{3455262720U, 22},
	{3455280896U, 24},
	{3455295744U, 24},
	{3455296000U, 23},
	{3455297024U, 23},
	{3455303680U, 19},
	{3455310848U, 24},
	{3455320064U, 21},
	{3455338752U, 24},
	{3455339008U, 24},
	{3455339264U, 24},
	{3455361024U, 21},
	{3455368192U, 24},
	{3455410176U, 24},
	{3455411968U, 24},
	{3455412224U, 22},
	{3455420160U, 24},
	{3455453184U, 21},
	{3455455232U, 23},
	{3455457280U, 22},
	{3455463424U, 20},
	{3455467520U, 21},
	{3455500800U, 24},
	{3455548928U, 23},
	{3455561728U, 20},
	{3455582464U, 24},
	{3455589632U, 24},
	{3455589888U, 24},
	{3455590144U, 24},
	{3455599360U, 24},
	{3455640064U, 24},
	{3455642624U, 24},
	{3455643904U, 24},
	{3455851264U, 24},
	{3455872000U, 22},
	{3455874048U, 22},
	{3455889408U, 20},
	{3455915264U, 24},
	{3455928320U, 22},
	{3455937280U, 24},
	{3455959040U, 19},
	{3456032768U, 19},
	{3456217856U, 24},
	{3456630784U, 14},
	{3456704512U, 21},
	{3456707584U, 22},
	{3456733952U, 24},
	{3456734208U, 22},
	{3456818944U, 24},
	{3456823296U, 23},
	{3456864768U, 24},
	{3456886784U, 21},
	{3457024000U, 16},
	{3457030144U, 21},
	{3457038592U, 24},
	{3457045760U, 24},
	{3457048832U, 24},
	{3457049856U, 24},
	{3457050880U, 24},
	{3457056000U, 24},
	{3457061376U, 24},
	{3457061632U, 24},
	{3457069056U, 24},
	{3457075712U, 24},
	{3457082368U, 24},
	{3457084928U, 24},
	{3457085184U, 24},
	{3457085440U, 24},
	{3457085696U, 24},
	{3457087488U, 24},
	{3457087744U, 24},
	{3457092352U, 24},
	{3457097728U, 19},
	{3457103872U, 21},
	{3457114112U, 21},
	{3457116160U, 22},
	{3457117184U, 22},
	{3457118208U, 20},
	{3457128960U, 24},
	{3457155072U, 16},
	{3457163264U, 22},
	{3457189888U, 22},
	{3457192960U, 23},
	{3457204224U, 20},
	{3457220608U, 16},
	{3457235456U, 23},
	{3457278464U, 24},
	{3457286144U, 16},
	{3457294336U, 21},
	{3457310720U, 24},
	{3457314304U, 24},
	{3457318912U, 17},
	{3457351680U, 16},
	{3457362176U, 24},
	{3457371136U, 24},
	{3457371392U, 24},
	{3457376256U, 21},
	{3457376256U, 24},
	{3457383424U, 23},
	{3457383936U, 24},
	{3457384704U, 24},
	{3457384960U, 23},
	{3457388544U, 22},
	{3457417216U, 16},
	{3457444608U, 24},
	{3457482752U, 16},
	{3457548288U, 16},
	{3457695744U, 24},
	{3457696768U, 23},
	{3457705472U, 23},
	{3457775360U, 24},
	{3457791488U, 24},
	{3457835520U, 23},
	{3457842176U, 22},
	{3457851392U, 21},
	{3457859584U, 24},
	{3457862400U, 24},
	{3457867776U, 21},
	{3457900544U, 23},
	{3457902592U, 24},
	{3457906176U, 23},
	{3457907712U, 24},
	{3457908224U, 24},
	{3457931008U, 24},
	{3457931264U, 24},
	{3457949696U, 19},
	{3457967616U, 24},
	{3457969408U, 24},
	{3457980672U, 24},
	{3458009600U, 24},
	{3458023424U, 21},
	{3458029568U, 21},
	{3458056192U, 22},
	{3458057216U, 23},
	{3458064384U, 20},
	{3458080256U, 24},
	{3458080768U, 21},
	{3458084864U, 21},
	{3458109440U, 22},
	{3458152960U, 23},
	{3458153472U, 23},
	{3458156032U, 23},
	{3458157824U, 24},
	{3458160640U, 24},
	{3458160896U, 24},
	{3458161152U, 24},
	{3458161408U, 24},
	{3458161664U, 24},
	{3458161920U, 24},
	{3458162176U, 24},
	{3458162432U, 24},
	{3458183680U, 24},
	{3458192384U, 24},
	{3458192640U, 24},
	{3458194176U, 24},
	{3458199552U, 23},
	{3458212352U, 24},
	{3458216448U, 23},
	{3458538496U, 24},
	{3458538752U, 24},
	{3458539008U, 24},
	{3458539264U, 24},
	{3458563584U, 24},
	{3458566656U, 24},
	{3458566912U, 24},
	{3458568704U, 24},
	{3458570496U, 24},
	{3458571776U, 24},
	{3458572032U, 24},
	{3458573312U, 24},
	{3458578688U, 24},
	{3458578944U, 24},
	{3458579712U, 24},
	{3458580224U, 24},
	{3458582272U, 24},
	{3458582528U, 24},
	{3458583808U, 24},
	{3458584064U, 24},
	{3458585856U, 24},
	{3458606848U, 24},
	{3458622976U, 24},
	{3458626304U, 24},
	{3458626816U, 24},
	{3458628608U, 24},
	{3458641408U, 24},
	{3458657280U, 24},
	{3458658048U, 24},
	{3458674688U, 21},
	{3458679040U, 24},
	{3458679552U, 24},
	{3458679808U, 24},
	{3458690048U, 24},
	{3458690560U, 24},
	{3458690816U, 24},
	{3458692096U, 23},
	{3458695168U, 23},
	{3458711552U, 21},
	{3458711552U, 22},
	{3458713600U, 23},
	{3458714112U, 24},
	{3458714368U, 24},
	{3458714880U, 24},
	{3458715136U, 24},
	{3458715392U, 24},
	{3458715648U, 24},
	{3458715904U, 24},
	{3458736128U, 19},
	{3458738176U, 21},
	{3458740224U, 24},
	{3458744320U, 19},
	{3458748160U, 24},
	{3458752512U, 19},
	{3458777088U, 19},
	{3458793472U, 26},
	{3458793536U, 27},
	{3458793568U, 27},
	{3458793632U, 27},
	{3458793704U, 29},
	{3458793712U, 29},
	{3458793728U, 28},
	{3458793744U, 28},
	{3458793760U, 30},
	{3458793768U, 29},
	{3458793792U, 26},
	{3458793856U, 26},
	{3458793920U, 28},
	{3458793936U, 28},
	{3458793952U, 27},
	{3458794784U, 27},
	{3458794856U, 29},
	{3458795136U, 27},
	{3458795272U, 30},
	{3458795296U, 29},
	{3458795304U, 29},
	{3458795360U, 27},
	{3458795392U, 27},
	{3458795440U, 28},
	{3458795456U, 27},
	{3458795488U, 30},
	{3458795496U, 29},
	{3458795504U, 28},
	{3458795544U, 30},
	{3458795584U, 26},
	{3458796040U, 30},
	{3458796192U, 28},
	{3458796544U, 28},
	{3458796676U, 30},
	{3458796684U, 30},
	{3458796736U, 29},
	{3458796748U, 30},
	{3458796752U, 28},
	{3458796768U, 27},
	{3458797624U, 30},
	{3458797628U, 30},
	{3458797648U, 29},
	{3458797656U, 29},
	{3458797760U, 27},
	{3458797816U, 30},
	{3458798592U, 24},
	{3458799616U, 26},
	{3458799712U, 27},
	{3458799744U, 26},
	{3458799808U, 26},
	{3458800896U, 24},
	{3458801152U, 24},
	{3458801440U, 27},
	{3458801472U, 27},
	{3458801664U, 19},
	{3458891776U, 24},
	{3458936832U, 20},
	{3458973696U, 19},
	{3458985984U, 20},
	{3459300672U, 28},
	{3459332608U, 23},
	{3459332608U, 24},
	{3459332864U, 24},
	{3459337984U, 24},
	{3459356160U, 24},
	{3459383296U, 16},
	{3459429888U, 24},
	{3459514368U, 16},
	{3459521792U, 24},
	{3459531776U, 23},
	{3459533824U, 24},
	{3459548160U, 24},
	{3459550208U, 23},
	{3459552768U, 23},
	{3459579904U, 22},
	{3459588096U, 21},
	{3459613696U, 24},
	{3459629056U, 21},
	{3459645440U, 18},
	{3459709952U, 23},
	{3459710976U, 18},
	{3459727360U, 20},
	{3459768320U, 19},
	{3459772160U, 24},
	{3459809280U, 17},
	{3459848208U, 28},
	{3459848256U, 27},
	{3459850848U, 27},
	{3459850880U, 25},
	{3459857520U, 28},
	{3459857536U, 26},
	{3459858944U, 23},
	{3459869952U, 24},
	{3459870208U, 24},
	{3459870464U, 24},
	{3459907584U, 16},
	{3459908096U, 24},
	{3459916288U, 24},
	{3459917312U, 24},
	{3459917568U, 24},
	{3459927552U, 23},
	{3459929344U, 24},
	{3459931648U, 24},
	{3459932672U, 24},
	{3459933184U, 24},
	{3459940096U, 24},
	{3459941632U, 24},
	{3459942400U, 23},
	{3459942912U, 24},
	{3459943424U, 24},
	{3459948544U, 24},
	{3459953664U, 22},
	{3459955968U, 24},
	{3459961088U, 24},
	{3459965952U, 24},
	{3459971072U, 21},
	{3459972608U, 23},
	{3460205568U, 22},
	{3460208128U, 24},
	{3460218880U, 22},
	{3460222976U, 21},
	{3460301824U, 24},
	{3460304896U, 20},
	{3460308992U, 20},
	{3460312832U, 24},
	{3460321280U, 21},
	{3460329472U, 24},
	{3460333568U, 23},
	{3460358144U, 22},
	{3460378624U, 20},
	{3460378624U, 21},
	{3460380672U, 21},
	{3460382720U, 23},
	{3460413184U, 24},
	{3460422144U, 24},
	{3460422912U, 24},
	{3460450048U, 24},
	{3460464640U, 21},
	{3460477696U, 24},
	{3460509184U, 24},
	{3460514816U, 22},
	{3460521984U, 20},
	{3460530176U, 22},
	{3460557312U, 24},
	{3460558592U, 24},
	{3460562944U, 15},
	{3460562944U, 22},
	{3460604928U, 22},
	{3460636672U, 20},
	{3460648960U, 21},
	{3460651008U, 22},
	{3460661248U, 22},
	{3460666368U, 22},
	{3460678656U, 22},
	{3460694016U, 16},
	{3460727040U, 24},
	{3460727296U, 24},
	{3460727552U, 24},
	{3460728064U, 24},
	{3460728320U, 24},
	{3460728576U, 24},
	{3460728832U, 24},
	{3460729088U, 24},
	{3460729344U, 24},
	{3460729600U, 24},
	{3460729856U, 24},
	{3460730112U, 24},
	{3460730368U, 24},
	{3460730624U, 24},
	{3460775936U, 19},
	{3460784128U, 21},
	{3460786176U, 21},
	{3460788224U, 21},
	{3460790272U, 21},
	{3460800512U, 19},
	{3460816896U, 19},
	{3460825088U, 18},
	{3460833280U, 24},
	{3460841472U, 24},
	{3460841728U, 24},
	{3460841984U, 24},
	{3460842240U, 24},
	{3460890624U, 16},
	{3460891904U, 24},
	{3460892672U, 24},
	{3460893184U, 24},
	{3460894208U, 24},
	{3460894720U, 24},
	{3460899328U, 24},
	{3460900608U, 24},
	{3460902144U, 24},
	{3460902656U, 24},
	{3460903680U, 24},
	{3460903936U, 24},
	{3460904192U, 24},
	{3460904448U, 24},
	{3460904704U, 24},
	{3460905728U, 24},
	{3460916992U, 24},
	{3460917504U, 24},
	{3460918016U, 24},
	{3460918784U, 24},
	{3460919296U, 24},
	{3460919552U, 24},
	{3460921344U, 24},
	{3460925440U, 24},
	{3460931072U, 24},
	{3460932352U, 24},
	{3460934400U, 24},
	{3460935168U, 24},
	{3460935936U, 24},
	{3460937216U, 24},
	{3460939008U, 24},
	{3460939264U, 24},
	{3460941824U, 24},
	{3460942336U, 24},
	{3460943360U, 24},
	{3460944640U, 24},
	{3460952064U, 24},
	{3460955136U, 24},
	{3460956160U, 16},
	{3460956160U, 17},
	{3460988928U, 17},
	{3461042688U, 24},
	{3461283840U, 16},
	{3461285184U, 26},
	{3461287680U, 24},
	{3461291520U, 24},
	{3461292032U, 20},
	{3461319680U, 24},
	{3461333760U, 24},
	{3461357568U, 19},
	{3461467136U, 24},
	{3461467392U, 24},
	{3461467648U, 24},
	{3461467904U, 24},
	{3461471232U, 22},
	{3461471232U, 24},
	{3461484544U, 20},
	{3461488640U, 19},
	{3461521408U, 22},
	{3461537792U, 19},
	{3461543936U, 24},
	{3461545984U, 19},
	{3461562368U, 19},
	{3461568256U, 24},
	{3461586944U, 19},
	{3461656576U, 20},
	{3461738496U, 24},
	{3461742592U, 16},
	{3461873664U, 13},
	{3462179840U, 24},
	{3462408192U, 23},
	{3462445056U, 24},
	{3462445312U, 24},
	{3462445568U, 24},
	{3462483968U, 20},
	{3462494720U, 24},
	{3462501376U, 22},
	{3462528512U, 24},
	{3462537216U, 24},
	{3462537472U, 24},
	{3462541312U, 21},
	{3462549504U, 23},
	{3462573056U, 23},
	{3462574848U, 24},
	{3462586624U, 24},
	{3462588416U, 23},
	{3462589952U, 24},
	{3462592000U, 24},
	{3462602752U, 24},
	{3462605824U, 22},
	{3462606848U, 21},
	{3462636800U, 24},
	{3462640128U, 24},
	{3462642176U, 23},
	{3462646016U, 24},
	{3462661632U, 24},
	{3462661888U, 24},
	{3462662656U, 23},
	{3462665728U, 23},
	{3462674432U, 21},
	{3462703104U, 23},
	{3462705920U, 24},
	{3462724096U, 23},
	{3462743040U, 23},
	{3462772224U, 24},
	{3462772480U, 24},
	{3462782976U, 22},
	{3462790144U, 22},
	{3462807552U, 19},
	{3462823680U, 24},
	{3462832384U, 24},
	{3462838784U, 23},
	{3462916864U, 24},
	{3462917120U, 22},
	{3462918144U, 20},
	{3462959104U, 24},
	{3462970368U, 22},
	{3462977536U, 21},
	{3463031808U, 24},
	{3463032064U, 24},
	{3463069696U, 18},
	{3463088640U, 24},
	{3463102464U, 20},
	{3463115264U, 24},
	{3463122944U, 21},
	{3463128576U, 23},
	{3463150592U, 22},
	{3463164928U, 24},
	{3463165184U, 24},
	{3463179008U, 24},
	{3463380992U, 16},
	{3463385600U, 24},
	{3463386880U, 24},
	{3463396096U, 24},
	{3463407104U, 24},
	{3463412224U, 24},
	{3463446528U, 19},
	{3463454720U, 19},
	{3463512064U, 19},
	{3463520256U, 19},
	{3463561984U, 24},
	{3463564032U, 24},
	{3463577600U, 22},
	{3463581696U, 24},
	{3463581952U, 24},
	{3463582208U, 24},
	{3463582720U, 22},
	{3463583744U, 21},
	{3463624448U, 24},
	{3463624704U, 23},
	{3463625216U, 24},
	{3463659520U, 19},
	{3463667712U, 20},
	{3463774208U, 16},
	{3463782400U, 21},
	{3463799808U, 22},
	{3463810048U, 24},
	{3463810304U, 24},
	{3463816704U, 24},
	{3463816960U, 24},
	{3463817216U, 24},
	{3463825152U, 24},
	{3463827968U, 24},
	{3463828480U, 22},
	{3464036352U, 16},
	{3464290304U, 19},
	{3464314880U, 19},
	{3464315648U, 24},
	{3464317952U, 24},
	{3464318208U, 24},
	{3464323072U, 19},
	{3464364032U, 24},
	{3464364288U, 24},
	{3464365312U, 24},
	{3464404992U, 21},
	{3464407040U, 21},
	{3464409088U, 21},
	{3464429568U, 19},
	{3464437760U, 19},
	{3464486912U, 19},
	{3464501248U, 22},
	{3464560640U, 23},
	{3464585472U, 24},
	{3464596224U, 24},
	{3464600576U, 22},
	{3464648192U, 24},
	{3464684288U, 24},
	{3464687616U, 24},
	{3464691712U, 17},
	{3464698368U, 23},
	{3464724480U, 19},
	{3464731136U, 23},
	{3464731648U, 23},
	{3464732672U, 19},
	{3464744960U, 20},
	{3464749056U, 21},
	{3464751104U, 21},
	{3464753152U, 20},
	{3464757376U, 25},
	{3464757504U, 24},
	{3464758016U, 24},
	{3464758272U, 24},
	{3464758656U, 27},
	{3464758688U, 27},
	{3464758720U, 26},
	{3464758784U, 25},
	{3464758912U, 29},
	{3464758928U, 28},
	{3464759336U, 29},
	{3464759360U, 26},
	{3464759424U, 26},
	{3464759808U, 24},
	{3464760192U, 25},
	{3464760384U, 27},
	{3464760448U, 29},
	{3464760456U, 29},
	{3464760464U, 28},
	{3464760480U, 27},
	{3464760576U, 24},
	{3464760832U, 24},
	{3464761088U, 27},
	{3464761120U, 27},
	{3464761200U, 30},
	{3464761204U, 30},
	{3464761208U, 29},
	{3464761296U, 28},
	{3464761312U, 28},
	{3464761344U, 23},
	{3464762112U, 24},
	{3464762880U, 23},
	{3464763648U, 24},
	{3464764160U, 25},
	{3464764304U, 30},
	{3464764308U, 30},
	{3464764312U, 29},
	{3464764336U, 28},
	{3464764352U, 27},
	{3464764384U, 27},
	{3464764420U, 30},
	{3464764424U, 29},
	{3464764432U, 30},
	{3464764512U, 27},
	{3464764544U, 28},
	{3464764656U, 28},
	{3464764672U, 26},
	{3464764736U, 27},
	{3464764824U, 30},
	{3464764828U, 30},
	{3464764904U, 29},
	{3464764928U, 25},
	{3464765088U, 28},
	{3464765104U, 29},
	{3464765112U, 30},
	{3464765120U, 27},
	{3464765152U, 28},
	{3464765376U, 27},
	{3464765408U, 27},
	{3464765968U, 28},
	{3464765984U, 27},
	{3464766044U, 30},
	{3464766048U, 29},
	{3464766056U, 30},
	{3464766060U, 30},
	{3464766064U, 28},
	{3464766080U, 27},
	{3464766144U, 27},
	{3464766176U, 28},
	{3464766192U, 29},
	{3464766208U, 24},
	{3464766464U, 24},
	{3464766720U, 24},
	{3464766976U, 24},
	{3464767232U, 24},
	{3464767488U, 24},
	{3464768000U, 27},
	{3464768048U, 29},
	{3464768056U, 30},
	{3464768060U, 30},
	{3464768120U, 30},
	{3464768124U, 30},
	{3464768128U, 26},
	{3464768192U, 27},
	{3464768224U, 27},
	{3464768256U, 24},
	{3464768512U, 26},
	{3464768576U, 27},
	{3464768608U, 27},
	{3464768640U, 29},
	{3464768656U, 28},
	{3464768672U, 27},
	{3464768768U, 25},
	{3464769024U, 26},
	{3464769088U, 28},
	{3464769104U, 29},
	{3464769120U, 27},
	{3464769152U, 27},
	{3464769184U, 27},
	{3464769280U, 24},
	{3464771584U, 30},
	{3464771588U, 30},
	{3464771592U, 30},
	{3464771596U, 30},
	{3464771600U, 28},
	{3464771616U, 27},
	{3464771696U, 28},
	{3464772160U, 27},
	{3464772232U, 30},
	{3464772236U, 30},
	{3464772240U, 29},
	{3464772248U, 29},
	{3464772256U, 27},
	{3464772320U, 27},
	{3464772352U, 25},
	{3464772480U, 25},
	{3464772608U, 22},
	{3464774144U, 27},
	{3464774176U, 27},
	{3464774272U, 26},
	{3464776448U, 28},
	{3464776464U, 28},
	{3464776512U, 30},
	{3464776528U, 29},
	{3464776544U, 27},
	{3464776608U, 28},
	{3464776632U, 29},
	{3464776640U, 26},
	{3464776960U, 25},
	{3464777216U, 24},
	{3464777472U, 24},
	{3464778752U, 22},
	{3464780288U, 23},
	{3464780800U, 26},
	{3464780896U, 28},
	{3464781056U, 24},
	{3464781824U, 24},
	{3464782080U, 24},
	{3464782336U, 24},
	{3464782592U, 24},
	{3464782880U, 27},
	{3464786122U, 27},
	{3464786136U, 30},
	{3464786140U, 30},
	{3464786144U, 30},
	{3464786148U, 30},
	{3464790784U, 25},
	{3464790912U, 27},
	{3464790944U, 27},
	{3464790976U, 26},
	{3464791040U, 24},
	{3464791296U, 24},
	{3464791552U, 24},
	{3464791808U, 24},
	{3464792320U, 24},
	{3464792704U, 26},
	{3464792832U, 25},
	{3464793640U, 29},
	{3464793664U, 27},
	{3464793824U, 27},
	{3464795872U, 30},
	{3464796160U, 24},
	{3464796416U, 24},
	{3464796928U, 26},
	{3464796992U, 27},
	{3464797024U, 28},
	{3464797040U, 28},
	{3464797056U, 25},
	{3464797184U, 24},
	{3464797440U, 24},
	{3464798208U, 28},
	{3464798224U, 30},
	{3464798240U, 27},
	{3464798272U, 27},
	{3464798336U, 26},
	{3464798464U, 24},
	{3464798720U, 24},
	{3464798976U, 24},
	{3464799232U, 25},
	{3464799424U, 26},
	{3464799744U, 24},
	{3464800000U, 24},
	{3464801280U, 23},
	{3464801792U, 24},
	{3464802304U, 23},
	{3464803072U, 24},
	{3464803328U, 24},
	{3464803968U, 25},
	{3464804352U, 26},
	{3464804448U, 28},
	{3464804608U, 24},
	{3464805184U, 28},
	{3464805200U, 30},
	{3464805204U, 30},
	{3464805208U, 29},
	{3464805216U, 28},
	{3464805240U, 29},
	{3464805248U, 26},
	{3464805312U, 27},
	{3464805344U, 27},
	{3464805408U, 28},
	{3464805424U, 28},
	{3464805440U, 27},
	{3464805472U, 28},
	{3464805488U, 29},
	{3464805504U, 25},
	{3464807104U, 27},
	{3464809856U, 25},
	{3464810752U, 24},
	{3464811264U, 24},
	{3464819728U, 28},
	{3464819744U, 27},
	{3464819776U, 26},
	{3464819856U, 28},
	{3464819936U, 29},
	{3464819968U, 29},
	{3464819984U, 30},
	{3464819992U, 29},
	{3464820008U, 29},
	{3464820016U, 28},
	{3464820032U, 27},
	{3464820064U, 28},
	{3464820096U, 27},
	{3464820128U, 27},
	{3464820160U, 27},
	{3464822028U, 30},
	{3464822308U, 30},
	{3464822312U, 30},
	{3464822316U, 30},
	{3464822320U, 30},
	{3464953856U, 16},
	{3464958208U, 24},
	{3464963328U, 24},
	{3464966656U, 24},
	{3464977664U, 24},
	{3464986880U, 24},
	{3464994304U, 24},
	{3465004288U, 24},
	{3465007616U, 24},
	{3465023488U, 20},
	{3465097216U, 21},
	{3465104896U, 24},
	{3465132032U, 21},
	{3465133312U, 24},
	{3465144576U, 24},
	{3465179136U, 24},
	{3465193472U, 21},
	{3465214976U, 22},
	{3465218048U, 21},
	{3465236480U, 20},
	{3465261056U, 20},
	{3465281536U, 20},
	{3465285632U, 20},
	{3465287936U, 24},
	{3465289728U, 20},
	{3465293824U, 20},
	{3465297920U, 20},
	{3465299456U, 23},
	{3465300480U, 24},
	{3465301504U, 24},
	{3465302016U, 20},
	{3465318400U, 20},
	{3465319424U, 24},
	{3465322240U, 24},
	{3465322496U, 20},
	{3465326592U, 20},
	{3465327872U, 24},
	{3465328640U, 24},
	{3465330688U, 20},
	{3465334784U, 20},
	{3465335808U, 23},
	{3465337344U, 24},
	{3465338880U, 20},
	{3465339904U, 23},
	{3465339904U, 24},
	{3465340672U, 24},
	{3465342976U, 20},
	{3465344000U, 22},
	{3465345024U, 23},
	{3465347072U, 20},
	{3465347584U, 24},
	{3465348096U, 24},
	{3465351168U, 20},
	{3465353216U, 22},
	{3465355264U, 20},
	{3465356288U, 24},
	{3465358080U, 24},
	{3465359104U, 24},
	{3465359360U, 20},
	{3465361408U, 24},
	{3465362688U, 24},
	{3465363456U, 20},
	{3465367552U, 20},
	{3465371648U, 20},
	{3465379840U, 18},
	{3465415680U, 23},
	{3465432320U, 24},
	{3465438208U, 24},
	{3465475072U, 24},
	{3465475328U, 24},
	{3465476352U, 24},
	{3465486848U, 24},
	{3465487360U, 24},
	{3465490688U, 24},
	{3465490944U, 24},
	{3465491200U, 24},
	{3465492224U, 24},
	{3465493248U, 24},
	{3465493504U, 24},
	{3465519104U, 24},
	{3465543680U, 14},
	{3465547776U, 21},
	{3465558016U, 21},
	{3465566208U, 24},
	{3465568256U, 19},
	{3465576448U, 18},
	{3465597952U, 22},
	{3465607168U, 21},
	{3465612544U, 24},
	{3465612800U, 24},
	{3465615360U, 22},
	{3465621504U, 20},
	{3465633792U, 21},
	{3465639168U, 24},
	{3465641984U, 19},
	{3465650176U, 21},
	{3465678848U, 20},
	{3465690112U, 24},
	{3465711360U, 24},
	{3465721856U, 21},
	{3465728000U, 21},
	{3465734400U, 24},
	{3465738240U, 21},
	{3465764608U, 24},
	{3465767424U, 23},
	{3465789440U, 18},
	{3465822208U, 22},
	{3465871360U, 20},
	{3465908224U, 22},
	{3465974784U, 23},
	{3465978880U, 24},
	{3465979136U, 24},
	{3465979392U, 24},
	{3465980160U, 24},
	{3465981440U, 23},
	{3465983744U, 24},
	{3465984768U, 24},
	{3465985024U, 23},
	{3465995264U, 24},
	{3466010624U, 23},
	{3466013696U, 24},
	{3466037248U, 22},
	{3466059776U, 19},
	{3466076672U, 24},
	{3466076928U, 24},
	{3466077184U, 22},
	{3466080768U, 23},
	{3466081280U, 23},
	{3466084096U, 24},
	{3466094592U, 22},
	{3466096384U, 24},
	{3466114048U, 23},
	{3466114048U, 24},
	{3466116096U, 22},
	{3466121216U, 20},
	{3466126080U, 24},
	{3466140160U, 24},
	{3466142720U, 22},
	{3466151936U, 21},
	{3466156032U, 21},
	{3466167296U, 22},
	{3466178560U, 20},
	{3466199552U, 24},
	{3466202880U, 24},
	{3466205184U, 21},
	{3466225152U, 24},
	{3466225920U, 24},
	{3466257920U, 24},
	{3466270208U, 24},
	{3466270720U, 21},
	{3466299392U, 23},
	{3466301440U, 20},
	{3466325248U, 24},
	{3466331136U, 24},
	{3466332160U, 24},
	{3466333184U, 24},
	{3466336256U, 23},
	{3466336768U, 24},
	{3466337024U, 24},
	{3466338304U, 24},
	{3466349568U, 24},
	{3466427136U, 24},
	{3466441728U, 24},
	{3466444800U, 23},
	{3466498304U, 24},
	{3466500352U, 24},
	{3466536960U, 22},
	{3466575872U, 18},
	{3466627072U, 21},
	{3466627072U, 24},
	{3466627328U, 24},
	{3466627584U, 24},
	{3466627840U, 24},
	{3466628096U, 24},
	{3466628352U, 24},
	{3466628608U, 24},
	{3466628864U, 24},
	{3466633216U, 21},
	{3466641408U, 20},
	{3466655232U, 23},
	{3466655488U, 24},
	{3466659840U, 23},
	{3466676224U, 21},
	{3466680320U, 21},
	{3466698752U, 19},
	{3466722560U, 24},
	{3466726912U, 24},
	{3466734848U, 24},
	{3466735104U, 24},
	{3466746112U, 24},
	{3466746880U, 24},
	{3466751744U, 24},
	{3466752256U, 24},
	{3466753792U, 24},
	{3466755072U, 24},
	{3466788864U, 17},
	{3466788864U, 23},
	{3466792192U, 24},
	{3466797056U, 22},
	{3466799104U, 23},
	{3466800896U, 24},
	{3466804224U, 24},
	{3466804480U, 24},
	{3466807040U, 24},
	{3466808064U, 24},
	{3466808320U, 24},
	{3466809344U, 22},
	{3466811136U, 24},
	{3466811904U, 24},
	{3466817792U, 24},
	{3466818560U, 22},
	{3466819584U, 21},
	{3466821632U, 18},
	{3466821632U, 23},
	{3466822144U, 23},
	{3466824704U, 22},
	{3466827776U, 22},
	{3466836992U, 24},
	{3466838016U, 19},
	{3466951424U, 24},
	{3466971136U, 22},
	{3466985472U, 17},
	{3467018240U, 18},
	{3467021312U, 22},
	{3467025408U, 22},
	{3467034624U, 18},
	{3467035904U, 24},
	{3467040256U, 24},
	{3467040768U, 22},
	{3467116544U, 16},
	{3467117312U, 24},
	{3467119872U, 24},
	{3467126528U, 24},
	{3467141376U, 24},
	{3467164416U, 24},
	{3467171840U, 24},
	{3467172096U, 24},
	{3467172352U, 24},
	{3467172608U, 24},
	{3467172864U, 24},
	{3467173376U, 24},
	{3467173632U, 24},
	{3467173888U, 24},
	{3467174144U, 24},
	{3467174400U, 24},
	{3467174656U, 24},
	{3467174912U, 24},
	{3467237632U, 24},
	{3467237888U, 23},
	{3467241728U, 24},
	{3467242752U, 24},
	{3467306496U, 23},
	{3467316224U, 22},
	{3467316736U, 24},
	{3467367936U, 23},
	{3467444224U, 16},
	{3467446272U, 22},
	{3467447296U, 22},
	{3467449344U, 22},
	{3467451392U, 22},
	{3467621120U, 24},
	{3467640832U, 20},
	{3467644928U, 20},
	{3467649024U, 20},
	{3467653120U, 22},
	{3467654144U, 23},
	{3467654656U, 23},
	{3467655168U, 23},
	{3467655680U, 24},
	{3467655936U, 24},
	{3467656192U, 22},
	{3467657216U, 20},
	{3467661312U, 20},
	{3467665408U, 21},
	{3467667456U, 23},
	{3467667968U, 23},
	{3467668480U, 22},
	{3467669504U, 20},
	{3467689984U, 21},
	{3467692032U, 21},
	{3467694080U, 21},
	{3467696128U, 21},
	{3467909376U, 24},
	{3467919360U, 18},
	{3467935744U, 19},
	{3467943936U, 20},
	{3467960320U, 20},
	{3468067840U, 24},
	{3468071424U, 24},
	{3468072448U, 24},
	{3468072960U, 24},
	{3468074240U, 24},
	{3468075776U, 24},
	{3468076032U, 24},
	{3468081152U, 24},
	{3468086272U, 24},
	{3468094976U, 24},
	{3468115968U, 19},
	{3468148736U, 19},
	{3468151296U, 24},
	{3468156928U, 19},
	{3468161536U, 24},
	{3468165120U, 16},
	{3468169472U, 24},
	{3468170240U, 23},
	{3468193792U, 23},
	{3468230656U, 21},
	{3468361728U, 16},
	{3468384256U, 21},
	{3468398592U, 21},
	{3468519195U, 21},
	{3468532480U, 24},
	{3468566528U, 19},
	{3468581632U, 24},
	{3468591104U, 19},
	{3468594688U, 24},
	{3468607488U, 19},
	{3468616192U, 24},
	{3468640256U, 18},
	{3468656640U, 18},
	{3468660992U, 24},
	{3468661248U, 23},
	{3468662784U, 22},
	{3468663808U, 24},
	{3468664320U, 24},
	{3468665600U, 24},
	{3468665856U, 24},
	{3468666112U, 24},
	{3468666368U, 24},
	{3468666624U, 24},
	{3468668928U, 22},
	{3468669952U, 23},
	{3468670464U, 23},
	{3468671744U, 24},
	{3468754944U, 18},
	{3468836864U, 18},
	{3468853248U, 18},
	{3468869632U, 18},
	{3468886784U, 24},
	{3468887040U, 24},
	{3469016320U, 24},
	{3469016576U, 24},
	{3469022976U, 24},
	{3469027328U, 23},
	{3469033728U, 24},
	{3469036032U, 24},
	{3469036800U, 24},
	{3469037824U, 24},
	{3469043712U, 24},
	{3469047040U, 24},
	{3469048064U, 24},
	{3469053952U, 24},
	{3469057024U, 24},
	{3469065728U, 24},
	{3469066752U, 24},
	{3469072640U, 24},
	{3469072896U, 24},
	{3469077504U, 24},
	{3469078528U, 24},
	{3469081344U, 24},
	{3469082624U, 16},
	{3469279232U, 20},
	{3469283584U, 24},
	{3469283840U, 24},
	{3469284096U, 24},
	{3469284352U, 24},
	{3469287424U, 20},
	{3469312000U, 20},
	{3469323264U, 24},
	{3469323520U, 24},
	{3469323776U, 24},
	{3469328384U, 20},
	{3469351936U, 24},
	{3469361152U, 18},
	{3469393920U, 18},
	{3469410304U, 18},
	{3469431040U, 24},
	{3469454080U, 24},
	{3469475840U, 16},
	{3469613056U, 21},
	{3469697280U, 24},
	{3469698048U, 24},
	{3469702912U, 24},
	{3469703168U, 23},
	{3469703680U, 24},
	{3469739520U, 24},
	{3469754368U, 21},
	{3469760512U, 21},
	{3469776896U, 24},
	{3469780992U, 24},
	{3469781248U, 24},
	{3469785088U, 21},
	{3469798400U, 24},
	{3469798656U, 24},
	{3469798912U, 24},
	{3469799168U, 24},
	{3469799424U, 22},
	{3469800448U, 23},
	{3469828096U, 20},
	{3469832192U, 20},
	{3469857280U, 24},
	{3469861120U, 24},
	{3469875712U, 24},
	{3469875968U, 24},
	{3469876224U, 24},
	{3469876480U, 24},
	{3469876736U, 24},
	{3469885440U, 19},
	{3469959168U, 20},
	{3469963264U, 21},
	{3469965312U, 24},
	{3469965568U, 24},
	{3469965824U, 24},
	{3469967360U, 19},
	{3469975552U, 19},
	{3470082048U, 18},
	{3470098432U, 18},
	{3470114816U, 18},
	{3470114816U, 19},
	{3470119168U, 24},
	{3470119424U, 24},
	{3470123008U, 19},
	{3470129920U, 24},
	{3470130176U, 24},
	{3470131200U, 15},
	{3470146048U, 24},
	{3470175232U, 24},
	{3470183424U, 22},
	{3470184704U, 24},
	{3470213376U, 24},
	{3470231296U, 24},
	{3470252288U, 24},
	{3470262272U, 15},
	{3470263808U, 24},
	{3470281984U, 24},
	{3470317824U, 24},
	{3470337024U, 24},
	{3470388992U, 24},
	{3470458880U, 20},
	{3470462976U, 21},
	{3470467840U, 24},
	{3470468096U, 22},
	{3470471424U, 24},
	{3470483456U, 19},
	{3470491648U, 18},
	{3470525440U, 22},
	{3470540800U, 24},
	{3470541056U, 24},
	{3470543872U, 22},
	{3470559232U, 22},
	{3470560256U, 22},
	{3470561280U, 22},
	{3470567424U, 22},
	{3470577920U, 24},
	{3470578432U, 24},
	{3470581760U, 22},
	{3470585856U, 24},
	{3470639104U, 20},
	{3470647296U, 20},
	{3470655488U, 19},
	{3470663680U, 19},
	{3470696448U, 19},
	{3470704640U, 19},
	{3470711552U, 24},
	{3470711808U, 24},
	{3470712576U, 24},
	{3470712832U, 19},
	{3470721024U, 24},
	{3470725376U, 24},
	{3470726656U, 24},
	{3470730240U, 24},
	{3470731008U, 24},
	{3470740992U, 24},
	{3470741504U, 24},
	{3470749184U, 24},
	{3470749440U, 24},
	{3470786560U, 19},
	{3470802944U, 19},
	{3470876672U, 19},
	{3471024128U, 19},
	{3471052800U, 20},
	{3471065088U, 19},
	{3471068672U, 24},
	{3471080448U, 24},
	{3471081728U, 24},
	{3471096320U, 24},
	{3471096576U, 24},
	{3471119360U, 24},
	{3471146240U, 24},
	{3471170560U, 24},
	{3471170816U, 24},
	{3471179776U, 21},
	{3471186944U, 22},
	{3471228928U, 19},
	{3471234816U, 24},
	{3471237120U, 20},
	{3471269888U, 24},
	{3471280128U, 21},
	{3471286272U, 21},
	{3471592960U, 24},
	{3471593216U, 24},
	{3471769600U, 16},
	{3471772160U, 24},
	{3471773696U, 24},
	{3471947008U, 24},
	{3471947264U, 24},
	{3472064512U, 23},
	{3472065024U, 24},
	{3472072704U, 19},
	{3472097280U, 16},
	{3472145152U, 24},
	{3472211968U, 18},
	{3472224256U, 24},
	{3472225024U, 24},
	{3472236544U, 20},
	{3472244736U, 18},
	{3472541952U, 24},
	{3472556032U, 30},
	{3472556036U, 30},
	{3472556060U, 30},
	{3472556084U, 30},
	{3472556113U, 30},
	{3472556124U, 30},
	{3472556129U, 30},
	{3472556272U, 30},
	{3472556496U, 30},
	{3472556544U, 24},
	{3472556800U, 24},
	{3472557072U, 28},
	{3472557104U, 30},
	{3472557108U, 30},
	{3472557112U, 29},
	{3472557120U, 26},
	{3472557184U, 26},
	{3472557248U, 28},
	{3472557264U, 28},
	{3472557280U, 27},
	{3472557312U, 26},
	{3472557392U, 29},
	{3472557400U, 30},
	{3472557440U, 26},
	{3472557512U, 30},
	{3472557516U, 30},
	{3472557536U, 28},
	{3472557552U, 30},
	{3472557568U, 24},
	{3472557904U, 30},
	{3472557908U, 30},
	{3472557920U, 27},
	{3472557952U, 27},
	{3472558000U, 28},
	{3472558048U, 27},
	{3472558080U, 27},
	{3472558112U, 27},
	{3472558592U, 24},
	{3472558912U, 27},
	{3472558944U, 28},
	{3472558960U, 30},
	{3472558968U, 29},
	{3472558976U, 28},
	{3472558992U, 29},
	{3472559000U, 29},
	{3472559008U, 29},
	{3472559016U, 29},
	{3472559024U, 29},
	{3472559032U, 29},
	{3472559040U, 29},
	{3472559048U, 29},
	{3472559056U, 29},
	{3472559064U, 29},
	{3472559072U, 29},
	{3472559080U, 29},
	{3472559088U, 29},
	{3472559096U, 29},
	{3472559142U, 24},
	{3472559360U, 25},
	{3472559488U, 27},
	{3472559600U, 29},
	{3472559616U, 26},
	{3472559712U, 28},
	{3472559728U, 29},
	{3472559744U, 25},
	{3472559872U, 24},
	{3472560128U, 23},
	{3472560640U, 24},
	{3472560896U, 24},
	{3472561152U, 24},
	{3472561408U, 24},
	{3472561664U, 24},
	{3472561920U, 24},
	{3472562176U, 24},
	{3472562432U, 24},
	{3472562688U, 24},
	{3472562944U, 24},
	{3472563200U, 24},
	{3472563456U, 24},
	{3472563968U, 26},
	{3472564032U, 28},
	{3472564048U, 28},
	{3472564064U, 27},
	{3472564096U, 27},
	{3472564128U, 27},
	{3472573696U, 24},
	{3472588800U, 19},
	{3472604928U, 24},
	{3472605184U, 24},
	{3472605440U, 24},
	{3472605952U, 24},
	{3472606208U, 22},
	{3472607232U, 21},
	{3472609280U, 24},
	{3472609536U, 24},
	{3472609792U, 23},
	{3472610304U, 24},
	{3472610560U, 24},
	{3472610816U, 24},
	{3472637952U, 18},
	{3472654336U, 19},
	{3472659840U, 26},
	{3472670720U, 19},
	{3472703488U, 19},
	{3472727040U, 24},
	{3472727296U, 24},
	{3472736256U, 19},
	{3472737536U, 24},
	{3472738304U, 22},
	{3472739328U, 22},
	{3472741632U, 24},
	{3472842752U, 19},
	{3472891904U, 21},
	{3472900864U, 24},
	{3472901120U, 23},
	{3472902144U, 23},
	{3472902656U, 24},
	{3472912384U, 20},
	{3472941056U, 20},
	{3472963584U, 23},
	{3472973824U, 21},
	{3472975872U, 22},
	{3472976896U, 23},
	{3472979968U, 24},
	{3472984064U, 21},
	{3472986112U, 21},
	{3472988160U, 23},
	{3473000704U, 24},
	{3473051648U, 20},
	{3473070592U, 24},
	{3473082880U, 23},
	{3473108992U, 20},
	{3473117184U, 21},
	{3473129472U, 19},
	{3473211392U, 18},
	{3473215488U, 22},
	{3473221632U, 21},
	{3473227776U, 19},
	{3473227776U, 22},
	{3473228800U, 22},
	{3473231872U, 21},
	{3473233920U, 21},
	{3473235968U, 24},
	{3473236224U, 24},
	{3473236480U, 24},
	{3473236736U, 24},
	{3473236992U, 24},
	{3473237248U, 24},
	{3473237504U, 24},
	{3473237760U, 24},
	{3473238016U, 24},
	{3473238272U, 24},
	{3473238528U, 24},
	{3473238784U, 24},
	{3473239040U, 24},
	{3473239296U, 24},
	{3473239552U, 24},
	{3473239808U, 24},
	{3473343488U, 22},
	{3473347072U, 24},
	{3473347328U, 24},
	{3473440768U, 17},
	{3473442048U, 24},
	{3473446144U, 24},
	{3473449984U, 22},
	{3473452544U, 23},
	{3473457152U, 24},
	{3473458176U, 24},
	{3473461760U, 24},
	{3473463808U, 24},
	{3473539072U, 16},
	{3473540096U, 24},
	{3473546240U, 22},
	{3473553152U, 24},
	{3473573888U, 24},
	{3473574144U, 24},
	{3473574400U, 24},
	{3473574656U, 24},
	{3473574912U, 24},
	{3473575168U, 24},
	{3473575424U, 24},
	{3473575680U, 24},
	{3473580288U, 24},
	{3473589248U, 24},
	{3473589504U, 24},
	{3473589760U, 24},
	{3473590016U, 24},
	{3473591808U, 24},
	{3473604608U, 17},
	{3473657600U, 24},
	{3473657856U, 24},
	{3473658368U, 24},
	{3473680384U, 22},
	{3473716480U, 24},
	{3473739264U, 24},
	{3473778688U, 22},
	{3473790976U, 21},
	{3473842176U, 24},
	{3473842432U, 24},
	{3473850368U, 20},
	{3473854976U, 24},
	{3473855232U, 24},
	{3473907712U, 20},
	{3473907712U, 24},
	{3473907968U, 24},
	{3473908224U, 24},
	{3473908480U, 24},
	{3473908736U, 24},
	{3473908992U, 24},
	{3473909248U, 24},
	{3473909504U, 24},
	{3473909760U, 24},
	{3473910016U, 24},
	{3473910272U, 24},
	{3473910528U, 24},
	{3473910784U, 24},
	{3473911040U, 24},
	{3473911296U, 24},
	{3473911552U, 24},
	{3473920000U, 21},
	{3473944064U, 24},
	{3473944320U, 24},
	{3473949696U, 24},
	{3473950208U, 24},
	{3473950464U, 24},
	{3473960192U, 24},
	{3474006272U, 24},
	{3474006528U, 24},
	{3474006784U, 24},
	{3474007296U, 24},
	{3474009600U, 24},
	{3474009856U, 24},
	{3474011136U, 24},
	{3474011392U, 24},
	{3474112768U, 24},
	{3474153472U, 21},
	{3474181120U, 24},
	{3474194432U, 16},
	{3474210048U, 24},
	{3474211840U, 24},
	{3474216192U, 24},
	{3474259968U, 17},
	{3474292736U, 18},
	{3474341888U, 18},
	{3474360064U, 24},
	{3474456576U, 24},
	{3474539520U, 24},
	{3474540288U, 24},
	{3474542336U, 24},
	{3474542592U, 24},
	{3474568704U, 24},
	{3474579712U, 24},
	{3474585600U, 21},
	{3474640896U, 21},
	{3474646528U, 23},
	{3474651136U, 21},
	{3474718208U, 24},
	{3474718720U, 16},
	{3474743296U, 20},
	{3474747392U, 22},
	{3474748416U, 23},
	{3474833408U, 20},
	{3474915328U, 18},
	{3474944000U, 24},
	{3474945280U, 24},
	{3474947072U, 24},
	{3474964480U, 18},
	{3474972416U, 24},
	{3474980864U, 18},
	{3474997248U, 18},
	{3475010560U, 24},
	{3475046400U, 16},
	{3475058688U, 24},
	{3475058944U, 24},
	{3475059200U, 24},
	{3475059456U, 24},
	{3475060480U, 24},
	{3475072512U, 24},
	{3475075072U, 24},
	{3475075328U, 24},
	{3475075584U, 24},
	{3475101696U, 22},
	{3475251200U, 19},
	{3475259392U, 19},
	{3475267584U, 19},
	{3475294720U, 23},
	{3475296768U, 23},
	{3475297792U, 23},
	{3475299072U, 24},
	{3475299328U, 24},
	{3475304448U, 23},
	{3475305984U, 23},
	{3475306496U, 23},
	{3475307008U, 23},
	{3475317248U, 24},
	{3475400192U, 24},
	{3475406848U, 17},
	{3475506432U, 24},
	{3475506688U, 24},
	{3475517440U, 20},
	{3475558400U, 22},
	{3475607552U, 20},
	{3475623936U, 20},
	{3475636224U, 20},
	{3475648512U, 24},
	{3475675392U, 24},
	{3475687424U, 23},
	{3475719936U, 24},
	{3475732480U, 22},
	{3475747840U, 22},
	{3475752448U, 23},
	{3475755008U, 21},
	{3475767296U, 17},
	{3475772416U, 24},
	{3475773440U, 23},
	{3475774976U, 23},
	{3475791616U, 24},
	{3475843072U, 24},
	{3475843328U, 24},
	{3475866112U, 24},
	{3475898368U, 19},
	{3475906560U, 19},
	{3475909120U, 23},
	{3475914752U, 19},
	{3475931136U, 18},
	{3475947520U, 18},
	{3476034304U, 24},
	{3476040192U, 23},
	{3476042752U, 24},
	{3476077056U, 23},
	{3476077568U, 23},
	{3476078080U, 24},
	{3476105216U, 23},
	{3476153088U, 24},
	{3476153344U, 22},
	{3476168704U, 22},
	{3476169728U, 22},
	{3476170752U, 22},
	{3476171776U, 22},
	{3476172800U, 21},
	{3476174848U, 24},
	{3476175104U, 24},
	{3476175360U, 23},
	{3476175872U, 22},
	{3476179968U, 24},
	{3476180992U, 22},
	{3476182016U, 22},
	{3476183040U, 22},
	{3476184832U, 24},
	{3476185088U, 20},
	{3476216832U, 22},
	{3476216832U, 24},
	{3476217088U, 24},
	{3476217344U, 24},
	{3476217600U, 24},
	{3476221952U, 22},
	{3476222976U, 22},
	{3476224000U, 22},
	{3476241920U, 23},
	{3476242432U, 24},
	{3476249344U, 24},
	{3476250112U, 24},
	{3476267520U, 23},
	{3476268544U, 24},
	{3476274432U, 24},
	{3476281344U, 24},
	{3476367104U, 24},
	{3476377600U, 24},
	{3476379392U, 24},
	{3476389888U, 18},
	{3476392960U, 22},
	{3476403712U, 24},
	{3476405248U, 24},
	{3476430848U, 19},
	{3476439040U, 19},
	{3476488192U, 18},
	{3476488448U, 24},
	{3476491264U, 24},
	{3476493056U, 24},
	{3476493312U, 24},
	{3476496128U, 24},
	{3476502784U, 24},
	{3476503040U, 24},
	{3476503808U, 24},
	{3476504576U, 22},
	{3476507648U, 22},
	{3476508672U, 20},
	{3476512768U, 19},
	{3476517632U, 24},
	{3476520960U, 18},
	{3476537344U, 19},
	{3476542720U, 24},
	{3476544512U, 22},
	{3476553728U, 15},
	{3476555776U, 22},
	{3476561920U, 24},
	{3476570112U, 24},
	{3476629504U, 21},
	{3476684800U, 17},
	{3477012480U, 16},
	{3477143552U, 19},
	{3477159936U, 18},
	{3477176320U, 18},
	{3477192704U, 18},
	{3477250304U, 24},
	{3477252864U, 24},
	{3477256704U, 24},
	{3477258496U, 24},
	{3477267456U, 24},
	{3477274624U, 17},
	{3477283328U, 24},
	{3477301248U, 24},
	{3477302016U, 24},
	{3477307392U, 17},
	{3477307904U, 24},
	{3477308160U, 24},
	{3477308672U, 24},
	{3477308928U, 24},
	{3477309696U, 24},
	{3477310976U, 23},
	{3477323776U, 23},
	{3477325824U, 21},
	{3477329664U, 24},
	{3477329920U, 21},
	{3477333248U, 24},
	{3477372928U, 20},
	{3477381120U, 19},
	{3477405696U, 16},
	{3477487616U, 18},
	{3477489920U, 24},
	{3477520384U, 18},
	{3477538816U, 24},
	{3477548032U, 23},
	{3477553152U, 18},
	{3477585920U, 18},
	{3477602304U, 14},
	{3477778432U, 21},
	{3477780480U, 22},
	{3477828608U, 22},
	{3477829632U, 22},
	{3477830656U, 23},
	{3477831168U, 24},
	{3477856256U, 24},
	{3477880832U, 21},
	{3477907456U, 24},
	{3477907712U, 24},
	{3477907968U, 24},
	{3477908224U, 24},
	{3477908480U, 24},
	{3477908736U, 24},
	{3477908992U, 24},
	{3477909248U, 24},
	{3477948416U, 24},
	{3477951232U, 24},
	{3477953024U, 23},
	{3477986304U, 24},
	{3477997568U, 21},
	{3478019840U, 24},
	{3478022144U, 24},
	{3478080512U, 22},
	{3478257664U, 16},
	{3478265856U, 24},
	{3478285312U, 22},
	{3478311168U, 24},
	{3478319664U, 28},
	{3478321664U, 23},
	{3478322176U, 23},
	{3478339584U, 19},
	{3478539776U, 23},
	{3478552576U, 22},
	{3478553600U, 22},
	{3478581248U, 23},
	{3478605824U, 22},
	{3478617088U, 22},
	{3478631936U, 23},
	{3478632448U, 23},
	{3478637824U, 24},
	{3478640128U, 23},
	{3478650880U, 16},
	{3478657280U, 24},
	{3478665472U, 24},
	{3478665728U, 24},
	{3478667264U, 22},
	{3478668288U, 23},
	{3478668800U, 23},
	{3478669312U, 22},
	{3478670336U, 22},
	{3478679552U, 23},
	{3478680064U, 23},
	{3478680576U, 23},
	{3478681088U, 23},
	{3478681600U, 22},
	{3478682624U, 23},
	{3478683136U, 23},
	{3478683648U, 23},
	{3478684160U, 23},
	{3478684416U, 24},
	{3478684672U, 22},
	{3478700032U, 22},
	{3478700032U, 24},
	{3478700288U, 24},
	{3478701056U, 22},
	{3478702080U, 23},
	{3478702592U, 23},
	{3478703104U, 23},
	{3478703616U, 23},
	{3478749184U, 17},
	{3478749184U, 18},
	{3478765568U, 19},
	{3478781952U, 18},
	{3478798336U, 18},
	{3478863872U, 18},
	{3478868736U, 24},
	{3478913024U, 14},
	{3478993920U, 24},
	{3479043840U, 24},
	{3479175168U, 17},
	{3479240704U, 17},
	{3479244800U, 24},
	{3479251456U, 24},
	{3479256320U, 24},
	{3479371776U, 17},
	{3479377408U, 24},
	{3479443456U, 23},
	{3479445504U, 20},
	{3479633920U, 16},
	{3479792128U, 23},
	{3479825664U, 24},
	{3479826176U, 24},
	{3479829504U, 24},
	{3479830528U, 16},
	{3479830528U, 17},
	{3479838464U, 24},
	{3479840768U, 24},
	{3479841024U, 24},
	{3479841280U, 24},
	{3479843072U, 24},
	{3479844352U, 23},
	{3479852032U, 24},
	{3479852800U, 24},
	{3479855104U, 21},
	{3479861504U, 24},
	{3479863296U, 17},
	{3479871488U, 20},
	{3479873280U, 24},
	{3480092672U, 18},
	{3480163072U, 24},
	{3480163328U, 24},
	{3480163840U, 23},
	{3480164352U, 23},
	{3480174592U, 18},
	{3480177664U, 22},
	{3480179712U, 23},
	{3480180224U, 23},
	{3480180992U, 24},
	{3480182784U, 24},
	{3480183552U, 24},
	{3480183808U, 24},
	{3480185088U, 24},
	{3480185856U, 24},
	{3480186112U, 24},
	{3480186368U, 24},
	{3480188928U, 23},
	{3480199168U, 20},
	{3480207360U, 18},
	{3480272896U, 21},
	{3480276992U, 22},
	{3480282112U, 22},
	{3480289280U, 17},
	{3480322048U, 17},
	{3480322304U, 24},
	{3480322560U, 24},
	{3480323584U, 24},
	{3480325120U, 24},
	{3480325376U, 24},
	{3480332032U, 24},
	{3480332288U, 22},
	{3480340736U, 24},
	{3480346112U, 24},
	{3480391424U, 24},
	{3480406528U, 24},
	{3480409088U, 24},
	{3480420352U, 18},
	{3480551424U, 16},
	{3480559872U, 24},
	{3480562176U, 24},
	{3480568320U, 24},
	{3480571904U, 24},
	{3480578560U, 24},
	{3480592896U, 24},
	{3480605184U, 24},
	{3480611328U, 24},
	{3480614400U, 24},
	{3480755200U, 22},
	{3480775936U, 24},
	{3480798720U, 23},
	{3480799232U, 24},
	{3480887296U, 24},
	{3480947968U, 24},
	{3480995840U, 21},
	{3481000704U, 24},
	{3481029376U, 24},
	{3481032960U, 24},
	{3481033216U, 24},
	{3481039360U, 24},
	{3481039616U, 24},
	{3481047040U, 22},
	{3481053952U, 24},
	{3481054208U, 22},
	{3481055232U, 23},
	{3481165824U, 19},
	{3481166080U, 24},
	{3481206784U, 16},
	{3481212928U, 22},
	{3481224448U, 24},
	{3481231360U, 24},
	{3481231616U, 24},
	{3481231872U, 24},
	{3481232128U, 24},
	{3481232384U, 24},
	{3481232640U, 24},
	{3481232896U, 24},
	{3481233152U, 24},
	{3481233408U, 24},
	{3481233664U, 24},
	{3481233920U, 24},
	{3481234176U, 24},
	{3481234432U, 24},
	{3481234688U, 24},
	{3481234944U, 24},
	{3481235200U, 24},
	{3481235712U, 24},
	{3481236480U, 24},
	{3481237504U, 21},
	{3481239552U, 24},
	{3481241344U, 24},
	{3481242112U, 24},
	{3481245440U, 24},
	{3481245696U, 24},
	{3481254912U, 22},
	{3481257984U, 23},
	{3481260544U, 24},
	{3481260800U, 24},
	{3481264128U, 22},
	{3481265920U, 24},
	{3481267968U, 24},
	{3481272320U, 14},
	{3481543424U, 24},
	{3481543936U, 24},
	{3481544192U, 24},
	{3481550848U, 22},
	{3481552896U, 24},
	{3481553152U, 24},
	{3481555200U, 24},
	{3481555456U, 24},
	{3481557248U, 24},
	{3481559552U, 24},
	{3481559808U, 24},
	{3481560064U, 24},
	{3481560576U, 24},
	{3481561600U, 24},
	{3481569280U, 22},
	{3481571328U, 22},
	{3481573376U, 22},
	{3481574400U, 22},
	{3481574656U, 24},
	{3481576448U, 22},
	{3481577472U, 22},
	{3481592320U, 24},
	{3481592576U, 24},
	{3481592832U, 22},
	{3481594880U, 24},
	{3481595136U, 24},
	{3481595392U, 24},
	{3481595648U, 24},
	{3481597952U, 22},
	{3481599744U, 24},
	{3481622272U, 24},
	{3481623808U, 24},
	{3481630976U, 24},
	{3481631232U, 24},
	{3481636096U, 24},
	{3481636352U, 24},
	{3481638912U, 24},
	{3481639168U, 24},
	{3481645824U, 24},
	{3481647616U, 24},
	{3481648896U, 24},
	{3481652224U, 24},
	{3481654016U, 24},
	{3481657344U, 24},
	{3481657600U, 24},
	{3481657856U, 24},
	{3481658112U, 24},
	{3481658368U, 24},
	{3481658624U, 24},
	{3481658880U, 24},
	{3481660672U, 24},
	{3481660928U, 24},
	{3481661184U, 24},
	{3481747456U, 18},
	{3481829376U, 19},
	{3481840128U, 25},
	{3481841408U, 24},
	{3481843968U, 24},
	{3481862144U, 16},
	{3481862144U, 20},
	{3481886720U, 22},
	{3481888512U, 24},
	{3481907200U, 21},
	{3481909248U, 22},
	{3481910784U, 23},
	{3481931776U, 22},
	{3481932800U, 23},
	{3481933312U, 24},
	{3481935872U, 24},
	{3481936128U, 28},
	{3481936144U, 29},
	{3481936152U, 29},
	{3481936192U, 27},
	{3481936336U, 29},
	{3481936348U, 30},
	{3481936384U, 29},
	{3481936400U, 29},
	{3481936416U, 27},
	{3481936448U, 26},
	{3481936512U, 25},
	{3481936656U, 29},
	{3481936664U, 29},
	{3481936696U, 29},
	{3481936896U, 28},
	{3481936960U, 26},
	{3481937152U, 24},
	{3481937664U, 25},
	{3481937792U, 26},
	{3481937856U, 27},
	{3481937920U, 26},
	{3481937984U, 26},
	{3481938048U, 26},
	{3481938112U, 26},
	{3481938176U, 26},
	{3481938304U, 25},
	{3481953184U, 27},
	{3481968192U, 27},
	{3481968256U, 28},
	{3481968272U, 28},
	{3481968320U, 27},
	{3481973360U, 28},
	{3481976084U, 30},
	{3481991680U, 23},
	{3481992192U, 23},
	{3481992704U, 24},
	{3482058752U, 15},
	{3482060800U, 24},
	{3482066432U, 23},
	{3482075648U, 24},
	{3482079232U, 24},
	{3482094080U, 24},
	{3482096640U, 24},
	{3482096896U, 24},
	{3482107648U, 24},
	{3482116096U, 21},
	{3482120192U, 24},
	{3482120448U, 24},
	{3482148608U, 24},
	{3482169344U, 23},
	{3482169856U, 24},
	{3482320896U, 16},
	{3482320896U, 17},
	{3482353664U, 17},
	{3482632192U, 19},
	{3482652160U, 24},
	{3482660608U, 24},
	{3482669312U, 24},
	{3482677504U, 24},
	{3482678016U, 24},
	{3482707456U, 23},
	{3482714112U, 17},
	{3482715392U, 24},
	{3482716160U, 23},
	{3482717184U, 23},
	{3482717696U, 24},
	{3482718208U, 23},
	{3482719232U, 23},
	{3482719744U, 24},
	{3482724352U, 23},
	{3482724864U, 24},
	{3482725120U, 24},
	{3482725376U, 24},
	{3482725632U, 24},
	{3482725888U, 24},
	{3482726400U, 20},
	{3482737664U, 22},
	{3482746880U, 19},
	{3482779648U, 16},
	{3482817024U, 24},
	{3482817280U, 24},
	{3482818560U, 21},
	{3482820608U, 21},
	{3482861568U, 18},
	{3482890240U, 24},
	{3482943488U, 18},
	{3482959872U, 18},
	{3482976256U, 18},
	{3483033600U, 19},
	{3483033600U, 24},
	{3483041792U, 16},
	{3483041792U, 17},
	{3483074560U, 17},
	{3483077632U, 22},
	{3483084800U, 23},
	{3483085312U, 24},
	{3483140096U, 17},
	{3483177728U, 24},
	{3483177984U, 24},
	{3483287552U, 18},
	{3483303936U, 18},
	{3483353088U, 18},
	{3483369472U, 17},
	{3483402240U, 18},
	{3483418624U, 19},
	{3483426816U, 19},
	{3483533312U, 24},
	{3483533568U, 24},
	{3483535616U, 24},
	{3483535872U, 24},
	{3483536384U, 24},
	{3483697152U, 16},
	{3483836416U, 21},
	{3483861504U, 23},
	{3483863040U, 24},
	{3483893760U, 16},
	{3483895808U, 24},
	{3483896576U, 24},
	{3483926528U, 19},
	{3483945216U, 24},
	{3483945472U, 24},
	{3484041216U, 18},
	{3484057600U, 18},
	{3484059136U, 23},
	{3484059648U, 23},
	{3484106752U, 18},
	{3484131328U, 20},
	{3484135424U, 20},
	{3484155904U, 16},
	{3484254208U, 20},
	{3484278784U, 24},
	{3484280064U, 24},
	{3484280320U, 24},
	{3484286976U, 17},
	{3484288512U, 24},
	{3484304640U, 24},
	{3484305408U, 24},
	{3484313344U, 24},
	{3484319744U, 18},
	{3484320000U, 24},
	{3484321536U, 24},
	{3484322048U, 24},
	{3484322304U, 24},
	{3484322816U, 24},
	{3484323328U, 24},
	{3484323584U, 24},
	{3484327168U, 24},
	{3484331776U, 24},
	{3484332288U, 24},
	{3484332544U, 24},
	{3484336128U, 18},
	{3484338432U, 24},
	{3484353536U, 24},
	{3484387840U, 23},
	{3484388352U, 23},
	{3484392704U, 24},
	{3484403712U, 23},
	{3484406016U, 24},
	{3484406528U, 24},
	{3484406784U, 24},
	{3484407040U, 24},
	{3484407296U, 23},
	{3484407808U, 22},
	{3484408832U, 23},
	{3484418048U, 22},
	{3484483584U, 17},
	{3484559872U, 23},
	{3484565504U, 19},
	{3484566272U, 24},
	{3484566528U, 24},
	{3484566784U, 24},
	{3484570112U, 24},
	{3484570368U, 24},
	{3484570624U, 24},
	{3484570880U, 24},
	{3484571136U, 24},
	{3484571392U, 24},
	{3484571648U, 24},
	{3484571904U, 24},
	{3484572160U, 24},
	{3484631296U, 24},
	{3484631552U, 24},
	{3484631808U, 24},
	{3484632064U, 24},
	{3484632320U, 24},
	{3484632576U, 24},
	{3484632832U, 24},
	{3484633088U, 24},
	{3484633344U, 24},
	{3484633600U, 24},
	{3484633856U, 24},
	{3484634112U, 24},
	{3484634368U, 24},
	{3484634624U, 24},
	{3484634880U, 24},
	{3484635136U, 24},
	{3484635392U, 24},
	{3484635648U, 24},
	{3484635904U, 24},
	{3484636160U, 24},
	{3484636416U, 24},
	{3484636672U, 24},
	{3484636928U, 24},
	{3484637184U, 24},
	{3484637440U, 24},
	{3484637696U, 24},
	{3484637952U, 24},
	{3484638208U, 24},
	{3484638464U, 24},
	{3484638720U, 24},
	{3484638976U, 24},
	{3484639232U, 20},
	{3484639232U, 24},
	{3484663808U, 19},
	{3484672000U, 20},
	{3484712960U, 19},
	{3484721152U, 19},
	{3484729344U, 18},
	{3484794880U, 18},
	{3484837120U, 24},
	{3484837632U, 24},
	{3484840448U, 24},
	{3484840960U, 24},
	{3484841472U, 24},
	{3484841728U, 24},
	{3484841984U, 24},
	{3484842752U, 24},
	{3484852224U, 19},
	{3484860416U, 24},
	{3484864256U, 24},
	{3484868608U, 19},
	{3484876800U, 19},
	{3484901376U, 20},
	{3484906496U, 23},
	{3484906496U, 24},
	{3484906752U, 24},
	{3484942336U, 14},
	{3485204480U, 19},
	{3485253632U, 19},
	{3485286400U, 19},
	{3485319168U, 19},
	{3485368320U, 19},
	{3485372160U, 24},
	{3485372416U, 24},
	{3485372672U, 24},
	{3485372928U, 24},
	{3485373184U, 24},
	{3485433856U, 19},
	{3485483008U, 18},
	{3485499392U, 18},
	{3485511680U, 20},
	{3485515776U, 19},
	{3485540352U, 22},
	{3485549568U, 24},
	{3485550592U, 23},
	{3485552128U, 23},
	{3485560320U, 24},
	{3485562112U, 24},
	{3485577984U, 24},
	{3485586176U, 24},
	{3485590528U, 23},
	{3485590528U, 24},
	{3485728768U, 17},
	{3485735936U, 24},
	{3485749504U, 24},
	{3485750272U, 24},
	{3485750784U, 24},
	{3485761536U, 17},
	{3485827072U, 17},
	{3485862656U, 24},
	{3485862912U, 23},
	{3485863424U, 24},
	{3485863936U, 22},
	{3485865216U, 24},
	{3485865472U, 23},
	{3485870080U, 22},
	{3485871104U, 23},
	{3485892608U, 17},
	{3485898752U, 22},
	{3485900544U, 24},
	{3485911808U, 24},
	{3485912064U, 24},
	{3485916160U, 23},
	{3485916672U, 23},
	{3485917696U, 24},
	{3485918208U, 22},
	{3485924096U, 24},
	{3485924608U, 24},
	{3485925376U, 17},
	{3485932544U, 24},
	{3485957632U, 24},
	{3485958144U, 18},
	{3485975040U, 23},
	{3485975552U, 23},
	{3485976576U, 22},
	{3485977600U, 22},
	{3485978624U, 20},
	{3485982720U, 20},
	{3485982720U, 22},
	{3485983744U, 22},
	{3485986816U, 21},
	{3485989888U, 23},
	{3485990400U, 23},
	{3486007296U, 19},
	{3486072064U, 24},
	{3486072320U, 24},
	{3486089216U, 18},
	{3486121984U, 17},
	{3486255104U, 21},
	{3486296064U, 24},
	{3486296320U, 24},
	{3486296576U, 24},
	{3486302208U, 20},
	{3486307840U, 24},
	{3486384128U, 17},
	{3486449664U, 18},
	{3486482432U, 18},
	{3486515200U, 16},
	{3486523392U, 24},
	{3486582784U, 24},
	{3486583040U, 24},
	{3486585088U, 24},
	{3486603264U, 24},
	{3486605312U, 24},
	{3486605824U, 24},
	{3486627072U, 24},
	{3486627328U, 24},
	{3486644736U, 24},
	{3486711808U, 16},
	{3486712064U, 24},
	{3486712320U, 24},
	{3486712832U, 24},
	{3486716928U, 24},
	{3486717440U, 23},
	{3486719232U, 24},
	{3486720768U, 24},
	{3486721024U, 24},
	{3486732032U, 24},
	{3486732288U, 20},
	{3486738944U, 24},
	{3486739200U, 24},
	{3486750208U, 24},
	{3486750720U, 24},
	{3486752768U, 24},
	{3486759936U, 24},
	{3486769920U, 24},
	{3486770176U, 23},
	{3486770688U, 24},
	{3486774016U, 24},
	{3486775296U, 24},
	{3486778112U, 24},
	{3486806016U, 21},
	{3486820608U, 24},
	{3486821376U, 22},
	{3486838784U, 24},
	{3486848512U, 23},
	{3486849024U, 21},
	{3486851072U, 23},
	{3486883840U, 20},
	{3486905856U, 24},
	{3486923776U, 23},
	{3486957568U, 22},
	{3486988800U, 23},
	{3487016960U, 21},
	{3487034368U, 23},
	{3487105024U, 16},
	{3487182336U, 24},
	{3487219712U, 20},
	{3487223808U, 20},
	{3487227904U, 20},
	{3487232000U, 20},
	{3487301632U, 14},
	{3487372800U, 23},
	{3487437312U, 23},
	{3487439872U, 24},
	{3487453952U, 24},
	{3487475968U, 24},
	{3487539200U, 24},
	{3487554560U, 24},
	{3487707904U, 24},
	{3487708160U, 22},
	{3487730688U, 22},
	{3487734784U, 22},
	{3487735808U, 19},
	{3487777792U, 22},
	{3487778560U, 24},
	{3487792128U, 22},
	{3487793664U, 24},
	{3487798272U, 22},
	{3487800832U, 23},
	{3487805696U, 24},
	{3487811584U, 22},
	{3487817728U, 23},
	{3487907840U, 18},
	{3487909120U, 24},
	{3487909376U, 24},
	{3487909888U, 22},
	{3487924224U, 18},
	{3487939584U, 22},
	{3487940608U, 18},
	{3487956992U, 20},
	{3487961088U, 22},
	{3487962112U, 22},
	{3487963136U, 22},
	{3487965184U, 19},
	{3487971328U, 24},
	{3487993088U, 24},
	{3487993344U, 24},
	{3487993600U, 24},
	{3487993856U, 24},
	{3487994112U, 24},
	{3487994368U, 24},
	{3487994624U, 24},
	{3487994880U, 24},
	{3487995392U, 24},
	{3487995648U, 24},
	{3487995904U, 24},
	{3487996160U, 24},
	{3487996416U, 24},
	{3487996672U, 24},
	{3487996928U, 24},
	{3487997184U, 24},
	{3487997440U, 24},
	{3487997696U, 24},
	{3487997952U, 19},
	{3488030720U, 19},
	{3488120832U, 17},
	{3488254464U, 23},
	{3488254976U, 23},
	{3488255488U, 24},
	{3488258560U, 24},
	{3488260864U, 24},
	{3488262400U, 24},
	{3488262912U, 24},
	{3488264704U, 23},
	{3488265216U, 24},
	{3488270080U, 24},
	{3488276224U, 24},
	{3488278528U, 23},
	{3488282624U, 24},
	{3488283648U, 24},
	{3488285696U, 22},
	{3488288768U, 23},
	{3488295424U, 24},
	{3488295680U, 24},
	{3488415744U, 16},
	{3488498176U, 24},
	{3488517888U, 24},
	{3488585216U, 24},
	{3488599040U, 22},
	{3488601088U, 22},
	{3488603136U, 22},
	{3488604672U, 24},
	{3488605696U, 24},
	{3488608256U, 21},
	{3488677888U, 17},
	{3488680448U, 24},
	{3488683008U, 24},
	{3488718848U, 19},
	{3488730880U, 24},
	{3488743424U, 15},
	{3488786432U, 24},
	{3488795904U, 24},
	{3488823808U, 24},
	{3488824064U, 24},
	{3488839680U, 22},
	{3488846080U, 24},
	{3488846336U, 24},
	{3488858112U, 24},
	{3488871680U, 24},
	{3488890880U, 18},
	{3488974848U, 24},
	{3488975360U, 24},
	{3489021952U, 18},
	{3489038336U, 19},
	{3489058816U, 24},
	{3489059072U, 24},
	{3489146880U, 21},
	{3489148928U, 21},
	{3489150976U, 21},
	{3489153536U, 24},
	{3489161216U, 24},
	{3489169408U, 19},
	{3489173504U, 24},
	{3489175040U, 24},
	{3489175808U, 24},
	{3489176576U, 24},
	{3489187072U, 24},
	{3489193984U, 19},
	{3489218560U, 19},
	{3489267712U, 17},
	{3489271040U, 24},
	{3489280256U, 24},
	{3489284096U, 24},
	{3489286656U, 24},
	{3489300480U, 17},
	{3489304320U, 24},
	{3489306624U, 24},
	{3489309440U, 24},
	{3489310208U, 24},
	{3489310976U, 24},
	{3489313024U, 24},
	{3489315072U, 24},
	{3489321216U, 24},
	{3489349632U, 18},
	{3489351680U, 24},
	{3489361920U, 23},
	{3489363968U, 23},
	{3489366016U, 18},
	{3489366016U, 21},
	{3489368064U, 23},
	{3489368576U, 23},
	{3489369088U, 22},
	{3489370112U, 23},
	{3489370624U, 23},
	{3489371136U, 23},
	{3489372160U, 23},
	{3489372160U, 24},
	{3489372672U, 23},
	{3489373184U, 23},
	{3489373696U, 23},
	{3489374464U, 24},
	{3489374720U, 23},
	{3489375232U, 24},
	{3489375744U, 24},
	{3489376000U, 24},
	{3489376256U, 24},
	{3489376512U, 24},
	{3489376768U, 24},
	{3489377024U, 24},
	{3489377536U, 24},
	{3489377792U, 23},
	{3489378560U, 24},
	{3489378816U, 23},
	{3489379584U, 24},
	{3489379840U, 23},
	{3489380608U, 24},
	{3489380864U, 23},
	{3489381120U, 24},
	{3489381376U, 22},
	{3489382144U, 24},
	{3489398784U, 16},
	{3489398784U, 22},
	{3489403904U, 23},
	{3489404416U, 24},
	{3489405952U, 24},
	{3489414144U, 22},
	{3489417216U, 21},
	{3489422848U, 24},
	{3489423104U, 24},
	{3489425408U, 23},
	{3489429760U, 24},
	{3489431296U, 24},
	{3489435648U, 22},
	{3489437696U, 21},
	{3489437696U, 24},
	{3489437952U, 24},
	{3489438208U, 24},
	{3489438464U, 24},
	{3489438720U, 24},
	{3489438976U, 24},
	{3489439232U, 24},
	{3489439488U, 24},
	{3489441024U, 24},
	{3489448960U, 22},
	{3489451008U, 24},
	{3489451264U, 24},
	{3489452032U, 21},
	{3489536512U, 23},
	{3489537024U, 24},
	{3489555456U, 24},
	{3489555712U, 24},
	{3489555968U, 24},
	{3489556224U, 24},
	{3489556480U, 21},
	{3489558528U, 20},
	{3489662976U, 24},
	{3489673216U, 24},
	{3489685504U, 21},
	{3489728256U, 24},
	{3489740800U, 23},
	{3489743616U, 24},
	{3489743872U, 24},
	{3489744128U, 24},
	{3489744384U, 24},
	{3489744640U, 24},
	{3489758208U, 23},
	{3489758976U, 24},
	{3489762304U, 22},
	{3489765376U, 21},
	{3489777664U, 21},
	{3489782784U, 22},
	{3489783808U, 24},
	{3489785856U, 24},
	{3489816576U, 20},
	{3489838592U, 24},
	{3489847296U, 22},
	{3489856000U, 23},
	{3489865728U, 24},
	{3489866240U, 23},
	{3489867264U, 24},
	{3489869056U, 24},
	{3489891840U, 24},
	{3489899520U, 22},
	{3489911808U, 24},
	{3489921024U, 22},
	{3489925120U, 23},
	{3489945600U, 21},
	{3489968896U, 24},
	{3489982464U, 21},
	{3489984512U, 20},
	{3489994752U, 21},
	{3489997312U, 24},
	{3489997568U, 24},
	{3489997824U, 24},
	{3490009088U, 21},
	{3490009088U, 24},
	{3490009344U, 24},
	{3490009600U, 24},
	{3490009856U, 24},
	{3490010112U, 24},
	{3490010368U, 24},
	{3490010624U, 24},
	{3490010880U, 24},
	{3490033664U, 20},
	{3490037760U, 24},
	{3490071552U, 22},
	{3490076416U, 24},
	{3490076928U, 24},
	{3490086912U, 19},
	{3490135552U, 24},
	{3490144256U, 21},
	{3490146048U, 24},
	{3490172928U, 22},
	{3490197760U, 24},
	{3490251264U, 23},
	{3490300416U, 24},
	{3490300928U, 24},
	{3490305024U, 24},
	{3490370560U, 22},
	{3490372608U, 22},
	{3490376448U, 24},
	{3490376704U, 23},
	{3490379264U, 23},
	{3490379776U, 23},
	{3490387968U, 21},
	{3490439168U, 24},
	{3490447360U, 19},
	{3490455552U, 19},
	{3490473984U, 24},
	{3490489856U, 24},
	{3490490368U, 22},
	{3490512896U, 19},
	{3490527232U, 21},
	{3490537472U, 19},
	{3490553088U, 24},
	{3490607104U, 20},
	{3490607104U, 24},
	{3490607360U, 24},
	{3490607616U, 24},
	{3490607872U, 24},
	{3490608128U, 24},
	{3490608384U, 24},
	{3490608640U, 24},
	{3490608896U, 24},
	{3490609152U, 24},
	{3490609408U, 24},
	{3490609664U, 24},
	{3490609920U, 24},
	{3490610176U, 24},
	{3490610432U, 24},
	{3490610688U, 24},
	{3490610944U, 24},
	{3490680832U, 20},
	{3490692096U, 22},
	{3490693120U, 19},
	{3490747904U, 24},
	{3490762752U, 21},
	{3490770944U, 20},
	{3490778112U, 23},
	{3490822400U, 24},
	{3490830080U, 24},
	{3490853888U, 24},
	{3490854144U, 24},
	{3490926848U, 24},
	{3490945792U, 24},
	{3491009536U, 24},
	{3491010304U, 24},
	{3491031040U, 24},
	{3491032064U, 24},
	{3491037184U, 21},
	{3491042816U, 24},
	{3491043328U, 23},
	{3491047936U, 24},
	{3491063808U, 21},
	{3491070464U, 23},
	{3491070976U, 22},
	{3491072000U, 23},
	{3491074048U, 20},
	{3491117568U, 24},
	{3491117824U, 24},
	{3491147776U, 24},
	{3491201024U, 23},
	{3491204096U, 22},
	{3491219456U, 21},
	{3491268224U, 25},
	{3491268608U, 23},
	{3491280896U, 21},
	{3491281152U, 24},
	{3491281408U, 24},
	{3491281664U, 24},
	{3491281920U, 24},
	{3491282176U, 24},
	{3491282432U, 24},
	{3491282688U, 24},
	{3491315712U, 19},
	{3491353600U, 24},
	{3491363584U, 24},
	{3491363840U, 23},
	{3491366912U, 21},
	{3491389952U, 24},
	{3491397632U, 20},
	{3491403776U, 24},
	{3491434496U, 23},
	{3491435520U, 22},
	{3491436544U, 22},
	{3491444736U, 24},
	{3491452416U, 24},
	{3491464192U, 24},
	{3491474432U, 22},
	{3491475456U, 22},
	{3491479040U, 24},
	{3491479296U, 24},
	{3491481600U, 24},
	{3491516416U, 21},
	{3491524608U, 24},
	{3491528960U, 24},
	{3491534080U, 24},
	{3491568640U, 22},
	{3491602432U, 23},
	{3491643392U, 21},
	{3491660032U, 24},
	{3491660800U, 22},
	{3491665920U, 21},
	{3491753984U, 21},
	{3491754496U, 24},
	{3491762176U, 24},
	{3491764736U, 23},
	{3491772416U, 21},
	{3491774720U, 24},
	{3491775232U, 24},
	{3491776512U, 21},
	{3491793408U, 24},
	{3491812096U, 24},
	{3491815936U, 24},
	{3491832832U, 24},
	{3491833344U, 24},
	{3491833600U, 24},
	{3491833856U, 24},
	{3491835904U, 23},
	{3491847168U, 24},
	{3491870208U, 24},
	{3491878912U, 22},
	{3491880960U, 20},
	{3491891200U, 21},
	{3491950848U, 24},
	{3492020224U, 15},
	{3492022528U, 24},
	{3492022784U, 24},
	{3492032768U, 24},
	{3492033024U, 23},
	{3492033792U, 24},
	{3492034048U, 23},
	{3492044800U, 23},
	{3492045568U, 24},
	{3492045824U, 24},
	{3492046336U, 24},
	{3492046592U, 24},
	{3492049664U, 24},
	{3492057088U, 23},
	{3492058112U, 24},
	{3492065280U, 24},
	{3492065536U, 24},
	{3492065792U, 24},
	{3492066048U, 24},
	{3492070144U, 24},
	{3492071424U, 21},
	{3492074496U, 22},
	{3492075776U, 24},
	{3492077568U, 24},
	{3492078080U, 24},
	{3492079104U, 24},
	{3492079360U, 24},
	{3492098304U, 24},
	{3492098560U, 24},
	{3492106240U, 23},
	{3492108288U, 23},
	{3492116480U, 22},
	{3492121088U, 23},
	{3492123648U, 22},
	{3492129792U, 24},
	{3492136960U, 24},
	{3492138752U, 24},
	{3492145152U, 24},
	{3492167680U, 19},
	{3492221952U, 22},
	{3492230144U, 22},
	{3492249600U, 19},
	{3492282368U, 17},
	{3492315136U, 19},
	{3492323328U, 20},
	{3492478976U, 16},
	{3492582912U, 24},
	{3492583168U, 24},
	{3492583424U, 24},
	{3492609024U, 24},
	{3492654080U, 22},
	{3492662528U, 24},
	{3492676608U, 24},
	{3492676864U, 24},
	{3492704768U, 24},
	{3492705024U, 24},
	{3492706816U, 24},
	{3492707072U, 24},
	{3492732928U, 24},
	{3492759552U, 21},
	{3492797440U, 22},
	{3492813312U, 24},
	{3492814912U, 26},
	{3492814976U, 25},
	{3492815360U, 24},
	{3492816896U, 24},
	{3492817920U, 27},
	{3492817984U, 30},
	{3492823296U, 26},
	{3492823360U, 28},
	{3492823376U, 28},
	{3492823392U, 28},
	{3492823408U, 28},
	{3492823424U, 28},
	{3492823456U, 28},
	{3492823472U, 28},
	{3492823520U, 29},
	{3492823528U, 29},
	{3492823536U, 28},
	{3492823808U, 24},
	{3492824320U, 28},
	{3492824344U, 29},
	{3492824576U, 24},
	{3492825504U, 29},
	{3492825516U, 30},
	{3492825520U, 28},
	{3492825536U, 26},
	{3492826368U, 26},
	{3492826560U, 27},
	{3492826592U, 28},
	{3492826616U, 29},
	{3492827392U, 26},
	{3492827456U, 26},
	{3492827584U, 27},
	{3492827624U, 29},
	{3492827632U, 29},
	{3492827640U, 29},
	{3492829184U, 24},
	{3492830976U, 24},
	{3492831232U, 23},
	{3492832000U, 24},
	{3492832256U, 29},
	{3492832264U, 29},
	{3492832272U, 28},
	{3492832288U, 28},
	{3492832304U, 28},
	{3492832320U, 28},
	{3492832336U, 29},
	{3492832344U, 29},
	{3492832352U, 28},
	{3492832384U, 26},
	{3492832768U, 27},
	{3492832832U, 28},
	{3492832848U, 28},
	{3492832864U, 28},
	{3492832896U, 27},
	{3492833024U, 24},
	{3492834560U, 24},
	{3492835072U, 24},
	{3492835328U, 24},
	{3492836288U, 26},
	{3492836608U, 24},
	{3492837104U, 30},
	{3492837108U, 30},
	{3492837112U, 30},
	{3492837116U, 30},
	{3492837120U, 27},
	{3492837152U, 28},
	{3492837184U, 26},
	{3492837312U, 27},
	{3492837344U, 27},
	{3492837888U, 25},
	{3492838400U, 24},
	{3492838928U, 28},
	{3492838944U, 28},
	{3492838960U, 29},
	{3492839016U, 29},
	{3492839316U, 30},
	{3492839320U, 29},
	{3492839344U, 28},
	{3492839360U, 27},
	{3492839416U, 29},
	{3492842496U, 22},
	{3492855096U, 29},
	{3492855104U, 28},
	{3492855120U, 28},
	{3492858880U, 24},
	{3492859968U, 28},
	{3492859984U, 28},
	{3492860008U, 29},
	{3492860016U, 28},
	{3492860032U, 26},
	{3492860672U, 24},
	{3492861440U, 24},
	{3492861696U, 25},
	{3492861824U, 26},
	{3492861952U, 24},
	{3492862208U, 24},
	{3492862464U, 26},
	{3492862528U, 27},
	{3492862592U, 27},
	{3492862648U, 29},
	{3492862656U, 27},
	{3492862704U, 29},
	{3492862712U, 29},
	{3492862720U, 24},
	{3492862976U, 24},
	{3492863232U, 24},
	{3492863488U, 24},
	{3492863744U, 25},
	{3492863936U, 26},
	{3492864000U, 27},
	{3492864096U, 27},
	{3492864512U, 24},
	{3492864768U, 26},
	{3492864848U, 28},
	{3492865376U, 27},
	{3492865416U, 30},
	{3492865420U, 30},
	{3492865456U, 28},
	{3492865792U, 25},
	{3492866008U, 30},
	{3492866664U, 30},
	{3492866668U, 30},
	{3492866704U, 29},
	{3492866736U, 29},
	{3492868096U, 24},
	{3492868416U, 26},
	{3492868552U, 29},
	{3492868864U, 24},
	{3492869632U, 24},
	{3492870640U, 28},
	{3492871168U, 24},
	{3492884480U, 24},
	{3492885504U, 24},
	{3492891392U, 24},
	{3492905472U, 24},
	{3492905792U, 28},
	{3492906064U, 28},
	{3492906176U, 26},
	{3492908256U, 28},
	{3492908544U, 24},
	{3492909056U, 24},
	{3492909376U, 27},
	{3492909408U, 27},
	{3492909440U, 28},
	{3492909456U, 28},
	{3492909648U, 28},
	{3492909824U, 24},
	{3492910144U, 27},
	{3492910316U, 30},
	{3492910320U, 29},
	{3492910400U, 26},
	{3492910480U, 28},
	{3492910848U, 24},
	{3492912128U, 22},
	{3492913152U, 27},
	{3492913328U, 28},
	{3492913344U, 27},
	{3492913376U, 29},
	{3492913384U, 29},
	{3492913392U, 28},
	{3492913472U, 28},
	{3492913488U, 29},
	{3492913496U, 30},
	{3492913504U, 27},
	{3492913664U, 25},
	{3492913824U, 27},
	{3492913856U, 26},
	{3492914176U, 24},
	{3492914944U, 25},
	{3492915168U, 27},
	{3492915512U, 29},
	{3492915520U, 29},
	{3492915528U, 29},
	{3492915536U, 28},
	{3492915680U, 27},
	{3492916480U, 24},
	{3492916996U, 30},
	{3492917008U, 28},
	{3492917088U, 28},
	{3492917104U, 30},
	{3492917108U, 30},
	{3492917136U, 29},
	{3492917184U, 27},
	{3492917216U, 27},
	{3492925952U, 27},
	{3492926016U, 29},
	{3492926080U, 28},
	{3492926144U, 27},
	{3492926176U, 27},
	{3492926208U, 24},
	{3492926912U, 27},
	{3492926944U, 27},
	{3492929968U, 28},
	{3492930304U, 24},
	{3492930848U, 28},
	{3492930864U, 29},
	{3492930876U, 30},
	{3492930880U, 27},
	{3492930960U, 28},
	{3492930992U, 28},
	{3492931072U, 24},
	{3492931584U, 24},
	{3492932928U, 27},
	{3492932960U, 27},
	{3492933248U, 27},
	{3492933376U, 26},
	{3492933440U, 28},
	{3492933504U, 27},
	{3492933600U, 28},
	{3492938240U, 24},
	{3492939008U, 28},
	{3492939076U, 30},
	{3492941472U, 28},
	{3492942784U, 26},
	{3492944896U, 24},
	{3492945152U, 24},
	{3492945920U, 24},
	{3492951552U, 24},
	{3492951808U, 24},
	{3492955136U, 27},
	{3492955264U, 25},
	{3492958272U, 27},
	{3492958304U, 27},
	{3492958368U, 29},
	{3492958380U, 30},
	{3492958392U, 29},
	{3492958464U, 24},
	{3492958976U, 24},
	{3492959248U, 28},
	{3492959272U, 29},
	{3492959328U, 28},
	{3492959360U, 26},
	{3492960320U, 26},
	{3492960384U, 27},
	{3492960576U, 26},
	{3492960768U, 24},
	{3492962560U, 24},
	{3492962880U, 27},
	{3492962928U, 28},
	{3492962988U, 30},
	{3492962992U, 28},
	{3492963072U, 26},
	{3492963144U, 29},
	{3492963160U, 29},
	{3492963168U, 27},
	{3492963216U, 29},
	{3492963224U, 29},
	{3492963236U, 30},
	{3492963240U, 29},
	{3492963248U, 29},
	{3492963256U, 29},
	{3492963264U, 26},
	{3492963328U, 24},
	{3492963584U, 25},
	{3492963712U, 25},
	{3492963840U, 26},
	{3492963904U, 27},
	{3492963936U, 28},
	{3492964032U, 26},
	{3492964096U, 24},
	{3492970240U, 24},
	{3492971264U, 28},
	{3492971280U, 28},
	{3492971296U, 27},
	{3492971328U, 27},
	{3492971360U, 28},
	{3492971376U, 28},
	{3492971392U, 26},
	{3492971456U, 26},
	{3492972160U, 26},
	{3492972272U, 28},
	{3492972576U, 27},
	{3492973568U, 22},
	{3492974624U, 27},
	{3492974656U, 26},
	{3492974848U, 29},
	{3492974856U, 29},
	{3492975360U, 24},
	{3492975616U, 28},
	{3492975648U, 29},
	{3492975656U, 29},
	{3492975664U, 28},
	{3492975744U, 26},
	{3492975808U, 27},
	{3492975872U, 24},
	{3492976144U, 28},
	{3492976192U, 26},
	{3492976352U, 27},
	{3492976384U, 24},
	{3492976640U, 23},
	{3492977408U, 24},
	{3492977664U, 24},
	{3492977920U, 28},
	{3492977936U, 29},
	{3492977944U, 29},
	{3492977984U, 26},
	{3492978080U, 28},
	{3492978096U, 28},
	{3492978112U, 26},
	{3492978432U, 24},
	{3492978688U, 29},
	{3492978697U, 29},
	{3492978720U, 27},
	{3492978752U, 26},
	{3492979456U, 27},
	{3492979584U, 27},
	{3492979616U, 27},
	{3492979648U, 28},
	{3492979664U, 28},
	{3492979696U, 30},
	{3492979700U, 30},
	{3492979704U, 30},
	{3492979708U, 30},
	{3492979712U, 22},
	{3492979712U, 24},
	{3492979968U, 24},
	{3492980224U, 23},
	{3492980736U, 24},
	{3492981112U, 29},
	{3492981120U, 29},
	{3492981174U, 29},
	{3492981248U, 24},
	{3492981504U, 24},
	{3492982016U, 26},
	{3492982144U, 29},
	{3492982168U, 29},
	{3492982208U, 26},
	{3492982784U, 25},
	{3492982912U, 25},
	{3492983040U, 24},
	{3492983296U, 28},
	{3492983328U, 28},
	{3492983360U, 26},
	{3492983440U, 28},
	{3492983456U, 27},
	{3492983488U, 30},
	{3492983492U, 30},
	{3492983496U, 29},
	{3492983520U, 29},
	{3492983528U, 29},
	{3492983536U, 28},
	{3492984064U, 24},
	{3492984728U, 29},
	{3492984736U, 29},
	{3492984752U, 28},
	{3492984808U, 29},
	{3492984824U, 30},
	{3492984832U, 24},
	{3492985088U, 24},
	{3492985600U, 24},
	{3492985856U, 25},
	{3492985984U, 27},
	{3492986016U, 27},
	{3492986048U, 27},
	{3492986104U, 29},
	{3492986112U, 27},
	{3492986144U, 27},
	{3492986208U, 28},
	{3492986240U, 26},
	{3492986304U, 28},
	{3492986320U, 29},
	{3492986360U, 29},
	{3492986368U, 24},
	{3493019872U, 28},
	{3493020208U, 30},
	{3493020296U, 30},
	{3493020300U, 30},
	{3493020316U, 30},
	{3493020320U, 30},
	{3493020336U, 29},
	{3493020352U, 28},
	{3493020448U, 30},
	{3493020452U, 30},
	{3493020456U, 30},
	{3493020460U, 30},
	{3493020640U, 27},
	{3493020672U, 22},
	{3493022144U, 26},
	{3493022528U, 28},
	{3493022544U, 28},
	{3493022560U, 28},
	{3493022584U, 29},
	{3493022592U, 26},
	{3493022720U, 24},
	{3493022976U, 24},
	{3493025144U, 29},
	{3493025184U, 27},
	{3493025664U, 26},
	{3493025764U, 30},
	{3493025768U, 29},
	{3493025776U, 29},
	{3493025784U, 29},
	{3493025792U, 24},
	{3493026048U, 24},
	{3493026304U, 26},
	{3493026816U, 24},
	{3493027624U, 29},
	{3493027648U, 26},
	{3493027712U, 28},
	{3493027728U, 28},
	{3493027808U, 28},
	{3493036800U, 28},
	{3493037376U, 27},
	{3493037424U, 28},
	{3493037440U, 26},
	{3493038272U, 27},
	{3493038592U, 25},
	{3493039904U, 29},
	{3493039984U, 28},
	{3493040000U, 27},
	{3493042176U, 24},
	{3493042472U, 29},
	{3493042480U, 28},
	{3493042496U, 26},
	{3493042592U, 28},
	{3493042608U, 29},
	{3493043712U, 24},
	{3493050680U, 29},
	{3493050840U, 30},
	{3493051008U, 26},
	{3493051072U, 29},
	{3493051080U, 29},
	{3493051128U, 29},
	{3493051136U, 24},
	{3493051904U, 24},
	{3493053456U, 28},
	{3493053512U, 29},
	{3493053528U, 29},
	{3493053568U, 26},
	{3493053952U, 24},
	{3493055152U, 28},
	{3493055312U, 30},
	{3493055320U, 29},
	{3493055328U, 28},
	{3493055344U, 28},
	{3493055360U, 25},
	{3493055584U, 27},
	{3493055744U, 24},
	{3493056016U, 28},
	{3493056064U, 26},
	{3493058304U, 25},
	{3493058432U, 28},
	{3493060608U, 24},
	{3493061440U, 26},
	{3493061568U, 26},
	{3493062144U, 24},
	{3493062624U, 27},
	{3493064704U, 24},
	{3493265408U, 16},
	{3493330944U, 16},
	{3493462016U, 16},
	{3493492992U, 24},
	{3493527552U, 16},
	{3493582592U, 24},
	{3493753344U, 24},
	{3498065920U, 20},
	{3498158080U, 22},
	{3498178816U, 24},
	{3498179072U, 24},
	{3498179328U, 24},
	{3498179584U, 24},
	{3498179840U, 24},
	{3498295296U, 20},
	{3498299392U, 22},
	{3498302976U, 24},
	{3498319872U, 20},
	{3498336000U, 24},
	{3498352640U, 19},
	{3498361856U, 24},
	{3498374400U, 24},
	{3498374656U, 24},
	{3498386176U, 24},
	{3498393600U, 19},
	{3498401792U, 20},
	{3498404096U, 24},
	{3498405888U, 21},
	{3498407936U, 22},
	{3498408960U, 23},
	{3498418176U, 21},
	{3498420224U, 22},
	{3498421248U, 23},
	{3498421760U, 24},
	{3498422528U, 24},
	{3498429440U, 23},
	{3498432512U, 22},
	{3498433536U, 23},
	{3498446848U, 21},
	{3498448896U, 23},
	{3498475520U, 23},
	{3498476032U, 24},
	{3498476288U, 24},
	{3498476544U, 23},
	{3498477056U, 24},
	{3498477312U, 24},
	{3498477568U, 23},
	{3498478080U, 24},
	{3498481152U, 24},
	{3498481408U, 24},
	{3498506240U, 22},
	{3498548224U, 24},
	{3498573824U, 19},
	{3498599936U, 24},
	{3498638336U, 22},
	{3498642432U, 24},
	{3498643456U, 21},
	{3498645504U, 21},
	{3498648576U, 24},
	{3498686208U, 24},
	{3498717184U, 20},
	{3498726912U, 24},
	{3498757120U, 22},
	{3498762240U, 24},
	{3498769920U, 24},
	{3498771968U, 24},
	{3498791424U, 24},
	{3498823680U, 20},
	{3498854400U, 21},
	{3498903552U, 21},
	{3498915840U, 23},
	{3498942464U, 19},
	{3498959872U, 24},
	{3498994176U, 23},
	{3498995456U, 24},
	{3498995712U, 24},
	{3498995968U, 24},
	{3498996224U, 24},
	{3498996480U, 24},
	{3498996736U, 24},
	{3498996992U, 24},
	{3498997248U, 24},
	{3498997504U, 24},
	{3498997760U, 24},
	{3498998016U, 24},
	{3499000576U, 24},
	{3499001856U, 21},
	{3499003392U, 24},
	{3499003904U, 21},
	{3499008000U, 24},
	{3499013120U, 23},
	{3499027968U, 24},
	{3499038208U, 24},
	{3499038464U, 24},
	{3499059200U, 24},
	{3499060224U, 24},
	{3499060480U, 24},
	{3499108352U, 22},
	{3499121152U, 24},
	{3499126784U, 21},
	{3499127824U, 28},
	{3499128320U, 23},
	{3499148288U, 24},
	{3499158272U, 24},
	{3499237376U, 20},
	{3499238144U, 24},
	{3499238400U, 22},
	{3499239424U, 23},
	{3499265536U, 24},
	{3499265792U, 24},
	{3499292672U, 21},
	{3499294720U, 21},
	{3499311104U, 24},
	{3499317248U, 21},
	{3499331584U, 21},
	{3499333632U, 22},
	{3499360256U, 19},
	{3499361792U, 24},
	{3499362816U, 24},
	{3499373056U, 23},
	{3499373568U, 23},
	{3499379200U, 24},
	{3499379712U, 22},
	{3499446272U, 20},
	{3499499520U, 19},
	{3499581440U, 19},
	{3499582464U, 22},
	{3499583488U, 21},
	{3499585536U, 21},
	{3499587584U, 23},
	{3499588096U, 23},
	{3499588608U, 22},
	{3499597824U, 23},
	{3499612160U, 22},
	{3499627008U, 23},
	{3499630592U, 19},
	{3499651072U, 22},
	{3499652096U, 23},
	{3499652608U, 24},
	{3499653120U, 21},
	{3499661568U, 24},
	{3499669504U, 21},
	{3499699456U, 24},
	{3499707136U, 24},
	{3499757056U, 24},
	{3499773952U, 23},
	{3499789824U, 23},
	{3499829248U, 21},
	{3499831296U, 21},
	{3499865088U, 24},
	{3499865344U, 24},
	{3499865600U, 24},
	{3499865856U, 24},
	{3499866112U, 24},
	{3499866368U, 24},
	{3499866624U, 24},
	{3499866880U, 24},
	{3499867136U, 24},
	{3499867392U, 24},
	{3499867648U, 24},
	{3499889920U, 24},
	{3499890176U, 23},
	{3499892928U, 26},
	{3499893760U, 27},
	{3499894528U, 24},
	{3499895168U, 25},
	{3499895296U, 24},
	{3499895552U, 24},
	{3499895808U, 24},
	{3499896064U, 24},
	{3499896320U, 24},
	{3499896864U, 29},
	{3499896912U, 28},
	{3499899392U, 24},
	{3499899648U, 24},
	{3499899904U, 24},
	{3499917312U, 20},
	{3499980800U, 24},
	{3499981312U, 23},
	{3499984896U, 24},
	{3500015360U, 24},
	{3500073984U, 22},
	{3500123136U, 22},
	{3500126208U, 21},
	{3500138496U, 21},
	{3500140544U, 21},
	{3500142592U, 22},
	{3500143616U, 22},
	{3500144640U, 21},
	{3500149248U, 23},
	{3500150272U, 23},
	{3500154880U, 20},
	{3500173312U, 21},
	{3500185344U, 24},
	{3500202496U, 24},
	{3500204032U, 19},
	{3500269568U, 19},
	{3500269568U, 21},
	{3500271616U, 21},
	{3500273664U, 21},
	{3500274688U, 22},
	{3500275712U, 21},
	{3500285440U, 24},
	{3500288256U, 24},
	{3500294144U, 19},
	{3500342272U, 24},
	{3500361728U, 21},
	{3500366848U, 24},
	{3500367360U, 24},
	{3500367872U, 21},
	{3500369920U, 21},
	{3500371968U, 20},
	{3500385280U, 24},
	{3500392448U, 22},
	{3500393472U, 22},
	{3500394496U, 22},
	{3500395520U, 22},
	{3500396544U, 22},
	{3500398592U, 22},
	{3500400640U, 22},
	{3500401664U, 22},
	{3500402688U, 22},
	{3500403712U, 22},
	{3500404736U, 21},
	{3500406784U, 21},
	{3500408832U, 21},
	{3500410368U, 23},
	{3500410880U, 21},
	{3500412928U, 21},
	{3500414976U, 21},
	{3500468480U, 24},
	{3500478464U, 24},
	{3500482560U, 20},
	{3500482560U, 21},
	{3500484608U, 21},
	{3500490752U, 20},
	{3500494848U, 21},
	{3500496896U, 21},
	{3500556288U, 21},
	{3500570624U, 21},
	{3500579072U, 24},
	{3500584960U, 20},
	{3500623872U, 21},
	{3500638208U, 20},
	{3500652544U, 22},
	{3500672000U, 22},
	{3500674048U, 23},
	{3500675072U, 24},
	{3500675328U, 24},
	{3500675584U, 24},
	{3500675840U, 24},
	{3500709888U, 22},
	{3500711936U, 23},
	{3500715520U, 23},
	{3500716032U, 22},
	{3500724992U, 24},
	{3500725504U, 24},
	{3500726016U, 24},
	{3500740608U, 21},
	{3500744704U, 22},
	{3500777472U, 22},
	{3500780544U, 22},
	{3500781568U, 22},
	{3500826624U, 20},
	{3500830720U, 20},
	{3500840960U, 22},
	{3500841984U, 23},
	{3500845056U, 21},
	{3500845056U, 24},
	{3500845312U, 24},
	{3500845568U, 24},
	{3500845824U, 24},
	{3500846080U, 24},
	{3500846336U, 24},
	{3500846592U, 24},
	{3500846848U, 24},
	{3500863488U, 22},
	{3500871680U, 20},
	{3500873216U, 23},
	{3500888064U, 22},
	{3500898304U, 21},
	{3500921856U, 24},
	{3501195264U, 15},
	{3501204736U, 24},
	{3501204992U, 23},
	{3501205760U, 24},
	{3501206016U, 24},
	{3501207552U, 24},
	{3501208064U, 24},
	{3501209856U, 24},
	{3501210112U, 23},
	{3501213696U, 22},
	{3501215488U, 24},
	{3501215744U, 20},
	{3501220608U, 24},
	{3501220864U, 24},
	{3501222144U, 24},
	{3501222400U, 23},
	{3501224960U, 24},
	{3501225216U, 24},
	{3501225984U, 22},
	{3501236480U, 24},
	{3501236736U, 23},
	{3501252096U, 24},
	{3501252608U, 21},
	{3501254656U, 22},
	{3501255680U, 22},
	{3501256704U, 23},
	{3501257216U, 24},
	{3501257472U, 24},
	{3501257728U, 22},
	{3501258752U, 24},
	{3501261056U, 24},
	{3501267200U, 24},
	{3501267712U, 24},
	{3501268480U, 23},
	{3501268992U, 22},
	{3501271040U, 22},
	{3501272064U, 24},
	{3501275136U, 24},
	{3501277184U, 23},
	{3501277952U, 24},
	{3501279744U, 23},
	{3501280256U, 23},
	{3501281024U, 24},
	{3501286912U, 23},
	{3501287936U, 24},
	{3501288448U, 23},
	{3501288960U, 24},
	{3501291520U, 22},
	{3501301760U, 23},
	{3501306112U, 24},
	{3501308928U, 24},
	{3501309952U, 21},
	{3501312000U, 22},
	{3501314048U, 22},
	{3501320192U, 24},
	{3501323264U, 24},
	{3501323520U, 24},
	{3501324288U, 22},
	{3501329264U, 29},
	{3501329272U, 29},
	{3501329920U, 23},
	{3501332016U, 29},
	{3501332024U, 30},
	{3501332084U, 30},
	{3501332088U, 30},
	{3501332092U, 30},
	{3501332096U, 28},
	{3501332112U, 29},
	{3501332128U, 28},
	{3501332144U, 28},
	{3501332960U, 28},
	{3501332960U, 30},
	{3501332964U, 30},
	{3501332984U, 30},
	{3501332992U, 24},
	{3501333376U, 26},
	{3501333440U, 27},
	{3501333472U, 27},
	{3501333760U, 24},
	{3501334432U, 27},
	{3501334496U, 27},
	{3501336576U, 24},
	{3501336832U, 24},
	{3501337088U, 23},
	{3501337992U, 30},
	{3501337996U, 30},
	{3501338000U, 28},
	{3501338024U, 29},
	{3501338040U, 29},
	{3501338096U, 28},
	{3501339136U, 24},
	{3501339648U, 23},
	{3501340416U, 24},
	{3501345280U, 23},
	{3501351680U, 25},
	{3501351872U, 27},
	{3501351928U, 30},
	{3501352192U, 26},
	{3501352320U, 27},
	{3501352372U, 30},
	{3501352376U, 30},
	{3501352400U, 30},
	{3501352404U, 30},
	{3501352408U, 29},
	{3501352416U, 28},
	{3501352432U, 28},
	{3501352448U, 25},
	{3501352704U, 27},
	{3501352752U, 30},
	{3501352756U, 30},
	{3501352764U, 30},
	{3501352768U, 27},
	{3501352800U, 28},
	{3501352832U, 26},
	{3501352832U, 27},
	{3501352864U, 27},
	{3501352960U, 24},
	{3501353216U, 24},
	{3501353216U, 30},
	{3501353472U, 24},
	{3501353728U, 28},
	{3501353744U, 28},
	{3501353760U, 27},
	{3501353792U, 26},
	{3501353856U, 25},
	{3501353984U, 24},
	{3501354240U, 26},
	{3501354304U, 28},
	{3501354320U, 28},
	{3501354336U, 27},
	{3501354464U, 29},
	{3501354472U, 29},
	{3501354480U, 30},
	{3501354496U, 26},
	{3501354560U, 26},
	{3501354624U, 26},
	{3501354688U, 26},
	{3501354752U, 24},
	{3501359304U, 29},
	{3501359320U, 30},
	{3501359616U, 24},
	{3501361120U, 28},
	{3501361152U, 24},
	{3501361408U, 24},
	{3501361984U, 26},
	{3501362080U, 28},
	{3501362168U, 30},
	{3501362432U, 24},
	{3501363264U, 27},
	{3501363328U, 25},
	{3501363456U, 24},
	{3501364224U, 30},
	{3501364232U, 29},
	{3501364240U, 30},
	{3501364256U, 27},
	{3501364288U, 27},
	{3501364352U, 25},
	{3501365248U, 28},
	{3501365296U, 29},
	{3501365312U, 26},
	{3501365432U, 29},
	{3501365440U, 26},
	{3501366528U, 26},
	{3501367168U, 26},
	{3501367232U, 26},
	{3501367808U, 24},
	{3501368112U, 29},
	{3501368128U, 26},
	{3501368192U, 25},
	{3501368384U, 27},
	{3501368512U, 27},
	{3501368576U, 26},
	{3501368640U, 27},
	{3501368672U, 27},
	{3501368812U, 30},
	{3501368832U, 24},
	{3501369088U, 25},
	{3501369312U, 28},
	{3501369328U, 28},
	{3501369600U, 25},
	{3501369728U, 27},
	{3501369776U, 28},
	{3501369792U, 27},
	{3501369824U, 29},
	{3501369832U, 29},
	{3501370112U, 24},
	{3501371280U, 28},
	{3501371328U, 28},
	{3501371344U, 29},
	{3501371352U, 29},
	{3501376000U, 24},
	{3501391396U, 30},
	{3501391400U, 30},
	{3501391424U, 27},
	{3501391488U, 28},
	{3501391728U, 30},
	{3501391732U, 30},
	{3501391736U, 30},
	{3501391740U, 30},
	{3501391808U, 28},
	{3501391830U, 28},
	{3501391853U, 28},
	{3501391869U, 28},
	{3501391872U, 16},
	{3501415168U, 24},
	{3501465600U, 20},
	{3501469696U, 21},
	{3501471744U, 22},
	{3501472768U, 22},
	{3501473792U, 21},
	{3501475840U, 24},
	{3501476096U, 24},
	{3501476608U, 24},
	{3501477632U, 24},
	{3501477888U, 20},
	{3501481984U, 20},
	{3501496320U, 21},
	{3501498368U, 20},
	{3501502464U, 21},
	{3501504512U, 22},
	{3501505536U, 22},
	{3501506560U, 21},
	{3501508608U, 22},
	{3501509632U, 22},
	{3501510656U, 21},
	{3501518848U, 21},
	{3501520896U, 21},
	{3501588480U, 17},
	{3501621248U, 19},
	{3501629440U, 20},
	{3501633536U, 22},
	{3501634560U, 23},
	{3501635072U, 23},
	{3501635584U, 21},
	{3501637632U, 18},
	{3501654016U, 17},
	{3501686784U, 19},
	{3501694976U, 19},
	{3501703168U, 19},
	{3501711360U, 20},
	{3501715456U, 20},
	{3501719552U, 15},
	{3501721344U, 24},
	{3501729792U, 24},
	{3501731328U, 24},
	{3501740032U, 23},
	{3501757952U, 23},
	{3501758464U, 24},
	{3501758720U, 24},
	{3501774848U, 24},
	{3501775616U, 24},
	{3501782016U, 22},
	{3501784064U, 22},
	{3501793536U, 24},
	{3501794048U, 24},
	{3501796096U, 24},
	{3501796352U, 24},
	{3501796608U, 24},
	{3501797376U, 23},
	{3501810176U, 23},
	{3501812992U, 24},
	{3501813760U, 24},
	{3501818112U, 24},
	{3501818368U, 24},
	{3501821440U, 24},
	{3501821696U, 24},
	{3501824512U, 23},
	{3501824512U, 24},
	{3501828352U, 24},
	{3501832704U, 24},
	{3501837312U, 24},
	{3501837568U, 24},
	{3501841408U, 24},
	{3501841920U, 23},
	{3501842432U, 23},
	{3501848576U, 22},
	{3501862912U, 21},
	{3501864960U, 21},
	{3501864960U, 24},
	{3501865472U, 23},
	{3501865984U, 22},
	{3501870336U, 24},
	{3501870592U, 24},
	{3501872640U, 24},
	{3501882880U, 23},
	{3501972224U, 24},
	{3502022656U, 20},
	{3502026752U, 21},
	{3502028800U, 21},
	{3502059520U, 20},
	{3502071808U, 20},
	{3502073600U, 24},
	{3502100480U, 21},
	{3502100992U, 24},
	{3502102528U, 21},
	{3502178304U, 20},
	{3502182400U, 20},
	{3502186496U, 20},
	{3502190592U, 20},
	{3502194688U, 20},
	{3502211072U, 20},
	{3502244608U, 24},
	{3502247424U, 24},
	{3502255360U, 24},
	{3502255616U, 24},
	{3502265856U, 24},
	{3502274560U, 24},
	{3502297088U, 22},
	{3502312960U, 24},
	{3502313216U, 24},
	{3502316288U, 24},
	{3502322944U, 24},
	{3502354688U, 24},
	{3502393856U, 23},
	{3502395392U, 24},
	{3502397440U, 24},
	{3502493696U, 20},
	{3502505728U, 24},
	{3502530560U, 19},
	{3502548992U, 24},
	{3502549248U, 24},
	{3502549504U, 24},
	{3502572544U, 24},
	{3502573568U, 24},
	{3502580480U, 24},
	{3502589440U, 24},
	{3502634496U, 24},
	{3502634752U, 24},
	{3502637056U, 22},
	{3502638080U, 22},
	{3502694400U, 21},
	{3502694400U, 24},
	{3502694656U, 24},
	{3502745600U, 21},
	{3502753792U, 21},
	{3502802944U, 21},
	{3502814208U, 24},
	{3502814464U, 24},
	{3502815488U, 24},
	{3502850048U, 21},
	{3502852352U, 24},
	{3502861312U, 24},
	{3502862336U, 22},
	{3502879488U, 24},
	{3502884864U, 21},
	{3502886912U, 24},
	{3502931968U, 21},
	{3502955008U, 23},
	{3502976768U, 24},
	{3502979072U, 21},
	{3502979072U, 22},
	{3502993408U, 23},
	{3503016192U, 24},
	{3503069952U, 24},
	{3503109376U, 24},
	{3503109632U, 24},
	{3503109888U, 24},
	{3503118336U, 21},
	{3503126528U, 24},
	{3503127552U, 24},
	{3503127808U, 24},
	{3503128064U, 24},
	{3503128320U, 24},
	{3503130624U, 24},
	{3503132672U, 20},
	{3503157248U, 22},
	{3503158272U, 22},
	{3503182848U, 24},
	{3503183104U, 24},
	{3503194112U, 23},
	{3503222784U, 24},
	{3503223296U, 24},
	{3503223552U, 24},
	{3503243264U, 24},
	{3503310848U, 22},
	{3503315712U, 24},
	{3503319040U, 21},
	{3503365120U, 24},
	{3503365376U, 24},
	{3503365632U, 24},
	{3503365888U, 24},
	{3503367680U, 24},
	{3503411712U, 24},
	{3503417344U, 24},
	{3503509504U, 24},
	{3503570944U, 20},
	{3503598336U, 24},
	{3503613952U, 23},
	{3503639552U, 22},
	{3503656960U, 20},
	{3503678720U, 24},
	{3503690240U, 24},
	{3503740928U, 21},
	{3503802368U, 24},
	{3503802624U, 24},
	{3503811584U, 24},
	{3503825632U, 28},
	{3503837184U, 21},
	{3503840000U, 24},
	{3503862784U, 22},
	{3503887616U, 24},
	{3503900416U, 24},
	{3503901184U, 24},
	{3503924736U, 24},
	{3503924992U, 24},
	{3503932928U, 24},
	{3503935488U, 20},
	{3503943168U, 24},
	{3503970304U, 21},
	{3503972352U, 22},
	{3503980544U, 21},
	{3504001536U, 24},
	{3504002560U, 24},
	{3504002816U, 24},
	{3504041984U, 20},
	{3504046080U, 19},
	{3504104448U, 24},
	{3504124928U, 24},
	{3504125184U, 24},
	{3504128000U, 19},
	{3504128512U, 23},
	{3504129024U, 23},
	{3504130048U, 24},
	{3504130304U, 24},
	{3504131072U, 24},
	{3504193536U, 24},
	{3504193792U, 24},
	{3504194048U, 24},
	{3504194304U, 24},
	{3504234496U, 23},
	{3504235008U, 24},
	{3504240640U, 21},
	{3504248320U, 23},
	{3504256512U, 24},
	{3504272384U, 24},
	{3504272640U, 24},
	{3504274432U, 24},
	{3504274688U, 24},
	{3504294912U, 24},
	{3504328704U, 23},
	{3504332800U, 20},
	{3504363264U, 24},
	{3504364032U, 24},
	{3504398336U, 24},
	{3504398592U, 24},
	{3504401152U, 24},
	{3504416768U, 24},
	{3504454400U, 24},
	{3504467712U, 24},
	{3504481280U, 24},
	{3504481536U, 24},
	{3504481792U, 24},
	{3504482048U, 24},
	{3504502784U, 22},
	{3504509952U, 24},
	{3504593152U, 24},
	{3504699648U, 24},
	{3504728320U, 24},
	{3504748544U, 24},
	{3504749056U, 23},
	{3504764416U, 24},
	{3504777216U, 22},
	{3504796672U, 24},
	{3504815104U, 24},
	{3504818176U, 23},
	{3504832512U, 22},
	{3504841216U, 24},
	{3504859136U, 24},
	{3504876544U, 24},
	{3504880128U, 24},
	{3504901632U, 23},
	{3504922112U, 23},
	{3504928000U, 24},
	{3504959488U, 21},
	{3504979968U, 20},
	{3504996352U, 19},
	{3505027072U, 22},
	{3505039360U, 24},
	{3505039616U, 24},
	{3505052160U, 23},
	{3505098752U, 21},
	{3505114624U, 23},
	{3505130496U, 22},
	{3505170944U, 24},
	{3505201408U, 24},
	{3505207296U, 22},
	{3505215488U, 23},
	{3505257984U, 24},
	{3505269504U, 24},
	{3505269760U, 24},
	{3505270016U, 24},
	{3505270272U, 24},
	{3505270528U, 24},
	{3505328128U, 21},
	{3505353728U, 22},
	{3505364736U, 24},
	{3505367296U, 24},
	{3505409024U, 23},
	{3505441792U, 24},
	{3505451008U, 22},
	{3505467392U, 22},
	{3505486848U, 24},
	{3505487104U, 24},
	{3505497600U, 23},
	{3505498112U, 24},
	{3505503744U, 24},
	{3505504000U, 24},
	{3505520640U, 24},
	{3505520896U, 24},
	{3505536512U, 24},
	{3505536768U, 24},
	{3505555712U, 24},
	{3505680128U, 24},
	{3505681920U, 24},
	{3505696256U, 23},
	{3505714688U, 23},
	{3505726464U, 23},
	{3505750016U, 24},
	{3505751040U, 22},
	{3505767680U, 24},
	{3505768192U, 24},
	{3505780736U, 21},
	{3505793536U, 23},
	{3505804032U, 24},
	{3505810432U, 22},
	{3505817088U, 24},
	{3505824768U, 23},
	{3505837824U, 24},
	{3505852672U, 24},
	{3505873920U, 24},
	{3505879296U, 24},
	{3505879552U, 24},
	{3505881344U, 24},
	{3505901568U, 24},
	{3505903616U, 24},
	{3505911808U, 23},
	{3505912320U, 23},
	{3505922304U, 24},
	{3505933568U, 24},
	{3505941504U, 23},
	{3505946624U, 20},
	{3505963008U, 24},
	{3505963264U, 24},
	{3505963520U, 24},
	{3505963776U, 24},
	{3505988608U, 24},
	{3506009088U, 24},
	{3506009344U, 24},
	{3506448384U, 24},
	{3506458880U, 24},
	{3506476800U, 24},
	{3506477056U, 22},
	{3506503680U, 16},
	{3506507520U, 24},
	{3506509568U, 24},
	{3506516384U, 27},
	{3506531328U, 22},
	{3506532352U, 24},
	{3506532608U, 24},
	{3506536448U, 24},
	{3506537920U, 26},
	{3506560512U, 24},
	{3506561024U, 23},
	{3506569216U, 16},
	{3506579456U, 24},
	{3506581248U, 24},
	{3506581504U, 24},
	{3506581760U, 24},
	{3506582016U, 24},
	{3506582272U, 24},
	{3506592256U, 24},
	{3506592768U, 24},
	{3506593024U, 24},
	{3506601984U, 24},
	{3506602240U, 24},
	{3506602496U, 24},
	{3506602752U, 24},
	{3506603008U, 24},
	{3506603264U, 24},
	{3506604544U, 24},
	{3506604800U, 24},
	{3506605824U, 24},
	{3506606592U, 24},
	{3506609152U, 24},
	{3506610176U, 21},
	{3506616576U, 24},
	{3506617088U, 24},
	{3506622464U, 24},
	{3506622720U, 24},
	{3506622976U, 24},
	{3506623232U, 24},
	{3506623488U, 24},
	{3506623744U, 24},
	{3506624512U, 24},
	{3506624768U, 24},
	{3506625024U, 24},
	{3506625280U, 24},
	{3506625536U, 24},
	{3506625792U, 24},
	{3506626048U, 24},
	{3506626304U, 24},
	{3506626560U, 24},
	{3506626816U, 24},
	{3506627072U, 24},
	{3506627328U, 24},
	{3506627584U, 24},
	{3506627840U, 24},
	{3506628096U, 24},
	{3506628352U, 24},
	{3506628608U, 24},
	{3506628864U, 24},
	{3506629120U, 24},
	{3506629376U, 24},
	{3506629632U, 24},
	{3506629888U, 24},
	{3506630144U, 24},
	{3506630400U, 24},
	{3506633984U, 24},
	{3506634240U, 24},
	{3506648576U, 24},
	{3506664960U, 24},
	{3506683136U, 24},
	{3506685440U, 24},
	{3506758656U, 24},
	{3506764288U, 23},
	{3506764800U, 23},
	{3506765312U, 23},
	{3506831360U, 17},
	{3506864128U, 19},
	{3506872320U, 19},
	{3506872576U, 24},
	{3506880512U, 20},
	{3506884608U, 20},
	{3506888704U, 19},
	{3506896896U, 16},
	{3506974720U, 22},
	{3506975744U, 22},
	{3506982912U, 23},
	{3507011584U, 22},
	{3507093504U, 16},
	{3507093504U, 19},
	{3507097088U, 23},
	{3507097600U, 22},
	{3507097600U, 24},
	{3507099648U, 21},
	{3507101696U, 20},
	{3507104384U, 25},
	{3507105792U, 21},
	{3507106560U, 24},
	{3507107840U, 21},
	{3507109888U, 19},
	{3507117568U, 24},
	{3507118080U, 19},
	{3507124992U, 24},
	{3507125504U, 24},
	{3507126272U, 23},
	{3507126784U, 23},
	{3507126784U, 24},
	{3507128576U, 24},
	{3507130880U, 24},
	{3507133440U, 22},
	{3507136512U, 21},
	{3507137536U, 24},
	{3507138560U, 20},
	{3507139584U, 24},
	{3507142656U, 21},
	{3507144704U, 22},
	{3507145728U, 22},
	{3507146752U, 20},
	{3507148288U, 24},
	{3507149312U, 24},
	{3507150848U, 20},
	{3507152000U, 25},
	{3507154944U, 20},
	{3507155968U, 23},
	{3507158016U, 24},
	{3507159040U, 17},
	{3507159040U, 22},
	{3507160064U, 22},
	{3507160448U, 25},
	{3507161088U, 21},
	{3507163136U, 20},
	{3507167232U, 19},
	{3507168512U, 24},
	{3507168768U, 24},
	{3507169408U, 25},
	{3507169664U, 25},
	{3507170304U, 25},
	{3507170560U, 26},
	{3507171328U, 25},
	{3507171456U, 25},
	{3507171584U, 24},
	{3507172416U, 26},
	{3507172480U, 25},
	{3507173120U, 24},
	{3507173376U, 24},
	{3507173632U, 24},
	{3507174144U, 25},
	{3507174272U, 25},
	{3507175168U, 24},
	{3507175424U, 19},
	{3507175424U, 26},
	{3507176448U, 24},
	{3507177216U, 24},
	{3507177472U, 22},
	{3507178496U, 24},
	{3507178752U, 24},
	{3507179008U, 24},
	{3507179264U, 24},
	{3507179776U, 24},
	{3507180288U, 25},
	{3507180608U, 26},
	{3507180672U, 25},
	{3507180800U, 24},
	{3507182016U, 26},
	{3507182464U, 25},
	{3507182848U, 24},
	{3507183616U, 20},
	{3507184064U, 26},
	{3507184128U, 24},
	{3507185408U, 24},
	{3507185664U, 23},
	{3507187712U, 20},
	{3507190016U, 24},
	{3507190272U, 24},
	{3507190784U, 26},
	{3507191808U, 19},
	{3507192064U, 24},
	{3507196672U, 24},
	{3507200000U, 19},
	{3507208192U, 19},
	{3507228672U, 21},
	{3507231744U, 22},
	{3507290112U, 16},
	{3507390464U, 24},
	{3507421184U, 18},
	{3507437568U, 19},
	{3507445760U, 19},
	{3507453952U, 19},
	{3507462144U, 19},
	{3507470336U, 19},
	{3507478528U, 19},
	{3507486720U, 18},
	{3507492864U, 24},
	{3507505920U, 24},
	{3507519488U, 18},
	{3507529728U, 23},
	{3507568640U, 19},
	{3507573504U, 24},
	{3507609600U, 19},
	{3507609876U, 30},
	{3507609880U, 30},
	{3507650560U, 17},
	{3507718912U, 24},
	{3507732480U, 18},
	{3507737600U, 24},
	{3507765248U, 19},
	{3507814400U, 18},
	{3507820544U, 24},
	{3507823616U, 24},
	{3507823872U, 24},
	{3507829504U, 24},
	{3507830016U, 24},
	{3507849216U, 21},
	{3507851264U, 21},
	{3507880448U, 24},
	{3507881472U, 24},
	{3507881728U, 24},
	{3507881984U, 24},
	{3507886336U, 24},
	{3507889152U, 24},
	{3507889408U, 24},
	{3507891968U, 24},
	{3507892992U, 24},
	{3507895296U, 24},
	{3507919104U, 24},
	{3507921152U, 24},
	{3507921408U, 24},
	{3507926272U, 24},
	{3507926528U, 24},
	{3507927552U, 23},
	{3507931648U, 24},
	{3507934208U, 24},
	{3507934464U, 24},
	{3507934720U, 24},
	{3507934976U, 24},
	{3507935232U, 24},
	{3507935488U, 24},
	{3507935744U, 24},
	{3507936000U, 24},
	{3507965952U, 20},
	{3508011008U, 16},
	{3508054016U, 21},
	{3508082688U, 24},
	{3508098304U, 24},
	{3508109312U, 18},
	{3508125696U, 19},
	{3508133888U, 20},
	{3508137984U, 20},
	{3508150272U, 22},
	{3508208384U, 24},
	{3508233728U, 24},
	{3508242688U, 24},
	{3508273152U, 16},
	{3508274688U, 24},
	{3508275456U, 24},
	{3508277248U, 24},
	{3508281856U, 24},
	{3508287488U, 24},
	{3508290816U, 24},
	{3508291328U, 24},
	{3508292352U, 24},
	{3508294144U, 24},
	{3508317696U, 24},
	{3508424704U, 20},
	{3508469760U, 16},
	{3508490240U, 24},
	{3508502528U, 21},
	{3508525824U, 24},
	{3508532224U, 24},
	{3508535296U, 16},
	{3508547584U, 20},
	{3508558848U, 22},
	{3508562944U, 22},
	{3508568064U, 19},
	{3508578304U, 21},
	{3508592640U, 22},
	{3508699136U, 19},
	{3508707328U, 20},
	{3508711424U, 20},
	{3508717568U, 22},
	{3508718592U, 22},
	{3508719616U, 20},
	{3508797440U, 15},
	{3508811008U, 24},
	{3508821760U, 24},
	{3508830208U, 24},
	{3508876544U, 24},
	{3508884480U, 24},
	{3508884736U, 24},
	{3508884992U, 24},
	{3508886784U, 24},
	{3508898304U, 24},
	{3508900096U, 24},
	{3508994048U, 16},
	{3509024256U, 24},
	{3509024512U, 24},
	{3509108736U, 21},
	{3509110784U, 21},
	{3509112832U, 21},
	{3509114880U, 21},
	{3509125120U, 18},
	{3509141504U, 18},
	{3509143808U, 24},
	{3509174272U, 18},
	{3509178112U, 24},
	{3509182464U, 24},
	{3509187584U, 24},
	{3509188352U, 24},
	{3509288960U, 17},
	{3509289472U, 24},
	{3509320192U, 24},
	{3509327872U, 21},
	{3509335040U, 23},
	{3509347840U, 24},
	{3509352448U, 22},
	{3509420032U, 24},
	{3509420288U, 24},
	{3509420544U, 24},
	{3509421056U, 24},
	{3509438464U, 23},
	{3509438976U, 24},
	{3509439232U, 24},
	{3509452800U, 17},
	{3509485824U, 24},
	{3509488640U, 24},
	{3509488896U, 24},
	{3509490176U, 24},
	{3509490432U, 24},
	{3509669888U, 21},
	{3509671936U, 22},
	{3509675008U, 23},
	{3509692416U, 24},
	{3509693440U, 22},
	{3509714944U, 19},
	{3509720064U, 24},
	{3509724416U, 24},
	{3509726208U, 24},
	{3509726464U, 24},
	{3509747712U, 19},
	{3509772288U, 19},
	{3509780480U, 19},
	{3509792768U, 20},
	{3509829632U, 19},
	{3509837824U, 19},
	{3509838592U, 24},
	{3509838848U, 24},
	{3509841664U, 24},
	{3509841920U, 24},
	{3509984256U, 22},
	{3509985280U, 22},
	{3509986304U, 22},
	{3509990656U, 24},
	{3510007808U, 24},
	{3510026240U, 20},
	{3510059008U, 18},
	{3510075392U, 24},
	{3510107904U, 24},
	{3510108160U, 16},
	{3510132736U, 21},
	{3510173696U, 16},
	{3510179840U, 21},
	{3510183936U, 21},
	{3510190080U, 21},
	{3510192128U, 21},
	{3510205184U, 24},
	{3510210560U, 21},
	{3510220544U, 24},
	{3510220800U, 23},
	{3510221568U, 24},
	{3510272000U, 18},
	{3510370304U, 16},
	{3510370560U, 24},
	{3510373888U, 24},
	{3510374144U, 24},
	{3510374400U, 23},
	{3510379008U, 24},
	{3510387712U, 24},
	{3510388224U, 23},
	{3510390016U, 24},
	{3510392832U, 24},
	{3510393344U, 24},
	{3510406144U, 23},
	{3510406656U, 24},
	{3510411264U, 24},
	{3510413056U, 24},
	{3510413824U, 24},
	{3510417152U, 24},
	{3510417408U, 24},
	{3510417664U, 24},
	{3510432256U, 24},
	{3510468608U, 18},
	{3510590976U, 23},
	{3510591488U, 22},
	{3510632448U, 15},
	{3510641408U, 24},
	{3510641664U, 24},
	{3510641920U, 24},
	{3510647040U, 24},
	{3510668800U, 24},
	{3510671360U, 22},
	{3510672384U, 23},
	{3510679552U, 23},
	{3510682624U, 23},
	{3510684160U, 24},
	{3510702080U, 24},
	{3510702336U, 24},
	{3510702592U, 24},
	{3510702848U, 24},
	{3510707200U, 22},
	{3510763520U, 19},
	{3510771712U, 19},
	{3510779904U, 18},
	{3510789120U, 23},
	{3510829056U, 16},
	{3510829056U, 18},
	{3510833664U, 24},
	{3510839808U, 24},
	{3510841344U, 22},
	{3510845440U, 18},
	{3510861824U, 18},
	{3510863712U, 27},
	{3510870272U, 24},
	{3510870528U, 24},
	{3510878208U, 19},
	{3510886400U, 19},
	{3510927360U, 19},
	{3510943744U, 18},
	{3510960128U, 16},
	{3510961920U, 24},
	{3510984704U, 24},
	{3510989824U, 24},
	{3511017472U, 20},
	{3511025664U, 16},
	{3511070464U, 24},
	{3511091200U, 17},
	{3511123968U, 19},
	{3511132160U, 20},
	{3511136256U, 20},
	{3511156736U, 24},
	{3511190528U, 24},
	{3511190784U, 24},
	{3511191040U, 24},
	{3511191296U, 24},
	{3511191552U, 24},
	{3511191808U, 24},
	{3511192064U, 24},
	{3511192320U, 24},
	{3511192576U, 24},
	{3511192832U, 24},
	{3511193088U, 24},
	{3511193344U, 24},
	{3511193600U, 24},
	{3511193856U, 24},
	{3511194112U, 24},
	{3511194368U, 24},
	{3511194624U, 24},
	{3511194880U, 24},
	{3511195136U, 24},
	{3511195392U, 24},
	{3511195648U, 24},
	{3511196160U, 24},
	{3511196416U, 24},
	{3511196672U, 24},
	{3511196928U, 24},
	{3511197184U, 24},
	{3511197440U, 24},
	{3511197696U, 24},
	{3511197952U, 24},
	{3511198208U, 24},
	{3511198464U, 24},
	{3511198720U, 24},
	{3511198976U, 24},
	{3511222272U, 18},
	{3511232512U, 24},
	{3511238656U, 18},
	{3511271424U, 18},
	{3511277568U, 23},
	{3511278848U, 24},
	{3511280128U, 23},
	{3511304192U, 19},
	{3511312384U, 19},
	{3511320576U, 18},
	{3511325696U, 24},
	{3511327488U, 24},
	{3511336960U, 19},
	{3511353344U, 16},
	{3511354368U, 22},
	{3511358464U, 22},
	{3511366400U, 24},
	{3511373824U, 22},
	{3511375872U, 21},
	{3511382016U, 21},
	{3511400448U, 22},
	{3511406592U, 22},
	{3511408640U, 22},
	{3511444992U, 24},
	{3511524864U, 24},
	{3511549952U, 19},
	{3511562752U, 24},
	{3511697408U, 24},
	{3511697664U, 24},
	{3511697920U, 23},
	{3511698432U, 24},
	{3511699456U, 24},
	{3511700480U, 24},
	{3511701504U, 24},
	{3511703552U, 24},
	{3511710720U, 24},
	{3511711232U, 24},
	{3511711744U, 24},
	{3511712256U, 24},
	{3511746560U, 18},
	{3511762944U, 19},
	{3511764224U, 24},
	{3511779328U, 17},
	{3511782144U, 24},
	{3511877632U, 24},
	{3511881728U, 23},
	{3511919872U, 24},
	{3511920640U, 23},
	{3511921408U, 24},
	{3511959552U, 21},
	{3511989760U, 24},
	{3511990016U, 24},
	{3512008704U, 16},
	{3512074240U, 16},
	{3512172544U, 20},
	{3512188928U, 20},
	{3512233984U, 24},
	{3512234240U, 24},
	{3512234496U, 24},
	{3512247296U, 22},
	{3512247552U, 24},
	{3512532992U, 17},
	{3512534016U, 24},
	{3512536064U, 24},
	{3512536832U, 24},
	{3512538368U, 24},
	{3512538624U, 24},
	{3512539136U, 24},
	{3512540928U, 24},
	{3512544512U, 24},
	{3512544768U, 24},
	{3512549120U, 24},
	{3512549376U, 24},
	{3512551424U, 24},
	{3512559104U, 24},
	{3512565760U, 18},
	{3512565760U, 24},
	{3512567040U, 24},
	{3512578816U, 24},
	{3512580352U, 24},
	{3512582144U, 19},
	{3512582144U, 24},
	{3512582912U, 24},
	{3512583168U, 24},
	{3512584448U, 24},
	{3512585728U, 24},
	{3512588288U, 24},
	{3512598528U, 19},
	{3512631296U, 19},
	{3512664064U, 19},
	{3512672256U, 19},
	{3512688384U, 24},
	{3512713216U, 19},
	{3512729600U, 18},
	{3512745984U, 19},
	{3512809472U, 24},
	{3512809728U, 24},
	{3512810240U, 24},
	{3512810752U, 24},
	{3512811520U, 19},
	{3512818688U, 23},
	{3512926208U, 17},
	{3512983552U, 23},
	{3512984064U, 23},
	{3512984576U, 23},
	{3512985088U, 23},
	{3513012224U, 21},
	{3513018368U, 21},
	{3513021440U, 22},
	{3513028608U, 21},
	{3513028608U, 22},
	{3513030656U, 23},
	{3513048576U, 23},
	{3513057280U, 16},
	{3513062400U, 24},
	{3513063424U, 24},
	{3513067264U, 24},
	{3513067520U, 23},
	{3513076992U, 24},
	{3513078528U, 24},
	{3513093120U, 24},
	{3513108736U, 24},
	{3513122304U, 24},
	{3513141248U, 22},
	{3513142272U, 23},
	{3513146368U, 22},
	{3513147392U, 22},
	{3513151488U, 24},
	{3513151744U, 24},
	{3513152000U, 24},
	{3513152256U, 24},
	{3513152512U, 24},
	{3513152768U, 24},
	{3513153024U, 24},
	{3513160448U, 24},
	{3513221120U, 19},
	{3513262080U, 23},
	{3513262592U, 23},
	{3513263104U, 22},
	{3513264640U, 23},
	{3513269504U, 24},
	{3513269760U, 24},
	{3513270016U, 24},
	{3513294848U, 19},
	{3513319424U, 17},
	{3513384960U, 17},
	{3513417728U, 18},
	{3513434112U, 19},
	{3513442304U, 19},
	{3513450496U, 18},
	{3513466880U, 19},
	{3513483264U, 18},
	{3513516032U, 14},
	{3513516032U, 15},
	{3513520896U, 24},
	{3513540608U, 20},
	{3513557504U, 24},
	{3513583616U, 22},
	{3513588736U, 22},
	{3513595904U, 21},
	{3513596672U, 24},
	{3513638912U, 21},
	{3513671936U, 24},
	{3513747200U, 24},
	{3513802752U, 20},
	{3513810944U, 21},
	{3513812992U, 21},
	{3513815040U, 21},
	{3513817088U, 21},
	{3513819136U, 19},
	{3513827328U, 20},
	{3513843712U, 17},
	{3513876480U, 17},
	{3513909248U, 18},
	{3513925632U, 24},
	{3513925888U, 24},
	{3513926144U, 24},
	{3513926400U, 24},
	{3513926656U, 24},
	{3513926912U, 24},
	{3513927168U, 24},
	{3513927424U, 24},
	{3513927680U, 24},
	{3513927936U, 24},
	{3513928192U, 24},
	{3513928448U, 24},
	{3513928704U, 24},
	{3513928960U, 24},
	{3513929216U, 24},
	{3513929728U, 24},
	{3513929984U, 24},
	{3513930752U, 22},
	{3513931776U, 24},
	{3513932032U, 24},
	{3513932544U, 24},
	{3513933568U, 24},
	{3513942016U, 18},
	{3513957632U, 24},
	{3513974784U, 17},
	{3513981184U, 24},
	{3513982208U, 24},
	{3513984512U, 24},
	{3513984768U, 24},
	{3513988352U, 24},
	{3513998848U, 24},
	{3514000384U, 24},
	{3514005504U, 22},
	{3514040320U, 21},
	{3514081280U, 21},
	{3514119680U, 23},
	{3514136576U, 23},
	{3514137088U, 24},
	{3514145792U, 24},
	{3514146304U, 24},
	{3514155008U, 22},
	{3514157056U, 22},
	{3514158080U, 23},
	{3514158592U, 23},
	{3514159104U, 21},
	{3514161152U, 21},
	{3514190336U, 24},
	{3514206720U, 23},
	{3514217984U, 24},
	{3514218240U, 24},
	{3514234880U, 22},
	{3514238976U, 21},
	{3514246144U, 23},
	{3514260480U, 22},
	{3514260736U, 24},
	{3514261504U, 20},
	{3514274048U, 24},
	{3514294784U, 23},
	{3514295296U, 22},
	{3514433536U, 16},
	{3514499072U, 16},
	{3514517504U, 24},
	{3514547712U, 23},
	{3514555136U, 24},
	{3514564608U, 19},
	{3514589184U, 20},
	{3514597376U, 19},
	{3514646016U, 24},
	{3514843136U, 19},
	{3514851328U, 19},
	{3514875904U, 19},
	{3514884096U, 21},
	{3514886144U, 22},
	{3514887168U, 23},
	{3514902016U, 23},
	{3514902528U, 22},
	{3514903552U, 23},
	{3514957824U, 17},
	{3514996736U, 24},
	{3514996992U, 24},
	{3514997248U, 24},
	{3514997504U, 24},
	{3514997760U, 24},
	{3514998016U, 24},
	{3514998272U, 24},
	{3514998528U, 24},
	{3515031552U, 19},
	{3515072512U, 19},
	{3515088896U, 17},
	{3515154432U, 17},
	{3515159808U, 24},
	{3515161600U, 23},
	{3515164160U, 24},
	{3515167232U, 24},
	{3515187200U, 18},
	{3515219968U, 18},
	{3515260928U, 19},
	{3515334656U, 18},
	{3515356416U, 24},
	{3515356672U, 24},
	{3515356928U, 24},
	{3515357184U, 24},
	{3515368960U, 24},
	{3515369216U, 24},
	{3515369472U, 24},
	{3515393024U, 22},
	{3515394048U, 23},
	{3515449344U, 19},
	{3515451392U, 21},
	{3515453440U, 21},
	{3515455488U, 21},
	{3515498752U, 24},
	{3515547648U, 17},
	{3515580416U, 18},
	{3515619328U, 24},
	{3515625472U, 20},
	{3515685376U, 24},
	{3515685888U, 24},
	{3515695616U, 24},
	{3515695872U, 24},
	{3515699200U, 24},
	{3515707392U, 21},
	{3515724800U, 22},
	{3515725824U, 24},
	{3515740416U, 24},
	{3515809792U, 18},
	{3515858944U, 27},
	{3515859008U, 27},
	{3515859040U, 27},
	{3515859072U, 27},
	{3515859136U, 27},
	{3515859264U, 26},
	{3515859352U, 30},
	{3515859356U, 30},
	{3515859360U, 27},
	{3515859392U, 27},
	{3515859424U, 30},
	{3515859432U, 30},
	{3515859436U, 30},
	{3515859440U, 29},
	{3515859968U, 24},
	{3515860224U, 24},
	{3515860480U, 24},
	{3515860864U, 30},
	{3515860928U, 27},
	{3515860960U, 28},
	{3515860976U, 28},
	{3515860992U, 24},
	{3515864064U, 24},
	{3515865344U, 24},
	{3515865600U, 24},
	{3515865856U, 24},
	{3515866112U, 24},
	{3515866368U, 24},
	{3515866752U, 25},
	{3515867392U, 24},
	{3515868416U, 24},
	{3515868672U, 24},
	{3515868928U, 26},
	{3515868992U, 26},
	{3515869056U, 26},
	{3515869120U, 26},
	{3515869184U, 24},
	{3515869440U, 24},
	{3515869696U, 25},
	{3515869824U, 26},
	{3515869888U, 30},
	{3515869892U, 30},
	{3515869896U, 29},
	{3515869904U, 28},
	{3515869920U, 28},
	{3515869952U, 24},
	{3515870208U, 24},
	{3515870464U, 24},
	{3515870720U, 24},
	{3515870976U, 24},
	{3515871360U, 27},
	{3515871424U, 27},
	{3515871456U, 27},
	{3515871488U, 24},
	{3515871848U, 29},
	{3515871856U, 28},
	{3515871872U, 26},
	{3515871936U, 26},
	{3515872000U, 26},
	{3515872080U, 28},
	{3515872128U, 27},
	{3515872256U, 24},
	{3515872528U, 28},
	{3515872560U, 30},
	{3515872564U, 30},
	{3515872568U, 29},
	{3515872704U, 27},
	{3515873024U, 24},
	{3515873280U, 24},
	{3515873792U, 24},
	{3515875200U, 28},
	{3515880448U, 23},
	{3515910144U, 23},
	{3515918592U, 24},
	{3515929088U, 24},
	{3515929344U, 24},
	{3515931392U, 24},
	{3515949056U, 19},
	{3515957248U, 19},
	{3515990016U, 19},
	{3515992064U, 22},
	{3516022528U, 24},
	{3516088320U, 19},
	{3516244992U, 23},
	{3516276736U, 19},
	{3516309504U, 19},
	{3516352512U, 22},
	{3516389376U, 22},
	{3516391424U, 19},
	{3516416000U, 18},
	{3516448768U, 19},
	{3516465152U, 18},
	{3516497920U, 18},
	{3516556288U, 24},
	{3516596224U, 16},
	{3516602624U, 24},
	{3516602880U, 23},
	{3516603392U, 22},
	{3516606976U, 24},
	{3516607232U, 24},
	{3516611328U, 24},
	{3516615424U, 24},
	{3516615680U, 24},
	{3516618752U, 24},
	{3516624384U, 24},
	{3516626432U, 24},
	{3516627968U, 24},
	{3516628224U, 24},
	{3516630784U, 24},
	{3516631040U, 24},
	{3516631296U, 24},
	{3516636160U, 24},
	{3516637696U, 23},
	{3516639232U, 22},
	{3516643584U, 24},
	{3516646912U, 24},
	{3516647168U, 24},
	{3516648448U, 22},
	{3516653568U, 21},
	{3516727296U, 16},
	{3516754944U, 24},
	{3516944896U, 24},
	{3517005824U, 19},
	{3517030400U, 19},
	{3517071360U, 18},
	{3517087744U, 19},
	{3517112064U, 24},
	{3517120512U, 18},
	{3517120512U, 21},
	{3517154304U, 24},
	{3517154560U, 24},
	{3517168640U, 24},
	{3517168896U, 24},
	{3517169152U, 24},
	{3517169408U, 24},
	{3517179904U, 21},
	{3517182976U, 22},
	{3517184000U, 22},
	{3517186048U, 18},
	{3517218816U, 18},
	{3517235200U, 19},
	{3517300736U, 19},
	{3517310464U, 23},
	{3517349888U, 18},
	{3517440256U, 24},
	{3517441024U, 24},
	{3517448192U, 17},
	{3517449984U, 24},
	{3517450240U, 24},
	{3517464320U, 24},
	{3517579264U, 18},
	{3517603584U, 24},
	{3517636608U, 19},
	{3517726720U, 18},
	{3517775872U, 19},
	{3517784064U, 24},
	{3517792256U, 20},
	{3517808640U, 19},
	{3517816832U, 19},
	{3517841408U, 16},
	{3517906944U, 16},
	{3517960192U, 21},
	{3517972480U, 22},
	{3517976064U, 23},
	{3517976576U, 22},
	{3517986816U, 22},
	{3518023680U, 21},
	{3518025984U, 24},
	{3518027776U, 21},
	{3518038016U, 18},
	{3518043648U, 23},
	{3518045440U, 24},
	{3518049280U, 24},
	{3518052864U, 24},
	{3518087168U, 18},
	{3518087168U, 19},
	{3518087168U, 24},
	{3518087424U, 24},
	{3518087680U, 23},
	{3518088192U, 24},
	{3518088448U, 24},
	{3518088704U, 24},
	{3518088960U, 24},
	{3518089472U, 24},
	{3518089728U, 24},
	{3518089984U, 24},
	{3518090240U, 24},
	{3518090496U, 24},
	{3518090752U, 24},
	{3518091008U, 24},
	{3518091264U, 22},
	{3518092288U, 24},
	{3518092544U, 24},
	{3518092800U, 24},
	{3518093312U, 22},
	{3518094336U, 23},
	{3518094848U, 24},
	{3518095104U, 24},
	{3518103552U, 17},
	{3518136320U, 18},
	{3518169088U, 16},
	{3518290944U, 22},
	{3518414848U, 21},
	{3518416896U, 21},
	{3518418944U, 21},
	{3518429184U, 21},
	{3518443520U, 21},
	{3518447616U, 18},
	{3518480384U, 18},
	{3518498816U, 22},
	{3518504960U, 21},
	{3518530304U, 24},
	{3518530560U, 22},
	{3518553088U, 23},
	{3518554112U, 21},
	{3518558720U, 23},
	{3518562304U, 16},
	{3518562304U, 17},
	{3518587648U, 24},
	{3518588672U, 24},
	{3518590464U, 24},
	{3518595072U, 18},
	{3518595072U, 19},
	{3518595072U, 24},
	{3518595328U, 24},
	{3518595584U, 23},
	{3518600448U, 24},
	{3518602752U, 24},
	{3518603264U, 19},
	{3518611456U, 19},
	{3518616576U, 23},
	{3518623744U, 22},
	{3518624512U, 24},
	{3518627840U, 15},
	{3518627840U, 24},
	{3518630912U, 24},
	{3518631168U, 24},
	{3518631424U, 24},
	{3518631680U, 24},
	{3518632704U, 24},
	{3518640640U, 23},
	{3518640640U, 24},
	{3518640896U, 24},
	{3518642688U, 23},
	{3518648320U, 22},
	{3518654208U, 24},
	{3518658048U, 24},
	{3518661632U, 23},
	{3518664192U, 24},
	{3518665728U, 24},
	{3518665984U, 24},
	{3518666240U, 24},
	{3518666496U, 24},
	{3518675456U, 24},
	{3518675712U, 24},
	{3518675968U, 24},
	{3518676224U, 24},
	{3518676480U, 23},
	{3518678272U, 24},
	{3518689280U, 21},
	{3518691328U, 22},
	{3518699008U, 24},
	{3518699264U, 24},
	{3518709504U, 24},
	{3518712832U, 23},
	{3518713344U, 23},
	{3518722048U, 21},
	{3518728448U, 24},
	{3518729216U, 24},
	{3518729472U, 24},
	{3518729728U, 24},
	{3518729984U, 24},
	{3518734336U, 24},
	{3518734592U, 24},
	{3518734848U, 24},
	{3518735104U, 24},
	{3518735360U, 24},
	{3518735616U, 24},
	{3518735872U, 24},
	{3518736128U, 24},
	{3518736384U, 22},
	{3518738432U, 20},
	{3518744576U, 22},
	{3518746368U, 24},
	{3518746624U, 21},
	{3518750720U, 19},
	{3518783488U, 20},
	{3518824448U, 17},
	{3518889984U, 17},
	{3518922752U, 19},
	{3518930944U, 19},
	{3518939136U, 18},
	{3518971904U, 24},
	{3518972416U, 24},
	{3518974464U, 24},
	{3518974976U, 24},
	{3518975488U, 24},
	{3518976768U, 24},
	{3518977024U, 24},
	{3518977792U, 24},
	{3518978304U, 24},
	{3518980096U, 24},
	{3518981120U, 24},
	{3518981888U, 24},
	{3518982144U, 24},
	{3518982400U, 24},
	{3518984448U, 24},
	{3518984704U, 24},
	{3518985216U, 24},
	{3518985984U, 24},
	{3518986240U, 24},
	{3518987008U, 24},
	{3518988288U, 19},
	{3518989568U, 24},
	{3518989824U, 24},
	{3518990336U, 24},
	{3518990848U, 24},
	{3518991104U, 24},
	{3518991360U, 23},
	{3518991872U, 24},
	{3518992384U, 23},
	{3518993920U, 23},
	{3518994432U, 24},
	{3518994688U, 24},
	{3518995200U, 24},
	{3518995712U, 24},
	{3518996480U, 19},
	{3518997504U, 23},
	{3518998272U, 24},
	{3518998528U, 21},
	{3518998528U, 23},
	{3518998528U, 24},
	{3518998784U, 24},
	{3518999552U, 24},
	{3518999808U, 24},
	{3519000576U, 22},
	{3519001600U, 24},
	{3519002112U, 23},
	{3519004672U, 19},
	{3519026176U, 22},
	{3519033344U, 22},
	{3519053824U, 17},
	{3519086592U, 18},
	{3519119360U, 17},
	{3519188480U, 24},
	{3519188736U, 24},
	{3519188992U, 24},
	{3519189248U, 24},
	{3519217664U, 19},
	{3519225856U, 19},
	{3519250432U, 18},
	{3519266816U, 18},
	{3519332352U, 19},
	{3519332352U, 24},
	{3519348736U, 19},
	{3519463424U, 19},
	{3519464704U, 24},
	{3519465984U, 23},
	{3519467008U, 24},
	{3519467776U, 24},
	{3519468032U, 24},
	{3519468800U, 24},
	{3519471616U, 20},
	{3519471872U, 24},
	{3519473664U, 24},
	{3519473920U, 24},
	{3519474944U, 24},
	{3519476992U, 24},
	{3519709184U, 18},
	{3519725568U, 20},
	{3519729664U, 20},
	{3519732736U, 23},
	{3519733760U, 20},
	{3519737856U, 20},
	{3519938560U, 23},
	{3519939072U, 23},
	{3519939584U, 23},
	{3519981568U, 24},
	{3519982592U, 24},
	{3520000000U, 22},
	{3520036864U, 17},
	{3520042240U, 24},
	{3520102400U, 17},
	{3520123392U, 24},
	{3520128000U, 24},
	{3520130304U, 24},
	{3520131840U, 24},
	{3520192512U, 19},
	{3520206848U, 23},
	{3520210944U, 23},
	{3520211456U, 24},
	{3520231424U, 21},
	{3520264960U, 24},
	{3520273920U, 23},
	{3520293632U, 24},
	{3520294400U, 24},
	{3520356352U, 19},
	{3520364288U, 24},
	{3520372736U, 19},
	{3520372736U, 22},
	{3520373760U, 24},
	{3520374016U, 24},
	{3520374272U, 24},
	{3520374528U, 24},
	{3520374784U, 23},
	{3520375296U, 23},
	{3520376832U, 24},
	{3520377088U, 24},
	{3520377344U, 23},
	{3520377856U, 23},
	{3520378368U, 23},
	{3520378880U, 23},
	{3520379392U, 24},
	{3520379648U, 24},
	{3520379904U, 24},
	{3520380160U, 24},
	{3520380416U, 24},
	{3520380672U, 24},
	{3520380928U, 19},
	{3520405504U, 19},
	{3520413696U, 19},
	{3520421888U, 19},
	{3520447232U, 24},
	{3520453888U, 24},
	{3520593920U, 18},
	{3520618496U, 19},
	{3520626688U, 19},
	{3520692224U, 18},
	{3520708608U, 19},
	{3520733184U, 23},
	{3520738816U, 24},
	{3520856064U, 16},
	{3520860672U, 23},
	{3520862720U, 24},
	{3520880640U, 24},
	{3520882688U, 24},
	{3520883712U, 24},
	{3520901632U, 24},
	{3520902656U, 23},
	{3520910336U, 23},
	{3520910848U, 23},
	{3520911616U, 24},
	{3520911872U, 24},
	{3520921600U, 19},
	{3520970752U, 19},
	{3520978944U, 24},
	{3520979200U, 24},
	{3520979456U, 24},
	{3520995328U, 20},
	{3521003520U, 18},
	{3521022208U, 24},
	{3521077248U, 20},
	{3521081344U, 20},
	{3521086208U, 24},
	{3521087488U, 21},
	{3521091584U, 23},
	{3521094656U, 23},
	{3521103872U, 21},
	{3521116672U, 23},
	{3521118208U, 22},
	{3521118720U, 24},
	{3521119488U, 24},
	{3521119744U, 23},
	{3521125888U, 23},
	{3521130496U, 21},
	{3521133568U, 22},
	{3521134592U, 22},
	{3521148928U, 22},
	{3521153024U, 22},
	{3521154048U, 23},
	{3521157120U, 21},
	{3521162240U, 22},
	{3521167360U, 21},
	{3521169408U, 22},
	{3521170432U, 22},
	{3521179136U, 23},
	{3521183744U, 18},
	{3521191872U, 26},
	{3521191936U, 26},
	{3521192960U, 22},
	{3521192960U, 23},
	{3521192960U, 26},
	{3521193472U, 23},
	{3521196288U, 24},
	{3521200128U, 19},
	{3521216512U, 18},
	{3521314816U, 17},
	{3521319424U, 24},
	{3521324032U, 24},
	{3521326080U, 24},
	{3521330688U, 24},
	{3521341184U, 24},
	{3521344512U, 24},
	{3521345280U, 24},
	{3521347584U, 18},
	{3521347584U, 19},
	{3521348096U, 23},
	{3521348608U, 22},
	{3521349632U, 23},
	{3521350144U, 23},
	{3521350656U, 23},
	{3521351680U, 22},
	{3521352704U, 23},
	{3521353728U, 23},
	{3521354240U, 23},
	{3521355776U, 19},
	{3521356800U, 22},
	{3521362944U, 22},
	{3521363968U, 18},
	{3521380352U, 14},
	{3521381888U, 24},
	{3521385984U, 24},
	{3521392640U, 21},
	{3521466368U, 20},
	{3521747968U, 22},
	{3521773568U, 18},
	{3521789952U, 19},
	{3521796096U, 24},
	{3521796352U, 24},
	{3521798144U, 20},
	{3521823744U, 24},
	{3521937408U, 20},
	{3521942016U, 23},
	{3521942528U, 22},
	{3521943552U, 21},
	{3521945600U, 21},
	{3521947648U, 22},
	{3521948672U, 23},
	{3521949440U, 24},
	{3521949696U, 22},
	{3521950976U, 24},
	{3521951232U, 23},
	{3521951744U, 21},
	{3521953792U, 22},
	{3521954816U, 24},
	{3521955072U, 24},
	{3521955584U, 24},
	{3521955840U, 21},
	{3521957888U, 22},
	{3521960960U, 22},
	{3521960960U, 24},
	{3521961216U, 24},
	{3521961472U, 24},
	{3521961728U, 24},
	{3521970176U, 18},
	{3521973248U, 24},
	{3521973504U, 24},
	{3521973760U, 24},
	{3521974016U, 24},
	{3521984512U, 23},
	{3521985024U, 24},
	{3521985280U, 24},
	{3521986560U, 24},
	{3521986816U, 24},
	{3521987072U, 24},
	{3521987328U, 24},
	{3521987584U, 24},
	{3521987840U, 24},
	{3521988096U, 24},
	{3521988352U, 24},
	{3521988608U, 23},
	{3521989376U, 24},
	{3521989632U, 24},
	{3521989888U, 24},
	{3521990144U, 24},
	{3521990400U, 24},
	{3521990656U, 23},
	{3521991168U, 24},
	{3521991424U, 24},
	{3521991936U, 24},
	{3521992192U, 24},
	{3521992448U, 24},
	{3521992704U, 24},
	{3521992960U, 24},
	{3521993216U, 24},
	{3521993472U, 24},
	{3521993728U, 24},
	{3521993984U, 24},
	{3521994240U, 24},
	{3521994496U, 24},
	{3521994752U, 24},
	{3521995008U, 24},
	{3521995264U, 24},
	{3521995520U, 24},
	{3521995776U, 24},
	{3521996032U, 24},
	{3521996288U, 24},
	{3521996544U, 24},
	{3521996800U, 24},
	{3521997056U, 24},
	{3521997312U, 24},
	{3521997568U, 24},
	{3521997824U, 24},
	{3521998080U, 24},
	{3521998336U, 24},
	{3521998848U, 24},
	{3521999104U, 24},
	{3521999360U, 24},
	{3521999616U, 24},
	{3521999872U, 24},
	{3522000384U, 24},
	{3522000640U, 24},
	{3522000896U, 24},
	{3522001152U, 24},
	{3522001920U, 24},
	{3522002176U, 24},
	{3522002432U, 24},
	{3522035712U, 16},
	{3522109440U, 19},
	{3522117632U, 19},
	{3522122240U, 24},
	{3522124032U, 24},
	{3522127360U, 24},
	{3522127616U, 24},
	{3522134016U, 19},
	{3522142208U, 19},
	{3522191360U, 19},
	{3522199552U, 19},
	{3522224128U, 19},
	{3522224128U, 20},
	{3522228224U, 21},
	{3522230272U, 21},
	{3522294528U, 24},
	{3522294784U, 24},
	{3522295040U, 24},
	{3522380544U, 24},
	{3522380800U, 24},
	{3522381056U, 24},
	{3522386944U, 24},
	{3522387456U, 24},
	{3522389248U, 24},
	{3522389504U, 24},
	{3522389760U, 24},
	{3522390784U, 24},
	{3522391296U, 24},
	{3522404352U, 19},
	{3522479360U, 24},
	{3522479616U, 23},
	{3522480896U, 24},
	{3522484224U, 23},
	{3522509824U, 23},
	{3522556160U, 24},
	{3522556928U, 22},
	{3522597376U, 24},
	{3522597632U, 24},
	{3522620416U, 22},
	{3522659328U, 23},
	{3522723840U, 17},
	{3522756608U, 16},
	{3522757120U, 24},
	{3522769664U, 24},
	{3522774528U, 24},
	{3522776064U, 23},
	{3522785536U, 24},
	{3522789376U, 23},
	{3522800896U, 24},
	{3522801152U, 24},
	{3522807296U, 23},
	{3522817024U, 24},
	{3522817792U, 24},
	{3522818048U, 24},
	{3522819584U, 23},
	{3522820608U, 24},
	{3522871296U, 19},
	{3522895872U, 21},
	{3522897920U, 21},
	{3522912256U, 19},
	{3523698688U, 19},
	{3523702784U, 21},
	{3523706880U, 19},
	{3523715072U, 19},
	{3523723008U, 24},
	{3523723264U, 19},
	{3523725056U, 24},
	{3523730688U, 24},
	{3523730944U, 24},
	{3523731456U, 19},
	{3523739648U, 14},
	{3523747328U, 23},
	{3523757312U, 24},
	{3523758848U, 24},
	{3523759616U, 24},
	{3523766528U, 24},
	{3523767808U, 24},
	{3523771136U, 24},
	{3523771392U, 22},
	{3523774976U, 24},
	{3523780096U, 24},
	{3523782656U, 24},
	{3523801088U, 23},
	{3523803136U, 24},
	{3523805696U, 24},
	{3523805952U, 24},
	{3523809280U, 20},
	{3523816448U, 22},
	{3523823360U, 24},
	{3523835904U, 22},
	{3523851520U, 24},
	{3523853056U, 24},
	{3523853824U, 24},
	{3523883520U, 24},
	{3523883776U, 24},
	{3523884032U, 24},
	{3523902464U, 22},
	{3523902464U, 24},
	{3523902720U, 24},
	{3523902976U, 24},
	{3523903232U, 24},
	{3524009984U, 19},
	{3524132864U, 19},
	{3524218880U, 20},
	{3524220928U, 21},
	{3524263936U, 20},
	{3524268032U, 20},
	{3524272128U, 20},
	{3524276224U, 20},
	{3524280320U, 22},
	{3524281344U, 22},
	{3524282368U, 22},
	{3524284416U, 22},
	{3524285440U, 22},
	{3524289536U, 24},
	{3524289792U, 24},
	{3524290048U, 24},
	{3524290304U, 24},
	{3524290560U, 24},
	{3524296448U, 24},
	{3524329472U, 17},
	{3524460544U, 18},
	{3524460544U, 19},
	{3524460544U, 20},
	{3524464640U, 20},
	{3524468736U, 19},
	{3524468736U, 20},
	{3524472832U, 20},
	{3524476928U, 18},
	{3524476928U, 19},
	{3524476928U, 20},
	{3524481024U, 20},
	{3524485120U, 19},
	{3524485120U, 20},
	{3524489216U, 20},
	{3524526080U, 17},
	{3524558848U, 17},
	{3524591616U, 16},
	{3524657152U, 16},
	{3524747264U, 19},
	{3524751360U, 20},
	{3524752128U, 24},
	{3524755456U, 19},
	{3524756736U, 24},
	{3524759040U, 23},
	{3524759552U, 22},
	{3524762112U, 23},
	{3524762624U, 23},
	{3524771840U, 19},
	{3524775936U, 20},
	{3524775936U, 23},
	{3524776448U, 23},
	{3524777984U, 23},
	{3524780032U, 19},
	{3524784128U, 20},
	{3524784128U, 23},
	{3524784640U, 23},
	{3524785152U, 23},
	{3524804608U, 18},
	{3524841472U, 20},
	{3524845568U, 22},
	{3524846592U, 22},
	{3526492160U, 18},
	{3526496256U, 22},
	{3526497280U, 24},
	{3526498560U, 24},
	{3526498816U, 23},
	{3526499328U, 23},
	{3526499328U, 24},
	{3526499840U, 24},
	{3526504448U, 23},
	{3526505216U, 24},
	{3526505472U, 22},
	{3526506496U, 21},
	{3526508544U, 20},
	{3526512640U, 20},
	{3526557696U, 16},
	{3526623232U, 16},
	{3526688768U, 16},
	{3526754304U, 17},
	{3526787072U, 17},
	{3526787840U, 24},
	{3526788096U, 24},
	{3526788352U, 24},
	{3526788608U, 24},
	{3526788864U, 24},
	{3526819840U, 17},
	{3526824192U, 24},
	{3526845440U, 22},
	{3526846464U, 22},
	{3526852608U, 17},
	{3526859520U, 24},
	{3526860032U, 24},
	{3526863104U, 24},
	{3526866944U, 24},
	{3526871552U, 24},
	{3526874624U, 24},
	{3526874880U, 24},
	{3526878720U, 24},
	{3526884864U, 24},
	{3526885376U, 19},
	{3527016448U, 16},
	{3527049216U, 18},
	{3527065600U, 18},
	{3527081984U, 17},
	{3527114752U, 17},
	{3527140864U, 24},
	{3527147520U, 16},
	{3527205120U, 24},
	{3527213056U, 16},
	{3527278592U, 18},
	{3527294976U, 19},
	{3527327744U, 19},
	{3527335936U, 20},
	{3527340032U, 21},
	{3527344128U, 18},
	{3527376896U, 19},
	{3527385088U, 19},
	{3527409664U, 16},
	{3527475200U, 16},
	{3527540736U, 16},
	{3527606272U, 18},
	{3527634944U, 20},
	{3527639040U, 20},
	{3527643136U, 20},
	{3527647232U, 19},
	{3527655424U, 19},
	{3527669760U, 21},
	{3527671808U, 16},
	{3527737344U, 16},
	{3527802880U, 16},
	{3527868416U, 17},
	{3527901184U, 17},
	{3527933952U, 19},
	{3527942144U, 19},
	{3527950336U, 18},
	{3527983104U, 19},
	{3527999488U, 18},
	{3528024064U, 19},
	{3528032256U, 19},
	{3528114176U, 19},
	{3528122368U, 19},
	{3528138752U, 19},
	{3528163328U, 19},
	{3528184832U, 22},
	{3528187904U, 22},
	{3528192000U, 20},
	{3528196096U, 19},
	{3528204288U, 19},
	{3528245248U, 19},
	{3528261632U, 19},
	{3528302592U, 20},
	{3528318976U, 19},
	{3528318976U, 20},
	{3528323072U, 20},
	{3528327680U, 24},
	{3528328192U, 22},
	{3528329216U, 21},
	{3528331264U, 20},
	{3528333056U, 24},
	{3528333312U, 24},
	{3528450048U, 19},
	{3528450048U, 20},
	{3528454144U, 20},
	{3528589312U, 16},
	{3528654848U, 16},
	{3528764160U, 24},
	{3528774656U, 24},
	{3528774912U, 24},
	{3528775168U, 24},
	{3528775424U, 24},
	{3528784384U, 24},
	{3528785920U, 16},
	{3528785920U, 18},
	{3528802304U, 18},
	{3528818688U, 18},
	{3528982528U, 17},
	{3528996864U, 21},
	{3528997376U, 24},
	{3529015296U, 18},
	{3529030656U, 22},
	{3529030656U, 24},
	{3529030912U, 24},
	{3529031424U, 24},
	{3529031680U, 19},
	{3529037824U, 24},
	{3529038592U, 24},
	{3529113600U, 16},
	{3529113600U, 17},
	{3529115392U, 24},
	{3529146368U, 17},
	{3529179136U, 16},
	{3529181184U, 24},
	{3529244672U, 18},
	{3529244672U, 24},
	{3529244928U, 24},
	{3529245184U, 24},
	{3529245440U, 24},
	{3529245696U, 24},
	{3529245952U, 24},
	{3529246208U, 24},
	{3529246464U, 24},
	{3529246720U, 24},
	{3529246976U, 24},
	{3529247232U, 24},
	{3529247744U, 24},
	{3529248000U, 24},
	{3529248256U, 24},
	{3529254912U, 24},
	{3529261056U, 18},
	{3529263360U, 24},
	{3529267968U, 24},
	{3529277184U, 24},
	{3529277440U, 17},
	{3529310208U, 17},
	{3529311744U, 23},
	{3529312256U, 21},
	{3529327616U, 24},
	{3529327872U, 24},
	{3529328128U, 24},
	{3529331456U, 24},
	{3529331712U, 22},
	{3529331712U, 24},
	{3529331968U, 24},
	{3529332224U, 24},
	{3529332480U, 24},
	{3529338880U, 20},
	{3529342976U, 24},
	{3529343232U, 24},
	{3529343488U, 24},
	{3529343744U, 24},
	{3529344000U, 22},
	{3529345024U, 24},
	{3529345280U, 24},
	{3529345536U, 24},
	{3529345792U, 24},
	{3529346048U, 24},
	{3529346304U, 24},
	{3529346560U, 24},
	{3529346816U, 24},
	{3529347072U, 24},
	{3529347328U, 24},
	{3529347584U, 24},
	{3529347840U, 24},
	{3529348096U, 24},
	{3529348352U, 24},
	{3529348608U, 24},
	{3529348864U, 24},
	{3529349120U, 23},
	{3529349632U, 24},
	{3529349888U, 24},
	{3529350144U, 24},
	{3529350400U, 24},
	{3529350656U, 24},
	{3529350912U, 24},
	{3529351168U, 24},
	{3529351424U, 24},
	{3529351680U, 24},
	{3529351936U, 24},
	{3529352192U, 24},
	{3529352448U, 24},
	{3529352704U, 24},
	{3529352960U, 24},
	{3529353216U, 24},
	{3529353472U, 24},
	{3529353728U, 24},
	{3529353984U, 24},
	{3529354240U, 24},
	{3529354496U, 24},
	{3529354752U, 24},
	{3529355008U, 24},
	{3529355264U, 24},
	{3529355520U, 24},
	{3529355776U, 24},
	{3529356032U, 24},
	{3529356288U, 24},
	{3529356544U, 24},
	{3529356800U, 24},
	{3529357056U, 24},
	{3529357312U, 24},
	{3529357568U, 24},
	{3529357824U, 24},
	{3529358080U, 24},
	{3529358336U, 24},
	{3529358592U, 24},
	{3529358848U, 24},
	{3529359104U, 24},
	{3529375744U, 19},
	{3529383936U, 19},
	{3529392128U, 18},
	{3529416704U, 19},
	{3529424896U, 19},
	{3529433088U, 19},
	{3529433856U, 24},
	{3529435136U, 24},
	{3529438720U, 24},
	{3529441280U, 16},
	{3529441280U, 17},
	{3529474048U, 17},
	{3529492224U, 24},
	{3529506816U, 17},
	{3529506816U, 18},
	{3529523200U, 18},
	{3529539584U, 17},
	{3529540608U, 24},
	{3529548288U, 24},
	{3529548544U, 24},
	{3529548800U, 24},
	{3529561856U, 24},
	{3529572352U, 17},
	{3529572352U, 18},
	{3529588736U, 18},
	{3529605120U, 19},
	{3529608192U, 23},
	{3529608704U, 24},
	{3529629696U, 20},
	{3529633792U, 20},
	{3529637888U, 18},
	{3529641984U, 21},
	{3529647616U, 24},
	{3529647872U, 24},
	{3529648128U, 22},
	{3529654272U, 18},
	{3529670656U, 18},
	{3529703424U, 16},
	{3529703424U, 17},
	{3529718784U, 24},
	{3529736192U, 17},
	{3529768960U, 17},
	{3529768960U, 18},
	{3529785344U, 18},
	{3529801728U, 17},
	{3529801728U, 18},
	{3529818112U, 18},
	{3529834496U, 18},
	{3529834496U, 19},
	{3529842688U, 19},
	{3529850880U, 18},
	{3529867264U, 18},
	{3529883648U, 19},
	{3529891840U, 20},
	{3529895936U, 21},
	{3529897984U, 22},
	{3529899008U, 23},
	{3529899520U, 23},
	{3529908224U, 19},
	{3529916416U, 19},
	{3529924608U, 19},
	{3529932800U, 17},
	{3529934848U, 22},
	{3529953280U, 21},
	{3529955328U, 22},
	{3529965568U, 17},
	{3529965568U, 18},
	{3529981952U, 18},
	{3530031104U, 16},
	{3530031104U, 17},
	{3530063872U, 17},
	{3530064896U, 24},
	{3530065152U, 24},
	{3530065408U, 24},
	{3530065664U, 24},
	{3530071040U, 22},
	{3530094848U, 24},
	{3530095104U, 24},
	{3530096640U, 16},
	{3530124288U, 24},
	{3530178560U, 18},
	{3530181632U, 22},
	{3530186752U, 21},
	{3530188800U, 22},
	{3530189824U, 23},
	{3530194944U, 18},
	{3530219520U, 19},
	{3530227712U, 17},
	{3530234880U, 24},
	{3530246912U, 24},
	{3530260480U, 17},
	{3530276864U, 20},
	{3530278656U, 24},
	{3530279168U, 24},
	{3530279424U, 24},
	{3530280960U, 24},
	{3530281216U, 24},
	{3530281472U, 24},
	{3530281728U, 24},
	{3530281984U, 22},
	{3530285056U, 20},
	{3530289152U, 22},
	{3530290176U, 23},
	{3530293248U, 16},
	{3530299904U, 24},
	{3530300160U, 24},
	{3530313728U, 22},
	{3530314752U, 24},
	{3530328320U, 24},
	{3530331392U, 24},
	{3530352128U, 24},
	{3530352384U, 24},
	{3530396928U, 24},
	{3530424320U, 17},
	{3530444800U, 21},
	{3530446848U, 22},
	{3530448896U, 24},
	{3530457088U, 17},
	{3530457088U, 18},
	{3530459136U, 23},
	{3530459648U, 24},
	{3530465280U, 20},
	{3530469376U, 22},
	{3530470400U, 23},
	{3530470912U, 23},
	{3530471424U, 21},
	{3530473472U, 19},
	{3530475520U, 22},
	{3530485760U, 22},
	{3530487808U, 22},
	{3530489088U, 24},
	{3530489856U, 17},
	{3530489856U, 18},
	{3530496768U, 24},
	{3530497024U, 24},
	{3530499072U, 24},
	{3530499328U, 24},
	{3530506240U, 18},
	{3530539008U, 19},
	{3530555392U, 17},
	{3530600704U, 24},
	{3530620928U, 16},
	{3530647552U, 24},
	{3530657792U, 23},
	{3530675712U, 23},
	{3530686464U, 18},
	{3530706944U, 20},
	{3530711040U, 19},
	{3530716416U, 24},
	{3530719232U, 17},
	{3530719232U, 18},
	{3530735616U, 18},
	{3530752000U, 20},
	{3530756096U, 20},
	{3530760192U, 19},
	{3530784768U, 19},
	{3530786816U, 22},
	{3530787840U, 22},
	{3530790400U, 24},
	{3530790656U, 24},
	{3530792960U, 19},
	{3530801152U, 19},
	{3530801152U, 24},
	{3530801408U, 24},
	{3530801664U, 24},
	{3530850304U, 17},
	{3530932224U, 18},
	{3530956800U, 19},
	{3530964992U, 18},
	{3530981376U, 17},
	{3530981376U, 18},
	{3530993408U, 24},
	{3530993920U, 24},
	{3530997760U, 18},
	{3531014144U, 17},
	{3531014144U, 18},
	{3531014144U, 20},
	{3531018240U, 22},
	{3531019264U, 23},
	{3531019776U, 24},
	{3531020288U, 21},
	{3531022336U, 22},
	{3531030528U, 20},
	{3531033600U, 22},
	{3531034624U, 22},
	{3531040256U, 23},
	{3531040768U, 21},
	{3531042816U, 24},
	{3531043328U, 24},
	{3531046912U, 17},
	{3531062272U, 22},
	{3531079680U, 16},
	{3531086080U, 24},
	{3531098368U, 24},
	{3531102208U, 24},
	{3531102464U, 24},
	{3531102720U, 24},
	{3531145216U, 17},
	{3531177984U, 17},
	{3531192064U, 24},
	{3531202304U, 24},
	{3531204608U, 24},
	{3531205376U, 24},
	{3531205632U, 24},
	{3531228160U, 24},
	{3531234816U, 24},
	{3531276288U, 16},
	{3531279872U, 24},
	{3531296768U, 24},
	{3531303936U, 24},
	{3531318528U, 24},
	{3531318784U, 23},
	{3531319296U, 24},
	{3531341824U, 16},
	{3531344896U, 24},
	{3531345152U, 24},
	{3531345408U, 24},
	{3531351040U, 24},
	{3531381248U, 24},
	{3531381504U, 24},
	{3531394048U, 24},
	{3531394304U, 24},
	{3531407360U, 17},
	{3531407360U, 24},
	{3531407616U, 24},
	{3531407872U, 24},
	{3531408128U, 24},
	{3531408384U, 24},
	{3531408640U, 24},
	{3531408896U, 24},
	{3531409152U, 24},
	{3531411456U, 20},
	{3531421696U, 22},
	{3531422720U, 22},
	{3531422720U, 23},
	{3531423232U, 23},
	{3531423744U, 21},
	{3531423744U, 22},
	{3531424768U, 22},
	{3531425792U, 22},
	{3531428352U, 24},
	{3531428864U, 22},
	{3531429888U, 21},
	{3531430144U, 24},
	{3531430400U, 23},
	{3531431936U, 21},
	{3531431936U, 23},
	{3531435008U, 22},
	{3531436032U, 20},
	{3531440128U, 17},
	{3531448320U, 24},
	{3531448576U, 24},
	{3531448832U, 24},
	{3531452416U, 21},
	{3531454464U, 24},
	{3531456512U, 24},
	{3531456768U, 24},
	{3531457024U, 24},
	{3531457280U, 24},
	{3531457536U, 24},
	{3531457792U, 24},
	{3531458048U, 24},
	{3531458304U, 24},
	{3531472896U, 17},
	{3531508736U, 24},
	{3531512576U, 24},
	{3531525632U, 24},
	{3531537920U, 24},
	{3531538432U, 19},
	{3531546624U, 20},
	{3531550720U, 21},
	{3531571200U, 18},
	{3531587584U, 18},
	{3531589888U, 24},
	{3531591680U, 21},
	{3531593728U, 22},
	{3531594752U, 23},
	{3531603968U, 16},
	{3531735040U, 16},
	{3531800576U, 17},
	{3531833344U, 17},
	{3531866112U, 18},
	{3531882496U, 19},
	{3531890688U, 19},
	{3531898880U, 17},
	{3531948032U, 19},
	{3531956224U, 19},
	{3531964416U, 19},
	{3531972608U, 19},
	{3531980800U, 18},
	{3531997184U, 20},
	{3532005376U, 19},
	{3532021760U, 19},
	{3532029952U, 19},
	{3532038144U, 19},
	{3532054528U, 19},
	{3532062720U, 20},
	{3532066816U, 20},
	{3532070912U, 20},
	{3532075008U, 21},
	{3532075776U, 24},
	{3532077056U, 21},
	{3532087296U, 19},
	{3532103680U, 19},
	{3532120064U, 19},
	{3532128256U, 16},
	{3532193792U, 16},
	{3532196864U, 22},
	{3532207360U, 24},
	{3532207616U, 24},
	{3532214528U, 24},
	{3532229120U, 24},
	{3532259328U, 16},
	{3532324864U, 17},
	{3532357632U, 17},
	{3532455936U, 20},
	{3532464128U, 19},
	{3532472320U, 19},
	{3532480512U, 19},
	{3532488704U, 19},
	{3532496896U, 19},
	{3532505088U, 20},
	{3532513280U, 19},
	{3532521472U, 18},
	{3532554240U, 19},
	{3532578816U, 19},
	{3532595200U, 19},
	{3532603392U, 19},
	{3532611584U, 19},
	{3532623872U, 20},
	{3532636160U, 19},
	{3532644352U, 19},
	{3532652544U, 16},
	{3532718080U, 16},
	{3532800000U, 18},
	{3532816384U, 17},
	{3532849152U, 16},
	{3532914688U, 16},
	{3532980224U, 16},
	{3533045760U, 16},
	{3533127680U, 18},
	{3533144064U, 17},
	{3533242368U, 17},
	{3533275136U, 17},
	{3533307904U, 16},
	{3533373440U, 17},
	{3533406208U, 19},
	{3533422592U, 19},
	{3533438976U, 22},
	{3533447168U, 19},
	{3533471744U, 19},
	{3533504512U, 19},
	{3533512704U, 19},
	{3533520896U, 20},
	{3533537280U, 19},
	{3533545472U, 24},
	{3533545728U, 24},
	{3533545984U, 24},
	{3533546240U, 24},
	{3533547008U, 24},
	{3533547520U, 24},
	{3533547776U, 24},
	{3533548288U, 24},
	{3533549568U, 24},
	{3533550080U, 24},
	{3533550336U, 24},
	{3533550592U, 24},
	{3533550848U, 24},
	{3533551104U, 24},
	{3533551616U, 23},
	{3533553664U, 19},
	{3533561856U, 19},
	{3533570048U, 19},
	{3533586432U, 19},
	{3533594624U, 20},
	{3533602816U, 20},
	{3533611008U, 20},
	{3533627392U, 19},
	{3533668352U, 17},
	{3533701120U, 16},
	{3533766656U, 16},
	{3533832192U, 16},
	{3533897728U, 16},
	{3533963264U, 16},
	{3534028800U, 16},
	{3534094336U, 19},
	{3534102528U, 19},
	{3534151680U, 19},
	{3534159872U, 19},
	{3534176256U, 19},
	{3534184448U, 19},
	{3534192640U, 18},
	{3534274560U, 18},
	{3534290944U, 17},
	{3534356480U, 18},
	{3534372864U, 18},
	{3534389248U, 17},
	{3534422016U, 19},
	{3534422016U, 20},
	{3534426112U, 20},
	{3534438400U, 19},
	{3534471168U, 19},
	{3534479360U, 19},
	{3534495744U, 19},
	{3534503936U, 18},
	{3534520320U, 18},
	{3534536704U, 19},
	{3534544896U, 20},
	{3534548480U, 23},
	{3534553088U, 19},
	{3534577664U, 19},
	{3534585856U, 22},
	{3534594048U, 19},
	{3534602240U, 19},
	{3534618624U, 18},
	{3534635008U, 18},
	{3534651392U, 17},
	{3534716928U, 23},
	{3534725120U, 19},
	{3534726144U, 24},
	{3534729984U, 24},
	{3534732288U, 24},
	{3534733312U, 19},
	{3534880768U, 16},
	{3534880768U, 17},
	{3534913536U, 17},
	{3534946304U, 16},
	{3534946304U, 17},
	{3534979072U, 17},
	{3535011840U, 19},
	{3535028224U, 19},
	{3535036416U, 19},
	{3535044608U, 18},
	{3535060992U, 19},
	{3535069184U, 19},
	{3535077376U, 19},
	{3535084544U, 24},
	{3535093760U, 18},
	{3535110144U, 18},
	{3535113728U, 23},
	{3535114240U, 22},
	{3535115264U, 22},
	{3535119360U, 23},
	{3535119872U, 24},
	{3535125504U, 23},
	{3535126016U, 24},
	{3535126528U, 19},
	{3535142912U, 16},
	{3535208448U, 16},
	{3535568896U, 18},
	{3535585280U, 19},
	{3535593472U, 19},
	{3535634432U, 19},
	{3535642624U, 21},
	{3535667200U, 16},
	{3535749120U, 18},
	{3535765504U, 19},
	{3535773696U, 19},
	{3535781888U, 19},
	{3535822848U, 19},
	{3535863808U, 20},
	{3535929344U, 16},
	{3536060416U, 16},
	{3536191488U, 19},
	{3536207872U, 18},
	{3536224256U, 17},
	{3536257024U, 18},
	{3536281600U, 19},
	{3536330752U, 19},
	{3536584704U, 16},
	{3536584704U, 17},
	{3536617472U, 17},
	{3536648192U, 22},
	{3536649216U, 22},
	{3536650240U, 18},
	{3536653056U, 24},
	{3536666624U, 19},
	{3536674816U, 19},
	{3536683008U, 17},
	{3536715776U, 16},
	{3536781312U, 16},
	{3536803584U, 24},
	{3536831232U, 24},
	{3536871424U, 19},
	{3536986112U, 22},
	{3536987136U, 22},
	{3536988160U, 22},
	{3536988928U, 24},
	{3537240064U, 21},
	{3537242112U, 21},
	{3537244160U, 21},
	{3537246208U, 21},
	{3537252352U, 20},
	{3537256448U, 20},
	{3537260544U, 20},
	{3537261568U, 22},
	{3537264640U, 21},
	{3537268736U, 20},
	{3537272832U, 20},
	{3537276928U, 20},
	{3537276928U, 24},
	{3537278976U, 21},
	{3537281024U, 20},
	{3537284096U, 22},
	{3537289216U, 20},
	{3537290496U, 24},
	{3537293312U, 21},
	{3537295360U, 22},
	{3537296384U, 23},
	{3537301504U, 20},
	{3537305600U, 21},
	{3537305856U, 24},
	{3537371136U, 16},
	{3537374464U, 24},
	{3537436672U, 17},
	{3537469440U, 19},
	{3537477632U, 19},
	{3537483520U, 24},
	{3537494016U, 19},
	{3537502208U, 18},
	{3537518592U, 19},
	{3537526784U, 19},
	{3537534976U, 18},
	{3537551360U, 19},
	{3537552128U, 24},
	{3537559552U, 19},
	{3537567744U, 19},
	{3537575936U, 19},
	{3537576960U, 24},
	{3537577216U, 24},
	{3537600512U, 18},
	{3537633280U, 19},
	{3537636608U, 24},
	{3537638656U, 24},
	{3537638912U, 24},
	{3537641472U, 19},
	{3537649664U, 19},
	{3537650944U, 24},
	{3537657856U, 19},
	{3537666048U, 19},
	{3537674240U, 19},
	{3537698816U, 17},
	{3537731584U, 19},
	{3537743872U, 20},
	{3537747968U, 19},
	{3537764352U, 15},
	{3537895424U, 17},
	{3537895424U, 18},
	{3537911808U, 18},
	{3537928192U, 19},
	{3537936384U, 19},
	{3537944576U, 18},
	{3537960960U, 16},
	{3538026496U, 15},
	{3538165760U, 19},
	{3538223104U, 19},
	{3538231296U, 19},
	{3538255872U, 19},
	{3538264064U, 19},
	{3538272256U, 19},
	{3538288640U, 17},
	{3538321408U, 17},
	{3538403328U, 19},
	{3538419712U, 16},
	{3538485248U, 18},
	{3538501632U, 19},
	{3538509824U, 19},
	{3538526208U, 19},
	{3538534400U, 19},
	{3538550784U, 16},
	{3538624512U, 19},
	{3538649088U, 19},
	{3538657280U, 19},
	{3538665472U, 18},
	{3538681856U, 19},
	{3538698240U, 19},
	{3538714624U, 19},
	{3538722816U, 19},
	{3538755584U, 19},
	{3538812928U, 19},
	{3538821120U, 19},
	{3538829312U, 18},
	{3538845696U, 17},
	{3538878464U, 19},
	{3538903040U, 19},
	{3538911232U, 17},
	{3538944000U, 16},
	{3539009536U, 17},
	{3539050496U, 20},
	{3539058688U, 19},
	{3539066880U, 19},
	{3539075072U, 16},
	{3539140608U, 18},
	{3539156992U, 19},
	{3539165184U, 19},
	{3539173376U, 17},
	{3539206144U, 17},
	{3539234816U, 20},
	{3539255296U, 20},
	{3539259392U, 20},
	{3539468288U, 16},
	{3539533824U, 17},
	{3539566592U, 18},
	{3539591168U, 19},
	{3539599360U, 18},
	{3539615744U, 18},
	{3539640320U, 19},
	{3539664896U, 17},
	{3539705856U, 19},
	{3539714048U, 20},
	{3539730432U, 18},
	{3539795968U, 19},
	{3539804160U, 19},
	{3539812352U, 19},
	{3539820544U, 19},
	{3539828736U, 18},
	{3539845120U, 19},
	{3539853312U, 19},
	{3539877888U, 18},
	{3539894272U, 17},
	{3539927040U, 17},
	{3539959808U, 19},
	{3539968000U, 19},
	{3539984384U, 19},
	{3539992576U, 16},
	{3540066304U, 19},
	{3540074496U, 18},
	{3540090880U, 19},
	{3540099072U, 23},
	{3540107264U, 19},
	{3540123648U, 17},
	{3540156416U, 19},
	{3540164608U, 19},
	{3540254720U, 16},
	{3540320256U, 16},
	{3540385792U, 16},
	{3540451328U, 18},
	{3540467712U, 20},
	{3540471808U, 20},
	{3540475904U, 19},
	{3540484096U, 18},
	{3540508672U, 19},
	{3540590592U, 19},
	{3540598784U, 18},
	{3540615168U, 18},
	{3540631552U, 19},
	{3540656128U, 19},
	{3540664320U, 19},
	{3540672512U, 19},
	{3540680704U, 17},
	{3540713472U, 16},
	{3540819968U, 19},
	{3540828160U, 20},
	{3540832256U, 21},
	{3540836352U, 19},
	{3540844544U, 17},
	{3540877312U, 19},
	{3540885504U, 19},
	{3540893696U, 19},
	{3540901888U, 19},
	{3540926464U, 18},
	{3540959232U, 19},
	{3540967424U, 19},
	{3540975616U, 19},
	{3540992000U, 19},
	{3541041152U, 15},
	{3541172224U, 16},
	{3541245952U, 19},
	{3541278720U, 19},
	{3541286912U, 19},
	{3541303296U, 16},
	{3541368832U, 16},
	{3541434368U, 16},
	{3541499904U, 16},
	{3542089728U, 16},
	{3542091520U, 24},
	{3542097920U, 24},
	{3542130688U, 24},
	{3542155264U, 17},
	{3542188032U, 17},
	{3542188544U, 24},
	{3542220800U, 16},
	{3542220800U, 17},
	{3542248960U, 24},
	{3542249216U, 24},
	{3542249472U, 24},
	{3542286336U, 18},
	{3542302720U, 19},
	{3542319104U, 17},
	{3542351872U, 22},
	{3542376448U, 19},
	{3542384640U, 22},
	{3542385664U, 22},
	{3542386688U, 22},
	{3542387712U, 22},
	{3542388736U, 22},
	{3542389760U, 22},
	{3542390784U, 21},
	{3542392832U, 19},
	{3542401024U, 22},
	{3542402048U, 22},
	{3542403072U, 22},
	{3542404096U, 22},
	{3542405120U, 20},
	{3542409216U, 19},
	{3542417408U, 17},
	{3542418944U, 24},
	{3542441216U, 24},
	{3542450176U, 18},
	{3542466560U, 19},
	{3542474752U, 19},
	{3542482944U, 16},
	{3542564864U, 18},
	{3542571520U, 24},
	{3542572800U, 24},
	{3542573056U, 21},
	{3542581248U, 22},
	{3542582272U, 22},
	{3542583296U, 22},
	{3542584320U, 22},
	{3542585344U, 20},
	{3542589440U, 19},
	{3542597632U, 19},
	{3542605824U, 19},
	{3542614016U, 16},
	{3542679552U, 19},
	{3542687744U, 19},
	{3542695936U, 19},
	{3542704128U, 19},
	{3542707200U, 24},
	{3542707456U, 24},
	{3542720512U, 19},
	{3542728704U, 19},
	{3542736896U, 22},
	{3542737920U, 22},
	{3542738944U, 22},
	{3542739968U, 22},
	{3542740992U, 22},
	{3542742016U, 22},
	{3542743040U, 22},
	{3542744064U, 22},
	{3542745088U, 17},
	{3542747648U, 24},
	{3542777856U, 19},
	{3542786048U, 19},
	{3542794240U, 19},
	{3542802432U, 19},
	{3542811392U, 24},
	{3542811648U, 24},
	{3542811904U, 24},
	{3542812416U, 24},
	{3542812672U, 21},
	{3542814720U, 21},
	{3542815744U, 24},
	{3542816000U, 24},
	{3542816256U, 24},
	{3542816512U, 24},
	{3542818048U, 24},
	{3542818304U, 23},
	{3542818816U, 19},
	{3542827008U, 21},
	{3542829056U, 22},
	{3542830080U, 22},
	{3542831104U, 20},
	{3542835200U, 20},
	{3542839296U, 21},
	{3542841344U, 24},
	{3542843392U, 20},
	{3542847488U, 20},
	{3542851584U, 20},
	{3542855680U, 20},
	{3542876160U, 16},
	{3542889472U, 24},
	{3542891264U, 24},
	{3542923264U, 24},
	{3542934528U, 24},
	{3542934784U, 24},
	{3542941696U, 19},
	{3542949888U, 19},
	{3542958080U, 19},
	{3542974464U, 18},
	{3542990848U, 18},
	{3543007232U, 16},
	{3543007232U, 17},
	{3543040000U, 17},
	{3543072768U, 18},
	{3543089152U, 24},
	{3543089408U, 24},
	{3543089664U, 24},
	{3543089920U, 24},
	{3543093248U, 20},
	{3543097344U, 19},
	{3543105536U, 19},
	{3543113728U, 24},
	{3543113984U, 24},
	{3543114240U, 24},
	{3543114496U, 24},
	{3543117824U, 20},
	{3543121920U, 19},
	{3543128576U, 24},
	{3543130112U, 19},
	{3543138304U, 16},
	{3543203840U, 17},
	{3543236608U, 17},
	{3543269376U, 16},
	{3543334912U, 16},
	{3543344896U, 24},
	{3543400448U, 18},
	{3543433216U, 17},
	{3543465984U, 16},
	{3543520512U, 24},
	{3543531520U, 15},
	{3543608576U, 24},
	{3543608832U, 24},
	{3543662592U, 17},
	{3543695360U, 18},
	{3543728128U, 16},
	{3543728128U, 17},
	{3543760896U, 17},
	{3543793664U, 16},
	{3543857152U, 24},
	{3543857408U, 24},
	{3543858688U, 24},
	{3543859200U, 16},
	{3543924736U, 16},
	{3543979264U, 24},
	{3543990272U, 18},
	{3544002560U, 24},
	{3544002816U, 24},
	{3544003072U, 24},
	{3544003328U, 24},
	{3544006656U, 18},
	{3544006656U, 19},
	{3544014848U, 19},
	{3544053504U, 24},
	{3544055808U, 18},
	{3544072192U, 18},
	{3544088576U, 17},
	{3544121344U, 19},
	{3544129536U, 19},
	{3544137728U, 19},
	{3544145920U, 19},
	{3544154112U, 17},
	{3544711168U, 16},
	{3544801280U, 19},
	{3544809472U, 19},
	{3544817664U, 20},
	{3544842240U, 16},
	{3544907776U, 16},
	{3544973312U, 19},
	{3544989696U, 20},
	{3545006080U, 20},
	{3545038848U, 18},
	{3545055232U, 18},
	{3545137152U, 19},
	{3545145344U, 19},
	{3545169920U, 19},
	{3545178112U, 20},
	{3545202688U, 19},
	{3545210880U, 19},
	{3546415104U, 17},
	{3546415104U, 18},
	{3546431488U, 18},
	{3546808320U, 14},
	{3546817024U, 24},
	{3546945024U, 24},
	{3547070464U, 16},
	{3547136000U, 16},
	{3547201536U, 16},
	{3547267072U, 17},
	{3547299840U, 20},
	{3547303936U, 20},
	{3547308032U, 20},
	{3547312128U, 20},
	{3547316224U, 22},
	{3547317248U, 22},
	{3547318272U, 21},
	{3547320320U, 20},
	{3547324416U, 19},
	{3547348992U, 19},
	{3547357184U, 19},
	{3547365376U, 17},
	{3547398144U, 17},
	{3547430912U, 17},
	{3547430912U, 18},
	{3547447296U, 18},
	{3547463680U, 16},
	{3547463680U, 17},
	{3547488768U, 24},
	{3547489024U, 24},
	{3547496448U, 17},
	{3547529216U, 19},
	{3547545600U, 19},
	{3547561984U, 18},
	{3547578368U, 19},
	{3547586560U, 19},
	{3547594752U, 18},
	{3547627520U, 19},
	{3547635712U, 22},
	{3547643904U, 20},
	{3547648000U, 20},
	{3547652096U, 19},
	{3547660288U, 16},
	{3547725824U, 16},
	{3547758592U, 24},
	{3547791360U, 16},
	{3547873280U, 19},
	{3547881472U, 19},
	{3547889664U, 18},
	{3547889664U, 19},
	{3547897856U, 19},
	{3547906048U, 19},
	{3547914240U, 19},
	{3547987968U, 15},
	{3548119040U, 16},
	{3548119040U, 19},
	{3548127232U, 19},
	{3548135424U, 19},
	{3548143616U, 19},
	{3548151808U, 19},
	{3548160000U, 19},
	{3548168192U, 19},
	{3548176384U, 19},
	{3548184576U, 18},
	{3548200960U, 19},
	{3548209152U, 19},
	{3548217344U, 19},
	{3548225536U, 19},
	{3548233728U, 21},
	{3548233728U, 22},
	{3548235776U, 21},
	{3548250112U, 16},
	{3548381184U, 22},
	{3548389376U, 19},
	{3548397568U, 19},
	{3548405760U, 20},
	{3548413952U, 17},
	{3548446208U, 23},
	{3548446720U, 16},
	{3548512256U, 16},
	{3548536832U, 19},
	{3548540416U, 23},
	{3548643328U, 20},
	{3548651520U, 19},
	{3548659712U, 19},
	{3548667904U, 19},
	{3548708864U, 17},
	{3548745728U, 20},
	{3548749824U, 19},
	{3548758016U, 19},
	{3548766208U, 20},
	{3548774400U, 16},
	{3548839936U, 17},
	{3548839936U, 19},
	{3548848128U, 19},
	{3548856320U, 19},
	{3548864512U, 19},
	{3548872704U, 17},
	{3549986816U, 19},
	{3550011392U, 19},
	{3550101504U, 19},
	{3550109696U, 20},
	{3550126080U, 21},
	{3550128128U, 21},
	{3550150656U, 20},
	{3550240768U, 20},
	{3550347264U, 19},
	{3550412800U, 19},
	{3550420992U, 19},
	{3550543872U, 19},
	{3550552064U, 20},
	{3550556160U, 24},
	{3550556416U, 24},
	{3550556672U, 23},
	{3550557184U, 22},
	{3550558208U, 21},
	{3550560256U, 18},
	{3550576640U, 18},
	{3550593024U, 18},
	{3550609408U, 17},
	{3550642176U, 18},
	{3550658560U, 19},
	{3550961664U, 19},
	{3550969856U, 19},
	{3551002624U, 16},
	{3551067904U, 24},
	{3551068160U, 16},
	{3551125760U, 24},
	{3551133696U, 16},
	{3551199232U, 16},
	{3551251968U, 24},
	{3551293440U, 20},
	{3551301632U, 21},
	{3551303680U, 21},
	{3551309824U, 21},
	{3551311872U, 21},
	{3551313920U, 20},
	{3551322112U, 20},
	{3551326208U, 20},
	{3551330304U, 17},
	{3551382528U, 24},
	{3551395840U, 20},
	{3551404032U, 21},
	{3551406080U, 22},
	{3551407104U, 23},
	{3551407616U, 23},
	{3551408128U, 20},
	{3551412224U, 19},
	{3551420416U, 19},
	{3551461376U, 16},
	{3551526912U, 14},
	{3551534592U, 24},
	{3551682560U, 24},
	{3551683328U, 24},
	{3551789056U, 16},
	{3551849216U, 24},
	{3551854592U, 16},
	{3551913728U, 24},
	{3551918336U, 24},
	{3551920128U, 16},
	{3551985664U, 16},
	{3552012800U, 24},
	{3552013056U, 24},
	{3552013312U, 24},
	{3552051200U, 15},
	{3552051200U, 16},
	{3552116736U, 16},
	{3552182272U, 16},
	{3552247808U, 16},
	{3552313344U, 17},
	{3552378880U, 17},
	{3552411648U, 19},
	{3552419840U, 19},
	{3552428032U, 19},
	{3552444416U, 16},
	{3552444416U, 17},
	{3552477184U, 17},
	{3552509952U, 16},
	{3552509952U, 17},
	{3552542720U, 17},
	{3552575488U, 13},
	{3552575488U, 24},
	{3552587008U, 24},
	{3552793856U, 24},
	{3553099776U, 13},
	{3553522432U, 24},
	{3553624064U, 14},
	{3553775360U, 24},
	{3553775616U, 21},
	{3553780480U, 24},
	{3553781248U, 24},
	{3554148352U, 13},
	{3554203648U, 24},
	{3554215936U, 24},
	{3554216192U, 24},
	{3554216448U, 24},
	{3554216704U, 24},
	{3554216960U, 24},
	{3554217216U, 24},
	{3554217472U, 24},
	{3554217728U, 24},
	{3554218240U, 24},
	{3554218496U, 24},
	{3554219008U, 24},
	{3554219264U, 24},
	{3554219520U, 24},
	{3554267648U, 23},
	{3554351104U, 24},
	{3554658304U, 24},
	{3554658560U, 24},
	{3554658816U, 24},
	{3554659072U, 24},
	{3554659328U, 24},
	{3554659584U, 24},
	{3554672640U, 13},
	{3554823424U, 24},
	{3555262464U, 18},
	{3555278848U, 20},
	{3555295232U, 18},
	{3555328000U, 17},
	{3555360768U, 17},
	{3555442688U, 21},
	{3555444736U, 21},
	{3555446784U, 22},
	{3555447808U, 23},
	{3555448320U, 23},
	{3555448832U, 21},
	{3555450624U, 24},
	{3555450880U, 19},
	{3555467264U, 20},
	{3555475456U, 18},
	{3555491840U, 19},
	{3555500032U, 19},
	{3555516416U, 19},
	{3555524608U, 21},
	{3555526656U, 22},
	{3555527680U, 23},
	{3555528192U, 23},
	{3555528704U, 22},
	{3555529728U, 22},
	{3555532800U, 20},
	{3555536896U, 20},
	{3555545088U, 20},
	{3555549184U, 20},
	{3555557376U, 20},
	{3555565568U, 20},
	{3555569664U, 20},
	{3555573760U, 20},
	{3555581952U, 20},
	{3555586048U, 20},
	{3555590144U, 20},
	{3555594240U, 21},
	{3555596288U, 21},
	{3555598336U, 19},
	{3555606528U, 19},
	{3555614720U, 19},
	{3555622912U, 20},
	{3555627008U, 20},
	{3555635200U, 20},
	{3555651584U, 20},
	{3555655424U, 24},
	{3555655680U, 17},
	{3555688448U, 18},
	{3555786752U, 17},
	{3555852288U, 17},
	{3555857408U, 24},
	{3555857664U, 24},
	{3555917824U, 16},
	{3556048896U, 17},
	{3556114432U, 15},
	{3556245504U, 16},
	{3556245504U, 17},
	{3556278272U, 17},
	{3556376576U, 15},
	{3556376576U, 16},
	{3556442112U, 16},
	{3556507648U, 15},
	{3556507648U, 16},
	{3556573184U, 16},
	{3556638720U, 18},
	{3556671488U, 18},
	{3556704256U, 19},
	{3556720640U, 20},
	{3556724736U, 22},
	{3556725760U, 23},
	{3556726272U, 23},
	{3556726784U, 22},
	{3556727808U, 23},
	{3556728320U, 23},
	{3556737024U, 19},
	{3556753408U, 21},
	{3556755456U, 21},
	{3556835328U, 19},
	{3556941824U, 19},
	{3557007360U, 19},
	{3557048320U, 19},
	{3557085184U, 24},
	{3557105664U, 19},
	{3557244928U, 19},
	{3557335040U, 19},
	{3557384192U, 19},
	{3557384192U, 22},
	{3557400576U, 19},
	{3557416960U, 19},
	{3557548032U, 19},
	{3557588992U, 19},
	{3557638144U, 19},
	{3557703680U, 19},
	{3557710080U, 24},
	{3557711872U, 19},
	{3557769216U, 19},
	{3557826560U, 20},
	{3557830656U, 22},
	{3557831680U, 22},
	{3557832704U, 21},
	{3557867520U, 19},
	{3557892096U, 19},
	{3557916672U, 19},
	{3557933056U, 19},
	{3557974016U, 19},
	{3558023168U, 19},
	{3558039552U, 19},
	{3558137856U, 19},
	{3558146048U, 19},
	{3558195200U, 19},
	{3558197248U, 23},
	{3558197760U, 23},
	{3558203392U, 19},
	{3558211584U, 19},
	{3558219776U, 19},
	{3558236160U, 24},
	{3558260736U, 19},
	{3558277120U, 19},
	{3558391808U, 19},
	{3558408192U, 19},
	{3558465536U, 19},
	{3558555648U, 18},
	{3558571008U, 24},
	{3558571520U, 24},
	{3558604800U, 20},
	{3558608896U, 20},
	{3558735872U, 19},
	{3558744064U, 19},
	{3558801408U, 19},
	{3558817792U, 19},
	{3558825984U, 24},
	{3558828544U, 24},
	{3558850560U, 21},
	{3558852608U, 21},
	{3558854400U, 24},
	{3558924288U, 19},
	{3559038976U, 19},
	{3559071744U, 19},
	{3559096576U, 24},
	{3559096832U, 23},
	{3559097344U, 22},
	{3559098624U, 24},
	{3559098880U, 24},
	{3559099392U, 24},
	{3559099904U, 23},
	{3559100416U, 22},
	{3559101952U, 24},
	{3559137280U, 19},
	{3559153664U, 19},
	{3559202816U, 19},
	{3559211008U, 19},
	{3559301120U, 19},
	{3559383040U, 19},
	{3559399424U, 19},
	{3559401472U, 23},
	{3559402496U, 24},
	{3559473152U, 18},
	{3559489536U, 19},
	{3559497728U, 19},
	{3559514112U, 19},
	{3559522304U, 19},
	{3559538688U, 19},
	{3559539712U, 22},
	{3559540736U, 22},
	{3559541760U, 23},
	{3559542272U, 23},
	{3559542784U, 22},
	{3559543808U, 22},
	{3559544832U, 23},
	{3559545344U, 23},
	{3559545856U, 23},
	{3559546368U, 23},
	{3559620608U, 19},
	{3559628800U, 19},
	{3559653376U, 18},
	{3559800832U, 19},
	{3559890944U, 19},
	{3559923712U, 19},
	{3559972864U, 19},
	{3560013824U, 18},
	{3560013824U, 19},
	{3560022016U, 19},
	{3560030208U, 19},
	{3560038400U, 19},
	{3560087552U, 19},
	{3560103936U, 19},
	{3560120320U, 19},
	{3560243200U, 19},
	{3560349696U, 19},
	{3560349696U, 24},
	{3560398848U, 19},
	{3560413440U, 24},
	{3560439808U, 19},
	{3560439808U, 24},
	{3560440064U, 24},
	{3560440320U, 24},
	{3560440576U, 24},
	{3560441088U, 24},
	{3560441344U, 24},
	{3560441600U, 24},
	{3560442112U, 24},
	{3560443136U, 24},
	{3560443392U, 24},
	{3560443904U, 22},
	{3560445440U, 23},
	{3560445952U, 21},
	{3560448000U, 19},
	{3560456192U, 18},
	{3560480768U, 19},
	{3560497152U, 19},
	{3560514048U, 24},
	{3560579072U, 19},
	{3560603648U, 19},
	{3560608000U, 24},
	{3560608256U, 24},
	{3560608512U, 24},
	{3560652800U, 19},
	{3560685568U, 19},
	{3560726528U, 19},
	{3560767488U, 16},
	{3560833024U, 19},
	{3561111552U, 19},
	{3561127936U, 19},
	{3561152512U, 19},
	{3561185280U, 20},
	{3561189376U, 24},
	{3561189632U, 24},
	{3561189888U, 24},
	{3561190144U, 24},
	{3561190400U, 24},
	{3561208832U, 22},
	{3561209856U, 19},
	{3561267200U, 19},
	{3561332736U, 19},
	{3561373696U, 19},
	{3561381888U, 19},
	{3561480192U, 19},
	{3561480192U, 22},
	{3561484288U, 22},
	{3561487360U, 22},
	{3561562112U, 19},
	{3561652224U, 18},
	{3561742336U, 19},
	{3561783296U, 19},
	{3561807872U, 19},
	{3561816064U, 19},
	{3561857024U, 19},
	{3561906176U, 19},
	{3561979904U, 19},
	{3562004480U, 19},
	{3562029056U, 19},
	{3562037248U, 19},
	{3562045440U, 19},
	{3562143744U, 19},
	{3562160128U, 19},
	{3562217472U, 19},
	{3562299392U, 19},
	{3562397696U, 19},
	{3562430464U, 19},
	{3562463232U, 19},
	{3562536960U, 19},
	{3562577920U, 19},
	{3562586112U, 19},
	{3562594304U, 19},
	{3562602496U, 19},
	{3562643456U, 19},
	{3562644480U, 24},
	{3562676224U, 20},
	{3562684416U, 19},
	{3562708992U, 19},
	{3562724352U, 22},
	{3562733568U, 19},
	{3562815488U, 19},
	{3562848256U, 22},
	{3563044864U, 19},
	{3563068416U, 23},
	{3563094016U, 19},
	{3563126784U, 19},
	{3563167744U, 19},
	{3563192320U, 20},
	{3563225088U, 19},
	{3563225344U, 24},
	{3563225600U, 24},
	{3563226624U, 24},
	{3563227136U, 24},
	{3563227904U, 24},
	{3563228160U, 24},
	{3563228416U, 24},
	{3563228672U, 24},
	{3563228928U, 24},
	{3563229184U, 24},
	{3563229440U, 24},
	{3563229696U, 24},
	{3563229952U, 24},
	{3563230720U, 24},
	{3563232512U, 24},
	{3563232768U, 24},
	{3563241472U, 21},
	{3563242496U, 24},
	{3563243776U, 24},
	{3563249408U, 24},
	{3563249664U, 19},
	{3563250688U, 24},
	{3563251712U, 21},
	{3563323392U, 19},
	{3563348480U, 24},
	{3563380736U, 19},
	{3563405312U, 19},
	{3563438080U, 19},
	{3563470848U, 22},
	{3563471872U, 24},
	{3563503616U, 20},
	{3563511808U, 19},
	{3563536384U, 19},
	{3563601920U, 21},
	{3563603968U, 22},
	{3563604992U, 22},
	{3563683840U, 19},
	{3563765760U, 18},
	{3563782144U, 19},
	{3563814912U, 19},
	{3563847680U, 19},
	{3563849728U, 21},
	{3563850240U, 23},
	{3563851776U, 22},
	{3563852800U, 22},
	{3563864064U, 19},
	{3563880448U, 20},
	{3563884544U, 20},
	{3563970560U, 24},
	{3563995136U, 24},
	{3563995392U, 24},
	{3563995648U, 24},
	{3563995904U, 24},
	{3563996160U, 24},
	{3563996416U, 24},
	{3563996672U, 24},
	{3563996928U, 24},
	{3563997184U, 24},
	{3563997440U, 24},
	{3563997696U, 24},
	{3563997952U, 24},
	{3563998208U, 24},
	{3563998464U, 24},
	{3563998720U, 24},
	{3563998976U, 24},
	{3563999232U, 24},
	{3563999488U, 24},
	{3563999744U, 24},
	{3564000000U, 24},
	{3564000256U, 24},
	{3564000512U, 24},
	{3564000768U, 24},
	{3564002048U, 24},
	{3564002560U, 24},
	{3564002816U, 24},
	{3564003072U, 24},
	{3564052480U, 19},
	{3564093440U, 19},
	{3564176896U, 23},
	{3564183552U, 19},
	{3564185600U, 22},
	{3564191744U, 19},
	{3564224512U, 19},
	{3564232704U, 19},
	{3564306432U, 19},
	{3564331008U, 19},
	{3564355584U, 19},
	{3564396544U, 19},
	{3564453888U, 19},
	{3564519424U, 19},
	{3564544000U, 19},
	{3564568576U, 19},
	{3564642304U, 19},
	{3564650496U, 18},
	{3564691456U, 20},
	{3564699392U, 24},
	{3564699648U, 19},
	{3564724224U, 19},
	{3564789760U, 19},
	{3564838912U, 19},
	{3564986368U, 19},
	{3565076480U, 19},
	{3565092864U, 19},
	{3565096960U, 20},
	{3565098240U, 24},
	{3565098496U, 24},
	{3565098752U, 24},
	{3565099008U, 21},
	{3565101056U, 19},
	{3565240320U, 24},
	{3565420544U, 16},
	{3565518848U, 18},
	{3565535232U, 22},
	{3565944832U, 16},
	{3566010368U, 18},
	{3566026752U, 19},
	{3566034944U, 19},
	{3566043136U, 17},
	{3566403584U, 17},
	{3566529536U, 24},
	{3567190016U, 19},
	{3567198208U, 19},
	{3567206400U, 18},
	{3567353856U, 17},
	{3567435776U, 20},
	{3567436544U, 24},
	{3567436800U, 24},
	{3567439872U, 20},
	{3567441920U, 22},
	{3567443968U, 22},
	{3567446016U, 24},
	{3567446272U, 24},
	{3567446784U, 24},
	{3567447040U, 22},
	{3567448064U, 20},
	{3567448064U, 24},
	{3567452160U, 16},
	{3567452160U, 17},
	{3567461120U, 24},
	{3567461376U, 24},
	{3567503360U, 22},
	{3567665152U, 19},
	{3567673344U, 19},
	{3567681536U, 17},
	{3567779840U, 16},
	{3567845376U, 18},
	{3568107520U, 16},
	{3568404224U, 24},
	{3568812032U, 18},
	{3569123328U, 19},
	{3569131520U, 19},
	{3569135616U, 20},
	{3569188864U, 17},
	{3569715200U, 21},
	{3569717248U, 20},
	{3569721344U, 19},
	{3570073600U, 19},
	{3570171904U, 18},
	{3570335744U, 16},
	{3570630656U, 17},
	{3571515392U, 19},
	{3571646464U, 16},
	{3571712000U, 15},
	{3571843072U, 15},
	{3572236288U, 16},
	{3572240128U, 24},
	{3572240640U, 24},
	{3572256512U, 24},
	{3572367360U, 16},
	{3572432896U, 17},
	{3572465664U, 17},
	{3572498432U, 16},
	{3572826112U, 17},
	{3572858880U, 17},
	{3573153792U, 16},
	{3573284864U, 15},
	{3573284864U, 16},
	{3573284864U, 22},
	{3573285888U, 22},
	{3573327872U, 23},
	{3573350400U, 17},
	{3573350400U, 22},
	{3573351424U, 22},
	{3573383168U, 18},
	{3573399552U, 18},
	{3573612544U, 16},
	{3573678080U, 16},
	{3573735424U, 19},
	{3573735424U, 20},
	{3573874688U, 16},
	{3573885440U, 23},
	{3573885952U, 22},
	{3573886976U, 20},
	{3573907456U, 17},
	{3573940224U, 15},
	{3574169600U, 17},
	{3574202368U, 16},
	{3574530048U, 17},
	{3574562816U, 18},
	{3574579200U, 19},
	{3574587392U, 19},
	{3574726656U, 16},
	{3575578624U, 16},
	{3575840768U, 16},
	{3575865344U, 19},
	{3575967488U, 24},
	{3575967744U, 20},
	{3575971840U, 16},
	{3576365056U, 16},
	{3576889344U, 16},
	{3576987648U, 17},
	{3576987648U, 20},
	{3577004032U, 21},
	{3577151488U, 19},
	{3577184256U, 17},
	{3577479168U, 16},
	{3577611264U, 24},
	{3578265600U, 16},
	{3578396672U, 16},
	{3578462208U, 16},
	{3578668800U, 24},
	{3578669056U, 22},
	{3578986496U, 18},
	{3579445248U, 17},
	{3579576320U, 17},
	{3579707392U, 18},
	{3580362752U, 14},
	{3580887040U, 14},
	{3581411328U, 14},
	{3581434368U, 24},
	{3581489664U, 24},
	{3581943808U, 19},
	{3581968384U, 19},
	{3581976576U, 19},
	{3582009344U, 19},
	{3582017536U, 19},
	{3582074880U, 19},
	{3582107648U, 19},
	{3582140416U, 19},
	{3582459904U, 19},
	{3582492672U, 19},
	{3582525440U, 19},
	{3582541824U, 19},
	{3582541824U, 24},
	{3582542080U, 24},
	{3582542592U, 24},
	{3582543104U, 24},
	{3582543616U, 24},
	{3582544128U, 24},
	{3582544384U, 24},
	{3582545408U, 24},
	{3582549760U, 24},
	{3582566400U, 22},
	{3582568448U, 22},
	{3582570496U, 22},
	{3582572544U, 22},
	{3582573568U, 22},
	{3582574592U, 19},
	{3582590976U, 19},
	{3582771200U, 19},
	{3582795776U, 19},
	{3582803968U, 19},
	{3582853120U, 19},
	{3582885888U, 19},
	{3582951424U, 19},
	{3582992384U, 19},
	{3583082496U, 19},
	{3583197184U, 24},
	{3583197440U, 24},
	{3583221760U, 19},
	{3583262720U, 21},
	{3583295488U, 19},
	{3583311872U, 19},
	{3583639552U, 19},
	{3583677184U, 24},
	{3583770624U, 19},
	{3583852544U, 19},
	{3583885312U, 19},
	{3583950848U, 19},
	{3584040960U, 19},
	{3584049152U, 19},
	{3584081920U, 19},
	{3584083712U, 24},
	{3584114688U, 19},
	{3584116224U, 24},
	{3584180224U, 19},
	{3584299008U, 24},
	{3584327680U, 19},
	{3584360448U, 19},
	{3584393216U, 19},
	{3584425984U, 22},
	{3584429568U, 24},
	{3584430336U, 24},
	{3584431104U, 24},
	{3584431360U, 24},
	{3584431616U, 24},
	{3584431872U, 24},
	{3584432128U, 24},
	{3584433408U, 24},
	{3584606208U, 19},
	{3584737280U, 19},
	{3584802816U, 19},
	{3584827392U, 19},
	{3584999424U, 19},
	{3585081344U, 19},
	{3585130496U, 19},
	{3585245184U, 19},
	{3585425408U, 19},
	{3585474560U, 19},
	{3585490944U, 19},
	{3585687552U, 19},
	{3585703936U, 19},
	{3585720320U, 19},
	{3585769472U, 19},
	{3585785856U, 19},
	{3585998848U, 19},
	{3586211840U, 18},
	{3586260992U, 18},
	{3586424832U, 18},
	{3586625536U, 20},
	{3586654208U, 19},
	{3586654464U, 24},
	{3586719744U, 17},
	{3587112960U, 18},
	{3587129344U, 18},
	{3587194880U, 18},
	{3587473408U, 18},
	{3587506176U, 18},
	{3587522560U, 18},
	{3587571712U, 20},
	{3587735552U, 18},
	{3587801088U, 18},
	{3587899392U, 18},
	{3587915008U, 24},
	{3587915264U, 24},
	{3588063232U, 20},
	{3588067328U, 21},
	{3588069376U, 22},
	{3588070656U, 24},
	{3588071168U, 24},
	{3588096000U, 19},
	{3588112384U, 18},
	{3588374528U, 18},
	{3588423680U, 18},
	{3588718592U, 19},
	{3588780032U, 24},
	{3589013504U, 19},
	{3589029888U, 18},
	{3589220864U, 24},
	{3589224448U, 22},
	{3589225472U, 24},
	{3589472256U, 19},
	{3589513216U, 19},
	{3589701632U, 18},
	{3589865472U, 18},
	{3589898240U, 18},
	{3590012928U, 18},
	{3590160384U, 18},
	{3590258688U, 18},
	{3590258688U, 19},
	{3590275072U, 18},
	{3590520832U, 24},
	{3590533632U, 24},
	{3590560000U, 24},
	{3590560256U, 24},
	{3607167232U, 24},
	{3607167488U, 24},
	{3607167744U, 24},
	{3607168000U, 24},
	{3607169024U, 24},
	{3607169280U, 24},
	{3607169536U, 24},
	{3607170048U, 24},
	{3607170560U, 24},
	{3607170816U, 24},
	{3607175424U, 24},
	{3623985152U, 20},
	{3623994368U, 22},
	{3624011776U, 23},
	{3624019968U, 23},
	{3624033280U, 23},
	{3624033792U, 24},
	{3624056832U, 23},
	{3624057344U, 24},
	{3624120320U, 22},
	{3624208640U, 24},
	{3624210432U, 20},
	{3624215552U, 22},
	{3624229888U, 23},
	{3624289280U, 24},
	{3624337408U, 19},
	{3624345344U, 24},
	{3624345600U, 20},
	{3624386560U, 19},
	{3624402944U, 18},
	{3624408064U, 22},
	{3624409088U, 22},
	{3624411136U, 21},
	{3624509440U, 24},
	{3624509696U, 24},
	{3624509952U, 24},
	{3624510208U, 24},
	{3624510464U, 24},
	{3624510720U, 24},
	{3624510976U, 24},
	{3624511232U, 24},
	{3624511488U, 24},
	{3624511744U, 24},
	{3624512000U, 24},
	{3624512512U, 24},
	{3624512768U, 24},
	{3624513024U, 24},
	{3624513280U, 24},
	{3624534016U, 19},
	{3624550400U, 22},
	{3624551424U, 24},
	{3624552192U, 24},
	{3624552448U, 22},
	{3624553472U, 23},
	{3624587264U, 20},
	{3624665088U, 18},
	{3624681472U, 18},
	{3624697856U, 20},
	{3624714240U, 20},
	{3624718336U, 20},
	{3624782848U, 22},
	{3624788992U, 23},
	{3624792064U, 23},
	{3624812544U, 20},
	{3624813024U, 29},
	{3624813040U, 30},
	{3624813048U, 30},
	{3624813052U, 30},
	{3624820736U, 20},
	{3624845312U, 20},
	{3624853504U, 20},
	{3624861696U, 17},
	{3624894464U, 19},
	{3624902656U, 19},
	{3624910848U, 19},
	{3624919040U, 19},
	{3624992768U, 19},
	{3625000960U, 19},
	{3625009152U, 19},
	{3625012224U, 24},
	{3625152256U, 24},
	{3625156608U, 19},
	{3625230336U, 21},
	{3625232384U, 22},
	{3625234432U, 23},
	{3625238272U, 24},
	{3625254912U, 24},
	{3625255168U, 24},
	{3625255424U, 24},
	{3625305088U, 24},
	{3625306368U, 24},
	{3625306624U, 24},
	{3625307648U, 23},
	{3625312256U, 20},
	{3625312256U, 22},
	{3625313280U, 24},
	{3625313536U, 24},
	{3625314304U, 23},
	{3625314560U, 24},
	{3625315328U, 24},
	{3625320448U, 19},
	{3625328640U, 20},
	{3625353216U, 17},
	{3625424896U, 21},
	{3625438464U, 24},
	{3625443328U, 21},
	{3625447520U, 27},
	{3625467904U, 20},
	{3625492480U, 20},
	{3625566208U, 21},
	{3625568256U, 22},
	{3625569280U, 24},
	{3625569536U, 24},
	{3625569792U, 24},
	{3625570048U, 24},
	{3625574400U, 19},
	{3625582592U, 18},
	{3625598976U, 20},
	{3625603072U, 20},
	{3625680896U, 19},
	{3625689088U, 20},
	{3625693184U, 20},
	{3625697280U, 20},
	{3625713664U, 15},
	{3625713664U, 21},
	{3625722368U, 24},
	{3625723392U, 24},
	{3625723648U, 24},
	{3625725440U, 24},
	{3625725952U, 20},
	{3625730048U, 22},
	{3625731328U, 24},
	{3625731584U, 23},
	{3625734144U, 20},
	{3625738752U, 24},
	{3625740288U, 24},
	{3625740800U, 24},
	{3625741056U, 24},
	{3625741568U, 24},
	{3625744384U, 24},
	{3625747200U, 24},
	{3625749248U, 24},
	{3625752320U, 24},
	{3625752576U, 24},
	{3625760768U, 24},
	{3625762816U, 22},
	{3625770752U, 24},
	{3625776128U, 24},
	{3625777408U, 24},
	{3625777920U, 24},
	{3625779712U, 24},
	{3625783296U, 23},
	{3625792000U, 24},
	{3625792512U, 23},
	{3625797376U, 24},
	{3625799168U, 23},
	{3625799680U, 24},
	{3625801728U, 24},
	{3625807360U, 23},
	{3625818368U, 24},
	{3625820672U, 24},
	{3625821184U, 24},
	{3625822976U, 24},
	{3625826304U, 24},
	{3625826560U, 24},
	{3625831424U, 24},
	{3625834496U, 24},
	{3625834752U, 24},
	{3625840640U, 24},
	{3625943040U, 19},
	{3625959424U, 20},
	{3625975808U, 16},
	{3625975808U, 19},
	{3625978368U, 23},
	{3625982976U, 23},
	{3625984000U, 19},
	{3625992192U, 19},
	{3625996288U, 23},
	{3626000384U, 19},
	{3626004992U, 24},
	{3626005248U, 24},
	{3626006528U, 24},
	{3626008576U, 19},
	{3626016768U, 19},
	{3626021888U, 22},
	{3626024960U, 19},
	{3626024960U, 24},
	{3626035200U, 22},
	{3626037248U, 22},
	{3626040320U, 23},
	{3626041344U, 16},
	{3626041344U, 19},
	{3626043648U, 24},
	{3626044672U, 24},
	{3626045440U, 22},
	{3626049536U, 19},
	{3626056704U, 23},
	{3626057728U, 19},
	{3626063360U, 24},
	{3626065920U, 19},
	{3626075136U, 22},
	{3626078720U, 23},
	{3626079232U, 22},
	{3626080000U, 24},
	{3626080256U, 23},
	{3626080768U, 23},
	{3626081280U, 23},
	{3626082304U, 19},
	{3626090496U, 19},
	{3626093568U, 22},
	{3626098688U, 19},
	{3626101760U, 22},
	{3626102784U, 22},
	{3626103808U, 22},
	{3626106880U, 19},
	{3626109312U, 25},
	{3626109440U, 24},
	{3626109952U, 24},
	{3626110304U, 28},
	{3626110320U, 28},
	{3626114720U, 27},
	{3626115072U, 19},
	{3626115072U, 20},
	{3626119168U, 20},
	{3626120624U, 28},
	{3626122240U, 22},
	{3626122240U, 23},
	{3626122752U, 23},
	{3626122992U, 28},
	{3626123264U, 19},
	{3626125312U, 22},
	{3626131456U, 19},
	{3626139648U, 19},
	{3626139648U, 20},
	{3626140224U, 26},
	{3626143552U, 27},
	{3626143744U, 20},
	{3626147840U, 20},
	{3626151936U, 20},
	{3626156032U, 19},
	{3626164224U, 19},
	{3626165760U, 23},
	{3626172416U, 19},
	{3626173440U, 24},
	{3626174688U, 28},
	{3626174720U, 26},
	{3626180608U, 19},
	{3626186752U, 23},
	{3626188800U, 20},
	{3626192896U, 20},
	{3626196992U, 20},
	{3626201088U, 20},
	{3626205184U, 19},
	{3626213376U, 20},
	{3626217472U, 20},
	{3626221568U, 20},
	{3626225664U, 20},
	{3626237952U, 18},
	{3626237952U, 20},
	{3626242048U, 21},
	{3626244096U, 21},
	{3626246144U, 20},
	{3626250240U, 20},
	{3626254336U, 20},
	{3626258432U, 20},
	{3626262528U, 19},
	{3626303488U, 18},
	{3626305536U, 23},
	{3626306048U, 24},
	{3626328064U, 22},
	{3626329600U, 23},
	{3626331648U, 23},
	{3626369024U, 19},
	{3626377216U, 20},
	{3626385408U, 20},
	{3626393600U, 20},
	{3626418176U, 19},
	{3626426368U, 23},
	{3626434560U, 19},
	{3626450944U, 19},
	{3626459136U, 20},
	{3626491904U, 20},
	{3626496000U, 20},
	{3626496000U, 24},
	{3626508288U, 20},
	{3626512384U, 22},
	{3626513408U, 22},
	{3626549248U, 20},
	{3626565632U, 17},
	{3626565632U, 20},
	{3626587392U, 24},
	{3626592768U, 24},
	{3626593024U, 24},
	{3626631168U, 16},
	{3626646016U, 24},
	{3626649600U, 23},
	{3626651136U, 23},
	{3626651648U, 23},
	{3626652672U, 24},
	{3626655488U, 24},
	{3626655744U, 24},
	{3626656000U, 24},
	{3626659072U, 24},
	{3626762240U, 16},
	{3626764288U, 22},
	{3626765312U, 24},
	{3626774528U, 22},
	{3626778624U, 22},
	{3626779648U, 22},
	{3626791424U, 23},
	{3626793728U, 24},
	{3626901504U, 19},
	{3626909696U, 19},
	{3626950656U, 19},
	{3626958848U, 20},
	{3626962944U, 20},
	{3626983424U, 24},
	{3626983936U, 24},
	{3626984192U, 24},
	{3626984448U, 23},
	{3626985472U, 24},
	{3626985728U, 24},
	{3626985984U, 24},
	{3626987264U, 24},
	{3626991616U, 19},
	{3626999808U, 19},
	{3627040768U, 20},
	{3627040768U, 23},
	{3627081728U, 19},
	{3627098112U, 19},
	{3627110400U, 20},
	{3627110400U, 21},
	{3627112448U, 21},
	{3627141632U, 23},
	{3627142144U, 23},
	{3627155456U, 16},
	{3627220992U, 17},
	{3627253760U, 19},
	{3627286528U, 19},
	{3627287552U, 24},
	{3627287808U, 24},
	{3627288064U, 24},
	{3627288320U, 24},
	{3627289088U, 24},
	{3627289344U, 24},
	{3627290112U, 24},
	{3627290880U, 24},
	{3627291136U, 24},
	{3627292416U, 24},
	{3627292928U, 24},
	{3627293696U, 24},
	{3627294720U, 20},
	{3627298048U, 24},
	{3627298816U, 20},
	{3627299328U, 24},
	{3627299584U, 24},
	{3627300352U, 24},
	{3627301120U, 24},
	{3627301632U, 24},
	{3627301888U, 24},
	{3627302912U, 20},
	{3627304192U, 24},
	{3627305472U, 23},
	{3627307008U, 21},
	{3627308800U, 24},
	{3627309056U, 21},
	{3627311104U, 20},
	{3627312384U, 24},
	{3627313408U, 24},
	{3627313664U, 24},
	{3627313920U, 24},
	{3627315200U, 20},
	{3627315200U, 22},
	{3627316224U, 24},
	{3627317760U, 24},
	{3627318016U, 24},
	{3627319296U, 19},
	{3627320576U, 24},
	{3627320832U, 24},
	{3627323904U, 23},
	{3627324672U, 24},
	{3627326720U, 24},
	{3627327488U, 21},
	{3627329536U, 21},
	{3627331584U, 20},
	{3627332096U, 24},
	{3627333120U, 24},
	{3627333376U, 24},
	{3627333888U, 24},
	{3627334656U, 24},
	{3627335680U, 20},
	{3627339776U, 20},
	{3627340032U, 24},
	{3627341568U, 24},
	{3627341824U, 24},
	{3627343872U, 19},
	{3627344384U, 23},
	{3627344384U, 24},
	{3627344896U, 24},
	{3627345152U, 24},
	{3627347456U, 24},
	{3627348224U, 24},
	{3627349760U, 24},
	{3627350272U, 24},
	{3627350784U, 24},
	{3627352064U, 17},
	{3627352064U, 18},
	{3627368448U, 19},
	{3627370240U, 24},
	{3627377408U, 24},
	{3627377664U, 24},
	{3627457024U, 24},
	{3627466752U, 22},
	{3627477504U, 24},
	{3627478016U, 23},
	{3627478528U, 24},
	{3627483136U, 18},
	{3627614208U, 18},
	{3627614208U, 22},
	{3627615232U, 23},
	{3627616256U, 22},
	{3627617792U, 23},
	{3627620352U, 23},
	{3627620864U, 23},
	{3627629568U, 22},
	{3627646976U, 19},
	{3627651072U, 24},
	{3627651584U, 23},
	{3627663360U, 20},
	{3627667456U, 20},
	{3627679744U, 17},
	{3627696128U, 18},
	{3627712512U, 19},
	{3627745280U, 22},
	{3627746816U, 23},
	{3627747072U, 24},
	{3627748352U, 22},
	{3627749376U, 21},
	{3627752448U, 23},
	{3627753472U, 23},
	{3627755520U, 21},
	{3627757568U, 23},
	{3627758848U, 24},
	{3627759616U, 23},
	{3627760640U, 24},
	{3627761664U, 21},
	{3627763712U, 22},
	{3627764736U, 23},
	{3627768576U, 24},
	{3627769088U, 24},
	{3627769344U, 23},
	{3627769856U, 22},
	{3627770880U, 23},
	{3627771392U, 23},
	{3627771904U, 23},
	{3627772416U, 23},
	{3627774976U, 24},
	{3627776768U, 24},
	{3627777024U, 24},
	{3627792384U, 21},
	{3627814912U, 21},
	{3627846144U, 23},
	{3627846656U, 22},
	{3627847680U, 21},
	{3627849728U, 22},
	{3627859968U, 20},
	{3627876352U, 19},
	{3627917312U, 20},
	{3627933696U, 20},
	{3628003328U, 20},
	{3628044288U, 21},
	{3628046336U, 21},
	{3628047872U, 24},
	{3628064768U, 19},
	{3628122112U, 19},
	{3628130304U, 20},
	{3628138496U, 17},
	{3628171264U, 19},
	{3628269568U, 20},
	{3628273664U, 20},
	{3628277760U, 20},
	{3628281856U, 20},
	{3628285952U, 20},
	{3628290048U, 20},
	{3628294144U, 20},
	{3628298240U, 20},
	{3628335104U, 16},
	{3628354560U, 24},
	{3628354816U, 24},
	{3628355072U, 24},
	{3628369920U, 22},
	{3628370944U, 22},
	{3628376064U, 22},
	{3628377088U, 22},
	{3628378112U, 21},
	{3628380160U, 21},
	{3628382208U, 22},
	{3628417024U, 19},
	{3628425216U, 24},
	{3628498944U, 18},
	{3628507904U, 24},
	{3628509952U, 24},
	{3628510208U, 24},
	{3628514048U, 24},
	{3628514816U, 24},
	{3628545536U, 23},
	{3628599808U, 24},
	{3628601344U, 22},
	{3628601344U, 24},
	{3628602368U, 24},
	{3628602880U, 24},
	{3628628992U, 24},
	{3628639488U, 24},
	{3628662784U, 18},
	{3628665344U, 24},
	{3628665600U, 24},
	{3628666880U, 24},
	{3628669440U, 24},
	{3628695552U, 18},
	{3628695552U, 19},
	{3628703744U, 20},
	{3628707840U, 20},
	{3628720128U, 20},
	{3628728320U, 18},
	{3628744704U, 18},
	{3628761088U, 18},
	{3628810240U, 19},
	{3628826624U, 21},
	{3628828672U, 24},
	{3628828928U, 24},
	{3628829184U, 23},
	{3629099520U, 24},
	{3629121536U, 17},
	{3629219840U, 17},
	{3629271040U, 21},
	{3629301760U, 20},
	{3629309952U, 20},
	{3629309952U, 24},
	{3629310976U, 24},
	{3629311232U, 24},
	{3629312256U, 24},
	{3629313024U, 24},
	{3629313280U, 24},
	{3629313536U, 24},
	{3629313792U, 24},
	{3629318144U, 19},
	{3629334528U, 20},
	{3629359104U, 19},
	{3629416448U, 21},
	{3629467904U, 24},
	{3629468160U, 23},
	{3629491712U, 24},
	{3629507584U, 24},
	{3629508864U, 24},
	{3629509120U, 23},
	{3629509632U, 22},
	{3629510656U, 20},
	{3629531136U, 19},
	{3629547520U, 20},
	{3629555712U, 20},
	{3629572096U, 20},
	{3629576192U, 20},
	{3629596672U, 19},
	{3629629440U, 20},
	{3629633536U, 20},
	{3629665280U, 23},
	{3629665792U, 24},
	{3629666048U, 24},
	{3629671680U, 24},
	{3629672448U, 22},
	{3629672448U, 24},
	{3629672704U, 24},
	{3629672960U, 24},
	{3629673216U, 24},
	{3629683456U, 24},
	{3629683712U, 22},
	{3629697024U, 21},
	{3629699840U, 24},
	{3629705216U, 22},
	{3629723648U, 21},
	{3629723648U, 24},
	{3629723904U, 24},
	{3629724160U, 24},
	{3629724416U, 24},
	{3629724672U, 24},
	{3629724928U, 24},
	{3629725184U, 24},
	{3629725440U, 24},
	{3629725696U, 23},
	{3629725696U, 24},
	{3629728768U, 22},
	{3629729792U, 21},
	{3629731840U, 21},
	{3629740032U, 22},
	{3629741056U, 23},
	{3629771264U, 23},
	{3629771776U, 24},
	{3629772288U, 23},
	{3629773824U, 23},
	{3629776896U, 23},
	{3629795328U, 22},
	{3629803520U, 23},
	{3629817856U, 21},
	{3629829120U, 23},
	{3629835264U, 22},
	{3629871616U, 23},
	{3629872128U, 22},
	{3629875712U, 24},
	{3629898752U, 23},
	{3629973504U, 17},
	{3630202880U, 18},
	{3630209024U, 21},
	{3630215168U, 22},
	{3630216192U, 22},
	{3630218752U, 23},
	{3630219264U, 22},
	{3630220288U, 22},
	{3630222336U, 22},
	{3630268416U, 19},
	{3630325760U, 19},
	{3630342144U, 20},
	{3630346240U, 24},
	{3630346496U, 24},
	{3630346752U, 24},
	{3630347008U, 24},
	{3630347264U, 24},
	{3630347520U, 24},
	{3630347776U, 24},
	{3630348032U, 24},
	{3630348288U, 24},
	{3630348544U, 24},
	{3630348800U, 24},
	{3630349056U, 24},
	{3630349312U, 24},
	{3630349568U, 24},
	{3630349824U, 24},
	{3630350080U, 24},
	{3630366720U, 19},
	{3630391808U, 24},
	{3630392064U, 24},
	{3630392832U, 24},
	{3630393088U, 24},
	{3630399488U, 21},
	{3630401536U, 22},
	{3630415872U, 19},
	{3630424064U, 19},
	{3630456832U, 19},
	{3630469888U, 24},
	{3630470656U, 24},
	{3630497792U, 20},
	{3630522112U, 24},
	{3630609920U, 24},
	{3630669824U, 20},
	{3630706688U, 21},
	{3630718976U, 19},
	{3630735360U, 19},
	{3630735360U, 20},
	{3630751744U, 19},
	{3630752992U, 27},
	{3630753312U, 27},
	{3630753344U, 27},
	{3630753408U, 27},
	{3630759936U, 19},
	{3630800896U, 20},
	{3630809088U, 20},
	{3630867968U, 23},
	{3630868480U, 24},
	{3630874624U, 22},
	{3631038464U, 19},
	{3631039488U, 23},
	{3631042048U, 25},
	{3631042560U, 24},
	{3631042816U, 24},
	{3631048704U, 24},
	{3631050752U, 20},
	{3631054848U, 19},
	{3631079424U, 20},
	{3631083520U, 20},
	{3631095808U, 20},
	{3631120384U, 18},
	{3631198464U, 24},
	{3631216640U, 23},
	{3631217664U, 22},
	{3631218688U, 16},
	{3631223040U, 24},
	{3631225856U, 24},
	{3631228928U, 21},
	{3631232000U, 24},
	{3631232512U, 24},
	{3631233024U, 24},
	{3631248384U, 24},
	{3631250944U, 23},
	{3631252480U, 22},
	{3631253504U, 24},
	{3631257600U, 24},
	{3631263744U, 22},
	{3631264768U, 22},
	{3631266816U, 22},
	{3631268352U, 23},
	{3631268864U, 23},
	{3631269632U, 24},
	{3631280128U, 22},
	{3631431680U, 19},
	{3631439872U, 20},
	{3631472640U, 19},
	{3631480832U, 20},
	{3631497216U, 20},
	{3631505408U, 19},
	{3631521792U, 19},
	{3631579136U, 18},
	{3631628288U, 19},
	{3631644672U, 19},
	{3631661056U, 20},
	{3631693824U, 19},
	{3631742976U, 17},
	{3631744000U, 23},
	{3631786240U, 24},
	{3631786752U, 24},
	{3631795200U, 22},
	{3631808512U, 19},
	{3631865856U, 19},
	{3631953920U, 24},
	{3631954176U, 24},
	{3631964160U, 21},
	{3631966208U, 23},
	{3631966976U, 24},
	{3631967232U, 24},
	{3631969280U, 22},
	{3631970304U, 22},
	{3631970304U, 24},
	{3631970816U, 24},
	{3632005120U, 16},
	{3632046080U, 20},
	{3632058368U, 21},
	{3632070656U, 16},
	{3632084992U, 21},
	{3632155136U, 24},
	{3632155392U, 24},
	{3632168960U, 19},
	{3632195584U, 22},
	{3632201728U, 19},
	{3632234496U, 19},
	{3632234496U, 22},
	{3632259072U, 22},
	{3632283648U, 22},
	{3632300032U, 22},
	{3632301056U, 22},
	{3632302080U, 22},
	{3632303104U, 22},
	{3632305152U, 22},
	{3632306176U, 22},
	{3632307200U, 22},
	{3632308224U, 22},
	{3632310272U, 22},
	{3632311296U, 22},
	{3632312320U, 22},
	{3632313344U, 22},
	{3632316416U, 22},
	{3632317440U, 22},
	{3632318464U, 22},
	{3632332800U, 19},
	{3632340992U, 20},
	{3632345088U, 21},
	{3632381952U, 19},
	{3632431104U, 19},
	{3632529408U, 15},
	{3632535040U, 24},
	{3632535296U, 24},
	{3632538624U, 23},
	{3632538880U, 24},
	{3632549376U, 24},
	{3632549632U, 24},
	{3632553984U, 22},
	{3632558336U, 24},
	{3632561920U, 24},
	{3632592640U, 24},
	{3632613376U, 23},
	{3632618752U, 24},
	{3632627712U, 24},
	{3632648192U, 24},
	{3632758784U, 17},
	{3632764928U, 21},
	{3632793600U, 24},
	{3632806144U, 24},
	{3632813312U, 24},
	{3632816128U, 19},
	{3632821248U, 23},
	{3632823552U, 24},
	{3632824320U, 17},
	{3632824320U, 22},
	{3632826400U, 27},
	{3632830976U, 23},
	{3632831616U, 25},
	{3632831744U, 27},
	{3632831776U, 27},
	{3632831872U, 25},
	{3632834144U, 27},
	{3632834560U, 28},
	{3632834576U, 28},
	{3632835328U, 25},
	{3632835584U, 22},
	{3632839908U, 30},
	{3632839912U, 30},
	{3632840704U, 21},
	{3632840704U, 22},
	{3632840720U, 28},
	{3632840736U, 27},
	{3632840768U, 26},
	{3632840832U, 26},
	{3632840896U, 26},
	{3632840960U, 27},
	{3632841008U, 28},
	{3632841024U, 27},
	{3632841136U, 30},
	{3632841148U, 30},
	{3632841152U, 28},
	{3632841208U, 29},
	{3632841216U, 23},
	{3632841728U, 22},
	{3632841728U, 25},
	{3632841984U, 24},
	{3632842240U, 25},
	{3632842376U, 29},
	{3632842400U, 28},
	{3632842416U, 28},
	{3632842432U, 28},
	{3632842496U, 24},
	{3632843520U, 24},
	{3632843776U, 24},
	{3632844288U, 30},
	{3632844400U, 28},
	{3632844416U, 25},
	{3632844544U, 24},
	{3632844800U, 25},
	{3632847216U, 29},
	{3632848896U, 22},
	{3632857088U, 19},
	{3632859136U, 21},
	{3632939008U, 20},
	{3632942080U, 24},
	{3632942336U, 24},
	{3632971776U, 19},
	{3633020928U, 19},
	{3633054782U, 14},
	{3633086464U, 18},
	{3633099264U, 23},
	{3633099776U, 24},
	{3633105664U, 24},
	{3633119232U, 18},
	{3633119232U, 19},
	{3633125376U, 23},
	{3633134592U, 23},
	{3633135616U, 20},
	{3633140224U, 23},
	{3633141248U, 23},
	{3633141504U, 24},
	{3633141760U, 23},
	{3633150208U, 24},
	{3633173088U, 27},
	{3633188864U, 20},
	{3633192960U, 22},
	{3633193984U, 22},
	{3633197056U, 21},
	{3633199104U, 22},
	{3633208320U, 24},
	{3633212544U, 25},
	{3633223936U, 24},
	{3633224704U, 22},
	{3633228800U, 22},
	{3633229824U, 22},
	{3633232896U, 23},
	{3633235968U, 21},
	{3633238016U, 20},
	{3633242112U, 22},
	{3633243136U, 22},
	{3633245184U, 22},
	{3633246208U, 21},
	{3633247232U, 22},
	{3633248256U, 21},
	{3633248256U, 22},
	{3633249280U, 22},
	{3633250304U, 22},
	{3633251328U, 22},
	{3633252352U, 21},
	{3633254400U, 22},
	{3633256448U, 22},
	{3633269760U, 22},
	{3633273344U, 24},
	{3633281024U, 22},
	{3633282560U, 23},
	{3633284608U, 24},
	{3633285632U, 23},
	{3633286144U, 22},
	{3633294336U, 22},
	{3633307648U, 22},
	{3633311232U, 23},
	{3633311744U, 23},
	{3633312768U, 22},
	{3633332224U, 20},
	{3633332224U, 24},
	{3633332224U, 28},
	{3633332240U, 28},
	{3633332480U, 26},
	{3633332608U, 28},
	{3633332672U, 27},
	{3633332720U, 28},
	{3633332736U, 24},
	{3633332992U, 25},
	{3633333152U, 27},
	{3633333216U, 27},
	{3633333504U, 24},
	{3633340416U, 20},
	{3633348608U, 19},
	{3633356800U, 19},
	{3633388544U, 24},
	{3633388800U, 24},
	{3633389056U, 24},
	{3633389312U, 24},
	{3633389568U, 20},
	{3633393664U, 20},
	{3633414656U, 24},
	{3633414912U, 24},
	{3633415168U, 24},
	{3633415424U, 24},
	{3633415936U, 24},
	{3633455616U, 24},
	{3633455872U, 24},
	{3633456128U, 24},
	{3633456384U, 24},
	{3633456640U, 24},
	{3633456896U, 24},
	{3633457152U, 24},
	{3633457408U, 24},
	{3633457664U, 24},
	{3633457920U, 24},
	{3633458176U, 24},
	{3633458432U, 24},
	{3633512448U, 17},
	{3633577984U, 16},
	{3633588224U, 24},
	{3633588480U, 24},
	{3633600512U, 23},
	{3633604096U, 24},
	{3633604608U, 23},
	{3633610752U, 24},
	{3633611264U, 24},
	{3633619968U, 23},
	{3633620992U, 21},
	{3633620992U, 22},
	{3633620992U, 24},
	{3633621248U, 24},
	{3633621504U, 24},
	{3633621760U, 24},
	{3633622016U, 24},
	{3633622272U, 24},
	{3633622528U, 24},
	{3633622784U, 24},
	{3633627648U, 24},
	{3633631232U, 20},
	{3633635072U, 24},
	{3633635328U, 19},
	{3633635328U, 22},
	{3633643520U, 16},
	{3633643520U, 19},
	{3633651712U, 19},
	{3633659904U, 19},
	{3633668096U, 19},
	{3633676288U, 19},
	{3633684480U, 19},
	{3633692672U, 19},
	{3633709056U, 19},
	{3633725440U, 19},
	{3633741824U, 19},
	{3633758208U, 19},
	{3633790976U, 18},
	{3633795584U, 23},
	{3633796096U, 24},
	{3633796352U, 24},
	{3633856512U, 20},
	{3633905664U, 17},
	{3634085888U, 20},
	{3634102272U, 16},
	{3634178048U, 21},
	{3634180096U, 21},
	{3634182144U, 22},
	{3634183168U, 22},
	{3634184192U, 21},
	{3634186240U, 21},
	{3634188288U, 21},
	{3634190336U, 21},
	{3634192384U, 21},
	{3634194432U, 21},
	{3634250240U, 24},
	{3634251776U, 24},
	{3634252288U, 24},
	{3634252544U, 24},
	{3634253312U, 24},
	{3634253824U, 24},
	{3634254080U, 24},
	{3634254336U, 24},
	{3634254848U, 24},
	{3634256128U, 24},
	{3634266112U, 19},
	{3634298880U, 17},
	{3634331648U, 18},
	{3634332160U, 23},
	{3634332672U, 23},
	{3634528256U, 20},
	{3634569216U, 20},
	{3634577408U, 19},
	{3634585600U, 19},
	{3634587392U, 24},
	{3634589952U, 24},
	{3634590208U, 24},
	{3634590976U, 24},
	{3634591744U, 23},
	{3634592256U, 24},
	{3634592512U, 24},
	{3634592768U, 24},
	{3634593024U, 24},
	{3634593280U, 24},
	{3634601984U, 20},
	{3634606080U, 20},
	{3634606080U, 21},
	{3634608128U, 21},
	{3634613504U, 24},
	{3634614272U, 20},
	{3634624512U, 21},
	{3634626560U, 16},
	{3634692096U, 17},
	{3634724864U, 18},
	{3634737152U, 23},
	{3634739200U, 23},
	{3634757632U, 17},
	{3634812928U, 21},
	{3634823168U, 17},
	{3634863104U, 23},
	{3634888704U, 19},
	{3634905088U, 23},
	{3634905600U, 24},
	{3634905856U, 24},
	{3634906112U, 24},
	{3634906368U, 24},
	{3634906624U, 24},
	{3634906880U, 24},
	{3634907136U, 23},
	{3634907648U, 24},
	{3634907904U, 24},
	{3634908160U, 24},
	{3634908416U, 24},
	{3634908672U, 24},
	{3634908928U, 24},
	{3634909184U, 24},
	{3634909440U, 24},
	{3634909696U, 24},
	{3634909952U, 24},
	{3634910208U, 24},
	{3634910464U, 24},
	{3634910720U, 24},
	{3634910976U, 24},
	{3634911232U, 23},
	{3634911744U, 24},
	{3634912000U, 24},
	{3634912256U, 24},
	{3634912512U, 24},
	{3634912768U, 24},
	{3634913024U, 24},
	{3634923520U, 24},
	{3634923776U, 24},
	{3634929664U, 24},
	{3634929920U, 24},
	{3634930176U, 23},
	{3634930688U, 22},
	{3634931712U, 22},
	{3634946048U, 19},
	{3634953216U, 22},
	{3634953216U, 24},
	{3634953472U, 24},
	{3634953728U, 24},
	{3634953984U, 24},
	{3634962432U, 19},
	{3634978816U, 19},
	{3634989056U, 24},
	{3634995200U, 24},
	{3635013120U, 23},
	{3635015680U, 23},
	{3635016192U, 23},
	{3635016704U, 23},
	{3635017216U, 23},
	{3635017728U, 23},
	{3635018752U, 22},
	{3635036160U, 19},
	{3635094272U, 24},
	{3635096064U, 23},
	{3635100928U, 24},
	{3635101184U, 24},
	{3635101696U, 20},
	{3635118080U, 20},
	{3635216384U, 18},
	{3635219968U, 23},
	{3635220480U, 23},
	{3635221504U, 23},
	{3635222528U, 23},
	{3635224064U, 23},
	{3635232768U, 24},
	{3635233024U, 24},
	{3635233280U, 24},
	{3635233536U, 24},
	{3635233792U, 24},
	{3635234560U, 24},
	{3635234816U, 24},
	{3635235072U, 24},
	{3635235328U, 24},
	{3635235584U, 24},
	{3635235840U, 24},
	{3635236352U, 23},
	{3635236608U, 24},
	{3635237120U, 24},
	{3635237376U, 24},
	{3635237888U, 24},
	{3635238400U, 24},
	{3635238656U, 24},
	{3635238912U, 24},
	{3635239168U, 24},
	{3635239424U, 24},
	{3635239680U, 24},
	{3635240192U, 24},
	{3635240448U, 23},
	{3635240704U, 24},
	{3635240960U, 20},
	{3635245568U, 24},
	{3635245824U, 24},
	{3635246080U, 24},
	{3635246336U, 24},
	{3635246592U, 24},
	{3635246848U, 24},
	{3635248384U, 24},
	{3635248640U, 24},
	{3635248896U, 24},
	{3635265536U, 19},
	{3635311616U, 24},
	{3635322880U, 22},
	{3635323904U, 22},
	{3635331072U, 18},
	{3635333632U, 23},
	{3635334144U, 22},
	{3635341312U, 21},
	{3635343360U, 22},
	{3635357696U, 21},
	{3635359744U, 20},
	{3635453952U, 20},
	{3635456768U, 24},
	{3635470336U, 20},
	{3635470336U, 22},
	{3635471360U, 22},
	{3635472384U, 22},
	{3635473408U, 23},
	{3635473920U, 24},
	{3635474176U, 24},
	{3635494912U, 19},
	{3635494912U, 20},
	{3635511296U, 19},
	{3635519488U, 20},
	{3635527680U, 19},
	{3635544064U, 19},
	{3635544064U, 24},
	{3635545344U, 24},
	{3635570688U, 24},
	{3635570944U, 24},
	{3635571200U, 23},
	{3635572736U, 20},
	{3635574784U, 22},
	{3635577344U, 23},
	{3635579904U, 22},
	{3635675136U, 17},
	{3635703808U, 20},
	{3635707904U, 19},
	{3635740672U, 16},
	{3635847168U, 20},
	{3635847200U, 30},
	{3635847204U, 30},
	{3635847232U, 29},
	{3635847240U, 29},
	{3635847248U, 29},
	{3635847264U, 29},
	{3635847280U, 28},
	{3635847296U, 28},
	{3635847320U, 29},
	{3635847328U, 29},
	{3635847336U, 29},
	{3635847344U, 29},
	{3635847424U, 24},
	{3635847680U, 29},
	{3635847688U, 30},
	{3635847696U, 28},
	{3635847712U, 28},
	{3635847728U, 28},
	{3635847744U, 27},
	{3635847808U, 25},
	{3635847936U, 24},
	{3635848192U, 26},
	{3635848320U, 28},
	{3635848384U, 27},
	{3635848432U, 28},
	{3635848448U, 27},
	{3635848480U, 28},
	{3635848496U, 28},
	{3635848512U, 28},
	{3635848528U, 28},
	{3635848704U, 24},
	{3635855360U, 20},
	{3635855360U, 28},
	{3635855376U, 28},
	{3635855608U, 29},
	{3635855616U, 26},
	{3635855744U, 28},
	{3635855808U, 27},
	{3635855856U, 28},
	{3635855872U, 25},
	{3635856064U, 27},
	{3635856096U, 27},
	{3635857408U, 21},
	{3635863552U, 20},
	{3635879936U, 20},
	{3635896320U, 22},
	{3635897344U, 23},
	{3635897856U, 24},
	{3635898368U, 23},
	{3635898880U, 24},
	{3635899136U, 24},
	{3635899392U, 23},
	{3635900416U, 24},
	{3635900928U, 23},
	{3635901440U, 24},
	{3635901696U, 24},
	{3635901952U, 24},
	{3635902208U, 24},
	{3635902464U, 22},
	{3635903488U, 24},
	{3635903744U, 24},
	{3636011008U, 19},
	{3636017152U, 23},
	{3636027392U, 20},
	{3636051968U, 20},
	{3636068352U, 17},
	{3636068352U, 18},
	{3636068352U, 19},
	{3636084736U, 20},
	{3636101120U, 18},
	{3636101120U, 20},
	{3636105216U, 23},
	{3636105728U, 23},
	{3636106240U, 23},
	{3636106752U, 24},
	{3636113920U, 23},
	{3636114432U, 22},
	{3636115456U, 23},
	{3636115968U, 23},
	{3636116480U, 23},
	{3636117504U, 19},
	{3636119552U, 23},
	{3636120064U, 24},
	{3636125696U, 20},
	{3636129792U, 21},
	{3636132352U, 23},
	{3636132864U, 22},
	{3636151296U, 23},
	{3636157184U, 24},
	{3636199424U, 17},
	{3636232192U, 18},
	{3636248576U, 20},
	{3636252672U, 20},
	{3636270592U, 23},
	{3636271616U, 23},
	{3636335616U, 23},
	{3636341248U, 23},
	{3636366336U, 22},
	{3636369408U, 24},
	{3636369664U, 24},
	{3636372480U, 23},
	{3636381696U, 24},
	{3636391936U, 21},
	{3636641792U, 19},
	{3636658176U, 19},
	{3636723712U, 18},
	{3636723712U, 24},
	{3636732672U, 24},
	{3636756480U, 18},
	{3636756480U, 21},
	{3636758528U, 21},
	{3636760576U, 21},
	{3636762624U, 21},
	{3636764672U, 21},
	{3636766720U, 21},
	{3636772864U, 18},
	{3636879360U, 20},
	{3636879360U, 24},
	{3636879872U, 24},
	{3636881664U, 24},
	{3636882176U, 24},
	{3636882944U, 24},
	{3636883200U, 24},
	{3636883456U, 24},
	{3636883712U, 24},
	{3636883968U, 24},
	{3636884224U, 24},
	{3636903936U, 19},
	{3636912128U, 19},
	{3636985856U, 16},
	{3636989952U, 24},
	{3637003264U, 22},
	{3637004288U, 21},
	{3637006336U, 22},
	{3637026816U, 20},
	{3637038592U, 24},
	{3637048832U, 24},
	{3637049088U, 24},
	{3637051392U, 18},
	{3637117696U, 24},
	{3637117952U, 24},
	{3637118208U, 24},
	{3637143552U, 22},
	{3637182464U, 18},
	{3637215232U, 17},
	{3637248000U, 16},
	{3637362688U, 20},
	{3637385216U, 24},
	{3637389568U, 24},
	{3637433088U, 24},
	{3637433344U, 23},
	{3637463040U, 21},
	{3637673984U, 18},
	{3637706752U, 17},
	{3637706752U, 18},
	{3637723136U, 20},
	{3637727232U, 20},
	{3637731328U, 20},
	{3637735424U, 20},
	{3637903360U, 16},
	{3638071296U, 20},
	{3638132992U, 24},
	{3638147328U, 24},
	{3638181888U, 19},
	{3638198272U, 17},
	{3638218496U, 24},
	{3638246400U, 24},
	{3638255616U, 20},
	{3638263808U, 17},
	{3638304768U, 20},
	{3638312960U, 21},
	{3638315008U, 21},
	{3638329344U, 19},
	{3638337536U, 20},
	{3638341632U, 20},
	{3638345728U, 20},
	{3638364160U, 21},
	{3638364160U, 24},
	{3638364416U, 24},
	{3638364672U, 24},
	{3638365184U, 24},
	{3638365440U, 24},
	{3638365696U, 24},
	{3638365952U, 24},
	{3638421504U, 24},
	{3638422784U, 24},
	{3638423296U, 24},
	{3638423552U, 24},
	{3638436352U, 23},
	{3638444032U, 21},
	{3638446080U, 22},
	{3638447104U, 22},
	{3638459392U, 22},
	{3638493184U, 19},
	{3638495232U, 21},
	{3638495488U, 24},
	{3638495744U, 24},
	{3638496000U, 24},
	{3638497280U, 23},
	{3638497792U, 24},
	{3638501376U, 19},
	{3638501376U, 20},
	{3638501376U, 24},
	{3638501632U, 24},
	{3638501888U, 24},
	{3638502144U, 24},
	{3638502912U, 24},
	{3638503424U, 22},
	{3638504448U, 24},
	{3638504960U, 24},
	{3638506240U, 24},
	{3638509568U, 18},
	{3638542336U, 19},
	{3638575104U, 19},
	{3638583296U, 20},
	{3638722560U, 19},
	{3638728704U, 24},
	{3638738944U, 21},
	{3638740736U, 24},
	{3638740992U, 21},
	{3638742528U, 24},
	{3638744064U, 23},
	{3638744320U, 24},
	{3638744576U, 23},
	{3638745088U, 24},
	{3638746112U, 23},
	{3638746368U, 24},
	{3638746624U, 24},
	{3638747136U, 20},
	{3638750720U, 23},
	{3638751232U, 21},
	{3638754560U, 24},
	{3638804480U, 20},
	{3638812672U, 20},
	{3638820864U, 20},
	{3638871552U, 23},
	{3638872064U, 24},
	{3638873600U, 24},
	{3638873856U, 24},
	{3638910976U, 20},
	{3638943744U, 20},
	{3638984704U, 24},
	{3638984960U, 24},
	{3638985216U, 24},
	{3638985472U, 24},
	{3638985728U, 24},
	{3638985984U, 24},
	{3638986240U, 24},
	{3638986496U, 24},
	{3638986752U, 24},
	{3638987008U, 24},
	{3638987264U, 24},
	{3638987520U, 24},
	{3638987776U, 24},
	{3638988032U, 24},
	{3638988288U, 24},
	{3638988544U, 24},
	{3638992896U, 20},
	{3639021568U, 22},
	{3639022592U, 23},
	{3639025664U, 19},
	{3639025664U, 24},
	{3639042048U, 19},
	{3639050240U, 20},
	{3639066624U, 22},
	{3639067648U, 23},
	{3639068672U, 21},
	{3639068928U, 24},
	{3639069952U, 24},
	{3639070464U, 24},
	{3639070720U, 20},
	{3639074816U, 20},
	{3639148544U, 16},
	{3639148544U, 22},
	{3639149568U, 23},
	{3639150080U, 23},
	{3639150592U, 22},
	{3639151616U, 22},
	{3639152640U, 23},
	{3639153152U, 23},
	{3639153664U, 22},
	{3639154688U, 22},
	{3639155712U, 22},
	{3639156736U, 22},
	{3639157760U, 22},
	{3639158784U, 23},
	{3639159296U, 24},
	{3639159552U, 24},
	{3639159808U, 23},
	{3639160320U, 24},
	{3639160576U, 24},
	{3639160832U, 24},
	{3639161088U, 24},
	{3639161344U, 24},
	{3639161600U, 24},
	{3639161856U, 22},
	{3639162880U, 22},
	{3639163904U, 23},
	{3639164416U, 24},
	{3639164672U, 24},
	{3639164928U, 21},
	{3639166976U, 21},
	{3639169024U, 22},
	{3639169536U, 23},
	{3639170048U, 24},
	{3639170304U, 24},
	{3639170560U, 23},
	{3639171072U, 21},
	{3639172864U, 24},
	{3639173120U, 21},
	{3639175168U, 21},
	{3639177216U, 21},
	{3639178496U, 24},
	{3639179264U, 23},
	{3639179776U, 23},
	{3639180288U, 22},
	{3639181312U, 21},
	{3639182336U, 22},
	{3639183360U, 21},
	{3639185408U, 22},
	{3639185920U, 23},
	{3639186432U, 24},
	{3639186688U, 24},
	{3639186944U, 23},
	{3639187456U, 24},
	{3639187968U, 24},
	{3639188224U, 24},
	{3639188480U, 24},
	{3639188736U, 24},
	{3639188992U, 23},
	{3639189504U, 23},
	{3639190016U, 24},
	{3639190272U, 24},
	{3639190528U, 23},
	{3639191040U, 23},
	{3639191552U, 21},
	{3639193600U, 23},
	{3639194112U, 24},
	{3639194368U, 24},
	{3639194624U, 22},
	{3639196160U, 23},
	{3639196672U, 23},
	{3639197184U, 24},
	{3639197440U, 24},
	{3639197696U, 22},
	{3639198720U, 23},
	{3639199232U, 24},
	{3639199488U, 24},
	{3639199744U, 21},
	{3639201792U, 23},
	{3639202304U, 24},
	{3639202560U, 24},
	{3639202816U, 22},
	{3639203840U, 21},
	{3639205376U, 24},
	{3639205632U, 24},
	{3639205888U, 21},
	{3639207936U, 22},
	{3639208960U, 23},
	{3639209472U, 23},
	{3639209984U, 22},
	{3639211008U, 23},
	{3639211520U, 23},
	{3639212032U, 23},
	{3639212544U, 23},
	{3639213056U, 22},
	{3639271424U, 19},
	{3639271424U, 20},
	{3639275520U, 20},
	{3639287808U, 19},
	{3639287808U, 20},
	{3639296000U, 20},
	{3639320576U, 20},
	{3639328768U, 24},
	{3639329280U, 24},
	{3639332864U, 20},
	{3639336960U, 20},
	{3639394304U, 20},
	{3639397888U, 24},
	{3639410688U, 18},
	{3639427072U, 22},
	{3639428096U, 22},
	{3639429120U, 22},
	{3639430144U, 22},
	{3639435264U, 20},
	{3639443456U, 18},
	{3639549952U, 23},
	{3639549952U, 24},
	{3639550208U, 24},
	{3639550464U, 23},
	{3639550464U, 24},
	{3639550720U, 24},
	{3639550976U, 23},
	{3639550976U, 24},
	{3639551232U, 24},
	{3639551488U, 24},
	{3639551744U, 24},
	{3639552000U, 24},
	{3639552256U, 24},
	{3639553024U, 24},
	{3639553280U, 24},
	{3639553536U, 24},
	{3639566336U, 23},
	{3639567104U, 24},
	{3639567360U, 23},
	{3639567872U, 23},
	{3639568384U, 24},
	{3639568640U, 24},
	{3639582720U, 21},
	{3639584768U, 21},
	{3639590912U, 20},
	{3639592960U, 23},
	{3639599104U, 20},
	{3639603200U, 20},
	{3639672832U, 19},
	{3639705600U, 22},
	{3639706624U, 23},
	{3639707648U, 22},
	{3639708672U, 23},
	{3639709184U, 23},
	{3639709696U, 22},
	{3639726080U, 20},
	{3639734272U, 23},
	{3639734784U, 24},
	{3639735040U, 24},
	{3639735296U, 24},
	{3639735552U, 24},
	{3639736064U, 24},
	{3639736320U, 24},
	{3639748096U, 24},
	{3639759872U, 24},
	{3639803904U, 18},
	{3639820288U, 20},
	{3639853056U, 19},
	{3639861248U, 20},
	{3639869440U, 18},
	{3639918592U, 20},
	{3639925248U, 24},
	{3639925504U, 24},
	{3639925760U, 24},
	{3639926016U, 24},
	{3639926272U, 24},
	{3639926528U, 24},
	{3639928320U, 24},
	{3639930880U, 21},
	{3639933184U, 24},
	{3639933440U, 24},
	{3639933696U, 24},
	{3639933952U, 24},
	{3639934720U, 24},
	{3639941120U, 22},
	{3640000512U, 17},
	{3640147968U, 18},
	{3640205056U, 24},
	{3640213504U, 19},
	{3640231936U, 24},
	{3640232192U, 24},
	{3640232448U, 24},
	{3640232704U, 24},
	{3640232960U, 24},
	{3640233216U, 24},
	{3640246272U, 18},
	{3640279040U, 19},
	{3640279040U, 23},
	{3640279552U, 24},
	{3640280064U, 23},
	{3640280576U, 23},
	{3640281088U, 24},
	{3640281344U, 24},
	{3640281856U, 24},
	{3640282112U, 24},
	{3640283136U, 23},
	{3640283648U, 23},
	{3640284160U, 23},
	{3640284672U, 23},
	{3640285184U, 24},
	{3640286208U, 24},
	{3640286464U, 24},
	{3640295424U, 21},
	{3640295680U, 24},
	{3640297472U, 24},
	{3640298240U, 24},
	{3640298496U, 24},
	{3640298752U, 24},
	{3640299008U, 23},
	{3640320000U, 19},
	{3640340992U, 24},
	{3640369152U, 20},
	{3640373248U, 20},
	{3640393728U, 18},
	{3640418304U, 20},
	{3640426496U, 20},
	{3640429568U, 22},
	{3640430592U, 21},
	{3640434688U, 20},
	{3640438272U, 24},
	{3640440832U, 22},
	{3640441600U, 24},
	{3640442880U, 20},
	{3640444160U, 24},
	{3640445952U, 24},
	{3640446976U, 20},
	{3640450048U, 23},
	{3640450560U, 23},
	{3640455168U, 20},
	{3640463360U, 20},
	{3640524800U, 18},
	{3640524800U, 24},
	{3640541184U, 18},
	{3640590336U, 20},
	{3640647680U, 20},
	{3641204736U, 20},
	{3641237504U, 20},
	{3641253888U, 20},
	{3641270272U, 20},
	{3641327616U, 20},
	{3641335808U, 20},
	{3641360384U, 24},
	{3641360640U, 24},
	{3641360896U, 24},
	{3641361152U, 24},
	{3641361408U, 24},
	{3641361664U, 24},
	{3641361920U, 24},
	{3641362176U, 24},
	{3641362432U, 24},
	{3641362688U, 24},
	{3641362944U, 24},
	{3641363200U, 24},
	{3641363456U, 24},
	{3641363968U, 24},
	{3641364480U, 24},
	{3641364736U, 24},
	{3641364992U, 24},
	{3641365248U, 24},
	{3641365504U, 24},
	{3641365760U, 24},
	{3641366016U, 24},
	{3641366272U, 24},
	{3641366528U, 24},
	{3641367040U, 24},
	{3641367296U, 24},
	{3641367552U, 24},
	{3641367808U, 24},
	{3641368064U, 24},
	{3641371136U, 24},
	{3641450496U, 20},
	{3641573376U, 20},
	{3641638912U, 20},
	{3641647104U, 20},
	{3641655296U, 20},
	{3641688064U, 20},
	{3641819136U, 20},
	{3641843712U, 20},
	{3641884672U, 20},
	{3641901312U, 24},
	{3641901824U, 24},
	{3641902080U, 24},
	{3641902336U, 24},
	{3641902592U, 24},
	{3641903104U, 24},
	{3641903360U, 24},
	{3641903616U, 24},
	{3641903872U, 24},
	{3641909248U, 20},
	{3641933824U, 20},
	{3641958400U, 20},
	{3641999360U, 20},
	{3642015744U, 20},
	{3642040320U, 20},
	{3642040320U, 24},
	{3642041856U, 24},
	{3642064896U, 20},
	{3642097664U, 20},
	{3642139648U, 24},
	{3642261504U, 20},
	{3642269696U, 20},
	{3642286080U, 20},
	{3642310656U, 20},
	{3642335232U, 20},
	{3642400768U, 24},
	{3642425344U, 23},
	{3642425856U, 23},
	{3642433536U, 24},
	{3642433792U, 24},
	{3642434048U, 24},
	{3642434304U, 24},
	{3642540032U, 20},
	{3642564608U, 20},
	{3642590720U, 24},
	{3642590976U, 24},
	{3642605568U, 23},
	{3642606080U, 23},
	{3642703872U, 20},
	{3642753024U, 12},
	{3644915712U, 20},
	{3645014016U, 20},
	{3645022208U, 20},
	{3645038592U, 19},
	{3645063168U, 20},
	{3645120512U, 20},
	{3645169664U, 23},
	{3645177856U, 20},
	{3645194240U, 20},
	{3645308928U, 22},
	{3645311488U, 24},
	{3645415424U, 20},
	{3645497344U, 20},
	{3645497344U, 21},
	{3645661184U, 20},
	{3645677568U, 20},
	{3645734912U, 20},
	{3645874176U, 20},
	{3648167936U, 20},
	{3648176128U, 24},
	{3648225280U, 20},
	{3648241664U, 20},
	{3648249856U, 20},
	{3648323584U, 20},
	{3648331776U, 19},
	{3648421888U, 20},
	{3648479232U, 19},
	{3648503808U, 20},
	{3648520192U, 14},
	{3649241088U, 16},
	{3650174976U, 20},
	{3650248704U, 20},
	{3650265088U, 23},
	{3650363392U, 20},
	{3650437120U, 20},
	{3650519040U, 20},
	{3650551808U, 20},
	{3650576384U, 20},
	{3650748416U, 16},
	{3650881536U, 24},
	{3650885888U, 24},
	{3650887680U, 24},
	{3650888704U, 24},
	{3650896384U, 23},
	{3651141632U, 16},
	{3651272704U, 16},
	{3651534848U, 16},
	{3651846144U, 20},
	{3651919872U, 20},
	{3652050944U, 20},
	{3652190208U, 13},
	{3653484544U, 20},
	{3653484544U, 24},
	{3653541888U, 21},
	{3654811648U, 15},
	{3655073792U, 16},
	{3657564160U, 15},
	{3657695232U, 16},
	{3221233664U, 24},
	{3221234176U, 24},
	{3221554176U, 23},
	{3221554688U, 24},
	{3221554944U, 24},
	{3221555712U, 24},
	{3221558528U, 24},
	{3221558784U, 24},
	{3221559040U, 24},
	{3221559296U, 24},
	{3221559552U, 24},
	{3221560064U, 24},
	{3221562880U, 24},
	{3221565184U, 24},
	{3221566720U, 24},
	{3221567232U, 24},
	{3221569792U, 24},
	{3221570048U, 24},
	{3221571840U, 24},
	{3221574656U, 22},
	{3221580288U, 24},
	{3221581312U, 24},
	{3221581568U, 24},
	{3221590784U, 24},
	{3221591040U, 24},
	{3221593088U, 24},
	{3221593344U, 24},
	{3221594624U, 24},
	{3221595648U, 24},
	{3221596672U, 23},
	{3221599232U, 24},
	{3221602304U, 24},
	{3221603072U, 24},
	{3221604608U, 24},
	{3221607424U, 24},
	{3221609472U, 24},
	{3221614592U, 24},
	{3221619200U, 24},
	{3221619456U, 24},
	{3221620224U, 24},
	{3221620992U, 24},
	{3221621248U, 24},
	{3221623552U, 24},
	{3221624064U, 24},
	{3221624576U, 24},
	{3221628160U, 24},
	{3221628416U, 24},
	{3221628672U, 24},
	{3221629184U, 24},
	{3221633792U, 24},
	{3221636864U, 24},
	{3221638400U, 24},
	{3221640704U, 24},
	{3221641472U, 24},
	{3221642496U, 24},
	{3221643776U, 24},
	{3221648896U, 24},
	{3221649408U, 24},
	{3221649664U, 24},
	{3221655296U, 24},
	{3221656832U, 24},
	{3221657344U, 24},
	{3221670400U, 24},
	{3221673472U, 24},
	{3221675776U, 24},
	{3221749760U, 16},
	{3221946368U, 16},
	{3222003968U, 24},
	{3222004224U, 24},
	{3222013184U, 24},
	{3222013696U, 24},
	{3222014464U, 24},
	{3222015744U, 24},
	{3222016768U, 24},
	{3222019328U, 24},
	{3222019584U, 24},
	{3222020096U, 24},
	{3222020352U, 24},
	{3222028544U, 24},
	{3222028800U, 24},
	{3222029056U, 24},
	{3222029312U, 24},
	{3222030592U, 24},
	{3222032896U, 24},
	{3222034432U, 24},
	{3222034688U, 24},
	{3222034944U, 24},
	{3222036224U, 24},
	{3222043648U, 24},
	{3222045952U, 24},
	{3222046208U, 24},
	{3222046464U, 24},
	{3222064896U, 24},
	{3222065920U, 24},
	{3222071552U, 24},
	{3222072576U, 24},
	{3222073344U, 24},
	{3222224896U, 22},
	{3222225920U, 23},
	{3222274048U, 19},
	{3222277376U, 24},
	{3222316800U, 24},
	{3222317056U, 24},
	{3222319616U, 24},
	{3222319872U, 24},
	{3222326272U, 24},
	{3222339584U, 16},
	{3222409216U, 22},
	{3222429696U, 20},
	{3222470656U, 16},
	{3222519808U, 22},
	{3222536704U, 24},
	{3222536960U, 24},
	{3222537216U, 24},
	{3222538240U, 24},
	{3222597376U, 24},
	{3222598912U, 24},
	{3222599168U, 24},
	{3222600192U, 24},
	{3222600448U, 24},
	{3222600704U, 24},
	{3222601728U, 16},
	{3222775808U, 24},
	{3222798336U, 16},
	{3222876160U, 24},
	{3222877184U, 24},
	{3222887168U, 24},
	{3222891008U, 24},
	{3222897920U, 24},
	{3222899456U, 24},
	{3222916608U, 24},
	{3222918656U, 24},
	{3222918912U, 24},
	{3222919168U, 24},
	{3222919680U, 24},
	{3222921472U, 24},
	{3222925312U, 24},
	{3222931968U, 24},
	{3222933248U, 24},
	{3222951168U, 24},
	{3222951424U, 24},
	{3222952704U, 24},
	{3222952960U, 24},
	{3222967040U, 24},
	{3222980608U, 24},
	{3222988288U, 24},
	{3222993664U, 24},
	{3222993920U, 24},
	{3222994944U, 16},
	{3223055104U, 24},
	{3223060480U, 18},
	{3223076864U, 19},
	{3223085056U, 22},
	{3223125504U, 24},
	{3223141376U, 24},
	{3223257856U, 24},
	{3223258880U, 24},
	{3223262464U, 24},
	{3223265024U, 24},
	{3223276032U, 24},
	{3223277568U, 24},
	{3223278336U, 24},
	{3223279616U, 24},
	{3223280128U, 24},
	{3223281664U, 24},
	{3223284224U, 24},
	{3223285760U, 24},
	{3223296256U, 24},
	{3223296768U, 24},
	{3223301632U, 24},
	{3223307520U, 24},
	{3223312384U, 24},
	{3223317248U, 24},
	{3223318272U, 24},
	{3223321856U, 24},
	{3223390720U, 24},
	{3223391488U, 24},
	{3223435776U, 24},
	{3223449600U, 24},
	{3223514880U, 24},
	{3223524352U, 24},
	{3223526656U, 24},
	{3223530496U, 24},
	{3223532288U, 24},
	{3223534336U, 24},
	{3223538176U, 24},
	{3223538432U, 24},
	{3223538688U, 24},
	{3223540224U, 24},
	{3223540480U, 24},
	{3223540736U, 24},
	{3223544320U, 24},
	{3223544576U, 24},
	{3223553280U, 24},
	{3223555584U, 24},
	{3223559168U, 24},
	{3223563008U, 24},
	{3223565312U, 24},
	{3223568640U, 24},
	{3223609088U, 24},
	{3223781376U, 16},
	{3223812608U, 24},
	{3223867392U, 24},
	{3223876608U, 24},
	{3223912448U, 18},
	{3223953920U, 24},
	{3223955968U, 24},
	{3223962880U, 24},
	{3223964672U, 24},
	{3223965696U, 24},
	{3223966976U, 24},
	{3223967232U, 24},
	{3223979776U, 24},
	{3223988480U, 24},
	{3223992064U, 24},
	{3223998976U, 24},
	{3224000512U, 24},
	{3224001792U, 24},
	{3224003072U, 24},
	{3224003328U, 24},
	{3224014080U, 24},
	{3224016640U, 24},
	{3224017152U, 24},
	{3224023808U, 24},
	{3224024320U, 24},
	{3224024576U, 24},
	{3224038912U, 24},
	{3224059904U, 18},
	{3224090880U, 24},
	{3224094208U, 24},
	{3224099072U, 24},
	{3224099328U, 24},
	{3224103680U, 24},
	{3224105984U, 24},
	{3224107776U, 24},
	{3224173824U, 24},
	{3224174592U, 16},
	{3224214272U, 24},
	{3224240640U, 24},
	{3224241664U, 24},
	{3224267776U, 24},
	{3224305920U, 24},
	{3224311808U, 24},
	{3224316416U, 24},
	{3224316928U, 24},
	{3224317440U, 24},
	{3224335616U, 24},
	{3224336384U, 22},
	{3224346880U, 24},
	{3224350720U, 24},
	{3224350976U, 24},
	{3224352768U, 21},
	{3224357888U, 24},
	{3224367104U, 24},
	{3224367360U, 24},
	{3224367872U, 24},
	{3224379648U, 24},
	{3224391680U, 24},
	{3224398336U, 24},
	{3224417280U, 24},
	{3224428032U, 24},
	{3224433152U, 24},
	{3224433920U, 24},
	{3224502272U, 21},
	{3224504320U, 23},
	{3224505600U, 24},
	{3224506624U, 24},
	{3224509184U, 24},
	{3224509440U, 24},
	{3224516608U, 23},
	{3224518912U, 24},
	{3224519168U, 23},
	{3224519680U, 24},
	{3224521216U, 23},
	{3224521728U, 23},
	{3224523008U, 24},
	{3224528128U, 24},
	{3224528384U, 23},
	{3224529152U, 24},
	{3224530432U, 24},
	{3224541696U, 24},
	{3224542720U, 24},
	{3224551424U, 23},
	{3224553472U, 24},
	{3224555008U, 23},
	{3224555520U, 23},
	{3224563712U, 24},
	{3224567552U, 24},
	{3224578304U, 24},
	{3224578816U, 24},
	{3224579072U, 24},
	{3224582912U, 24},
	{3224604672U, 21},
	{3224610816U, 21},
	{3224613888U, 22},
	{3224617472U, 23},
	{3224621056U, 20},
	{3224631808U, 24},
	{3224648448U, 24},
	{3224652032U, 24},
	{3224660480U, 24},
	{3224663296U, 24},
	{3224680448U, 24},
	{3224689664U, 24},
	{3224707840U, 24},
	{3224775936U, 24},
	{3224776704U, 24},
	{3224798976U, 24},
	{3224822272U, 24},
	{3224828416U, 24},
	{3224828672U, 24},
	{3224830208U, 24},
	{3224830464U, 23},
	{3224835840U, 24},
	{3224836096U, 24},
	{3224839424U, 24},
	{3224852224U, 24},
	{3224854784U, 24},
	{3224857088U, 24},
	{3224857600U, 24},
	{3224860672U, 24},
	{3224861184U, 24},
	{3224861440U, 24},
	{3224861696U, 24},
	{3224864000U, 24},
	{3224865024U, 24},
	{3224865280U, 23},
	{3224865792U, 22},
	{3224866816U, 20},
	{3224870912U, 20},
	{3224875008U, 21},
	{3224877056U, 23},
	{3224877568U, 24},
	{3224877824U, 24},
	{3224883200U, 24},
	{3224883712U, 24},
	{3224884736U, 24},
	{3224888320U, 24},
	{3224888576U, 24},
	{3224889856U, 24},
	{3224891392U, 24},
	{3224910848U, 24},
	{3224944384U, 24},
	{3224954624U, 24},
	{3224961024U, 16},
	{3225053952U, 24},
	{3225059072U, 24},
	{3225060864U, 24},
	{3225061120U, 24},
	{3225061376U, 24},
	{3225067264U, 24},
	{3225070592U, 24},
	{3225072896U, 24},
	{3225073408U, 24},
	{3225073664U, 21},
	{3225077504U, 24},
	{3225082880U, 24},
	{3225083392U, 24},
	{3225083648U, 24},
	{3225088768U, 24},
	{3225089024U, 24},
	{3225089536U, 24},
	{3225444352U, 24},
	{3225459968U, 24},
	{3225510144U, 24},
	{3225518336U, 24},
	{3225521408U, 24},
	{3225522176U, 24},
	{3225522688U, 24},
	{3225524480U, 24},
	{3225531904U, 24},
	{3225536512U, 24},
	{3225536768U, 24},
	{3225537024U, 24},
	{3225540352U, 24},
	{3225540608U, 24},
	{3225541120U, 24},
	{3225542656U, 24},
	{3225543168U, 24},
	{3225543680U, 24},
	{3225617664U, 24},
	{3225619712U, 24},
	{3225619968U, 24},
	{3225621760U, 24},
	{3225628672U, 24},
	{3225629952U, 24},
	{3225636864U, 24},
	{3225637120U, 24},
	{3225637376U, 24},
	{3225640192U, 24},
	{3225656576U, 24},
	{3225658880U, 24},
	{3225660672U, 24},
	{3225676800U, 22},
	{3225677824U, 21},
	{3225687552U, 24},
	{3225689600U, 24},
	{3225709568U, 24},
	{3225725696U, 24},
	{3225725952U, 24},
	{3225728768U, 24},
	{3225733632U, 24},
	{3225734400U, 24},
	{3225734912U, 24},
	{3225739008U, 24},
	{3225740032U, 24},
	{3225742080U, 24},
	{3225742336U, 22},
	{3225743360U, 22},
	{3225744384U, 24},
	{3225744640U, 24},
	{3225745408U, 23},
	{3225759232U, 24},
	{3225764352U, 24},
	{3225796096U, 24},
	{3225853952U, 24},
	{3225854464U, 24},
	{3225858816U, 24},
	{3225859072U, 23},
	{3225860608U, 24},
	{3225865216U, 24},
	{3225867008U, 24},
	{3225868800U, 24},
	{3225873408U, 24},
	{3225873664U, 24},
	{3225875712U, 24},
	{3225877504U, 24},
	{3225911552U, 24},
	{3225911808U, 24},
	{3225929472U, 24},
	{3225933056U, 24},
	{3225944064U, 16},
	{3225956352U, 24},
	{3225967872U, 24},
	{3226010368U, 24},
	{3226011392U, 24},
	{3226021888U, 24},
	{3226024192U, 24},
	{3226024960U, 24},
	{3226025472U, 24},
	{3226025984U, 24},
	{3226026752U, 24},
	{3226062592U, 24},
	{3226064128U, 24},
	{3226064896U, 24},
	{3226067968U, 24},
	{3226110720U, 24},
	{3226112000U, 20},
	{3226130432U, 24},
	{3226186240U, 24},
	{3226240256U, 24},
	{3226240768U, 24},
	{3226244864U, 24},
	{3226251520U, 24},
	{3226251776U, 24},
	{3226253056U, 24},
	{3226253312U, 24},
	{3226267392U, 24},
	{3226269952U, 24},
	{3226274048U, 24},
	{3226301440U, 24},
	{3226309376U, 24},
	{3226315776U, 24},
	{3226316032U, 24},
	{3226322432U, 24},
	{3226324224U, 24},
	{3226325248U, 24},
	{3226325504U, 24},
	{3226338304U, 24},
	{3226463744U, 24},
	{3226471424U, 22},
	{3226472448U, 24},
	{3226472704U, 24},
	{3226474496U, 24},
	{3226475776U, 24},
	{3226476032U, 24},
	{3226481152U, 24},
	{3226484736U, 24},
	{3226485760U, 24},
	{3226522368U, 24},
	{3226593792U, 24},
	{3226599424U, 19},
	{3226627584U, 24},
	{3226629632U, 24},
	{3226630144U, 24},
	{3226635776U, 24},
	{3226656256U, 24},
	{3226693376U, 24},
	{3226695168U, 24},
	{3226695424U, 24},
	{3226705664U, 24},
	{3226707456U, 23},
	{3226707968U, 21},
	{3226708736U, 24},
	{3226710016U, 20},
	{3226710016U, 24},
	{3226711040U, 24},
	{3226714112U, 22},
	{3226714112U, 24},
	{3226715136U, 24},
	{3226722304U, 24},
	{3226723328U, 24},
	{3226724096U, 24},
	{3226724352U, 24},
	{3226726912U, 24},
	{3226728704U, 24},
	{3226729728U, 24},
	{3226734592U, 22},
	{3226735616U, 24},
	{3226753024U, 24},
	{3226753280U, 24},
	{3226760960U, 24},
	{3226786304U, 24},
	{3226786560U, 24},
	{3226789376U, 24},
	{3226792704U, 24},
	{3226795008U, 24},
	{3226800128U, 23},
	{3226857728U, 24},
	{3226857984U, 24},
	{3226863104U, 24},
	{3226863360U, 24},
	{3226863616U, 24},
	{3226863872U, 24},
	{3226878464U, 24},
	{3226879744U, 24},
	{3226880000U, 22},
	{3226881280U, 24},
	{3226882048U, 24},
	{3226893824U, 24},
	{3226897152U, 24},
	{3226903808U, 24},
	{3226926336U, 24},
	{3226972160U, 24},
	{3226994176U, 24},
	{3226994688U, 24},
	{3226998016U, 24},
	{3226999808U, 24},
	{3227012608U, 24},
	{3227020800U, 24},
	{3227021312U, 24},
	{3227021824U, 24},
	{3227022080U, 24},
	{3227022336U, 24},
	{3227023872U, 24},
	{3227041792U, 24},
	{3227042048U, 24},
	{3227042304U, 24},
	{3227042560U, 24},
	{3227045120U, 24},
	{3227045376U, 24},
	{3227046144U, 24},
	{3227046400U, 24},
	{3227046912U, 24},
	{3227054336U, 24},
	{3227054592U, 24},
	{3227191552U, 24},
	{3227207936U, 24},
	{3227208192U, 24},
	{3227208448U, 24},
	{3227224576U, 24},
	{3227228160U, 24},
	{3227228672U, 24},
	{3227229952U, 24},
	{3227233024U, 24},
	{3227235072U, 24},
	{3227236608U, 24},
	{3227239936U, 24},
	{3227240704U, 24},
	{3227243520U, 24},
	{3227253760U, 24},
	{3227260416U, 24},
	{3227262464U, 24},
	{3227269120U, 24},
	{3227270656U, 24},
	{3227270912U, 24},
	{3227274752U, 24},
	{3227276032U, 24},
	{3227278336U, 24},
	{3227279104U, 24},
	{3227279360U, 24},
	{3227286528U, 24},
	{3227295488U, 24},
	{3227391488U, 24},
	{3227392256U, 24},
	{3227393792U, 24},
	{3227395584U, 23},
	{3227396096U, 24},
	{3227396352U, 24},
	{3227397888U, 24},
	{3227399680U, 24},
	{3227400960U, 24},
	{3227401216U, 24},
	{3227401472U, 24},
	{3227409920U, 24},
	{3227430144U, 24},
	{3227437568U, 24},
	{3227439616U, 24},
	{3227441408U, 24},
	{3227443968U, 24},
	{3227445504U, 24},
	{3227447552U, 24},
	{3227449600U, 24},
	{3227517184U, 24},
	{3227517440U, 24},
	{3227517696U, 24},
	{3227518208U, 24},
	{3227518464U, 23},
	{3227518976U, 23},
	{3227519488U, 24},
	{3227519744U, 24},
	{3227520000U, 24},
	{3227520256U, 24},
	{3227520512U, 24},
	{3227522048U, 23},
	{3227525632U, 24},
	{3227526144U, 23},
	{3227526656U, 24},
	{3227528704U, 24},
	{3227529216U, 24},
	{3227531520U, 24},
	{3227535872U, 24},
	{3227536384U, 24},
	{3227537152U, 24},
	{3227537408U, 22},
	{3227538432U, 23},
	{3227539712U, 24},
	{3227539968U, 23},
	{3227540480U, 24},
	{3227540992U, 23},
	{3227544064U, 24},
	{3227544832U, 24},
	{3227547648U, 21},
	{3227549696U, 22},
	{3227550976U, 24},
	{3227551232U, 24},
	{3227551488U, 24},
	{3227551744U, 23},
	{3227552512U, 24},
	{3227552768U, 23},
	{3227553280U, 24},
	{3227553536U, 24},
	{3227554048U, 24},
	{3227554560U, 24},
	{3227555328U, 24},
	{3227566336U, 24},
	{3227566592U, 24},
	{3227579904U, 24},
	{3227581440U, 24},
	{3227592192U, 24},
	{3227779328U, 24},
	{3227779584U, 24},
	{3227780352U, 24},
	{3227793152U, 24},
	{3227794176U, 24},
	{3227795712U, 24},
	{3227798784U, 24},
	{3227799552U, 24},
	{3227802368U, 24},
	{3227802624U, 24},
	{3227803136U, 24},
	{3227805696U, 21},
	{3227819520U, 24},
	{3227820544U, 24},
	{3227821056U, 24},
	{3227821312U, 24},
	{3227822592U, 24},
	{3227823104U, 24},
	{3227823360U, 24},
	{3227824128U, 24},
	{3227825920U, 24},
	{3227827712U, 24},
	{3227828480U, 24},
	{3227828992U, 24},
	{3227829248U, 24},
	{3227830016U, 24},
	{3227830272U, 24},
	{3227830528U, 24},
	{3227832320U, 24},
	{3227833600U, 24},
	{3227834880U, 24},
	{3227835392U, 24},
	{3227835648U, 24},
	{3227848960U, 24},
	{3227852544U, 24},
	{3227853312U, 24},
	{3227855872U, 24},
	{3227859456U, 24},
	{3227868160U, 24},
	{3227869696U, 24},
	{3227870208U, 22},
	{3227871232U, 22},
	{3227872256U, 23},
	{3227879424U, 24},
	{3227881472U, 24},
	{3227883008U, 23},
	{3227893248U, 24},
	{3227893504U, 24},
	{3227908608U, 24},
	{3227911424U, 24},
	{3227913216U, 24},
	{3227913728U, 24},
	{3227921408U, 24},
	{3227933184U, 24},
	{3227933696U, 24},
	{3227960320U, 24},
	{3227960576U, 24},
	{3227960832U, 24},
	{3227961088U, 24},
	{3227961344U, 24},
	{3227961600U, 24},
	{3227961856U, 24},
	{3227969024U, 24},
	{3227969280U, 24},
	{3227970560U, 24},
	{3227971328U, 24},
	{3227972352U, 24},
	{3227972608U, 22},
	{3227973888U, 24},
	{3227974912U, 24},
	{3227977728U, 24},
	{3227979008U, 24},
	{3227986176U, 24},
	{3227986688U, 24},
	{3228013568U, 23},
	{3228013824U, 24},
	{3228014336U, 24},
	{3228014592U, 24},
	{3228015104U, 24},
	{3228015360U, 24},
	{3228015616U, 22},
	{3228016128U, 23},
	{3228016640U, 23},
	{3228016896U, 24},
	{3228017152U, 24},
	{3228020480U, 24},
	{3228020736U, 24},
	{3228021504U, 24},
	{3228021760U, 22},
	{3228022272U, 23},
	{3228022784U, 22},
	{3228023296U, 23},
	{3228023808U, 24},
	{3228024320U, 23},
	{3228024576U, 24},
	{3228024832U, 24},
	{3228025344U, 23},
	{3228025600U, 24},
	{3228025856U, 22},
	{3228026368U, 23},
	{3228026880U, 22},
	{3228027392U, 23},
	{3228027904U, 22},
	{3228028928U, 23},
	{3228029440U, 24},
	{3228034304U, 24},
	{3228034560U, 23},
	{3228034816U, 24},
	{3228035072U, 22},
	{3228035584U, 23},
	{3228036096U, 23},
	{3228036352U, 24},
	{3228041472U, 24},
	{3228044544U, 24},
	{3228045056U, 24},
	{3228047872U, 24},
	{3228052480U, 23},
	{3228061440U, 24},
	{3228068608U, 24},
	{3228068864U, 24},
	{3228069120U, 24},
	{3228069376U, 24},
	{3228084992U, 24},
	{3228087552U, 24},
	{3228087808U, 23},
	{3228088832U, 24},
	{3228089088U, 24},
	{3228094464U, 22},
	{3228101120U, 24},
	{3228103680U, 24},
	{3228171776U, 24},
	{3228180480U, 19},
	{3228221440U, 24},
	{3228238592U, 24},
	{3228244992U, 24},
	{3228248320U, 24},
	{3228248832U, 24},
	{3228249344U, 24},
	{3228249600U, 24},
	{3228263680U, 24},
	{3228264192U, 24},
	{3228265472U, 24},
	{3228269312U, 24},
	{3228272128U, 24},
	{3228282624U, 24},
	{3228287744U, 24},
	{3228308736U, 24},
	{3228328448U, 24},
	{3228329472U, 24},
	{3228330496U, 24},
	{3228331520U, 24},
	{3228349184U, 24},
	{3228351488U, 24},
	{3228351744U, 24},
	{3228352000U, 24},
	{3228352256U, 24},
	{3228352512U, 24},
	{3228360960U, 24},
	{3228361472U, 24},
	{3228365568U, 24},
	{3228366080U, 24},
	{3228368384U, 24},
	{3228389632U, 24},
	{3228405248U, 24},
	{3228419328U, 24},
	{3228423424U, 24},
	{3228424192U, 24},
	{3228425728U, 24},
	{3228509184U, 24},
	{3228512000U, 24},
	{3228513536U, 24},
	{3228522752U, 24},
	{3228526848U, 24},
	{3228529664U, 24},
	{3228530688U, 24},
	{3228530944U, 24},
	{3228578304U, 24},
	{3228579328U, 24},
	{3228581888U, 24},
	{3228582144U, 24},
	{3228600832U, 24},
	{3228601088U, 24},
	{3228619264U, 24},
	{3228698624U, 23},
	{3228699136U, 24},
	{3228706816U, 21},
	{3228717056U, 22},
	{3228766208U, 20},
	{3228776448U, 21},
	{3228780544U, 21},
	{3228794880U, 21},
	{3228807168U, 22},
	{3228816384U, 22},
	{3228817408U, 21},
	{3228819456U, 20},
	{3228831744U, 21},
	{3228844032U, 18},
	{3228860416U, 18},
	{3228872960U, 24},
	{3228893184U, 18},
	{3228917760U, 19},
	{3228963840U, 22},
	{3228965888U, 22},
	{3228971008U, 22},
	{3228991488U, 22},
	{3229092096U, 24},
	{3229092352U, 23},
	{3229092864U, 22},
	{3229112576U, 24},
	{3229112832U, 24},
	{3229113088U, 24},
	{3229117184U, 24},
	{3229141248U, 24},
	{3229197568U, 24},
	{3229254400U, 24},
	{3229254656U, 22},
	{3229255680U, 22},
	{3229256704U, 24},
	{3229264640U, 24},
	{3229264896U, 24},
	{3229265152U, 24},
	{3229265408U, 24},
	{3229275392U, 24},
	{3229284864U, 24},
	{3229355264U, 24},
	{3229360640U, 24},
	{3229361920U, 24},
	{3229362688U, 24},
	{3229377536U, 24},
	{3229382144U, 24},
	{3229391104U, 24},
	{3229392640U, 24},
	{3229392896U, 24},
	{3229393152U, 24},
	{3229627392U, 24},
	{3229646080U, 24},
	{3229646336U, 24},
	{3229648128U, 24},
	{3229656576U, 24},
	{3229656832U, 24},
	{3229678592U, 24},
	{3229679104U, 24},
	{3229692416U, 24},
	{3229693696U, 24},
	{3229696000U, 24},
	{3229697024U, 24},
	{3229701376U, 24},
	{3229818112U, 24},
	{3229832704U, 24},
	{3229834240U, 24},
	{3229836032U, 24},
	{3229841664U, 24},
	{3229842176U, 24},
	{3229847808U, 24},
	{3229850368U, 24},
	{3229857024U, 24},
	{3229868288U, 24},
	{3229868544U, 24},
	{3229873664U, 24},
	{3229889280U, 24},
	{3229897216U, 24},
	{3229928960U, 24},
	{3229930752U, 24},
	{3229931776U, 24},
	{3229932032U, 24},
	{3229932288U, 24},
	{3229933824U, 24},
	{3229934592U, 24},
	{3229938944U, 24},
	{3229939456U, 24},
	{3229940992U, 24},
	{3229944832U, 24},
	{3229946112U, 24},
	{3229946368U, 24},
	{3229950464U, 24},
	{3229952768U, 24},
	{3229954816U, 24},
	{3229957120U, 24},
	{3229957888U, 24},
	{3229963264U, 24},
	{3229968384U, 24},
	{3229968640U, 24},
	{3229974528U, 24},
	{3229978624U, 20},
	{3229982720U, 19},
	{3229990912U, 19},
	{3229999104U, 20},
	{3230003200U, 22},
	{3230083840U, 24},
	{3230085632U, 24},
	{3230093312U, 24},
	{3230097408U, 24},
	{3230101504U, 24},
	{3230101760U, 24},
	{3230102016U, 24},
	{3230102272U, 24},
	{3230102528U, 24},
	{3230103040U, 24},
	{3230103296U, 24},
	{3230103552U, 24},
	{3230103808U, 24},
	{3230104064U, 24},
	{3230108672U, 24},
	{3230108928U, 24},
	{3230109696U, 24},
	{3230117376U, 24},
	{3230117888U, 24},
	{3230119168U, 24},
	{3230120960U, 24},
	{3230121216U, 24},
	{3230122240U, 24},
	{3230125824U, 24},
	{3230130944U, 24},
	{3230133504U, 24},
	{3230133760U, 24},
	{3230134016U, 24},
	{3230134272U, 21},
	{3230136320U, 23},
	{3230140416U, 24},
	{3230142464U, 24},
	{3230144000U, 24},
	{3230146560U, 23},
	{3230151168U, 24},
	{3230154752U, 24},
	{3230167040U, 24},
	{3230175744U, 24},
	{3230177792U, 23},
	{3230209280U, 24},
	{3230218496U, 24},
	{3230261504U, 24},
	{3230268416U, 24},
	{3230276864U, 24},
	{3230277632U, 24},
	{3230278400U, 24},
	{3230289408U, 24},
	{3230291200U, 24},
	{3230291712U, 24},
	{3230291968U, 24},
	{3230302976U, 24},
	{3230304512U, 24},
	{3230313728U, 24},
	{3230314496U, 23},
	{3230315008U, 24},
	{3230316032U, 24},
	{3230317824U, 24},
	{3230318336U, 24},
	{3230318848U, 24},
	{3230319104U, 24},
	{3230321920U, 24},
	{3230333184U, 24},
	{3230334208U, 24},
	{3230344448U, 24},
	{3230355968U, 24},
	{3230369024U, 24},
	{3230369280U, 24},
	{3230395904U, 24},
	{3230793984U, 24},
	{3230794240U, 24},
	{3230800128U, 24},
	{3230800384U, 24},
	{3230800640U, 24},
	{3230800896U, 24},
	{3230801152U, 24},
	{3230801408U, 24},
	{3230801664U, 24},
	{3230801920U, 19},
	{3230810112U, 19},
	{3230818304U, 22},
	{3230819328U, 24},
	{3230822400U, 24},
	{3230832128U, 24},
	{3230834432U, 24},
	{3230834944U, 24},
	{3230835200U, 24},
	{3230842624U, 24},
	{3230842880U, 24},
	{3230845184U, 24},
	{3230846464U, 24},
	{3230848512U, 24},
	{3230851584U, 24},
	{3230857984U, 24},
	{3230858240U, 24},
	{3230858496U, 24},
	{3230861056U, 24},
	{3230862336U, 24},
	{3230862592U, 24},
	{3230865408U, 24},
	{3230869504U, 24},
	{3230871552U, 24},
	{3230872064U, 24},
	{3230872320U, 24},
	{3230873856U, 24},
	{3230877952U, 24},
	{3230888192U, 24},
	{3230900224U, 20},
	{3230900992U, 24},
	{3230902784U, 24},
	{3230903040U, 24},
	{3230903808U, 24},
	{3230904320U, 22},
	{3230917888U, 24},
	{3230918912U, 24},
	{3230919680U, 24},
	{3230920448U, 24},
	{3230923008U, 24},
	{3230948608U, 24},
	{3230949376U, 23},
	{3230954752U, 24},
	{3230955264U, 24},
	{3230955520U, 24},
	{3230955776U, 24},
	{3230956032U, 24},
	{3230956288U, 24},
	{3230956544U, 24},
	{3230956800U, 24},
	{3230957056U, 24},
	{3230957312U, 24},
	{3230957824U, 24},
	{3230958336U, 24},
	{3230959616U, 24},
	{3230960128U, 24},
	{3230960384U, 24},
	{3230960896U, 24},
	{3230961152U, 24},
	{3230961664U, 24},
	{3230962688U, 24},
	{3230965760U, 22},
	{3230965760U, 24},
	{3230966784U, 23},
	{3230967808U, 24},
	{3230974720U, 24},
	{3230980608U, 24},
	{3230984704U, 24},
	{3230984960U, 24},
	{3230985472U, 24},
	{3230986240U, 24},
	{3230987008U, 24},
	{3230987264U, 24},
	{3230987520U, 24},
	{3230987776U, 24},
	{3230988032U, 24},
	{3230988288U, 24},
	{3230988544U, 24},
	{3230988800U, 24},
	{3230989056U, 24},
	{3230989312U, 24},
	{3230989568U, 24},
	{3230990592U, 24},
	{3230990848U, 24},
	{3230995456U, 24},
	{3231004672U, 24},
	{3231013888U, 24},
	{3231027968U, 24},
	{3231028224U, 24},
	{3231042304U, 24},
	{3231045120U, 24},
	{3231045632U, 24},
	{3231045888U, 24},
	{3231046144U, 24},
	{3231049472U, 24},
	{3231051008U, 24},
	{3231052544U, 24},
	{3231052800U, 24},
	{3231059456U, 24},
	{3231061248U, 24},
	{3231066368U, 24},
	{3231066880U, 24},
	{3231067136U, 22},
	{3231078400U, 24},
	{3231082240U, 24},
	{3231084800U, 24},
	{3231085312U, 24},
	{3231087360U, 24},
	{3231088896U, 24},
	{3231092480U, 24},
	{3231093504U, 24},
	{3231109632U, 24},
	{3231112448U, 24},
	{3231115776U, 23},
	{3231116288U, 23},
	{3231117824U, 24},
	{3231118592U, 24},
	{3231119616U, 24},
	{3231119872U, 23},
	{3231120640U, 24},
	{3231123200U, 24},
	{3231123968U, 23},
	{3231128320U, 24},
	{3231129088U, 24},
	{3231130112U, 24},
	{3231131392U, 24},
	{3231133184U, 24},
	{3231134720U, 23},
	{3231135232U, 24},
	{3231149568U, 24},
	{3231150080U, 24},
	{3231150336U, 24},
	{3231188224U, 24},
	{3231189504U, 24},
	{3231194368U, 24},
	{3231197952U, 24},
	{3231200768U, 24},
	{3231212288U, 24},
	{3231219456U, 24},
	{3231222272U, 24},
	{3231241216U, 24},
	{3231249152U, 24},
	{3231249664U, 24},
	{3231250688U, 24},
	{3231253504U, 24},
	{3231255296U, 24},
	{3231258112U, 24},
	{3231258880U, 24},
	{3231259136U, 24},
	{3231259648U, 24},
	{3231259904U, 24},
	{3231260160U, 24},
	{3231260416U, 24},
	{3231260672U, 24},
	{3231260928U, 24},
	{3231261184U, 24},
	{3231261440U, 24},
	{3231261696U, 24},
	{3231262720U, 24},
	{3231262976U, 24},
	{3231264768U, 21},
	{3231265536U, 24},
	{3231276032U, 24},
	{3231276288U, 24},
	{3231283968U, 24},
	{3231284224U, 24},
	{3231291648U, 24},
	{3231292416U, 24},
	{3231292928U, 24},
	{3231293184U, 24},
	{3231294208U, 24},
	{3231300352U, 24},
	{3231301376U, 24},
	{3231301888U, 24},
	{3231308544U, 24},
	{3231315200U, 24},
	{3231315712U, 24},
	{3231332608U, 24},
	{3231452416U, 24},
	{3231455744U, 24},
	{3231457536U, 24},
	{3231464704U, 24},
	{3231465216U, 24},
	{3231465472U, 24},
	{3231465728U, 24},
	{3231465984U, 24},
	{3231466240U, 24},
	{3231469824U, 24},
	{3231470592U, 24},
	{3231471104U, 24},
	{3231471360U, 24},
	{3231471616U, 24},
	{3231471872U, 24},
	{3231472128U, 24},
	{3231472384U, 24},
	{3231472896U, 24},
	{3231473408U, 24},
	{3231474944U, 24},
	{3231482880U, 24},
	{3231483136U, 24},
	{3231483648U, 24},
	{3231483904U, 24},
	{3231484928U, 24},
	{3231486208U, 24},
	{3231486464U, 23},
	{3231486976U, 23},
	{3231491584U, 24},
	{3231497984U, 24},
	{3231503872U, 24},
	{3231504128U, 24},
	{3231505408U, 24},
	{3231506944U, 24},
	{3231508992U, 24},
	{3231511040U, 24},
	{3231511296U, 24},
	{3231515904U, 24},
	{3231547904U, 24},
	{3231592448U, 24},
	{3231595776U, 24},
	{3231648256U, 24},
	{3231653888U, 22},
	{3231664640U, 24},
	{3231672320U, 24},
	{3231681024U, 24},
	{3231715072U, 24},
	{3231716096U, 24},
	{3231723264U, 24},
	{3231723520U, 24},
	{3231723776U, 24},
	{3231724800U, 24},
	{3231726848U, 24},
	{3231727104U, 24},
	{3231728896U, 24},
	{3231729152U, 24},
	{3231729920U, 24},
	{3231743232U, 24},
	{3231744512U, 24},
	{3231745280U, 24},
	{3231751680U, 24},
	{3231751936U, 24},
	{3231753472U, 24},
	{3231754496U, 24},
	{3231760640U, 24},
	{3231766528U, 21},
	{3231769856U, 24},
	{3231773184U, 24},
	{3231773440U, 24},
	{3231773696U, 24},
	{3231776000U, 24},
	{3231785984U, 24},
	{3231991808U, 21},
	{3232006144U, 19},
	{3232018432U, 20},
	{3232022528U, 20},
	{3232087040U, 24},
	{3232091904U, 24},
	{3232302080U, 24},
	{3232302336U, 24},
	{3232311040U, 24},
	{3232317440U, 23},
	{3232366592U, 17},
	{3232382976U, 19},
	{3232382976U, 20},
	{3232382976U, 24},
	{3232383488U, 24},
	{3232385280U, 24},
	{3232387072U, 20},
	{3232387584U, 24},
	{3232387840U, 24},
	{3232388608U, 24},
	{3232389120U, 24},
	{3232391168U, 19},
	{3232434176U, 22},
	{3232435200U, 24},
	{3232436224U, 23},
	{3232452608U, 20},
	{3232461056U, 24},
	{3232554496U, 24},
	{3232555008U, 24},
	{3232555520U, 24},
	{3232559360U, 24},
	{3232565248U, 22},
	{3232566272U, 24},
	{3232571392U, 20},
	{3232575488U, 22},
	{3232736512U, 24},
	{3232738560U, 24},
	{3232740864U, 23},
	{3232741632U, 24},
	{3232744960U, 24},
	{3232747776U, 24},
	{3232759040U, 24},
	{3232824576U, 24},
	{3232832768U, 24},
	{3233481728U, 24},
	{3233513472U, 17},
	{3233513472U, 24},
	{3233520640U, 24},
	{3233530368U, 24},
	{3233533440U, 24},
	{3233543168U, 24},
	{3233543424U, 24},
	{3233550592U, 24},
	{3233554944U, 24},
	{3233555200U, 24},
	{3233557760U, 24},
	{3233558528U, 24},
	{3233560320U, 24},
	{3233561088U, 24},
	{3233561344U, 24},
	{3233564160U, 24},
	{3233564672U, 24},
	{3233568000U, 24},
	{3233568256U, 24},
	{3233568512U, 24},
	{3233569024U, 24},
	{3233569280U, 24},
	{3233570816U, 24},
	{3233571840U, 24},
	{3233572096U, 24},
	{3233573376U, 24},
	{3233573632U, 24},
	{3233576448U, 24},
	{3233576960U, 24},
	{3233580288U, 24},
	{3233584128U, 24},
	{3233584384U, 24},
	{3233584896U, 24},
	{3233586944U, 24},
	{3233587200U, 22},
	{3233595648U, 24},
	{3233597184U, 24},
	{3233597952U, 24},
	{3233605120U, 24},
	{3233605376U, 24},
	{3233605632U, 24},
	{3233607168U, 23},
	{3233607680U, 24},
	{3233607936U, 24},
	{3233612544U, 24},
	{3233619968U, 24},
	{3233623040U, 24},
	{3233625600U, 24},
	{3233627648U, 24},
	{3233628416U, 24},
	{3233630720U, 24},
	{3233646592U, 24},
	{3233655808U, 24},
	{3233656320U, 24},
	{3233657088U, 24},
	{3233658880U, 22},
	{3233662208U, 24},
	{3233662720U, 24},
	{3233665024U, 23},
	{3233665280U, 24},
	{3233665536U, 23},
	{3233667584U, 24},
	{3233667840U, 24},
	{3233669632U, 24},
	{3233669888U, 24},
	{3233670400U, 24},
	{3233675008U, 24},
	{3233681408U, 24},
	{3233685760U, 24},
	{3233686784U, 24},
	{3233689600U, 24},
	{3233692928U, 24},
	{3233693440U, 24},
	{3233694208U, 24},
	{3233704192U, 24},
	{3233704448U, 24},
	{3233705216U, 24},
	{3233705728U, 24},
	{3233707776U, 24},
	{3233730560U, 24},
	{3233730816U, 24},
	{3233731072U, 24},
	{3233731328U, 24},
	{3233731584U, 24},
	{3233731840U, 24},
	{3233732096U, 24},
	{3233733632U, 22},
	{3233734656U, 24},
	{3233742336U, 24},
	{3233808384U, 16},
	{3233808384U, 24},
	{3233808640U, 24},
	{3233808896U, 24},
	{3233812224U, 24},
	{3233885184U, 24},
	{3233886208U, 24},
	{3233891840U, 24},
	{3233892608U, 24},
	{3233893120U, 24},
	{3233893376U, 24},
	{3233893632U, 24},
	{3233893888U, 24},
	{3233923072U, 24},
	{3233923328U, 24},
	{3233923840U, 24},
	{3233924096U, 24},
	{3233927168U, 24},
	{3233927680U, 24},
	{3233927936U, 24},
	{3234005760U, 24},
	{3234006016U, 24},
	{3234006272U, 24},
	{3234008064U, 24},
	{3234008320U, 24},
	{3234011648U, 24},
	{3234014720U, 24},
	{3234016256U, 24},
	{3234017536U, 24},
	{3234017792U, 24},
	{3234022400U, 23},
	{3234022912U, 24},
	{3234026752U, 24},
	{3234043904U, 24},
	{3234044160U, 24},
	{3234044416U, 23},
	{3234050048U, 24},
	{3234050304U, 24},
	{3234055168U, 24},
	{3234055424U, 24},
	{3234062592U, 24},
	{3234062848U, 23},
	{3234063360U, 23},
	{3234063872U, 24},
	{3234064896U, 24},
	{3234067200U, 24},
	{3234067712U, 24},
	{3234068480U, 23},
	{3234069760U, 24},
	{3234184960U, 24},
	{3234200832U, 24},
	{3234202624U, 22},
	{3234217984U, 21},
	{3234220032U, 22},
	{3234239488U, 24},
	{3234275328U, 20},
	{3234333184U, 24},
	{3234333440U, 24},
	{3234333696U, 24},
	{3234333952U, 24},
	{3234334208U, 24},
	{3234334464U, 24},
	{3234365440U, 21},
	{3234537472U, 22},
	{3234539520U, 24},
	{3234539776U, 24},
	{3234540288U, 24},
	{3234540800U, 24},
	{3234541568U, 22},
	{3234541568U, 24},
	{3234541824U, 24},
	{3234542336U, 24},
	{3234562560U, 23},
	{3234563072U, 24},
	{3234564096U, 23},
	{3234564608U, 24},
	{3234564864U, 24},
	{3234565120U, 22},
	{3234566144U, 24},
	{3234568960U, 24},
	{3234571264U, 24},
	{3234572032U, 24},
	{3234574848U, 24},
	{3234575360U, 24},
	{3234576896U, 24},
	{3234577408U, 24},
	{3234577920U, 24},
	{3234579456U, 24},
	{3234580736U, 24},
	{3234581504U, 24},
	{3234582016U, 24},
	{3234583552U, 24},
	{3234583808U, 24},
	{3234592512U, 24},
	{3234593024U, 24},
	{3234594816U, 16},
	{3234599424U, 24},
	{3234613248U, 21},
	{3234615296U, 21},
	{3234617856U, 23},
	{3234623744U, 24},
	{3234635776U, 21},
	{3234658816U, 24},
	{3234659840U, 24},
	{3234668288U, 24},
	{3234668544U, 22},
	{3234669568U, 23},
	{3234728192U, 24},
	{3234728448U, 23},
	{3234733312U, 24},
	{3234738688U, 24},
	{3234742528U, 24},
	{3234750720U, 24},
	{3234750976U, 24},
	{3234751744U, 24},
	{3234765312U, 24},
	{3234771968U, 24},
	{3234777344U, 24},
	{3234779904U, 24},
	{3234780160U, 22},
	{3234781184U, 24},
	{3234785792U, 24},
	{3234786048U, 24},
	{3234787328U, 24},
	{3234789632U, 24},
	{3234789888U, 24},
	{3234790144U, 24},
	{3234790400U, 24},
	{3234796544U, 24},
	{3234800640U, 24},
	{3234807552U, 24},
	{3234807808U, 24},
	{3234813696U, 24},
	{3234816000U, 24},
	{3234816256U, 24},
	{3234816512U, 24},
	{3234818048U, 24},
	{3234821888U, 24},
	{3234822144U, 24},
	{3234822400U, 24},
	{3234823168U, 24},
	{3234828800U, 24},
	{3234833664U, 24},
	{3234834688U, 24},
	{3234835968U, 23},
	{3234836480U, 23},
	{3234836992U, 24},
	{3234839296U, 24},
	{3234844928U, 24},
	{3234845184U, 24},
	{3234845440U, 24},
	{3234846720U, 24},
	{3234848512U, 24},
	{3234851072U, 24},
	{3234854912U, 24},
	{3234930688U, 20},
	{3234934784U, 21},
	{3234936832U, 22},
	{3234937856U, 23},
	{3235013120U, 24},
	{3235057664U, 20},
	{3235069952U, 24},
	{3235070208U, 24},
	{3235070464U, 24},
	{3235070720U, 24},
	{3235071232U, 24},
	{3235071488U, 24},
	{3235071744U, 24},
	{3235072000U, 24},
	{3235072768U, 24},
	{3235073024U, 22},
	{3235074048U, 22},
	{3235075072U, 23},
	{3235076096U, 24},
	{3235077632U, 23},
	{3235078144U, 23},
	{3235078656U, 24},
	{3235078912U, 24},
	{3235079680U, 23},
	{3235079936U, 24},
	{3235080448U, 24},
	{3235080960U, 24},
	{3235081728U, 23},
	{3235082240U, 23},
	{3235082752U, 24},
	{3235083264U, 24},
	{3235083520U, 24},
	{3235083776U, 24},
	{3235084032U, 24},
	{3235084288U, 24},
	{3235084544U, 24},
	{3235084800U, 24},
	{3235315712U, 16},
	{3235315968U, 24},
	{3235316480U, 24},
	{3235317760U, 24},
	{3235319808U, 24},
	{3235321088U, 24},
	{3235321344U, 24},
	{3235321600U, 24},
	{3235322368U, 24},
	{3235323904U, 24},
	{3235324928U, 24},
	{3235326720U, 24},
	{3235328000U, 24},
	{3235328768U, 24},
	{3235330560U, 24},
	{3235332096U, 23},
	{3235335936U, 24},
	{3235341312U, 22},
	{3235343104U, 24},
	{3235347968U, 23},
	{3235348480U, 22},
	{3235351552U, 24},
	{3235351808U, 24},
	{3235352064U, 24},
	{3235352320U, 24},
	{3235352832U, 24},
	{3235353088U, 24},
	{3235353344U, 24},
	{3235354112U, 24},
	{3235356672U, 24},
	{3235356928U, 24},
	{3235357184U, 24},
	{3235359232U, 24},
	{3235359488U, 24},
	{3235362048U, 24},
	{3235366400U, 24},
	{3235369984U, 24},
	{3235371008U, 23},
	{3235375616U, 24},
	{3235375872U, 24},
	{3235380480U, 24},
	{3235383296U, 24},
	{3235392512U, 24},
	{3235392768U, 24},
	{3235394048U, 24},
	{3235395584U, 24},
	{3235395840U, 24},
	{3235396864U, 24},
	{3235399680U, 24},
	{3235399936U, 24},
	{3235400192U, 24},
	{3235401472U, 24},
	{3235403776U, 24},
	{3235404032U, 24},
	{3235405056U, 24},
	{3235405568U, 24},
	{3235416832U, 24},
	{3235418112U, 21},
	{3235425280U, 24},
	{3235428864U, 24},
	{3235442944U, 24},
	{3235446784U, 16},
	{3235447040U, 24},
	{3235447296U, 23},
	{3235447808U, 22},
	{3235448832U, 23},
	{3235467776U, 24},
	{3235512576U, 24},
	{3235514368U, 23},
	{3235514880U, 23},
	{3235515392U, 22},
	{3235534848U, 24},
	{3235535872U, 22},
	{3235540992U, 22},
	{3235542016U, 22},
	{3235545088U, 23},
	{3235548160U, 24},
	{3235550976U, 24},
	{3235553280U, 20},
	{3235573760U, 21},
	{3235643392U, 16},
	{3235694592U, 21},
	{3235704576U, 24},
	{3235790848U, 23},
	{3235791360U, 24},
	{3235791616U, 24},
	{3235792128U, 24},
	{3235792896U, 22},
	{3235794432U, 23},
	{3235794944U, 24},
	{3235795456U, 23},
	{3235797504U, 24},
	{3235798272U, 24},
	{3235798528U, 24},
	{3235799808U, 24},
	{3235841024U, 24},
	{3235841536U, 24},
	{3235841792U, 24},
	{3235848960U, 24},
	{3235849216U, 24},
	{3235849472U, 24},
	{3235854592U, 24},
	{3235879424U, 24},
	{3235880960U, 24},
	{3235881216U, 24},
	{3235881728U, 24},
	{3235883264U, 24},
	{3235884032U, 24},
	{3235884544U, 24},
	{3235885056U, 21},
	{3235887104U, 21},
	{3235889152U, 21},
	{3235891200U, 24},
	{3235891968U, 24},
	{3235892224U, 24},
	{3235892736U, 24},
	{3235892992U, 24},
	{3235893248U, 21},
	{3235896064U, 24},
	{3235896832U, 24},
	{3235897088U, 24},
	{3235897856U, 24},
	{3235898112U, 24},
	{3235898368U, 24},
	{3235900672U, 24},
	{3235901440U, 24},
	{3235901696U, 24},
	{3235901952U, 24},
	{3235903488U, 21},
	{3235908352U, 24},
	{3235975936U, 24},
	{3235979264U, 20},
	{3235983360U, 21},
	{3235985408U, 24},
	{3236102400U, 24},
	{3236102656U, 23},
	{3236103168U, 22},
	{3236104192U, 21},
	{3236200448U, 17},
	{3236200448U, 18},
	{3236216832U, 19},
	{3236225024U, 19},
	{3236243968U, 24},
	{3236298752U, 20},
	{3236365824U, 24},
	{3236367104U, 24},
	{3236372224U, 24},
	{3236378624U, 24},
	{3236379392U, 24},
	{3236380416U, 24},
	{3236386304U, 24},
	{3236387328U, 24},
	{3236392448U, 24},
	{3236393216U, 24},
	{3236397056U, 24},
	{3236398848U, 24},
	{3236399872U, 24},
	{3236404224U, 22},
	{3236405248U, 24},
	{3236405760U, 23},
	{3236406272U, 24},
	{3236409600U, 24},
	{3236409856U, 24},
	{3236412160U, 24},
	{3236413440U, 24},
	{3236413696U, 24},
	{3236415744U, 24},
	{3236416000U, 24},
	{3236416256U, 24},
	{3236419072U, 24},
	{3236423424U, 24},
	{3236423680U, 24},
	{3236423936U, 24},
	{3236429056U, 24},
	{3236433920U, 20},
	{3236446208U, 18},
	{3236462592U, 19},
	{3236515840U, 24},
	{3236516096U, 24},
	{3236517120U, 24},
	{3236532480U, 24},
	{3236563968U, 23},
	{3236564480U, 23},
	{3236564992U, 24},
	{3236565248U, 24},
	{3236565504U, 23},
	{3236566016U, 24},
	{3236577536U, 24},
	{3236579328U, 24},
	{3236585472U, 24},
	{3236586240U, 24},
	{3236595456U, 24},
	{3236596736U, 24},
	{3236600064U, 24},
	{3236601088U, 24},
	{3236603648U, 24},
	{3236603904U, 24},
	{3236604928U, 24},
	{3236605184U, 24},
	{3236605696U, 24},
	{3236605952U, 24},
	{3236606208U, 24},
	{3236620800U, 24},
	{3236621056U, 24},
	{3236624128U, 24},
	{3236625664U, 24},
	{3236626432U, 20},
	{3236630528U, 20},
	{3236700160U, 19},
	{3236765696U, 19},
	{3236789504U, 24},
	{3236900864U, 24},
	{3236944384U, 23},
	{3236954112U, 20},
	{3236988672U, 24},
	{3237031680U, 24},
	{3237195008U, 24},
	{3237204992U, 24},
	{3237217280U, 24},
	{3237218304U, 21},
	{3237221376U, 23},
	{3237222400U, 23},
	{3237235456U, 24},
	{3237236224U, 23},
	{3237236736U, 20},
	{3237243648U, 24},
	{3237253120U, 20},
	{3237268224U, 24},
	{3237269504U, 20},
	{3237275392U, 24},
	{3237279488U, 24},
	{3237281024U, 24},
	{3237281280U, 24},
	{3237286400U, 24},
	{3237286656U, 24},
	{3237286912U, 22},
	{3237288192U, 24},
	{3237288448U, 24},
	{3237288704U, 24},
	{3237288960U, 24},
	{3237289216U, 24},
	{3237290240U, 24},
	{3237291008U, 24},
	{3237292544U, 23},
	{3237296640U, 23},
	{3237302528U, 24},
	{3237303808U, 24},
	{3237304320U, 24},
	{3237304576U, 24},
	{3237304832U, 24},
	{3237305344U, 24},
	{3237308672U, 24},
	{3237308928U, 23},
	{3237309440U, 22},
	{3237310464U, 24},
	{3237312256U, 24},
	{3237318144U, 24},
	{3237324032U, 24},
	{3237325568U, 24},
	{3237326848U, 24},
	{3237329664U, 24},
	{3237330944U, 24},
	{3237337600U, 24},
	{3237341184U, 24},
	{3237341952U, 24},
	{3237345536U, 24},
	{3237345792U, 24},
	{3237349632U, 24},
	{3237351680U, 24},
	{3237356032U, 24},
	{3237357312U, 24},
	{3237368832U, 24},
	{3237369088U, 24},
	{3237369856U, 24},
	{3237373696U, 24},
	{3237374208U, 24},
	{3237377280U, 24},
	{3237378816U, 24},
	{3237385728U, 24},
	{3237387008U, 24},
	{3237391104U, 24},
	{3237393920U, 23},
	{3237403136U, 24},
	{3237404672U, 22},
	{3237405696U, 23},
	{3237406208U, 24},
	{3237406464U, 24},
	{3237406720U, 23},
	{3237407232U, 24},
	{3237407488U, 24},
	{3237416960U, 20},
	{3237445632U, 17},
	{3237478400U, 17},
	{3237550080U, 24},
	{3237555712U, 24},
	{3237555968U, 24},
	{3237556224U, 24},
	{3237556480U, 24},
	{3237616128U, 23},
	{3237638144U, 24},
	{3237676544U, 24},
	{3237676800U, 24},
	{3237678592U, 24},
	{3237683200U, 24},
	{3237683456U, 24},
	{3237686784U, 23},
	{3237689344U, 24},
	{3237691904U, 24},
	{3237692160U, 24},
	{3237692416U, 24},
	{3237692672U, 24},
	{3237698816U, 24},
	{3237699072U, 24},
	{3237708032U, 24},
	{3237712640U, 24},
	{3237721088U, 22},
	{3237723136U, 24},
	{3237724416U, 24},
	{3237724928U, 24},
	{3237731072U, 24},
	{3237731328U, 22},
	{3237732352U, 24},
	{3237732608U, 24},
	{3237740544U, 24},
	{3237756928U, 18},
	{3237760000U, 24},
	{3237815040U, 24},
	{3504147712U, 24},
	{3459513600U, 24},
	{3452698880U, 24},
	{3439276800U, 24},
	{3438158336U, 24},
	{3423722752U, 24},
	{3421381888U, 24},
	{3408062720U, 24},
	{3359935488U, 24},
	{3323057920U, 24},
	{3244730112U, 24},
	{3225715712U, 24},
	{2863267840U, 19},
	{2863325184U, 20},
	{2863332864U, 24},
	{3639555584U, 24},
	{3630677504U, 24},
	{3629419776U, 24},
	{3589225216U, 24},
	{3570210816U, 24},
	{3449312256U, 24},
	{3422434304U, 24},
	{3405892352U, 24},
	{3389114880U, 24},
	{3335326208U, 24},
	{3326444032U, 24},
	{3223577088U, 24},
	{2863333632U, 24},
	{2863333376U, 20},
	{2863394816U, 20},
	{2863397632U, 24},
	{2863398144U, 24},
	{2863397888U, 24},
	{3634053376U, 24},
	{3498727424U, 24},
	{3483919616U, 24},
	{3481945856U, 24},
	{3454804736U, 24},
	{3431613440U, 24},
	{3411516928U, 24},
	{3394739968U, 24},
	{3392272640U, 24},
	{3350821888U, 24},
	{3336510208U, 24},
	{3247065344U, 24},
	{3244599040U, 24},
	{3227821568U, 24},
	{3225846784U, 24},
	{3634983424U, 24},
	{3631525632U, 24},
	{3459316992U, 24},
	{3454870272U, 24},
	{3437105408U, 24},
	{3432666368U, 24},
	{3430202112U, 24},
	{3413425152U, 24},
	{3407010304U, 24},
	{3400097792U, 24},
	{3393687040U, 24},
	{3244664576U, 24},
	{3230353408U, 24},
	{3228874496U, 24},
	{2863214080U, 24},
	{3630349824U, 24},
	{3625306368U, 24},
	{3554217472U, 24},
	{3505012224U, 24},
	{3485430784U, 24},
	{3483194880U, 24},
	{3433981440U, 24},
	{3393228288U, 24},
	{3333319680U, 24},
	{3244467968U, 24},
	{3224892160U, 24},
	{3650895872U, 24},
	{3627477760U, 24},
	{3490041856U, 24},
	{3461389056U, 24},
	{3436712192U, 24},
	{3398255104U, 24},
	{3360726272U, 24},
	{3258380544U, 24},
	{2290941952U, 16},
	{3633205248U, 24},
	{3524772608U, 24},
	{3407337984U, 24},
	{3368682496U, 24},
	{3357006080U, 24},
	{3288777728U, 24},
	{3252362240U, 24},
	{3244336896U, 24},
	{3235585280U, 24},
	{3233643264U, 24},
	{3222786304U, 24},
	{2863398912U, 16},
	{2291007488U, 16},
	{3634249984U, 24},
	{3507929088U, 24},
	{3431941120U, 24},
	{3392469248U, 24},
	{3391481856U, 24},
	{3335195136U, 24},
	{3250354688U, 24},
	{3247393024U, 24},
	{3233577728U, 24},
	{3228612352U, 24},
	{2863464448U, 23},
	{2863464448U, 16},
	{3638965760U, 24},
	{3633398016U, 24},
	{3624458240U, 24},
	{3545011968U, 24},
	{3520400384U, 24},
	{3498072064U, 24},
	{3429804544U, 24},
	{3418621696U, 24},
	{3405198592U, 24},
	{3285523968U, 24},
	{3253088000U, 24},
	{2862743552U, 16},
	{3628964864U, 24},
	{3464578560U, 24},
	{3413093632U, 24},
	{3407403520U, 24},
	{3405133056U, 24},
	{3399704576U, 24},
	{3398456064U, 24},
	{3352566272U, 24},
	{3345981696U, 24},
	{3335789312U, 24},
	{3245319936U, 24},
	{3234139136U, 24},
	{3225088768U, 24},
	{3224101376U, 24},
	{2862809088U, 16},
	{3641366784U, 24},
	{3639944960U, 24},
	{3561918464U, 24},
	{3520531456U, 24},
	{3499313408U, 24},
	{3479149056U, 24},
	{3414311680U, 24},
	{3409573888U, 24},
	{3395264256U, 24},
	{3357268224U, 24},
	{3356149760U, 24},
	{3283187712U, 24},
	{3257458688U, 24},
	{3246241280U, 24},
	{3245123328U, 24},
	{3235323136U, 24},
	{3231738368U, 24},
	{2862612480U, 16},
	{3683795456U, 24},
	{3641432320U, 24},
	{3625634048U, 24},
	{3473657600U, 24},
	{3471122432U, 24},
	{3412962560U, 24},
	{3409508352U, 24},
	{3407534592U, 24},
	{3392731392U, 24},
	{3343876864U, 24},
	{3289105408U, 24},
	{3240747776U, 24},
	{3232791296U, 24},
	{3227424000U, 24},
	{2862678016U, 16},
	{3625830656U, 24},
	{3561525248U, 24},
	{3511194880U, 24},
	{3491610880U, 24},
	{3460300032U, 24},
	{3453030400U, 24},
	{3432338688U, 24},
	{3411648000U, 24},
	{3407731200U, 24},
	{3344536064U, 24},
	{3340621312U, 24},
	{3327759104U, 24},
	{3264568064U, 24},
	{3252825856U, 24},
	{3250588928U, 24},
	{3632615424U, 24},
	{3564806912U, 24},
	{3500636672U, 24},
	{3397730816U, 24},
	{3394805504U, 24},
	{3356346368U, 24},
	{3337763072U, 24},
	{3326706176U, 24},
	{3289236480U, 24},
	{3274694912U, 24},
	{3270655232U, 24},
	{3229267712U, 24},
	{3228280320U, 24},
	{2863072512U, 24},
	{2863072256U, 24},
	{2863072768U, 24},
	{2863071232U, 16},
	{3637708032U, 24},
	{3629878528U, 24},
	{3493716736U, 24},
	{3452043520U, 24},
	{3431351296U, 24},
	{3414573824U, 24},
	{3407862272U, 24},
	{3399770112U, 24},
	{3393059072U, 24},
	{3229202176U, 24},
	{3228083712U, 24},
	{3223310592U, 24},
	{2862874624U, 16},
	{3633725696U, 24},
	{3627870976U, 24},
	{3584392960U, 24},
	{3536981760U, 24},
	{3516287046U, 24},
	{3514344960U, 24},
	{3509449472U, 24},
	{3463030784U, 24},
	{3360394240U, 24},
	{3357464832U, 24},
	{3330756096U, 24},
	{3250785536U, 24},
	{3234008064U, 24},
	{2862940160U, 17},
	{2862940160U, 16},
	{2862972928U, 17},
	{3636163072U, 24},
	{3632808192U, 24},
	{3536588544U, 24},
	{3465041664U, 24},
	{3448263680U, 24},
	{3439272448U, 24},
	{3432596480U, 24},
	{3427047680U, 24},
	{3408066560U, 24},
	{3392399360U, 24},
	{3359939840U, 24},
	{3325289472U, 24},
	{3264825856U, 24},
	{2291728384U, 16},
	{301983744U, 24},
	{285212672U, 9},
	{285212672U, 8},
	{301985792U, 23},
	{290652160U, 16},
	{290717696U, 16},
	{290979840U, 16},
	{289406976U, 12},
	{289931264U, 16},
	{292552704U, 16},
	{293470208U, 15},
	{291962880U, 16},
	{292028416U, 16},
	{293601280U, 9},
	{301744384U, 24},
	{299368448U, 16},
	{298319872U, 14},
	{301608960U, 24},
	{298778624U, 16},
	{301662208U, 16},
	{292588544U, 22},
	{301858816U, 22},
	{3651887616U, 24},
	{3639551744U, 24},
	{3631660544U, 24},
	{3589220864U, 24},
	{3583532288U, 24},
	{3582544896U, 24},
	{3557872640U, 24},
	{3514218240U, 24},
	{3513230848U, 24},
	{3507540224U, 24},
	{3499644928U, 24},
	{3427113216U, 24},
	{3422430464U, 24},
	{3406875392U, 24},
	{3405896192U, 24},
	{3394539008U, 24},
	{3360005376U, 24},
	{3344204544U, 24},
	{3338786304U, 24},
	{3257135360U, 24},
	{3230226688U, 24},
	{3228022528U, 24},
	{3222323200U, 24},
	{2864316416U, 16},
	{2291662848U, 16},
	{3634057216U, 24},
	{3556588800U, 24},
	{3501816320U, 24},
	{3500698368U, 24},
	{3463817216U, 24},
	{3433592576U, 24},
	{3405961728U, 24},
	{3247069184U, 24},
	{3234733312U, 24},
	{3230292224U, 24},
	{3227825920U, 24},
	{3224494592U, 24},
	{3222519808U, 24},
	{2864250880U, 16},
	{2291859456U, 16},
	{3634979584U, 24},
	{3556523264U, 24},
	{3524448768U, 24},
	{3515566080U, 24},
	{3459312640U, 24},
	{3431683328U, 24},
	{3429219072U, 24},
	{3408001024U, 24},
	{3399107072U, 24},
	{3394670080U, 24},
	{3393691392U, 24},
	{3357670144U, 24},
	{3355191552U, 24},
	{3340891136U, 24},
	{2864188416U, 24},
	{2291793920U, 16},
	{3631463936U, 24},
	{3466413568U, 24},
	{3449636096U, 24},
	{3433985792U, 24},
	{3407203072U, 24},
	{3393232640U, 24},
	{3345133568U, 24},
	{3259012864U, 24},
	{3650900224U, 24},
	{3639289600U, 24},
	{3506060800U, 24},
	{3482146304U, 24},
	{3469284096U, 24},
	{3463620608U, 24},
	{3462641920U, 24},
	{3461384704U, 24},
	{3454743040U, 24},
	{3427829760U, 24},
	{3337304320U, 24},
	{3327164928U, 24},
	{3325486080U, 24},
	{3244537344U, 24},
	{3233704448U, 24},
	{2864578560U, 24},
	{2864611328U, 24},
	{2291924992U, 16},
	{3637118208U, 24},
	{3634319360U, 24},
	{3542409216U, 24},
	{3529549056U, 24},
	{3422102784U, 24},
	{3407334144U, 24},
	{3327361536U, 24},
	{3251248128U, 24},
	{3237555712U, 24},
	{2292121600U, 16},
	{3634253824U, 24},
	{3627350528U, 24},
	{3519745024U, 24},
	{3499051264U, 24},
	{3486192128U, 24},
	{3475373056U, 24},
	{3428956928U, 24},
	{3426020864U, 24},
	{3407268608U, 24},
	{3389512448U, 24},
	{3250350848U, 24},
	{3233573376U, 24},
	{2864447488U, 16},
	{2292056064U, 16},
	{3633401856U, 24},
	{3632283904U, 24},
	{3624454400U, 24},
	{3473464832U, 24},
	{3414184448U, 24},
	{2863857664U, 16},
	{2291204096U, 16},
	{3634586368U, 24},
	{3522576128U, 24},
	{3505798656U, 24},
	{3486778112U, 24},
	{3459968000U, 24},
	{3450041856U, 24},
	{3448784128U, 24},
	{3399708928U, 24},
	{3398451712U, 24},
	{3391879424U, 24},
	{3359304192U, 24},
	{3352562432U, 24},
	{3335784960U, 24},
	{3332603136U, 24},
	{3287690496U, 24},
	{3275415808U, 24},
	{3253157376U, 24},
	{3236380416U, 24},
	{3225084416U, 24},
	{2863792128U, 16},
	{2863812096U, 24},
	{2863812352U, 24},
	{3641362432U, 24},
	{3630144512U, 24},
	{3584060928U, 24},
	{3493458432U, 24},
	{3464648448U, 24},
	{3436642304U, 24},
	{3407596288U, 24},
	{3396123904U, 24},
	{3361704960U, 24},
	{3252960768U, 24},
	{3245127168U, 24},
	{2863726592U, 16},
	{3520470272U, 24},
	{3509182976U, 24},
	{3483464704U, 24},
	{3428747264U, 24},
	{3411971840U, 24},
	{3409504512U, 24},
	{3406551552U, 24},
	{3397168128U, 24},
	{3392727040U, 24},
	{3359173120U, 24},
	{3340420864U, 24},
	{3254005504U, 24},
	{3239756032U, 24},
	{3232786944U, 24},
	{3625834496U, 24},
	{3561521408U, 24},
	{3511190528U, 24},
	{3491614720U, 24},
	{3453026560U, 24},
	{3434571264U, 24},
	{3398779392U, 24},
	{3394866688U, 24},
	{3264563712U, 24},
	{3262882816U, 24},
	{3252829696U, 24},
	{3236052736U, 24},
	{3229899008U, 24},
	{3222065408U, 24},
	{2291466240U, 16},
	{3641559040U, 24},
	{3564810752U, 24},
	{3563823872U, 24},
	{3517409792U, 24},
	{3505536512U, 24},
	{3493786112U, 24},
	{3492799232U, 24},
	{3469738496U, 24},
	{3463166208U, 24},
	{3450304000U, 24},
	{3416748032U, 24},
	{3411578624U, 24},
	{3398713856U, 24},
	{3394801152U, 24},
	{3356350720U, 24},
	{3289240832U, 24},
	{3285192448U, 24},
	{3274698752U, 24},
	{3270650880U, 24},
	{3252895232U, 24},
	{3227026432U, 24},
	{3224367872U, 24},
	{2291400704U, 16},
	{3579547904U, 24},
	{3492602624U, 24},
	{3453157632U, 24},
	{3448132608U, 24},
	{3431355648U, 24},
	{3411775232U, 24},
	{3350555904U, 24},
	{3346637056U, 24},
	{3332668672U, 24},
	{3257725184U, 24},
	{3255751424U, 24},
	{3224171264U, 24},
	{3223306240U, 24},
	{2291597312U, 16},
	{3645606912U, 24},
	{3633729536U, 24},
	{3584388608U, 24},
	{3500501760U, 24},
	{3468890880U, 24},
	{3357460480U, 24},
	{3346571520U, 24},
	{3345592320U, 24},
	{3342656768U, 24},
	{3266603008U, 24},
	{3262686208U, 24},
	{3236965888U, 24},
	{3234012416U, 24},
	{2291583176U, 30},
	{2291531776U, 16},
	{2291548672U, 24},
	{2291557888U, 24},
	{2291557376U, 24},
	{2291583036U, 30},
	{2291583008U, 30},
	{3638372096U, 24},
	{3632820736U, 24},
	{3560162560U, 24},
	{3427052032U, 24},
	{3424832512U, 24},
	{3421374208U, 24},
	{3359944192U, 24},
	{3357722624U, 24},
	{3325286144U, 24},
	{3243619840U, 24},
	{3231283968U, 24},
	{3226842880U, 24},
	{587071488U, 24},
	{3631648000U, 24},
	{3490767616U, 24},
	{3476217344U, 24},
	{3449320960U, 24},
	{3430324480U, 24},
	{3405900032U, 24},
	{3393563648U, 24},
	{3254656000U, 24},
	{3244786944U, 24},
	{3237879040U, 24},
	{3231218432U, 24},
	{3224555776U, 24},
	{2292908032U, 16},
	{3512182272U, 24},
	{3486392576U, 24},
	{3428301568U, 24},
	{3416802048U, 24},
	{3335399424U, 24},
	{3325155072U, 24},
	{3285069056U, 24},
	{2861219840U, 24},
	{2861221888U, 24},
	{2292711424U, 16},
	{3637458432U, 24},
	{3624139264U, 24},
	{3585625088U, 24},
	{3582689024U, 24},
	{3564404992U, 24},
	{3422295552U, 24},
	{3389253632U, 24},
	{3343360256U, 24},
	{2861236224U, 16},
	{3563229184U, 24},
	{3483202560U, 24},
	{3462564352U, 24},
	{3433972736U, 24},
	{3398197248U, 24},
	{3355765248U, 24},
	{3237682432U, 24},
	{3226580736U, 24},
	{2861301760U, 16},
	{2293104640U, 16},
	{3650904576U, 24},
	{3627469056U, 24},
	{3586018304U, 24},
	{3558139648U, 24},
	{3555401472U, 24},
	{3506048256U, 24},
	{3489272320U, 24},
	{3458715136U, 24},
	{3435733504U, 24},
	{3412299520U, 24},
	{3355056640U, 24},
	{3328410112U, 24},
	{3327176960U, 24},
	{3251187456U, 24},
	{3247270656U, 24},
	{3224817920U, 24},
	{2861377280U, 24},
	{2861377024U, 24},
	{2861376768U, 24},
	{2861376000U, 24},
	{2861375488U, 24},
	{2861379072U, 24},
	{2861378560U, 24},
	{2861378048U, 24},
	{2861377536U, 24},
	{2861381376U, 24},
	{2861380864U, 24},
	{2861380608U, 24},
	{2861383168U, 24},
	{2861382912U, 24},
	{2861382656U, 24},
	{2861382400U, 24},
	{2861381888U, 24},
	{2861381632U, 24},
	{2861368320U, 24},
	{2861368064U, 24},
	{2861367296U, 16},
	{2861370880U, 24},
	{2861370624U, 24},
	{2861369600U, 24},
	{2861372416U, 22},
	{2861371648U, 24},
	{2861375232U, 24},
	{2861374976U, 24},
	{2861374720U, 24},
	{2861374208U, 24},
	{2861373696U, 24},
	{2861393152U, 24},
	{2861392896U, 24},
	{2861392640U, 24},
	{2861395712U, 24},
	{2861395456U, 24},
	{2861394944U, 24},
	{2861394432U, 24},
	{2861396736U, 24},
	{2861396480U, 24},
	{2861395968U, 24},
	{2861384704U, 22},
	{2861384192U, 24},
	{2861383936U, 24},
	{2861383680U, 24},
	{2861387520U, 24},
	{2861387264U, 24},
	{2861387008U, 24},
	{2861386240U, 24},
	{2861385984U, 24},
	{2861385728U, 24},
	{2861388544U, 24},
	{2861388288U, 24},
	{2861409792U, 24},
	{2861409536U, 24},
	{2861410304U, 22},
	{2861405696U, 24},
	{2861405440U, 24},
	{2861405184U, 24},
	{2861404928U, 24},
	{2861404672U, 24},
	{2861404416U, 24},
	{2861407488U, 24},
	{2861407232U, 24},
	{2861426432U, 24},
	{2861426176U, 24},
	{2861425920U, 24},
	{2861425664U, 24},
	{2861425408U, 24},
	{2861425152U, 24},
	{2861424896U, 24},
	{2861424640U, 24},
	{2861428480U, 24},
	{2861428224U, 24},
	{2861427712U, 24},
	{2861427200U, 24},
	{2861430528U, 24},
	{2861430272U, 24},
	{2861428992U, 24},
	{2861428736U, 24},
	{2861432576U, 24},
	{2861432320U, 24},
	{2861424384U, 24},
	{2861424128U, 24},
	{2861423872U, 24},
	{3559183360U, 24},
	{3491226368U, 24},
	{3470471424U, 24},
	{3465438208U, 24},
	{3449779712U, 24},
	{3419022592U, 24},
	{3391408640U, 24},
	{3357014784U, 24},
	{3342194176U, 24},
	{3327373568U, 24},
	{3262224128U, 24},
	{3223633920U, 24},
	{3222795008U, 24},
	{2861445376U, 24},
	{2861432832U, 17},
	{2861432832U, 16},
	{2861461248U, 24},
	{2861463808U, 24},
	{2861455616U, 24},
	{2861465600U, 17},
	{2861468672U, 23},
	{2861468416U, 24},
	{2861469952U, 24},
	{2861472000U, 24},
	{2861494528U, 24},
	{2861498112U, 24},
	{2861489664U, 24},
	{2292973568U, 16},
	{3627337984U, 24},
	{3504937984U, 24},
	{3486195968U, 24},
	{3462498816U, 24},
	{3458584064U, 24},
	{3448727296U, 24},
	{3438809344U, 24},
	{3413155328U, 24},
	{3407280128U, 24},
	{3398393856U, 24},
	{3389515776U, 24},
	{3358906624U, 24},
	{3273060352U, 24},
	{3233569024U, 24},
	{3225658880U, 24},
	{2861507072U, 24},
	{2861509888U, 24},
	{2861509632U, 24},
	{2861510144U, 24},
	{2861511680U, 22},
	{2861510656U, 24},
	{2861513728U, 22},
	{2861498368U, 17},
	{2861498368U, 16},
	{2861501696U, 24},
	{2861501440U, 24},
	{2861502208U, 24},
	{2861501952U, 24},
	{2861501184U, 24},
	{2861518848U, 24},
	{2861531136U, 17},
	{2861551360U, 24},
	{2861554944U, 24},
	{2861554688U, 24},
	{3514858240U, 24},
	{3491357440U, 24},
	{3477907712U, 24},
	{3465639168U, 24},
	{3434304768U, 24},
	{3432085248U, 24},
	{3429795840U, 24},
	{3407476736U, 24},
	{3395140864U, 24},
	{3264313600U, 24},
	{3253079296U, 24},
	{3245245696U, 24},
	{3240804608U, 24},
	{2860515328U, 16},
	{2860558848U, 24},
	{2860560128U, 24},
	{2292326400U, 19},
	{2292318208U, 19},
	{2292318208U, 16},
	{2292334592U, 19},
	{2292383232U, 24},
	{3484571136U, 24},
	{3469025280U, 24},
	{3463416320U, 24},
	{3448796672U, 24},
	{3399696896U, 24},
	{3398463744U, 24},
	{3354794496U, 24},
	{3241857024U, 24},
	{3226314240U, 24},
	{2860580864U, 16},
	{2292383744U, 16},
	{3638825984U, 24},
	{3520540160U, 24},
	{3510222848U, 24},
	{3493445888U, 24},
	{3485868288U, 24},
	{3455389696U, 24},
	{3434173696U, 24},
	{3398660352U, 24},
	{3397541888U, 24},
	{3356158464U, 24},
	{3333512960U, 24},
	{2860646400U, 16},
	{2292187136U, 16},
	{3560490240U, 24},
	{3504675840U, 24},
	{3485933824U, 24},
	{3413941760U, 24},
	{3409500672U, 24},
	{3407542272U, 24},
	{3406555392U, 24},
	{3397607424U, 24},
	{3392723712U, 24},
	{3353676544U, 24},
	{3341403904U, 24},
	{3286568704U, 24},
	{3251056384U, 24},
	{3240739072U, 24},
	{3222004224U, 24},
	{2860711936U, 16},
	{2860746752U, 21},
	{2860752128U, 24},
	{2860748800U, 22},
	{2860749824U, 22},
	{2860771328U, 21},
	{2860773376U, 21},
	{2292252672U, 16},
	{2292257024U, 24},
	{3557619200U, 24},
	{3519037184U, 24},
	{3463088640U, 24},
	{3450225920U, 24},
	{3428432640U, 24},
	{3414450432U, 24},
	{3397099264U, 24},
	{3393182464U, 24},
	{3356289536U, 24},
	{3344543744U, 24},
	{3341731584U, 24},
	{3263457280U, 24},
	{3250597632U, 24},
	{2292580352U, 16},
	{3631910144U, 24},
	{3510550528U, 24},
	{3503304448U, 24},
	{3479931648U, 24},
	{3455193088U, 24},
	{3429599232U, 24},
	{3394813184U, 24},
	{3393116928U, 24},
	{3390896384U, 24},
	{3330632704U, 24},
	{3274687232U, 24},
	{3252882688U, 24},
	{3230956288U, 24},
	{2292645888U, 16},
	{3562775296U, 24},
	{3521125632U, 24},
	{3491750656U, 24},
	{3471905536U, 24},
	{3432478464U, 24},
	{3431360000U, 24},
	{3393891328U, 24},
	{3360337408U, 24},
	{3356420608U, 24},
	{3353348864U, 24},
	{3336571392U, 24},
	{3335731456U, 24},
	{3231152896U, 24},
	{3230034432U, 24},
	{2860908544U, 16},
	{2292449280U, 16},
	{3505392896U, 24},
	{3501476096U, 24},
	{3428498176U, 24},
	{3407804416U, 24},
	{3399827968U, 24},
	{3357473536U, 24},
	{2860974080U, 16},
	{2292514816U, 16},
	{3641834240U, 24},
	{3638375936U, 24},
	{3632816896U, 24},
	{3531052544U, 24},
	{3489719040U, 24},
	{3475168768U, 24},
	{3411389696U, 24},
	{3408058880U, 24},
	{3405838336U, 24},
	{3392391680U, 24},
	{3361058304U, 24},
	{3359948544U, 24},
	{3353159936U, 24},
	{3328611072U, 24},
	{3261503232U, 24},
	{3252498176U, 24},
	{3238064640U, 24},
	{3225728768U, 24},
	{2862158848U, 23},
	{2862153728U, 22},
	{2862153728U, 17},
	{2862153728U, 16},
	{2862181376U, 24},
	{2862194688U, 19},
	{2862190592U, 20},
	{2862188288U, 24},
	{2862188032U, 24},
	{2862189056U, 23},
	{2862189568U, 22},
	{2862208000U, 22},
	{2862209024U, 21},
	{2862202880U, 18},
	{2293956608U, 16},
	{3631651840U, 24},
	{3511990016U, 24},
	{3492990976U, 24},
	{3452776960U, 24},
	{3356551680U, 24},
	{3259348224U, 24},
	{3244790784U, 24},
	{3239109376U, 24},
	{3231214080U, 24},
	{3228013824U, 24},
	{3226772992U, 24},
	{3223572736U, 24},
	{2862088192U, 16},
	{2293891072U, 16},
	{3556960000U, 24},
	{3505130752U, 24},
	{3499850240U, 24},
	{3454799872U, 24},
	{3448403456U, 24},
	{3433583872U, 24},
	{3413479168U, 24},
	{3407927808U, 24},
	{3365626368U, 24},
	{3325150720U, 24},
	{3285072896U, 24},
	{3247077888U, 24},
	{3224485888U, 24},
	{2862284800U, 16},
	{2293825536U, 16},
	{3588111104U, 24},
	{3583672064U, 24},
	{3564408832U, 24},
	{3515574784U, 24},
	{3482022912U, 24},
	{3469684992U, 24},
	{3467204352U, 24},
	{3437109760U, 24},
	{3430189056U, 24},
	{3412434432U, 24},
	{3407014144U, 24},
	{3389257984U, 24},
	{3366539520U, 24},
	{3236764928U, 24},
	{3234807552U, 24},
	{3230366464U, 24},
	{3226904064U, 24},
	{3225925376U, 24},
	{2862219264U, 16},
	{2293760000U, 16},
	{3563225344U, 24},
	{3530790400U, 24},
	{3449644800U, 24},
	{3409431296U, 24},
	{3406100480U, 24},
	{3359098880U, 24},
	{3322213632U, 24},
	{3256213504U, 24},
	{3243353856U, 24},
	{3234348800U, 24},
	{3226576384U, 24},
	{2862415872U, 16},
	{3627472896U, 24},
	{3586022656U, 24},
	{3558143488U, 24},
	{3555397120U, 24},
	{3533469696U, 24},
	{3506052096U, 24},
	{3498928896U, 24},
	{3488289280U, 24},
	{3458719488U, 24},
	{3407145216U, 24},
	{3406166016U, 24},
	{3356813824U, 24},
	{3337296640U, 24},
	{3327172608U, 24},
	{3274166784U, 24},
	{3256147968U, 24},
	{3695356672U, 24},
	{3638244864U, 24},
	{3636285440U, 24},
	{3559179520U, 24},
	{3511924480U, 24},
	{3508846592U, 24},
	{3483329792U, 24},
	{3453690624U, 24},
	{3452580352U, 24},
	{3407341824U, 24},
	{3401400832U, 24},
	{3394481152U, 24},
	{3391412992U, 24},
	{3367845888U, 24},
	{3247340032U, 24},
	{3231672832U, 24},
	{2862546944U, 22},
	{2862546944U, 16},
	{3502976768U, 24},
	{3463481856U, 24},
	{3462503168U, 24},
	{3452645888U, 24},
	{3438804992U, 24},
	{3412172288U, 24},
	{3411193088U, 24},
	{3407276288U, 24},
	{3392457216U, 24},
	{3389520128U, 24},
	{3337165568U, 24},
	{3273056512U, 24},
	{3250342144U, 24},
	{3233564672U, 24},
	{2862481408U, 16},
	{3628904192U, 24},
	{3584183296U, 24},
	{3583082240U, 24},
	{3524915200U, 24},
	{3499194880U, 24},
	{3413024256U, 24},
	{3400745472U, 24},
	{3353745920U, 24},
	{3322475776U, 24},
	{3263137280U, 24},
	{3245249536U, 24},
	{3227362816U, 24},
	{3226253056U, 24},
	{2861629440U, 24},
	{2861629440U, 16},
	{2293432320U, 16},
	{3641305600U, 24},
	{3519360512U, 24},
	{3500361984U, 24},
	{3471250176U, 24},
	{3466811136U, 24},
	{3448792832U, 24},
	{3399701248U, 24},
	{3398459392U, 24},
	{3392850432U, 24},
	{3357075968U, 24},
	{3237350400U, 24},
	{3236371712U, 24},
	{2861563904U, 16},
	{3641371136U, 24},
	{3639940096U, 24},
	{3638822144U, 24},
	{3624594176U, 24},
	{3493449728U, 24},
	{3426339840U, 24},
	{3424382464U, 24},
	{3417391872U, 24},
	{3409562368U, 24},
	{3398656000U, 24},
	{3397225984U, 24},
	{3391675136U, 24},
	{3240677376U, 24},
	{3237284864U, 24},
	{3236175104U, 24},
	{3228341504U, 24},
	{2861760512U, 16},
	{2293301248U, 16},
	{3520478976U, 24},
	{3517995264U, 24},
	{3455320320U, 24},
	{3454341120U, 24},
	{3407538432U, 24},
	{3406559232U, 24},
	{3397611776U, 24},
	{3392719360U, 24},
	{3359164416U, 24},
	{3343888384U, 24},
	{3253996800U, 24},
	{3246163200U, 24},
	{3241722112U, 24},
	{3229842176U, 24},
	{2861694976U, 16},
	{2861718272U, 24},
	{2861743104U, 23},
	{2861740288U, 24},
	{2861754880U, 24},
	{2861753344U, 24},
	{2861753856U, 24},
	{2861754112U, 24},
	{2861749760U, 24},
	{2861745664U, 24},
	{2861745920U, 24},
	{2293235712U, 16},
	{3628642048U, 24},
	{3589478656U, 24},
	{3584445440U, 24},
	{3516234496U, 24},
	{3504475392U, 24},
	{3450229760U, 24},
	{3428428288U, 24},
	{3414454272U, 24},
	{3406624768U, 24},
	{3397094912U, 24},
	{3393178112U, 24},
	{3359623168U, 24},
	{3344539904U, 24},
	{3327762432U, 24},
	{3252820992U, 24},
	{3250601472U, 24},
	{2293694464U, 16},
	{3628707808U, 16},
	{3587193600U, 24},
	{3509567488U, 24},
	{3463158528U, 24},
	{3450295296U, 24},
	{3436192256U, 24},
	{3426667520U, 24},
	{3409890048U, 24},
	{3407669504U, 24},
	{3394808832U, 24},
	{3358578944U, 24},
	{3356359424U, 24},
	{3344474368U, 24},
	{3326718208U, 24},
	{3326002688U, 24},
	{3274691072U, 24},
	{3263527168U, 24},
	{3234868736U, 24},
	{2861834240U, 19},
	{2861826048U, 19},
	{2861826048U, 16},
	{2861850624U, 19},
	{2861849600U, 22},
	{2861847552U, 24},
	{2861873152U, 24},
	{2861872128U, 24},
	{2861872384U, 24},
	{2861871616U, 24},
	{2861871360U, 24},
	{2861858816U, 19},
	{2293628928U, 17},
	{2293628928U, 16},
	{2293661696U, 17},
	{3667357696U, 24},
	{3637720576U, 24},
	{3579556608U, 24},
	{3575641856U, 24},
	{3528107264U, 24},
	{3493711872U, 24},
	{3449251584U, 24},
	{3346629376U, 24},
	{3345519104U, 24},
	{3257717504U, 24},
	{2293563392U, 16},
	{3659462656U, 24},
	{3524256000U, 24},
	{3514340608U, 24},
	{3509436416U, 24},
	{3490702080U, 24},
	{3478825216U, 24},
	{3455058176U, 24},
	{3406821376U, 24},
	{3357469184U, 24},
	{3234021120U, 24},
	{3223249408U, 24},
	{2293497856U, 16},
	{3559043584U, 24},
	{3515358464U, 24},
	{3510948096U, 24},
	{3438175744U, 24},
	{3433701888U, 24},
	{3424823808U, 24},
	{3411401216U, 24},
	{3408047360U, 24},
	{3405811456U, 24},
	{3357715968U, 24},
	{3325276416U, 24},
	{3323040512U, 24},
	{3276063488U, 24},
	{3274945536U, 24},
	{3261521920U, 24},
	{3244745472U, 24},
	{3241391616U, 24},
	{3231259904U, 24},
	{3230141440U, 24},
	{3227968000U, 24},
	{2295070720U, 17},
	{2295070720U, 16},
	{2295119872U, 21},
	{2295122944U, 23},
	{2295121920U, 23},
	{2295124992U, 23},
	{2295123968U, 23},
	{2295127040U, 23},
	{2295126016U, 23},
	{2295128064U, 24},
	{1155572736U, 22},
	{1151129600U, 22},
	{1150868480U, 22},
	{1146359808U, 20},
	{1145572352U, 22},
	{1145372928U, 24},
	{1145307136U, 19},
	{1141920768U, 22},
	{1154846720U, 21},
	{1151921408U, 24},
	{1151195136U, 21},
	{1146425344U, 20},
	{1145372672U, 24},
	{1145111552U, 23},
	{1144352768U, 20},
	{1143300096U, 19},
	{1142247424U, 20},
	{1141921024U, 24},
	{1154520576U, 23},
	{1149681664U, 20},
	{1145438208U, 19},
	{1145373440U, 24},
	{1144418304U, 20},
	{1142708736U, 23},
	{1142312960U, 22},
	{1154586112U, 23},
	{1151326208U, 21},
	{1148661760U, 20},
	{1145503744U, 19},
	{1145373184U, 23},
	{1145242624U, 24},
	{1145112064U, 23},
	{1143431168U, 19},
	{1142378496U, 22},
	{1141921536U, 24},
	{1155571712U, 22},
	{1151130624U, 22},
	{1150867456U, 22},
	{1148597760U, 23},
	{1148203008U, 21},
	{1147150336U, 20},
	{1145571328U, 22},
	{1145373952U, 24},
	{1145044992U, 20},
	{1145044992U, 13},
	{1142972416U, 20},
	{1141919744U, 23},
	{1140867072U, 18},
	{1154584576U, 22},
	{1150932992U, 21},
	{1145373696U, 24},
	{1145110528U, 22},
	{1141920000U, 24},
	{1154650112U, 21},
	{1151920640U, 24},
	{1151524864U, 19},
	{1150998528U, 21},
	{1148334080U, 21},
	{1145176064U, 20},
	{1142313984U, 22},
	{1142050816U, 20},
	{1141920256U, 23},
	{1154715648U, 20},
	{1151064064U, 21},
	{1150868224U, 24},
	{1148399616U, 20},
	{1147346944U, 21},
	{1145241600U, 24},
	{1144221696U, 20},
	{1142379520U, 22},
	{1142116352U, 20},
	{1154522112U, 22},
	{1152180224U, 19},
	{1151127552U, 22},
	{1150866432U, 23},
	{1150074880U, 19},
	{1148206080U, 22},
	{1145831424U, 20},
	{1145570304U, 22},
	{1145245440U, 24},
	{1141922816U, 23},
	{1154848768U, 21},
	{1154587648U, 23},
	{1150140416U, 20},
	{1148002304U, 19},
	{1147480064U, 22},
	{1145896960U, 19},
	{1145374720U, 21},
	{1141988352U, 22},
	{1151919616U, 24},
	{1151258624U, 20},
	{1150997504U, 22},
	{1150866944U, 23},
	{1148067840U, 19},
	{1145962496U, 20},
	{1145244928U, 24},
	{1144942592U, 20},
	{1142706688U, 23},
	{1142315008U, 22},
	{1141923328U, 23},
	{1141784576U, 19},
	{1154588160U, 23},
	{1151324160U, 21},
	{1149749248U, 21},
	{1148272128U, 24},
	{1148133376U, 20},
	{1142380544U, 22},
	{1141850112U, 19},
	{1155573760U, 21},
	{1154521088U, 23},
	{1153990656U, 17},
	{1151918080U, 20},
	{1151128576U, 22},
	{1150865408U, 24},
	{1149812736U, 19},
	{1148205056U, 22},
	{1145569280U, 22},
	{1145569280U, 16},
	{1141921792U, 23},
	{1154586624U, 22},
	{1153036288U, 20},
	{1151983616U, 19},
	{1150930944U, 21},
	{1150865664U, 24},
	{1149878272U, 19},
	{1147740160U, 20},
	{1147481088U, 22},
	{1145634816U, 19},
	{1145112576U, 21},
	{1154652160U, 21},
	{1153101824U, 20},
	{1152049152U, 20},
	{1150996480U, 22},
	{1150865920U, 24},
	{1150865920U, 23},
	{1148858368U, 20},
	{1148336128U, 21},
	{1145700352U, 19},
	{1142316032U, 22},
	{1141922304U, 24},
	{1141922304U, 23},
	{1153167360U, 20},
	{1151918848U, 24},
	{1151062016U, 21},
	{1147348992U, 21},
	{1145765888U, 20},
	{1145243648U, 24},
	{1142381568U, 22},
	{1154515968U, 23},
	{1151125504U, 22},
	{1150864384U, 22},
	{1148461056U, 19},
	{1146355712U, 20},
	{1142177792U, 19},
	{1141916672U, 23},
	{1141916672U, 22},
	{1154842624U, 21},
	{1152057088U, 24},
	{1151191040U, 21},
	{1148526592U, 19},
	{1147482112U, 20},
	{1146421248U, 20},
	{1145376768U, 20},
	{1145247232U, 23},
	{1144348672U, 20},
	{1142243328U, 22},
	{1149685760U, 20},
	{1148592128U, 19},
	{1148461568U, 23},
	{1146486784U, 19},
	{1145968640U, 22},
	{1144414208U, 20},
	{1142308864U, 22},
	{1154582016U, 23},
	{1148657664U, 20},
	{1142374400U, 22},
	{1141917440U, 24},
	{1154514944U, 21},
	{1151126528U, 22},
	{1150863360U, 22},
	{1148198912U, 21},
	{1147154432U, 20},
	{1146093568U, 15},
	{1145049088U, 20},
	{1142976512U, 20},
	{1141915648U, 23},
	{1141915648U, 22},
	{1152056064U, 24},
	{1148264448U, 19},
	{1147746304U, 21},
	{1145114624U, 20},
	{1142244352U, 22},
	{1141981184U, 24},
	{1141981184U, 22},
	{1154646016U, 20},
	{1154581248U, 24},
	{1148856320U, 21},
	{1146224640U, 17},
	{1145969664U, 22},
	{1145180160U, 20},
	{1142309888U, 22},
	{1142046720U, 20},
	{1141981952U, 24},
	{1141916160U, 24},
	{1154711552U, 20},
	{1153165312U, 21},
	{1148395520U, 21},
	{1147351040U, 21},
	{1146290176U, 18},
	{1145245696U, 21},
	{1144217600U, 20},
	{1142375424U, 22},
	{1154518016U, 22},
	{1151123456U, 22},
	{1150862336U, 23},
	{1148333568U, 23},
	{1148201984U, 22},
	{1145835520U, 20},
	{1145444864U, 24},
	{1141918720U, 24},
	{1154844672U, 21},
	{1154583552U, 23},
	{1151188992U, 21},
	{1150144512U, 20},
	{1142245376U, 22},
	{1141984256U, 24},
	{1141984256U, 22},
	{1141918976U, 24},
	{1151254528U, 20},
	{1148333056U, 22},
	{1145249024U, 24},
	{1144938496U, 20},
	{1142310912U, 21},
	{1141919232U, 23},
	{1154584064U, 23},
	{1151467008U, 24},
	{1151320064U, 20},
	{1151320064U, 19},
	{1150863104U, 24},
	{1149753344U, 21},
	{1148137472U, 20},
	{1145248768U, 24},
	{1145004032U, 19},
	{1142376448U, 22},
	{1155577856U, 21},
	{1151922176U, 20},
	{1151124480U, 22},
	{1150861312U, 23},
	{1148723200U, 19},
	{1148200960U, 22},
	{1148200960U, 21},
	{1146617856U, 14},
	{1145573376U, 20},
	{1142439936U, 19},
	{1142439936U, 18},
	{1141917696U, 23},
	{1154582528U, 23},
	{1153032192U, 20},
	{1150926848U, 20},
	{1147744256U, 21},
	{1145446144U, 24},
	{1142505472U, 18},
	{1142246400U, 22},
	{1141983232U, 22},
	{1153097728U, 20},
	{1152053248U, 20},
	{1150992384U, 20},
	{1150861824U, 24},
	{1148854272U, 21},
	{1148595200U, 23},
	{1148332032U, 22},
	{1145837056U, 24},
	{1142571008U, 18},
	{1141918208U, 24},
	{1154583040U, 23},
	{1153163264U, 21},
	{1151057920U, 20},
	{1150862080U, 24},
	{1149491200U, 21},
	{1148397568U, 21},
	{1147353088U, 21},
	{1145769984U, 20},
	{1145247744U, 22},
	{1142377472U, 22},
	{1141918464U, 24},
	{1151137792U, 22},
	{1150876672U, 24},
	{1148588544U, 24},
	{1147404288U, 16},
	{1146368000U, 20},
	{1145315328U, 19},
	{1154593792U, 22},
	{1151203328U, 22},
	{1150942208U, 22},
	{1147469824U, 19},
	{1145380864U, 21},
	{1144344576U, 20},
	{1143291904U, 20},
	{1141994496U, 22},
	{1150877184U, 24},
	{1149689856U, 20},
	{1148588032U, 24},
	{1147535360U, 15},
	{1145446400U, 19},
	{1144410112U, 20},
	{1143357440U, 18},
	{1142716928U, 23},
	{1150877440U, 24},
	{1149755392U, 21},
	{1148653568U, 21},
	{1148588288U, 24},
	{1148127232U, 22},
	{1145511936U, 20},
	{1143422976U, 20},
	{1155563520U, 19},
	{1151911936U, 24},
	{1151385600U, 18},
	{1151336192U, 24},
	{1151138816U, 22},
	{1150875648U, 23},
	{1148194816U, 20},
	{1147142144U, 20},
	{1147142144U, 13},
	{1145513728U, 24},
	{1145053184U, 20},
	{1142964224U, 20},
	{1141927936U, 21},
	{1154592768U, 23},
	{1151335936U, 24},
	{1151204352U, 22},
	{1150941184U, 22},
	{1147207680U, 16},
	{1146697728U, 23},
	{1145118720U, 19},
	{1141993472U, 22},
	{1154658304U, 20},
	{1153095680U, 21},
	{1151516672U, 19},
	{1151335680U, 24},
	{1150876160U, 23},
	{1148589056U, 22},
	{1148458496U, 23},
	{1147273216U, 17},
	{1145184256U, 20},
	{1142059008U, 20},
	{1154593280U, 23},
	{1151335424U, 24},
	{1151072256U, 21},
	{1148391424U, 20},
	{1148128256U, 22},
	{1147338752U, 19},
	{1145249792U, 19},
	{1142124544U, 20},
	{1152172032U, 20},
	{1151135744U, 22},
	{1150874624U, 23},
	{1150083072U, 20},
	{1147928576U, 17},
	{1147928576U, 15},
	{1145839616U, 20},
	{1154595840U, 22},
	{1151201280U, 21},
	{1150940160U, 22},
	{1150148608U, 20},
	{1147994112U, 21},
	{1145905152U, 19},
	{1145382912U, 23},
	{1141996544U, 22},
	{1151266816U, 20},
	{1150875136U, 24},
	{1150875136U, 23},
	{1148590080U, 21},
	{1148059648U, 20},
	{1148059648U, 15},
	{1145970688U, 20},
	{1145383680U, 24},
	{1145317888U, 23},
	{1145122560U, 24},
	{1142714880U, 23},
	{1141792768U, 19},
	{1148655616U, 21},
	{1145383424U, 24},
	{1145122304U, 24},
	{1144999936U, 20},
	{1143947264U, 18},
	{1141858304U, 19},
	{1154529280U, 22},
	{1151909888U, 20},
	{1151136768U, 22},
	{1150873600U, 24},
	{1149820928U, 19},
	{1148719104U, 20},
	{1147666432U, 17},
	{1147666432U, 15},
	{1145577472U, 20},
	{1145318400U, 23},
	{1143488512U, 18},
	{1141929984U, 21},
	{1153028096U, 20},
	{1151975424U, 19},
	{1151519488U, 24},
	{1150939136U, 22},
	{1150873856U, 24},
	{1149886464U, 19},
	{1147731968U, 20},
	{1146695680U, 21},
	{1145643008U, 19},
	{1145383936U, 22},
	{1143554048U, 18},
	{1141995520U, 22},
	{1153093632U, 21},
	{1152040960U, 19},
	{1151004672U, 20},
	{1150874112U, 23},
	{1147797504U, 18},
	{1147797504U, 15},
	{1146630656U, 23},
	{1145708544U, 20},
	{1143619584U, 18},
	{1154595328U, 23},
	{1153159168U, 20},
	{1152106496U, 18},
	{1151070208U, 21},
	{1147863040U, 17},
	{1145774080U, 19},
	{1143685120U, 18},
	{1151133696U, 22},
	{1150872576U, 23},
	{1148452864U, 19},
	{1146363904U, 20},
	{1145584640U, 22},
	{1145319424U, 20},
	{1145255680U, 24},
	{1145189888U, 24},
	{1142185984U, 22},
	{1142185984U, 19},
	{1154850816U, 21},
	{1154589696U, 22},
	{1151199232U, 21},
	{1150938112U, 22},
	{1148518400U, 19},
	{1147739136U, 23},
	{1146429440U, 19},
	{1145384960U, 22},
	{1145190144U, 24},
	{1145123840U, 24},
	{1144340480U, 20},
	{1143296000U, 20},
	{1142251520U, 19},
	{1141990400U, 22},
	{1151264768U, 21},
	{1150873088U, 23},
	{1149693952U, 20},
	{1148583936U, 20},
	{1146494976U, 19},
	{1145450496U, 20},
	{1145255168U, 24},
	{1145189376U, 24},
	{1144406016U, 20},
	{1142317056U, 19},
	{1150873344U, 24},
	{1149759488U, 21},
	{1148649472U, 20},
	{1145516032U, 20},
	{1143427072U, 20},
	{1142382592U, 19},
	{1154523136U, 24},
	{1151134720U, 22},
	{1150871552U, 24},
	{1148190720U, 20},
	{1147146240U, 20},
	{1145583616U, 22},
	{1145123072U, 24},
	{1145057280U, 20},
	{1142968320U, 20},
	{1141923840U, 21},
	{1154588672U, 22},
	{1150937088U, 22},
	{1150871808U, 24},
	{1148256256U, 19},
	{1147738112U, 22},
	{1145385984U, 24},
	{1145189120U, 24},
	{1141989376U, 23},
	{1154654208U, 20},
	{1150872064U, 24},
	{1148848128U, 21},
	{1148321792U, 19},
	{1145386752U, 24},
	{1145188352U, 23},
	{1142253312U, 24},
	{1142054912U, 20},
	{1154719744U, 20},
	{1150872320U, 24},
	{1149497344U, 20},
	{1148387328U, 20},
	{1144209408U, 19},
	{1142120448U, 21},
	{1141989888U, 23},
	{1152176128U, 20},
	{1151131648U, 22},
	{1150870528U, 23},
	{1150087168U, 20},
	{1145843712U, 20},
	{1145582592U, 22},
	{1145191936U, 23},
	{1144799232U, 18},
	{1154591744U, 22},
	{1152046848U, 24},
	{1151197184U, 21},
	{1147998208U, 20},
	{1145387008U, 21},
	{1141992448U, 22},
	{1151262720U, 21},
	{1150871040U, 24},
	{1150871040U, 23},
	{1148063744U, 20},
	{1145974784U, 20},
	{1144930304U, 19},
	{1149761536U, 21},
	{1148129280U, 20},
	{1144995840U, 20},
	{1152958464U, 18},
	{1151913984U, 20},
	{1151132672U, 22},
	{1150869504U, 22},
	{1149302784U, 21},
	{1148715008U, 15},
	{1145581568U, 22},
	{1145190912U, 24},
	{1142448128U, 19},
	{1141925888U, 22},
	{1154590720U, 23},
	{1153024000U, 20},
	{1152045824U, 24},
	{1150935040U, 21},
	{1147736064U, 21},
	{1145191168U, 24},
	{1144602624U, 18},
	{1141991424U, 22},
	{1153089536U, 20},
	{1151000576U, 20},
	{1148846080U, 21},
	{1148846080U, 16},
	{1145712640U, 20},
	{1145190400U, 24},
	{1154591232U, 23},
	{1153155072U, 20},
	{1151066112U, 20},
	{1145190656U, 24},
	{1144733696U, 18},
	{1142122496U, 21},
	{1154797568U, 20},
	{1151113216U, 22},
	{1148481536U, 20},
	{1146376192U, 20},
	{1145323520U, 20},
	{1141904384U, 23},
	{1141904384U, 22},
	{1141112832U, 15},
	{1154863104U, 20},
	{1154601984U, 22},
	{1150917632U, 22},
	{1148547072U, 22},
	{1148152320U, 23},
	{1147494400U, 19},
	{1146441728U, 20},
	{1145654272U, 22},
	{1145389056U, 19},
	{1143283712U, 19},
	{1141969920U, 24},
	{1151113728U, 23},
	{1150852608U, 24},
	{1149665280U, 19},
	{1145454592U, 19},
	{1145259264U, 24},
	{1143349248U, 20},
	{1141243904U, 15},
	{1150852864U, 24},
	{1149730816U, 21},
	{1145520128U, 19},
	{1142362112U, 22},
	{1151377408U, 19},
	{1151114240U, 24},
	{1150851072U, 24},
	{1148745728U, 21},
	{1148219392U, 21},
	{1147166720U, 20},
	{1145061376U, 20},
	{1142956032U, 20},
	{1141903360U, 24},
	{1141903360U, 22},
	{1140850688U, 20},
	{1140850688U, 12},
	{1154600960U, 22},
	{1150916608U, 22},
	{1150851328U, 24},
	{1148548096U, 22},
	{1148284928U, 21},
	{1145653248U, 22},
	{1145258496U, 24},
	{1145126912U, 19},
	{1141968896U, 24},
	{1141968896U, 21},
	{1140916224U, 17},
	{1151508480U, 19},
	{1151114752U, 24},
	{1151114752U, 23},
	{1150982144U, 21},
	{1150851584U, 24},
	{1145192448U, 18},
	{1142693376U, 24},
	{1142363392U, 24},
	{1142034432U, 20},
	{1141903872U, 24},
	{1141903872U, 23},
	{1140981760U, 15},
	{1154732032U, 20},
	{1153153024U, 21},
	{1151115008U, 24},
	{1148416000U, 21},
	{1148152832U, 22},
	{1147363328U, 20},
	{1145257984U, 23},
	{1142363136U, 22},
	{1142099968U, 21},
	{1152163840U, 20},
	{1151111168U, 23},
	{1150058496U, 19},
	{1145847808U, 19},
	{1142689792U, 24},
	{1141906432U, 24},
	{1141906432U, 23},
	{1141637120U, 16},
	{1154604032U, 22},
	{1151176704U, 20},
	{1151111424U, 24},
	{1150850304U, 24},
	{1150124032U, 20},
	{1148549120U, 22},
	{1148018688U, 20},
	{1145913344U, 20},
	{1142690048U, 24},
	{1141971968U, 22},
	{1141906688U, 24},
	{1141702656U, 17},
	{1151242240U, 21},
	{1151111680U, 23},
	{1150850560U, 23},
	{1148614656U, 22},
	{1148484096U, 23},
	{1145978880U, 20},
	{1145261312U, 24},
	{1141906944U, 23},
	{1141768192U, 19},
	{1151307776U, 21},
	{1151111936U, 24},
	{1149732864U, 21},
	{1148149760U, 21},
	{1142364160U, 22},
	{1141972480U, 23},
	{1141907200U, 24},
	{1141833728U, 19},
	{1152954368U, 20},
	{1152033280U, 24},
	{1151901696U, 20},
	{1151112192U, 23},
	{1149796352U, 19},
	{1148221440U, 21},
	{1145585664U, 20},
	{1141905408U, 23},
	{1141374976U, 16},
	{1154603008U, 22},
	{1150914560U, 21},
	{1149861888U, 20},
	{1148550144U, 22},
	{1148286976U, 21},
	{1145651200U, 21},
	{1145260544U, 23},
	{1141970944U, 22},
	{1141440512U, 16},
	{1153085440U, 20},
	{1152032768U, 19},
	{1151112704U, 24},
	{1151112704U, 23},
	{1150980096U, 21},
	{1148615680U, 22},
	{1147822080U, 19},
	{1145716736U, 20},
	{1145260288U, 24},
	{1142691328U, 24},
	{1141905920U, 24},
	{1141905920U, 23},
	{1141506048U, 16},
	{1152098304U, 19},
	{1151045632U, 20},
	{1148418048U, 21},
	{1145782272U, 20},
	{1144729600U, 20},
	{1142365184U, 22},
	{1142102016U, 21},
	{1141906176U, 24},
	{1141571584U, 17},
	{1148477440U, 20},
	{1148216320U, 22},
	{1146372096U, 20},
	{1145327616U, 20},
	{1142161408U, 18},
	{1142161408U, 16},
	{1141900288U, 24},
	{1154859008U, 21},
	{1154597888U, 22},
	{1148542976U, 21},
	{1148281856U, 22},
	{1146437632U, 20},
	{1142226944U, 19},
	{1142226944U, 16},
	{1141965824U, 24},
	{1141900544U, 24},
	{1151240192U, 21},
	{1148608512U, 20},
	{1146503168U, 19},
	{1144397824U, 19},
	{1143353344U, 20},
	{1142292480U, 19},
	{1142292480U, 16},
	{1141900800U, 24},
	{1141900800U, 23},
	{1149734912U, 20},
	{1148674048U, 19},
	{1148155904U, 21},
	{1142358016U, 20},
	{1142358016U, 16},
	{1141901056U, 24},
	{1148215296U, 22},
	{1148215296U, 21},
	{1147170816U, 20},
	{1145065472U, 20},
	{1142960128U, 20},
	{1141899264U, 21},
	{1141899264U, 16},
	{1141899264U, 14},
	{1140854784U, 20},
	{1154596864U, 23},
	{1150912512U, 21},
	{1148280832U, 22},
	{1146701824U, 24},
	{1141964800U, 23},
	{1141964800U, 21},
	{1141964800U, 16},
	{1154662400U, 20},
	{1150978048U, 21},
	{1148346368U, 19},
	{1145722880U, 21},
	{1142030336U, 20},
	{1142030336U, 16},
	{1141899776U, 24},
	{1154727936U, 20},
	{1154597376U, 23},
	{1148411904U, 20},
	{1147367424U, 21},
	{1146306560U, 18},
	{1145262080U, 20},
	{1142689536U, 24},
	{1142095872U, 20},
	{1141900032U, 24},
	{1140920832U, 23},
	{1152167936U, 20},
	{1144791040U, 19},
	{1142685696U, 16},
	{1154599936U, 22},
	{1151172608U, 20},
	{1150128128U, 20},
	{1148545024U, 22},
	{1148022784U, 20},
	{1145917440U, 20},
	{1141967872U, 24},
	{1141967872U, 22},
	{1151238144U, 21},
	{1150977024U, 22},
	{1150846464U, 23},
	{1145982976U, 20},
	{1145721856U, 22},
	{1151303680U, 20},
	{1148153856U, 21},
	{1147370496U, 22},
	{1141968384U, 23},
	{1152950272U, 20},
	{1151905792U, 20},
	{1150844928U, 23},
	{1150844928U, 19},
	{1148739584U, 19},
	{1148217344U, 21},
	{1147370240U, 24},
	{1145589760U, 20},
	{1142423552U, 19},
	{1142423552U, 14},
	{1141901312U, 21},
	{1153015808U, 19},
	{1150910464U, 21},
	{1149865984U, 21},
	{1148546048U, 22},
	{1148282880U, 21},
	{1147369984U, 24},
	{1145655296U, 20},
	{1144594432U, 19},
	{1142489088U, 18},
	{1142489088U, 17},
	{1141966848U, 22},
	{1153081344U, 20},
	{1150976000U, 22},
	{1145720832U, 22},
	{1142554624U, 18},
	{1142554624U, 17},
	{1154599424U, 23},
	{1153146880U, 20},
	{1151041536U, 20},
	{1147369472U, 23},
	{1145786368U, 20},
	{1144725504U, 20},
	{1142620160U, 17},
	{1142620160U, 16},
	{1154805760U, 20},
	{1150860288U, 24},
	{1148473344U, 23},
	{1148473344U, 20},
	{1146384384U, 20},
	{1145331712U, 19},
	{1143209984U, 16},
	{1141912576U, 23},
	{1154871296U, 20},
	{1150860544U, 24},
	{1148538880U, 21},
	{1148212480U, 24},
	{1147486208U, 19},
	{1146449920U, 20},
	{1145662464U, 22},
	{1145397248U, 19},
	{1143275520U, 20},
	{1142239232U, 20},
	{1141978112U, 24},
	{1141978112U, 23},
	{1141912832U, 24},
	{1151252480U, 21},
	{1150991360U, 22},
	{1150860800U, 23},
	{1149673472U, 19},
	{1148604416U, 20},
	{1148473856U, 23},
	{1148212736U, 24},
	{1145728000U, 22},
	{1145462784U, 20},
	{1143341056U, 19},
	{1142700544U, 23},
	{1141913088U, 23},
	{1151318016U, 21},
	{1149739008U, 20},
	{1148212992U, 24},
	{1145528320U, 20},
	{1145397760U, 23},
	{1143406592U, 18},
	{1141978624U, 24},
	{1141978624U, 23},
	{1141913344U, 24},
	{1155579904U, 20},
	{1151369216U, 19},
	{1150859264U, 24},
	{1148474368U, 23},
	{1148211200U, 22},
	{1147158528U, 19},
	{1145069568U, 20},
	{1142947840U, 19},
	{1141977344U, 24},
	{1141911552U, 22},
	{1140858880U, 20},
	{1150924800U, 21},
	{1150859520U, 24},
	{1146648832U, 24},
	{1145661440U, 22},
	{1145398272U, 24},
	{1145135104U, 19},
	{1143013376U, 16},
	{1141977088U, 24},
	{1141977088U, 23},
	{1151500288U, 19},
	{1150990336U, 22},
	{1150859776U, 24},
	{1148474880U, 23},
	{1148342272U, 20},
	{1147815936U, 21},
	{1145726976U, 22},
	{1143078912U, 17},
	{1142042624U, 20},
	{1154740224U, 21},
	{1150860032U, 24},
	{1148407808U, 20},
	{1147355136U, 21},
	{1145266176U, 19},
	{1143144448U, 17},
	{1141977600U, 24},
	{1141977600U, 23},
	{1141912320U, 24},
	{1152155648U, 19},
	{1151119360U, 24},
	{1151119360U, 23},
	{1150066688U, 19},
	{1148475392U, 23},
	{1145856000U, 19},
	{1143734272U, 15},
	{1141914624U, 23},
	{1151184896U, 21},
	{1151119616U, 24},
	{1150132224U, 20},
	{1148540928U, 21},
	{1148010496U, 19},
	{1145921536U, 23},
	{1141980160U, 23},
	{1141980160U, 22},
	{1141914880U, 24},
	{1151250432U, 21},
	{1151119872U, 23},
	{1150989312U, 22},
	{1148475904U, 23},
	{1148076032U, 18},
	{1145987072U, 19},
	{1145725952U, 22},
	{1143865344U, 17},
	{1142698496U, 23},
	{1141915136U, 23},
	{1141776384U, 19},
	{1151315968U, 21},
	{1148141568U, 19},
	{1143930880U, 18},
	{1141980672U, 24},
	{1141841920U, 19},
	{1151893504U, 20},
	{1151120384U, 22},
	{1149804544U, 19},
	{1148735488U, 20},
	{1148476416U, 23},
	{1148213248U, 21},
	{1145593856U, 20},
	{1143472128U, 18},
	{1141913600U, 22},
	{1153011712U, 20},
	{1151959040U, 18},
	{1150922752U, 21},
	{1147748352U, 18},
	{1145659392U, 21},
	{1143537664U, 18},
	{1141979136U, 23},
	{1141979136U, 22},
	{1154676736U, 21},
	{1152024576U, 19},
	{1150988288U, 22},
	{1148866560U, 20},
	{1148476928U, 23},
	{1147813888U, 21},
	{1145724928U, 22},
	{1143603200U, 18},
	{1141979904U, 24},
	{1154742272U, 21},
	{1153142784U, 20},
	{1152090112U, 19},
	{1151121152U, 24},
	{1151053824U, 20},
	{1147357184U, 21},
	{1145790464U, 20},
	{1143668736U, 18},
	{1154801664U, 20},
	{1151117312U, 24},
	{1151117312U, 23},
	{1148469248U, 20},
	{1146380288U, 20},
	{1144258560U, 17},
	{1142434816U, 22},
	{1141974272U, 24},
	{1141908480U, 23},
	{1154867200U, 20},
	{1154606080U, 22},
	{1151182848U, 21},
	{1151117568U, 24},
	{1148534784U, 20},
	{1146445824U, 20},
	{1144324096U, 18},
	{1143279616U, 20},
	{1142235136U, 20},
	{1141974016U, 22},
	{1141908736U, 24},
	{1151117824U, 24},
	{1151117824U, 23},
	{1148600320U, 20},
	{1146511360U, 19},
	{1145466880U, 21},
	{1144389632U, 19},
	{1142300672U, 19},
	{1141908992U, 24},
	{1141908992U, 23},
	{1151313920U, 21},
	{1151118080U, 24},
	{1149743104U, 20},
	{1148665856U, 19},
	{1145532416U, 20},
	{1144455168U, 16},
	{1142366208U, 19},
	{1141974528U, 23},
	{1141909248U, 24},
	{1155584000U, 21},
	{1151118336U, 24},
	{1151118336U, 23},
	{1148207104U, 20},
	{1145073664U, 20},
	{1143996416U, 17},
	{1143996416U, 16},
	{1142433792U, 22},
	{1142433792U, 21},
	{1141907456U, 23},
	{1140862976U, 20},
	{1154605056U, 22},
	{1150920704U, 21},
	{1148272640U, 19},
	{1144061952U, 16},
	{1141972992U, 24},
	{1141972992U, 22},
	{1151118848U, 23},
	{1148338176U, 21},
	{1147820032U, 21},
	{1144127488U, 16},
	{1142038528U, 20},
	{1141973760U, 24},
	{1141907968U, 24},
	{1141907968U, 23},
	{1154736128U, 20},
	{1153140736U, 22},
	{1151051776U, 21},
	{1148403712U, 20},
	{1147359232U, 20},
	{1144193024U, 18},
	{1142104064U, 20},
	{1141973504U, 23},
	{1141908224U, 24},
	{1151115264U, 23},
	{1151115264U, 22},
	{1145337856U, 22},
	{1144782848U, 19},
	{1141976320U, 24},
	{1151180800U, 22},
	{1150136320U, 20},
	{1145925632U, 20},
	{1144848384U, 16},
	{1141976064U, 23},
	{1151246336U, 20},
	{1145468928U, 21},
	{1144913920U, 18},
	{1142302720U, 24},
	{1141976832U, 24},
	{1151311872U, 21},
	{1144979456U, 18},
	{1141976576U, 24},
	{1155586048U, 21},
	{1152942080U, 19},
	{1151897600U, 20},
	{1151116288U, 23},
	{1150853120U, 19},
	{1148731392U, 20},
	{1148603904U, 23},
	{1148472320U, 23},
	{1145597952U, 20},
	{1145338880U, 23},
	{1144520704U, 16},
	{1141909504U, 21},
	{1154607104U, 22},
	{1153007616U, 20},
	{1151181824U, 22},
	{1151116544U, 24},
	{1150918656U, 21},
	{1149874176U, 21},
	{1145663488U, 20},
	{1144586240U, 19},
	{1141975040U, 24},
	{1141975040U, 22},
	{1150984192U, 20},
	{1150853632U, 24},
	{1148472832U, 23},
	{1147817984U, 21},
	{1145729024U, 20},
	{1144651776U, 17},
	{1151049728U, 21},
	{1145794560U, 20},
	{1145076480U, 24},
	{1144717312U, 19},
	{1141975552U, 24},
	{1152019968U, 23},
	{1151096832U, 23},
	{1150835712U, 23},
	{1148497920U, 21},
	{1146392576U, 20},
	{1145736704U, 24},
	{1145339904U, 20},
	{1154813952U, 20},
	{1154487552U, 24},
	{1153006592U, 22},
	{1151097088U, 24},
	{1148563456U, 20},
	{1145537024U, 24},
	{1145405440U, 20},
	{1142280192U, 20},
	{1151097344U, 23},
	{1150836224U, 23},
	{1149648896U, 19},
	{1148628992U, 20},
	{1148102656U, 21},
	{1146523648U, 20},
	{1145736192U, 23},
	{1145736192U, 22},
	{1145470976U, 19},
	{1144451072U, 20},
	{1143398400U, 19},
	{1154488064U, 24},
	{1152019712U, 24},
	{1151293440U, 21},
	{1149714432U, 20},
	{1148694528U, 20},
	{1148433408U, 22},
	{1146589184U, 20},
	{1145536512U, 24},
	{1145536512U, 20},
	{1142411264U, 20},
	{1154486272U, 24},
	{1154486272U, 20},
	{1153433600U, 14},
	{1153433600U, 13},
	{1151361024U, 19},
	{1151229440U, 23},
	{1151097856U, 23},
	{1150834688U, 23},
	{1148235776U, 20},
	{1147183104U, 19},
	{1145077760U, 20},
	{1143005184U, 20},
	{1141952512U, 22},
	{1140899840U, 18},
	{1154486528U, 24},
	{1153005568U, 22},
	{1148301312U, 20},
	{1145669632U, 21},
	{1145538048U, 24},
	{1145143296U, 19},
	{1142018048U, 20},
	{1140965376U, 18},
	{1154617344U, 21},
	{1154486784U, 24},
	{1151492096U, 19},
	{1151098368U, 23},
	{1150965760U, 21},
	{1150835200U, 23},
	{1148366848U, 21},
	{1145735168U, 22},
	{1145208832U, 20},
	{1143136256U, 20},
	{1142083584U, 20},
	{1154682880U, 20},
	{1154487040U, 24},
	{1151557632U, 20},
	{1151361792U, 24},
	{1148432384U, 22},
	{1148432384U, 21},
	{1147379712U, 21},
	{1146327040U, 20},
	{1145274368U, 19},
	{1143201792U, 20},
	{1142149120U, 21},
	{1154489344U, 24},
	{1151094784U, 24},
	{1151094784U, 23},
	{1150833664U, 22},
	{1150042112U, 19},
	{1148499968U, 22},
	{1145864192U, 20},
	{1144844288U, 20},
	{1141955584U, 22},
	{1154489600U, 24},
	{1151160320U, 20},
	{1151095040U, 24},
	{1150107648U, 19},
	{1145929728U, 19},
	{1141751808U, 19},
	{1154489856U, 24},
	{1151095296U, 24},
	{1151095296U, 23},
	{1148369920U, 22},
	{1148100608U, 21},
	{1145995264U, 19},
	{1145734144U, 22},
	{1144975360U, 20},
	{1143922688U, 20},
	{1141817344U, 20},
	{1151291392U, 21},
	{1147382784U, 22},
	{1145040896U, 20},
	{1141882880U, 20},
	{1154488320U, 23},
	{1153957888U, 17},
	{1152937984U, 20},
	{1151885312U, 19},
	{1151095808U, 23},
	{1151095808U, 22},
	{1150832640U, 24},
	{1149779968U, 18},
	{1148500992U, 22},
	{1145602048U, 20},
	{1141954560U, 22},
	{1154023424U, 19},
	{1153003520U, 21},
	{1150898176U, 20},
	{1150832896U, 24},
	{1149845504U, 20},
	{1147772928U, 20},
	{1145667584U, 21},
	{1145540096U, 23},
	{1142542336U, 20},
	{1154619392U, 21},
	{1154488832U, 24},
	{1152016384U, 19},
	{1151096320U, 24},
	{1150833152U, 23},
	{1149911040U, 20},
	{1148368896U, 22},
	{1148368896U, 21},
	{1147838464U, 20},
	{1145733120U, 22},
	{1154489088U, 24},
	{1152081920U, 19},
	{1151096576U, 24},
	{1151029248U, 20},
	{1148434432U, 21},
	{1147904000U, 20},
	{1147381760U, 22},
	{1145798656U, 20},
	{1142151168U, 21},
	{1154744320U, 20},
	{1154744320U, 15},
	{1152024064U, 24},
	{1151092736U, 21},
	{1150831616U, 23},
	{1148493824U, 20},
	{1147846144U, 24},
	{1146388480U, 20},
	{1145609216U, 22},
	{1145541376U, 24},
	{1145344000U, 20},
	{1142210560U, 19},
	{1154809856U, 20},
	{1154483456U, 24},
	{1151158272U, 21},
	{1148559360U, 20},
	{1147846400U, 24},
	{1146454016U, 19},
	{1145541120U, 24},
	{1145409536U, 20},
	{1142276096U, 22},
	{1152023552U, 23},
	{1150832128U, 24},
	{1148624896U, 22},
	{1148106752U, 21},
	{1147845632U, 23},
	{1146519552U, 20},
	{1145344512U, 24},
	{1144446976U, 20},
	{1142341632U, 19},
	{1152089088U, 24},
	{1151562752U, 22},
	{1150832384U, 24},
	{1149718528U, 20},
	{1148690432U, 21},
	{1147911168U, 22},
	{1146585088U, 20},
	{1145540608U, 23},
	{1142407168U, 22},
	{1154482176U, 20},
	{1154482176U, 14},
	{1151562496U, 24},
	{1150830592U, 24},
	{1150830592U, 23},
	{1148231680U, 20},
	{1145608192U, 22},
	{1145410816U, 24},
	{1145081856U, 20},
	{1143009280U, 20},
	{1141948416U, 21},
	{1153001472U, 21},
	{1152088576U, 24},
	{1151562240U, 24},
	{1150896128U, 21},
	{1148297216U, 21},
	{1145542144U, 23},
	{1145345280U, 24},
	{1142277120U, 22},
	{1142013952U, 20},
	{1154613248U, 20},
	{1152022528U, 22},
	{1150831104U, 23},
	{1148362752U, 21},
	{1147844608U, 22},
	{1146257408U, 17},
	{1145541888U, 24},
	{1145411328U, 24},
	{1145212928U, 20},
	{1144184832U, 19},
	{1143140352U, 20},
	{1142079488U, 20},
	{1154678784U, 20},
	{1151561728U, 24},
	{1148428288U, 20},
	{1147910144U, 22},
	{1147383808U, 20},
	{1146322944U, 20},
	{1145541632U, 24},
	{1144250368U, 19},
	{1143205888U, 20},
	{1142408192U, 22},
	{1142145024U, 20},
	{1151090688U, 22},
	{1150829568U, 24},
	{1150829568U, 23},
	{1145868288U, 20},
	{1145607168U, 22},
	{1144840192U, 20},
	{1141951488U, 22},
	{1153000448U, 22},
	{1151156224U, 21},
	{1142278144U, 22},
	{1151221760U, 20},
	{1150830080U, 24},
	{1150830080U, 23},
	{1148626944U, 21},
	{1148104704U, 21},
	{1146652160U, 23},
	{1144971264U, 20},
	{1143926784U, 20},
	{1141821440U, 20},
	{1151287296U, 20},
	{1148692480U, 21},
	{1145542656U, 24},
	{1145036800U, 20},
	{1142409216U, 21},
	{1141886976U, 20},
	{1154484224U, 24},
	{1152933888U, 20},
	{1151091712U, 22},
	{1150828544U, 24},
	{1150828544U, 23},
	{1148755968U, 19},
	{1145606144U, 22},
	{1145544448U, 24},
	{1142472704U, 18},
	{1141950464U, 22},
	{1151564288U, 23},
	{1150894080U, 21},
	{1148299264U, 21},
	{1147777024U, 20},
	{1145671680U, 20},
	{1142538240U, 20},
	{1142538240U, 19},
	{1142279168U, 22},
	{1154484736U, 24},
	{1152020480U, 21},
	{1150959616U, 20},
	{1150829056U, 24},
	{1150829056U, 23},
	{1149915136U, 20},
	{1148364800U, 21},
	{1147842560U, 21},
	{1145737216U, 20},
	{1142603776U, 18},
	{1153130496U, 19},
	{1151563776U, 24},
	{1151025152U, 20},
	{1147908096U, 21},
	{1145802752U, 20},
	{1145543680U, 24},
	{1145413120U, 24},
	{1142279680U, 24},
	{1154495488U, 22},
	{1151105024U, 23},
	{1145479680U, 24},
	{1145348096U, 20},
	{1145218560U, 24},
	{1142288640U, 24},
	{1148555264U, 20},
	{1148294144U, 23},
	{1147502592U, 17},
	{1145479936U, 24},
	{1145413632U, 21},
	{1145152512U, 23},
	{1151236096U, 22},
	{1151105536U, 23},
	{1149657088U, 19},
	{1148620800U, 21},
	{1148094464U, 21},
	{1146531840U, 20},
	{1145744384U, 22},
	{1145479168U, 20},
	{1144442880U, 20},
	{1143390208U, 20},
	{1142749696U, 23},
	{1142353920U, 22},
	{1151301632U, 21},
	{1149722624U, 21},
	{1148294656U, 23},
	{1145544704U, 21},
	{1155530752U, 17},
	{1155530752U, 16},
	{1154494464U, 22},
	{1151352832U, 19},
	{1151106048U, 24},
	{1151106048U, 23},
	{1148227584U, 21},
	{1147174912U, 20},
	{1145546496U, 24},
	{1145085952U, 20},
	{1142996992U, 20},
	{1141960704U, 21},
	{1155596288U, 21},
	{1150908416U, 21},
	{1148293120U, 23},
	{1148293120U, 21},
	{1145151488U, 20},
	{1142552576U, 21},
	{1142026240U, 20},
	{1154494976U, 24},
	{1151483904U, 19},
	{1151237120U, 22},
	{1151106560U, 23},
	{1147305984U, 18},
	{1145743360U, 22},
	{1145217024U, 20},
	{1143128064U, 19},
	{1142354944U, 22},
	{1142091776U, 21},
	{1154691072U, 21},
	{1151549440U, 19},
	{1151106816U, 24},
	{1151039488U, 21},
	{1148293632U, 23},
	{1147371520U, 20},
	{1146335232U, 20},
	{1145480448U, 24},
	{1145282560U, 19},
	{1143193600U, 20},
	{1142157312U, 21},
	{1154497536U, 24},
	{1154497536U, 22},
	{1152139264U, 18},
	{1151878144U, 22},
	{1151355904U, 24},
	{1151102976U, 21},
	{1150050304U, 19},
	{1147961344U, 18},
	{1145872384U, 23},
	{1145481728U, 24},
	{1144836096U, 20},
	{1151168512U, 20},
	{1150115840U, 19},
	{1148026880U, 18},
	{1145937920U, 20},
	{1141760000U, 19},
	{1151234048U, 21},
	{1148622848U, 22},
	{1148092416U, 22},
	{1146003456U, 20},
	{1145742336U, 22},
	{1143914496U, 20},
	{1142747648U, 23},
	{1142355968U, 22},
	{1142094848U, 22},
	{1141825536U, 19},
	{1154694144U, 22},
	{1151299584U, 21},
	{1151038464U, 22},
	{1149724672U, 21},
	{1148157952U, 17},
	{1145546752U, 21},
	{1145032704U, 20},
	{1143980032U, 18},
	{1141891072U, 20},
	{1156055040U, 16},
	{1154496512U, 24},
	{1152929792U, 20},
	{1152074496U, 24},
	{1151877120U, 22},
	{1151877120U, 20},
	{1150840832U, 20},
	{1148229632U, 21},
	{1148093952U, 23},
	{1147699200U, 17},
	{1145610240U, 19},
	{1143521280U, 18},
	{1141962752U, 21},
	{1154031616U, 20},
	{1151942656U, 18},
	{1150906368U, 21},
	{1149853696U, 20},
	{1148295168U, 21},
	{1147764736U, 20},
	{1145675776U, 19},
	{1143586816U, 18},
	{1142550528U, 21},
	{1142550528U, 20},
	{1152008192U, 19},
	{1150971904U, 20},
	{1148623872U, 22},
	{1147830272U, 20},
	{1145741312U, 22},
	{1143652352U, 18},
	{1142356992U, 22},
	{1142093824U, 22},
	{1154693120U, 22},
	{1154497280U, 24},
	{1153126400U, 20},
	{1152073728U, 20},
	{1151355648U, 24},
	{1151037440U, 22},
	{1147895808U, 20},
	{1145806848U, 19},
	{1143717888U, 18},
	{1142159360U, 21},
	{1154752512U, 21},
	{1154491392U, 23},
	{1154491392U, 22},
	{1151100928U, 23},
	{1148485632U, 19},
	{1146396672U, 19},
	{1145352192U, 21},
	{1144307712U, 18},
	{1142218752U, 19},
	{1141957632U, 22},
	{1152994304U, 23},
	{1148551168U, 20},
	{1146462208U, 19},
	{1145417728U, 20},
	{1144373248U, 18},
	{1142284288U, 19},
	{1154491904U, 24},
	{1152995072U, 24},
	{1151101440U, 23},
	{1148616704U, 21},
	{1146527744U, 20},
	{1145483264U, 20},
	{1144438784U, 20},
	{1143394304U, 20},
	{1142349824U, 22},
	{1149726720U, 20},
	{1148682240U, 19},
	{1146593280U, 20},
	{1145548800U, 20},
	{1142415360U, 19},
	{1154490368U, 24},
	{1154490368U, 22},
	{1151101952U, 22},
	{1148223488U, 21},
	{1147179008U, 20},
	{1145090048U, 20},
	{1143001088U, 20},
	{1141956608U, 22},
	{1152993280U, 23},
	{1150904320U, 21},
	{1148289024U, 20},
	{1145681920U, 21},
	{1145155584U, 21},
	{1142548480U, 21},
	{1142022144U, 20},
	{1154621440U, 21},
	{1154490880U, 24},
	{1152014336U, 24},
	{1150969856U, 21},
	{1148354560U, 19},
	{1147836416U, 21},
	{1145221120U, 20},
	{1142350848U, 22},
	{1142087680U, 20},
	{1154686976U, 20},
	{1154491136U, 24},
	{1152993792U, 23},
	{1151035392U, 21},
	{1148420096U, 19},
	{1147375616U, 21},
	{1146331136U, 20},
	{1144242176U, 19},
	{1143197696U, 20},
	{1142153216U, 20},
	{1154493440U, 23},
	{1154493440U, 22},
	{1151098880U, 21},
	{1145876480U, 20},
	{1145354240U, 22},
	{1144832000U, 20},
	{1152992256U, 23},
	{1151164416U, 20},
	{1145942016U, 20},
	{1142417920U, 24},
	{1154493952U, 24},
	{1151229952U, 20},
	{1148618752U, 21},
	{1148096512U, 20},
	{1147835392U, 22},
	{1146007552U, 20},
	{1144963072U, 19},
	{1143918592U, 20},
	{1142351872U, 22},
	{1152992768U, 23},
	{1151295488U, 20},
	{1145028608U, 20},
	{1141895168U, 20},
	{1154492416U, 22},
	{1152925696U, 20},
	{1151881216U, 20},
	{1150836736U, 20},
	{1148747776U, 19},
	{1148225536U, 21},
	{1145355264U, 23},
	{1141958656U, 21},
	{1154492672U, 24},
	{1152991232U, 23},
	{1152991232U, 19},
	{1150902272U, 21},
	{1149857792U, 20},
	{1147768832U, 20},
	{1145157632U, 21},
	{1144635392U, 18},
	{1142546432U, 21},
	{1142546432U, 20},
	{1154623488U, 21},
	{1153056768U, 19},
	{1150967808U, 21},
	{1147834368U, 22},
	{1145745408U, 20},
	{1145355776U, 24},
	{1144700928U, 18},
	{1142352896U, 22},
	{1153122304U, 21},
	{1152991744U, 23},
	{1152077824U, 20},
	{1151033344U, 21},
	{1147899904U, 20},
	{1147377664U, 21},
	{1144766464U, 18},
	{1154764800U, 20},
	{1154503680U, 22},
	{1151872000U, 23},
	{1151080448U, 21},
	{1150885120U, 24},
	{1150819328U, 23},
	{1149898240U, 24},
	{1149501440U, 15},
	{1148514304U, 21},
	{1146674176U, 24},
	{1146408960U, 20},
	{1145621504U, 22},
	{1145356288U, 19},
	{1144303616U, 20},
	{1142198272U, 21},
	{1154830336U, 21},
	{1150884864U, 24},
	{1150884864U, 23},
	{1148053504U, 21},
	{1146674432U, 24},
	{1146474496U, 20},
	{1145421824U, 20},
	{1144369152U, 20},
	{1142263808U, 22},
	{1151211520U, 21},
	{1150819840U, 24},
	{1150819840U, 23},
	{1149897728U, 24},
	{1149632512U, 19},
	{1146540032U, 20},
	{1145487360U, 20},
	{1144434688U, 20},
	{1142725120U, 23},
	{1142329344U, 22},
	{1151872768U, 24},
	{1151277056U, 21},
	{1150885376U, 23},
	{1150820096U, 24},
	{1149897984U, 24},
	{1149698048U, 20},
	{1148710912U, 20},
	{1145552896U, 20},
	{1142394880U, 22},
	{1154502656U, 22},
	{1151344640U, 19},
	{1150818304U, 24},
	{1150818304U, 22},
	{1149897216U, 24},
	{1149239296U, 14},
	{1149239296U, 13},
	{1147199488U, 19},
	{1145620480U, 22},
	{1145094144U, 20},
	{1142988800U, 20},
	{1141936128U, 21},
	{1140883456U, 18},
	{1154502912U, 24},
	{1151871232U, 24},
	{1149897472U, 24},
	{1148317696U, 20},
	{1147791360U, 21},
	{1145159680U, 18},
	{1142264832U, 22},
	{1142001664U, 20},
	{1140948992U, 19},
	{1154633728U, 21},
	{1154503168U, 23},
	{1150949376U, 21},
	{1150818816U, 24},
	{1149896704U, 24},
	{1149896704U, 21},
	{1147330560U, 20},
	{1145225216U, 20},
	{1145225216U, 18},
	{1143119872U, 19},
	{1142330368U, 22},
	{1142067200U, 20},
	{1151014912U, 21},
	{1150884352U, 23},
	{1150819072U, 24},
	{1149896960U, 24},
	{1147922432U, 21},
	{1146343424U, 20},
	{1145290752U, 18},
	{1142395904U, 22},
	{1142132736U, 20},
	{1154505728U, 22},
	{1152131072U, 19},
	{1151869952U, 22},
	{1151078400U, 24},
	{1151078400U, 22},
	{1150883072U, 24},
	{1150025728U, 19},
	{1150025728U, 15},
	{1148516352U, 21},
	{1147985920U, 20},
	{1145880576U, 20},
	{1145619456U, 22},
	{1142200320U, 22},
	{1154832384U, 21},
	{1151143936U, 21},
	{1150882816U, 24},
	{1150817536U, 24},
	{1150091264U, 19},
	{1148051456U, 21},
	{1141735424U, 18},
	{1151209472U, 21},
	{1150948352U, 22},
	{1148116992U, 19},
	{1142723072U, 23},
	{1142331392U, 22},
	{1141800960U, 19},
	{1151275008U, 21},
	{1151079168U, 24},
	{1145024512U, 20},
	{1143971840U, 19},
	{1142396928U, 22},
	{1141866496U, 19},
	{1154504704U, 24},
	{1154504704U, 22},
	{1152921600U, 20},
	{1151079424U, 24},
	{1151079424U, 22},
	{1150882048U, 24},
	{1150816256U, 22},
	{1150816256U, 21},
	{1149763584U, 18},
	{1149763584U, 14},
	{1145618432U, 22},
	{1145096192U, 21},
	{1142201344U, 22},
	{1141938176U, 21},
	{1151934464U, 19},
	{1151079680U, 24},
	{1150881792U, 22},
	{1149829120U, 19},
	{1147789312U, 21},
	{1145683968U, 20},
	{1142266880U, 22},
	{1152000000U, 19},
	{1151079936U, 24},
	{1150947328U, 22},
	{1147854848U, 19},
	{1145749504U, 20},
	{1142332416U, 22},
	{1153118208U, 20},
	{1151012864U, 21},
	{1147920384U, 21},
	{1145815040U, 20},
	{1144762368U, 20},
	{1142397952U, 22},
	{1142332672U, 24},
	{1141604352U, 17},
	{1154760704U, 20},
	{1154499584U, 23},
	{1151876096U, 24},
	{1151076352U, 22},
	{1150815232U, 23},
	{1148510208U, 20},
	{1146404864U, 20},
	{1144299520U, 20},
	{1142194176U, 20},
	{1154826240U, 21},
	{1151141888U, 21},
	{1148057600U, 21},
	{1147796480U, 22},
	{1146470400U, 20},
	{1145425920U, 20},
	{1144365056U, 20},
	{1142524928U, 22},
	{1142259712U, 22},
	{1151876608U, 24},
	{1150815744U, 24},
	{1150815744U, 23},
	{1148641280U, 19},
	{1146535936U, 20},
	{1145756672U, 22},
	{1145491456U, 20},
	{1144430592U, 20},
	{1142325248U, 22},
	{1154696192U, 22},
	{1150881280U, 23},
	{1149702144U, 20},
	{1148706816U, 21},
	{1145556992U, 20},
	{1142390784U, 22},
	{1142325504U, 24},
	{1154498560U, 22},
	{1151077376U, 24},
	{1150814208U, 23},
	{1150287872U, 14},
	{1148248064U, 19},
	{1145098240U, 20},
	{1142992896U, 20},
	{1141932032U, 21},
	{1152270080U, 24},
	{1150879744U, 24},
	{1150814464U, 24},
	{1148313600U, 20},
	{1147795456U, 22},
	{1145690112U, 21},
	{1142523904U, 22},
	{1142523904U, 21},
	{1142260736U, 22},
	{1141997568U, 20},
	{1154629632U, 20},
	{1154499072U, 24},
	{1150814720U, 24},
	{1150814720U, 23},
	{1148379136U, 19},
	{1147334656U, 21},
	{1145229312U, 21},
	{1142326272U, 22},
	{1142063104U, 20},
	{1154695168U, 22},
	{1151875840U, 24},
	{1147926528U, 21},
	{1146339328U, 20},
	{1142391808U, 22},
	{1142128640U, 20},
	{1151874048U, 24},
	{1151074304U, 24},
	{1151074304U, 20},
	{1147990016U, 20},
	{1145884672U, 20},
	{1141935104U, 22},
	{1151139840U, 21},
	{1150878720U, 24},
	{1148055552U, 21},
	{1145689088U, 22},
	{1142261760U, 21},
	{1151205376U, 20},
	{1146015744U, 20},
	{1145232384U, 24},
	{1144954880U, 19},
	{1142327296U, 21},
	{1151270912U, 20},
	{1148708864U, 21},
	{1145020416U, 20},
	{1142392832U, 22},
	{1154500608U, 21},
	{1152917504U, 20},
	{1151075328U, 24},
	{1150812160U, 24},
	{1150812160U, 21},
	{1150812160U, 14},
	{1150812160U, 13},
	{1148772352U, 20},
	{1145622528U, 20},
	{1142456320U, 18},
	{1142456320U, 17},
	{1141934080U, 22},
	{1152983040U, 19},
	{1151873280U, 24},
	{1150877696U, 24},
	{1148056576U, 22},
	{1147793408U, 21},
	{1145688064U, 22},
	{1153048576U, 19},
	{1151873536U, 23},
	{1151075840U, 23},
	{1150943232U, 20},
	{1149898752U, 21},
	{1147336704U, 21},
	{1145753600U, 22},
	{1145231360U, 22},
	{1144692736U, 19},
	{1142587392U, 18},
	{1142587392U, 17},
	{1154697216U, 21},
	{1153114112U, 20},
	{1151008768U, 20},
	{1147924480U, 21},
	{1145819136U, 20},
	{1144758272U, 20},
	{1142652928U, 17},
	{1142393856U, 22},
	{1154772992U, 21},
	{1154511872U, 22},
	{1152916480U, 22},
	{1151995392U, 24},
	{1151929600U, 24},
	{1151598592U, 14},
	{1151088640U, 24},
	{1150827520U, 23},
	{1148506112U, 21},
	{1148310784U, 24},
	{1146417152U, 20},
	{1145364480U, 20},
	{1154838528U, 21},
	{1151995648U, 24},
	{1151088896U, 24},
	{1150893056U, 22},
	{1148571648U, 20},
	{1148310528U, 24},
	{1148045312U, 24},
	{1147784192U, 22},
	{1146482688U, 20},
	{1145430016U, 19},
	{1143308288U, 17},
	{1154512384U, 23},
	{1151994880U, 23},
	{1151219712U, 21},
	{1151089152U, 24},
	{1151089152U, 23},
	{1150828032U, 24},
	{1148637184U, 20},
	{1148376064U, 22},
	{1145495552U, 19},
	{1144426496U, 20},
	{1143373824U, 18},
	{1142733312U, 23},
	{1150828288U, 24},
	{1149706240U, 20},
	{1148702720U, 20},
	{1148045824U, 23},
	{1145561088U, 19},
	{1143439360U, 17},
	{1142403072U, 20},
	{1141876736U, 21},
	{1151928576U, 24},
	{1151336448U, 19},
	{1151089664U, 22},
	{1150826496U, 23},
	{1148309760U, 24},
	{1148243968U, 20},
	{1147191296U, 19},
	{1145102336U, 20},
	{1142980608U, 20},
	{1141944320U, 21},
	{1154576384U, 21},
	{1151401984U, 16},
	{1150892032U, 22},
	{1148309504U, 24},
	{1148309504U, 20},
	{1148046336U, 22},
	{1147783168U, 22},
	{1142009856U, 20},
	{1140957184U, 19},
	{1154641920U, 21},
	{1154511360U, 23},
	{1151993856U, 22},
	{1151467520U, 18},
	{1150957568U, 21},
	{1150827008U, 24},
	{1150827008U, 23},
	{1148375040U, 21},
	{1148310272U, 24},
	{1147322368U, 21},
	{1145233408U, 22},
	{1143111680U, 20},
	{1142075392U, 20},
	{1154707456U, 20},
	{1153112064U, 21},
	{1148310016U, 24},
	{1147914240U, 21},
	{1147387904U, 18},
	{1146351616U, 20},
	{1143177216U, 18},
	{1142140928U, 20},
	{1152122880U, 19},
	{1151086592U, 22},
	{1150825472U, 23},
	{1150033920U, 19},
	{1148508160U, 21},
	{1148312832U, 24},
	{1147977728U, 19},
	{1145888768U, 19},
	{1154840576U, 21},
	{1154579456U, 23},
	{1152188416U, 16},
	{1151152128U, 20},
	{1150891008U, 24},
	{1150891008U, 22},
	{1150099456U, 19},
	{1148312576U, 24},
	{1148043264U, 21},
	{1147782144U, 22},
	{1145954304U, 21},
	{1152253952U, 18},
	{1151217664U, 21},
	{1151087104U, 23},
	{1150825984U, 23},
	{1148313344U, 24},
	{1148108800U, 20},
	{1146019840U, 20},
	{1143898112U, 18},
	{1142731264U, 23},
	{1141809152U, 20},
	{1154579968U, 23},
	{1151927808U, 24},
	{1151283200U, 20},
	{1150826240U, 24},
	{1148313088U, 24},
	{1147913216U, 22},
	{1143963648U, 20},
	{1141874688U, 21},
	{1154512896U, 22},
	{1152913408U, 21},
	{1151860736U, 20},
	{1151860736U, 14},
	{1151087616U, 24},
	{1151087616U, 23},
	{1150824448U, 23},
	{1148311808U, 24},
	{1145626624U, 19},
	{1143504896U, 18},
	{1141946368U, 21},
	{1151926272U, 19},
	{1150889984U, 24},
	{1150889984U, 22},
	{1149837312U, 19},
	{1148311552U, 24},
	{1147781120U, 22},
	{1145692160U, 19},
	{1143570432U, 18},
	{1151991808U, 21},
	{1151088128U, 24},
	{1151088128U, 23},
	{1150955520U, 21},
	{1150890752U, 24},
	{1150824960U, 24},
	{1150824960U, 23},
	{1149902848U, 21},
	{1148377088U, 21},
	{1147846656U, 20},
	{1147324416U, 21},
	{1145757696U, 19},
	{1143635968U, 18},
	{1154578944U, 23},
	{1153110016U, 21},
	{1152057344U, 19},
	{1151021056U, 20},
	{1150825216U, 24},
	{1148312064U, 23},
	{1147912192U, 22},
	{1145823232U, 19},
	{1143701504U, 18},
	{1154768896U, 20},
	{1154507776U, 24},
	{1154507776U, 23},
	{1151084544U, 24},
	{1150823424U, 23},
	{1150823424U, 22},
	{1148502016U, 20},
	{1146413056U, 20},
	{1145368576U, 20},
	{1144291328U, 19},
	{1142202368U, 19},
	{1141941248U, 22},
	{1154834432U, 21},
	{1154508032U, 24},
	{1151150080U, 21},
	{1150888960U, 23},
	{1148567552U, 21},
	{1148049408U, 21},
	{1146478592U, 20},
	{1144356864U, 19},
	{1142267904U, 19},
	{1154508288U, 24},
	{1154508288U, 23},
	{1150954496U, 22},
	{1148633088U, 20},
	{1148114944U, 21},
	{1146544128U, 19},
	{1144422400U, 20},
	{1142333440U, 19},
	{1154704384U, 22},
	{1150889472U, 23},
	{1150824192U, 24},
	{1149710336U, 20},
	{1148698624U, 21},
	{1142398976U, 19},
	{1154506752U, 22},
	{1150822400U, 23},
	{1148239872U, 20},
	{1145106432U, 20},
	{1144029184U, 17},
	{1142984704U, 20},
	{1141940224U, 22},
	{1154572288U, 21},
	{1154507008U, 24},
	{1151932416U, 24},
	{1150887936U, 24},
	{1150887936U, 23},
	{1148305408U, 20},
	{1142005760U, 20},
	{1154637824U, 20},
	{1150953472U, 22},
	{1150888704U, 24},
	{1150822912U, 24},
	{1149908992U, 21},
	{1148370944U, 20},
	{1147852800U, 21},
	{1147326464U, 20},
	{1143115776U, 20},
	{1142071296U, 20},
	{1154703360U, 22},
	{1151086336U, 24},
	{1150888448U, 24},
	{1150888448U, 23},
	{1148436480U, 18},
	{1147918336U, 21},
	{1146347520U, 20},
	{1144225792U, 18},
	{1142334720U, 24},
	{1142136832U, 20},
	{1154509824U, 22},
	{1151931648U, 24},
	{1151082496U, 24},
	{1151082496U, 20},
	{1150887168U, 24},
	{1150821376U, 22},
	{1144815616U, 18},
	{1150886912U, 24},
	{1150886912U, 22},
	{1149581312U, 21},
	{1148569600U, 21},
	{1148047360U, 21},
	{1151213568U, 20},
	{1151083008U, 24},
	{1150821888U, 24},
	{1148112896U, 21},
	{1146676736U, 24},
	{1146023936U, 20},
	{1144946688U, 19},
	{1141813248U, 20},
	{1151279104U, 20},
	{1147917312U, 22},
	{1145012224U, 19},
	{1143967744U, 20},
	{1141878784U, 20},
	{1154508800U, 22},
	{1152909312U, 20},
	{1151864832U, 20},
	{1151083520U, 24},
	{1150820352U, 23},
	{1148764160U, 20},
	{1141942272U, 21},
	{1154574336U, 21},
	{1152974848U, 19},
	{1151083776U, 24},
	{1150885888U, 22},
	{1147785216U, 20},
	{1144619008U, 18},
	{1153040384U, 19},
	{1151995904U, 20},
	{1151931136U, 24},
	{1151084032U, 24},
	{1150951424U, 21},
	{1150820864U, 24},
	{1150820864U, 23},
	{1149906944U, 21},
	{1147850752U, 21},
	{1145761792U, 24},
	{1144684544U, 19},
	{1154705408U, 21},
	{1153105920U, 20},
	{1151084288U, 24},
	{1151016960U, 20},
	{1150886400U, 24},
	{1147916288U, 22},
	{1145696768U, 24},
	{1144750080U, 19},
	{3631672064U, 24},
	{3515424000U, 24},
	{3498646528U, 24},
	{3425876736U, 24},
	{3394558720U, 24},
	{3390086912U, 24},
	{3360016384U, 24},
	{3334093056U, 24},
	{3231194368U, 24},
	{3228033536U, 24},
	{2295136256U, 16},
	{3629631744U, 24},
	{3517464320U, 24},
	{3499822336U, 24},
	{3490940160U, 24},
	{3486402304U, 24},
	{3478642176U, 24},
	{3436069888U, 24},
	{3407060480U, 24},
	{3392257280U, 24},
	{3355278336U, 24},
	{3276194560U, 24},
	{3256919040U, 24},
	{3244614400U, 24},
	{2867596800U, 24},
	{2295201792U, 16},
	{3584637696U, 24},
	{3566864640U, 24},
	{3506203392U, 24},
	{3503249408U, 24},
	{3491870208U, 24},
	{3490874624U, 24},
	{3452912896U, 24},
	{3406994944U, 24},
	{3400082432U, 24},
	{3340869888U, 24},
	{3260470016U, 24},
	{3254548992U, 24},
	{3234809856U, 24},
	{3230338048U, 24},
	{2867663616U, 24},
	{2867663360U, 24},
	{2295267328U, 16},
	{3499953408U, 24},
	{3483177472U, 24},
	{3462589440U, 24},
	{3433964032U, 24},
	{3400410112U, 24},
	{3236588032U, 24},
	{2867462144U, 16},
	{2294808576U, 16},
	{3650880512U, 24},
	{3627462400U, 24},
	{3586009600U, 24},
	{3513967104U, 24},
	{3484360960U, 24},
	{3461406464U, 24},
	{3449556992U, 24},
	{3427851520U, 24},
	{3407126016U, 24},
	{3389361664U, 24},
	{3359031040U, 24},
	{3350145280U, 24},
	{3345212672U, 24},
	{3334355200U, 24},
	{3255141888U, 24},
	{3235404032U, 24},
	{3226521856U, 24},
	{2867527680U, 16},
	{2294874112U, 16},
	{3624311808U, 24},
	{3588783872U, 24},
	{3449753600U, 24},
	{3406204672U, 24},
	{3356990720U, 24},
	{3351924480U, 24},
	{3284814592U, 24},
	{3277050368U, 24},
	{2867331072U, 16},
	{3588849408U, 24},
	{3507913728U, 24},
	{3500018944U, 24},
	{3487192576U, 24},
	{3474364928U, 24},
	{3438835456U, 24},
	{3390480128U, 24},
	{3389492736U, 24},
	{3341132032U, 24},
	{3281919488U, 24},
	{3250339328U, 24},
	{3245404672U, 24},
	{3228627712U, 24},
	{3224680192U, 24},
	{3564041728U, 24},
	{3505875712U, 24},
	{3448836096U, 24},
	{3436532992U, 24},
	{3414165248U, 24},
	{3397387776U, 24},
	{3361593600U, 24},
	{3354885120U, 24},
	{3254221312U, 24},
	{3635554048U, 24},
	{3561870336U, 24},
	{3500359168U, 24},
	{3482325504U, 24},
	{3410873088U, 24},
	{3406401280U, 24},
	{3359293184U, 24},
	{3352583680U, 24},
	{3253168896U, 24},
	{3245335296U, 24},
	{3237378816U, 24},
	{3236391424U, 24},
	{3234154496U, 24},
	{3228557824U, 24},
	{3225073408U, 24},
	{3636875264U, 24},
	{3630156032U, 24},
	{3520546816U, 24},
	{3509106432U, 24},
	{3507131648U, 24},
	{3505744640U, 24},
	{3488969728U, 24},
	{3485878016U, 24},
	{3474692608U, 24},
	{3449824000U, 24},
	{3414296320U, 24},
	{3394161152U, 24},
	{3356134400U, 24},
	{3350280192U, 24},
	{3237313280U, 24},
	{3650225152U, 24},
	{3635422976U, 24},
	{3564955392U, 24},
	{3531399424U, 24},
	{3515030784U, 24},
	{3512647680U, 24},
	{3508175872U, 24},
	{3490419712U, 24},
	{3424295168U, 24},
	{3413964800U, 24},
	{3409492992U, 24},
	{3343894272U, 24},
	{3323630336U, 24},
	{3289088000U, 24},
	{3267840512U, 24},
	{3266329856U, 24},
	{3245204224U, 24},
	{3230801152U, 24},
	{3227439360U, 24},
	{3222967552U, 24},
	{2294743040U, 16},
	{3628652544U, 24},
	{3516206080U, 24},
	{3455284736U, 24},
	{3359620864U, 24},
	{3357383936U, 24},
	{3353505024U, 24},
	{3344553472U, 24},
	{3498384384U, 24},
	{3491529984U, 24},
	{3467059200U, 24},
	{3460943360U, 24},
	{3435217920U, 24},
	{3429625344U, 24},
	{3409886208U, 24},
	{3407650304U, 24},
	{3394820864U, 24},
	{3358567936U, 24},
	{3263499776U, 24},
	{3229944832U, 24},
	{3229283072U, 24},
	{3227046144U, 24},
	{3518311936U, 24},
	{3478904320U, 24},
	{3449229312U, 24},
	{3434427136U, 24},
	{3418505984U, 24},
	{3409820672U, 24},
	{3399754752U, 24},
	{3359489792U, 24},
	{3332646912U, 24},
	{3257705472U, 24},
	{3255731712U, 24},
	{3250735360U, 24},
	{3229217536U, 24},
	{3224151552U, 24},
	{2866823168U, 19},
	{2866831360U, 19},
	{2866806784U, 19},
	{2866806784U, 16},
	{2866814976U, 19},
	{2866864128U, 20},
	{2866868224U, 20},
	{2866851840U, 20},
	{3639632640U, 24},
	{3625880832U, 24},
	{3536997120U, 24},
	{3500490240U, 24},
	{3493635840U, 24},
	{3491661056U, 24},
	{3479825664U, 24},
	{3414624000U, 24},
	{3407781376U, 24},
	{3399820288U, 24},
	{3360409600U, 24},
	{3358436864U, 24},
	{3357449472U, 24},
	{3249815040U, 24},
	{3234023424U, 24},
	{3232050688U, 24},
	{3231063296U, 24},
	{3223229696U, 24},
	{3635029760U, 24},
	{3632792832U, 24},
	{3627269632U, 24},
	{3585817344U, 24},
	{3556802816U, 24},
	{3513180672U, 24},
	{3422511360U, 24},
	{3408051200U, 24},
	{3361064960U, 24},
	{3358830080U, 24},
	{3357720320U, 24},
	{3355483392U, 24},
	{3349821440U, 24},
	{3326400256U, 24},
	{3276067328U, 24},
	{3261526272U, 24},
	{3231255552U, 24},
	{2296184832U, 16},
	{3639567104U, 24},
	{3470542336U, 24},
	{3468304384U, 24},
	{3427130624U, 24},
	{3406860032U, 24},
	{3360020736U, 24},
	{3358764544U, 24},
	{3328701696U, 24},
	{3231190016U, 24},
	{2296119296U, 16},
	{3505154816U, 24},
	{3470738944U, 24},
	{3428305920U, 24},
	{3407920128U, 24},
	{3407056640U, 24},
	{3405946368U, 24},
	{3399157248U, 24},
	{3234748672U, 24},
	{3230276864U, 24},
	{3228951040U, 24},
	{3224479232U, 24},
	{2868707328U, 17},
	{2868707328U, 16},
	{2868740096U, 17},
	{2296342272U, 24},
	{2296342016U, 24},
	{2296341760U, 24},
	{2296341504U, 24},
	{2296341248U, 24},
	{2296340992U, 24},
	{2296340736U, 24},
	{2296340480U, 24},
	{2296342528U, 24},
	{2296320512U, 23},
	{2296320256U, 24},
	{2296320000U, 24},
	{2296317696U, 24},
	{2296316928U, 23},
	{2296315904U, 22},
	{2296315904U, 20},
	{2296319488U, 24},
	{2296319232U, 24},
	{2296318976U, 24},
	{2296318720U, 24},
	{2296318464U, 24},
	{2296328192U, 24},
	{2296324096U, 24},
	{2296379392U, 24},
	{2296352512U, 24},
	{3651741184U, 24},
	{3518512896U, 24},
	{3452916736U, 24},
	{3428240384U, 24},
	{3407985664U, 24},
	{3406991104U, 24},
	{3389234944U, 24},
	{3357654784U, 24},
	{3288568064U, 24},
	{3278237696U, 24},
	{3230342400U, 24},
	{2868663808U, 24},
	{2868663040U, 24},
	{2868662272U, 24},
	{2868662272U, 21},
	{2868665344U, 24},
	{2868665344U, 22},
	{2868664320U, 22},
	{2868664320U, 21},
	{2868658176U, 24},
	{2868658176U, 21},
	{2868658176U, 18},
	{2868661248U, 23},
	{2868660224U, 21},
	{2868672000U, 24},
	{2868672000U, 23},
	{2868672256U, 24},
	{2868671488U, 24},
	{2868671488U, 23},
	{2868671744U, 24},
	{2868670464U, 24},
	{2868670464U, 23},
	{2868670720U, 24},
	{2868674048U, 24},
	{2868674304U, 24},
	{2868673536U, 24},
	{2868673792U, 24},
	{2868673024U, 24},
	{2868673280U, 24},
	{2868672512U, 24},
	{2868672768U, 24},
	{2868666368U, 24},
	{2868669952U, 24},
	{2868668416U, 24},
	{2868646656U, 24},
	{2868645888U, 21},
	{2868642560U, 24},
	{2868641792U, 16},
	{2868643840U, 21},
	{2868655104U, 24},
	{2868657152U, 24},
	{2868657152U, 23},
	{2868657408U, 24},
	{2868656128U, 24},
	{2868656128U, 23},
	{2868656384U, 24},
	{2868697600U, 24},
	{2868697344U, 24},
	{2868704256U, 24},
	{2868703744U, 24},
	{2868705792U, 23},
	{2868706048U, 24},
	{2868699648U, 24},
	{2868699648U, 23},
	{2868699392U, 24},
	{2868701696U, 24},
	{2868701440U, 24},
	{2868678656U, 24},
	{2868680704U, 21},
	{2868676608U, 24},
	{2868676608U, 21},
	{2868676864U, 24},
	{2868686848U, 22},
	{2868690432U, 24},
	{2868690688U, 24},
	{2868689920U, 24},
	{2868689664U, 24},
	{2868682752U, 21},
	{2868684800U, 23},
	{3502194176U, 24},
	{3491075072U, 24},
	{3485409536U, 24},
	{3462593792U, 24},
	{3418903040U, 24},
	{3409423616U, 24},
	{3407187712U, 24},
	{3392646144U, 24},
	{3355745536U, 24},
	{3333306624U, 24},
	{3258426368U, 24},
	{3236592384U, 24},
	{2868600320U, 24},
	{2868605184U, 24},
	{2868605696U, 24},
	{2868605440U, 23},
	{2868600832U, 22},
	{2868601856U, 22},
	{2868603904U, 24},
	{2868576256U, 16},
	{2868589568U, 22},
	{2868625408U, 18},
	{2868609024U, 22},
	{2868610048U, 22},
	{2868617472U, 24},
	{2868618240U, 24},
	{2295922688U, 16},
	{3678521856U, 24},
	{3627466240U, 24},
	{3586013952U, 24},
	{3557130496U, 24},
	{3503839232U, 24},
	{3502852352U, 24},
	{3491009536U, 24},
	{3488314368U, 24},
	{3477200384U, 24},
	{3474230016U, 24},
	{3461402112U, 24},
	{3454760448U, 24},
	{3449553152U, 24},
	{3437983488U, 24},
	{3389366016U, 24},
	{3360737280U, 24},
	{3345216512U, 24},
	{3335085824U, 24},
	{3333372160U, 24},
	{3331136256U, 24},
	{3255146240U, 24},
	{3240605184U, 24},
	{3235399680U, 24},
	{3233689088U, 24},
	{2868510720U, 16},
	{3624307968U, 24},
	{3588779520U, 24},
	{3485278464U, 24},
	{3465417472U, 24},
	{3454563840U, 24},
	{3449749760U, 24},
	{3356986368U, 24},
	{3351928320U, 24},
	{3328242944U, 24},
	{3284818432U, 24},
	{3222766592U, 24},
	{2868445184U, 16},
	{2296053760U, 16},
	{3633251584U, 24},
	{3624373504U, 24},
	{3588845056U, 24},
	{3586870272U, 24},
	{3520747776U, 24},
	{3466461696U, 24},
	{3458578688U, 24},
	{3453633792U, 24},
	{3358895616U, 24},
	{3323363840U, 24},
	{3273033472U, 24},
	{3225669888U, 24},
	{2868403712U, 24},
	{2868403968U, 24},
	{2868403456U, 24},
	{2868396544U, 24},
	{2868398848U, 24},
	{2868408320U, 22},
	{2868409344U, 22},
	{2868411904U, 24},
	{2868412160U, 24},
	{2868379648U, 16},
	{2868383232U, 24},
	{2868387840U, 22},
	{2868428800U, 21},
	{2868437504U, 24},
	{2868412416U, 21},
	{2868427776U, 23},
	{2295988224U, 16},
	{3564037888U, 24},
	{3489096960U, 24},
	{3485750784U, 24},
	{3481267456U, 24},
	{3475683328U, 24},
	{3448832256U, 24},
	{3407449856U, 24},
	{3397392128U, 24},
	{3323560448U, 24},
	{3263160320U, 24},
	{3259814656U, 24},
	{3426396672U, 24},
	{3419685632U, 24},
	{3407384320U, 24},
	{3392842752U, 24},
	{3359288832U, 24},
	{3352579840U, 24},
	{3350341888U, 24},
	{3341529088U, 24},
	{3333564416U, 24},
	{3253172736U, 24},
	{3238630400U, 24},
	{3236395776U, 24},
	{3631016704U, 24},
	{3582068736U, 24},
	{3510220544U, 24},
	{3509102080U, 24},
	{3463249152U, 24},
	{3455411968U, 24},
	{3449827840U, 24},
	{3339358720U, 24},
	{3263029248U, 24},
	{3230862336U, 24},
	{3228365568U, 24},
	{2295791616U, 16},
	{3512652032U, 24},
	{3478117888U, 24},
	{3437590272U, 24},
	{3430739456U, 24},
	{3413960960U, 24},
	{3411987200U, 24},
	{3359157760U, 24},
	{3323625984U, 24},
	{3266325504U, 24},
	{3249549056U, 24},
	{3229818112U, 24},
	{3639833088U, 24},
	{3628648704U, 24},
	{3522394880U, 24},
	{3514561280U, 24},
	{3455280896U, 24},
	{3450221056U, 24},
	{3393170432U, 24},
	{3361327104U, 24},
	{3357379584U, 24},
	{3353508864U, 24},
	{3344549632U, 24},
	{3264548352U, 24},
	{3252845056U, 24},
	{2295398400U, 16},
	{3631938048U, 24},
	{3570424832U, 24},
	{3419423488U, 24},
	{3407646464U, 24},
	{3399955712U, 24},
	{3398698496U, 24},
	{3394816512U, 24},
	{3358572288U, 24},
	{3344484096U, 24},
	{3326727936U, 24},
	{3325992960U, 24},
	{3242840064U, 24},
	{3229949184U, 24},
	{3227041792U, 24},
	{3478900480U, 24},
	{3449225472U, 24},
	{3393039360U, 24},
	{3391929600U, 24},
	{3257709824U, 24},
	{3231989504U, 24},
	{3642662144U, 24},
	{3574562816U, 24},
	{3563710208U, 24},
	{3521210880U, 24},
	{3510417152U, 24},
	{3479829504U, 24},
	{3437328128U, 24},
	{3414627840U, 24},
	{3407777536U, 24},
	{3398829568U, 24},
	{3358441216U, 24},
	{3357445120U, 24},
	{3352448768U, 24},
	{3325861888U, 24},
	{3263635200U, 24},
	{3257775360U, 24},
	{3240002816U, 24},
	{3231058944U, 24},
	{2295487488U, 22},
	{2295485440U, 22},
	{2295481344U, 22},
	{2295469056U, 22},
	{2295463936U, 16},
	{3465027584U, 24},
	{3448251136U, 24},
	{3432592128U, 24},
	{3424815104U, 24},
	{3421389568U, 24},
	{3416917760U, 24},
	{3408039680U, 24},
	{3406937088U, 24},
	{3390160128U, 24},
	{3389041664U, 24},
	{3331930368U, 24},
	{3328624128U, 24},
	{3323048192U, 24},
	{3277189120U, 24},
	{3261514240U, 24},
	{3230150144U, 24},
	{3639562240U, 24},
	{3582540544U, 24},
	{3518630912U, 24},
	{3425868032U, 24},
	{3360025088U, 24},
	{3356540672U, 24},
	{3328689664U, 24},
	{3259359232U, 24},
	{3228024832U, 24},
	{3632936448U, 24},
	{3530932992U, 24},
	{3500678144U, 24},
	{3479490304U, 24},
	{3477531904U, 24},
	{3473058048U, 24},
	{3421258496U, 24},
	{3407908608U, 24},
	{3365615360U, 24},
	{3350796800U, 24},
	{3290464256U, 24},
	{3242648320U, 24},
	{3227828224U, 24},
	{2865651712U, 19},
	{2865643520U, 19},
	{2865635328U, 19},
	{2865627136U, 19},
	{2865627136U, 16},
	{2865686272U, 24},
	{2865684480U, 23},
	{2865684992U, 23},
	{2865676288U, 19},
	{2865668096U, 19},
	{2865659904U, 19},
	{3492840704U, 24},
	{3357641728U, 24},
	{3340862208U, 24},
	{3288572416U, 24},
	{3231334144U, 24},
	{3230346752U, 24},
	{3226923776U, 24},
	{2865692672U, 16},
	{2297233408U, 16},
	{3630356480U, 24},
	{3521796352U, 24},
	{3489969664U, 24},
	{3430145280U, 24},
	{3409419776U, 24},
	{3271252736U, 24},
	{3237697792U, 24},
	{2865267712U, 24},
	{2297036800U, 16},
	{3650889216U, 24},
	{3635352576U, 24},
	{3502864896U, 24},
	{3486082304U, 24},
	{3449565696U, 24},
	{3431801344U, 24},
	{3406146816U, 24},
	{3389369344U, 24},
	{3358034944U, 24},
	{3251202816U, 24},
	{3240592640U, 24},
	{3231465216U, 24},
	{3225543168U, 24},
	{3221595648U, 24},
	{2865299456U, 16},
	{2297102336U, 16},
	{3485274624U, 24},
	{3465420800U, 24},
	{3454551296U, 24},
	{3351932160U, 24},
	{3226727168U, 24},
	{3223618560U, 24},
	{3222779648U, 24},
	{3221661184U, 24},
	{2865390592U, 24},
	{2865392640U, 24},
	{2865393664U, 24},
	{2865364992U, 16},
	{2865422336U, 24},
	{2865422336U, 20},
	{2865422848U, 24},
	{2865424128U, 24},
	{2865424384U, 24},
	{2865424640U, 24},
	{2865424896U, 24},
	{2865426432U, 20},
	{2865426688U, 24},
	{2865426944U, 24},
	{2865427200U, 24},
	{2865428992U, 24},
	{2865430016U, 24},
	{2865416192U, 24},
	{2865416448U, 24},
	{2865416704U, 24},
	{2865416960U, 24},
	{2865417728U, 24},
	{2865417984U, 24},
	{2865418752U, 24},
	{2865419008U, 24},
	{2865419776U, 24},
	{2865420032U, 24},
	{2865420800U, 24},
	{2865421056U, 24},
	{2296905728U, 16},
	{3588840704U, 24},
	{3528646912U, 24},
	{3460557824U, 24},
	{3458566656U, 24},
	{3448709888U, 24},
	{3425011712U, 24},
	{3407264768U, 24},
	{3406277888U, 24},
	{3358891264U, 24},
	{3341124352U, 24},
	{3234556416U, 24},
	{3232566272U, 24},
	{3650168320U, 24},
	{3625561856U, 24},
	{3512590848U, 24},
	{3449946368U, 24},
	{3448844800U, 24},
	{3446590720U, 24},
	{3435423232U, 24},
	{3427593728U, 24},
	{3407461376U, 24},
	{3333626624U, 24},
	{3285547008U, 24},
	{3258685184U, 24},
	{3257566720U, 24},
	{3254212608U, 24},
	{3238569728U, 24},
	{3635545344U, 24},
	{3471263232U, 24},
	{3469042688U, 24},
	{3464568832U, 24},
	{3456739328U, 24},
	{3410880768U, 24},
	{3265465856U, 24},
	{3253160192U, 24},
	{3249675264U, 24},
	{3236382720U, 24},
	{3226329600U, 24},
	{2296840192U, 16},
	{3650299392U, 24},
	{3636883968U, 24},
	{3531457280U, 24},
	{3509097728U, 24},
	{3502668288U, 24},
	{3450933248U, 24},
	{3437511680U, 24},
	{3431080448U, 24},
	{3409550848U, 24},
	{3391655424U, 24},
	{3246247936U, 24},
	{3245129984U, 24},
	{3237304576U, 24},
	{3633456896U, 24},
	{3487909632U, 24},
	{3413957120U, 24},
	{3412970240U, 24},
	{3411998720U, 24},
	{3392708352U, 24},
	{3343901952U, 24},
	{3336916480U, 24},
	{3323638016U, 24},
	{2865168384U, 16},
	{2296709120U, 16},
	{3507271424U, 24},
	{3451326464U, 24},
	{3415553024U, 24},
	{3407723520U, 24},
	{3389828096U, 24},
	{3353497344U, 24},
	{3289162240U, 24},
	{3263441920U, 24},
	{3228221440U, 24},
	{2296512512U, 16},
	{3631925504U, 24},
	{3529040128U, 24},
	{3487778560U, 24},
	{3436214016U, 24},
	{3416721152U, 24},
	{3409878528U, 24},
	{3399943680U, 24},
	{3356339712U, 24},
	{3326731264U, 24},
	{3325989632U, 24},
	{3229953536U, 24},
	{3229274368U, 24},
	{3228286976U, 24},
	{2296578048U, 16},
	{3633784576U, 24},
	{3629902592U, 24},
	{3586293504U, 24},
	{3482791936U, 24},
	{3478912000U, 24},
	{3451195392U, 24},
	{3332639232U, 24},
	{3275593216U, 24},
	{3258816256U, 24},
	{2864840704U, 24},
	{2864844800U, 24},
	{2296406016U, 20},
	{2296406016U, 19},
	{2296410112U, 20},
	{2296397824U, 19},
	{2296401920U, 21},
	{2296389632U, 19},
	{2296381440U, 18},
	{2296381440U, 16},
	{2296440832U, 21},
	{2296438784U, 21},
	{2296438784U, 19},
	{2296444928U, 21},
	{2296442880U, 21},
	{2296430592U, 20},
	{2296430592U, 19},
	{2296434688U, 20},
	{2296414208U, 18},
	{3514351616U, 24},
	{3492647936U, 24},
	{3490690560U, 24},
	{3437315072U, 24},
	{3427528192U, 24},
	{3414631680U, 24},
	{3358428160U, 24},
	{3352460288U, 24},
	{3266584320U, 24},
	{3263638528U, 24},
	{2296446976U, 16},
	{3503057664U, 24},
	{3500805376U, 24},
	{3489703680U, 24},
	{3472930816U, 24},
	{3424819456U, 24},
	{3408043520U, 24},
	{3399033856U, 24},
	{3357711616U, 24},
	{3344295168U, 24},
	{3328628480U, 24},
	{3261518592U, 24},
	{3244740608U, 24},
	{3230154496U, 24},
	{3639558400U, 24},
	{3501857792U, 24},
	{3452794368U, 24},
	{3449299712U, 24},
	{3431543552U, 24},
	{3425863680U, 24},
	{3406867712U, 24},
	{3360029440U, 24},
	{3328694016U, 24},
	{3228029184U, 24},
	{3222316544U, 24},
	{2866544640U, 24},
	{3570298624U, 24},
	{3498716928U, 24},
	{3454817280U, 24},
	{3439150080U, 24},
	{3423840768U, 24},
	{3416790528U, 24},
	{3407912448U, 24},
	{3407064320U, 24},
	{3405954048U, 24},
	{3365611008U, 24},
	{3334015488U, 24},
	{3332905728U, 24},
	{3290468608U, 24},
	{3224470528U, 24},
	{2866741248U, 16},
	{2298281984U, 16},
	{3583654656U, 24},
	{3452925440U, 24},
	{3234822912U, 24},
	{3226919424U, 24},
	{2866675712U, 16},
	{2298216448U, 16},
	{3536349440U, 24},
	{3485401856U, 24},
	{3480473344U, 24},
	{3450736640U, 24},
	{3418910720U, 24},
	{3409415936U, 24},
	{3389308160U, 24},
	{3331078400U, 24},
	{3247193600U, 24},
	{3244478464U, 24},
	{2866348032U, 16},
	{3650893568U, 24},
	{3473258496U, 24},
	{3471529728U, 24},
	{3469309184U, 24},
	{3466338304U, 24},
	{3449561856U, 24},
	{3436733952U, 24},
	{3359017984U, 24},
	{3358039296U, 24},
	{3355819776U, 24},
	{3233680384U, 24},
	{2866282496U, 16},
	{2298085376U, 16},
	{3635152128U, 24},
	{3454555136U, 24},
	{3286784512U, 24},
	{3258287616U, 24},
	{3239552768U, 24},
	{3222775296U, 24},
	{2866479104U, 16},
	{2298019840U, 17},
	{2298019840U, 16},
	{3637207808U, 24},
	{3588836352U, 24},
	{3582929408U, 24},
	{3486217216U, 24},
	{3421065728U, 24},
	{3390483456U, 24},
	{3389504768U, 24},
	{3353959936U, 24},
	{3250326784U, 24},
	{3244412928U, 24},
	{3234560768U, 24},
	{2297954304U, 16},
	{3626667264U, 24},
	{3507004928U, 24},
	{3479039232U, 24},
	{3449950208U, 24},
	{3448840960U, 24},
	{3407457536U, 24},
	{3368317696U, 24},
	{3333622272U, 24},
	{3325788672U, 24},
	{3254208768U, 24},
	{3227378176U, 24},
	{3226268416U, 24},
	{2866119680U, 24},
	{2866118912U, 24},
	{2866118656U, 24},
	{2297888768U, 16},
	{3624513280U, 24},
	{3474499840U, 24},
	{3469047040U, 24},
	{3459942912U, 24},
	{3411863808U, 24},
	{3636880128U, 24},
	{3630168576U, 24},
	{3522517248U, 24},
	{3520559872U, 24},
	{3509093376U, 24},
	{3488958208U, 24},
	{3485889536U, 24},
	{3480018432U, 24},
	{3464638720U, 24},
	{3409547008U, 24},
	{3400599040U, 24},
	{3273368832U, 24},
	{3269745408U, 24},
	{3245133824U, 24},
	{3237300224U, 24},
	{3230871040U, 24},
	{3228356864U, 24},
	{2866249472U, 24},
	{2866246912U, 24},
	{2866246656U, 24},
	{2866245632U, 23},
	{2866246400U, 24},
	{2866246144U, 24},
	{2866244608U, 23},
	{2866245376U, 24},
	{2866244096U, 23},
	{2866242816U, 24},
	{2866241536U, 19},
	{2866240512U, 23},
	{2866241024U, 24},
	{2866239488U, 23},
	{2866240256U, 24},
	{2866240000U, 24},
	{2866237696U, 24},
	{2866237440U, 24},
	{2866236672U, 24},
	{2866236416U, 24},
	{2866237184U, 24},
	{2866236928U, 24},
	{2866235648U, 24},
	{2866235392U, 24},
	{2866236160U, 24},
	{2866235904U, 24},
	{2866234624U, 24},
	{2866234368U, 24},
	{2866234880U, 23},
	{2866233600U, 24},
	{2866233344U, 24},
	{2866233344U, 19},
	{2866234112U, 24},
	{2866233856U, 24},
	{2866231296U, 21},
	{2866231040U, 24},
	{2866229248U, 21},
	{2866227200U, 21},
	{2866225152U, 21},
	{2866224128U, 23},
	{2866224640U, 24},
	{2866223104U, 22},
	{2866222080U, 22},
	{2866216960U, 19},
	{2866216960U, 16},
	{2866270208U, 24},
	{2866269952U, 24},
	{2866268160U, 24},
	{2866267392U, 24},
	{2866267648U, 23},
	{2866266112U, 19},
	{2866266112U, 18},
	{2866263040U, 23},
	{2866262528U, 24},
	{2866261504U, 24},
	{2866259200U, 24},
	{2866256640U, 24},
	{3498258176U, 24},
	{3413953280U, 24},
	{3397175808U, 24},
	{3358170368U, 24},
	{3340411136U, 24},
	{3323633664U, 24},
	{3260018944U, 24},
	{3248561152U, 24},
	{3245199360U, 24},
	{3227443712U, 24},
	{2297716736U, 19},
	{2297708544U, 19},
	{2297692160U, 19},
	{2297692160U, 16},
	{2297724928U, 17},
	{3584428032U, 24},
	{3446332416U, 24},
	{3424496128U, 24},
	{3357388288U, 24},
	{3356278528U, 24},
	{3354611456U, 24},
	{3353501184U, 24},
	{3344557312U, 24},
	{3289166592U, 24},
	{3227116032U, 24},
	{2297626624U, 16},
	{3629709824U, 24},
	{3529043968U, 24},
	{3503323648U, 24},
	{3499376128U, 24},
	{3493762048U, 24},
	{3450277888U, 24},
	{3436209664U, 24},
	{3434479616U, 24},
	{3429620992U, 24},
	{3409874688U, 24},
	{3407654144U, 24},
	{3399948032U, 24},
	{3389897984U, 24},
	{3358563584U, 24},
	{3356344064U, 24},
	{3250682368U, 24},
	{3229957888U, 24},
	{2865758208U, 16},
	{2297561088U, 16},
	{3520297728U, 24},
	{3504359680U, 24},
	{3490621184U, 24},
	{3469960192U, 24},
	{3460139520U, 24},
	{3432456704U, 24},
	{3431346944U, 24},
	{3411798272U, 24},
	{3407850752U, 24},
	{3345536512U, 24},
	{3333753344U, 24},
	{3331794944U, 24},
	{3231133184U, 24},
	{3229204480U, 24},
	{3228094720U, 24},
	{2865954816U, 16},
	{3628854016U, 24},
	{3554757120U, 24},
	{3537008640U, 24},
	{3514355968U, 24},
	{3507463680U, 24},
	{3503454720U, 24},
	{3492644096U, 24},
	{3490686720U, 24},
	{3458115584U, 24},
	{3433369856U, 24},
	{3414635520U, 24},
	{3341652480U, 24},
	{3269548800U, 24},
	{3266579968U, 24},
	{2865920000U, 21},
	{2865917952U, 21},
	{2865916928U, 22},
	{2865911808U, 22},
	{2865912832U, 22},
	{2865909760U, 22},
	{2865909248U, 24},
	{2865909504U, 24},
	{2865905664U, 22},
	{2865906688U, 24},
	{2865903616U, 22},
	{2865904640U, 24},
	{2865901568U, 22},
	{2865902592U, 22},
	{2865900544U, 24},
	{2865900800U, 24},
	{2865901056U, 24},
	{2865897472U, 22},
	{2865898496U, 22},
	{2865895424U, 21},
	{2865893376U, 24},
	{2865893376U, 21},
	{2865893632U, 24},
	{2865893888U, 24},
	{2865894144U, 24},
	{2865894400U, 24},
	{2865894656U, 24},
	{2865894912U, 24},
	{2865895168U, 24},
	{2865891328U, 21},
	{2865889280U, 24},
	{2865889280U, 16},
	{2865950720U, 22},
	{2865951744U, 24},
	{2865952000U, 24},
	{2865952256U, 24},
	{2865952512U, 24},
	{2865949696U, 24},
	{2865949952U, 24},
	{2865950208U, 24},
	{2865946624U, 21},
	{2865944576U, 22},
	{2865942528U, 21},
	{2865940480U, 21},
	{2865938432U, 21},
	{2865936384U, 21},
	{2865935360U, 24},
	{2865935616U, 24},
	{2865935872U, 24},
	{2865936128U, 24},
	{2865932288U, 21},
	{2865930240U, 22},
	{2865928192U, 22},
	{2865926144U, 21},
	{2865924096U, 21},
	{2865922048U, 21},
	{3546692864U, 24},
	{3484085504U, 24},
	{3448294656U, 24},
	{3439311616U, 24},
	{3408027904U, 24},
	{3389014528U, 24},
	{3359900672U, 24},
	{3357696512U, 24},
	{3326347776U, 24},
	{3273812224U, 24},
	{3260358400U, 24},
	{3234628608U, 24},
	{3524283136U, 24},
	{3490728192U, 24},
	{3489748992U, 24},
	{3488590080U, 24},
	{3452799232U, 24},
	{3448360192U, 24},
	{3438258688U, 24},
	{3358749440U, 24},
	{3356512512U, 24},
	{3355525120U, 24},
	{3273877760U, 24},
	{2854477824U, 22},
	{2854478848U, 22},
	{2854483968U, 22},
	{2854481920U, 22},
	{2854482944U, 22},
	{2854420480U, 16},
	{2567962624U, 16},
	{2281766912U, 16},
	{3637419008U, 24},
	{3625140480U, 24},
	{3558899200U, 24},
	{3516645376U, 24},
	{3487537664U, 24},
	{3439180544U, 24},
	{3430232832U, 24},
	{3417962496U, 24},
	{3411482112U, 24},
	{3350852608U, 24},
	{3338514688U, 24},
	{3332957184U, 24},
	{3235878144U, 24},
	{2854223872U, 16},
	{2568159232U, 16},
	{2281832448U, 16},
	{3648267776U, 24},
	{3631490816U, 24},
	{3501777664U, 24},
	{3480498176U, 24},
	{3477537536U, 24},
	{3458294784U, 24},
	{3430167296U, 24},
	{3429179904U, 24},
	{3422338048U, 24},
	{3420364288U, 24},
	{3389211136U, 24},
	{3357630976U, 24},
	{3350787072U, 24},
	{3338449152U, 24},
	{3278187776U, 24},
	{3227856384U, 24},
	{3225881600U, 24},
	{2854289408U, 16},
	{2568093696U, 16},
	{3572150784U, 24},
	{3520693248U, 24},
	{3506723072U, 24},
	{3485465600U, 24},
	{3439049472U, 24},
	{3409408000U, 24},
	{3389276672U, 24},
	{3288615936U, 24},
	{3286934784U, 24},
	{3271838464U, 24},
	{3237721856U, 24},
	{3224861440U, 24},
	{2854617088U, 16},
	{3489314816U, 24},
	{3476452352U, 24},
	{3448622336U, 24},
	{3430036224U, 24},
	{3407106560U, 24},
	{3351180288U, 24},
	{3333415936U, 24},
	{3327138560U, 24},
	{3255126528U, 24},
	{3251209472U, 24},
	{3233739520U, 24},
	{3231502592U, 24},
	{3226475776U, 24},
	{2568224768U, 16},
	{3516907520U, 24},
	{3504911872U, 24},
	{3448687872U, 24},
	{3443654912U, 24},
	{3428852224U, 24},
	{3418224640U, 24},
	{3407303168U, 24},
	{3355029504U, 24},
	{3344967936U, 24},
	{3342994176U, 24},
	{3335160320U, 24},
	{3328190464U, 24},
	{3233673984U, 24},
	{3232555520U, 24},
	{3227528704U, 24},
	{3222755584U, 24},
	{3221637120U, 24},
	{3639197184U, 24},
	{3558231296U, 24},
	{3486223104U, 24},
	{3470433024U, 24},
	{3448753408U, 24},
	{3437865472U, 24},
	{3422075904U, 24},
	{3417172224U, 24},
	{3407237632U, 24},
	{3360822528U, 24},
	{3358880512U, 24},
	{3354963968U, 24},
	{3353977088U, 24},
	{3350062336U, 24},
	{3328256000U, 24},
	{3234563072U, 24},
	{3228581632U, 24},
	{2854612480U, 23},
	{2854612224U, 24},
	{2854551552U, 18},
	{2854551552U, 17},
	{2854567936U, 18},
	{3631101440U, 24},
	{3624423424U, 24},
	{3517117184U, 24},
	{3512536064U, 24},
	{3509222144U, 24},
	{3480101120U, 24},
	{3444310272U, 24},
	{3430992896U, 24},
	{3407434240U, 24},
	{3350459392U, 24},
	{3338121472U, 24},
	{3333682432U, 24},
	{3253118720U, 24},
	{2282258432U, 19},
	{2282225664U, 20},
	{3624488960U, 24},
	{3557383168U, 24},
	{3518161408U, 24},
	{3504846336U, 24},
	{3501384448U, 24},
	{3458950144U, 24},
	{3421944832U, 24},
	{3414280960U, 24},
	{3392827648U, 24},
	{3357036800U, 24},
	{3338055936U, 24},
	{3335820032U, 24},
	{3263053056U, 24},
	{3245289216U, 24},
	{3236406784U, 24},
	{3229499136U, 24},
	{3225058048U, 24},
	{2282348544U, 24},
	{3628995584U, 24},
	{3509091072U, 24},
	{3508226048U, 24},
	{3507116288U, 24},
	{3466652672U, 24},
	{3464678912U, 24},
	{3463192576U, 24},
	{3420761344U, 24},
	{3390788352U, 24},
	{3358089728U, 24},
	{3346872320U, 24},
	{3264467712U, 24},
	{3683830272U, 24},
	{3635473152U, 24},
	{3631035904U, 24},
	{3499278592U, 24},
	{3484482560U, 24},
	{3400595712U, 24},
	{3391709184U, 24},
	{3359142656U, 24},
	{3350262784U, 24},
	{3336937472U, 24},
	{3333485824U, 24},
	{3222952192U, 24},
	{3641463040U, 24},
	{3500601856U, 24},
	{3493817088U, 24},
	{3464179968U, 24},
	{3414477568U, 24},
	{3406578432U, 24},
	{3402735360U, 24},
	{3393155328U, 24},
	{3356246016U, 24},
	{3349603584U, 24},
	{3282493696U, 24},
	{2855141376U, 16},
	{2568814592U, 16},
	{3631884032U, 24},
	{3582317824U, 24},
	{3512208384U, 24},
	{3492772352U, 24},
	{3418459904U, 24},
	{3413783552U, 24},
	{3354570752U, 24},
	{3344439808U, 24},
	{3252922112U, 24},
	{3249992192U, 24},
	{3229990912U, 24},
	{3228249600U, 24},
	{2855206912U, 16},
	{3629843712U, 24},
	{3513270016U, 24},
	{3473819392U, 24},
	{3460956672U, 24},
	{3460134144U, 24},
	{3453196288U, 24},
	{3407827456U, 24},
	{3389932032U, 24},
	{3360293888U, 24},
	{3359470336U, 24},
	{3357495552U, 24},
	{3356377088U, 24},
	{3332695040U, 24},
	{3223279872U, 24},
	{2568945664U, 16},
	{3522209280U, 24},
	{3514314240U, 24},
	{3413652480U, 24},
	{3407761920U, 24},
	{3399870464U, 24},
	{3390984960U, 24},
	{3360359424U, 24},
	{3358417408U, 24},
	{3231109376U, 24},
	{3226143744U, 24},
	{3567970048U, 24},
	{3523234560U, 24},
	{3514253056U, 24},
	{3477344768U, 24},
	{3438197504U, 24},
	{3334202368U, 24},
	{3231301632U, 24},
	{3227926272U, 24},
	{2855534336U, 24},
	{3490732032U, 24},
	{3461612032U, 24},
	{3449343232U, 24},
	{3427078400U, 24},
	{3408097280U, 24},
	{3359970560U, 24},
	{3328653568U, 24},
	{3327396352U, 24},
	{3261545728U, 24},
	{3227991808U, 24},
	{2566979584U, 16},
	{3566982144U, 24},
	{3558895360U, 24},
	{3480559872U, 24},
	{3475010560U, 24},
	{3462672640U, 24},
	{3459343360U, 24},
	{3407900672U, 24},
	{3403648512U, 24},
	{3393591040U, 24},
	{3392233472U, 24},
	{3389149952U, 24},
	{3357569792U, 24},
	{3355287808U, 24},
	{3336536576U, 24},
	{3334071296U, 24},
	{3234764032U, 24},
	{3224463872U, 24},
	{2855337984U, 16},
	{2567107072U, 24},
	{2567108352U, 24},
	{2567108096U, 24},
	{2567107584U, 24},
	{2567105024U, 24},
	{2567104512U, 24},
	{2567106304U, 24},
	{2567106048U, 24},
	{2567105792U, 24},
	{2567105536U, 24},
	{2567103232U, 24},
	{2567102976U, 24},
	{2567102720U, 24},
	{2567102464U, 24},
	{2567104256U, 24},
	{2567104000U, 24},
	{2567103744U, 24},
	{2567103488U, 24},
	{2567045120U, 16},
	{3640442368U, 24},
	{3587145728U, 24},
	{3498819840U, 24},
	{3469712128U, 24},
	{3430162944U, 24},
	{3422334208U, 24},
	{3406971648U, 24},
	{3355660544U, 24},
	{3350783232U, 24},
	{3326548736U, 24},
	{3259440896U, 24},
	{3557051648U, 24},
	{3529649408U, 24},
	{3510635520U, 24},
	{3502802176U, 24},
	{3489376512U, 24},
	{3485461760U, 24},
	{3430097408U, 24},
	{3412210688U, 24},
	{3407168256U, 24},
	{3391516928U, 24},
	{3331118848U, 24},
	{3286938624U, 24},
	{3258982144U, 24},
	{3256175104U, 24},
	{3224857088U, 24},
	{2855731200U, 16},
	{3611363840U, 24},
	{3510008576U, 24},
	{3476448512U, 24},
	{3460371200U, 24},
	{3453520128U, 24},
	{3360687104U, 24},
	{3351876096U, 24},
	{3346147584U, 24},
	{3337335040U, 24},
	{3287004160U, 24},
	{3257366784U, 24},
	{3240589824U, 24},
	{2855727104U, 24},
	{2855665664U, 16},
	{2855680768U, 24},
	{2567241728U, 16},
	{3516911872U, 24},
	{3422967040U, 24},
	{3419053568U, 24},
	{3418220800U, 24},
	{3407299328U, 24},
	{3393328896U, 24},
	{3392495616U, 24},
	{3356966912U, 24},
	{3351941632U, 24},
	{3322306304U, 24},
	{3257170176U, 24},
	{3233669632U, 24},
	{3222751232U, 24},
	{3221641472U, 24},
	{2855600128U, 16},
	{3625340928U, 24},
	{3588858368U, 24},
	{3576000000U, 24},
	{3558235136U, 24},
	{3510832128U, 24},
	{3470428672U, 24},
	{3454646784U, 24},
	{3407233792U, 24},
	{3341122560U, 24},
	{3265184256U, 24},
	{3247427584U, 24},
	{3224660480U, 24},
	{3221707008U, 24},
	{3624419584U, 24},
	{3523758848U, 24},
	{3519316992U, 24},
	{3509217792U, 24},
	{3474540288U, 24},
	{3450011136U, 24},
	{3418660352U, 24},
	{3407430400U, 24},
	{3333678080U, 24},
	{3325783040U, 24},
	{3285550848U, 24},
	{3253122560U, 24},
	{2855993344U, 16},
	{3624485120U, 24},
	{3517178368U, 24},
	{3510270720U, 24},
	{3505829376U, 24},
	{3427602688U, 24},
	{3414284800U, 24},
	{3357032448U, 24},
	{3354829056U, 24},
	{3345954816U, 24},
	{3263048704U, 24},
	{3258607616U, 24},
	{3234174208U, 24},
	{3229494784U, 24},
	{2567503872U, 16},
	{3564976640U, 24},
	{3520566528U, 24},
	{3518100224U, 24},
	{3509086720U, 24},
	{3426313728U, 24},
	{3424338944U, 24},
	{3419901696U, 24},
	{3407561472U, 24},
	{3399547136U, 24},
	{3332437248U, 24},
	{3328117248U, 24},
	{3241765632U, 24},
	{3231773440U, 24},
	{3228319488U, 24},
	{2855862272U, 16},
	{2567569408U, 16},
	{3639918080U, 24},
	{3631032064U, 24},
	{3481018624U, 24},
	{3426248192U, 24},
	{3409469696U, 24},
	{3230842880U, 24},
	{2855796736U, 24},
	{2567634944U, 16},
	{3637615616U, 24},
	{3628598528U, 24},
	{3516256512U, 24},
	{3510598400U, 24},
	{3485506048U, 24},
	{3450273280U, 24},
	{3436283904U, 24},
	{3407692544U, 24},
	{3397067776U, 24},
	{3361276928U, 24},
	{3356250368U, 24},
	{3345627136U, 24},
	{3282497536U, 24},
	{2856255488U, 16},
	{3631887872U, 24},
	{3628664064U, 24},
	{3626984192U, 24},
	{3582313472U, 24},
	{3498426624U, 24},
	{3413779712U, 24},
	{3390849536U, 24},
	{3325979648U, 24},
	{3289210112U, 24},
	{3252925952U, 24},
	{3584353792U, 24},
	{3520304384U, 24},
	{3513265664U, 24},
	{3491715072U, 24},
	{3431390464U, 24},
	{3407823616U, 24},
	{3360298240U, 24},
	{3357491200U, 24},
	{3352527616U, 24},
	{3349476352U, 24},
	{3331835392U, 24},
	{3507439616U, 24},
	{3498557696U, 24},
	{3453126912U, 24},
	{3437345536U, 24},
	{3418594816U, 24},
	{3407758080U, 24},
	{3400853504U, 24},
	{3399874816U, 24},
	{3390980608U, 24},
	{3360363776U, 24},
	{3357425664U, 24},
	{3343587840U, 24},
	{3333743616U, 24},
	{3269571840U, 24},
	{3258738688U, 24},
	{3234043136U, 24},
	{3232101120U, 24},
	{3230126336U, 24},
	{2856058880U, 18},
	{2856069888U, 24},
	{2856075264U, 19},
	{3486296320U, 24},
	{3438184448U, 24},
	{3418085888U, 24},
	{3406917632U, 24},
	{3389022208U, 24},
	{3335299072U, 24},
	{3334199040U, 24},
	{3264868608U, 24},
	{3260366080U, 24},
	{3227913216U, 24},
	{3223472128U, 24},
	{3633900288U, 24},
	{3523118080U, 24},
	{3393528832U, 24},
	{3359974912U, 24},
	{3288428032U, 24},
	{3231249152U, 24},
	{3226746624U, 24},
	{3225759232U, 24},
	{3223537664U, 24},
	{3648324608U, 24},
	{3638537984U, 24},
	{3560000768U, 24},
	{3490933504U, 24},
	{3473040640U, 24},
	{3411489792U, 24},
	{3407889152U, 24},
	{3357556736U, 24},
	{3353325568U, 24},
	{3338507008U, 24},
	{3244559616U, 24},
	{3227782144U, 24},
	{3224459520U, 24},
	{2852257792U, 16},
	{3628545536U, 24},
	{3499811584U, 24},
	{3452939008U, 24},
	{3430158592U, 24},
	{3428201216U, 24},
	{3399153920U, 24},
	{3360105984U, 24},
	{3340848896U, 24},
	{3338890496U, 24},
	{3283669504U, 24},
	{3245612032U, 24},
	{2852323328U, 16},
	{3630306304U, 24},
	{3526839040U, 24},
	{3439040768U, 24},
	{3422840320U, 24},
	{3412199168U, 24},
	{3335036928U, 24},
	{2852388864U, 16},
	{3559349248U, 24},
	{3542571776U, 24},
	{3483171840U, 24},
	{3473237248U, 24},
	{3432840960U, 24},
	{3412264704U, 24},
	{3398297600U, 24},
	{3390337280U, 24},
	{3351879936U, 24},
	{3333408256U, 24},
	{3327146240U, 24},
	{3253437696U, 24},
	{3251218176U, 24},
	{3233730816U, 24},
	{3231511296U, 24},
	{3221580288U, 24},
	{2852454400U, 16},
	{3640233216U, 24},
	{3633248768U, 24},
	{3517763840U, 24},
	{3451771904U, 24},
	{3421015808U, 24},
	{3406192896U, 24},
	{3395290624U, 24},
	{3389415424U, 24},
	{3335168000U, 24},
	{3233665280U, 24},
	{3227520000U, 24},
	{3222764288U, 24},
	{3639188480U, 24},
	{3512802560U, 24},
	{3500073728U, 24},
	{3491130112U, 24},
	{3487217664U, 24},
	{3398428672U, 24},
	{3360831232U, 24},
	{3353969408U, 24},
	{3323362560U, 24},
	{3276946432U, 24},
	{3234571776U, 24},
	{2852585472U, 16},
	{3638991872U, 24},
	{3628873216U, 24},
	{3512544768U, 24},
	{3498111488U, 24},
	{3491326720U, 24},
	{3449998592U, 24},
	{3446538496U, 24},
	{3432120064U, 24},
	{3431001600U, 24},
	{3393987584U, 24},
	{3392885504U, 24},
	{3390664960U, 24},
	{3351552256U, 24},
	{3326879744U, 24},
	{3285562368U, 24},
	{3253110016U, 24},
	{3222895360U, 24},
	{3518152704U, 24},
	{3480158976U, 24},
	{3418729728U, 24},
	{3414288640U, 24},
	{3391832576U, 24},
	{3356058112U, 24},
	{3333609216U, 24},
	{3263045376U, 24},
	{3259837440U, 24},
	{3258604288U, 24},
	{3249721344U, 24},
	{3236398080U, 24},
	{3234178560U, 24},
	{3229490432U, 24},
	{3227270912U, 24},
	{2852749312U, 18},
	{2852730880U, 21},
	{2852716544U, 18},
	{2852732928U, 18},
	{3518087168U, 24},
	{3516977408U, 24},
	{3504641024U, 24},
	{3472202496U, 24},
	{3463184896U, 24},
	{3409531392U, 24},
	{3406455040U, 24},
	{3405094656U, 24},
	{3399535104U, 24},
	{3337982720U, 24},
	{3336864256U, 24},
	{3331585280U, 24},
	{3234244096U, 24},
	{3230921472U, 24},
	{3638926336U, 24},
	{3537282304U, 24},
	{3498308096U, 24},
	{3491392256U, 24},
	{3449933056U, 24},
	{3448962560U, 24},
	{3407507456U, 24},
	{3332490752U, 24},
	{3323624704U, 24},
	{3263422464U, 24},
	{3246136320U, 24},
	{3229868544U, 24},
	{3227401984U, 24},
	{3222960896U, 24},
	{2852847616U, 16},
	{3628611072U, 24},
	{3504509952U, 24},
	{3490478592U, 24},
	{3481595136U, 24},
	{3450260736U, 24},
	{3438516480U, 24},
	{3424483072U, 24},
	{3406586112U, 24},
	{3359592704U, 24},
	{3356254720U, 24},
	{3343395072U, 24},
	{3286402816U, 24},
	{3264606464U, 24},
	{3244952832U, 24},
	{2852913152U, 16},
	{3637554944U, 24},
	{3570443008U, 24},
	{3493742848U, 24},
	{3481660672U, 24},
	{3413775872U, 24},
	{3393082112U, 24},
	{3392094720U, 24},
	{3326683136U, 24},
	{3250693888U, 24},
	{3230987008U, 24},
	{3559676928U, 24},
	{3393016576U, 24},
	{3389939712U, 24},
	{3336602112U, 24},
	{3326748672U, 24},
	{3257682432U, 24},
	{3639643392U, 24},
	{3564636416U, 24},
	{3516326400U, 24},
	{3479765760U, 24},
	{3466972672U, 24},
	{3455096832U, 24},
	{3449224704U, 24},
	{3437332480U, 24},
	{3365337856U, 24},
	{3358408704U, 24},
	{3357438720U, 24},
	{3333740288U, 24},
	{3325845248U, 24},
	{3261664768U, 24},
	{3589177344U, 24},
	{3508684800U, 24},
	{3490806272U, 24},
	{3484081664U, 24},
	{3438188800U, 24},
	{3430350848U, 24},
	{3355472640U, 24},
	{3333084928U, 24},
	{3264864256U, 24},
	{2853240832U, 16},
	{3590230272U, 24},
	{3468348928U, 24},
	{3466128384U, 24},
	{3449351936U, 24},
	{3399018496U, 24},
	{3394511872U, 24},
	{3356516864U, 24},
	{3273873920U, 24},
	{2853208064U, 17},
	{2853177344U, 22},
	{2853178880U, 23},
	{2853178368U, 23},
	{2853175296U, 23},
	{2853175296U, 17},
	{2853175296U, 16},
	{2853207040U, 22},
	{2853203968U, 23},
	{2853203968U, 21},
	{2853204992U, 23},
	{2853204992U, 22},
	{3560004608U, 24},
	{3519981056U, 24},
	{3467173632U, 24},
	{3407892992U, 24},
	{3394708480U, 24},
	{3357561088U, 24},
	{3355280128U, 24},
	{3335434496U, 24},
	{3263885568U, 24},
	{3224455168U, 24},
	{2569011200U, 16},
	{3628541696U, 24},
	{3487475968U, 24},
	{3455879424U, 24},
	{3450461184U, 24},
	{3437144576U, 24},
	{3432705536U, 24},
	{3399149568U, 24},
	{3360110336U, 24},
	{3283665664U, 24},
	{3230397184U, 24},
	{2853306368U, 16},
	{2569076736U, 16},
	{3652110336U, 24},
	{3544198144U, 24},
	{3522925824U, 24},
	{3513982208U, 24},
	{3470370816U, 24},
	{3439036416U, 24},
	{3412203008U, 24},
	{3409396480U, 24},
	{3326097664U, 24},
	{3286930944U, 24},
	{3257293568U, 24},
	{3237708800U, 24},
	{3236599040U, 24},
	{3627438080U, 24},
	{3528473600U, 24},
	{3499946496U, 24},
	{3455748352U, 24},
	{3450854400U, 24},
	{3407110400U, 24},
	{3406131200U, 24},
	{3398301952U, 24},
	{3327141888U, 24},
	{3286996480U, 24},
	{3275832320U, 24},
	{3235423744U, 24},
	{3224782848U, 24},
	{2853478400U, 19},
	{2853474304U, 20},
	{2853470208U, 20},
	{2853486592U, 18},
	{2853437440U, 18},
	{2853437440U, 16},
	{2853462016U, 19},
	{2853453824U, 19},
	{2569502720U, 17},
	{2569502976U, 24},
	{2569519616U, 24},
	{2569478144U, 19},
	{2569469952U, 19},
	{2569469952U, 18},
	{2569494528U, 24},
	{2569494528U, 19},
	{2569486848U, 24},
	{2569486336U, 19},
	{3642192640U, 24},
	{3534537472U, 24},
	{3499025152U, 24},
	{3461554176U, 24},
	{3449810688U, 24},
	{3428847872U, 24},
	{3407307008U, 24},
	{3393336576U, 24},
	{3389419776U, 24},
	{3358932992U, 24},
	{3355017984U, 24},
	{3335172352U, 24},
	{3328187136U, 24},
	{3244301312U, 24},
	{3233660928U, 24},
	{3222759936U, 24},
	{3221650176U, 24},
	{3642127104U, 24},
	{3493091328U, 24},
	{3470436352U, 24},
	{3454638080U, 24},
	{3448765952U, 24},
	{3411158272U, 24},
	{3407241472U, 24},
	{3233595392U, 24},
	{3228568576U, 24},
	{3225632512U, 24},
	{3224651776U, 24},
	{2853568512U, 16},
	{2853587968U, 23},
	{3638988032U, 24},
	{3523766528U, 24},
	{3519325696U, 24},
	{3512549120U, 24},
	{3499225600U, 24},
	{3487996416U, 24},
	{3446542336U, 24},
	{3418668032U, 24},
	{3407438080U, 24},
	{3406327808U, 24},
	{3399670528U, 24},
	{3392881152U, 24},
	{3326884096U, 24},
	{3286668800U, 24},
	{3254224128U, 24},
	{3224000768U, 24},
	{2853765120U, 16},
	{2569666560U, 16},
	{3639053568U, 24},
	{3529260032U, 24},
	{3520378624U, 24},
	{3518157056U, 24},
	{3510262016U, 24},
	{3505820672U, 24},
	{3503601152U, 24},
	{3486820608U, 24},
	{3482381568U, 24},
	{3432050176U, 24},
	{3414292480U, 24},
	{3398494208U, 24},
	{3357041152U, 24},
	{3356062464U, 24},
	{3332626176U, 24},
	{3263041024U, 24},
	{3234182912U, 24},
	{3226287872U, 24},
	{2853699584U, 16},
	{3558571520U, 24},
	{3505755136U, 24},
	{3499356672U, 24},
	{3457901568U, 24},
	{3414358016U, 24},
	{3405090304U, 24},
	{3354755840U, 24},
	{2853929984U, 22},
	{2853947648U, 24},
	{2853896192U, 16},
	{3520509696U, 24},
	{3434138624U, 24},
	{3430678528U, 24},
	{3409462016U, 24},
	{3406524416U, 24},
	{3394188544U, 24},
	{3359129600U, 24},
	{3289087744U, 24},
	{3287582464U, 24},
	{3230851584U, 24},
	{3229355008U, 24},
	{3228376320U, 24},
	{3227397632U, 24},
	{3222956544U, 24},
	{3629725184U, 24},
	{3456922880U, 24},
	{3438512128U, 24},
	{3429503232U, 24},
	{3409920768U, 24},
	{3359588352U, 24},
	{3356259072U, 24},
	{3327731712U, 24},
	{3237184512U, 24},
	{2854027264U, 24},
	{2569991168U, 24},
	{2569990144U, 20},
	{2569929728U, 24},
	{3641532928U, 24},
	{3632655104U, 24},
	{3560856576U, 24},
	{3512221440U, 24},
	{3507317248U, 24},
	{3484864256U, 24},
	{3469780992U, 24},
	{3427349248U, 24},
	{3394774016U, 24},
	{3354559232U, 24},
	{3289218816U, 24},
	{3250697728U, 24},
	{3242802688U, 24},
	{3233920768U, 24},
	{3230982656U, 24},
	{2853994496U, 20},
	{2853961728U, 17},
	{3515277824U, 24},
	{3502417664U, 24},
	{3482840320U, 24},
	{3478855936U, 24},
	{3473830912U, 24},
	{3462927104U, 24},
	{3393012224U, 24},
	{3389944064U, 24},
	{3359457280U, 24},
	{3357499904U, 24},
	{3356390144U, 24},
	{3352535296U, 24},
	{3255728384U, 24},
	{3223284224U, 24},
	{2854158336U, 16},
	{2569797632U, 16},
	{2569818368U, 24},
	{2569820928U, 24},
	{3639647232U, 24},
	{3558768128U, 24},
	{3510393088U, 24},
	{3507448320U, 24},
	{3462992640U, 24},
	{3418602496U, 24},
	{3407765760U, 24},
	{3394905088U, 24},
	{3360372480U, 24},
	{3358413056U, 24},
	{3357434368U, 24},
	{3337650688U, 24},
	{3269564160U, 24},
	{3266626048U, 24},
	{2854092800U, 16},
	{2569863168U, 16},
	{3633941760U, 24},
	{3518735872U, 24},
	{3491905024U, 24},
	{3456105984U, 24},
	{3443803392U, 24},
	{3423670528U, 24},
	{3408012544U, 24},
	{3406894592U, 24},
	{3394589440U, 24},
	{3359916032U, 24},
	{3330834944U, 24},
	{3261491200U, 24},
	{3234643968U, 24},
	{3695531008U, 24},
	{3575855872U, 24},
	{3449329664U, 24},
	{3398999808U, 24},
	{3389064704U, 24},
	{3359981568U, 24},
	{3328666624U, 24},
	{3228002816U, 24},
	{3226753280U, 24},
	{3222281472U, 24},
	{2858876928U, 16},
	{2858877440U, 24},
	{3641902080U, 24},
	{3486437120U, 24},
	{3459330304U, 24},
	{3423801600U, 24},
	{3350835200U, 24},
	{3334058240U, 24},
	{3323996160U, 24},
	{3285107456U, 24},
	{3280635648U, 24},
	{3266950400U, 24},
	{3258006784U, 24},
	{3550119424U, 24},
	{3547621376U, 24},
	{3524398848U, 24},
	{3454922496U, 24},
	{3452947712U, 24},
	{3437157632U, 24},
	{3425710848U, 24},
	{3406960128U, 24},
	{3338466560U, 24},
	{3288532992U, 24},
	{3264911104U, 24},
	{3254579712U, 24},
	{3238202624U, 24},
	{3228859136U, 24},
	{3586105856U, 24},
	{3491040512U, 24},
	{3418340352U, 24},
	{3413340160U, 24},
	{3409392640U, 24},
	{3398209024U, 24},
	{3360772352U, 24},
	{3335046656U, 24},
	{3236618752U, 24},
	{2858598400U, 18},
	{2858582016U, 20},
	{2858586112U, 20},
	{2858590208U, 19},
	{2858549248U, 17},
	{3631375104U, 24},
	{3489332224U, 24},
	{3412287744U, 24},
	{3398274560U, 24},
	{3389326848U, 24},
	{3351162880U, 24},
	{3343932928U, 24},
	{3328404480U, 24},
	{3233724160U, 24},
	{2858614784U, 16},
	{3587949568U, 24},
	{3490061312U, 24},
	{3407287808U, 24},
	{3356955904U, 24},
	{3286819072U, 24},
	{3271954176U, 24},
	{3241491968U, 24},
	{3233658624U, 24},
	{2858475520U, 20},
	{2858479616U, 20},
	{2858418176U, 16},
	{3627296512U, 24},
	{3537552128U, 24},
	{3477292800U, 24},
	{3459526912U, 24},
	{3407222272U, 24},
	{3390445312U, 24},
	{3328273408U, 24},
	{2858526464U, 24},
	{2858483712U, 16},
	{3628879872U, 24},
	{3585319424U, 24},
	{3520446464U, 24},
	{3512551424U, 24},
	{3511441664U, 24},
	{3483543808U, 24},
	{3456631296U, 24},
	{3429787136U, 24},
	{3415318016U, 24},
	{3407418880U, 24},
	{3326889472U, 24},
	{3279980288U, 24},
	{3278792960U, 24},
	{3260898048U, 24},
	{3253134080U, 24},
	{2859335680U, 16},
	{3515909120U, 24},
	{3510251008U, 24},
	{3480184064U, 24},
	{3469069824U, 24},
	{3437751808U, 24},
	{3433277952U, 24},
	{3430840064U, 24},
	{3395048192U, 24},
	{3359258368U, 24},
	{3354850304U, 24},
	{3238595840U, 24},
	{3228527104U, 24},
	{2572943360U, 16},
	{3633548544U, 24},
	{3629010944U, 24},
	{3576183552U, 24},
	{3520577536U, 24},
	{3492298240U, 24},
	{3454332672U, 24},
	{3449858816U, 24},
	{3438673664U, 24},
	{3410903808U, 24},
	{3394126336U, 24},
	{3359192832U, 24},
	{3331560192U, 24},
	{3290110208U, 24},
	{3228330496U, 24},
	{2859204608U, 16},
	{2573139968U, 16},
	{3639929600U, 24},
	{3635457792U, 24},
	{3626579456U, 24},
	{3448936448U, 24},
	{3395179264U, 24},
	{3266360576U, 24},
	{3229383424U, 24},
	{2859335168U, 24},
	{2859333632U, 24},
	{2859270144U, 16},
	{2859282432U, 24},
	{2573074432U, 16},
	{3639864064U, 24},
	{3638753792U, 24},
	{3628617728U, 24},
	{3516236800U, 24},
	{3493801728U, 24},
	{3414462208U, 24},
	{3393733120U, 24},
	{3346758656U, 24},
	{3324913664U, 24},
	{3289122816U, 24},
	{3268530944U, 24},
	{3222014976U, 24},
	{3631899392U, 24},
	{3630920192U, 24},
	{3628683264U, 24},
	{3479921920U, 24},
	{3450317568U, 24},
	{3436240128U, 24},
	{3407615488U, 24},
	{3359520512U, 24},
	{3358533120U, 24},
	{3354588160U, 24},
	{3333861632U, 24},
	{3332874240U, 24},
	{3326692864U, 24},
	{3263530496U, 24},
	{3259582976U, 24},
	{3250700544U, 24},
	{3242805504U, 24},
	{3233923072U, 24},
	{3230962944U, 24},
	{3227015424U, 24},
	{3224317440U, 24},
	{2859139072U, 16},
	{2572681216U, 16},
	{3641578752U, 24},
	{3524140544U, 24},
	{3511310592U, 24},
	{3498480640U, 24},
	{3490585600U, 24},
	{3486768640U, 24},
	{3431368704U, 24},
	{3407812096U, 24},
	{3398934272U, 24},
	{3391890432U, 24},
	{3391035136U, 24},
	{3357480192U, 24},
	{3352548864U, 24},
	{3346627584U, 24},
	{3332677632U, 24},
	{3331822336U, 24},
	{3257674752U, 24},
	{2858942464U, 16},
	{2572877824U, 16},
	{3544931072U, 24},
	{3507428608U, 24},
	{3503472896U, 24},
	{3493605120U, 24},
	{3491630336U, 24},
	{3487689984U, 24},
	{3453148160U, 24},
	{3407746560U, 24},
	{3360374784U, 24},
	{3349520640U, 24},
	{3322874368U, 24},
	{3232081408U, 24},
	{3231094016U, 24},
	{3230106624U, 24},
	{3228133888U, 24},
	{3226159104U, 24},
	{2572812288U, 16},
	{3531044864U, 24},
	{3486309888U, 24},
	{3467294976U, 24},
	{3438214912U, 24},
	{3408016384U, 24},
	{3367742976U, 24},
	{3359920384U, 24},
	{3357685504U, 24},
	{3338672640U, 24},
	{2859925504U, 16},
	{3607169536U, 24},
	{3561311488U, 24},
	{3449325824U, 24},
	{3415772928U, 24},
	{3406825216U, 24},
	{3359985920U, 24},
	{3355370752U, 24},
	{3334119424U, 24},
	{3330904832U, 24},
	{3276102144U, 24},
	{3223535360U, 24},
	{2859859968U, 16},
	{2571468800U, 24},
	{2571468800U, 17},
	{2571469056U, 24},
	{2571436032U, 24},
	{2571436032U, 17},
	{2571436288U, 24},
	{2571436544U, 24},
	{2571436800U, 24},
	{3521106176U, 24},
	{3486440960U, 24},
	{3459325952U, 24},
	{3454860800U, 24},
	{3411493632U, 24},
	{3407021824U, 24},
	{3280639488U, 24},
	{3230307584U, 24},
	{3556569344U, 24},
	{3536831232U, 24},
	{3524402688U, 24},
	{3452951552U, 24},
	{3432679424U, 24},
	{3430180352U, 24},
	{3407950848U, 24},
	{3398147840U, 24},
	{3343343104U, 24},
	{3338462208U, 24},
	{3264906752U, 24},
	{3230373120U, 24},
	{3228854784U, 24},
	{3226880000U, 24},
	{3659932928U, 24},
	{3635326720U, 24},
	{3521831424U, 24},
	{3451890432U, 24},
	{3413336320U, 24},
	{3409388800U, 24},
	{3398213376U, 24},
	{3338934784U, 24},
	{3254510336U, 24},
	{3253400064U, 24},
	{3237732864U, 24},
	{2859712512U, 18},
	{2859696128U, 19},
	{2859708416U, 20},
	{2859704320U, 20},
	{2859663360U, 17},
	{3644932096U, 24},
	{3637102848U, 24},
	{3631378944U, 24},
	{3585057280U, 24},
	{3529730304U, 24},
	{3506768896U, 24},
	{3499922432U, 24},
	{3489328384U, 24},
	{3483142912U, 24},
	{3432810496U, 24},
	{3405441024U, 24},
	{3351159040U, 24},
	{3334381568U, 24},
	{3328408832U, 24},
	{3232741120U, 24},
	{3231482880U, 24},
	{3222539264U, 24},
	{3221560576U, 24},
	{3555254272U, 24},
	{3483339520U, 24},
	{3443676160U, 24},
	{3407283968U, 24},
	{3355841792U, 24},
	{3349119744U, 24},
	{3335182080U, 24},
	{3222735872U, 24},
	{3627300352U, 24},
	{3505975808U, 24},
	{3473347072U, 24},
	{3461498368U, 24},
	{3434916352U, 24},
	{3422087424U, 24},
	{3417160704U, 24},
	{3407218432U, 24},
	{3391436032U, 24},
	{3357882112U, 24},
	{3350048768U, 24},
	{3333271808U, 24},
	{2859466752U, 16},
	{3633421312U, 24},
	{3520450816U, 24},
	{3481232640U, 24},
	{3478996736U, 24},
	{3475648512U, 24},
	{3455577856U, 24},
	{3435453696U, 24},
	{3426427392U, 24},
	{3420911616U, 24},
	{3418675712U, 24},
	{3415314176U, 24},
	{3397426944U, 24},
	{3397345280U, 24},
	{3342543104U, 24},
	{3325765632U, 24},
	{3253137920U, 24},
	{3226228992U, 24},
	{3637827584U, 24},
	{3628941568U, 24},
	{3517163008U, 24},
	{3397279744U, 24},
	{3282285568U, 24},
	{3253203456U, 24},
	{3249710848U, 24},
	{3234189568U, 24},
	{3228531456U, 24},
	{3225038336U, 24},
	{3633552384U, 24},
	{3519463424U, 24},
	{3410907648U, 24},
	{3406435840U, 24},
	{3392742400U, 24},
	{3365977856U, 24},
	{3332419840U, 24},
	{3287671040U, 24},
	{2860318720U, 16},
	{3520516352U, 24},
	{3510124288U, 24},
	{3453406464U, 24},
	{3432155136U, 24},
	{3430704640U, 24},
	{3409454336U, 24},
	{3395174912U, 24},
	{3392676864U, 24},
	{3333464064U, 24},
	{3287605504U, 24},
	{3275238656U, 24},
	{3257482496U, 24},
	{3245177344U, 24},
	{3516241152U, 24},
	{3501700608U, 24},
	{3460243456U, 24},
	{3445179648U, 24},
	{3426689536U, 24},
	{3414466048U, 24},
	{3407677184U, 24},
	{3406566912U, 24},
	{3394847232U, 24},
	{3390899712U, 24},
	{3361292288U, 24},
	{3346754816U, 24},
	{3222019328U, 24},
	{3631903232U, 24},
	{3630916352U, 24},
	{3512228096U, 24},
	{3508280576U, 24},
	{3479925760U, 24},
	{3468077056U, 24},
	{3457942016U, 24},
	{3406632448U, 24},
	{3397017600U, 24},
	{3394781696U, 24},
	{3390834176U, 24},
	{3290171392U, 24},
	{3242809344U, 24},
	{3228269312U, 24},
	{2860122112U, 16},
	{3639736832U, 24},
	{3522294528U, 24},
	{3519201280U, 24},
	{3510451968U, 24},
	{3492556544U, 24},
	{3458138624U, 24},
	{3407808256U, 24},
	{3406697984U, 24},
	{3389921024U, 24},
	{3361423360U, 24},
	{3359450624U, 24},
	{3357475840U, 24},
	{3352545024U, 24},
	{3331817984U, 24},
	{3262736384U, 24},
	{3257679104U, 24},
	{3255705344U, 24},
	{3224125184U, 24},
	{2860056576U, 16},
	{3659404800U, 24},
	{3557755136U, 24},
	{3507424256U, 24},
	{3491634176U, 24},
	{3482749696U, 24},
	{3411690240U, 24},
	{3360379136U, 24},
	{3349524480U, 24},
	{3226163456U, 24},
	{3520979456U, 24},
	{3443812096U, 24},
	{3434846464U, 24},
	{3408004864U, 24},
	{3406902272U, 24},
	{3405784320U, 24},
	{3359924736U, 24},
	{3344268288U, 24},
	{3330842624U, 24},
	{3323017472U, 24},
	{3261483520U, 24},
	{3227928576U, 24},
	{2856583168U, 16},
	{3574606336U, 24},
	{3560048896U, 24},
	{3491961856U, 24},
	{3489742336U, 24},
	{3486379264U, 24},
	{3425833216U, 24},
	{3393544192U, 24},
	{3359990272U, 24},
	{3358725376U, 24},
	{3341949440U, 24},
	{3324185088U, 24},
	{3231233792U, 24},
	{2856648704U, 16},
	{3638553344U, 24},
	{3634081536U, 24},
	{3542097664U, 24},
	{3512166912U, 24},
	{3433596928U, 24},
	{3325106944U, 24},
	{3280643328U, 24},
	{3250164736U, 24},
	{3240103168U, 24},
	{3235902208U, 24},
	{3225840128U, 24},
	{3224444160U, 24},
	{2856714240U, 16},
	{3633036800U, 24},
	{3547613696U, 24},
	{3506650880U, 24},
	{3501753600U, 24},
	{3473088768U, 24},
	{3463730944U, 24},
	{3427231232U, 24},
	{3413398016U, 24},
	{3360121344U, 24},
	{3333985024U, 24},
	{3234849280U, 24},
	{3230377472U, 24},
	{3228850432U, 24},
	{3226893056U, 24},
	{3223391232U, 24},
	{3642041856U, 24},
	{3629212416U, 24},
	{3523492864U, 24},
	{3515660032U, 24},
	{3489938944U, 24},
	{3484322560U, 24},
	{3413332480U, 24},
	{3400437248U, 24},
	{3398216704U, 24},
	{3335054336U, 24},
	{3258392320U, 24},
	{3226565376U, 24},
	{2856321024U, 16},
	{3640314112U, 24},
	{3636366592U, 24},
	{3513927680U, 24},
	{3432823552U, 24},
	{3407098880U, 24},
	{3405437696U, 24},
	{3350168320U, 24},
	{3343940608U, 24},
	{3339991040U, 24},
	{3337340416U, 24},
	{3284047360U, 24},
	{3271217920U, 24},
	{2856419584U, 24},
	{2856419328U, 24},
	{2856419328U, 21},
	{2856413696U, 24},
	{2856404992U, 21},
	{2856409088U, 24},
	{2856407040U, 21},
	{2856386560U, 16},
	{2574413824U, 21},
	{2574385152U, 16},
	{3555250944U, 24},
	{3486182656U, 24},
	{3451754496U, 24},
	{3438927104U, 24},
	{2856454656U, 24},
	{2856452096U, 16},
	{2856452352U, 24},
	{2856452608U, 24},
	{2856452864U, 24},
	{2856453632U, 24},
	{2574319616U, 16},
	{3629277952U, 24},
	{3520782848U, 24},
	{3505963264U, 24},
	{3490135552U, 24},
	{3453681152U, 24},
	{3438861568U, 24},
	{3431967232U, 24},
	{3287863808U, 24},
	{3251364608U, 24},
	{3250361344U, 24},
	{3628888576U, 24},
	{3564002304U, 24},
	{3523755008U, 24},
	{3490201088U, 24},
	{3484654080U, 24},
	{3479008256U, 24},
	{3449981184U, 24},
	{3448879616U, 24},
	{3435458048U, 24},
	{3418679552U, 24},
	{3415325696U, 24},
	{3410780416U, 24},
	{3400769280U, 24},
	{3342539264U, 24},
	{3333657344U, 24},
	{3255315456U, 24},
	{3254243328U, 24},
	{3253125376U, 24},
	{3229656576U, 24},
	{2857107456U, 16},
	{2857112576U, 24},
	{3631173632U, 24},
	{3510242304U, 24},
	{3469077504U, 24},
	{3466824192U, 24},
	{3428611840U, 24},
	{3407361024U, 24},
	{3356042752U, 24},
	{3354842624U, 24},
	{3253190912U, 24},
	{3236413440U, 24},
	{3227286272U, 24},
	{2857172992U, 16},
	{3642435072U, 24},
	{3526954752U, 24},
	{3520586240U, 24},
	{3512691200U, 24},
	{3493399808U, 24},
	{3471101440U, 24},
	{3409516032U, 24},
	{3407557632U, 24},
	{3406439680U, 24},
	{3399519744U, 24},
	{3397561344U, 24},
	{3354777088U, 24},
	{3338000128U, 24},
	{3333526272U, 24},
	{3287667200U, 24},
	{3252994304U, 24},
	{3231745024U, 24},
	{3635449088U, 24},
	{3629085184U, 24},
	{3560442112U, 24},
	{3526889216U, 24},
	{3484457472U, 24},
	{3431180800U, 24},
	{3430700288U, 24},
	{3429712896U, 24},
	{3409450496U, 24},
	{3358131200U, 24},
	{3354711552U, 24},
	{3350237696U, 24},
	{3334988800U, 24},
	{3324578304U, 24},
	{3287601664U, 24},
	{3259983872U, 24},
	{3232797952U, 24},
	{3230840576U, 24},
	{3227417344U, 24},
	{3638745088U, 24},
	{3629736704U, 24},
	{3628626432U, 24},
	{3468139264U, 24},
	{3448023808U, 24},
	{3358458880U, 24},
	{3289131520U, 24},
	{3237204224U, 24},
	{3630911488U, 24},
	{3535925248U, 24},
	{3469802752U, 24},
	{3455245312U, 24},
	{3406636288U, 24},
	{3356304896U, 24},
	{3350630912U, 24},
	{3337803520U, 24},
	{3331633408U, 24},
	{3330646016U, 24},
	{3326700544U, 24},
	{3289197056U, 24},
	{3277355008U, 24},
	{3272420608U, 24},
	{3233931776U, 24},
	{3528095744U, 24},
	{3500446720U, 24},
	{3473809664U, 24},
	{3466049792U, 24},
	{3434453248U, 24},
	{3427427840U, 24},
	{3407819776U, 24},
	{3406701824U, 24},
	{3397823488U, 24},
	{3391882752U, 24},
	{3361436416U, 24},
	{3357488896U, 24},
	{3349447424U, 24},
	{3346619904U, 24},
	{3345501952U, 24},
	{3337737984U, 24},
	{3229178112U, 24},
	{2857040896U, 24},
	{3453156864U, 24},
	{3428480768U, 24},
	{3411701760U, 24},
	{3399847424U, 24},
	{3358393344U, 24},
	{3333722880U, 24},
	{3324840448U, 24},
	{3232072704U, 24},
	{3229112576U, 24},
	{3489672960U, 24},
	{3474006272U, 24},
	{3465066752U, 24},
	{3434842112U, 24},
	{3408008704U, 24},
	{3406898432U, 24},
	{3323013120U, 24},
	{3231294976U, 24},
	{2857697280U, 16},
	{2573598720U, 16},
	{3695535872U, 24},
	{3560052736U, 24},
	{3526499840U, 24},
	{3519930880U, 24},
	{3518665984U, 24},
	{3491958016U, 24},
	{3467352832U, 24},
	{3449334528U, 24},
	{3446100992U, 24},
	{3358721024U, 24},
	{3355363072U, 24},
	{3223526656U, 24},
	{2573664256U, 16},
	{3641915136U, 24},
	{3637439232U, 24},
	{3589063680U, 24},
	{3509656832U, 24},
	{3499865600U, 24},
	{3448420864U, 24},
	{3423805952U, 24},
	{3411501312U, 24},
	{3330978048U, 24},
	{3325102592U, 24},
	{3240107008U, 24},
	{3235897856U, 24},
	{3234788096U, 24},
	{3224439808U, 24},
	{2573467648U, 16},
	{3633032960U, 24},
	{3459252736U, 24},
	{3454917632U, 24},
	{3450443776U, 24},
	{3357611264U, 24},
	{3343350784U, 24},
	{3230381824U, 24},
	{3226888704U, 24},
	{3222416896U, 24},
	{2857762816U, 16},
	{3642046208U, 24},
	{3635318016U, 24},
	{3631435776U, 24},
	{3506163712U, 24},
	{3474268416U, 24},
	{3469278464U, 24},
	{3461440512U, 24},
	{3417218560U, 24},
	{3412218368U, 24},
	{3407160576U, 24},
	{3394330624U, 24},
	{3288611584U, 24},
	{3274055168U, 24},
	{3245558016U, 24},
	{2573369344U, 24},
	{2573336576U, 24},
	{3640317952U, 24},
	{3513932032U, 24},
	{3488341504U, 24},
	{3467614976U, 24},
	{3453546240U, 24},
	{3418263296U, 24},
	{3392538112U, 24},
	{3358983168U, 24},
	{3343936768U, 24},
	{3333395200U, 24},
	{3284043520U, 24},
	{3247289856U, 24},
	{3233711104U, 24},
	{3231491584U, 24},
	{3221569280U, 24},
	{3555246592U, 24},
	{3451750656U, 24},
	{3443684864U, 24},
	{3400310528U, 24},
	{3394461696U, 24},
	{3393351936U, 24},
	{3359798016U, 24},
	{3356960256U, 24},
	{3355035392U, 24},
	{3349127424U, 24},
	{3337148160U, 24},
	{3275034368U, 24},
	{3256298496U, 24},
	{3233645568U, 24},
	{3227539712U, 24},
	{3226692096U, 24},
	{2573269248U, 24},
	{2573268992U, 24},
	{2573269760U, 24},
	{2573269504U, 24},
	{2573270016U, 23},
	{2573270528U, 24},
	{2573267200U, 24},
	{2573266944U, 24},
	{2573267712U, 24},
	{2573267456U, 24},
	{2573264896U, 23},
	{2573265664U, 24},
	{2573265408U, 24},
	{2573265920U, 22},
	{2573262848U, 23},
	{2573263616U, 24},
	{2573263360U, 24},
	{2573264128U, 24},
	{2573263872U, 24},
	{2573264384U, 24},
	{2573260800U, 22},
	{2573261312U, 24},
	{2573261824U, 22},
	{2573258752U, 23},
	{2573259264U, 23},
	{2573259776U, 22},
	{2573256704U, 23},
	{2573257472U, 24},
	{2573257216U, 24},
	{2573257728U, 23},
	{2573258496U, 24},
	{2573258240U, 24},
	{2573254656U, 22},
	{2573255680U, 23},
	{2573256192U, 23},
	{2573252864U, 24},
	{2573252608U, 24},
	{2573253120U, 23},
	{2573253632U, 22},
	{2573250560U, 22},
	{2573251840U, 24},
	{2573251584U, 24},
	{2573252096U, 23},
	{2573248512U, 21},
	{2573246464U, 22},
	{2573246976U, 23},
	{2573247488U, 23},
	{2573247488U, 22},
	{2573248000U, 23},
	{2573244416U, 22},
	{2573245440U, 23},
	{2573246208U, 24},
	{2573245952U, 24},
	{2573242368U, 23},
	{2573242880U, 23},
	{2573243648U, 24},
	{2573243392U, 24},
	{2573244160U, 24},
	{2573243904U, 24},
	{2573240320U, 22},
	{2573242112U, 24},
	{2573241856U, 23},
	{2573238272U, 22},
	{2573239552U, 24},
	{2573239296U, 24},
	{2573240064U, 24},
	{2573239808U, 24},
	{2573236224U, 22},
	{2573237248U, 23},
	{2573237760U, 23},
	{2573234432U, 24},
	{2573234176U, 24},
	{2573234688U, 23},
	{2573235200U, 23},
	{2573235712U, 23},
	{2573232128U, 22},
	{2573233152U, 24},
	{2573233920U, 24},
	{2573233664U, 24},
	{2573230080U, 22},
	{2573231360U, 24},
	{2573231104U, 24},
	{2573231872U, 24},
	{2573231616U, 24},
	{2573228032U, 22},
	{2573229312U, 24},
	{2573229056U, 24},
	{2573229568U, 23},
	{2573225984U, 21},
	{2573223936U, 22},
	{2573224960U, 23},
	{2573225472U, 24},
	{2573221888U, 22},
	{2573223168U, 24},
	{2573222912U, 24},
	{2573223424U, 23},
	{2573219840U, 24},
	{2573220352U, 23},
	{2573221120U, 24},
	{2573220864U, 24},
	{2573221376U, 23},
	{2573217792U, 23},
	{2573218560U, 24},
	{2573218304U, 24},
	{2573219072U, 24},
	{2573218816U, 24},
	{2573219328U, 23},
	{2573215744U, 23},
	{2573216512U, 24},
	{2573216256U, 24},
	{2573217024U, 24},
	{2573216768U, 24},
	{2573217280U, 23},
	{2573213696U, 21},
	{2573211648U, 24},
	{2573212672U, 22},
	{2573209600U, 24},
	{2573210624U, 23},
	{2573211392U, 24},
	{2573211136U, 24},
	{2573207552U, 23},
	{2573208320U, 24},
	{2573208064U, 24},
	{2573208576U, 22},
	{2573205760U, 24},
	{2573206016U, 23},
	{2573206528U, 24},
	{2573207040U, 23},
	{3629281792U, 24},
	{3627291648U, 24},
	{3490131712U, 24},
	{3486252032U, 24},
	{3424981248U, 24},
	{3391428352U, 24},
	{3353990656U, 24},
	{3328270080U, 24},
	{3287859968U, 24},
	{3286880768U, 24},
	{2573320192U, 24},
	{2573287424U, 24},
	{3628884736U, 24},
	{3563998464U, 24},
	{3505901568U, 24},
	{3477894144U, 24},
	{3469016320U, 24},
	{3418683392U, 24},
	{3415321856U, 24},
	{3407422720U, 24},
	{3400764928U, 24},
	{3359310848U, 24},
	{3333652992U, 24},
	{3328011264U, 24},
	{3253129216U, 24},
	{3245234176U, 24},
	{2858257920U, 23},
	{2858221568U, 16},
	{2574123008U, 16},
	{3639068928U, 24},
	{3628950272U, 24},
	{3584262144U, 24},
	{3560577024U, 24},
	{3523816704U, 24},
	{3517154304U, 24},
	{3502629632U, 24},
	{3459908096U, 24},
	{3428607488U, 24},
	{3358266624U, 24},
	{3357025792U, 24},
	{3356047104U, 24},
	{3335840768U, 24},
	{3332608768U, 24},
	{3249702144U, 24},
	{3245299712U, 24},
	{3234198272U, 24},
	{3228522752U, 24},
	{3227281920U, 24},
	{2858156032U, 16},
	{2574188544U, 16},
	{3642439424U, 24},
	{3638872320U, 24},
	{3520590592U, 24},
	{3431119616U, 24},
	{3409512192U, 24},
	{3398675456U, 24},
	{3354773248U, 24},
	{3245103104U, 24},
	{3241741568U, 24},
	{2573991936U, 24},
	{3629081344U, 24},
	{3526893056U, 24},
	{3430695936U, 24},
	{3409446656U, 24},
	{3407488256U, 24},
	{3322624256U, 24},
	{3287597824U, 24},
	{3259988224U, 24},
	{3245168640U, 24},
	{3228391680U, 24},
	{2858287104U, 16},
	{2574057472U, 16},
	{3516249856U, 24},
	{3468134912U, 24},
	{3456905472U, 24},
	{3407684864U, 24},
	{3397075456U, 24},
	{3237199872U, 24},
	{2857959424U, 16},
	{2573860864U, 16},
	{3632639744U, 24},
	{3631894528U, 24},
	{3530246912U, 24},
	{3509521408U, 24},
	{3469798400U, 24},
	{3429586176U, 24},
	{3419465984U, 24},
	{3407619328U, 24},
	{3399982848U, 24},
	{3333849600U, 24},
	{3326704896U, 24},
	{3325954560U, 24},
	{3324975872U, 24},
	{3230967296U, 24},
	{3224313088U, 24},
	{2857925632U, 24},
	{2573926400U, 16},
	{3524144384U, 24},
	{3509324800U, 24},
	{3488730880U, 24},
	{3484781312U, 24},
	{3470843648U, 24},
	{3432491520U, 24},
	{3425440000U, 24},
	{3412611584U, 24},
	{3394985984U, 24},
	{3361432064U, 24},
	{3359441920U, 24},
	{3357484544U, 24},
	{3224116480U, 24},
	{2858139648U, 18},
	{2858123264U, 18},
	{2858090496U, 17},
	{2573729792U, 16},
	{3531102720U, 24},
	{3515328000U, 24},
	{3507432960U, 24},
	{3498551040U, 24},
	{3493600256U, 24},
	{3437354240U, 24},
	{3428476416U, 24},
	{3411697920U, 24},
	{3349516800U, 24},
	{3276503040U, 24},
	{3234067200U, 24},
	{2573795328U, 16},
	{3636163328U, 24},
	{3632807936U, 24},
	{3465041408U, 24},
	{3434833664U, 24},
	{3427047424U, 24},
	{3424845312U, 24},
	{3423718656U, 24},
	{3408066816U, 24},
	{3406940672U, 24},
	{3392399616U, 24},
	{3325289728U, 24},
	{3323053824U, 24},
	{3264826112U, 24},
	{3261510656U, 24},
	{3225719808U, 24},
	{2559049728U, 16},
	{2308505600U, 16},
	{268435456U, 12},
	{268435456U, 8},
	{276987904U, 22},
	{268828672U, 15},
	{268959744U, 15},
	{269352960U, 15},
	{272760832U, 18},
	{273416192U, 19},
	{276955136U, 19},
	{276972288U, 24},
	{3639551488U, 24},
	{3583532032U, 24},
	{3582545152U, 24},
	{3514217984U, 24},
	{3513231104U, 24},
	{3506323200U, 24},
	{3449308160U, 24},
	{3406875136U, 24},
	{3405896448U, 24},
	{3394539264U, 24},
	{3360005120U, 24},
	{3344204288U, 24},
	{3338786560U, 24},
	{3328684032U, 24},
	{3228022272U, 24},
	{2559115264U, 16},
	{3634057472U, 24},
	{3556588544U, 24},
	{3516618752U, 24},
	{3500698112U, 24},
	{3483923712U, 24},
	{3476155392U, 24},
	{3433592320U, 24},
	{3411512832U, 24},
	{3405961984U, 24},
	{3338852096U, 24},
	{3337369600U, 24},
	{3325158656U, 24},
	{3234733056U, 24},
	{3230291968U, 24},
	{3224494848U, 24},
	{3222520064U, 24},
	{2559180800U, 16},
	{2308636672U, 16},
	{3634979328U, 24},
	{3631529728U, 24},
	{3543199744U, 24},
	{3524449024U, 24},
	{3500763648U, 24},
	{3492868864U, 24},
	{3459312896U, 24},
	{3432662272U, 24},
	{3411447296U, 24},
	{3408001280U, 24},
	{3399107328U, 24},
	{3398128128U, 24},
	{3393691136U, 24},
	{3350752256U, 24},
	{3340891392U, 24},
	{3225916416U, 24},
	{3224429312U, 24},
	{2308571136U, 16},
	{3631464192U, 24},
	{3484316928U, 24},
	{3433985536U, 24},
	{3407202816U, 24},
	{2559311872U, 16},
	{2308767744U, 16},
	{3650899968U, 24},
	{3506061056U, 24},
	{3480397824U, 24},
	{3469283840U, 24},
	{3463620864U, 24},
	{3461384960U, 24},
	{3454743296U, 24},
	{3351845632U, 24},
	{3337304064U, 24},
	{3327165184U, 24},
	{3221606400U, 24},
	{2559382784U, 24},
	{2559383040U, 24},
	{2559385344U, 24},
	{2559378688U, 24},
	{2559378432U, 24},
	{2559378944U, 24},
	{2559377408U, 16},
	{2559379968U, 24},
	{2559389696U, 24},
	{2559385600U, 24},
	{2559388928U, 24},
	{2559388672U, 24},
	{2559389440U, 24},
	{2559389184U, 24},
	{2559399680U, 24},
	{2559397888U, 24},
	{2559400960U, 24},
	{2559400704U, 24},
	{2559396864U, 24},
	{2559397632U, 24},
	{2559409408U, 24},
	{2559409152U, 24},
	{2559409920U, 24},
	{2559409664U, 24},
	{2559408384U, 24},
	{2559408128U, 24},
	{2559408640U, 24},
	{2559402240U, 24},
	{2559401984U, 24},
	{2559402752U, 24},
	{2559402496U, 24},
	{2559415808U, 24},
	{2559414528U, 24},
	{2559410176U, 24},
	{2559413248U, 24},
	{2559414016U, 24},
	{2559413760U, 24},
	{2559412224U, 24},
	{2559422464U, 24},
	{2559426048U, 24},
	{2559419648U, 24},
	{2559419904U, 24},
	{2559418624U, 24},
	{2559419136U, 24},
	{2559421440U, 24},
	{2559421952U, 24},
	{2559420672U, 24},
	{2559433984U, 24},
	{2559434496U, 24},
	{2559439872U, 24},
	{2559440640U, 24},
	{2559440384U, 24},
	{2559439104U, 24},
	{2559439616U, 24},
	{2559439360U, 24},
	{2559442432U, 24},
	{2559441152U, 24},
	{2559435776U, 24},
	{2559436544U, 24},
	{2559435008U, 24},
	{2559434752U, 24},
	{2559435520U, 24},
	{2559435264U, 24},
	{2559436800U, 24},
	{3637117952U, 24},
	{3634319616U, 24},
	{3529548800U, 24},
	{3449766912U, 24},
	{3405325568U, 24},
	{3288781824U, 24},
	{3237555968U, 24},
	{3223646720U, 24},
	{3222782208U, 24},
	{2559442944U, 16},
	{2308898816U, 16},
	{3634254080U, 24},
	{3627350784U, 24},
	{3499051008U, 24},
	{3475373312U, 24},
	{3426021120U, 24},
	{3407268352U, 24},
	{3389512192U, 24},
	{3250350592U, 24},
	{3233573632U, 24},
	{2308833280U, 16},
	{3633402112U, 24},
	{3632283648U, 24},
	{3624454144U, 24},
	{3414184704U, 24},
	{3406355200U, 24},
	{3323578112U, 24},
	{2307981312U, 16},
	{2307995904U, 24},
	{2307995136U, 24},
	{2307995392U, 24},
	{3634586112U, 24},
	{3505798912U, 24},
	{3478948352U, 24},
	{3459968256U, 24},
	{3450042112U, 24},
	{3448783872U, 24},
	{3418691328U, 24},
	{3399708672U, 24},
	{3398451968U, 24},
	{3391879168U, 24},
	{3359304448U, 24},
	{3356088320U, 24},
	{3354798080U, 24},
	{3352562176U, 24},
	{3335785216U, 24},
	{3332602880U, 24},
	{3287690240U, 24},
	{3275415552U, 24},
	{3253157632U, 24},
	{3225084672U, 24},
	{2307915776U, 16},
	{3641362688U, 24},
	{3630144768U, 24},
	{3584061184U, 24},
	{3493458688U, 24},
	{3464648192U, 24},
	{3395260160U, 24},
	{3361705216U, 24},
	{3339376384U, 24},
	{3337955584U, 24},
	{3245127424U, 24},
	{3231742464U, 24},
	{3230877952U, 24},
	{2558656768U, 24},
	{2308112384U, 16},
	{3520470016U, 24},
	{3416355072U, 24},
	{3413945344U, 24},
	{3406551808U, 24},
	{3397168384U, 24},
	{3392727296U, 24},
	{3359173376U, 24},
	{3289109504U, 24},
	{3258507520U, 24},
	{2558751232U, 24},
	{2558750720U, 23},
	{2558748672U, 24},
	{2558750208U, 23},
	{2558747648U, 22},
	{2308046848U, 16},
	{3628633088U, 24},
	{3625834752U, 24},
	{3561521152U, 24},
	{3511190784U, 24},
	{3450238720U, 24},
	{3434571520U, 24},
	{3424505088U, 24},
	{3398779648U, 24},
	{3389839872U, 24},
	{3344531968U, 24},
	{3327755008U, 24},
	{3264563968U, 24},
	{3252829952U, 24},
	{2308243456U, 16},
	{3641559296U, 24},
	{3564811008U, 24},
	{3517410048U, 24},
	{3505536768U, 24},
	{3493786368U, 24},
	{3492798976U, 24},
	{3481622272U, 24},
	{3469738752U, 24},
	{3463165952U, 24},
	{3457994496U, 24},
	{3450304256U, 24},
	{3418429184U, 24},
	{3411578368U, 24},
	{3394801408U, 24},
	{3356350464U, 24},
	{3285192192U, 24},
	{3270651136U, 24},
	{3224367616U, 24},
	{2308177920U, 16},
	{3579547648U, 24},
	{3512439808U, 24},
	{3492602368U, 24},
	{3486712320U, 24},
	{3451217408U, 24},
	{3431355392U, 24},
	{3411774976U, 24},
	{3393054976U, 24},
	{3357526272U, 24},
	{3346636800U, 24},
	{3332668416U, 24},
	{3268611840U, 24},
	{3257724928U, 24},
	{3237031680U, 24},
	{3224171008U, 24},
	{2558918656U, 16},
	{2308374528U, 16},
	{3645607168U, 24},
	{3636659200U, 24},
	{3633729792U, 24},
	{3584388864U, 24},
	{3500501504U, 24},
	{3449177088U, 24},
	{3407792640U, 24},
	{3403756544U, 24},
	{3392010240U, 24},
	{3357460736U, 24},
	{3342656512U, 24},
	{3250789632U, 24},
	{3232070144U, 24},
	{2558984192U, 16},
	{2559016960U, 19},
	{2559025152U, 19},
	{2559033344U, 19},
	{2559041536U, 19},
	{2308308992U, 16},
	{3509838592U, 24},
	{3439276544U, 24},
	{3438158592U, 24},
	{3424841472U, 24},
	{3423722496U, 24},
	{3421381632U, 24},
	{3393490688U, 24},
	{3359935744U, 24},
	{3328614656U, 24},
	{3325293568U, 24},
	{3323057664U, 24},
	{3227952896U, 24},
	{3639555840U, 24},
	{3589224960U, 24},
	{3583528192U, 24},
	{3515439104U, 24},
	{3503103232U, 24},
	{3328680192U, 24},
	{3326444288U, 24},
	{3258118144U, 24},
	{2560098304U, 16},
	{3634053120U, 24},
	{3454804480U, 24},
	{3433588480U, 24},
	{3411517184U, 24},
	{3394739712U, 24},
	{3350822144U, 24},
	{3336509952U, 24},
	{3247065088U, 24},
	{3244598784U, 24},
	{2560300544U, 24},
	{2307522560U, 16},
	{3634983680U, 24},
	{3631525376U, 24},
	{3629550592U, 24},
	{3520990464U, 24},
	{3459316736U, 24},
	{3454870016U, 24},
	{3437105152U, 24},
	{3432666112U, 24},
	{3400098048U, 24},
	{3393687296U, 24},
	{3331018496U, 24},
	{3234794752U, 24},
	{3224433152U, 24},
	{2307588096U, 16},
	{3630350080U, 24},
	{3625306112U, 24},
	{3554217728U, 24},
	{3505012480U, 24},
	{3484312576U, 24},
	{3449640192U, 24},
	{3433981696U, 24},
	{3333319936U, 24},
	{2560425984U, 16},
	{2560442368U, 20},
	{2307653632U, 16},
	{3650896128U, 24},
	{3630415616U, 24},
	{3627477504U, 24},
	{3519618048U, 24},
	{3461388800U, 24},
	{3398255360U, 24},
	{3360726016U, 24},
	{3327169024U, 24},
	{3258380288U, 24},
	{3231471616U, 24},
	{3224826368U, 24},
	{2560360448U, 16},
	{2307719168U, 16},
	{3638232064U, 24},
	{3479218176U, 24},
	{3449771264U, 24},
	{3431875840U, 24},
	{3419014656U, 24},
	{3407338240U, 24},
	{3368682752U, 24},
	{3358980608U, 24},
	{3334306816U, 24},
	{3328221440U, 24},
	{3327365632U, 24},
	{3235585024U, 24},
	{3231668224U, 24},
	{3222786048U, 24},
	{2307784704U, 16},
	{3695417600U, 24},
	{3634249728U, 24},
	{3559257856U, 24},
	{3526680576U, 24},
	{3507929344U, 24},
	{3454607872U, 24},
	{3437830912U, 24},
	{3335195392U, 24},
	{3250354944U, 24},
	{2560491520U, 16},
	{2560532480U, 19},
	{2560540672U, 18},
	{2307850240U, 16},
	{3638966016U, 24},
	{3633397760U, 24},
	{3624458496U, 24},
	{3545011712U, 24},
	{3520400640U, 24},
	{3512567040U, 24},
	{3351513600U, 24},
	{3263187712U, 24},
	{3263149056U, 24},
	{3253087744U, 24},
	{2879549440U, 24},
	{2879557632U, 24},
	{2879574016U, 24},
	{2879582208U, 24},
	{2306867200U, 16},
	{3631202048U, 24},
	{3628965120U, 24},
	{3499116544U, 24},
	{3413093376U, 24},
	{3398455808U, 24},
	{3392862208U, 24},
	{3356084480U, 24},
	{3345981440U, 24},
	{3335789056U, 24},
	{3245319680U, 24},
	{3224101632U, 24},
	{2559574016U, 16},
	{2559604992U, 24},
	{2559606784U, 24},
	{2559608064U, 24},
	{2306932736U, 16},
	{3641366528U, 24},
	{3639944704U, 24},
	{3520531712U, 24},
	{3511587840U, 24},
	{3499313152U, 24},
	{3488952576U, 24},
	{3395264000U, 24},
	{3357267968U, 24},
	{3283187968U, 24},
	{3246241536U, 24},
	{3245123072U, 24},
	{3683795712U, 24},
	{3641432064U, 24},
	{3471122688U, 24},
	{3459841024U, 24},
	{3412962304U, 24},
	{3409508608U, 24},
	{3407534848U, 24},
	{3392731136U, 24},
	{3289105664U, 24},
	{3287563520U, 24},
	{3255550720U, 24},
	{3240747520U, 24},
	{3232791040U, 24},
	{3223970560U, 24},
	{2879455232U, 16},
	{2879467520U, 20},
	{2879479808U, 20},
	{2879483904U, 20},
	{2879500032U, 24},
	{2879496192U, 20},
	{2879500288U, 20},
	{2879512576U, 20},
	{2879516672U, 20},
	{2307063808U, 16},
	{3632550144U, 24},
	{3576624640U, 24},
	{3561525504U, 24},
	{3520138496U, 24},
	{3511194624U, 24},
	{3503361024U, 24},
	{3491610624U, 24},
	{3484906752U, 24},
	{3460299776U, 24},
	{3453030656U, 24},
	{3411648256U, 24},
	{3407731456U, 24},
	{3344536320U, 24},
	{3340621568U, 24},
	{3327758848U, 24},
	{3252825600U, 24},
	{3236048640U, 24},
	{2559901696U, 16},
	{2307129344U, 16},
	{3639748096U, 24},
	{3631918592U, 24},
	{3564806656U, 24},
	{3563827968U, 24},
	{3521330688U, 24},
	{3499378688U, 24},
	{3468063744U, 24},
	{3426680320U, 24},
	{3407665920U, 24},
	{3397731072U, 24},
	{3394805248U, 24},
	{3356346624U, 24},
	{3352304384U, 24},
	{3344470784U, 24},
	{3337762816U, 24},
	{3330625280U, 24},
	{3326706432U, 24},
	{3274694656U, 24},
	{3270654976U, 24},
	{3252891136U, 24},
	{3249961728U, 24},
	{3234864128U, 24},
	{3229960448U, 24},
	{3229267456U, 24},
	{2559836160U, 16},
	{2307227648U, 16},
	{3637707776U, 24},
	{3629878272U, 24},
	{3511325696U, 24},
	{3431351552U, 24},
	{3407862528U, 24},
	{3399770368U, 24},
	{3393058816U, 24},
	{2307261440U, 22},
	{2307260416U, 16},
	{2307264512U, 22},
	{2307272448U, 24},
	{2307306496U, 24},
	{2307317760U, 22},
	{2307321856U, 22},
	{3633725440U, 24},
	{3627870720U, 24},
	{3584392704U, 24},
	{3536981504U, 24},
	{3514345216U, 24},
	{3498531072U, 24},
	{3491676160U, 24},
	{3463031040U, 24},
	{3407796992U, 24},
	{3360394496U, 24},
	{3357464576U, 24},
	{3234008320U, 24},
	{3231078400U, 24},
	{3223244800U, 24},
	{3641833984U, 24},
	{3638376192U, 24},
	{3635036160U, 24},
	{3632816640U, 24},
	{3531052800U, 24},
	{3506380032U, 24},
	{3489718784U, 24},
	{3448272640U, 24},
	{3438153728U, 24},
	{3361058560U, 24},
	{3359948288U, 24},
	{3261502976U, 24},
	{3238064896U, 24},
	{3232389120U, 24},
	{3227948032U, 24},
	{2310733824U, 16},
	{3631652096U, 24},
	{3511989760U, 24},
	{3489530368U, 24},
	{3438219264U, 24},
	{3403425024U, 24},
	{3356551936U, 24},
	{3328676352U, 24},
	{3223572480U, 24},
	{2310668288U, 16},
	{3505130496U, 24},
	{3486396672U, 24},
	{3428297472U, 24},
	{3407079424U, 24},
	{3325150976U, 24},
	{3285073152U, 24},
	{3276190976U, 24},
	{3254586368U, 24},
	{3247078144U, 24},
	{3224486144U, 24},
	{3582684928U, 24},
	{3564409088U, 24},
	{3467204096U, 24},
	{3437110016U, 24},
	{3430189312U, 24},
	{3412434688U, 24},
	{3407013888U, 24},
	{3394678016U, 24},
	{3389257728U, 24},
	{3338925312U, 24},
	{3278214912U, 24},
	{3227882496U, 24},
	{3586665216U, 24},
	{3563225088U, 24},
	{3530790656U, 24},
	{3485419008U, 24},
	{3468642048U, 24},
	{3449644544U, 24},
	{3409431040U, 24},
	{3406100736U, 24},
	{3359099136U, 24},
	{3261240832U, 24},
	{3237678336U, 24},
	{3224879360U, 24},
	{3650908672U, 24},
	{3627473152U, 24},
	{3586022400U, 24},
	{3558143744U, 24},
	{3555397376U, 24},
	{3533469952U, 24},
	{3526808320U, 24},
	{3506052352U, 24},
	{3488289536U, 24},
	{3468576512U, 24},
	{3458719232U, 24},
	{3430058240U, 24},
	{3406166272U, 24},
	{3398266880U, 24},
	{3359033600U, 24},
	{3356814080U, 24},
	{3337296384U, 24},
	{3328414208U, 24},
	{3274167040U, 24},
	{3267250944U, 24},
	{3225531904U, 24},
	{3224813824U, 24},
	{2310930432U, 16},
	{3636285696U, 24},
	{3559179264U, 24},
	{3451732992U, 24},
	{3437760512U, 24},
	{3428882432U, 24},
	{3401401088U, 24},
	{3394481408U, 24},
	{3367846144U, 24},
	{3247340288U, 24},
	{3222790912U, 24},
	{2879336448U, 20},
	{2879333632U, 24},
	{2879332352U, 23},
	{2879324160U, 16},
	{2879352832U, 20},
	{2879340544U, 20},
	{2879344384U, 24},
	{2879369216U, 20},
	{2879361024U, 20},
	{2879356928U, 20},
	{2879385600U, 20},
	{2879373312U, 20},
	{2879377152U, 24},
	{2310864896U, 16},
	{3695421952U, 24},
	{3486200064U, 24},
	{3462502912U, 24},
	{3435868672U, 24},
	{3411192832U, 24},
	{3407276032U, 24},
	{3392457472U, 24},
	{3389519872U, 24},
	{3273056256U, 24},
	{3250341888U, 24},
	{2310799360U, 16},
	{3584183552U, 24},
	{3583081984U, 24},
	{3524915456U, 24},
	{3481242112U, 24},
	{3448858112U, 24},
	{3400745728U, 24},
	{3389585408U, 24},
	{3351525632U, 24},
	{3285527552U, 24},
	{3279914496U, 24},
	{3263137536U, 24},
	{3245249792U, 24},
	{3564077056U, 24},
	{3519360768U, 24},
	{3500361728U, 24},
	{3448792576U, 24},
	{3399700992U, 24},
	{3398459648U, 24},
	{3392850688U, 24},
	{3357076224U, 24},
	{3352569856U, 24},
	{3246488320U, 24},
	{3234151936U, 24},
	{3224096768U, 24},
	{2560819200U, 20},
	{2560819200U, 16},
	{3639940352U, 24},
	{3638821888U, 24},
	{3516942592U, 24},
	{3493449984U, 24},
	{3438608640U, 24},
	{3424382720U, 24},
	{3405055744U, 24},
	{3398656256U, 24},
	{3391674880U, 24},
	{3356162560U, 24},
	{3236174848U, 24},
	{3226383872U, 24},
	{2560622592U, 16},
	{3520478720U, 24},
	{3517995008U, 24},
	{3500230656U, 24},
	{3490439680U, 24},
	{3455320064U, 24},
	{3430713600U, 24},
	{3409496576U, 24},
	{3406559488U, 24},
	{3397611520U, 24},
	{3392719616U, 24},
	{3359164672U, 24},
	{3343888640U, 24},
	{3332464128U, 24},
	{3323651328U, 24},
	{3289118208U, 24},
	{3258499840U, 24},
	{3253996544U, 24},
	{3223965696U, 24},
	{3552587008U, 24},
	{3516234240U, 24},
	{3504475136U, 24},
	{3436258048U, 24},
	{3424513792U, 24},
	{3413872128U, 24},
	{3407734784U, 24},
	{3406625024U, 24},
	{3397095168U, 24},
	{3393178368U, 24},
	{3359623424U, 24},
	{3344539648U, 24},
	{3263461376U, 24},
	{3250601728U, 24},
	{3231017728U, 24},
	{3631914240U, 24},
	{3486523392U, 24},
	{3463158272U, 24},
	{3426667776U, 24},
	{3409889792U, 24},
	{3407669248U, 24},
	{3404859136U, 24},
	{3394809088U, 24},
	{3358578688U, 24},
	{3356359168U, 24},
	{3326717952U, 24},
	{3263526912U, 24},
	{3261830656U, 24},
	{3252886784U, 24},
	{3667357952U, 24},
	{3579556352U, 24},
	{3575641600U, 24},
	{3512448512U, 24},
	{3493712128U, 24},
	{3484763648U, 24},
	{3434431744U, 24},
	{3389978624U, 24},
	{3350547968U, 24},
	{3257717248U, 24},
	{3223315200U, 24},
	{2560884736U, 21},
	{2560884736U, 16},
	{3696933632U, 24},
	{3659462912U, 24},
	{3455057920U, 24},
	{3430451456U, 24},
	{3427514880U, 24},
	{3406821632U, 24},
	{3357469440U, 24},
	{3331747072U, 24},
	{3250798336U, 24},
	{3232061440U, 24},
	{3230104064U, 24},
	{2560950272U, 16},
	{3641830144U, 24},
	{3638371840U, 24},
	{3635040512U, 24},
	{3632820992U, 24},
	{3590260992U, 24},
	{3560162304U, 24},
	{3475164672U, 24},
	{3454926848U, 24},
	{3434828800U, 24},
	{3427052288U, 24},
	{3424832768U, 24},
	{3408054784U, 24},
	{3406952704U, 24},
	{3359944448U, 24},
	{3357722880U, 24},
	{3325285888U, 24},
	{3244721152U, 24},
	{3232385280U, 24},
	{2562408960U, 24},
	{2562409472U, 24},
	{2309619712U, 16},
	{587202560U, 8},
	{3631647744U, 24},
	{3490767360U, 24},
	{3488547328U, 24},
	{3476217600U, 24},
	{3405899776U, 24},
	{3356555776U, 24},
	{3254656256U, 24},
	{3237878784U, 24},
	{3236891904U, 24},
	{3223568640U, 24},
	{2562334720U, 22},
	{2562332672U, 24},
	{2562360320U, 22},
	{2562366720U, 24},
	{2562387712U, 24},
	{2562386944U, 23},
	{2562389760U, 24},
	{3512182528U, 24},
	{3489469184U, 24},
	{3483911680U, 24},
	{3450356736U, 24},
	{3431622400U, 24},
	{3423862272U, 24},
	{3416801792U, 24},
	{3407923712U, 24},
	{3335399680U, 24},
	{3247073792U, 24},
	{3224489984U, 24},
	{2562302976U, 23},
	{2562298624U, 24},
	{2562318848U, 23},
	{2562320384U, 22},
	{3637458688U, 24},
	{3564404736U, 24},
	{3524452352U, 24},
	{3467200256U, 24},
	{3422295808U, 24},
	{3389253888U, 24},
	{3259475200U, 24},
	{2562209280U, 23},
	{2562210304U, 23},
	{2562210816U, 24},
	{2562195456U, 24},
	{2562195968U, 24},
	{2562222336U, 24},
	{2562223104U, 23},
	{2562225408U, 24},
	{2562226688U, 23},
	{2562212864U, 23},
	{2309554176U, 16},
	{3563229440U, 24},
	{3483202816U, 24},
	{3480460032U, 24},
	{3462564608U, 24},
	{3433972992U, 24},
	{3398197504U, 24},
	{3355122432U, 24},
	{3237682176U, 24},
	{3226580480U, 24},
	{3224883200U, 24},
	{2562670848U, 24},
	{2309881856U, 16},
	{3650904832U, 24},
	{3627468800U, 24},
	{3558139392U, 24},
	{3555401216U, 24},
	{3506827776U, 24},
	{3506048000U, 24},
	{3462630144U, 24},
	{3458715392U, 24},
	{3431819008U, 24},
	{3407149312U, 24},
	{3337292544U, 24},
	{3251187200U, 24},
	{3237616640U, 24},
	{3224817664U, 24},
	{2562647296U, 24},
	{2562639872U, 24},
	{3695360768U, 24},
	{3638240768U, 24},
	{3480328960U, 24},
	{3357014528U, 24},
	{3342194432U, 24},
	{3328213760U, 24},
	{3327373312U, 24},
	{3227550976U, 24},
	{3222794752U, 24},
	{2562533888U, 23},
	{2562526208U, 22},
	{2562525440U, 24},
	{2562540544U, 23},
	{2562541056U, 23},
	{2562539520U, 23},
	{2562540032U, 23},
	{2562542592U, 23},
	{2562542336U, 24},
	{2309769728U, 24},
	{2309808128U, 19},
	{2309800192U, 24},
	{2309805056U, 24},
	{2309804800U, 24},
	{3627337728U, 24},
	{3519757824U, 24},
	{3504938240U, 24},
	{3486195712U, 24},
	{3452641792U, 24},
	{3413155584U, 24},
	{3407280384U, 24},
	{3406292992U, 24},
	{3398394112U, 24},
	{3389516032U, 24},
	{3358906368U, 24},
	{3273060608U, 24},
	{3244393472U, 24},
	{3225659136U, 24},
	{2562493952U, 24},
	{3520409344U, 24},
	{3514857984U, 24},
	{3477907456U, 24},
	{3434304512U, 24},
	{3407476992U, 24},
	{3395140608U, 24},
	{3264313344U, 24},
	{2561870848U, 23},
	{2561875200U, 24},
	{2561895936U, 24},
	{2561895424U, 23},
	{2561892864U, 24},
	{2561892352U, 23},
	{2561898496U, 24},
	{2561897728U, 24},
	{2561885696U, 23},
	{2561890304U, 23},
	{2561891840U, 23},
	{2561891584U, 24},
	{2561910784U, 23},
	{2561914880U, 23},
	{2561913088U, 24},
	{2561914368U, 24},
	{2561913856U, 23},
	{2561902592U, 24},
	{2561901312U, 24},
	{2561904896U, 24},
	{2561928192U, 22},
	{2561926400U, 24},
	{2561931264U, 23},
	{2561919488U, 23},
	{2561920512U, 24},
	{2561921024U, 22},
	{3628973824U, 24},
	{3564081408U, 24},
	{3523866880U, 24},
	{3484571392U, 24},
	{3466807040U, 24},
	{3457743872U, 24},
	{3398463488U, 24},
	{3356093184U, 24},
	{3326976256U, 24},
	{3241857280U, 24},
	{3226314496U, 24},
	{2309160960U, 16},
	{3638826240U, 24},
	{3521387520U, 24},
	{3493445632U, 24},
	{3485868032U, 24},
	{3474717952U, 24},
	{3434173440U, 24},
	{3426343936U, 24},
	{3409566464U, 24},
	{3398660096U, 24},
	{3397542144U, 24},
	{3354729216U, 24},
	{3333512704U, 24},
	{3289048832U, 24},
	{3263326464U, 24},
	{3231729920U, 24},
	{2561746432U, 23},
	{2561751808U, 24},
	{2561743360U, 23},
	{2561743872U, 23},
	{2561763328U, 23},
	{2561763840U, 23},
	{2561764352U, 23},
	{2561764864U, 23},
	{2561755136U, 23},
	{2561755648U, 23},
	{2561756160U, 23},
	{2561753088U, 23},
	{2561753600U, 23},
	{2561754112U, 23},
	{2561754624U, 23},
	{2561784576U, 24},
	{2561796096U, 22},
	{2561795328U, 24},
	{2561786624U, 24},
	{2561787136U, 24},
	{2561787392U, 23},
	{2561790976U, 23},
	{2308964352U, 16},
	{3560489984U, 24},
	{3417330432U, 24},
	{3413942016U, 24},
	{3409500928U, 24},
	{3407542528U, 24},
	{3406555136U, 24},
	{3392723456U, 24},
	{3358181632U, 24},
	{3353676288U, 24},
	{3341403648U, 24},
	{3339445248U, 24},
	{3259999488U, 24},
	{3255558400U, 24},
	{3241726208U, 24},
	{3237223424U, 24},
	{3222004480U, 24},
	{2561679360U, 23},
	{2561679872U, 23},
	{2561680384U, 23},
	{2561680896U, 23},
	{2561678848U, 23},
	{2561676032U, 24},
	{2561698816U, 23},
	{2561701888U, 23},
	{2561702400U, 23},
	{2561702912U, 23},
	{2561700864U, 23},
	{2561701376U, 23},
	{2561689600U, 23},
	{2561690112U, 23},
	{2561690624U, 23},
	{2561691136U, 23},
	{2561687808U, 24},
	{2561688576U, 23},
	{2561689088U, 23},
	{2561694464U, 24},
	{2561691648U, 23},
	{2561692160U, 23},
	{2561692672U, 23},
	{2561693440U, 24},
	{2561714176U, 22},
	{2561718272U, 23},
	{2561718784U, 23},
	{2561719296U, 23},
	{2561719808U, 24},
	{2561717760U, 23},
	{2561720320U, 23},
	{2561721344U, 22},
	{2309029888U, 16},
	{3519036928U, 24},
	{3481560064U, 24},
	{3434566656U, 24},
	{3409959680U, 24},
	{3407739136U, 24},
	{3406620672U, 24},
	{3397099008U, 24},
	{3395981056U, 24},
	{3393182208U, 24},
	{3389843712U, 24},
	{3344544000U, 24},
	{3341731328U, 24},
	{3337820672U, 24},
	{3250597376U, 24},
	{3242763776U, 24},
	{2562138112U, 23},
	{2562137088U, 22},
	{2562154752U, 24},
	{2562152448U, 23},
	{2562178560U, 23},
	{2562186752U, 23},
	{2309357568U, 16},
	{3631909888U, 24},
	{3629690368U, 24},
	{3493773312U, 24},
	{3479931392U, 24},
	{3394812928U, 24},
	{3390896128U, 24},
	{3356355328U, 24},
	{3344478464U, 24},
	{3326714112U, 24},
	{3274686976U, 24},
	{3230956032U, 24},
	{2562080256U, 24},
	{2562080512U, 24},
	{2562078208U, 23},
	{2562081024U, 24},
	{2562087424U, 24},
	{2562106368U, 24},
	{2562109440U, 24},
	{2562098944U, 24},
	{2562104832U, 23},
	{2562123776U, 23},
	{2562125824U, 22},
	{3579552512U, 24},
	{3562775040U, 24},
	{3455127808U, 24},
	{3435275008U, 24},
	{3432478208U, 24},
	{3431360256U, 24},
	{3393891584U, 24},
	{3360337664U, 24},
	{3356420864U, 24},
	{3343556608U, 24},
	{2562024192U, 24},
	{2562018304U, 22},
	{2562019840U, 23},
	{2562043392U, 23},
	{2309229824U, 24},
	{2309226496U, 16},
	{3501475840U, 24},
	{3451147520U, 24},
	{3407804672U, 24},
	{3357473280U, 24},
	{3262682624U, 24},
	{3246877184U, 24},
	{3232057600U, 24},
	{2309293056U, 23},
	{2309292032U, 16},
	{3635029504U, 24},
	{3632792576U, 24},
	{3627269888U, 24},
	{3556802560U, 24},
	{3458381824U, 24},
	{3361065216U, 24},
	{3358830336U, 24},
	{3357720064U, 24},
	{3355483136U, 24},
	{3349821696U, 24},
	{3328635904U, 24},
	{3277177344U, 24},
	{3276067584U, 24},
	{3261526016U, 24},
	{3252504576U, 24},
	{3639566848U, 24},
	{3564566272U, 24},
	{3498642432U, 24},
	{3449290752U, 24},
	{3443907840U, 24},
	{3427130368U, 24},
	{3360020480U, 24},
	{3358764800U, 24},
	{2312896512U, 16},
	{3581277696U, 24},
	{3521075200U, 24},
	{3500682752U, 24},
	{3499826432U, 24},
	{3479502080U, 24},
	{3433574912U, 24},
	{3428306176U, 24},
	{3423832320U, 24},
	{3407920384U, 24},
	{3407056384U, 24},
	{3405946624U, 24},
	{3399157504U, 24},
	{3325141248U, 24},
	{3268303360U, 24},
	{3228951296U, 24},
	{3224479488U, 24},
	{3651741440U, 24},
	{3481998080U, 24},
	{3470673664U, 24},
	{3428240640U, 24},
	{3389234688U, 24},
	{3357654528U, 24},
	{3288567808U, 24},
	{3278237952U, 24},
	{3263897088U, 24},
	{3261460480U, 24},
	{3230342144U, 24},
	{2313027584U, 16},
	{3635291648U, 24},
	{3456408064U, 24},
	{3411134976U, 24},
	{3409423360U, 24},
	{3407187456U, 24},
	{3392646400U, 24},
	{3355745280U, 24},
	{3351797504U, 24},
	{3327248128U, 24},
	{3261263872U, 24},
	{2312699904U, 16},
	{3627466496U, 24},
	{3586013696U, 24},
	{3557130240U, 24},
	{3454760704U, 24},
	{3437983232U, 24},
	{3333371904U, 24},
	{3328439296U, 24},
	{3255145984U, 24},
	{3235399936U, 24},
	{3231452416U, 24},
	{3221591040U, 24},
	{2312634368U, 16},
	{3683518208U, 24},
	{3624307712U, 24},
	{3588779776U, 24},
	{3586804992U, 24},
	{3485278208U, 24},
	{3465417216U, 24},
	{3434947328U, 24},
	{3407318528U, 24},
	{3351928576U, 24},
	{3328242688U, 24},
	{3284818688U, 24},
	{3244356352U, 24},
	{3239543808U, 24},
	{3233623808U, 24},
	{3222766848U, 24},
	{2312830976U, 16},
	{3634238720U, 24},
	{3633251328U, 24},
	{3588845312U, 24},
	{3586870528U, 24},
	{3489162240U, 24},
	{3466461952U, 24},
	{3453633536U, 24},
	{3406274304U, 24},
	{3358895872U, 24},
	{3323364096U, 24},
	{3289809152U, 24},
	{3273033216U, 24},
	{3233558272U, 24},
	{3564037632U, 24},
	{3475683584U, 24},
	{3456670208U, 24},
	{3448832000U, 24},
	{3432055040U, 24},
	{3414169344U, 24},
	{3407449600U, 24},
	{3397391872U, 24},
	{3341463808U, 24},
	{3263160576U, 24},
	{3224024576U, 24},
	{3222897920U, 24},
	{2312437760U, 16},
	{3642268672U, 24},
	{3634570752U, 24},
	{3524826880U, 24},
	{3523839488U, 24},
	{3426396928U, 24},
	{3419685376U, 24},
	{3392843008U, 24},
	{3359289088U, 24},
	{3352579584U, 24},
	{3333564672U, 24},
	{3238630656U, 24},
	{3236395520U, 24},
	{3234158592U, 24},
	{2312372224U, 16},
	{3632399360U, 24},
	{3631016448U, 24},
	{3520550912U, 24},
	{3509102336U, 24},
	{3463248896U, 24},
	{3449828096U, 24},
	{3263029504U, 24},
	{3241780736U, 24},
	{3231727104U, 24},
	{3230862592U, 24},
	{3523970560U, 24},
	{3512651776U, 24},
	{3418837760U, 24},
	{3413960704U, 24},
	{3411986944U, 24},
	{3407515136U, 24},
	{3406536448U, 24},
	{3359158016U, 24},
	{3333433600U, 24},
	{3289092096U, 24},
	{3266325760U, 24},
	{3258492160U, 24},
	{3249548800U, 24},
	{3237243648U, 24},
	{3639833344U, 24},
	{3628648448U, 24},
	{3576603392U, 24},
	{3522394624U, 24},
	{3393170688U, 24},
	{3361327360U, 24},
	{3357379840U, 24},
	{3353509120U, 24},
	{3252845312U, 24},
	{3250007552U, 24},
	{3230993664U, 24},
	{2562743296U, 22},
	{2562740224U, 22},
	{2562738176U, 22},
	{2562739200U, 24},
	{2562739712U, 23},
	{2562736128U, 21},
	{2562750464U, 24},
	{2562746368U, 22},
	{2562747392U, 23},
	{2562747904U, 23},
	{2562745344U, 22},
	{2562725888U, 21},
	{2562723840U, 21},
	{2562721792U, 23},
	{2562723328U, 23},
	{2562719744U, 23},
	{2562720512U, 24},
	{2562734080U, 23},
	{2562734592U, 24},
	{2562735104U, 24},
	{2562735616U, 23},
	{2562732032U, 21},
	{2562729984U, 22},
	{2562731264U, 24},
	{2562731520U, 23},
	{2562729728U, 24},
	{2562783232U, 22},
	{2562784256U, 23},
	{2562785024U, 24},
	{2562781184U, 22},
	{2562782208U, 23},
	{2562782720U, 24},
	{2562779648U, 24},
	{2562780160U, 22},
	{2562777088U, 22},
	{2562758656U, 22},
	{2562760192U, 23},
	{2562757632U, 23},
	{2562754560U, 22},
	{2562755584U, 22},
	{2562752512U, 22},
	{2562753536U, 23},
	{2562754048U, 23},
	{2562767872U, 22},
	{2312175616U, 16},
	{3631938304U, 24},
	{3479960832U, 24},
	{3460947456U, 24},
	{3436201216U, 24},
	{3429629440U, 24},
	{3419423232U, 24},
	{3407646208U, 24},
	{3399955456U, 24},
	{3398698752U, 24},
	{3358572032U, 24},
	{3344483840U, 24},
	{3337776384U, 24},
	{3229948928U, 24},
	{3227042048U, 24},
	{2562807808U, 22},
	{2562809088U, 24},
	{2562808832U, 24},
	{2562809600U, 24},
	{2562809344U, 24},
	{2562805760U, 22},
	{2562806784U, 23},
	{2562807296U, 23},
	{2562791424U, 22},
	{2562792448U, 23},
	{2562792960U, 24},
	{2562789376U, 23},
	{2562789888U, 24},
	{2562790400U, 22},
	{2562787584U, 24},
	{2562787328U, 24},
	{2562788096U, 24},
	{2562788352U, 24},
	{2562788864U, 24},
	{2562785280U, 23},
	{2562785792U, 23},
	{2562786304U, 22},
	{2562800896U, 24},
	{2562800640U, 24},
	{2562801408U, 24},
	{2562797568U, 22},
	{2562798592U, 22},
	{2562795520U, 22},
	{2562796544U, 22},
	{2562793472U, 22},
	{2562794496U, 23},
	{2562795008U, 23},
	{2562840832U, 24},
	{2562841344U, 24},
	{2562841600U, 23},
	{2562842112U, 23},
	{2562838528U, 21},
	{2562836480U, 21},
	{2562848768U, 21},
	{2562846720U, 22},
	{2562848256U, 24},
	{2562844672U, 21},
	{2562842624U, 21},
	{2562824192U, 22},
	{2562825216U, 23},
	{2562825728U, 23},
	{2562822144U, 22},
	{2562823168U, 23},
	{2562823680U, 23},
	{2562820352U, 24},
	{2562820096U, 24},
	{2562820608U, 24},
	{2562821120U, 23},
	{2562818304U, 24},
	{2562818560U, 23},
	{2562819072U, 22},
	{2562832384U, 22},
	{2562833408U, 23},
	{2562834176U, 24},
	{2562830336U, 23},
	{2562830848U, 23},
	{2562831360U, 23},
	{2562831872U, 23},
	{2562828288U, 22},
	{2562829312U, 22},
	{2562826240U, 23},
	{2562826752U, 23},
	{2562827264U, 24},
	{2562827776U, 23},
	{2312110080U, 16},
	{3458173696U, 24},
	{3393039616U, 24},
	{3359485696U, 24},
	{3257709568U, 24},
	{3250739456U, 24},
	{3228103168U, 24},
	{2562873344U, 22},
	{2562874880U, 23},
	{2562874624U, 24},
	{2562871808U, 24},
	{2562872064U, 24},
	{2562872832U, 24},
	{2562869760U, 24},
	{2562870016U, 24},
	{2562869248U, 23},
	{2562870784U, 23},
	{2562870272U, 23},
	{2562868224U, 22},
	{2562882048U, 23},
	{2562881536U, 23},
	{2562883072U, 24},
	{2562883328U, 24},
	{2562882560U, 23},
	{2562879488U, 22},
	{2562880512U, 22},
	{2562877952U, 24},
	{2562878464U, 23},
	{2562875392U, 22},
	{2562857984U, 22},
	{2562854912U, 21},
	{2562852864U, 22},
	{2562854400U, 23},
	{2562851584U, 24},
	{2562850816U, 23},
	{2562852352U, 23},
	{2562851840U, 23},
	{2562865664U, 23},
	{2562865152U, 23},
	{2562866688U, 23},
	{2562866176U, 23},
	{2562863104U, 22},
	{2562864128U, 22},
	{2562861568U, 23},
	{2562861056U, 23},
	{2562862080U, 22},
	{2562859008U, 21},
	{2562906112U, 21},
	{2562904064U, 22},
	{2562905088U, 22},
	{2562902528U, 23},
	{2562902016U, 23},
	{2562903040U, 22},
	{2562900480U, 23},
	{2562899968U, 24},
	{2562900224U, 24},
	{2562900992U, 22},
	{2562914304U, 22},
	{2562915328U, 23},
	{2562912256U, 22},
	{2562913280U, 22},
	{2562911232U, 22},
	{2562889728U, 22},
	{2562891264U, 23},
	{2562890752U, 24},
	{2562891008U, 24},
	{2562887680U, 21},
	{2562883584U, 22},
	{2562884608U, 22},
	{2562897920U, 22},
	{2562899456U, 23},
	{2562898944U, 23},
	{2562895872U, 22},
	{2562897408U, 23},
	{2562896896U, 23},
	{2562893824U, 22},
	{2562894848U, 22},
	{2562892288U, 24},
	{2562892544U, 24},
	{2562891776U, 23},
	{2562893312U, 24},
	{2562893568U, 24},
	{2562892800U, 23},
	{3464958464U, 24},
	{3414628096U, 24},
	{3407777280U, 24},
	{3398829824U, 24},
	{3358440960U, 24},
	{3357445376U, 24},
	{3263634944U, 24},
	{3240002560U, 24},
	{3231059200U, 24},
	{3228168704U, 24},
	{2562939392U, 23},
	{2562938880U, 23},
	{2562939904U, 22},
	{2562937344U, 24},
	{2562936832U, 23},
	{2562937856U, 22},
	{2562935296U, 23},
	{2562934784U, 23},
	{2562935808U, 22},
	{2562932736U, 22},
	{2562934272U, 24},
	{2562933760U, 22},
	{2562948608U, 23},
	{2562948096U, 23},
	{2562945024U, 22},
	{2562942976U, 22},
	{2562944000U, 23},
	{2562940928U, 22},
	{2562942464U, 23},
	{2562941952U, 23},
	{2562920448U, 21},
	{2562919424U, 23},
	{2562916352U, 21},
	{2562927104U, 24},
	{2562927872U, 24},
	{2562927616U, 24},
	{2562925056U, 23},
	{2562924544U, 23},
	{2562926336U, 24},
	{2562925824U, 24},
	{2562925568U, 24},
	{2562972416U, 24},
	{2562972160U, 24},
	{2562971648U, 23},
	{2562972672U, 22},
	{2562969600U, 22},
	{2562971136U, 23},
	{2562970624U, 23},
	{2562967552U, 22},
	{2562968576U, 22},
	{2562965504U, 22},
	{2562966528U, 22},
	{2562980352U, 23},
	{2562979840U, 23},
	{2562980864U, 22},
	{2562977792U, 22},
	{2562978816U, 22},
	{2562976256U, 23},
	{2562975744U, 23},
	{2562976768U, 22},
	{2562973696U, 22},
	{2562974720U, 22},
	{2562956800U, 24},
	{2562956288U, 23},
	{2562953728U, 24},
	{2562953216U, 23},
	{2562954240U, 22},
	{2562951168U, 22},
	{2562952192U, 22},
	{2562949120U, 21},
	{2562950656U, 23},
	{2562950400U, 24},
	{2562950144U, 24},
	{2562963968U, 23},
	{2562963456U, 23},
	{2562964480U, 22},
	{2562961408U, 22},
	{2562962432U, 22},
	{2562959872U, 24},
	{2562959360U, 23},
	{2562961152U, 24},
	{2562960896U, 24},
	{2562960384U, 24},
	{2562957824U, 24},
	{2562957568U, 24},
	{2562957312U, 24},
	{2562958336U, 22},
	{3632796928U, 24},
	{3559043840U, 24},
	{3515358208U, 24},
	{3484033024U, 24},
	{3433702144U, 24},
	{3432583168U, 24},
	{3408047104U, 24},
	{3358834176U, 24},
	{3357716224U, 24},
	{3335278336U, 24},
	{3323040256U, 24},
	{3276063232U, 24},
	{3261522176U, 24},
	{3244745216U, 24},
	{2311847936U, 16},
	{1158237184U, 24},
	{1157971968U, 20},
	{1158237440U, 24},
	{1157906432U, 20},
	{1157776896U, 23},
	{1157711104U, 24},
	{1157645312U, 23},
	{1160208384U, 20},
	{1158237696U, 24},
	{1158103040U, 20},
	{1157776640U, 24},
	{1158237952U, 24},
	{1157776384U, 24},
	{1157711616U, 24},
	{1158236160U, 24},
	{1157709824U, 19},
	{1158236416U, 24},
	{1157775872U, 23},
	{1157644288U, 19},
	{1158236672U, 24},
	{1157908224U, 24},
	{1157775616U, 24},
	{1157710336U, 24},
	{1159880704U, 21},
	{1158434304U, 23},
	{1158236928U, 24},
	{1157775360U, 24},
	{1157775360U, 20},
	{1157775360U, 19},
	{1158496256U, 18},
	{1158235136U, 24},
	{1157779200U, 24},
	{1158430720U, 20},
	{1158235392U, 24},
	{1157778944U, 24},
	{1157713152U, 24},
	{1158627328U, 21},
	{1158235648U, 24},
	{1157713408U, 24},
	{1159883776U, 22},
	{1158561792U, 20},
	{1158561792U, 18},
	{1158235904U, 24},
	{1158234112U, 24},
	{1158234112U, 19},
	{1157711872U, 24},
	{1160273920U, 19},
	{1158300160U, 24},
	{1158234368U, 24},
	{1157777920U, 24},
	{1157712128U, 24},
	{1158299904U, 24},
	{1158234624U, 24},
	{1157777664U, 24},
	{1157712384U, 24},
	{1160404992U, 20},
	{1159882752U, 22},
	{1158299648U, 20},
	{1157777408U, 24},
	{1158241280U, 24},
	{1157714944U, 23},
	{1158241536U, 24},
	{1161256960U, 20},
	{1159885824U, 22},
	{1159086080U, 19},
	{1157780480U, 22},
	{1160863744U, 20},
	{1159679488U, 24},
	{1159679744U, 24},
	{1158240512U, 24},
	{1157714176U, 24},
	{1159678976U, 24},
	{1158240768U, 24},
	{1160929280U, 20},
	{1159884800U, 22},
	{1159679232U, 24},
	{1158241024U, 24},
	{1157779456U, 22},
	{1157779456U, 20},
	{1158239232U, 24},
	{1159479296U, 19},
	{1158434816U, 20},
	{1158239488U, 24},
	{1157783040U, 23},
	{1159675904U, 24},
	{1159675904U, 20},
	{1158631424U, 21},
	{1159887872U, 22},
	{1158565888U, 20},
	{1158240000U, 24},
	{1157782528U, 24},
	{1161388032U, 20},
	{1158238208U, 24},
	{1159217152U, 20},
	{1158238464U, 24},
	{1159413760U, 20},
	{1158238720U, 24},
	{1160931328U, 22},
	{1159886848U, 22},
	{1159348224U, 19},
	{1158238976U, 24},
	{1157781504U, 22},
	{1160003584U, 19},
	{1157914624U, 20},
	{1160200192U, 19},
	{1158111232U, 20},
	{1159873536U, 22},
	{1157652480U, 19},
	{1159872512U, 21},
	{1157783552U, 21},
	{1160658944U, 19},
	{1158569984U, 20},
	{1160331264U, 20},
	{1160265728U, 19},
	{1160396800U, 20},
	{1159874560U, 21},
	{1158307840U, 20},
	{1161248768U, 20},
	{1161183232U, 20},
	{1160204544U, 24},
	{1159094272U, 20},
	{1160855552U, 19},
	{1160986624U, 19},
	{1160921088U, 20},
	{1159876608U, 21},
	{1157787648U, 21},
	{1161576448U, 24},
	{1158443008U, 20},
	{1158574080U, 20},
	{1157790720U, 22},
	{1159225344U, 20},
	{1161445376U, 19},
	{1159878656U, 21},
	{1157789696U, 22},
	{1157789696U, 21},
	{1160326144U, 24},
	{1159534592U, 22},
	{1158747136U, 22},
	{1157955584U, 19},
	{1160521728U, 21},
	{1159995392U, 20},
	{1158547968U, 23},
	{1157890048U, 19},
	{1160718336U, 21},
	{1160192000U, 20},
	{1158612992U, 21},
	{1158086656U, 20},
	{1159865344U, 22},
	{1158547456U, 24},
	{1158021120U, 20},
	{1160325120U, 22},
	{1158746112U, 22},
	{1157693440U, 19},
	{1157693440U, 18},
	{1160785920U, 21},
	{1158548992U, 23},
	{1157891072U, 23},
	{1157627904U, 19},
	{1157824512U, 16},
	{1159864320U, 22},
	{1158548480U, 24},
	{1157957376U, 24},
	{1157758976U, 21},
	{1160519936U, 24},
	{1158749184U, 23},
	{1158479872U, 19},
	{1160519680U, 24},
	{1159997440U, 24},
	{1158414336U, 19},
	{1157892096U, 21},
	{1160716288U, 21},
	{1159663616U, 20},
	{1158749696U, 23},
	{1158610944U, 21},
	{1158545408U, 21},
	{1158545408U, 19},
	{1158545408U, 18},
	{1160323072U, 24},
	{1159998720U, 24},
	{1159270400U, 20},
	{1158748160U, 22},
	{1158217728U, 19},
	{1160257536U, 19},
	{1159998464U, 22},
	{1158152192U, 18},
	{1160323584U, 24},
	{1158348800U, 18},
	{1160388608U, 20},
	{1159866368U, 21},
	{1158283264U, 20},
	{1157761024U, 21},
	{1161109504U, 19},
	{1159004160U, 18},
	{1159004160U, 16},
	{1160782848U, 22},
	{1158938624U, 19},
	{1160722432U, 21},
	{1160330752U, 24},
	{1159531008U, 24},
	{1159135232U, 19},
	{1158617088U, 21},
	{1161175040U, 20},
	{1159069696U, 18},
	{1158025216U, 20},
	{1158742016U, 21},
	{1167097856U, 17},
	{1160781824U, 22},
	{1159202816U, 21},
	{1158676480U, 17},
	{1158873088U, 19},
	{1160912896U, 21},
	{1159868416U, 21},
	{1158807552U, 18},
	{1158422016U, 23},
	{1159528448U, 22},
	{1159528448U, 18},
	{1161568256U, 19},
	{1160916480U, 23},
	{1159660288U, 24},
	{1159462912U, 19},
	{1160720384U, 21},
	{1160328704U, 23},
	{1159659520U, 20},
	{1159659520U, 19},
	{1158615040U, 21},
	{1160915968U, 23},
	{1159593984U, 17},
	{1158549504U, 20},
	{1161371648U, 20},
	{1159529472U, 22},
	{1159266304U, 20},
	{1158744064U, 21},
	{1160783872U, 21},
	{1159200768U, 21},
	{1159200768U, 20},
	{1157897216U, 23},
	{1159660544U, 22},
	{1159397376U, 20},
	{1160914944U, 22},
	{1159870464U, 21},
	{1159331840U, 19},
	{1160317952U, 23},
	{1160052736U, 19},
	{1159542784U, 22},
	{1160252416U, 22},
	{1159987200U, 20},
	{1157898240U, 24},
	{1157898240U, 20},
	{1160710144U, 21},
	{1160318464U, 24},
	{1160183808U, 20},
	{1158621184U, 21},
	{1158094848U, 20},
	{1160318720U, 24},
	{1160118272U, 20},
	{1157898752U, 24},
	{1160316928U, 23},
	{1159790592U, 17},
	{1160777728U, 20},
	{1160514560U, 22},
	{1160251392U, 23},
	{1159725056U, 16},
	{1157636096U, 19},
	{1160317440U, 24},
	{1159921664U, 16},
	{1160317696U, 24},
	{1160251904U, 23},
	{1159856128U, 20},
	{1157767168U, 20},
	{1158488064U, 19},
	{1160511488U, 16},
	{1158422528U, 20},
	{1160708096U, 21},
	{1158619136U, 21},
	{1160642560U, 20},
	{1158553600U, 20},
	{1160314880U, 21},
	{1160314880U, 20},
	{1160445952U, 20},
	{1160445952U, 18},
	{1157902080U, 24},
	{1160380416U, 20},
	{1158291456U, 20},
	{1157901824U, 24},
	{1161101312U, 19},
	{1158751232U, 22},
	{1161232384U, 20},
	{1160714240U, 21},
	{1159143424U, 19},
	{1158625280U, 21},
	{1161166848U, 20},
	{1160905216U, 24},
	{1160773632U, 20},
	{1160773632U, 18},
	{1160518656U, 22},
	{1158750464U, 24},
	{1160970240U, 19},
	{1159407616U, 21},
	{1158750720U, 24},
	{1160904704U, 21},
	{1160904704U, 20},
	{1159860224U, 20},
	{1159536640U, 22},
	{1161560064U, 20},
	{1160908288U, 23},
	{1158426624U, 20},
	{1160712192U, 21},
	{1159667712U, 19},
	{1158623232U, 21},
	{1160907776U, 23},
	{1160646656U, 20},
	{1158557696U, 20},
	{1158752256U, 23},
	{1161297920U, 20},
	{1160253440U, 20},
	{1159208960U, 20},
	{1160450048U, 23},
	{1159405568U, 21},
	{1159405568U, 20},
	{1161428992U, 19},
	{1160906752U, 22},
	{1158004736U, 19},
	{1160044544U, 20},
	{1157939200U, 20},
	{1160241152U, 20},
	{1158135808U, 20},
	{1157742592U, 19},
	{1167085568U, 21},
	{1158926336U, 21},
	{1159913472U, 21},
	{1157808128U, 20},
	{1159516160U, 22},
	{1158929408U, 24},
	{1158929664U, 24},
	{1158594560U, 20},
	{1160372224U, 20},
	{1158266880U, 19},
	{1167087616U, 22},
	{1158397952U, 18},
	{1160437760U, 20},
	{1158332416U, 20},
	{1161290240U, 24},
	{1161290496U, 24},
	{1159514112U, 22},
	{1161289728U, 24},
	{1161289984U, 24},
	{1161224192U, 20},
	{1159384064U, 22},
	{1159118848U, 19},
	{1161291264U, 24},
	{1160896512U, 20},
	{1167081472U, 20},
	{1161291520U, 24},
	{1159515136U, 22},
	{1161290752U, 24},
	{1158922240U, 20},
	{1161291008U, 24},
	{1160962048U, 20},
	{1159383040U, 22},
	{1161292288U, 24},
	{1161617408U, 20},
	{1161292544U, 24},
	{1159512064U, 21},
	{1161291776U, 24},
	{1161292032U, 24},
	{1159920640U, 23},
	{1158598656U, 20},
	{1161293312U, 24},
	{1161293568U, 24},
	{1159249920U, 20},
	{1161292800U, 24},
	{1159446528U, 20},
	{1161293056U, 24},
	{1159380992U, 21},
	{1159380992U, 20},
	{1158144512U, 24},
	{1160036352U, 20},
	{1158144768U, 24},
	{1157947392U, 20},
	{1160232960U, 20},
	{1158144000U, 24},
	{1158144256U, 24},
	{1159461376U, 24},
	{1158145536U, 24},
	{1158145792U, 24},
	{1161023488U, 21},
	{1158145024U, 24},
	{1160957952U, 20},
	{1159905280U, 21},
	{1158145280U, 24},
	{1157816320U, 21},
	{1157816320U, 19},
	{1158146560U, 24},
	{1158146816U, 24},
	{1158146048U, 24},
	{1160691712U, 19},
	{1158602752U, 20},
	{1158146304U, 24},
	{1160364032U, 20},
	{1158275072U, 19},
	{1158147584U, 24},
	{1158147840U, 24},
	{1161025536U, 21},
	{1159458816U, 24},
	{1158147072U, 24},
	{1160429568U, 20},
	{1159907328U, 21},
	{1158340608U, 20},
	{1157818368U, 21},
	{1159261184U, 22},
	{1159457792U, 24},
	{1161216000U, 20},
	{1159910400U, 22},
	{1159127040U, 19},
	{1160888320U, 20},
	{1159457280U, 24},
	{1159457536U, 24},
	{1161019392U, 20},
	{1160953856U, 21},
	{1159909376U, 22},
	{1157820416U, 21},
	{1161609216U, 20},
	{1159912448U, 22},
	{1159456000U, 24},
	{1158606848U, 20},
	{1161412608U, 20},
	{1159258112U, 20},
	{1161543680U, 19},
	{1159454720U, 19},
	{1161478144U, 18},
	{1157822464U, 21},
	{1158911488U, 24},
	{1157988352U, 19},
	{1160028160U, 20},
	{1158911744U, 24},
	{1157922816U, 19},
	{1157661696U, 22},
	{1160224768U, 20},
	{1158910976U, 24},
	{1159502336U, 23},
	{1159106560U, 23},
	{1158911232U, 24},
	{1158053888U, 18},
	{1159766272U, 24},
	{1159108352U, 24},
	{1158910464U, 24},
	{1158120960U, 24},
	{1157726208U, 19},
	{1167069184U, 20},
	{1166016512U, 18},
	{1159766016U, 24},
	{1158910720U, 24},
	{1158187008U, 22},
	{1157660672U, 22},
	{1157660672U, 21},
	{1157660672U, 17},
	{1158909952U, 24},
	{1158909952U, 20},
	{1158187776U, 24},
	{1158120448U, 24},
	{1159897088U, 20},
	{1159766528U, 24},
	{1159107584U, 22},
	{1158910208U, 24},
	{1157791744U, 19},
	{1159500032U, 24},
	{1158913536U, 24},
	{1166802944U, 16},
	{1158913792U, 24},
	{1158185984U, 22},
	{1158913024U, 24},
	{1158121472U, 24},
	{1158913280U, 24},
	{1158578176U, 20},
	{1158578176U, 18},
	{1159501056U, 24},
	{1158912512U, 24},
	{1158250496U, 19},
	{1160356096U, 24},
	{1158912768U, 24},
	{1158184960U, 19},
	{1160356352U, 24},
	{1159109888U, 24},
	{1158912000U, 24},
	{1158381568U, 18},
	{1160421376U, 20},
	{1159501312U, 24},
	{1158912256U, 24},
	{1158316032U, 20},
	{1159497728U, 24},
	{1158971392U, 18},
	{1161273344U, 20},
	{1159498240U, 23},
	{1159102464U, 19},
	{1159102464U, 18},
	{1158584320U, 22},
	{1160880128U, 20},
	{1159499008U, 24},
	{1158774784U, 18},
	{1167065088U, 20},
	{1158585856U, 23},
	{1158905856U, 21},
	{1160945664U, 20},
	{1159901184U, 21},
	{1159366656U, 21},
	{1159103488U, 22},
	{1158840320U, 18},
	{1158585344U, 23},
	{1160949504U, 24},
	{1158583040U, 24},
	{1161601024U, 20},
	{1159495680U, 21},
	{1159495680U, 19},
	{1158582784U, 24},
	{1158582272U, 20},
	{1159233536U, 20},
	{1159430144U, 20},
	{1158907904U, 21},
	{1159903232U, 21},
	{1159364608U, 21},
	{1158583296U, 22},
	{1160482560U, 24},
	{1160019968U, 20},
	{1157931008U, 20},
	{1160481792U, 24},
	{1160216576U, 20},
	{1158127616U, 20},
	{1160482048U, 24},
	{1160151040U, 20},
	{1160349696U, 21},
	{1160481536U, 24},
	{1160480768U, 24},
	{1158918144U, 21},
	{1159888896U, 20},
	{1157799936U, 20},
	{1160480256U, 24},
	{1160348672U, 22},
	{1160479744U, 24},
	{1160675328U, 19},
	{1160480000U, 24},
	{1158586368U, 20},
	{1161400320U, 20},
	{1160347648U, 24},
	{1160347904U, 24},
	{1160478720U, 24},
	{1160348160U, 24},
	{1158920192U, 24},
	{1160478976U, 24},
	{1160413184U, 20},
	{1160348416U, 24},
	{1158920448U, 24},
	{1158324224U, 20},
	{1160939264U, 24},
	{1158915584U, 24},
	{1160939008U, 24},
	{1160486656U, 24},
	{1159111168U, 23},
	{1158915840U, 24},
	{1161265152U, 20},
	{1160938752U, 24},
	{1158915072U, 23},
	{1161199616U, 20},
	{1160938496U, 24},
	{1160155136U, 20},
	{1159110656U, 19},
	{1160938240U, 24},
	{1160937984U, 24},
	{1160806400U, 24},
	{1160806400U, 18},
	{1160937728U, 24},
	{1160484864U, 24},
	{1159440384U, 23},
	{1158914048U, 22},
	{1160937472U, 24},
	{1159892992U, 20},
	{1160941312U, 24},
	{1161592832U, 20},
	{1160941056U, 24},
	{1160940800U, 24},
	{1160940544U, 24},
	{1159112704U, 22},
	{1158590464U, 20},
	{1161396224U, 20},
	{1160940288U, 24},
	{1161330688U, 18},
	{1160940032U, 24},
	{1160483584U, 24},
	{1159241728U, 20},
	{1161527296U, 19},
	{1160939776U, 24},
	{1159438336U, 20},
	{1158916096U, 21},
	{1161461760U, 19},
	{1160939520U, 24},
	{3631671808U, 24},
	{3503118592U, 24},
	{3449295104U, 24},
	{3392322560U, 24},
	{3360016640U, 24},
	{3334092800U, 24},
	{3222311936U, 24},
	{2311913472U, 16},
	{3629631488U, 24},
	{3499822080U, 24},
	{3454821888U, 24},
	{3432714240U, 24},
	{3431596288U, 24},
	{3407060736U, 24},
	{3405942272U, 24},
	{3393637120U, 24},
	{3584637440U, 24},
	{3566864384U, 24},
	{3514098432U, 24},
	{3420345088U, 24},
	{3406007808U, 24},
	{3400082688U, 24},
	{3399095808U, 24},
	{3340869632U, 24},
	{3254549248U, 24},
	{3230338304U, 24},
	{3225927936U, 24},
	{2312044544U, 16},
	{3563255552U, 24},
	{3499953152U, 24},
	{3483177728U, 24},
	{3480485120U, 24},
	{3450741248U, 24},
	{3433964288U, 24},
	{3400410368U, 24},
	{3393243904U, 24},
	{3258430464U, 24},
	{2311585792U, 16},
	{3650880768U, 24},
	{3586009856U, 24},
	{3557134592U, 24},
	{3513967360U, 24},
	{3486074368U, 24},
	{3449557248U, 24},
	{3431792896U, 24},
	{3407126272U, 24},
	{3389361920U, 24},
	{3359030784U, 24},
	{3334354944U, 24},
	{3326199552U, 24},
	{3262312448U, 24},
	{3235403776U, 24},
	{2311651328U, 16},
	{2311704576U, 22},
	{3695369472U, 24},
	{3645036544U, 24},
	{3624312064U, 24},
	{3588783616U, 24},
	{3511927040U, 24},
	{3451728640U, 24},
	{3448635392U, 24},
	{3428047872U, 24},
	{3391401216U, 24},
	{3351924224U, 24},
	{3288760576U, 24},
	{3284814336U, 24},
	{3251259392U, 24},
	{3244352000U, 24},
	{3633255680U, 24},
	{3627331072U, 24},
	{3588849152U, 24},
	{3507913984U, 24},
	{3500018688U, 24},
	{3486205440U, 24},
	{3438835200U, 24},
	{3426007552U, 24},
	{3391466752U, 24},
	{3390479872U, 24},
	{3389492992U, 24},
	{3353963520U, 24},
	{3345081344U, 24},
	{3341131776U, 24},
	{3323367936U, 24},
	{3281919744U, 24},
	{3250339584U, 24},
	{3235534848U, 24},
	{3226652672U, 24},
	{2311782400U, 16},
	{3564041984U, 24},
	{3505875456U, 24},
	{3479035648U, 24},
	{3448836352U, 24},
	{3414164992U, 24},
	{3407453952U, 24},
	{3397388032U, 24},
	{3361593344U, 24},
	{3343697408U, 24},
	{3285539584U, 24},
	{3259810560U, 24},
	{3254221568U, 24},
	{3253103104U, 24},
	{3238560768U, 24},
	{3561870592U, 24},
	{3406401024U, 24},
	{3398440448U, 24},
	{3391859968U, 24},
	{3359292928U, 24},
	{3269945600U, 24},
	{3254156032U, 24},
	{3253168640U, 24},
	{3245335040U, 24},
	{3236391680U, 24},
	{3228558080U, 24},
	{2311389184U, 16},
	{3718263296U, 24},
	{3664574720U, 24},
	{3638850304U, 24},
	{3529490944U, 24},
	{3520547072U, 24},
	{3509106176U, 24},
	{3493438976U, 24},
	{3491464192U, 24},
	{3485877760U, 24},
	{3474692864U, 24},
	{3471074560U, 24},
	{3449823744U, 24},
	{3414296064U, 24},
	{3394161408U, 24},
	{3357252608U, 24},
	{3354754304U, 24},
	{3263033344U, 24},
	{3234220288U, 24},
	{3231723264U, 24},
	{2311454720U, 16},
	{3574304768U, 24},
	{3564955136U, 24},
	{3531399168U, 24},
	{3515030528U, 24},
	{3512647936U, 24},
	{3436598272U, 24},
	{3434099200U, 24},
	{3413965056U, 24},
	{3409493248U, 24},
	{3323630080U, 24},
	{3289088256U, 24},
	{3273299712U, 24},
	{3266329600U, 24},
	{3246191360U, 24},
	{3245203968U, 24},
	{3230800896U, 24},
	{3229814016U, 24},
	{3227439104U, 24},
	{3562652672U, 24},
	{3522390784U, 24},
	{3516206336U, 24},
	{3360213248U, 24},
	{3357383680U, 24},
	{3353504768U, 24},
	{3230997504U, 24},
	{3229879552U, 24},
	{3222045952U, 24},
	{2311061504U, 16},
	{3517398528U, 24},
	{3498384640U, 24},
	{3435218176U, 24},
	{3409886464U, 24},
	{3407650560U, 24},
	{3358568192U, 24},
	{3344488192U, 24},
	{3325997056U, 24},
	{3263500032U, 24},
	{3255666432U, 24},
	{3224348416U, 24},
	{2311127040U, 16},
	{3478904576U, 24},
	{3449229568U, 24},
	{3434426880U, 24},
	{3430546944U, 24},
	{3418505728U, 24},
	{3399755008U, 24},
	{3393043456U, 24},
	{3391925504U, 24},
	{3389951744U, 24},
	{3359489536U, 24},
	{3332647168U, 24},
	{3235076096U, 24},
	{3224151808U, 24},
	{2311192576U, 16},
	{3639632384U, 24},
	{3536996864U, 24},
	{3510413056U, 24},
	{3500490496U, 24},
	{3493635584U, 24},
	{3491660800U, 24},
	{3474889472U, 24},
	{3453113600U, 24},
	{3437324032U, 24},
	{3414623744U, 24},
	{3407781632U, 24},
	{3406794240U, 24},
	{3399820544U, 24},
	{3360409856U, 24},
	{3359424000U, 24},
	{3358437120U, 24},
	{3357449216U, 24},
	{3257771264U, 24},
	{3231063040U, 24},
	{2311258112U, 16},
	{3556727296U, 24},
	{3489703424U, 24},
	{3476261376U, 24},
	{3408043776U, 24},
	{3399034112U, 24},
	{3357711360U, 24},
	{3344294912U, 24},
	{3261518336U, 24},
	{3250260992U, 24},
	{3243631104U, 24},
	{3230154240U, 24},
	{3639558144U, 24},
	{3530015232U, 24},
	{3489547776U, 24},
	{3452794624U, 24},
	{3449299456U, 24},
	{3438236672U, 24},
	{3406867456U, 24},
	{3360029184U, 24},
	{3356536576U, 24},
	{3355332096U, 24},
	{3349879552U, 24},
	{3228028928U, 24},
	{3222316800U, 24},
	{3498716672U, 24},
	{3459353344U, 24},
	{3454817536U, 24},
	{3407064064U, 24},
	{3405954304U, 24},
	{3365611264U, 24},
	{3268311040U, 24},
	{3244609792U, 24},
	{3227832320U, 24},
	{3225874944U, 24},
	{3482005760U, 24},
	{3478580224U, 24},
	{3333950208U, 24},
	{2314993664U, 24},
	{2315026432U, 24},
	{3506743040U, 24},
	{3489351168U, 24},
	{3409415680U, 24},
	{3406085376U, 24},
	{3392638720U, 24},
	{3389307904U, 24},
	{3247193856U, 24},
	{3237693696U, 24},
	{3224864000U, 24},
	{2314928128U, 16},
	{3650893312U, 24},
	{3564295424U, 24},
	{3486086400U, 24},
	{3469308928U, 24},
	{3436734208U, 24},
	{3359018240U, 24},
	{3358039040U, 24},
	{2314862592U, 16},
	{3588771072U, 24},
	{3485270528U, 24},
	{3479232256U, 24},
	{3454555392U, 24},
	{3288773120U, 24},
	{3223622656U, 24},
	{3637207552U, 24},
	{3634247424U, 24},
	{3588836608U, 24},
	{3582929664U, 24},
	{3507926528U, 24},
	{3486217472U, 24},
	{3428965376U, 24},
	{3390483712U, 24},
	{3389504512U, 24},
	{3349030912U, 24},
	{3250326528U, 24},
	{3234560512U, 24},
	{2314731520U, 16},
	{3626667008U, 24},
	{3449950464U, 24},
	{3448840704U, 24},
	{3421979136U, 24},
	{3407457280U, 24},
	{3325788928U, 24},
	{3259822080U, 24},
	{3254208512U, 24},
	{2314665984U, 16},
	{3624513024U, 24},
	{3515891200U, 24},
	{3407391744U, 24},
	{3398444288U, 24},
	{3356081664U, 24},
	{3287697920U, 24},
	{3272193280U, 24},
	{3255415808U, 24},
	{3246309376U, 24},
	{2314600448U, 16},
	{3630168832U, 24},
	{3520559616U, 24},
	{3507136256U, 24},
	{3485889792U, 24},
	{3450929152U, 24},
	{3417376256U, 24},
	{3409546752U, 24},
	{3400599296U, 24},
	{3333491456U, 24},
	{3245134080U, 24},
	{3235343104U, 24},
	{2565079040U, 16},
	{2314534912U, 16},
	{3631073280U, 24},
	{3551534592U, 24},
	{3520494080U, 24},
	{3517979648U, 24},
	{3508188672U, 24},
	{3498257920U, 24},
	{3418845440U, 24},
	{3413953024U, 24},
	{3407522816U, 24},
	{3397176064U, 24},
	{3336920576U, 24},
	{3323633920U, 24},
	{3260018688U, 24},
	{3245199616U, 24},
	{3227443968U, 24},
	{3223950336U, 24},
	{2565144576U, 16},
	{2314469376U, 16},
	{3628657152U, 24},
	{3357388544U, 24},
	{3356278272U, 24},
	{3354611200U, 24},
	{3349551872U, 24},
	{3289166336U, 24},
	{3242783488U, 24},
	{2564966400U, 24},
	{2564960256U, 20},
	{2564956160U, 20},
	{2564947968U, 16},
	{2565009408U, 21},
	{2565005312U, 20},
	{2564988928U, 20},
	{2564980736U, 20},
	{3631929600U, 24},
	{3629710080U, 24},
	{3567716352U, 24},
	{3460955136U, 24},
	{3459226112U, 24},
	{3436209920U, 24},
	{3416725248U, 24},
	{3409874432U, 24},
	{3407653888U, 24},
	{3399947776U, 24},
	{3358563328U, 24},
	{3356343808U, 24},
	{3250682624U, 24},
	{2314338304U, 16},
	{3629906688U, 24},
	{3586289408U, 24},
	{3584297216U, 24},
	{3511345920U, 24},
	{3504359424U, 24},
	{3490620928U, 24},
	{3478907904U, 24},
	{3469960448U, 24},
	{3431346688U, 24},
	{3333753600U, 24},
	{3332643328U, 24},
	{3331795200U, 24},
	{3257701888U, 24},
	{3235080960U, 24},
	{3229204736U, 24},
	{3537008896U, 24},
	{3518241792U, 24},
	{3514355712U, 24},
	{3507463936U, 24},
	{3453117952U, 24},
	{3427532288U, 24},
	{3414635776U, 24},
	{3392966400U, 24},
	{3269548544U, 24},
	{3258746624U, 24},
	{3229139200U, 24},
	{3651802112U, 24},
	{3632805632U, 24},
	{3524371456U, 24},
	{3465027840U, 24},
	{3432591872U, 24},
	{3416917504U, 24},
	{3408039424U, 24},
	{3406937344U, 24},
	{3389041920U, 24},
	{3357707520U, 24},
	{3344299264U, 24},
	{3328624384U, 24},
	{3323047936U, 24},
	{3279409920U, 24},
	{3261514496U, 24},
	{3244736512U, 24},
	{3226857984U, 24},
	{3225740032U, 24},
	{2314076160U, 16},
	{3639562496U, 24},
	{3582540288U, 24},
	{3518631168U, 24},
	{3491992832U, 24},
	{3489552128U, 24},
	{3481870336U, 24},
	{3476200192U, 24},
	{3449303808U, 24},
	{3438232832U, 24},
	{3360025344U, 24},
	{3355553536U, 24},
	{3259359488U, 24},
	{3223553280U, 24},
	{2314141696U, 16},
	{3632936704U, 24},
	{3491796224U, 24},
	{3473057792U, 24},
	{3467117312U, 24},
	{3466276864U, 24},
	{3459357184U, 24},
	{3423844864U, 24},
	{3421258240U, 24},
	{3407908352U, 24},
	{3365615104U, 24},
	{3290464512U, 24},
	{3242648064U, 24},
	{3227828480U, 24},
	{2313945088U, 16},
	{3492840448U, 24},
	{3340861952U, 24},
	{3274741504U, 24},
	{3231333888U, 24},
	{3226923520U, 24},
	{2314010624U, 16},
	{3630356736U, 24},
	{3626409216U, 24},
	{3530801664U, 24},
	{3521796096U, 24},
	{3433955584U, 24},
	{3430145024U, 24},
	{3322192128U, 24},
	{3256202240U, 24},
	{3650889472U, 24},
	{3635352832U, 24},
	{3627453440U, 24},
	{3586001152U, 24},
	{3506812416U, 24},
	{3502865152U, 24},
	{3468562944U, 24},
	{3449565952U, 24},
	{3438957568U, 24},
	{3431801600U, 24},
	{3389369600U, 24},
	{3358035200U, 24},
	{3253422080U, 24},
	{3251202560U, 24},
	{3485274880U, 24},
	{3466539008U, 24},
	{3465421056U, 24},
	{3433824512U, 24},
	{3351931904U, 24},
	{3328231168U, 24},
	{3227566336U, 24},
	{3226726912U, 24},
	{3223618816U, 24},
	{3222779392U, 24},
	{3221661440U, 24},
	{3588840448U, 24},
	{3520752384U, 24},
	{3503974912U, 24},
	{3458566912U, 24},
	{3454616576U, 24},
	{3448709632U, 24},
	{3425011968U, 24},
	{3406277632U, 24},
	{3358891008U, 24},
	{3353955840U, 24},
	{3341124096U, 24},
	{3323375616U, 24},
	{3267108352U, 24},
	{3481263872U, 24},
	{3473451008U, 24},
	{3448845056U, 24},
	{3435423488U, 24},
	{3427593984U, 24},
	{3368313600U, 24},
	{3332508416U, 24},
	{3285547264U, 24},
	{3258684928U, 24},
	{3254212864U, 24},
	{2313551872U, 16},
	{3523851520U, 24},
	{3489027840U, 24},
	{3471263488U, 24},
	{3428646400U, 24},
	{3398448128U, 24},
	{3356077824U, 24},
	{3333560832U, 24},
	{3270924800U, 24},
	{3253159936U, 24},
	{3249675520U, 24},
	{3234163456U, 24},
	{3650299648U, 24},
	{3636884224U, 24},
	{3531457024U, 24},
	{3499306496U, 24},
	{3491472896U, 24},
	{3437511936U, 24},
	{3409551104U, 24},
	{3358100736U, 24},
	{3354746624U, 24},
	{3246248192U, 24},
	{3245129728U, 24},
	{3231714560U, 24},
	{2313420800U, 16},
	{3633456640U, 24},
	{3432133120U, 24},
	{3417315072U, 24},
	{3413957376U, 24},
	{3412969984U, 24},
	{3411998976U, 24},
	{3407527168U, 24},
	{3406539776U, 24},
	{3392708096U, 24},
	{3391721216U, 24},
	{3343901696U, 24},
	{3340415232U, 24},
	{3336916736U, 24},
	{3227447808U, 24},
	{2313486336U, 16},
	{3584432128U, 24},
	{3516215040U, 24},
	{3353497088U, 24},
	{3289162496U, 24},
	{2313289728U, 16},
	{3631925248U, 24},
	{3487778304U, 24},
	{3463171840U, 24},
	{3436213760U, 24},
	{3409878784U, 24},
	{3406670848U, 24},
	{3397723392U, 24},
	{3356339968U, 24},
	{3354550016U, 24},
	{3333822976U, 24},
	{3289228032U, 24},
	{3250678272U, 24},
	{3229274112U, 24},
	{3228287232U, 24},
	{3227054592U, 24},
	{2313381888U, 21},
	{2313404416U, 19},
	{2313388032U, 19},
	{3633784320U, 24},
	{3586293248U, 24},
	{3520293632U, 24},
	{3490625280U, 24},
	{3478912256U, 24},
	{3426588672U, 24},
	{3411802368U, 24},
	{3406736384U, 24},
	{3275593472U, 24},
	{3258816000U, 24},
	{3235084800U, 24},
	{2313158656U, 16},
	{3455079680U, 24},
	{3437315328U, 24},
	{3414631424U, 24},
	{3403760384U, 24},
	{3358428416U, 24},
	{3257763584U, 24},
	{2313224192U, 16},
	{3523234304U, 24},
	{3489679360U, 24},
	{3406905856U, 24},
	{3393459712U, 24},
	{3389018624U, 24},
	{3346475008U, 24},
	{3330856448U, 24},
	{3325259008U, 24},
	{3231301888U, 24},
	{3225689088U, 24},
	{2299592704U, 16},
	{3628401664U, 24},
	{3473950208U, 24},
	{3449342976U, 24},
	{3356508416U, 24},
	{3334137088U, 24},
	{3330921984U, 24},
	{3273881856U, 24},
	{3261545472U, 24},
	{2550202368U, 16},
	{2299527168U, 16},
	{3637414912U, 24},
	{3558895104U, 24},
	{3459343616U, 24},
	{3429118464U, 24},
	{3407900928U, 24},
	{3407036928U, 24},
	{3393590784U, 24},
	{3392233728U, 24},
	{3389149696U, 24},
	{3355287552U, 24},
	{3338510592U, 24},
	{3336536832U, 24},
	{3326482944U, 24},
	{3240131328U, 24},
	{3234763776U, 24},
	{3224464128U, 24},
	{2550267904U, 16},
	{3631494912U, 24},
	{3551125760U, 24},
	{3484024064U, 24},
	{3469711872U, 24},
	{3422333952U, 24},
	{3406971392U, 24},
	{3355660288U, 24},
	{3350782976U, 24},
	{3326548480U, 24},
	{3224398592U, 24},
	{2299658240U, 16},
	{3642052608U, 24},
	{3523496448U, 24},
	{3498885120U, 24},
	{3489376256U, 24},
	{3485461504U, 24},
	{3434020352U, 24},
	{3407168000U, 24},
	{3322174976U, 24},
	{3286938880U, 24},
	{3256175360U, 24},
	{2550398976U, 16},
	{2299854848U, 16},
	{3476448256U, 24},
	{3467639808U, 24},
	{3460370944U, 24},
	{3390325504U, 24},
	{3360687360U, 24},
	{3327134464U, 24},
	{3231498496U, 24},
	{3223812608U, 24},
	{3221575680U, 24},
	{2299789312U, 16},
	{3695312896U, 24},
	{3625406720U, 24},
	{3521685248U, 24},
	{3516911616U, 24},
	{3499016192U, 24},
	{3462410240U, 24},
	{3418220544U, 24},
	{3392495872U, 24},
	{3355025408U, 24},
	{3351941888U, 24},
	{3335164416U, 24},
	{3280917248U, 24},
	{3257169920U, 24},
	{3241503232U, 24},
	{3233669888U, 24},
	{3226668288U, 24},
	{3500069120U, 24},
	{3454647040U, 24},
	{3407233536U, 24},
	{3391451136U, 24},
	{3335229952U, 24},
	{3328260096U, 24},
	{2299920384U, 16},
	{3624419328U, 24},
	{3567445504U, 24},
	{3559550464U, 24},
	{3519317248U, 24},
	{3509218048U, 24},
	{3485768448U, 24},
	{3430996992U, 24},
	{3418660608U, 24},
	{3407430144U, 24},
	{3333678336U, 24},
	{3325783296U, 24},
	{3253122816U, 24},
	{2300116992U, 16},
	{3628925952U, 24},
	{3624484864U, 24},
	{3517178624U, 24},
	{3510270464U, 24},
	{3502605312U, 24},
	{3427602432U, 24},
	{3414285056U, 24},
	{3407364608U, 24},
	{3357032704U, 24},
	{3263048960U, 24},
	{3234173952U, 24},
	{3225053952U, 24},
	{2300051456U, 16},
	{3632449536U, 24},
	{3520566272U, 24},
	{3518099968U, 24},
	{3471095808U, 24},
	{3419901440U, 24},
	{3409534976U, 24},
	{3353653504U, 24},
	{3331573504U, 24},
	{3241765376U, 24},
	{3234239488U, 24},
	{3231773184U, 24},
	{2300248064U, 16},
	{3683834368U, 24},
	{3639918336U, 24},
	{3631031808U, 24},
	{3630044416U, 24},
	{3481018368U, 24},
	{3406516992U, 24},
	{3357163776U, 24},
	{3351745280U, 24},
	{3333481728U, 24},
	{2550857728U, 16},
	{2300182528U, 16},
	{3628598272U, 24},
	{3516256256U, 24},
	{3510598144U, 24},
	{3485506304U, 24},
	{3479843072U, 24},
	{3467049984U, 24},
	{3406582528U, 24},
	{3401050368U, 24},
	{3361277184U, 24},
	{3356250112U, 24},
	{3345627392U, 24},
	{3282497792U, 24},
	{3262852352U, 24},
	{3255589376U, 24},
	{3222034432U, 24},
	{3631888128U, 24},
	{3626983936U, 24},
	{3582313728U, 24},
	{3502343168U, 24},
	{3480887296U, 24},
	{3457959680U, 24},
	{3413779456U, 24},
	{3390849792U, 24},
	{3330659840U, 24},
	{3252926208U, 24},
	{3230974208U, 24},
	{2300313600U, 16},
	{3520304128U, 24},
	{3491715328U, 24},
	{3460960768U, 24},
	{3453192192U, 24},
	{3431390208U, 24},
	{3429380608U, 24},
	{3407823360U, 24},
	{3406713600U, 24},
	{3389936128U, 24},
	{3360297984U, 24},
	{3357491456U, 24},
	{3356381184U, 24},
	{3337724160U, 24},
	{3331835648U, 24},
	{2551054336U, 16},
	{3641655552U, 24},
	{3507439872U, 24},
	{3437345280U, 24},
	{3428450560U, 24},
	{3418595072U, 24},
	{3399874560U, 24},
	{3390980864U, 24},
	{3360363520U, 24},
	{3357425920U, 24},
	{3333743872U, 24},
	{3330790912U, 24},
	{3325848832U, 24},
	{3258738944U, 24},
	{3249857024U, 24},
	{3234042880U, 24},
	{3230126080U, 24},
	{3229101824U, 24},
	{2300444672U, 16},
	{3569083904U, 24},
	{3439311360U, 24},
	{3357696768U, 24},
	{3326348032U, 24},
	{3273811968U, 24},
	{3261476096U, 24},
	{3234628864U, 24},
	{3223481088U, 24},
	{2551292416U, 24},
	{2551250944U, 16},
	{2551292640U, 27},
	{3524282880U, 24},
	{3506349568U, 24},
	{3463852032U, 24},
	{3408093184U, 24},
	{3392303104U, 24},
	{3356512256U, 24},
	{3330918144U, 24},
	{3328649472U, 24},
	{2551185408U, 16},
	{3625140224U, 24},
	{3558899456U, 24},
	{3516645632U, 24},
	{3439180288U, 24},
	{3411482368U, 24},
	{3335422720U, 24},
	{3332957440U, 24},
	{3327597056U, 24},
	{3230318848U, 24},
	{2551382016U, 16},
	{3640438272U, 24},
	{3585664768U, 24},
	{3506657280U, 24},
	{3506218496U, 24},
	{3477537280U, 24},
	{3467242752U, 24},
	{3452930048U, 24},
	{3429180160U, 24},
	{3425728000U, 24},
	{3422338304U, 24},
	{3420364544U, 24},
	{3389211392U, 24},
	{3357631232U, 24},
	{3350787328U, 24},
	{3344308992U, 24},
	{3278187520U, 24},
	{3234825472U, 24},
	{3230384384U, 24},
	{3225881856U, 24},
	{3224402432U, 24},
	{3520693504U, 24},
	{3506722816U, 24},
	{3506152960U, 24},
	{3489380608U, 24},
	{3485465856U, 24},
	{3407172352U, 24},
	{3286934528U, 24},
	{3242200064U, 24},
	{3236603648U, 24},
	{3224861184U, 24},
	{3489315072U, 24},
	{3476452608U, 24},
	{3461353984U, 24},
	{3448622080U, 24},
	{3351180544U, 24},
	{3346151680U, 24},
	{3333416192U, 24},
	{3255126784U, 24},
	{3251209216U, 24},
	{3233739264U, 24},
	{3232752384U, 24},
	{3224795648U, 24},
	{3221571840U, 24},
	{3627377152U, 24},
	{3562211328U, 24},
	{3516907776U, 24},
	{3490076928U, 24},
	{3482242560U, 24},
	{3448687616U, 24},
	{3418224896U, 24},
	{3407303424U, 24},
	{3393324800U, 24},
	{3356971008U, 24},
	{3355853056U, 24},
	{3342993920U, 24},
	{3328190720U, 24},
	{3262200832U, 24},
	{3222755328U, 24},
	{3639197440U, 24},
	{3558231040U, 24},
	{3490142464U, 24},
	{3486222848U, 24},
	{3484281856U, 24},
	{3448753152U, 24},
	{3417171968U, 24},
	{3407237888U, 24},
	{3360822272U, 24},
	{3358880256U, 24},
	{3354964224U, 24},
	{3335226112U, 24},
	{3328256256U, 24},
	{3326282496U, 24},
	{3228581376U, 24},
	{3225619712U, 24},
	{3631101696U, 24},
	{3624423680U, 24},
	{3542775808U, 24},
	{3531549696U, 24},
	{3517116928U, 24},
	{3509221888U, 24},
	{3444310016U, 24},
	{3407434496U, 24},
	{3350459648U, 24},
	{3254236928U, 24},
	{3253118464U, 24},
	{3624489216U, 24},
	{3542841344U, 24},
	{3529248256U, 24},
	{3518161664U, 24},
	{3504846592U, 24},
	{3498168576U, 24},
	{3486817024U, 24},
	{3480166400U, 24},
	{3474478848U, 24},
	{3421945088U, 24},
	{3414280704U, 24},
	{3406381568U, 24},
	{3357036544U, 24},
	{3332629760U, 24},
	{3245288960U, 24},
	{3236407040U, 24},
	{3229498880U, 24},
	{3228512000U, 24},
	{3628995840U, 24},
	{3509090816U, 24},
	{3485895168U, 24},
	{3475530752U, 24},
	{3464679168U, 24},
	{3463192832U, 24},
	{3420761088U, 24},
	{3414346240U, 24},
	{3409539328U, 24},
	{3354767616U, 24},
	{3333551104U, 24},
	{3324538112U, 24},
	{3269764352U, 24},
	{3231769344U, 24},
	{3635472896U, 24},
	{3537274368U, 24},
	{3449941504U, 24},
	{3400595456U, 24},
	{3391709440U, 24},
	{3359142400U, 24},
	{3336937728U, 24},
	{3333485568U, 24},
	{3232821760U, 24},
	{3227393024U, 24},
	{3641462784U, 24},
	{3543037952U, 24},
	{3493816832U, 24},
	{3464179712U, 24},
	{3451387648U, 24},
	{3438524928U, 24},
	{3398818304U, 24},
	{3360163072U, 24},
	{3356246272U, 24},
	{3349603328U, 24},
	{3282493440U, 24},
	{3273480960U, 24},
	{3252856320U, 24},
	{3222030592U, 24},
	{3631883776U, 24},
	{3560861184U, 24},
	{3498430720U, 24},
	{3490535680U, 24},
	{3469777408U, 24},
	{3413783808U, 24},
	{3346675968U, 24},
	{3330656000U, 24},
	{3252921856U, 24},
	{3229991168U, 24},
	{3228249856U, 24},
	{3226999808U, 24},
	{3226012928U, 24},
	{3641593856U, 24},
	{3513269760U, 24},
	{3453196544U, 24},
	{3407827712U, 24},
	{3389932288U, 24},
	{3360294144U, 24},
	{3359470080U, 24},
	{3326741248U, 24},
	{3255716608U, 24},
	{3223279616U, 24},
	{2299396096U, 16},
	{3522209536U, 24},
	{3465006848U, 24},
	{3426514432U, 24},
	{3407762176U, 24},
	{3399870720U, 24},
	{3390984704U, 24},
	{3360359680U, 24},
	{3358417664U, 24},
	{3249861376U, 24},
	{3230122240U, 24},
	{3226144000U, 24},
	{2299461632U, 16},
	{3589177600U, 24},
	{3430351104U, 24},
	{3408024320U, 24},
	{3333084672U, 24},
	{3326359552U, 24},
	{3264864512U, 24},
	{3226808064U, 24},
	{2301820928U, 16},
	{3590230016U, 24},
	{3514178560U, 24},
	{3466128640U, 24},
	{3449351680U, 24},
	{3447062528U, 24},
	{3413509632U, 24},
	{3399018752U, 24},
	{3394512128U, 24},
	{3393532928U, 24},
	{3356517120U, 24},
	{3355345408U, 24},
	{3338763520U, 24},
	{3273874176U, 24},
	{3224520960U, 24},
	{2870017280U, 24},
	{2869953024U, 24},
	{2869952512U, 16},
	{2301755392U, 16},
	{3560004864U, 24},
	{3521099264U, 24},
	{3492894976U, 24},
	{3467173376U, 24},
	{3466325248U, 24},
	{3459335936U, 24},
	{3454834944U, 24},
	{3394708736U, 24},
	{3357560832U, 24},
	{3355279872U, 24},
	{3330995200U, 24},
	{3263885312U, 24},
	{3234772480U, 24},
	{3224455424U, 24},
	{2870149120U, 16},
	{2301689856U, 16},
	{3628541440U, 24},
	{3506662144U, 24},
	{3482057984U, 24},
	{3437144832U, 24},
	{3406979072U, 24},
	{3399149824U, 24},
	{3360110080U, 24},
	{3338894592U, 24},
	{3335499776U, 24},
	{3322117120U, 24},
	{3230396928U, 24},
	{2552299520U, 16},
	{2301624320U, 16},
	{3652110592U, 24},
	{3412203264U, 24},
	{3286931200U, 24},
	{3257293312U, 24},
	{3237709056U, 24},
	{2870280192U, 16},
	{3627438336U, 24},
	{3559345152U, 24},
	{3506793216U, 24},
	{3499946752U, 24},
	{3493222656U, 24},
	{3466390784U, 24},
	{3407110144U, 24},
	{3406131456U, 24},
	{3398301696U, 24},
	{3334391552U, 24},
	{3286996736U, 24},
	{3255138304U, 24},
	{3238361856U, 24},
	{3224783104U, 24},
	{2302074880U, 19},
	{2302066688U, 19},
	{2302017536U, 16},
	{3642192384U, 24},
	{3499024896U, 24},
	{3461554432U, 24},
	{3451767808U, 24},
	{3428847616U, 24},
	{3428000512U, 24},
	{3393336320U, 24},
	{3389419520U, 24},
	{3355017728U, 24},
	{3342159360U, 24},
	{3337130496U, 24},
	{3328186880U, 24},
	{3324272128U, 24},
	{3236467712U, 24},
	{2870411264U, 16},
	{2552496128U, 16},
	{2301952000U, 16},
	{3642126848U, 24},
	{3484278528U, 24},
	{3470436608U, 24},
	{3454638336U, 24},
	{3448766208U, 24},
	{3411158016U, 24},
	{3407241216U, 24},
	{3323358464U, 24},
	{3233595648U, 24},
	{3224652032U, 24},
	{2301886464U, 16},
	{3638987776U, 24},
	{3519325952U, 24},
	{3502548480U, 24},
	{3487996672U, 24},
	{3466780160U, 24},
	{3446542592U, 24},
	{3431005696U, 24},
	{3418668288U, 24},
	{3407437824U, 24},
	{3406328064U, 24},
	{3399670272U, 24},
	{3392881408U, 24},
	{3326883840U, 24},
	{3259776000U, 24},
	{3253114112U, 24},
	{3224000512U, 24},
	{2870583296U, 24},
	{3639053312U, 24},
	{3520378368U, 24},
	{3518156800U, 24},
	{3501379840U, 24},
	{3480163072U, 24},
	{3463385600U, 24},
	{3432050432U, 24},
	{3414292736U, 24},
	{3398494464U, 24},
	{3357041408U, 24},
	{3353842432U, 24},
	{3338044160U, 24},
	{3332625920U, 24},
	{3263041280U, 24},
	{3234182656U, 24},
	{3226287616U, 24},
	{2870476800U, 16},
	{2302279680U, 16},
	{3499356928U, 24},
	{3488975360U, 24},
	{3485907200U, 24},
	{3429634048U, 24},
	{3419909120U, 24},
	{3414358272U, 24},
	{3407568896U, 24},
	{3397191424U, 24},
	{3357238016U, 24},
	{3346860544U, 24},
	{3245088000U, 24},
	{2870673408U, 16},
	{3520509440U, 24},
	{3449937152U, 24},
	{3430678784U, 24},
	{3409461760U, 24},
	{3407503360U, 24},
	{3394188288U, 24},
	{3391705600U, 24},
	{3333474048U, 24},
	{3289087488U, 24},
	{3287582208U, 24},
	{3240712448U, 24},
	{3229355264U, 24},
	{3227397888U, 24},
	{2552823808U, 16},
	{2302148608U, 16},
	{3629725440U, 24},
	{3625808640U, 24},
	{3499488000U, 24},
	{3450264832U, 24},
	{3434597632U, 24},
	{3429502976U, 24},
	{3424478976U, 24},
	{3407699968U, 24},
	{3359588608U, 24},
	{3356258816U, 24},
	{3327731968U, 24},
	{3253961728U, 24},
	{3641533184U, 24},
	{3632654848U, 24},
	{3512221184U, 24},
	{3499422464U, 24},
	{3486558208U, 24},
	{3469781248U, 24},
	{3406655744U, 24},
	{3396994816U, 24},
	{3394774272U, 24},
	{3358543872U, 24},
	{3330667520U, 24},
	{3326687232U, 24},
	{3289218560U, 24},
	{3260558592U, 24},
	{3250697984U, 24},
	{3233920512U, 24},
	{3230982912U, 24},
	{3228244992U, 24},
	{3226025472U, 24},
	{3515278080U, 24},
	{3509340416U, 24},
	{3502417408U, 24},
	{3491724032U, 24},
	{3482840064U, 24},
	{3453200896U, 24},
	{3407831040U, 24},
	{3393012480U, 24},
	{3389943808U, 24},
	{3359457536U, 24},
	{3357500160U, 24},
	{3356389888U, 24},
	{3352535040U, 24},
	{3257686528U, 24},
	{2870935552U, 16},
	{2302476288U, 16},
	{3639647488U, 24},
	{3558768384U, 24},
	{3507448576U, 24},
	{3484732928U, 24},
	{3453135360U, 24},
	{3430416640U, 24},
	{3418602752U, 24},
	{3407765504U, 24},
	{3394905344U, 24},
	{3360372224U, 24},
	{3358412800U, 24},
	{3357434624U, 24},
	{3333736192U, 24},
	{3269563904U, 24},
	{3239995904U, 24},
	{2870902784U, 24},
	{2870870016U, 24},
	{3623908096U, 24},
	{3513129984U, 24},
	{3486296064U, 24},
	{3418086144U, 24},
	{3406917888U, 24},
	{3358806016U, 24},
	{3334198784U, 24},
	{3330860288U, 24},
	{3325255168U, 24},
	{3264868352U, 24},
	{3227913472U, 24},
	{2553479168U, 16},
	{3649698304U, 24},
	{3633900032U, 24},
	{3468353024U, 24},
	{3466132480U, 24},
	{3461623808U, 24},
	{3449356032U, 24},
	{3405864960U, 24},
	{3393529088U, 24},
	{3359975168U, 24},
	{3288428288U, 24},
	{3250245888U, 24},
	{3227979008U, 24},
	{3222305280U, 24},
	{2553446400U, 24},
	{2553413632U, 24},
	{3648324864U, 24},
	{3560000512U, 24},
	{3473040384U, 24},
	{3465211136U, 24},
	{3454830592U, 24},
	{3431657216U, 24},
	{3423827456U, 24},
	{3407888896U, 24},
	{3390271488U, 24},
	{3357556992U, 24},
	{3355599616U, 24},
	{3350845184U, 24},
	{3334067712U, 24},
	{3248222976U, 24},
	{3224459264U, 24},
	{2300575744U, 16},
	{3628545792U, 24},
	{3499811328U, 24},
	{3489438464U, 24},
	{3459274240U, 24},
	{3452938752U, 24},
	{3428200960U, 24},
	{3413382912U, 24},
	{3399153664U, 24},
	{3398166784U, 24},
	{3360106240U, 24},
	{3357622528U, 24},
	{3350779648U, 24},
	{3343329280U, 24},
	{3338890240U, 24},
	{3230393088U, 24},
	{3225890560U, 24},
	{2300683520U, 24},
	{2300683776U, 24},
	{2300641280U, 16},
	{3526838784U, 24},
	{3449683712U, 24},
	{3439040512U, 24},
	{3412198912U, 24},
	{3409400576U, 24},
	{3286926848U, 24},
	{3629131264U, 24},
	{3559349504U, 24},
	{3542571520U, 24},
	{3489307392U, 24},
	{3473236992U, 24},
	{3412264448U, 24},
	{3407114496U, 24},
	{3398297856U, 24},
	{3392557568U, 24},
	{3390337024U, 24},
	{3351879680U, 24},
	{3334395392U, 24},
	{3333408512U, 24},
	{3327145984U, 24},
	{3251217920U, 24},
	{3233730560U, 24},
	{3231511040U, 24},
	{2301034496U, 16},
	{3640232960U, 24},
	{3499029248U, 24},
	{3476379392U, 24},
	{3421015552U, 24},
	{3407311104U, 24},
	{3389415680U, 24},
	{3356979712U, 24},
	{3355022080U, 24},
	{3227520256U, 24},
	{3223603456U, 24},
	{2300837888U, 16},
	{2300842496U, 24},
	{2300866048U, 24},
	{3639188736U, 24},
	{3512802304U, 24},
	{3491129856U, 24},
	{3477282816U, 24},
	{3448761856U, 24},
	{3407245568U, 24},
	{3395356416U, 24},
	{3360830976U, 24},
	{3353969152U, 24},
	{3333277440U, 24},
	{3326290176U, 24},
	{3323362304U, 24},
	{3276946688U, 24},
	{3224655872U, 24},
	{2553554944U, 21},
	{2553553920U, 24},
	{2553554176U, 24},
	{2553554432U, 24},
	{2553554688U, 24},
	{2553552896U, 22},
	{2553556992U, 23},
	{2553544704U, 16},
	{2553552384U, 24},
	{2553552640U, 24},
	{2300952576U, 20},
	{2300903424U, 16},
	{3638992128U, 24},
	{3628873472U, 24},
	{3498111744U, 24},
	{3491326464U, 24},
	{3487992320U, 24},
	{3471215360U, 24},
	{3449998336U, 24},
	{3446538240U, 24},
	{3397445888U, 24},
	{3392885248U, 24},
	{3359330304U, 24},
	{3353772544U, 24},
	{3346995968U, 24},
	{3333674496U, 24},
	{3326880000U, 24},
	{3263226112U, 24},
	{3259772160U, 24},
	{3253109760U, 24},
	{3628939008U, 24},
	{3520374528U, 24},
	{3518152960U, 24},
	{3482385664U, 24},
	{3480158720U, 24},
	{3414288384U, 24},
	{3407376640U, 24},
	{3356058368U, 24},
	{3335827456U, 24},
	{3263045120U, 24},
	{3249721600U, 24},
	{3236398336U, 24},
	{3234178816U, 24},
	{3227270656U, 24},
	{3225049088U, 24},
	{2301296640U, 16},
	{3650349824U, 24},
	{3531410944U, 24},
	{3520571136U, 24},
	{3518087424U, 24},
	{3516130048U, 24},
	{3499352576U, 24},
	{3471084288U, 24},
	{3409531648U, 24},
	{3398694912U, 24},
	{3337982464U, 24},
	{3336864512U, 24},
	{3331585024U, 24},
	{3264475136U, 24},
	{3231760640U, 24},
	{3230921216U, 24},
	{3631027456U, 24},
	{3630048768U, 24},
	{3542702592U, 24},
	{3531345408U, 24},
	{3491392000U, 24},
	{3465739264U, 24},
	{3448962816U, 24},
	{3407507712U, 24},
	{3406520320U, 24},
	{3332491008U, 24},
	{3239738112U, 24},
	{3230855680U, 24},
	{3229868800U, 24},
	{3229359104U, 24},
	{3228372224U, 24},
	{3227401728U, 24},
	{3628611328U, 24},
	{3531279872U, 24},
	{3516261120U, 24},
	{3493808128U, 24},
	{3492698368U, 24},
	{3481594880U, 24},
	{3464172032U, 24},
	{3424482816U, 24},
	{3389808896U, 24},
	{3359592448U, 24},
	{3356254976U, 24},
	{3286402560U, 24},
	{3272370176U, 24},
	{3244952576U, 24},
	{2554265600U, 16},
	{3632659200U, 24},
	{3509540864U, 24},
	{3481660416U, 24},
	{3450326016U, 24},
	{3413776128U, 24},
	{3407638784U, 24},
	{3393081856U, 24},
	{3326683392U, 24},
	{3250693632U, 24},
	{2554200064U, 16},
	{2301558784U, 16},
	{3559677184U, 24},
	{3492567296U, 24},
	{3473826816U, 24},
	{3406716928U, 24},
	{3393016320U, 24},
	{3352539392U, 24},
	{3336602368U, 24},
	{3333805568U, 24},
	{3326748928U, 24},
	{3258800640U, 24},
	{3248799744U, 24},
	{3228044544U, 24},
	{2554195968U, 20},
	{2554134528U, 16},
	{2301362176U, 16},
	{3639643136U, 24},
	{3564636160U, 24},
	{3531083264U, 24},
	{3516326656U, 24},
	{3455097088U, 24},
	{3365337600U, 24},
	{3358408960U, 24},
	{3357438464U, 24},
	{3337654784U, 24},
	{3325844992U, 24},
	{3269560064U, 24},
	{3261665024U, 24},
	{3234047744U, 24},
	{3231117824U, 24},
	{3230130944U, 24},
	{3223222784U, 24},
	{2301427712U, 16},
	{3629469952U, 24},
	{3531045120U, 24},
	{3476234240U, 24},
	{3422545920U, 24},
	{3367743232U, 24},
	{3359920128U, 24},
	{3357685248U, 24},
	{3331949312U, 24},
	{2304049152U, 16},
	{3607169792U, 24},
	{3561311232U, 24},
	{3486375680U, 24},
	{3449325568U, 24},
	{3415772672U, 24},
	{3359985664U, 24},
	{3355370496U, 24},
	{3276102400U, 24},
	{3222277376U, 24},
	{2303983616U, 16},
	{3566964992U, 24},
	{3505185280U, 24},
	{3486441216U, 24},
	{3459326208U, 24},
	{3422414848U, 24},
	{3413467136U, 24},
	{3411493376U, 24},
	{3407885568U, 24},
	{3407021568U, 24},
	{3325110528U, 24},
	{3280639744U, 24},
	{3258002688U, 24},
	{2304180224U, 16},
	{3633024000U, 24},
	{3556569088U, 24},
	{3515581696U, 24},
	{3476037632U, 24},
	{3452951808U, 24},
	{3432679680U, 24},
	{3429201408U, 24},
	{3425706752U, 24},
	{3407951104U, 24},
	{3406956032U, 24},
	{3357619712U, 24},
	{3343343360U, 24},
	{3264907008U, 24},
	{3254575616U, 24},
	{3230372864U, 24},
	{3226880256U, 24},
	{2554789888U, 16},
	{2304114688U, 16},
	{3635326464U, 24},
	{3521831680U, 24},
	{3439062784U, 24},
	{3437952512U, 24},
	{3413336064U, 24},
	{3409388544U, 24},
	{3407152640U, 24},
	{3398213120U, 24},
	{3351224320U, 24},
	{3345120512U, 24},
	{3338935040U, 24},
	{3254510080U, 24},
	{2303787008U, 16},
	{3644932352U, 24},
	{3637102592U, 24},
	{3631379200U, 24},
	{3585057536U, 24},
	{3559336448U, 24},
	{3511703552U, 24},
	{3499922688U, 24},
	{3492228608U, 24},
	{3489328128U, 24},
	{3484399872U, 24},
	{3345186048U, 24},
	{3343928832U, 24},
	{3334381824U, 24},
	{3333402624U, 24},
	{3280836352U, 24},
	{3270242304U, 24},
	{3265038080U, 24},
	{3253465856U, 24},
	{3232740864U, 24},
	{3231483136U, 24},
	{3226487040U, 24},
	{3224776448U, 24},
	{3222539520U, 24},
	{3221560320U, 24},
	{2554396672U, 16},
	{2303721472U, 16},
	{3637168128U, 24},
	{3555254528U, 24},
	{3511900160U, 24},
	{3453733888U, 24},
	{3394454272U, 24},
	{3356951808U, 24},
	{3355042816U, 24},
	{3349119488U, 24},
	{3335181824U, 24},
	{3253269248U, 24},
	{3222736128U, 24},
	{2554462208U, 16},
	{2303918080U, 16},
	{3586901248U, 24},
	{3526638848U, 24},
	{3505976064U, 24},
	{3504001280U, 24},
	{3484268800U, 24},
	{3473347328U, 24},
	{3434916608U, 24},
	{3422087168U, 24},
	{3417160960U, 24},
	{3399388928U, 24},
	{3391435776U, 24},
	{3354977280U, 24},
	{3350049024U, 24},
	{3323333376U, 24},
	{3278923776U, 24},
	{2554583808U, 24},
	{2554584064U, 22},
	{2554580992U, 24},
	{2554579456U, 24},
	{2554592256U, 24},
	{2554585088U, 23},
	{2554560512U, 21},
	{2554574080U, 24},
	{2554546944U, 24},
	{2554554880U, 24},
	{2554554624U, 24},
	{2554553088U, 24},
	{2554554112U, 24},
	{2554553856U, 24},
	{2554553600U, 24},
	{2554553344U, 24},
	{2554531072U, 24},
	{2554527744U, 16},
	{2303852544U, 16},
	{3520450560U, 24},
	{3481232384U, 24},
	{3475648768U, 24},
	{3455577600U, 24},
	{3449993984U, 24},
	{3435453440U, 24},
	{3420911872U, 24},
	{3418675968U, 24},
	{3415313920U, 24},
	{3397345536U, 24},
	{3342542848U, 24},
	{3253138176U, 24},
	{3226228736U, 24},
	{2555117568U, 16},
	{2304573440U, 16},
	{3637827840U, 24},
	{3529267968U, 24},
	{3522621952U, 24},
	{3482356224U, 24},
	{3437755904U, 24},
	{3418741504U, 24},
	{3411821056U, 24},
	{3407349248U, 24},
	{3354846208U, 24},
	{3338069248U, 24},
	{3335833344U, 24},
	{3332616192U, 24},
	{3253203712U, 24},
	{3249710592U, 24},
	{3239578624U, 24},
	{2555183104U, 16},
	{2304548864U, 24},
	{2304507904U, 16},
	{3633552640U, 24},
	{3624535040U, 24},
	{3559401984U, 24},
	{3520581632U, 24},
	{3458740224U, 24},
	{3450972672U, 24},
	{3410907904U, 24},
	{3406436096U, 24},
	{3392742656U, 24},
	{3325634816U, 24},
	{3287670784U, 24},
	{2555248640U, 16},
	{2304704512U, 16},
	{3645849856U, 24},
	{3520516096U, 24},
	{3512621056U, 24},
	{3508149248U, 24},
	{3453406208U, 24},
	{3430704896U, 24},
	{3427750912U, 24},
	{3424256256U, 24},
	{3409454080U, 24},
	{3407480320U, 24},
	{3395175168U, 24},
	{3392677120U, 24},
	{3275238400U, 24},
	{3257482240U, 24},
	{3245177600U, 24},
	{3241684480U, 24},
	{3240705792U, 24},
	{3227404544U, 24},
	{2555314176U, 16},
	{2304696320U, 16},
	{3664404480U, 24},
	{3531307264U, 24},
	{3516240896U, 24},
	{3510582784U, 24},
	{3460243712U, 24},
	{3445179392U, 24},
	{3428402432U, 24},
	{3426689792U, 24},
	{3414466304U, 24},
	{3406567168U, 24},
	{3394847488U, 24},
	{3361292544U, 24},
	{3346754560U, 24},
	{3327741696U, 24},
	{3263469056U, 24},
	{2554855424U, 16},
	{2304311296U, 16},
	{3632630784U, 24},
	{3631903488U, 24},
	{3630916096U, 24},
	{3512227840U, 24},
	{3406632704U, 24},
	{3394781952U, 24},
	{3390834432U, 24},
	{3354584064U, 24},
	{3333857536U, 24},
	{3330642432U, 24},
	{3249972736U, 24},
	{3242809600U, 24},
	{3233927168U, 24},
	{2554920960U, 16},
	{2304245760U, 16},
	{3458138880U, 24},
	{3407808000U, 24},
	{3406698240U, 24},
	{3398930176U, 24},
	{3389920768U, 24},
	{3361423616U, 24},
	{3359450880U, 24},
	{3357476096U, 24},
	{3352544768U, 24},
	{3333792000U, 24},
	{3331818240U, 24},
	{3227207936U, 24},
	{2554986496U, 16},
	{2304442368U, 16},
	{3531110656U, 24},
	{3524201984U, 24},
	{3507424512U, 24},
	{3487694080U, 24},
	{3463017472U, 24},
	{3449194496U, 24},
	{3428467968U, 24},
	{3411689984U, 24},
	{3406763776U, 24},
	{3360378880U, 24},
	{3345579264U, 24},
	{3333726464U, 24},
	{3229117184U, 24},
	{3226163200U, 24},
	{2555052032U, 16},
	{2304376832U, 16},
	{3518736128U, 24},
	{3504193536U, 24},
	{3423670272U, 24},
	{3408012288U, 24},
	{3406894848U, 24},
	{3394589184U, 24},
	{3359916288U, 24},
	{3349848064U, 24},
	{3331953152U, 24},
	{3264845312U, 24},
	{3261491456U, 24},
	{3254776576U, 24},
	{3230172416U, 24},
	{2555741440U, 24},
	{2555707392U, 16},
	{2555708160U, 24},
	{2555707904U, 24},
	{2555718144U, 24},
	{2302935040U, 16},
	{3695531264U, 24},
	{3574597888U, 24},
	{3504128000U, 24},
	{3449329920U, 24},
	{3389064960U, 24},
	{3359981824U, 24},
	{3328666880U, 24},
	{3226753024U, 24},
	{2555641856U, 16},
	{2303057152U, 24},
	{2303057408U, 23},
	{2303056128U, 24},
	{2303056384U, 24},
	{2303053824U, 20},
	{2303062016U, 24},
	{2303036416U, 22},
	{2303034880U, 23},
	{2303040512U, 24},
	{2303039488U, 22},
	{2303038976U, 23},
	{2303019008U, 22},
	{2303028224U, 23},
	{2303028736U, 23},
	{2303027200U, 22},
	{2303025152U, 21},
	{2303032320U, 24},
	{2303032576U, 24},
	{2303032832U, 24},
	{2303033088U, 24},
	{2303031552U, 24},
	{2303031808U, 24},
	{2303032064U, 24},
	{2303030528U, 24},
	{2303030784U, 23},
	{2303029248U, 22},
	{2303000576U, 16},
	{2303010816U, 21},
	{2303012864U, 20},
	{3641902336U, 24},
	{3506299392U, 24},
	{3487555328U, 24},
	{3486436864U, 24},
	{3480581376U, 24},
	{3423801344U, 24},
	{3407881216U, 24},
	{3407025920U, 24},
	{3394720256U, 24},
	{3350835456U, 24},
	{3334057984U, 24},
	{3330966272U, 24},
	{3285107200U, 24},
	{3280635392U, 24},
	{3258006528U, 24},
	{2555838464U, 16},
	{3547621632U, 24},
	{3530844160U, 24},
	{3498808576U, 24},
	{3489864960U, 24},
	{3454922240U, 24},
	{3450448384U, 24},
	{3437157376U, 24},
	{3415908096U, 24},
	{3406960384U, 24},
	{3357615872U, 24},
	{3355641088U, 24},
	{3350769920U, 24},
	{3338466304U, 24},
	{3288533248U, 24},
	{3264910848U, 24},
	{3254579968U, 24},
	{3230369024U, 24},
	{3228858880U, 24},
	{2555806976U, 24},
	{2555772928U, 16},
	{2303189504U, 23},
	{2303188992U, 23},
	{2303131648U, 16},
	{2303138048U, 24},
	{2303137536U, 24},
	{3586106112U, 24},
	{3418340608U, 24},
	{3413340416U, 24},
	{3398209280U, 24},
	{3360772096U, 24},
	{2555445248U, 16},
	{3631374848U, 24},
	{3585061376U, 24},
	{3489332480U, 24},
	{3483147008U, 24},
	{3406104064U, 24},
	{3389327104U, 24},
	{3351163136U, 24},
	{3343933184U, 24},
	{3339983616U, 24},
	{3253461504U, 24},
	{3225504000U, 24},
	{2555379712U, 16},
	{2302738432U, 16},
	{3587949824U, 24},
	{3407288064U, 24},
	{3335177984U, 24},
	{3323402752U, 24},
	{3286818816U, 24},
	{3241492224U, 24},
	{2555576320U, 16},
	{2302803968U, 16},
	{3639212800U, 24},
	{3627296256U, 24},
	{3407222528U, 24},
	{3323337216U, 24},
	{3628880128U, 24},
	{3585319680U, 24},
	{3583082752U, 24},
	{3520446720U, 24},
	{3491302400U, 24},
	{3483543552U, 24},
	{3464530688U, 24},
	{3429787392U, 24},
	{3418671616U, 24},
	{3415318272U, 24},
	{3393995520U, 24},
	{3229648128U, 24},
	{2556231680U, 16},
	{2303480064U, 16},
	{2303460864U, 16},
	{2303460096U, 16},
	{2303459840U, 16},
	{2303461376U, 16},
	{2303466496U, 16},
	{2303467264U, 16},
	{2303466240U, 16},
	{2303474688U, 16},
	{3659007488U, 24},
	{3482360576U, 24},
	{3480183808U, 24},
	{3464596224U, 24},
	{3430839808U, 24},
	{3407353600U, 24},
	{3395047936U, 24},
	{3359258112U, 24},
	{3354850560U, 24},
	{3352614656U, 24},
	{3341494272U, 24},
	{3253199360U, 24},
	{3226290432U, 24},
	{2556166144U, 16},
	{2303589888U, 24},
	{2303557632U, 17},
	{2303524864U, 17},
	{3633548288U, 24},
	{3629011200U, 24},
	{3585188608U, 24},
	{3576183296U, 24},
	{3520577792U, 24},
	{3514995712U, 24},
	{3454332416U, 24},
	{3410903552U, 24},
	{3389654784U, 24},
	{3365973760U, 24},
	{3332415744U, 24},
	{3287675136U, 24},
	{2556362752U, 16},
	{2303590400U, 16},
	{3639929344U, 24},
	{3635457536U, 24},
	{3430708736U, 24},
	{3399593216U, 24},
	{3395179008U, 24},
	{3354719488U, 24},
	{3334981376U, 24},
	{3275242752U, 24},
	{3266360320U, 24},
	{3230831616U, 24},
	{3229383168U, 24},
	{2556297216U, 16},
	{2303655936U, 16},
	{3568804352U, 24},
	{3516237056U, 24},
	{3479856128U, 24},
	{3431237888U, 24},
	{3414461952U, 24},
	{3406562816U, 24},
	{3393733376U, 24},
	{3390903808U, 24},
	{3289123072U, 24},
	{3231028224U, 24},
	{3224252160U, 24},
	{3631899136U, 24},
	{3630920448U, 24},
	{3628683520U, 24},
	{3535184896U, 24},
	{3468081152U, 24},
	{3450317312U, 24},
	{3436239872U, 24},
	{3429590784U, 24},
	{3420710912U, 24},
	{3359520256U, 24},
	{3358533376U, 24},
	{3354588416U, 24},
	{3337810944U, 24},
	{3332874496U, 24},
	{3331625472U, 24},
	{3327680000U, 24},
	{3326693120U, 24},
	{3250700288U, 24},
	{3233923328U, 24},
	{3230962688U, 24},
	{2555904000U, 16},
	{2303262720U, 16},
	{3641578496U, 24},
	{3629858816U, 24},
	{3511310336U, 24},
	{3505512960U, 24},
	{3486768896U, 24},
	{3471965184U, 24},
	{3431368960U, 24},
	{3407812352U, 24},
	{3398934016U, 24},
	{3391890688U, 24},
	{3391034880U, 24},
	{3361427456U, 24},
	{3359454720U, 24},
	{3357479936U, 24},
	{3349454848U, 24},
	{3346627840U, 24},
	{3345509376U, 24},
	{3323927040U, 24},
	{3275570432U, 24},
	{3257675008U, 24},
	{3228068608U, 24},
	{2556100608U, 16},
	{3568607744U, 24},
	{3558737920U, 24},
	{3507428352U, 24},
	{3503472640U, 24},
	{3474854656U, 24},
	{3473867264U, 24},
	{3453148416U, 24},
	{3360375040U, 24},
	{3322874624U, 24},
	{3257740544U, 24},
	{2303393792U, 16},
	{3493010688U, 24},
	{3434842368U, 24},
	{3425894656U, 24},
	{3408008960U, 24},
	{3406898176U, 24},
	{3325233920U, 24},
	{3283846656U, 24},
	{3261487616U, 24},
	{3259267072U, 24},
	{2556821504U, 16},
	{3695535616U, 24},
	{3667442944U, 24},
	{3560052992U, 24},
	{3519931136U, 24},
	{3518665728U, 24},
	{3486383360U, 24},
	{3467352576U, 24},
	{3452829440U, 24},
	{3358721280U, 24},
	{3325168384U, 24},
	{3224505600U, 24},
	{2556887040U, 16},
	{2306273280U, 20},
	{2306268160U, 22},
	{2306267136U, 22},
	{2306266112U, 22},
	{2306265088U, 22},
	{2306264064U, 22},
	{2306263040U, 22},
	{2306262016U, 22},
	{2306260992U, 22},
	{2306259968U, 22},
	{2306258944U, 22},
	{2306211840U, 16},
	{3641914880U, 24},
	{3589063936U, 24},
	{3512171008U, 24},
	{3506581248U, 24},
	{3499865856U, 24},
	{3423806208U, 24},
	{3411501056U, 24},
	{3338520320U, 24},
	{3335451648U, 24},
	{3330977792U, 24},
	{3274771968U, 24},
	{3240107264U, 24},
	{3235898112U, 24},
	{3230316032U, 24},
	{3634990080U, 24},
	{3491826688U, 24},
	{3459252992U, 24},
	{3454917888U, 24},
	{3357611008U, 24},
	{3230381568U, 24},
	{3222417152U, 24},
	{2556786432U, 24},
	{2556786176U, 24},
	{2556784896U, 24},
	{2556782848U, 24},
	{2556783104U, 24},
	{2556779776U, 24},
	{2556776448U, 24},
	{2556776448U, 23},
	{2556774656U, 24},
	{2556772352U, 24},
	{2556765696U, 24},
	{2556764160U, 24},
	{2556758272U, 24},
	{2556757248U, 24},
	{2556756992U, 23},
	{2556755968U, 16},
	{2556756480U, 24},
	{3631436032U, 24},
	{3412218624U, 24},
	{3407160320U, 24},
	{3400441344U, 24},
	{3394330880U, 24},
	{3274055424U, 24},
	{3245557760U, 24},
	{3237724416U, 24},
	{2556559360U, 16},
	{3640318208U, 24},
	{3513931776U, 24},
	{3506777856U, 24},
	{3489320448U, 24},
	{3488341760U, 24},
	{3483150336U, 24},
	{3468593920U, 24},
	{3418263040U, 24},
	{3411042304U, 24},
	{3407094784U, 24},
	{3358983424U, 24},
	{3351901440U, 24},
	{3343936512U, 24},
	{3337344512U, 24},
	{3284043264U, 24},
	{3261291008U, 24},
	{3247290112U, 24},
	{3238346496U, 24},
	{2556674048U, 18},
	{2556624896U, 17},
	{2556624896U, 16},
	{3555246848U, 24},
	{3515787008U, 24},
	{3461571840U, 24},
	{3443685120U, 24},
	{3407291392U, 24},
	{3401420544U, 24},
	{3394461952U, 24},
	{3359797760U, 24},
	{3356960512U, 24},
	{3355035136U, 24},
	{3349127168U, 24},
	{3337147904U, 24},
	{3227539456U, 24},
	{3223591936U, 24},
	{2556428288U, 16},
	{2305884160U, 16},
	{3638229760U, 24},
	{3627291904U, 24},
	{3486252288U, 24},
	{3454655744U, 24},
	{3424980992U, 24},
	{3323341056U, 24},
	{3287859712U, 24},
	{3286881024U, 24},
	{3268145152U, 24},
	{3262139136U, 24},
	{3234591232U, 24},
	{3233580288U, 24},
	{2556493824U, 16},
	{2305851392U, 16},
	{2305818624U, 16},
	{3628884480U, 24},
	{3563998208U, 24},
	{3523750912U, 24},
	{3505901824U, 24},
	{3484649984U, 24},
	{3477894400U, 24},
	{3432098560U, 24},
	{3426418944U, 24},
	{3418683648U, 24},
	{3415321600U, 24},
	{3407422464U, 24},
	{3400765184U, 24},
	{3359311104U, 24},
	{3328011520U, 24},
	{3322427392U, 24},
	{3245234432U, 24},
	{2557345792U, 16},
	{3560577280U, 24},
	{3523816448U, 24},
	{3517154560U, 24},
	{3510246400U, 24},
	{3502629376U, 24},
	{3428607744U, 24},
	{3411828736U, 24},
	{3407356928U, 24},
	{3358266368U, 24},
	{3357026048U, 24},
	{3356046848U, 24},
	{3342469632U, 24},
	{3335841024U, 24},
	{3332608512U, 24},
	{3249701888U, 24},
	{3245299968U, 24},
	{3240828160U, 24},
	{3237396736U, 24},
	{2557440000U, 20},
	{2557411328U, 16},
	{3642439168U, 24},
	{3638872064U, 24},
	{3520590336U, 24},
	{3502694912U, 24},
	{3485924608U, 24},
	{3407553536U, 24},
	{3398675712U, 24},
	{3353663232U, 24},
	{3332411904U, 24},
	{3331563776U, 24},
	{3325627136U, 24},
	{3287663104U, 24},
	{3245103360U, 24},
	{3241741312U, 24},
	{3228325888U, 24},
	{2557214720U, 16},
	{2306703360U, 17},
	{2306686976U, 18},
	{2306682880U, 21},
	{2306685952U, 22},
	{2306684928U, 22},
	{2306685696U, 24},
	{2306678784U, 20},
	{2306670592U, 19},
	{2306670592U, 16},
	{3409446400U, 24},
	{3407488000U, 24},
	{3350233600U, 24},
	{3289070080U, 24},
	{3287597568U, 24},
	{3259987968U, 24},
	{3245168896U, 24},
	{3239718400U, 24},
	{3232793856U, 24},
	{2306605056U, 16},
	{3516249600U, 24},
	{3504521216U, 24},
	{3479852800U, 24},
	{3468135168U, 24},
	{3407684608U, 24},
	{3397075712U, 24},
	{3390907648U, 24},
	{2557083648U, 16},
	{2306539520U, 16},
	{3632639488U, 24},
	{3631894784U, 24},
	{3469798656U, 24},
	{3419465728U, 24},
	{3407619072U, 24},
	{3359507712U, 24},
	{3333849856U, 24},
	{3327683840U, 24},
	{3326704640U, 24},
	{3325954816U, 24},
	{3324975616U, 24},
	{3289201152U, 24},
	{3253911552U, 24},
	{3230967552U, 24},
	{3227020032U, 24},
	{2557149184U, 16},
	{2306473984U, 16},
	{3524144128U, 24},
	{3488730624U, 24},
	{3470843392U, 24},
	{3425439744U, 24},
	{3418552576U, 24},
	{3394986240U, 24},
	{3361432320U, 24},
	{3359442176U, 24},
	{3357484800U, 24},
	{3352552448U, 24},
	{3350561280U, 24},
	{3345506048U, 24},
	{3331825920U, 24},
	{3257671168U, 24},
	{2557014016U, 22},
	{2557017088U, 22},
	{2557010944U, 22},
	{2557001728U, 18},
	{2556994560U, 22},
	{2556996608U, 22},
	{2556992512U, 22},
	{2556985344U, 18},
	{2556985344U, 17},
	{2556987136U, 24},
	{2556977152U, 19},
	{2556968960U, 19},
	{2556952576U, 18},
	{2556952576U, 16},
	{2306473472U, 24},
	{2306441216U, 17},
	{2306408448U, 17},
	{2306408448U, 16},
	{3505443072U, 24},
	{3498550784U, 24},
	{3493600512U, 24},
	{3474857984U, 24},
	{3437353984U, 24},
	{3428476672U, 24},
	{3411697664U, 24},
	{3407750144U, 24},
	{3349517056U, 24},
	{3333718784U, 24},
	{3267620864U, 24},
	{3231098624U, 24},
	{2557018112U, 16},
	{2306342912U, 16},
	{3638422016U, 24},
	{3509783808U, 24},
	{3475112448U, 24},
	{3408004608U, 24},
	{3406902528U, 24},
	{3405784064U, 24},
	{3359924992U, 24},
	{3344268544U, 24},
	{3261483776U, 24},
	{3258129920U, 24},
	{3231299072U, 24},
	{3227928832U, 24},
	{2557935616U, 16},
	{3574606592U, 24},
	{3489742592U, 24},
	{3486379008U, 24},
	{3449338624U, 24},
	{3408070144U, 24},
	{3405699584U, 24},
	{3393544448U, 24},
	{3359990528U, 24},
	{3355367168U, 24},
	{3324185344U, 24},
	{3257077504U, 24},
	{3225774848U, 24},
	{3224509440U, 24},
	{2557870080U, 16},
	{2305228800U, 16},
	{3639400704U, 24},
	{3634081280U, 24},
	{3512167168U, 24},
	{3499861504U, 24},
	{3490917888U, 24},
	{3407873536U, 24},
	{3407033600U, 24},
	{3394727936U, 24},
	{3280643072U, 24},
	{3235901952U, 24},
	{3224443904U, 24},
	{2557804544U, 16},
	{2305091072U, 24},
	{2305096960U, 24},
	{2305096704U, 24},
	{2305097216U, 24},
	{2305095680U, 23},
	{2305096448U, 24},
	{2305096192U, 24},
	{2305068032U, 24},
	{2305068544U, 24},
	{2305067264U, 24},
	{2305067008U, 24},
	{2305067520U, 24},
	{2305066240U, 24},
	{2305065984U, 24},
	{2305066752U, 24},
	{2305066496U, 24},
	{2305069056U, 24},
	{2305069568U, 24},
	{2305060608U, 24},
	{2305059072U, 24},
	{2305059584U, 24},
	{2305058048U, 24},
	{2305058560U, 24},
	{2305057024U, 24},
	{2305057536U, 24},
	{2305064192U, 24},
	{2305063936U, 24},
	{2305064448U, 24},
	{2305063168U, 24},
	{2305062144U, 24},
	{2305061888U, 24},
	{2305062656U, 24},
	{2305062400U, 24},
	{2305061120U, 24},
	{2305061632U, 24},
	{2305055744U, 22},
	{2305054720U, 24},
	{2305055488U, 24},
	{2305055232U, 24},
	{2305053696U, 24},
	{2305054208U, 24},
	{2305052672U, 24},
	{2305053184U, 24},
	{2305032192U, 18},
	{2305032192U, 16},
	{3633037056U, 24},
	{3547613952U, 24},
	{3506650624U, 24},
	{3476034304U, 24},
	{3463730688U, 24},
	{3452956160U, 24},
	{3413398272U, 24},
	{3407939072U, 24},
	{3406968064U, 24},
	{3398151424U, 24},
	{3360121600U, 24},
	{3230377728U, 24},
	{3228850176U, 24},
	{3225905920U, 24},
	{3223391488U, 24},
	{2305097728U, 16},
	{3642042112U, 24},
	{3631431680U, 24},
	{3629212160U, 24},
	{3523493120U, 24},
	{3518989568U, 24},
	{3515659776U, 24},
	{3489939200U, 24},
	{3484322304U, 24},
	{3482101760U, 24},
	{3409385216U, 24},
	{3400437504U, 24},
	{3331105024U, 24},
	{3259001088U, 24},
	{3258392064U, 24},
	{2557735424U, 23},
	{2557673472U, 17},
	{2304909312U, 17},
	{3640313856U, 24},
	{3636366336U, 24},
	{3513927936U, 24},
	{3477169152U, 24},
	{3432823296U, 24},
	{3412279808U, 24},
	{3407099136U, 24},
	{3350168064U, 24},
	{3343940864U, 24},
	{3337340672U, 24},
	{3324447488U, 24},
	{3265049600U, 24},
	{3261287168U, 24},
	{3235443200U, 24},
	{3221565184U, 24},
	{2557607936U, 16},
	{2304966656U, 16},
	{3555250688U, 24},
	{3515790848U, 24},
	{3451754752U, 24},
	{3438926848U, 24},
	{3407295744U, 24},
	{3356964352U, 24},
	{3325368832U, 24},
	{3233649664U, 24},
	{3222748672U, 24},
	{2873253888U, 24},
	{2557542400U, 16},
	{3629277696U, 24},
	{3507891968U, 24},
	{3505963008U, 24},
	{3438861312U, 24},
	{3413136128U, 24},
	{3328265984U, 24},
	{3251364352U, 24},
	{3250361600U, 24},
	{3233584128U, 24},
	{3226630656U, 24},
	{3225643776U, 24},
	{2557476864U, 16},
	{2304900096U, 24},
	{2304835584U, 16},
	{3628888832U, 24},
	{3564002560U, 24},
	{3479008512U, 24},
	{3470130176U, 24},
	{3432102400U, 24},
	{3418679296U, 24},
	{3415325952U, 24},
	{3273211136U, 24},
	{3255315712U, 24},
	{3254243584U, 24},
	{3253125120U, 24},
	{3229656832U, 24},
	{2305687552U, 16},
	{3418744832U, 24},
	{3407361280U, 24},
	{3359249408U, 24},
	{3356043008U, 24},
	{3354842880U, 24},
	{3333591552U, 24},
	{3256368128U, 24},
	{3234194176U, 24},
	{2305753088U, 16},
	{3642435328U, 24},
	{3632447232U, 24},
	{3520586496U, 24},
	{3515004416U, 24},
	{3512691456U, 24},
	{3493399552U, 24},
	{3475505664U, 24},
	{3466627840U, 24},
	{3437546752U, 24},
	{3425173760U, 24},
	{3409516288U, 24},
	{3406439424U, 24},
	{3400637952U, 24},
	{3394134272U, 24},
	{3358065920U, 24},
	{3337999872U, 24},
	{3333526016U, 24},
	{3287667456U, 24},
	{3237335040U, 24},
	{3231745280U, 24},
	{2305556480U, 16},
	{3635448832U, 24},
	{3560441856U, 24},
	{3526888960U, 24},
	{3475571200U, 24},
	{3465721856U, 24},
	{3430700032U, 24},
	{3409450752U, 24},
	{3358131456U, 24},
	{3324578560U, 24},
	{3287601920U, 24},
	{3266352640U, 24},
	{3259984128U, 24},
	{3228387584U, 24},
	{2305622016U, 16},
	{3638745344U, 24},
	{3628626688U, 24},
	{3524017408U, 24},
	{3492683008U, 24},
	{3468139008U, 24},
	{3448023552U, 24},
	{3406570496U, 24},
	{3404978688U, 24},
	{3390911488U, 24},
	{3345632768U, 24},
	{3289131776U, 24},
	{2873622528U, 16},
	{2558197760U, 16},
	{3630911744U, 24},
	{3535925504U, 24},
	{3505569792U, 24},
	{3487813120U, 24},
	{3436248576U, 24},
	{3429582080U, 24},
	{3406636032U, 24},
	{3390845952U, 24},
	{3358524672U, 24},
	{3356305152U, 24},
	{3272420352U, 24},
	{3227023872U, 24},
	{2873737216U, 24},
	{2558132224U, 16},
	{3492551936U, 24},
	{3473809408U, 24},
	{3466049536U, 24},
	{3434452992U, 24},
	{3427428096U, 24},
	{3407820032U, 24},
	{3406701568U, 24},
	{3397823744U, 24},
	{3391883008U, 24},
	{3352556800U, 24},
	{3349447168U, 24},
	{3345501696U, 24},
	{3262732800U, 24},
	{3240050432U, 24},
	{2558066688U, 16},
	{2305294336U, 16},
	{3507437056U, 24},
	{3428480512U, 24},
	{3399847680U, 24},
	{3358393600U, 24},
	{3324840704U, 24},
	{3641829376U, 24},
	{3638371584U, 24},
	{3454927616U, 24},
	{3434829568U, 24},
	{3427051520U, 24},
	{3408054528U, 24},
	{3359943680U, 24},
	{3325285632U, 24},
	{3323066112U, 24},
	{3261498368U, 24},
	{3260397312U, 24},
	{3252501504U, 24},
	{3243619328U, 24},
	{2612723712U, 16},
	{551731968U, 24},
	{551732736U, 24},
	{551927808U, 18},
	{551732224U, 24},
	{543062016U, 24},
	{551732480U, 24},
	{543061504U, 24},
	{543641088U, 24},
	{543640832U, 24},
	{543640576U, 24},
	{543061248U, 24},
	{543640320U, 24},
	{543640064U, 24},
	{543183616U, 24},
	{551802368U, 24},
	{551802112U, 24},
	{543184384U, 24},
	{551803648U, 24},
	{542535168U, 24},
	{551803392U, 24},
	{543251200U, 24},
	{551803904U, 24},
	{536870912U, 8},
	{543514880U, 24},
	{543253504U, 24},
	{543254528U, 24},
	{543256064U, 24},
	{543190784U, 24},
	{551613440U, 24},
	{543162368U, 13},
	{551845888U, 19},
	{543621888U, 24},
	{543490304U, 24},
	{551911424U, 18},
	{543886848U, 24},
	{543490048U, 24},
	{543490048U, 22},
	{543621376U, 24},
	{543686656U, 15},
	{543890176U, 24},
	{543232256U, 24},
	{551784960U, 24},
	{544342016U, 16},
	{543494400U, 24},
	{543496704U, 24},
	{551854080U, 21},
	{543237120U, 24},
	{543173376U, 24},
	{551856128U, 21},
	{543101184U, 24},
	{543174656U, 24},
	{551859456U, 24},
	{551859712U, 24},
	{551859968U, 24},
	{551858176U, 24},
	{543178240U, 24},
	{543605248U, 24},
	{543095296U, 24},
	{551895040U, 18},
	{543095552U, 24},
	{543604736U, 24},
	{543604992U, 24},
	{543278592U, 24},
	{543608320U, 24},
	{543094272U, 24},
	{543608576U, 24},
	{543094528U, 24},
	{543607808U, 24},
	{543608064U, 24},
	{543094016U, 24},
	{543607552U, 24},
	{543280640U, 24},
	{543282176U, 24},
	{543608832U, 24},
	{543283456U, 24},
	{543283968U, 24},
	{543285504U, 24},
	{543219712U, 19},
	{543289088U, 24},
	{551775232U, 24},
	{543289344U, 23},
	{543289856U, 24},
	{543683328U, 24},
	{543488000U, 24},
	{543292416U, 22},
	{551550976U, 12},
	{543589888U, 23},
	{551878656U, 18},
	{543261696U, 24},
	{543196672U, 24},
	{543262720U, 24},
	{543591424U, 23},
	{543590400U, 22},
	{543265024U, 24},
	{551753216U, 24},
	{543266560U, 24},
	{551622912U, 24},
	{543266816U, 24},
	{551623424U, 24},
	{543267584U, 24},
	{551623168U, 24},
	{543268608U, 24},
	{543270656U, 24},
	{551824384U, 24},
	{543270912U, 23},
	{543271424U, 24},
	{551823360U, 24},
	{551823616U, 24},
	{551823872U, 24},
	{551824128U, 24},
	{543274752U, 24},
	{543274496U, 24},
	{543275264U, 24},
	{543604480U, 24},
	{3641763840U, 24},
	{3633864960U, 24},
	{3631648512U, 24},
	{3505331712U, 24},
	{3476216832U, 24},
	{3438215680U, 24},
	{3405900544U, 24},
	{3356555520U, 24},
	{3254656512U, 24},
	{3237879552U, 24},
	{3231217920U, 24},
	{3228009984U, 24},
	{2827550720U, 21},
	{2827552768U, 22},
	{2612658176U, 16},
	{3640461056U, 24},
	{3637392384U, 24},
	{3512181760U, 24},
	{3470734080U, 24},
	{3454796544U, 24},
	{3428301056U, 24},
	{3423862016U, 24},
	{3416801536U, 24},
	{3407923456U, 24},
	{3407084032U, 24},
	{3398066688U, 24},
	{3335399936U, 24},
	{3325154560U, 24},
	{3247073536U, 24},
	{2612592640U, 16},
	{2326265856U, 16},
	{3637457920U, 24},
	{3564405504U, 24},
	{3487445504U, 24},
	{3430193920U, 24},
	{3420337664U, 24},
	{3407988992U, 24},
	{3389254144U, 24},
	{3357657600U, 24},
	{3355187200U, 24},
	{3333971200U, 24},
	{3252567040U, 24},
	{3228866304U, 24},
	{2612527104U, 16},
	{3625314560U, 24},
	{3563229696U, 24},
	{3540316928U, 24},
	{3484304640U, 24},
	{3461462784U, 24},
	{3409434624U, 24},
	{3351206912U, 24},
	{3265100544U, 24},
	{2827805952U, 24},
	{2827804672U, 20},
	{2827805440U, 24},
	{2827808768U, 22},
	{2612985856U, 16},
	{2613050368U, 24},
	{2613050624U, 24},
	{2613050880U, 24},
	{2613051136U, 24},
	{2613049344U, 24},
	{2613049600U, 24},
	{2613049856U, 24},
	{2613050112U, 24},
	{3650904064U, 24},
	{3627469568U, 24},
	{3624269824U, 24},
	{3558139136U, 24},
	{3555400960U, 24},
	{3506048768U, 24},
	{3488284928U, 24},
	{3431818240U, 24},
	{3407149568U, 24},
	{3355056128U, 24},
	{3345187072U, 24},
	{3339052800U, 24},
	{3251186944U, 24},
	{3235396864U, 24},
	{2827812864U, 17},
	{2827812864U, 16},
	{3695360000U, 24},
	{3564208896U, 24},
	{3511919616U, 24},
	{3498997760U, 24},
	{3477252864U, 24},
	{3470471936U, 24},
	{3448661248U, 24},
	{3407346176U, 24},
	{3358972672U, 24},
	{3357014272U, 24},
	{3275083776U, 24},
	{3227551232U, 24},
	{3222794496U, 24},
	{2827878400U, 16},
	{3633278976U, 24},
	{3526672640U, 24},
	{3519757568U, 24},
	{3491160320U, 24},
	{3486196480U, 24},
	{3456626176U, 24},
	{3435864064U, 24},
	{3426017024U, 24},
	{3412167936U, 24},
	{3398394368U, 24},
	{3389516288U, 24},
	{3358907136U, 24},
	{3273060864U, 24},
	{3268095488U, 24},
	{2827943936U, 16},
	{2827968512U, 24},
	{2828001792U, 24},
	{2828004096U, 24},
	{2612789248U, 16},
	{2612830208U, 23},
	{2612837888U, 24},
	{2612837632U, 24},
	{2612837376U, 24},
	{2612836608U, 24},
	{2612846592U, 23},
	{2612854272U, 24},
	{2612854016U, 24},
	{2612853760U, 24},
	{2612852736U, 21},
	{3627797248U, 24},
	{3501411072U, 24},
	{3481245696U, 24},
	{3477908224U, 24},
	{3434305280U, 24},
	{3429796352U, 24},
	{3407477248U, 24},
	{3395141376U, 24},
	{3353741568U, 24},
	{3253079808U, 24},
	{3248638720U, 24},
	{2325872640U, 24},
	{2325873152U, 23},
	{2325873664U, 24},
	{3628973056U, 24},
	{3484570624U, 24},
	{3463415808U, 24},
	{3455455744U, 24},
	{3409631232U, 24},
	{3354793984U, 24},
	{3352574464U, 24},
	{3225080576U, 24},
	{2612133888U, 16},
	{2325938176U, 16},
	{2325939200U, 16},
	{2325970944U, 16},
	{3638826496U, 24},
	{3520539648U, 24},
	{3493446400U, 24},
	{3455390208U, 24},
	{3434174208U, 24},
	{3424386304U, 24},
	{3410931456U, 24},
	{3390831360U, 24},
	{3339380480U, 24},
	{3240674048U, 24},
	{3231730176U, 24},
	{3560490752U, 24},
	{3417329664U, 24},
	{3413941248U, 24},
	{3407542784U, 24},
	{3406555904U, 24},
	{3392723200U, 24},
	{3358181888U, 24},
	{3353676032U, 24},
	{3341403392U, 24},
	{3240739584U, 24},
	{3222003712U, 24},
	{2827157504U, 16},
	{2612002816U, 16},
	{3628645376U, 24},
	{3520146432U, 24},
	{3516229632U, 24},
	{3482678784U, 24},
	{3481560832U, 24},
	{3473731328U, 24},
	{3414450944U, 24},
	{3409958912U, 24},
	{3407739392U, 24},
	{3406621440U, 24},
	{3397098752U, 24},
	{3393181952U, 24},
	{3250597120U, 24},
	{3229902848U, 24},
	{2827223040U, 17},
	{2827223040U, 16},
	{2827254016U, 24},
	{2827255808U, 17},
	{3631910656U, 24},
	{3509572352U, 24},
	{3467068416U, 24},
	{3450291968U, 24},
	{3429599744U, 24},
	{3426672384U, 24},
	{3404862720U, 24},
	{3394813696U, 24},
	{3390896896U, 24},
	{3330633216U, 24},
	{3326714368U, 24},
	{3274686720U, 24},
	{3263523328U, 24},
	{3252883200U, 24},
	{3233885184U, 24},
	{3230955776U, 24},
	{3229968384U, 24},
	{3228272128U, 24},
	{2827298816U, 22},
	{2827304192U, 24},
	{2827303936U, 24},
	{2827292160U, 24},
	{2827289600U, 24},
	{2827290368U, 24},
	{2827288576U, 16},
	{2827295744U, 24},
	{2612396032U, 16},
	{2612422656U, 24},
	{3579551744U, 24},
	{3491750144U, 24},
	{3490639872U, 24},
	{3435274240U, 24},
	{3393891840U, 24},
	{3389975040U, 24},
	{3360336896U, 24},
	{3356420096U, 24},
	{3343557376U, 24},
	{3227235584U, 24},
	{3224158720U, 24},
	{3223318784U, 24},
	{2612330496U, 24},
	{2612371456U, 24},
	{2612363264U, 24},
	{2326003712U, 16},
	{3562709248U, 24},
	{3536989952U, 24},
	{3505393408U, 24},
	{3498539008U, 24},
	{3493643008U, 24},
	{3451147776U, 24},
	{3414647552U, 24},
	{3357473024U, 24},
	{3330764288U, 24},
	{3234016256U, 24},
	{3232057856U, 24},
	{3231086848U, 24},
	{3641833728U, 24},
	{3638375424U, 24},
	{3635036928U, 24},
	{3632816384U, 24},
	{3531052032U, 24},
	{3529934080U, 24},
	{3523273472U, 24},
	{3517598208U, 24},
	{3489718528U, 24},
	{3408058368U, 24},
	{3361057792U, 24},
	{3359948032U, 24},
	{3264834048U, 24},
	{3261502720U, 24},
	{3238064128U, 24},
	{3232389888U, 24},
	{2828599296U, 16},
	{2611609600U, 17},
	{2611609600U, 16},
	{2611642368U, 17},
	{2327511040U, 16},
	{3638309888U, 24},
	{3631652352U, 24},
	{3515443200U, 24},
	{3492004608U, 24},
	{3489530112U, 24},
	{3455976192U, 24},
	{3406883584U, 24},
	{3405904384U, 24},
	{3345453056U, 24},
	{3344212736U, 24},
	{3228014336U, 24},
	{3638506496U, 24},
	{3634905856U, 24},
	{3556959488U, 24},
	{3505131264U, 24},
	{3407080192U, 24},
	{3398071040U, 24},
	{3392260096U, 24},
	{3244594688U, 24},
	{3630534400U, 24},
	{3576747776U, 24},
	{3564409344U, 24},
	{3482023424U, 24},
	{3469685504U, 24},
	{3467203840U, 24},
	{3466225152U, 24},
	{3437109248U, 24},
	{3412433920U, 24},
	{3389258496U, 24},
	{3338925568U, 24},
	{3259479808U, 24},
	{3225924864U, 24},
	{2828664832U, 16},
	{2828709888U, 23},
	{2828709632U, 24},
	{2327314432U, 16},
	{3563225856U, 24},
	{3483199232U, 24},
	{3450754560U, 24},
	{3449644288U, 24},
	{3406100992U, 24},
	{3389324032U, 24},
	{3359099392U, 24},
	{3259021056U, 24},
	{3237678592U, 24},
	{3653837824U, 24},
	{3650908416U, 24},
	{3627473408U, 24},
	{3586023168U, 24},
	{3558142976U, 24},
	{3555396608U, 24},
	{3547501824U, 24},
	{3533470208U, 24},
	{3515705344U, 24},
	{3506052608U, 24},
	{3406166528U, 24},
	{3359033856U, 24},
	{3337296128U, 24},
	{3328413952U, 24},
	{3327173120U, 24},
	{3325477888U, 24},
	{3256148480U, 24},
	{3253411328U, 24},
	{2828795904U, 16},
	{2828824576U, 20},
	{2828820480U, 20},
	{2828816384U, 20},
	{2828812288U, 20},
	{2327707648U, 16},
	{3559180032U, 24},
	{3500111872U, 24},
	{3491229696U, 24},
	{3483330304U, 24},
	{3477256704U, 24},
	{3471315200U, 24},
	{3451733760U, 24},
	{3428034560U, 24},
	{3407342336U, 24},
	{3406232064U, 24},
	{3401400320U, 24},
	{3394481664U, 24},
	{3367846400U, 24},
	{3254324992U, 24},
	{3244332544U, 24},
	{3233630720U, 24},
	{3231672320U, 24},
	{2828992512U, 16},
	{2327642112U, 16},
	{3633275136U, 24},
	{3515836416U, 24},
	{3486200320U, 24},
	{3466487296U, 24},
	{3463481344U, 24},
	{3462502656U, 24},
	{3411193600U, 24},
	{3407276800U, 24},
	{3392456704U, 24},
	{3389520640U, 24},
	{3273057024U, 24},
	{2828926976U, 16},
	{2611806208U, 16},
	{2611806464U, 24},
	{2327576576U, 16},
	{3637851136U, 24},
	{3584183808U, 24},
	{3499194368U, 24},
	{3481241856U, 24},
	{3400744960U, 24},
	{3392915456U, 24},
	{3358251776U, 24},
	{3351525888U, 24},
	{3332529408U, 24},
	{3326915328U, 24},
	{3323586048U, 24},
	{3285528320U, 24},
	{3263136768U, 24},
	{3253083648U, 24},
	{3245250048U, 24},
	{3229645056U, 24},
	{2828075008U, 16},
	{3641305088U, 24},
	{3631189760U, 24},
	{3500362496U, 24},
	{3484566784U, 24},
	{3448792320U, 24},
	{3427645696U, 24},
	{3407407872U, 24},
	{3399700736U, 24},
	{3398459904U, 24},
	{3354790144U, 24},
	{3341538304U, 24},
	{3263071232U, 24},
	{3226318080U, 24},
	{2828009472U, 16},
	{2326934016U, 16},
	{2326931456U, 16},
	{2326931712U, 16},
	{2326929408U, 16},
	{2326929664U, 16},
	{2326929920U, 16},
	{2326930176U, 16},
	{2326930432U, 16},
	{2326930688U, 16},
	{2326930944U, 16},
	{2326931200U, 16},
	{2326929152U, 16},
	{2326925312U, 16},
	{2326925568U, 16},
	{2326926336U, 16},
	{2326923264U, 16},
	{2326923776U, 16},
	{2326924032U, 16},
	{2326924288U, 16},
	{2326924544U, 16},
	{2326922240U, 16},
	{2326946816U, 16},
	{2326972928U, 16},
	{2326973184U, 16},
	{2326973440U, 16},
	{2326973696U, 16},
	{3653641216U, 24},
	{3639940608U, 24},
	{3638822656U, 24},
	{3576219136U, 24},
	{3478043136U, 24},
	{3465766400U, 24},
	{3409561856U, 24},
	{3398656512U, 24},
	{3390827008U, 24},
	{3280108032U, 24},
	{3236175616U, 24},
	{3517995776U, 24},
	{3481045248U, 24},
	{3455320832U, 24},
	{3434104320U, 24},
	{3417325824U, 24},
	{3413937408U, 24},
	{3407538944U, 24},
	{3406559744U, 24},
	{3404989440U, 24},
	{3397612288U, 24},
	{3397159936U, 24},
	{3392718848U, 24},
	{3343888896U, 24},
	{3332463872U, 24},
	{3290096640U, 24},
	{3255563008U, 24},
	{3229841664U, 24},
	{3227427840U, 24},
	{3223966464U, 24},
	{2828140544U, 16},
	{2611019776U, 16},
	{3516233984U, 24},
	{3460287488U, 24},
	{3424513024U, 24},
	{3413871872U, 24},
	{3407735552U, 24},
	{3406625280U, 24},
	{3397094400U, 24},
	{3393177600U, 24},
	{3344540416U, 24},
	{3337816064U, 24},
	{3252821504U, 24},
	{3250600960U, 24},
	{3231016960U, 24},
	{2828337152U, 16},
	{2327248896U, 16},
	{3517401600U, 24},
	{3463158016U, 24},
	{3436191744U, 24},
	{3431298304U, 24},
	{3426668032U, 24},
	{3399962880U, 24},
	{3394809344U, 24},
	{3393112064U, 24},
	{3358579456U, 24},
	{3356358912U, 24},
	{3326002176U, 24},
	{3263527680U, 24},
	{3261830400U, 24},
	{3234868224U, 24},
	{3667358208U, 24},
	{3637720064U, 24},
	{3579556096U, 24},
	{3575641344U, 24},
	{3562778624U, 24},
	{3493712384U, 24},
	{3486720768U, 24},
	{3484763392U, 24},
	{3434432000U, 24},
	{3426602496U, 24},
	{3350547712U, 24},
	{3235064832U, 24},
	{2828468224U, 16},
	{2611216384U, 16},
	{2327117824U, 16},
	{3659463168U, 24},
	{3629825024U, 24},
	{3514341120U, 24},
	{3455058688U, 24},
	{3449185536U, 24},
	{3357468672U, 24},
	{3346563328U, 24},
	{3331747328U, 24},
	{3255825152U, 24},
	{3230103808U, 24},
	{2828402688U, 16},
	{2327052288U, 16},
	{3632812544U, 24},
	{3517610240U, 24},
	{3499707136U, 24},
	{3493060864U, 24},
	{3452699392U, 24},
	{3451614208U, 24},
	{3449378304U, 24},
	{3438157824U, 24},
	{3423723264U, 24},
	{3411385344U, 24},
	{3408063232U, 24},
	{3359936000U, 24},
	{2829713408U, 16},
	{3629420288U, 24},
	{3589224704U, 24},
	{3583528448U, 24},
	{3582549760U, 24},
	{3507536384U, 24},
	{3427109376U, 24},
	{3403420928U, 24},
	{3389114368U, 24},
	{3344207872U, 24},
	{3338781952U, 24},
	{3335325696U, 24},
	{3326443520U, 24},
	{3244795136U, 24},
	{3223576576U, 24},
	{2829778944U, 16},
	{2610460672U, 16},
	{3634053888U, 24},
	{3489845760U, 24},
	{3489477120U, 24},
	{3450365184U, 24},
	{3433587712U, 24},
	{3415953408U, 24},
	{3411516416U, 24},
	{3405957376U, 24},
	{3336509696U, 24},
	{3335391232U, 24},
	{3325163264U, 24},
	{3262494464U, 24},
	{3247065856U, 24},
	{3227821056U, 24},
	{2829582336U, 16},
	{3634982912U, 24},
	{3631525120U, 24},
	{3459317504U, 24},
	{3454869760U, 24},
	{3437105920U, 24},
	{3432666880U, 24},
	{3407009792U, 24},
	{3393686528U, 24},
	{3333979904U, 24},
	{3228873984U, 24},
	{2829647872U, 16},
	{3630349312U, 24},
	{3628113408U, 24},
	{3625306880U, 24},
	{3554216960U, 24},
	{3526877952U, 24},
	{3484313344U, 24},
	{3430136064U, 24},
	{3399307520U, 24},
	{3351775488U, 24},
	{3333320192U, 24},
	{3251113728U, 24},
	{3244467456U, 24},
	{2829975552U, 16},
	{3650896384U, 24},
	{3537374464U, 24},
	{3490042368U, 24},
	{3489280512U, 24},
	{3461388544U, 24},
	{3436712704U, 24},
	{3417268992U, 24},
	{3398254592U, 24},
	{3360726784U, 24},
	{3339044096U, 24},
	{3327168768U, 24},
	{3325490944U, 24},
	{3255156736U, 24},
	{3233708288U, 24},
	{3231472384U, 24},
	{2830104576U, 24},
	{3498990080U, 24},
	{3449771520U, 24},
	{3431876096U, 24},
	{3407337472U, 24},
	{3368683008U, 24},
	{3357006592U, 24},
	{3333189120U, 24},
	{3327365376U, 24},
	{3322332160U, 24},
	{3288778240U, 24},
	{3235585792U, 24},
	{3223642112U, 24},
	{3222786816U, 24},
	{2829844480U, 16},
	{2610888704U, 16},
	{3634250496U, 24},
	{3507929600U, 24},
	{3477309696U, 24},
	{3454607616U, 24},
	{3407271936U, 24},
	{3392469760U, 24},
	{3391482368U, 24},
	{3343089920U, 24},
	{3289831168U, 24},
	{3250354176U, 24},
	{3240485120U, 24},
	{3225650688U, 24},
	{2829910016U, 16},
	{2610823168U, 16},
	{3638965248U, 24},
	{3633398528U, 24},
	{3545011456U, 24},
	{3520400896U, 24},
	{3429804032U, 24},
	{3426483456U, 24},
	{3406350592U, 24},
	{3399639552U, 24},
	{3253087488U, 24},
	{3226240512U, 24},
	{2609995776U, 24},
	{3645742848U, 24},
	{3628965376U, 24},
	{3582025472U, 24},
	{3504815104U, 24},
	{3414245632U, 24},
	{3413094144U, 24},
	{3398455552U, 24},
	{3353815808U, 24},
	{3352565760U, 24},
	{3335788800U, 24},
	{3273183232U, 24},
	{3245319424U, 24},
	{2609905664U, 16},
	{2609912064U, 24},
	{2609911808U, 24},
	{2609910016U, 24},
	{2609909760U, 24},
	{2609910784U, 24},
	{2609914368U, 24},
	{2609931520U, 24},
	{2609931264U, 24},
	{2609969920U, 24},
	{2609970432U, 24},
	{2323709952U, 16},
	{3641367296U, 24},
	{3639944448U, 24},
	{3531450112U, 24},
	{3520531968U, 24},
	{3499313920U, 24},
	{3493454080U, 24},
	{3472175872U, 24},
	{3437502464U, 24},
	{3407599616U, 24},
	{3395263744U, 24},
	{3390822656U, 24},
	{3356150272U, 24},
	{3283188224U, 24},
	{3246240768U, 24},
	{3237297408U, 24},
	{2829058048U, 16},
	{2610102272U, 16},
	{2610108672U, 24},
	{2323775488U, 16},
	{3641432832U, 24},
	{3638899712U, 24},
	{3629096448U, 24},
	{3502710272U, 24},
	{3471122944U, 24},
	{3457867008U, 24},
	{3412963072U, 24},
	{3409508864U, 24},
	{3407534080U, 24},
	{3397599232U, 24},
	{3392731904U, 24},
	{3350232576U, 24},
	{3251048192U, 24},
	{3229398272U, 24},
	{3222983424U, 24},
	{2323841024U, 16},
	{3628637696U, 24},
	{3561525760U, 24},
	{3511195392U, 24},
	{3484907008U, 24},
	{3460300544U, 24},
	{3456945152U, 24},
	{3453030912U, 24},
	{3413884416U, 24},
	{3411647488U, 24},
	{3340620800U, 24},
	{3327758592U, 24},
	{3273510912U, 24},
	{3252825344U, 24},
	{3228214272U, 24},
	{2829451264U, 16},
	{2610233344U, 16},
	{2323906560U, 16},
	{3631918336U, 24},
	{3629682432U, 24},
	{3627022336U, 24},
	{3625765632U, 24},
	{3564806400U, 24},
	{3517413632U, 24},
	{3509580032U, 24},
	{3500636160U, 24},
	{3486519296U, 24},
	{3460925440U, 24},
	{3429607424U, 24},
	{3426680064U, 24},
	{3404871424U, 24},
	{3402634496U, 24},
	{3397730304U, 24},
	{3394804992U, 24},
	{3356346880U, 24},
	{3351316736U, 24},
	{3333848832U, 24},
	{3326705664U, 24},
	{3274695424U, 24},
	{3270655744U, 24},
	{3261834752U, 24},
	{3228279808U, 24},
	{2829516800U, 16},
	{2829522176U, 24},
	{2829529856U, 24},
	{2610167808U, 16},
	{2323972096U, 16},
	{2324021248U, 22},
	{2324033536U, 22},
	{3650568704U, 24},
	{3637708544U, 24},
	{3520269824U, 24},
	{3484775936U, 24},
	{3435266560U, 24},
	{3407861760U, 24},
	{3406743808U, 24},
	{3393059584U, 24},
	{3257721344U, 24},
	{2829320192U, 16},
	{2324037632U, 16},
	{3633726208U, 24},
	{3627870464U, 24},
	{3584392448U, 24},
	{3536981248U, 24},
	{3524251648U, 24},
	{3514344448U, 24},
	{3407796224U, 24},
	{3360394752U, 24},
	{3358451712U, 24},
	{3357465344U, 24},
	{3262691072U, 24},
	{3234008576U, 24},
	{3226174976U, 24},
	{2829387776U, 24},
	{2829386752U, 24},
	{2829385984U, 24},
	{2829385728U, 22},
	{2829385728U, 16},
	{2829386496U, 24},
	{2829386240U, 24},
	{2829429760U, 24},
	{2829430272U, 24},
	{2829428992U, 24},
	{2829428736U, 24},
	{2829429504U, 24},
	{2829429248U, 24},
	{2829428480U, 24},
	{2829428224U, 24},
	{2829450496U, 24},
	{2829450752U, 24},
	{3636162560U, 24},
	{3632808704U, 24},
	{3505270016U, 24},
	{3465041152U, 24},
	{3454939136U, 24},
	{3439271936U, 24},
	{3405830144U, 24},
	{3393494272U, 24},
	{3392399872U, 24},
	{3359940352U, 24},
	{3264825344U, 24},
	{3261511424U, 24},
	{3231271424U, 24},
	{3225720576U, 24},
	{2830827520U, 16},
	{2830858752U, 23},
	{2830858240U, 23},
	{2830858240U, 22},
	{2830871040U, 23},
	{2830870528U, 23},
	{2830870528U, 22},
	{2830886400U, 24},
	{2609381376U, 16},
	{2609397760U, 19},
	{3651887104U, 24},
	{3639551232U, 24},
	{3583532800U, 24},
	{3582545408U, 24},
	{3513230336U, 24},
	{3449308928U, 24},
	{3425889280U, 24},
	{3422430976U, 24},
	{3406874880U, 24},
	{3394538496U, 24},
	{3356543488U, 24},
	{3344204032U, 24},
	{3338785792U, 24},
	{3261576960U, 24},
	{3228022016U, 24},
	{2830761984U, 16},
	{2609446912U, 16},
	{3634057728U, 24},
	{3500697856U, 24},
	{3490959872U, 24},
	{3486388224U, 24},
	{3470721024U, 24},
	{3411512576U, 24},
	{3358713856U, 24},
	{3350818560U, 24},
	{3338851328U, 24},
	{3286174976U, 24},
	{3247069696U, 24},
	{3234733824U, 24},
	{3227825408U, 24},
	{3222520320U, 24},
	{2609512448U, 18},
	{2609512448U, 16},
	{2609528832U, 19},
	{2609537024U, 19},
	{2609545216U, 17},
	{3634979072U, 24},
	{3631528960U, 24},
	{3524448256U, 24},
	{3489907456U, 24},
	{3437101568U, 24},
	{3393690880U, 24},
	{3357669632U, 24},
	{3355192064U, 24},
	{3338916864U, 24},
	{3224428544U, 24},
	{2830630912U, 16},
	{2609577984U, 16},
	{3574978304U, 24},
	{3506749952U, 24},
	{3466413056U, 24},
	{3461449728U, 24},
	{3449636608U, 24},
	{3433985280U, 24},
	{3333324544U, 24},
	{3224887296U, 24},
	{2831089664U, 16},
	{2609643520U, 17},
	{2609643520U, 16},
	{2609669120U, 23},
	{2609676544U, 24},
	{2609676288U, 17},
	{3650900736U, 24},
	{3506060288U, 24},
	{3489276672U, 24},
	{3469283584U, 24},
	{3463621120U, 24},
	{3461384192U, 24},
	{3454742528U, 24},
	{3406157824U, 24},
	{3398258944U, 24},
	{3360722432U, 24},
	{3345199616U, 24},
	{3327164416U, 24},
	{3244536832U, 24},
	{3224821760U, 24},
	{2831024128U, 16},
	{2609709056U, 16},
	{3695348480U, 24},
	{3634319872U, 24},
	{3486126080U, 24},
	{3449767680U, 24},
	{3391421184U, 24},
	{3357002240U, 24},
	{3252358912U, 24},
	{3251248640U, 24},
	{3237555200U, 24},
	{3225589504U, 24},
	{3222782464U, 24},
	{2830958592U, 16},
	{2830982400U, 24},
	{2830982144U, 24},
	{2830982912U, 24},
	{2830982656U, 24},
	{2831023616U, 23},
	{3634254336U, 24},
	{3630279936U, 24},
	{3567148544U, 24},
	{3475373568U, 24},
	{3425041664U, 24},
	{3407268096U, 24},
	{3252293376U, 24},
	{3250350336U, 24},
	{3235515904U, 24},
	{3233572864U, 24},
	{2830893056U, 16},
	{2830931456U, 24},
	{2830931712U, 24},
	{2830931968U, 24},
	{2830932480U, 24},
	{2830934784U, 24},
	{3633402368U, 24},
	{3632284416U, 24},
	{3632249856U, 24},
	{3624454912U, 24},
	{3512571648U, 24},
	{3435401984U, 24},
	{3394018560U, 24},
	{3326906624U, 24},
	{3226244864U, 24},
	{2830303232U, 16},
	{2608857088U, 16},
	{2324758528U, 16},
	{3628961536U, 24},
	{3499121152U, 24},
	{3490300672U, 24},
	{3475766784U, 24},
	{3450041344U, 24},
	{3448784640U, 24},
	{3407399168U, 24},
	{3391879936U, 24},
	{3359303680U, 24},
	{3356089088U, 24},
	{3352561920U, 24},
	{3287691008U, 24},
	{3275416320U, 24},
	{3259864320U, 24},
	{3237358592U, 24},
	{3227289088U, 24},
	{3225083904U, 24},
	{2830237696U, 16},
	{2608922624U, 16},
	{2324692992U, 16},
	{3641362944U, 24},
	{3510235392U, 24},
	{3493457920U, 24},
	{3426348032U, 24},
	{3424374272U, 24},
	{3407595776U, 24},
	{3406485504U, 24},
	{3395259392U, 24},
	{3361705472U, 24},
	{3356154624U, 24},
	{3245126656U, 24},
	{3235319296U, 24},
	{3231742208U, 24},
	{2830172160U, 16},
	{2608988160U, 16},
	{3505667072U, 24},
	{3480074752U, 24},
	{3409505024U, 24},
	{3406551040U, 24},
	{3397168640U, 24},
	{3392727552U, 24},
	{3359172608U, 24},
	{3255554304U, 24},
	{3232786432U, 24},
	{3229833984U, 24},
	{2830106624U, 16},
	{2609061632U, 24},
	{2609053696U, 16},
	{2609053952U, 24},
	{2609086208U, 24},
	{2609078528U, 24},
	{2609111040U, 21},
	{3642612480U, 24},
	{3561521920U, 24},
	{3516226304U, 24},
	{3511191040U, 24},
	{3481555968U, 24},
	{3434570752U, 24},
	{3428420096U, 24},
	{3411643648U, 24},
	{3406616576U, 24},
	{3389839616U, 24},
	{3264563200U, 24},
	{3252829184U, 24},
	{3222065920U, 24},
	{2830565376U, 16},
	{3632612096U, 24},
	{3564810240U, 24},
	{3535867136U, 24},
	{3502313216U, 24},
	{3492798720U, 24},
	{3457993728U, 24},
	{3426675712U, 24},
	{3411578112U, 24},
	{3409898240U, 24},
	{3407661312U, 24},
	{3398713344U, 24},
	{3394800640U, 24},
	{3392142080U, 24},
	{3356351232U, 24},
	{3337759232U, 24},
	{3274699264U, 24},
	{3270651392U, 24},
	{3252894720U, 24},
	{3249957120U, 24},
	{3224367360U, 24},
	{2830499840U, 21},
	{2830508032U, 19},
	{3637712384U, 24},
	{3579548416U, 24},
	{3486712064U, 24},
	{3466019840U, 24},
	{3451217152U, 24},
	{3449243392U, 24},
	{3411774720U, 24},
	{3393055232U, 24},
	{3389970688U, 24},
	{3357526528U, 24},
	{3350556416U, 24},
	{3257725696U, 24},
	{3244864512U, 24},
	{3228087552U, 24},
	{2609265664U, 24},
	{3645607424U, 24},
	{3633730048U, 24},
	{3628830464U, 24},
	{3584388096U, 24},
	{3500501248U, 24},
	{3475897856U, 24},
	{3430459392U, 24},
	{3428485632U, 24},
	{3357460992U, 24},
	{2830368768U, 16},
	{2609315840U, 16},
	{3489707008U, 24},
	{3476264960U, 24},
	{3465028096U, 24},
	{3438167552U, 24},
	{3432591616U, 24},
	{3423713536U, 24},
	{3416917248U, 24},
	{3408039168U, 24},
	{3389042176U, 24},
	{3357707776U, 24},
	{3261513728U, 24},
	{3259294208U, 24},
	{3244737280U, 24},
	{3226857728U, 24},
	{2330853376U, 24},
	{2330886144U, 24},
	{3639562752U, 24},
	{3582540032U, 24},
	{3518631424U, 24},
	{3481871104U, 24},
	{3452790016U, 24},
	{3432526080U, 24},
	{3394566912U, 24},
	{3355335680U, 24},
	{3331865344U, 24},
	{3326469632U, 24},
	{3288440832U, 24},
	{3228025344U, 24},
	{2832007168U, 16},
	{2617114624U, 16},
	{2617147392U, 17},
	{2330935296U, 20},
	{2330918912U, 16},
	{3632935936U, 24},
	{3521079296U, 24},
	{3489838080U, 24},
	{3477532416U, 24},
	{3473058560U, 24},
	{3454813952U, 24},
	{3433562624U, 24},
	{3421257984U, 24},
	{3407908096U, 24},
	{3404480512U, 24},
	{3365614848U, 24},
	{3350796288U, 24},
	{3334019328U, 24},
	{3280613120U, 24},
	{3260543744U, 24},
	{3252647936U, 24},
	{3231399168U, 24},
	{3227828736U, 24},
	{3225870336U, 24},
	{2617049088U, 16},
	{2330722304U, 16},
	{3583649792U, 24},
	{3492841216U, 24},
	{3468169472U, 24},
	{3407973632U, 24},
	{3404546048U, 24},
	{3357642240U, 24},
	{3340861696U, 24},
	{3234818048U, 24},
	{3231333632U, 24},
	{3226923264U, 24},
	{3223422464U, 24},
	{2617013248U, 22},
	{2617012224U, 22},
	{2616999936U, 21},
	{2617001984U, 21},
	{2617004032U, 21},
	{2617006080U, 21},
	{2616984576U, 22},
	{2616984064U, 24},
	{2616983808U, 24},
	{2616983552U, 24},
	{2616983552U, 16},
	{2616987648U, 20},
	{2617040896U, 20},
	{2617044992U, 21},
	{2617048320U, 24},
	{2617048064U, 24},
	{2617047040U, 22},
	{2617032704U, 21},
	{2617035776U, 22},
	{2617035264U, 24},
	{2617025536U, 23},
	{2617024512U, 22},
	{2617016320U, 21},
	{2617020416U, 21},
	{2617024000U, 24},
	{2617022464U, 22},
	{2330787840U, 16},
	{3630356992U, 24},
	{3530801408U, 24},
	{3453580288U, 24},
	{3409419264U, 24},
	{3333294080U, 24},
	{3288637440U, 24},
	{2831679488U, 16},
	{2831680000U, 24},
	{2330591232U, 16},
	{3650888704U, 24},
	{3635353088U, 24},
	{3506812160U, 24},
	{3489289216U, 24},
	{3486082816U, 24},
	{3449565184U, 24},
	{3438958336U, 24},
	{3389369856U, 24},
	{3358035456U, 24},
	{3339035392U, 24},
	{3256137472U, 24},
	{3255150080U, 24},
	{3251202304U, 24},
	{3235412224U, 24},
	{3231464704U, 24},
	{3225542656U, 24},
	{3221595136U, 24},
	{2831745024U, 16},
	{2616852480U, 16},
	{2330656768U, 16},
	{3522775552U, 24},
	{3485274112U, 24},
	{3472446720U, 24},
	{3451720192U, 24},
	{3351932672U, 24},
	{3349940480U, 24},
	{3277897984U, 24},
	{3227566592U, 24},
	{3223619072U, 24},
	{3221660672U, 24},
	{2831810560U, 16},
	{2330460160U, 16},
	{3588841216U, 24},
	{3490165760U, 24},
	{3458566144U, 24},
	{3434877696U, 24},
	{3431931904U, 24},
	{3407265280U, 24},
	{3406278400U, 24},
	{3389500928U, 24},
	{3358891776U, 24},
	{3353955584U, 24},
	{3341123840U, 24},
	{3324346368U, 24},
	{3231595776U, 24},
	{3228619520U, 24},
	{3226661120U, 24},
	{2831876096U, 16},
	{2616721408U, 16},
	{2330525696U, 16},
	{3650167808U, 24},
	{3625561344U, 24},
	{3477925632U, 24},
	{3448844288U, 24},
	{3435422720U, 24},
	{3426458368U, 24},
	{3421982720U, 24},
	{3406343936U, 24},
	{3405205760U, 24},
	{3325792512U, 24},
	{3264298752U, 24},
	{3258684672U, 24},
	{3257566208U, 24},
	{2616655872U, 16},
	{2330329088U, 16},
	{3631208960U, 24},
	{3478978048U, 24},
	{3471262720U, 24},
	{3456739840U, 24},
	{3407396352U, 24},
	{3398448896U, 24},
	{3341517056U, 24},
	{3253160704U, 24},
	{3249675776U, 24},
	{3245327104U, 24},
	{2616590336U, 16},
	{2330394624U, 16},
	{3636883456U, 24},
	{3531456768U, 24},
	{3488961536U, 24},
	{3409550336U, 24},
	{3246248448U, 24},
	{3245130496U, 24},
	{2831548416U, 16},
	{2616524800U, 16},
	{3633456384U, 24},
	{3503712512U, 24},
	{3418841856U, 24},
	{3413956608U, 24},
	{3411999232U, 24},
	{3407527424U, 24},
	{3391720448U, 24},
	{3340415488U, 24},
	{3262959872U, 24},
	{3227447552U, 24},
	{2616459264U, 16},
	{2330263552U, 16},
	{2330267648U, 22},
	{2330304512U, 22},
	{3516214272U, 24},
	{3502274560U, 24},
	{3486610944U, 24},
	{3483762944U, 24},
	{3481543424U, 24},
	{3428449536U, 24},
	{3424499968U, 24},
	{3407724032U, 24},
	{3389828608U, 24},
	{3358494208U, 24},
	{3353496832U, 24},
	{3289161728U, 24},
	{3241051904U, 24},
	{2330066944U, 16},
	{3651606272U, 24},
	{3631926016U, 24},
	{3467051008U, 24},
	{3460951552U, 24},
	{3436213504U, 24},
	{3407658496U, 24},
	{3399943168U, 24},
	{3397723648U, 24},
	{3392113664U, 24},
	{3356339200U, 24},
	{3333822720U, 24},
	{3289227264U, 24},
	{3229274880U, 24},
	{3227054336U, 24},
	{3226066944U, 24},
	{2330132480U, 16},
	{3633784064U, 24},
	{3586292992U, 24},
	{3504364032U, 24},
	{3490624512U, 24},
	{3482792448U, 24},
	{3478912512U, 24},
	{3468846592U, 24},
	{3426589440U, 24},
	{3411802624U, 24},
	{3407855104U, 24},
	{3393035520U, 24},
	{3332638720U, 24},
	{3235084544U, 24},
	{2616268800U, 24},
	{3629836544U, 24},
	{3514352128U, 24},
	{3504429568U, 24},
	{3498523648U, 24},
	{3471856896U, 24},
	{3437315584U, 24},
	{3414632192U, 24},
	{3406802688U, 24},
	{3404747008U, 24},
	{3346584576U, 24},
	{3269543936U, 24},
	{2616197120U, 16},
	{3489703168U, 24},
	{3439281664U, 24},
	{3399034368U, 24},
	{3357712128U, 24},
	{3342041344U, 24},
	{3335290624U, 24},
	{3328627968U, 24},
	{3272713984U, 24},
	{3261518080U, 24},
	{3241379584U, 24},
	{3227964160U, 24},
	{2833055744U, 16},
	{2616066048U, 16},
	{3639558912U, 24},
	{3530014976U, 24},
	{3489547520U, 24},
	{3452793856U, 24},
	{3432521728U, 24},
	{3406868224U, 24},
	{3405889024U, 24},
	{3360028928U, 24},
	{3328693504U, 24},
	{3269224960U, 24},
	{2832990208U, 16},
	{2616131584U, 16},
	{2331901952U, 16},
	{3500674816U, 24},
	{3498716416U, 24},
	{3478646528U, 24},
	{3471594752U, 24},
	{3470747136U, 24},
	{3466273280U, 24},
	{3454817792U, 24},
	{3428314112U, 24},
	{3416790016U, 24},
	{3407064832U, 24},
	{3405954560U, 24},
	{3392244736U, 24},
	{3365610496U, 24},
	{3290469120U, 24},
	{2833186816U, 16},
	{2615973376U, 23},
	{2615973888U, 24},
	{2331836416U, 16},
	{3638456320U, 24},
	{3492845056U, 24},
	{3340865536U, 24},
	{3333949440U, 24},
	{3259495168U, 24},
	{3257959424U, 24},
	{2616000512U, 16},
	{3489350912U, 24},
	{3485401344U, 24},
	{3450737152U, 24},
	{3422861568U, 24},
	{3409415424U, 24},
	{3406085632U, 24},
	{3389308672U, 24},
	{3327256064U, 24},
	{3247193088U, 24},
	{3237693952U, 24},
	{3233746432U, 24},
	{3224864256U, 24},
	{2832793600U, 16},
	{2615803904U, 16},
	{3650893056U, 24},
	{3627458048U, 24},
	{3564295680U, 24},
	{3509028352U, 24},
	{3506807808U, 24},
	{3473259008U, 24},
	{3471529216U, 24},
	{3454752256U, 24},
	{3436733440U, 24},
	{3432783872U, 24},
	{3359018496U, 24},
	{3358039808U, 24},
	{3352850176U, 24},
	{3251206144U, 24},
	{3247258624U, 24},
	{2832728064U, 17},
	{2832728064U, 16},
	{2832760832U, 17},
	{2615869440U, 16},
	{3629381632U, 24},
	{3588771328U, 24},
	{3500096512U, 24},
	{3485270272U, 24},
	{3454555648U, 24},
	{3451716352U, 24},
	{3407326976U, 24},
	{3391397120U, 24},
	{3356994560U, 24},
	{3244347904U, 24},
	{3235604480U, 24},
	{3226722304U, 24},
	{3223623424U, 24},
	{3222774784U, 24},
	{2832924672U, 16},
	{2615672832U, 16},
	{3637207296U, 24},
	{3627326976U, 24},
	{3588836864U, 24},
	{3576005120U, 24},
	{3507926272U, 24},
	{3458570496U, 24},
	{3443784704U, 24},
	{3434873344U, 24},
	{3390483968U, 24},
	{3353959424U, 24},
	{3345077248U, 24},
	{3254274816U, 24},
	{3252316416U, 24},
	{3234560256U, 24},
	{3233549824U, 24},
	{3449950720U, 24},
	{3448840448U, 24},
	{3368317184U, 24},
	{3285543680U, 24},
	{3238573056U, 24},
	{3226267904U, 24},
	{3224016640U, 24},
	{2832531456U, 16},
	{2615541760U, 16},
	{2331443200U, 16},
	{3641289728U, 24},
	{3624512768U, 24},
	{3515890944U, 24},
	{3505805824U, 24},
	{3502598400U, 24},
	{3469047552U, 24},
	{3436471296U, 24},
	{3428641792U, 24},
	{3356081408U, 24},
	{3234167040U, 24},
	{3227312128U, 24},
	{2832465920U, 16},
	{2331377664U, 16},
	{3522517760U, 24},
	{3509093888U, 24},
	{3504622336U, 24},
	{3485890048U, 24},
	{3464639232U, 24},
	{3409546496U, 24},
	{3400598528U, 24},
	{3395283456U, 24},
	{3391659264U, 24},
	{3350268160U, 24},
	{3331533312U, 24},
	{3327063808U, 24},
	{3252967936U, 24},
	{3245134336U, 24},
	{3231719168U, 24},
	{3230870528U, 24},
	{2832691456U, 24},
	{2832691200U, 20},
	{2832690176U, 23},
	{2832689152U, 24},
	{2832687104U, 20},
	{2832685824U, 24},
	{2832683520U, 24},
	{2832683264U, 24},
	{2832678912U, 23},
	{2832678912U, 19},
	{2832674816U, 20},
	{2832670720U, 20},
	{2832662528U, 19},
	{2832662528U, 16},
	{2832727552U, 23},
	{2832723968U, 20},
	{2832723200U, 24},
	{2832722944U, 24},
	{2832722688U, 24},
	{2832722432U, 24},
	{2832722176U, 24},
	{2832719872U, 20},
	{2832715776U, 20},
	{2832715008U, 24},
	{2832714496U, 24},
	{2832713728U, 21},
	{2832713472U, 24},
	{2832712960U, 24},
	{2832712192U, 23},
	{2832711680U, 20},
	{2832705280U, 24},
	{2832704512U, 24},
	{2832703488U, 19},
	{2832702976U, 24},
	{2832699392U, 20},
	{2832695296U, 20},
	{3635418624U, 24},
	{3582142464U, 24},
	{3502729472U, 24},
	{3490424064U, 24},
	{3428772864U, 24},
	{3418845696U, 24},
	{3413952768U, 24},
	{3397175296U, 24},
	{3359149568U, 24},
	{3323634176U, 24},
	{3264359936U, 24},
	{3260019456U, 24},
	{3232763392U, 24},
	{3228422912U, 24},
	{2832596992U, 16},
	{2615495680U, 24},
	{2615476224U, 16},
	{2615526400U, 24},
	{2615523328U, 24},
	{3628656896U, 24},
	{3628047872U, 24},
	{3584428544U, 24},
	{3492710144U, 24},
	{3491607552U, 24},
	{3460270080U, 24},
	{3404939264U, 24},
	{3357387776U, 24},
	{3354610944U, 24},
	{3353500672U, 24},
	{3349551104U, 24},
	{3344557824U, 24},
	{3289166080U, 24},
	{3263446784U, 24},
	{3249999616U, 24},
	{2832294144U, 24},
	{2832294400U, 24},
	{2832269312U, 16},
	{2615279616U, 16},
	{3631929856U, 24},
	{3629709312U, 24},
	{3567717120U, 24},
	{3436209152U, 24},
	{3409874176U, 24},
	{3358564096U, 24},
	{3356343552U, 24},
	{3229957376U, 24},
	{2832203776U, 16},
	{2615345152U, 16},
	{3559686912U, 24},
	{3535084544U, 24},
	{3505478144U, 24},
	{3504360192U, 24},
	{3490620672U, 24},
	{3478908672U, 24},
	{3469960704U, 24},
	{3431346432U, 24},
	{3411798784U, 24},
	{3357518848U, 24},
	{3345536000U, 24},
	{3333752832U, 24},
	{3331795456U, 24},
	{3257701632U, 24},
	{3229204992U, 24},
	{3537009152U, 24},
	{3507463168U, 24},
	{3474893568U, 24},
	{3473914368U, 24},
	{3427532032U, 24},
	{3414636032U, 24},
	{3407785728U, 24},
	{3354414336U, 24},
	{3255809792U, 24},
	{3232046848U, 24},
	{2832360448U, 24},
	{2832360704U, 24},
	{2832357888U, 24},
	{2832358144U, 24},
	{2832358912U, 23},
	{2832351232U, 24},
	{2832352256U, 22},
	{2832349184U, 24},
	{2832347648U, 24},
	{2832348672U, 23},
	{2832345088U, 24},
	{2832345344U, 24},
	{2832340992U, 23},
	{2832339968U, 24},
	{2832334848U, 16},
	{2832394240U, 24},
	{2832368128U, 23},
	{2832367616U, 17},
	{2615214080U, 16},
	{3635033088U, 24},
	{3632797184U, 24},
	{3515358976U, 24},
	{3510948608U, 24},
	{3506476800U, 24},
	{3481796864U, 24},
	{3467256320U, 24},
	{3466137856U, 24},
	{3433701376U, 24},
	{3408047872U, 24},
	{3405810944U, 24},
	{3323040000U, 24},
	{3276062976U, 24},
	{3241391104U, 24},
	{3231260416U, 24},
	{3230141952U, 24},
	{2834186240U, 18},
	{2834186496U, 24},
	{2834169856U, 18},
	{2834169856U, 16},
	{2834203648U, 24},
	{2834203136U, 24},
	{2834203392U, 24},
	{3631671552U, 24},
	{3585746944U, 24},
	{3427126784U, 24},
	{3392323328U, 24},
	{3360016896U, 24},
	{3356532480U, 24},
	{3334093568U, 24},
	{3288433152U, 24},
	{3285997568U, 24},
	{3222312704U, 24},
	{2328690688U, 16},
	{3637400064U, 24},
	{3629632256U, 24},
	{3627134208U, 24},
	{3505158144U, 24},
	{3501796608U, 24},
	{3489494528U, 24},
	{3479498496U, 24},
	{3423836928U, 24},
	{3407059968U, 24},
	{3405607680U, 24},
	{3355278848U, 24},
	{3324027392U, 24},
	{3263826944U, 24},
	{2834038784U, 16},
	{2615083008U, 16},
	{2328756224U, 16},
	{3651745024U, 24},
	{3584637184U, 24},
	{3452913408U, 24},
	{3406994432U, 24},
	{3400082944U, 24},
	{3393701888U, 24},
	{3340870400U, 24},
	{3331987712U, 24},
	{3322118144U, 24},
	{3278234368U, 24},
	{3234810368U, 24},
	{3230338560U, 24},
	{3225928192U, 24},
	{2328821760U, 16},
	{3635295232U, 24},
	{3558179584U, 24},
	{3485413888U, 24},
	{3480485376U, 24},
	{3462589952U, 24},
	{3430153472U, 24},
	{3400410624U, 24},
	{3390414080U, 24},
	{3351198208U, 24},
	{3258431232U, 24},
	{3237705984U, 24},
	{2833925120U, 22},
	{2833939456U, 24},
	{2833907712U, 17},
	{2833917440U, 23},
	{2833957376U, 24},
	{2833957632U, 24},
	{2833956864U, 24},
	{2833956864U, 20},
	{2833957120U, 24},
	{2833958400U, 24},
	{2833958656U, 24},
	{2833957888U, 24},
	{2833958144U, 24},
	{2833959424U, 24},
	{2833959680U, 24},
	{2833958912U, 24},
	{2833959168U, 24},
	{2833960448U, 24},
	{2833959936U, 24},
	{2833971712U, 24},
	{2833971968U, 24},
	{2833972736U, 24},
	{2833972224U, 24},
	{2833972480U, 24},
	{2833940992U, 24},
	{2833940480U, 20},
	{2833940736U, 24},
	{2833942016U, 24},
	{2833942272U, 24},
	{2833943040U, 24},
	{2833943296U, 24},
	{2833942528U, 24},
	{2833942784U, 24},
	{2833944320U, 24},
	{2833945088U, 24},
	{2833945344U, 24},
	{2833944576U, 20},
	{2833944832U, 24},
	{2833946112U, 24},
	{2833945600U, 24},
	{2833946880U, 24},
	{2833948160U, 24},
	{2833947904U, 24},
	{2833948672U, 20},
	{2833950208U, 24},
	{2833950464U, 24},
	{2833949952U, 24},
	{2833951232U, 24},
	{2833951488U, 24},
	{2833950720U, 24},
	{2833950976U, 24},
	{2833952512U, 24},
	{2833952000U, 24},
	{2833952768U, 24},
	{2833952768U, 20},
	{2833953024U, 24},
	{2833954048U, 24},
	{2833956352U, 24},
	{2833956608U, 24},
	{2328363008U, 16},
	{3650881024U, 24},
	{3627461888U, 24},
	{3586009088U, 24},
	{3513966592U, 24},
	{3486074112U, 24},
	{3449557504U, 24},
	{3430087936U, 24},
	{3407125504U, 24},
	{3389361152U, 24},
	{3334355712U, 24},
	{3270208000U, 24},
	{3233692928U, 24},
	{3226522368U, 24},
	{3221587456U, 24},
	{2328428544U, 16},
	{3588783360U, 24},
	{3524756736U, 24},
	{3509953536U, 24},
	{3506006272U, 24},
	{3504896000U, 24},
	{3406204160U, 24},
	{3391401472U, 24},
	{3356991232U, 24},
	{3351923968U, 24},
	{3284814080U, 24},
	{3224745216U, 24},
	{2328494080U, 16},
	{3639177216U, 24},
	{3634235136U, 24},
	{3588848896U, 24},
	{3562194688U, 24},
	{3500019456U, 24},
	{3453638144U, 24},
	{3443773184U, 24},
	{3390479616U, 24},
	{3389492224U, 24},
	{3353964288U, 24},
	{3341132544U, 24},
	{3250338816U, 24},
	{3234548224U, 24},
	{3233561856U, 24},
	{2833842432U, 24},
	{2833842176U, 16},
	{2833907200U, 24},
	{2614755328U, 16},
	{2328559616U, 16},
	{3564041216U, 24},
	{3550625536U, 24},
	{3505875200U, 24},
	{3448836608U, 24},
	{3414164736U, 24},
	{3407453184U, 24},
	{3397387264U, 24},
	{3361594112U, 24},
	{3278824192U, 24},
	{3254220800U, 24},
	{3222902528U, 24},
	{2833662976U, 22},
	{2833661952U, 24},
	{2833661952U, 19},
	{2833645568U, 16},
	{2833653760U, 21},
	{2833657856U, 21},
	{2833694720U, 19},
	{2833681408U, 24},
	{2833679360U, 24},
	{2833679616U, 24},
	{2833678848U, 24},
	{2833679104U, 24},
	{2833678592U, 24},
	{2833686016U, 24},
	{2833686272U, 24},
	{2833685760U, 24},
	{2614427648U, 16},
	{3635553536U, 24},
	{3561870848U, 24},
	{3500358656U, 24},
	{3482324992U, 24},
	{3458968064U, 24},
	{3391860224U, 24},
	{3359292672U, 24},
	{3356069376U, 24},
	{3262112256U, 24},
	{3254155264U, 24},
	{3253168384U, 24},
	{3245334784U, 24},
	{3225072896U, 24},
	{3224085504U, 24},
	{2833711104U, 16},
	{2833762560U, 24},
	{2833762304U, 24},
	{2614362112U, 16},
	{3718263040U, 24},
	{3636875776U, 24},
	{3520547328U, 24},
	{3509105920U, 24},
	{3493438720U, 24},
	{3488970240U, 24},
	{3485877504U, 24},
	{3474692096U, 24},
	{3449823488U, 24},
	{3418767616U, 24},
	{3417388544U, 24},
	{3414295808U, 24},
	{3350280704U, 24},
	{3256587520U, 24},
	{3246526208U, 24},
	{3241784320U, 24},
	{2328231936U, 16},
	{3650225664U, 24},
	{3635422464U, 24},
	{3564954880U, 24},
	{3512648192U, 24},
	{3454362880U, 24},
	{3432125184U, 24},
	{3413965312U, 24},
	{3409493504U, 24},
	{3407518720U, 24},
	{3323629824U, 24},
	{3289088512U, 24},
	{3249552384U, 24},
	{3245203712U, 24},
	{3230801664U, 24},
	{3229814272U, 24},
	{2833580032U, 16},
	{2328297472U, 16},
	{3632535040U, 24},
	{3628653056U, 24},
	{3576606976U, 24},
	{3562653440U, 24},
	{3561543168U, 24},
	{3516206592U, 24},
	{3486602240U, 24},
	{3459164672U, 24},
	{3456927744U, 24},
	{3450216704U, 24},
	{3428441856U, 24},
	{3409952256U, 24},
	{3389819904U, 24},
	{3359620352U, 24},
	{3357384448U, 24},
	{3356265984U, 24},
	{3353505536U, 24},
	{3345671936U, 24},
	{3337846528U, 24},
	{3252840704U, 24},
	{3250011136U, 24},
	{3232115712U, 24},
	{3229879808U, 24},
	{3222046208U, 24},
	{2833383424U, 16},
	{2614165504U, 16},
	{2327838720U, 16},
	{3517398272U, 24},
	{3457980672U, 24},
	{3435218432U, 24},
	{3434492160U, 24},
	{3409886720U, 24},
	{3404886784U, 24},
	{3394820352U, 24},
	{3393832960U, 24},
	{3358567424U, 24},
	{3352321024U, 24},
	{3263499264U, 24},
	{2614099968U, 16},
	{3478903808U, 24},
	{3476929024U, 24},
	{3468837888U, 24},
	{3462983168U, 24},
	{3460152064U, 24},
	{3434426624U, 24},
	{3427454464U, 24},
	{3425478656U, 24},
	{3418505472U, 24},
	{3399755264U, 24},
	{3359489280U, 24},
	{3345540864U, 24},
	{3332647424U, 24},
	{3258824448U, 24},
	{3250735872U, 24},
	{3229217024U, 24},
	{2833252352U, 24},
	{2614296576U, 16},
	{2327969792U, 16},
	{3639632128U, 24},
	{3510412288U, 24},
	{3493635328U, 24},
	{3491661568U, 24},
	{3479826176U, 24},
	{3453113856U, 24},
	{3414623488U, 24},
	{3399820800U, 24},
	{3359423744U, 24},
	{3358436352U, 24},
	{3269552640U, 24},
	{3266592512U, 24},
	{3246853888U, 24},
	{3232050176U, 24},
	{3229151488U, 24},
	{2614231040U, 16},
	{2328035328U, 16},
	{3635029248U, 24},
	{3556803328U, 24},
	{3513180160U, 24},
	{3466133504U, 24},
	{3451592960U, 24},
	{3408051712U, 24},
	{3394619392U, 24},
	{3391274752U, 24},
	{3361065472U, 24},
	{3358829568U, 24},
	{3357719808U, 24},
	{3355483904U, 24},
	{3349821952U, 24},
	{3323035648U, 24},
	{3277177088U, 24},
	{3261526784U, 24},
	{3252505344U, 24},
	{3231256064U, 24},
	{3225735936U, 24},
	{3223500032U, 24},
	{2835283968U, 16},
	{2329739264U, 16},
	{3490747904U, 24},
	{3488577024U, 24},
	{3470541824U, 24},
	{3415737600U, 24},
	{3360021248U, 24},
	{3356528128U, 24},
	{2835218432U, 16},
	{2613903360U, 16},
	{2329673728U, 16},
	{3630491904U, 24},
	{3505154304U, 24},
	{3500682496U, 24},
	{3499826688U, 24},
	{3454825472U, 24},
	{3423832576U, 24},
	{3407056128U, 24},
	{3338497536U, 24},
	{3327640576U, 24},
	{3276197888U, 24},
	{3268303104U, 24},
	{3228950528U, 24},
	{3225867008U, 24},
	{3224478720U, 24},
	{2835152896U, 21},
	{2835152896U, 16},
	{2613968896U, 16},
	{2329870336U, 16},
	{3651740672U, 24},
	{3566868992U, 24},
	{3492852736U, 24},
	{3470672896U, 24},
	{3428240896U, 24},
	{3407986176U, 24},
	{3406990592U, 24},
	{3404559104U, 24},
	{3399091200U, 24},
	{3389234432U, 24},
	{3357654272U, 24},
	{3353234688U, 24},
	{3288568576U, 24},
	{3278238208U, 24},
	{3268368640U, 24},
	{3234814720U, 24},
	{3230342912U, 24},
	{2835087360U, 16},
	{2614034432U, 16},
	{2329804800U, 16},
	{3491075584U, 24},
	{3485410048U, 24},
	{3462594304U, 24},
	{3418902528U, 24},
	{3411134720U, 24},
	{3407187200U, 24},
	{3392646656U, 24},
	{3390409728U, 24},
	{3355746048U, 24},
	{3258426880U, 24},
	{2835021824U, 16},
	{2329477120U, 16},
	{3678521344U, 24},
	{3650885376U, 24},
	{3586013440U, 24},
	{3492259072U, 24},
	{3485344512U, 24},
	{3483107584U, 24},
	{3454759936U, 24},
	{3437982976U, 24},
	{3389365504U, 24},
	{3360737792U, 24},
	{3355811584U, 24},
	{3328440064U, 24},
	{3325469184U, 24},
	{3235400192U, 24},
	{2834956288U, 16},
	{2613641216U, 16},
	{2613653504U, 21},
	{2613649408U, 24},
	{2613653758U, 32},
	{3624308480U, 24},
	{3588779008U, 24},
	{3586805248U, 24},
	{3485278976U, 24},
	{3465416960U, 24},
	{3451724032U, 24},
	{3428044288U, 24},
	{3406208000U, 24},
	{3288765184U, 24},
	{3284817920U, 24},
	{3244355584U, 24},
	{3222767104U, 24},
	{3221657344U, 24},
	{2613706752U, 16},
	{2613771776U, 24},
	{3627334656U, 24},
	{3588844544U, 24},
	{3586870784U, 24},
	{3465482496U, 24},
	{3443777024U, 24},
	{3406273536U, 24},
	{3261199104U, 24},
	{2613782528U, 24},
	{2329542656U, 16},
	{3632265216U, 24},
	{3564037376U, 24},
	{3501407232U, 24},
	{3485750272U, 24},
	{3475683840U, 24},
	{3455542528U, 24},
	{3448832768U, 24},
	{3436529152U, 24},
	{3432055296U, 24},
	{3419750656U, 24},
	{3397391616U, 24},
	{3336994560U, 24},
	{3263160832U, 24},
	{3234093824U, 24},
	{3224024320U, 24},
	{2834759680U, 16},
	{3561867008U, 24},
	{3477986304U, 24},
	{3426396160U, 24},
	{3419685120U, 24},
	{3406404608U, 24},
	{3359288320U, 24},
	{3352579328U, 24},
	{3234159360U, 24},
	{2834718720U, 24},
	{2329149440U, 16},
	{3636871936U, 24},
	{3631016192U, 24},
	{3582069248U, 24},
	{3520551680U, 24},
	{3509101568U, 24},
	{3419881728U, 24},
	{3417384704U, 24},
	{3390802944U, 24},
	{3358113024U, 24},
	{3356139264U, 24},
	{3350276864U, 24},
	{3231726848U, 24},
	{2834628608U, 16},
	{2613444608U, 16},
	{3639898112U, 24},
	{3554040064U, 24},
	{3515026944U, 24},
	{3512652544U, 24},
	{3500223744U, 24},
	{3413961472U, 24},
	{3412982272U, 24},
	{3411986688U, 24},
	{3398566912U, 24},
	{3289092864U, 24},
	{2834563072U, 16},
	{2613527552U, 24},
	{2613526528U, 23},
	{2613526528U, 22},
	{2613516032U, 24},
	{2613513216U, 24},
	{2613512192U, 23},
	{2613510144U, 16},
	{2613543936U, 24},
	{2613542912U, 23},
	{2613543680U, 24},
	{3639832576U, 24},
	{3629767168U, 24},
	{3498315520U, 24},
	{3456932096U, 24},
	{3450220544U, 24},
	{3424487936U, 24},
	{3407711488U, 24},
	{3394881536U, 24},
	{3393170944U, 24},
	{3392061184U, 24},
	{3389824256U, 24},
	{3361327616U, 24},
	{3357380096U, 24},
	{3353509376U, 24},
	{3290268160U, 24},
	{3252844544U, 24},
	{3222050560U, 24},
	{2834518016U, 20},
	{2834515968U, 21},
	{2834526208U, 20},
	{2834522112U, 20},
	{2834497536U, 20},
	{2834511360U, 23},
	{2834505728U, 20},
	{2834546688U, 19},
	{2834561024U, 21},
	{2834558976U, 21},
	{2834558976U, 20},
	{2834556928U, 21},
	{2834554880U, 21},
	{2834534400U, 20},
	{2834532352U, 24},
	{2834530304U, 20},
	{2834544640U, 22},
	{2834545664U, 22},
	{2834542592U, 22},
	{2834543616U, 22},
	{2834538496U, 20},
	{2613051392U, 19},
	{2613051392U, 16},
	{2613067520U, 24},
	{2613059584U, 21},
	{2613100288U, 24},
	{2613092352U, 21},
	{3651609600U, 24},
	{3631937536U, 24},
	{3509560320U, 24},
	{3492783360U, 24},
	{3419422976U, 24},
	{3407645952U, 24},
	{3399956224U, 24},
	{3358571776U, 24},
	{3326727424U, 24},
	{3323756544U, 24},
	{3227042304U, 24},
	{2328887296U, 16},
	{3449225984U, 24},
	{3414561792U, 24},
	{3406732288U, 24},
	{3393039872U, 24},
	{3359484928U, 24},
	{3323953152U, 24},
	{3257710336U, 24},
	{3229212672U, 24},
	{2834366464U, 16},
	{2613182464U, 16},
	{3642662656U, 24},
	{3624898304U, 24},
	{3537000448U, 24},
	{3521210368U, 24},
	{3464958208U, 24},
	{3437327616U, 24},
	{3414627328U, 24},
	{3407777024U, 24},
	{3357445632U, 24},
	{3341660672U, 24},
	{3240003328U, 24},
	{3231059456U, 24},
	{2329018368U, 16},
	{3546684672U, 24},
	{3476247552U, 24},
	{3462791168U, 24},
	{3411359232U, 24},
	{3406918144U, 24},
	{3405800192U, 24},
	{3345352960U, 24},
	{3334198528U, 24},
	{3325254912U, 24},
	{3449355264U, 24},
	{3393529344U, 24},
	{3359974400U, 24},
	{3261533184U, 24},
	{3254687232U, 24},
	{3648325120U, 24},
	{3560001280U, 24},
	{3473041152U, 24},
	{3459339520U, 24},
	{3431656448U, 24},
	{3423827200U, 24},
	{3411490304U, 24},
	{3407888640U, 24},
	{3357557248U, 24},
	{3353326080U, 24},
	{3335430656U, 24},
	{3290451456U, 24},
	{2603712512U, 18},
	{2603743232U, 21},
	{2603741184U, 21},
	{2603728896U, 19},
	{2603679744U, 17},
	{2317361152U, 20},
	{2317361152U, 19},
	{2317365248U, 20},
	{3459273984U, 24},
	{3430159104U, 24},
	{3407954176U, 24},
	{3399154432U, 24},
	{3360105472U, 24},
	{3355664384U, 24},
	{3343330048U, 24},
	{3329497344U, 24},
	{3254556160U, 24},
	{3225889792U, 24},
	{2603614208U, 16},
	{3526838528U, 24},
	{3439041280U, 24},
	{3418926848U, 24},
	{3412198656U, 24},
	{3409399808U, 24},
	{3398232576U, 24},
	{3394320128U, 24},
	{3325517056U, 24},
	{3286926592U, 24},
	{3257288704U, 24},
	{2604072960U, 16},
	{2317746176U, 16},
	{3637099520U, 24},
	{3473237760U, 24},
	{3458679808U, 24},
	{3438975744U, 24},
	{3412264192U, 24},
	{3407114752U, 24},
	{3398298112U, 24},
	{3392557312U, 24},
	{3390337792U, 24},
	{3352867328U, 24},
	{3334395136U, 24},
	{3333407744U, 24},
	{3327146752U, 24},
	{3251217664U, 24},
	{3247300864U, 24},
	{3226483968U, 24},
	{2604007424U, 16},
	{2317823744U, 24},
	{2317813504U, 24},
	{2317811712U, 16},
	{3640233728U, 24},
	{3631286016U, 24},
	{3517764352U, 24},
	{3507972096U, 24},
	{3436951808U, 24},
	{3421015296U, 24},
	{3389415936U, 24},
	{3356979456U, 24},
	{3335168512U, 24},
	{3288755200U, 24},
	{3227520512U, 24},
	{3222763776U, 24},
	{2603941888U, 16},
	{3554321920U, 24},
	{3477283584U, 24},
	{3452676352U, 24},
	{3438844672U, 24},
	{3428909568U, 24},
	{3407245824U, 24},
	{3395355648U, 24},
	{3360830720U, 24},
	{3354955776U, 24},
	{3353968896U, 24},
	{3323363072U, 24},
	{3234571264U, 24},
	{2603876352U, 16},
	{2317680640U, 16},
	{3638992384U, 24},
	{3559546368U, 24},
	{3487992064U, 24},
	{3457775360U, 24},
	{3449999104U, 24},
	{3446539008U, 24},
	{3392884992U, 24},
	{3353772288U, 24},
	{3333674240U, 24},
	{3326880256U, 24},
	{3285562880U, 24},
	{3254228480U, 24},
	{2604335104U, 16},
	{2604335616U, 24},
	{2318008320U, 16},
	{3628938240U, 24},
	{3518153216U, 24},
	{3510258176U, 24},
	{3414289152U, 24},
	{3407376896U, 24},
	{3338047744U, 24},
	{3333608704U, 24},
	{3263044864U, 24},
	{3249721856U, 24},
	{3229490944U, 24},
	{3226283008U, 24},
	{2604310528U, 22},
	{2604277760U, 24},
	{2604269568U, 16},
	{2604273664U, 24},
	{2604294144U, 24},
	{2604295168U, 24},
	{2604296192U, 21},
	{2604298240U, 22},
	{2604299520U, 24},
	{2604299264U, 24},
	{2604300032U, 24},
	{2604299776U, 24},
	{2604300288U, 21},
	{2604290048U, 23},
	{2604291840U, 24},
	{2604291584U, 24},
	{3585197568U, 24},
	{3472201984U, 24},
	{3464687104U, 24},
	{3414354688U, 24},
	{3405094144U, 24},
	{3356123136U, 24},
	{3337982208U, 24},
	{3234243584U, 24},
	{2819260416U, 24},
	{2819227648U, 24},
	{2604244992U, 24},
	{2604236800U, 19},
	{2604253184U, 19},
	{2604204032U, 16},
	{2317877248U, 16},
	{3542702336U, 24},
	{3537282816U, 24},
	{3531345152U, 24},
	{3520504832U, 24},
	{3491391744U, 24},
	{3484474368U, 24},
	{3409465344U, 24},
	{3346798592U, 24},
	{3289082880U, 24},
	{3228372480U, 24},
	{3227401472U, 24},
	{2819325952U, 18},
	{2819350528U, 19},
	{2819342336U, 18},
	{2819293184U, 17},
	{2604138496U, 16},
	{3628610560U, 24},
	{3492698624U, 24},
	{3490478080U, 24},
	{3481595648U, 24},
	{3424482560U, 24},
	{3415603712U, 24},
	{3359593216U, 24},
	{3356254208U, 24},
	{3259510272U, 24},
	{3244953344U, 24},
	{3237189376U, 24},
	{2318270464U, 16},
	{3632658432U, 24},
	{3560853248U, 24},
	{3493743360U, 24},
	{3481661184U, 24},
	{3460899328U, 24},
	{3457971968U, 24},
	{3450326784U, 24},
	{3413775360U, 24},
	{3393081600U, 24},
	{3326683648U, 24},
	{3324988416U, 24},
	{3289213952U, 24},
	{3250693376U, 24},
	{2318336000U, 16},
	{3478860288U, 24},
	{3391897600U, 24},
	{3359462144U, 24},
	{3356385280U, 24},
	{3352539648U, 24},
	{3345484032U, 24},
	{3336601600U, 24},
	{3332686848U, 24},
	{3228044800U, 24},
	{3639643904U, 24},
	{3564636928U, 24},
	{3529125632U, 24},
	{3516325888U, 24},
	{3512347648U, 24},
	{3499548928U, 24},
	{3493612288U, 24},
	{3455097344U, 24},
	{3453138944U, 24},
	{3418599168U, 24},
	{3365337344U, 24},
	{3360367616U, 24},
	{3358409216U, 24},
	{3357438208U, 24},
	{3349529856U, 24},
	{3341634816U, 24},
	{3325844736U, 24},
	{2604400640U, 24},
	{2604400640U, 16},
	{3589177856U, 24},
	{3508685312U, 24},
	{3358802432U, 24},
	{3334194176U, 24},
	{3227918080U, 24},
	{3524295168U, 24},
	{3504124928U, 24},
	{3466128896U, 24},
	{3449351424U, 24},
	{3413509376U, 24},
	{3399019008U, 24},
	{3394512384U, 24},
	{3356516352U, 24},
	{3338763776U, 24},
	{3268261632U, 24},
	{2602762240U, 16},
	{2318532608U, 16},
	{3560005120U, 24},
	{3519980544U, 24},
	{3500720896U, 24},
	{3454835200U, 24},
	{3394708992U, 24},
	{3357561600U, 24},
	{3355279616U, 24},
	{3353322240U, 24},
	{3263886080U, 24},
	{3258009600U, 24},
	{3224455680U, 24},
	{2318467072U, 16},
	{3637488896U, 24},
	{3452942336U, 24},
	{3450461696U, 24},
	{3449482496U, 24},
	{3437144064U, 24},
	{3399150080U, 24},
	{3360109824U, 24},
	{3355668736U, 24},
	{3353256704U, 24},
	{3283665152U, 24},
	{3259449088U, 24},
	{3234837760U, 24},
	{3230396672U, 24},
	{3227852544U, 24},
	{2602631168U, 16},
	{2318401536U, 16},
	{3652110848U, 24},
	{3590614784U, 24},
	{3506148864U, 24},
	{3470371328U, 24},
	{3452483584U, 24},
	{3434012416U, 24},
	{3409395968U, 24},
	{3393206016U, 24},
	{3346204928U, 24},
	{3286930432U, 24},
	{3254486784U, 24},
	{2602958848U, 16},
	{3627438592U, 24},
	{3488323584U, 24},
	{3483168512U, 24},
	{3429044992U, 24},
	{3407110912U, 24},
	{3398302464U, 24},
	{3327142400U, 24},
	{2603043840U, 24},
	{2603041792U, 24},
	{2603040768U, 24},
	{3642192128U, 24},
	{3530628096U, 24},
	{3461554688U, 24},
	{3449810176U, 24},
	{3407307520U, 24},
	{3406197248U, 24},
	{3356975104U, 24},
	{3355017472U, 24},
	{3349145344U, 24},
	{3342159104U, 24},
	{3337130240U, 24},
	{3328186624U, 24},
	{3324271872U, 24},
	{3236468480U, 24},
	{3233661440U, 24},
	{3222759424U, 24},
	{3221649664U, 24},
	{2602827776U, 16},
	{3642126592U, 24},
	{3491133440U, 24},
	{3448765440U, 24},
	{3411158784U, 24},
	{3353972736U, 24},
	{3323358720U, 24},
	{2602893312U, 16},
	{3638988544U, 24},
	{3626648320U, 24},
	{3588653568U, 24},
	{3519325184U, 24},
	{3487995904U, 24},
	{3446542848U, 24},
	{3418668544U, 24},
	{3406328320U, 24},
	{3399670016U, 24},
	{3392880640U, 24},
	{3346991360U, 24},
	{3326884608U, 24},
	{2603220992U, 16},
	{3639054080U, 24},
	{3628934400U, 24},
	{3522598656U, 24},
	{3518157568U, 24},
	{3504834304U, 24},
	{3501380096U, 24},
	{3491264512U, 24},
	{3482382080U, 24},
	{3414292992U, 24},
	{3398494720U, 24},
	{3357040640U, 24},
	{3332625664U, 24},
	{3263040512U, 24},
	{3238623232U, 24},
	{3234182400U, 24},
	{3226287360U, 24},
	{2603286528U, 16},
	{3630958336U, 24},
	{3520574720U, 24},
	{3518092032U, 24},
	{3449023744U, 24},
	{3431136512U, 24},
	{3426305536U, 24},
	{3424347136U, 24},
	{3414358528U, 24},
	{3409527040U, 24},
	{3407569664U, 24},
	{3405089792U, 24},
	{3397190656U, 24},
	{3354755328U, 24},
	{3346860288U, 24},
	{3266428928U, 24},
	{3230916608U, 24},
	{3228311296U, 24},
	{2319022848U, 24},
	{3645842432U, 24},
	{3520509184U, 24},
	{3518026496U, 24},
	{3467693056U, 24},
	{3430679040U, 24},
	{3409461504U, 24},
	{3406524928U, 24},
	{3394189056U, 24},
	{3391705344U, 24},
	{3358151424U, 24},
	{3333473280U, 24},
	{3289087232U, 24},
	{3287581952U, 24},
	{3240712704U, 24},
	{3228376832U, 24},
	{2603188224U, 17},
	{2603155456U, 18},
	{2603155456U, 17},
	{2603171840U, 18},
	{3641466880U, 24},
	{3629724672U, 24},
	{3625807872U, 24},
	{3527945984U, 24},
	{3516264704U, 24},
	{3492694784U, 24},
	{3481599488U, 24},
	{3451375360U, 24},
	{3436292096U, 24},
	{3429503744U, 24},
	{3424478208U, 24},
	{3359588864U, 24},
	{3356258560U, 24},
	{3327732224U, 24},
	{3253962496U, 24},
	{3252852224U, 24},
	{3247825152U, 24},
	{3231047680U, 24},
	{2319384576U, 16},
	{3641532416U, 24},
	{3633641472U, 24},
	{3632654592U, 24},
	{3543091200U, 24},
	{3512220928U, 24},
	{3507316736U, 24},
	{3499421696U, 24},
	{3469781504U, 24},
	{3468086272U, 24},
	{3460903680U, 24},
	{3436226560U, 24},
	{3418471936U, 24},
	{3394774528U, 24},
	{3356324096U, 24},
	{3333866496U, 24},
	{3330668288U, 24},
	{3326688000U, 24},
	{3242802176U, 24},
	{3230982144U, 24},
	{3226025216U, 24},
	{2603548672U, 16},
	{2319319040U, 16},
	{3639713280U, 24},
	{3502417152U, 24},
	{3482840832U, 24},
	{3478856448U, 24},
	{3407831808U, 24},
	{3393011712U, 24},
	{3357499392U, 24},
	{3356389632U, 24},
	{3352535808U, 24},
	{3249914624U, 24},
	{3228049152U, 24},
	{3224132352U, 24},
	{2603389696U, 24},
	{2603389440U, 24},
	{2603405568U, 24},
	{2603364352U, 21},
	{2603367424U, 24},
	{2603366656U, 24},
	{2603364096U, 24},
	{2603358208U, 21},
	{2603352064U, 16},
	{2603376640U, 21},
	{2603378688U, 22},
	{2603372288U, 24},
	{2603371776U, 24},
	{2603371520U, 24},
	{3639647744U, 24},
	{3558767616U, 24},
	{3521218048U, 24},
	{3507447808U, 24},
	{3493616128U, 24},
	{3409723648U, 24},
	{3404762112U, 24},
	{3394905600U, 24},
	{3358413568U, 24},
	{3357433856U, 24},
	{3354427648U, 24},
	{3337650176U, 24},
	{3325840384U, 24},
	{3234051328U, 24},
	{3231113216U, 24},
	{2603417600U, 16},
	{2319187968U, 16},
	{3484086016U, 24},
	{3477340416U, 24},
	{3439311104U, 24},
	{3389014016U, 24},
	{3357696000U, 24},
	{3355460096U, 24},
	{3342040576U, 24},
	{3334207232U, 24},
	{3259239424U, 24},
	{3244698880U, 24},
	{3234629120U, 24},
	{3227921408U, 24},
	{2820800512U, 16},
	{2601582592U, 16},
	{3587998208U, 24},
	{3524282624U, 24},
	{3490728704U, 24},
	{3448360704U, 24},
	{3425858816U, 24},
	{3356513024U, 24},
	{3355525632U, 24},
	{3328649728U, 24},
	{3273878272U, 24},
	{2820866048U, 16},
	{2601517056U, 16},
	{3625140992U, 24},
	{3558898688U, 24},
	{3514117120U, 24},
	{3512143360U, 24},
	{3499868928U, 24},
	{3448426240U, 24},
	{3439180032U, 24},
	{3422404096U, 24},
	{3417963008U, 24},
	{3407897344U, 24},
	{3357564928U, 24},
	{3353317376U, 24},
	{3332957696U, 24},
	{3327596800U, 24},
	{3273681664U, 24},
	{3230319104U, 24},
	{2820669440U, 16},
	{3637485056U, 24},
	{3631490304U, 24},
	{3587150592U, 24},
	{3484020480U, 24},
	{3477537024U, 24},
	{3469707264U, 24},
	{3460759552U, 24},
	{3439114496U, 24},
	{3429179392U, 24},
	{3422338560U, 24},
	{3420363776U, 24},
	{3405988096U, 24},
	{3404574208U, 24},
	{3389210624U, 24},
	{3230384640U, 24},
	{3225882112U, 24},
	{2820734976U, 16},
	{3631424768U, 24},
	{3520693760U, 24},
	{3506723584U, 24},
	{3489380864U, 24},
	{3485466112U, 24},
	{3409408512U, 24},
	{3407171584U, 24},
	{3288616448U, 24},
	{3286935296U, 24},
	{3271276288U, 24},
	{3237721344U, 24},
	{3236602880U, 24},
	{2821062656U, 16},
	{2315517952U, 16},
	{3476452864U, 24},
	{3462603264U, 24},
	{3448622848U, 24},
	{3407106048U, 24},
	{3392566016U, 24},
	{3390329088U, 24},
	{3351180800U, 24},
	{3334403840U, 24},
	{3333416448U, 24},
	{3327138048U, 24},
	{3262267136U, 24},
	{2821128192U, 16},
	{2315616256U, 21},
	{2315620352U, 21},
	{2315626496U, 21},
	{2315632128U, 23},
	{2315628544U, 21},
	{2315632640U, 21},
	{2315646976U, 23},
	{2315644928U, 23},
	{2315585536U, 21},
	{2315583488U, 16},
	{2315589632U, 23},
	{2315587584U, 23},
	{2315593728U, 23},
	{2315595776U, 21},
	{2315606016U, 23},
	{2315608064U, 21},
	{3633240576U, 24},
	{3516908032U, 24},
	{3499020800U, 24},
	{3448688384U, 24},
	{3443655424U, 24},
	{3428851712U, 24},
	{3418225152U, 24},
	{3407302656U, 24},
	{3359770112U, 24},
	{3356971776U, 24},
	{3355853312U, 24},
	{3328190976U, 24},
	{3324276224U, 24},
	{3223611392U, 24},
	{3222756096U, 24},
	{2820931584U, 16},
	{2315649024U, 16},
	{3558231808U, 24},
	{3512810752U, 24},
	{3486222592U, 24},
	{3470432512U, 24},
	{3448753920U, 24},
	{3354964480U, 24},
	{3350062848U, 24},
	{3328256512U, 24},
	{3250384896U, 24},
	{3235550976U, 24},
	{3234563584U, 24},
	{3233607936U, 24},
	{3225619968U, 24},
	{2820997120U, 16},
	{2315749376U, 16},
	{2315747328U, 16},
	{2315724800U, 16},
	{2315722752U, 16},
	{2315728896U, 16},
	{2315726848U, 16},
	{2315730944U, 16},
	{2315741184U, 16},
	{2315745280U, 16},
	{3631100928U, 24},
	{3624423936U, 24},
	{3517116672U, 24},
	{3509221632U, 24},
	{3504780288U, 24},
	{3480101632U, 24},
	{3435432448U, 24},
	{3430993408U, 24},
	{3407433728U, 24},
	{3393979392U, 24},
	{3254236160U, 24},
	{3222887168U, 24},
	{2821324800U, 16},
	{3624489472U, 24},
	{3562801920U, 24},
	{3529248000U, 24},
	{3518160896U, 24},
	{3504845824U, 24},
	{3414280448U, 24},
	{3407368192U, 24},
	{3394044928U, 24},
	{3357037312U, 24},
	{3356049920U, 24},
	{3352596480U, 24},
	{3263053568U, 24},
	{3245288704U, 24},
	{3236406272U, 24},
	{3229498624U, 24},
	{2821390336U, 16},
	{2315845632U, 16},
	{3632454144U, 24},
	{3520562688U, 24},
	{3518095360U, 24},
	{3509090560U, 24},
	{3472210688U, 24},
	{3464678400U, 24},
	{3463193088U, 24},
	{3410887936U, 24},
	{3409539584U, 24},
	{3407564800U, 24},
	{3394110464U, 24},
	{3351675136U, 24},
	{3339341056U, 24},
	{3333551872U, 24},
	{3324538368U, 24},
	{3245092096U, 24},
	{2821193728U, 16},
	{3490404864U, 24},
	{3472145152U, 24},
	{3449941248U, 24},
	{3409474048U, 24},
	{3407499264U, 24},
	{3400596224U, 24},
	{3359142144U, 24},
	{3336937984U, 24},
	{3334963200U, 24},
	{3333486336U, 24},
	{3332498944U, 24},
	{3230847744U, 24},
	{3228380160U, 24},
	{3227393792U, 24},
	{3222952704U, 24},
	{2821259264U, 16},
	{2316032000U, 24},
	{2316032512U, 24},
	{2316033024U, 24},
	{2316033792U, 24},
	{2316033536U, 24},
	{2316034048U, 21},
	{2315976704U, 16},
	{3407695872U, 24},
	{3393155840U, 24},
	{3356246528U, 24},
	{3326609408U, 24},
	{3282494208U, 24},
	{3252856064U, 24},
	{2821586944U, 16},
	{2316042240U, 16},
	{3642507776U, 24},
	{3631883520U, 24},
	{3582318336U, 24},
	{3512208896U, 24},
	{3498430976U, 24},
	{3469777152U, 24},
	{3468099328U, 24},
	{3418459392U, 24},
	{3413784064U, 24},
	{3407630336U, 24},
	{3344439296U, 24},
	{3333879552U, 24},
	{3278581504U, 24},
	{3252921600U, 24},
	{3228249088U, 24},
	{2821652480U, 16},
	{2316107776U, 16},
	{3641594624U, 24},
	{3513269504U, 24},
	{3511295744U, 24},
	{3486750720U, 24},
	{3473818880U, 24},
	{3453196800U, 24},
	{3449282048U, 24},
	{3360294400U, 24},
	{3359469824U, 24},
	{3357496064U, 24},
	{3350590976U, 24},
	{3331839232U, 24},
	{2821455872U, 16},
	{2602532864U, 17},
	{2602500096U, 17},
	{2602500096U, 16},
	{2602502656U, 24},
	{2602505216U, 24},
	{2316235776U, 24},
	{2316173312U, 16},
	{3522208768U, 24},
	{3490667008U, 24},
	{3483758336U, 24},
	{3407761408U, 24},
	{3406774528U, 24},
	{3399870976U, 24},
	{3390984448U, 24},
	{3360359936U, 24},
	{3358416896U, 24},
	{3341643520U, 24},
	{3257756160U, 24},
	{3226144256U, 24},
	{3223214848U, 24},
	{2821521408U, 16},
	{2316238848U, 16},
	{3632843520U, 24},
	{3504182784U, 24},
	{3500859648U, 24},
	{3481852928U, 24},
	{3477344256U, 24},
	{3408032256U, 24},
	{3405795328U, 24},
	{3344238848U, 24},
	{3334202880U, 24},
	{3331965952U, 24},
	{3330856192U, 24},
	{3325259264U, 24},
	{3231302144U, 24},
	{2821914624U, 16},
	{3430293504U, 24},
	{3273882112U, 24},
	{3261546240U, 24},
	{3227991296U, 24},
	{2821849088U, 16},
	{2316339200U, 23},
	{2316340224U, 24},
	{2316337664U, 24},
	{2316337920U, 24},
	{2316337408U, 24},
	{2316338944U, 24},
	{2316338176U, 24},
	{2316338432U, 24},
	{2316308480U, 24},
	{2316307456U, 24},
	{2316304384U, 16},
	{2316321024U, 24},
	{3589054464U, 24},
	{3558894848U, 24},
	{3470755840U, 24},
	{3459343872U, 24},
	{3454842880U, 24},
	{3450403840U, 24},
	{3448430080U, 24},
	{3407901184U, 24},
	{3407036672U, 24},
	{3393590528U, 24},
	{3392233984U, 24},
	{3389149440U, 24},
	{3355288320U, 24},
	{3353313536U, 24},
	{3234764544U, 24},
	{3227794688U, 24},
	{3225820928U, 24},
	{2821783552U, 16},
	{2600599552U, 16},
	{2600600832U, 24},
	{2600600576U, 24},
	{3631494144U, 24},
	{3498820352U, 24},
	{3477540864U, 24},
	{3469711616U, 24},
	{3452934656U, 24},
	{3422334720U, 24},
	{3420359936U, 24},
	{3406971136U, 24},
	{3355661056U, 24},
	{3327526912U, 24},
	{3288555264U, 24},
	{3226865152U, 24},
	{3225886464U, 24},
	{2821718016U, 16},
	{2316486656U, 24},
	{2316486912U, 24},
	{2316487168U, 24},
	{2316487424U, 24},
	{2316487680U, 24},
	{2316435456U, 16},
	{3633105664U, 24},
	{3572146432U, 24},
	{3489377024U, 24},
	{3485462272U, 24},
	{3453586176U, 24},
	{3412211200U, 24},
	{3407167744U, 24},
	{3391517440U, 24},
	{3355726592U, 24},
	{3288620800U, 24},
	{3286939136U, 24},
	{3274078720U, 24},
	{3256174592U, 24},
	{3254494464U, 24},
	{3253384192U, 24},
	{3236607232U, 24},
	{3227663616U, 24},
	{2822176768U, 16},
	{3611363328U, 24},
	{3543563008U, 24},
	{3489311488U, 24},
	{3476449024U, 24},
	{3460370688U, 24},
	{3450862592U, 24},
	{3448626688U, 24},
	{3406123008U, 24},
	{3394241536U, 24},
	{3393262848U, 24},
	{3390324736U, 24},
	{3360687616U, 24},
	{3337335552U, 24},
	{3334399488U, 24},
	{3257367296U, 24},
	{3224791040U, 24},
	{2822111232U, 16},
	{2600796160U, 16},
	{3631297536U, 24},
	{3516912384U, 24},
	{3506025472U, 24},
	{3462411008U, 24},
	{3393328384U, 24},
	{3392496128U, 24},
	{3356967424U, 24},
	{3355026176U, 24},
	{3335164160U, 24},
	{3232559360U, 24},
	{3224725504U, 24},
	{2822045696U, 16},
	{2600897792U, 24},
	{2600869376U, 24},
	{2600867584U, 24},
	{2600864256U, 24},
	{2600862976U, 24},
	{2600861696U, 16},
	{2600889856U, 24},
	{2316763136U, 16},
	{3575999488U, 24},
	{3558235648U, 24},
	{3493099520U, 24},
	{3470428160U, 24},
	{3438848000U, 24},
	{3407233280U, 24},
	{3392430592U, 24},
	{3360818688U, 24},
	{3358875648U, 24},
	{3353981440U, 24},
	{3341123072U, 24},
	{3335229696U, 24},
	{3287852800U, 24},
	{2821980160U, 16},
	{2600927232U, 16},
	{2316697600U, 16},
	{3633437184U, 24},
	{3628861184U, 24},
	{3624420096U, 24},
	{3550667264U, 24},
	{3519317504U, 24},
	{3512540928U, 24},
	{3509217280U, 24},
	{3485767680U, 24},
	{3418659840U, 24},
	{3406319616U, 24},
	{3325783552U, 24},
	{3288882944U, 24},
	{3253122048U, 24},
	{2822438912U, 16},
	{2316894208U, 16},
	{3624485632U, 24},
	{3515929344U, 24},
	{3414284288U, 24},
	{3357032960U, 24},
	{3352592640U, 24},
	{3345955328U, 24},
	{3263049216U, 24},
	{3248746496U, 24},
	{3234174720U, 24},
	{3229494272U, 24},
	{3227258368U, 24},
	{3226279680U, 24},
	{2822373376U, 16},
	{2316828672U, 16},
	{3564976128U, 24},
	{3520567040U, 24},
	{3484544768U, 24},
	{3471096576U, 24},
	{3466657536U, 24},
	{3419901184U, 24},
	{3414349824U, 24},
	{3405098496U, 24},
	{3399547648U, 24},
	{3357229568U, 24},
	{3354764032U, 24},
	{3252990976U, 24},
	{3241765120U, 24},
	{3234240256U, 24},
	{2822307840U, 16},
	{2601123840U, 16},
	{2601133824U, 24},
	{2317025280U, 16},
	{3537277952U, 24},
	{3481019136U, 24},
	{3409470208U, 24},
	{3400591872U, 24},
	{3390717952U, 24},
	{3334967552U, 24},
	{3332503296U, 24},
	{2822242304U, 16},
	{2316959744U, 16},
	{2316960000U, 24},
	{3628599040U, 24},
	{3516257024U, 24},
	{3500597504U, 24},
	{3409928960U, 24},
	{3407692032U, 24},
	{3401050624U, 24},
	{3361277440U, 24},
	{3356250880U, 24},
	{3349607936U, 24},
	{3282498048U, 24},
	{3252859904U, 24},
	{2317156352U, 16},
	{3582313984U, 24},
	{3493754880U, 24},
	{3479908864U, 24},
	{3413780224U, 24},
	{3252925440U, 24},
	{3226017536U, 24},
	{2601353216U, 17},
	{2601320448U, 17},
	{2601320448U, 16},
	{2317090816U, 16},
	{3529186304U, 24},
	{3521160192U, 24},
	{3520304896U, 24},
	{3513265152U, 24},
	{3478847744U, 24},
	{3473822720U, 24},
	{3460960512U, 24},
	{3389935872U, 24},
	{3360298752U, 24},
	{3359465472U, 24},
	{3357491712U, 24},
	{3337724416U, 24},
	{3326744832U, 24},
	{3262721536U, 24},
	{3228056832U, 24},
	{3223276032U, 24},
	{2822569984U, 16},
	{2601385984U, 16},
	{3635738624U, 24},
	{3507440128U, 24},
	{3493623808U, 24},
	{3479777792U, 24},
	{3399875328U, 24},
	{3390980096U, 24},
	{3360364288U, 24},
	{3357426176U, 24},
	{3330790656U, 24},
	{3325849088U, 24},
	{3230126848U, 24},
	{3227127296U, 24},
	{2822504448U, 16},
	{2601451520U, 16},
	{3520978944U, 24},
	{3491896832U, 24},
	{3475112192U, 24},
	{3450505984U, 24},
	{3424780800U, 24},
	{3408004352U, 24},
	{3406902784U, 24},
	{3359924224U, 24},
	{3323017984U, 24},
	{3244706560U, 24},
	{3227929088U, 24},
	{2823028736U, 16},
	{2608267264U, 16},
	{2321969664U, 24},
	{2321940480U, 16},
	{3560049408U, 24},
	{3514190336U, 24},
	{3491962368U, 24},
	{3489741824U, 24},
	{3486379776U, 24},
	{3461641984U, 24},
	{3455045376U, 24},
	{3425833728U, 24},
	{3422625792U, 24},
	{3406837248U, 24},
	{3405699328U, 24},
	{3393544704U, 24},
	{3359989760U, 24},
	{3358725888U, 24},
	{3355366400U, 24},
	{3334115584U, 24},
	{3326438912U, 24},
	{3324184576U, 24},
	{3230245888U, 24},
	{3226761472U, 24},
	{2823094272U, 16},
	{2608201728U, 16},
	{2322006016U, 16},
	{3648340480U, 24},
	{3638552832U, 24},
	{3634081024U, 24},
	{3512166400U, 24},
	{3474141696U, 24},
	{3462677504U, 24},
	{3407033856U, 24},
	{3280643840U, 24},
	{3235901696U, 24},
	{2823208960U, 18},
	{2823201792U, 24},
	{2823207936U, 22},
	{2823159808U, 16},
	{2321809408U, 16},
	{3633036288U, 24},
	{3491831296U, 24},
	{3482036992U, 24},
	{3466246912U, 24},
	{3452955904U, 24},
	{3413397504U, 24},
	{3406968320U, 24},
	{3357607424U, 24},
	{3341817856U, 24},
	{3338458368U, 24},
	{3332997120U, 24},
	{3266876672U, 24},
	{3252613120U, 24},
	{3230376960U, 24},
	{3228850944U, 24},
	{3224379136U, 24},
	{3223391744U, 24},
	{2823225344U, 16},
	{2321874944U, 16},
	{3642041344U, 24},
	{3640380160U, 24},
	{3631432448U, 24},
	{3629211904U, 24},
	{3521827584U, 24},
	{3489938432U, 24},
	{3484322048U, 24},
	{3466443520U, 24},
	{3462546432U, 24},
	{3460326912U, 24},
	{3413331968U, 24},
	{3400436736U, 24},
	{3394335488U, 24},
	{3333324800U, 24},
	{2822766592U, 16},
	{3640314624U, 24},
	{3636367104U, 24},
	{3513928192U, 24},
	{3432823040U, 24},
	{3412279552U, 24},
	{3407099392U, 24},
	{3351897856U, 24},
	{3350167808U, 24},
	{3343941120U, 24},
	{3328396288U, 24},
	{3284046848U, 24},
	{3254440448U, 24},
	{3253453568U, 24},
	{3235442944U, 24},
	{3624285184U, 24},
	{3573139200U, 24},
	{3559135744U, 24},
	{3555250432U, 24},
	{3515790592U, 24},
	{3507956736U, 24},
	{3450637056U, 24},
	{3407296000U, 24},
	{3356964096U, 24},
	{3355038720U, 24},
	{3342145536U, 24},
	{3341027584U, 24},
	{3235639552U, 24},
	{3227535872U, 24},
	{3222748416U, 24},
	{2607874048U, 16},
	{2321547264U, 16},
	{3505963776U, 24},
	{3486248704U, 24},
	{3477300992U, 24},
	{3453680640U, 24},
	{3449731072U, 24},
	{3438862080U, 24},
	{3413135360U, 24},
	{3389466112U, 24},
	{3251364096U, 24},
	{3250361856U, 24},
	{3234586624U, 24},
	{3233584896U, 24},
	{3226630400U, 24},
	{2607808512U, 16},
	{3628888064U, 24},
	{3564002816U, 24},
	{3484653568U, 24},
	{3430983680U, 24},
	{3418680064U, 24},
	{3415326208U, 24},
	{3400768768U, 24},
	{3273211392U, 24},
	{3255315968U, 24},
	{3253125888U, 24},
	{2322464768U, 16},
	{3542818048U, 24},
	{3517159168U, 24},
	{3469078016U, 24},
	{3428611328U, 24},
	{3416493312U, 24},
	{3407361536U, 24},
	{3356042240U, 24},
	{3326963200U, 24},
	{3274378496U, 24},
	{3273145856U, 24},
	{3240824576U, 24},
	{2823618560U, 16},
	{2322530304U, 16},
	{3642434560U, 24},
	{3629019136U, 24},
	{3520585728U, 24},
	{3512690688U, 24},
	{3510177280U, 24},
	{3493400320U, 24},
	{3425174016U, 24},
	{3409515520U, 24},
	{3332407296U, 24},
	{3290958336U, 24},
	{3287666688U, 24},
	{3235377408U, 24},
	{2823684096U, 16},
	{3626571264U, 24},
	{3584135936U, 24},
	{3560442624U, 24},
	{3526888704U, 24},
	{3516048384U, 24},
	{3513604864U, 24},
	{3476557824U, 24},
	{3475570944U, 24},
	{3409449984U, 24},
	{3407492608U, 24},
	{3397144832U, 24},
	{3391685632U, 24},
	{3358131712U, 24},
	{3354711040U, 24},
	{3324577792U, 24},
	{3289065472U, 24},
	{3287601152U, 24},
	{3259984384U, 24},
	{3638745600U, 24},
	{3568796416U, 24},
	{3468138752U, 24},
	{3434584832U, 24},
	{3406571264U, 24},
	{3346750464U, 24},
	{3289131008U, 24},
	{3286417664U, 24},
	{3237204736U, 24},
	{3222023168U, 24},
	{2823299328U, 24},
	{2608529408U, 16},
	{2322202624U, 16},
	{3630912000U, 24},
	{3629670656U, 24},
	{3512231936U, 24},
	{3487812864U, 24},
	{3469803264U, 24},
	{3449075712U, 24},
	{3436248320U, 24},
	{3429582336U, 24},
	{3337803008U, 24},
	{3289196544U, 24},
	{3272421120U, 24},
	{3250708736U, 24},
	{2823417856U, 24},
	{2823389184U, 17},
	{2608463872U, 16},
	{2322268160U, 16},
	{3503546624U, 24},
	{3492552192U, 24},
	{3473810176U, 24},
	{3458151168U, 24},
	{3434453760U, 24},
	{3427427328U, 24},
	{3406702336U, 24},
	{3397824000U, 24},
	{3391882240U, 24},
	{3391043328U, 24},
	{3357488384U, 24},
	{3352557056U, 24},
	{3349446912U, 24},
	{3331830528U, 24},
	{3323935488U, 24},
	{3257666560U, 24},
	{2322071552U, 16},
	{3531098368U, 24},
	{3517290240U, 24},
	{3510373888U, 24},
	{3453156352U, 24},
	{3411702272U, 24},
	{3399846912U, 24},
	{3393937920U, 24},
	{3390977792U, 24},
	{3357422848U, 24},
	{3336684544U, 24},
	{3324839936U, 24},
	{3229113088U, 24},
	{3226167296U, 24},
	{2823544832U, 24},
	{2823536640U, 24},
	{2823540736U, 24},
	{2823520256U, 24},
	{2823512064U, 24},
	{2823503872U, 24},
	{2823495680U, 24},
	{2823491584U, 24},
	{3633953792U, 24},
	{3489672448U, 24},
	{3474006784U, 24},
	{3425894912U, 24},
	{3408008192U, 24},
	{3340900352U, 24},
	{3334176768U, 24},
	{3283846400U, 24},
	{3261487360U, 24},
	{3238018048U, 24},
	{2824142848U, 16},
	{2607153152U, 16},
	{2323054592U, 16},
	{3695535360U, 24},
	{3560053248U, 24},
	{3529984256U, 24},
	{3519930368U, 24},
	{3518666496U, 24},
	{3503153408U, 24},
	{3486383616U, 24},
	{3465132800U, 24},
	{3421493248U, 24},
	{3406833408U, 24},
	{3394527744U, 24},
	{3334111232U, 24},
	{3325167616U, 24},
	{3227998976U, 24},
	{2824077312U, 16},
	{2607218688U, 16},
	{3641914624U, 24},
	{3637438720U, 24},
	{3631567360U, 24},
	{3590182656U, 24},
	{3589064192U, 24},
	{3509657344U, 24},
	{3499865088U, 24},
	{3454852608U, 24},
	{3448420352U, 24},
	{3443946496U, 24},
	{3423805440U, 24},
	{3413459200U, 24},
	{3394724352U, 24},
	{3358656000U, 24},
	{3338811904U, 24},
	{3335452416U, 24},
	{3281757952U, 24},
	{3230315776U, 24},
	{3224440320U, 24},
	{2824273920U, 16},
	{2607022080U, 16},
	{3633032448U, 24},
	{3498812672U, 24},
	{3489869056U, 24},
	{3466242560U, 24},
	{3462747392U, 24},
	{3459252224U, 24},
	{3454918144U, 24},
	{3407942656U, 24},
	{3406964480U, 24},
	{3333980160U, 24},
	{3259464448U, 24},
	{3250095872U, 24},
	{3230381312U, 24},
	{3228846592U, 24},
	{3227867904U, 24},
	{3226888192U, 24},
	{3222416384U, 24},
	{2824208896U, 24},
	{2824208384U, 16},
	{2607087616U, 16},
	{2322857984U, 16},
	{3642045696U, 24},
	{3507830016U, 24},
	{3407161088U, 24},
	{3400441088U, 24},
	{3394331136U, 24},
	{3393221376U, 24},
	{3338942976U, 24},
	{3331109632U, 24},
	{3288611072U, 24},
	{3245558528U, 24},
	{3237724672U, 24},
	{3228781056U, 24},
	{2823907584U, 24},
	{2606891008U, 16},
	{2322792448U, 16},
	{3640318464U, 24},
	{3573884928U, 24},
	{3513932544U, 24},
	{3467614464U, 24},
	{3418262784U, 24},
	{3398287104U, 24},
	{3392537600U, 24},
	{3358983680U, 24},
	{3343937280U, 24},
	{3333394688U, 24},
	{3327159808U, 24},
	{3322231552U, 24},
	{3284043008U, 24},
	{3270234368U, 24},
	{3255123712U, 24},
	{3247289344U, 24},
	{2823841280U, 23},
	{2823815168U, 16},
	{2606956544U, 16},
	{3555246080U, 24},
	{3466570240U, 24},
	{3451751168U, 24},
	{3449792768U, 24},
	{3443684352U, 24},
	{3349127936U, 24},
	{3335190272U, 24},
	{3289851904U, 24},
	{3221634304U, 24},
	{2824032256U, 20},
	{2824030208U, 21},
	{2824029184U, 22},
	{2824027648U, 23},
	{2824027392U, 24},
	{2824027136U, 22},
	{2824016896U, 23},
	{2824011776U, 16},
	{2322661376U, 16},
	{3486252544U, 24},
	{3424981760U, 24},
	{3354969344U, 24},
	{3328269568U, 24},
	{3287859456U, 24},
	{3250358016U, 24},
	{3226626048U, 24},
	{2823946240U, 16},
	{2606825472U, 16},
	{2322595840U, 16},
	{3628884224U, 24},
	{3563998976U, 24},
	{3486904064U, 24},
	{3481224448U, 24},
	{3477894656U, 24},
	{3471236352U, 24},
	{3435461888U, 24},
	{3426419200U, 24},
	{3418683904U, 24},
	{3415322368U, 24},
	{3407423232U, 24},
	{3400764416U, 24},
	{3359311360U, 24},
	{3341424640U, 24},
	{3333652480U, 24},
	{3328011776U, 24},
	{3323537920U, 24},
	{3285574400U, 24},
	{3238542336U, 24},
	{2824667136U, 16},
	{2323607552U, 24},
	{2323606272U, 24},
	{2323593216U, 24},
	{2323578880U, 16},
	{3639069440U, 24},
	{3632377088U, 24},
	{3560577536U, 24},
	{3455504128U, 24},
	{3416497152U, 24},
	{3357025280U, 24},
	{3356046592U, 24},
	{3332608256U, 24},
	{3249702656U, 24},
	{3245300224U, 24},
	{3227281408U, 24},
	{3226302720U, 24},
	{2824626176U, 20},
	{2824601600U, 16},
	{2607742976U, 16},
	{3642438912U, 24},
	{3638872832U, 24},
	{3520590080U, 24},
	{3502694656U, 24},
	{3493404160U, 24},
	{3431119104U, 24},
	{3407554304U, 24},
	{3406444032U, 24},
	{3405105152U, 24},
	{3398675968U, 24},
	{3392734208U, 24},
	{3353662464U, 24},
	{3331564032U, 24},
	{3287662848U, 24},
	{3237331456U, 24},
	{2824798208U, 16},
	{3630067712U, 24},
	{3550577664U, 24},
	{3526892544U, 24},
	{3498288384U, 24},
	{3491380224U, 24},
	{3484453120U, 24},
	{3471170816U, 24},
	{3409446144U, 24},
	{3407488768U, 24},
	{3405039616U, 24},
	{3291028224U, 24},
	{3289069824U, 24},
	{3287597312U, 24},
	{3259988736U, 24},
	{3245169152U, 24},
	{3229857024U, 24},
	{2824732672U, 16},
	{2607619328U, 24},
	{2607613184U, 24},
	{2607611904U, 16},
	{2323382272U, 16},
	{3628013056U, 24},
	{3568800256U, 24},
	{3516249344U, 24},
	{3479852032U, 24},
	{3468134400U, 24},
	{3455307520U, 24},
	{3397074944U, 24},
	{3289135360U, 24},
	{3237200384U, 24},
	{2824404992U, 16},
	{2607415296U, 16},
	{2323316736U, 16},
	{3632639232U, 24},
	{3631895040U, 24},
	{3630908160U, 24},
	{3570463744U, 24},
	{3517416960U, 24},
	{3490524416U, 24},
	{3481647616U, 24},
	{3469798912U, 24},
	{3429586688U, 24},
	{3390842368U, 24},
	{3359507968U, 24},
	{3326705408U, 24},
	{3325954048U, 24},
	{3324975360U, 24},
	{3289200896U, 24},
	{2824396800U, 24},
	{2824374784U, 24},
	{2824356352U, 24},
	{2824339456U, 16},
	{2607513856U, 16},
	{3543997696U, 24},
	{3524144896U, 24},
	{3519209472U, 24},
	{3488730368U, 24},
	{3470843136U, 24},
	{3425440512U, 24},
	{3412611072U, 24},
	{3406706176U, 24},
	{3397828352U, 24},
	{3394986496U, 24},
	{3359442432U, 24},
	{3357484032U, 24},
	{3349450752U, 24},
	{3345505280U, 24},
	{3331826176U, 24},
	{2824536064U, 16},
	{2607284224U, 16},
	{3696915456U, 24},
	{3531102208U, 24},
	{3507432448U, 24},
	{3498550528U, 24},
	{3437354752U, 24},
	{3411698432U, 24},
	{3390973440U, 24},
	{3244907008U, 24},
	{3234066688U, 24},
	{3230119168U, 24},
	{2607349760U, 16},
	{3518735360U, 24},
	{3506430208U, 24},
	{3465054208U, 24},
	{3438210048U, 24},
	{3432618752U, 24},
	{3406894080U, 24},
	{3359916544U, 24},
	{3343142144U, 24},
	{3262610176U, 24},
	{3261491712U, 24},
	{2825256960U, 16},
	{2606039040U, 16},
	{3695531520U, 24},
	{3359982080U, 24},
	{3345444608U, 24},
	{3223530496U, 24},
	{3222281984U, 24},
	{2825322496U, 16},
	{2605973504U, 16},
	{2319819776U, 16},
	{2319818752U, 16},
	{3641902592U, 24},
	{3486436608U, 24},
	{3431631360U, 24},
	{3430249728U, 24},
	{3407881984U, 24},
	{3394720000U, 24},
	{3355309568U, 24},
	{3323996672U, 24},
	{3285106944U, 24},
	{3280635136U, 24},
	{2825125888U, 16},
	{2606170112U, 16},
	{2319843328U, 16},
	{3585646592U, 24},
	{3547621888U, 24},
	{3490844416U, 24},
	{3489865216U, 24},
	{3455908864U, 24},
	{3425710336U, 24},
	{3407947520U, 24},
	{3406959616U, 24},
	{3389195264U, 24},
	{3357615104U, 24},
	{3350770176U, 24},
	{3335504896U, 24},
	{3288533504U, 24},
	{3264910592U, 24},
	{3244648704U, 24},
	{3230369280U, 24},
	{3228858624U, 24},
	{2825224192U, 21},
	{2825191424U, 16},
	{2825197568U, 21},
	{2825195520U, 21},
	{2606104576U, 16},
	{3625256704U, 24},
	{3586105344U, 24},
	{3422288384U, 24},
	{3413340672U, 24},
	{3409393152U, 24},
	{3407156224U, 24},
	{3406038272U, 24},
	{3398208512U, 24},
	{3352941568U, 24},
	{3258400512U, 24},
	{2825046272U, 24},
	{2824994816U, 16},
	{2605776896U, 16},
	{2319450112U, 16},
	{3631374592U, 24},
	{3585061120U, 24},
	{3523550208U, 24},
	{3489332736U, 24},
	{3398274048U, 24},
	{3392550656U, 24},
	{3350176512U, 24},
	{3343932416U, 24},
	{3328404992U, 24},
	{3287016192U, 24},
	{3270238720U, 24},
	{3253461248U, 24},
	{3251225344U, 24},
	{3235435264U, 24},
	{3233723648U, 24},
	{3221556736U, 24},
	{2825060352U, 16},
	{2605711360U, 16},
	{3587950080U, 24},
	{3449788928U, 24},
	{3424919552U, 24},
	{3407287296U, 24},
	{3356956416U, 24},
	{3351954688U, 24},
	{3349123072U, 24},
	{3286819584U, 24},
	{3244321024U, 24},
	{3241491456U, 24},
	{3223596032U, 24},
	{2824915968U, 23},
	{2824918016U, 24},
	{2824929024U, 24},
	{2824896512U, 22},
	{2824897536U, 23},
	{2824898048U, 24},
	{2824898304U, 24},
	{2824900608U, 22},
	{2824882176U, 21},
	{2824880128U, 21},
	{2824863744U, 16},
	{2605907968U, 16},
	{2319581184U, 16},
	{3659871744U, 24},
	{3627296000U, 24},
	{3477292288U, 24},
	{3471437312U, 24},
	{3459527424U, 24},
	{3418144256U, 24},
	{3413144064U, 24},
	{3335242752U, 24},
	{3328273920U, 24},
	{3234578944U, 24},
	{3224648960U, 24},
	{2824929280U, 16},
	{2605842432U, 16},
	{2319646720U, 16},
	{3628880384U, 24},
	{3585318912U, 24},
	{3583083008U, 24},
	{3520446976U, 24},
	{3483544320U, 24},
	{3458867712U, 24},
	{3455581184U, 24},
	{3429786624U, 24},
	{3418671360U, 24},
	{3415317504U, 24},
	{3397422080U, 24},
	{3325770496U, 24},
	{3257544192U, 24},
	{3255307264U, 24},
	{3253133568U, 24},
	{3229648384U, 24},
	{3632373248U, 24},
	{3480184576U, 24},
	{3466832384U, 24},
	{3394060288U, 24},
	{3359257856U, 24},
	{3354850816U, 24},
	{3326954496U, 24},
	{3259844608U, 24},
	{3238596352U, 24},
	{3228526592U, 24},
	{2825846784U, 16},
	{2606497792U, 16},
	{2320302080U, 16},
	{3633549056U, 24},
	{3534857984U, 24},
	{3520578048U, 24},
	{3499329280U, 24},
	{3498219008U, 24},
	{3454332160U, 24},
	{3410903296U, 24},
	{3357218560U, 24},
	{3354785280U, 24},
	{3287675392U, 24},
	{3228329984U, 24},
	{2825650176U, 16},
	{2606694400U, 16},
	{2320367616U, 16},
	{3639929088U, 24},
	{3635457280U, 24},
	{3629076992U, 24},
	{3514591232U, 24},
	{3504730112U, 24},
	{3452423936U, 24},
	{3430708480U, 24},
	{3395178752U, 24},
	{3354719744U, 24},
	{3351758080U, 24},
	{3273268224U, 24},
	{3266361088U, 24},
	{3246159872U, 24},
	{3241688064U, 24},
	{3240701184U, 24},
	{3230832384U, 24},
	{2606654976U, 24},
	{2606655488U, 21},
	{2606628864U, 16},
	{2606641152U, 21},
	{2606643200U, 21},
	{3628618240U, 24},
	{3516237312U, 24},
	{3436306176U, 24},
	{3418409216U, 24},
	{3414461696U, 24},
	{3393732608U, 24},
	{3390903552U, 24},
	{3358467072U, 24},
	{3250041856U, 24},
	{3241028864U, 24},
	{3231028992U, 24},
	{2825519616U, 24},
	{2825519872U, 24},
	{2825519104U, 16},
	{2825524736U, 24},
	{2319974400U, 16},
	{3631898880U, 24},
	{3628683776U, 24},
	{3517428992U, 24},
	{3508276736U, 24},
	{3468081920U, 24},
	{3436240640U, 24},
	{3359520000U, 24},
	{3332874752U, 24},
	{3249976320U, 24},
	{3242806016U, 24},
	{3228264448U, 24},
	{3227015936U, 24},
	{3224316928U, 24},
	{2606235648U, 16},
	{2320039936U, 16},
	{3492559872U, 24},
	{3486768128U, 24},
	{3431369216U, 24},
	{3398933760U, 24},
	{3391890944U, 24},
	{3359454464U, 24},
	{3357480704U, 24},
	{3350573568U, 24},
	{3262741248U, 24},
	{3258793728U, 24},
	{3249910784U, 24},
	{3223265024U, 24},
	{2606467072U, 24},
	{2606467328U, 24},
	{2606467584U, 24},
	{2606448640U, 24},
	{2606448896U, 24},
	{2606450944U, 24},
	{2606451200U, 24},
	{2606451456U, 24},
	{2606452736U, 24},
	{2606452992U, 24},
	{2606454784U, 24},
	{2606432256U, 16},
	{2606433280U, 24},
	{2606433792U, 24},
	{2606434304U, 24},
	{2606436352U, 24},
	{2606436608U, 24},
	{2606436864U, 24},
	{2606437120U, 24},
	{2606437376U, 24},
	{2320105472U, 16},
	{3558738688U, 24},
	{3507429120U, 24},
	{3493604608U, 24},
	{3482753024U, 24},
	{3466963456U, 24},
	{3453148672U, 24},
	{3407746048U, 24},
	{3360375296U, 24},
	{3257740800U, 24},
	{2825453568U, 16},
	{2320171008U, 16},
	{2320185088U, 24},
	{3628352256U, 24},
	{3531045376U, 24},
	{3432614400U, 24},
	{3416964608U, 24},
	{3406890240U, 24},
	{3367742464U, 24},
	{3359920896U, 24},
	{3264840704U, 24},
	{3233522688U, 24},
	{3224579072U, 24},
	{2604924928U, 16},
	{2320826368U, 16},
	{3607169024U, 24},
	{3560060928U, 24},
	{3452820992U, 24},
	{3449326336U, 24},
	{3405845504U, 24},
	{3359986432U, 24},
	{3330904320U, 24},
	{3276101632U, 24},
	{3231221248U, 24},
	{2605010944U, 20},
	{2605006848U, 19},
	{2605015040U, 23},
	{2604996608U, 22},
	{2604990464U, 16},
	{2320760832U, 16},
	{3486440448U, 24},
	{3483941376U, 24},
	{3467164416U, 24},
	{3423797760U, 24},
	{3411493120U, 24},
	{3398081792U, 24},
	{3358663680U, 24},
	{3339913472U, 24},
	{3332944640U, 24},
	{3280638976U, 24},
	{3234779904U, 24},
	{3230308096U, 24},
	{2605088768U, 19},
	{2605076480U, 21},
	{2605060096U, 20},
	{2605064192U, 24},
	{2605064192U, 21},
	{2605064192U, 20},
	{2320957440U, 16},
	{3556569856U, 24},
	{3524402176U, 24},
	{3491835136U, 24},
	{3454925824U, 24},
	{3452952064U, 24},
	{3430179840U, 24},
	{3425705984U, 24},
	{3407951360U, 24},
	{3406955776U, 24},
	{3350766336U, 24},
	{3264906240U, 24},
	{3226880512U, 24},
	{3225901824U, 24},
	{2605121536U, 16},
	{2320891904U, 16},
	{3635326208U, 24},
	{3521830912U, 24},
	{3489926912U, 24},
	{3487157504U, 24},
	{3451889920U, 24},
	{3430114304U, 24},
	{3413336832U, 24},
	{3409389312U, 24},
	{3407152384U, 24},
	{3398212864U, 24},
	{3338934272U, 24},
	{3237732352U, 24},
	{3236622592U, 24},
	{2826141696U, 17},
	{2826108928U, 17},
	{2826108928U, 16},
	{2604662784U, 16},
	{2320564224U, 16},
	{3644932608U, 24},
	{3631378432U, 24},
	{3585056768U, 24},
	{3411034368U, 24},
	{3406107648U, 24},
	{3392546304U, 24},
	{3343928576U, 24},
	{3325438464U, 24},
	{3270243072U, 24},
	{3232740608U, 24},
	{3231483392U, 24},
	{3224775680U, 24},
	{3221561088U, 24},
	{2826049536U, 24},
	{2826045440U, 24},
	{2826043392U, 16},
	{2826044416U, 24},
	{2320498688U, 16},
	{3584860160U, 24},
	{3555254784U, 24},
	{3522818304U, 24},
	{3515778560U, 24},
	{3483339008U, 24},
	{3460453632U, 24},
	{3407283456U, 24},
	{3358925824U, 24},
	{3356952064U, 24},
	{3337156352U, 24},
	{3328212736U, 24},
	{3222736384U, 24},
	{2320695296U, 16},
	{3484269056U, 24},
	{3434915840U, 24},
	{3422087936U, 24},
	{3407217920U, 24},
	{3358860288U, 24},
	{3350049280U, 24},
	{3234583296U, 24},
	{3225639680U, 24},
	{3223665920U, 24},
	{2604859392U, 16},
	{3633421824U, 24},
	{3520451328U, 24},
	{3481233152U, 24},
	{3455577344U, 24},
	{3449993216U, 24},
	{3447757312U, 24},
	{3426426880U, 24},
	{3420912128U, 24},
	{3418675200U, 24},
	{3415313664U, 24},
	{3397426432U, 24},
	{3333661184U, 24},
	{3253137408U, 24},
	{3223993600U, 24},
	{2826895360U, 16},
	{2605449216U, 16},
	{3641247232U, 24},
	{3637828096U, 24},
	{3632164864U, 24},
	{3510254848U, 24},
	{3501372416U, 24},
	{3490254592U, 24},
	{3354846976U, 24},
	{3338069504U, 24},
	{3332616960U, 24},
	{3323463680U, 24},
	{3259848960U, 24},
	{3253202944U, 24},
	{3249710336U, 24},
	{3236425984U, 24},
	{2826834688U, 24},
	{2826836736U, 24},
	{2826829824U, 16},
	{2826845184U, 24},
	{2826845440U, 24},
	{2605514752U, 16},
	{2321285120U, 16},
	{3633552896U, 24},
	{3522556160U, 24},
	{3478017024U, 24},
	{3464665344U, 24},
	{3431111424U, 24},
	{3410907136U, 24},
	{3407545600U, 24},
	{3406435328U, 24},
	{3392742912U, 24},
	{3358078208U, 24},
	{3354781440U, 24},
	{3351696384U, 24},
	{3344911616U, 24},
	{3332420352U, 24},
	{3331555328U, 24},
	{3287671552U, 24},
	{3264447488U, 24},
	{3248534528U, 24},
	{3237339136U, 24},
	{3235365376U, 24},
	{3228334336U, 24},
	{2605580288U, 16},
	{3626575104U, 24},
	{3520516864U, 24},
	{3512621824U, 24},
	{3508150016U, 24},
	{3505713152U, 24},
	{3453406976U, 24},
	{3430704128U, 24},
	{3409454848U, 24},
	{3407480064U, 24},
	{3395174400U, 24},
	{3257483008U, 24},
	{3245176832U, 24},
	{3230828032U, 24},
	{2605645824U, 16},
	{3628614400U, 24},
	{3531307520U, 24},
	{3516241664U, 24},
	{3510582528U, 24},
	{3503411712U, 24},
	{3502293760U, 24},
	{3492687104U, 24},
	{3470982912U, 24},
	{3414465536U, 24},
	{3395973888U, 24},
	{3394846720U, 24},
	{3390899200U, 24},
	{3356235520U, 24},
	{3340568832U, 24},
	{3263468800U, 24},
	{2826633216U, 16},
	{2605236224U, 20},
	{2605224192U, 24},
	{2605224960U, 22},
	{2605219840U, 22},
	{2605228288U, 24},
	{2605212672U, 24},
	{2605187072U, 16},
	{2321137664U, 18},
	{2321121280U, 18},
	{2321088512U, 17},
	{2321088512U, 16},
	{3631902720U, 24},
	{3630915840U, 24},
	{3570456064U, 24},
	{3512228608U, 24},
	{3481638912U, 24},
	{3436236288U, 24},
	{3429594368U, 24},
	{3415510272U, 24},
	{3394781184U, 24},
	{3390833664U, 24},
	{3354584832U, 24},
	{3352347904U, 24},
	{3327675392U, 24},
	{3242809856U, 24},
	{3233927936U, 24},
	{2826600448U, 17},
	{2826567680U, 17},
	{2826567680U, 16},
	{2321022976U, 16},
	{3639736320U, 24},
	{3519201792U, 24},
	{3504398592U, 24},
	{3498477312U, 24},
	{3492556032U, 24},
	{3491700224U, 24},
	{3407807744U, 24},
	{3406697472U, 24},
	{3389920512U, 24},
	{3359450112U, 24},
	{3357476352U, 24},
	{3352544512U, 24},
	{3350569728U, 24},
	{3349459456U, 24},
	{3340699904U, 24},
	{3330707712U, 24},
	{3323922432U, 24},
	{3257679616U, 24},
	{3229181952U, 24},
	{3227208192U, 24},
	{3223260672U, 24},
	{2605318144U, 16},
	{3659404288U, 24},
	{3531110912U, 24},
	{3507424768U, 24},
	{3498542848U, 24},
	{3487694336U, 24},
	{3418609664U, 24},
	{3411689728U, 24},
	{3345579520U, 24},
	{3333726720U, 24},
	{2826452992U, 18},
	{2826443264U, 24},
	{2826443520U, 24},
	{2826436608U, 18},
	{2826439680U, 24},
	{2826439936U, 24},
	{2605383680U, 16},
	{2321154048U, 16},
	{3641833472U, 24},
	{3638375680U, 24},
	{3632816128U, 24},
	{3531052288U, 24},
	{3529933824U, 24},
	{3489718272U, 24},
	{3470598912U, 24},
	{3451602432U, 24},
	{3411389952U, 24},
	{3408058624U, 24},
	{3361058048U, 24},
	{3359947776U, 24},
	{3353160192U, 24},
	{3325281536U, 24},
	{3264834304U, 24},
	{3261502464U, 24},
	{3238064384U, 24},
	{3231279360U, 24},
	{3229058816U, 24},
	{3225728000U, 24},
	{2845382400U, 24},
	{2845376512U, 17},
	{2845376512U, 16},
	{2845422080U, 24},
	{2845423616U, 24},
	{2845413376U, 24},
	{2845409280U, 17},
	{2845409792U, 24},
	{2845410304U, 24},
	{2845410816U, 24},
	{2845411328U, 24},
	{2845428480U, 24},
	{3638310144U, 24},
	{3631652608U, 24},
	{3489783808U, 24},
	{3468313856U, 24},
	{3455975936U, 24},
	{3438219776U, 24},
	{3406883328U, 24},
	{3405904640U, 24},
	{3344212480U, 24},
	{3223572992U, 24},
	{2845310976U, 16},
	{3556959232U, 24},
	{3514144256U, 24},
	{3505131008U, 24},
	{3433584128U, 24},
	{3428296960U, 24},
	{3413478400U, 24},
	{3407079936U, 24},
	{3398070784U, 24},
	{3324040192U, 24},
	{3254586880U, 24},
	{2845507584U, 16},
	{3588110336U, 24},
	{3576747520U, 24},
	{3564409600U, 24},
	{3469685248U, 24},
	{3467203584U, 24},
	{3455844864U, 24},
	{3437109504U, 24},
	{3430189824U, 24},
	{3412434176U, 24},
	{3407993088U, 24},
	{3399115520U, 24},
	{3394678528U, 24},
	{3389258240U, 24},
	{3226903808U, 24},
	{2845442048U, 16},
	{2344091648U, 16},
	{3672769536U, 24},
	{3563225600U, 24},
	{3449644032U, 24},
	{3406101248U, 24},
	{3393240576U, 24},
	{3359099648U, 24},
	{3224879872U, 24},
	{2845638656U, 16},
	{2344550400U, 18},
	{2344579072U, 20},
	{2344574976U, 20},
	{2344566784U, 19},
	{2344595456U, 21},
	{2344591360U, 20},
	{2344587264U, 21},
	{2344589312U, 21},
	{2344583168U, 20},
	{2344607744U, 19},
	{2344603648U, 20},
	{2344599552U, 20},
	{3653838080U, 24},
	{3650908160U, 24},
	{3586022912U, 24},
	{3558143232U, 24},
	{3555396864U, 24},
	{3547501568U, 24},
	{3533470464U, 24},
	{3519622400U, 24},
	{3506052864U, 24},
	{3407145472U, 24},
	{3406166784U, 24},
	{3359034112U, 24},
	{3355052032U, 24},
	{3346169856U, 24},
	{3339056896U, 24},
	{3337295872U, 24},
	{3328413696U, 24},
	{3247274240U, 24},
	{3244529408U, 24},
	{3235392768U, 24},
	{3233696512U, 24},
	{3224814336U, 24},
	{3222593792U, 24},
	{2845573120U, 16},
	{3559179776U, 24},
	{3529540608U, 24},
	{3511923712U, 24},
	{3502910464U, 24},
	{3500112128U, 24},
	{3470467840U, 24},
	{3449775104U, 24},
	{3434956544U, 24},
	{3412106496U, 24},
	{3407342080U, 24},
	{3406232320U, 24},
	{3401400576U, 24},
	{3367846656U, 24},
	{3327369984U, 24},
	{3257192448U, 24},
	{3256345344U, 24},
	{3227555328U, 24},
	{3490177024U, 24},
	{3486200576U, 24},
	{3463481600U, 24},
	{3462502400U, 24},
	{3450689280U, 24},
	{3411193344U, 24},
	{3407276544U, 24},
	{3392456960U, 24},
	{3389520384U, 24},
	{3343102720U, 24},
	{3328282624U, 24},
	{3273056768U, 24},
	{3250342400U, 24},
	{2845704192U, 16},
	{2845762048U, 24},
	{2845761792U, 24},
	{2845761536U, 24},
	{3501415168U, 24},
	{3499194624U, 24},
	{3407473152U, 24},
	{3400745216U, 24},
	{3358251520U, 24},
	{3351526144U, 24},
	{3332529152U, 24},
	{3326915072U, 24},
	{3323586304U, 24},
	{3263137024U, 24},
	{3245250304U, 24},
	{3222921472U, 24},
	{2844852224U, 24},
	{2844901376U, 24},
	{2343763968U, 16},
	{3631189504U, 24},
	{3564077568U, 24},
	{3519360256U, 24},
	{3513747200U, 24},
	{3500362240U, 24},
	{3484566528U, 24},
	{3469029888U, 24},
	{3448792064U, 24},
	{3407407616U, 24},
	{3406428928U, 24},
	{3399700480U, 24},
	{3398460160U, 24},
	{3357075712U, 24},
	{3354789888U, 24},
	{3337033728U, 24},
	{3234151424U, 24},
	{3224097280U, 24},
	{2844786688U, 16},
	{2343698432U, 16},
	{3653641472U, 24},
	{3639940864U, 24},
	{3638822400U, 24},
	{3455386112U, 24},
	{3398656768U, 24},
	{3391674368U, 24},
	{3333508352U, 24},
	{3280108288U, 24},
	{3236175360U, 24},
	{2844983296U, 16},
	{2343632896U, 16},
	{3629100032U, 24},
	{3517995520U, 24},
	{3508203520U, 24},
	{3455320576U, 24},
	{3428755712U, 24},
	{3413937152U, 24},
	{3409496064U, 24},
	{3407538688U, 24},
	{3406560000U, 24},
	{3404989696U, 24},
	{3397612032U, 24},
	{3397160192U, 24},
	{3392719104U, 24},
	{3343889152U, 24},
	{3340428800U, 24},
	{3332463616U, 24},
	{3253997056U, 24},
	{3246163456U, 24},
	{3230820608U, 24},
	{3227428096U, 24},
	{2844917760U, 16},
	{3624724480U, 24},
	{3584446208U, 24},
	{3557614592U, 24},
	{3516233728U, 24},
	{3514537472U, 24},
	{3428428032U, 24},
	{3413871616U, 24},
	{3409954816U, 24},
	{3406625536U, 24},
	{3397094656U, 24},
	{3393177856U, 24},
	{3344540160U, 24},
	{3263461888U, 24},
	{3252821760U, 24},
	{3250601216U, 24},
	{3231017216U, 24},
	{3222073344U, 24},
	{3517401856U, 24},
	{3468051712U, 24},
	{3463157760U, 24},
	{3426668288U, 24},
	{3409889280U, 24},
	{3407669760U, 24},
	{3404858624U, 24},
	{3394809600U, 24},
	{3358579200U, 24},
	{3356358656U, 24},
	{3274690816U, 24},
	{3263527424U, 24},
	{3234868480U, 24},
	{3229972480U, 24},
	{2845048832U, 16},
	{2343960576U, 16},
	{3667358464U, 24},
	{3637720320U, 24},
	{3579555840U, 24},
	{3575641088U, 24},
	{3535100160U, 24},
	{3512448000U, 24},
	{3461003776U, 24},
	{3434432256U, 24},
	{3391936512U, 24},
	{3323979520U, 24},
	{3256869632U, 24},
	{3235065088U, 24},
	{3231148288U, 24},
	{2845245440U, 16},
	{3659463424U, 24},
	{3629825280U, 24},
	{3627866880U, 24},
	{3514340864U, 24},
	{3407800832U, 24},
	{3406822144U, 24},
	{3357468928U, 24},
	{3262678272U, 24},
	{3230103552U, 24},
	{2845179904U, 16},
	{2343829504U, 16},
	{3641829632U, 24},
	{3638371328U, 24},
	{3514271488U, 24},
	{3490832384U, 24},
	{3411394304U, 24},
	{3408054272U, 24},
	{3406953216U, 24},
	{3359943936U, 24},
	{3261498624U, 24},
	{3259279104U, 24},
	{3252501760U, 24},
	{3243619584U, 24},
	{3225724160U, 24},
	{2844262400U, 16},
	{553648128U, 8},
	{3641764096U, 24},
	{3631648256U, 24},
	{3511985408U, 24},
	{3476217088U, 24},
	{3465111296U, 24},
	{3427117312U, 24},
	{3405900288U, 24},
	{3254656768U, 24},
	{3237879296U, 24},
	{3223569152U, 24},
	{2844327936U, 16},
	{2343239680U, 16},
	{2343245824U, 21},
	{2343256064U, 19},
	{3512182016U, 24},
	{3483911168U, 24},
	{3454796288U, 24},
	{3423861760U, 24},
	{3416801280U, 24},
	{3407923200U, 24},
	{3398066944U, 24},
	{3353295616U, 24},
	{3335400192U, 24},
	{3247073280U, 24},
	{3244590592U, 24},
	{3235855360U, 24},
	{2844393472U, 16},
	{3637458176U, 24},
	{3564405248U, 24},
	{3482019328U, 24},
	{3467199744U, 24},
	{3430193664U, 24},
	{3420337920U, 24},
	{3394682368U, 24},
	{3389254400U, 24},
	{3234802944U, 24},
	{3227879168U, 24},
	{2844471296U, 20},
	{2844474112U, 24},
	{2844473344U, 24},
	{2844474880U, 24},
	{2844459008U, 19},
	{2844459264U, 24},
	{2844461056U, 24},
	{2844463872U, 24},
	{2844464640U, 24},
	{2844464896U, 24},
	{2844465664U, 23},
	{2844465152U, 24},
	{2844465408U, 24},
	{2844466688U, 24},
	{2844484352U, 24},
	{2844488448U, 24},
	{2844487680U, 24},
	{2844487936U, 24},
	{2844489216U, 24},
	{2844489472U, 24},
	{2844488960U, 24},
	{2844490496U, 24},
	{2844489728U, 24},
	{2844489984U, 24},
	{2844490752U, 23},
	{2844475392U, 18},
	{2844475648U, 24},
	{2844501504U, 24},
	{2844500992U, 24},
	{2844503552U, 24},
	{2844503808U, 24},
	{2844504064U, 24},
	{2844504320U, 24},
	{2844505856U, 24},
	{2844505088U, 24},
	{2844507648U, 24},
	{2844507136U, 23},
	{2844491776U, 18},
	{2844496896U, 22},
	{2844516352U, 24},
	{2844516608U, 24},
	{2844518144U, 24},
	{2844520960U, 24},
	{2844521216U, 24},
	{2844520448U, 24},
	{2844522240U, 24},
	{2844523008U, 23},
	{2844523520U, 24},
	{2844523776U, 24},
	{2844508160U, 18},
	{2844514816U, 24},
	{2844515072U, 24},
	{2844514304U, 24},
	{2844514560U, 24},
	{2844515840U, 24},
	{2844516096U, 24},
	{2844515328U, 24},
	{2844515584U, 24},
	{2343108608U, 16},
	{3625314304U, 24},
	{3563229952U, 24},
	{3483203328U, 24},
	{3480459520U, 24},
	{3435667712U, 24},
	{3265100288U, 24},
	{3237682688U, 24},
	{3224883712U, 24},
	{2844524544U, 24},
	{2844540928U, 24},
	{2844557312U, 24},
	{2844573696U, 24},
	{2343436288U, 16},
	{3650904320U, 24},
	{3558138880U, 24},
	{3555400704U, 24},
	{3488284672U, 24},
	{3480393984U, 24},
	{3467592960U, 24},
	{3458714880U, 24},
	{3457482240U, 24},
	{3449582848U, 24},
	{3431818496U, 24},
	{3427842048U, 24},
	{3407149824U, 24},
	{3345186816U, 24},
	{3327177216U, 24},
	{3251186688U, 24},
	{3247269888U, 24},
	{2844590080U, 16},
	{2343516160U, 24},
	{2343516416U, 24},
	{2343516928U, 24},
	{2343501824U, 18},
	{2343501824U, 16},
	{2343518208U, 18},
	{2343534592U, 18},
	{2343550976U, 18},
	{3511919872U, 24},
	{3498998016U, 24},
	{3491225600U, 24},
	{3470471680U, 24},
	{3449779456U, 24},
	{3358972416U, 24},
	{3357014016U, 24},
	{3349118720U, 24},
	{3327373824U, 24},
	{3227551488U, 24},
	{3226711040U, 24},
	{3225593088U, 24},
	{3223634688U, 24},
	{3222794240U, 24},
	{2844655616U, 16},
	{2343319296U, 24},
	{2343305216U, 16},
	{2343370240U, 24},
	{2343369984U, 24},
	{2343369728U, 24},
	{3526672384U, 24},
	{3519757312U, 24},
	{3486196224U, 24},
	{3458583808U, 24},
	{3407280896U, 24},
	{3398394624U, 24},
	{3389516544U, 24},
	{3358906880U, 24},
	{3273061120U, 24},
	{3244393984U, 24},
	{3233569280U, 24},
	{3477907968U, 24},
	{3434305024U, 24},
	{3429796608U, 24},
	{3395141120U, 24},
	{3267636992U, 24},
	{3248638464U, 24},
	{3240804864U, 24},
	{3222925312U, 24},
	{2843797504U, 21},
	{2843798784U, 24},
	{2843798528U, 24},
	{2843799296U, 24},
	{2843801600U, 21},
	{2843802112U, 24},
	{2843802624U, 24},
	{2843799808U, 24},
	{2843799552U, 24},
	{2843799552U, 21},
	{2843800832U, 24},
	{2843801088U, 24},
	{3636802816U, 24},
	{3625510912U, 24},
	{3523867392U, 24},
	{3484570880U, 24},
	{3463416064U, 24},
	{3456757504U, 24},
	{3407411968U, 24},
	{3399696640U, 24},
	{3354794240U, 24},
	{3352574720U, 24},
	{3326976768U, 24},
	{3225080320U, 24},
	{2342715392U, 16},
	{3638826752U, 24},
	{3530331392U, 24},
	{3520539904U, 24},
	{3500169984U, 24},
	{3493446144U, 24},
	{3485868544U, 24},
	{3434173952U, 24},
	{3417395456U, 24},
	{3410931200U, 24},
	{3398660608U, 24},
	{3397542656U, 24},
	{3390831104U, 24},
	{3341337600U, 24},
	{3289048320U, 24},
	{3237289472U, 24},
	{3235331072U, 24},
	{2843869184U, 16},
	{2342518784U, 16},
	{2342535168U, 22},
	{3560490496U, 24},
	{3488878848U, 24},
	{3483452416U, 24},
	{3417329920U, 24},
	{3413941504U, 24},
	{3409500416U, 24},
	{3407543040U, 24},
	{3406555648U, 24},
	{3397608192U, 24},
	{3394219776U, 24},
	{3392722944U, 24},
	{3358182144U, 24},
	{3345842176U, 24},
	{3341403136U, 24},
	{3339445760U, 24},
	{3241726720U, 24},
	{3240739328U, 24},
	{3230824448U, 24},
	{3228403456U, 24},
	{3222003968U, 24},
	{2843934720U, 16},
	{2342584320U, 16},
	{3632558336U, 24},
	{3628645632U, 24},
	{3516229888U, 24},
	{3481560576U, 24},
	{3479865344U, 24},
	{3463088384U, 24},
	{3407739648U, 24},
	{3406621184U, 24},
	{3397098496U, 24},
	{3393181696U, 24},
	{3340629760U, 24},
	{3337820160U, 24},
	{3250596864U, 24},
	{2844000256U, 17},
	{2844000256U, 16},
	{2844033024U, 17},
	{2342912000U, 16},
	{3631910400U, 24},
	{3629689856U, 24},
	{3628711296U, 24},
	{3492795136U, 24},
	{3467068672U, 24},
	{3460934400U, 24},
	{3450291712U, 24},
	{3409893632U, 24},
	{3406686720U, 24},
	{3404862464U, 24},
	{3394813440U, 24},
	{3390896640U, 24},
	{3360271616U, 24},
	{3354532096U, 24},
	{3344478976U, 24},
	{3326714624U, 24},
	{3274686464U, 24},
	{3263523584U, 24},
	{3252882944U, 24},
	{3233885440U, 24},
	{3230955520U, 24},
	{3229968640U, 24},
	{2844065792U, 16},
	{3579552000U, 24},
	{3491749888U, 24},
	{3457085184U, 24},
	{3389975296U, 24},
	{3360337152U, 24},
	{3356420352U, 24},
	{3345514496U, 24},
	{3256873472U, 24},
	{3224158976U, 24},
	{2844131328U, 16},
	{2342780928U, 16},
	{3536989696U, 24},
	{3478829824U, 24},
	{3357472768U, 24},
	{2844196864U, 16},
	{2342846464U, 16},
	{3636162816U, 24},
	{3632808448U, 24},
	{3509841920U, 24},
	{3505269760U, 24},
	{3465040896U, 24},
	{3432597248U, 24},
	{3427047936U, 24},
	{3392400128U, 24},
	{3359940096U, 24},
	{3323053312U, 24},
	{3261511168U, 24},
	{3254725632U, 24},
	{2342060032U, 16},
	{301989888U, 8},
	{3651887360U, 24},
	{3639550976U, 24},
	{3582545664U, 24},
	{3557873408U, 24},
	{3515435776U, 24},
	{3513230592U, 24},
	{3510994688U, 24},
	{3507540480U, 24},
	{3452769024U, 24},
	{3449308672U, 24},
	{3422430720U, 24},
	{3406874624U, 24},
	{3356543744U, 24},
	{3344203776U, 24},
	{3338786048U, 24},
	{3290690560U, 24},
	{3228021760U, 24},
	{3222323968U, 24},
	{2341994496U, 16},
	{3634057984U, 24},
	{3585702912U, 24},
	{3501816064U, 24},
	{3500697600U, 24},
	{3489473024U, 24},
	{3476155904U, 24},
	{3411512320U, 24},
	{3405961472U, 24},
	{3358714112U, 24},
	{3350818304U, 24},
	{3346375168U, 24},
	{3338851584U, 24},
	{3247069952U, 24},
	{3230292480U, 24},
	{3227825152U, 24},
	{3224494336U, 24},
	{3222520576U, 24},
	{3634978816U, 24},
	{3631529216U, 24},
	{3524448512U, 24},
	{3515566848U, 24},
	{3489907200U, 24},
	{3432662784U, 24},
	{3427244544U, 24},
	{3411446784U, 24},
	{3408001792U, 24},
	{3393690624U, 24},
	{3338414848U, 24},
	{3332001024U, 24},
	{3223449600U, 24},
	{3222455040U, 24},
	{3640341760U, 24},
	{3631463680U, 24},
	{3563233280U, 24},
	{3505007616U, 24},
	{3485427200U, 24},
	{3439010048U, 24},
	{3433985024U, 24},
	{3407202304U, 24},
	{3399303424U, 24},
	{3327230208U, 24},
	{3244471552U, 24},
	{2342322176U, 16},
	{2342371328U, 21},
	{3650900480U, 24},
	{3638040320U, 24},
	{3636359424U, 24},
	{3627481344U, 24},
	{3506060544U, 24},
	{3491025664U, 24},
	{3463621376U, 24},
	{3461384448U, 24},
	{3454742784U, 24},
	{3431814656U, 24},
	{3406158080U, 24},
	{3398258688U, 24},
	{3393297408U, 24},
	{3327164672U, 24},
	{3247266560U, 24},
	{3233704192U, 24},
	{3529549312U, 24},
	{3511916032U, 24},
	{3504876544U, 24},
	{3500104448U, 24},
	{3288782336U, 24},
	{3252358656U, 24},
	{3237555456U, 24},
	{3225589248U, 24},
	{3222782720U, 24},
	{3640145152U, 24},
	{3634254592U, 24},
	{3627350272U, 24},
	{3524710656U, 24},
	{3499051520U, 24},
	{3475373824U, 24},
	{3428956160U, 24},
	{3426020608U, 24},
	{3250350080U, 24},
	{3235516160U, 24},
	{3632284160U, 24},
	{3632250112U, 24},
	{3624454656U, 24},
	{3500304384U, 24},
	{3499186944U, 24},
	{3435401728U, 24},
	{3326906368U, 24},
	{3323577600U, 24},
	{3224039424U, 24},
	{2341535744U, 16},
	{3635572992U, 24},
	{3628961280U, 24},
	{3505798400U, 24},
	{3490300416U, 24},
	{3475767040U, 24},
	{3450041600U, 24},
	{3448784384U, 24},
	{3407398912U, 24},
	{3399709184U, 24},
	{3398451456U, 24},
	{3391879680U, 24},
	{3359303936U, 24},
	{3356088832U, 24},
	{3352561664U, 24},
	{3351582976U, 24},
	{3287690752U, 24},
	{3275416064U, 24},
	{3225084160U, 24},
	{2341470208U, 16},
	{3641363200U, 24},
	{3493458176U, 24},
	{3491484416U, 24},
	{3464647680U, 24},
	{3424374528U, 24},
	{3406485760U, 24},
	{3395259648U, 24},
	{3361705728U, 24},
	{3252960512U, 24},
	{3245126912U, 24},
	{3231741952U, 24},
	{2341666816U, 16},
	{3479078912U, 24},
	{3411971072U, 24},
	{3409504768U, 24},
	{3406551296U, 24},
	{3397168896U, 24},
	{3392727808U, 24},
	{3359172864U, 24},
	{3358193664U, 24},
	{3332472320U, 24},
	{3239756288U, 24},
	{3232786688U, 24},
	{3229833728U, 24},
	{2341611520U, 24},
	{3628633600U, 24},
	{3561521664U, 24},
	{3516226048U, 24},
	{3511191296U, 24},
	{3502247424U, 24},
	{3460864000U, 24},
	{3428420352U, 24},
	{3424505600U, 24},
	{3411643392U, 24},
	{3406616832U, 24},
	{3398779136U, 24},
	{3394866432U, 24},
	{3352365056U, 24},
	{3344531456U, 24},
	{3268480256U, 24},
	{3264563456U, 24},
	{3252829440U, 24},
	{3250022400U, 24},
	{3222065664U, 24},
	{2341797888U, 16},
	{3641559808U, 24},
	{3632611840U, 24},
	{3564810496U, 24},
	{3563823104U, 24},
	{3502312960U, 24},
	{3492798464U, 24},
	{3463166464U, 24},
	{3432269568U, 24},
	{3411577856U, 24},
	{3407661056U, 24},
	{3394800896U, 24},
	{3392141824U, 24},
	{3356350976U, 24},
	{3350621696U, 24},
	{3344465920U, 24},
	{3330628608U, 24},
	{3270651648U, 24},
	{3263518720U, 24},
	{3252894976U, 24},
	{3249956864U, 24},
	{3224367104U, 24},
	{3579548160U, 24},
	{3531192064U, 24},
	{3493720320U, 24},
	{3466020096U, 24},
	{3453157888U, 24},
	{3449243136U, 24},
	{3411774464U, 24},
	{3393055488U, 24},
	{3389970432U, 24},
	{3357526784U, 24},
	{3350556160U, 24},
	{3346637312U, 24},
	{3337693952U, 24},
	{3257725440U, 24},
	{3256860928U, 24},
	{3229197568U, 24},
	{3227223808U, 24},
	{2341928960U, 16},
	{3633730304U, 24},
	{3628830208U, 24},
	{3584388352U, 24},
	{3516291584U, 24},
	{3500500992U, 24},
	{3475898112U, 24},
	{3458125056U, 24},
	{3437309952U, 24},
	{3427506688U, 24},
	{3407792128U, 24},
	{3392010752U, 24},
	{3391015168U, 24},
	{3357461248U, 24},
	{3234012672U, 24},
	{3232069632U, 24},
	{3231075072U, 24},
	{3632812800U, 24},
	{3513168896U, 24},
	{3490824704U, 24},
	{3470594048U, 24},
	{3452699136U, 24},
	{3424840960U, 24},
	{3423723008U, 24},
	{3422500608U, 24},
	{3393490176U, 24},
	{3359936256U, 24},
	{3328615168U, 24},
	{3227952384U, 24},
	{50331648U, 8},
	{58518528U, 22},
	{3639555328U, 24},
	{3629420032U, 24},
	{3589224448U, 24},
	{3583528704U, 24},
	{3582549504U, 24},
	{3572447488U, 24},
	{3514213632U, 24},
	{3489780480U, 24},
	{3425893376U, 24},
	{3389114624U, 24},
	{3335325952U, 24},
	{3326443776U, 24},
	{3261572864U, 24},
	{3244794880U, 24},
	{3224563712U, 24},
	{3223576832U, 24},
	{2341011456U, 16},
	{3634053632U, 24},
	{3439144960U, 24},
	{3433587968U, 24},
	{3405957120U, 24},
	{3338484224U, 24},
	{3336509440U, 24},
	{3335391488U, 24},
	{3271737344U, 24},
	{3247065600U, 24},
	{3227821312U, 24},
	{3225847552U, 24},
	{2341076992U, 16},
	{3634983168U, 24},
	{3631524864U, 24},
	{3513103360U, 24},
	{3505208576U, 24},
	{3459317248U, 24},
	{3454869504U, 24},
	{3439079424U, 24},
	{3437105664U, 24},
	{3432666624U, 24},
	{3407997440U, 24},
	{3407010048U, 24},
	{3393686784U, 24},
	{3333979648U, 24},
	{3331017984U, 24},
	{3234795264U, 24},
	{3230354176U, 24},
	{2341142528U, 16},
	{3630349568U, 24},
	{3628113664U, 24},
	{3625306624U, 24},
	{3554217216U, 24},
	{3515636224U, 24},
	{3505011968U, 24},
	{3483194624U, 24},
	{3433981184U, 24},
	{3431745280U, 24},
	{3399307264U, 24},
	{3338978304U, 24},
	{3333320448U, 24},
	{3267890432U, 24},
	{3251113472U, 24},
	{3224891392U, 24},
	{2341208064U, 16},
	{3650896640U, 24},
	{3463625216U, 24},
	{3462638336U, 24},
	{3461388288U, 24},
	{3436712448U, 24},
	{3417268736U, 24},
	{3398254848U, 24},
	{3360726528U, 24},
	{3333385984U, 24},
	{3327168512U, 24},
	{3253414912U, 24},
	{3231472128U, 24},
	{2341273600U, 17},
	{2341273600U, 16},
	{2341306368U, 18},
	{2341322752U, 18},
	{3573098496U, 24},
	{3451745536U, 24},
	{3407337728U, 24},
	{3391417088U, 24},
	{3368683264U, 24},
	{3328221952U, 24},
	{3288778496U, 24},
	{3249301504U, 24},
	{3222786560U, 24},
	{2341339136U, 18},
	{2341339136U, 16},
	{2341355520U, 18},
	{2341359360U, 24},
	{2341359616U, 20},
	{2341380096U, 20},
	{2341384192U, 22},
	{2341390848U, 23},
	{2341400576U, 22},
	{2341402624U, 21},
	{3634250240U, 24},
	{3559257344U, 24},
	{3507929856U, 24},
	{3505925120U, 24},
	{3437830400U, 24},
	{3426024448U, 24},
	{3392469504U, 24},
	{3335194880U, 24},
	{3250354432U, 24},
	{3247393280U, 24},
	{3233576960U, 24},
	{3226637824U, 24},
	{2341404672U, 16},
	{3638965504U, 24},
	{3633398272U, 24},
	{3624459008U, 24},
	{3545011200U, 24},
	{3520401152U, 24},
	{3475697152U, 24},
	{3473460224U, 24},
	{3462240256U, 24},
	{3418620928U, 24},
	{3406350336U, 24},
	{3399639808U, 24},
	{3394014464U, 24},
	{3323581440U, 24},
	{3263149568U, 24},
	{3227358720U, 24},
	{3226240768U, 24},
	{2340421632U, 16},
	{3645742592U, 24},
	{3635568640U, 24},
	{3582025216U, 24},
	{3500374272U, 24},
	{3456748800U, 24},
	{3405133312U, 24},
	{3399705344U, 24},
	{3335788544U, 24},
	{3227293184U, 24},
	{3641367040U, 24},
	{3639944192U, 24},
	{3531449856U, 24},
	{3520532224U, 24},
	{3499313664U, 24},
	{3493453824U, 24},
	{3490370304U, 24},
	{3424378368U, 24},
	{3407599872U, 24},
	{3397533952U, 24},
	{3395263488U, 24},
	{3345785344U, 24},
	{3283188480U, 24},
	{3237297152U, 24},
	{3231738112U, 24},
	{2340552704U, 16},
	{3641432576U, 24},
	{3638899968U, 24},
	{3629096704U, 24},
	{3625634304U, 24},
	{3483461120U, 24},
	{3471123200U, 24},
	{3459841536U, 24},
	{3432142336U, 24},
	{3412962816U, 24},
	{3407534336U, 24},
	{3392731648U, 24},
	{3251047936U, 24},
	{3241734400U, 24},
	{3240747008U, 24},
	{3222983168U, 24},
	{2340620544U, 24},
	{2340618240U, 16},
	{2340643840U, 24},
	{2340651008U, 18},
	{2340667392U, 19},
	{2340681728U, 21},
	{2340679680U, 21},
	{3625830912U, 24},
	{3561526016U, 24},
	{3511195136U, 24},
	{3486585088U, 24},
	{3460300288U, 24},
	{3456945408U, 24},
	{3453031168U, 24},
	{3435135744U, 24},
	{3428424192U, 24},
	{3413884672U, 24},
	{3411647744U, 24},
	{3340621056U, 24},
	{3327758336U, 24},
	{3273511168U, 24},
	{3252825088U, 24},
	{3250589184U, 24},
	{3231013376U, 24},
	{2340683776U, 16},
	{3631918080U, 24},
	{3564806144U, 24},
	{3517413376U, 24},
	{3500636416U, 24},
	{3499379200U, 24},
	{3464149504U, 24},
	{3399967488U, 24},
	{3394804736U, 24},
	{3356347136U, 24},
	{3352303872U, 24},
	{3343482880U, 24},
	{3333848576U, 24},
	{3330624768U, 24},
	{3326705920U, 24},
	{3270655488U, 24},
	{3252890624U, 24},
	{3229266944U, 24},
	{3228280064U, 24},
	{2340749312U, 16},
	{3650568960U, 24},
	{3629878784U, 24},
	{3511326208U, 24},
	{3493716032U, 24},
	{3452043776U, 24},
	{3434443776U, 24},
	{3407862016U, 24},
	{3399770880U, 24},
	{3393059328U, 24},
	{3350560512U, 24},
	{3257721600U, 24},
	{3256864768U, 24},
	{3229201408U, 24},
	{2340814848U, 16},
	{3633725952U, 24},
	{3627870208U, 24},
	{3584392192U, 24},
	{3567615232U, 24},
	{3536980992U, 24},
	{3360395008U, 24},
	{3358451968U, 24},
	{3357465088U, 24},
	{3262690816U, 24},
	{3257787136U, 24},
	{3249830144U, 24},
	{2340880384U, 16},
	{3632800768U, 24},
	{3489702912U, 24},
	{3427073024U, 24},
	{3424819712U, 24},
	{3423709440U, 24},
	{3399034624U, 24},
	{3344295424U, 24},
	{3342041088U, 24},
	{3335290368U, 24},
	{3277185536U, 24},
	{3261517824U, 24},
	{3241379328U, 24},
	{3233484544U, 24},
	{3227963904U, 24},
	{3639558656U, 24},
	{3488568576U, 24},
	{3486349056U, 24},
	{3458439168U, 24},
	{3452794112U, 24},
	{3432521984U, 24},
	{3427138560U, 24},
	{3405889280U, 24},
	{3360028672U, 24},
	{3344229888U, 24},
	{3231198464U, 24},
	{3228029440U, 24},
	{2348693248U, 24},
	{3500674560U, 24},
	{3498716160U, 24},
	{3470747392U, 24},
	{3459352832U, 24},
	{3454818048U, 24},
	{3430272768U, 24},
	{3416790272U, 24},
	{3407912192U, 24},
	{3407064576U, 24},
	{3392244992U, 24},
	{3365610752U, 24},
	{3290468864U, 24},
	{3224471296U, 24},
	{3638456576U, 24},
	{3629578624U, 24},
	{3583653888U, 24},
	{3511148800U, 24},
	{3469702656U, 24},
	{3406999040U, 24},
	{3340865792U, 24},
	{3333949696U, 24},
	{3244675840U, 24},
	{3234822144U, 24},
	{3231329536U, 24},
	{3472573696U, 24},
	{3450737408U, 24},
	{3421131008U, 24},
	{3409415168U, 24},
	{3406085888U, 24},
	{3389308416U, 24},
	{3261255680U, 24},
	{3247193344U, 24},
	{3237694208U, 24},
	{3236583936U, 24},
	{3650892800U, 24},
	{3486086912U, 24},
	{3483116032U, 24},
	{3473259264U, 24},
	{3456481792U, 24},
	{3454752512U, 24},
	{3427855616U, 24},
	{3406151424U, 24},
	{3359018752U, 24},
	{3358039552U, 24},
	{3352849920U, 24},
	{3351119872U, 24},
	{3339039488U, 24},
	{3272910336U, 24},
	{3251206400U, 24},
	{3247258880U, 24},
	{3224798976U, 24},
	{3629381888U, 24},
	{3588771584U, 24},
	{3500096768U, 24},
	{3485270016U, 24},
	{3451716096U, 24},
	{3449757696U, 24},
	{3428052224U, 24},
	{3407326720U, 24},
	{3406216960U, 24},
	{3244348160U, 24},
	{3239552000U, 24},
	{3233615616U, 24},
	{3223623168U, 24},
	{3222775040U, 24},
	{3695438848U, 24},
	{3637207040U, 24},
	{3588837120U, 24},
	{3582929152U, 24},
	{3564164864U, 24},
	{3526661376U, 24},
	{3520755712U, 24},
	{3486217984U, 24},
	{3448713472U, 24},
	{3434873600U, 24},
	{3390484224U, 24},
	{3252316160U, 24},
	{3234560000U, 24},
	{3515956224U, 24},
	{3475675392U, 24},
	{3474565632U, 24},
	{3449950976U, 24},
	{3448840192U, 24},
	{3368316928U, 24},
	{3259822592U, 24},
	{3258680576U, 24},
	{3238573312U, 24},
	{3226267648U, 24},
	{3624512512U, 24},
	{3515890688U, 24},
	{3436471552U, 24},
	{3398444800U, 24},
	{3354807296U, 24},
	{3234166784U, 24},
	{3229694976U, 24},
	{3630168320U, 24},
	{3570892032U, 24},
	{3509094144U, 24},
	{3485890304U, 24},
	{3424364800U, 24},
	{3409546240U, 24},
	{3400598784U, 24},
	{3356146688U, 24},
	{3331533568U, 24},
	{3243176192U, 24},
	{3228357120U, 24},
	{3413952512U, 24},
	{3407523328U, 24},
	{3397175552U, 24},
	{3359149824U, 24},
	{3336920064U, 24},
	{3268832000U, 24},
	{3260019200U, 24},
	{3237235456U, 24},
	{3221992448U, 24},
	{3584428800U, 24},
	{3502270464U, 24},
	{3424495872U, 24},
	{3358498304U, 24},
	{3357388032U, 24},
	{3356277760U, 24},
	{3344557568U, 24},
	{3289165824U, 24},
	{3631930112U, 24},
	{3629709568U, 24},
	{3567716864U, 24},
	{3522320896U, 24},
	{3450278656U, 24},
	{3407654400U, 24},
	{3358563840U, 24},
	{3263512064U, 24},
	{3250682112U, 24},
	{3229957120U, 24},
	{3228291584U, 24},
	{3535084800U, 24},
	{3504359936U, 24},
	{3478908416U, 24},
	{3469960960U, 24},
	{3432456448U, 24},
	{3431346176U, 24},
	{3389963776U, 24},
	{3349420288U, 24},
	{3343578880U, 24},
	{3235080448U, 24},
	{3231132928U, 24},
	{3229205248U, 24},
	{3628853248U, 24},
	{3507463424U, 24},
	{3464966656U, 24},
	{3455075840U, 24},
	{3433370112U, 24},
	{3427531776U, 24},
	{3414636288U, 24},
	{3325853952U, 24},
	{2849128448U, 18},
	{2849112064U, 18},
	{2849112064U, 16},
	{2849161216U, 18},
	{2849144832U, 18},
	{3638386688U, 24},
	{3635025664U, 24},
	{3632805120U, 24},
	{3476265216U, 24},
	{3465028352U, 24},
	{3416916992U, 24},
	{3408038912U, 24},
	{3389042432U, 24},
	{3357708032U, 24},
	{3261513984U, 24},
	{3244737024U, 24},
	{3230149888U, 24},
	{2848718848U, 16},
	{3639563008U, 24},
	{3582539776U, 24},
	{3559101184U, 24},
	{3518631680U, 24},
	{3490751488U, 24},
	{3432525824U, 24},
	{3415750400U, 24},
	{3406872320U, 24},
	{3360024832U, 24},
	{3355553024U, 24},
	{3355335936U, 24},
	{3288441088U, 24},
	{3228025600U, 24},
	{2848784384U, 16},
	{3632936192U, 24},
	{3504302080U, 24},
	{3473058304U, 24},
	{3421257728U, 24},
	{3405950464U, 24},
	{3404480768U, 24},
	{3365614592U, 24},
	{3350796544U, 24},
	{3290465024U, 24},
	{3227828992U, 24},
	{3225870592U, 24},
	{3224475136U, 24},
	{2848849920U, 16},
	{3583650048U, 24},
	{3506194944U, 24},
	{3492840960U, 24},
	{3469698816U, 24},
	{3467182336U, 24},
	{3407973376U, 24},
	{3357642496U, 24},
	{3340861440U, 24},
	{3288572160U, 24},
	{3226923008U, 24},
	{3223422720U, 24},
	{2848915456U, 16},
	{2848976384U, 24},
	{2848978432U, 24},
	{3630357248U, 24},
	{3530801152U, 24},
	{3485405440U, 24},
	{3448512512U, 24},
	{3430145536U, 24},
	{3418907136U, 24},
	{3409419520U, 24},
	{3398182656U, 24},
	{3327260160U, 24},
	{3288637696U, 24},
	{3237698048U, 24},
	{2848465920U, 24},
	{2848469760U, 24},
	{2848471808U, 24},
	{2848456704U, 16},
	{2848459264U, 24},
	{2848459776U, 24},
	{2848463104U, 24},
	{2848514304U, 24},
	{2848518144U, 23},
	{2848508928U, 24},
	{2848511744U, 24},
	{2848498432U, 24},
	{2848498944U, 24},
	{2848498688U, 24},
	{2848499200U, 23},
	{2848499968U, 24},
	{2848499712U, 24},
	{2848500992U, 24},
	{2848501248U, 23},
	{2848502016U, 24},
	{2848503296U, 23},
	{2848504064U, 24},
	{2848503808U, 24},
	{2848504320U, 24},
	{2848505344U, 24},
	{2848490752U, 24},
	{3650888960U, 24},
	{3635353344U, 24},
	{3506811904U, 24},
	{3486082560U, 24},
	{3449565440U, 24},
	{3438958080U, 24},
	{3389370112U, 24},
	{3358035712U, 24},
	{3333359872U, 24},
	{3271927296U, 24},
	{3255150336U, 24},
	{3251202048U, 24},
	{3642207488U, 24},
	{3485274368U, 24},
	{3472446464U, 24},
	{3451720448U, 24},
	{3431866624U, 24},
	{3407331072U, 24},
	{3391393024U, 24},
	{3356998656U, 24},
	{3351932416U, 24},
	{3349940224U, 24},
	{3226726400U, 24},
	{3223619328U, 24},
	{3222778880U, 24},
	{3221660928U, 24},
	{2848598528U, 24},
	{2848598272U, 24},
	{2848587776U, 16},
	{2848589312U, 24},
	{2848589056U, 24},
	{2848639488U, 24},
	{2848639232U, 24},
	{2347237376U, 16},
	{3588840960U, 24},
	{3586882560U, 24},
	{3585870592U, 24},
	{3528647168U, 24},
	{3460558592U, 24},
	{3358891520U, 24},
	{3357904640U, 24},
	{3353955328U, 24},
	{3341123584U, 24},
	{3252320512U, 24},
	{3228619264U, 24},
	{2848653312U, 16},
	{3650168064U, 24},
	{3625561088U, 24},
	{3479043840U, 24},
	{3457792512U, 24},
	{3448844544U, 24},
	{3406343680U, 24},
	{3332507904U, 24},
	{3325792256U, 24},
	{3285547776U, 24},
	{3264298496U, 24},
	{2848251904U, 24},
	{2848256000U, 24},
	{2347106304U, 16},
	{3515886848U, 24},
	{3502602496U, 24},
	{3471262976U, 24},
	{3410881024U, 24},
	{3398448640U, 24},
	{3255412480U, 24},
	{3253160448U, 24},
	{3245326848U, 24},
	{3240855040U, 24},
	{3229691136U, 24},
	{3225064960U, 24},
	{2848260096U, 24},
	{2347176192U, 24},
	{3667076608U, 24},
	{3636883712U, 24},
	{3630163968U, 24},
	{3531456512U, 24},
	{3520555264U, 24},
	{3437512448U, 24},
	{3391655168U, 24},
	{3350272256U, 24},
	{3245130240U, 24},
	{3237304832U, 24},
	{3235346432U, 24},
	{3231715072U, 24},
	{3230874624U, 24},
	{3228353280U, 24},
	{2848325632U, 16},
	{3633456128U, 24},
	{3537267200U, 24},
	{3503712256U, 24},
	{3413956864U, 24},
	{3411999488U, 24},
	{3406540288U, 24},
	{3353693184U, 24},
	{3340415744U, 24},
	{3336916224U, 24},
	{3329082624U, 24},
	{3323638272U, 24},
	{3281141504U, 24},
	{3264364032U, 24},
	{3262959616U, 24},
	{3255543552U, 24},
	{3228418816U, 24},
	{2848391168U, 16},
	{2347040768U, 16},
	{3516214528U, 24},
	{3483762688U, 24},
	{3479882752U, 24},
	{3428449280U, 24},
	{3407724288U, 24},
	{3389828864U, 24},
	{3358494464U, 24},
	{3353496576U, 24},
	{3344561920U, 24},
	{3289161984U, 24},
	{3274605568U, 24},
	{3631925760U, 24},
	{3529040384U, 24},
	{3460951808U, 24},
	{3409878272U, 24},
	{3407658752U, 24},
	{3406671360U, 24},
	{3356339456U, 24},
	{3333822464U, 24},
	{3250677760U, 24},
	{3633783808U, 24},
	{3504364288U, 24},
	{3478912768U, 24},
	{3468846848U, 24},
	{3451196160U, 24},
	{3407855360U, 24},
	{3249872640U, 24},
	{3235084288U, 24},
	{3223303168U, 24},
	{3645634560U, 24},
	{3520227584U, 24},
	{3437315840U, 24},
	{3414631936U, 24},
	{3391012352U, 24},
	{3234031872U, 24},
	{2346778624U, 16},
	{3627269376U, 24},
	{3584698624U, 24},
	{3556803072U, 24},
	{3513180416U, 24},
	{3423701760U, 24},
	{3408051968U, 24},
	{3361065728U, 24},
	{3358829824U, 24},
	{3357719552U, 24},
	{3355483648U, 24},
	{3349822208U, 24},
	{3335281664U, 24},
	{3326399488U, 24},
	{3257054720U, 24},
	{3252505088U, 24},
	{3564565760U, 24},
	{3470542080U, 24},
	{3431535104U, 24},
	{3427130880U, 24},
	{3415737344U, 24},
	{3360020992U, 24},
	{3358764288U, 24},
	{3356528384U, 24},
	{3338768640U, 24},
	{3328701952U, 24},
	{3223565312U, 24},
	{3581277184U, 24},
	{3500682240U, 24},
	{3499826944U, 24},
	{3454825728U, 24},
	{3407055872U, 24},
	{3338497792U, 24},
	{3231387392U, 24},
	{3228950784U, 24},
	{3224478976U, 24},
	{2851930112U, 16},
	{2346663936U, 18},
	{2346680064U, 24},
	{2346651648U, 20},
	{2346648576U, 22},
	{2346647552U, 22},
	{2346647552U, 17},
	{2346647552U, 16},
	{2346648064U, 24},
	{2346649600U, 21},
	{2346655744U, 19},
	{2346703872U, 22},
	{2346697728U, 24},
	{2346697984U, 24},
	{2346698240U, 24},
	{2346698496U, 24},
	{2346696704U, 24},
	{2346696704U, 19},
	{2346696960U, 24},
	{2346697472U, 24},
	{2346698752U, 24},
	{2346704896U, 19},
	{2346706944U, 24},
	{2346680320U, 19},
	{2346680320U, 18},
	{2346681088U, 24},
	{2346695680U, 24},
	{2346695936U, 24},
	{2346696192U, 24},
	{2346696448U, 24},
	{2346695424U, 24},
	{2346689536U, 22},
	{2346688512U, 22},
	{2346688512U, 20},
	{2346691584U, 22},
	{2346690560U, 22},
	{3575750912U, 24},
	{3489891840U, 24},
	{3470673152U, 24},
	{3428241152U, 24},
	{3407986432U, 24},
	{3406990336U, 24},
	{3392188160U, 24},
	{3389234176U, 24},
	{3357654016U, 24},
	{3288568320U, 24},
	{3278238464U, 24},
	{3261460992U, 24},
	{3234814464U, 24},
	{3230342656U, 24},
	{3223434240U, 24},
	{2851864576U, 16},
	{2851929856U, 24},
	{2346582016U, 16},
	{3635291136U, 24},
	{3471472128U, 24},
	{3462594048U, 24},
	{3448509184U, 24},
	{3411134464U, 24},
	{3407186944U, 24},
	{3355745792U, 24},
	{3258427136U, 24},
	{3678521600U, 24},
	{3650885120U, 24},
	{3638055680U, 24},
	{3627465984U, 24},
	{3586013184U, 24},
	{3557130752U, 24},
	{3491010304U, 24},
	{3454760192U, 24},
	{3449553408U, 24},
	{3437982720U, 24},
	{3389365248U, 24},
	{3360738048U, 24},
	{3328439808U, 24},
	{3325469440U, 24},
	{3233688832U, 24},
	{3624308224U, 24},
	{3588779264U, 24},
	{3519695616U, 24},
	{3485278720U, 24},
	{3479240448U, 24},
	{3465416704U, 24},
	{3356987136U, 24},
	{3351928064U, 24},
	{3284818176U, 24},
	{3239544320U, 24},
	{3233623296U, 24},
	{3223630848U, 24},
	{3222767360U, 24},
	{3588844800U, 24},
	{3586871040U, 24},
	{3523707904U, 24},
	{3443777280U, 24},
	{3406273792U, 24},
	{3350997504U, 24},
	{3281914880U, 24},
	{3239478784U, 24},
	{3233557760U, 24},
	{3632265472U, 24},
	{3564037120U, 24},
	{3481267712U, 24},
	{3475684096U, 24},
	{3449958656U, 24},
	{3448832512U, 24},
	{3432055552U, 24},
	{3407449088U, 24},
	{3397391360U, 24},
	{3392909056U, 24},
	{3285534720U, 24},
	{3259813888U, 24},
	{3253106944U, 24},
	{3246399232U, 24},
	{3515883008U, 24},
	{3426396416U, 24},
	{3419684864U, 24},
	{3406404864U, 24},
	{3391864320U, 24},
	{3359288576U, 24},
	{3352579072U, 24},
	{3238631168U, 24},
	{3234159104U, 24},
	{3226325504U, 24},
	{3636871680U, 24},
	{3630160640U, 24},
	{3520551424U, 24},
	{3509101824U, 24},
	{3463249408U, 24},
	{3428830976U, 24},
	{3358112768U, 24},
	{3357249280U, 24},
	{3237308672U, 24},
	{2851405824U, 16},
	{3515027200U, 24},
	{3512652288U, 24},
	{3500223488U, 24},
	{3478117632U, 24},
	{3413961216U, 24},
	{3411986432U, 24},
	{3407514624U, 24},
	{3398567168U, 24},
	{3289092608U, 24},
	{3222963968U, 24},
	{2851340288U, 16},
	{3639832832U, 24},
	{3628648960U, 24},
	{3576602880U, 24},
	{3455280128U, 24},
	{3434553600U, 24},
	{3424488192U, 24},
	{3393171200U, 24},
	{3392060928U, 24},
	{3389824000U, 24},
	{3361327872U, 24},
	{3357380352U, 24},
	{3344548864U, 24},
	{3252844800U, 24},
	{3230994176U, 24},
	{3632596480U, 24},
	{3631937792U, 24},
	{3503315712U, 24},
	{3500616704U, 24},
	{3492783104U, 24},
	{3479961344U, 24},
	{3463183872U, 24},
	{3434488064U, 24},
	{3429628928U, 24},
	{3419422720U, 24},
	{3399955968U, 24},
	{3358571520U, 24},
	{3337776896U, 24},
	{3326727168U, 24},
	{3323756800U, 24},
	{3227042560U, 24},
	{3503512320U, 24},
	{3449225728U, 24},
	{3432448768U, 24},
	{3393040128U, 24},
	{3391929856U, 24},
	{3359485184U, 24},
	{3346654720U, 24},
	{3345544960U, 24},
	{3257710080U, 24},
	{3235072768U, 24},
	{2851143680U, 16},
	{3521210624U, 24},
	{3414627584U, 24},
	{3407776768U, 24},
	{3357445888U, 24},
	{3346589184U, 24},
	{3341660928U, 24},
	{3331721472U, 24},
	{3325862656U, 24},
	{3269556736U, 24},
	{3263634432U, 24},
	{2851078144U, 16},
	{3632797440U, 24},
	{3559043328U, 24},
	{3515358720U, 24},
	{3466137600U, 24},
	{3438175488U, 24},
	{3434819584U, 24},
	{3433701632U, 24},
	{3414688768U, 24},
	{3408047616U, 24},
	{3405810688U, 24},
	{3400148736U, 24},
	{3355479808U, 24},
	{3325276672U, 24},
	{3323039744U, 24},
	{3276062720U, 24},
	{3261522688U, 24},
	{3259285760U, 24},
	{3231260160U, 24},
	{3230142208U, 24},
	{3227967744U, 24},
	{3585747200U, 24},
	{3515424256U, 24},
	{3492001024U, 24},
	{3466072064U, 24},
	{3427127040U, 24},
	{3425875968U, 24},
	{3403436032U, 24},
	{3392323072U, 24},
	{3355545344U, 24},
	{3288433408U, 24},
	{3285997824U, 24},
	{3629632000U, 24},
	{3501796352U, 24},
	{3499822592U, 24},
	{3492914176U, 24},
	{3489494784U, 24},
	{3486401536U, 24},
	{3478641920U, 24},
	{3469624576U, 24},
	{3454821376U, 24},
	{3407060224U, 24},
	{3355279104U, 24},
	{3332909824U, 24},
	{2850816000U, 16},
	{3467191040U, 24},
	{3425744896U, 24},
	{3406994688U, 24},
	{3400083200U, 24},
	{3340870144U, 24},
	{3331987456U, 24},
	{3270339328U, 24},
	{3235797504U, 24},
	{3230338816U, 24},
	{3224417280U, 24},
	{2850881536U, 16},
	{3563255040U, 24},
	{3558179328U, 24},
	{3503901184U, 24},
	{3485414144U, 24},
	{3483177216U, 24},
	{3430153216U, 24},
	{3418898432U, 24},
	{3409428224U, 24},
	{3400410880U, 24},
	{3244482560U, 24},
	{3237705728U, 24},
	{3650881280U, 24},
	{3627461632U, 24},
	{3586009344U, 24},
	{3557135104U, 24},
	{3513966848U, 24},
	{3486073856U, 24},
	{3449557760U, 24},
	{3427851776U, 24},
	{3407125760U, 24},
	{3389361408U, 24},
	{3359030272U, 24},
	{3342976000U, 24},
	{3334355456U, 24},
	{3270208256U, 24},
	{3241587968U, 24},
	{3233692672U, 24},
	{3232705792U, 24},
	{3226522112U, 24},
	{3588783104U, 24},
	{3509953792U, 24},
	{3504032256U, 24},
	{3485283072U, 24},
	{3471337216U, 24},
	{3406203904U, 24},
	{3356990976U, 24},
	{3351923712U, 24},
	{3284813824U, 24},
	{3262247424U, 24},
	{3222771200U, 24},
	{2850553856U, 16},
	{3639177472U, 24},
	{3636208640U, 24},
	{3588848640U, 24},
	{3517791232U, 24},
	{3500019200U, 24},
	{3489167104U, 24},
	{3488179712U, 24},
	{3466465280U, 24},
	{3443772928U, 24},
	{3390479360U, 24},
	{3389492480U, 24},
	{3341132288U, 24},
	{3281919232U, 24},
	{3266129664U, 24},
	{3250339072U, 24},
	{3233561600U, 24},
	{2850619392U, 16},
	{3564041472U, 24},
	{3512582912U, 24},
	{3505874944U, 24},
	{3477916672U, 24},
	{3448836864U, 24},
	{3414164480U, 24},
	{3407453440U, 24},
	{3405214208U, 24},
	{3397387520U, 24},
	{3361593856U, 24},
	{3259810048U, 24},
	{3254221056U, 24},
	{3253102592U, 24},
	{2850422784U, 16},
	{3561871104U, 24},
	{3500358912U, 24},
	{3499101696U, 24},
	{3471271680U, 24},
	{3469034752U, 24},
	{3418701824U, 24},
	{3405148672U, 24},
	{3398439936U, 24},
	{3391860480U, 24},
	{3359292416U, 24},
	{3254155520U, 24},
	{3253168128U, 24},
	{3238626816U, 24},
	{3228557568U, 24},
	{3718262784U, 24},
	{3636876032U, 24},
	{3630156288U, 24},
	{3520547584U, 24},
	{3485877248U, 24},
	{3475548672U, 24},
	{3449823232U, 24},
	{3418767360U, 24},
	{3414295552U, 24},
	{3356135168U, 24},
	{3354754816U, 24},
	{3350280960U, 24},
	{3230866944U, 24},
	{3228360960U, 24},
	{2850308096U, 19},
	{2850324224U, 24},
	{2850320384U, 20},
	{2850324480U, 19},
	{2850332672U, 20},
	{3650225920U, 24},
	{3531399680U, 24},
	{3515031040U, 24},
	{3512648448U, 24},
	{3504699648U, 24},
	{3413965568U, 24},
	{3409493760U, 24},
	{3406531584U, 24},
	{3323629568U, 24},
	{3291062528U, 24},
	{3289088768U, 24},
	{3249552640U, 24},
	{3230801408U, 24},
	{3227439616U, 24},
	{3222967808U, 24},
	{2850357248U, 16},
	{3628653312U, 24},
	{3576606720U, 24},
	{3562653184U, 24},
	{3516206848U, 24},
	{3456928000U, 24},
	{3450216448U, 24},
	{3428441600U, 24},
	{3424492032U, 24},
	{