// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System.Globalization;
using System.ComponentModel;

namespace System.Configuration
{
    public sealed class WhiteSpaceTrimStringConverter : ConfigurationConverterBase
    {
        public override object ConvertTo(ITypeDescriptorContext ctx, CultureInfo ci, object value, Type type)
        {
            ValidateType(value, typeof(string));

            return value == null ? string.Empty : ((string)value).Trim();
        }

        public override object ConvertFrom(ITypeDescriptorContext ctx, CultureInfo ci, object data)
        {
            return ((string)data).Trim();
        }
    }
}
