/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api.proto

package v1

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type Protocol int32

const (
	Protocol_TCP  Protocol = 0
	Protocol_UDP  Protocol = 1
	Protocol_SCTP Protocol = 2
)

var Protocol_name = map[int32]string{
	0: "TCP",
	1: "UDP",
	2: "SCTP",
}

var Protocol_value = map[string]int32{
	"TCP":  0,
	"UDP":  1,
	"SCTP": 2,
}

func (x Protocol) String() string {
	return proto.EnumName(Protocol_name, int32(x))
}

func (Protocol) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{0}
}

type MountPropagation int32

const (
	// No mount propagation ("rprivate" in Linux terminology).
	MountPropagation_PROPAGATION_PRIVATE MountPropagation = 0
	// Mounts get propagated from the host to the container ("rslave" in Linux).
	MountPropagation_PROPAGATION_HOST_TO_CONTAINER MountPropagation = 1
	// Mounts get propagated from the host to the container and from the
	// container to the host ("rshared" in Linux).
	MountPropagation_PROPAGATION_BIDIRECTIONAL MountPropagation = 2
)

var MountPropagation_name = map[int32]string{
	0: "PROPAGATION_PRIVATE",
	1: "PROPAGATION_HOST_TO_CONTAINER",
	2: "PROPAGATION_BIDIRECTIONAL",
}

var MountPropagation_value = map[string]int32{
	"PROPAGATION_PRIVATE":           0,
	"PROPAGATION_HOST_TO_CONTAINER": 1,
	"PROPAGATION_BIDIRECTIONAL":     2,
}

func (x MountPropagation) String() string {
	return proto.EnumName(MountPropagation_name, int32(x))
}

func (MountPropagation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{1}
}

// A NamespaceMode describes the intended namespace configuration for each
// of the namespaces (Network, PID, IPC) in NamespaceOption. Runtimes should
// map these modes as appropriate for the technology underlying the runtime.
type NamespaceMode int32

const (
	// A POD namespace is common to all containers in a pod.
	// For example, a container with a PID namespace of POD expects to view
	// all of the processes in all of the containers in the pod.
	NamespaceMode_POD NamespaceMode = 0
	// A CONTAINER namespace is restricted to a single container.
	// For example, a container with a PID namespace of CONTAINER expects to
	// view only the processes in that container.
	NamespaceMode_CONTAINER NamespaceMode = 1
	// A NODE namespace is the namespace of the Kubernetes node.
	// For example, a container with a PID namespace of NODE expects to view
	// all of the processes on the host running the kubelet.
	NamespaceMode_NODE NamespaceMode = 2
	// TARGET targets the namespace of another container. When this is specified,
	// a target_id must be specified in NamespaceOption and refer to a container
	// previously created with NamespaceMode CONTAINER. This containers namespace
	// will be made to match that of container target_id.
	// For example, a container with a PID namespace of TARGET expects to view
	// all of the processes that container target_id can view.
	NamespaceMode_TARGET NamespaceMode = 3
)

var NamespaceMode_name = map[int32]string{
	0: "POD",
	1: "CONTAINER",
	2: "NODE",
	3: "TARGET",
}

var NamespaceMode_value = map[string]int32{
	"POD":       0,
	"CONTAINER": 1,
	"NODE":      2,
	"TARGET":    3,
}

func (x NamespaceMode) String() string {
	return proto.EnumName(NamespaceMode_name, int32(x))
}

func (NamespaceMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{2}
}

// SupplementalGroupsPolicy defines how supplemental groups
// of the first container processes are calculated.
type SupplementalGroupsPolicy int32

const (
	// Merge means that the container's provided SupplementalGroups
	// and FsGroup (specified in SecurityContext) will be merged with
	// the primary user's groups as defined in the container image
	// (in /etc/group).
	SupplementalGroupsPolicy_Merge SupplementalGroupsPolicy = 0
	// Strict means that the container's provided SupplementalGroups
	// and FsGroup (specified in SecurityContext) will be used instead of
	// any groups defined in the container image.
	SupplementalGroupsPolicy_Strict SupplementalGroupsPolicy = 1
)

var SupplementalGroupsPolicy_name = map[int32]string{
	0: "Merge",
	1: "Strict",
}

var SupplementalGroupsPolicy_value = map[string]int32{
	"Merge":  0,
	"Strict": 1,
}

func (x SupplementalGroupsPolicy) String() string {
	return proto.EnumName(SupplementalGroupsPolicy_name, int32(x))
}

func (SupplementalGroupsPolicy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{3}
}

type PodSandboxState int32

const (
	PodSandboxState_SANDBOX_READY    PodSandboxState = 0
	PodSandboxState_SANDBOX_NOTREADY PodSandboxState = 1
)

var PodSandboxState_name = map[int32]string{
	0: "SANDBOX_READY",
	1: "SANDBOX_NOTREADY",
}

var PodSandboxState_value = map[string]int32{
	"SANDBOX_READY":    0,
	"SANDBOX_NOTREADY": 1,
}

func (x PodSandboxState) String() string {
	return proto.EnumName(PodSandboxState_name, int32(x))
}

func (PodSandboxState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{4}
}

type ContainerState int32

const (
	ContainerState_CONTAINER_CREATED ContainerState = 0
	ContainerState_CONTAINER_RUNNING ContainerState = 1
	ContainerState_CONTAINER_EXITED  ContainerState = 2
	ContainerState_CONTAINER_UNKNOWN ContainerState = 3
)

var ContainerState_name = map[int32]string{
	0: "CONTAINER_CREATED",
	1: "CONTAINER_RUNNING",
	2: "CONTAINER_EXITED",
	3: "CONTAINER_UNKNOWN",
}

var ContainerState_value = map[string]int32{
	"CONTAINER_CREATED": 0,
	"CONTAINER_RUNNING": 1,
	"CONTAINER_EXITED":  2,
	"CONTAINER_UNKNOWN": 3,
}

func (x ContainerState) String() string {
	return proto.EnumName(ContainerState_name, int32(x))
}

func (ContainerState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{5}
}

type ContainerEventType int32

const (
	// Container created
	ContainerEventType_CONTAINER_CREATED_EVENT ContainerEventType = 0
	// Container started
	ContainerEventType_CONTAINER_STARTED_EVENT ContainerEventType = 1
	// Container stopped
	ContainerEventType_CONTAINER_STOPPED_EVENT ContainerEventType = 2
	// Container deleted
	ContainerEventType_CONTAINER_DELETED_EVENT ContainerEventType = 3
)

var ContainerEventType_name = map[int32]string{
	0: "CONTAINER_CREATED_EVENT",
	1: "CONTAINER_STARTED_EVENT",
	2: "CONTAINER_STOPPED_EVENT",
	3: "CONTAINER_DELETED_EVENT",
}

var ContainerEventType_value = map[string]int32{
	"CONTAINER_CREATED_EVENT": 0,
	"CONTAINER_STARTED_EVENT": 1,
	"CONTAINER_STOPPED_EVENT": 2,
	"CONTAINER_DELETED_EVENT": 3,
}

func (x ContainerEventType) String() string {
	return proto.EnumName(ContainerEventType_name, int32(x))
}

func (ContainerEventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{6}
}

type MetricType int32

const (
	MetricType_COUNTER MetricType = 0
	MetricType_GAUGE   MetricType = 1
)

var MetricType_name = map[int32]string{
	0: "COUNTER",
	1: "GAUGE",
}

var MetricType_value = map[string]int32{
	"COUNTER": 0,
	"GAUGE":   1,
}

func (x MetricType) String() string {
	return proto.EnumName(MetricType_name, int32(x))
}

func (MetricType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{7}
}

type CgroupDriver int32

const (
	CgroupDriver_SYSTEMD  CgroupDriver = 0
	CgroupDriver_CGROUPFS CgroupDriver = 1
)

var CgroupDriver_name = map[int32]string{
	0: "SYSTEMD",
	1: "CGROUPFS",
}

var CgroupDriver_value = map[string]int32{
	"SYSTEMD":  0,
	"CGROUPFS": 1,
}

func (x CgroupDriver) String() string {
	return proto.EnumName(CgroupDriver_name, int32(x))
}

func (CgroupDriver) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{8}
}

// Available profile types.
type SecurityProfile_ProfileType int32

const (
	// The container runtime default profile should be used.
	SecurityProfile_RuntimeDefault SecurityProfile_ProfileType = 0
	// Disable the feature for the sandbox or the container.
	SecurityProfile_Unconfined SecurityProfile_ProfileType = 1
	// A pre-defined profile on the node should be used.
	SecurityProfile_Localhost SecurityProfile_ProfileType = 2
)

var SecurityProfile_ProfileType_name = map[int32]string{
	0: "RuntimeDefault",
	1: "Unconfined",
	2: "Localhost",
}

var SecurityProfile_ProfileType_value = map[string]int32{
	"RuntimeDefault": 0,
	"Unconfined":     1,
	"Localhost":      2,
}

func (x SecurityProfile_ProfileType) String() string {
	return proto.EnumName(SecurityProfile_ProfileType_name, int32(x))
}

func (SecurityProfile_ProfileType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{10, 0}
}

type VersionRequest struct {
	// Version of the kubelet runtime API.
	Version              string   `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VersionRequest) Reset()      { *m = VersionRequest{} }
func (*VersionRequest) ProtoMessage() {}
func (*VersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{0}
}
func (m *VersionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VersionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VersionRequest.Merge(m, src)
}
func (m *VersionRequest) XXX_Size() int {
	return m.Size()
}
func (m *VersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_VersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_VersionRequest proto.InternalMessageInfo

func (m *VersionRequest) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

type VersionResponse struct {
	// Version of the kubelet runtime API.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Name of the container runtime.
	RuntimeName string `protobuf:"bytes,2,opt,name=runtime_name,json=runtimeName,proto3" json:"runtime_name,omitempty"`
	// Version of the container runtime. The string must be
	// semver-compatible.
	RuntimeVersion string `protobuf:"bytes,3,opt,name=runtime_version,json=runtimeVersion,proto3" json:"runtime_version,omitempty"`
	// API version of the container runtime. The string must be
	// semver-compatible.
	RuntimeApiVersion    string   `protobuf:"bytes,4,opt,name=runtime_api_version,json=runtimeApiVersion,proto3" json:"runtime_api_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VersionResponse) Reset()      { *m = VersionResponse{} }
func (*VersionResponse) ProtoMessage() {}
func (*VersionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{1}
}
func (m *VersionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VersionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VersionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VersionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VersionResponse.Merge(m, src)
}
func (m *VersionResponse) XXX_Size() int {
	return m.Size()
}
func (m *VersionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_VersionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_VersionResponse proto.InternalMessageInfo

func (m *VersionResponse) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *VersionResponse) GetRuntimeName() string {
	if m != nil {
		return m.RuntimeName
	}
	return ""
}

func (m *VersionResponse) GetRuntimeVersion() string {
	if m != nil {
		return m.RuntimeVersion
	}
	return ""
}

func (m *VersionResponse) GetRuntimeApiVersion() string {
	if m != nil {
		return m.RuntimeApiVersion
	}
	return ""
}

// DNSConfig specifies the DNS servers and search domains of a sandbox.
type DNSConfig struct {
	// List of DNS servers of the cluster.
	Servers []string `protobuf:"bytes,1,rep,name=servers,proto3" json:"servers,omitempty"`
	// List of DNS search domains of the cluster.
	Searches []string `protobuf:"bytes,2,rep,name=searches,proto3" json:"searches,omitempty"`
	// List of DNS options. See https://linux.die.net/man/5/resolv.conf
	// for all available options.
	Options              []string `protobuf:"bytes,3,rep,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DNSConfig) Reset()      { *m = DNSConfig{} }
func (*DNSConfig) ProtoMessage() {}
func (*DNSConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{2}
}
func (m *DNSConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DNSConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DNSConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DNSConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DNSConfig.Merge(m, src)
}
func (m *DNSConfig) XXX_Size() int {
	return m.Size()
}
func (m *DNSConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_DNSConfig.DiscardUnknown(m)
}

var xxx_messageInfo_DNSConfig proto.InternalMessageInfo

func (m *DNSConfig) GetServers() []string {
	if m != nil {
		return m.Servers
	}
	return nil
}

func (m *DNSConfig) GetSearches() []string {
	if m != nil {
		return m.Searches
	}
	return nil
}

func (m *DNSConfig) GetOptions() []string {
	if m != nil {
		return m.Options
	}
	return nil
}

// PortMapping specifies the port mapping configurations of a sandbox.
type PortMapping struct {
	// Protocol of the port mapping.
	Protocol Protocol `protobuf:"varint,1,opt,name=protocol,proto3,enum=runtime.v1.Protocol" json:"protocol,omitempty"`
	// Port number within the container. Default: 0 (not specified).
	ContainerPort int32 `protobuf:"varint,2,opt,name=container_port,json=containerPort,proto3" json:"container_port,omitempty"`
	// Port number on the host. Default: 0 (not specified).
	HostPort int32 `protobuf:"varint,3,opt,name=host_port,json=hostPort,proto3" json:"host_port,omitempty"`
	// Host IP.
	HostIp               string   `protobuf:"bytes,4,opt,name=host_ip,json=hostIp,proto3" json:"host_ip,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PortMapping) Reset()      { *m = PortMapping{} }
func (*PortMapping) ProtoMessage() {}
func (*PortMapping) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{3}
}
func (m *PortMapping) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PortMapping) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PortMapping.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PortMapping) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PortMapping.Merge(m, src)
}
func (m *PortMapping) XXX_Size() int {
	return m.Size()
}
func (m *PortMapping) XXX_DiscardUnknown() {
	xxx_messageInfo_PortMapping.DiscardUnknown(m)
}

var xxx_messageInfo_PortMapping proto.InternalMessageInfo

func (m *PortMapping) GetProtocol() Protocol {
	if m != nil {
		return m.Protocol
	}
	return Protocol_TCP
}

func (m *PortMapping) GetContainerPort() int32 {
	if m != nil {
		return m.ContainerPort
	}
	return 0
}

func (m *PortMapping) GetHostPort() int32 {
	if m != nil {
		return m.HostPort
	}
	return 0
}

func (m *PortMapping) GetHostIp() string {
	if m != nil {
		return m.HostIp
	}
	return ""
}

// Mount specifies a host volume to mount into a container.
type Mount struct {
	// Path of the mount within the container.
	ContainerPath string `protobuf:"bytes,1,opt,name=container_path,json=containerPath,proto3" json:"container_path,omitempty"`
	// Path of the mount on the host. If the hostPath doesn't exist, then runtimes
	// should report error. If the hostpath is a symbolic link, runtimes should
	// follow the symlink and mount the real destination to container.
	HostPath string `protobuf:"bytes,2,opt,name=host_path,json=hostPath,proto3" json:"host_path,omitempty"`
	// If set, the mount is read-only.
	Readonly bool `protobuf:"varint,3,opt,name=readonly,proto3" json:"readonly,omitempty"`
	// If set, the mount needs SELinux relabeling.
	SelinuxRelabel bool `protobuf:"varint,4,opt,name=selinux_relabel,json=selinuxRelabel,proto3" json:"selinux_relabel,omitempty"`
	// Requested propagation mode.
	Propagation MountPropagation `protobuf:"varint,5,opt,name=propagation,proto3,enum=runtime.v1.MountPropagation" json:"propagation,omitempty"`
	// UidMappings specifies the runtime UID mappings for the mount.
	UidMappings []*IDMapping `protobuf:"bytes,6,rep,name=uidMappings,proto3" json:"uidMappings,omitempty"`
	// GidMappings specifies the runtime GID mappings for the mount.
	GidMappings []*IDMapping `protobuf:"bytes,7,rep,name=gidMappings,proto3" json:"gidMappings,omitempty"`
	// If set to true, the mount is made recursive read-only.
	// In this CRI API, recursive_read_only is a plain true/false boolean, although its equivalent
	// in the Kubernetes core API is a quaternary that can be nil, "Enabled", "IfPossible", or "Disabled".
	// kubelet translates that quaternary value in the core API into a boolean in this CRI API.
	// Remarks:
	// - nil is just treated as false
	// - when set to true, readonly must be explicitly set to true, and propagation must be PRIVATE (0).
	// - (readonly == false && recursive_read_only == false) does not make the mount read-only.
	RecursiveReadOnly    bool     `protobuf:"varint,8,opt,name=recursive_read_only,json=recursiveReadOnly,proto3" json:"recursive_read_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Mount) Reset()      { *m = Mount{} }
func (*Mount) ProtoMessage() {}
func (*Mount) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{4}
}
func (m *Mount) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Mount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Mount.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Mount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mount.Merge(m, src)
}
func (m *Mount) XXX_Size() int {
	return m.Size()
}
func (m *Mount) XXX_DiscardUnknown() {
	xxx_messageInfo_Mount.DiscardUnknown(m)
}

var xxx_messageInfo_Mount proto.InternalMessageInfo

func (m *Mount) GetContainerPath() string {
	if m != nil {
		return m.ContainerPath
	}
	return ""
}

func (m *Mount) GetHostPath() string {
	if m != nil {
		return m.HostPath
	}
	return ""
}

func (m *Mount) GetReadonly() bool {
	if m != nil {
		return m.Readonly
	}
	return false
}

func (m *Mount) GetSelinuxRelabel() bool {
	if m != nil {
		return m.SelinuxRelabel
	}
	return false
}

func (m *Mount) GetPropagation() MountPropagation {
	if m != nil {
		return m.Propagation
	}
	return MountPropagation_PROPAGATION_PRIVATE
}

func (m *Mount) GetUidMappings() []*IDMapping {
	if m != nil {
		return m.UidMappings
	}
	return nil
}

func (m *Mount) GetGidMappings() []*IDMapping {
	if m != nil {
		return m.GidMappings
	}
	return nil
}

func (m *Mount) GetRecursiveReadOnly() bool {
	if m != nil {
		return m.RecursiveReadOnly
	}
	return false
}

// IDMapping describes host to container ID mappings for a pod sandbox.
type IDMapping struct {
	// HostId is the id on the host.
	HostId uint32 `protobuf:"varint,1,opt,name=host_id,json=hostId,proto3" json:"host_id,omitempty"`
	// ContainerId is the id in the container.
	ContainerId uint32 `protobuf:"varint,2,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Length is the size of the range to map.
	Length               uint32   `protobuf:"varint,3,opt,name=length,proto3" json:"length,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IDMapping) Reset()      { *m = IDMapping{} }
func (*IDMapping) ProtoMessage() {}
func (*IDMapping) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{5}
}
func (m *IDMapping) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IDMapping) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IDMapping.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IDMapping) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IDMapping.Merge(m, src)
}
func (m *IDMapping) XXX_Size() int {
	return m.Size()
}
func (m *IDMapping) XXX_DiscardUnknown() {
	xxx_messageInfo_IDMapping.DiscardUnknown(m)
}

var xxx_messageInfo_IDMapping proto.InternalMessageInfo

func (m *IDMapping) GetHostId() uint32 {
	if m != nil {
		return m.HostId
	}
	return 0
}

func (m *IDMapping) GetContainerId() uint32 {
	if m != nil {
		return m.ContainerId
	}
	return 0
}

func (m *IDMapping) GetLength() uint32 {
	if m != nil {
		return m.Length
	}
	return 0
}

// UserNamespace describes the intended user namespace configuration for a pod sandbox.
type UserNamespace struct {
	// Mode is the NamespaceMode for this UserNamespace.
	// Note: NamespaceMode for UserNamespace currently supports only POD and NODE, not CONTAINER OR TARGET.
	Mode NamespaceMode `protobuf:"varint,1,opt,name=mode,proto3,enum=runtime.v1.NamespaceMode" json:"mode,omitempty"`
	// Uids specifies the UID mappings for the user namespace.
	Uids []*IDMapping `protobuf:"bytes,2,rep,name=uids,proto3" json:"uids,omitempty"`
	// Gids specifies the GID mappings for the user namespace.
	Gids                 []*IDMapping `protobuf:"bytes,3,rep,name=gids,proto3" json:"gids,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *UserNamespace) Reset()      { *m = UserNamespace{} }
func (*UserNamespace) ProtoMessage() {}
func (*UserNamespace) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{6}
}
func (m *UserNamespace) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UserNamespace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UserNamespace.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UserNamespace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserNamespace.Merge(m, src)
}
func (m *UserNamespace) XXX_Size() int {
	return m.Size()
}
func (m *UserNamespace) XXX_DiscardUnknown() {
	xxx_messageInfo_UserNamespace.DiscardUnknown(m)
}

var xxx_messageInfo_UserNamespace proto.InternalMessageInfo

func (m *UserNamespace) GetMode() NamespaceMode {
	if m != nil {
		return m.Mode
	}
	return NamespaceMode_POD
}

func (m *UserNamespace) GetUids() []*IDMapping {
	if m != nil {
		return m.Uids
	}
	return nil
}

func (m *UserNamespace) GetGids() []*IDMapping {
	if m != nil {
		return m.Gids
	}
	return nil
}

// NamespaceOption provides options for Linux namespaces.
type NamespaceOption struct {
	// Network namespace for this container/sandbox.
	// Note: There is currently no way to set CONTAINER scoped network in the Kubernetes API.
	// Namespaces currently set by the kubelet: POD, NODE
	Network NamespaceMode `protobuf:"varint,1,opt,name=network,proto3,enum=runtime.v1.NamespaceMode" json:"network,omitempty"`
	// PID namespace for this container/sandbox.
	// Note: The CRI default is POD, but the v1.PodSpec default is CONTAINER.
	// The kubelet's runtime manager will set this to CONTAINER explicitly for v1 pods.
	// Namespaces currently set by the kubelet: POD, CONTAINER, NODE, TARGET
	Pid NamespaceMode `protobuf:"varint,2,opt,name=pid,proto3,enum=runtime.v1.NamespaceMode" json:"pid,omitempty"`
	// IPC namespace for this container/sandbox.
	// Note: There is currently no way to set CONTAINER scoped IPC in the Kubernetes API.
	// Namespaces currently set by the kubelet: POD, NODE
	Ipc NamespaceMode `protobuf:"varint,3,opt,name=ipc,proto3,enum=runtime.v1.NamespaceMode" json:"ipc,omitempty"`
	// Target Container ID for NamespaceMode of TARGET. This container must have been
	// previously created in the same pod. It is not possible to specify different targets
	// for each namespace.
	TargetId string `protobuf:"bytes,4,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// UsernsOptions for this pod sandbox.
	// The Kubelet picks the user namespace configuration to use for the pod sandbox.  The mappings
	// are specified as part of the UserNamespace struct.  If the struct is nil, then the POD mode
	// must be assumed.  This is done for backward compatibility with older Kubelet versions that
	// do not set a user namespace.
	UsernsOptions        *UserNamespace `protobuf:"bytes,5,opt,name=userns_options,json=usernsOptions,proto3" json:"userns_options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *NamespaceOption) Reset()      { *m = NamespaceOption{} }
func (*NamespaceOption) ProtoMessage() {}
func (*NamespaceOption) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{7}
}
func (m *NamespaceOption) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NamespaceOption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NamespaceOption.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NamespaceOption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NamespaceOption.Merge(m, src)
}
func (m *NamespaceOption) XXX_Size() int {
	return m.Size()
}
func (m *NamespaceOption) XXX_DiscardUnknown() {
	xxx_messageInfo_NamespaceOption.DiscardUnknown(m)
}

var xxx_messageInfo_NamespaceOption proto.InternalMessageInfo

func (m *NamespaceOption) GetNetwork() NamespaceMode {
	if m != nil {
		return m.Network
	}
	return NamespaceMode_POD
}

func (m *NamespaceOption) GetPid() NamespaceMode {
	if m != nil {
		return m.Pid
	}
	return NamespaceMode_POD
}

func (m *NamespaceOption) GetIpc() NamespaceMode {
	if m != nil {
		return m.Ipc
	}
	return NamespaceMode_POD
}

func (m *NamespaceOption) GetTargetId() string {
	if m != nil {
		return m.TargetId
	}
	return ""
}

func (m *NamespaceOption) GetUsernsOptions() *UserNamespace {
	if m != nil {
		return m.UsernsOptions
	}
	return nil
}

// Int64Value is the wrapper of int64.
type Int64Value struct {
	// The value.
	Value                int64    `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Int64Value) Reset()      { *m = Int64Value{} }
func (*Int64Value) ProtoMessage() {}
func (*Int64Value) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{8}
}
func (m *Int64Value) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Int64Value) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Int64Value.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Int64Value) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Int64Value.Merge(m, src)
}
func (m *Int64Value) XXX_Size() int {
	return m.Size()
}
func (m *Int64Value) XXX_DiscardUnknown() {
	xxx_messageInfo_Int64Value.DiscardUnknown(m)
}

var xxx_messageInfo_Int64Value proto.InternalMessageInfo

func (m *Int64Value) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

// LinuxSandboxSecurityContext holds linux security configuration that will be
// applied to a sandbox. Note that:
//  1. It does not apply to containers in the pods.
//  2. It may not be applicable to a PodSandbox which does not contain any running
//     process.
type LinuxSandboxSecurityContext struct {
	// Configurations for the sandbox's namespaces.
	// This will be used only if the PodSandbox uses namespace for isolation.
	NamespaceOptions *NamespaceOption `protobuf:"bytes,1,opt,name=namespace_options,json=namespaceOptions,proto3" json:"namespace_options,omitempty"`
	// Optional SELinux context to be applied.
	SelinuxOptions *SELinuxOption `protobuf:"bytes,2,opt,name=selinux_options,json=selinuxOptions,proto3" json:"selinux_options,omitempty"`
	// UID to run sandbox processes as, when applicable.
	RunAsUser *Int64Value `protobuf:"bytes,3,opt,name=run_as_user,json=runAsUser,proto3" json:"run_as_user,omitempty"`
	// GID to run sandbox processes as, when applicable. run_as_group should only
	// be specified when run_as_user is specified; otherwise, the runtime MUST error.
	RunAsGroup *Int64Value `protobuf:"bytes,8,opt,name=run_as_group,json=runAsGroup,proto3" json:"run_as_group,omitempty"`
	// If set, the root filesystem of the sandbox is read-only.
	ReadonlyRootfs bool `protobuf:"varint,4,opt,name=readonly_rootfs,json=readonlyRootfs,proto3" json:"readonly_rootfs,omitempty"`
	// List of groups applied to the first process run in each container.
	// supplemental_groups_policy can control how groups will be calculated.
	SupplementalGroups []int64 `protobuf:"varint,5,rep,packed,name=supplemental_groups,json=supplementalGroups,proto3" json:"supplemental_groups,omitempty"`
	// supplemental_groups_policy defines how supplemental groups of the first
	// container processes are calculated.
	// Valid values are "Merge" and "Strict".
	// If not specified, "Merge" is used.
	SupplementalGroupsPolicy SupplementalGroupsPolicy `protobuf:"varint,11,opt,name=supplemental_groups_policy,json=supplementalGroupsPolicy,proto3,enum=runtime.v1.SupplementalGroupsPolicy" json:"supplemental_groups_policy,omitempty"`
	// Indicates whether the sandbox will be asked to run a privileged
	// container. If a privileged container is to be executed within it, this
	// MUST be true.
	// This allows a sandbox to take additional security precautions if no
	// privileged containers are expected to be run.
	Privileged bool `protobuf:"varint,6,opt,name=privileged,proto3" json:"privileged,omitempty"`
	// Seccomp profile for the sandbox.
	Seccomp *SecurityProfile `protobuf:"bytes,9,opt,name=seccomp,proto3" json:"seccomp,omitempty"`
	// AppArmor profile for the sandbox.
	Apparmor *SecurityProfile `protobuf:"bytes,10,opt,name=apparmor,proto3" json:"apparmor,omitempty"`
	// Seccomp profile for the sandbox, candidate values are:
	//   - runtime/default: the default profile for the container runtime
	//   - unconfined: unconfined profile, ie, no seccomp sandboxing
	//   - localhost/<full-path-to-profile>: the profile installed on the node.
	//     <full-path-to-profile> is the full path of the profile.
	//
	// Default: "", which is identical with unconfined.
	SeccompProfilePath   string   `protobuf:"bytes,7,opt,name=seccomp_profile_path,json=seccompProfilePath,proto3" json:"seccomp_profile_path,omitempty"` // Deprecated: Do not use.
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinuxSandboxSecurityContext) Reset()      { *m = LinuxSandboxSecurityContext{} }
func (*LinuxSandboxSecurityContext) ProtoMessage() {}
func (*LinuxSandboxSecurityContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{9}
}
func (m *LinuxSandboxSecurityContext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxSandboxSecurityContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxSandboxSecurityContext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxSandboxSecurityContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxSandboxSecurityContext.Merge(m, src)
}
func (m *LinuxSandboxSecurityContext) XXX_Size() int {
	return m.Size()
}
func (m *LinuxSandboxSecurityContext) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxSandboxSecurityContext.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxSandboxSecurityContext proto.InternalMessageInfo

func (m *LinuxSandboxSecurityContext) GetNamespaceOptions() *NamespaceOption {
	if m != nil {
		return m.NamespaceOptions
	}
	return nil
}

func (m *LinuxSandboxSecurityContext) GetSelinuxOptions() *SELinuxOption {
	if m != nil {
		return m.SelinuxOptions
	}
	return nil
}

func (m *LinuxSandboxSecurityContext) GetRunAsUser() *Int64Value {
	if m != nil {
		return m.RunAsUser
	}
	return nil
}

func (m *LinuxSandboxSecurityContext) GetRunAsGroup() *Int64Value {
	if m != nil {
		return m.RunAsGroup
	}
	return nil
}

func (m *LinuxSandboxSecurityContext) GetReadonlyRootfs() bool {
	if m != nil {
		return m.ReadonlyRootfs
	}
	return false
}

func (m *LinuxSandboxSecurityContext) GetSupplementalGroups() []int64 {
	if m != nil {
		return m.SupplementalGroups
	}
	return nil
}

func (m *LinuxSandboxSecurityContext) GetSupplementalGroupsPolicy() SupplementalGroupsPolicy {
	if m != nil {
		return m.SupplementalGroupsPolicy
	}
	return SupplementalGroupsPolicy_Merge
}

func (m *LinuxSandboxSecurityContext) GetPrivileged() bool {
	if m != nil {
		return m.Privileged
	}
	return false
}

func (m *LinuxSandboxSecurityContext) GetSeccomp() *SecurityProfile {
	if m != nil {
		return m.Seccomp
	}
	return nil
}

func (m *LinuxSandboxSecurityContext) GetApparmor() *SecurityProfile {
	if m != nil {
		return m.Apparmor
	}
	return nil
}

// Deprecated: Do not use.
func (m *LinuxSandboxSecurityContext) GetSeccompProfilePath() string {
	if m != nil {
		return m.SeccompProfilePath
	}
	return ""
}

// A security profile which can be used for sandboxes and containers.
type SecurityProfile struct {
	// Indicator which `ProfileType` should be applied.
	ProfileType SecurityProfile_ProfileType `protobuf:"varint,1,opt,name=profile_type,json=profileType,proto3,enum=runtime.v1.SecurityProfile_ProfileType" json:"profile_type,omitempty"`
	// Indicates that a pre-defined profile on the node should be used.
	// Must only be set if `ProfileType` is `Localhost`.
	// For seccomp, it must be an absolute path to the seccomp profile.
	// For AppArmor, this field is the AppArmor `<profile name>/`
	LocalhostRef         string   `protobuf:"bytes,2,opt,name=localhost_ref,json=localhostRef,proto3" json:"localhost_ref,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SecurityProfile) Reset()      { *m = SecurityProfile{} }
func (*SecurityProfile) ProtoMessage() {}
func (*SecurityProfile) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{10}
}
func (m *SecurityProfile) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SecurityProfile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SecurityProfile.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SecurityProfile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityProfile.Merge(m, src)
}
func (m *SecurityProfile) XXX_Size() int {
	return m.Size()
}
func (m *SecurityProfile) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityProfile.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityProfile proto.InternalMessageInfo

func (m *SecurityProfile) GetProfileType() SecurityProfile_ProfileType {
	if m != nil {
		return m.ProfileType
	}
	return SecurityProfile_RuntimeDefault
}

func (m *SecurityProfile) GetLocalhostRef() string {
	if m != nil {
		return m.LocalhostRef
	}
	return ""
}

// LinuxPodSandboxConfig holds platform-specific configurations for Linux
// host platforms and Linux-based containers.
type LinuxPodSandboxConfig struct {
	// Parent cgroup of the PodSandbox.
	// The cgroupfs style syntax will be used, but the container runtime can
	// convert it to systemd semantics if needed.
	CgroupParent string `protobuf:"bytes,1,opt,name=cgroup_parent,json=cgroupParent,proto3" json:"cgroup_parent,omitempty"`
	// LinuxSandboxSecurityContext holds sandbox security attributes.
	SecurityContext *LinuxSandboxSecurityContext `protobuf:"bytes,2,opt,name=security_context,json=securityContext,proto3" json:"security_context,omitempty"`
	// Sysctls holds linux sysctls config for the sandbox.
	Sysctls map[string]string `protobuf:"bytes,3,rep,name=sysctls,proto3" json:"sysctls,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional overhead represents the overheads associated with this sandbox
	Overhead *LinuxContainerResources `protobuf:"bytes,4,opt,name=overhead,proto3" json:"overhead,omitempty"`
	// Optional resources represents the sum of container resources for this sandbox
	Resources            *LinuxContainerResources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *LinuxPodSandboxConfig) Reset()      { *m = LinuxPodSandboxConfig{} }
func (*LinuxPodSandboxConfig) ProtoMessage() {}
func (*LinuxPodSandboxConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{11}
}
func (m *LinuxPodSandboxConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxPodSandboxConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxPodSandboxConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxPodSandboxConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxPodSandboxConfig.Merge(m, src)
}
func (m *LinuxPodSandboxConfig) XXX_Size() int {
	return m.Size()
}
func (m *LinuxPodSandboxConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxPodSandboxConfig.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxPodSandboxConfig proto.InternalMessageInfo

func (m *LinuxPodSandboxConfig) GetCgroupParent() string {
	if m != nil {
		return m.CgroupParent
	}
	return ""
}

func (m *LinuxPodSandboxConfig) GetSecurityContext() *LinuxSandboxSecurityContext {
	if m != nil {
		return m.SecurityContext
	}
	return nil
}

func (m *LinuxPodSandboxConfig) GetSysctls() map[string]string {
	if m != nil {
		return m.Sysctls
	}
	return nil
}

func (m *LinuxPodSandboxConfig) GetOverhead() *LinuxContainerResources {
	if m != nil {
		return m.Overhead
	}
	return nil
}

func (m *LinuxPodSandboxConfig) GetResources() *LinuxContainerResources {
	if m != nil {
		return m.Resources
	}
	return nil
}

// PodSandboxMetadata holds all necessary information for building the sandbox name.
// The container runtime is encouraged to expose the metadata associated with the
// PodSandbox in its user interface for better user experience. For example,
// the runtime can construct a unique PodSandboxName based on the metadata.
type PodSandboxMetadata struct {
	// Pod name of the sandbox. Same as the pod name in the Pod ObjectMeta.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Pod UID of the sandbox. Same as the pod UID in the Pod ObjectMeta.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Pod namespace of the sandbox. Same as the pod namespace in the Pod ObjectMeta.
	Namespace string `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Attempt number of creating the sandbox. Default: 0.
	Attempt              uint32   `protobuf:"varint,4,opt,name=attempt,proto3" json:"attempt,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PodSandboxMetadata) Reset()      { *m = PodSandboxMetadata{} }
func (*PodSandboxMetadata) ProtoMessage() {}
func (*PodSandboxMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{12}
}
func (m *PodSandboxMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSandboxMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSandboxMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSandboxMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSandboxMetadata.Merge(m, src)
}
func (m *PodSandboxMetadata) XXX_Size() int {
	return m.Size()
}
func (m *PodSandboxMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSandboxMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_PodSandboxMetadata proto.InternalMessageInfo

func (m *PodSandboxMetadata) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PodSandboxMetadata) GetUid() string {
	if m != nil {
		return m.Uid
	}
	return ""
}

func (m *PodSandboxMetadata) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *PodSandboxMetadata) GetAttempt() uint32 {
	if m != nil {
		return m.Attempt
	}
	return 0
}

// PodSandboxConfig holds all the required and optional fields for creating a
// sandbox.
type PodSandboxConfig struct {
	// Metadata of the sandbox. This information will uniquely identify the
	// sandbox, and the runtime should leverage this to ensure correct
	// operation. The runtime may also use this information to improve UX, such
	// as by constructing a readable name.
	Metadata *PodSandboxMetadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Hostname of the sandbox. Hostname could only be empty when the pod
	// network namespace is NODE.
	Hostname string `protobuf:"bytes,2,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Path to the directory on the host in which container log files are
	// stored.
	// By default the log of a container going into the LogDirectory will be
	// hooked up to STDOUT and STDERR. However, the LogDirectory may contain
	// binary log files with structured logging data from the individual
	// containers. For example, the files might be newline separated JSON
	// structured logs, systemd-journald journal files, gRPC trace files, etc.
	// E.g.,
	//
	//	PodSandboxConfig.LogDirectory = `/var/log/pods/<NAMESPACE>_<NAME>_<UID>/`
	//	ContainerConfig.LogPath = `containerName/Instance#.log`
	LogDirectory string `protobuf:"bytes,3,opt,name=log_directory,json=logDirectory,proto3" json:"log_directory,omitempty"`
	// DNS config for the sandbox.
	DnsConfig *DNSConfig `protobuf:"bytes,4,opt,name=dns_config,json=dnsConfig,proto3" json:"dns_config,omitempty"`
	// Port mappings for the sandbox.
	PortMappings []*PortMapping `protobuf:"bytes,5,rep,name=port_mappings,json=portMappings,proto3" json:"port_mappings,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Unstructured key-value map that may be set by the kubelet to store and
	// retrieve arbitrary metadata. This will include any annotations set on a
	// pod through the Kubernetes API.
	//
	// Annotations MUST NOT be altered by the runtime; the annotations stored
	// here MUST be returned in the PodSandboxStatus associated with the pod
	// this PodSandboxConfig creates.
	//
	// In general, in order to preserve a well-defined interface between the
	// kubelet and the container runtime, annotations SHOULD NOT influence
	// runtime behaviour.
	//
	// Annotations can also be useful for runtime authors to experiment with
	// new features that are opaque to the Kubernetes APIs (both user-facing
	// and the CRI). Whenever possible, however, runtime authors SHOULD
	// consider proposing new typed fields for any new features instead.
	Annotations map[string]string `protobuf:"bytes,7,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional configurations specific to Linux hosts.
	Linux *LinuxPodSandboxConfig `protobuf:"bytes,8,opt,name=linux,proto3" json:"linux,omitempty"`
	// Optional configurations specific to Windows hosts.
	Windows              *WindowsPodSandboxConfig `protobuf:"bytes,9,opt,name=windows,proto3" json:"windows,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *PodSandboxConfig) Reset()      { *m = PodSandboxConfig{} }
func (*PodSandboxConfig) ProtoMessage() {}
func (*PodSandboxConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{13}
}
func (m *PodSandboxConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSandboxConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSandboxConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSandboxConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSandboxConfig.Merge(m, src)
}
func (m *PodSandboxConfig) XXX_Size() int {
	return m.Size()
}
func (m *PodSandboxConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSandboxConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PodSandboxConfig proto.InternalMessageInfo

func (m *PodSandboxConfig) GetMetadata() *PodSandboxMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodSandboxConfig) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

func (m *PodSandboxConfig) GetLogDirectory() string {
	if m != nil {
		return m.LogDirectory
	}
	return ""
}

func (m *PodSandboxConfig) GetDnsConfig() *DNSConfig {
	if m != nil {
		return m.DnsConfig
	}
	return nil
}

func (m *PodSandboxConfig) GetPortMappings() []*PortMapping {
	if m != nil {
		return m.PortMappings
	}
	return nil
}

func (m *PodSandboxConfig) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *PodSandboxConfig) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *PodSandboxConfig) GetLinux() *LinuxPodSandboxConfig {
	if m != nil {
		return m.Linux
	}
	return nil
}

func (m *PodSandboxConfig) GetWindows() *WindowsPodSandboxConfig {
	if m != nil {
		return m.Windows
	}
	return nil
}

type RunPodSandboxRequest struct {
	// Configuration for creating a PodSandbox.
	Config *PodSandboxConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Named runtime configuration to use for this PodSandbox.
	// If the runtime handler is unknown, this request should be rejected.  An
	// empty string should select the default handler, equivalent to the
	// behavior before this feature was added.
	// See https://git.k8s.io/enhancements/keps/sig-node/585-runtime-class
	RuntimeHandler       string   `protobuf:"bytes,2,opt,name=runtime_handler,json=runtimeHandler,proto3" json:"runtime_handler,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RunPodSandboxRequest) Reset()      { *m = RunPodSandboxRequest{} }
func (*RunPodSandboxRequest) ProtoMessage() {}
func (*RunPodSandboxRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{14}
}
func (m *RunPodSandboxRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RunPodSandboxRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RunPodSandboxRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RunPodSandboxRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunPodSandboxRequest.Merge(m, src)
}
func (m *RunPodSandboxRequest) XXX_Size() int {
	return m.Size()
}
func (m *RunPodSandboxRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RunPodSandboxRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RunPodSandboxRequest proto.InternalMessageInfo

func (m *RunPodSandboxRequest) GetConfig() *PodSandboxConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *RunPodSandboxRequest) GetRuntimeHandler() string {
	if m != nil {
		return m.RuntimeHandler
	}
	return ""
}

type RunPodSandboxResponse struct {
	// ID of the PodSandbox to run.
	PodSandboxId         string   `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RunPodSandboxResponse) Reset()      { *m = RunPodSandboxResponse{} }
func (*RunPodSandboxResponse) ProtoMessage() {}
func (*RunPodSandboxResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{15}
}
func (m *RunPodSandboxResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RunPodSandboxResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RunPodSandboxResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RunPodSandboxResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunPodSandboxResponse.Merge(m, src)
}
func (m *RunPodSandboxResponse) XXX_Size() int {
	return m.Size()
}
func (m *RunPodSandboxResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RunPodSandboxResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RunPodSandboxResponse proto.InternalMessageInfo

func (m *RunPodSandboxResponse) GetPodSandboxId() string {
	if m != nil {
		return m.PodSandboxId
	}
	return ""
}

type StopPodSandboxRequest struct {
	// ID of the PodSandbox to stop.
	PodSandboxId         string   `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopPodSandboxRequest) Reset()      { *m = StopPodSandboxRequest{} }
func (*StopPodSandboxRequest) ProtoMessage() {}
func (*StopPodSandboxRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{16}
}
func (m *StopPodSandboxRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StopPodSandboxRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StopPodSandboxRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StopPodSandboxRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopPodSandboxRequest.Merge(m, src)
}
func (m *StopPodSandboxRequest) XXX_Size() int {
	return m.Size()
}
func (m *StopPodSandboxRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StopPodSandboxRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StopPodSandboxRequest proto.InternalMessageInfo

func (m *StopPodSandboxRequest) GetPodSandboxId() string {
	if m != nil {
		return m.PodSandboxId
	}
	return ""
}

type StopPodSandboxResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopPodSandboxResponse) Reset()      { *m = StopPodSandboxResponse{} }
func (*StopPodSandboxResponse) ProtoMessage() {}
func (*StopPodSandboxResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{17}
}
func (m *StopPodSandboxResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StopPodSandboxResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StopPodSandboxResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StopPodSandboxResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopPodSandboxResponse.Merge(m, src)
}
func (m *StopPodSandboxResponse) XXX_Size() int {
	return m.Size()
}
func (m *StopPodSandboxResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StopPodSandboxResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StopPodSandboxResponse proto.InternalMessageInfo

type RemovePodSandboxRequest struct {
	// ID of the PodSandbox to remove.
	PodSandboxId         string   `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemovePodSandboxRequest) Reset()      { *m = RemovePodSandboxRequest{} }
func (*RemovePodSandboxRequest) ProtoMessage() {}
func (*RemovePodSandboxRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{18}
}
func (m *RemovePodSandboxRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemovePodSandboxRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemovePodSandboxRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemovePodSandboxRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemovePodSandboxRequest.Merge(m, src)
}
func (m *RemovePodSandboxRequest) XXX_Size() int {
	return m.Size()
}
func (m *RemovePodSandboxRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemovePodSandboxRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemovePodSandboxRequest proto.InternalMessageInfo

func (m *RemovePodSandboxRequest) GetPodSandboxId() string {
	if m != nil {
		return m.PodSandboxId
	}
	return ""
}

type RemovePodSandboxResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemovePodSandboxResponse) Reset()      { *m = RemovePodSandboxResponse{} }
func (*RemovePodSandboxResponse) ProtoMessage() {}
func (*RemovePodSandboxResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{19}
}
func (m *RemovePodSandboxResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemovePodSandboxResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemovePodSandboxResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemovePodSandboxResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemovePodSandboxResponse.Merge(m, src)
}
func (m *RemovePodSandboxResponse) XXX_Size() int {
	return m.Size()
}
func (m *RemovePodSandboxResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RemovePodSandboxResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RemovePodSandboxResponse proto.InternalMessageInfo

type PodSandboxStatusRequest struct {
	// ID of the PodSandbox for which to retrieve status.
	PodSandboxId string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// Verbose indicates whether to return extra information about the pod sandbox.
	Verbose              bool     `protobuf:"varint,2,opt,name=verbose,proto3" json:"verbose,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PodSandboxStatusRequest) Reset()      { *m = PodSandboxStatusRequest{} }
func (*PodSandboxStatusRequest) ProtoMessage() {}
func (*PodSandboxStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{20}
}
func (m *PodSandboxStatusRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSandboxStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSandboxStatusRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSandboxStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSandboxStatusRequest.Merge(m, src)
}
func (m *PodSandboxStatusRequest) XXX_Size() int {
	return m.Size()
}
func (m *PodSandboxStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSandboxStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PodSandboxStatusRequest proto.InternalMessageInfo

func (m *PodSandboxStatusRequest) GetPodSandboxId() string {
	if m != nil {
		return m.PodSandboxId
	}
	return ""
}

func (m *PodSandboxStatusRequest) GetVerbose() bool {
	if m != nil {
		return m.Verbose
	}
	return false
}

// PodIP represents an ip of a Pod
type PodIP struct {
	// an ip is a string representation of an IPv4 or an IPv6
	Ip                   string   `protobuf:"bytes,1,opt,name=ip,proto3" json:"ip,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PodIP) Reset()      { *m = PodIP{} }
func (*PodIP) ProtoMessage() {}
func (*PodIP) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{21}
}
func (m *PodIP) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodIP) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodIP.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodIP) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodIP.Merge(m, src)
}
func (m *PodIP) XXX_Size() int {
	return m.Size()
}
func (m *PodIP) XXX_DiscardUnknown() {
	xxx_messageInfo_PodIP.DiscardUnknown(m)
}

var xxx_messageInfo_PodIP proto.InternalMessageInfo

func (m *PodIP) GetIp() string {
	if m != nil {
		return m.Ip
	}
	return ""
}

// PodSandboxNetworkStatus is the status of the network for a PodSandbox.
// Currently ignored for pods sharing the host networking namespace.
type PodSandboxNetworkStatus struct {
	// IP address of the PodSandbox.
	Ip string `protobuf:"bytes,1,opt,name=ip,proto3" json:"ip,omitempty"`
	// list of additional ips (not inclusive of PodSandboxNetworkStatus.Ip) of the PodSandBoxNetworkStatus
	AdditionalIps        []*PodIP `protobuf:"bytes,2,rep,name=additional_ips,json=additionalIps,proto3" json:"additional_ips,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PodSandboxNetworkStatus) Reset()      { *m = PodSandboxNetworkStatus{} }
func (*PodSandboxNetworkStatus) ProtoMessage() {}
func (*PodSandboxNetworkStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{22}
}
func (m *PodSandboxNetworkStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSandboxNetworkStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSandboxNetworkStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSandboxNetworkStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSandboxNetworkStatus.Merge(m, src)
}
func (m *PodSandboxNetworkStatus) XXX_Size() int {
	return m.Size()
}
func (m *PodSandboxNetworkStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSandboxNetworkStatus.DiscardUnknown(m)
}

var xxx_messageInfo_PodSandboxNetworkStatus proto.InternalMessageInfo

func (m *PodSandboxNetworkStatus) GetIp() string {
	if m != nil {
		return m.Ip
	}
	return ""
}

func (m *PodSandboxNetworkStatus) GetAdditionalIps() []*PodIP {
	if m != nil {
		return m.AdditionalIps
	}
	return nil
}

// Namespace contains paths to the namespaces.
type Namespace struct {
	// Namespace options for Linux namespaces.
	Options              *NamespaceOption `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Namespace) Reset()      { *m = Namespace{} }
func (*Namespace) ProtoMessage() {}
func (*Namespace) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{23}
}
func (m *Namespace) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Namespace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Namespace.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Namespace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Namespace.Merge(m, src)
}
func (m *Namespace) XXX_Size() int {
	return m.Size()
}
func (m *Namespace) XXX_DiscardUnknown() {
	xxx_messageInfo_Namespace.DiscardUnknown(m)
}

var xxx_messageInfo_Namespace proto.InternalMessageInfo

func (m *Namespace) GetOptions() *NamespaceOption {
	if m != nil {
		return m.Options
	}
	return nil
}

// LinuxSandboxStatus contains status specific to Linux sandboxes.
type LinuxPodSandboxStatus struct {
	// Paths to the sandbox's namespaces.
	Namespaces           *Namespace `protobuf:"bytes,1,opt,name=namespaces,proto3" json:"namespaces,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *LinuxPodSandboxStatus) Reset()      { *m = LinuxPodSandboxStatus{} }
func (*LinuxPodSandboxStatus) ProtoMessage() {}
func (*LinuxPodSandboxStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{24}
}
func (m *LinuxPodSandboxStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxPodSandboxStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxPodSandboxStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxPodSandboxStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxPodSandboxStatus.Merge(m, src)
}
func (m *LinuxPodSandboxStatus) XXX_Size() int {
	return m.Size()
}
func (m *LinuxPodSandboxStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxPodSandboxStatus.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxPodSandboxStatus proto.InternalMessageInfo

func (m *LinuxPodSandboxStatus) GetNamespaces() *Namespace {
	if m != nil {
		return m.Namespaces
	}
	return nil
}

// PodSandboxStatus contains the status of the PodSandbox.
type PodSandboxStatus struct {
	// ID of the sandbox.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Metadata of the sandbox.
	Metadata *PodSandboxMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// State of the sandbox.
	State PodSandboxState `protobuf:"varint,3,opt,name=state,proto3,enum=runtime.v1.PodSandboxState" json:"state,omitempty"`
	// Creation timestamp of the sandbox in nanoseconds. Must be > 0.
	CreatedAt int64 `protobuf:"varint,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Network contains network status if network is handled by the runtime.
	Network *PodSandboxNetworkStatus `protobuf:"bytes,5,opt,name=network,proto3" json:"network,omitempty"`
	// Linux-specific status to a pod sandbox.
	Linux *LinuxPodSandboxStatus `protobuf:"bytes,6,opt,name=linux,proto3" json:"linux,omitempty"`
	// Labels are key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding PodSandboxConfig used to
	// instantiate the pod sandbox this status represents.
	Annotations map[string]string `protobuf:"bytes,8,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// runtime configuration used for this PodSandbox.
	RuntimeHandler       string   `protobuf:"bytes,9,opt,name=runtime_handler,json=runtimeHandler,proto3" json:"runtime_handler,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PodSandboxStatus) Reset()      { *m = PodSandboxStatus{} }
func (*PodSandboxStatus) ProtoMessage() {}
func (*PodSandboxStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{25}
}
func (m *PodSandboxStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSandboxStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSandboxStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSandboxStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSandboxStatus.Merge(m, src)
}
func (m *PodSandboxStatus) XXX_Size() int {
	return m.Size()
}
func (m *PodSandboxStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSandboxStatus.DiscardUnknown(m)
}

var xxx_messageInfo_PodSandboxStatus proto.InternalMessageInfo

func (m *PodSandboxStatus) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PodSandboxStatus) GetMetadata() *PodSandboxMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodSandboxStatus) GetState() PodSandboxState {
	if m != nil {
		return m.State
	}
	return PodSandboxState_SANDBOX_READY
}

func (m *PodSandboxStatus) GetCreatedAt() int64 {
	if m != nil {
		return m.CreatedAt
	}
	return 0
}

func (m *PodSandboxStatus) GetNetwork() *PodSandboxNetworkStatus {
	if m != nil {
		return m.Network
	}
	return nil
}

func (m *PodSandboxStatus) GetLinux() *LinuxPodSandboxStatus {
	if m != nil {
		return m.Linux
	}
	return nil
}

func (m *PodSandboxStatus) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *PodSandboxStatus) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *PodSandboxStatus) GetRuntimeHandler() string {
	if m != nil {
		return m.RuntimeHandler
	}
	return ""
}

type PodSandboxStatusResponse struct {
	// Status of the PodSandbox.
	Status *PodSandboxStatus `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Info is extra information of the PodSandbox. The key could be arbitrary string, and
	// value should be in json format. The information could include anything useful for
	// debug, e.g. network namespace for linux container based container runtime.
	// It should only be returned non-empty when Verbose is true.
	Info map[string]string `protobuf:"bytes,2,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Container statuses
	ContainersStatuses []*ContainerStatus `protobuf:"bytes,3,rep,name=containers_statuses,json=containersStatuses,proto3" json:"containers_statuses,omitempty"`
	// Timestamp at which container and pod statuses were recorded
	Timestamp            int64    `protobuf:"varint,4,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PodSandboxStatusResponse) Reset()      { *m = PodSandboxStatusResponse{} }
func (*PodSandboxStatusResponse) ProtoMessage() {}
func (*PodSandboxStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{26}
}
func (m *PodSandboxStatusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSandboxStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSandboxStatusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSandboxStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSandboxStatusResponse.Merge(m, src)
}
func (m *PodSandboxStatusResponse) XXX_Size() int {
	return m.Size()
}
func (m *PodSandboxStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSandboxStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PodSandboxStatusResponse proto.InternalMessageInfo

func (m *PodSandboxStatusResponse) GetStatus() *PodSandboxStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *PodSandboxStatusResponse) GetInfo() map[string]string {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *PodSandboxStatusResponse) GetContainersStatuses() []*ContainerStatus {
	if m != nil {
		return m.ContainersStatuses
	}
	return nil
}

func (m *PodSandboxStatusResponse) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

// PodSandboxStateValue is the wrapper of PodSandboxState.
type PodSandboxStateValue struct {
	// State of the sandbox.
	State                PodSandboxState `protobuf:"varint,1,opt,name=state,proto3,enum=runtime.v1.PodSandboxState" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *PodSandboxStateValue) Reset()      { *m = PodSandboxStateValue{} }
func (*PodSandboxStateValue) ProtoMessage() {}
func (*PodSandboxStateValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{27}
}
func (m *PodSandboxStateValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSandboxStateValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSandboxStateValue.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSandboxStateValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSandboxStateValue.Merge(m, src)
}
func (m *PodSandboxStateValue) XXX_Size() int {
	return m.Size()
}
func (m *PodSandboxStateValue) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSandboxStateValue.DiscardUnknown(m)
}

var xxx_messageInfo_PodSandboxStateValue proto.InternalMessageInfo

func (m *PodSandboxStateValue) GetState() PodSandboxState {
	if m != nil {
		return m.State
	}
	return PodSandboxState_SANDBOX_READY
}

// PodSandboxFilter is used to filter a list of PodSandboxes.
// All those fields are combined with 'AND'
type PodSandboxFilter struct {
	// ID of the sandbox.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// State of the sandbox.
	State *PodSandboxStateValue `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	// LabelSelector to select matches.
	// Only api.MatchLabels is supported for now and the requirements
	// are ANDed. MatchExpressions is not supported yet.
	LabelSelector        map[string]string `protobuf:"bytes,3,rep,name=label_selector,json=labelSelector,proto3" json:"label_selector,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PodSandboxFilter) Reset()      { *m = PodSandboxFilter{} }
func (*PodSandboxFilter) ProtoMessage() {}
func (*PodSandboxFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{28}
}
func (m *PodSandboxFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSandboxFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSandboxFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSandboxFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSandboxFilter.Merge(m, src)
}
func (m *PodSandboxFilter) XXX_Size() int {
	return m.Size()
}
func (m *PodSandboxFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSandboxFilter.DiscardUnknown(m)
}

var xxx_messageInfo_PodSandboxFilter proto.InternalMessageInfo

func (m *PodSandboxFilter) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PodSandboxFilter) GetState() *PodSandboxStateValue {
	if m != nil {
		return m.State
	}
	return nil
}

func (m *PodSandboxFilter) GetLabelSelector() map[string]string {
	if m != nil {
		return m.LabelSelector
	}
	return nil
}

type ListPodSandboxRequest struct {
	// PodSandboxFilter to filter a list of PodSandboxes.
	Filter               *PodSandboxFilter `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ListPodSandboxRequest) Reset()      { *m = ListPodSandboxRequest{} }
func (*ListPodSandboxRequest) ProtoMessage() {}
func (*ListPodSandboxRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{29}
}
func (m *ListPodSandboxRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListPodSandboxRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListPodSandboxRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListPodSandboxRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPodSandboxRequest.Merge(m, src)
}
func (m *ListPodSandboxRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListPodSandboxRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPodSandboxRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPodSandboxRequest proto.InternalMessageInfo

func (m *ListPodSandboxRequest) GetFilter() *PodSandboxFilter {
	if m != nil {
		return m.Filter
	}
	return nil
}

// PodSandbox contains minimal information about a sandbox.
type PodSandbox struct {
	// ID of the PodSandbox.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Metadata of the PodSandbox.
	Metadata *PodSandboxMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// State of the PodSandbox.
	State PodSandboxState `protobuf:"varint,3,opt,name=state,proto3,enum=runtime.v1.PodSandboxState" json:"state,omitempty"`
	// Creation timestamps of the PodSandbox in nanoseconds. Must be > 0.
	CreatedAt int64 `protobuf:"varint,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Labels of the PodSandbox.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding PodSandboxConfig used to
	// instantiate this PodSandbox.
	Annotations map[string]string `protobuf:"bytes,6,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// runtime configuration used for this PodSandbox.
	RuntimeHandler       string   `protobuf:"bytes,7,opt,name=runtime_handler,json=runtimeHandler,proto3" json:"runtime_handler,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PodSandbox) Reset()      { *m = PodSandbox{} }
func (*PodSandbox) ProtoMessage() {}
func (*PodSandbox) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{30}
}
func (m *PodSandbox) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSandbox) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSandbox.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSandbox) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSandbox.Merge(m, src)
}
func (m *PodSandbox) XXX_Size() int {
	return m.Size()
}
func (m *PodSandbox) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSandbox.DiscardUnknown(m)
}

var xxx_messageInfo_PodSandbox proto.InternalMessageInfo

func (m *PodSandbox) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PodSandbox) GetMetadata() *PodSandboxMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodSandbox) GetState() PodSandboxState {
	if m != nil {
		return m.State
	}
	return PodSandboxState_SANDBOX_READY
}

func (m *PodSandbox) GetCreatedAt() int64 {
	if m != nil {
		return m.CreatedAt
	}
	return 0
}

func (m *PodSandbox) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *PodSandbox) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *PodSandbox) GetRuntimeHandler() string {
	if m != nil {
		return m.RuntimeHandler
	}
	return ""
}

type ListPodSandboxResponse struct {
	// List of PodSandboxes.
	Items                []*PodSandbox `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ListPodSandboxResponse) Reset()      { *m = ListPodSandboxResponse{} }
func (*ListPodSandboxResponse) ProtoMessage() {}
func (*ListPodSandboxResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{31}
}
func (m *ListPodSandboxResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListPodSandboxResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListPodSandboxResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListPodSandboxResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPodSandboxResponse.Merge(m, src)
}
func (m *ListPodSandboxResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListPodSandboxResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPodSandboxResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListPodSandboxResponse proto.InternalMessageInfo

func (m *ListPodSandboxResponse) GetItems() []*PodSandbox {
	if m != nil {
		return m.Items
	}
	return nil
}

type PodSandboxStatsRequest struct {
	// ID of the pod sandbox for which to retrieve stats.
	PodSandboxId         string   `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PodSandboxStatsRequest) Reset()      { *m = PodSandboxStatsRequest{} }
func (*PodSandboxStatsRequest) ProtoMessage() {}
func (*PodSandboxStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{32}
}
func (m *PodSandboxStatsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSandboxStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSandboxStatsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSandboxStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSandboxStatsRequest.Merge(m, src)
}
func (m *PodSandboxStatsRequest) XXX_Size() int {
	return m.Size()
}
func (m *PodSandboxStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSandboxStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PodSandboxStatsRequest proto.InternalMessageInfo

func (m *PodSandboxStatsRequest) GetPodSandboxId() string {
	if m != nil {
		return m.PodSandboxId
	}
	return ""
}

type PodSandboxStatsResponse struct {
	Stats                *PodSandboxStats `protobuf:"bytes,1,opt,name=stats,proto3" json:"stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *PodSandboxStatsResponse) Reset()      { *m = PodSandboxStatsResponse{} }
func (*PodSandboxStatsResponse) ProtoMessage() {}
func (*PodSandboxStatsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{33}
}
func (m *PodSandboxStatsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSandboxStatsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSandboxStatsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSandboxStatsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSandboxStatsResponse.Merge(m, src)
}
func (m *PodSandboxStatsResponse) XXX_Size() int {
	return m.Size()
}
func (m *PodSandboxStatsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSandboxStatsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PodSandboxStatsResponse proto.InternalMessageInfo

func (m *PodSandboxStatsResponse) GetStats() *PodSandboxStats {
	if m != nil {
		return m.Stats
	}
	return nil
}

// PodSandboxStatsFilter is used to filter the list of pod sandboxes to retrieve stats for.
// All those fields are combined with 'AND'.
type PodSandboxStatsFilter struct {
	// ID of the pod sandbox.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// LabelSelector to select matches.
	// Only api.MatchLabels is supported for now and the requirements
	// are ANDed. MatchExpressions is not supported yet.
	LabelSelector        map[string]string `protobuf:"bytes,2,rep,name=label_selector,json=labelSelector,proto3" json:"label_selector,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PodSandboxStatsFilter) Reset()      { *m = PodSandboxStatsFilter{} }
func (*PodSandboxStatsFilter) ProtoMessage() {}
func (*PodSandboxStatsFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{34}
}
func (m *PodSandboxStatsFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSandboxStatsFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSandboxStatsFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSandboxStatsFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSandboxStatsFilter.Merge(m, src)
}
func (m *PodSandboxStatsFilter) XXX_Size() int {
	return m.Size()
}
func (m *PodSandboxStatsFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSandboxStatsFilter.DiscardUnknown(m)
}

var xxx_messageInfo_PodSandboxStatsFilter proto.InternalMessageInfo

func (m *PodSandboxStatsFilter) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PodSandboxStatsFilter) GetLabelSelector() map[string]string {
	if m != nil {
		return m.LabelSelector
	}
	return nil
}

type ListPodSandboxStatsRequest struct {
	// Filter for the list request.
	Filter               *PodSandboxStatsFilter `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *ListPodSandboxStatsRequest) Reset()      { *m = ListPodSandboxStatsRequest{} }
func (*ListPodSandboxStatsRequest) ProtoMessage() {}
func (*ListPodSandboxStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{35}
}
func (m *ListPodSandboxStatsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListPodSandboxStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListPodSandboxStatsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListPodSandboxStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPodSandboxStatsRequest.Merge(m, src)
}
func (m *ListPodSandboxStatsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListPodSandboxStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPodSandboxStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPodSandboxStatsRequest proto.InternalMessageInfo

func (m *ListPodSandboxStatsRequest) GetFilter() *PodSandboxStatsFilter {
	if m != nil {
		return m.Filter
	}
	return nil
}

type ListPodSandboxStatsResponse struct {
	// Stats of the pod sandbox.
	Stats                []*PodSandboxStats `protobuf:"bytes,1,rep,name=stats,proto3" json:"stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ListPodSandboxStatsResponse) Reset()      { *m = ListPodSandboxStatsResponse{} }
func (*ListPodSandboxStatsResponse) ProtoMessage() {}
func (*ListPodSandboxStatsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{36}
}
func (m *ListPodSandboxStatsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListPodSandboxStatsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListPodSandboxStatsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListPodSandboxStatsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPodSandboxStatsResponse.Merge(m, src)
}
func (m *ListPodSandboxStatsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListPodSandboxStatsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPodSandboxStatsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListPodSandboxStatsResponse proto.InternalMessageInfo

func (m *ListPodSandboxStatsResponse) GetStats() []*PodSandboxStats {
	if m != nil {
		return m.Stats
	}
	return nil
}

// PodSandboxAttributes provides basic information of the pod sandbox.
type PodSandboxAttributes struct {
	// ID of the pod sandbox.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Metadata of the pod sandbox.
	Metadata *PodSandboxMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding PodSandboxStatus used to
	// instantiate the PodSandbox this status represents.
	Annotations          map[string]string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PodSandboxAttributes) Reset()      { *m = PodSandboxAttributes{} }
func (*PodSandboxAttributes) ProtoMessage() {}
func (*PodSandboxAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{37}
}
func (m *PodSandboxAttributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSandboxAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSandboxAttributes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSandboxAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSandboxAttributes.Merge(m, src)
}
func (m *PodSandboxAttributes) XXX_Size() int {
	return m.Size()
}
func (m *PodSandboxAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSandboxAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_PodSandboxAttributes proto.InternalMessageInfo

func (m *PodSandboxAttributes) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PodSandboxAttributes) GetMetadata() *PodSandboxMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodSandboxAttributes) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *PodSandboxAttributes) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

// PodSandboxStats provides the resource usage statistics for a pod.
// The linux or windows field will be populated depending on the platform.
type PodSandboxStats struct {
	// Information of the pod.
	Attributes *PodSandboxAttributes `protobuf:"bytes,1,opt,name=attributes,proto3" json:"attributes,omitempty"`
	// Stats from linux.
	Linux *LinuxPodSandboxStats `protobuf:"bytes,2,opt,name=linux,proto3" json:"linux,omitempty"`
	// Stats from windows.
	Windows              *WindowsPodSandboxStats `protobuf:"bytes,3,opt,name=windows,proto3" json:"windows,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *PodSandboxStats) Reset()      { *m = PodSandboxStats{} }
func (*PodSandboxStats) ProtoMessage() {}
func (*PodSandboxStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{38}
}
func (m *PodSandboxStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSandboxStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSandboxStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSandboxStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSandboxStats.Merge(m, src)
}
func (m *PodSandboxStats) XXX_Size() int {
	return m.Size()
}
func (m *PodSandboxStats) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSandboxStats.DiscardUnknown(m)
}

var xxx_messageInfo_PodSandboxStats proto.InternalMessageInfo

func (m *PodSandboxStats) GetAttributes() *PodSandboxAttributes {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *PodSandboxStats) GetLinux() *LinuxPodSandboxStats {
	if m != nil {
		return m.Linux
	}
	return nil
}

func (m *PodSandboxStats) GetWindows() *WindowsPodSandboxStats {
	if m != nil {
		return m.Windows
	}
	return nil
}

// LinuxPodSandboxStats provides the resource usage statistics for a pod sandbox on linux.
type LinuxPodSandboxStats struct {
	// CPU usage gathered for the pod sandbox.
	Cpu *CpuUsage `protobuf:"bytes,1,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Memory usage gathered for the pod sandbox.
	Memory *MemoryUsage `protobuf:"bytes,2,opt,name=memory,proto3" json:"memory,omitempty"`
	// Network usage gathered for the pod sandbox
	Network *NetworkUsage `protobuf:"bytes,3,opt,name=network,proto3" json:"network,omitempty"`
	// Stats pertaining to processes in the pod sandbox.
	Process *ProcessUsage `protobuf:"bytes,4,opt,name=process,proto3" json:"process,omitempty"`
	// Stats of containers in the measured pod sandbox.
	Containers           []*ContainerStats `protobuf:"bytes,5,rep,name=containers,proto3" json:"containers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *LinuxPodSandboxStats) Reset()      { *m = LinuxPodSandboxStats{} }
func (*LinuxPodSandboxStats) ProtoMessage() {}
func (*LinuxPodSandboxStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{39}
}
func (m *LinuxPodSandboxStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxPodSandboxStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxPodSandboxStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxPodSandboxStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxPodSandboxStats.Merge(m, src)
}
func (m *LinuxPodSandboxStats) XXX_Size() int {
	return m.Size()
}
func (m *LinuxPodSandboxStats) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxPodSandboxStats.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxPodSandboxStats proto.InternalMessageInfo

func (m *LinuxPodSandboxStats) GetCpu() *CpuUsage {
	if m != nil {
		return m.Cpu
	}
	return nil
}

func (m *LinuxPodSandboxStats) GetMemory() *MemoryUsage {
	if m != nil {
		return m.Memory
	}
	return nil
}

func (m *LinuxPodSandboxStats) GetNetwork() *NetworkUsage {
	if m != nil {
		return m.Network
	}
	return nil
}

func (m *LinuxPodSandboxStats) GetProcess() *ProcessUsage {
	if m != nil {
		return m.Process
	}
	return nil
}

func (m *LinuxPodSandboxStats) GetContainers() []*ContainerStats {
	if m != nil {
		return m.Containers
	}
	return nil
}

// WindowsPodSandboxStats provides the resource usage statistics for a pod sandbox on windows
type WindowsPodSandboxStats struct {
	// CPU usage gathered for the pod sandbox.
	Cpu *WindowsCpuUsage `protobuf:"bytes,1,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Memory usage gathered for the pod sandbox.
	Memory *WindowsMemoryUsage `protobuf:"bytes,2,opt,name=memory,proto3" json:"memory,omitempty"`
	// Network usage gathered for the pod sandbox
	Network *WindowsNetworkUsage `protobuf:"bytes,3,opt,name=network,proto3" json:"network,omitempty"`
	// Stats pertaining to processes in the pod sandbox.
	Process *WindowsProcessUsage `protobuf:"bytes,4,opt,name=process,proto3" json:"process,omitempty"`
	// Stats of containers in the measured pod sandbox.
	Containers           []*WindowsContainerStats `protobuf:"bytes,5,rep,name=containers,proto3" json:"containers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *WindowsPodSandboxStats) Reset()      { *m = WindowsPodSandboxStats{} }
func (*WindowsPodSandboxStats) ProtoMessage() {}
func (*WindowsPodSandboxStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{40}
}
func (m *WindowsPodSandboxStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsPodSandboxStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsPodSandboxStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsPodSandboxStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsPodSandboxStats.Merge(m, src)
}
func (m *WindowsPodSandboxStats) XXX_Size() int {
	return m.Size()
}
func (m *WindowsPodSandboxStats) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsPodSandboxStats.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsPodSandboxStats proto.InternalMessageInfo

func (m *WindowsPodSandboxStats) GetCpu() *WindowsCpuUsage {
	if m != nil {
		return m.Cpu
	}
	return nil
}

func (m *WindowsPodSandboxStats) GetMemory() *WindowsMemoryUsage {
	if m != nil {
		return m.Memory
	}
	return nil
}

func (m *WindowsPodSandboxStats) GetNetwork() *WindowsNetworkUsage {
	if m != nil {
		return m.Network
	}
	return nil
}

func (m *WindowsPodSandboxStats) GetProcess() *WindowsProcessUsage {
	if m != nil {
		return m.Process
	}
	return nil
}

func (m *WindowsPodSandboxStats) GetContainers() []*WindowsContainerStats {
	if m != nil {
		return m.Containers
	}
	return nil
}

// NetworkUsage contains data about network resources.
type NetworkUsage struct {
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Stats for the default network interface.
	DefaultInterface *NetworkInterfaceUsage `protobuf:"bytes,2,opt,name=default_interface,json=defaultInterface,proto3" json:"default_interface,omitempty"`
	// Stats for all found network interfaces, excluding the default.
	Interfaces           []*NetworkInterfaceUsage `protobuf:"bytes,3,rep,name=interfaces,proto3" json:"interfaces,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *NetworkUsage) Reset()      { *m = NetworkUsage{} }
func (*NetworkUsage) ProtoMessage() {}
func (*NetworkUsage) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{41}
}
func (m *NetworkUsage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkUsage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkUsage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkUsage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkUsage.Merge(m, src)
}
func (m *NetworkUsage) XXX_Size() int {
	return m.Size()
}
func (m *NetworkUsage) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkUsage.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkUsage proto.InternalMessageInfo

func (m *NetworkUsage) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *NetworkUsage) GetDefaultInterface() *NetworkInterfaceUsage {
	if m != nil {
		return m.DefaultInterface
	}
	return nil
}

func (m *NetworkUsage) GetInterfaces() []*NetworkInterfaceUsage {
	if m != nil {
		return m.Interfaces
	}
	return nil
}

// WindowsNetworkUsage contains data about network resources specific to Windows.
type WindowsNetworkUsage struct {
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Stats for the default network interface.
	DefaultInterface *WindowsNetworkInterfaceUsage `protobuf:"bytes,2,opt,name=default_interface,json=defaultInterface,proto3" json:"default_interface,omitempty"`
	// Stats for all found network interfaces, excluding the default.
	Interfaces           []*WindowsNetworkInterfaceUsage `protobuf:"bytes,3,rep,name=interfaces,proto3" json:"interfaces,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *WindowsNetworkUsage) Reset()      { *m = WindowsNetworkUsage{} }
func (*WindowsNetworkUsage) ProtoMessage() {}
func (*WindowsNetworkUsage) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{42}
}
func (m *WindowsNetworkUsage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsNetworkUsage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsNetworkUsage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsNetworkUsage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsNetworkUsage.Merge(m, src)
}
func (m *WindowsNetworkUsage) XXX_Size() int {
	return m.Size()
}
func (m *WindowsNetworkUsage) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsNetworkUsage.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsNetworkUsage proto.InternalMessageInfo

func (m *WindowsNetworkUsage) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *WindowsNetworkUsage) GetDefaultInterface() *WindowsNetworkInterfaceUsage {
	if m != nil {
		return m.DefaultInterface
	}
	return nil
}

func (m *WindowsNetworkUsage) GetInterfaces() []*WindowsNetworkInterfaceUsage {
	if m != nil {
		return m.Interfaces
	}
	return nil
}

// NetworkInterfaceUsage contains resource value data about a network interface.
type NetworkInterfaceUsage struct {
	// The name of the network interface.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Cumulative count of bytes received.
	RxBytes *UInt64Value `protobuf:"bytes,2,opt,name=rx_bytes,json=rxBytes,proto3" json:"rx_bytes,omitempty"`
	// Cumulative count of receive errors encountered.
	RxErrors *UInt64Value `protobuf:"bytes,3,opt,name=rx_errors,json=rxErrors,proto3" json:"rx_errors,omitempty"`
	// Cumulative count of bytes transmitted.
	TxBytes *UInt64Value `protobuf:"bytes,4,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`
	// Cumulative count of transmit errors encountered.
	TxErrors             *UInt64Value `protobuf:"bytes,5,opt,name=tx_errors,json=txErrors,proto3" json:"tx_errors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *NetworkInterfaceUsage) Reset()      { *m = NetworkInterfaceUsage{} }
func (*NetworkInterfaceUsage) ProtoMessage() {}
func (*NetworkInterfaceUsage) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{43}
}
func (m *NetworkInterfaceUsage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkInterfaceUsage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkInterfaceUsage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkInterfaceUsage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkInterfaceUsage.Merge(m, src)
}
func (m *NetworkInterfaceUsage) XXX_Size() int {
	return m.Size()
}
func (m *NetworkInterfaceUsage) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkInterfaceUsage.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkInterfaceUsage proto.InternalMessageInfo

func (m *NetworkInterfaceUsage) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *NetworkInterfaceUsage) GetRxBytes() *UInt64Value {
	if m != nil {
		return m.RxBytes
	}
	return nil
}

func (m *NetworkInterfaceUsage) GetRxErrors() *UInt64Value {
	if m != nil {
		return m.RxErrors
	}
	return nil
}

func (m *NetworkInterfaceUsage) GetTxBytes() *UInt64Value {
	if m != nil {
		return m.TxBytes
	}
	return nil
}

func (m *NetworkInterfaceUsage) GetTxErrors() *UInt64Value {
	if m != nil {
		return m.TxErrors
	}
	return nil
}

// WindowsNetworkInterfaceUsage contains resource value data about a network interface specific for Windows.
type WindowsNetworkInterfaceUsage struct {
	// The name of the network interface.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Cumulative count of bytes received.
	RxBytes *UInt64Value `protobuf:"bytes,2,opt,name=rx_bytes,json=rxBytes,proto3" json:"rx_bytes,omitempty"`
	// Cumulative count of receive errors encountered.
	RxPacketsDropped *UInt64Value `protobuf:"bytes,3,opt,name=rx_packets_dropped,json=rxPacketsDropped,proto3" json:"rx_packets_dropped,omitempty"`
	// Cumulative count of bytes transmitted.
	TxBytes *UInt64Value `protobuf:"bytes,4,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`
	// Cumulative count of transmit errors encountered.
	TxPacketsDropped     *UInt64Value `protobuf:"bytes,5,opt,name=tx_packets_dropped,json=txPacketsDropped,proto3" json:"tx_packets_dropped,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *WindowsNetworkInterfaceUsage) Reset()      { *m = WindowsNetworkInterfaceUsage{} }
func (*WindowsNetworkInterfaceUsage) ProtoMessage() {}
func (*WindowsNetworkInterfaceUsage) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{44}
}
func (m *WindowsNetworkInterfaceUsage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsNetworkInterfaceUsage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsNetworkInterfaceUsage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsNetworkInterfaceUsage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsNetworkInterfaceUsage.Merge(m, src)
}
func (m *WindowsNetworkInterfaceUsage) XXX_Size() int {
	return m.Size()
}
func (m *WindowsNetworkInterfaceUsage) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsNetworkInterfaceUsage.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsNetworkInterfaceUsage proto.InternalMessageInfo

func (m *WindowsNetworkInterfaceUsage) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *WindowsNetworkInterfaceUsage) GetRxBytes() *UInt64Value {
	if m != nil {
		return m.RxBytes
	}
	return nil
}

func (m *WindowsNetworkInterfaceUsage) GetRxPacketsDropped() *UInt64Value {
	if m != nil {
		return m.RxPacketsDropped
	}
	return nil
}

func (m *WindowsNetworkInterfaceUsage) GetTxBytes() *UInt64Value {
	if m != nil {
		return m.TxBytes
	}
	return nil
}

func (m *WindowsNetworkInterfaceUsage) GetTxPacketsDropped() *UInt64Value {
	if m != nil {
		return m.TxPacketsDropped
	}
	return nil
}

// ProcessUsage are stats pertaining to processes.
type ProcessUsage struct {
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Number of processes.
	ProcessCount         *UInt64Value `protobuf:"bytes,2,opt,name=process_count,json=processCount,proto3" json:"process_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ProcessUsage) Reset()      { *m = ProcessUsage{} }
func (*ProcessUsage) ProtoMessage() {}
func (*ProcessUsage) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{45}
}
func (m *ProcessUsage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessUsage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessUsage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessUsage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessUsage.Merge(m, src)
}
func (m *ProcessUsage) XXX_Size() int {
	return m.Size()
}
func (m *ProcessUsage) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessUsage.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessUsage proto.InternalMessageInfo

func (m *ProcessUsage) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *ProcessUsage) GetProcessCount() *UInt64Value {
	if m != nil {
		return m.ProcessCount
	}
	return nil
}

// WindowsProcessUsage are stats pertaining to processes specific to Windows.
type WindowsProcessUsage struct {
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Number of processes.
	ProcessCount         *UInt64Value `protobuf:"bytes,2,opt,name=process_count,json=processCount,proto3" json:"process_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *WindowsProcessUsage) Reset()      { *m = WindowsProcessUsage{} }
func (*WindowsProcessUsage) ProtoMessage() {}
func (*WindowsProcessUsage) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{46}
}
func (m *WindowsProcessUsage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsProcessUsage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsProcessUsage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsProcessUsage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsProcessUsage.Merge(m, src)
}
func (m *WindowsProcessUsage) XXX_Size() int {
	return m.Size()
}
func (m *WindowsProcessUsage) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsProcessUsage.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsProcessUsage proto.InternalMessageInfo

func (m *WindowsProcessUsage) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *WindowsProcessUsage) GetProcessCount() *UInt64Value {
	if m != nil {
		return m.ProcessCount
	}
	return nil
}

// ImageSpec is an internal representation of an image.
type ImageSpec struct {
	// Container's Image field (e.g. imageID or imageDigest).
	Image string `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Unstructured key-value map holding arbitrary metadata.
	// ImageSpec Annotations can be used to help the runtime target specific
	// images in multi-arch images.
	Annotations map[string]string `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The container image reference specified by the user (e.g. image[:tag] or digest).
	// Only set if available within the RPC context.
	UserSpecifiedImage string `protobuf:"bytes,18,opt,name=user_specified_image,json=userSpecifiedImage,proto3" json:"user_specified_image,omitempty"`
	// Runtime handler to use for pulling the image.
	// If the runtime handler is unknown, the request should be rejected.
	// An empty string would select the default runtime handler.
	RuntimeHandler       string   `protobuf:"bytes,19,opt,name=runtime_handler,json=runtimeHandler,proto3" json:"runtime_handler,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImageSpec) Reset()      { *m = ImageSpec{} }
func (*ImageSpec) ProtoMessage() {}
func (*ImageSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{47}
}
func (m *ImageSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImageSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImageSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImageSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageSpec.Merge(m, src)
}
func (m *ImageSpec) XXX_Size() int {
	return m.Size()
}
func (m *ImageSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ImageSpec proto.InternalMessageInfo

func (m *ImageSpec) GetImage() string {
	if m != nil {
		return m.Image
	}
	return ""
}

func (m *ImageSpec) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *ImageSpec) GetUserSpecifiedImage() string {
	if m != nil {
		return m.UserSpecifiedImage
	}
	return ""
}

func (m *ImageSpec) GetRuntimeHandler() string {
	if m != nil {
		return m.RuntimeHandler
	}
	return ""
}

type KeyValue struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KeyValue) Reset()      { *m = KeyValue{} }
func (*KeyValue) ProtoMessage() {}
func (*KeyValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{48}
}
func (m *KeyValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KeyValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KeyValue.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KeyValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyValue.Merge(m, src)
}
func (m *KeyValue) XXX_Size() int {
	return m.Size()
}
func (m *KeyValue) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyValue.DiscardUnknown(m)
}

var xxx_messageInfo_KeyValue proto.InternalMessageInfo

func (m *KeyValue) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *KeyValue) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// LinuxContainerResources specifies Linux specific configuration for
// resources.
type LinuxContainerResources struct {
	// CPU CFS (Completely Fair Scheduler) period. Default: 0 (not specified).
	CpuPeriod int64 `protobuf:"varint,1,opt,name=cpu_period,json=cpuPeriod,proto3" json:"cpu_period,omitempty"`
	// CPU CFS (Completely Fair Scheduler) quota. Default: 0 (not specified).
	CpuQuota int64 `protobuf:"varint,2,opt,name=cpu_quota,json=cpuQuota,proto3" json:"cpu_quota,omitempty"`
	// CPU shares (relative weight vs. other containers). Default: 0 (not specified).
	CpuShares int64 `protobuf:"varint,3,opt,name=cpu_shares,json=cpuShares,proto3" json:"cpu_shares,omitempty"`
	// Memory limit in bytes. Default: 0 (not specified).
	MemoryLimitInBytes int64 `protobuf:"varint,4,opt,name=memory_limit_in_bytes,json=memoryLimitInBytes,proto3" json:"memory_limit_in_bytes,omitempty"`
	// OOMScoreAdj adjusts the oom-killer score. Default: 0 (not specified).
	OomScoreAdj int64 `protobuf:"varint,5,opt,name=oom_score_adj,json=oomScoreAdj,proto3" json:"oom_score_adj,omitempty"`
	// CpusetCpus constrains the allowed set of logical CPUs. Default: "" (not specified).
	CpusetCpus string `protobuf:"bytes,6,opt,name=cpuset_cpus,json=cpusetCpus,proto3" json:"cpuset_cpus,omitempty"`
	// CpusetMems constrains the allowed set of memory nodes. Default: "" (not specified).
	CpusetMems string `protobuf:"bytes,7,opt,name=cpuset_mems,json=cpusetMems,proto3" json:"cpuset_mems,omitempty"`
	// List of HugepageLimits to limit the HugeTLB usage of container per page size. Default: nil (not specified).
	HugepageLimits []*HugepageLimit `protobuf:"bytes,8,rep,name=hugepage_limits,json=hugepageLimits,proto3" json:"hugepage_limits,omitempty"`
	// Unified resources for cgroup v2. Default: nil (not specified).
	// Each key/value in the map refers to the cgroup v2.
	// e.g. "memory.max": "6937202688" or "io.weight": "default 100".
	Unified map[string]string `protobuf:"bytes,9,rep,name=unified,proto3" json:"unified,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Memory swap limit in bytes. Default 0 (not specified).
	MemorySwapLimitInBytes int64    `protobuf:"varint,10,opt,name=memory_swap_limit_in_bytes,json=memorySwapLimitInBytes,proto3" json:"memory_swap_limit_in_bytes,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *LinuxContainerResources) Reset()      { *m = LinuxContainerResources{} }
func (*LinuxContainerResources) ProtoMessage() {}
func (*LinuxContainerResources) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{49}
}
func (m *LinuxContainerResources) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxContainerResources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxContainerResources.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxContainerResources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxContainerResources.Merge(m, src)
}
func (m *LinuxContainerResources) XXX_Size() int {
	return m.Size()
}
func (m *LinuxContainerResources) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxContainerResources.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxContainerResources proto.InternalMessageInfo

func (m *LinuxContainerResources) GetCpuPeriod() int64 {
	if m != nil {
		return m.CpuPeriod
	}
	return 0
}

func (m *LinuxContainerResources) GetCpuQuota() int64 {
	if m != nil {
		return m.CpuQuota
	}
	return 0
}

func (m *LinuxContainerResources) GetCpuShares() int64 {
	if m != nil {
		return m.CpuShares
	}
	return 0
}

func (m *LinuxContainerResources) GetMemoryLimitInBytes() int64 {
	if m != nil {
		return m.MemoryLimitInBytes
	}
	return 0
}

func (m *LinuxContainerResources) GetOomScoreAdj() int64 {
	if m != nil {
		return m.OomScoreAdj
	}
	return 0
}

func (m *LinuxContainerResources) GetCpusetCpus() string {
	if m != nil {
		return m.CpusetCpus
	}
	return ""
}

func (m *LinuxContainerResources) GetCpusetMems() string {
	if m != nil {
		return m.CpusetMems
	}
	return ""
}

func (m *LinuxContainerResources) GetHugepageLimits() []*HugepageLimit {
	if m != nil {
		return m.HugepageLimits
	}
	return nil
}

func (m *LinuxContainerResources) GetUnified() map[string]string {
	if m != nil {
		return m.Unified
	}
	return nil
}

func (m *LinuxContainerResources) GetMemorySwapLimitInBytes() int64 {
	if m != nil {
		return m.MemorySwapLimitInBytes
	}
	return 0
}

// HugepageLimit corresponds to the file`hugetlb.<hugepagesize>.limit_in_byte` in container level cgroup.
// For example, `PageSize=1GB`, `Limit=1073741824` means setting `1073741824` bytes to hugetlb.1GB.limit_in_bytes.
type HugepageLimit struct {
	// The value of PageSize has the format <size><unit-prefix>B (2MB, 1GB),
	// and must match the <hugepagesize> of the corresponding control file found in `hugetlb.<hugepagesize>.limit_in_bytes`.
	// The values of <unit-prefix> are intended to be parsed using base 1024("1KB" = 1024, "1MB" = 1048576, etc).
	PageSize string `protobuf:"bytes,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// limit in bytes of hugepagesize HugeTLB usage.
	Limit                uint64   `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HugepageLimit) Reset()      { *m = HugepageLimit{} }
func (*HugepageLimit) ProtoMessage() {}
func (*HugepageLimit) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{50}
}
func (m *HugepageLimit) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HugepageLimit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HugepageLimit.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HugepageLimit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HugepageLimit.Merge(m, src)
}
func (m *HugepageLimit) XXX_Size() int {
	return m.Size()
}
func (m *HugepageLimit) XXX_DiscardUnknown() {
	xxx_messageInfo_HugepageLimit.DiscardUnknown(m)
}

var xxx_messageInfo_HugepageLimit proto.InternalMessageInfo

func (m *HugepageLimit) GetPageSize() string {
	if m != nil {
		return m.PageSize
	}
	return ""
}

func (m *HugepageLimit) GetLimit() uint64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

// SELinuxOption are the labels to be applied to the container.
type SELinuxOption struct {
	User                 string   `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	Role                 string   `protobuf:"bytes,2,opt,name=role,proto3" json:"role,omitempty"`
	Type                 string   `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	Level                string   `protobuf:"bytes,4,opt,name=level,proto3" json:"level,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SELinuxOption) Reset()      { *m = SELinuxOption{} }
func (*SELinuxOption) ProtoMessage() {}
func (*SELinuxOption) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{51}
}
func (m *SELinuxOption) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SELinuxOption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SELinuxOption.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SELinuxOption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SELinuxOption.Merge(m, src)
}
func (m *SELinuxOption) XXX_Size() int {
	return m.Size()
}
func (m *SELinuxOption) XXX_DiscardUnknown() {
	xxx_messageInfo_SELinuxOption.DiscardUnknown(m)
}

var xxx_messageInfo_SELinuxOption proto.InternalMessageInfo

func (m *SELinuxOption) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *SELinuxOption) GetRole() string {
	if m != nil {
		return m.Role
	}
	return ""
}

func (m *SELinuxOption) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *SELinuxOption) GetLevel() string {
	if m != nil {
		return m.Level
	}
	return ""
}

// Capability contains the container capabilities to add or drop
// Dropping a capability will drop it from all sets.
// If a capability is added to only the add_capabilities list then it gets added to permitted,
// inheritable, effective and bounding sets, i.e. all sets except the ambient set.
// If a capability is added to only the add_ambient_capabilities list then it gets added to all sets, i.e permitted
// inheritable, effective, bounding and ambient sets.
// If a capability is added to add_capabilities and add_ambient_capabilities lists then it gets added to all sets, i.e.
// permitted, inheritable, effective, bounding and ambient sets.
type Capability struct {
	// List of capabilities to add.
	AddCapabilities []string `protobuf:"bytes,1,rep,name=add_capabilities,json=addCapabilities,proto3" json:"add_capabilities,omitempty"`
	// List of capabilities to drop.
	DropCapabilities []string `protobuf:"bytes,2,rep,name=drop_capabilities,json=dropCapabilities,proto3" json:"drop_capabilities,omitempty"`
	// List of ambient capabilities to add.
	AddAmbientCapabilities []string `protobuf:"bytes,3,rep,name=add_ambient_capabilities,json=addAmbientCapabilities,proto3" json:"add_ambient_capabilities,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *Capability) Reset()      { *m = Capability{} }
func (*Capability) ProtoMessage() {}
func (*Capability) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{52}
}
func (m *Capability) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Capability) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Capability.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Capability) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Capability.Merge(m, src)
}
func (m *Capability) XXX_Size() int {
	return m.Size()
}
func (m *Capability) XXX_DiscardUnknown() {
	xxx_messageInfo_Capability.DiscardUnknown(m)
}

var xxx_messageInfo_Capability proto.InternalMessageInfo

func (m *Capability) GetAddCapabilities() []string {
	if m != nil {
		return m.AddCapabilities
	}
	return nil
}

func (m *Capability) GetDropCapabilities() []string {
	if m != nil {
		return m.DropCapabilities
	}
	return nil
}

func (m *Capability) GetAddAmbientCapabilities() []string {
	if m != nil {
		return m.AddAmbientCapabilities
	}
	return nil
}

// LinuxContainerSecurityContext holds linux security configuration that will be applied to a container.
type LinuxContainerSecurityContext struct {
	// Capabilities to add or drop.
	Capabilities *Capability `protobuf:"bytes,1,opt,name=capabilities,proto3" json:"capabilities,omitempty"`
	// If set, run container in privileged mode.
	// Privileged mode is incompatible with the following options. If
	// privileged is set, the following features MAY have no effect:
	// 1. capabilities
	// 2. selinux_options
	// 4. seccomp
	// 5. apparmor
	//
	// Privileged mode implies the following specific options are applied:
	// 1. All capabilities are added.
	// 2. Sensitive paths, such as kernel module paths within sysfs, are not masked.
	// 3. Any sysfs and procfs mounts are mounted RW.
	// 4. AppArmor confinement is not applied.
	// 5. Seccomp restrictions are not applied.
	// 6. The device cgroup does not restrict access to any devices.
	// 7. All devices from the host's /dev are available within the container.
	// 8. SELinux restrictions are not applied (e.g. label=disabled).
	Privileged bool `protobuf:"varint,2,opt,name=privileged,proto3" json:"privileged,omitempty"`
	// Configurations for the container's namespaces.
	// Only used if the container uses namespace for isolation.
	NamespaceOptions *NamespaceOption `protobuf:"bytes,3,opt,name=namespace_options,json=namespaceOptions,proto3" json:"namespace_options,omitempty"`
	// SELinux context to be optionally applied.
	SelinuxOptions *SELinuxOption `protobuf:"bytes,4,opt,name=selinux_options,json=selinuxOptions,proto3" json:"selinux_options,omitempty"`
	// UID to run the container process as. Only one of run_as_user and
	// run_as_username can be specified at a time.
	RunAsUser *Int64Value `protobuf:"bytes,5,opt,name=run_as_user,json=runAsUser,proto3" json:"run_as_user,omitempty"`
	// GID to run the container process as. run_as_group should only be specified
	// when run_as_user or run_as_username is specified; otherwise, the runtime
	// MUST error.
	RunAsGroup *Int64Value `protobuf:"bytes,12,opt,name=run_as_group,json=runAsGroup,proto3" json:"run_as_group,omitempty"`
	// User name to run the container process as. If specified, the user MUST
	// exist in the container image (i.e. in the /etc/passwd inside the image),
	// and be resolved there by the runtime; otherwise, the runtime MUST error.
	RunAsUsername string `protobuf:"bytes,6,opt,name=run_as_username,json=runAsUsername,proto3" json:"run_as_username,omitempty"`
	// If set, the root filesystem of the container is read-only.
	ReadonlyRootfs bool `protobuf:"varint,7,opt,name=readonly_rootfs,json=readonlyRootfs,proto3" json:"readonly_rootfs,omitempty"`
	// List of groups applied to the first process run in each container.
	// supplemental_groups_policy can control how groups will be calculated.
	SupplementalGroups []int64 `protobuf:"varint,8,rep,packed,name=supplemental_groups,json=supplementalGroups,proto3" json:"supplemental_groups,omitempty"`
	// supplemental_groups_policy defines how supplemental groups of the first
	// container processes are calculated.
	// Valid values are "Merge" and "Strict".
	// If not specified, "Merge" is used.
	SupplementalGroupsPolicy SupplementalGroupsPolicy `protobuf:"varint,17,opt,name=supplemental_groups_policy,json=supplementalGroupsPolicy,proto3,enum=runtime.v1.SupplementalGroupsPolicy" json:"supplemental_groups_policy,omitempty"`
	// no_new_privs defines if the flag for no_new_privs should be set on the
	// container.
	NoNewPrivs bool `protobuf:"varint,11,opt,name=no_new_privs,json=noNewPrivs,proto3" json:"no_new_privs,omitempty"`
	// masked_paths is a slice of paths that should be masked by the container
	// runtime, this can be passed directly to the OCI spec.
	MaskedPaths []string `protobuf:"bytes,13,rep,name=masked_paths,json=maskedPaths,proto3" json:"masked_paths,omitempty"`
	// readonly_paths is a slice of paths that should be set as readonly by the
	// container runtime, this can be passed directly to the OCI spec.
	ReadonlyPaths []string `protobuf:"bytes,14,rep,name=readonly_paths,json=readonlyPaths,proto3" json:"readonly_paths,omitempty"`
	// Seccomp profile for the container.
	Seccomp *SecurityProfile `protobuf:"bytes,15,opt,name=seccomp,proto3" json:"seccomp,omitempty"`
	// AppArmor profile for the container.
	Apparmor *SecurityProfile `protobuf:"bytes,16,opt,name=apparmor,proto3" json:"apparmor,omitempty"`
	// AppArmor profile for the container, candidate values are:
	//   - runtime/default: equivalent to not specifying a profile.
	//   - unconfined: no profiles are loaded
	//   - localhost/<profile_name>: profile loaded on the node
	//     (localhost) by name. The possible profile names are detailed at
	//     https://gitlab.com/apparmor/apparmor/-/wikis/AppArmor_Core_Policy_Reference
	ApparmorProfile string `protobuf:"bytes,9,opt,name=apparmor_profile,json=apparmorProfile,proto3" json:"apparmor_profile,omitempty"` // Deprecated: Do not use.
	// Seccomp profile for the container, candidate values are:
	//   - runtime/default: the default profile for the container runtime
	//   - unconfined: unconfined profile, ie, no seccomp sandboxing
	//   - localhost/<full-path-to-profile>: the profile installed on the node.
	//     <full-path-to-profile> is the full path of the profile.
	//
	// Default: "", which is identical with unconfined.
	SeccompProfilePath   string   `protobuf:"bytes,10,opt,name=seccomp_profile_path,json=seccompProfilePath,proto3" json:"seccomp_profile_path,omitempty"` // Deprecated: Do not use.
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinuxContainerSecurityContext) Reset()      { *m = LinuxContainerSecurityContext{} }
func (*LinuxContainerSecurityContext) ProtoMessage() {}
func (*LinuxContainerSecurityContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{53}
}
func (m *LinuxContainerSecurityContext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxContainerSecurityContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxContainerSecurityContext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxContainerSecurityContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxContainerSecurityContext.Merge(m, src)
}
func (m *LinuxContainerSecurityContext) XXX_Size() int {
	return m.Size()
}
func (m *LinuxContainerSecurityContext) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxContainerSecurityContext.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxContainerSecurityContext proto.InternalMessageInfo

func (m *LinuxContainerSecurityContext) GetCapabilities() *Capability {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

func (m *LinuxContainerSecurityContext) GetPrivileged() bool {
	if m != nil {
		return m.Privileged
	}
	return false
}

func (m *LinuxContainerSecurityContext) GetNamespaceOptions() *NamespaceOption {
	if m != nil {
		return m.NamespaceOptions
	}
	return nil
}

func (m *LinuxContainerSecurityContext) GetSelinuxOptions() *SELinuxOption {
	if m != nil {
		return m.SelinuxOptions
	}
	return nil
}

func (m *LinuxContainerSecurityContext) GetRunAsUser() *Int64Value {
	if m != nil {
		return m.RunAsUser
	}
	return nil
}

func (m *LinuxContainerSecurityContext) GetRunAsGroup() *Int64Value {
	if m != nil {
		return m.RunAsGroup
	}
	return nil
}

func (m *LinuxContainerSecurityContext) GetRunAsUsername() string {
	if m != nil {
		return m.RunAsUsername
	}
	return ""
}

func (m *LinuxContainerSecurityContext) GetReadonlyRootfs() bool {
	if m != nil {
		return m.ReadonlyRootfs
	}
	return false
}

func (m *LinuxContainerSecurityContext) GetSupplementalGroups() []int64 {
	if m != nil {
		return m.SupplementalGroups
	}
	return nil
}

func (m *LinuxContainerSecurityContext) GetSupplementalGroupsPolicy() SupplementalGroupsPolicy {
	if m != nil {
		return m.SupplementalGroupsPolicy
	}
	return SupplementalGroupsPolicy_Merge
}

func (m *LinuxContainerSecurityContext) GetNoNewPrivs() bool {
	if m != nil {
		return m.NoNewPrivs
	}
	return false
}

func (m *LinuxContainerSecurityContext) GetMaskedPaths() []string {
	if m != nil {
		return m.MaskedPaths
	}
	return nil
}

func (m *LinuxContainerSecurityContext) GetReadonlyPaths() []string {
	if m != nil {
		return m.ReadonlyPaths
	}
	return nil
}

func (m *LinuxContainerSecurityContext) GetSeccomp() *SecurityProfile {
	if m != nil {
		return m.Seccomp
	}
	return nil
}

func (m *LinuxContainerSecurityContext) GetApparmor() *SecurityProfile {
	if m != nil {
		return m.Apparmor
	}
	return nil
}

// Deprecated: Do not use.
func (m *LinuxContainerSecurityContext) GetApparmorProfile() string {
	if m != nil {
		return m.ApparmorProfile
	}
	return ""
}

// Deprecated: Do not use.
func (m *LinuxContainerSecurityContext) GetSeccompProfilePath() string {
	if m != nil {
		return m.SeccompProfilePath
	}
	return ""
}

// LinuxContainerConfig contains platform-specific configuration for
// Linux-based containers.
type LinuxContainerConfig struct {
	// Resources specification for the container.
	Resources *LinuxContainerResources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	// LinuxContainerSecurityContext configuration for the container.
	SecurityContext      *LinuxContainerSecurityContext `protobuf:"bytes,2,opt,name=security_context,json=securityContext,proto3" json:"security_context,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *LinuxContainerConfig) Reset()      { *m = LinuxContainerConfig{} }
func (*LinuxContainerConfig) ProtoMessage() {}
func (*LinuxContainerConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{54}
}
func (m *LinuxContainerConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxContainerConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxContainerConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxContainerConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxContainerConfig.Merge(m, src)
}
func (m *LinuxContainerConfig) XXX_Size() int {
	return m.Size()
}
func (m *LinuxContainerConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxContainerConfig.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxContainerConfig proto.InternalMessageInfo

func (m *LinuxContainerConfig) GetResources() *LinuxContainerResources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *LinuxContainerConfig) GetSecurityContext() *LinuxContainerSecurityContext {
	if m != nil {
		return m.SecurityContext
	}
	return nil
}

type LinuxContainerUser struct {
	// uid is the primary uid initially attached to the first process in the container
	Uid int64 `protobuf:"varint,1,opt,name=uid,proto3" json:"uid,omitempty"`
	// gid is the primary gid initially attached to the first process in the container
	Gid int64 `protobuf:"varint,2,opt,name=gid,proto3" json:"gid,omitempty"`
	// supplemental_groups are the supplemental groups initially attached to the first process in the container
	SupplementalGroups   []int64  `protobuf:"varint,3,rep,packed,name=supplemental_groups,json=supplementalGroups,proto3" json:"supplemental_groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinuxContainerUser) Reset()      { *m = LinuxContainerUser{} }
func (*LinuxContainerUser) ProtoMessage() {}
func (*LinuxContainerUser) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{55}
}
func (m *LinuxContainerUser) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxContainerUser) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxContainerUser.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxContainerUser) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxContainerUser.Merge(m, src)
}
func (m *LinuxContainerUser) XXX_Size() int {
	return m.Size()
}
func (m *LinuxContainerUser) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxContainerUser.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxContainerUser proto.InternalMessageInfo

func (m *LinuxContainerUser) GetUid() int64 {
	if m != nil {
		return m.Uid
	}
	return 0
}

func (m *LinuxContainerUser) GetGid() int64 {
	if m != nil {
		return m.Gid
	}
	return 0
}

func (m *LinuxContainerUser) GetSupplementalGroups() []int64 {
	if m != nil {
		return m.SupplementalGroups
	}
	return nil
}

// WindowsNamespaceOption provides options for Windows namespaces.
type WindowsNamespaceOption struct {
	// Network namespace for this container/sandbox.
	// Namespaces currently set by the kubelet: POD, NODE
	Network              NamespaceMode `protobuf:"varint,1,opt,name=network,proto3,enum=runtime.v1.NamespaceMode" json:"network,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *WindowsNamespaceOption) Reset()      { *m = WindowsNamespaceOption{} }
func (*WindowsNamespaceOption) ProtoMessage() {}
func (*WindowsNamespaceOption) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{56}
}
func (m *WindowsNamespaceOption) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsNamespaceOption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsNamespaceOption.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsNamespaceOption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsNamespaceOption.Merge(m, src)
}
func (m *WindowsNamespaceOption) XXX_Size() int {
	return m.Size()
}
func (m *WindowsNamespaceOption) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsNamespaceOption.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsNamespaceOption proto.InternalMessageInfo

func (m *WindowsNamespaceOption) GetNetwork() NamespaceMode {
	if m != nil {
		return m.Network
	}
	return NamespaceMode_POD
}

// WindowsSandboxSecurityContext holds platform-specific configurations that will be
// applied to a sandbox.
// These settings will only apply to the sandbox container.
type WindowsSandboxSecurityContext struct {
	// User name to run the container process as. If specified, the user MUST
	// exist in the container image and be resolved there by the runtime;
	// otherwise, the runtime MUST return error.
	RunAsUsername string `protobuf:"bytes,1,opt,name=run_as_username,json=runAsUsername,proto3" json:"run_as_username,omitempty"`
	// The contents of the GMSA credential spec to use to run this container.
	CredentialSpec string `protobuf:"bytes,2,opt,name=credential_spec,json=credentialSpec,proto3" json:"credential_spec,omitempty"`
	// Indicates whether the container requested to run as a HostProcess container.
	HostProcess bool `protobuf:"varint,3,opt,name=host_process,json=hostProcess,proto3" json:"host_process,omitempty"`
	// Configuration for the sandbox's namespaces
	NamespaceOptions     *WindowsNamespaceOption `protobuf:"bytes,4,opt,name=namespace_options,json=namespaceOptions,proto3" json:"namespace_options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *WindowsSandboxSecurityContext) Reset()      { *m = WindowsSandboxSecurityContext{} }
func (*WindowsSandboxSecurityContext) ProtoMessage() {}
func (*WindowsSandboxSecurityContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{57}
}
func (m *WindowsSandboxSecurityContext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsSandboxSecurityContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsSandboxSecurityContext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsSandboxSecurityContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsSandboxSecurityContext.Merge(m, src)
}
func (m *WindowsSandboxSecurityContext) XXX_Size() int {
	return m.Size()
}
func (m *WindowsSandboxSecurityContext) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsSandboxSecurityContext.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsSandboxSecurityContext proto.InternalMessageInfo

func (m *WindowsSandboxSecurityContext) GetRunAsUsername() string {
	if m != nil {
		return m.RunAsUsername
	}
	return ""
}

func (m *WindowsSandboxSecurityContext) GetCredentialSpec() string {
	if m != nil {
		return m.CredentialSpec
	}
	return ""
}

func (m *WindowsSandboxSecurityContext) GetHostProcess() bool {
	if m != nil {
		return m.HostProcess
	}
	return false
}

func (m *WindowsSandboxSecurityContext) GetNamespaceOptions() *WindowsNamespaceOption {
	if m != nil {
		return m.NamespaceOptions
	}
	return nil
}

// WindowsPodSandboxConfig holds platform-specific configurations for Windows
// host platforms and Windows-based containers.
type WindowsPodSandboxConfig struct {
	// WindowsSandboxSecurityContext holds sandbox security attributes.
	SecurityContext      *WindowsSandboxSecurityContext `protobuf:"bytes,1,opt,name=security_context,json=securityContext,proto3" json:"security_context,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *WindowsPodSandboxConfig) Reset()      { *m = WindowsPodSandboxConfig{} }
func (*WindowsPodSandboxConfig) ProtoMessage() {}
func (*WindowsPodSandboxConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{58}
}
func (m *WindowsPodSandboxConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsPodSandboxConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsPodSandboxConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsPodSandboxConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsPodSandboxConfig.Merge(m, src)
}
func (m *WindowsPodSandboxConfig) XXX_Size() int {
	return m.Size()
}
func (m *WindowsPodSandboxConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsPodSandboxConfig.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsPodSandboxConfig proto.InternalMessageInfo

func (m *WindowsPodSandboxConfig) GetSecurityContext() *WindowsSandboxSecurityContext {
	if m != nil {
		return m.SecurityContext
	}
	return nil
}

// WindowsContainerSecurityContext holds windows security configuration that will be applied to a container.
type WindowsContainerSecurityContext struct {
	// User name to run the container process as. If specified, the user MUST
	// exist in the container image and be resolved there by the runtime;
	// otherwise, the runtime MUST return error.
	RunAsUsername string `protobuf:"bytes,1,opt,name=run_as_username,json=runAsUsername,proto3" json:"run_as_username,omitempty"`
	// The contents of the GMSA credential spec to use to run this container.
	CredentialSpec string `protobuf:"bytes,2,opt,name=credential_spec,json=credentialSpec,proto3" json:"credential_spec,omitempty"`
	// Indicates whether a container is to be run as a HostProcess container.
	HostProcess          bool     `protobuf:"varint,3,opt,name=host_process,json=hostProcess,proto3" json:"host_process,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WindowsContainerSecurityContext) Reset()      { *m = WindowsContainerSecurityContext{} }
func (*WindowsContainerSecurityContext) ProtoMessage() {}
func (*WindowsContainerSecurityContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{59}
}
func (m *WindowsContainerSecurityContext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsContainerSecurityContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsContainerSecurityContext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsContainerSecurityContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsContainerSecurityContext.Merge(m, src)
}
func (m *WindowsContainerSecurityContext) XXX_Size() int {
	return m.Size()
}
func (m *WindowsContainerSecurityContext) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsContainerSecurityContext.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsContainerSecurityContext proto.InternalMessageInfo

func (m *WindowsContainerSecurityContext) GetRunAsUsername() string {
	if m != nil {
		return m.RunAsUsername
	}
	return ""
}

func (m *WindowsContainerSecurityContext) GetCredentialSpec() string {
	if m != nil {
		return m.CredentialSpec
	}
	return ""
}

func (m *WindowsContainerSecurityContext) GetHostProcess() bool {
	if m != nil {
		return m.HostProcess
	}
	return false
}

// WindowsContainerConfig contains platform-specific configuration for
// Windows-based containers.
type WindowsContainerConfig struct {
	// Resources specification for the container.
	Resources *WindowsContainerResources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	// WindowsContainerSecurityContext configuration for the container.
	SecurityContext      *WindowsContainerSecurityContext `protobuf:"bytes,2,opt,name=security_context,json=securityContext,proto3" json:"security_context,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *WindowsContainerConfig) Reset()      { *m = WindowsContainerConfig{} }
func (*WindowsContainerConfig) ProtoMessage() {}
func (*WindowsContainerConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{60}
}
func (m *WindowsContainerConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsContainerConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsContainerConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsContainerConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsContainerConfig.Merge(m, src)
}
func (m *WindowsContainerConfig) XXX_Size() int {
	return m.Size()
}
func (m *WindowsContainerConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsContainerConfig.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsContainerConfig proto.InternalMessageInfo

func (m *WindowsContainerConfig) GetResources() *WindowsContainerResources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *WindowsContainerConfig) GetSecurityContext() *WindowsContainerSecurityContext {
	if m != nil {
		return m.SecurityContext
	}
	return nil
}

// WindowsContainerResources specifies Windows specific configuration for
// resources.
type WindowsContainerResources struct {
	// CPU shares (relative weight vs. other containers). Default: 0 (not specified).
	CpuShares int64 `protobuf:"varint,1,opt,name=cpu_shares,json=cpuShares,proto3" json:"cpu_shares,omitempty"`
	// Number of CPUs available to the container. Default: 0 (not specified).
	CpuCount int64 `protobuf:"varint,2,opt,name=cpu_count,json=cpuCount,proto3" json:"cpu_count,omitempty"`
	// Specifies the portion of processor cycles that this container can use as a percentage times 100.
	CpuMaximum int64 `protobuf:"varint,3,opt,name=cpu_maximum,json=cpuMaximum,proto3" json:"cpu_maximum,omitempty"`
	// Memory limit in bytes. Default: 0 (not specified).
	MemoryLimitInBytes int64 `protobuf:"varint,4,opt,name=memory_limit_in_bytes,json=memoryLimitInBytes,proto3" json:"memory_limit_in_bytes,omitempty"`
	// Specifies the size of the rootfs / scratch space in bytes to be configured for this container. Default: 0 (not specified).
	RootfsSizeInBytes    int64    `protobuf:"varint,5,opt,name=rootfs_size_in_bytes,json=rootfsSizeInBytes,proto3" json:"rootfs_size_in_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WindowsContainerResources) Reset()      { *m = WindowsContainerResources{} }
func (*WindowsContainerResources) ProtoMessage() {}
func (*WindowsContainerResources) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{61}
}
func (m *WindowsContainerResources) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsContainerResources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsContainerResources.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsContainerResources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsContainerResources.Merge(m, src)
}
func (m *WindowsContainerResources) XXX_Size() int {
	return m.Size()
}
func (m *WindowsContainerResources) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsContainerResources.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsContainerResources proto.InternalMessageInfo

func (m *WindowsContainerResources) GetCpuShares() int64 {
	if m != nil {
		return m.CpuShares
	}
	return 0
}

func (m *WindowsContainerResources) GetCpuCount() int64 {
	if m != nil {
		return m.CpuCount
	}
	return 0
}

func (m *WindowsContainerResources) GetCpuMaximum() int64 {
	if m != nil {
		return m.CpuMaximum
	}
	return 0
}

func (m *WindowsContainerResources) GetMemoryLimitInBytes() int64 {
	if m != nil {
		return m.MemoryLimitInBytes
	}
	return 0
}

func (m *WindowsContainerResources) GetRootfsSizeInBytes() int64 {
	if m != nil {
		return m.RootfsSizeInBytes
	}
	return 0
}

// ContainerMetadata holds all necessary information for building the container
// name. The container runtime is encouraged to expose the metadata in its user
// interface for better user experience. E.g., runtime can construct a unique
// container name based on the metadata. Note that (name, attempt) is unique
// within a sandbox for the entire lifetime of the sandbox.
type ContainerMetadata struct {
	// Name of the container. Same as the container name in the PodSpec.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Attempt number of creating the container. Default: 0.
	Attempt              uint32   `protobuf:"varint,2,opt,name=attempt,proto3" json:"attempt,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContainerMetadata) Reset()      { *m = ContainerMetadata{} }
func (*ContainerMetadata) ProtoMessage() {}
func (*ContainerMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{62}
}
func (m *ContainerMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerMetadata.Merge(m, src)
}
func (m *ContainerMetadata) XXX_Size() int {
	return m.Size()
}
func (m *ContainerMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerMetadata proto.InternalMessageInfo

func (m *ContainerMetadata) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ContainerMetadata) GetAttempt() uint32 {
	if m != nil {
		return m.Attempt
	}
	return 0
}

// Device specifies a host device to mount into a container.
type Device struct {
	// Path of the device within the container.
	ContainerPath string `protobuf:"bytes,1,opt,name=container_path,json=containerPath,proto3" json:"container_path,omitempty"`
	// Path of the device on the host.
	HostPath string `protobuf:"bytes,2,opt,name=host_path,json=hostPath,proto3" json:"host_path,omitempty"`
	// Cgroups permissions of the device, candidates are one or more of
	// * r - allows container to read from the specified device.
	// * w - allows container to write to the specified device.
	// * m - allows container to create device files that do not yet exist.
	Permissions          string   `protobuf:"bytes,3,opt,name=permissions,proto3" json:"permissions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Device) Reset()      { *m = Device{} }
func (*Device) ProtoMessage() {}
func (*Device) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{63}
}
func (m *Device) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Device) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Device.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Device) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Device.Merge(m, src)
}
func (m *Device) XXX_Size() int {
	return m.Size()
}
func (m *Device) XXX_DiscardUnknown() {
	xxx_messageInfo_Device.DiscardUnknown(m)
}

var xxx_messageInfo_Device proto.InternalMessageInfo

func (m *Device) GetContainerPath() string {
	if m != nil {
		return m.ContainerPath
	}
	return ""
}

func (m *Device) GetHostPath() string {
	if m != nil {
		return m.HostPath
	}
	return ""
}

func (m *Device) GetPermissions() string {
	if m != nil {
		return m.Permissions
	}
	return ""
}

// CDIDevice specifies a CDI device information.
type CDIDevice struct {
	// Fully qualified CDI device name
	// for example: vendor.com/gpu=gpudevice1
	// see more details in the CDI specification:
	// https://github.com/container-orchestrated-devices/container-device-interface/blob/main/SPEC.md
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CDIDevice) Reset()      { *m = CDIDevice{} }
func (*CDIDevice) ProtoMessage() {}
func (*CDIDevice) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{64}
}
func (m *CDIDevice) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CDIDevice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CDIDevice.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CDIDevice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CDIDevice.Merge(m, src)
}
func (m *CDIDevice) XXX_Size() int {
	return m.Size()
}
func (m *CDIDevice) XXX_DiscardUnknown() {
	xxx_messageInfo_CDIDevice.DiscardUnknown(m)
}

var xxx_messageInfo_CDIDevice proto.InternalMessageInfo

func (m *CDIDevice) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ContainerConfig holds all the required and optional fields for creating a
// container.
type ContainerConfig struct {
	// Metadata of the container. This information will uniquely identify the
	// container, and the runtime should leverage this to ensure correct
	// operation. The runtime may also use this information to improve UX, such
	// as by constructing a readable name.
	Metadata *ContainerMetadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Image to use.
	Image *ImageSpec `protobuf:"bytes,2,opt,name=image,proto3" json:"image,omitempty"`
	// Command to execute (i.e., entrypoint for docker)
	Command []string `protobuf:"bytes,3,rep,name=command,proto3" json:"command,omitempty"`
	// Args for the Command (i.e., command for docker)
	Args []string `protobuf:"bytes,4,rep,name=args,proto3" json:"args,omitempty"`
	// Current working directory of the command.
	WorkingDir string `protobuf:"bytes,5,opt,name=working_dir,json=workingDir,proto3" json:"working_dir,omitempty"`
	// List of environment variable to set in the container.
	Envs []*KeyValue `protobuf:"bytes,6,rep,name=envs,proto3" json:"envs,omitempty"`
	// Mounts for the container.
	Mounts []*Mount `protobuf:"bytes,7,rep,name=mounts,proto3" json:"mounts,omitempty"`
	// Devices for the container.
	Devices []*Device `protobuf:"bytes,8,rep,name=devices,proto3" json:"devices,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	// Label keys are of the form:
	//
	//	label-key ::= prefixed-name | name
	//	prefixed-name ::= prefix '/' name
	//	prefix ::= DNS_SUBDOMAIN
	//	name ::= DNS_LABEL
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Unstructured key-value map that may be used by the kubelet to store and
	// retrieve arbitrary metadata.
	//
	// Annotations MUST NOT be altered by the runtime; the annotations stored
	// here MUST be returned in the ContainerStatus associated with the container
	// this ContainerConfig creates.
	//
	// In general, in order to preserve a well-defined interface between the
	// kubelet and the container runtime, annotations SHOULD NOT influence
	// runtime behaviour.
	Annotations map[string]string `protobuf:"bytes,10,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Path relative to PodSandboxConfig.LogDirectory for container to store
	// the log (STDOUT and STDERR) on the host.
	// E.g.,
	//
	//	PodSandboxConfig.LogDirectory = `/var/log/pods/<NAMESPACE>_<NAME>_<UID>/`
	//	ContainerConfig.LogPath = `containerName/Instance#.log`
	LogPath string `protobuf:"bytes,11,opt,name=log_path,json=logPath,proto3" json:"log_path,omitempty"`
	// Variables for interactive containers, these have very specialized
	// use-cases (e.g. debugging).
	Stdin     bool `protobuf:"varint,12,opt,name=stdin,proto3" json:"stdin,omitempty"`
	StdinOnce bool `protobuf:"varint,13,opt,name=stdin_once,json=stdinOnce,proto3" json:"stdin_once,omitempty"`
	Tty       bool `protobuf:"varint,14,opt,name=tty,proto3" json:"tty,omitempty"`
	// Configuration specific to Linux containers.
	Linux *LinuxContainerConfig `protobuf:"bytes,15,opt,name=linux,proto3" json:"linux,omitempty"`
	// Configuration specific to Windows containers.
	Windows *WindowsContainerConfig `protobuf:"bytes,16,opt,name=windows,proto3" json:"windows,omitempty"`
	// CDI devices for the container.
	CDIDevices           []*CDIDevice `protobuf:"bytes,17,rep,name=CDI_devices,json=CDIDevices,proto3" json:"CDI_devices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ContainerConfig) Reset()      { *m = ContainerConfig{} }
func (*ContainerConfig) ProtoMessage() {}
func (*ContainerConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{65}
}
func (m *ContainerConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerConfig.Merge(m, src)
}
func (m *ContainerConfig) XXX_Size() int {
	return m.Size()
}
func (m *ContainerConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerConfig proto.InternalMessageInfo

func (m *ContainerConfig) GetMetadata() *ContainerMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ContainerConfig) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *ContainerConfig) GetCommand() []string {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *ContainerConfig) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *ContainerConfig) GetWorkingDir() string {
	if m != nil {
		return m.WorkingDir
	}
	return ""
}

func (m *ContainerConfig) GetEnvs() []*KeyValue {
	if m != nil {
		return m.Envs
	}
	return nil
}

func (m *ContainerConfig) GetMounts() []*Mount {
	if m != nil {
		return m.Mounts
	}
	return nil
}

func (m *ContainerConfig) GetDevices() []*Device {
	if m != nil {
		return m.Devices
	}
	return nil
}

func (m *ContainerConfig) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *ContainerConfig) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *ContainerConfig) GetLogPath() string {
	if m != nil {
		return m.LogPath
	}
	return ""
}

func (m *ContainerConfig) GetStdin() bool {
	if m != nil {
		return m.Stdin
	}
	return false
}

func (m *ContainerConfig) GetStdinOnce() bool {
	if m != nil {
		return m.StdinOnce
	}
	return false
}

func (m *ContainerConfig) GetTty() bool {
	if m != nil {
		return m.Tty
	}
	return false
}

func (m *ContainerConfig) GetLinux() *LinuxContainerConfig {
	if m != nil {
		return m.Linux
	}
	return nil
}

func (m *ContainerConfig) GetWindows() *WindowsContainerConfig {
	if m != nil {
		return m.Windows
	}
	return nil
}

func (m *ContainerConfig) GetCDIDevices() []*CDIDevice {
	if m != nil {
		return m.CDIDevices
	}
	return nil
}

type CreateContainerRequest struct {
	// ID of the PodSandbox in which the container should be created.
	PodSandboxId string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// Config of the container.
	Config *ContainerConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Config of the PodSandbox. This is the same config that was passed
	// to RunPodSandboxRequest to create the PodSandbox. It is passed again
	// here just for easy reference. The PodSandboxConfig is immutable and
	// remains the same throughout the lifetime of the pod.
	SandboxConfig        *PodSandboxConfig `protobuf:"bytes,3,opt,name=sandbox_config,json=sandboxConfig,proto3" json:"sandbox_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateContainerRequest) Reset()      { *m = CreateContainerRequest{} }
func (*CreateContainerRequest) ProtoMessage() {}
func (*CreateContainerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{66}
}
func (m *CreateContainerRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CreateContainerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CreateContainerRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CreateContainerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateContainerRequest.Merge(m, src)
}
func (m *CreateContainerRequest) XXX_Size() int {
	return m.Size()
}
func (m *CreateContainerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateContainerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateContainerRequest proto.InternalMessageInfo

func (m *CreateContainerRequest) GetPodSandboxId() string {
	if m != nil {
		return m.PodSandboxId
	}
	return ""
}

func (m *CreateContainerRequest) GetConfig() *ContainerConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *CreateContainerRequest) GetSandboxConfig() *PodSandboxConfig {
	if m != nil {
		return m.SandboxConfig
	}
	return nil
}

type CreateContainerResponse struct {
	// ID of the created container.
	ContainerId          string   `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateContainerResponse) Reset()      { *m = CreateContainerResponse{} }
func (*CreateContainerResponse) ProtoMessage() {}
func (*CreateContainerResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{67}
}
func (m *CreateContainerResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CreateContainerResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CreateContainerResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CreateContainerResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateContainerResponse.Merge(m, src)
}
func (m *CreateContainerResponse) XXX_Size() int {
	return m.Size()
}
func (m *CreateContainerResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateContainerResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateContainerResponse proto.InternalMessageInfo

func (m *CreateContainerResponse) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

type StartContainerRequest struct {
	// ID of the container to start.
	ContainerId          string   `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartContainerRequest) Reset()      { *m = StartContainerRequest{} }
func (*StartContainerRequest) ProtoMessage() {}
func (*StartContainerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{68}
}
func (m *StartContainerRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StartContainerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StartContainerRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StartContainerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartContainerRequest.Merge(m, src)
}
func (m *StartContainerRequest) XXX_Size() int {
	return m.Size()
}
func (m *StartContainerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartContainerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartContainerRequest proto.InternalMessageInfo

func (m *StartContainerRequest) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

type StartContainerResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartContainerResponse) Reset()      { *m = StartContainerResponse{} }
func (*StartContainerResponse) ProtoMessage() {}
func (*StartContainerResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{69}
}
func (m *StartContainerResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StartContainerResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StartContainerResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StartContainerResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartContainerResponse.Merge(m, src)
}
func (m *StartContainerResponse) XXX_Size() int {
	return m.Size()
}
func (m *StartContainerResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StartContainerResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StartContainerResponse proto.InternalMessageInfo

type StopContainerRequest struct {
	// ID of the container to stop.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Timeout in seconds to wait for the container to stop before forcibly
	// terminating it. Default: 0 (forcibly terminate the container immediately)
	Timeout              int64    `protobuf:"varint,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopContainerRequest) Reset()      { *m = StopContainerRequest{} }
func (*StopContainerRequest) ProtoMessage() {}
func (*StopContainerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{70}
}
func (m *StopContainerRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StopContainerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StopContainerRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StopContainerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopContainerRequest.Merge(m, src)
}
func (m *StopContainerRequest) XXX_Size() int {
	return m.Size()
}
func (m *StopContainerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StopContainerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StopContainerRequest proto.InternalMessageInfo

func (m *StopContainerRequest) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *StopContainerRequest) GetTimeout() int64 {
	if m != nil {
		return m.Timeout
	}
	return 0
}

type StopContainerResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopContainerResponse) Reset()      { *m = StopContainerResponse{} }
func (*StopContainerResponse) ProtoMessage() {}
func (*StopContainerResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{71}
}
func (m *StopContainerResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StopContainerResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StopContainerResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StopContainerResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopContainerResponse.Merge(m, src)
}
func (m *StopContainerResponse) XXX_Size() int {
	return m.Size()
}
func (m *StopContainerResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StopContainerResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StopContainerResponse proto.InternalMessageInfo

type RemoveContainerRequest struct {
	// ID of the container to remove.
	ContainerId          string   `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveContainerRequest) Reset()      { *m = RemoveContainerRequest{} }
func (*RemoveContainerRequest) ProtoMessage() {}
func (*RemoveContainerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{72}
}
func (m *RemoveContainerRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveContainerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveContainerRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveContainerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveContainerRequest.Merge(m, src)
}
func (m *RemoveContainerRequest) XXX_Size() int {
	return m.Size()
}
func (m *RemoveContainerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveContainerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveContainerRequest proto.InternalMessageInfo

func (m *RemoveContainerRequest) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

type RemoveContainerResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveContainerResponse) Reset()      { *m = RemoveContainerResponse{} }
func (*RemoveContainerResponse) ProtoMessage() {}
func (*RemoveContainerResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{73}
}
func (m *RemoveContainerResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveContainerResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveContainerResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveContainerResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveContainerResponse.Merge(m, src)
}
func (m *RemoveContainerResponse) XXX_Size() int {
	return m.Size()
}
func (m *RemoveContainerResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveContainerResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveContainerResponse proto.InternalMessageInfo

// ContainerStateValue is the wrapper of ContainerState.
type ContainerStateValue struct {
	// State of the container.
	State                ContainerState `protobuf:"varint,1,opt,name=state,proto3,enum=runtime.v1.ContainerState" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ContainerStateValue) Reset()      { *m = ContainerStateValue{} }
func (*ContainerStateValue) ProtoMessage() {}
func (*ContainerStateValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{74}
}
func (m *ContainerStateValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerStateValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerStateValue.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerStateValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerStateValue.Merge(m, src)
}
func (m *ContainerStateValue) XXX_Size() int {
	return m.Size()
}
func (m *ContainerStateValue) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerStateValue.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerStateValue proto.InternalMessageInfo

func (m *ContainerStateValue) GetState() ContainerState {
	if m != nil {
		return m.State
	}
	return ContainerState_CONTAINER_CREATED
}

// ContainerFilter is used to filter containers.
// All those fields are combined with 'AND'
type ContainerFilter struct {
	// ID of the container.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// State of the container.
	State *ContainerStateValue `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	// ID of the PodSandbox.
	PodSandboxId string `protobuf:"bytes,3,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// LabelSelector to select matches.
	// Only api.MatchLabels is supported for now and the requirements
	// are ANDed. MatchExpressions is not supported yet.
	LabelSelector        map[string]string `protobuf:"bytes,4,rep,name=label_selector,json=labelSelector,proto3" json:"label_selector,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ContainerFilter) Reset()      { *m = ContainerFilter{} }
func (*ContainerFilter) ProtoMessage() {}
func (*ContainerFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{75}
}
func (m *ContainerFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerFilter.Merge(m, src)
}
func (m *ContainerFilter) XXX_Size() int {
	return m.Size()
}
func (m *ContainerFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerFilter.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerFilter proto.InternalMessageInfo

func (m *ContainerFilter) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ContainerFilter) GetState() *ContainerStateValue {
	if m != nil {
		return m.State
	}
	return nil
}

func (m *ContainerFilter) GetPodSandboxId() string {
	if m != nil {
		return m.PodSandboxId
	}
	return ""
}

func (m *ContainerFilter) GetLabelSelector() map[string]string {
	if m != nil {
		return m.LabelSelector
	}
	return nil
}

type ListContainersRequest struct {
	Filter               *ContainerFilter `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ListContainersRequest) Reset()      { *m = ListContainersRequest{} }
func (*ListContainersRequest) ProtoMessage() {}
func (*ListContainersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{76}
}
func (m *ListContainersRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListContainersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListContainersRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListContainersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListContainersRequest.Merge(m, src)
}
func (m *ListContainersRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListContainersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListContainersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListContainersRequest proto.InternalMessageInfo

func (m *ListContainersRequest) GetFilter() *ContainerFilter {
	if m != nil {
		return m.Filter
	}
	return nil
}

// Container provides the runtime information for a container, such as ID, hash,
// state of the container.
type Container struct {
	// ID of the container, used by the container runtime to identify
	// a container.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the sandbox to which this container belongs.
	PodSandboxId string `protobuf:"bytes,2,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// Metadata of the container.
	Metadata *ContainerMetadata `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Spec of the image.
	Image *ImageSpec `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	// Digested reference to the image in use.
	ImageRef string `protobuf:"bytes,5,opt,name=image_ref,json=imageRef,proto3" json:"image_ref,omitempty"`
	// State of the container.
	State ContainerState `protobuf:"varint,6,opt,name=state,proto3,enum=runtime.v1.ContainerState" json:"state,omitempty"`
	// Creation time of the container in nanoseconds.
	CreatedAt int64 `protobuf:"varint,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding ContainerConfig used to
	// instantiate this Container.
	Annotations map[string]string `protobuf:"bytes,9,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Reference to the unique identifier of the image, on the node, as
	// returned in the image service apis.
	//
	// Note: The image_ref above has been historically used by container
	// runtimes to reference images by digest. The image_ref has been also used
	// in the kubelet image garbage collection, which does not work with
	// digests at all. To separate and avoid possible misusage, we now
	// introduce the image_id field, which should always refer to a unique
	// image identifier on the node.
	ImageId              string   `protobuf:"bytes,10,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Container) Reset()      { *m = Container{} }
func (*Container) ProtoMessage() {}
func (*Container) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{77}
}
func (m *Container) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Container) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Container.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Container) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Container.Merge(m, src)
}
func (m *Container) XXX_Size() int {
	return m.Size()
}
func (m *Container) XXX_DiscardUnknown() {
	xxx_messageInfo_Container.DiscardUnknown(m)
}

var xxx_messageInfo_Container proto.InternalMessageInfo

func (m *Container) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Container) GetPodSandboxId() string {
	if m != nil {
		return m.PodSandboxId
	}
	return ""
}

func (m *Container) GetMetadata() *ContainerMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Container) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *Container) GetImageRef() string {
	if m != nil {
		return m.ImageRef
	}
	return ""
}

func (m *Container) GetState() ContainerState {
	if m != nil {
		return m.State
	}
	return ContainerState_CONTAINER_CREATED
}

func (m *Container) GetCreatedAt() int64 {
	if m != nil {
		return m.CreatedAt
	}
	return 0
}

func (m *Container) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Container) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *Container) GetImageId() string {
	if m != nil {
		return m.ImageId
	}
	return ""
}

type ListContainersResponse struct {
	// List of containers.
	Containers           []*Container `protobuf:"bytes,1,rep,name=containers,proto3" json:"containers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ListContainersResponse) Reset()      { *m = ListContainersResponse{} }
func (*ListContainersResponse) ProtoMessage() {}
func (*ListContainersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{78}
}
func (m *ListContainersResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListContainersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListContainersResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListContainersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListContainersResponse.Merge(m, src)
}
func (m *ListContainersResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListContainersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListContainersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListContainersResponse proto.InternalMessageInfo

func (m *ListContainersResponse) GetContainers() []*Container {
	if m != nil {
		return m.Containers
	}
	return nil
}

type ContainerStatusRequest struct {
	// ID of the container for which to retrieve status.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Verbose indicates whether to return extra information about the container.
	Verbose              bool     `protobuf:"varint,2,opt,name=verbose,proto3" json:"verbose,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContainerStatusRequest) Reset()      { *m = ContainerStatusRequest{} }
func (*ContainerStatusRequest) ProtoMessage() {}
func (*ContainerStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{79}
}
func (m *ContainerStatusRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerStatusRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerStatusRequest.Merge(m, src)
}
func (m *ContainerStatusRequest) XXX_Size() int {
	return m.Size()
}
func (m *ContainerStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerStatusRequest proto.InternalMessageInfo

func (m *ContainerStatusRequest) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *ContainerStatusRequest) GetVerbose() bool {
	if m != nil {
		return m.Verbose
	}
	return false
}

// ContainerStatus represents the status of a container.
type ContainerStatus struct {
	// ID of the container.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Metadata of the container.
	Metadata *ContainerMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Status of the container.
	State ContainerState `protobuf:"varint,3,opt,name=state,proto3,enum=runtime.v1.ContainerState" json:"state,omitempty"`
	// Creation time of the container in nanoseconds.
	CreatedAt int64 `protobuf:"varint,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Start time of the container in nanoseconds. Default: 0 (not specified).
	StartedAt int64 `protobuf:"varint,5,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	// Finish time of the container in nanoseconds. Default: 0 (not specified).
	FinishedAt int64 `protobuf:"varint,6,opt,name=finished_at,json=finishedAt,proto3" json:"finished_at,omitempty"`
	// Exit code of the container. Only required when finished_at != 0. Default: 0.
	ExitCode int32 `protobuf:"varint,7,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	// Spec of the image.
	Image *ImageSpec `protobuf:"bytes,8,opt,name=image,proto3" json:"image,omitempty"`
	// Digested reference to the image in use.
	ImageRef string `protobuf:"bytes,9,opt,name=image_ref,json=imageRef,proto3" json:"image_ref,omitempty"`
	// Brief CamelCase string explaining why container is in its current state.
	// Must be set to "OOMKilled" for containers terminated by cgroup-based Out-of-Memory killer.
	Reason string `protobuf:"bytes,10,opt,name=reason,proto3" json:"reason,omitempty"`
	// Human-readable message indicating details about why container is in its
	// current state.
	Message string `protobuf:"bytes,11,opt,name=message,proto3" json:"message,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,12,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding ContainerConfig used to
	// instantiate the Container this status represents.
	Annotations map[string]string `protobuf:"bytes,13,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Mounts for the container.
	Mounts []*Mount `protobuf:"bytes,14,rep,name=mounts,proto3" json:"mounts,omitempty"`
	// Log path of container.
	LogPath string `protobuf:"bytes,15,opt,name=log_path,json=logPath,proto3" json:"log_path,omitempty"`
	// Resource limits configuration of the container.
	Resources *ContainerResources `protobuf:"bytes,16,opt,name=resources,proto3" json:"resources,omitempty"`
	// Reference to the unique identifier of the image, on the node, as
	// returned in the image service apis.
	//
	// Note: The image_ref above has been historically used by container
	// runtimes to reference images by digest. To separate and avoid possible
	// misusage, we now introduce the image_id field, which should always refer
	// to a unique image identifier on the node.
	ImageId string `protobuf:"bytes,17,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	// User identities initially attached to the container
	User                 *ContainerUser `protobuf:"bytes,18,opt,name=user,proto3" json:"user,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ContainerStatus) Reset()      { *m = ContainerStatus{} }
func (*ContainerStatus) ProtoMessage() {}
func (*ContainerStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{80}
}
func (m *ContainerStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerStatus.Merge(m, src)
}
func (m *ContainerStatus) XXX_Size() int {
	return m.Size()
}
func (m *ContainerStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerStatus proto.InternalMessageInfo

func (m *ContainerStatus) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ContainerStatus) GetMetadata() *ContainerMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ContainerStatus) GetState() ContainerState {
	if m != nil {
		return m.State
	}
	return ContainerState_CONTAINER_CREATED
}

func (m *ContainerStatus) GetCreatedAt() int64 {
	if m != nil {
		return m.CreatedAt
	}
	return 0
}

func (m *ContainerStatus) GetStartedAt() int64 {
	if m != nil {
		return m.StartedAt
	}
	return 0
}

func (m *ContainerStatus) GetFinishedAt() int64 {
	if m != nil {
		return m.FinishedAt
	}
	return 0
}

func (m *ContainerStatus) GetExitCode() int32 {
	if m != nil {
		return m.ExitCode
	}
	return 0
}

func (m *ContainerStatus) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *ContainerStatus) GetImageRef() string {
	if m != nil {
		return m.ImageRef
	}
	return ""
}

func (m *ContainerStatus) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *ContainerStatus) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *ContainerStatus) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *ContainerStatus) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *ContainerStatus) GetMounts() []*Mount {
	if m != nil {
		return m.Mounts
	}
	return nil
}

func (m *ContainerStatus) GetLogPath() string {
	if m != nil {
		return m.LogPath
	}
	return ""
}

func (m *ContainerStatus) GetResources() *ContainerResources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ContainerStatus) GetImageId() string {
	if m != nil {
		return m.ImageId
	}
	return ""
}

func (m *ContainerStatus) GetUser() *ContainerUser {
	if m != nil {
		return m.User
	}
	return nil
}

type ContainerStatusResponse struct {
	// Status of the container.
	Status *ContainerStatus `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Info is extra information of the Container. The key could be arbitrary string, and
	// value should be in json format. The information could include anything useful for
	// debug, e.g. pid for linux container based container runtime.
	// It should only be returned non-empty when Verbose is true.
	Info                 map[string]string `protobuf:"bytes,2,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ContainerStatusResponse) Reset()      { *m = ContainerStatusResponse{} }
func (*ContainerStatusResponse) ProtoMessage() {}
func (*ContainerStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{81}
}
func (m *ContainerStatusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerStatusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerStatusResponse.Merge(m, src)
}
func (m *ContainerStatusResponse) XXX_Size() int {
	return m.Size()
}
func (m *ContainerStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerStatusResponse proto.InternalMessageInfo

func (m *ContainerStatusResponse) GetStatus() *ContainerStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *ContainerStatusResponse) GetInfo() map[string]string {
	if m != nil {
		return m.Info
	}
	return nil
}

// ContainerResources holds resource limits configuration for a container.
type ContainerResources struct {
	// Resource limits configuration specific to Linux container.
	Linux *LinuxContainerResources `protobuf:"bytes,1,opt,name=linux,proto3" json:"linux,omitempty"`
	// Resource limits configuration specific to Windows container.
	Windows              *WindowsContainerResources `protobuf:"bytes,2,opt,name=windows,proto3" json:"windows,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *ContainerResources) Reset()      { *m = ContainerResources{} }
func (*ContainerResources) ProtoMessage() {}
func (*ContainerResources) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{82}
}
func (m *ContainerResources) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerResources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerResources.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerResources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerResources.Merge(m, src)
}
func (m *ContainerResources) XXX_Size() int {
	return m.Size()
}
func (m *ContainerResources) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerResources.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerResources proto.InternalMessageInfo

func (m *ContainerResources) GetLinux() *LinuxContainerResources {
	if m != nil {
		return m.Linux
	}
	return nil
}

func (m *ContainerResources) GetWindows() *WindowsContainerResources {
	if m != nil {
		return m.Windows
	}
	return nil
}

type ContainerUser struct {
	// User identities initially attached to first process in the Linux container.
	// Note that the actual running identity can be changed if the process has enough privilege to do so.
	Linux                *LinuxContainerUser `protobuf:"bytes,1,opt,name=linux,proto3" json:"linux,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ContainerUser) Reset()      { *m = ContainerUser{} }
func (*ContainerUser) ProtoMessage() {}
func (*ContainerUser) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{83}
}
func (m *ContainerUser) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerUser) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerUser.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerUser) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerUser.Merge(m, src)
}
func (m *ContainerUser) XXX_Size() int {
	return m.Size()
}
func (m *ContainerUser) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerUser.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerUser proto.InternalMessageInfo

func (m *ContainerUser) GetLinux() *LinuxContainerUser {
	if m != nil {
		return m.Linux
	}
	return nil
}

type UpdateContainerResourcesRequest struct {
	// ID of the container to update.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Resource configuration specific to Linux containers.
	Linux *LinuxContainerResources `protobuf:"bytes,2,opt,name=linux,proto3" json:"linux,omitempty"`
	// Resource configuration specific to Windows containers.
	Windows *WindowsContainerResources `protobuf:"bytes,3,opt,name=windows,proto3" json:"windows,omitempty"`
	// Unstructured key-value map holding arbitrary additional information for
	// container resources updating. This can be used for specifying experimental
	// resources to update or other options to use when updating the container.
	Annotations          map[string]string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateContainerResourcesRequest) Reset()      { *m = UpdateContainerResourcesRequest{} }
func (*UpdateContainerResourcesRequest) ProtoMessage() {}
func (*UpdateContainerResourcesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{84}
}
func (m *UpdateContainerResourcesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateContainerResourcesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateContainerResourcesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateContainerResourcesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateContainerResourcesRequest.Merge(m, src)
}
func (m *UpdateContainerResourcesRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateContainerResourcesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateContainerResourcesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateContainerResourcesRequest proto.InternalMessageInfo

func (m *UpdateContainerResourcesRequest) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *UpdateContainerResourcesRequest) GetLinux() *LinuxContainerResources {
	if m != nil {
		return m.Linux
	}
	return nil
}

func (m *UpdateContainerResourcesRequest) GetWindows() *WindowsContainerResources {
	if m != nil {
		return m.Windows
	}
	return nil
}

func (m *UpdateContainerResourcesRequest) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

type UpdateContainerResourcesResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateContainerResourcesResponse) Reset()      { *m = UpdateContainerResourcesResponse{} }
func (*UpdateContainerResourcesResponse) ProtoMessage() {}
func (*UpdateContainerResourcesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{85}
}
func (m *UpdateContainerResourcesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateContainerResourcesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateContainerResourcesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateContainerResourcesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateContainerResourcesResponse.Merge(m, src)
}
func (m *UpdateContainerResourcesResponse) XXX_Size() int {
	return m.Size()
}
func (m *UpdateContainerResourcesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateContainerResourcesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateContainerResourcesResponse proto.InternalMessageInfo

type ExecSyncRequest struct {
	// ID of the container.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Command to execute.
	Cmd []string `protobuf:"bytes,2,rep,name=cmd,proto3" json:"cmd,omitempty"`
	// Timeout in seconds to stop the command. Default: 0 (run forever).
	Timeout              int64    `protobuf:"varint,3,opt,name=timeout,proto3" json:"timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecSyncRequest) Reset()      { *m = ExecSyncRequest{} }
func (*ExecSyncRequest) ProtoMessage() {}
func (*ExecSyncRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{86}
}
func (m *ExecSyncRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExecSyncRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExecSyncRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExecSyncRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecSyncRequest.Merge(m, src)
}
func (m *ExecSyncRequest) XXX_Size() int {
	return m.Size()
}
func (m *ExecSyncRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecSyncRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExecSyncRequest proto.InternalMessageInfo

func (m *ExecSyncRequest) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *ExecSyncRequest) GetCmd() []string {
	if m != nil {
		return m.Cmd
	}
	return nil
}

func (m *ExecSyncRequest) GetTimeout() int64 {
	if m != nil {
		return m.Timeout
	}
	return 0
}

type ExecSyncResponse struct {
	// Captured command stdout output.
	// The runtime should cap the output of this response to 16MB.
	// If the stdout of the command produces more than 16MB, the remaining output
	// should be discarded, and the command should proceed with no error.
	// See CVE-2022-1708 and CVE-2022-31030 for more information.
	Stdout []byte `protobuf:"bytes,1,opt,name=stdout,proto3" json:"stdout,omitempty"`
	// Captured command stderr output.
	// The runtime should cap the output of this response to 16MB.
	// If the stderr of the command produces more than 16MB, the remaining output
	// should be discarded, and the command should proceed with no error.
	// See CVE-2022-1708 and CVE-2022-31030 for more information.
	Stderr []byte `protobuf:"bytes,2,opt,name=stderr,proto3" json:"stderr,omitempty"`
	// Exit code the command finished with. Default: 0 (success).
	ExitCode             int32    `protobuf:"varint,3,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecSyncResponse) Reset()      { *m = ExecSyncResponse{} }
func (*ExecSyncResponse) ProtoMessage() {}
func (*ExecSyncResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{87}
}
func (m *ExecSyncResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExecSyncResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExecSyncResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExecSyncResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecSyncResponse.Merge(m, src)
}
func (m *ExecSyncResponse) XXX_Size() int {
	return m.Size()
}
func (m *ExecSyncResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecSyncResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExecSyncResponse proto.InternalMessageInfo

func (m *ExecSyncResponse) GetStdout() []byte {
	if m != nil {
		return m.Stdout
	}
	return nil
}

func (m *ExecSyncResponse) GetStderr() []byte {
	if m != nil {
		return m.Stderr
	}
	return nil
}

func (m *ExecSyncResponse) GetExitCode() int32 {
	if m != nil {
		return m.ExitCode
	}
	return 0
}

type ExecRequest struct {
	// ID of the container in which to execute the command.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Command to execute.
	Cmd []string `protobuf:"bytes,2,rep,name=cmd,proto3" json:"cmd,omitempty"`
	// Whether to exec the command in a TTY.
	Tty bool `protobuf:"varint,3,opt,name=tty,proto3" json:"tty,omitempty"`
	// Whether to stream stdin.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	Stdin bool `protobuf:"varint,4,opt,name=stdin,proto3" json:"stdin,omitempty"`
	// Whether to stream stdout.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	Stdout bool `protobuf:"varint,5,opt,name=stdout,proto3" json:"stdout,omitempty"`
	// Whether to stream stderr.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	// If `tty` is true, `stderr` MUST be false. Multiplexing is not supported
	// in this case. The output of stdout and stderr will be combined to a
	// single stream.
	Stderr               bool     `protobuf:"varint,6,opt,name=stderr,proto3" json:"stderr,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecRequest) Reset()      { *m = ExecRequest{} }
func (*ExecRequest) ProtoMessage() {}
func (*ExecRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{88}
}
func (m *ExecRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExecRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExecRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExecRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecRequest.Merge(m, src)
}
func (m *ExecRequest) XXX_Size() int {
	return m.Size()
}
func (m *ExecRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExecRequest proto.InternalMessageInfo

func (m *ExecRequest) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *ExecRequest) GetCmd() []string {
	if m != nil {
		return m.Cmd
	}
	return nil
}

func (m *ExecRequest) GetTty() bool {
	if m != nil {
		return m.Tty
	}
	return false
}

func (m *ExecRequest) GetStdin() bool {
	if m != nil {
		return m.Stdin
	}
	return false
}

func (m *ExecRequest) GetStdout() bool {
	if m != nil {
		return m.Stdout
	}
	return false
}

func (m *ExecRequest) GetStderr() bool {
	if m != nil {
		return m.Stderr
	}
	return false
}

type ExecResponse struct {
	// Fully qualified URL of the exec streaming server.
	Url                  string   `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecResponse) Reset()      { *m = ExecResponse{} }
func (*ExecResponse) ProtoMessage() {}
func (*ExecResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{89}
}
func (m *ExecResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExecResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExecResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExecResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecResponse.Merge(m, src)
}
func (m *ExecResponse) XXX_Size() int {
	return m.Size()
}
func (m *ExecResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExecResponse proto.InternalMessageInfo

func (m *ExecResponse) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

type AttachRequest struct {
	// ID of the container to which to attach.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Whether to stream stdin.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	Stdin bool `protobuf:"varint,2,opt,name=stdin,proto3" json:"stdin,omitempty"`
	// Whether the process being attached is running in a TTY.
	// This must match the TTY setting in the ContainerConfig.
	Tty bool `protobuf:"varint,3,opt,name=tty,proto3" json:"tty,omitempty"`
	// Whether to stream stdout.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	Stdout bool `protobuf:"varint,4,opt,name=stdout,proto3" json:"stdout,omitempty"`
	// Whether to stream stderr.
	// One of `stdin`, `stdout`, and `stderr` MUST be true.
	// If `tty` is true, `stderr` MUST be false. Multiplexing is not supported
	// in this case. The output of stdout and stderr will be combined to a
	// single stream.
	Stderr               bool     `protobuf:"varint,5,opt,name=stderr,proto3" json:"stderr,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttachRequest) Reset()      { *m = AttachRequest{} }
func (*AttachRequest) ProtoMessage() {}
func (*AttachRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{90}
}
func (m *AttachRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AttachRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AttachRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AttachRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachRequest.Merge(m, src)
}
func (m *AttachRequest) XXX_Size() int {
	return m.Size()
}
func (m *AttachRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AttachRequest proto.InternalMessageInfo

func (m *AttachRequest) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *AttachRequest) GetStdin() bool {
	if m != nil {
		return m.Stdin
	}
	return false
}

func (m *AttachRequest) GetTty() bool {
	if m != nil {
		return m.Tty
	}
	return false
}

func (m *AttachRequest) GetStdout() bool {
	if m != nil {
		return m.Stdout
	}
	return false
}

func (m *AttachRequest) GetStderr() bool {
	if m != nil {
		return m.Stderr
	}
	return false
}

type AttachResponse struct {
	// Fully qualified URL of the attach streaming server.
	Url                  string   `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttachResponse) Reset()      { *m = AttachResponse{} }
func (*AttachResponse) ProtoMessage() {}
func (*AttachResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{91}
}
func (m *AttachResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AttachResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AttachResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AttachResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachResponse.Merge(m, src)
}
func (m *AttachResponse) XXX_Size() int {
	return m.Size()
}
func (m *AttachResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AttachResponse proto.InternalMessageInfo

func (m *AttachResponse) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

type PortForwardRequest struct {
	// ID of the container to which to forward the port.
	PodSandboxId string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// Port to forward.
	Port                 []int32  `protobuf:"varint,2,rep,packed,name=port,proto3" json:"port,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PortForwardRequest) Reset()      { *m = PortForwardRequest{} }
func (*PortForwardRequest) ProtoMessage() {}
func (*PortForwardRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{92}
}
func (m *PortForwardRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PortForwardRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PortForwardRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PortForwardRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PortForwardRequest.Merge(m, src)
}
func (m *PortForwardRequest) XXX_Size() int {
	return m.Size()
}
func (m *PortForwardRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PortForwardRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PortForwardRequest proto.InternalMessageInfo

func (m *PortForwardRequest) GetPodSandboxId() string {
	if m != nil {
		return m.PodSandboxId
	}
	return ""
}

func (m *PortForwardRequest) GetPort() []int32 {
	if m != nil {
		return m.Port
	}
	return nil
}

type PortForwardResponse struct {
	// Fully qualified URL of the port-forward streaming server.
	Url                  string   `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PortForwardResponse) Reset()      { *m = PortForwardResponse{} }
func (*PortForwardResponse) ProtoMessage() {}
func (*PortForwardResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{93}
}
func (m *PortForwardResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PortForwardResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PortForwardResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PortForwardResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PortForwardResponse.Merge(m, src)
}
func (m *PortForwardResponse) XXX_Size() int {
	return m.Size()
}
func (m *PortForwardResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PortForwardResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PortForwardResponse proto.InternalMessageInfo

func (m *PortForwardResponse) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

type ImageFilter struct {
	// Spec of the image.
	Image                *ImageSpec `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ImageFilter) Reset()      { *m = ImageFilter{} }
func (*ImageFilter) ProtoMessage() {}
func (*ImageFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{94}
}
func (m *ImageFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImageFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImageFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImageFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageFilter.Merge(m, src)
}
func (m *ImageFilter) XXX_Size() int {
	return m.Size()
}
func (m *ImageFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageFilter.DiscardUnknown(m)
}

var xxx_messageInfo_ImageFilter proto.InternalMessageInfo

func (m *ImageFilter) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

type ListImagesRequest struct {
	// Filter to list images.
	Filter               *ImageFilter `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ListImagesRequest) Reset()      { *m = ListImagesRequest{} }
func (*ListImagesRequest) ProtoMessage() {}
func (*ListImagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{95}
}
func (m *ListImagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListImagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListImagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListImagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListImagesRequest.Merge(m, src)
}
func (m *ListImagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListImagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListImagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListImagesRequest proto.InternalMessageInfo

func (m *ListImagesRequest) GetFilter() *ImageFilter {
	if m != nil {
		return m.Filter
	}
	return nil
}

// Basic information about a container image.
type Image struct {
	// ID of the image.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Other names by which this image is known.
	RepoTags []string `protobuf:"bytes,2,rep,name=repo_tags,json=repoTags,proto3" json:"repo_tags,omitempty"`
	// Digests by which this image is known.
	RepoDigests []string `protobuf:"bytes,3,rep,name=repo_digests,json=repoDigests,proto3" json:"repo_digests,omitempty"`
	// Size of the image in bytes. Must be > 0.
	Size_ uint64 `protobuf:"varint,4,opt,name=size,proto3" json:"size,omitempty"`
	// UID that will run the command(s). This is used as a default if no user is
	// specified when creating the container. UID and the following user name
	// are mutually exclusive.
	Uid *Int64Value `protobuf:"bytes,5,opt,name=uid,proto3" json:"uid,omitempty"`
	// User name that will run the command(s). This is used if UID is not set
	// and no user is specified when creating container.
	Username string `protobuf:"bytes,6,opt,name=username,proto3" json:"username,omitempty"`
	// ImageSpec for image which includes annotations
	Spec *ImageSpec `protobuf:"bytes,7,opt,name=spec,proto3" json:"spec,omitempty"`
	// Recommendation on whether this image should be exempt from garbage collection.
	// It must only be treated as a recommendation -- the client can still request that the image be deleted,
	// and the runtime must oblige.
	Pinned               bool     `protobuf:"varint,8,opt,name=pinned,proto3" json:"pinned,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Image) Reset()      { *m = Image{} }
func (*Image) ProtoMessage() {}
func (*Image) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{96}
}
func (m *Image) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Image) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Image.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Image) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Image.Merge(m, src)
}
func (m *Image) XXX_Size() int {
	return m.Size()
}
func (m *Image) XXX_DiscardUnknown() {
	xxx_messageInfo_Image.DiscardUnknown(m)
}

var xxx_messageInfo_Image proto.InternalMessageInfo

func (m *Image) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Image) GetRepoTags() []string {
	if m != nil {
		return m.RepoTags
	}
	return nil
}

func (m *Image) GetRepoDigests() []string {
	if m != nil {
		return m.RepoDigests
	}
	return nil
}

func (m *Image) GetSize_() uint64 {
	if m != nil {
		return m.Size_
	}
	return 0
}

func (m *Image) GetUid() *Int64Value {
	if m != nil {
		return m.Uid
	}
	return nil
}

func (m *Image) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *Image) GetSpec() *ImageSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Image) GetPinned() bool {
	if m != nil {
		return m.Pinned
	}
	return false
}

type ListImagesResponse struct {
	// List of images.
	Images               []*Image `protobuf:"bytes,1,rep,name=images,proto3" json:"images,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListImagesResponse) Reset()      { *m = ListImagesResponse{} }
func (*ListImagesResponse) ProtoMessage() {}
func (*ListImagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{97}
}
func (m *ListImagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListImagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListImagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListImagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListImagesResponse.Merge(m, src)
}
func (m *ListImagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListImagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListImagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListImagesResponse proto.InternalMessageInfo

func (m *ListImagesResponse) GetImages() []*Image {
	if m != nil {
		return m.Images
	}
	return nil
}

type ImageStatusRequest struct {
	// Spec of the image.
	Image *ImageSpec `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Verbose indicates whether to return extra information about the image.
	Verbose              bool     `protobuf:"varint,2,opt,name=verbose,proto3" json:"verbose,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImageStatusRequest) Reset()      { *m = ImageStatusRequest{} }
func (*ImageStatusRequest) ProtoMessage() {}
func (*ImageStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{98}
}
func (m *ImageStatusRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImageStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImageStatusRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImageStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageStatusRequest.Merge(m, src)
}
func (m *ImageStatusRequest) XXX_Size() int {
	return m.Size()
}
func (m *ImageStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImageStatusRequest proto.InternalMessageInfo

func (m *ImageStatusRequest) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *ImageStatusRequest) GetVerbose() bool {
	if m != nil {
		return m.Verbose
	}
	return false
}

type ImageStatusResponse struct {
	// Status of the image.
	Image *Image `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Info is extra information of the Image. The key could be arbitrary string, and
	// value should be in json format. The information could include anything useful
	// for debug, e.g. image config for oci image based container runtime.
	// It should only be returned non-empty when Verbose is true.
	Info                 map[string]string `protobuf:"bytes,2,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ImageStatusResponse) Reset()      { *m = ImageStatusResponse{} }
func (*ImageStatusResponse) ProtoMessage() {}
func (*ImageStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{99}
}
func (m *ImageStatusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImageStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImageStatusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImageStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageStatusResponse.Merge(m, src)
}
func (m *ImageStatusResponse) XXX_Size() int {
	return m.Size()
}
func (m *ImageStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ImageStatusResponse proto.InternalMessageInfo

func (m *ImageStatusResponse) GetImage() *Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *ImageStatusResponse) GetInfo() map[string]string {
	if m != nil {
		return m.Info
	}
	return nil
}

// AuthConfig contains authorization information for connecting to a registry.
type AuthConfig struct {
	Username      string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	Password      string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	Auth          string `protobuf:"bytes,3,opt,name=auth,proto3" json:"auth,omitempty"`
	ServerAddress string `protobuf:"bytes,4,opt,name=server_address,json=serverAddress,proto3" json:"server_address,omitempty"`
	// IdentityToken is used to authenticate the user and get
	// an access token for the registry.
	IdentityToken string `protobuf:"bytes,5,opt,name=identity_token,json=identityToken,proto3" json:"identity_token,omitempty"`
	// RegistryToken is a bearer token to be sent to a registry
	RegistryToken        string   `protobuf:"bytes,6,opt,name=registry_token,json=registryToken,proto3" json:"registry_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuthConfig) Reset()      { *m = AuthConfig{} }
func (*AuthConfig) ProtoMessage() {}
func (*AuthConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{100}
}
func (m *AuthConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuthConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuthConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuthConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuthConfig.Merge(m, src)
}
func (m *AuthConfig) XXX_Size() int {
	return m.Size()
}
func (m *AuthConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_AuthConfig.DiscardUnknown(m)
}

var xxx_messageInfo_AuthConfig proto.InternalMessageInfo

func (m *AuthConfig) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *AuthConfig) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *AuthConfig) GetAuth() string {
	if m != nil {
		return m.Auth
	}
	return ""
}

func (m *AuthConfig) GetServerAddress() string {
	if m != nil {
		return m.ServerAddress
	}
	return ""
}

func (m *AuthConfig) GetIdentityToken() string {
	if m != nil {
		return m.IdentityToken
	}
	return ""
}

func (m *AuthConfig) GetRegistryToken() string {
	if m != nil {
		return m.RegistryToken
	}
	return ""
}

type PullImageRequest struct {
	// Spec of the image.
	Image *ImageSpec `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Authentication configuration for pulling the image.
	Auth *AuthConfig `protobuf:"bytes,2,opt,name=auth,proto3" json:"auth,omitempty"`
	// Config of the PodSandbox, which is used to pull image in PodSandbox context.
	SandboxConfig        *PodSandboxConfig `protobuf:"bytes,3,opt,name=sandbox_config,json=sandboxConfig,proto3" json:"sandbox_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PullImageRequest) Reset()      { *m = PullImageRequest{} }
func (*PullImageRequest) ProtoMessage() {}
func (*PullImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{101}
}
func (m *PullImageRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PullImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PullImageRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PullImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PullImageRequest.Merge(m, src)
}
func (m *PullImageRequest) XXX_Size() int {
	return m.Size()
}
func (m *PullImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PullImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PullImageRequest proto.InternalMessageInfo

func (m *PullImageRequest) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *PullImageRequest) GetAuth() *AuthConfig {
	if m != nil {
		return m.Auth
	}
	return nil
}

func (m *PullImageRequest) GetSandboxConfig() *PodSandboxConfig {
	if m != nil {
		return m.SandboxConfig
	}
	return nil
}

type PullImageResponse struct {
	// Reference to the image in use. For most runtimes, this should be an
	// image ID or digest.
	ImageRef             string   `protobuf:"bytes,1,opt,name=image_ref,json=imageRef,proto3" json:"image_ref,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PullImageResponse) Reset()      { *m = PullImageResponse{} }
func (*PullImageResponse) ProtoMessage() {}
func (*PullImageResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{102}
}
func (m *PullImageResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PullImageResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PullImageResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PullImageResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PullImageResponse.Merge(m, src)
}
func (m *PullImageResponse) XXX_Size() int {
	return m.Size()
}
func (m *PullImageResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PullImageResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PullImageResponse proto.InternalMessageInfo

func (m *PullImageResponse) GetImageRef() string {
	if m != nil {
		return m.ImageRef
	}
	return ""
}

type RemoveImageRequest struct {
	// Spec of the image to remove.
	Image                *ImageSpec `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *RemoveImageRequest) Reset()      { *m = RemoveImageRequest{} }
func (*RemoveImageRequest) ProtoMessage() {}
func (*RemoveImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{103}
}
func (m *RemoveImageRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveImageRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveImageRequest.Merge(m, src)
}
func (m *RemoveImageRequest) XXX_Size() int {
	return m.Size()
}
func (m *RemoveImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveImageRequest proto.InternalMessageInfo

func (m *RemoveImageRequest) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

type RemoveImageResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveImageResponse) Reset()      { *m = RemoveImageResponse{} }
func (*RemoveImageResponse) ProtoMessage() {}
func (*RemoveImageResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{104}
}
func (m *RemoveImageResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveImageResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveImageResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveImageResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveImageResponse.Merge(m, src)
}
func (m *RemoveImageResponse) XXX_Size() int {
	return m.Size()
}
func (m *RemoveImageResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveImageResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveImageResponse proto.InternalMessageInfo

type NetworkConfig struct {
	// CIDR to use for pod IP addresses. If the CIDR is empty, runtimes
	// should omit it.
	PodCidr              string   `protobuf:"bytes,1,opt,name=pod_cidr,json=podCidr,proto3" json:"pod_cidr,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkConfig) Reset()      { *m = NetworkConfig{} }
func (*NetworkConfig) ProtoMessage() {}
func (*NetworkConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{105}
}
func (m *NetworkConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkConfig.Merge(m, src)
}
func (m *NetworkConfig) XXX_Size() int {
	return m.Size()
}
func (m *NetworkConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkConfig.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkConfig proto.InternalMessageInfo

func (m *NetworkConfig) GetPodCidr() string {
	if m != nil {
		return m.PodCidr
	}
	return ""
}

type RuntimeConfig struct {
	NetworkConfig        *NetworkConfig `protobuf:"bytes,1,opt,name=network_config,json=networkConfig,proto3" json:"network_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RuntimeConfig) Reset()      { *m = RuntimeConfig{} }
func (*RuntimeConfig) ProtoMessage() {}
func (*RuntimeConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{106}
}
func (m *RuntimeConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RuntimeConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RuntimeConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RuntimeConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeConfig.Merge(m, src)
}
func (m *RuntimeConfig) XXX_Size() int {
	return m.Size()
}
func (m *RuntimeConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeConfig.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeConfig proto.InternalMessageInfo

func (m *RuntimeConfig) GetNetworkConfig() *NetworkConfig {
	if m != nil {
		return m.NetworkConfig
	}
	return nil
}

type UpdateRuntimeConfigRequest struct {
	RuntimeConfig        *RuntimeConfig `protobuf:"bytes,1,opt,name=runtime_config,json=runtimeConfig,proto3" json:"runtime_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *UpdateRuntimeConfigRequest) Reset()      { *m = UpdateRuntimeConfigRequest{} }
func (*UpdateRuntimeConfigRequest) ProtoMessage() {}
func (*UpdateRuntimeConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{107}
}
func (m *UpdateRuntimeConfigRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateRuntimeConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateRuntimeConfigRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateRuntimeConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateRuntimeConfigRequest.Merge(m, src)
}
func (m *UpdateRuntimeConfigRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateRuntimeConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateRuntimeConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateRuntimeConfigRequest proto.InternalMessageInfo

func (m *UpdateRuntimeConfigRequest) GetRuntimeConfig() *RuntimeConfig {
	if m != nil {
		return m.RuntimeConfig
	}
	return nil
}

type UpdateRuntimeConfigResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateRuntimeConfigResponse) Reset()      { *m = UpdateRuntimeConfigResponse{} }
func (*UpdateRuntimeConfigResponse) ProtoMessage() {}
func (*UpdateRuntimeConfigResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{108}
}
func (m *UpdateRuntimeConfigResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateRuntimeConfigResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateRuntimeConfigResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateRuntimeConfigResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateRuntimeConfigResponse.Merge(m, src)
}
func (m *UpdateRuntimeConfigResponse) XXX_Size() int {
	return m.Size()
}
func (m *UpdateRuntimeConfigResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateRuntimeConfigResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateRuntimeConfigResponse proto.InternalMessageInfo

// RuntimeCondition contains condition information for the runtime.
// There are 2 kinds of runtime conditions:
// 1. Required conditions: Conditions are required for kubelet to work
// properly. If any required condition is unmet, the node will be not ready.
// The required conditions include:
//   - RuntimeReady: RuntimeReady means the runtime is up and ready to accept
//     basic containers e.g. container only needs host network.
//   - NetworkReady: NetworkReady means the runtime network is up and ready to
//     accept containers which require container network.
//
// 2. Optional conditions: Conditions are informative to the user, but kubelet
// will not rely on. Since condition type is an arbitrary string, all conditions
// not required are optional. These conditions will be exposed to users to help
// them understand the status of the system.
type RuntimeCondition struct {
	// Type of runtime condition.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Status of the condition, one of true/false. Default: false.
	Status bool `protobuf:"varint,2,opt,name=status,proto3" json:"status,omitempty"`
	// Brief CamelCase string containing reason for the condition's last transition.
	Reason string `protobuf:"bytes,3,opt,name=reason,proto3" json:"reason,omitempty"`
	// Human-readable message indicating details about last transition.
	Message              string   `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RuntimeCondition) Reset()      { *m = RuntimeCondition{} }
func (*RuntimeCondition) ProtoMessage() {}
func (*RuntimeCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{109}
}
func (m *RuntimeCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RuntimeCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RuntimeCondition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RuntimeCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeCondition.Merge(m, src)
}
func (m *RuntimeCondition) XXX_Size() int {
	return m.Size()
}
func (m *RuntimeCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeCondition.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeCondition proto.InternalMessageInfo

func (m *RuntimeCondition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *RuntimeCondition) GetStatus() bool {
	if m != nil {
		return m.Status
	}
	return false
}

func (m *RuntimeCondition) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *RuntimeCondition) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// RuntimeStatus is information about the current status of the runtime.
type RuntimeStatus struct {
	// List of current observed runtime conditions.
	Conditions           []*RuntimeCondition `protobuf:"bytes,1,rep,name=conditions,proto3" json:"conditions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *RuntimeStatus) Reset()      { *m = RuntimeStatus{} }
func (*RuntimeStatus) ProtoMessage() {}
func (*RuntimeStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{110}
}
func (m *RuntimeStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RuntimeStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RuntimeStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RuntimeStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeStatus.Merge(m, src)
}
func (m *RuntimeStatus) XXX_Size() int {
	return m.Size()
}
func (m *RuntimeStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeStatus.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeStatus proto.InternalMessageInfo

func (m *RuntimeStatus) GetConditions() []*RuntimeCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

type StatusRequest struct {
	// Verbose indicates whether to return extra information about the runtime.
	Verbose              bool     `protobuf:"varint,1,opt,name=verbose,proto3" json:"verbose,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StatusRequest) Reset()      { *m = StatusRequest{} }
func (*StatusRequest) ProtoMessage() {}
func (*StatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{111}
}
func (m *StatusRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StatusRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatusRequest.Merge(m, src)
}
func (m *StatusRequest) XXX_Size() int {
	return m.Size()
}
func (m *StatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StatusRequest proto.InternalMessageInfo

func (m *StatusRequest) GetVerbose() bool {
	if m != nil {
		return m.Verbose
	}
	return false
}

type RuntimeHandlerFeatures struct {
	// recursive_read_only_mounts is set to true if the runtime handler supports
	// recursive read-only mounts.
	// For runc-compatible runtimes, availability of this feature can be detected by checking whether
	// the Linux kernel version is >= 5.12, and,  `runc features | jq .mountOptions` contains "rro".
	RecursiveReadOnlyMounts bool `protobuf:"varint,1,opt,name=recursive_read_only_mounts,json=recursiveReadOnlyMounts,proto3" json:"recursive_read_only_mounts,omitempty"`
	// user_namespaces is set to true if the runtime handler supports user namespaces as implemented
	// in Kubernetes. This means support for both, user namespaces and idmap mounts.
	UserNamespaces       bool     `protobuf:"varint,2,opt,name=user_namespaces,json=userNamespaces,proto3" json:"user_namespaces,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RuntimeHandlerFeatures) Reset()      { *m = RuntimeHandlerFeatures{} }
func (*RuntimeHandlerFeatures) ProtoMessage() {}
func (*RuntimeHandlerFeatures) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{112}
}
func (m *RuntimeHandlerFeatures) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RuntimeHandlerFeatures) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RuntimeHandlerFeatures.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RuntimeHandlerFeatures) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeHandlerFeatures.Merge(m, src)
}
func (m *RuntimeHandlerFeatures) XXX_Size() int {
	return m.Size()
}
func (m *RuntimeHandlerFeatures) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeHandlerFeatures.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeHandlerFeatures proto.InternalMessageInfo

func (m *RuntimeHandlerFeatures) GetRecursiveReadOnlyMounts() bool {
	if m != nil {
		return m.RecursiveReadOnlyMounts
	}
	return false
}

func (m *RuntimeHandlerFeatures) GetUserNamespaces() bool {
	if m != nil {
		return m.UserNamespaces
	}
	return false
}

type RuntimeHandler struct {
	// Name must be unique in StatusResponse.
	// An empty string denotes the default handler.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Supported features.
	Features             *RuntimeHandlerFeatures `protobuf:"bytes,2,opt,name=features,proto3" json:"features,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *RuntimeHandler) Reset()      { *m = RuntimeHandler{} }
func (*RuntimeHandler) ProtoMessage() {}
func (*RuntimeHandler) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{113}
}
func (m *RuntimeHandler) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RuntimeHandler) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RuntimeHandler.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RuntimeHandler) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeHandler.Merge(m, src)
}
func (m *RuntimeHandler) XXX_Size() int {
	return m.Size()
}
func (m *RuntimeHandler) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeHandler.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeHandler proto.InternalMessageInfo

func (m *RuntimeHandler) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RuntimeHandler) GetFeatures() *RuntimeHandlerFeatures {
	if m != nil {
		return m.Features
	}
	return nil
}

type StatusResponse struct {
	// Status of the Runtime.
	Status *RuntimeStatus `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Info is extra information of the Runtime. The key could be arbitrary string, and
	// value should be in json format. The information could include anything useful for
	// debug, e.g. plugins used by the container runtime.
	// It should only be returned non-empty when Verbose is true.
	Info map[string]string `protobuf:"bytes,2,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Runtime handlers.
	RuntimeHandlers      []*RuntimeHandler `protobuf:"bytes,3,rep,name=runtime_handlers,json=runtimeHandlers,proto3" json:"runtime_handlers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *StatusResponse) Reset()      { *m = StatusResponse{} }
func (*StatusResponse) ProtoMessage() {}
func (*StatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{114}
}
func (m *StatusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StatusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatusResponse.Merge(m, src)
}
func (m *StatusResponse) XXX_Size() int {
	return m.Size()
}
func (m *StatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StatusResponse proto.InternalMessageInfo

func (m *StatusResponse) GetStatus() *RuntimeStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *StatusResponse) GetInfo() map[string]string {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *StatusResponse) GetRuntimeHandlers() []*RuntimeHandler {
	if m != nil {
		return m.RuntimeHandlers
	}
	return nil
}

type ImageFsInfoRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImageFsInfoRequest) Reset()      { *m = ImageFsInfoRequest{} }
func (*ImageFsInfoRequest) ProtoMessage() {}
func (*ImageFsInfoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{115}
}
func (m *ImageFsInfoRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImageFsInfoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImageFsInfoRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImageFsInfoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageFsInfoRequest.Merge(m, src)
}
func (m *ImageFsInfoRequest) XXX_Size() int {
	return m.Size()
}
func (m *ImageFsInfoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageFsInfoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImageFsInfoRequest proto.InternalMessageInfo

// UInt64Value is the wrapper of uint64.
type UInt64Value struct {
	// The value.
	Value                uint64   `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UInt64Value) Reset()      { *m = UInt64Value{} }
func (*UInt64Value) ProtoMessage() {}
func (*UInt64Value) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{116}
}
func (m *UInt64Value) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UInt64Value) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UInt64Value.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UInt64Value) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UInt64Value.Merge(m, src)
}
func (m *UInt64Value) XXX_Size() int {
	return m.Size()
}
func (m *UInt64Value) XXX_DiscardUnknown() {
	xxx_messageInfo_UInt64Value.DiscardUnknown(m)
}

var xxx_messageInfo_UInt64Value proto.InternalMessageInfo

func (m *UInt64Value) GetValue() uint64 {
	if m != nil {
		return m.Value
	}
	return 0
}

// FilesystemIdentifier uniquely identify the filesystem.
type FilesystemIdentifier struct {
	// Mountpoint of a filesystem.
	Mountpoint           string   `protobuf:"bytes,1,opt,name=mountpoint,proto3" json:"mountpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FilesystemIdentifier) Reset()      { *m = FilesystemIdentifier{} }
func (*FilesystemIdentifier) ProtoMessage() {}
func (*FilesystemIdentifier) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{117}
}
func (m *FilesystemIdentifier) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FilesystemIdentifier) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FilesystemIdentifier.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FilesystemIdentifier) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FilesystemIdentifier.Merge(m, src)
}
func (m *FilesystemIdentifier) XXX_Size() int {
	return m.Size()
}
func (m *FilesystemIdentifier) XXX_DiscardUnknown() {
	xxx_messageInfo_FilesystemIdentifier.DiscardUnknown(m)
}

var xxx_messageInfo_FilesystemIdentifier proto.InternalMessageInfo

func (m *FilesystemIdentifier) GetMountpoint() string {
	if m != nil {
		return m.Mountpoint
	}
	return ""
}

// FilesystemUsage provides the filesystem usage information.
type FilesystemUsage struct {
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The unique identifier of the filesystem.
	FsId *FilesystemIdentifier `protobuf:"bytes,2,opt,name=fs_id,json=fsId,proto3" json:"fs_id,omitempty"`
	// UsedBytes represents the bytes used for images on the filesystem.
	// This may differ from the total bytes used on the filesystem and may not
	// equal CapacityBytes - AvailableBytes.
	UsedBytes *UInt64Value `protobuf:"bytes,3,opt,name=used_bytes,json=usedBytes,proto3" json:"used_bytes,omitempty"`
	// InodesUsed represents the inodes used by the images.
	// This may not equal InodesCapacity - InodesAvailable because the underlying
	// filesystem may also be used for purposes other than storing images.
	InodesUsed           *UInt64Value `protobuf:"bytes,4,opt,name=inodes_used,json=inodesUsed,proto3" json:"inodes_used,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *FilesystemUsage) Reset()      { *m = FilesystemUsage{} }
func (*FilesystemUsage) ProtoMessage() {}
func (*FilesystemUsage) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{118}
}
func (m *FilesystemUsage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FilesystemUsage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FilesystemUsage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FilesystemUsage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FilesystemUsage.Merge(m, src)
}
func (m *FilesystemUsage) XXX_Size() int {
	return m.Size()
}
func (m *FilesystemUsage) XXX_DiscardUnknown() {
	xxx_messageInfo_FilesystemUsage.DiscardUnknown(m)
}

var xxx_messageInfo_FilesystemUsage proto.InternalMessageInfo

func (m *FilesystemUsage) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *FilesystemUsage) GetFsId() *FilesystemIdentifier {
	if m != nil {
		return m.FsId
	}
	return nil
}

func (m *FilesystemUsage) GetUsedBytes() *UInt64Value {
	if m != nil {
		return m.UsedBytes
	}
	return nil
}

func (m *FilesystemUsage) GetInodesUsed() *UInt64Value {
	if m != nil {
		return m.InodesUsed
	}
	return nil
}

// WindowsFilesystemUsage provides the filesystem usage information specific to Windows.
type WindowsFilesystemUsage struct {
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The unique identifier of the filesystem.
	FsId *FilesystemIdentifier `protobuf:"bytes,2,opt,name=fs_id,json=fsId,proto3" json:"fs_id,omitempty"`
	// UsedBytes represents the bytes used for images on the filesystem.
	// This may differ from the total bytes used on the filesystem and may not
	// equal CapacityBytes - AvailableBytes.
	UsedBytes            *UInt64Value `protobuf:"bytes,3,opt,name=used_bytes,json=usedBytes,proto3" json:"used_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *WindowsFilesystemUsage) Reset()      { *m = WindowsFilesystemUsage{} }
func (*WindowsFilesystemUsage) ProtoMessage() {}
func (*WindowsFilesystemUsage) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{119}
}
func (m *WindowsFilesystemUsage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsFilesystemUsage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsFilesystemUsage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsFilesystemUsage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsFilesystemUsage.Merge(m, src)
}
func (m *WindowsFilesystemUsage) XXX_Size() int {
	return m.Size()
}
func (m *WindowsFilesystemUsage) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsFilesystemUsage.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsFilesystemUsage proto.InternalMessageInfo

func (m *WindowsFilesystemUsage) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *WindowsFilesystemUsage) GetFsId() *FilesystemIdentifier {
	if m != nil {
		return m.FsId
	}
	return nil
}

func (m *WindowsFilesystemUsage) GetUsedBytes() *UInt64Value {
	if m != nil {
		return m.UsedBytes
	}
	return nil
}

type ImageFsInfoResponse struct {
	// Information of image filesystem(s).
	ImageFilesystems []*FilesystemUsage `protobuf:"bytes,1,rep,name=image_filesystems,json=imageFilesystems,proto3" json:"image_filesystems,omitempty"`
	// Information of container filesystem(s).
	// This is an optional field, may be used for example if container and image
	// storage are separated.
	// Default will be to return this as empty.
	ContainerFilesystems []*FilesystemUsage `protobuf:"bytes,2,rep,name=container_filesystems,json=containerFilesystems,proto3" json:"container_filesystems,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ImageFsInfoResponse) Reset()      { *m = ImageFsInfoResponse{} }
func (*ImageFsInfoResponse) ProtoMessage() {}
func (*ImageFsInfoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{120}
}
func (m *ImageFsInfoResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImageFsInfoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImageFsInfoResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImageFsInfoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageFsInfoResponse.Merge(m, src)
}
func (m *ImageFsInfoResponse) XXX_Size() int {
	return m.Size()
}
func (m *ImageFsInfoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageFsInfoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ImageFsInfoResponse proto.InternalMessageInfo

func (m *ImageFsInfoResponse) GetImageFilesystems() []*FilesystemUsage {
	if m != nil {
		return m.ImageFilesystems
	}
	return nil
}

func (m *ImageFsInfoResponse) GetContainerFilesystems() []*FilesystemUsage {
	if m != nil {
		return m.ContainerFilesystems
	}
	return nil
}

type ContainerStatsRequest struct {
	// ID of the container for which to retrieve stats.
	ContainerId          string   `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContainerStatsRequest) Reset()      { *m = ContainerStatsRequest{} }
func (*ContainerStatsRequest) ProtoMessage() {}
func (*ContainerStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{121}
}
func (m *ContainerStatsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerStatsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerStatsRequest.Merge(m, src)
}
func (m *ContainerStatsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ContainerStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerStatsRequest proto.InternalMessageInfo

func (m *ContainerStatsRequest) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

type ContainerStatsResponse struct {
	// Stats of the container.
	Stats                *ContainerStats `protobuf:"bytes,1,opt,name=stats,proto3" json:"stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ContainerStatsResponse) Reset()      { *m = ContainerStatsResponse{} }
func (*ContainerStatsResponse) ProtoMessage() {}
func (*ContainerStatsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{122}
}
func (m *ContainerStatsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerStatsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerStatsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerStatsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerStatsResponse.Merge(m, src)
}
func (m *ContainerStatsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ContainerStatsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerStatsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerStatsResponse proto.InternalMessageInfo

func (m *ContainerStatsResponse) GetStats() *ContainerStats {
	if m != nil {
		return m.Stats
	}
	return nil
}

type ListContainerStatsRequest struct {
	// Filter for the list request.
	Filter               *ContainerStatsFilter `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ListContainerStatsRequest) Reset()      { *m = ListContainerStatsRequest{} }
func (*ListContainerStatsRequest) ProtoMessage() {}
func (*ListContainerStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{123}
}
func (m *ListContainerStatsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListContainerStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListContainerStatsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListContainerStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListContainerStatsRequest.Merge(m, src)
}
func (m *ListContainerStatsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListContainerStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListContainerStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListContainerStatsRequest proto.InternalMessageInfo

func (m *ListContainerStatsRequest) GetFilter() *ContainerStatsFilter {
	if m != nil {
		return m.Filter
	}
	return nil
}

// ContainerStatsFilter is used to filter containers.
// All those fields are combined with 'AND'
type ContainerStatsFilter struct {
	// ID of the container.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the PodSandbox.
	PodSandboxId string `protobuf:"bytes,2,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	// LabelSelector to select matches.
	// Only api.MatchLabels is supported for now and the requirements
	// are ANDed. MatchExpressions is not supported yet.
	LabelSelector        map[string]string `protobuf:"bytes,3,rep,name=label_selector,json=labelSelector,proto3" json:"label_selector,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ContainerStatsFilter) Reset()      { *m = ContainerStatsFilter{} }
func (*ContainerStatsFilter) ProtoMessage() {}
func (*ContainerStatsFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{124}
}
func (m *ContainerStatsFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerStatsFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerStatsFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerStatsFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerStatsFilter.Merge(m, src)
}
func (m *ContainerStatsFilter) XXX_Size() int {
	return m.Size()
}
func (m *ContainerStatsFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerStatsFilter.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerStatsFilter proto.InternalMessageInfo

func (m *ContainerStatsFilter) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ContainerStatsFilter) GetPodSandboxId() string {
	if m != nil {
		return m.PodSandboxId
	}
	return ""
}

func (m *ContainerStatsFilter) GetLabelSelector() map[string]string {
	if m != nil {
		return m.LabelSelector
	}
	return nil
}

type ListContainerStatsResponse struct {
	// Stats of the container.
	Stats                []*ContainerStats `protobuf:"bytes,1,rep,name=stats,proto3" json:"stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ListContainerStatsResponse) Reset()      { *m = ListContainerStatsResponse{} }
func (*ListContainerStatsResponse) ProtoMessage() {}
func (*ListContainerStatsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{125}
}
func (m *ListContainerStatsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListContainerStatsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListContainerStatsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListContainerStatsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListContainerStatsResponse.Merge(m, src)
}
func (m *ListContainerStatsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListContainerStatsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListContainerStatsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListContainerStatsResponse proto.InternalMessageInfo

func (m *ListContainerStatsResponse) GetStats() []*ContainerStats {
	if m != nil {
		return m.Stats
	}
	return nil
}

// ContainerAttributes provides basic information of the container.
type ContainerAttributes struct {
	// ID of the container.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Metadata of the container.
	Metadata *ContainerMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Unstructured key-value map holding arbitrary metadata.
	// Annotations MUST NOT be altered by the runtime; the value of this field
	// MUST be identical to that of the corresponding ContainerConfig used to
	// instantiate the Container this status represents.
	Annotations          map[string]string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ContainerAttributes) Reset()      { *m = ContainerAttributes{} }
func (*ContainerAttributes) ProtoMessage() {}
func (*ContainerAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{126}
}
func (m *ContainerAttributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerAttributes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerAttributes.Merge(m, src)
}
func (m *ContainerAttributes) XXX_Size() int {
	return m.Size()
}
func (m *ContainerAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerAttributes proto.InternalMessageInfo

func (m *ContainerAttributes) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ContainerAttributes) GetMetadata() *ContainerMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ContainerAttributes) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *ContainerAttributes) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

// ContainerStats provides the resource usage statistics for a container.
type ContainerStats struct {
	// Information of the container.
	Attributes *ContainerAttributes `protobuf:"bytes,1,opt,name=attributes,proto3" json:"attributes,omitempty"`
	// CPU usage gathered from the container.
	Cpu *CpuUsage `protobuf:"bytes,2,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Memory usage gathered from the container.
	Memory *MemoryUsage `protobuf:"bytes,3,opt,name=memory,proto3" json:"memory,omitempty"`
	// Usage of the writable layer.
	WritableLayer *FilesystemUsage `protobuf:"bytes,4,opt,name=writable_layer,json=writableLayer,proto3" json:"writable_layer,omitempty"`
	// Swap usage gathered from the container.
	Swap                 *SwapUsage `protobuf:"bytes,5,opt,name=swap,proto3" json:"swap,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ContainerStats) Reset()      { *m = ContainerStats{} }
func (*ContainerStats) ProtoMessage() {}
func (*ContainerStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{127}
}
func (m *ContainerStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerStats.Merge(m, src)
}
func (m *ContainerStats) XXX_Size() int {
	return m.Size()
}
func (m *ContainerStats) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerStats.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerStats proto.InternalMessageInfo

func (m *ContainerStats) GetAttributes() *ContainerAttributes {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *ContainerStats) GetCpu() *CpuUsage {
	if m != nil {
		return m.Cpu
	}
	return nil
}

func (m *ContainerStats) GetMemory() *MemoryUsage {
	if m != nil {
		return m.Memory
	}
	return nil
}

func (m *ContainerStats) GetWritableLayer() *FilesystemUsage {
	if m != nil {
		return m.WritableLayer
	}
	return nil
}

func (m *ContainerStats) GetSwap() *SwapUsage {
	if m != nil {
		return m.Swap
	}
	return nil
}

// WindowsContainerStats provides the resource usage statistics for a container specific for Windows
type WindowsContainerStats struct {
	// Information of the container.
	Attributes *ContainerAttributes `protobuf:"bytes,1,opt,name=attributes,proto3" json:"attributes,omitempty"`
	// CPU usage gathered from the container.
	Cpu *WindowsCpuUsage `protobuf:"bytes,2,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Memory usage gathered from the container.
	Memory *WindowsMemoryUsage `protobuf:"bytes,3,opt,name=memory,proto3" json:"memory,omitempty"`
	// Usage of the writable layer.
	WritableLayer        *WindowsFilesystemUsage `protobuf:"bytes,4,opt,name=writable_layer,json=writableLayer,proto3" json:"writable_layer,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *WindowsContainerStats) Reset()      { *m = WindowsContainerStats{} }
func (*WindowsContainerStats) ProtoMessage() {}
func (*WindowsContainerStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{128}
}
func (m *WindowsContainerStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsContainerStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsContainerStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsContainerStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsContainerStats.Merge(m, src)
}
func (m *WindowsContainerStats) XXX_Size() int {
	return m.Size()
}
func (m *WindowsContainerStats) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsContainerStats.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsContainerStats proto.InternalMessageInfo

func (m *WindowsContainerStats) GetAttributes() *ContainerAttributes {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *WindowsContainerStats) GetCpu() *WindowsCpuUsage {
	if m != nil {
		return m.Cpu
	}
	return nil
}

func (m *WindowsContainerStats) GetMemory() *WindowsMemoryUsage {
	if m != nil {
		return m.Memory
	}
	return nil
}

func (m *WindowsContainerStats) GetWritableLayer() *WindowsFilesystemUsage {
	if m != nil {
		return m.WritableLayer
	}
	return nil
}

// CpuUsage provides the CPU usage information.
type CpuUsage struct {
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Cumulative CPU usage (sum across all cores) since object creation.
	UsageCoreNanoSeconds *UInt64Value `protobuf:"bytes,2,opt,name=usage_core_nano_seconds,json=usageCoreNanoSeconds,proto3" json:"usage_core_nano_seconds,omitempty"`
	// Total CPU usage (sum of all cores) averaged over the sample window.
	// The "core" unit can be interpreted as CPU core-nanoseconds per second.
	UsageNanoCores       *UInt64Value `protobuf:"bytes,3,opt,name=usage_nano_cores,json=usageNanoCores,proto3" json:"usage_nano_cores,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CpuUsage) Reset()      { *m = CpuUsage{} }
func (*CpuUsage) ProtoMessage() {}
func (*CpuUsage) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{129}
}
func (m *CpuUsage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CpuUsage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CpuUsage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CpuUsage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CpuUsage.Merge(m, src)
}
func (m *CpuUsage) XXX_Size() int {
	return m.Size()
}
func (m *CpuUsage) XXX_DiscardUnknown() {
	xxx_messageInfo_CpuUsage.DiscardUnknown(m)
}

var xxx_messageInfo_CpuUsage proto.InternalMessageInfo

func (m *CpuUsage) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *CpuUsage) GetUsageCoreNanoSeconds() *UInt64Value {
	if m != nil {
		return m.UsageCoreNanoSeconds
	}
	return nil
}

func (m *CpuUsage) GetUsageNanoCores() *UInt64Value {
	if m != nil {
		return m.UsageNanoCores
	}
	return nil
}

// WindowsCpuUsage provides the CPU usage information specific to Windows
type WindowsCpuUsage struct {
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Cumulative CPU usage (sum across all cores) since object creation.
	UsageCoreNanoSeconds *UInt64Value `protobuf:"bytes,2,opt,name=usage_core_nano_seconds,json=usageCoreNanoSeconds,proto3" json:"usage_core_nano_seconds,omitempty"`
	// Total CPU usage (sum of all cores) averaged over the sample window.
	// The "core" unit can be interpreted as CPU core-nanoseconds per second.
	UsageNanoCores       *UInt64Value `protobuf:"bytes,3,opt,name=usage_nano_cores,json=usageNanoCores,proto3" json:"usage_nano_cores,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *WindowsCpuUsage) Reset()      { *m = WindowsCpuUsage{} }
func (*WindowsCpuUsage) ProtoMessage() {}
func (*WindowsCpuUsage) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{130}
}
func (m *WindowsCpuUsage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsCpuUsage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsCpuUsage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsCpuUsage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsCpuUsage.Merge(m, src)
}
func (m *WindowsCpuUsage) XXX_Size() int {
	return m.Size()
}
func (m *WindowsCpuUsage) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsCpuUsage.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsCpuUsage proto.InternalMessageInfo

func (m *WindowsCpuUsage) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *WindowsCpuUsage) GetUsageCoreNanoSeconds() *UInt64Value {
	if m != nil {
		return m.UsageCoreNanoSeconds
	}
	return nil
}

func (m *WindowsCpuUsage) GetUsageNanoCores() *UInt64Value {
	if m != nil {
		return m.UsageNanoCores
	}
	return nil
}

// MemoryUsage provides the memory usage information.
type MemoryUsage struct {
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The amount of working set memory in bytes.
	WorkingSetBytes *UInt64Value `protobuf:"bytes,2,opt,name=working_set_bytes,json=workingSetBytes,proto3" json:"working_set_bytes,omitempty"`
	// Available memory for use. This is defined as the memory limit - workingSetBytes.
	AvailableBytes *UInt64Value `protobuf:"bytes,3,opt,name=available_bytes,json=availableBytes,proto3" json:"available_bytes,omitempty"`
	// Total memory in use. This includes all memory regardless of when it was accessed.
	UsageBytes *UInt64Value `protobuf:"bytes,4,opt,name=usage_bytes,json=usageBytes,proto3" json:"usage_bytes,omitempty"`
	// The amount of anonymous and swap cache memory (includes transparent hugepages).
	RssBytes *UInt64Value `protobuf:"bytes,5,opt,name=rss_bytes,json=rssBytes,proto3" json:"rss_bytes,omitempty"`
	// Cumulative number of minor page faults.
	PageFaults *UInt64Value `protobuf:"bytes,6,opt,name=page_faults,json=pageFaults,proto3" json:"page_faults,omitempty"`
	// Cumulative number of major page faults.
	MajorPageFaults      *UInt64Value `protobuf:"bytes,7,opt,name=major_page_faults,json=majorPageFaults,proto3" json:"major_page_faults,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *MemoryUsage) Reset()      { *m = MemoryUsage{} }
func (*MemoryUsage) ProtoMessage() {}
func (*MemoryUsage) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{131}
}
func (m *MemoryUsage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MemoryUsage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MemoryUsage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MemoryUsage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MemoryUsage.Merge(m, src)
}
func (m *MemoryUsage) XXX_Size() int {
	return m.Size()
}
func (m *MemoryUsage) XXX_DiscardUnknown() {
	xxx_messageInfo_MemoryUsage.DiscardUnknown(m)
}

var xxx_messageInfo_MemoryUsage proto.InternalMessageInfo

func (m *MemoryUsage) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *MemoryUsage) GetWorkingSetBytes() *UInt64Value {
	if m != nil {
		return m.WorkingSetBytes
	}
	return nil
}

func (m *MemoryUsage) GetAvailableBytes() *UInt64Value {
	if m != nil {
		return m.AvailableBytes
	}
	return nil
}

func (m *MemoryUsage) GetUsageBytes() *UInt64Value {
	if m != nil {
		return m.UsageBytes
	}
	return nil
}

func (m *MemoryUsage) GetRssBytes() *UInt64Value {
	if m != nil {
		return m.RssBytes
	}
	return nil
}

func (m *MemoryUsage) GetPageFaults() *UInt64Value {
	if m != nil {
		return m.PageFaults
	}
	return nil
}

func (m *MemoryUsage) GetMajorPageFaults() *UInt64Value {
	if m != nil {
		return m.MajorPageFaults
	}
	return nil
}

type SwapUsage struct {
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Available swap for use. This is defined as the swap limit - swapUsageBytes.
	SwapAvailableBytes *UInt64Value `protobuf:"bytes,2,opt,name=swap_available_bytes,json=swapAvailableBytes,proto3" json:"swap_available_bytes,omitempty"`
	// Total memory in use. This includes all memory regardless of when it was accessed.
	SwapUsageBytes       *UInt64Value `protobuf:"bytes,3,opt,name=swap_usage_bytes,json=swapUsageBytes,proto3" json:"swap_usage_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *SwapUsage) Reset()      { *m = SwapUsage{} }
func (*SwapUsage) ProtoMessage() {}
func (*SwapUsage) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{132}
}
func (m *SwapUsage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SwapUsage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SwapUsage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SwapUsage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SwapUsage.Merge(m, src)
}
func (m *SwapUsage) XXX_Size() int {
	return m.Size()
}
func (m *SwapUsage) XXX_DiscardUnknown() {
	xxx_messageInfo_SwapUsage.DiscardUnknown(m)
}

var xxx_messageInfo_SwapUsage proto.InternalMessageInfo

func (m *SwapUsage) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *SwapUsage) GetSwapAvailableBytes() *UInt64Value {
	if m != nil {
		return m.SwapAvailableBytes
	}
	return nil
}

func (m *SwapUsage) GetSwapUsageBytes() *UInt64Value {
	if m != nil {
		return m.SwapUsageBytes
	}
	return nil
}

// WindowsMemoryUsage provides the memory usage information specific to Windows
type WindowsMemoryUsage struct {
	// Timestamp in nanoseconds at which the information were collected. Must be > 0.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The amount of working set memory in bytes.
	WorkingSetBytes *UInt64Value `protobuf:"bytes,2,opt,name=working_set_bytes,json=workingSetBytes,proto3" json:"working_set_bytes,omitempty"`
	// Available memory for use. This is defined as the memory limit - commit_memory_bytes.
	AvailableBytes *UInt64Value `protobuf:"bytes,3,opt,name=available_bytes,json=availableBytes,proto3" json:"available_bytes,omitempty"`
	// Cumulative number of page faults.
	PageFaults *UInt64Value `protobuf:"bytes,4,opt,name=page_faults,json=pageFaults,proto3" json:"page_faults,omitempty"`
	// Total commit memory in use. Commit memory is total of physical and virtual memory in use.
	CommitMemoryBytes    *UInt64Value `protobuf:"bytes,5,opt,name=commit_memory_bytes,json=commitMemoryBytes,proto3" json:"commit_memory_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *WindowsMemoryUsage) Reset()      { *m = WindowsMemoryUsage{} }
func (*WindowsMemoryUsage) ProtoMessage() {}
func (*WindowsMemoryUsage) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{133}
}
func (m *WindowsMemoryUsage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WindowsMemoryUsage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WindowsMemoryUsage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WindowsMemoryUsage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsMemoryUsage.Merge(m, src)
}
func (m *WindowsMemoryUsage) XXX_Size() int {
	return m.Size()
}
func (m *WindowsMemoryUsage) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsMemoryUsage.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsMemoryUsage proto.InternalMessageInfo

func (m *WindowsMemoryUsage) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *WindowsMemoryUsage) GetWorkingSetBytes() *UInt64Value {
	if m != nil {
		return m.WorkingSetBytes
	}
	return nil
}

func (m *WindowsMemoryUsage) GetAvailableBytes() *UInt64Value {
	if m != nil {
		return m.AvailableBytes
	}
	return nil
}

func (m *WindowsMemoryUsage) GetPageFaults() *UInt64Value {
	if m != nil {
		return m.PageFaults
	}
	return nil
}

func (m *WindowsMemoryUsage) GetCommitMemoryBytes() *UInt64Value {
	if m != nil {
		return m.CommitMemoryBytes
	}
	return nil
}

type ReopenContainerLogRequest struct {
	// ID of the container for which to reopen the log.
	ContainerId          string   `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReopenContainerLogRequest) Reset()      { *m = ReopenContainerLogRequest{} }
func (*ReopenContainerLogRequest) ProtoMessage() {}
func (*ReopenContainerLogRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{134}
}
func (m *ReopenContainerLogRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReopenContainerLogRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReopenContainerLogRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReopenContainerLogRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReopenContainerLogRequest.Merge(m, src)
}
func (m *ReopenContainerLogRequest) XXX_Size() int {
	return m.Size()
}
func (m *ReopenContainerLogRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReopenContainerLogRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReopenContainerLogRequest proto.InternalMessageInfo

func (m *ReopenContainerLogRequest) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

type ReopenContainerLogResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReopenContainerLogResponse) Reset()      { *m = ReopenContainerLogResponse{} }
func (*ReopenContainerLogResponse) ProtoMessage() {}
func (*ReopenContainerLogResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{135}
}
func (m *ReopenContainerLogResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReopenContainerLogResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReopenContainerLogResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReopenContainerLogResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReopenContainerLogResponse.Merge(m, src)
}
func (m *ReopenContainerLogResponse) XXX_Size() int {
	return m.Size()
}
func (m *ReopenContainerLogResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReopenContainerLogResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReopenContainerLogResponse proto.InternalMessageInfo

type CheckpointContainerRequest struct {
	// ID of the container to be checkpointed.
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Location of the checkpoint archive used for export
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// Timeout in seconds for the checkpoint to complete.
	// Timeout of zero means to use the CRI default.
	// Timeout > 0 means to use the user specified timeout.
	Timeout              int64    `protobuf:"varint,3,opt,name=timeout,proto3" json:"timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckpointContainerRequest) Reset()      { *m = CheckpointContainerRequest{} }
func (*CheckpointContainerRequest) ProtoMessage() {}
func (*CheckpointContainerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{136}
}
func (m *CheckpointContainerRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckpointContainerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckpointContainerRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckpointContainerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckpointContainerRequest.Merge(m, src)
}
func (m *CheckpointContainerRequest) XXX_Size() int {
	return m.Size()
}
func (m *CheckpointContainerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckpointContainerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckpointContainerRequest proto.InternalMessageInfo

func (m *CheckpointContainerRequest) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *CheckpointContainerRequest) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *CheckpointContainerRequest) GetTimeout() int64 {
	if m != nil {
		return m.Timeout
	}
	return 0
}

type CheckpointContainerResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckpointContainerResponse) Reset()      { *m = CheckpointContainerResponse{} }
func (*CheckpointContainerResponse) ProtoMessage() {}
func (*CheckpointContainerResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{137}
}
func (m *CheckpointContainerResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckpointContainerResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckpointContainerResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckpointContainerResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckpointContainerResponse.Merge(m, src)
}
func (m *CheckpointContainerResponse) XXX_Size() int {
	return m.Size()
}
func (m *CheckpointContainerResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckpointContainerResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckpointContainerResponse proto.InternalMessageInfo

type GetEventsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetEventsRequest) Reset()      { *m = GetEventsRequest{} }
func (*GetEventsRequest) ProtoMessage() {}
func (*GetEventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{138}
}
func (m *GetEventsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetEventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetEventsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetEventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetEventsRequest.Merge(m, src)
}
func (m *GetEventsRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetEventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetEventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetEventsRequest proto.InternalMessageInfo

type ContainerEventResponse struct {
	// ID of the container
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Type of the container event
	ContainerEventType ContainerEventType `protobuf:"varint,2,opt,name=container_event_type,json=containerEventType,proto3,enum=runtime.v1.ContainerEventType" json:"container_event_type,omitempty"`
	// Creation timestamp of this event
	CreatedAt int64 `protobuf:"varint,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Sandbox status
	PodSandboxStatus *PodSandboxStatus `protobuf:"bytes,4,opt,name=pod_sandbox_status,json=podSandboxStatus,proto3" json:"pod_sandbox_status,omitempty"`
	// Container statuses
	ContainersStatuses   []*ContainerStatus `protobuf:"bytes,5,rep,name=containers_statuses,json=containersStatuses,proto3" json:"containers_statuses,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ContainerEventResponse) Reset()      { *m = ContainerEventResponse{} }
func (*ContainerEventResponse) ProtoMessage() {}
func (*ContainerEventResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{139}
}
func (m *ContainerEventResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerEventResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerEventResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerEventResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerEventResponse.Merge(m, src)
}
func (m *ContainerEventResponse) XXX_Size() int {
	return m.Size()
}
func (m *ContainerEventResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerEventResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerEventResponse proto.InternalMessageInfo

func (m *ContainerEventResponse) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *ContainerEventResponse) GetContainerEventType() ContainerEventType {
	if m != nil {
		return m.ContainerEventType
	}
	return ContainerEventType_CONTAINER_CREATED_EVENT
}

func (m *ContainerEventResponse) GetCreatedAt() int64 {
	if m != nil {
		return m.CreatedAt
	}
	return 0
}

func (m *ContainerEventResponse) GetPodSandboxStatus() *PodSandboxStatus {
	if m != nil {
		return m.PodSandboxStatus
	}
	return nil
}

func (m *ContainerEventResponse) GetContainersStatuses() []*ContainerStatus {
	if m != nil {
		return m.ContainersStatuses
	}
	return nil
}

type ListMetricDescriptorsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMetricDescriptorsRequest) Reset()      { *m = ListMetricDescriptorsRequest{} }
func (*ListMetricDescriptorsRequest) ProtoMessage() {}
func (*ListMetricDescriptorsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{140}
}
func (m *ListMetricDescriptorsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListMetricDescriptorsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListMetricDescriptorsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListMetricDescriptorsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMetricDescriptorsRequest.Merge(m, src)
}
func (m *ListMetricDescriptorsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListMetricDescriptorsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMetricDescriptorsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListMetricDescriptorsRequest proto.InternalMessageInfo

type ListMetricDescriptorsResponse struct {
	Descriptors          []*MetricDescriptor `protobuf:"bytes,1,rep,name=descriptors,proto3" json:"descriptors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ListMetricDescriptorsResponse) Reset()      { *m = ListMetricDescriptorsResponse{} }
func (*ListMetricDescriptorsResponse) ProtoMessage() {}
func (*ListMetricDescriptorsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{141}
}
func (m *ListMetricDescriptorsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListMetricDescriptorsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListMetricDescriptorsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListMetricDescriptorsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMetricDescriptorsResponse.Merge(m, src)
}
func (m *ListMetricDescriptorsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListMetricDescriptorsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMetricDescriptorsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListMetricDescriptorsResponse proto.InternalMessageInfo

func (m *ListMetricDescriptorsResponse) GetDescriptors() []*MetricDescriptor {
	if m != nil {
		return m.Descriptors
	}
	return nil
}

type MetricDescriptor struct {
	// The name field will be used as a unique identifier of this MetricDescriptor,
	// and be used in conjunction with the Metric structure to populate the full Metric.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Help string `protobuf:"bytes,2,opt,name=help,proto3" json:"help,omitempty"`
	// When a metric uses this metric descriptor, it should only define
	// labels that have previously been declared in label_keys.
	// It is the responsibility of the runtime to correctly keep sorted the keys and values.
	// If the two slices have different length, the behavior is undefined.
	LabelKeys            []string `protobuf:"bytes,3,rep,name=label_keys,json=labelKeys,proto3" json:"label_keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MetricDescriptor) Reset()      { *m = MetricDescriptor{} }
func (*MetricDescriptor) ProtoMessage() {}
func (*MetricDescriptor) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{142}
}
func (m *MetricDescriptor) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MetricDescriptor) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MetricDescriptor.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MetricDescriptor) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricDescriptor.Merge(m, src)
}
func (m *MetricDescriptor) XXX_Size() int {
	return m.Size()
}
func (m *MetricDescriptor) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricDescriptor.DiscardUnknown(m)
}

var xxx_messageInfo_MetricDescriptor proto.InternalMessageInfo

func (m *MetricDescriptor) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MetricDescriptor) GetHelp() string {
	if m != nil {
		return m.Help
	}
	return ""
}

func (m *MetricDescriptor) GetLabelKeys() []string {
	if m != nil {
		return m.LabelKeys
	}
	return nil
}

type ListPodSandboxMetricsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListPodSandboxMetricsRequest) Reset()      { *m = ListPodSandboxMetricsRequest{} }
func (*ListPodSandboxMetricsRequest) ProtoMessage() {}
func (*ListPodSandboxMetricsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{143}
}
func (m *ListPodSandboxMetricsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListPodSandboxMetricsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListPodSandboxMetricsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListPodSandboxMetricsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPodSandboxMetricsRequest.Merge(m, src)
}
func (m *ListPodSandboxMetricsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListPodSandboxMetricsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPodSandboxMetricsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPodSandboxMetricsRequest proto.InternalMessageInfo

type ListPodSandboxMetricsResponse struct {
	PodMetrics           []*PodSandboxMetrics `protobuf:"bytes,1,rep,name=pod_metrics,json=podMetrics,proto3" json:"pod_metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListPodSandboxMetricsResponse) Reset()      { *m = ListPodSandboxMetricsResponse{} }
func (*ListPodSandboxMetricsResponse) ProtoMessage() {}
func (*ListPodSandboxMetricsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{144}
}
func (m *ListPodSandboxMetricsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListPodSandboxMetricsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListPodSandboxMetricsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListPodSandboxMetricsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPodSandboxMetricsResponse.Merge(m, src)
}
func (m *ListPodSandboxMetricsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListPodSandboxMetricsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPodSandboxMetricsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListPodSandboxMetricsResponse proto.InternalMessageInfo

func (m *ListPodSandboxMetricsResponse) GetPodMetrics() []*PodSandboxMetrics {
	if m != nil {
		return m.PodMetrics
	}
	return nil
}

type PodSandboxMetrics struct {
	PodSandboxId         string              `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId,proto3" json:"pod_sandbox_id,omitempty"`
	Metrics              []*Metric           `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
	ContainerMetrics     []*ContainerMetrics `protobuf:"bytes,3,rep,name=container_metrics,json=containerMetrics,proto3" json:"container_metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *PodSandboxMetrics) Reset()      { *m = PodSandboxMetrics{} }
func (*PodSandboxMetrics) ProtoMessage() {}
func (*PodSandboxMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{145}
}
func (m *PodSandboxMetrics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodSandboxMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodSandboxMetrics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodSandboxMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodSandboxMetrics.Merge(m, src)
}
func (m *PodSandboxMetrics) XXX_Size() int {
	return m.Size()
}
func (m *PodSandboxMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_PodSandboxMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_PodSandboxMetrics proto.InternalMessageInfo

func (m *PodSandboxMetrics) GetPodSandboxId() string {
	if m != nil {
		return m.PodSandboxId
	}
	return ""
}

func (m *PodSandboxMetrics) GetMetrics() []*Metric {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *PodSandboxMetrics) GetContainerMetrics() []*ContainerMetrics {
	if m != nil {
		return m.ContainerMetrics
	}
	return nil
}

type ContainerMetrics struct {
	ContainerId          string    `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	Metrics              []*Metric `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *ContainerMetrics) Reset()      { *m = ContainerMetrics{} }
func (*ContainerMetrics) ProtoMessage() {}
func (*ContainerMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{146}
}
func (m *ContainerMetrics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ContainerMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ContainerMetrics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ContainerMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerMetrics.Merge(m, src)
}
func (m *ContainerMetrics) XXX_Size() int {
	return m.Size()
}
func (m *ContainerMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerMetrics proto.InternalMessageInfo

func (m *ContainerMetrics) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *ContainerMetrics) GetMetrics() []*Metric {
	if m != nil {
		return m.Metrics
	}
	return nil
}

type Metric struct {
	// Name must match a name previously returned in a MetricDescriptors call,
	// otherwise, it will be ignored.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Timestamp should be 0 if the metric was gathered live.
	// If it was cached, the Timestamp should reflect the time it was collected.
	Timestamp  int64      `protobuf:"varint,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	MetricType MetricType `protobuf:"varint,3,opt,name=metric_type,json=metricType,proto3,enum=runtime.v1.MetricType" json:"metric_type,omitempty"`
	// The corresponding LabelValues to the LabelKeys defined in the MetricDescriptor.
	// It is the responsibility of the runtime to correctly keep sorted the keys and values.
	// If the two slices have different length, the behavior is undefined.
	LabelValues          []string     `protobuf:"bytes,4,rep,name=label_values,json=labelValues,proto3" json:"label_values,omitempty"`
	Value                *UInt64Value `protobuf:"bytes,5,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Metric) Reset()      { *m = Metric{} }
func (*Metric) ProtoMessage() {}
func (*Metric) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{147}
}
func (m *Metric) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Metric) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Metric.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Metric) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metric.Merge(m, src)
}
func (m *Metric) XXX_Size() int {
	return m.Size()
}
func (m *Metric) XXX_DiscardUnknown() {
	xxx_messageInfo_Metric.DiscardUnknown(m)
}

var xxx_messageInfo_Metric proto.InternalMessageInfo

func (m *Metric) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Metric) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *Metric) GetMetricType() MetricType {
	if m != nil {
		return m.MetricType
	}
	return MetricType_COUNTER
}

func (m *Metric) GetLabelValues() []string {
	if m != nil {
		return m.LabelValues
	}
	return nil
}

func (m *Metric) GetValue() *UInt64Value {
	if m != nil {
		return m.Value
	}
	return nil
}

type RuntimeConfigRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RuntimeConfigRequest) Reset()      { *m = RuntimeConfigRequest{} }
func (*RuntimeConfigRequest) ProtoMessage() {}
func (*RuntimeConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{148}
}
func (m *RuntimeConfigRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RuntimeConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RuntimeConfigRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RuntimeConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeConfigRequest.Merge(m, src)
}
func (m *RuntimeConfigRequest) XXX_Size() int {
	return m.Size()
}
func (m *RuntimeConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeConfigRequest proto.InternalMessageInfo

type RuntimeConfigResponse struct {
	// Configuration information for Linux-based runtimes. This field contains
	// global runtime configuration options that are not specific to runtime
	// handlers.
	Linux                *LinuxRuntimeConfiguration `protobuf:"bytes,1,opt,name=linux,proto3" json:"linux,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *RuntimeConfigResponse) Reset()      { *m = RuntimeConfigResponse{} }
func (*RuntimeConfigResponse) ProtoMessage() {}
func (*RuntimeConfigResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{149}
}
func (m *RuntimeConfigResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RuntimeConfigResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RuntimeConfigResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RuntimeConfigResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeConfigResponse.Merge(m, src)
}
func (m *RuntimeConfigResponse) XXX_Size() int {
	return m.Size()
}
func (m *RuntimeConfigResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeConfigResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeConfigResponse proto.InternalMessageInfo

func (m *RuntimeConfigResponse) GetLinux() *LinuxRuntimeConfiguration {
	if m != nil {
		return m.Linux
	}
	return nil
}

type LinuxRuntimeConfiguration struct {
	// Cgroup driver to use
	// Note: this field should not change for the lifecycle of the Kubelet,
	// or while there are running containers.
	// The Kubelet will not re-request this after startup, and will construct the cgroup
	// hierarchy assuming it is static.
	// If the runtime wishes to change this value, it must be accompanied by removal of
	// all pods, and a restart of the Kubelet. The easiest way to do this is with a full node reboot.
	CgroupDriver         CgroupDriver `protobuf:"varint,1,opt,name=cgroup_driver,json=cgroupDriver,proto3,enum=runtime.v1.CgroupDriver" json:"cgroup_driver,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *LinuxRuntimeConfiguration) Reset()      { *m = LinuxRuntimeConfiguration{} }
func (*LinuxRuntimeConfiguration) ProtoMessage() {}
func (*LinuxRuntimeConfiguration) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{150}
}
func (m *LinuxRuntimeConfiguration) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinuxRuntimeConfiguration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinuxRuntimeConfiguration.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinuxRuntimeConfiguration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinuxRuntimeConfiguration.Merge(m, src)
}
func (m *LinuxRuntimeConfiguration) XXX_Size() int {
	return m.Size()
}
func (m *LinuxRuntimeConfiguration) XXX_DiscardUnknown() {
	xxx_messageInfo_LinuxRuntimeConfiguration.DiscardUnknown(m)
}

var xxx_messageInfo_LinuxRuntimeConfiguration proto.InternalMessageInfo

func (m *LinuxRuntimeConfiguration) GetCgroupDriver() CgroupDriver {
	if m != nil {
		return m.CgroupDriver
	}
	return CgroupDriver_SYSTEMD
}

func init() {
	proto.RegisterEnum("runtime.v1.Protocol", Protocol_name, Protocol_value)
	proto.RegisterEnum("runtime.v1.MountPropagation", MountPropagation_name, MountPropagation_value)
	proto.RegisterEnum("runtime.v1.NamespaceMode", NamespaceMode_name, NamespaceMode_value)
	proto.RegisterEnum("runtime.v1.SupplementalGroupsPolicy", SupplementalGroupsPolicy_name, SupplementalGroupsPolicy_value)
	proto.RegisterEnum("runtime.v1.PodSandboxState", PodSandboxState_name, PodSandboxState_value)
	proto.RegisterEnum("runtime.v1.ContainerState", ContainerState_name, ContainerState_value)
	proto.RegisterEnum("runtime.v1.ContainerEventType", ContainerEventType_name, ContainerEventType_value)
	proto.RegisterEnum("runtime.v1.MetricType", MetricType_name, MetricType_value)
	proto.RegisterEnum("runtime.v1.CgroupDriver", CgroupDriver_name, CgroupDriver_value)
	proto.RegisterEnum("runtime.v1.SecurityProfile_ProfileType", SecurityProfile_ProfileType_name, SecurityProfile_ProfileType_value)
	proto.RegisterType((*VersionRequest)(nil), "runtime.v1.VersionRequest")
	proto.RegisterType((*VersionResponse)(nil), "runtime.v1.VersionResponse")
	proto.RegisterType((*DNSConfig)(nil), "runtime.v1.DNSConfig")
	proto.RegisterType((*PortMapping)(nil), "runtime.v1.PortMapping")
	proto.RegisterType((*Mount)(nil), "runtime.v1.Mount")
	proto.RegisterType((*IDMapping)(nil), "runtime.v1.IDMapping")
	proto.RegisterType((*UserNamespace)(nil), "runtime.v1.UserNamespace")
	proto.RegisterType((*NamespaceOption)(nil), "runtime.v1.NamespaceOption")
	proto.RegisterType((*Int64Value)(nil), "runtime.v1.Int64Value")
	proto.RegisterType((*LinuxSandboxSecurityContext)(nil), "runtime.v1.LinuxSandboxSecurityContext")
	proto.RegisterType((*SecurityProfile)(nil), "runtime.v1.SecurityProfile")
	proto.RegisterType((*LinuxPodSandboxConfig)(nil), "runtime.v1.LinuxPodSandboxConfig")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.LinuxPodSandboxConfig.SysctlsEntry")
	proto.RegisterType((*PodSandboxMetadata)(nil), "runtime.v1.PodSandboxMetadata")
	proto.RegisterType((*PodSandboxConfig)(nil), "runtime.v1.PodSandboxConfig")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.PodSandboxConfig.AnnotationsEntry")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.PodSandboxConfig.LabelsEntry")
	proto.RegisterType((*RunPodSandboxRequest)(nil), "runtime.v1.RunPodSandboxRequest")
	proto.RegisterType((*RunPodSandboxResponse)(nil), "runtime.v1.RunPodSandboxResponse")
	proto.RegisterType((*StopPodSandboxRequest)(nil), "runtime.v1.StopPodSandboxRequest")
	proto.RegisterType((*StopPodSandboxResponse)(nil), "runtime.v1.StopPodSandboxResponse")
	proto.RegisterType((*RemovePodSandboxRequest)(nil), "runtime.v1.RemovePodSandboxRequest")
	proto.RegisterType((*RemovePodSandboxResponse)(nil), "runtime.v1.RemovePodSandboxResponse")
	proto.RegisterType((*PodSandboxStatusRequest)(nil), "runtime.v1.PodSandboxStatusRequest")
	proto.RegisterType((*PodIP)(nil), "runtime.v1.PodIP")
	proto.RegisterType((*PodSandboxNetworkStatus)(nil), "runtime.v1.PodSandboxNetworkStatus")
	proto.RegisterType((*Namespace)(nil), "runtime.v1.Namespace")
	proto.RegisterType((*LinuxPodSandboxStatus)(nil), "runtime.v1.LinuxPodSandboxStatus")
	proto.RegisterType((*PodSandboxStatus)(nil), "runtime.v1.PodSandboxStatus")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.PodSandboxStatus.AnnotationsEntry")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.PodSandboxStatus.LabelsEntry")
	proto.RegisterType((*PodSandboxStatusResponse)(nil), "runtime.v1.PodSandboxStatusResponse")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.PodSandboxStatusResponse.InfoEntry")
	proto.RegisterType((*PodSandboxStateValue)(nil), "runtime.v1.PodSandboxStateValue")
	proto.RegisterType((*PodSandboxFilter)(nil), "runtime.v1.PodSandboxFilter")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.PodSandboxFilter.LabelSelectorEntry")
	proto.RegisterType((*ListPodSandboxRequest)(nil), "runtime.v1.ListPodSandboxRequest")
	proto.RegisterType((*PodSandbox)(nil), "runtime.v1.PodSandbox")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.PodSandbox.AnnotationsEntry")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.PodSandbox.LabelsEntry")
	proto.RegisterType((*ListPodSandboxResponse)(nil), "runtime.v1.ListPodSandboxResponse")
	proto.RegisterType((*PodSandboxStatsRequest)(nil), "runtime.v1.PodSandboxStatsRequest")
	proto.RegisterType((*PodSandboxStatsResponse)(nil), "runtime.v1.PodSandboxStatsResponse")
	proto.RegisterType((*PodSandboxStatsFilter)(nil), "runtime.v1.PodSandboxStatsFilter")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.PodSandboxStatsFilter.LabelSelectorEntry")
	proto.RegisterType((*ListPodSandboxStatsRequest)(nil), "runtime.v1.ListPodSandboxStatsRequest")
	proto.RegisterType((*ListPodSandboxStatsResponse)(nil), "runtime.v1.ListPodSandboxStatsResponse")
	proto.RegisterType((*PodSandboxAttributes)(nil), "runtime.v1.PodSandboxAttributes")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.PodSandboxAttributes.AnnotationsEntry")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.PodSandboxAttributes.LabelsEntry")
	proto.RegisterType((*PodSandboxStats)(nil), "runtime.v1.PodSandboxStats")
	proto.RegisterType((*LinuxPodSandboxStats)(nil), "runtime.v1.LinuxPodSandboxStats")
	proto.RegisterType((*WindowsPodSandboxStats)(nil), "runtime.v1.WindowsPodSandboxStats")
	proto.RegisterType((*NetworkUsage)(nil), "runtime.v1.NetworkUsage")
	proto.RegisterType((*WindowsNetworkUsage)(nil), "runtime.v1.WindowsNetworkUsage")
	proto.RegisterType((*NetworkInterfaceUsage)(nil), "runtime.v1.NetworkInterfaceUsage")
	proto.RegisterType((*WindowsNetworkInterfaceUsage)(nil), "runtime.v1.WindowsNetworkInterfaceUsage")
	proto.RegisterType((*ProcessUsage)(nil), "runtime.v1.ProcessUsage")
	proto.RegisterType((*WindowsProcessUsage)(nil), "runtime.v1.WindowsProcessUsage")
	proto.RegisterType((*ImageSpec)(nil), "runtime.v1.ImageSpec")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.ImageSpec.AnnotationsEntry")
	proto.RegisterType((*KeyValue)(nil), "runtime.v1.KeyValue")
	proto.RegisterType((*LinuxContainerResources)(nil), "runtime.v1.LinuxContainerResources")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.LinuxContainerResources.UnifiedEntry")
	proto.RegisterType((*HugepageLimit)(nil), "runtime.v1.HugepageLimit")
	proto.RegisterType((*SELinuxOption)(nil), "runtime.v1.SELinuxOption")
	proto.RegisterType((*Capability)(nil), "runtime.v1.Capability")
	proto.RegisterType((*LinuxContainerSecurityContext)(nil), "runtime.v1.LinuxContainerSecurityContext")
	proto.RegisterType((*LinuxContainerConfig)(nil), "runtime.v1.LinuxContainerConfig")
	proto.RegisterType((*LinuxContainerUser)(nil), "runtime.v1.LinuxContainerUser")
	proto.RegisterType((*WindowsNamespaceOption)(nil), "runtime.v1.WindowsNamespaceOption")
	proto.RegisterType((*WindowsSandboxSecurityContext)(nil), "runtime.v1.WindowsSandboxSecurityContext")
	proto.RegisterType((*WindowsPodSandboxConfig)(nil), "runtime.v1.WindowsPodSandboxConfig")
	proto.RegisterType((*WindowsContainerSecurityContext)(nil), "runtime.v1.WindowsContainerSecurityContext")
	proto.RegisterType((*WindowsContainerConfig)(nil), "runtime.v1.WindowsContainerConfig")
	proto.RegisterType((*WindowsContainerResources)(nil), "runtime.v1.WindowsContainerResources")
	proto.RegisterType((*ContainerMetadata)(nil), "runtime.v1.ContainerMetadata")
	proto.RegisterType((*Device)(nil), "runtime.v1.Device")
	proto.RegisterType((*CDIDevice)(nil), "runtime.v1.CDIDevice")
	proto.RegisterType((*ContainerConfig)(nil), "runtime.v1.ContainerConfig")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.ContainerConfig.AnnotationsEntry")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.ContainerConfig.LabelsEntry")
	proto.RegisterType((*CreateContainerRequest)(nil), "runtime.v1.CreateContainerRequest")
	proto.RegisterType((*CreateContainerResponse)(nil), "runtime.v1.CreateContainerResponse")
	proto.RegisterType((*StartContainerRequest)(nil), "runtime.v1.StartContainerRequest")
	proto.RegisterType((*StartContainerResponse)(nil), "runtime.v1.StartContainerResponse")
	proto.RegisterType((*StopContainerRequest)(nil), "runtime.v1.StopContainerRequest")
	proto.RegisterType((*StopContainerResponse)(nil), "runtime.v1.StopContainerResponse")
	proto.RegisterType((*RemoveContainerRequest)(nil), "runtime.v1.RemoveContainerRequest")
	proto.RegisterType((*RemoveContainerResponse)(nil), "runtime.v1.RemoveContainerResponse")
	proto.RegisterType((*ContainerStateValue)(nil), "runtime.v1.ContainerStateValue")
	proto.RegisterType((*ContainerFilter)(nil), "runtime.v1.ContainerFilter")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.ContainerFilter.LabelSelectorEntry")
	proto.RegisterType((*ListContainersRequest)(nil), "runtime.v1.ListContainersRequest")
	proto.RegisterType((*Container)(nil), "runtime.v1.Container")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.Container.AnnotationsEntry")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.Container.LabelsEntry")
	proto.RegisterType((*ListContainersResponse)(nil), "runtime.v1.ListContainersResponse")
	proto.RegisterType((*ContainerStatusRequest)(nil), "runtime.v1.ContainerStatusRequest")
	proto.RegisterType((*ContainerStatus)(nil), "runtime.v1.ContainerStatus")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.ContainerStatus.AnnotationsEntry")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.ContainerStatus.LabelsEntry")
	proto.RegisterType((*ContainerStatusResponse)(nil), "runtime.v1.ContainerStatusResponse")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.ContainerStatusResponse.InfoEntry")
	proto.RegisterType((*ContainerResources)(nil), "runtime.v1.ContainerResources")
	proto.RegisterType((*ContainerUser)(nil), "runtime.v1.ContainerUser")
	proto.RegisterType((*UpdateContainerResourcesRequest)(nil), "runtime.v1.UpdateContainerResourcesRequest")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.UpdateContainerResourcesRequest.AnnotationsEntry")
	proto.RegisterType((*UpdateContainerResourcesResponse)(nil), "runtime.v1.UpdateContainerResourcesResponse")
	proto.RegisterType((*ExecSyncRequest)(nil), "runtime.v1.ExecSyncRequest")
	proto.RegisterType((*ExecSyncResponse)(nil), "runtime.v1.ExecSyncResponse")
	proto.RegisterType((*ExecRequest)(nil), "runtime.v1.ExecRequest")
	proto.RegisterType((*ExecResponse)(nil), "runtime.v1.ExecResponse")
	proto.RegisterType((*AttachRequest)(nil), "runtime.v1.AttachRequest")
	proto.RegisterType((*AttachResponse)(nil), "runtime.v1.AttachResponse")
	proto.RegisterType((*PortForwardRequest)(nil), "runtime.v1.PortForwardRequest")
	proto.RegisterType((*PortForwardResponse)(nil), "runtime.v1.PortForwardResponse")
	proto.RegisterType((*ImageFilter)(nil), "runtime.v1.ImageFilter")
	proto.RegisterType((*ListImagesRequest)(nil), "runtime.v1.ListImagesRequest")
	proto.RegisterType((*Image)(nil), "runtime.v1.Image")
	proto.RegisterType((*ListImagesResponse)(nil), "runtime.v1.ListImagesResponse")
	proto.RegisterType((*ImageStatusRequest)(nil), "runtime.v1.ImageStatusRequest")
	proto.RegisterType((*ImageStatusResponse)(nil), "runtime.v1.ImageStatusResponse")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.ImageStatusResponse.InfoEntry")
	proto.RegisterType((*AuthConfig)(nil), "runtime.v1.AuthConfig")
	proto.RegisterType((*PullImageRequest)(nil), "runtime.v1.PullImageRequest")
	proto.RegisterType((*PullImageResponse)(nil), "runtime.v1.PullImageResponse")
	proto.RegisterType((*RemoveImageRequest)(nil), "runtime.v1.RemoveImageRequest")
	proto.RegisterType((*RemoveImageResponse)(nil), "runtime.v1.RemoveImageResponse")
	proto.RegisterType((*NetworkConfig)(nil), "runtime.v1.NetworkConfig")
	proto.RegisterType((*RuntimeConfig)(nil), "runtime.v1.RuntimeConfig")
	proto.RegisterType((*UpdateRuntimeConfigRequest)(nil), "runtime.v1.UpdateRuntimeConfigRequest")
	proto.RegisterType((*UpdateRuntimeConfigResponse)(nil), "runtime.v1.UpdateRuntimeConfigResponse")
	proto.RegisterType((*RuntimeCondition)(nil), "runtime.v1.RuntimeCondition")
	proto.RegisterType((*RuntimeStatus)(nil), "runtime.v1.RuntimeStatus")
	proto.RegisterType((*StatusRequest)(nil), "runtime.v1.StatusRequest")
	proto.RegisterType((*RuntimeHandlerFeatures)(nil), "runtime.v1.RuntimeHandlerFeatures")
	proto.RegisterType((*RuntimeHandler)(nil), "runtime.v1.RuntimeHandler")
	proto.RegisterType((*StatusResponse)(nil), "runtime.v1.StatusResponse")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.StatusResponse.InfoEntry")
	proto.RegisterType((*ImageFsInfoRequest)(nil), "runtime.v1.ImageFsInfoRequest")
	proto.RegisterType((*UInt64Value)(nil), "runtime.v1.UInt64Value")
	proto.RegisterType((*FilesystemIdentifier)(nil), "runtime.v1.FilesystemIdentifier")
	proto.RegisterType((*FilesystemUsage)(nil), "runtime.v1.FilesystemUsage")
	proto.RegisterType((*WindowsFilesystemUsage)(nil), "runtime.v1.WindowsFilesystemUsage")
	proto.RegisterType((*ImageFsInfoResponse)(nil), "runtime.v1.ImageFsInfoResponse")
	proto.RegisterType((*ContainerStatsRequest)(nil), "runtime.v1.ContainerStatsRequest")
	proto.RegisterType((*ContainerStatsResponse)(nil), "runtime.v1.ContainerStatsResponse")
	proto.RegisterType((*ListContainerStatsRequest)(nil), "runtime.v1.ListContainerStatsRequest")
	proto.RegisterType((*ContainerStatsFilter)(nil), "runtime.v1.ContainerStatsFilter")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.ContainerStatsFilter.LabelSelectorEntry")
	proto.RegisterType((*ListContainerStatsResponse)(nil), "runtime.v1.ListContainerStatsResponse")
	proto.RegisterType((*ContainerAttributes)(nil), "runtime.v1.ContainerAttributes")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.ContainerAttributes.AnnotationsEntry")
	proto.RegisterMapType((map[string]string)(nil), "runtime.v1.ContainerAttributes.LabelsEntry")
	proto.RegisterType((*ContainerStats)(nil), "runtime.v1.ContainerStats")
	proto.RegisterType((*WindowsContainerStats)(nil), "runtime.v1.WindowsContainerStats")
	proto.RegisterType((*CpuUsage)(nil), "runtime.v1.CpuUsage")
	proto.RegisterType((*WindowsCpuUsage)(nil), "runtime.v1.WindowsCpuUsage")
	proto.RegisterType((*MemoryUsage)(nil), "runtime.v1.MemoryUsage")
	proto.RegisterType((*SwapUsage)(nil), "runtime.v1.SwapUsage")
	proto.RegisterType((*WindowsMemoryUsage)(nil), "runtime.v1.WindowsMemoryUsage")
	proto.RegisterType((*ReopenContainerLogRequest)(nil), "runtime.v1.ReopenContainerLogRequest")
	proto.RegisterType((*ReopenContainerLogResponse)(nil), "runtime.v1.ReopenContainerLogResponse")
	proto.RegisterType((*CheckpointContainerRequest)(nil), "runtime.v1.CheckpointContainerRequest")
	proto.RegisterType((*CheckpointContainerResponse)(nil), "runtime.v1.CheckpointContainerResponse")
	proto.RegisterType((*GetEventsRequest)(nil), "runtime.v1.GetEventsRequest")
	proto.RegisterType((*ContainerEventResponse)(nil), "runtime.v1.ContainerEventResponse")
	proto.RegisterType((*ListMetricDescriptorsRequest)(nil), "runtime.v1.ListMetricDescriptorsRequest")
	proto.RegisterType((*ListMetricDescriptorsResponse)(nil), "runtime.v1.ListMetricDescriptorsResponse")
	proto.RegisterType((*MetricDescriptor)(nil), "runtime.v1.MetricDescriptor")
	proto.RegisterType((*ListPodSandboxMetricsRequest)(nil), "runtime.v1.ListPodSandboxMetricsRequest")
	proto.RegisterType((*ListPodSandboxMetricsResponse)(nil), "runtime.v1.ListPodSandboxMetricsResponse")
	proto.RegisterType((*PodSandboxMetrics)(nil), "runtime.v1.PodSandboxMetrics")
	proto.RegisterType((*ContainerMetrics)(nil), "runtime.v1.ContainerMetrics")
	proto.RegisterType((*Metric)(nil), "runtime.v1.Metric")
	proto.RegisterType((*RuntimeConfigRequest)(nil), "runtime.v1.RuntimeConfigRequest")
	proto.RegisterType((*RuntimeConfigResponse)(nil), "runtime.v1.RuntimeConfigResponse")
	proto.RegisterType((*LinuxRuntimeConfiguration)(nil), "runtime.v1.LinuxRuntimeConfiguration")
}

func init() { proto.RegisterFile("api.proto", fileDescriptor_00212fb1f9d3bf1c) }

var fileDescriptor_00212fb1f9d3bf1c = []byte{
	// 7085 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x7d, 0x5b, 0x6c, 0x1c, 0xc9,
	0x75, 0x28, 0x7b, 0x66, 0x48, 0xce, 0x9c, 0xe1, 0x90, 0xc3, 0x12, 0x45, 0x52, 0xa3, 0x77, 0xef,
	0x4b, 0xd2, 0xae, 0x1e, 0xab, 0xd5, 0xee, 0x4a, 0xda, 0x97, 0x46, 0x24, 0xa5, 0x9d, 0xb5, 0x48,
	0x8e, 0x7b, 0xc8, 0xb5, 0x77, 0x7d, 0xe1, 0xbe, 0xad, 0xe9, 0xe2, 0xb0, 0x57, 0x33, 0xdd, 0xed,
	0xee, 0x1e, 0x49, 0xf4, 0xc7, 0xc5, 0xfd, 0xba, 0xb8, 0xf1, 0x97, 0x81, 0xc4, 0x08, 0x62, 0x04,
	0x09, 0x1c, 0x20, 0x48, 0xfe, 0x92, 0x18, 0x48, 0xe2, 0x20, 0x01, 0x02, 0x04, 0x89, 0xe1, 0x04,
	0x08, 0x90, 0x8f, 0x04, 0xf0, 0x47, 0x80, 0xd8, 0x9b, 0x00, 0x01, 0xf2, 0x19, 0xf8, 0x23, 0x3f,
	0x89, 0x83, 0x7a, 0x75, 0x77, 0xf5, 0x63, 0x66, 0xc8, 0xdd, 0xec, 0xae, 0xbf, 0x38, 0x5d, 0x75,
	0xce, 0xa9, 0x53, 0xa7, 0x4e, 0x9d, 0x3a, 0xa7, 0xea, 0x54, 0x11, 0x2a, 0x86, 0x6b, 0x5d, 0x71,
	0x3d, 0x27, 0x70, 0x10, 0x78, 0x43, 0x3b, 0xb0, 0x06, 0xf8, 0xca, 0xe3, 0x97, 0x1b, 0x97, 0x7b,
	0x56, 0xb0, 0x3f, 0x7c, 0x78, 0xa5, 0xeb, 0x0c, 0xae, 0xf6, 0x9c, 0x9e, 0x73, 0x95, 0x82, 0x3c,
	0x1c, 0xee, 0xd1, 0x2f, 0xfa, 0x41, 0x7f, 0x31, 0x54, 0xf5, 0x12, 0xcc, 0xbf, 0x8f, 0x3d, 0xdf,
	0x72, 0x6c, 0x0d, 0x7f, 0x63, 0x88, 0xfd, 0x00, 0xad, 0xc2, 0xec, 0x63, 0x56, 0xb2, 0xaa, 0x9c,
	0x53, 0x2e, 0x54, 0x34, 0xf1, 0xa9, 0xfe, 0x8e, 0x02, 0x0b, 0x21, 0xb0, 0xef, 0x3a, 0xb6, 0x8f,
	0xf3, 0xa1, 0xd1, 0x79, 0x98, 0xe3, 0x6c, 0xe9, 0xb6, 0x31, 0xc0, 0xab, 0x05, 0x5a, 0x5d, 0xe5,
	0x65, 0x5b, 0xc6, 0x00, 0xa3, 0x17, 0x60, 0x41, 0x80, 0x08, 0x22, 0x45, 0x0a, 0x35, 0xcf, 0x8b,
	0x79, 0x6b, 0xe8, 0x0a, 0x1c, 0x13, 0x80, 0x86, 0x6b, 0x85, 0xc0, 0x25, 0x0a, 0xbc, 0xc8, 0xab,
	0x9a, 0xae, 0xc5, 0xe1, 0xd5, 0xaf, 0x41, 0x65, 0x7d, 0xab, 0xb3, 0xe6, 0xd8, 0x7b, 0x56, 0x8f,
	0xb0, 0xe8, 0x63, 0x8f, 0xe0, 0xac, 0x2a, 0xe7, 0x8a, 0x84, 0x45, 0xfe, 0x89, 0x1a, 0x50, 0xf6,
	0xb1, 0xe1, 0x75, 0xf7, 0xb1, 0xbf, 0x5a, 0xa0, 0x55, 0xe1, 0x37, 0xc1, 0x72, 0xdc, 0xc0, 0x72,
	0x6c, 0x7f, 0xb5, 0xc8, 0xb0, 0xf8, 0xa7, 0xfa, 0xeb, 0x0a, 0x54, 0xdb, 0x8e, 0x17, 0x6c, 0x1a,
	0xae, 0x6b, 0xd9, 0x3d, 0x74, 0x0d, 0xca, 0x54, 0x96, 0x5d, 0xa7, 0x4f, 0x65, 0x30, 0x7f, 0x7d,
	0xe9, 0x4a, 0x34, 0x20, 0x57, 0xda, 0xbc, 0x4e, 0x0b, 0xa1, 0xd0, 0x73, 0x30, 0xdf, 0x75, 0xec,
	0xc0, 0xb0, 0x6c, 0xec, 0xe9, 0xae, 0xe3, 0x05, 0x54, 0x38, 0xd3, 0x5a, 0x2d, 0x2c, 0x25, 0xf4,
	0xd1, 0x49, 0xa8, 0xec, 0x3b, 0x7e, 0xc0, 0x20, 0x8a, 0x14, 0xa2, 0x4c, 0x0a, 0x68, 0xe5, 0x0a,
	0xcc, 0xd2, 0x4a, 0xcb, 0xe5, 0x62, 0x98, 0x21, 0x9f, 0x2d, 0x57, 0xfd, 0xf7, 0x02, 0x4c, 0x6f,
	0x3a, 0x43, 0x3b, 0x48, 0x34, 0x63, 0x04, 0xfb, 0x7c, 0x88, 0x62, 0xcd, 0x18, 0xc1, 0x7e, 0xd4,
	0x0c, 0x81, 0x60, 0xa3, 0xc4, 0x9a, 0x21, 0x95, 0x0d, 0x28, 0x7b, 0xd8, 0x30, 0x1d, 0xbb, 0x7f,
	0x40, 0x59, 0x28, 0x6b, 0xe1, 0x37, 0x19, 0x3e, 0x1f, 0xf7, 0x2d, 0x7b, 0xf8, 0x54, 0xf7, 0x70,
	0xdf, 0x78, 0x88, 0xfb, 0x94, 0x95, 0xb2, 0x36, 0xcf, 0x8b, 0x35, 0x56, 0x8a, 0xde, 0x86, 0xaa,
	0xeb, 0x39, 0xae, 0xd1, 0x33, 0x88, 0x04, 0x57, 0xa7, 0xa9, 0x90, 0x4e, 0xc5, 0x85, 0x44, 0x19,
	0x6e, 0x47, 0x30, 0x5a, 0x1c, 0x01, 0xbd, 0x0e, 0xd5, 0xa1, 0x65, 0x72, 0x79, 0xfb, 0xab, 0x33,
	0xe7, 0x8a, 0x17, 0xaa, 0xd7, 0x8f, 0xc7, 0xf1, 0x5b, 0xeb, 0xbc, 0x56, 0x8b, 0x43, 0x12, 0xc4,
	0x5e, 0x0c, 0x71, 0x76, 0x24, 0x62, 0x0c, 0x92, 0x2a, 0x1c, 0xee, 0x0e, 0x3d, 0xdf, 0x7a, 0x8c,
	0x75, 0xd2, 0x61, 0x9d, 0x4a, 0xa0, 0x4c, 0xbb, 0xb7, 0x18, 0x56, 0x69, 0xd8, 0x30, 0xb7, 0xed,
	0xfe, 0x81, 0xaa, 0x43, 0x25, 0xa4, 0x14, 0x0d, 0x8d, 0x49, 0x05, 0x5e, 0xe3, 0x43, 0x63, 0x92,
	0x29, 0x11, 0x0d, 0x88, 0x65, 0x52, 0x61, 0xd7, 0xb4, 0x6a, 0x58, 0xd6, 0x32, 0xd1, 0x32, 0xcc,
	0xf4, 0xb1, 0xdd, 0x0b, 0xf6, 0xa9, 0xb4, 0x6b, 0x1a, 0xff, 0x52, 0x7f, 0x45, 0x81, 0xda, 0xae,
	0x8f, 0x3d, 0x32, 0x6f, 0x7c, 0xd7, 0xe8, 0x62, 0x74, 0x19, 0x4a, 0x03, 0xc7, 0xc4, 0x5c, 0xe5,
	0x4e, 0xc4, 0x3b, 0x15, 0x02, 0x6d, 0x3a, 0x26, 0xd6, 0x28, 0x18, 0xba, 0x08, 0xa5, 0xa1, 0x65,
	0x32, 0x3d, 0xcf, 0x95, 0x01, 0x05, 0x21, 0xa0, 0x3d, 0x02, 0x5a, 0x1c, 0x09, 0x4a, 0x40, 0xd4,
	0x9f, 0x2b, 0xb0, 0x10, 0xb6, 0xb6, 0x4d, 0x27, 0x08, 0x7a, 0x05, 0x66, 0x6d, 0x1c, 0x3c, 0x71,
	0xbc, 0x47, 0xe3, 0x79, 0x13, 0x90, 0xe8, 0x45, 0x28, 0xba, 0x5c, 0x22, 0x23, 0x11, 0x08, 0x14,
	0x01, 0xb6, 0xdc, 0x2e, 0x95, 0xd0, 0x68, 0x60, 0xcb, 0xed, 0x12, 0xf5, 0x0e, 0x0c, 0xaf, 0x87,
	0xe9, 0x78, 0xb0, 0xa9, 0x52, 0x66, 0x05, 0x2d, 0x13, 0xdd, 0x81, 0xf9, 0xa1, 0x8f, 0x3d, 0xdb,
	0xd7, 0xc5, 0x64, 0x27, 0xca, 0x59, 0x95, 0x89, 0x4a, 0x72, 0xd7, 0x6a, 0x0c, 0x61, 0x9b, 0x5b,
	0x03, 0x15, 0xa0, 0x65, 0x07, 0xaf, 0xdd, 0x78, 0xdf, 0xe8, 0x0f, 0x31, 0x5a, 0x82, 0xe9, 0xc7,
	0xe4, 0x07, 0xed, 0x79, 0x51, 0x63, 0x1f, 0xea, 0xf7, 0xa6, 0xe1, 0xe4, 0x03, 0x32, 0x21, 0x3a,
	0x86, 0x6d, 0x3e, 0x74, 0x9e, 0x76, 0x88, 0xfe, 0x58, 0xc1, 0xc1, 0x9a, 0x63, 0x07, 0xf8, 0x69,
	0x80, 0xde, 0x85, 0x45, 0x5b, 0xd0, 0x0f, 0x19, 0x51, 0x28, 0x23, 0x27, 0x33, 0x7b, 0xc7, 0x1a,
	0xd7, 0xea, 0xb6, 0x5c, 0xe0, 0xa3, 0xbb, 0xd1, 0x94, 0x14, 0x74, 0x0a, 0xe9, 0x0e, 0x75, 0x36,
	0x28, 0x37, 0x9c, 0x8a, 0x98, 0xad, 0x82, 0xc6, 0x6b, 0x40, 0x8c, 0xb4, 0x6e, 0xf8, 0x3a, 0xe9,
	0x29, 0x95, 0x72, 0xf5, 0xfa, 0xb2, 0xa4, 0x05, 0x61, 0x87, 0xb5, 0x8a, 0x37, 0xb4, 0x9b, 0x3e,
	0x91, 0x10, 0xba, 0x49, 0x0d, 0x3e, 0xc1, 0xeb, 0x79, 0xce, 0xd0, 0xa5, 0x93, 0x25, 0x1f, 0x11,
	0x28, 0xe2, 0x7d, 0x02, 0x49, 0xd7, 0x01, 0x6e, 0x54, 0x74, 0xcf, 0x71, 0x82, 0x3d, 0x5f, 0x18,
	0x12, 0x51, 0xac, 0xd1, 0x52, 0x74, 0x15, 0x8e, 0xf9, 0x43, 0xd7, 0xed, 0xe3, 0x01, 0xb6, 0x03,
	0xa3, 0xcf, 0x1a, 0x22, 0x63, 0x56, 0xbc, 0x50, 0xd4, 0x50, 0xbc, 0x8a, 0x12, 0xf6, 0xd1, 0x43,
	0x68, 0x64, 0x20, 0xe8, 0xae, 0xd3, 0xb7, 0xba, 0x07, 0xab, 0x55, 0xaa, 0x40, 0xcf, 0x4a, 0xa2,
	0x49, 0xd1, 0x68, 0x53, 0x58, 0x6d, 0xd5, 0xcf, 0xa9, 0x41, 0x67, 0x00, 0x5c, 0xcf, 0x7a, 0x6c,
	0xf5, 0x71, 0x0f, 0x9b, 0xab, 0x33, 0x94, 0xf1, 0x58, 0x09, 0x7a, 0x95, 0xac, 0x3f, 0xdd, 0xae,
	0x33, 0x70, 0x57, 0x2b, 0xe9, 0x31, 0x15, 0xba, 0xd0, 0xf6, 0x9c, 0x3d, 0xab, 0x8f, 0x35, 0x01,
	0x8b, 0x5e, 0x87, 0xb2, 0xe1, 0xba, 0x86, 0x37, 0x70, 0xbc, 0x55, 0x18, 0x8f, 0x17, 0x02, 0xa3,
	0x1b, 0xb0, 0xc4, 0x69, 0xe8, 0x2e, 0xab, 0x64, 0xa6, 0x7d, 0x96, 0xe8, 0xfe, 0xdd, 0xc2, 0xaa,
	0xa2, 0x21, 0x5e, 0xcf, 0x71, 0x89, 0xa1, 0x57, 0xff, 0x52, 0x81, 0x85, 0x04, 0x4d, 0xf4, 0x1e,
	0xcc, 0x09, 0x0a, 0xc1, 0x81, 0x2b, 0x4c, 0xcd, 0x0b, 0x23, 0xd8, 0xb8, 0xc2, 0xff, 0xee, 0x1c,
	0xb8, 0x98, 0xda, 0x70, 0xf1, 0x81, 0x9e, 0x81, 0x5a, 0xdf, 0xe9, 0x1a, 0x7d, 0x6a, 0x19, 0x3d,
	0xbc, 0xc7, 0x57, 0x9a, 0xb9, 0xb0, 0x50, 0xc3, 0x7b, 0xea, 0x1d, 0xa8, 0xc6, 0x08, 0x20, 0x04,
	0xf3, 0x1a, 0x6b, 0x6a, 0x1d, 0xef, 0x19, 0xc3, 0x7e, 0x50, 0x9f, 0x42, 0xf3, 0x00, 0xbb, 0x76,
	0x97, 0xac, 0xec, 0x36, 0x36, 0xeb, 0x0a, 0xaa, 0x41, 0xe5, 0x81, 0x20, 0x51, 0x2f, 0xa8, 0xdf,
	0x2d, 0xc2, 0x71, 0xaa, 0xdc, 0x6d, 0xc7, 0xe4, 0xb3, 0x8d, 0xbb, 0x01, 0xcf, 0x40, 0xad, 0x4b,
	0x87, 0x5f, 0x77, 0x0d, 0x0f, 0xdb, 0x01, 0x5f, 0x0c, 0xe7, 0x58, 0x61, 0x9b, 0x96, 0x21, 0x0d,
	0xea, 0x3e, 0xef, 0x91, 0xde, 0x65, 0xb3, 0x93, 0x4f, 0x20, 0xa9, 0xd7, 0x23, 0x26, 0xb3, 0xb6,
	0xe0, 0xa7, 0x66, 0xf7, 0xac, 0x7f, 0xe0, 0x77, 0x83, 0xbe, 0xb0, 0xa8, 0x57, 0x52, 0xa4, 0x92,
	0xcc, 0x5e, 0xe9, 0x30, 0x84, 0x0d, 0x3b, 0xf0, 0x0e, 0x34, 0x81, 0x8e, 0xde, 0x81, 0xb2, 0xf3,
	0x18, 0x7b, 0xfb, 0xd8, 0x60, 0x96, 0xac, 0x7a, 0xfd, 0x99, 0x14, 0xa9, 0x35, 0xb1, 0x98, 0x68,
	0xd8, 0x77, 0x86, 0x5e, 0x17, 0xfb, 0x5a, 0x88, 0x84, 0x9a, 0x50, 0xf1, 0x44, 0x31, 0xb7, 0x74,
	0x13, 0x51, 0x88, 0xb0, 0x1a, 0xb7, 0x61, 0x2e, 0xce, 0x1c, 0xaa, 0x43, 0xf1, 0x11, 0x3e, 0xe0,
	0xc2, 0x24, 0x3f, 0x23, 0x1b, 0xc8, 0x46, 0x98, 0x7d, 0xdc, 0x2e, 0xdc, 0x54, 0x54, 0x0f, 0x50,
	0xd4, 0xd3, 0x4d, 0x1c, 0x18, 0xa6, 0x11, 0x18, 0x08, 0x41, 0x89, 0x3a, 0x88, 0x8c, 0x04, 0xfd,
	0x4d, 0xa8, 0x0e, 0xf9, 0x72, 0x50, 0xd1, 0xc8, 0x4f, 0x74, 0x0a, 0x2a, 0xa1, 0xb5, 0xe3, 0x5e,
	0x62, 0x54, 0x40, 0xbc, 0x35, 0x23, 0x08, 0xf0, 0xc0, 0x0d, 0xa8, 0x60, 0x6a, 0x9a, 0xf8, 0x54,
	0x7f, 0x69, 0x1a, 0xea, 0x29, 0x5d, 0xb8, 0x0d, 0xe5, 0x01, 0x6f, 0x9e, 0xdb, 0xd9, 0x33, 0x92,
	0xcb, 0x96, 0x62, 0x52, 0x0b, 0xe1, 0x89, 0x47, 0x44, 0x74, 0x2d, 0xe6, 0xd3, 0x86, 0xdf, 0x4c,
	0xc9, 0x7b, 0xba, 0x69, 0x79, 0xb8, 0x1b, 0x38, 0xde, 0x01, 0x67, 0x74, 0xae, 0xef, 0xf4, 0xd6,
	0x45, 0x19, 0xba, 0x01, 0x60, 0xda, 0xbe, 0x4e, 0x75, 0xb8, 0xc7, 0xc7, 0x51, 0x5a, 0x64, 0x43,
	0xd7, 0x55, 0xab, 0x98, 0xb6, 0xcf, 0x59, 0x7e, 0x13, 0x6a, 0xc4, 0x0f, 0xd4, 0x07, 0xc2, 0x99,
	0x99, 0xa6, 0xba, 0xb4, 0x22, 0xf3, 0x1d, 0x7a, 0xa5, 0xda, 0x9c, 0x1b, 0x7d, 0xf8, 0xe8, 0x0e,
	0xcc, 0x50, 0x57, 0x4c, 0x38, 0x4f, 0x17, 0xb2, 0xbb, 0xcb, 0xb5, 0xef, 0x01, 0x05, 0x65, 0xca,
	0xc7, 0xf1, 0xd0, 0x36, 0x54, 0x0d, 0xdb, 0x76, 0x02, 0x83, 0xad, 0x2a, 0xcc, 0x95, 0xba, 0x3c,
	0x92, 0x4c, 0x33, 0x82, 0x67, 0xb4, 0xe2, 0x14, 0xd0, 0xeb, 0x30, 0x4d, 0x97, 0x1d, 0xbe, 0x4e,
	0x9c, 0x1f, 0x3b, 0x29, 0x34, 0x06, 0x8f, 0xde, 0x82, 0xd9, 0x27, 0x96, 0x6d, 0x3a, 0x4f, 0x7c,
	0x6e, 0x4f, 0x25, 0x15, 0xfe, 0x0a, 0xab, 0x4a, 0x21, 0x0b, 0x9c, 0xc6, 0x2d, 0xa8, 0xc6, 0xfa,
	0x77, 0x18, 0xfd, 0x6d, 0xbc, 0x0d, 0xf5, 0x64, 0x9f, 0x0e, 0xa5, 0xff, 0x43, 0x58, 0xd2, 0x86,
	0x76, 0xc4, 0x9a, 0x08, 0xb9, 0x6e, 0xc0, 0x0c, 0xd7, 0x06, 0xa6, 0x8c, 0xa7, 0x46, 0x89, 0x55,
	0xe3, 0xb0, 0xf1, 0xe8, 0x69, 0xdf, 0xb0, 0xcd, 0x3e, 0xf6, 0x78, 0x8b, 0x22, 0x7a, 0x7a, 0x97,
	0x95, 0xaa, 0x6f, 0xc1, 0xf1, 0x44, 0xb3, 0x3c, 0x78, 0x7b, 0x16, 0xe6, 0x5d, 0xc7, 0xd4, 0x7d,
	0x56, 0x2c, 0xfc, 0xd5, 0x0a, 0xd1, 0x1d, 0x01, 0xdb, 0x32, 0x09, 0x7a, 0x27, 0x70, 0xdc, 0x34,
	0xdb, 0x93, 0xa1, 0xaf, 0xc2, 0x72, 0x12, 0x9d, 0x35, 0xaf, 0xbe, 0x03, 0x2b, 0x1a, 0x1e, 0x38,
	0x8f, 0xf1, 0x51, 0x49, 0x37, 0x60, 0x35, 0x4d, 0x80, 0x13, 0xff, 0x00, 0x56, 0xa2, 0xd2, 0x4e,
	0x60, 0x04, 0x43, 0xff, 0x50, 0xc4, 0x79, 0x64, 0xfb, 0xd0, 0xf1, 0xd9, 0x40, 0x96, 0x35, 0xf1,
	0xa9, 0xae, 0xc0, 0x74, 0xdb, 0x31, 0x5b, 0x6d, 0x34, 0x0f, 0x05, 0xcb, 0xe5, 0xc8, 0x05, 0xcb,
	0x55, 0xbb, 0xf1, 0x36, 0xb7, 0x98, 0x67, 0xcb, 0x9a, 0x4e, 0x82, 0xa2, 0x9b, 0x30, 0x6f, 0x98,
	0xa6, 0x45, 0x14, 0xc9, 0xe8, 0xeb, 0x96, 0x2b, 0x1c, 0xf3, 0xc5, 0xc4, 0xd0, 0xb7, 0xda, 0x5a,
	0x2d, 0x02, 0x6c, 0xb9, 0xbe, 0x7a, 0x17, 0x2a, 0x51, 0x10, 0xf0, 0x6a, 0x14, 0xa5, 0x16, 0xc6,
	0xfb, 0x8b, 0x61, 0x08, 0xbb, 0x95, 0x5a, 0x24, 0x39, 0x9b, 0xaf, 0x02, 0x84, 0x46, 0x55, 0xb8,
	0xa0, 0xc7, 0x33, 0x49, 0x6a, 0x31, 0x40, 0xf5, 0x9f, 0x4a, 0x71, 0x23, 0x1b, 0xeb, 0xb2, 0x19,
	0x76, 0xd9, 0x94, 0x8c, 0x6e, 0xe1, 0x90, 0x46, 0xf7, 0x65, 0x98, 0xf6, 0x03, 0x23, 0xc0, 0xdc,
	0xe7, 0x3f, 0x99, 0x8d, 0x48, 0x1a, 0xc6, 0x1a, 0x83, 0x44, 0xa7, 0x01, 0xba, 0x1e, 0x36, 0x02,
	0x6c, 0xea, 0x06, 0x5b, 0x15, 0x8a, 0x5a, 0x85, 0x97, 0x34, 0x03, 0x62, 0x45, 0x44, 0x94, 0x92,
	0xb1, 0x10, 0xe6, 0x0c, 0x63, 0x14, 0xaf, 0x84, 0xd6, 0x6b, 0x66, 0xac, 0xf5, 0xe2, 0xa8, 0xdc,
	0x7a, 0x45, 0x96, 0x78, 0x76, 0x94, 0x25, 0x66, 0x48, 0x93, 0x58, 0xe2, 0xf2, 0x28, 0x4b, 0xcc,
	0xc9, 0x8c, 0xb6, 0xc4, 0x19, 0x86, 0xa4, 0x92, 0x65, 0x48, 0x3e, 0x4f, 0xd3, 0xf9, 0x27, 0x05,
	0x58, 0x4d, 0xcf, 0x67, 0x6e, 0xc7, 0x6e, 0xc0, 0x8c, 0x4f, 0x4b, 0x46, 0xdb, 0x4f, 0x8e, 0xc5,
	0x61, 0xd1, 0x5d, 0x28, 0x59, 0xf6, 0x9e, 0xc3, 0x27, 0xde, 0x95, 0x91, 0x38, 0xbc, 0xa5, 0x2b,
	0x2d, 0x7b, 0xcf, 0x61, 0x12, 0xa4, 0xb8, 0xe8, 0x01, 0x1c, 0x0b, 0xa3, 0x77, 0x5f, 0x67, 0x84,
	0xb1, 0xf0, 0xf3, 0x24, 0x2d, 0x0d, 0xbd, 0x2a, 0x4e, 0x11, 0x45, 0x78, 0x1d, 0x8e, 0x46, 0x7c,
	0x1c, 0x02, 0xee, 0x07, 0xc6, 0xc0, 0x15, 0x1a, 0x1b, 0x16, 0x34, 0x5e, 0x87, 0x4a, 0xd8, 0xfc,
	0xa1, 0x64, 0xd7, 0x82, 0xa5, 0xc4, 0x1c, 0x61, 0xc1, 0x6a, 0x38, 0xa9, 0x94, 0x49, 0x27, 0x95,
	0xfa, 0x33, 0x25, 0x3e, 0xd1, 0xef, 0x59, 0xfd, 0x00, 0x7b, 0xa9, 0x89, 0xfe, 0x9a, 0xa0, 0xcb,
	0x66, 0xf9, 0xb9, 0x11, 0x74, 0x59, 0x2c, 0xc8, 0x67, 0xec, 0xfb, 0x30, 0x4f, 0x55, 0x5c, 0xf7,
	0x71, 0x9f, 0xfa, 0x4a, 0x5c, 0x8e, 0x57, 0xb3, 0x09, 0xb0, 0xd6, 0xd9, 0x14, 0xe9, 0x70, 0x0c,
	0x36, 0x36, 0xb5, 0x7e, 0xbc, 0xac, 0x71, 0x07, 0x50, 0x1a, 0xe8, 0x50, 0x12, 0xdc, 0x24, 0xf6,
	0xd2, 0x0f, 0x32, 0x57, 0xee, 0x3d, 0xca, 0xc6, 0x68, 0xcd, 0x63, 0xac, 0x6a, 0x1c, 0x56, 0xfd,
	0x87, 0x22, 0x40, 0x54, 0xf9, 0x05, 0x37, 0x94, 0xb7, 0x43, 0x83, 0xc5, 0x3c, 0x4e, 0x35, 0x9b,
	0x64, 0xa6, 0xa9, 0x6a, 0xc9, 0xa6, 0x8a, 0xf9, 0x9e, 0x2f, 0xe4, 0x10, 0x38, 0xb4, 0x91, 0x9a,
	0xfd, 0xa2, 0x19, 0xa9, 0x7b, 0xb0, 0x9c, 0x54, 0x13, 0x6e, 0xa1, 0x5e, 0x82, 0x69, 0x2b, 0xc0,
	0x03, 0xb6, 0x03, 0x9d, 0xd8, 0x14, 0x89, 0x81, 0x33, 0x20, 0xf5, 0x6d, 0x58, 0x96, 0xc7, 0xea,
	0x70, 0xae, 0x8b, 0xfa, 0x20, 0xe9, 0xfb, 0x44, 0xa6, 0x92, 0xeb, 0x47, 0xe6, 0xf6, 0x52, 0x12,
	0x87, 0x41, 0xaa, 0x3f, 0x54, 0xe0, 0x78, 0xa2, 0x2a, 0x67, 0xe2, 0x7f, 0x2d, 0x35, 0x81, 0x99,
	0x6d, 0xbd, 0x31, 0xa2, 0x95, 0xcf, 0x70, 0x16, 0x7f, 0x05, 0x1a, 0xf2, 0xf0, 0x48, 0xa2, 0xbd,
	0x95, 0x98, 0xca, 0xe7, 0xc7, 0x32, 0x1d, 0xce, 0xe7, 0x36, 0x9c, 0xcc, 0x24, 0x9c, 0x96, 0x79,
	0x71, 0x42, 0x99, 0xff, 0x47, 0x21, 0x6e, 0xb3, 0x9b, 0x41, 0xe0, 0x59, 0x0f, 0x87, 0x01, 0xfe,
	0x74, 0x9d, 0xaa, 0xf5, 0x70, 0x66, 0x33, 0x3b, 0xfb, 0x52, 0x36, 0x66, 0xd4, 0x7a, 0xe6, 0x1c,
	0xef, 0xc8, 0x73, 0xbc, 0x44, 0x49, 0xbd, 0x3c, 0x96, 0xd4, 0xc8, 0xd9, 0xfe, 0x79, 0x4e, 0xe2,
	0xbf, 0x56, 0x60, 0x21, 0x31, 0x2a, 0xe8, 0x0e, 0x80, 0x11, 0xb2, 0xce, 0xf5, 0xe3, 0xdc, 0xb8,
	0x2e, 0x6a, 0x31, 0x1c, 0xb2, 0x26, 0x32, 0x7f, 0x31, 0x63, 0x4d, 0xcc, 0xf0, 0x17, 0x43, 0x77,
	0xf1, 0xcd, 0x28, 0xd8, 0x65, 0x1b, 0xb1, 0xea, 0xc8, 0x60, 0x97, 0xe1, 0x0a, 0x14, 0xf5, 0x97,
	0x0b, 0xb0, 0x94, 0x45, 0x1d, 0x3d, 0x0f, 0xc5, 0xae, 0x3b, 0xe4, 0x3d, 0x91, 0x8e, 0xab, 0xd6,
	0xdc, 0xe1, 0xae, 0x6f, 0xf4, 0xb0, 0x46, 0x00, 0xd0, 0x55, 0x98, 0x19, 0xe0, 0x81, 0xe3, 0x1d,
	0x70, 0xbe, 0xa5, 0xed, 0x86, 0x4d, 0x5a, 0xc3, 0xa0, 0x39, 0x18, 0xba, 0x1e, 0xb9, 0xd5, 0x8c,
	0xdf, 0x55, 0x29, 0x7a, 0x60, 0x55, 0x0c, 0x25, 0xf4, 0xa5, 0xaf, 0xc3, 0xac, 0xeb, 0x39, 0x5d,
	0xec, 0xfb, 0x7c, 0x37, 0x64, 0x35, 0x71, 0x7e, 0x46, 0xaa, 0x38, 0x0e, 0x07, 0x44, 0xb7, 0x01,
	0x22, 0x07, 0x8a, 0xaf, 0x4c, 0x8d, 0x5c, 0x7f, 0xcb, 0xd7, 0x62, 0xd0, 0xea, 0x0f, 0x0a, 0xb0,
	0x9c, 0x2d, 0x39, 0x74, 0x39, 0x2e, 0x97, 0x93, 0x19, 0xa2, 0x96, 0xc5, 0xf3, 0x5a, 0x42, 0x3c,
	0x67, 0x32, 0x30, 0xb2, 0xa4, 0x74, 0x2b, 0x29, 0xa5, 0xb3, 0x19, 0x88, 0xd9, 0xc2, 0xba, 0x95,
	0x14, 0x56, 0x16, 0x6a, 0xb6, 0xcc, 0x9a, 0x19, 0x32, 0x3b, 0x9f, 0xd5, 0xc7, 0x7c, 0xd1, 0xfd,
	0xb9, 0x02, 0x73, 0x71, 0xbe, 0x64, 0x97, 0x55, 0x49, 0xb8, 0xac, 0x68, 0x0b, 0x16, 0x4d, 0xb6,
	0x73, 0xab, 0x5b, 0x76, 0x80, 0xbd, 0x3d, 0xa3, 0x2b, 0xbc, 0xc2, 0xf3, 0x19, 0x7a, 0xd1, 0x12,
	0x30, 0x8c, 0xf1, 0x3a, 0xc7, 0x0d, 0x8b, 0x49, 0x0f, 0x42, 0x3a, 0xc2, 0x6a, 0x4d, 0x40, 0x28,
	0x86, 0xa4, 0xfe, 0xbd, 0x02, 0xc7, 0x32, 0x04, 0x3c, 0xa6, 0x23, 0xbb, 0xf9, 0x1d, 0xb9, 0x90,
	0x3f, 0x74, 0x63, 0xfb, 0xf3, 0x6e, 0x46, 0x7f, 0x26, 0xa7, 0x17, 0xef, 0xd6, 0xcf, 0x15, 0x38,
	0x9e, 0x09, 0x95, 0xb9, 0xbd, 0x7a, 0x1d, 0xca, 0xde, 0x53, 0xfd, 0xe1, 0x41, 0x80, 0xfd, 0xac,
	0x89, 0xbd, 0x1b, 0x3b, 0xa7, 0x99, 0xf5, 0x9e, 0xde, 0x25, 0x70, 0xe8, 0x06, 0x54, 0xbc, 0xa7,
	0x3a, 0xf6, 0x3c, 0xc7, 0x13, 0xb6, 0x28, 0x17, 0xa9, 0xec, 0x3d, 0xdd, 0xa0, 0x80, 0xa4, 0xa5,
	0x40, 0xb4, 0x54, 0x1a, 0xd3, 0x52, 0x10, 0xb5, 0x14, 0x84, 0x2d, 0x4d, 0x8f, 0x69, 0x29, 0xe0,
	0x2d, 0xa9, 0xbf, 0x5b, 0x80, 0x53, 0xa3, 0xc4, 0xf5, 0xa9, 0x09, 0x62, 0x03, 0x90, 0xf7, 0x54,
	0x77, 0x8d, 0xee, 0x23, 0x1c, 0xf8, 0xba, 0xe9, 0x39, 0xae, 0x8b, 0xcd, 0x71, 0x12, 0xa9, 0x7b,
	0x4f, 0xdb, 0x0c, 0x63, 0x9d, 0x21, 0x1c, 0x49, 0x32, 0x1b, 0x80, 0x82, 0x74, 0xd3, 0x63, 0x44,
	0x54, 0x0f, 0x12, 0x4d, 0xab, 0x1f, 0xc1, 0x5c, 0xdc, 0x42, 0x8c, 0xd1, 0xfd, 0x37, 0xa1, 0xc6,
	0x2d, 0x88, 0xde, 0x75, 0x86, 0x76, 0x30, 0x4e, 0x50, 0x73, 0x1c, 0x7a, 0x8d, 0x00, 0xab, 0xdf,
	0x08, 0xa7, 0xdb, 0x67, 0xd6, 0xe4, 0xff, 0x2b, 0x40, 0xa5, 0x35, 0x30, 0x7a, 0xb8, 0xe3, 0xe2,
	0x2e, 0x59, 0xe9, 0x2d, 0xf2, 0xc1, 0xc7, 0x9d, 0x7d, 0xa0, 0x77, 0x65, 0xaf, 0x85, 0xf9, 0xa9,
	0xcf, 0x4b, 0x67, 0x95, 0x82, 0xc2, 0x98, 0xc0, 0xe4, 0x1a, 0x2c, 0x0d, 0x7d, 0xec, 0xe9, 0xbe,
	0x8b, 0xbb, 0xd6, 0x9e, 0x85, 0x4d, 0x9d, 0x35, 0x87, 0x68, 0x73, 0x88, 0xd4, 0x75, 0x44, 0x15,
	0xa5, 0x99, 0x15, 0xca, 0x1c, 0xcb, 0x0c, 0x65, 0x3e, 0xa9, 0x2b, 0x73, 0x1d, 0xca, 0x5f, 0xc2,
	0x07, 0x2c, 0xd8, 0x9f, 0x10, 0x4f, 0xfd, 0x4e, 0x09, 0x56, 0x72, 0x8e, 0x81, 0x68, 0xa4, 0xe8,
	0x0e, 0x75, 0x17, 0x7b, 0x96, 0x63, 0x8a, 0x51, 0xeb, 0xba, 0xc3, 0x36, 0x2d, 0x40, 0x27, 0x81,
	0x7c, 0xe8, 0xdf, 0x18, 0x3a, 0xdc, 0x19, 0x2d, 0x6a, 0xe5, 0xae, 0x3b, 0xfc, 0x32, 0xf9, 0x16,
	0xb8, 0xfe, 0xbe, 0xe1, 0x61, 0x66, 0x3f, 0x18, 0x6e, 0x87, 0x16, 0xa0, 0x97, 0xe1, 0x38, 0x5b,
	0x1b, 0xf5, 0xbe, 0x35, 0xb0, 0x88, 0x95, 0x8d, 0x4d, 0x8d, 0xa2, 0x86, 0x58, 0xe5, 0x03, 0x52,
	0xd7, 0xb2, 0xd9, 0x64, 0x50, 0xa1, 0xe6, 0x38, 0x03, 0xdd, 0xef, 0x3a, 0x1e, 0xd6, 0x0d, 0xf3,
	0x23, 0x3a, 0x0f, 0x8a, 0x5a, 0xd5, 0x71, 0x06, 0x1d, 0x52, 0xd6, 0x34, 0x3f, 0x42, 0x67, 0xa1,
	0xda, 0x75, 0x87, 0x3e, 0x0e, 0x74, 0xf2, 0x87, 0x6e, 0xd6, 0x55, 0x34, 0x60, 0x45, 0x6b, 0xee,
	0xd0, 0x8f, 0x01, 0x0c, 0x48, 0x78, 0x36, 0x1b, 0x07, 0xd8, 0xc4, 0x03, 0x7a, 0xa2, 0xbe, 0x3f,
	0xec, 0x61, 0xd7, 0xe8, 0x61, 0xc6, 0x9a, 0xd8, 0x71, 0x93, 0x4e, 0xd4, 0xdf, 0xe5, 0x20, 0x94,
	0x41, 0x6d, 0x7e, 0x3f, 0xfe, 0xe9, 0xa3, 0xf7, 0x60, 0x76, 0x68, 0x53, 0x05, 0x58, 0xad, 0x50,
	0xdc, 0x6b, 0x13, 0x1c, 0xba, 0x5d, 0xd9, 0x65, 0x28, 0xfc, 0x0c, 0x90, 0x13, 0x40, 0xb7, 0xa1,
	0xc1, 0x05, 0xe5, 0x3f, 0x31, 0xdc, 0xa4, 0xb4, 0x80, 0x8a, 0x60, 0x99, 0x41, 0x74, 0x9e, 0x18,
	0x6e, 0x5c, 0x62, 0x8d, 0xdb, 0x30, 0x17, 0x27, 0x7a, 0x28, 0x5d, 0xba, 0x0b, 0x35, 0xa9, 0x93,
	0x64, 0xb4, 0xa9, 0x50, 0x7c, 0xeb, 0x9b, 0x62, 0x6e, 0x95, 0x49, 0x41, 0xc7, 0xfa, 0x26, 0xcd,
	0x83, 0xa0, 0x9c, 0x51, 0x3a, 0x25, 0x8d, 0x7d, 0xa8, 0x06, 0xd4, 0xa4, 0xd4, 0x03, 0x62, 0x92,
	0x69, 0x8e, 0x01, 0x37, 0xc9, 0xe4, 0x37, 0x29, 0xf3, 0x9c, 0xbe, 0xe0, 0x80, 0xfe, 0x26, 0x65,
	0xf4, 0x00, 0x9a, 0x1d, 0xa7, 0xd1, 0xdf, 0xb4, 0x09, 0xfc, 0x98, 0xe7, 0x1c, 0x55, 0x34, 0xf6,
	0xa1, 0xfe, 0x86, 0x02, 0xb0, 0x66, 0xb8, 0xc6, 0x43, 0xab, 0x6f, 0x05, 0x07, 0xe8, 0x22, 0xd4,
	0x0d, 0xd3, 0xd4, 0xbb, 0xa2, 0xc4, 0xc2, 0x22, 0x09, 0x6c, 0xc1, 0x30, 0xcd, 0xb5, 0x58, 0x31,
	0x7a, 0x11, 0x16, 0x89, 0x41, 0x95, 0x61, 0x59, 0x56, 0x58, 0x9d, 0x54, 0x48, 0xc0, 0x37, 0x61,
	0x95, 0xd0, 0x35, 0x06, 0x0f, 0x2d, 0x6c, 0x07, 0x32, 0x0e, 0x4b, 0x17, 0x5b, 0x36, 0x4c, 0xb3,
	0xc9, 0xaa, 0xe3, 0x98, 0xea, 0x6f, 0xcd, 0xc2, 0x69, 0x79, 0xc4, 0x93, 0xd9, 0x20, 0xb7, 0x61,
	0x2e, 0xc1, 0x6f, 0x2a, 0x8f, 0x22, 0xea, 0xa1, 0x26, 0xc1, 0x26, 0x72, 0x11, 0x0a, 0xa9, 0x5c,
	0x84, 0xcc, 0x4c, 0x93, 0xe2, 0xa7, 0x94, 0x69, 0x52, 0xfa, 0x84, 0x99, 0x26, 0xd3, 0x47, 0xcd,
	0x34, 0x99, 0x9b, 0x38, 0xd3, 0xe4, 0x79, 0x6a, 0x7a, 0x45, 0x8b, 0xd4, 0x1d, 0x60, 0x36, 0xa1,
	0x16, 0x52, 0xb7, 0x45, 0x66, 0x62, 0x22, 0x23, 0x65, 0xf6, 0x30, 0x19, 0x29, 0xe5, 0x23, 0x66,
	0xa4, 0x2c, 0x7e, 0x2a, 0x19, 0x29, 0xe7, 0x60, 0xce, 0x76, 0x74, 0x1b, 0x3f, 0xd1, 0xc9, 0xd0,
	0xfb, 0x34, 0xcf, 0xa5, 0xac, 0x81, 0xed, 0x6c, 0xe1, 0x27, 0x6d, 0x52, 0x82, 0xce, 0xc3, 0xdc,
	0xc0, 0xf0, 0x1f, 0x61, 0x93, 0xa6, 0x86, 0xf8, 0xab, 0x35, 0xaa, 0xb3, 0x55, 0x56, 0xd6, 0x26,
	0x45, 0xe8, 0x39, 0x08, 0xfb, 0xca, 0x81, 0xe6, 0x29, 0x50, 0x4d, 0x94, 0x32, 0xb0, 0x58, 0x76,
	0xcb, 0xc2, 0x11, 0xb3, 0x5b, 0xea, 0x87, 0xc9, 0x6e, 0xb9, 0x0c, 0x75, 0xf1, 0x5b, 0xa4, 0xb7,
	0xb0, 0xd3, 0x0a, 0x9a, 0xd9, 0xb2, 0x20, 0xea, 0x44, 0x0a, 0x4b, 0x5e, 0x32, 0x0c, 0x8c, 0x4c,
	0x86, 0xf9, 0x3d, 0x85, 0xc7, 0xcd, 0xe1, 0x24, 0xe5, 0xa7, 0xf0, 0x52, 0x02, 0x85, 0x72, 0x94,
	0x04, 0x0a, 0xb4, 0x93, 0x9b, 0x62, 0x72, 0x31, 0x9f, 0xd2, 0xb8, 0x24, 0x13, 0xd5, 0x02, 0x24,
	0x63, 0xd0, 0x89, 0xc2, 0xd3, 0x28, 0xd8, 0x4a, 0x4d, 0xd3, 0x28, 0xea, 0x50, 0xec, 0xf1, 0xc4,
	0x8a, 0xa2, 0x46, 0x7e, 0xe6, 0x69, 0x70, 0x31, 0x4f, 0x83, 0xd5, 0xcd, 0x30, 0x7a, 0xfe, 0x34,
	0x32, 0xff, 0xd4, 0x7f, 0x51, 0xe0, 0x34, 0xa7, 0x97, 0x93, 0x1e, 0x97, 0x31, 0x69, 0x95, 0x9c,
	0x49, 0xdb, 0xf5, 0xb0, 0x89, 0xed, 0xc0, 0x32, 0xfa, 0xd4, 0x1f, 0x13, 0x07, 0xe2, 0x51, 0x31,
	0x75, 0x09, 0xcf, 0xc3, 0x1c, 0xcb, 0x78, 0xe5, 0x81, 0x34, 0x4b, 0x6c, 0xad, 0xd2, 0xa4, 0x57,
	0x1e, 0x2b, 0x6f, 0x67, 0x19, 0xca, 0x52, 0xee, 0x0e, 0xcc, 0x58, 0x7b, 0xa9, 0x3a, 0xb0, 0x92,
	0x93, 0x9a, 0x90, 0xa9, 0x11, 0x4a, 0x5a, 0x23, 0x46, 0x0a, 0x29, 0xad, 0x11, 0xdf, 0x51, 0xe0,
	0x6c, 0x2a, 0xa0, 0xff, 0xfc, 0x25, 0xab, 0xfe, 0xa1, 0x12, 0xea, 0x4f, 0x72, 0x76, 0xad, 0xa5,
	0x67, 0xd7, 0x73, 0xa3, 0xf6, 0x27, 0x32, 0xe7, 0xd7, 0xfb, 0xb9, 0xf3, 0xeb, 0xc5, 0x91, 0x7b,
	0x1d, 0xe3, 0xe4, 0xf9, 0x8f, 0x0a, 0x9c, 0xc8, 0x65, 0x20, 0xe1, 0xde, 0x2a, 0x49, 0xf7, 0x96,
	0xbb, 0xc6, 0x51, 0x30, 0xc3, 0x5c, 0x63, 0x1a, 0xaf, 0x70, 0x1f, 0x54, 0x1f, 0x18, 0x4f, 0xad,
	0xc1, 0x70, 0xc0, 0x7d, 0x63, 0x42, 0x6e, 0x93, 0x95, 0x1c, 0xc5, 0x39, 0xbe, 0x0a, 0x4b, 0x6c,
	0xdd, 0xa2, 0xfe, 0x59, 0x84, 0xc1, 0x7c, 0xe4, 0x45, 0x56, 0x47, 0x5c, 0x35, 0x8e, 0xa0, 0x36,
	0x61, 0x31, 0xec, 0xd6, 0xc8, 0xd4, 0xac, 0x58, 0xaa, 0x55, 0x41, 0x4e, 0xb5, 0xb2, 0x61, 0x66,
	0x1d, 0x3f, 0xb6, 0xba, 0xf8, 0x53, 0xc9, 0x3c, 0x3f, 0x07, 0x55, 0x17, 0x7b, 0x03, 0xcb, 0xf7,
	0x43, 0x27, 0xa5, 0xa2, 0xc5, 0x8b, 0xd4, 0xb3, 0x50, 0x59, 0x5b, 0x6f, 0xf1, 0x26, 0x33, 0x58,
	0x55, 0xff, 0x75, 0x06, 0x16, 0x92, 0x3a, 0x76, 0x2b, 0x95, 0xfa, 0x75, 0x3a, 0x73, 0xdb, 0x30,
	0x63, 0xbf, 0xfc, 0x45, 0x11, 0x49, 0x16, 0xd2, 0x79, 0x11, 0x61, 0xb4, 0x28, 0x02, 0xcc, 0x55,
	0x98, 0xed, 0x3a, 0x83, 0x81, 0x61, 0x9b, 0xe2, 0xfe, 0x00, 0xff, 0x24, 0x9c, 0x1a, 0x5e, 0x8f,
	0xed, 0x94, 0x57, 0x34, 0xfa, 0x9b, 0xa8, 0x00, 0x31, 0x86, 0x96, 0x4d, 0x93, 0xc7, 0xe8, 0x28,
	0x55, 0x34, 0xe0, 0x45, 0xeb, 0x96, 0x87, 0x2e, 0x40, 0x09, 0xdb, 0x8f, 0xc5, 0x11, 0x9a, 0xb4,
	0x63, 0x2b, 0x42, 0x3c, 0x8d, 0x42, 0xa0, 0x8b, 0x30, 0x33, 0x20, 0x6a, 0x25, 0x12, 0x0c, 0x16,
	0x53, 0x79, 0xf6, 0x1a, 0x07, 0x40, 0x2f, 0xc1, 0xac, 0x49, 0xa5, 0x27, 0x62, 0x1a, 0x24, 0xa5,
	0xa1, 0xd1, 0x2a, 0x4d, 0x80, 0xa0, 0x77, 0xc2, 0xe3, 0x82, 0x4a, 0xfa, 0x1c, 0x2f, 0x21, 0xe6,
	0xcc, 0x93, 0x82, 0x2d, 0x39, 0xe6, 0x86, 0xf4, 0xa1, 0x43, 0x92, 0xca, 0xe8, 0xc8, 0xfb, 0x04,
	0x94, 0xfb, 0x4e, 0x8f, 0x69, 0x4f, 0x95, 0x5d, 0x3e, 0xe9, 0x3b, 0x3d, 0xaa, 0x3c, 0x4b, 0x30,
	0xed, 0x07, 0xa6, 0x65, 0x53, 0xd7, 0xb0, 0xac, 0xb1, 0x0f, 0x32, 0x49, 0xe9, 0x0f, 0xdd, 0xb1,
	0xbb, 0x78, 0xb5, 0x46, 0xab, 0x2a, 0xb4, 0x64, 0xdb, 0xee, 0xd2, 0x10, 0x39, 0x08, 0x0e, 0x56,
	0xe7, 0x69, 0x39, 0xf9, 0x19, 0xed, 0xda, 0x2f, 0xe4, 0xec, 0xda, 0x27, 0x18, 0xce, 0xd8, 0xb5,
	0xaf, 0xe7, 0xae, 0x19, 0x49, 0x5c, 0x81, 0x42, 0xdc, 0xe2, 0xb5, 0xf5, 0x96, 0x2e, 0x86, 0x66,
	0x31, 0x9d, 0x86, 0x1f, 0xaa, 0xbd, 0x06, 0xe1, 0xcf, 0xcf, 0xf5, 0xd0, 0xe4, 0x07, 0x0a, 0x2c,
	0xaf, 0xd1, 0x23, 0xe3, 0x98, 0x6d, 0x3c, 0x4c, 0xb6, 0xd5, 0x2b, 0x61, 0x0a, 0x5c, 0x46, 0x1e,
	0x53, 0x52, 0x52, 0x22, 0x03, 0x6e, 0x0d, 0xe6, 0x05, 0x59, 0x8e, 0x5c, 0x9c, 0x20, 0x7f, 0xae,
	0xe6, 0xc7, 0x3f, 0xd5, 0x37, 0x61, 0x25, 0xc5, 0x39, 0x3f, 0xb8, 0x4b, 0xde, 0xd7, 0x60, 0x8c,
	0xc7, 0xef, 0x6b, 0xa8, 0xb7, 0xe1, 0x78, 0x27, 0x30, 0xbc, 0x20, 0xd5, 0xed, 0x09, 0x70, 0x69,
	0x66, 0x9c, 0x8c, 0xcb, 0x93, 0xd7, 0x3a, 0xb0, 0xd4, 0x09, 0x1c, 0xf7, 0x08, 0x44, 0x89, 0xdd,
	0x21, 0x3d, 0x77, 0x86, 0x62, 0x9d, 0x11, 0x9f, 0xea, 0x0a, 0xcb, 0xe3, 0x4b, 0xb7, 0xf6, 0x06,
	0x2c, 0xb3, 0x34, 0xba, 0xa3, 0x74, 0xe2, 0x84, 0x48, 0xe2, 0x4b, 0xd3, 0xbd, 0x0f, 0xc7, 0xa4,
	0xa3, 0x04, 0x9e, 0x76, 0x72, 0x4d, 0x4e, 0x3b, 0xc9, 0x3f, 0xb5, 0x09, 0xb3, 0x4e, 0x7e, 0xb5,
	0x10, 0xb3, 0xe3, 0x39, 0x67, 0xcf, 0xaf, 0xca, 0x49, 0x27, 0x67, 0xf3, 0xa9, 0x4a, 0x39, 0x27,
	0x69, 0xed, 0x2c, 0x66, 0x68, 0xe7, 0x6e, 0xea, 0x60, 0xbb, 0x94, 0x4e, 0x1a, 0x4a, 0x70, 0xf8,
	0x99, 0x1c, 0x69, 0x3f, 0x60, 0x89, 0x29, 0x61, 0xd3, 0xe1, 0x69, 0xf6, 0x2b, 0x89, 0xd3, 0xec,
	0x93, 0x23, 0x38, 0x0d, 0xcf, 0xb1, 0xbf, 0x5f, 0x82, 0x4a, 0x58, 0x97, 0x92, 0x70, 0x5a, 0x54,
	0x85, 0x0c, 0x51, 0xc5, 0xd7, 0xd7, 0xe2, 0x11, 0xd7, 0xd7, 0xd2, 0x04, 0xeb, 0xeb, 0x49, 0xa8,
	0xd0, 0x1f, 0xf4, 0x2e, 0x01, 0x5b, 0x2f, 0xcb, 0xb4, 0x40, 0xc3, 0x7b, 0x91, 0x8a, 0xcd, 0x4c,
	0xa8, 0x62, 0x89, 0x24, 0x98, 0xd9, 0x64, 0x12, 0xcc, 0xad, 0x70, 0xed, 0x2b, 0xa7, 0x0f, 0x9d,
	0x42, 0x8a, 0x99, 0xab, 0x5e, 0x62, 0xa7, 0xb9, 0x92, 0xde, 0x69, 0x8e, 0xf0, 0xc7, 0xae, 0x77,
	0xac, 0xcb, 0x96, 0xc9, 0xe2, 0x57, 0x6d, 0x96, 0x7e, 0xb7, 0xcc, 0xcf, 0xd3, 0xf4, 0x6f, 0xb3,
	0xa4, 0x97, 0xb8, 0x0a, 0x72, 0xf3, 0xf9, 0xaa, 0x74, 0xde, 0xa8, 0x64, 0x2c, 0x63, 0xa1, 0xc9,
	0x88, 0x9f, 0x31, 0xee, 0xc2, 0x72, 0x32, 0x59, 0xee, 0x50, 0xe6, 0x2f, 0x27, 0x6b, 0xf7, 0x27,
	0x71, 0x67, 0x30, 0x27, 0x45, 0xf5, 0x56, 0x2a, 0x9b, 0x62, 0x62, 0xe5, 0xbd, 0x26, 0x27, 0x5e,
	0x1d, 0x5a, 0xe5, 0x52, 0x79, 0x57, 0xd4, 0x59, 0x31, 0x3c, 0x5e, 0xcd, 0xfc, 0xf6, 0x0a, 0x2f,
	0x69, 0xd2, 0xa0, 0x61, 0xcf, 0xb2, 0x2d, 0x7f, 0x9f, 0xd5, 0xcf, 0xb0, 0xa0, 0x41, 0x14, 0x35,
	0xe9, 0xfe, 0x2c, 0x7e, 0x6a, 0x05, 0x7a, 0xd7, 0x31, 0x31, 0x55, 0xe8, 0x69, 0xad, 0x4c, 0x0a,
	0xd6, 0x1c, 0x13, 0x47, 0x53, 0xad, 0x7c, 0xd8, 0xa9, 0x56, 0x49, 0x4c, 0xb5, 0x65, 0x98, 0xf1,
	0xb0, 0xe1, 0x3b, 0x36, 0x57, 0x49, 0xfe, 0x45, 0x06, 0x62, 0x80, 0x7d, 0x9f, 0xb4, 0xc1, 0x7d,
	0x33, 0xfe, 0x19, 0xf3, 0x23, 0xe7, 0x46, 0xf8, 0x91, 0x23, 0x12, 0x60, 0x13, 0x7e, 0x64, 0x6d,
	0x84, 0x1f, 0x39, 0x51, 0xfe, 0x6b, 0xe4, 0x31, 0xcf, 0x8f, 0xf3, 0x98, 0xe3, 0x2e, 0xe7, 0x82,
	0xec, 0x72, 0xbe, 0x19, 0x0f, 0x5e, 0xeb, 0xe9, 0x74, 0x80, 0xd1, 0x51, 0x6b, 0x7c, 0x6e, 0x2f,
	0x4a, 0x73, 0x1b, 0x5d, 0xe6, 0x9b, 0xe4, 0x28, 0xbd, 0xbd, 0x2a, 0xed, 0xf6, 0xb0, 0xfd, 0xf3,
	0xcf, 0xd3, 0x14, 0xfc, 0x8d, 0x02, 0x2b, 0xa9, 0xa9, 0xcb, 0x8d, 0xc1, 0x2b, 0x89, 0x1c, 0xdd,
	0x91, 0xc9, 0xb1, 0x22, 0x45, 0xb7, 0x29, 0xa5, 0xe8, 0x5e, 0x1e, 0x85, 0x92, 0x93, 0xa1, 0x7b,
	0xf4, 0xac, 0xd9, 0x6f, 0x2b, 0x80, 0x32, 0x02, 0xfd, 0x5b, 0x22, 0x24, 0x38, 0xc4, 0xee, 0x1f,
	0x8f, 0x0a, 0xde, 0x89, 0xa2, 0x82, 0xc2, 0x61, 0x36, 0x37, 0xc2, 0x74, 0x9e, 0x0d, 0xa8, 0xc9,
	0xfb, 0x7b, 0x37, 0x64, 0x66, 0xce, 0xe4, 0x33, 0x43, 0x15, 0x84, 0x01, 0xab, 0x3f, 0x29, 0xc0,
	0xd9, 0x5d, 0xd7, 0x4c, 0xb8, 0xbc, 0xbc, 0xb1, 0xc9, 0x4d, 0xed, 0x2d, 0x39, 0xa5, 0xe9, 0x88,
	0x92, 0x28, 0x1e, 0x45, 0x12, 0xe8, 0xeb, 0x59, 0x49, 0x67, 0x6f, 0x4a, 0xc7, 0xc3, 0xa3, 0x3b,
	0x38, 0x26, 0xff, 0xec, 0x93, 0xce, 0x04, 0x15, 0xce, 0xe5, 0x33, 0xc0, 0xdd, 0xe3, 0xff, 0x0d,
	0x0b, 0x1b, 0x4f, 0x71, 0xb7, 0x73, 0x60, 0x77, 0x0f, 0x21, 0xf5, 0x3a, 0x14, 0xbb, 0x03, 0x93,
	0x1f, 0x4c, 0x91, 0x9f, 0x71, 0x8f, 0xbf, 0x28, 0x7b, 0xfc, 0x3a, 0xd4, 0xa3, 0x16, 0xf8, 0x3c,
	0x5c, 0x26, 0xf3, 0xd0, 0x24, 0xc0, 0x84, 0xf8, 0x9c, 0xc6, 0xbf, 0x78, 0x39, 0xf6, 0xd8, 0x25,
	0x22, 0x56, 0x8e, 0x3d, 0x4f, 0x5e, 0x46, 0x8a, 0xf2, 0x32, 0xa2, 0x7e, 0x57, 0x81, 0x2a, 0x69,
	0xe1, 0x13, 0xf1, 0xcf, 0xc3, 0xee, 0x62, 0x14, 0x76, 0x87, 0xd1, 0x7b, 0x29, 0x1e, 0xbd, 0x47,
	0x9c, 0x4f, 0xd3, 0xe2, 0x34, 0xe7, 0x33, 0x61, 0x39, 0xf6, 0x3c, 0xf5, 0x1c, 0xcc, 0x31, 0xde,
	0x78, 0xcf, 0xeb, 0x50, 0x1c, 0x7a, 0x7d, 0x31, 0x7e, 0x43, 0xaf, 0xaf, 0x7e, 0x4b, 0x81, 0x5a,
	0x33, 0x08, 0x8c, 0xee, 0xfe, 0x21, 0x3a, 0x10, 0x32, 0x57, 0x88, 0x33, 0x97, 0xee, 0x44, 0xc4,
	0x6e, 0x29, 0x87, 0xdd, 0x69, 0x89, 0x5d, 0x15, 0xe6, 0x05, 0x2f, 0xb9, 0x0c, 0x6f, 0x01, 0x6a,
	0x3b, 0x5e, 0x70, 0xcf, 0xf1, 0x9e, 0x18, 0x9e, 0x79, 0xb8, 0x08, 0x1b, 0x41, 0x89, 0x3f, 0x35,
	0x51, 0xbc, 0x30, 0xad, 0xd1, 0xdf, 0xea, 0x0b, 0x70, 0x4c, 0xa2, 0x97, 0xdb, 0xf0, 0x6d, 0xa8,
	0x52, 0xb7, 0x80, 0x07, 0x5f, 0x2f, 0xc6, 0x73, 0x2a, 0xc6, 0xb8, 0x0f, 0xea, 0x3a, 0x2c, 0x12,
	0x07, 0x91, 0x96, 0x87, 0xf6, 0xe5, 0x6a, 0x22, 0x3e, 0x59, 0x49, 0x91, 0x48, 0xc4, 0x26, 0x3f,
	0x53, 0x60, 0x9a, 0xa5, 0x4f, 0x24, 0x9d, 0xb6, 0x93, 0x64, 0xe1, 0x75, 0x1d, 0x3d, 0x30, 0x7a,
	0xe1, 0x33, 0x1e, 0xa4, 0x60, 0xc7, 0xe8, 0xd1, 0x83, 0x2e, 0x5a, 0x69, 0x5a, 0x3d, 0xec, 0x07,
	0xe2, 0x70, 0xb6, 0x4a, 0xca, 0xd6, 0x59, 0x11, 0x11, 0x0c, 0x3d, 0xc3, 0x2e, 0xd1, 0xa3, 0x6a,
	0xfa, 0x1b, 0x5d, 0x60, 0x07, 0x27, 0xa3, 0x4f, 0x24, 0xe9, 0x81, 0x4a, 0x03, 0xca, 0x89, 0xa3,
	0xc4, 0xf0, 0x1b, 0x5d, 0x84, 0x12, 0xdd, 0x2b, 0x9f, 0x1d, 0x25, 0x25, 0x0a, 0x42, 0xb4, 0xc2,
	0xb5, 0x6c, 0x1b, 0x9b, 0xfc, 0x8d, 0x09, 0xfe, 0xa5, 0xbe, 0x03, 0x28, 0x2e, 0x3c, 0x3e, 0x40,
	0x17, 0x61, 0x86, 0xca, 0x56, 0x78, 0xd5, 0x8b, 0x29, 0xd2, 0x1a, 0x07, 0x50, 0xbf, 0x06, 0x88,
	0xb5, 0x25, 0x79, 0xd2, 0x87, 0x19, 0xc0, 0x11, 0x3e, 0xf5, 0x1f, 0x29, 0x70, 0x4c, 0xa2, 0xce,
	0xf9, 0x7b, 0x41, 0x26, 0x9f, 0xc1, 0x1e, 0x27, 0xfd, 0x96, 0xb4, 0xc0, 0x5f, 0x4c, 0xb3, 0xf1,
	0x3f, 0xb4, 0xb8, 0xff, 0xad, 0x02, 0xd0, 0x1c, 0x06, 0xfb, 0x7c, 0x53, 0x38, 0x3e, 0x88, 0x4a,
	0x62, 0x10, 0x1b, 0x50, 0x76, 0x0d, 0xdf, 0x7f, 0xe2, 0x78, 0x22, 0xe0, 0x0d, 0xbf, 0xe9, 0x56,
	0xee, 0x90, 0xbf, 0xd5, 0x51, 0xd1, 0xe8, 0x6f, 0xf4, 0x1c, 0xcc, 0xb3, 0xf7, 0x65, 0x74, 0xc3,
	0x34, 0x3d, 0x91, 0xa7, 0x59, 0xd1, 0x6a, 0xac, 0xb4, 0xc9, 0x0a, 0x09, 0x98, 0x45, 0x4f, 0x4e,
	0x82, 0x03, 0x3d, 0x70, 0x1e, 0x61, 0x9b, 0x07, 0xb1, 0x35, 0x51, 0xba, 0x43, 0x0a, 0xd9, 0x29,
	0x6c, 0xcf, 0xf2, 0x03, 0x4f, 0x80, 0x89, 0xf3, 0x6a, 0x5e, 0x4a, 0xc1, 0xd4, 0xdf, 0x57, 0xa0,
	0xde, 0x1e, 0xf6, 0xfb, 0x4c, 0xb8, 0x47, 0x19, 0xe4, 0x4b, 0xbc, 0x2b, 0x85, 0xb4, 0xca, 0x47,
	0x82, 0xe2, 0x5d, 0xfc, 0x54, 0xf6, 0xdd, 0xae, 0xc1, 0x62, 0x8c, 0x63, 0xae, 0x38, 0x52, 0xa8,
	0xa1, 0xc8, 0xa1, 0x86, 0xda, 0x04, 0xc4, 0xb6, 0x9a, 0x8e, 0xdc, 0x4b, 0xf5, 0x38, 0x1c, 0x93,
	0x48, 0xf0, 0xa5, 0xf8, 0x12, 0xd4, 0x78, 0xce, 0x20, 0x57, 0x88, 0x13, 0x50, 0x26, 0x26, 0xb5,
	0x6b, 0x99, 0x22, 0x39, 0x65, 0xd6, 0x75, 0xcc, 0x35, 0xcb, 0xf4, 0xd4, 0x2f, 0x43, 0x8d, 0x3f,
	0x4a, 0xc0, 0x61, 0xef, 0xc0, 0x3c, 0x3f, 0xcb, 0xd4, 0xa5, 0x5b, 0xbc, 0x27, 0x32, 0x12, 0x53,
	0x85, 0x28, 0xec, 0xf8, 0xa7, 0xfa, 0x75, 0x68, 0x30, 0x6f, 0x41, 0x22, 0x2c, 0x3a, 0x78, 0x07,
	0x44, 0x5e, 0xd8, 0x08, 0xfa, 0x32, 0x66, 0xcd, 0x8b, 0x7f, 0xaa, 0xa7, 0xe1, 0x64, 0x26, 0x7d,
	0xde, 0x7b, 0x17, 0xea, 0x51, 0x05, 0xbb, 0x6a, 0x1a, 0x66, 0xdc, 0x28, 0xb1, 0x8c, 0x9b, 0xe5,
	0xd0, 0x85, 0x2f, 0x88, 0x95, 0x8b, 0x7a, 0xe9, 0x51, 0x08, 0x58, 0xcc, 0x0b, 0x01, 0x4b, 0x52,
	0x08, 0xa8, 0x6e, 0x86, 0x32, 0xe4, 0x81, 0xf8, 0x9b, 0x74, 0xab, 0x80, 0xb5, 0x2d, 0x8c, 0xda,
	0xa9, 0xec, 0xfe, 0x31, 0x20, 0x2d, 0x06, 0xaf, 0x5e, 0x84, 0x9a, 0x6c, 0xde, 0x62, 0x16, 0x4b,
	0x91, 0x2d, 0xd6, 0xff, 0x81, 0x65, 0x4d, 0x4a, 0xb2, 0xbb, 0x87, 0x8d, 0x60, 0xe8, 0x61, 0x1f,
	0xbd, 0x01, 0x8d, 0x8c, 0x27, 0x7f, 0x74, 0x1e, 0x19, 0x32, 0x32, 0x2b, 0xa9, 0x97, 0x7f, 0x36,
	0x59, 0x5c, 0xf8, 0x02, 0x2c, 0xd0, 0x24, 0xc0, 0xd8, 0xe5, 0x59, 0x26, 0x23, 0xfa, 0xbc, 0xcc,
	0x56, 0x74, 0x53, 0xd6, 0x0c, 0x9f, 0xb4, 0xe0, 0xed, 0x67, 0x9e, 0xb1, 0xbd, 0x0d, 0xe5, 0x3d,
	0xce, 0x17, 0x9f, 0x90, 0x6a, 0x86, 0x30, 0x12, 0x3d, 0xd0, 0x42, 0x1c, 0xf5, 0x3f, 0x15, 0x98,
	0x4f, 0x98, 0xe4, 0x97, 0x13, 0xf1, 0x57, 0x96, 0xf6, 0x24, 0xa2, 0xaf, 0x9b, 0x92, 0x71, 0x96,
	0x93, 0x52, 0x46, 0x5f, 0x8b, 0xdc, 0x80, 0x7a, 0x22, 0xc3, 0x51, 0x64, 0x37, 0x37, 0xf2, 0xfb,
	0xa1, 0x2d, 0xc8, 0xe9, 0x8f, 0xfe, 0xd1, 0xcd, 0xfb, 0x12, 0x5f, 0xf4, 0xee, 0xf9, 0x04, 0x9f,
	0x6b, 0x85, 0xfa, 0x0c, 0x54, 0x77, 0xf3, 0xde, 0xea, 0x29, 0x89, 0xfc, 0xc7, 0xd7, 0x60, 0xe9,
	0x9e, 0xd5, 0xc7, 0xfe, 0x81, 0x1f, 0xe0, 0x41, 0x8b, 0xda, 0xe2, 0x3d, 0x0b, 0x7b, 0xe8, 0x0c,
	0x00, 0x55, 0x05, 0xd7, 0xb1, 0xc2, 0xb7, 0x43, 0x62, 0x25, 0xea, 0x8f, 0x15, 0x58, 0x88, 0x10,
	0x27, 0x49, 0x72, 0x7d, 0x15, 0xa6, 0xf7, 0x7c, 0xb1, 0x8d, 0x9a, 0x38, 0x5c, 0xca, 0x62, 0x41,
	0x2b, 0xed, 0xf9, 0x2d, 0x13, 0xbd, 0x06, 0x30, 0xf4, 0xb1, 0xc9, 0xcf, 0x73, 0xc7, 0xa4, 0x1d,
	0x57, 0x08, 0x28, 0x3b, 0x11, 0xbe, 0x09, 0x55, 0xcb, 0x76, 0x4c, 0x4c, 0xcf, 0xfa, 0xcd, 0x71,
	0x29, 0xc7, 0xc0, 0x60, 0x77, 0x7d, 0x6c, 0xaa, 0xbf, 0x1d, 0x9d, 0xd8, 0x7f, 0x91, 0x7b, 0xa8,
	0xfe, 0x81, 0xf0, 0x46, 0xc4, 0xb0, 0x73, 0xd5, 0x7f, 0x17, 0x16, 0xd9, 0xa2, 0xb2, 0x17, 0xb6,
	0x99, 0x79, 0x17, 0x2b, 0xd1, 0x39, 0xad, 0x6e, 0x71, 0x3f, 0x54, 0x20, 0xa1, 0x36, 0x1c, 0x8f,
	0xc2, 0x83, 0x38, 0xb5, 0xc2, 0x78, 0x6a, 0x4b, 0xdd, 0xd8, 0xae, 0xbb, 0x40, 0x54, 0x6f, 0xc3,
	0xf1, 0xc4, 0x75, 0x8b, 0xc9, 0x8f, 0x5e, 0xde, 0x4b, 0x6c, 0x94, 0x46, 0x93, 0xfd, 0x9a, 0x7c,
	0xcb, 0x6f, 0xd4, 0xc5, 0x18, 0x7e, 0xe1, 0x6c, 0x17, 0x4e, 0x48, 0xbb, 0xb8, 0x12, 0x2f, 0x37,
	0x13, 0xce, 0xfa, 0xb9, 0x7c, 0x7a, 0x09, 0xaf, 0xfd, 0xdf, 0x14, 0x58, 0xca, 0x02, 0x38, 0xe2,
	0xe1, 0xc2, 0x87, 0x39, 0x37, 0x84, 0x5f, 0x19, 0xc7, 0xd0, 0x67, 0x72, 0x18, 0xb3, 0xc5, 0xee,
	0x17, 0x8e, 0x1f, 0x93, 0xe2, 0x64, 0x63, 0xf2, 0xb3, 0x42, 0xec, 0x00, 0x6d, 0xc4, 0x1d, 0xc0,
	0x4f, 0xb0, 0x6b, 0xbd, 0x96, 0xb8, 0x02, 0xf8, 0x62, 0x26, 0xe2, 0x98, 0x1b, 0x80, 0x5a, 0xd6,
	0x66, 0xcc, 0xb5, 0x71, 0x94, 0xbe, 0xb0, 0x17, 0x00, 0x7f, 0xad, 0x00, 0xf3, 0xf2, 0x80, 0xa0,
	0x77, 0x32, 0xee, 0xff, 0x9d, 0x1d, 0xd3, 0x41, 0xe9, 0xfa, 0x1f, 0xbf, 0x6f, 0x57, 0x98, 0xfc,
	0xbe, 0x5d, 0x71, 0xb2, 0xfb, 0x76, 0x77, 0x61, 0xfe, 0x89, 0x67, 0x05, 0xc6, 0xc3, 0x3e, 0xd6,
	0xfb, 0xc6, 0x01, 0xf6, 0xb8, 0x61, 0x1f, 0x69, 0x8a, 0x6a, 0x02, 0xe5, 0x01, 0xc1, 0xa0, 0x61,
	0xea, 0x13, 0xc3, 0xe5, 0xd1, 0xae, 0xe4, 0x40, 0x77, 0x9e, 0x18, 0x2e, 0xc3, 0xa1, 0x20, 0xea,
	0xb7, 0x0a, 0x70, 0x3c, 0xf3, 0x96, 0xd8, 0x27, 0x17, 0xd1, 0xe5, 0xb8, 0x88, 0x0e, 0x73, 0xf5,
	0xae, 0x78, 0xa8, 0xab, 0x77, 0xad, 0x1c, 0x81, 0x65, 0x65, 0x68, 0x8c, 0x96, 0x9b, 0xfa, 0xa7,
	0x0a, 0x94, 0x05, 0x53, 0x63, 0x2f, 0xc2, 0xad, 0x0c, 0x09, 0x98, 0x4e, 0x2f, 0x2b, 0xd8, 0x86,
	0xed, 0xe8, 0x3e, 0x26, 0x1e, 0xec, 0xd8, 0x6b, 0x47, 0x4b, 0x14, 0x6f, 0xcd, 0xf1, 0xf0, 0x96,
	0x61, 0x3b, 0x1d, 0x86, 0x84, 0x9a, 0x50, 0x67, 0xf4, 0x28, 0x29, 0x42, 0x74, 0xec, 0x42, 0x39,
	0x4f, 0x11, 0x08, 0x11, 0x42, 0xcc, 0x57, 0xff, 0x42, 0x81, 0x85, 0x84, 0x64, 0x7f, 0xf1, 0x3a,
	0xf1, 0xbd, 0x22, 0x54, 0x63, 0xa3, 0x3c, 0xa6, 0x03, 0x6b, 0xb0, 0x28, 0xb2, 0xac, 0x7c, 0x1c,
	0x4c, 0x76, 0xed, 0x6b, 0x81, 0x63, 0x74, 0x70, 0xc0, 0xfc, 0xa8, 0x3b, 0xb0, 0x60, 0x3c, 0x36,
	0xac, 0x3e, 0xd5, 0xa0, 0x89, 0x5c, 0x94, 0xf9, 0x10, 0x3e, 0xf4, 0xc4, 0x58, 0xbf, 0x27, 0xba,
	0xfc, 0x05, 0x14, 0x36, 0xba, 0x83, 0xe7, 0xfb, 0xb1, 0x54, 0xbe, 0x91, 0x77, 0xf0, 0x7c, 0x3f,
	0x6c, 0x8f, 0xde, 0xd4, 0xa0, 0x97, 0x0f, 0x7d, 0xfe, 0x62, 0x4d, 0x7e, 0x7b, 0x04, 0xf6, 0x1e,
	0x05, 0x25, 0x02, 0x1b, 0x18, 0x1f, 0x39, 0x9e, 0x1e, 0xc7, 0x9f, 0x1d, 0x23, 0x30, 0x8a, 0xd1,
	0x0e, 0x89, 0xa8, 0x7f, 0xac, 0x40, 0x25, 0xb4, 0x23, 0x63, 0x46, 0xa8, 0x05, 0x4b, 0xf4, 0x5a,
	0x4b, 0x52, 0xc2, 0x63, 0x06, 0x09, 0x11, 0xa4, 0xa6, 0x2c, 0xe5, 0x26, 0xd4, 0x29, 0xa9, 0xb8,
	0xa8, 0xc7, 0x0d, 0x94, 0x2f, 0xd8, 0x64, 0x0e, 0xe5, 0x9f, 0x15, 0x00, 0xa5, 0x4d, 0xc9, 0x2f,
	0x8c, 0x92, 0xc5, 0x07, 0xad, 0x34, 0xf9, 0xa0, 0xdf, 0x87, 0x63, 0x5d, 0x67, 0x30, 0xb0, 0xe8,
	0x95, 0x28, 0xc7, 0x3b, 0x98, 0x4c, 0xdd, 0x16, 0x19, 0x0e, 0x93, 0x13, 0x13, 0xdf, 0xdb, 0x70,
	0x42, 0xc3, 0x8e, 0x8b, 0xed, 0xd0, 0xf4, 0x3f, 0x70, 0x7a, 0x87, 0xf0, 0x6f, 0x4f, 0x41, 0x23,
	0x0b, 0x9f, 0xef, 0x5a, 0x0c, 0xa1, 0xb1, 0xb6, 0x8f, 0xbb, 0x8f, 0x68, 0xf8, 0x75, 0x94, 0x4c,
	0xa9, 0x06, 0x94, 0xfb, 0x4e, 0x97, 0x3d, 0x49, 0xcc, 0x37, 0xf6, 0xc4, 0xf7, 0x88, 0x33, 0x95,
	0xd3, 0x70, 0x32, 0xb3, 0x59, 0xce, 0x15, 0x82, 0xfa, 0x7d, 0x1c, 0x6c, 0x3c, 0xc6, 0x76, 0xe8,
	0x3e, 0xab, 0x3f, 0x2c, 0xc4, 0x1c, 0x75, 0x5a, 0x75, 0x88, 0x0c, 0x33, 0xd4, 0x86, 0x28, 0x72,
	0xd0, 0x31, 0xc1, 0x66, 0x8f, 0x71, 0xb2, 0xa7, 0x72, 0xb3, 0x8f, 0x98, 0x69, 0x23, 0xf4, 0x0d,
	0xce, 0xe8, 0x99, 0xa1, 0xb0, 0x2c, 0x91, 0x78, 0x50, 0x4c, 0x26, 0x1e, 0xbc, 0x07, 0x28, 0xee,
	0x8a, 0xf3, 0x5d, 0x83, 0xd2, 0x04, 0x2f, 0x2b, 0xd5, 0xdd, 0xe4, 0x1b, 0x60, 0x39, 0xef, 0x23,
	0x4d, 0x1f, 0xe9, 0x7d, 0x24, 0xf5, 0x0c, 0x9c, 0x22, 0x0e, 0xf6, 0x26, 0x0e, 0x3c, 0xab, 0xbb,
	0x8e, 0xfd, 0xae, 0x67, 0xb9, 0x81, 0x13, 0x26, 0x3d, 0xa9, 0x3a, 0x9c, 0xce, 0xa9, 0xe7, 0xe2,
	0x7e, 0x1b, 0xaa, 0x66, 0x54, 0x9c, 0xb5, 0xcf, 0x94, 0xc4, 0xd5, 0xe2, 0x08, 0xea, 0x07, 0x50,
	0x4f, 0x02, 0x64, 0xee, 0xdf, 0x20, 0x28, 0xed, 0xe3, 0xbe, 0x2b, 0xee, 0xb0, 0x91, 0xdf, 0x44,
	0xea, 0x2c, 0x76, 0x79, 0x84, 0x0f, 0xc4, 0x39, 0x44, 0x85, 0x96, 0x7c, 0x09, 0x1f, 0x84, 0x7d,
	0x93, 0x1e, 0xec, 0xf0, 0xac, 0x6e, 0xb2, 0x6f, 0x19, 0xf5, 0x51, 0xdf, 0xc8, 0xb0, 0x0d, 0x58,
	0x31, 0xef, 0xdb, 0xe9, 0xdc, 0xc7, 0x40, 0x28, 0x2e, 0xb8, 0x8e, 0xc9, 0x7f, 0xab, 0xdf, 0x57,
	0x60, 0x31, 0x05, 0x31, 0xe1, 0xd9, 0xd2, 0x4b, 0x30, 0x2b, 0xda, 0x2d, 0xa4, 0x13, 0x89, 0x19,
	0x2d, 0x4d, 0x80, 0xa0, 0x16, 0x2c, 0x46, 0x1a, 0x2d, 0xf0, 0x8a, 0xe9, 0xb1, 0x88, 0x07, 0x2e,
	0x94, 0xdd, 0x7a, 0x37, 0x51, 0xa2, 0x76, 0xa1, 0x9e, 0x84, 0x9a, 0x64, 0x4e, 0x1d, 0x8a, 0x5f,
	0xf5, 0xaf, 0x14, 0x98, 0x61, 0x65, 0x99, 0x83, 0x2d, 0x2d, 0x07, 0x85, 0xe4, 0x72, 0xf0, 0x3a,
	0x54, 0x19, 0x1d, 0x3d, 0xbc, 0xc1, 0x38, 0x2f, 0x6f, 0xaf, 0x33, 0xd2, 0x74, 0xb6, 0xc2, 0x20,
	0xfc, 0x4d, 0xba, 0xc1, 0xf4, 0x85, 0x46, 0x26, 0x22, 0x5d, 0xbc, 0x4a, 0xcb, 0xa8, 0xc9, 0x25,
	0x2e, 0x33, 0x8f, 0x61, 0xc6, 0xd8, 0x66, 0xbe, 0xb5, 0xb5, 0x4c, 0x9f, 0x9f, 0x4c, 0x6d, 0x30,
	0xab, 0x3b, 0xf4, 0x7d, 0xc8, 0xf4, 0xc6, 0x30, 0x7a, 0x43, 0x4e, 0x2f, 0x78, 0x2e, 0x75, 0xc2,
	0x2f, 0xa1, 0x0d, 0x3d, 0xf6, 0x74, 0x3b, 0xcf, 0x32, 0xf8, 0x10, 0x4e, 0xe4, 0xc2, 0xa0, 0xb7,
	0xc2, 0xc7, 0x78, 0x4d, 0xcf, 0x7a, 0xcc, 0x37, 0x16, 0xe6, 0xe5, 0x87, 0x3f, 0xd6, 0x28, 0xc0,
	0x3a, 0xad, 0x17, 0xcf, 0xf4, 0xb2, 0xaf, 0x4b, 0xcf, 0x43, 0x59, 0x3c, 0xab, 0x8f, 0x66, 0xa1,
	0xb8, 0xb3, 0xd6, 0xae, 0x4f, 0x91, 0x1f, 0xbb, 0xeb, 0xed, 0xba, 0x82, 0xca, 0x50, 0xea, 0xac,
	0xed, 0xb4, 0xeb, 0x85, 0x4b, 0x03, 0xa8, 0x27, 0x5f, 0x96, 0x47, 0x2b, 0x70, 0xac, 0xad, 0x6d,
	0xb7, 0x9b, 0xf7, 0x9b, 0x3b, 0xad, 0xed, 0x2d, 0xbd, 0xad, 0xb5, 0xde, 0x6f, 0xee, 0x6c, 0xd4,
	0xa7, 0xd0, 0x79, 0x38, 0x1d, 0xaf, 0x78, 0x77, 0xbb, 0xb3, 0xa3, 0xef, 0x6c, 0xeb, 0x6b, 0xdb,
	0x5b, 0x3b, 0xcd, 0xd6, 0xd6, 0x86, 0x56, 0x57, 0xd0, 0x69, 0x38, 0x11, 0x07, 0xb9, 0xdb, 0x5a,
	0x6f, 0x69, 0x1b, 0x6b, 0xe4, 0x77, 0xf3, 0x41, 0xbd, 0x70, 0xe9, 0x2d, 0xa8, 0x49, 0x97, 0x9c,
	0x08, 0x4b, 0xed, 0xed, 0xf5, 0xfa, 0x14, 0xaa, 0x41, 0x25, 0x4e, 0xa7, 0x0c, 0xa5, 0xad, 0xed,
	0xf5, 0x8d, 0x7a, 0x01, 0x01, 0xcc, 0xec, 0x34, 0xb5, 0xfb, 0x1b, 0x3b, 0xf5, 0xe2, 0xa5, 0x97,
	0x61, 0x35, 0xef, 0xb2, 0x1f, 0xaa, 0xc0, 0xf4, 0x26, 0xf6, 0x7a, 0xb8, 0x3e, 0x45, 0x50, 0x3a,
	0x44, 0x4b, 0x82, 0xba, 0x72, 0xe9, 0x76, 0xf2, 0xad, 0x1a, 0x8c, 0x16, 0xa1, 0xd6, 0x69, 0x6e,
	0xad, 0xdf, 0xdd, 0xfe, 0xaa, 0xae, 0x6d, 0x34, 0xd7, 0x3f, 0xa8, 0x4f, 0xa1, 0x25, 0xa8, 0x8b,
	0xa2, 0xad, 0xed, 0x1d, 0x56, 0xaa, 0x5c, 0x7a, 0x94, 0x08, 0x73, 0x31, 0x3a, 0x0e, 0x8b, 0x21,
	0x97, 0xfa, 0x9a, 0xb6, 0xd1, 0xdc, 0xd9, 0x20, 0xcc, 0x4b, 0xc5, 0xda, 0xee, 0xd6, 0x56, 0x6b,
	0xeb, 0x7e, 0x5d, 0x21, 0x54, 0xa3, 0xe2, 0x8d, 0xaf, 0xb6, 0x08, 0x70, 0x41, 0x06, 0xde, 0xdd,
	0xfa, 0xd2, 0xd6, 0xf6, 0x57, 0xb6, 0xea, 0xc5, 0x4b, 0xff, 0x3f, 0x9e, 0x4d, 0x13, 0x2d, 0x45,
	0x27, 0x61, 0x25, 0xd5, 0xa2, 0xbe, 0xf1, 0xfe, 0xc6, 0xd6, 0x4e, 0x7d, 0x4a, 0xae, 0xec, 0xec,
	0x34, 0xb5, 0xa8, 0x52, 0x49, 0x56, 0x6e, 0xb7, 0xdb, 0x61, 0x65, 0x41, 0xae, 0x5c, 0xdf, 0x78,
	0xb0, 0x11, 0x61, 0x16, 0x2f, 0x3d, 0x0b, 0x10, 0x4d, 0x39, 0x54, 0x85, 0xd9, 0xb5, 0xed, 0xdd,
	0xad, 0x9d, 0x0d, 0xad, 0x3e, 0x45, 0xa4, 0x7c, 0xbf, 0xb9, 0x7b, 0x7f, 0xa3, 0xae, 0x5c, 0xba,
	0x08, 0x73, 0x71, 0x05, 0x24, 0x70, 0x9d, 0x0f, 0x3a, 0x3b, 0x1b, 0x9b, 0x44, 0x22, 0x73, 0x50,
	0x5e, 0xbb, 0xaf, 0x6d, 0xef, 0xb6, 0xef, 0x75, 0xea, 0xca, 0xf5, 0xff, 0x5a, 0x0a, 0x37, 0xf5,
	0x3b, 0xd8, 0xa3, 0xb7, 0x51, 0xd6, 0x61, 0x56, 0xfc, 0xef, 0x0a, 0x69, 0xa3, 0x47, 0xfe, 0x5f,
	0x1b, 0x8d, 0x93, 0x99, 0x75, 0xdc, 0x95, 0x98, 0x42, 0xef, 0xd3, 0x63, 0x92, 0xd8, 0x4b, 0x71,
	0xe7, 0x12, 0xbb, 0xe7, 0xa9, 0x07, 0xe9, 0x1a, 0xe7, 0x47, 0x40, 0x84, 0x74, 0x3f, 0x80, 0x79,
	0xf9, 0x49, 0x56, 0x74, 0x5e, 0xde, 0xdc, 0xcf, 0x78, 0xed, 0xb5, 0xa1, 0x8e, 0x02, 0x09, 0x49,
	0xeb, 0x50, 0x4f, 0x3e, 0xc9, 0x8a, 0xa4, 0xcc, 0xa0, 0x9c, 0x17, 0x5f, 0x1b, 0xcf, 0x8e, 0x06,
	0x8a, 0x37, 0x90, 0x7a, 0x69, 0xf4, 0x99, 0xd1, 0x6f, 0x37, 0x66, 0x34, 0x90, 0xf7, 0xc0, 0x23,
	0x13, 0x8e, 0xbc, 0xd0, 0xa2, 0xc4, 0xe3, 0x9e, 0x19, 0xef, 0x00, 0xca, 0xc2, 0xc9, 0x7e, 0x03,
	0x4e, 0x9d, 0x42, 0xff, 0x0b, 0x16, 0x12, 0x57, 0x0d, 0x90, 0x84, 0x98, 0x7d, 0x83, 0xa2, 0xf1,
	0xcc, 0x48, 0x18, 0x79, 0x54, 0xe3, 0xd7, 0x09, 0x92, 0xa3, 0x9a, 0x71, 0x4d, 0x21, 0x39, 0xaa,
	0x99, 0xb7, 0x11, 0xa8, 0x22, 0x4a, 0x57, 0x07, 0x64, 0x45, 0xcc, 0xba, 0xaa, 0xd0, 0x38, 0x3f,
	0x02, 0x22, 0x2e, 0x90, 0xc4, 0xe5, 0x01, 0x59, 0x20, 0xd9, 0xd7, 0x12, 0x1a, 0xcf, 0x8c, 0x84,
	0x49, 0x8e, 0x64, 0x94, 0x99, 0x9c, 0x1e, 0xc9, 0x54, 0xe2, 0x7c, 0x7a, 0x24, 0xd3, 0x89, 0xcd,
	0x7c, 0x24, 0x13, 0xb9, 0xc4, 0xea, 0xc8, 0xec, 0xc4, 0xac, 0x91, 0xcc, 0xce, 0x60, 0x54, 0xa7,
	0xd0, 0x13, 0x58, 0xcd, 0xcb, 0x1e, 0x43, 0x2f, 0x1e, 0x22, 0xc9, 0xad, 0xf1, 0xd2, 0x64, 0xc0,
	0x61, 0xc3, 0x18, 0x50, 0x3a, 0xe2, 0x42, 0xcf, 0xc9, 0xe2, 0xce, 0x89, 0xe8, 0x1a, 0xcf, 0x8f,
	0x03, 0x0b, 0x9b, 0xb9, 0x0f, 0x65, 0x91, 0x97, 0x86, 0x24, 0x13, 0x98, 0xc8, 0x87, 0x6b, 0x9c,
	0xca, 0xae, 0x0c, 0x09, 0xbd, 0x01, 0x25, 0x52, 0x8a, 0x56, 0x92, 0x70, 0x82, 0xc0, 0x6a, 0xba,
	0x22, 0x44, 0x6e, 0xc2, 0x0c, 0x4b, 0xb8, 0x42, 0xd2, 0x59, 0xa8, 0x94, 0x10, 0xd6, 0x68, 0x64,
	0x55, 0x85, 0x24, 0xda, 0xec, 0x3f, 0x01, 0xf1, 0xfc, 0x29, 0x74, 0x26, 0xf9, 0x18, 0xbb, 0x9c,
	0xa8, 0xd5, 0x38, 0x9b, 0x5b, 0x1f, 0xd7, 0xd9, 0xc4, 0xc6, 0xea, 0xf9, 0x11, 0x07, 0x05, 0x59,
	0x3a, 0x9b, 0x7d, 0xfc, 0xc0, 0x06, 0x37, 0x7d, 0x3c, 0x81, 0x9e, 0xcb, 0xd5, 0x77, 0xa9, 0x89,
	0xe7, 0xc7, 0x81, 0xc5, 0xa7, 0x46, 0xf2, 0x55, 0x35, 0x75, 0xd4, 0x8b, 0x87, 0x59, 0x53, 0x23,
	0xe7, 0x25, 0x45, 0x75, 0x0a, 0xed, 0xc3, 0xb1, 0x8c, 0xa7, 0x16, 0xd1, 0xf3, 0xf9, 0xf6, 0x57,
	0x6a, 0xe5, 0x85, 0xb1, 0x70, 0xf1, 0x96, 0x32, 0x92, 0x26, 0xe4, 0x96, 0xf2, 0xb3, 0x36, 0xe4,
	0x96, 0x46, 0x65, 0x5f, 0x50, 0x45, 0xe4, 0x36, 0xe4, 0x44, 0xd6, 0x19, 0x7b, 0x86, 0x22, 0xa6,
	0x2c, 0xc6, 0x3e, 0x1c, 0xcb, 0xd8, 0x95, 0x90, 0x99, 0xcd, 0xdf, 0x2d, 0x91, 0x99, 0x1d, 0xb5,
	0xbd, 0x31, 0x85, 0x3e, 0x04, 0x74, 0x1f, 0x07, 0xb2, 0x2b, 0xe7, 0x23, 0x69, 0xa2, 0x26, 0x37,
	0x40, 0x72, 0xf4, 0x53, 0xda, 0x09, 0x51, 0xa7, 0xae, 0x29, 0xc8, 0x66, 0xb7, 0x99, 0x52, 0xf1,
	0x3b, 0xba, 0x90, 0x1c, 0xb6, 0xbc, 0x2d, 0x80, 0xc6, 0xc5, 0x09, 0x20, 0xc3, 0xbe, 0xd8, 0xc9,
	0x67, 0x7d, 0x45, 0x08, 0x79, 0x21, 0x5f, 0x4d, 0xe4, 0xb0, 0x3c, 0xdd, 0x5e, 0x6e, 0x80, 0x1e,
	0xfa, 0x73, 0x31, 0x65, 0x3a, 0x97, 0x9f, 0xc2, 0x93, 0xe3, 0xcf, 0x65, 0x29, 0xd0, 0xf5, 0xdf,
	0x2c, 0xc2, 0x1c, 0x4b, 0x75, 0xe2, 0xee, 0xe7, 0x26, 0x40, 0x94, 0x35, 0x88, 0x4e, 0x27, 0x79,
	0x94, 0x52, 0x31, 0x1b, 0x67, 0xf2, 0xaa, 0xe3, 0x66, 0x2e, 0x96, 0x8d, 0x27, 0x9b, 0xb9, 0x74,
	0x72, 0xa1, 0x6c, 0xe6, 0x32, 0xd2, 0xf8, 0xd4, 0x29, 0xf4, 0x1e, 0x54, 0xc2, 0xe4, 0x2f, 0x59,
	0x79, 0x92, 0x59, 0x6c, 0x8d, 0xd3, 0x39, 0xb5, 0x71, 0xee, 0x62, 0x39, 0x5d, 0x32, 0x77, 0xe9,
	0x7c, 0x31, 0x99, 0xbb, 0xac, 0x64, 0xb0, 0xa8, 0xbf, 0x2c, 0x8f, 0x20, 0xa3, 0xbf, 0x52, 0x5e,
	0x49, 0x46, 0x7f, 0xe5, 0x04, 0x04, 0x75, 0xea, 0xee, 0x9d, 0x1f, 0xfd, 0xf4, 0x8c, 0xf2, 0xe3,
	0x9f, 0x9e, 0x99, 0xfa, 0xbf, 0x1f, 0x9f, 0x51, 0x7e, 0xf4, 0xf1, 0x19, 0xe5, 0xef, 0x3e, 0x3e,
	0xa3, 0xfc, 0xe4, 0xe3, 0x33, 0xca, 0xb7, 0xff, 0xf9, 0xcc, 0xd4, 0x87, 0xea, 0xa3, 0x9b, 0xfe,
	0x15, 0xcb, 0xb9, 0xda, 0xf5, 0xac, 0xcb, 0x86, 0x6b, 0x5d, 0x75, 0x1f, 0xf5, 0xae, 0x1a, 0xae,
	0xe5, 0x5f, 0xe5, 0x74, 0xaf, 0x3e, 0x7e, 0xf9, 0xe1, 0x0c, 0xfd, 0xef, 0x71, 0xaf, 0xfc, 0x77,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x26, 0xce, 0xd5, 0x75, 0xf7, 0x6f, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// RuntimeServiceClient is the client API for RuntimeService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RuntimeServiceClient interface {
	// Version returns the runtime name, runtime version, and runtime API version.
	Version(ctx context.Context, in *VersionRequest, opts ...grpc.CallOption) (*VersionResponse, error)
	// RunPodSandbox creates and starts a pod-level sandbox. Runtimes must ensure
	// the sandbox is in the ready state on success.
	RunPodSandbox(ctx context.Context, in *RunPodSandboxRequest, opts ...grpc.CallOption) (*RunPodSandboxResponse, error)
	// StopPodSandbox stops any running process that is part of the sandbox and
	// reclaims network resources (e.g., IP addresses) allocated to the sandbox.
	// If there are any running containers in the sandbox, they must be forcibly
	// terminated.
	// This call is idempotent, and must not return an error if all relevant
	// resources have already been reclaimed. kubelet will call StopPodSandbox
	// at least once before calling RemovePodSandbox. It will also attempt to
	// reclaim resources eagerly, as soon as a sandbox is not needed. Hence,
	// multiple StopPodSandbox calls are expected.
	StopPodSandbox(ctx context.Context, in *StopPodSandboxRequest, opts ...grpc.CallOption) (*StopPodSandboxResponse, error)
	// RemovePodSandbox removes the sandbox. If there are any running containers
	// in the sandbox, they must be forcibly terminated and removed.
	// This call is idempotent, and must not return an error if the sandbox has
	// already been removed.
	RemovePodSandbox(ctx context.Context, in *RemovePodSandboxRequest, opts ...grpc.CallOption) (*RemovePodSandboxResponse, error)
	// PodSandboxStatus returns the status of the PodSandbox. If the PodSandbox is not
	// present, returns an error.
	PodSandboxStatus(ctx context.Context, in *PodSandboxStatusRequest, opts ...grpc.CallOption) (*PodSandboxStatusResponse, error)
	// ListPodSandbox returns a list of PodSandboxes.
	ListPodSandbox(ctx context.Context, in *ListPodSandboxRequest, opts ...grpc.CallOption) (*ListPodSandboxResponse, error)
	// CreateContainer creates a new container in specified PodSandbox
	CreateContainer(ctx context.Context, in *CreateContainerRequest, opts ...grpc.CallOption) (*CreateContainerResponse, error)
	// StartContainer starts the container.
	StartContainer(ctx context.Context, in *StartContainerRequest, opts ...grpc.CallOption) (*StartContainerResponse, error)
	// StopContainer stops a running container with a grace period (i.e., timeout).
	// This call is idempotent, and must not return an error if the container has
	// already been stopped.
	// The runtime must forcibly kill the container after the grace period is
	// reached.
	StopContainer(ctx context.Context, in *StopContainerRequest, opts ...grpc.CallOption) (*StopContainerResponse, error)
	// RemoveContainer removes the container. If the container is running, the
	// container must be forcibly removed.
	// This call is idempotent, and must not return an error if the container has
	// already been removed.
	RemoveContainer(ctx context.Context, in *RemoveContainerRequest, opts ...grpc.CallOption) (*RemoveContainerResponse, error)
	// ListContainers lists all containers by filters.
	ListContainers(ctx context.Context, in *ListContainersRequest, opts ...grpc.CallOption) (*ListContainersResponse, error)
	// ContainerStatus returns status of the container. If the container is not
	// present, returns an error.
	ContainerStatus(ctx context.Context, in *ContainerStatusRequest, opts ...grpc.CallOption) (*ContainerStatusResponse, error)
	// UpdateContainerResources updates ContainerConfig of the container synchronously.
	// If runtime fails to transactionally update the requested resources, an error is returned.
	UpdateContainerResources(ctx context.Context, in *UpdateContainerResourcesRequest, opts ...grpc.CallOption) (*UpdateContainerResourcesResponse, error)
	// ReopenContainerLog asks runtime to reopen the stdout/stderr log file
	// for the container. This is often called after the log file has been
	// rotated. If the container is not running, container runtime can choose
	// to either create a new log file and return nil, or return an error.
	// Once it returns error, new container log file MUST NOT be created.
	ReopenContainerLog(ctx context.Context, in *ReopenContainerLogRequest, opts ...grpc.CallOption) (*ReopenContainerLogResponse, error)
	// ExecSync runs a command in a container synchronously.
	ExecSync(ctx context.Context, in *ExecSyncRequest, opts ...grpc.CallOption) (*ExecSyncResponse, error)
	// Exec prepares a streaming endpoint to execute a command in the container.
	Exec(ctx context.Context, in *ExecRequest, opts ...grpc.CallOption) (*ExecResponse, error)
	// Attach prepares a streaming endpoint to attach to a running container.
	Attach(ctx context.Context, in *AttachRequest, opts ...grpc.CallOption) (*AttachResponse, error)
	// PortForward prepares a streaming endpoint to forward ports from a PodSandbox.
	PortForward(ctx context.Context, in *PortForwardRequest, opts ...grpc.CallOption) (*PortForwardResponse, error)
	// ContainerStats returns stats of the container. If the container does not
	// exist, the call returns an error.
	ContainerStats(ctx context.Context, in *ContainerStatsRequest, opts ...grpc.CallOption) (*ContainerStatsResponse, error)
	// ListContainerStats returns stats of all running containers.
	ListContainerStats(ctx context.Context, in *ListContainerStatsRequest, opts ...grpc.CallOption) (*ListContainerStatsResponse, error)
	// PodSandboxStats returns stats of the pod sandbox. If the pod sandbox does not
	// exist, the call returns an error.
	PodSandboxStats(ctx context.Context, in *PodSandboxStatsRequest, opts ...grpc.CallOption) (*PodSandboxStatsResponse, error)
	// ListPodSandboxStats returns stats of the pod sandboxes matching a filter.
	ListPodSandboxStats(ctx context.Context, in *ListPodSandboxStatsRequest, opts ...grpc.CallOption) (*ListPodSandboxStatsResponse, error)
	// UpdateRuntimeConfig updates the runtime configuration based on the given request.
	UpdateRuntimeConfig(ctx context.Context, in *UpdateRuntimeConfigRequest, opts ...grpc.CallOption) (*UpdateRuntimeConfigResponse, error)
	// Status returns the status of the runtime.
	Status(ctx context.Context, in *StatusRequest, opts ...grpc.CallOption) (*StatusResponse, error)
	// CheckpointContainer checkpoints a container
	CheckpointContainer(ctx context.Context, in *CheckpointContainerRequest, opts ...grpc.CallOption) (*CheckpointContainerResponse, error)
	// GetContainerEvents gets container events from the CRI runtime
	GetContainerEvents(ctx context.Context, in *GetEventsRequest, opts ...grpc.CallOption) (RuntimeService_GetContainerEventsClient, error)
	// ListMetricDescriptors gets the descriptors for the metrics that will be returned in ListPodSandboxMetrics.
	// This list should be static at startup: either the client and server restart together when
	// adding or removing metrics descriptors, or they should not change.
	// Put differently, if ListPodSandboxMetrics references a name that is not described in the initial
	// ListMetricDescriptors call, then the metric will not be broadcasted.
	ListMetricDescriptors(ctx context.Context, in *ListMetricDescriptorsRequest, opts ...grpc.CallOption) (*ListMetricDescriptorsResponse, error)
	// ListPodSandboxMetrics gets pod sandbox metrics from CRI Runtime
	ListPodSandboxMetrics(ctx context.Context, in *ListPodSandboxMetricsRequest, opts ...grpc.CallOption) (*ListPodSandboxMetricsResponse, error)
	// RuntimeConfig returns configuration information of the runtime.
	// A couple of notes:
	//   - The RuntimeConfigRequest object is not to be confused with the contents of UpdateRuntimeConfigRequest.
	//     The former is for having runtime tell Kubelet what to do, the latter vice versa.
	//   - It is the expectation of the Kubelet that these fields are static for the lifecycle of the Kubelet.
	//     The Kubelet will not re-request the RuntimeConfiguration after startup, and CRI implementations should
	//     avoid updating them without a full node reboot.
	RuntimeConfig(ctx context.Context, in *RuntimeConfigRequest, opts ...grpc.CallOption) (*RuntimeConfigResponse, error)
}

type runtimeServiceClient struct {
	cc *grpc.ClientConn
}

func NewRuntimeServiceClient(cc *grpc.ClientConn) RuntimeServiceClient {
	return &runtimeServiceClient{cc}
}

func (c *runtimeServiceClient) Version(ctx context.Context, in *VersionRequest, opts ...grpc.CallOption) (*VersionResponse, error) {
	out := new(VersionResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/Version", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) RunPodSandbox(ctx context.Context, in *RunPodSandboxRequest, opts ...grpc.CallOption) (*RunPodSandboxResponse, error) {
	out := new(RunPodSandboxResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/RunPodSandbox", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) StopPodSandbox(ctx context.Context, in *StopPodSandboxRequest, opts ...grpc.CallOption) (*StopPodSandboxResponse, error) {
	out := new(StopPodSandboxResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/StopPodSandbox", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) RemovePodSandbox(ctx context.Context, in *RemovePodSandboxRequest, opts ...grpc.CallOption) (*RemovePodSandboxResponse, error) {
	out := new(RemovePodSandboxResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/RemovePodSandbox", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) PodSandboxStatus(ctx context.Context, in *PodSandboxStatusRequest, opts ...grpc.CallOption) (*PodSandboxStatusResponse, error) {
	out := new(PodSandboxStatusResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/PodSandboxStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) ListPodSandbox(ctx context.Context, in *ListPodSandboxRequest, opts ...grpc.CallOption) (*ListPodSandboxResponse, error) {
	out := new(ListPodSandboxResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/ListPodSandbox", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) CreateContainer(ctx context.Context, in *CreateContainerRequest, opts ...grpc.CallOption) (*CreateContainerResponse, error) {
	out := new(CreateContainerResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/CreateContainer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) StartContainer(ctx context.Context, in *StartContainerRequest, opts ...grpc.CallOption) (*StartContainerResponse, error) {
	out := new(StartContainerResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/StartContainer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) StopContainer(ctx context.Context, in *StopContainerRequest, opts ...grpc.CallOption) (*StopContainerResponse, error) {
	out := new(StopContainerResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/StopContainer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) RemoveContainer(ctx context.Context, in *RemoveContainerRequest, opts ...grpc.CallOption) (*RemoveContainerResponse, error) {
	out := new(RemoveContainerResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/RemoveContainer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) ListContainers(ctx context.Context, in *ListContainersRequest, opts ...grpc.CallOption) (*ListContainersResponse, error) {
	out := new(ListContainersResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/ListContainers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) ContainerStatus(ctx context.Context, in *ContainerStatusRequest, opts ...grpc.CallOption) (*ContainerStatusResponse, error) {
	out := new(ContainerStatusResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/ContainerStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) UpdateContainerResources(ctx context.Context, in *UpdateContainerResourcesRequest, opts ...grpc.CallOption) (*UpdateContainerResourcesResponse, error) {
	out := new(UpdateContainerResourcesResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/UpdateContainerResources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) ReopenContainerLog(ctx context.Context, in *ReopenContainerLogRequest, opts ...grpc.CallOption) (*ReopenContainerLogResponse, error) {
	out := new(ReopenContainerLogResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/ReopenContainerLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) ExecSync(ctx context.Context, in *ExecSyncRequest, opts ...grpc.CallOption) (*ExecSyncResponse, error) {
	out := new(ExecSyncResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/ExecSync", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) Exec(ctx context.Context, in *ExecRequest, opts ...grpc.CallOption) (*ExecResponse, error) {
	out := new(ExecResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/Exec", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) Attach(ctx context.Context, in *AttachRequest, opts ...grpc.CallOption) (*AttachResponse, error) {
	out := new(AttachResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/Attach", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) PortForward(ctx context.Context, in *PortForwardRequest, opts ...grpc.CallOption) (*PortForwardResponse, error) {
	out := new(PortForwardResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/PortForward", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) ContainerStats(ctx context.Context, in *ContainerStatsRequest, opts ...grpc.CallOption) (*ContainerStatsResponse, error) {
	out := new(ContainerStatsResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/ContainerStats", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) ListContainerStats(ctx context.Context, in *ListContainerStatsRequest, opts ...grpc.CallOption) (*ListContainerStatsResponse, error) {
	out := new(ListContainerStatsResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/ListContainerStats", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) PodSandboxStats(ctx context.Context, in *PodSandboxStatsRequest, opts ...grpc.CallOption) (*PodSandboxStatsResponse, error) {
	out := new(PodSandboxStatsResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/PodSandboxStats", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) ListPodSandboxStats(ctx context.Context, in *ListPodSandboxStatsRequest, opts ...grpc.CallOption) (*ListPodSandboxStatsResponse, error) {
	out := new(ListPodSandboxStatsResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/ListPodSandboxStats", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) UpdateRuntimeConfig(ctx context.Context, in *UpdateRuntimeConfigRequest, opts ...grpc.CallOption) (*UpdateRuntimeConfigResponse, error) {
	out := new(UpdateRuntimeConfigResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/UpdateRuntimeConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) Status(ctx context.Context, in *StatusRequest, opts ...grpc.CallOption) (*StatusResponse, error) {
	out := new(StatusResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/Status", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) CheckpointContainer(ctx context.Context, in *CheckpointContainerRequest, opts ...grpc.CallOption) (*CheckpointContainerResponse, error) {
	out := new(CheckpointContainerResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/CheckpointContainer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) GetContainerEvents(ctx context.Context, in *GetEventsRequest, opts ...grpc.CallOption) (RuntimeService_GetContainerEventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_RuntimeService_serviceDesc.Streams[0], "/runtime.v1.RuntimeService/GetContainerEvents", opts...)
	if err != nil {
		return nil, err
	}
	x := &runtimeServiceGetContainerEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type RuntimeService_GetContainerEventsClient interface {
	Recv() (*ContainerEventResponse, error)
	grpc.ClientStream
}

type runtimeServiceGetContainerEventsClient struct {
	grpc.ClientStream
}

func (x *runtimeServiceGetContainerEventsClient) Recv() (*ContainerEventResponse, error) {
	m := new(ContainerEventResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *runtimeServiceClient) ListMetricDescriptors(ctx context.Context, in *ListMetricDescriptorsRequest, opts ...grpc.CallOption) (*ListMetricDescriptorsResponse, error) {
	out := new(ListMetricDescriptorsResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/ListMetricDescriptors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) ListPodSandboxMetrics(ctx context.Context, in *ListPodSandboxMetricsRequest, opts ...grpc.CallOption) (*ListPodSandboxMetricsResponse, error) {
	out := new(ListPodSandboxMetricsResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/ListPodSandboxMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) RuntimeConfig(ctx context.Context, in *RuntimeConfigRequest, opts ...grpc.CallOption) (*RuntimeConfigResponse, error) {
	out := new(RuntimeConfigResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.RuntimeService/RuntimeConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RuntimeServiceServer is the server API for RuntimeService service.
type RuntimeServiceServer interface {
	// Version returns the runtime name, runtime version, and runtime API version.
	Version(context.Context, *VersionRequest) (*VersionResponse, error)
	// RunPodSandbox creates and starts a pod-level sandbox. Runtimes must ensure
	// the sandbox is in the ready state on success.
	RunPodSandbox(context.Context, *RunPodSandboxRequest) (*RunPodSandboxResponse, error)
	// StopPodSandbox stops any running process that is part of the sandbox and
	// reclaims network resources (e.g., IP addresses) allocated to the sandbox.
	// If there are any running containers in the sandbox, they must be forcibly
	// terminated.
	// This call is idempotent, and must not return an error if all relevant
	// resources have already been reclaimed. kubelet will call StopPodSandbox
	// at least once before calling RemovePodSandbox. It will also attempt to
	// reclaim resources eagerly, as soon as a sandbox is not needed. Hence,
	// multiple StopPodSandbox calls are expected.
	StopPodSandbox(context.Context, *StopPodSandboxRequest) (*StopPodSandboxResponse, error)
	// RemovePodSandbox removes the sandbox. If there are any running containers
	// in the sandbox, they must be forcibly terminated and removed.
	// This call is idempotent, and must not return an error if the sandbox has
	// already been removed.
	RemovePodSandbox(context.Context, *RemovePodSandboxRequest) (*RemovePodSandboxResponse, error)
	// PodSandboxStatus returns the status of the PodSandbox. If the PodSandbox is not
	// present, returns an error.
	PodSandboxStatus(context.Context, *PodSandboxStatusRequest) (*PodSandboxStatusResponse, error)
	// ListPodSandbox returns a list of PodSandboxes.
	ListPodSandbox(context.Context, *ListPodSandboxRequest) (*ListPodSandboxResponse, error)
	// CreateContainer creates a new container in specified PodSandbox
	CreateContainer(context.Context, *CreateContainerRequest) (*CreateContainerResponse, error)
	// StartContainer starts the container.
	StartContainer(context.Context, *StartContainerRequest) (*StartContainerResponse, error)
	// StopContainer stops a running container with a grace period (i.e., timeout).
	// This call is idempotent, and must not return an error if the container has
	// already been stopped.
	// The runtime must forcibly kill the container after the grace period is
	// reached.
	StopContainer(context.Context, *StopContainerRequest) (*StopContainerResponse, error)
	// RemoveContainer removes the container. If the container is running, the
	// container must be forcibly removed.
	// This call is idempotent, and must not return an error if the container has
	// already been removed.
	RemoveContainer(context.Context, *RemoveContainerRequest) (*RemoveContainerResponse, error)
	// ListContainers lists all containers by filters.
	ListContainers(context.Context, *ListContainersRequest) (*ListContainersResponse, error)
	// ContainerStatus returns status of the container. If the container is not
	// present, returns an error.
	ContainerStatus(context.Context, *ContainerStatusRequest) (*ContainerStatusResponse, error)
	// UpdateContainerResources updates ContainerConfig of the container synchronously.
	// If runtime fails to transactionally update the requested resources, an error is returned.
	UpdateContainerResources(context.Context, *UpdateContainerResourcesRequest) (*UpdateContainerResourcesResponse, error)
	// ReopenContainerLog asks runtime to reopen the stdout/stderr log file
	// for the container. This is often called after the log file has been
	// rotated. If the container is not running, container runtime can choose
	// to either create a new log file and return nil, or return an error.
	// Once it returns error, new container log file MUST NOT be created.
	ReopenContainerLog(context.Context, *ReopenContainerLogRequest) (*ReopenContainerLogResponse, error)
	// ExecSync runs a command in a container synchronously.
	ExecSync(context.Context, *ExecSyncRequest) (*ExecSyncResponse, error)
	// Exec prepares a streaming endpoint to execute a command in the container.
	Exec(context.Context, *ExecRequest) (*ExecResponse, error)
	// Attach prepares a streaming endpoint to attach to a running container.
	Attach(context.Context, *AttachRequest) (*AttachResponse, error)
	// PortForward prepares a streaming endpoint to forward ports from a PodSandbox.
	PortForward(context.Context, *PortForwardRequest) (*PortForwardResponse, error)
	// ContainerStats returns stats of the container. If the container does not
	// exist, the call returns an error.
	ContainerStats(context.Context, *ContainerStatsRequest) (*ContainerStatsResponse, error)
	// ListContainerStats returns stats of all running containers.
	ListContainerStats(context.Context, *ListContainerStatsRequest) (*ListContainerStatsResponse, error)
	// PodSandboxStats returns stats of the pod sandbox. If the pod sandbox does not
	// exist, the call returns an error.
	PodSandboxStats(context.Context, *PodSandboxStatsRequest) (*PodSandboxStatsResponse, error)
	// ListPodSandboxStats returns stats of the pod sandboxes matching a filter.
	ListPodSandboxStats(context.Context, *ListPodSandboxStatsRequest) (*ListPodSandboxStatsResponse, error)
	// UpdateRuntimeConfig updates the runtime configuration based on the given request.
	UpdateRuntimeConfig(context.Context, *UpdateRuntimeConfigRequest) (*UpdateRuntimeConfigResponse, error)
	// Status returns the status of the runtime.
	Status(context.Context, *StatusRequest) (*StatusResponse, error)
	// CheckpointContainer checkpoints a container
	CheckpointContainer(context.Context, *CheckpointContainerRequest) (*CheckpointContainerResponse, error)
	// GetContainerEvents gets container events from the CRI runtime
	GetContainerEvents(*GetEventsRequest, RuntimeService_GetContainerEventsServer) error
	// ListMetricDescriptors gets the descriptors for the metrics that will be returned in ListPodSandboxMetrics.
	// This list should be static at startup: either the client and server restart together when
	// adding or removing metrics descriptors, or they should not change.
	// Put differently, if ListPodSandboxMetrics references a name that is not described in the initial
	// ListMetricDescriptors call, then the metric will not be broadcasted.
	ListMetricDescriptors(context.Context, *ListMetricDescriptorsRequest) (*ListMetricDescriptorsResponse, error)
	// ListPodSandboxMetrics gets pod sandbox metrics from CRI Runtime
	ListPodSandboxMetrics(context.Context, *ListPodSandboxMetricsRequest) (*ListPodSandboxMetricsResponse, error)
	// RuntimeConfig returns configuration information of the runtime.
	// A couple of notes:
	//   - The RuntimeConfigRequest object is not to be confused with the contents of UpdateRuntimeConfigRequest.
	//     The former is for having runtime tell Kubelet what to do, the latter vice versa.
	//   - It is the expectation of the Kubelet that these fields are static for the lifecycle of the Kubelet.
	//     The Kubelet will not re-request the RuntimeConfiguration after startup, and CRI implementations should
	//     avoid updating them without a full node reboot.
	RuntimeConfig(context.Context, *RuntimeConfigRequest) (*RuntimeConfigResponse, error)
}

// UnimplementedRuntimeServiceServer can be embedded to have forward compatible implementations.
type UnimplementedRuntimeServiceServer struct {
}

func (*UnimplementedRuntimeServiceServer) Version(ctx context.Context, req *VersionRequest) (*VersionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Version not implemented")
}
func (*UnimplementedRuntimeServiceServer) RunPodSandbox(ctx context.Context, req *RunPodSandboxRequest) (*RunPodSandboxResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunPodSandbox not implemented")
}
func (*UnimplementedRuntimeServiceServer) StopPodSandbox(ctx context.Context, req *StopPodSandboxRequest) (*StopPodSandboxResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopPodSandbox not implemented")
}
func (*UnimplementedRuntimeServiceServer) RemovePodSandbox(ctx context.Context, req *RemovePodSandboxRequest) (*RemovePodSandboxResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemovePodSandbox not implemented")
}
func (*UnimplementedRuntimeServiceServer) PodSandboxStatus(ctx context.Context, req *PodSandboxStatusRequest) (*PodSandboxStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PodSandboxStatus not implemented")
}
func (*UnimplementedRuntimeServiceServer) ListPodSandbox(ctx context.Context, req *ListPodSandboxRequest) (*ListPodSandboxResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPodSandbox not implemented")
}
func (*UnimplementedRuntimeServiceServer) CreateContainer(ctx context.Context, req *CreateContainerRequest) (*CreateContainerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateContainer not implemented")
}
func (*UnimplementedRuntimeServiceServer) StartContainer(ctx context.Context, req *StartContainerRequest) (*StartContainerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartContainer not implemented")
}
func (*UnimplementedRuntimeServiceServer) StopContainer(ctx context.Context, req *StopContainerRequest) (*StopContainerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopContainer not implemented")
}
func (*UnimplementedRuntimeServiceServer) RemoveContainer(ctx context.Context, req *RemoveContainerRequest) (*RemoveContainerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveContainer not implemented")
}
func (*UnimplementedRuntimeServiceServer) ListContainers(ctx context.Context, req *ListContainersRequest) (*ListContainersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListContainers not implemented")
}
func (*UnimplementedRuntimeServiceServer) ContainerStatus(ctx context.Context, req *ContainerStatusRequest) (*ContainerStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ContainerStatus not implemented")
}
func (*UnimplementedRuntimeServiceServer) UpdateContainerResources(ctx context.Context, req *UpdateContainerResourcesRequest) (*UpdateContainerResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateContainerResources not implemented")
}
func (*UnimplementedRuntimeServiceServer) ReopenContainerLog(ctx context.Context, req *ReopenContainerLogRequest) (*ReopenContainerLogResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReopenContainerLog not implemented")
}
func (*UnimplementedRuntimeServiceServer) ExecSync(ctx context.Context, req *ExecSyncRequest) (*ExecSyncResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExecSync not implemented")
}
func (*UnimplementedRuntimeServiceServer) Exec(ctx context.Context, req *ExecRequest) (*ExecResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Exec not implemented")
}
func (*UnimplementedRuntimeServiceServer) Attach(ctx context.Context, req *AttachRequest) (*AttachResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Attach not implemented")
}
func (*UnimplementedRuntimeServiceServer) PortForward(ctx context.Context, req *PortForwardRequest) (*PortForwardResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PortForward not implemented")
}
func (*UnimplementedRuntimeServiceServer) ContainerStats(ctx context.Context, req *ContainerStatsRequest) (*ContainerStatsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ContainerStats not implemented")
}
func (*UnimplementedRuntimeServiceServer) ListContainerStats(ctx context.Context, req *ListContainerStatsRequest) (*ListContainerStatsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListContainerStats not implemented")
}
func (*UnimplementedRuntimeServiceServer) PodSandboxStats(ctx context.Context, req *PodSandboxStatsRequest) (*PodSandboxStatsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PodSandboxStats not implemented")
}
func (*UnimplementedRuntimeServiceServer) ListPodSandboxStats(ctx context.Context, req *ListPodSandboxStatsRequest) (*ListPodSandboxStatsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPodSandboxStats not implemented")
}
func (*UnimplementedRuntimeServiceServer) UpdateRuntimeConfig(ctx context.Context, req *UpdateRuntimeConfigRequest) (*UpdateRuntimeConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRuntimeConfig not implemented")
}
func (*UnimplementedRuntimeServiceServer) Status(ctx context.Context, req *StatusRequest) (*StatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Status not implemented")
}
func (*UnimplementedRuntimeServiceServer) CheckpointContainer(ctx context.Context, req *CheckpointContainerRequest) (*CheckpointContainerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckpointContainer not implemented")
}
func (*UnimplementedRuntimeServiceServer) GetContainerEvents(req *GetEventsRequest, srv RuntimeService_GetContainerEventsServer) error {
	return status.Errorf(codes.Unimplemented, "method GetContainerEvents not implemented")
}
func (*UnimplementedRuntimeServiceServer) ListMetricDescriptors(ctx context.Context, req *ListMetricDescriptorsRequest) (*ListMetricDescriptorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMetricDescriptors not implemented")
}
func (*UnimplementedRuntimeServiceServer) ListPodSandboxMetrics(ctx context.Context, req *ListPodSandboxMetricsRequest) (*ListPodSandboxMetricsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPodSandboxMetrics not implemented")
}
func (*UnimplementedRuntimeServiceServer) RuntimeConfig(ctx context.Context, req *RuntimeConfigRequest) (*RuntimeConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RuntimeConfig not implemented")
}

func RegisterRuntimeServiceServer(s *grpc.Server, srv RuntimeServiceServer) {
	s.RegisterService(&_RuntimeService_serviceDesc, srv)
}

func _RuntimeService_Version_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).Version(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/Version",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).Version(ctx, req.(*VersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_RunPodSandbox_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunPodSandboxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).RunPodSandbox(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/RunPodSandbox",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).RunPodSandbox(ctx, req.(*RunPodSandboxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_StopPodSandbox_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopPodSandboxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).StopPodSandbox(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/StopPodSandbox",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).StopPodSandbox(ctx, req.(*StopPodSandboxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_RemovePodSandbox_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemovePodSandboxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).RemovePodSandbox(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/RemovePodSandbox",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).RemovePodSandbox(ctx, req.(*RemovePodSandboxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_PodSandboxStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PodSandboxStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).PodSandboxStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/PodSandboxStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).PodSandboxStatus(ctx, req.(*PodSandboxStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_ListPodSandbox_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPodSandboxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).ListPodSandbox(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/ListPodSandbox",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).ListPodSandbox(ctx, req.(*ListPodSandboxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_CreateContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).CreateContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/CreateContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).CreateContainer(ctx, req.(*CreateContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_StartContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).StartContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/StartContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).StartContainer(ctx, req.(*StartContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_StopContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).StopContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/StopContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).StopContainer(ctx, req.(*StopContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_RemoveContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).RemoveContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/RemoveContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).RemoveContainer(ctx, req.(*RemoveContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_ListContainers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListContainersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).ListContainers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/ListContainers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).ListContainers(ctx, req.(*ListContainersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_ContainerStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContainerStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).ContainerStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/ContainerStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).ContainerStatus(ctx, req.(*ContainerStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_UpdateContainerResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateContainerResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).UpdateContainerResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/UpdateContainerResources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).UpdateContainerResources(ctx, req.(*UpdateContainerResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_ReopenContainerLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReopenContainerLogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).ReopenContainerLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/ReopenContainerLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).ReopenContainerLog(ctx, req.(*ReopenContainerLogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_ExecSync_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecSyncRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).ExecSync(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/ExecSync",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).ExecSync(ctx, req.(*ExecSyncRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_Exec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).Exec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/Exec",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).Exec(ctx, req.(*ExecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_Attach_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AttachRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).Attach(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/Attach",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).Attach(ctx, req.(*AttachRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_PortForward_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PortForwardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).PortForward(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/PortForward",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).PortForward(ctx, req.(*PortForwardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_ContainerStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContainerStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).ContainerStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/ContainerStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).ContainerStats(ctx, req.(*ContainerStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_ListContainerStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListContainerStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).ListContainerStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/ListContainerStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).ListContainerStats(ctx, req.(*ListContainerStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_PodSandboxStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PodSandboxStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).PodSandboxStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/PodSandboxStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).PodSandboxStats(ctx, req.(*PodSandboxStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_ListPodSandboxStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPodSandboxStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).ListPodSandboxStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/ListPodSandboxStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).ListPodSandboxStats(ctx, req.(*ListPodSandboxStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_UpdateRuntimeConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRuntimeConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).UpdateRuntimeConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/UpdateRuntimeConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).UpdateRuntimeConfig(ctx, req.(*UpdateRuntimeConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_Status_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).Status(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/Status",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).Status(ctx, req.(*StatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_CheckpointContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckpointContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).CheckpointContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/CheckpointContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).CheckpointContainer(ctx, req.(*CheckpointContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_GetContainerEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetEventsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RuntimeServiceServer).GetContainerEvents(m, &runtimeServiceGetContainerEventsServer{stream})
}

type RuntimeService_GetContainerEventsServer interface {
	Send(*ContainerEventResponse) error
	grpc.ServerStream
}

type runtimeServiceGetContainerEventsServer struct {
	grpc.ServerStream
}

func (x *runtimeServiceGetContainerEventsServer) Send(m *ContainerEventResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _RuntimeService_ListMetricDescriptors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMetricDescriptorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).ListMetricDescriptors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/ListMetricDescriptors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).ListMetricDescriptors(ctx, req.(*ListMetricDescriptorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_ListPodSandboxMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPodSandboxMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).ListPodSandboxMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/ListPodSandboxMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).ListPodSandboxMetrics(ctx, req.(*ListPodSandboxMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_RuntimeConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RuntimeConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).RuntimeConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.RuntimeService/RuntimeConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).RuntimeConfig(ctx, req.(*RuntimeConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RuntimeService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "runtime.v1.RuntimeService",
	HandlerType: (*RuntimeServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Version",
			Handler:    _RuntimeService_Version_Handler,
		},
		{
			MethodName: "RunPodSandbox",
			Handler:    _RuntimeService_RunPodSandbox_Handler,
		},
		{
			MethodName: "StopPodSandbox",
			Handler:    _RuntimeService_StopPodSandbox_Handler,
		},
		{
			MethodName: "RemovePodSandbox",
			Handler:    _RuntimeService_RemovePodSandbox_Handler,
		},
		{
			MethodName: "PodSandboxStatus",
			Handler:    _RuntimeService_PodSandboxStatus_Handler,
		},
		{
			MethodName: "ListPodSandbox",
			Handler:    _RuntimeService_ListPodSandbox_Handler,
		},
		{
			MethodName: "CreateContainer",
			Handler:    _RuntimeService_CreateContainer_Handler,
		},
		{
			MethodName: "StartContainer",
			Handler:    _RuntimeService_StartContainer_Handler,
		},
		{
			MethodName: "StopContainer",
			Handler:    _RuntimeService_StopContainer_Handler,
		},
		{
			MethodName: "RemoveContainer",
			Handler:    _RuntimeService_RemoveContainer_Handler,
		},
		{
			MethodName: "ListContainers",
			Handler:    _RuntimeService_ListContainers_Handler,
		},
		{
			MethodName: "ContainerStatus",
			Handler:    _RuntimeService_ContainerStatus_Handler,
		},
		{
			MethodName: "UpdateContainerResources",
			Handler:    _RuntimeService_UpdateContainerResources_Handler,
		},
		{
			MethodName: "ReopenContainerLog",
			Handler:    _RuntimeService_ReopenContainerLog_Handler,
		},
		{
			MethodName: "ExecSync",
			Handler:    _RuntimeService_ExecSync_Handler,
		},
		{
			MethodName: "Exec",
			Handler:    _RuntimeService_Exec_Handler,
		},
		{
			MethodName: "Attach",
			Handler:    _RuntimeService_Attach_Handler,
		},
		{
			MethodName: "PortForward",
			Handler:    _RuntimeService_PortForward_Handler,
		},
		{
			MethodName: "ContainerStats",
			Handler:    _RuntimeService_ContainerStats_Handler,
		},
		{
			MethodName: "ListContainerStats",
			Handler:    _RuntimeService_ListContainerStats_Handler,
		},
		{
			MethodName: "PodSandboxStats",
			Handler:    _RuntimeService_PodSandboxStats_Handler,
		},
		{
			MethodName: "ListPodSandboxStats",
			Handler:    _RuntimeService_ListPodSandboxStats_Handler,
		},
		{
			MethodName: "UpdateRuntimeConfig",
			Handler:    _RuntimeService_UpdateRuntimeConfig_Handler,
		},
		{
			MethodName: "Status",
			Handler:    _RuntimeService_Status_Handler,
		},
		{
			MethodName: "CheckpointContainer",
			Handler:    _RuntimeService_CheckpointContainer_Handler,
		},
		{
			MethodName: "ListMetricDescriptors",
			Handler:    _RuntimeService_ListMetricDescriptors_Handler,
		},
		{
			MethodName: "ListPodSandboxMetrics",
			Handler:    _RuntimeService_ListPodSandboxMetrics_Handler,
		},
		{
			MethodName: "RuntimeConfig",
			Handler:    _RuntimeService_RuntimeConfig_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetContainerEvents",
			Handler:       _RuntimeService_GetContainerEvents_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "api.proto",
}

// ImageServiceClient is the client API for ImageService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ImageServiceClient interface {
	// ListImages lists existing images.
	ListImages(ctx context.Context, in *ListImagesRequest, opts ...grpc.CallOption) (*ListImagesResponse, error)
	// ImageStatus returns the status of the image. If the image is not
	// present, returns a response with ImageStatusResponse.Image set to
	// nil.
	ImageStatus(ctx context.Context, in *ImageStatusRequest, opts ...grpc.CallOption) (*ImageStatusResponse, error)
	// PullImage pulls an image with authentication config.
	PullImage(ctx context.Context, in *PullImageRequest, opts ...grpc.CallOption) (*PullImageResponse, error)
	// RemoveImage removes the image.
	// This call is idempotent, and must not return an error if the image has
	// already been removed.
	RemoveImage(ctx context.Context, in *RemoveImageRequest, opts ...grpc.CallOption) (*RemoveImageResponse, error)
	// ImageFSInfo returns information of the filesystem that is used to store images.
	ImageFsInfo(ctx context.Context, in *ImageFsInfoRequest, opts ...grpc.CallOption) (*ImageFsInfoResponse, error)
}

type imageServiceClient struct {
	cc *grpc.ClientConn
}

func NewImageServiceClient(cc *grpc.ClientConn) ImageServiceClient {
	return &imageServiceClient{cc}
}

func (c *imageServiceClient) ListImages(ctx context.Context, in *ListImagesRequest, opts ...grpc.CallOption) (*ListImagesResponse, error) {
	out := new(ListImagesResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.ImageService/ListImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) ImageStatus(ctx context.Context, in *ImageStatusRequest, opts ...grpc.CallOption) (*ImageStatusResponse, error) {
	out := new(ImageStatusResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.ImageService/ImageStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) PullImage(ctx context.Context, in *PullImageRequest, opts ...grpc.CallOption) (*PullImageResponse, error) {
	out := new(PullImageResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.ImageService/PullImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) RemoveImage(ctx context.Context, in *RemoveImageRequest, opts ...grpc.CallOption) (*RemoveImageResponse, error) {
	out := new(RemoveImageResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.ImageService/RemoveImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) ImageFsInfo(ctx context.Context, in *ImageFsInfoRequest, opts ...grpc.CallOption) (*ImageFsInfoResponse, error) {
	out := new(ImageFsInfoResponse)
	err := c.cc.Invoke(ctx, "/runtime.v1.ImageService/ImageFsInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ImageServiceServer is the server API for ImageService service.
type ImageServiceServer interface {
	// ListImages lists existing images.
	ListImages(context.Context, *ListImagesRequest) (*ListImagesResponse, error)
	// ImageStatus returns the status of the image. If the image is not
	// present, returns a response with ImageStatusResponse.Image set to
	// nil.
	ImageStatus(context.Context, *ImageStatusRequest) (*ImageStatusResponse, error)
	// PullImage pulls an image with authentication config.
	PullImage(context.Context, *PullImageRequest) (*PullImageResponse, error)
	// RemoveImage removes the image.
	// This call is idempotent, and must not return an error if the image has
	// already been removed.
	RemoveImage(context.Context, *RemoveImageRequest) (*RemoveImageResponse, error)
	// ImageFSInfo returns information of the filesystem that is used to store images.
	ImageFsInfo(context.Context, *ImageFsInfoRequest) (*ImageFsInfoResponse, error)
}

// UnimplementedImageServiceServer can be embedded to have forward compatible implementations.
type UnimplementedImageServiceServer struct {
}

func (*UnimplementedImageServiceServer) ListImages(ctx context.Context, req *ListImagesRequest) (*ListImagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListImages not implemented")
}
func (*UnimplementedImageServiceServer) ImageStatus(ctx context.Context, req *ImageStatusRequest) (*ImageStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImageStatus not implemented")
}
func (*UnimplementedImageServiceServer) PullImage(ctx context.Context, req *PullImageRequest) (*PullImageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PullImage not implemented")
}
func (*UnimplementedImageServiceServer) RemoveImage(ctx context.Context, req *RemoveImageRequest) (*RemoveImageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveImage not implemented")
}
func (*UnimplementedImageServiceServer) ImageFsInfo(ctx context.Context, req *ImageFsInfoRequest) (*ImageFsInfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImageFsInfo not implemented")
}

func RegisterImageServiceServer(s *grpc.Server, srv ImageServiceServer) {
	s.RegisterService(&_ImageService_serviceDesc, srv)
}

func _ImageService_ListImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).ListImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.ImageService/ListImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).ListImages(ctx, req.(*ListImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_ImageStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImageStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).ImageStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.ImageService/ImageStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).ImageStatus(ctx, req.(*ImageStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_PullImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PullImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).PullImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.ImageService/PullImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).PullImage(ctx, req.(*PullImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_RemoveImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).RemoveImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.ImageService/RemoveImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).RemoveImage(ctx, req.(*RemoveImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_ImageFsInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImageFsInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).ImageFsInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.v1.ImageService/ImageFsInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).ImageFsInfo(ctx, req.(*ImageFsInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ImageService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "runtime.v1.ImageService",
	HandlerType: (*ImageServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListImages",
			Handler:    _ImageService_ListImages_Handler,
		},
		{
			MethodName: "ImageStatus",
			Handler:    _ImageService_ImageStatus_Handler,
		},
		{
			MethodName: "PullImage",
			Handler:    _ImageService_PullImage_Handler,
		},
		{
			MethodName: "RemoveImage",
			Handler:    _ImageService_RemoveImage_Handler,
		},
		{
			MethodName: "ImageFsInfo",
			Handler:    _ImageService_ImageFsInfo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api.proto",
}

func (m *VersionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VersionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VersionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *VersionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VersionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VersionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.RuntimeApiVersion) > 0 {
		i -= len(m.RuntimeApiVersion)
		copy(dAtA[i:], m.RuntimeApiVersion)
		i = encodeVarintApi(dAtA, i, uint64(len(m.RuntimeApiVersion)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.RuntimeVersion) > 0 {
		i -= len(m.RuntimeVersion)
		copy(dAtA[i:], m.RuntimeVersion)
		i = encodeVarintApi(dAtA, i, uint64(len(m.RuntimeVersion)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.RuntimeName) > 0 {
		i -= len(m.RuntimeName)
		copy(dAtA[i:], m.RuntimeName)
		i = encodeVarintApi(dAtA, i, uint64(len(m.RuntimeName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DNSConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DNSConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DNSConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Options) > 0 {
		for iNdEx := len(m.Options) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Options[iNdEx])
			copy(dAtA[i:], m.Options[iNdEx])
			i = encodeVarintApi(dAtA, i, uint64(len(m.Options[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Searches) > 0 {
		for iNdEx := len(m.Searches) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Searches[iNdEx])
			copy(dAtA[i:], m.Searches[iNdEx])
			i = encodeVarintApi(dAtA, i, uint64(len(m.Searches[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Servers) > 0 {
		for iNdEx := len(m.Servers) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Servers[iNdEx])
			copy(dAtA[i:], m.Servers[iNdEx])
			i = encodeVarintApi(dAtA, i, uint64(len(m.Servers[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *PortMapping) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PortMapping) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PortMapping) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.HostIp) > 0 {
		i -= len(m.HostIp)
		copy(dAtA[i:], m.HostIp)
		i = encodeVarintApi(dAtA, i, uint64(len(m.HostIp)))
		i--
		dAtA[i] = 0x22
	}
	if m.HostPort != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.HostPort))
		i--
		dAtA[i] = 0x18
	}
	if m.ContainerPort != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.ContainerPort))
		i--
		dAtA[i] = 0x10
	}
	if m.Protocol != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Protocol))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Mount) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Mount) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Mount) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.RecursiveReadOnly {
		i--
		if m.RecursiveReadOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if len(m.GidMappings) > 0 {
		for iNdEx := len(m.GidMappings) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.GidMappings[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.UidMappings) > 0 {
		for iNdEx := len(m.UidMappings) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.UidMappings[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.Propagation != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Propagation))
		i--
		dAtA[i] = 0x28
	}
	if m.SelinuxRelabel {
		i--
		if m.SelinuxRelabel {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Readonly {
		i--
		if m.Readonly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.HostPath) > 0 {
		i -= len(m.HostPath)
		copy(dAtA[i:], m.HostPath)
		i = encodeVarintApi(dAtA, i, uint64(len(m.HostPath)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ContainerPath) > 0 {
		i -= len(m.ContainerPath)
		copy(dAtA[i:], m.ContainerPath)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ContainerPath)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IDMapping) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IDMapping) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IDMapping) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Length != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Length))
		i--
		dAtA[i] = 0x18
	}
	if m.ContainerId != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.ContainerId))
		i--
		dAtA[i] = 0x10
	}
	if m.HostId != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.HostId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *UserNamespace) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UserNamespace) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UserNamespace) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Gids) > 0 {
		for iNdEx := len(m.Gids) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Gids[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Uids) > 0 {
		for iNdEx := len(m.Uids) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Uids[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Mode != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Mode))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NamespaceOption) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceOption) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NamespaceOption) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.UsernsOptions != nil {
		{
			size, err := m.UsernsOptions.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.TargetId) > 0 {
		i -= len(m.TargetId)
		copy(dAtA[i:], m.TargetId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.TargetId)))
		i--
		dAtA[i] = 0x22
	}
	if m.Ipc != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Ipc))
		i--
		dAtA[i] = 0x18
	}
	if m.Pid != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Pid))
		i--
		dAtA[i] = 0x10
	}
	if m.Network != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Network))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Int64Value) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Int64Value) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Int64Value) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Value != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Value))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LinuxSandboxSecurityContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxSandboxSecurityContext) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxSandboxSecurityContext) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SupplementalGroupsPolicy != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.SupplementalGroupsPolicy))
		i--
		dAtA[i] = 0x58
	}
	if m.Apparmor != nil {
		{
			size, err := m.Apparmor.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.Seccomp != nil {
		{
			size, err := m.Seccomp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.RunAsGroup != nil {
		{
			size, err := m.RunAsGroup.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.SeccompProfilePath) > 0 {
		i -= len(m.SeccompProfilePath)
		copy(dAtA[i:], m.SeccompProfilePath)
		i = encodeVarintApi(dAtA, i, uint64(len(m.SeccompProfilePath)))
		i--
		dAtA[i] = 0x3a
	}
	if m.Privileged {
		i--
		if m.Privileged {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.SupplementalGroups) > 0 {
		dAtA6 := make([]byte, len(m.SupplementalGroups)*10)
		var j5 int
		for _, num1 := range m.SupplementalGroups {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA6[j5] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j5++
			}
			dAtA6[j5] = uint8(num)
			j5++
		}
		i -= j5
		copy(dAtA[i:], dAtA6[:j5])
		i = encodeVarintApi(dAtA, i, uint64(j5))
		i--
		dAtA[i] = 0x2a
	}
	if m.ReadonlyRootfs {
		i--
		if m.ReadonlyRootfs {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.RunAsUser != nil {
		{
			size, err := m.RunAsUser.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.SelinuxOptions != nil {
		{
			size, err := m.SelinuxOptions.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.NamespaceOptions != nil {
		{
			size, err := m.NamespaceOptions.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SecurityProfile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecurityProfile) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SecurityProfile) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.LocalhostRef) > 0 {
		i -= len(m.LocalhostRef)
		copy(dAtA[i:], m.LocalhostRef)
		i = encodeVarintApi(dAtA, i, uint64(len(m.LocalhostRef)))
		i--
		dAtA[i] = 0x12
	}
	if m.ProfileType != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.ProfileType))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LinuxPodSandboxConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxPodSandboxConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxPodSandboxConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Resources != nil {
		{
			size, err := m.Resources.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Overhead != nil {
		{
			size, err := m.Overhead.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Sysctls) > 0 {
		for k := range m.Sysctls {
			v := m.Sysctls[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.SecurityContext != nil {
		{
			size, err := m.SecurityContext.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.CgroupParent) > 0 {
		i -= len(m.CgroupParent)
		copy(dAtA[i:], m.CgroupParent)
		i = encodeVarintApi(dAtA, i, uint64(len(m.CgroupParent)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodSandboxMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSandboxMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodSandboxMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Attempt != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Attempt))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Uid) > 0 {
		i -= len(m.Uid)
		copy(dAtA[i:], m.Uid)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Uid)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodSandboxConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSandboxConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodSandboxConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Windows != nil {
		{
			size, err := m.Windows.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.Linux != nil {
		{
			size, err := m.Linux.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.PortMappings) > 0 {
		for iNdEx := len(m.PortMappings) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PortMappings[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.DnsConfig != nil {
		{
			size, err := m.DnsConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.LogDirectory) > 0 {
		i -= len(m.LogDirectory)
		copy(dAtA[i:], m.LogDirectory)
		i = encodeVarintApi(dAtA, i, uint64(len(m.LogDirectory)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Hostname) > 0 {
		i -= len(m.Hostname)
		copy(dAtA[i:], m.Hostname)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Hostname)))
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RunPodSandboxRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RunPodSandboxRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RunPodSandboxRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.RuntimeHandler) > 0 {
		i -= len(m.RuntimeHandler)
		copy(dAtA[i:], m.RuntimeHandler)
		i = encodeVarintApi(dAtA, i, uint64(len(m.RuntimeHandler)))
		i--
		dAtA[i] = 0x12
	}
	if m.Config != nil {
		{
			size, err := m.Config.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RunPodSandboxResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RunPodSandboxResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RunPodSandboxResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PodSandboxId) > 0 {
		i -= len(m.PodSandboxId)
		copy(dAtA[i:], m.PodSandboxId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.PodSandboxId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StopPodSandboxRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StopPodSandboxRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StopPodSandboxRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PodSandboxId) > 0 {
		i -= len(m.PodSandboxId)
		copy(dAtA[i:], m.PodSandboxId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.PodSandboxId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StopPodSandboxResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StopPodSandboxResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StopPodSandboxResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *RemovePodSandboxRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemovePodSandboxRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemovePodSandboxRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PodSandboxId) > 0 {
		i -= len(m.PodSandboxId)
		copy(dAtA[i:], m.PodSandboxId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.PodSandboxId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RemovePodSandboxResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemovePodSandboxResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemovePodSandboxResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *PodSandboxStatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSandboxStatusRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodSandboxStatusRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Verbose {
		i--
		if m.Verbose {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.PodSandboxId) > 0 {
		i -= len(m.PodSandboxId)
		copy(dAtA[i:], m.PodSandboxId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.PodSandboxId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodIP) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodIP) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodIP) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Ip) > 0 {
		i -= len(m.Ip)
		copy(dAtA[i:], m.Ip)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Ip)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodSandboxNetworkStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSandboxNetworkStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodSandboxNetworkStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.AdditionalIps) > 0 {
		for iNdEx := len(m.AdditionalIps) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.AdditionalIps[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Ip) > 0 {
		i -= len(m.Ip)
		copy(dAtA[i:], m.Ip)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Ip)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Namespace) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Namespace) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Namespace) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func (m *LinuxPodSandboxStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxPodSandboxStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxPodSandboxStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Namespaces != nil {
		{
			size, err := m.Namespaces.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodSandboxStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSandboxStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodSandboxStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.RuntimeHandler) > 0 {
		i -= len(m.RuntimeHandler)
		copy(dAtA[i:], m.RuntimeHandler)
		i = encodeVarintApi(dAtA, i, uint64(len(m.RuntimeHandler)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Linux != nil {
		{
			size, err := m.Linux.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.Network != nil {
		{
			size, err := m.Network.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.CreatedAt != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.CreatedAt))
		i--
		dAtA[i] = 0x20
	}
	if m.State != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x18
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodSandboxStatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSandboxStatusResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodSandboxStatusResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Timestamp != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Timestamp))
		i--
		dAtA[i] = 0x20
	}
	if len(m.ContainersStatuses) > 0 {
		for iNdEx := len(m.ContainersStatuses) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ContainersStatuses[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Info) > 0 {
		for k := range m.Info {
			v := m.Info[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodSandboxStateValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSandboxStateValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodSandboxStateValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.State != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PodSandboxFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSandboxFilter) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodSandboxFilter) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.LabelSelector) > 0 {
		for k := range m.LabelSelector {
			v := m.LabelSelector[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.State != nil {
		{
			size, err := m.State.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListPodSandboxRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListPodSandboxRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListPodSandboxRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Filter != nil {
		{
			size, err := m.Filter.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodSandbox) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSandbox) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodSandbox) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.RuntimeHandler) > 0 {
		i -= len(m.RuntimeHandler)
		copy(dAtA[i:], m.RuntimeHandler)
		i = encodeVarintApi(dAtA, i, uint64(len(m.RuntimeHandler)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.CreatedAt != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.CreatedAt))
		i--
		dAtA[i] = 0x20
	}
	if m.State != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x18
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListPodSandboxResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListPodSandboxResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListPodSandboxResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *PodSandboxStatsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSandboxStatsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodSandboxStatsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PodSandboxId) > 0 {
		i -= len(m.PodSandboxId)
		copy(dAtA[i:], m.PodSandboxId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.PodSandboxId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodSandboxStatsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSandboxStatsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodSandboxStatsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Stats != nil {
		{
			size, err := m.Stats.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodSandboxStatsFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSandboxStatsFilter) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodSandboxStatsFilter) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.LabelSelector) > 0 {
		for k := range m.LabelSelector {
			v := m.LabelSelector[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListPodSandboxStatsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListPodSandboxStatsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListPodSandboxStatsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Filter != nil {
		{
			size, err := m.Filter.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListPodSandboxStatsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListPodSandboxStatsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListPodSandboxStatsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Stats) > 0 {
		for iNdEx := len(m.Stats) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Stats[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *PodSandboxAttributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSandboxAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodSandboxAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PodSandboxStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSandboxStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodSandboxStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Windows != nil {
		{
			size, err := m.Windows.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Linux != nil {
		{
			size, err := m.Linux.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Attributes != nil {
		{
			size, err := m.Attributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LinuxPodSandboxStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxPodSandboxStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxPodSandboxStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Containers) > 0 {
		for iNdEx := len(m.Containers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Containers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.Process != nil {
		{
			size, err := m.Process.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Network != nil {
		{
			size, err := m.Network.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Memory != nil {
		{
			size, err := m.Memory.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Cpu != nil {
		{
			size, err := m.Cpu.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WindowsPodSandboxStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsPodSandboxStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WindowsPodSandboxStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Containers) > 0 {
		for iNdEx := len(m.Containers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Containers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.Process != nil {
		{
			size, err := m.Process.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Network != nil {
		{
			size, err := m.Network.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Memory != nil {
		{
			size, err := m.Memory.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Cpu != nil {
		{
			size, err := m.Cpu.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkUsage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkUsage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkUsage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Interfaces) > 0 {
		for iNdEx := len(m.Interfaces) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Interfaces[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.DefaultInterface != nil {
		{
			size, err := m.DefaultInterface.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Timestamp != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Timestamp))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *WindowsNetworkUsage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsNetworkUsage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WindowsNetworkUsage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Interfaces) > 0 {
		for iNdEx := len(m.Interfaces) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Interfaces[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.DefaultInterface != nil {
		{
			size, err := m.DefaultInterface.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Timestamp != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Timestamp))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NetworkInterfaceUsage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkInterfaceUsage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkInterfaceUsage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TxErrors != nil {
		{
			size, err := m.TxErrors.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.TxBytes != nil {
		{
			size, err := m.TxBytes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.RxErrors != nil {
		{
			size, err := m.RxErrors.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.RxBytes != nil {
		{
			size, err := m.RxBytes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WindowsNetworkInterfaceUsage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsNetworkInterfaceUsage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WindowsNetworkInterfaceUsage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TxPacketsDropped != nil {
		{
			size, err := m.TxPacketsDropped.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.TxBytes != nil {
		{
			size, err := m.TxBytes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.RxPacketsDropped != nil {
		{
			size, err := m.RxPacketsDropped.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.RxBytes != nil {
		{
			size, err := m.RxBytes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ProcessUsage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessUsage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessUsage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ProcessCount != nil {
		{
			size, err := m.ProcessCount.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Timestamp != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Timestamp))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *WindowsProcessUsage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsProcessUsage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WindowsProcessUsage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ProcessCount != nil {
		{
			size, err := m.ProcessCount.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Timestamp != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Timestamp))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ImageSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImageSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.RuntimeHandler) > 0 {
		i -= len(m.RuntimeHandler)
		copy(dAtA[i:], m.RuntimeHandler)
		i = encodeVarintApi(dAtA, i, uint64(len(m.RuntimeHandler)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	if len(m.UserSpecifiedImage) > 0 {
		i -= len(m.UserSpecifiedImage)
		copy(dAtA[i:], m.UserSpecifiedImage)
		i = encodeVarintApi(dAtA, i, uint64(len(m.UserSpecifiedImage)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Image) > 0 {
		i -= len(m.Image)
		copy(dAtA[i:], m.Image)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Image)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *KeyValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KeyValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LinuxContainerResources) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxContainerResources) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxContainerResources) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MemorySwapLimitInBytes != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.MemorySwapLimitInBytes))
		i--
		dAtA[i] = 0x50
	}
	if len(m.Unified) > 0 {
		for k := range m.Unified {
			v := m.Unified[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.HugepageLimits) > 0 {
		for iNdEx := len(m.HugepageLimits) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.HugepageLimits[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.CpusetMems) > 0 {
		i -= len(m.CpusetMems)
		copy(dAtA[i:], m.CpusetMems)
		i = encodeVarintApi(dAtA, i, uint64(len(m.CpusetMems)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.CpusetCpus) > 0 {
		i -= len(m.CpusetCpus)
		copy(dAtA[i:], m.CpusetCpus)
		i = encodeVarintApi(dAtA, i, uint64(len(m.CpusetCpus)))
		i--
		dAtA[i] = 0x32
	}
	if m.OomScoreAdj != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.OomScoreAdj))
		i--
		dAtA[i] = 0x28
	}
	if m.MemoryLimitInBytes != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.MemoryLimitInBytes))
		i--
		dAtA[i] = 0x20
	}
	if m.CpuShares != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.CpuShares))
		i--
		dAtA[i] = 0x18
	}
	if m.CpuQuota != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.CpuQuota))
		i--
		dAtA[i] = 0x10
	}
	if m.CpuPeriod != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.CpuPeriod))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *HugepageLimit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HugepageLimit) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HugepageLimit) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Limit != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x10
	}
	if len(m.PageSize) > 0 {
		i -= len(m.PageSize)
		copy(dAtA[i:], m.PageSize)
		i = encodeVarintApi(dAtA, i, uint64(len(m.PageSize)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SELinuxOption) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SELinuxOption) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SELinuxOption) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Level) > 0 {
		i -= len(m.Level)
		copy(dAtA[i:], m.Level)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Level)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Role) > 0 {
		i -= len(m.Role)
		copy(dAtA[i:], m.Role)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Role)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.User) > 0 {
		i -= len(m.User)
		copy(dAtA[i:], m.User)
		i = encodeVarintApi(dAtA, i, uint64(len(m.User)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Capability) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Capability) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Capability) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.AddAmbientCapabilities) > 0 {
		for iNdEx := len(m.AddAmbientCapabilities) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AddAmbientCapabilities[iNdEx])
			copy(dAtA[i:], m.AddAmbientCapabilities[iNdEx])
			i = encodeVarintApi(dAtA, i, uint64(len(m.AddAmbientCapabilities[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.DropCapabilities) > 0 {
		for iNdEx := len(m.DropCapabilities) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.DropCapabilities[iNdEx])
			copy(dAtA[i:], m.DropCapabilities[iNdEx])
			i = encodeVarintApi(dAtA, i, uint64(len(m.DropCapabilities[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.AddCapabilities) > 0 {
		for iNdEx := len(m.AddCapabilities) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AddCapabilities[iNdEx])
			copy(dAtA[i:], m.AddCapabilities[iNdEx])
			i = encodeVarintApi(dAtA, i, uint64(len(m.AddCapabilities[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *LinuxContainerSecurityContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxContainerSecurityContext) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxContainerSecurityContext) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SupplementalGroupsPolicy != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.SupplementalGroupsPolicy))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.Apparmor != nil {
		{
			size, err := m.Apparmor.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.Seccomp != nil {
		{
			size, err := m.Seccomp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x7a
	}
	if len(m.ReadonlyPaths) > 0 {
		for iNdEx := len(m.ReadonlyPaths) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ReadonlyPaths[iNdEx])
			copy(dAtA[i:], m.ReadonlyPaths[iNdEx])
			i = encodeVarintApi(dAtA, i, uint64(len(m.ReadonlyPaths[iNdEx])))
			i--
			dAtA[i] = 0x72
		}
	}
	if len(m.MaskedPaths) > 0 {
		for iNdEx := len(m.MaskedPaths) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.MaskedPaths[iNdEx])
			copy(dAtA[i:], m.MaskedPaths[iNdEx])
			i = encodeVarintApi(dAtA, i, uint64(len(m.MaskedPaths[iNdEx])))
			i--
			dAtA[i] = 0x6a
		}
	}
	if m.RunAsGroup != nil {
		{
			size, err := m.RunAsGroup.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.NoNewPrivs {
		i--
		if m.NoNewPrivs {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if len(m.SeccompProfilePath) > 0 {
		i -= len(m.SeccompProfilePath)
		copy(dAtA[i:], m.SeccompProfilePath)
		i = encodeVarintApi(dAtA, i, uint64(len(m.SeccompProfilePath)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.ApparmorProfile) > 0 {
		i -= len(m.ApparmorProfile)
		copy(dAtA[i:], m.ApparmorProfile)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ApparmorProfile)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.SupplementalGroups) > 0 {
		dAtA57 := make([]byte, len(m.SupplementalGroups)*10)
		var j56 int
		for _, num1 := range m.SupplementalGroups {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA57[j56] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j56++
			}
			dAtA57[j56] = uint8(num)
			j56++
		}
		i -= j56
		copy(dAtA[i:], dAtA57[:j56])
		i = encodeVarintApi(dAtA, i, uint64(j56))
		i--
		dAtA[i] = 0x42
	}
	if m.ReadonlyRootfs {
		i--
		if m.ReadonlyRootfs {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if len(m.RunAsUsername) > 0 {
		i -= len(m.RunAsUsername)
		copy(dAtA[i:], m.RunAsUsername)
		i = encodeVarintApi(dAtA, i, uint64(len(m.RunAsUsername)))
		i--
		dAtA[i] = 0x32
	}
	if m.RunAsUser != nil {
		{
			size, err := m.RunAsUser.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.SelinuxOptions != nil {
		{
			size, err := m.SelinuxOptions.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.NamespaceOptions != nil {
		{
			size, err := m.NamespaceOptions.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Privileged {
		i--
		if m.Privileged {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.Capabilities != nil {
		{
			size, err := m.Capabilities.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LinuxContainerConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxContainerConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxContainerConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SecurityContext != nil {
		{
			size, err := m.SecurityContext.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Resources != nil {
		{
			size, err := m.Resources.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LinuxContainerUser) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxContainerUser) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxContainerUser) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SupplementalGroups) > 0 {
		dAtA65 := make([]byte, len(m.SupplementalGroups)*10)
		var j64 int
		for _, num1 := range m.SupplementalGroups {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA65[j64] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j64++
			}
			dAtA65[j64] = uint8(num)
			j64++
		}
		i -= j64
		copy(dAtA[i:], dAtA65[:j64])
		i = encodeVarintApi(dAtA, i, uint64(j64))
		i--
		dAtA[i] = 0x1a
	}
	if m.Gid != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Gid))
		i--
		dAtA[i] = 0x10
	}
	if m.Uid != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Uid))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *WindowsNamespaceOption) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsNamespaceOption) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WindowsNamespaceOption) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Network != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Network))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *WindowsSandboxSecurityContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsSandboxSecurityContext) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WindowsSandboxSecurityContext) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.NamespaceOptions != nil {
		{
			size, err := m.NamespaceOptions.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.HostProcess {
		i--
		if m.HostProcess {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.CredentialSpec) > 0 {
		i -= len(m.CredentialSpec)
		copy(dAtA[i:], m.CredentialSpec)
		i = encodeVarintApi(dAtA, i, uint64(len(m.CredentialSpec)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.RunAsUsername) > 0 {
		i -= len(m.RunAsUsername)
		copy(dAtA[i:], m.RunAsUsername)
		i = encodeVarintApi(dAtA, i, uint64(len(m.RunAsUsername)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WindowsPodSandboxConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsPodSandboxConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WindowsPodSandboxConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SecurityContext != nil {
		{
			size, err := m.SecurityContext.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WindowsContainerSecurityContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsContainerSecurityContext) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WindowsContainerSecurityContext) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.HostProcess {
		i--
		if m.HostProcess {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.CredentialSpec) > 0 {
		i -= len(m.CredentialSpec)
		copy(dAtA[i:], m.CredentialSpec)
		i = encodeVarintApi(dAtA, i, uint64(len(m.CredentialSpec)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.RunAsUsername) > 0 {
		i -= len(m.RunAsUsername)
		copy(dAtA[i:], m.RunAsUsername)
		i = encodeVarintApi(dAtA, i, uint64(len(m.RunAsUsername)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WindowsContainerConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsContainerConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WindowsContainerConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SecurityContext != nil {
		{
			size, err := m.SecurityContext.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Resources != nil {
		{
			size, err := m.Resources.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WindowsContainerResources) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsContainerResources) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WindowsContainerResources) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.RootfsSizeInBytes != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.RootfsSizeInBytes))
		i--
		dAtA[i] = 0x28
	}
	if m.MemoryLimitInBytes != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.MemoryLimitInBytes))
		i--
		dAtA[i] = 0x20
	}
	if m.CpuMaximum != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.CpuMaximum))
		i--
		dAtA[i] = 0x18
	}
	if m.CpuCount != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.CpuCount))
		i--
		dAtA[i] = 0x10
	}
	if m.CpuShares != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.CpuShares))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ContainerMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Attempt != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Attempt))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Device) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Device) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Device) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Permissions) > 0 {
		i -= len(m.Permissions)
		copy(dAtA[i:], m.Permissions)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Permissions)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.HostPath) > 0 {
		i -= len(m.HostPath)
		copy(dAtA[i:], m.HostPath)
		i = encodeVarintApi(dAtA, i, uint64(len(m.HostPath)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ContainerPath) > 0 {
		i -= len(m.ContainerPath)
		copy(dAtA[i:], m.ContainerPath)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ContainerPath)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CDIDevice) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CDIDevice) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CDIDevice) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContainerConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.CDIDevices) > 0 {
		for iNdEx := len(m.CDIDevices) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.CDIDevices[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x8a
		}
	}
	if m.Windows != nil {
		{
			size, err := m.Windows.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.Linux != nil {
		{
			size, err := m.Linux.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x7a
	}
	if m.Tty {
		i--
		if m.Tty {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x70
	}
	if m.StdinOnce {
		i--
		if m.StdinOnce {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x68
	}
	if m.Stdin {
		i--
		if m.Stdin {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if len(m.LogPath) > 0 {
		i -= len(m.LogPath)
		copy(dAtA[i:], m.LogPath)
		i = encodeVarintApi(dAtA, i, uint64(len(m.LogPath)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x52
		}
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.Devices) > 0 {
		for iNdEx := len(m.Devices) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Devices[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.Mounts) > 0 {
		for iNdEx := len(m.Mounts) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Mounts[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.Envs) > 0 {
		for iNdEx := len(m.Envs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Envs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.WorkingDir) > 0 {
		i -= len(m.WorkingDir)
		copy(dAtA[i:], m.WorkingDir)
		i = encodeVarintApi(dAtA, i, uint64(len(m.WorkingDir)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Args) > 0 {
		for iNdEx := len(m.Args) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Args[iNdEx])
			copy(dAtA[i:], m.Args[iNdEx])
			i = encodeVarintApi(dAtA, i, uint64(len(m.Args[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Command) > 0 {
		for iNdEx := len(m.Command) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Command[iNdEx])
			copy(dAtA[i:], m.Command[iNdEx])
			i = encodeVarintApi(dAtA, i, uint64(len(m.Command[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Image != nil {
		{
			size, err := m.Image.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CreateContainerRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CreateContainerRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CreateContainerRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SandboxConfig != nil {
		{
			size, err := m.SandboxConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Config != nil {
		{
			size, err := m.Config.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.PodSandboxId) > 0 {
		i -= len(m.PodSandboxId)
		copy(dAtA[i:], m.PodSandboxId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.PodSandboxId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CreateContainerResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CreateContainerResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CreateContainerResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StartContainerRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StartContainerRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StartContainerRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StartContainerResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StartContainerResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StartContainerResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *StopContainerRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StopContainerRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StopContainerRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Timeout != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Timeout))
		i--
		dAtA[i] = 0x10
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StopContainerResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StopContainerResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StopContainerResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *RemoveContainerRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveContainerRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveContainerRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RemoveContainerResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveContainerResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveContainerResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *ContainerStateValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStateValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerStateValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.State != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ContainerFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerFilter) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerFilter) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.LabelSelector) > 0 {
		for k := range m.LabelSelector {
			v := m.LabelSelector[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.PodSandboxId) > 0 {
		i -= len(m.PodSandboxId)
		copy(dAtA[i:], m.PodSandboxId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.PodSandboxId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.State != nil {
		{
			size, err := m.State.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListContainersRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListContainersRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListContainersRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Filter != nil {
		{
			size, err := m.Filter.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Container) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Container) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Container) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ImageId) > 0 {
		i -= len(m.ImageId)
		copy(dAtA[i:], m.ImageId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ImageId)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x42
		}
	}
	if m.CreatedAt != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.CreatedAt))
		i--
		dAtA[i] = 0x38
	}
	if m.State != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x30
	}
	if len(m.ImageRef) > 0 {
		i -= len(m.ImageRef)
		copy(dAtA[i:], m.ImageRef)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ImageRef)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Image != nil {
		{
			size, err := m.Image.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.PodSandboxId) > 0 {
		i -= len(m.PodSandboxId)
		copy(dAtA[i:], m.PodSandboxId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.PodSandboxId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListContainersResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListContainersResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListContainersResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Containers) > 0 {
		for iNdEx := len(m.Containers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Containers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ContainerStatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStatusRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerStatusRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Verbose {
		i--
		if m.Verbose {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContainerStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.User != nil {
		{
			size, err := m.User.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if len(m.ImageId) > 0 {
		i -= len(m.ImageId)
		copy(dAtA[i:], m.ImageId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ImageId)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if m.Resources != nil {
		{
			size, err := m.Resources.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if len(m.LogPath) > 0 {
		i -= len(m.LogPath)
		copy(dAtA[i:], m.LogPath)
		i = encodeVarintApi(dAtA, i, uint64(len(m.LogPath)))
		i--
		dAtA[i] = 0x7a
	}
	if len(m.Mounts) > 0 {
		for iNdEx := len(m.Mounts) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Mounts[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x72
		}
	}
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x6a
		}
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x62
		}
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.ImageRef) > 0 {
		i -= len(m.ImageRef)
		copy(dAtA[i:], m.ImageRef)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ImageRef)))
		i--
		dAtA[i] = 0x4a
	}
	if m.Image != nil {
		{
			size, err := m.Image.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.ExitCode != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.ExitCode))
		i--
		dAtA[i] = 0x38
	}
	if m.FinishedAt != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.FinishedAt))
		i--
		dAtA[i] = 0x30
	}
	if m.StartedAt != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.StartedAt))
		i--
		dAtA[i] = 0x28
	}
	if m.CreatedAt != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.CreatedAt))
		i--
		dAtA[i] = 0x20
	}
	if m.State != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x18
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContainerStatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStatusResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerStatusResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Info) > 0 {
		for k := range m.Info {
			v := m.Info[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContainerResources) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerResources) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerResources) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Windows != nil {
		{
			size, err := m.Windows.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Linux != nil {
		{
			size, err := m.Linux.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContainerUser) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerUser) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerUser) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Linux != nil {
		{
			size, err := m.Linux.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateContainerResourcesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateContainerResourcesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateContainerResourcesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.Windows != nil {
		{
			size, err := m.Windows.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Linux != nil {
		{
			size, err := m.Linux.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateContainerResourcesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateContainerResourcesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateContainerResourcesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *ExecSyncRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExecSyncRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExecSyncRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Timeout != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Timeout))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Cmd) > 0 {
		for iNdEx := len(m.Cmd) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Cmd[iNdEx])
			copy(dAtA[i:], m.Cmd[iNdEx])
			i = encodeVarintApi(dAtA, i, uint64(len(m.Cmd[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExecSyncResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExecSyncResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExecSyncResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ExitCode != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.ExitCode))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Stderr) > 0 {
		i -= len(m.Stderr)
		copy(dAtA[i:], m.Stderr)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Stderr)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Stdout) > 0 {
		i -= len(m.Stdout)
		copy(dAtA[i:], m.Stdout)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Stdout)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExecRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExecRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExecRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Stderr {
		i--
		if m.Stderr {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.Stdout {
		i--
		if m.Stdout {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.Stdin {
		i--
		if m.Stdin {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Tty {
		i--
		if m.Tty {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Cmd) > 0 {
		for iNdEx := len(m.Cmd) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Cmd[iNdEx])
			copy(dAtA[i:], m.Cmd[iNdEx])
			i = encodeVarintApi(dAtA, i, uint64(len(m.Cmd[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExecResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExecResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExecResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AttachRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttachRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AttachRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Stderr {
		i--
		if m.Stderr {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.Stdout {
		i--
		if m.Stdout {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Tty {
		i--
		if m.Tty {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.Stdin {
		i--
		if m.Stdin {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AttachResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttachResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AttachResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PortForwardRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PortForwardRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PortForwardRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Port) > 0 {
		dAtA91 := make([]byte, len(m.Port)*10)
		var j90 int
		for _, num1 := range m.Port {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA91[j90] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j90++
			}
			dAtA91[j90] = uint8(num)
			j90++
		}
		i -= j90
		copy(dAtA[i:], dAtA91[:j90])
		i = encodeVarintApi(dAtA, i, uint64(j90))
		i--
		dAtA[i] = 0x12
	}
	if len(m.PodSandboxId) > 0 {
		i -= len(m.PodSandboxId)
		copy(dAtA[i:], m.PodSandboxId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.PodSandboxId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PortForwardResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PortForwardResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PortForwardResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ImageFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImageFilter) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageFilter) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Image != nil {
		{
			size, err := m.Image.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListImagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListImagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListImagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Filter != nil {
		{
			size, err := m.Filter.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Image) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Image) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Image) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Pinned {
		i--
		if m.Pinned {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.Spec != nil {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Username) > 0 {
		i -= len(m.Username)
		copy(dAtA[i:], m.Username)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Username)))
		i--
		dAtA[i] = 0x32
	}
	if m.Uid != nil {
		{
			size, err := m.Uid.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Size_ != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Size_))
		i--
		dAtA[i] = 0x20
	}
	if len(m.RepoDigests) > 0 {
		for iNdEx := len(m.RepoDigests) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RepoDigests[iNdEx])
			copy(dAtA[i:], m.RepoDigests[iNdEx])
			i = encodeVarintApi(dAtA, i, uint64(len(m.RepoDigests[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.RepoTags) > 0 {
		for iNdEx := len(m.RepoTags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RepoTags[iNdEx])
			copy(dAtA[i:], m.RepoTags[iNdEx])
			i = encodeVarintApi(dAtA, i, uint64(len(m.RepoTags[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListImagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListImagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListImagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Images) > 0 {
		for iNdEx := len(m.Images) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Images[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ImageStatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImageStatusRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageStatusRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Verbose {
		i--
		if m.Verbose {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.Image != nil {
		{
			size, err := m.Image.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ImageStatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImageStatusResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageStatusResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Info) > 0 {
		for k := range m.Info {
			v := m.Info[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Image != nil {
		{
			size, err := m.Image.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuthConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuthConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuthConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.RegistryToken) > 0 {
		i -= len(m.RegistryToken)
		copy(dAtA[i:], m.RegistryToken)
		i = encodeVarintApi(dAtA, i, uint64(len(m.RegistryToken)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.IdentityToken) > 0 {
		i -= len(m.IdentityToken)
		copy(dAtA[i:], m.IdentityToken)
		i = encodeVarintApi(dAtA, i, uint64(len(m.IdentityToken)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ServerAddress) > 0 {
		i -= len(m.ServerAddress)
		copy(dAtA[i:], m.ServerAddress)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ServerAddress)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Auth) > 0 {
		i -= len(m.Auth)
		copy(dAtA[i:], m.Auth)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Auth)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Password) > 0 {
		i -= len(m.Password)
		copy(dAtA[i:], m.Password)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Password)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Username) > 0 {
		i -= len(m.Username)
		copy(dAtA[i:], m.Username)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Username)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PullImageRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PullImageRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PullImageRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SandboxConfig != nil {
		{
			size, err := m.SandboxConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Auth != nil {
		{
			size, err := m.Auth.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Image != nil {
		{
			size, err := m.Image.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PullImageResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PullImageResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PullImageResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ImageRef) > 0 {
		i -= len(m.ImageRef)
		copy(dAtA[i:], m.ImageRef)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ImageRef)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RemoveImageRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveImageRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveImageRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Image != nil {
		{
			size, err := m.Image.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RemoveImageResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveImageResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveImageResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *NetworkConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PodCidr) > 0 {
		i -= len(m.PodCidr)
		copy(dAtA[i:], m.PodCidr)
		i = encodeVarintApi(dAtA, i, uint64(len(m.PodCidr)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RuntimeConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuntimeConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RuntimeConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.NetworkConfig != nil {
		{
			size, err := m.NetworkConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateRuntimeConfigRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateRuntimeConfigRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateRuntimeConfigRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.RuntimeConfig != nil {
		{
			size, err := m.RuntimeConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateRuntimeConfigResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateRuntimeConfigResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateRuntimeConfigResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *RuntimeCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuntimeCondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RuntimeCondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Status {
		i--
		if m.Status {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RuntimeStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuntimeStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RuntimeStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *StatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatusRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StatusRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Verbose {
		i--
		if m.Verbose {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RuntimeHandlerFeatures) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuntimeHandlerFeatures) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RuntimeHandlerFeatures) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.UserNamespaces {
		i--
		if m.UserNamespaces {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.RecursiveReadOnlyMounts {
		i--
		if m.RecursiveReadOnlyMounts {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RuntimeHandler) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuntimeHandler) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RuntimeHandler) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Features != nil {
		{
			size, err := m.Features.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatusResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StatusResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.RuntimeHandlers) > 0 {
		for iNdEx := len(m.RuntimeHandlers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.RuntimeHandlers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Info) > 0 {
		for k := range m.Info {
			v := m.Info[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ImageFsInfoRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImageFsInfoRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageFsInfoRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *UInt64Value) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UInt64Value) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UInt64Value) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Value != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Value))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *FilesystemIdentifier) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FilesystemIdentifier) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FilesystemIdentifier) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Mountpoint) > 0 {
		i -= len(m.Mountpoint)
		copy(dAtA[i:], m.Mountpoint)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Mountpoint)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *FilesystemUsage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FilesystemUsage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FilesystemUsage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.InodesUsed != nil {
		{
			size, err := m.InodesUsed.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.UsedBytes != nil {
		{
			size, err := m.UsedBytes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.FsId != nil {
		{
			size, err := m.FsId.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Timestamp != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Timestamp))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *WindowsFilesystemUsage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsFilesystemUsage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WindowsFilesystemUsage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.UsedBytes != nil {
		{
			size, err := m.UsedBytes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.FsId != nil {
		{
			size, err := m.FsId.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Timestamp != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Timestamp))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ImageFsInfoResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImageFsInfoResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImageFsInfoResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ContainerFilesystems) > 0 {
		for iNdEx := len(m.ContainerFilesystems) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ContainerFilesystems[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ImageFilesystems) > 0 {
		for iNdEx := len(m.ImageFilesystems) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ImageFilesystems[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ContainerStatsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStatsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerStatsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContainerStatsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStatsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerStatsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Stats != nil {
		{
			size, err := m.Stats.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListContainerStatsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListContainerStatsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListContainerStatsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Filter != nil {
		{
			size, err := m.Filter.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContainerStatsFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStatsFilter) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerStatsFilter) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.LabelSelector) > 0 {
		for k := range m.LabelSelector {
			v := m.LabelSelector[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.PodSandboxId) > 0 {
		i -= len(m.PodSandboxId)
		copy(dAtA[i:], m.PodSandboxId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.PodSandboxId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListContainerStatsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListContainerStatsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListContainerStatsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Stats) > 0 {
		for iNdEx := len(m.Stats) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Stats[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ContainerAttributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Annotations) > 0 {
		for k := range m.Annotations {
			v := m.Annotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintApi(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintApi(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintApi(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContainerStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Swap != nil {
		{
			size, err := m.Swap.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.WritableLayer != nil {
		{
			size, err := m.WritableLayer.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Memory != nil {
		{
			size, err := m.Memory.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Cpu != nil {
		{
			size, err := m.Cpu.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Attributes != nil {
		{
			size, err := m.Attributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WindowsContainerStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsContainerStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WindowsContainerStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.WritableLayer != nil {
		{
			size, err := m.WritableLayer.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Memory != nil {
		{
			size, err := m.Memory.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Cpu != nil {
		{
			size, err := m.Cpu.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Attributes != nil {
		{
			size, err := m.Attributes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CpuUsage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CpuUsage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CpuUsage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.UsageNanoCores != nil {
		{
			size, err := m.UsageNanoCores.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.UsageCoreNanoSeconds != nil {
		{
			size, err := m.UsageCoreNanoSeconds.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Timestamp != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Timestamp))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *WindowsCpuUsage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsCpuUsage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WindowsCpuUsage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.UsageNanoCores != nil {
		{
			size, err := m.UsageNanoCores.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.UsageCoreNanoSeconds != nil {
		{
			size, err := m.UsageCoreNanoSeconds.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Timestamp != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Timestamp))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MemoryUsage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MemoryUsage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MemoryUsage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MajorPageFaults != nil {
		{
			size, err := m.MajorPageFaults.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.PageFaults != nil {
		{
			size, err := m.PageFaults.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.RssBytes != nil {
		{
			size, err := m.RssBytes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.UsageBytes != nil {
		{
			size, err := m.UsageBytes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.AvailableBytes != nil {
		{
			size, err := m.AvailableBytes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.WorkingSetBytes != nil {
		{
			size, err := m.WorkingSetBytes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Timestamp != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Timestamp))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SwapUsage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SwapUsage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SwapUsage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SwapUsageBytes != nil {
		{
			size, err := m.SwapUsageBytes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.SwapAvailableBytes != nil {
		{
			size, err := m.SwapAvailableBytes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Timestamp != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Timestamp))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *WindowsMemoryUsage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WindowsMemoryUsage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WindowsMemoryUsage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CommitMemoryBytes != nil {
		{
			size, err := m.CommitMemoryBytes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.PageFaults != nil {
		{
			size, err := m.PageFaults.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.AvailableBytes != nil {
		{
			size, err := m.AvailableBytes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.WorkingSetBytes != nil {
		{
			size, err := m.WorkingSetBytes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Timestamp != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Timestamp))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ReopenContainerLogRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReopenContainerLogRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReopenContainerLogRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReopenContainerLogResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReopenContainerLogResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReopenContainerLogResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *CheckpointContainerRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckpointContainerRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckpointContainerRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Timeout != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Timeout))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Location) > 0 {
		i -= len(m.Location)
		copy(dAtA[i:], m.Location)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Location)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CheckpointContainerResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckpointContainerResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckpointContainerResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *GetEventsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetEventsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetEventsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *ContainerEventResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerEventResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerEventResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ContainersStatuses) > 0 {
		for iNdEx := len(m.ContainersStatuses) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ContainersStatuses[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.PodSandboxStatus != nil {
		{
			size, err := m.PodSandboxStatus.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.CreatedAt != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.CreatedAt))
		i--
		dAtA[i] = 0x18
	}
	if m.ContainerEventType != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.ContainerEventType))
		i--
		dAtA[i] = 0x10
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListMetricDescriptorsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListMetricDescriptorsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListMetricDescriptorsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *ListMetricDescriptorsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListMetricDescriptorsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListMetricDescriptorsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Descriptors) > 0 {
		for iNdEx := len(m.Descriptors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Descriptors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *MetricDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricDescriptor) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MetricDescriptor) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.LabelKeys) > 0 {
		for iNdEx := len(m.LabelKeys) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.LabelKeys[iNdEx])
			copy(dAtA[i:], m.LabelKeys[iNdEx])
			i = encodeVarintApi(dAtA, i, uint64(len(m.LabelKeys[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Help) > 0 {
		i -= len(m.Help)
		copy(dAtA[i:], m.Help)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Help)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListPodSandboxMetricsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListPodSandboxMetricsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListPodSandboxMetricsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *ListPodSandboxMetricsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListPodSandboxMetricsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListPodSandboxMetricsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PodMetrics) > 0 {
		for iNdEx := len(m.PodMetrics) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PodMetrics[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *PodSandboxMetrics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodSandboxMetrics) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodSandboxMetrics) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ContainerMetrics) > 0 {
		for iNdEx := len(m.ContainerMetrics) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ContainerMetrics[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Metrics) > 0 {
		for iNdEx := len(m.Metrics) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Metrics[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.PodSandboxId) > 0 {
		i -= len(m.PodSandboxId)
		copy(dAtA[i:], m.PodSandboxId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.PodSandboxId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ContainerMetrics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerMetrics) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ContainerMetrics) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Metrics) > 0 {
		for iNdEx := len(m.Metrics) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Metrics[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintApi(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Metric) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Metric) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metric) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		{
			size, err := m.Value.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.LabelValues) > 0 {
		for iNdEx := len(m.LabelValues) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.LabelValues[iNdEx])
			copy(dAtA[i:], m.LabelValues[iNdEx])
			i = encodeVarintApi(dAtA, i, uint64(len(m.LabelValues[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.MetricType != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.MetricType))
		i--
		dAtA[i] = 0x18
	}
	if m.Timestamp != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.Timestamp))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintApi(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RuntimeConfigRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuntimeConfigRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RuntimeConfigRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *RuntimeConfigResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuntimeConfigResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RuntimeConfigResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Linux != nil {
		{
			size, err := m.Linux.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LinuxRuntimeConfiguration) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxRuntimeConfiguration) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinuxRuntimeConfiguration) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CgroupDriver != 0 {
		i = encodeVarintApi(dAtA, i, uint64(m.CgroupDriver))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintApi(dAtA []byte, offset int, v uint64) int {
	offset -= sovApi(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *VersionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *VersionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.RuntimeName)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.RuntimeVersion)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.RuntimeApiVersion)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *DNSConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Servers) > 0 {
		for _, s := range m.Servers {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.Searches) > 0 {
		for _, s := range m.Searches {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.Options) > 0 {
		for _, s := range m.Options {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *PortMapping) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Protocol != 0 {
		n += 1 + sovApi(uint64(m.Protocol))
	}
	if m.ContainerPort != 0 {
		n += 1 + sovApi(uint64(m.ContainerPort))
	}
	if m.HostPort != 0 {
		n += 1 + sovApi(uint64(m.HostPort))
	}
	l = len(m.HostIp)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *Mount) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerPath)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.HostPath)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Readonly {
		n += 2
	}
	if m.SelinuxRelabel {
		n += 2
	}
	if m.Propagation != 0 {
		n += 1 + sovApi(uint64(m.Propagation))
	}
	if len(m.UidMappings) > 0 {
		for _, e := range m.UidMappings {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.GidMappings) > 0 {
		for _, e := range m.GidMappings {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if m.RecursiveReadOnly {
		n += 2
	}
	return n
}

func (m *IDMapping) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HostId != 0 {
		n += 1 + sovApi(uint64(m.HostId))
	}
	if m.ContainerId != 0 {
		n += 1 + sovApi(uint64(m.ContainerId))
	}
	if m.Length != 0 {
		n += 1 + sovApi(uint64(m.Length))
	}
	return n
}

func (m *UserNamespace) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Mode != 0 {
		n += 1 + sovApi(uint64(m.Mode))
	}
	if len(m.Uids) > 0 {
		for _, e := range m.Uids {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.Gids) > 0 {
		for _, e := range m.Gids {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *NamespaceOption) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Network != 0 {
		n += 1 + sovApi(uint64(m.Network))
	}
	if m.Pid != 0 {
		n += 1 + sovApi(uint64(m.Pid))
	}
	if m.Ipc != 0 {
		n += 1 + sovApi(uint64(m.Ipc))
	}
	l = len(m.TargetId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.UsernsOptions != nil {
		l = m.UsernsOptions.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *Int64Value) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != 0 {
		n += 1 + sovApi(uint64(m.Value))
	}
	return n
}

func (m *LinuxSandboxSecurityContext) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NamespaceOptions != nil {
		l = m.NamespaceOptions.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.SelinuxOptions != nil {
		l = m.SelinuxOptions.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.RunAsUser != nil {
		l = m.RunAsUser.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.ReadonlyRootfs {
		n += 2
	}
	if len(m.SupplementalGroups) > 0 {
		l = 0
		for _, e := range m.SupplementalGroups {
			l += sovApi(uint64(e))
		}
		n += 1 + sovApi(uint64(l)) + l
	}
	if m.Privileged {
		n += 2
	}
	l = len(m.SeccompProfilePath)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.RunAsGroup != nil {
		l = m.RunAsGroup.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Seccomp != nil {
		l = m.Seccomp.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Apparmor != nil {
		l = m.Apparmor.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.SupplementalGroupsPolicy != 0 {
		n += 1 + sovApi(uint64(m.SupplementalGroupsPolicy))
	}
	return n
}

func (m *SecurityProfile) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ProfileType != 0 {
		n += 1 + sovApi(uint64(m.ProfileType))
	}
	l = len(m.LocalhostRef)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *LinuxPodSandboxConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CgroupParent)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.SecurityContext != nil {
		l = m.SecurityContext.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Sysctls) > 0 {
		for k, v := range m.Sysctls {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	if m.Overhead != nil {
		l = m.Overhead.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Resources != nil {
		l = m.Resources.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *PodSandboxMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Uid)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Attempt != 0 {
		n += 1 + sovApi(uint64(m.Attempt))
	}
	return n
}

func (m *PodSandboxConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Hostname)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.LogDirectory)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.DnsConfig != nil {
		l = m.DnsConfig.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.PortMappings) > 0 {
		for _, e := range m.PortMappings {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	if m.Linux != nil {
		l = m.Linux.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Windows != nil {
		l = m.Windows.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *RunPodSandboxRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.RuntimeHandler)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *RunPodSandboxResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PodSandboxId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *StopPodSandboxRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PodSandboxId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *StopPodSandboxResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *RemovePodSandboxRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PodSandboxId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *RemovePodSandboxResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *PodSandboxStatusRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PodSandboxId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Verbose {
		n += 2
	}
	return n
}

func (m *PodIP) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Ip)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *PodSandboxNetworkStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Ip)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.AdditionalIps) > 0 {
		for _, e := range m.AdditionalIps {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *Namespace) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *LinuxPodSandboxStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Namespaces != nil {
		l = m.Namespaces.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *PodSandboxStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovApi(uint64(m.State))
	}
	if m.CreatedAt != 0 {
		n += 1 + sovApi(uint64(m.CreatedAt))
	}
	if m.Network != nil {
		l = m.Network.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Linux != nil {
		l = m.Linux.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	l = len(m.RuntimeHandler)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *PodSandboxStatusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Info) > 0 {
		for k, v := range m.Info {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	if len(m.ContainersStatuses) > 0 {
		for _, e := range m.ContainersStatuses {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if m.Timestamp != 0 {
		n += 1 + sovApi(uint64(m.Timestamp))
	}
	return n
}

func (m *PodSandboxStateValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.State != 0 {
		n += 1 + sovApi(uint64(m.State))
	}
	return n
}

func (m *PodSandboxFilter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.State != nil {
		l = m.State.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.LabelSelector) > 0 {
		for k, v := range m.LabelSelector {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *ListPodSandboxRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Filter != nil {
		l = m.Filter.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *PodSandbox) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovApi(uint64(m.State))
	}
	if m.CreatedAt != 0 {
		n += 1 + sovApi(uint64(m.CreatedAt))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	l = len(m.RuntimeHandler)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ListPodSandboxResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *PodSandboxStatsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PodSandboxId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *PodSandboxStatsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Stats != nil {
		l = m.Stats.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *PodSandboxStatsFilter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.LabelSelector) > 0 {
		for k, v := range m.LabelSelector {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *ListPodSandboxStatsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Filter != nil {
		l = m.Filter.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ListPodSandboxStatsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Stats) > 0 {
		for _, e := range m.Stats {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *PodSandboxAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *PodSandboxStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Attributes != nil {
		l = m.Attributes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Linux != nil {
		l = m.Linux.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Windows != nil {
		l = m.Windows.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *LinuxPodSandboxStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Cpu != nil {
		l = m.Cpu.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Memory != nil {
		l = m.Memory.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Network != nil {
		l = m.Network.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Process != nil {
		l = m.Process.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Containers) > 0 {
		for _, e := range m.Containers {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *WindowsPodSandboxStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Cpu != nil {
		l = m.Cpu.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Memory != nil {
		l = m.Memory.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Network != nil {
		l = m.Network.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Process != nil {
		l = m.Process.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Containers) > 0 {
		for _, e := range m.Containers {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *NetworkUsage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != 0 {
		n += 1 + sovApi(uint64(m.Timestamp))
	}
	if m.DefaultInterface != nil {
		l = m.DefaultInterface.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Interfaces) > 0 {
		for _, e := range m.Interfaces {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *WindowsNetworkUsage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != 0 {
		n += 1 + sovApi(uint64(m.Timestamp))
	}
	if m.DefaultInterface != nil {
		l = m.DefaultInterface.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Interfaces) > 0 {
		for _, e := range m.Interfaces {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *NetworkInterfaceUsage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.RxBytes != nil {
		l = m.RxBytes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.RxErrors != nil {
		l = m.RxErrors.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.TxBytes != nil {
		l = m.TxBytes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.TxErrors != nil {
		l = m.TxErrors.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *WindowsNetworkInterfaceUsage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.RxBytes != nil {
		l = m.RxBytes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.RxPacketsDropped != nil {
		l = m.RxPacketsDropped.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.TxBytes != nil {
		l = m.TxBytes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.TxPacketsDropped != nil {
		l = m.TxPacketsDropped.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ProcessUsage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != 0 {
		n += 1 + sovApi(uint64(m.Timestamp))
	}
	if m.ProcessCount != nil {
		l = m.ProcessCount.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *WindowsProcessUsage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != 0 {
		n += 1 + sovApi(uint64(m.Timestamp))
	}
	if m.ProcessCount != nil {
		l = m.ProcessCount.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ImageSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Image)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	l = len(m.UserSpecifiedImage)
	if l > 0 {
		n += 2 + l + sovApi(uint64(l))
	}
	l = len(m.RuntimeHandler)
	if l > 0 {
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}

func (m *KeyValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *LinuxContainerResources) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CpuPeriod != 0 {
		n += 1 + sovApi(uint64(m.CpuPeriod))
	}
	if m.CpuQuota != 0 {
		n += 1 + sovApi(uint64(m.CpuQuota))
	}
	if m.CpuShares != 0 {
		n += 1 + sovApi(uint64(m.CpuShares))
	}
	if m.MemoryLimitInBytes != 0 {
		n += 1 + sovApi(uint64(m.MemoryLimitInBytes))
	}
	if m.OomScoreAdj != 0 {
		n += 1 + sovApi(uint64(m.OomScoreAdj))
	}
	l = len(m.CpusetCpus)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.CpusetMems)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.HugepageLimits) > 0 {
		for _, e := range m.HugepageLimits {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.Unified) > 0 {
		for k, v := range m.Unified {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	if m.MemorySwapLimitInBytes != 0 {
		n += 1 + sovApi(uint64(m.MemorySwapLimitInBytes))
	}
	return n
}

func (m *HugepageLimit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PageSize)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Limit != 0 {
		n += 1 + sovApi(uint64(m.Limit))
	}
	return n
}

func (m *SELinuxOption) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Role)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Level)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *Capability) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.AddCapabilities) > 0 {
		for _, s := range m.AddCapabilities {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.DropCapabilities) > 0 {
		for _, s := range m.DropCapabilities {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.AddAmbientCapabilities) > 0 {
		for _, s := range m.AddAmbientCapabilities {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *LinuxContainerSecurityContext) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Capabilities != nil {
		l = m.Capabilities.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Privileged {
		n += 2
	}
	if m.NamespaceOptions != nil {
		l = m.NamespaceOptions.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.SelinuxOptions != nil {
		l = m.SelinuxOptions.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.RunAsUser != nil {
		l = m.RunAsUser.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.RunAsUsername)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.ReadonlyRootfs {
		n += 2
	}
	if len(m.SupplementalGroups) > 0 {
		l = 0
		for _, e := range m.SupplementalGroups {
			l += sovApi(uint64(e))
		}
		n += 1 + sovApi(uint64(l)) + l
	}
	l = len(m.ApparmorProfile)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.SeccompProfilePath)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.NoNewPrivs {
		n += 2
	}
	if m.RunAsGroup != nil {
		l = m.RunAsGroup.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.MaskedPaths) > 0 {
		for _, s := range m.MaskedPaths {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.ReadonlyPaths) > 0 {
		for _, s := range m.ReadonlyPaths {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if m.Seccomp != nil {
		l = m.Seccomp.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Apparmor != nil {
		l = m.Apparmor.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.SupplementalGroupsPolicy != 0 {
		n += 2 + sovApi(uint64(m.SupplementalGroupsPolicy))
	}
	return n
}

func (m *LinuxContainerConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Resources != nil {
		l = m.Resources.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.SecurityContext != nil {
		l = m.SecurityContext.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *LinuxContainerUser) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Uid != 0 {
		n += 1 + sovApi(uint64(m.Uid))
	}
	if m.Gid != 0 {
		n += 1 + sovApi(uint64(m.Gid))
	}
	if len(m.SupplementalGroups) > 0 {
		l = 0
		for _, e := range m.SupplementalGroups {
			l += sovApi(uint64(e))
		}
		n += 1 + sovApi(uint64(l)) + l
	}
	return n
}

func (m *WindowsNamespaceOption) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Network != 0 {
		n += 1 + sovApi(uint64(m.Network))
	}
	return n
}

func (m *WindowsSandboxSecurityContext) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.RunAsUsername)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.CredentialSpec)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.HostProcess {
		n += 2
	}
	if m.NamespaceOptions != nil {
		l = m.NamespaceOptions.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *WindowsPodSandboxConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SecurityContext != nil {
		l = m.SecurityContext.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *WindowsContainerSecurityContext) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.RunAsUsername)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.CredentialSpec)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.HostProcess {
		n += 2
	}
	return n
}

func (m *WindowsContainerConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Resources != nil {
		l = m.Resources.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.SecurityContext != nil {
		l = m.SecurityContext.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *WindowsContainerResources) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CpuShares != 0 {
		n += 1 + sovApi(uint64(m.CpuShares))
	}
	if m.CpuCount != 0 {
		n += 1 + sovApi(uint64(m.CpuCount))
	}
	if m.CpuMaximum != 0 {
		n += 1 + sovApi(uint64(m.CpuMaximum))
	}
	if m.MemoryLimitInBytes != 0 {
		n += 1 + sovApi(uint64(m.MemoryLimitInBytes))
	}
	if m.RootfsSizeInBytes != 0 {
		n += 1 + sovApi(uint64(m.RootfsSizeInBytes))
	}
	return n
}

func (m *ContainerMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Attempt != 0 {
		n += 1 + sovApi(uint64(m.Attempt))
	}
	return n
}

func (m *Device) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerPath)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.HostPath)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Permissions)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *CDIDevice) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ContainerConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Image != nil {
		l = m.Image.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.Args) > 0 {
		for _, s := range m.Args {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	l = len(m.WorkingDir)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Envs) > 0 {
		for _, e := range m.Envs {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.Mounts) > 0 {
		for _, e := range m.Mounts {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.Devices) > 0 {
		for _, e := range m.Devices {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	l = len(m.LogPath)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Stdin {
		n += 2
	}
	if m.StdinOnce {
		n += 2
	}
	if m.Tty {
		n += 2
	}
	if m.Linux != nil {
		l = m.Linux.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Windows != nil {
		l = m.Windows.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if len(m.CDIDevices) > 0 {
		for _, e := range m.CDIDevices {
			l = e.Size()
			n += 2 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *CreateContainerRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PodSandboxId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.SandboxConfig != nil {
		l = m.SandboxConfig.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *CreateContainerResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *StartContainerRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *StartContainerResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *StopContainerRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Timeout != 0 {
		n += 1 + sovApi(uint64(m.Timeout))
	}
	return n
}

func (m *StopContainerResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *RemoveContainerRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *RemoveContainerResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ContainerStateValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.State != 0 {
		n += 1 + sovApi(uint64(m.State))
	}
	return n
}

func (m *ContainerFilter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.State != nil {
		l = m.State.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.PodSandboxId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.LabelSelector) > 0 {
		for k, v := range m.LabelSelector {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *ListContainersRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Filter != nil {
		l = m.Filter.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *Container) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.PodSandboxId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Image != nil {
		l = m.Image.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.ImageRef)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovApi(uint64(m.State))
	}
	if m.CreatedAt != 0 {
		n += 1 + sovApi(uint64(m.CreatedAt))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	l = len(m.ImageId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ListContainersResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Containers) > 0 {
		for _, e := range m.Containers {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *ContainerStatusRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Verbose {
		n += 2
	}
	return n
}

func (m *ContainerStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovApi(uint64(m.State))
	}
	if m.CreatedAt != 0 {
		n += 1 + sovApi(uint64(m.CreatedAt))
	}
	if m.StartedAt != 0 {
		n += 1 + sovApi(uint64(m.StartedAt))
	}
	if m.FinishedAt != 0 {
		n += 1 + sovApi(uint64(m.FinishedAt))
	}
	if m.ExitCode != 0 {
		n += 1 + sovApi(uint64(m.ExitCode))
	}
	if m.Image != nil {
		l = m.Image.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.ImageRef)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Reason)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	if len(m.Mounts) > 0 {
		for _, e := range m.Mounts {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	l = len(m.LogPath)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Resources != nil {
		l = m.Resources.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	l = len(m.ImageId)
	if l > 0 {
		n += 2 + l + sovApi(uint64(l))
	}
	if m.User != nil {
		l = m.User.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ContainerStatusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Info) > 0 {
		for k, v := range m.Info {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *ContainerResources) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Linux != nil {
		l = m.Linux.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Windows != nil {
		l = m.Windows.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ContainerUser) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Linux != nil {
		l = m.Linux.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *UpdateContainerResourcesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Linux != nil {
		l = m.Linux.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Windows != nil {
		l = m.Windows.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *UpdateContainerResourcesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ExecSyncRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Cmd) > 0 {
		for _, s := range m.Cmd {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if m.Timeout != 0 {
		n += 1 + sovApi(uint64(m.Timeout))
	}
	return n
}

func (m *ExecSyncResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Stdout)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Stderr)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.ExitCode != 0 {
		n += 1 + sovApi(uint64(m.ExitCode))
	}
	return n
}

func (m *ExecRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Cmd) > 0 {
		for _, s := range m.Cmd {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if m.Tty {
		n += 2
	}
	if m.Stdin {
		n += 2
	}
	if m.Stdout {
		n += 2
	}
	if m.Stderr {
		n += 2
	}
	return n
}

func (m *ExecResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *AttachRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Stdin {
		n += 2
	}
	if m.Tty {
		n += 2
	}
	if m.Stdout {
		n += 2
	}
	if m.Stderr {
		n += 2
	}
	return n
}

func (m *AttachResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *PortForwardRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PodSandboxId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Port) > 0 {
		l = 0
		for _, e := range m.Port {
			l += sovApi(uint64(e))
		}
		n += 1 + sovApi(uint64(l)) + l
	}
	return n
}

func (m *PortForwardResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ImageFilter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Image != nil {
		l = m.Image.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ListImagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Filter != nil {
		l = m.Filter.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *Image) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.RepoTags) > 0 {
		for _, s := range m.RepoTags {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.RepoDigests) > 0 {
		for _, s := range m.RepoDigests {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if m.Size_ != 0 {
		n += 1 + sovApi(uint64(m.Size_))
	}
	if m.Uid != nil {
		l = m.Uid.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Pinned {
		n += 2
	}
	return n
}

func (m *ListImagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Images) > 0 {
		for _, e := range m.Images {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *ImageStatusRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Image != nil {
		l = m.Image.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Verbose {
		n += 2
	}
	return n
}

func (m *ImageStatusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Image != nil {
		l = m.Image.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Info) > 0 {
		for k, v := range m.Info {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *AuthConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Password)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Auth)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.ServerAddress)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.IdentityToken)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.RegistryToken)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *PullImageRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Image != nil {
		l = m.Image.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Auth != nil {
		l = m.Auth.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.SandboxConfig != nil {
		l = m.SandboxConfig.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *PullImageResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ImageRef)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *RemoveImageRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Image != nil {
		l = m.Image.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *RemoveImageResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *NetworkConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PodCidr)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *RuntimeConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NetworkConfig != nil {
		l = m.NetworkConfig.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *UpdateRuntimeConfigRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RuntimeConfig != nil {
		l = m.RuntimeConfig.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *UpdateRuntimeConfigResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *RuntimeCondition) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Status {
		n += 2
	}
	l = len(m.Reason)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *RuntimeStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for _, e := range m.Conditions {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *StatusRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Verbose {
		n += 2
	}
	return n
}

func (m *RuntimeHandlerFeatures) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RecursiveReadOnlyMounts {
		n += 2
	}
	if m.UserNamespaces {
		n += 2
	}
	return n
}

func (m *RuntimeHandler) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Features != nil {
		l = m.Features.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *StatusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Info) > 0 {
		for k, v := range m.Info {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	if len(m.RuntimeHandlers) > 0 {
		for _, e := range m.RuntimeHandlers {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *ImageFsInfoRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *UInt64Value) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != 0 {
		n += 1 + sovApi(uint64(m.Value))
	}
	return n
}

func (m *FilesystemIdentifier) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Mountpoint)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *FilesystemUsage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != 0 {
		n += 1 + sovApi(uint64(m.Timestamp))
	}
	if m.FsId != nil {
		l = m.FsId.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.UsedBytes != nil {
		l = m.UsedBytes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.InodesUsed != nil {
		l = m.InodesUsed.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *WindowsFilesystemUsage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != 0 {
		n += 1 + sovApi(uint64(m.Timestamp))
	}
	if m.FsId != nil {
		l = m.FsId.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.UsedBytes != nil {
		l = m.UsedBytes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ImageFsInfoResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ImageFilesystems) > 0 {
		for _, e := range m.ImageFilesystems {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.ContainerFilesystems) > 0 {
		for _, e := range m.ContainerFilesystems {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *ContainerStatsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ContainerStatsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Stats != nil {
		l = m.Stats.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ListContainerStatsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Filter != nil {
		l = m.Filter.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ContainerStatsFilter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.PodSandboxId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.LabelSelector) > 0 {
		for k, v := range m.LabelSelector {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *ListContainerStatsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Stats) > 0 {
		for _, e := range m.Stats {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *ContainerAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	if len(m.Annotations) > 0 {
		for k, v := range m.Annotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovApi(uint64(len(k))) + 1 + len(v) + sovApi(uint64(len(v)))
			n += mapEntrySize + 1 + sovApi(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *ContainerStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Attributes != nil {
		l = m.Attributes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Cpu != nil {
		l = m.Cpu.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Memory != nil {
		l = m.Memory.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.WritableLayer != nil {
		l = m.WritableLayer.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Swap != nil {
		l = m.Swap.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *WindowsContainerStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Attributes != nil {
		l = m.Attributes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Cpu != nil {
		l = m.Cpu.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Memory != nil {
		l = m.Memory.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.WritableLayer != nil {
		l = m.WritableLayer.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *CpuUsage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != 0 {
		n += 1 + sovApi(uint64(m.Timestamp))
	}
	if m.UsageCoreNanoSeconds != nil {
		l = m.UsageCoreNanoSeconds.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.UsageNanoCores != nil {
		l = m.UsageNanoCores.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *WindowsCpuUsage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != 0 {
		n += 1 + sovApi(uint64(m.Timestamp))
	}
	if m.UsageCoreNanoSeconds != nil {
		l = m.UsageCoreNanoSeconds.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.UsageNanoCores != nil {
		l = m.UsageNanoCores.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *MemoryUsage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != 0 {
		n += 1 + sovApi(uint64(m.Timestamp))
	}
	if m.WorkingSetBytes != nil {
		l = m.WorkingSetBytes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.AvailableBytes != nil {
		l = m.AvailableBytes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.UsageBytes != nil {
		l = m.UsageBytes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.RssBytes != nil {
		l = m.RssBytes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.PageFaults != nil {
		l = m.PageFaults.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.MajorPageFaults != nil {
		l = m.MajorPageFaults.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *SwapUsage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != 0 {
		n += 1 + sovApi(uint64(m.Timestamp))
	}
	if m.SwapAvailableBytes != nil {
		l = m.SwapAvailableBytes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.SwapUsageBytes != nil {
		l = m.SwapUsageBytes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *WindowsMemoryUsage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != 0 {
		n += 1 + sovApi(uint64(m.Timestamp))
	}
	if m.WorkingSetBytes != nil {
		l = m.WorkingSetBytes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.AvailableBytes != nil {
		l = m.AvailableBytes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.PageFaults != nil {
		l = m.PageFaults.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.CommitMemoryBytes != nil {
		l = m.CommitMemoryBytes.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ReopenContainerLogRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ReopenContainerLogResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *CheckpointContainerRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Location)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Timeout != 0 {
		n += 1 + sovApi(uint64(m.Timeout))
	}
	return n
}

func (m *CheckpointContainerResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *GetEventsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ContainerEventResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.ContainerEventType != 0 {
		n += 1 + sovApi(uint64(m.ContainerEventType))
	}
	if m.CreatedAt != 0 {
		n += 1 + sovApi(uint64(m.CreatedAt))
	}
	if m.PodSandboxStatus != nil {
		l = m.PodSandboxStatus.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.ContainersStatuses) > 0 {
		for _, e := range m.ContainersStatuses {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *ListMetricDescriptorsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ListMetricDescriptorsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Descriptors) > 0 {
		for _, e := range m.Descriptors {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *MetricDescriptor) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Help)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.LabelKeys) > 0 {
		for _, s := range m.LabelKeys {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *ListPodSandboxMetricsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ListPodSandboxMetricsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.PodMetrics) > 0 {
		for _, e := range m.PodMetrics {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *PodSandboxMetrics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PodSandboxId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Metrics) > 0 {
		for _, e := range m.Metrics {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.ContainerMetrics) > 0 {
		for _, e := range m.ContainerMetrics {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *ContainerMetrics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Metrics) > 0 {
		for _, e := range m.Metrics {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *Metric) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Timestamp != 0 {
		n += 1 + sovApi(uint64(m.Timestamp))
	}
	if m.MetricType != 0 {
		n += 1 + sovApi(uint64(m.MetricType))
	}
	if len(m.LabelValues) > 0 {
		for _, s := range m.LabelValues {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *RuntimeConfigRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *RuntimeConfigResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Linux != nil {
		l = m.Linux.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *LinuxRuntimeConfiguration) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CgroupDriver != 0 {
		n += 1 + sovApi(uint64(m.CgroupDriver))
	}
	return n
}

func sovApi(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozApi(x uint64) (n int) {
	return sovApi(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *VersionRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&VersionRequest{`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`}`,
	}, "")
	return s
}
func (this *VersionResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&VersionResponse{`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`RuntimeName:` + fmt.Sprintf("%v", this.RuntimeName) + `,`,
		`RuntimeVersion:` + fmt.Sprintf("%v", this.RuntimeVersion) + `,`,
		`RuntimeApiVersion:` + fmt.Sprintf("%v", this.RuntimeApiVersion) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DNSConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DNSConfig{`,
		`Servers:` + fmt.Sprintf("%v", this.Servers) + `,`,
		`Searches:` + fmt.Sprintf("%v", this.Searches) + `,`,
		`Options:` + fmt.Sprintf("%v", this.Options) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PortMapping) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PortMapping{`,
		`Protocol:` + fmt.Sprintf("%v", this.Protocol) + `,`,
		`ContainerPort:` + fmt.Sprintf("%v", this.ContainerPort) + `,`,
		`HostPort:` + fmt.Sprintf("%v", this.HostPort) + `,`,
		`HostIp:` + fmt.Sprintf("%v", this.HostIp) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Mount) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForUidMappings := "[]*IDMapping{"
	for _, f := range this.UidMappings {
		repeatedStringForUidMappings += strings.Replace(f.String(), "IDMapping", "IDMapping", 1) + ","
	}
	repeatedStringForUidMappings += "}"
	repeatedStringForGidMappings := "[]*IDMapping{"
	for _, f := range this.GidMappings {
		repeatedStringForGidMappings += strings.Replace(f.String(), "IDMapping", "IDMapping", 1) + ","
	}
	repeatedStringForGidMappings += "}"
	s := strings.Join([]string{`&Mount{`,
		`ContainerPath:` + fmt.Sprintf("%v", this.ContainerPath) + `,`,
		`HostPath:` + fmt.Sprintf("%v", this.HostPath) + `,`,
		`Readonly:` + fmt.Sprintf("%v", this.Readonly) + `,`,
		`SelinuxRelabel:` + fmt.Sprintf("%v", this.SelinuxRelabel) + `,`,
		`Propagation:` + fmt.Sprintf("%v", this.Propagation) + `,`,
		`UidMappings:` + repeatedStringForUidMappings + `,`,
		`GidMappings:` + repeatedStringForGidMappings + `,`,
		`RecursiveReadOnly:` + fmt.Sprintf("%v", this.RecursiveReadOnly) + `,`,
		`}`,
	}, "")
	return s
}
func (this *IDMapping) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&IDMapping{`,
		`HostId:` + fmt.Sprintf("%v", this.HostId) + `,`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`Length:` + fmt.Sprintf("%v", this.Length) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UserNamespace) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForUids := "[]*IDMapping{"
	for _, f := range this.Uids {
		repeatedStringForUids += strings.Replace(f.String(), "IDMapping", "IDMapping", 1) + ","
	}
	repeatedStringForUids += "}"
	repeatedStringForGids := "[]*IDMapping{"
	for _, f := range this.Gids {
		repeatedStringForGids += strings.Replace(f.String(), "IDMapping", "IDMapping", 1) + ","
	}
	repeatedStringForGids += "}"
	s := strings.Join([]string{`&UserNamespace{`,
		`Mode:` + fmt.Sprintf("%v", this.Mode) + `,`,
		`Uids:` + repeatedStringForUids + `,`,
		`Gids:` + repeatedStringForGids + `,`,
		`}`,
	}, "")
	return s
}
func (this *NamespaceOption) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NamespaceOption{`,
		`Network:` + fmt.Sprintf("%v", this.Network) + `,`,
		`Pid:` + fmt.Sprintf("%v", this.Pid) + `,`,
		`Ipc:` + fmt.Sprintf("%v", this.Ipc) + `,`,
		`TargetId:` + fmt.Sprintf("%v", this.TargetId) + `,`,
		`UsernsOptions:` + strings.Replace(this.UsernsOptions.String(), "UserNamespace", "UserNamespace", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Int64Value) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Int64Value{`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxSandboxSecurityContext) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxSandboxSecurityContext{`,
		`NamespaceOptions:` + strings.Replace(this.NamespaceOptions.String(), "NamespaceOption", "NamespaceOption", 1) + `,`,
		`SelinuxOptions:` + strings.Replace(this.SelinuxOptions.String(), "SELinuxOption", "SELinuxOption", 1) + `,`,
		`RunAsUser:` + strings.Replace(this.RunAsUser.String(), "Int64Value", "Int64Value", 1) + `,`,
		`ReadonlyRootfs:` + fmt.Sprintf("%v", this.ReadonlyRootfs) + `,`,
		`SupplementalGroups:` + fmt.Sprintf("%v", this.SupplementalGroups) + `,`,
		`Privileged:` + fmt.Sprintf("%v", this.Privileged) + `,`,
		`SeccompProfilePath:` + fmt.Sprintf("%v", this.SeccompProfilePath) + `,`,
		`RunAsGroup:` + strings.Replace(this.RunAsGroup.String(), "Int64Value", "Int64Value", 1) + `,`,
		`Seccomp:` + strings.Replace(this.Seccomp.String(), "SecurityProfile", "SecurityProfile", 1) + `,`,
		`Apparmor:` + strings.Replace(this.Apparmor.String(), "SecurityProfile", "SecurityProfile", 1) + `,`,
		`SupplementalGroupsPolicy:` + fmt.Sprintf("%v", this.SupplementalGroupsPolicy) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SecurityProfile) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SecurityProfile{`,
		`ProfileType:` + fmt.Sprintf("%v", this.ProfileType) + `,`,
		`LocalhostRef:` + fmt.Sprintf("%v", this.LocalhostRef) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxPodSandboxConfig) String() string {
	if this == nil {
		return "nil"
	}
	keysForSysctls := make([]string, 0, len(this.Sysctls))
	for k := range this.Sysctls {
		keysForSysctls = append(keysForSysctls, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSysctls)
	mapStringForSysctls := "map[string]string{"
	for _, k := range keysForSysctls {
		mapStringForSysctls += fmt.Sprintf("%v: %v,", k, this.Sysctls[k])
	}
	mapStringForSysctls += "}"
	s := strings.Join([]string{`&LinuxPodSandboxConfig{`,
		`CgroupParent:` + fmt.Sprintf("%v", this.CgroupParent) + `,`,
		`SecurityContext:` + strings.Replace(this.SecurityContext.String(), "LinuxSandboxSecurityContext", "LinuxSandboxSecurityContext", 1) + `,`,
		`Sysctls:` + mapStringForSysctls + `,`,
		`Overhead:` + strings.Replace(this.Overhead.String(), "LinuxContainerResources", "LinuxContainerResources", 1) + `,`,
		`Resources:` + strings.Replace(this.Resources.String(), "LinuxContainerResources", "LinuxContainerResources", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PodSandboxMetadata) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PodSandboxMetadata{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Uid:` + fmt.Sprintf("%v", this.Uid) + `,`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`Attempt:` + fmt.Sprintf("%v", this.Attempt) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PodSandboxConfig) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForPortMappings := "[]*PortMapping{"
	for _, f := range this.PortMappings {
		repeatedStringForPortMappings += strings.Replace(f.String(), "PortMapping", "PortMapping", 1) + ","
	}
	repeatedStringForPortMappings += "}"
	keysForLabels := make([]string, 0, len(this.Labels))
	for k := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%v: %v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	keysForAnnotations := make([]string, 0, len(this.Annotations))
	for k := range this.Annotations {
		keysForAnnotations = append(keysForAnnotations, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAnnotations)
	mapStringForAnnotations := "map[string]string{"
	for _, k := range keysForAnnotations {
		mapStringForAnnotations += fmt.Sprintf("%v: %v,", k, this.Annotations[k])
	}
	mapStringForAnnotations += "}"
	s := strings.Join([]string{`&PodSandboxConfig{`,
		`Metadata:` + strings.Replace(this.Metadata.String(), "PodSandboxMetadata", "PodSandboxMetadata", 1) + `,`,
		`Hostname:` + fmt.Sprintf("%v", this.Hostname) + `,`,
		`LogDirectory:` + fmt.Sprintf("%v", this.LogDirectory) + `,`,
		`DnsConfig:` + strings.Replace(this.DnsConfig.String(), "DNSConfig", "DNSConfig", 1) + `,`,
		`PortMappings:` + repeatedStringForPortMappings + `,`,
		`Labels:` + mapStringForLabels + `,`,
		`Annotations:` + mapStringForAnnotations + `,`,
		`Linux:` + strings.Replace(this.Linux.String(), "LinuxPodSandboxConfig", "LinuxPodSandboxConfig", 1) + `,`,
		`Windows:` + strings.Replace(this.Windows.String(), "WindowsPodSandboxConfig", "WindowsPodSandboxConfig", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RunPodSandboxRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RunPodSandboxRequest{`,
		`Config:` + strings.Replace(this.Config.String(), "PodSandboxConfig", "PodSandboxConfig", 1) + `,`,
		`RuntimeHandler:` + fmt.Sprintf("%v", this.RuntimeHandler) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RunPodSandboxResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RunPodSandboxResponse{`,
		`PodSandboxId:` + fmt.Sprintf("%v", this.PodSandboxId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StopPodSandboxRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StopPodSandboxRequest{`,
		`PodSandboxId:` + fmt.Sprintf("%v", this.PodSandboxId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StopPodSandboxResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StopPodSandboxResponse{`,
		`}`,
	}, "")
	return s
}
func (this *RemovePodSandboxRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemovePodSandboxRequest{`,
		`PodSandboxId:` + fmt.Sprintf("%v", this.PodSandboxId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemovePodSandboxResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemovePodSandboxResponse{`,
		`}`,
	}, "")
	return s
}
func (this *PodSandboxStatusRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PodSandboxStatusRequest{`,
		`PodSandboxId:` + fmt.Sprintf("%v", this.PodSandboxId) + `,`,
		`Verbose:` + fmt.Sprintf("%v", this.Verbose) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PodIP) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PodIP{`,
		`Ip:` + fmt.Sprintf("%v", this.Ip) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PodSandboxNetworkStatus) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForAdditionalIps := "[]*PodIP{"
	for _, f := range this.AdditionalIps {
		repeatedStringForAdditionalIps += strings.Replace(f.String(), "PodIP", "PodIP", 1) + ","
	}
	repeatedStringForAdditionalIps += "}"
	s := strings.Join([]string{`&PodSandboxNetworkStatus{`,
		`Ip:` + fmt.Sprintf("%v", this.Ip) + `,`,
		`AdditionalIps:` + repeatedStringForAdditionalIps + `,`,
		`}`,
	}, "")
	return s
}
func (this *Namespace) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Namespace{`,
		`Options:` + strings.Replace(this.Options.String(), "NamespaceOption", "NamespaceOption", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxPodSandboxStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxPodSandboxStatus{`,
		`Namespaces:` + strings.Replace(this.Namespaces.String(), "Namespace", "Namespace", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PodSandboxStatus) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabels := make([]string, 0, len(this.Labels))
	for k := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%v: %v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	keysForAnnotations := make([]string, 0, len(this.Annotations))
	for k := range this.Annotations {
		keysForAnnotations = append(keysForAnnotations, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAnnotations)
	mapStringForAnnotations := "map[string]string{"
	for _, k := range keysForAnnotations {
		mapStringForAnnotations += fmt.Sprintf("%v: %v,", k, this.Annotations[k])
	}
	mapStringForAnnotations += "}"
	s := strings.Join([]string{`&PodSandboxStatus{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`Metadata:` + strings.Replace(this.Metadata.String(), "PodSandboxMetadata", "PodSandboxMetadata", 1) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`CreatedAt:` + fmt.Sprintf("%v", this.CreatedAt) + `,`,
		`Network:` + strings.Replace(this.Network.String(), "PodSandboxNetworkStatus", "PodSandboxNetworkStatus", 1) + `,`,
		`Linux:` + strings.Replace(this.Linux.String(), "LinuxPodSandboxStatus", "LinuxPodSandboxStatus", 1) + `,`,
		`Labels:` + mapStringForLabels + `,`,
		`Annotations:` + mapStringForAnnotations + `,`,
		`RuntimeHandler:` + fmt.Sprintf("%v", this.RuntimeHandler) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PodSandboxStatusResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForContainersStatuses := "[]*ContainerStatus{"
	for _, f := range this.ContainersStatuses {
		repeatedStringForContainersStatuses += strings.Replace(f.String(), "ContainerStatus", "ContainerStatus", 1) + ","
	}
	repeatedStringForContainersStatuses += "}"
	keysForInfo := make([]string, 0, len(this.Info))
	for k := range this.Info {
		keysForInfo = append(keysForInfo, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForInfo)
	mapStringForInfo := "map[string]string{"
	for _, k := range keysForInfo {
		mapStringForInfo += fmt.Sprintf("%v: %v,", k, this.Info[k])
	}
	mapStringForInfo += "}"
	s := strings.Join([]string{`&PodSandboxStatusResponse{`,
		`Status:` + strings.Replace(this.Status.String(), "PodSandboxStatus", "PodSandboxStatus", 1) + `,`,
		`Info:` + mapStringForInfo + `,`,
		`ContainersStatuses:` + repeatedStringForContainersStatuses + `,`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PodSandboxStateValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PodSandboxStateValue{`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PodSandboxFilter) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabelSelector := make([]string, 0, len(this.LabelSelector))
	for k := range this.LabelSelector {
		keysForLabelSelector = append(keysForLabelSelector, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabelSelector)
	mapStringForLabelSelector := "map[string]string{"
	for _, k := range keysForLabelSelector {
		mapStringForLabelSelector += fmt.Sprintf("%v: %v,", k, this.LabelSelector[k])
	}
	mapStringForLabelSelector += "}"
	s := strings.Join([]string{`&PodSandboxFilter{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`State:` + strings.Replace(this.State.String(), "PodSandboxStateValue", "PodSandboxStateValue", 1) + `,`,
		`LabelSelector:` + mapStringForLabelSelector + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListPodSandboxRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListPodSandboxRequest{`,
		`Filter:` + strings.Replace(this.Filter.String(), "PodSandboxFilter", "PodSandboxFilter", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PodSandbox) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabels := make([]string, 0, len(this.Labels))
	for k := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%v: %v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	keysForAnnotations := make([]string, 0, len(this.Annotations))
	for k := range this.Annotations {
		keysForAnnotations = append(keysForAnnotations, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAnnotations)
	mapStringForAnnotations := "map[string]string{"
	for _, k := range keysForAnnotations {
		mapStringForAnnotations += fmt.Sprintf("%v: %v,", k, this.Annotations[k])
	}
	mapStringForAnnotations += "}"
	s := strings.Join([]string{`&PodSandbox{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`Metadata:` + strings.Replace(this.Metadata.String(), "PodSandboxMetadata", "PodSandboxMetadata", 1) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`CreatedAt:` + fmt.Sprintf("%v", this.CreatedAt) + `,`,
		`Labels:` + mapStringForLabels + `,`,
		`Annotations:` + mapStringForAnnotations + `,`,
		`RuntimeHandler:` + fmt.Sprintf("%v", this.RuntimeHandler) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListPodSandboxResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForItems := "[]*PodSandbox{"
	for _, f := range this.Items {
		repeatedStringForItems += strings.Replace(f.String(), "PodSandbox", "PodSandbox", 1) + ","
	}
	repeatedStringForItems += "}"
	s := strings.Join([]string{`&ListPodSandboxResponse{`,
		`Items:` + repeatedStringForItems + `,`,
		`}`,
	}, "")
	return s
}
func (this *PodSandboxStatsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PodSandboxStatsRequest{`,
		`PodSandboxId:` + fmt.Sprintf("%v", this.PodSandboxId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PodSandboxStatsResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PodSandboxStatsResponse{`,
		`Stats:` + strings.Replace(this.Stats.String(), "PodSandboxStats", "PodSandboxStats", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PodSandboxStatsFilter) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabelSelector := make([]string, 0, len(this.LabelSelector))
	for k := range this.LabelSelector {
		keysForLabelSelector = append(keysForLabelSelector, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabelSelector)
	mapStringForLabelSelector := "map[string]string{"
	for _, k := range keysForLabelSelector {
		mapStringForLabelSelector += fmt.Sprintf("%v: %v,", k, this.LabelSelector[k])
	}
	mapStringForLabelSelector += "}"
	s := strings.Join([]string{`&PodSandboxStatsFilter{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`LabelSelector:` + mapStringForLabelSelector + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListPodSandboxStatsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListPodSandboxStatsRequest{`,
		`Filter:` + strings.Replace(this.Filter.String(), "PodSandboxStatsFilter", "PodSandboxStatsFilter", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListPodSandboxStatsResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForStats := "[]*PodSandboxStats{"
	for _, f := range this.Stats {
		repeatedStringForStats += strings.Replace(f.String(), "PodSandboxStats", "PodSandboxStats", 1) + ","
	}
	repeatedStringForStats += "}"
	s := strings.Join([]string{`&ListPodSandboxStatsResponse{`,
		`Stats:` + repeatedStringForStats + `,`,
		`}`,
	}, "")
	return s
}
func (this *PodSandboxAttributes) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabels := make([]string, 0, len(this.Labels))
	for k := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%v: %v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	keysForAnnotations := make([]string, 0, len(this.Annotations))
	for k := range this.Annotations {
		keysForAnnotations = append(keysForAnnotations, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAnnotations)
	mapStringForAnnotations := "map[string]string{"
	for _, k := range keysForAnnotations {
		mapStringForAnnotations += fmt.Sprintf("%v: %v,", k, this.Annotations[k])
	}
	mapStringForAnnotations += "}"
	s := strings.Join([]string{`&PodSandboxAttributes{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`Metadata:` + strings.Replace(this.Metadata.String(), "PodSandboxMetadata", "PodSandboxMetadata", 1) + `,`,
		`Labels:` + mapStringForLabels + `,`,
		`Annotations:` + mapStringForAnnotations + `,`,
		`}`,
	}, "")
	return s
}
func (this *PodSandboxStats) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PodSandboxStats{`,
		`Attributes:` + strings.Replace(this.Attributes.String(), "PodSandboxAttributes", "PodSandboxAttributes", 1) + `,`,
		`Linux:` + strings.Replace(this.Linux.String(), "LinuxPodSandboxStats", "LinuxPodSandboxStats", 1) + `,`,
		`Windows:` + strings.Replace(this.Windows.String(), "WindowsPodSandboxStats", "WindowsPodSandboxStats", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxPodSandboxStats) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForContainers := "[]*ContainerStats{"
	for _, f := range this.Containers {
		repeatedStringForContainers += strings.Replace(f.String(), "ContainerStats", "ContainerStats", 1) + ","
	}
	repeatedStringForContainers += "}"
	s := strings.Join([]string{`&LinuxPodSandboxStats{`,
		`Cpu:` + strings.Replace(this.Cpu.String(), "CpuUsage", "CpuUsage", 1) + `,`,
		`Memory:` + strings.Replace(this.Memory.String(), "MemoryUsage", "MemoryUsage", 1) + `,`,
		`Network:` + strings.Replace(this.Network.String(), "NetworkUsage", "NetworkUsage", 1) + `,`,
		`Process:` + strings.Replace(this.Process.String(), "ProcessUsage", "ProcessUsage", 1) + `,`,
		`Containers:` + repeatedStringForContainers + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsPodSandboxStats) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForContainers := "[]*WindowsContainerStats{"
	for _, f := range this.Containers {
		repeatedStringForContainers += strings.Replace(f.String(), "WindowsContainerStats", "WindowsContainerStats", 1) + ","
	}
	repeatedStringForContainers += "}"
	s := strings.Join([]string{`&WindowsPodSandboxStats{`,
		`Cpu:` + strings.Replace(this.Cpu.String(), "WindowsCpuUsage", "WindowsCpuUsage", 1) + `,`,
		`Memory:` + strings.Replace(this.Memory.String(), "WindowsMemoryUsage", "WindowsMemoryUsage", 1) + `,`,
		`Network:` + strings.Replace(this.Network.String(), "WindowsNetworkUsage", "WindowsNetworkUsage", 1) + `,`,
		`Process:` + strings.Replace(this.Process.String(), "WindowsProcessUsage", "WindowsProcessUsage", 1) + `,`,
		`Containers:` + repeatedStringForContainers + `,`,
		`}`,
	}, "")
	return s
}
func (this *NetworkUsage) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForInterfaces := "[]*NetworkInterfaceUsage{"
	for _, f := range this.Interfaces {
		repeatedStringForInterfaces += strings.Replace(f.String(), "NetworkInterfaceUsage", "NetworkInterfaceUsage", 1) + ","
	}
	repeatedStringForInterfaces += "}"
	s := strings.Join([]string{`&NetworkUsage{`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`DefaultInterface:` + strings.Replace(this.DefaultInterface.String(), "NetworkInterfaceUsage", "NetworkInterfaceUsage", 1) + `,`,
		`Interfaces:` + repeatedStringForInterfaces + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsNetworkUsage) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForInterfaces := "[]*WindowsNetworkInterfaceUsage{"
	for _, f := range this.Interfaces {
		repeatedStringForInterfaces += strings.Replace(f.String(), "WindowsNetworkInterfaceUsage", "WindowsNetworkInterfaceUsage", 1) + ","
	}
	repeatedStringForInterfaces += "}"
	s := strings.Join([]string{`&WindowsNetworkUsage{`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`DefaultInterface:` + strings.Replace(this.DefaultInterface.String(), "WindowsNetworkInterfaceUsage", "WindowsNetworkInterfaceUsage", 1) + `,`,
		`Interfaces:` + repeatedStringForInterfaces + `,`,
		`}`,
	}, "")
	return s
}
func (this *NetworkInterfaceUsage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NetworkInterfaceUsage{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`RxBytes:` + strings.Replace(this.RxBytes.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`RxErrors:` + strings.Replace(this.RxErrors.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`TxBytes:` + strings.Replace(this.TxBytes.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`TxErrors:` + strings.Replace(this.TxErrors.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsNetworkInterfaceUsage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WindowsNetworkInterfaceUsage{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`RxBytes:` + strings.Replace(this.RxBytes.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`RxPacketsDropped:` + strings.Replace(this.RxPacketsDropped.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`TxBytes:` + strings.Replace(this.TxBytes.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`TxPacketsDropped:` + strings.Replace(this.TxPacketsDropped.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ProcessUsage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ProcessUsage{`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`ProcessCount:` + strings.Replace(this.ProcessCount.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsProcessUsage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WindowsProcessUsage{`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`ProcessCount:` + strings.Replace(this.ProcessCount.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ImageSpec) String() string {
	if this == nil {
		return "nil"
	}
	keysForAnnotations := make([]string, 0, len(this.Annotations))
	for k := range this.Annotations {
		keysForAnnotations = append(keysForAnnotations, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAnnotations)
	mapStringForAnnotations := "map[string]string{"
	for _, k := range keysForAnnotations {
		mapStringForAnnotations += fmt.Sprintf("%v: %v,", k, this.Annotations[k])
	}
	mapStringForAnnotations += "}"
	s := strings.Join([]string{`&ImageSpec{`,
		`Image:` + fmt.Sprintf("%v", this.Image) + `,`,
		`Annotations:` + mapStringForAnnotations + `,`,
		`UserSpecifiedImage:` + fmt.Sprintf("%v", this.UserSpecifiedImage) + `,`,
		`RuntimeHandler:` + fmt.Sprintf("%v", this.RuntimeHandler) + `,`,
		`}`,
	}, "")
	return s
}
func (this *KeyValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&KeyValue{`,
		`Key:` + fmt.Sprintf("%v", this.Key) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxContainerResources) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForHugepageLimits := "[]*HugepageLimit{"
	for _, f := range this.HugepageLimits {
		repeatedStringForHugepageLimits += strings.Replace(f.String(), "HugepageLimit", "HugepageLimit", 1) + ","
	}
	repeatedStringForHugepageLimits += "}"
	keysForUnified := make([]string, 0, len(this.Unified))
	for k := range this.Unified {
		keysForUnified = append(keysForUnified, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForUnified)
	mapStringForUnified := "map[string]string{"
	for _, k := range keysForUnified {
		mapStringForUnified += fmt.Sprintf("%v: %v,", k, this.Unified[k])
	}
	mapStringForUnified += "}"
	s := strings.Join([]string{`&LinuxContainerResources{`,
		`CpuPeriod:` + fmt.Sprintf("%v", this.CpuPeriod) + `,`,
		`CpuQuota:` + fmt.Sprintf("%v", this.CpuQuota) + `,`,
		`CpuShares:` + fmt.Sprintf("%v", this.CpuShares) + `,`,
		`MemoryLimitInBytes:` + fmt.Sprintf("%v", this.MemoryLimitInBytes) + `,`,
		`OomScoreAdj:` + fmt.Sprintf("%v", this.OomScoreAdj) + `,`,
		`CpusetCpus:` + fmt.Sprintf("%v", this.CpusetCpus) + `,`,
		`CpusetMems:` + fmt.Sprintf("%v", this.CpusetMems) + `,`,
		`HugepageLimits:` + repeatedStringForHugepageLimits + `,`,
		`Unified:` + mapStringForUnified + `,`,
		`MemorySwapLimitInBytes:` + fmt.Sprintf("%v", this.MemorySwapLimitInBytes) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HugepageLimit) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HugepageLimit{`,
		`PageSize:` + fmt.Sprintf("%v", this.PageSize) + `,`,
		`Limit:` + fmt.Sprintf("%v", this.Limit) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SELinuxOption) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SELinuxOption{`,
		`User:` + fmt.Sprintf("%v", this.User) + `,`,
		`Role:` + fmt.Sprintf("%v", this.Role) + `,`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Level:` + fmt.Sprintf("%v", this.Level) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Capability) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Capability{`,
		`AddCapabilities:` + fmt.Sprintf("%v", this.AddCapabilities) + `,`,
		`DropCapabilities:` + fmt.Sprintf("%v", this.DropCapabilities) + `,`,
		`AddAmbientCapabilities:` + fmt.Sprintf("%v", this.AddAmbientCapabilities) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxContainerSecurityContext) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxContainerSecurityContext{`,
		`Capabilities:` + strings.Replace(this.Capabilities.String(), "Capability", "Capability", 1) + `,`,
		`Privileged:` + fmt.Sprintf("%v", this.Privileged) + `,`,
		`NamespaceOptions:` + strings.Replace(this.NamespaceOptions.String(), "NamespaceOption", "NamespaceOption", 1) + `,`,
		`SelinuxOptions:` + strings.Replace(this.SelinuxOptions.String(), "SELinuxOption", "SELinuxOption", 1) + `,`,
		`RunAsUser:` + strings.Replace(this.RunAsUser.String(), "Int64Value", "Int64Value", 1) + `,`,
		`RunAsUsername:` + fmt.Sprintf("%v", this.RunAsUsername) + `,`,
		`ReadonlyRootfs:` + fmt.Sprintf("%v", this.ReadonlyRootfs) + `,`,
		`SupplementalGroups:` + fmt.Sprintf("%v", this.SupplementalGroups) + `,`,
		`ApparmorProfile:` + fmt.Sprintf("%v", this.ApparmorProfile) + `,`,
		`SeccompProfilePath:` + fmt.Sprintf("%v", this.SeccompProfilePath) + `,`,
		`NoNewPrivs:` + fmt.Sprintf("%v", this.NoNewPrivs) + `,`,
		`RunAsGroup:` + strings.Replace(this.RunAsGroup.String(), "Int64Value", "Int64Value", 1) + `,`,
		`MaskedPaths:` + fmt.Sprintf("%v", this.MaskedPaths) + `,`,
		`ReadonlyPaths:` + fmt.Sprintf("%v", this.ReadonlyPaths) + `,`,
		`Seccomp:` + strings.Replace(this.Seccomp.String(), "SecurityProfile", "SecurityProfile", 1) + `,`,
		`Apparmor:` + strings.Replace(this.Apparmor.String(), "SecurityProfile", "SecurityProfile", 1) + `,`,
		`SupplementalGroupsPolicy:` + fmt.Sprintf("%v", this.SupplementalGroupsPolicy) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxContainerConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxContainerConfig{`,
		`Resources:` + strings.Replace(this.Resources.String(), "LinuxContainerResources", "LinuxContainerResources", 1) + `,`,
		`SecurityContext:` + strings.Replace(this.SecurityContext.String(), "LinuxContainerSecurityContext", "LinuxContainerSecurityContext", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxContainerUser) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxContainerUser{`,
		`Uid:` + fmt.Sprintf("%v", this.Uid) + `,`,
		`Gid:` + fmt.Sprintf("%v", this.Gid) + `,`,
		`SupplementalGroups:` + fmt.Sprintf("%v", this.SupplementalGroups) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsNamespaceOption) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WindowsNamespaceOption{`,
		`Network:` + fmt.Sprintf("%v", this.Network) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsSandboxSecurityContext) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WindowsSandboxSecurityContext{`,
		`RunAsUsername:` + fmt.Sprintf("%v", this.RunAsUsername) + `,`,
		`CredentialSpec:` + fmt.Sprintf("%v", this.CredentialSpec) + `,`,
		`HostProcess:` + fmt.Sprintf("%v", this.HostProcess) + `,`,
		`NamespaceOptions:` + strings.Replace(this.NamespaceOptions.String(), "WindowsNamespaceOption", "WindowsNamespaceOption", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsPodSandboxConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WindowsPodSandboxConfig{`,
		`SecurityContext:` + strings.Replace(this.SecurityContext.String(), "WindowsSandboxSecurityContext", "WindowsSandboxSecurityContext", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsContainerSecurityContext) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WindowsContainerSecurityContext{`,
		`RunAsUsername:` + fmt.Sprintf("%v", this.RunAsUsername) + `,`,
		`CredentialSpec:` + fmt.Sprintf("%v", this.CredentialSpec) + `,`,
		`HostProcess:` + fmt.Sprintf("%v", this.HostProcess) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsContainerConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WindowsContainerConfig{`,
		`Resources:` + strings.Replace(this.Resources.String(), "WindowsContainerResources", "WindowsContainerResources", 1) + `,`,
		`SecurityContext:` + strings.Replace(this.SecurityContext.String(), "WindowsContainerSecurityContext", "WindowsContainerSecurityContext", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsContainerResources) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WindowsContainerResources{`,
		`CpuShares:` + fmt.Sprintf("%v", this.CpuShares) + `,`,
		`CpuCount:` + fmt.Sprintf("%v", this.CpuCount) + `,`,
		`CpuMaximum:` + fmt.Sprintf("%v", this.CpuMaximum) + `,`,
		`MemoryLimitInBytes:` + fmt.Sprintf("%v", this.MemoryLimitInBytes) + `,`,
		`RootfsSizeInBytes:` + fmt.Sprintf("%v", this.RootfsSizeInBytes) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerMetadata) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerMetadata{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Attempt:` + fmt.Sprintf("%v", this.Attempt) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Device) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Device{`,
		`ContainerPath:` + fmt.Sprintf("%v", this.ContainerPath) + `,`,
		`HostPath:` + fmt.Sprintf("%v", this.HostPath) + `,`,
		`Permissions:` + fmt.Sprintf("%v", this.Permissions) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CDIDevice) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CDIDevice{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerConfig) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForEnvs := "[]*KeyValue{"
	for _, f := range this.Envs {
		repeatedStringForEnvs += strings.Replace(f.String(), "KeyValue", "KeyValue", 1) + ","
	}
	repeatedStringForEnvs += "}"
	repeatedStringForMounts := "[]*Mount{"
	for _, f := range this.Mounts {
		repeatedStringForMounts += strings.Replace(f.String(), "Mount", "Mount", 1) + ","
	}
	repeatedStringForMounts += "}"
	repeatedStringForDevices := "[]*Device{"
	for _, f := range this.Devices {
		repeatedStringForDevices += strings.Replace(f.String(), "Device", "Device", 1) + ","
	}
	repeatedStringForDevices += "}"
	repeatedStringForCDIDevices := "[]*CDIDevice{"
	for _, f := range this.CDIDevices {
		repeatedStringForCDIDevices += strings.Replace(f.String(), "CDIDevice", "CDIDevice", 1) + ","
	}
	repeatedStringForCDIDevices += "}"
	keysForLabels := make([]string, 0, len(this.Labels))
	for k := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%v: %v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	keysForAnnotations := make([]string, 0, len(this.Annotations))
	for k := range this.Annotations {
		keysForAnnotations = append(keysForAnnotations, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAnnotations)
	mapStringForAnnotations := "map[string]string{"
	for _, k := range keysForAnnotations {
		mapStringForAnnotations += fmt.Sprintf("%v: %v,", k, this.Annotations[k])
	}
	mapStringForAnnotations += "}"
	s := strings.Join([]string{`&ContainerConfig{`,
		`Metadata:` + strings.Replace(this.Metadata.String(), "ContainerMetadata", "ContainerMetadata", 1) + `,`,
		`Image:` + strings.Replace(this.Image.String(), "ImageSpec", "ImageSpec", 1) + `,`,
		`Command:` + fmt.Sprintf("%v", this.Command) + `,`,
		`Args:` + fmt.Sprintf("%v", this.Args) + `,`,
		`WorkingDir:` + fmt.Sprintf("%v", this.WorkingDir) + `,`,
		`Envs:` + repeatedStringForEnvs + `,`,
		`Mounts:` + repeatedStringForMounts + `,`,
		`Devices:` + repeatedStringForDevices + `,`,
		`Labels:` + mapStringForLabels + `,`,
		`Annotations:` + mapStringForAnnotations + `,`,
		`LogPath:` + fmt.Sprintf("%v", this.LogPath) + `,`,
		`Stdin:` + fmt.Sprintf("%v", this.Stdin) + `,`,
		`StdinOnce:` + fmt.Sprintf("%v", this.StdinOnce) + `,`,
		`Tty:` + fmt.Sprintf("%v", this.Tty) + `,`,
		`Linux:` + strings.Replace(this.Linux.String(), "LinuxContainerConfig", "LinuxContainerConfig", 1) + `,`,
		`Windows:` + strings.Replace(this.Windows.String(), "WindowsContainerConfig", "WindowsContainerConfig", 1) + `,`,
		`CDIDevices:` + repeatedStringForCDIDevices + `,`,
		`}`,
	}, "")
	return s
}
func (this *CreateContainerRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CreateContainerRequest{`,
		`PodSandboxId:` + fmt.Sprintf("%v", this.PodSandboxId) + `,`,
		`Config:` + strings.Replace(this.Config.String(), "ContainerConfig", "ContainerConfig", 1) + `,`,
		`SandboxConfig:` + strings.Replace(this.SandboxConfig.String(), "PodSandboxConfig", "PodSandboxConfig", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CreateContainerResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CreateContainerResponse{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StartContainerRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StartContainerRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StartContainerResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StartContainerResponse{`,
		`}`,
	}, "")
	return s
}
func (this *StopContainerRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StopContainerRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`Timeout:` + fmt.Sprintf("%v", this.Timeout) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StopContainerResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StopContainerResponse{`,
		`}`,
	}, "")
	return s
}
func (this *RemoveContainerRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveContainerRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveContainerResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveContainerResponse{`,
		`}`,
	}, "")
	return s
}
func (this *ContainerStateValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerStateValue{`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerFilter) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabelSelector := make([]string, 0, len(this.LabelSelector))
	for k := range this.LabelSelector {
		keysForLabelSelector = append(keysForLabelSelector, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabelSelector)
	mapStringForLabelSelector := "map[string]string{"
	for _, k := range keysForLabelSelector {
		mapStringForLabelSelector += fmt.Sprintf("%v: %v,", k, this.LabelSelector[k])
	}
	mapStringForLabelSelector += "}"
	s := strings.Join([]string{`&ContainerFilter{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`State:` + strings.Replace(this.State.String(), "ContainerStateValue", "ContainerStateValue", 1) + `,`,
		`PodSandboxId:` + fmt.Sprintf("%v", this.PodSandboxId) + `,`,
		`LabelSelector:` + mapStringForLabelSelector + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListContainersRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListContainersRequest{`,
		`Filter:` + strings.Replace(this.Filter.String(), "ContainerFilter", "ContainerFilter", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Container) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabels := make([]string, 0, len(this.Labels))
	for k := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%v: %v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	keysForAnnotations := make([]string, 0, len(this.Annotations))
	for k := range this.Annotations {
		keysForAnnotations = append(keysForAnnotations, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAnnotations)
	mapStringForAnnotations := "map[string]string{"
	for _, k := range keysForAnnotations {
		mapStringForAnnotations += fmt.Sprintf("%v: %v,", k, this.Annotations[k])
	}
	mapStringForAnnotations += "}"
	s := strings.Join([]string{`&Container{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`PodSandboxId:` + fmt.Sprintf("%v", this.PodSandboxId) + `,`,
		`Metadata:` + strings.Replace(this.Metadata.String(), "ContainerMetadata", "ContainerMetadata", 1) + `,`,
		`Image:` + strings.Replace(this.Image.String(), "ImageSpec", "ImageSpec", 1) + `,`,
		`ImageRef:` + fmt.Sprintf("%v", this.ImageRef) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`CreatedAt:` + fmt.Sprintf("%v", this.CreatedAt) + `,`,
		`Labels:` + mapStringForLabels + `,`,
		`Annotations:` + mapStringForAnnotations + `,`,
		`ImageId:` + fmt.Sprintf("%v", this.ImageId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListContainersResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForContainers := "[]*Container{"
	for _, f := range this.Containers {
		repeatedStringForContainers += strings.Replace(f.String(), "Container", "Container", 1) + ","
	}
	repeatedStringForContainers += "}"
	s := strings.Join([]string{`&ListContainersResponse{`,
		`Containers:` + repeatedStringForContainers + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerStatusRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerStatusRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`Verbose:` + fmt.Sprintf("%v", this.Verbose) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerStatus) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForMounts := "[]*Mount{"
	for _, f := range this.Mounts {
		repeatedStringForMounts += strings.Replace(f.String(), "Mount", "Mount", 1) + ","
	}
	repeatedStringForMounts += "}"
	keysForLabels := make([]string, 0, len(this.Labels))
	for k := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%v: %v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	keysForAnnotations := make([]string, 0, len(this.Annotations))
	for k := range this.Annotations {
		keysForAnnotations = append(keysForAnnotations, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAnnotations)
	mapStringForAnnotations := "map[string]string{"
	for _, k := range keysForAnnotations {
		mapStringForAnnotations += fmt.Sprintf("%v: %v,", k, this.Annotations[k])
	}
	mapStringForAnnotations += "}"
	s := strings.Join([]string{`&ContainerStatus{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`Metadata:` + strings.Replace(this.Metadata.String(), "ContainerMetadata", "ContainerMetadata", 1) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`CreatedAt:` + fmt.Sprintf("%v", this.CreatedAt) + `,`,
		`StartedAt:` + fmt.Sprintf("%v", this.StartedAt) + `,`,
		`FinishedAt:` + fmt.Sprintf("%v", this.FinishedAt) + `,`,
		`ExitCode:` + fmt.Sprintf("%v", this.ExitCode) + `,`,
		`Image:` + strings.Replace(this.Image.String(), "ImageSpec", "ImageSpec", 1) + `,`,
		`ImageRef:` + fmt.Sprintf("%v", this.ImageRef) + `,`,
		`Reason:` + fmt.Sprintf("%v", this.Reason) + `,`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`Labels:` + mapStringForLabels + `,`,
		`Annotations:` + mapStringForAnnotations + `,`,
		`Mounts:` + repeatedStringForMounts + `,`,
		`LogPath:` + fmt.Sprintf("%v", this.LogPath) + `,`,
		`Resources:` + strings.Replace(this.Resources.String(), "ContainerResources", "ContainerResources", 1) + `,`,
		`ImageId:` + fmt.Sprintf("%v", this.ImageId) + `,`,
		`User:` + strings.Replace(this.User.String(), "ContainerUser", "ContainerUser", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerStatusResponse) String() string {
	if this == nil {
		return "nil"
	}
	keysForInfo := make([]string, 0, len(this.Info))
	for k := range this.Info {
		keysForInfo = append(keysForInfo, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForInfo)
	mapStringForInfo := "map[string]string{"
	for _, k := range keysForInfo {
		mapStringForInfo += fmt.Sprintf("%v: %v,", k, this.Info[k])
	}
	mapStringForInfo += "}"
	s := strings.Join([]string{`&ContainerStatusResponse{`,
		`Status:` + strings.Replace(this.Status.String(), "ContainerStatus", "ContainerStatus", 1) + `,`,
		`Info:` + mapStringForInfo + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerResources) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerResources{`,
		`Linux:` + strings.Replace(this.Linux.String(), "LinuxContainerResources", "LinuxContainerResources", 1) + `,`,
		`Windows:` + strings.Replace(this.Windows.String(), "WindowsContainerResources", "WindowsContainerResources", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerUser) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerUser{`,
		`Linux:` + strings.Replace(this.Linux.String(), "LinuxContainerUser", "LinuxContainerUser", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateContainerResourcesRequest) String() string {
	if this == nil {
		return "nil"
	}
	keysForAnnotations := make([]string, 0, len(this.Annotations))
	for k := range this.Annotations {
		keysForAnnotations = append(keysForAnnotations, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAnnotations)
	mapStringForAnnotations := "map[string]string{"
	for _, k := range keysForAnnotations {
		mapStringForAnnotations += fmt.Sprintf("%v: %v,", k, this.Annotations[k])
	}
	mapStringForAnnotations += "}"
	s := strings.Join([]string{`&UpdateContainerResourcesRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`Linux:` + strings.Replace(this.Linux.String(), "LinuxContainerResources", "LinuxContainerResources", 1) + `,`,
		`Windows:` + strings.Replace(this.Windows.String(), "WindowsContainerResources", "WindowsContainerResources", 1) + `,`,
		`Annotations:` + mapStringForAnnotations + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateContainerResourcesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateContainerResourcesResponse{`,
		`}`,
	}, "")
	return s
}
func (this *ExecSyncRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ExecSyncRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`Cmd:` + fmt.Sprintf("%v", this.Cmd) + `,`,
		`Timeout:` + fmt.Sprintf("%v", this.Timeout) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ExecSyncResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ExecSyncResponse{`,
		`Stdout:` + fmt.Sprintf("%v", this.Stdout) + `,`,
		`Stderr:` + fmt.Sprintf("%v", this.Stderr) + `,`,
		`ExitCode:` + fmt.Sprintf("%v", this.ExitCode) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ExecRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ExecRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`Cmd:` + fmt.Sprintf("%v", this.Cmd) + `,`,
		`Tty:` + fmt.Sprintf("%v", this.Tty) + `,`,
		`Stdin:` + fmt.Sprintf("%v", this.Stdin) + `,`,
		`Stdout:` + fmt.Sprintf("%v", this.Stdout) + `,`,
		`Stderr:` + fmt.Sprintf("%v", this.Stderr) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ExecResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ExecResponse{`,
		`Url:` + fmt.Sprintf("%v", this.Url) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AttachRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AttachRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`Stdin:` + fmt.Sprintf("%v", this.Stdin) + `,`,
		`Tty:` + fmt.Sprintf("%v", this.Tty) + `,`,
		`Stdout:` + fmt.Sprintf("%v", this.Stdout) + `,`,
		`Stderr:` + fmt.Sprintf("%v", this.Stderr) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AttachResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AttachResponse{`,
		`Url:` + fmt.Sprintf("%v", this.Url) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PortForwardRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PortForwardRequest{`,
		`PodSandboxId:` + fmt.Sprintf("%v", this.PodSandboxId) + `,`,
		`Port:` + fmt.Sprintf("%v", this.Port) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PortForwardResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PortForwardResponse{`,
		`Url:` + fmt.Sprintf("%v", this.Url) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ImageFilter) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ImageFilter{`,
		`Image:` + strings.Replace(this.Image.String(), "ImageSpec", "ImageSpec", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListImagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListImagesRequest{`,
		`Filter:` + strings.Replace(this.Filter.String(), "ImageFilter", "ImageFilter", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Image) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Image{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`RepoTags:` + fmt.Sprintf("%v", this.RepoTags) + `,`,
		`RepoDigests:` + fmt.Sprintf("%v", this.RepoDigests) + `,`,
		`Size_:` + fmt.Sprintf("%v", this.Size_) + `,`,
		`Uid:` + strings.Replace(this.Uid.String(), "Int64Value", "Int64Value", 1) + `,`,
		`Username:` + fmt.Sprintf("%v", this.Username) + `,`,
		`Spec:` + strings.Replace(this.Spec.String(), "ImageSpec", "ImageSpec", 1) + `,`,
		`Pinned:` + fmt.Sprintf("%v", this.Pinned) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListImagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForImages := "[]*Image{"
	for _, f := range this.Images {
		repeatedStringForImages += strings.Replace(f.String(), "Image", "Image", 1) + ","
	}
	repeatedStringForImages += "}"
	s := strings.Join([]string{`&ListImagesResponse{`,
		`Images:` + repeatedStringForImages + `,`,
		`}`,
	}, "")
	return s
}
func (this *ImageStatusRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ImageStatusRequest{`,
		`Image:` + strings.Replace(this.Image.String(), "ImageSpec", "ImageSpec", 1) + `,`,
		`Verbose:` + fmt.Sprintf("%v", this.Verbose) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ImageStatusResponse) String() string {
	if this == nil {
		return "nil"
	}
	keysForInfo := make([]string, 0, len(this.Info))
	for k := range this.Info {
		keysForInfo = append(keysForInfo, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForInfo)
	mapStringForInfo := "map[string]string{"
	for _, k := range keysForInfo {
		mapStringForInfo += fmt.Sprintf("%v: %v,", k, this.Info[k])
	}
	mapStringForInfo += "}"
	s := strings.Join([]string{`&ImageStatusResponse{`,
		`Image:` + strings.Replace(this.Image.String(), "Image", "Image", 1) + `,`,
		`Info:` + mapStringForInfo + `,`,
		`}`,
	}, "")
	return s
}
func (this *AuthConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AuthConfig{`,
		`Username:` + fmt.Sprintf("%v", this.Username) + `,`,
		`Password:` + fmt.Sprintf("%v", this.Password) + `,`,
		`Auth:` + fmt.Sprintf("%v", this.Auth) + `,`,
		`ServerAddress:` + fmt.Sprintf("%v", this.ServerAddress) + `,`,
		`IdentityToken:` + fmt.Sprintf("%v", this.IdentityToken) + `,`,
		`RegistryToken:` + fmt.Sprintf("%v", this.RegistryToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PullImageRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PullImageRequest{`,
		`Image:` + strings.Replace(this.Image.String(), "ImageSpec", "ImageSpec", 1) + `,`,
		`Auth:` + strings.Replace(this.Auth.String(), "AuthConfig", "AuthConfig", 1) + `,`,
		`SandboxConfig:` + strings.Replace(this.SandboxConfig.String(), "PodSandboxConfig", "PodSandboxConfig", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PullImageResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PullImageResponse{`,
		`ImageRef:` + fmt.Sprintf("%v", this.ImageRef) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveImageRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveImageRequest{`,
		`Image:` + strings.Replace(this.Image.String(), "ImageSpec", "ImageSpec", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveImageResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveImageResponse{`,
		`}`,
	}, "")
	return s
}
func (this *NetworkConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NetworkConfig{`,
		`PodCidr:` + fmt.Sprintf("%v", this.PodCidr) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RuntimeConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RuntimeConfig{`,
		`NetworkConfig:` + strings.Replace(this.NetworkConfig.String(), "NetworkConfig", "NetworkConfig", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateRuntimeConfigRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateRuntimeConfigRequest{`,
		`RuntimeConfig:` + strings.Replace(this.RuntimeConfig.String(), "RuntimeConfig", "RuntimeConfig", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateRuntimeConfigResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateRuntimeConfigResponse{`,
		`}`,
	}, "")
	return s
}
func (this *RuntimeCondition) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RuntimeCondition{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`Reason:` + fmt.Sprintf("%v", this.Reason) + `,`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RuntimeStatus) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForConditions := "[]*RuntimeCondition{"
	for _, f := range this.Conditions {
		repeatedStringForConditions += strings.Replace(f.String(), "RuntimeCondition", "RuntimeCondition", 1) + ","
	}
	repeatedStringForConditions += "}"
	s := strings.Join([]string{`&RuntimeStatus{`,
		`Conditions:` + repeatedStringForConditions + `,`,
		`}`,
	}, "")
	return s
}
func (this *StatusRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StatusRequest{`,
		`Verbose:` + fmt.Sprintf("%v", this.Verbose) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RuntimeHandlerFeatures) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RuntimeHandlerFeatures{`,
		`RecursiveReadOnlyMounts:` + fmt.Sprintf("%v", this.RecursiveReadOnlyMounts) + `,`,
		`UserNamespaces:` + fmt.Sprintf("%v", this.UserNamespaces) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RuntimeHandler) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RuntimeHandler{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Features:` + strings.Replace(this.Features.String(), "RuntimeHandlerFeatures", "RuntimeHandlerFeatures", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StatusResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForRuntimeHandlers := "[]*RuntimeHandler{"
	for _, f := range this.RuntimeHandlers {
		repeatedStringForRuntimeHandlers += strings.Replace(f.String(), "RuntimeHandler", "RuntimeHandler", 1) + ","
	}
	repeatedStringForRuntimeHandlers += "}"
	keysForInfo := make([]string, 0, len(this.Info))
	for k := range this.Info {
		keysForInfo = append(keysForInfo, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForInfo)
	mapStringForInfo := "map[string]string{"
	for _, k := range keysForInfo {
		mapStringForInfo += fmt.Sprintf("%v: %v,", k, this.Info[k])
	}
	mapStringForInfo += "}"
	s := strings.Join([]string{`&StatusResponse{`,
		`Status:` + strings.Replace(this.Status.String(), "RuntimeStatus", "RuntimeStatus", 1) + `,`,
		`Info:` + mapStringForInfo + `,`,
		`RuntimeHandlers:` + repeatedStringForRuntimeHandlers + `,`,
		`}`,
	}, "")
	return s
}
func (this *ImageFsInfoRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ImageFsInfoRequest{`,
		`}`,
	}, "")
	return s
}
func (this *UInt64Value) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UInt64Value{`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *FilesystemIdentifier) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FilesystemIdentifier{`,
		`Mountpoint:` + fmt.Sprintf("%v", this.Mountpoint) + `,`,
		`}`,
	}, "")
	return s
}
func (this *FilesystemUsage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FilesystemUsage{`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`FsId:` + strings.Replace(this.FsId.String(), "FilesystemIdentifier", "FilesystemIdentifier", 1) + `,`,
		`UsedBytes:` + strings.Replace(this.UsedBytes.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`InodesUsed:` + strings.Replace(this.InodesUsed.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsFilesystemUsage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WindowsFilesystemUsage{`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`FsId:` + strings.Replace(this.FsId.String(), "FilesystemIdentifier", "FilesystemIdentifier", 1) + `,`,
		`UsedBytes:` + strings.Replace(this.UsedBytes.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ImageFsInfoResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForImageFilesystems := "[]*FilesystemUsage{"
	for _, f := range this.ImageFilesystems {
		repeatedStringForImageFilesystems += strings.Replace(f.String(), "FilesystemUsage", "FilesystemUsage", 1) + ","
	}
	repeatedStringForImageFilesystems += "}"
	repeatedStringForContainerFilesystems := "[]*FilesystemUsage{"
	for _, f := range this.ContainerFilesystems {
		repeatedStringForContainerFilesystems += strings.Replace(f.String(), "FilesystemUsage", "FilesystemUsage", 1) + ","
	}
	repeatedStringForContainerFilesystems += "}"
	s := strings.Join([]string{`&ImageFsInfoResponse{`,
		`ImageFilesystems:` + repeatedStringForImageFilesystems + `,`,
		`ContainerFilesystems:` + repeatedStringForContainerFilesystems + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerStatsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerStatsRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerStatsResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerStatsResponse{`,
		`Stats:` + strings.Replace(this.Stats.String(), "ContainerStats", "ContainerStats", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListContainerStatsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListContainerStatsRequest{`,
		`Filter:` + strings.Replace(this.Filter.String(), "ContainerStatsFilter", "ContainerStatsFilter", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerStatsFilter) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabelSelector := make([]string, 0, len(this.LabelSelector))
	for k := range this.LabelSelector {
		keysForLabelSelector = append(keysForLabelSelector, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabelSelector)
	mapStringForLabelSelector := "map[string]string{"
	for _, k := range keysForLabelSelector {
		mapStringForLabelSelector += fmt.Sprintf("%v: %v,", k, this.LabelSelector[k])
	}
	mapStringForLabelSelector += "}"
	s := strings.Join([]string{`&ContainerStatsFilter{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`PodSandboxId:` + fmt.Sprintf("%v", this.PodSandboxId) + `,`,
		`LabelSelector:` + mapStringForLabelSelector + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListContainerStatsResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForStats := "[]*ContainerStats{"
	for _, f := range this.Stats {
		repeatedStringForStats += strings.Replace(f.String(), "ContainerStats", "ContainerStats", 1) + ","
	}
	repeatedStringForStats += "}"
	s := strings.Join([]string{`&ListContainerStatsResponse{`,
		`Stats:` + repeatedStringForStats + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerAttributes) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabels := make([]string, 0, len(this.Labels))
	for k := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%v: %v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	keysForAnnotations := make([]string, 0, len(this.Annotations))
	for k := range this.Annotations {
		keysForAnnotations = append(keysForAnnotations, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAnnotations)
	mapStringForAnnotations := "map[string]string{"
	for _, k := range keysForAnnotations {
		mapStringForAnnotations += fmt.Sprintf("%v: %v,", k, this.Annotations[k])
	}
	mapStringForAnnotations += "}"
	s := strings.Join([]string{`&ContainerAttributes{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`Metadata:` + strings.Replace(this.Metadata.String(), "ContainerMetadata", "ContainerMetadata", 1) + `,`,
		`Labels:` + mapStringForLabels + `,`,
		`Annotations:` + mapStringForAnnotations + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerStats) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerStats{`,
		`Attributes:` + strings.Replace(this.Attributes.String(), "ContainerAttributes", "ContainerAttributes", 1) + `,`,
		`Cpu:` + strings.Replace(this.Cpu.String(), "CpuUsage", "CpuUsage", 1) + `,`,
		`Memory:` + strings.Replace(this.Memory.String(), "MemoryUsage", "MemoryUsage", 1) + `,`,
		`WritableLayer:` + strings.Replace(this.WritableLayer.String(), "FilesystemUsage", "FilesystemUsage", 1) + `,`,
		`Swap:` + strings.Replace(this.Swap.String(), "SwapUsage", "SwapUsage", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsContainerStats) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WindowsContainerStats{`,
		`Attributes:` + strings.Replace(this.Attributes.String(), "ContainerAttributes", "ContainerAttributes", 1) + `,`,
		`Cpu:` + strings.Replace(this.Cpu.String(), "WindowsCpuUsage", "WindowsCpuUsage", 1) + `,`,
		`Memory:` + strings.Replace(this.Memory.String(), "WindowsMemoryUsage", "WindowsMemoryUsage", 1) + `,`,
		`WritableLayer:` + strings.Replace(this.WritableLayer.String(), "WindowsFilesystemUsage", "WindowsFilesystemUsage", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CpuUsage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CpuUsage{`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`UsageCoreNanoSeconds:` + strings.Replace(this.UsageCoreNanoSeconds.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`UsageNanoCores:` + strings.Replace(this.UsageNanoCores.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsCpuUsage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WindowsCpuUsage{`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`UsageCoreNanoSeconds:` + strings.Replace(this.UsageCoreNanoSeconds.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`UsageNanoCores:` + strings.Replace(this.UsageNanoCores.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MemoryUsage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MemoryUsage{`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`WorkingSetBytes:` + strings.Replace(this.WorkingSetBytes.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`AvailableBytes:` + strings.Replace(this.AvailableBytes.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`UsageBytes:` + strings.Replace(this.UsageBytes.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`RssBytes:` + strings.Replace(this.RssBytes.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`PageFaults:` + strings.Replace(this.PageFaults.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`MajorPageFaults:` + strings.Replace(this.MajorPageFaults.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SwapUsage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SwapUsage{`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`SwapAvailableBytes:` + strings.Replace(this.SwapAvailableBytes.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`SwapUsageBytes:` + strings.Replace(this.SwapUsageBytes.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WindowsMemoryUsage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WindowsMemoryUsage{`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`WorkingSetBytes:` + strings.Replace(this.WorkingSetBytes.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`AvailableBytes:` + strings.Replace(this.AvailableBytes.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`PageFaults:` + strings.Replace(this.PageFaults.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`CommitMemoryBytes:` + strings.Replace(this.CommitMemoryBytes.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReopenContainerLogRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReopenContainerLogRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReopenContainerLogResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReopenContainerLogResponse{`,
		`}`,
	}, "")
	return s
}
func (this *CheckpointContainerRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CheckpointContainerRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`Location:` + fmt.Sprintf("%v", this.Location) + `,`,
		`Timeout:` + fmt.Sprintf("%v", this.Timeout) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CheckpointContainerResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CheckpointContainerResponse{`,
		`}`,
	}, "")
	return s
}
func (this *GetEventsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetEventsRequest{`,
		`}`,
	}, "")
	return s
}
func (this *ContainerEventResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForContainersStatuses := "[]*ContainerStatus{"
	for _, f := range this.ContainersStatuses {
		repeatedStringForContainersStatuses += strings.Replace(f.String(), "ContainerStatus", "ContainerStatus", 1) + ","
	}
	repeatedStringForContainersStatuses += "}"
	s := strings.Join([]string{`&ContainerEventResponse{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`ContainerEventType:` + fmt.Sprintf("%v", this.ContainerEventType) + `,`,
		`CreatedAt:` + fmt.Sprintf("%v", this.CreatedAt) + `,`,
		`PodSandboxStatus:` + strings.Replace(this.PodSandboxStatus.String(), "PodSandboxStatus", "PodSandboxStatus", 1) + `,`,
		`ContainersStatuses:` + repeatedStringForContainersStatuses + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListMetricDescriptorsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListMetricDescriptorsRequest{`,
		`}`,
	}, "")
	return s
}
func (this *ListMetricDescriptorsResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForDescriptors := "[]*MetricDescriptor{"
	for _, f := range this.Descriptors {
		repeatedStringForDescriptors += strings.Replace(f.String(), "MetricDescriptor", "MetricDescriptor", 1) + ","
	}
	repeatedStringForDescriptors += "}"
	s := strings.Join([]string{`&ListMetricDescriptorsResponse{`,
		`Descriptors:` + repeatedStringForDescriptors + `,`,
		`}`,
	}, "")
	return s
}
func (this *MetricDescriptor) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MetricDescriptor{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Help:` + fmt.Sprintf("%v", this.Help) + `,`,
		`LabelKeys:` + fmt.Sprintf("%v", this.LabelKeys) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListPodSandboxMetricsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListPodSandboxMetricsRequest{`,
		`}`,
	}, "")
	return s
}
func (this *ListPodSandboxMetricsResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForPodMetrics := "[]*PodSandboxMetrics{"
	for _, f := range this.PodMetrics {
		repeatedStringForPodMetrics += strings.Replace(f.String(), "PodSandboxMetrics", "PodSandboxMetrics", 1) + ","
	}
	repeatedStringForPodMetrics += "}"
	s := strings.Join([]string{`&ListPodSandboxMetricsResponse{`,
		`PodMetrics:` + repeatedStringForPodMetrics + `,`,
		`}`,
	}, "")
	return s
}
func (this *PodSandboxMetrics) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForMetrics := "[]*Metric{"
	for _, f := range this.Metrics {
		repeatedStringForMetrics += strings.Replace(f.String(), "Metric", "Metric", 1) + ","
	}
	repeatedStringForMetrics += "}"
	repeatedStringForContainerMetrics := "[]*ContainerMetrics{"
	for _, f := range this.ContainerMetrics {
		repeatedStringForContainerMetrics += strings.Replace(f.String(), "ContainerMetrics", "ContainerMetrics", 1) + ","
	}
	repeatedStringForContainerMetrics += "}"
	s := strings.Join([]string{`&PodSandboxMetrics{`,
		`PodSandboxId:` + fmt.Sprintf("%v", this.PodSandboxId) + `,`,
		`Metrics:` + repeatedStringForMetrics + `,`,
		`ContainerMetrics:` + repeatedStringForContainerMetrics + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerMetrics) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForMetrics := "[]*Metric{"
	for _, f := range this.Metrics {
		repeatedStringForMetrics += strings.Replace(f.String(), "Metric", "Metric", 1) + ","
	}
	repeatedStringForMetrics += "}"
	s := strings.Join([]string{`&ContainerMetrics{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`Metrics:` + repeatedStringForMetrics + `,`,
		`}`,
	}, "")
	return s
}
func (this *Metric) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Metric{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`MetricType:` + fmt.Sprintf("%v", this.MetricType) + `,`,
		`LabelValues:` + fmt.Sprintf("%v", this.LabelValues) + `,`,
		`Value:` + strings.Replace(this.Value.String(), "UInt64Value", "UInt64Value", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RuntimeConfigRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RuntimeConfigRequest{`,
		`}`,
	}, "")
	return s
}
func (this *RuntimeConfigResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RuntimeConfigResponse{`,
		`Linux:` + strings.Replace(this.Linux.String(), "LinuxRuntimeConfiguration", "LinuxRuntimeConfiguration", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LinuxRuntimeConfiguration) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LinuxRuntimeConfiguration{`,
		`CgroupDriver:` + fmt.Sprintf("%v", this.CgroupDriver) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringApi(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *VersionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VersionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VersionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VersionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VersionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VersionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeApiVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeApiVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DNSConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DNSConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DNSConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Servers", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Servers = append(m.Servers, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Searches", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Searches = append(m.Searches, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Options = append(m.Options, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PortMapping) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PortMapping: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PortMapping: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			m.Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Protocol |= Protocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerPort", wireType)
			}
			m.ContainerPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ContainerPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostPort", wireType)
			}
			m.HostPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HostPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostIp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostIp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mount) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Mount: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Mount: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Readonly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Readonly = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SelinuxRelabel", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SelinuxRelabel = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Propagation", wireType)
			}
			m.Propagation = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Propagation |= MountPropagation(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UidMappings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UidMappings = append(m.UidMappings, &IDMapping{})
			if err := m.UidMappings[len(m.UidMappings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GidMappings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GidMappings = append(m.GidMappings, &IDMapping{})
			if err := m.GidMappings[len(m.GidMappings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecursiveReadOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RecursiveReadOnly = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IDMapping) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IDMapping: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IDMapping: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostId", wireType)
			}
			m.HostId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HostId |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			m.ContainerId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ContainerId |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Length", wireType)
			}
			m.Length = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Length |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UserNamespace) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UserNamespace: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UserNamespace: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mode |= NamespaceMode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uids", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Uids = append(m.Uids, &IDMapping{})
			if err := m.Uids[len(m.Uids)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gids", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Gids = append(m.Gids, &IDMapping{})
			if err := m.Gids[len(m.Gids)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NamespaceOption) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NamespaceOption: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NamespaceOption: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Network", wireType)
			}
			m.Network = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Network |= NamespaceMode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pid", wireType)
			}
			m.Pid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Pid |= NamespaceMode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ipc", wireType)
			}
			m.Ipc = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Ipc |= NamespaceMode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TargetId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UsernsOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UsernsOptions == nil {
				m.UsernsOptions = &UserNamespace{}
			}
			if err := m.UsernsOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Int64Value) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Int64Value: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Int64Value: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Value |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxSandboxSecurityContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxSandboxSecurityContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxSandboxSecurityContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NamespaceOptions == nil {
				m.NamespaceOptions = &NamespaceOption{}
			}
			if err := m.NamespaceOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SelinuxOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SelinuxOptions == nil {
				m.SelinuxOptions = &SELinuxOption{}
			}
			if err := m.SelinuxOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunAsUser", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RunAsUser == nil {
				m.RunAsUser = &Int64Value{}
			}
			if err := m.RunAsUser.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadonlyRootfs", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReadonlyRootfs = bool(v != 0)
		case 5:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.SupplementalGroups = append(m.SupplementalGroups, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthApi
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthApi
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.SupplementalGroups) == 0 {
					m.SupplementalGroups = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.SupplementalGroups = append(m.SupplementalGroups, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field SupplementalGroups", wireType)
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Privileged", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Privileged = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeccompProfilePath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SeccompProfilePath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunAsGroup", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RunAsGroup == nil {
				m.RunAsGroup = &Int64Value{}
			}
			if err := m.RunAsGroup.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seccomp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Seccomp == nil {
				m.Seccomp = &SecurityProfile{}
			}
			if err := m.Seccomp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Apparmor", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Apparmor == nil {
				m.Apparmor = &SecurityProfile{}
			}
			if err := m.Apparmor.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SupplementalGroupsPolicy", wireType)
			}
			m.SupplementalGroupsPolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SupplementalGroupsPolicy |= SupplementalGroupsPolicy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SecurityProfile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SecurityProfile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SecurityProfile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProfileType", wireType)
			}
			m.ProfileType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProfileType |= SecurityProfile_ProfileType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalhostRef", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LocalhostRef = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxPodSandboxConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxPodSandboxConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxPodSandboxConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CgroupParent", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CgroupParent = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecurityContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SecurityContext == nil {
				m.SecurityContext = &LinuxSandboxSecurityContext{}
			}
			if err := m.SecurityContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sysctls", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Sysctls == nil {
				m.Sysctls = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipApi(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthApi
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Sysctls[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Overhead", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Overhead == nil {
				m.Overhead = &LinuxContainerResources{}
			}
			if err := m.Overhead.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resources == nil {
				m.Resources = &LinuxContainerResources{}
			}
			if err := m.Resources.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PodSandboxMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodSandboxMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodSandboxMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Uid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attempt", wireType)
			}
			m.Attempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Attempt |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PodSandboxConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodSandboxConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodSandboxConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &PodSandboxMetadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hostname = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogDirectory", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LogDirectory = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsConfig == nil {
				m.DnsConfig = &DNSConfig{}
			}
			if err := m.DnsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortMappings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PortMappings = append(m.PortMappings, &PortMapping{})
			if err := m.PortMappings[len(m.PortMappings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipApi(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthApi
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Annotations == nil {
				m.Annotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipApi(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthApi
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Annotations[mapkey] = mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Linux", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Linux == nil {
				m.Linux = &LinuxPodSandboxConfig{}
			}
			if err := m.Linux.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Windows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Windows == nil {
				m.Windows = &WindowsPodSandboxConfig{}
			}
			if err := m.Windows.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RunPodSandboxRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RunPodSandboxRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RunPodSandboxRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &PodSandboxConfig{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeHandler", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeHandler = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RunPodSandboxResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RunPodSandboxResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RunPodSandboxResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodSandboxId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PodSandboxId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StopPodSandboxRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StopPodSandboxRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StopPodSandboxRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodSandboxId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PodSandboxId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StopPodSandboxResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StopPodSandboxResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StopPodSandboxResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemovePodSandboxRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemovePodSandboxRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemovePodSandboxRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodSandboxId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PodSandboxId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemovePodSandboxResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemovePodSandboxResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemovePodSandboxResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PodSandboxStatusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodSandboxStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodSandboxStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodSandboxId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PodSandboxId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Verbose", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Verbose = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PodIP) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodIP: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodIP: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ip", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ip = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PodSandboxNetworkStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodSandboxNetworkStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodSandboxNetworkStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ip", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ip = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdditionalIps", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AdditionalIps = append(m.AdditionalIps, &PodIP{})
			if err := m.AdditionalIps[len(m.AdditionalIps)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Namespace) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Namespace: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Namespace: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &NamespaceOption{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxPodSandboxStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxPodSandboxStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxPodSandboxStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespaces", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Namespaces == nil {
				m.Namespaces = &Namespace{}
			}
			if err := m.Namespaces.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PodSandboxStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodSandboxStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodSandboxStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &PodSandboxMetadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= PodSandboxState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			m.CreatedAt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CreatedAt |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Network", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Network == nil {
				m.Network = &PodSandboxNetworkStatus{}
			}
			if err := m.Network.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Linux", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Linux == nil {
				m.Linux = &LinuxPodSandboxStatus{}
			}
			if err := m.Linux.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipApi(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthApi
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Annotations == nil {
				m.Annotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipApi(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthApi
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Annotations[mapkey] = mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeHandler", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeHandler = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PodSandboxStatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodSandboxStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodSandboxStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &PodSandboxStatus{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Info == nil {
				m.Info = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipApi(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthApi
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Info[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainersStatuses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainersStatuses = append(m.ContainersStatuses, &ContainerStatus{})
			if err := m.ContainersStatuses[len(m.ContainersStatuses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			m.Timestamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timestamp |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PodSandboxStateValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodSandboxStateValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodSandboxStateValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= PodSandboxState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PodSandboxFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodSandboxFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodSandboxFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.State == nil {
				m.State = &PodSandboxStateValue{}
			}
			if err := m.State.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LabelSelector", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LabelSelector == nil {
				m.LabelSelector = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipApi(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthApi
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.LabelSelector[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListPodSandboxRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListPodSandboxRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListPodSandboxRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Filter == nil {
				m.Filter = &PodSandboxFilter{}
			}
			if err := m.Filter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PodSandbox) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodSandbox: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodSandbox: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &PodSandboxMetadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= PodSandboxState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			m.CreatedAt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CreatedAt |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipApi(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthApi
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Annotations == nil {
				m.Annotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipApi(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthApi
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Annotations[mapkey] = mapvalue
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeHandler", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeHandler = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListPodSandboxResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListPodSandboxResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListPodSandboxResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &PodSandbox{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PodSandboxStatsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodSandboxStatsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodSandboxStatsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodSandboxId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PodSandboxId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PodSandboxStatsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodSandboxStatsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodSandboxStatsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Stats == nil {
				m.Stats = &PodSandboxStats{}
			}
			if err := m.Stats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PodSandboxStatsFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodSandboxStatsFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodSandboxStatsFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LabelSelector", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LabelSelector == nil {
				m.LabelSelector = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipApi(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthApi
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.LabelSelector[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListPodSandboxStatsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListPodSandboxStatsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListPodSandboxStatsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Filter == nil {
				m.Filter = &PodSandboxStatsFilter{}
			}
			if err := m.Filter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListPodSandboxStatsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListPodSandboxStatsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListPodSandboxStatsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Stats = append(m.Stats, &PodSandboxStats{})
			if err := m.Stats[len(m.Stats)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PodSandboxAttributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodSandboxAttributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodSandboxAttributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &PodSandboxMetadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipApi(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthApi
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Annotations == nil {
				m.Annotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipApi(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthApi
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Annotations[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PodSandboxStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodSandboxStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodSandboxStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Attributes == nil {
				m.Attributes = &PodSandboxAttributes{}
			}
			if err := m.Attributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Linux", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Linux == nil {
				m.Linux = &LinuxPodSandboxStats{}
			}
			if err := m.Linux.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Windows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Windows == nil {
				m.Windows = &WindowsPodSandboxStats{}
			}
			if err := m.Windows.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxPodSandboxStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxPodSandboxStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxPodSandboxStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cpu", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Cpu == nil {
				m.Cpu = &CpuUsage{}
			}
			if err := m.Cpu.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Memory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Memory == nil {
				m.Memory = &MemoryUsage{}
			}
			if err := m.Memory.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Network", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Network == nil {
				m.Network = &NetworkUsage{}
			}
			if err := m.Network.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Process", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Process == nil {
				m.Process = &ProcessUsage{}
			}
			if err := m.Process.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Containers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Containers = append(m.Containers, &ContainerStats{})
			if err := m.Containers[len(m.Containers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowsPodSandboxStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WindowsPodSandboxStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WindowsPodSandboxStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cpu", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Cpu == nil {
				m.Cpu = &WindowsCpuUsage{}
			}
			if err := m.Cpu.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Memory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Memory == nil {
				m.Memory = &WindowsMemoryUsage{}
			}
			if err := m.Memory.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Network", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Network == nil {
				m.Network = &WindowsNetworkUsage{}
			}
			if err := m.Network.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Process", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Process == nil {
				m.Process = &WindowsProcessUsage{}
			}
			if err := m.Process.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Containers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Containers = append(m.Containers, &WindowsContainerStats{})
			if err := m.Containers[len(m.Containers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkUsage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkUsage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkUsage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			m.Timestamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timestamp |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultInterface", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DefaultInterface == nil {
				m.DefaultInterface = &NetworkInterfaceUsage{}
			}
			if err := m.DefaultInterface.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interfaces", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Interfaces = append(m.Interfaces, &NetworkInterfaceUsage{})
			if err := m.Interfaces[len(m.Interfaces)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowsNetworkUsage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WindowsNetworkUsage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WindowsNetworkUsage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			m.Timestamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timestamp |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultInterface", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DefaultInterface == nil {
				m.DefaultInterface = &WindowsNetworkInterfaceUsage{}
			}
			if err := m.DefaultInterface.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interfaces", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Interfaces = append(m.Interfaces, &WindowsNetworkInterfaceUsage{})
			if err := m.Interfaces[len(m.Interfaces)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkInterfaceUsage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkInterfaceUsage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkInterfaceUsage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RxBytes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RxBytes == nil {
				m.RxBytes = &UInt64Value{}
			}
			if err := m.RxBytes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RxErrors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RxErrors == nil {
				m.RxErrors = &UInt64Value{}
			}
			if err := m.RxErrors.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxBytes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TxBytes == nil {
				m.TxBytes = &UInt64Value{}
			}
			if err := m.TxBytes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxErrors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TxErrors == nil {
				m.TxErrors = &UInt64Value{}
			}
			if err := m.TxErrors.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowsNetworkInterfaceUsage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WindowsNetworkInterfaceUsage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WindowsNetworkInterfaceUsage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RxBytes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RxBytes == nil {
				m.RxBytes = &UInt64Value{}
			}
			if err := m.RxBytes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RxPacketsDropped", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RxPacketsDropped == nil {
				m.RxPacketsDropped = &UInt64Value{}
			}
			if err := m.RxPacketsDropped.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxBytes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TxBytes == nil {
				m.TxBytes = &UInt64Value{}
			}
			if err := m.TxBytes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxPacketsDropped", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TxPacketsDropped == nil {
				m.TxPacketsDropped = &UInt64Value{}
			}
			if err := m.TxPacketsDropped.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessUsage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessUsage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessUsage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			m.Timestamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timestamp |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessCount", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProcessCount == nil {
				m.ProcessCount = &UInt64Value{}
			}
			if err := m.ProcessCount.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowsProcessUsage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WindowsProcessUsage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WindowsProcessUsage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			m.Timestamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timestamp |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessCount", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProcessCount == nil {
				m.ProcessCount = &UInt64Value{}
			}
			if err := m.ProcessCount.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImageSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImageSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImageSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Image = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Annotations == nil {
				m.Annotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipApi(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthApi
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Annotations[mapkey] = mapvalue
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserSpecifiedImage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserSpecifiedImage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeHandler", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeHandler = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KeyValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxContainerResources) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxContainerResources: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxContainerResources: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpuPeriod", wireType)
			}
			m.CpuPeriod = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CpuPeriod |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpuQuota", wireType)
			}
			m.CpuQuota = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CpuQuota |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpuShares", wireType)
			}
			m.CpuShares = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CpuShares |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryLimitInBytes", wireType)
			}
			m.MemoryLimitInBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemoryLimitInBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OomScoreAdj", wireType)
			}
			m.OomScoreAdj = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OomScoreAdj |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpusetCpus", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CpusetCpus = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpusetMems", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CpusetMems = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HugepageLimits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HugepageLimits = append(m.HugepageLimits, &HugepageLimit{})
			if err := m.HugepageLimits[len(m.HugepageLimits)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unified", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Unified == nil {
				m.Unified = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipApi(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthApi
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Unified[mapkey] = mapvalue
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemorySwapLimitInBytes", wireType)
			}
			m.MemorySwapLimitInBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemorySwapLimitInBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HugepageLimit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HugepageLimit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HugepageLimit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PageSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PageSize = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SELinuxOption) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SELinuxOption: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SELinuxOption: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Role = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Level", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Level = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Capability) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Capability: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Capability: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddCapabilities", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AddCapabilities = append(m.AddCapabilities, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DropCapabilities", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DropCapabilities = append(m.DropCapabilities, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddAmbientCapabilities", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AddAmbientCapabilities = append(m.AddAmbientCapabilities, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxContainerSecurityContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxContainerSecurityContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxContainerSecurityContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Capabilities", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Capabilities == nil {
				m.Capabilities = &Capability{}
			}
			if err := m.Capabilities.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Privileged", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Privileged = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NamespaceOptions == nil {
				m.NamespaceOptions = &NamespaceOption{}
			}
			if err := m.NamespaceOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SelinuxOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SelinuxOptions == nil {
				m.SelinuxOptions = &SELinuxOption{}
			}
			if err := m.SelinuxOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunAsUser", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RunAsUser == nil {
				m.RunAsUser = &Int64Value{}
			}
			if err := m.RunAsUser.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunAsUsername", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunAsUsername = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadonlyRootfs", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReadonlyRootfs = bool(v != 0)
		case 8:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.SupplementalGroups = append(m.SupplementalGroups, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthApi
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthApi
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.SupplementalGroups) == 0 {
					m.SupplementalGroups = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.SupplementalGroups = append(m.SupplementalGroups, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field SupplementalGroups", wireType)
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApparmorProfile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApparmorProfile = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeccompProfilePath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SeccompProfilePath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoNewPrivs", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoNewPrivs = bool(v != 0)
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunAsGroup", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RunAsGroup == nil {
				m.RunAsGroup = &Int64Value{}
			}
			if err := m.RunAsGroup.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaskedPaths", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MaskedPaths = append(m.MaskedPaths, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadonlyPaths", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReadonlyPaths = append(m.ReadonlyPaths, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seccomp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Seccomp == nil {
				m.Seccomp = &SecurityProfile{}
			}
			if err := m.Seccomp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Apparmor", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Apparmor == nil {
				m.Apparmor = &SecurityProfile{}
			}
			if err := m.Apparmor.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SupplementalGroupsPolicy", wireType)
			}
			m.SupplementalGroupsPolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SupplementalGroupsPolicy |= SupplementalGroupsPolicy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxContainerConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxContainerConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxContainerConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resources == nil {
				m.Resources = &LinuxContainerResources{}
			}
			if err := m.Resources.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecurityContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SecurityContext == nil {
				m.SecurityContext = &LinuxContainerSecurityContext{}
			}
			if err := m.SecurityContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinuxContainerUser) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinuxContainerUser: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinuxContainerUser: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uid", wireType)
			}
			m.Uid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Uid |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gid", wireType)
			}
			m.Gid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Gid |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.SupplementalGroups = append(m.SupplementalGroups, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthApi
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthApi
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.SupplementalGroups) == 0 {
					m.SupplementalGroups = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.SupplementalGroups = append(m.SupplementalGroups, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field SupplementalGroups", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowsNamespaceOption) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WindowsNamespaceOption: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WindowsNamespaceOption: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Network", wireType)
			}
			m.Network = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Network |= NamespaceMode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowsSandboxSecurityContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WindowsSandboxSecurityContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WindowsSandboxSecurityContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunAsUsername", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunAsUsername = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CredentialSpec", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CredentialSpec = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostProcess", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HostProcess = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NamespaceOptions == nil {
				m.NamespaceOptions = &WindowsNamespaceOption{}
			}
			if err := m.NamespaceOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowsPodSandboxConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WindowsPodSandboxConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WindowsPodSandboxConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecurityContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SecurityContext == nil {
				m.SecurityContext = &WindowsSandboxSecurityContext{}
			}
			if err := m.SecurityContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowsContainerSecurityContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WindowsContainerSecurityContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WindowsContainerSecurityContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunAsUsername", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunAsUsername = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CredentialSpec", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CredentialSpec = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostProcess", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HostProcess = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowsContainerConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WindowsContainerConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WindowsContainerConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resources == nil {
				m.Resources = &WindowsContainerResources{}
			}
			if err := m.Resources.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecurityContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SecurityContext == nil {
				m.SecurityContext = &WindowsContainerSecurityContext{}
			}
			if err := m.SecurityContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WindowsContainerResources) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WindowsContainerResources: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WindowsContainerResources: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpuShares", wireType)
			}
			m.CpuShares = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CpuShares |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpuCount", wireType)
			}
			m.CpuCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CpuCount |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpuMaximum", wireType)
			}
			m.CpuMaximum = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CpuMaximum |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryLimitInBytes", wireType)
			}
			m.MemoryLimitInBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemoryLimitInBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RootfsSizeInBytes", wireType)
			}
			m.RootfsSizeInBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RootfsSizeInBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attempt", wireType)
			}
			m.Attempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Attempt |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Device) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Device: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Device: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Permissions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Permissions = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CDIDevice) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CDIDevice: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CDIDevice: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &ContainerMetadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Image == nil {
				m.Image = &ImageSpec{}
			}
			if err := m.Image.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Command = append(m.Command, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkingDir", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkingDir = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Envs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Envs = append(m.Envs, &KeyValue{})
			if err := m.Envs[len(m.Envs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mounts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Mounts = append(m.Mounts, &Mount{})
			if err := m.Mounts[len(m.Mounts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Devices", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Devices = append(m.Devices, &Device{})
			if err := m.Devices[len(m.Devices)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipApi(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthApi
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Annotations == nil {
				m.Annotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApi
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApi
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthApi
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipApi(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthApi
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Annotations[mapkey] = mapvalue
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LogPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stdin", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Stdin = bool(v != 0)
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StdinOnce", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StdinOnce = bool(v != 0)
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tty", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Tty = bool(v != 0)
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Linux", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Linux == nil {
				m.Linux = &LinuxContainerConfig{}
			}
			if err := m.Linux.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Windows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Windows == nil {
				m.Windows = &WindowsContainerConfig{}
			}
			if err := m.Windows.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CDIDevices", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CDIDevices = append(m.CDIDevices, &CDIDevice{})
			if err := m.CDIDevices[len(m.CDIDevices)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skipp