
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.


###################################################################
# WARNING!
#
# Do not edit this file directly. This file should be generated by
# running the command "tox -e genopts" any time a config option
# has been added, changed, or removed.
###################################################################

import itertools

from keystoneauth1 import loading

from cinder import objects  # noqa
objects.register_all()
from cinder.api import common as cinder_api_common
from cinder.api.middleware import auth as cinder_api_middleware_auth
import cinder.api.openstack
from cinder.api.views import versions as cinder_api_views_versions
from cinder.backup import api as cinder_backup_api
from cinder.backup import chunkeddriver as cinder_backup_chunkeddriver
from cinder.backup import driver as cinder_backup_driver
from cinder.backup.drivers import ceph as cinder_backup_drivers_ceph
from cinder.backup.drivers import gcs as cinder_backup_drivers_gcs
from cinder.backup.drivers import glusterfs as cinder_backup_drivers_glusterfs
from cinder.backup.drivers import nfs as cinder_backup_drivers_nfs
from cinder.backup.drivers import posix as cinder_backup_drivers_posix
from cinder.backup.drivers import s3 as cinder_backup_drivers_s3
from cinder.backup.drivers import swift as cinder_backup_drivers_swift
from cinder.backup import manager as cinder_backup_manager
from cinder.cmd import backup as cinder_cmd_backup
from cinder.cmd import volume as cinder_cmd_volume
from cinder.common import config as cinder_common_config
import cinder.compute
from cinder.compute import nova as cinder_compute_nova
from cinder import context as cinder_context
from cinder import coordination as cinder_coordination
from cinder.db import api as cinder_db_api
from cinder.image import glance as cinder_image_glance
from cinder.image import image_utils as cinder_image_imageutils
from cinder.keymgr import conf_key_mgr as cinder_keymgr_confkeymgr
from cinder.message import api as cinder_message_api
from cinder import quota as cinder_quota
from cinder.scheduler import driver as cinder_scheduler_driver
from cinder.scheduler import host_manager as cinder_scheduler_hostmanager
from cinder.scheduler import manager as cinder_scheduler_manager
from cinder.scheduler import scheduler_options as \
    cinder_scheduler_scheduleroptions
from cinder.scheduler.weights import capacity as \
    cinder_scheduler_weights_capacity
from cinder.scheduler.weights import volume_number as \
    cinder_scheduler_weights_volumenumber
from cinder import service as cinder_service
from cinder import service_auth as cinder_serviceauth
from cinder import ssh_utils as cinder_sshutils
from cinder.transfer import api as cinder_transfer_api
from cinder.volume import api as cinder_volume_api
from cinder.volume import driver as cinder_volume_driver
from cinder.volume.drivers.ceph import rbd_iscsi as \
    cinder_volume_drivers_ceph_rbdiscsi
from cinder.volume.drivers.datacore import driver as \
    cinder_volume_drivers_datacore_driver
from cinder.volume.drivers.datacore import fc as \
    cinder_volume_drivers_datacore_fc
from cinder.volume.drivers.datacore import iscsi as \
    cinder_volume_drivers_datacore_iscsi
from cinder.volume.drivers.datera import datera_iscsi as \
    cinder_volume_drivers_datera_dateraiscsi
from cinder.volume.drivers.dell_emc.powerflex import driver as \
    cinder_volume_drivers_dell_emc_powerflex_driver
from cinder.volume.drivers.dell_emc.powermax import common as \
    cinder_volume_drivers_dell_emc_powermax_common
from cinder.volume.drivers.dell_emc.powerstore import driver as \
    cinder_volume_drivers_dell_emc_powerstore_driver
from cinder.volume.drivers.dell_emc.powerstore import nfs as \
    cinder_volume_drivers_dell_emc_powerstore_nfs
from cinder.volume.drivers.dell_emc.powervault import common as \
    cinder_volume_drivers_dell_emc_powervault_common
from cinder.volume.drivers.dell_emc.sc import storagecenter_common as \
    cinder_volume_drivers_dell_emc_sc_storagecentercommon
from cinder.volume.drivers.dell_emc.unity import driver as \
    cinder_volume_drivers_dell_emc_unity_driver
from cinder.volume.drivers.dell_emc.vnx import common as \
    cinder_volume_drivers_dell_emc_vnx_common
from cinder.volume.drivers.dell_emc import xtremio as \
    cinder_volume_drivers_dell_emc_xtremio
from cinder.volume.drivers.fujitsu.eternus_dx import eternus_dx_common as \
    cinder_volume_drivers_fujitsu_eternus_dx_eternusdxcommon
from cinder.volume.drivers.fungible import driver as \
    cinder_volume_drivers_fungible_driver
from cinder.volume.drivers.fusionstorage import dsware as \
    cinder_volume_drivers_fusionstorage_dsware
from cinder.volume.drivers.hitachi import hbsd_common as \
    cinder_volume_drivers_hitachi_hbsdcommon
from cinder.volume.drivers.hitachi import hbsd_replication as \
    cinder_volume_drivers_hitachi_hbsdreplication
from cinder.volume.drivers.hitachi import hbsd_rest as \
    cinder_volume_drivers_hitachi_hbsdrest
from cinder.volume.drivers.hitachi import hbsd_rest_fc as \
    cinder_volume_drivers_hitachi_hbsdrestfc
from cinder.volume.drivers.hpe import hpe_3par_common as \
    cinder_volume_drivers_hpe_hpe3parcommon
from cinder.volume.drivers.hpe import nimble as \
    cinder_volume_drivers_hpe_nimble
from cinder.volume.drivers.hpe.xp import hpe_xp_rest as \
    cinder_volume_drivers_hpe_xp_hpexprest
from cinder.volume.drivers.huawei import common as \
    cinder_volume_drivers_huawei_common
from cinder.volume.drivers.ibm import flashsystem_common as \
    cinder_volume_drivers_ibm_flashsystemcommon
from cinder.volume.drivers.ibm import flashsystem_iscsi as \
    cinder_volume_drivers_ibm_flashsystemiscsi
from cinder.volume.drivers.ibm import gpfs as cinder_volume_drivers_ibm_gpfs
from cinder.volume.drivers.ibm.ibm_storage import ds8k_proxy as \
    cinder_volume_drivers_ibm_ibm_storage_ds8kproxy
from cinder.volume.drivers.ibm.ibm_storage import ibm_storage as \
    cinder_volume_drivers_ibm_ibm_storage_ibmstorage
from cinder.volume.drivers.ibm.storwize_svc import storwize_svc_common as \
    cinder_volume_drivers_ibm_storwize_svc_storwizesvccommon
from cinder.volume.drivers.ibm.storwize_svc import storwize_svc_fc as \
    cinder_volume_drivers_ibm_storwize_svc_storwizesvcfc
from cinder.volume.drivers.ibm.storwize_svc import storwize_svc_iscsi as \
    cinder_volume_drivers_ibm_storwize_svc_storwizesvciscsi
from cinder.volume.drivers import infinidat as cinder_volume_drivers_infinidat
from cinder.volume.drivers.infortrend.raidcmd_cli import common_cli as \
    cinder_volume_drivers_infortrend_raidcmd_cli_commoncli
from cinder.volume.drivers.inspur.as13000 import as13000_driver as \
    cinder_volume_drivers_inspur_as13000_as13000driver
from cinder.volume.drivers.inspur.instorage import instorage_common as \
    cinder_volume_drivers_inspur_instorage_instoragecommon
from cinder.volume.drivers.inspur.instorage import instorage_iscsi as \
    cinder_volume_drivers_inspur_instorage_instorageiscsi
from cinder.volume.drivers.kaminario import kaminario_common as \
    cinder_volume_drivers_kaminario_kaminariocommon
from cinder.volume.drivers.kioxia import kumoscale as \
    cinder_volume_drivers_kioxia_kumoscale
from cinder.volume.drivers.lenovo import lenovo_common as \
    cinder_volume_drivers_lenovo_lenovocommon
from cinder.volume.drivers import lightos as cinder_volume_drivers_lightos
from cinder.volume.drivers import linstordrv as \
    cinder_volume_drivers_linstordrv
from cinder.volume.drivers import lvm as cinder_volume_drivers_lvm
from cinder.volume.drivers.macrosan import driver as \
    cinder_volume_drivers_macrosan_driver
from cinder.volume.drivers.nec.v import nec_v_rest as \
    cinder_volume_drivers_nec_v_necvrest
from cinder.volume.drivers.netapp import options as \
    cinder_volume_drivers_netapp_options
from cinder.volume.drivers.nexenta import options as \
    cinder_volume_drivers_nexenta_options
from cinder.volume.drivers import nfs as cinder_volume_drivers_nfs
from cinder.volume.drivers.open_e import options as \
    cinder_volume_drivers_open_e_options
from cinder.volume.drivers.prophetstor import options as \
    cinder_volume_drivers_prophetstor_options
from cinder.volume.drivers import pure as cinder_volume_drivers_pure
from cinder.volume.drivers import qnap as cinder_volume_drivers_qnap
from cinder.volume.drivers import quobyte as cinder_volume_drivers_quobyte
from cinder.volume.drivers import rbd as cinder_volume_drivers_rbd
from cinder.volume.drivers import remotefs as cinder_volume_drivers_remotefs
from cinder.volume.drivers.san.hp import hpmsa_common as \
    cinder_volume_drivers_san_hp_hpmsacommon
from cinder.volume.drivers.san import san as cinder_volume_drivers_san_san
from cinder.volume.drivers.sandstone import sds_driver as \
    cinder_volume_drivers_sandstone_sdsdriver
from cinder.volume.drivers import solidfire as cinder_volume_drivers_solidfire
from cinder.volume.drivers import storpool as cinder_volume_drivers_storpool
from cinder.volume.drivers.stx import common as \
    cinder_volume_drivers_stx_common
from cinder.volume.drivers.synology import synology_common as \
    cinder_volume_drivers_synology_synologycommon
from cinder.volume.drivers.toyou.acs5000 import acs5000_common as \
    cinder_volume_drivers_toyou_acs5000_acs5000common
from cinder.volume.drivers.veritas_access import veritas_iscsi as \
    cinder_volume_drivers_veritas_access_veritasiscsi
from cinder.volume.drivers.vmware import vmdk as \
    cinder_volume_drivers_vmware_vmdk
from cinder.volume.drivers import vzstorage as cinder_volume_drivers_vzstorage
from cinder.volume.drivers.windows import iscsi as \
    cinder_volume_drivers_windows_iscsi
from cinder.volume.drivers.windows import smbfs as \
    cinder_volume_drivers_windows_smbfs
from cinder.volume.drivers.yadro import tatlin_common as \
    cinder_volume_drivers_yadro_tatlincommon
from cinder.volume.drivers.zadara import zadara as \
    cinder_volume_drivers_zadara_zadara
from cinder.volume import manager as cinder_volume_manager
from cinder.volume.targets import spdknvmf as cinder_volume_targets_spdknvmf
from cinder.wsgi import eventlet_server as cinder_wsgi_eventletserver
from cinder.zonemanager.drivers.brocade import brcd_fabric_opts as \
    cinder_zonemanager_drivers_brocade_brcdfabricopts
from cinder.zonemanager.drivers.brocade import brcd_fc_zone_driver as \
    cinder_zonemanager_drivers_brocade_brcdfczonedriver
from cinder.zonemanager.drivers.cisco import cisco_fabric_opts as \
    cinder_zonemanager_drivers_cisco_ciscofabricopts
from cinder.zonemanager.drivers.cisco import cisco_fc_zone_driver as \
    cinder_zonemanager_drivers_cisco_ciscofczonedriver
from cinder.zonemanager import fc_zone_manager as \
    cinder_zonemanager_fczonemanager


def list_opts():
    return [
        ('backend',
            itertools.chain(
                [cinder_cmd_volume.host_opt],
            )),
        ('brcd_fabric_example',
            itertools.chain(
                cinder_zonemanager_drivers_brocade_brcdfabricopts.
                brcd_zone_opts,
            )),
        ('cisco_fabric_example',
            itertools.chain(
                cinder_zonemanager_drivers_cisco_ciscofabricopts.
                cisco_zone_opts,
            )),
        ('coordination',
            itertools.chain(
                cinder_coordination.coordination_opts,
            )),
        ('DEFAULT',
            itertools.chain(
                cinder_api_common.api_common_opts,
                [cinder_api_middleware_auth.use_forwarded_for_opt],
                cinder.api.openstack.openstack_api_opts,
                cinder_api_views_versions.versions_opts,
                cinder_backup_api.backup_opts,
                cinder_backup_chunkeddriver.backup_opts,
                cinder_backup_driver.backup_opts,
                cinder_backup_drivers_ceph.service_opts,
                cinder_backup_drivers_gcs.gcsbackup_service_opts,
                cinder_backup_drivers_glusterfs.glusterfsbackup_service_opts,
                cinder_backup_drivers_nfs.nfsbackup_service_opts,
                cinder_backup_drivers_posix.posixbackup_service_opts,
                cinder_backup_drivers_s3.s3backup_service_opts,
                cinder_backup_drivers_swift.swiftbackup_service_opts,
                cinder_backup_manager.backup_manager_opts,
                cinder_cmd_backup.backup_cmd_opts,
                [cinder_cmd_volume.cluster_opt],
                cinder_common_config.api_opts,
                cinder_common_config.core_opts,
                cinder_common_config.auth_opts,
                cinder_common_config.backup_opts,
                cinder_common_config.image_opts,
                cinder_common_config.global_opts,
                cinder_common_config.compression_opts,
                cinder.compute.compute_opts,
                cinder_context.context_opts,
                cinder_db_api.db_opts,
                cinder_db_api.backup_opts,
                cinder_image_glance.image_opts,
                cinder_image_glance.glance_core_properties_opts,
                cinder_image_imageutils.image_opts,
                cinder_message_api.messages_opts,
                cinder_quota.quota_opts,
                cinder_scheduler_driver.scheduler_driver_opts,
                cinder_scheduler_hostmanager.host_manager_opts,
                cinder_scheduler_manager.scheduler_manager_opts,
                [cinder_scheduler_scheduleroptions.
                    scheduler_json_config_location_opt],
                cinder_scheduler_weights_capacity.capacity_weight_opts,
                cinder_scheduler_weights_volumenumber.
                volume_number_weight_opts,
                cinder_service.service_opts,
                cinder_sshutils.ssh_opts,
                cinder_transfer_api.volume_transfer_opts,
                [cinder_volume_api.allow_force_upload_opt],
                [cinder_volume_api.volume_host_opt],
                [cinder_volume_api.volume_same_az_opt],
                [cinder_volume_api.az_cache_time_opt],
                cinder_volume_driver.volume_opts,
                cinder_volume_driver.iser_opts,
                cinder_volume_driver.nvmeof_opts,
                cinder_volume_driver.nvmet_opts,
                cinder_volume_driver.scst_opts,
                cinder_volume_driver.backup_opts,
                cinder_volume_driver.image_opts,
                cinder_volume_drivers_datera_dateraiscsi.d_opts,
                cinder_volume_drivers_fungible_driver.fungible_opts,
                cinder_volume_drivers_fusionstorage_dsware.volume_opts,
                cinder_volume_drivers_hitachi_hbsdreplication._REP_OPTS,
                cinder_volume_drivers_hitachi_hbsdreplication.
                COMMON_MIRROR_OPTS,
                cinder_volume_drivers_hitachi_hbsdreplication.
                ISCSI_MIRROR_OPTS,
                cinder_volume_drivers_hitachi_hbsdreplication.
                REST_MIRROR_OPTS,
                cinder_volume_drivers_hitachi_hbsdreplication.
                REST_MIRROR_API_OPTS,
                cinder_volume_drivers_hitachi_hbsdreplication.
                REST_MIRROR_SSL_OPTS,
                cinder_volume_drivers_infortrend_raidcmd_cli_commoncli.
                infortrend_opts,
                cinder_volume_drivers_inspur_as13000_as13000driver.
                inspur_as13000_opts,
                cinder_volume_drivers_inspur_instorage_instoragecommon.
                instorage_mcs_opts,
                cinder_volume_drivers_inspur_instorage_instorageiscsi.
                instorage_mcs_iscsi_opts,
                cinder_volume_drivers_kioxia_kumoscale.KUMOSCALE_OPTS,
                cinder_volume_drivers_open_e_options.jdss_connection_opts,
                cinder_volume_drivers_open_e_options.jdss_iscsi_opts,
                cinder_volume_drivers_open_e_options.jdss_volume_opts,
                cinder_volume_drivers_sandstone_sdsdriver.sds_opts,
                cinder_volume_drivers_toyou_acs5000_acs5000common.
                acs5000c_opts,
                cinder_volume_drivers_veritas_access_veritasiscsi.VA_VOL_OPTS,
                cinder_volume_manager.volume_manager_opts,
                cinder_wsgi_eventletserver.socket_opts,
            )),
        ('fc-zone-manager',
            itertools.chain(
                cinder_zonemanager_drivers_brocade_brcdfczonedriver.brcd_opts,
                cinder_zonemanager_drivers_cisco_ciscofczonedriver.cisco_opts,
                cinder_zonemanager_fczonemanager.zone_manager_opts,
            )),
        ('key_manager',
            itertools.chain(
                cinder_keymgr_confkeymgr.key_mgr_opts,
            )),
        ('service_user',
            itertools.chain(
                cinder_serviceauth.service_user_opts,
                loading.get_auth_plugin_conf_options('v3password'),
                loading.get_session_conf_options(),
            )),
        ('backend_defaults',
            itertools.chain(
                cinder_volume_driver.volume_opts,
                cinder_volume_driver.iser_opts,
                cinder_volume_driver.nvmeof_opts,
                cinder_volume_driver.nvmet_opts,
                cinder_volume_driver.scst_opts,
                cinder_volume_driver.image_opts,
                cinder_volume_driver.fqdn_opts,
                cinder_volume_drivers_ceph_rbdiscsi.RBD_ISCSI_OPTS,
                cinder_volume_drivers_datacore_driver.datacore_opts,
                cinder_volume_drivers_datacore_fc.datacore_fc_opts,
                cinder_volume_drivers_datacore_iscsi.datacore_iscsi_opts,
                cinder_volume_drivers_dell_emc_powerflex_driver.
                powerflex_opts,
                cinder_volume_drivers_dell_emc_powermax_common.powermax_opts,
                cinder_volume_drivers_dell_emc_powerstore_driver.
                POWERSTORE_OPTS,
                cinder_volume_drivers_dell_emc_powerstore_nfs.nfs_opts,
                cinder_volume_drivers_dell_emc_powervault_common.common_opts,
                cinder_volume_drivers_dell_emc_powervault_common.iscsi_opts,
                cinder_volume_drivers_dell_emc_sc_storagecentercommon.
                common_opts,
                cinder_volume_drivers_dell_emc_unity_driver.UNITY_OPTS,
                cinder_volume_drivers_dell_emc_vnx_common.VNX_OPTS,
                cinder_volume_drivers_dell_emc_xtremio.XTREMIO_OPTS,
                cinder_volume_drivers_fujitsu_eternus_dx_eternusdxcommon.
                FJ_ETERNUS_DX_OPT_opts,
                cinder_volume_drivers_hitachi_hbsdcommon.COMMON_VOLUME_OPTS,
                cinder_volume_drivers_hitachi_hbsdcommon.COMMON_PORT_OPTS,
                cinder_volume_drivers_hitachi_hbsdcommon.COMMON_PAIR_OPTS,
                cinder_volume_drivers_hitachi_hbsdcommon.COMMON_NAME_OPTS,
                cinder_volume_drivers_hitachi_hbsdrest.REST_VOLUME_OPTS,
                cinder_volume_drivers_hitachi_hbsdrest.REST_PAIR_OPTS,
                cinder_volume_drivers_hitachi_hbsdrestfc.FC_VOLUME_OPTS,
                cinder_volume_drivers_hpe_hpe3parcommon.hpe3par_opts,
                cinder_volume_drivers_hpe_nimble.nimble_opts,
                cinder_volume_drivers_hpe_xp_hpexprest.COMMON_VOLUME_OPTS,
                cinder_volume_drivers_hpe_xp_hpexprest.REST_VOLUME_OPTS,
                cinder_volume_drivers_hpe_xp_hpexprest.FC_VOLUME_OPTS,
                cinder_volume_drivers_huawei_common.huawei_opts,
                cinder_volume_drivers_ibm_flashsystemcommon.flashsystem_opts,
                cinder_volume_drivers_ibm_flashsystemiscsi.
                flashsystem_iscsi_opts,
                cinder_volume_drivers_ibm_gpfs.gpfs_opts,
                cinder_volume_drivers_ibm_gpfs.gpfs_remote_ssh_opts,
                cinder_volume_drivers_ibm_ibm_storage_ds8kproxy.ds8k_opts,
                cinder_volume_drivers_ibm_ibm_storage_ibmstorage.driver_opts,
                cinder_volume_drivers_ibm_storwize_svc_storwizesvccommon.
                storwize_svc_opts,
                cinder_volume_drivers_ibm_storwize_svc_storwizesvcfc.
                storwize_svc_fc_opts,
                cinder_volume_drivers_ibm_storwize_svc_storwizesvciscsi.
                storwize_svc_iscsi_opts,
                cinder_volume_drivers_infinidat.infinidat_opts,
                cinder_volume_drivers_kaminario_kaminariocommon.
                kaminario_opts,
                cinder_volume_drivers_lenovo_lenovocommon.common_opts,
                cinder_volume_drivers_lenovo_lenovocommon.iscsi_opts,
                cinder_volume_drivers_lightos.lightos_opts,
                cinder_volume_drivers_linstordrv.linstor_opts,
                cinder_volume_drivers_lvm.volume_opts,
                cinder_volume_drivers_macrosan_driver.config.macrosan_opts,
                cinder_volume_drivers_nec_v_necvrest.COMMON_VOLUME_OPTS,
                cinder_volume_drivers_nec_v_necvrest.REST_VOLUME_OPTS,
                cinder_volume_drivers_nec_v_necvrest.FC_VOLUME_OPTS,
                cinder_volume_drivers_netapp_options.netapp_proxy_opts,
                cinder_volume_drivers_netapp_options.netapp_connection_opts,
                cinder_volume_drivers_netapp_options.netapp_transport_opts,
                cinder_volume_drivers_netapp_options.netapp_basicauth_opts,
                cinder_volume_drivers_netapp_options.netapp_cluster_opts,
                cinder_volume_drivers_netapp_options.netapp_provisioning_opts,
                cinder_volume_drivers_netapp_options.netapp_img_cache_opts,
                cinder_volume_drivers_netapp_options.netapp_nfs_extra_opts,
                cinder_volume_drivers_netapp_options.netapp_san_opts,
                cinder_volume_drivers_netapp_options.netapp_replication_opts,
                cinder_volume_drivers_netapp_options.netapp_support_opts,
                cinder_volume_drivers_netapp_options.netapp_migration_opts,
                cinder_volume_drivers_nexenta_options.NEXENTA_CONNECTION_OPTS,
                cinder_volume_drivers_nexenta_options.NEXENTA_ISCSI_OPTS,
                cinder_volume_drivers_nexenta_options.NEXENTA_DATASET_OPTS,
                cinder_volume_drivers_nexenta_options.NEXENTA_NFS_OPTS,
                cinder_volume_drivers_nexenta_options.NEXENTA_RRMGR_OPTS,
                cinder_volume_drivers_nexenta_options.NEXENTA_EDGE_OPTS,
                cinder_volume_drivers_nfs.nfs_opts,
                cinder_volume_drivers_prophetstor_options.DPL_OPTS,
                cinder_volume_drivers_pure.PURE_OPTS,
                cinder_volume_drivers_qnap.qnap_opts,
                cinder_volume_drivers_quobyte.volume_opts,
                cinder_volume_drivers_rbd.RBD_OPTS,
                cinder_volume_drivers_remotefs.nas_opts,
                cinder_volume_drivers_remotefs.volume_opts,
                cinder_volume_drivers_san_hp_hpmsacommon.common_opts,
                cinder_volume_drivers_san_hp_hpmsacommon.iscsi_opts,
                cinder_volume_drivers_san_san.san_opts,
                cinder_volume_drivers_solidfire.sf_opts,
                cinder_volume_drivers_storpool.storpool_opts,
                cinder_volume_drivers_stx_common.common_opts,
                cinder_volume_drivers_stx_common.iscsi_opts,
                cinder_volume_drivers_synology_synologycommon.cinder_opts,
                cinder_volume_drivers_vmware_vmdk.vmdk_opts,
                cinder_volume_drivers_vzstorage.vzstorage_opts,
                cinder_volume_drivers_windows_iscsi.windows_opts,
                cinder_volume_drivers_windows_smbfs.volume_opts,
                cinder_volume_drivers_yadro_tatlincommon.tatlin_opts,
                cinder_volume_drivers_zadara_zadara.common.zadara_opts,
                cinder_volume_manager.volume_backend_opts,
                cinder_volume_targets_spdknvmf.spdk_opts,
            )),
        ('nova',
            itertools.chain(
                cinder_compute_nova.nova_opts,
                cinder_compute_nova.nova_session_opts,
                cinder_compute_nova.nova_auth_opts,
            )),
    ]
