from bzrlib import errors
from bzrlib.branch import Branch
from bzrlib.config import extract_email_address
from bzrtools import short_committer
def branch_history(branch):
    """Print history of a branch"""
    b = Branch.open_containing(branch)[0]
    descriptor = None
    start = None
    b.repository.lock_read()
    try:
        for revno, revision in iter_revisiondata(b):
            new_descriptor = (revision.committer,
                              revision.properties.get('branch-nick'))
            if descriptor is None:
                descriptor = new_descriptor
            if start is None:
                start = revno
            if branch_change(descriptor, new_descriptor):
                print_info(descriptor, start, revno - 1)
                start = revno
            descriptor = new_descriptor
        print_info(descriptor, start, revno)
    finally:
        b.repository.unlock()

def branch_change(old_descriptor, new_descriptor):
    try:
        old_email = extract_email_address(old_descriptor[0])
    except errors.NoEmailInUsername:
        old_email = None
    try:
        new_email = extract_email_address(new_descriptor[0])
    except errors.NoEmailInUsername:
        new_email = None
    if old_descriptor == new_descriptor:
        return False
    elif None not in (old_descriptor[1], new_descriptor[1]) and \
        old_descriptor[1] != new_descriptor[1]:
        return True
    elif short_committer(old_descriptor[0]) ==\
        short_committer(new_descriptor[0]):
        return False
    elif old_descriptor[0].strip(' ') == new_email:
        return False
    elif new_descriptor[0].strip(' ') == old_email:
        return False
    else:
        return True

def iter_revisiondata(branch):
    """Iterate through revno, Revision pairs in the revision history"""
    for no, revision_id in enumerate(branch.revision_history()):
        yield no+1, branch.repository.get_revision(revision_id)

def print_info(descriptor, start, end):
    """Print revision history"""
    descriptor_string = descriptor[0]
    if descriptor[1] is not None:
        descriptor_string += " / "+ descriptor[1]
    print descriptor_string
    if start != end:
        print "  %d .. %d" % (start, end)
    else:
        print "  %d" % start
