package ONVIF::Device::Types::VideoAnalyticsStream;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Frame_of :ATTR(:get<Frame>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Frame
        Extension

    ) ],
    {
        'Frame' => \%Frame_of,
        'Extension' => \%Extension_of,
    },
    {
        'Frame' => 'ONVIF::Device::Types::Frame',
        'Extension' => 'ONVIF::Device::Types::VideoAnalyticsStreamExtension',
    },
    {

        'Frame' => 'Frame',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::VideoAnalyticsStream

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
VideoAnalyticsStream from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Frame


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::VideoAnalyticsStream
   # One of the following elements.
   # No occurance checks yet, so be sure to pass just one...
   Frame =>  { # ONVIF::Device::Types::Frame
     PTZStatus =>  { # ONVIF::Device::Types::PTZStatus
       Position =>  { # ONVIF::Device::Types::PTZVector
         PanTilt => ,
         Zoom => ,
       },
       MoveStatus =>  { # ONVIF::Device::Types::PTZMoveStatus
         PanTilt => $some_value, # MoveStatus
         Zoom => $some_value, # MoveStatus
       },
       Error =>  $some_value, # string
       UtcTime =>  $some_value, # dateTime
     },
     Transformation =>  { # ONVIF::Device::Types::Transformation
       Translate => ,
       Scale => ,
       Extension =>  { # ONVIF::Device::Types::TransformationExtension
       },
     },
     Object =>  { # ONVIF::Device::Types::Object
       Appearance =>  { # ONVIF::Device::Types::Appearance
         Transformation =>  { # ONVIF::Device::Types::Transformation
           Translate => ,
           Scale => ,
           Extension =>  { # ONVIF::Device::Types::TransformationExtension
           },
         },
         Shape =>  { # ONVIF::Device::Types::ShapeDescriptor
           BoundingBox => ,
           CenterOfGravity => ,
           Polygon =>  { # ONVIF::Device::Types::Polygon
             Point => ,
           },
           Extension =>  { # ONVIF::Device::Types::ShapeDescriptorExtension
           },
         },
         Color =>  { # ONVIF::Device::Types::ColorDescriptor
           ColorCluster =>  {
             Color => ,
             Weight =>  $some_value, # float
             Covariance => ,
           },
           Extension =>  { # ONVIF::Device::Types::ColorDescriptorExtension
           },
         },
         Class =>  { # ONVIF::Device::Types::ClassDescriptor
           ClassCandidate =>  {
             Type => $some_value, # ClassType
             Likelihood =>  $some_value, # float
           },
           Extension =>  { # ONVIF::Device::Types::ClassDescriptorExtension
             OtherTypes =>  { # ONVIF::Device::Types::OtherType
               Type =>  $some_value, # string
               Likelihood =>  $some_value, # float
             },
             Extension =>  { # ONVIF::Device::Types::ClassDescriptorExtension2
             },
           },
         },
         Extension =>  { # ONVIF::Device::Types::AppearanceExtension
         },
       },
       Behaviour =>  { # ONVIF::Device::Types::Behaviour
         Removed =>  {
         },
         Idle =>  {
         },
         Extension =>  { # ONVIF::Device::Types::BehaviourExtension
         },
       },
       Extension =>  { # ONVIF::Device::Types::ObjectExtension
       },
     },
     ObjectTree =>  { # ONVIF::Device::Types::ObjectTree
       Rename =>  { # ONVIF::Device::Types::Rename
         from => ,
         to => ,
       },
       Split =>  { # ONVIF::Device::Types::Split
         from => ,
         to => ,
       },
       Merge =>  { # ONVIF::Device::Types::Merge
         from => ,
         to => ,
       },
       Delete => ,
       Extension =>  { # ONVIF::Device::Types::ObjectTreeExtension
       },
     },
     Extension =>  { # ONVIF::Device::Types::FrameExtension
       MotionInCells =>  { # ONVIF::Device::Types::MotionInCells
       },
       Extension =>  { # ONVIF::Device::Types::FrameExtension2
       },
     },
   },
   Extension =>  { # ONVIF::Device::Types::VideoAnalyticsStreamExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

