/****************************************************************************

    CtrlTableDelegate Class
    Copyright (C) 2009 Andre Deperrois 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*****************************************************************************/



#include <QApplication>


#include "ctrltabledelegate.h"
#include <misc/text/doubleedit.h>


CtrlTableDelegate::CtrlTableDelegate(QObject *parent)
 : QItemDelegate(parent)
{
}


QWidget *CtrlTableDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &, const QModelIndex & index ) const
{
    if(index.column()==0)
    {
/*        QLineEdit *editor = new QLineEdit(parent);
        editor->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
        return editor;*/
    }
    else if(index.column()==1 || index.column()==2)
    {
        DoubleEdit *editor = new DoubleEdit(parent);
        editor->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
        editor->setPrecision(m_Precision[index.column()]);
        return editor;
    }
    else if(index.column()==3)
    {
/*        QLineEdit *editor = new QLineEdit(parent);
        editor->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
        return editor;*/
    }

    return nullptr;
}


void CtrlTableDelegate::setEditorData(QWidget *editor, const QModelIndex &index) const
{
    if(index.column()==0)
    {
        QString strong = index.model()->data(index, Qt::EditRole).toString();
        QLineEdit *lineEdit = (QLineEdit*)editor;
        lineEdit->setText(strong);
    }
    else if(index.column()==1 || index.column()==2)
    {
        double value = index.model()->data(index, Qt::EditRole).toDouble();
        DoubleEdit *pDE = static_cast<DoubleEdit*>(editor);
        pDE->setValue(value);
    }
    else if(index.column()==3)
    {
        QString strong = index.model()->data(index, Qt::EditRole).toString();
        QLineEdit *lineEdit = (QLineEdit*)editor;
        lineEdit->setText(strong);
    }
}


void CtrlTableDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
{
    if(index.column()==0)
    {
/*        QString strong;
        QLineEdit *pLineEdit = static_cast<QLineEdit*>(editor);
        strong = pLineEdit->text();
        model->setData(index, strong, Qt::EditRole);*/
    }
    else if(index.column()==1 || index.column()==2)
    {
        DoubleEdit *pDE = static_cast<DoubleEdit*>(editor);
        double value = pDE->value();
        model->setData(index, value, Qt::EditRole);
    }
    else if(index.column()==3)
    {
/*        QString strong;
        QLineEdit *pLineEdit = static_cast<QLineEdit*>(editor);
        strong = pLineEdit->text();
        model->setData(index, strong, Qt::EditRole);*/
    }
}
 

void CtrlTableDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    QString strong;
//    int NCtrls = 2;
    QStyleOptionViewItem myOption = option;
//    QMiarex *pMiarex = (QMiarex*)s_pMiarex;
//    NCtrls = pMiarex->m_poaCtrl->size();

/*    if(index.row()> NCtrls)
    {
        strong=" ";
        drawDisplay(painter, myOption, myOption.rect, strong);
        drawFocus(painter, myOption, myOption.rect);
    }
    else */
    if(index.column()==0)
    {
        myOption.displayAlignment = Qt::AlignLeft | Qt::AlignVCenter;
        strong = index.model()->data(index, Qt::DisplayRole).toString();
        drawDisplay(painter, myOption, myOption.rect, strong);
        drawFocus(painter, myOption, myOption.rect);
    }
    else if(index.column()==1 || index.column()==2)
    {
        myOption.displayAlignment = Qt::AlignRight | Qt::AlignVCenter;
        strong = QString("%1").arg(index.model()->data(index, Qt::DisplayRole).toDouble(), 0,'f',m_Precision[index.column()]);
        drawDisplay(painter, myOption, myOption.rect, strong);
        drawFocus(painter, myOption, myOption.rect);
    }
    else if(index.column()==3)
    {
        myOption.displayAlignment = Qt::AlignLeft | Qt::AlignVCenter;
        strong = index.model()->data(index, Qt::DisplayRole).toString();
        drawDisplay(painter, myOption, myOption.rect, strong);
        drawFocus(painter, myOption, myOption.rect);
    }
}


void CtrlTableDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &/* index */) const
{
    editor->setGeometry(option.rect);
}


void CtrlTableDelegate::drawCheck(QPainter *painter, const QStyleOptionViewItem &option, const QRect &, Qt::CheckState state) const
{
    const int textMargin = QApplication::style()->pixelMetric(QStyle::PM_FocusFrameHMargin) + 1;

    QRect checkRect = QStyle::alignedRect(option.direction, Qt::AlignCenter,
                                          option.rect.size(),
                                          QRect(option.rect.x() + textMargin, option.rect.y(),
                                                option.rect.width() - (textMargin * 2), option.rect.height()));

    QItemDelegate::drawCheck(painter, option, checkRect, state);
}




bool CtrlTableDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option,
                         const QModelIndex &index)
{
    // make sure that the item is checkable
    Qt::ItemFlags flags = model->flags(index);
    if (!(flags & Qt::ItemIsUserCheckable) || !(flags & Qt::ItemIsEnabled))
        return false;

    // make sure that we have a check state
    QVariant value = index.data(Qt::CheckStateRole);
    if (!value.isValid())
        return false;

    // make sure that we have the right event type
    if (event->type() == QEvent::MouseButtonRelease)
    {
        const int textMargin = QApplication::style()->pixelMetric(QStyle::PM_FocusFrameHMargin) + 1;
        QRect checkRect = QStyle::alignedRect(option.direction, Qt::AlignCenter,
                                              option.rect.size(),
                                              QRect(option.rect.x() + textMargin, option.rect.y(),
                                                    option.rect.width() - (2 * textMargin), option.rect.height()));

        if (!checkRect.contains(static_cast<QMouseEvent*>(event)->pos())) return false;
    }
    else if (event->type() == QEvent::KeyPress)
    {
        if (   static_cast<QKeyEvent*>(event)->key() != Qt::Key_Space
            && static_cast<QKeyEvent*>(event)->key() != Qt::Key_Select)
            return false;
    }
    else
    {
        return false;
    }

    Qt::CheckState state = (static_cast<Qt::CheckState>(value.toInt()) == Qt::Checked
                        ? Qt::Unchecked : Qt::Checked);
    return model->setData(index, state, Qt::CheckStateRole);
}
