## Good Habit Checklist for Issue Reporting
Checkout [Mastering Markdown · GitHub Guides](https://guides.github.com/features/mastering-markdown/#GitHub-flavored-markdown) if you needs help on the GitHub-flavored Markdown syntax.  You may remove sections and contents that don't apply.

* [ ] I've searched the issue tracker and is pretty sure that there's no duplicate issue already filed
* [ ] I've built the latest development snapshot using the instructions in README and verified that the issue can still be reproduced (for bug reports)

## Issue Reproduce Instructions
> 1. Launch WoeUSB by running `<command>`
> 2. Do blablabla...

## Expected Behavior
> No error

## Current Behavior
> WoeUSB errors with message "blablabla"

## Info of My Environment
### WoeUSB Version
> For source code build, run `git describe --tags --always --dirty` under the source tree, for prebuilt releases refer the source that provides WoeUSB

### WoeUSB Source
> Built from source code, commit abcdefg
> Installed from Ubuntu 16.04 software archive
> Installed from WebUpd8 PPA

### GNU Bash Version
> WoeUSB exploits several advanced features of the Bash scripting language and requires a relatively-recent Bash intepreter.  Run `bash --version` in a terminal to acquire this information.

### Information about the Operating System
> Different OS distributions provides different characteristics and may influence the result of running WoeUSB.  Run `lsb_release --description` or `lsb_release -d` in a terminal to acquire this information.

### Information about the Source Media
> "Windows 9 Professional Edition" downloaded from <https://microsoft.com/download/windows-9>

### Information about the Target Device
> Transcend JetFlash® 790K 64GB (USB 3.1 variant) 
