/*
 * This source file is part of libRocket, the HTML/CSS Interface Middleware
 *
 * For the latest information, see http://www.librocket.com
 *
 * Copyright (c) 2008-2010 CodePoint Ltd, Shift Technology Ltd
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */

#ifndef ROCKETCORESTRINGCACHE_H
#define ROCKETCORESTRINGCACHE_H

#include "../../Include/Rocket/Core/String.h"

namespace Rocket {
namespace Core {

extern const String MARGIN_TOP;
extern const String MARGIN_RIGHT;
extern const String MARGIN_BOTTOM;
extern const String MARGIN_LEFT;
extern const String MARGIN;
extern const String PADDING_TOP;
extern const String PADDING_RIGHT;
extern const String PADDING_BOTTOM;
extern const String PADDING_LEFT;
extern const String PADDING;
extern const String BORDER_TOP_WIDTH;
extern const String BORDER_RIGHT_WIDTH;
extern const String BORDER_BOTTOM_WIDTH;
extern const String BORDER_LEFT_WIDTH;
extern const String BORDER_WIDTH;
extern const String BORDER_TOP_COLOR;
extern const String BORDER_RIGHT_COLOR;
extern const String BORDER_BOTTOM_COLOR;
extern const String BORDER_LEFT_COLOR;
extern const String BORDER_COLOR;
extern const String BORDER_TOP;
extern const String BORDER_RIGHT;
extern const String BORDER_BOTTOM;
extern const String BORDER_LEFT;
extern const String DISPLAY;
extern const String POSITION;
extern const String TOP;
extern const String RIGHT;
extern const String BOTTOM;
extern const String LEFT;
extern const String FLOAT;
extern const String CLEAR;
extern const String Z_INDEX;
extern const String WIDTH;
extern const String MIN_WIDTH;
extern const String MAX_WIDTH;
extern const String HEIGHT;
extern const String MIN_HEIGHT;
extern const String MAX_HEIGHT;
extern const String LINE_HEIGHT;
extern const String VERTICAL_ALIGN;
extern const String OVERFLOW_X;
extern const String OVERFLOW_Y;
extern const String CLIP;
extern const String VISIBILITY;
extern const String BACKGROUND_COLOR;
extern const String BACKGROUND;
extern const String COLOR;
extern const String FONT_FAMILY;
extern const String FONT_CHARSET;
extern const String FONT_STYLE;
extern const String FONT_WEIGHT;
extern const String FONT_SIZE;
extern const String FONT;
extern const String TEXT_ALIGN;
extern const String TEXT_DECORATION;
extern const String TEXT_TRANSFORM;
extern const String WHITE_SPACE;
extern const String CURSOR;
extern const String DRAG;
extern const String TAB_INDEX;
extern const String SCROLLBAR_MARGIN;

extern const String MOUSEDOWN;
extern const String MOUSESCROLL;
extern const String MOUSEOVER;
extern const String MOUSEOUT;
extern const String FOCUS;
extern const String BLUR;
extern const String KEYDOWN;
extern const String MOUSEUP;
extern const String CLICK;
extern const String DRAGSTART;
extern const String LOAD;
extern const String UNLOAD;
extern const String KEYUP;
extern const String TEXTINPUT;
extern const String MOUSEMOVE;
extern const String DRAGMOVE;
extern const String DBLCLICK;
extern const String DRAGDROP;
extern const String DRAGOUT;
extern const String DRAGEND;
extern const String DRAGOVER;
extern const String RESIZE;

}
}

#endif
