/*

    OpenGL loader generated by glad 0.1.12a0 on Mon Sep 12 03:10:20 2016.

    Language/Generator: C/C++
    Specification: gl
    APIs: gl=4.5
    Profile: core
    Extensions:
        GL_3DFX_multisample,
        GL_3DFX_tbuffer,
        GL_3DFX_texture_compression_FXT1,
        GL_AMD_blend_minmax_factor,
        GL_AMD_conservative_depth,
        GL_AMD_debug_output,
        GL_AMD_depth_clamp_separate,
        GL_AMD_draw_buffers_blend,
        GL_AMD_gcn_shader,
        GL_AMD_gpu_shader_int64,
        GL_AMD_interleaved_elements,
        GL_AMD_multi_draw_indirect,
        GL_AMD_name_gen_delete,
        GL_AMD_occlusion_query_event,
        GL_AMD_performance_monitor,
        GL_AMD_pinned_memory,
        GL_AMD_query_buffer_object,
        GL_AMD_sample_positions,
        GL_AMD_seamless_cubemap_per_texture,
        GL_AMD_shader_atomic_counter_ops,
        GL_AMD_shader_explicit_vertex_parameter,
        GL_AMD_shader_stencil_export,
        GL_AMD_shader_trinary_minmax,
        GL_AMD_sparse_texture,
        GL_AMD_stencil_operation_extended,
        GL_AMD_texture_texture4,
        GL_AMD_transform_feedback3_lines_triangles,
        GL_AMD_transform_feedback4,
        GL_AMD_vertex_shader_layer,
        GL_AMD_vertex_shader_tessellator,
        GL_AMD_vertex_shader_viewport_index,
        GL_APPLE_aux_depth_stencil,
        GL_APPLE_client_storage,
        GL_APPLE_element_array,
        GL_APPLE_fence,
        GL_APPLE_float_pixels,
        GL_APPLE_flush_buffer_range,
        GL_APPLE_object_purgeable,
        GL_APPLE_rgb_422,
        GL_APPLE_row_bytes,
        GL_APPLE_specular_vector,
        GL_APPLE_texture_range,
        GL_APPLE_transform_hint,
        GL_APPLE_vertex_array_object,
        GL_APPLE_vertex_array_range,
        GL_APPLE_vertex_program_evaluators,
        GL_APPLE_ycbcr_422,
        GL_ARB_ES2_compatibility,
        GL_ARB_ES3_1_compatibility,
        GL_ARB_ES3_2_compatibility,
        GL_ARB_ES3_compatibility,
        GL_ARB_arrays_of_arrays,
        GL_ARB_base_instance,
        GL_ARB_bindless_texture,
        GL_ARB_blend_func_extended,
        GL_ARB_buffer_storage,
        GL_ARB_cl_event,
        GL_ARB_clear_buffer_object,
        GL_ARB_clear_texture,
        GL_ARB_clip_control,
        GL_ARB_color_buffer_float,
        GL_ARB_compatibility,
        GL_ARB_compressed_texture_pixel_storage,
        GL_ARB_compute_shader,
        GL_ARB_compute_variable_group_size,
        GL_ARB_conditional_render_inverted,
        GL_ARB_conservative_depth,
        GL_ARB_copy_buffer,
        GL_ARB_copy_image,
        GL_ARB_cull_distance,
        GL_ARB_debug_output,
        GL_ARB_depth_buffer_float,
        GL_ARB_depth_clamp,
        GL_ARB_depth_texture,
        GL_ARB_derivative_control,
        GL_ARB_direct_state_access,
        GL_ARB_draw_buffers,
        GL_ARB_draw_buffers_blend,
        GL_ARB_draw_elements_base_vertex,
        GL_ARB_draw_indirect,
        GL_ARB_draw_instanced,
        GL_ARB_enhanced_layouts,
        GL_ARB_explicit_attrib_location,
        GL_ARB_explicit_uniform_location,
        GL_ARB_fragment_coord_conventions,
        GL_ARB_fragment_layer_viewport,
        GL_ARB_fragment_program,
        GL_ARB_fragment_program_shadow,
        GL_ARB_fragment_shader,
        GL_ARB_fragment_shader_interlock,
        GL_ARB_framebuffer_no_attachments,
        GL_ARB_framebuffer_object,
        GL_ARB_framebuffer_sRGB,
        GL_ARB_geometry_shader4,
        GL_ARB_get_program_binary,
        GL_ARB_get_texture_sub_image,
        GL_ARB_gpu_shader5,
        GL_ARB_gpu_shader_fp64,
        GL_ARB_gpu_shader_int64,
        GL_ARB_half_float_pixel,
        GL_ARB_half_float_vertex,
        GL_ARB_imaging,
        GL_ARB_indirect_parameters,
        GL_ARB_instanced_arrays,
        GL_ARB_internalformat_query,
        GL_ARB_internalformat_query2,
        GL_ARB_invalidate_subdata,
        GL_ARB_map_buffer_alignment,
        GL_ARB_map_buffer_range,
        GL_ARB_matrix_palette,
        GL_ARB_multi_bind,
        GL_ARB_multi_draw_indirect,
        GL_ARB_multisample,
        GL_ARB_multitexture,
        GL_ARB_occlusion_query,
        GL_ARB_occlusion_query2,
        GL_ARB_parallel_shader_compile,
        GL_ARB_pipeline_statistics_query,
        GL_ARB_pixel_buffer_object,
        GL_ARB_point_parameters,
        GL_ARB_point_sprite,
        GL_ARB_post_depth_coverage,
        GL_ARB_program_interface_query,
        GL_ARB_provoking_vertex,
        GL_ARB_query_buffer_object,
        GL_ARB_robust_buffer_access_behavior,
        GL_ARB_robustness,
        GL_ARB_robustness_isolation,
        GL_ARB_sample_locations,
        GL_ARB_sample_shading,
        GL_ARB_sampler_objects,
        GL_ARB_seamless_cube_map,
        GL_ARB_seamless_cubemap_per_texture,
        GL_ARB_separate_shader_objects,
        GL_ARB_shader_atomic_counter_ops,
        GL_ARB_shader_atomic_counters,
        GL_ARB_shader_ballot,
        GL_ARB_shader_bit_encoding,
        GL_ARB_shader_clock,
        GL_ARB_shader_draw_parameters,
        GL_ARB_shader_group_vote,
        GL_ARB_shader_image_load_store,
        GL_ARB_shader_image_size,
        GL_ARB_shader_objects,
        GL_ARB_shader_precision,
        GL_ARB_shader_stencil_export,
        GL_ARB_shader_storage_buffer_object,
        GL_ARB_shader_subroutine,
        GL_ARB_shader_texture_image_samples,
        GL_ARB_shader_texture_lod,
        GL_ARB_shader_viewport_layer_array,
        GL_ARB_shading_language_100,
        GL_ARB_shading_language_420pack,
        GL_ARB_shading_language_include,
        GL_ARB_shading_language_packing,
        GL_ARB_shadow,
        GL_ARB_shadow_ambient,
        GL_ARB_sparse_buffer,
        GL_ARB_sparse_texture,
        GL_ARB_sparse_texture2,
        GL_ARB_sparse_texture_clamp,
        GL_ARB_stencil_texturing,
        GL_ARB_sync,
        GL_ARB_tessellation_shader,
        GL_ARB_texture_barrier,
        GL_ARB_texture_border_clamp,
        GL_ARB_texture_buffer_object,
        GL_ARB_texture_buffer_object_rgb32,
        GL_ARB_texture_buffer_range,
        GL_ARB_texture_compression,
        GL_ARB_texture_compression_bptc,
        GL_ARB_texture_compression_rgtc,
        GL_ARB_texture_cube_map,
        GL_ARB_texture_cube_map_array,
        GL_ARB_texture_env_add,
        GL_ARB_texture_env_combine,
        GL_ARB_texture_env_crossbar,
        GL_ARB_texture_env_dot3,
        GL_ARB_texture_filter_minmax,
        GL_ARB_texture_float,
        GL_ARB_texture_gather,
        GL_ARB_texture_mirror_clamp_to_edge,
        GL_ARB_texture_mirrored_repeat,
        GL_ARB_texture_multisample,
        GL_ARB_texture_non_power_of_two,
        GL_ARB_texture_query_levels,
        GL_ARB_texture_query_lod,
        GL_ARB_texture_rectangle,
        GL_ARB_texture_rg,
        GL_ARB_texture_rgb10_a2ui,
        GL_ARB_texture_stencil8,
        GL_ARB_texture_storage,
        GL_ARB_texture_storage_multisample,
        GL_ARB_texture_swizzle,
        GL_ARB_texture_view,
        GL_ARB_timer_query,
        GL_ARB_transform_feedback2,
        GL_ARB_transform_feedback3,
        GL_ARB_transform_feedback_instanced,
        GL_ARB_transform_feedback_overflow_query,
        GL_ARB_transpose_matrix,
        GL_ARB_uniform_buffer_object,
        GL_ARB_vertex_array_bgra,
        GL_ARB_vertex_array_object,
        GL_ARB_vertex_attrib_64bit,
        GL_ARB_vertex_attrib_binding,
        GL_ARB_vertex_blend,
        GL_ARB_vertex_buffer_object,
        GL_ARB_vertex_program,
        GL_ARB_vertex_shader,
        GL_ARB_vertex_type_10f_11f_11f_rev,
        GL_ARB_vertex_type_2_10_10_10_rev,
        GL_ARB_viewport_array,
        GL_ARB_window_pos,
        GL_ATI_draw_buffers,
        GL_ATI_element_array,
        GL_ATI_envmap_bumpmap,
        GL_ATI_fragment_shader,
        GL_ATI_map_object_buffer,
        GL_ATI_meminfo,
        GL_ATI_pixel_format_float,
        GL_ATI_pn_triangles,
        GL_ATI_separate_stencil,
        GL_ATI_text_fragment_shader,
        GL_ATI_texture_env_combine3,
        GL_ATI_texture_float,
        GL_ATI_texture_mirror_once,
        GL_ATI_vertex_array_object,
        GL_ATI_vertex_attrib_array_object,
        GL_ATI_vertex_streams,
        GL_EXT_422_pixels,
        GL_EXT_abgr,
        GL_EXT_bgra,
        GL_EXT_bindable_uniform,
        GL_EXT_blend_color,
        GL_EXT_blend_equation_separate,
        GL_EXT_blend_func_separate,
        GL_EXT_blend_logic_op,
        GL_EXT_blend_minmax,
        GL_EXT_blend_subtract,
        GL_EXT_clip_volume_hint,
        GL_EXT_cmyka,
        GL_EXT_color_subtable,
        GL_EXT_compiled_vertex_array,
        GL_EXT_convolution,
        GL_EXT_coordinate_frame,
        GL_EXT_copy_texture,
        GL_EXT_cull_vertex,
        GL_EXT_debug_label,
        GL_EXT_debug_marker,
        GL_EXT_depth_bounds_test,
        GL_EXT_direct_state_access,
        GL_EXT_draw_buffers2,
        GL_EXT_draw_instanced,
        GL_EXT_draw_range_elements,
        GL_EXT_fog_coord,
        GL_EXT_framebuffer_blit,
        GL_EXT_framebuffer_multisample,
        GL_EXT_framebuffer_multisample_blit_scaled,
        GL_EXT_framebuffer_object,
        GL_EXT_framebuffer_sRGB,
        GL_EXT_geometry_shader4,
        GL_EXT_gpu_program_parameters,
        GL_EXT_gpu_shader4,
        GL_EXT_histogram,
        GL_EXT_index_array_formats,
        GL_EXT_index_func,
        GL_EXT_index_material,
        GL_EXT_index_texture,
        GL_EXT_light_texture,
        GL_EXT_misc_attribute,
        GL_EXT_multi_draw_arrays,
        GL_EXT_multisample,
        GL_EXT_packed_depth_stencil,
        GL_EXT_packed_float,
        GL_EXT_packed_pixels,
        GL_EXT_paletted_texture,
        GL_EXT_pixel_buffer_object,
        GL_EXT_pixel_transform,
        GL_EXT_pixel_transform_color_table,
        GL_EXT_point_parameters,
        GL_EXT_polygon_offset,
        GL_EXT_polygon_offset_clamp,
        GL_EXT_post_depth_coverage,
        GL_EXT_provoking_vertex,
        GL_EXT_raster_multisample,
        GL_EXT_rescale_normal,
        GL_EXT_secondary_color,
        GL_EXT_separate_shader_objects,
        GL_EXT_separate_specular_color,
        GL_EXT_shader_image_load_formatted,
        GL_EXT_shader_image_load_store,
        GL_EXT_shader_integer_mix,
        GL_EXT_shadow_funcs,
        GL_EXT_shared_texture_palette,
        GL_EXT_sparse_texture2,
        GL_EXT_stencil_clear_tag,
        GL_EXT_stencil_two_side,
        GL_EXT_stencil_wrap,
        GL_EXT_subtexture,
        GL_EXT_texture,
        GL_EXT_texture3D,
        GL_EXT_texture_array,
        GL_EXT_texture_buffer_object,
        GL_EXT_texture_compression_latc,
        GL_EXT_texture_compression_rgtc,
        GL_EXT_texture_compression_s3tc,
        GL_EXT_texture_cube_map,
        GL_EXT_texture_env_add,
        GL_EXT_texture_env_combine,
        GL_EXT_texture_env_dot3,
        GL_EXT_texture_filter_anisotropic,
        GL_EXT_texture_filter_minmax,
        GL_EXT_texture_integer,
        GL_EXT_texture_lod_bias,
        GL_EXT_texture_mirror_clamp,
        GL_EXT_texture_object,
        GL_EXT_texture_perturb_normal,
        GL_EXT_texture_sRGB,
        GL_EXT_texture_sRGB_decode,
        GL_EXT_texture_shared_exponent,
        GL_EXT_texture_snorm,
        GL_EXT_texture_swizzle,
        GL_EXT_timer_query,
        GL_EXT_transform_feedback,
        GL_EXT_vertex_array,
        GL_EXT_vertex_array_bgra,
        GL_EXT_vertex_attrib_64bit,
        GL_EXT_vertex_shader,
        GL_EXT_vertex_weighting,
        GL_EXT_window_rectangles,
        GL_EXT_x11_sync_object,
        GL_GREMEDY_frame_terminator,
        GL_GREMEDY_string_marker,
        GL_HP_convolution_border_modes,
        GL_HP_image_transform,
        GL_HP_occlusion_test,
        GL_HP_texture_lighting,
        GL_IBM_cull_vertex,
        GL_IBM_multimode_draw_arrays,
        GL_IBM_rasterpos_clip,
        GL_IBM_static_data,
        GL_IBM_texture_mirrored_repeat,
        GL_IBM_vertex_array_lists,
        GL_INGR_blend_func_separate,
        GL_INGR_color_clamp,
        GL_INGR_interlace_read,
        GL_INTEL_conservative_rasterization,
        GL_INTEL_fragment_shader_ordering,
        GL_INTEL_framebuffer_CMAA,
        GL_INTEL_map_texture,
        GL_INTEL_parallel_arrays,
        GL_INTEL_performance_query,
        GL_KHR_blend_equation_advanced,
        GL_KHR_blend_equation_advanced_coherent,
        GL_KHR_context_flush_control,
        GL_KHR_debug,
        GL_KHR_no_error,
        GL_KHR_robust_buffer_access_behavior,
        GL_KHR_robustness,
        GL_KHR_texture_compression_astc_hdr,
        GL_KHR_texture_compression_astc_ldr,
        GL_KHR_texture_compression_astc_sliced_3d,
        GL_MESAX_texture_stack,
        GL_MESA_pack_invert,
        GL_MESA_resize_buffers,
        GL_MESA_window_pos,
        GL_MESA_ycbcr_texture,
        GL_NVX_conditional_render,
        GL_NVX_gpu_memory_info,
        GL_NV_bindless_multi_draw_indirect,
        GL_NV_bindless_multi_draw_indirect_count,
        GL_NV_bindless_texture,
        GL_NV_blend_equation_advanced,
        GL_NV_blend_equation_advanced_coherent,
        GL_NV_blend_square,
        GL_NV_clip_space_w_scaling,
        GL_NV_command_list,
        GL_NV_compute_program5,
        GL_NV_conditional_render,
        GL_NV_conservative_raster,
        GL_NV_conservative_raster_dilate,
        GL_NV_conservative_raster_pre_snap_triangles,
        GL_NV_copy_depth_to_color,
        GL_NV_copy_image,
        GL_NV_deep_texture3D,
        GL_NV_depth_buffer_float,
        GL_NV_depth_clamp,
        GL_NV_draw_texture,
        GL_NV_evaluators,
        GL_NV_explicit_multisample,
        GL_NV_fence,
        GL_NV_fill_rectangle,
        GL_NV_float_buffer,
        GL_NV_fog_distance,
        GL_NV_fragment_coverage_to_color,
        GL_NV_fragment_program,
        GL_NV_fragment_program2,
        GL_NV_fragment_program4,
        GL_NV_fragment_program_option,
        GL_NV_fragment_shader_interlock,
        GL_NV_framebuffer_mixed_samples,
        GL_NV_framebuffer_multisample_coverage,
        GL_NV_geometry_program4,
        GL_NV_geometry_shader4,
        GL_NV_geometry_shader_passthrough,
        GL_NV_gpu_program4,
        GL_NV_gpu_program5,
        GL_NV_gpu_program5_mem_extended,
        GL_NV_gpu_shader5,
        GL_NV_half_float,
        GL_NV_internalformat_sample_query,
        GL_NV_light_max_exponent,
        GL_NV_multisample_coverage,
        GL_NV_multisample_filter_hint,
        GL_NV_occlusion_query,
        GL_NV_packed_depth_stencil,
        GL_NV_parameter_buffer_object,
        GL_NV_parameter_buffer_object2,
        GL_NV_path_rendering,
        GL_NV_path_rendering_shared_edge,
        GL_NV_pixel_data_range,
        GL_NV_point_sprite,
        GL_NV_present_video,
        GL_NV_primitive_restart,
        GL_NV_register_combiners,
        GL_NV_register_combiners2,
        GL_NV_robustness_video_memory_purge,
        GL_NV_sample_locations,
        GL_NV_sample_mask_override_coverage,
        GL_NV_shader_atomic_counters,
        GL_NV_shader_atomic_float,
        GL_NV_shader_atomic_float64,
        GL_NV_shader_atomic_fp16_vector,
        GL_NV_shader_atomic_int64,
        GL_NV_shader_buffer_load,
        GL_NV_shader_buffer_store,
        GL_NV_shader_storage_buffer_object,
        GL_NV_shader_thread_group,
        GL_NV_shader_thread_shuffle,
        GL_NV_stereo_view_rendering,
        GL_NV_tessellation_program5,
        GL_NV_texgen_emboss,
        GL_NV_texgen_reflection,
        GL_NV_texture_barrier,
        GL_NV_texture_compression_vtc,
        GL_NV_texture_env_combine4,
        GL_NV_texture_expand_normal,
        GL_NV_texture_multisample,
        GL_NV_texture_rectangle,
        GL_NV_texture_shader,
        GL_NV_texture_shader2,
        GL_NV_texture_shader3,
        GL_NV_transform_feedback,
        GL_NV_transform_feedback2,
        GL_NV_uniform_buffer_unified_memory,
        GL_NV_vdpau_interop,
        GL_NV_vertex_array_range,
        GL_NV_vertex_array_range2,
        GL_NV_vertex_attrib_integer_64bit,
        GL_NV_vertex_buffer_unified_memory,
        GL_NV_vertex_program,
        GL_NV_vertex_program1_1,
        GL_NV_vertex_program2,
        GL_NV_vertex_program2_option,
        GL_NV_vertex_program3,
        GL_NV_vertex_program4,
        GL_NV_video_capture,
        GL_NV_viewport_array2,
        GL_NV_viewport_swizzle,
        GL_OES_byte_coordinates,
        GL_OES_compressed_paletted_texture,
        GL_OES_fixed_point,
        GL_OES_query_matrix,
        GL_OES_read_format,
        GL_OES_single_precision,
        GL_OML_interlace,
        GL_OML_resample,
        GL_OML_subsample,
        GL_OVR_multiview,
        GL_OVR_multiview2,
        GL_PGI_misc_hints,
        GL_PGI_vertex_hints,
        GL_REND_screen_coordinates,
        GL_S3_s3tc,
        GL_SGIS_detail_texture,
        GL_SGIS_fog_function,
        GL_SGIS_generate_mipmap,
        GL_SGIS_multisample,
        GL_SGIS_pixel_texture,
        GL_SGIS_point_line_texgen,
        GL_SGIS_point_parameters,
        GL_SGIS_sharpen_texture,
        GL_SGIS_texture4D,
        GL_SGIS_texture_border_clamp,
        GL_SGIS_texture_color_mask,
        GL_SGIS_texture_edge_clamp,
        GL_SGIS_texture_filter4,
        GL_SGIS_texture_lod,
        GL_SGIS_texture_select,
        GL_SGIX_async,
        GL_SGIX_async_histogram,
        GL_SGIX_async_pixel,
        GL_SGIX_blend_alpha_minmax,
        GL_SGIX_calligraphic_fragment,
        GL_SGIX_clipmap,
        GL_SGIX_convolution_accuracy,
        GL_SGIX_depth_pass_instrument,
        GL_SGIX_depth_texture,
        GL_SGIX_flush_raster,
        GL_SGIX_fog_offset,
        GL_SGIX_fragment_lighting,
        GL_SGIX_framezoom,
        GL_SGIX_igloo_interface,
        GL_SGIX_instruments,
        GL_SGIX_interlace,
        GL_SGIX_ir_instrument1,
        GL_SGIX_list_priority,
        GL_SGIX_pixel_texture,
        GL_SGIX_pixel_tiles,
        GL_SGIX_polynomial_ffd,
        GL_SGIX_reference_plane,
        GL_SGIX_resample,
        GL_SGIX_scalebias_hint,
        GL_SGIX_shadow,
        GL_SGIX_shadow_ambient,
        GL_SGIX_sprite,
        GL_SGIX_subsample,
        GL_SGIX_tag_sample_buffer,
        GL_SGIX_texture_add_env,
        GL_SGIX_texture_coordinate_clamp,
        GL_SGIX_texture_lod_bias,
        GL_SGIX_texture_multi_buffer,
        GL_SGIX_texture_scale_bias,
        GL_SGIX_vertex_preclip,
        GL_SGIX_ycrcb,
        GL_SGIX_ycrcb_subsample,
        GL_SGIX_ycrcba,
        GL_SGI_color_matrix,
        GL_SGI_color_table,
        GL_SGI_texture_color_table,
        GL_SUNX_constant_data,
        GL_SUN_convolution_border_modes,
        GL_SUN_global_alpha,
        GL_SUN_mesh_array,
        GL_SUN_slice_accum,
        GL_SUN_triangle_list,
        GL_SUN_vertex,
        GL_WIN_phong_shading,
        GL_WIN_specular_fog
    Loader: True
    Local files: False
    Omit khrplatform: False

    Commandline:
        --profile="core" --api="gl=4.5" --generator="c" --spec="gl" --extensions="GL_3DFX_multisample,GL_3DFX_tbuffer,GL_3DFX_texture_compression_FXT1,GL_AMD_blend_minmax_factor,GL_AMD_conservative_depth,GL_AMD_debug_output,GL_AMD_depth_clamp_separate,GL_AMD_draw_buffers_blend,GL_AMD_gcn_shader,GL_AMD_gpu_shader_int64,GL_AMD_interleaved_elements,GL_AMD_multi_draw_indirect,GL_AMD_name_gen_delete,GL_AMD_occlusion_query_event,GL_AMD_performance_monitor,GL_AMD_pinned_memory,GL_AMD_query_buffer_object,GL_AMD_sample_positions,GL_AMD_seamless_cubemap_per_texture,GL_AMD_shader_atomic_counter_ops,GL_AMD_shader_explicit_vertex_parameter,GL_AMD_shader_stencil_export,GL_AMD_shader_trinary_minmax,GL_AMD_sparse_texture,GL_AMD_stencil_operation_extended,GL_AMD_texture_texture4,GL_AMD_transform_feedback3_lines_triangles,GL_AMD_transform_feedback4,GL_AMD_vertex_shader_layer,GL_AMD_vertex_shader_tessellator,GL_AMD_vertex_shader_viewport_index,GL_APPLE_aux_depth_stencil,GL_APPLE_client_storage,GL_APPLE_element_array,GL_APPLE_fence,GL_APPLE_float_pixels,GL_APPLE_flush_buffer_range,GL_APPLE_object_purgeable,GL_APPLE_rgb_422,GL_APPLE_row_bytes,GL_APPLE_specular_vector,GL_APPLE_texture_range,GL_APPLE_transform_hint,GL_APPLE_vertex_array_object,GL_APPLE_vertex_array_range,GL_APPLE_vertex_program_evaluators,GL_APPLE_ycbcr_422,GL_ARB_ES2_compatibility,GL_ARB_ES3_1_compatibility,GL_ARB_ES3_2_compatibility,GL_ARB_ES3_compatibility,GL_ARB_arrays_of_arrays,GL_ARB_base_instance,GL_ARB_bindless_texture,GL_ARB_blend_func_extended,GL_ARB_buffer_storage,GL_ARB_cl_event,GL_ARB_clear_buffer_object,GL_ARB_clear_texture,GL_ARB_clip_control,GL_ARB_color_buffer_float,GL_ARB_compatibility,GL_ARB_compressed_texture_pixel_storage,GL_ARB_compute_shader,GL_ARB_compute_variable_group_size,GL_ARB_conditional_render_inverted,GL_ARB_conservative_depth,GL_ARB_copy_buffer,GL_ARB_copy_image,GL_ARB_cull_distance,GL_ARB_debug_output,GL_ARB_depth_buffer_float,GL_ARB_depth_clamp,GL_ARB_depth_texture,GL_ARB_derivative_control,GL_ARB_direct_state_access,GL_ARB_draw_buffers,GL_ARB_draw_buffers_blend,GL_ARB_draw_elements_base_vertex,GL_ARB_draw_indirect,GL_ARB_draw_instanced,GL_ARB_enhanced_layouts,GL_ARB_explicit_attrib_location,GL_ARB_explicit_uniform_location,GL_ARB_fragment_coord_conventions,GL_ARB_fragment_layer_viewport,GL_ARB_fragment_program,GL_ARB_fragment_program_shadow,GL_ARB_fragment_shader,GL_ARB_fragment_shader_interlock,GL_ARB_framebuffer_no_attachments,GL_ARB_framebuffer_object,GL_ARB_framebuffer_sRGB,GL_ARB_geometry_shader4,GL_ARB_get_program_binary,GL_ARB_get_texture_sub_image,GL_ARB_gpu_shader5,GL_ARB_gpu_shader_fp64,GL_ARB_gpu_shader_int64,GL_ARB_half_float_pixel,GL_ARB_half_float_vertex,GL_ARB_imaging,GL_ARB_indirect_parameters,GL_ARB_instanced_arrays,GL_ARB_internalformat_query,GL_ARB_internalformat_query2,GL_ARB_invalidate_subdata,GL_ARB_map_buffer_alignment,GL_ARB_map_buffer_range,GL_ARB_matrix_palette,GL_ARB_multi_bind,GL_ARB_multi_draw_indirect,GL_ARB_multisample,GL_ARB_multitexture,GL_ARB_occlusion_query,GL_ARB_occlusion_query2,GL_ARB_parallel_shader_compile,GL_ARB_pipeline_statistics_query,GL_ARB_pixel_buffer_object,GL_ARB_point_parameters,GL_ARB_point_sprite,GL_ARB_post_depth_coverage,GL_ARB_program_interface_query,GL_ARB_provoking_vertex,GL_ARB_query_buffer_object,GL_ARB_robust_buffer_access_behavior,GL_ARB_robustness,GL_ARB_robustness_isolation,GL_ARB_sample_locations,GL_ARB_sample_shading,GL_ARB_sampler_objects,GL_ARB_seamless_cube_map,GL_ARB_seamless_cubemap_per_texture,GL_ARB_separate_shader_objects,GL_ARB_shader_atomic_counter_ops,GL_ARB_shader_atomic_counters,GL_ARB_shader_ballot,GL_ARB_shader_bit_encoding,GL_ARB_shader_clock,GL_ARB_shader_draw_parameters,GL_ARB_shader_group_vote,GL_ARB_shader_image_load_store,GL_ARB_shader_image_size,GL_ARB_shader_objects,GL_ARB_shader_precision,GL_ARB_shader_stencil_export,GL_ARB_shader_storage_buffer_object,GL_ARB_shader_subroutine,GL_ARB_shader_texture_image_samples,GL_ARB_shader_texture_lod,GL_ARB_shader_viewport_layer_array,GL_ARB_shading_language_100,GL_ARB_shading_language_420pack,GL_ARB_shading_language_include,GL_ARB_shading_language_packing,GL_ARB_shadow,GL_ARB_shadow_ambient,GL_ARB_sparse_buffer,GL_ARB_sparse_texture,GL_ARB_sparse_texture2,GL_ARB_sparse_texture_clamp,GL_ARB_stencil_texturing,GL_ARB_sync,GL_ARB_tessellation_shader,GL_ARB_texture_barrier,GL_ARB_texture_border_clamp,GL_ARB_texture_buffer_object,GL_ARB_texture_buffer_object_rgb32,GL_ARB_texture_buffer_range,GL_ARB_texture_compression,GL_ARB_texture_compression_bptc,GL_ARB_texture_compression_rgtc,GL_ARB_texture_cube_map,GL_ARB_texture_cube_map_array,GL_ARB_texture_env_add,GL_ARB_texture_env_combine,GL_ARB_texture_env_crossbar,GL_ARB_texture_env_dot3,GL_ARB_texture_filter_minmax,GL_ARB_texture_float,GL_ARB_texture_gather,GL_ARB_texture_mirror_clamp_to_edge,GL_ARB_texture_mirrored_repeat,GL_ARB_texture_multisample,GL_ARB_texture_non_power_of_two,GL_ARB_texture_query_levels,GL_ARB_texture_query_lod,GL_ARB_texture_rectangle,GL_ARB_texture_rg,GL_ARB_texture_rgb10_a2ui,GL_ARB_texture_stencil8,GL_ARB_texture_storage,GL_ARB_texture_storage_multisample,GL_ARB_texture_swizzle,GL_ARB_texture_view,GL_ARB_timer_query,GL_ARB_transform_feedback2,GL_ARB_transform_feedback3,GL_ARB_transform_feedback_instanced,GL_ARB_transform_feedback_overflow_query,GL_ARB_transpose_matrix,GL_ARB_uniform_buffer_object,GL_ARB_vertex_array_bgra,GL_ARB_vertex_array_object,GL_ARB_vertex_attrib_64bit,GL_ARB_vertex_attrib_binding,GL_ARB_vertex_blend,GL_ARB_vertex_buffer_object,GL_ARB_vertex_program,GL_ARB_vertex_shader,GL_ARB_vertex_type_10f_11f_11f_rev,GL_ARB_vertex_type_2_10_10_10_rev,GL_ARB_viewport_array,GL_ARB_window_pos,GL_ATI_draw_buffers,GL_ATI_element_array,GL_ATI_envmap_bumpmap,GL_ATI_fragment_shader,GL_ATI_map_object_buffer,GL_ATI_meminfo,GL_ATI_pixel_format_float,GL_ATI_pn_triangles,GL_ATI_separate_stencil,GL_ATI_text_fragment_shader,GL_ATI_texture_env_combine3,GL_ATI_texture_float,GL_ATI_texture_mirror_once,GL_ATI_vertex_array_object,GL_ATI_vertex_attrib_array_object,GL_ATI_vertex_streams,GL_EXT_422_pixels,GL_EXT_abgr,GL_EXT_bgra,GL_EXT_bindable_uniform,GL_EXT_blend_color,GL_EXT_blend_equation_separate,GL_EXT_blend_func_separate,GL_EXT_blend_logic_op,GL_EXT_blend_minmax,GL_EXT_blend_subtract,GL_EXT_clip_volume_hint,GL_EXT_cmyka,GL_EXT_color_subtable,GL_EXT_compiled_vertex_array,GL_EXT_convolution,GL_EXT_coordinate_frame,GL_EXT_copy_texture,GL_EXT_cull_vertex,GL_EXT_debug_label,GL_EXT_debug_marker,GL_EXT_depth_bounds_test,GL_EXT_direct_state_access,GL_EXT_draw_buffers2,GL_EXT_draw_instanced,GL_EXT_draw_range_elements,GL_EXT_fog_coord,GL_EXT_framebuffer_blit,GL_EXT_framebuffer_multisample,GL_EXT_framebuffer_multisample_blit_scaled,GL_EXT_framebuffer_object,GL_EXT_framebuffer_sRGB,GL_EXT_geometry_shader4,GL_EXT_gpu_program_parameters,GL_EXT_gpu_shader4,GL_EXT_histogram,GL_EXT_index_array_formats,GL_EXT_index_func,GL_EXT_index_material,GL_EXT_index_texture,GL_EXT_light_texture,GL_EXT_misc_attribute,GL_EXT_multi_draw_arrays,GL_EXT_multisample,GL_EXT_packed_depth_stencil,GL_EXT_packed_float,GL_EXT_packed_pixels,GL_EXT_paletted_texture,GL_EXT_pixel_buffer_object,GL_EXT_pixel_transform,GL_EXT_pixel_transform_color_table,GL_EXT_point_parameters,GL_EXT_polygon_offset,GL_EXT_polygon_offset_clamp,GL_EXT_post_depth_coverage,GL_EXT_provoking_vertex,GL_EXT_raster_multisample,GL_EXT_rescale_normal,GL_EXT_secondary_color,GL_EXT_separate_shader_objects,GL_EXT_separate_specular_color,GL_EXT_shader_image_load_formatted,GL_EXT_shader_image_load_store,GL_EXT_shader_integer_mix,GL_EXT_shadow_funcs,GL_EXT_shared_texture_palette,GL_EXT_sparse_texture2,GL_EXT_stencil_clear_tag,GL_EXT_stencil_two_side,GL_EXT_stencil_wrap,GL_EXT_subtexture,GL_EXT_texture,GL_EXT_texture3D,GL_EXT_texture_array,GL_EXT_texture_buffer_object,GL_EXT_texture_compression_latc,GL_EXT_texture_compression_rgtc,GL_EXT_texture_compression_s3tc,GL_EXT_texture_cube_map,GL_EXT_texture_env_add,GL_EXT_texture_env_combine,GL_EXT_texture_env_dot3,GL_EXT_texture_filter_anisotropic,GL_EXT_texture_filter_minmax,GL_EXT_texture_integer,GL_EXT_texture_lod_bias,GL_EXT_texture_mirror_clamp,GL_EXT_texture_object,GL_EXT_texture_perturb_normal,GL_EXT_texture_sRGB,GL_EXT_texture_sRGB_decode,GL_EXT_texture_shared_exponent,GL_EXT_texture_snorm,GL_EXT_texture_swizzle,GL_EXT_timer_query,GL_EXT_transform_feedback,GL_EXT_vertex_array,GL_EXT_vertex_array_bgra,GL_EXT_vertex_attrib_64bit,GL_EXT_vertex_shader,GL_EXT_vertex_weighting,GL_EXT_window_rectangles,GL_EXT_x11_sync_object,GL_GREMEDY_frame_terminator,GL_GREMEDY_string_marker,GL_HP_convolution_border_modes,GL_HP_image_transform,GL_HP_occlusion_test,GL_HP_texture_lighting,GL_IBM_cull_vertex,GL_IBM_multimode_draw_arrays,GL_IBM_rasterpos_clip,GL_IBM_static_data,GL_IBM_texture_mirrored_repeat,GL_IBM_vertex_array_lists,GL_INGR_blend_func_separate,GL_INGR_color_clamp,GL_INGR_interlace_read,GL_INTEL_conservative_rasterization,GL_INTEL_fragment_shader_ordering,GL_INTEL_framebuffer_CMAA,GL_INTEL_map_texture,GL_INTEL_parallel_arrays,GL_INTEL_performance_query,GL_KHR_blend_equation_advanced,GL_KHR_blend_equation_advanced_coherent,GL_KHR_context_flush_control,GL_KHR_debug,GL_KHR_no_error,GL_KHR_robust_buffer_access_behavior,GL_KHR_robustness,GL_KHR_texture_compression_astc_hdr,GL_KHR_texture_compression_astc_ldr,GL_KHR_texture_compression_astc_sliced_3d,GL_MESAX_texture_stack,GL_MESA_pack_invert,GL_MESA_resize_buffers,GL_MESA_window_pos,GL_MESA_ycbcr_texture,GL_NVX_conditional_render,GL_NVX_gpu_memory_info,GL_NV_bindless_multi_draw_indirect,GL_NV_bindless_multi_draw_indirect_count,GL_NV_bindless_texture,GL_NV_blend_equation_advanced,GL_NV_blend_equation_advanced_coherent,GL_NV_blend_square,GL_NV_clip_space_w_scaling,GL_NV_command_list,GL_NV_compute_program5,GL_NV_conditional_render,GL_NV_conservative_raster,GL_NV_conservative_raster_dilate,GL_NV_conservative_raster_pre_snap_triangles,GL_NV_copy_depth_to_color,GL_NV_copy_image,GL_NV_deep_texture3D,GL_NV_depth_buffer_float,GL_NV_depth_clamp,GL_NV_draw_texture,GL_NV_evaluators,GL_NV_explicit_multisample,GL_NV_fence,GL_NV_fill_rectangle,GL_NV_float_buffer,GL_NV_fog_distance,GL_NV_fragment_coverage_to_color,GL_NV_fragment_program,GL_NV_fragment_program2,GL_NV_fragment_program4,GL_NV_fragment_program_option,GL_NV_fragment_shader_interlock,GL_NV_framebuffer_mixed_samples,GL_NV_framebuffer_multisample_coverage,GL_NV_geometry_program4,GL_NV_geometry_shader4,GL_NV_geometry_shader_passthrough,GL_NV_gpu_program4,GL_NV_gpu_program5,GL_NV_gpu_program5_mem_extended,GL_NV_gpu_shader5,GL_NV_half_float,GL_NV_internalformat_sample_query,GL_NV_light_max_exponent,GL_NV_multisample_coverage,GL_NV_multisample_filter_hint,GL_NV_occlusion_query,GL_NV_packed_depth_stencil,GL_NV_parameter_buffer_object,GL_NV_parameter_buffer_object2,GL_NV_path_rendering,GL_NV_path_rendering_shared_edge,GL_NV_pixel_data_range,GL_NV_point_sprite,GL_NV_present_video,GL_NV_primitive_restart,GL_NV_register_combiners,GL_NV_register_combiners2,GL_NV_robustness_video_memory_purge,GL_NV_sample_locations,GL_NV_sample_mask_override_coverage,GL_NV_shader_atomic_counters,GL_NV_shader_atomic_float,GL_NV_shader_atomic_float64,GL_NV_shader_atomic_fp16_vector,GL_NV_shader_atomic_int64,GL_NV_shader_buffer_load,GL_NV_shader_buffer_store,GL_NV_shader_storage_buffer_object,GL_NV_shader_thread_group,GL_NV_shader_thread_shuffle,GL_NV_stereo_view_rendering,GL_NV_tessellation_program5,GL_NV_texgen_emboss,GL_NV_texgen_reflection,GL_NV_texture_barrier,GL_NV_texture_compression_vtc,GL_NV_texture_env_combine4,GL_NV_texture_expand_normal,GL_NV_texture_multisample,GL_NV_texture_rectangle,GL_NV_texture_shader,GL_NV_texture_shader2,GL_NV_texture_shader3,GL_NV_transform_feedback,GL_NV_transform_feedback2,GL_NV_uniform_buffer_unified_memory,GL_NV_vdpau_interop,GL_NV_vertex_array_range,GL_NV_vertex_array_range2,GL_NV_vertex_attrib_integer_64bit,GL_NV_vertex_buffer_unified_memory,GL_NV_vertex_program,GL_NV_vertex_program1_1,GL_NV_vertex_program2,GL_NV_vertex_program2_option,GL_NV_vertex_program3,GL_NV_vertex_program4,GL_NV_video_capture,GL_NV_viewport_array2,GL_NV_viewport_swizzle,GL_OES_byte_coordinates,GL_OES_compressed_paletted_texture,GL_OES_fixed_point,GL_OES_query_matrix,GL_OES_read_format,GL_OES_single_precision,GL_OML_interlace,GL_OML_resample,GL_OML_subsample,GL_OVR_multiview,GL_OVR_multiview2,GL_PGI_misc_hints,GL_PGI_vertex_hints,GL_REND_screen_coordinates,GL_S3_s3tc,GL_SGIS_detail_texture,GL_SGIS_fog_function,GL_SGIS_generate_mipmap,GL_SGIS_multisample,GL_SGIS_pixel_texture,GL_SGIS_point_line_texgen,GL_SGIS_point_parameters,GL_SGIS_sharpen_texture,GL_SGIS_texture4D,GL_SGIS_texture_border_clamp,GL_SGIS_texture_color_mask,GL_SGIS_texture_edge_clamp,GL_SGIS_texture_filter4,GL_SGIS_texture_lod,GL_SGIS_texture_select,GL_SGIX_async,GL_SGIX_async_histogram,GL_SGIX_async_pixel,GL_SGIX_blend_alpha_minmax,GL_SGIX_calligraphic_fragment,GL_SGIX_clipmap,GL_SGIX_convolution_accuracy,GL_SGIX_depth_pass_instrument,GL_SGIX_depth_texture,GL_SGIX_flush_raster,GL_SGIX_fog_offset,GL_SGIX_fragment_lighting,GL_SGIX_framezoom,GL_SGIX_igloo_interface,GL_SGIX_instruments,GL_SGIX_interlace,GL_SGIX_ir_instrument1,GL_SGIX_list_priority,GL_SGIX_pixel_texture,GL_SGIX_pixel_tiles,GL_SGIX_polynomial_ffd,GL_SGIX_reference_plane,GL_SGIX_resample,GL_SGIX_scalebias_hint,GL_SGIX_shadow,GL_SGIX_shadow_ambient,GL_SGIX_sprite,GL_SGIX_subsample,GL_SGIX_tag_sample_buffer,GL_SGIX_texture_add_env,GL_SGIX_texture_coordinate_clamp,GL_SGIX_texture_lod_bias,GL_SGIX_texture_multi_buffer,GL_SGIX_texture_scale_bias,GL_SGIX_vertex_preclip,GL_SGIX_ycrcb,GL_SGIX_ycrcb_subsample,GL_SGIX_ycrcba,GL_SGI_color_matrix,GL_SGI_color_table,GL_SGI_texture_color_table,GL_SUNX_constant_data,GL_SUN_convolution_border_modes,GL_SUN_global_alpha,GL_SUN_mesh_array,GL_SUN_slice_accum,GL_SUN_triangle_list,GL_SUN_vertex,GL_WIN_phong_shading,GL_WIN_specular_fog"
    Online:
        Too many extensions
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glad/glad.h>

static void* get_proc(const char *namez);

#ifdef _WIN32
#include <windows.h>
static HMODULE libGL;

typedef void* (APIENTRYP PFNWGLGETPROCADDRESSPROC_PRIVATE)(const char*);
PFNWGLGETPROCADDRESSPROC_PRIVATE gladGetProcAddressPtr;

static
int open_gl(void) {
    libGL = LoadLibraryW(L"opengl32.dll");
    if(libGL != NULL) {
        gladGetProcAddressPtr = (PFNWGLGETPROCADDRESSPROC_PRIVATE)GetProcAddress(
                libGL, "wglGetProcAddress");
        return gladGetProcAddressPtr != NULL;
    }

    return 0;
}

static
void close_gl(void) {
    if(libGL != NULL) {
        FreeLibrary(libGL);
        libGL = NULL;
    }
}
#else
#include <dlfcn.h>
static void* libGL;

#ifndef __APPLE__
typedef void* (APIENTRYP PFNGLXGETPROCADDRESSPROC_PRIVATE)(const char*);
PFNGLXGETPROCADDRESSPROC_PRIVATE gladGetProcAddressPtr;
#endif

static
int open_gl(void) {
#ifdef __APPLE__
    static const char *NAMES[] = {
        "../Frameworks/OpenGL.framework/OpenGL",
        "/Library/Frameworks/OpenGL.framework/OpenGL",
        "/System/Library/Frameworks/OpenGL.framework/OpenGL",
        "/System/Library/Frameworks/OpenGL.framework/Versions/Current/OpenGL"
    };
#else
    static const char *NAMES[] = {"libGL.so.1", "libGL.so"};
#endif

    unsigned int index = 0;
    for(index = 0; index < (sizeof(NAMES) / sizeof(NAMES[0])); index++) {
        libGL = dlopen(NAMES[index], RTLD_NOW | RTLD_GLOBAL);

        if(libGL != NULL) {
#ifdef __APPLE__
            return 1;
#else
            gladGetProcAddressPtr = (PFNGLXGETPROCADDRESSPROC_PRIVATE)dlsym(libGL,
                "glXGetProcAddressARB");
            return gladGetProcAddressPtr != NULL;
#endif
        }
    }

    return 0;
}

static
void close_gl() {
    if(libGL != NULL) {
        dlclose(libGL);
        libGL = NULL;
    }
}
#endif

static
void* get_proc(const char *namez) {
    void* result = NULL;
    if(libGL == NULL) return NULL;

#ifndef __APPLE__
    if(gladGetProcAddressPtr != NULL) {
        result = gladGetProcAddressPtr(namez);
    }
#endif
    if(result == NULL) {
#ifdef _WIN32
        result = (void*)GetProcAddress(libGL, namez);
#else
        result = dlsym(libGL, namez);
#endif
    }

    return result;
}

int gladLoadGL(void) {
    int status = 0;

    if(open_gl()) {
        status = gladLoadGLLoader(&get_proc);
        close_gl();
    }

    return status;
}

struct gladGLversionStruct GLVersion;

#if defined(GL_ES_VERSION_3_0) || defined(GL_VERSION_3_0)
#define _GLAD_IS_SOME_NEW_VERSION 1
#endif

static int max_loaded_major;
static int max_loaded_minor;

static const char *exts = NULL;
static int num_exts_i = 0;
static const char **exts_i = NULL;

static int get_exts(void) {
#ifdef _GLAD_IS_SOME_NEW_VERSION
    if(max_loaded_major < 3) {
#endif
        exts = (const char *)glGetString(GL_EXTENSIONS);
#ifdef _GLAD_IS_SOME_NEW_VERSION
    } else {
        int index;

        num_exts_i = 0;
        glGetIntegerv(GL_NUM_EXTENSIONS, &num_exts_i);
        if (num_exts_i > 0) {
            exts_i = (const char **)realloc((void *)exts_i, num_exts_i * sizeof *exts_i);
        }

        if (exts_i == NULL) {
            return 0;
        }

        for(index = 0; index < num_exts_i; index++) {
            exts_i[index] = (const char*)glGetStringi(GL_EXTENSIONS, index);
        }
    }
#endif
    return 1;
}

static void free_exts(void) {
    if (exts_i != NULL) {
        free((char **)exts_i);
        exts_i = NULL;
    }
}

static int has_ext(const char *ext) {
#ifdef _GLAD_IS_SOME_NEW_VERSION
    if(max_loaded_major < 3) {
#endif
        const char *extensions;
        const char *loc;
        const char *terminator;
        extensions = exts;
        if(extensions == NULL || ext == NULL) {
            return 0;
        }

        while(1) {
            loc = strstr(extensions, ext);
            if(loc == NULL) {
                return 0;
            }

            terminator = loc + strlen(ext);
            if((loc == extensions || *(loc - 1) == ' ') &&
                (*terminator == ' ' || *terminator == '\0')) {
                return 1;
            }
            extensions = terminator;
        }
#ifdef _GLAD_IS_SOME_NEW_VERSION
    } else {
        int index;

        for(index = 0; index < num_exts_i; index++) {
            const char *e = exts_i[index];

            if(strcmp(e, ext) == 0) {
                return 1;
            }
        }
    }
#endif

    return 0;
}
int GLAD_GL_VERSION_1_0;
int GLAD_GL_VERSION_1_1;
int GLAD_GL_VERSION_1_2;
int GLAD_GL_VERSION_1_3;
int GLAD_GL_VERSION_1_4;
int GLAD_GL_VERSION_1_5;
int GLAD_GL_VERSION_2_0;
int GLAD_GL_VERSION_2_1;
int GLAD_GL_VERSION_3_0;
int GLAD_GL_VERSION_3_1;
int GLAD_GL_VERSION_3_2;
int GLAD_GL_VERSION_3_3;
int GLAD_GL_VERSION_4_0;
int GLAD_GL_VERSION_4_1;
int GLAD_GL_VERSION_4_2;
int GLAD_GL_VERSION_4_3;
int GLAD_GL_VERSION_4_4;
int GLAD_GL_VERSION_4_5;
PFNGLCOPYTEXIMAGE1DPROC glad_glCopyTexImage1D;
PFNGLVERTEXATTRIBI3UIPROC glad_glVertexAttribI3ui;
PFNGLVERTEXARRAYELEMENTBUFFERPROC glad_glVertexArrayElementBuffer;
PFNGLSTENCILMASKSEPARATEPROC glad_glStencilMaskSeparate;
PFNGLTEXTURESTORAGE3DMULTISAMPLEPROC glad_glTextureStorage3DMultisample;
PFNGLTEXTUREPARAMETERFVPROC glad_glTextureParameterfv;
PFNGLMINSAMPLESHADINGPROC glad_glMinSampleShading;
PFNGLFRAMEBUFFERRENDERBUFFERPROC glad_glFramebufferRenderbuffer;
PFNGLUNIFORMSUBROUTINESUIVPROC glad_glUniformSubroutinesuiv;
PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC glad_glCompressedTexSubImage3D;
PFNGLTEXCOORDP3UIVPROC glad_glTexCoordP3uiv;
PFNGLGETDOUBLEI_VPROC glad_glGetDoublei_v;
PFNGLVERTEXATTRIB1SVPROC glad_glVertexAttrib1sv;
PFNGLVERTEXARRAYVERTEXBUFFERSPROC glad_glVertexArrayVertexBuffers;
PFNGLBINDSAMPLERPROC glad_glBindSampler;
PFNGLLINEWIDTHPROC glad_glLineWidth;
PFNGLCOLORP3UIVPROC glad_glColorP3uiv;
PFNGLGETINTEGERI_VPROC glad_glGetIntegeri_v;
PFNGLCOMPILESHADERPROC glad_glCompileShader;
PFNGLGETTRANSFORMFEEDBACKVARYINGPROC glad_glGetTransformFeedbackVarying;
PFNGLCOMPRESSEDTEXTURESUBIMAGE3DPROC glad_glCompressedTextureSubImage3D;
PFNGLGETCOMPRESSEDTEXTUREIMAGEPROC glad_glGetCompressedTextureImage;
PFNGLGETNMAPFVPROC glad_glGetnMapfv;
PFNGLTRANSFORMFEEDBACKBUFFERRANGEPROC glad_glTransformFeedbackBufferRange;
PFNGLGETTEXTUREIMAGEPROC glad_glGetTextureImage;
PFNGLDEPTHRANGEFPROC glad_glDepthRangef;
PFNGLVERTEXATTRIBIPOINTERPROC glad_glVertexAttribIPointer;
PFNGLMULTITEXCOORDP3UIPROC glad_glMultiTexCoordP3ui;
PFNGLGETNAMEDBUFFERPARAMETERIVPROC glad_glGetNamedBufferParameteriv;
PFNGLVERTEXP4UIPROC glad_glVertexP4ui;
PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEPROC glad_glDrawElementsInstancedBaseInstance;
PFNGLENABLEIPROC glad_glEnablei;
PFNGLVERTEXATTRIBP4UIPROC glad_glVertexAttribP4ui;
PFNGLCREATESHADERPROC glad_glCreateShader;
PFNGLISBUFFERPROC glad_glIsBuffer;
PFNGLGETMULTISAMPLEFVPROC glad_glGetMultisamplefv;
PFNGLPROGRAMUNIFORMMATRIX2DVPROC glad_glProgramUniformMatrix2dv;
PFNGLGENRENDERBUFFERSPROC glad_glGenRenderbuffers;
PFNGLCOPYTEXSUBIMAGE2DPROC glad_glCopyTexSubImage2D;
PFNGLCOMPRESSEDTEXIMAGE2DPROC glad_glCompressedTexImage2D;
PFNGLVERTEXATTRIB1FPROC glad_glVertexAttrib1f;
PFNGLBLENDFUNCSEPARATEPROC glad_glBlendFuncSeparate;
PFNGLPROGRAMUNIFORMMATRIX4FVPROC glad_glProgramUniformMatrix4fv;
PFNGLCLEARNAMEDFRAMEBUFFERFIPROC glad_glClearNamedFramebufferfi;
PFNGLGETQUERYBUFFEROBJECTUIVPROC glad_glGetQueryBufferObjectuiv;
PFNGLHINTPROC glad_glHint;
PFNGLVERTEXATTRIB1SPROC glad_glVertexAttrib1s;
PFNGLSAMPLEMASKIPROC glad_glSampleMaski;
PFNGLVERTEXP2UIPROC glad_glVertexP2ui;
PFNGLUNIFORMMATRIX3X2FVPROC glad_glUniformMatrix3x2fv;
PFNGLDEBUGMESSAGECONTROLPROC glad_glDebugMessageControl;
PFNGLPOINTSIZEPROC glad_glPointSize;
PFNGLBINDTEXTUREUNITPROC glad_glBindTextureUnit;
PFNGLVERTEXATTRIB2DVPROC glad_glVertexAttrib2dv;
PFNGLDELETEPROGRAMPROC glad_glDeleteProgram;
PFNGLVERTEXATTRIB4NUIVPROC glad_glVertexAttrib4Nuiv;
PFNGLTEXSTORAGE2DPROC glad_glTexStorage2D;
PFNGLRENDERBUFFERSTORAGEPROC glad_glRenderbufferStorage;
PFNGLWAITSYNCPROC glad_glWaitSync;
PFNGLUNIFORMMATRIX4X3FVPROC glad_glUniformMatrix4x3fv;
PFNGLUNIFORM3IPROC glad_glUniform3i;
PFNGLCLEARBUFFERFVPROC glad_glClearBufferfv;
PFNGLPROGRAMUNIFORM1UIPROC glad_glProgramUniform1ui;
PFNGLBLENDEQUATIONSEPARATEIPROC glad_glBlendEquationSeparatei;
PFNGLGETNMAPIVPROC glad_glGetnMapiv;
PFNGLTEXTUREBARRIERPROC glad_glTextureBarrier;
PFNGLUNIFORM3DPROC glad_glUniform3d;
PFNGLUNIFORM3FPROC glad_glUniform3f;
PFNGLVERTEXATTRIB4UBVPROC glad_glVertexAttrib4ubv;
PFNGLGETBUFFERPARAMETERIVPROC glad_glGetBufferParameteriv;
PFNGLTEXCOORDP2UIPROC glad_glTexCoordP2ui;
PFNGLCOLORMASKIPROC glad_glColorMaski;
PFNGLCLEARBUFFERFIPROC glad_glClearBufferfi;
PFNGLDRAWARRAYSINDIRECTPROC glad_glDrawArraysIndirect;
PFNGLGENVERTEXARRAYSPROC glad_glGenVertexArrays;
PFNGLPAUSETRANSFORMFEEDBACKPROC glad_glPauseTransformFeedback;
PFNGLMULTITEXCOORDP2UIPROC glad_glMultiTexCoordP2ui;
PFNGLPROGRAMUNIFORMMATRIX3X2DVPROC glad_glProgramUniformMatrix3x2dv;
PFNGLCOPYNAMEDBUFFERSUBDATAPROC glad_glCopyNamedBufferSubData;
PFNGLPROGRAMUNIFORMMATRIX3X2FVPROC glad_glProgramUniformMatrix3x2fv;
PFNGLGETSAMPLERPARAMETERIIVPROC glad_glGetSamplerParameterIiv;
PFNGLGETFRAGDATAINDEXPROC glad_glGetFragDataIndex;
PFNGLVERTEXATTRIBL4DPROC glad_glVertexAttribL4d;
PFNGLBINDIMAGETEXTUREPROC glad_glBindImageTexture;
PFNGLTEXTUREPARAMETERIVPROC glad_glTextureParameteriv;
PFNGLGETQUERYBUFFEROBJECTI64VPROC glad_glGetQueryBufferObjecti64v;
PFNGLGETVERTEXATTRIBDVPROC glad_glGetVertexAttribdv;
PFNGLACTIVESHADERPROGRAMPROC glad_glActiveShaderProgram;
PFNGLUNIFORMMATRIX3X4FVPROC glad_glUniformMatrix3x4fv;
PFNGLUNIFORMMATRIX3DVPROC glad_glUniformMatrix3dv;
PFNGLPROGRAMUNIFORMMATRIX3X4DVPROC glad_glProgramUniformMatrix3x4dv;
PFNGLNAMEDFRAMEBUFFERTEXTUREPROC glad_glNamedFramebufferTexture;
PFNGLGETTEXTUREPARAMETERFVPROC glad_glGetTextureParameterfv;
PFNGLINVALIDATEBUFFERSUBDATAPROC glad_glInvalidateBufferSubData;
PFNGLRESUMETRANSFORMFEEDBACKPROC glad_glResumeTransformFeedback;
PFNGLMULTITEXCOORDP4UIPROC glad_glMultiTexCoordP4ui;
PFNGLPROGRAMUNIFORMMATRIX4X3FVPROC glad_glProgramUniformMatrix4x3fv;
PFNGLVIEWPORTARRAYVPROC glad_glViewportArrayv;
PFNGLDELETEFRAMEBUFFERSPROC glad_glDeleteFramebuffers;
PFNGLDRAWARRAYSPROC glad_glDrawArrays;
PFNGLUNIFORM1UIPROC glad_glUniform1ui;
PFNGLPROGRAMUNIFORM2UIVPROC glad_glProgramUniform2uiv;
PFNGLVERTEXATTRIBI2IPROC glad_glVertexAttribI2i;
PFNGLTEXCOORDP3UIPROC glad_glTexCoordP3ui;
PFNGLVERTEXATTRIB3DPROC glad_glVertexAttrib3d;
PFNGLCLEARPROC glad_glClear;
PFNGLPROGRAMPARAMETERIPROC glad_glProgramParameteri;
PFNGLGETACTIVEUNIFORMNAMEPROC glad_glGetActiveUniformName;
PFNGLMEMORYBARRIERPROC glad_glMemoryBarrier;
PFNGLGETGRAPHICSRESETSTATUSPROC glad_glGetGraphicsResetStatus;
PFNGLISENABLEDPROC glad_glIsEnabled;
PFNGLSTENCILOPPROC glad_glStencilOp;
PFNGLFRAMEBUFFERTEXTURE2DPROC glad_glFramebufferTexture2D;
PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC glad_glGetFramebufferAttachmentParameteriv;
PFNGLVERTEXATTRIB4NUBPROC glad_glVertexAttrib4Nub;
PFNGLMAPNAMEDBUFFERRANGEPROC glad_glMapNamedBufferRange;
PFNGLGETFRAGDATALOCATIONPROC glad_glGetFragDataLocation;
PFNGLGETTEXTUREPARAMETERIIVPROC glad_glGetTextureParameterIiv;
PFNGLTEXIMAGE1DPROC glad_glTexImage1D;
PFNGLTEXPARAMETERIVPROC glad_glTexParameteriv;
PFNGLVERTEXARRAYATTRIBIFORMATPROC glad_glVertexArrayAttribIFormat;
PFNGLVERTEXARRAYVERTEXBUFFERPROC glad_glVertexArrayVertexBuffer;
PFNGLGETTEXIMAGEPROC glad_glGetTexImage;
PFNGLGETQUERYOBJECTI64VPROC glad_glGetQueryObjecti64v;
PFNGLGENFRAMEBUFFERSPROC glad_glGenFramebuffers;
PFNGLCREATETEXTURESPROC glad_glCreateTextures;
PFNGLTRANSFORMFEEDBACKBUFFERBASEPROC glad_glTransformFeedbackBufferBase;
PFNGLCLEARTEXSUBIMAGEPROC glad_glClearTexSubImage;
PFNGLGETATTACHEDSHADERSPROC glad_glGetAttachedShaders;
PFNGLISRENDERBUFFERPROC glad_glIsRenderbuffer;
PFNGLDELETEVERTEXARRAYSPROC glad_glDeleteVertexArrays;
PFNGLBINDVERTEXBUFFERSPROC glad_glBindVertexBuffers;
PFNGLPROGRAMUNIFORM1UIVPROC glad_glProgramUniform1uiv;
PFNGLISVERTEXARRAYPROC glad_glIsVertexArray;
PFNGLDISABLEVERTEXATTRIBARRAYPROC glad_glDisableVertexAttribArray;
PFNGLPROGRAMUNIFORM2IVPROC glad_glProgramUniform2iv;
PFNGLGETQUERYIVPROC glad_glGetQueryiv;
PFNGLGETTRANSFORMFEEDBACKIVPROC glad_glGetTransformFeedbackiv;
PFNGLBLITNAMEDFRAMEBUFFERPROC glad_glBlitNamedFramebuffer;
PFNGLVERTEXARRAYATTRIBLFORMATPROC glad_glVertexArrayAttribLFormat;
PFNGLCREATEQUERIESPROC glad_glCreateQueries;
PFNGLGETSAMPLERPARAMETERFVPROC glad_glGetSamplerParameterfv;
PFNGLSHADERSTORAGEBLOCKBINDINGPROC glad_glShaderStorageBlockBinding;
PFNGLPROGRAMUNIFORMMATRIX4X2DVPROC glad_glProgramUniformMatrix4x2dv;
PFNGLGETUNIFORMINDICESPROC glad_glGetUniformIndices;
PFNGLISSHADERPROC glad_glIsShader;
PFNGLVERTEXATTRIBI4UBVPROC glad_glVertexAttribI4ubv;
PFNGLBEGINQUERYINDEXEDPROC glad_glBeginQueryIndexed;
PFNGLPOINTPARAMETERIVPROC glad_glPointParameteriv;
PFNGLENABLEPROC glad_glEnable;
PFNGLGETACTIVEUNIFORMSIVPROC glad_glGetActiveUniformsiv;
PFNGLVERTEXARRAYATTRIBBINDINGPROC glad_glVertexArrayAttribBinding;
PFNGLTEXTURESTORAGE1DPROC glad_glTextureStorage1D;
PFNGLMEMORYBARRIERBYREGIONPROC glad_glMemoryBarrierByRegion;
PFNGLBLENDEQUATIONIPROC glad_glBlendEquationi;
PFNGLGETATTRIBLOCATIONPROC glad_glGetAttribLocation;
PFNGLVERTEXATTRIB4DVPROC glad_glVertexAttrib4dv;
PFNGLGETTEXTUREPARAMETERIVPROC glad_glGetTextureParameteriv;
PFNGLGETPROGRAMINTERFACEIVPROC glad_glGetProgramInterfaceiv;
PFNGLUNIFORM2DVPROC glad_glUniform2dv;
PFNGLMAPNAMEDBUFFERPROC glad_glMapNamedBuffer;
PFNGLMULTITEXCOORDP3UIVPROC glad_glMultiTexCoordP3uiv;
PFNGLVERTEXATTRIBP3UIPROC glad_glVertexAttribP3ui;
PFNGLVERTEXATTRIBL1DVPROC glad_glVertexAttribL1dv;
PFNGLTEXTUREBUFFERRANGEPROC glad_glTextureBufferRange;
PFNGLGETNUNIFORMDVPROC glad_glGetnUniformdv;
PFNGLPROGRAMUNIFORM3UIPROC glad_glProgramUniform3ui;
PFNGLVERTEXBINDINGDIVISORPROC glad_glVertexBindingDivisor;
PFNGLGETUNIFORMFVPROC glad_glGetUniformfv;
PFNGLGETUNIFORMUIVPROC glad_glGetUniformuiv;
PFNGLPROGRAMUNIFORMMATRIX2X3FVPROC glad_glProgramUniformMatrix2x3fv;
PFNGLGETVERTEXATTRIBIIVPROC glad_glGetVertexAttribIiv;
PFNGLVERTEXARRAYBINDINGDIVISORPROC glad_glVertexArrayBindingDivisor;
PFNGLDRAWBUFFERPROC glad_glDrawBuffer;
PFNGLENDQUERYINDEXEDPROC glad_glEndQueryIndexed;
PFNGLGETNPIXELMAPUSVPROC glad_glGetnPixelMapusv;
PFNGLCLEARBUFFERUIVPROC glad_glClearBufferuiv;
PFNGLDRAWELEMENTSINSTANCEDPROC glad_glDrawElementsInstanced;
PFNGLPROGRAMUNIFORM1IPROC glad_glProgramUniform1i;
PFNGLPATCHPARAMETERIPROC glad_glPatchParameteri;
PFNGLPROGRAMUNIFORM1DPROC glad_glProgramUniform1d;
PFNGLPROGRAMUNIFORM1FPROC glad_glProgramUniform1f;
PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVPROC glad_glGetNamedFramebufferParameteriv;
PFNGLFLUSHPROC glad_glFlush;
PFNGLGETRENDERBUFFERPARAMETERIVPROC glad_glGetRenderbufferParameteriv;
PFNGLPROGRAMUNIFORM3IVPROC glad_glProgramUniform3iv;
PFNGLGETDEBUGMESSAGELOGPROC glad_glGetDebugMessageLog;
PFNGLNAMEDRENDERBUFFERSTORAGEPROC glad_glNamedRenderbufferStorage;
PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVPROC glad_glGetNamedFramebufferAttachmentParameteriv;
PFNGLGETVERTEXATTRIBPOINTERVPROC glad_glGetVertexAttribPointerv;
PFNGLFENCESYNCPROC glad_glFenceSync;
PFNGLCOLORP3UIPROC glad_glColorP3ui;
PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEPROC glad_glDrawElementsInstancedBaseVertexBaseInstance;
PFNGLVERTEXATTRIB3SVPROC glad_glVertexAttrib3sv;
PFNGLBEGINCONDITIONALRENDERPROC glad_glBeginConditionalRender;
PFNGLVALIDATEPROGRAMPIPELINEPROC glad_glValidateProgramPipeline;
PFNGLGETNMINMAXPROC glad_glGetnMinmax;
PFNGLGETTEXLEVELPARAMETERIVPROC glad_glGetTexLevelParameteriv;
PFNGLMULTITEXCOORDP4UIVPROC glad_glMultiTexCoordP4uiv;
PFNGLTEXSTORAGE3DMULTISAMPLEPROC glad_glTexStorage3DMultisample;
PFNGLSTENCILFUNCSEPARATEPROC glad_glStencilFuncSeparate;
PFNGLDISABLEVERTEXARRAYATTRIBPROC glad_glDisableVertexArrayAttrib;
PFNGLGENSAMPLERSPROC glad_glGenSamplers;
PFNGLCLAMPCOLORPROC glad_glClampColor;
PFNGLUNIFORM4IVPROC glad_glUniform4iv;
PFNGLCLEARSTENCILPROC glad_glClearStencil;
PFNGLTEXCOORDP1UIVPROC glad_glTexCoordP1uiv;
PFNGLGETNAMEDRENDERBUFFERPARAMETERIVPROC glad_glGetNamedRenderbufferParameteriv;
PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDPROC glad_glDrawTransformFeedbackInstanced;
PFNGLGENTEXTURESPROC glad_glGenTextures;
PFNGLTEXTURESTORAGE2DMULTISAMPLEPROC glad_glTextureStorage2DMultisample;
PFNGLDRAWTRANSFORMFEEDBACKPROC glad_glDrawTransformFeedback;
PFNGLUNIFORM1DVPROC glad_glUniform1dv;
PFNGLGETTEXPARAMETERIUIVPROC glad_glGetTexParameterIuiv;
PFNGLGETTRANSFORMFEEDBACKI_VPROC glad_glGetTransformFeedbacki_v;
PFNGLVERTEXATTRIB4NBVPROC glad_glVertexAttrib4Nbv;
PFNGLCLEARNAMEDFRAMEBUFFERUIVPROC glad_glClearNamedFramebufferuiv;
PFNGLISSYNCPROC glad_glIsSync;
PFNGLCLEARNAMEDFRAMEBUFFERIVPROC glad_glClearNamedFramebufferiv;
PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC glad_glGetActiveUniformBlockName;
PFNGLUNIFORM2IPROC glad_glUniform2i;
PFNGLUNIFORM2FPROC glad_glUniform2f;
PFNGLUNIFORM2DPROC glad_glUniform2d;
PFNGLTEXCOORDP4UIPROC glad_glTexCoordP4ui;
PFNGLGETPROGRAMIVPROC glad_glGetProgramiv;
PFNGLVERTEXATTRIBPOINTERPROC glad_glVertexAttribPointer;
PFNGLFRAMEBUFFERTEXTURELAYERPROC glad_glFramebufferTextureLayer;
PFNGLPROGRAMUNIFORM4FVPROC glad_glProgramUniform4fv;
PFNGLGETOBJECTPTRLABELPROC glad_glGetObjectPtrLabel;
PFNGLTEXTUREPARAMETERIPROC glad_glTextureParameteri;
PFNGLTEXTUREPARAMETERFPROC glad_glTextureParameterf;
PFNGLFLUSHMAPPEDBUFFERRANGEPROC glad_glFlushMappedBufferRange;
PFNGLPROGRAMUNIFORM2FVPROC glad_glProgramUniform2fv;
PFNGLUNIFORMMATRIX2X3DVPROC glad_glUniformMatrix2x3dv;
PFNGLPROGRAMUNIFORMMATRIX4DVPROC glad_glProgramUniformMatrix4dv;
PFNGLVERTEXATTRIBL3DPROC glad_glVertexAttribL3d;
PFNGLPROGRAMUNIFORMMATRIX2X4DVPROC glad_glProgramUniformMatrix2x4dv;
PFNGLDISPATCHCOMPUTEPROC glad_glDispatchCompute;
PFNGLGENQUERIESPROC glad_glGenQueries;
PFNGLVERTEXATTRIBP1UIPROC glad_glVertexAttribP1ui;
PFNGLTEXSUBIMAGE3DPROC glad_glTexSubImage3D;
PFNGLGETINTEGER64I_VPROC glad_glGetInteger64i_v;
PFNGLDELETESAMPLERSPROC glad_glDeleteSamplers;
PFNGLCOPYTEXIMAGE2DPROC glad_glCopyTexImage2D;
PFNGLGETTEXTURESUBIMAGEPROC glad_glGetTextureSubImage;
PFNGLBLITFRAMEBUFFERPROC glad_glBlitFramebuffer;
PFNGLISENABLEDIPROC glad_glIsEnabledi;
PFNGLBINDBUFFERSRANGEPROC glad_glBindBuffersRange;
PFNGLSECONDARYCOLORP3UIPROC glad_glSecondaryColorP3ui;
PFNGLBINDFRAGDATALOCATIONINDEXEDPROC glad_glBindFragDataLocationIndexed;
PFNGLCOPYIMAGESUBDATAPROC glad_glCopyImageSubData;
PFNGLUNIFORM2IVPROC glad_glUniform2iv;
PFNGLVERTEXATTRIB1FVPROC glad_glVertexAttrib1fv;
PFNGLUNIFORM4UIVPROC glad_glUniform4uiv;
PFNGLPROGRAMUNIFORM2DVPROC glad_glProgramUniform2dv;
PFNGLTEXTURESUBIMAGE3DPROC glad_glTextureSubImage3D;
PFNGLFRAMEBUFFERTEXTURE1DPROC glad_glFramebufferTexture1D;
PFNGLGETSHADERIVPROC glad_glGetShaderiv;
PFNGLPROGRAMUNIFORMMATRIX3FVPROC glad_glProgramUniformMatrix3fv;
PFNGLOBJECTPTRLABELPROC glad_glObjectPtrLabel;
PFNGLINVALIDATEFRAMEBUFFERPROC glad_glInvalidateFramebuffer;
PFNGLBINDTEXTURESPROC glad_glBindTextures;
PFNGLBINDFRAGDATALOCATIONPROC glad_glBindFragDataLocation;
PFNGLNAMEDBUFFERSTORAGEPROC glad_glNamedBufferStorage;
PFNGLSCISSORARRAYVPROC glad_glScissorArrayv;
PFNGLPOLYGONOFFSETPROC glad_glPolygonOffset;
PFNGLGETDOUBLEVPROC glad_glGetDoublev;
PFNGLVERTEXATTRIB1DPROC glad_glVertexAttrib1d;
PFNGLUNIFORM4DVPROC glad_glUniform4dv;
PFNGLPROGRAMUNIFORM3DVPROC glad_glProgramUniform3dv;
PFNGLGETUNIFORMIVPROC glad_glGetUniformiv;
PFNGLINVALIDATEBUFFERDATAPROC glad_glInvalidateBufferData;
PFNGLGETNCOLORTABLEPROC glad_glGetnColorTable;
PFNGLCOMPRESSEDTEXTURESUBIMAGE1DPROC glad_glCompressedTextureSubImage1D;
PFNGLMULTITEXCOORDP1UIVPROC glad_glMultiTexCoordP1uiv;
PFNGLUNIFORM3FVPROC glad_glUniform3fv;
PFNGLMULTIDRAWELEMENTSINDIRECTPROC glad_glMultiDrawElementsIndirect;
PFNGLDEPTHRANGEPROC glad_glDepthRange;
PFNGLINVALIDATESUBFRAMEBUFFERPROC glad_glInvalidateSubFramebuffer;
PFNGLMAPBUFFERPROC glad_glMapBuffer;
PFNGLCLEARTEXIMAGEPROC glad_glClearTexImage;
PFNGLVERTEXATTRIBLFORMATPROC glad_glVertexAttribLFormat;
PFNGLCOMPRESSEDTEXIMAGE3DPROC glad_glCompressedTexImage3D;
PFNGLDELETESYNCPROC glad_glDeleteSync;
PFNGLCOPYTEXSUBIMAGE3DPROC glad_glCopyTexSubImage3D;
PFNGLGETTRANSFORMFEEDBACKI64_VPROC glad_glGetTransformFeedbacki64_v;
PFNGLUNIFORMMATRIX4DVPROC glad_glUniformMatrix4dv;
PFNGLGETVERTEXATTRIBIVPROC glad_glGetVertexAttribiv;
PFNGLUNIFORMMATRIX4X2DVPROC glad_glUniformMatrix4x2dv;
PFNGLMULTIDRAWELEMENTSPROC glad_glMultiDrawElements;
PFNGLVERTEXATTRIB3FVPROC glad_glVertexAttrib3fv;
PFNGLUNIFORM3IVPROC glad_glUniform3iv;
PFNGLPOLYGONMODEPROC glad_glPolygonMode;
PFNGLDRAWBUFFERSPROC glad_glDrawBuffers;
PFNGLGETNHISTOGRAMPROC glad_glGetnHistogram;
PFNGLGETACTIVEUNIFORMBLOCKIVPROC glad_glGetActiveUniformBlockiv;
PFNGLNAMEDFRAMEBUFFERREADBUFFERPROC glad_glNamedFramebufferReadBuffer;
PFNGLPROGRAMUNIFORM4IVPROC glad_glProgramUniform4iv;
PFNGLGETPROGRAMBINARYPROC glad_glGetProgramBinary;
PFNGLUSEPROGRAMPROC glad_glUseProgram;
PFNGLGETPROGRAMINFOLOGPROC glad_glGetProgramInfoLog;
PFNGLBINDTRANSFORMFEEDBACKPROC glad_glBindTransformFeedback;
PFNGLBINDVERTEXARRAYPROC glad_glBindVertexArray;
PFNGLDELETEBUFFERSPROC glad_glDeleteBuffers;
PFNGLGENERATETEXTUREMIPMAPPROC glad_glGenerateTextureMipmap;
PFNGLSAMPLERPARAMETERIIVPROC glad_glSamplerParameterIiv;
PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC glad_glMultiDrawElementsBaseVertex;
PFNGLNAMEDBUFFERSUBDATAPROC glad_glNamedBufferSubData;
PFNGLTEXTURESTORAGE2DPROC glad_glTextureStorage2D;
PFNGLGETNCONVOLUTIONFILTERPROC glad_glGetnConvolutionFilter;
PFNGLUNIFORM2UIVPROC glad_glUniform2uiv;
PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC glad_glCompressedTexSubImage1D;
PFNGLFINISHPROC glad_glFinish;
PFNGLDEPTHRANGEINDEXEDPROC glad_glDepthRangeIndexed;
PFNGLDELETESHADERPROC glad_glDeleteShader;
PFNGLGETINTERNALFORMATI64VPROC glad_glGetInternalformati64v;
PFNGLCOPYTEXTURESUBIMAGE1DPROC glad_glCopyTextureSubImage1D;
PFNGLPUSHDEBUGGROUPPROC glad_glPushDebugGroup;
PFNGLVERTEXATTRIB4NSVPROC glad_glVertexAttrib4Nsv;
PFNGLGETPROGRAMRESOURCELOCATIONINDEXPROC glad_glGetProgramResourceLocationIndex;
PFNGLTEXTUREPARAMETERIUIVPROC glad_glTextureParameterIuiv;
PFNGLVIEWPORTPROC glad_glViewport;
PFNGLUNIFORM1UIVPROC glad_glUniform1uiv;
PFNGLTRANSFORMFEEDBACKVARYINGSPROC glad_glTransformFeedbackVaryings;
PFNGLUNIFORM2UIPROC glad_glUniform2ui;
PFNGLGETNMAPDVPROC glad_glGetnMapdv;
PFNGLDEBUGMESSAGECALLBACKPROC glad_glDebugMessageCallback;
PFNGLVERTEXATTRIBI3IPROC glad_glVertexAttribI3i;
PFNGLINVALIDATETEXIMAGEPROC glad_glInvalidateTexImage;
PFNGLVERTEXATTRIBFORMATPROC glad_glVertexAttribFormat;
PFNGLCLEARDEPTHPROC glad_glClearDepth;
PFNGLVERTEXATTRIBI4USVPROC glad_glVertexAttribI4usv;
PFNGLTEXPARAMETERFPROC glad_glTexParameterf;
PFNGLVERTEXATTRIBBINDINGPROC glad_glVertexAttribBinding;
PFNGLTEXPARAMETERIPROC glad_glTexParameteri;
PFNGLGETACTIVESUBROUTINEUNIFORMIVPROC glad_glGetActiveSubroutineUniformiv;
PFNGLGETSHADERSOURCEPROC glad_glGetShaderSource;
PFNGLGETNTEXIMAGEPROC glad_glGetnTexImage;
PFNGLTEXBUFFERPROC glad_glTexBuffer;
PFNGLPIXELSTOREIPROC glad_glPixelStorei;
PFNGLVALIDATEPROGRAMPROC glad_glValidateProgram;
PFNGLPIXELSTOREFPROC glad_glPixelStoref;
PFNGLCREATEBUFFERSPROC glad_glCreateBuffers;
PFNGLGETBOOLEANI_VPROC glad_glGetBooleani_v;
PFNGLCLIPCONTROLPROC glad_glClipControl;
PFNGLMULTITEXCOORDP2UIVPROC glad_glMultiTexCoordP2uiv;
PFNGLGENPROGRAMPIPELINESPROC glad_glGenProgramPipelines;
PFNGLGETINTERNALFORMATIVPROC glad_glGetInternalformativ;
PFNGLCOPYTEXTURESUBIMAGE3DPROC glad_glCopyTextureSubImage3D;
PFNGLVERTEXATTRIBP1UIVPROC glad_glVertexAttribP1uiv;
PFNGLLINKPROGRAMPROC glad_glLinkProgram;
PFNGLBINDTEXTUREPROC glad_glBindTexture;
PFNGLMULTIDRAWARRAYSINDIRECTPROC glad_glMultiDrawArraysIndirect;
PFNGLGETOBJECTLABELPROC glad_glGetObjectLabel;
PFNGLGETPROGRAMPIPELINEINFOLOGPROC glad_glGetProgramPipelineInfoLog;
PFNGLGETSTRINGPROC glad_glGetString;
PFNGLVERTEXATTRIBP2UIVPROC glad_glVertexAttribP2uiv;
PFNGLDETACHSHADERPROC glad_glDetachShader;
PFNGLPROGRAMUNIFORM3IPROC glad_glProgramUniform3i;
PFNGLUNIFORMMATRIX3X4DVPROC glad_glUniformMatrix3x4dv;
PFNGLENDQUERYPROC glad_glEndQuery;
PFNGLNORMALP3UIPROC glad_glNormalP3ui;
PFNGLFRAMEBUFFERPARAMETERIPROC glad_glFramebufferParameteri;
PFNGLGETPROGRAMRESOURCENAMEPROC glad_glGetProgramResourceName;
PFNGLUNIFORMMATRIX4X3DVPROC glad_glUniformMatrix4x3dv;
PFNGLDEPTHRANGEARRAYVPROC glad_glDepthRangeArrayv;
PFNGLVERTEXATTRIBI2UIPROC glad_glVertexAttribI2ui;
PFNGLGETPROGRAMRESOURCELOCATIONPROC glad_glGetProgramResourceLocation;
PFNGLDELETETEXTURESPROC glad_glDeleteTextures;
PFNGLGETACTIVEATOMICCOUNTERBUFFERIVPROC glad_glGetActiveAtomicCounterBufferiv;
PFNGLSTENCILOPSEPARATEPROC glad_glStencilOpSeparate;
PFNGLDELETEQUERIESPROC glad_glDeleteQueries;
PFNGLNORMALP3UIVPROC glad_glNormalP3uiv;
PFNGLVERTEXATTRIB4FPROC glad_glVertexAttrib4f;
PFNGLVERTEXATTRIB4DPROC glad_glVertexAttrib4d;
PFNGLVIEWPORTINDEXEDFVPROC glad_glViewportIndexedfv;
PFNGLBINDBUFFERSBASEPROC glad_glBindBuffersBase;
PFNGLVERTEXATTRIBL4DVPROC glad_glVertexAttribL4dv;
PFNGLGETTEXPARAMETERIVPROC glad_glGetTexParameteriv;
PFNGLCREATEVERTEXARRAYSPROC glad_glCreateVertexArrays;
PFNGLPROGRAMUNIFORM1DVPROC glad_glProgramUniform1dv;
PFNGLVERTEXATTRIB4SPROC glad_glVertexAttrib4s;
PFNGLDRAWELEMENTSBASEVERTEXPROC glad_glDrawElementsBaseVertex;
PFNGLSAMPLECOVERAGEPROC glad_glSampleCoverage;
PFNGLSAMPLERPARAMETERIPROC glad_glSamplerParameteri;
PFNGLCLEARBUFFERSUBDATAPROC glad_glClearBufferSubData;
PFNGLSAMPLERPARAMETERFPROC glad_glSamplerParameterf;
PFNGLTEXSTORAGE1DPROC glad_glTexStorage1D;
PFNGLUNIFORM1FPROC glad_glUniform1f;
PFNGLGETVERTEXATTRIBFVPROC glad_glGetVertexAttribfv;
PFNGLUNIFORM1DPROC glad_glUniform1d;
PFNGLGETCOMPRESSEDTEXIMAGEPROC glad_glGetCompressedTexImage;
PFNGLGETNCOMPRESSEDTEXIMAGEPROC glad_glGetnCompressedTexImage;
PFNGLUNIFORM1IPROC glad_glUniform1i;
PFNGLGETACTIVEATTRIBPROC glad_glGetActiveAttrib;
PFNGLTEXSUBIMAGE2DPROC glad_glTexSubImage2D;
PFNGLDISABLEPROC glad_glDisable;
PFNGLLOGICOPPROC glad_glLogicOp;
PFNGLPROGRAMUNIFORMMATRIX3X4FVPROC glad_glProgramUniformMatrix3x4fv;
PFNGLGETTEXTUREPARAMETERIUIVPROC glad_glGetTextureParameterIuiv;
PFNGLPROGRAMUNIFORM4UIVPROC glad_glProgramUniform4uiv;
PFNGLUNIFORM4UIPROC glad_glUniform4ui;
PFNGLCOPYTEXTURESUBIMAGE2DPROC glad_glCopyTextureSubImage2D;
PFNGLBINDFRAMEBUFFERPROC glad_glBindFramebuffer;
PFNGLCULLFACEPROC glad_glCullFace;
PFNGLPROGRAMUNIFORM4IPROC glad_glProgramUniform4i;
PFNGLPROGRAMUNIFORM4FPROC glad_glProgramUniform4f;
PFNGLVIEWPORTINDEXEDFPROC glad_glViewportIndexedf;
PFNGLPROGRAMUNIFORM4DPROC glad_glProgramUniform4d;
PFNGLTEXTUREPARAMETERIIVPROC glad_glTextureParameterIiv;
PFNGLGETSTRINGIPROC glad_glGetStringi;
PFNGLTEXTURESUBIMAGE2DPROC glad_glTextureSubImage2D;
PFNGLSCISSORINDEXEDPROC glad_glScissorIndexed;
PFNGLDRAWTRANSFORMFEEDBACKSTREAMPROC glad_glDrawTransformFeedbackStream;
PFNGLATTACHSHADERPROC glad_glAttachShader;
PFNGLQUERYCOUNTERPROC glad_glQueryCounter;
PFNGLPROVOKINGVERTEXPROC glad_glProvokingVertex;
PFNGLSHADERBINARYPROC glad_glShaderBinary;
PFNGLUNMAPNAMEDBUFFERPROC glad_glUnmapNamedBuffer;
PFNGLDRAWELEMENTSPROC glad_glDrawElements;
PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEPROC glad_glNamedRenderbufferStorageMultisample;
PFNGLVERTEXATTRIBI4SVPROC glad_glVertexAttribI4sv;
PFNGLCLEARNAMEDBUFFERDATAPROC glad_glClearNamedBufferData;
PFNGLUNIFORM1IVPROC glad_glUniform1iv;
PFNGLCREATESHADERPROGRAMVPROC glad_glCreateShaderProgramv;
PFNGLGETQUERYOBJECTIVPROC glad_glGetQueryObjectiv;
PFNGLREADBUFFERPROC glad_glReadBuffer;
PFNGLTEXPARAMETERIUIVPROC glad_glTexParameterIuiv;
PFNGLDRAWARRAYSINSTANCEDPROC glad_glDrawArraysInstanced;
PFNGLGENERATEMIPMAPPROC glad_glGenerateMipmap;
PFNGLCOMPRESSEDTEXTURESUBIMAGE2DPROC glad_glCompressedTextureSubImage2D;
PFNGLPROGRAMUNIFORMMATRIX2FVPROC glad_glProgramUniformMatrix2fv;
PFNGLSAMPLERPARAMETERIVPROC glad_glSamplerParameteriv;
PFNGLVERTEXATTRIB3FPROC glad_glVertexAttrib3f;
PFNGLVERTEXATTRIB4UIVPROC glad_glVertexAttrib4uiv;
PFNGLPOINTPARAMETERIPROC glad_glPointParameteri;
PFNGLBLENDCOLORPROC glad_glBlendColor;
PFNGLSAMPLERPARAMETERIUIVPROC glad_glSamplerParameterIuiv;
PFNGLCHECKNAMEDFRAMEBUFFERSTATUSPROC glad_glCheckNamedFramebufferStatus;
PFNGLUNMAPBUFFERPROC glad_glUnmapBuffer;
PFNGLPOINTPARAMETERFPROC glad_glPointParameterf;
PFNGLPROGRAMUNIFORM1IVPROC glad_glProgramUniform1iv;
PFNGLGETVERTEXARRAYIVPROC glad_glGetVertexArrayiv;
PFNGLVERTEXATTRIB3SPROC glad_glVertexAttrib3s;
PFNGLBINDRENDERBUFFERPROC glad_glBindRenderbuffer;
PFNGLVERTEXATTRIBP4UIVPROC glad_glVertexAttribP4uiv;
PFNGLGETPROGRAMSTAGEIVPROC glad_glGetProgramStageiv;
PFNGLISPROGRAMPROC glad_glIsProgram;
PFNGLVERTEXATTRIB4BVPROC glad_glVertexAttrib4bv;
PFNGLTEXTURESTORAGE3DPROC glad_glTextureStorage3D;
PFNGLUNIFORMMATRIX3X2DVPROC glad_glUniformMatrix3x2dv;
PFNGLVERTEXATTRIB4FVPROC glad_glVertexAttrib4fv;
PFNGLPROGRAMUNIFORMMATRIX2X3DVPROC glad_glProgramUniformMatrix2x3dv;
PFNGLISTRANSFORMFEEDBACKPROC glad_glIsTransformFeedback;
PFNGLUNIFORM4IPROC glad_glUniform4i;
PFNGLACTIVETEXTUREPROC glad_glActiveTexture;
PFNGLENABLEVERTEXATTRIBARRAYPROC glad_glEnableVertexAttribArray;
PFNGLISPROGRAMPIPELINEPROC glad_glIsProgramPipeline;
PFNGLREADPIXELSPROC glad_glReadPixels;
PFNGLVERTEXATTRIBI3IVPROC glad_glVertexAttribI3iv;
PFNGLUNIFORM4FPROC glad_glUniform4f;
PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC glad_glRenderbufferStorageMultisample;
PFNGLCREATEPROGRAMPIPELINESPROC glad_glCreateProgramPipelines;
PFNGLUNIFORMMATRIX3FVPROC glad_glUniformMatrix3fv;
PFNGLVERTEXATTRIBLPOINTERPROC glad_glVertexAttribLPointer;
PFNGLGETNUNIFORMFVPROC glad_glGetnUniformfv;
PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC glad_glDrawElementsInstancedBaseVertex;
PFNGLVERTEXATTRIBL2DVPROC glad_glVertexAttribL2dv;
PFNGLENABLEVERTEXARRAYATTRIBPROC glad_glEnableVertexArrayAttrib;
PFNGLDRAWTRANSFORMFEEDBACKSTREAMINSTANCEDPROC glad_glDrawTransformFeedbackStreamInstanced;
PFNGLGETACTIVESUBROUTINENAMEPROC glad_glGetActiveSubroutineName;
PFNGLVERTEXATTRIBL2DPROC glad_glVertexAttribL2d;
PFNGLSTENCILFUNCPROC glad_glStencilFunc;
PFNGLINVALIDATENAMEDFRAMEBUFFERDATAPROC glad_glInvalidateNamedFramebufferData;
PFNGLPOPDEBUGGROUPPROC glad_glPopDebugGroup;
PFNGLUNIFORMBLOCKBINDINGPROC glad_glUniformBlockBinding;
PFNGLGETVERTEXARRAYINDEXEDIVPROC glad_glGetVertexArrayIndexediv;
PFNGLCOLORP4UIPROC glad_glColorP4ui;
PFNGLUSEPROGRAMSTAGESPROC glad_glUseProgramStages;
PFNGLPROGRAMUNIFORM3FPROC glad_glProgramUniform3f;
PFNGLPROGRAMUNIFORM3DPROC glad_glProgramUniform3d;
PFNGLVERTEXATTRIBI4IVPROC glad_glVertexAttribI4iv;
PFNGLGETPROGRAMPIPELINEIVPROC glad_glGetProgramPipelineiv;
PFNGLTEXSTORAGE3DPROC glad_glTexStorage3D;
PFNGLNAMEDFRAMEBUFFERDRAWBUFFERPROC glad_glNamedFramebufferDrawBuffer;
PFNGLGETQUERYINDEXEDIVPROC glad_glGetQueryIndexediv;
PFNGLGETSHADERINFOLOGPROC glad_glGetShaderInfoLog;
PFNGLOBJECTLABELPROC glad_glObjectLabel;
PFNGLVERTEXATTRIBI4IPROC glad_glVertexAttribI4i;
PFNGLGETBUFFERSUBDATAPROC glad_glGetBufferSubData;
PFNGLGETVERTEXATTRIBLDVPROC glad_glGetVertexAttribLdv;
PFNGLGETNUNIFORMUIVPROC glad_glGetnUniformuiv;
PFNGLGETQUERYBUFFEROBJECTIVPROC glad_glGetQueryBufferObjectiv;
PFNGLBLENDEQUATIONSEPARATEPROC glad_glBlendEquationSeparate;
PFNGLVERTEXATTRIBI1UIPROC glad_glVertexAttribI1ui;
PFNGLGENBUFFERSPROC glad_glGenBuffers;
PFNGLGETSUBROUTINEINDEXPROC glad_glGetSubroutineIndex;
PFNGLVERTEXATTRIB2SVPROC glad_glVertexAttrib2sv;
PFNGLGETNPOLYGONSTIPPLEPROC glad_glGetnPolygonStipple;
PFNGLBLENDFUNCPROC glad_glBlendFunc;
PFNGLCREATEPROGRAMPROC glad_glCreateProgram;
PFNGLTEXIMAGE3DPROC glad_glTexImage3D;
PFNGLISFRAMEBUFFERPROC glad_glIsFramebuffer;
PFNGLCLEARNAMEDFRAMEBUFFERFVPROC glad_glClearNamedFramebufferfv;
PFNGLGETNAMEDBUFFERSUBDATAPROC glad_glGetNamedBufferSubData;
PFNGLPRIMITIVERESTARTINDEXPROC glad_glPrimitiveRestartIndex;
PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEPROC glad_glFlushMappedNamedBufferRange;
PFNGLINVALIDATETEXSUBIMAGEPROC glad_glInvalidateTexSubImage;
PFNGLBINDIMAGETEXTURESPROC glad_glBindImageTextures;
PFNGLGETINTEGER64VPROC glad_glGetInteger64v;
PFNGLBINDPROGRAMPIPELINEPROC glad_glBindProgramPipeline;
PFNGLSCISSORPROC glad_glScissor;
PFNGLTEXCOORDP4UIVPROC glad_glTexCoordP4uiv;
PFNGLGETBOOLEANVPROC glad_glGetBooleanv;
PFNGLNAMEDFRAMEBUFFERRENDERBUFFERPROC glad_glNamedFramebufferRenderbuffer;
PFNGLVERTEXP2UIVPROC glad_glVertexP2uiv;
PFNGLUNIFORM3UIVPROC glad_glUniform3uiv;
PFNGLCLEARCOLORPROC glad_glClearColor;
PFNGLVERTEXATTRIB4NIVPROC glad_glVertexAttrib4Niv;
PFNGLCLEARBUFFERIVPROC glad_glClearBufferiv;
PFNGLGETBUFFERPARAMETERI64VPROC glad_glGetBufferParameteri64v;
PFNGLPROGRAMUNIFORM4DVPROC glad_glProgramUniform4dv;
PFNGLCOLORP4UIVPROC glad_glColorP4uiv;
PFNGLGETTEXTURELEVELPARAMETERIVPROC glad_glGetTextureLevelParameteriv;
PFNGLGETNUNIFORMIVPROC glad_glGetnUniformiv;
PFNGLVERTEXATTRIBI2UIVPROC glad_glVertexAttribI2uiv;
PFNGLUNIFORM3UIPROC glad_glUniform3ui;
PFNGLPROGRAMUNIFORM3UIVPROC glad_glProgramUniform3uiv;
PFNGLVERTEXATTRIBI4UIVPROC glad_glVertexAttribI4uiv;
PFNGLPOINTPARAMETERFVPROC glad_glPointParameterfv;
PFNGLUNIFORM2FVPROC glad_glUniform2fv;
PFNGLGETACTIVESUBROUTINEUNIFORMNAMEPROC glad_glGetActiveSubroutineUniformName;
PFNGLGETPROGRAMRESOURCEINDEXPROC glad_glGetProgramResourceIndex;
PFNGLDRAWELEMENTSINDIRECTPROC glad_glDrawElementsIndirect;
PFNGLGETTEXTURELEVELPARAMETERFVPROC glad_glGetTextureLevelParameterfv;
PFNGLGETNAMEDBUFFERPOINTERVPROC glad_glGetNamedBufferPointerv;
PFNGLDISPATCHCOMPUTEINDIRECTPROC glad_glDispatchComputeIndirect;
PFNGLINVALIDATENAMEDFRAMEBUFFERSUBDATAPROC glad_glInvalidateNamedFramebufferSubData;
PFNGLGETSAMPLERPARAMETERIUIVPROC glad_glGetSamplerParameterIuiv;
PFNGLBINDBUFFERRANGEPROC glad_glBindBufferRange;
PFNGLTEXTURESUBIMAGE1DPROC glad_glTextureSubImage1D;
PFNGLVERTEXATTRIBL3DVPROC glad_glVertexAttribL3dv;
PFNGLGETUNIFORMDVPROC glad_glGetUniformdv;
PFNGLGETQUERYBUFFEROBJECTUI64VPROC glad_glGetQueryBufferObjectui64v;
PFNGLCLEARDEPTHFPROC glad_glClearDepthf;
PFNGLCREATERENDERBUFFERSPROC glad_glCreateRenderbuffers;
PFNGLUNIFORMMATRIX2X3FVPROC glad_glUniformMatrix2x3fv;
PFNGLGENTRANSFORMFEEDBACKSPROC glad_glGenTransformFeedbacks;
PFNGLGETVERTEXATTRIBIUIVPROC glad_glGetVertexAttribIuiv;
PFNGLVERTEXATTRIB4NUSVPROC glad_glVertexAttrib4Nusv;
PFNGLPROGRAMUNIFORMMATRIX4X3DVPROC glad_glProgramUniformMatrix4x3dv;
PFNGLDEPTHFUNCPROC glad_glDepthFunc;
PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC glad_glCompressedTexSubImage2D;
PFNGLPROGRAMBINARYPROC glad_glProgramBinary;
PFNGLVERTEXATTRIBI4BVPROC glad_glVertexAttribI4bv;
PFNGLGETTEXPARAMETERFVPROC glad_glGetTexParameterfv;
PFNGLMULTITEXCOORDP1UIPROC glad_glMultiTexCoordP1ui;
PFNGLBUFFERSTORAGEPROC glad_glBufferStorage;
PFNGLCLIENTWAITSYNCPROC glad_glClientWaitSync;
PFNGLVERTEXATTRIBI4UIPROC glad_glVertexAttribI4ui;
PFNGLGETFLOATI_VPROC glad_glGetFloati_v;
PFNGLCOLORMASKPROC glad_glColorMask;
PFNGLTEXTUREBUFFERPROC glad_glTextureBuffer;
PFNGLTEXPARAMETERIIVPROC glad_glTexParameterIiv;
PFNGLBLENDEQUATIONPROC glad_glBlendEquation;
PFNGLGETUNIFORMLOCATIONPROC glad_glGetUniformLocation;
PFNGLUNIFORMMATRIX2X4DVPROC glad_glUniformMatrix2x4dv;
PFNGLVERTEXARRAYATTRIBFORMATPROC glad_glVertexArrayAttribFormat;
PFNGLREADNPIXELSPROC glad_glReadnPixels;
PFNGLNAMEDFRAMEBUFFERDRAWBUFFERSPROC glad_glNamedFramebufferDrawBuffers;
PFNGLENDTRANSFORMFEEDBACKPROC glad_glEndTransformFeedback;
PFNGLVERTEXATTRIB4USVPROC glad_glVertexAttrib4usv;
PFNGLGETUNIFORMSUBROUTINEUIVPROC glad_glGetUniformSubroutineuiv;
PFNGLUNIFORM4FVPROC glad_glUniform4fv;
PFNGLBINDVERTEXBUFFERPROC glad_glBindVertexBuffer;
PFNGLDEBUGMESSAGEINSERTPROC glad_glDebugMessageInsert;
PFNGLCREATESAMPLERSPROC glad_glCreateSamplers;
PFNGLGETPROGRAMRESOURCEIVPROC glad_glGetProgramResourceiv;
PFNGLCLEARBUFFERDATAPROC glad_glClearBufferData;
PFNGLBEGINTRANSFORMFEEDBACKPROC glad_glBeginTransformFeedback;
PFNGLVERTEXATTRIBI1IVPROC glad_glVertexAttribI1iv;
PFNGLISSAMPLERPROC glad_glIsSampler;
PFNGLVERTEXP3UIPROC glad_glVertexP3ui;
PFNGLVERTEXATTRIBDIVISORPROC glad_glVertexAttribDivisor;
PFNGLBINDSAMPLERSPROC glad_glBindSamplers;
PFNGLCOMPRESSEDTEXIMAGE1DPROC glad_glCompressedTexImage1D;
PFNGLDELETETRANSFORMFEEDBACKSPROC glad_glDeleteTransformFeedbacks;
PFNGLCOPYTEXSUBIMAGE1DPROC glad_glCopyTexSubImage1D;
PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC glad_glDrawRangeElementsBaseVertex;
PFNGLCHECKFRAMEBUFFERSTATUSPROC glad_glCheckFramebufferStatus;
PFNGLENDCONDITIONALRENDERPROC glad_glEndConditionalRender;
PFNGLVERTEXP3UIVPROC glad_glVertexP3uiv;
PFNGLBINDATTRIBLOCATIONPROC glad_glBindAttribLocation;
PFNGLUNIFORMMATRIX4X2FVPROC glad_glUniformMatrix4x2fv;
PFNGLUNIFORMMATRIX2DVPROC glad_glUniformMatrix2dv;
PFNGLBLENDFUNCIPROC glad_glBlendFunci;
PFNGLVERTEXATTRIB1DVPROC glad_glVertexAttrib1dv;
PFNGLDRAWRANGEELEMENTSPROC glad_glDrawRangeElements;
PFNGLGETQUERYOBJECTUIVPROC glad_glGetQueryObjectuiv;
PFNGLBINDBUFFERBASEPROC glad_glBindBufferBase;
PFNGLBUFFERSUBDATAPROC glad_glBufferSubData;
PFNGLVERTEXATTRIB4IVPROC glad_glVertexAttrib4iv;
PFNGLMAPBUFFERRANGEPROC glad_glMapBufferRange;
PFNGLFRAMEBUFFERTEXTUREPROC glad_glFramebufferTexture;
PFNGLBLENDFUNCSEPARATEIPROC glad_glBlendFuncSeparatei;
PFNGLPROGRAMUNIFORMMATRIX4X2FVPROC glad_glProgramUniformMatrix4x2fv;
PFNGLVERTEXATTRIBL1DPROC glad_glVertexAttribL1d;
PFNGLMULTIDRAWARRAYSPROC glad_glMultiDrawArrays;
PFNGLVERTEXP4UIVPROC glad_glVertexP4uiv;
PFNGLVERTEXATTRIBI2IVPROC glad_glVertexAttribI2iv;
PFNGLGETSHADERPRECISIONFORMATPROC glad_glGetShaderPrecisionFormat;
PFNGLTEXTUREVIEWPROC glad_glTextureView;
PFNGLDISABLEIPROC glad_glDisablei;
PFNGLPROGRAMUNIFORMMATRIX2X4FVPROC glad_glProgramUniformMatrix2x4fv;
PFNGLSHADERSOURCEPROC glad_glShaderSource;
PFNGLGETNSEPARABLEFILTERPROC glad_glGetnSeparableFilter;
PFNGLDELETERENDERBUFFERSPROC glad_glDeleteRenderbuffers;
PFNGLVERTEXATTRIBI3UIVPROC glad_glVertexAttribI3uiv;
PFNGLRELEASESHADERCOMPILERPROC glad_glReleaseShaderCompiler;
PFNGLVERTEXATTRIBIFORMATPROC glad_glVertexAttribIFormat;
PFNGLCREATEFRAMEBUFFERSPROC glad_glCreateFramebuffers;
PFNGLGETSYNCIVPROC glad_glGetSynciv;
PFNGLGETNPIXELMAPFVPROC glad_glGetnPixelMapfv;
PFNGLTEXCOORDP2UIVPROC glad_glTexCoordP2uiv;
PFNGLPATCHPARAMETERFVPROC glad_glPatchParameterfv;
PFNGLPROGRAMUNIFORM2IPROC glad_glProgramUniform2i;
PFNGLGETNAMEDBUFFERPARAMETERI64VPROC glad_glGetNamedBufferParameteri64v;
PFNGLBEGINQUERYPROC glad_glBeginQuery;
PFNGLUNIFORMMATRIX4FVPROC glad_glUniformMatrix4fv;
PFNGLBINDBUFFERPROC glad_glBindBuffer;
PFNGLTEXSTORAGE2DMULTISAMPLEPROC glad_glTexStorage2DMultisample;
PFNGLPROGRAMUNIFORM2DPROC glad_glProgramUniform2d;
PFNGLPROGRAMUNIFORM2FPROC glad_glProgramUniform2f;
PFNGLUNIFORMMATRIX2FVPROC glad_glUniformMatrix2fv;
PFNGLUNIFORMMATRIX2X4FVPROC glad_glUniformMatrix2x4fv;
PFNGLBUFFERDATAPROC glad_glBufferData;
PFNGLGETTEXPARAMETERIIVPROC glad_glGetTexParameterIiv;
PFNGLTEXCOORDP1UIPROC glad_glTexCoordP1ui;
PFNGLGETERRORPROC glad_glGetError;
PFNGLCREATETRANSFORMFEEDBACKSPROC glad_glCreateTransformFeedbacks;
PFNGLVERTEXATTRIBP2UIPROC glad_glVertexAttribP2ui;
PFNGLGETFLOATVPROC glad_glGetFloatv;
PFNGLTEXSUBIMAGE1DPROC glad_glTexSubImage1D;
PFNGLVERTEXATTRIB2FVPROC glad_glVertexAttrib2fv;
PFNGLGETTEXLEVELPARAMETERFVPROC glad_glGetTexLevelParameterfv;
PFNGLVERTEXATTRIBI1IPROC glad_glVertexAttribI1i;
PFNGLVERTEXATTRIBP3UIVPROC glad_glVertexAttribP3uiv;
PFNGLUNIFORM4DPROC glad_glUniform4d;
PFNGLSECONDARYCOLORP3UIVPROC glad_glSecondaryColorP3uiv;
PFNGLGETINTEGERVPROC glad_glGetIntegerv;
PFNGLGETVERTEXARRAYINDEXED64IVPROC glad_glGetVertexArrayIndexed64iv;
PFNGLGETBUFFERPOINTERVPROC glad_glGetBufferPointerv;
PFNGLPROGRAMUNIFORMMATRIX3DVPROC glad_glProgramUniformMatrix3dv;
PFNGLFRAMEBUFFERTEXTURE3DPROC glad_glFramebufferTexture3D;
PFNGLISQUERYPROC glad_glIsQuery;
PFNGLPROGRAMUNIFORM2UIPROC glad_glProgramUniform2ui;
PFNGLPROGRAMUNIFORM4UIPROC glad_glProgramUniform4ui;
PFNGLVERTEXATTRIB4SVPROC glad_glVertexAttrib4sv;
PFNGLTEXIMAGE2DPROC glad_glTexImage2D;
PFNGLSTENCILMASKPROC glad_glStencilMask;
PFNGLSAMPLERPARAMETERFVPROC glad_glSamplerParameterfv;
PFNGLISTEXTUREPROC glad_glIsTexture;
PFNGLNAMEDBUFFERDATAPROC glad_glNamedBufferData;
PFNGLUNIFORM1FVPROC glad_glUniform1fv;
PFNGLVERTEXATTRIB4NUBVPROC glad_glVertexAttrib4Nubv;
PFNGLCLEARNAMEDBUFFERSUBDATAPROC glad_glClearNamedBufferSubData;
PFNGLTEXPARAMETERFVPROC glad_glTexParameterfv;
PFNGLSCISSORINDEXEDVPROC glad_glScissorIndexedv;
PFNGLUNIFORM3DVPROC glad_glUniform3dv;
PFNGLGETNPIXELMAPUIVPROC glad_glGetnPixelMapuiv;
PFNGLPROGRAMUNIFORM3FVPROC glad_glProgramUniform3fv;
PFNGLGETSUBROUTINEUNIFORMLOCATIONPROC glad_glGetSubroutineUniformLocation;
PFNGLGETFRAMEBUFFERPARAMETERIVPROC glad_glGetFramebufferParameteriv;
PFNGLGETSAMPLERPARAMETERIVPROC glad_glGetSamplerParameteriv;
PFNGLGETCOMPRESSEDTEXTURESUBIMAGEPROC glad_glGetCompressedTextureSubImage;
PFNGLCOPYBUFFERSUBDATAPROC glad_glCopyBufferSubData;
PFNGLVERTEXATTRIBI1UIVPROC glad_glVertexAttribI1uiv;
PFNGLVERTEXATTRIB2DPROC glad_glVertexAttrib2d;
PFNGLVERTEXATTRIB2FPROC glad_glVertexAttrib2f;
PFNGLVERTEXATTRIB3DVPROC glad_glVertexAttrib3dv;
PFNGLGETQUERYOBJECTUI64VPROC glad_glGetQueryObjectui64v;
PFNGLDEPTHMASKPROC glad_glDepthMask;
PFNGLVERTEXATTRIB2SPROC glad_glVertexAttrib2s;
PFNGLTEXIMAGE3DMULTISAMPLEPROC glad_glTexImage3DMultisample;
PFNGLPROGRAMUNIFORM1FVPROC glad_glProgramUniform1fv;
PFNGLGETUNIFORMBLOCKINDEXPROC glad_glGetUniformBlockIndex;
PFNGLTEXIMAGE2DMULTISAMPLEPROC glad_glTexImage2DMultisample;
PFNGLGETACTIVEUNIFORMPROC glad_glGetActiveUniform;
PFNGLFRONTFACEPROC glad_glFrontFace;
PFNGLTEXBUFFERRANGEPROC glad_glTexBufferRange;
PFNGLNAMEDFRAMEBUFFERTEXTURELAYERPROC glad_glNamedFramebufferTextureLayer;
PFNGLNAMEDFRAMEBUFFERPARAMETERIPROC glad_glNamedFramebufferParameteri;
PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEPROC glad_glDrawArraysInstancedBaseInstance;
PFNGLDELETEPROGRAMPIPELINESPROC glad_glDeleteProgramPipelines;
int GLAD_GL_SGIX_pixel_tiles;
int GLAD_GL_EXT_post_depth_coverage;
int GLAD_GL_APPLE_element_array;
int GLAD_GL_AMD_multi_draw_indirect;
int GLAD_GL_EXT_blend_subtract;
int GLAD_GL_SGIX_tag_sample_buffer;
int GLAD_GL_NV_point_sprite;
int GLAD_GL_IBM_texture_mirrored_repeat;
int GLAD_GL_APPLE_transform_hint;
int GLAD_GL_ATI_separate_stencil;
int GLAD_GL_NV_shader_atomic_int64;
int GLAD_GL_NV_vertex_program2_option;
int GLAD_GL_EXT_texture_buffer_object;
int GLAD_GL_ARB_vertex_blend;
int GLAD_GL_OVR_multiview;
int GLAD_GL_NV_vertex_program2;
int GLAD_GL_ARB_program_interface_query;
int GLAD_GL_EXT_misc_attribute;
int GLAD_GL_NV_multisample_coverage;
int GLAD_GL_ARB_shading_language_packing;
int GLAD_GL_EXT_texture_cube_map;
int GLAD_GL_NV_viewport_array2;
int GLAD_GL_ARB_texture_stencil8;
int GLAD_GL_EXT_index_func;
int GLAD_GL_OES_compressed_paletted_texture;
int GLAD_GL_NV_depth_clamp;
int GLAD_GL_NV_shader_buffer_load;
int GLAD_GL_EXT_color_subtable;
int GLAD_GL_SUNX_constant_data;
int GLAD_GL_EXT_texture_compression_s3tc;
int GLAD_GL_EXT_multi_draw_arrays;
int GLAD_GL_ARB_shader_atomic_counters;
int GLAD_GL_ARB_arrays_of_arrays;
int GLAD_GL_NV_conditional_render;
int GLAD_GL_EXT_texture_env_combine;
int GLAD_GL_NV_fog_distance;
int GLAD_GL_SGIX_async_histogram;
int GLAD_GL_MESA_resize_buffers;
int GLAD_GL_NV_light_max_exponent;
int GLAD_GL_NV_texture_env_combine4;
int GLAD_GL_ARB_texture_view;
int GLAD_GL_ARB_texture_env_combine;
int GLAD_GL_ARB_map_buffer_range;
int GLAD_GL_EXT_convolution;
int GLAD_GL_NV_compute_program5;
int GLAD_GL_NV_vertex_attrib_integer_64bit;
int GLAD_GL_EXT_paletted_texture;
int GLAD_GL_ARB_texture_buffer_object;
int GLAD_GL_ATI_pn_triangles;
int GLAD_GL_SGIX_resample;
int GLAD_GL_SGIX_flush_raster;
int GLAD_GL_EXT_light_texture;
int GLAD_GL_ARB_point_sprite;
int GLAD_GL_SUN_convolution_border_modes;
int GLAD_GL_NV_parameter_buffer_object2;
int GLAD_GL_ARB_half_float_pixel;
int GLAD_GL_NV_tessellation_program5;
int GLAD_GL_REND_screen_coordinates;
int GLAD_GL_EXT_shared_texture_palette;
int GLAD_GL_EXT_packed_float;
int GLAD_GL_OML_subsample;
int GLAD_GL_SGIX_vertex_preclip;
int GLAD_GL_SGIX_texture_scale_bias;
int GLAD_GL_AMD_draw_buffers_blend;
int GLAD_GL_APPLE_texture_range;
int GLAD_GL_EXT_texture_array;
int GLAD_GL_NV_texture_barrier;
int GLAD_GL_ARB_texture_query_levels;
int GLAD_GL_NV_texgen_emboss;
int GLAD_GL_EXT_texture_swizzle;
int GLAD_GL_ARB_texture_rg;
int GLAD_GL_ARB_vertex_type_2_10_10_10_rev;
int GLAD_GL_ARB_fragment_shader;
int GLAD_GL_3DFX_tbuffer;
int GLAD_GL_GREMEDY_frame_terminator;
int GLAD_GL_ARB_blend_func_extended;
int GLAD_GL_EXT_separate_shader_objects;
int GLAD_GL_NV_texture_multisample;
int GLAD_GL_ARB_shader_objects;
int GLAD_GL_ARB_framebuffer_object;
int GLAD_GL_ATI_envmap_bumpmap;
int GLAD_GL_AMD_shader_explicit_vertex_parameter;
int GLAD_GL_ARB_robust_buffer_access_behavior;
int GLAD_GL_ARB_shader_stencil_export;
int GLAD_GL_NV_texture_rectangle;
int GLAD_GL_ARB_enhanced_layouts;
int GLAD_GL_ARB_texture_rectangle;
int GLAD_GL_SGI_texture_color_table;
int GLAD_GL_NV_viewport_swizzle;
int GLAD_GL_ATI_map_object_buffer;
int GLAD_GL_ARB_robustness;
int GLAD_GL_NV_pixel_data_range;
int GLAD_GL_EXT_framebuffer_blit;
int GLAD_GL_ARB_gpu_shader_fp64;
int GLAD_GL_NV_command_list;
int GLAD_GL_SGIX_depth_texture;
int GLAD_GL_EXT_vertex_weighting;
int GLAD_GL_GREMEDY_string_marker;
int GLAD_GL_ARB_texture_compression_bptc;
int GLAD_GL_EXT_subtexture;
int GLAD_GL_EXT_pixel_transform_color_table;
int GLAD_GL_EXT_texture_compression_rgtc;
int GLAD_GL_ARB_shader_atomic_counter_ops;
int GLAD_GL_SGIX_depth_pass_instrument;
int GLAD_GL_EXT_gpu_program_parameters;
int GLAD_GL_NV_evaluators;
int GLAD_GL_SGIS_texture_filter4;
int GLAD_GL_AMD_performance_monitor;
int GLAD_GL_NV_geometry_shader4;
int GLAD_GL_EXT_stencil_clear_tag;
int GLAD_GL_NV_vertex_program1_1;
int GLAD_GL_NV_present_video;
int GLAD_GL_ARB_texture_compression_rgtc;
int GLAD_GL_HP_convolution_border_modes;
int GLAD_GL_EXT_shader_integer_mix;
int GLAD_GL_SGIX_framezoom;
int GLAD_GL_ARB_stencil_texturing;
int GLAD_GL_ARB_shader_clock;
int GLAD_GL_NV_shader_atomic_fp16_vector;
int GLAD_GL_SGIX_fog_offset;
int GLAD_GL_ARB_draw_elements_base_vertex;
int GLAD_GL_INGR_interlace_read;
int GLAD_GL_NV_transform_feedback;
int GLAD_GL_NV_fragment_program;
int GLAD_GL_AMD_stencil_operation_extended;
int GLAD_GL_ARB_seamless_cubemap_per_texture;
int GLAD_GL_ARB_instanced_arrays;
int GLAD_GL_ARB_get_texture_sub_image;
int GLAD_GL_NV_vertex_array_range2;
int GLAD_GL_KHR_robustness;
int GLAD_GL_AMD_sparse_texture;
int GLAD_GL_ARB_clip_control;
int GLAD_GL_NV_fragment_coverage_to_color;
int GLAD_GL_NV_fence;
int GLAD_GL_ARB_texture_buffer_range;
int GLAD_GL_SUN_mesh_array;
int GLAD_GL_ARB_vertex_attrib_binding;
int GLAD_GL_ARB_framebuffer_no_attachments;
int GLAD_GL_ARB_cl_event;
int GLAD_GL_ARB_derivative_control;
int GLAD_GL_NV_packed_depth_stencil;
int GLAD_GL_OES_single_precision;
int GLAD_GL_NV_primitive_restart;
int GLAD_GL_SUN_global_alpha;
int GLAD_GL_ARB_fragment_shader_interlock;
int GLAD_GL_EXT_texture_object;
int GLAD_GL_AMD_name_gen_delete;
int GLAD_GL_NV_texture_compression_vtc;
int GLAD_GL_NV_sample_mask_override_coverage;
int GLAD_GL_NV_texture_shader3;
int GLAD_GL_NV_texture_shader2;
int GLAD_GL_EXT_texture;
int GLAD_GL_ARB_buffer_storage;
int GLAD_GL_AMD_shader_atomic_counter_ops;
int GLAD_GL_APPLE_vertex_program_evaluators;
int GLAD_GL_ARB_multi_bind;
int GLAD_GL_ARB_explicit_uniform_location;
int GLAD_GL_ARB_depth_buffer_float;
int GLAD_GL_NV_path_rendering_shared_edge;
int GLAD_GL_SGIX_shadow_ambient;
int GLAD_GL_ARB_texture_cube_map;
int GLAD_GL_AMD_vertex_shader_viewport_index;
int GLAD_GL_SGIX_list_priority;
int GLAD_GL_NV_vertex_buffer_unified_memory;
int GLAD_GL_NV_uniform_buffer_unified_memory;
int GLAD_GL_ARB_clear_texture;
int GLAD_GL_ATI_texture_env_combine3;
int GLAD_GL_ARB_map_buffer_alignment;
int GLAD_GL_NV_blend_equation_advanced;
int GLAD_GL_SGIS_sharpen_texture;
int GLAD_GL_KHR_robust_buffer_access_behavior;
int GLAD_GL_ARB_pipeline_statistics_query;
int GLAD_GL_ARB_vertex_program;
int GLAD_GL_ARB_texture_rgb10_a2ui;
int GLAD_GL_OML_interlace;
int GLAD_GL_ATI_pixel_format_float;
int GLAD_GL_NV_clip_space_w_scaling;
int GLAD_GL_ARB_vertex_buffer_object;
int GLAD_GL_EXT_shadow_funcs;
int GLAD_GL_ATI_text_fragment_shader;
int GLAD_GL_NV_vertex_array_range;
int GLAD_GL_SGIX_fragment_lighting;
int GLAD_GL_NV_texture_expand_normal;
int GLAD_GL_NV_framebuffer_multisample_coverage;
int GLAD_GL_EXT_timer_query;
int GLAD_GL_EXT_vertex_array_bgra;
int GLAD_GL_NV_bindless_texture;
int GLAD_GL_KHR_debug;
int GLAD_GL_SGIS_texture_border_clamp;
int GLAD_GL_ATI_vertex_attrib_array_object;
int GLAD_GL_SGIX_clipmap;
int GLAD_GL_EXT_geometry_shader4;
int GLAD_GL_ARB_shader_texture_image_samples;
int GLAD_GL_MESA_ycbcr_texture;
int GLAD_GL_MESAX_texture_stack;
int GLAD_GL_AMD_seamless_cubemap_per_texture;
int GLAD_GL_EXT_bindable_uniform;
int GLAD_GL_KHR_texture_compression_astc_hdr;
int GLAD_GL_ARB_shader_ballot;
int GLAD_GL_KHR_blend_equation_advanced;
int GLAD_GL_ARB_fragment_program_shadow;
int GLAD_GL_ATI_element_array;
int GLAD_GL_AMD_texture_texture4;
int GLAD_GL_SGIX_reference_plane;
int GLAD_GL_EXT_stencil_two_side;
int GLAD_GL_ARB_transform_feedback_overflow_query;
int GLAD_GL_SGIX_texture_lod_bias;
int GLAD_GL_KHR_no_error;
int GLAD_GL_NV_explicit_multisample;
int GLAD_GL_NV_stereo_view_rendering;
int GLAD_GL_IBM_static_data;
int GLAD_GL_EXT_clip_volume_hint;
int GLAD_GL_EXT_texture_perturb_normal;
int GLAD_GL_NV_fragment_program2;
int GLAD_GL_NV_fragment_program4;
int GLAD_GL_EXT_point_parameters;
int GLAD_GL_PGI_misc_hints;
int GLAD_GL_SGIX_subsample;
int GLAD_GL_AMD_shader_stencil_export;
int GLAD_GL_ARB_shader_texture_lod;
int GLAD_GL_ARB_vertex_shader;
int GLAD_GL_ARB_depth_clamp;
int GLAD_GL_SGIS_texture_select;
int GLAD_GL_NV_texture_shader;
int GLAD_GL_ARB_tessellation_shader;
int GLAD_GL_EXT_draw_buffers2;
int GLAD_GL_ARB_vertex_attrib_64bit;
int GLAD_GL_EXT_texture_filter_minmax;
int GLAD_GL_WIN_specular_fog;
int GLAD_GL_AMD_interleaved_elements;
int GLAD_GL_ARB_fragment_program;
int GLAD_GL_OML_resample;
int GLAD_GL_APPLE_ycbcr_422;
int GLAD_GL_SGIX_texture_add_env;
int GLAD_GL_ARB_shadow_ambient;
int GLAD_GL_ARB_texture_storage;
int GLAD_GL_EXT_pixel_buffer_object;
int GLAD_GL_ARB_copy_image;
int GLAD_GL_SGIS_pixel_texture;
int GLAD_GL_SGIS_generate_mipmap;
int GLAD_GL_SGIX_instruments;
int GLAD_GL_HP_texture_lighting;
int GLAD_GL_ARB_shader_storage_buffer_object;
int GLAD_GL_EXT_sparse_texture2;
int GLAD_GL_EXT_blend_minmax;
int GLAD_GL_MESA_pack_invert;
int GLAD_GL_ARB_base_instance;
int GLAD_GL_SGIX_convolution_accuracy;
int GLAD_GL_PGI_vertex_hints;
int GLAD_GL_AMD_transform_feedback4;
int GLAD_GL_ARB_ES3_1_compatibility;
int GLAD_GL_EXT_texture_integer;
int GLAD_GL_ARB_texture_multisample;
int GLAD_GL_AMD_gpu_shader_int64;
int GLAD_GL_S3_s3tc;
int GLAD_GL_ARB_query_buffer_object;
int GLAD_GL_AMD_vertex_shader_tessellator;
int GLAD_GL_ARB_invalidate_subdata;
int GLAD_GL_EXT_index_material;
int GLAD_GL_NV_blend_equation_advanced_coherent;
int GLAD_GL_KHR_texture_compression_astc_sliced_3d;
int GLAD_GL_INTEL_parallel_arrays;
int GLAD_GL_ATI_draw_buffers;
int GLAD_GL_EXT_cmyka;
int GLAD_GL_SGIX_pixel_texture;
int GLAD_GL_APPLE_specular_vector;
int GLAD_GL_ARB_compatibility;
int GLAD_GL_ARB_timer_query;
int GLAD_GL_SGIX_interlace;
int GLAD_GL_NV_parameter_buffer_object;
int GLAD_GL_AMD_shader_trinary_minmax;
int GLAD_GL_ARB_direct_state_access;
int GLAD_GL_EXT_rescale_normal;
int GLAD_GL_ARB_pixel_buffer_object;
int GLAD_GL_ARB_uniform_buffer_object;
int GLAD_GL_ARB_vertex_type_10f_11f_11f_rev;
int GLAD_GL_ARB_texture_swizzle;
int GLAD_GL_NV_transform_feedback2;
int GLAD_GL_SGIX_async_pixel;
int GLAD_GL_NV_fragment_program_option;
int GLAD_GL_ARB_explicit_attrib_location;
int GLAD_GL_EXT_blend_color;
int GLAD_GL_NV_shader_thread_group;
int GLAD_GL_EXT_stencil_wrap;
int GLAD_GL_EXT_index_array_formats;
int GLAD_GL_OVR_multiview2;
int GLAD_GL_EXT_histogram;
int GLAD_GL_EXT_polygon_offset;
int GLAD_GL_SGIS_point_parameters;
int GLAD_GL_SGIX_ycrcb;
int GLAD_GL_EXT_direct_state_access;
int GLAD_GL_ARB_cull_distance;
int GLAD_GL_AMD_sample_positions;
int GLAD_GL_NV_vertex_program;
int GLAD_GL_NV_shader_thread_shuffle;
int GLAD_GL_ARB_shader_precision;
int GLAD_GL_EXT_vertex_shader;
int GLAD_GL_EXT_blend_func_separate;
int GLAD_GL_APPLE_fence;
int GLAD_GL_OES_byte_coordinates;
int GLAD_GL_ARB_transpose_matrix;
int GLAD_GL_ARB_provoking_vertex;
int GLAD_GL_EXT_fog_coord;
int GLAD_GL_EXT_vertex_array;
int GLAD_GL_ARB_half_float_vertex;
int GLAD_GL_EXT_blend_equation_separate;
int GLAD_GL_NV_framebuffer_mixed_samples;
int GLAD_GL_NVX_conditional_render;
int GLAD_GL_ARB_multi_draw_indirect;
int GLAD_GL_EXT_raster_multisample;
int GLAD_GL_NV_copy_image;
int GLAD_GL_ARB_fragment_layer_viewport;
int GLAD_GL_INTEL_framebuffer_CMAA;
int GLAD_GL_ARB_transform_feedback2;
int GLAD_GL_ARB_transform_feedback3;
int GLAD_GL_SGIX_ycrcba;
int GLAD_GL_EXT_debug_marker;
int GLAD_GL_EXT_bgra;
int GLAD_GL_ARB_sparse_texture_clamp;
int GLAD_GL_EXT_pixel_transform;
int GLAD_GL_ARB_conservative_depth;
int GLAD_GL_ATI_fragment_shader;
int GLAD_GL_ARB_vertex_array_object;
int GLAD_GL_SUN_triangle_list;
int GLAD_GL_EXT_texture_env_add;
int GLAD_GL_EXT_packed_depth_stencil;
int GLAD_GL_EXT_texture_mirror_clamp;
int GLAD_GL_NV_multisample_filter_hint;
int GLAD_GL_APPLE_float_pixels;
int GLAD_GL_ARB_transform_feedback_instanced;
int GLAD_GL_SGIX_async;
int GLAD_GL_EXT_texture_compression_latc;
int GLAD_GL_NV_robustness_video_memory_purge;
int GLAD_GL_ARB_shading_language_100;
int GLAD_GL_INTEL_performance_query;
int GLAD_GL_ARB_texture_mirror_clamp_to_edge;
int GLAD_GL_NV_gpu_shader5;
int GLAD_GL_NV_bindless_multi_draw_indirect_count;
int GLAD_GL_ARB_ES2_compatibility;
int GLAD_GL_ARB_indirect_parameters;
int GLAD_GL_EXT_window_rectangles;
int GLAD_GL_NV_half_float;
int GLAD_GL_ARB_ES3_2_compatibility;
int GLAD_GL_ATI_texture_mirror_once;
int GLAD_GL_IBM_rasterpos_clip;
int GLAD_GL_SGIX_shadow;
int GLAD_GL_EXT_polygon_offset_clamp;
int GLAD_GL_NV_deep_texture3D;
int GLAD_GL_ARB_shader_draw_parameters;
int GLAD_GL_SGIX_calligraphic_fragment;
int GLAD_GL_ARB_shader_bit_encoding;
int GLAD_GL_EXT_compiled_vertex_array;
int GLAD_GL_NV_depth_buffer_float;
int GLAD_GL_NV_occlusion_query;
int GLAD_GL_APPLE_flush_buffer_range;
int GLAD_GL_ARB_imaging;
int GLAD_GL_NV_shader_atomic_float;
int GLAD_GL_ARB_draw_buffers_blend;
int GLAD_GL_AMD_gcn_shader;
int GLAD_GL_AMD_blend_minmax_factor;
int GLAD_GL_EXT_texture_sRGB_decode;
int GLAD_GL_ARB_shading_language_420pack;
int GLAD_GL_ARB_shader_viewport_layer_array;
int GLAD_GL_ATI_meminfo;
int GLAD_GL_EXT_abgr;
int GLAD_GL_AMD_pinned_memory;
int GLAD_GL_EXT_texture_snorm;
int GLAD_GL_SGIX_texture_coordinate_clamp;
int GLAD_GL_ARB_clear_buffer_object;
int GLAD_GL_ARB_multisample;
int GLAD_GL_EXT_debug_label;
int GLAD_GL_ARB_sample_shading;
int GLAD_GL_NV_internalformat_sample_query;
int GLAD_GL_INTEL_map_texture;
int GLAD_GL_ARB_texture_env_crossbar;
int GLAD_GL_EXT_422_pixels;
int GLAD_GL_NV_conservative_raster_pre_snap_triangles;
int GLAD_GL_ARB_compute_shader;
int GLAD_GL_EXT_blend_logic_op;
int GLAD_GL_IBM_cull_vertex;
int GLAD_GL_IBM_vertex_array_lists;
int GLAD_GL_ARB_color_buffer_float;
int GLAD_GL_ARB_bindless_texture;
int GLAD_GL_ARB_window_pos;
int GLAD_GL_ARB_internalformat_query;
int GLAD_GL_ARB_shadow;
int GLAD_GL_ARB_texture_mirrored_repeat;
int GLAD_GL_EXT_shader_image_load_store;
int GLAD_GL_EXT_copy_texture;
int GLAD_GL_NV_register_combiners2;
int GLAD_GL_SGIX_ycrcb_subsample;
int GLAD_GL_SGIX_ir_instrument1;
int GLAD_GL_NV_draw_texture;
int GLAD_GL_EXT_texture_shared_exponent;
int GLAD_GL_EXT_draw_instanced;
int GLAD_GL_NV_copy_depth_to_color;
int GLAD_GL_ARB_viewport_array;
int GLAD_GL_ARB_separate_shader_objects;
int GLAD_GL_EXT_depth_bounds_test;
int GLAD_GL_HP_image_transform;
int GLAD_GL_ARB_texture_env_add;
int GLAD_GL_NV_video_capture;
int GLAD_GL_ARB_sampler_objects;
int GLAD_GL_ARB_matrix_palette;
int GLAD_GL_SGIS_texture_color_mask;
int GLAD_GL_EXT_packed_pixels;
int GLAD_GL_EXT_coordinate_frame;
int GLAD_GL_ARB_texture_compression;
int GLAD_GL_APPLE_aux_depth_stencil;
int GLAD_GL_ARB_shader_subroutine;
int GLAD_GL_EXT_framebuffer_sRGB;
int GLAD_GL_ARB_texture_storage_multisample;
int GLAD_GL_KHR_blend_equation_advanced_coherent;
int GLAD_GL_EXT_vertex_attrib_64bit;
int GLAD_GL_NV_shader_atomic_float64;
int GLAD_GL_ARB_depth_texture;
int GLAD_GL_NV_shader_buffer_store;
int GLAD_GL_OES_query_matrix;
int GLAD_GL_MESA_window_pos;
int GLAD_GL_NV_fill_rectangle;
int GLAD_GL_NV_shader_storage_buffer_object;
int GLAD_GL_ARB_texture_query_lod;
int GLAD_GL_ARB_copy_buffer;
int GLAD_GL_ARB_shader_image_size;
int GLAD_GL_NV_shader_atomic_counters;
int GLAD_GL_APPLE_object_purgeable;
int GLAD_GL_ARB_occlusion_query;
int GLAD_GL_INGR_color_clamp;
int GLAD_GL_SGI_color_table;
int GLAD_GL_NV_gpu_program5_mem_extended;
int GLAD_GL_ARB_texture_cube_map_array;
int GLAD_GL_SGIX_scalebias_hint;
int GLAD_GL_EXT_gpu_shader4;
int GLAD_GL_NV_geometry_program4;
int GLAD_GL_EXT_framebuffer_multisample_blit_scaled;
int GLAD_GL_AMD_debug_output;
int GLAD_GL_ARB_texture_border_clamp;
int GLAD_GL_ARB_fragment_coord_conventions;
int GLAD_GL_ARB_multitexture;
int GLAD_GL_SGIX_polynomial_ffd;
int GLAD_GL_EXT_provoking_vertex;
int GLAD_GL_ARB_point_parameters;
int GLAD_GL_ARB_shader_image_load_store;
int GLAD_GL_ARB_conditional_render_inverted;
int GLAD_GL_HP_occlusion_test;
int GLAD_GL_ARB_ES3_compatibility;
int GLAD_GL_ARB_texture_barrier;
int GLAD_GL_ARB_texture_buffer_object_rgb32;
int GLAD_GL_NV_bindless_multi_draw_indirect;
int GLAD_GL_SGIX_texture_multi_buffer;
int GLAD_GL_EXT_transform_feedback;
int GLAD_GL_KHR_texture_compression_astc_ldr;
int GLAD_GL_3DFX_multisample;
int GLAD_GL_INTEL_fragment_shader_ordering;
int GLAD_GL_ARB_texture_env_dot3;
int GLAD_GL_NV_gpu_program4;
int GLAD_GL_NV_gpu_program5;
int GLAD_GL_NV_float_buffer;
int GLAD_GL_SGIS_texture_edge_clamp;
int GLAD_GL_ARB_framebuffer_sRGB;
int GLAD_GL_SUN_slice_accum;
int GLAD_GL_EXT_index_texture;
int GLAD_GL_EXT_shader_image_load_formatted;
int GLAD_GL_ARB_geometry_shader4;
int GLAD_GL_EXT_separate_specular_color;
int GLAD_GL_AMD_depth_clamp_separate;
int GLAD_GL_NV_conservative_raster;
int GLAD_GL_ARB_sparse_texture2;
int GLAD_GL_SGIX_sprite;
int GLAD_GL_ARB_get_program_binary;
int GLAD_GL_AMD_occlusion_query_event;
int GLAD_GL_SGIS_multisample;
int GLAD_GL_EXT_framebuffer_object;
int GLAD_GL_ARB_robustness_isolation;
int GLAD_GL_ARB_vertex_array_bgra;
int GLAD_GL_APPLE_vertex_array_range;
int GLAD_GL_AMD_query_buffer_object;
int GLAD_GL_NV_register_combiners;
int GLAD_GL_ARB_draw_buffers;
int GLAD_GL_EXT_texture_env_dot3;
int GLAD_GL_ARB_debug_output;
int GLAD_GL_SGI_color_matrix;
int GLAD_GL_EXT_cull_vertex;
int GLAD_GL_EXT_texture_sRGB;
int GLAD_GL_APPLE_row_bytes;
int GLAD_GL_NV_texgen_reflection;
int GLAD_GL_IBM_multimode_draw_arrays;
int GLAD_GL_APPLE_vertex_array_object;
int GLAD_GL_3DFX_texture_compression_FXT1;
int GLAD_GL_NV_fragment_shader_interlock;
int GLAD_GL_AMD_conservative_depth;
int GLAD_GL_ARB_texture_float;
int GLAD_GL_ARB_compressed_texture_pixel_storage;
int GLAD_GL_SGIS_detail_texture;
int GLAD_GL_NV_geometry_shader_passthrough;
int GLAD_GL_ARB_draw_instanced;
int GLAD_GL_OES_read_format;
int GLAD_GL_ATI_texture_float;
int GLAD_GL_ARB_texture_gather;
int GLAD_GL_AMD_vertex_shader_layer;
int GLAD_GL_ARB_shading_language_include;
int GLAD_GL_APPLE_client_storage;
int GLAD_GL_WIN_phong_shading;
int GLAD_GL_INGR_blend_func_separate;
int GLAD_GL_NV_path_rendering;
int GLAD_GL_NV_conservative_raster_dilate;
int GLAD_GL_ATI_vertex_streams;
int GLAD_GL_ARB_post_depth_coverage;
int GLAD_GL_ARB_texture_non_power_of_two;
int GLAD_GL_APPLE_rgb_422;
int GLAD_GL_EXT_texture_lod_bias;
int GLAD_GL_ARB_gpu_shader_int64;
int GLAD_GL_ARB_seamless_cube_map;
int GLAD_GL_ARB_shader_group_vote;
int GLAD_GL_NV_vdpau_interop;
int GLAD_GL_ARB_occlusion_query2;
int GLAD_GL_ARB_internalformat_query2;
int GLAD_GL_EXT_texture_filter_anisotropic;
int GLAD_GL_SUN_vertex;
int GLAD_GL_SGIX_igloo_interface;
int GLAD_GL_SGIS_texture_lod;
int GLAD_GL_NV_vertex_program3;
int GLAD_GL_ARB_draw_indirect;
int GLAD_GL_NV_vertex_program4;
int GLAD_GL_AMD_transform_feedback3_lines_triangles;
int GLAD_GL_SGIS_fog_function;
int GLAD_GL_EXT_x11_sync_object;
int GLAD_GL_ARB_sync;
int GLAD_GL_NV_sample_locations;
int GLAD_GL_ARB_compute_variable_group_size;
int GLAD_GL_OES_fixed_point;
int GLAD_GL_NV_blend_square;
int GLAD_GL_EXT_framebuffer_multisample;
int GLAD_GL_ARB_gpu_shader5;
int GLAD_GL_SGIS_texture4D;
int GLAD_GL_EXT_texture3D;
int GLAD_GL_EXT_multisample;
int GLAD_GL_EXT_secondary_color;
int GLAD_GL_INTEL_conservative_rasterization;
int GLAD_GL_ARB_texture_filter_minmax;
int GLAD_GL_ATI_vertex_array_object;
int GLAD_GL_ARB_parallel_shader_compile;
int GLAD_GL_NVX_gpu_memory_info;
int GLAD_GL_ARB_sparse_texture;
int GLAD_GL_SGIS_point_line_texgen;
int GLAD_GL_ARB_sample_locations;
int GLAD_GL_ARB_sparse_buffer;
int GLAD_GL_EXT_draw_range_elements;
int GLAD_GL_SGIX_blend_alpha_minmax;
int GLAD_GL_KHR_context_flush_control;
PFNGLTBUFFERMASK3DFXPROC glad_glTbufferMask3DFX;
PFNGLDEBUGMESSAGEENABLEAMDPROC glad_glDebugMessageEnableAMD;
PFNGLDEBUGMESSAGEINSERTAMDPROC glad_glDebugMessageInsertAMD;
PFNGLDEBUGMESSAGECALLBACKAMDPROC glad_glDebugMessageCallbackAMD;
PFNGLGETDEBUGMESSAGELOGAMDPROC glad_glGetDebugMessageLogAMD;
PFNGLBLENDFUNCINDEXEDAMDPROC glad_glBlendFuncIndexedAMD;
PFNGLBLENDFUNCSEPARATEINDEXEDAMDPROC glad_glBlendFuncSeparateIndexedAMD;
PFNGLBLENDEQUATIONINDEXEDAMDPROC glad_glBlendEquationIndexedAMD;
PFNGLBLENDEQUATIONSEPARATEINDEXEDAMDPROC glad_glBlendEquationSeparateIndexedAMD;
PFNGLUNIFORM1I64NVPROC glad_glUniform1i64NV;
PFNGLUNIFORM2I64NVPROC glad_glUniform2i64NV;
PFNGLUNIFORM3I64NVPROC glad_glUniform3i64NV;
PFNGLUNIFORM4I64NVPROC glad_glUniform4i64NV;
PFNGLUNIFORM1I64VNVPROC glad_glUniform1i64vNV;
PFNGLUNIFORM2I64VNVPROC glad_glUniform2i64vNV;
PFNGLUNIFORM3I64VNVPROC glad_glUniform3i64vNV;
PFNGLUNIFORM4I64VNVPROC glad_glUniform4i64vNV;
PFNGLUNIFORM1UI64NVPROC glad_glUniform1ui64NV;
PFNGLUNIFORM2UI64NVPROC glad_glUniform2ui64NV;
PFNGLUNIFORM3UI64NVPROC glad_glUniform3ui64NV;
PFNGLUNIFORM4UI64NVPROC glad_glUniform4ui64NV;
PFNGLUNIFORM1UI64VNVPROC glad_glUniform1ui64vNV;
PFNGLUNIFORM2UI64VNVPROC glad_glUniform2ui64vNV;
PFNGLUNIFORM3UI64VNVPROC glad_glUniform3ui64vNV;
PFNGLUNIFORM4UI64VNVPROC glad_glUniform4ui64vNV;
PFNGLGETUNIFORMI64VNVPROC glad_glGetUniformi64vNV;
PFNGLGETUNIFORMUI64VNVPROC glad_glGetUniformui64vNV;
PFNGLPROGRAMUNIFORM1I64NVPROC glad_glProgramUniform1i64NV;
PFNGLPROGRAMUNIFORM2I64NVPROC glad_glProgramUniform2i64NV;
PFNGLPROGRAMUNIFORM3I64NVPROC glad_glProgramUniform3i64NV;
PFNGLPROGRAMUNIFORM4I64NVPROC glad_glProgramUniform4i64NV;
PFNGLPROGRAMUNIFORM1I64VNVPROC glad_glProgramUniform1i64vNV;
PFNGLPROGRAMUNIFORM2I64VNVPROC glad_glProgramUniform2i64vNV;
PFNGLPROGRAMUNIFORM3I64VNVPROC glad_glProgramUniform3i64vNV;
PFNGLPROGRAMUNIFORM4I64VNVPROC glad_glProgramUniform4i64vNV;
PFNGLPROGRAMUNIFORM1UI64NVPROC glad_glProgramUniform1ui64NV;
PFNGLPROGRAMUNIFORM2UI64NVPROC glad_glProgramUniform2ui64NV;
PFNGLPROGRAMUNIFORM3UI64NVPROC glad_glProgramUniform3ui64NV;
PFNGLPROGRAMUNIFORM4UI64NVPROC glad_glProgramUniform4ui64NV;
PFNGLPROGRAMUNIFORM1UI64VNVPROC glad_glProgramUniform1ui64vNV;
PFNGLPROGRAMUNIFORM2UI64VNVPROC glad_glProgramUniform2ui64vNV;
PFNGLPROGRAMUNIFORM3UI64VNVPROC glad_glProgramUniform3ui64vNV;
PFNGLPROGRAMUNIFORM4UI64VNVPROC glad_glProgramUniform4ui64vNV;
PFNGLVERTEXATTRIBPARAMETERIAMDPROC glad_glVertexAttribParameteriAMD;
PFNGLMULTIDRAWARRAYSINDIRECTAMDPROC glad_glMultiDrawArraysIndirectAMD;
PFNGLMULTIDRAWELEMENTSINDIRECTAMDPROC glad_glMultiDrawElementsIndirectAMD;
PFNGLGENNAMESAMDPROC glad_glGenNamesAMD;
PFNGLDELETENAMESAMDPROC glad_glDeleteNamesAMD;
PFNGLISNAMEAMDPROC glad_glIsNameAMD;
PFNGLQUERYOBJECTPARAMETERUIAMDPROC glad_glQueryObjectParameteruiAMD;
PFNGLGETPERFMONITORGROUPSAMDPROC glad_glGetPerfMonitorGroupsAMD;
PFNGLGETPERFMONITORCOUNTERSAMDPROC glad_glGetPerfMonitorCountersAMD;
PFNGLGETPERFMONITORGROUPSTRINGAMDPROC glad_glGetPerfMonitorGroupStringAMD;
PFNGLGETPERFMONITORCOUNTERSTRINGAMDPROC glad_glGetPerfMonitorCounterStringAMD;
PFNGLGETPERFMONITORCOUNTERINFOAMDPROC glad_glGetPerfMonitorCounterInfoAMD;
PFNGLGENPERFMONITORSAMDPROC glad_glGenPerfMonitorsAMD;
PFNGLDELETEPERFMONITORSAMDPROC glad_glDeletePerfMonitorsAMD;
PFNGLSELECTPERFMONITORCOUNTERSAMDPROC glad_glSelectPerfMonitorCountersAMD;
PFNGLBEGINPERFMONITORAMDPROC glad_glBeginPerfMonitorAMD;
PFNGLENDPERFMONITORAMDPROC glad_glEndPerfMonitorAMD;
PFNGLGETPERFMONITORCOUNTERDATAAMDPROC glad_glGetPerfMonitorCounterDataAMD;
PFNGLSETMULTISAMPLEFVAMDPROC glad_glSetMultisamplefvAMD;
PFNGLTEXSTORAGESPARSEAMDPROC glad_glTexStorageSparseAMD;
PFNGLTEXTURESTORAGESPARSEAMDPROC glad_glTextureStorageSparseAMD;
PFNGLSTENCILOPVALUEAMDPROC glad_glStencilOpValueAMD;
PFNGLTESSELLATIONFACTORAMDPROC glad_glTessellationFactorAMD;
PFNGLTESSELLATIONMODEAMDPROC glad_glTessellationModeAMD;
PFNGLELEMENTPOINTERAPPLEPROC glad_glElementPointerAPPLE;
PFNGLDRAWELEMENTARRAYAPPLEPROC glad_glDrawElementArrayAPPLE;
PFNGLDRAWRANGEELEMENTARRAYAPPLEPROC glad_glDrawRangeElementArrayAPPLE;
PFNGLMULTIDRAWELEMENTARRAYAPPLEPROC glad_glMultiDrawElementArrayAPPLE;
PFNGLMULTIDRAWRANGEELEMENTARRAYAPPLEPROC glad_glMultiDrawRangeElementArrayAPPLE;
PFNGLGENFENCESAPPLEPROC glad_glGenFencesAPPLE;
PFNGLDELETEFENCESAPPLEPROC glad_glDeleteFencesAPPLE;
PFNGLSETFENCEAPPLEPROC glad_glSetFenceAPPLE;
PFNGLISFENCEAPPLEPROC glad_glIsFenceAPPLE;
PFNGLTESTFENCEAPPLEPROC glad_glTestFenceAPPLE;
PFNGLFINISHFENCEAPPLEPROC glad_glFinishFenceAPPLE;
PFNGLTESTOBJECTAPPLEPROC glad_glTestObjectAPPLE;
PFNGLFINISHOBJECTAPPLEPROC glad_glFinishObjectAPPLE;
PFNGLBUFFERPARAMETERIAPPLEPROC glad_glBufferParameteriAPPLE;
PFNGLFLUSHMAPPEDBUFFERRANGEAPPLEPROC glad_glFlushMappedBufferRangeAPPLE;
PFNGLOBJECTPURGEABLEAPPLEPROC glad_glObjectPurgeableAPPLE;
PFNGLOBJECTUNPURGEABLEAPPLEPROC glad_glObjectUnpurgeableAPPLE;
PFNGLGETOBJECTPARAMETERIVAPPLEPROC glad_glGetObjectParameterivAPPLE;
PFNGLTEXTURERANGEAPPLEPROC glad_glTextureRangeAPPLE;
PFNGLGETTEXPARAMETERPOINTERVAPPLEPROC glad_glGetTexParameterPointervAPPLE;
PFNGLBINDVERTEXARRAYAPPLEPROC glad_glBindVertexArrayAPPLE;
PFNGLDELETEVERTEXARRAYSAPPLEPROC glad_glDeleteVertexArraysAPPLE;
PFNGLGENVERTEXARRAYSAPPLEPROC glad_glGenVertexArraysAPPLE;
PFNGLISVERTEXARRAYAPPLEPROC glad_glIsVertexArrayAPPLE;
PFNGLVERTEXARRAYRANGEAPPLEPROC glad_glVertexArrayRangeAPPLE;
PFNGLFLUSHVERTEXARRAYRANGEAPPLEPROC glad_glFlushVertexArrayRangeAPPLE;
PFNGLVERTEXARRAYPARAMETERIAPPLEPROC glad_glVertexArrayParameteriAPPLE;
PFNGLENABLEVERTEXATTRIBAPPLEPROC glad_glEnableVertexAttribAPPLE;
PFNGLDISABLEVERTEXATTRIBAPPLEPROC glad_glDisableVertexAttribAPPLE;
PFNGLISVERTEXATTRIBENABLEDAPPLEPROC glad_glIsVertexAttribEnabledAPPLE;
PFNGLMAPVERTEXATTRIB1DAPPLEPROC glad_glMapVertexAttrib1dAPPLE;
PFNGLMAPVERTEXATTRIB1FAPPLEPROC glad_glMapVertexAttrib1fAPPLE;
PFNGLMAPVERTEXATTRIB2DAPPLEPROC glad_glMapVertexAttrib2dAPPLE;
PFNGLMAPVERTEXATTRIB2FAPPLEPROC glad_glMapVertexAttrib2fAPPLE;
PFNGLPRIMITIVEBOUNDINGBOXARBPROC glad_glPrimitiveBoundingBoxARB;
PFNGLGETTEXTUREHANDLEARBPROC glad_glGetTextureHandleARB;
PFNGLGETTEXTURESAMPLERHANDLEARBPROC glad_glGetTextureSamplerHandleARB;
PFNGLMAKETEXTUREHANDLERESIDENTARBPROC glad_glMakeTextureHandleResidentARB;
PFNGLMAKETEXTUREHANDLENONRESIDENTARBPROC glad_glMakeTextureHandleNonResidentARB;
PFNGLGETIMAGEHANDLEARBPROC glad_glGetImageHandleARB;
PFNGLMAKEIMAGEHANDLERESIDENTARBPROC glad_glMakeImageHandleResidentARB;
PFNGLMAKEIMAGEHANDLENONRESIDENTARBPROC glad_glMakeImageHandleNonResidentARB;
PFNGLUNIFORMHANDLEUI64ARBPROC glad_glUniformHandleui64ARB;
PFNGLUNIFORMHANDLEUI64VARBPROC glad_glUniformHandleui64vARB;
PFNGLPROGRAMUNIFORMHANDLEUI64ARBPROC glad_glProgramUniformHandleui64ARB;
PFNGLPROGRAMUNIFORMHANDLEUI64VARBPROC glad_glProgramUniformHandleui64vARB;
PFNGLISTEXTUREHANDLERESIDENTARBPROC glad_glIsTextureHandleResidentARB;
PFNGLISIMAGEHANDLERESIDENTARBPROC glad_glIsImageHandleResidentARB;
PFNGLVERTEXATTRIBL1UI64ARBPROC glad_glVertexAttribL1ui64ARB;
PFNGLVERTEXATTRIBL1UI64VARBPROC glad_glVertexAttribL1ui64vARB;
PFNGLGETVERTEXATTRIBLUI64VARBPROC glad_glGetVertexAttribLui64vARB;
PFNGLCREATESYNCFROMCLEVENTARBPROC glad_glCreateSyncFromCLeventARB;
PFNGLCLAMPCOLORARBPROC glad_glClampColorARB;
PFNGLDISPATCHCOMPUTEGROUPSIZEARBPROC glad_glDispatchComputeGroupSizeARB;
PFNGLDEBUGMESSAGECONTROLARBPROC glad_glDebugMessageControlARB;
PFNGLDEBUGMESSAGEINSERTARBPROC glad_glDebugMessageInsertARB;
PFNGLDEBUGMESSAGECALLBACKARBPROC glad_glDebugMessageCallbackARB;
PFNGLGETDEBUGMESSAGELOGARBPROC glad_glGetDebugMessageLogARB;
PFNGLDRAWBUFFERSARBPROC glad_glDrawBuffersARB;
PFNGLBLENDEQUATIONIARBPROC glad_glBlendEquationiARB;
PFNGLBLENDEQUATIONSEPARATEIARBPROC glad_glBlendEquationSeparateiARB;
PFNGLBLENDFUNCIARBPROC glad_glBlendFunciARB;
PFNGLBLENDFUNCSEPARATEIARBPROC glad_glBlendFuncSeparateiARB;
PFNGLDRAWARRAYSINSTANCEDARBPROC glad_glDrawArraysInstancedARB;
PFNGLDRAWELEMENTSINSTANCEDARBPROC glad_glDrawElementsInstancedARB;
PFNGLPROGRAMSTRINGARBPROC glad_glProgramStringARB;
PFNGLBINDPROGRAMARBPROC glad_glBindProgramARB;
PFNGLDELETEPROGRAMSARBPROC glad_glDeleteProgramsARB;
PFNGLGENPROGRAMSARBPROC glad_glGenProgramsARB;
PFNGLPROGRAMENVPARAMETER4DARBPROC glad_glProgramEnvParameter4dARB;
PFNGLPROGRAMENVPARAMETER4DVARBPROC glad_glProgramEnvParameter4dvARB;
PFNGLPROGRAMENVPARAMETER4FARBPROC glad_glProgramEnvParameter4fARB;
PFNGLPROGRAMENVPARAMETER4FVARBPROC glad_glProgramEnvParameter4fvARB;
PFNGLPROGRAMLOCALPARAMETER4DARBPROC glad_glProgramLocalParameter4dARB;
PFNGLPROGRAMLOCALPARAMETER4DVARBPROC glad_glProgramLocalParameter4dvARB;
PFNGLPROGRAMLOCALPARAMETER4FARBPROC glad_glProgramLocalParameter4fARB;
PFNGLPROGRAMLOCALPARAMETER4FVARBPROC glad_glProgramLocalParameter4fvARB;
PFNGLGETPROGRAMENVPARAMETERDVARBPROC glad_glGetProgramEnvParameterdvARB;
PFNGLGETPROGRAMENVPARAMETERFVARBPROC glad_glGetProgramEnvParameterfvARB;
PFNGLGETPROGRAMLOCALPARAMETERDVARBPROC glad_glGetProgramLocalParameterdvARB;
PFNGLGETPROGRAMLOCALPARAMETERFVARBPROC glad_glGetProgramLocalParameterfvARB;
PFNGLGETPROGRAMIVARBPROC glad_glGetProgramivARB;
PFNGLGETPROGRAMSTRINGARBPROC glad_glGetProgramStringARB;
PFNGLISPROGRAMARBPROC glad_glIsProgramARB;
PFNGLPROGRAMPARAMETERIARBPROC glad_glProgramParameteriARB;
PFNGLFRAMEBUFFERTEXTUREARBPROC glad_glFramebufferTextureARB;
PFNGLFRAMEBUFFERTEXTURELAYERARBPROC glad_glFramebufferTextureLayerARB;
PFNGLFRAMEBUFFERTEXTUREFACEARBPROC glad_glFramebufferTextureFaceARB;
PFNGLUNIFORM1I64ARBPROC glad_glUniform1i64ARB;
PFNGLUNIFORM2I64ARBPROC glad_glUniform2i64ARB;
PFNGLUNIFORM3I64ARBPROC glad_glUniform3i64ARB;
PFNGLUNIFORM4I64ARBPROC glad_glUniform4i64ARB;
PFNGLUNIFORM1I64VARBPROC glad_glUniform1i64vARB;
PFNGLUNIFORM2I64VARBPROC glad_glUniform2i64vARB;
PFNGLUNIFORM3I64VARBPROC glad_glUniform3i64vARB;
PFNGLUNIFORM4I64VARBPROC glad_glUniform4i64vARB;
PFNGLUNIFORM1UI64ARBPROC glad_glUniform1ui64ARB;
PFNGLUNIFORM2UI64ARBPROC glad_glUniform2ui64ARB;
PFNGLUNIFORM3UI64ARBPROC glad_glUniform3ui64ARB;
PFNGLUNIFORM4UI64ARBPROC glad_glUniform4ui64ARB;
PFNGLUNIFORM1UI64VARBPROC glad_glUniform1ui64vARB;
PFNGLUNIFORM2UI64VARBPROC glad_glUniform2ui64vARB;
PFNGLUNIFORM3UI64VARBPROC glad_glUniform3ui64vARB;
PFNGLUNIFORM4UI64VARBPROC glad_glUniform4ui64vARB;
PFNGLGETUNIFORMI64VARBPROC glad_glGetUniformi64vARB;
PFNGLGETUNIFORMUI64VARBPROC glad_glGetUniformui64vARB;
PFNGLGETNUNIFORMI64VARBPROC glad_glGetnUniformi64vARB;
PFNGLGETNUNIFORMUI64VARBPROC glad_glGetnUniformui64vARB;
PFNGLPROGRAMUNIFORM1I64ARBPROC glad_glProgramUniform1i64ARB;
PFNGLPROGRAMUNIFORM2I64ARBPROC glad_glProgramUniform2i64ARB;
PFNGLPROGRAMUNIFORM3I64ARBPROC glad_glProgramUniform3i64ARB;
PFNGLPROGRAMUNIFORM4I64ARBPROC glad_glProgramUniform4i64ARB;
PFNGLPROGRAMUNIFORM1I64VARBPROC glad_glProgramUniform1i64vARB;
PFNGLPROGRAMUNIFORM2I64VARBPROC glad_glProgramUniform2i64vARB;
PFNGLPROGRAMUNIFORM3I64VARBPROC glad_glProgramUniform3i64vARB;
PFNGLPROGRAMUNIFORM4I64VARBPROC glad_glProgramUniform4i64vARB;
PFNGLPROGRAMUNIFORM1UI64ARBPROC glad_glProgramUniform1ui64ARB;
PFNGLPROGRAMUNIFORM2UI64ARBPROC glad_glProgramUniform2ui64ARB;
PFNGLPROGRAMUNIFORM3UI64ARBPROC glad_glProgramUniform3ui64ARB;
PFNGLPROGRAMUNIFORM4UI64ARBPROC glad_glProgramUniform4ui64ARB;
PFNGLPROGRAMUNIFORM1UI64VARBPROC glad_glProgramUniform1ui64vARB;
PFNGLPROGRAMUNIFORM2UI64VARBPROC glad_glProgramUniform2ui64vARB;
PFNGLPROGRAMUNIFORM3UI64VARBPROC glad_glProgramUniform3ui64vARB;
PFNGLPROGRAMUNIFORM4UI64VARBPROC glad_glProgramUniform4ui64vARB;
PFNGLCOLORTABLEPROC glad_glColorTable;
PFNGLCOLORTABLEPARAMETERFVPROC glad_glColorTableParameterfv;
PFNGLCOLORTABLEPARAMETERIVPROC glad_glColorTableParameteriv;
PFNGLCOPYCOLORTABLEPROC glad_glCopyColorTable;
PFNGLGETCOLORTABLEPROC glad_glGetColorTable;
PFNGLGETCOLORTABLEPARAMETERFVPROC glad_glGetColorTableParameterfv;
PFNGLGETCOLORTABLEPARAMETERIVPROC glad_glGetColorTableParameteriv;
PFNGLCOLORSUBTABLEPROC glad_glColorSubTable;
PFNGLCOPYCOLORSUBTABLEPROC glad_glCopyColorSubTable;
PFNGLCONVOLUTIONFILTER1DPROC glad_glConvolutionFilter1D;
PFNGLCONVOLUTIONFILTER2DPROC glad_glConvolutionFilter2D;
PFNGLCONVOLUTIONPARAMETERFPROC glad_glConvolutionParameterf;
PFNGLCONVOLUTIONPARAMETERFVPROC glad_glConvolutionParameterfv;
PFNGLCONVOLUTIONPARAMETERIPROC glad_glConvolutionParameteri;
PFNGLCONVOLUTIONPARAMETERIVPROC glad_glConvolutionParameteriv;
PFNGLCOPYCONVOLUTIONFILTER1DPROC glad_glCopyConvolutionFilter1D;
PFNGLCOPYCONVOLUTIONFILTER2DPROC glad_glCopyConvolutionFilter2D;
PFNGLGETCONVOLUTIONFILTERPROC glad_glGetConvolutionFilter;
PFNGLGETCONVOLUTIONPARAMETERFVPROC glad_glGetConvolutionParameterfv;
PFNGLGETCONVOLUTIONPARAMETERIVPROC glad_glGetConvolutionParameteriv;
PFNGLGETSEPARABLEFILTERPROC glad_glGetSeparableFilter;
PFNGLSEPARABLEFILTER2DPROC glad_glSeparableFilter2D;
PFNGLGETHISTOGRAMPROC glad_glGetHistogram;
PFNGLGETHISTOGRAMPARAMETERFVPROC glad_glGetHistogramParameterfv;
PFNGLGETHISTOGRAMPARAMETERIVPROC glad_glGetHistogramParameteriv;
PFNGLGETMINMAXPROC glad_glGetMinmax;
PFNGLGETMINMAXPARAMETERFVPROC glad_glGetMinmaxParameterfv;
PFNGLGETMINMAXPARAMETERIVPROC glad_glGetMinmaxParameteriv;
PFNGLHISTOGRAMPROC glad_glHistogram;
PFNGLMINMAXPROC glad_glMinmax;
PFNGLRESETHISTOGRAMPROC glad_glResetHistogram;
PFNGLRESETMINMAXPROC glad_glResetMinmax;
PFNGLMULTIDRAWARRAYSINDIRECTCOUNTARBPROC glad_glMultiDrawArraysIndirectCountARB;
PFNGLMULTIDRAWELEMENTSINDIRECTCOUNTARBPROC glad_glMultiDrawElementsIndirectCountARB;
PFNGLVERTEXATTRIBDIVISORARBPROC glad_glVertexAttribDivisorARB;
PFNGLCURRENTPALETTEMATRIXARBPROC glad_glCurrentPaletteMatrixARB;
PFNGLMATRIXINDEXUBVARBPROC glad_glMatrixIndexubvARB;
PFNGLMATRIXINDEXUSVARBPROC glad_glMatrixIndexusvARB;
PFNGLMATRIXINDEXUIVARBPROC glad_glMatrixIndexuivARB;
PFNGLMATRIXINDEXPOINTERARBPROC glad_glMatrixIndexPointerARB;
PFNGLSAMPLECOVERAGEARBPROC glad_glSampleCoverageARB;
PFNGLACTIVETEXTUREARBPROC glad_glActiveTextureARB;
PFNGLCLIENTACTIVETEXTUREARBPROC glad_glClientActiveTextureARB;
PFNGLMULTITEXCOORD1DARBPROC glad_glMultiTexCoord1dARB;
PFNGLMULTITEXCOORD1DVARBPROC glad_glMultiTexCoord1dvARB;
PFNGLMULTITEXCOORD1FARBPROC glad_glMultiTexCoord1fARB;
PFNGLMULTITEXCOORD1FVARBPROC glad_glMultiTexCoord1fvARB;
PFNGLMULTITEXCOORD1IARBPROC glad_glMultiTexCoord1iARB;
PFNGLMULTITEXCOORD1IVARBPROC glad_glMultiTexCoord1ivARB;
PFNGLMULTITEXCOORD1SARBPROC glad_glMultiTexCoord1sARB;
PFNGLMULTITEXCOORD1SVARBPROC glad_glMultiTexCoord1svARB;
PFNGLMULTITEXCOORD2DARBPROC glad_glMultiTexCoord2dARB;
PFNGLMULTITEXCOORD2DVARBPROC glad_glMultiTexCoord2dvARB;
PFNGLMULTITEXCOORD2FARBPROC glad_glMultiTexCoord2fARB;
PFNGLMULTITEXCOORD2FVARBPROC glad_glMultiTexCoord2fvARB;
PFNGLMULTITEXCOORD2IARBPROC glad_glMultiTexCoord2iARB;
PFNGLMULTITEXCOORD2IVARBPROC glad_glMultiTexCoord2ivARB;
PFNGLMULTITEXCOORD2SARBPROC glad_glMultiTexCoord2sARB;
PFNGLMULTITEXCOORD2SVARBPROC glad_glMultiTexCoord2svARB;
PFNGLMULTITEXCOORD3DARBPROC glad_glMultiTexCoord3dARB;
PFNGLMULTITEXCOORD3DVARBPROC glad_glMultiTexCoord3dvARB;
PFNGLMULTITEXCOORD3FARBPROC glad_glMultiTexCoord3fARB;
PFNGLMULTITEXCOORD3FVARBPROC glad_glMultiTexCoord3fvARB;
PFNGLMULTITEXCOORD3IARBPROC glad_glMultiTexCoord3iARB;
PFNGLMULTITEXCOORD3IVARBPROC glad_glMultiTexCoord3ivARB;
PFNGLMULTITEXCOORD3SARBPROC glad_glMultiTexCoord3sARB;
PFNGLMULTITEXCOORD3SVARBPROC glad_glMultiTexCoord3svARB;
PFNGLMULTITEXCOORD4DARBPROC glad_glMultiTexCoord4dARB;
PFNGLMULTITEXCOORD4DVARBPROC glad_glMultiTexCoord4dvARB;
PFNGLMULTITEXCOORD4FARBPROC glad_glMultiTexCoord4fARB;
PFNGLMULTITEXCOORD4FVARBPROC glad_glMultiTexCoord4fvARB;
PFNGLMULTITEXCOORD4IARBPROC glad_glMultiTexCoord4iARB;
PFNGLMULTITEXCOORD4IVARBPROC glad_glMultiTexCoord4ivARB;
PFNGLMULTITEXCOORD4SARBPROC glad_glMultiTexCoord4sARB;
PFNGLMULTITEXCOORD4SVARBPROC glad_glMultiTexCoord4svARB;
PFNGLGENQUERIESARBPROC glad_glGenQueriesARB;
PFNGLDELETEQUERIESARBPROC glad_glDeleteQueriesARB;
PFNGLISQUERYARBPROC glad_glIsQueryARB;
PFNGLBEGINQUERYARBPROC glad_glBeginQueryARB;
PFNGLENDQUERYARBPROC glad_glEndQueryARB;
PFNGLGETQUERYIVARBPROC glad_glGetQueryivARB;
PFNGLGETQUERYOBJECTIVARBPROC glad_glGetQueryObjectivARB;
PFNGLGETQUERYOBJECTUIVARBPROC glad_glGetQueryObjectuivARB;
PFNGLMAXSHADERCOMPILERTHREADSARBPROC glad_glMaxShaderCompilerThreadsARB;
PFNGLPOINTPARAMETERFARBPROC glad_glPointParameterfARB;
PFNGLPOINTPARAMETERFVARBPROC glad_glPointParameterfvARB;
PFNGLGETGRAPHICSRESETSTATUSARBPROC glad_glGetGraphicsResetStatusARB;
PFNGLGETNTEXIMAGEARBPROC glad_glGetnTexImageARB;
PFNGLREADNPIXELSARBPROC glad_glReadnPixelsARB;
PFNGLGETNCOMPRESSEDTEXIMAGEARBPROC glad_glGetnCompressedTexImageARB;
PFNGLGETNUNIFORMFVARBPROC glad_glGetnUniformfvARB;
PFNGLGETNUNIFORMIVARBPROC glad_glGetnUniformivARB;
PFNGLGETNUNIFORMUIVARBPROC glad_glGetnUniformuivARB;
PFNGLGETNUNIFORMDVARBPROC glad_glGetnUniformdvARB;
PFNGLGETNMAPDVARBPROC glad_glGetnMapdvARB;
PFNGLGETNMAPFVARBPROC glad_glGetnMapfvARB;
PFNGLGETNMAPIVARBPROC glad_glGetnMapivARB;
PFNGLGETNPIXELMAPFVARBPROC glad_glGetnPixelMapfvARB;
PFNGLGETNPIXELMAPUIVARBPROC glad_glGetnPixelMapuivARB;
PFNGLGETNPIXELMAPUSVARBPROC glad_glGetnPixelMapusvARB;
PFNGLGETNPOLYGONSTIPPLEARBPROC glad_glGetnPolygonStippleARB;
PFNGLGETNCOLORTABLEARBPROC glad_glGetnColorTableARB;
PFNGLGETNCONVOLUTIONFILTERARBPROC glad_glGetnConvolutionFilterARB;
PFNGLGETNSEPARABLEFILTERARBPROC glad_glGetnSeparableFilterARB;
PFNGLGETNHISTOGRAMARBPROC glad_glGetnHistogramARB;
PFNGLGETNMINMAXARBPROC glad_glGetnMinmaxARB;
PFNGLFRAMEBUFFERSAMPLELOCATIONSFVARBPROC glad_glFramebufferSampleLocationsfvARB;
PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVARBPROC glad_glNamedFramebufferSampleLocationsfvARB;
PFNGLEVALUATEDEPTHVALUESARBPROC glad_glEvaluateDepthValuesARB;
PFNGLMINSAMPLESHADINGARBPROC glad_glMinSampleShadingARB;
PFNGLDELETEOBJECTARBPROC glad_glDeleteObjectARB;
PFNGLGETHANDLEARBPROC glad_glGetHandleARB;
PFNGLDETACHOBJECTARBPROC glad_glDetachObjectARB;
PFNGLCREATESHADEROBJECTARBPROC glad_glCreateShaderObjectARB;
PFNGLSHADERSOURCEARBPROC glad_glShaderSourceARB;
PFNGLCOMPILESHADERARBPROC glad_glCompileShaderARB;
PFNGLCREATEPROGRAMOBJECTARBPROC glad_glCreateProgramObjectARB;
PFNGLATTACHOBJECTARBPROC glad_glAttachObjectARB;
PFNGLLINKPROGRAMARBPROC glad_glLinkProgramARB;
PFNGLUSEPROGRAMOBJECTARBPROC glad_glUseProgramObjectARB;
PFNGLVALIDATEPROGRAMARBPROC glad_glValidateProgramARB;
PFNGLUNIFORM1FARBPROC glad_glUniform1fARB;
PFNGLUNIFORM2FARBPROC glad_glUniform2fARB;
PFNGLUNIFORM3FARBPROC glad_glUniform3fARB;
PFNGLUNIFORM4FARBPROC glad_glUniform4fARB;
PFNGLUNIFORM1IARBPROC glad_glUniform1iARB;
PFNGLUNIFORM2IARBPROC glad_glUniform2iARB;
PFNGLUNIFORM3IARBPROC glad_glUniform3iARB;
PFNGLUNIFORM4IARBPROC glad_glUniform4iARB;
PFNGLUNIFORM1FVARBPROC glad_glUniform1fvARB;
PFNGLUNIFORM2FVARBPROC glad_glUniform2fvARB;
PFNGLUNIFORM3FVARBPROC glad_glUniform3fvARB;
PFNGLUNIFORM4FVARBPROC glad_glUniform4fvARB;
PFNGLUNIFORM1IVARBPROC glad_glUniform1ivARB;
PFNGLUNIFORM2IVARBPROC glad_glUniform2ivARB;
PFNGLUNIFORM3IVARBPROC glad_glUniform3ivARB;
PFNGLUNIFORM4IVARBPROC glad_glUniform4ivARB;
PFNGLUNIFORMMATRIX2FVARBPROC glad_glUniformMatrix2fvARB;
PFNGLUNIFORMMATRIX3FVARBPROC glad_glUniformMatrix3fvARB;
PFNGLUNIFORMMATRIX4FVARBPROC glad_glUniformMatrix4fvARB;
PFNGLGETOBJECTPARAMETERFVARBPROC glad_glGetObjectParameterfvARB;
PFNGLGETOBJECTPARAMETERIVARBPROC glad_glGetObjectParameterivARB;
PFNGLGETINFOLOGARBPROC glad_glGetInfoLogARB;
PFNGLGETATTACHEDOBJECTSARBPROC glad_glGetAttachedObjectsARB;
PFNGLGETUNIFORMLOCATIONARBPROC glad_glGetUniformLocationARB;
PFNGLGETACTIVEUNIFORMARBPROC glad_glGetActiveUniformARB;
PFNGLGETUNIFORMFVARBPROC glad_glGetUniformfvARB;
PFNGLGETUNIFORMIVARBPROC glad_glGetUniformivARB;
PFNGLGETSHADERSOURCEARBPROC glad_glGetShaderSourceARB;
PFNGLNAMEDSTRINGARBPROC glad_glNamedStringARB;
PFNGLDELETENAMEDSTRINGARBPROC glad_glDeleteNamedStringARB;
PFNGLCOMPILESHADERINCLUDEARBPROC glad_glCompileShaderIncludeARB;
PFNGLISNAMEDSTRINGARBPROC glad_glIsNamedStringARB;
PFNGLGETNAMEDSTRINGARBPROC glad_glGetNamedStringARB;
PFNGLGETNAMEDSTRINGIVARBPROC glad_glGetNamedStringivARB;
PFNGLBUFFERPAGECOMMITMENTARBPROC glad_glBufferPageCommitmentARB;
PFNGLNAMEDBUFFERPAGECOMMITMENTEXTPROC glad_glNamedBufferPageCommitmentEXT;
PFNGLNAMEDBUFFERPAGECOMMITMENTARBPROC glad_glNamedBufferPageCommitmentARB;
PFNGLTEXPAGECOMMITMENTARBPROC glad_glTexPageCommitmentARB;
PFNGLTEXBUFFERARBPROC glad_glTexBufferARB;
PFNGLCOMPRESSEDTEXIMAGE3DARBPROC glad_glCompressedTexImage3DARB;
PFNGLCOMPRESSEDTEXIMAGE2DARBPROC glad_glCompressedTexImage2DARB;
PFNGLCOMPRESSEDTEXIMAGE1DARBPROC glad_glCompressedTexImage1DARB;
PFNGLCOMPRESSEDTEXSUBIMAGE3DARBPROC glad_glCompressedTexSubImage3DARB;
PFNGLCOMPRESSEDTEXSUBIMAGE2DARBPROC glad_glCompressedTexSubImage2DARB;
PFNGLCOMPRESSEDTEXSUBIMAGE1DARBPROC glad_glCompressedTexSubImage1DARB;
PFNGLGETCOMPRESSEDTEXIMAGEARBPROC glad_glGetCompressedTexImageARB;
PFNGLLOADTRANSPOSEMATRIXFARBPROC glad_glLoadTransposeMatrixfARB;
PFNGLLOADTRANSPOSEMATRIXDARBPROC glad_glLoadTransposeMatrixdARB;
PFNGLMULTTRANSPOSEMATRIXFARBPROC glad_glMultTransposeMatrixfARB;
PFNGLMULTTRANSPOSEMATRIXDARBPROC glad_glMultTransposeMatrixdARB;
PFNGLWEIGHTBVARBPROC glad_glWeightbvARB;
PFNGLWEIGHTSVARBPROC glad_glWeightsvARB;
PFNGLWEIGHTIVARBPROC glad_glWeightivARB;
PFNGLWEIGHTFVARBPROC glad_glWeightfvARB;
PFNGLWEIGHTDVARBPROC glad_glWeightdvARB;
PFNGLWEIGHTUBVARBPROC glad_glWeightubvARB;
PFNGLWEIGHTUSVARBPROC glad_glWeightusvARB;
PFNGLWEIGHTUIVARBPROC glad_glWeightuivARB;
PFNGLWEIGHTPOINTERARBPROC glad_glWeightPointerARB;
PFNGLVERTEXBLENDARBPROC glad_glVertexBlendARB;
PFNGLBINDBUFFERARBPROC glad_glBindBufferARB;
PFNGLDELETEBUFFERSARBPROC glad_glDeleteBuffersARB;
PFNGLGENBUFFERSARBPROC glad_glGenBuffersARB;
PFNGLISBUFFERARBPROC glad_glIsBufferARB;
PFNGLBUFFERDATAARBPROC glad_glBufferDataARB;
PFNGLBUFFERSUBDATAARBPROC glad_glBufferSubDataARB;
PFNGLGETBUFFERSUBDATAARBPROC glad_glGetBufferSubDataARB;
PFNGLMAPBUFFERARBPROC glad_glMapBufferARB;
PFNGLUNMAPBUFFERARBPROC glad_glUnmapBufferARB;
PFNGLGETBUFFERPARAMETERIVARBPROC glad_glGetBufferParameterivARB;
PFNGLGETBUFFERPOINTERVARBPROC glad_glGetBufferPointervARB;
PFNGLVERTEXATTRIB1DARBPROC glad_glVertexAttrib1dARB;
PFNGLVERTEXATTRIB1DVARBPROC glad_glVertexAttrib1dvARB;
PFNGLVERTEXATTRIB1FARBPROC glad_glVertexAttrib1fARB;
PFNGLVERTEXATTRIB1FVARBPROC glad_glVertexAttrib1fvARB;
PFNGLVERTEXATTRIB1SARBPROC glad_glVertexAttrib1sARB;
PFNGLVERTEXATTRIB1SVARBPROC glad_glVertexAttrib1svARB;
PFNGLVERTEXATTRIB2DARBPROC glad_glVertexAttrib2dARB;
PFNGLVERTEXATTRIB2DVARBPROC glad_glVertexAttrib2dvARB;
PFNGLVERTEXATTRIB2FARBPROC glad_glVertexAttrib2fARB;
PFNGLVERTEXATTRIB2FVARBPROC glad_glVertexAttrib2fvARB;
PFNGLVERTEXATTRIB2SARBPROC glad_glVertexAttrib2sARB;
PFNGLVERTEXATTRIB2SVARBPROC glad_glVertexAttrib2svARB;
PFNGLVERTEXATTRIB3DARBPROC glad_glVertexAttrib3dARB;
PFNGLVERTEXATTRIB3DVARBPROC glad_glVertexAttrib3dvARB;
PFNGLVERTEXATTRIB3FARBPROC glad_glVertexAttrib3fARB;
PFNGLVERTEXATTRIB3FVARBPROC glad_glVertexAttrib3fvARB;
PFNGLVERTEXATTRIB3SARBPROC glad_glVertexAttrib3sARB;
PFNGLVERTEXATTRIB3SVARBPROC glad_glVertexAttrib3svARB;
PFNGLVERTEXATTRIB4NBVARBPROC glad_glVertexAttrib4NbvARB;
PFNGLVERTEXATTRIB4NIVARBPROC glad_glVertexAttrib4NivARB;
PFNGLVERTEXATTRIB4NSVARBPROC glad_glVertexAttrib4NsvARB;
PFNGLVERTEXATTRIB4NUBARBPROC glad_glVertexAttrib4NubARB;
PFNGLVERTEXATTRIB4NUBVARBPROC glad_glVertexAttrib4NubvARB;
PFNGLVERTEXATTRIB4NUIVARBPROC glad_glVertexAttrib4NuivARB;
PFNGLVERTEXATTRIB4NUSVARBPROC glad_glVertexAttrib4NusvARB;
PFNGLVERTEXATTRIB4BVARBPROC glad_glVertexAttrib4bvARB;
PFNGLVERTEXATTRIB4DARBPROC glad_glVertexAttrib4dARB;
PFNGLVERTEXATTRIB4DVARBPROC glad_glVertexAttrib4dvARB;
PFNGLVERTEXATTRIB4FARBPROC glad_glVertexAttrib4fARB;
PFNGLVERTEXATTRIB4FVARBPROC glad_glVertexAttrib4fvARB;
PFNGLVERTEXATTRIB4IVARBPROC glad_glVertexAttrib4ivARB;
PFNGLVERTEXATTRIB4SARBPROC glad_glVertexAttrib4sARB;
PFNGLVERTEXATTRIB4SVARBPROC glad_glVertexAttrib4svARB;
PFNGLVERTEXATTRIB4UBVARBPROC glad_glVertexAttrib4ubvARB;
PFNGLVERTEXATTRIB4UIVARBPROC glad_glVertexAttrib4uivARB;
PFNGLVERTEXATTRIB4USVARBPROC glad_glVertexAttrib4usvARB;
PFNGLVERTEXATTRIBPOINTERARBPROC glad_glVertexAttribPointerARB;
PFNGLENABLEVERTEXATTRIBARRAYARBPROC glad_glEnableVertexAttribArrayARB;
PFNGLDISABLEVERTEXATTRIBARRAYARBPROC glad_glDisableVertexAttribArrayARB;
PFNGLGETVERTEXATTRIBDVARBPROC glad_glGetVertexAttribdvARB;
PFNGLGETVERTEXATTRIBFVARBPROC glad_glGetVertexAttribfvARB;
PFNGLGETVERTEXATTRIBIVARBPROC glad_glGetVertexAttribivARB;
PFNGLGETVERTEXATTRIBPOINTERVARBPROC glad_glGetVertexAttribPointervARB;
PFNGLBINDATTRIBLOCATIONARBPROC glad_glBindAttribLocationARB;
PFNGLGETACTIVEATTRIBARBPROC glad_glGetActiveAttribARB;
PFNGLGETATTRIBLOCATIONARBPROC glad_glGetAttribLocationARB;
PFNGLWINDOWPOS2DARBPROC glad_glWindowPos2dARB;
PFNGLWINDOWPOS2DVARBPROC glad_glWindowPos2dvARB;
PFNGLWINDOWPOS2FARBPROC glad_glWindowPos2fARB;
PFNGLWINDOWPOS2FVARBPROC glad_glWindowPos2fvARB;
PFNGLWINDOWPOS2IARBPROC glad_glWindowPos2iARB;
PFNGLWINDOWPOS2IVARBPROC glad_glWindowPos2ivARB;
PFNGLWINDOWPOS2SARBPROC glad_glWindowPos2sARB;
PFNGLWINDOWPOS2SVARBPROC glad_glWindowPos2svARB;
PFNGLWINDOWPOS3DARBPROC glad_glWindowPos3dARB;
PFNGLWINDOWPOS3DVARBPROC glad_glWindowPos3dvARB;
PFNGLWINDOWPOS3FARBPROC glad_glWindowPos3fARB;
PFNGLWINDOWPOS3FVARBPROC glad_glWindowPos3fvARB;
PFNGLWINDOWPOS3IARBPROC glad_glWindowPos3iARB;
PFNGLWINDOWPOS3IVARBPROC glad_glWindowPos3ivARB;
PFNGLWINDOWPOS3SARBPROC glad_glWindowPos3sARB;
PFNGLWINDOWPOS3SVARBPROC glad_glWindowPos3svARB;
PFNGLDRAWBUFFERSATIPROC glad_glDrawBuffersATI;
PFNGLELEMENTPOINTERATIPROC glad_glElementPointerATI;
PFNGLDRAWELEMENTARRAYATIPROC glad_glDrawElementArrayATI;
PFNGLDRAWRANGEELEMENTARRAYATIPROC glad_glDrawRangeElementArrayATI;
PFNGLTEXBUMPPARAMETERIVATIPROC glad_glTexBumpParameterivATI;
PFNGLTEXBUMPPARAMETERFVATIPROC glad_glTexBumpParameterfvATI;
PFNGLGETTEXBUMPPARAMETERIVATIPROC glad_glGetTexBumpParameterivATI;
PFNGLGETTEXBUMPPARAMETERFVATIPROC glad_glGetTexBumpParameterfvATI;
PFNGLGENFRAGMENTSHADERSATIPROC glad_glGenFragmentShadersATI;
PFNGLBINDFRAGMENTSHADERATIPROC glad_glBindFragmentShaderATI;
PFNGLDELETEFRAGMENTSHADERATIPROC glad_glDeleteFragmentShaderATI;
PFNGLBEGINFRAGMENTSHADERATIPROC glad_glBeginFragmentShaderATI;
PFNGLENDFRAGMENTSHADERATIPROC glad_glEndFragmentShaderATI;
PFNGLPASSTEXCOORDATIPROC glad_glPassTexCoordATI;
PFNGLSAMPLEMAPATIPROC glad_glSampleMapATI;
PFNGLCOLORFRAGMENTOP1ATIPROC glad_glColorFragmentOp1ATI;
PFNGLCOLORFRAGMENTOP2ATIPROC glad_glColorFragmentOp2ATI;
PFNGLCOLORFRAGMENTOP3ATIPROC glad_glColorFragmentOp3ATI;
PFNGLALPHAFRAGMENTOP1ATIPROC glad_glAlphaFragmentOp1ATI;
PFNGLALPHAFRAGMENTOP2ATIPROC glad_glAlphaFragmentOp2ATI;
PFNGLALPHAFRAGMENTOP3ATIPROC glad_glAlphaFragmentOp3ATI;
PFNGLSETFRAGMENTSHADERCONSTANTATIPROC glad_glSetFragmentShaderConstantATI;
PFNGLMAPOBJECTBUFFERATIPROC glad_glMapObjectBufferATI;
PFNGLUNMAPOBJECTBUFFERATIPROC glad_glUnmapObjectBufferATI;
PFNGLPNTRIANGLESIATIPROC glad_glPNTrianglesiATI;
PFNGLPNTRIANGLESFATIPROC glad_glPNTrianglesfATI;
PFNGLSTENCILOPSEPARATEATIPROC glad_glStencilOpSeparateATI;
PFNGLSTENCILFUNCSEPARATEATIPROC glad_glStencilFuncSeparateATI;
PFNGLNEWOBJECTBUFFERATIPROC glad_glNewObjectBufferATI;
PFNGLISOBJECTBUFFERATIPROC glad_glIsObjectBufferATI;
PFNGLUPDATEOBJECTBUFFERATIPROC glad_glUpdateObjectBufferATI;
PFNGLGETOBJECTBUFFERFVATIPROC glad_glGetObjectBufferfvATI;
PFNGLGETOBJECTBUFFERIVATIPROC glad_glGetObjectBufferivATI;
PFNGLFREEOBJECTBUFFERATIPROC glad_glFreeObjectBufferATI;
PFNGLARRAYOBJECTATIPROC glad_glArrayObjectATI;
PFNGLGETARRAYOBJECTFVATIPROC glad_glGetArrayObjectfvATI;
PFNGLGETARRAYOBJECTIVATIPROC glad_glGetArrayObjectivATI;
PFNGLVARIANTARRAYOBJECTATIPROC glad_glVariantArrayObjectATI;
PFNGLGETVARIANTARRAYOBJECTFVATIPROC glad_glGetVariantArrayObjectfvATI;
PFNGLGETVARIANTARRAYOBJECTIVATIPROC glad_glGetVariantArrayObjectivATI;
PFNGLVERTEXATTRIBARRAYOBJECTATIPROC glad_glVertexAttribArrayObjectATI;
PFNGLGETVERTEXATTRIBARRAYOBJECTFVATIPROC glad_glGetVertexAttribArrayObjectfvATI;
PFNGLGETVERTEXATTRIBARRAYOBJECTIVATIPROC glad_glGetVertexAttribArrayObjectivATI;
PFNGLVERTEXSTREAM1SATIPROC glad_glVertexStream1sATI;
PFNGLVERTEXSTREAM1SVATIPROC glad_glVertexStream1svATI;
PFNGLVERTEXSTREAM1IATIPROC glad_glVertexStream1iATI;
PFNGLVERTEXSTREAM1IVATIPROC glad_glVertexStream1ivATI;
PFNGLVERTEXSTREAM1FATIPROC glad_glVertexStream1fATI;
PFNGLVERTEXSTREAM1FVATIPROC glad_glVertexStream1fvATI;
PFNGLVERTEXSTREAM1DATIPROC glad_glVertexStream1dATI;
PFNGLVERTEXSTREAM1DVATIPROC glad_glVertexStream1dvATI;
PFNGLVERTEXSTREAM2SATIPROC glad_glVertexStream2sATI;
PFNGLVERTEXSTREAM2SVATIPROC glad_glVertexStream2svATI;
PFNGLVERTEXSTREAM2IATIPROC glad_glVertexStream2iATI;
PFNGLVERTEXSTREAM2IVATIPROC glad_glVertexStream2ivATI;
PFNGLVERTEXSTREAM2FATIPROC glad_glVertexStream2fATI;
PFNGLVERTEXSTREAM2FVATIPROC glad_glVertexStream2fvATI;
PFNGLVERTEXSTREAM2DATIPROC glad_glVertexStream2dATI;
PFNGLVERTEXSTREAM2DVATIPROC glad_glVertexStream2dvATI;
PFNGLVERTEXSTREAM3SATIPROC glad_glVertexStream3sATI;
PFNGLVERTEXSTREAM3SVATIPROC glad_glVertexStream3svATI;
PFNGLVERTEXSTREAM3IATIPROC glad_glVertexStream3iATI;
PFNGLVERTEXSTREAM3IVATIPROC glad_glVertexStream3ivATI;
PFNGLVERTEXSTREAM3FATIPROC glad_glVertexStream3fATI;
PFNGLVERTEXSTREAM3FVATIPROC glad_glVertexStream3fvATI;
PFNGLVERTEXSTREAM3DATIPROC glad_glVertexStream3dATI;
PFNGLVERTEXSTREAM3DVATIPROC glad_glVertexStream3dvATI;
PFNGLVERTEXSTREAM4SATIPROC glad_glVertexStream4sATI;
PFNGLVERTEXSTREAM4SVATIPROC glad_glVertexStream4svATI;
PFNGLVERTEXSTREAM4IATIPROC glad_glVertexStream4iATI;
PFNGLVERTEXSTREAM4IVATIPROC glad_glVertexStream4ivATI;
PFNGLVERTEXSTREAM4FATIPROC glad_glVertexStream4fATI;
PFNGLVERTEXSTREAM4FVATIPROC glad_glVertexStream4fvATI;
PFNGLVERTEXSTREAM4DATIPROC glad_glVertexStream4dATI;
PFNGLVERTEXSTREAM4DVATIPROC glad_glVertexStream4dvATI;
PFNGLNORMALSTREAM3BATIPROC glad_glNormalStream3bATI;
PFNGLNORMALSTREAM3BVATIPROC glad_glNormalStream3bvATI;
PFNGLNORMALSTREAM3SATIPROC glad_glNormalStream3sATI;
PFNGLNORMALSTREAM3SVATIPROC glad_glNormalStream3svATI;
PFNGLNORMALSTREAM3IATIPROC glad_glNormalStream3iATI;
PFNGLNORMALSTREAM3IVATIPROC glad_glNormalStream3ivATI;
PFNGLNORMALSTREAM3FATIPROC glad_glNormalStream3fATI;
PFNGLNORMALSTREAM3FVATIPROC glad_glNormalStream3fvATI;
PFNGLNORMALSTREAM3DATIPROC glad_glNormalStream3dATI;
PFNGLNORMALSTREAM3DVATIPROC glad_glNormalStream3dvATI;
PFNGLCLIENTACTIVEVERTEXSTREAMATIPROC glad_glClientActiveVertexStreamATI;
PFNGLVERTEXBLENDENVIATIPROC glad_glVertexBlendEnviATI;
PFNGLVERTEXBLENDENVFATIPROC glad_glVertexBlendEnvfATI;
PFNGLUNIFORMBUFFEREXTPROC glad_glUniformBufferEXT;
PFNGLGETUNIFORMBUFFERSIZEEXTPROC glad_glGetUniformBufferSizeEXT;
PFNGLGETUNIFORMOFFSETEXTPROC glad_glGetUniformOffsetEXT;
PFNGLBLENDCOLOREXTPROC glad_glBlendColorEXT;
PFNGLBLENDEQUATIONSEPARATEEXTPROC glad_glBlendEquationSeparateEXT;
PFNGLBLENDFUNCSEPARATEEXTPROC glad_glBlendFuncSeparateEXT;
PFNGLBLENDEQUATIONEXTPROC glad_glBlendEquationEXT;
PFNGLCOLORSUBTABLEEXTPROC glad_glColorSubTableEXT;
PFNGLCOPYCOLORSUBTABLEEXTPROC glad_glCopyColorSubTableEXT;
PFNGLLOCKARRAYSEXTPROC glad_glLockArraysEXT;
PFNGLUNLOCKARRAYSEXTPROC glad_glUnlockArraysEXT;
PFNGLCONVOLUTIONFILTER1DEXTPROC glad_glConvolutionFilter1DEXT;
PFNGLCONVOLUTIONFILTER2DEXTPROC glad_glConvolutionFilter2DEXT;
PFNGLCONVOLUTIONPARAMETERFEXTPROC glad_glConvolutionParameterfEXT;
PFNGLCONVOLUTIONPARAMETERFVEXTPROC glad_glConvolutionParameterfvEXT;
PFNGLCONVOLUTIONPARAMETERIEXTPROC glad_glConvolutionParameteriEXT;
PFNGLCONVOLUTIONPARAMETERIVEXTPROC glad_glConvolutionParameterivEXT;
PFNGLCOPYCONVOLUTIONFILTER1DEXTPROC glad_glCopyConvolutionFilter1DEXT;
PFNGLCOPYCONVOLUTIONFILTER2DEXTPROC glad_glCopyConvolutionFilter2DEXT;
PFNGLGETCONVOLUTIONFILTEREXTPROC glad_glGetConvolutionFilterEXT;
PFNGLGETCONVOLUTIONPARAMETERFVEXTPROC glad_glGetConvolutionParameterfvEXT;
PFNGLGETCONVOLUTIONPARAMETERIVEXTPROC glad_glGetConvolutionParameterivEXT;
PFNGLGETSEPARABLEFILTEREXTPROC glad_glGetSeparableFilterEXT;
PFNGLSEPARABLEFILTER2DEXTPROC glad_glSeparableFilter2DEXT;
PFNGLTANGENT3BEXTPROC glad_glTangent3bEXT;
PFNGLTANGENT3BVEXTPROC glad_glTangent3bvEXT;
PFNGLTANGENT3DEXTPROC glad_glTangent3dEXT;
PFNGLTANGENT3DVEXTPROC glad_glTangent3dvEXT;
PFNGLTANGENT3FEXTPROC glad_glTangent3fEXT;
PFNGLTANGENT3FVEXTPROC glad_glTangent3fvEXT;
PFNGLTANGENT3IEXTPROC glad_glTangent3iEXT;
PFNGLTANGENT3IVEXTPROC glad_glTangent3ivEXT;
PFNGLTANGENT3SEXTPROC glad_glTangent3sEXT;
PFNGLTANGENT3SVEXTPROC glad_glTangent3svEXT;
PFNGLBINORMAL3BEXTPROC glad_glBinormal3bEXT;
PFNGLBINORMAL3BVEXTPROC glad_glBinormal3bvEXT;
PFNGLBINORMAL3DEXTPROC glad_glBinormal3dEXT;
PFNGLBINORMAL3DVEXTPROC glad_glBinormal3dvEXT;
PFNGLBINORMAL3FEXTPROC glad_glBinormal3fEXT;
PFNGLBINORMAL3FVEXTPROC glad_glBinormal3fvEXT;
PFNGLBINORMAL3IEXTPROC glad_glBinormal3iEXT;
PFNGLBINORMAL3IVEXTPROC glad_glBinormal3ivEXT;
PFNGLBINORMAL3SEXTPROC glad_glBinormal3sEXT;
PFNGLBINORMAL3SVEXTPROC glad_glBinormal3svEXT;
PFNGLTANGENTPOINTEREXTPROC glad_glTangentPointerEXT;
PFNGLBINORMALPOINTEREXTPROC glad_glBinormalPointerEXT;
PFNGLCOPYTEXIMAGE1DEXTPROC glad_glCopyTexImage1DEXT;
PFNGLCOPYTEXIMAGE2DEXTPROC glad_glCopyTexImage2DEXT;
PFNGLCOPYTEXSUBIMAGE1DEXTPROC glad_glCopyTexSubImage1DEXT;
PFNGLCOPYTEXSUBIMAGE2DEXTPROC glad_glCopyTexSubImage2DEXT;
PFNGLCOPYTEXSUBIMAGE3DEXTPROC glad_glCopyTexSubImage3DEXT;
PFNGLCULLPARAMETERDVEXTPROC glad_glCullParameterdvEXT;
PFNGLCULLPARAMETERFVEXTPROC glad_glCullParameterfvEXT;
PFNGLLABELOBJECTEXTPROC glad_glLabelObjectEXT;
PFNGLGETOBJECTLABELEXTPROC glad_glGetObjectLabelEXT;
PFNGLINSERTEVENTMARKEREXTPROC glad_glInsertEventMarkerEXT;
PFNGLPUSHGROUPMARKEREXTPROC glad_glPushGroupMarkerEXT;
PFNGLPOPGROUPMARKEREXTPROC glad_glPopGroupMarkerEXT;
PFNGLDEPTHBOUNDSEXTPROC glad_glDepthBoundsEXT;
PFNGLMATRIXLOADFEXTPROC glad_glMatrixLoadfEXT;
PFNGLMATRIXLOADDEXTPROC glad_glMatrixLoaddEXT;
PFNGLMATRIXMULTFEXTPROC glad_glMatrixMultfEXT;
PFNGLMATRIXMULTDEXTPROC glad_glMatrixMultdEXT;
PFNGLMATRIXLOADIDENTITYEXTPROC glad_glMatrixLoadIdentityEXT;
PFNGLMATRIXROTATEFEXTPROC glad_glMatrixRotatefEXT;
PFNGLMATRIXROTATEDEXTPROC glad_glMatrixRotatedEXT;
PFNGLMATRIXSCALEFEXTPROC glad_glMatrixScalefEXT;
PFNGLMATRIXSCALEDEXTPROC glad_glMatrixScaledEXT;
PFNGLMATRIXTRANSLATEFEXTPROC glad_glMatrixTranslatefEXT;
PFNGLMATRIXTRANSLATEDEXTPROC glad_glMatrixTranslatedEXT;
PFNGLMATRIXFRUSTUMEXTPROC glad_glMatrixFrustumEXT;
PFNGLMATRIXORTHOEXTPROC glad_glMatrixOrthoEXT;
PFNGLMATRIXPOPEXTPROC glad_glMatrixPopEXT;
PFNGLMATRIXPUSHEXTPROC glad_glMatrixPushEXT;
PFNGLCLIENTATTRIBDEFAULTEXTPROC glad_glClientAttribDefaultEXT;
PFNGLPUSHCLIENTATTRIBDEFAULTEXTPROC glad_glPushClientAttribDefaultEXT;
PFNGLTEXTUREPARAMETERFEXTPROC glad_glTextureParameterfEXT;
PFNGLTEXTUREPARAMETERFVEXTPROC glad_glTextureParameterfvEXT;
PFNGLTEXTUREPARAMETERIEXTPROC glad_glTextureParameteriEXT;
PFNGLTEXTUREPARAMETERIVEXTPROC glad_glTextureParameterivEXT;
PFNGLTEXTUREIMAGE1DEXTPROC glad_glTextureImage1DEXT;
PFNGLTEXTUREIMAGE2DEXTPROC glad_glTextureImage2DEXT;
PFNGLTEXTURESUBIMAGE1DEXTPROC glad_glTextureSubImage1DEXT;
PFNGLTEXTURESUBIMAGE2DEXTPROC glad_glTextureSubImage2DEXT;
PFNGLCOPYTEXTUREIMAGE1DEXTPROC glad_glCopyTextureImage1DEXT;
PFNGLCOPYTEXTUREIMAGE2DEXTPROC glad_glCopyTextureImage2DEXT;
PFNGLCOPYTEXTURESUBIMAGE1DEXTPROC glad_glCopyTextureSubImage1DEXT;
PFNGLCOPYTEXTURESUBIMAGE2DEXTPROC glad_glCopyTextureSubImage2DEXT;
PFNGLGETTEXTUREIMAGEEXTPROC glad_glGetTextureImageEXT;
PFNGLGETTEXTUREPARAMETERFVEXTPROC glad_glGetTextureParameterfvEXT;
PFNGLGETTEXTUREPARAMETERIVEXTPROC glad_glGetTextureParameterivEXT;
PFNGLGETTEXTURELEVELPARAMETERFVEXTPROC glad_glGetTextureLevelParameterfvEXT;
PFNGLGETTEXTURELEVELPARAMETERIVEXTPROC glad_glGetTextureLevelParameterivEXT;
PFNGLTEXTUREIMAGE3DEXTPROC glad_glTextureImage3DEXT;
PFNGLTEXTURESUBIMAGE3DEXTPROC glad_glTextureSubImage3DEXT;
PFNGLCOPYTEXTURESUBIMAGE3DEXTPROC glad_glCopyTextureSubImage3DEXT;
PFNGLBINDMULTITEXTUREEXTPROC glad_glBindMultiTextureEXT;
PFNGLMULTITEXCOORDPOINTEREXTPROC glad_glMultiTexCoordPointerEXT;
PFNGLMULTITEXENVFEXTPROC glad_glMultiTexEnvfEXT;
PFNGLMULTITEXENVFVEXTPROC glad_glMultiTexEnvfvEXT;
PFNGLMULTITEXENVIEXTPROC glad_glMultiTexEnviEXT;
PFNGLMULTITEXENVIVEXTPROC glad_glMultiTexEnvivEXT;
PFNGLMULTITEXGENDEXTPROC glad_glMultiTexGendEXT;
PFNGLMULTITEXGENDVEXTPROC glad_glMultiTexGendvEXT;
PFNGLMULTITEXGENFEXTPROC glad_glMultiTexGenfEXT;
PFNGLMULTITEXGENFVEXTPROC glad_glMultiTexGenfvEXT;
PFNGLMULTITEXGENIEXTPROC glad_glMultiTexGeniEXT;
PFNGLMULTITEXGENIVEXTPROC glad_glMultiTexGenivEXT;
PFNGLGETMULTITEXENVFVEXTPROC glad_glGetMultiTexEnvfvEXT;
PFNGLGETMULTITEXENVIVEXTPROC glad_glGetMultiTexEnvivEXT;
PFNGLGETMULTITEXGENDVEXTPROC glad_glGetMultiTexGendvEXT;
PFNGLGETMULTITEXGENFVEXTPROC glad_glGetMultiTexGenfvEXT;
PFNGLGETMULTITEXGENIVEXTPROC glad_glGetMultiTexGenivEXT;
PFNGLMULTITEXPARAMETERIEXTPROC glad_glMultiTexParameteriEXT;
PFNGLMULTITEXPARAMETERIVEXTPROC glad_glMultiTexParameterivEXT;
PFNGLMULTITEXPARAMETERFEXTPROC glad_glMultiTexParameterfEXT;
PFNGLMULTITEXPARAMETERFVEXTPROC glad_glMultiTexParameterfvEXT;
PFNGLMULTITEXIMAGE1DEXTPROC glad_glMultiTexImage1DEXT;
PFNGLMULTITEXIMAGE2DEXTPROC glad_glMultiTexImage2DEXT;
PFNGLMULTITEXSUBIMAGE1DEXTPROC glad_glMultiTexSubImage1DEXT;
PFNGLMULTITEXSUBIMAGE2DEXTPROC glad_glMultiTexSubImage2DEXT;
PFNGLCOPYMULTITEXIMAGE1DEXTPROC glad_glCopyMultiTexImage1DEXT;
PFNGLCOPYMULTITEXIMAGE2DEXTPROC glad_glCopyMultiTexImage2DEXT;
PFNGLCOPYMULTITEXSUBIMAGE1DEXTPROC glad_glCopyMultiTexSubImage1DEXT;
PFNGLCOPYMULTITEXSUBIMAGE2DEXTPROC glad_glCopyMultiTexSubImage2DEXT;
PFNGLGETMULTITEXIMAGEEXTPROC glad_glGetMultiTexImageEXT;
PFNGLGETMULTITEXPARAMETERFVEXTPROC glad_glGetMultiTexParameterfvEXT;
PFNGLGETMULTITEXPARAMETERIVEXTPROC glad_glGetMultiTexParameterivEXT;
PFNGLGETMULTITEXLEVELPARAMETERFVEXTPROC glad_glGetMultiTexLevelParameterfvEXT;
PFNGLGETMULTITEXLEVELPARAMETERIVEXTPROC glad_glGetMultiTexLevelParameterivEXT;
PFNGLMULTITEXIMAGE3DEXTPROC glad_glMultiTexImage3DEXT;
PFNGLMULTITEXSUBIMAGE3DEXTPROC glad_glMultiTexSubImage3DEXT;
PFNGLCOPYMULTITEXSUBIMAGE3DEXTPROC glad_glCopyMultiTexSubImage3DEXT;
PFNGLENABLECLIENTSTATEINDEXEDEXTPROC glad_glEnableClientStateIndexedEXT;
PFNGLDISABLECLIENTSTATEINDEXEDEXTPROC glad_glDisableClientStateIndexedEXT;
PFNGLGETFLOATINDEXEDVEXTPROC glad_glGetFloatIndexedvEXT;
PFNGLGETDOUBLEINDEXEDVEXTPROC glad_glGetDoubleIndexedvEXT;
PFNGLGETPOINTERINDEXEDVEXTPROC glad_glGetPointerIndexedvEXT;
PFNGLENABLEINDEXEDEXTPROC glad_glEnableIndexedEXT;
PFNGLDISABLEINDEXEDEXTPROC glad_glDisableIndexedEXT;
PFNGLISENABLEDINDEXEDEXTPROC glad_glIsEnabledIndexedEXT;
PFNGLGETINTEGERINDEXEDVEXTPROC glad_glGetIntegerIndexedvEXT;
PFNGLGETBOOLEANINDEXEDVEXTPROC glad_glGetBooleanIndexedvEXT;
PFNGLCOMPRESSEDTEXTUREIMAGE3DEXTPROC glad_glCompressedTextureImage3DEXT;
PFNGLCOMPRESSEDTEXTUREIMAGE2DEXTPROC glad_glCompressedTextureImage2DEXT;
PFNGLCOMPRESSEDTEXTUREIMAGE1DEXTPROC glad_glCompressedTextureImage1DEXT;
PFNGLCOMPRESSEDTEXTURESUBIMAGE3DEXTPROC glad_glCompressedTextureSubImage3DEXT;
PFNGLCOMPRESSEDTEXTURESUBIMAGE2DEXTPROC glad_glCompressedTextureSubImage2DEXT;
PFNGLCOMPRESSEDTEXTURESUBIMAGE1DEXTPROC glad_glCompressedTextureSubImage1DEXT;
PFNGLGETCOMPRESSEDTEXTUREIMAGEEXTPROC glad_glGetCompressedTextureImageEXT;
PFNGLCOMPRESSEDMULTITEXIMAGE3DEXTPROC glad_glCompressedMultiTexImage3DEXT;
PFNGLCOMPRESSEDMULTITEXIMAGE2DEXTPROC glad_glCompressedMultiTexImage2DEXT;
PFNGLCOMPRESSEDMULTITEXIMAGE1DEXTPROC glad_glCompressedMultiTexImage1DEXT;
PFNGLCOMPRESSEDMULTITEXSUBIMAGE3DEXTPROC glad_glCompressedMultiTexSubImage3DEXT;
PFNGLCOMPRESSEDMULTITEXSUBIMAGE2DEXTPROC glad_glCompressedMultiTexSubImage2DEXT;
PFNGLCOMPRESSEDMULTITEXSUBIMAGE1DEXTPROC glad_glCompressedMultiTexSubImage1DEXT;
PFNGLGETCOMPRESSEDMULTITEXIMAGEEXTPROC glad_glGetCompressedMultiTexImageEXT;
PFNGLMATRIXLOADTRANSPOSEFEXTPROC glad_glMatrixLoadTransposefEXT;
PFNGLMATRIXLOADTRANSPOSEDEXTPROC glad_glMatrixLoadTransposedEXT;
PFNGLMATRIXMULTTRANSPOSEFEXTPROC glad_glMatrixMultTransposefEXT;
PFNGLMATRIXMULTTRANSPOSEDEXTPROC glad_glMatrixMultTransposedEXT;
PFNGLNAMEDBUFFERDATAEXTPROC glad_glNamedBufferDataEXT;
PFNGLNAMEDBUFFERSUBDATAEXTPROC glad_glNamedBufferSubDataEXT;
PFNGLMAPNAMEDBUFFEREXTPROC glad_glMapNamedBufferEXT;
PFNGLUNMAPNAMEDBUFFEREXTPROC glad_glUnmapNamedBufferEXT;
PFNGLGETNAMEDBUFFERPARAMETERIVEXTPROC glad_glGetNamedBufferParameterivEXT;
PFNGLGETNAMEDBUFFERPOINTERVEXTPROC glad_glGetNamedBufferPointervEXT;
PFNGLGETNAMEDBUFFERSUBDATAEXTPROC glad_glGetNamedBufferSubDataEXT;
PFNGLPROGRAMUNIFORM1FEXTPROC glad_glProgramUniform1fEXT;
PFNGLPROGRAMUNIFORM2FEXTPROC glad_glProgramUniform2fEXT;
PFNGLPROGRAMUNIFORM3FEXTPROC glad_glProgramUniform3fEXT;
PFNGLPROGRAMUNIFORM4FEXTPROC glad_glProgramUniform4fEXT;
PFNGLPROGRAMUNIFORM1IEXTPROC glad_glProgramUniform1iEXT;
PFNGLPROGRAMUNIFORM2IEXTPROC glad_glProgramUniform2iEXT;
PFNGLPROGRAMUNIFORM3IEXTPROC glad_glProgramUniform3iEXT;
PFNGLPROGRAMUNIFORM4IEXTPROC glad_glProgramUniform4iEXT;
PFNGLPROGRAMUNIFORM1FVEXTPROC glad_glProgramUniform1fvEXT;
PFNGLPROGRAMUNIFORM2FVEXTPROC glad_glProgramUniform2fvEXT;
PFNGLPROGRAMUNIFORM3FVEXTPROC glad_glProgramUniform3fvEXT;
PFNGLPROGRAMUNIFORM4FVEXTPROC glad_glProgramUniform4fvEXT;
PFNGLPROGRAMUNIFORM1IVEXTPROC glad_glProgramUniform1ivEXT;
PFNGLPROGRAMUNIFORM2IVEXTPROC glad_glProgramUniform2ivEXT;
PFNGLPROGRAMUNIFORM3IVEXTPROC glad_glProgramUniform3ivEXT;
PFNGLPROGRAMUNIFORM4IVEXTPROC glad_glProgramUniform4ivEXT;
PFNGLPROGRAMUNIFORMMATRIX2FVEXTPROC glad_glProgramUniformMatrix2fvEXT;
PFNGLPROGRAMUNIFORMMATRIX3FVEXTPROC glad_glProgramUniformMatrix3fvEXT;
PFNGLPROGRAMUNIFORMMATRIX4FVEXTPROC glad_glProgramUniformMatrix4fvEXT;
PFNGLPROGRAMUNIFORMMATRIX2X3FVEXTPROC glad_glProgramUniformMatrix2x3fvEXT;
PFNGLPROGRAMUNIFORMMATRIX3X2FVEXTPROC glad_glProgramUniformMatrix3x2fvEXT;
PFNGLPROGRAMUNIFORMMATRIX2X4FVEXTPROC glad_glProgramUniformMatrix2x4fvEXT;
PFNGLPROGRAMUNIFORMMATRIX4X2FVEXTPROC glad_glProgramUniformMatrix4x2fvEXT;
PFNGLPROGRAMUNIFORMMATRIX3X4FVEXTPROC glad_glProgramUniformMatrix3x4fvEXT;
PFNGLPROGRAMUNIFORMMATRIX4X3FVEXTPROC glad_glProgramUniformMatrix4x3fvEXT;
PFNGLTEXTUREBUFFEREXTPROC glad_glTextureBufferEXT;
PFNGLMULTITEXBUFFEREXTPROC glad_glMultiTexBufferEXT;
PFNGLTEXTUREPARAMETERIIVEXTPROC glad_glTextureParameterIivEXT;
PFNGLTEXTUREPARAMETERIUIVEXTPROC glad_glTextureParameterIuivEXT;
PFNGLGETTEXTUREPARAMETERIIVEXTPROC glad_glGetTextureParameterIivEXT;
PFNGLGETTEXTUREPARAMETERIUIVEXTPROC glad_glGetTextureParameterIuivEXT;
PFNGLMULTITEXPARAMETERIIVEXTPROC glad_glMultiTexParameterIivEXT;
PFNGLMULTITEXPARAMETERIUIVEXTPROC glad_glMultiTexParameterIuivEXT;
PFNGLGETMULTITEXPARAMETERIIVEXTPROC glad_glGetMultiTexParameterIivEXT;
PFNGLGETMULTITEXPARAMETERIUIVEXTPROC glad_glGetMultiTexParameterIuivEXT;
PFNGLPROGRAMUNIFORM1UIEXTPROC glad_glProgramUniform1uiEXT;
PFNGLPROGRAMUNIFORM2UIEXTPROC glad_glProgramUniform2uiEXT;
PFNGLPROGRAMUNIFORM3UIEXTPROC glad_glProgramUniform3uiEXT;
PFNGLPROGRAMUNIFORM4UIEXTPROC glad_glProgramUniform4uiEXT;
PFNGLPROGRAMUNIFORM1UIVEXTPROC glad_glProgramUniform1uivEXT;
PFNGLPROGRAMUNIFORM2UIVEXTPROC glad_glProgramUniform2uivEXT;
PFNGLPROGRAMUNIFORM3UIVEXTPROC glad_glProgramUniform3uivEXT;
PFNGLPROGRAMUNIFORM4UIVEXTPROC glad_glProgramUniform4uivEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETERS4FVEXTPROC glad_glNamedProgramLocalParameters4fvEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETERI4IEXTPROC glad_glNamedProgramLocalParameterI4iEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETERI4IVEXTPROC glad_glNamedProgramLocalParameterI4ivEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETERSI4IVEXTPROC glad_glNamedProgramLocalParametersI4ivEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIEXTPROC glad_glNamedProgramLocalParameterI4uiEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIVEXTPROC glad_glNamedProgramLocalParameterI4uivEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETERSI4UIVEXTPROC glad_glNamedProgramLocalParametersI4uivEXT;
PFNGLGETNAMEDPROGRAMLOCALPARAMETERIIVEXTPROC glad_glGetNamedProgramLocalParameterIivEXT;
PFNGLGETNAMEDPROGRAMLOCALPARAMETERIUIVEXTPROC glad_glGetNamedProgramLocalParameterIuivEXT;
PFNGLENABLECLIENTSTATEIEXTPROC glad_glEnableClientStateiEXT;
PFNGLDISABLECLIENTSTATEIEXTPROC glad_glDisableClientStateiEXT;
PFNGLGETFLOATI_VEXTPROC glad_glGetFloati_vEXT;
PFNGLGETDOUBLEI_VEXTPROC glad_glGetDoublei_vEXT;
PFNGLGETPOINTERI_VEXTPROC glad_glGetPointeri_vEXT;
PFNGLNAMEDPROGRAMSTRINGEXTPROC glad_glNamedProgramStringEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETER4DEXTPROC glad_glNamedProgramLocalParameter4dEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETER4DVEXTPROC glad_glNamedProgramLocalParameter4dvEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETER4FEXTPROC glad_glNamedProgramLocalParameter4fEXT;
PFNGLNAMEDPROGRAMLOCALPARAMETER4FVEXTPROC glad_glNamedProgramLocalParameter4fvEXT;
PFNGLGETNAMEDPROGRAMLOCALPARAMETERDVEXTPROC glad_glGetNamedProgramLocalParameterdvEXT;
PFNGLGETNAMEDPROGRAMLOCALPARAMETERFVEXTPROC glad_glGetNamedProgramLocalParameterfvEXT;
PFNGLGETNAMEDPROGRAMIVEXTPROC glad_glGetNamedProgramivEXT;
PFNGLGETNAMEDPROGRAMSTRINGEXTPROC glad_glGetNamedProgramStringEXT;
PFNGLNAMEDRENDERBUFFERSTORAGEEXTPROC glad_glNamedRenderbufferStorageEXT;
PFNGLGETNAMEDRENDERBUFFERPARAMETERIVEXTPROC glad_glGetNamedRenderbufferParameterivEXT;
PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC glad_glNamedRenderbufferStorageMultisampleEXT;
PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLECOVERAGEEXTPROC glad_glNamedRenderbufferStorageMultisampleCoverageEXT;
PFNGLCHECKNAMEDFRAMEBUFFERSTATUSEXTPROC glad_glCheckNamedFramebufferStatusEXT;
PFNGLNAMEDFRAMEBUFFERTEXTURE1DEXTPROC glad_glNamedFramebufferTexture1DEXT;
PFNGLNAMEDFRAMEBUFFERTEXTURE2DEXTPROC glad_glNamedFramebufferTexture2DEXT;
PFNGLNAMEDFRAMEBUFFERTEXTURE3DEXTPROC glad_glNamedFramebufferTexture3DEXT;
PFNGLNAMEDFRAMEBUFFERRENDERBUFFEREXTPROC glad_glNamedFramebufferRenderbufferEXT;
PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC glad_glGetNamedFramebufferAttachmentParameterivEXT;
PFNGLGENERATETEXTUREMIPMAPEXTPROC glad_glGenerateTextureMipmapEXT;
PFNGLGENERATEMULTITEXMIPMAPEXTPROC glad_glGenerateMultiTexMipmapEXT;
PFNGLFRAMEBUFFERDRAWBUFFEREXTPROC glad_glFramebufferDrawBufferEXT;
PFNGLFRAMEBUFFERDRAWBUFFERSEXTPROC glad_glFramebufferDrawBuffersEXT;
PFNGLFRAMEBUFFERREADBUFFEREXTPROC glad_glFramebufferReadBufferEXT;
PFNGLGETFRAMEBUFFERPARAMETERIVEXTPROC glad_glGetFramebufferParameterivEXT;
PFNGLNAMEDCOPYBUFFERSUBDATAEXTPROC glad_glNamedCopyBufferSubDataEXT;
PFNGLNAMEDFRAMEBUFFERTEXTUREEXTPROC glad_glNamedFramebufferTextureEXT;
PFNGLNAMEDFRAMEBUFFERTEXTURELAYEREXTPROC glad_glNamedFramebufferTextureLayerEXT;
PFNGLNAMEDFRAMEBUFFERTEXTUREFACEEXTPROC glad_glNamedFramebufferTextureFaceEXT;
PFNGLTEXTURERENDERBUFFEREXTPROC glad_glTextureRenderbufferEXT;
PFNGLMULTITEXRENDERBUFFEREXTPROC glad_glMultiTexRenderbufferEXT;
PFNGLVERTEXARRAYVERTEXOFFSETEXTPROC glad_glVertexArrayVertexOffsetEXT;
PFNGLVERTEXARRAYCOLOROFFSETEXTPROC glad_glVertexArrayColorOffsetEXT;
PFNGLVERTEXARRAYEDGEFLAGOFFSETEXTPROC glad_glVertexArrayEdgeFlagOffsetEXT;
PFNGLVERTEXARRAYINDEXOFFSETEXTPROC glad_glVertexArrayIndexOffsetEXT;
PFNGLVERTEXARRAYNORMALOFFSETEXTPROC glad_glVertexArrayNormalOffsetEXT;
PFNGLVERTEXARRAYTEXCOORDOFFSETEXTPROC glad_glVertexArrayTexCoordOffsetEXT;
PFNGLVERTEXARRAYMULTITEXCOORDOFFSETEXTPROC glad_glVertexArrayMultiTexCoordOffsetEXT;
PFNGLVERTEXARRAYFOGCOORDOFFSETEXTPROC glad_glVertexArrayFogCoordOffsetEXT;
PFNGLVERTEXARRAYSECONDARYCOLOROFFSETEXTPROC glad_glVertexArraySecondaryColorOffsetEXT;
PFNGLVERTEXARRAYVERTEXATTRIBOFFSETEXTPROC glad_glVertexArrayVertexAttribOffsetEXT;
PFNGLVERTEXARRAYVERTEXATTRIBIOFFSETEXTPROC glad_glVertexArrayVertexAttribIOffsetEXT;
PFNGLENABLEVERTEXARRAYEXTPROC glad_glEnableVertexArrayEXT;
PFNGLDISABLEVERTEXARRAYEXTPROC glad_glDisableVertexArrayEXT;
PFNGLENABLEVERTEXARRAYATTRIBEXTPROC glad_glEnableVertexArrayAttribEXT;
PFNGLDISABLEVERTEXARRAYATTRIBEXTPROC glad_glDisableVertexArrayAttribEXT;
PFNGLGETVERTEXARRAYINTEGERVEXTPROC glad_glGetVertexArrayIntegervEXT;
PFNGLGETVERTEXARRAYPOINTERVEXTPROC glad_glGetVertexArrayPointervEXT;
PFNGLGETVERTEXARRAYINTEGERI_VEXTPROC glad_glGetVertexArrayIntegeri_vEXT;
PFNGLGETVERTEXARRAYPOINTERI_VEXTPROC glad_glGetVertexArrayPointeri_vEXT;
PFNGLMAPNAMEDBUFFERRANGEEXTPROC glad_glMapNamedBufferRangeEXT;
PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEEXTPROC glad_glFlushMappedNamedBufferRangeEXT;
PFNGLNAMEDBUFFERSTORAGEEXTPROC glad_glNamedBufferStorageEXT;
PFNGLCLEARNAMEDBUFFERDATAEXTPROC glad_glClearNamedBufferDataEXT;
PFNGLCLEARNAMEDBUFFERSUBDATAEXTPROC glad_glClearNamedBufferSubDataEXT;
PFNGLNAMEDFRAMEBUFFERPARAMETERIEXTPROC glad_glNamedFramebufferParameteriEXT;
PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVEXTPROC glad_glGetNamedFramebufferParameterivEXT;
PFNGLPROGRAMUNIFORM1DEXTPROC glad_glProgramUniform1dEXT;
PFNGLPROGRAMUNIFORM2DEXTPROC glad_glProgramUniform2dEXT;
PFNGLPROGRAMUNIFORM3DEXTPROC glad_glProgramUniform3dEXT;
PFNGLPROGRAMUNIFORM4DEXTPROC glad_glProgramUniform4dEXT;
PFNGLPROGRAMUNIFORM1DVEXTPROC glad_glProgramUniform1dvEXT;
PFNGLPROGRAMUNIFORM2DVEXTPROC glad_glProgramUniform2dvEXT;
PFNGLPROGRAMUNIFORM3DVEXTPROC glad_glProgramUniform3dvEXT;
PFNGLPROGRAMUNIFORM4DVEXTPROC glad_glProgramUniform4dvEXT;
PFNGLPROGRAMUNIFORMMATRIX2DVEXTPROC glad_glProgramUniformMatrix2dvEXT;
PFNGLPROGRAMUNIFORMMATRIX3DVEXTPROC glad_glProgramUniformMatrix3dvEXT;
PFNGLPROGRAMUNIFORMMATRIX4DVEXTPROC glad_glProgramUniformMatrix4dvEXT;
PFNGLPROGRAMUNIFORMMATRIX2X3DVEXTPROC glad_glProgramUniformMatrix2x3dvEXT;
PFNGLPROGRAMUNIFORMMATRIX2X4DVEXTPROC glad_glProgramUniformMatrix2x4dvEXT;
PFNGLPROGRAMUNIFORMMATRIX3X2DVEXTPROC glad_glProgramUniformMatrix3x2dvEXT;
PFNGLPROGRAMUNIFORMMATRIX3X4DVEXTPROC glad_glProgramUniformMatrix3x4dvEXT;
PFNGLPROGRAMUNIFORMMATRIX4X2DVEXTPROC glad_glProgramUniformMatrix4x2dvEXT;
PFNGLPROGRAMUNIFORMMATRIX4X3DVEXTPROC glad_glProgramUniformMatrix4x3dvEXT;
PFNGLTEXTUREBUFFERRANGEEXTPROC glad_glTextureBufferRangeEXT;
PFNGLTEXTURESTORAGE1DEXTPROC glad_glTextureStorage1DEXT;
PFNGLTEXTURESTORAGE2DEXTPROC glad_glTextureStorage2DEXT;
PFNGLTEXTURESTORAGE3DEXTPROC glad_glTextureStorage3DEXT;
PFNGLTEXTURESTORAGE2DMULTISAMPLEEXTPROC glad_glTextureStorage2DMultisampleEXT;
PFNGLTEXTURESTORAGE3DMULTISAMPLEEXTPROC glad_glTextureStorage3DMultisampleEXT;
PFNGLVERTEXARRAYBINDVERTEXBUFFEREXTPROC glad_glVertexArrayBindVertexBufferEXT;
PFNGLVERTEXARRAYVERTEXATTRIBFORMATEXTPROC glad_glVertexArrayVertexAttribFormatEXT;
PFNGLVERTEXARRAYVERTEXATTRIBIFORMATEXTPROC glad_glVertexArrayVertexAttribIFormatEXT;
PFNGLVERTEXARRAYVERTEXATTRIBLFORMATEXTPROC glad_glVertexArrayVertexAttribLFormatEXT;
PFNGLVERTEXARRAYVERTEXATTRIBBINDINGEXTPROC glad_glVertexArrayVertexAttribBindingEXT;
PFNGLVERTEXARRAYVERTEXBINDINGDIVISOREXTPROC glad_glVertexArrayVertexBindingDivisorEXT;
PFNGLVERTEXARRAYVERTEXATTRIBLOFFSETEXTPROC glad_glVertexArrayVertexAttribLOffsetEXT;
PFNGLTEXTUREPAGECOMMITMENTEXTPROC glad_glTexturePageCommitmentEXT;
PFNGLVERTEXARRAYVERTEXATTRIBDIVISOREXTPROC glad_glVertexArrayVertexAttribDivisorEXT;
PFNGLCOLORMASKINDEXEDEXTPROC glad_glColorMaskIndexedEXT;
PFNGLDRAWARRAYSINSTANCEDEXTPROC glad_glDrawArraysInstancedEXT;
PFNGLDRAWELEMENTSINSTANCEDEXTPROC glad_glDrawElementsInstancedEXT;
PFNGLDRAWRANGEELEMENTSEXTPROC glad_glDrawRangeElementsEXT;
PFNGLFOGCOORDFEXTPROC glad_glFogCoordfEXT;
PFNGLFOGCOORDFVEXTPROC glad_glFogCoordfvEXT;
PFNGLFOGCOORDDEXTPROC glad_glFogCoorddEXT;
PFNGLFOGCOORDDVEXTPROC glad_glFogCoorddvEXT;
PFNGLFOGCOORDPOINTEREXTPROC glad_glFogCoordPointerEXT;
PFNGLBLITFRAMEBUFFEREXTPROC glad_glBlitFramebufferEXT;
PFNGLRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC glad_glRenderbufferStorageMultisampleEXT;
PFNGLISRENDERBUFFEREXTPROC glad_glIsRenderbufferEXT;
PFNGLBINDRENDERBUFFEREXTPROC glad_glBindRenderbufferEXT;
PFNGLDELETERENDERBUFFERSEXTPROC glad_glDeleteRenderbuffersEXT;
PFNGLGENRENDERBUFFERSEXTPROC glad_glGenRenderbuffersEXT;
PFNGLRENDERBUFFERSTORAGEEXTPROC glad_glRenderbufferStorageEXT;
PFNGLGETRENDERBUFFERPARAMETERIVEXTPROC glad_glGetRenderbufferParameterivEXT;
PFNGLISFRAMEBUFFEREXTPROC glad_glIsFramebufferEXT;
PFNGLBINDFRAMEBUFFEREXTPROC glad_glBindFramebufferEXT;
PFNGLDELETEFRAMEBUFFERSEXTPROC glad_glDeleteFramebuffersEXT;
PFNGLGENFRAMEBUFFERSEXTPROC glad_glGenFramebuffersEXT;
PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC glad_glCheckFramebufferStatusEXT;
PFNGLFRAMEBUFFERTEXTURE1DEXTPROC glad_glFramebufferTexture1DEXT;
PFNGLFRAMEBUFFERTEXTURE2DEXTPROC glad_glFramebufferTexture2DEXT;
PFNGLFRAMEBUFFERTEXTURE3DEXTPROC glad_glFramebufferTexture3DEXT;
PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC glad_glFramebufferRenderbufferEXT;
PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC glad_glGetFramebufferAttachmentParameterivEXT;
PFNGLGENERATEMIPMAPEXTPROC glad_glGenerateMipmapEXT;
PFNGLPROGRAMPARAMETERIEXTPROC glad_glProgramParameteriEXT;
PFNGLPROGRAMENVPARAMETERS4FVEXTPROC glad_glProgramEnvParameters4fvEXT;
PFNGLPROGRAMLOCALPARAMETERS4FVEXTPROC glad_glProgramLocalParameters4fvEXT;
PFNGLGETUNIFORMUIVEXTPROC glad_glGetUniformuivEXT;
PFNGLBINDFRAGDATALOCATIONEXTPROC glad_glBindFragDataLocationEXT;
PFNGLGETFRAGDATALOCATIONEXTPROC glad_glGetFragDataLocationEXT;
PFNGLUNIFORM1UIEXTPROC glad_glUniform1uiEXT;
PFNGLUNIFORM2UIEXTPROC glad_glUniform2uiEXT;
PFNGLUNIFORM3UIEXTPROC glad_glUniform3uiEXT;
PFNGLUNIFORM4UIEXTPROC glad_glUniform4uiEXT;
PFNGLUNIFORM1UIVEXTPROC glad_glUniform1uivEXT;
PFNGLUNIFORM2UIVEXTPROC glad_glUniform2uivEXT;
PFNGLUNIFORM3UIVEXTPROC glad_glUniform3uivEXT;
PFNGLUNIFORM4UIVEXTPROC glad_glUniform4uivEXT;
PFNGLGETHISTOGRAMEXTPROC glad_glGetHistogramEXT;
PFNGLGETHISTOGRAMPARAMETERFVEXTPROC glad_glGetHistogramParameterfvEXT;
PFNGLGETHISTOGRAMPARAMETERIVEXTPROC glad_glGetHistogramParameterivEXT;
PFNGLGETMINMAXEXTPROC glad_glGetMinmaxEXT;
PFNGLGETMINMAXPARAMETERFVEXTPROC glad_glGetMinmaxParameterfvEXT;
PFNGLGETMINMAXPARAMETERIVEXTPROC glad_glGetMinmaxParameterivEXT;
PFNGLHISTOGRAMEXTPROC glad_glHistogramEXT;
PFNGLMINMAXEXTPROC glad_glMinmaxEXT;
PFNGLRESETHISTOGRAMEXTPROC glad_glResetHistogramEXT;
PFNGLRESETMINMAXEXTPROC glad_glResetMinmaxEXT;
PFNGLINDEXFUNCEXTPROC glad_glIndexFuncEXT;
PFNGLINDEXMATERIALEXTPROC glad_glIndexMaterialEXT;
PFNGLAPPLYTEXTUREEXTPROC glad_glApplyTextureEXT;
PFNGLTEXTURELIGHTEXTPROC glad_glTextureLightEXT;
PFNGLTEXTUREMATERIALEXTPROC glad_glTextureMaterialEXT;
PFNGLMULTIDRAWARRAYSEXTPROC glad_glMultiDrawArraysEXT;
PFNGLMULTIDRAWELEMENTSEXTPROC glad_glMultiDrawElementsEXT;
PFNGLSAMPLEMASKEXTPROC glad_glSampleMaskEXT;
PFNGLSAMPLEPATTERNEXTPROC glad_glSamplePatternEXT;
PFNGLCOLORTABLEEXTPROC glad_glColorTableEXT;
PFNGLGETCOLORTABLEEXTPROC glad_glGetColorTableEXT;
PFNGLGETCOLORTABLEPARAMETERIVEXTPROC glad_glGetColorTableParameterivEXT;
PFNGLGETCOLORTABLEPARAMETERFVEXTPROC glad_glGetColorTableParameterfvEXT;
PFNGLPIXELTRANSFORMPARAMETERIEXTPROC glad_glPixelTransformParameteriEXT;
PFNGLPIXELTRANSFORMPARAMETERFEXTPROC glad_glPixelTransformParameterfEXT;
PFNGLPIXELTRANSFORMPARAMETERIVEXTPROC glad_glPixelTransformParameterivEXT;
PFNGLPIXELTRANSFORMPARAMETERFVEXTPROC glad_glPixelTransformParameterfvEXT;
PFNGLGETPIXELTRANSFORMPARAMETERIVEXTPROC glad_glGetPixelTransformParameterivEXT;
PFNGLGETPIXELTRANSFORMPARAMETERFVEXTPROC glad_glGetPixelTransformParameterfvEXT;
PFNGLPOINTPARAMETERFEXTPROC glad_glPointParameterfEXT;
PFNGLPOINTPARAMETERFVEXTPROC glad_glPointParameterfvEXT;
PFNGLPOLYGONOFFSETEXTPROC glad_glPolygonOffsetEXT;
PFNGLPOLYGONOFFSETCLAMPEXTPROC glad_glPolygonOffsetClampEXT;
PFNGLPROVOKINGVERTEXEXTPROC glad_glProvokingVertexEXT;
PFNGLRASTERSAMPLESEXTPROC glad_glRasterSamplesEXT;
PFNGLSECONDARYCOLOR3BEXTPROC glad_glSecondaryColor3bEXT;
PFNGLSECONDARYCOLOR3BVEXTPROC glad_glSecondaryColor3bvEXT;
PFNGLSECONDARYCOLOR3DEXTPROC glad_glSecondaryColor3dEXT;
PFNGLSECONDARYCOLOR3DVEXTPROC glad_glSecondaryColor3dvEXT;
PFNGLSECONDARYCOLOR3FEXTPROC glad_glSecondaryColor3fEXT;
PFNGLSECONDARYCOLOR3FVEXTPROC glad_glSecondaryColor3fvEXT;
PFNGLSECONDARYCOLOR3IEXTPROC glad_glSecondaryColor3iEXT;
PFNGLSECONDARYCOLOR3IVEXTPROC glad_glSecondaryColor3ivEXT;
PFNGLSECONDARYCOLOR3SEXTPROC glad_glSecondaryColor3sEXT;
PFNGLSECONDARYCOLOR3SVEXTPROC glad_glSecondaryColor3svEXT;
PFNGLSECONDARYCOLOR3UBEXTPROC glad_glSecondaryColor3ubEXT;
PFNGLSECONDARYCOLOR3UBVEXTPROC glad_glSecondaryColor3ubvEXT;
PFNGLSECONDARYCOLOR3UIEXTPROC glad_glSecondaryColor3uiEXT;
PFNGLSECONDARYCOLOR3UIVEXTPROC glad_glSecondaryColor3uivEXT;
PFNGLSECONDARYCOLOR3USEXTPROC glad_glSecondaryColor3usEXT;
PFNGLSECONDARYCOLOR3USVEXTPROC glad_glSecondaryColor3usvEXT;
PFNGLSECONDARYCOLORPOINTEREXTPROC glad_glSecondaryColorPointerEXT;
PFNGLUSESHADERPROGRAMEXTPROC glad_glUseShaderProgramEXT;
PFNGLACTIVEPROGRAMEXTPROC glad_glActiveProgramEXT;
PFNGLCREATESHADERPROGRAMEXTPROC glad_glCreateShaderProgramEXT;
PFNGLACTIVESHADERPROGRAMEXTPROC glad_glActiveShaderProgramEXT;
PFNGLBINDPROGRAMPIPELINEEXTPROC glad_glBindProgramPipelineEXT;
PFNGLCREATESHADERPROGRAMVEXTPROC glad_glCreateShaderProgramvEXT;
PFNGLDELETEPROGRAMPIPELINESEXTPROC glad_glDeleteProgramPipelinesEXT;
PFNGLGENPROGRAMPIPELINESEXTPROC glad_glGenProgramPipelinesEXT;
PFNGLGETPROGRAMPIPELINEINFOLOGEXTPROC glad_glGetProgramPipelineInfoLogEXT;
PFNGLGETPROGRAMPIPELINEIVEXTPROC glad_glGetProgramPipelineivEXT;
PFNGLISPROGRAMPIPELINEEXTPROC glad_glIsProgramPipelineEXT;
PFNGLUSEPROGRAMSTAGESEXTPROC glad_glUseProgramStagesEXT;
PFNGLVALIDATEPROGRAMPIPELINEEXTPROC glad_glValidateProgramPipelineEXT;
PFNGLBINDIMAGETEXTUREEXTPROC glad_glBindImageTextureEXT;
PFNGLMEMORYBARRIEREXTPROC glad_glMemoryBarrierEXT;
PFNGLSTENCILCLEARTAGEXTPROC glad_glStencilClearTagEXT;
PFNGLACTIVESTENCILFACEEXTPROC glad_glActiveStencilFaceEXT;
PFNGLTEXSUBIMAGE1DEXTPROC glad_glTexSubImage1DEXT;
PFNGLTEXSUBIMAGE2DEXTPROC glad_glTexSubImage2DEXT;
PFNGLTEXIMAGE3DEXTPROC glad_glTexImage3DEXT;
PFNGLTEXSUBIMAGE3DEXTPROC glad_glTexSubImage3DEXT;
PFNGLFRAMEBUFFERTEXTURELAYEREXTPROC glad_glFramebufferTextureLayerEXT;
PFNGLTEXBUFFEREXTPROC glad_glTexBufferEXT;
PFNGLTEXPARAMETERIIVEXTPROC glad_glTexParameterIivEXT;
PFNGLTEXPARAMETERIUIVEXTPROC glad_glTexParameterIuivEXT;
PFNGLGETTEXPARAMETERIIVEXTPROC glad_glGetTexParameterIivEXT;
PFNGLGETTEXPARAMETERIUIVEXTPROC glad_glGetTexParameterIuivEXT;
PFNGLCLEARCOLORIIEXTPROC glad_glClearColorIiEXT;
PFNGLCLEARCOLORIUIEXTPROC glad_glClearColorIuiEXT;
PFNGLARETEXTURESRESIDENTEXTPROC glad_glAreTexturesResidentEXT;
PFNGLBINDTEXTUREEXTPROC glad_glBindTextureEXT;
PFNGLDELETETEXTURESEXTPROC glad_glDeleteTexturesEXT;
PFNGLGENTEXTURESEXTPROC glad_glGenTexturesEXT;
PFNGLISTEXTUREEXTPROC glad_glIsTextureEXT;
PFNGLPRIORITIZETEXTURESEXTPROC glad_glPrioritizeTexturesEXT;
PFNGLTEXTURENORMALEXTPROC glad_glTextureNormalEXT;
PFNGLGETQUERYOBJECTI64VEXTPROC glad_glGetQueryObjecti64vEXT;
PFNGLGETQUERYOBJECTUI64VEXTPROC glad_glGetQueryObjectui64vEXT;
PFNGLBEGINTRANSFORMFEEDBACKEXTPROC glad_glBeginTransformFeedbackEXT;
PFNGLENDTRANSFORMFEEDBACKEXTPROC glad_glEndTransformFeedbackEXT;
PFNGLBINDBUFFERRANGEEXTPROC glad_glBindBufferRangeEXT;
PFNGLBINDBUFFEROFFSETEXTPROC glad_glBindBufferOffsetEXT;
PFNGLBINDBUFFERBASEEXTPROC glad_glBindBufferBaseEXT;
PFNGLTRANSFORMFEEDBACKVARYINGSEXTPROC glad_glTransformFeedbackVaryingsEXT;
PFNGLGETTRANSFORMFEEDBACKVARYINGEXTPROC glad_glGetTransformFeedbackVaryingEXT;
PFNGLARRAYELEMENTEXTPROC glad_glArrayElementEXT;
PFNGLCOLORPOINTEREXTPROC glad_glColorPointerEXT;
PFNGLDRAWARRAYSEXTPROC glad_glDrawArraysEXT;
PFNGLEDGEFLAGPOINTEREXTPROC glad_glEdgeFlagPointerEXT;
PFNGLGETPOINTERVEXTPROC glad_glGetPointervEXT;
PFNGLINDEXPOINTEREXTPROC glad_glIndexPointerEXT;
PFNGLNORMALPOINTEREXTPROC glad_glNormalPointerEXT;
PFNGLTEXCOORDPOINTEREXTPROC glad_glTexCoordPointerEXT;
PFNGLVERTEXPOINTEREXTPROC glad_glVertexPointerEXT;
PFNGLVERTEXATTRIBL1DEXTPROC glad_glVertexAttribL1dEXT;
PFNGLVERTEXATTRIBL2DEXTPROC glad_glVertexAttribL2dEXT;
PFNGLVERTEXATTRIBL3DEXTPROC glad_glVertexAttribL3dEXT;
PFNGLVERTEXATTRIBL4DEXTPROC glad_glVertexAttribL4dEXT;
PFNGLVERTEXATTRIBL1DVEXTPROC glad_glVertexAttribL1dvEXT;
PFNGLVERTEXATTRIBL2DVEXTPROC glad_glVertexAttribL2dvEXT;
PFNGLVERTEXATTRIBL3DVEXTPROC glad_glVertexAttribL3dvEXT;
PFNGLVERTEXATTRIBL4DVEXTPROC glad_glVertexAttribL4dvEXT;
PFNGLVERTEXATTRIBLPOINTEREXTPROC glad_glVertexAttribLPointerEXT;
PFNGLGETVERTEXATTRIBLDVEXTPROC glad_glGetVertexAttribLdvEXT;
PFNGLBEGINVERTEXSHADEREXTPROC glad_glBeginVertexShaderEXT;
PFNGLENDVERTEXSHADEREXTPROC glad_glEndVertexShaderEXT;
PFNGLBINDVERTEXSHADEREXTPROC glad_glBindVertexShaderEXT;
PFNGLGENVERTEXSHADERSEXTPROC glad_glGenVertexShadersEXT;
PFNGLDELETEVERTEXSHADEREXTPROC glad_glDeleteVertexShaderEXT;
PFNGLSHADEROP1EXTPROC glad_glShaderOp1EXT;
PFNGLSHADEROP2EXTPROC glad_glShaderOp2EXT;
PFNGLSHADEROP3EXTPROC glad_glShaderOp3EXT;
PFNGLSWIZZLEEXTPROC glad_glSwizzleEXT;
PFNGLWRITEMASKEXTPROC glad_glWriteMaskEXT;
PFNGLINSERTCOMPONENTEXTPROC glad_glInsertComponentEXT;
PFNGLEXTRACTCOMPONENTEXTPROC glad_glExtractComponentEXT;
PFNGLGENSYMBOLSEXTPROC glad_glGenSymbolsEXT;
PFNGLSETINVARIANTEXTPROC glad_glSetInvariantEXT;
PFNGLSETLOCALCONSTANTEXTPROC glad_glSetLocalConstantEXT;
PFNGLVARIANTBVEXTPROC glad_glVariantbvEXT;
PFNGLVARIANTSVEXTPROC glad_glVariantsvEXT;
PFNGLVARIANTIVEXTPROC glad_glVariantivEXT;
PFNGLVARIANTFVEXTPROC glad_glVariantfvEXT;
PFNGLVARIANTDVEXTPROC glad_glVariantdvEXT;
PFNGLVARIANTUBVEXTPROC glad_glVariantubvEXT;
PFNGLVARIANTUSVEXTPROC glad_glVariantusvEXT;
PFNGLVARIANTUIVEXTPROC glad_glVariantuivEXT;
PFNGLVARIANTPOINTEREXTPROC glad_glVariantPointerEXT;
PFNGLENABLEVARIANTCLIENTSTATEEXTPROC glad_glEnableVariantClientStateEXT;
PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC glad_glDisableVariantClientStateEXT;
PFNGLBINDLIGHTPARAMETEREXTPROC glad_glBindLightParameterEXT;
PFNGLBINDMATERIALPARAMETEREXTPROC glad_glBindMaterialParameterEXT;
PFNGLBINDTEXGENPARAMETEREXTPROC glad_glBindTexGenParameterEXT;
PFNGLBINDTEXTUREUNITPARAMETEREXTPROC glad_glBindTextureUnitParameterEXT;
PFNGLBINDPARAMETEREXTPROC glad_glBindParameterEXT;
PFNGLISVARIANTENABLEDEXTPROC glad_glIsVariantEnabledEXT;
PFNGLGETVARIANTBOOLEANVEXTPROC glad_glGetVariantBooleanvEXT;
PFNGLGETVARIANTINTEGERVEXTPROC glad_glGetVariantIntegervEXT;
PFNGLGETVARIANTFLOATVEXTPROC glad_glGetVariantFloatvEXT;
PFNGLGETVARIANTPOINTERVEXTPROC glad_glGetVariantPointervEXT;
PFNGLGETINVARIANTBOOLEANVEXTPROC glad_glGetInvariantBooleanvEXT;
PFNGLGETINVARIANTINTEGERVEXTPROC glad_glGetInvariantIntegervEXT;
PFNGLGETINVARIANTFLOATVEXTPROC glad_glGetInvariantFloatvEXT;
PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC glad_glGetLocalConstantBooleanvEXT;
PFNGLGETLOCALCONSTANTINTEGERVEXTPROC glad_glGetLocalConstantIntegervEXT;
PFNGLGETLOCALCONSTANTFLOATVEXTPROC glad_glGetLocalConstantFloatvEXT;
PFNGLVERTEXWEIGHTFEXTPROC glad_glVertexWeightfEXT;
PFNGLVERTEXWEIGHTFVEXTPROC glad_glVertexWeightfvEXT;
PFNGLVERTEXWEIGHTPOINTEREXTPROC glad_glVertexWeightPointerEXT;
PFNGLWINDOWRECTANGLESEXTPROC glad_glWindowRectanglesEXT;
PFNGLIMPORTSYNCEXTPROC glad_glImportSyncEXT;
PFNGLFRAMETERMINATORGREMEDYPROC glad_glFrameTerminatorGREMEDY;
PFNGLSTRINGMARKERGREMEDYPROC glad_glStringMarkerGREMEDY;
PFNGLIMAGETRANSFORMPARAMETERIHPPROC glad_glImageTransformParameteriHP;
PFNGLIMAGETRANSFORMPARAMETERFHPPROC glad_glImageTransformParameterfHP;
PFNGLIMAGETRANSFORMPARAMETERIVHPPROC glad_glImageTransformParameterivHP;
PFNGLIMAGETRANSFORMPARAMETERFVHPPROC glad_glImageTransformParameterfvHP;
PFNGLGETIMAGETRANSFORMPARAMETERIVHPPROC glad_glGetImageTransformParameterivHP;
PFNGLGETIMAGETRANSFORMPARAMETERFVHPPROC glad_glGetImageTransformParameterfvHP;
PFNGLMULTIMODEDRAWARRAYSIBMPROC glad_glMultiModeDrawArraysIBM;
PFNGLMULTIMODEDRAWELEMENTSIBMPROC glad_glMultiModeDrawElementsIBM;
PFNGLFLUSHSTATICDATAIBMPROC glad_glFlushStaticDataIBM;
PFNGLCOLORPOINTERLISTIBMPROC glad_glColorPointerListIBM;
PFNGLSECONDARYCOLORPOINTERLISTIBMPROC glad_glSecondaryColorPointerListIBM;
PFNGLEDGEFLAGPOINTERLISTIBMPROC glad_glEdgeFlagPointerListIBM;
PFNGLFOGCOORDPOINTERLISTIBMPROC glad_glFogCoordPointerListIBM;
PFNGLINDEXPOINTERLISTIBMPROC glad_glIndexPointerListIBM;
PFNGLNORMALPOINTERLISTIBMPROC glad_glNormalPointerListIBM;
PFNGLTEXCOORDPOINTERLISTIBMPROC glad_glTexCoordPointerListIBM;
PFNGLVERTEXPOINTERLISTIBMPROC glad_glVertexPointerListIBM;
PFNGLBLENDFUNCSEPARATEINGRPROC glad_glBlendFuncSeparateINGR;
PFNGLAPPLYFRAMEBUFFERATTACHMENTCMAAINTELPROC glad_glApplyFramebufferAttachmentCMAAINTEL;
PFNGLSYNCTEXTUREINTELPROC glad_glSyncTextureINTEL;
PFNGLUNMAPTEXTURE2DINTELPROC glad_glUnmapTexture2DINTEL;
PFNGLMAPTEXTURE2DINTELPROC glad_glMapTexture2DINTEL;
PFNGLVERTEXPOINTERVINTELPROC glad_glVertexPointervINTEL;
PFNGLNORMALPOINTERVINTELPROC glad_glNormalPointervINTEL;
PFNGLCOLORPOINTERVINTELPROC glad_glColorPointervINTEL;
PFNGLTEXCOORDPOINTERVINTELPROC glad_glTexCoordPointervINTEL;
PFNGLBEGINPERFQUERYINTELPROC glad_glBeginPerfQueryINTEL;
PFNGLCREATEPERFQUERYINTELPROC glad_glCreatePerfQueryINTEL;
PFNGLDELETEPERFQUERYINTELPROC glad_glDeletePerfQueryINTEL;
PFNGLENDPERFQUERYINTELPROC glad_glEndPerfQueryINTEL;
PFNGLGETFIRSTPERFQUERYIDINTELPROC glad_glGetFirstPerfQueryIdINTEL;
PFNGLGETNEXTPERFQUERYIDINTELPROC glad_glGetNextPerfQueryIdINTEL;
PFNGLGETPERFCOUNTERINFOINTELPROC glad_glGetPerfCounterInfoINTEL;
PFNGLGETPERFQUERYDATAINTELPROC glad_glGetPerfQueryDataINTEL;
PFNGLGETPERFQUERYIDBYNAMEINTELPROC glad_glGetPerfQueryIdByNameINTEL;
PFNGLGETPERFQUERYINFOINTELPROC glad_glGetPerfQueryInfoINTEL;
PFNGLBLENDBARRIERKHRPROC glad_glBlendBarrierKHR;
PFNGLGETPOINTERVPROC glad_glGetPointerv;
PFNGLDEBUGMESSAGECONTROLKHRPROC glad_glDebugMessageControlKHR;
PFNGLDEBUGMESSAGEINSERTKHRPROC glad_glDebugMessageInsertKHR;
PFNGLDEBUGMESSAGECALLBACKKHRPROC glad_glDebugMessageCallbackKHR;
PFNGLGETDEBUGMESSAGELOGKHRPROC glad_glGetDebugMessageLogKHR;
PFNGLPUSHDEBUGGROUPKHRPROC glad_glPushDebugGroupKHR;
PFNGLPOPDEBUGGROUPKHRPROC glad_glPopDebugGroupKHR;
PFNGLOBJECTLABELKHRPROC glad_glObjectLabelKHR;
PFNGLGETOBJECTLABELKHRPROC glad_glGetObjectLabelKHR;
PFNGLOBJECTPTRLABELKHRPROC glad_glObjectPtrLabelKHR;
PFNGLGETOBJECTPTRLABELKHRPROC glad_glGetObjectPtrLabelKHR;
PFNGLGETPOINTERVKHRPROC glad_glGetPointervKHR;
PFNGLGETGRAPHICSRESETSTATUSKHRPROC glad_glGetGraphicsResetStatusKHR;
PFNGLREADNPIXELSKHRPROC glad_glReadnPixelsKHR;
PFNGLGETNUNIFORMFVKHRPROC glad_glGetnUniformfvKHR;
PFNGLGETNUNIFORMIVKHRPROC glad_glGetnUniformivKHR;
PFNGLGETNUNIFORMUIVKHRPROC glad_glGetnUniformuivKHR;
PFNGLRESIZEBUFFERSMESAPROC glad_glResizeBuffersMESA;
PFNGLWINDOWPOS2DMESAPROC glad_glWindowPos2dMESA;
PFNGLWINDOWPOS2DVMESAPROC glad_glWindowPos2dvMESA;
PFNGLWINDOWPOS2FMESAPROC glad_glWindowPos2fMESA;
PFNGLWINDOWPOS2FVMESAPROC glad_glWindowPos2fvMESA;
PFNGLWINDOWPOS2IMESAPROC glad_glWindowPos2iMESA;
PFNGLWINDOWPOS2IVMESAPROC glad_glWindowPos2ivMESA;
PFNGLWINDOWPOS2SMESAPROC glad_glWindowPos2sMESA;
PFNGLWINDOWPOS2SVMESAPROC glad_glWindowPos2svMESA;
PFNGLWINDOWPOS3DMESAPROC glad_glWindowPos3dMESA;
PFNGLWINDOWPOS3DVMESAPROC glad_glWindowPos3dvMESA;
PFNGLWINDOWPOS3FMESAPROC glad_glWindowPos3fMESA;
PFNGLWINDOWPOS3FVMESAPROC glad_glWindowPos3fvMESA;
PFNGLWINDOWPOS3IMESAPROC glad_glWindowPos3iMESA;
PFNGLWINDOWPOS3IVMESAPROC glad_glWindowPos3ivMESA;
PFNGLWINDOWPOS3SMESAPROC glad_glWindowPos3sMESA;
PFNGLWINDOWPOS3SVMESAPROC glad_glWindowPos3svMESA;
PFNGLWINDOWPOS4DMESAPROC glad_glWindowPos4dMESA;
PFNGLWINDOWPOS4DVMESAPROC glad_glWindowPos4dvMESA;
PFNGLWINDOWPOS4FMESAPROC glad_glWindowPos4fMESA;
PFNGLWINDOWPOS4FVMESAPROC glad_glWindowPos4fvMESA;
PFNGLWINDOWPOS4IMESAPROC glad_glWindowPos4iMESA;
PFNGLWINDOWPOS4IVMESAPROC glad_glWindowPos4ivMESA;
PFNGLWINDOWPOS4SMESAPROC glad_glWindowPos4sMESA;
PFNGLWINDOWPOS4SVMESAPROC glad_glWindowPos4svMESA;
PFNGLBEGINCONDITIONALRENDERNVXPROC glad_glBeginConditionalRenderNVX;
PFNGLENDCONDITIONALRENDERNVXPROC glad_glEndConditionalRenderNVX;
PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSNVPROC glad_glMultiDrawArraysIndirectBindlessNV;
PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSNVPROC glad_glMultiDrawElementsIndirectBindlessNV;
PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSCOUNTNVPROC glad_glMultiDrawArraysIndirectBindlessCountNV;
PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSCOUNTNVPROC glad_glMultiDrawElementsIndirectBindlessCountNV;
PFNGLGETTEXTUREHANDLENVPROC glad_glGetTextureHandleNV;
PFNGLGETTEXTURESAMPLERHANDLENVPROC glad_glGetTextureSamplerHandleNV;
PFNGLMAKETEXTUREHANDLERESIDENTNVPROC glad_glMakeTextureHandleResidentNV;
PFNGLMAKETEXTUREHANDLENONRESIDENTNVPROC glad_glMakeTextureHandleNonResidentNV;
PFNGLGETIMAGEHANDLENVPROC glad_glGetImageHandleNV;
PFNGLMAKEIMAGEHANDLERESIDENTNVPROC glad_glMakeImageHandleResidentNV;
PFNGLMAKEIMAGEHANDLENONRESIDENTNVPROC glad_glMakeImageHandleNonResidentNV;
PFNGLUNIFORMHANDLEUI64NVPROC glad_glUniformHandleui64NV;
PFNGLUNIFORMHANDLEUI64VNVPROC glad_glUniformHandleui64vNV;
PFNGLPROGRAMUNIFORMHANDLEUI64NVPROC glad_glProgramUniformHandleui64NV;
PFNGLPROGRAMUNIFORMHANDLEUI64VNVPROC glad_glProgramUniformHandleui64vNV;
PFNGLISTEXTUREHANDLERESIDENTNVPROC glad_glIsTextureHandleResidentNV;
PFNGLISIMAGEHANDLERESIDENTNVPROC glad_glIsImageHandleResidentNV;
PFNGLBLENDPARAMETERINVPROC glad_glBlendParameteriNV;
PFNGLBLENDBARRIERNVPROC glad_glBlendBarrierNV;
PFNGLVIEWPORTPOSITIONWSCALENVPROC glad_glViewportPositionWScaleNV;
PFNGLCREATESTATESNVPROC glad_glCreateStatesNV;
PFNGLDELETESTATESNVPROC glad_glDeleteStatesNV;
PFNGLISSTATENVPROC glad_glIsStateNV;
PFNGLSTATECAPTURENVPROC glad_glStateCaptureNV;
PFNGLGETCOMMANDHEADERNVPROC glad_glGetCommandHeaderNV;
PFNGLGETSTAGEINDEXNVPROC glad_glGetStageIndexNV;
PFNGLDRAWCOMMANDSNVPROC glad_glDrawCommandsNV;
PFNGLDRAWCOMMANDSADDRESSNVPROC glad_glDrawCommandsAddressNV;
PFNGLDRAWCOMMANDSSTATESNVPROC glad_glDrawCommandsStatesNV;
PFNGLDRAWCOMMANDSSTATESADDRESSNVPROC glad_glDrawCommandsStatesAddressNV;
PFNGLCREATECOMMANDLISTSNVPROC glad_glCreateCommandListsNV;
PFNGLDELETECOMMANDLISTSNVPROC glad_glDeleteCommandListsNV;
PFNGLISCOMMANDLISTNVPROC glad_glIsCommandListNV;
PFNGLLISTDRAWCOMMANDSSTATESCLIENTNVPROC glad_glListDrawCommandsStatesClientNV;
PFNGLCOMMANDLISTSEGMENTSNVPROC glad_glCommandListSegmentsNV;
PFNGLCOMPILECOMMANDLISTNVPROC glad_glCompileCommandListNV;
PFNGLCALLCOMMANDLISTNVPROC glad_glCallCommandListNV;
PFNGLBEGINCONDITIONALRENDERNVPROC glad_glBeginConditionalRenderNV;
PFNGLENDCONDITIONALRENDERNVPROC glad_glEndConditionalRenderNV;
PFNGLSUBPIXELPRECISIONBIASNVPROC glad_glSubpixelPrecisionBiasNV;
PFNGLCONSERVATIVERASTERPARAMETERFNVPROC glad_glConservativeRasterParameterfNV;
PFNGLCONSERVATIVERASTERPARAMETERINVPROC glad_glConservativeRasterParameteriNV;
PFNGLCOPYIMAGESUBDATANVPROC glad_glCopyImageSubDataNV;
PFNGLDEPTHRANGEDNVPROC glad_glDepthRangedNV;
PFNGLCLEARDEPTHDNVPROC glad_glClearDepthdNV;
PFNGLDEPTHBOUNDSDNVPROC glad_glDepthBoundsdNV;
PFNGLDRAWTEXTURENVPROC glad_glDrawTextureNV;
PFNGLMAPCONTROLPOINTSNVPROC glad_glMapControlPointsNV;
PFNGLMAPPARAMETERIVNVPROC glad_glMapParameterivNV;
PFNGLMAPPARAMETERFVNVPROC glad_glMapParameterfvNV;
PFNGLGETMAPCONTROLPOINTSNVPROC glad_glGetMapControlPointsNV;
PFNGLGETMAPPARAMETERIVNVPROC glad_glGetMapParameterivNV;
PFNGLGETMAPPARAMETERFVNVPROC glad_glGetMapParameterfvNV;
PFNGLGETMAPATTRIBPARAMETERIVNVPROC glad_glGetMapAttribParameterivNV;
PFNGLGETMAPATTRIBPARAMETERFVNVPROC glad_glGetMapAttribParameterfvNV;
PFNGLEVALMAPSNVPROC glad_glEvalMapsNV;
PFNGLGETMULTISAMPLEFVNVPROC glad_glGetMultisamplefvNV;
PFNGLSAMPLEMASKINDEXEDNVPROC glad_glSampleMaskIndexedNV;
PFNGLTEXRENDERBUFFERNVPROC glad_glTexRenderbufferNV;
PFNGLDELETEFENCESNVPROC glad_glDeleteFencesNV;
PFNGLGENFENCESNVPROC glad_glGenFencesNV;
PFNGLISFENCENVPROC glad_glIsFenceNV;
PFNGLTESTFENCENVPROC glad_glTestFenceNV;
PFNGLGETFENCEIVNVPROC glad_glGetFenceivNV;
PFNGLFINISHFENCENVPROC glad_glFinishFenceNV;
PFNGLSETFENCENVPROC glad_glSetFenceNV;
PFNGLFRAGMENTCOVERAGECOLORNVPROC glad_glFragmentCoverageColorNV;
PFNGLPROGRAMNAMEDPARAMETER4FNVPROC glad_glProgramNamedParameter4fNV;
PFNGLPROGRAMNAMEDPARAMETER4FVNVPROC glad_glProgramNamedParameter4fvNV;
PFNGLPROGRAMNAMEDPARAMETER4DNVPROC glad_glProgramNamedParameter4dNV;
PFNGLPROGRAMNAMEDPARAMETER4DVNVPROC glad_glProgramNamedParameter4dvNV;
PFNGLGETPROGRAMNAMEDPARAMETERFVNVPROC glad_glGetProgramNamedParameterfvNV;
PFNGLGETPROGRAMNAMEDPARAMETERDVNVPROC glad_glGetProgramNamedParameterdvNV;
PFNGLCOVERAGEMODULATIONTABLENVPROC glad_glCoverageModulationTableNV;
PFNGLGETCOVERAGEMODULATIONTABLENVPROC glad_glGetCoverageModulationTableNV;
PFNGLCOVERAGEMODULATIONNVPROC glad_glCoverageModulationNV;
PFNGLRENDERBUFFERSTORAGEMULTISAMPLECOVERAGENVPROC glad_glRenderbufferStorageMultisampleCoverageNV;
PFNGLPROGRAMVERTEXLIMITNVPROC glad_glProgramVertexLimitNV;
PFNGLFRAMEBUFFERTEXTUREEXTPROC glad_glFramebufferTextureEXT;
PFNGLFRAMEBUFFERTEXTUREFACEEXTPROC glad_glFramebufferTextureFaceEXT;
PFNGLPROGRAMLOCALPARAMETERI4INVPROC glad_glProgramLocalParameterI4iNV;
PFNGLPROGRAMLOCALPARAMETERI4IVNVPROC glad_glProgramLocalParameterI4ivNV;
PFNGLPROGRAMLOCALPARAMETERSI4IVNVPROC glad_glProgramLocalParametersI4ivNV;
PFNGLPROGRAMLOCALPARAMETERI4UINVPROC glad_glProgramLocalParameterI4uiNV;
PFNGLPROGRAMLOCALPARAMETERI4UIVNVPROC glad_glProgramLocalParameterI4uivNV;
PFNGLPROGRAMLOCALPARAMETERSI4UIVNVPROC glad_glProgramLocalParametersI4uivNV;
PFNGLPROGRAMENVPARAMETERI4INVPROC glad_glProgramEnvParameterI4iNV;
PFNGLPROGRAMENVPARAMETERI4IVNVPROC glad_glProgramEnvParameterI4ivNV;
PFNGLPROGRAMENVPARAMETERSI4IVNVPROC glad_glProgramEnvParametersI4ivNV;
PFNGLPROGRAMENVPARAMETERI4UINVPROC glad_glProgramEnvParameterI4uiNV;
PFNGLPROGRAMENVPARAMETERI4UIVNVPROC glad_glProgramEnvParameterI4uivNV;
PFNGLPROGRAMENVPARAMETERSI4UIVNVPROC glad_glProgramEnvParametersI4uivNV;
PFNGLGETPROGRAMLOCALPARAMETERIIVNVPROC glad_glGetProgramLocalParameterIivNV;
PFNGLGETPROGRAMLOCALPARAMETERIUIVNVPROC glad_glGetProgramLocalParameterIuivNV;
PFNGLGETPROGRAMENVPARAMETERIIVNVPROC glad_glGetProgramEnvParameterIivNV;
PFNGLGETPROGRAMENVPARAMETERIUIVNVPROC glad_glGetProgramEnvParameterIuivNV;
PFNGLPROGRAMSUBROUTINEPARAMETERSUIVNVPROC glad_glProgramSubroutineParametersuivNV;
PFNGLGETPROGRAMSUBROUTINEPARAMETERUIVNVPROC glad_glGetProgramSubroutineParameteruivNV;
PFNGLVERTEX2HNVPROC glad_glVertex2hNV;
PFNGLVERTEX2HVNVPROC glad_glVertex2hvNV;
PFNGLVERTEX3HNVPROC glad_glVertex3hNV;
PFNGLVERTEX3HVNVPROC glad_glVertex3hvNV;
PFNGLVERTEX4HNVPROC glad_glVertex4hNV;
PFNGLVERTEX4HVNVPROC glad_glVertex4hvNV;
PFNGLNORMAL3HNVPROC glad_glNormal3hNV;
PFNGLNORMAL3HVNVPROC glad_glNormal3hvNV;
PFNGLCOLOR3HNVPROC glad_glColor3hNV;
PFNGLCOLOR3HVNVPROC glad_glColor3hvNV;
PFNGLCOLOR4HNVPROC glad_glColor4hNV;
PFNGLCOLOR4HVNVPROC glad_glColor4hvNV;
PFNGLTEXCOORD1HNVPROC glad_glTexCoord1hNV;
PFNGLTEXCOORD1HVNVPROC glad_glTexCoord1hvNV;
PFNGLTEXCOORD2HNVPROC glad_glTexCoord2hNV;
PFNGLTEXCOORD2HVNVPROC glad_glTexCoord2hvNV;
PFNGLTEXCOORD3HNVPROC glad_glTexCoord3hNV;
PFNGLTEXCOORD3HVNVPROC glad_glTexCoord3hvNV;
PFNGLTEXCOORD4HNVPROC glad_glTexCoord4hNV;
PFNGLTEXCOORD4HVNVPROC glad_glTexCoord4hvNV;
PFNGLMULTITEXCOORD1HNVPROC glad_glMultiTexCoord1hNV;
PFNGLMULTITEXCOORD1HVNVPROC glad_glMultiTexCoord1hvNV;
PFNGLMULTITEXCOORD2HNVPROC glad_glMultiTexCoord2hNV;
PFNGLMULTITEXCOORD2HVNVPROC glad_glMultiTexCoord2hvNV;
PFNGLMULTITEXCOORD3HNVPROC glad_glMultiTexCoord3hNV;
PFNGLMULTITEXCOORD3HVNVPROC glad_glMultiTexCoord3hvNV;
PFNGLMULTITEXCOORD4HNVPROC glad_glMultiTexCoord4hNV;
PFNGLMULTITEXCOORD4HVNVPROC glad_glMultiTexCoord4hvNV;
PFNGLFOGCOORDHNVPROC glad_glFogCoordhNV;
PFNGLFOGCOORDHVNVPROC glad_glFogCoordhvNV;
PFNGLSECONDARYCOLOR3HNVPROC glad_glSecondaryColor3hNV;
PFNGLSECONDARYCOLOR3HVNVPROC glad_glSecondaryColor3hvNV;
PFNGLVERTEXWEIGHTHNVPROC glad_glVertexWeighthNV;
PFNGLVERTEXWEIGHTHVNVPROC glad_glVertexWeighthvNV;
PFNGLVERTEXATTRIB1HNVPROC glad_glVertexAttrib1hNV;
PFNGLVERTEXATTRIB1HVNVPROC glad_glVertexAttrib1hvNV;
PFNGLVERTEXATTRIB2HNVPROC glad_glVertexAttrib2hNV;
PFNGLVERTEXATTRIB2HVNVPROC glad_glVertexAttrib2hvNV;
PFNGLVERTEXATTRIB3HNVPROC glad_glVertexAttrib3hNV;
PFNGLVERTEXATTRIB3HVNVPROC glad_glVertexAttrib3hvNV;
PFNGLVERTEXATTRIB4HNVPROC glad_glVertexAttrib4hNV;
PFNGLVERTEXATTRIB4HVNVPROC glad_glVertexAttrib4hvNV;
PFNGLVERTEXATTRIBS1HVNVPROC glad_glVertexAttribs1hvNV;
PFNGLVERTEXATTRIBS2HVNVPROC glad_glVertexAttribs2hvNV;
PFNGLVERTEXATTRIBS3HVNVPROC glad_glVertexAttribs3hvNV;
PFNGLVERTEXATTRIBS4HVNVPROC glad_glVertexAttribs4hvNV;
PFNGLGETINTERNALFORMATSAMPLEIVNVPROC glad_glGetInternalformatSampleivNV;
PFNGLGENOCCLUSIONQUERIESNVPROC glad_glGenOcclusionQueriesNV;
PFNGLDELETEOCCLUSIONQUERIESNVPROC glad_glDeleteOcclusionQueriesNV;
PFNGLISOCCLUSIONQUERYNVPROC glad_glIsOcclusionQueryNV;
PFNGLBEGINOCCLUSIONQUERYNVPROC glad_glBeginOcclusionQueryNV;
PFNGLENDOCCLUSIONQUERYNVPROC glad_glEndOcclusionQueryNV;
PFNGLGETOCCLUSIONQUERYIVNVPROC glad_glGetOcclusionQueryivNV;
PFNGLGETOCCLUSIONQUERYUIVNVPROC glad_glGetOcclusionQueryuivNV;
PFNGLPROGRAMBUFFERPARAMETERSFVNVPROC glad_glProgramBufferParametersfvNV;
PFNGLPROGRAMBUFFERPARAMETERSIIVNVPROC glad_glProgramBufferParametersIivNV;
PFNGLPROGRAMBUFFERPARAMETERSIUIVNVPROC glad_glProgramBufferParametersIuivNV;
PFNGLGENPATHSNVPROC glad_glGenPathsNV;
PFNGLDELETEPATHSNVPROC glad_glDeletePathsNV;
PFNGLISPATHNVPROC glad_glIsPathNV;
PFNGLPATHCOMMANDSNVPROC glad_glPathCommandsNV;
PFNGLPATHCOORDSNVPROC glad_glPathCoordsNV;
PFNGLPATHSUBCOMMANDSNVPROC glad_glPathSubCommandsNV;
PFNGLPATHSUBCOORDSNVPROC glad_glPathSubCoordsNV;
PFNGLPATHSTRINGNVPROC glad_glPathStringNV;
PFNGLPATHGLYPHSNVPROC glad_glPathGlyphsNV;
PFNGLPATHGLYPHRANGENVPROC glad_glPathGlyphRangeNV;
PFNGLWEIGHTPATHSNVPROC glad_glWeightPathsNV;
PFNGLCOPYPATHNVPROC glad_glCopyPathNV;
PFNGLINTERPOLATEPATHSNVPROC glad_glInterpolatePathsNV;
PFNGLTRANSFORMPATHNVPROC glad_glTransformPathNV;
PFNGLPATHPARAMETERIVNVPROC glad_glPathParameterivNV;
PFNGLPATHPARAMETERINVPROC glad_glPathParameteriNV;
PFNGLPATHPARAMETERFVNVPROC glad_glPathParameterfvNV;
PFNGLPATHPARAMETERFNVPROC glad_glPathParameterfNV;
PFNGLPATHDASHARRAYNVPROC glad_glPathDashArrayNV;
PFNGLPATHSTENCILFUNCNVPROC glad_glPathStencilFuncNV;
PFNGLPATHSTENCILDEPTHOFFSETNVPROC glad_glPathStencilDepthOffsetNV;
PFNGLSTENCILFILLPATHNVPROC glad_glStencilFillPathNV;
PFNGLSTENCILSTROKEPATHNVPROC glad_glStencilStrokePathNV;
PFNGLSTENCILFILLPATHINSTANCEDNVPROC glad_glStencilFillPathInstancedNV;
PFNGLSTENCILSTROKEPATHINSTANCEDNVPROC glad_glStencilStrokePathInstancedNV;
PFNGLPATHCOVERDEPTHFUNCNVPROC glad_glPathCoverDepthFuncNV;
PFNGLCOVERFILLPATHNVPROC glad_glCoverFillPathNV;
PFNGLCOVERSTROKEPATHNVPROC glad_glCoverStrokePathNV;
PFNGLCOVERFILLPATHINSTANCEDNVPROC glad_glCoverFillPathInstancedNV;
PFNGLCOVERSTROKEPATHINSTANCEDNVPROC glad_glCoverStrokePathInstancedNV;
PFNGLGETPATHPARAMETERIVNVPROC glad_glGetPathParameterivNV;
PFNGLGETPATHPARAMETERFVNVPROC glad_glGetPathParameterfvNV;
PFNGLGETPATHCOMMANDSNVPROC glad_glGetPathCommandsNV;
PFNGLGETPATHCOORDSNVPROC glad_glGetPathCoordsNV;
PFNGLGETPATHDASHARRAYNVPROC glad_glGetPathDashArrayNV;
PFNGLGETPATHMETRICSNVPROC glad_glGetPathMetricsNV;
PFNGLGETPATHMETRICRANGENVPROC glad_glGetPathMetricRangeNV;
PFNGLGETPATHSPACINGNVPROC glad_glGetPathSpacingNV;
PFNGLISPOINTINFILLPATHNVPROC glad_glIsPointInFillPathNV;
PFNGLISPOINTINSTROKEPATHNVPROC glad_glIsPointInStrokePathNV;
PFNGLGETPATHLENGTHNVPROC glad_glGetPathLengthNV;
PFNGLPOINTALONGPATHNVPROC glad_glPointAlongPathNV;
PFNGLMATRIXLOAD3X2FNVPROC glad_glMatrixLoad3x2fNV;
PFNGLMATRIXLOAD3X3FNVPROC glad_glMatrixLoad3x3fNV;
PFNGLMATRIXLOADTRANSPOSE3X3FNVPROC glad_glMatrixLoadTranspose3x3fNV;
PFNGLMATRIXMULT3X2FNVPROC glad_glMatrixMult3x2fNV;
PFNGLMATRIXMULT3X3FNVPROC glad_glMatrixMult3x3fNV;
PFNGLMATRIXMULTTRANSPOSE3X3FNVPROC glad_glMatrixMultTranspose3x3fNV;
PFNGLSTENCILTHENCOVERFILLPATHNVPROC glad_glStencilThenCoverFillPathNV;
PFNGLSTENCILTHENCOVERSTROKEPATHNVPROC glad_glStencilThenCoverStrokePathNV;
PFNGLSTENCILTHENCOVERFILLPATHINSTANCEDNVPROC glad_glStencilThenCoverFillPathInstancedNV;
PFNGLSTENCILTHENCOVERSTROKEPATHINSTANCEDNVPROC glad_glStencilThenCoverStrokePathInstancedNV;
PFNGLPATHGLYPHINDEXRANGENVPROC glad_glPathGlyphIndexRangeNV;
PFNGLPATHGLYPHINDEXARRAYNVPROC glad_glPathGlyphIndexArrayNV;
PFNGLPATHMEMORYGLYPHINDEXARRAYNVPROC glad_glPathMemoryGlyphIndexArrayNV;
PFNGLPROGRAMPATHFRAGMENTINPUTGENNVPROC glad_glProgramPathFragmentInputGenNV;
PFNGLGETPROGRAMRESOURCEFVNVPROC glad_glGetProgramResourcefvNV;
PFNGLPATHCOLORGENNVPROC glad_glPathColorGenNV;
PFNGLPATHTEXGENNVPROC glad_glPathTexGenNV;
PFNGLPATHFOGGENNVPROC glad_glPathFogGenNV;
PFNGLGETPATHCOLORGENIVNVPROC glad_glGetPathColorGenivNV;
PFNGLGETPATHCOLORGENFVNVPROC glad_glGetPathColorGenfvNV;
PFNGLGETPATHTEXGENIVNVPROC glad_glGetPathTexGenivNV;
PFNGLGETPATHTEXGENFVNVPROC glad_glGetPathTexGenfvNV;
PFNGLPIXELDATARANGENVPROC glad_glPixelDataRangeNV;
PFNGLFLUSHPIXELDATARANGENVPROC glad_glFlushPixelDataRangeNV;
PFNGLPOINTPARAMETERINVPROC glad_glPointParameteriNV;
PFNGLPOINTPARAMETERIVNVPROC glad_glPointParameterivNV;
PFNGLPRESENTFRAMEKEYEDNVPROC glad_glPresentFrameKeyedNV;
PFNGLPRESENTFRAMEDUALFILLNVPROC glad_glPresentFrameDualFillNV;
PFNGLGETVIDEOIVNVPROC glad_glGetVideoivNV;
PFNGLGETVIDEOUIVNVPROC glad_glGetVideouivNV;
PFNGLGETVIDEOI64VNVPROC glad_glGetVideoi64vNV;
PFNGLGETVIDEOUI64VNVPROC glad_glGetVideoui64vNV;
PFNGLPRIMITIVERESTARTNVPROC glad_glPrimitiveRestartNV;
PFNGLPRIMITIVERESTARTINDEXNVPROC glad_glPrimitiveRestartIndexNV;
PFNGLCOMBINERPARAMETERFVNVPROC glad_glCombinerParameterfvNV;
PFNGLCOMBINERPARAMETERFNVPROC glad_glCombinerParameterfNV;
PFNGLCOMBINERPARAMETERIVNVPROC glad_glCombinerParameterivNV;
PFNGLCOMBINERPARAMETERINVPROC glad_glCombinerParameteriNV;
PFNGLCOMBINERINPUTNVPROC glad_glCombinerInputNV;
PFNGLCOMBINEROUTPUTNVPROC glad_glCombinerOutputNV;
PFNGLFINALCOMBINERINPUTNVPROC glad_glFinalCombinerInputNV;
PFNGLGETCOMBINERINPUTPARAMETERFVNVPROC glad_glGetCombinerInputParameterfvNV;
PFNGLGETCOMBINERINPUTPARAMETERIVNVPROC glad_glGetCombinerInputParameterivNV;
PFNGLGETCOMBINEROUTPUTPARAMETERFVNVPROC glad_glGetCombinerOutputParameterfvNV;
PFNGLGETCOMBINEROUTPUTPARAMETERIVNVPROC glad_glGetCombinerOutputParameterivNV;
PFNGLGETFINALCOMBINERINPUTPARAMETERFVNVPROC glad_glGetFinalCombinerInputParameterfvNV;
PFNGLGETFINALCOMBINERINPUTPARAMETERIVNVPROC glad_glGetFinalCombinerInputParameterivNV;
PFNGLCOMBINERSTAGEPARAMETERFVNVPROC glad_glCombinerStageParameterfvNV;
PFNGLGETCOMBINERSTAGEPARAMETERFVNVPROC glad_glGetCombinerStageParameterfvNV;
PFNGLFRAMEBUFFERSAMPLELOCATIONSFVNVPROC glad_glFramebufferSampleLocationsfvNV;
PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVNVPROC glad_glNamedFramebufferSampleLocationsfvNV;
PFNGLRESOLVEDEPTHVALUESNVPROC glad_glResolveDepthValuesNV;
PFNGLMAKEBUFFERRESIDENTNVPROC glad_glMakeBufferResidentNV;
PFNGLMAKEBUFFERNONRESIDENTNVPROC glad_glMakeBufferNonResidentNV;
PFNGLISBUFFERRESIDENTNVPROC glad_glIsBufferResidentNV;
PFNGLMAKENAMEDBUFFERRESIDENTNVPROC glad_glMakeNamedBufferResidentNV;
PFNGLMAKENAMEDBUFFERNONRESIDENTNVPROC glad_glMakeNamedBufferNonResidentNV;
PFNGLISNAMEDBUFFERRESIDENTNVPROC glad_glIsNamedBufferResidentNV;
PFNGLGETBUFFERPARAMETERUI64VNVPROC glad_glGetBufferParameterui64vNV;
PFNGLGETNAMEDBUFFERPARAMETERUI64VNVPROC glad_glGetNamedBufferParameterui64vNV;
PFNGLGETINTEGERUI64VNVPROC glad_glGetIntegerui64vNV;
PFNGLUNIFORMUI64NVPROC glad_glUniformui64NV;
PFNGLUNIFORMUI64VNVPROC glad_glUniformui64vNV;
PFNGLPROGRAMUNIFORMUI64NVPROC glad_glProgramUniformui64NV;
PFNGLPROGRAMUNIFORMUI64VNVPROC glad_glProgramUniformui64vNV;
PFNGLTEXTUREBARRIERNVPROC glad_glTextureBarrierNV;
PFNGLTEXIMAGE2DMULTISAMPLECOVERAGENVPROC glad_glTexImage2DMultisampleCoverageNV;
PFNGLTEXIMAGE3DMULTISAMPLECOVERAGENVPROC glad_glTexImage3DMultisampleCoverageNV;
PFNGLTEXTUREIMAGE2DMULTISAMPLENVPROC glad_glTextureImage2DMultisampleNV;
PFNGLTEXTUREIMAGE3DMULTISAMPLENVPROC glad_glTextureImage3DMultisampleNV;
PFNGLTEXTUREIMAGE2DMULTISAMPLECOVERAGENVPROC glad_glTextureImage2DMultisampleCoverageNV;
PFNGLTEXTUREIMAGE3DMULTISAMPLECOVERAGENVPROC glad_glTextureImage3DMultisampleCoverageNV;
PFNGLBEGINTRANSFORMFEEDBACKNVPROC glad_glBeginTransformFeedbackNV;
PFNGLENDTRANSFORMFEEDBACKNVPROC glad_glEndTransformFeedbackNV;
PFNGLTRANSFORMFEEDBACKATTRIBSNVPROC glad_glTransformFeedbackAttribsNV;
PFNGLBINDBUFFERRANGENVPROC glad_glBindBufferRangeNV;
PFNGLBINDBUFFEROFFSETNVPROC glad_glBindBufferOffsetNV;
PFNGLBINDBUFFERBASENVPROC glad_glBindBufferBaseNV;
PFNGLTRANSFORMFEEDBACKVARYINGSNVPROC glad_glTransformFeedbackVaryingsNV;
PFNGLACTIVEVARYINGNVPROC glad_glActiveVaryingNV;
PFNGLGETVARYINGLOCATIONNVPROC glad_glGetVaryingLocationNV;
PFNGLGETACTIVEVARYINGNVPROC glad_glGetActiveVaryingNV;
PFNGLGETTRANSFORMFEEDBACKVARYINGNVPROC glad_glGetTransformFeedbackVaryingNV;
PFNGLTRANSFORMFEEDBACKSTREAMATTRIBSNVPROC glad_glTransformFeedbackStreamAttribsNV;
PFNGLBINDTRANSFORMFEEDBACKNVPROC glad_glBindTransformFeedbackNV;
PFNGLDELETETRANSFORMFEEDBACKSNVPROC glad_glDeleteTransformFeedbacksNV;
PFNGLGENTRANSFORMFEEDBACKSNVPROC glad_glGenTransformFeedbacksNV;
PFNGLISTRANSFORMFEEDBACKNVPROC glad_glIsTransformFeedbackNV;
PFNGLPAUSETRANSFORMFEEDBACKNVPROC glad_glPauseTransformFeedbackNV;
PFNGLRESUMETRANSFORMFEEDBACKNVPROC glad_glResumeTransformFeedbackNV;
PFNGLDRAWTRANSFORMFEEDBACKNVPROC glad_glDrawTransformFeedbackNV;
PFNGLVDPAUINITNVPROC glad_glVDPAUInitNV;
PFNGLVDPAUFININVPROC glad_glVDPAUFiniNV;
PFNGLVDPAUREGISTERVIDEOSURFACENVPROC glad_glVDPAURegisterVideoSurfaceNV;
PFNGLVDPAUREGISTEROUTPUTSURFACENVPROC glad_glVDPAURegisterOutputSurfaceNV;
PFNGLVDPAUISSURFACENVPROC glad_glVDPAUIsSurfaceNV;
PFNGLVDPAUUNREGISTERSURFACENVPROC glad_glVDPAUUnregisterSurfaceNV;
PFNGLVDPAUGETSURFACEIVNVPROC glad_glVDPAUGetSurfaceivNV;
PFNGLVDPAUSURFACEACCESSNVPROC glad_glVDPAUSurfaceAccessNV;
PFNGLVDPAUMAPSURFACESNVPROC glad_glVDPAUMapSurfacesNV;
PFNGLVDPAUUNMAPSURFACESNVPROC glad_glVDPAUUnmapSurfacesNV;
PFNGLFLUSHVERTEXARRAYRANGENVPROC glad_glFlushVertexArrayRangeNV;
PFNGLVERTEXARRAYRANGENVPROC glad_glVertexArrayRangeNV;
PFNGLVERTEXATTRIBL1I64NVPROC glad_glVertexAttribL1i64NV;
PFNGLVERTEXATTRIBL2I64NVPROC glad_glVertexAttribL2i64NV;
PFNGLVERTEXATTRIBL3I64NVPROC glad_glVertexAttribL3i64NV;
PFNGLVERTEXATTRIBL4I64NVPROC glad_glVertexAttribL4i64NV;
PFNGLVERTEXATTRIBL1I64VNVPROC glad_glVertexAttribL1i64vNV;
PFNGLVERTEXATTRIBL2I64VNVPROC glad_glVertexAttribL2i64vNV;
PFNGLVERTEXATTRIBL3I64VNVPROC glad_glVertexAttribL3i64vNV;
PFNGLVERTEXATTRIBL4I64VNVPROC glad_glVertexAttribL4i64vNV;
PFNGLVERTEXATTRIBL1UI64NVPROC glad_glVertexAttribL1ui64NV;
PFNGLVERTEXATTRIBL2UI64NVPROC glad_glVertexAttribL2ui64NV;
PFNGLVERTEXATTRIBL3UI64NVPROC glad_glVertexAttribL3ui64NV;
PFNGLVERTEXATTRIBL4UI64NVPROC glad_glVertexAttribL4ui64NV;
PFNGLVERTEXATTRIBL1UI64VNVPROC glad_glVertexAttribL1ui64vNV;
PFNGLVERTEXATTRIBL2UI64VNVPROC glad_glVertexAttribL2ui64vNV;
PFNGLVERTEXATTRIBL3UI64VNVPROC glad_glVertexAttribL3ui64vNV;
PFNGLVERTEXATTRIBL4UI64VNVPROC glad_glVertexAttribL4ui64vNV;
PFNGLGETVERTEXATTRIBLI64VNVPROC glad_glGetVertexAttribLi64vNV;
PFNGLGETVERTEXATTRIBLUI64VNVPROC glad_glGetVertexAttribLui64vNV;
PFNGLVERTEXATTRIBLFORMATNVPROC glad_glVertexAttribLFormatNV;
PFNGLBUFFERADDRESSRANGENVPROC glad_glBufferAddressRangeNV;
PFNGLVERTEXFORMATNVPROC glad_glVertexFormatNV;
PFNGLNORMALFORMATNVPROC glad_glNormalFormatNV;
PFNGLCOLORFORMATNVPROC glad_glColorFormatNV;
PFNGLINDEXFORMATNVPROC glad_glIndexFormatNV;
PFNGLTEXCOORDFORMATNVPROC glad_glTexCoordFormatNV;
PFNGLEDGEFLAGFORMATNVPROC glad_glEdgeFlagFormatNV;
PFNGLSECONDARYCOLORFORMATNVPROC glad_glSecondaryColorFormatNV;
PFNGLFOGCOORDFORMATNVPROC glad_glFogCoordFormatNV;
PFNGLVERTEXATTRIBFORMATNVPROC glad_glVertexAttribFormatNV;
PFNGLVERTEXATTRIBIFORMATNVPROC glad_glVertexAttribIFormatNV;
PFNGLGETINTEGERUI64I_VNVPROC glad_glGetIntegerui64i_vNV;
PFNGLAREPROGRAMSRESIDENTNVPROC glad_glAreProgramsResidentNV;
PFNGLBINDPROGRAMNVPROC glad_glBindProgramNV;
PFNGLDELETEPROGRAMSNVPROC glad_glDeleteProgramsNV;
PFNGLEXECUTEPROGRAMNVPROC glad_glExecuteProgramNV;
PFNGLGENPROGRAMSNVPROC glad_glGenProgramsNV;
PFNGLGETPROGRAMPARAMETERDVNVPROC glad_glGetProgramParameterdvNV;
PFNGLGETPROGRAMPARAMETERFVNVPROC glad_glGetProgramParameterfvNV;
PFNGLGETPROGRAMIVNVPROC glad_glGetProgramivNV;
PFNGLGETPROGRAMSTRINGNVPROC glad_glGetProgramStringNV;
PFNGLGETTRACKMATRIXIVNVPROC glad_glGetTrackMatrixivNV;
PFNGLGETVERTEXATTRIBDVNVPROC glad_glGetVertexAttribdvNV;
PFNGLGETVERTEXATTRIBFVNVPROC glad_glGetVertexAttribfvNV;
PFNGLGETVERTEXATTRIBIVNVPROC glad_glGetVertexAttribivNV;
PFNGLGETVERTEXATTRIBPOINTERVNVPROC glad_glGetVertexAttribPointervNV;
PFNGLISPROGRAMNVPROC glad_glIsProgramNV;
PFNGLLOADPROGRAMNVPROC glad_glLoadProgramNV;
PFNGLPROGRAMPARAMETER4DNVPROC glad_glProgramParameter4dNV;
PFNGLPROGRAMPARAMETER4DVNVPROC glad_glProgramParameter4dvNV;
PFNGLPROGRAMPARAMETER4FNVPROC glad_glProgramParameter4fNV;
PFNGLPROGRAMPARAMETER4FVNVPROC glad_glProgramParameter4fvNV;
PFNGLPROGRAMPARAMETERS4DVNVPROC glad_glProgramParameters4dvNV;
PFNGLPROGRAMPARAMETERS4FVNVPROC glad_glProgramParameters4fvNV;
PFNGLREQUESTRESIDENTPROGRAMSNVPROC glad_glRequestResidentProgramsNV;
PFNGLTRACKMATRIXNVPROC glad_glTrackMatrixNV;
PFNGLVERTEXATTRIBPOINTERNVPROC glad_glVertexAttribPointerNV;
PFNGLVERTEXATTRIB1DNVPROC glad_glVertexAttrib1dNV;
PFNGLVERTEXATTRIB1DVNVPROC glad_glVertexAttrib1dvNV;
PFNGLVERTEXATTRIB1FNVPROC glad_glVertexAttrib1fNV;
PFNGLVERTEXATTRIB1FVNVPROC glad_glVertexAttrib1fvNV;
PFNGLVERTEXATTRIB1SNVPROC glad_glVertexAttrib1sNV;
PFNGLVERTEXATTRIB1SVNVPROC glad_glVertexAttrib1svNV;
PFNGLVERTEXATTRIB2DNVPROC glad_glVertexAttrib2dNV;
PFNGLVERTEXATTRIB2DVNVPROC glad_glVertexAttrib2dvNV;
PFNGLVERTEXATTRIB2FNVPROC glad_glVertexAttrib2fNV;
PFNGLVERTEXATTRIB2FVNVPROC glad_glVertexAttrib2fvNV;
PFNGLVERTEXATTRIB2SNVPROC glad_glVertexAttrib2sNV;
PFNGLVERTEXATTRIB2SVNVPROC glad_glVertexAttrib2svNV;
PFNGLVERTEXATTRIB3DNVPROC glad_glVertexAttrib3dNV;
PFNGLVERTEXATTRIB3DVNVPROC glad_glVertexAttrib3dvNV;
PFNGLVERTEXATTRIB3FNVPROC glad_glVertexAttrib3fNV;
PFNGLVERTEXATTRIB3FVNVPROC glad_glVertexAttrib3fvNV;
PFNGLVERTEXATTRIB3SNVPROC glad_glVertexAttrib3sNV;
PFNGLVERTEXATTRIB3SVNVPROC glad_glVertexAttrib3svNV;
PFNGLVERTEXATTRIB4DNVPROC glad_glVertexAttrib4dNV;
PFNGLVERTEXATTRIB4DVNVPROC glad_glVertexAttrib4dvNV;
PFNGLVERTEXATTRIB4FNVPROC glad_glVertexAttrib4fNV;
PFNGLVERTEXATTRIB4FVNVPROC glad_glVertexAttrib4fvNV;
PFNGLVERTEXATTRIB4SNVPROC glad_glVertexAttrib4sNV;
PFNGLVERTEXATTRIB4SVNVPROC glad_glVertexAttrib4svNV;
PFNGLVERTEXATTRIB4UBNVPROC glad_glVertexAttrib4ubNV;
PFNGLVERTEXATTRIB4UBVNVPROC glad_glVertexAttrib4ubvNV;
PFNGLVERTEXATTRIBS1DVNVPROC glad_glVertexAttribs1dvNV;
PFNGLVERTEXATTRIBS1FVNVPROC glad_glVertexAttribs1fvNV;
PFNGLVERTEXATTRIBS1SVNVPROC glad_glVertexAttribs1svNV;
PFNGLVERTEXATTRIBS2DVNVPROC glad_glVertexAttribs2dvNV;
PFNGLVERTEXATTRIBS2FVNVPROC glad_glVertexAttribs2fvNV;
PFNGLVERTEXATTRIBS2SVNVPROC glad_glVertexAttribs2svNV;
PFNGLVERTEXATTRIBS3DVNVPROC glad_glVertexAttribs3dvNV;
PFNGLVERTEXATTRIBS3FVNVPROC glad_glVertexAttribs3fvNV;
PFNGLVERTEXATTRIBS3SVNVPROC glad_glVertexAttribs3svNV;
PFNGLVERTEXATTRIBS4DVNVPROC glad_glVertexAttribs4dvNV;
PFNGLVERTEXATTRIBS4FVNVPROC glad_glVertexAttribs4fvNV;
PFNGLVERTEXATTRIBS4SVNVPROC glad_glVertexAttribs4svNV;
PFNGLVERTEXATTRIBS4UBVNVPROC glad_glVertexAttribs4ubvNV;
PFNGLVERTEXATTRIBI1IEXTPROC glad_glVertexAttribI1iEXT;
PFNGLVERTEXATTRIBI2IEXTPROC glad_glVertexAttribI2iEXT;
PFNGLVERTEXATTRIBI3IEXTPROC glad_glVertexAttribI3iEXT;
PFNGLVERTEXATTRIBI4IEXTPROC glad_glVertexAttribI4iEXT;
PFNGLVERTEXATTRIBI1UIEXTPROC glad_glVertexAttribI1uiEXT;
PFNGLVERTEXATTRIBI2UIEXTPROC glad_glVertexAttribI2uiEXT;
PFNGLVERTEXATTRIBI3UIEXTPROC glad_glVertexAttribI3uiEXT;
PFNGLVERTEXATTRIBI4UIEXTPROC glad_glVertexAttribI4uiEXT;
PFNGLVERTEXATTRIBI1IVEXTPROC glad_glVertexAttribI1ivEXT;
PFNGLVERTEXATTRIBI2IVEXTPROC glad_glVertexAttribI2ivEXT;
PFNGLVERTEXATTRIBI3IVEXTPROC glad_glVertexAttribI3ivEXT;
PFNGLVERTEXATTRIBI4IVEXTPROC glad_glVertexAttribI4ivEXT;
PFNGLVERTEXATTRIBI1UIVEXTPROC glad_glVertexAttribI1uivEXT;
PFNGLVERTEXATTRIBI2UIVEXTPROC glad_glVertexAttribI2uivEXT;
PFNGLVERTEXATTRIBI3UIVEXTPROC glad_glVertexAttribI3uivEXT;
PFNGLVERTEXATTRIBI4UIVEXTPROC glad_glVertexAttribI4uivEXT;
PFNGLVERTEXATTRIBI4BVEXTPROC glad_glVertexAttribI4bvEXT;
PFNGLVERTEXATTRIBI4SVEXTPROC glad_glVertexAttribI4svEXT;
PFNGLVERTEXATTRIBI4UBVEXTPROC glad_glVertexAttribI4ubvEXT;
PFNGLVERTEXATTRIBI4USVEXTPROC glad_glVertexAttribI4usvEXT;
PFNGLVERTEXATTRIBIPOINTEREXTPROC glad_glVertexAttribIPointerEXT;
PFNGLGETVERTEXATTRIBIIVEXTPROC glad_glGetVertexAttribIivEXT;
PFNGLGETVERTEXATTRIBIUIVEXTPROC glad_glGetVertexAttribIuivEXT;
PFNGLBEGINVIDEOCAPTURENVPROC glad_glBeginVideoCaptureNV;
PFNGLBINDVIDEOCAPTURESTREAMBUFFERNVPROC glad_glBindVideoCaptureStreamBufferNV;
PFNGLBINDVIDEOCAPTURESTREAMTEXTURENVPROC glad_glBindVideoCaptureStreamTextureNV;
PFNGLENDVIDEOCAPTURENVPROC glad_glEndVideoCaptureNV;
PFNGLGETVIDEOCAPTUREIVNVPROC glad_glGetVideoCaptureivNV;
PFNGLGETVIDEOCAPTURESTREAMIVNVPROC glad_glGetVideoCaptureStreamivNV;
PFNGLGETVIDEOCAPTURESTREAMFVNVPROC glad_glGetVideoCaptureStreamfvNV;
PFNGLGETVIDEOCAPTURESTREAMDVNVPROC glad_glGetVideoCaptureStreamdvNV;
PFNGLVIDEOCAPTURENVPROC glad_glVideoCaptureNV;
PFNGLVIDEOCAPTURESTREAMPARAMETERIVNVPROC glad_glVideoCaptureStreamParameterivNV;
PFNGLVIDEOCAPTURESTREAMPARAMETERFVNVPROC glad_glVideoCaptureStreamParameterfvNV;
PFNGLVIDEOCAPTURESTREAMPARAMETERDVNVPROC glad_glVideoCaptureStreamParameterdvNV;
PFNGLVIEWPORTSWIZZLENVPROC glad_glViewportSwizzleNV;
PFNGLMULTITEXCOORD1BOESPROC glad_glMultiTexCoord1bOES;
PFNGLMULTITEXCOORD1BVOESPROC glad_glMultiTexCoord1bvOES;
PFNGLMULTITEXCOORD2BOESPROC glad_glMultiTexCoord2bOES;
PFNGLMULTITEXCOORD2BVOESPROC glad_glMultiTexCoord2bvOES;
PFNGLMULTITEXCOORD3BOESPROC glad_glMultiTexCoord3bOES;
PFNGLMULTITEXCOORD3BVOESPROC glad_glMultiTexCoord3bvOES;
PFNGLMULTITEXCOORD4BOESPROC glad_glMultiTexCoord4bOES;
PFNGLMULTITEXCOORD4BVOESPROC glad_glMultiTexCoord4bvOES;
PFNGLTEXCOORD1BOESPROC glad_glTexCoord1bOES;
PFNGLTEXCOORD1BVOESPROC glad_glTexCoord1bvOES;
PFNGLTEXCOORD2BOESPROC glad_glTexCoord2bOES;
PFNGLTEXCOORD2BVOESPROC glad_glTexCoord2bvOES;
PFNGLTEXCOORD3BOESPROC glad_glTexCoord3bOES;
PFNGLTEXCOORD3BVOESPROC glad_glTexCoord3bvOES;
PFNGLTEXCOORD4BOESPROC glad_glTexCoord4bOES;
PFNGLTEXCOORD4BVOESPROC glad_glTexCoord4bvOES;
PFNGLVERTEX2BOESPROC glad_glVertex2bOES;
PFNGLVERTEX2BVOESPROC glad_glVertex2bvOES;
PFNGLVERTEX3BOESPROC glad_glVertex3bOES;
PFNGLVERTEX3BVOESPROC glad_glVertex3bvOES;
PFNGLVERTEX4BOESPROC glad_glVertex4bOES;
PFNGLVERTEX4BVOESPROC glad_glVertex4bvOES;
PFNGLALPHAFUNCXOESPROC glad_glAlphaFuncxOES;
PFNGLCLEARCOLORXOESPROC glad_glClearColorxOES;
PFNGLCLEARDEPTHXOESPROC glad_glClearDepthxOES;
PFNGLCLIPPLANEXOESPROC glad_glClipPlanexOES;
PFNGLCOLOR4XOESPROC glad_glColor4xOES;
PFNGLDEPTHRANGEXOESPROC glad_glDepthRangexOES;
PFNGLFOGXOESPROC glad_glFogxOES;
PFNGLFOGXVOESPROC glad_glFogxvOES;
PFNGLFRUSTUMXOESPROC glad_glFrustumxOES;
PFNGLGETCLIPPLANEXOESPROC glad_glGetClipPlanexOES;
PFNGLGETFIXEDVOESPROC glad_glGetFixedvOES;
PFNGLGETTEXENVXVOESPROC glad_glGetTexEnvxvOES;
PFNGLGETTEXPARAMETERXVOESPROC glad_glGetTexParameterxvOES;
PFNGLLIGHTMODELXOESPROC glad_glLightModelxOES;
PFNGLLIGHTMODELXVOESPROC glad_glLightModelxvOES;
PFNGLLIGHTXOESPROC glad_glLightxOES;
PFNGLLIGHTXVOESPROC glad_glLightxvOES;
PFNGLLINEWIDTHXOESPROC glad_glLineWidthxOES;
PFNGLLOADMATRIXXOESPROC glad_glLoadMatrixxOES;
PFNGLMATERIALXOESPROC glad_glMaterialxOES;
PFNGLMATERIALXVOESPROC glad_glMaterialxvOES;
PFNGLMULTMATRIXXOESPROC glad_glMultMatrixxOES;
PFNGLMULTITEXCOORD4XOESPROC glad_glMultiTexCoord4xOES;
PFNGLNORMAL3XOESPROC glad_glNormal3xOES;
PFNGLORTHOXOESPROC glad_glOrthoxOES;
PFNGLPOINTPARAMETERXVOESPROC glad_glPointParameterxvOES;
PFNGLPOINTSIZEXOESPROC glad_glPointSizexOES;
PFNGLPOLYGONOFFSETXOESPROC glad_glPolygonOffsetxOES;
PFNGLROTATEXOESPROC glad_glRotatexOES;
PFNGLSCALEXOESPROC glad_glScalexOES;
PFNGLTEXENVXOESPROC glad_glTexEnvxOES;
PFNGLTEXENVXVOESPROC glad_glTexEnvxvOES;
PFNGLTEXPARAMETERXOESPROC glad_glTexParameterxOES;
PFNGLTEXPARAMETERXVOESPROC glad_glTexParameterxvOES;
PFNGLTRANSLATEXOESPROC glad_glTranslatexOES;
PFNGLGETLIGHTXVOESPROC glad_glGetLightxvOES;
PFNGLGETMATERIALXVOESPROC glad_glGetMaterialxvOES;
PFNGLPOINTPARAMETERXOESPROC glad_glPointParameterxOES;
PFNGLSAMPLECOVERAGEXOESPROC glad_glSampleCoveragexOES;
PFNGLACCUMXOESPROC glad_glAccumxOES;
PFNGLBITMAPXOESPROC glad_glBitmapxOES;
PFNGLBLENDCOLORXOESPROC glad_glBlendColorxOES;
PFNGLCLEARACCUMXOESPROC glad_glClearAccumxOES;
PFNGLCOLOR3XOESPROC glad_glColor3xOES;
PFNGLCOLOR3XVOESPROC glad_glColor3xvOES;
PFNGLCOLOR4XVOESPROC glad_glColor4xvOES;
PFNGLCONVOLUTIONPARAMETERXOESPROC glad_glConvolutionParameterxOES;
PFNGLCONVOLUTIONPARAMETERXVOESPROC glad_glConvolutionParameterxvOES;
PFNGLEVALCOORD1XOESPROC glad_glEvalCoord1xOES;
PFNGLEVALCOORD1XVOESPROC glad_glEvalCoord1xvOES;
PFNGLEVALCOORD2XOESPROC glad_glEvalCoord2xOES;
PFNGLEVALCOORD2XVOESPROC glad_glEvalCoord2xvOES;
PFNGLFEEDBACKBUFFERXOESPROC glad_glFeedbackBufferxOES;
PFNGLGETCONVOLUTIONPARAMETERXVOESPROC glad_glGetConvolutionParameterxvOES;
PFNGLGETHISTOGRAMPARAMETERXVOESPROC glad_glGetHistogramParameterxvOES;
PFNGLGETLIGHTXOESPROC glad_glGetLightxOES;
PFNGLGETMAPXVOESPROC glad_glGetMapxvOES;
PFNGLGETMATERIALXOESPROC glad_glGetMaterialxOES;
PFNGLGETPIXELMAPXVPROC glad_glGetPixelMapxv;
PFNGLGETTEXGENXVOESPROC glad_glGetTexGenxvOES;
PFNGLGETTEXLEVELPARAMETERXVOESPROC glad_glGetTexLevelParameterxvOES;
PFNGLINDEXXOESPROC glad_glIndexxOES;
PFNGLINDEXXVOESPROC glad_glIndexxvOES;
PFNGLLOADTRANSPOSEMATRIXXOESPROC glad_glLoadTransposeMatrixxOES;
PFNGLMAP1XOESPROC glad_glMap1xOES;
PFNGLMAP2XOESPROC glad_glMap2xOES;
PFNGLMAPGRID1XOESPROC glad_glMapGrid1xOES;
PFNGLMAPGRID2XOESPROC glad_glMapGrid2xOES;
PFNGLMULTTRANSPOSEMATRIXXOESPROC glad_glMultTransposeMatrixxOES;
PFNGLMULTITEXCOORD1XOESPROC glad_glMultiTexCoord1xOES;
PFNGLMULTITEXCOORD1XVOESPROC glad_glMultiTexCoord1xvOES;
PFNGLMULTITEXCOORD2XOESPROC glad_glMultiTexCoord2xOES;
PFNGLMULTITEXCOORD2XVOESPROC glad_glMultiTexCoord2xvOES;
PFNGLMULTITEXCOORD3XOESPROC glad_glMultiTexCoord3xOES;
PFNGLMULTITEXCOORD3XVOESPROC glad_glMultiTexCoord3xvOES;
PFNGLMULTITEXCOORD4XVOESPROC glad_glMultiTexCoord4xvOES;
PFNGLNORMAL3XVOESPROC glad_glNormal3xvOES;
PFNGLPASSTHROUGHXOESPROC glad_glPassThroughxOES;
PFNGLPIXELMAPXPROC glad_glPixelMapx;
PFNGLPIXELSTOREXPROC glad_glPixelStorex;
PFNGLPIXELTRANSFERXOESPROC glad_glPixelTransferxOES;
PFNGLPIXELZOOMXOESPROC glad_glPixelZoomxOES;
PFNGLPRIORITIZETEXTURESXOESPROC glad_glPrioritizeTexturesxOES;
PFNGLRASTERPOS2XOESPROC glad_glRasterPos2xOES;
PFNGLRASTERPOS2XVOESPROC glad_glRasterPos2xvOES;
PFNGLRASTERPOS3XOESPROC glad_glRasterPos3xOES;
PFNGLRASTERPOS3XVOESPROC glad_glRasterPos3xvOES;
PFNGLRASTERPOS4XOESPROC glad_glRasterPos4xOES;
PFNGLRASTERPOS4XVOESPROC glad_glRasterPos4xvOES;
PFNGLRECTXOESPROC glad_glRectxOES;
PFNGLRECTXVOESPROC glad_glRectxvOES;
PFNGLTEXCOORD1XOESPROC glad_glTexCoord1xOES;
PFNGLTEXCOORD1XVOESPROC glad_glTexCoord1xvOES;
PFNGLTEXCOORD2XOESPROC glad_glTexCoord2xOES;
PFNGLTEXCOORD2XVOESPROC glad_glTexCoord2xvOES;
PFNGLTEXCOORD3XOESPROC glad_glTexCoord3xOES;
PFNGLTEXCOORD3XVOESPROC glad_glTexCoord3xvOES;
PFNGLTEXCOORD4XOESPROC glad_glTexCoord4xOES;
PFNGLTEXCOORD4XVOESPROC glad_glTexCoord4xvOES;
PFNGLTEXGENXOESPROC glad_glTexGenxOES;
PFNGLTEXGENXVOESPROC glad_glTexGenxvOES;
PFNGLVERTEX2XOESPROC glad_glVertex2xOES;
PFNGLVERTEX2XVOESPROC glad_glVertex2xvOES;
PFNGLVERTEX3XOESPROC glad_glVertex3xOES;
PFNGLVERTEX3XVOESPROC glad_glVertex3xvOES;
PFNGLVERTEX4XOESPROC glad_glVertex4xOES;
PFNGLVERTEX4XVOESPROC glad_glVertex4xvOES;
PFNGLQUERYMATRIXXOESPROC glad_glQueryMatrixxOES;
PFNGLCLEARDEPTHFOESPROC glad_glClearDepthfOES;
PFNGLCLIPPLANEFOESPROC glad_glClipPlanefOES;
PFNGLDEPTHRANGEFOESPROC glad_glDepthRangefOES;
PFNGLFRUSTUMFOESPROC glad_glFrustumfOES;
PFNGLGETCLIPPLANEFOESPROC glad_glGetClipPlanefOES;
PFNGLORTHOFOESPROC glad_glOrthofOES;
PFNGLFRAMEBUFFERTEXTUREMULTIVIEWOVRPROC glad_glFramebufferTextureMultiviewOVR;
PFNGLHINTPGIPROC glad_glHintPGI;
PFNGLDETAILTEXFUNCSGISPROC glad_glDetailTexFuncSGIS;
PFNGLGETDETAILTEXFUNCSGISPROC glad_glGetDetailTexFuncSGIS;
PFNGLFOGFUNCSGISPROC glad_glFogFuncSGIS;
PFNGLGETFOGFUNCSGISPROC glad_glGetFogFuncSGIS;
PFNGLSAMPLEMASKSGISPROC glad_glSampleMaskSGIS;
PFNGLSAMPLEPATTERNSGISPROC glad_glSamplePatternSGIS;
PFNGLPIXELTEXGENPARAMETERISGISPROC glad_glPixelTexGenParameteriSGIS;
PFNGLPIXELTEXGENPARAMETERIVSGISPROC glad_glPixelTexGenParameterivSGIS;
PFNGLPIXELTEXGENPARAMETERFSGISPROC glad_glPixelTexGenParameterfSGIS;
PFNGLPIXELTEXGENPARAMETERFVSGISPROC glad_glPixelTexGenParameterfvSGIS;
PFNGLGETPIXELTEXGENPARAMETERIVSGISPROC glad_glGetPixelTexGenParameterivSGIS;
PFNGLGETPIXELTEXGENPARAMETERFVSGISPROC glad_glGetPixelTexGenParameterfvSGIS;
PFNGLPOINTPARAMETERFSGISPROC glad_glPointParameterfSGIS;
PFNGLPOINTPARAMETERFVSGISPROC glad_glPointParameterfvSGIS;
PFNGLSHARPENTEXFUNCSGISPROC glad_glSharpenTexFuncSGIS;
PFNGLGETSHARPENTEXFUNCSGISPROC glad_glGetSharpenTexFuncSGIS;
PFNGLTEXIMAGE4DSGISPROC glad_glTexImage4DSGIS;
PFNGLTEXSUBIMAGE4DSGISPROC glad_glTexSubImage4DSGIS;
PFNGLTEXTURECOLORMASKSGISPROC glad_glTextureColorMaskSGIS;
PFNGLGETTEXFILTERFUNCSGISPROC glad_glGetTexFilterFuncSGIS;
PFNGLTEXFILTERFUNCSGISPROC glad_glTexFilterFuncSGIS;
PFNGLASYNCMARKERSGIXPROC glad_glAsyncMarkerSGIX;
PFNGLFINISHASYNCSGIXPROC glad_glFinishAsyncSGIX;
PFNGLPOLLASYNCSGIXPROC glad_glPollAsyncSGIX;
PFNGLGENASYNCMARKERSSGIXPROC glad_glGenAsyncMarkersSGIX;
PFNGLDELETEASYNCMARKERSSGIXPROC glad_glDeleteAsyncMarkersSGIX;
PFNGLISASYNCMARKERSGIXPROC glad_glIsAsyncMarkerSGIX;
PFNGLFLUSHRASTERSGIXPROC glad_glFlushRasterSGIX;
PFNGLFRAGMENTCOLORMATERIALSGIXPROC glad_glFragmentColorMaterialSGIX;
PFNGLFRAGMENTLIGHTFSGIXPROC glad_glFragmentLightfSGIX;
PFNGLFRAGMENTLIGHTFVSGIXPROC glad_glFragmentLightfvSGIX;
PFNGLFRAGMENTLIGHTISGIXPROC glad_glFragmentLightiSGIX;
PFNGLFRAGMENTLIGHTIVSGIXPROC glad_glFragmentLightivSGIX;
PFNGLFRAGMENTLIGHTMODELFSGIXPROC glad_glFragmentLightModelfSGIX;
PFNGLFRAGMENTLIGHTMODELFVSGIXPROC glad_glFragmentLightModelfvSGIX;
PFNGLFRAGMENTLIGHTMODELISGIXPROC glad_glFragmentLightModeliSGIX;
PFNGLFRAGMENTLIGHTMODELIVSGIXPROC glad_glFragmentLightModelivSGIX;
PFNGLFRAGMENTMATERIALFSGIXPROC glad_glFragmentMaterialfSGIX;
PFNGLFRAGMENTMATERIALFVSGIXPROC glad_glFragmentMaterialfvSGIX;
PFNGLFRAGMENTMATERIALISGIXPROC glad_glFragmentMaterialiSGIX;
PFNGLFRAGMENTMATERIALIVSGIXPROC glad_glFragmentMaterialivSGIX;
PFNGLGETFRAGMENTLIGHTFVSGIXPROC glad_glGetFragmentLightfvSGIX;
PFNGLGETFRAGMENTLIGHTIVSGIXPROC glad_glGetFragmentLightivSGIX;
PFNGLGETFRAGMENTMATERIALFVSGIXPROC glad_glGetFragmentMaterialfvSGIX;
PFNGLGETFRAGMENTMATERIALIVSGIXPROC glad_glGetFragmentMaterialivSGIX;
PFNGLLIGHTENVISGIXPROC glad_glLightEnviSGIX;
PFNGLFRAMEZOOMSGIXPROC glad_glFrameZoomSGIX;
PFNGLIGLOOINTERFACESGIXPROC glad_glIglooInterfaceSGIX;
PFNGLGETINSTRUMENTSSGIXPROC glad_glGetInstrumentsSGIX;
PFNGLINSTRUMENTSBUFFERSGIXPROC glad_glInstrumentsBufferSGIX;
PFNGLPOLLINSTRUMENTSSGIXPROC glad_glPollInstrumentsSGIX;
PFNGLREADINSTRUMENTSSGIXPROC glad_glReadInstrumentsSGIX;
PFNGLSTARTINSTRUMENTSSGIXPROC glad_glStartInstrumentsSGIX;
PFNGLSTOPINSTRUMENTSSGIXPROC glad_glStopInstrumentsSGIX;
PFNGLGETLISTPARAMETERFVSGIXPROC glad_glGetListParameterfvSGIX;
PFNGLGETLISTPARAMETERIVSGIXPROC glad_glGetListParameterivSGIX;
PFNGLLISTPARAMETERFSGIXPROC glad_glListParameterfSGIX;
PFNGLLISTPARAMETERFVSGIXPROC glad_glListParameterfvSGIX;
PFNGLLISTPARAMETERISGIXPROC glad_glListParameteriSGIX;
PFNGLLISTPARAMETERIVSGIXPROC glad_glListParameterivSGIX;
PFNGLPIXELTEXGENSGIXPROC glad_glPixelTexGenSGIX;
PFNGLDEFORMATIONMAP3DSGIXPROC glad_glDeformationMap3dSGIX;
PFNGLDEFORMATIONMAP3FSGIXPROC glad_glDeformationMap3fSGIX;
PFNGLDEFORMSGIXPROC glad_glDeformSGIX;
PFNGLLOADIDENTITYDEFORMATIONMAPSGIXPROC glad_glLoadIdentityDeformationMapSGIX;
PFNGLREFERENCEPLANESGIXPROC glad_glReferencePlaneSGIX;
PFNGLSPRITEPARAMETERFSGIXPROC glad_glSpriteParameterfSGIX;
PFNGLSPRITEPARAMETERFVSGIXPROC glad_glSpriteParameterfvSGIX;
PFNGLSPRITEPARAMETERISGIXPROC glad_glSpriteParameteriSGIX;
PFNGLSPRITEPARAMETERIVSGIXPROC glad_glSpriteParameterivSGIX;
PFNGLTAGSAMPLEBUFFERSGIXPROC glad_glTagSampleBufferSGIX;
PFNGLCOLORTABLESGIPROC glad_glColorTableSGI;
PFNGLCOLORTABLEPARAMETERFVSGIPROC glad_glColorTableParameterfvSGI;
PFNGLCOLORTABLEPARAMETERIVSGIPROC glad_glColorTableParameterivSGI;
PFNGLCOPYCOLORTABLESGIPROC glad_glCopyColorTableSGI;
PFNGLGETCOLORTABLESGIPROC glad_glGetColorTableSGI;
PFNGLGETCOLORTABLEPARAMETERFVSGIPROC glad_glGetColorTableParameterfvSGI;
PFNGLGETCOLORTABLEPARAMETERIVSGIPROC glad_glGetColorTableParameterivSGI;
PFNGLFINISHTEXTURESUNXPROC glad_glFinishTextureSUNX;
PFNGLGLOBALALPHAFACTORBSUNPROC glad_glGlobalAlphaFactorbSUN;
PFNGLGLOBALALPHAFACTORSSUNPROC glad_glGlobalAlphaFactorsSUN;
PFNGLGLOBALALPHAFACTORISUNPROC glad_glGlobalAlphaFactoriSUN;
PFNGLGLOBALALPHAFACTORFSUNPROC glad_glGlobalAlphaFactorfSUN;
PFNGLGLOBALALPHAFACTORDSUNPROC glad_glGlobalAlphaFactordSUN;
PFNGLGLOBALALPHAFACTORUBSUNPROC glad_glGlobalAlphaFactorubSUN;
PFNGLGLOBALALPHAFACTORUSSUNPROC glad_glGlobalAlphaFactorusSUN;
PFNGLGLOBALALPHAFACTORUISUNPROC glad_glGlobalAlphaFactoruiSUN;
PFNGLDRAWMESHARRAYSSUNPROC glad_glDrawMeshArraysSUN;
PFNGLREPLACEMENTCODEUISUNPROC glad_glReplacementCodeuiSUN;
PFNGLREPLACEMENTCODEUSSUNPROC glad_glReplacementCodeusSUN;
PFNGLREPLACEMENTCODEUBSUNPROC glad_glReplacementCodeubSUN;
PFNGLREPLACEMENTCODEUIVSUNPROC glad_glReplacementCodeuivSUN;
PFNGLREPLACEMENTCODEUSVSUNPROC glad_glReplacementCodeusvSUN;
PFNGLREPLACEMENTCODEUBVSUNPROC glad_glReplacementCodeubvSUN;
PFNGLREPLACEMENTCODEPOINTERSUNPROC glad_glReplacementCodePointerSUN;
PFNGLCOLOR4UBVERTEX2FSUNPROC glad_glColor4ubVertex2fSUN;
PFNGLCOLOR4UBVERTEX2FVSUNPROC glad_glColor4ubVertex2fvSUN;
PFNGLCOLOR4UBVERTEX3FSUNPROC glad_glColor4ubVertex3fSUN;
PFNGLCOLOR4UBVERTEX3FVSUNPROC glad_glColor4ubVertex3fvSUN;
PFNGLCOLOR3FVERTEX3FSUNPROC glad_glColor3fVertex3fSUN;
PFNGLCOLOR3FVERTEX3FVSUNPROC glad_glColor3fVertex3fvSUN;
PFNGLNORMAL3FVERTEX3FSUNPROC glad_glNormal3fVertex3fSUN;
PFNGLNORMAL3FVERTEX3FVSUNPROC glad_glNormal3fVertex3fvSUN;
PFNGLCOLOR4FNORMAL3FVERTEX3FSUNPROC glad_glColor4fNormal3fVertex3fSUN;
PFNGLCOLOR4FNORMAL3FVERTEX3FVSUNPROC glad_glColor4fNormal3fVertex3fvSUN;
PFNGLTEXCOORD2FVERTEX3FSUNPROC glad_glTexCoord2fVertex3fSUN;
PFNGLTEXCOORD2FVERTEX3FVSUNPROC glad_glTexCoord2fVertex3fvSUN;
PFNGLTEXCOORD4FVERTEX4FSUNPROC glad_glTexCoord4fVertex4fSUN;
PFNGLTEXCOORD4FVERTEX4FVSUNPROC glad_glTexCoord4fVertex4fvSUN;
PFNGLTEXCOORD2FCOLOR4UBVERTEX3FSUNPROC glad_glTexCoord2fColor4ubVertex3fSUN;
PFNGLTEXCOORD2FCOLOR4UBVERTEX3FVSUNPROC glad_glTexCoord2fColor4ubVertex3fvSUN;
PFNGLTEXCOORD2FCOLOR3FVERTEX3FSUNPROC glad_glTexCoord2fColor3fVertex3fSUN;
PFNGLTEXCOORD2FCOLOR3FVERTEX3FVSUNPROC glad_glTexCoord2fColor3fVertex3fvSUN;
PFNGLTEXCOORD2FNORMAL3FVERTEX3FSUNPROC glad_glTexCoord2fNormal3fVertex3fSUN;
PFNGLTEXCOORD2FNORMAL3FVERTEX3FVSUNPROC glad_glTexCoord2fNormal3fVertex3fvSUN;
PFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC glad_glTexCoord2fColor4fNormal3fVertex3fSUN;
PFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC glad_glTexCoord2fColor4fNormal3fVertex3fvSUN;
PFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FSUNPROC glad_glTexCoord4fColor4fNormal3fVertex4fSUN;
PFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FVSUNPROC glad_glTexCoord4fColor4fNormal3fVertex4fvSUN;
PFNGLREPLACEMENTCODEUIVERTEX3FSUNPROC glad_glReplacementCodeuiVertex3fSUN;
PFNGLREPLACEMENTCODEUIVERTEX3FVSUNPROC glad_glReplacementCodeuiVertex3fvSUN;
PFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FSUNPROC glad_glReplacementCodeuiColor4ubVertex3fSUN;
PFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FVSUNPROC glad_glReplacementCodeuiColor4ubVertex3fvSUN;
PFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FSUNPROC glad_glReplacementCodeuiColor3fVertex3fSUN;
PFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FVSUNPROC glad_glReplacementCodeuiColor3fVertex3fvSUN;
PFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FSUNPROC glad_glReplacementCodeuiNormal3fVertex3fSUN;
PFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FVSUNPROC glad_glReplacementCodeuiNormal3fVertex3fvSUN;
PFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FSUNPROC glad_glReplacementCodeuiColor4fNormal3fVertex3fSUN;
PFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FVSUNPROC glad_glReplacementCodeuiColor4fNormal3fVertex3fvSUN;
PFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FSUNPROC glad_glReplacementCodeuiTexCoord2fVertex3fSUN;
PFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FVSUNPROC glad_glReplacementCodeuiTexCoord2fVertex3fvSUN;
PFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FSUNPROC glad_glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN;
PFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FVSUNPROC glad_glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN;
PFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC glad_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN;
PFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC glad_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN;
static void load_GL_VERSION_1_0(GLADloadproc load) {
	if(!GLAD_GL_VERSION_1_0) return;
	glad_glCullFace = (PFNGLCULLFACEPROC)load("glCullFace");
	glad_glFrontFace = (PFNGLFRONTFACEPROC)load("glFrontFace");
	glad_glHint = (PFNGLHINTPROC)load("glHint");
	glad_glLineWidth = (PFNGLLINEWIDTHPROC)load("glLineWidth");
	glad_glPointSize = (PFNGLPOINTSIZEPROC)load("glPointSize");
	glad_glPolygonMode = (PFNGLPOLYGONMODEPROC)load("glPolygonMode");
	glad_glScissor = (PFNGLSCISSORPROC)load("glScissor");
	glad_glTexParameterf = (PFNGLTEXPARAMETERFPROC)load("glTexParameterf");
	glad_glTexParameterfv = (PFNGLTEXPARAMETERFVPROC)load("glTexParameterfv");
	glad_glTexParameteri = (PFNGLTEXPARAMETERIPROC)load("glTexParameteri");
	glad_glTexParameteriv = (PFNGLTEXPARAMETERIVPROC)load("glTexParameteriv");
	glad_glTexImage1D = (PFNGLTEXIMAGE1DPROC)load("glTexImage1D");
	glad_glTexImage2D = (PFNGLTEXIMAGE2DPROC)load("glTexImage2D");
	glad_glDrawBuffer = (PFNGLDRAWBUFFERPROC)load("glDrawBuffer");
	glad_glClear = (PFNGLCLEARPROC)load("glClear");
	glad_glClearColor = (PFNGLCLEARCOLORPROC)load("glClearColor");
	glad_glClearStencil = (PFNGLCLEARSTENCILPROC)load("glClearStencil");
	glad_glClearDepth = (PFNGLCLEARDEPTHPROC)load("glClearDepth");
	glad_glStencilMask = (PFNGLSTENCILMASKPROC)load("glStencilMask");
	glad_glColorMask = (PFNGLCOLORMASKPROC)load("glColorMask");
	glad_glDepthMask = (PFNGLDEPTHMASKPROC)load("glDepthMask");
	glad_glDisable = (PFNGLDISABLEPROC)load("glDisable");
	glad_glEnable = (PFNGLENABLEPROC)load("glEnable");
	glad_glFinish = (PFNGLFINISHPROC)load("glFinish");
	glad_glFlush = (PFNGLFLUSHPROC)load("glFlush");
	glad_glBlendFunc = (PFNGLBLENDFUNCPROC)load("glBlendFunc");
	glad_glLogicOp = (PFNGLLOGICOPPROC)load("glLogicOp");
	glad_glStencilFunc = (PFNGLSTENCILFUNCPROC)load("glStencilFunc");
	glad_glStencilOp = (PFNGLSTENCILOPPROC)load("glStencilOp");
	glad_glDepthFunc = (PFNGLDEPTHFUNCPROC)load("glDepthFunc");
	glad_glPixelStoref = (PFNGLPIXELSTOREFPROC)load("glPixelStoref");
	glad_glPixelStorei = (PFNGLPIXELSTOREIPROC)load("glPixelStorei");
	glad_glReadBuffer = (PFNGLREADBUFFERPROC)load("glReadBuffer");
	glad_glReadPixels = (PFNGLREADPIXELSPROC)load("glReadPixels");
	glad_glGetBooleanv = (PFNGLGETBOOLEANVPROC)load("glGetBooleanv");
	glad_glGetDoublev = (PFNGLGETDOUBLEVPROC)load("glGetDoublev");
	glad_glGetError = (PFNGLGETERRORPROC)load("glGetError");
	glad_glGetFloatv = (PFNGLGETFLOATVPROC)load("glGetFloatv");
	glad_glGetIntegerv = (PFNGLGETINTEGERVPROC)load("glGetIntegerv");
	glad_glGetString = (PFNGLGETSTRINGPROC)load("glGetString");
	glad_glGetTexImage = (PFNGLGETTEXIMAGEPROC)load("glGetTexImage");
	glad_glGetTexParameterfv = (PFNGLGETTEXPARAMETERFVPROC)load("glGetTexParameterfv");
	glad_glGetTexParameteriv = (PFNGLGETTEXPARAMETERIVPROC)load("glGetTexParameteriv");
	glad_glGetTexLevelParameterfv = (PFNGLGETTEXLEVELPARAMETERFVPROC)load("glGetTexLevelParameterfv");
	glad_glGetTexLevelParameteriv = (PFNGLGETTEXLEVELPARAMETERIVPROC)load("glGetTexLevelParameteriv");
	glad_glIsEnabled = (PFNGLISENABLEDPROC)load("glIsEnabled");
	glad_glDepthRange = (PFNGLDEPTHRANGEPROC)load("glDepthRange");
	glad_glViewport = (PFNGLVIEWPORTPROC)load("glViewport");
}
static void load_GL_VERSION_1_1(GLADloadproc load) {
	if(!GLAD_GL_VERSION_1_1) return;
	glad_glDrawArrays = (PFNGLDRAWARRAYSPROC)load("glDrawArrays");
	glad_glDrawElements = (PFNGLDRAWELEMENTSPROC)load("glDrawElements");
	glad_glPolygonOffset = (PFNGLPOLYGONOFFSETPROC)load("glPolygonOffset");
	glad_glCopyTexImage1D = (PFNGLCOPYTEXIMAGE1DPROC)load("glCopyTexImage1D");
	glad_glCopyTexImage2D = (PFNGLCOPYTEXIMAGE2DPROC)load("glCopyTexImage2D");
	glad_glCopyTexSubImage1D = (PFNGLCOPYTEXSUBIMAGE1DPROC)load("glCopyTexSubImage1D");
	glad_glCopyTexSubImage2D = (PFNGLCOPYTEXSUBIMAGE2DPROC)load("glCopyTexSubImage2D");
	glad_glTexSubImage1D = (PFNGLTEXSUBIMAGE1DPROC)load("glTexSubImage1D");
	glad_glTexSubImage2D = (PFNGLTEXSUBIMAGE2DPROC)load("glTexSubImage2D");
	glad_glBindTexture = (PFNGLBINDTEXTUREPROC)load("glBindTexture");
	glad_glDeleteTextures = (PFNGLDELETETEXTURESPROC)load("glDeleteTextures");
	glad_glGenTextures = (PFNGLGENTEXTURESPROC)load("glGenTextures");
	glad_glIsTexture = (PFNGLISTEXTUREPROC)load("glIsTexture");
}
static void load_GL_VERSION_1_2(GLADloadproc load) {
	if(!GLAD_GL_VERSION_1_2) return;
	glad_glDrawRangeElements = (PFNGLDRAWRANGEELEMENTSPROC)load("glDrawRangeElements");
	glad_glTexImage3D = (PFNGLTEXIMAGE3DPROC)load("glTexImage3D");
	glad_glTexSubImage3D = (PFNGLTEXSUBIMAGE3DPROC)load("glTexSubImage3D");
	glad_glCopyTexSubImage3D = (PFNGLCOPYTEXSUBIMAGE3DPROC)load("glCopyTexSubImage3D");
}
static void load_GL_VERSION_1_3(GLADloadproc load) {
	if(!GLAD_GL_VERSION_1_3) return;
	glad_glActiveTexture = (PFNGLACTIVETEXTUREPROC)load("glActiveTexture");
	glad_glSampleCoverage = (PFNGLSAMPLECOVERAGEPROC)load("glSampleCoverage");
	glad_glCompressedTexImage3D = (PFNGLCOMPRESSEDTEXIMAGE3DPROC)load("glCompressedTexImage3D");
	glad_glCompressedTexImage2D = (PFNGLCOMPRESSEDTEXIMAGE2DPROC)load("glCompressedTexImage2D");
	glad_glCompressedTexImage1D = (PFNGLCOMPRESSEDTEXIMAGE1DPROC)load("glCompressedTexImage1D");
	glad_glCompressedTexSubImage3D = (PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC)load("glCompressedTexSubImage3D");
	glad_glCompressedTexSubImage2D = (PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC)load("glCompressedTexSubImage2D");
	glad_glCompressedTexSubImage1D = (PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC)load("glCompressedTexSubImage1D");
	glad_glGetCompressedTexImage = (PFNGLGETCOMPRESSEDTEXIMAGEPROC)load("glGetCompressedTexImage");
}
static void load_GL_VERSION_1_4(GLADloadproc load) {
	if(!GLAD_GL_VERSION_1_4) return;
	glad_glBlendFuncSeparate = (PFNGLBLENDFUNCSEPARATEPROC)load("glBlendFuncSeparate");
	glad_glMultiDrawArrays = (PFNGLMULTIDRAWARRAYSPROC)load("glMultiDrawArrays");
	glad_glMultiDrawElements = (PFNGLMULTIDRAWELEMENTSPROC)load("glMultiDrawElements");
	glad_glPointParameterf = (PFNGLPOINTPARAMETERFPROC)load("glPointParameterf");
	glad_glPointParameterfv = (PFNGLPOINTPARAMETERFVPROC)load("glPointParameterfv");
	glad_glPointParameteri = (PFNGLPOINTPARAMETERIPROC)load("glPointParameteri");
	glad_glPointParameteriv = (PFNGLPOINTPARAMETERIVPROC)load("glPointParameteriv");
	glad_glBlendColor = (PFNGLBLENDCOLORPROC)load("glBlendColor");
	glad_glBlendEquation = (PFNGLBLENDEQUATIONPROC)load("glBlendEquation");
}
static void load_GL_VERSION_1_5(GLADloadproc load) {
	if(!GLAD_GL_VERSION_1_5) return;
	glad_glGenQueries = (PFNGLGENQUERIESPROC)load("glGenQueries");
	glad_glDeleteQueries = (PFNGLDELETEQUERIESPROC)load("glDeleteQueries");
	glad_glIsQuery = (PFNGLISQUERYPROC)load("glIsQuery");
	glad_glBeginQuery = (PFNGLBEGINQUERYPROC)load("glBeginQuery");
	glad_glEndQuery = (PFNGLENDQUERYPROC)load("glEndQuery");
	glad_glGetQueryiv = (PFNGLGETQUERYIVPROC)load("glGetQueryiv");
	glad_glGetQueryObjectiv = (PFNGLGETQUERYOBJECTIVPROC)load("glGetQueryObjectiv");
	glad_glGetQueryObjectuiv = (PFNGLGETQUERYOBJECTUIVPROC)load("glGetQueryObjectuiv");
	glad_glBindBuffer = (PFNGLBINDBUFFERPROC)load("glBindBuffer");
	glad_glDeleteBuffers = (PFNGLDELETEBUFFERSPROC)load("glDeleteBuffers");
	glad_glGenBuffers = (PFNGLGENBUFFERSPROC)load("glGenBuffers");
	glad_glIsBuffer = (PFNGLISBUFFERPROC)load("glIsBuffer");
	glad_glBufferData = (PFNGLBUFFERDATAPROC)load("glBufferData");
	glad_glBufferSubData = (PFNGLBUFFERSUBDATAPROC)load("glBufferSubData");
	glad_glGetBufferSubData = (PFNGLGETBUFFERSUBDATAPROC)load("glGetBufferSubData");
	glad_glMapBuffer = (PFNGLMAPBUFFERPROC)load("glMapBuffer");
	glad_glUnmapBuffer = (PFNGLUNMAPBUFFERPROC)load("glUnmapBuffer");
	glad_glGetBufferParameteriv = (PFNGLGETBUFFERPARAMETERIVPROC)load("glGetBufferParameteriv");
	glad_glGetBufferPointerv = (PFNGLGETBUFFERPOINTERVPROC)load("glGetBufferPointerv");
}
static void load_GL_VERSION_2_0(GLADloadproc load) {
	if(!GLAD_GL_VERSION_2_0) return;
	glad_glBlendEquationSeparate = (PFNGLBLENDEQUATIONSEPARATEPROC)load("glBlendEquationSeparate");
	glad_glDrawBuffers = (PFNGLDRAWBUFFERSPROC)load("glDrawBuffers");
	glad_glStencilOpSeparate = (PFNGLSTENCILOPSEPARATEPROC)load("glStencilOpSeparate");
	glad_glStencilFuncSeparate = (PFNGLSTENCILFUNCSEPARATEPROC)load("glStencilFuncSeparate");
	glad_glStencilMaskSeparate = (PFNGLSTENCILMASKSEPARATEPROC)load("glStencilMaskSeparate");
	glad_glAttachShader = (PFNGLATTACHSHADERPROC)load("glAttachShader");
	glad_glBindAttribLocation = (PFNGLBINDATTRIBLOCATIONPROC)load("glBindAttribLocation");
	glad_glCompileShader = (PFNGLCOMPILESHADERPROC)load("glCompileShader");
	glad_glCreateProgram = (PFNGLCREATEPROGRAMPROC)load("glCreateProgram");
	glad_glCreateShader = (PFNGLCREATESHADERPROC)load("glCreateShader");
	glad_glDeleteProgram = (PFNGLDELETEPROGRAMPROC)load("glDeleteProgram");
	glad_glDeleteShader = (PFNGLDELETESHADERPROC)load("glDeleteShader");
	glad_glDetachShader = (PFNGLDETACHSHADERPROC)load("glDetachShader");
	glad_glDisableVertexAttribArray = (PFNGLDISABLEVERTEXATTRIBARRAYPROC)load("glDisableVertexAttribArray");
	glad_glEnableVertexAttribArray = (PFNGLENABLEVERTEXATTRIBARRAYPROC)load("glEnableVertexAttribArray");
	glad_glGetActiveAttrib = (PFNGLGETACTIVEATTRIBPROC)load("glGetActiveAttrib");
	glad_glGetActiveUniform = (PFNGLGETACTIVEUNIFORMPROC)load("glGetActiveUniform");
	glad_glGetAttachedShaders = (PFNGLGETATTACHEDSHADERSPROC)load("glGetAttachedShaders");
	glad_glGetAttribLocation = (PFNGLGETATTRIBLOCATIONPROC)load("glGetAttribLocation");
	glad_glGetProgramiv = (PFNGLGETPROGRAMIVPROC)load("glGetProgramiv");
	glad_glGetProgramInfoLog = (PFNGLGETPROGRAMINFOLOGPROC)load("glGetProgramInfoLog");
	glad_glGetShaderiv = (PFNGLGETSHADERIVPROC)load("glGetShaderiv");
	glad_glGetShaderInfoLog = (PFNGLGETSHADERINFOLOGPROC)load("glGetShaderInfoLog");
	glad_glGetShaderSource = (PFNGLGETSHADERSOURCEPROC)load("glGetShaderSource");
	glad_glGetUniformLocation = (PFNGLGETUNIFORMLOCATIONPROC)load("glGetUniformLocation");
	glad_glGetUniformfv = (PFNGLGETUNIFORMFVPROC)load("glGetUniformfv");
	glad_glGetUniformiv = (PFNGLGETUNIFORMIVPROC)load("glGetUniformiv");
	glad_glGetVertexAttribdv = (PFNGLGETVERTEXATTRIBDVPROC)load("glGetVertexAttribdv");
	glad_glGetVertexAttribfv = (PFNGLGETVERTEXATTRIBFVPROC)load("glGetVertexAttribfv");
	glad_glGetVertexAttribiv = (PFNGLGETVERTEXATTRIBIVPROC)load("glGetVertexAttribiv");
	glad_glGetVertexAttribPointerv = (PFNGLGETVERTEXATTRIBPOINTERVPROC)load("glGetVertexAttribPointerv");
	glad_glIsProgram = (PFNGLISPROGRAMPROC)load("glIsProgram");
	glad_glIsShader = (PFNGLISSHADERPROC)load("glIsShader");
	glad_glLinkProgram = (PFNGLLINKPROGRAMPROC)load("glLinkProgram");
	glad_glShaderSource = (PFNGLSHADERSOURCEPROC)load("glShaderSource");
	glad_glUseProgram = (PFNGLUSEPROGRAMPROC)load("glUseProgram");
	glad_glUniform1f = (PFNGLUNIFORM1FPROC)load("glUniform1f");
	glad_glUniform2f = (PFNGLUNIFORM2FPROC)load("glUniform2f");
	glad_glUniform3f = (PFNGLUNIFORM3FPROC)load("glUniform3f");
	glad_glUniform4f = (PFNGLUNIFORM4FPROC)load("glUniform4f");
	glad_glUniform1i = (PFNGLUNIFORM1IPROC)load("glUniform1i");
	glad_glUniform2i = (PFNGLUNIFORM2IPROC)load("glUniform2i");
	glad_glUniform3i = (PFNGLUNIFORM3IPROC)load("glUniform3i");
	glad_glUniform4i = (PFNGLUNIFORM4IPROC)load("glUniform4i");
	glad_glUniform1fv = (PFNGLUNIFORM1FVPROC)load("glUniform1fv");
	glad_glUniform2fv = (PFNGLUNIFORM2FVPROC)load("glUniform2fv");
	glad_glUniform3fv = (PFNGLUNIFORM3FVPROC)load("glUniform3fv");
	glad_glUniform4fv = (PFNGLUNIFORM4FVPROC)load("glUniform4fv");
	glad_glUniform1iv = (PFNGLUNIFORM1IVPROC)load("glUniform1iv");
	glad_glUniform2iv = (PFNGLUNIFORM2IVPROC)load("glUniform2iv");
	glad_glUniform3iv = (PFNGLUNIFORM3IVPROC)load("glUniform3iv");
	glad_glUniform4iv = (PFNGLUNIFORM4IVPROC)load("glUniform4iv");
	glad_glUniformMatrix2fv = (PFNGLUNIFORMMATRIX2FVPROC)load("glUniformMatrix2fv");
	glad_glUniformMatrix3fv = (PFNGLUNIFORMMATRIX3FVPROC)load("glUniformMatrix3fv");
	glad_glUniformMatrix4fv = (PFNGLUNIFORMMATRIX4FVPROC)load("glUniformMatrix4fv");
	glad_glValidateProgram = (PFNGLVALIDATEPROGRAMPROC)load("glValidateProgram");
	glad_glVertexAttrib1d = (PFNGLVERTEXATTRIB1DPROC)load("glVertexAttrib1d");
	glad_glVertexAttrib1dv = (PFNGLVERTEXATTRIB1DVPROC)load("glVertexAttrib1dv");
	glad_glVertexAttrib1f = (PFNGLVERTEXATTRIB1FPROC)load("glVertexAttrib1f");
	glad_glVertexAttrib1fv = (PFNGLVERTEXATTRIB1FVPROC)load("glVertexAttrib1fv");
	glad_glVertexAttrib1s = (PFNGLVERTEXATTRIB1SPROC)load("glVertexAttrib1s");
	glad_glVertexAttrib1sv = (PFNGLVERTEXATTRIB1SVPROC)load("glVertexAttrib1sv");
	glad_glVertexAttrib2d = (PFNGLVERTEXATTRIB2DPROC)load("glVertexAttrib2d");
	glad_glVertexAttrib2dv = (PFNGLVERTEXATTRIB2DVPROC)load("glVertexAttrib2dv");
	glad_glVertexAttrib2f = (PFNGLVERTEXATTRIB2FPROC)load("glVertexAttrib2f");
	glad_glVertexAttrib2fv = (PFNGLVERTEXATTRIB2FVPROC)load("glVertexAttrib2fv");
	glad_glVertexAttrib2s = (PFNGLVERTEXATTRIB2SPROC)load("glVertexAttrib2s");
	glad_glVertexAttrib2sv = (PFNGLVERTEXATTRIB2SVPROC)load("glVertexAttrib2sv");
	glad_glVertexAttrib3d = (PFNGLVERTEXATTRIB3DPROC)load("glVertexAttrib3d");
	glad_glVertexAttrib3dv = (PFNGLVERTEXATTRIB3DVPROC)load("glVertexAttrib3dv");
	glad_glVertexAttrib3f = (PFNGLVERTEXATTRIB3FPROC)load("glVertexAttrib3f");
	glad_glVertexAttrib3fv = (PFNGLVERTEXATTRIB3FVPROC)load("glVertexAttrib3fv");
	glad_glVertexAttrib3s = (PFNGLVERTEXATTRIB3SPROC)load("glVertexAttrib3s");
	glad_glVertexAttrib3sv = (PFNGLVERTEXATTRIB3SVPROC)load("glVertexAttrib3sv");
	glad_glVertexAttrib4Nbv = (PFNGLVERTEXATTRIB4NBVPROC)load("glVertexAttrib4Nbv");
	glad_glVertexAttrib4Niv = (PFNGLVERTEXATTRIB4NIVPROC)load("glVertexAttrib4Niv");
	glad_glVertexAttrib4Nsv = (PFNGLVERTEXATTRIB4NSVPROC)load("glVertexAttrib4Nsv");
	glad_glVertexAttrib4Nub = (PFNGLVERTEXATTRIB4NUBPROC)load("glVertexAttrib4Nub");
	glad_glVertexAttrib4Nubv = (PFNGLVERTEXATTRIB4NUBVPROC)load("glVertexAttrib4Nubv");
	glad_glVertexAttrib4Nuiv = (PFNGLVERTEXATTRIB4NUIVPROC)load("glVertexAttrib4Nuiv");
	glad_glVertexAttrib4Nusv = (PFNGLVERTEXATTRIB4NUSVPROC)load("glVertexAttrib4Nusv");
	glad_glVertexAttrib4bv = (PFNGLVERTEXATTRIB4BVPROC)load("glVertexAttrib4bv");
	glad_glVertexAttrib4d = (PFNGLVERTEXATTRIB4DPROC)load("glVertexAttrib4d");
	glad_glVertexAttrib4dv = (PFNGLVERTEXATTRIB4DVPROC)load("glVertexAttrib4dv");
	glad_glVertexAttrib4f = (PFNGLVERTEXATTRIB4FPROC)load("glVertexAttrib4f");
	glad_glVertexAttrib4fv = (PFNGLVERTEXATTRIB4FVPROC)load("glVertexAttrib4fv");
	glad_glVertexAttrib4iv = (PFNGLVERTEXATTRIB4IVPROC)load("glVertexAttrib4iv");
	glad_glVertexAttrib4s = (PFNGLVERTEXATTRIB4SPROC)load("glVertexAttrib4s");
	glad_glVertexAttrib4sv = (PFNGLVERTEXATTRIB4SVPROC)load("glVertexAttrib4sv");
	glad_glVertexAttrib4ubv = (PFNGLVERTEXATTRIB4UBVPROC)load("glVertexAttrib4ubv");
	glad_glVertexAttrib4uiv = (PFNGLVERTEXATTRIB4UIVPROC)load("glVertexAttrib4uiv");
	glad_glVertexAttrib4usv = (PFNGLVERTEXATTRIB4USVPROC)load("glVertexAttrib4usv");
	glad_glVertexAttribPointer = (PFNGLVERTEXATTRIBPOINTERPROC)load("glVertexAttribPointer");
}
static void load_GL_VERSION_2_1(GLADloadproc load) {
	if(!GLAD_GL_VERSION_2_1) return;
	glad_glUniformMatrix2x3fv = (PFNGLUNIFORMMATRIX2X3FVPROC)load("glUniformMatrix2x3fv");
	glad_glUniformMatrix3x2fv = (PFNGLUNIFORMMATRIX3X2FVPROC)load("glUniformMatrix3x2fv");
	glad_glUniformMatrix2x4fv = (PFNGLUNIFORMMATRIX2X4FVPROC)load("glUniformMatrix2x4fv");
	glad_glUniformMatrix4x2fv = (PFNGLUNIFORMMATRIX4X2FVPROC)load("glUniformMatrix4x2fv");
	glad_glUniformMatrix3x4fv = (PFNGLUNIFORMMATRIX3X4FVPROC)load("glUniformMatrix3x4fv");
	glad_glUniformMatrix4x3fv = (PFNGLUNIFORMMATRIX4X3FVPROC)load("glUniformMatrix4x3fv");
}
static void load_GL_VERSION_3_0(GLADloadproc load) {
	if(!GLAD_GL_VERSION_3_0) return;
	glad_glColorMaski = (PFNGLCOLORMASKIPROC)load("glColorMaski");
	glad_glGetBooleani_v = (PFNGLGETBOOLEANI_VPROC)load("glGetBooleani_v");
	glad_glGetIntegeri_v = (PFNGLGETINTEGERI_VPROC)load("glGetIntegeri_v");
	glad_glEnablei = (PFNGLENABLEIPROC)load("glEnablei");
	glad_glDisablei = (PFNGLDISABLEIPROC)load("glDisablei");
	glad_glIsEnabledi = (PFNGLISENABLEDIPROC)load("glIsEnabledi");
	glad_glBeginTransformFeedback = (PFNGLBEGINTRANSFORMFEEDBACKPROC)load("glBeginTransformFeedback");
	glad_glEndTransformFeedback = (PFNGLENDTRANSFORMFEEDBACKPROC)load("glEndTransformFeedback");
	glad_glBindBufferRange = (PFNGLBINDBUFFERRANGEPROC)load("glBindBufferRange");
	glad_glBindBufferBase = (PFNGLBINDBUFFERBASEPROC)load("glBindBufferBase");
	glad_glTransformFeedbackVaryings = (PFNGLTRANSFORMFEEDBACKVARYINGSPROC)load("glTransformFeedbackVaryings");
	glad_glGetTransformFeedbackVarying = (PFNGLGETTRANSFORMFEEDBACKVARYINGPROC)load("glGetTransformFeedbackVarying");
	glad_glClampColor = (PFNGLCLAMPCOLORPROC)load("glClampColor");
	glad_glBeginConditionalRender = (PFNGLBEGINCONDITIONALRENDERPROC)load("glBeginConditionalRender");
	glad_glEndConditionalRender = (PFNGLENDCONDITIONALRENDERPROC)load("glEndConditionalRender");
	glad_glVertexAttribIPointer = (PFNGLVERTEXATTRIBIPOINTERPROC)load("glVertexAttribIPointer");
	glad_glGetVertexAttribIiv = (PFNGLGETVERTEXATTRIBIIVPROC)load("glGetVertexAttribIiv");
	glad_glGetVertexAttribIuiv = (PFNGLGETVERTEXATTRIBIUIVPROC)load("glGetVertexAttribIuiv");
	glad_glVertexAttribI1i = (PFNGLVERTEXATTRIBI1IPROC)load("glVertexAttribI1i");
	glad_glVertexAttribI2i = (PFNGLVERTEXATTRIBI2IPROC)load("glVertexAttribI2i");
	glad_glVertexAttribI3i = (PFNGLVERTEXATTRIBI3IPROC)load("glVertexAttribI3i");
	glad_glVertexAttribI4i = (PFNGLVERTEXATTRIBI4IPROC)load("glVertexAttribI4i");
	glad_glVertexAttribI1ui = (PFNGLVERTEXATTRIBI1UIPROC)load("glVertexAttribI1ui");
	glad_glVertexAttribI2ui = (PFNGLVERTEXATTRIBI2UIPROC)load("glVertexAttribI2ui");
	glad_glVertexAttribI3ui = (PFNGLVERTEXATTRIBI3UIPROC)load("glVertexAttribI3ui");
	glad_glVertexAttribI4ui = (PFNGLVERTEXATTRIBI4UIPROC)load("glVertexAttribI4ui");
	glad_glVertexAttribI1iv = (PFNGLVERTEXATTRIBI1IVPROC)load("glVertexAttribI1iv");
	glad_glVertexAttribI2iv = (PFNGLVERTEXATTRIBI2IVPROC)load("glVertexAttribI2iv");
	glad_glVertexAttribI3iv = (PFNGLVERTEXATTRIBI3IVPROC)load("glVertexAttribI3iv");
	glad_glVertexAttribI4iv = (PFNGLVERTEXATTRIBI4IVPROC)load("glVertexAttribI4iv");
	glad_glVertexAttribI1uiv = (PFNGLVERTEXATTRIBI1UIVPROC)load("glVertexAttribI1uiv");
	glad_glVertexAttribI2uiv = (PFNGLVERTEXATTRIBI2UIVPROC)load("glVertexAttribI2uiv");
	glad_glVertexAttribI3uiv = (PFNGLVERTEXATTRIBI3UIVPROC)load("glVertexAttribI3uiv");
	glad_glVertexAttribI4uiv = (PFNGLVERTEXATTRIBI4UIVPROC)load("glVertexAttribI4uiv");
	glad_glVertexAttribI4bv = (PFNGLVERTEXATTRIBI4BVPROC)load("glVertexAttribI4bv");
	glad_glVertexAttribI4sv = (PFNGLVERTEXATTRIBI4SVPROC)load("glVertexAttribI4sv");
	glad_glVertexAttribI4ubv = (PFNGLVERTEXATTRIBI4UBVPROC)load("glVertexAttribI4ubv");
	glad_glVertexAttribI4usv = (PFNGLVERTEXATTRIBI4USVPROC)load("glVertexAttribI4usv");
	glad_glGetUniformuiv = (PFNGLGETUNIFORMUIVPROC)load("glGetUniformuiv");
	glad_glBindFragDataLocation = (PFNGLBINDFRAGDATALOCATIONPROC)load("glBindFragDataLocation");
	glad_glGetFragDataLocation = (PFNGLGETFRAGDATALOCATIONPROC)load("glGetFragDataLocation");
	glad_glUniform1ui = (PFNGLUNIFORM1UIPROC)load("glUniform1ui");
	glad_glUniform2ui = (PFNGLUNIFORM2UIPROC)load("glUniform2ui");
	glad_glUniform3ui = (PFNGLUNIFORM3UIPROC)load("glUniform3ui");
	glad_glUniform4ui = (PFNGLUNIFORM4UIPROC)load("glUniform4ui");
	glad_glUniform1uiv = (PFNGLUNIFORM1UIVPROC)load("glUniform1uiv");
	glad_glUniform2uiv = (PFNGLUNIFORM2UIVPROC)load("glUniform2uiv");
	glad_glUniform3uiv = (PFNGLUNIFORM3UIVPROC)load("glUniform3uiv");
	glad_glUniform4uiv = (PFNGLUNIFORM4UIVPROC)load("glUniform4uiv");
	glad_glTexParameterIiv = (PFNGLTEXPARAMETERIIVPROC)load("glTexParameterIiv");
	glad_glTexParameterIuiv = (PFNGLTEXPARAMETERIUIVPROC)load("glTexParameterIuiv");
	glad_glGetTexParameterIiv = (PFNGLGETTEXPARAMETERIIVPROC)load("glGetTexParameterIiv");
	glad_glGetTexParameterIuiv = (PFNGLGETTEXPARAMETERIUIVPROC)load("glGetTexParameterIuiv");
	glad_glClearBufferiv = (PFNGLCLEARBUFFERIVPROC)load("glClearBufferiv");
	glad_glClearBufferuiv = (PFNGLCLEARBUFFERUIVPROC)load("glClearBufferuiv");
	glad_glClearBufferfv = (PFNGLCLEARBUFFERFVPROC)load("glClearBufferfv");
	glad_glClearBufferfi = (PFNGLCLEARBUFFERFIPROC)load("glClearBufferfi");
	glad_glGetStringi = (PFNGLGETSTRINGIPROC)load("glGetStringi");
	glad_glIsRenderbuffer = (PFNGLISRENDERBUFFERPROC)load("glIsRenderbuffer");
	glad_glBindRenderbuffer = (PFNGLBINDRENDERBUFFERPROC)load("glBindRenderbuffer");
	glad_glDeleteRenderbuffers = (PFNGLDELETERENDERBUFFERSPROC)load("glDeleteRenderbuffers");
	glad_glGenRenderbuffers = (PFNGLGENRENDERBUFFERSPROC)load("glGenRenderbuffers");
	glad_glRenderbufferStorage = (PFNGLRENDERBUFFERSTORAGEPROC)load("glRenderbufferStorage");
	glad_glGetRenderbufferParameteriv = (PFNGLGETRENDERBUFFERPARAMETERIVPROC)load("glGetRenderbufferParameteriv");
	glad_glIsFramebuffer = (PFNGLISFRAMEBUFFERPROC)load("glIsFramebuffer");
	glad_glBindFramebuffer = (PFNGLBINDFRAMEBUFFERPROC)load("glBindFramebuffer");
	glad_glDeleteFramebuffers = (PFNGLDELETEFRAMEBUFFERSPROC)load("glDeleteFramebuffers");
	glad_glGenFramebuffers = (PFNGLGENFRAMEBUFFERSPROC)load("glGenFramebuffers");
	glad_glCheckFramebufferStatus = (PFNGLCHECKFRAMEBUFFERSTATUSPROC)load("glCheckFramebufferStatus");
	glad_glFramebufferTexture1D = (PFNGLFRAMEBUFFERTEXTURE1DPROC)load("glFramebufferTexture1D");
	glad_glFramebufferTexture2D = (PFNGLFRAMEBUFFERTEXTURE2DPROC)load("glFramebufferTexture2D");
	glad_glFramebufferTexture3D = (PFNGLFRAMEBUFFERTEXTURE3DPROC)load("glFramebufferTexture3D");
	glad_glFramebufferRenderbuffer = (PFNGLFRAMEBUFFERRENDERBUFFERPROC)load("glFramebufferRenderbuffer");
	glad_glGetFramebufferAttachmentParameteriv = (PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC)load("glGetFramebufferAttachmentParameteriv");
	glad_glGenerateMipmap = (PFNGLGENERATEMIPMAPPROC)load("glGenerateMipmap");
	glad_glBlitFramebuffer = (PFNGLBLITFRAMEBUFFERPROC)load("glBlitFramebuffer");
	glad_glRenderbufferStorageMultisample = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC)load("glRenderbufferStorageMultisample");
	glad_glFramebufferTextureLayer = (PFNGLFRAMEBUFFERTEXTURELAYERPROC)load("glFramebufferTextureLayer");
	glad_glMapBufferRange = (PFNGLMAPBUFFERRANGEPROC)load("glMapBufferRange");
	glad_glFlushMappedBufferRange = (PFNGLFLUSHMAPPEDBUFFERRANGEPROC)load("glFlushMappedBufferRange");
	glad_glBindVertexArray = (PFNGLBINDVERTEXARRAYPROC)load("glBindVertexArray");
	glad_glDeleteVertexArrays = (PFNGLDELETEVERTEXARRAYSPROC)load("glDeleteVertexArrays");
	glad_glGenVertexArrays = (PFNGLGENVERTEXARRAYSPROC)load("glGenVertexArrays");
	glad_glIsVertexArray = (PFNGLISVERTEXARRAYPROC)load("glIsVertexArray");
}
static void load_GL_VERSION_3_1(GLADloadproc load) {
	if(!GLAD_GL_VERSION_3_1) return;
	glad_glDrawArraysInstanced = (PFNGLDRAWARRAYSINSTANCEDPROC)load("glDrawArraysInstanced");
	glad_glDrawElementsInstanced = (PFNGLDRAWELEMENTSINSTANCEDPROC)load("glDrawElementsInstanced");
	glad_glTexBuffer = (PFNGLTEXBUFFERPROC)load("glTexBuffer");
	glad_glPrimitiveRestartIndex = (PFNGLPRIMITIVERESTARTINDEXPROC)load("glPrimitiveRestartIndex");
	glad_glCopyBufferSubData = (PFNGLCOPYBUFFERSUBDATAPROC)load("glCopyBufferSubData");
	glad_glGetUniformIndices = (PFNGLGETUNIFORMINDICESPROC)load("glGetUniformIndices");
	glad_glGetActiveUniformsiv = (PFNGLGETACTIVEUNIFORMSIVPROC)load("glGetActiveUniformsiv");
	glad_glGetActiveUniformName = (PFNGLGETACTIVEUNIFORMNAMEPROC)load("glGetActiveUniformName");
	glad_glGetUniformBlockIndex = (PFNGLGETUNIFORMBLOCKINDEXPROC)load("glGetUniformBlockIndex");
	glad_glGetActiveUniformBlockiv = (PFNGLGETACTIVEUNIFORMBLOCKIVPROC)load("glGetActiveUniformBlockiv");
	glad_glGetActiveUniformBlockName = (PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC)load("glGetActiveUniformBlockName");
	glad_glUniformBlockBinding = (PFNGLUNIFORMBLOCKBINDINGPROC)load("glUniformBlockBinding");
	glad_glBindBufferRange = (PFNGLBINDBUFFERRANGEPROC)load("glBindBufferRange");
	glad_glBindBufferBase = (PFNGLBINDBUFFERBASEPROC)load("glBindBufferBase");
	glad_glGetIntegeri_v = (PFNGLGETINTEGERI_VPROC)load("glGetIntegeri_v");
}
static void load_GL_VERSION_3_2(GLADloadproc load) {
	if(!GLAD_GL_VERSION_3_2) return;
	glad_glDrawElementsBaseVertex = (PFNGLDRAWELEMENTSBASEVERTEXPROC)load("glDrawElementsBaseVertex");
	glad_glDrawRangeElementsBaseVertex = (PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC)load("glDrawRangeElementsBaseVertex");
	glad_glDrawElementsInstancedBaseVertex = (PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC)load("glDrawElementsInstancedBaseVertex");
	glad_glMultiDrawElementsBaseVertex = (PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC)load("glMultiDrawElementsBaseVertex");
	glad_glProvokingVertex = (PFNGLPROVOKINGVERTEXPROC)load("glProvokingVertex");
	glad_glFenceSync = (PFNGLFENCESYNCPROC)load("glFenceSync");
	glad_glIsSync = (PFNGLISSYNCPROC)load("glIsSync");
	glad_glDeleteSync = (PFNGLDELETESYNCPROC)load("glDeleteSync");
	glad_glClientWaitSync = (PFNGLCLIENTWAITSYNCPROC)load("glClientWaitSync");
	glad_glWaitSync = (PFNGLWAITSYNCPROC)load("glWaitSync");
	glad_glGetInteger64v = (PFNGLGETINTEGER64VPROC)load("glGetInteger64v");
	glad_glGetSynciv = (PFNGLGETSYNCIVPROC)load("glGetSynciv");
	glad_glGetInteger64i_v = (PFNGLGETINTEGER64I_VPROC)load("glGetInteger64i_v");
	glad_glGetBufferParameteri64v = (PFNGLGETBUFFERPARAMETERI64VPROC)load("glGetBufferParameteri64v");
	glad_glFramebufferTexture = (PFNGLFRAMEBUFFERTEXTUREPROC)load("glFramebufferTexture");
	glad_glTexImage2DMultisample = (PFNGLTEXIMAGE2DMULTISAMPLEPROC)load("glTexImage2DMultisample");
	glad_glTexImage3DMultisample = (PFNGLTEXIMAGE3DMULTISAMPLEPROC)load("glTexImage3DMultisample");
	glad_glGetMultisamplefv = (PFNGLGETMULTISAMPLEFVPROC)load("glGetMultisamplefv");
	glad_glSampleMaski = (PFNGLSAMPLEMASKIPROC)load("glSampleMaski");
}
static void load_GL_VERSION_3_3(GLADloadproc load) {
	if(!GLAD_GL_VERSION_3_3) return;
	glad_glBindFragDataLocationIndexed = (PFNGLBINDFRAGDATALOCATIONINDEXEDPROC)load("glBindFragDataLocationIndexed");
	glad_glGetFragDataIndex = (PFNGLGETFRAGDATAINDEXPROC)load("glGetFragDataIndex");
	glad_glGenSamplers = (PFNGLGENSAMPLERSPROC)load("glGenSamplers");
	glad_glDeleteSamplers = (PFNGLDELETESAMPLERSPROC)load("glDeleteSamplers");
	glad_glIsSampler = (PFNGLISSAMPLERPROC)load("glIsSampler");
	glad_glBindSampler = (PFNGLBINDSAMPLERPROC)load("glBindSampler");
	glad_glSamplerParameteri = (PFNGLSAMPLERPARAMETERIPROC)load("glSamplerParameteri");
	glad_glSamplerParameteriv = (PFNGLSAMPLERPARAMETERIVPROC)load("glSamplerParameteriv");
	glad_glSamplerParameterf = (PFNGLSAMPLERPARAMETERFPROC)load("glSamplerParameterf");
	glad_glSamplerParameterfv = (PFNGLSAMPLERPARAMETERFVPROC)load("glSamplerParameterfv");
	glad_glSamplerParameterIiv = (PFNGLSAMPLERPARAMETERIIVPROC)load("glSamplerParameterIiv");
	glad_glSamplerParameterIuiv = (PFNGLSAMPLERPARAMETERIUIVPROC)load("glSamplerParameterIuiv");
	glad_glGetSamplerParameteriv = (PFNGLGETSAMPLERPARAMETERIVPROC)load("glGetSamplerParameteriv");
	glad_glGetSamplerParameterIiv = (PFNGLGETSAMPLERPARAMETERIIVPROC)load("glGetSamplerParameterIiv");
	glad_glGetSamplerParameterfv = (PFNGLGETSAMPLERPARAMETERFVPROC)load("glGetSamplerParameterfv");
	glad_glGetSamplerParameterIuiv = (PFNGLGETSAMPLERPARAMETERIUIVPROC)load("glGetSamplerParameterIuiv");
	glad_glQueryCounter = (PFNGLQUERYCOUNTERPROC)load("glQueryCounter");
	glad_glGetQueryObjecti64v = (PFNGLGETQUERYOBJECTI64VPROC)load("glGetQueryObjecti64v");
	glad_glGetQueryObjectui64v = (PFNGLGETQUERYOBJECTUI64VPROC)load("glGetQueryObjectui64v");
	glad_glVertexAttribDivisor = (PFNGLVERTEXATTRIBDIVISORPROC)load("glVertexAttribDivisor");
	glad_glVertexAttribP1ui = (PFNGLVERTEXATTRIBP1UIPROC)load("glVertexAttribP1ui");
	glad_glVertexAttribP1uiv = (PFNGLVERTEXATTRIBP1UIVPROC)load("glVertexAttribP1uiv");
	glad_glVertexAttribP2ui = (PFNGLVERTEXATTRIBP2UIPROC)load("glVertexAttribP2ui");
	glad_glVertexAttribP2uiv = (PFNGLVERTEXATTRIBP2UIVPROC)load("glVertexAttribP2uiv");
	glad_glVertexAttribP3ui = (PFNGLVERTEXATTRIBP3UIPROC)load("glVertexAttribP3ui");
	glad_glVertexAttribP3uiv = (PFNGLVERTEXATTRIBP3UIVPROC)load("glVertexAttribP3uiv");
	glad_glVertexAttribP4ui = (PFNGLVERTEXATTRIBP4UIPROC)load("glVertexAttribP4ui");
	glad_glVertexAttribP4uiv = (PFNGLVERTEXATTRIBP4UIVPROC)load("glVertexAttribP4uiv");
	glad_glVertexP2ui = (PFNGLVERTEXP2UIPROC)load("glVertexP2ui");
	glad_glVertexP2uiv = (PFNGLVERTEXP2UIVPROC)load("glVertexP2uiv");
	glad_glVertexP3ui = (PFNGLVERTEXP3UIPROC)load("glVertexP3ui");
	glad_glVertexP3uiv = (PFNGLVERTEXP3UIVPROC)load("glVertexP3uiv");
	glad_glVertexP4ui = (PFNGLVERTEXP4UIPROC)load("glVertexP4ui");
	glad_glVertexP4uiv = (PFNGLVERTEXP4UIVPROC)load("glVertexP4uiv");
	glad_glTexCoordP1ui = (PFNGLTEXCOORDP1UIPROC)load("glTexCoordP1ui");
	glad_glTexCoordP1uiv = (PFNGLTEXCOORDP1UIVPROC)load("glTexCoordP1uiv");
	glad_glTexCoordP2ui = (PFNGLTEXCOORDP2UIPROC)load("glTexCoordP2ui");
	glad_glTexCoordP2uiv = (PFNGLTEXCOORDP2UIVPROC)load("glTexCoordP2uiv");
	glad_glTexCoordP3ui = (PFNGLTEXCOORDP3UIPROC)load("glTexCoordP3ui");
	glad_glTexCoordP3uiv = (PFNGLTEXCOORDP3UIVPROC)load("glTexCoordP3uiv");
	glad_glTexCoordP4ui = (PFNGLTEXCOORDP4UIPROC)load("glTexCoordP4ui");
	glad_glTexCoordP4uiv = (PFNGLTEXCOORDP4UIVPROC)load("glTexCoordP4uiv");
	glad_glMultiTexCoordP1ui = (PFNGLMULTITEXCOORDP1UIPROC)load("glMultiTexCoordP1ui");
	glad_glMultiTexCoordP1uiv = (PFNGLMULTITEXCOORDP1UIVPROC)load("glMultiTexCoordP1uiv");
	glad_glMultiTexCoordP2ui = (PFNGLMULTITEXCOORDP2UIPROC)load("glMultiTexCoordP2ui");
	glad_glMultiTexCoordP2uiv = (PFNGLMULTITEXCOORDP2UIVPROC)load("glMultiTexCoordP2uiv");
	glad_glMultiTexCoordP3ui = (PFNGLMULTITEXCOORDP3UIPROC)load("glMultiTexCoordP3ui");
	glad_glMultiTexCoordP3uiv = (PFNGLMULTITEXCOORDP3UIVPROC)load("glMultiTexCoordP3uiv");
	glad_glMultiTexCoordP4ui = (PFNGLMULTITEXCOORDP4UIPROC)load("glMultiTexCoordP4ui");
	glad_glMultiTexCoordP4uiv = (PFNGLMULTITEXCOORDP4UIVPROC)load("glMultiTexCoordP4uiv");
	glad_glNormalP3ui = (PFNGLNORMALP3UIPROC)load("glNormalP3ui");
	glad_glNormalP3uiv = (PFNGLNORMALP3UIVPROC)load("glNormalP3uiv");
	glad_glColorP3ui = (PFNGLCOLORP3UIPROC)load("glColorP3ui");
	glad_glColorP3uiv = (PFNGLCOLORP3UIVPROC)load("glColorP3uiv");
	glad_glColorP4ui = (PFNGLCOLORP4UIPROC)load("glColorP4ui");
	glad_glColorP4uiv = (PFNGLCOLORP4UIVPROC)load("glColorP4uiv");
	glad_glSecondaryColorP3ui = (PFNGLSECONDARYCOLORP3UIPROC)load("glSecondaryColorP3ui");
	glad_glSecondaryColorP3uiv = (PFNGLSECONDARYCOLORP3UIVPROC)load("glSecondaryColorP3uiv");
}
static void load_GL_VERSION_4_0(GLADloadproc load) {
	if(!GLAD_GL_VERSION_4_0) return;
	glad_glMinSampleShading = (PFNGLMINSAMPLESHADINGPROC)load("glMinSampleShading");
	glad_glBlendEquationi = (PFNGLBLENDEQUATIONIPROC)load("glBlendEquationi");
	glad_glBlendEquationSeparatei = (PFNGLBLENDEQUATIONSEPARATEIPROC)load("glBlendEquationSeparatei");
	glad_glBlendFunci = (PFNGLBLENDFUNCIPROC)load("glBlendFunci");
	glad_glBlendFuncSeparatei = (PFNGLBLENDFUNCSEPARATEIPROC)load("glBlendFuncSeparatei");
	glad_glDrawArraysIndirect = (PFNGLDRAWARRAYSINDIRECTPROC)load("glDrawArraysIndirect");
	glad_glDrawElementsIndirect = (PFNGLDRAWELEMENTSINDIRECTPROC)load("glDrawElementsIndirect");
	glad_glUniform1d = (PFNGLUNIFORM1DPROC)load("glUniform1d");
	glad_glUniform2d = (PFNGLUNIFORM2DPROC)load("glUniform2d");
	glad_glUniform3d = (PFNGLUNIFORM3DPROC)load("glUniform3d");
	glad_glUniform4d = (PFNGLUNIFORM4DPROC)load("glUniform4d");
	glad_glUniform1dv = (PFNGLUNIFORM1DVPROC)load("glUniform1dv");
	glad_glUniform2dv = (PFNGLUNIFORM2DVPROC)load("glUniform2dv");
	glad_glUniform3dv = (PFNGLUNIFORM3DVPROC)load("glUniform3dv");
	glad_glUniform4dv = (PFNGLUNIFORM4DVPROC)load("glUniform4dv");
	glad_glUniformMatrix2dv = (PFNGLUNIFORMMATRIX2DVPROC)load("glUniformMatrix2dv");
	glad_glUniformMatrix3dv = (PFNGLUNIFORMMATRIX3DVPROC)load("glUniformMatrix3dv");
	glad_glUniformMatrix4dv = (PFNGLUNIFORMMATRIX4DVPROC)load("glUniformMatrix4dv");
	glad_glUniformMatrix2x3dv = (PFNGLUNIFORMMATRIX2X3DVPROC)load("glUniformMatrix2x3dv");
	glad_glUniformMatrix2x4dv = (PFNGLUNIFORMMATRIX2X4DVPROC)load("glUniformMatrix2x4dv");
	glad_glUniformMatrix3x2dv = (PFNGLUNIFORMMATRIX3X2DVPROC)load("glUniformMatrix3x2dv");
	glad_glUniformMatrix3x4dv = (PFNGLUNIFORMMATRIX3X4DVPROC)load("glUniformMatrix3x4dv");
	glad_glUniformMatrix4x2dv = (PFNGLUNIFORMMATRIX4X2DVPROC)load("glUniformMatrix4x2dv");
	glad_glUniformMatrix4x3dv = (PFNGLUNIFORMMATRIX4X3DVPROC)load("glUniformMatrix4x3dv");
	glad_glGetUniformdv = (PFNGLGETUNIFORMDVPROC)load("glGetUniformdv");
	glad_glGetSubroutineUniformLocation = (PFNGLGETSUBROUTINEUNIFORMLOCATIONPROC)load("glGetSubroutineUniformLocation");
	glad_glGetSubroutineIndex = (PFNGLGETSUBROUTINEINDEXPROC)load("glGetSubroutineIndex");
	glad_glGetActiveSubroutineUniformiv = (PFNGLGETACTIVESUBROUTINEUNIFORMIVPROC)load("glGetActiveSubroutineUniformiv");
	glad_glGetActiveSubroutineUniformName = (PFNGLGETACTIVESUBROUTINEUNIFORMNAMEPROC)load("glGetActiveSubroutineUniformName");
	glad_glGetActiveSubroutineName = (PFNGLGETACTIVESUBROUTINENAMEPROC)load("glGetActiveSubroutineName");
	glad_glUniformSubroutinesuiv = (PFNGLUNIFORMSUBROUTINESUIVPROC)load("glUniformSubroutinesuiv");
	glad_glGetUniformSubroutineuiv = (PFNGLGETUNIFORMSUBROUTINEUIVPROC)load("glGetUniformSubroutineuiv");
	glad_glGetProgramStageiv = (PFNGLGETPROGRAMSTAGEIVPROC)load("glGetProgramStageiv");
	glad_glPatchParameteri = (PFNGLPATCHPARAMETERIPROC)load("glPatchParameteri");
	glad_glPatchParameterfv = (PFNGLPATCHPARAMETERFVPROC)load("glPatchParameterfv");
	glad_glBindTransformFeedback = (PFNGLBINDTRANSFORMFEEDBACKPROC)load("glBindTransformFeedback");
	glad_glDeleteTransformFeedbacks = (PFNGLDELETETRANSFORMFEEDBACKSPROC)load("glDeleteTransformFeedbacks");
	glad_glGenTransformFeedbacks = (PFNGLGENTRANSFORMFEEDBACKSPROC)load("glGenTransformFeedbacks");
	glad_glIsTransformFeedback = (PFNGLISTRANSFORMFEEDBACKPROC)load("glIsTransformFeedback");
	glad_glPauseTransformFeedback = (PFNGLPAUSETRANSFORMFEEDBACKPROC)load("glPauseTransformFeedback");
	glad_glResumeTransformFeedback = (PFNGLRESUMETRANSFORMFEEDBACKPROC)load("glResumeTransformFeedback");
	glad_glDrawTransformFeedback = (PFNGLDRAWTRANSFORMFEEDBACKPROC)load("glDrawTransformFeedback");
	glad_glDrawTransformFeedbackStream = (PFNGLDRAWTRANSFORMFEEDBACKSTREAMPROC)load("glDrawTransformFeedbackStream");
	glad_glBeginQueryIndexed = (PFNGLBEGINQUERYINDEXEDPROC)load("glBeginQueryIndexed");
	glad_glEndQueryIndexed = (PFNGLENDQUERYINDEXEDPROC)load("glEndQueryIndexed");
	glad_glGetQueryIndexediv = (PFNGLGETQUERYINDEXEDIVPROC)load("glGetQueryIndexediv");
}
static void load_GL_VERSION_4_1(GLADloadproc load) {
	if(!GLAD_GL_VERSION_4_1) return;
	glad_glReleaseShaderCompiler = (PFNGLRELEASESHADERCOMPILERPROC)load("glReleaseShaderCompiler");
	glad_glShaderBinary = (PFNGLSHADERBINARYPROC)load("glShaderBinary");
	glad_glGetShaderPrecisionFormat = (PFNGLGETSHADERPRECISIONFORMATPROC)load("glGetShaderPrecisionFormat");
	glad_glDepthRangef = (PFNGLDEPTHRANGEFPROC)load("glDepthRangef");
	glad_glClearDepthf = (PFNGLCLEARDEPTHFPROC)load("glClearDepthf");
	glad_glGetProgramBinary = (PFNGLGETPROGRAMBINARYPROC)load("glGetProgramBinary");
	glad_glProgramBinary = (PFNGLPROGRAMBINARYPROC)load("glProgramBinary");
	glad_glProgramParameteri = (PFNGLPROGRAMPARAMETERIPROC)load("glProgramParameteri");
	glad_glUseProgramStages = (PFNGLUSEPROGRAMSTAGESPROC)load("glUseProgramStages");
	glad_glActiveShaderProgram = (PFNGLACTIVESHADERPROGRAMPROC)load("glActiveShaderProgram");
	glad_glCreateShaderProgramv = (PFNGLCREATESHADERPROGRAMVPROC)load("glCreateShaderProgramv");
	glad_glBindProgramPipeline = (PFNGLBINDPROGRAMPIPELINEPROC)load("glBindProgramPipeline");
	glad_glDeleteProgramPipelines = (PFNGLDELETEPROGRAMPIPELINESPROC)load("glDeleteProgramPipelines");
	glad_glGenProgramPipelines = (PFNGLGENPROGRAMPIPELINESPROC)load("glGenProgramPipelines");
	glad_glIsProgramPipeline = (PFNGLISPROGRAMPIPELINEPROC)load("glIsProgramPipeline");
	glad_glGetProgramPipelineiv = (PFNGLGETPROGRAMPIPELINEIVPROC)load("glGetProgramPipelineiv");
	glad_glProgramUniform1i = (PFNGLPROGRAMUNIFORM1IPROC)load("glProgramUniform1i");
	glad_glProgramUniform1iv = (PFNGLPROGRAMUNIFORM1IVPROC)load("glProgramUniform1iv");
	glad_glProgramUniform1f = (PFNGLPROGRAMUNIFORM1FPROC)load("glProgramUniform1f");
	glad_glProgramUniform1fv = (PFNGLPROGRAMUNIFORM1FVPROC)load("glProgramUniform1fv");
	glad_glProgramUniform1d = (PFNGLPROGRAMUNIFORM1DPROC)load("glProgramUniform1d");
	glad_glProgramUniform1dv = (PFNGLPROGRAMUNIFORM1DVPROC)load("glProgramUniform1dv");
	glad_glProgramUniform1ui = (PFNGLPROGRAMUNIFORM1UIPROC)load("glProgramUniform1ui");
	glad_glProgramUniform1uiv = (PFNGLPROGRAMUNIFORM1UIVPROC)load("glProgramUniform1uiv");
	glad_glProgramUniform2i = (PFNGLPROGRAMUNIFORM2IPROC)load("glProgramUniform2i");
	glad_glProgramUniform2iv = (PFNGLPROGRAMUNIFORM2IVPROC)load("glProgramUniform2iv");
	glad_glProgramUniform2f = (PFNGLPROGRAMUNIFORM2FPROC)load("glProgramUniform2f");
	glad_glProgramUniform2fv = (PFNGLPROGRAMUNIFORM2FVPROC)load("glProgramUniform2fv");
	glad_glProgramUniform2d = (PFNGLPROGRAMUNIFORM2DPROC)load("glProgramUniform2d");
	glad_glProgramUniform2dv = (PFNGLPROGRAMUNIFORM2DVPROC)load("glProgramUniform2dv");
	glad_glProgramUniform2ui = (PFNGLPROGRAMUNIFORM2UIPROC)load("glProgramUniform2ui");
	glad_glProgramUniform2uiv = (PFNGLPROGRAMUNIFORM2UIVPROC)load("glProgramUniform2uiv");
	glad_glProgramUniform3i = (PFNGLPROGRAMUNIFORM3IPROC)load("glProgramUniform3i");
	glad_glProgramUniform3iv = (PFNGLPROGRAMUNIFORM3IVPROC)load("glProgramUniform3iv");
	glad_glProgramUniform3f = (PFNGLPROGRAMUNIFORM3FPROC)load("glProgramUniform3f");
	glad_glProgramUniform3fv = (PFNGLPROGRAMUNIFORM3FVPROC)load("glProgramUniform3fv");
	glad_glProgramUniform3d = (PFNGLPROGRAMUNIFORM3DPROC)load("glProgramUniform3d");
	glad_glProgramUniform3dv = (PFNGLPROGRAMUNIFORM3DVPROC)load("glProgramUniform3dv");
	glad_glProgramUniform3ui = (PFNGLPROGRAMUNIFORM3UIPROC)load("glProgramUniform3ui");
	glad_glProgramUniform3uiv = (PFNGLPROGRAMUNIFORM3UIVPROC)load("glProgramUniform3uiv");
	glad_glProgramUniform4i = (PFNGLPROGRAMUNIFORM4IPROC)load("glProgramUniform4i");
	glad_glProgramUniform4iv = (PFNGLPROGRAMUNIFORM4IVPROC)load("glProgramUniform4iv");
	glad_glProgramUniform4f = (PFNGLPROGRAMUNIFORM4FPROC)load("glProgramUniform4f");
	glad_glProgramUniform4fv = (PFNGLPROGRAMUNIFORM4FVPROC)load("glProgramUniform4fv");
	glad_glProgramUniform4d = (PFNGLPROGRAMUNIFORM4DPROC)load("glProgramUniform4d");
	glad_glProgramUniform4dv = (PFNGLPROGRAMUNIFORM4DVPROC)load("glProgramUniform4dv");
	glad_glProgramUniform4ui = (PFNGLPROGRAMUNIFORM4UIPROC)load("glProgramUniform4ui");
	glad_glProgramUniform4uiv = (PFNGLPROGRAMUNIFORM4UIVPROC)load("glProgramUniform4uiv");
	glad_glProgramUniformMatrix2fv = (PFNGLPROGRAMUNIFORMMATRIX2FVPROC)load("glProgramUniformMatrix2fv");
	glad_glProgramUniformMatrix3fv = (PFNGLPROGRAMUNIFORMMATRIX3FVPROC)load("glProgramUniformMatrix3fv");
	glad_glProgramUniformMatrix4fv = (PFNGLPROGRAMUNIFORMMATRIX4FVPROC)load("glProgramUniformMatrix4fv");
	glad_glProgramUniformMatrix2dv = (PFNGLPROGRAMUNIFORMMATRIX2DVPROC)load("glProgramUniformMatrix2dv");
	glad_glProgramUniformMatrix3dv = (PFNGLPROGRAMUNIFORMMATRIX3DVPROC)load("glProgramUniformMatrix3dv");
	glad_glProgramUniformMatrix4dv = (PFNGLPROGRAMUNIFORMMATRIX4DVPROC)load("glProgramUniformMatrix4dv");
	glad_glProgramUniformMatrix2x3fv = (PFNGLPROGRAMUNIFORMMATRIX2X3FVPROC)load("glProgramUniformMatrix2x3fv");
	glad_glProgramUniformMatrix3x2fv = (PFNGLPROGRAMUNIFORMMATRIX3X2FVPROC)load("glProgramUniformMatrix3x2fv");
	glad_glProgramUniformMatrix2x4fv = (PFNGLPROGRAMUNIFORMMATRIX2X4FVPROC)load("glProgramUniformMatrix2x4fv");
	glad_glProgramUniformMatrix4x2fv = (PFNGLPROGRAMUNIFORMMATRIX4X2FVPROC)load("glProgramUniformMatrix4x2fv");
	glad_glProgramUniformMatrix3x4fv = (PFNGLPROGRAMUNIFORMMATRIX3X4FVPROC)load("glProgramUniformMatrix3x4fv");
	glad_glProgramUniformMatrix4x3fv = (PFNGLPROGRAMUNIFORMMATRIX4X3FVPROC)load("glProgramUniformMatrix4x3fv");
	glad_glProgramUniformMatrix2x3dv = (PFNGLPROGRAMUNIFORMMATRIX2X3DVPROC)load("glProgramUniformMatrix2x3dv");
	glad_glProgramUniformMatrix3x2dv = (PFNGLPROGRAMUNIFORMMATRIX3X2DVPROC)load("glProgramUniformMatrix3x2dv");
	glad_glProgramUniformMatrix2x4dv = (PFNGLPROGRAMUNIFORMMATRIX2X4DVPROC)load("glProgramUniformMatrix2x4dv");
	glad_glProgramUniformMatrix4x2dv = (PFNGLPROGRAMUNIFORMMATRIX4X2DVPROC)load("glProgramUniformMatrix4x2dv");
	glad_glProgramUniformMatrix3x4dv = (PFNGLPROGRAMUNIFORMMATRIX3X4DVPROC)load("glProgramUniformMatrix3x4dv");
	glad_glProgramUniformMatrix4x3dv = (PFNGLPROGRAMUNIFORMMATRIX4X3DVPROC)load("glProgramUniformMatrix4x3dv");
	glad_glValidateProgramPipeline = (PFNGLVALIDATEPROGRAMPIPELINEPROC)load("glValidateProgramPipeline");
	glad_glGetProgramPipelineInfoLog = (PFNGLGETPROGRAMPIPELINEINFOLOGPROC)load("glGetProgramPipelineInfoLog");
	glad_glVertexAttribL1d = (PFNGLVERTEXATTRIBL1DPROC)load("glVertexAttribL1d");
	glad_glVertexAttribL2d = (PFNGLVERTEXATTRIBL2DPROC)load("glVertexAttribL2d");
	glad_glVertexAttribL3d = (PFNGLVERTEXATTRIBL3DPROC)load("glVertexAttribL3d");
	glad_glVertexAttribL4d = (PFNGLVERTEXATTRIBL4DPROC)load("glVertexAttribL4d");
	glad_glVertexAttribL1dv = (PFNGLVERTEXATTRIBL1DVPROC)load("glVertexAttribL1dv");
	glad_glVertexAttribL2dv = (PFNGLVERTEXATTRIBL2DVPROC)load("glVertexAttribL2dv");
	glad_glVertexAttribL3dv = (PFNGLVERTEXATTRIBL3DVPROC)load("glVertexAttribL3dv");
	glad_glVertexAttribL4dv = (PFNGLVERTEXATTRIBL4DVPROC)load("glVertexAttribL4dv");
	glad_glVertexAttribLPointer = (PFNGLVERTEXATTRIBLPOINTERPROC)load("glVertexAttribLPointer");
	glad_glGetVertexAttribLdv = (PFNGLGETVERTEXATTRIBLDVPROC)load("glGetVertexAttribLdv");
	glad_glViewportArrayv = (PFNGLVIEWPORTARRAYVPROC)load("glViewportArrayv");
	glad_glViewportIndexedf = (PFNGLVIEWPORTINDEXEDFPROC)load("glViewportIndexedf");
	glad_glViewportIndexedfv = (PFNGLVIEWPORTINDEXEDFVPROC)load("glViewportIndexedfv");
	glad_glScissorArrayv = (PFNGLSCISSORARRAYVPROC)load("glScissorArrayv");
	glad_glScissorIndexed = (PFNGLSCISSORINDEXEDPROC)load("glScissorIndexed");
	glad_glScissorIndexedv = (PFNGLSCISSORINDEXEDVPROC)load("glScissorIndexedv");
	glad_glDepthRangeArrayv = (PFNGLDEPTHRANGEARRAYVPROC)load("glDepthRangeArrayv");
	glad_glDepthRangeIndexed = (PFNGLDEPTHRANGEINDEXEDPROC)load("glDepthRangeIndexed");
	glad_glGetFloati_v = (PFNGLGETFLOATI_VPROC)load("glGetFloati_v");
	glad_glGetDoublei_v = (PFNGLGETDOUBLEI_VPROC)load("glGetDoublei_v");
}
static void load_GL_VERSION_4_2(GLADloadproc load) {
	if(!GLAD_GL_VERSION_4_2) return;
	glad_glDrawArraysInstancedBaseInstance = (PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEPROC)load("glDrawArraysInstancedBaseInstance");
	glad_glDrawElementsInstancedBaseInstance = (PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEPROC)load("glDrawElementsInstancedBaseInstance");
	glad_glDrawElementsInstancedBaseVertexBaseInstance = (PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEPROC)load("glDrawElementsInstancedBaseVertexBaseInstance");
	glad_glGetInternalformativ = (PFNGLGETINTERNALFORMATIVPROC)load("glGetInternalformativ");
	glad_glGetActiveAtomicCounterBufferiv = (PFNGLGETACTIVEATOMICCOUNTERBUFFERIVPROC)load("glGetActiveAtomicCounterBufferiv");
	glad_glBindImageTexture = (PFNGLBINDIMAGETEXTUREPROC)load("glBindImageTexture");
	glad_glMemoryBarrier = (PFNGLMEMORYBARRIERPROC)load("glMemoryBarrier");
	glad_glTexStorage1D = (PFNGLTEXSTORAGE1DPROC)load("glTexStorage1D");
	glad_glTexStorage2D = (PFNGLTEXSTORAGE2DPROC)load("glTexStorage2D");
	glad_glTexStorage3D = (PFNGLTEXSTORAGE3DPROC)load("glTexStorage3D");
	glad_glDrawTransformFeedbackInstanced = (PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDPROC)load("glDrawTransformFeedbackInstanced");
	glad_glDrawTransformFeedbackStreamInstanced = (PFNGLDRAWTRANSFORMFEEDBACKSTREAMINSTANCEDPROC)load("glDrawTransformFeedbackStreamInstanced");
}
static void load_GL_VERSION_4_3(GLADloadproc load) {
	if(!GLAD_GL_VERSION_4_3) return;
	glad_glClearBufferData = (PFNGLCLEARBUFFERDATAPROC)load("glClearBufferData");
	glad_glClearBufferSubData = (PFNGLCLEARBUFFERSUBDATAPROC)load("glClearBufferSubData");
	glad_glDispatchCompute = (PFNGLDISPATCHCOMPUTEPROC)load("glDispatchCompute");
	glad_glDispatchComputeIndirect = (PFNGLDISPATCHCOMPUTEINDIRECTPROC)load("glDispatchComputeIndirect");
	glad_glCopyImageSubData = (PFNGLCOPYIMAGESUBDATAPROC)load("glCopyImageSubData");
	glad_glFramebufferParameteri = (PFNGLFRAMEBUFFERPARAMETERIPROC)load("glFramebufferParameteri");
	glad_glGetFramebufferParameteriv = (PFNGLGETFRAMEBUFFERPARAMETERIVPROC)load("glGetFramebufferParameteriv");
	glad_glGetInternalformati64v = (PFNGLGETINTERNALFORMATI64VPROC)load("glGetInternalformati64v");
	glad_glInvalidateTexSubImage = (PFNGLINVALIDATETEXSUBIMAGEPROC)load("glInvalidateTexSubImage");
	glad_glInvalidateTexImage = (PFNGLINVALIDATETEXIMAGEPROC)load("glInvalidateTexImage");
	glad_glInvalidateBufferSubData = (PFNGLINVALIDATEBUFFERSUBDATAPROC)load("glInvalidateBufferSubData");
	glad_glInvalidateBufferData = (PFNGLINVALIDATEBUFFERDATAPROC)load("glInvalidateBufferData");
	glad_glInvalidateFramebuffer = (PFNGLINVALIDATEFRAMEBUFFERPROC)load("glInvalidateFramebuffer");
	glad_glInvalidateSubFramebuffer = (PFNGLINVALIDATESUBFRAMEBUFFERPROC)load("glInvalidateSubFramebuffer");
	glad_glMultiDrawArraysIndirect = (PFNGLMULTIDRAWARRAYSINDIRECTPROC)load("glMultiDrawArraysIndirect");
	glad_glMultiDrawElementsIndirect = (PFNGLMULTIDRAWELEMENTSINDIRECTPROC)load("glMultiDrawElementsIndirect");
	glad_glGetProgramInterfaceiv = (PFNGLGETPROGRAMINTERFACEIVPROC)load("glGetProgramInterfaceiv");
	glad_glGetProgramResourceIndex = (PFNGLGETPROGRAMRESOURCEINDEXPROC)load("glGetProgramResourceIndex");
	glad_glGetProgramResourceName = (PFNGLGETPROGRAMRESOURCENAMEPROC)load("glGetProgramResourceName");
	glad_glGetProgramResourceiv = (PFNGLGETPROGRAMRESOURCEIVPROC)load("glGetProgramResourceiv");
	glad_glGetProgramResourceLocation = (PFNGLGETPROGRAMRESOURCELOCATIONPROC)load("glGetProgramResourceLocation");
	glad_glGetProgramResourceLocationIndex = (PFNGLGETPROGRAMRESOURCELOCATIONINDEXPROC)load("glGetProgramResourceLocationIndex");
	glad_glShaderStorageBlockBinding = (PFNGLSHADERSTORAGEBLOCKBINDINGPROC)load("glShaderStorageBlockBinding");
	glad_glTexBufferRange = (PFNGLTEXBUFFERRANGEPROC)load("glTexBufferRange");
	glad_glTexStorage2DMultisample = (PFNGLTEXSTORAGE2DMULTISAMPLEPROC)load("glTexStorage2DMultisample");
	glad_glTexStorage3DMultisample = (PFNGLTEXSTORAGE3DMULTISAMPLEPROC)load("glTexStorage3DMultisample");
	glad_glTextureView = (PFNGLTEXTUREVIEWPROC)load("glTextureView");
	glad_glBindVertexBuffer = (PFNGLBINDVERTEXBUFFERPROC)load("glBindVertexBuffer");
	glad_glVertexAttribFormat = (PFNGLVERTEXATTRIBFORMATPROC)load("glVertexAttribFormat");
	glad_glVertexAttribIFormat = (PFNGLVERTEXATTRIBIFORMATPROC)load("glVertexAttribIFormat");
	glad_glVertexAttribLFormat = (PFNGLVERTEXATTRIBLFORMATPROC)load("glVertexAttribLFormat");
	glad_glVertexAttribBinding = (PFNGLVERTEXATTRIBBINDINGPROC)load("glVertexAttribBinding");
	glad_glVertexBindingDivisor = (PFNGLVERTEXBINDINGDIVISORPROC)load("glVertexBindingDivisor");
	glad_glDebugMessageControl = (PFNGLDEBUGMESSAGECONTROLPROC)load("glDebugMessageControl");
	glad_glDebugMessageInsert = (PFNGLDEBUGMESSAGEINSERTPROC)load("glDebugMessageInsert");
	glad_glDebugMessageCallback = (PFNGLDEBUGMESSAGECALLBACKPROC)load("glDebugMessageCallback");
	glad_glGetDebugMessageLog = (PFNGLGETDEBUGMESSAGELOGPROC)load("glGetDebugMessageLog");
	glad_glPushDebugGroup = (PFNGLPUSHDEBUGGROUPPROC)load("glPushDebugGroup");
	glad_glPopDebugGroup = (PFNGLPOPDEBUGGROUPPROC)load("glPopDebugGroup");
	glad_glObjectLabel = (PFNGLOBJECTLABELPROC)load("glObjectLabel");
	glad_glGetObjectLabel = (PFNGLGETOBJECTLABELPROC)load("glGetObjectLabel");
	glad_glObjectPtrLabel = (PFNGLOBJECTPTRLABELPROC)load("glObjectPtrLabel");
	glad_glGetObjectPtrLabel = (PFNGLGETOBJECTPTRLABELPROC)load("glGetObjectPtrLabel");
}
static void load_GL_VERSION_4_4(GLADloadproc load) {
	if(!GLAD_GL_VERSION_4_4) return;
	glad_glBufferStorage = (PFNGLBUFFERSTORAGEPROC)load("glBufferStorage");
	glad_glClearTexImage = (PFNGLCLEARTEXIMAGEPROC)load("glClearTexImage");
	glad_glClearTexSubImage = (PFNGLCLEARTEXSUBIMAGEPROC)load("glClearTexSubImage");
	glad_glBindBuffersBase = (PFNGLBINDBUFFERSBASEPROC)load("glBindBuffersBase");
	glad_glBindBuffersRange = (PFNGLBINDBUFFERSRANGEPROC)load("glBindBuffersRange");
	glad_glBindTextures = (PFNGLBINDTEXTURESPROC)load("glBindTextures");
	glad_glBindSamplers = (PFNGLBINDSAMPLERSPROC)load("glBindSamplers");
	glad_glBindImageTextures = (PFNGLBINDIMAGETEXTURESPROC)load("glBindImageTextures");
	glad_glBindVertexBuffers = (PFNGLBINDVERTEXBUFFERSPROC)load("glBindVertexBuffers");
}
static void load_GL_VERSION_4_5(GLADloadproc load) {
	if(!GLAD_GL_VERSION_4_5) return;
	glad_glClipControl = (PFNGLCLIPCONTROLPROC)load("glClipControl");
	glad_glCreateTransformFeedbacks = (PFNGLCREATETRANSFORMFEEDBACKSPROC)load("glCreateTransformFeedbacks");
	glad_glTransformFeedbackBufferBase = (PFNGLTRANSFORMFEEDBACKBUFFERBASEPROC)load("glTransformFeedbackBufferBase");
	glad_glTransformFeedbackBufferRange = (PFNGLTRANSFORMFEEDBACKBUFFERRANGEPROC)load("glTransformFeedbackBufferRange");
	glad_glGetTransformFeedbackiv = (PFNGLGETTRANSFORMFEEDBACKIVPROC)load("glGetTransformFeedbackiv");
	glad_glGetTransformFeedbacki_v = (PFNGLGETTRANSFORMFEEDBACKI_VPROC)load("glGetTransformFeedbacki_v");
	glad_glGetTransformFeedbacki64_v = (PFNGLGETTRANSFORMFEEDBACKI64_VPROC)load("glGetTransformFeedbacki64_v");
	glad_glCreateBuffers = (PFNGLCREATEBUFFERSPROC)load("glCreateBuffers");
	glad_glNamedBufferStorage = (PFNGLNAMEDBUFFERSTORAGEPROC)load("glNamedBufferStorage");
	glad_glNamedBufferData = (PFNGLNAMEDBUFFERDATAPROC)load("glNamedBufferData");
	glad_glNamedBufferSubData = (PFNGLNAMEDBUFFERSUBDATAPROC)load("glNamedBufferSubData");
	glad_glCopyNamedBufferSubData = (PFNGLCOPYNAMEDBUFFERSUBDATAPROC)load("glCopyNamedBufferSubData");
	glad_glClearNamedBufferData = (PFNGLCLEARNAMEDBUFFERDATAPROC)load("glClearNamedBufferData");
	glad_glClearNamedBufferSubData = (PFNGLCLEARNAMEDBUFFERSUBDATAPROC)load("glClearNamedBufferSubData");
	glad_glMapNamedBuffer = (PFNGLMAPNAMEDBUFFERPROC)load("glMapNamedBuffer");
	glad_glMapNamedBufferRange = (PFNGLMAPNAMEDBUFFERRANGEPROC)load("glMapNamedBufferRange");
	glad_glUnmapNamedBuffer = (PFNGLUNMAPNAMEDBUFFERPROC)load("glUnmapNamedBuffer");
	glad_glFlushMappedNamedBufferRange = (PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEPROC)load("glFlushMappedNamedBufferRange");
	glad_glGetNamedBufferParameteriv = (PFNGLGETNAMEDBUFFERPARAMETERIVPROC)load("glGetNamedBufferParameteriv");
	glad_glGetNamedBufferParameteri64v = (PFNGLGETNAMEDBUFFERPARAMETERI64VPROC)load("glGetNamedBufferParameteri64v");
	glad_glGetNamedBufferPointerv = (PFNGLGETNAMEDBUFFERPOINTERVPROC)load("glGetNamedBufferPointerv");
	glad_glGetNamedBufferSubData = (PFNGLGETNAMEDBUFFERSUBDATAPROC)load("glGetNamedBufferSubData");
	glad_glCreateFramebuffers = (PFNGLCREATEFRAMEBUFFERSPROC)load("glCreateFramebuffers");
	glad_glNamedFramebufferRenderbuffer = (PFNGLNAMEDFRAMEBUFFERRENDERBUFFERPROC)load("glNamedFramebufferRenderbuffer");
	glad_glNamedFramebufferParameteri = (PFNGLNAMEDFRAMEBUFFERPARAMETERIPROC)load("glNamedFramebufferParameteri");
	glad_glNamedFramebufferTexture = (PFNGLNAMEDFRAMEBUFFERTEXTUREPROC)load("glNamedFramebufferTexture");
	glad_glNamedFramebufferTextureLayer = (PFNGLNAMEDFRAMEBUFFERTEXTURELAYERPROC)load("glNamedFramebufferTextureLayer");
	glad_glNamedFramebufferDrawBuffer = (PFNGLNAMEDFRAMEBUFFERDRAWBUFFERPROC)load("glNamedFramebufferDrawBuffer");
	glad_glNamedFramebufferDrawBuffers = (PFNGLNAMEDFRAMEBUFFERDRAWBUFFERSPROC)load("glNamedFramebufferDrawBuffers");
	glad_glNamedFramebufferReadBuffer = (PFNGLNAMEDFRAMEBUFFERREADBUFFERPROC)load("glNamedFramebufferReadBuffer");
	glad_glInvalidateNamedFramebufferData = (PFNGLINVALIDATENAMEDFRAMEBUFFERDATAPROC)load("glInvalidateNamedFramebufferData");
	glad_glInvalidateNamedFramebufferSubData = (PFNGLINVALIDATENAMEDFRAMEBUFFERSUBDATAPROC)load("glInvalidateNamedFramebufferSubData");
	glad_glClearNamedFramebufferiv = (PFNGLCLEARNAMEDFRAMEBUFFERIVPROC)load("glClearNamedFramebufferiv");
	glad_glClearNamedFramebufferuiv = (PFNGLCLEARNAMEDFRAMEBUFFERUIVPROC)load("glClearNamedFramebufferuiv");
	glad_glClearNamedFramebufferfv = (PFNGLCLEARNAMEDFRAMEBUFFERFVPROC)load("glClearNamedFramebufferfv");
	glad_glClearNamedFramebufferfi = (PFNGLCLEARNAMEDFRAMEBUFFERFIPROC)load("glClearNamedFramebufferfi");
	glad_glBlitNamedFramebuffer = (PFNGLBLITNAMEDFRAMEBUFFERPROC)load("glBlitNamedFramebuffer");
	glad_glCheckNamedFramebufferStatus = (PFNGLCHECKNAMEDFRAMEBUFFERSTATUSPROC)load("glCheckNamedFramebufferStatus");
	glad_glGetNamedFramebufferParameteriv = (PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVPROC)load("glGetNamedFramebufferParameteriv");
	glad_glGetNamedFramebufferAttachmentParameteriv = (PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVPROC)load("glGetNamedFramebufferAttachmentParameteriv");
	glad_glCreateRenderbuffers = (PFNGLCREATERENDERBUFFERSPROC)load("glCreateRenderbuffers");
	glad_glNamedRenderbufferStorage = (PFNGLNAMEDRENDERBUFFERSTORAGEPROC)load("glNamedRenderbufferStorage");
	glad_glNamedRenderbufferStorageMultisample = (PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEPROC)load("glNamedRenderbufferStorageMultisample");
	glad_glGetNamedRenderbufferParameteriv = (PFNGLGETNAMEDRENDERBUFFERPARAMETERIVPROC)load("glGetNamedRenderbufferParameteriv");
	glad_glCreateTextures = (PFNGLCREATETEXTURESPROC)load("glCreateTextures");
	glad_glTextureBuffer = (PFNGLTEXTUREBUFFERPROC)load("glTextureBuffer");
	glad_glTextureBufferRange = (PFNGLTEXTUREBUFFERRANGEPROC)load("glTextureBufferRange");
	glad_glTextureStorage1D = (PFNGLTEXTURESTORAGE1DPROC)load("glTextureStorage1D");
	glad_glTextureStorage2D = (PFNGLTEXTURESTORAGE2DPROC)load("glTextureStorage2D");
	glad_glTextureStorage3D = (PFNGLTEXTURESTORAGE3DPROC)load("glTextureStorage3D");
	glad_glTextureStorage2DMultisample = (PFNGLTEXTURESTORAGE2DMULTISAMPLEPROC)load("glTextureStorage2DMultisample");
	glad_glTextureStorage3DMultisample = (PFNGLTEXTURESTORAGE3DMULTISAMPLEPROC)load("glTextureStorage3DMultisample");
	glad_glTextureSubImage1D = (PFNGLTEXTURESUBIMAGE1DPROC)load("glTextureSubImage1D");
	glad_glTextureSubImage2D = (PFNGLTEXTURESUBIMAGE2DPROC)load("glTextureSubImage2D");
	glad_glTextureSubImage3D = (PFNGLTEXTURESUBIMAGE3DPROC)load("glTextureSubImage3D");
	glad_glCompressedTextureSubImage1D = (PFNGLCOMPRESSEDTEXTURESUBIMAGE1DPROC)load("glCompressedTextureSubImage1D");
	glad_glCompressedTextureSubImage2D = (PFNGLCOMPRESSEDTEXTURESUBIMAGE2DPROC)load("glCompressedTextureSubImage2D");
	glad_glCompressedTextureSubImage3D = (PFNGLCOMPRESSEDTEXTURESUBIMAGE3DPROC)load("glCompressedTextureSubImage3D");
	glad_glCopyTextureSubImage1D = (PFNGLCOPYTEXTURESUBIMAGE1DPROC)load("glCopyTextureSubImage1D");
	glad_glCopyTextureSubImage2D = (PFNGLCOPYTEXTURESUBIMAGE2DPROC)load("glCopyTextureSubImage2D");
	glad_glCopyTextureSubImage3D = (PFNGLCOPYTEXTURESUBIMAGE3DPROC)load("glCopyTextureSubImage3D");
	glad_glTextureParameterf = (PFNGLTEXTUREPARAMETERFPROC)load("glTextureParameterf");
	glad_glTextureParameterfv = (PFNGLTEXTUREPARAMETERFVPROC)load("glTextureParameterfv");
	glad_glTextureParameteri = (PFNGLTEXTUREPARAMETERIPROC)load("glTextureParameteri");
	glad_glTextureParameterIiv = (PFNGLTEXTUREPARAMETERIIVPROC)load("glTextureParameterIiv");
	glad_glTextureParameterIuiv = (PFNGLTEXTUREPARAMETERIUIVPROC)load("glTextureParameterIuiv");
	glad_glTextureParameteriv = (PFNGLTEXTUREPARAMETERIVPROC)load("glTextureParameteriv");
	glad_glGenerateTextureMipmap = (PFNGLGENERATETEXTUREMIPMAPPROC)load("glGenerateTextureMipmap");
	glad_glBindTextureUnit = (PFNGLBINDTEXTUREUNITPROC)load("glBindTextureUnit");
	glad_glGetTextureImage = (PFNGLGETTEXTUREIMAGEPROC)load("glGetTextureImage");
	glad_glGetCompressedTextureImage = (PFNGLGETCOMPRESSEDTEXTUREIMAGEPROC)load("glGetCompressedTextureImage");
	glad_glGetTextureLevelParameterfv = (PFNGLGETTEXTURELEVELPARAMETERFVPROC)load("glGetTextureLevelParameterfv");
	glad_glGetTextureLevelParameteriv = (PFNGLGETTEXTURELEVELPARAMETERIVPROC)load("glGetTextureLevelParameteriv");
	glad_glGetTextureParameterfv = (PFNGLGETTEXTUREPARAMETERFVPROC)load("glGetTextureParameterfv");
	glad_glGetTextureParameterIiv = (PFNGLGETTEXTUREPARAMETERIIVPROC)load("glGetTextureParameterIiv");
	glad_glGetTextureParameterIuiv = (PFNGLGETTEXTUREPARAMETERIUIVPROC)load("glGetTextureParameterIuiv");
	glad_glGetTextureParameteriv = (PFNGLGETTEXTUREPARAMETERIVPROC)load("glGetTextureParameteriv");
	glad_glCreateVertexArrays = (PFNGLCREATEVERTEXARRAYSPROC)load("glCreateVertexArrays");
	glad_glDisableVertexArrayAttrib = (PFNGLDISABLEVERTEXARRAYATTRIBPROC)load("glDisableVertexArrayAttrib");
	glad_glEnableVertexArrayAttrib = (PFNGLENABLEVERTEXARRAYATTRIBPROC)load("glEnableVertexArrayAttrib");
	glad_glVertexArrayElementBuffer = (PFNGLVERTEXARRAYELEMENTBUFFERPROC)load("glVertexArrayElementBuffer");
	glad_glVertexArrayVertexBuffer = (PFNGLVERTEXARRAYVERTEXBUFFERPROC)load("glVertexArrayVertexBuffer");
	glad_glVertexArrayVertexBuffers = (PFNGLVERTEXARRAYVERTEXBUFFERSPROC)load("glVertexArrayVertexBuffers");
	glad_glVertexArrayAttribBinding = (PFNGLVERTEXARRAYATTRIBBINDINGPROC)load("glVertexArrayAttribBinding");
	glad_glVertexArrayAttribFormat = (PFNGLVERTEXARRAYATTRIBFORMATPROC)load("glVertexArrayAttribFormat");
	glad_glVertexArrayAttribIFormat = (PFNGLVERTEXARRAYATTRIBIFORMATPROC)load("glVertexArrayAttribIFormat");
	glad_glVertexArrayAttribLFormat = (PFNGLVERTEXARRAYATTRIBLFORMATPROC)load("glVertexArrayAttribLFormat");
	glad_glVertexArrayBindingDivisor = (PFNGLVERTEXARRAYBINDINGDIVISORPROC)load("glVertexArrayBindingDivisor");
	glad_glGetVertexArrayiv = (PFNGLGETVERTEXARRAYIVPROC)load("glGetVertexArrayiv");
	glad_glGetVertexArrayIndexediv = (PFNGLGETVERTEXARRAYINDEXEDIVPROC)load("glGetVertexArrayIndexediv");
	glad_glGetVertexArrayIndexed64iv = (PFNGLGETVERTEXARRAYINDEXED64IVPROC)load("glGetVertexArrayIndexed64iv");
	glad_glCreateSamplers = (PFNGLCREATESAMPLERSPROC)load("glCreateSamplers");
	glad_glCreateProgramPipelines = (PFNGLCREATEPROGRAMPIPELINESPROC)load("glCreateProgramPipelines");
	glad_glCreateQueries = (PFNGLCREATEQUERIESPROC)load("glCreateQueries");
	glad_glGetQueryBufferObjecti64v = (PFNGLGETQUERYBUFFEROBJECTI64VPROC)load("glGetQueryBufferObjecti64v");
	glad_glGetQueryBufferObjectiv = (PFNGLGETQUERYBUFFEROBJECTIVPROC)load("glGetQueryBufferObjectiv");
	glad_glGetQueryBufferObjectui64v = (PFNGLGETQUERYBUFFEROBJECTUI64VPROC)load("glGetQueryBufferObjectui64v");
	glad_glGetQueryBufferObjectuiv = (PFNGLGETQUERYBUFFEROBJECTUIVPROC)load("glGetQueryBufferObjectuiv");
	glad_glMemoryBarrierByRegion = (PFNGLMEMORYBARRIERBYREGIONPROC)load("glMemoryBarrierByRegion");
	glad_glGetTextureSubImage = (PFNGLGETTEXTURESUBIMAGEPROC)load("glGetTextureSubImage");
	glad_glGetCompressedTextureSubImage = (PFNGLGETCOMPRESSEDTEXTURESUBIMAGEPROC)load("glGetCompressedTextureSubImage");
	glad_glGetGraphicsResetStatus = (PFNGLGETGRAPHICSRESETSTATUSPROC)load("glGetGraphicsResetStatus");
	glad_glGetnCompressedTexImage = (PFNGLGETNCOMPRESSEDTEXIMAGEPROC)load("glGetnCompressedTexImage");
	glad_glGetnTexImage = (PFNGLGETNTEXIMAGEPROC)load("glGetnTexImage");
	glad_glGetnUniformdv = (PFNGLGETNUNIFORMDVPROC)load("glGetnUniformdv");
	glad_glGetnUniformfv = (PFNGLGETNUNIFORMFVPROC)load("glGetnUniformfv");
	glad_glGetnUniformiv = (PFNGLGETNUNIFORMIVPROC)load("glGetnUniformiv");
	glad_glGetnUniformuiv = (PFNGLGETNUNIFORMUIVPROC)load("glGetnUniformuiv");
	glad_glReadnPixels = (PFNGLREADNPIXELSPROC)load("glReadnPixels");
	glad_glGetnMapdv = (PFNGLGETNMAPDVPROC)load("glGetnMapdv");
	glad_glGetnMapfv = (PFNGLGETNMAPFVPROC)load("glGetnMapfv");
	glad_glGetnMapiv = (PFNGLGETNMAPIVPROC)load("glGetnMapiv");
	glad_glGetnPixelMapfv = (PFNGLGETNPIXELMAPFVPROC)load("glGetnPixelMapfv");
	glad_glGetnPixelMapuiv = (PFNGLGETNPIXELMAPUIVPROC)load("glGetnPixelMapuiv");
	glad_glGetnPixelMapusv = (PFNGLGETNPIXELMAPUSVPROC)load("glGetnPixelMapusv");
	glad_glGetnPolygonStipple = (PFNGLGETNPOLYGONSTIPPLEPROC)load("glGetnPolygonStipple");
	glad_glGetnColorTable = (PFNGLGETNCOLORTABLEPROC)load("glGetnColorTable");
	glad_glGetnConvolutionFilter = (PFNGLGETNCONVOLUTIONFILTERPROC)load("glGetnConvolutionFilter");
	glad_glGetnSeparableFilter = (PFNGLGETNSEPARABLEFILTERPROC)load("glGetnSeparableFilter");
	glad_glGetnHistogram = (PFNGLGETNHISTOGRAMPROC)load("glGetnHistogram");
	glad_glGetnMinmax = (PFNGLGETNMINMAXPROC)load("glGetnMinmax");
	glad_glTextureBarrier = (PFNGLTEXTUREBARRIERPROC)load("glTextureBarrier");
}
static void load_GL_3DFX_tbuffer(GLADloadproc load) {
	if(!GLAD_GL_3DFX_tbuffer) return;
	glad_glTbufferMask3DFX = (PFNGLTBUFFERMASK3DFXPROC)load("glTbufferMask3DFX");
}
static void load_GL_AMD_debug_output(GLADloadproc load) {
	if(!GLAD_GL_AMD_debug_output) return;
	glad_glDebugMessageEnableAMD = (PFNGLDEBUGMESSAGEENABLEAMDPROC)load("glDebugMessageEnableAMD");
	glad_glDebugMessageInsertAMD = (PFNGLDEBUGMESSAGEINSERTAMDPROC)load("glDebugMessageInsertAMD");
	glad_glDebugMessageCallbackAMD = (PFNGLDEBUGMESSAGECALLBACKAMDPROC)load("glDebugMessageCallbackAMD");
	glad_glGetDebugMessageLogAMD = (PFNGLGETDEBUGMESSAGELOGAMDPROC)load("glGetDebugMessageLogAMD");
}
static void load_GL_AMD_draw_buffers_blend(GLADloadproc load) {
	if(!GLAD_GL_AMD_draw_buffers_blend) return;
	glad_glBlendFuncIndexedAMD = (PFNGLBLENDFUNCINDEXEDAMDPROC)load("glBlendFuncIndexedAMD");
	glad_glBlendFuncSeparateIndexedAMD = (PFNGLBLENDFUNCSEPARATEINDEXEDAMDPROC)load("glBlendFuncSeparateIndexedAMD");
	glad_glBlendEquationIndexedAMD = (PFNGLBLENDEQUATIONINDEXEDAMDPROC)load("glBlendEquationIndexedAMD");
	glad_glBlendEquationSeparateIndexedAMD = (PFNGLBLENDEQUATIONSEPARATEINDEXEDAMDPROC)load("glBlendEquationSeparateIndexedAMD");
}
static void load_GL_AMD_gpu_shader_int64(GLADloadproc load) {
	if(!GLAD_GL_AMD_gpu_shader_int64) return;
	glad_glUniform1i64NV = (PFNGLUNIFORM1I64NVPROC)load("glUniform1i64NV");
	glad_glUniform2i64NV = (PFNGLUNIFORM2I64NVPROC)load("glUniform2i64NV");
	glad_glUniform3i64NV = (PFNGLUNIFORM3I64NVPROC)load("glUniform3i64NV");
	glad_glUniform4i64NV = (PFNGLUNIFORM4I64NVPROC)load("glUniform4i64NV");
	glad_glUniform1i64vNV = (PFNGLUNIFORM1I64VNVPROC)load("glUniform1i64vNV");
	glad_glUniform2i64vNV = (PFNGLUNIFORM2I64VNVPROC)load("glUniform2i64vNV");
	glad_glUniform3i64vNV = (PFNGLUNIFORM3I64VNVPROC)load("glUniform3i64vNV");
	glad_glUniform4i64vNV = (PFNGLUNIFORM4I64VNVPROC)load("glUniform4i64vNV");
	glad_glUniform1ui64NV = (PFNGLUNIFORM1UI64NVPROC)load("glUniform1ui64NV");
	glad_glUniform2ui64NV = (PFNGLUNIFORM2UI64NVPROC)load("glUniform2ui64NV");
	glad_glUniform3ui64NV = (PFNGLUNIFORM3UI64NVPROC)load("glUniform3ui64NV");
	glad_glUniform4ui64NV = (PFNGLUNIFORM4UI64NVPROC)load("glUniform4ui64NV");
	glad_glUniform1ui64vNV = (PFNGLUNIFORM1UI64VNVPROC)load("glUniform1ui64vNV");
	glad_glUniform2ui64vNV = (PFNGLUNIFORM2UI64VNVPROC)load("glUniform2ui64vNV");
	glad_glUniform3ui64vNV = (PFNGLUNIFORM3UI64VNVPROC)load("glUniform3ui64vNV");
	glad_glUniform4ui64vNV = (PFNGLUNIFORM4UI64VNVPROC)load("glUniform4ui64vNV");
	glad_glGetUniformi64vNV = (PFNGLGETUNIFORMI64VNVPROC)load("glGetUniformi64vNV");
	glad_glGetUniformui64vNV = (PFNGLGETUNIFORMUI64VNVPROC)load("glGetUniformui64vNV");
	glad_glProgramUniform1i64NV = (PFNGLPROGRAMUNIFORM1I64NVPROC)load("glProgramUniform1i64NV");
	glad_glProgramUniform2i64NV = (PFNGLPROGRAMUNIFORM2I64NVPROC)load("glProgramUniform2i64NV");
	glad_glProgramUniform3i64NV = (PFNGLPROGRAMUNIFORM3I64NVPROC)load("glProgramUniform3i64NV");
	glad_glProgramUniform4i64NV = (PFNGLPROGRAMUNIFORM4I64NVPROC)load("glProgramUniform4i64NV");
	glad_glProgramUniform1i64vNV = (PFNGLPROGRAMUNIFORM1I64VNVPROC)load("glProgramUniform1i64vNV");
	glad_glProgramUniform2i64vNV = (PFNGLPROGRAMUNIFORM2I64VNVPROC)load("glProgramUniform2i64vNV");
	glad_glProgramUniform3i64vNV = (PFNGLPROGRAMUNIFORM3I64VNVPROC)load("glProgramUniform3i64vNV");
	glad_glProgramUniform4i64vNV = (PFNGLPROGRAMUNIFORM4I64VNVPROC)load("glProgramUniform4i64vNV");
	glad_glProgramUniform1ui64NV = (PFNGLPROGRAMUNIFORM1UI64NVPROC)load("glProgramUniform1ui64NV");
	glad_glProgramUniform2ui64NV = (PFNGLPROGRAMUNIFORM2UI64NVPROC)load("glProgramUniform2ui64NV");
	glad_glProgramUniform3ui64NV = (PFNGLPROGRAMUNIFORM3UI64NVPROC)load("glProgramUniform3ui64NV");
	glad_glProgramUniform4ui64NV = (PFNGLPROGRAMUNIFORM4UI64NVPROC)load("glProgramUniform4ui64NV");
	glad_glProgramUniform1ui64vNV = (PFNGLPROGRAMUNIFORM1UI64VNVPROC)load("glProgramUniform1ui64vNV");
	glad_glProgramUniform2ui64vNV = (PFNGLPROGRAMUNIFORM2UI64VNVPROC)load("glProgramUniform2ui64vNV");
	glad_glProgramUniform3ui64vNV = (PFNGLPROGRAMUNIFORM3UI64VNVPROC)load("glProgramUniform3ui64vNV");
	glad_glProgramUniform4ui64vNV = (PFNGLPROGRAMUNIFORM4UI64VNVPROC)load("glProgramUniform4ui64vNV");
}
static void load_GL_AMD_interleaved_elements(GLADloadproc load) {
	if(!GLAD_GL_AMD_interleaved_elements) return;
	glad_glVertexAttribParameteriAMD = (PFNGLVERTEXATTRIBPARAMETERIAMDPROC)load("glVertexAttribParameteriAMD");
}
static void load_GL_AMD_multi_draw_indirect(GLADloadproc load) {
	if(!GLAD_GL_AMD_multi_draw_indirect) return;
	glad_glMultiDrawArraysIndirectAMD = (PFNGLMULTIDRAWARRAYSINDIRECTAMDPROC)load("glMultiDrawArraysIndirectAMD");
	glad_glMultiDrawElementsIndirectAMD = (PFNGLMULTIDRAWELEMENTSINDIRECTAMDPROC)load("glMultiDrawElementsIndirectAMD");
}
static void load_GL_AMD_name_gen_delete(GLADloadproc load) {
	if(!GLAD_GL_AMD_name_gen_delete) return;
	glad_glGenNamesAMD = (PFNGLGENNAMESAMDPROC)load("glGenNamesAMD");
	glad_glDeleteNamesAMD = (PFNGLDELETENAMESAMDPROC)load("glDeleteNamesAMD");
	glad_glIsNameAMD = (PFNGLISNAMEAMDPROC)load("glIsNameAMD");
}
static void load_GL_AMD_occlusion_query_event(GLADloadproc load) {
	if(!GLAD_GL_AMD_occlusion_query_event) return;
	glad_glQueryObjectParameteruiAMD = (PFNGLQUERYOBJECTPARAMETERUIAMDPROC)load("glQueryObjectParameteruiAMD");
}
static void load_GL_AMD_performance_monitor(GLADloadproc load) {
	if(!GLAD_GL_AMD_performance_monitor) return;
	glad_glGetPerfMonitorGroupsAMD = (PFNGLGETPERFMONITORGROUPSAMDPROC)load("glGetPerfMonitorGroupsAMD");
	glad_glGetPerfMonitorCountersAMD = (PFNGLGETPERFMONITORCOUNTERSAMDPROC)load("glGetPerfMonitorCountersAMD");
	glad_glGetPerfMonitorGroupStringAMD = (PFNGLGETPERFMONITORGROUPSTRINGAMDPROC)load("glGetPerfMonitorGroupStringAMD");
	glad_glGetPerfMonitorCounterStringAMD = (PFNGLGETPERFMONITORCOUNTERSTRINGAMDPROC)load("glGetPerfMonitorCounterStringAMD");
	glad_glGetPerfMonitorCounterInfoAMD = (PFNGLGETPERFMONITORCOUNTERINFOAMDPROC)load("glGetPerfMonitorCounterInfoAMD");
	glad_glGenPerfMonitorsAMD = (PFNGLGENPERFMONITORSAMDPROC)load("glGenPerfMonitorsAMD");
	glad_glDeletePerfMonitorsAMD = (PFNGLDELETEPERFMONITORSAMDPROC)load("glDeletePerfMonitorsAMD");
	glad_glSelectPerfMonitorCountersAMD = (PFNGLSELECTPERFMONITORCOUNTERSAMDPROC)load("glSelectPerfMonitorCountersAMD");
	glad_glBeginPerfMonitorAMD = (PFNGLBEGINPERFMONITORAMDPROC)load("glBeginPerfMonitorAMD");
	glad_glEndPerfMonitorAMD = (PFNGLENDPERFMONITORAMDPROC)load("glEndPerfMonitorAMD");
	glad_glGetPerfMonitorCounterDataAMD = (PFNGLGETPERFMONITORCOUNTERDATAAMDPROC)load("glGetPerfMonitorCounterDataAMD");
}
static void load_GL_AMD_sample_positions(GLADloadproc load) {
	if(!GLAD_GL_AMD_sample_positions) return;
	glad_glSetMultisamplefvAMD = (PFNGLSETMULTISAMPLEFVAMDPROC)load("glSetMultisamplefvAMD");
}
static void load_GL_AMD_sparse_texture(GLADloadproc load) {
	if(!GLAD_GL_AMD_sparse_texture) return;
	glad_glTexStorageSparseAMD = (PFNGLTEXSTORAGESPARSEAMDPROC)load("glTexStorageSparseAMD");
	glad_glTextureStorageSparseAMD = (PFNGLTEXTURESTORAGESPARSEAMDPROC)load("glTextureStorageSparseAMD");
}
static void load_GL_AMD_stencil_operation_extended(GLADloadproc load) {
	if(!GLAD_GL_AMD_stencil_operation_extended) return;
	glad_glStencilOpValueAMD = (PFNGLSTENCILOPVALUEAMDPROC)load("glStencilOpValueAMD");
}
static void load_GL_AMD_vertex_shader_tessellator(GLADloadproc load) {
	if(!GLAD_GL_AMD_vertex_shader_tessellator) return;
	glad_glTessellationFactorAMD = (PFNGLTESSELLATIONFACTORAMDPROC)load("glTessellationFactorAMD");
	glad_glTessellationModeAMD = (PFNGLTESSELLATIONMODEAMDPROC)load("glTessellationModeAMD");
}
static void load_GL_APPLE_element_array(GLADloadproc load) {
	if(!GLAD_GL_APPLE_element_array) return;
	glad_glElementPointerAPPLE = (PFNGLELEMENTPOINTERAPPLEPROC)load("glElementPointerAPPLE");
	glad_glDrawElementArrayAPPLE = (PFNGLDRAWELEMENTARRAYAPPLEPROC)load("glDrawElementArrayAPPLE");
	glad_glDrawRangeElementArrayAPPLE = (PFNGLDRAWRANGEELEMENTARRAYAPPLEPROC)load("glDrawRangeElementArrayAPPLE");
	glad_glMultiDrawElementArrayAPPLE = (PFNGLMULTIDRAWELEMENTARRAYAPPLEPROC)load("glMultiDrawElementArrayAPPLE");
	glad_glMultiDrawRangeElementArrayAPPLE = (PFNGLMULTIDRAWRANGEELEMENTARRAYAPPLEPROC)load("glMultiDrawRangeElementArrayAPPLE");
}
static void load_GL_APPLE_fence(GLADloadproc load) {
	if(!GLAD_GL_APPLE_fence) return;
	glad_glGenFencesAPPLE = (PFNGLGENFENCESAPPLEPROC)load("glGenFencesAPPLE");
	glad_glDeleteFencesAPPLE = (PFNGLDELETEFENCESAPPLEPROC)load("glDeleteFencesAPPLE");
	glad_glSetFenceAPPLE = (PFNGLSETFENCEAPPLEPROC)load("glSetFenceAPPLE");
	glad_glIsFenceAPPLE = (PFNGLISFENCEAPPLEPROC)load("glIsFenceAPPLE");
	glad_glTestFenceAPPLE = (PFNGLTESTFENCEAPPLEPROC)load("glTestFenceAPPLE");
	glad_glFinishFenceAPPLE = (PFNGLFINISHFENCEAPPLEPROC)load("glFinishFenceAPPLE");
	glad_glTestObjectAPPLE = (PFNGLTESTOBJECTAPPLEPROC)load("glTestObjectAPPLE");
	glad_glFinishObjectAPPLE = (PFNGLFINISHOBJECTAPPLEPROC)load("glFinishObjectAPPLE");
}
static void load_GL_APPLE_flush_buffer_range(GLADloadproc load) {
	if(!GLAD_GL_APPLE_flush_buffer_range) return;
	glad_glBufferParameteriAPPLE = (PFNGLBUFFERPARAMETERIAPPLEPROC)load("glBufferParameteriAPPLE");
	glad_glFlushMappedBufferRangeAPPLE = (PFNGLFLUSHMAPPEDBUFFERRANGEAPPLEPROC)load("glFlushMappedBufferRangeAPPLE");
}
static void load_GL_APPLE_object_purgeable(GLADloadproc load) {
	if(!GLAD_GL_APPLE_object_purgeable) return;
	glad_glObjectPurgeableAPPLE = (PFNGLOBJECTPURGEABLEAPPLEPROC)load("glObjectPurgeableAPPLE");
	glad_glObjectUnpurgeableAPPLE = (PFNGLOBJECTUNPURGEABLEAPPLEPROC)load("glObjectUnpurgeableAPPLE");
	glad_glGetObjectParameterivAPPLE = (PFNGLGETOBJECTPARAMETERIVAPPLEPROC)load("glGetObjectParameterivAPPLE");
}
static void load_GL_APPLE_texture_range(GLADloadproc load) {
	if(!GLAD_GL_APPLE_texture_range) return;
	glad_glTextureRangeAPPLE = (PFNGLTEXTURERANGEAPPLEPROC)load("glTextureRangeAPPLE");
	glad_glGetTexParameterPointervAPPLE = (PFNGLGETTEXPARAMETERPOINTERVAPPLEPROC)load("glGetTexParameterPointervAPPLE");
}
static void load_GL_APPLE_vertex_array_object(GLADloadproc load) {
	if(!GLAD_GL_APPLE_vertex_array_object) return;
	glad_glBindVertexArrayAPPLE = (PFNGLBINDVERTEXARRAYAPPLEPROC)load("glBindVertexArrayAPPLE");
	glad_glDeleteVertexArraysAPPLE = (PFNGLDELETEVERTEXARRAYSAPPLEPROC)load("glDeleteVertexArraysAPPLE");
	glad_glGenVertexArraysAPPLE = (PFNGLGENVERTEXARRAYSAPPLEPROC)load("glGenVertexArraysAPPLE");
	glad_glIsVertexArrayAPPLE = (PFNGLISVERTEXARRAYAPPLEPROC)load("glIsVertexArrayAPPLE");
}
static void load_GL_APPLE_vertex_array_range(GLADloadproc load) {
	if(!GLAD_GL_APPLE_vertex_array_range) return;
	glad_glVertexArrayRangeAPPLE = (PFNGLVERTEXARRAYRANGEAPPLEPROC)load("glVertexArrayRangeAPPLE");
	glad_glFlushVertexArrayRangeAPPLE = (PFNGLFLUSHVERTEXARRAYRANGEAPPLEPROC)load("glFlushVertexArrayRangeAPPLE");
	glad_glVertexArrayParameteriAPPLE = (PFNGLVERTEXARRAYPARAMETERIAPPLEPROC)load("glVertexArrayParameteriAPPLE");
}
static void load_GL_APPLE_vertex_program_evaluators(GLADloadproc load) {
	if(!GLAD_GL_APPLE_vertex_program_evaluators) return;
	glad_glEnableVertexAttribAPPLE = (PFNGLENABLEVERTEXATTRIBAPPLEPROC)load("glEnableVertexAttribAPPLE");
	glad_glDisableVertexAttribAPPLE = (PFNGLDISABLEVERTEXATTRIBAPPLEPROC)load("glDisableVertexAttribAPPLE");
	glad_glIsVertexAttribEnabledAPPLE = (PFNGLISVERTEXATTRIBENABLEDAPPLEPROC)load("glIsVertexAttribEnabledAPPLE");
	glad_glMapVertexAttrib1dAPPLE = (PFNGLMAPVERTEXATTRIB1DAPPLEPROC)load("glMapVertexAttrib1dAPPLE");
	glad_glMapVertexAttrib1fAPPLE = (PFNGLMAPVERTEXATTRIB1FAPPLEPROC)load("glMapVertexAttrib1fAPPLE");
	glad_glMapVertexAttrib2dAPPLE = (PFNGLMAPVERTEXATTRIB2DAPPLEPROC)load("glMapVertexAttrib2dAPPLE");
	glad_glMapVertexAttrib2fAPPLE = (PFNGLMAPVERTEXATTRIB2FAPPLEPROC)load("glMapVertexAttrib2fAPPLE");
}
static void load_GL_ARB_ES2_compatibility(GLADloadproc load) {
	if(!GLAD_GL_ARB_ES2_compatibility) return;
	glad_glReleaseShaderCompiler = (PFNGLRELEASESHADERCOMPILERPROC)load("glReleaseShaderCompiler");
	glad_glShaderBinary = (PFNGLSHADERBINARYPROC)load("glShaderBinary");
	glad_glGetShaderPrecisionFormat = (PFNGLGETSHADERPRECISIONFORMATPROC)load("glGetShaderPrecisionFormat");
	glad_glDepthRangef = (PFNGLDEPTHRANGEFPROC)load("glDepthRangef");
	glad_glClearDepthf = (PFNGLCLEARDEPTHFPROC)load("glClearDepthf");
}
static void load_GL_ARB_ES3_1_compatibility(GLADloadproc load) {
	if(!GLAD_GL_ARB_ES3_1_compatibility) return;
	glad_glMemoryBarrierByRegion = (PFNGLMEMORYBARRIERBYREGIONPROC)load("glMemoryBarrierByRegion");
}
static void load_GL_ARB_ES3_2_compatibility(GLADloadproc load) {
	if(!GLAD_GL_ARB_ES3_2_compatibility) return;
	glad_glPrimitiveBoundingBoxARB = (PFNGLPRIMITIVEBOUNDINGBOXARBPROC)load("glPrimitiveBoundingBoxARB");
}
static void load_GL_ARB_base_instance(GLADloadproc load) {
	if(!GLAD_GL_ARB_base_instance) return;
	glad_glDrawArraysInstancedBaseInstance = (PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEPROC)load("glDrawArraysInstancedBaseInstance");
	glad_glDrawElementsInstancedBaseInstance = (PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEPROC)load("glDrawElementsInstancedBaseInstance");
	glad_glDrawElementsInstancedBaseVertexBaseInstance = (PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEPROC)load("glDrawElementsInstancedBaseVertexBaseInstance");
}
static void load_GL_ARB_bindless_texture(GLADloadproc load) {
	if(!GLAD_GL_ARB_bindless_texture) return;
	glad_glGetTextureHandleARB = (PFNGLGETTEXTUREHANDLEARBPROC)load("glGetTextureHandleARB");
	glad_glGetTextureSamplerHandleARB = (PFNGLGETTEXTURESAMPLERHANDLEARBPROC)load("glGetTextureSamplerHandleARB");
	glad_glMakeTextureHandleResidentARB = (PFNGLMAKETEXTUREHANDLERESIDENTARBPROC)load("glMakeTextureHandleResidentARB");
	glad_glMakeTextureHandleNonResidentARB = (PFNGLMAKETEXTUREHANDLENONRESIDENTARBPROC)load("glMakeTextureHandleNonResidentARB");
	glad_glGetImageHandleARB = (PFNGLGETIMAGEHANDLEARBPROC)load("glGetImageHandleARB");
	glad_glMakeImageHandleResidentARB = (PFNGLMAKEIMAGEHANDLERESIDENTARBPROC)load("glMakeImageHandleResidentARB");
	glad_glMakeImageHandleNonResidentARB = (PFNGLMAKEIMAGEHANDLENONRESIDENTARBPROC)load("glMakeImageHandleNonResidentARB");
	glad_glUniformHandleui64ARB = (PFNGLUNIFORMHANDLEUI64ARBPROC)load("glUniformHandleui64ARB");
	glad_glUniformHandleui64vARB = (PFNGLUNIFORMHANDLEUI64VARBPROC)load("glUniformHandleui64vARB");
	glad_glProgramUniformHandleui64ARB = (PFNGLPROGRAMUNIFORMHANDLEUI64ARBPROC)load("glProgramUniformHandleui64ARB");
	glad_glProgramUniformHandleui64vARB = (PFNGLPROGRAMUNIFORMHANDLEUI64VARBPROC)load("glProgramUniformHandleui64vARB");
	glad_glIsTextureHandleResidentARB = (PFNGLISTEXTUREHANDLERESIDENTARBPROC)load("glIsTextureHandleResidentARB");
	glad_glIsImageHandleResidentARB = (PFNGLISIMAGEHANDLERESIDENTARBPROC)load("glIsImageHandleResidentARB");
	glad_glVertexAttribL1ui64ARB = (PFNGLVERTEXATTRIBL1UI64ARBPROC)load("glVertexAttribL1ui64ARB");
	glad_glVertexAttribL1ui64vARB = (PFNGLVERTEXATTRIBL1UI64VARBPROC)load("glVertexAttribL1ui64vARB");
	glad_glGetVertexAttribLui64vARB = (PFNGLGETVERTEXATTRIBLUI64VARBPROC)load("glGetVertexAttribLui64vARB");
}
static void load_GL_ARB_blend_func_extended(GLADloadproc load) {
	if(!GLAD_GL_ARB_blend_func_extended) return;
	glad_glBindFragDataLocationIndexed = (PFNGLBINDFRAGDATALOCATIONINDEXEDPROC)load("glBindFragDataLocationIndexed");
	glad_glGetFragDataIndex = (PFNGLGETFRAGDATAINDEXPROC)load("glGetFragDataIndex");
}
static void load_GL_ARB_buffer_storage(GLADloadproc load) {
	if(!GLAD_GL_ARB_buffer_storage) return;
	glad_glBufferStorage = (PFNGLBUFFERSTORAGEPROC)load("glBufferStorage");
}
static void load_GL_ARB_cl_event(GLADloadproc load) {
	if(!GLAD_GL_ARB_cl_event) return;
	glad_glCreateSyncFromCLeventARB = (PFNGLCREATESYNCFROMCLEVENTARBPROC)load("glCreateSyncFromCLeventARB");
}
static void load_GL_ARB_clear_buffer_object(GLADloadproc load) {
	if(!GLAD_GL_ARB_clear_buffer_object) return;
	glad_glClearBufferData = (PFNGLCLEARBUFFERDATAPROC)load("glClearBufferData");
	glad_glClearBufferSubData = (PFNGLCLEARBUFFERSUBDATAPROC)load("glClearBufferSubData");
}
static void load_GL_ARB_clear_texture(GLADloadproc load) {
	if(!GLAD_GL_ARB_clear_texture) return;
	glad_glClearTexImage = (PFNGLCLEARTEXIMAGEPROC)load("glClearTexImage");
	glad_glClearTexSubImage = (PFNGLCLEARTEXSUBIMAGEPROC)load("glClearTexSubImage");
}
static void load_GL_ARB_clip_control(GLADloadproc load) {
	if(!GLAD_GL_ARB_clip_control) return;
	glad_glClipControl = (PFNGLCLIPCONTROLPROC)load("glClipControl");
}
static void load_GL_ARB_color_buffer_float(GLADloadproc load) {
	if(!GLAD_GL_ARB_color_buffer_float) return;
	glad_glClampColorARB = (PFNGLCLAMPCOLORARBPROC)load("glClampColorARB");
}
static void load_GL_ARB_compute_shader(GLADloadproc load) {
	if(!GLAD_GL_ARB_compute_shader) return;
	glad_glDispatchCompute = (PFNGLDISPATCHCOMPUTEPROC)load("glDispatchCompute");
	glad_glDispatchComputeIndirect = (PFNGLDISPATCHCOMPUTEINDIRECTPROC)load("glDispatchComputeIndirect");
}
static void load_GL_ARB_compute_variable_group_size(GLADloadproc load) {
	if(!GLAD_GL_ARB_compute_variable_group_size) return;
	glad_glDispatchComputeGroupSizeARB = (PFNGLDISPATCHCOMPUTEGROUPSIZEARBPROC)load("glDispatchComputeGroupSizeARB");
}
static void load_GL_ARB_copy_buffer(GLADloadproc load) {
	if(!GLAD_GL_ARB_copy_buffer) return;
	glad_glCopyBufferSubData = (PFNGLCOPYBUFFERSUBDATAPROC)load("glCopyBufferSubData");
}
static void load_GL_ARB_copy_image(GLADloadproc load) {
	if(!GLAD_GL_ARB_copy_image) return;
	glad_glCopyImageSubData = (PFNGLCOPYIMAGESUBDATAPROC)load("glCopyImageSubData");
}
static void load_GL_ARB_debug_output(GLADloadproc load) {
	if(!GLAD_GL_ARB_debug_output) return;
	glad_glDebugMessageControlARB = (PFNGLDEBUGMESSAGECONTROLARBPROC)load("glDebugMessageControlARB");
	glad_glDebugMessageInsertARB = (PFNGLDEBUGMESSAGEINSERTARBPROC)load("glDebugMessageInsertARB");
	glad_glDebugMessageCallbackARB = (PFNGLDEBUGMESSAGECALLBACKARBPROC)load("glDebugMessageCallbackARB");
	glad_glGetDebugMessageLogARB = (PFNGLGETDEBUGMESSAGELOGARBPROC)load("glGetDebugMessageLogARB");
}
static void load_GL_ARB_direct_state_access(GLADloadproc load) {
	if(!GLAD_GL_ARB_direct_state_access) return;
	glad_glCreateTransformFeedbacks = (PFNGLCREATETRANSFORMFEEDBACKSPROC)load("glCreateTransformFeedbacks");
	glad_glTransformFeedbackBufferBase = (PFNGLTRANSFORMFEEDBACKBUFFERBASEPROC)load("glTransformFeedbackBufferBase");
	glad_glTransformFeedbackBufferRange = (PFNGLTRANSFORMFEEDBACKBUFFERRANGEPROC)load("glTransformFeedbackBufferRange");
	glad_glGetTransformFeedbackiv = (PFNGLGETTRANSFORMFEEDBACKIVPROC)load("glGetTransformFeedbackiv");
	glad_glGetTransformFeedbacki_v = (PFNGLGETTRANSFORMFEEDBACKI_VPROC)load("glGetTransformFeedbacki_v");
	glad_glGetTransformFeedbacki64_v = (PFNGLGETTRANSFORMFEEDBACKI64_VPROC)load("glGetTransformFeedbacki64_v");
	glad_glCreateBuffers = (PFNGLCREATEBUFFERSPROC)load("glCreateBuffers");
	glad_glNamedBufferStorage = (PFNGLNAMEDBUFFERSTORAGEPROC)load("glNamedBufferStorage");
	glad_glNamedBufferData = (PFNGLNAMEDBUFFERDATAPROC)load("glNamedBufferData");
	glad_glNamedBufferSubData = (PFNGLNAMEDBUFFERSUBDATAPROC)load("glNamedBufferSubData");
	glad_glCopyNamedBufferSubData = (PFNGLCOPYNAMEDBUFFERSUBDATAPROC)load("glCopyNamedBufferSubData");
	glad_glClearNamedBufferData = (PFNGLCLEARNAMEDBUFFERDATAPROC)load("glClearNamedBufferData");
	glad_glClearNamedBufferSubData = (PFNGLCLEARNAMEDBUFFERSUBDATAPROC)load("glClearNamedBufferSubData");
	glad_glMapNamedBuffer = (PFNGLMAPNAMEDBUFFERPROC)load("glMapNamedBuffer");
	glad_glMapNamedBufferRange = (PFNGLMAPNAMEDBUFFERRANGEPROC)load("glMapNamedBufferRange");
	glad_glUnmapNamedBuffer = (PFNGLUNMAPNAMEDBUFFERPROC)load("glUnmapNamedBuffer");
	glad_glFlushMappedNamedBufferRange = (PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEPROC)load("glFlushMappedNamedBufferRange");
	glad_glGetNamedBufferParameteriv = (PFNGLGETNAMEDBUFFERPARAMETERIVPROC)load("glGetNamedBufferParameteriv");
	glad_glGetNamedBufferParameteri64v = (PFNGLGETNAMEDBUFFERPARAMETERI64VPROC)load("glGetNamedBufferParameteri64v");
	glad_glGetNamedBufferPointerv = (PFNGLGETNAMEDBUFFERPOINTERVPROC)load("glGetNamedBufferPointerv");
	glad_glGetNamedBufferSubData = (PFNGLGETNAMEDBUFFERSUBDATAPROC)load("glGetNamedBufferSubData");
	glad_glCreateFramebuffers = (PFNGLCREATEFRAMEBUFFERSPROC)load("glCreateFramebuffers");
	glad_glNamedFramebufferRenderbuffer = (PFNGLNAMEDFRAMEBUFFERRENDERBUFFERPROC)load("glNamedFramebufferRenderbuffer");
	glad_glNamedFramebufferParameteri = (PFNGLNAMEDFRAMEBUFFERPARAMETERIPROC)load("glNamedFramebufferParameteri");
	glad_glNamedFramebufferTexture = (PFNGLNAMEDFRAMEBUFFERTEXTUREPROC)load("glNamedFramebufferTexture");
	glad_glNamedFramebufferTextureLayer = (PFNGLNAMEDFRAMEBUFFERTEXTURELAYERPROC)load("glNamedFramebufferTextureLayer");
	glad_glNamedFramebufferDrawBuffer = (PFNGLNAMEDFRAMEBUFFERDRAWBUFFERPROC)load("glNamedFramebufferDrawBuffer");
	glad_glNamedFramebufferDrawBuffers = (PFNGLNAMEDFRAMEBUFFERDRAWBUFFERSPROC)load("glNamedFramebufferDrawBuffers");
	glad_glNamedFramebufferReadBuffer = (PFNGLNAMEDFRAMEBUFFERREADBUFFERPROC)load("glNamedFramebufferReadBuffer");
	glad_glInvalidateNamedFramebufferData = (PFNGLINVALIDATENAMEDFRAMEBUFFERDATAPROC)load("glInvalidateNamedFramebufferData");
	glad_glInvalidateNamedFramebufferSubData = (PFNGLINVALIDATENAMEDFRAMEBUFFERSUBDATAPROC)load("glInvalidateNamedFramebufferSubData");
	glad_glClearNamedFramebufferiv = (PFNGLCLEARNAMEDFRAMEBUFFERIVPROC)load("glClearNamedFramebufferiv");
	glad_glClearNamedFramebufferuiv = (PFNGLCLEARNAMEDFRAMEBUFFERUIVPROC)load("glClearNamedFramebufferuiv");
	glad_glClearNamedFramebufferfv = (PFNGLCLEARNAMEDFRAMEBUFFERFVPROC)load("glClearNamedFramebufferfv");
	glad_glClearNamedFramebufferfi = (PFNGLCLEARNAMEDFRAMEBUFFERFIPROC)load("glClearNamedFramebufferfi");
	glad_glBlitNamedFramebuffer = (PFNGLBLITNAMEDFRAMEBUFFERPROC)load("glBlitNamedFramebuffer");
	glad_glCheckNamedFramebufferStatus = (PFNGLCHECKNAMEDFRAMEBUFFERSTATUSPROC)load("glCheckNamedFramebufferStatus");
	glad_glGetNamedFramebufferParameteriv = (PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVPROC)load("glGetNamedFramebufferParameteriv");
	glad_glGetNamedFramebufferAttachmentParameteriv = (PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVPROC)load("glGetNamedFramebufferAttachmentParameteriv");
	glad_glCreateRenderbuffers = (PFNGLCREATERENDERBUFFERSPROC)load("glCreateRenderbuffers");
	glad_glNamedRenderbufferStorage = (PFNGLNAMEDRENDERBUFFERSTORAGEPROC)load("glNamedRenderbufferStorage");
	glad_glNamedRenderbufferStorageMultisample = (PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEPROC)load("glNamedRenderbufferStorageMultisample");
	glad_glGetNamedRenderbufferParameteriv = (PFNGLGETNAMEDRENDERBUFFERPARAMETERIVPROC)load("glGetNamedRenderbufferParameteriv");
	glad_glCreateTextures = (PFNGLCREATETEXTURESPROC)load("glCreateTextures");
	glad_glTextureBuffer = (PFNGLTEXTUREBUFFERPROC)load("glTextureBuffer");
	glad_glTextureBufferRange = (PFNGLTEXTUREBUFFERRANGEPROC)load("glTextureBufferRange");
	glad_glTextureStorage1D = (PFNGLTEXTURESTORAGE1DPROC)load("glTextureStorage1D");
	glad_glTextureStorage2D = (PFNGLTEXTURESTORAGE2DPROC)load("glTextureStorage2D");
	glad_glTextureStorage3D = (PFNGLTEXTURESTORAGE3DPROC)load("glTextureStorage3D");
	glad_glTextureStorage2DMultisample = (PFNGLTEXTURESTORAGE2DMULTISAMPLEPROC)load("glTextureStorage2DMultisample");
	glad_glTextureStorage3DMultisample = (PFNGLTEXTURESTORAGE3DMULTISAMPLEPROC)load("glTextureStorage3DMultisample");
	glad_glTextureSubImage1D = (PFNGLTEXTURESUBIMAGE1DPROC)load("glTextureSubImage1D");
	glad_glTextureSubImage2D = (PFNGLTEXTURESUBIMAGE2DPROC)load("glTextureSubImage2D");
	glad_glTextureSubImage3D = (PFNGLTEXTURESUBIMAGE3DPROC)load("glTextureSubImage3D");
	glad_glCompressedTextureSubImage1D = (PFNGLCOMPRESSEDTEXTURESUBIMAGE1DPROC)load("glCompressedTextureSubImage1D");
	glad_glCompressedTextureSubImage2D = (PFNGLCOMPRESSEDTEXTURESUBIMAGE2DPROC)load("glCompressedTextureSubImage2D");
	glad_glCompressedTextureSubImage3D = (PFNGLCOMPRESSEDTEXTURESUBIMAGE3DPROC)load("glCompressedTextureSubImage3D");
	glad_glCopyTextureSubImage1D = (PFNGLCOPYTEXTURESUBIMAGE1DPROC)load("glCopyTextureSubImage1D");
	glad_glCopyTextureSubImage2D = (PFNGLCOPYTEXTURESUBIMAGE2DPROC)load("glCopyTextureSubImage2D");
	glad_glCopyTextureSubImage3D = (PFNGLCOPYTEXTURESUBIMAGE3DPROC)load("glCopyTextureSubImage3D");
	glad_glTextureParameterf = (PFNGLTEXTUREPARAMETERFPROC)load("glTextureParameterf");
	glad_glTextureParameterfv = (PFNGLTEXTUREPARAMETERFVPROC)load("glTextureParameterfv");
	glad_glTextureParameteri = (PFNGLTEXTUREPARAMETERIPROC)load("glTextureParameteri");
	glad_glTextureParameterIiv = (PFNGLTEXTUREPARAMETERIIVPROC)load("glTextureParameterIiv");
	glad_glTextureParameterIuiv = (PFNGLTEXTUREPARAMETERIUIVPROC)load("glTextureParameterIuiv");
	glad_glTextureParameteriv = (PFNGLTEXTUREPARAMETERIVPROC)load("glTextureParameteriv");
	glad_glGenerateTextureMipmap = (PFNGLGENERATETEXTUREMIPMAPPROC)load("glGenerateTextureMipmap");
	glad_glBindTextureUnit = (PFNGLBINDTEXTUREUNITPROC)load("glBindTextureUnit");
	glad_glGetTextureImage = (PFNGLGETTEXTUREIMAGEPROC)load("glGetTextureImage");
	glad_glGetCompressedTextureImage = (PFNGLGETCOMPRESSEDTEXTUREIMAGEPROC)load("glGetCompressedTextureImage");
	glad_glGetTextureLevelParameterfv = (PFNGLGETTEXTURELEVELPARAMETERFVPROC)load("glGetTextureLevelParameterfv");
	glad_glGetTextureLevelParameteriv = (PFNGLGETTEXTURELEVELPARAMETERIVPROC)load("glGetTextureLevelParameteriv");
	glad_glGetTextureParameterfv = (PFNGLGETTEXTUREPARAMETERFVPROC)load("glGetTextureParameterfv");
	glad_glGetTextureParameterIiv = (PFNGLGETTEXTUREPARAMETERIIVPROC)load("glGetTextureParameterIiv");
	glad_glGetTextureParameterIuiv = (PFNGLGETTEXTUREPARAMETERIUIVPROC)load("glGetTextureParameterIuiv");
	glad_glGetTextureParameteriv = (PFNGLGETTEXTUREPARAMETERIVPROC)load("glGetTextureParameteriv");
	glad_glCreateVertexArrays = (PFNGLCREATEVERTEXARRAYSPROC)load("glCreateVertexArrays");
	glad_glDisableVertexArrayAttrib = (PFNGLDISABLEVERTEXARRAYATTRIBPROC)load("glDisableVertexArrayAttrib");
	glad_glEnableVertexArrayAttrib = (PFNGLENABLEVERTEXARRAYATTRIBPROC)load("glEnableVertexArrayAttrib");
	glad_glVertexArrayElementBuffer = (PFNGLVERTEXARRAYELEMENTBUFFERPROC)load("glVertexArrayElementBuffer");
	glad_glVertexArrayVertexBuffer = (PFNGLVERTEXARRAYVERTEXBUFFERPROC)load("glVertexArrayVertexBuffer");
	glad_glVertexArrayVertexBuffers = (PFNGLVERTEXARRAYVERTEXBUFFERSPROC)load("glVertexArrayVertexBuffers");
	glad_glVertexArrayAttribBinding = (PFNGLVERTEXARRAYATTRIBBINDINGPROC)load("glVertexArrayAttribBinding");
	glad_glVertexArrayAttribFormat = (PFNGLVERTEXARRAYATTRIBFORMATPROC)load("glVertexArrayAttribFormat");
	glad_glVertexArrayAttribIFormat = (PFNGLVERTEXARRAYATTRIBIFORMATPROC)load("glVertexArrayAttribIFormat");
	glad_glVertexArrayAttribLFormat = (PFNGLVERTEXARRAYATTRIBLFORMATPROC)load("glVertexArrayAttribLFormat");
	glad_glVertexArrayBindingDivisor = (PFNGLVERTEXARRAYBINDINGDIVISORPROC)load("glVertexArrayBindingDivisor");
	glad_glGetVertexArrayiv = (PFNGLGETVERTEXARRAYIVPROC)load("glGetVertexArrayiv");
	glad_glGetVertexArrayIndexediv = (PFNGLGETVERTEXARRAYINDEXEDIVPROC)load("glGetVertexArrayIndexediv");
	glad_glGetVertexArrayIndexed64iv = (PFNGLGETVERTEXARRAYINDEXED64IVPROC)load("glGetVertexArrayIndexed64iv");
	glad_glCreateSamplers = (PFNGLCREATESAMPLERSPROC)load("glCreateSamplers");
	glad_glCreateProgramPipelines = (PFNGLCREATEPROGRAMPIPELINESPROC)load("glCreateProgramPipelines");
	glad_glCreateQueries = (PFNGLCREATEQUERIESPROC)load("glCreateQueries");
	glad_glGetQueryBufferObjecti64v = (PFNGLGETQUERYBUFFEROBJECTI64VPROC)load("glGetQueryBufferObjecti64v");
	glad_glGetQueryBufferObjectiv = (PFNGLGETQUERYBUFFEROBJECTIVPROC)load("glGetQueryBufferObjectiv");
	glad_glGetQueryBufferObjectui64v = (PFNGLGETQUERYBUFFEROBJECTUI64VPROC)load("glGetQueryBufferObjectui64v");
	glad_glGetQueryBufferObjectuiv = (PFNGLGETQUERYBUFFEROBJECTUIVPROC)load("glGetQueryBufferObjectuiv");
}
static void load_GL_ARB_draw_buffers(GLADloadproc load) {
	if(!GLAD_GL_ARB_draw_buffers) return;
	glad_glDrawBuffersARB = (PFNGLDRAWBUFFERSARBPROC)load("glDrawBuffersARB");
}
static void load_GL_ARB_draw_buffers_blend(GLADloadproc load) {
	if(!GLAD_GL_ARB_draw_buffers_blend) return;
	glad_glBlendEquationiARB = (PFNGLBLENDEQUATIONIARBPROC)load("glBlendEquationiARB");
	glad_glBlendEquationSeparateiARB = (PFNGLBLENDEQUATIONSEPARATEIARBPROC)load("glBlendEquationSeparateiARB");
	glad_glBlendFunciARB = (PFNGLBLENDFUNCIARBPROC)load("glBlendFunciARB");
	glad_glBlendFuncSeparateiARB = (PFNGLBLENDFUNCSEPARATEIARBPROC)load("glBlendFuncSeparateiARB");
}
static void load_GL_ARB_draw_elements_base_vertex(GLADloadproc load) {
	if(!GLAD_GL_ARB_draw_elements_base_vertex) return;
	glad_glDrawElementsBaseVertex = (PFNGLDRAWELEMENTSBASEVERTEXPROC)load("glDrawElementsBaseVertex");
	glad_glDrawRangeElementsBaseVertex = (PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC)load("glDrawRangeElementsBaseVertex");
	glad_glDrawElementsInstancedBaseVertex = (PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC)load("glDrawElementsInstancedBaseVertex");
	glad_glMultiDrawElementsBaseVertex = (PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC)load("glMultiDrawElementsBaseVertex");
}
static void load_GL_ARB_draw_indirect(GLADloadproc load) {
	if(!GLAD_GL_ARB_draw_indirect) return;
	glad_glDrawArraysIndirect = (PFNGLDRAWARRAYSINDIRECTPROC)load("glDrawArraysIndirect");
	glad_glDrawElementsIndirect = (PFNGLDRAWELEMENTSINDIRECTPROC)load("glDrawElementsIndirect");
}
static void load_GL_ARB_draw_instanced(GLADloadproc load) {
	if(!GLAD_GL_ARB_draw_instanced) return;
	glad_glDrawArraysInstancedARB = (PFNGLDRAWARRAYSINSTANCEDARBPROC)load("glDrawArraysInstancedARB");
	glad_glDrawElementsInstancedARB = (PFNGLDRAWELEMENTSINSTANCEDARBPROC)load("glDrawElementsInstancedARB");
}
static void load_GL_ARB_fragment_program(GLADloadproc load) {
	if(!GLAD_GL_ARB_fragment_program) return;
	glad_glProgramStringARB = (PFNGLPROGRAMSTRINGARBPROC)load("glProgramStringARB");
	glad_glBindProgramARB = (PFNGLBINDPROGRAMARBPROC)load("glBindProgramARB");
	glad_glDeleteProgramsARB = (PFNGLDELETEPROGRAMSARBPROC)load("glDeleteProgramsARB");
	glad_glGenProgramsARB = (PFNGLGENPROGRAMSARBPROC)load("glGenProgramsARB");
	glad_glProgramEnvParameter4dARB = (PFNGLPROGRAMENVPARAMETER4DARBPROC)load("glProgramEnvParameter4dARB");
	glad_glProgramEnvParameter4dvARB = (PFNGLPROGRAMENVPARAMETER4DVARBPROC)load("glProgramEnvParameter4dvARB");
	glad_glProgramEnvParameter4fARB = (PFNGLPROGRAMENVPARAMETER4FARBPROC)load("glProgramEnvParameter4fARB");
	glad_glProgramEnvParameter4fvARB = (PFNGLPROGRAMENVPARAMETER4FVARBPROC)load("glProgramEnvParameter4fvARB");
	glad_glProgramLocalParameter4dARB = (PFNGLPROGRAMLOCALPARAMETER4DARBPROC)load("glProgramLocalParameter4dARB");
	glad_glProgramLocalParameter4dvARB = (PFNGLPROGRAMLOCALPARAMETER4DVARBPROC)load("glProgramLocalParameter4dvARB");
	glad_glProgramLocalParameter4fARB = (PFNGLPROGRAMLOCALPARAMETER4FARBPROC)load("glProgramLocalParameter4fARB");
	glad_glProgramLocalParameter4fvARB = (PFNGLPROGRAMLOCALPARAMETER4FVARBPROC)load("glProgramLocalParameter4fvARB");
	glad_glGetProgramEnvParameterdvARB = (PFNGLGETPROGRAMENVPARAMETERDVARBPROC)load("glGetProgramEnvParameterdvARB");
	glad_glGetProgramEnvParameterfvARB = (PFNGLGETPROGRAMENVPARAMETERFVARBPROC)load("glGetProgramEnvParameterfvARB");
	glad_glGetProgramLocalParameterdvARB = (PFNGLGETPROGRAMLOCALPARAMETERDVARBPROC)load("glGetProgramLocalParameterdvARB");
	glad_glGetProgramLocalParameterfvARB = (PFNGLGETPROGRAMLOCALPARAMETERFVARBPROC)load("glGetProgramLocalParameterfvARB");
	glad_glGetProgramivARB = (PFNGLGETPROGRAMIVARBPROC)load("glGetProgramivARB");
	glad_glGetProgramStringARB = (PFNGLGETPROGRAMSTRINGARBPROC)load("glGetProgramStringARB");
	glad_glIsProgramARB = (PFNGLISPROGRAMARBPROC)load("glIsProgramARB");
}
static void load_GL_ARB_framebuffer_no_attachments(GLADloadproc load) {
	if(!GLAD_GL_ARB_framebuffer_no_attachments) return;
	glad_glFramebufferParameteri = (PFNGLFRAMEBUFFERPARAMETERIPROC)load("glFramebufferParameteri");
	glad_glGetFramebufferParameteriv = (PFNGLGETFRAMEBUFFERPARAMETERIVPROC)load("glGetFramebufferParameteriv");
}
static void load_GL_ARB_framebuffer_object(GLADloadproc load) {
	if(!GLAD_GL_ARB_framebuffer_object) return;
	glad_glIsRenderbuffer = (PFNGLISRENDERBUFFERPROC)load("glIsRenderbuffer");
	glad_glBindRenderbuffer = (PFNGLBINDRENDERBUFFERPROC)load("glBindRenderbuffer");
	glad_glDeleteRenderbuffers = (PFNGLDELETERENDERBUFFERSPROC)load("glDeleteRenderbuffers");
	glad_glGenRenderbuffers = (PFNGLGENRENDERBUFFERSPROC)load("glGenRenderbuffers");
	glad_glRenderbufferStorage = (PFNGLRENDERBUFFERSTORAGEPROC)load("glRenderbufferStorage");
	glad_glGetRenderbufferParameteriv = (PFNGLGETRENDERBUFFERPARAMETERIVPROC)load("glGetRenderbufferParameteriv");
	glad_glIsFramebuffer = (PFNGLISFRAMEBUFFERPROC)load("glIsFramebuffer");
	glad_glBindFramebuffer = (PFNGLBINDFRAMEBUFFERPROC)load("glBindFramebuffer");
	glad_glDeleteFramebuffers = (PFNGLDELETEFRAMEBUFFERSPROC)load("glDeleteFramebuffers");
	glad_glGenFramebuffers = (PFNGLGENFRAMEBUFFERSPROC)load("glGenFramebuffers");
	glad_glCheckFramebufferStatus = (PFNGLCHECKFRAMEBUFFERSTATUSPROC)load("glCheckFramebufferStatus");
	glad_glFramebufferTexture1D = (PFNGLFRAMEBUFFERTEXTURE1DPROC)load("glFramebufferTexture1D");
	glad_glFramebufferTexture2D = (PFNGLFRAMEBUFFERTEXTURE2DPROC)load("glFramebufferTexture2D");
	glad_glFramebufferTexture3D = (PFNGLFRAMEBUFFERTEXTURE3DPROC)load("glFramebufferTexture3D");
	glad_glFramebufferRenderbuffer = (PFNGLFRAMEBUFFERRENDERBUFFERPROC)load("glFramebufferRenderbuffer");
	glad_glGetFramebufferAttachmentParameteriv = (PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC)load("glGetFramebufferAttachmentParameteriv");
	glad_glGenerateMipmap = (PFNGLGENERATEMIPMAPPROC)load("glGenerateMipmap");
	glad_glBlitFramebuffer = (PFNGLBLITFRAMEBUFFERPROC)load("glBlitFramebuffer");
	glad_glRenderbufferStorageMultisample = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC)load("glRenderbufferStorageMultisample");
	glad_glFramebufferTextureLayer = (PFNGLFRAMEBUFFERTEXTURELAYERPROC)load("glFramebufferTextureLayer");
}
static void load_GL_ARB_geometry_shader4(GLADloadproc load) {
	if(!GLAD_GL_ARB_geometry_shader4) return;
	glad_glProgramParameteriARB = (PFNGLPROGRAMPARAMETERIARBPROC)load("glProgramParameteriARB");
	glad_glFramebufferTextureARB = (PFNGLFRAMEBUFFERTEXTUREARBPROC)load("glFramebufferTextureARB");
	glad_glFramebufferTextureLayerARB = (PFNGLFRAMEBUFFERTEXTURELAYERARBPROC)load("glFramebufferTextureLayerARB");
	glad_glFramebufferTextureFaceARB = (PFNGLFRAMEBUFFERTEXTUREFACEARBPROC)load("glFramebufferTextureFaceARB");
}
static void load_GL_ARB_get_program_binary(GLADloadproc load) {
	if(!GLAD_GL_ARB_get_program_binary) return;
	glad_glGetProgramBinary = (PFNGLGETPROGRAMBINARYPROC)load("glGetProgramBinary");
	glad_glProgramBinary = (PFNGLPROGRAMBINARYPROC)load("glProgramBinary");
	glad_glProgramParameteri = (PFNGLPROGRAMPARAMETERIPROC)load("glProgramParameteri");
}
static void load_GL_ARB_get_texture_sub_image(GLADloadproc load) {
	if(!GLAD_GL_ARB_get_texture_sub_image) return;
	glad_glGetTextureSubImage = (PFNGLGETTEXTURESUBIMAGEPROC)load("glGetTextureSubImage");
	glad_glGetCompressedTextureSubImage = (PFNGLGETCOMPRESSEDTEXTURESUBIMAGEPROC)load("glGetCompressedTextureSubImage");
}
static void load_GL_ARB_gpu_shader_fp64(GLADloadproc load) {
	if(!GLAD_GL_ARB_gpu_shader_fp64) return;
	glad_glUniform1d = (PFNGLUNIFORM1DPROC)load("glUniform1d");
	glad_glUniform2d = (PFNGLUNIFORM2DPROC)load("glUniform2d");
	glad_glUniform3d = (PFNGLUNIFORM3DPROC)load("glUniform3d");
	glad_glUniform4d = (PFNGLUNIFORM4DPROC)load("glUniform4d");
	glad_glUniform1dv = (PFNGLUNIFORM1DVPROC)load("glUniform1dv");
	glad_glUniform2dv = (PFNGLUNIFORM2DVPROC)load("glUniform2dv");
	glad_glUniform3dv = (PFNGLUNIFORM3DVPROC)load("glUniform3dv");
	glad_glUniform4dv = (PFNGLUNIFORM4DVPROC)load("glUniform4dv");
	glad_glUniformMatrix2dv = (PFNGLUNIFORMMATRIX2DVPROC)load("glUniformMatrix2dv");
	glad_glUniformMatrix3dv = (PFNGLUNIFORMMATRIX3DVPROC)load("glUniformMatrix3dv");
	glad_glUniformMatrix4dv = (PFNGLUNIFORMMATRIX4DVPROC)load("glUniformMatrix4dv");
	glad_glUniformMatrix2x3dv = (PFNGLUNIFORMMATRIX2X3DVPROC)load("glUniformMatrix2x3dv");
	glad_glUniformMatrix2x4dv = (PFNGLUNIFORMMATRIX2X4DVPROC)load("glUniformMatrix2x4dv");
	glad_glUniformMatrix3x2dv = (PFNGLUNIFORMMATRIX3X2DVPROC)load("glUniformMatrix3x2dv");
	glad_glUniformMatrix3x4dv = (PFNGLUNIFORMMATRIX3X4DVPROC)load("glUniformMatrix3x4dv");
	glad_glUniformMatrix4x2dv = (PFNGLUNIFORMMATRIX4X2DVPROC)load("glUniformMatrix4x2dv");
	glad_glUniformMatrix4x3dv = (PFNGLUNIFORMMATRIX4X3DVPROC)load("glUniformMatrix4x3dv");
	glad_glGetUniformdv = (PFNGLGETUNIFORMDVPROC)load("glGetUniformdv");
}
static void load_GL_ARB_gpu_shader_int64(GLADloadproc load) {
	if(!GLAD_GL_ARB_gpu_shader_int64) return;
	glad_glUniform1i64ARB = (PFNGLUNIFORM1I64ARBPROC)load("glUniform1i64ARB");
	glad_glUniform2i64ARB = (PFNGLUNIFORM2I64ARBPROC)load("glUniform2i64ARB");
	glad_glUniform3i64ARB = (PFNGLUNIFORM3I64ARBPROC)load("glUniform3i64ARB");
	glad_glUniform4i64ARB = (PFNGLUNIFORM4I64ARBPROC)load("glUniform4i64ARB");
	glad_glUniform1i64vARB = (PFNGLUNIFORM1I64VARBPROC)load("glUniform1i64vARB");
	glad_glUniform2i64vARB = (PFNGLUNIFORM2I64VARBPROC)load("glUniform2i64vARB");
	glad_glUniform3i64vARB = (PFNGLUNIFORM3I64VARBPROC)load("glUniform3i64vARB");
	glad_glUniform4i64vARB = (PFNGLUNIFORM4I64VARBPROC)load("glUniform4i64vARB");
	glad_glUniform1ui64ARB = (PFNGLUNIFORM1UI64ARBPROC)load("glUniform1ui64ARB");
	glad_glUniform2ui64ARB = (PFNGLUNIFORM2UI64ARBPROC)load("glUniform2ui64ARB");
	glad_glUniform3ui64ARB = (PFNGLUNIFORM3UI64ARBPROC)load("glUniform3ui64ARB");
	glad_glUniform4ui64ARB = (PFNGLUNIFORM4UI64ARBPROC)load("glUniform4ui64ARB");
	glad_glUniform1ui64vARB = (PFNGLUNIFORM1UI64VARBPROC)load("glUniform1ui64vARB");
	glad_glUniform2ui64vARB = (PFNGLUNIFORM2UI64VARBPROC)load("glUniform2ui64vARB");
	glad_glUniform3ui64vARB = (PFNGLUNIFORM3UI64VARBPROC)load("glUniform3ui64vARB");
	glad_glUniform4ui64vARB = (PFNGLUNIFORM4UI64VARBPROC)load("glUniform4ui64vARB");
	glad_glGetUniformi64vARB = (PFNGLGETUNIFORMI64VARBPROC)load("glGetUniformi64vARB");
	glad_glGetUniformui64vARB = (PFNGLGETUNIFORMUI64VARBPROC)load("glGetUniformui64vARB");
	glad_glGetnUniformi64vARB = (PFNGLGETNUNIFORMI64VARBPROC)load("glGetnUniformi64vARB");
	glad_glGetnUniformui64vARB = (PFNGLGETNUNIFORMUI64VARBPROC)load("glGetnUniformui64vARB");
	glad_glProgramUniform1i64ARB = (PFNGLPROGRAMUNIFORM1I64ARBPROC)load("glProgramUniform1i64ARB");
	glad_glProgramUniform2i64ARB = (PFNGLPROGRAMUNIFORM2I64ARBPROC)load("glProgramUniform2i64ARB");
	glad_glProgramUniform3i64ARB = (PFNGLPROGRAMUNIFORM3I64ARBPROC)load("glProgramUniform3i64ARB");
	glad_glProgramUniform4i64ARB = (PFNGLPROGRAMUNIFORM4I64ARBPROC)load("glProgramUniform4i64ARB");
	glad_glProgramUniform1i64vARB = (PFNGLPROGRAMUNIFORM1I64VARBPROC)load("glProgramUniform1i64vARB");
	glad_glProgramUniform2i64vARB = (PFNGLPROGRAMUNIFORM2I64VARBPROC)load("glProgramUniform2i64vARB");
	glad_glProgramUniform3i64vARB = (PFNGLPROGRAMUNIFORM3I64VARBPROC)load("glProgramUniform3i64vARB");
	glad_glProgramUniform4i64vARB = (PFNGLPROGRAMUNIFORM4I64VARBPROC)load("glProgramUniform4i64vARB");
	glad_glProgramUniform1ui64ARB = (PFNGLPROGRAMUNIFORM1UI64ARBPROC)load("glProgramUniform1ui64ARB");
	glad_glProgramUniform2ui64ARB = (PFNGLPROGRAMUNIFORM2UI64ARBPROC)load("glProgramUniform2ui64ARB");
	glad_glProgramUniform3ui64ARB = (PFNGLPROGRAMUNIFORM3UI64ARBPROC)load("glProgramUniform3ui64ARB");
	glad_glProgramUniform4ui64ARB = (PFNGLPROGRAMUNIFORM4UI64ARBPROC)load("glProgramUniform4ui64ARB");
	glad_glProgramUniform1ui64vARB = (PFNGLPROGRAMUNIFORM1UI64VARBPROC)load("glProgramUniform1ui64vARB");
	glad_glProgramUniform2ui64vARB = (PFNGLPROGRAMUNIFORM2UI64VARBPROC)load("glProgramUniform2ui64vARB");
	glad_glProgramUniform3ui64vARB = (PFNGLPROGRAMUNIFORM3UI64VARBPROC)load("glProgramUniform3ui64vARB");
	glad_glProgramUniform4ui64vARB = (PFNGLPROGRAMUNIFORM4UI64VARBPROC)load("glProgramUniform4ui64vARB");
}
static void load_GL_ARB_imaging(GLADloadproc load) {
	if(!GLAD_GL_ARB_imaging) return;
	glad_glBlendColor = (PFNGLBLENDCOLORPROC)load("glBlendColor");
	glad_glBlendEquation = (PFNGLBLENDEQUATIONPROC)load("glBlendEquation");
	glad_glColorTable = (PFNGLCOLORTABLEPROC)load("glColorTable");
	glad_glColorTableParameterfv = (PFNGLCOLORTABLEPARAMETERFVPROC)load("glColorTableParameterfv");
	glad_glColorTableParameteriv = (PFNGLCOLORTABLEPARAMETERIVPROC)load("glColorTableParameteriv");
	glad_glCopyColorTable = (PFNGLCOPYCOLORTABLEPROC)load("glCopyColorTable");
	glad_glGetColorTable = (PFNGLGETCOLORTABLEPROC)load("glGetColorTable");
	glad_glGetColorTableParameterfv = (PFNGLGETCOLORTABLEPARAMETERFVPROC)load("glGetColorTableParameterfv");
	glad_glGetColorTableParameteriv = (PFNGLGETCOLORTABLEPARAMETERIVPROC)load("glGetColorTableParameteriv");
	glad_glColorSubTable = (PFNGLCOLORSUBTABLEPROC)load("glColorSubTable");
	glad_glCopyColorSubTable = (PFNGLCOPYCOLORSUBTABLEPROC)load("glCopyColorSubTable");
	glad_glConvolutionFilter1D = (PFNGLCONVOLUTIONFILTER1DPROC)load("glConvolutionFilter1D");
	glad_glConvolutionFilter2D = (PFNGLCONVOLUTIONFILTER2DPROC)load("glConvolutionFilter2D");
	glad_glConvolutionParameterf = (PFNGLCONVOLUTIONPARAMETERFPROC)load("glConvolutionParameterf");
	glad_glConvolutionParameterfv = (PFNGLCONVOLUTIONPARAMETERFVPROC)load("glConvolutionParameterfv");
	glad_glConvolutionParameteri = (PFNGLCONVOLUTIONPARAMETERIPROC)load("glConvolutionParameteri");
	glad_glConvolutionParameteriv = (PFNGLCONVOLUTIONPARAMETERIVPROC)load("glConvolutionParameteriv");
	glad_glCopyConvolutionFilter1D = (PFNGLCOPYCONVOLUTIONFILTER1DPROC)load("glCopyConvolutionFilter1D");
	glad_glCopyConvolutionFilter2D = (PFNGLCOPYCONVOLUTIONFILTER2DPROC)load("glCopyConvolutionFilter2D");
	glad_glGetConvolutionFilter = (PFNGLGETCONVOLUTIONFILTERPROC)load("glGetConvolutionFilter");
	glad_glGetConvolutionParameterfv = (PFNGLGETCONVOLUTIONPARAMETERFVPROC)load("glGetConvolutionParameterfv");
	glad_glGetConvolutionParameteriv = (PFNGLGETCONVOLUTIONPARAMETERIVPROC)load("glGetConvolutionParameteriv");
	glad_glGetSeparableFilter = (PFNGLGETSEPARABLEFILTERPROC)load("glGetSeparableFilter");
	glad_glSeparableFilter2D = (PFNGLSEPARABLEFILTER2DPROC)load("glSeparableFilter2D");
	glad_glGetHistogram = (PFNGLGETHISTOGRAMPROC)load("glGetHistogram");
	glad_glGetHistogramParameterfv = (PFNGLGETHISTOGRAMPARAMETERFVPROC)load("glGetHistogramParameterfv");
	glad_glGetHistogramParameteriv = (PFNGLGETHISTOGRAMPARAMETERIVPROC)load("glGetHistogramParameteriv");
	glad_glGetMinmax = (PFNGLGETMINMAXPROC)load("glGetMinmax");
	glad_glGetMinmaxParameterfv = (PFNGLGETMINMAXPARAMETERFVPROC)load("glGetMinmaxParameterfv");
	glad_glGetMinmaxParameteriv = (PFNGLGETMINMAXPARAMETERIVPROC)load("glGetMinmaxParameteriv");
	glad_glHistogram = (PFNGLHISTOGRAMPROC)load("glHistogram");
	glad_glMinmax = (PFNGLMINMAXPROC)load("glMinmax");
	glad_glResetHistogram = (PFNGLRESETHISTOGRAMPROC)load("glResetHistogram");
	glad_glResetMinmax = (PFNGLRESETMINMAXPROC)load("glResetMinmax");
}
static void load_GL_ARB_indirect_parameters(GLADloadproc load) {
	if(!GLAD_GL_ARB_indirect_parameters) return;
	glad_glMultiDrawArraysIndirectCountARB = (PFNGLMULTIDRAWARRAYSINDIRECTCOUNTARBPROC)load("glMultiDrawArraysIndirectCountARB");
	glad_glMultiDrawElementsIndirectCountARB = (PFNGLMULTIDRAWELEMENTSINDIRECTCOUNTARBPROC)load("glMultiDrawElementsIndirectCountARB");
}
static void load_GL_ARB_instanced_arrays(GLADloadproc load) {
	if(!GLAD_GL_ARB_instanced_arrays) return;
	glad_glVertexAttribDivisorARB = (PFNGLVERTEXATTRIBDIVISORARBPROC)load("glVertexAttribDivisorARB");
}
static void load_GL_ARB_internalformat_query(GLADloadproc load) {
	if(!GLAD_GL_ARB_internalformat_query) return;
	glad_glGetInternalformativ = (PFNGLGETINTERNALFORMATIVPROC)load("glGetInternalformativ");
}
static void load_GL_ARB_internalformat_query2(GLADloadproc load) {
	if(!GLAD_GL_ARB_internalformat_query2) return;
	glad_glGetInternalformati64v = (PFNGLGETINTERNALFORMATI64VPROC)load("glGetInternalformati64v");
}
static void load_GL_ARB_invalidate_subdata(GLADloadproc load) {
	if(!GLAD_GL_ARB_invalidate_subdata) return;
	glad_glInvalidateTexSubImage = (PFNGLINVALIDATETEXSUBIMAGEPROC)load("glInvalidateTexSubImage");
	glad_glInvalidateTexImage = (PFNGLINVALIDATETEXIMAGEPROC)load("glInvalidateTexImage");
	glad_glInvalidateBufferSubData = (PFNGLINVALIDATEBUFFERSUBDATAPROC)load("glInvalidateBufferSubData");
	glad_glInvalidateBufferData = (PFNGLINVALIDATEBUFFERDATAPROC)load("glInvalidateBufferData");
	glad_glInvalidateFramebuffer = (PFNGLINVALIDATEFRAMEBUFFERPROC)load("glInvalidateFramebuffer");
	glad_glInvalidateSubFramebuffer = (PFNGLINVALIDATESUBFRAMEBUFFERPROC)load("glInvalidateSubFramebuffer");
}
static void load_GL_ARB_map_buffer_range(GLADloadproc load) {
	if(!GLAD_GL_ARB_map_buffer_range) return;
	glad_glMapBufferRange = (PFNGLMAPBUFFERRANGEPROC)load("glMapBufferRange");
	glad_glFlushMappedBufferRange = (PFNGLFLUSHMAPPEDBUFFERRANGEPROC)load("glFlushMappedBufferRange");
}
static void load_GL_ARB_matrix_palette(GLADloadproc load) {
	if(!GLAD_GL_ARB_matrix_palette) return;
	glad_glCurrentPaletteMatrixARB = (PFNGLCURRENTPALETTEMATRIXARBPROC)load("glCurrentPaletteMatrixARB");
	glad_glMatrixIndexubvARB = (PFNGLMATRIXINDEXUBVARBPROC)load("glMatrixIndexubvARB");
	glad_glMatrixIndexusvARB = (PFNGLMATRIXINDEXUSVARBPROC)load("glMatrixIndexusvARB");
	glad_glMatrixIndexuivARB = (PFNGLMATRIXINDEXUIVARBPROC)load("glMatrixIndexuivARB");
	glad_glMatrixIndexPointerARB = (PFNGLMATRIXINDEXPOINTERARBPROC)load("glMatrixIndexPointerARB");
}
static void load_GL_ARB_multi_bind(GLADloadproc load) {
	if(!GLAD_GL_ARB_multi_bind) return;
	glad_glBindBuffersBase = (PFNGLBINDBUFFERSBASEPROC)load("glBindBuffersBase");
	glad_glBindBuffersRange = (PFNGLBINDBUFFERSRANGEPROC)load("glBindBuffersRange");
	glad_glBindTextures = (PFNGLBINDTEXTURESPROC)load("glBindTextures");
	glad_glBindSamplers = (PFNGLBINDSAMPLERSPROC)load("glBindSamplers");
	glad_glBindImageTextures = (PFNGLBINDIMAGETEXTURESPROC)load("glBindImageTextures");
	glad_glBindVertexBuffers = (PFNGLBINDVERTEXBUFFERSPROC)load("glBindVertexBuffers");
}
static void load_GL_ARB_multi_draw_indirect(GLADloadproc load) {
	if(!GLAD_GL_ARB_multi_draw_indirect) return;
	glad_glMultiDrawArraysIndirect = (PFNGLMULTIDRAWARRAYSINDIRECTPROC)load("glMultiDrawArraysIndirect");
	glad_glMultiDrawElementsIndirect = (PFNGLMULTIDRAWELEMENTSINDIRECTPROC)load("glMultiDrawElementsIndirect");
}
static void load_GL_ARB_multisample(GLADloadproc load) {
	if(!GLAD_GL_ARB_multisample) return;
	glad_glSampleCoverageARB = (PFNGLSAMPLECOVERAGEARBPROC)load("glSampleCoverageARB");
}
static void load_GL_ARB_multitexture(GLADloadproc load) {
	if(!GLAD_GL_ARB_multitexture) return;
	glad_glActiveTextureARB = (PFNGLACTIVETEXTUREARBPROC)load("glActiveTextureARB");
	glad_glClientActiveTextureARB = (PFNGLCLIENTACTIVETEXTUREARBPROC)load("glClientActiveTextureARB");
	glad_glMultiTexCoord1dARB = (PFNGLMULTITEXCOORD1DARBPROC)load("glMultiTexCoord1dARB");
	glad_glMultiTexCoord1dvARB = (PFNGLMULTITEXCOORD1DVARBPROC)load("glMultiTexCoord1dvARB");
	glad_glMultiTexCoord1fARB = (PFNGLMULTITEXCOORD1FARBPROC)load("glMultiTexCoord1fARB");
	glad_glMultiTexCoord1fvARB = (PFNGLMULTITEXCOORD1FVARBPROC)load("glMultiTexCoord1fvARB");
	glad_glMultiTexCoord1iARB = (PFNGLMULTITEXCOORD1IARBPROC)load("glMultiTexCoord1iARB");
	glad_glMultiTexCoord1ivARB = (PFNGLMULTITEXCOORD1IVARBPROC)load("glMultiTexCoord1ivARB");
	glad_glMultiTexCoord1sARB = (PFNGLMULTITEXCOORD1SARBPROC)load("glMultiTexCoord1sARB");
	glad_glMultiTexCoord1svARB = (PFNGLMULTITEXCOORD1SVARBPROC)load("glMultiTexCoord1svARB");
	glad_glMultiTexCoord2dARB = (PFNGLMULTITEXCOORD2DARBPROC)load("glMultiTexCoord2dARB");
	glad_glMultiTexCoord2dvARB = (PFNGLMULTITEXCOORD2DVARBPROC)load("glMultiTexCoord2dvARB");
	glad_glMultiTexCoord2fARB = (PFNGLMULTITEXCOORD2FARBPROC)load("glMultiTexCoord2fARB");
	glad_glMultiTexCoord2fvARB = (PFNGLMULTITEXCOORD2FVARBPROC)load("glMultiTexCoord2fvARB");
	glad_glMultiTexCoord2iARB = (PFNGLMULTITEXCOORD2IARBPROC)load("glMultiTexCoord2iARB");
	glad_glMultiTexCoord2ivARB = (PFNGLMULTITEXCOORD2IVARBPROC)load("glMultiTexCoord2ivARB");
	glad_glMultiTexCoord2sARB = (PFNGLMULTITEXCOORD2SARBPROC)load("glMultiTexCoord2sARB");
	glad_glMultiTexCoord2svARB = (PFNGLMULTITEXCOORD2SVARBPROC)load("glMultiTexCoord2svARB");
	glad_glMultiTexCoord3dARB = (PFNGLMULTITEXCOORD3DARBPROC)load("glMultiTexCoord3dARB");
	glad_glMultiTexCoord3dvARB = (PFNGLMULTITEXCOORD3DVARBPROC)load("glMultiTexCoord3dvARB");
	glad_glMultiTexCoord3fARB = (PFNGLMULTITEXCOORD3FARBPROC)load("glMultiTexCoord3fARB");
	glad_glMultiTexCoord3fvARB = (PFNGLMULTITEXCOORD3FVARBPROC)load("glMultiTexCoord3fvARB");
	glad_glMultiTexCoord3iARB = (PFNGLMULTITEXCOORD3IARBPROC)load("glMultiTexCoord3iARB");
	glad_glMultiTexCoord3ivARB = (PFNGLMULTITEXCOORD3IVARBPROC)load("glMultiTexCoord3ivARB");
	glad_glMultiTexCoord3sARB = (PFNGLMULTITEXCOORD3SARBPROC)load("glMultiTexCoord3sARB");
	glad_glMultiTexCoord3svARB = (PFNGLMULTITEXCOORD3SVARBPROC)load("glMultiTexCoord3svARB");
	glad_glMultiTexCoord4dARB = (PFNGLMULTITEXCOORD4DARBPROC)load("glMultiTexCoord4dARB");
	glad_glMultiTexCoord4dvARB = (PFNGLMULTITEXCOORD4DVARBPROC)load("glMultiTexCoord4dvARB");
	glad_glMultiTexCoord4fARB = (PFNGLMULTITEXCOORD4FARBPROC)load("glMultiTexCoord4fARB");
	glad_glMultiTexCoord4fvARB = (PFNGLMULTITEXCOORD4FVARBPROC)load("glMultiTexCoord4fvARB");
	glad_glMultiTexCoord4iARB = (PFNGLMULTITEXCOORD4IARBPROC)load("glMultiTexCoord4iARB");
	glad_glMultiTexCoord4ivARB = (PFNGLMULTITEXCOORD4IVARBPROC)load("glMultiTexCoord4ivARB");
	glad_glMultiTexCoord4sARB = (PFNGLMULTITEXCOORD4SARBPROC)load("glMultiTexCoord4sARB");
	glad_glMultiTexCoord4svARB = (PFNGLMULTITEXCOORD4SVARBPROC)load("glMultiTexCoord4svARB");
}
static void load_GL_ARB_occlusion_query(GLADloadproc load) {
	if(!GLAD_GL_ARB_occlusion_query) return;
	glad_glGenQueriesARB = (PFNGLGENQUERIESARBPROC)load("glGenQueriesARB");
	glad_glDeleteQueriesARB = (PFNGLDELETEQUERIESARBPROC)load("glDeleteQueriesARB");
	glad_glIsQueryARB = (PFNGLISQUERYARBPROC)load("glIsQueryARB");
	glad_glBeginQueryARB = (PFNGLBEGINQUERYARBPROC)load("glBeginQueryARB");
	glad_glEndQueryARB = (PFNGLENDQUERYARBPROC)load("glEndQueryARB");
	glad_glGetQueryivARB = (PFNGLGETQUERYIVARBPROC)load("glGetQueryivARB");
	glad_glGetQueryObjectivARB = (PFNGLGETQUERYOBJECTIVARBPROC)load("glGetQueryObjectivARB");
	glad_glGetQueryObjectuivARB = (PFNGLGETQUERYOBJECTUIVARBPROC)load("glGetQueryObjectuivARB");
}
static void load_GL_ARB_parallel_shader_compile(GLADloadproc load) {
	if(!GLAD_GL_ARB_parallel_shader_compile) return;
	glad_glMaxShaderCompilerThreadsARB = (PFNGLMAXSHADERCOMPILERTHREADSARBPROC)load("glMaxShaderCompilerThreadsARB");
}
static void load_GL_ARB_point_parameters(GLADloadproc load) {
	if(!GLAD_GL_ARB_point_parameters) return;
	glad_glPointParameterfARB = (PFNGLPOINTPARAMETERFARBPROC)load("glPointParameterfARB");
	glad_glPointParameterfvARB = (PFNGLPOINTPARAMETERFVARBPROC)load("glPointParameterfvARB");
}
static void load_GL_ARB_program_interface_query(GLADloadproc load) {
	if(!GLAD_GL_ARB_program_interface_query) return;
	glad_glGetProgramInterfaceiv = (PFNGLGETPROGRAMINTERFACEIVPROC)load("glGetProgramInterfaceiv");
	glad_glGetProgramResourceIndex = (PFNGLGETPROGRAMRESOURCEINDEXPROC)load("glGetProgramResourceIndex");
	glad_glGetProgramResourceName = (PFNGLGETPROGRAMRESOURCENAMEPROC)load("glGetProgramResourceName");
	glad_glGetProgramResourceiv = (PFNGLGETPROGRAMRESOURCEIVPROC)load("glGetProgramResourceiv");
	glad_glGetProgramResourceLocation = (PFNGLGETPROGRAMRESOURCELOCATIONPROC)load("glGetProgramResourceLocation");
	glad_glGetProgramResourceLocationIndex = (PFNGLGETPROGRAMRESOURCELOCATIONINDEXPROC)load("glGetProgramResourceLocationIndex");
}
static void load_GL_ARB_provoking_vertex(GLADloadproc load) {
	if(!GLAD_GL_ARB_provoking_vertex) return;
	glad_glProvokingVertex = (PFNGLPROVOKINGVERTEXPROC)load("glProvokingVertex");
}
static void load_GL_ARB_robustness(GLADloadproc load) {
	if(!GLAD_GL_ARB_robustness) return;
	glad_glGetGraphicsResetStatusARB = (PFNGLGETGRAPHICSRESETSTATUSARBPROC)load("glGetGraphicsResetStatusARB");
	glad_glGetnTexImageARB = (PFNGLGETNTEXIMAGEARBPROC)load("glGetnTexImageARB");
	glad_glReadnPixelsARB = (PFNGLREADNPIXELSARBPROC)load("glReadnPixelsARB");
	glad_glGetnCompressedTexImageARB = (PFNGLGETNCOMPRESSEDTEXIMAGEARBPROC)load("glGetnCompressedTexImageARB");
	glad_glGetnUniformfvARB = (PFNGLGETNUNIFORMFVARBPROC)load("glGetnUniformfvARB");
	glad_glGetnUniformivARB = (PFNGLGETNUNIFORMIVARBPROC)load("glGetnUniformivARB");
	glad_glGetnUniformuivARB = (PFNGLGETNUNIFORMUIVARBPROC)load("glGetnUniformuivARB");
	glad_glGetnUniformdvARB = (PFNGLGETNUNIFORMDVARBPROC)load("glGetnUniformdvARB");
	glad_glGetnMapdvARB = (PFNGLGETNMAPDVARBPROC)load("glGetnMapdvARB");
	glad_glGetnMapfvARB = (PFNGLGETNMAPFVARBPROC)load("glGetnMapfvARB");
	glad_glGetnMapivARB = (PFNGLGETNMAPIVARBPROC)load("glGetnMapivARB");
	glad_glGetnPixelMapfvARB = (PFNGLGETNPIXELMAPFVARBPROC)load("glGetnPixelMapfvARB");
	glad_glGetnPixelMapuivARB = (PFNGLGETNPIXELMAPUIVARBPROC)load("glGetnPixelMapuivARB");
	glad_glGetnPixelMapusvARB = (PFNGLGETNPIXELMAPUSVARBPROC)load("glGetnPixelMapusvARB");
	glad_glGetnPolygonStippleARB = (PFNGLGETNPOLYGONSTIPPLEARBPROC)load("glGetnPolygonStippleARB");
	glad_glGetnColorTableARB = (PFNGLGETNCOLORTABLEARBPROC)load("glGetnColorTableARB");
	glad_glGetnConvolutionFilterARB = (PFNGLGETNCONVOLUTIONFILTERARBPROC)load("glGetnConvolutionFilterARB");
	glad_glGetnSeparableFilterARB = (PFNGLGETNSEPARABLEFILTERARBPROC)load("glGetnSeparableFilterARB");
	glad_glGetnHistogramARB = (PFNGLGETNHISTOGRAMARBPROC)load("glGetnHistogramARB");
	glad_glGetnMinmaxARB = (PFNGLGETNMINMAXARBPROC)load("glGetnMinmaxARB");
}
static void load_GL_ARB_sample_locations(GLADloadproc load) {
	if(!GLAD_GL_ARB_sample_locations) return;
	glad_glFramebufferSampleLocationsfvARB = (PFNGLFRAMEBUFFERSAMPLELOCATIONSFVARBPROC)load("glFramebufferSampleLocationsfvARB");
	glad_glNamedFramebufferSampleLocationsfvARB = (PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVARBPROC)load("glNamedFramebufferSampleLocationsfvARB");
	glad_glEvaluateDepthValuesARB = (PFNGLEVALUATEDEPTHVALUESARBPROC)load("glEvaluateDepthValuesARB");
}
static void load_GL_ARB_sample_shading(GLADloadproc load) {
	if(!GLAD_GL_ARB_sample_shading) return;
	glad_glMinSampleShadingARB = (PFNGLMINSAMPLESHADINGARBPROC)load("glMinSampleShadingARB");
}
static void load_GL_ARB_sampler_objects(GLADloadproc load) {
	if(!GLAD_GL_ARB_sampler_objects) return;
	glad_glGenSamplers = (PFNGLGENSAMPLERSPROC)load("glGenSamplers");
	glad_glDeleteSamplers = (PFNGLDELETESAMPLERSPROC)load("glDeleteSamplers");
	glad_glIsSampler = (PFNGLISSAMPLERPROC)load("glIsSampler");
	glad_glBindSampler = (PFNGLBINDSAMPLERPROC)load("glBindSampler");
	glad_glSamplerParameteri = (PFNGLSAMPLERPARAMETERIPROC)load("glSamplerParameteri");
	glad_glSamplerParameteriv = (PFNGLSAMPLERPARAMETERIVPROC)load("glSamplerParameteriv");
	glad_glSamplerParameterf = (PFNGLSAMPLERPARAMETERFPROC)load("glSamplerParameterf");
	glad_glSamplerParameterfv = (PFNGLSAMPLERPARAMETERFVPROC)load("glSamplerParameterfv");
	glad_glSamplerParameterIiv = (PFNGLSAMPLERPARAMETERIIVPROC)load("glSamplerParameterIiv");
	glad_glSamplerParameterIuiv = (PFNGLSAMPLERPARAMETERIUIVPROC)load("glSamplerParameterIuiv");
	glad_glGetSamplerParameteriv = (PFNGLGETSAMPLERPARAMETERIVPROC)load("glGetSamplerParameteriv");
	glad_glGetSamplerParameterIiv = (PFNGLGETSAMPLERPARAMETERIIVPROC)load("glGetSamplerParameterIiv");
	glad_glGetSamplerParameterfv = (PFNGLGETSAMPLERPARAMETERFVPROC)load("glGetSamplerParameterfv");
	glad_glGetSamplerParameterIuiv = (PFNGLGETSAMPLERPARAMETERIUIVPROC)load("glGetSamplerParameterIuiv");
}
static void load_GL_ARB_separate_shader_objects(GLADloadproc load) {
	if(!GLAD_GL_ARB_separate_shader_objects) return;
	glad_glUseProgramStages = (PFNGLUSEPROGRAMSTAGESPROC)load("glUseProgramStages");
	glad_glActiveShaderProgram = (PFNGLACTIVESHADERPROGRAMPROC)load("glActiveShaderProgram");
	glad_glCreateShaderProgramv = (PFNGLCREATESHADERPROGRAMVPROC)load("glCreateShaderProgramv");
	glad_glBindProgramPipeline = (PFNGLBINDPROGRAMPIPELINEPROC)load("glBindProgramPipeline");
	glad_glDeleteProgramPipelines = (PFNGLDELETEPROGRAMPIPELINESPROC)load("glDeleteProgramPipelines");
	glad_glGenProgramPipelines = (PFNGLGENPROGRAMPIPELINESPROC)load("glGenProgramPipelines");
	glad_glIsProgramPipeline = (PFNGLISPROGRAMPIPELINEPROC)load("glIsProgramPipeline");
	glad_glGetProgramPipelineiv = (PFNGLGETPROGRAMPIPELINEIVPROC)load("glGetProgramPipelineiv");
	glad_glProgramUniform1i = (PFNGLPROGRAMUNIFORM1IPROC)load("glProgramUniform1i");
	glad_glProgramUniform1iv = (PFNGLPROGRAMUNIFORM1IVPROC)load("glProgramUniform1iv");
	glad_glProgramUniform1f = (PFNGLPROGRAMUNIFORM1FPROC)load("glProgramUniform1f");
	glad_glProgramUniform1fv = (PFNGLPROGRAMUNIFORM1FVPROC)load("glProgramUniform1fv");
	glad_glProgramUniform1d = (PFNGLPROGRAMUNIFORM1DPROC)load("glProgramUniform1d");
	glad_glProgramUniform1dv = (PFNGLPROGRAMUNIFORM1DVPROC)load("glProgramUniform1dv");
	glad_glProgramUniform1ui = (PFNGLPROGRAMUNIFORM1UIPROC)load("glProgramUniform1ui");
	glad_glProgramUniform1uiv = (PFNGLPROGRAMUNIFORM1UIVPROC)load("glProgramUniform1uiv");
	glad_glProgramUniform2i = (PFNGLPROGRAMUNIFORM2IPROC)load("glProgramUniform2i");
	glad_glProgramUniform2iv = (PFNGLPROGRAMUNIFORM2IVPROC)load("glProgramUniform2iv");
	glad_glProgramUniform2f = (PFNGLPROGRAMUNIFORM2FPROC)load("glProgramUniform2f");
	glad_glProgramUniform2fv = (PFNGLPROGRAMUNIFORM2FVPROC)load("glProgramUniform2fv");
	glad_glProgramUniform2d = (PFNGLPROGRAMUNIFORM2DPROC)load("glProgramUniform2d");
	glad_glProgramUniform2dv = (PFNGLPROGRAMUNIFORM2DVPROC)load("glProgramUniform2dv");
	glad_glProgramUniform2ui = (PFNGLPROGRAMUNIFORM2UIPROC)load("glProgramUniform2ui");
	glad_glProgramUniform2uiv = (PFNGLPROGRAMUNIFORM2UIVPROC)load("glProgramUniform2uiv");
	glad_glProgramUniform3i = (PFNGLPROGRAMUNIFORM3IPROC)load("glProgramUniform3i");
	glad_glProgramUniform3iv = (PFNGLPROGRAMUNIFORM3IVPROC)load("glProgramUniform3iv");
	glad_glProgramUniform3f = (PFNGLPROGRAMUNIFORM3FPROC)load("glProgramUniform3f");
	glad_glProgramUniform3fv = (PFNGLPROGRAMUNIFORM3FVPROC)load("glProgramUniform3fv");
	glad_glProgramUniform3d = (PFNGLPROGRAMUNIFORM3DPROC)load("glProgramUniform3d");
	glad_glProgramUniform3dv = (PFNGLPROGRAMUNIFORM3DVPROC)load("glProgramUniform3dv");
	glad_glProgramUniform3ui = (PFNGLPROGRAMUNIFORM3UIPROC)load("glProgramUniform3ui");
	glad_glProgramUniform3uiv = (PFNGLPROGRAMUNIFORM3UIVPROC)load("glProgramUniform3uiv");
	glad_glProgramUniform4i = (PFNGLPROGRAMUNIFORM4IPROC)load("glProgramUniform4i");
	glad_glProgramUniform4iv = (PFNGLPROGRAMUNIFORM4IVPROC)load("glProgramUniform4iv");
	glad_glProgramUniform4f = (PFNGLPROGRAMUNIFORM4FPROC)load("glProgramUniform4f");
	glad_glProgramUniform4fv = (PFNGLPROGRAMUNIFORM4FVPROC)load("glProgramUniform4fv");
	glad_glProgramUniform4d = (PFNGLPROGRAMUNIFORM4DPROC)load("glProgramUniform4d");
	glad_glProgramUniform4dv = (PFNGLPROGRAMUNIFORM4DVPROC)load("glProgramUniform4dv");
	glad_glProgramUniform4ui = (PFNGLPROGRAMUNIFORM4UIPROC)load("glProgramUniform4ui");
	glad_glProgramUniform4uiv = (PFNGLPROGRAMUNIFORM4UIVPROC)load("glProgramUniform4uiv");
	glad_glProgramUniformMatrix2fv = (PFNGLPROGRAMUNIFORMMATRIX2FVPROC)load("glProgramUniformMatrix2fv");
	glad_glProgramUniformMatrix3fv = (PFNGLPROGRAMUNIFORMMATRIX3FVPROC)load("glProgramUniformMatrix3fv");
	glad_glProgramUniformMatrix4fv = (PFNGLPROGRAMUNIFORMMATRIX4FVPROC)load("glProgramUniformMatrix4fv");
	glad_glProgramUniformMatrix2dv = (PFNGLPROGRAMUNIFORMMATRIX2DVPROC)load("glProgramUniformMatrix2dv");
	glad_glProgramUniformMatrix3dv = (PFNGLPROGRAMUNIFORMMATRIX3DVPROC)load("glProgramUniformMatrix3dv");
	glad_glProgramUniformMatrix4dv = (PFNGLPROGRAMUNIFORMMATRIX4DVPROC)load("glProgramUniformMatrix4dv");
	glad_glProgramUniformMatrix2x3fv = (PFNGLPROGRAMUNIFORMMATRIX2X3FVPROC)load("glProgramUniformMatrix2x3fv");
	glad_glProgramUniformMatrix3x2fv = (PFNGLPROGRAMUNIFORMMATRIX3X2FVPROC)load("glProgramUniformMatrix3x2fv");
	glad_glProgramUniformMatrix2x4fv = (PFNGLPROGRAMUNIFORMMATRIX2X4FVPROC)load("glProgramUniformMatrix2x4fv");
	glad_glProgramUniformMatrix4x2fv = (PFNGLPROGRAMUNIFORMMATRIX4X2FVPROC)load("glProgramUniformMatrix4x2fv");
	glad_glProgramUniformMatrix3x4fv = (PFNGLPROGRAMUNIFORMMATRIX3X4FVPROC)load("glProgramUniformMatrix3x4fv");
	glad_glProgramUniformMatrix4x3fv = (PFNGLPROGRAMUNIFORMMATRIX4X3FVPROC)load("glProgramUniformMatrix4x3fv");
	glad_glProgramUniformMatrix2x3dv = (PFNGLPROGRAMUNIFORMMATRIX2X3DVPROC)load("glProgramUniformMatrix2x3dv");
	glad_glProgramUniformMatrix3x2dv = (PFNGLPROGRAMUNIFORMMATRIX3X2DVPROC)load("glProgramUniformMatrix3x2dv");
	glad_glProgramUniformMatrix2x4dv = (PFNGLPROGRAMUNIFORMMATRIX2X4DVPROC)load("glProgramUniformMatrix2x4dv");
	glad_glProgramUniformMatrix4x2dv = (PFNGLPROGRAMUNIFORMMATRIX4X2DVPROC)load("glProgramUniformMatrix4x2dv");
	glad_glProgramUniformMatrix3x4dv = (PFNGLPROGRAMUNIFORMMATRIX3X4DVPROC)load("glProgramUniformMatrix3x4dv");
	glad_glProgramUniformMatrix4x3dv = (PFNGLPROGRAMUNIFORMMATRIX4X3DVPROC)load("glProgramUniformMatrix4x3dv");
	glad_glValidateProgramPipeline = (PFNGLVALIDATEPROGRAMPIPELINEPROC)load("glValidateProgramPipeline");
	glad_glGetProgramPipelineInfoLog = (PFNGLGETPROGRAMPIPELINEINFOLOGPROC)load("glGetProgramPipelineInfoLog");
}
static void load_GL_ARB_shader_atomic_counters(GLADloadproc load) {
	if(!GLAD_GL_ARB_shader_atomic_counters) return;
	glad_glGetActiveAtomicCounterBufferiv = (PFNGLGETACTIVEATOMICCOUNTERBUFFERIVPROC)load("glGetActiveAtomicCounterBufferiv");
}
static void load_GL_ARB_shader_image_load_store(GLADloadproc load) {
	if(!GLAD_GL_ARB_shader_image_load_store) return;
	glad_glBindImageTexture = (PFNGLBINDIMAGETEXTUREPROC)load("glBindImageTexture");
	glad_glMemoryBarrier = (PFNGLMEMORYBARRIERPROC)load("glMemoryBarrier");
}
static void load_GL_ARB_shader_objects(GLADloadproc load) {
	if(!GLAD_GL_ARB_shader_objects) return;
	glad_glDeleteObjectARB = (PFNGLDELETEOBJECTARBPROC)load("glDeleteObjectARB");
	glad_glGetHandleARB = (PFNGLGETHANDLEARBPROC)load("glGetHandleARB");
	glad_glDetachObjectARB = (PFNGLDETACHOBJECTARBPROC)load("glDetachObjectARB");
	glad_glCreateShaderObjectARB = (PFNGLCREATESHADEROBJECTARBPROC)load("glCreateShaderObjectARB");
	glad_glShaderSourceARB = (PFNGLSHADERSOURCEARBPROC)load("glShaderSourceARB");
	glad_glCompileShaderARB = (PFNGLCOMPILESHADERARBPROC)load("glCompileShaderARB");
	glad_glCreateProgramObjectARB = (PFNGLCREATEPROGRAMOBJECTARBPROC)load("glCreateProgramObjectARB");
	glad_glAttachObjectARB = (PFNGLATTACHOBJECTARBPROC)load("glAttachObjectARB");
	glad_glLinkProgramARB = (PFNGLLINKPROGRAMARBPROC)load("glLinkProgramARB");
	glad_glUseProgramObjectARB = (PFNGLUSEPROGRAMOBJECTARBPROC)load("glUseProgramObjectARB");
	glad_glValidateProgramARB = (PFNGLVALIDATEPROGRAMARBPROC)load("glValidateProgramARB");
	glad_glUniform1fARB = (PFNGLUNIFORM1FARBPROC)load("glUniform1fARB");
	glad_glUniform2fARB = (PFNGLUNIFORM2FARBPROC)load("glUniform2fARB");
	glad_glUniform3fARB = (PFNGLUNIFORM3FARBPROC)load("glUniform3fARB");
	glad_glUniform4fARB = (PFNGLUNIFORM4FARBPROC)load("glUniform4fARB");
	glad_glUniform1iARB = (PFNGLUNIFORM1IARBPROC)load("glUniform1iARB");
	glad_glUniform2iARB = (PFNGLUNIFORM2IARBPROC)load("glUniform2iARB");
	glad_glUniform3iARB = (PFNGLUNIFORM3IARBPROC)load("glUniform3iARB");
	glad_glUniform4iARB = (PFNGLUNIFORM4IARBPROC)load("glUniform4iARB");
	glad_glUniform1fvARB = (PFNGLUNIFORM1FVARBPROC)load("glUniform1fvARB");
	glad_glUniform2fvARB = (PFNGLUNIFORM2FVARBPROC)load("glUniform2fvARB");
	glad_glUniform3fvARB = (PFNGLUNIFORM3FVARBPROC)load("glUniform3fvARB");
	glad_glUniform4fvARB = (PFNGLUNIFORM4FVARBPROC)load("glUniform4fvARB");
	glad_glUniform1ivARB = (PFNGLUNIFORM1IVARBPROC)load("glUniform1ivARB");
	glad_glUniform2ivARB = (PFNGLUNIFORM2IVARBPROC)load("glUniform2ivARB");
	glad_glUniform3ivARB = (PFNGLUNIFORM3IVARBPROC)load("glUniform3ivARB");
	glad_glUniform4ivARB = (PFNGLUNIFORM4IVARBPROC)load("glUniform4ivARB");
	glad_glUniformMatrix2fvARB = (PFNGLUNIFORMMATRIX2FVARBPROC)load("glUniformMatrix2fvARB");
	glad_glUniformMatrix3fvARB = (PFNGLUNIFORMMATRIX3FVARBPROC)load("glUniformMatrix3fvARB");
	glad_glUniformMatrix4fvARB = (PFNGLUNIFORMMATRIX4FVARBPROC)load("glUniformMatrix4fvARB");
	glad_glGetObjectParameterfvARB = (PFNGLGETOBJECTPARAMETERFVARBPROC)load("glGetObjectParameterfvARB");
	glad_glGetObjectParameterivARB = (PFNGLGETOBJECTPARAMETERIVARBPROC)load("glGetObjectParameterivARB");
	glad_glGetInfoLogARB = (PFNGLGETINFOLOGARBPROC)load("glGetInfoLogARB");
	glad_glGetAttachedObjectsARB = (PFNGLGETATTACHEDOBJECTSARBPROC)load("glGetAttachedObjectsARB");
	glad_glGetUniformLocationARB = (PFNGLGETUNIFORMLOCATIONARBPROC)load("glGetUniformLocationARB");
	glad_glGetActiveUniformARB = (PFNGLGETACTIVEUNIFORMARBPROC)load("glGetActiveUniformARB");
	glad_glGetUniformfvARB = (PFNGLGETUNIFORMFVARBPROC)load("glGetUniformfvARB");
	glad_glGetUniformivARB = (PFNGLGETUNIFORMIVARBPROC)load("glGetUniformivARB");
	glad_glGetShaderSourceARB = (PFNGLGETSHADERSOURCEARBPROC)load("glGetShaderSourceARB");
}
static void load_GL_ARB_shader_storage_buffer_object(GLADloadproc load) {
	if(!GLAD_GL_ARB_shader_storage_buffer_object) return;
	glad_glShaderStorageBlockBinding = (PFNGLSHADERSTORAGEBLOCKBINDINGPROC)load("glShaderStorageBlockBinding");
}
static void load_GL_ARB_shader_subroutine(GLADloadproc load) {
	if(!GLAD_GL_ARB_shader_subroutine) return;
	glad_glGetSubroutineUniformLocation = (PFNGLGETSUBROUTINEUNIFORMLOCATIONPROC)load("glGetSubroutineUniformLocation");
	glad_glGetSubroutineIndex = (PFNGLGETSUBROUTINEINDEXPROC)load("glGetSubroutineIndex");
	glad_glGetActiveSubroutineUniformiv = (PFNGLGETACTIVESUBROUTINEUNIFORMIVPROC)load("glGetActiveSubroutineUniformiv");
	glad_glGetActiveSubroutineUniformName = (PFNGLGETACTIVESUBROUTINEUNIFORMNAMEPROC)load("glGetActiveSubroutineUniformName");
	glad_glGetActiveSubroutineName = (PFNGLGETACTIVESUBROUTINENAMEPROC)load("glGetActiveSubroutineName");
	glad_glUniformSubroutinesuiv = (PFNGLUNIFORMSUBROUTINESUIVPROC)load("glUniformSubroutinesuiv");
	glad_glGetUniformSubroutineuiv = (PFNGLGETUNIFORMSUBROUTINEUIVPROC)load("glGetUniformSubroutineuiv");
	glad_glGetProgramStageiv = (PFNGLGETPROGRAMSTAGEIVPROC)load("glGetProgramStageiv");
}
static void load_GL_ARB_shading_language_include(GLADloadproc load) {
	if(!GLAD_GL_ARB_shading_language_include) return;
	glad_glNamedStringARB = (PFNGLNAMEDSTRINGARBPROC)load("glNamedStringARB");
	glad_glDeleteNamedStringARB = (PFNGLDELETENAMEDSTRINGARBPROC)load("glDeleteNamedStringARB");
	glad_glCompileShaderIncludeARB = (PFNGLCOMPILESHADERINCLUDEARBPROC)load("glCompileShaderIncludeARB");
	glad_glIsNamedStringARB = (PFNGLISNAMEDSTRINGARBPROC)load("glIsNamedStringARB");
	glad_glGetNamedStringARB = (PFNGLGETNAMEDSTRINGARBPROC)load("glGetNamedStringARB");
	glad_glGetNamedStringivARB = (PFNGLGETNAMEDSTRINGIVARBPROC)load("glGetNamedStringivARB");
}
static void load_GL_ARB_sparse_buffer(GLADloadproc load) {
	if(!GLAD_GL_ARB_sparse_buffer) return;
	glad_glBufferPageCommitmentARB = (PFNGLBUFFERPAGECOMMITMENTARBPROC)load("glBufferPageCommitmentARB");
	glad_glNamedBufferPageCommitmentEXT = (PFNGLNAMEDBUFFERPAGECOMMITMENTEXTPROC)load("glNamedBufferPageCommitmentEXT");
	glad_glNamedBufferPageCommitmentARB = (PFNGLNAMEDBUFFERPAGECOMMITMENTARBPROC)load("glNamedBufferPageCommitmentARB");
}
static void load_GL_ARB_sparse_texture(GLADloadproc load) {
	if(!GLAD_GL_ARB_sparse_texture) return;
	glad_glTexPageCommitmentARB = (PFNGLTEXPAGECOMMITMENTARBPROC)load("glTexPageCommitmentARB");
}
static void load_GL_ARB_sync(GLADloadproc load) {
	if(!GLAD_GL_ARB_sync) return;
	glad_glFenceSync = (PFNGLFENCESYNCPROC)load("glFenceSync");
	glad_glIsSync = (PFNGLISSYNCPROC)load("glIsSync");
	glad_glDeleteSync = (PFNGLDELETESYNCPROC)load("glDeleteSync");
	glad_glClientWaitSync = (PFNGLCLIENTWAITSYNCPROC)load("glClientWaitSync");
	glad_glWaitSync = (PFNGLWAITSYNCPROC)load("glWaitSync");
	glad_glGetInteger64v = (PFNGLGETINTEGER64VPROC)load("glGetInteger64v");
	glad_glGetSynciv = (PFNGLGETSYNCIVPROC)load("glGetSynciv");
}
static void load_GL_ARB_tessellation_shader(GLADloadproc load) {
	if(!GLAD_GL_ARB_tessellation_shader) return;
	glad_glPatchParameteri = (PFNGLPATCHPARAMETERIPROC)load("glPatchParameteri");
	glad_glPatchParameterfv = (PFNGLPATCHPARAMETERFVPROC)load("glPatchParameterfv");
}
static void load_GL_ARB_texture_barrier(GLADloadproc load) {
	if(!GLAD_GL_ARB_texture_barrier) return;
	glad_glTextureBarrier = (PFNGLTEXTUREBARRIERPROC)load("glTextureBarrier");
}
static void load_GL_ARB_texture_buffer_object(GLADloadproc load) {
	if(!GLAD_GL_ARB_texture_buffer_object) return;
	glad_glTexBufferARB = (PFNGLTEXBUFFERARBPROC)load("glTexBufferARB");
}
static void load_GL_ARB_texture_buffer_range(GLADloadproc load) {
	if(!GLAD_GL_ARB_texture_buffer_range) return;
	glad_glTexBufferRange = (PFNGLTEXBUFFERRANGEPROC)load("glTexBufferRange");
}
static void load_GL_ARB_texture_compression(GLADloadproc load) {
	if(!GLAD_GL_ARB_texture_compression) return;
	glad_glCompressedTexImage3DARB = (PFNGLCOMPRESSEDTEXIMAGE3DARBPROC)load("glCompressedTexImage3DARB");
	glad_glCompressedTexImage2DARB = (PFNGLCOMPRESSEDTEXIMAGE2DARBPROC)load("glCompressedTexImage2DARB");
	glad_glCompressedTexImage1DARB = (PFNGLCOMPRESSEDTEXIMAGE1DARBPROC)load("glCompressedTexImage1DARB");
	glad_glCompressedTexSubImage3DARB = (PFNGLCOMPRESSEDTEXSUBIMAGE3DARBPROC)load("glCompressedTexSubImage3DARB");
	glad_glCompressedTexSubImage2DARB = (PFNGLCOMPRESSEDTEXSUBIMAGE2DARBPROC)load("glCompressedTexSubImage2DARB");
	glad_glCompressedTexSubImage1DARB = (PFNGLCOMPRESSEDTEXSUBIMAGE1DARBPROC)load("glCompressedTexSubImage1DARB");
	glad_glGetCompressedTexImageARB = (PFNGLGETCOMPRESSEDTEXIMAGEARBPROC)load("glGetCompressedTexImageARB");
}
static void load_GL_ARB_texture_multisample(GLADloadproc load) {
	if(!GLAD_GL_ARB_texture_multisample) return;
	glad_glTexImage2DMultisample = (PFNGLTEXIMAGE2DMULTISAMPLEPROC)load("glTexImage2DMultisample");
	glad_glTexImage3DMultisample = (PFNGLTEXIMAGE3DMULTISAMPLEPROC)load("glTexImage3DMultisample");
	glad_glGetMultisamplefv = (PFNGLGETMULTISAMPLEFVPROC)load("glGetMultisamplefv");
	glad_glSampleMaski = (PFNGLSAMPLEMASKIPROC)load("glSampleMaski");
}
static void load_GL_ARB_texture_storage(GLADloadproc load) {
	if(!GLAD_GL_ARB_texture_storage) return;
	glad_glTexStorage1D = (PFNGLTEXSTORAGE1DPROC)load("glTexStorage1D");
	glad_glTexStorage2D = (PFNGLTEXSTORAGE2DPROC)load("glTexStorage2D");
	glad_glTexStorage3D = (PFNGLTEXSTORAGE3DPROC)load("glTexStorage3D");
}
static void load_GL_ARB_texture_storage_multisample(GLADloadproc load) {
	if(!GLAD_GL_ARB_texture_storage_multisample) return;
	glad_glTexStorage2DMultisample = (PFNGLTEXSTORAGE2DMULTISAMPLEPROC)load("glTexStorage2DMultisample");
	glad_glTexStorage3DMultisample = (PFNGLTEXSTORAGE3DMULTISAMPLEPROC)load("glTexStorage3DMultisample");
}
static void load_GL_ARB_texture_view(GLADloadproc load) {
	if(!GLAD_GL_ARB_texture_view) return;
	glad_glTextureView = (PFNGLTEXTUREVIEWPROC)load("glTextureView");
}
static void load_GL_ARB_timer_query(GLADloadproc load) {
	if(!GLAD_GL_ARB_timer_query) return;
	glad_glQueryCounter = (PFNGLQUERYCOUNTERPROC)load("glQueryCounter");
	glad_glGetQueryObjecti64v = (PFNGLGETQUERYOBJECTI64VPROC)load("glGetQueryObjecti64v");
	glad_glGetQueryObjectui64v = (PFNGLGETQUERYOBJECTUI64VPROC)load("glGetQueryObjectui64v");
}
static void load_GL_ARB_transform_feedback2(GLADloadproc load) {
	if(!GLAD_GL_ARB_transform_feedback2) return;
	glad_glBindTransformFeedback = (PFNGLBINDTRANSFORMFEEDBACKPROC)load("glBindTransformFeedback");
	glad_glDeleteTransformFeedbacks = (PFNGLDELETETRANSFORMFEEDBACKSPROC)load("glDeleteTransformFeedbacks");
	glad_glGenTransformFeedbacks = (PFNGLGENTRANSFORMFEEDBACKSPROC)load("glGenTransformFeedbacks");
	glad_glIsTransformFeedback = (PFNGLISTRANSFORMFEEDBACKPROC)load("glIsTransformFeedback");
	glad_glPauseTransformFeedback = (PFNGLPAUSETRANSFORMFEEDBACKPROC)load("glPauseTransformFeedback");
	glad_glResumeTransformFeedback = (PFNGLRESUMETRANSFORMFEEDBACKPROC)load("glResumeTransformFeedback");
	glad_glDrawTransformFeedback = (PFNGLDRAWTRANSFORMFEEDBACKPROC)load("glDrawTransformFeedback");
}
static void load_GL_ARB_transform_feedback3(GLADloadproc load) {
	if(!GLAD_GL_ARB_transform_feedback3) return;
	glad_glDrawTransformFeedbackStream = (PFNGLDRAWTRANSFORMFEEDBACKSTREAMPROC)load("glDrawTransformFeedbackStream");
	glad_glBeginQueryIndexed = (PFNGLBEGINQUERYINDEXEDPROC)load("glBeginQueryIndexed");
	glad_glEndQueryIndexed = (PFNGLENDQUERYINDEXEDPROC)load("glEndQueryIndexed");
	glad_glGetQueryIndexediv = (PFNGLGETQUERYINDEXEDIVPROC)load("glGetQueryIndexediv");
}
static void load_GL_ARB_transform_feedback_instanced(GLADloadproc load) {
	if(!GLAD_GL_ARB_transform_feedback_instanced) return;
	glad_glDrawTransformFeedbackInstanced = (PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDPROC)load("glDrawTransformFeedbackInstanced");
	glad_glDrawTransformFeedbackStreamInstanced = (PFNGLDRAWTRANSFORMFEEDBACKSTREAMINSTANCEDPROC)load("glDrawTransformFeedbackStreamInstanced");
}
static void load_GL_ARB_transpose_matrix(GLADloadproc load) {
	if(!GLAD_GL_ARB_transpose_matrix) return;
	glad_glLoadTransposeMatrixfARB = (PFNGLLOADTRANSPOSEMATRIXFARBPROC)load("glLoadTransposeMatrixfARB");
	glad_glLoadTransposeMatrixdARB = (PFNGLLOADTRANSPOSEMATRIXDARBPROC)load("glLoadTransposeMatrixdARB");
	glad_glMultTransposeMatrixfARB = (PFNGLMULTTRANSPOSEMATRIXFARBPROC)load("glMultTransposeMatrixfARB");
	glad_glMultTransposeMatrixdARB = (PFNGLMULTTRANSPOSEMATRIXDARBPROC)load("glMultTransposeMatrixdARB");
}
static void load_GL_ARB_uniform_buffer_object(GLADloadproc load) {
	if(!GLAD_GL_ARB_uniform_buffer_object) return;
	glad_glGetUniformIndices = (PFNGLGETUNIFORMINDICESPROC)load("glGetUniformIndices");
	glad_glGetActiveUniformsiv = (PFNGLGETACTIVEUNIFORMSIVPROC)load("glGetActiveUniformsiv");
	glad_glGetActiveUniformName = (PFNGLGETACTIVEUNIFORMNAMEPROC)load("glGetActiveUniformName");
	glad_glGetUniformBlockIndex = (PFNGLGETUNIFORMBLOCKINDEXPROC)load("glGetUniformBlockIndex");
	glad_glGetActiveUniformBlockiv = (PFNGLGETACTIVEUNIFORMBLOCKIVPROC)load("glGetActiveUniformBlockiv");
	glad_glGetActiveUniformBlockName = (PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC)load("glGetActiveUniformBlockName");
	glad_glUniformBlockBinding = (PFNGLUNIFORMBLOCKBINDINGPROC)load("glUniformBlockBinding");
	glad_glBindBufferRange = (PFNGLBINDBUFFERRANGEPROC)load("glBindBufferRange");
	glad_glBindBufferBase = (PFNGLBINDBUFFERBASEPROC)load("glBindBufferBase");
	glad_glGetIntegeri_v = (PFNGLGETINTEGERI_VPROC)load("glGetIntegeri_v");
}
static void load_GL_ARB_vertex_array_object(GLADloadproc load) {
	if(!GLAD_GL_ARB_vertex_array_object) return;
	glad_glBindVertexArray = (PFNGLBINDVERTEXARRAYPROC)load("glBindVertexArray");
	glad_glDeleteVertexArrays = (PFNGLDELETEVERTEXARRAYSPROC)load("glDeleteVertexArrays");
	glad_glGenVertexArrays = (PFNGLGENVERTEXARRAYSPROC)load("glGenVertexArrays");
	glad_glIsVertexArray = (PFNGLISVERTEXARRAYPROC)load("glIsVertexArray");
}
static void load_GL_ARB_vertex_attrib_64bit(GLADloadproc load) {
	if(!GLAD_GL_ARB_vertex_attrib_64bit) return;
	glad_glVertexAttribL1d = (PFNGLVERTEXATTRIBL1DPROC)load("glVertexAttribL1d");
	glad_glVertexAttribL2d = (PFNGLVERTEXATTRIBL2DPROC)load("glVertexAttribL2d");
	glad_glVertexAttribL3d = (PFNGLVERTEXATTRIBL3DPROC)load("glVertexAttribL3d");
	glad_glVertexAttribL4d = (PFNGLVERTEXATTRIBL4DPROC)load("glVertexAttribL4d");
	glad_glVertexAttribL1dv = (PFNGLVERTEXATTRIBL1DVPROC)load("glVertexAttribL1dv");
	glad_glVertexAttribL2dv = (PFNGLVERTEXATTRIBL2DVPROC)load("glVertexAttribL2dv");
	glad_glVertexAttribL3dv = (PFNGLVERTEXATTRIBL3DVPROC)load("glVertexAttribL3dv");
	glad_glVertexAttribL4dv = (PFNGLVERTEXATTRIBL4DVPROC)load("glVertexAttribL4dv");
	glad_glVertexAttribLPointer = (PFNGLVERTEXATTRIBLPOINTERPROC)load("glVertexAttribLPointer");
	glad_glGetVertexAttribLdv = (PFNGLGETVERTEXATTRIBLDVPROC)load("glGetVertexAttribLdv");
}
static void load_GL_ARB_vertex_attrib_binding(GLADloadproc load) {
	if(!GLAD_GL_ARB_vertex_attrib_binding) return;
	glad_glBindVertexBuffer = (PFNGLBINDVERTEXBUFFERPROC)load("glBindVertexBuffer");
	glad_glVertexAttribFormat = (PFNGLVERTEXATTRIBFORMATPROC)load("glVertexAttribFormat");
	glad_glVertexAttribIFormat = (PFNGLVERTEXATTRIBIFORMATPROC)load("glVertexAttribIFormat");
	glad_glVertexAttribLFormat = (PFNGLVERTEXATTRIBLFORMATPROC)load("glVertexAttribLFormat");
	glad_glVertexAttribBinding = (PFNGLVERTEXATTRIBBINDINGPROC)load("glVertexAttribBinding");
	glad_glVertexBindingDivisor = (PFNGLVERTEXBINDINGDIVISORPROC)load("glVertexBindingDivisor");
}
static void load_GL_ARB_vertex_blend(GLADloadproc load) {
	if(!GLAD_GL_ARB_vertex_blend) return;
	glad_glWeightbvARB = (PFNGLWEIGHTBVARBPROC)load("glWeightbvARB");
	glad_glWeightsvARB = (PFNGLWEIGHTSVARBPROC)load("glWeightsvARB");
	glad_glWeightivARB = (PFNGLWEIGHTIVARBPROC)load("glWeightivARB");
	glad_glWeightfvARB = (PFNGLWEIGHTFVARBPROC)load("glWeightfvARB");
	glad_glWeightdvARB = (PFNGLWEIGHTDVARBPROC)load("glWeightdvARB");
	glad_glWeightubvARB = (PFNGLWEIGHTUBVARBPROC)load("glWeightubvARB");
	glad_glWeightusvARB = (PFNGLWEIGHTUSVARBPROC)load("glWeightusvARB");
	glad_glWeightuivARB = (PFNGLWEIGHTUIVARBPROC)load("glWeightuivARB");
	glad_glWeightPointerARB = (PFNGLWEIGHTPOINTERARBPROC)load("glWeightPointerARB");
	glad_glVertexBlendARB = (PFNGLVERTEXBLENDARBPROC)load("glVertexBlendARB");
}
static void load_GL_ARB_vertex_buffer_object(GLADloadproc load) {
	if(!GLAD_GL_ARB_vertex_buffer_object) return;
	glad_glBindBufferARB = (PFNGLBINDBUFFERARBPROC)load("glBindBufferARB");
	glad_glDeleteBuffersARB = (PFNGLDELETEBUFFERSARBPROC)load("glDeleteBuffersARB");
	glad_glGenBuffersARB = (PFNGLGENBUFFERSARBPROC)load("glGenBuffersARB");
	glad_glIsBufferARB = (PFNGLISBUFFERARBPROC)load("glIsBufferARB");
	glad_glBufferDataARB = (PFNGLBUFFERDATAARBPROC)load("glBufferDataARB");
	glad_glBufferSubDataARB = (PFNGLBUFFERSUBDATAARBPROC)load("glBufferSubDataARB");
	glad_glGetBufferSubDataARB = (PFNGLGETBUFFERSUBDATAARBPROC)load("glGetBufferSubDataARB");
	glad_glMapBufferARB = (PFNGLMAPBUFFERARBPROC)load("glMapBufferARB");
	glad_glUnmapBufferARB = (PFNGLUNMAPBUFFERARBPROC)load("glUnmapBufferARB");
	glad_glGetBufferParameterivARB = (PFNGLGETBUFFERPARAMETERIVARBPROC)load("glGetBufferParameterivARB");
	glad_glGetBufferPointervARB = (PFNGLGETBUFFERPOINTERVARBPROC)load("glGetBufferPointervARB");
}
static void load_GL_ARB_vertex_program(GLADloadproc load) {
	if(!GLAD_GL_ARB_vertex_program) return;
	glad_glVertexAttrib1dARB = (PFNGLVERTEXATTRIB1DARBPROC)load("glVertexAttrib1dARB");
	glad_glVertexAttrib1dvARB = (PFNGLVERTEXATTRIB1DVARBPROC)load("glVertexAttrib1dvARB");
	glad_glVertexAttrib1fARB = (PFNGLVERTEXATTRIB1FARBPROC)load("glVertexAttrib1fARB");
	glad_glVertexAttrib1fvARB = (PFNGLVERTEXATTRIB1FVARBPROC)load("glVertexAttrib1fvARB");
	glad_glVertexAttrib1sARB = (PFNGLVERTEXATTRIB1SARBPROC)load("glVertexAttrib1sARB");
	glad_glVertexAttrib1svARB = (PFNGLVERTEXATTRIB1SVARBPROC)load("glVertexAttrib1svARB");
	glad_glVertexAttrib2dARB = (PFNGLVERTEXATTRIB2DARBPROC)load("glVertexAttrib2dARB");
	glad_glVertexAttrib2dvARB = (PFNGLVERTEXATTRIB2DVARBPROC)load("glVertexAttrib2dvARB");
	glad_glVertexAttrib2fARB = (PFNGLVERTEXATTRIB2FARBPROC)load("glVertexAttrib2fARB");
	glad_glVertexAttrib2fvARB = (PFNGLVERTEXATTRIB2FVARBPROC)load("glVertexAttrib2fvARB");
	glad_glVertexAttrib2sARB = (PFNGLVERTEXATTRIB2SARBPROC)load("glVertexAttrib2sARB");
	glad_glVertexAttrib2svARB = (PFNGLVERTEXATTRIB2SVARBPROC)load("glVertexAttrib2svARB");
	glad_glVertexAttrib3dARB = (PFNGLVERTEXATTRIB3DARBPROC)load("glVertexAttrib3dARB");
	glad_glVertexAttrib3dvARB = (PFNGLVERTEXATTRIB3DVARBPROC)load("glVertexAttrib3dvARB");
	glad_glVertexAttrib3fARB = (PFNGLVERTEXATTRIB3FARBPROC)load("glVertexAttrib3fARB");
	glad_glVertexAttrib3fvARB = (PFNGLVERTEXATTRIB3FVARBPROC)load("glVertexAttrib3fvARB");
	glad_glVertexAttrib3sARB = (PFNGLVERTEXATTRIB3SARBPROC)load("glVertexAttrib3sARB");
	glad_glVertexAttrib3svARB = (PFNGLVERTEXATTRIB3SVARBPROC)load("glVertexAttrib3svARB");
	glad_glVertexAttrib4NbvARB = (PFNGLVERTEXATTRIB4NBVARBPROC)load("glVertexAttrib4NbvARB");
	glad_glVertexAttrib4NivARB = (PFNGLVERTEXATTRIB4NIVARBPROC)load("glVertexAttrib4NivARB");
	glad_glVertexAttrib4NsvARB = (PFNGLVERTEXATTRIB4NSVARBPROC)load("glVertexAttrib4NsvARB");
	glad_glVertexAttrib4NubARB = (PFNGLVERTEXATTRIB4NUBARBPROC)load("glVertexAttrib4NubARB");
	glad_glVertexAttrib4NubvARB = (PFNGLVERTEXATTRIB4NUBVARBPROC)load("glVertexAttrib4NubvARB");
	glad_glVertexAttrib4NuivARB = (PFNGLVERTEXATTRIB4NUIVARBPROC)load("glVertexAttrib4NuivARB");
	glad_glVertexAttrib4NusvARB = (PFNGLVERTEXATTRIB4NUSVARBPROC)load("glVertexAttrib4NusvARB");
	glad_glVertexAttrib4bvARB = (PFNGLVERTEXATTRIB4BVARBPROC)load("glVertexAttrib4bvARB");
	glad_glVertexAttrib4dARB = (PFNGLVERTEXATTRIB4DARBPROC)load("glVertexAttrib4dARB");
	glad_glVertexAttrib4dvARB = (PFNGLVERTEXATTRIB4DVARBPROC)load("glVertexAttrib4dvARB");
	glad_glVertexAttrib4fARB = (PFNGLVERTEXATTRIB4FARBPROC)load("glVertexAttrib4fARB");
	glad_glVertexAttrib4fvARB = (PFNGLVERTEXATTRIB4FVARBPROC)load("glVertexAttrib4fvARB");
	glad_glVertexAttrib4ivARB = (PFNGLVERTEXATTRIB4IVARBPROC)load("glVertexAttrib4ivARB");
	glad_glVertexAttrib4sARB = (PFNGLVERTEXATTRIB4SARBPROC)load("glVertexAttrib4sARB");
	glad_glVertexAttrib4svARB = (PFNGLVERTEXATTRIB4SVARBPROC)load("glVertexAttrib4svARB");
	glad_glVertexAttrib4ubvARB = (PFNGLVERTEXATTRIB4UBVARBPROC)load("glVertexAttrib4ubvARB");
	glad_glVertexAttrib4uivARB = (PFNGLVERTEXATTRIB4UIVARBPROC)load("glVertexAttrib4uivARB");
	glad_glVertexAttrib4usvARB = (PFNGLVERTEXATTRIB4USVARBPROC)load("glVertexAttrib4usvARB");
	glad_glVertexAttribPointerARB = (PFNGLVERTEXATTRIBPOINTERARBPROC)load("glVertexAttribPointerARB");
	glad_glEnableVertexAttribArrayARB = (PFNGLENABLEVERTEXATTRIBARRAYARBPROC)load("glEnableVertexAttribArrayARB");
	glad_glDisableVertexAttribArrayARB = (PFNGLDISABLEVERTEXATTRIBARRAYARBPROC)load("glDisableVertexAttribArrayARB");
	glad_glProgramStringARB = (PFNGLPROGRAMSTRINGARBPROC)load("glProgramStringARB");
	glad_glBindProgramARB = (PFNGLBINDPROGRAMARBPROC)load("glBindProgramARB");
	glad_glDeleteProgramsARB = (PFNGLDELETEPROGRAMSARBPROC)load("glDeleteProgramsARB");
	glad_glGenProgramsARB = (PFNGLGENPROGRAMSARBPROC)load("glGenProgramsARB");
	glad_glProgramEnvParameter4dARB = (PFNGLPROGRAMENVPARAMETER4DARBPROC)load("glProgramEnvParameter4dARB");
	glad_glProgramEnvParameter4dvARB = (PFNGLPROGRAMENVPARAMETER4DVARBPROC)load("glProgramEnvParameter4dvARB");
	glad_glProgramEnvParameter4fARB = (PFNGLPROGRAMENVPARAMETER4FARBPROC)load("glProgramEnvParameter4fARB");
	glad_glProgramEnvParameter4fvARB = (PFNGLPROGRAMENVPARAMETER4FVARBPROC)load("glProgramEnvParameter4fvARB");
	glad_glProgramLocalParameter4dARB = (PFNGLPROGRAMLOCALPARAMETER4DARBPROC)load("glProgramLocalParameter4dARB");
	glad_glProgramLocalParameter4dvARB = (PFNGLPROGRAMLOCALPARAMETER4DVARBPROC)load("glProgramLocalParameter4dvARB");
	glad_glProgramLocalParameter4fARB = (PFNGLPROGRAMLOCALPARAMETER4FARBPROC)load("glProgramLocalParameter4fARB");
	glad_glProgramLocalParameter4fvARB = (PFNGLPROGRAMLOCALPARAMETER4FVARBPROC)load("glProgramLocalParameter4fvARB");
	glad_glGetProgramEnvParameterdvARB = (PFNGLGETPROGRAMENVPARAMETERDVARBPROC)load("glGetProgramEnvParameterdvARB");
	glad_glGetProgramEnvParameterfvARB = (PFNGLGETPROGRAMENVPARAMETERFVARBPROC)load("glGetProgramEnvParameterfvARB");
	glad_glGetProgramLocalParameterdvARB = (PFNGLGETPROGRAMLOCALPARAMETERDVARBPROC)load("glGetProgramLocalParameterdvARB");
	glad_glGetProgramLocalParameterfvARB = (PFNGLGETPROGRAMLOCALPARAMETERFVARBPROC)load("glGetProgramLocalParameterfvARB");
	glad_glGetProgramivARB = (PFNGLGETPROGRAMIVARBPROC)load("glGetProgramivARB");
	glad_glGetProgramStringARB = (PFNGLGETPROGRAMSTRINGARBPROC)load("glGetProgramStringARB");
	glad_glGetVertexAttribdvARB = (PFNGLGETVERTEXATTRIBDVARBPROC)load("glGetVertexAttribdvARB");
	glad_glGetVertexAttribfvARB = (PFNGLGETVERTEXATTRIBFVARBPROC)load("glGetVertexAttribfvARB");
	glad_glGetVertexAttribivARB = (PFNGLGETVERTEXATTRIBIVARBPROC)load("glGetVertexAttribivARB");
	glad_glGetVertexAttribPointervARB = (PFNGLGETVERTEXATTRIBPOINTERVARBPROC)load("glGetVertexAttribPointervARB");
	glad_glIsProgramARB = (PFNGLISPROGRAMARBPROC)load("glIsProgramARB");
}
static void load_GL_ARB_vertex_shader(GLADloadproc load) {
	if(!GLAD_GL_ARB_vertex_shader) return;
	glad_glVertexAttrib1fARB = (PFNGLVERTEXATTRIB1FARBPROC)load("glVertexAttrib1fARB");
	glad_glVertexAttrib1sARB = (PFNGLVERTEXATTRIB1SARBPROC)load("glVertexAttrib1sARB");
	glad_glVertexAttrib1dARB = (PFNGLVERTEXATTRIB1DARBPROC)load("glVertexAttrib1dARB");
	glad_glVertexAttrib2fARB = (PFNGLVERTEXATTRIB2FARBPROC)load("glVertexAttrib2fARB");
	glad_glVertexAttrib2sARB = (PFNGLVERTEXATTRIB2SARBPROC)load("glVertexAttrib2sARB");
	glad_glVertexAttrib2dARB = (PFNGLVERTEXATTRIB2DARBPROC)load("glVertexAttrib2dARB");
	glad_glVertexAttrib3fARB = (PFNGLVERTEXATTRIB3FARBPROC)load("glVertexAttrib3fARB");
	glad_glVertexAttrib3sARB = (PFNGLVERTEXATTRIB3SARBPROC)load("glVertexAttrib3sARB");
	glad_glVertexAttrib3dARB = (PFNGLVERTEXATTRIB3DARBPROC)load("glVertexAttrib3dARB");
	glad_glVertexAttrib4fARB = (PFNGLVERTEXATTRIB4FARBPROC)load("glVertexAttrib4fARB");
	glad_glVertexAttrib4sARB = (PFNGLVERTEXATTRIB4SARBPROC)load("glVertexAttrib4sARB");
	glad_glVertexAttrib4dARB = (PFNGLVERTEXATTRIB4DARBPROC)load("glVertexAttrib4dARB");
	glad_glVertexAttrib4NubARB = (PFNGLVERTEXATTRIB4NUBARBPROC)load("glVertexAttrib4NubARB");
	glad_glVertexAttrib1fvARB = (PFNGLVERTEXATTRIB1FVARBPROC)load("glVertexAttrib1fvARB");
	glad_glVertexAttrib1svARB = (PFNGLVERTEXATTRIB1SVARBPROC)load("glVertexAttrib1svARB");
	glad_glVertexAttrib1dvARB = (PFNGLVERTEXATTRIB1DVARBPROC)load("glVertexAttrib1dvARB");
	glad_glVertexAttrib2fvARB = (PFNGLVERTEXATTRIB2FVARBPROC)load("glVertexAttrib2fvARB");
	glad_glVertexAttrib2svARB = (PFNGLVERTEXATTRIB2SVARBPROC)load("glVertexAttrib2svARB");
	glad_glVertexAttrib2dvARB = (PFNGLVERTEXATTRIB2DVARBPROC)load("glVertexAttrib2dvARB");
	glad_glVertexAttrib3fvARB = (PFNGLVERTEXATTRIB3FVARBPROC)load("glVertexAttrib3fvARB");
	glad_glVertexAttrib3svARB = (PFNGLVERTEXATTRIB3SVARBPROC)load("glVertexAttrib3svARB");
	glad_glVertexAttrib3dvARB = (PFNGLVERTEXATTRIB3DVARBPROC)load("glVertexAttrib3dvARB");
	glad_glVertexAttrib4fvARB = (PFNGLVERTEXATTRIB4FVARBPROC)load("glVertexAttrib4fvARB");
	glad_glVertexAttrib4svARB = (PFNGLVERTEXATTRIB4SVARBPROC)load("glVertexAttrib4svARB");
	glad_glVertexAttrib4dvARB = (PFNGLVERTEXATTRIB4DVARBPROC)load("glVertexAttrib4dvARB");
	glad_glVertexAttrib4ivARB = (PFNGLVERTEXATTRIB4IVARBPROC)load("glVertexAttrib4ivARB");
	glad_glVertexAttrib4bvARB = (PFNGLVERTEXATTRIB4BVARBPROC)load("glVertexAttrib4bvARB");
	glad_glVertexAttrib4ubvARB = (PFNGLVERTEXATTRIB4UBVARBPROC)load("glVertexAttrib4ubvARB");
	glad_glVertexAttrib4usvARB = (PFNGLVERTEXATTRIB4USVARBPROC)load("glVertexAttrib4usvARB");
	glad_glVertexAttrib4uivARB = (PFNGLVERTEXATTRIB4UIVARBPROC)load("glVertexAttrib4uivARB");
	glad_glVertexAttrib4NbvARB = (PFNGLVERTEXATTRIB4NBVARBPROC)load("glVertexAttrib4NbvARB");
	glad_glVertexAttrib4NsvARB = (PFNGLVERTEXATTRIB4NSVARBPROC)load("glVertexAttrib4NsvARB");
	glad_glVertexAttrib4NivARB = (PFNGLVERTEXATTRIB4NIVARBPROC)load("glVertexAttrib4NivARB");
	glad_glVertexAttrib4NubvARB = (PFNGLVERTEXATTRIB4NUBVARBPROC)load("glVertexAttrib4NubvARB");
	glad_glVertexAttrib4NusvARB = (PFNGLVERTEXATTRIB4NUSVARBPROC)load("glVertexAttrib4NusvARB");
	glad_glVertexAttrib4NuivARB = (PFNGLVERTEXATTRIB4NUIVARBPROC)load("glVertexAttrib4NuivARB");
	glad_glVertexAttribPointerARB = (PFNGLVERTEXATTRIBPOINTERARBPROC)load("glVertexAttribPointerARB");
	glad_glEnableVertexAttribArrayARB = (PFNGLENABLEVERTEXATTRIBARRAYARBPROC)load("glEnableVertexAttribArrayARB");
	glad_glDisableVertexAttribArrayARB = (PFNGLDISABLEVERTEXATTRIBARRAYARBPROC)load("glDisableVertexAttribArrayARB");
	glad_glBindAttribLocationARB = (PFNGLBINDATTRIBLOCATIONARBPROC)load("glBindAttribLocationARB");
	glad_glGetActiveAttribARB = (PFNGLGETACTIVEATTRIBARBPROC)load("glGetActiveAttribARB");
	glad_glGetAttribLocationARB = (PFNGLGETATTRIBLOCATIONARBPROC)load("glGetAttribLocationARB");
	glad_glGetVertexAttribdvARB = (PFNGLGETVERTEXATTRIBDVARBPROC)load("glGetVertexAttribdvARB");
	glad_glGetVertexAttribfvARB = (PFNGLGETVERTEXATTRIBFVARBPROC)load("glGetVertexAttribfvARB");
	glad_glGetVertexAttribivARB = (PFNGLGETVERTEXATTRIBIVARBPROC)load("glGetVertexAttribivARB");
	glad_glGetVertexAttribPointervARB = (PFNGLGETVERTEXATTRIBPOINTERVARBPROC)load("glGetVertexAttribPointervARB");
}
static void load_GL_ARB_vertex_type_2_10_10_10_rev(GLADloadproc load) {
	if(!GLAD_GL_ARB_vertex_type_2_10_10_10_rev) return;
	glad_glVertexAttribP1ui = (PFNGLVERTEXATTRIBP1UIPROC)load("glVertexAttribP1ui");
	glad_glVertexAttribP1uiv = (PFNGLVERTEXATTRIBP1UIVPROC)load("glVertexAttribP1uiv");
	glad_glVertexAttribP2ui = (PFNGLVERTEXATTRIBP2UIPROC)load("glVertexAttribP2ui");
	glad_glVertexAttribP2uiv = (PFNGLVERTEXATTRIBP2UIVPROC)load("glVertexAttribP2uiv");
	glad_glVertexAttribP3ui = (PFNGLVERTEXATTRIBP3UIPROC)load("glVertexAttribP3ui");
	glad_glVertexAttribP3uiv = (PFNGLVERTEXATTRIBP3UIVPROC)load("glVertexAttribP3uiv");
	glad_glVertexAttribP4ui = (PFNGLVERTEXATTRIBP4UIPROC)load("glVertexAttribP4ui");
	glad_glVertexAttribP4uiv = (PFNGLVERTEXATTRIBP4UIVPROC)load("glVertexAttribP4uiv");
	glad_glVertexP2ui = (PFNGLVERTEXP2UIPROC)load("glVertexP2ui");
	glad_glVertexP2uiv = (PFNGLVERTEXP2UIVPROC)load("glVertexP2uiv");
	glad_glVertexP3ui = (PFNGLVERTEXP3UIPROC)load("glVertexP3ui");
	glad_glVertexP3uiv = (PFNGLVERTEXP3UIVPROC)load("glVertexP3uiv");
	glad_glVertexP4ui = (PFNGLVERTEXP4UIPROC)load("glVertexP4ui");
	glad_glVertexP4uiv = (PFNGLVERTEXP4UIVPROC)load("glVertexP4uiv");
	glad_glTexCoordP1ui = (PFNGLTEXCOORDP1UIPROC)load("glTexCoordP1ui");
	glad_glTexCoordP1uiv = (PFNGLTEXCOORDP1UIVPROC)load("glTexCoordP1uiv");
	glad_glTexCoordP2ui = (PFNGLTEXCOORDP2UIPROC)load("glTexCoordP2ui");
	glad_glTexCoordP2uiv = (PFNGLTEXCOORDP2UIVPROC)load("glTexCoordP2uiv");
	glad_glTexCoordP3ui = (PFNGLTEXCOORDP3UIPROC)load("glTexCoordP3ui");
	glad_glTexCoordP3uiv = (PFNGLTEXCOORDP3UIVPROC)load("glTexCoordP3uiv");
	glad_glTexCoordP4ui = (PFNGLTEXCOORDP4UIPROC)load("glTexCoordP4ui");
	glad_glTexCoordP4uiv = (PFNGLTEXCOORDP4UIVPROC)load("glTexCoordP4uiv");
	glad_glMultiTexCoordP1ui = (PFNGLMULTITEXCOORDP1UIPROC)load("glMultiTexCoordP1ui");
	glad_glMultiTexCoordP1uiv = (PFNGLMULTITEXCOORDP1UIVPROC)load("glMultiTexCoordP1uiv");
	glad_glMultiTexCoordP2ui = (PFNGLMULTITEXCOORDP2UIPROC)load("glMultiTexCoordP2ui");
	glad_glMultiTexCoordP2uiv = (PFNGLMULTITEXCOORDP2UIVPROC)load("glMultiTexCoordP2uiv");
	glad_glMultiTexCoordP3ui = (PFNGLMULTITEXCOORDP3UIPROC)load("glMultiTexCoordP3ui");
	glad_glMultiTexCoordP3uiv = (PFNGLMULTITEXCOORDP3UIVPROC)load("glMultiTexCoordP3uiv");
	glad_glMultiTexCoordP4ui = (PFNGLMULTITEXCOORDP4UIPROC)load("glMultiTexCoordP4ui");
	glad_glMultiTexCoordP4uiv = (PFNGLMULTITEXCOORDP4UIVPROC)load("glMultiTexCoordP4uiv");
	glad_glNormalP3ui = (PFNGLNORMALP3UIPROC)load("glNormalP3ui");
	glad_glNormalP3uiv = (PFNGLNORMALP3UIVPROC)load("glNormalP3uiv");
	glad_glColorP3ui = (PFNGLCOLORP3UIPROC)load("glColorP3ui");
	glad_glColorP3uiv = (PFNGLCOLORP3UIVPROC)load("glColorP3uiv");
	glad_glColorP4ui = (PFNGLCOLORP4UIPROC)load("glColorP4ui");
	glad_glColorP4uiv = (PFNGLCOLORP4UIVPROC)load("glColorP4uiv");
	glad_glSecondaryColorP3ui = (PFNGLSECONDARYCOLORP3UIPROC)load("glSecondaryColorP3ui");
	glad_glSecondaryColorP3uiv = (PFNGLSECONDARYCOLORP3UIVPROC)load("glSecondaryColorP3uiv");
}
static void load_GL_ARB_viewport_array(GLADloadproc load) {
	if(!GLAD_GL_ARB_viewport_array) return;
	glad_glViewportArrayv = (PFNGLVIEWPORTARRAYVPROC)load("glViewportArrayv");
	glad_glViewportIndexedf = (PFNGLVIEWPORTINDEXEDFPROC)load("glViewportIndexedf");
	glad_glViewportIndexedfv = (PFNGLVIEWPORTINDEXEDFVPROC)load("glViewportIndexedfv");
	glad_glScissorArrayv = (PFNGLSCISSORARRAYVPROC)load("glScissorArrayv");
	glad_glScissorIndexed = (PFNGLSCISSORINDEXEDPROC)load("glScissorIndexed");
	glad_glScissorIndexedv = (PFNGLSCISSORINDEXEDVPROC)load("glScissorIndexedv");
	glad_glDepthRangeArrayv = (PFNGLDEPTHRANGEARRAYVPROC)load("glDepthRangeArrayv");
	glad_glDepthRangeIndexed = (PFNGLDEPTHRANGEINDEXEDPROC)load("glDepthRangeIndexed");
	glad_glGetFloati_v = (PFNGLGETFLOATI_VPROC)load("glGetFloati_v");
	glad_glGetDoublei_v = (PFNGLGETDOUBLEI_VPROC)load("glGetDoublei_v");
}
static void load_GL_ARB_window_pos(GLADloadproc load) {
	if(!GLAD_GL_ARB_window_pos) return;
	glad_glWindowPos2dARB = (PFNGLWINDOWPOS2DARBPROC)load("glWindowPos2dARB");
	glad_glWindowPos2dvARB = (PFNGLWINDOWPOS2DVARBPROC)load("glWindowPos2dvARB");
	glad_glWindowPos2fARB = (PFNGLWINDOWPOS2FARBPROC)load("glWindowPos2fARB");
	glad_glWindowPos2fvARB = (PFNGLWINDOWPOS2FVARBPROC)load("glWindowPos2fvARB");
	glad_glWindowPos2iARB = (PFNGLWINDOWPOS2IARBPROC)load("glWindowPos2iARB");
	glad_glWindowPos2ivARB = (PFNGLWINDOWPOS2IVARBPROC)load("glWindowPos2ivARB");
	glad_glWindowPos2sARB = (PFNGLWINDOWPOS2SARBPROC)load("glWindowPos2sARB");
	glad_glWindowPos2svARB = (PFNGLWINDOWPOS2SVARBPROC)load("glWindowPos2svARB");
	glad_glWindowPos3dARB = (PFNGLWINDOWPOS3DARBPROC)load("glWindowPos3dARB");
	glad_glWindowPos3dvARB = (PFNGLWINDOWPOS3DVARBPROC)load("glWindowPos3dvARB");
	glad_glWindowPos3fARB = (PFNGLWINDOWPOS3FARBPROC)load("glWindowPos3fARB");
	glad_glWindowPos3fvARB = (PFNGLWINDOWPOS3FVARBPROC)load("glWindowPos3fvARB");
	glad_glWindowPos3iARB = (PFNGLWINDOWPOS3IARBPROC)load("glWindowPos3iARB");
	glad_glWindowPos3ivARB = (PFNGLWINDOWPOS3IVARBPROC)load("glWindowPos3ivARB");
	glad_glWindowPos3sARB = (PFNGLWINDOWPOS3SARBPROC)load("glWindowPos3sARB");
	glad_glWindowPos3svARB = (PFNGLWINDOWPOS3SVARBPROC)load("glWindowPos3svARB");
}
static void load_GL_ATI_draw_buffers(GLADloadproc load) {
	if(!GLAD_GL_ATI_draw_buffers) return;
	glad_glDrawBuffersATI = (PFNGLDRAWBUFFERSATIPROC)load("glDrawBuffersATI");
}
static void load_GL_ATI_element_array(GLADloadproc load) {
	if(!GLAD_GL_ATI_element_array) return;
	glad_glElementPointerATI = (PFNGLELEMENTPOINTERATIPROC)load("glElementPointerATI");
	glad_glDrawElementArrayATI = (PFNGLDRAWELEMENTARRAYATIPROC)load("glDrawElementArrayATI");
	glad_glDrawRangeElementArrayATI = (PFNGLDRAWRANGEELEMENTARRAYATIPROC)load("glDrawRangeElementArrayATI");
}
static void load_GL_ATI_envmap_bumpmap(GLADloadproc load) {
	if(!GLAD_GL_ATI_envmap_bumpmap) return;
	glad_glTexBumpParameterivATI = (PFNGLTEXBUMPPARAMETERIVATIPROC)load("glTexBumpParameterivATI");
	glad_glTexBumpParameterfvATI = (PFNGLTEXBUMPPARAMETERFVATIPROC)load("glTexBumpParameterfvATI");
	glad_glGetTexBumpParameterivATI = (PFNGLGETTEXBUMPPARAMETERIVATIPROC)load("glGetTexBumpParameterivATI");
	glad_glGetTexBumpParameterfvATI = (PFNGLGETTEXBUMPPARAMETERFVATIPROC)load("glGetTexBumpParameterfvATI");
}
static void load_GL_ATI_fragment_shader(GLADloadproc load) {
	if(!GLAD_GL_ATI_fragment_shader) return;
	glad_glGenFragmentShadersATI = (PFNGLGENFRAGMENTSHADERSATIPROC)load("glGenFragmentShadersATI");
	glad_glBindFragmentShaderATI = (PFNGLBINDFRAGMENTSHADERATIPROC)load("glBindFragmentShaderATI");
	glad_glDeleteFragmentShaderATI = (PFNGLDELETEFRAGMENTSHADERATIPROC)load("glDeleteFragmentShaderATI");
	glad_glBeginFragmentShaderATI = (PFNGLBEGINFRAGMENTSHADERATIPROC)load("glBeginFragmentShaderATI");
	glad_glEndFragmentShaderATI = (PFNGLENDFRAGMENTSHADERATIPROC)load("glEndFragmentShaderATI");
	glad_glPassTexCoordATI = (PFNGLPASSTEXCOORDATIPROC)load("glPassTexCoordATI");
	glad_glSampleMapATI = (PFNGLSAMPLEMAPATIPROC)load("glSampleMapATI");
	glad_glColorFragmentOp1ATI = (PFNGLCOLORFRAGMENTOP1ATIPROC)load("glColorFragmentOp1ATI");
	glad_glColorFragmentOp2ATI = (PFNGLCOLORFRAGMENTOP2ATIPROC)load("glColorFragmentOp2ATI");
	glad_glColorFragmentOp3ATI = (PFNGLCOLORFRAGMENTOP3ATIPROC)load("glColorFragmentOp3ATI");
	glad_glAlphaFragmentOp1ATI = (PFNGLALPHAFRAGMENTOP1ATIPROC)load("glAlphaFragmentOp1ATI");
	glad_glAlphaFragmentOp2ATI = (PFNGLALPHAFRAGMENTOP2ATIPROC)load("glAlphaFragmentOp2ATI");
	glad_glAlphaFragmentOp3ATI = (PFNGLALPHAFRAGMENTOP3ATIPROC)load("glAlphaFragmentOp3ATI");
	glad_glSetFragmentShaderConstantATI = (PFNGLSETFRAGMENTSHADERCONSTANTATIPROC)load("glSetFragmentShaderConstantATI");
}
static void load_GL_ATI_map_object_buffer(GLADloadproc load) {
	if(!GLAD_GL_ATI_map_object_buffer) return;
	glad_glMapObjectBufferATI = (PFNGLMAPOBJECTBUFFERATIPROC)load("glMapObjectBufferATI");
	glad_glUnmapObjectBufferATI = (PFNGLUNMAPOBJECTBUFFERATIPROC)load("glUnmapObjectBufferATI");
}
static void load_GL_ATI_pn_triangles(GLADloadproc load) {
	if(!GLAD_GL_ATI_pn_triangles) return;
	glad_glPNTrianglesiATI = (PFNGLPNTRIANGLESIATIPROC)load("glPNTrianglesiATI");
	glad_glPNTrianglesfATI = (PFNGLPNTRIANGLESFATIPROC)load("glPNTrianglesfATI");
}
static void load_GL_ATI_separate_stencil(GLADloadproc load) {
	if(!GLAD_GL_ATI_separate_stencil) return;
	glad_glStencilOpSeparateATI = (PFNGLSTENCILOPSEPARATEATIPROC)load("glStencilOpSeparateATI");
	glad_glStencilFuncSeparateATI = (PFNGLSTENCILFUNCSEPARATEATIPROC)load("glStencilFuncSeparateATI");
}
static void load_GL_ATI_vertex_array_object(GLADloadproc load) {
	if(!GLAD_GL_ATI_vertex_array_object) return;
	glad_glNewObjectBufferATI = (PFNGLNEWOBJECTBUFFERATIPROC)load("glNewObjectBufferATI");
	glad_glIsObjectBufferATI = (PFNGLISOBJECTBUFFERATIPROC)load("glIsObjectBufferATI");
	glad_glUpdateObjectBufferATI = (PFNGLUPDATEOBJECTBUFFERATIPROC)load("glUpdateObjectBufferATI");
	glad_glGetObjectBufferfvATI = (PFNGLGETOBJECTBUFFERFVATIPROC)load("glGetObjectBufferfvATI");
	glad_glGetObjectBufferivATI = (PFNGLGETOBJECTBUFFERIVATIPROC)load("glGetObjectBufferivATI");
	glad_glFreeObjectBufferATI = (PFNGLFREEOBJECTBUFFERATIPROC)load("glFreeObjectBufferATI");
	glad_glArrayObjectATI = (PFNGLARRAYOBJECTATIPROC)load("glArrayObjectATI");
	glad_glGetArrayObjectfvATI = (PFNGLGETARRAYOBJECTFVATIPROC)load("glGetArrayObjectfvATI");
	glad_glGetArrayObjectivATI = (PFNGLGETARRAYOBJECTIVATIPROC)load("glGetArrayObjectivATI");
	glad_glVariantArrayObjectATI = (PFNGLVARIANTARRAYOBJECTATIPROC)load("glVariantArrayObjectATI");
	glad_glGetVariantArrayObjectfvATI = (PFNGLGETVARIANTARRAYOBJECTFVATIPROC)load("glGetVariantArrayObjectfvATI");
	glad_glGetVariantArrayObjectivATI = (PFNGLGETVARIANTARRAYOBJECTIVATIPROC)load("glGetVariantArrayObjectivATI");
}
static void load_GL_ATI_vertex_attrib_array_object(GLADloadproc load) {
	if(!GLAD_GL_ATI_vertex_attrib_array_object) return;
	glad_glVertexAttribArrayObjectATI = (PFNGLVERTEXATTRIBARRAYOBJECTATIPROC)load("glVertexAttribArrayObjectATI");
	glad_glGetVertexAttribArrayObjectfvATI = (PFNGLGETVERTEXATTRIBARRAYOBJECTFVATIPROC)load("glGetVertexAttribArrayObjectfvATI");
	glad_glGetVertexAttribArrayObjectivATI = (PFNGLGETVERTEXATTRIBARRAYOBJECTIVATIPROC)load("glGetVertexAttribArrayObjectivATI");
}
static void load_GL_ATI_vertex_streams(GLADloadproc load) {
	if(!GLAD_GL_ATI_vertex_streams) return;
	glad_glVertexStream1sATI = (PFNGLVERTEXSTREAM1SATIPROC)load("glVertexStream1sATI");
	glad_glVertexStream1svATI = (PFNGLVERTEXSTREAM1SVATIPROC)load("glVertexStream1svATI");
	glad_glVertexStream1iATI = (PFNGLVERTEXSTREAM1IATIPROC)load("glVertexStream1iATI");
	glad_glVertexStream1ivATI = (PFNGLVERTEXSTREAM1IVATIPROC)load("glVertexStream1ivATI");
	glad_glVertexStream1fATI = (PFNGLVERTEXSTREAM1FATIPROC)load("glVertexStream1fATI");
	glad_glVertexStream1fvATI = (PFNGLVERTEXSTREAM1FVATIPROC)load("glVertexStream1fvATI");
	glad_glVertexStream1dATI = (PFNGLVERTEXSTREAM1DATIPROC)load("glVertexStream1dATI");
	glad_glVertexStream1dvATI = (PFNGLVERTEXSTREAM1DVATIPROC)load("glVertexStream1dvATI");
	glad_glVertexStream2sATI = (PFNGLVERTEXSTREAM2SATIPROC)load("glVertexStream2sATI");
	glad_glVertexStream2svATI = (PFNGLVERTEXSTREAM2SVATIPROC)load("glVertexStream2svATI");
	glad_glVertexStream2iATI = (PFNGLVERTEXSTREAM2IATIPROC)load("glVertexStream2iATI");
	glad_glVertexStream2ivATI = (PFNGLVERTEXSTREAM2IVATIPROC)load("glVertexStream2ivATI");
	glad_glVertexStream2fATI = (PFNGLVERTEXSTREAM2FATIPROC)load("glVertexStream2fATI");
	glad_glVertexStream2fvATI = (PFNGLVERTEXSTREAM2FVATIPROC)load("glVertexStream2fvATI");
	glad_glVertexStream2dATI = (PFNGLVERTEXSTREAM2DATIPROC)load("glVertexStream2dATI");
	glad_glVertexStream2dvATI = (PFNGLVERTEXSTREAM2DVATIPROC)load("glVertexStream2dvATI");
	glad_glVertexStream3sATI = (PFNGLVERTEXSTREAM3SATIPROC)load("glVertexStream3sATI");
	glad_glVertexStream3svATI = (PFNGLVERTEXSTREAM3SVATIPROC)load("glVertexStream3svATI");
	glad_glVertexStream3iATI = (PFNGLVERTEXSTREAM3IATIPROC)load("glVertexStream3iATI");
	glad_glVertexStream3ivATI = (PFNGLVERTEXSTREAM3IVATIPROC)load("glVertexStream3ivATI");
	glad_glVertexStream3fATI = (PFNGLVERTEXSTREAM3FATIPROC)load("glVertexStream3fATI");
	glad_glVertexStream3fvATI = (PFNGLVERTEXSTREAM3FVATIPROC)load("glVertexStream3fvATI");
	glad_glVertexStream3dATI = (PFNGLVERTEXSTREAM3DATIPROC)load("glVertexStream3dATI");
	glad_glVertexStream3dvATI = (PFNGLVERTEXSTREAM3DVATIPROC)load("glVertexStream3dvATI");
	glad_glVertexStream4sATI = (PFNGLVERTEXSTREAM4SATIPROC)load("glVertexStream4sATI");
	glad_glVertexStream4svATI = (PFNGLVERTEXSTREAM4SVATIPROC)load("glVertexStream4svATI");
	glad_glVertexStream4iATI = (PFNGLVERTEXSTREAM4IATIPROC)load("glVertexStream4iATI");
	glad_glVertexStream4ivATI = (PFNGLVERTEXSTREAM4IVATIPROC)load("glVertexStream4ivATI");
	glad_glVertexStream4fATI = (PFNGLVERTEXSTREAM4FATIPROC)load("glVertexStream4fATI");
	glad_glVertexStream4fvATI = (PFNGLVERTEXSTREAM4FVATIPROC)load("glVertexStream4fvATI");
	glad_glVertexStream4dATI = (PFNGLVERTEXSTREAM4DATIPROC)load("glVertexStream4dATI");
	glad_glVertexStream4dvATI = (PFNGLVERTEXSTREAM4DVATIPROC)load("glVertexStream4dvATI");
	glad_glNormalStream3bATI = (PFNGLNORMALSTREAM3BATIPROC)load("glNormalStream3bATI");
	glad_glNormalStream3bvATI = (PFNGLNORMALSTREAM3BVATIPROC)load("glNormalStream3bvATI");
	glad_glNormalStream3sATI = (PFNGLNORMALSTREAM3SATIPROC)load("glNormalStream3sATI");
	glad_glNormalStream3svATI = (PFNGLNORMALSTREAM3SVATIPROC)load("glNormalStream3svATI");
	glad_glNormalStream3iATI = (PFNGLNORMALSTREAM3IATIPROC)load("glNormalStream3iATI");
	glad_glNormalStream3ivATI = (PFNGLNORMALSTREAM3IVATIPROC)load("glNormalStream3ivATI");
	glad_glNormalStream3fATI = (PFNGLNORMALSTREAM3FATIPROC)load("glNormalStream3fATI");
	glad_glNormalStream3fvATI = (PFNGLNORMALSTREAM3FVATIPROC)load("glNormalStream3fvATI");
	glad_glNormalStream3dATI = (PFNGLNORMALSTREAM3DATIPROC)load("glNormalStream3dATI");
	glad_glNormalStream3dvATI = (PFNGLNORMALSTREAM3DVATIPROC)load("glNormalStream3dvATI");
	glad_glClientActiveVertexStreamATI = (PFNGLCLIENTACTIVEVERTEXSTREAMATIPROC)load("glClientActiveVertexStreamATI");
	glad_glVertexBlendEnviATI = (PFNGLVERTEXBLENDENVIATIPROC)load("glVertexBlendEnviATI");
	glad_glVertexBlendEnvfATI = (PFNGLVERTEXBLENDENVFATIPROC)load("glVertexBlendEnvfATI");
}
static void load_GL_EXT_bindable_uniform(GLADloadproc load) {
	if(!GLAD_GL_EXT_bindable_uniform) return;
	glad_glUniformBufferEXT = (PFNGLUNIFORMBUFFEREXTPROC)load("glUniformBufferEXT");
	glad_glGetUniformBufferSizeEXT = (PFNGLGETUNIFORMBUFFERSIZEEXTPROC)load("glGetUniformBufferSizeEXT");
	glad_glGetUniformOffsetEXT = (PFNGLGETUNIFORMOFFSETEXTPROC)load("glGetUniformOffsetEXT");
}
static void load_GL_EXT_blend_color(GLADloadproc load) {
	if(!GLAD_GL_EXT_blend_color) return;
	glad_glBlendColorEXT = (PFNGLBLENDCOLOREXTPROC)load("glBlendColorEXT");
}
static void load_GL_EXT_blend_equation_separate(GLADloadproc load) {
	if(!GLAD_GL_EXT_blend_equation_separate) return;
	glad_glBlendEquationSeparateEXT = (PFNGLBLENDEQUATIONSEPARATEEXTPROC)load("glBlendEquationSeparateEXT");
}
static void load_GL_EXT_blend_func_separate(GLADloadproc load) {
	if(!GLAD_GL_EXT_blend_func_separate) return;
	glad_glBlendFuncSeparateEXT = (PFNGLBLENDFUNCSEPARATEEXTPROC)load("glBlendFuncSeparateEXT");
}
static void load_GL_EXT_blend_minmax(GLADloadproc load) {
	if(!GLAD_GL_EXT_blend_minmax) return;
	glad_glBlendEquationEXT = (PFNGLBLENDEQUATIONEXTPROC)load("glBlendEquationEXT");
}
static void load_GL_EXT_color_subtable(GLADloadproc load) {
	if(!GLAD_GL_EXT_color_subtable) return;
	glad_glColorSubTableEXT = (PFNGLCOLORSUBTABLEEXTPROC)load("glColorSubTableEXT");
	glad_glCopyColorSubTableEXT = (PFNGLCOPYCOLORSUBTABLEEXTPROC)load("glCopyColorSubTableEXT");
}
static void load_GL_EXT_compiled_vertex_array(GLADloadproc load) {
	if(!GLAD_GL_EXT_compiled_vertex_array) return;
	glad_glLockArraysEXT = (PFNGLLOCKARRAYSEXTPROC)load("glLockArraysEXT");
	glad_glUnlockArraysEXT = (PFNGLUNLOCKARRAYSEXTPROC)load("glUnlockArraysEXT");
}
static void load_GL_EXT_convolution(GLADloadproc load) {
	if(!GLAD_GL_EXT_convolution) return;
	glad_glConvolutionFilter1DEXT = (PFNGLCONVOLUTIONFILTER1DEXTPROC)load("glConvolutionFilter1DEXT");
	glad_glConvolutionFilter2DEXT = (PFNGLCONVOLUTIONFILTER2DEXTPROC)load("glConvolutionFilter2DEXT");
	glad_glConvolutionParameterfEXT = (PFNGLCONVOLUTIONPARAMETERFEXTPROC)load("glConvolutionParameterfEXT");
	glad_glConvolutionParameterfvEXT = (PFNGLCONVOLUTIONPARAMETERFVEXTPROC)load("glConvolutionParameterfvEXT");
	glad_glConvolutionParameteriEXT = (PFNGLCONVOLUTIONPARAMETERIEXTPROC)load("glConvolutionParameteriEXT");
	glad_glConvolutionParameterivEXT = (PFNGLCONVOLUTIONPARAMETERIVEXTPROC)load("glConvolutionParameterivEXT");
	glad_glCopyConvolutionFilter1DEXT = (PFNGLCOPYCONVOLUTIONFILTER1DEXTPROC)load("glCopyConvolutionFilter1DEXT");
	glad_glCopyConvolutionFilter2DEXT = (PFNGLCOPYCONVOLUTIONFILTER2DEXTPROC)load("glCopyConvolutionFilter2DEXT");
	glad_glGetConvolutionFilterEXT = (PFNGLGETCONVOLUTIONFILTEREXTPROC)load("glGetConvolutionFilterEXT");
	glad_glGetConvolutionParameterfvEXT = (PFNGLGETCONVOLUTIONPARAMETERFVEXTPROC)load("glGetConvolutionParameterfvEXT");
	glad_glGetConvolutionParameterivEXT = (PFNGLGETCONVOLUTIONPARAMETERIVEXTPROC)load("glGetConvolutionParameterivEXT");
	glad_glGetSeparableFilterEXT = (PFNGLGETSEPARABLEFILTEREXTPROC)load("glGetSeparableFilterEXT");
	glad_glSeparableFilter2DEXT = (PFNGLSEPARABLEFILTER2DEXTPROC)load("glSeparableFilter2DEXT");
}
static void load_GL_EXT_coordinate_frame(GLADloadproc load) {
	if(!GLAD_GL_EXT_coordinate_frame) return;
	glad_glTangent3bEXT = (PFNGLTANGENT3BEXTPROC)load("glTangent3bEXT");
	glad_glTangent3bvEXT = (PFNGLTANGENT3BVEXTPROC)load("glTangent3bvEXT");
	glad_glTangent3dEXT = (PFNGLTANGENT3DEXTPROC)load("glTangent3dEXT");
	glad_glTangent3dvEXT = (PFNGLTANGENT3DVEXTPROC)load("glTangent3dvEXT");
	glad_glTangent3fEXT = (PFNGLTANGENT3FEXTPROC)load("glTangent3fEXT");
	glad_glTangent3fvEXT = (PFNGLTANGENT3FVEXTPROC)load("glTangent3fvEXT");
	glad_glTangent3iEXT = (PFNGLTANGENT3IEXTPROC)load("glTangent3iEXT");
	glad_glTangent3ivEXT = (PFNGLTANGENT3IVEXTPROC)load("glTangent3ivEXT");
	glad_glTangent3sEXT = (PFNGLTANGENT3SEXTPROC)load("glTangent3sEXT");
	glad_glTangent3svEXT = (PFNGLTANGENT3SVEXTPROC)load("glTangent3svEXT");
	glad_glBinormal3bEXT = (PFNGLBINORMAL3BEXTPROC)load("glBinormal3bEXT");
	glad_glBinormal3bvEXT = (PFNGLBINORMAL3BVEXTPROC)load("glBinormal3bvEXT");
	glad_glBinormal3dEXT = (PFNGLBINORMAL3DEXTPROC)load("glBinormal3dEXT");
	glad_glBinormal3dvEXT = (PFNGLBINORMAL3DVEXTPROC)load("glBinormal3dvEXT");
	glad_glBinormal3fEXT = (PFNGLBINORMAL3FEXTPROC)load("glBinormal3fEXT");
	glad_glBinormal3fvEXT = (PFNGLBINORMAL3FVEXTPROC)load("glBinormal3fvEXT");
	glad_glBinormal3iEXT = (PFNGLBINORMAL3IEXTPROC)load("glBinormal3iEXT");
	glad_glBinormal3ivEXT = (PFNGLBINORMAL3IVEXTPROC)load("glBinormal3ivEXT");
	glad_glBinormal3sEXT = (PFNGLBINORMAL3SEXTPROC)load("glBinormal3sEXT");
	glad_glBinormal3svEXT = (PFNGLBINORMAL3SVEXTPROC)load("glBinormal3svEXT");
	glad_glTangentPointerEXT = (PFNGLTANGENTPOINTEREXTPROC)load("glTangentPointerEXT");
	glad_glBinormalPointerEXT = (PFNGLBINORMALPOINTEREXTPROC)load("glBinormalPointerEXT");
}
static void load_GL_EXT_copy_texture(GLADloadproc load) {
	if(!GLAD_GL_EXT_copy_texture) return;
	glad_glCopyTexImage1DEXT = (PFNGLCOPYTEXIMAGE1DEXTPROC)load("glCopyTexImage1DEXT");
	glad_glCopyTexImage2DEXT = (PFNGLCOPYTEXIMAGE2DEXTPROC)load("glCopyTexImage2DEXT");
	glad_glCopyTexSubImage1DEXT = (PFNGLCOPYTEXSUBIMAGE1DEXTPROC)load("glCopyTexSubImage1DEXT");
	glad_glCopyTexSubImage2DEXT = (PFNGLCOPYTEXSUBIMAGE2DEXTPROC)load("glCopyTexSubImage2DEXT");
	glad_glCopyTexSubImage3DEXT = (PFNGLCOPYTEXSUBIMAGE3DEXTPROC)load("glCopyTexSubImage3DEXT");
}
static void load_GL_EXT_cull_vertex(GLADloadproc load) {
	if(!GLAD_GL_EXT_cull_vertex) return;
	glad_glCullParameterdvEXT = (PFNGLCULLPARAMETERDVEXTPROC)load("glCullParameterdvEXT");
	glad_glCullParameterfvEXT = (PFNGLCULLPARAMETERFVEXTPROC)load("glCullParameterfvEXT");
}
static void load_GL_EXT_debug_label(GLADloadproc load) {
	if(!GLAD_GL_EXT_debug_label) return;
	glad_glLabelObjectEXT = (PFNGLLABELOBJECTEXTPROC)load("glLabelObjectEXT");
	glad_glGetObjectLabelEXT = (PFNGLGETOBJECTLABELEXTPROC)load("glGetObjectLabelEXT");
}
static void load_GL_EXT_debug_marker(GLADloadproc load) {
	if(!GLAD_GL_EXT_debug_marker) return;
	glad_glInsertEventMarkerEXT = (PFNGLINSERTEVENTMARKEREXTPROC)load("glInsertEventMarkerEXT");
	glad_glPushGroupMarkerEXT = (PFNGLPUSHGROUPMARKEREXTPROC)load("glPushGroupMarkerEXT");
	glad_glPopGroupMarkerEXT = (PFNGLPOPGROUPMARKEREXTPROC)load("glPopGroupMarkerEXT");
}
static void load_GL_EXT_depth_bounds_test(GLADloadproc load) {
	if(!GLAD_GL_EXT_depth_bounds_test) return;
	glad_glDepthBoundsEXT = (PFNGLDEPTHBOUNDSEXTPROC)load("glDepthBoundsEXT");
}
static void load_GL_EXT_direct_state_access(GLADloadproc load) {
	if(!GLAD_GL_EXT_direct_state_access) return;
	glad_glMatrixLoadfEXT = (PFNGLMATRIXLOADFEXTPROC)load("glMatrixLoadfEXT");
	glad_glMatrixLoaddEXT = (PFNGLMATRIXLOADDEXTPROC)load("glMatrixLoaddEXT");
	glad_glMatrixMultfEXT = (PFNGLMATRIXMULTFEXTPROC)load("glMatrixMultfEXT");
	glad_glMatrixMultdEXT = (PFNGLMATRIXMULTDEXTPROC)load("glMatrixMultdEXT");
	glad_glMatrixLoadIdentityEXT = (PFNGLMATRIXLOADIDENTITYEXTPROC)load("glMatrixLoadIdentityEXT");
	glad_glMatrixRotatefEXT = (PFNGLMATRIXROTATEFEXTPROC)load("glMatrixRotatefEXT");
	glad_glMatrixRotatedEXT = (PFNGLMATRIXROTATEDEXTPROC)load("glMatrixRotatedEXT");
	glad_glMatrixScalefEXT = (PFNGLMATRIXSCALEFEXTPROC)load("glMatrixScalefEXT");
	glad_glMatrixScaledEXT = (PFNGLMATRIXSCALEDEXTPROC)load("glMatrixScaledEXT");
	glad_glMatrixTranslatefEXT = (PFNGLMATRIXTRANSLATEFEXTPROC)load("glMatrixTranslatefEXT");
	glad_glMatrixTranslatedEXT = (PFNGLMATRIXTRANSLATEDEXTPROC)load("glMatrixTranslatedEXT");
	glad_glMatrixFrustumEXT = (PFNGLMATRIXFRUSTUMEXTPROC)load("glMatrixFrustumEXT");
	glad_glMatrixOrthoEXT = (PFNGLMATRIXORTHOEXTPROC)load("glMatrixOrthoEXT");
	glad_glMatrixPopEXT = (PFNGLMATRIXPOPEXTPROC)load("glMatrixPopEXT");
	glad_glMatrixPushEXT = (PFNGLMATRIXPUSHEXTPROC)load("glMatrixPushEXT");
	glad_glClientAttribDefaultEXT = (PFNGLCLIENTATTRIBDEFAULTEXTPROC)load("glClientAttribDefaultEXT");
	glad_glPushClientAttribDefaultEXT = (PFNGLPUSHCLIENTATTRIBDEFAULTEXTPROC)load("glPushClientAttribDefaultEXT");
	glad_glTextureParameterfEXT = (PFNGLTEXTUREPARAMETERFEXTPROC)load("glTextureParameterfEXT");
	glad_glTextureParameterfvEXT = (PFNGLTEXTUREPARAMETERFVEXTPROC)load("glTextureParameterfvEXT");
	glad_glTextureParameteriEXT = (PFNGLTEXTUREPARAMETERIEXTPROC)load("glTextureParameteriEXT");
	glad_glTextureParameterivEXT = (PFNGLTEXTUREPARAMETERIVEXTPROC)load("glTextureParameterivEXT");
	glad_glTextureImage1DEXT = (PFNGLTEXTUREIMAGE1DEXTPROC)load("glTextureImage1DEXT");
	glad_glTextureImage2DEXT = (PFNGLTEXTUREIMAGE2DEXTPROC)load("glTextureImage2DEXT");
	glad_glTextureSubImage1DEXT = (PFNGLTEXTURESUBIMAGE1DEXTPROC)load("glTextureSubImage1DEXT");
	glad_glTextureSubImage2DEXT = (PFNGLTEXTURESUBIMAGE2DEXTPROC)load("glTextureSubImage2DEXT");
	glad_glCopyTextureImage1DEXT = (PFNGLCOPYTEXTUREIMAGE1DEXTPROC)load("glCopyTextureImage1DEXT");
	glad_glCopyTextureImage2DEXT = (PFNGLCOPYTEXTUREIMAGE2DEXTPROC)load("glCopyTextureImage2DEXT");
	glad_glCopyTextureSubImage1DEXT = (PFNGLCOPYTEXTURESUBIMAGE1DEXTPROC)load("glCopyTextureSubImage1DEXT");
	glad_glCopyTextureSubImage2DEXT = (PFNGLCOPYTEXTURESUBIMAGE2DEXTPROC)load("glCopyTextureSubImage2DEXT");
	glad_glGetTextureImageEXT = (PFNGLGETTEXTUREIMAGEEXTPROC)load("glGetTextureImageEXT");
	glad_glGetTextureParameterfvEXT = (PFNGLGETTEXTUREPARAMETERFVEXTPROC)load("glGetTextureParameterfvEXT");
	glad_glGetTextureParameterivEXT = (PFNGLGETTEXTUREPARAMETERIVEXTPROC)load("glGetTextureParameterivEXT");
	glad_glGetTextureLevelParameterfvEXT = (PFNGLGETTEXTURELEVELPARAMETERFVEXTPROC)load("glGetTextureLevelParameterfvEXT");
	glad_glGetTextureLevelParameterivEXT = (PFNGLGETTEXTURELEVELPARAMETERIVEXTPROC)load("glGetTextureLevelParameterivEXT");
	glad_glTextureImage3DEXT = (PFNGLTEXTUREIMAGE3DEXTPROC)load("glTextureImage3DEXT");
	glad_glTextureSubImage3DEXT = (PFNGLTEXTURESUBIMAGE3DEXTPROC)load("glTextureSubImage3DEXT");
	glad_glCopyTextureSubImage3DEXT = (PFNGLCOPYTEXTURESUBIMAGE3DEXTPROC)load("glCopyTextureSubImage3DEXT");
	glad_glBindMultiTextureEXT = (PFNGLBINDMULTITEXTUREEXTPROC)load("glBindMultiTextureEXT");
	glad_glMultiTexCoordPointerEXT = (PFNGLMULTITEXCOORDPOINTEREXTPROC)load("glMultiTexCoordPointerEXT");
	glad_glMultiTexEnvfEXT = (PFNGLMULTITEXENVFEXTPROC)load("glMultiTexEnvfEXT");
	glad_glMultiTexEnvfvEXT = (PFNGLMULTITEXENVFVEXTPROC)load("glMultiTexEnvfvEXT");
	glad_glMultiTexEnviEXT = (PFNGLMULTITEXENVIEXTPROC)load("glMultiTexEnviEXT");
	glad_glMultiTexEnvivEXT = (PFNGLMULTITEXENVIVEXTPROC)load("glMultiTexEnvivEXT");
	glad_glMultiTexGendEXT = (PFNGLMULTITEXGENDEXTPROC)load("glMultiTexGendEXT");
	glad_glMultiTexGendvEXT = (PFNGLMULTITEXGENDVEXTPROC)load("glMultiTexGendvEXT");
	glad_glMultiTexGenfEXT = (PFNGLMULTITEXGENFEXTPROC)load("glMultiTexGenfEXT");
	glad_glMultiTexGenfvEXT = (PFNGLMULTITEXGENFVEXTPROC)load("glMultiTexGenfvEXT");
	glad_glMultiTexGeniEXT = (PFNGLMULTITEXGENIEXTPROC)load("glMultiTexGeniEXT");
	glad_glMultiTexGenivEXT = (PFNGLMULTITEXGENIVEXTPROC)load("glMultiTexGenivEXT");
	glad_glGetMultiTexEnvfvEXT = (PFNGLGETMULTITEXENVFVEXTPROC)load("glGetMultiTexEnvfvEXT");
	glad_glGetMultiTexEnvivEXT = (PFNGLGETMULTITEXENVIVEXTPROC)load("glGetMultiTexEnvivEXT");
	glad_glGetMultiTexGendvEXT = (PFNGLGETMULTITEXGENDVEXTPROC)load("glGetMultiTexGendvEXT");
	glad_glGetMultiTexGenfvEXT = (PFNGLGETMULTITEXGENFVEXTPROC)load("glGetMultiTexGenfvEXT");
	glad_glGetMultiTexGenivEXT = (PFNGLGETMULTITEXGENIVEXTPROC)load("glGetMultiTexGenivEXT");
	glad_glMultiTexParameteriEXT = (PFNGLMULTITEXPARAMETERIEXTPROC)load("glMultiTexParameteriEXT");
	glad_glMultiTexParameterivEXT = (PFNGLMULTITEXPARAMETERIVEXTPROC)load("glMultiTexParameterivEXT");
	glad_glMultiTexParameterfEXT = (PFNGLMULTITEXPARAMETERFEXTPROC)load("glMultiTexParameterfEXT");
	glad_glMultiTexParameterfvEXT = (PFNGLMULTITEXPARAMETERFVEXTPROC)load("glMultiTexParameterfvEXT");
	glad_glMultiTexImage1DEXT = (PFNGLMULTITEXIMAGE1DEXTPROC)load("glMultiTexImage1DEXT");
	glad_glMultiTexImage2DEXT = (PFNGLMULTITEXIMAGE2DEXTPROC)load("glMultiTexImage2DEXT");
	glad_glMultiTexSubImage1DEXT = (PFNGLMULTITEXSUBIMAGE1DEXTPROC)load("glMultiTexSubImage1DEXT");
	glad_glMultiTexSubImage2DEXT = (PFNGLMULTITEXSUBIMAGE2DEXTPROC)load("glMultiTexSubImage2DEXT");
	glad_glCopyMultiTexImage1DEXT = (PFNGLCOPYMULTITEXIMAGE1DEXTPROC)load("glCopyMultiTexImage1DEXT");
	glad_glCopyMultiTexImage2DEXT = (PFNGLCOPYMULTITEXIMAGE2DEXTPROC)load("glCopyMultiTexImage2DEXT");
	glad_glCopyMultiTexSubImage1DEXT = (PFNGLCOPYMULTITEXSUBIMAGE1DEXTPROC)load("glCopyMultiTexSubImage1DEXT");
	glad_glCopyMultiTexSubImage2DEXT = (PFNGLCOPYMULTITEXSUBIMAGE2DEXTPROC)load("glCopyMultiTexSubImage2DEXT");
	glad_glGetMultiTexImageEXT = (PFNGLGETMULTITEXIMAGEEXTPROC)load("glGetMultiTexImageEXT");
	glad_glGetMultiTexParameterfvEXT = (PFNGLGETMULTITEXPARAMETERFVEXTPROC)load("glGetMultiTexParameterfvEXT");
	glad_glGetMultiTexParameterivEXT = (PFNGLGETMULTITEXPARAMETERIVEXTPROC)load("glGetMultiTexParameterivEXT");
	glad_glGetMultiTexLevelParameterfvEXT = (PFNGLGETMULTITEXLEVELPARAMETERFVEXTPROC)load("glGetMultiTexLevelParameterfvEXT");
	glad_glGetMultiTexLevelParameterivEXT = (PFNGLGETMULTITEXLEVELPARAMETERIVEXTPROC)load("glGetMultiTexLevelParameterivEXT");
	glad_glMultiTexImage3DEXT = (PFNGLMULTITEXIMAGE3DEXTPROC)load("glMultiTexImage3DEXT");
	glad_glMultiTexSubImage3DEXT = (PFNGLMULTITEXSUBIMAGE3DEXTPROC)load("glMultiTexSubImage3DEXT");
	glad_glCopyMultiTexSubImage3DEXT = (PFNGLCOPYMULTITEXSUBIMAGE3DEXTPROC)load("glCopyMultiTexSubImage3DEXT");
	glad_glEnableClientStateIndexedEXT = (PFNGLENABLECLIENTSTATEINDEXEDEXTPROC)load("glEnableClientStateIndexedEXT");
	glad_glDisableClientStateIndexedEXT = (PFNGLDISABLECLIENTSTATEINDEXEDEXTPROC)load("glDisableClientStateIndexedEXT");
	glad_glGetFloatIndexedvEXT = (PFNGLGETFLOATINDEXEDVEXTPROC)load("glGetFloatIndexedvEXT");
	glad_glGetDoubleIndexedvEXT = (PFNGLGETDOUBLEINDEXEDVEXTPROC)load("glGetDoubleIndexedvEXT");
	glad_glGetPointerIndexedvEXT = (PFNGLGETPOINTERINDEXEDVEXTPROC)load("glGetPointerIndexedvEXT");
	glad_glEnableIndexedEXT = (PFNGLENABLEINDEXEDEXTPROC)load("glEnableIndexedEXT");
	glad_glDisableIndexedEXT = (PFNGLDISABLEINDEXEDEXTPROC)load("glDisableIndexedEXT");
	glad_glIsEnabledIndexedEXT = (PFNGLISENABLEDINDEXEDEXTPROC)load("glIsEnabledIndexedEXT");
	glad_glGetIntegerIndexedvEXT = (PFNGLGETINTEGERINDEXEDVEXTPROC)load("glGetIntegerIndexedvEXT");
	glad_glGetBooleanIndexedvEXT = (PFNGLGETBOOLEANINDEXEDVEXTPROC)load("glGetBooleanIndexedvEXT");
	glad_glCompressedTextureImage3DEXT = (PFNGLCOMPRESSEDTEXTUREIMAGE3DEXTPROC)load("glCompressedTextureImage3DEXT");
	glad_glCompressedTextureImage2DEXT = (PFNGLCOMPRESSEDTEXTUREIMAGE2DEXTPROC)load("glCompressedTextureImage2DEXT");
	glad_glCompressedTextureImage1DEXT = (PFNGLCOMPRESSEDTEXTUREIMAGE1DEXTPROC)load("glCompressedTextureImage1DEXT");
	glad_glCompressedTextureSubImage3DEXT = (PFNGLCOMPRESSEDTEXTURESUBIMAGE3DEXTPROC)load("glCompressedTextureSubImage3DEXT");
	glad_glCompressedTextureSubImage2DEXT = (PFNGLCOMPRESSEDTEXTURESUBIMAGE2DEXTPROC)load("glCompressedTextureSubImage2DEXT");
	glad_glCompressedTextureSubImage1DEXT = (PFNGLCOMPRESSEDTEXTURESUBIMAGE1DEXTPROC)load("glCompressedTextureSubImage1DEXT");
	glad_glGetCompressedTextureImageEXT = (PFNGLGETCOMPRESSEDTEXTUREIMAGEEXTPROC)load("glGetCompressedTextureImageEXT");
	glad_glCompressedMultiTexImage3DEXT = (PFNGLCOMPRESSEDMULTITEXIMAGE3DEXTPROC)load("glCompressedMultiTexImage3DEXT");
	glad_glCompressedMultiTexImage2DEXT = (PFNGLCOMPRESSEDMULTITEXIMAGE2DEXTPROC)load("glCompressedMultiTexImage2DEXT");
	glad_glCompressedMultiTexImage1DEXT = (PFNGLCOMPRESSEDMULTITEXIMAGE1DEXTPROC)load("glCompressedMultiTexImage1DEXT");
	glad_glCompressedMultiTexSubImage3DEXT = (PFNGLCOMPRESSEDMULTITEXSUBIMAGE3DEXTPROC)load("glCompressedMultiTexSubImage3DEXT");
	glad_glCompressedMultiTexSubImage2DEXT = (PFNGLCOMPRESSEDMULTITEXSUBIMAGE2DEXTPROC)load("glCompressedMultiTexSubImage2DEXT");
	glad_glCompressedMultiTexSubImage1DEXT = (PFNGLCOMPRESSEDMULTITEXSUBIMAGE1DEXTPROC)load("glCompressedMultiTexSubImage1DEXT");
	glad_glGetCompressedMultiTexImageEXT = (PFNGLGETCOMPRESSEDMULTITEXIMAGEEXTPROC)load("glGetCompressedMultiTexImageEXT");
	glad_glMatrixLoadTransposefEXT = (PFNGLMATRIXLOADTRANSPOSEFEXTPROC)load("glMatrixLoadTransposefEXT");
	glad_glMatrixLoadTransposedEXT = (PFNGLMATRIXLOADTRANSPOSEDEXTPROC)load("glMatrixLoadTransposedEXT");
	glad_glMatrixMultTransposefEXT = (PFNGLMATRIXMULTTRANSPOSEFEXTPROC)load("glMatrixMultTransposefEXT");
	glad_glMatrixMultTransposedEXT = (PFNGLMATRIXMULTTRANSPOSEDEXTPROC)load("glMatrixMultTransposedEXT");
	glad_glNamedBufferDataEXT = (PFNGLNAMEDBUFFERDATAEXTPROC)load("glNamedBufferDataEXT");
	glad_glNamedBufferSubDataEXT = (PFNGLNAMEDBUFFERSUBDATAEXTPROC)load("glNamedBufferSubDataEXT");
	glad_glMapNamedBufferEXT = (PFNGLMAPNAMEDBUFFEREXTPROC)load("glMapNamedBufferEXT");
	glad_glUnmapNamedBufferEXT = (PFNGLUNMAPNAMEDBUFFEREXTPROC)load("glUnmapNamedBufferEXT");
	glad_glGetNamedBufferParameterivEXT = (PFNGLGETNAMEDBUFFERPARAMETERIVEXTPROC)load("glGetNamedBufferParameterivEXT");
	glad_glGetNamedBufferPointervEXT = (PFNGLGETNAMEDBUFFERPOINTERVEXTPROC)load("glGetNamedBufferPointervEXT");
	glad_glGetNamedBufferSubDataEXT = (PFNGLGETNAMEDBUFFERSUBDATAEXTPROC)load("glGetNamedBufferSubDataEXT");
	glad_glProgramUniform1fEXT = (PFNGLPROGRAMUNIFORM1FEXTPROC)load("glProgramUniform1fEXT");
	glad_glProgramUniform2fEXT = (PFNGLPROGRAMUNIFORM2FEXTPROC)load("glProgramUniform2fEXT");
	glad_glProgramUniform3fEXT = (PFNGLPROGRAMUNIFORM3FEXTPROC)load("glProgramUniform3fEXT");
	glad_glProgramUniform4fEXT = (PFNGLPROGRAMUNIFORM4FEXTPROC)load("glProgramUniform4fEXT");
	glad_glProgramUniform1iEXT = (PFNGLPROGRAMUNIFORM1IEXTPROC)load("glProgramUniform1iEXT");
	glad_glProgramUniform2iEXT = (PFNGLPROGRAMUNIFORM2IEXTPROC)load("glProgramUniform2iEXT");
	glad_glProgramUniform3iEXT = (PFNGLPROGRAMUNIFORM3IEXTPROC)load("glProgramUniform3iEXT");
	glad_glProgramUniform4iEXT = (PFNGLPROGRAMUNIFORM4IEXTPROC)load("glProgramUniform4iEXT");
	glad_glProgramUniform1fvEXT = (PFNGLPROGRAMUNIFORM1FVEXTPROC)load("glProgramUniform1fvEXT");
	glad_glProgramUniform2fvEXT = (PFNGLPROGRAMUNIFORM2FVEXTPROC)load("glProgramUniform2fvEXT");
	glad_glProgramUniform3fvEXT = (PFNGLPROGRAMUNIFORM3FVEXTPROC)load("glProgramUniform3fvEXT");
	glad_glProgramUniform4fvEXT = (PFNGLPROGRAMUNIFORM4FVEXTPROC)load("glProgramUniform4fvEXT");
	glad_glProgramUniform1ivEXT = (PFNGLPROGRAMUNIFORM1IVEXTPROC)load("glProgramUniform1ivEXT");
	glad_glProgramUniform2ivEXT = (PFNGLPROGRAMUNIFORM2IVEXTPROC)load("glProgramUniform2ivEXT");
	glad_glProgramUniform3ivEXT = (PFNGLPROGRAMUNIFORM3IVEXTPROC)load("glProgramUniform3ivEXT");
	glad_glProgramUniform4ivEXT = (PFNGLPROGRAMUNIFORM4IVEXTPROC)load("glProgramUniform4ivEXT");
	glad_glProgramUniformMatrix2fvEXT = (PFNGLPROGRAMUNIFORMMATRIX2FVEXTPROC)load("glProgramUniformMatrix2fvEXT");
	glad_glProgramUniformMatrix3fvEXT = (PFNGLPROGRAMUNIFORMMATRIX3FVEXTPROC)load("glProgramUniformMatrix3fvEXT");
	glad_glProgramUniformMatrix4fvEXT = (PFNGLPROGRAMUNIFORMMATRIX4FVEXTPROC)load("glProgramUniformMatrix4fvEXT");
	glad_glProgramUniformMatrix2x3fvEXT = (PFNGLPROGRAMUNIFORMMATRIX2X3FVEXTPROC)load("glProgramUniformMatrix2x3fvEXT");
	glad_glProgramUniformMatrix3x2fvEXT = (PFNGLPROGRAMUNIFORMMATRIX3X2FVEXTPROC)load("glProgramUniformMatrix3x2fvEXT");
	glad_glProgramUniformMatrix2x4fvEXT = (PFNGLPROGRAMUNIFORMMATRIX2X4FVEXTPROC)load("glProgramUniformMatrix2x4fvEXT");
	glad_glProgramUniformMatrix4x2fvEXT = (PFNGLPROGRAMUNIFORMMATRIX4X2FVEXTPROC)load("glProgramUniformMatrix4x2fvEXT");
	glad_glProgramUniformMatrix3x4fvEXT = (PFNGLPROGRAMUNIFORMMATRIX3X4FVEXTPROC)load("glProgramUniformMatrix3x4fvEXT");
	glad_glProgramUniformMatrix4x3fvEXT = (PFNGLPROGRAMUNIFORMMATRIX4X3FVEXTPROC)load("glProgramUniformMatrix4x3fvEXT");
	glad_glTextureBufferEXT = (PFNGLTEXTUREBUFFEREXTPROC)load("glTextureBufferEXT");
	glad_glMultiTexBufferEXT = (PFNGLMULTITEXBUFFEREXTPROC)load("glMultiTexBufferEXT");
	glad_glTextureParameterIivEXT = (PFNGLTEXTUREPARAMETERIIVEXTPROC)load("glTextureParameterIivEXT");
	glad_glTextureParameterIuivEXT = (PFNGLTEXTUREPARAMETERIUIVEXTPROC)load("glTextureParameterIuivEXT");
	glad_glGetTextureParameterIivEXT = (PFNGLGETTEXTUREPARAMETERIIVEXTPROC)load("glGetTextureParameterIivEXT");
	glad_glGetTextureParameterIuivEXT = (PFNGLGETTEXTUREPARAMETERIUIVEXTPROC)load("glGetTextureParameterIuivEXT");
	glad_glMultiTexParameterIivEXT = (PFNGLMULTITEXPARAMETERIIVEXTPROC)load("glMultiTexParameterIivEXT");
	glad_glMultiTexParameterIuivEXT = (PFNGLMULTITEXPARAMETERIUIVEXTPROC)load("glMultiTexParameterIuivEXT");
	glad_glGetMultiTexParameterIivEXT = (PFNGLGETMULTITEXPARAMETERIIVEXTPROC)load("glGetMultiTexParameterIivEXT");
	glad_glGetMultiTexParameterIuivEXT = (PFNGLGETMULTITEXPARAMETERIUIVEXTPROC)load("glGetMultiTexParameterIuivEXT");
	glad_glProgramUniform1uiEXT = (PFNGLPROGRAMUNIFORM1UIEXTPROC)load("glProgramUniform1uiEXT");
	glad_glProgramUniform2uiEXT = (PFNGLPROGRAMUNIFORM2UIEXTPROC)load("glProgramUniform2uiEXT");
	glad_glProgramUniform3uiEXT = (PFNGLPROGRAMUNIFORM3UIEXTPROC)load("glProgramUniform3uiEXT");
	glad_glProgramUniform4uiEXT = (PFNGLPROGRAMUNIFORM4UIEXTPROC)load("glProgramUniform4uiEXT");
	glad_glProgramUniform1uivEXT = (PFNGLPROGRAMUNIFORM1UIVEXTPROC)load("glProgramUniform1uivEXT");
	glad_glProgramUniform2uivEXT = (PFNGLPROGRAMUNIFORM2UIVEXTPROC)load("glProgramUniform2uivEXT");
	glad_glProgramUniform3uivEXT = (PFNGLPROGRAMUNIFORM3UIVEXTPROC)load("glProgramUniform3uivEXT");
	glad_glProgramUniform4uivEXT = (PFNGLPROGRAMUNIFORM4UIVEXTPROC)load("glProgramUniform4uivEXT");
	glad_glNamedProgramLocalParameters4fvEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERS4FVEXTPROC)load("glNamedProgramLocalParameters4fvEXT");
	glad_glNamedProgramLocalParameterI4iEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERI4IEXTPROC)load("glNamedProgramLocalParameterI4iEXT");
	glad_glNamedProgramLocalParameterI4ivEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERI4IVEXTPROC)load("glNamedProgramLocalParameterI4ivEXT");
	glad_glNamedProgramLocalParametersI4ivEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERSI4IVEXTPROC)load("glNamedProgramLocalParametersI4ivEXT");
	glad_glNamedProgramLocalParameterI4uiEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIEXTPROC)load("glNamedProgramLocalParameterI4uiEXT");
	glad_glNamedProgramLocalParameterI4uivEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIVEXTPROC)load("glNamedProgramLocalParameterI4uivEXT");
	glad_glNamedProgramLocalParametersI4uivEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETERSI4UIVEXTPROC)load("glNamedProgramLocalParametersI4uivEXT");
	glad_glGetNamedProgramLocalParameterIivEXT = (PFNGLGETNAMEDPROGRAMLOCALPARAMETERIIVEXTPROC)load("glGetNamedProgramLocalParameterIivEXT");
	glad_glGetNamedProgramLocalParameterIuivEXT = (PFNGLGETNAMEDPROGRAMLOCALPARAMETERIUIVEXTPROC)load("glGetNamedProgramLocalParameterIuivEXT");
	glad_glEnableClientStateiEXT = (PFNGLENABLECLIENTSTATEIEXTPROC)load("glEnableClientStateiEXT");
	glad_glDisableClientStateiEXT = (PFNGLDISABLECLIENTSTATEIEXTPROC)load("glDisableClientStateiEXT");
	glad_glGetFloati_vEXT = (PFNGLGETFLOATI_VEXTPROC)load("glGetFloati_vEXT");
	glad_glGetDoublei_vEXT = (PFNGLGETDOUBLEI_VEXTPROC)load("glGetDoublei_vEXT");
	glad_glGetPointeri_vEXT = (PFNGLGETPOINTERI_VEXTPROC)load("glGetPointeri_vEXT");
	glad_glNamedProgramStringEXT = (PFNGLNAMEDPROGRAMSTRINGEXTPROC)load("glNamedProgramStringEXT");
	glad_glNamedProgramLocalParameter4dEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETER4DEXTPROC)load("glNamedProgramLocalParameter4dEXT");
	glad_glNamedProgramLocalParameter4dvEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETER4DVEXTPROC)load("glNamedProgramLocalParameter4dvEXT");
	glad_glNamedProgramLocalParameter4fEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETER4FEXTPROC)load("glNamedProgramLocalParameter4fEXT");
	glad_glNamedProgramLocalParameter4fvEXT = (PFNGLNAMEDPROGRAMLOCALPARAMETER4FVEXTPROC)load("glNamedProgramLocalParameter4fvEXT");
	glad_glGetNamedProgramLocalParameterdvEXT = (PFNGLGETNAMEDPROGRAMLOCALPARAMETERDVEXTPROC)load("glGetNamedProgramLocalParameterdvEXT");
	glad_glGetNamedProgramLocalParameterfvEXT = (PFNGLGETNAMEDPROGRAMLOCALPARAMETERFVEXTPROC)load("glGetNamedProgramLocalParameterfvEXT");
	glad_glGetNamedProgramivEXT = (PFNGLGETNAMEDPROGRAMIVEXTPROC)load("glGetNamedProgramivEXT");
	glad_glGetNamedProgramStringEXT = (PFNGLGETNAMEDPROGRAMSTRINGEXTPROC)load("glGetNamedProgramStringEXT");
	glad_glNamedRenderbufferStorageEXT = (PFNGLNAMEDRENDERBUFFERSTORAGEEXTPROC)load("glNamedRenderbufferStorageEXT");
	glad_glGetNamedRenderbufferParameterivEXT = (PFNGLGETNAMEDRENDERBUFFERPARAMETERIVEXTPROC)load("glGetNamedRenderbufferParameterivEXT");
	glad_glNamedRenderbufferStorageMultisampleEXT = (PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC)load("glNamedRenderbufferStorageMultisampleEXT");
	glad_glNamedRenderbufferStorageMultisampleCoverageEXT = (PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLECOVERAGEEXTPROC)load("glNamedRenderbufferStorageMultisampleCoverageEXT");
	glad_glCheckNamedFramebufferStatusEXT = (PFNGLCHECKNAMEDFRAMEBUFFERSTATUSEXTPROC)load("glCheckNamedFramebufferStatusEXT");
	glad_glNamedFramebufferTexture1DEXT = (PFNGLNAMEDFRAMEBUFFERTEXTURE1DEXTPROC)load("glNamedFramebufferTexture1DEXT");
	glad_glNamedFramebufferTexture2DEXT = (PFNGLNAMEDFRAMEBUFFERTEXTURE2DEXTPROC)load("glNamedFramebufferTexture2DEXT");
	glad_glNamedFramebufferTexture3DEXT = (PFNGLNAMEDFRAMEBUFFERTEXTURE3DEXTPROC)load("glNamedFramebufferTexture3DEXT");
	glad_glNamedFramebufferRenderbufferEXT = (PFNGLNAMEDFRAMEBUFFERRENDERBUFFEREXTPROC)load("glNamedFramebufferRenderbufferEXT");
	glad_glGetNamedFramebufferAttachmentParameterivEXT = (PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC)load("glGetNamedFramebufferAttachmentParameterivEXT");
	glad_glGenerateTextureMipmapEXT = (PFNGLGENERATETEXTUREMIPMAPEXTPROC)load("glGenerateTextureMipmapEXT");
	glad_glGenerateMultiTexMipmapEXT = (PFNGLGENERATEMULTITEXMIPMAPEXTPROC)load("glGenerateMultiTexMipmapEXT");
	glad_glFramebufferDrawBufferEXT = (PFNGLFRAMEBUFFERDRAWBUFFEREXTPROC)load("glFramebufferDrawBufferEXT");
	glad_glFramebufferDrawBuffersEXT = (PFNGLFRAMEBUFFERDRAWBUFFERSEXTPROC)load("glFramebufferDrawBuffersEXT");
	glad_glFramebufferReadBufferEXT = (PFNGLFRAMEBUFFERREADBUFFEREXTPROC)load("glFramebufferReadBufferEXT");
	glad_glGetFramebufferParameterivEXT = (PFNGLGETFRAMEBUFFERPARAMETERIVEXTPROC)load("glGetFramebufferParameterivEXT");
	glad_glNamedCopyBufferSubDataEXT = (PFNGLNAMEDCOPYBUFFERSUBDATAEXTPROC)load("glNamedCopyBufferSubDataEXT");
	glad_glNamedFramebufferTextureEXT = (PFNGLNAMEDFRAMEBUFFERTEXTUREEXTPROC)load("glNamedFramebufferTextureEXT");
	glad_glNamedFramebufferTextureLayerEXT = (PFNGLNAMEDFRAMEBUFFERTEXTURELAYEREXTPROC)load("glNamedFramebufferTextureLayerEXT");
	glad_glNamedFramebufferTextureFaceEXT = (PFNGLNAMEDFRAMEBUFFERTEXTUREFACEEXTPROC)load("glNamedFramebufferTextureFaceEXT");
	glad_glTextureRenderbufferEXT = (PFNGLTEXTURERENDERBUFFEREXTPROC)load("glTextureRenderbufferEXT");
	glad_glMultiTexRenderbufferEXT = (PFNGLMULTITEXRENDERBUFFEREXTPROC)load("glMultiTexRenderbufferEXT");
	glad_glVertexArrayVertexOffsetEXT = (PFNGLVERTEXARRAYVERTEXOFFSETEXTPROC)load("glVertexArrayVertexOffsetEXT");
	glad_glVertexArrayColorOffsetEXT = (PFNGLVERTEXARRAYCOLOROFFSETEXTPROC)load("glVertexArrayColorOffsetEXT");
	glad_glVertexArrayEdgeFlagOffsetEXT = (PFNGLVERTEXARRAYEDGEFLAGOFFSETEXTPROC)load("glVertexArrayEdgeFlagOffsetEXT");
	glad_glVertexArrayIndexOffsetEXT = (PFNGLVERTEXARRAYINDEXOFFSETEXTPROC)load("glVertexArrayIndexOffsetEXT");
	glad_glVertexArrayNormalOffsetEXT = (PFNGLVERTEXARRAYNORMALOFFSETEXTPROC)load("glVertexArrayNormalOffsetEXT");
	glad_glVertexArrayTexCoordOffsetEXT = (PFNGLVERTEXARRAYTEXCOORDOFFSETEXTPROC)load("glVertexArrayTexCoordOffsetEXT");
	glad_glVertexArrayMultiTexCoordOffsetEXT = (PFNGLVERTEXARRAYMULTITEXCOORDOFFSETEXTPROC)load("glVertexArrayMultiTexCoordOffsetEXT");
	glad_glVertexArrayFogCoordOffsetEXT = (PFNGLVERTEXARRAYFOGCOORDOFFSETEXTPROC)load("glVertexArrayFogCoordOffsetEXT");
	glad_glVertexArraySecondaryColorOffsetEXT = (PFNGLVERTEXARRAYSECONDARYCOLOROFFSETEXTPROC)load("glVertexArraySecondaryColorOffsetEXT");
	glad_glVertexArrayVertexAttribOffsetEXT = (PFNGLVERTEXARRAYVERTEXATTRIBOFFSETEXTPROC)load("glVertexArrayVertexAttribOffsetEXT");
	glad_glVertexArrayVertexAttribIOffsetEXT = (PFNGLVERTEXARRAYVERTEXATTRIBIOFFSETEXTPROC)load("glVertexArrayVertexAttribIOffsetEXT");
	glad_glEnableVertexArrayEXT = (PFNGLENABLEVERTEXARRAYEXTPROC)load("glEnableVertexArrayEXT");
	glad_glDisableVertexArrayEXT = (PFNGLDISABLEVERTEXARRAYEXTPROC)load("glDisableVertexArrayEXT");
	glad_glEnableVertexArrayAttribEXT = (PFNGLENABLEVERTEXARRAYATTRIBEXTPROC)load("glEnableVertexArrayAttribEXT");
	glad_glDisableVertexArrayAttribEXT = (PFNGLDISABLEVERTEXARRAYATTRIBEXTPROC)load("glDisableVertexArrayAttribEXT");
	glad_glGetVertexArrayIntegervEXT = (PFNGLGETVERTEXARRAYINTEGERVEXTPROC)load("glGetVertexArrayIntegervEXT");
	glad_glGetVertexArrayPointervEXT = (PFNGLGETVERTEXARRAYPOINTERVEXTPROC)load("glGetVertexArrayPointervEXT");
	glad_glGetVertexArrayIntegeri_vEXT = (PFNGLGETVERTEXARRAYINTEGERI_VEXTPROC)load("glGetVertexArrayIntegeri_vEXT");
	glad_glGetVertexArrayPointeri_vEXT = (PFNGLGETVERTEXARRAYPOINTERI_VEXTPROC)load("glGetVertexArrayPointeri_vEXT");
	glad_glMapNamedBufferRangeEXT = (PFNGLMAPNAMEDBUFFERRANGEEXTPROC)load("glMapNamedBufferRangeEXT");
	glad_glFlushMappedNamedBufferRangeEXT = (PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEEXTPROC)load("glFlushMappedNamedBufferRangeEXT");
	glad_glNamedBufferStorageEXT = (PFNGLNAMEDBUFFERSTORAGEEXTPROC)load("glNamedBufferStorageEXT");
	glad_glClearNamedBufferDataEXT = (PFNGLCLEARNAMEDBUFFERDATAEXTPROC)load("glClearNamedBufferDataEXT");
	glad_glClearNamedBufferSubDataEXT = (PFNGLCLEARNAMEDBUFFERSUBDATAEXTPROC)load("glClearNamedBufferSubDataEXT");
	glad_glNamedFramebufferParameteriEXT = (PFNGLNAMEDFRAMEBUFFERPARAMETERIEXTPROC)load("glNamedFramebufferParameteriEXT");
	glad_glGetNamedFramebufferParameterivEXT = (PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVEXTPROC)load("glGetNamedFramebufferParameterivEXT");
	glad_glProgramUniform1dEXT = (PFNGLPROGRAMUNIFORM1DEXTPROC)load("glProgramUniform1dEXT");
	glad_glProgramUniform2dEXT = (PFNGLPROGRAMUNIFORM2DEXTPROC)load("glProgramUniform2dEXT");
	glad_glProgramUniform3dEXT = (PFNGLPROGRAMUNIFORM3DEXTPROC)load("glProgramUniform3dEXT");
	glad_glProgramUniform4dEXT = (PFNGLPROGRAMUNIFORM4DEXTPROC)load("glProgramUniform4dEXT");
	glad_glProgramUniform1dvEXT = (PFNGLPROGRAMUNIFORM1DVEXTPROC)load("glProgramUniform1dvEXT");
	glad_glProgramUniform2dvEXT = (PFNGLPROGRAMUNIFORM2DVEXTPROC)load("glProgramUniform2dvEXT");
	glad_glProgramUniform3dvEXT = (PFNGLPROGRAMUNIFORM3DVEXTPROC)load("glProgramUniform3dvEXT");
	glad_glProgramUniform4dvEXT = (PFNGLPROGRAMUNIFORM4DVEXTPROC)load("glProgramUniform4dvEXT");
	glad_glProgramUniformMatrix2dvEXT = (PFNGLPROGRAMUNIFORMMATRIX2DVEXTPROC)load("glProgramUniformMatrix2dvEXT");
	glad_glProgramUniformMatrix3dvEXT = (PFNGLPROGRAMUNIFORMMATRIX3DVEXTPROC)load("glProgramUniformMatrix3dvEXT");
	glad_glProgramUniformMatrix4dvEXT = (PFNGLPROGRAMUNIFORMMATRIX4DVEXTPROC)load("glProgramUniformMatrix4dvEXT");
	glad_glProgramUniformMatrix2x3dvEXT = (PFNGLPROGRAMUNIFORMMATRIX2X3DVEXTPROC)load("glProgramUniformMatrix2x3dvEXT");
	glad_glProgramUniformMatrix2x4dvEXT = (PFNGLPROGRAMUNIFORMMATRIX2X4DVEXTPROC)load("glProgramUniformMatrix2x4dvEXT");
	glad_glProgramUniformMatrix3x2dvEXT = (PFNGLPROGRAMUNIFORMMATRIX3X2DVEXTPROC)load("glProgramUniformMatrix3x2dvEXT");
	glad_glProgramUniformMatrix3x4dvEXT = (PFNGLPROGRAMUNIFORMMATRIX3X4DVEXTPROC)load("glProgramUniformMatrix3x4dvEXT");
	glad_glProgramUniformMatrix4x2dvEXT = (PFNGLPROGRAMUNIFORMMATRIX4X2DVEXTPROC)load("glProgramUniformMatrix4x2dvEXT");
	glad_glProgramUniformMatrix4x3dvEXT = (PFNGLPROGRAMUNIFORMMATRIX4X3DVEXTPROC)load("glProgramUniformMatrix4x3dvEXT");
	glad_glTextureBufferRangeEXT = (PFNGLTEXTUREBUFFERRANGEEXTPROC)load("glTextureBufferRangeEXT");
	glad_glTextureStorage1DEXT = (PFNGLTEXTURESTORAGE1DEXTPROC)load("glTextureStorage1DEXT");
	glad_glTextureStorage2DEXT = (PFNGLTEXTURESTORAGE2DEXTPROC)load("glTextureStorage2DEXT");
	glad_glTextureStorage3DEXT = (PFNGLTEXTURESTORAGE3DEXTPROC)load("glTextureStorage3DEXT");
	glad_glTextureStorage2DMultisampleEXT = (PFNGLTEXTURESTORAGE2DMULTISAMPLEEXTPROC)load("glTextureStorage2DMultisampleEXT");
	glad_glTextureStorage3DMultisampleEXT = (PFNGLTEXTURESTORAGE3DMULTISAMPLEEXTPROC)load("glTextureStorage3DMultisampleEXT");
	glad_glVertexArrayBindVertexBufferEXT = (PFNGLVERTEXARRAYBINDVERTEXBUFFEREXTPROC)load("glVertexArrayBindVertexBufferEXT");
	glad_glVertexArrayVertexAttribFormatEXT = (PFNGLVERTEXARRAYVERTEXATTRIBFORMATEXTPROC)load("glVertexArrayVertexAttribFormatEXT");
	glad_glVertexArrayVertexAttribIFormatEXT = (PFNGLVERTEXARRAYVERTEXATTRIBIFORMATEXTPROC)load("glVertexArrayVertexAttribIFormatEXT");
	glad_glVertexArrayVertexAttribLFormatEXT = (PFNGLVERTEXARRAYVERTEXATTRIBLFORMATEXTPROC)load("glVertexArrayVertexAttribLFormatEXT");
	glad_glVertexArrayVertexAttribBindingEXT = (PFNGLVERTEXARRAYVERTEXATTRIBBINDINGEXTPROC)load("glVertexArrayVertexAttribBindingEXT");
	glad_glVertexArrayVertexBindingDivisorEXT = (PFNGLVERTEXARRAYVERTEXBINDINGDIVISOREXTPROC)load("glVertexArrayVertexBindingDivisorEXT");
	glad_glVertexArrayVertexAttribLOffsetEXT = (PFNGLVERTEXARRAYVERTEXATTRIBLOFFSETEXTPROC)load("glVertexArrayVertexAttribLOffsetEXT");
	glad_glTexturePageCommitmentEXT = (PFNGLTEXTUREPAGECOMMITMENTEXTPROC)load("glTexturePageCommitmentEXT");
	glad_glVertexArrayVertexAttribDivisorEXT = (PFNGLVERTEXARRAYVERTEXATTRIBDIVISOREXTPROC)load("glVertexArrayVertexAttribDivisorEXT");
}
static void load_GL_EXT_draw_buffers2(GLADloadproc load) {
	if(!GLAD_GL_EXT_draw_buffers2) return;
	glad_glColorMaskIndexedEXT = (PFNGLCOLORMASKINDEXEDEXTPROC)load("glColorMaskIndexedEXT");
	glad_glGetBooleanIndexedvEXT = (PFNGLGETBOOLEANINDEXEDVEXTPROC)load("glGetBooleanIndexedvEXT");
	glad_glGetIntegerIndexedvEXT = (PFNGLGETINTEGERINDEXEDVEXTPROC)load("glGetIntegerIndexedvEXT");
	glad_glEnableIndexedEXT = (PFNGLENABLEINDEXEDEXTPROC)load("glEnableIndexedEXT");
	glad_glDisableIndexedEXT = (PFNGLDISABLEINDEXEDEXTPROC)load("glDisableIndexedEXT");
	glad_glIsEnabledIndexedEXT = (PFNGLISENABLEDINDEXEDEXTPROC)load("glIsEnabledIndexedEXT");
}
static void load_GL_EXT_draw_instanced(GLADloadproc load) {
	if(!GLAD_GL_EXT_draw_instanced) return;
	glad_glDrawArraysInstancedEXT = (PFNGLDRAWARRAYSINSTANCEDEXTPROC)load("glDrawArraysInstancedEXT");
	glad_glDrawElementsInstancedEXT = (PFNGLDRAWELEMENTSINSTANCEDEXTPROC)load("glDrawElementsInstancedEXT");
}
static void load_GL_EXT_draw_range_elements(GLADloadproc load) {
	if(!GLAD_GL_EXT_draw_range_elements) return;
	glad_glDrawRangeElementsEXT = (PFNGLDRAWRANGEELEMENTSEXTPROC)load("glDrawRangeElementsEXT");
}
static void load_GL_EXT_fog_coord(GLADloadproc load) {
	if(!GLAD_GL_EXT_fog_coord) return;
	glad_glFogCoordfEXT = (PFNGLFOGCOORDFEXTPROC)load("glFogCoordfEXT");
	glad_glFogCoordfvEXT = (PFNGLFOGCOORDFVEXTPROC)load("glFogCoordfvEXT");
	glad_glFogCoorddEXT = (PFNGLFOGCOORDDEXTPROC)load("glFogCoorddEXT");
	glad_glFogCoorddvEXT = (PFNGLFOGCOORDDVEXTPROC)load("glFogCoorddvEXT");
	glad_glFogCoordPointerEXT = (PFNGLFOGCOORDPOINTEREXTPROC)load("glFogCoordPointerEXT");
}
static void load_GL_EXT_framebuffer_blit(GLADloadproc load) {
	if(!GLAD_GL_EXT_framebuffer_blit) return;
	glad_glBlitFramebufferEXT = (PFNGLBLITFRAMEBUFFEREXTPROC)load("glBlitFramebufferEXT");
}
static void load_GL_EXT_framebuffer_multisample(GLADloadproc load) {
	if(!GLAD_GL_EXT_framebuffer_multisample) return;
	glad_glRenderbufferStorageMultisampleEXT = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC)load("glRenderbufferStorageMultisampleEXT");
}
static void load_GL_EXT_framebuffer_object(GLADloadproc load) {
	if(!GLAD_GL_EXT_framebuffer_object) return;
	glad_glIsRenderbufferEXT = (PFNGLISRENDERBUFFEREXTPROC)load("glIsRenderbufferEXT");
	glad_glBindRenderbufferEXT = (PFNGLBINDRENDERBUFFEREXTPROC)load("glBindRenderbufferEXT");
	glad_glDeleteRenderbuffersEXT = (PFNGLDELETERENDERBUFFERSEXTPROC)load("glDeleteRenderbuffersEXT");
	glad_glGenRenderbuffersEXT = (PFNGLGENRENDERBUFFERSEXTPROC)load("glGenRenderbuffersEXT");
	glad_glRenderbufferStorageEXT = (PFNGLRENDERBUFFERSTORAGEEXTPROC)load("glRenderbufferStorageEXT");
	glad_glGetRenderbufferParameterivEXT = (PFNGLGETRENDERBUFFERPARAMETERIVEXTPROC)load("glGetRenderbufferParameterivEXT");
	glad_glIsFramebufferEXT = (PFNGLISFRAMEBUFFEREXTPROC)load("glIsFramebufferEXT");
	glad_glBindFramebufferEXT = (PFNGLBINDFRAMEBUFFEREXTPROC)load("glBindFramebufferEXT");
	glad_glDeleteFramebuffersEXT = (PFNGLDELETEFRAMEBUFFERSEXTPROC)load("glDeleteFramebuffersEXT");
	glad_glGenFramebuffersEXT = (PFNGLGENFRAMEBUFFERSEXTPROC)load("glGenFramebuffersEXT");
	glad_glCheckFramebufferStatusEXT = (PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC)load("glCheckFramebufferStatusEXT");
	glad_glFramebufferTexture1DEXT = (PFNGLFRAMEBUFFERTEXTURE1DEXTPROC)load("glFramebufferTexture1DEXT");
	glad_glFramebufferTexture2DEXT = (PFNGLFRAMEBUFFERTEXTURE2DEXTPROC)load("glFramebufferTexture2DEXT");
	glad_glFramebufferTexture3DEXT = (PFNGLFRAMEBUFFERTEXTURE3DEXTPROC)load("glFramebufferTexture3DEXT");
	glad_glFramebufferRenderbufferEXT = (PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC)load("glFramebufferRenderbufferEXT");
	glad_glGetFramebufferAttachmentParameterivEXT = (PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC)load("glGetFramebufferAttachmentParameterivEXT");
	glad_glGenerateMipmapEXT = (PFNGLGENERATEMIPMAPEXTPROC)load("glGenerateMipmapEXT");
}
static void load_GL_EXT_geometry_shader4(GLADloadproc load) {
	if(!GLAD_GL_EXT_geometry_shader4) return;
	glad_glProgramParameteriEXT = (PFNGLPROGRAMPARAMETERIEXTPROC)load("glProgramParameteriEXT");
}
static void load_GL_EXT_gpu_program_parameters(GLADloadproc load) {
	if(!GLAD_GL_EXT_gpu_program_parameters) return;
	glad_glProgramEnvParameters4fvEXT = (PFNGLPROGRAMENVPARAMETERS4FVEXTPROC)load("glProgramEnvParameters4fvEXT");
	glad_glProgramLocalParameters4fvEXT = (PFNGLPROGRAMLOCALPARAMETERS4FVEXTPROC)load("glProgramLocalParameters4fvEXT");
}
static void load_GL_EXT_gpu_shader4(GLADloadproc load) {
	if(!GLAD_GL_EXT_gpu_shader4) return;
	glad_glGetUniformuivEXT = (PFNGLGETUNIFORMUIVEXTPROC)load("glGetUniformuivEXT");
	glad_glBindFragDataLocationEXT = (PFNGLBINDFRAGDATALOCATIONEXTPROC)load("glBindFragDataLocationEXT");
	glad_glGetFragDataLocationEXT = (PFNGLGETFRAGDATALOCATIONEXTPROC)load("glGetFragDataLocationEXT");
	glad_glUniform1uiEXT = (PFNGLUNIFORM1UIEXTPROC)load("glUniform1uiEXT");
	glad_glUniform2uiEXT = (PFNGLUNIFORM2UIEXTPROC)load("glUniform2uiEXT");
	glad_glUniform3uiEXT = (PFNGLUNIFORM3UIEXTPROC)load("glUniform3uiEXT");
	glad_glUniform4uiEXT = (PFNGLUNIFORM4UIEXTPROC)load("glUniform4uiEXT");
	glad_glUniform1uivEXT = (PFNGLUNIFORM1UIVEXTPROC)load("glUniform1uivEXT");
	glad_glUniform2uivEXT = (PFNGLUNIFORM2UIVEXTPROC)load("glUniform2uivEXT");
	glad_glUniform3uivEXT = (PFNGLUNIFORM3UIVEXTPROC)load("glUniform3uivEXT");
	glad_glUniform4uivEXT = (PFNGLUNIFORM4UIVEXTPROC)load("glUniform4uivEXT");
}
static void load_GL_EXT_histogram(GLADloadproc load) {
	if(!GLAD_GL_EXT_histogram) return;
	glad_glGetHistogramEXT = (PFNGLGETHISTOGRAMEXTPROC)load("glGetHistogramEXT");
	glad_glGetHistogramParameterfvEXT = (PFNGLGETHISTOGRAMPARAMETERFVEXTPROC)load("glGetHistogramParameterfvEXT");
	glad_glGetHistogramParameterivEXT = (PFNGLGETHISTOGRAMPARAMETERIVEXTPROC)load("glGetHistogramParameterivEXT");
	glad_glGetMinmaxEXT = (PFNGLGETMINMAXEXTPROC)load("glGetMinmaxEXT");
	glad_glGetMinmaxParameterfvEXT = (PFNGLGETMINMAXPARAMETERFVEXTPROC)load("glGetMinmaxParameterfvEXT");
	glad_glGetMinmaxParameterivEXT = (PFNGLGETMINMAXPARAMETERIVEXTPROC)load("glGetMinmaxParameterivEXT");
	glad_glHistogramEXT = (PFNGLHISTOGRAMEXTPROC)load("glHistogramEXT");
	glad_glMinmaxEXT = (PFNGLMINMAXEXTPROC)load("glMinmaxEXT");
	glad_glResetHistogramEXT = (PFNGLRESETHISTOGRAMEXTPROC)load("glResetHistogramEXT");
	glad_glResetMinmaxEXT = (PFNGLRESETMINMAXEXTPROC)load("glResetMinmaxEXT");
}
static void load_GL_EXT_index_func(GLADloadproc load) {
	if(!GLAD_GL_EXT_index_func) return;
	glad_glIndexFuncEXT = (PFNGLINDEXFUNCEXTPROC)load("glIndexFuncEXT");
}
static void load_GL_EXT_index_material(GLADloadproc load) {
	if(!GLAD_GL_EXT_index_material) return;
	glad_glIndexMaterialEXT = (PFNGLINDEXMATERIALEXTPROC)load("glIndexMaterialEXT");
}
static void load_GL_EXT_light_texture(GLADloadproc load) {
	if(!GLAD_GL_EXT_light_texture) return;
	glad_glApplyTextureEXT = (PFNGLAPPLYTEXTUREEXTPROC)load("glApplyTextureEXT");
	glad_glTextureLightEXT = (PFNGLTEXTURELIGHTEXTPROC)load("glTextureLightEXT");
	glad_glTextureMaterialEXT = (PFNGLTEXTUREMATERIALEXTPROC)load("glTextureMaterialEXT");
}
static void load_GL_EXT_multi_draw_arrays(GLADloadproc load) {
	if(!GLAD_GL_EXT_multi_draw_arrays) return;
	glad_glMultiDrawArraysEXT = (PFNGLMULTIDRAWARRAYSEXTPROC)load("glMultiDrawArraysEXT");
	glad_glMultiDrawElementsEXT = (PFNGLMULTIDRAWELEMENTSEXTPROC)load("glMultiDrawElementsEXT");
}
static void load_GL_EXT_multisample(GLADloadproc load) {
	if(!GLAD_GL_EXT_multisample) return;
	glad_glSampleMaskEXT = (PFNGLSAMPLEMASKEXTPROC)load("glSampleMaskEXT");
	glad_glSamplePatternEXT = (PFNGLSAMPLEPATTERNEXTPROC)load("glSamplePatternEXT");
}
static void load_GL_EXT_paletted_texture(GLADloadproc load) {
	if(!GLAD_GL_EXT_paletted_texture) return;
	glad_glColorTableEXT = (PFNGLCOLORTABLEEXTPROC)load("glColorTableEXT");
	glad_glGetColorTableEXT = (PFNGLGETCOLORTABLEEXTPROC)load("glGetColorTableEXT");
	glad_glGetColorTableParameterivEXT = (PFNGLGETCOLORTABLEPARAMETERIVEXTPROC)load("glGetColorTableParameterivEXT");
	glad_glGetColorTableParameterfvEXT = (PFNGLGETCOLORTABLEPARAMETERFVEXTPROC)load("glGetColorTableParameterfvEXT");
}
static void load_GL_EXT_pixel_transform(GLADloadproc load) {
	if(!GLAD_GL_EXT_pixel_transform) return;
	glad_glPixelTransformParameteriEXT = (PFNGLPIXELTRANSFORMPARAMETERIEXTPROC)load("glPixelTransformParameteriEXT");
	glad_glPixelTransformParameterfEXT = (PFNGLPIXELTRANSFORMPARAMETERFEXTPROC)load("glPixelTransformParameterfEXT");
	glad_glPixelTransformParameterivEXT = (PFNGLPIXELTRANSFORMPARAMETERIVEXTPROC)load("glPixelTransformParameterivEXT");
	glad_glPixelTransformParameterfvEXT = (PFNGLPIXELTRANSFORMPARAMETERFVEXTPROC)load("glPixelTransformParameterfvEXT");
	glad_glGetPixelTransformParameterivEXT = (PFNGLGETPIXELTRANSFORMPARAMETERIVEXTPROC)load("glGetPixelTransformParameterivEXT");
	glad_glGetPixelTransformParameterfvEXT = (PFNGLGETPIXELTRANSFORMPARAMETERFVEXTPROC)load("glGetPixelTransformParameterfvEXT");
}
static void load_GL_EXT_point_parameters(GLADloadproc load) {
	if(!GLAD_GL_EXT_point_parameters) return;
	glad_glPointParameterfEXT = (PFNGLPOINTPARAMETERFEXTPROC)load("glPointParameterfEXT");
	glad_glPointParameterfvEXT = (PFNGLPOINTPARAMETERFVEXTPROC)load("glPointParameterfvEXT");
}
static void load_GL_EXT_polygon_offset(GLADloadproc load) {
	if(!GLAD_GL_EXT_polygon_offset) return;
	glad_glPolygonOffsetEXT = (PFNGLPOLYGONOFFSETEXTPROC)load("glPolygonOffsetEXT");
}
static void load_GL_EXT_polygon_offset_clamp(GLADloadproc load) {
	if(!GLAD_GL_EXT_polygon_offset_clamp) return;
	glad_glPolygonOffsetClampEXT = (PFNGLPOLYGONOFFSETCLAMPEXTPROC)load("glPolygonOffsetClampEXT");
}
static void load_GL_EXT_provoking_vertex(GLADloadproc load) {
	if(!GLAD_GL_EXT_provoking_vertex) return;
	glad_glProvokingVertexEXT = (PFNGLPROVOKINGVERTEXEXTPROC)load("glProvokingVertexEXT");
}
static void load_GL_EXT_raster_multisample(GLADloadproc load) {
	if(!GLAD_GL_EXT_raster_multisample) return;
	glad_glRasterSamplesEXT = (PFNGLRASTERSAMPLESEXTPROC)load("glRasterSamplesEXT");
}
static void load_GL_EXT_secondary_color(GLADloadproc load) {
	if(!GLAD_GL_EXT_secondary_color) return;
	glad_glSecondaryColor3bEXT = (PFNGLSECONDARYCOLOR3BEXTPROC)load("glSecondaryColor3bEXT");
	glad_glSecondaryColor3bvEXT = (PFNGLSECONDARYCOLOR3BVEXTPROC)load("glSecondaryColor3bvEXT");
	glad_glSecondaryColor3dEXT = (PFNGLSECONDARYCOLOR3DEXTPROC)load("glSecondaryColor3dEXT");
	glad_glSecondaryColor3dvEXT = (PFNGLSECONDARYCOLOR3DVEXTPROC)load("glSecondaryColor3dvEXT");
	glad_glSecondaryColor3fEXT = (PFNGLSECONDARYCOLOR3FEXTPROC)load("glSecondaryColor3fEXT");
	glad_glSecondaryColor3fvEXT = (PFNGLSECONDARYCOLOR3FVEXTPROC)load("glSecondaryColor3fvEXT");
	glad_glSecondaryColor3iEXT = (PFNGLSECONDARYCOLOR3IEXTPROC)load("glSecondaryColor3iEXT");
	glad_glSecondaryColor3ivEXT = (PFNGLSECONDARYCOLOR3IVEXTPROC)load("glSecondaryColor3ivEXT");
	glad_glSecondaryColor3sEXT = (PFNGLSECONDARYCOLOR3SEXTPROC)load("glSecondaryColor3sEXT");
	glad_glSecondaryColor3svEXT = (PFNGLSECONDARYCOLOR3SVEXTPROC)load("glSecondaryColor3svEXT");
	glad_glSecondaryColor3ubEXT = (PFNGLSECONDARYCOLOR3UBEXTPROC)load("glSecondaryColor3ubEXT");
	glad_glSecondaryColor3ubvEXT = (PFNGLSECONDARYCOLOR3UBVEXTPROC)load("glSecondaryColor3ubvEXT");
	glad_glSecondaryColor3uiEXT = (PFNGLSECONDARYCOLOR3UIEXTPROC)load("glSecondaryColor3uiEXT");
	glad_glSecondaryColor3uivEXT = (PFNGLSECONDARYCOLOR3UIVEXTPROC)load("glSecondaryColor3uivEXT");
	glad_glSecondaryColor3usEXT = (PFNGLSECONDARYCOLOR3USEXTPROC)load("glSecondaryColor3usEXT");
	glad_glSecondaryColor3usvEXT = (PFNGLSECONDARYCOLOR3USVEXTPROC)load("glSecondaryColor3usvEXT");
	glad_glSecondaryColorPointerEXT = (PFNGLSECONDARYCOLORPOINTEREXTPROC)load("glSecondaryColorPointerEXT");
}
static void load_GL_EXT_separate_shader_objects(GLADloadproc load) {
	if(!GLAD_GL_EXT_separate_shader_objects) return;
	glad_glUseShaderProgramEXT = (PFNGLUSESHADERPROGRAMEXTPROC)load("glUseShaderProgramEXT");
	glad_glActiveProgramEXT = (PFNGLACTIVEPROGRAMEXTPROC)load("glActiveProgramEXT");
	glad_glCreateShaderProgramEXT = (PFNGLCREATESHADERPROGRAMEXTPROC)load("glCreateShaderProgramEXT");
	glad_glActiveShaderProgramEXT = (PFNGLACTIVESHADERPROGRAMEXTPROC)load("glActiveShaderProgramEXT");
	glad_glBindProgramPipelineEXT = (PFNGLBINDPROGRAMPIPELINEEXTPROC)load("glBindProgramPipelineEXT");
	glad_glCreateShaderProgramvEXT = (PFNGLCREATESHADERPROGRAMVEXTPROC)load("glCreateShaderProgramvEXT");
	glad_glDeleteProgramPipelinesEXT = (PFNGLDELETEPROGRAMPIPELINESEXTPROC)load("glDeleteProgramPipelinesEXT");
	glad_glGenProgramPipelinesEXT = (PFNGLGENPROGRAMPIPELINESEXTPROC)load("glGenProgramPipelinesEXT");
	glad_glGetProgramPipelineInfoLogEXT = (PFNGLGETPROGRAMPIPELINEINFOLOGEXTPROC)load("glGetProgramPipelineInfoLogEXT");
	glad_glGetProgramPipelineivEXT = (PFNGLGETPROGRAMPIPELINEIVEXTPROC)load("glGetProgramPipelineivEXT");
	glad_glIsProgramPipelineEXT = (PFNGLISPROGRAMPIPELINEEXTPROC)load("glIsProgramPipelineEXT");
	glad_glProgramParameteriEXT = (PFNGLPROGRAMPARAMETERIEXTPROC)load("glProgramParameteriEXT");
	glad_glProgramUniform1fEXT = (PFNGLPROGRAMUNIFORM1FEXTPROC)load("glProgramUniform1fEXT");
	glad_glProgramUniform1fvEXT = (PFNGLPROGRAMUNIFORM1FVEXTPROC)load("glProgramUniform1fvEXT");
	glad_glProgramUniform1iEXT = (PFNGLPROGRAMUNIFORM1IEXTPROC)load("glProgramUniform1iEXT");
	glad_glProgramUniform1ivEXT = (PFNGLPROGRAMUNIFORM1IVEXTPROC)load("glProgramUniform1ivEXT");
	glad_glProgramUniform2fEXT = (PFNGLPROGRAMUNIFORM2FEXTPROC)load("glProgramUniform2fEXT");
	glad_glProgramUniform2fvEXT = (PFNGLPROGRAMUNIFORM2FVEXTPROC)load("glProgramUniform2fvEXT");
	glad_glProgramUniform2iEXT = (PFNGLPROGRAMUNIFORM2IEXTPROC)load("glProgramUniform2iEXT");
	glad_glProgramUniform2ivEXT = (PFNGLPROGRAMUNIFORM2IVEXTPROC)load("glProgramUniform2ivEXT");
	glad_glProgramUniform3fEXT = (PFNGLPROGRAMUNIFORM3FEXTPROC)load("glProgramUniform3fEXT");
	glad_glProgramUniform3fvEXT = (PFNGLPROGRAMUNIFORM3FVEXTPROC)load("glProgramUniform3fvEXT");
	glad_glProgramUniform3iEXT = (PFNGLPROGRAMUNIFORM3IEXTPROC)load("glProgramUniform3iEXT");
	glad_glProgramUniform3ivEXT = (PFNGLPROGRAMUNIFORM3IVEXTPROC)load("glProgramUniform3ivEXT");
	glad_glProgramUniform4fEXT = (PFNGLPROGRAMUNIFORM4FEXTPROC)load("glProgramUniform4fEXT");
	glad_glProgramUniform4fvEXT = (PFNGLPROGRAMUNIFORM4FVEXTPROC)load("glProgramUniform4fvEXT");
	glad_glProgramUniform4iEXT = (PFNGLPROGRAMUNIFORM4IEXTPROC)load("glProgramUniform4iEXT");
	glad_glProgramUniform4ivEXT = (PFNGLPROGRAMUNIFORM4IVEXTPROC)load("glProgramUniform4ivEXT");
	glad_glProgramUniformMatrix2fvEXT = (PFNGLPROGRAMUNIFORMMATRIX2FVEXTPROC)load("glProgramUniformMatrix2fvEXT");
	glad_glProgramUniformMatrix3fvEXT = (PFNGLPROGRAMUNIFORMMATRIX3FVEXTPROC)load("glProgramUniformMatrix3fvEXT");
	glad_glProgramUniformMatrix4fvEXT = (PFNGLPROGRAMUNIFORMMATRIX4FVEXTPROC)load("glProgramUniformMatrix4fvEXT");
	glad_glUseProgramStagesEXT = (PFNGLUSEPROGRAMSTAGESEXTPROC)load("glUseProgramStagesEXT");
	glad_glValidateProgramPipelineEXT = (PFNGLVALIDATEPROGRAMPIPELINEEXTPROC)load("glValidateProgramPipelineEXT");
	glad_glProgramUniform1uiEXT = (PFNGLPROGRAMUNIFORM1UIEXTPROC)load("glProgramUniform1uiEXT");
	glad_glProgramUniform2uiEXT = (PFNGLPROGRAMUNIFORM2UIEXTPROC)load("glProgramUniform2uiEXT");
	glad_glProgramUniform3uiEXT = (PFNGLPROGRAMUNIFORM3UIEXTPROC)load("glProgramUniform3uiEXT");
	glad_glProgramUniform4uiEXT = (PFNGLPROGRAMUNIFORM4UIEXTPROC)load("glProgramUniform4uiEXT");
	glad_glProgramUniform1uivEXT = (PFNGLPROGRAMUNIFORM1UIVEXTPROC)load("glProgramUniform1uivEXT");
	glad_glProgramUniform2uivEXT = (PFNGLPROGRAMUNIFORM2UIVEXTPROC)load("glProgramUniform2uivEXT");
	glad_glProgramUniform3uivEXT = (PFNGLPROGRAMUNIFORM3UIVEXTPROC)load("glProgramUniform3uivEXT");
	glad_glProgramUniform4uivEXT = (PFNGLPROGRAMUNIFORM4UIVEXTPROC)load("glProgramUniform4uivEXT");
	glad_glProgramUniformMatrix4fvEXT = (PFNGLPROGRAMUNIFORMMATRIX4FVEXTPROC)load("glProgramUniformMatrix4fvEXT");
	glad_glProgramUniformMatrix2x3fvEXT = (PFNGLPROGRAMUNIFORMMATRIX2X3FVEXTPROC)load("glProgramUniformMatrix2x3fvEXT");
	glad_glProgramUniformMatrix3x2fvEXT = (PFNGLPROGRAMUNIFORMMATRIX3X2FVEXTPROC)load("glProgramUniformMatrix3x2fvEXT");
	glad_glProgramUniformMatrix2x4fvEXT = (PFNGLPROGRAMUNIFORMMATRIX2X4FVEXTPROC)load("glProgramUniformMatrix2x4fvEXT");
	glad_glProgramUniformMatrix4x2fvEXT = (PFNGLPROGRAMUNIFORMMATRIX4X2FVEXTPROC)load("glProgramUniformMatrix4x2fvEXT");
	glad_glProgramUniformMatrix3x4fvEXT = (PFNGLPROGRAMUNIFORMMATRIX3X4FVEXTPROC)load("glProgramUniformMatrix3x4fvEXT");
	glad_glProgramUniformMatrix4x3fvEXT = (PFNGLPROGRAMUNIFORMMATRIX4X3FVEXTPROC)load("glProgramUniformMatrix4x3fvEXT");
}
static void load_GL_EXT_shader_image_load_store(GLADloadproc load) {
	if(!GLAD_GL_EXT_shader_image_load_store) return;
	glad_glBindImageTextureEXT = (PFNGLBINDIMAGETEXTUREEXTPROC)load("glBindImageTextureEXT");
	glad_glMemoryBarrierEXT = (PFNGLMEMORYBARRIEREXTPROC)load("glMemoryBarrierEXT");
}
static void load_GL_EXT_stencil_clear_tag(GLADloadproc load) {
	if(!GLAD_GL_EXT_stencil_clear_tag) return;
	glad_glStencilClearTagEXT = (PFNGLSTENCILCLEARTAGEXTPROC)load("glStencilClearTagEXT");
}
static void load_GL_EXT_stencil_two_side(GLADloadproc load) {
	if(!GLAD_GL_EXT_stencil_two_side) return;
	glad_glActiveStencilFaceEXT = (PFNGLACTIVESTENCILFACEEXTPROC)load("glActiveStencilFaceEXT");
}
static void load_GL_EXT_subtexture(GLADloadproc load) {
	if(!GLAD_GL_EXT_subtexture) return;
	glad_glTexSubImage1DEXT = (PFNGLTEXSUBIMAGE1DEXTPROC)load("glTexSubImage1DEXT");
	glad_glTexSubImage2DEXT = (PFNGLTEXSUBIMAGE2DEXTPROC)load("glTexSubImage2DEXT");
}
static void load_GL_EXT_texture3D(GLADloadproc load) {
	if(!GLAD_GL_EXT_texture3D) return;
	glad_glTexImage3DEXT = (PFNGLTEXIMAGE3DEXTPROC)load("glTexImage3DEXT");
	glad_glTexSubImage3DEXT = (PFNGLTEXSUBIMAGE3DEXTPROC)load("glTexSubImage3DEXT");
}
static void load_GL_EXT_texture_array(GLADloadproc load) {
	if(!GLAD_GL_EXT_texture_array) return;
	glad_glFramebufferTextureLayerEXT = (PFNGLFRAMEBUFFERTEXTURELAYEREXTPROC)load("glFramebufferTextureLayerEXT");
}
static void load_GL_EXT_texture_buffer_object(GLADloadproc load) {
	if(!GLAD_GL_EXT_texture_buffer_object) return;
	glad_glTexBufferEXT = (PFNGLTEXBUFFEREXTPROC)load("glTexBufferEXT");
}
static void load_GL_EXT_texture_filter_minmax(GLADloadproc load) {
	if(!GLAD_GL_EXT_texture_filter_minmax) return;
	glad_glRasterSamplesEXT = (PFNGLRASTERSAMPLESEXTPROC)load("glRasterSamplesEXT");
}
static void load_GL_EXT_texture_integer(GLADloadproc load) {
	if(!GLAD_GL_EXT_texture_integer) return;
	glad_glTexParameterIivEXT = (PFNGLTEXPARAMETERIIVEXTPROC)load("glTexParameterIivEXT");
	glad_glTexParameterIuivEXT = (PFNGLTEXPARAMETERIUIVEXTPROC)load("glTexParameterIuivEXT");
	glad_glGetTexParameterIivEXT = (PFNGLGETTEXPARAMETERIIVEXTPROC)load("glGetTexParameterIivEXT");
	glad_glGetTexParameterIuivEXT = (PFNGLGETTEXPARAMETERIUIVEXTPROC)load("glGetTexParameterIuivEXT");
	glad_glClearColorIiEXT = (PFNGLCLEARCOLORIIEXTPROC)load("glClearColorIiEXT");
	glad_glClearColorIuiEXT = (PFNGLCLEARCOLORIUIEXTPROC)load("glClearColorIuiEXT");
}
static void load_GL_EXT_texture_object(GLADloadproc load) {
	if(!GLAD_GL_EXT_texture_object) return;
	glad_glAreTexturesResidentEXT = (PFNGLARETEXTURESRESIDENTEXTPROC)load("glAreTexturesResidentEXT");
	glad_glBindTextureEXT = (PFNGLBINDTEXTUREEXTPROC)load("glBindTextureEXT");
	glad_glDeleteTexturesEXT = (PFNGLDELETETEXTURESEXTPROC)load("glDeleteTexturesEXT");
	glad_glGenTexturesEXT = (PFNGLGENTEXTURESEXTPROC)load("glGenTexturesEXT");
	glad_glIsTextureEXT = (PFNGLISTEXTUREEXTPROC)load("glIsTextureEXT");
	glad_glPrioritizeTexturesEXT = (PFNGLPRIORITIZETEXTURESEXTPROC)load("glPrioritizeTexturesEXT");
}
static void load_GL_EXT_texture_perturb_normal(GLADloadproc load) {
	if(!GLAD_GL_EXT_texture_perturb_normal) return;
	glad_glTextureNormalEXT = (PFNGLTEXTURENORMALEXTPROC)load("glTextureNormalEXT");
}
static void load_GL_EXT_timer_query(GLADloadproc load) {
	if(!GLAD_GL_EXT_timer_query) return;
	glad_glGetQueryObjecti64vEXT = (PFNGLGETQUERYOBJECTI64VEXTPROC)load("glGetQueryObjecti64vEXT");
	glad_glGetQueryObjectui64vEXT = (PFNGLGETQUERYOBJECTUI64VEXTPROC)load("glGetQueryObjectui64vEXT");
}
static void load_GL_EXT_transform_feedback(GLADloadproc load) {
	if(!GLAD_GL_EXT_transform_feedback) return;
	glad_glBeginTransformFeedbackEXT = (PFNGLBEGINTRANSFORMFEEDBACKEXTPROC)load("glBeginTransformFeedbackEXT");
	glad_glEndTransformFeedbackEXT = (PFNGLENDTRANSFORMFEEDBACKEXTPROC)load("glEndTransformFeedbackEXT");
	glad_glBindBufferRangeEXT = (PFNGLBINDBUFFERRANGEEXTPROC)load("glBindBufferRangeEXT");
	glad_glBindBufferOffsetEXT = (PFNGLBINDBUFFEROFFSETEXTPROC)load("glBindBufferOffsetEXT");
	glad_glBindBufferBaseEXT = (PFNGLBINDBUFFERBASEEXTPROC)load("glBindBufferBaseEXT");
	glad_glTransformFeedbackVaryingsEXT = (PFNGLTRANSFORMFEEDBACKVARYINGSEXTPROC)load("glTransformFeedbackVaryingsEXT");
	glad_glGetTransformFeedbackVaryingEXT = (PFNGLGETTRANSFORMFEEDBACKVARYINGEXTPROC)load("glGetTransformFeedbackVaryingEXT");
}
static void load_GL_EXT_vertex_array(GLADloadproc load) {
	if(!GLAD_GL_EXT_vertex_array) return;
	glad_glArrayElementEXT = (PFNGLARRAYELEMENTEXTPROC)load("glArrayElementEXT");
	glad_glColorPointerEXT = (PFNGLCOLORPOINTEREXTPROC)load("glColorPointerEXT");
	glad_glDrawArraysEXT = (PFNGLDRAWARRAYSEXTPROC)load("glDrawArraysEXT");
	glad_glEdgeFlagPointerEXT = (PFNGLEDGEFLAGPOINTEREXTPROC)load("glEdgeFlagPointerEXT");
	glad_glGetPointervEXT = (PFNGLGETPOINTERVEXTPROC)load("glGetPointervEXT");
	glad_glIndexPointerEXT = (PFNGLINDEXPOINTEREXTPROC)load("glIndexPointerEXT");
	glad_glNormalPointerEXT = (PFNGLNORMALPOINTEREXTPROC)load("glNormalPointerEXT");
	glad_glTexCoordPointerEXT = (PFNGLTEXCOORDPOINTEREXTPROC)load("glTexCoordPointerEXT");
	glad_glVertexPointerEXT = (PFNGLVERTEXPOINTEREXTPROC)load("glVertexPointerEXT");
}
static void load_GL_EXT_vertex_attrib_64bit(GLADloadproc load) {
	if(!GLAD_GL_EXT_vertex_attrib_64bit) return;
	glad_glVertexAttribL1dEXT = (PFNGLVERTEXATTRIBL1DEXTPROC)load("glVertexAttribL1dEXT");
	glad_glVertexAttribL2dEXT = (PFNGLVERTEXATTRIBL2DEXTPROC)load("glVertexAttribL2dEXT");
	glad_glVertexAttribL3dEXT = (PFNGLVERTEXATTRIBL3DEXTPROC)load("glVertexAttribL3dEXT");
	glad_glVertexAttribL4dEXT = (PFNGLVERTEXATTRIBL4DEXTPROC)load("glVertexAttribL4dEXT");
	glad_glVertexAttribL1dvEXT = (PFNGLVERTEXATTRIBL1DVEXTPROC)load("glVertexAttribL1dvEXT");
	glad_glVertexAttribL2dvEXT = (PFNGLVERTEXATTRIBL2DVEXTPROC)load("glVertexAttribL2dvEXT");
	glad_glVertexAttribL3dvEXT = (PFNGLVERTEXATTRIBL3DVEXTPROC)load("glVertexAttribL3dvEXT");
	glad_glVertexAttribL4dvEXT = (PFNGLVERTEXATTRIBL4DVEXTPROC)load("glVertexAttribL4dvEXT");
	glad_glVertexAttribLPointerEXT = (PFNGLVERTEXATTRIBLPOINTEREXTPROC)load("glVertexAttribLPointerEXT");
	glad_glGetVertexAttribLdvEXT = (PFNGLGETVERTEXATTRIBLDVEXTPROC)load("glGetVertexAttribLdvEXT");
}
static void load_GL_EXT_vertex_shader(GLADloadproc load) {
	if(!GLAD_GL_EXT_vertex_shader) return;
	glad_glBeginVertexShaderEXT = (PFNGLBEGINVERTEXSHADEREXTPROC)load("glBeginVertexShaderEXT");
	glad_glEndVertexShaderEXT = (PFNGLENDVERTEXSHADEREXTPROC)load("glEndVertexShaderEXT");
	glad_glBindVertexShaderEXT = (PFNGLBINDVERTEXSHADEREXTPROC)load("glBindVertexShaderEXT");
	glad_glGenVertexShadersEXT = (PFNGLGENVERTEXSHADERSEXTPROC)load("glGenVertexShadersEXT");
	glad_glDeleteVertexShaderEXT = (PFNGLDELETEVERTEXSHADEREXTPROC)load("glDeleteVertexShaderEXT");
	glad_glShaderOp1EXT = (PFNGLSHADEROP1EXTPROC)load("glShaderOp1EXT");
	glad_glShaderOp2EXT = (PFNGLSHADEROP2EXTPROC)load("glShaderOp2EXT");
	glad_glShaderOp3EXT = (PFNGLSHADEROP3EXTPROC)load("glShaderOp3EXT");
	glad_glSwizzleEXT = (PFNGLSWIZZLEEXTPROC)load("glSwizzleEXT");
	glad_glWriteMaskEXT = (PFNGLWRITEMASKEXTPROC)load("glWriteMaskEXT");
	glad_glInsertComponentEXT = (PFNGLINSERTCOMPONENTEXTPROC)load("glInsertComponentEXT");
	glad_glExtractComponentEXT = (PFNGLEXTRACTCOMPONENTEXTPROC)load("glExtractComponentEXT");
	glad_glGenSymbolsEXT = (PFNGLGENSYMBOLSEXTPROC)load("glGenSymbolsEXT");
	glad_glSetInvariantEXT = (PFNGLSETINVARIANTEXTPROC)load("glSetInvariantEXT");
	glad_glSetLocalConstantEXT = (PFNGLSETLOCALCONSTANTEXTPROC)load("glSetLocalConstantEXT");
	glad_glVariantbvEXT = (PFNGLVARIANTBVEXTPROC)load("glVariantbvEXT");
	glad_glVariantsvEXT = (PFNGLVARIANTSVEXTPROC)load("glVariantsvEXT");
	glad_glVariantivEXT = (PFNGLVARIANTIVEXTPROC)load("glVariantivEXT");
	glad_glVariantfvEXT = (PFNGLVARIANTFVEXTPROC)load("glVariantfvEXT");
	glad_glVariantdvEXT = (PFNGLVARIANTDVEXTPROC)load("glVariantdvEXT");
	glad_glVariantubvEXT = (PFNGLVARIANTUBVEXTPROC)load("glVariantubvEXT");
	glad_glVariantusvEXT = (PFNGLVARIANTUSVEXTPROC)load("glVariantusvEXT");
	glad_glVariantuivEXT = (PFNGLVARIANTUIVEXTPROC)load("glVariantuivEXT");
	glad_glVariantPointerEXT = (PFNGLVARIANTPOINTEREXTPROC)load("glVariantPointerEXT");
	glad_glEnableVariantClientStateEXT = (PFNGLENABLEVARIANTCLIENTSTATEEXTPROC)load("glEnableVariantClientStateEXT");
	glad_glDisableVariantClientStateEXT = (PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC)load("glDisableVariantClientStateEXT");
	glad_glBindLightParameterEXT = (PFNGLBINDLIGHTPARAMETEREXTPROC)load("glBindLightParameterEXT");
	glad_glBindMaterialParameterEXT = (PFNGLBINDMATERIALPARAMETEREXTPROC)load("glBindMaterialParameterEXT");
	glad_glBindTexGenParameterEXT = (PFNGLBINDTEXGENPARAMETEREXTPROC)load("glBindTexGenParameterEXT");
	glad_glBindTextureUnitParameterEXT = (PFNGLBINDTEXTUREUNITPARAMETEREXTPROC)load("glBindTextureUnitParameterEXT");
	glad_glBindParameterEXT = (PFNGLBINDPARAMETEREXTPROC)load("glBindParameterEXT");
	glad_glIsVariantEnabledEXT = (PFNGLISVARIANTENABLEDEXTPROC)load("glIsVariantEnabledEXT");
	glad_glGetVariantBooleanvEXT = (PFNGLGETVARIANTBOOLEANVEXTPROC)load("glGetVariantBooleanvEXT");
	glad_glGetVariantIntegervEXT = (PFNGLGETVARIANTINTEGERVEXTPROC)load("glGetVariantIntegervEXT");
	glad_glGetVariantFloatvEXT = (PFNGLGETVARIANTFLOATVEXTPROC)load("glGetVariantFloatvEXT");
	glad_glGetVariantPointervEXT = (PFNGLGETVARIANTPOINTERVEXTPROC)load("glGetVariantPointervEXT");
	glad_glGetInvariantBooleanvEXT = (PFNGLGETINVARIANTBOOLEANVEXTPROC)load("glGetInvariantBooleanvEXT");
	glad_glGetInvariantIntegervEXT = (PFNGLGETINVARIANTINTEGERVEXTPROC)load("glGetInvariantIntegervEXT");
	glad_glGetInvariantFloatvEXT = (PFNGLGETINVARIANTFLOATVEXTPROC)load("glGetInvariantFloatvEXT");
	glad_glGetLocalConstantBooleanvEXT = (PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC)load("glGetLocalConstantBooleanvEXT");
	glad_glGetLocalConstantIntegervEXT = (PFNGLGETLOCALCONSTANTINTEGERVEXTPROC)load("glGetLocalConstantIntegervEXT");
	glad_glGetLocalConstantFloatvEXT = (PFNGLGETLOCALCONSTANTFLOATVEXTPROC)load("glGetLocalConstantFloatvEXT");
}
static void load_GL_EXT_vertex_weighting(GLADloadproc load) {
	if(!GLAD_GL_EXT_vertex_weighting) return;
	glad_glVertexWeightfEXT = (PFNGLVERTEXWEIGHTFEXTPROC)load("glVertexWeightfEXT");
	glad_glVertexWeightfvEXT = (PFNGLVERTEXWEIGHTFVEXTPROC)load("glVertexWeightfvEXT");
	glad_glVertexWeightPointerEXT = (PFNGLVERTEXWEIGHTPOINTEREXTPROC)load("glVertexWeightPointerEXT");
}
static void load_GL_EXT_window_rectangles(GLADloadproc load) {
	if(!GLAD_GL_EXT_window_rectangles) return;
	glad_glWindowRectanglesEXT = (PFNGLWINDOWRECTANGLESEXTPROC)load("glWindowRectanglesEXT");
}
static void load_GL_EXT_x11_sync_object(GLADloadproc load) {
	if(!GLAD_GL_EXT_x11_sync_object) return;
	glad_glImportSyncEXT = (PFNGLIMPORTSYNCEXTPROC)load("glImportSyncEXT");
}
static void load_GL_GREMEDY_frame_terminator(GLADloadproc load) {
	if(!GLAD_GL_GREMEDY_frame_terminator) return;
	glad_glFrameTerminatorGREMEDY = (PFNGLFRAMETERMINATORGREMEDYPROC)load("glFrameTerminatorGREMEDY");
}
static void load_GL_GREMEDY_string_marker(GLADloadproc load) {
	if(!GLAD_GL_GREMEDY_string_marker) return;
	glad_glStringMarkerGREMEDY = (PFNGLSTRINGMARKERGREMEDYPROC)load("glStringMarkerGREMEDY");
}
static void load_GL_HP_image_transform(GLADloadproc load) {
	if(!GLAD_GL_HP_image_transform) return;
	glad_glImageTransformParameteriHP = (PFNGLIMAGETRANSFORMPARAMETERIHPPROC)load("glImageTransformParameteriHP");
	glad_glImageTransformParameterfHP = (PFNGLIMAGETRANSFORMPARAMETERFHPPROC)load("glImageTransformParameterfHP");
	glad_glImageTransformParameterivHP = (PFNGLIMAGETRANSFORMPARAMETERIVHPPROC)load("glImageTransformParameterivHP");
	glad_glImageTransformParameterfvHP = (PFNGLIMAGETRANSFORMPARAMETERFVHPPROC)load("glImageTransformParameterfvHP");
	glad_glGetImageTransformParameterivHP = (PFNGLGETIMAGETRANSFORMPARAMETERIVHPPROC)load("glGetImageTransformParameterivHP");
	glad_glGetImageTransformParameterfvHP = (PFNGLGETIMAGETRANSFORMPARAMETERFVHPPROC)load("glGetImageTransformParameterfvHP");
}
static void load_GL_IBM_multimode_draw_arrays(GLADloadproc load) {
	if(!GLAD_GL_IBM_multimode_draw_arrays) return;
	glad_glMultiModeDrawArraysIBM = (PFNGLMULTIMODEDRAWARRAYSIBMPROC)load("glMultiModeDrawArraysIBM");
	glad_glMultiModeDrawElementsIBM = (PFNGLMULTIMODEDRAWELEMENTSIBMPROC)load("glMultiModeDrawElementsIBM");
}
static void load_GL_IBM_static_data(GLADloadproc load) {
	if(!GLAD_GL_IBM_static_data) return;
	glad_glFlushStaticDataIBM = (PFNGLFLUSHSTATICDATAIBMPROC)load("glFlushStaticDataIBM");
}
static void load_GL_IBM_vertex_array_lists(GLADloadproc load) {
	if(!GLAD_GL_IBM_vertex_array_lists) return;
	glad_glColorPointerListIBM = (PFNGLCOLORPOINTERLISTIBMPROC)load("glColorPointerListIBM");
	glad_glSecondaryColorPointerListIBM = (PFNGLSECONDARYCOLORPOINTERLISTIBMPROC)load("glSecondaryColorPointerListIBM");
	glad_glEdgeFlagPointerListIBM = (PFNGLEDGEFLAGPOINTERLISTIBMPROC)load("glEdgeFlagPointerListIBM");
	glad_glFogCoordPointerListIBM = (PFNGLFOGCOORDPOINTERLISTIBMPROC)load("glFogCoordPointerListIBM");
	glad_glIndexPointerListIBM = (PFNGLINDEXPOINTERLISTIBMPROC)load("glIndexPointerListIBM");
	glad_glNormalPointerListIBM = (PFNGLNORMALPOINTERLISTIBMPROC)load("glNormalPointerListIBM");
	glad_glTexCoordPointerListIBM = (PFNGLTEXCOORDPOINTERLISTIBMPROC)load("glTexCoordPointerListIBM");
	glad_glVertexPointerListIBM = (PFNGLVERTEXPOINTERLISTIBMPROC)load("glVertexPointerListIBM");
}
static void load_GL_INGR_blend_func_separate(GLADloadproc load) {
	if(!GLAD_GL_INGR_blend_func_separate) return;
	glad_glBlendFuncSeparateINGR = (PFNGLBLENDFUNCSEPARATEINGRPROC)load("glBlendFuncSeparateINGR");
}
static void load_GL_INTEL_framebuffer_CMAA(GLADloadproc load) {
	if(!GLAD_GL_INTEL_framebuffer_CMAA) return;
	glad_glApplyFramebufferAttachmentCMAAINTEL = (PFNGLAPPLYFRAMEBUFFERATTACHMENTCMAAINTELPROC)load("glApplyFramebufferAttachmentCMAAINTEL");
}
static void load_GL_INTEL_map_texture(GLADloadproc load) {
	if(!GLAD_GL_INTEL_map_texture) return;
	glad_glSyncTextureINTEL = (PFNGLSYNCTEXTUREINTELPROC)load("glSyncTextureINTEL");
	glad_glUnmapTexture2DINTEL = (PFNGLUNMAPTEXTURE2DINTELPROC)load("glUnmapTexture2DINTEL");
	glad_glMapTexture2DINTEL = (PFNGLMAPTEXTURE2DINTELPROC)load("glMapTexture2DINTEL");
}
static void load_GL_INTEL_parallel_arrays(GLADloadproc load) {
	if(!GLAD_GL_INTEL_parallel_arrays) return;
	glad_glVertexPointervINTEL = (PFNGLVERTEXPOINTERVINTELPROC)load("glVertexPointervINTEL");
	glad_glNormalPointervINTEL = (PFNGLNORMALPOINTERVINTELPROC)load("glNormalPointervINTEL");
	glad_glColorPointervINTEL = (PFNGLCOLORPOINTERVINTELPROC)load("glColorPointervINTEL");
	glad_glTexCoordPointervINTEL = (PFNGLTEXCOORDPOINTERVINTELPROC)load("glTexCoordPointervINTEL");
}
static void load_GL_INTEL_performance_query(GLADloadproc load) {
	if(!GLAD_GL_INTEL_performance_query) return;
	glad_glBeginPerfQueryINTEL = (PFNGLBEGINPERFQUERYINTELPROC)load("glBeginPerfQueryINTEL");
	glad_glCreatePerfQueryINTEL = (PFNGLCREATEPERFQUERYINTELPROC)load("glCreatePerfQueryINTEL");
	glad_glDeletePerfQueryINTEL = (PFNGLDELETEPERFQUERYINTELPROC)load("glDeletePerfQueryINTEL");
	glad_glEndPerfQueryINTEL = (PFNGLENDPERFQUERYINTELPROC)load("glEndPerfQueryINTEL");
	glad_glGetFirstPerfQueryIdINTEL = (PFNGLGETFIRSTPERFQUERYIDINTELPROC)load("glGetFirstPerfQueryIdINTEL");
	glad_glGetNextPerfQueryIdINTEL = (PFNGLGETNEXTPERFQUERYIDINTELPROC)load("glGetNextPerfQueryIdINTEL");
	glad_glGetPerfCounterInfoINTEL = (PFNGLGETPERFCOUNTERINFOINTELPROC)load("glGetPerfCounterInfoINTEL");
	glad_glGetPerfQueryDataINTEL = (PFNGLGETPERFQUERYDATAINTELPROC)load("glGetPerfQueryDataINTEL");
	glad_glGetPerfQueryIdByNameINTEL = (PFNGLGETPERFQUERYIDBYNAMEINTELPROC)load("glGetPerfQueryIdByNameINTEL");
	glad_glGetPerfQueryInfoINTEL = (PFNGLGETPERFQUERYINFOINTELPROC)load("glGetPerfQueryInfoINTEL");
}
static void load_GL_KHR_blend_equation_advanced(GLADloadproc load) {
	if(!GLAD_GL_KHR_blend_equation_advanced) return;
	glad_glBlendBarrierKHR = (PFNGLBLENDBARRIERKHRPROC)load("glBlendBarrierKHR");
}
static void load_GL_KHR_debug(GLADloadproc load) {
	if(!GLAD_GL_KHR_debug) return;
	glad_glDebugMessageControl = (PFNGLDEBUGMESSAGECONTROLPROC)load("glDebugMessageControl");
	glad_glDebugMessageInsert = (PFNGLDEBUGMESSAGEINSERTPROC)load("glDebugMessageInsert");
	glad_glDebugMessageCallback = (PFNGLDEBUGMESSAGECALLBACKPROC)load("glDebugMessageCallback");
	glad_glGetDebugMessageLog = (PFNGLGETDEBUGMESSAGELOGPROC)load("glGetDebugMessageLog");
	glad_glPushDebugGroup = (PFNGLPUSHDEBUGGROUPPROC)load("glPushDebugGroup");
	glad_glPopDebugGroup = (PFNGLPOPDEBUGGROUPPROC)load("glPopDebugGroup");
	glad_glObjectLabel = (PFNGLOBJECTLABELPROC)load("glObjectLabel");
	glad_glGetObjectLabel = (PFNGLGETOBJECTLABELPROC)load("glGetObjectLabel");
	glad_glObjectPtrLabel = (PFNGLOBJECTPTRLABELPROC)load("glObjectPtrLabel");
	glad_glGetObjectPtrLabel = (PFNGLGETOBJECTPTRLABELPROC)load("glGetObjectPtrLabel");
	glad_glGetPointerv = (PFNGLGETPOINTERVPROC)load("glGetPointerv");
	glad_glDebugMessageControlKHR = (PFNGLDEBUGMESSAGECONTROLKHRPROC)load("glDebugMessageControlKHR");
	glad_glDebugMessageInsertKHR = (PFNGLDEBUGMESSAGEINSERTKHRPROC)load("glDebugMessageInsertKHR");
	glad_glDebugMessageCallbackKHR = (PFNGLDEBUGMESSAGECALLBACKKHRPROC)load("glDebugMessageCallbackKHR");
	glad_glGetDebugMessageLogKHR = (PFNGLGETDEBUGMESSAGELOGKHRPROC)load("glGetDebugMessageLogKHR");
	glad_glPushDebugGroupKHR = (PFNGLPUSHDEBUGGROUPKHRPROC)load("glPushDebugGroupKHR");
	glad_glPopDebugGroupKHR = (PFNGLPOPDEBUGGROUPKHRPROC)load("glPopDebugGroupKHR");
	glad_glObjectLabelKHR = (PFNGLOBJECTLABELKHRPROC)load("glObjectLabelKHR");
	glad_glGetObjectLabelKHR = (PFNGLGETOBJECTLABELKHRPROC)load("glGetObjectLabelKHR");
	glad_glObjectPtrLabelKHR = (PFNGLOBJECTPTRLABELKHRPROC)load("glObjectPtrLabelKHR");
	glad_glGetObjectPtrLabelKHR = (PFNGLGETOBJECTPTRLABELKHRPROC)load("glGetObjectPtrLabelKHR");
	glad_glGetPointervKHR = (PFNGLGETPOINTERVKHRPROC)load("glGetPointervKHR");
}
static void load_GL_KHR_robustness(GLADloadproc load) {
	if(!GLAD_GL_KHR_robustness) return;
	glad_glGetGraphicsResetStatus = (PFNGLGETGRAPHICSRESETSTATUSPROC)load("glGetGraphicsResetStatus");
	glad_glReadnPixels = (PFNGLREADNPIXELSPROC)load("glReadnPixels");
	glad_glGetnUniformfv = (PFNGLGETNUNIFORMFVPROC)load("glGetnUniformfv");
	glad_glGetnUniformiv = (PFNGLGETNUNIFORMIVPROC)load("glGetnUniformiv");
	glad_glGetnUniformuiv = (PFNGLGETNUNIFORMUIVPROC)load("glGetnUniformuiv");
	glad_glGetGraphicsResetStatusKHR = (PFNGLGETGRAPHICSRESETSTATUSKHRPROC)load("glGetGraphicsResetStatusKHR");
	glad_glReadnPixelsKHR = (PFNGLREADNPIXELSKHRPROC)load("glReadnPixelsKHR");
	glad_glGetnUniformfvKHR = (PFNGLGETNUNIFORMFVKHRPROC)load("glGetnUniformfvKHR");
	glad_glGetnUniformivKHR = (PFNGLGETNUNIFORMIVKHRPROC)load("glGetnUniformivKHR");
	glad_glGetnUniformuivKHR = (PFNGLGETNUNIFORMUIVKHRPROC)load("glGetnUniformuivKHR");
}
static void load_GL_MESA_resize_buffers(GLADloadproc load) {
	if(!GLAD_GL_MESA_resize_buffers) return;
	glad_glResizeBuffersMESA = (PFNGLRESIZEBUFFERSMESAPROC)load("glResizeBuffersMESA");
}
static void load_GL_MESA_window_pos(GLADloadproc load) {
	if(!GLAD_GL_MESA_window_pos) return;
	glad_glWindowPos2dMESA = (PFNGLWINDOWPOS2DMESAPROC)load("glWindowPos2dMESA");
	glad_glWindowPos2dvMESA = (PFNGLWINDOWPOS2DVMESAPROC)load("glWindowPos2dvMESA");
	glad_glWindowPos2fMESA = (PFNGLWINDOWPOS2FMESAPROC)load("glWindowPos2fMESA");
	glad_glWindowPos2fvMESA = (PFNGLWINDOWPOS2FVMESAPROC)load("glWindowPos2fvMESA");
	glad_glWindowPos2iMESA = (PFNGLWINDOWPOS2IMESAPROC)load("glWindowPos2iMESA");
	glad_glWindowPos2ivMESA = (PFNGLWINDOWPOS2IVMESAPROC)load("glWindowPos2ivMESA");
	glad_glWindowPos2sMESA = (PFNGLWINDOWPOS2SMESAPROC)load("glWindowPos2sMESA");
	glad_glWindowPos2svMESA = (PFNGLWINDOWPOS2SVMESAPROC)load("glWindowPos2svMESA");
	glad_glWindowPos3dMESA = (PFNGLWINDOWPOS3DMESAPROC)load("glWindowPos3dMESA");
	glad_glWindowPos3dvMESA = (PFNGLWINDOWPOS3DVMESAPROC)load("glWindowPos3dvMESA");
	glad_glWindowPos3fMESA = (PFNGLWINDOWPOS3FMESAPROC)load("glWindowPos3fMESA");
	glad_glWindowPos3fvMESA = (PFNGLWINDOWPOS3FVMESAPROC)load("glWindowPos3fvMESA");
	glad_glWindowPos3iMESA = (PFNGLWINDOWPOS3IMESAPROC)load("glWindowPos3iMESA");
	glad_glWindowPos3ivMESA = (PFNGLWINDOWPOS3IVMESAPROC)load("glWindowPos3ivMESA");
	glad_glWindowPos3sMESA = (PFNGLWINDOWPOS3SMESAPROC)load("glWindowPos3sMESA");
	glad_glWindowPos3svMESA = (PFNGLWINDOWPOS3SVMESAPROC)load("glWindowPos3svMESA");
	glad_glWindowPos4dMESA = (PFNGLWINDOWPOS4DMESAPROC)load("glWindowPos4dMESA");
	glad_glWindowPos4dvMESA = (PFNGLWINDOWPOS4DVMESAPROC)load("glWindowPos4dvMESA");
	glad_glWindowPos4fMESA = (PFNGLWINDOWPOS4FMESAPROC)load("glWindowPos4fMESA");
	glad_glWindowPos4fvMESA = (PFNGLWINDOWPOS4FVMESAPROC)load("glWindowPos4fvMESA");
	glad_glWindowPos4iMESA = (PFNGLWINDOWPOS4IMESAPROC)load("glWindowPos4iMESA");
	glad_glWindowPos4ivMESA = (PFNGLWINDOWPOS4IVMESAPROC)load("glWindowPos4ivMESA");
	glad_glWindowPos4sMESA = (PFNGLWINDOWPOS4SMESAPROC)load("glWindowPos4sMESA");
	glad_glWindowPos4svMESA = (PFNGLWINDOWPOS4SVMESAPROC)load("glWindowPos4svMESA");
}
static void load_GL_NVX_conditional_render(GLADloadproc load) {
	if(!GLAD_GL_NVX_conditional_render) return;
	glad_glBeginConditionalRenderNVX = (PFNGLBEGINCONDITIONALRENDERNVXPROC)load("glBeginConditionalRenderNVX");
	glad_glEndConditionalRenderNVX = (PFNGLENDCONDITIONALRENDERNVXPROC)load("glEndConditionalRenderNVX");
}
static void load_GL_NV_bindless_multi_draw_indirect(GLADloadproc load) {
	if(!GLAD_GL_NV_bindless_multi_draw_indirect) return;
	glad_glMultiDrawArraysIndirectBindlessNV = (PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSNVPROC)load("glMultiDrawArraysIndirectBindlessNV");
	glad_glMultiDrawElementsIndirectBindlessNV = (PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSNVPROC)load("glMultiDrawElementsIndirectBindlessNV");
}
static void load_GL_NV_bindless_multi_draw_indirect_count(GLADloadproc load) {
	if(!GLAD_GL_NV_bindless_multi_draw_indirect_count) return;
	glad_glMultiDrawArraysIndirectBindlessCountNV = (PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSCOUNTNVPROC)load("glMultiDrawArraysIndirectBindlessCountNV");
	glad_glMultiDrawElementsIndirectBindlessCountNV = (PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSCOUNTNVPROC)load("glMultiDrawElementsIndirectBindlessCountNV");
}
static void load_GL_NV_bindless_texture(GLADloadproc load) {
	if(!GLAD_GL_NV_bindless_texture) return;
	glad_glGetTextureHandleNV = (PFNGLGETTEXTUREHANDLENVPROC)load("glGetTextureHandleNV");
	glad_glGetTextureSamplerHandleNV = (PFNGLGETTEXTURESAMPLERHANDLENVPROC)load("glGetTextureSamplerHandleNV");
	glad_glMakeTextureHandleResidentNV = (PFNGLMAKETEXTUREHANDLERESIDENTNVPROC)load("glMakeTextureHandleResidentNV");
	glad_glMakeTextureHandleNonResidentNV = (PFNGLMAKETEXTUREHANDLENONRESIDENTNVPROC)load("glMakeTextureHandleNonResidentNV");
	glad_glGetImageHandleNV = (PFNGLGETIMAGEHANDLENVPROC)load("glGetImageHandleNV");
	glad_glMakeImageHandleResidentNV = (PFNGLMAKEIMAGEHANDLERESIDENTNVPROC)load("glMakeImageHandleResidentNV");
	glad_glMakeImageHandleNonResidentNV = (PFNGLMAKEIMAGEHANDLENONRESIDENTNVPROC)load("glMakeImageHandleNonResidentNV");
	glad_glUniformHandleui64NV = (PFNGLUNIFORMHANDLEUI64NVPROC)load("glUniformHandleui64NV");
	glad_glUniformHandleui64vNV = (PFNGLUNIFORMHANDLEUI64VNVPROC)load("glUniformHandleui64vNV");
	glad_glProgramUniformHandleui64NV = (PFNGLPROGRAMUNIFORMHANDLEUI64NVPROC)load("glProgramUniformHandleui64NV");
	glad_glProgramUniformHandleui64vNV = (PFNGLPROGRAMUNIFORMHANDLEUI64VNVPROC)load("glProgramUniformHandleui64vNV");
	glad_glIsTextureHandleResidentNV = (PFNGLISTEXTUREHANDLERESIDENTNVPROC)load("glIsTextureHandleResidentNV");
	glad_glIsImageHandleResidentNV = (PFNGLISIMAGEHANDLERESIDENTNVPROC)load("glIsImageHandleResidentNV");
}
static void load_GL_NV_blend_equation_advanced(GLADloadproc load) {
	if(!GLAD_GL_NV_blend_equation_advanced) return;
	glad_glBlendParameteriNV = (PFNGLBLENDPARAMETERINVPROC)load("glBlendParameteriNV");
	glad_glBlendBarrierNV = (PFNGLBLENDBARRIERNVPROC)load("glBlendBarrierNV");
}
static void load_GL_NV_clip_space_w_scaling(GLADloadproc load) {
	if(!GLAD_GL_NV_clip_space_w_scaling) return;
	glad_glViewportPositionWScaleNV = (PFNGLVIEWPORTPOSITIONWSCALENVPROC)load("glViewportPositionWScaleNV");
}
static void load_GL_NV_command_list(GLADloadproc load) {
	if(!GLAD_GL_NV_command_list) return;
	glad_glCreateStatesNV = (PFNGLCREATESTATESNVPROC)load("glCreateStatesNV");
	glad_glDeleteStatesNV = (PFNGLDELETESTATESNVPROC)load("glDeleteStatesNV");
	glad_glIsStateNV = (PFNGLISSTATENVPROC)load("glIsStateNV");
	glad_glStateCaptureNV = (PFNGLSTATECAPTURENVPROC)load("glStateCaptureNV");
	glad_glGetCommandHeaderNV = (PFNGLGETCOMMANDHEADERNVPROC)load("glGetCommandHeaderNV");
	glad_glGetStageIndexNV = (PFNGLGETSTAGEINDEXNVPROC)load("glGetStageIndexNV");
	glad_glDrawCommandsNV = (PFNGLDRAWCOMMANDSNVPROC)load("glDrawCommandsNV");
	glad_glDrawCommandsAddressNV = (PFNGLDRAWCOMMANDSADDRESSNVPROC)load("glDrawCommandsAddressNV");
	glad_glDrawCommandsStatesNV = (PFNGLDRAWCOMMANDSSTATESNVPROC)load("glDrawCommandsStatesNV");
	glad_glDrawCommandsStatesAddressNV = (PFNGLDRAWCOMMANDSSTATESADDRESSNVPROC)load("glDrawCommandsStatesAddressNV");
	glad_glCreateCommandListsNV = (PFNGLCREATECOMMANDLISTSNVPROC)load("glCreateCommandListsNV");
	glad_glDeleteCommandListsNV = (PFNGLDELETECOMMANDLISTSNVPROC)load("glDeleteCommandListsNV");
	glad_glIsCommandListNV = (PFNGLISCOMMANDLISTNVPROC)load("glIsCommandListNV");
	glad_glListDrawCommandsStatesClientNV = (PFNGLLISTDRAWCOMMANDSSTATESCLIENTNVPROC)load("glListDrawCommandsStatesClientNV");
	glad_glCommandListSegmentsNV = (PFNGLCOMMANDLISTSEGMENTSNVPROC)load("glCommandListSegmentsNV");
	glad_glCompileCommandListNV = (PFNGLCOMPILECOMMANDLISTNVPROC)load("glCompileCommandListNV");
	glad_glCallCommandListNV = (PFNGLCALLCOMMANDLISTNVPROC)load("glCallCommandListNV");
}
static void load_GL_NV_conditional_render(GLADloadproc load) {
	if(!GLAD_GL_NV_conditional_render) return;
	glad_glBeginConditionalRenderNV = (PFNGLBEGINCONDITIONALRENDERNVPROC)load("glBeginConditionalRenderNV");
	glad_glEndConditionalRenderNV = (PFNGLENDCONDITIONALRENDERNVPROC)load("glEndConditionalRenderNV");
}
static void load_GL_NV_conservative_raster(GLADloadproc load) {
	if(!GLAD_GL_NV_conservative_raster) return;
	glad_glSubpixelPrecisionBiasNV = (PFNGLSUBPIXELPRECISIONBIASNVPROC)load("glSubpixelPrecisionBiasNV");
}
static void load_GL_NV_conservative_raster_dilate(GLADloadproc load) {
	if(!GLAD_GL_NV_conservative_raster_dilate) return;
	glad_glConservativeRasterParameterfNV = (PFNGLCONSERVATIVERASTERPARAMETERFNVPROC)load("glConservativeRasterParameterfNV");
}
static void load_GL_NV_conservative_raster_pre_snap_triangles(GLADloadproc load) {
	if(!GLAD_GL_NV_conservative_raster_pre_snap_triangles) return;
	glad_glConservativeRasterParameteriNV = (PFNGLCONSERVATIVERASTERPARAMETERINVPROC)load("glConservativeRasterParameteriNV");
}
static void load_GL_NV_copy_image(GLADloadproc load) {
	if(!GLAD_GL_NV_copy_image) return;
	glad_glCopyImageSubDataNV = (PFNGLCOPYIMAGESUBDATANVPROC)load("glCopyImageSubDataNV");
}
static void load_GL_NV_depth_buffer_float(GLADloadproc load) {
	if(!GLAD_GL_NV_depth_buffer_float) return;
	glad_glDepthRangedNV = (PFNGLDEPTHRANGEDNVPROC)load("glDepthRangedNV");
	glad_glClearDepthdNV = (PFNGLCLEARDEPTHDNVPROC)load("glClearDepthdNV");
	glad_glDepthBoundsdNV = (PFNGLDEPTHBOUNDSDNVPROC)load("glDepthBoundsdNV");
}
static void load_GL_NV_draw_texture(GLADloadproc load) {
	if(!GLAD_GL_NV_draw_texture) return;
	glad_glDrawTextureNV = (PFNGLDRAWTEXTURENVPROC)load("glDrawTextureNV");
}
static void load_GL_NV_evaluators(GLADloadproc load) {
	if(!GLAD_GL_NV_evaluators) return;
	glad_glMapControlPointsNV = (PFNGLMAPCONTROLPOINTSNVPROC)load("glMapControlPointsNV");
	glad_glMapParameterivNV = (PFNGLMAPPARAMETERIVNVPROC)load("glMapParameterivNV");
	glad_glMapParameterfvNV = (PFNGLMAPPARAMETERFVNVPROC)load("glMapParameterfvNV");
	glad_glGetMapControlPointsNV = (PFNGLGETMAPCONTROLPOINTSNVPROC)load("glGetMapControlPointsNV");
	glad_glGetMapParameterivNV = (PFNGLGETMAPPARAMETERIVNVPROC)load("glGetMapParameterivNV");
	glad_glGetMapParameterfvNV = (PFNGLGETMAPPARAMETERFVNVPROC)load("glGetMapParameterfvNV");
	glad_glGetMapAttribParameterivNV = (PFNGLGETMAPATTRIBPARAMETERIVNVPROC)load("glGetMapAttribParameterivNV");
	glad_glGetMapAttribParameterfvNV = (PFNGLGETMAPATTRIBPARAMETERFVNVPROC)load("glGetMapAttribParameterfvNV");
	glad_glEvalMapsNV = (PFNGLEVALMAPSNVPROC)load("glEvalMapsNV");
}
static void load_GL_NV_explicit_multisample(GLADloadproc load) {
	if(!GLAD_GL_NV_explicit_multisample) return;
	glad_glGetMultisamplefvNV = (PFNGLGETMULTISAMPLEFVNVPROC)load("glGetMultisamplefvNV");
	glad_glSampleMaskIndexedNV = (PFNGLSAMPLEMASKINDEXEDNVPROC)load("glSampleMaskIndexedNV");
	glad_glTexRenderbufferNV = (PFNGLTEXRENDERBUFFERNVPROC)load("glTexRenderbufferNV");
}
static void load_GL_NV_fence(GLADloadproc load) {
	if(!GLAD_GL_NV_fence) return;
	glad_glDeleteFencesNV = (PFNGLDELETEFENCESNVPROC)load("glDeleteFencesNV");
	glad_glGenFencesNV = (PFNGLGENFENCESNVPROC)load("glGenFencesNV");
	glad_glIsFenceNV = (PFNGLISFENCENVPROC)load("glIsFenceNV");
	glad_glTestFenceNV = (PFNGLTESTFENCENVPROC)load("glTestFenceNV");
	glad_glGetFenceivNV = (PFNGLGETFENCEIVNVPROC)load("glGetFenceivNV");
	glad_glFinishFenceNV = (PFNGLFINISHFENCENVPROC)load("glFinishFenceNV");
	glad_glSetFenceNV = (PFNGLSETFENCENVPROC)load("glSetFenceNV");
}
static void load_GL_NV_fragment_coverage_to_color(GLADloadproc load) {
	if(!GLAD_GL_NV_fragment_coverage_to_color) return;
	glad_glFragmentCoverageColorNV = (PFNGLFRAGMENTCOVERAGECOLORNVPROC)load("glFragmentCoverageColorNV");
}
static void load_GL_NV_fragment_program(GLADloadproc load) {
	if(!GLAD_GL_NV_fragment_program) return;
	glad_glProgramNamedParameter4fNV = (PFNGLPROGRAMNAMEDPARAMETER4FNVPROC)load("glProgramNamedParameter4fNV");
	glad_glProgramNamedParameter4fvNV = (PFNGLPROGRAMNAMEDPARAMETER4FVNVPROC)load("glProgramNamedParameter4fvNV");
	glad_glProgramNamedParameter4dNV = (PFNGLPROGRAMNAMEDPARAMETER4DNVPROC)load("glProgramNamedParameter4dNV");
	glad_glProgramNamedParameter4dvNV = (PFNGLPROGRAMNAMEDPARAMETER4DVNVPROC)load("glProgramNamedParameter4dvNV");
	glad_glGetProgramNamedParameterfvNV = (PFNGLGETPROGRAMNAMEDPARAMETERFVNVPROC)load("glGetProgramNamedParameterfvNV");
	glad_glGetProgramNamedParameterdvNV = (PFNGLGETPROGRAMNAMEDPARAMETERDVNVPROC)load("glGetProgramNamedParameterdvNV");
}
static void load_GL_NV_framebuffer_mixed_samples(GLADloadproc load) {
	if(!GLAD_GL_NV_framebuffer_mixed_samples) return;
	glad_glRasterSamplesEXT = (PFNGLRASTERSAMPLESEXTPROC)load("glRasterSamplesEXT");
	glad_glCoverageModulationTableNV = (PFNGLCOVERAGEMODULATIONTABLENVPROC)load("glCoverageModulationTableNV");
	glad_glGetCoverageModulationTableNV = (PFNGLGETCOVERAGEMODULATIONTABLENVPROC)load("glGetCoverageModulationTableNV");
	glad_glCoverageModulationNV = (PFNGLCOVERAGEMODULATIONNVPROC)load("glCoverageModulationNV");
}
static void load_GL_NV_framebuffer_multisample_coverage(GLADloadproc load) {
	if(!GLAD_GL_NV_framebuffer_multisample_coverage) return;
	glad_glRenderbufferStorageMultisampleCoverageNV = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLECOVERAGENVPROC)load("glRenderbufferStorageMultisampleCoverageNV");
}
static void load_GL_NV_geometry_program4(GLADloadproc load) {
	if(!GLAD_GL_NV_geometry_program4) return;
	glad_glProgramVertexLimitNV = (PFNGLPROGRAMVERTEXLIMITNVPROC)load("glProgramVertexLimitNV");
	glad_glFramebufferTextureEXT = (PFNGLFRAMEBUFFERTEXTUREEXTPROC)load("glFramebufferTextureEXT");
	glad_glFramebufferTextureLayerEXT = (PFNGLFRAMEBUFFERTEXTURELAYEREXTPROC)load("glFramebufferTextureLayerEXT");
	glad_glFramebufferTextureFaceEXT = (PFNGLFRAMEBUFFERTEXTUREFACEEXTPROC)load("glFramebufferTextureFaceEXT");
}
static void load_GL_NV_gpu_program4(GLADloadproc load) {
	if(!GLAD_GL_NV_gpu_program4) return;
	glad_glProgramLocalParameterI4iNV = (PFNGLPROGRAMLOCALPARAMETERI4INVPROC)load("glProgramLocalParameterI4iNV");
	glad_glProgramLocalParameterI4ivNV = (PFNGLPROGRAMLOCALPARAMETERI4IVNVPROC)load("glProgramLocalParameterI4ivNV");
	glad_glProgramLocalParametersI4ivNV = (PFNGLPROGRAMLOCALPARAMETERSI4IVNVPROC)load("glProgramLocalParametersI4ivNV");
	glad_glProgramLocalParameterI4uiNV = (PFNGLPROGRAMLOCALPARAMETERI4UINVPROC)load("glProgramLocalParameterI4uiNV");
	glad_glProgramLocalParameterI4uivNV = (PFNGLPROGRAMLOCALPARAMETERI4UIVNVPROC)load("glProgramLocalParameterI4uivNV");
	glad_glProgramLocalParametersI4uivNV = (PFNGLPROGRAMLOCALPARAMETERSI4UIVNVPROC)load("glProgramLocalParametersI4uivNV");
	glad_glProgramEnvParameterI4iNV = (PFNGLPROGRAMENVPARAMETERI4INVPROC)load("glProgramEnvParameterI4iNV");
	glad_glProgramEnvParameterI4ivNV = (PFNGLPROGRAMENVPARAMETERI4IVNVPROC)load("glProgramEnvParameterI4ivNV");
	glad_glProgramEnvParametersI4ivNV = (PFNGLPROGRAMENVPARAMETERSI4IVNVPROC)load("glProgramEnvParametersI4ivNV");
	glad_glProgramEnvParameterI4uiNV = (PFNGLPROGRAMENVPARAMETERI4UINVPROC)load("glProgramEnvParameterI4uiNV");
	glad_glProgramEnvParameterI4uivNV = (PFNGLPROGRAMENVPARAMETERI4UIVNVPROC)load("glProgramEnvParameterI4uivNV");
	glad_glProgramEnvParametersI4uivNV = (PFNGLPROGRAMENVPARAMETERSI4UIVNVPROC)load("glProgramEnvParametersI4uivNV");
	glad_glGetProgramLocalParameterIivNV = (PFNGLGETPROGRAMLOCALPARAMETERIIVNVPROC)load("glGetProgramLocalParameterIivNV");
	glad_glGetProgramLocalParameterIuivNV = (PFNGLGETPROGRAMLOCALPARAMETERIUIVNVPROC)load("glGetProgramLocalParameterIuivNV");
	glad_glGetProgramEnvParameterIivNV = (PFNGLGETPROGRAMENVPARAMETERIIVNVPROC)load("glGetProgramEnvParameterIivNV");
	glad_glGetProgramEnvParameterIuivNV = (PFNGLGETPROGRAMENVPARAMETERIUIVNVPROC)load("glGetProgramEnvParameterIuivNV");
}
static void load_GL_NV_gpu_program5(GLADloadproc load) {
	if(!GLAD_GL_NV_gpu_program5) return;
	glad_glProgramSubroutineParametersuivNV = (PFNGLPROGRAMSUBROUTINEPARAMETERSUIVNVPROC)load("glProgramSubroutineParametersuivNV");
	glad_glGetProgramSubroutineParameteruivNV = (PFNGLGETPROGRAMSUBROUTINEPARAMETERUIVNVPROC)load("glGetProgramSubroutineParameteruivNV");
}
static void load_GL_NV_gpu_shader5(GLADloadproc load) {
	if(!GLAD_GL_NV_gpu_shader5) return;
	glad_glUniform1i64NV = (PFNGLUNIFORM1I64NVPROC)load("glUniform1i64NV");
	glad_glUniform2i64NV = (PFNGLUNIFORM2I64NVPROC)load("glUniform2i64NV");
	glad_glUniform3i64NV = (PFNGLUNIFORM3I64NVPROC)load("glUniform3i64NV");
	glad_glUniform4i64NV = (PFNGLUNIFORM4I64NVPROC)load("glUniform4i64NV");
	glad_glUniform1i64vNV = (PFNGLUNIFORM1I64VNVPROC)load("glUniform1i64vNV");
	glad_glUniform2i64vNV = (PFNGLUNIFORM2I64VNVPROC)load("glUniform2i64vNV");
	glad_glUniform3i64vNV = (PFNGLUNIFORM3I64VNVPROC)load("glUniform3i64vNV");
	glad_glUniform4i64vNV = (PFNGLUNIFORM4I64VNVPROC)load("glUniform4i64vNV");
	glad_glUniform1ui64NV = (PFNGLUNIFORM1UI64NVPROC)load("glUniform1ui64NV");
	glad_glUniform2ui64NV = (PFNGLUNIFORM2UI64NVPROC)load("glUniform2ui64NV");
	glad_glUniform3ui64NV = (PFNGLUNIFORM3UI64NVPROC)load("glUniform3ui64NV");
	glad_glUniform4ui64NV = (PFNGLUNIFORM4UI64NVPROC)load("glUniform4ui64NV");
	glad_glUniform1ui64vNV = (PFNGLUNIFORM1UI64VNVPROC)load("glUniform1ui64vNV");
	glad_glUniform2ui64vNV = (PFNGLUNIFORM2UI64VNVPROC)load("glUniform2ui64vNV");
	glad_glUniform3ui64vNV = (PFNGLUNIFORM3UI64VNVPROC)load("glUniform3ui64vNV");
	glad_glUniform4ui64vNV = (PFNGLUNIFORM4UI64VNVPROC)load("glUniform4ui64vNV");
	glad_glGetUniformi64vNV = (PFNGLGETUNIFORMI64VNVPROC)load("glGetUniformi64vNV");
	glad_glProgramUniform1i64NV = (PFNGLPROGRAMUNIFORM1I64NVPROC)load("glProgramUniform1i64NV");
	glad_glProgramUniform2i64NV = (PFNGLPROGRAMUNIFORM2I64NVPROC)load("glProgramUniform2i64NV");
	glad_glProgramUniform3i64NV = (PFNGLPROGRAMUNIFORM3I64NVPROC)load("glProgramUniform3i64NV");
	glad_glProgramUniform4i64NV = (PFNGLPROGRAMUNIFORM4I64NVPROC)load("glProgramUniform4i64NV");
	glad_glProgramUniform1i64vNV = (PFNGLPROGRAMUNIFORM1I64VNVPROC)load("glProgramUniform1i64vNV");
	glad_glProgramUniform2i64vNV = (PFNGLPROGRAMUNIFORM2I64VNVPROC)load("glProgramUniform2i64vNV");
	glad_glProgramUniform3i64vNV = (PFNGLPROGRAMUNIFORM3I64VNVPROC)load("glProgramUniform3i64vNV");
	glad_glProgramUniform4i64vNV = (PFNGLPROGRAMUNIFORM4I64VNVPROC)load("glProgramUniform4i64vNV");
	glad_glProgramUniform1ui64NV = (PFNGLPROGRAMUNIFORM1UI64NVPROC)load("glProgramUniform1ui64NV");
	glad_glProgramUniform2ui64NV = (PFNGLPROGRAMUNIFORM2UI64NVPROC)load("glProgramUniform2ui64NV");
	glad_glProgramUniform3ui64NV = (PFNGLPROGRAMUNIFORM3UI64NVPROC)load("glProgramUniform3ui64NV");
	glad_glProgramUniform4ui64NV = (PFNGLPROGRAMUNIFORM4UI64NVPROC)load("glProgramUniform4ui64NV");
	glad_glProgramUniform1ui64vNV = (PFNGLPROGRAMUNIFORM1UI64VNVPROC)load("glProgramUniform1ui64vNV");
	glad_glProgramUniform2ui64vNV = (PFNGLPROGRAMUNIFORM2UI64VNVPROC)load("glProgramUniform2ui64vNV");
	glad_glProgramUniform3ui64vNV = (PFNGLPROGRAMUNIFORM3UI64VNVPROC)load("glProgramUniform3ui64vNV");
	glad_glProgramUniform4ui64vNV = (PFNGLPROGRAMUNIFORM4UI64VNVPROC)load("glProgramUniform4ui64vNV");
}
static void load_GL_NV_half_float(GLADloadproc load) {
	if(!GLAD_GL_NV_half_float) return;
	glad_glVertex2hNV = (PFNGLVERTEX2HNVPROC)load("glVertex2hNV");
	glad_glVertex2hvNV = (PFNGLVERTEX2HVNVPROC)load("glVertex2hvNV");
	glad_glVertex3hNV = (PFNGLVERTEX3HNVPROC)load("glVertex3hNV");
	glad_glVertex3hvNV = (PFNGLVERTEX3HVNVPROC)load("glVertex3hvNV");
	glad_glVertex4hNV = (PFNGLVERTEX4HNVPROC)load("glVertex4hNV");
	glad_glVertex4hvNV = (PFNGLVERTEX4HVNVPROC)load("glVertex4hvNV");
	glad_glNormal3hNV = (PFNGLNORMAL3HNVPROC)load("glNormal3hNV");
	glad_glNormal3hvNV = (PFNGLNORMAL3HVNVPROC)load("glNormal3hvNV");
	glad_glColor3hNV = (PFNGLCOLOR3HNVPROC)load("glColor3hNV");
	glad_glColor3hvNV = (PFNGLCOLOR3HVNVPROC)load("glColor3hvNV");
	glad_glColor4hNV = (PFNGLCOLOR4HNVPROC)load("glColor4hNV");
	glad_glColor4hvNV = (PFNGLCOLOR4HVNVPROC)load("glColor4hvNV");
	glad_glTexCoord1hNV = (PFNGLTEXCOORD1HNVPROC)load("glTexCoord1hNV");
	glad_glTexCoord1hvNV = (PFNGLTEXCOORD1HVNVPROC)load("glTexCoord1hvNV");
	glad_glTexCoord2hNV = (PFNGLTEXCOORD2HNVPROC)load("glTexCoord2hNV");
	glad_glTexCoord2hvNV = (PFNGLTEXCOORD2HVNVPROC)load("glTexCoord2hvNV");
	glad_glTexCoord3hNV = (PFNGLTEXCOORD3HNVPROC)load("glTexCoord3hNV");
	glad_glTexCoord3hvNV = (PFNGLTEXCOORD3HVNVPROC)load("glTexCoord3hvNV");
	glad_glTexCoord4hNV = (PFNGLTEXCOORD4HNVPROC)load("glTexCoord4hNV");
	glad_glTexCoord4hvNV = (PFNGLTEXCOORD4HVNVPROC)load("glTexCoord4hvNV");
	glad_glMultiTexCoord1hNV = (PFNGLMULTITEXCOORD1HNVPROC)load("glMultiTexCoord1hNV");
	glad_glMultiTexCoord1hvNV = (PFNGLMULTITEXCOORD1HVNVPROC)load("glMultiTexCoord1hvNV");
	glad_glMultiTexCoord2hNV = (PFNGLMULTITEXCOORD2HNVPROC)load("glMultiTexCoord2hNV");
	glad_glMultiTexCoord2hvNV = (PFNGLMULTITEXCOORD2HVNVPROC)load("glMultiTexCoord2hvNV");
	glad_glMultiTexCoord3hNV = (PFNGLMULTITEXCOORD3HNVPROC)load("glMultiTexCoord3hNV");
	glad_glMultiTexCoord3hvNV = (PFNGLMULTITEXCOORD3HVNVPROC)load("glMultiTexCoord3hvNV");
	glad_glMultiTexCoord4hNV = (PFNGLMULTITEXCOORD4HNVPROC)load("glMultiTexCoord4hNV");
	glad_glMultiTexCoord4hvNV = (PFNGLMULTITEXCOORD4HVNVPROC)load("glMultiTexCoord4hvNV");
	glad_glFogCoordhNV = (PFNGLFOGCOORDHNVPROC)load("glFogCoordhNV");
	glad_glFogCoordhvNV = (PFNGLFOGCOORDHVNVPROC)load("glFogCoordhvNV");
	glad_glSecondaryColor3hNV = (PFNGLSECONDARYCOLOR3HNVPROC)load("glSecondaryColor3hNV");
	glad_glSecondaryColor3hvNV = (PFNGLSECONDARYCOLOR3HVNVPROC)load("glSecondaryColor3hvNV");
	glad_glVertexWeighthNV = (PFNGLVERTEXWEIGHTHNVPROC)load("glVertexWeighthNV");
	glad_glVertexWeighthvNV = (PFNGLVERTEXWEIGHTHVNVPROC)load("glVertexWeighthvNV");
	glad_glVertexAttrib1hNV = (PFNGLVERTEXATTRIB1HNVPROC)load("glVertexAttrib1hNV");
	glad_glVertexAttrib1hvNV = (PFNGLVERTEXATTRIB1HVNVPROC)load("glVertexAttrib1hvNV");
	glad_glVertexAttrib2hNV = (PFNGLVERTEXATTRIB2HNVPROC)load("glVertexAttrib2hNV");
	glad_glVertexAttrib2hvNV = (PFNGLVERTEXATTRIB2HVNVPROC)load("glVertexAttrib2hvNV");
	glad_glVertexAttrib3hNV = (PFNGLVERTEXATTRIB3HNVPROC)load("glVertexAttrib3hNV");
	glad_glVertexAttrib3hvNV = (PFNGLVERTEXATTRIB3HVNVPROC)load("glVertexAttrib3hvNV");
	glad_glVertexAttrib4hNV = (PFNGLVERTEXATTRIB4HNVPROC)load("glVertexAttrib4hNV");
	glad_glVertexAttrib4hvNV = (PFNGLVERTEXATTRIB4HVNVPROC)load("glVertexAttrib4hvNV");
	glad_glVertexAttribs1hvNV = (PFNGLVERTEXATTRIBS1HVNVPROC)load("glVertexAttribs1hvNV");
	glad_glVertexAttribs2hvNV = (PFNGLVERTEXATTRIBS2HVNVPROC)load("glVertexAttribs2hvNV");
	glad_glVertexAttribs3hvNV = (PFNGLVERTEXATTRIBS3HVNVPROC)load("glVertexAttribs3hvNV");
	glad_glVertexAttribs4hvNV = (PFNGLVERTEXATTRIBS4HVNVPROC)load("glVertexAttribs4hvNV");
}
static void load_GL_NV_internalformat_sample_query(GLADloadproc load) {
	if(!GLAD_GL_NV_internalformat_sample_query) return;
	glad_glGetInternalformatSampleivNV = (PFNGLGETINTERNALFORMATSAMPLEIVNVPROC)load("glGetInternalformatSampleivNV");
}
static void load_GL_NV_occlusion_query(GLADloadproc load) {
	if(!GLAD_GL_NV_occlusion_query) return;
	glad_glGenOcclusionQueriesNV = (PFNGLGENOCCLUSIONQUERIESNVPROC)load("glGenOcclusionQueriesNV");
	glad_glDeleteOcclusionQueriesNV = (PFNGLDELETEOCCLUSIONQUERIESNVPROC)load("glDeleteOcclusionQueriesNV");
	glad_glIsOcclusionQueryNV = (PFNGLISOCCLUSIONQUERYNVPROC)load("glIsOcclusionQueryNV");
	glad_glBeginOcclusionQueryNV = (PFNGLBEGINOCCLUSIONQUERYNVPROC)load("glBeginOcclusionQueryNV");
	glad_glEndOcclusionQueryNV = (PFNGLENDOCCLUSIONQUERYNVPROC)load("glEndOcclusionQueryNV");
	glad_glGetOcclusionQueryivNV = (PFNGLGETOCCLUSIONQUERYIVNVPROC)load("glGetOcclusionQueryivNV");
	glad_glGetOcclusionQueryuivNV = (PFNGLGETOCCLUSIONQUERYUIVNVPROC)load("glGetOcclusionQueryuivNV");
}
static void load_GL_NV_parameter_buffer_object(GLADloadproc load) {
	if(!GLAD_GL_NV_parameter_buffer_object) return;
	glad_glProgramBufferParametersfvNV = (PFNGLPROGRAMBUFFERPARAMETERSFVNVPROC)load("glProgramBufferParametersfvNV");
	glad_glProgramBufferParametersIivNV = (PFNGLPROGRAMBUFFERPARAMETERSIIVNVPROC)load("glProgramBufferParametersIivNV");
	glad_glProgramBufferParametersIuivNV = (PFNGLPROGRAMBUFFERPARAMETERSIUIVNVPROC)load("glProgramBufferParametersIuivNV");
}
static void load_GL_NV_path_rendering(GLADloadproc load) {
	if(!GLAD_GL_NV_path_rendering) return;
	glad_glGenPathsNV = (PFNGLGENPATHSNVPROC)load("glGenPathsNV");
	glad_glDeletePathsNV = (PFNGLDELETEPATHSNVPROC)load("glDeletePathsNV");
	glad_glIsPathNV = (PFNGLISPATHNVPROC)load("glIsPathNV");
	glad_glPathCommandsNV = (PFNGLPATHCOMMANDSNVPROC)load("glPathCommandsNV");
	glad_glPathCoordsNV = (PFNGLPATHCOORDSNVPROC)load("glPathCoordsNV");
	glad_glPathSubCommandsNV = (PFNGLPATHSUBCOMMANDSNVPROC)load("glPathSubCommandsNV");
	glad_glPathSubCoordsNV = (PFNGLPATHSUBCOORDSNVPROC)load("glPathSubCoordsNV");
	glad_glPathStringNV = (PFNGLPATHSTRINGNVPROC)load("glPathStringNV");
	glad_glPathGlyphsNV = (PFNGLPATHGLYPHSNVPROC)load("glPathGlyphsNV");
	glad_glPathGlyphRangeNV = (PFNGLPATHGLYPHRANGENVPROC)load("glPathGlyphRangeNV");
	glad_glWeightPathsNV = (PFNGLWEIGHTPATHSNVPROC)load("glWeightPathsNV");
	glad_glCopyPathNV = (PFNGLCOPYPATHNVPROC)load("glCopyPathNV");
	glad_glInterpolatePathsNV = (PFNGLINTERPOLATEPATHSNVPROC)load("glInterpolatePathsNV");
	glad_glTransformPathNV = (PFNGLTRANSFORMPATHNVPROC)load("glTransformPathNV");
	glad_glPathParameterivNV = (PFNGLPATHPARAMETERIVNVPROC)load("glPathParameterivNV");
	glad_glPathParameteriNV = (PFNGLPATHPARAMETERINVPROC)load("glPathParameteriNV");
	glad_glPathParameterfvNV = (PFNGLPATHPARAMETERFVNVPROC)load("glPathParameterfvNV");
	glad_glPathParameterfNV = (PFNGLPATHPARAMETERFNVPROC)load("glPathParameterfNV");
	glad_glPathDashArrayNV = (PFNGLPATHDASHARRAYNVPROC)load("glPathDashArrayNV");
	glad_glPathStencilFuncNV = (PFNGLPATHSTENCILFUNCNVPROC)load("glPathStencilFuncNV");
	glad_glPathStencilDepthOffsetNV = (PFNGLPATHSTENCILDEPTHOFFSETNVPROC)load("glPathStencilDepthOffsetNV");
	glad_glStencilFillPathNV = (PFNGLSTENCILFILLPATHNVPROC)load("glStencilFillPathNV");
	glad_glStencilStrokePathNV = (PFNGLSTENCILSTROKEPATHNVPROC)load("glStencilStrokePathNV");
	glad_glStencilFillPathInstancedNV = (PFNGLSTENCILFILLPATHINSTANCEDNVPROC)load("glStencilFillPathInstancedNV");
	glad_glStencilStrokePathInstancedNV = (PFNGLSTENCILSTROKEPATHINSTANCEDNVPROC)load("glStencilStrokePathInstancedNV");
	glad_glPathCoverDepthFuncNV = (PFNGLPATHCOVERDEPTHFUNCNVPROC)load("glPathCoverDepthFuncNV");
	glad_glCoverFillPathNV = (PFNGLCOVERFILLPATHNVPROC)load("glCoverFillPathNV");
	glad_glCoverStrokePathNV = (PFNGLCOVERSTROKEPATHNVPROC)load("glCoverStrokePathNV");
	glad_glCoverFillPathInstancedNV = (PFNGLCOVERFILLPATHINSTANCEDNVPROC)load("glCoverFillPathInstancedNV");
	glad_glCoverStrokePathInstancedNV = (PFNGLCOVERSTROKEPATHINSTANCEDNVPROC)load("glCoverStrokePathInstancedNV");
	glad_glGetPathParameterivNV = (PFNGLGETPATHPARAMETERIVNVPROC)load("glGetPathParameterivNV");
	glad_glGetPathParameterfvNV = (PFNGLGETPATHPARAMETERFVNVPROC)load("glGetPathParameterfvNV");
	glad_glGetPathCommandsNV = (PFNGLGETPATHCOMMANDSNVPROC)load("glGetPathCommandsNV");
	glad_glGetPathCoordsNV = (PFNGLGETPATHCOORDSNVPROC)load("glGetPathCoordsNV");
	glad_glGetPathDashArrayNV = (PFNGLGETPATHDASHARRAYNVPROC)load("glGetPathDashArrayNV");
	glad_glGetPathMetricsNV = (PFNGLGETPATHMETRICSNVPROC)load("glGetPathMetricsNV");
	glad_glGetPathMetricRangeNV = (PFNGLGETPATHMETRICRANGENVPROC)load("glGetPathMetricRangeNV");
	glad_glGetPathSpacingNV = (PFNGLGETPATHSPACINGNVPROC)load("glGetPathSpacingNV");
	glad_glIsPointInFillPathNV = (PFNGLISPOINTINFILLPATHNVPROC)load("glIsPointInFillPathNV");
	glad_glIsPointInStrokePathNV = (PFNGLISPOINTINSTROKEPATHNVPROC)load("glIsPointInStrokePathNV");
	glad_glGetPathLengthNV = (PFNGLGETPATHLENGTHNVPROC)load("glGetPathLengthNV");
	glad_glPointAlongPathNV = (PFNGLPOINTALONGPATHNVPROC)load("glPointAlongPathNV");
	glad_glMatrixLoad3x2fNV = (PFNGLMATRIXLOAD3X2FNVPROC)load("glMatrixLoad3x2fNV");
	glad_glMatrixLoad3x3fNV = (PFNGLMATRIXLOAD3X3FNVPROC)load("glMatrixLoad3x3fNV");
	glad_glMatrixLoadTranspose3x3fNV = (PFNGLMATRIXLOADTRANSPOSE3X3FNVPROC)load("glMatrixLoadTranspose3x3fNV");
	glad_glMatrixMult3x2fNV = (PFNGLMATRIXMULT3X2FNVPROC)load("glMatrixMult3x2fNV");
	glad_glMatrixMult3x3fNV = (PFNGLMATRIXMULT3X3FNVPROC)load("glMatrixMult3x3fNV");
	glad_glMatrixMultTranspose3x3fNV = (PFNGLMATRIXMULTTRANSPOSE3X3FNVPROC)load("glMatrixMultTranspose3x3fNV");
	glad_glStencilThenCoverFillPathNV = (PFNGLSTENCILTHENCOVERFILLPATHNVPROC)load("glStencilThenCoverFillPathNV");
	glad_glStencilThenCoverStrokePathNV = (PFNGLSTENCILTHENCOVERSTROKEPATHNVPROC)load("glStencilThenCoverStrokePathNV");
	glad_glStencilThenCoverFillPathInstancedNV = (PFNGLSTENCILTHENCOVERFILLPATHINSTANCEDNVPROC)load("glStencilThenCoverFillPathInstancedNV");
	glad_glStencilThenCoverStrokePathInstancedNV = (PFNGLSTENCILTHENCOVERSTROKEPATHINSTANCEDNVPROC)load("glStencilThenCoverStrokePathInstancedNV");
	glad_glPathGlyphIndexRangeNV = (PFNGLPATHGLYPHINDEXRANGENVPROC)load("glPathGlyphIndexRangeNV");
	glad_glPathGlyphIndexArrayNV = (PFNGLPATHGLYPHINDEXARRAYNVPROC)load("glPathGlyphIndexArrayNV");
	glad_glPathMemoryGlyphIndexArrayNV = (PFNGLPATHMEMORYGLYPHINDEXARRAYNVPROC)load("glPathMemoryGlyphIndexArrayNV");
	glad_glProgramPathFragmentInputGenNV = (PFNGLPROGRAMPATHFRAGMENTINPUTGENNVPROC)load("glProgramPathFragmentInputGenNV");
	glad_glGetProgramResourcefvNV = (PFNGLGETPROGRAMRESOURCEFVNVPROC)load("glGetProgramResourcefvNV");
	glad_glPathColorGenNV = (PFNGLPATHCOLORGENNVPROC)load("glPathColorGenNV");
	glad_glPathTexGenNV = (PFNGLPATHTEXGENNVPROC)load("glPathTexGenNV");
	glad_glPathFogGenNV = (PFNGLPATHFOGGENNVPROC)load("glPathFogGenNV");
	glad_glGetPathColorGenivNV = (PFNGLGETPATHCOLORGENIVNVPROC)load("glGetPathColorGenivNV");
	glad_glGetPathColorGenfvNV = (PFNGLGETPATHCOLORGENFVNVPROC)load("glGetPathColorGenfvNV");
	glad_glGetPathTexGenivNV = (PFNGLGETPATHTEXGENIVNVPROC)load("glGetPathTexGenivNV");
	glad_glGetPathTexGenfvNV = (PFNGLGETPATHTEXGENFVNVPROC)load("glGetPathTexGenfvNV");
}
static void load_GL_NV_pixel_data_range(GLADloadproc load) {
	if(!GLAD_GL_NV_pixel_data_range) return;
	glad_glPixelDataRangeNV = (PFNGLPIXELDATARANGENVPROC)load("glPixelDataRangeNV");
	glad_glFlushPixelDataRangeNV = (PFNGLFLUSHPIXELDATARANGENVPROC)load("glFlushPixelDataRangeNV");
}
static void load_GL_NV_point_sprite(GLADloadproc load) {
	if(!GLAD_GL_NV_point_sprite) return;
	glad_glPointParameteriNV = (PFNGLPOINTPARAMETERINVPROC)load("glPointParameteriNV");
	glad_glPointParameterivNV = (PFNGLPOINTPARAMETERIVNVPROC)load("glPointParameterivNV");
}
static void load_GL_NV_present_video(GLADloadproc load) {
	if(!GLAD_GL_NV_present_video) return;
	glad_glPresentFrameKeyedNV = (PFNGLPRESENTFRAMEKEYEDNVPROC)load("glPresentFrameKeyedNV");
	glad_glPresentFrameDualFillNV = (PFNGLPRESENTFRAMEDUALFILLNVPROC)load("glPresentFrameDualFillNV");
	glad_glGetVideoivNV = (PFNGLGETVIDEOIVNVPROC)load("glGetVideoivNV");
	glad_glGetVideouivNV = (PFNGLGETVIDEOUIVNVPROC)load("glGetVideouivNV");
	glad_glGetVideoi64vNV = (PFNGLGETVIDEOI64VNVPROC)load("glGetVideoi64vNV");
	glad_glGetVideoui64vNV = (PFNGLGETVIDEOUI64VNVPROC)load("glGetVideoui64vNV");
}
static void load_GL_NV_primitive_restart(GLADloadproc load) {
	if(!GLAD_GL_NV_primitive_restart) return;
	glad_glPrimitiveRestartNV = (PFNGLPRIMITIVERESTARTNVPROC)load("glPrimitiveRestartNV");
	glad_glPrimitiveRestartIndexNV = (PFNGLPRIMITIVERESTARTINDEXNVPROC)load("glPrimitiveRestartIndexNV");
}
static void load_GL_NV_register_combiners(GLADloadproc load) {
	if(!GLAD_GL_NV_register_combiners) return;
	glad_glCombinerParameterfvNV = (PFNGLCOMBINERPARAMETERFVNVPROC)load("glCombinerParameterfvNV");
	glad_glCombinerParameterfNV = (PFNGLCOMBINERPARAMETERFNVPROC)load("glCombinerParameterfNV");
	glad_glCombinerParameterivNV = (PFNGLCOMBINERPARAMETERIVNVPROC)load("glCombinerParameterivNV");
	glad_glCombinerParameteriNV = (PFNGLCOMBINERPARAMETERINVPROC)load("glCombinerParameteriNV");
	glad_glCombinerInputNV = (PFNGLCOMBINERINPUTNVPROC)load("glCombinerInputNV");
	glad_glCombinerOutputNV = (PFNGLCOMBINEROUTPUTNVPROC)load("glCombinerOutputNV");
	glad_glFinalCombinerInputNV = (PFNGLFINALCOMBINERINPUTNVPROC)load("glFinalCombinerInputNV");
	glad_glGetCombinerInputParameterfvNV = (PFNGLGETCOMBINERINPUTPARAMETERFVNVPROC)load("glGetCombinerInputParameterfvNV");
	glad_glGetCombinerInputParameterivNV = (PFNGLGETCOMBINERINPUTPARAMETERIVNVPROC)load("glGetCombinerInputParameterivNV");
	glad_glGetCombinerOutputParameterfvNV = (PFNGLGETCOMBINEROUTPUTPARAMETERFVNVPROC)load("glGetCombinerOutputParameterfvNV");
	glad_glGetCombinerOutputParameterivNV = (PFNGLGETCOMBINEROUTPUTPARAMETERIVNVPROC)load("glGetCombinerOutputParameterivNV");
	glad_glGetFinalCombinerInputParameterfvNV = (PFNGLGETFINALCOMBINERINPUTPARAMETERFVNVPROC)load("glGetFinalCombinerInputParameterfvNV");
	glad_glGetFinalCombinerInputParameterivNV = (PFNGLGETFINALCOMBINERINPUTPARAMETERIVNVPROC)load("glGetFinalCombinerInputParameterivNV");
}
static void load_GL_NV_register_combiners2(GLADloadproc load) {
	if(!GLAD_GL_NV_register_combiners2) return;
	glad_glCombinerStageParameterfvNV = (PFNGLCOMBINERSTAGEPARAMETERFVNVPROC)load("glCombinerStageParameterfvNV");
	glad_glGetCombinerStageParameterfvNV = (PFNGLGETCOMBINERSTAGEPARAMETERFVNVPROC)load("glGetCombinerStageParameterfvNV");
}
static void load_GL_NV_sample_locations(GLADloadproc load) {
	if(!GLAD_GL_NV_sample_locations) return;
	glad_glFramebufferSampleLocationsfvNV = (PFNGLFRAMEBUFFERSAMPLELOCATIONSFVNVPROC)load("glFramebufferSampleLocationsfvNV");
	glad_glNamedFramebufferSampleLocationsfvNV = (PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVNVPROC)load("glNamedFramebufferSampleLocationsfvNV");
	glad_glResolveDepthValuesNV = (PFNGLRESOLVEDEPTHVALUESNVPROC)load("glResolveDepthValuesNV");
}
static void load_GL_NV_shader_buffer_load(GLADloadproc load) {
	if(!GLAD_GL_NV_shader_buffer_load) return;
	glad_glMakeBufferResidentNV = (PFNGLMAKEBUFFERRESIDENTNVPROC)load("glMakeBufferResidentNV");
	glad_glMakeBufferNonResidentNV = (PFNGLMAKEBUFFERNONRESIDENTNVPROC)load("glMakeBufferNonResidentNV");
	glad_glIsBufferResidentNV = (PFNGLISBUFFERRESIDENTNVPROC)load("glIsBufferResidentNV");
	glad_glMakeNamedBufferResidentNV = (PFNGLMAKENAMEDBUFFERRESIDENTNVPROC)load("glMakeNamedBufferResidentNV");
	glad_glMakeNamedBufferNonResidentNV = (PFNGLMAKENAMEDBUFFERNONRESIDENTNVPROC)load("glMakeNamedBufferNonResidentNV");
	glad_glIsNamedBufferResidentNV = (PFNGLISNAMEDBUFFERRESIDENTNVPROC)load("glIsNamedBufferResidentNV");
	glad_glGetBufferParameterui64vNV = (PFNGLGETBUFFERPARAMETERUI64VNVPROC)load("glGetBufferParameterui64vNV");
	glad_glGetNamedBufferParameterui64vNV = (PFNGLGETNAMEDBUFFERPARAMETERUI64VNVPROC)load("glGetNamedBufferParameterui64vNV");
	glad_glGetIntegerui64vNV = (PFNGLGETINTEGERUI64VNVPROC)load("glGetIntegerui64vNV");
	glad_glUniformui64NV = (PFNGLUNIFORMUI64NVPROC)load("glUniformui64NV");
	glad_glUniformui64vNV = (PFNGLUNIFORMUI64VNVPROC)load("glUniformui64vNV");
	glad_glGetUniformui64vNV = (PFNGLGETUNIFORMUI64VNVPROC)load("glGetUniformui64vNV");
	glad_glProgramUniformui64NV = (PFNGLPROGRAMUNIFORMUI64NVPROC)load("glProgramUniformui64NV");
	glad_glProgramUniformui64vNV = (PFNGLPROGRAMUNIFORMUI64VNVPROC)load("glProgramUniformui64vNV");
}
static void load_GL_NV_texture_barrier(GLADloadproc load) {
	if(!GLAD_GL_NV_texture_barrier) return;
	glad_glTextureBarrierNV = (PFNGLTEXTUREBARRIERNVPROC)load("glTextureBarrierNV");
}
static void load_GL_NV_texture_multisample(GLADloadproc load) {
	if(!GLAD_GL_NV_texture_multisample) return;
	glad_glTexImage2DMultisampleCoverageNV = (PFNGLTEXIMAGE2DMULTISAMPLECOVERAGENVPROC)load("glTexImage2DMultisampleCoverageNV");
	glad_glTexImage3DMultisampleCoverageNV = (PFNGLTEXIMAGE3DMULTISAMPLECOVERAGENVPROC)load("glTexImage3DMultisampleCoverageNV");
	glad_glTextureImage2DMultisampleNV = (PFNGLTEXTUREIMAGE2DMULTISAMPLENVPROC)load("glTextureImage2DMultisampleNV");
	glad_glTextureImage3DMultisampleNV = (PFNGLTEXTUREIMAGE3DMULTISAMPLENVPROC)load("glTextureImage3DMultisampleNV");
	glad_glTextureImage2DMultisampleCoverageNV = (PFNGLTEXTUREIMAGE2DMULTISAMPLECOVERAGENVPROC)load("glTextureImage2DMultisampleCoverageNV");
	glad_glTextureImage3DMultisampleCoverageNV = (PFNGLTEXTUREIMAGE3DMULTISAMPLECOVERAGENVPROC)load("glTextureImage3DMultisampleCoverageNV");
}
static void load_GL_NV_transform_feedback(GLADloadproc load) {
	if(!GLAD_GL_NV_transform_feedback) return;
	glad_glBeginTransformFeedbackNV = (PFNGLBEGINTRANSFORMFEEDBACKNVPROC)load("glBeginTransformFeedbackNV");
	glad_glEndTransformFeedbackNV = (PFNGLENDTRANSFORMFEEDBACKNVPROC)load("glEndTransformFeedbackNV");
	glad_glTransformFeedbackAttribsNV = (PFNGLTRANSFORMFEEDBACKATTRIBSNVPROC)load("glTransformFeedbackAttribsNV");
	glad_glBindBufferRangeNV = (PFNGLBINDBUFFERRANGENVPROC)load("glBindBufferRangeNV");
	glad_glBindBufferOffsetNV = (PFNGLBINDBUFFEROFFSETNVPROC)load("glBindBufferOffsetNV");
	glad_glBindBufferBaseNV = (PFNGLBINDBUFFERBASENVPROC)load("glBindBufferBaseNV");
	glad_glTransformFeedbackVaryingsNV = (PFNGLTRANSFORMFEEDBACKVARYINGSNVPROC)load("glTransformFeedbackVaryingsNV");
	glad_glActiveVaryingNV = (PFNGLACTIVEVARYINGNVPROC)load("glActiveVaryingNV");
	glad_glGetVaryingLocationNV = (PFNGLGETVARYINGLOCATIONNVPROC)load("glGetVaryingLocationNV");
	glad_glGetActiveVaryingNV = (PFNGLGETACTIVEVARYINGNVPROC)load("glGetActiveVaryingNV");
	glad_glGetTransformFeedbackVaryingNV = (PFNGLGETTRANSFORMFEEDBACKVARYINGNVPROC)load("glGetTransformFeedbackVaryingNV");
	glad_glTransformFeedbackStreamAttribsNV = (PFNGLTRANSFORMFEEDBACKSTREAMATTRIBSNVPROC)load("glTransformFeedbackStreamAttribsNV");
}
static void load_GL_NV_transform_feedback2(GLADloadproc load) {
	if(!GLAD_GL_NV_transform_feedback2) return;
	glad_glBindTransformFeedbackNV = (PFNGLBINDTRANSFORMFEEDBACKNVPROC)load("glBindTransformFeedbackNV");
	glad_glDeleteTransformFeedbacksNV = (PFNGLDELETETRANSFORMFEEDBACKSNVPROC)load("glDeleteTransformFeedbacksNV");
	glad_glGenTransformFeedbacksNV = (PFNGLGENTRANSFORMFEEDBACKSNVPROC)load("glGenTransformFeedbacksNV");
	glad_glIsTransformFeedbackNV = (PFNGLISTRANSFORMFEEDBACKNVPROC)load("glIsTransformFeedbackNV");
	glad_glPauseTransformFeedbackNV = (PFNGLPAUSETRANSFORMFEEDBACKNVPROC)load("glPauseTransformFeedbackNV");
	glad_glResumeTransformFeedbackNV = (PFNGLRESUMETRANSFORMFEEDBACKNVPROC)load("glResumeTransformFeedbackNV");
	glad_glDrawTransformFeedbackNV = (PFNGLDRAWTRANSFORMFEEDBACKNVPROC)load("glDrawTransformFeedbackNV");
}
static void load_GL_NV_vdpau_interop(GLADloadproc load) {
	if(!GLAD_GL_NV_vdpau_interop) return;
	glad_glVDPAUInitNV = (PFNGLVDPAUINITNVPROC)load("glVDPAUInitNV");
	glad_glVDPAUFiniNV = (PFNGLVDPAUFININVPROC)load("glVDPAUFiniNV");
	glad_glVDPAURegisterVideoSurfaceNV = (PFNGLVDPAUREGISTERVIDEOSURFACENVPROC)load("glVDPAURegisterVideoSurfaceNV");
	glad_glVDPAURegisterOutputSurfaceNV = (PFNGLVDPAUREGISTEROUTPUTSURFACENVPROC)load("glVDPAURegisterOutputSurfaceNV");
	glad_glVDPAUIsSurfaceNV = (PFNGLVDPAUISSURFACENVPROC)load("glVDPAUIsSurfaceNV");
	glad_glVDPAUUnregisterSurfaceNV = (PFNGLVDPAUUNREGISTERSURFACENVPROC)load("glVDPAUUnregisterSurfaceNV");
	glad_glVDPAUGetSurfaceivNV = (PFNGLVDPAUGETSURFACEIVNVPROC)load("glVDPAUGetSurfaceivNV");
	glad_glVDPAUSurfaceAccessNV = (PFNGLVDPAUSURFACEACCESSNVPROC)load("glVDPAUSurfaceAccessNV");
	glad_glVDPAUMapSurfacesNV = (PFNGLVDPAUMAPSURFACESNVPROC)load("glVDPAUMapSurfacesNV");
	glad_glVDPAUUnmapSurfacesNV = (PFNGLVDPAUUNMAPSURFACESNVPROC)load("glVDPAUUnmapSurfacesNV");
}
static void load_GL_NV_vertex_array_range(GLADloadproc load) {
	if(!GLAD_GL_NV_vertex_array_range) return;
	glad_glFlushVertexArrayRangeNV = (PFNGLFLUSHVERTEXARRAYRANGENVPROC)load("glFlushVertexArrayRangeNV");
	glad_glVertexArrayRangeNV = (PFNGLVERTEXARRAYRANGENVPROC)load("glVertexArrayRangeNV");
}
static void load_GL_NV_vertex_attrib_integer_64bit(GLADloadproc load) {
	if(!GLAD_GL_NV_vertex_attrib_integer_64bit) return;
	glad_glVertexAttribL1i64NV = (PFNGLVERTEXATTRIBL1I64NVPROC)load("glVertexAttribL1i64NV");
	glad_glVertexAttribL2i64NV = (PFNGLVERTEXATTRIBL2I64NVPROC)load("glVertexAttribL2i64NV");
	glad_glVertexAttribL3i64NV = (PFNGLVERTEXATTRIBL3I64NVPROC)load("glVertexAttribL3i64NV");
	glad_glVertexAttribL4i64NV = (PFNGLVERTEXATTRIBL4I64NVPROC)load("glVertexAttribL4i64NV");
	glad_glVertexAttribL1i64vNV = (PFNGLVERTEXATTRIBL1I64VNVPROC)load("glVertexAttribL1i64vNV");
	glad_glVertexAttribL2i64vNV = (PFNGLVERTEXATTRIBL2I64VNVPROC)load("glVertexAttribL2i64vNV");
	glad_glVertexAttribL3i64vNV = (PFNGLVERTEXATTRIBL3I64VNVPROC)load("glVertexAttribL3i64vNV");
	glad_glVertexAttribL4i64vNV = (PFNGLVERTEXATTRIBL4I64VNVPROC)load("glVertexAttribL4i64vNV");
	glad_glVertexAttribL1ui64NV = (PFNGLVERTEXATTRIBL1UI64NVPROC)load("glVertexAttribL1ui64NV");
	glad_glVertexAttribL2ui64NV = (PFNGLVERTEXATTRIBL2UI64NVPROC)load("glVertexAttribL2ui64NV");
	glad_glVertexAttribL3ui64NV = (PFNGLVERTEXATTRIBL3UI64NVPROC)load("glVertexAttribL3ui64NV");
	glad_glVertexAttribL4ui64NV = (PFNGLVERTEXATTRIBL4UI64NVPROC)load("glVertexAttribL4ui64NV");
	glad_glVertexAttribL1ui64vNV = (PFNGLVERTEXATTRIBL1UI64VNVPROC)load("glVertexAttribL1ui64vNV");
	glad_glVertexAttribL2ui64vNV = (PFNGLVERTEXATTRIBL2UI64VNVPROC)load("glVertexAttribL2ui64vNV");
	glad_glVertexAttribL3ui64vNV = (PFNGLVERTEXATTRIBL3UI64VNVPROC)load("glVertexAttribL3ui64vNV");
	glad_glVertexAttribL4ui64vNV = (PFNGLVERTEXATTRIBL4UI64VNVPROC)load("glVertexAttribL4ui64vNV");
	glad_glGetVertexAttribLi64vNV = (PFNGLGETVERTEXATTRIBLI64VNVPROC)load("glGetVertexAttribLi64vNV");
	glad_glGetVertexAttribLui64vNV = (PFNGLGETVERTEXATTRIBLUI64VNVPROC)load("glGetVertexAttribLui64vNV");
	glad_glVertexAttribLFormatNV = (PFNGLVERTEXATTRIBLFORMATNVPROC)load("glVertexAttribLFormatNV");
}
static void load_GL_NV_vertex_buffer_unified_memory(GLADloadproc load) {
	if(!GLAD_GL_NV_vertex_buffer_unified_memory) return;
	glad_glBufferAddressRangeNV = (PFNGLBUFFERADDRESSRANGENVPROC)load("glBufferAddressRangeNV");
	glad_glVertexFormatNV = (PFNGLVERTEXFORMATNVPROC)load("glVertexFormatNV");
	glad_glNormalFormatNV = (PFNGLNORMALFORMATNVPROC)load("glNormalFormatNV");
	glad_glColorFormatNV = (PFNGLCOLORFORMATNVPROC)load("glColorFormatNV");
	glad_glIndexFormatNV = (PFNGLINDEXFORMATNVPROC)load("glIndexFormatNV");
	glad_glTexCoordFormatNV = (PFNGLTEXCOORDFORMATNVPROC)load("glTexCoordFormatNV");
	glad_glEdgeFlagFormatNV = (PFNGLEDGEFLAGFORMATNVPROC)load("glEdgeFlagFormatNV");
	glad_glSecondaryColorFormatNV = (PFNGLSECONDARYCOLORFORMATNVPROC)load("glSecondaryColorFormatNV");
	glad_glFogCoordFormatNV = (PFNGLFOGCOORDFORMATNVPROC)load("glFogCoordFormatNV");
	glad_glVertexAttribFormatNV = (PFNGLVERTEXATTRIBFORMATNVPROC)load("glVertexAttribFormatNV");
	glad_glVertexAttribIFormatNV = (PFNGLVERTEXATTRIBIFORMATNVPROC)load("glVertexAttribIFormatNV");
	glad_glGetIntegerui64i_vNV = (PFNGLGETINTEGERUI64I_VNVPROC)load("glGetIntegerui64i_vNV");
}
static void load_GL_NV_vertex_program(GLADloadproc load) {
	if(!GLAD_GL_NV_vertex_program) return;
	glad_glAreProgramsResidentNV = (PFNGLAREPROGRAMSRESIDENTNVPROC)load("glAreProgramsResidentNV");
	glad_glBindProgramNV = (PFNGLBINDPROGRAMNVPROC)load("glBindProgramNV");
	glad_glDeleteProgramsNV = (PFNGLDELETEPROGRAMSNVPROC)load("glDeleteProgramsNV");
	glad_glExecuteProgramNV = (PFNGLEXECUTEPROGRAMNVPROC)load("glExecuteProgramNV");
	glad_glGenProgramsNV = (PFNGLGENPROGRAMSNVPROC)load("glGenProgramsNV");
	glad_glGetProgramParameterdvNV = (PFNGLGETPROGRAMPARAMETERDVNVPROC)load("glGetProgramParameterdvNV");
	glad_glGetProgramParameterfvNV = (PFNGLGETPROGRAMPARAMETERFVNVPROC)load("glGetProgramParameterfvNV");
	glad_glGetProgramivNV = (PFNGLGETPROGRAMIVNVPROC)load("glGetProgramivNV");
	glad_glGetProgramStringNV = (PFNGLGETPROGRAMSTRINGNVPROC)load("glGetProgramStringNV");
	glad_glGetTrackMatrixivNV = (PFNGLGETTRACKMATRIXIVNVPROC)load("glGetTrackMatrixivNV");
	glad_glGetVertexAttribdvNV = (PFNGLGETVERTEXATTRIBDVNVPROC)load("glGetVertexAttribdvNV");
	glad_glGetVertexAttribfvNV = (PFNGLGETVERTEXATTRIBFVNVPROC)load("glGetVertexAttribfvNV");
	glad_glGetVertexAttribivNV = (PFNGLGETVERTEXATTRIBIVNVPROC)load("glGetVertexAttribivNV");
	glad_glGetVertexAttribPointervNV = (PFNGLGETVERTEXATTRIBPOINTERVNVPROC)load("glGetVertexAttribPointervNV");
	glad_glIsProgramNV = (PFNGLISPROGRAMNVPROC)load("glIsProgramNV");
	glad_glLoadProgramNV = (PFNGLLOADPROGRAMNVPROC)load("glLoadProgramNV");
	glad_glProgramParameter4dNV = (PFNGLPROGRAMPARAMETER4DNVPROC)load("glProgramParameter4dNV");
	glad_glProgramParameter4dvNV = (PFNGLPROGRAMPARAMETER4DVNVPROC)load("glProgramParameter4dvNV");
	glad_glProgramParameter4fNV = (PFNGLPROGRAMPARAMETER4FNVPROC)load("glProgramParameter4fNV");
	glad_glProgramParameter4fvNV = (PFNGLPROGRAMPARAMETER4FVNVPROC)load("glProgramParameter4fvNV");
	glad_glProgramParameters4dvNV = (PFNGLPROGRAMPARAMETERS4DVNVPROC)load("glProgramParameters4dvNV");
	glad_glProgramParameters4fvNV = (PFNGLPROGRAMPARAMETERS4FVNVPROC)load("glProgramParameters4fvNV");
	glad_glRequestResidentProgramsNV = (PFNGLREQUESTRESIDENTPROGRAMSNVPROC)load("glRequestResidentProgramsNV");
	glad_glTrackMatrixNV = (PFNGLTRACKMATRIXNVPROC)load("glTrackMatrixNV");
	glad_glVertexAttribPointerNV = (PFNGLVERTEXATTRIBPOINTERNVPROC)load("glVertexAttribPointerNV");
	glad_glVertexAttrib1dNV = (PFNGLVERTEXATTRIB1DNVPROC)load("glVertexAttrib1dNV");
	glad_glVertexAttrib1dvNV = (PFNGLVERTEXATTRIB1DVNVPROC)load("glVertexAttrib1dvNV");
	glad_glVertexAttrib1fNV = (PFNGLVERTEXATTRIB1FNVPROC)load("glVertexAttrib1fNV");
	glad_glVertexAttrib1fvNV = (PFNGLVERTEXATTRIB1FVNVPROC)load("glVertexAttrib1fvNV");
	glad_glVertexAttrib1sNV = (PFNGLVERTEXATTRIB1SNVPROC)load("glVertexAttrib1sNV");
	glad_glVertexAttrib1svNV = (PFNGLVERTEXATTRIB1SVNVPROC)load("glVertexAttrib1svNV");
	glad_glVertexAttrib2dNV = (PFNGLVERTEXATTRIB2DNVPROC)load("glVertexAttrib2dNV");
	glad_glVertexAttrib2dvNV = (PFNGLVERTEXATTRIB2DVNVPROC)load("glVertexAttrib2dvNV");
	glad_glVertexAttrib2fNV = (PFNGLVERTEXATTRIB2FNVPROC)load("glVertexAttrib2fNV");
	glad_glVertexAttrib2fvNV = (PFNGLVERTEXATTRIB2FVNVPROC)load("glVertexAttrib2fvNV");
	glad_glVertexAttrib2sNV = (PFNGLVERTEXATTRIB2SNVPROC)load("glVertexAttrib2sNV");
	glad_glVertexAttrib2svNV = (PFNGLVERTEXATTRIB2SVNVPROC)load("glVertexAttrib2svNV");
	glad_glVertexAttrib3dNV = (PFNGLVERTEXATTRIB3DNVPROC)load("glVertexAttrib3dNV");
	glad_glVertexAttrib3dvNV = (PFNGLVERTEXATTRIB3DVNVPROC)load("glVertexAttrib3dvNV");
	glad_glVertexAttrib3fNV = (PFNGLVERTEXATTRIB3FNVPROC)load("glVertexAttrib3fNV");
	glad_glVertexAttrib3fvNV = (PFNGLVERTEXATTRIB3FVNVPROC)load("glVertexAttrib3fvNV");
	glad_glVertexAttrib3sNV = (PFNGLVERTEXATTRIB3SNVPROC)load("glVertexAttrib3sNV");
	glad_glVertexAttrib3svNV = (PFNGLVERTEXATTRIB3SVNVPROC)load("glVertexAttrib3svNV");
	glad_glVertexAttrib4dNV = (PFNGLVERTEXATTRIB4DNVPROC)load("glVertexAttrib4dNV");
	glad_glVertexAttrib4dvNV = (PFNGLVERTEXATTRIB4DVNVPROC)load("glVertexAttrib4dvNV");
	glad_glVertexAttrib4fNV = (PFNGLVERTEXATTRIB4FNVPROC)load("glVertexAttrib4fNV");
	glad_glVertexAttrib4fvNV = (PFNGLVERTEXATTRIB4FVNVPROC)load("glVertexAttrib4fvNV");
	glad_glVertexAttrib4sNV = (PFNGLVERTEXATTRIB4SNVPROC)load("glVertexAttrib4sNV");
	glad_glVertexAttrib4svNV = (PFNGLVERTEXATTRIB4SVNVPROC)load("glVertexAttrib4svNV");
	glad_glVertexAttrib4ubNV = (PFNGLVERTEXATTRIB4UBNVPROC)load("glVertexAttrib4ubNV");
	glad_glVertexAttrib4ubvNV = (PFNGLVERTEXATTRIB4UBVNVPROC)load("glVertexAttrib4ubvNV");
	glad_glVertexAttribs1dvNV = (PFNGLVERTEXATTRIBS1DVNVPROC)load("glVertexAttribs1dvNV");
	glad_glVertexAttribs1fvNV = (PFNGLVERTEXATTRIBS1FVNVPROC)load("glVertexAttribs1fvNV");
	glad_glVertexAttribs1svNV = (PFNGLVERTEXATTRIBS1SVNVPROC)load("glVertexAttribs1svNV");
	glad_glVertexAttribs2dvNV = (PFNGLVERTEXATTRIBS2DVNVPROC)load("glVertexAttribs2dvNV");
	glad_glVertexAttribs2fvNV = (PFNGLVERTEXATTRIBS2FVNVPROC)load("glVertexAttribs2fvNV");
	glad_glVertexAttribs2svNV = (PFNGLVERTEXATTRIBS2SVNVPROC)load("glVertexAttribs2svNV");
	glad_glVertexAttribs3dvNV = (PFNGLVERTEXATTRIBS3DVNVPROC)load("glVertexAttribs3dvNV");
	glad_glVertexAttribs3fvNV = (PFNGLVERTEXATTRIBS3FVNVPROC)load("glVertexAttribs3fvNV");
	glad_glVertexAttribs3svNV = (PFNGLVERTEXATTRIBS3SVNVPROC)load("glVertexAttribs3svNV");
	glad_glVertexAttribs4dvNV = (PFNGLVERTEXATTRIBS4DVNVPROC)load("glVertexAttribs4dvNV");
	glad_glVertexAttribs4fvNV = (PFNGLVERTEXATTRIBS4FVNVPROC)load("glVertexAttribs4fvNV");
	glad_glVertexAttribs4svNV = (PFNGLVERTEXATTRIBS4SVNVPROC)load("glVertexAttribs4svNV");
	glad_glVertexAttribs4ubvNV = (PFNGLVERTEXATTRIBS4UBVNVPROC)load("glVertexAttribs4ubvNV");
}
static void load_GL_NV_vertex_program4(GLADloadproc load) {
	if(!GLAD_GL_NV_vertex_program4) return;
	glad_glVertexAttribI1iEXT = (PFNGLVERTEXATTRIBI1IEXTPROC)load("glVertexAttribI1iEXT");
	glad_glVertexAttribI2iEXT = (PFNGLVERTEXATTRIBI2IEXTPROC)load("glVertexAttribI2iEXT");
	glad_glVertexAttribI3iEXT = (PFNGLVERTEXATTRIBI3IEXTPROC)load("glVertexAttribI3iEXT");
	glad_glVertexAttribI4iEXT = (PFNGLVERTEXATTRIBI4IEXTPROC)load("glVertexAttribI4iEXT");
	glad_glVertexAttribI1uiEXT = (PFNGLVERTEXATTRIBI1UIEXTPROC)load("glVertexAttribI1uiEXT");
	glad_glVertexAttribI2uiEXT = (PFNGLVERTEXATTRIBI2UIEXTPROC)load("glVertexAttribI2uiEXT");
	glad_glVertexAttribI3uiEXT = (PFNGLVERTEXATTRIBI3UIEXTPROC)load("glVertexAttribI3uiEXT");
	glad_glVertexAttribI4uiEXT = (PFNGLVERTEXATTRIBI4UIEXTPROC)load("glVertexAttribI4uiEXT");
	glad_glVertexAttribI1ivEXT = (PFNGLVERTEXATTRIBI1IVEXTPROC)load("glVertexAttribI1ivEXT");
	glad_glVertexAttribI2ivEXT = (PFNGLVERTEXATTRIBI2IVEXTPROC)load("glVertexAttribI2ivEXT");
	glad_glVertexAttribI3ivEXT = (PFNGLVERTEXATTRIBI3IVEXTPROC)load("glVertexAttribI3ivEXT");
	glad_glVertexAttribI4ivEXT = (PFNGLVERTEXATTRIBI4IVEXTPROC)load("glVertexAttribI4ivEXT");
	glad_glVertexAttribI1uivEXT = (PFNGLVERTEXATTRIBI1UIVEXTPROC)load("glVertexAttribI1uivEXT");
	glad_glVertexAttribI2uivEXT = (PFNGLVERTEXATTRIBI2UIVEXTPROC)load("glVertexAttribI2uivEXT");
	glad_glVertexAttribI3uivEXT = (PFNGLVERTEXATTRIBI3UIVEXTPROC)load("glVertexAttribI3uivEXT");
	glad_glVertexAttribI4uivEXT = (PFNGLVERTEXATTRIBI4UIVEXTPROC)load("glVertexAttribI4uivEXT");
	glad_glVertexAttribI4bvEXT = (PFNGLVERTEXATTRIBI4BVEXTPROC)load("glVertexAttribI4bvEXT");
	glad_glVertexAttribI4svEXT = (PFNGLVERTEXATTRIBI4SVEXTPROC)load("glVertexAttribI4svEXT");
	glad_glVertexAttribI4ubvEXT = (PFNGLVERTEXATTRIBI4UBVEXTPROC)load("glVertexAttribI4ubvEXT");
	glad_glVertexAttribI4usvEXT = (PFNGLVERTEXATTRIBI4USVEXTPROC)load("glVertexAttribI4usvEXT");
	glad_glVertexAttribIPointerEXT = (PFNGLVERTEXATTRIBIPOINTEREXTPROC)load("glVertexAttribIPointerEXT");
	glad_glGetVertexAttribIivEXT = (PFNGLGETVERTEXATTRIBIIVEXTPROC)load("glGetVertexAttribIivEXT");
	glad_glGetVertexAttribIuivEXT = (PFNGLGETVERTEXATTRIBIUIVEXTPROC)load("glGetVertexAttribIuivEXT");
}
static void load_GL_NV_video_capture(GLADloadproc load) {
	if(!GLAD_GL_NV_video_capture) return;
	glad_glBeginVideoCaptureNV = (PFNGLBEGINVIDEOCAPTURENVPROC)load("glBeginVideoCaptureNV");
	glad_glBindVideoCaptureStreamBufferNV = (PFNGLBINDVIDEOCAPTURESTREAMBUFFERNVPROC)load("glBindVideoCaptureStreamBufferNV");
	glad_glBindVideoCaptureStreamTextureNV = (PFNGLBINDVIDEOCAPTURESTREAMTEXTURENVPROC)load("glBindVideoCaptureStreamTextureNV");
	glad_glEndVideoCaptureNV = (PFNGLENDVIDEOCAPTURENVPROC)load("glEndVideoCaptureNV");
	glad_glGetVideoCaptureivNV = (PFNGLGETVIDEOCAPTUREIVNVPROC)load("glGetVideoCaptureivNV");
	glad_glGetVideoCaptureStreamivNV = (PFNGLGETVIDEOCAPTURESTREAMIVNVPROC)load("glGetVideoCaptureStreamivNV");
	glad_glGetVideoCaptureStreamfvNV = (PFNGLGETVIDEOCAPTURESTREAMFVNVPROC)load("glGetVideoCaptureStreamfvNV");
	glad_glGetVideoCaptureStreamdvNV = (PFNGLGETVIDEOCAPTURESTREAMDVNVPROC)load("glGetVideoCaptureStreamdvNV");
	glad_glVideoCaptureNV = (PFNGLVIDEOCAPTURENVPROC)load("glVideoCaptureNV");
	glad_glVideoCaptureStreamParameterivNV = (PFNGLVIDEOCAPTURESTREAMPARAMETERIVNVPROC)load("glVideoCaptureStreamParameterivNV");
	glad_glVideoCaptureStreamParameterfvNV = (PFNGLVIDEOCAPTURESTREAMPARAMETERFVNVPROC)load("glVideoCaptureStreamParameterfvNV");
	glad_glVideoCaptureStreamParameterdvNV = (PFNGLVIDEOCAPTURESTREAMPARAMETERDVNVPROC)load("glVideoCaptureStreamParameterdvNV");
}
static void load_GL_NV_viewport_swizzle(GLADloadproc load) {
	if(!GLAD_GL_NV_viewport_swizzle) return;
	glad_glViewportSwizzleNV = (PFNGLVIEWPORTSWIZZLENVPROC)load("glViewportSwizzleNV");
}
static void load_GL_OES_byte_coordinates(GLADloadproc load) {
	if(!GLAD_GL_OES_byte_coordinates) return;
	glad_glMultiTexCoord1bOES = (PFNGLMULTITEXCOORD1BOESPROC)load("glMultiTexCoord1bOES");
	glad_glMultiTexCoord1bvOES = (PFNGLMULTITEXCOORD1BVOESPROC)load("glMultiTexCoord1bvOES");
	glad_glMultiTexCoord2bOES = (PFNGLMULTITEXCOORD2BOESPROC)load("glMultiTexCoord2bOES");
	glad_glMultiTexCoord2bvOES = (PFNGLMULTITEXCOORD2BVOESPROC)load("glMultiTexCoord2bvOES");
	glad_glMultiTexCoord3bOES = (PFNGLMULTITEXCOORD3BOESPROC)load("glMultiTexCoord3bOES");
	glad_glMultiTexCoord3bvOES = (PFNGLMULTITEXCOORD3BVOESPROC)load("glMultiTexCoord3bvOES");
	glad_glMultiTexCoord4bOES = (PFNGLMULTITEXCOORD4BOESPROC)load("glMultiTexCoord4bOES");
	glad_glMultiTexCoord4bvOES = (PFNGLMULTITEXCOORD4BVOESPROC)load("glMultiTexCoord4bvOES");
	glad_glTexCoord1bOES = (PFNGLTEXCOORD1BOESPROC)load("glTexCoord1bOES");
	glad_glTexCoord1bvOES = (PFNGLTEXCOORD1BVOESPROC)load("glTexCoord1bvOES");
	glad_glTexCoord2bOES = (PFNGLTEXCOORD2BOESPROC)load("glTexCoord2bOES");
	glad_glTexCoord2bvOES = (PFNGLTEXCOORD2BVOESPROC)load("glTexCoord2bvOES");
	glad_glTexCoord3bOES = (PFNGLTEXCOORD3BOESPROC)load("glTexCoord3bOES");
	glad_glTexCoord3bvOES = (PFNGLTEXCOORD3BVOESPROC)load("glTexCoord3bvOES");
	glad_glTexCoord4bOES = (PFNGLTEXCOORD4BOESPROC)load("glTexCoord4bOES");
	glad_glTexCoord4bvOES = (PFNGLTEXCOORD4BVOESPROC)load("glTexCoord4bvOES");
	glad_glVertex2bOES = (PFNGLVERTEX2BOESPROC)load("glVertex2bOES");
	glad_glVertex2bvOES = (PFNGLVERTEX2BVOESPROC)load("glVertex2bvOES");
	glad_glVertex3bOES = (PFNGLVERTEX3BOESPROC)load("glVertex3bOES");
	glad_glVertex3bvOES = (PFNGLVERTEX3BVOESPROC)load("glVertex3bvOES");
	glad_glVertex4bOES = (PFNGLVERTEX4BOESPROC)load("glVertex4bOES");
	glad_glVertex4bvOES = (PFNGLVERTEX4BVOESPROC)load("glVertex4bvOES");
}
static void load_GL_OES_fixed_point(GLADloadproc load) {
	if(!GLAD_GL_OES_fixed_point) return;
	glad_glAlphaFuncxOES = (PFNGLALPHAFUNCXOESPROC)load("glAlphaFuncxOES");
	glad_glClearColorxOES = (PFNGLCLEARCOLORXOESPROC)load("glClearColorxOES");
	glad_glClearDepthxOES = (PFNGLCLEARDEPTHXOESPROC)load("glClearDepthxOES");
	glad_glClipPlanexOES = (PFNGLCLIPPLANEXOESPROC)load("glClipPlanexOES");
	glad_glColor4xOES = (PFNGLCOLOR4XOESPROC)load("glColor4xOES");
	glad_glDepthRangexOES = (PFNGLDEPTHRANGEXOESPROC)load("glDepthRangexOES");
	glad_glFogxOES = (PFNGLFOGXOESPROC)load("glFogxOES");
	glad_glFogxvOES = (PFNGLFOGXVOESPROC)load("glFogxvOES");
	glad_glFrustumxOES = (PFNGLFRUSTUMXOESPROC)load("glFrustumxOES");
	glad_glGetClipPlanexOES = (PFNGLGETCLIPPLANEXOESPROC)load("glGetClipPlanexOES");
	glad_glGetFixedvOES = (PFNGLGETFIXEDVOESPROC)load("glGetFixedvOES");
	glad_glGetTexEnvxvOES = (PFNGLGETTEXENVXVOESPROC)load("glGetTexEnvxvOES");
	glad_glGetTexParameterxvOES = (PFNGLGETTEXPARAMETERXVOESPROC)load("glGetTexParameterxvOES");
	glad_glLightModelxOES = (PFNGLLIGHTMODELXOESPROC)load("glLightModelxOES");
	glad_glLightModelxvOES = (PFNGLLIGHTMODELXVOESPROC)load("glLightModelxvOES");
	glad_glLightxOES = (PFNGLLIGHTXOESPROC)load("glLightxOES");
	glad_glLightxvOES = (PFNGLLIGHTXVOESPROC)load("glLightxvOES");
	glad_glLineWidthxOES = (PFNGLLINEWIDTHXOESPROC)load("glLineWidthxOES");
	glad_glLoadMatrixxOES = (PFNGLLOADMATRIXXOESPROC)load("glLoadMatrixxOES");
	glad_glMaterialxOES = (PFNGLMATERIALXOESPROC)load("glMaterialxOES");
	glad_glMaterialxvOES = (PFNGLMATERIALXVOESPROC)load("glMaterialxvOES");
	glad_glMultMatrixxOES = (PFNGLMULTMATRIXXOESPROC)load("glMultMatrixxOES");
	glad_glMultiTexCoord4xOES = (PFNGLMULTITEXCOORD4XOESPROC)load("glMultiTexCoord4xOES");
	glad_glNormal3xOES = (PFNGLNORMAL3XOESPROC)load("glNormal3xOES");
	glad_glOrthoxOES = (PFNGLORTHOXOESPROC)load("glOrthoxOES");
	glad_glPointParameterxvOES = (PFNGLPOINTPARAMETERXVOESPROC)load("glPointParameterxvOES");
	glad_glPointSizexOES = (PFNGLPOINTSIZEXOESPROC)load("glPointSizexOES");
	glad_glPolygonOffsetxOES = (PFNGLPOLYGONOFFSETXOESPROC)load("glPolygonOffsetxOES");
	glad_glRotatexOES = (PFNGLROTATEXOESPROC)load("glRotatexOES");
	glad_glScalexOES = (PFNGLSCALEXOESPROC)load("glScalexOES");
	glad_glTexEnvxOES = (PFNGLTEXENVXOESPROC)load("glTexEnvxOES");
	glad_glTexEnvxvOES = (PFNGLTEXENVXVOESPROC)load("glTexEnvxvOES");
	glad_glTexParameterxOES = (PFNGLTEXPARAMETERXOESPROC)load("glTexParameterxOES");
	glad_glTexParameterxvOES = (PFNGLTEXPARAMETERXVOESPROC)load("glTexParameterxvOES");
	glad_glTranslatexOES = (PFNGLTRANSLATEXOESPROC)load("glTranslatexOES");
	glad_glGetLightxvOES = (PFNGLGETLIGHTXVOESPROC)load("glGetLightxvOES");
	glad_glGetMaterialxvOES = (PFNGLGETMATERIALXVOESPROC)load("glGetMaterialxvOES");
	glad_glPointParameterxOES = (PFNGLPOINTPARAMETERXOESPROC)load("glPointParameterxOES");
	glad_glSampleCoveragexOES = (PFNGLSAMPLECOVERAGEXOESPROC)load("glSampleCoveragexOES");
	glad_glAccumxOES = (PFNGLACCUMXOESPROC)load("glAccumxOES");
	glad_glBitmapxOES = (PFNGLBITMAPXOESPROC)load("glBitmapxOES");
	glad_glBlendColorxOES = (PFNGLBLENDCOLORXOESPROC)load("glBlendColorxOES");
	glad_glClearAccumxOES = (PFNGLCLEARACCUMXOESPROC)load("glClearAccumxOES");
	glad_glColor3xOES = (PFNGLCOLOR3XOESPROC)load("glColor3xOES");
	glad_glColor3xvOES = (PFNGLCOLOR3XVOESPROC)load("glColor3xvOES");
	glad_glColor4xvOES = (PFNGLCOLOR4XVOESPROC)load("glColor4xvOES");
	glad_glConvolutionParameterxOES = (PFNGLCONVOLUTIONPARAMETERXOESPROC)load("glConvolutionParameterxOES");
	glad_glConvolutionParameterxvOES = (PFNGLCONVOLUTIONPARAMETERXVOESPROC)load("glConvolutionParameterxvOES");
	glad_glEvalCoord1xOES = (PFNGLEVALCOORD1XOESPROC)load("glEvalCoord1xOES");
	glad_glEvalCoord1xvOES = (PFNGLEVALCOORD1XVOESPROC)load("glEvalCoord1xvOES");
	glad_glEvalCoord2xOES = (PFNGLEVALCOORD2XOESPROC)load("glEvalCoord2xOES");
	glad_glEvalCoord2xvOES = (PFNGLEVALCOORD2XVOESPROC)load("glEvalCoord2xvOES");
	glad_glFeedbackBufferxOES = (PFNGLFEEDBACKBUFFERXOESPROC)load("glFeedbackBufferxOES");
	glad_glGetConvolutionParameterxvOES = (PFNGLGETCONVOLUTIONPARAMETERXVOESPROC)load("glGetConvolutionParameterxvOES");
	glad_glGetHistogramParameterxvOES = (PFNGLGETHISTOGRAMPARAMETERXVOESPROC)load("glGetHistogramParameterxvOES");
	glad_glGetLightxOES = (PFNGLGETLIGHTXOESPROC)load("glGetLightxOES");
	glad_glGetMapxvOES = (PFNGLGETMAPXVOESPROC)load("glGetMapxvOES");
	glad_glGetMaterialxOES = (PFNGLGETMATERIALXOESPROC)load("glGetMaterialxOES");
	glad_glGetPixelMapxv = (PFNGLGETPIXELMAPXVPROC)load("glGetPixelMapxv");
	glad_glGetTexGenxvOES = (PFNGLGETTEXGENXVOESPROC)load("glGetTexGenxvOES");
	glad_glGetTexLevelParameterxvOES = (PFNGLGETTEXLEVELPARAMETERXVOESPROC)load("glGetTexLevelParameterxvOES");
	glad_glIndexxOES = (PFNGLINDEXXOESPROC)load("glIndexxOES");
	glad_glIndexxvOES = (PFNGLINDEXXVOESPROC)load("glIndexxvOES");
	glad_glLoadTransposeMatrixxOES = (PFNGLLOADTRANSPOSEMATRIXXOESPROC)load("glLoadTransposeMatrixxOES");
	glad_glMap1xOES = (PFNGLMAP1XOESPROC)load("glMap1xOES");
	glad_glMap2xOES = (PFNGLMAP2XOESPROC)load("glMap2xOES");
	glad_glMapGrid1xOES = (PFNGLMAPGRID1XOESPROC)load("glMapGrid1xOES");
	glad_glMapGrid2xOES = (PFNGLMAPGRID2XOESPROC)load("glMapGrid2xOES");
	glad_glMultTransposeMatrixxOES = (PFNGLMULTTRANSPOSEMATRIXXOESPROC)load("glMultTransposeMatrixxOES");
	glad_glMultiTexCoord1xOES = (PFNGLMULTITEXCOORD1XOESPROC)load("glMultiTexCoord1xOES");
	glad_glMultiTexCoord1xvOES = (PFNGLMULTITEXCOORD1XVOESPROC)load("glMultiTexCoord1xvOES");
	glad_glMultiTexCoord2xOES = (PFNGLMULTITEXCOORD2XOESPROC)load("glMultiTexCoord2xOES");
	glad_glMultiTexCoord2xvOES = (PFNGLMULTITEXCOORD2XVOESPROC)load("glMultiTexCoord2xvOES");
	glad_glMultiTexCoord3xOES = (PFNGLMULTITEXCOORD3XOESPROC)load("glMultiTexCoord3xOES");
	glad_glMultiTexCoord3xvOES = (PFNGLMULTITEXCOORD3XVOESPROC)load("glMultiTexCoord3xvOES");
	glad_glMultiTexCoord4xvOES = (PFNGLMULTITEXCOORD4XVOESPROC)load("glMultiTexCoord4xvOES");
	glad_glNormal3xvOES = (PFNGLNORMAL3XVOESPROC)load("glNormal3xvOES");
	glad_glPassThroughxOES = (PFNGLPASSTHROUGHXOESPROC)load("glPassThroughxOES");
	glad_glPixelMapx = (PFNGLPIXELMAPXPROC)load("glPixelMapx");
	glad_glPixelStorex = (PFNGLPIXELSTOREXPROC)load("glPixelStorex");
	glad_glPixelTransferxOES = (PFNGLPIXELTRANSFERXOESPROC)load("glPixelTransferxOES");
	glad_glPixelZoomxOES = (PFNGLPIXELZOOMXOESPROC)load("glPixelZoomxOES");
	glad_glPrioritizeTexturesxOES = (PFNGLPRIORITIZETEXTURESXOESPROC)load("glPrioritizeTexturesxOES");
	glad_glRasterPos2xOES = (PFNGLRASTERPOS2XOESPROC)load("glRasterPos2xOES");
	glad_glRasterPos2xvOES = (PFNGLRASTERPOS2XVOESPROC)load("glRasterPos2xvOES");
	glad_glRasterPos3xOES = (PFNGLRASTERPOS3XOESPROC)load("glRasterPos3xOES");
	glad_glRasterPos3xvOES = (PFNGLRASTERPOS3XVOESPROC)load("glRasterPos3xvOES");
	glad_glRasterPos4xOES = (PFNGLRASTERPOS4XOESPROC)load("glRasterPos4xOES");
	glad_glRasterPos4xvOES = (PFNGLRASTERPOS4XVOESPROC)load("glRasterPos4xvOES");
	glad_glRectxOES = (PFNGLRECTXOESPROC)load("glRectxOES");
	glad_glRectxvOES = (PFNGLRECTXVOESPROC)load("glRectxvOES");
	glad_glTexCoord1xOES = (PFNGLTEXCOORD1XOESPROC)load("glTexCoord1xOES");
	glad_glTexCoord1xvOES = (PFNGLTEXCOORD1XVOESPROC)load("glTexCoord1xvOES");
	glad_glTexCoord2xOES = (PFNGLTEXCOORD2XOESPROC)load("glTexCoord2xOES");
	glad_glTexCoord2xvOES = (PFNGLTEXCOORD2XVOESPROC)load("glTexCoord2xvOES");
	glad_glTexCoord3xOES = (PFNGLTEXCOORD3XOESPROC)load("glTexCoord3xOES");
	glad_glTexCoord3xvOES = (PFNGLTEXCOORD3XVOESPROC)load("glTexCoord3xvOES");
	glad_glTexCoord4xOES = (PFNGLTEXCOORD4XOESPROC)load("glTexCoord4xOES");
	glad_glTexCoord4xvOES = (PFNGLTEXCOORD4XVOESPROC)load("glTexCoord4xvOES");
	glad_glTexGenxOES = (PFNGLTEXGENXOESPROC)load("glTexGenxOES");
	glad_glTexGenxvOES = (PFNGLTEXGENXVOESPROC)load("glTexGenxvOES");
	glad_glVertex2xOES = (PFNGLVERTEX2XOESPROC)load("glVertex2xOES");
	glad_glVertex2xvOES = (PFNGLVERTEX2XVOESPROC)load("glVertex2xvOES");
	glad_glVertex3xOES = (PFNGLVERTEX3XOESPROC)load("glVertex3xOES");
	glad_glVertex3xvOES = (PFNGLVERTEX3XVOESPROC)load("glVertex3xvOES");
	glad_glVertex4xOES = (PFNGLVERTEX4XOESPROC)load("glVertex4xOES");
	glad_glVertex4xvOES = (PFNGLVERTEX4XVOESPROC)load("glVertex4xvOES");
}
static void load_GL_OES_query_matrix(GLADloadproc load) {
	if(!GLAD_GL_OES_query_matrix) return;
	glad_glQueryMatrixxOES = (PFNGLQUERYMATRIXXOESPROC)load("glQueryMatrixxOES");
}
static void load_GL_OES_single_precision(GLADloadproc load) {
	if(!GLAD_GL_OES_single_precision) return;
	glad_glClearDepthfOES = (PFNGLCLEARDEPTHFOESPROC)load("glClearDepthfOES");
	glad_glClipPlanefOES = (PFNGLCLIPPLANEFOESPROC)load("glClipPlanefOES");
	glad_glDepthRangefOES = (PFNGLDEPTHRANGEFOESPROC)load("glDepthRangefOES");
	glad_glFrustumfOES = (PFNGLFRUSTUMFOESPROC)load("glFrustumfOES");
	glad_glGetClipPlanefOES = (PFNGLGETCLIPPLANEFOESPROC)load("glGetClipPlanefOES");
	glad_glOrthofOES = (PFNGLORTHOFOESPROC)load("glOrthofOES");
}
static void load_GL_OVR_multiview(GLADloadproc load) {
	if(!GLAD_GL_OVR_multiview) return;
	glad_glFramebufferTextureMultiviewOVR = (PFNGLFRAMEBUFFERTEXTUREMULTIVIEWOVRPROC)load("glFramebufferTextureMultiviewOVR");
}
static void load_GL_PGI_misc_hints(GLADloadproc load) {
	if(!GLAD_GL_PGI_misc_hints) return;
	glad_glHintPGI = (PFNGLHINTPGIPROC)load("glHintPGI");
}
static void load_GL_SGIS_detail_texture(GLADloadproc load) {
	if(!GLAD_GL_SGIS_detail_texture) return;
	glad_glDetailTexFuncSGIS = (PFNGLDETAILTEXFUNCSGISPROC)load("glDetailTexFuncSGIS");
	glad_glGetDetailTexFuncSGIS = (PFNGLGETDETAILTEXFUNCSGISPROC)load("glGetDetailTexFuncSGIS");
}
static void load_GL_SGIS_fog_function(GLADloadproc load) {
	if(!GLAD_GL_SGIS_fog_function) return;
	glad_glFogFuncSGIS = (PFNGLFOGFUNCSGISPROC)load("glFogFuncSGIS");
	glad_glGetFogFuncSGIS = (PFNGLGETFOGFUNCSGISPROC)load("glGetFogFuncSGIS");
}
static void load_GL_SGIS_multisample(GLADloadproc load) {
	if(!GLAD_GL_SGIS_multisample) return;
	glad_glSampleMaskSGIS = (PFNGLSAMPLEMASKSGISPROC)load("glSampleMaskSGIS");
	glad_glSamplePatternSGIS = (PFNGLSAMPLEPATTERNSGISPROC)load("glSamplePatternSGIS");
}
static void load_GL_SGIS_pixel_texture(GLADloadproc load) {
	if(!GLAD_GL_SGIS_pixel_texture) return;
	glad_glPixelTexGenParameteriSGIS = (PFNGLPIXELTEXGENPARAMETERISGISPROC)load("glPixelTexGenParameteriSGIS");
	glad_glPixelTexGenParameterivSGIS = (PFNGLPIXELTEXGENPARAMETERIVSGISPROC)load("glPixelTexGenParameterivSGIS");
	glad_glPixelTexGenParameterfSGIS = (PFNGLPIXELTEXGENPARAMETERFSGISPROC)load("glPixelTexGenParameterfSGIS");
	glad_glPixelTexGenParameterfvSGIS = (PFNGLPIXELTEXGENPARAMETERFVSGISPROC)load("glPixelTexGenParameterfvSGIS");
	glad_glGetPixelTexGenParameterivSGIS = (PFNGLGETPIXELTEXGENPARAMETERIVSGISPROC)load("glGetPixelTexGenParameterivSGIS");
	glad_glGetPixelTexGenParameterfvSGIS = (PFNGLGETPIXELTEXGENPARAMETERFVSGISPROC)load("glGetPixelTexGenParameterfvSGIS");
}
static void load_GL_SGIS_point_parameters(GLADloadproc load) {
	if(!GLAD_GL_SGIS_point_parameters) return;
	glad_glPointParameterfSGIS = (PFNGLPOINTPARAMETERFSGISPROC)load("glPointParameterfSGIS");
	glad_glPointParameterfvSGIS = (PFNGLPOINTPARAMETERFVSGISPROC)load("glPointParameterfvSGIS");
}
static void load_GL_SGIS_sharpen_texture(GLADloadproc load) {
	if(!GLAD_GL_SGIS_sharpen_texture) return;
	glad_glSharpenTexFuncSGIS = (PFNGLSHARPENTEXFUNCSGISPROC)load("glSharpenTexFuncSGIS");
	glad_glGetSharpenTexFuncSGIS = (PFNGLGETSHARPENTEXFUNCSGISPROC)load("glGetSharpenTexFuncSGIS");
}
static void load_GL_SGIS_texture4D(GLADloadproc load) {
	if(!GLAD_GL_SGIS_texture4D) return;
	glad_glTexImage4DSGIS = (PFNGLTEXIMAGE4DSGISPROC)load("glTexImage4DSGIS");
	glad_glTexSubImage4DSGIS = (PFNGLTEXSUBIMAGE4DSGISPROC)load("glTexSubImage4DSGIS");
}
static void load_GL_SGIS_texture_color_mask(GLADloadproc load) {
	if(!GLAD_GL_SGIS_texture_color_mask) return;
	glad_glTextureColorMaskSGIS = (PFNGLTEXTURECOLORMASKSGISPROC)load("glTextureColorMaskSGIS");
}
static void load_GL_SGIS_texture_filter4(GLADloadproc load) {
	if(!GLAD_GL_SGIS_texture_filter4) return;
	glad_glGetTexFilterFuncSGIS = (PFNGLGETTEXFILTERFUNCSGISPROC)load("glGetTexFilterFuncSGIS");
	glad_glTexFilterFuncSGIS = (PFNGLTEXFILTERFUNCSGISPROC)load("glTexFilterFuncSGIS");
}
static void load_GL_SGIX_async(GLADloadproc load) {
	if(!GLAD_GL_SGIX_async) return;
	glad_glAsyncMarkerSGIX = (PFNGLASYNCMARKERSGIXPROC)load("glAsyncMarkerSGIX");
	glad_glFinishAsyncSGIX = (PFNGLFINISHASYNCSGIXPROC)load("glFinishAsyncSGIX");
	glad_glPollAsyncSGIX = (PFNGLPOLLASYNCSGIXPROC)load("glPollAsyncSGIX");
	glad_glGenAsyncMarkersSGIX = (PFNGLGENASYNCMARKERSSGIXPROC)load("glGenAsyncMarkersSGIX");
	glad_glDeleteAsyncMarkersSGIX = (PFNGLDELETEASYNCMARKERSSGIXPROC)load("glDeleteAsyncMarkersSGIX");
	glad_glIsAsyncMarkerSGIX = (PFNGLISASYNCMARKERSGIXPROC)load("glIsAsyncMarkerSGIX");
}
static void load_GL_SGIX_flush_raster(GLADloadproc load) {
	if(!GLAD_GL_SGIX_flush_raster) return;
	glad_glFlushRasterSGIX = (PFNGLFLUSHRASTERSGIXPROC)load("glFlushRasterSGIX");
}
static void load_GL_SGIX_fragment_lighting(GLADloadproc load) {
	if(!GLAD_GL_SGIX_fragment_lighting) return;
	glad_glFragmentColorMaterialSGIX = (PFNGLFRAGMENTCOLORMATERIALSGIXPROC)load("glFragmentColorMaterialSGIX");
	glad_glFragmentLightfSGIX = (PFNGLFRAGMENTLIGHTFSGIXPROC)load("glFragmentLightfSGIX");
	glad_glFragmentLightfvSGIX = (PFNGLFRAGMENTLIGHTFVSGIXPROC)load("glFragmentLightfvSGIX");
	glad_glFragmentLightiSGIX = (PFNGLFRAGMENTLIGHTISGIXPROC)load("glFragmentLightiSGIX");
	glad_glFragmentLightivSGIX = (PFNGLFRAGMENTLIGHTIVSGIXPROC)load("glFragmentLightivSGIX");
	glad_glFragmentLightModelfSGIX = (PFNGLFRAGMENTLIGHTMODELFSGIXPROC)load("glFragmentLightModelfSGIX");
	glad_glFragmentLightModelfvSGIX = (PFNGLFRAGMENTLIGHTMODELFVSGIXPROC)load("glFragmentLightModelfvSGIX");
	glad_glFragmentLightModeliSGIX = (PFNGLFRAGMENTLIGHTMODELISGIXPROC)load("glFragmentLightModeliSGIX");
	glad_glFragmentLightModelivSGIX = (PFNGLFRAGMENTLIGHTMODELIVSGIXPROC)load("glFragmentLightModelivSGIX");
	glad_glFragmentMaterialfSGIX = (PFNGLFRAGMENTMATERIALFSGIXPROC)load("glFragmentMaterialfSGIX");
	glad_glFragmentMaterialfvSGIX = (PFNGLFRAGMENTMATERIALFVSGIXPROC)load("glFragmentMaterialfvSGIX");
	glad_glFragmentMaterialiSGIX = (PFNGLFRAGMENTMATERIALISGIXPROC)load("glFragmentMaterialiSGIX");
	glad_glFragmentMaterialivSGIX = (PFNGLFRAGMENTMATERIALIVSGIXPROC)load("glFragmentMaterialivSGIX");
	glad_glGetFragmentLightfvSGIX = (PFNGLGETFRAGMENTLIGHTFVSGIXPROC)load("glGetFragmentLightfvSGIX");
	glad_glGetFragmentLightivSGIX = (PFNGLGETFRAGMENTLIGHTIVSGIXPROC)load("glGetFragmentLightivSGIX");
	glad_glGetFragmentMaterialfvSGIX = (PFNGLGETFRAGMENTMATERIALFVSGIXPROC)load("glGetFragmentMaterialfvSGIX");
	glad_glGetFragmentMaterialivSGIX = (PFNGLGETFRAGMENTMATERIALIVSGIXPROC)load("glGetFragmentMaterialivSGIX");
	glad_glLightEnviSGIX = (PFNGLLIGHTENVISGIXPROC)load("glLightEnviSGIX");
}
static void load_GL_SGIX_framezoom(GLADloadproc load) {
	if(!GLAD_GL_SGIX_framezoom) return;
	glad_glFrameZoomSGIX = (PFNGLFRAMEZOOMSGIXPROC)load("glFrameZoomSGIX");
}
static void load_GL_SGIX_igloo_interface(GLADloadproc load) {
	if(!GLAD_GL_SGIX_igloo_interface) return;
	glad_glIglooInterfaceSGIX = (PFNGLIGLOOINTERFACESGIXPROC)load("glIglooInterfaceSGIX");
}
static void load_GL_SGIX_instruments(GLADloadproc load) {
	if(!GLAD_GL_SGIX_instruments) return;
	glad_glGetInstrumentsSGIX = (PFNGLGETINSTRUMENTSSGIXPROC)load("glGetInstrumentsSGIX");
	glad_glInstrumentsBufferSGIX = (PFNGLINSTRUMENTSBUFFERSGIXPROC)load("glInstrumentsBufferSGIX");
	glad_glPollInstrumentsSGIX = (PFNGLPOLLINSTRUMENTSSGIXPROC)load("glPollInstrumentsSGIX");
	glad_glReadInstrumentsSGIX = (PFNGLREADINSTRUMENTSSGIXPROC)load("glReadInstrumentsSGIX");
	glad_glStartInstrumentsSGIX = (PFNGLSTARTINSTRUMENTSSGIXPROC)load("glStartInstrumentsSGIX");
	glad_glStopInstrumentsSGIX = (PFNGLSTOPINSTRUMENTSSGIXPROC)load("glStopInstrumentsSGIX");
}
static void load_GL_SGIX_list_priority(GLADloadproc load) {
	if(!GLAD_GL_SGIX_list_priority) return;
	glad_glGetListParameterfvSGIX = (PFNGLGETLISTPARAMETERFVSGIXPROC)load("glGetListParameterfvSGIX");
	glad_glGetListParameterivSGIX = (PFNGLGETLISTPARAMETERIVSGIXPROC)load("glGetListParameterivSGIX");
	glad_glListParameterfSGIX = (PFNGLLISTPARAMETERFSGIXPROC)load("glListParameterfSGIX");
	glad_glListParameterfvSGIX = (PFNGLLISTPARAMETERFVSGIXPROC)load("glListParameterfvSGIX");
	glad_glListParameteriSGIX = (PFNGLLISTPARAMETERISGIXPROC)load("glListParameteriSGIX");
	glad_glListParameterivSGIX = (PFNGLLISTPARAMETERIVSGIXPROC)load("glListParameterivSGIX");
}
static void load_GL_SGIX_pixel_texture(GLADloadproc load) {
	if(!GLAD_GL_SGIX_pixel_texture) return;
	glad_glPixelTexGenSGIX = (PFNGLPIXELTEXGENSGIXPROC)load("glPixelTexGenSGIX");
}
static void load_GL_SGIX_polynomial_ffd(GLADloadproc load) {
	if(!GLAD_GL_SGIX_polynomial_ffd) return;
	glad_glDeformationMap3dSGIX = (PFNGLDEFORMATIONMAP3DSGIXPROC)load("glDeformationMap3dSGIX");
	glad_glDeformationMap3fSGIX = (PFNGLDEFORMATIONMAP3FSGIXPROC)load("glDeformationMap3fSGIX");
	glad_glDeformSGIX = (PFNGLDEFORMSGIXPROC)load("glDeformSGIX");
	glad_glLoadIdentityDeformationMapSGIX = (PFNGLLOADIDENTITYDEFORMATIONMAPSGIXPROC)load("glLoadIdentityDeformationMapSGIX");
}
static void load_GL_SGIX_reference_plane(GLADloadproc load) {
	if(!GLAD_GL_SGIX_reference_plane) return;
	glad_glReferencePlaneSGIX = (PFNGLREFERENCEPLANESGIXPROC)load("glReferencePlaneSGIX");
}
static void load_GL_SGIX_sprite(GLADloadproc load) {
	if(!GLAD_GL_SGIX_sprite) return;
	glad_glSpriteParameterfSGIX = (PFNGLSPRITEPARAMETERFSGIXPROC)load("glSpriteParameterfSGIX");
	glad_glSpriteParameterfvSGIX = (PFNGLSPRITEPARAMETERFVSGIXPROC)load("glSpriteParameterfvSGIX");
	glad_glSpriteParameteriSGIX = (PFNGLSPRITEPARAMETERISGIXPROC)load("glSpriteParameteriSGIX");
	glad_glSpriteParameterivSGIX = (PFNGLSPRITEPARAMETERIVSGIXPROC)load("glSpriteParameterivSGIX");
}
static void load_GL_SGIX_tag_sample_buffer(GLADloadproc load) {
	if(!GLAD_GL_SGIX_tag_sample_buffer) return;
	glad_glTagSampleBufferSGIX = (PFNGLTAGSAMPLEBUFFERSGIXPROC)load("glTagSampleBufferSGIX");
}
static void load_GL_SGI_color_table(GLADloadproc load) {
	if(!GLAD_GL_SGI_color_table) return;
	glad_glColorTableSGI = (PFNGLCOLORTABLESGIPROC)load("glColorTableSGI");
	glad_glColorTableParameterfvSGI = (PFNGLCOLORTABLEPARAMETERFVSGIPROC)load("glColorTableParameterfvSGI");
	glad_glColorTableParameterivSGI = (PFNGLCOLORTABLEPARAMETERIVSGIPROC)load("glColorTableParameterivSGI");
	glad_glCopyColorTableSGI = (PFNGLCOPYCOLORTABLESGIPROC)load("glCopyColorTableSGI");
	glad_glGetColorTableSGI = (PFNGLGETCOLORTABLESGIPROC)load("glGetColorTableSGI");
	glad_glGetColorTableParameterfvSGI = (PFNGLGETCOLORTABLEPARAMETERFVSGIPROC)load("glGetColorTableParameterfvSGI");
	glad_glGetColorTableParameterivSGI = (PFNGLGETCOLORTABLEPARAMETERIVSGIPROC)load("glGetColorTableParameterivSGI");
}
static void load_GL_SUNX_constant_data(GLADloadproc load) {
	if(!GLAD_GL_SUNX_constant_data) return;
	glad_glFinishTextureSUNX = (PFNGLFINISHTEXTURESUNXPROC)load("glFinishTextureSUNX");
}
static void load_GL_SUN_global_alpha(GLADloadproc load) {
	if(!GLAD_GL_SUN_global_alpha) return;
	glad_glGlobalAlphaFactorbSUN = (PFNGLGLOBALALPHAFACTORBSUNPROC)load("glGlobalAlphaFactorbSUN");
	glad_glGlobalAlphaFactorsSUN = (PFNGLGLOBALALPHAFACTORSSUNPROC)load("glGlobalAlphaFactorsSUN");
	glad_glGlobalAlphaFactoriSUN = (PFNGLGLOBALALPHAFACTORISUNPROC)load("glGlobalAlphaFactoriSUN");
	glad_glGlobalAlphaFactorfSUN = (PFNGLGLOBALALPHAFACTORFSUNPROC)load("glGlobalAlphaFactorfSUN");
	glad_glGlobalAlphaFactordSUN = (PFNGLGLOBALALPHAFACTORDSUNPROC)load("glGlobalAlphaFactordSUN");
	glad_glGlobalAlphaFactorubSUN = (PFNGLGLOBALALPHAFACTORUBSUNPROC)load("glGlobalAlphaFactorubSUN");
	glad_glGlobalAlphaFactorusSUN = (PFNGLGLOBALALPHAFACTORUSSUNPROC)load("glGlobalAlphaFactorusSUN");
	glad_glGlobalAlphaFactoruiSUN = (PFNGLGLOBALALPHAFACTORUISUNPROC)load("glGlobalAlphaFactoruiSUN");
}
static void load_GL_SUN_mesh_array(GLADloadproc load) {
	if(!GLAD_GL_SUN_mesh_array) return;
	glad_glDrawMeshArraysSUN = (PFNGLDRAWMESHARRAYSSUNPROC)load("glDrawMeshArraysSUN");
}
static void load_GL_SUN_triangle_list(GLADloadproc load) {
	if(!GLAD_GL_SUN_triangle_list) return;
	glad_glReplacementCodeuiSUN = (PFNGLREPLACEMENTCODEUISUNPROC)load("glReplacementCodeuiSUN");
	glad_glReplacementCodeusSUN = (PFNGLREPLACEMENTCODEUSSUNPROC)load("glReplacementCodeusSUN");
	glad_glReplacementCodeubSUN = (PFNGLREPLACEMENTCODEUBSUNPROC)load("glReplacementCodeubSUN");
	glad_glReplacementCodeuivSUN = (PFNGLREPLACEMENTCODEUIVSUNPROC)load("glReplacementCodeuivSUN");
	glad_glReplacementCodeusvSUN = (PFNGLREPLACEMENTCODEUSVSUNPROC)load("glReplacementCodeusvSUN");
	glad_glReplacementCodeubvSUN = (PFNGLREPLACEMENTCODEUBVSUNPROC)load("glReplacementCodeubvSUN");
	glad_glReplacementCodePointerSUN = (PFNGLREPLACEMENTCODEPOINTERSUNPROC)load("glReplacementCodePointerSUN");
}
static void load_GL_SUN_vertex(GLADloadproc load) {
	if(!GLAD_GL_SUN_vertex) return;
	glad_glColor4ubVertex2fSUN = (PFNGLCOLOR4UBVERTEX2FSUNPROC)load("glColor4ubVertex2fSUN");
	glad_glColor4ubVertex2fvSUN = (PFNGLCOLOR4UBVERTEX2FVSUNPROC)load("glColor4ubVertex2fvSUN");
	glad_glColor4ubVertex3fSUN = (PFNGLCOLOR4UBVERTEX3FSUNPROC)load("glColor4ubVertex3fSUN");
	glad_glColor4ubVertex3fvSUN = (PFNGLCOLOR4UBVERTEX3FVSUNPROC)load("glColor4ubVertex3fvSUN");
	glad_glColor3fVertex3fSUN = (PFNGLCOLOR3FVERTEX3FSUNPROC)load("glColor3fVertex3fSUN");
	glad_glColor3fVertex3fvSUN = (PFNGLCOLOR3FVERTEX3FVSUNPROC)load("glColor3fVertex3fvSUN");
	glad_glNormal3fVertex3fSUN = (PFNGLNORMAL3FVERTEX3FSUNPROC)load("glNormal3fVertex3fSUN");
	glad_glNormal3fVertex3fvSUN = (PFNGLNORMAL3FVERTEX3FVSUNPROC)load("glNormal3fVertex3fvSUN");
	glad_glColor4fNormal3fVertex3fSUN = (PFNGLCOLOR4FNORMAL3FVERTEX3FSUNPROC)load("glColor4fNormal3fVertex3fSUN");
	glad_glColor4fNormal3fVertex3fvSUN = (PFNGLCOLOR4FNORMAL3FVERTEX3FVSUNPROC)load("glColor4fNormal3fVertex3fvSUN");
	glad_glTexCoord2fVertex3fSUN = (PFNGLTEXCOORD2FVERTEX3FSUNPROC)load("glTexCoord2fVertex3fSUN");
	glad_glTexCoord2fVertex3fvSUN = (PFNGLTEXCOORD2FVERTEX3FVSUNPROC)load("glTexCoord2fVertex3fvSUN");
	glad_glTexCoord4fVertex4fSUN = (PFNGLTEXCOORD4FVERTEX4FSUNPROC)load("glTexCoord4fVertex4fSUN");
	glad_glTexCoord4fVertex4fvSUN = (PFNGLTEXCOORD4FVERTEX4FVSUNPROC)load("glTexCoord4fVertex4fvSUN");
	glad_glTexCoord2fColor4ubVertex3fSUN = (PFNGLTEXCOORD2FCOLOR4UBVERTEX3FSUNPROC)load("glTexCoord2fColor4ubVertex3fSUN");
	glad_glTexCoord2fColor4ubVertex3fvSUN = (PFNGLTEXCOORD2FCOLOR4UBVERTEX3FVSUNPROC)load("glTexCoord2fColor4ubVertex3fvSUN");
	glad_glTexCoord2fColor3fVertex3fSUN = (PFNGLTEXCOORD2FCOLOR3FVERTEX3FSUNPROC)load("glTexCoord2fColor3fVertex3fSUN");
	glad_glTexCoord2fColor3fVertex3fvSUN = (PFNGLTEXCOORD2FCOLOR3FVERTEX3FVSUNPROC)load("glTexCoord2fColor3fVertex3fvSUN");
	glad_glTexCoord2fNormal3fVertex3fSUN = (PFNGLTEXCOORD2FNORMAL3FVERTEX3FSUNPROC)load("glTexCoord2fNormal3fVertex3fSUN");
	glad_glTexCoord2fNormal3fVertex3fvSUN = (PFNGLTEXCOORD2FNORMAL3FVERTEX3FVSUNPROC)load("glTexCoord2fNormal3fVertex3fvSUN");
	glad_glTexCoord2fColor4fNormal3fVertex3fSUN = (PFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC)load("glTexCoord2fColor4fNormal3fVertex3fSUN");
	glad_glTexCoord2fColor4fNormal3fVertex3fvSUN = (PFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC)load("glTexCoord2fColor4fNormal3fVertex3fvSUN");
	glad_glTexCoord4fColor4fNormal3fVertex4fSUN = (PFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FSUNPROC)load("glTexCoord4fColor4fNormal3fVertex4fSUN");
	glad_glTexCoord4fColor4fNormal3fVertex4fvSUN = (PFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FVSUNPROC)load("glTexCoord4fColor4fNormal3fVertex4fvSUN");
	glad_glReplacementCodeuiVertex3fSUN = (PFNGLREPLACEMENTCODEUIVERTEX3FSUNPROC)load("glReplacementCodeuiVertex3fSUN");
	glad_glReplacementCodeuiVertex3fvSUN = (PFNGLREPLACEMENTCODEUIVERTEX3FVSUNPROC)load("glReplacementCodeuiVertex3fvSUN");
	glad_glReplacementCodeuiColor4ubVertex3fSUN = (PFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FSUNPROC)load("glReplacementCodeuiColor4ubVertex3fSUN");
	glad_glReplacementCodeuiColor4ubVertex3fvSUN = (PFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FVSUNPROC)load("glReplacementCodeuiColor4ubVertex3fvSUN");
	glad_glReplacementCodeuiColor3fVertex3fSUN = (PFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FSUNPROC)load("glReplacementCodeuiColor3fVertex3fSUN");
	glad_glReplacementCodeuiColor3fVertex3fvSUN = (PFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FVSUNPROC)load("glReplacementCodeuiColor3fVertex3fvSUN");
	glad_glReplacementCodeuiNormal3fVertex3fSUN = (PFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FSUNPROC)load("glReplacementCodeuiNormal3fVertex3fSUN");
	glad_glReplacementCodeuiNormal3fVertex3fvSUN = (PFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FVSUNPROC)load("glReplacementCodeuiNormal3fVertex3fvSUN");
	glad_glReplacementCodeuiColor4fNormal3fVertex3fSUN = (PFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FSUNPROC)load("glReplacementCodeuiColor4fNormal3fVertex3fSUN");
	glad_glReplacementCodeuiColor4fNormal3fVertex3fvSUN = (PFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FVSUNPROC)load("glReplacementCodeuiColor4fNormal3fVertex3fvSUN");
	glad_glReplacementCodeuiTexCoord2fVertex3fSUN = (PFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FSUNPROC)load("glReplacementCodeuiTexCoord2fVertex3fSUN");
	glad_glReplacementCodeuiTexCoord2fVertex3fvSUN = (PFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FVSUNPROC)load("glReplacementCodeuiTexCoord2fVertex3fvSUN");
	glad_glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN = (PFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FSUNPROC)load("glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN");
	glad_glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN = (PFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FVSUNPROC)load("glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN");
	glad_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN = (PFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC)load("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN");
	glad_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN = (PFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC)load("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN");
}
static int find_extensionsGL(void) {
	if (!get_exts()) return 0;
	GLAD_GL_3DFX_multisample = has_ext("GL_3DFX_multisample");
	GLAD_GL_3DFX_tbuffer = has_ext("GL_3DFX_tbuffer");
	GLAD_GL_3DFX_texture_compression_FXT1 = has_ext("GL_3DFX_texture_compression_FXT1");
	GLAD_GL_AMD_blend_minmax_factor = has_ext("GL_AMD_blend_minmax_factor");
	GLAD_GL_AMD_conservative_depth = has_ext("GL_AMD_conservative_depth");
	GLAD_GL_AMD_debug_output = has_ext("GL_AMD_debug_output");
	GLAD_GL_AMD_depth_clamp_separate = has_ext("GL_AMD_depth_clamp_separate");
	GLAD_GL_AMD_draw_buffers_blend = has_ext("GL_AMD_draw_buffers_blend");
	GLAD_GL_AMD_gcn_shader = has_ext("GL_AMD_gcn_shader");
	GLAD_GL_AMD_gpu_shader_int64 = has_ext("GL_AMD_gpu_shader_int64");
	GLAD_GL_AMD_interleaved_elements = has_ext("GL_AMD_interleaved_elements");
	GLAD_GL_AMD_multi_draw_indirect = has_ext("GL_AMD_multi_draw_indirect");
	GLAD_GL_AMD_name_gen_delete = has_ext("GL_AMD_name_gen_delete");
	GLAD_GL_AMD_occlusion_query_event = has_ext("GL_AMD_occlusion_query_event");
	GLAD_GL_AMD_performance_monitor = has_ext("GL_AMD_performance_monitor");
	GLAD_GL_AMD_pinned_memory = has_ext("GL_AMD_pinned_memory");
	GLAD_GL_AMD_query_buffer_object = has_ext("GL_AMD_query_buffer_object");
	GLAD_GL_AMD_sample_positions = has_ext("GL_AMD_sample_positions");
	GLAD_GL_AMD_seamless_cubemap_per_texture = has_ext("GL_AMD_seamless_cubemap_per_texture");
	GLAD_GL_AMD_shader_atomic_counter_ops = has_ext("GL_AMD_shader_atomic_counter_ops");
	GLAD_GL_AMD_shader_explicit_vertex_parameter = has_ext("GL_AMD_shader_explicit_vertex_parameter");
	GLAD_GL_AMD_shader_stencil_export = has_ext("GL_AMD_shader_stencil_export");
	GLAD_GL_AMD_shader_trinary_minmax = has_ext("GL_AMD_shader_trinary_minmax");
	GLAD_GL_AMD_sparse_texture = has_ext("GL_AMD_sparse_texture");
	GLAD_GL_AMD_stencil_operation_extended = has_ext("GL_AMD_stencil_operation_extended");
	GLAD_GL_AMD_texture_texture4 = has_ext("GL_AMD_texture_texture4");
	GLAD_GL_AMD_transform_feedback3_lines_triangles = has_ext("GL_AMD_transform_feedback3_lines_triangles");
	GLAD_GL_AMD_transform_feedback4 = has_ext("GL_AMD_transform_feedback4");
	GLAD_GL_AMD_vertex_shader_layer = has_ext("GL_AMD_vertex_shader_layer");
	GLAD_GL_AMD_vertex_shader_tessellator = has_ext("GL_AMD_vertex_shader_tessellator");
	GLAD_GL_AMD_vertex_shader_viewport_index = has_ext("GL_AMD_vertex_shader_viewport_index");
	GLAD_GL_APPLE_aux_depth_stencil = has_ext("GL_APPLE_aux_depth_stencil");
	GLAD_GL_APPLE_client_storage = has_ext("GL_APPLE_client_storage");
	GLAD_GL_APPLE_element_array = has_ext("GL_APPLE_element_array");
	GLAD_GL_APPLE_fence = has_ext("GL_APPLE_fence");
	GLAD_GL_APPLE_float_pixels = has_ext("GL_APPLE_float_pixels");
	GLAD_GL_APPLE_flush_buffer_range = has_ext("GL_APPLE_flush_buffer_range");
	GLAD_GL_APPLE_object_purgeable = has_ext("GL_APPLE_object_purgeable");
	GLAD_GL_APPLE_rgb_422 = has_ext("GL_APPLE_rgb_422");
	GLAD_GL_APPLE_row_bytes = has_ext("GL_APPLE_row_bytes");
	GLAD_GL_APPLE_specular_vector = has_ext("GL_APPLE_specular_vector");
	GLAD_GL_APPLE_texture_range = has_ext("GL_APPLE_texture_range");
	GLAD_GL_APPLE_transform_hint = has_ext("GL_APPLE_transform_hint");
	GLAD_GL_APPLE_vertex_array_object = has_ext("GL_APPLE_vertex_array_object");
	GLAD_GL_APPLE_vertex_array_range = has_ext("GL_APPLE_vertex_array_range");
	GLAD_GL_APPLE_vertex_program_evaluators = has_ext("GL_APPLE_vertex_program_evaluators");
	GLAD_GL_APPLE_ycbcr_422 = has_ext("GL_APPLE_ycbcr_422");
	GLAD_GL_ARB_ES2_compatibility = has_ext("GL_ARB_ES2_compatibility");
	GLAD_GL_ARB_ES3_1_compatibility = has_ext("GL_ARB_ES3_1_compatibility");
	GLAD_GL_ARB_ES3_2_compatibility = has_ext("GL_ARB_ES3_2_compatibility");
	GLAD_GL_ARB_ES3_compatibility = has_ext("GL_ARB_ES3_compatibility");
	GLAD_GL_ARB_arrays_of_arrays = has_ext("GL_ARB_arrays_of_arrays");
	GLAD_GL_ARB_base_instance = has_ext("GL_ARB_base_instance");
	GLAD_GL_ARB_bindless_texture = has_ext("GL_ARB_bindless_texture");
	GLAD_GL_ARB_blend_func_extended = has_ext("GL_ARB_blend_func_extended");
	GLAD_GL_ARB_buffer_storage = has_ext("GL_ARB_buffer_storage");
	GLAD_GL_ARB_cl_event = has_ext("GL_ARB_cl_event");
	GLAD_GL_ARB_clear_buffer_object = has_ext("GL_ARB_clear_buffer_object");
	GLAD_GL_ARB_clear_texture = has_ext("GL_ARB_clear_texture");
	GLAD_GL_ARB_clip_control = has_ext("GL_ARB_clip_control");
	GLAD_GL_ARB_color_buffer_float = has_ext("GL_ARB_color_buffer_float");
	GLAD_GL_ARB_compatibility = has_ext("GL_ARB_compatibility");
	GLAD_GL_ARB_compressed_texture_pixel_storage = has_ext("GL_ARB_compressed_texture_pixel_storage");
	GLAD_GL_ARB_compute_shader = has_ext("GL_ARB_compute_shader");
	GLAD_GL_ARB_compute_variable_group_size = has_ext("GL_ARB_compute_variable_group_size");
	GLAD_GL_ARB_conditional_render_inverted = has_ext("GL_ARB_conditional_render_inverted");
	GLAD_GL_ARB_conservative_depth = has_ext("GL_ARB_conservative_depth");
	GLAD_GL_ARB_copy_buffer = has_ext("GL_ARB_copy_buffer");
	GLAD_GL_ARB_copy_image = has_ext("GL_ARB_copy_image");
	GLAD_GL_ARB_cull_distance = has_ext("GL_ARB_cull_distance");
	GLAD_GL_ARB_debug_output = has_ext("GL_ARB_debug_output");
	GLAD_GL_ARB_depth_buffer_float = has_ext("GL_ARB_depth_buffer_float");
	GLAD_GL_ARB_depth_clamp = has_ext("GL_ARB_depth_clamp");
	GLAD_GL_ARB_depth_texture = has_ext("GL_ARB_depth_texture");
	GLAD_GL_ARB_derivative_control = has_ext("GL_ARB_derivative_control");
	GLAD_GL_ARB_direct_state_access = has_ext("GL_ARB_direct_state_access");
	GLAD_GL_ARB_draw_buffers = has_ext("GL_ARB_draw_buffers");
	GLAD_GL_ARB_draw_buffers_blend = has_ext("GL_ARB_draw_buffers_blend");
	GLAD_GL_ARB_draw_elements_base_vertex = has_ext("GL_ARB_draw_elements_base_vertex");
	GLAD_GL_ARB_draw_indirect = has_ext("GL_ARB_draw_indirect");
	GLAD_GL_ARB_draw_instanced = has_ext("GL_ARB_draw_instanced");
	GLAD_GL_ARB_enhanced_layouts = has_ext("GL_ARB_enhanced_layouts");
	GLAD_GL_ARB_explicit_attrib_location = has_ext("GL_ARB_explicit_attrib_location");
	GLAD_GL_ARB_explicit_uniform_location = has_ext("GL_ARB_explicit_uniform_location");
	GLAD_GL_ARB_fragment_coord_conventions = has_ext("GL_ARB_fragment_coord_conventions");
	GLAD_GL_ARB_fragment_layer_viewport = has_ext("GL_ARB_fragment_layer_viewport");
	GLAD_GL_ARB_fragment_program = has_ext("GL_ARB_fragment_program");
	GLAD_GL_ARB_fragment_program_shadow = has_ext("GL_ARB_fragment_program_shadow");
	GLAD_GL_ARB_fragment_shader = has_ext("GL_ARB_fragment_shader");
	GLAD_GL_ARB_fragment_shader_interlock = has_ext("GL_ARB_fragment_shader_interlock");
	GLAD_GL_ARB_framebuffer_no_attachments = has_ext("GL_ARB_framebuffer_no_attachments");
	GLAD_GL_ARB_framebuffer_object = has_ext("GL_ARB_framebuffer_object");
	GLAD_GL_ARB_framebuffer_sRGB = has_ext("GL_ARB_framebuffer_sRGB");
	GLAD_GL_ARB_geometry_shader4 = has_ext("GL_ARB_geometry_shader4");
	GLAD_GL_ARB_get_program_binary = has_ext("GL_ARB_get_program_binary");
	GLAD_GL_ARB_get_texture_sub_image = has_ext("GL_ARB_get_texture_sub_image");
	GLAD_GL_ARB_gpu_shader5 = has_ext("GL_ARB_gpu_shader5");
	GLAD_GL_ARB_gpu_shader_fp64 = has_ext("GL_ARB_gpu_shader_fp64");
	GLAD_GL_ARB_gpu_shader_int64 = has_ext("GL_ARB_gpu_shader_int64");
	GLAD_GL_ARB_half_float_pixel = has_ext("GL_ARB_half_float_pixel");
	GLAD_GL_ARB_half_float_vertex = has_ext("GL_ARB_half_float_vertex");
	GLAD_GL_ARB_imaging = has_ext("GL_ARB_imaging");
	GLAD_GL_ARB_indirect_parameters = has_ext("GL_ARB_indirect_parameters");
	GLAD_GL_ARB_instanced_arrays = has_ext("GL_ARB_instanced_arrays");
	GLAD_GL_ARB_internalformat_query = has_ext("GL_ARB_internalformat_query");
	GLAD_GL_ARB_internalformat_query2 = has_ext("GL_ARB_internalformat_query2");
	GLAD_GL_ARB_invalidate_subdata = has_ext("GL_ARB_invalidate_subdata");
	GLAD_GL_ARB_map_buffer_alignment = has_ext("GL_ARB_map_buffer_alignment");
	GLAD_GL_ARB_map_buffer_range = has_ext("GL_ARB_map_buffer_range");
	GLAD_GL_ARB_matrix_palette = has_ext("GL_ARB_matrix_palette");
	GLAD_GL_ARB_multi_bind = has_ext("GL_ARB_multi_bind");
	GLAD_GL_ARB_multi_draw_indirect = has_ext("GL_ARB_multi_draw_indirect");
	GLAD_GL_ARB_multisample = has_ext("GL_ARB_multisample");
	GLAD_GL_ARB_multitexture = has_ext("GL_ARB_multitexture");
	GLAD_GL_ARB_occlusion_query = has_ext("GL_ARB_occlusion_query");
	GLAD_GL_ARB_occlusion_query2 = has_ext("GL_ARB_occlusion_query2");
	GLAD_GL_ARB_parallel_shader_compile = has_ext("GL_ARB_parallel_shader_compile");
	GLAD_GL_ARB_pipeline_statistics_query = has_ext("GL_ARB_pipeline_statistics_query");
	GLAD_GL_ARB_pixel_buffer_object = has_ext("GL_ARB_pixel_buffer_object");
	GLAD_GL_ARB_point_parameters = has_ext("GL_ARB_point_parameters");
	GLAD_GL_ARB_point_sprite = has_ext("GL_ARB_point_sprite");
	GLAD_GL_ARB_post_depth_coverage = has_ext("GL_ARB_post_depth_coverage");
	GLAD_GL_ARB_program_interface_query = has_ext("GL_ARB_program_interface_query");
	GLAD_GL_ARB_provoking_vertex = has_ext("GL_ARB_provoking_vertex");
	GLAD_GL_ARB_query_buffer_object = has_ext("GL_ARB_query_buffer_object");
	GLAD_GL_ARB_robust_buffer_access_behavior = has_ext("GL_ARB_robust_buffer_access_behavior");
	GLAD_GL_ARB_robustness = has_ext("GL_ARB_robustness");
	GLAD_GL_ARB_robustness_isolation = has_ext("GL_ARB_robustness_isolation");
	GLAD_GL_ARB_sample_locations = has_ext("GL_ARB_sample_locations");
	GLAD_GL_ARB_sample_shading = has_ext("GL_ARB_sample_shading");
	GLAD_GL_ARB_sampler_objects = has_ext("GL_ARB_sampler_objects");
	GLAD_GL_ARB_seamless_cube_map = has_ext("GL_ARB_seamless_cube_map");
	GLAD_GL_ARB_seamless_cubemap_per_texture = has_ext("GL_ARB_seamless_cubemap_per_texture");
	GLAD_GL_ARB_separate_shader_objects = has_ext("GL_ARB_separate_shader_objects");
	GLAD_GL_ARB_shader_atomic_counter_ops = has_ext("GL_ARB_shader_atomic_counter_ops");
	GLAD_GL_ARB_shader_atomic_counters = has_ext("GL_ARB_shader_atomic_counters");
	GLAD_GL_ARB_shader_ballot = has_ext("GL_ARB_shader_ballot");
	GLAD_GL_ARB_shader_bit_encoding = has_ext("GL_ARB_shader_bit_encoding");
	GLAD_GL_ARB_shader_clock = has_ext("GL_ARB_shader_clock");
	GLAD_GL_ARB_shader_draw_parameters = has_ext("GL_ARB_shader_draw_parameters");
	GLAD_GL_ARB_shader_group_vote = has_ext("GL_ARB_shader_group_vote");
	GLAD_GL_ARB_shader_image_load_store = has_ext("GL_ARB_shader_image_load_store");
	GLAD_GL_ARB_shader_image_size = has_ext("GL_ARB_shader_image_size");
	GLAD_GL_ARB_shader_objects = has_ext("GL_ARB_shader_objects");
	GLAD_GL_ARB_shader_precision = has_ext("GL_ARB_shader_precision");
	GLAD_GL_ARB_shader_stencil_export = has_ext("GL_ARB_shader_stencil_export");
	GLAD_GL_ARB_shader_storage_buffer_object = has_ext("GL_ARB_shader_storage_buffer_object");
	GLAD_GL_ARB_shader_subroutine = has_ext("GL_ARB_shader_subroutine");
	GLAD_GL_ARB_shader_texture_image_samples = has_ext("GL_ARB_shader_texture_image_samples");
	GLAD_GL_ARB_shader_texture_lod = has_ext("GL_ARB_shader_texture_lod");
	GLAD_GL_ARB_shader_viewport_layer_array = has_ext("GL_ARB_shader_viewport_layer_array");
	GLAD_GL_ARB_shading_language_100 = has_ext("GL_ARB_shading_language_100");
	GLAD_GL_ARB_shading_language_420pack = has_ext("GL_ARB_shading_language_420pack");
	GLAD_GL_ARB_shading_language_include = has_ext("GL_ARB_shading_language_include");
	GLAD_GL_ARB_shading_language_packing = has_ext("GL_ARB_shading_language_packing");
	GLAD_GL_ARB_shadow = has_ext("GL_ARB_shadow");
	GLAD_GL_ARB_shadow_ambient = has_ext("GL_ARB_shadow_ambient");
	GLAD_GL_ARB_sparse_buffer = has_ext("GL_ARB_sparse_buffer");
	GLAD_GL_ARB_sparse_texture = has_ext("GL_ARB_sparse_texture");
	GLAD_GL_ARB_sparse_texture2 = has_ext("GL_ARB_sparse_texture2");
	GLAD_GL_ARB_sparse_texture_clamp = has_ext("GL_ARB_sparse_texture_clamp");
	GLAD_GL_ARB_stencil_texturing = has_ext("GL_ARB_stencil_texturing");
	GLAD_GL_ARB_sync = has_ext("GL_ARB_sync");
	GLAD_GL_ARB_tessellation_shader = has_ext("GL_ARB_tessellation_shader");
	GLAD_GL_ARB_texture_barrier = has_ext("GL_ARB_texture_barrier");
	GLAD_GL_ARB_texture_border_clamp = has_ext("GL_ARB_texture_border_clamp");
	GLAD_GL_ARB_texture_buffer_object = has_ext("GL_ARB_texture_buffer_object");
	GLAD_GL_ARB_texture_buffer_object_rgb32 = has_ext("GL_ARB_texture_buffer_object_rgb32");
	GLAD_GL_ARB_texture_buffer_range = has_ext("GL_ARB_texture_buffer_range");
	GLAD_GL_ARB_texture_compression = has_ext("GL_ARB_texture_compression");
	GLAD_GL_ARB_texture_compression_bptc = has_ext("GL_ARB_texture_compression_bptc");
	GLAD_GL_ARB_texture_compression_rgtc = has_ext("GL_ARB_texture_compression_rgtc");
	GLAD_GL_ARB_texture_cube_map = has_ext("GL_ARB_texture_cube_map");
	GLAD_GL_ARB_texture_cube_map_array = has_ext("GL_ARB_texture_cube_map_array");
	GLAD_GL_ARB_texture_env_add = has_ext("GL_ARB_texture_env_add");
	GLAD_GL_ARB_texture_env_combine = has_ext("GL_ARB_texture_env_combine");
	GLAD_GL_ARB_texture_env_crossbar = has_ext("GL_ARB_texture_env_crossbar");
	GLAD_GL_ARB_texture_env_dot3 = has_ext("GL_ARB_texture_env_dot3");
	GLAD_GL_ARB_texture_filter_minmax = has_ext("GL_ARB_texture_filter_minmax");
	GLAD_GL_ARB_texture_float = has_ext("GL_ARB_texture_float");
	GLAD_GL_ARB_texture_gather = has_ext("GL_ARB_texture_gather");
	GLAD_GL_ARB_texture_mirror_clamp_to_edge = has_ext("GL_ARB_texture_mirror_clamp_to_edge");
	GLAD_GL_ARB_texture_mirrored_repeat = has_ext("GL_ARB_texture_mirrored_repeat");
	GLAD_GL_ARB_texture_multisample = has_ext("GL_ARB_texture_multisample");
	GLAD_GL_ARB_texture_non_power_of_two = has_ext("GL_ARB_texture_non_power_of_two");
	GLAD_GL_ARB_texture_query_levels = has_ext("GL_ARB_texture_query_levels");
	GLAD_GL_ARB_texture_query_lod = has_ext("GL_ARB_texture_query_lod");
	GLAD_GL_ARB_texture_rectangle = has_ext("GL_ARB_texture_rectangle");
	GLAD_GL_ARB_texture_rg = has_ext("GL_ARB_texture_rg");
	GLAD_GL_ARB_texture_rgb10_a2ui = has_ext("GL_ARB_texture_rgb10_a2ui");
	GLAD_GL_ARB_texture_stencil8 = has_ext("GL_ARB_texture_stencil8");
	GLAD_GL_ARB_texture_storage = has_ext("GL_ARB_texture_storage");
	GLAD_GL_ARB_texture_storage_multisample = has_ext("GL_ARB_texture_storage_multisample");
	GLAD_GL_ARB_texture_swizzle = has_ext("GL_ARB_texture_swizzle");
	GLAD_GL_ARB_texture_view = has_ext("GL_ARB_texture_view");
	GLAD_GL_ARB_timer_query = has_ext("GL_ARB_timer_query");
	GLAD_GL_ARB_transform_feedback2 = has_ext("GL_ARB_transform_feedback2");
	GLAD_GL_ARB_transform_feedback3 = has_ext("GL_ARB_transform_feedback3");
	GLAD_GL_ARB_transform_feedback_instanced = has_ext("GL_ARB_transform_feedback_instanced");
	GLAD_GL_ARB_transform_feedback_overflow_query = has_ext("GL_ARB_transform_feedback_overflow_query");
	GLAD_GL_ARB_transpose_matrix = has_ext("GL_ARB_transpose_matrix");
	GLAD_GL_ARB_uniform_buffer_object = has_ext("GL_ARB_uniform_buffer_object");
	GLAD_GL_ARB_vertex_array_bgra = has_ext("GL_ARB_vertex_array_bgra");
	GLAD_GL_ARB_vertex_array_object = has_ext("GL_ARB_vertex_array_object");
	GLAD_GL_ARB_vertex_attrib_64bit = has_ext("GL_ARB_vertex_attrib_64bit");
	GLAD_GL_ARB_vertex_attrib_binding = has_ext("GL_ARB_vertex_attrib_binding");
	GLAD_GL_ARB_vertex_blend = has_ext("GL_ARB_vertex_blend");
	GLAD_GL_ARB_vertex_buffer_object = has_ext("GL_ARB_vertex_buffer_object");
	GLAD_GL_ARB_vertex_program = has_ext("GL_ARB_vertex_program");
	GLAD_GL_ARB_vertex_shader = has_ext("GL_ARB_vertex_shader");
	GLAD_GL_ARB_vertex_type_10f_11f_11f_rev = has_ext("GL_ARB_vertex_type_10f_11f_11f_rev");
	GLAD_GL_ARB_vertex_type_2_10_10_10_rev = has_ext("GL_ARB_vertex_type_2_10_10_10_rev");
	GLAD_GL_ARB_viewport_array = has_ext("GL_ARB_viewport_array");
	GLAD_GL_ARB_window_pos = has_ext("GL_ARB_window_pos");
	GLAD_GL_ATI_draw_buffers = has_ext("GL_ATI_draw_buffers");
	GLAD_GL_ATI_element_array = has_ext("GL_ATI_element_array");
	GLAD_GL_ATI_envmap_bumpmap = has_ext("GL_ATI_envmap_bumpmap");
	GLAD_GL_ATI_fragment_shader = has_ext("GL_ATI_fragment_shader");
	GLAD_GL_ATI_map_object_buffer = has_ext("GL_ATI_map_object_buffer");
	GLAD_GL_ATI_meminfo = has_ext("GL_ATI_meminfo");
	GLAD_GL_ATI_pixel_format_float = has_ext("GL_ATI_pixel_format_float");
	GLAD_GL_ATI_pn_triangles = has_ext("GL_ATI_pn_triangles");
	GLAD_GL_ATI_separate_stencil = has_ext("GL_ATI_separate_stencil");
	GLAD_GL_ATI_text_fragment_shader = has_ext("GL_ATI_text_fragment_shader");
	GLAD_GL_ATI_texture_env_combine3 = has_ext("GL_ATI_texture_env_combine3");
	GLAD_GL_ATI_texture_float = has_ext("GL_ATI_texture_float");
	GLAD_GL_ATI_texture_mirror_once = has_ext("GL_ATI_texture_mirror_once");
	GLAD_GL_ATI_vertex_array_object = has_ext("GL_ATI_vertex_array_object");
	GLAD_GL_ATI_vertex_attrib_array_object = has_ext("GL_ATI_vertex_attrib_array_object");
	GLAD_GL_ATI_vertex_streams = has_ext("GL_ATI_vertex_streams");
	GLAD_GL_EXT_422_pixels = has_ext("GL_EXT_422_pixels");
	GLAD_GL_EXT_abgr = has_ext("GL_EXT_abgr");
	GLAD_GL_EXT_bgra = has_ext("GL_EXT_bgra");
	GLAD_GL_EXT_bindable_uniform = has_ext("GL_EXT_bindable_uniform");
	GLAD_GL_EXT_blend_color = has_ext("GL_EXT_blend_color");
	GLAD_GL_EXT_blend_equation_separate = has_ext("GL_EXT_blend_equation_separate");
	GLAD_GL_EXT_blend_func_separate = has_ext("GL_EXT_blend_func_separate");
	GLAD_GL_EXT_blend_logic_op = has_ext("GL_EXT_blend_logic_op");
	GLAD_GL_EXT_blend_minmax = has_ext("GL_EXT_blend_minmax");
	GLAD_GL_EXT_blend_subtract = has_ext("GL_EXT_blend_subtract");
	GLAD_GL_EXT_clip_volume_hint = has_ext("GL_EXT_clip_volume_hint");
	GLAD_GL_EXT_cmyka = has_ext("GL_EXT_cmyka");
	GLAD_GL_EXT_color_subtable = has_ext("GL_EXT_color_subtable");
	GLAD_GL_EXT_compiled_vertex_array = has_ext("GL_EXT_compiled_vertex_array");
	GLAD_GL_EXT_convolution = has_ext("GL_EXT_convolution");
	GLAD_GL_EXT_coordinate_frame = has_ext("GL_EXT_coordinate_frame");
	GLAD_GL_EXT_copy_texture = has_ext("GL_EXT_copy_texture");
	GLAD_GL_EXT_cull_vertex = has_ext("GL_EXT_cull_vertex");
	GLAD_GL_EXT_debug_label = has_ext("GL_EXT_debug_label");
	GLAD_GL_EXT_debug_marker = has_ext("GL_EXT_debug_marker");
	GLAD_GL_EXT_depth_bounds_test = has_ext("GL_EXT_depth_bounds_test");
	GLAD_GL_EXT_direct_state_access = has_ext("GL_EXT_direct_state_access");
	GLAD_GL_EXT_draw_buffers2 = has_ext("GL_EXT_draw_buffers2");
	GLAD_GL_EXT_draw_instanced = has_ext("GL_EXT_draw_instanced");
	GLAD_GL_EXT_draw_range_elements = has_ext("GL_EXT_draw_range_elements");
	GLAD_GL_EXT_fog_coord = has_ext("GL_EXT_fog_coord");
	GLAD_GL_EXT_framebuffer_blit = has_ext("GL_EXT_framebuffer_blit");
	GLAD_GL_EXT_framebuffer_multisample = has_ext("GL_EXT_framebuffer_multisample");
	GLAD_GL_EXT_framebuffer_multisample_blit_scaled = has_ext("GL_EXT_framebuffer_multisample_blit_scaled");
	GLAD_GL_EXT_framebuffer_object = has_ext("GL_EXT_framebuffer_object");
	GLAD_GL_EXT_framebuffer_sRGB = has_ext("GL_EXT_framebuffer_sRGB");
	GLAD_GL_EXT_geometry_shader4 = has_ext("GL_EXT_geometry_shader4");
	GLAD_GL_EXT_gpu_program_parameters = has_ext("GL_EXT_gpu_program_parameters");
	GLAD_GL_EXT_gpu_shader4 = has_ext("GL_EXT_gpu_shader4");
	GLAD_GL_EXT_histogram = has_ext("GL_EXT_histogram");
	GLAD_GL_EXT_index_array_formats = has_ext("GL_EXT_index_array_formats");
	GLAD_GL_EXT_index_func = has_ext("GL_EXT_index_func");
	GLAD_GL_EXT_index_material = has_ext("GL_EXT_index_material");
	GLAD_GL_EXT_index_texture = has_ext("GL_EXT_index_texture");
	GLAD_GL_EXT_light_texture = has_ext("GL_EXT_light_texture");
	GLAD_GL_EXT_misc_attribute = has_ext("GL_EXT_misc_attribute");
	GLAD_GL_EXT_multi_draw_arrays = has_ext("GL_EXT_multi_draw_arrays");
	GLAD_GL_EXT_multisample = has_ext("GL_EXT_multisample");
	GLAD_GL_EXT_packed_depth_stencil = has_ext("GL_EXT_packed_depth_stencil");
	GLAD_GL_EXT_packed_float = has_ext("GL_EXT_packed_float");
	GLAD_GL_EXT_packed_pixels = has_ext("GL_EXT_packed_pixels");
	GLAD_GL_EXT_paletted_texture = has_ext("GL_EXT_paletted_texture");
	GLAD_GL_EXT_pixel_buffer_object = has_ext("GL_EXT_pixel_buffer_object");
	GLAD_GL_EXT_pixel_transform = has_ext("GL_EXT_pixel_transform");
	GLAD_GL_EXT_pixel_transform_color_table = has_ext("GL_EXT_pixel_transform_color_table");
	GLAD_GL_EXT_point_parameters = has_ext("GL_EXT_point_parameters");
	GLAD_GL_EXT_polygon_offset = has_ext("GL_EXT_polygon_offset");
	GLAD_GL_EXT_polygon_offset_clamp = has_ext("GL_EXT_polygon_offset_clamp");
	GLAD_GL_EXT_post_depth_coverage = has_ext("GL_EXT_post_depth_coverage");
	GLAD_GL_EXT_provoking_vertex = has_ext("GL_EXT_provoking_vertex");
	GLAD_GL_EXT_raster_multisample = has_ext("GL_EXT_raster_multisample");
	GLAD_GL_EXT_rescale_normal = has_ext("GL_EXT_rescale_normal");
	GLAD_GL_EXT_secondary_color = has_ext("GL_EXT_secondary_color");
	GLAD_GL_EXT_separate_shader_objects = has_ext("GL_EXT_separate_shader_objects");
	GLAD_GL_EXT_separate_specular_color = has_ext("GL_EXT_separate_specular_color");
	GLAD_GL_EXT_shader_image_load_formatted = has_ext("GL_EXT_shader_image_load_formatted");
	GLAD_GL_EXT_shader_image_load_store = has_ext("GL_EXT_shader_image_load_store");
	GLAD_GL_EXT_shader_integer_mix = has_ext("GL_EXT_shader_integer_mix");
	GLAD_GL_EXT_shadow_funcs = has_ext("GL_EXT_shadow_funcs");
	GLAD_GL_EXT_shared_texture_palette = has_ext("GL_EXT_shared_texture_palette");
	GLAD_GL_EXT_sparse_texture2 = has_ext("GL_EXT_sparse_texture2");
	GLAD_GL_EXT_stencil_clear_tag = has_ext("GL_EXT_stencil_clear_tag");
	GLAD_GL_EXT_stencil_two_side = has_ext("GL_EXT_stencil_two_side");
	GLAD_GL_EXT_stencil_wrap = has_ext("GL_EXT_stencil_wrap");
	GLAD_GL_EXT_subtexture = has_ext("GL_EXT_subtexture");
	GLAD_GL_EXT_texture = has_ext("GL_EXT_texture");
	GLAD_GL_EXT_texture3D = has_ext("GL_EXT_texture3D");
	GLAD_GL_EXT_texture_array = has_ext("GL_EXT_texture_array");
	GLAD_GL_EXT_texture_buffer_object = has_ext("GL_EXT_texture_buffer_object");
	GLAD_GL_EXT_texture_compression_latc = has_ext("GL_EXT_texture_compression_latc");
	GLAD_GL_EXT_texture_compression_rgtc = has_ext("GL_EXT_texture_compression_rgtc");
	GLAD_GL_EXT_texture_compression_s3tc = has_ext("GL_EXT_texture_compression_s3tc");
	GLAD_GL_EXT_texture_cube_map = has_ext("GL_EXT_texture_cube_map");
	GLAD_GL_EXT_texture_env_add = has_ext("GL_EXT_texture_env_add");
	GLAD_GL_EXT_texture_env_combine = has_ext("GL_EXT_texture_env_combine");
	GLAD_GL_EXT_texture_env_dot3 = has_ext("GL_EXT_texture_env_dot3");
	GLAD_GL_EXT_texture_filter_anisotropic = has_ext("GL_EXT_texture_filter_anisotropic");
	GLAD_GL_EXT_texture_filter_minmax = has_ext("GL_EXT_texture_filter_minmax");
	GLAD_GL_EXT_texture_integer = has_ext("GL_EXT_texture_integer");
	GLAD_GL_EXT_texture_lod_bias = has_ext("GL_EXT_texture_lod_bias");
	GLAD_GL_EXT_texture_mirror_clamp = has_ext("GL_EXT_texture_mirror_clamp");
	GLAD_GL_EXT_texture_object = has_ext("GL_EXT_texture_object");
	GLAD_GL_EXT_texture_perturb_normal = has_ext("GL_EXT_texture_perturb_normal");
	GLAD_GL_EXT_texture_sRGB = has_ext("GL_EXT_texture_sRGB");
	GLAD_GL_EXT_texture_sRGB_decode = has_ext("GL_EXT_texture_sRGB_decode");
	GLAD_GL_EXT_texture_shared_exponent = has_ext("GL_EXT_texture_shared_exponent");
	GLAD_GL_EXT_texture_snorm = has_ext("GL_EXT_texture_snorm");
	GLAD_GL_EXT_texture_swizzle = has_ext("GL_EXT_texture_swizzle");
	GLAD_GL_EXT_timer_query = has_ext("GL_EXT_timer_query");
	GLAD_GL_EXT_transform_feedback = has_ext("GL_EXT_transform_feedback");
	GLAD_GL_EXT_vertex_array = has_ext("GL_EXT_vertex_array");
	GLAD_GL_EXT_vertex_array_bgra = has_ext("GL_EXT_vertex_array_bgra");
	GLAD_GL_EXT_vertex_attrib_64bit = has_ext("GL_EXT_vertex_attrib_64bit");
	GLAD_GL_EXT_vertex_shader = has_ext("GL_EXT_vertex_shader");
	GLAD_GL_EXT_vertex_weighting = has_ext("GL_EXT_vertex_weighting");
	GLAD_GL_EXT_window_rectangles = has_ext("GL_EXT_window_rectangles");
	GLAD_GL_EXT_x11_sync_object = has_ext("GL_EXT_x11_sync_object");
	GLAD_GL_GREMEDY_frame_terminator = has_ext("GL_GREMEDY_frame_terminator");
	GLAD_GL_GREMEDY_string_marker = has_ext("GL_GREMEDY_string_marker");
	GLAD_GL_HP_convolution_border_modes = has_ext("GL_HP_convolution_border_modes");
	GLAD_GL_HP_image_transform = has_ext("GL_HP_image_transform");
	GLAD_GL_HP_occlusion_test = has_ext("GL_HP_occlusion_test");
	GLAD_GL_HP_texture_lighting = has_ext("GL_HP_texture_lighting");
	GLAD_GL_IBM_cull_vertex = has_ext("GL_IBM_cull_vertex");
	GLAD_GL_IBM_multimode_draw_arrays = has_ext("GL_IBM_multimode_draw_arrays");
	GLAD_GL_IBM_rasterpos_clip = has_ext("GL_IBM_rasterpos_clip");
	GLAD_GL_IBM_static_data = has_ext("GL_IBM_static_data");
	GLAD_GL_IBM_texture_mirrored_repeat = has_ext("GL_IBM_texture_mirrored_repeat");
	GLAD_GL_IBM_vertex_array_lists = has_ext("GL_IBM_vertex_array_lists");
	GLAD_GL_INGR_blend_func_separate = has_ext("GL_INGR_blend_func_separate");
	GLAD_GL_INGR_color_clamp = has_ext("GL_INGR_color_clamp");
	GLAD_GL_INGR_interlace_read = has_ext("GL_INGR_interlace_read");
	GLAD_GL_INTEL_conservative_rasterization = has_ext("GL_INTEL_conservative_rasterization");
	GLAD_GL_INTEL_fragment_shader_ordering = has_ext("GL_INTEL_fragment_shader_ordering");
	GLAD_GL_INTEL_framebuffer_CMAA = has_ext("GL_INTEL_framebuffer_CMAA");
	GLAD_GL_INTEL_map_texture = has_ext("GL_INTEL_map_texture");
	GLAD_GL_INTEL_parallel_arrays = has_ext("GL_INTEL_parallel_arrays");
	GLAD_GL_INTEL_performance_query = has_ext("GL_INTEL_performance_query");
	GLAD_GL_KHR_blend_equation_advanced = has_ext("GL_KHR_blend_equation_advanced");
	GLAD_GL_KHR_blend_equation_advanced_coherent = has_ext("GL_KHR_blend_equation_advanced_coherent");
	GLAD_GL_KHR_context_flush_control = has_ext("GL_KHR_context_flush_control");
	GLAD_GL_KHR_debug = has_ext("GL_KHR_debug");
	GLAD_GL_KHR_no_error = has_ext("GL_KHR_no_error");
	GLAD_GL_KHR_robust_buffer_access_behavior = has_ext("GL_KHR_robust_buffer_access_behavior");
	GLAD_GL_KHR_robustness = has_ext("GL_KHR_robustness");
	GLAD_GL_KHR_texture_compression_astc_hdr = has_ext("GL_KHR_texture_compression_astc_hdr");
	GLAD_GL_KHR_texture_compression_astc_ldr = has_ext("GL_KHR_texture_compression_astc_ldr");
	GLAD_GL_KHR_texture_compression_astc_sliced_3d = has_ext("GL_KHR_texture_compression_astc_sliced_3d");
	GLAD_GL_MESAX_texture_stack = has_ext("GL_MESAX_texture_stack");
	GLAD_GL_MESA_pack_invert = has_ext("GL_MESA_pack_invert");
	GLAD_GL_MESA_resize_buffers = has_ext("GL_MESA_resize_buffers");
	GLAD_GL_MESA_window_pos = has_ext("GL_MESA_window_pos");
	GLAD_GL_MESA_ycbcr_texture = has_ext("GL_MESA_ycbcr_texture");
	GLAD_GL_NVX_conditional_render = has_ext("GL_NVX_conditional_render");
	GLAD_GL_NVX_gpu_memory_info = has_ext("GL_NVX_gpu_memory_info");
	GLAD_GL_NV_bindless_multi_draw_indirect = has_ext("GL_NV_bindless_multi_draw_indirect");
	GLAD_GL_NV_bindless_multi_draw_indirect_count = has_ext("GL_NV_bindless_multi_draw_indirect_count");
	GLAD_GL_NV_bindless_texture = has_ext("GL_NV_bindless_texture");
	GLAD_GL_NV_blend_equation_advanced = has_ext("GL_NV_blend_equation_advanced");
	GLAD_GL_NV_blend_equation_advanced_coherent = has_ext("GL_NV_blend_equation_advanced_coherent");
	GLAD_GL_NV_blend_square = has_ext("GL_NV_blend_square");
	GLAD_GL_NV_clip_space_w_scaling = has_ext("GL_NV_clip_space_w_scaling");
	GLAD_GL_NV_command_list = has_ext("GL_NV_command_list");
	GLAD_GL_NV_compute_program5 = has_ext("GL_NV_compute_program5");
	GLAD_GL_NV_conditional_render = has_ext("GL_NV_conditional_render");
	GLAD_GL_NV_conservative_raster = has_ext("GL_NV_conservative_raster");
	GLAD_GL_NV_conservative_raster_dilate = has_ext("GL_NV_conservative_raster_dilate");
	GLAD_GL_NV_conservative_raster_pre_snap_triangles = has_ext("GL_NV_conservative_raster_pre_snap_triangles");
	GLAD_GL_NV_copy_depth_to_color = has_ext("GL_NV_copy_depth_to_color");
	GLAD_GL_NV_copy_image = has_ext("GL_NV_copy_image");
	GLAD_GL_NV_deep_texture3D = has_ext("GL_NV_deep_texture3D");
	GLAD_GL_NV_depth_buffer_float = has_ext("GL_NV_depth_buffer_float");
	GLAD_GL_NV_depth_clamp = has_ext("GL_NV_depth_clamp");
	GLAD_GL_NV_draw_texture = has_ext("GL_NV_draw_texture");
	GLAD_GL_NV_evaluators = has_ext("GL_NV_evaluators");
	GLAD_GL_NV_explicit_multisample = has_ext("GL_NV_explicit_multisample");
	GLAD_GL_NV_fence = has_ext("GL_NV_fence");
	GLAD_GL_NV_fill_rectangle = has_ext("GL_NV_fill_rectangle");
	GLAD_GL_NV_float_buffer = has_ext("GL_NV_float_buffer");
	GLAD_GL_NV_fog_distance = has_ext("GL_NV_fog_distance");
	GLAD_GL_NV_fragment_coverage_to_color = has_ext("GL_NV_fragment_coverage_to_color");
	GLAD_GL_NV_fragment_program = has_ext("GL_NV_fragment_program");
	GLAD_GL_NV_fragment_program2 = has_ext("GL_NV_fragment_program2");
	GLAD_GL_NV_fragment_program4 = has_ext("GL_NV_fragment_program4");
	GLAD_GL_NV_fragment_program_option = has_ext("GL_NV_fragment_program_option");
	GLAD_GL_NV_fragment_shader_interlock = has_ext("GL_NV_fragment_shader_interlock");
	GLAD_GL_NV_framebuffer_mixed_samples = has_ext("GL_NV_framebuffer_mixed_samples");
	GLAD_GL_NV_framebuffer_multisample_coverage = has_ext("GL_NV_framebuffer_multisample_coverage");
	GLAD_GL_NV_geometry_program4 = has_ext("GL_NV_geometry_program4");
	GLAD_GL_NV_geometry_shader4 = has_ext("GL_NV_geometry_shader4");
	GLAD_GL_NV_geometry_shader_passthrough = has_ext("GL_NV_geometry_shader_passthrough");
	GLAD_GL_NV_gpu_program4 = has_ext("GL_NV_gpu_program4");
	GLAD_GL_NV_gpu_program5 = has_ext("GL_NV_gpu_program5");
	GLAD_GL_NV_gpu_program5_mem_extended = has_ext("GL_NV_gpu_program5_mem_extended");
	GLAD_GL_NV_gpu_shader5 = has_ext("GL_NV_gpu_shader5");
	GLAD_GL_NV_half_float = has_ext("GL_NV_half_float");
	GLAD_GL_NV_internalformat_sample_query = has_ext("GL_NV_internalformat_sample_query");
	GLAD_GL_NV_light_max_exponent = has_ext("GL_NV_light_max_exponent");
	GLAD_GL_NV_multisample_coverage = has_ext("GL_NV_multisample_coverage");
	GLAD_GL_NV_multisample_filter_hint = has_ext("GL_NV_multisample_filter_hint");
	GLAD_GL_NV_occlusion_query = has_ext("GL_NV_occlusion_query");
	GLAD_GL_NV_packed_depth_stencil = has_ext("GL_NV_packed_depth_stencil");
	GLAD_GL_NV_parameter_buffer_object = has_ext("GL_NV_parameter_buffer_object");
	GLAD_GL_NV_parameter_buffer_object2 = has_ext("GL_NV_parameter_buffer_object2");
	GLAD_GL_NV_path_rendering = has_ext("GL_NV_path_rendering");
	GLAD_GL_NV_path_rendering_shared_edge = has_ext("GL_NV_path_rendering_shared_edge");
	GLAD_GL_NV_pixel_data_range = has_ext("GL_NV_pixel_data_range");
	GLAD_GL_NV_point_sprite = has_ext("GL_NV_point_sprite");
	GLAD_GL_NV_present_video = has_ext("GL_NV_present_video");
	GLAD_GL_NV_primitive_restart = has_ext("GL_NV_primitive_restart");
	GLAD_GL_NV_register_combiners = has_ext("GL_NV_register_combiners");
	GLAD_GL_NV_register_combiners2 = has_ext("GL_NV_register_combiners2");
	GLAD_GL_NV_robustness_video_memory_purge = has_ext("GL_NV_robustness_video_memory_purge");
	GLAD_GL_NV_sample_locations = has_ext("GL_NV_sample_locations");
	GLAD_GL_NV_sample_mask_override_coverage = has_ext("GL_NV_sample_mask_override_coverage");
	GLAD_GL_NV_shader_atomic_counters = has_ext("GL_NV_shader_atomic_counters");
	GLAD_GL_NV_shader_atomic_float = has_ext("GL_NV_shader_atomic_float");
	GLAD_GL_NV_shader_atomic_float64 = has_ext("GL_NV_shader_atomic_float64");
	GLAD_GL_NV_shader_atomic_fp16_vector = has_ext("GL_NV_shader_atomic_fp16_vector");
	GLAD_GL_NV_shader_atomic_int64 = has_ext("GL_NV_shader_atomic_int64");
	GLAD_GL_NV_shader_buffer_load = has_ext("GL_NV_shader_buffer_load");
	GLAD_GL_NV_shader_buffer_store = has_ext("GL_NV_shader_buffer_store");
	GLAD_GL_NV_shader_storage_buffer_object = has_ext("GL_NV_shader_storage_buffer_object");
	GLAD_GL_NV_shader_thread_group = has_ext("GL_NV_shader_thread_group");
	GLAD_GL_NV_shader_thread_shuffle = has_ext("GL_NV_shader_thread_shuffle");
	GLAD_GL_NV_stereo_view_rendering = has_ext("GL_NV_stereo_view_rendering");
	GLAD_GL_NV_tessellation_program5 = has_ext("GL_NV_tessellation_program5");
	GLAD_GL_NV_texgen_emboss = has_ext("GL_NV_texgen_emboss");
	GLAD_GL_NV_texgen_reflection = has_ext("GL_NV_texgen_reflection");
	GLAD_GL_NV_texture_barrier = has_ext("GL_NV_texture_barrier");
	GLAD_GL_NV_texture_compression_vtc = has_ext("GL_NV_texture_compression_vtc");
	GLAD_GL_NV_texture_env_combine4 = has_ext("GL_NV_texture_env_combine4");
	GLAD_GL_NV_texture_expand_normal = has_ext("GL_NV_texture_expand_normal");
	GLAD_GL_NV_texture_multisample = has_ext("GL_NV_texture_multisample");
	GLAD_GL_NV_texture_rectangle = has_ext("GL_NV_texture_rectangle");
	GLAD_GL_NV_texture_shader = has_ext("GL_NV_texture_shader");
	GLAD_GL_NV_texture_shader2 = has_ext("GL_NV_texture_shader2");
	GLAD_GL_NV_texture_shader3 = has_ext("GL_NV_texture_shader3");
	GLAD_GL_NV_transform_feedback = has_ext("GL_NV_transform_feedback");
	GLAD_GL_NV_transform_feedback2 = has_ext("GL_NV_transform_feedback2");
	GLAD_GL_NV_uniform_buffer_unified_memory = has_ext("GL_NV_uniform_buffer_unified_memory");
	GLAD_GL_NV_vdpau_interop = has_ext("GL_NV_vdpau_interop");
	GLAD_GL_NV_vertex_array_range = has_ext("GL_NV_vertex_array_range");
	GLAD_GL_NV_vertex_array_range2 = has_ext("GL_NV_vertex_array_range2");
	GLAD_GL_NV_vertex_attrib_integer_64bit = has_ext("GL_NV_vertex_attrib_integer_64bit");
	GLAD_GL_NV_vertex_buffer_unified_memory = has_ext("GL_NV_vertex_buffer_unified_memory");
	GLAD_GL_NV_vertex_program = has_ext("GL_NV_vertex_program");
	GLAD_GL_NV_vertex_program1_1 = has_ext("GL_NV_vertex_program1_1");
	GLAD_GL_NV_vertex_program2 = has_ext("GL_NV_vertex_program2");
	GLAD_GL_NV_vertex_program2_option = has_ext("GL_NV_vertex_program2_option");
	GLAD_GL_NV_vertex_program3 = has_ext("GL_NV_vertex_program3");
	GLAD_GL_NV_vertex_program4 = has_ext("GL_NV_vertex_program4");
	GLAD_GL_NV_video_capture = has_ext("GL_NV_video_capture");
	GLAD_GL_NV_viewport_array2 = has_ext("GL_NV_viewport_array2");
	GLAD_GL_NV_viewport_swizzle = has_ext("GL_NV_viewport_swizzle");
	GLAD_GL_OES_byte_coordinates = has_ext("GL_OES_byte_coordinates");
	GLAD_GL_OES_compressed_paletted_texture = has_ext("GL_OES_compressed_paletted_texture");
	GLAD_GL_OES_fixed_point = has_ext("GL_OES_fixed_point");
	GLAD_GL_OES_query_matrix = has_ext("GL_OES_query_matrix");
	GLAD_GL_OES_read_format = has_ext("GL_OES_read_format");
	GLAD_GL_OES_single_precision = has_ext("GL_OES_single_precision");
	GLAD_GL_OML_interlace = has_ext("GL_OML_interlace");
	GLAD_GL_OML_resample = has_ext("GL_OML_resample");
	GLAD_GL_OML_subsample = has_ext("GL_OML_subsample");
	GLAD_GL_OVR_multiview = has_ext("GL_OVR_multiview");
	GLAD_GL_OVR_multiview2 = has_ext("GL_OVR_multiview2");
	GLAD_GL_PGI_misc_hints = has_ext("GL_PGI_misc_hints");
	GLAD_GL_PGI_vertex_hints = has_ext("GL_PGI_vertex_hints");
	GLAD_GL_REND_screen_coordinates = has_ext("GL_REND_screen_coordinates");
	GLAD_GL_S3_s3tc = has_ext("GL_S3_s3tc");
	GLAD_GL_SGIS_detail_texture = has_ext("GL_SGIS_detail_texture");
	GLAD_GL_SGIS_fog_function = has_ext("GL_SGIS_fog_function");
	GLAD_GL_SGIS_generate_mipmap = has_ext("GL_SGIS_generate_mipmap");
	GLAD_GL_SGIS_multisample = has_ext("GL_SGIS_multisample");
	GLAD_GL_SGIS_pixel_texture = has_ext("GL_SGIS_pixel_texture");
	GLAD_GL_SGIS_point_line_texgen = has_ext("GL_SGIS_point_line_texgen");
	GLAD_GL_SGIS_point_parameters = has_ext("GL_SGIS_point_parameters");
	GLAD_GL_SGIS_sharpen_texture = has_ext("GL_SGIS_sharpen_texture");
	GLAD_GL_SGIS_texture4D = has_ext("GL_SGIS_texture4D");
	GLAD_GL_SGIS_texture_border_clamp = has_ext("GL_SGIS_texture_border_clamp");
	GLAD_GL_SGIS_texture_color_mask = has_ext("GL_SGIS_texture_color_mask");
	GLAD_GL_SGIS_texture_edge_clamp = has_ext("GL_SGIS_texture_edge_clamp");
	GLAD_GL_SGIS_texture_filter4 = has_ext("GL_SGIS_texture_filter4");
	GLAD_GL_SGIS_texture_lod = has_ext("GL_SGIS_texture_lod");
	GLAD_GL_SGIS_texture_select = has_ext("GL_SGIS_texture_select");
	GLAD_GL_SGIX_async = has_ext("GL_SGIX_async");
	GLAD_GL_SGIX_async_histogram = has_ext("GL_SGIX_async_histogram");
	GLAD_GL_SGIX_async_pixel = has_ext("GL_SGIX_async_pixel");
	GLAD_GL_SGIX_blend_alpha_minmax = has_ext("GL_SGIX_blend_alpha_minmax");
	GLAD_GL_SGIX_calligraphic_fragment = has_ext("GL_SGIX_calligraphic_fragment");
	GLAD_GL_SGIX_clipmap = has_ext("GL_SGIX_clipmap");
	GLAD_GL_SGIX_convolution_accuracy = has_ext("GL_SGIX_convolution_accuracy");
	GLAD_GL_SGIX_depth_pass_instrument = has_ext("GL_SGIX_depth_pass_instrument");
	GLAD_GL_SGIX_depth_texture = has_ext("GL_SGIX_depth_texture");
	GLAD_GL_SGIX_flush_raster = has_ext("GL_SGIX_flush_raster");
	GLAD_GL_SGIX_fog_offset = has_ext("GL_SGIX_fog_offset");
	GLAD_GL_SGIX_fragment_lighting = has_ext("GL_SGIX_fragment_lighting");
	GLAD_GL_SGIX_framezoom = has_ext("GL_SGIX_framezoom");
	GLAD_GL_SGIX_igloo_interface = has_ext("GL_SGIX_igloo_interface");
	GLAD_GL_SGIX_instruments = has_ext("GL_SGIX_instruments");
	GLAD_GL_SGIX_interlace = has_ext("GL_SGIX_interlace");
	GLAD_GL_SGIX_ir_instrument1 = has_ext("GL_SGIX_ir_instrument1");
	GLAD_GL_SGIX_list_priority = has_ext("GL_SGIX_list_priority");
	GLAD_GL_SGIX_pixel_texture = has_ext("GL_SGIX_pixel_texture");
	GLAD_GL_SGIX_pixel_tiles = has_ext("GL_SGIX_pixel_tiles");
	GLAD_GL_SGIX_polynomial_ffd = has_ext("GL_SGIX_polynomial_ffd");
	GLAD_GL_SGIX_reference_plane = has_ext("GL_SGIX_reference_plane");
	GLAD_GL_SGIX_resample = has_ext("GL_SGIX_resample");
	GLAD_GL_SGIX_scalebias_hint = has_ext("GL_SGIX_scalebias_hint");
	GLAD_GL_SGIX_shadow = has_ext("GL_SGIX_shadow");
	GLAD_GL_SGIX_shadow_ambient = has_ext("GL_SGIX_shadow_ambient");
	GLAD_GL_SGIX_sprite = has_ext("GL_SGIX_sprite");
	GLAD_GL_SGIX_subsample = has_ext("GL_SGIX_subsample");
	GLAD_GL_SGIX_tag_sample_buffer = has_ext("GL_SGIX_tag_sample_buffer");
	GLAD_GL_SGIX_texture_add_env = has_ext("GL_SGIX_texture_add_env");
	GLAD_GL_SGIX_texture_coordinate_clamp = has_ext("GL_SGIX_texture_coordinate_clamp");
	GLAD_GL_SGIX_texture_lod_bias = has_ext("GL_SGIX_texture_lod_bias");
	GLAD_GL_SGIX_texture_multi_buffer = has_ext("GL_SGIX_texture_multi_buffer");
	GLAD_GL_SGIX_texture_scale_bias = has_ext("GL_SGIX_texture_scale_bias");
	GLAD_GL_SGIX_vertex_preclip = has_ext("GL_SGIX_vertex_preclip");
	GLAD_GL_SGIX_ycrcb = has_ext("GL_SGIX_ycrcb");
	GLAD_GL_SGIX_ycrcb_subsample = has_ext("GL_SGIX_ycrcb_subsample");
	GLAD_GL_SGIX_ycrcba = has_ext("GL_SGIX_ycrcba");
	GLAD_GL_SGI_color_matrix = has_ext("GL_SGI_color_matrix");
	GLAD_GL_SGI_color_table = has_ext("GL_SGI_color_table");
	GLAD_GL_SGI_texture_color_table = has_ext("GL_SGI_texture_color_table");
	GLAD_GL_SUNX_constant_data = has_ext("GL_SUNX_constant_data");
	GLAD_GL_SUN_convolution_border_modes = has_ext("GL_SUN_convolution_border_modes");
	GLAD_GL_SUN_global_alpha = has_ext("GL_SUN_global_alpha");
	GLAD_GL_SUN_mesh_array = has_ext("GL_SUN_mesh_array");
	GLAD_GL_SUN_slice_accum = has_ext("GL_SUN_slice_accum");
	GLAD_GL_SUN_triangle_list = has_ext("GL_SUN_triangle_list");
	GLAD_GL_SUN_vertex = has_ext("GL_SUN_vertex");
	GLAD_GL_WIN_phong_shading = has_ext("GL_WIN_phong_shading");
	GLAD_GL_WIN_specular_fog = has_ext("GL_WIN_specular_fog");
	free_exts();
	return 1;
}

static void find_coreGL(void) {

    /* Thank you @elmindreda
     * https://github.com/elmindreda/greg/blob/master/templates/greg.c.in#L176
     * https://github.com/glfw/glfw/blob/master/src/context.c#L36
     */
    int i, major, minor;

    const char* version;
    const char* prefixes[] = {
        "OpenGL ES-CM ",
        "OpenGL ES-CL ",
        "OpenGL ES ",
        NULL
    };

    version = (const char*) glGetString(GL_VERSION);
    if (!version) return;

    for (i = 0;  prefixes[i];  i++) {
        const size_t length = strlen(prefixes[i]);
        if (strncmp(version, prefixes[i], length) == 0) {
            version += length;
            break;
        }
    }

/* PR #18 */
#ifdef _MSC_VER
    sscanf_s(version, "%d.%d", &major, &minor);
#else
    sscanf(version, "%d.%d", &major, &minor);
#endif

    GLVersion.major = major; GLVersion.minor = minor;
    max_loaded_major = major; max_loaded_minor = minor;
	GLAD_GL_VERSION_1_0 = (major == 1 && minor >= 0) || major > 1;
	GLAD_GL_VERSION_1_1 = (major == 1 && minor >= 1) || major > 1;
	GLAD_GL_VERSION_1_2 = (major == 1 && minor >= 2) || major > 1;
	GLAD_GL_VERSION_1_3 = (major == 1 && minor >= 3) || major > 1;
	GLAD_GL_VERSION_1_4 = (major == 1 && minor >= 4) || major > 1;
	GLAD_GL_VERSION_1_5 = (major == 1 && minor >= 5) || major > 1;
	GLAD_GL_VERSION_2_0 = (major == 2 && minor >= 0) || major > 2;
	GLAD_GL_VERSION_2_1 = (major == 2 && minor >= 1) || major > 2;
	GLAD_GL_VERSION_3_0 = (major == 3 && minor >= 0) || major > 3;
	GLAD_GL_VERSION_3_1 = (major == 3 && minor >= 1) || major > 3;
	GLAD_GL_VERSION_3_2 = (major == 3 && minor >= 2) || major > 3;
	GLAD_GL_VERSION_3_3 = (major == 3 && minor >= 3) || major > 3;
	GLAD_GL_VERSION_4_0 = (major == 4 && minor >= 0) || major > 4;
	GLAD_GL_VERSION_4_1 = (major == 4 && minor >= 1) || major > 4;
	GLAD_GL_VERSION_4_2 = (major == 4 && minor >= 2) || major > 4;
	GLAD_GL_VERSION_4_3 = (major == 4 && minor >= 3) || major > 4;
	GLAD_GL_VERSION_4_4 = (major == 4 && minor >= 4) || major > 4;
	GLAD_GL_VERSION_4_5 = (major == 4 && minor >= 5) || major > 4;
	if (GLVersion.major > 4 || (GLVersion.major >= 4 && GLVersion.minor >= 5)) {
		max_loaded_major = 4;
		max_loaded_minor = 5;
	}
}

int gladLoadGLLoader(GLADloadproc load) {
	GLVersion.major = 0; GLVersion.minor = 0;
	glGetString = (PFNGLGETSTRINGPROC)load("glGetString");
	if(glGetString == NULL) return 0;
	if(glGetString(GL_VERSION) == NULL) return 0;
	find_coreGL();
	load_GL_VERSION_1_0(load);
	load_GL_VERSION_1_1(load);
	load_GL_VERSION_1_2(load);
	load_GL_VERSION_1_3(load);
	load_GL_VERSION_1_4(load);
	load_GL_VERSION_1_5(load);
	load_GL_VERSION_2_0(load);
	load_GL_VERSION_2_1(load);
	load_GL_VERSION_3_0(load);
	load_GL_VERSION_3_1(load);
	load_GL_VERSION_3_2(load);
	load_GL_VERSION_3_3(load);
	load_GL_VERSION_4_0(load);
	load_GL_VERSION_4_1(load);
	load_GL_VERSION_4_2(load);
	load_GL_VERSION_4_3(load);
	load_GL_VERSION_4_4(load);
	load_GL_VERSION_4_5(load);

	if (!find_extensionsGL()) return 0;
	load_GL_3DFX_tbuffer(load);
	load_GL_AMD_debug_output(load);
	load_GL_AMD_draw_buffers_blend(load);
	load_GL_AMD_gpu_shader_int64(load);
	load_GL_AMD_interleaved_elements(load);
	load_GL_AMD_multi_draw_indirect(load);
	load_GL_AMD_name_gen_delete(load);
	load_GL_AMD_occlusion_query_event(load);
	load_GL_AMD_performance_monitor(load);
	load_GL_AMD_sample_positions(load);
	load_GL_AMD_sparse_texture(load);
	load_GL_AMD_stencil_operation_extended(load);
	load_GL_AMD_vertex_shader_tessellator(load);
	load_GL_APPLE_element_array(load);
	load_GL_APPLE_fence(load);
	load_GL_APPLE_flush_buffer_range(load);
	load_GL_APPLE_object_purgeable(load);
	load_GL_APPLE_texture_range(load);
	load_GL_APPLE_vertex_array_object(load);
	load_GL_APPLE_vertex_array_range(load);
	load_GL_APPLE_vertex_program_evaluators(load);
	load_GL_ARB_ES2_compatibility(load);
	load_GL_ARB_ES3_1_compatibility(load);
	load_GL_ARB_ES3_2_compatibility(load);
	load_GL_ARB_base_instance(load);
	load_GL_ARB_bindless_texture(load);
	load_GL_ARB_blend_func_extended(load);
	load_GL_ARB_buffer_storage(load);
	load_GL_ARB_cl_event(load);
	load_GL_ARB_clear_buffer_object(load);
	load_GL_ARB_clear_texture(load);
	load_GL_ARB_clip_control(load);
	load_GL_ARB_color_buffer_float(load);
	load_GL_ARB_compute_shader(load);
	load_GL_ARB_compute_variable_group_size(load);
	load_GL_ARB_copy_buffer(load);
	load_GL_ARB_copy_image(load);
	load_GL_ARB_debug_output(load);
	load_GL_ARB_direct_state_access(load);
	load_GL_ARB_draw_buffers(load);
	load_GL_ARB_draw_buffers_blend(load);
	load_GL_ARB_draw_elements_base_vertex(load);
	load_GL_ARB_draw_indirect(load);
	load_GL_ARB_draw_instanced(load);
	load_GL_ARB_fragment_program(load);
	load_GL_ARB_framebuffer_no_attachments(load);
	load_GL_ARB_framebuffer_object(load);
	load_GL_ARB_geometry_shader4(load);
	load_GL_ARB_get_program_binary(load);
	load_GL_ARB_get_texture_sub_image(load);
	load_GL_ARB_gpu_shader_fp64(load);
	load_GL_ARB_gpu_shader_int64(load);
	load_GL_ARB_imaging(load);
	load_GL_ARB_indirect_parameters(load);
	load_GL_ARB_instanced_arrays(load);
	load_GL_ARB_internalformat_query(load);
	load_GL_ARB_internalformat_query2(load);
	load_GL_ARB_invalidate_subdata(load);
	load_GL_ARB_map_buffer_range(load);
	load_GL_ARB_matrix_palette(load);
	load_GL_ARB_multi_bind(load);
	load_GL_ARB_multi_draw_indirect(load);
	load_GL_ARB_multisample(load);
	load_GL_ARB_multitexture(load);
	load_GL_ARB_occlusion_query(load);
	load_GL_ARB_parallel_shader_compile(load);
	load_GL_ARB_point_parameters(load);
	load_GL_ARB_program_interface_query(load);
	load_GL_ARB_provoking_vertex(load);
	load_GL_ARB_robustness(load);
	load_GL_ARB_sample_locations(load);
	load_GL_ARB_sample_shading(load);
	load_GL_ARB_sampler_objects(load);
	load_GL_ARB_separate_shader_objects(load);
	load_GL_ARB_shader_atomic_counters(load);
	load_GL_ARB_shader_image_load_store(load);
	load_GL_ARB_shader_objects(load);
	load_GL_ARB_shader_storage_buffer_object(load);
	load_GL_ARB_shader_subroutine(load);
	load_GL_ARB_shading_language_include(load);
	load_GL_ARB_sparse_buffer(load);
	load_GL_ARB_sparse_texture(load);
	load_GL_ARB_sync(load);
	load_GL_ARB_tessellation_shader(load);
	load_GL_ARB_texture_barrier(load);
	load_GL_ARB_texture_buffer_object(load);
	load_GL_ARB_texture_buffer_range(load);
	load_GL_ARB_texture_compression(load);
	load_GL_ARB_texture_multisample(load);
	load_GL_ARB_texture_storage(load);
	load_GL_ARB_texture_storage_multisample(load);
	load_GL_ARB_texture_view(load);
	load_GL_ARB_timer_query(load);
	load_GL_ARB_transform_feedback2(load);
	load_GL_ARB_transform_feedback3(load);
	load_GL_ARB_transform_feedback_instanced(load);
	load_GL_ARB_transpose_matrix(load);
	load_GL_ARB_uniform_buffer_object(load);
	load_GL_ARB_vertex_array_object(load);
	load_GL_ARB_vertex_attrib_64bit(load);
	load_GL_ARB_vertex_attrib_binding(load);
	load_GL_ARB_vertex_blend(load);
	load_GL_ARB_vertex_buffer_object(load);
	load_GL_ARB_vertex_program(load);
	load_GL_ARB_vertex_shader(load);
	load_GL_ARB_vertex_type_2_10_10_10_rev(load);
	load_GL_ARB_viewport_array(load);
	load_GL_ARB_window_pos(load);
	load_GL_ATI_draw_buffers(load);
	load_GL_ATI_element_array(load);
	load_GL_ATI_envmap_bumpmap(load);
	load_GL_ATI_fragment_shader(load);
	load_GL_ATI_map_object_buffer(load);
	load_GL_ATI_pn_triangles(load);
	load_GL_ATI_separate_stencil(load);
	load_GL_ATI_vertex_array_object(load);
	load_GL_ATI_vertex_attrib_array_object(load);
	load_GL_ATI_vertex_streams(load);
	load_GL_EXT_bindable_uniform(load);
	load_GL_EXT_blend_color(load);
	load_GL_EXT_blend_equation_separate(load);
	load_GL_EXT_blend_func_separate(load);
	load_GL_EXT_blend_minmax(load);
	load_GL_EXT_color_subtable(load);
	load_GL_EXT_compiled_vertex_array(load);
	load_GL_EXT_convolution(load);
	load_GL_EXT_coordinate_frame(load);
	load_GL_EXT_copy_texture(load);
	load_GL_EXT_cull_vertex(load);
	load_GL_EXT_debug_label(load);
	load_GL_EXT_debug_marker(load);
	load_GL_EXT_depth_bounds_test(load);
	load_GL_EXT_direct_state_access(load);
	load_GL_EXT_draw_buffers2(load);
	load_GL_EXT_draw_instanced(load);
	load_GL_EXT_draw_range_elements(load);
	load_GL_EXT_fog_coord(load);
	load_GL_EXT_framebuffer_blit(load);
	load_GL_EXT_framebuffer_multisample(load);
	load_GL_EXT_framebuffer_object(load);
	load_GL_EXT_geometry_shader4(load);
	load_GL_EXT_gpu_program_parameters(load);
	load_GL_EXT_gpu_shader4(load);
	load_GL_EXT_histogram(load);
	load_GL_EXT_index_func(load);
	load_GL_EXT_index_material(load);
	load_GL_EXT_light_texture(load);
	load_GL_EXT_multi_draw_arrays(load);
	load_GL_EXT_multisample(load);
	load_GL_EXT_paletted_texture(load);
	load_GL_EXT_pixel_transform(load);
	load_GL_EXT_point_parameters(load);
	load_GL_EXT_polygon_offset(load);
	load_GL_EXT_polygon_offset_clamp(load);
	load_GL_EXT_provoking_vertex(load);
	load_GL_EXT_raster_multisample(load);
	load_GL_EXT_secondary_color(load);
	load_GL_EXT_separate_shader_objects(load);
	load_GL_EXT_shader_image_load_store(load);
	load_GL_EXT_stencil_clear_tag(load);
	load_GL_EXT_stencil_two_side(load);
	load_GL_EXT_subtexture(load);
	load_GL_EXT_texture3D(load);
	load_GL_EXT_texture_array(load);
	load_GL_EXT_texture_buffer_object(load);
	load_GL_EXT_texture_filter_minmax(load);
	load_GL_EXT_texture_integer(load);
	load_GL_EXT_texture_object(load);
	load_GL_EXT_texture_perturb_normal(load);
	load_GL_EXT_timer_query(load);
	load_GL_EXT_transform_feedback(load);
	load_GL_EXT_vertex_array(load);
	load_GL_EXT_vertex_attrib_64bit(load);
	load_GL_EXT_vertex_shader(load);
	load_GL_EXT_vertex_weighting(load);
	load_GL_EXT_window_rectangles(load);
	load_GL_EXT_x11_sync_object(load);
	load_GL_GREMEDY_frame_terminator(load);
	load_GL_GREMEDY_string_marker(load);
	load_GL_HP_image_transform(load);
	load_GL_IBM_multimode_draw_arrays(load);
	load_GL_IBM_static_data(load);
	load_GL_IBM_vertex_array_lists(load);
	load_GL_INGR_blend_func_separate(load);
	load_GL_INTEL_framebuffer_CMAA(load);
	load_GL_INTEL_map_texture(load);
	load_GL_INTEL_parallel_arrays(load);
	load_GL_INTEL_performance_query(load);
	load_GL_KHR_blend_equation_advanced(load);
	load_GL_KHR_debug(load);
	load_GL_KHR_robustness(load);
	load_GL_MESA_resize_buffers(load);
	load_GL_MESA_window_pos(load);
	load_GL_NVX_conditional_render(load);
	load_GL_NV_bindless_multi_draw_indirect(load);
	load_GL_NV_bindless_multi_draw_indirect_count(load);
	load_GL_NV_bindless_texture(load);
	load_GL_NV_blend_equation_advanced(load);
	load_GL_NV_clip_space_w_scaling(load);
	load_GL_NV_command_list(load);
	load_GL_NV_conditional_render(load);
	load_GL_NV_conservative_raster(load);
	load_GL_NV_conservative_raster_dilate(load);
	load_GL_NV_conservative_raster_pre_snap_triangles(load);
	load_GL_NV_copy_image(load);
	load_GL_NV_depth_buffer_float(load);
	load_GL_NV_draw_texture(load);
	load_GL_NV_evaluators(load);
	load_GL_NV_explicit_multisample(load);
	load_GL_NV_fence(load);
	load_GL_NV_fragment_coverage_to_color(load);
	load_GL_NV_fragment_program(load);
	load_GL_NV_framebuffer_mixed_samples(load);
	load_GL_NV_framebuffer_multisample_coverage(load);
	load_GL_NV_geometry_program4(load);
	load_GL_NV_gpu_program4(load);
	load_GL_NV_gpu_program5(load);
	load_GL_NV_gpu_shader5(load);
	load_GL_NV_half_float(load);
	load_GL_NV_internalformat_sample_query(load);
	load_GL_NV_occlusion_query(load);
	load_GL_NV_parameter_buffer_object(load);
	load_GL_NV_path_rendering(load);
	load_GL_NV_pixel_data_range(load);
	load_GL_NV_point_sprite(load);
	load_GL_NV_present_video(load);
	load_GL_NV_primitive_restart(load);
	load_GL_NV_register_combiners(load);
	load_GL_NV_register_combiners2(load);
	load_GL_NV_sample_locations(load);
	load_GL_NV_shader_buffer_load(load);
	load_GL_NV_texture_barrier(load);
	load_GL_NV_texture_multisample(load);
	load_GL_NV_transform_feedback(load);
	load_GL_NV_transform_feedback2(load);
	load_GL_NV_vdpau_interop(load);
	load_GL_NV_vertex_array_range(load);
	load_GL_NV_vertex_attrib_integer_64bit(load);
	load_GL_NV_vertex_buffer_unified_memory(load);
	load_GL_NV_vertex_program(load);
	load_GL_NV_vertex_program4(load);
	load_GL_NV_video_capture(load);
	load_GL_NV_viewport_swizzle(load);
	load_GL_OES_byte_coordinates(load);
	load_GL_OES_fixed_point(load);
	load_GL_OES_query_matrix(load);
	load_GL_OES_single_precision(load);
	load_GL_OVR_multiview(load);
	load_GL_PGI_misc_hints(load);
	load_GL_SGIS_detail_texture(load);
	load_GL_SGIS_fog_function(load);
	load_GL_SGIS_multisample(load);
	load_GL_SGIS_pixel_texture(load);
	load_GL_SGIS_point_parameters(load);
	load_GL_SGIS_sharpen_texture(load);
	load_GL_SGIS_texture4D(load);
	load_GL_SGIS_texture_color_mask(load);
	load_GL_SGIS_texture_filter4(load);
	load_GL_SGIX_async(load);
	load_GL_SGIX_flush_raster(load);
	load_GL_SGIX_fragment_lighting(load);
	load_GL_SGIX_framezoom(load);
	load_GL_SGIX_igloo_interface(load);
	load_GL_SGIX_instruments(load);
	load_GL_SGIX_list_priority(load);
	load_GL_SGIX_pixel_texture(load);
	load_GL_SGIX_polynomial_ffd(load);
	load_GL_SGIX_reference_plane(load);
	load_GL_SGIX_sprite(load);
	load_GL_SGIX_tag_sample_buffer(load);
	load_GL_SGI_color_table(load);
	load_GL_SUNX_constant_data(load);
	load_GL_SUN_global_alpha(load);
	load_GL_SUN_mesh_array(load);
	load_GL_SUN_triangle_list(load);
	load_GL_SUN_vertex(load);
	return GLVersion.major != 0 || GLVersion.minor != 0;
}

