# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


## Quick Filter Bar

# The tooltip to display when the user hovers over the sticky button
# (currently displayed as a push-pin). When active, the sticky button
# causes the current filter settings to be retained when the user changes
# folders or opens new tabs. (When inactive, only the state of the text
# filters are propagated between folder changes and when opening new tabs.)
quick-filter-bar-sticky =
    .title = Задржи примену филтера приликом мењања између фасцикли
# The tooltip for the filter button that causes us to filter results to only
# include unread messages.
quick-filter-bar-unread =
    .title = Прикажи само непрочитане поруке
# The label for the filter button that causes us to filter results to only
# include unread messages.
quick-filter-bar-unread-label = Непрочитано
# The tooltip for the filter button that causes us to filter results to only
# include messages that have been starred/flagged.
quick-filter-bar-starred =
    .title = Прикажи само поруке са звездицом
# The label for the filter button that causes us to filter results to only
# include messages that have been starred/flagged.
quick-filter-bar-starred-label = Са звездицом
# The tooltip for the filter button that causes us to filter results to only
# include messages from contacts in one of the user's non-remote address
# books.
quick-filter-bar-inaddrbook =
    .title = Прикажи само поруке од особа из вашег именика
# The label for the filter button that causes us to filter results to only
# include messages from contacts in one of the user's non-remote address
# books.
quick-filter-bar-inaddrbook-label = Контакт
# The tooltip for the filter button that causes us to filter results to only
# include messages with at least one tag on them.
quick-filter-bar-tags =
    .title = Прикажи само поруке са ознакама на себи
# The label for the filter button that causes us to filter results to only
# include messages with at least one tag on them.
quick-filter-bar-tags-label = Ознаке
# The tooltip for the filter button that causes us to filter results to only
# include messages with attachments.
quick-filter-bar-attachment =
    .title = Прикажи само поруке са прилозима
# The label for the filter button that causes us to filter results to only
# include messages with attachments.
quick-filter-bar-attachment-label = Прилог
# The contents of the results box when there is a filter active but there
# are no messages matching the filter.
quick-filter-bar-no-results = Нема резултата
# This is used to populate the results box; it either displays the
# number of messages found using this string, that there are no messages
# (using quick-filter-bar-no-results), or the box is hidden.
# Variables:
# $count (Number) - The number of messages that match selected filters.
quick-filter-bar-results =
    { $count ->
        [one] { $count } порука
        [few] { $count } порука
       *[other] { $count } порука
    }
# Keyboard shortcut for the text search box.
# This should match quick-filter-bar-show in messenger.ftl.
quick-filter-bar-textbox-shortcut =
    { PLATFORM() ->
        [macos] ⇧ ⌘ K
       *[other] Ctrl+Shift+K
    }
# This is the empty text for the text search box.
# The goal is to convey to the user that typing in the box will filter
# the messages and that there is a hotkey they can press to get to the
# box faster.
quick-filter-bar-textbox =
    .placeholder = Филтрирај ове поруке <{ quick-filter-bar-textbox-shortcut }>
# Tooltip of the Any-of/All-of tagging mode selector.
quick-filter-bar-boolean-mode =
    .title = Режим филтрирања ознака
# The Any-of tagging mode.
quick-filter-bar-boolean-mode-any =
    .label = Било шта од
    .title = Барем један од услова изабраних ознака треба да се испуни
# The All-of tagging mode.
quick-filter-bar-boolean-mode-all =
    .label = Све од
    .title = Сви од услова изабраних ознака треба да се испуне
# This label explains what the sender/recipients/subject/body buttons do.
# This string should ideally be kept short because the label and the text
# filter buttons share their bar (that appears when there is text in the text
# filter box) with the list of tags when the tag filter is active, and the
# tag sub-bar wants as much space as possible. (Overflow is handled by an
# arrow scroll box.)
quick-filter-bar-text-filter-explanation = Филтрирај поруке по:
# The button label that toggles whether the text filter searches the message
# sender for the string.
quick-filter-bar-text-filter-sender = Пошиљаоцу
# The button label that toggles whether the text filter searches the message
# recipients (to, cc) for the string.
quick-filter-bar-text-filter-recipients = Примаоцима
# The button label that toggles whether the text filter searches the message
# subject for the string.
quick-filter-bar-text-filter-subject = Тема
# The button label that toggles whether the text filter searches the message
# body for the string.
quick-filter-bar-text-filter-body = Телу
# The first line of the panel popup that tells the user we found no matches
# but we can convert to a global search for them.
quick-filter-bar-gloda-upsell-line1 = Настави претраживање по свим фасциклама
# The second line of the panel popup that tells the user we found no matches.
# Variables:
# $text (String) - What the user has typed so far.
quick-filter-bar-gloda-upsell-line2 = Притисните још једном „Ентер“ да бисте наставили вашу претрагу за: { $text }

## Message thread pane

threadpane-column-header-select =
    .title = Изаберите/поништите све поруке
threadpane-column-label-select =
    .label = Одаберите поруке
threadpane-column-label-thread =
    .label = Нит
threadpane-column-header-flagged =
    .title = Поређај по звездици
threadpane-column-label-flagged =
    .label = Са звездицом
threadpane-column-header-attachments =
    .title = Поређај по прилозима
threadpane-column-label-attachments =
    .label = Прилози
threadpane-column-header-sender = Шаље
    .title = Поређај по пошиљаоцу
threadpane-column-label-sender =
    .label = Шаље
threadpane-column-header-recipient = Прималац
    .title = Поређај по примаоцу
threadpane-column-label-recipient =
    .label = Прималац
threadpane-column-header-correspondents = Дописници
    .title = Поређај по дописницима
threadpane-column-label-correspondents =
    .label = Дописници
threadpane-column-header-subject = Наслов
    .title = Поређај по наслову
threadpane-column-label-subject =
    .label = Наслов
threadpane-column-header-date = Датум
    .title = Поређај по датуму
threadpane-column-label-date =
    .label = Датум
threadpane-column-header-received = Примљено
    .title = Поређај по датуму пријема
threadpane-column-label-received =
    .label = Примљено
threadpane-column-header-status = Стање
    .title = Поређај на основу стања
threadpane-column-label-status =
    .label = Стање
threadpane-column-header-size = Величина
    .title = Поређај по величини
threadpane-column-label-size =
    .label = Величина
threadpane-column-header-tags = Ознака
    .title = Поређај по ознакама
threadpane-column-label-tags =
    .label = Ознака
threadpane-column-header-account = Налог
    .title = Поређај по налогу
threadpane-column-label-account =
    .label = Налог
threadpane-column-header-priority = Првенство
    .title = Поређај по првенству
threadpane-column-label-priority =
    .label = Првенство
threadpane-column-header-unread = Непрочитано
    .title = Број непрочитаних порука у овој нити
threadpane-column-label-unread =
    .label = Непрочитано
threadpane-column-header-total = Укупно
    .title = Укупан број порука у овој нити
threadpane-column-label-total =
    .label = Укупно
threadpane-column-header-location = Локација
    .title = Поређај по месту
threadpane-column-label-location =
    .label = Локација
threadpane-column-header-id = Редослед пријема
    .title = Поређај по редоследу пријема
threadpane-column-label-id =
    .label = Редослед пријема
threadpane-column-header-delete =
    .title = Обриши поруку
threadpane-column-label-delete =
    .label = Обриши

## Message state variations

apply-columns-to-menu =
    .label = Примени колоне на…
apply-current-view-to-folder =
    .label = Фасциклу…
apply-current-view-to-folder-children =
    .label = Фасциклу и њен садржај…

## Apply columns confirmation dialog

# Variables:
#  $name (String): The name of the folder to apply to.
apply-current-columns-to-folder-message = Применити колоне тренутне фасцикле на { $name }?
# Variables:
#  $name (String): The name of the folder to apply to.
apply-current-columns-to-folder-with-children-message = Применити колоне тренутне фасцикле на { $name } и њену децу?
