# This file is part of Desktop App Toolkit,
# a set of libraries for developing nice desktop applications.
#
# For license and copyright information please follow this link:
# https://github.com/desktop-app/legal/blob/master/LEGAL

function(nice_target_sources target_name src_loc)
    set(list ${ARGV})
    list(REMOVE_AT list 0 1)

    set(writing_now "")
    set(private_sources "")
    set(public_sources "")
    set(interface_sources "")
    set(not_win_sources "")
    set(not_mac_sources "")
    set(not_linux_sources "")
    foreach (entry ${list})
        if (${entry} STREQUAL "PRIVATE" OR ${entry} STREQUAL "PUBLIC" OR ${entry} STREQUAL "INTERFACE")
            set(writing_now ${entry})
        else()
            set(full_name ${src_loc}/${entry})
            if (${entry} MATCHES "(^|/)win/" OR ${entry} MATCHES "(^|/)winrc/" OR ${entry} MATCHES "(^|/)windows/" OR ${entry} MATCHES "[_\\/]win\\.")
                list(APPEND not_mac_sources ${full_name})
                list(APPEND not_linux_sources ${full_name})
            elseif (${entry} MATCHES "(^|/)mac/" OR ${entry} MATCHES "(^|/)darwin/" OR ${entry} MATCHES "(^|/)osx/" OR ${entry} MATCHES "[_\\/]mac\\." OR ${entry} MATCHES "[_\\/]darwin\\." OR ${entry} MATCHES "[_\\/]osx\\.")
                list(APPEND not_win_sources ${full_name})
                list(APPEND not_linux_sources ${full_name})
            elseif (${entry} MATCHES "(^|/)linux/" OR ${entry} MATCHES "[_\\/]linux\\.")
                list(APPEND not_win_sources ${full_name})
                list(APPEND not_mac_sources ${full_name})
            elseif (${entry} MATCHES "(^|/)posix/" OR ${entry} MATCHES "[_\\/]posix\\.")
                list(APPEND not_win_sources ${full_name})
            endif()
            if ("${writing_now}" STREQUAL "PRIVATE")
                list(APPEND private_sources ${full_name})
            elseif ("${writing_now}" STREQUAL "PUBLIC")
                list(APPEND public_sources ${full_name})
            elseif ("${writing_now}" STREQUAL "INTERFACE")
                list(APPEND interface_sources ${full_name})
            else()
                message(FATAL_ERROR "Unknown sources scope for target ${target_name}")
            endif()
            if (${src_loc} MATCHES "/Resources$")
                source_group(TREE ${src_loc} PREFIX Resources FILES ${full_name})
            else()
                source_group(TREE ${src_loc} PREFIX Sources FILES ${full_name})
            endif()
        endif()
    endforeach()

    if (NOT "${public_sources}" STREQUAL "")
        target_sources(${target_name} PUBLIC ${public_sources})
    endif()
    if (NOT "${private_sources}" STREQUAL "")
        target_sources(${target_name} PRIVATE ${private_sources})
    endif()
    if (NOT "${interface_sources}" STREQUAL "")
        target_sources(${target_name} INTERFACE ${interface_sources})
    endif()
    if (WIN32)
        set_source_files_properties(${not_win_sources} PROPERTIES HEADER_FILE_ONLY TRUE)
        set_source_files_properties(${not_win_sources} PROPERTIES SKIP_AUTOGEN TRUE)
    elseif (APPLE)
        set_source_files_properties(${not_mac_sources} PROPERTIES HEADER_FILE_ONLY TRUE)
        set_source_files_properties(${not_mac_sources} PROPERTIES SKIP_AUTOGEN TRUE)
    elseif (LINUX)
        set_source_files_properties(${not_linux_sources} PROPERTIES HEADER_FILE_ONLY TRUE)
        set_source_files_properties(${not_linux_sources} PROPERTIES SKIP_AUTOGEN TRUE)
    endif()
endfunction()
