/* GUI_DirectoryWidget.h */

/* Copyright (C) 2011-2017  Lucio Carreras
 *
 * This file is part of sayonara player
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GUI_DIRECTORYWIDGET_H
#define GUI_DIRECTORYWIDGET_H

#include "GUI/Helper/SayonaraWidget/SayonaraWidget.h"
#include "GUI/InfoDialog/InfoDialogContainer.h"
#include "Helper/MetaData/MetaDataFwd.h"
#include "Helper/Pimpl.h"

class QComboBox;
namespace Ui { class GUI_DirectoryWidget; }

class GUI_DirectoryWidget :
		public SayonaraWidget,
		public InfoDialogContainer

{
	Q_OBJECT

public:
	explicit GUI_DirectoryWidget(QWidget *parent = 0);
	virtual ~GUI_DirectoryWidget();

	QComboBox*	get_libchooser();
	void init();


private:
	PIMPL(GUI_DirectoryWidget)
	Ui::GUI_DirectoryWidget* ui=nullptr;

private:

	void showEvent(QShowEvent* e) override;
	void init_shortcuts();


private slots:
	void search_button_clicked();
	void search_term_changed(const QString& term);
	void directory_loaded(const QString& path);
	void init_dir_view();
	void dir_clicked(QModelIndex idx);
	void dir_pressed(QModelIndex idx);
	void file_dbl_clicked(QModelIndex idx);
	void file_pressed(QModelIndex idx);

	void dir_append_clicked();
	void dir_play_next_clicked();
	void dir_delete_clicked();

	void file_append_clicked();
	void file_play_next_clicked();
	void file_delete_clicked();
	void language_changed() override;

	// InfoDialogContainer interface
protected:
	MD::Interpretation get_metadata_interpretation() const override;
	MetaDataList get_data_for_info_dialog() const override;
};

#endif // GUI_DIRECTORYWIDGET_H
