// Copyright 2015 Google Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

//! Expansions of HTML5 entities

// Autogenerated by mk_entities.py

const ENTITIES: [(&[u8], &str); 2125] = [
        (b"AElig", "\u{00C6}"),
        (b"AMP", "\u{0026}"),
        (b"Aacute", "\u{00C1}"),
        (b"Abreve", "\u{0102}"),
        (b"Acirc", "\u{00C2}"),
        (b"Acy", "\u{0410}"),
        (b"Afr", "\u{1D504}"),
        (b"Agrave", "\u{00C0}"),
        (b"Alpha", "\u{0391}"),
        (b"Amacr", "\u{0100}"),
        (b"And", "\u{2A53}"),
        (b"Aogon", "\u{0104}"),
        (b"Aopf", "\u{1D538}"),
        (b"ApplyFunction", "\u{2061}"),
        (b"Aring", "\u{00C5}"),
        (b"Ascr", "\u{1D49C}"),
        (b"Assign", "\u{2254}"),
        (b"Atilde", "\u{00C3}"),
        (b"Auml", "\u{00C4}"),
        (b"Backslash", "\u{2216}"),
        (b"Barv", "\u{2AE7}"),
        (b"Barwed", "\u{2306}"),
        (b"Bcy", "\u{0411}"),
        (b"Because", "\u{2235}"),
        (b"Bernoullis", "\u{212C}"),
        (b"Beta", "\u{0392}"),
        (b"Bfr", "\u{1D505}"),
        (b"Bopf", "\u{1D539}"),
        (b"Breve", "\u{02D8}"),
        (b"Bscr", "\u{212C}"),
        (b"Bumpeq", "\u{224E}"),
        (b"CHcy", "\u{0427}"),
        (b"COPY", "\u{00A9}"),
        (b"Cacute", "\u{0106}"),
        (b"Cap", "\u{22D2}"),
        (b"CapitalDifferentialD", "\u{2145}"),
        (b"Cayleys", "\u{212D}"),
        (b"Ccaron", "\u{010C}"),
        (b"Ccedil", "\u{00C7}"),
        (b"Ccirc", "\u{0108}"),
        (b"Cconint", "\u{2230}"),
        (b"Cdot", "\u{010A}"),
        (b"Cedilla", "\u{00B8}"),
        (b"CenterDot", "\u{00B7}"),
        (b"Cfr", "\u{212D}"),
        (b"Chi", "\u{03A7}"),
        (b"CircleDot", "\u{2299}"),
        (b"CircleMinus", "\u{2296}"),
        (b"CirclePlus", "\u{2295}"),
        (b"CircleTimes", "\u{2297}"),
        (b"ClockwiseContourIntegral", "\u{2232}"),
        (b"CloseCurlyDoubleQuote", "\u{201D}"),
        (b"CloseCurlyQuote", "\u{2019}"),
        (b"Colon", "\u{2237}"),
        (b"Colone", "\u{2A74}"),
        (b"Congruent", "\u{2261}"),
        (b"Conint", "\u{222F}"),
        (b"ContourIntegral", "\u{222E}"),
        (b"Copf", "\u{2102}"),
        (b"Coproduct", "\u{2210}"),
        (b"CounterClockwiseContourIntegral", "\u{2233}"),
        (b"Cross", "\u{2A2F}"),
        (b"Cscr", "\u{1D49E}"),
        (b"Cup", "\u{22D3}"),
        (b"CupCap", "\u{224D}"),
        (b"DD", "\u{2145}"),
        (b"DDotrahd", "\u{2911}"),
        (b"DJcy", "\u{0402}"),
        (b"DScy", "\u{0405}"),
        (b"DZcy", "\u{040F}"),
        (b"Dagger", "\u{2021}"),
        (b"Darr", "\u{21A1}"),
        (b"Dashv", "\u{2AE4}"),
        (b"Dcaron", "\u{010E}"),
        (b"Dcy", "\u{0414}"),
        (b"Del", "\u{2207}"),
        (b"Delta", "\u{0394}"),
        (b"Dfr", "\u{1D507}"),
        (b"DiacriticalAcute", "\u{00B4}"),
        (b"DiacriticalDot", "\u{02D9}"),
        (b"DiacriticalDoubleAcute", "\u{02DD}"),
        (b"DiacriticalGrave", "\u{0060}"),
        (b"DiacriticalTilde", "\u{02DC}"),
        (b"Diamond", "\u{22C4}"),
        (b"DifferentialD", "\u{2146}"),
        (b"Dopf", "\u{1D53B}"),
        (b"Dot", "\u{00A8}"),
        (b"DotDot", "\u{20DC}"),
        (b"DotEqual", "\u{2250}"),
        (b"DoubleContourIntegral", "\u{222F}"),
        (b"DoubleDot", "\u{00A8}"),
        (b"DoubleDownArrow", "\u{21D3}"),
        (b"DoubleLeftArrow", "\u{21D0}"),
        (b"DoubleLeftRightArrow", "\u{21D4}"),
        (b"DoubleLeftTee", "\u{2AE4}"),
        (b"DoubleLongLeftArrow", "\u{27F8}"),
        (b"DoubleLongLeftRightArrow", "\u{27FA}"),
        (b"DoubleLongRightArrow", "\u{27F9}"),
        (b"DoubleRightArrow", "\u{21D2}"),
        (b"DoubleRightTee", "\u{22A8}"),
        (b"DoubleUpArrow", "\u{21D1}"),
        (b"DoubleUpDownArrow", "\u{21D5}"),
        (b"DoubleVerticalBar", "\u{2225}"),
        (b"DownArrow", "\u{2193}"),
        (b"DownArrowBar", "\u{2913}"),
        (b"DownArrowUpArrow", "\u{21F5}"),
        (b"DownBreve", "\u{0311}"),
        (b"DownLeftRightVector", "\u{2950}"),
        (b"DownLeftTeeVector", "\u{295E}"),
        (b"DownLeftVector", "\u{21BD}"),
        (b"DownLeftVectorBar", "\u{2956}"),
        (b"DownRightTeeVector", "\u{295F}"),
        (b"DownRightVector", "\u{21C1}"),
        (b"DownRightVectorBar", "\u{2957}"),
        (b"DownTee", "\u{22A4}"),
        (b"DownTeeArrow", "\u{21A7}"),
        (b"Downarrow", "\u{21D3}"),
        (b"Dscr", "\u{1D49F}"),
        (b"Dstrok", "\u{0110}"),
        (b"ENG", "\u{014A}"),
        (b"ETH", "\u{00D0}"),
        (b"Eacute", "\u{00C9}"),
        (b"Ecaron", "\u{011A}"),
        (b"Ecirc", "\u{00CA}"),
        (b"Ecy", "\u{042D}"),
        (b"Edot", "\u{0116}"),
        (b"Efr", "\u{1D508}"),
        (b"Egrave", "\u{00C8}"),
        (b"Element", "\u{2208}"),
        (b"Emacr", "\u{0112}"),
        (b"EmptySmallSquare", "\u{25FB}"),
        (b"EmptyVerySmallSquare", "\u{25AB}"),
        (b"Eogon", "\u{0118}"),
        (b"Eopf", "\u{1D53C}"),
        (b"Epsilon", "\u{0395}"),
        (b"Equal", "\u{2A75}"),
        (b"EqualTilde", "\u{2242}"),
        (b"Equilibrium", "\u{21CC}"),
        (b"Escr", "\u{2130}"),
        (b"Esim", "\u{2A73}"),
        (b"Eta", "\u{0397}"),
        (b"Euml", "\u{00CB}"),
        (b"Exists", "\u{2203}"),
        (b"ExponentialE", "\u{2147}"),
        (b"Fcy", "\u{0424}"),
        (b"Ffr", "\u{1D509}"),
        (b"FilledSmallSquare", "\u{25FC}"),
        (b"FilledVerySmallSquare", "\u{25AA}"),
        (b"Fopf", "\u{1D53D}"),
        (b"ForAll", "\u{2200}"),
        (b"Fouriertrf", "\u{2131}"),
        (b"Fscr", "\u{2131}"),
        (b"GJcy", "\u{0403}"),
        (b"GT", "\u{003E}"),
        (b"Gamma", "\u{0393}"),
        (b"Gammad", "\u{03DC}"),
        (b"Gbreve", "\u{011E}"),
        (b"Gcedil", "\u{0122}"),
        (b"Gcirc", "\u{011C}"),
        (b"Gcy", "\u{0413}"),
        (b"Gdot", "\u{0120}"),
        (b"Gfr", "\u{1D50A}"),
        (b"Gg", "\u{22D9}"),
        (b"Gopf", "\u{1D53E}"),
        (b"GreaterEqual", "\u{2265}"),
        (b"GreaterEqualLess", "\u{22DB}"),
        (b"GreaterFullEqual", "\u{2267}"),
        (b"GreaterGreater", "\u{2AA2}"),
        (b"GreaterLess", "\u{2277}"),
        (b"GreaterSlantEqual", "\u{2A7E}"),
        (b"GreaterTilde", "\u{2273}"),
        (b"Gscr", "\u{1D4A2}"),
        (b"Gt", "\u{226B}"),
        (b"HARDcy", "\u{042A}"),
        (b"Hacek", "\u{02C7}"),
        (b"Hat", "\u{005E}"),
        (b"Hcirc", "\u{0124}"),
        (b"Hfr", "\u{210C}"),
        (b"HilbertSpace", "\u{210B}"),
        (b"Hopf", "\u{210D}"),
        (b"HorizontalLine", "\u{2500}"),
        (b"Hscr", "\u{210B}"),
        (b"Hstrok", "\u{0126}"),
        (b"HumpDownHump", "\u{224E}"),
        (b"HumpEqual", "\u{224F}"),
        (b"IEcy", "\u{0415}"),
        (b"IJlig", "\u{0132}"),
        (b"IOcy", "\u{0401}"),
        (b"Iacute", "\u{00CD}"),
        (b"Icirc", "\u{00CE}"),
        (b"Icy", "\u{0418}"),
        (b"Idot", "\u{0130}"),
        (b"Ifr", "\u{2111}"),
        (b"Igrave", "\u{00CC}"),
        (b"Im", "\u{2111}"),
        (b"Imacr", "\u{012A}"),
        (b"ImaginaryI", "\u{2148}"),
        (b"Implies", "\u{21D2}"),
        (b"Int", "\u{222C}"),
        (b"Integral", "\u{222B}"),
        (b"Intersection", "\u{22C2}"),
        (b"InvisibleComma", "\u{2063}"),
        (b"InvisibleTimes", "\u{2062}"),
        (b"Iogon", "\u{012E}"),
        (b"Iopf", "\u{1D540}"),
        (b"Iota", "\u{0399}"),
        (b"Iscr", "\u{2110}"),
        (b"Itilde", "\u{0128}"),
        (b"Iukcy", "\u{0406}"),
        (b"Iuml", "\u{00CF}"),
        (b"Jcirc", "\u{0134}"),
        (b"Jcy", "\u{0419}"),
        (b"Jfr", "\u{1D50D}"),
        (b"Jopf", "\u{1D541}"),
        (b"Jscr", "\u{1D4A5}"),
        (b"Jsercy", "\u{0408}"),
        (b"Jukcy", "\u{0404}"),
        (b"KHcy", "\u{0425}"),
        (b"KJcy", "\u{040C}"),
        (b"Kappa", "\u{039A}"),
        (b"Kcedil", "\u{0136}"),
        (b"Kcy", "\u{041A}"),
        (b"Kfr", "\u{1D50E}"),
        (b"Kopf", "\u{1D542}"),
        (b"Kscr", "\u{1D4A6}"),
        (b"LJcy", "\u{0409}"),
        (b"LT", "\u{003C}"),
        (b"Lacute", "\u{0139}"),
        (b"Lambda", "\u{039B}"),
        (b"Lang", "\u{27EA}"),
        (b"Laplacetrf", "\u{2112}"),
        (b"Larr", "\u{219E}"),
        (b"Lcaron", "\u{013D}"),
        (b"Lcedil", "\u{013B}"),
        (b"Lcy", "\u{041B}"),
        (b"LeftAngleBracket", "\u{27E8}"),
        (b"LeftArrow", "\u{2190}"),
        (b"LeftArrowBar", "\u{21E4}"),
        (b"LeftArrowRightArrow", "\u{21C6}"),
        (b"LeftCeiling", "\u{2308}"),
        (b"LeftDoubleBracket", "\u{27E6}"),
        (b"LeftDownTeeVector", "\u{2961}"),
        (b"LeftDownVector", "\u{21C3}"),
        (b"LeftDownVectorBar", "\u{2959}"),
        (b"LeftFloor", "\u{230A}"),
        (b"LeftRightArrow", "\u{2194}"),
        (b"LeftRightVector", "\u{294E}"),
        (b"LeftTee", "\u{22A3}"),
        (b"LeftTeeArrow", "\u{21A4}"),
        (b"LeftTeeVector", "\u{295A}"),
        (b"LeftTriangle", "\u{22B2}"),
        (b"LeftTriangleBar", "\u{29CF}"),
        (b"LeftTriangleEqual", "\u{22B4}"),
        (b"LeftUpDownVector", "\u{2951}"),
        (b"LeftUpTeeVector", "\u{2960}"),
        (b"LeftUpVector", "\u{21BF}"),
        (b"LeftUpVectorBar", "\u{2958}"),
        (b"LeftVector", "\u{21BC}"),
        (b"LeftVectorBar", "\u{2952}"),
        (b"Leftarrow", "\u{21D0}"),
        (b"Leftrightarrow", "\u{21D4}"),
        (b"LessEqualGreater", "\u{22DA}"),
        (b"LessFullEqual", "\u{2266}"),
        (b"LessGreater", "\u{2276}"),
        (b"LessLess", "\u{2AA1}"),
        (b"LessSlantEqual", "\u{2A7D}"),
        (b"LessTilde", "\u{2272}"),
        (b"Lfr", "\u{1D50F}"),
        (b"Ll", "\u{22D8}"),
        (b"Lleftarrow", "\u{21DA}"),
        (b"Lmidot", "\u{013F}"),
        (b"LongLeftArrow", "\u{27F5}"),
        (b"LongLeftRightArrow", "\u{27F7}"),
        (b"LongRightArrow", "\u{27F6}"),
        (b"Longleftarrow", "\u{27F8}"),
        (b"Longleftrightarrow", "\u{27FA}"),
        (b"Longrightarrow", "\u{27F9}"),
        (b"Lopf", "\u{1D543}"),
        (b"LowerLeftArrow", "\u{2199}"),
        (b"LowerRightArrow", "\u{2198}"),
        (b"Lscr", "\u{2112}"),
        (b"Lsh", "\u{21B0}"),
        (b"Lstrok", "\u{0141}"),
        (b"Lt", "\u{226A}"),
        (b"Map", "\u{2905}"),
        (b"Mcy", "\u{041C}"),
        (b"MediumSpace", "\u{205F}"),
        (b"Mellintrf", "\u{2133}"),
        (b"Mfr", "\u{1D510}"),
        (b"MinusPlus", "\u{2213}"),
        (b"Mopf", "\u{1D544}"),
        (b"Mscr", "\u{2133}"),
        (b"Mu", "\u{039C}"),
        (b"NJcy", "\u{040A}"),
        (b"Nacute", "\u{0143}"),
        (b"Ncaron", "\u{0147}"),
        (b"Ncedil", "\u{0145}"),
        (b"Ncy", "\u{041D}"),
        (b"NegativeMediumSpace", "\u{200B}"),
        (b"NegativeThickSpace", "\u{200B}"),
        (b"NegativeThinSpace", "\u{200B}"),
        (b"NegativeVeryThinSpace", "\u{200B}"),
        (b"NestedGreaterGreater", "\u{226B}"),
        (b"NestedLessLess", "\u{226A}"),
        (b"NewLine", "\u{000A}"),
        (b"Nfr", "\u{1D511}"),
        (b"NoBreak", "\u{2060}"),
        (b"NonBreakingSpace", "\u{00A0}"),
        (b"Nopf", "\u{2115}"),
        (b"Not", "\u{2AEC}"),
        (b"NotCongruent", "\u{2262}"),
        (b"NotCupCap", "\u{226D}"),
        (b"NotDoubleVerticalBar", "\u{2226}"),
        (b"NotElement", "\u{2209}"),
        (b"NotEqual", "\u{2260}"),
        (b"NotEqualTilde", "\u{2242}\u{0338}"),
        (b"NotExists", "\u{2204}"),
        (b"NotGreater", "\u{226F}"),
        (b"NotGreaterEqual", "\u{2271}"),
        (b"NotGreaterFullEqual", "\u{2267}\u{0338}"),
        (b"NotGreaterGreater", "\u{226B}\u{0338}"),
        (b"NotGreaterLess", "\u{2279}"),
        (b"NotGreaterSlantEqual", "\u{2A7E}\u{0338}"),
        (b"NotGreaterTilde", "\u{2275}"),
        (b"NotHumpDownHump", "\u{224E}\u{0338}"),
        (b"NotHumpEqual", "\u{224F}\u{0338}"),
        (b"NotLeftTriangle", "\u{22EA}"),
        (b"NotLeftTriangleBar", "\u{29CF}\u{0338}"),
        (b"NotLeftTriangleEqual", "\u{22EC}"),
        (b"NotLess", "\u{226E}"),
        (b"NotLessEqual", "\u{2270}"),
        (b"NotLessGreater", "\u{2278}"),
        (b"NotLessLess", "\u{226A}\u{0338}"),
        (b"NotLessSlantEqual", "\u{2A7D}\u{0338}"),
        (b"NotLessTilde", "\u{2274}"),
        (b"NotNestedGreaterGreater", "\u{2AA2}\u{0338}"),
        (b"NotNestedLessLess", "\u{2AA1}\u{0338}"),
        (b"NotPrecedes", "\u{2280}"),
        (b"NotPrecedesEqual", "\u{2AAF}\u{0338}"),
        (b"NotPrecedesSlantEqual", "\u{22E0}"),
        (b"NotReverseElement", "\u{220C}"),
        (b"NotRightTriangle", "\u{22EB}"),
        (b"NotRightTriangleBar", "\u{29D0}\u{0338}"),
        (b"NotRightTriangleEqual", "\u{22ED}"),
        (b"NotSquareSubset", "\u{228F}\u{0338}"),
        (b"NotSquareSubsetEqual", "\u{22E2}"),
        (b"NotSquareSuperset", "\u{2290}\u{0338}"),
        (b"NotSquareSupersetEqual", "\u{22E3}"),
        (b"NotSubset", "\u{2282}\u{20D2}"),
        (b"NotSubsetEqual", "\u{2288}"),
        (b"NotSucceeds", "\u{2281}"),
        (b"NotSucceedsEqual", "\u{2AB0}\u{0338}"),
        (b"NotSucceedsSlantEqual", "\u{22E1}"),
        (b"NotSucceedsTilde", "\u{227F}\u{0338}"),
        (b"NotSuperset", "\u{2283}\u{20D2}"),
        (b"NotSupersetEqual", "\u{2289}"),
        (b"NotTilde", "\u{2241}"),
        (b"NotTildeEqual", "\u{2244}"),
        (b"NotTildeFullEqual", "\u{2247}"),
        (b"NotTildeTilde", "\u{2249}"),
        (b"NotVerticalBar", "\u{2224}"),
        (b"Nscr", "\u{1D4A9}"),
        (b"Ntilde", "\u{00D1}"),
        (b"Nu", "\u{039D}"),
        (b"OElig", "\u{0152}"),
        (b"Oacute", "\u{00D3}"),
        (b"Ocirc", "\u{00D4}"),
        (b"Ocy", "\u{041E}"),
        (b"Odblac", "\u{0150}"),
        (b"Ofr", "\u{1D512}"),
        (b"Ograve", "\u{00D2}"),
        (b"Omacr", "\u{014C}"),
        (b"Omega", "\u{03A9}"),
        (b"Omicron", "\u{039F}"),
        (b"Oopf", "\u{1D546}"),
        (b"OpenCurlyDoubleQuote", "\u{201C}"),
        (b"OpenCurlyQuote", "\u{2018}"),
        (b"Or", "\u{2A54}"),
        (b"Oscr", "\u{1D4AA}"),
        (b"Oslash", "\u{00D8}"),
        (b"Otilde", "\u{00D5}"),
        (b"Otimes", "\u{2A37}"),
        (b"Ouml", "\u{00D6}"),
        (b"OverBar", "\u{203E}"),
        (b"OverBrace", "\u{23DE}"),
        (b"OverBracket", "\u{23B4}"),
        (b"OverParenthesis", "\u{23DC}"),
        (b"PartialD", "\u{2202}"),
        (b"Pcy", "\u{041F}"),
        (b"Pfr", "\u{1D513}"),
        (b"Phi", "\u{03A6}"),
        (b"Pi", "\u{03A0}"),
        (b"PlusMinus", "\u{00B1}"),
        (b"Poincareplane", "\u{210C}"),
        (b"Popf", "\u{2119}"),
        (b"Pr", "\u{2ABB}"),
        (b"Precedes", "\u{227A}"),
        (b"PrecedesEqual", "\u{2AAF}"),
        (b"PrecedesSlantEqual", "\u{227C}"),
        (b"PrecedesTilde", "\u{227E}"),
        (b"Prime", "\u{2033}"),
        (b"Product", "\u{220F}"),
        (b"Proportion", "\u{2237}"),
        (b"Proportional", "\u{221D}"),
        (b"Pscr", "\u{1D4AB}"),
        (b"Psi", "\u{03A8}"),
        (b"QUOT", "\u{0022}"),
        (b"Qfr", "\u{1D514}"),
        (b"Qopf", "\u{211A}"),
        (b"Qscr", "\u{1D4AC}"),
        (b"RBarr", "\u{2910}"),
        (b"REG", "\u{00AE}"),
        (b"Racute", "\u{0154}"),
        (b"Rang", "\u{27EB}"),
        (b"Rarr", "\u{21A0}"),
        (b"Rarrtl", "\u{2916}"),
        (b"Rcaron", "\u{0158}"),
        (b"Rcedil", "\u{0156}"),
        (b"Rcy", "\u{0420}"),
        (b"Re", "\u{211C}"),
        (b"ReverseElement", "\u{220B}"),
        (b"ReverseEquilibrium", "\u{21CB}"),
        (b"ReverseUpEquilibrium", "\u{296F}"),
        (b"Rfr", "\u{211C}"),
        (b"Rho", "\u{03A1}"),
        (b"RightAngleBracket", "\u{27E9}"),
        (b"RightArrow", "\u{2192}"),
        (b"RightArrowBar", "\u{21E5}"),
        (b"RightArrowLeftArrow", "\u{21C4}"),
        (b"RightCeiling", "\u{2309}"),
        (b"RightDoubleBracket", "\u{27E7}"),
        (b"RightDownTeeVector", "\u{295D}"),
        (b"RightDownVector", "\u{21C2}"),
        (b"RightDownVectorBar", "\u{2955}"),
        (b"RightFloor", "\u{230B}"),
        (b"RightTee", "\u{22A2}"),
        (b"RightTeeArrow", "\u{21A6}"),
        (b"RightTeeVector", "\u{295B}"),
        (b"RightTriangle", "\u{22B3}"),
        (b"RightTriangleBar", "\u{29D0}"),
        (b"RightTriangleEqual", "\u{22B5}"),
        (b"RightUpDownVector", "\u{294F}"),
        (b"RightUpTeeVector", "\u{295C}"),
        (b"RightUpVector", "\u{21BE}"),
        (b"RightUpVectorBar", "\u{2954}"),
        (b"RightVector", "\u{21C0}"),
        (b"RightVectorBar", "\u{2953}"),
        (b"Rightarrow", "\u{21D2}"),
        (b"Ropf", "\u{211D}"),
        (b"RoundImplies", "\u{2970}"),
        (b"Rrightarrow", "\u{21DB}"),
        (b"Rscr", "\u{211B}"),
        (b"Rsh", "\u{21B1}"),
        (b"RuleDelayed", "\u{29F4}"),
        (b"SHCHcy", "\u{0429}"),
        (b"SHcy", "\u{0428}"),
        (b"SOFTcy", "\u{042C}"),
        (b"Sacute", "\u{015A}"),
        (b"Sc", "\u{2ABC}"),
        (b"Scaron", "\u{0160}"),
        (b"Scedil", "\u{015E}"),
        (b"Scirc", "\u{015C}"),
        (b"Scy", "\u{0421}"),
        (b"Sfr", "\u{1D516}"),
        (b"ShortDownArrow", "\u{2193}"),
        (b"ShortLeftArrow", "\u{2190}"),
        (b"ShortRightArrow", "\u{2192}"),
        (b"ShortUpArrow", "\u{2191}"),
        (b"Sigma", "\u{03A3}"),
        (b"SmallCircle", "\u{2218}"),
        (b"Sopf", "\u{1D54A}"),
        (b"Sqrt", "\u{221A}"),
        (b"Square", "\u{25A1}"),
        (b"SquareIntersection", "\u{2293}"),
        (b"SquareSubset", "\u{228F}"),
        (b"SquareSubsetEqual", "\u{2291}"),
        (b"SquareSuperset", "\u{2290}"),
        (b"SquareSupersetEqual", "\u{2292}"),
        (b"SquareUnion", "\u{2294}"),
        (b"Sscr", "\u{1D4AE}"),
        (b"Star", "\u{22C6}"),
        (b"Sub", "\u{22D0}"),
        (b"Subset", "\u{22D0}"),
        (b"SubsetEqual", "\u{2286}"),
        (b"Succeeds", "\u{227B}"),
        (b"SucceedsEqual", "\u{2AB0}"),
        (b"SucceedsSlantEqual", "\u{227D}"),
        (b"SucceedsTilde", "\u{227F}"),
        (b"SuchThat", "\u{220B}"),
        (b"Sum", "\u{2211}"),
        (b"Sup", "\u{22D1}"),
        (b"Superset", "\u{2283}"),
        (b"SupersetEqual", "\u{2287}"),
        (b"Supset", "\u{22D1}"),
        (b"THORN", "\u{00DE}"),
        (b"TRADE", "\u{2122}"),
        (b"TSHcy", "\u{040B}"),
        (b"TScy", "\u{0426}"),
        (b"Tab", "\u{0009}"),
        (b"Tau", "\u{03A4}"),
        (b"Tcaron", "\u{0164}"),
        (b"Tcedil", "\u{0162}"),
        (b"Tcy", "\u{0422}"),
        (b"Tfr", "\u{1D517}"),
        (b"Therefore", "\u{2234}"),
        (b"Theta", "\u{0398}"),
        (b"ThickSpace", "\u{205F}\u{200A}"),
        (b"ThinSpace", "\u{2009}"),
        (b"Tilde", "\u{223C}"),
        (b"TildeEqual", "\u{2243}"),
        (b"TildeFullEqual", "\u{2245}"),
        (b"TildeTilde", "\u{2248}"),
        (b"Topf", "\u{1D54B}"),
        (b"TripleDot", "\u{20DB}"),
        (b"Tscr", "\u{1D4AF}"),
        (b"Tstrok", "\u{0166}"),
        (b"Uacute", "\u{00DA}"),
        (b"Uarr", "\u{219F}"),
        (b"Uarrocir", "\u{2949}"),
        (b"Ubrcy", "\u{040E}"),
        (b"Ubreve", "\u{016C}"),
        (b"Ucirc", "\u{00DB}"),
        (b"Ucy", "\u{0423}"),
        (b"Udblac", "\u{0170}"),
        (b"Ufr", "\u{1D518}"),
        (b"Ugrave", "\u{00D9}"),
        (b"Umacr", "\u{016A}"),
        (b"UnderBar", "\u{005F}"),
        (b"UnderBrace", "\u{23DF}"),
        (b"UnderBracket", "\u{23B5}"),
        (b"UnderParenthesis", "\u{23DD}"),
        (b"Union", "\u{22C3}"),
        (b"UnionPlus", "\u{228E}"),
        (b"Uogon", "\u{0172}"),
        (b"Uopf", "\u{1D54C}"),
        (b"UpArrow", "\u{2191}"),
        (b"UpArrowBar", "\u{2912}"),
        (b"UpArrowDownArrow", "\u{21C5}"),
        (b"UpDownArrow", "\u{2195}"),
        (b"UpEquilibrium", "\u{296E}"),
        (b"UpTee", "\u{22A5}"),
        (b"UpTeeArrow", "\u{21A5}"),
        (b"Uparrow", "\u{21D1}"),
        (b"Updownarrow", "\u{21D5}"),
        (b"UpperLeftArrow", "\u{2196}"),
        (b"UpperRightArrow", "\u{2197}"),
        (b"Upsi", "\u{03D2}"),
        (b"Upsilon", "\u{03A5}"),
        (b"Uring", "\u{016E}"),
        (b"Uscr", "\u{1D4B0}"),
        (b"Utilde", "\u{0168}"),
        (b"Uuml", "\u{00DC}"),
        (b"VDash", "\u{22AB}"),
        (b"Vbar", "\u{2AEB}"),
        (b"Vcy", "\u{0412}"),
        (b"Vdash", "\u{22A9}"),
        (b"Vdashl", "\u{2AE6}"),
        (b"Vee", "\u{22C1}"),
        (b"Verbar", "\u{2016}"),
        (b"Vert", "\u{2016}"),
        (b"VerticalBar", "\u{2223}"),
        (b"VerticalLine", "\u{007C}"),
        (b"VerticalSeparator", "\u{2758}"),
        (b"VerticalTilde", "\u{2240}"),
        (b"VeryThinSpace", "\u{200A}"),
        (b"Vfr", "\u{1D519}"),
        (b"Vopf", "\u{1D54D}"),
        (b"Vscr", "\u{1D4B1}"),
        (b"Vvdash", "\u{22AA}"),
        (b"Wcirc", "\u{0174}"),
        (b"Wedge", "\u{22C0}"),
        (b"Wfr", "\u{1D51A}"),
        (b"Wopf", "\u{1D54E}"),
        (b"Wscr", "\u{1D4B2}"),
        (b"Xfr", "\u{1D51B}"),
        (b"Xi", "\u{039E}"),
        (b"Xopf", "\u{1D54F}"),
        (b"Xscr", "\u{1D4B3}"),
        (b"YAcy", "\u{042F}"),
        (b"YIcy", "\u{0407}"),
        (b"YUcy", "\u{042E}"),
        (b"Yacute", "\u{00DD}"),
        (b"Ycirc", "\u{0176}"),
        (b"Ycy", "\u{042B}"),
        (b"Yfr", "\u{1D51C}"),
        (b"Yopf", "\u{1D550}"),
        (b"Yscr", "\u{1D4B4}"),
        (b"Yuml", "\u{0178}"),
        (b"ZHcy", "\u{0416}"),
        (b"Zacute", "\u{0179}"),
        (b"Zcaron", "\u{017D}"),
        (b"Zcy", "\u{0417}"),
        (b"Zdot", "\u{017B}"),
        (b"ZeroWidthSpace", "\u{200B}"),
        (b"Zeta", "\u{0396}"),
        (b"Zfr", "\u{2128}"),
        (b"Zopf", "\u{2124}"),
        (b"Zscr", "\u{1D4B5}"),
        (b"aacute", "\u{00E1}"),
        (b"abreve", "\u{0103}"),
        (b"ac", "\u{223E}"),
        (b"acE", "\u{223E}\u{0333}"),
        (b"acd", "\u{223F}"),
        (b"acirc", "\u{00E2}"),
        (b"acute", "\u{00B4}"),
        (b"acy", "\u{0430}"),
        (b"aelig", "\u{00E6}"),
        (b"af", "\u{2061}"),
        (b"afr", "\u{1D51E}"),
        (b"agrave", "\u{00E0}"),
        (b"alefsym", "\u{2135}"),
        (b"aleph", "\u{2135}"),
        (b"alpha", "\u{03B1}"),
        (b"amacr", "\u{0101}"),
        (b"amalg", "\u{2A3F}"),
        (b"amp", "\u{0026}"),
        (b"and", "\u{2227}"),
        (b"andand", "\u{2A55}"),
        (b"andd", "\u{2A5C}"),
        (b"andslope", "\u{2A58}"),
        (b"andv", "\u{2A5A}"),
        (b"ang", "\u{2220}"),
        (b"ange", "\u{29A4}"),
        (b"angle", "\u{2220}"),
        (b"angmsd", "\u{2221}"),
        (b"angmsdaa", "\u{29A8}"),
        (b"angmsdab", "\u{29A9}"),
        (b"angmsdac", "\u{29AA}"),
        (b"angmsdad", "\u{29AB}"),
        (b"angmsdae", "\u{29AC}"),
        (b"angmsdaf", "\u{29AD}"),
        (b"angmsdag", "\u{29AE}"),
        (b"angmsdah", "\u{29AF}"),
        (b"angrt", "\u{221F}"),
        (b"angrtvb", "\u{22BE}"),
        (b"angrtvbd", "\u{299D}"),
        (b"angsph", "\u{2222}"),
        (b"angst", "\u{00C5}"),
        (b"angzarr", "\u{237C}"),
        (b"aogon", "\u{0105}"),
        (b"aopf", "\u{1D552}"),
        (b"ap", "\u{2248}"),
        (b"apE", "\u{2A70}"),
        (b"apacir", "\u{2A6F}"),
        (b"ape", "\u{224A}"),
        (b"apid", "\u{224B}"),
        (b"apos", "\u{0027}"),
        (b"approx", "\u{2248}"),
        (b"approxeq", "\u{224A}"),
        (b"aring", "\u{00E5}"),
        (b"ascr", "\u{1D4B6}"),
        (b"ast", "\u{002A}"),
        (b"asymp", "\u{2248}"),
        (b"asympeq", "\u{224D}"),
        (b"atilde", "\u{00E3}"),
        (b"auml", "\u{00E4}"),
        (b"awconint", "\u{2233}"),
        (b"awint", "\u{2A11}"),
        (b"bNot", "\u{2AED}"),
        (b"backcong", "\u{224C}"),
        (b"backepsilon", "\u{03F6}"),
        (b"backprime", "\u{2035}"),
        (b"backsim", "\u{223D}"),
        (b"backsimeq", "\u{22CD}"),
        (b"barvee", "\u{22BD}"),
        (b"barwed", "\u{2305}"),
        (b"barwedge", "\u{2305}"),
        (b"bbrk", "\u{23B5}"),
        (b"bbrktbrk", "\u{23B6}"),
        (b"bcong", "\u{224C}"),
        (b"bcy", "\u{0431}"),
        (b"bdquo", "\u{201E}"),
        (b"becaus", "\u{2235}"),
        (b"because", "\u{2235}"),
        (b"bemptyv", "\u{29B0}"),
        (b"bepsi", "\u{03F6}"),
        (b"bernou", "\u{212C}"),
        (b"beta", "\u{03B2}"),
        (b"beth", "\u{2136}"),
        (b"between", "\u{226C}"),
        (b"bfr", "\u{1D51F}"),
        (b"bigcap", "\u{22C2}"),
        (b"bigcirc", "\u{25EF}"),
        (b"bigcup", "\u{22C3}"),
        (b"bigodot", "\u{2A00}"),
        (b"bigoplus", "\u{2A01}"),
        (b"bigotimes", "\u{2A02}"),
        (b"bigsqcup", "\u{2A06}"),
        (b"bigstar", "\u{2605}"),
        (b"bigtriangledown", "\u{25BD}"),
        (b"bigtriangleup", "\u{25B3}"),
        (b"biguplus", "\u{2A04}"),
        (b"bigvee", "\u{22C1}"),
        (b"bigwedge", "\u{22C0}"),
        (b"bkarow", "\u{290D}"),
        (b"blacklozenge", "\u{29EB}"),
        (b"blacksquare", "\u{25AA}"),
        (b"blacktriangle", "\u{25B4}"),
        (b"blacktriangledown", "\u{25BE}"),
        (b"blacktriangleleft", "\u{25C2}"),
        (b"blacktriangleright", "\u{25B8}"),
        (b"blank", "\u{2423}"),
        (b"blk12", "\u{2592}"),
        (b"blk14", "\u{2591}"),
        (b"blk34", "\u{2593}"),
        (b"block", "\u{2588}"),
        (b"bne", "\u{003D}\u{20E5}"),
        (b"bnequiv", "\u{2261}\u{20E5}"),
        (b"bnot", "\u{2310}"),
        (b"bopf", "\u{1D553}"),
        (b"bot", "\u{22A5}"),
        (b"bottom", "\u{22A5}"),
        (b"bowtie", "\u{22C8}"),
        (b"boxDL", "\u{2557}"),
        (b"boxDR", "\u{2554}"),
        (b"boxDl", "\u{2556}"),
        (b"boxDr", "\u{2553}"),
        (b"boxH", "\u{2550}"),
        (b"boxHD", "\u{2566}"),
        (b"boxHU", "\u{2569}"),
        (b"boxHd", "\u{2564}"),
        (b"boxHu", "\u{2567}"),
        (b"boxUL", "\u{255D}"),
        (b"boxUR", "\u{255A}"),
        (b"boxUl", "\u{255C}"),
        (b"boxUr", "\u{2559}"),
        (b"boxV", "\u{2551}"),
        (b"boxVH", "\u{256C}"),
        (b"boxVL", "\u{2563}"),
        (b"boxVR", "\u{2560}"),
        (b"boxVh", "\u{256B}"),
        (b"boxVl", "\u{2562}"),
        (b"boxVr", "\u{255F}"),
        (b"boxbox", "\u{29C9}"),
        (b"boxdL", "\u{2555}"),
        (b"boxdR", "\u{2552}"),
        (b"boxdl", "\u{2510}"),
        (b"boxdr", "\u{250C}"),
        (b"boxh", "\u{2500}"),
        (b"boxhD", "\u{2565}"),
        (b"boxhU", "\u{2568}"),
        (b"boxhd", "\u{252C}"),
        (b"boxhu", "\u{2534}"),
        (b"boxminus", "\u{229F}"),
        (b"boxplus", "\u{229E}"),
        (b"boxtimes", "\u{22A0}"),
        (b"boxuL", "\u{255B}"),
        (b"boxuR", "\u{2558}"),
        (b"boxul", "\u{2518}"),
        (b"boxur", "\u{2514}"),
        (b"boxv", "\u{2502}"),
        (b"boxvH", "\u{256A}"),
        (b"boxvL", "\u{2561}"),
        (b"boxvR", "\u{255E}"),
        (b"boxvh", "\u{253C}"),
        (b"boxvl", "\u{2524}"),
        (b"boxvr", "\u{251C}"),
        (b"bprime", "\u{2035}"),
        (b"breve", "\u{02D8}"),
        (b"brvbar", "\u{00A6}"),
        (b"bscr", "\u{1D4B7}"),
        (b"bsemi", "\u{204F}"),
        (b"bsim", "\u{223D}"),
        (b"bsime", "\u{22CD}"),
        (b"bsol", "\u{005C}"),
        (b"bsolb", "\u{29C5}"),
        (b"bsolhsub", "\u{27C8}"),
        (b"bull", "\u{2022}"),
        (b"bullet", "\u{2022}"),
        (b"bump", "\u{224E}"),
        (b"bumpE", "\u{2AAE}"),
        (b"bumpe", "\u{224F}"),
        (b"bumpeq", "\u{224F}"),
        (b"cacute", "\u{0107}"),
        (b"cap", "\u{2229}"),
        (b"capand", "\u{2A44}"),
        (b"capbrcup", "\u{2A49}"),
        (b"capcap", "\u{2A4B}"),
        (b"capcup", "\u{2A47}"),
        (b"capdot", "\u{2A40}"),
        (b"caps", "\u{2229}\u{FE00}"),
        (b"caret", "\u{2041}"),
        (b"caron", "\u{02C7}"),
        (b"ccaps", "\u{2A4D}"),
        (b"ccaron", "\u{010D}"),
        (b"ccedil", "\u{00E7}"),
        (b"ccirc", "\u{0109}"),
        (b"ccups", "\u{2A4C}"),
        (b"ccupssm", "\u{2A50}"),
        (b"cdot", "\u{010B}"),
        (b"cedil", "\u{00B8}"),
        (b"cemptyv", "\u{29B2}"),
        (b"cent", "\u{00A2}"),
        (b"centerdot", "\u{00B7}"),
        (b"cfr", "\u{1D520}"),
        (b"chcy", "\u{0447}"),
        (b"check", "\u{2713}"),
        (b"checkmark", "\u{2713}"),
        (b"chi", "\u{03C7}"),
        (b"cir", "\u{25CB}"),
        (b"cirE", "\u{29C3}"),
        (b"circ", "\u{02C6}"),
        (b"circeq", "\u{2257}"),
        (b"circlearrowleft", "\u{21BA}"),
        (b"circlearrowright", "\u{21BB}"),
        (b"circledR", "\u{00AE}"),
        (b"circledS", "\u{24C8}"),
        (b"circledast", "\u{229B}"),
        (b"circledcirc", "\u{229A}"),
        (b"circleddash", "\u{229D}"),
        (b"cire", "\u{2257}"),
        (b"cirfnint", "\u{2A10}"),
        (b"cirmid", "\u{2AEF}"),
        (b"cirscir", "\u{29C2}"),
        (b"clubs", "\u{2663}"),
        (b"clubsuit", "\u{2663}"),
        (b"colon", "\u{003A}"),
        (b"colone", "\u{2254}"),
        (b"coloneq", "\u{2254}"),
        (b"comma", "\u{002C}"),
        (b"commat", "\u{0040}"),
        (b"comp", "\u{2201}"),
        (b"compfn", "\u{2218}"),
        (b"complement", "\u{2201}"),
        (b"complexes", "\u{2102}"),
        (b"cong", "\u{2245}"),
        (b"congdot", "\u{2A6D}"),
        (b"conint", "\u{222E}"),
        (b"copf", "\u{1D554}"),
        (b"coprod", "\u{2210}"),
        (b"copy", "\u{00A9}"),
        (b"copysr", "\u{2117}"),
        (b"crarr", "\u{21B5}"),
        (b"cross", "\u{2717}"),
        (b"cscr", "\u{1D4B8}"),
        (b"csub", "\u{2ACF}"),
        (b"csube", "\u{2AD1}"),
        (b"csup", "\u{2AD0}"),
        (b"csupe", "\u{2AD2}"),
        (b"ctdot", "\u{22EF}"),
        (b"cudarrl", "\u{2938}"),
        (b"cudarrr", "\u{2935}"),
        (b"cuepr", "\u{22DE}"),
        (b"cuesc", "\u{22DF}"),
        (b"cularr", "\u{21B6}"),
        (b"cularrp", "\u{293D}"),
        (b"cup", "\u{222A}"),
        (b"cupbrcap", "\u{2A48}"),
        (b"cupcap", "\u{2A46}"),
        (b"cupcup", "\u{2A4A}"),
        (b"cupdot", "\u{228D}"),
        (b"cupor", "\u{2A45}"),
        (b"cups", "\u{222A}\u{FE00}"),
        (b"curarr", "\u{21B7}"),
        (b"curarrm", "\u{293C}"),
        (b"curlyeqprec", "\u{22DE}"),
        (b"curlyeqsucc", "\u{22DF}"),
        (b"curlyvee", "\u{22CE}"),
        (b"curlywedge", "\u{22CF}"),
        (b"curren", "\u{00A4}"),
        (b"curvearrowleft", "\u{21B6}"),
        (b"curvearrowright", "\u{21B7}"),
        (b"cuvee", "\u{22CE}"),
        (b"cuwed", "\u{22CF}"),
        (b"cwconint", "\u{2232}"),
        (b"cwint", "\u{2231}"),
        (b"cylcty", "\u{232D}"),
        (b"dArr", "\u{21D3}"),
        (b"dHar", "\u{2965}"),
        (b"dagger", "\u{2020}"),
        (b"daleth", "\u{2138}"),
        (b"darr", "\u{2193}"),
        (b"dash", "\u{2010}"),
        (b"dashv", "\u{22A3}"),
        (b"dbkarow", "\u{290F}"),
        (b"dblac", "\u{02DD}"),
        (b"dcaron", "\u{010F}"),
        (b"dcy", "\u{0434}"),
        (b"dd", "\u{2146}"),
        (b"ddagger", "\u{2021}"),
        (b"ddarr", "\u{21CA}"),
        (b"ddotseq", "\u{2A77}"),
        (b"deg", "\u{00B0}"),
        (b"delta", "\u{03B4}"),
        (b"demptyv", "\u{29B1}"),
        (b"dfisht", "\u{297F}"),
        (b"dfr", "\u{1D521}"),
        (b"dharl", "\u{21C3}"),
        (b"dharr", "\u{21C2}"),
        (b"diam", "\u{22C4}"),
        (b"diamond", "\u{22C4}"),
        (b"diamondsuit", "\u{2666}"),
        (b"diams", "\u{2666}"),
        (b"die", "\u{00A8}"),
        (b"digamma", "\u{03DD}"),
        (b"disin", "\u{22F2}"),
        (b"div", "\u{00F7}"),
        (b"divide", "\u{00F7}"),
        (b"divideontimes", "\u{22C7}"),
        (b"divonx", "\u{22C7}"),
        (b"djcy", "\u{0452}"),
        (b"dlcorn", "\u{231E}"),
        (b"dlcrop", "\u{230D}"),
        (b"dollar", "\u{0024}"),
        (b"dopf", "\u{1D555}"),
        (b"dot", "\u{02D9}"),
        (b"doteq", "\u{2250}"),
        (b"doteqdot", "\u{2251}"),
        (b"dotminus", "\u{2238}"),
        (b"dotplus", "\u{2214}"),
        (b"dotsquare", "\u{22A1}"),
        (b"doublebarwedge", "\u{2306}"),
        (b"downarrow", "\u{2193}"),
        (b"downdownarrows", "\u{21CA}"),
        (b"downharpoonleft", "\u{21C3}"),
        (b"downharpoonright", "\u{21C2}"),
        (b"drbkarow", "\u{2910}"),
        (b"drcorn", "\u{231F}"),
        (b"drcrop", "\u{230C}"),
        (b"dscr", "\u{1D4B9}"),
        (b"dscy", "\u{0455}"),
        (b"dsol", "\u{29F6}"),
        (b"dstrok", "\u{0111}"),
        (b"dtdot", "\u{22F1}"),
        (b"dtri", "\u{25BF}"),
        (b"dtrif", "\u{25BE}"),
        (b"duarr", "\u{21F5}"),
        (b"duhar", "\u{296F}"),
        (b"dwangle", "\u{29A6}"),
        (b"dzcy", "\u{045F}"),
        (b"dzigrarr", "\u{27FF}"),
        (b"eDDot", "\u{2A77}"),
        (b"eDot", "\u{2251}"),
        (b"eacute", "\u{00E9}"),
        (b"easter", "\u{2A6E}"),
        (b"ecaron", "\u{011B}"),
        (b"ecir", "\u{2256}"),
        (b"ecirc", "\u{00EA}"),
        (b"ecolon", "\u{2255}"),
        (b"ecy", "\u{044D}"),
        (b"edot", "\u{0117}"),
        (b"ee", "\u{2147}"),
        (b"efDot", "\u{2252}"),
        (b"efr", "\u{1D522}"),
        (b"eg", "\u{2A9A}"),
        (b"egrave", "\u{00E8}"),
        (b"egs", "\u{2A96}"),
        (b"egsdot", "\u{2A98}"),
        (b"el", "\u{2A99}"),
        (b"elinters", "\u{23E7}"),
        (b"ell", "\u{2113}"),
        (b"els", "\u{2A95}"),
        (b"elsdot", "\u{2A97}"),
        (b"emacr", "\u{0113}"),
        (b"empty", "\u{2205}"),
        (b"emptyset", "\u{2205}"),
        (b"emptyv", "\u{2205}"),
        (b"emsp", "\u{2003}"),
        (b"emsp13", "\u{2004}"),
        (b"emsp14", "\u{2005}"),
        (b"eng", "\u{014B}"),
        (b"ensp", "\u{2002}"),
        (b"eogon", "\u{0119}"),
        (b"eopf", "\u{1D556}"),
        (b"epar", "\u{22D5}"),
        (b"eparsl", "\u{29E3}"),
        (b"eplus", "\u{2A71}"),
        (b"epsi", "\u{03B5}"),
        (b"epsilon", "\u{03B5}"),
        (b"epsiv", "\u{03F5}"),
        (b"eqcirc", "\u{2256}"),
        (b"eqcolon", "\u{2255}"),
        (b"eqsim", "\u{2242}"),
        (b"eqslantgtr", "\u{2A96}"),
        (b"eqslantless", "\u{2A95}"),
        (b"equals", "\u{003D}"),
        (b"equest", "\u{225F}"),
        (b"equiv", "\u{2261}"),
        (b"equivDD", "\u{2A78}"),
        (b"eqvparsl", "\u{29E5}"),
        (b"erDot", "\u{2253}"),
        (b"erarr", "\u{2971}"),
        (b"escr", "\u{212F}"),
        (b"esdot", "\u{2250}"),
        (b"esim", "\u{2242}"),
        (b"eta", "\u{03B7}"),
        (b"eth", "\u{00F0}"),
        (b"euml", "\u{00EB}"),
        (b"euro", "\u{20AC}"),
        (b"excl", "\u{0021}"),
        (b"exist", "\u{2203}"),
        (b"expectation", "\u{2130}"),
        (b"exponentiale", "\u{2147}"),
        (b"fallingdotseq", "\u{2252}"),
        (b"fcy", "\u{0444}"),
        (b"female", "\u{2640}"),
        (b"ffilig", "\u{FB03}"),
        (b"fflig", "\u{FB00}"),
        (b"ffllig", "\u{FB04}"),
        (b"ffr", "\u{1D523}"),
        (b"filig", "\u{FB01}"),
        (b"fjlig", "\u{0066}\u{006A}"),
        (b"flat", "\u{266D}"),
        (b"fllig", "\u{FB02}"),
        (b"fltns", "\u{25B1}"),
        (b"fnof", "\u{0192}"),
        (b"fopf", "\u{1D557}"),
        (b"forall", "\u{2200}"),
        (b"fork", "\u{22D4}"),
        (b"forkv", "\u{2AD9}"),
        (b"fpartint", "\u{2A0D}"),
        (b"frac12", "\u{00BD}"),
        (b"frac13", "\u{2153}"),
        (b"frac14", "\u{00BC}"),
        (b"frac15", "\u{2155}"),
        (b"frac16", "\u{2159}"),
        (b"frac18", "\u{215B}"),
        (b"frac23", "\u{2154}"),
        (b"frac25", "\u{2156}"),
        (b"frac34", "\u{00BE}"),
        (b"frac35", "\u{2157}"),
        (b"frac38", "\u{215C}"),
        (b"frac45", "\u{2158}"),
        (b"frac56", "\u{215A}"),
        (b"frac58", "\u{215D}"),
        (b"frac78", "\u{215E}"),
        (b"frasl", "\u{2044}"),
        (b"frown", "\u{2322}"),
        (b"fscr", "\u{1D4BB}"),
        (b"gE", "\u{2267}"),
        (b"gEl", "\u{2A8C}"),
        (b"gacute", "\u{01F5}"),
        (b"gamma", "\u{03B3}"),
        (b"gammad", "\u{03DD}"),
        (b"gap", "\u{2A86}"),
        (b"gbreve", "\u{011F}"),
        (b"gcirc", "\u{011D}"),
        (b"gcy", "\u{0433}"),
        (b"gdot", "\u{0121}"),
        (b"ge", "\u{2265}"),
        (b"gel", "\u{22DB}"),
        (b"geq", "\u{2265}"),
        (b"geqq", "\u{2267}"),
        (b"geqslant", "\u{2A7E}"),
        (b"ges", "\u{2A7E}"),
        (b"gescc", "\u{2AA9}"),
        (b"gesdot", "\u{2A80}"),
        (b"gesdoto", "\u{2A82}"),
        (b"gesdotol", "\u{2A84}"),
        (b"gesl", "\u{22DB}\u{FE00}"),
        (b"gesles", "\u{2A94}"),
        (b"gfr", "\u{1D524}"),
        (b"gg", "\u{226B}"),
        (b"ggg", "\u{22D9}"),
        (b"gimel", "\u{2137}"),
        (b"gjcy", "\u{0453}"),
        (b"gl", "\u{2277}"),
        (b"glE", "\u{2A92}"),
        (b"gla", "\u{2AA5}"),
        (b"glj", "\u{2AA4}"),
        (b"gnE", "\u{2269}"),
        (b"gnap", "\u{2A8A}"),
        (b"gnapprox", "\u{2A8A}"),
        (b"gne", "\u{2A88}"),
        (b"gneq", "\u{2A88}"),
        (b"gneqq", "\u{2269}"),
        (b"gnsim", "\u{22E7}"),
        (b"gopf", "\u{1D558}"),
        (b"grave", "\u{0060}"),
        (b"gscr", "\u{210A}"),
        (b"gsim", "\u{2273}"),
        (b"gsime", "\u{2A8E}"),
        (b"gsiml", "\u{2A90}"),
        (b"gt", "\u{003E}"),
        (b"gtcc", "\u{2AA7}"),
        (b"gtcir", "\u{2A7A}"),
        (b"gtdot", "\u{22D7}"),
        (b"gtlPar", "\u{2995}"),
        (b"gtquest", "\u{2A7C}"),
        (b"gtrapprox", "\u{2A86}"),
        (b"gtrarr", "\u{2978}"),
        (b"gtrdot", "\u{22D7}"),
        (b"gtreqless", "\u{22DB}"),
        (b"gtreqqless", "\u{2A8C}"),
        (b"gtrless", "\u{2277}"),
        (b"gtrsim", "\u{2273}"),
        (b"gvertneqq", "\u{2269}\u{FE00}"),
        (b"gvnE", "\u{2269}\u{FE00}"),
        (b"hArr", "\u{21D4}"),
        (b"hairsp", "\u{200A}"),
        (b"half", "\u{00BD}"),
        (b"hamilt", "\u{210B}"),
        (b"hardcy", "\u{044A}"),
        (b"harr", "\u{2194}"),
        (b"harrcir", "\u{2948}"),
        (b"harrw", "\u{21AD}"),
        (b"hbar", "\u{210F}"),
        (b"hcirc", "\u{0125}"),
        (b"hearts", "\u{2665}"),
        (b"heartsuit", "\u{2665}"),
        (b"hellip", "\u{2026}"),
        (b"hercon", "\u{22B9}"),
        (b"hfr", "\u{1D525}"),
        (b"hksearow", "\u{2925}"),
        (b"hkswarow", "\u{2926}"),
        (b"hoarr", "\u{21FF}"),
        (b"homtht", "\u{223B}"),
        (b"hookleftarrow", "\u{21A9}"),
        (b"hookrightarrow", "\u{21AA}"),
        (b"hopf", "\u{1D559}"),
        (b"horbar", "\u{2015}"),
        (b"hscr", "\u{1D4BD}"),
        (b"hslash", "\u{210F}"),
        (b"hstrok", "\u{0127}"),
        (b"hybull", "\u{2043}"),
        (b"hyphen", "\u{2010}"),
        (b"iacute", "\u{00ED}"),
        (b"ic", "\u{2063}"),
        (b"icirc", "\u{00EE}"),
        (b"icy", "\u{0438}"),
        (b"iecy", "\u{0435}"),
        (b"iexcl", "\u{00A1}"),
        (b"iff", "\u{21D4}"),
        (b"ifr", "\u{1D526}"),
        (b"igrave", "\u{00EC}"),
        (b"ii", "\u{2148}"),
        (b"iiiint", "\u{2A0C}"),
        (b"iiint", "\u{222D}"),
        (b"iinfin", "\u{29DC}"),
        (b"iiota", "\u{2129}"),
        (b"ijlig", "\u{0133}"),
        (b"imacr", "\u{012B}"),
        (b"image", "\u{2111}"),
        (b"imagline", "\u{2110}"),
        (b"imagpart", "\u{2111}"),
        (b"imath", "\u{0131}"),
        (b"imof", "\u{22B7}"),
        (b"imped", "\u{01B5}"),
        (b"in", "\u{2208}"),
        (b"incare", "\u{2105}"),
        (b"infin", "\u{221E}"),
        (b"infintie", "\u{29DD}"),
        (b"inodot", "\u{0131}"),
        (b"int", "\u{222B}"),
        (b"intcal", "\u{22BA}"),
        (b"integers", "\u{2124}"),
        (b"intercal", "\u{22BA}"),
        (b"intlarhk", "\u{2A17}"),
        (b"intprod", "\u{2A3C}"),
        (b"iocy", "\u{0451}"),
        (b"iogon", "\u{012F}"),
        (b"iopf", "\u{1D55A}"),
        (b"iota", "\u{03B9}"),
        (b"iprod", "\u{2A3C}"),
        (b"iquest", "\u{00BF}"),
        (b"iscr", "\u{1D4BE}"),
        (b"isin", "\u{2208}"),
        (b"isinE", "\u{22F9}"),
        (b"isindot", "\u{22F5}"),
        (b"isins", "\u{22F4}"),
        (b"isinsv", "\u{22F3}"),
        (b"isinv", "\u{2208}"),
        (b"it", "\u{2062}"),
        (b"itilde", "\u{0129}"),
        (b"iukcy", "\u{0456}"),
        (b"iuml", "\u{00EF}"),
        (b"jcirc", "\u{0135}"),
        (b"jcy", "\u{0439}"),
        (b"jfr", "\u{1D527}"),
        (b"jmath", "\u{0237}"),
        (b"jopf", "\u{1D55B}"),
        (b"jscr", "\u{1D4BF}"),
        (b"jsercy", "\u{0458}"),
        (b"jukcy", "\u{0454}"),
        (b"kappa", "\u{03BA}"),
        (b"kappav", "\u{03F0}"),
        (b"kcedil", "\u{0137}"),
        (b"kcy", "\u{043A}"),
        (b"kfr", "\u{1D528}"),
        (b"kgreen", "\u{0138}"),
        (b"khcy", "\u{0445}"),
        (b"kjcy", "\u{045C}"),
        (b"kopf", "\u{1D55C}"),
        (b"kscr", "\u{1D4C0}"),
        (b"lAarr", "\u{21DA}"),
        (b"lArr", "\u{21D0}"),
        (b"lAtail", "\u{291B}"),
        (b"lBarr", "\u{290E}"),
        (b"lE", "\u{2266}"),
        (b"lEg", "\u{2A8B}"),
        (b"lHar", "\u{2962}"),
        (b"lacute", "\u{013A}"),
        (b"laemptyv", "\u{29B4}"),
        (b"lagran", "\u{2112}"),
        (b"lambda", "\u{03BB}"),
        (b"lang", "\u{27E8}"),
        (b"langd", "\u{2991}"),
        (b"langle", "\u{27E8}"),
        (b"lap", "\u{2A85}"),
        (b"laquo", "\u{00AB}"),
        (b"larr", "\u{2190}"),
        (b"larrb", "\u{21E4}"),
        (b"larrbfs", "\u{291F}"),
        (b"larrfs", "\u{291D}"),
        (b"larrhk", "\u{21A9}"),
        (b"larrlp", "\u{21AB}"),
        (b"larrpl", "\u{2939}"),
        (b"larrsim", "\u{2973}"),
        (b"larrtl", "\u{21A2}"),
        (b"lat", "\u{2AAB}"),
        (b"latail", "\u{2919}"),
        (b"late", "\u{2AAD}"),
        (b"lates", "\u{2AAD}\u{FE00}"),
        (b"lbarr", "\u{290C}"),
        (b"lbbrk", "\u{2772}"),
        (b"lbrace", "\u{007B}"),
        (b"lbrack", "\u{005B}"),
        (b"lbrke", "\u{298B}"),
        (b"lbrksld", "\u{298F}"),
        (b"lbrkslu", "\u{298D}"),
        (b"lcaron", "\u{013E}"),
        (b"lcedil", "\u{013C}"),
        (b"lceil", "\u{2308}"),
        (b"lcub", "\u{007B}"),
        (b"lcy", "\u{043B}"),
        (b"ldca", "\u{2936}"),
        (b"ldquo", "\u{201C}"),
        (b"ldquor", "\u{201E}"),
        (b"ldrdhar", "\u{2967}"),
        (b"ldrushar", "\u{294B}"),
        (b"ldsh", "\u{21B2}"),
        (b"le", "\u{2264}"),
        (b"leftarrow", "\u{2190}"),
        (b"leftarrowtail", "\u{21A2}"),
        (b"leftharpoondown", "\u{21BD}"),
        (b"leftharpoonup", "\u{21BC}"),
        (b"leftleftarrows", "\u{21C7}"),
        (b"leftrightarrow", "\u{2194}"),
        (b"leftrightarrows", "\u{21C6}"),
        (b"leftrightharpoons", "\u{21CB}"),
        (b"leftrightsquigarrow", "\u{21AD}"),
        (b"leftthreetimes", "\u{22CB}"),
        (b"leg", "\u{22DA}"),
        (b"leq", "\u{2264}"),
        (b"leqq", "\u{2266}"),
        (b"leqslant", "\u{2A7D}"),
        (b"les", "\u{2A7D}"),
        (b"lescc", "\u{2AA8}"),
        (b"lesdot", "\u{2A7F}"),
        (b"lesdoto", "\u{2A81}"),
        (b"lesdotor", "\u{2A83}"),
        (b"lesg", "\u{22DA}\u{FE00}"),
        (b"lesges", "\u{2A93}"),
        (b"lessapprox", "\u{2A85}"),
        (b"lessdot", "\u{22D6}"),
        (b"lesseqgtr", "\u{22DA}"),
        (b"lesseqqgtr", "\u{2A8B}"),
        (b"lessgtr", "\u{2276}"),
        (b"lesssim", "\u{2272}"),
        (b"lfisht", "\u{297C}"),
        (b"lfloor", "\u{230A}"),
        (b"lfr", "\u{1D529}"),
        (b"lg", "\u{2276}"),
        (b"lgE", "\u{2A91}"),
        (b"lhard", "\u{21BD}"),
        (b"lharu", "\u{21BC}"),
        (b"lharul", "\u{296A}"),
        (b"lhblk", "\u{2584}"),
        (b"ljcy", "\u{0459}"),
        (b"ll", "\u{226A}"),
        (b"llarr", "\u{21C7}"),
        (b"llcorner", "\u{231E}"),
        (b"llhard", "\u{296B}"),
        (b"lltri", "\u{25FA}"),
        (b"lmidot", "\u{0140}"),
        (b"lmoust", "\u{23B0}"),
        (b"lmoustache", "\u{23B0}"),
        (b"lnE", "\u{2268}"),
        (b"lnap", "\u{2A89}"),
        (b"lnapprox", "\u{2A89}"),
        (b"lne", "\u{2A87}"),
        (b"lneq", "\u{2A87}"),
        (b"lneqq", "\u{2268}"),
        (b"lnsim", "\u{22E6}"),
        (b"loang", "\u{27EC}"),
        (b"loarr", "\u{21FD}"),
        (b"lobrk", "\u{27E6}"),
        (b"longleftarrow", "\u{27F5}"),
        (b"longleftrightarrow", "\u{27F7}"),
        (b"longmapsto", "\u{27FC}"),
        (b"longrightarrow", "\u{27F6}"),
        (b"looparrowleft", "\u{21AB}"),
        (b"looparrowright", "\u{21AC}"),
        (b"lopar", "\u{2985}"),
        (b"lopf", "\u{1D55D}"),
        (b"loplus", "\u{2A2D}"),
        (b"lotimes", "\u{2A34}"),
        (b"lowast", "\u{2217}"),
        (b"lowbar", "\u{005F}"),
        (b"loz", "\u{25CA}"),
        (b"lozenge", "\u{25CA}"),
        (b"lozf", "\u{29EB}"),
        (b"lpar", "\u{0028}"),
        (b"lparlt", "\u{2993}"),
        (b"lrarr", "\u{21C6}"),
        (b"lrcorner", "\u{231F}"),
        (b"lrhar", "\u{21CB}"),
        (b"lrhard", "\u{296D}"),
        (b"lrm", "\u{200E}"),
        (b"lrtri", "\u{22BF}"),
        (b"lsaquo", "\u{2039}"),
        (b"lscr", "\u{1D4C1}"),
        (b"lsh", "\u{21B0}"),
        (b"lsim", "\u{2272}"),
        (b"lsime", "\u{2A8D}"),
        (b"lsimg", "\u{2A8F}"),
        (b"lsqb", "\u{005B}"),
        (b"lsquo", "\u{2018}"),
        (b"lsquor", "\u{201A}"),
        (b"lstrok", "\u{0142}"),
        (b"lt", "\u{003C}"),
        (b"ltcc", "\u{2AA6}"),
        (b"ltcir", "\u{2A79}"),
        (b"ltdot", "\u{22D6}"),
        (b"lthree", "\u{22CB}"),
        (b"ltimes", "\u{22C9}"),
        (b"ltlarr", "\u{2976}"),
        (b"ltquest", "\u{2A7B}"),
        (b"ltrPar", "\u{2996}"),
        (b"ltri", "\u{25C3}"),
        (b"ltrie", "\u{22B4}"),
        (b"ltrif", "\u{25C2}"),
        (b"lurdshar", "\u{294A}"),
        (b"luruhar", "\u{2966}"),
        (b"lvertneqq", "\u{2268}\u{FE00}"),
        (b"lvnE", "\u{2268}\u{FE00}"),
        (b"mDDot", "\u{223A}"),
        (b"macr", "\u{00AF}"),
        (b"male", "\u{2642}"),
        (b"malt", "\u{2720}"),
        (b"maltese", "\u{2720}"),
        (b"map", "\u{21A6}"),
        (b"mapsto", "\u{21A6}"),
        (b"mapstodown", "\u{21A7}"),
        (b"mapstoleft", "\u{21A4}"),
        (b"mapstoup", "\u{21A5}"),
        (b"marker", "\u{25AE}"),
        (b"mcomma", "\u{2A29}"),
        (b"mcy", "\u{043C}"),
        (b"mdash", "\u{2014}"),
        (b"measuredangle", "\u{2221}"),
        (b"mfr", "\u{1D52A}"),
        (b"mho", "\u{2127}"),
        (b"micro", "\u{00B5}"),
        (b"mid", "\u{2223}"),
        (b"midast", "\u{002A}"),
        (b"midcir", "\u{2AF0}"),
        (b"middot", "\u{00B7}"),
        (b"minus", "\u{2212}"),
        (b"minusb", "\u{229F}"),
        (b"minusd", "\u{2238}"),
        (b"minusdu", "\u{2A2A}"),
        (b"mlcp", "\u{2ADB}"),
        (b"mldr", "\u{2026}"),
        (b"mnplus", "\u{2213}"),
        (b"models", "\u{22A7}"),
        (b"mopf", "\u{1D55E}"),
        (b"mp", "\u{2213}"),
        (b"mscr", "\u{1D4C2}"),
        (b"mstpos", "\u{223E}"),
        (b"mu", "\u{03BC}"),
        (b"multimap", "\u{22B8}"),
        (b"mumap", "\u{22B8}"),
        (b"nGg", "\u{22D9}\u{0338}"),
        (b"nGt", "\u{226B}\u{20D2}"),
        (b"nGtv", "\u{226B}\u{0338}"),
        (b"nLeftarrow", "\u{21CD}"),
        (b"nLeftrightarrow", "\u{21CE}"),
        (b"nLl", "\u{22D8}\u{0338}"),
        (b"nLt", "\u{226A}\u{20D2}"),
        (b"nLtv", "\u{226A}\u{0338}"),
        (b"nRightarrow", "\u{21CF}"),
        (b"nVDash", "\u{22AF}"),
        (b"nVdash", "\u{22AE}"),
        (b"nabla", "\u{2207}"),
        (b"nacute", "\u{0144}"),
        (b"nang", "\u{2220}\u{20D2}"),
        (b"nap", "\u{2249}"),
        (b"napE", "\u{2A70}\u{0338}"),
        (b"napid", "\u{224B}\u{0338}"),
        (b"napos", "\u{0149}"),
        (b"napprox", "\u{2249}"),
        (b"natur", "\u{266E}"),
        (b"natural", "\u{266E}"),
        (b"naturals", "\u{2115}"),
        (b"nbsp", "\u{00A0}"),
        (b"nbump", "\u{224E}\u{0338}"),
        (b"nbumpe", "\u{224F}\u{0338}"),
        (b"ncap", "\u{2A43}"),
        (b"ncaron", "\u{0148}"),
        (b"ncedil", "\u{0146}"),
        (b"ncong", "\u{2247}"),
        (b"ncongdot", "\u{2A6D}\u{0338}"),
        (b"ncup", "\u{2A42}"),
        (b"ncy", "\u{043D}"),
        (b"ndash", "\u{2013}"),
        (b"ne", "\u{2260}"),
        (b"neArr", "\u{21D7}"),
        (b"nearhk", "\u{2924}"),
        (b"nearr", "\u{2197}"),
        (b"nearrow", "\u{2197}"),
        (b"nedot", "\u{2250}\u{0338}"),
        (b"nequiv", "\u{2262}"),
        (b"nesear", "\u{2928}"),
        (b"nesim", "\u{2242}\u{0338}"),
        (b"nexist", "\u{2204}"),
        (b"nexists", "\u{2204}"),
        (b"nfr", "\u{1D52B}"),
        (b"ngE", "\u{2267}\u{0338}"),
        (b"nge", "\u{2271}"),
        (b"ngeq", "\u{2271}"),
        (b"ngeqq", "\u{2267}\u{0338}"),
        (b"ngeqslant", "\u{2A7E}\u{0338}"),
        (b"nges", "\u{2A7E}\u{0338}"),
        (b"ngsim", "\u{2275}"),
        (b"ngt", "\u{226F}"),
        (b"ngtr", "\u{226F}"),
        (b"nhArr", "\u{21CE}"),
        (b"nharr", "\u{21AE}"),
        (b"nhpar", "\u{2AF2}"),
        (b"ni", "\u{220B}"),
        (b"nis", "\u{22FC}"),
        (b"nisd", "\u{22FA}"),
        (b"niv", "\u{220B}"),
        (b"njcy", "\u{045A}"),
        (b"nlArr", "\u{21CD}"),
        (b"nlE", "\u{2266}\u{0338}"),
        (b"nlarr", "\u{219A}"),
        (b"nldr", "\u{2025}"),
        (b"nle", "\u{2270}"),
        (b"nleftarrow", "\u{219A}"),
        (b"nleftrightarrow", "\u{21AE}"),
        (b"nleq", "\u{2270}"),
        (b"nleqq", "\u{2266}\u{0338}"),
        (b"nleqslant", "\u{2A7D}\u{0338}"),
        (b"nles", "\u{2A7D}\u{0338}"),
        (b"nless", "\u{226E}"),
        (b"nlsim", "\u{2274}"),
        (b"nlt", "\u{226E}"),
        (b"nltri", "\u{22EA}"),
        (b"nltrie", "\u{22EC}"),
        (b"nmid", "\u{2224}"),
        (b"nopf", "\u{1D55F}"),
        (b"not", "\u{00AC}"),
        (b"notin", "\u{2209}"),
        (b"notinE", "\u{22F9}\u{0338}"),
        (b"notindot", "\u{22F5}\u{0338}"),
        (b"notinva", "\u{2209}"),
        (b"notinvb", "\u{22F7}"),
        (b"notinvc", "\u{22F6}"),
        (b"notni", "\u{220C}"),
        (b"notniva", "\u{220C}"),
        (b"notnivb", "\u{22FE}"),
        (b"notnivc", "\u{22FD}"),
        (b"npar", "\u{2226}"),
        (b"nparallel", "\u{2226}"),
        (b"nparsl", "\u{2AFD}\u{20E5}"),
        (b"npart", "\u{2202}\u{0338}"),
        (b"npolint", "\u{2A14}"),
        (b"npr", "\u{2280}"),
        (b"nprcue", "\u{22E0}"),
        (b"npre", "\u{2AAF}\u{0338}"),
        (b"nprec", "\u{2280}"),
        (b"npreceq", "\u{2AAF}\u{0338}"),
        (b"nrArr", "\u{21CF}"),
        (b"nrarr", "\u{219B}"),
        (b"nrarrc", "\u{2933}\u{0338}"),
        (b"nrarrw", "\u{219D}\u{0338}"),
        (b"nrightarrow", "\u{219B}"),
        (b"nrtri", "\u{22EB}"),
        (b"nrtrie", "\u{22ED}"),
        (b"nsc", "\u{2281}"),
        (b"nsccue", "\u{22E1}"),
        (b"nsce", "\u{2AB0}\u{0338}"),
        (b"nscr", "\u{1D4C3}"),
        (b"nshortmid", "\u{2224}"),
        (b"nshortparallel", "\u{2226}"),
        (b"nsim", "\u{2241}"),
        (b"nsime", "\u{2244}"),
        (b"nsimeq", "\u{2244}"),
        (b"nsmid", "\u{2224}"),
        (b"nspar", "\u{2226}"),
        (b"nsqsube", "\u{22E2}"),
        (b"nsqsupe", "\u{22E3}"),
        (b"nsub", "\u{2284}"),
        (b"nsubE", "\u{2AC5}\u{0338}"),
        (b"nsube", "\u{2288}"),
        (b"nsubset", "\u{2282}\u{20D2}"),
        (b"nsubseteq", "\u{2288}"),
        (b"nsubseteqq", "\u{2AC5}\u{0338}"),
        (b"nsucc", "\u{2281}"),
        (b"nsucceq", "\u{2AB0}\u{0338}"),
        (b"nsup", "\u{2285}"),
        (b"nsupE", "\u{2AC6}\u{0338}"),
        (b"nsupe", "\u{2289}"),
        (b"nsupset", "\u{2283}\u{20D2}"),
        (b"nsupseteq", "\u{2289}"),
        (b"nsupseteqq", "\u{2AC6}\u{0338}"),
        (b"ntgl", "\u{2279}"),
        (b"ntilde", "\u{00F1}"),
        (b"ntlg", "\u{2278}"),
        (b"ntriangleleft", "\u{22EA}"),
        (b"ntrianglelefteq", "\u{22EC}"),
        (b"ntriangleright", "\u{22EB}"),
        (b"ntrianglerighteq", "\u{22ED}"),
        (b"nu", "\u{03BD}"),
        (b"num", "\u{0023}"),
        (b"numero", "\u{2116}"),
        (b"numsp", "\u{2007}"),
        (b"nvDash", "\u{22AD}"),
        (b"nvHarr", "\u{2904}"),
        (b"nvap", "\u{224D}\u{20D2}"),
        (b"nvdash", "\u{22AC}"),
        (b"nvge", "\u{2265}\u{20D2}"),
        (b"nvgt", "\u{003E}\u{20D2}"),
        (b"nvinfin", "\u{29DE}"),
        (b"nvlArr", "\u{2902}"),
        (b"nvle", "\u{2264}\u{20D2}"),
        (b"nvlt", "\u{003C}\u{20D2}"),
        (b"nvltrie", "\u{22B4}\u{20D2}"),
        (b"nvrArr", "\u{2903}"),
        (b"nvrtrie", "\u{22B5}\u{20D2}"),
        (b"nvsim", "\u{223C}\u{20D2}"),
        (b"nwArr", "\u{21D6}"),
        (b"nwarhk", "\u{2923}"),
        (b"nwarr", "\u{2196}"),
        (b"nwarrow", "\u{2196}"),
        (b"nwnear", "\u{2927}"),
        (b"oS", "\u{24C8}"),
        (b"oacute", "\u{00F3}"),
        (b"oast", "\u{229B}"),
        (b"ocir", "\u{229A}"),
        (b"ocirc", "\u{00F4}"),
        (b"ocy", "\u{043E}"),
        (b"odash", "\u{229D}"),
        (b"odblac", "\u{0151}"),
        (b"odiv", "\u{2A38}"),
        (b"odot", "\u{2299}"),
        (b"odsold", "\u{29BC}"),
        (b"oelig", "\u{0153}"),
        (b"ofcir", "\u{29BF}"),
        (b"ofr", "\u{1D52C}"),
        (b"ogon", "\u{02DB}"),
        (b"ograve", "\u{00F2}"),
        (b"ogt", "\u{29C1}"),
        (b"ohbar", "\u{29B5}"),
        (b"ohm", "\u{03A9}"),
        (b"oint", "\u{222E}"),
        (b"olarr", "\u{21BA}"),
        (b"olcir", "\u{29BE}"),
        (b"olcross", "\u{29BB}"),
        (b"oline", "\u{203E}"),
        (b"olt", "\u{29C0}"),
        (b"omacr", "\u{014D}"),
        (b"omega", "\u{03C9}"),
        (b"omicron", "\u{03BF}"),
        (b"omid", "\u{29B6}"),
        (b"ominus", "\u{2296}"),
        (b"oopf", "\u{1D560}"),
        (b"opar", "\u{29B7}"),
        (b"operp", "\u{29B9}"),
        (b"oplus", "\u{2295}"),
        (b"or", "\u{2228}"),
        (b"orarr", "\u{21BB}"),
        (b"ord", "\u{2A5D}"),
        (b"order", "\u{2134}"),
        (b"orderof", "\u{2134}"),
        (b"ordf", "\u{00AA}"),
        (b"ordm", "\u{00BA}"),
        (b"origof", "\u{22B6}"),
        (b"oror", "\u{2A56}"),
        (b"orslope", "\u{2A57}"),
        (b"orv", "\u{2A5B}"),
        (b"oscr", "\u{2134}"),
        (b"oslash", "\u{00F8}"),
        (b"osol", "\u{2298}"),
        (b"otilde", "\u{00F5}"),
        (b"otimes", "\u{2297}"),
        (b"otimesas", "\u{2A36}"),
        (b"ouml", "\u{00F6}"),
        (b"ovbar", "\u{233D}"),
        (b"par", "\u{2225}"),
        (b"para", "\u{00B6}"),
        (b"parallel", "\u{2225}"),
        (b"parsim", "\u{2AF3}"),
        (b"parsl", "\u{2AFD}"),
        (b"part", "\u{2202}"),
        (b"pcy", "\u{043F}"),
        (b"percnt", "\u{0025}"),
        (b"period", "\u{002E}"),
        (b"permil", "\u{2030}"),
        (b"perp", "\u{22A5}"),
        (b"pertenk", "\u{2031}"),
        (b"pfr", "\u{1D52D}"),
        (b"phi", "\u{03C6}"),
        (b"phiv", "\u{03D5}"),
        (b"phmmat", "\u{2133}"),
        (b"phone", "\u{260E}"),
        (b"pi", "\u{03C0}"),
        (b"pitchfork", "\u{22D4}"),
        (b"piv", "\u{03D6}"),
        (b"planck", "\u{210F}"),
        (b"planckh", "\u{210E}"),
        (b"plankv", "\u{210F}"),
        (b"plus", "\u{002B}"),
        (b"plusacir", "\u{2A23}"),
        (b"plusb", "\u{229E}"),
        (b"pluscir", "\u{2A22}"),
        (b"plusdo", "\u{2214}"),
        (b"plusdu", "\u{2A25}"),
        (b"pluse", "\u{2A72}"),
        (b"plusmn", "\u{00B1}"),
        (b"plussim", "\u{2A26}"),
        (b"plustwo", "\u{2A27}"),
        (b"pm", "\u{00B1}"),
        (b"pointint", "\u{2A15}"),
        (b"popf", "\u{1D561}"),
        (b"pound", "\u{00A3}"),
        (b"pr", "\u{227A}"),
        (b"prE", "\u{2AB3}"),
        (b"prap", "\u{2AB7}"),
        (b"prcue", "\u{227C}"),
        (b"pre", "\u{2AAF}"),
        (b"prec", "\u{227A}"),
        (b"precapprox", "\u{2AB7}"),
        (b"preccurlyeq", "\u{227C}"),
        (b"preceq", "\u{2AAF}"),
        (b"precnapprox", "\u{2AB9}"),
        (b"precneqq", "\u{2AB5}"),
        (b"precnsim", "\u{22E8}"),
        (b"precsim", "\u{227E}"),
        (b"prime", "\u{2032}"),
        (b"primes", "\u{2119}"),
        (b"prnE", "\u{2AB5}"),
        (b"prnap", "\u{2AB9}"),
        (b"prnsim", "\u{22E8}"),
        (b"prod", "\u{220F}"),
        (b"profalar", "\u{232E}"),
        (b"profline", "\u{2312}"),
        (b"profsurf", "\u{2313}"),
        (b"prop", "\u{221D}"),
        (b"propto", "\u{221D}"),
        (b"prsim", "\u{227E}"),
        (b"prurel", "\u{22B0}"),
        (b"pscr", "\u{1D4C5}"),
        (b"psi", "\u{03C8}"),
        (b"puncsp", "\u{2008}"),
        (b"qfr", "\u{1D52E}"),
        (b"qint", "\u{2A0C}"),
        (b"qopf", "\u{1D562}"),
        (b"qprime", "\u{2057}"),
        (b"qscr", "\u{1D4C6}"),
        (b"quaternions", "\u{210D}"),
        (b"quatint", "\u{2A16}"),
        (b"quest", "\u{003F}"),
        (b"questeq", "\u{225F}"),
        (b"quot", "\u{0022}"),
        (b"rAarr", "\u{21DB}"),
        (b"rArr", "\u{21D2}"),
        (b"rAtail", "\u{291C}"),
        (b"rBarr", "\u{290F}"),
        (b"rHar", "\u{2964}"),
        (b"race", "\u{223D}\u{0331}"),
        (b"racute", "\u{0155}"),
        (b"radic", "\u{221A}"),
        (b"raemptyv", "\u{29B3}"),
        (b"rang", "\u{27E9}"),
        (b"rangd", "\u{2992}"),
        (b"range", "\u{29A5}"),
        (b"rangle", "\u{27E9}"),
        (b"raquo", "\u{00BB}"),
        (b"rarr", "\u{2192}"),
        (b"rarrap", "\u{2975}"),
        (b"rarrb", "\u{21E5}"),
        (b"rarrbfs", "\u{2920}"),
        (b"rarrc", "\u{2933}"),
        (b"rarrfs", "\u{291E}"),
        (b"rarrhk", "\u{21AA}"),
        (b"rarrlp", "\u{21AC}"),
        (b"rarrpl", "\u{2945}"),
        (b"rarrsim", "\u{2974}"),
        (b"rarrtl", "\u{21A3}"),
        (b"rarrw", "\u{219D}"),
        (b"ratail", "\u{291A}"),
        (b"ratio", "\u{2236}"),
        (b"rationals", "\u{211A}"),
        (b"rbarr", "\u{290D}"),
        (b"rbbrk", "\u{2773}"),
        (b"rbrace", "\u{007D}"),
        (b"rbrack", "\u{005D}"),
        (b"rbrke", "\u{298C}"),
        (b"rbrksld", "\u{298E}"),
        (b"rbrkslu", "\u{2990}"),
        (b"rcaron", "\u{0159}"),
        (b"rcedil", "\u{0157}"),
        (b"rceil", "\u{2309}"),
        (b"rcub", "\u{007D}"),
        (b"rcy", "\u{0440}"),
        (b"rdca", "\u{2937}"),
        (b"rdldhar", "\u{2969}"),
        (b"rdquo", "\u{201D}"),
        (b"rdquor", "\u{201D}"),
        (b"rdsh", "\u{21B3}"),
        (b"real", "\u{211C}"),
        (b"realine", "\u{211B}"),
        (b"realpart", "\u{211C}"),
        (b"reals", "\u{211D}"),
        (b"rect", "\u{25AD}"),
        (b"reg", "\u{00AE}"),
        (b"rfisht", "\u{297D}"),
        (b"rfloor", "\u{230B}"),
        (b"rfr", "\u{1D52F}"),
        (b"rhard", "\u{21C1}"),
        (b"rharu", "\u{21C0}"),
        (b"rharul", "\u{296C}"),
        (b"rho", "\u{03C1}"),
        (b"rhov", "\u{03F1}"),
        (b"rightarrow", "\u{2192}"),
        (b"rightarrowtail", "\u{21A3}"),
        (b"rightharpoondown", "\u{21C1}"),
        (b"rightharpoonup", "\u{21C0}"),
        (b"rightleftarrows", "\u{21C4}"),
        (b"rightleftharpoons", "\u{21CC}"),
        (b"rightrightarrows", "\u{21C9}"),
        (b"rightsquigarrow", "\u{219D}"),
        (b"rightthreetimes", "\u{22CC}"),
        (b"ring", "\u{02DA}"),
        (b"risingdotseq", "\u{2253}"),
        (b"rlarr", "\u{21C4}"),
        (b"rlhar", "\u{21CC}"),
        (b"rlm", "\u{200F}"),
        (b"rmoust", "\u{23B1}"),
        (b"rmoustache", "\u{23B1}"),
        (b"rnmid", "\u{2AEE}"),
        (b"roang", "\u{27ED}"),
        (b"roarr", "\u{21FE}"),
        (b"robrk", "\u{27E7}"),
        (b"ropar", "\u{2986}"),
        (b"ropf", "\u{1D563}"),
        (b"roplus", "\u{2A2E}"),
        (b"rotimes", "\u{2A35}"),
        (b"rpar", "\u{0029}"),
        (b"rpargt", "\u{2994}"),
        (b"rppolint", "\u{2A12}"),
        (b"rrarr", "\u{21C9}"),
        (b"rsaquo", "\u{203A}"),
        (b"rscr", "\u{1D4C7}"),
        (b"rsh", "\u{21B1}"),
        (b"rsqb", "\u{005D}"),
        (b"rsquo", "\u{2019}"),
        (b"rsquor", "\u{2019}"),
        (b"rthree", "\u{22CC}"),
        (b"rtimes", "\u{22CA}"),
        (b"rtri", "\u{25B9}"),
        (b"rtrie", "\u{22B5}"),
        (b"rtrif", "\u{25B8}"),
        (b"rtriltri", "\u{29CE}"),
        (b"ruluhar", "\u{2968}"),
        (b"rx", "\u{211E}"),
        (b"sacute", "\u{015B}"),
        (b"sbquo", "\u{201A}"),
        (b"sc", "\u{227B}"),
        (b"scE", "\u{2AB4}"),
        (b"scap", "\u{2AB8}"),
        (b"scaron", "\u{0161}"),
        (b"sccue", "\u{227D}"),
        (b"sce", "\u{2AB0}"),
        (b"scedil", "\u{015F}"),
        (b"scirc", "\u{015D}"),
        (b"scnE", "\u{2AB6}"),
        (b"scnap", "\u{2ABA}"),
        (b"scnsim", "\u{22E9}"),
        (b"scpolint", "\u{2A13}"),
        (b"scsim", "\u{227F}"),
        (b"scy", "\u{0441}"),
        (b"sdot", "\u{22C5}"),
        (b"sdotb", "\u{22A1}"),
        (b"sdote", "\u{2A66}"),
        (b"seArr", "\u{21D8}"),
        (b"searhk", "\u{2925}"),
        (b"searr", "\u{2198}"),
        (b"searrow", "\u{2198}"),
        (b"sect", "\u{00A7}"),
        (b"semi", "\u{003B}"),
        (b"seswar", "\u{2929}"),
        (b"setminus", "\u{2216}"),
        (b"setmn", "\u{2216}"),
        (b"sext", "\u{2736}"),
        (b"sfr", "\u{1D530}"),
        (b"sfrown", "\u{2322}"),
        (b"sharp", "\u{266F}"),
        (b"shchcy", "\u{0449}"),
        (b"shcy", "\u{0448}"),
        (b"shortmid", "\u{2223}"),
        (b"shortparallel", "\u{2225}"),
        (b"shy", "\u{00AD}"),
        (b"sigma", "\u{03C3}"),
        (b"sigmaf", "\u{03C2}"),
        (b"sigmav", "\u{03C2}"),
        (b"sim", "\u{223C}"),
        (b"simdot", "\u{2A6A}"),
        (b"sime", "\u{2243}"),
        (b"simeq", "\u{2243}"),
        (b"simg", "\u{2A9E}"),
        (b"simgE", "\u{2AA0}"),
        (b"siml", "\u{2A9D}"),
        (b"simlE", "\u{2A9F}"),
        (b"simne", "\u{2246}"),
        (b"simplus", "\u{2A24}"),
        (b"simrarr", "\u{2972}"),
        (b"slarr", "\u{2190}"),
        (b"smallsetminus", "\u{2216}"),
        (b"smashp", "\u{2A33}"),
        (b"smeparsl", "\u{29E4}"),
        (b"smid", "\u{2223}"),
        (b"smile", "\u{2323}"),
        (b"smt", "\u{2AAA}"),
        (b"smte", "\u{2AAC}"),
        (b"smtes", "\u{2AAC}\u{FE00}"),
        (b"softcy", "\u{044C}"),
        (b"sol", "\u{002F}"),
        (b"solb", "\u{29C4}"),
        (b"solbar", "\u{233F}"),
        (b"sopf", "\u{1D564}"),
        (b"spades", "\u{2660}"),
        (b"spadesuit", "\u{2660}"),
        (b"spar", "\u{2225}"),
        (b"sqcap", "\u{2293}"),
        (b"sqcaps", "\u{2293}\u{FE00}"),
        (b"sqcup", "\u{2294}"),
        (b"sqcups", "\u{2294}\u{FE00}"),
        (b"sqsub", "\u{228F}"),
        (b"sqsube", "\u{2291}"),
        (b"sqsubset", "\u{228F}"),
        (b"sqsubseteq", "\u{2291}"),
        (b"sqsup", "\u{2290}"),
        (b"sqsupe", "\u{2292}"),
        (b"sqsupset", "\u{2290}"),
        (b"sqsupseteq", "\u{2292}"),
        (b"squ", "\u{25A1}"),
        (b"square", "\u{25A1}"),
        (b"squarf", "\u{25AA}"),
        (b"squf", "\u{25AA}"),
        (b"srarr", "\u{2192}"),
        (b"sscr", "\u{1D4C8}"),
        (b"ssetmn", "\u{2216}"),
        (b"ssmile", "\u{2323}"),
        (b"sstarf", "\u{22C6}"),
        (b"star", "\u{2606}"),
        (b"starf", "\u{2605}"),
        (b"straightepsilon", "\u{03F5}"),
        (b"straightphi", "\u{03D5}"),
        (b"strns", "\u{00AF}"),
        (b"sub", "\u{2282}"),
        (b"subE", "\u{2AC5}"),
        (b"subdot", "\u{2ABD}"),
        (b"sube", "\u{2286}"),
        (b"subedot", "\u{2AC3}"),
        (b"submult", "\u{2AC1}"),
        (b"subnE", "\u{2ACB}"),
        (b"subne", "\u{228A}"),
        (b"subplus", "\u{2ABF}"),
        (b"subrarr", "\u{2979}"),
        (b"subset", "\u{2282}"),
        (b"subseteq", "\u{2286}"),
        (b"subseteqq", "\u{2AC5}"),
        (b"subsetneq", "\u{228A}"),
        (b"subsetneqq", "\u{2ACB}"),
        (b"subsim", "\u{2AC7}"),
        (b"subsub", "\u{2AD5}"),
        (b"subsup", "\u{2AD3}"),
        (b"succ", "\u{227B}"),
        (b"succapprox", "\u{2AB8}"),
        (b"succcurlyeq", "\u{227D}"),
        (b"succeq", "\u{2AB0}"),
        (b"succnapprox", "\u{2ABA}"),
        (b"succneqq", "\u{2AB6}"),
        (b"succnsim", "\u{22E9}"),
        (b"succsim", "\u{227F}"),
        (b"sum", "\u{2211}"),
        (b"sung", "\u{266A}"),
        (b"sup", "\u{2283}"),
        (b"sup1", "\u{00B9}"),
        (b"sup2", "\u{00B2}"),
        (b"sup3", "\u{00B3}"),
        (b"supE", "\u{2AC6}"),
        (b"supdot", "\u{2ABE}"),
        (b"supdsub", "\u{2AD8}"),
        (b"supe", "\u{2287}"),
        (b"supedot", "\u{2AC4}"),
        (b"suphsol", "\u{27C9}"),
        (b"suphsub", "\u{2AD7}"),
        (b"suplarr", "\u{297B}"),
        (b"supmult", "\u{2AC2}"),
        (b"supnE", "\u{2ACC}"),
        (b"supne", "\u{228B}"),
        (b"supplus", "\u{2AC0}"),
        (b"supset", "\u{2283}"),
        (b"supseteq", "\u{2287}"),
        (b"supseteqq", "\u{2AC6}"),
        (b"supsetneq", "\u{228B}"),
        (b"supsetneqq", "\u{2ACC}"),
        (b"supsim", "\u{2AC8}"),
        (b"supsub", "\u{2AD4}"),
        (b"supsup", "\u{2AD6}"),
        (b"swArr", "\u{21D9}"),
        (b"swarhk", "\u{2926}"),
        (b"swarr", "\u{2199}"),
        (b"swarrow", "\u{2199}"),
        (b"swnwar", "\u{292A}"),
        (b"szlig", "\u{00DF}"),
        (b"target", "\u{2316}"),
        (b"tau", "\u{03C4}"),
        (b"tbrk", "\u{23B4}"),
        (b"tcaron", "\u{0165}"),
        (b"tcedil", "\u{0163}"),
        (b"tcy", "\u{0442}"),
        (b"tdot", "\u{20DB}"),
        (b"telrec", "\u{2315}"),
        (b"tfr", "\u{1D531}"),
        (b"there4", "\u{2234}"),
        (b"therefore", "\u{2234}"),
        (b"theta", "\u{03B8}"),
        (b"thetasym", "\u{03D1}"),
        (b"thetav", "\u{03D1}"),
        (b"thickapprox", "\u{2248}"),
        (b"thicksim", "\u{223C}"),
        (b"thinsp", "\u{2009}"),
        (b"thkap", "\u{2248}"),
        (b"thksim", "\u{223C}"),
        (b"thorn", "\u{00FE}"),
        (b"tilde", "\u{02DC}"),
        (b"times", "\u{00D7}"),
        (b"timesb", "\u{22A0}"),
        (b"timesbar", "\u{2A31}"),
        (b"timesd", "\u{2A30}"),
        (b"tint", "\u{222D}"),
        (b"toea", "\u{2928}"),
        (b"top", "\u{22A4}"),
        (b"topbot", "\u{2336}"),
        (b"topcir", "\u{2AF1}"),
        (b"topf", "\u{1D565}"),
        (b"topfork", "\u{2ADA}"),
        (b"tosa", "\u{2929}"),
        (b"tprime", "\u{2034}"),
        (b"trade", "\u{2122}"),
        (b"triangle", "\u{25B5}"),
        (b"triangledown", "\u{25BF}"),
        (b"triangleleft", "\u{25C3}"),
        (b"trianglelefteq", "\u{22B4}"),
        (b"triangleq", "\u{225C}"),
        (b"triangleright", "\u{25B9}"),
        (b"trianglerighteq", "\u{22B5}"),
        (b"tridot", "\u{25EC}"),
        (b"trie", "\u{225C}"),
        (b"triminus", "\u{2A3A}"),
        (b"triplus", "\u{2A39}"),
        (b"trisb", "\u{29CD}"),
        (b"tritime", "\u{2A3B}"),
        (b"trpezium", "\u{23E2}"),
        (b"tscr", "\u{1D4C9}"),
        (b"tscy", "\u{0446}"),
        (b"tshcy", "\u{045B}"),
        (b"tstrok", "\u{0167}"),
        (b"twixt", "\u{226C}"),
        (b"twoheadleftarrow", "\u{219E}"),
        (b"twoheadrightarrow", "\u{21A0}"),
        (b"uArr", "\u{21D1}"),
        (b"uHar", "\u{2963}"),
        (b"uacute", "\u{00FA}"),
        (b"uarr", "\u{2191}"),
        (b"ubrcy", "\u{045E}"),
        (b"ubreve", "\u{016D}"),
        (b"ucirc", "\u{00FB}"),
        (b"ucy", "\u{0443}"),
        (b"udarr", "\u{21C5}"),
        (b"udblac", "\u{0171}"),
        (b"udhar", "\u{296E}"),
        (b"ufisht", "\u{297E}"),
        (b"ufr", "\u{1D532}"),
        (b"ugrave", "\u{00F9}"),
        (b"uharl", "\u{21BF}"),
        (b"uharr", "\u{21BE}"),
        (b"uhblk", "\u{2580}"),
        (b"ulcorn", "\u{231C}"),
        (b"ulcorner", "\u{231C}"),
        (b"ulcrop", "\u{230F}"),
        (b"ultri", "\u{25F8}"),
        (b"umacr", "\u{016B}"),
        (b"uml", "\u{00A8}"),
        (b"uogon", "\u{0173}"),
        (b"uopf", "\u{1D566}"),
        (b"uparrow", "\u{2191}"),
        (b"updownarrow", "\u{2195}"),
        (b"upharpoonleft", "\u{21BF}"),
        (b"upharpoonright", "\u{21BE}"),
        (b"uplus", "\u{228E}"),
        (b"upsi", "\u{03C5}"),
        (b"upsih", "\u{03D2}"),
        (b"upsilon", "\u{03C5}"),
        (b"upuparrows", "\u{21C8}"),
        (b"urcorn", "\u{231D}"),
        (b"urcorner", "\u{231D}"),
        (b"urcrop", "\u{230E}"),
        (b"uring", "\u{016F}"),
        (b"urtri", "\u{25F9}"),
        (b"uscr", "\u{1D4CA}"),
        (b"utdot", "\u{22F0}"),
        (b"utilde", "\u{0169}"),
        (b"utri", "\u{25B5}"),
        (b"utrif", "\u{25B4}"),
        (b"uuarr", "\u{21C8}"),
        (b"uuml", "\u{00FC}"),
        (b"uwangle", "\u{29A7}"),
        (b"vArr", "\u{21D5}"),
        (b"vBar", "\u{2AE8}"),
        (b"vBarv", "\u{2AE9}"),
        (b"vDash", "\u{22A8}"),
        (b"vangrt", "\u{299C}"),
        (b"varepsilon", "\u{03F5}"),
        (b"varkappa", "\u{03F0}"),
        (b"varnothing", "\u{2205}"),
        (b"varphi", "\u{03D5}"),
        (b"varpi", "\u{03D6}"),
        (b"varpropto", "\u{221D}"),
        (b"varr", "\u{2195}"),
        (b"varrho", "\u{03F1}"),
        (b"varsigma", "\u{03C2}"),
        (b"varsubsetneq", "\u{228A}\u{FE00}"),
        (b"varsubsetneqq", "\u{2ACB}\u{FE00}"),
        (b"varsupsetneq", "\u{228B}\u{FE00}"),
        (b"varsupsetneqq", "\u{2ACC}\u{FE00}"),
        (b"vartheta", "\u{03D1}"),
        (b"vartriangleleft", "\u{22B2}"),
        (b"vartriangleright", "\u{22B3}"),
        (b"vcy", "\u{0432}"),
        (b"vdash", "\u{22A2}"),
        (b"vee", "\u{2228}"),
        (b"veebar", "\u{22BB}"),
        (b"veeeq", "\u{225A}"),
        (b"vellip", "\u{22EE}"),
        (b"verbar", "\u{007C}"),
        (b"vert", "\u{007C}"),
        (b"vfr", "\u{1D533}"),
        (b"vltri", "\u{22B2}"),
        (b"vnsub", "\u{2282}\u{20D2}"),
        (b"vnsup", "\u{2283}\u{20D2}"),
        (b"vopf", "\u{1D567}"),
        (b"vprop", "\u{221D}"),
        (b"vrtri", "\u{22B3}"),
        (b"vscr", "\u{1D4CB}"),
        (b"vsubnE", "\u{2ACB}\u{FE00}"),
        (b"vsubne", "\u{228A}\u{FE00}"),
        (b"vsupnE", "\u{2ACC}\u{FE00}"),
        (b"vsupne", "\u{228B}\u{FE00}"),
        (b"vzigzag", "\u{299A}"),
        (b"wcirc", "\u{0175}"),
        (b"wedbar", "\u{2A5F}"),
        (b"wedge", "\u{2227}"),
        (b"wedgeq", "\u{2259}"),
        (b"weierp", "\u{2118}"),
        (b"wfr", "\u{1D534}"),
        (b"wopf", "\u{1D568}"),
        (b"wp", "\u{2118}"),
        (b"wr", "\u{2240}"),
        (b"wreath", "\u{2240}"),
        (b"wscr", "\u{1D4CC}"),
        (b"xcap", "\u{22C2}"),
        (b"xcirc", "\u{25EF}"),
        (b"xcup", "\u{22C3}"),
        (b"xdtri", "\u{25BD}"),
        (b"xfr", "\u{1D535}"),
        (b"xhArr", "\u{27FA}"),
        (b"xharr", "\u{27F7}"),
        (b"xi", "\u{03BE}"),
        (b"xlArr", "\u{27F8}"),
        (b"xlarr", "\u{27F5}"),
        (b"xmap", "\u{27FC}"),
        (b"xnis", "\u{22FB}"),
        (b"xodot", "\u{2A00}"),
        (b"xopf", "\u{1D569}"),
        (b"xoplus", "\u{2A01}"),
        (b"xotime", "\u{2A02}"),
        (b"xrArr", "\u{27F9}"),
        (b"xrarr", "\u{27F6}"),
        (b"xscr", "\u{1D4CD}"),
        (b"xsqcup", "\u{2A06}"),
        (b"xuplus", "\u{2A04}"),
        (b"xutri", "\u{25B3}"),
        (b"xvee", "\u{22C1}"),
        (b"xwedge", "\u{22C0}"),
        (b"yacute", "\u{00FD}"),
        (b"yacy", "\u{044F}"),
        (b"ycirc", "\u{0177}"),
        (b"ycy", "\u{044B}"),
        (b"yen", "\u{00A5}"),
        (b"yfr", "\u{1D536}"),
        (b"yicy", "\u{0457}"),
        (b"yopf", "\u{1D56A}"),
        (b"yscr", "\u{1D4CE}"),
        (b"yucy", "\u{044E}"),
        (b"yuml", "\u{00FF}"),
        (b"zacute", "\u{017A}"),
        (b"zcaron", "\u{017E}"),
        (b"zcy", "\u{0437}"),
        (b"zdot", "\u{017C}"),
        (b"zeetrf", "\u{2128}"),
        (b"zeta", "\u{03B6}"),
        (b"zfr", "\u{1D537}"),
        (b"zhcy", "\u{0436}"),
        (b"zigrarr", "\u{21DD}"),
        (b"zopf", "\u{1D56B}"),
        (b"zscr", "\u{1D4CF}"),
        (b"zwj", "\u{200D}"),
        (b"zwnj", "\u{200C}"),
    ];

pub(crate) fn get_entity(bytes: &[u8]) -> Option<&'static str> {
    ENTITIES.binary_search_by_key(&bytes, |&(key, _value)| key).ok().map(|i| ENTITIES[i].1)
}

