#ifndef __ROCCAT_TYON_PROFILE_BUTTONS_H__
#define __ROCCAT_TYON_PROFILE_BUTTONS_H__

/*
 * This file is part of roccat-tools.
 *
 * roccat-tools is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * roccat-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with roccat-tools. If not, see <http://www.gnu.org/licenses/>.
 */

#include "roccat_device.h"

G_BEGIN_DECLS

typedef struct _TyonProfileButton TyonProfileButton;
typedef struct _TyonProfileButtons TyonProfileButtons;

enum {
	TYON_PHYSICAL_BUTTON_NUM = 16,
	TYON_PROFILE_BUTTON_NUM = 32,
};

struct _TyonProfileButton {
	guint8 type;
	/* modifier and key are only valid for type shortcut */
	guint8 modifier;
	guint8 key;
} __attribute__ ((packed));

typedef enum {
	TYON_BUTTON_INDEX_LEFT = 0,
	TYON_BUTTON_INDEX_RIGHT,
	TYON_BUTTON_INDEX_MIDDLE,
	TYON_BUTTON_INDEX_THUMB_BACK,
	TYON_BUTTON_INDEX_THUMB_FORWARD,
	TYON_BUTTON_INDEX_THUMB_PEDAL,
	TYON_BUTTON_INDEX_THUMB_PADDLE_UP,
	TYON_BUTTON_INDEX_THUMB_PADDLE_DOWN,
	TYON_BUTTON_INDEX_LEFT_BACK,
	TYON_BUTTON_INDEX_LEFT_FORWARD,
	TYON_BUTTON_INDEX_RIGHT_BACK,
	TYON_BUTTON_INDEX_RIGHT_FORWARD,
	TYON_BUTTON_INDEX_FIN_RIGHT,
	TYON_BUTTON_INDEX_FIN_LEFT,
	TYON_BUTTON_INDEX_WHEEL_UP,
	TYON_BUTTON_INDEX_WHEEL_DOWN,
	TYON_BUTTON_INDEX_SHIFT_LEFT,
	TYON_BUTTON_INDEX_SHIFT_RIGHT,
	TYON_BUTTON_INDEX_SHIFT_MIDDLE,
	TYON_BUTTON_INDEX_SHIFT_THUMB_BACK,
	TYON_BUTTON_INDEX_SHIFT_THUMB_FORWARD,
	TYON_BUTTON_INDEX_SHIFT_THUMB_PEDAL,
	TYON_BUTTON_INDEX_SHIFT_THUMB_PADDLE_UP,
	TYON_BUTTON_INDEX_SHIFT_THUMB_PADDLE_DOWN,
	TYON_BUTTON_INDEX_SHIFT_LEFT_BACK,
	TYON_BUTTON_INDEX_SHIFT_LEFT_FORWARD,
	TYON_BUTTON_INDEX_SHIFT_RIGHT_BACK,
	TYON_BUTTON_INDEX_SHIFT_RIGHT_FORWARD,
	TYON_BUTTON_INDEX_SHIFT_FIN_RIGHT,
	TYON_BUTTON_INDEX_SHIFT_FIN_LEFT,
	TYON_BUTTON_INDEX_SHIFT_WHEEL_UP,
	TYON_BUTTON_INDEX_SHIFT_WHEEL_DOWN,
} TyonButtonIndex;

typedef enum {
	TYON_BUTTON_TYPE_UNUSED = 0x00,
	TYON_BUTTON_TYPE_CLICK = 0x01,
	TYON_BUTTON_TYPE_MENU = 0x02,
	TYON_BUTTON_TYPE_UNIVERSAL_SCROLLING = 0x03,
	TYON_BUTTON_TYPE_DOUBLE_CLICK = 0x04,
	TYON_BUTTON_TYPE_SHORTCUT = 0x05,
	TYON_BUTTON_TYPE_DISABLED = 0x06,
	TYON_BUTTON_TYPE_IE_FORWARD = 0x07,
	TYON_BUTTON_TYPE_IE_BACKWARD = 0x08,
	TYON_BUTTON_TYPE_TILT_LEFT = 0x09,
	TYON_BUTTON_TYPE_TILT_RIGHT = 0x0a,
	TYON_BUTTON_TYPE_SCROLL_UP = 0x0d,
	TYON_BUTTON_TYPE_SCROLL_DOWN = 0x0e,
	TYON_BUTTON_TYPE_QUICKLAUNCH = 0x0f,
	TYON_BUTTON_TYPE_PROFILE_CYCLE = 0x10,
	TYON_BUTTON_TYPE_PROFILE_UP = 0x11,
	TYON_BUTTON_TYPE_PROFILE_DOWN = 0x12,
	TYON_BUTTON_TYPE_CPI_CYCLE = 0x14,
	TYON_BUTTON_TYPE_CPI_UP = 0x15,
	TYON_BUTTON_TYPE_CPI_DOWN = 0x16,
	TYON_BUTTON_TYPE_SENSITIVITY_CYCLE = 0x17,
	TYON_BUTTON_TYPE_SENSITIVITY_UP = 0x18,
	TYON_BUTTON_TYPE_SENSITIVITY_DOWN = 0x19,
	TYON_BUTTON_TYPE_WINDOWS_KEY = 0x1a,
	TYON_BUTTON_TYPE_OPEN_DRIVER = 0x1b,
	TYON_BUTTON_TYPE_OPEN_PLAYER = 0x20,
	TYON_BUTTON_TYPE_PREV_TRACK = 0x21,
	TYON_BUTTON_TYPE_NEXT_TRACK = 0x22,
	TYON_BUTTON_TYPE_PLAY_PAUSE = 0x23,
	TYON_BUTTON_TYPE_STOP = 0x24,
	TYON_BUTTON_TYPE_MUTE = 0x25,
	TYON_BUTTON_TYPE_VOLUME_UP = 0x26,
	TYON_BUTTON_TYPE_VOLUME_DOWN = 0x27,
	TYON_BUTTON_TYPE_MACRO = 0x30,
	TYON_BUTTON_TYPE_TIMER = 0x31,
	TYON_BUTTON_TYPE_TIMER_STOP = 0x32,
	TYON_BUTTON_TYPE_EASYAIM_1 = 0x33,
	TYON_BUTTON_TYPE_EASYAIM_2 = 0x34,
	TYON_BUTTON_TYPE_EASYAIM_3 = 0x35,
	TYON_BUTTON_TYPE_EASYAIM_4 = 0x36,
	TYON_BUTTON_TYPE_EASYAIM_5 = 0x37,
	TYON_BUTTON_TYPE_EASYSHIFT_SELF = 0x41, // FIXME confirm, firmware suggests it's 0x54
	TYON_BUTTON_TYPE_EASYWHEEL_SENSITIVITY = 0x42,
	TYON_BUTTON_TYPE_EASYWHEEL_PROFILE = 0x43,
	TYON_BUTTON_TYPE_EASYWHEEL_CPI = 0x44,
	TYON_BUTTON_TYPE_EASYWHEEL_VOLUME = 0x45,
	TYON_BUTTON_TYPE_EASYWHEEL_ALT_TAB = 0x46,
	TYON_BUTTON_TYPE_EASYWHEEL_AERO_FLIP_3D = 0x47,
	TYON_BUTTON_TYPE_EASYSHIFT_OTHER = 0x51,
	TYON_BUTTON_TYPE_EASYSHIFT_LOCK_OTHER = 0x52,
	TYON_BUTTON_TYPE_EASYSHIFT_ALL = 0x53,
	TYON_BUTTON_TYPE_XINPUT_1 = 0x60,
	TYON_BUTTON_TYPE_XINPUT_2 = 0x61,
	TYON_BUTTON_TYPE_XINPUT_3 = 0x62,
	TYON_BUTTON_TYPE_XINPUT_4 = 0x63,
	TYON_BUTTON_TYPE_XINPUT_5 = 0x64,
	TYON_BUTTON_TYPE_XINPUT_6 = 0x65,
	TYON_BUTTON_TYPE_XINPUT_7 = 0x66,
	TYON_BUTTON_TYPE_XINPUT_8 = 0x67,
	TYON_BUTTON_TYPE_XINPUT_9 = 0x68,
	TYON_BUTTON_TYPE_XINPUT_10 = 0x69,
	TYON_BUTTON_TYPE_XINPUT_RX_UP = 0x6a,
	TYON_BUTTON_TYPE_XINPUT_RX_DOWN = 0x6b,
	TYON_BUTTON_TYPE_XINPUT_RY_UP = 0x6c,
	TYON_BUTTON_TYPE_XINPUT_RY_DOWN = 0x6d,
	TYON_BUTTON_TYPE_XINPUT_X_UP = 0x6e,
	TYON_BUTTON_TYPE_XINPUT_X_DOWN = 0x6f,
	TYON_BUTTON_TYPE_XINPUT_Y_UP = 0x70,
	TYON_BUTTON_TYPE_XINPUT_Y_DOWN = 0x71,
	TYON_BUTTON_TYPE_XINPUT_Z_UP = 0x72,
	TYON_BUTTON_TYPE_XINPUT_Z_DOWN = 0x73,
	TYON_BUTTON_TYPE_DINPUT_1 = 0x74,
	TYON_BUTTON_TYPE_DINPUT_2 = 0x75,
	TYON_BUTTON_TYPE_DINPUT_3 = 0x76,
	TYON_BUTTON_TYPE_DINPUT_4 = 0x77,
	TYON_BUTTON_TYPE_DINPUT_5 = 0x78,
	TYON_BUTTON_TYPE_DINPUT_6 = 0x79,
	TYON_BUTTON_TYPE_DINPUT_7 = 0x7a,
	TYON_BUTTON_TYPE_DINPUT_8 = 0x7b,
	TYON_BUTTON_TYPE_DINPUT_9 = 0x7c,
	TYON_BUTTON_TYPE_DINPUT_10 = 0x7d,
	TYON_BUTTON_TYPE_DINPUT_11 = 0x7e,
	TYON_BUTTON_TYPE_DINPUT_12 = 0x7f,
	TYON_BUTTON_TYPE_DINPUT_X_UP = 0x80,
	TYON_BUTTON_TYPE_DINPUT_X_DOWN = 0x81,
	TYON_BUTTON_TYPE_DINPUT_Y_UP = 0x82,
	TYON_BUTTON_TYPE_DINPUT_Y_DOWN = 0x83,
	TYON_BUTTON_TYPE_DINPUT_Z_UP = 0x84,
	TYON_BUTTON_TYPE_DINPUT_Z_DOWN = 0x85,
	TYON_BUTTON_TYPE_HOME = 0x86,
	TYON_BUTTON_TYPE_END = 0x87,
	TYON_BUTTON_TYPE_PAGE_UP = 0x88,
	TYON_BUTTON_TYPE_PAGE_DOWN = 0x89,
	TYON_BUTTON_TYPE_L_CTRL = 0x8a,
	TYON_BUTTON_TYPE_L_ALT = 0x8b,
} TyonButtonType;

typedef enum {
	TYON_BUTTON_MODIFIER_BIT_NONE = 0,
	TYON_BUTTON_MODIFIER_BIT_SHIFT = 1,
	TYON_BUTTON_MODIFIER_BIT_CTRL = 2,
	TYON_BUTTON_MODIFIER_BIT_ALT = 3,
	TYON_BUTTON_MODIFIER_BIT_WIN = 4,
} TyonButtonModifierBit;

struct _TyonProfileButtons {
	guint8 report_id; /* TYON_REPORT_ID_PROFILE_BUTTONS */
	guint8 size; /* always 99 */
	guint8 profile_index; /* range 0-4 */
	TyonProfileButton buttons[TYON_PROFILE_BUTTON_NUM];
} __attribute__ ((packed));

void tyon_profile_buttons_finalize(TyonProfileButtons *profile_buttons, guint profile_index);
gboolean tyon_profile_buttons_write(RoccatDevice *device, guint profile_index, TyonProfileButtons *profile_buttons, GError **error);
TyonProfileButtons *tyon_profile_buttons_read(RoccatDevice *device, guint profile_index, GError **error);
gboolean tyon_profile_buttons_equal(TyonProfileButtons const *left, TyonProfileButtons const *right);

G_END_DECLS

#endif
