/*
 * This file is part of roccat-tools.
 *
 * roccat-tools is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * roccat-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with roccat-tools. If not, see <http://www.gnu.org/licenses/>.
 */

#include "roccateventhandler_config.h"

static gchar const * const group_name = "Eventhandler";
static gchar const * const scan_interval_key = "ScanInterval";
static gchar const * const start_quiet_key = "StartQuiet";
static gchar const * const sound_driver_key = "SoundDriver";

gint roccateventhandler_configuration_get_scan_interval(RoccatKeyFile *config) {
	return roccat_key_file_get_integer_with_default(config, group_name, scan_interval_key, 2);
}

void roccateventhandler_configuration_set_scan_interval(RoccatKeyFile *config, gint new_value) {
	roccat_key_file_set_integer(config, group_name, scan_interval_key, new_value);
}

gboolean roccateventhandler_configuration_get_start_quiet(RoccatKeyFile *config) {
	return roccat_key_file_get_boolean_with_default(config, group_name, start_quiet_key, FALSE);
}

void roccateventhandler_configuration_set_start_quiet(RoccatKeyFile *config, gboolean new_value) {
	roccat_key_file_set_boolean(config, group_name, start_quiet_key, new_value);
}

gchar *roccateventhandler_configuration_get_sound_driver(RoccatKeyFile *config) {
	return roccat_key_file_get_string_with_default(config, group_name, sound_driver_key, "pulse");
}

void roccateventhandler_configuration_set_sound_driver(RoccatKeyFile *config, gchar const *path) {
	roccat_key_file_set_string(config, group_name, sound_driver_key, path);
}
