% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgcvExports.R
\name{Sl.setup}
\alias{Sl.setup}
\title{Setting up a list representing a block diagonal penalty matrix}
\usage{
Sl.setup(G)
}
\arguments{
\item{G}{the output of \code{gam.setup}.}
}
\value{
A list with an element for each block. 
        For block, b, \code{Sl[[b]]} is a list with the following elements \itemize{
         \item{\code{repara}: should re-parameterization be applied to model matrix, etc?
                               Usually \code{FALSE} if non-linear in coefficients.}
         \item{\code{start, stop}: such that \code{start:stop} are the indexes of the parameters of this block.}
         \item{\code{S}: a list of penalty matrices for the block (\code{dim = stop-start+1})
                         If \code{length(S)==1} then this will be an identity penalty.
                         Otherwise it is a multiple penalty, and an \code{rS} list of square
                         root penalty matrices will be added. \code{S} (if \code{repara==TRUE}) and \code{rS} (always)
                         will be projected into range space of total penalty matrix.}
         \item{\code{rS}: square root of penalty matrices if multiple penalties are used.}
         \item{\code{D}: a reparameterization matrix for the block. Applies to cols/params in \code{start:stop}.
                         If numeric then \code{X[,start:stop]\%*\%diag(D)} is re-parametrization of \code{X[,start:stop]},
                         and \code{b.orig = D*b.repara} (where \code{b.orig} is the original parameter vector).
                         If matrix then \code{X[,start:stop]\%*\%D} is re-parametrization of \code{X[,start:stop]},
                         and \code{b.orig = D\%*\%b.repara} (where \code{b.orig} is the original parameter vector).}
                         }
}
\description{
INTERNAL function for setting up a list representing a block diagonal penalty matrix
             from the object produced by \code{gam.setup}.
}
\author{
Simon N. Wood <simon.wood@r-project.org>.
}
