/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.javafx.experiments.dukepad.compass.app;

import com.javafx.experiments.dukepad.compass.imu.IMUConfigurator;
import com.javafx.experiments.dukepad.compass.imu.Mpu9150;
import com.javafx.experiments.dukepad.compass.imu.MpuData;
import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.event.EventHandler;
import javafx.scene.*;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.util.Duration;
import javafx.event.ActionEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * Compass UI
 */
public class CompassUI extends Pane {

    private static Group NODE_0;
    private static Node NODE_1,NODE_2,NODE_3,NODE_4,NODE_5,NODE_6;
    private static TriangleMesh MESH_0,MESH_1,MESH_2,MESH_3,MESH_4,MESH_5;
    public static final MeshView[] MESHVIEWS = new MeshView[]{ new MeshView(),new MeshView(),new MeshView(),new MeshView(),new MeshView(),new MeshView()};
    public static final Group ROOT;
    public static final Map<String,MeshView> MESHVIEW_MAP;

    private final Mpu9150 mpu9150 = new Mpu9150();
    private final MpuData mpu = new MpuData();
    private Timeline timeline;

    public CompassUI() {
        setBackground(new Background(new BackgroundFill[0]));

        Group group = new Group();
        group.setDepthTest(DepthTest.ENABLE);

        final Rotate compassRotate = new Rotate();

        group.getTransforms().addAll(compassRotate, new Rotate(90, Rotate.X_AXIS), new Rotate(180, Rotate.Z_AXIS));

        group.getChildren().add(ROOT);
        ROOT.setScaleX(25);
        ROOT.setScaleY(25);
        ROOT.setScaleZ(25);
        ROOT.setTranslateX(this.widthProperty().divide(2).subtract(0.0006445050239563).get());
        ROOT.setTranslateY(this.heightProperty().divide(2).subtract(0.0006445050239563).get());
        ROOT.setRotate(-90);
        ROOT.setRotationAxis(Rotate.X_AXIS);

        Group needles = new Group();
        needles.setTranslateX(this.widthProperty().divide(2).subtract(0.0006445050239563).get());
        needles.setTranslateY(this.heightProperty().divide(2).subtract(0.0006445050239563).get());
        final Rotate needleRotate = new Rotate();
        needleRotate.setAxis(Rotate.Y_AXIS);
        needles.getChildren().addAll(NODE_1, NODE_2, NODE_3, NODE_4);
        needles.getTransforms().addAll(needleRotate);
        ROOT.getChildren().add(needles);

        /*Box box = new Box(1.0, 2.0, 0.2);
        group.getChildren().add(box);
        box.getTransforms().addAll(compassRotate);

        Axis imuAxis = new Axis();
        group.getChildren().add(imuAxis);  */

        int i2cBus = Integer.parseInt(System.getProperty("i2c.bus", "1"));
        short i2cAddress = (short) Integer.parseInt(System.getProperty("i2c.address", "0x68").substring(2), 16);
        int sampleRate = 10;
        int samplePeriodMillis = (1000 / sampleRate);
        int yawMixingFactor = 1;

        System.out.println("Using bus: " + i2cBus + ", address = 0x" + Integer.toHexString(i2cAddress));

        if (!mpu9150.init(i2cBus, i2cAddress, sampleRate, yawMixingFactor, Boolean.getBoolean("useMag"))) {
            throw new RuntimeException("Unable to initialize IMU");
        }
        //IMUConfigurator.calibrate(mpu9150);
        try {
            TimeUnit.MILLISECONDS.sleep(samplePeriodMillis);

            timeline = new Timeline(new KeyFrame(Duration.millis(samplePeriodMillis), new EventHandler<ActionEvent>() {
                @Override public void handle(ActionEvent t) {
                    if (mpu9150.read(mpu)) {
                        //mpu.fusedEuler.mul(180 / Math.PI);
                        //Rotate deviceInWorldRotate = new Rotate();



                        //IMUConfigurator.quaternionToRotate(mpu.fusedQuat, compassRotate);
                        IMUConfigurator.quaternionToRotate(mpu, compassRotate, needleRotate);


                        //Rotate compassInWorldRotate = new Rotate();
                        //Transform worldToDeviceTransform = null;
                        //try {
                       //     worldToDeviceTransform = deviceInWorldRotate.createInverse();
                       // } catch (NonInvertibleTransformException e) {
                       //     e.printStackTrace();
                       // }
                       // compassRotate[0] = worldToDeviceTransform.createConcatenation(compassInWorldRotate);
                    }
                }
            }));
            timeline.setCycleCount(Timeline.INDEFINITE);
            timeline.play();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        AmbientLight ambient = new AmbientLight(Color.WHEAT);
        PointLight l1 = new PointLight(Color.rgb(255, 255, 255,1));
        l1.setLayoutX(400);
        l1.setLayoutY(400);
        l1.getScope().add(group);
        getChildren().addAll(group, l1, ambient);


        this.setPickOnBounds(true);
    }

    public void exitMpu9150() {
        mpu9150.exit();
        timeline.stop();
    }

    /*class Axis extends Group {
        public Axis() {
            Box boxX = new Box(3.0, 0.1, 0.1);
            getChildren().add(boxX);
            boxX.setMaterial(new PhongMaterial(Color.RED));
            //boxX.getTransforms().add(rotate);
            boxX.getTransforms().add(new Translate(1.5, 0.0, 0.0));

            Box boxY = new Box(0.1, 3.0, 0.1);
            getChildren().add(boxY);
            boxY.setMaterial(new PhongMaterial(Color.GREEN));
            //boxY.getTransforms().add(rotate);
            boxY.getTransforms().add(new Translate(0.0, 1.5, 0.0));

            Box boxZ = new Box(0.1, 0.1, 3.0);
            getChildren().add(boxZ);
            boxZ.setMaterial(new PhongMaterial(Color.BLUE));
            //boxZ.getTransforms().add(rotate);
            boxZ.getTransforms().add(new Translate(0.0, 0.0, 1.5));
        }
    }*/

    // ======== NODE CODE ===============
    private static void method0(){
        NODE_1 = MESHVIEWS[0];
        MESHVIEWS[0].setId("Needle");
        MESHVIEWS[0].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_0 = new PhongMaterial();
        MATERIAL_0.setDiffuseColor(new Color(1.0,0.0,0.0,1.0));
        MATERIAL_0.setSpecularColor(new Color(0.33000001311302185,0.33000001311302185,0.33000001311302185,1.0));
        MATERIAL_0.setSpecularPower(64.0);
        MESHVIEWS[0].setMaterial(MATERIAL_0);
        MESH_0 = new TriangleMesh();
        MESHVIEWS[0].setMesh(MESH_0);
        MESH_0.getPoints().ensureCapacity(48);
        MESH_0.getPoints().addAll(-0.022029f,0.014133f,-0.022978f,5.26E-4f,0.016555f,-0.022978f,4.08E-4f,0.014133f,0.097835f,6.45E-4f,0.01277f,0.099108f,-0.022029f,0.01277f,-0.022978f,-0.022029f,0.014133f,-0.022978f,4.08E-4f,0.014133f,0.097835f,6.45E-4f,0.014133f,0.099108f,0.023318f,0.01277f,-0.022978f,6.45E-4f,0.01277f,0.099108f,6.45E-4f,0.014133f,0.099108f,0.023318f,0.014133f,-0.022978f,6.45E-4f,0.014133f,0.099108f,0.023318f,0.014133f,-0.022978f,6.45E-4f,0.014133f,0.099108f,5.26E-4f,0.016555f,-0.022978f);
    }
    private static void method1(){
        MESH_0.getTexCoords().ensureCapacity(32);
        MESH_0.getTexCoords().addAll(3.083057f,0.446365f,2.990094f,-0.07801497f,0.309261f,0.446365f,0.280029f,1.0f,3.083057f,1.0f,3.083057f,0.912126f,0.309261f,0.912126f,0.280029f,0.912126f,-3.262774f,1.0f,-0.459746f,1.0f,-0.459746f,0.912126f,-3.262774f,0.912126f,0.280029f,0.446365f,-3.262774f,1.370744f,-0.459746f,1.370744f,-3.168831f,0.841326f);
    }
    private static void method2(){
        MESH_0.getFaces().ensureCapacity(48);
        MESH_0.getFaces().addAll(0,0,1,1,2,2,3,3,4,4,5,5,3,3,5,5,6,6,3,3,6,6,7,7,8,8,9,9,10,10,8,8,10,10,11,11,2,2,1,1,12,12,13,13,14,14,15,15);
    }
    private static void method3(){
        MESH_0.getFaceSmoothingGroups().ensureCapacity(8);
        MESH_0.getFaceSmoothingGroups().addAll(1, 4, 4, 4, 2, 2, 1, 0);
        NODE_2 = MESHVIEWS[1];
        MESHVIEWS[1].setId("S");
        MESHVIEWS[1].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_1 = new PhongMaterial();
        MATERIAL_1.setDiffuseColor(new Color(0.3294120132923126,0.3294120132923126,0.3294120132923126,1.0));
        MATERIAL_1.setSpecularColor(new Color(0.33000001311302185,0.33000001311302185,0.33000001311302185,1.0));
        MATERIAL_1.setSpecularPower(64.0);
        MESHVIEWS[1].setMaterial(MATERIAL_1);
        MESH_1 = new TriangleMesh();
        MESHVIEWS[1].setMesh(MESH_1);
        MESH_1.getPoints().ensureCapacity(1362);
        MESH_1.getPoints().addAll(-0.001836f,0.009648f,-0.160732f,-0.001653f,0.009648f,-0.159951f,-0.00135f,0.009648f,-0.159396f,-9.59E-4f,0.009648f,-0.159043f,-4.49E-4f,0.009648f,-0.158792f,1.78E-4f,0.009648f,-0.158641f,9.24E-4f,0.009648f,-0.158591f,0.001798f,0.009648f,-0.158644f,0.00249f,0.009648f,-0.158803f,0.002989f,0.009648f,-0.15905f,0.003346f,0.009648f,-0.159385f,0.00356f,0.009648f,-0.159807f,0.003631f,0.009648f,-0.160316f,0.00349f,0.009648f,-0.160889f,0.003065f,0.009648f,-0.161316f,0.002338f,0.009648f,-0.161641f,0.001287f,0.009648f,-0.161926f,-9.3E-5f,0.009648f,-0.162236f,-0.001814f,0.009648f,-0.162716f,-0.002907f,0.009648f,-0.163236f,-0.003484f,0.009648f,-0.16375f,-0.003896f,0.009648f,-0.164392f,-0.004143f,0.009648f,-0.165162f,-0.004225f,0.009648f,-0.166058f,-0.004146f,0.009648f,-0.166897f,-0.003907f,0.009648f,-0.167662f,-0.003509f,0.009648f,-0.168352f,-0.002951f,0.009648f,-0.168969f,-0.002239f,0.009648f,-0.169476f,-0.001378f,0.009648f,-0.169838f,-3.68E-4f,0.009648f,-0.170055f,7.91E-4f,0.009648f,-0.170128f,0.001784f,0.009648f,-0.17006f,0.002701f,0.009648f,-0.169855f,0.003543f,0.009648f,-0.169513f,0.004308f,0.009648f,-0.169035f,0.00495f,0.009648f,-0.168427f,0.005418f,0.009648f,-0.167696f,0.005713f,0.009648f,-0.166841f,0.005835f,0.009648f,-0.165863f,0.003216f,0.009648f,-0.165863f,0.003125f,0.009648f,-0.166409f,0.002924f,0.009648f,-0.16687f,0.002612f,0.009648f,-0.167245f,0.002189f,0.009648f,-0.167535f,0.001475f,0.009648f,-0.167781f,6.06E-4f,0.009648f,-0.167863f,-3.41E-4f,0.009648f,-0.167757f,-0.001075f,0.009648f,-0.167438f,-0.001547f,0.009648f,-0.166929f,-0.001704f,0.009648f,-0.166253f,-0.001549f,0.009648f,-0.165642f,-0.001084f,0.009648f,-0.165209f,6.14E-4f,0.009648f,-0.164669f,0.002862f,0.009648f,-0.164129f,0.004158f,0.009648f,-0.163716f,0.005091f,0.009648f,-0.163182f,0.005602f,0.009648f,-0.162671f,0.005967f,0.009648f,-0.162057f,0.006186f,0.009648f,-0.161339f,0.006259f,0.009648f,-0.160519f,0.006174f,0.009648f,-0.159664f,0.005918f,0.009648f,-0.158884f,0.00549f,0.009648f,-0.158179f,0.004892f,0.009648f,-0.157551f,0.004138f,0.009648f,-0.157034f,0.003243f,0.009648f,-0.156665f,0.002207f,0.009648f,-0.156444f,0.00103f,0.009648f,-0.15637f,-1.76E-4f,0.009648f,-0.156442f,-0.001246f,0.009648f,-0.156661f,-0.00218f,0.009648f,-0.157024f,-0.002978f,0.009648f,-0.157533f,-0.003616f,0.009648f,-0.158169f,-0.004073f,0.009648f,-0.158915f,-0.004346f,0.009648f,-0.159769f,-0.004438f,0.009648f,-0.160732f,-0.001653f,0.013137f,-0.159951f,-0.001836f,0.013137f,-0.160732f,-0.004438f,0.013137f,-0.160732f,-0.004346f,0.013137f,-0.159769f,-0.004073f,0.013137f,-0.158915f,-0.003616f,0.013137f,-0.158169f,-0.002978f,0.013137f,-0.157533f,-0.00218f,0.013137f,-0.157024f,-0.001246f,0.013137f,-0.156661f,-1.76E-4f,0.013137f,-0.156442f,0.00103f,0.013137f,-0.15637f,0.002207f,0.013137f,-0.156444f,0.003243f,0.013137f,-0.156665f,0.004138f,0.013137f,-0.157034f,0.004892f,0.013137f,-0.157551f,0.00549f,0.013137f,-0.158179f,0.005918f,0.013137f,-0.158884f,0.006174f,0.013137f,-0.159664f,0.006259f,0.013137f,-0.160519f,0.006186f,0.013137f,-0.161339f,0.005967f,0.013137f,-0.162057f,0.005602f,0.013137f,-0.162671f,0.005091f,0.013137f,-0.163182f,0.004158f,0.013137f,-0.163716f,0.002862f,0.013137f,-0.164129f,6.14E-4f,0.013137f,-0.164669f,-0.001084f,0.013137f,-0.165209f,-0.001549f,0.013137f,-0.165642f,-0.001704f,0.013137f,-0.166253f,-0.001547f,0.013137f,-0.166929f,-0.001075f,0.013137f,-0.167438f,-3.41E-4f,0.013137f,-0.167757f,6.06E-4f,0.013137f,-0.167863f,0.001475f,0.013137f,-0.167781f,0.002189f,0.013137f,-0.167535f,0.002612f,0.013137f,-0.167245f,0.002924f,0.013137f,-0.16687f,0.003125f,0.013137f,-0.166409f,0.003216f,0.013137f,-0.165863f,0.005835f,0.013137f,-0.165863f,0.005713f,0.013137f,-0.166841f,0.005418f,0.013137f,-0.167696f,0.00495f,0.013137f,-0.168427f,0.004308f,0.013137f,-0.169035f,0.003543f,0.013137f,-0.169513f,0.002701f,0.013137f,-0.169855f,0.001784f,0.013137f,-0.17006f,7.91E-4f,0.013137f,-0.170128f,-3.68E-4f,0.013137f,-0.170055f,-0.001378f,0.013137f,-0.169838f,-0.002239f,0.013137f,-0.169476f,-0.002951f,0.013137f,-0.168969f,-0.003509f,0.013137f,-0.168352f,-0.003907f,0.013137f,-0.167662f,-0.004146f,0.013137f,-0.166897f,-0.004225f,0.013137f,-0.166058f,-0.004143f,0.013137f,-0.165162f,-0.003896f,0.013137f,-0.164392f,-0.003484f,0.013137f,-0.16375f,-0.002907f,0.013137f,-0.163236f,-0.001814f,0.013137f,-0.162716f,-9.3E-5f,0.013137f,-0.162236f,0.001287f,0.013137f,-0.161926f,0.002338f,0.013137f,-0.161641f,0.003065f,0.013137f,-0.161316f,0.00349f,0.013137f,-0.160889f,0.003631f,0.013137f,-0.160316f,0.00356f,0.013137f,-0.159807f,0.003346f,0.013137f,-0.159385f,0.002989f,0.013137f,-0.15905f,0.00249f,0.013137f,-0.158803f,0.001798f,0.013137f,-0.158644f,9.24E-4f,0.013137f,-0.158591f,1.78E-4f,0.013137f,-0.158641f,-4.49E-4f,0.013137f,-0.158792f,-9.59E-4f,0.013137f,-0.159043f,-0.00135f,0.013137f,-0.159396f,-0.001653f,0.009648f,-0.159951f,-0.001836f,0.009648f,-0.160732f,-0.001836f,0.013137f,-0.160732f,-0.001653f,0.013137f,-0.159951f,-0.00135f,0.009648f,-0.159396f,-0.001653f,0.009648f,-0.159951f,-0.001653f,0.013137f,-0.159951f,-0.00135f,0.013137f,-0.159396f,-9.59E-4f,0.009648f,-0.159043f,-0.00135f,0.009648f,-0.159396f,-0.00135f,0.013137f,-0.159396f,-9.59E-4f,0.013137f,-0.159043f,-4.49E-4f,0.009648f,-0.158792f,-9.59E-4f,0.009648f,-0.159043f,-9.59E-4f,0.013137f,-0.159043f,-4.49E-4f,0.013137f,-0.158792f,1.78E-4f,0.009648f,-0.158641f,-4.49E-4f,0.009648f,-0.158792f,-4.49E-4f,0.013137f,-0.158792f,1.78E-4f,0.013137f,-0.158641f,9.24E-4f,0.009648f,-0.158591f,1.78E-4f,0.009648f,-0.158641f,1.78E-4f,0.013137f,-0.158641f,9.24E-4f,0.013137f,-0.158591f,0.001798f,0.009648f,-0.158644f,9.24E-4f,0.009648f,-0.158591f,9.24E-4f,0.013137f,-0.158591f,0.001798f,0.013137f,-0.158644f,0.00249f,0.009648f,-0.158803f,0.001798f,0.009648f,-0.158644f,0.001798f,0.013137f,-0.158644f,0.00249f,0.013137f,-0.158803f,0.002989f,0.009648f,-0.15905f,0.00249f,0.009648f,-0.158803f,0.00249f,0.013137f,-0.158803f,0.002989f,0.013137f,-0.15905f,0.003346f,0.009648f,-0.159385f,0.002989f,0.009648f,-0.15905f,0.002989f,0.013137f,-0.15905f,0.003346f,0.013137f,-0.159385f,0.00356f,0.009648f,-0.159807f,0.003346f,0.009648f,-0.159385f,0.003346f,0.013137f,-0.159385f,0.00356f,0.013137f,-0.159807f,0.003631f,0.009648f,-0.160316f,0.00356f,0.009648f,-0.159807f,0.00356f,0.013137f,-0.159807f,0.003631f,0.013137f,-0.160316f,0.00349f,0.009648f,-0.160889f,0.003631f,0.009648f,-0.160316f,0.003631f,0.013137f,-0.160316f,0.00349f,0.013137f,-0.160889f,0.003065f,0.009648f,-0.161316f,0.00349f,0.009648f,-0.160889f,0.00349f,0.013137f,-0.160889f,0.003065f,0.013137f,-0.161316f,0.002338f,0.009648f,-0.161641f,0.003065f,0.009648f,-0.161316f,0.003065f,0.013137f,-0.161316f,0.002338f,0.013137f,-0.161641f,0.001287f,0.009648f,-0.161926f,0.002338f,0.009648f,-0.161641f,0.002338f,0.013137f,-0.161641f,0.001287f,0.013137f,-0.161926f,-9.3E-5f,0.009648f,-0.162236f,0.001287f,0.009648f,-0.161926f,0.001287f,0.013137f,-0.161926f,-9.3E-5f,0.013137f,-0.162236f,-0.001814f,0.009648f,-0.162716f,-0.001814f,0.013137f,-0.162716f,-0.002907f,0.009648f,-0.163236f,-0.002907f,0.013137f,-0.163236f,-0.003484f,0.009648f,-0.16375f,-0.002907f,0.009648f,-0.163236f,-0.002907f,0.013137f,-0.163236f,-0.003484f,0.013137f,-0.16375f,-0.003896f,0.009648f,-0.164392f,-0.003484f,0.009648f,-0.16375f,-0.003484f,0.013137f,-0.16375f,-0.003896f,0.013137f,-0.164392f,-0.004143f,0.009648f,-0.165162f,-0.003896f,0.009648f,-0.164392f,-0.003896f,0.013137f,-0.164392f,-0.004143f,0.013137f,-0.165162f,-0.004225f,0.009648f,-0.166058f,-0.004143f,0.009648f,-0.165162f,-0.004143f,0.013137f,-0.165162f,-0.004225f,0.013137f,-0.166058f,-0.004146f,0.009648f,-0.166897f,-0.004225f,0.009648f,-0.166058f,-0.004225f,0.013137f,-0.166058f,-0.004146f,0.013137f,-0.166897f,-0.003907f,0.009648f,-0.167662f,-0.004146f,0.009648f,-0.166897f,-0.004146f,0.013137f,-0.166897f,-0.003907f,0.013137f,-0.167662f,-0.003509f,0.009648f,-0.168352f,-0.003907f,0.009648f,-0.167662f,-0.003907f,0.013137f,-0.167662f,-0.003509f,0.013137f,-0.168352f,-0.002951f,0.009648f,-0.168969f,-0.003509f,0.009648f,-0.168352f,-0.003509f,0.013137f,-0.168352f,-0.002951f,0.013137f,-0.168969f,-0.002239f,0.009648f,-0.169476f,-0.002951f,0.009648f,-0.168969f,-0.002951f,0.013137f,-0.168969f,-0.002239f,0.013137f,-0.169476f,-0.001378f,0.009648f,-0.169838f,-0.002239f,0.009648f,-0.169476f,-0.002239f,0.013137f,-0.169476f,-0.001378f,0.013137f,-0.169838f,-3.68E-4f,0.009648f,-0.170055f,-0.001378f,0.009648f,-0.169838f,-0.001378f,0.013137f,-0.169838f,-3.68E-4f,0.013137f,-0.170055f,7.91E-4f,0.009648f,-0.170128f,-3.68E-4f,0.009648f,-0.170055f,-3.68E-4f,0.013137f,-0.170055f,7.91E-4f,0.013137f,-0.170128f,0.001784f,0.009648f,-0.17006f,7.91E-4f,0.009648f,-0.170128f,7.91E-4f,0.013137f,-0.170128f,0.001784f,0.013137f,-0.17006f,0.002701f,0.009648f,-0.169855f,0.001784f,0.009648f,-0.17006f,0.001784f,0.013137f,-0.17006f,0.002701f,0.013137f,-0.169855f,0.003543f,0.009648f,-0.169513f,0.002701f,0.009648f,-0.169855f,0.002701f,0.013137f,-0.169855f,0.003543f,0.013137f,-0.169513f,0.004308f,0.009648f,-0.169035f,0.003543f,0.009648f,-0.169513f,0.003543f,0.013137f,-0.169513f,0.004308f,0.013137f,-0.169035f,0.00495f,0.009648f,-0.168427f,0.004308f,0.009648f,-0.169035f,0.004308f,0.013137f,-0.169035f,0.00495f,0.013137f,-0.168427f,0.005418f,0.009648f,-0.167696f,0.00495f,0.009648f,-0.168427f,0.00495f,0.013137f,-0.168427f,0.005418f,0.013137f,-0.167696f,0.005713f,0.009648f,-0.166841f,0.005418f,0.009648f,-0.167696f,0.005418f,0.013137f,-0.167696f,0.005713f,0.013137f,-0.166841f,0.005835f,0.009648f,-0.165863f,0.005713f,0.009648f,-0.166841f,0.005713f,0.013137f,-0.166841f,0.005835f,0.013137f,-0.165863f,0.003216f,0.009648f,-0.165863f,0.005835f,0.009648f,-0.165863f,0.005835f,0.013137f,-0.165863f,0.003216f,0.013137f,-0.165863f,0.003125f,0.009648f,-0.166409f,0.003216f,0.009648f,-0.165863f,0.003216f,0.013137f,-0.165863f,0.003125f,0.013137f,-0.166409f,0.002924f,0.009648f,-0.16687f,0.003125f,0.009648f,-0.166409f,0.003125f,0.013137f,-0.166409f,0.002924f,0.013137f,-0.16687f,0.002612f,0.009648f,-0.167245f,0.002924f,0.009648f,-0.16687f,0.002924f,0.013137f,-0.16687f,0.002612f,0.013137f,-0.167245f,0.002189f,0.009648f,-0.167535f,0.002612f,0.009648f,-0.167245f,0.002612f,0.013137f,-0.167245f,0.002189f,0.013137f,-0.167535f,0.001475f,0.009648f,-0.167781f,0.002189f,0.009648f,-0.167535f,0.002189f,0.013137f,-0.167535f,0.001475f,0.013137f,-0.167781f,6.06E-4f,0.009648f,-0.167863f,0.001475f,0.009648f,-0.167781f,0.001475f,0.013137f,-0.167781f,6.06E-4f,0.013137f,-0.167863f,-3.41E-4f,0.009648f,-0.167757f,6.06E-4f,0.009648f,-0.167863f,6.06E-4f,0.013137f,-0.167863f,-3.41E-4f,0.013137f,-0.167757f,-0.001075f,0.009648f,-0.167438f,-3.41E-4f,0.009648f,-0.167757f,-3.41E-4f,0.013137f,-0.167757f,-0.001075f,0.013137f,-0.167438f,-0.001547f,0.009648f,-0.166929f,-0.001075f,0.009648f,-0.167438f,-0.001075f,0.013137f,-0.167438f,-0.001547f,0.013137f,-0.166929f,-0.001704f,0.009648f,-0.166253f,-0.001547f,0.009648f,-0.166929f,-0.001547f,0.013137f,-0.166929f,-0.001704f,0.013137f,-0.166253f,-0.001549f,0.009648f,-0.165642f,-0.001704f,0.009648f,-0.166253f,-0.001704f,0.013137f,-0.166253f,-0.001549f,0.013137f,-0.165642f,-0.001084f,0.009648f,-0.165209f,-0.001549f,0.009648f,-0.165642f,-0.001549f,0.013137f,-0.165642f,-0.001084f,0.013137f,-0.165209f,6.14E-4f,0.009648f,-0.164669f,-0.001084f,0.009648f,-0.165209f,-0.001084f,0.013137f,-0.165209f,6.14E-4f,0.013137f,-0.164669f,0.002862f,0.009648f,-0.164129f,0.002862f,0.013137f,-0.164129f,0.004158f,0.009648f,-0.163716f,0.004158f,0.013137f,-0.163716f,0.005091f,0.009648f,-0.163182f,0.004158f,0.009648f,-0.163716f,0.004158f,0.013137f,-0.163716f,0.005091f,0.013137f,-0.163182f,0.005602f,0.009648f,-0.162671f,0.005091f,0.009648f,-0.163182f,0.005091f,0.013137f,-0.163182f,0.005602f,0.013137f,-0.162671f,0.005967f,0.009648f,-0.162057f,0.005602f,0.009648f,-0.162671f,0.005602f,0.013137f,-0.162671f,0.005967f,0.013137f,-0.162057f,0.006186f,0.009648f,-0.161339f,0.005967f,0.009648f,-0.162057f,0.005967f,0.013137f,-0.162057f,0.006186f,0.013137f,-0.161339f,0.006259f,0.009648f,-0.160519f,0.006186f,0.009648f,-0.161339f,0.006186f,0.013137f,-0.161339f,0.006259f,0.013137f,-0.160519f,0.006174f,0.009648f,-0.159664f,0.006259f,0.009648f,-0.160519f,0.006259f,0.013137f,-0.160519f,0.006174f,0.013137f,-0.159664f,0.005918f,0.009648f,-0.158884f,0.006174f,0.009648f,-0.159664f,0.006174f,0.013137f,-0.159664f,0.005918f,0.013137f,-0.158884f,0.00549f,0.009648f,-0.158179f,0.005918f,0.009648f,-0.158884f,0.005918f,0.013137f,-0.158884f,0.00549f,0.013137f,-0.158179f,0.004892f,0.009648f,-0.157551f,0.00549f,0.009648f,-0.158179f,0.00549f,0.013137f,-0.158179f,0.004892f,0.013137f,-0.157551f,0.004138f,0.009648f,-0.157034f,0.004892f,0.009648f,-0.157551f,0.004892f,0.013137f,-0.157551f,0.004138f,0.013137f,-0.157034f,0.003243f,0.009648f,-0.156665f,0.004138f,0.009648f,-0.157034f,0.004138f,0.013137f,-0.157034f,0.003243f,0.013137f,-0.156665f,0.002207f,0.009648f,-0.156444f,0.003243f,0.009648f,-0.156665f,0.003243f,0.013137f,-0.156665f,0.002207f,0.013137f,-0.156444f,0.00103f,0.009648f,-0.15637f,0.002207f,0.009648f,-0.156444f,0.002207f,0.013137f,-0.156444f,0.00103f,0.013137f,-0.15637f,-1.76E-4f,0.009648f,-0.156442f,0.00103f,0.009648f,-0.15637f,0.00103f,0.013137f,-0.15637f,-1.76E-4f,0.013137f,-0.156442f,-0.001246f,0.009648f,-0.156661f,-1.76E-4f,0.009648f,-0.156442f,-1.76E-4f,0.013137f,-0.156442f,-0.001246f,0.013137f,-0.156661f,-0.00218f,0.009648f,-0.157024f,-0.001246f,0.009648f,-0.156661f,-0.001246f,0.013137f,-0.156661f,-0.00218f,0.013137f,-0.157024f,-0.002978f,0.009648f,-0.157533f,-0.00218f,0.009648f,-0.157024f,-0.00218f,0.013137f,-0.157024f,-0.002978f,0.013137f,-0.157533f,-0.003616f,0.009648f,-0.158169f,-0.002978f,0.009648f,-0.157533f,-0.002978f,0.013137f,-0.157533f,-0.003616f,0.013137f,-0.158169f,-0.004073f,0.009648f,-0.158915f,-0.003616f,0.009648f,-0.158169f,-0.003616f,0.013137f,-0.158169f,-0.004073f,0.013137f,-0.158915f,-0.004346f,0.009648f,-0.159769f,-0.004073f,0.009648f,-0.158915f,-0.004073f,0.013137f,-0.158915f,-0.004346f,0.013137f,-0.159769f,-0.004438f,0.009648f,-0.160732f,-0.004346f,0.009648f,-0.159769f,-0.004346f,0.013137f,-0.159769f,-0.004438f,0.013137f,-0.160732f,-0.001836f,0.009648f,-0.160732f,-0.004438f,0.009648f,-0.160732f,-0.004438f,0.013137f,-0.160732f,-0.001836f,0.013137f,-0.160732f);
    }
    private static void method4(){
        MESH_1.getTexCoords().ensureCapacity(922);
        MESH_1.getTexCoords().addAll(-0.058718f,0.909127f,-0.062862f,0.926752f,-0.069703f,0.939285f,-0.078528f,0.947236f,-0.090024f,0.952916f,-0.104192f,0.956323f,-0.121031f,0.957459f,-0.140754f,0.956261f,-0.156382f,0.952666f,-0.167654f,0.947086f,-0.175705f,0.939534f,-0.180536f,0.93001f,-0.182146f,0.918514f,-0.17895f,0.905582f,-0.169364f,0.895945f,-0.152937f,0.888605f,-0.12922f,0.882164f,-0.098063f,0.875174f,-0.059217f,0.864339f,-0.034552f,0.852606f,-0.021532f,0.840984f,-0.012233f,0.826492f,-0.006653f,0.809129f,-0.004793f,0.788894f,-0.006591f,0.769958f,-0.011983f,0.75269496f,-0.020971f,0.737104f,-0.033553f,0.723186f,-0.049618f,0.71174f,-0.069054f,0.703564f,-0.091859f,0.698658f,-0.118035f,0.69702303f,-0.140448f,0.698564f,-0.16115f,0.703189f,-0.180142f,0.71089697f,-0.197425f,0.72168803f,-0.211898f,0.735413f,-0.222465f,0.751921f,-0.229124f,0.771213f,-0.231877f,0.793288f,-0.172759f,0.793288f,-0.170712f,0.780968f,-0.166168f,0.77057f,-0.159128f,0.762094f,-0.149591f,0.75554097f,-0.133464f,0.749999f,-0.113841f,0.748151f,-0.092471f,0.750548f,-0.075894f,0.757738f,-0.065259f,0.769222f,-0.061714f,0.784501f,-0.065209f,0.798281f,-0.075694f,0.80806804f,-0.114041f,0.820251f,-0.16477f,0.832434f,-0.194029f,0.841771f,-0.2151f,0.853804f,-0.226634f,0.86535f,-0.234872f,0.879218f,-0.239815f,0.895408f,-0.241463f,0.91392f,-0.239535f,0.933237f,-0.233749f,0.950844f,-0.224106f,0.96674f,-0.210606f,0.980927f,-0.193586f,0.992592f,-0.173383f,1.000924f,-0.149997f,1.005923f,-0.123428f,1.007589f,-0.096203f,1.005948f,-0.072049f,1.001024f,-0.050966f,0.992816f,-0.032954f,0.981326f,-0.018537f,0.966965f,-0.008238f,0.950145f,-0.00206f,0.930865f,0.0f,0.909127f,0.062862f,0.926752f,0.058718f,0.909127f,0.00206f,0.930865f,0.008238f,0.950145f,0.018537f,0.966965f,0.032954f,0.981326f,0.050966f,0.992816f,0.072049f,1.001024f,0.096203f,1.005948f,0.123428f,1.007589f,0.149997f,1.005923f,0.173383f,1.000924f,0.193586f,0.992592f,0.210606f,0.980927f,0.224106f,0.96674f,0.233749f,0.950844f,0.239535f,0.933237f,0.241463f,0.91392f,0.239815f,0.895408f,0.234872f,0.879218f,0.226634f,0.86535f,0.2151f,0.853804f,0.194029f,0.841771f,0.16477f,0.832434f,0.114041f,0.820251f,0.075694f,0.80806804f,0.065209f,0.798281f,0.061714f,0.784501f,0.065259f,0.769222f,0.075894f,0.757738f,0.092471f,0.750548f,0.113841f,0.748151f,0.133464f,0.749999f,0.149591f,0.75554097f,0.159128f,0.762094f,0.166168f,0.77057f,0.170712f,0.780968f,0.172759f,0.793288f,0.231877f,0.793288f,0.229124f,0.771213f,0.222465f,0.751921f,0.211898f,0.735413f,0.197425f,0.72168803f,0.180142f,0.71089697f,0.16115f,0.703189f,0.140448f,0.698564f,0.118035f,0.69702303f,0.091859f,0.698658f,0.069054f,0.703564f,0.049618f,0.71174f,0.033553f,0.723186f,0.020971f,0.737104f,0.011983f,0.75269496f,0.006591f,0.769958f,0.004793f,0.788894f,0.006653f,0.809129f,0.012233f,0.826492f,0.021532f,0.840984f,0.034552f,0.852606f,0.059217f,0.864339f,0.098063f,0.875174f,0.12922f,0.882164f,0.152937f,0.888605f,0.169364f,0.895945f,0.17895f,0.905582f,0.182146f,0.918514f,0.180536f,0.93001f,0.175705f,0.939534f,0.167654f,0.947086f,0.156382f,0.952666f,0.140754f,0.956261f,0.121031f,0.957459f,0.104192f,0.956323f,0.090024f,0.952916f,0.078528f,0.947236f,0.069703f,0.939285f,0.056915f,1.0f,0.075021f,1.0f,0.075021f,0.92126f,0.056915f,0.92126f,0.019899f,1.0f,0.034177f,1.0f,0.034177f,0.92126f,0.019899f,0.92126f,-0.023022f,1.0f,-0.011143f,1.0f,-0.011143f,0.92126f,-0.023022f,0.92126f,-0.059857f,1.0f,-0.047034f,1.0f,-0.047034f,0.92126f,-0.059857f,0.92126f,-0.091089f,1.0f,-0.076517f,1.0f,-0.076517f,0.92126f,-0.091089f,0.92126f,-0.117894f,1.0f,-0.101016f,1.0f,-0.101016f,0.92126f,-0.117894f,0.92126f,-0.143147f,1.0f,-0.123388f,1.0f,-0.123388f,0.92126f,-0.143147f,0.92126f,-0.163013f,1.0f,-0.146977f,1.0f,-0.146977f,0.92126f,-0.163013f,0.92126f,-0.173727f,1.0f,-0.16115f,1.0f,-0.16115f,0.92126f,-0.173727f,0.92126f,-0.169519f,1.0f,-0.15848f,1.0f,-0.15848f,0.92126f,-0.169519f,0.92126f,-0.144085f,1.0f,-0.133406f,1.0f,-0.133406f,0.92126f,-0.144085f,0.92126f,-0.105964f,1.0f,-0.094355f,1.0f,-0.094355f,0.92126f,-0.105964f,0.92126f,-0.048733f,1.0f,-0.035412f,1.0f,-0.035412f,0.92126f,-0.048733f,0.92126f,0.045678f,1.0f,0.059271f,1.0f,0.059271f,0.92126f,0.045678f,0.92126f,0.09419f,1.0f,0.112182f,1.0f,0.112182f,0.92126f,0.09419f,0.92126f,0.09382f,1.0f,0.118396f,1.0f,0.118396f,0.92126f,0.09382f,0.92126f,0.068358f,1.0f,0.100289f,1.0f,0.100289f,0.92126f,0.068358f,0.92126f,0.020593f,1.0f,0.060921f,1.0f,0.060921f,0.92126f,0.020593f,0.92126f,-0.032116f,1.0f,-0.004802f,1.0f,-0.004802f,0.92126f,-0.032116f,0.92126f,-0.089827f,1.0f,-0.072376f,1.0f,-0.072376f,0.92126f,-0.089827f,0.92126f,-0.139422f,1.0f,-0.122203f,1.0f,-0.122203f,0.92126f,-0.139422f,0.92126f,-0.179683f,1.0f,-0.161446f,1.0f,-0.161446f,0.92126f,-0.179683f,0.92126f,-0.209781f,1.0f,-0.189461f,1.0f,-0.189461f,0.92126f,-0.209781f,0.92126f,-0.229635f,1.0f,-0.210614f,1.0f,-0.210614f,0.92126f,-0.229635f,0.92126f,-0.23963f,1.0f,-0.221544f,1.0f,-0.221544f,0.92126f,-0.23963f,0.92126f,-0.238235f,1.0f,-0.220239f,1.0f,-0.220239f,0.92126f,-0.238235f,0.92126f,-0.227843f,1.0f,-0.20908f,1.0f,-0.20908f,0.92126f,-0.227843f,0.92126f,-0.207682f,1.0f,-0.187956f,1.0f,-0.187956f,0.92126f,-0.207682f,0.92126f,-0.178599f,1.0f,-0.157514f,1.0f,-0.157514f,0.92126f,-0.178599f,0.92126f,-0.153176f,1.0f,-0.129849f,1.0f,-0.129849f,0.92126f,-0.153176f,0.92126f,-0.136696f,1.0f,-0.110469f,1.0f,-0.110469f,0.92126f,-0.136696f,0.92126f,-0.119432f,1.0f,-0.096967f,1.0f,-0.096967f,0.92126f,-0.119432f,0.92126f,-0.092563f,1.0f,-0.07135f,1.0f,-0.07135f,0.92126f,-0.092563f,0.92126f,-0.058199f,1.0f,-0.037703f,1.0f,-0.037703f,0.92126f,-0.058199f,0.92126f,-0.020054f,1.0f,3.2E-4f,1.0f,3.2E-4f,0.92126f,-0.020054f,0.92126f,0.028297f,1.0f,0.048244f,1.0f,0.048244f,0.92126f,0.028297f,0.92126f,0.089012f,1.0f,0.108612f,1.0f,0.108612f,0.92126f,0.089012f,0.92126f,0.141501f,1.0f,0.16191f,1.0f,0.16191f,0.92126f,0.141501f,0.92126f,0.176435f,1.0f,0.198681f,1.0f,0.198681f,0.92126f,0.176435f,0.92126f,0.172759f,1.0f,0.231877f,1.0f,0.231877f,0.92126f,0.172759f,0.92126f,-0.188088f,1.0f,-0.175599f,1.0f,-0.175599f,0.92126f,-0.188088f,0.92126f,-0.143698f,1.0f,-0.132351f,1.0f,-0.132351f,0.92126f,-0.143698f,0.92126f,-0.081331f,1.0f,-0.070312f,1.0f,-0.070312f,0.92126f,-0.081331f,0.92126f,-0.01516f,1.0f,-0.003588f,1.0f,-0.003588f,0.92126f,-0.01516f,0.92126f,0.044969f,1.0f,0.062022f,1.0f,0.062022f,0.92126f,0.044969f,0.92126f,0.089734f,1.0f,0.109443f,1.0f,0.109443f,0.92126f,0.089734f,0.92126f,0.119696f,1.0f,0.141201f,1.0f,0.141201f,0.92126f,0.119696f,0.92126f,0.166027f,1.0f,0.184096f,1.0f,0.184096f,0.92126f,0.166027f,0.92126f,0.213664f,1.0f,0.229316f,1.0f,0.229316f,0.92126f,0.213664f,0.92126f,0.223871f,1.0f,0.239556f,1.0f,0.239556f,0.92126f,0.223871f,0.92126f,0.179497f,1.0f,0.193714f,1.0f,0.193714f,0.92126f,0.179497f,0.92126f,0.075622f,1.0f,0.089965f,1.0f,0.089965f,0.92126f,0.075622f,0.92126f,-0.05426f,1.0f,-0.014025f,1.0f,-0.014025f,0.92126f,-0.05426f,0.92126f,-0.121085f,1.0f,-0.068913f,1.0f,-0.068913f,0.92126f,-0.121085f,0.92126f,-0.136743f,1.0f,-0.10603f,1.0f,-0.10603f,0.92126f,-0.136743f,0.92126f,-0.114285f,1.0f,-0.09002f,1.0f,-0.09002f,0.92126f,-0.114285f,0.92126f,-0.064905f,1.0f,-0.048585f,1.0f,-0.048585f,0.92126f,-0.064905f,0.92126f,-0.016117f,1.0f,1.3E-5f,1.0f,1.3E-5f,0.92126f,-0.016117f,0.92126f,0.030004f,1.0f,0.046932f,1.0f,0.046932f,0.92126f,0.030004f,0.92126f,0.064333f,1.0f,0.082918f,1.0f,0.082918f,0.92126f,0.064333f,0.92126f,0.090229f,1.0f,0.109642f,1.0f,0.109642f,0.92126f,0.090229f,0.92126f,0.119672f,1.0f,0.138205f,1.0f,0.138205f,0.92126f,0.119672f,0.92126f,0.144667f,1.0f,0.163259f,1.0f,0.163259f,0.92126f,0.144667f,0.92126f,0.159001f,1.0f,0.178584f,1.0f,0.178584f,0.92126f,0.159001f,0.92126f,0.16387f,1.0f,0.184504f,1.0f,0.184504f,0.92126f,0.16387f,0.92126f,0.159934f,1.0f,0.181788f,1.0f,0.181788f,0.92126f,0.159934f,0.92126f,0.145445f,1.0f,0.169359f,1.0f,0.169359f,0.92126f,0.145445f,0.92126f,0.122711f,1.0f,0.149332f,1.0f,0.149332f,0.92126f,0.122711f,0.92126f,0.096387f,1.0f,0.123661f,1.0f,0.123661f,0.92126f,0.096387f,0.92126f,0.070802f,1.0f,0.095452f,1.0f,0.095452f,0.92126f,0.070802f,0.92126f,0.044889f,1.0f,0.067513f,1.0f,0.067513f,0.92126f,0.044889f,0.92126f,0.01774f,1.0f,0.039105f,1.0f,0.039105f,0.92126f,0.01774f,0.92126f,-0.010181f,1.0f,0.010169f,1.0f,0.010169f,0.92126f,-0.010181f,0.92126f,-0.038217f,1.0f,-0.018495f,1.0f,-0.018495f,0.92126f,-0.038217f,0.92126f,-0.065208f,1.0f,-0.044962f,1.0f,-0.044962f,0.92126f,-0.065208f,0.92126f,-0.090468f,1.0f,-0.068632f,1.0f,-0.068632f,0.92126f,-0.090468f,0.92126f,-0.058718f,1.0f,0.0f,1.0f,0.0f,0.92126f,-0.058718f,0.92126f);
    }
    private static void method5(){
        MESH_1.getFaces().ensureCapacity(1824);
        MESH_1.getFaces().addAll(0,0,1,1,2,2,0,0,2,2,3,3,0,0,3,3,4,4,0,0,4,4,5,5,0,0,5,5,6,6,0,0,6,6,7,7,0,0,7,7,8,8,0,0,8,8,9,9,0,0,9,9,10,10,0,0,10,10,11,11,0,0,11,11,12,12,0,0,12,12,13,13,0,0,13,13,14,14,0,0,14,14,15,15,0,0,15,15,16,16,0,0,16,16,17,17,0,0,17,17,18,18,0,0,18,18,19,19,0,0,19,19,20,20,0,0,20,20,21,21,0,0,21,21,22,22,0,0,22,22,23,23,0,0,23,23,24,24,0,0,24,24,25,25,0,0,25,25,26,26,0,0,26,26,27,27,0,0,27,27,28,28,0,0,28,28,29,29,0,0,29,29,30,30,0,0,30,30,31,31,0,0,31,31,32,32,0,0,32,32,33,33,0,0,33,33,34,34,0,0,34,34,35,35,0,0,35,35,36,36,0,0,36,36,37,37,0,0,37,37,38,38,0,0,38,38,39,39,0,0,39,39,40,40,0,0,40,40,41,41,0,0,41,41,42,42,0,0,42,42,43,43,0,0,43,43,44,44,0,0,44,44,45,45,0,0,45,45,46,46,0,0,46,46,47,47,0,0,47,47,48,48,0,0,48,48,49,49,0,0,49,49,50,50,0,0,50,50,51,51,0,0,51,51,52,52,0,0,52,52,53,53,0,0,53,53,54,54,0,0,54,54,55,55,0,0,55,55,56,56,0,0,56,56,57,57,0,0,57,57,58,58,0,0,58,58,59,59,0,0,59,59,60,60,0,0,60,60,61,61,0,0,61,61,62,62,0,0,62,62,63,63,0,0,63,63,64,64,0,0,64,64,65,65,0,0,65,65,66,66,0,0,66,66,67,67,0,0,67,67,68,68,0,0,68,68,69,69,0,0,69,69,70,70,0,0,70,70,71,71,0,0,71,71,72,72,0,0,72,72,73,73,0,0,73,73,74,74,0,0,74,74,75,75,0,0,75,75,76,76,77,77,78,78,79,76,77,77,79,76,80,79,77,77,80,79,81,80,77,77,81,80,82,81,77,77,82,81,83,82,77,77,83,82,84,83,77,77,84,83,85,84,77,77,85,84,86,85,77,77,86,85,87,86,77,77,87,86,88,87,77,77,88,87,89,88,77,77,89,88,90,89,77,77,90,89,91,90,77,77,91,90,92,91,77,77,92,91,93,92,77,77,93,92,94,93,77,77,94,93,95,94,77,77,95,94,96,95,77,77,96,95,97,96,77,77,97,96,98,97,77,77,98,97,99,98,77,77,99,98,100,99,77,77,100,99,101,100,77,77,101,100,102,101,77,77,102,101,103,102,77,77,103,102,104,103,77,77,104,103,105,104,77,77,105,104,106,105,77,77,106,105,107,106,77,77,107,106,108,107,77,77,108,107,109,108,77,77,109,108,110,109,77,77,110,109,111,110,77,77,111,110,112,111,77,77,112,111,113,112,77,77,113,112,114,113,77,77,114,113,115,114,77,77,115,114,116,115,77,77,116,115,117,116,77,77,117,116,118,117,77,77,118,117,119,118,77,77,119,118,120,119,77,77,120,119,121,120,77,77,121,120,122,121,77,77,122,121,123,122,77,77,123,122,124,123,77,77,124,123,125,124,77,77,125,124,126,125,77,77,126,125,127,126,77,77,127,126,128,127,77,77,128,127,129,128,77,77,129,128,130,129,77,77,130,129,131,130,77,77,131,130,132,131,77,77,132,131,133,132,77,77,133,132,134,133,77,77,134,133,135,134,77,77,135,134,136,135,77,77,136,135,137,136,77,77,137,136,138,137,77,77,138,137,139,138,77,77,139,138,140,139,77,77,140,139,141,140,77,77,141,140,142,141,77,77,142,141,143,142,77,77,143,142,144,143,77,77,144,143,145,144,77,77,145,144,146,145,77,77,146,145,147,146,77,77,147,146,148,147,77,77,148,147,149,148,77,77,149,148,150,149,77,77,150,149,151,150,77,77,151,150,152,151,77,77,152,151,153,152,154,153,155,154,156,155,154,153,156,155,157,156,158,157,159,158,160,159,158,157,160,159,161,160,162,161,163,162,164,163,162,161,164,163,165,164,166,165,167,166,168,167,166,165,168,167,169,168,170,169,171,170,172,171,170,169,172,171,173,172,174,173,175,174,176,175,174,173,176,175,177,176,178,177,179,178,180,179,178,177,180,179,181,180,182,181,183,182,184,183,182,181,184,183,185,184,186,185,187,186,188,187,186,185,188,187,189,188,190,189,191,190,192,191,190,189,192,191,193,192,194,193,195,194,196,195,194,193,196,195,197,196,198,197,199,198,200,199,198,197,200,199,201,200,202,201,203,202,204,203,202,201,204,203,205,204,206,205,207,206,208,207,206,205,208,207,209,208,210,209,211,210,212,211,210,209,212,211,213,212,214,213,215,214,216,215,214,213,216,215,217,216,218,217,219,218,220,219,218,217,220,219,221,220,222,221,218,222,221,223,222,221,221,223,223,224,224,225,222,226,223,227,224,225,223,227,225,228,226,229,227,230,228,231,226,229,228,231,229,232,230,233,231,234,232,235,230,233,232,235,233,236,234,237,235,238,236,239,234,237,236,239,237,240,238,241,239,242,240,243,238,241,240,243,241,244,242,245,243,246,244,247,242,245,244,247,245,248,246,249,247,250,248,251,246,249,248,251,249,252,250,253,251,254,252,255,250,253,252,255,253,256,254,257,255,258,256,259,254,257,256,259,257,260,258,261,259,262,260,263,258,261,260,263,261,264,262,265,263,266,264,267,262,265,264,267,265,268,266,269,267,270,268,271,266,269,268,271,269,272,270,273,271,274,272,275,270,273,272,275,273,276,274,277,275,278,276,279,274,277,276,279,277,280,278,281,279,282,280,283,278,281,280,283,281,284,282,285,283,286,284,287,282,285,284,287,285,288,286,289,287,290,288,291,286,289,288,291,289,292,290,293,291,294,292,295,290,293,292,295,293,296,294,297,295,298,296,299,294,297,296,299,297,300,298,301,299,302,300,303,298,301,300,303,301,304,302,305,303,306,304,307,302,305,304,307,305,308,306,309,307,310,308,311,306,309,308,311,309,312,310,313,311,314,312,315,310,313,312,315,313,316,314,317,315,318,316,319,314,317,316,319,317,320,318,321,319,322,320,323,318,321,320,323,321,324,322,325,323,326,324,327,322,325,324,327,325,328,326,329,327,330,328,331,326,329,328,331,329,332,330,333,331,334,332,335,330,333,332,335,333,336,334,337,335,338,336,339,334,337,336,339,337,340,338,341,339,342,340,343,338,341,340,343,341,344,342,345,343,346,344,347,342,345,344,347,345,348,346,349,347,350,348,351,346,349,348,351,349,352,350,353,351,354,352,355,350,353,352,355,353,356,354,357,355,358,356,359,354,357,356,359,357,360,358,361,359,362,360,363,358,361,360,363,361,364,362,365,358,366,361,367,362,365,361,367,363,368,364,369,362,370,363,371,364,369,363,371,365,372,366,373,367,374,368,375,366,373,368,375,369,376,370,377,371,378,372,379,370,377,372,379,373,380,374,381,375,382,376,383,374,381,376,383,377,384,378,385,379,386,380,387,378,385,380,387,381,388,382,389,383,390,384,391,382,389,384,391,385,392,386,393,387,394,388,395,386,393,388,395,389,396,390,397,391,398,392,399,390,397,392,399,393,400,394,401,395,402,396,403,394,401,396,403,397,404,398,405,399,406,400,407,398,405,400,407,401,408,402,409,403,410,404,411,402,409,404,411,405,412,406,413,407,414,408,415,406,413,408,415,409,416,410,417,411,418,412,419,410,417,412,419,413,420,414,421,415,422,416,423,414,421,416,423,417,424,418,425,419,426,420,427,418,425,420,427,421,428,422,429,423,430,424,431,422,429,424,431,425,432,426,433,427,434,428,435,426,433,428,435,429,436,430,437,431,438,432,439,430,437,432,439,433,440,434,441,435,442,436,443,434,441,436,443,437,444,438,445,439,446,440,447,438,445,440,447,441,448,442,449,443,450,444,451,442,449,444,451,445,452,446,453,447,454,448,455,446,453,448,455,449,456,450,457,451,458,452,459,450,457,452,459,453,460);
    }
    private static void method6(){
        MESH_1.getFaceSmoothingGroups().ensureCapacity(304);
        MESH_1.getFaceSmoothingGroups().addAll(1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,256,256,128,128,64,64,32,32,16,16,8,8,4,4,2,2,1,1,-2147483648,-2147483648,1073741824,1073741824,536870912,536870912,268435456,268435456,134217728,134217728,67108864,67108864,33554432,33554432,16777216,16777216,16777216,16777216,16777216,16777216,8388608,8388608,4194304,4194304,2097152,2097152,1048576,1048576,524288,524288,262144,262144,131072,131072,65536,65536,32768,32768,16384,16384,8192,8192,4096,4096,2048,2048,1024,1024,512,512,256,256,128,128,64,64,32,32,16,16,8,8,4,4,2,2,1,1,-2147483648,-2147483648,1073741824,1073741824,536870912,536870912,268435456,268435456,134217728,134217728,67108864,67108864,33554432,33554432,16777216,16777216,8388608,8388608,4194304,4194304,4194304,4194304,4194304,4194304,2097152,2097152,1048576,1048576,524288,524288,262144,262144,131072,131072,65536,65536,32768,32768,16384,16384,8192,8192,4096,4096,2048,2048,1024,1024,512,512,256,256,128,128,64,64,32,32,16,16,8,8,4,4,2,2,1,1);
        NODE_3 = MESHVIEWS[2];
        MESHVIEWS[2].setId("Needle (2)");
        MESHVIEWS[2].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_2 = new PhongMaterial();
        MATERIAL_2.setDiffuseColor(new Color(1.0,1.0,1.0,1.0));
        MATERIAL_2.setSpecularColor(new Color(1.0,1.0,1.0,1.0));
        MATERIAL_2.setSpecularPower(80.0);
        MESHVIEWS[2].setMaterial(MATERIAL_2);
        MESH_2 = new TriangleMesh();
        MESHVIEWS[2].setMesh(MESH_2);
        MESH_2.getPoints().ensureCapacity(42);
        MESH_2.getPoints().addAll(-0.022029f,0.014133f,-0.022978f,6.45E-4f,0.014133f,-0.145065f,5.26E-4f,0.016555f,-0.022978f,6.45E-4f,0.01277f,-0.145065f,0.023318f,0.01277f,-0.022978f,0.023318f,0.014133f,-0.022978f,6.45E-4f,0.014133f,-0.145065f,-0.022029f,0.01277f,-0.022978f,6.45E-4f,0.01277f,-0.145065f,6.45E-4f,0.014133f,-0.145065f,-0.022029f,0.014133f,-0.022978f,0.023318f,0.014133f,-0.022978f,5.26E-4f,0.016555f,-0.022978f,6.45E-4f,0.014133f,-0.145065f);
    }
    private static void method7(){
        MESH_2.getTexCoords().ensureCapacity(28);
        MESH_2.getTexCoords().addAll(3.075868f,1.538228f,5.878896f,1.538228f,3.168831f,1.013848f,-5.69918f,1.0f,-2.896152f,1.0f,-2.896152f,0.912126f,-5.69918f,0.912126f,3.075868f,1.0f,5.878896f,1.0f,5.878896f,0.912126f,3.075868f,0.912126f,-2.896152f,2.463614f,-2.990094f,1.934196f,-5.69918f,2.463614f);
    }
    private static void method8(){
        MESH_2.getFaces().ensureCapacity(36);
        MESH_2.getFaces().addAll(0,0,1,1,2,2,3,3,4,4,5,5,3,3,5,5,6,6,7,7,8,8,9,9,7,7,9,9,10,10,11,11,12,12,13,13);
    }
    private static void method9(){
        MESH_2.getFaceSmoothingGroups().ensureCapacity(6);
        MESH_2.getFaceSmoothingGroups().addAll(0,2,2,1,1,0);
        NODE_4 = MESHVIEWS[3];
        MESHVIEWS[3].setId("N");
        MESHVIEWS[3].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_3 = new PhongMaterial();
        MATERIAL_3.setDiffuseColor(new Color(0.3294120132923126,0.3294120132923126,0.3294120132923126,1.0));
        MATERIAL_3.setSpecularColor(new Color(0.33000001311302185,0.33000001311302185,0.33000001311302185,1.0));
        MATERIAL_3.setSpecularPower(64.0);
        MESHVIEWS[3].setMaterial(MATERIAL_3);
        MESH_3 = new TriangleMesh();
        MESHVIEWS[3].setMesh(MESH_3);
        MESH_3.getPoints().ensureCapacity(180);
        MESH_3.getPoints().addAll(-0.005039f,0.009648f,0.115907f,-0.002181f,0.009648f,0.115907f,0.003012f,0.009648f,0.125012f,0.003012f,0.009648f,0.115907f,0.005552f,0.009648f,0.115907f,0.005552f,0.009648f,0.128949f,0.002827f,0.009648f,0.128949f,-0.0025f,0.009648f,0.119685f,-0.0025f,0.009648f,0.128949f,-0.005039f,0.009648f,0.128949f,-0.002181f,0.013137f,0.115907f,-0.005039f,0.013137f,0.115907f,-0.005039f,0.013137f,0.128949f,-0.0025f,0.013137f,0.128949f,-0.0025f,0.013137f,0.119685f,0.002827f,0.013137f,0.128949f,0.005552f,0.013137f,0.128949f,0.005552f,0.013137f,0.115907f,0.003012f,0.013137f,0.115907f,0.003012f,0.013137f,0.125012f,-0.002181f,0.009648f,0.115907f,-0.005039f,0.009648f,0.115907f,-0.005039f,0.013137f,0.115907f,-0.002181f,0.013137f,0.115907f,0.003012f,0.009648f,0.125012f,-0.002181f,0.009648f,0.115907f,-0.002181f,0.013137f,0.115907f,0.003012f,0.013137f,0.125012f,0.003012f,0.009648f,0.115907f,0.003012f,0.009648f,0.125012f,0.003012f,0.013137f,0.125012f,0.003012f,0.013137f,0.115907f,0.005552f,0.009648f,0.115907f,0.003012f,0.009648f,0.115907f,0.003012f,0.013137f,0.115907f,0.005552f,0.013137f,0.115907f,0.005552f,0.009648f,0.128949f,0.005552f,0.009648f,0.115907f,0.005552f,0.013137f,0.115907f,0.005552f,0.013137f,0.128949f,0.002827f,0.009648f,0.128949f,0.005552f,0.009648f,0.128949f,0.005552f,0.013137f,0.128949f,0.002827f,0.013137f,0.128949f,-0.0025f,0.009648f,0.119685f,0.002827f,0.009648f,0.128949f,0.002827f,0.013137f,0.128949f,-0.0025f,0.013137f,0.119685f,-0.0025f,0.009648f,0.128949f,-0.0025f,0.009648f,0.119685f,-0.0025f,0.013137f,0.119685f,-0.0025f,0.013137f,0.128949f,-0.005039f,0.009648f,0.128949f,-0.0025f,0.009648f,0.128949f,-0.0025f,0.013137f,0.128949f,-0.005039f,0.013137f,0.128949f,-0.005039f,0.009648f,0.115907f,-0.005039f,0.009648f,0.128949f,-0.005039f,0.013137f,0.128949f,-0.005039f,0.013137f,0.115907f);
    }
    private static void method10(){
        MESH_3.getTexCoords().ensureCapacity(86);
        MESH_3.getTexCoords().addAll(0.0f,0.705611f,-0.06451f,0.705611f,-0.181746f,0.911124f,-0.181746f,0.705611f,-0.239066f,0.705611f,-0.239066f,1.0f,-0.177552f,1.0f,-0.05732f,0.790892f,-0.05732f,1.0f,0.0f,1.0f,0.06451f,0.705611f,0.05732f,1.0f,0.05732f,0.790892f,0.177552f,1.0f,0.239066f,1.0f,0.239066f,0.705611f,0.181746f,0.705611f,0.181746f,0.911124f,-0.06451f,1.0f,0.0f,0.92126f,-0.06451f,0.92126f,-0.012858f,1.0f,0.223744f,1.0f,0.223744f,0.92126f,-0.012858f,0.92126f,-0.294389f,1.0f,-0.088876f,1.0f,-0.088876f,0.92126f,-0.294389f,0.92126f,-0.181746f,1.0f,-0.181746f,0.92126f,-0.239066f,0.92126f,0.294389f,1.0f,0.294389f,0.92126f,0.239066f,0.92126f,0.177552f,0.92126f,-0.152708f,1.0f,0.088502f,1.0f,0.088502f,0.92126f,-0.152708f,0.92126f,0.209108f,1.0f,0.209108f,0.92126f,0.05732f,0.92126f);
    }
    private static void method11(){
        MESH_3.getFaces().ensureCapacity(216);
        MESH_3.getFaces().addAll(0,0,1,1,2,2,0,0,2,2,3,3,0,0,3,3,4,4,0,0,4,4,5,5,0,0,5,5,6,6,0,0,6,6,7,7,0,0,7,7,8,8,0,0,8,8,9,9,10,10,11,0,12,9,10,10,12,9,13,11,10,10,13,11,14,12,10,10,14,12,15,13,10,10,15,13,16,14,10,10,16,14,17,15,10,10,17,15,18,16,10,10,18,16,19,17,20,18,21,9,22,19,20,18,22,19,23,20,24,21,25,22,26,23,24,21,26,23,27,24,28,25,29,26,30,27,28,25,30,27,31,28,32,5,33,29,34,30,32,5,34,30,35,31,36,9,37,32,38,33,36,9,38,33,39,19,40,13,41,14,42,34,40,13,42,34,43,35,44,36,45,37,46,38,44,36,46,38,47,39,48,9,49,40,50,41,48,9,50,41,51,19,52,9,53,11,54,42,52,9,54,42,55,19,56,25,57,9,58,19,56,25,58,19,59,28);
    }
    private static void method12(){
        MESH_3.getFaceSmoothingGroups().ensureCapacity(36);
        MESH_3.getFaceSmoothingGroups().addAll(2048,2048,2048,2048,2048,2048,2048,2048,1024,1024,1024,1024,1024,1024,1024,1024,512,512,256,256,128,128,64,64,32,32,16,16,8,8,4,4,2,2,1,1);
        NODE_5 = MESHVIEWS[4];
        MESHVIEWS[4].setId("Mesh2 (2)");
        MESHVIEWS[4].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_4 = new PhongMaterial();
        MATERIAL_4.setDiffuseColor(new Color(0.7333329916000366,0.764706015586853,0.7960780262947083,1.0));
        MATERIAL_4.setSpecularColor(new Color(0.33000001311302185,0.33000001311302185,0.33000001311302185,1.0));
        MATERIAL_4.setSpecularPower(64.0);
        MESHVIEWS[4].setMaterial(MATERIAL_4);
        MESH_4 = new TriangleMesh();
        MESHVIEWS[4].setMesh(MESH_4);
        MESH_4.getPoints().ensureCapacity(3600);
        MESH_4.getPoints().addAll(6.45E-4f,0.023078f,-0.027862f,1.34E-4f,0.023078f,-0.027835f,-3.71E-4f,0.023078f,-0.027755f,-8.65E-4f,0.023078f,-0.027623f,-0.001342f,0.023078f,-0.027439f,-0.001797f,0.023078f,-0.027207f,-0.002226f,0.023078f,-0.026929f,-0.002623f,0.023078f,-0.026607f,-0.002985f,0.023078f,-0.026246f,-0.003306f,0.023078f,-0.025849f,-0.003585f,0.023078f,-0.02542f,-0.003817f,0.023078f,-0.024964f,-0.004f,0.023078f,-0.024487f,-0.004132f,0.023078f,-0.023993f,-0.004212f,0.023078f,-0.023489f,-0.004239f,0.023078f,-0.022978f,-0.004212f,0.023078f,-0.022468f,-0.004132f,0.023078f,-0.021963f,-0.004f,0.023078f,-0.021469f,-0.003817f,0.023078f,-0.020992f,-0.003585f,0.023078f,-0.020536f,-0.003306f,0.023078f,-0.020108f,-0.002985f,0.023078f,-0.01971f,-0.002623f,0.023078f,-0.019349f,-0.002226f,0.023078f,-0.019027f,-0.001797f,0.023078f,-0.018749f,-0.001342f,0.023078f,-0.018517f,-8.65E-4f,0.023078f,-0.018334f,-3.71E-4f,0.023078f,-0.018201f,1.34E-4f,0.023078f,-0.018121f,6.45E-4f,0.023078f,-0.018095f,0.001155f,0.023078f,-0.018121f,0.00166f,0.023078f,-0.018201f,0.002154f,0.023078f,-0.018334f,0.002631f,0.023078f,-0.018517f,0.003086f,0.023078f,-0.018749f,0.003515f,0.023078f,-0.019027f,0.003912f,0.023078f,-0.019349f,0.004274f,0.023078f,-0.01971f,0.004595f,0.023078f,-0.020108f,0.004874f,0.023078f,-0.020536f,0.005106f,0.023078f,-0.020992f,0.005289f,0.023078f,-0.021469f,0.005421f,0.023078f,-0.021963f,0.005501f,0.023078f,-0.022468f,0.005528f,0.023078f,-0.022978f,0.005501f,0.023078f,-0.023489f,0.005421f,0.023078f,-0.023993f,0.005289f,0.023078f,-0.024487f,0.005106f,0.023078f,-0.024964f,0.004874f,0.023078f,-0.02542f,0.004595f,0.023078f,-0.025849f,0.004274f,0.023078f,-0.026246f,0.003912f,0.023078f,-0.026607f,0.003515f,0.023078f,-0.026929f,0.003086f,0.023078f,-0.027207f,0.002631f,0.023078f,-0.027439f,0.002154f,0.023078f,-0.027623f,0.00166f,0.023078f,-0.027755f,0.001155f,0.023078f,-0.027835f,0.011273f,0.009648f,-0.013408f,0.011273f,0.01959f,-0.013408f,0.010214f,0.01959f,-0.01235f,0.010214f,0.009648f,-0.01235f,0.002139f,0.01959f,-0.008755f,0.003618f,0.01959f,-0.008989f,0.00166f,0.023078f,-0.018201f,0.001155f,0.023078f,-0.018121f,-0.006506f,0.009648f,-0.010593f,-0.006506f,0.01959f,-0.010593f,-0.007762f,0.01959f,-0.011408f,-0.007762f,0.009648f,-0.011408f,0.014868f,0.01959f,-0.024473f,0.014634f,0.01959f,-0.025952f,0.005421f,0.023078f,-0.023993f,0.005501f,0.023078f,-0.023489f,0.012215f,0.01959f,-0.014572f,0.01303f,0.01959f,-0.015827f,0.004874f,0.023078f,-0.020536f,0.004595f,0.023078f,-0.020108f,0.175054f,4.92E-4f,-0.022978f,0.162845f,-0.025757f,-0.022978f,0.162525f,-0.025757f,-0.033163f,0.17471f,4.92E-4f,-0.033929f,0.007795f,0.009648f,-0.010593f,0.007795f,0.01959f,-0.010593f,0.006462f,0.01959f,-0.009913f,0.006462f,0.009648f,-0.009913f,0.009051f,0.009648f,-0.011408f,0.009051f,0.01959f,-0.011408f,0.005064f,0.009648f,-0.009376f,0.005064f,0.01959f,-0.009376f,0.003618f,0.01959f,-0.008989f,0.003618f,0.009648f,-0.008989f,0.116961f,0.026741f,-0.132207f,0.109873f,0.026741f,-0.139295f,0.114425f,0.009648f,-0.144141f,0.121808f,0.009648f,-0.136758f,-0.164257f,0.009648f,-0.04381f,-0.162623f,0.009648f,-0.054123f,-0.156093f,0.026741f,-0.052877f,-0.157661f,0.026741f,-0.042977f,0.071414f,0.009648f,0.127415f,0.068583f,0.026741f,0.121399f,0.077515f,0.026741f,0.116849f,0.080718f,0.009648f,0.122675f,6.45E-4f,0.009648f,-0.18919f,6.45E-4f,0.026741f,-0.182542f,-0.009375f,0.026741f,-0.182227f,-0.009792f,0.009648f,-0.188862f,-0.153896f,0.009648f,0.038209f,-0.157433f,0.009648f,0.028384f,-0.151109f,0.026741f,0.02633f,-0.147714f,0.026741f,0.035761f,0.011081f,0.009648f,-0.188862f,0.010664f,0.026741f,-0.182227f,-0.139693f,0.009648f,-0.112039f,-0.133824f,0.009648f,-0.120675f,-0.128445f,0.026741f,-0.116767f,-0.134079f,0.026741f,-0.108477f,0.155195f,0.026741f,-0.06266f,0.152399f,0.026741f,-0.072286f,0.158722f,0.009648f,-0.07434f,0.161635f,0.009648f,-0.064313f,-0.020187f,0.009648f,-0.18788f,-0.019354f,0.026741f,-0.181283f,-0.029255f,0.026741f,-0.179715f,-0.0305f,0.009648f,-0.186246f,-0.040691f,0.009648f,-0.183968f,-0.039037f,0.026741f,-0.177529f,-0.048663f,0.026741f,-0.174732f,-0.050718f,0.009648f,-0.181055f,-0.149749f,0.009648f,-0.093748f,-0.145008f,0.009648f,-0.103051f,-0.139182f,0.026741f,-0.099848f,-0.143733f,0.026741f,-0.090917f,-0.127424f,0.009648f,0.082969f,-0.133824f,0.009648f,0.074719f,-0.128445f,0.026741f,0.070811f,-0.122301f,0.026741f,0.078732f,-0.127424f,0.009648f,-0.128926f,-0.122301f,0.026741f,-0.124688f,0.15895f,0.026741f,-0.002979f,0.159893f,0.026741f,-0.012959f,0.166529f,0.009648f,-0.012542f,0.165546f,0.009648f,-0.002146f,0.052007f,0.009648f,-0.181055f,0.049952f,0.026741f,-0.174732f,0.040326f,0.026741f,-0.177529f,0.04198f,0.009648f,-0.183968f,0.021476f,0.009648f,0.141923f,0.020643f,0.026741f,0.135327f,0.030544f,0.026741f,0.133759f,0.03179f,0.009648f,0.14029f,-0.079429f,0.009648f,0.122675f,-0.076226f,0.026741f,0.116849f,-0.067294f,0.026741f,0.121399f,-0.070125f,0.009648f,0.127415f,0.031038f,-0.025757f,0.13635f,0.033326f,4.92E-4f,0.148342f,0.022504f,4.92E-4f,0.150056f,0.020974f,-0.025757f,0.137944f,0.01303f,0.009648f,-0.030129f,0.012215f,0.009648f,-0.031384f,0.012215f,0.01959f,-0.031384f,0.01303f,0.01959f,-0.030129f,0.069706f,-0.025757f,0.123785f,0.074904f,4.92E-4f,0.134832f,0.064849f,4.92E-4f,0.139184f,0.060355f,-0.025757f,0.127832f,-0.00954f,-0.025757f,-0.184859f,-0.010307f,4.92E-4f,-0.197043f,6.45E-4f,4.92E-4f,-0.197387f,6.45E-4f,-0.025757f,-0.185179f,0.011273f,0.01959f,-0.013408f,0.004274f,0.023078f,-0.01971f,0.01303f,0.01959f,-0.030129f,0.012215f,0.01959f,-0.031384f,0.004595f,0.023078f,-0.025849f,0.004874f,0.023078f,-0.02542f,0.014946f,0.01959f,-0.022978f,0.005528f,0.023078f,-0.022978f,-0.013579f,0.01959f,-0.021483f,-0.013344f,0.01959f,-0.020005f,-0.004132f,0.023078f,-0.021963f,-0.004212f,0.023078f,-0.022468f,-0.009984f,0.01959f,-0.032548f,-0.008925f,0.01959f,-0.033606f,-0.008925f,0.009648f,-0.033606f,-0.009984f,0.009648f,-0.032548f,-0.010926f,0.01959f,-0.014572f,-0.009984f,0.01959f,-0.013408f,-0.002985f,0.023078f,-0.01971f,-0.003306f,0.023078f,-0.020108f,-0.158594f,0.026741f,0.028762f,-0.158919f,0.026741f,-0.022978f,-0.161528f,0.026741f,0.018661f,-0.158604f,0.026741f,-0.012959f,-0.157661f,0.026741f,-0.002979f,-0.155031f,0.026741f,0.038658f,-0.156093f,0.026741f,0.006921f,-0.153906f,0.026741f,0.016704f,-0.150853f,0.026741f,0.048311f,-0.151109f,0.026741f,0.02633f,-0.147714f,0.026741f,0.035761f,-0.146078f,0.026741f,0.057683f,-0.143733f,0.026741f,0.044961f,-0.140724f,0.026741f,0.066737f,-0.139182f,0.026741f,0.053892f,-0.134812f,0.026741f,0.075437f,-0.134079f,0.026741f,0.06252f,-0.128365f,0.026741f,0.083748f,-0.128445f,0.026741f,0.070811f,-0.122301f,0.026741f,0.078732f,-0.121409f,0.026741f,0.091638f,-0.115672f,0.026741f,0.086251f,-0.113971f,0.026741f,0.099075f,-0.108584f,0.026741f,0.093339f,-0.106081f,0.026741f,0.106031f,-0.101065f,0.026741f,0.099968f,-0.09777f,0.026741f,0.112478f,-0.093145f,0.026741f,0.106112f,-0.089071f,0.026741f,0.11839f,-0.084854f,0.026741f,0.111746f,-0.080017f,0.026741f,0.123745f,-0.076226f,0.026741f,0.116849f,-0.070645f,0.026741f,0.12852f,-0.067294f,0.026741f,0.121399f,-0.060992f,0.026741f,0.132697f,-0.058095f,0.026741f,0.12538f,-0.051095f,0.026741f,0.13626f,-0.048663f,0.026741f,0.128776f,-0.040994f,0.026741f,0.139195f,-0.039037f,0.026741f,0.131573f,-0.030729f,0.026741f,0.141489f,-0.029255f,0.026741f,0.133759f,-0.02034f,0.026741f,0.143135f,-0.019354f,0.026741f,0.135327f,-0.009869f,0.026741f,0.144124f,-0.009375f,0.026741f,0.136271f,6.45E-4f,0.026741f,0.144455f,6.45E-4f,0.026741f,0.136586f,0.010664f,0.026741f,0.136271f,0.011158f,0.026741f,0.144124f,0.020643f,0.026741f,0.135327f,0.021629f,0.026741f,0.143135f,0.030544f,0.026741f,0.133759f,0.032018f,0.026741f,0.141489f,0.040326f,0.026741f,0.131573f,0.042283f,0.026741f,0.139195f,0.049952f,0.026741f,0.128776f,0.052384f,0.026741f,0.13626f,0.059384f,0.026741f,0.12538f,0.062281f,0.026741f,0.132697f,0.068583f,0.026741f,0.121399f,0.071934f,0.026741f,0.12852f,0.077515f,0.026741f,0.116849f,0.081306f,0.026741f,0.123745f,0.086143f,0.026741f,0.111746f,0.09036f,0.026741f,0.11839f,0.094434f,0.026741f,0.106112f,0.099059f,0.026741f,0.112478f,0.102354f,0.026741f,0.099968f,0.10737f,0.026741f,0.106031f,0.109873f,0.026741f,0.093339f,0.11526f,0.026741f,0.099075f,0.116961f,0.026741f,0.086251f,0.122698f,0.026741f,0.091638f,0.12359f,0.026741f,0.078732f,0.129654f,0.026741f,0.083748f,0.129734f,0.026741f,0.070811f,0.136101f,0.026741f,0.075437f,0.135369f,0.026741f,0.06252f,0.140471f,0.026741f,0.053892f,0.142013f,0.026741f,0.066737f,0.145022f,0.026741f,0.044961f,0.147367f,0.026741f,0.057683f,0.149003f,0.026741f,0.035761f,0.152142f,0.026741f,0.048311f,0.152399f,0.026741f,0.02633f,0.15632f,0.026741f,0.038658f,0.155195f,0.026741f,0.016704f,0.157382f,0.026741f,0.006921f,0.159883f,0.026741f,0.028762f,0.15895f,0.026741f,-0.002979f,0.159893f,0.026741f,-0.012959f,0.162817f,0.026741f,0.018661f,0.160208f,0.026741f,-0.022978f,-0.166458f,0.026741f,-0.012465f,-0.166458f,0.026741f,-0.033491f,-0.166788f,0.026741f,-0.022978f,-0.165468f,0.026741f,-0.001993f,-0.165468f,0.026741f,-0.043963f,-0.163823f,0.026741f,-0.054352f,-0.163823f,0.026741f,0.008396f,-0.161528f,0.026741f,-0.064617f,-0.158594f,0.026741f,-0.074718f,-0.158604f,0.026741f,-0.032997f,-0.157661f,0.026741f,-0.042977f,-0.155031f,0.026741f,-0.084614f,-0.156093f,0.026741f,-0.052877f,-0.153906f,0.026741f,-0.06266f,-0.150853f,0.026741f,-0.094268f,-0.151109f,0.026741f,-0.072286f,-0.147714f,0.026741f,-0.081717f,-0.146078f,0.026741f,-0.10364f,-0.143733f,0.026741f,-0.090917f,-0.140724f,0.026741f,-0.112693f,-0.139182f,0.026741f,-0.099848f,-0.134812f,0.026741f,-0.121393f,-0.134079f,0.026741f,-0.108477f,-0.128365f,0.026741f,-0.129704f,-0.128445f,0.026741f,-0.116767f,-0.122301f,0.026741f,-0.124688f,-0.121409f,0.026741f,-0.137594f,-0.115672f,0.026741f,-0.132207f,-0.113971f,0.026741f,-0.145031f,-0.108584f,0.026741f,-0.139295f,-0.106081f,0.026741f,-0.151987f,-0.101065f,0.026741f,-0.145924f,-0.09777f,0.026741f,-0.158434f,-0.093145f,0.026741f,-0.152068f,-0.089071f,0.026741f,-0.164346f,-0.084854f,0.026741f,-0.157702f,-0.080017f,0.026741f,-0.169701f,-0.076226f,0.026741f,-0.162805f,-0.070645f,0.026741f,-0.174476f,-0.067294f,0.026741f,-0.167356f,-0.060992f,0.026741f,-0.178653f,-0.058095f,0.026741f,-0.171337f,-0.051095f,0.026741f,-0.182216f,-0.048663f,0.026741f,-0.174732f,-0.040994f,0.026741f,-0.185151f,-0.039037f,0.026741f,-0.177529f,-0.030729f,0.026741f,-0.187445f,-0.029255f,0.026741f,-0.179715f,-0.02034f,0.026741f,-0.189091f,-0.019354f,0.026741f,-0.181283f,-0.009869f,0.026741f,-0.190081f,-0.009375f,0.026741f,-0.182227f,6.45E-4f,0.026741f,-0.190411f,6.45E-4f,0.026741f,-0.182542f,0.010664f,0.026741f,-0.182227f,0.011158f,0.026741f,-0.190081f,0.020643f,0.026741f,-0.181283f,0.021629f,0.026741f,-0.189091f,0.030544f,0.026741f,-0.179715f,0.032018f,0.026741f,-0.187445f,0.040326f,0.026741f,-0.177529f,0.042283f,0.026741f,-0.185151f,0.049952f,0.026741f,-0.174732f,0.052384f,0.026741f,-0.182216f,0.059384f,0.026741f,-0.171337f,0.062281f,0.026741f,-0.178653f,0.068583f,0.026741f,-0.167356f,0.071934f,0.026741f,-0.174476f,0.077515f,0.026741f,-0.162805f,0.081306f,0.026741f,-0.169701f,0.086143f,0.026741f,-0.157702f,0.09036f,0.026741f,-0.164346f,0.094434f,0.026741f,-0.152068f,0.099059f,0.026741f,-0.158434f,0.102354f,0.026741f,-0.145924f,0.10737f,0.026741f,-0.151987f,0.109873f,0.026741f,-0.139295f,0.11526f,0.026741f,-0.145031f,0.116961f,0.026741f,-0.132207f,0.122698f,0.026741f,-0.137594f,0.12359f,0.026741f,-0.124688f,0.129654f,0.026741f,-0.129704f,0.129734f,0.026741f,-0.116767f,0.136101f,0.026741f,-0.121393f,0.135369f,0.026741f,-0.108477f,0.140471f,0.026741f,-0.099848f,0.142013f,0.026741f,-0.112693f,0.145022f,0.026741f,-0.090917f,0.147367f,0.026741f,-0.10364f,0.149003f,0.026741f,-0.081717f,0.152142f,0.026741f,-0.094268f,0.152399f,0.026741f,-0.072286f,0.15632f,0.026741f,-0.084614f,0.155195f,0.026741f,-0.06266f,0.157382f,0.026741f,-0.052877f,0.159883f,0.026741f,-0.074718f,0.15895f,0.026741f,-0.042977f,0.159893f,0.026741f,-0.032997f,0.162817f,0.026741f,-0.064617f,0.165112f,0.026741f,0.008396f,0.165112f,0.026741f,-0.054352f,0.166757f,0.026741f,-0.001993f,0.166757f,0.026741f,-0.043963f,0.167747f,0.026741f,-0.012465f,0.167747f,0.026741f,-0.033491f,0.168077f,0.026741f,-0.022978f,0.011273f,0.009648f,-0.032548f,0.010214f,0.009648f,-0.033606f,0.010214f,0.01959f,-0.033606f,0.011273f,0.01959f,-0.032548f,-0.124333f,-0.025757f,-0.126369f,-0.13374f,4.92E-4f,-0.134151f,-0.126494f,4.92E-4f,-0.142369f,-0.117595f,-0.025757f,-0.134012f,0.05454f,4.92E-4f,0.142895f,0.050767f,-0.025757f,0.131284f,-0.102746f,-0.025757f,0.102f,-0.110528f,4.92E-4f,0.111407f,-0.118747f,4.92E-4f,0.104161f,-0.110389f,-0.025757f,0.095261f,-0.008925f,0.01959f,-0.01235f,-0.009984f,0.01959f,-0.013408f,-0.009984f,0.009648f,-0.013408f,-0.008925f,0.009648f,-0.01235f,-0.005172f,0.01959f,-0.009913f,-0.003775f,0.01959f,-0.009376f,-8.65E-4f,0.023078f,-0.018334f,-0.001342f,0.023078f,-0.018517f,0.151455f,-0.025757f,0.036732f,0.154907f,-0.025757f,0.027145f,0.166518f,4.92E-4f,0.030917f,0.162806f,4.92E-4f,0.041226f,-0.013579f,0.01959f,-0.021483f,-0.013657f,0.01959f,-0.022978f,-0.013657f,0.009648f,-0.022978f,-0.013579f,0.009648f,-0.021483f,-0.153617f,-0.025757f,-0.073101f,-0.165229f,4.92E-4f,-0.076874f,-0.161517f,4.92E-4f,-0.087182f,-0.150166f,-0.025757f,-0.082688f,0.153481f,4.92E-4f,-0.107f,0.142782f,-0.025757f,-0.101119f,0.137595f,-0.025757f,-0.10989f,0.147903f,4.92E-4f,-0.116431f,-0.012421f,0.01959f,-0.028795f,-0.011741f,0.01959f,-0.030129f,-0.011741f,0.009648f,-0.030129f,-0.012421f,0.009648f,-0.028795f,6.45E-4f,-0.025757f,0.139223f,6.45E-4f,4.92E-4f,0.151431f,-0.010307f,4.92E-4f,0.151087f,-0.00954f,-0.025757f,0.138903f,-0.110389f,-0.025757f,-0.141217f,-0.118747f,4.92E-4f,-0.150117f,-0.110528f,4.92E-4f,-0.157363f,-0.102746f,-0.025757f,-0.147956f,-0.124333f,-0.025757f,0.080413f,-0.13374f,4.92E-4f,0.088195f,-0.140456f,4.92E-4f,0.079537f,-0.130579f,-0.025757f,0.072361f,-0.003775f,0.009648f,-0.03658f,-0.003775f,0.01959f,-0.03658f,-0.002329f,0.01959f,-0.036967f,-0.002329f,0.009648f,-0.036967f,-0.161556f,-0.025757f,-0.022978f,-0.173765f,4.92E-4f,-0.022978f,-0.173421f,4.92E-4f,-0.033929f,-0.161236f,-0.025757f,-0.033163f,-0.059065f,-0.025757f,0.127832f,-0.06356f,4.92E-4f,0.139184f,-0.073615f,4.92E-4f,0.134832f,-0.068417f,-0.025757f,0.123785f,-0.012957f,0.01959f,-0.027398f,-0.012957f,0.009648f,-0.027398f,-0.012421f,0.01959f,-0.017161f,-0.011741f,0.01959f,-0.015827f,-0.003585f,0.023078f,-0.020536f,-0.003817f,0.023078f,-0.020992f,0.014246f,0.01959f,-0.018559f,0.014634f,0.01959f,-0.020005f,0.005421f,0.023078f,-0.021963f,0.005289f,0.023078f,-0.021469f,-0.012957f,0.01959f,-0.018559f,-0.013344f,0.01959f,-0.020005f,-0.013344f,0.009648f,-0.020005f,-0.012957f,0.009648f,-0.018559f,0.007795f,0.009648f,-0.035364f,0.007795f,0.01959f,-0.035364f,0.009051f,0.01959f,-0.034548f,0.009051f,0.009648f,-0.034548f,-8.5E-4f,0.009648f,-0.037201f,-8.5E-4f,0.01959f,-0.037201f,6.45E-4f,0.01959f,-0.03728f,6.45E-4f,0.009648f,-0.03728f,-8.5E-4f,0.01959f,-0.008755f,6.45E-4f,0.01959f,-0.008677f,6.45E-4f,0.023078f,-0.018095f,1.34E-4f,0.023078f,-0.018121f,0.158455f,4.92E-4f,-0.097238f,0.147408f,-0.025757f,-0.09204f,-0.126494f,4.92E-4f,0.096413f,-0.117595f,-0.025757f,0.088056f,0.009051f,0.01959f,-0.034548f,0.007795f,0.01959f,-0.035364f,0.003086f,0.023078f,-0.027207f,0.003515f,0.023078f,-0.026929f,-0.012421f,0.01959f,-0.017161f,-0.012421f,0.009648f,-0.017161f,-0.077496f,-0.025757f,-0.165116f,-0.083378f,4.92E-4f,-0.175814f,-0.073615f,4.92E-4f,-0.180788f,-0.068417f,-0.025757f,-0.169742f,-0.013579f,0.01959f,-0.024473f,-0.013344f,0.01959f,-0.025952f,-0.013344f,0.009648f,-0.025952f,-0.013579f,0.009648f,-0.024473f,-0.136306f,-0.025757f,0.063933f,-0.146614f,4.92E-4f,0.070475f,-0.152191f,4.92E-4f,0.061044f,-0.141493f,-0.025757f,0.055163f,0.153481f,4.92E-4f,0.061044f,0.142782f,-0.025757f,0.055163f,0.147408f,-0.025757f,0.046084f,0.158455f,4.92E-4f,0.051282f,0.159972f,-0.025757f,-0.053371f,0.157749f,-0.025757f,-0.063316f,0.169574f,4.92E-4f,-0.066352f,0.171965f,4.92E-4f,-0.055659f,0.104035f,-0.025757f,-0.147956f,0.111817f,4.92E-4f,-0.157363f,0.120036f,4.92E-4f,-0.150117f,0.111679f,-0.025757f,-0.141217f,0.118884f,-0.025757f,0.088056f,0.125622f,-0.025757f,0.080413f,0.135029f,4.92E-4f,0.088195f,0.127783f,4.92E-4f,0.096413f,0.006462f,0.009648f,-0.036043f,0.006462f,0.01959f,-0.036043f,0.118884f,-0.025757f,-0.134012f,0.127783f,4.92E-4f,-0.142369f,0.005064f,0.009648f,-0.03658f,0.005064f,0.01959f,-0.03658f,-0.172389f,4.92E-4f,-0.001119f,-0.173421f,4.92E-4f,-0.012027f,-0.161236f,-0.025757f,-0.012793f,-0.160277f,-0.025757f,-0.002649f,0.003618f,0.009648f,-0.036967f,0.003618f,0.01959f,-0.036967f,-0.15646f,-0.025757f,0.01736f,-0.168285f,4.92E-4f,0.020396f,-0.170675f,4.92E-4f,0.009703f,-0.158683f,-0.025757f,0.007415f,0.014868f,0.009648f,-0.024473f,0.014634f,0.009648f,-0.025952f,0.014634f,0.01959f,-0.025952f,0.014868f,0.01959f,-0.024473f,0.002139f,0.009648f,-0.037201f,0.002139f,0.01959f,-0.037201f,0.006462f,0.01959f,-0.036043f,0.002631f,0.023078f,-0.027439f,0.161566f,-0.025757f,-0.002649f,0.162525f,-0.025757f,-0.012793f,0.17471f,4.92E-4f,-0.012027f,0.173679f,4.92E-4f,-0.001119f,-0.165229f,4.92E-4f,0.030917f,-0.153617f,-0.025757f,0.027145f,-0.102746f,-0.025757f,-0.147956f,-0.094695f,-0.025757f,-0.154201f,-0.086267f,-0.025757f,-0.159929f,-0.077496f,-0.025757f,-0.165116f,-0.068417f,-0.025757f,-0.169742f,-0.059065f,-0.025757f,-0.173788f,-0.049478f,-0.025757f,-0.17724f,-0.039693f,-0.025757f,-0.180083f,-0.029749f,-0.025757f,-0.182306f,-0.019685f,-0.025757f,-0.1839f,-0.00954f,-0.025757f,-0.184859f,6.45E-4f,-0.025757f,-0.185179f,0.010829f,-0.025757f,-0.184859f,0.020974f,-0.025757f,-0.1839f,0.031038f,-0.025757f,-0.182306f,0.040982f,-0.025757f,-0.180083f,0.050767f,-0.025757f,-0.17724f,0.060355f,-0.025757f,-0.173788f,0.069706f,-0.025757f,-0.169742f,0.078785f,-0.025757f,-0.165116f,0.087556f,-0.025757f,-0.159929f,0.095984f,-0.025757f,-0.154201f,0.104035f,-0.025757f,-0.147956f,0.111679f,-0.025757f,-0.141217f,0.118884f,-0.025757f,-0.134012f,0.125622f,-0.025757f,-0.126369f,0.131868f,-0.025757f,-0.118317f,0.137595f,-0.025757f,-0.10989f,0.142782f,-0.025757f,-0.101119f,0.147408f,-0.025757f,-0.09204f,0.151455f,-0.025757f,-0.082688f,0.154907f,-0.025757f,-0.073101f,0.157749f,-0.025757f,-0.063316f,0.159972f,-0.025757f,-0.053371f,0.161566f,-0.025757f,-0.043307f,0.162525f,-0.025757f,-0.033163f,0.162845f,-0.025757f,-0.022978f,0.162525f,-0.025757f,-0.012793f,0.161566f,-0.025757f,-0.002649f,0.159972f,-0.025757f,0.007415f,0.157749f,-0.025757f,0.01736f,0.154907f,-0.025757f,0.027145f,0.151455f,-0.025757f,0.036732f,0.147408f,-0.025757f,0.046084f,0.142782f,-0.025757f,0.055163f,0.137595f,-0.025757f,0.063933f,0.131868f,-0.025757f,0.072361f,0.125622f,-0.025757f,0.080413f,0.118884f,-0.025757f,0.088056f,0.111679f,-0.025757f,0.095261f,0.104035f,-0.025757f,0.102f,0.095984f,-0.025757f,0.108245f,0.087556f,-0.025757f,0.113972f,0.078785f,-0.025757f,0.119159f,0.069706f,-0.025757f,0.123785f,0.060355f,-0.025757f,0.127832f,0.050767f,-0.025757f,0.131284f,0.040982f,-0.025757f,0.134127f,0.031038f,-0.025757f,0.13635f,0.020974f,-0.025757f,0.137944f,0.010829f,-0.025757f,0.138903f,6.45E-4f,-0.025757f,0.139223f,-0.00954f,-0.025757f,0.138903f,-0.019685f,-0.025757f,0.137944f,-0.029749f,-0.025757f,0.13635f,-0.039693f,-0.025757f,0.134127f,-0.049478f,-0.025757f,0.131284f,-0.059065f,-0.025757f,0.127832f,-0.068417f,-0.025757f,0.123785f,-0.077496f,-0.025757f,0.119159f,-0.086267f,-0.025757f,0.113972f,-0.094695f,-0.025757f,0.108245f,-0.102746f,-0.025757f,0.102f,-0.110389f,-0.025757f,0.095261f,-0.117595f,-0.025757f,0.088056f,-0.124333f,-0.025757f,0.080413f,-0.130579f,-0.025757f,0.072361f,-0.136306f,-0.025757f,0.063933f,-0.141493f,-0.025757f,0.055163f,-0.146119f,-0.025757f,0.046084f,-0.150166f,-0.025757f,0.036732f,-0.153617f,-0.025757f,0.027145f,-0.15646f,-0.025757f,0.01736f,-0.158683f,-0.025757f,0.007415f,-0.160277f,-0.025757f,-0.002649f,-0.161236f,-0.025757f,-0.012793f,-0.161556f,-0.025757f,-0.022978f,-0.161236f,-0.025757f,-0.033163f,-0.160277f,-0.025757f,-0.043307f,-0.158683f,-0.025757f,-0.053371f,-0.15646f,-0.025757f,-0.063316f,-0.153617f,-0.025757f,-0.073101f,-0.150166f,-0.025757f,-0.082688f,-0.146119f,-0.025757f,-0.09204f,-0.141493f,-0.025757f,-0.101119f,-0.136306f,-0.025757f,-0.10989f,-0.130579f,-0.025757f,-0.118317f,-0.124333f,-0.025757f,-0.126369f,-0.117595f,-0.025757f,-0.134012f,-0.110389f,-0.025757f,-0.141217f,-0.029749f,-0.025757f,0.13635f,-0.032036f,4.92E-4f,0.148342f,-0.042729f,4.92E-4f,0.145952f,-0.039693f,-0.025757f,0.134127f,-0.157166f,4.92E-4f,-0.097238f,-0.152191f,4.92E-4f,-0.107f,-0.141493f,-0.025757f,-0.101119f,-0.146119f,-0.025757f,-0.09204f,0.014946f,0.009648f,-0.022978f,0.014946f,0.01959f,-0.022978f,0.010214f,0.01959f,-0.033606f,0.003912f,0.023078f,-0.026607f,-0.008925f,0.01959f,-0.01235f,-0.002623f,0.023078f,-0.019349f,-0.006506f,0.01959f,-0.035364f,-0.007762f,0.01959f,-0.034548f,-0.002226f,0.023078f,-0.026929f,-0.001797f,0.023078f,-0.027207f,-0.013344f,0.01959f,-0.025952f,-0.013579f,0.01959f,-0.024473f,-0.004212f,0.023078f,-0.023489f,-0.004132f,0.023078f,-0.023993f,-0.083378f,4.92E-4f,0.129858f,-0.077496f,-0.025757f,0.119159f,0.011273f,0.01959f,-0.032548f,0.004274f,0.023078f,-0.026246f,0.159972f,-0.025757f,0.007415f,0.171965f,4.92E-4f,0.009703f,-0.092809f,4.92E-4f,0.124281f,-0.086267f,-0.025757f,0.113972f,-0.021215f,4.92E-4f,0.150056f,-0.019685f,-0.025757f,0.137944f,-0.136306f,-0.025757f,-0.10989f,-0.146614f,4.92E-4f,-0.116431f,-0.140456f,4.92E-4f,-0.125493f,-0.130579f,-0.025757f,-0.118317f,-0.010926f,0.01959f,-0.031384f,-0.011741f,0.01959f,-0.030129f,-0.003585f,0.023078f,-0.02542f,-0.003306f,0.023078f,-0.025849f,-0.005172f,0.009648f,-0.009913f,-0.005172f,0.01959f,-0.009913f,0.125622f,-0.025757f,-0.126369f,0.135029f,4.92E-4f,-0.134151f,0.060355f,-0.025757f,-0.173788f,0.064849f,4.92E-4f,-0.18514f,0.074904f,4.92E-4f,-0.180788f,0.069706f,-0.025757f,-0.169742f,0.01371f,0.009648f,-0.017161f,0.014246f,0.009648f,-0.018559f,0.014246f,0.01959f,-0.018559f,0.01371f,0.01959f,-0.017161f,-0.049478f,-0.025757f,0.131284f,-0.053251f,4.92E-4f,0.142895f,-0.012957f,0.01959f,-0.018559f,-0.004f,0.023078f,-0.021469f,0.131868f,-0.025757f,0.072361f,0.137595f,-0.025757f,0.063933f,0.147903f,4.92E-4f,0.070475f,0.141745f,4.92E-4f,0.079537f,-0.010926f,0.01959f,-0.014572f,-0.010926f,0.009648f,-0.014572f,0.007795f,0.01959f,-0.010593f,0.009051f,0.01959f,-0.011408f,0.003515f,0.023078f,-0.019027f,0.003086f,0.023078f,-0.018749f,0.01371f,0.01959f,-0.028795f,0.005106f,0.023078f,-0.024964f,-0.005172f,0.01959f,-0.036043f,-0.001342f,0.023078f,-0.027439f,0.014634f,0.009648f,-0.020005f,0.014634f,0.01959f,-0.020005f,-0.010926f,0.01959f,-0.031384f,-0.010926f,0.009648f,-0.031384f,0.104035f,-0.025757f,0.102f,0.111817f,4.92E-4f,0.111407f,0.10316f,4.92E-4f,0.118122f,0.095984f,-0.025757f,0.108245f,-0.006506f,0.01959f,-0.010593f,-0.001797f,0.023078f,-0.018749f,-0.007762f,0.009648f,-0.034548f,-0.007762f,0.01959f,-0.034548f,-0.006506f,0.01959f,-0.035364f,-0.006506f,0.009648f,-0.035364f,0.005064f,0.01959f,-0.03658f,0.002154f,0.023078f,-0.027623f,-0.101871f,4.92E-4f,0.118122f,-0.094695f,-0.025757f,0.108245f,-0.002329f,0.01959f,-0.008989f,-3.71E-4f,0.023078f,-0.018201f,0.006462f,0.01959f,-0.009913f,0.002631f,0.023078f,-0.018517f,0.012215f,0.009648f,-0.014572f,0.012215f,0.01959f,-0.014572f,-0.012957f,0.01959f,-0.027398f,-0.004f,0.023078f,-0.024487f,0.010829f,-0.025757f,-0.184859f,0.011596f,4.92E-4f,-0.197043f,0.022504f,4.92E-4f,-0.196012f,0.020974f,-0.025757f,-0.1839f,-0.003775f,0.01959f,-0.03658f,-8.65E-4f,0.023078f,-0.027623f,0.031038f,-0.025757f,-0.182306f,0.033326f,4.92E-4f,-0.194298f,0.044018f,4.92E-4f,-0.191908f,0.040982f,-0.025757f,-0.180083f,-0.002329f,0.01959f,-0.036967f,-3.71E-4f,0.023078f,-0.027755f,0.005064f,0.01959f,-0.009376f,0.002154f,0.023078f,-0.018334f,0.094098f,4.92E-4f,0.124281f,0.087556f,-0.025757f,0.113972f,-0.012421f,0.01959f,-0.028795f,-0.003817f,0.023078f,-0.024964f,-0.013657f,0.01959f,-0.022978f,-0.004239f,0.023078f,-0.022978f,-0.003775f,0.009648f,-0.009376f,-0.003775f,0.01959f,-0.009376f,-0.029749f,-0.025757f,-0.182306f,-0.032036f,4.92E-4f,-0.194298f,-0.021215f,4.92E-4f,-0.196012f,-0.019685f,-0.025757f,-0.1839f,-0.008925f,0.01959f,-0.033606f,-0.009984f,0.01959f,-0.032548f,-0.002985f,0.023078f,-0.026246f,-0.002623f,0.023078f,-0.026607f,-0.005172f,0.009648f,-0.036043f,-0.005172f,0.01959f,-0.036043f,-0.06356f,4.92E-4f,-0.18514f,-0.059065f,-0.025757f,-0.173788f,0.157749f,-0.025757f,0.01736f,0.169574f,4.92E-4f,0.020396f,-8.5E-4f,0.01959f,-0.037201f,1.34E-4f,0.023078f,-0.027835f,0.131868f,-0.025757f,-0.118317f,0.141745f,4.92E-4f,-0.125493f,-0.157166f,4.92E-4f,0.051282f,-0.146119f,-0.025757f,0.046084f,-0.172389f,4.92E-4f,-0.044837f,-0.160277f,-0.025757f,-0.043307f,0.01371f,0.01959f,-0.017161f,0.005106f,0.023078f,-0.020992f,-0.161517f,4.92E-4f,0.041226f,-0.150166f,-0.025757f,0.036732f,-0.158683f,-0.025757f,-0.053371f,-0.170675f,4.92E-4f,-0.055659f,-0.168285f,4.92E-4f,-0.066352f,-0.15646f,-0.025757f,-0.063316f,0.014246f,0.009648f,-0.027398f,0.01371f,0.009648f,-0.028795f,0.01371f,0.01959f,-0.028795f,0.014246f,0.01959f,-0.027398f,0.154907f,-0.025757f,-0.073101f,0.166518f,4.92E-4f,-0.076874f,-0.011741f,0.01959f,-0.015827f,-0.011741f,0.009648f,-0.015827f,0.111679f,-0.025757f,0.095261f,0.120036f,4.92E-4f,0.104161f,-0.049478f,-0.025757f,-0.17724f,-0.053251f,4.92E-4f,-0.188851f,-0.042729f,4.92E-4f,-0.191908f,-0.039693f,-0.025757f,-0.180083f,0.002139f,0.01959f,-0.037201f,6.45E-4f,0.01959f,-0.03728f,6.45E-4f,0.023078f,-0.027862f,0.001155f,0.023078f,-0.027835f,0.014868f,0.009648f,-0.021483f,0.014868f,0.01959f,-0.021483f,0.014868f,0.01959f,-0.021483f,0.005501f,0.023078f,-0.022468f,-0.002329f,0.009648f,-0.008989f,-0.002329f,0.01959f,-0.008989f,0.010214f,0.01959f,-0.01235f,0.003912f,0.023078f,-0.019349f,-8.5E-4f,0.009648f,-0.008755f,-8.5E-4f,0.01959f,-0.008755f,-0.007762f,0.01959f,-0.011408f,-0.002226f,0.023078f,-0.019027f,0.040982f,-0.025757f,0.134127f,0.044018f,4.92E-4f,0.145952f,0.084667f,4.92E-4f,-0.175814f,0.078785f,-0.025757f,-0.165116f,0.05454f,4.92E-4f,-0.188851f,0.050767f,-0.025757f,-0.17724f,-0.101871f,4.92E-4f,-0.164078f,-0.094695f,-0.025757f,-0.154201f,0.003618f,0.01959f,-0.036967f,0.00166f,0.023078f,-0.027755f,0.01303f,0.009648f,-0.015827f,0.01303f,0.01959f,-0.015827f,0.084667f,4.92E-4f,0.129858f,0.078785f,-0.025757f,0.119159f,0.095984f,-0.025757f,-0.154201f,0.10316f,4.92E-4f,-0.164078f,0.161566f,-0.025757f,-0.043307f,0.173679f,4.92E-4f,-0.044837f,0.151455f,-0.025757f,-0.082688f,0.162806f,4.92E-4f,-0.087182f,-0.086267f,-0.025757f,-0.159929f,-0.092809f,4.92E-4f,-0.170237f,6.45E-4f,0.009648f,-0.008677f,6.45E-4f,0.01959f,-0.008677f,0.094098f,4.92E-4f,-0.170237f,0.087556f,-0.025757f,-0.159929f,0.002139f,0.009648f,-0.008755f,0.002139f,0.01959f,-0.008755f,0.011596f,4.92E-4f,0.151087f,0.010829f,-0.025757f,0.138903f,0.014246f,0.01959f,-0.027398f,0.005289f,0.023078f,-0.024487f,0.052007f,0.009648f,0.135099f,0.049952f,0.026741f,0.128776f,0.059384f,0.026741f,0.12538f,0.061831f,0.009648f,0.131562f,0.040326f,0.026741f,0.131573f,0.04198f,0.009648f,0.138012f,-0.097052f,0.009648f,-0.157446f,-0.093145f,0.026741f,-0.152068f,-0.101065f,0.026741f,-0.145924f,-0.105303f,0.009648f,-0.151047f,-0.153896f,0.009648f,-0.084165f,-0.147714f,0.026741f,-0.081717f,0.149003f,0.026741f,-0.081717f,0.145022f,0.026741f,-0.090917f,0.151038f,0.009648f,-0.093748f,0.155185f,0.009648f,-0.084165f,-0.160346f,0.009648f,-0.064313f,-0.153906f,0.026741f,-0.06266f,0.155195f,0.026741f,0.016704f,0.157382f,0.026741f,0.006921f,0.163913f,0.009648f,0.008167f,0.161635f,0.009648f,0.018357f,-0.157433f,0.009648f,-0.07434f,-0.151109f,0.026741f,-0.072286f,0.12359f,0.026741f,0.078732f,0.129734f,0.026741f,0.070811f,0.135113f,0.009648f,0.074719f,0.128713f,0.009648f,0.082969f,0.03179f,0.009648f,-0.186246f,0.030544f,0.026741f,-0.179715f,0.020643f,0.026741f,-0.181283f,0.021476f,0.009648f,-0.18788f,-0.058095f,0.026741f,0.12538f,-0.060542f,0.009648f,0.131562f,0.140471f,0.026741f,-0.099848f,0.146297f,0.009648f,-0.103051f,-0.160346f,0.009648f,0.018357f,-0.162623f,0.009648f,0.008167f,-0.156093f,0.026741f,0.006921f,-0.153906f,0.026741f,0.016704f,0.160208f,0.026741f,-0.022978f,0.166857f,0.009648f,-0.022978f,0.157382f,0.026741f,-0.052877f,0.163913f,0.009648f,-0.054123f,0.071414f,0.009648f,-0.173371f,0.068583f,0.026741f,-0.167356f,0.059384f,0.026741f,-0.171337f,0.061831f,0.009648f,-0.177518f,0.098342f,0.009648f,0.11149f,0.094434f,0.026741f,0.106112f,0.102354f,0.026741f,0.099968f,0.106592f,0.009648f,0.105091f,-0.165568f,0.009648f,-0.022978f,-0.16524f,0.009648f,-0.033415f,-0.158604f,0.026741f,-0.032997f,-0.158919f,0.026741f,-0.022978f,-0.108584f,0.026741f,-0.139295f,-0.113135f,0.009648f,-0.144141f,0.098342f,0.009648f,-0.157446f,0.094434f,0.026741f,-0.152068f,0.086143f,0.026741f,-0.157702f,0.089705f,0.009648f,-0.163316f,-0.079429f,0.009648f,-0.168631f,-0.076226f,0.026741f,-0.162805f,-0.084854f,0.026741f,-0.157702f,-0.088416f,0.009648f,-0.163316f,0.12359f,0.026741f,-0.124688f,0.128713f,0.009648f,-0.128926f,-0.139693f,0.009648f,0.066083f,-0.145008f,0.009648f,0.057095f,-0.139182f,0.026741f,0.053892f,-0.134079f,0.026741f,0.06252f,0.140471f,0.026741f,0.053892f,0.145022f,0.026741f,0.044961f,0.151038f,0.009648f,0.047792f,0.146297f,0.009648f,0.057095f,0.135369f,0.026741f,0.06252f,0.140982f,0.009648f,0.066083f,-0.164257f,0.009648f,-0.002146f,-0.157661f,0.026741f,-0.002979f,0.086143f,0.026741f,0.111746f,0.089705f,0.009648f,0.117359f,0.159893f,0.026741f,-0.032997f,0.166529f,0.009648f,-0.033415f,0.011081f,0.009648f,0.142906f,0.010664f,0.026741f,0.136271f,-0.113135f,0.009648f,0.098185f,-0.120519f,0.009648f,0.090802f,-0.115672f,0.026741f,0.086251f,-0.108584f,0.026741f,0.093339f,-0.120519f,0.009648f,-0.136758f,-0.115672f,0.026741f,-0.132207f,-0.050718f,0.009648f,0.135099f,-0.048663f,0.026741f,0.128776f,-0.039037f,0.026741f,0.131573f,-0.040691f,0.009648f,0.138012f,-0.16524f,0.009648f,-0.012542f,-0.158604f,0.026741f,-0.012959f,-0.165468f,0.026741f,-0.001993f,-0.166458f,0.026741f,-0.012465f,-0.173421f,4.92E-4f,-0.012027f,-0.172389f,4.92E-4f,-0.001119f,-0.166788f,0.026741f,-0.022978f,-0.166458f,0.026741f,-0.033491f,-0.173421f,4.92E-4f,-0.033929f,-0.173765f,4.92E-4f,-0.022978f,-0.092809f,4.92E-4f,-0.170237f,-0.089071f,0.026741f,-0.164346f,-0.080017f,0.026741f,-0.169701f,-0.083378f,4.92E-4f,-0.175814f,-0.070645f,0.026741f,-0.174476f,-0.073615f,4.92E-4f,-0.180788f,-0.060992f,0.026741f,-0.178653f,-0.06356f,4.92E-4f,-0.18514f,-0.155031f,0.026741f,-0.084614f,-0.150853f,0.026741f,-0.094268f,-0.157166f,4.92E-4f,-0.097238f,-0.161517f,4.92E-4f,-0.087182f,-0.042729f,4.92E-4f,-0.191908f,-0.040994f,0.026741f,-0.185151f,-0.030729f,0.026741f,-0.187445f,-0.032036f,4.92E-4f,-0.194298f,0.135369f,0.026741f,-0.108477f,0.140982f,0.009648f,-0.112039f,-0.110528f,4.92E-4f,-0.157363f,-0.106081f,0.026741f,-0.151987f,-0.09777f,0.026741f,-0.158434f,-0.101871f,4.92E-4f,-0.164078f,-0.134812f,0.026741f,-0.121393f,-0.128365f,0.026741f,-0.129704f,-0.13374f,4.92E-4f,-0.134151f,-0.140456f,4.92E-4f,-0.125493f,-0.010307f,4.92E-4f,-0.197043f,-0.009869f,0.026741f,-0.190081f,6.45E-4f,0.026741f,-0.190411f,6.45E-4f,4.92E-4f,-0.197387f,-0.146078f,0.026741f,-0.10364f,-0.152191f,4.92E-4f,-0.107f,-0.140724f,0.026741f,-0.112693f,-0.146614f,4.92E-4f,-0.116431f,0.166518f,4.92E-4f,-0.076874f,0.162806f,4.92E-4f,-0.087182f,0.15632f,0.026741f,-0.084614f,0.159883f,0.026741f,-0.074718f,0.162817f,0.026741f,-0.064617f,0.169574f,4.92E-4f,-0.066352f,0.175054f,4.92E-4f,-0.022978f,0.17471f,4.92E-4f,-0.033929f,0.167747f,0.026741f,-0.033491f,0.168077f,0.026741f,-0.022978f,0.153481f,4.92E-4f,-0.107f,0.147903f,4.92E-4f,-0.116431f,0.142013f,0.026741f,-0.112693f,0.147367f,0.026741f,-0.10364f,0.074904f,4.92E-4f,-0.180788f,0.071934f,0.026741f,-0.174476f,0.081306f,0.026741f,-0.169701f,0.084667f,4.92E-4f,-0.175814f,0.05454f,4.92E-4f,-0.188851f,0.052384f,0.026741f,-0.182216f,0.062281f,0.026741f,-0.178653f,0.064849f,4.92E-4f,-0.18514f,-0.051095f,0.026741f,-0.182216f,-0.053251f,4.92E-4f,-0.188851f,0.171965f,4.92E-4f,0.009703f,0.173679f,4.92E-4f,-0.001119f,0.166757f,0.026741f,-0.001993f,0.165112f,0.026741f,0.008396f,0.162817f,0.026741f,0.018661f,0.169574f,4.92E-4f,0.020396f,-0.121409f,0.026741f,-0.137594f,-0.113971f,0.026741f,-0.145031f,-0.118747f,4.92E-4f,-0.150117f,-0.126494f,4.92E-4f,-0.142369f,-0.021215f,4.92E-4f,-0.196012f,-0.02034f,0.026741f,-0.189091f,0.166757f,0.026741f,-0.043963f,0.173679f,4.92E-4f,-0.044837f,0.171965f,4.92E-4f,-0.055659f,0.165112f,0.026741f,-0.054352f,-0.163823f,0.026741f,0.008396f,-0.170675f,4.92E-4f,0.009703f,-0.165468f,0.026741f,-0.043963f,-0.172389f,4.92E-4f,-0.044837f,-0.163823f,0.026741f,-0.054352f,-0.170675f,4.92E-4f,-0.055659f,-0.161528f,0.026741f,-0.064617f,-0.168285f,4.92E-4f,-0.066352f,0.122698f,0.026741f,-0.137594f,0.127783f,4.92E-4f,-0.142369f,0.120036f,4.92E-4f,-0.150117f,0.11526f,0.026741f,-0.145031f,0.129654f,0.026741f,-0.129704f,0.135029f,4.92E-4f,-0.134151f,0.158455f,4.92E-4f,-0.097238f,0.152142f,0.026741f,-0.094268f,-0.152191f,4.92E-4f,0.061044f,-0.146078f,0.026741f,0.057683f,-0.150853f,0.026741f,0.048311f,-0.157166f,4.92E-4f,0.051282f,6.45E-4f,0.009648f,0.143234f,6.45E-4f,0.026741f,0.136586f,-0.029255f,0.026741f,0.133759f,-0.0305f,0.009648f,0.14029f,-0.060542f,0.009648f,-0.177518f,-0.058095f,0.026741f,-0.171337f,-0.067294f,0.026741f,-0.167356f,-0.070125f,0.009648f,-0.173371f,0.129734f,0.026741f,-0.116767f,0.135113f,0.009648f,-0.120675f,0.077515f,0.026741f,-0.162805f,0.080718f,0.009648f,-0.168631f,-0.149749f,0.009648f,0.047792f,-0.143733f,0.026741f,0.044961f,0.152399f,0.026741f,0.02633f,0.158722f,0.009648f,0.028384f,-0.088416f,0.009648f,0.117359f,-0.084854f,0.026741f,0.111746f,-0.009792f,0.009648f,0.142906f,-0.009375f,0.026741f,0.136271f,-0.019354f,0.026741f,0.135327f,-0.020187f,0.009648f,0.141923f,0.116961f,0.026741f,0.086251f,0.121808f,0.009648f,0.090802f,0.109873f,0.026741f,0.093339f,0.114425f,0.009648f,0.098185f,0.149003f,0.026741f,0.035761f,0.155185f,0.009648f,0.038209f,0.102354f,0.026741f,-0.145924f,0.106592f,0.009648f,-0.151047f,-0.097052f,0.009648f,0.11149f,-0.093145f,0.026741f,0.106112f,0.15895f,0.026741f,-0.042977f,0.165546f,0.009648f,-0.04381f,-0.105303f,0.009648f,0.105091f,-0.101065f,0.026741f,0.099968f,0.011596f,4.92E-4f,-0.197043f,0.011158f,0.026741f,-0.190081f,0.021629f,0.026741f,-0.189091f,0.022504f,4.92E-4f,-0.196012f,0.09036f,0.026741f,-0.164346f,0.094098f,4.92E-4f,-0.170237f,0.15632f,0.026741f,0.038658f,0.162806f,4.92E-4f,0.041226f,0.166518f,4.92E-4f,0.030917f,0.159883f,0.026741f,0.028762f,0.099059f,0.026741f,-0.158434f,0.10316f,4.92E-4f,-0.164078f,0.10737f,0.026741f,-0.151987f,0.111817f,4.92E-4f,-0.157363f,0.032018f,0.026741f,-0.187445f,0.033326f,4.92E-4f,-0.194298f,0.136101f,0.026741f,-0.121393f,0.141745f,4.92E-4f,-0.125493f,0.147903f,4.92E-4f,0.070475f,0.153481f,4.92E-4f,0.061044f,0.147367f,0.026741f,0.057683f,0.142013f,0.026741f,0.066737f,0.141745f,4.92E-4f,0.079537f,0.136101f,0.026741f,0.075437f,0.11526f,0.026741f,0.099075f,0.120036f,4.92E-4f,0.104161f,0.127783f,4.92E-4f,0.096413f,0.122698f,0.026741f,0.091638f,0.10737f,0.026741f,0.106031f,0.111817f,4.92E-4f,0.111407f,0.099059f,0.026741f,0.112478f,0.10316f,4.92E-4f,0.118122f,0.05454f,4.92E-4f,0.142895f,0.052384f,0.026741f,0.13626f,0.042283f,0.026741f,0.139195f,0.044018f,4.92E-4f,0.145952f,0.064849f,4.92E-4f,0.139184f,0.062281f,0.026741f,0.132697f,-0.158594f,0.026741f,-0.074718f,-0.165229f,4.92E-4f,-0.076874f,0.074904f,4.92E-4f,0.134832f,0.071934f,0.026741f,0.12852f,0.032018f,0.026741f,0.141489f,0.033326f,4.92E-4f,0.148342f,-0.155031f,0.026741f,0.038658f,-0.161517f,4.92E-4f,0.041226f,-0.158594f,0.026741f,0.028762f,-0.165229f,4.92E-4f,0.030917f,-0.161528f,0.026741f,0.018661f,-0.168285f,4.92E-4f,0.020396f,0.094098f,4.92E-4f,0.124281f,0.09036f,0.026741f,0.11839f,0.081306f,0.026741f,0.123745f,0.084667f,4.92E-4f,0.129858f,-0.053251f,4.92E-4f,0.142895f,-0.051095f,0.026741f,0.13626f,-0.060992f,0.026741f,0.132697f,-0.06356f,4.92E-4f,0.139184f,-0.070645f,0.026741f,0.12852f,-0.073615f,4.92E-4f,0.134832f,-0.080017f,0.026741f,0.123745f,-0.083378f,4.92E-4f,0.129858f,-0.089071f,0.026741f,0.11839f,-0.092809f,4.92E-4f,0.124281f,-0.09777f,0.026741f,0.112478f,-0.101871f,4.92E-4f,0.118122f,-0.106081f,0.026741f,0.106031f,-0.110528f,4.92E-4f,0.111407f,-0.113971f,0.026741f,0.099075f,-0.118747f,4.92E-4f,0.104161f,-0.121409f,0.026741f,0.091638f,-0.126494f,4.92E-4f,0.096413f,-0.128365f,0.026741f,0.083748f,-0.13374f,4.92E-4f,0.088195f,-0.134812f,0.026741f,0.075437f,-0.140456f,4.92E-4f,0.079537f,-0.140724f,0.026741f,0.066737f,-0.146614f,4.92E-4f,0.070475f,0.044018f,4.92E-4f,-0.191908f,0.042283f,0.026741f,-0.185151f,-0.021215f,4.92E-4f,0.150056f,-0.02034f,0.026741f,0.143135f,-0.030729f,0.026741f,0.141489f,-0.032036f,4.92E-4f,0.148342f,-0.040994f,0.026741f,0.139195f,-0.042729f,4.92E-4f,0.145952f,0.158455f,4.92E-4f,0.051282f,0.152142f,0.026741f,0.048311f,0.021629f,0.026741f,0.143135f,0.022504f,4.92E-4f,0.150056f,0.011158f,0.026741f,0.144124f,0.011596f,4.92E-4f,0.151087f,6.45E-4f,0.026741f,0.144455f,6.45E-4f,4.92E-4f,0.151431f,-0.009869f,0.026741f,0.144124f,-0.010307f,4.92E-4f,0.151087f,0.135029f,4.92E-4f,0.088195f,0.129654f,0.026741f,0.083748f,0.17471f,4.92E-4f,-0.012027f,0.167747f,0.026741f,-0.012465f);
    }
    private static void method13(){
        MESH_4.getTexCoords().ensureCapacity(3848);
        MESH_4.getTexCoords().addAll(3.937008f,-3.047244f,3.925485f,-3.04664f,3.914088f,-3.044835f,3.902943f,-3.0418491f,3.892171f,-3.037714f,3.88189f,-3.032475f,3.872213f,-3.0261912f,3.863245f,-3.018929f,3.855086f,-3.0107698f,3.847825f,-3.001803f,3.841541f,-2.992126f,3.836302f,-2.981845f,3.832167f,-2.971073f,3.82918f,-2.959927f,3.827376f,-2.948531f,3.826772f,-2.937008f,3.827376f,-2.925485f,3.82918f,-2.914088f,3.832167f,-2.902943f,3.836302f,-2.892171f,3.841541f,-2.88189f,3.847825f,-2.872213f,3.855086f,-2.863245f,3.863245f,-2.855086f,3.872213f,-2.847825f,3.88189f,-2.841541f,3.892171f,-2.836302f,3.902943f,-2.832167f,3.914088f,-2.82918f,3.925485f,-2.827376f,3.937008f,-2.826772f,3.948531f,-2.827376f,3.959927f,-2.82918f,3.971073f,-2.832167f,3.981845f,-2.836302f,3.992126f,-2.841541f,4.001803f,-2.847825f,4.01077f,-2.855086f,4.018929f,-2.863245f,4.026191f,-2.872213f,4.032475f,-2.88189f,4.037714f,-2.892171f,4.041849f,-2.902943f,4.044835f,-2.914088f,4.04664f,-2.925485f,4.047244f,-2.937008f,4.04664f,-2.948531f,4.044835f,-2.959927f,4.041849f,-2.971073f,4.037714f,-2.981845f,4.032475f,-2.992126f,4.026191f,-3.001803f,4.018929f,-3.0107698f,4.01077f,-3.018929f,4.001803f,-3.0261912f,3.992126f,-3.032475f,3.981845f,-3.037714f,3.971073f,-3.0418491f,3.959927f,-3.044835f,3.948531f,-3.04664f,5.584666f,0.20078701f,5.584666f,-0.023622036f,5.550874f,-0.023622036f,5.550874f,0.20078701f,4.487525f,-2.122093f,4.521317f,-2.122093f,4.51019f,-2.348531f,4.498651f,-2.348531f,1.1745f,0.20078701f,1.1745f,-0.023622036f,1.140709f,-0.023622036f,1.140709f,0.20078701f,3.255757f,5.169641f,3.289549f,5.169641f,3.278422f,4.943202f,3.266884f,4.943202f,5.429205f,2.031688f,5.462996f,2.031688f,5.45187f,1.805249f,5.440331f,1.805249f,3.687736f,-2.907159f,3.696393f,-2.253741f,3.926409f,-2.253741f,3.935065f,-2.907159f,5.31216f,0.20078701f,5.31216f,-0.023622036f,5.278368f,-0.023622036f,5.278368f,0.20078701f,5.462996f,0.20078701f,5.462996f,-0.023622036f,5.429205f,-0.023622036f,5.429205f,0.20078701f,4.838726f,0.20078701f,4.838726f,-0.023622036f,4.804935f,-0.023622036f,4.804935f,0.20078701f,0.113138f,3.217613f,-0.113138f,3.217613f,-0.117852f,3.631574f,0.117852f,3.631574f,4.386569f,0.42812097f,4.622272f,0.42812097f,4.617558f,0.014159977f,4.391283f,0.014159977f,-5.177412f,0.990553f,-5.182126f,0.57659197f,-5.408402f,0.57659197f,-5.413116f,0.990553f,4.176582f,2.995129f,4.171868f,2.5811682f,3.945591f,2.5811682f,3.940877f,2.995129f,2.252789f,-0.21153104f,2.488493f,-0.21153104f,2.483779f,-0.625492f,2.257503f,-0.625492f,3.929253f,3.084752f,3.924539f,2.6707911f,3.698263f,2.6707911f,3.693549f,3.084752f,5.351297f,1.23596f,5.587002f,1.23596f,5.582287f,0.821999f,5.356011f,0.821999f,-2.569155f,2.968055f,-2.795432f,2.968055f,-2.800146f,3.382015f,-2.564441f,3.382015f,4.622272f,2.799906f,4.617558f,2.3859448f,4.391283f,2.3859448f,4.386569f,2.799906f,4.996926f,2.585981f,4.992212f,2.17202f,4.765936f,2.17202f,4.761222f,2.585981f,5.177412f,0.990553f,5.413116f,0.990553f,5.408402f,0.57659197f,5.182126f,0.57659197f,0.579974f,-0.38763905f,0.815679f,-0.38763905f,0.810965f,-0.8016f,0.584689f,-0.8016f,5.406014f,1.361146f,5.641718f,1.361146f,5.637004f,0.947185f,5.410728f,0.947185f,-4.176902f,2.486094f,-4.403179f,2.486094f,-4.407893f,2.900055f,-4.172188f,2.900055f,2.800146f,3.382015f,2.795432f,2.968055f,2.569155f,2.968055f,2.564441f,3.382015f,-4.386569f,0.42812097f,-4.391283f,0.014159977f,-4.617558f,0.014159977f,-4.622272f,0.42812097f,-1.602683f,-0.304801f,-1.607397f,-0.71876204f,-1.833674f,-0.71876204f,-1.838388f,-0.304801f,4.619428f,0.836874f,4.628085f,0.18345702f,4.380756f,0.18345702f,4.389412f,0.836874f,5.29179f,0.321298f,5.300446f,-0.332119f,5.053117f,-0.332119f,5.061774f,0.321298f,-3.943722f,-2.149477f,-3.935065f,-2.802895f,-4.182394f,-2.802895f,-4.173738f,-2.149477f,5.520373f,1.491996f,5.554165f,1.491996f,5.543038f,1.265557f,5.5315f,1.265557f,1.140709f,6.052554f,1.1745f,6.052554f,1.163374f,5.826116f,1.151835f,5.826116f,3.708669f,4.825768f,3.742461f,4.825768f,3.731335f,4.599329f,3.719796f,4.599329f,-3.289549f,-3.27699f,-3.255757f,-3.27699f,-3.266884f,-3.503428f,-3.278422f,-3.503428f,-5.550874f,-0.023622036f,-5.584666f,-0.023622036f,-5.584666f,0.20078701f,-5.550874f,0.20078701f,-0.598886f,-4.245382f,-0.565095f,-4.245382f,-0.576221f,-4.47182f,-0.58776f,-4.47182f,0.342464f,-1.7690699f,0.335118f,-2.937008f,0.276221f,-1.997078f,0.342226f,-2.710843f,0.36352f,-2.485571f,0.422892f,-1.545671f,0.398917f,-2.262081f,0.448278f,-2.041254f,0.517189f,-1.3277631f,0.511407f,-1.8239629f,0.588055f,-1.611064f,0.624983f,-1.1162069f,0.677921f,-1.403398f,0.745847f,-0.911836f,0.780648f,-1.2017839f,0.879306f,-0.71545696f,0.895832f,-1.007019f,1.024832f,-0.527846f,1.023018f,-0.81987f,1.161704f,-0.64107704f,1.181851f,-0.349743f,1.311343f,-0.47134495f,1.349743f,-0.18185103f,1.471345f,-0.31134295f,1.527846f,-0.02483201f,1.641077f,-0.16170394f,1.715457f,0.12069398f,1.81987f,-0.023018003f,1.911836f,0.254153f,2.007019f,0.104168f,2.116207f,0.375017f,2.201784f,0.219352f,2.327763f,0.48281097f,2.403398f,0.322079f,2.545671f,0.577108f,2.611064f,0.411945f,2.76907f,0.65753603f,2.823963f,0.48859298f,2.997078f,0.72377896f,3.041254f,0.551722f,3.228795f,0.77557397f,3.262081f,0.60108304f,3.463307f,0.812717f,3.485571f,0.63648f,3.699689f,0.835062f,3.710843f,0.657774f,3.937008f,0.84252f,3.937008f,0.664882f,4.163172f,0.657774f,4.174326f,0.835062f,4.388444f,0.63648f,4.410708f,0.812717f,4.611935f,0.60108304f,4.645221f,0.77557397f,4.832761f,0.551722f,4.876938f,0.72377896f,5.050053f,0.48859298f,5.104946f,0.65753603f,5.262952f,0.411945f,5.328345f,0.577108f,5.470618f,0.322079f,5.546252f,0.48281097f,5.672232f,0.219352f,5.757809f,0.375017f,5.866997f,0.104168f,5.96218f,0.254153f,6.054145f,-0.023018003f,6.158558f,0.12069398f,6.232939f,-0.16170394f,6.346169f,-0.02483201f,6.402671f,-0.31134295f,6.524272f,-0.18185103f,6.562673f,-0.47134495f,6.692165f,-0.349743f,6.712312f,-0.64107704f,6.849184f,-0.527846f,6.850998f,-0.81987f,6.99471f,-0.71545696f,6.978184f,-1.007019f,7.093368f,-1.2017839f,7.128169f,-0.911836f,7.196095f,-1.403398f,7.249033f,-1.1162069f,7.28596f,-1.611064f,7.356827f,-1.3277631f,7.362608f,-1.8239629f,7.451124f,-1.545671f,7.425738f,-2.041254f,7.475098f,-2.262081f,7.531552f,-1.7690699f,7.510496f,-2.485571f,7.53179f,-2.710843f,7.597795f,-1.997078f,7.538898f,-2.937008f,0.164938f,-2.699689f,0.164938f,-3.174326f,0.15748f,-2.937008f,0.187283f,-2.463307f,0.187283f,-3.410708f,0.224426f,-3.6452212f,0.224426f,-2.228795f,0.276221f,-3.8769379f,0.342464f,-4.104946f,0.342226f,-3.1631718f,0.36352f,-3.388444f,0.422892f,-4.328345f,0.398917f,-3.6119351f,0.448278f,-3.8327618f,0.517189f,-4.546252f,0.511407f,-4.050053f,0.588055f,-4.262952f,0.624983f,-4.757809f,0.677921f,-4.470618f,0.745847f,-4.96218f,0.780648f,-4.672232f,0.879306f,-5.158558f,0.895832f,-4.866997f,1.024832f,-5.346169f,1.023018f,-5.054145f,1.161704f,-5.232939f,1.181851f,-5.524272f,1.311343f,-5.402671f,1.349743f,-5.692165f,1.471345f,-5.562673f,1.527846f,-5.849184f,1.641077f,-5.712312f,1.715457f,-5.99471f,1.81987f,-5.850998f,1.911836f,-6.128169f,2.007019f,-5.978184f,2.116207f,-6.249033f,2.201784f,-6.093368f,2.327763f,-6.356827f,2.403398f,-6.196095f,2.545671f,-6.451124f,2.611064f,-6.28596f,2.76907f,-6.531552f,2.823963f,-6.362608f,2.997078f,-6.597795f,3.041254f,-6.425738f,3.228795f,-6.64959f,3.262081f,-6.475098f,3.463307f,-6.686733f,3.485571f,-6.510496f,3.699689f,-6.709077f,3.710843f,-6.53179f,3.937008f,-6.716536f,3.937008f,-6.538898f,4.163172f,-6.53179f,4.174326f,-6.709077f,4.388444f,-6.510496f,4.410708f,-6.686733f,4.611935f,-6.475098f,4.645221f,-6.64959f,4.832761f,-6.425738f,4.876938f,-6.597795f,5.050053f,-6.362608f,5.104946f,-6.531552f,5.262952f,-6.28596f,5.328345f,-6.451124f,5.470618f,-6.196095f,5.546252f,-6.356827f,5.672232f,-6.093368f,5.757809f,-6.249033f,5.866997f,-5.978184f,5.96218f,-6.128169f,6.054145f,-5.850998f,6.158558f,-5.99471f,6.232939f,-5.712312f,6.346169f,-5.849184f,6.402671f,-5.562673f,6.524272f,-5.692165f,6.562673f,-5.402671f,6.692165f,-5.524272f,6.712312f,-5.232939f,6.849184f,-5.346169f,6.850998f,-5.054145f,6.99471f,-5.158558f,6.978184f,-4.866997f,7.093368f,-4.672232f,7.128169f,-4.96218f,7.196095f,-4.470618f,7.249033f,-4.757809f,7.28596f,-4.262952f,7.356827f,-4.546252f,7.362608f,-4.050053f,7.451124f,-4.328345f,7.425738f,-3.8327618f,7.475098f,-3.6119351f,7.531552f,-4.104946f,7.510496f,-3.388444f,7.53179f,-3.1631718f,7.597795f,-3.8769379f,7.64959f,-2.228795f,7.64959f,-3.6452212f,7.686733f,-2.463307f,7.686733f,-3.410708f,7.709077f,-2.699689f,7.709077f,-3.174326f,7.716536f,-2.937008f,-0.016896f,0.20078701f,0.016896f,0.20078701f,0.016896f,-0.023622036f,-0.016896f,-0.023622036f,-5.441775f,-0.39536595f,-5.433119f,-1.0487831f,-5.680448f,-1.0487831f,-5.671791f,-0.39536595f,5.152877f,0.456622f,5.161533f,-0.19679499f,4.914205f,-0.19679499f,4.922861f,0.456622f,0.464611f,1.7997711f,0.473268f,1.146354f,0.225939f,1.146354f,0.234595f,1.7997711f,2.24772f,-3.82266f,2.281512f,-3.82266f,2.270385f,-4.049098f,2.258847f,-4.049098f,4.922861f,-1.5421109f,5.152877f,-1.5421109f,5.161533f,-2.195529f,4.914205f,-2.195529f,-3.708669f,-0.023622036f,-3.742461f,-0.023622036f,-3.742461f,0.20078701f,-3.708669f,0.20078701f,-4.922861f,0.456622f,-4.914205f,-0.19679499f,-5.161533f,-0.19679499f,-5.152877f,0.456622f,1.260984f,-3.4695692f,1.26964f,-2.816151f,1.499656f,-2.816151f,1.508312f,-3.4695692f,-5.278368f,-0.023622036f,-5.31216f,-0.023622036f,-5.31216f,0.20078701f,-5.278368f,0.20078701f,3.926409f,1.168252f,3.935065f,0.514835f,3.687736f,0.514835f,3.696393f,1.168252f,-5.441775f,-0.69012296f,-5.433119f,-1.3435409f,-5.680448f,-1.3435409f,-5.671791f,-0.69012296f,-0.582819f,1.785895f,-0.574162f,1.132477f,-0.821491f,1.132477f,-0.812835f,1.785895f,-4.804935f,0.20078701f,-4.804935f,-0.023622036f,-4.838726f,-0.023622036f,-4.838726f,0.20078701f,-3.943722f,1.063989f,-3.935065f,0.41057098f,-4.182394f,0.41057098f,-4.173738f,1.063989f,2.164641f,1.639578f,2.173297f,0.98616f,1.925968f,0.98616f,1.934625f,1.639578f,-5.069515f,-0.023622036f,-5.103307f,-0.023622036f,-5.103307f,0.20078701f,-5.069515f,0.20078701f,-1.737431f,-4.018479f,-1.70364f,-4.018479f,-1.714766f,-4.244918f,-1.726305f,-4.244918f,4.804935f,3.556478f,4.838726f,3.556478f,4.8276f,3.330039f,4.816061f,3.330039f,-2.766989f,-0.023622036f,-2.800781f,-0.023622036f,-2.800781f,0.20078701f,-2.766989f,0.20078701f,-1.140709f,0.20078701f,-1.140709f,-0.023622036f,-1.1745f,-0.023622036f,-1.1745f,0.20078701f,-4.120764f,0.20078701f,-4.120764f,-0.023622036f,-4.154555f,-0.023622036f,-4.154555f,0.20078701f,3.708669f,-2.933117f,3.742461f,-2.933117f,3.731335f,-3.159555f,3.719796f,-3.159555f,1.596871f,-3.428432f,1.605528f,-2.775014f,1.835543f,-2.775014f,1.8442f,-3.428432f,-0.225939f,1.146354f,-0.473268f,1.146354f,-0.464611f,1.7997711f,-0.234595f,1.7997711f,-1.1745f,6.052554f,-1.140709f,6.052554f,-1.151835f,5.826116f,-1.163374f,5.826116f,-2.24772f,-0.023622036f,-2.281512f,-0.023622036f,-2.281512f,0.20078701f,-2.24772f,0.20078701f,-5.180256f,-1.2680521f,-5.171599f,-1.9214699f,-5.418928f,-1.9214699f,-5.410272f,-1.2680521f,-4.487525f,-0.023622036f,-4.521317f,-0.023622036f,-4.521317f,0.20078701f,-4.487525f,0.20078701f,-1.26964f,1.7306631f,-1.260984f,1.077245f,-1.508312f,1.077245f,-1.499656f,1.7306631f,5.171599f,-1.9214699f,5.180256f,-1.2680521f,5.410272f,-1.2680521f,5.418928f,-1.9214699f,2.868352f,-2.524506f,3.098368f,-2.524506f,3.107025f,-3.1779242f,2.859696f,-3.1779242f,-0.234595f,-2.88526f,-0.225939f,-3.5386772f,-0.473268f,-3.5386772f,-0.464611f,-2.88526f,5.441775f,-0.69012296f,5.671791f,-0.69012296f,5.680448f,-1.3435409f,5.433119f,-1.3435409f,-1.70364f,0.20078701f,-1.70364f,-0.023622036f,-1.737431f,-0.023622036f,-1.737431f,0.20078701f,-0.115008f,-2.889891f,0.115008f,-2.889891f,0.123664f,-3.5433092f,-0.123664f,-3.5433092f,-3.425366f,0.612346f,-3.672694f,0.612346f,-3.664038f,1.265764f,-3.434022f,1.265764f,-1.1745f,-4.159903f,-1.140709f,-4.159903f,-1.151835f,-4.386342f,-1.163374f,-4.386342f,-2.868352f,1.439018f,-2.859696f,0.7856f,-3.107025f,0.7856f,-3.098368f,1.439018f,3.255757f,0.20078701f,3.289549f,0.20078701f,3.289549f,-0.023622036f,3.255757f,-0.023622036f,-3.255757f,0.20078701f,-3.255757f,-0.023622036f,-3.289549f,-0.023622036f,-3.289549f,0.20078701f,5.103307f,0.20078701f,5.103307f,-0.023622036f,5.069515f,-0.023622036f,5.069515f,0.20078701f,-1.737431f,5.91113f,-1.70364f,5.91113f,-1.714766f,5.684692f,-1.726305f,5.684692f,5.061774f,-1.4067869f,5.29179f,-1.4067869f,5.300446f,-2.060205f,5.053117f,-2.060205f,4.175033f,-2.038872f,4.405048f,-2.038872f,4.413705f,-2.69229f,4.166376f,-2.69229f,0.598886f,0.20078701f,0.598886f,-0.023622036f,0.565095f,-0.023622036f,0.565095f,0.20078701f,-0.565095f,0.20078701f,-0.565095f,-0.023622036f,-0.598886f,-0.023622036f,-0.598886f,0.20078701f,-2.558629f,0.860659f,-2.805958f,0.860659f,-2.797302f,1.514076f,-2.567286f,1.514076f,-1.603133f,-5.758178f,-1.784881f,-5.899157f,-1.975122f,-6.028445f,-2.173107f,-6.145532f,-2.378052f,-6.249957f,-2.58915f,-6.341308f,-2.805568f,-6.419223f,-3.02645f,-6.483395f,-3.250927f,-6.533571f,-3.478111f,-6.569554f,-3.707106f,-6.5912f,-3.937008f,-6.598425f,-4.16691f,-6.5912f,-4.395905f,-6.569554f,-4.623089f,-6.533571f,-4.847565f,-6.483395f,-5.068448f,-6.419223f,-5.284865f,-6.341308f,-5.495964f,-6.249957f,-5.700909f,-6.145532f,-5.898893f,-6.028445f,-6.089135f,-5.899157f,-6.270883f,-5.758178f,-6.44342f,-5.606066f,-6.606066f,-5.44342f,-6.758178f,-5.270883f,-6.899157f,-5.089135f,-7.028445f,-4.898893f,-7.145532f,-4.700909f,-7.249957f,-4.495964f,-7.341308f,-4.284865f,-7.419223f,-4.068448f,-7.483395f,-3.8475652f,-7.533571f,-3.6230888f,-7.569554f,-3.395905f,-7.5912f,-3.1669102f,-7.598425f,-2.937008f,-7.5912f,-2.707106f,-7.569554f,-2.478111f,-7.533571f,-2.250927f,-7.483395f,-2.02645f,-7.419223f,-1.805568f,-7.341308f,-1.58915f,-7.249957f,-1.378052f,-7.145532f,-1.1731069f,-7.028445f,-0.975122f,-6.899157f,-0.784881f,-6.758178f,-0.60313296f,-6.606066f,-0.43059504f,-6.44342f,-0.26795006f,-6.270883f,-0.11583698f,-6.089135f,0.025141f,-5.898893f,0.15442902f,-5.700909f,0.27151698f,-5.495964f,0.375942f,-5.284865f,0.467292f,-5.068448f,0.545207f,-4.847565f,0.609379f,-4.623089f,0.65955603f,-4.395905f,0.69553804f,-4.16691f,0.717184f,-3.937008f,0.724409f,-3.707106f,0.717184f,-3.478111f,0.69553804f,-3.250927f,0.65955603f,-3.02645f,0.609379f,-2.805568f,0.545207f,-2.58915f,0.467292f,-2.378052f,0.375942f,-2.173107f,0.27151698f,-1.975122f,0.15442902f,-1.784881f,0.025141f,-1.603133f,-0.11583698f,-1.430595f,-0.26795006f,-1.267949f,-0.43059504f,-1.115837f,-0.60313296f,-0.974859f,-0.784881f,-0.845571f,-0.975122f,-0.728483f,-1.1731069f,-0.624058f,-1.378052f,-0.532708f,-1.58915f,-0.454793f,-1.805568f,-0.390621f,-2.02645f,-0.340444f,-2.250927f,-0.304462f,-2.478111f,-0.282816f,-2.707106f,-0.275591f,-2.937008f,-0.282816f,-3.1669102f,-0.304462f,-3.395905f,-0.340444f,-3.6230888f,-0.390621f,-3.8475652f,-0.454793f,-4.068448f,-0.532708f,-4.284865f,-0.624058f,-4.495964f,-0.728483f,-4.700909f,-0.845571f,-4.898893f,-0.974859f,-5.089135f,-1.115837f,-5.270883f,-1.267949f,-5.44342f,-1.430595f,-5.606066f,3.098368f,1.439018f,3.107025f,0.7856f,2.859696f,0.7856f,2.868352f,1.439018f,-5.171599f,-0.47085404f,-5.418928f,-0.47085404f,-5.410272f,0.18256402f,-5.180256f,0.18256402f,3.708669f,0.20078701f,3.742461f,0.20078701f,3.742461f,-0.023622036f,3.708669f,-0.023622036f,-0.598886f,6.138032f,-0.565095f,6.138032f,-0.576221f,5.911594f,-0.58776f,5.911594f,-0.016896f,-4.273979f,0.016896f,-4.273979f,0.005769f,-4.500418f,-0.005769f,-4.500418f,-5.462996f,2.031688f,-5.429205f,2.031688f,-5.440331f,1.805249f,-5.45187f,1.805249f,-4.521317f,-2.122093f,-4.487525f,-2.122093f,-4.498651f,-2.348531f,-4.51019f,-2.348531f,1.835543f,1.689525f,1.8442f,1.036108f,1.596871f,1.036108f,1.605528f,1.689525f,-0.016896f,6.16663f,0.016896f,6.16663f,0.005769f,5.940192f,-0.005769f,5.940192f,4.389412f,-1.922363f,4.619428f,-1.922363f,4.628085f,-2.57578f,4.380756f,-2.57578f,1.499656f,1.7306631f,1.508312f,1.077245f,1.260984f,1.077245f,1.26964f,1.7306631f,3.664038f,1.265764f,3.672694f,0.612346f,3.425366f,0.612346f,3.434022f,1.265764f,-5.354142f,-0.10293305f,-5.345485f,-0.75635004f,-5.592814f,-0.75635004f,-5.584157f,-0.10293305f,-5.462996f,-0.13903701f,-5.429205f,-0.13903701f,-5.440331f,-0.36547506f,-5.45187f,-0.36547506f,1.737431f,0.20078701f,1.737431f,-0.023622036f,1.70364f,-0.023622036f,1.70364f,0.20078701f,0.234595f,-2.88526f,0.464611f,-2.88526f,0.473268f,-3.5386772f,0.225939f,-3.5386772f,5.554165f,0.20078701f,5.554165f,-0.023622036f,5.520373f,-0.023622036f,5.520373f,0.20078701f,-1.934625f,-2.725066f,-1.925968f,-3.3784838f,-2.173297f,-3.3784838f,-2.164641f,-2.725066f,2.485649f,1.581018f,2.494306f,0.9276f,2.246977f,0.9276f,2.255633f,1.581018f,-2.800781f,-3.5745912f,-2.766989f,-3.5745912f,-2.778116f,-3.8010292f,-2.789654f,-3.8010292f,-3.696393f,1.168252f,-3.687736f,0.514835f,-3.935065f,0.514835f,-3.926409f,1.168252f,5.354142f,-0.982556f,5.584157f,-0.982556f,5.592814f,-1.635973f,5.345485f,-1.635973f,5.429205f,-0.13903701f,5.462996f,-0.13903701f,5.45187f,-0.36547506f,5.440331f,-0.36547506f,1.70364f,5.91113f,1.737431f,5.91113f,1.726305f,5.684692f,1.714766f,5.684692f,-5.31216f,2.559488f,-5.278368f,2.559488f,-5.289495f,2.33305f,-5.301033f,2.33305f,-5.520373f,-0.023622036f,-5.554165f,-0.023622036f,-5.554165f,0.20078701f,-5.520373f,0.20078701f,5.638875f,-0.24856901f,5.647531f,-0.901986f,5.400202f,-0.901986f,5.408858f,-0.24856901f,1.70364f,-4.018479f,1.737431f,-4.018479f,1.726305f,-4.244918f,1.714766f,-4.244918f,-5.429205f,0.20078701f,-5.429205f,-0.023622036f,-5.462996f,-0.023622036f,-5.462996f,0.20078701f,-2.281512f,5.715311f,-2.24772f,5.715311f,-2.258847f,5.488873f,-2.270385f,5.488873f,1.158304f,1.762828f,1.16696f,1.109411f,0.919632f,1.109411f,0.928288f,1.762828f,3.255757f,-3.27699f,3.289549f,-3.27699f,3.278422f,-3.503428f,3.266884f,-3.503428f,5.278368f,-0.66683805f,5.31216f,-0.66683805f,5.301033f,-0.893276f,5.289495f,-0.893276f,4.120764f,-2.54674f,4.154555f,-2.54674f,4.143429f,-2.773179f,4.13189f,-2.773179f,0.565095f,6.138032f,0.598886f,6.138032f,0.58776f,5.911594f,0.576221f,5.911594f,-4.838726f,-1.663827f,-4.804935f,-1.663827f,-4.816061f,-1.890265f,-4.8276f,-1.890265f,-3.434022f,-2.351252f,-3.425366f,-3.0046701f,-3.672694f,-3.0046701f,-3.664038f,-2.351252f,-5.103307f,3.069614f,-5.069515f,3.069614f,-5.080642f,2.843176f,-5.09218f,2.843176f,-5.061774f,0.321298f,-5.053117f,-0.332119f,-5.300446f,-0.332119f,-5.29179f,0.321298f,-2.868352f,-2.524506f,-2.859696f,-3.1779242f,-3.107025f,-3.1779242f,-3.098368f,-2.524506f,-4.838726f,3.556478f,-4.804935f,3.556478f,-4.816061f,3.330039f,-4.8276f,3.330039f,5.069515f,-1.176964f,5.103307f,-1.176964f,5.09218f,-1.4034021f,5.080642f,-1.4034021f,5.584157f,-0.10293305f,5.592814f,-0.75635004f,5.345485f,-0.75635004f,5.354142f,-0.10293305f,4.804935f,-1.663827f,4.838726f,-1.663827f,4.8276f,-1.890265f,4.816061f,-1.890265f,-5.31216f,-0.66683805f,-5.278368f,-0.66683805f,-5.289495f,-0.893276f,-5.301033f,-0.893276f,-4.154555f,-2.54674f,-4.120764f,-2.54674f,-4.13189f,-2.773179f,-4.143429f,-2.773179f,2.281512f,0.20078701f,2.281512f,-0.023622036f,2.24772f,-0.023622036f,2.24772f,0.20078701f,-4.389412f,-1.922363f,-4.380756f,-2.57578f,-4.628085f,-2.57578f,-4.619428f,-1.922363f,-5.584666f,0.946325f,-5.550874f,0.946325f,-5.562001f,0.719887f,-5.573539f,0.719887f,-5.061774f,-1.4067869f,-5.053117f,-2.060205f,-5.300446f,-2.060205f,-5.29179f,-1.4067869f,0.115008f,1.8044031f,0.123664f,1.150985f,-0.123664f,1.150985f,-0.115008f,1.8044031f,4.764066f,-1.673491f,4.994082f,-1.673491f,5.002738f,-2.326909f,4.75541f,-2.326909f,-4.521317f,4.014743f,-4.487525f,4.014743f,-4.498651f,3.788305f,-4.51019f,3.788305f,0.928288f,-2.848317f,1.158304f,-2.848317f,1.16696f,-3.5017338f,0.919632f,-3.5017338f,-1.596871f,1.036108f,-1.8442f,1.036108f,-1.835543f,1.689525f,-1.605528f,1.689525f,-4.166376f,0.29996598f,-4.413705f,0.29996598f,-4.405048f,0.953384f,-4.175033f,0.953384f,5.278368f,2.559488f,5.31216f,2.559488f,5.301033f,2.33305f,5.289495f,2.33305f,-3.157645f,1.356138f,-3.148989f,0.70272f,-3.396317f,0.70272f,-3.387661f,1.356138f,-1.934625f,1.639578f,-1.925968f,0.98616f,-2.173297f,0.98616f,-2.164641f,1.639578f,-4.586016f,0.71492004f,-4.577359f,0.06150198f,-4.824688f,0.06150198f,-4.816031f,0.71492004f,4.586016f,-1.8004079f,4.816031f,-1.8004079f,4.824688f,-2.453826f,4.577359f,-2.453826f,2.567286f,-2.599565f,2.797302f,-2.599565f,2.805958f,-3.252983f,2.558629f,-3.252983f,-5.554165f,1.491996f,-5.520373f,1.491996f,-5.5315f,1.265557f,-5.543038f,1.265557f,5.452762f,-0.54274404f,5.682778f,-0.54274404f,5.691434f,-1.196162f,5.444106f,-1.196162f,-5.554165f,0.40065497f,-5.520373f,0.40065497f,-5.5315f,0.17421699f,-5.543038f,0.17421699f,-4.764066f,-1.673491f,-4.75541f,-2.326909f,-5.002738f,-2.326909f,-4.994082f,-1.673491f,-3.742461f,4.825768f,-3.708669f,4.825768f,-3.719796f,4.599329f,-3.731335f,4.599329f,4.120764f,0.20078701f,4.154555f,0.20078701f,4.154555f,-0.023622036f,4.120764f,-0.023622036f,-4.154555f,4.439391f,-4.120764f,4.439391f,-4.13189f,4.212953f,-4.143429f,4.212953f,4.487525f,4.014743f,4.521317f,4.014743f,4.51019f,3.788305f,4.498651f,3.788305f,2.800781f,0.20078701f,2.800781f,-0.023622036f,2.766989f,-0.023622036f,2.766989f,0.20078701f,5.550874f,0.946325f,5.584666f,0.946325f,5.573539f,0.719887f,5.562001f,0.719887f,2.797302f,1.514076f,2.805958f,0.860659f,2.558629f,0.860659f,2.567286f,1.514076f,3.935065f,-2.802895f,3.943722f,-2.149477f,4.173738f,-2.149477f,4.182394f,-2.802895f,-2.255633f,1.581018f,-2.246977f,0.9276f,-2.494306f,0.9276f,-2.485649f,1.581018f,0.812835f,1.785895f,0.821491f,1.132477f,0.574162f,1.132477f,0.582819f,1.785895f,1.140709f,-4.159903f,1.1745f,-4.159903f,1.163374f,-4.386342f,1.151835f,-4.386342f,-3.696393f,-2.253741f,-3.687736f,-2.907159f,-3.935065f,-2.907159f,-3.926409f,-2.253741f,0.582819f,-2.871383f,0.812835f,-2.871383f,0.821491f,-3.5248008f,0.574162f,-3.5248008f,4.816031f,0.71492004f,4.824688f,0.06150198f,4.577359f,0.06150198f,4.586016f,0.71492004f,2.766989f,-3.5745912f,2.800781f,-3.5745912f,2.789654f,-3.8010292f,2.778116f,-3.8010292f,-4.922861f,-1.5421109f,-4.914205f,-2.195529f,-5.161533f,-2.195529f,-5.152877f,-1.5421109f,-3.157645f,-2.441626f,-3.148989f,-3.0950441f,-3.396317f,-3.0950441f,-3.387661f,-2.441626f,-1.605528f,-2.775014f,-1.596871f,-3.428432f,-1.8442f,-3.428432f,-1.835543f,-2.775014f,-2.567286f,-2.599565f,-2.558629f,-3.252983f,-2.805958f,-3.252983f,-2.797302f,-2.599565f,5.069515f,3.069614f,5.103307f,3.069614f,5.09218f,2.843176f,5.080642f,2.843176f,5.408858f,-0.83692f,5.638875f,-0.83692f,5.647531f,-1.4903369f,5.400202f,-1.4903369f,-5.27784f,0.040968f,-5.269184f,-0.61245f,-5.516512f,-0.61245f,-5.507856f,0.040968f,-3.742461f,-2.933117f,-3.708669f,-2.933117f,-3.719796f,-3.159555f,-3.731335f,-3.159555f,-5.408858f,-0.83692f,-5.400202f,-1.4903369f,-5.647531f,-1.4903369f,-5.638875f,-0.83692f,-3.289549f,5.169641f,-3.255757f,5.169641f,-3.266884f,4.943202f,-3.278422f,4.943202f,5.507856f,0.040968f,5.516512f,-0.61245f,5.269184f,-0.61245f,5.27784f,0.040968f,-0.582819f,-2.871383f,-0.574162f,-3.5248008f,-0.821491f,-3.5248008f,-0.812835f,-2.871383f,3.157645f,-2.441626f,3.387661f,-2.441626f,3.396317f,-3.0950441f,3.148989f,-3.0950441f,1.934625f,-2.725066f,2.164641f,-2.725066f,2.173297f,-3.3784838f,1.925968f,-3.3784838f,-4.764066f,0.58800304f,-4.75541f,-0.065415025f,-5.002738f,-0.065415025f,-4.994082f,0.58800304f,0.565095f,-4.245382f,0.598886f,-4.245382f,0.58776f,-4.47182f,0.576221f,-4.47182f,-5.103307f,-1.176964f,-5.069515f,-1.176964f,-5.080642f,-1.4034021f,-5.09218f,-1.4034021f,-2.800781f,5.467242f,-2.766989f,5.467242f,-2.778116f,5.240803f,-2.789654f,5.240803f,5.27784f,-1.126456f,5.507856f,-1.126456f,5.516512f,-1.7798741f,5.269184f,-1.7798741f,-2.255633f,-2.666506f,-2.246977f,-3.3199239f,-2.494306f,-3.3199239f,-2.485649f,-2.666506f,-5.27784f,-1.126456f,-5.269184f,-1.7798741f,-5.516512f,-1.7798741f,-5.507856f,-1.126456f,5.520373f,0.40065497f,5.554165f,0.40065497f,5.543038f,0.17421699f,5.5315f,0.17421699f,-4.586016f,-1.8004079f,-4.577359f,-2.453826f,-4.824688f,-2.453826f,-4.816031f,-1.8004079f,4.120764f,4.439391f,4.154555f,4.439391f,4.143429f,4.212953f,4.13189f,4.212953f,-0.928288f,1.762828f,-0.919632f,1.109411f,-1.16696f,1.109411f,-1.158304f,1.762828f,3.387661f,1.356138f,3.396317f,0.70272f,3.148989f,0.70272f,3.157645f,1.356138f,-1.26964f,-2.816151f,-1.260984f,-3.4695692f,-1.508312f,-3.4695692f,-1.499656f,-2.816151f,-4.389412f,0.836874f,-4.380756f,0.18345702f,-4.628085f,0.18345702f,-4.619428f,0.836874f,5.410272f,0.18256402f,5.418928f,-0.47085404f,5.171599f,-0.47085404f,5.180256f,0.18256402f,-2.281512f,-3.82266f,-2.24772f,-3.82266f,-2.258847f,-4.049098f,-2.270385f,-4.049098f,4.994082f,0.58800304f,5.002738f,-0.065415025f,4.75541f,-0.065415025f,4.764066f,0.58800304f,4.487525f,0.20078701f,4.521317f,0.20078701f,4.521317f,-0.023622036f,4.487525f,-0.023622036f,-5.354142f,-0.982556f,-5.345485f,-1.635973f,-5.592814f,-1.635973f,-5.584157f,-0.982556f,2.255633f,-2.666506f,2.485649f,-2.666506f,2.494306f,-3.3199239f,2.246977f,-3.3199239f,3.434022f,-2.351252f,3.664038f,-2.351252f,3.672694f,-3.0046701f,3.425366f,-3.0046701f,-5.452762f,-0.54274404f,-5.444106f,-1.196162f,-5.691434f,-1.196162f,-5.682778f,-0.54274404f,4.405048f,0.953384f,4.413705f,0.29996598f,4.166376f,0.29996598f,4.175033f,0.953384f,2.24772f,5.715311f,2.281512f,5.715311f,2.270385f,5.488873f,2.258847f,5.488873f,4.173738f,1.063989f,4.182394f,0.41057098f,3.935065f,0.41057098f,3.943722f,1.063989f,5.671791f,-0.39536595f,5.680448f,-1.0487831f,5.433119f,-1.0487831f,5.441775f,-0.39536595f,-0.928288f,-2.848317f,-0.919632f,-3.5017338f,-1.16696f,-3.5017338f,-1.158304f,-2.848317f,-5.400202f,-0.901986f,-5.647531f,-0.901986f,-5.638875f,-0.24856901f,-5.408858f,-0.24856901f,2.766989f,5.467242f,2.800781f,5.467242f,2.789654f,5.240803f,2.778116f,5.240803f,-4.175033f,-2.038872f,-4.166376f,-2.69229f,-4.413705f,-2.69229f,-4.405048f,-2.038872f,-4.920017f,0.754978f,-4.924731f,0.341017f,-5.151007f,0.341017f,-5.155721f,0.754978f,-4.583171f,0.53295004f,-4.587885f,0.11898899f,-4.814162f,0.11898899f,-4.818876f,0.53295004f,5.641718f,1.866881f,5.637004f,1.45292f,5.410728f,1.45292f,5.406014f,1.866881f,5.058929f,0.871299f,5.294634f,0.871299f,5.28992f,0.45733798f,5.063643f,0.45733798f,-1.936495f,3.075933f,-2.162771f,3.075933f,-2.167485f,3.489894f,-1.931781f,3.489894f,4.583171f,0.53295004f,4.818876f,0.53295004f,4.814162f,0.11898899f,4.587885f,0.11898899f,-4.587885f,2.281116f,-4.814162f,2.281116f,-4.818876f,2.695076f,-4.583171f,2.695076f,-4.761222f,0.642046f,-4.765936f,0.22808498f,-4.992212f,0.22808498f,-4.996926f,0.642046f,4.761222f,0.642046f,4.996926f,0.642046f,4.992212f,0.22808498f,4.765936f,0.22808498f,-5.410728f,1.45292f,-5.637004f,1.45292f,-5.641718f,1.866881f,-5.406014f,1.866881f,3.390505f,3.246254f,3.385791f,2.832294f,3.159515f,2.832294f,3.154801f,3.246254f,-1.931781f,-0.261868f,-1.936495f,-0.67582905f,-2.162771f,-0.67582905f,-2.167485f,-0.261868f,-1.607397f,3.118867f,-1.833674f,3.118867f,-1.838388f,3.532828f,-1.602683f,3.532828f,3.666882f,3.168571f,3.662168f,2.75461f,3.435892f,2.75461f,3.431178f,3.168571f,2.865508f,-0.08947003f,3.101213f,-0.08947003f,3.096498f,-0.50343096f,2.870222f,-0.50343096f,-3.945591f,2.5811682f,-4.171868f,2.5811682f,-4.176582f,2.995129f,-3.940877f,2.995129f,-2.870222f,2.903535f,-3.096498f,2.903535f,-3.101213f,3.317496f,-2.865508f,3.317496f,2.167485f,3.489894f,2.162771f,3.075933f,1.936495f,3.075933f,1.931781f,3.489894f,-5.406014f,1.361146f,-5.410728f,0.947185f,-5.637004f,0.947185f,-5.641718f,1.361146f,3.940877f,0.232898f,4.176582f,0.232898f,4.171868f,-0.18106306f,3.945591f,-0.18106306f,3.101213f,3.317496f,3.096498f,2.903535f,2.870222f,2.903535f,2.865508f,3.317496f,5.674635f,1.740697f,5.669921f,1.326736f,5.443645f,1.326736f,5.438931f,1.740697f,1.161148f,3.595838f,1.156434f,3.181877f,0.930158f,3.181877f,0.925444f,3.595838f,4.172188f,0.32797098f,4.407893f,0.32797098f,4.403179f,-0.08598995f,4.176902f,-0.08598995f,5.5107f,2.1157598f,5.505986f,1.7017989f,5.27971f,1.7017989f,5.274996f,2.1157598f,-0.236465f,3.213632f,-0.462741f,3.213632f,-0.467455f,3.627593f,-0.231751f,3.627593f,1.266796f,-0.34016204f,1.5025f,-0.34016204f,1.497786f,-0.754123f,1.27151f,-0.754123f,-5.182126f,1.823513f,-5.408402f,1.823513f,-5.413116f,2.237474f,-5.177412f,2.237474f,-5.356011f,1.578105f,-5.582287f,1.578105f,-5.587002f,1.992067f,-5.351297f,1.992067f,3.154801f,-0.018228054f,3.390505f,-0.018228054f,3.385791f,-0.432189f,3.159515f,-0.432189f,-5.274996f,1.112266f,-5.27971f,0.698305f,-5.505986f,0.698305f,-5.5107f,1.112266f,-3.698263f,2.6707911f,-3.924539f,2.6707911f,-3.929253f,3.084752f,-3.693549f,3.084752f,-4.172188f,0.32797098f,-4.176902f,-0.08598995f,-4.403179f,-0.08598995f,-4.407893f,0.32797098f,-0.117852f,-0.403548f,0.117852f,-0.403548f,0.113138f,-0.81750906f,-0.113138f,-0.81750906f,5.449918f,1.614013f,5.685622f,1.614013f,5.680908f,1.200052f,5.454632f,1.200052f,-2.564441f,-0.15398896f,-2.569155f,-0.56795f,-2.795432f,-0.56795f,-2.800146f,-0.15398896f,3.431178f,0.05945599f,3.666882f,0.05945599f,3.662168f,-0.35450494f,3.435892f,-0.35450494f,-3.430312f,-0.27686596f,-3.667748f,-0.27686596f,-3.672694f,0.336204f,-3.425366f,0.336204f,-3.940012f,-0.15397799f,-4.177447f,-0.15397799f,-4.182394f,0.45909202f,-3.935065f,0.45909202f,-5.269184f,1.793151f,-5.27413f,1.180081f,-5.511566f,1.180081f,-5.516512f,1.793151f,-5.171599f,1.879388f,-5.176546f,1.266318f,-5.413982f,1.266318f,-5.418928f,1.879388f,-5.053117f,1.963882f,-5.058064f,1.350812f,-5.295499f,1.350812f,-5.300446f,1.963882f,-5.058064f,0.298347f,-5.295499f,0.298347f,-5.300446f,0.911417f,-5.053117f,0.911417f,-4.577359f,2.2036119f,-4.582306f,1.5905421f,-4.819741f,1.5905421f,-4.824688f,2.2036119f,-1.27151f,3.154228f,-1.497786f,3.154228f,-1.5025f,3.568189f,-1.266796f,3.568189f,-5.400202f,1.616813f,-5.405149f,1.003743f,-5.642584f,1.003743f,-5.647531f,1.616813f,-5.405149f,0.645416f,-5.642584f,0.645416f,-5.647531f,1.258486f,-5.400202f,1.258486f,-3.935065f,2.4162068f,-3.940012f,1.8031371f,-4.177447f,1.8031371f,-4.182394f,2.4162068f,-5.176546f,0.382841f,-5.413982f,0.382841f,-5.418928f,0.995911f,-5.171599f,0.995911f,-5.350431f,0.556718f,-5.587867f,0.556718f,-5.592814f,1.169789f,-5.345485f,1.169789f,2.246977f,2.731096f,2.494306f,2.731096f,2.489359f,2.118026f,2.251923f,2.118026f,2.563576f,2.077256f,2.558629f,2.690326f,2.805958f,2.690326f,2.801012f,2.077256f,3.687736f,2.479707f,3.935065f,2.479707f,3.930119f,1.866637f,3.692683f,1.866637f,1.260984f,2.822235f,1.508312f,2.822235f,1.503366f,2.209165f,1.26593f,2.209165f,-1.596871f,2.7971811f,-1.601818f,2.184111f,-1.839253f,2.184111f,-1.8442f,2.7971811f,-2.246977f,2.731096f,-2.251923f,2.118026f,-2.489359f,2.118026f,-2.494306f,2.731096f,-1.925968f,2.7667608f,-1.930915f,2.153691f,-2.168351f,2.153691f,-2.173297f,2.7667608f,-4.914205f,2.046299f,-4.919151f,1.433229f,-5.156587f,1.433229f,-5.161533f,2.046299f,4.380756f,2.277886f,4.628085f,2.277886f,4.623138f,1.664816f,4.385703f,1.664816f,4.582306f,1.5905421f,4.577359f,2.2036119f,4.824688f,2.2036119f,4.819741f,1.5905421f,-4.75541f,2.126315f,-4.760356f,1.5132439f,-4.997792f,1.5132439f,-5.002738f,2.126315f,-5.449052f,0.824579f,-5.686488f,0.824579f,-5.691434f,1.43765f,-5.444106f,1.43765f,-5.433119f,1.527408f,-5.438066f,0.914338f,-5.675501f,0.914338f,-5.680448f,1.527408f,-4.166376f,2.348845f,-4.171323f,1.735774f,-4.408758f,1.735774f,-4.413705f,2.348845f,-5.27413f,0.469078f,-5.511566f,0.469078f,-5.516512f,1.082148f,-5.269184f,1.082148f,-5.438066f,0.73482f,-5.675501f,0.73482f,-5.680448f,1.347891f,-5.433119f,1.347891f,-5.345485f,1.70551f,-5.350431f,1.09244f,-5.587867f,1.09244f,-5.592814f,1.70551f,3.153935f,1.981066f,3.148989f,2.594136f,3.396317f,2.594136f,3.391371f,1.981066f,-3.153935f,-0.33190703f,-3.391371f,-0.33190703f,-3.396317f,0.28116298f,-3.148989f,0.28116298f,-4.166376f,0.526455f,-4.171323f,-0.08661604f,-4.408758f,-0.08661604f,-4.413705f,0.526455f,-4.385703f,-0.015656948f,-4.623138f,-0.015656948f,-4.628085f,0.597413f,-4.380756f,0.597413f,-4.582306f,0.058616996f,-4.819741f,0.058616996f,-4.824688f,0.671687f,-4.577359f,0.671687f,-0.118718f,2.254075f,-0.123664f,2.867146f,0.123664f,2.867146f,0.118718f,2.254075f,0.230885f,2.251255f,0.225939f,2.864325f,0.473268f,2.864325f,0.468321f,2.251255f,1.596871f,2.7971811f,1.8442f,2.7971811f,1.839253f,2.184111f,1.601818f,2.184111f,1.930915f,2.153691f,1.925968f,2.7667608f,2.173297f,2.7667608f,2.168351f,2.153691f,-1.596871f,0.078118026f,-1.601818f,-0.53495204f,-1.839253f,-0.53495204f,-1.8442f,0.078118026f,-3.940877f,0.232898f,-3.945591f,-0.18106306f,-4.171868f,-0.18106306f,-4.176582f,0.232898f,3.693549f,0.14327502f,3.929253f,0.14327502f,3.924539f,-0.27068603f,3.698263f,-0.27068603f,-4.391283f,2.3859448f,-4.617558f,2.3859448f,-4.622272f,2.799906f,-4.386569f,2.799906f,4.407893f,2.900055f,4.403179f,2.486094f,4.176902f,2.486094f,4.172188f,2.900055f,-2.865508f,-0.08947003f,-2.870222f,-0.50343096f,-3.096498f,-0.50343096f,-3.101213f,-0.08947003f,-2.257503f,3.025596f,-2.483779f,3.025596f,-2.488493f,3.439557f,-2.252789f,3.439557f,5.294634f,2.3567271f,5.28992f,1.942766f,5.063643f,1.942766f,5.058929f,2.3567271f,-0.584689f,3.201704f,-0.810965f,3.201704f,-0.815679f,3.615665f,-0.579974f,3.615665f,1.5025f,3.568189f,1.497786f,3.154228f,1.27151f,3.154228f,1.266796f,3.568189f,5.413116f,2.237474f,5.408402f,1.823513f,5.182126f,1.823513f,5.177412f,2.237474f,0.231751f,-0.399567f,0.467455f,-0.399567f,0.462741f,-0.81352794f,0.236465f,-0.81352794f,1.602683f,-0.304801f,1.838388f,-0.304801f,1.833674f,-0.71876204f,1.607397f,-0.71876204f,1.838388f,3.532828f,1.833674f,3.118867f,1.607397f,3.118867f,1.602683f,3.532828f,-4.765936f,2.17202f,-4.992212f,2.17202f,-4.996926f,2.585981f,-4.761222f,2.585981f,-1.266796f,-0.34016204f,-1.27151f,-0.754123f,-1.497786f,-0.754123f,-1.5025f,-0.34016204f,-3.693549f,0.14327502f,-3.698263f,-0.27068603f,-3.924539f,-0.27068603f,-3.929253f,0.14327502f,4.818876f,2.695076f,4.814162f,2.281116f,4.587885f,2.281116f,4.583171f,2.695076f,-5.27971f,1.7017989f,-5.505986f,1.7017989f,-5.5107f,2.1157598f,-5.274996f,2.1157598f,-3.154801f,-0.018228054f,-3.159515f,-0.432189f,-3.385791f,-0.432189f,-3.390505f,-0.018228054f,-5.443645f,1.326736f,-5.669921f,1.326736f,-5.674635f,1.740697f,-5.438931f,1.740697f,-5.438931f,1.487329f,-5.443645f,1.073369f,-5.669921f,1.073369f,-5.674635f,1.487329f,4.920017f,0.754978f,5.155721f,0.754978f,5.151007f,0.341017f,4.924731f,0.341017f,-5.063643f,1.942766f,-5.28992f,1.942766f,-5.294634f,2.3567271f,-5.058929f,2.3567271f,2.488493f,3.439557f,2.483779f,3.025596f,2.257503f,3.025596f,2.252789f,3.439557f,-0.930158f,3.181877f,-1.156434f,3.181877f,-1.161148f,3.595838f,-0.925444f,3.595838f,-5.449918f,1.614013f,-5.454632f,1.200052f,-5.680908f,1.200052f,-5.685622f,1.614013f,0.467455f,3.627593f,0.462741f,3.213632f,0.236465f,3.213632f,0.231751f,3.627593f,-0.925444f,-0.36781096f,-0.930158f,-0.781772f,-1.156434f,-0.781772f,-1.161148f,-0.36781096f,-5.058929f,0.871299f,-5.063643f,0.45733798f,-5.28992f,0.45733798f,-5.294634f,0.871299f,0.815679f,3.615665f,0.810965f,3.201704f,0.584689f,3.201704f,0.579974f,3.615665f,-2.252789f,-0.21153104f,-2.257503f,-0.625492f,-2.483779f,-0.625492f,-2.488493f,-0.21153104f,5.438931f,1.487329f,5.674635f,1.487329f,5.669921f,1.073369f,5.443645f,1.073369f,1.931781f,-0.261868f,2.167485f,-0.261868f,2.162771f,-0.67582905f,1.936495f,-0.67582905f,5.274996f,1.112266f,5.5107f,1.112266f,5.505986f,0.698305f,5.27971f,0.698305f,-5.351297f,1.23596f,-5.356011f,0.821999f,-5.582287f,0.821999f,-5.587002f,1.23596f,-3.431178f,0.05945599f,-3.435892f,-0.35450494f,-3.662168f,-0.35450494f,-3.666882f,0.05945599f,-3.435892f,2.75461f,-3.662168f,2.75461f,-3.666882f,3.168571f,-3.431178f,3.168571f,0.925444f,-0.36781096f,1.161148f,-0.36781096f,1.156434f,-0.781772f,0.930158f,-0.781772f,5.587002f,1.992067f,5.582287f,1.578105f,5.356011f,1.578105f,5.351297f,1.992067f,-3.159515f,2.832294f,-3.385791f,2.832294f,-3.390505f,3.246254f,-3.154801f,3.246254f,5.155721f,2.4730492f,5.151007f,2.059088f,4.924731f,2.059088f,4.920017f,2.4730492f,-0.579974f,-0.38763905f,-0.584689f,-0.8016f,-0.810965f,-0.8016f,-0.815679f,-0.38763905f,-4.924731f,2.059088f,-5.151007f,2.059088f,-5.155721f,2.4730492f,-4.920017f,2.4730492f,2.564441f,-0.15398896f,2.800146f,-0.15398896f,2.795432f,-0.56795f,2.569155f,-0.56795f,-0.231751f,-0.399567f,-0.236465f,-0.81352794f,-0.462741f,-0.81352794f,-0.467455f,-0.399567f,-3.425366f,2.539095f,-3.430312f,1.9260249f,-3.667748f,1.9260249f,-3.672694f,2.539095f,-1.260984f,2.822235f,-1.26593f,2.209165f,-1.503366f,2.209165f,-1.508312f,2.822235f,4.919151f,1.433229f,4.914205f,2.046299f,5.161533f,2.046299f,5.156587f,1.433229f,-3.692683f,-0.21747804f,-3.930119f,-0.21747804f,-3.935065f,0.39559197f,-3.687736f,0.39559197f,-0.919632f,2.841825f,-0.924578f,2.228755f,-1.162014f,2.228755f,-1.16696f,2.841825f,-0.574162f,2.855874f,-0.579109f,2.242803f,-0.816544f,2.242803f,-0.821491f,2.855874f,-0.225939f,2.864325f,-0.230885f,2.251255f,-0.468321f,2.251255f,-0.473268f,2.864325f,-3.148989f,2.594136f,-3.153935f,1.981066f,-3.391371f,1.981066f,-3.396317f,2.594136f,-3.687736f,2.479707f,-3.692683f,1.866637f,-3.930119f,1.866637f,-3.935065f,2.479707f,0.579109f,2.242803f,0.574162f,2.855874f,0.821491f,2.855874f,0.816544f,2.242803f,0.924578f,2.228755f,0.919632f,2.841825f,1.16696f,2.841825f,1.162014f,2.228755f,5.269184f,1.793151f,5.516512f,1.793151f,5.511566f,1.180081f,5.27413f,1.180081f,5.345485f,1.70551f,5.592814f,1.70551f,5.587867f,1.09244f,5.350431f,1.09244f,4.75541f,2.126315f,5.002738f,2.126315f,4.997792f,1.5132439f,4.760356f,1.5132439f,5.449052f,0.824579f,5.444106f,1.43765f,5.691434f,1.43765f,5.686488f,0.824579f,5.680448f,1.347891f,5.675501f,0.73482f,5.438066f,0.73482f,5.433119f,1.347891f,5.647531f,1.258486f,5.642584f,0.645416f,5.405149f,0.645416f,5.400202f,1.258486f,5.002738f,0.748985f,4.997792f,0.13591403f,4.760356f,0.13591403f,4.75541f,0.748985f,5.161533f,0.829f,5.156587f,0.21592999f,4.919151f,0.21592999f,4.914205f,0.829f,-4.760356f,0.13591403f,-4.997792f,0.13591403f,-5.002738f,0.748985f,-4.75541f,0.748985f,-4.919151f,0.21592999f,-5.156587f,0.21592999f,-5.161533f,0.829f,-4.914205f,0.829f,5.300446f,0.911417f,5.295499f,0.298347f,5.058064f,0.298347f,5.053117f,0.911417f,4.824688f,0.671687f,4.819741f,0.058616996f,4.582306f,0.058616996f,4.577359f,0.671687f,-1.930915f,-0.504532f,-2.168351f,-0.504532f,-2.173297f,0.10853797f,-1.925968f,0.10853797f,-2.251923f,-0.46886694f,-2.489359f,-0.46886694f,-2.494306f,0.144203f,-2.246977f,0.144203f,-2.563576f,-0.42809796f,-2.801012f,-0.42809796f,-2.805958f,0.184973f,-2.558629f,0.184973f,-2.864642f,-0.38238394f,-3.102078f,-0.38238394f,-3.107025f,0.23068601f,-2.859696f,0.23068601f,5.516512f,1.082148f,5.511566f,0.469078f,5.27413f,0.469078f,5.269184f,1.082148f,-4.380756f,2.277886f,-4.385703f,1.664816f,-4.623138f,1.664816f,-4.628085f,2.277886f,2.494306f,0.144203f,2.489359f,-0.46886694f,2.251923f,-0.46886694f,2.246977f,0.144203f,2.173297f,0.10853797f,2.168351f,-0.504532f,1.930915f,-0.504532f,1.925968f,0.10853797f,1.8442f,0.078118026f,1.839253f,-0.53495204f,1.601818f,-0.53495204f,1.596871f,0.078118026f,1.508312f,0.05306399f,1.503366f,-0.560006f,1.26593f,-0.560006f,1.260984f,0.05306399f,1.16696f,0.033474028f,1.162014f,-0.57959604f,0.924578f,-0.57959604f,0.919632f,0.033474028f,0.821491f,0.019425988f,0.816544f,-0.593645f,0.579109f,-0.593645f,0.574162f,0.019425988f,0.473268f,0.01097399f,0.468321f,-0.60209596f,0.230885f,-0.60209596f,0.225939f,0.01097399f,0.123664f,0.008153975f,0.118718f,-0.60491705f,-0.118718f,-0.60491705f,-0.123664f,0.008153975f,-0.230885f,-0.60209596f,-0.468321f,-0.60209596f,-0.473268f,0.01097399f,-0.225939f,0.01097399f,-0.579109f,-0.593645f,-0.816544f,-0.593645f,-0.821491f,0.019425988f,-0.574162f,0.019425988f,-0.924578f,-0.57959604f,-1.162014f,-0.57959604f,-1.16696f,0.033474028f,-0.919632f,0.033474028f,-1.26593f,-0.560006f,-1.503366f,-0.560006f,-1.508312f,0.05306399f,-1.260984f,0.05306399f,-2.558629f,2.690326f,-2.563576f,2.077256f,-2.801012f,2.077256f,-2.805958f,2.690326f,3.396317f,0.28116298f,3.391371f,-0.33190703f,3.153935f,-0.33190703f,3.148989f,0.28116298f,3.107025f,0.23068601f,3.102078f,-0.38238394f,2.864642f,-0.38238394f,2.859696f,0.23068601f,2.805958f,0.184973f,2.801012f,-0.42809796f,2.563576f,-0.42809796f,2.558629f,0.184973f,5.592814f,1.169789f,5.587867f,0.556718f,5.350431f,0.556718f,5.345485f,1.169789f,5.053117f,1.963882f,5.300446f,1.963882f,5.295499f,1.350812f,5.058064f,1.350812f,5.171599f,1.879388f,5.418928f,1.879388f,5.413982f,1.266318f,5.176546f,1.266318f,4.628085f,0.597413f,4.623138f,-0.015656948f,4.385703f,-0.015656948f,4.380756f,0.597413f,5.418928f,0.995911f,5.413982f,0.382841f,5.176546f,0.382841f,5.171599f,0.995911f,2.864642f,2.031543f,2.859696f,2.644613f,3.107025f,2.644613f,3.102078f,2.031543f,4.413705f,0.526455f,4.408758f,-0.08661604f,4.171323f,-0.08661604f,4.166376f,0.526455f,4.182394f,0.45909202f,4.177447f,-0.15397799f,3.940012f,-0.15397799f,3.935065f,0.45909202f,3.935065f,0.39559197f,3.930119f,-0.21747804f,3.692683f,-0.21747804f,3.687736f,0.39559197f,3.672694f,0.336204f,3.667748f,-0.27686596f,3.430312f,-0.27686596f,3.425366f,0.336204f,3.425366f,2.539095f,3.672694f,2.539095f,3.667748f,1.9260249f,3.430312f,1.9260249f,5.438066f,0.914338f,5.433119f,1.527408f,5.680448f,1.527408f,5.675501f,0.914338f,5.400202f,1.616813f,5.647531f,1.616813f,5.642584f,1.003743f,5.405149f,1.003743f,-2.859696f,2.644613f,-2.864642f,2.031543f,-3.102078f,2.031543f,-3.107025f,2.644613f,3.935065f,2.4162068f,4.182394f,2.4162068f,4.177447f,1.8031371f,3.940012f,1.8031371f,4.171323f,1.735774f,4.166376f,2.348845f,4.413705f,2.348845f,4.408758f,1.735774f);
    }
    private static void method14(){
        MESH_4.getFaces().ensureCapacity(7176);
        MESH_4.getFaces().addAll(0,0,1,1,2,2,0,0,2,2,3,3,0,0,3,3,4,4,0,0,4,4,5,5,0,0,5,5,6,6,0,0,6,6,7,7,0,0,7,7,8,8,0,0,8,8,9,9,0,0,9,9,10,10,0,0,10,10,11,11,0,0,11,11,12,12,0,0,12,12,13,13,0,0,13,13,14,14,0,0,14,14,15,15,0,0,15,15,16,16,0,0,16,16,17,17,0,0,17,17,18,18,0,0,18,18,19,19,0,0,19,19,20,20,0,0,20,20,21,21,0,0,21,21,22,22,0,0,22,22,23,23,0,0,23,23,24,24,0,0,24,24,25,25,0,0,25,25,26,26,0,0,26,26,27,27,0,0,27,27,28,28,0,0,28,28,29,29,0,0,29,29,30,30,0,0,30,30,31,31,0,0,31,31,32,32,0,0,32,32,33,33,0,0,33,33,34,34,0,0,34,34,35,35,0,0,35,35,36,36,0,0,36,36,37,37,0,0,37,37,38,38,0,0,38,38,39,39,0,0,39,39,40,40,0,0,40,40,41,41,0,0,41,41,42,42,0,0,42,42,43,43,0,0,43,43,44,44,0,0,44,44,45,45,0,0,45,45,46,46,0,0,46,46,47,47,0,0,47,47,48,48,0,0,48,48,49,49,0,0,49,49,50,50,0,0,50,50,51,51,0,0,51,51,52,52,0,0,52,52,53,53,0,0,53,53,54,54,0,0,54,54,55,55,0,0,55,55,56,56,0,0,56,56,57,57,0,0,57,57,58,58,0,0,58,58,59,59,60,60,61,61,62,62,60,60,62,62,63,63,64,64,65,65,66,66,64,64,66,66,67,67,68,68,69,69,70,70,68,68,70,70,71,71,72,72,73,73,74,74,72,72,74,74,75,75,76,76,77,77,78,78,76,76,78,78,79,79,80,80,81,81,82,82,80,80,82,82,83,83,84,84,85,85,86,86,84,84,86,86,87,87,88,88,89,89,85,90,88,88,85,90,84,91,90,92,91,93,92,94,90,92,92,94,93,95,94,96,95,97,96,98,94,96,96,98,97,99,98,100,99,101,100,102,98,100,100,102,101,103,102,104,103,105,104,106,102,104,104,106,105,107,106,108,107,109,108,110,106,108,108,110,109,111,110,112,111,113,112,114,110,112,112,114,113,115,114,116,115,117,107,118,114,116,107,118,106,119,116,120,117,121,118,122,116,120,118,122,119,123,120,124,121,125,122,126,120,124,122,126,123,127,124,128,125,129,126,130,124,128,126,130,127,131,128,132,129,133,130,134,128,132,130,134,131,135,132,136,133,137,134,138,132,136,134,138,135,139,136,140,137,141,138,142,136,140,138,142,139,143,117,144,140,145,141,146,117,144,141,146,118,147,142,148,143,149,144,150,142,148,144,150,145,151,146,152,147,153,148,154,146,152,148,154,149,155,150,156,151,157,152,158,150,156,152,158,153,159,154,160,155,161,156,162,154,160,156,162,157,163,158,164,159,165,160,166,158,164,160,166,161,167,162,71,163,68,164,69,162,71,164,69,165,70,166,168,167,169,168,170,166,168,168,170,169,171,170,172,171,173,172,174,170,172,172,174,173,175,174,176,76,177,79,178,174,176,79,178,175,179,176,180,177,181,178,182,176,180,178,182,179,183,180,184,72,185,75,186,180,184,75,186,181,187,182,188,183,189,184,190,182,188,184,190,185,191,186,192,187,193,188,194,186,192,188,194,189,195,190,196,191,197,192,198,190,196,192,198,193,199,194,200,195,201,196,202,195,201,194,200,197,203,197,203,194,200,198,204,198,204,194,200,199,205,198,204,199,205,200,206,200,206,199,205,201,207,201,207,199,205,202,208,201,207,202,208,203,209,203,209,202,208,204,210,204,210,202,208,205,211,204,210,205,211,206,212,206,212,205,211,207,213,206,212,207,213,208,214,208,214,207,213,209,215,208,214,209,215,210,216,210,216,209,215,211,217,210,216,211,217,212,218,212,218,211,217,213,219,213,219,211,217,214,220,213,219,214,220,215,221,215,221,214,220,216,222,215,221,216,222,217,223,217,223,216,222,218,224,217,223,218,224,219,225,219,225,218,224,220,226,219,225,220,226,221,227,221,227,220,226,222,228,221,227,222,228,223,229,223,229,222,228,224,230,223,229,224,230,225,231,225,231,224,230,226,232,225,231,226,232,227,233,227,233,226,232,228,234,227,233,228,234,229,235,229,235,228,234,230,236,229,235,230,236,231,237,231,237,230,236,232,238,231,237,232,238,233,239,233,239,232,238,234,240,233,239,234,240,235,241,235,241,234,240,236,242,235,241,236,242,237,243,237,243,236,242,238,244,237,243,238,244,239,245,239,245,238,244,240,246,239,245,240,246,241,247,241,247,240,246,242,248,242,248,240,246,243,249,242,248,243,249,244,250,244,250,243,249,245,251,244,250,245,251,246,252,246,252,245,251,247,253,246,252,247,253,248,254,248,254,247,253,249,255,248,254,249,255,250,256,250,256,249,255,251,257,250,256,251,257,252,258,252,258,251,257,253,259,252,258,253,259,254,260,254,260,253,259,255,261,254,260,255,261,256,262,256,262,255,261,257,263,256,262,257,263,258,264,258,264,257,263,259,265,258,264,259,265,260,266,260,266,259,265,261,267,260,266,261,267,262,268,262,268,261,267,263,269,262,268,263,269,264,270,264,270,263,269,265,271,264,270,265,271,266,272,266,272,265,271,267,273,266,272,267,273,268,274,268,274,267,273,269,275,268,274,269,275,270,276,270,276,269,275,271,277,270,276,271,277,272,278,272,278,271,277,273,279,273,279,271,277,274,280,273,279,274,280,275,281,275,281,274,280,276,282,275,281,276,282,277,283,277,283,276,282,278,284,277,283,278,284,279,285,279,285,278,284,280,286,279,285,280,286,281,287,281,287,280,286,282,288,282,288,280,286,283,289,282,288,283,289,284,290,284,290,283,289,285,291,285,291,283,289,286,292,285,291,286,292,287,293,288,294,289,295,290,296,289,295,288,294,291,297,289,295,291,297,292,298,292,298,291,297,293,299,293,299,291,297,294,300,293,299,294,300,295,301,295,301,294,300,196,202,295,301,196,202,296,302,296,302,196,202,195,201,296,302,195,201,297,303,296,302,297,303,298,304,296,302,298,304,299,305,299,305,298,304,300,306,299,305,300,306,301,307,299,305,301,307,302,308,302,308,301,307,303,309,302,308,303,309,304,310,302,308,304,310,305,311,305,311,304,310,306,312,305,311,306,312,307,313,307,313,306,312,308,314,307,313,308,314,309,315,309,315,308,314,310,316,309,315,310,316,311,317,311,317,310,316,312,318,311,317,312,318,313,319,311,317,313,319,314,320,314,320,313,319,315,321,314,320,315,321,316,322,316,322,315,321,317,323,316,322,317,323,318,324,318,324,317,323,319,325,318,324,319,325,320,326,320,326,319,325,321,327,320,326,321,327,322,328,322,328,321,327,323,329,322,328,323,329,324,330,324,330,323,329,325,331,324,330,325,331,326,332,326,332,325,331,327,333,326,332,327,333,328,334,328,334,327,333,329,335,328,334,329,335,330,336,330,336,329,335,331,337,330,336,331,337,332,338,332,338,331,337,333,339,332,338,333,339,334,340,334,340,333,339,335,341,334,340,335,341,336,342,336,342,335,341,337,343,336,342,337,343,338,344,338,344,337,343,339,345,338,344,339,345,340,346,340,346,339,345,341,347,340,346,341,347,342,348,340,346,342,348,343,349,343,349,342,348,344,350,343,349,344,350,345,351,345,351,344,350,346,352,345,351,346,352,347,353,347,353,346,352,348,354,347,353,348,354,349,355,349,355,348,354,350,356,349,355,350,356,351,357,351,357,350,356,352,358,351,357,352,358,353,359,353,359,352,358,354,360,353,359,354,360,355,361,355,361,354,360,356,362,355,361,356,362,357,363,357,363,356,362,358,364,357,363,358,364,359,365,359,365,358,364,360,366,359,365,360,366,361,367,361,367,360,366,362,368,361,367,362,368,363,369,363,369,362,368,364,370,363,369,364,370,365,371,365,371,364,370,366,372,365,371,366,372,367,373,367,373,366,372,368,374,367,373,368,374,369,375,369,375,368,374,370,376,369,375,370,376,371,377,371,377,370,376,372,378,371,377,372,378,373,379,371,377,373,379,374,380,374,380,373,379,375,381,374,380,375,381,376,382,376,382,375,381,377,383,376,382,377,383,378,384,378,384,377,383,379,385,378,384,379,385,380,386,380,386,379,385,381,387,380,386,381,387,382,388,380,386,382,388,383,389,383,389,382,388,384,390,383,389,384,390,385,391,383,389,385,391,386,392,386,392,385,391,287,293,386,392,287,293,286,292,386,392,286,292,387,393,386,392,387,393,388,394,388,394,387,393,389,395,388,394,389,395,390,396,390,396,389,395,391,397,390,396,391,397,392,398,392,398,391,397,393,399,394,400,395,401,396,402,394,400,396,402,397,403,398,404,399,405,400,406,398,404,400,406,401,407,169,408,168,409,402,410,169,408,402,410,403,411,404,412,405,413,406,414,404,412,406,414,407,415,408,402,409,403,410,400,408,402,410,400,411,401,412,416,413,417,414,418,412,416,414,418,415,419,416,420,417,421,418,422,416,420,418,422,419,423,420,424,421,425,422,426,420,424,422,426,423,427,424,428,425,429,426,430,424,428,426,430,427,431,428,432,429,433,430,434,428,432,430,434,431,435,432,436,433,437,434,438,432,436,434,438,435,439,436,440,437,441,438,442,436,440,438,442,439,443,440,444,441,445,442,446,440,444,442,446,443,447,444,448,445,449,446,450,444,448,446,450,447,451,448,452,449,453,450,454,448,452,450,454,451,455,452,456,453,457,454,458,452,456,454,458,455,459,456,460,457,461,458,462,456,460,458,462,459,463,460,464,432,465,435,466,460,464,435,466,461,467,462,468,463,469,464,470,462,468,464,470,465,471,466,472,467,473,468,474,466,472,468,474,469,475,470,476,471,477,472,478,470,476,472,478,473,479,474,480,475,481,476,482,474,480,476,482,477,483,478,484,479,485,480,486,478,484,480,486,481,487,482,488,483,489,484,490,482,488,484,490,485,491,486,492,487,493,429,494,486,492,429,494,428,495,488,496,445,497,444,498,488,496,444,498,489,499,490,500,491,501,492,502,490,500,492,502,493,503,494,504,470,505,473,506,494,504,473,506,495,507,496,508,497,509,498,510,496,508,498,510,499,511,500,512,501,513,502,514,500,512,502,514,503,515,504,516,505,517,506,518,504,516,506,518,507,519,508,520,509,521,510,522,508,520,510,522,511,523,512,524,513,525,514,526,512,524,514,526,515,527,516,528,517,529,518,530,516,528,518,530,519,531,520,532,521,533,522,534,520,532,522,534,523,535,524,536,525,537,475,538,524,536,475,538,474,539,526,540,519,541,518,542,526,540,518,542,527,543,528,507,529,504,525,505,528,507,525,505,524,506,530,544,531,545,532,546,530,544,532,546,533,547,463,548,190,549,193,550,463,548,193,550,464,551,534,479,535,476,529,477,534,479,529,477,528,478,536,552,537,553,538,554,536,552,538,554,539,555,540,556,541,557,542,558,540,556,542,558,543,559,544,560,545,561,535,562,544,560,535,562,534,563,87,564,86,565,91,566,87,564,91,566,90,567,491,568,546,569,547,570,491,568,547,570,492,571,510,572,416,573,419,574,510,572,419,574,511,575,548,576,549,577,550,578,548,576,550,578,551,579,71,580,70,581,408,582,71,580,408,582,411,583,477,584,476,585,396,586,477,584,396,586,395,587,552,588,537,589,536,590,552,588,536,590,553,591,554,592,555,593,556,594,554,592,556,594,557,595,554,592,557,595,558,596,554,592,558,596,559,597,554,592,559,597,560,598,554,592,560,598,561,599,554,592,561,599,562,600,554,592,562,600,563,601,554,592,563,601,564,602,554,592,564,602,565,603,554,592,565,603,566,604,554,592,566,604,567,605,554,592,567,605,568,606,554,592,568,606,569,607,554,592,569,607,570,608,554,592,570,608,571,609,554,592,571,609,572,610,554,592,572,610,573,611,554,592,573,611,574,612,554,592,574,612,575,613,554,592,575,613,576,614,554,592,576,614,577,615,554,592,577,615,578,616,554,592,578,616,579,617,554,592,579,617,580,618,554,592,580,618,581,619,554,592,581,619,582,620,554,592,582,620,583,621,554,592,583,621,584,622,554,592,584,622,585,623,554,592,585,623,586,624,554,592,586,624,587,625,554,592,587,625,588,626,554,592,588,626,589,627,554,592,589,627,590,628,554,592,590,628,591,629,554,592,591,629,592,630,554,592,592,630,593,631,554,592,593,631,594,632,554,592,594,632,595,633,554,592,595,633,596,634,554,592,596,634,597,635,554,592,597,635,598,636,554,592,598,636,599,637,554,592,599,637,600,638,554,592,600,638,601,639,554,592,601,639,602,640,554,592,602,640,603,641,554,592,603,641,604,642,554,592,604,642,605,643,554,592,605,643,606,644,554,592,606,644,607,645,554,592,607,645,608,646,554,592,608,646,609,647,554,592,609,647,610,648,554,592,610,648,611,649,554,592,611,649,612,650,554,592,612,650,613,651,554,592,613,651,614,652,554,592,614,652,615,653,554,592,615,653,616,654,554,592,616,654,617,655,554,592,617,655,618,656,554,592,618,656,619,657,554,592,619,657,620,658,554,592,620,658,621,659,554,592,621,659,622,660,554,592,622,660,623,661,554,592,623,661,624,662,554,592,624,662,625,663,554,592,625,663,626,664,554,592,626,664,627,665,554,592,627,665,628,666,554,592,628,666,629,667,554,592,629,667,630,668,554,592,630,668,631,669,554,592,631,669,632,670,554,592,632,670,633,671,554,592,633,671,634,672,554,592,634,672,635,673,554,592,635,673,636,674,554,592,636,674,637,675,554,592,637,675,638,676,554,592,638,676,639,677,554,592,639,677,640,678,554,592,640,678,641,679,554,592,641,679,642,680,554,592,642,680,643,681,554,592,643,681,644,682,554,592,644,682,645,683,554,592,645,683,646,684,554,592,646,684,647,685,554,592,647,685,648,686,554,592,648,686,649,687,554,592,649,687,650,688,554,592,650,688,651,689,554,592,651,689,652,690,554,592,652,690,653,691,481,427,480,424,545,425,481,427,545,425,544,426,654,692,655,693,656,694,654,692,656,694,657,695,658,696,659,697,660,698,658,696,660,698,661,699,662,700,540,701,543,702,662,700,543,702,663,703,664,704,490,705,493,706,664,704,493,706,665,707,191,708,666,709,667,710,191,708,667,710,192,711,501,453,460,454,461,455,501,453,461,455,502,452,668,712,669,713,670,714,668,712,670,714,671,715,672,716,673,717,674,718,672,716,674,718,675,719,459,720,458,721,676,722,459,720,676,722,677,723,678,724,664,725,665,726,678,724,665,726,679,727,680,728,548,729,551,730,680,728,551,730,681,731,677,732,676,733,682,734,677,732,682,734,683,735,439,736,438,737,684,738,439,736,684,738,685,739,686,740,687,741,688,742,686,740,688,742,689,743,690,744,691,745,692,746,690,744,692,746,693,747,694,748,695,749,69,750,694,748,69,750,68,751,696,752,526,753,527,754,696,752,527,754,697,755,63,756,62,757,89,758,63,756,89,758,88,759,698,760,699,761,700,762,698,760,700,762,701,763,702,567,703,564,704,565,702,567,704,565,705,566,706,764,707,765,457,766,706,764,457,766,456,767,183,768,708,769,709,770,183,768,709,770,184,771,532,772,531,773,453,774,532,772,453,774,452,775,710,776,711,777,712,778,710,776,712,778,713,779,409,585,714,586,715,587,409,585,715,587,410,584,716,780,717,781,718,782,716,780,718,782,719,783,720,784,176,785,179,786,720,784,179,786,721,787,722,788,668,789,671,790,722,788,671,790,723,791,703,95,724,92,725,93,703,95,725,93,704,94,726,792,186,793,189,794,726,792,189,794,727,795,728,796,729,797,730,798,728,796,730,798,731,799,732,800,412,801,415,802,732,800,415,802,733,803,734,804,735,805,736,806,734,804,736,806,737,807,188,795,187,792,735,793,188,795,735,793,734,794,546,808,738,809,739,810,546,808,739,810,547,811,683,812,682,813,740,814,683,812,740,814,741,815,742,816,482,817,485,818,742,816,485,818,743,819,744,820,716,821,719,822,744,820,719,822,745,823,483,824,64,825,67,826,483,824,67,826,484,827,60,759,746,756,747,757,60,759,747,757,61,758,177,828,678,829,679,830,177,828,679,830,178,831,748,832,672,833,675,834,748,832,675,834,749,835,750,836,751,837,752,838,750,836,752,838,753,839,754,840,722,841,723,842,754,840,723,842,755,843,427,844,426,845,658,846,427,844,658,846,661,847,756,848,757,849,758,850,756,848,758,850,759,851,760,852,754,853,755,854,760,852,755,854,761,855,762,856,744,857,745,858,762,856,745,858,763,859,731,860,730,861,764,862,731,860,764,862,765,863,65,864,762,865,763,866,65,864,763,866,66,867,691,868,766,869,767,870,691,868,767,870,692,871,673,872,768,873,769,874,673,872,769,874,674,875,471,561,420,562,423,563,471,561,423,563,472,560,770,876,771,877,695,878,770,876,695,878,694,879,772,880,773,881,774,882,772,880,774,882,775,883,776,884,777,885,778,886,776,884,778,886,779,887,780,467,781,464,449,465,780,467,449,465,448,466,499,888,498,889,782,890,499,888,782,890,783,891,407,892,406,893,488,894,407,892,488,894,489,895,417,896,784,897,785,898,417,896,785,898,418,899,786,900,760,901,761,902,786,900,761,902,787,903,430,904,788,905,789,906,430,904,789,906,431,907,506,908,790,909,791,910,506,908,791,910,507,911,454,912,792,913,793,914,454,912,793,914,455,915,77,916,794,917,795,918,77,916,795,918,78,919,539,920,538,921,530,922,539,920,530,922,533,923,791,924,790,925,796,926,791,924,796,926,797,927,798,928,799,929,800,930,798,928,800,930,801,931,784,932,680,933,681,934,784,932,681,934,785,935,802,879,803,876,804,877,802,879,804,877,805,878,513,936,806,937,807,938,513,936,807,938,514,939,669,940,776,941,779,942,669,940,779,942,670,943,714,481,808,482,809,483,714,481,809,483,715,480,810,944,520,945,523,946,810,944,523,946,811,947,421,485,500,486,503,487,421,485,503,487,422,484,777,948,690,949,693,950,777,948,693,950,778,951,812,952,813,953,814,954,812,952,814,954,815,955,737,439,736,436,781,437,737,439,781,437,780,438,816,956,817,957,818,958,816,956,818,958,819,959,803,751,162,748,165,749,803,751,165,749,804,750,820,960,662,961,663,962,820,960,663,962,821,963,817,964,786,965,787,966,817,964,787,966,818,967,467,968,822,969,823,970,467,968,823,970,468,971,824,972,825,973,771,974,824,972,771,974,770,975,826,976,174,977,175,978,826,976,175,978,827,979,828,557,829,558,825,559,828,557,825,559,824,556,657,980,656,981,707,982,657,980,707,982,706,983,550,984,549,985,81,986,550,984,81,986,80,987,541,975,802,972,805,973,541,975,805,973,542,974,797,988,796,989,552,990,797,988,552,990,553,991,741,992,740,993,405,994,741,992,405,994,404,995,830,996,732,997,733,998,830,996,733,998,831,999,173,1000,172,1001,751,1002,173,1000,751,1002,750,1003,788,1004,696,1005,697,1006,788,1004,697,1006,789,1007,832,1008,833,1009,159,1010,832,1008,159,1010,158,1011,413,1012,742,1013,743,1014,413,1012,743,1014,414,1015,783,1016,782,1017,813,1018,783,1016,813,1018,812,1019,753,1020,752,1021,757,1022,753,1020,757,1022,756,1023,701,1024,700,1025,834,1026,701,1024,834,1026,835,1027,759,1028,758,1029,836,1030,759,1028,836,1030,837,1031,794,1032,466,1033,469,1034,794,1032,469,1034,795,1035,451,515,450,512,479,513,451,515,479,513,478,514,521,1036,710,1037,713,1038,521,1036,713,1038,522,1039,660,1040,659,1041,687,1042,660,1040,687,1042,686,1043,768,1044,182,1045,185,1046,768,1044,185,1046,769,1047,443,1048,442,1049,838,1050,443,1048,838,1050,839,1051,840,1052,816,1053,819,1054,840,1052,819,1054,841,1055,842,87,702,84,705,85,842,87,705,85,843,86,765,1056,764,1057,844,1058,765,1056,844,1058,845,1059,808,537,494,538,495,539,808,537,495,539,809,536,846,1060,847,1061,517,1062,846,1060,517,1062,516,1063,848,1064,512,1065,515,1066,848,1064,515,1066,849,1067,850,1068,487,1069,486,1070,850,1068,486,1070,851,1071,801,1072,800,1073,425,1074,801,1072,425,1074,424,1075,746,91,842,88,843,89,746,91,843,89,747,90,666,1076,830,1077,831,1078,666,1076,831,1078,667,1079,766,1080,748,1081,749,1082,766,1080,749,1082,767,1083,738,1084,840,1085,841,1086,738,1084,841,1086,739,1087,711,1088,509,1089,508,1090,711,1088,508,1090,712,1091,837,1092,836,1093,699,1094,837,1092,699,1094,698,1095,852,1096,853,1097,497,1098,852,1096,497,1098,496,1099,717,1100,826,1101,827,1102,717,1100,827,1102,718,1103,815,1104,814,1105,773,1106,815,1104,773,1106,772,1107,822,1108,180,1109,181,1110,822,1108,181,1110,823,1111,447,1112,446,1113,505,1114,447,1112,505,1114,504,1115,685,1116,684,1117,655,1118,685,1116,655,1118,654,1119,854,701,855,702,829,703,854,701,829,703,828,700,835,1120,834,1121,856,1122,835,1120,856,1122,857,1123,793,1124,792,1125,799,1126,793,1124,799,1126,798,1127,845,1128,844,1129,167,1130,845,1128,167,1130,166,1131,708,1132,462,1133,465,1134,708,1132,465,1134,709,1135,403,1136,402,1137,833,1138,403,1136,833,1138,832,1139,724,1140,820,1141,821,1142,724,1140,821,1142,725,1143,839,1144,838,1145,853,1146,839,1144,853,1146,852,1147,806,1148,850,1149,851,1150,806,1148,851,1150,807,1151,82,1152,848,1153,849,1154,82,1152,849,1154,83,1155,858,961,859,962,855,963,858,961,855,963,854,960,401,1156,400,1157,441,1158,401,1156,441,1158,440,1159,161,1160,160,1161,860,1162,161,1160,860,1162,861,1163,862,1164,720,1165,721,1166,862,1164,721,1166,863,1167,861,1168,860,1169,437,1170,861,1168,437,1170,436,1171,810,1172,811,1173,729,1174,810,1172,729,1174,728,1175,857,1176,856,1177,847,1178,857,1176,847,1178,846,1179,688,1180,399,1181,398,1182,688,1180,398,1182,689,1183,433,805,726,806,727,807,433,805,727,807,434,804,93,1141,92,1142,859,1143,93,1141,859,1143,858,1140,73,1184,862,1185,863,1186,73,1184,863,1186,74,1187,163,583,394,580,397,581,163,583,397,581,164,582,775,1188,774,1189,171,1190,775,1188,171,1190,170,1191,864,1192,865,1193,866,1194,864,1192,866,1194,867,1195,153,1196,152,1197,868,1198,153,1196);
    }
    private static void method15(){
        MESH_4.getFaces().addAll(868,1198,869,1199,870,1200,871,1201,872,1202,870,1200,872,1202,873,1203,874,1204,132,1205,135,1206,874,1204,135,1206,875,1207,876,1208,877,1209,878,1210,876,1208,878,1210,879,1211,99,1212,880,1213,881,1214,99,1212,881,1214,100,1215,882,1216,883,1217,884,1218,882,1216,884,1218,885,1219,869,1220,868,1221,865,1222,869,1220,865,1222,864,1223,880,1224,886,1225,887,1226,880,1224,887,1226,881,1227,888,1228,889,1229,890,1230,888,1228,890,1230,891,1231,892,1232,893,1233,894,1234,892,1232,894,1234,895,1235,157,1236,156,1237,896,1238,157,1236,896,1238,897,1239,877,1240,898,1241,899,1242,877,1240,899,1242,878,1243,895,1244,894,1245,115,1246,895,1244,115,1246,114,1247,900,1248,901,1249,902,1250,900,1248,902,1250,903,1251,143,1252,904,1253,905,1254,143,1252,905,1254,144,1255,906,1256,120,1257,123,1258,906,1256,123,1258,907,1259,908,1260,909,1261,910,1262,908,1260,910,1262,911,1263,912,1264,913,1265,914,1266,912,1264,914,1266,915,1267,916,1268,917,1269,918,1270,916,1268,918,1270,919,1271,149,1272,148,1273,893,1274,149,1272,893,1274,892,1275,873,1276,872,1277,920,1278,873,1276,920,1278,921,1279,922,1280,923,1281,924,1282,922,1280,924,1282,925,1283,917,1284,98,1285,101,1286,917,1284,101,1286,918,1287,926,1288,927,1289,928,1290,926,1288,928,1290,929,1291,930,1292,94,1293,97,1294,930,1292,97,1294,931,1295,932,1296,933,1297,934,1298,932,1296,934,1298,935,1299,936,1300,937,1301,938,1302,936,1300,938,1302,939,1303,889,1304,940,1305,941,1306,889,1304,941,1306,890,1307,901,1308,942,1309,943,1310,901,1308,943,1310,902,1311,105,1312,104,1313,944,1314,105,1312,944,1314,945,1315,904,1316,946,1317,947,1318,904,1316,947,1318,905,1319,948,1320,949,1321,151,1322,948,1320,151,1322,150,1323,950,1324,951,1325,952,1326,950,1324,952,1326,953,1327,954,1328,921,1329,920,1330,954,1328,920,1330,955,1331,956,1332,957,1333,958,1334,956,1332,958,1334,959,1335,942,1336,960,1337,961,1338,942,1336,961,1338,943,1339,962,1340,963,1341,964,1342,962,1340,964,1342,965,1343,966,1344,967,1345,968,1346,966,1344,968,1346,969,1347,970,1348,971,1349,972,1350,970,1348,972,1350,973,1351,973,1352,972,1353,974,1354,973,1352,974,1354,975,1355,975,1356,974,1357,976,1358,975,1356,976,1358,977,1359,978,1360,979,1361,980,1362,978,1360,980,1362,981,1363,982,1364,983,1365,984,1366,982,1364,984,1366,985,1367,898,1368,986,1369,987,1370,898,1368,987,1370,899,1371,988,1372,989,1373,990,1374,988,1372,990,1374,991,1375,992,1376,993,1377,994,1378,992,1376,994,1378,995,1379,996,1380,997,1381,998,1382,996,1380,998,1382,999,1383,979,1384,1000,1385,1001,1386,979,1384,1001,1386,980,1387,1002,1388,992,1389,995,1390,1002,1388,995,1390,1003,1391,1004,1392,1005,1393,1006,1394,1004,1392,1006,1394,1007,1395,1008,1396,1009,1397,1004,1398,1008,1396,1004,1398,1007,1399,1010,1400,1011,1401,1012,1402,1010,1400,1012,1402,1013,1403,1014,1404,1015,1405,1016,1406,1014,1404,1016,1406,1017,1407,1018,1408,1019,1409,1020,1410,1018,1408,1020,1410,1021,1411,1022,1412,1023,1413,1024,1414,1022,1412,1024,1414,1025,1415,1025,1416,1024,1417,1019,1418,1025,1416,1019,1418,1018,1419,977,1420,976,1421,1026,1422,977,1420,1026,1422,1027,1423,1028,1424,1029,1425,1030,1426,1028,1424,1030,1426,1031,1427,1032,1428,1033,1429,1028,1430,1032,1428,1028,1430,1031,1431,1027,1432,1026,1433,983,1434,1027,1432,983,1434,982,1435,1034,1436,1035,1437,1036,1438,1034,1436,1036,1438,1037,1439,1036,1440,1035,1441,989,1442,1036,1440,989,1442,988,1443,1038,1444,1039,1445,997,1446,1038,1444,997,1446,996,1447,1000,1448,1002,1449,1003,1450,1000,1448,1003,1450,1001,1451,993,1452,1034,1453,1037,1454,993,1452,1037,1454,994,1455,991,1456,990,1457,971,1458,991,1456,971,1458,970,1459,1040,1460,1041,1461,1042,1462,1040,1460,1042,1462,1043,1463,1044,1464,962,1465,965,1466,1044,1464,965,1466,1045,1467,968,1468,967,1469,1046,1470,968,1468,1046,1470,1047,1471,1046,1472,1048,1473,1049,1474,1046,1472,1049,1474,1047,1475,1048,1476,1050,1477,1051,1478,1048,1476,1051,1478,1049,1479,1052,1480,1053,1481,1054,1482,1052,1480,1054,1482,1055,1483,1056,1484,1057,1485,1053,1486,1056,1484,1053,1486,1052,1487,1058,1488,1014,1489,1017,1490,1058,1488,1017,1490,1059,1491,1006,1492,1005,1493,1058,1494,1006,1492,1058,1494,1059,1495,1060,1496,1061,1497,1062,1498,1060,1496,1062,1498,1063,1499,1064,1500,1065,1501,949,1502,1064,1500,949,1502,948,1503,960,1504,916,1505,919,1506,960,1504,919,1506,961,1507,883,1508,142,1509,145,1510,883,1508,145,1510,884,1511,109,1512,108,1513,125,1514,109,1512,125,1514,124,1515,959,1516,958,1517,1066,1518,959,1516,1066,1518,1067,1519,121,1520,876,1521,879,1522,121,1520,879,1522,122,1523,1068,1524,1069,1525,1070,1526,1068,1524,1070,1526,1071,1527,1072,1528,930,1529,931,1530,1072,1528,931,1530,1073,1531,925,1532,924,1533,1074,1534,925,1532,1074,1534,1075,1535,1071,1536,1070,1537,927,1538,1071,1536,927,1538,926,1539,951,1540,136,1541,139,1542,951,1540,139,1542,952,1543,933,1544,1076,1545,1077,1546,933,1544,1077,1546,934,1547,1075,1548,1074,1549,909,1550,1075,1548,909,1550,908,1551,1078,1552,882,1553,885,1554,1078,1552,885,1554,1079,1555,1080,1556,1081,1557,155,1558,1080,1556,155,1558,154,1559,1082,1560,1083,1561,1065,1562,1082,1560,1065,1562,1064,1563,127,1564,126,1565,129,1566,127,1564,129,1566,128,1567,940,1568,936,1569,939,1570,940,1568,939,1570,941,1571,1067,1572,1066,1573,1084,1574,1067,1572,1084,1574,1085,1575,1086,1576,888,1577,891,1578,1086,1576,891,1578,1087,1579,915,1580,914,1581,1088,1582,915,1580,1088,1582,1089,1583,886,1584,874,1585,875,1586,886,1584,875,1586,887,1587,937,1588,1090,1589,1091,1590,937,1588,1091,1590,938,1591,911,1592,910,1593,147,1594,911,1592,147,1594,146,1595,986,1596,1072,1597,1073,1598,986,1596,1073,1598,987,1599,1089,1600,1088,1601,1086,1602,1089,1600,1086,1602,1087,1603,96,1604,95,1605,1092,1606,96,1604,1092,1606,1093,1607,1094,1608,1095,1609,1081,1610,1094,1608,1081,1610,1080,1611,867,1612,866,1613,103,1614,867,1612,103,1614,102,1615,1093,1616,1092,1617,923,1618,1093,1616,923,1618,922,1619,897,1620,896,1621,957,1622,897,1620,957,1622,956,1623,140,1624,954,1625,955,1626,140,1624,955,1626,141,1627,1076,1628,110,1629,113,1630,1076,1628,113,1630,1077,1631,133,1632,116,1633,119,1634,133,1632,119,1634,134,1635,945,1636,944,1637,913,1638,945,1636,913,1638,912,1639,1085,1640,1084,1641,1083,1642,1085,1640,1083,1642,1082,1643,946,1644,1096,1645,1097,1646,946,1644,1097,1646,947,1647,137,1648,932,1649,935,1650,137,1648,935,1650,138,1651,929,1652,928,1653,871,1654,929,1652,871,1654,870,1655,1096,1656,906,1657,907,1658,1096,1656,907,1658,1097,1659,131,1660,130,1661,1069,1662,131,1660,1069,1662,1068,1663,1098,1664,1099,1665,1095,1666,1098,1664,1095,1666,1094,1667,1090,1668,1078,1669,1079,1670,1090,1668,1079,1670,1091,1671,111,1672,900,1673,903,1674,111,1672,903,1674,112,1675,950,1676,953,1677,1099,1678,950,1676,1099,1678,1098,1679,1100,1680,1101,1681,1102,1682,1100,1680,1102,1682,1103,1683,1021,1684,1020,1685,1104,1686,1021,1684,1104,1686,1105,1687,1106,1688,1107,1689,1108,1690,1106,1688,1108,1690,1109,1691,963,1692,966,1693,969,1694,963,1692,969,1694,964,1695,1105,1696,1104,1697,1110,1698,1105,1696,1110,1698,1111,1699,1111,1700,1110,1701,1112,1702,1111,1700,1112,1702,1113,1703,1113,1704,1112,1705,1055,1706,1113,1704,1055,1706,1054,1707,1103,1708,1102,1709,1114,1710,1103,1708,1114,1710,1115,1711,999,1712,998,1713,1101,1714,999,1712,1101,1714,1100,1715,1116,1716,1117,1717,1057,1718,1116,1716,1057,1718,1056,1719,1016,1720,1015,1721,1117,1722,1016,1720,1117,1722,1116,1723,1118,1724,1119,1725,1120,1726,1118,1724,1120,1726,1121,1727,1122,1728,1118,1729,1121,1730,1122,1728,1121,1730,1123,1731,1108,1732,1033,1733,1032,1734,1108,1732,1032,1734,1109,1735,1124,1736,1125,1737,1126,1738,1124,1736,1126,1738,1127,1739,1125,1740,1124,1741,1128,1742,1125,1740,1128,1742,1129,1743,1129,1744,1128,1745,1130,1746,1129,1744,1130,1746,1131,1747,1132,1748,1133,1749,1134,1750,1132,1748,1134,1750,1135,1751,1136,1752,1137,1753,1133,1754,1136,1752,1133,1754,1132,1755,1050,1756,1138,1757,1139,1758,1050,1756,1139,1758,1051,1759,1138,1760,978,1761,981,1762,1138,1760,981,1762,1139,1763,1140,1764,1141,1765,1137,1766,1140,1764,1137,1766,1136,1767,1135,1768,1134,1769,1142,1770,1135,1768,1142,1770,1143,1771,1062,1772,1144,1773,1145,1774,1062,1772,1145,1774,1063,1775,1144,1776,1146,1777,1147,1778,1144,1776,1147,1778,1145,1779,1146,1780,1148,1781,1149,1782,1146,1780,1149,1782,1147,1783,1148,1784,1044,1785,1045,1786,1148,1784,1045,1786,1149,1787,1150,1788,1151,1789,1152,1790,1150,1788,1152,1790,1153,1791,985,1792,984,1793,1039,1794,985,1792,1039,1794,1038,1795,1154,1796,1155,1797,1156,1798,1154,1796,1156,1798,1157,1799,1157,1800,1156,1801,1158,1802,1157,1800,1158,1802,1159,1803,1159,1804,1158,1805,1160,1806,1159,1804,1160,1806,1161,1807,1161,1808,1160,1809,1162,1810,1161,1808,1162,1810,1163,1811,1163,1812,1162,1813,1164,1814,1163,1812,1164,1814,1165,1815,1165,1816,1164,1817,1166,1818,1165,1816,1166,1818,1167,1819,1167,1820,1166,1821,1168,1822,1167,1820,1168,1822,1169,1823,1169,1824,1168,1825,1170,1826,1169,1824,1170,1826,1171,1827,1170,1828,1172,1829,1173,1830,1170,1828,1173,1830,1171,1831,1172,1832,1174,1833,1175,1834,1172,1832,1175,1834,1173,1835,1174,1836,1176,1837,1177,1838,1174,1836,1177,1838,1175,1839,1176,1840,1061,1841,1060,1842,1176,1840,1060,1842,1177,1843,1178,1844,1179,1845,1023,1846,1178,1844,1023,1846,1022,1847,1180,1848,1181,1849,1182,1850,1180,1848,1182,1850,1183,1851,1183,1852,1182,1853,1184,1854,1183,1852,1184,1854,1185,1855,1185,1856,1184,1857,1155,1858,1185,1856,1155,1858,1154,1859,1131,1860,1130,1861,1151,1862,1131,1860,1151,1862,1150,1863,1186,1864,1107,1865,1106,1866,1186,1864,1106,1866,1187,1867,1119,1868,1186,1869,1187,1870,1119,1868,1187,1870,1120,1871,1143,1872,1142,1873,1188,1874,1143,1872,1188,1874,1189,1875,1153,1876,1152,1877,1141,1878,1153,1876,1141,1878,1140,1879,1043,1880,1042,1881,1009,1882,1043,1880,1009,1882,1008,1883,1189,1884,1188,1885,1190,1886,1189,1884,1190,1886,1191,1887,1191,1888,1190,1889,1192,1890,1191,1888,1192,1890,1193,1891,1193,1892,1192,1893,1194,1894,1193,1892,1194,1894,1195,1895,1195,1896,1194,1897,1181,1898,1195,1896,1181,1898,1180,1899,1011,1900,1041,1901,1040,1902,1011,1900,1040,1902,1012,1903,1127,1904,1126,1905,1196,1906,1127,1904,1196,1906,1197,1907,1196,1908,1122,1909,1123,1910,1196,1908,1123,1910,1197,1911,1115,1912,1114,1913,1179,1914,1115,1912,1179,1914,1178,1915,1198,1916,1010,1917,1013,1918,1198,1916,1013,1918,1199,1919,1030,1920,1029,1921,1198,1922,1030,1920,1198,1922,1199,1923);
    }
    private static void method16(){
        MESH_4.getFaceSmoothingGroups().ensureCapacity(1196);
        MESH_4.getFaceSmoothingGroups().addAll(128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,8,8,16,16,8,8,16,16,16,16,4,4,8,8,8,8,8,8,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4,8,8,4,4,4,4,16,16,16,16,16,16,16,16,8,8,16,16,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,8,8,4,4,4,4,4,4,8,8,16,16,4,4,8,8,4,4,4,4,8,8,4,4,4,4,4,4,8,8,4,4,4,4,8,8,16,16,16,16,8,8,8,8,8,8,16,16,4,4,4,4,16,16,8,8,4,4,8,8,4,4,4,4,4,4,4,4,4,4,8,8,4,4,8,8,4,4,16,16,8,8,4,4,8,8,8,8,8,8,16,16,4,4,4,4,8,8,8,8,4,4,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,8,8,4,4,4,4,8,8,16,16,16,16,8,8,16,16,16,16,4,4,16,16,4,4,4,4,4,4,4,4,16,16,8,8,4,4,8,8,4,4,8,8,4,4,16,16,4,4,4,4,8,8,16,16,16,16,16,16,8,8,8,8,4,4,16,16,8,8,8,8,16,16,4,4,16,16,16,16,16,16,8,8,16,16,16,16,4,4,16,16,4,4,4,4,16,16,16,16,4,4,16,16,16,16,16,16,8,8,8,8,4,4,16,16,8,8,4,4,4,4,4,4,16,16,4,4,4,4,4,4,16,16,4,4,4,4,4,4,4,4,8,8,4,4,16,16,8,8,4,4,8,8,16,16,4,4,8,8,16,16,8,8,8,8,16,16,16,16,8,8,16,16,8,8,4,4,4,4,8,8,4,4,4,4,16,16,4,4,4,4,4,4,16,16,4,4,4,4,4,4,4,4,16,16,8,8,4,4,4,4,16,16,4,4,16,16,8,8,4,4,8,8,4,4,4,4,4,4,4,4,8,8,16,16,16,16,16,16,4,4,4,4,4,4,16,16,4,4,16,16,4,4,4,4,8,8,4,4,4,4,4,4,16,16,4,4,8,8,4,4,4,4,4,4,8,8,4,4,4,4,16,16,4,4,4,4,4,4,4,4,8,8,8,8,16,16,8,8,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
        NODE_6 = MESHVIEWS[5];
        MESHVIEWS[5].setId("Mesh2");
        MESHVIEWS[5].setCullFace(CullFace.NONE);
        PhongMaterial MATERIAL_5 = new PhongMaterial();
        MATERIAL_5.setDiffuseColor(new Color(0.521569013595581,0.5411760210990906,0.5686269998550415,1.0));
        MATERIAL_5.setSpecularColor(new Color(0.33000001311302185,0.33000001311302185,0.33000001311302185,1.0));
        MATERIAL_5.setSpecularPower(64.0);
        MESHVIEWS[5].setMaterial(MATERIAL_5);
        MESH_5 = new TriangleMesh();
        MESHVIEWS[5].setMesh(MESH_5);
        MESH_5.getPoints().ensureCapacity(480);
        MESH_5.getPoints().addAll(-0.009792f,0.009648f,0.142906f,-0.013657f,0.009648f,-0.022978f,-0.020187f,0.009648f,0.141923f,-0.013579f,0.009648f,-0.021483f,-0.013344f,0.009648f,-0.020005f,-0.012957f,0.009648f,-0.018559f,-0.012421f,0.009648f,-0.017161f,-0.011741f,0.009648f,-0.015827f,-0.010926f,0.009648f,-0.014572f,-0.009984f,0.009648f,-0.013408f,-0.008925f,0.009648f,-0.01235f,6.45E-4f,0.009648f,0.143234f,-0.007762f,0.009648f,-0.011408f,-0.006506f,0.009648f,-0.010593f,-0.005172f,0.009648f,-0.009913f,-0.003775f,0.009648f,-0.009376f,-0.002329f,0.009648f,-0.008989f,-8.5E-4f,0.009648f,-0.008755f,6.45E-4f,0.009648f,-0.008677f,0.011081f,0.009648f,0.142906f,0.002139f,0.009648f,-0.008755f,0.003618f,0.009648f,-0.008989f,0.005064f,0.009648f,-0.009376f,0.006462f,0.009648f,-0.009913f,0.007795f,0.009648f,-0.010593f,0.009051f,0.009648f,-0.011408f,0.010214f,0.009648f,-0.01235f,0.011273f,0.009648f,-0.013408f,0.021476f,0.009648f,0.141923f,0.012215f,0.009648f,-0.014572f,0.01303f,0.009648f,-0.015827f,0.01371f,0.009648f,-0.017161f,0.014246f,0.009648f,-0.018559f,0.014634f,0.009648f,-0.020005f,0.014868f,0.009648f,-0.021483f,0.014946f,0.009648f,-0.022978f,-0.16524f,0.009648f,-0.012542f,-0.16524f,0.009648f,-0.033415f,-0.165568f,0.009648f,-0.022978f,-0.164257f,0.009648f,-0.002146f,-0.164257f,0.009648f,-0.04381f,-0.162623f,0.009648f,0.008167f,-0.162623f,0.009648f,-0.054123f,-0.160346f,0.009648f,-0.064313f,-0.160346f,0.009648f,0.018357f,-0.157433f,0.009648f,-0.07434f,-0.157433f,0.009648f,0.028384f,-0.153896f,0.009648f,-0.084165f,-0.153896f,0.009648f,0.038209f,-0.149749f,0.009648f,-0.093748f,-0.149749f,0.009648f,0.047792f,-0.145008f,0.009648f,-0.103051f,-0.145008f,0.009648f,0.057095f,-0.139693f,0.009648f,-0.112039f,-0.139693f,0.009648f,0.066083f,-0.133824f,0.009648f,-0.120675f,-0.133824f,0.009648f,0.074719f,-0.127424f,0.009648f,-0.128926f,-0.127424f,0.009648f,0.082969f,-0.120519f,0.009648f,-0.136758f,-0.120519f,0.009648f,0.090802f,-0.113135f,0.009648f,-0.144141f,-0.113135f,0.009648f,0.098185f,-0.105303f,0.009648f,-0.151047f,-0.105303f,0.009648f,0.105091f,-0.097052f,0.009648f,-0.157446f,-0.097052f,0.009648f,0.11149f,-0.088416f,0.009648f,-0.163316f,-0.088416f,0.009648f,0.117359f,-0.079429f,0.009648f,-0.168631f,-0.079429f,0.009648f,0.122675f,-0.070125f,0.009648f,-0.173371f,-0.070125f,0.009648f,0.127415f,-0.060542f,0.009648f,-0.177518f,-0.060542f,0.009648f,0.131562f,-0.050718f,0.009648f,-0.181055f,-0.050718f,0.009648f,0.135099f,-0.040691f,0.009648f,-0.183968f,-0.040691f,0.009648f,0.138012f,-0.0305f,0.009648f,-0.186246f,-0.0305f,0.009648f,0.14029f,-0.020187f,0.009648f,-0.18788f,-0.009792f,0.009648f,-0.188862f,-0.013579f,0.009648f,-0.024473f,-0.013344f,0.009648f,-0.025952f,-0.012957f,0.009648f,-0.027398f,-0.012421f,0.009648f,-0.028795f,-0.011741f,0.009648f,-0.030129f,-0.010926f,0.009648f,-0.031384f,-0.009984f,0.009648f,-0.032548f,-0.008925f,0.009648f,-0.033606f,6.45E-4f,0.009648f,-0.18919f,-0.007762f,0.009648f,-0.034548f,-0.006506f,0.009648f,-0.035364f,-0.005172f,0.009648f,-0.036043f,-0.003775f,0.009648f,-0.03658f,-0.002329f,0.009648f,-0.036967f,-8.5E-4f,0.009648f,-0.037201f,6.45E-4f,0.009648f,-0.03728f,0.002139f,0.009648f,-0.037201f,0.011081f,0.009648f,-0.188862f,0.003618f,0.009648f,-0.036967f,0.005064f,0.009648f,-0.03658f,0.006462f,0.009648f,-0.036043f,0.007795f,0.009648f,-0.035364f,0.009051f,0.009648f,-0.034548f,0.010214f,0.009648f,-0.033606f,0.011273f,0.009648f,-0.032548f,0.021476f,0.009648f,-0.18788f,0.012215f,0.009648f,-0.031384f,0.01303f,0.009648f,-0.030129f,0.01371f,0.009648f,-0.028795f,0.014246f,0.009648f,-0.027398f,0.014634f,0.009648f,-0.025952f,0.014868f,0.009648f,-0.024473f,0.03179f,0.009648f,0.14029f,0.03179f,0.009648f,-0.186246f,0.04198f,0.009648f,0.138012f,0.04198f,0.009648f,-0.183968f,0.052007f,0.009648f,0.135099f,0.052007f,0.009648f,-0.181055f,0.061831f,0.009648f,0.131562f,0.061831f,0.009648f,-0.177518f,0.071414f,0.009648f,0.127415f,0.071414f,0.009648f,-0.173371f,0.080718f,0.009648f,0.122675f,0.080718f,0.009648f,-0.168631f,0.089705f,0.009648f,0.117359f,0.089705f,0.009648f,-0.163316f,0.098342f,0.009648f,0.11149f,0.098342f,0.009648f,-0.157446f,0.106592f,0.009648f,0.105091f,0.106592f,0.009648f,-0.151047f,0.114425f,0.009648f,0.098185f,0.114425f,0.009648f,-0.144141f,0.121808f,0.009648f,0.090802f,0.121808f,0.009648f,-0.136758f,0.128713f,0.009648f,0.082969f,0.128713f,0.009648f,-0.128926f,0.135113f,0.009648f,0.074719f,0.135113f,0.009648f,-0.120675f,0.140982f,0.009648f,0.066083f,0.140982f,0.009648f,-0.112039f,0.146297f,0.009648f,0.057095f,0.146297f,0.009648f,-0.103051f,0.151038f,0.009648f,0.047792f,0.151038f,0.009648f,-0.093748f,0.155185f,0.009648f,0.038209f,0.155185f,0.009648f,-0.084165f,0.158722f,0.009648f,0.028384f,0.158722f,0.009648f,-0.07434f,0.161635f,0.009648f,0.018357f,0.161635f,0.009648f,-0.064313f,0.163913f,0.009648f,0.008167f,0.163913f,0.009648f,-0.054123f,0.165546f,0.009648f,-0.002146f,0.165546f,0.009648f,-0.04381f,0.166529f,0.009648f,-0.012542f,0.166529f,0.009648f,-0.033415f,0.166857f,0.009648f,-0.022978f);
    }
    private static void method17(){
        MESH_5.getTexCoords().ensureCapacity(320);
        MESH_5.getTexCoords().addAll(3.70142f,0.807557f,3.614173f,-2.937008f,3.466762f,0.785375f,3.615942f,-2.903262f,3.621228f,-2.869887f,3.629974f,-2.837246f,3.642084f,-2.805699f,3.657425f,-2.775591f,3.675829f,-2.74725f,3.697095f,-2.720989f,3.720989f,-2.697095f,3.937008f,0.814961f,3.74725f,-2.675829f,3.775591f,-2.657425f,3.805699f,-2.642084f,3.837246f,-2.629974f,3.869887f,-2.621228f,3.903262f,-2.615942f,3.937008f,-2.614173f,4.172596f,0.807557f,3.970753f,-2.615942f,4.004129f,-2.621228f,4.036769f,-2.629974f,4.068316f,-2.642084f,4.098425f,-2.657425f,4.126765f,-2.675829f,4.153027f,-2.697095f,4.176921f,-2.720989f,4.407254f,0.785375f,4.198186f,-2.74725f,4.216591f,-2.775591f,4.231932f,-2.805699f,4.244042f,-2.837246f,4.252788f,-2.869887f,4.258074f,-2.903262f,4.259842f,-2.937008f,0.192443f,-2.70142f,0.192443f,-3.172596f,0.185039f,-2.937008f,0.214625f,-2.466762f,0.214625f,-3.4072542f,0.251497f,-2.233959f,0.251497f,-3.640057f,0.302914f,-3.8700848f,0.302914f,-2.003931f,0.368674f,-4.09643f,0.368674f,-1.777586f,0.448516f,-4.3182f,0.448516f,-1.5558159f,0.542125f,-4.534518f,0.542125f,-1.3394971f,0.649133f,-4.744533f,0.649133f,-1.129483f,0.769116f,-4.947413f,0.769116f,-0.92660296f,0.901602f,-5.14236f,0.901602f,-0.73165596f,1.046066f,-5.328603f,1.046066f,-0.545413f,1.201941f,-5.505407f,1.201941f,-0.36860895f,1.368609f,-5.672075f,1.368609f,-0.20194101f,1.545413f,-5.82795f,1.545413f,-0.046066046f,1.731656f,-5.972414f,1.731656f,0.09839797f,1.926603f,-6.1049f,1.926603f,0.23088402f,2.129483f,-6.224883f,2.129483f,0.35086697f,2.339497f,-6.331891f,2.339497f,0.457875f,2.555816f,-6.4255f,2.555816f,0.551484f,2.777586f,-6.505342f,2.777586f,0.63132596f,3.003931f,-6.571101f,3.003931f,0.697086f,3.233959f,-6.622519f,3.233959f,0.74850297f,3.466762f,-6.659391f,3.70142f,-6.681573f,3.615942f,-2.970753f,3.621228f,-3.004129f,3.629974f,-3.036769f,3.642084f,-3.068316f,3.657425f,-3.098425f,3.675829f,-3.1267648f,3.697095f,-3.153026f,3.720989f,-3.176921f,3.937008f,-6.688976f,3.74725f,-3.1981869f,3.775591f,-3.216591f,3.805699f,-3.2319322f,3.837246f,-3.244042f,3.869887f,-3.252788f,3.903262f,-3.2580738f,3.937008f,-3.2598429f,3.970753f,-3.2580738f,4.172596f,-6.681573f,4.004129f,-3.252788f,4.036769f,-3.244042f,4.068316f,-3.2319322f,4.098425f,-3.216591f,4.126765f,-3.1981869f,4.153027f,-3.176921f,4.176921f,-3.153026f,4.407254f,-6.659391f,4.198186f,-3.1267648f,4.216591f,-3.098425f,4.231932f,-3.068316f,4.244042f,-3.036769f,4.252788f,-3.004129f,4.258074f,-2.970753f,4.640057f,0.74850297f,4.640057f,-6.622519f,4.870084f,0.697086f,4.870084f,-6.571101f,5.09643f,0.63132596f,5.09643f,-6.505342f,5.3182f,0.551484f,5.3182f,-6.4255f,5.534518f,0.457875f,5.534518f,-6.331891f,5.744533f,0.35086697f,5.744533f,-6.224883f,5.947413f,0.23088402f,5.947413f,-6.1049f,6.14236f,0.09839797f,6.14236f,-5.972414f,6.328603f,-0.046066046f,6.328603f,-5.82795f,6.505407f,-0.20194101f,6.505407f,-5.672075f,6.672075f,-0.36860895f,6.672075f,-5.505407f,6.82795f,-0.545413f,6.82795f,-5.328603f,6.972414f,-0.73165596f,6.972414f,-5.14236f,7.1049f,-0.92660296f,7.1049f,-4.947413f,7.224883f,-1.129483f,7.224883f,-4.744533f,7.331891f,-1.3394971f,7.331891f,-4.534518f,7.4255f,-1.5558159f,7.4255f,-4.3182f,7.505342f,-1.777586f,7.505342f,-4.09643f,7.571101f,-2.003931f,7.571101f,-3.8700848f,7.622519f,-2.233959f,7.622519f,-3.640057f,7.659391f,-2.466762f,7.659391f,-3.4072542f,7.681573f,-2.70142f,7.681573f,-3.172596f,7.688976f,-2.937008f);
    }
    private static void method18(){
        MESH_5.getFaces().ensureCapacity(960);
        MESH_5.getFaces().addAll(0,0,1,1,2,2,1,1,0,0,3,3,3,3,0,0,4,4,4,4,0,0,5,5,5,5,0,0,6,6,6,6,0,0,7,7,7,7,0,0,8,8,8,8,0,0,9,9,9,9,0,0,10,10,10,10,0,0,11,11,10,10,11,11,12,12,12,12,11,11,13,13,13,13,11,11,14,14,14,14,11,11,15,15,15,15,11,11,16,16,16,16,11,11,17,17,17,17,11,11,18,18,18,18,11,11,19,19,18,18,19,19,20,20,20,20,19,19,21,21,21,21,19,19,22,22,22,22,19,19,23,23,23,23,19,19,24,24,24,24,19,19,25,25,25,25,19,19,26,26,26,26,19,19,27,27,27,27,19,19,28,28,27,27,28,28,29,29,29,29,28,28,30,30,30,30,28,28,31,31,31,31,28,28,32,32,32,32,28,28,33,33,33,33,28,28,34,34,34,34,28,28,35,35,36,36,37,37,38,38,37,37,36,36,39,39,37,37,39,39,40,40,40,40,39,39,41,41,40,40,41,41,42,42,42,42,41,41,43,43,43,43,41,41,44,44,43,43,44,44,45,45,45,45,44,44,46,46,45,45,46,46,47,47,47,47,46,46,48,48,47,47,48,48,49,49,49,49,48,48,50,50,49,49,50,50,51,51,51,51,50,50,52,52,51,51,52,52,53,53,53,53,52,52,54,54,53,53,54,54,55,55,55,55,54,54,56,56,55,55,56,56,57,57,57,57,56,56,58,58,57,57,58,58,59,59,59,59,58,58,60,60,59,59,60,60,61,61,61,61,60,60,62,62,61,61,62,62,63,63,63,63,62,62,64,64,63,63,64,64,65,65,65,65,64,64,66,66,65,65,66,66,67,67,67,67,66,66,68,68,67,67,68,68,69,69,69,69,68,68,70,70,69,69,70,70,71,71,71,71,70,70,72,72,71,71,72,72,73,73,73,73,72,72,74,74,73,73,74,74,75,75,75,75,74,74,76,76,75,75,76,76,77,77,77,77,76,76,78,78,77,77,78,78,79,79,79,79,78,78,80,80,79,79,80,80,81,81,81,81,80,80,2,2,81,81,2,2,82,82,82,82,2,2,1,1,82,82,1,1,83,83,82,82,83,83,84,84,82,82,84,84,85,85,82,82,85,85,86,86,82,82,86,86,87,87,82,82,87,87,88,88,82,82,88,88,89,89,82,82,89,89,90,90,82,82,90,90,91,91,91,91,90,90,92,92,91,91,92,92,93,93,91,91,93,93,94,94,91,91,94,94,95,95,91,91,95,95,96,96,91,91,96,96,97,97,91,91,97,97,98,98,91,91,98,98,99,99,91,91,99,99,100,100,100,100,99,99,101,101,100,100,101,101,102,102,100,100,102,102,103,103,100,100,103,103,104,104,100,100,104,104,105,105,100,100,105,105,106,106,100,100,106,106,107,107,100,100,107,107,108,108,108,108,107,107,109,109,108,108,109,109,110,110,108,108,110,110,111,111,108,108,111,111,112,112,108,108,112,112,113,113,108,108,113,113,114,114,108,108,114,114,35,35,108,108,35,35,28,28,108,108,28,28,115,115,108,108,115,115,116,116,116,116,115,115,117,117,116,116,117,117,118,118,118,118,117,117,119,119,118,118,119,119,120,120,120,120,119,119,121,121,120,120,121,121,122,122,122,122,121,121,123,123,122,122,123,123,124,124,124,124,123,123,125,125,124,124,125,125,126,126,126,126,125,125,127,127,126,126,127,127,128,128,128,128,127,127,129,129,128,128,129,129,130,130,130,130,129,129,131,131,130,130,131,131,132,132,132,132,131,131,133,133,132,132,133,133,134,134,134,134,133,133,135,135,134,134,135,135,136,136,136,136,135,135,137,137,136,136,137,137,138,138,138,138,137,137,139,139,138,138,139,139,140,140,140,140,139,139,141,141,140,140,141,141,142,142,142,142,141,141,143,143,142,142,143,143,144,144,144,144,143,143,145,145,144,144,145,145,146,146,146,146,145,145,147,147,146,146,147,147,148,148,148,148,147,147,149,149,148,148,149,149,150,150,150,150,149,149,151,151,150,150,151,151,152,152,152,152,151,151,153,153,152,152,153,153,154,154,154,154,153,153,155,155,154,154,155,155,156,156,156,156,155,155,157,157,156,156,157,157,158,158,158,158,157,157,159,159);
    }
    private static void method19(){
        MESH_5.getFaceSmoothingGroups().ensureCapacity(160);
        MESH_5.getFaceSmoothingGroups().addAll(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
        NODE_0 = new Group(NODE_5, NODE_6);
        //NODE_0 = new Group(NODE_1, NODE_2, NODE_3, NODE_4, NODE_5, NODE_6);
    }
    private static void method20(){
    }
    static {
        method0();
        method1();
        method2();
        method3();
        method4();
        method5();
        method6();
        method7();
        method8();
        method9();
        method10();
        method11();
        method12();
        method13();
        method14();
        method15();
        method16();
        method17();
        method18();
        method19();
        method20();
        // ======== TIMELINE CODE ===============
        // ======== SET PUBLIC VARS ===============
        Map<String,MeshView> meshViewMap = new HashMap<String,MeshView>();
        for (MeshView meshView: MESHVIEWS) meshViewMap.put(meshView.getId(),meshView);
        MESHVIEW_MAP = Collections.unmodifiableMap(meshViewMap);
        ROOT = NODE_0;
    }
}
