/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.fragment.Dimension;
import com.google.android.gms.wallet.fragment.zzc;

public final class WalletFragmentStyle
implements SafeParcelable {
    public static final Parcelable.Creator<WalletFragmentStyle> CREATOR = new zzc();
    final int zzCY;
    Bundle zzaSm;
    int zzaSn;

    public WalletFragmentStyle() {
        this.zzCY = 1;
        this.zzaSm = new Bundle();
    }

    WalletFragmentStyle(int versionCode, Bundle attributes, int styleResourceId) {
        this.zzCY = versionCode;
        this.zzaSm = attributes;
        this.zzaSn = styleResourceId;
    }

    public WalletFragmentStyle setStyleResourceId(int id) {
        this.zzaSn = id;
        return this;
    }

    public WalletFragmentStyle setBuyButtonText(int buyButtonText) {
        this.zzaSm.putInt("buyButtonText", buyButtonText);
        return this;
    }

    public WalletFragmentStyle setBuyButtonHeight(int height) {
        this.zzaSm.putLong("buyButtonHeight", Dimension.zzjx(height));
        return this;
    }

    public WalletFragmentStyle setBuyButtonHeight(int unit, float height) {
        this.zzaSm.putLong("buyButtonHeight", Dimension.zza(unit, height));
        return this;
    }

    public WalletFragmentStyle setBuyButtonWidth(int width) {
        this.zzaSm.putLong("buyButtonWidth", Dimension.zzjx(width));
        return this;
    }

    public WalletFragmentStyle setBuyButtonWidth(int unit, float width) {
        this.zzaSm.putLong("buyButtonWidth", Dimension.zza(unit, width));
        return this;
    }

    public WalletFragmentStyle setBuyButtonAppearance(int buyButtonAppearance) {
        this.zzaSm.putInt("buyButtonAppearance", buyButtonAppearance);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsTextAppearance(int resourceId) {
        this.zzaSm.putInt("maskedWalletDetailsTextAppearance", resourceId);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsHeaderTextAppearance(int resourceId) {
        this.zzaSm.putInt("maskedWalletDetailsHeaderTextAppearance", resourceId);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsBackgroundColor(int color2) {
        this.zzaSm.remove("maskedWalletDetailsBackgroundResource");
        this.zzaSm.putInt("maskedWalletDetailsBackgroundColor", color2);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsBackgroundResource(int resourceId) {
        this.zzaSm.remove("maskedWalletDetailsBackgroundColor");
        this.zzaSm.putInt("maskedWalletDetailsBackgroundResource", resourceId);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsButtonTextAppearance(int resourceId) {
        this.zzaSm.putInt("maskedWalletDetailsButtonTextAppearance", resourceId);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsButtonBackgroundColor(int color2) {
        this.zzaSm.remove("maskedWalletDetailsButtonBackgroundResource");
        this.zzaSm.putInt("maskedWalletDetailsButtonBackgroundColor", color2);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsButtonBackgroundResource(int resourceId) {
        this.zzaSm.remove("maskedWalletDetailsButtonBackgroundColor");
        this.zzaSm.putInt("maskedWalletDetailsButtonBackgroundResource", resourceId);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsLogoImageType(int imageType) {
        this.zzaSm.putInt("maskedWalletDetailsLogoImageType", imageType);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsLogoTextColor(int color2) {
        this.zzaSm.putInt("maskedWalletDetailsLogoTextColor", color2);
        return this;
    }

    public int zza(String string2, DisplayMetrics displayMetrics, int n) {
        if (this.zzaSm.containsKey(string2)) {
            return Dimension.zza(this.zzaSm.getLong(string2), displayMetrics);
        }
        return n;
    }

    public void zzaL(Context context) {
        int n = this.zzaSn <= 0 ? R.style.WalletFragmentDefaultStyle : this.zzaSn;
        int[] nArray = R.styleable.WalletFragmentStyle;
        TypedArray typedArray = context.obtainStyledAttributes(n, nArray);
        this.zza(typedArray, R.styleable.WalletFragmentStyle_buyButtonWidth, "buyButtonWidth");
        this.zza(typedArray, R.styleable.WalletFragmentStyle_buyButtonHeight, "buyButtonHeight");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_buyButtonText, "buyButtonText");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_buyButtonAppearance, "buyButtonAppearance");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsTextAppearance, "maskedWalletDetailsTextAppearance");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsHeaderTextAppearance, "maskedWalletDetailsHeaderTextAppearance");
        this.zza(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsBackground, "maskedWalletDetailsBackgroundColor", "maskedWalletDetailsBackgroundResource");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsButtonTextAppearance, "maskedWalletDetailsButtonTextAppearance");
        this.zza(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsButtonBackground, "maskedWalletDetailsButtonBackgroundColor", "maskedWalletDetailsButtonBackgroundResource");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsLogoTextColor, "maskedWalletDetailsLogoTextColor");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsLogoImageType, "maskedWalletDetailsLogoImageType");
        typedArray.recycle();
    }

    private void zza(TypedArray typedArray, int n, String string2) {
        if (this.zzaSm.containsKey(string2)) {
            return;
        }
        TypedValue typedValue = typedArray.peekValue(n);
        if (typedValue != null) {
            this.zzaSm.putLong(string2, Dimension.zza(typedValue));
        }
    }

    private void zzb(TypedArray typedArray, int n, String string2) {
        if (this.zzaSm.containsKey(string2)) {
            return;
        }
        TypedValue typedValue = typedArray.peekValue(n);
        if (typedValue != null) {
            this.zzaSm.putInt(string2, typedValue.data);
        }
    }

    private void zza(TypedArray typedArray, int n, String string2, String string3) {
        if (this.zzaSm.containsKey(string2) || this.zzaSm.containsKey(string3)) {
            return;
        }
        TypedValue typedValue = typedArray.peekValue(n);
        if (typedValue != null) {
            if (typedValue.type >= 28 && typedValue.type <= 31) {
                this.zzaSm.putInt(string2, typedValue.data);
            } else {
                this.zzaSm.putInt(string3, typedValue.resourceId);
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzc.zza(this, dest, flags);
    }
}

