/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.nearby.messages.zzf;

public class Strategy
implements SafeParcelable {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzf();
    public static final Strategy zzaFQ = new zza().zzwZ();
    public static final Strategy zzaFR;
    @Deprecated
    public static final Strategy zzaFS;
    final int versionCode;
    @Deprecated
    final int zzaFT;
    final int zzaFU;
    final int zzaFV;
    @Deprecated
    final boolean zzaFW;
    final int zzaFX;
    final int zzaFY;

    Strategy(int versionCode, int broadcastScanStrategy, int ttlSeconds, int distanceType, boolean isBleBeaconStrategy, int discoveryMedium, int discoveryMode) {
        this.versionCode = versionCode;
        this.zzaFT = broadcastScanStrategy;
        if (broadcastScanStrategy == 0) {
            this.zzaFY = discoveryMode;
        } else {
            switch (broadcastScanStrategy) {
                case 2: {
                    this.zzaFY = 1;
                    break;
                }
                case 3: {
                    this.zzaFY = 2;
                    break;
                }
                default: {
                    this.zzaFY = 3;
                }
            }
        }
        this.zzaFV = distanceType;
        this.zzaFW = isBleBeaconStrategy;
        if (isBleBeaconStrategy) {
            this.zzaFX = 2;
            this.zzaFU = Integer.MAX_VALUE;
        } else if (discoveryMedium == 0) {
            this.zzaFX = 1;
            this.zzaFU = ttlSeconds;
        } else {
            this.zzaFX = discoveryMedium;
            this.zzaFU = ttlSeconds;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzf.zza(this, out, flags);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)other;
        return this.versionCode == strategy.versionCode && this.zzaFY == strategy.zzaFY && this.zzaFU == strategy.zzaFU && this.zzaFV == strategy.zzaFV && this.zzaFX == strategy.zzaFX;
    }

    public int hashCode() {
        int n = this.versionCode;
        n = 31 * n + this.zzaFY;
        n = 31 * n + this.zzaFU;
        n = 31 * n + this.zzaFV;
        n = 31 * n + this.zzaFX;
        return n;
    }

    static {
        zzaFS = zzaFR = new zza().zzie(2).zzif(Integer.MAX_VALUE).zzwZ();
    }

    public static class zza {
        private int zzaFY = 3;
        private int zzaFU = 300;
        private int zzaFV = 0;
        private int zzaFX = 1;

        public zza zzie(int n) {
            this.zzaFX = n;
            return this;
        }

        public zza zzif(int n) {
            zzu.zzb(n == Integer.MAX_VALUE || n > 0 && n <= 86400, "ttlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", n, 86400);
            this.zzaFU = n;
            return this;
        }

        public Strategy zzwZ() {
            if (this.zzaFX == 2) {
                if (this.zzaFY != 3) {
                    throw new IllegalStateException("Discovery mode must be DISCOVERY_MODE_DEFAULT.");
                }
                if (this.zzaFV == 1) {
                    throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
                }
            }
            return new Strategy(2, 0, this.zzaFU, this.zzaFV, false, this.zzaFX, this.zzaFY);
        }
    }
}

